
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   91 ( 1400),  selected   91 , name 2dgw_A
# Molecule2: number of CA atoms   71 (  558),  selected   71 , name T0487_26_96.pdb
# PARAMETERS: 2dgw_A.T0487_26_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   284_A      -       -           -
LGA    S   285_A      -       -           -
LGA    S   286_A      -       -           -
LGA    G   287_A      -       -           -
LGA    S   288_A      -       -           -
LGA    S   289_A      -       -           -
LGA    G   290_A      -       -           -
LGA    T   291_A      -       -           -
LGA    T   292_A      -       -           -
LGA    C   293_A      P      26          3.460
LGA    H   294_A      W      27          1.986
LGA    T   295_A      R      28          1.686
LGA    V   296_A      L      29          1.777
LGA    K   297_A      E      30          1.842
LGA    L   298_A      V      31          1.334
LGA    R   299_A      V      32          0.653
LGA    G   300_A      L      33          0.949
LGA    A   301_A      D      34          5.508
LGA    -       -      P      35           -
LGA    -       -      P      36           -
LGA    P   302_A      P      37          2.605
LGA    F   303_A      G      38          2.852
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    N   304_A      E      41          2.100
LGA    V   305_A      V      42          3.716
LGA    T   306_A      Y      43          2.992
LGA    E   307_A      P      44          4.815
LGA    -       -      L      45           -
LGA    -       -      L      46           -
LGA    K   308_A      A      47          3.006
LGA    N   309_A      Q      48          1.288
LGA    V   310_A      V      49          2.391
LGA    M   311_A      A      50          3.091
LGA    E   312_A      R      51          2.644
LGA    F   313_A      R      52          1.743
LGA    L   314_A      A      53          1.801
LGA    A   315_A      G      54          2.500
LGA    P   316_A      -       -           -
LGA    L   317_A      G      55          1.792
LGA    K   318_A      V      56          2.372
LGA    P   319_A      T      57          1.740
LGA    V   320_A      -       -           -
LGA    A   321_A      V      58          4.016
LGA    I   322_A      R      59          1.220
LGA    R   323_A      M      60          1.655
LGA    I   324_A      G      61          3.080
LGA    V   325_A      D      62          2.330
LGA    R   326_A      -       -           -
LGA    N   327_A      -       -           -
LGA    A   328_A      -       -           -
LGA    H   329_A      -       -           -
LGA    G   330_A      -       -           -
LGA    N   331_A      -       -           -
LGA    K   332_A      -       -           -
LGA    T   333_A      -       -           -
LGA    G   334_A      -       -           -
LGA    Y   335_A      -       -           -
LGA    I   336_A      -       -           -
LGA    F   337_A      G      63          1.863
LGA    V   338_A      L      64          1.299
LGA    D   339_A      A      65          1.318
LGA    F   340_A      S      66          1.705
LGA    S   341_A      W      67          2.038
LGA    N   342_A      S      68          3.586
LGA    E   343_A      P      69          2.408
LGA    E   344_A      -       -           -
LGA    E   345_A      -       -           -
LGA    V   346_A      P      70          2.299
LGA    K   347_A      E      71          1.662
LGA    Q   348_A      V      72          1.349
LGA    A   349_A      L      73          1.382
LGA    L   350_A      -       -           -
LGA    K   351_A      -       -           -
LGA    C   352_A      V      74          2.164
LGA    N   353_A      L      75          3.815
LGA    R   354_A      E      76          3.746
LGA    E   355_A      G      77          1.672
LGA    Y   356_A      T      78          1.644
LGA    M   357_A      L      79          1.311
LGA    G   358_A      A      80          3.336
LGA    -       -      R      81           -
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    G   359_A      T      85          2.260
LGA    R   360_A      Y      86          2.447
LGA    Y   361_A      A      87          2.523
LGA    I   362_A      Y      88          1.369
LGA    E   363_A      R      89          1.212
LGA    V   364_A      L      90          1.208
LGA    F   365_A      Y      91          1.391
LGA    R   366_A      P      92          1.014
LGA    E   367_A      K      93          0.654
LGA    K   368_A      G      94          2.854
LGA    S   369_A      -       -           -
LGA    G   370_A      R      95          2.984
LGA    P   371_A      R      96          2.833
LGA    S   372_A      -       -           -
LGA    S   373_A      -       -           -
LGA    G   374_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   91   71    5.0     61    2.44     4.92     61.217     2.401

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.967029 * X  +  -0.028544 * Y  +  -0.253061 * Z  +  62.355526
  Y_new =   0.056366 * X  +  -0.945063 * Y  +   0.321992 * Z  +  13.415599
  Z_new =  -0.248349 * X  +  -0.325640 * Y  +  -0.912295 * Z  +  55.528454 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.798743    0.342849  [ DEG:  -160.3562     19.6438 ]
  Theta =   0.250975    2.890617  [ DEG:    14.3798    165.6202 ]
  Phi   =   0.058222   -3.083370  [ DEG:     3.3359   -176.6641 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dgw_A                                        
REMARK     2: T0487_26_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dgw_A.T0487_26_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   91   71   5.0   61   2.44    4.92  61.217
REMARK  ---------------------------------------------------------- 
MOLECULE 2dgw_A
HEADER    RNA BINDING PROTEIN                     16-MAR-06   2DGW              
TITLE     SOLUTION STRUCTURE OF THE SECOND RNA RECOGNITION MOTIF IN             
TITLE    2 RNA-BINDING PROTEIN 19                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE RNA-BINDING PROTEIN 19;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RNA RECOGNITION MOTIF;                                     
COMPND   5 SYNONYM: RNA-BINDING MOTIF PROTEIN 19;                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: RBM19;                                                         
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P051121-04;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    RRM DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT             
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    C.ABE,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,M.SHIROUZU,                    
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   16-SEP-06 2DGW    0                                                
JRNL        AUTH   C.ABE,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,M.SHIROUZU,           
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE SECOND RNA RECOGNITION             
JRNL        TITL 2 MOTIF IN RNA-BINDING PROTEIN 19                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DGW A  291   368  UNP    Q9Y4C8   RBM19_HUMAN    291    368             
SEQRES   1 A   91  GLY SER SER GLY SER SER GLY THR THR CYS HIS THR VAL          
SEQRES   2 A   91  LYS LEU ARG GLY ALA PRO PHE ASN VAL THR GLU LYS ASN          
SEQRES   3 A   91  VAL MET GLU PHE LEU ALA PRO LEU LYS PRO VAL ALA ILE          
SEQRES   4 A   91  ARG ILE VAL ARG ASN ALA HIS GLY ASN LYS THR GLY TYR          
SEQRES   5 A   91  ILE PHE VAL ASP PHE SER ASN GLU GLU GLU VAL LYS GLN          
SEQRES   6 A   91  ALA LEU LYS CYS ASN ARG GLU TYR MET GLY GLY ARG TYR          
SEQRES   7 A   91  ILE GLU VAL PHE ARG GLU LYS SER GLY PRO SER SER GLY          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 284      52.558 -10.432  76.229  1.00  0.00           N  
ATOM      2  CA  GLY A 284      52.584 -11.741  76.854  1.00  0.00           C  
ATOM      3  C   GLY A 284      53.652 -12.642  76.270  1.00  0.00           C  
ATOM      4  O   GLY A 284      53.348 -13.586  75.541  1.00  0.00           O  
ATOM      5  HA2 GLY A 284      52.769 -11.619  77.912  1.00  0.00           H  
ATOM      6  HA3 GLY A 284      51.620 -12.211  76.720  1.00  0.00           H  
ATOM      7  H1  GLY A 284      53.306  -9.813  76.360  1.00  0.00           H  
ATOM      8  N   SER A 285      54.909 -12.350  76.587  1.00  0.00           N  
ATOM      9  CA  SER A 285      56.028 -13.138  76.083  1.00  0.00           C  
ATOM     10  C   SER A 285      56.085 -13.089  74.559  1.00  0.00           C  
ATOM     11  O   SER A 285      56.320 -14.103  73.902  1.00  0.00           O  
ATOM     12  CB  SER A 285      55.910 -14.589  76.554  1.00  0.00           C  
ATOM     13  OG  SER A 285      57.077 -15.326  76.230  1.00  0.00           O  
ATOM     14  H   SER A 285      55.088 -11.585  77.173  1.00  0.00           H  
ATOM     15  HA  SER A 285      56.939 -12.713  76.480  1.00  0.00           H  
ATOM     16  HB2 SER A 285      55.774 -14.607  77.625  1.00  0.00           H  
ATOM     17  HB3 SER A 285      55.061 -15.053  76.074  1.00  0.00           H  
ATOM     18  HG  SER A 285      57.334 -15.138  75.324  1.00  0.00           H  
ATOM     19  N   SER A 286      55.868 -11.901  74.004  1.00  0.00           N  
ATOM     20  CA  SER A 286      55.889 -11.718  72.558  1.00  0.00           C  
ATOM     21  C   SER A 286      57.263 -11.244  72.091  1.00  0.00           C  
ATOM     22  O   SER A 286      58.131 -10.928  72.902  1.00  0.00           O  
ATOM     23  CB  SER A 286      54.818 -10.713  72.132  1.00  0.00           C  
ATOM     24  OG  SER A 286      54.382 -10.960  70.807  1.00  0.00           O  
ATOM     25  H   SER A 286      55.686 -11.130  74.581  1.00  0.00           H  
ATOM     26  HA  SER A 286      55.677 -12.673  72.099  1.00  0.00           H  
ATOM     27  HB2 SER A 286      53.971 -10.790  72.798  1.00  0.00           H  
ATOM     28  HB3 SER A 286      55.226  -9.713  72.184  1.00  0.00           H  
ATOM     29  HG  SER A 286      54.218 -11.900  70.695  1.00  0.00           H  
ATOM     30  N   GLY A 287      57.449 -11.196  70.774  1.00  0.00           N  
ATOM     31  CA  GLY A 287      58.718 -10.759  70.221  1.00  0.00           C  
ATOM     32  C   GLY A 287      59.073 -11.489  68.941  1.00  0.00           C  
ATOM     33  O   GLY A 287      59.683 -12.557  68.976  1.00  0.00           O  
ATOM     34  H   GLY A 287      56.720 -11.460  70.175  1.00  0.00           H  
ATOM     35  HA2 GLY A 287      58.663  -9.700  70.018  1.00  0.00           H  
ATOM     36  HA3 GLY A 287      59.496 -10.935  70.950  1.00  0.00           H  
ATOM     37  N   SER A 288      58.691 -10.911  67.807  1.00  0.00           N  
ATOM     38  CA  SER A 288      58.968 -11.516  66.509  1.00  0.00           C  
ATOM     39  C   SER A 288      59.129 -10.446  65.434  1.00  0.00           C  
ATOM     40  O   SER A 288      58.176  -9.745  65.092  1.00  0.00           O  
ATOM     41  CB  SER A 288      57.845 -12.480  66.122  1.00  0.00           C  
ATOM     42  OG  SER A 288      57.890 -13.658  66.907  1.00  0.00           O  
ATOM     43  H   SER A 288      58.208 -10.059  67.843  1.00  0.00           H  
ATOM     44  HA  SER A 288      59.892 -12.068  66.592  1.00  0.00           H  
ATOM     45  HB2 SER A 288      56.892 -11.996  66.273  1.00  0.00           H  
ATOM     46  HB3 SER A 288      57.950 -12.750  65.081  1.00  0.00           H  
ATOM     47  HG  SER A 288      58.708 -14.130  66.729  1.00  0.00           H  
ATOM     48  N   SER A 289      60.343 -10.325  64.905  1.00  0.00           N  
ATOM     49  CA  SER A 289      60.631  -9.338  63.871  1.00  0.00           C  
ATOM     50  C   SER A 289      59.605  -9.414  62.745  1.00  0.00           C  
ATOM     51  O   SER A 289      59.240 -10.500  62.295  1.00  0.00           O  
ATOM     52  CB  SER A 289      62.038  -9.553  63.310  1.00  0.00           C  
ATOM     53  OG  SER A 289      62.529  -8.372  62.700  1.00  0.00           O  
ATOM     54  H   SER A 289      61.062 -10.913  65.219  1.00  0.00           H  
ATOM     55  HA  SER A 289      60.580  -8.359  64.324  1.00  0.00           H  
ATOM     56  HB2 SER A 289      62.704  -9.833  64.111  1.00  0.00           H  
ATOM     57  HB3 SER A 289      62.011 -10.341  62.571  1.00  0.00           H  
ATOM     58  HG  SER A 289      61.796  -7.870  62.335  1.00  0.00           H  
ATOM     59  N   GLY A 290      59.141  -8.252  62.296  1.00  0.00           N  
ATOM     60  CA  GLY A 290      58.161  -8.208  61.226  1.00  0.00           C  
ATOM     61  C   GLY A 290      58.144  -6.873  60.509  1.00  0.00           C  
ATOM     62  O   GLY A 290      57.740  -5.858  61.077  1.00  0.00           O  
ATOM     63  H   GLY A 290      59.468  -7.417  62.692  1.00  0.00           H  
ATOM     64  HA2 GLY A 290      58.387  -8.986  60.513  1.00  0.00           H  
ATOM     65  HA3 GLY A 290      57.182  -8.391  61.643  1.00  0.00           H  
ATOM     66  N   THR A 291      58.587  -6.871  59.256  1.00  0.00           N  
ATOM     67  CA  THR A 291      58.625  -5.650  58.461  1.00  0.00           C  
ATOM     68  C   THR A 291      57.455  -4.735  58.800  1.00  0.00           C  
ATOM     69  O   THR A 291      56.294  -5.144  58.739  1.00  0.00           O  
ATOM     70  CB  THR A 291      58.597  -5.961  56.952  1.00  0.00           C  
ATOM     71  OG1 THR A 291      59.727  -6.767  56.597  1.00  0.00           O  
ATOM     72  CG2 THR A 291      58.605  -4.679  56.134  1.00  0.00           C  
ATOM     73  H   THR A 291      58.897  -7.712  58.858  1.00  0.00           H  
ATOM     74  HA  THR A 291      59.549  -5.136  58.683  1.00  0.00           H  
ATOM     75  HB  THR A 291      57.692  -6.507  56.729  1.00  0.00           H  
ATOM     76  HG1 THR A 291      59.449  -7.681  56.497  1.00  0.00           H  
ATOM     77 HG21 THR A 291      59.594  -4.244  56.156  1.00  0.00           H  
ATOM     78 HG22 THR A 291      57.896  -3.980  56.552  1.00  0.00           H  
ATOM     79 HG23 THR A 291      58.333  -4.901  55.113  1.00  0.00           H  
ATOM     80  N   THR A 292      57.764  -3.494  59.161  1.00  0.00           N  
ATOM     81  CA  THR A 292      56.738  -2.522  59.512  1.00  0.00           C  
ATOM     82  C   THR A 292      56.503  -1.534  58.374  1.00  0.00           C  
ATOM     83  O   THR A 292      57.312  -1.433  57.451  1.00  0.00           O  
ATOM     84  CB  THR A 292      57.115  -1.740  60.785  1.00  0.00           C  
ATOM     85  OG1 THR A 292      58.310  -0.984  60.559  1.00  0.00           O  
ATOM     86  CG2 THR A 292      57.322  -2.685  61.958  1.00  0.00           C  
ATOM     87  H   THR A 292      58.707  -3.227  59.191  1.00  0.00           H  
ATOM     88  HA  THR A 292      55.821  -3.059  59.704  1.00  0.00           H  
ATOM     89  HB  THR A 292      56.309  -1.062  61.025  1.00  0.00           H  
ATOM     90  HG1 THR A 292      58.877  -1.457  59.945  1.00  0.00           H  
ATOM     91 HG21 THR A 292      58.231  -2.422  62.477  1.00  0.00           H  
ATOM     92 HG22 THR A 292      57.395  -3.700  61.595  1.00  0.00           H  
ATOM     93 HG23 THR A 292      56.485  -2.605  62.636  1.00  0.00           H  
ATOM     94  N   CYS A 293      55.394  -0.807  58.446  1.00  0.00           N  
ATOM     95  CA  CYS A 293      55.053   0.173  57.421  1.00  0.00           C  
ATOM     96  C   CYS A 293      56.032   1.342  57.441  1.00  0.00           C  
ATOM     97  O   CYS A 293      55.946   2.224  58.297  1.00  0.00           O  
ATOM     98  CB  CYS A 293      53.627   0.684  57.628  1.00  0.00           C  
ATOM     99  SG  CYS A 293      52.347  -0.435  57.012  1.00  0.00           S  
ATOM    100  H   CYS A 293      54.788  -0.933  59.207  1.00  0.00           H  
ATOM    101  HA  CYS A 293      55.116  -0.317  56.462  1.00  0.00           H  
ATOM    102  HB2 CYS A 293      53.454   0.830  58.684  1.00  0.00           H  
ATOM    103  HB3 CYS A 293      53.513   1.629  57.118  1.00  0.00           H  
ATOM    104  HG  CYS A 293      51.830   0.100  55.917  1.00  0.00           H  
ATOM    105  N   HIS A 294      56.965   1.342  56.494  1.00  0.00           N  
ATOM    106  CA  HIS A 294      57.963   2.403  56.403  1.00  0.00           C  
ATOM    107  C   HIS A 294      57.342   3.760  56.720  1.00  0.00           C  
ATOM    108  O   HIS A 294      56.285   4.110  56.194  1.00  0.00           O  
ATOM    109  CB  HIS A 294      58.586   2.428  55.007  1.00  0.00           C  
ATOM    110  CG  HIS A 294      58.866   1.064  54.452  1.00  0.00           C  
ATOM    111  ND1 HIS A 294      59.909   0.274  54.887  1.00  0.00           N  
ATOM    112  CD2 HIS A 294      58.230   0.351  53.493  1.00  0.00           C  
ATOM    113  CE1 HIS A 294      59.904  -0.864  54.218  1.00  0.00           C  
ATOM    114  NE2 HIS A 294      58.895  -0.844  53.366  1.00  0.00           N  
ATOM    115  H   HIS A 294      56.983   0.612  55.841  1.00  0.00           H  
ATOM    116  HA  HIS A 294      58.734   2.196  57.128  1.00  0.00           H  
ATOM    117  HB2 HIS A 294      57.912   2.929  54.328  1.00  0.00           H  
ATOM    118  HB3 HIS A 294      59.520   2.969  55.046  1.00  0.00           H  
ATOM    119  HD1 HIS A 294      60.557   0.514  55.581  1.00  0.00           H  
ATOM    120  HD2 HIS A 294      57.361   0.664  52.930  1.00  0.00           H  
ATOM    121  HE1 HIS A 294      60.606  -1.675  54.345  1.00  0.00           H  
ATOM    122  HE2 HIS A 294      58.714  -1.528  52.688  1.00  0.00           H  
ATOM    123  N   THR A 295      58.007   4.522  57.583  1.00  0.00           N  
ATOM    124  CA  THR A 295      57.520   5.840  57.971  1.00  0.00           C  
ATOM    125  C   THR A 295      58.665   6.842  58.071  1.00  0.00           C  
ATOM    126  O   THR A 295      59.762   6.504  58.516  1.00  0.00           O  
ATOM    127  CB  THR A 295      56.778   5.790  59.320  1.00  0.00           C  
ATOM    128  OG1 THR A 295      55.706   4.844  59.254  1.00  0.00           O  
ATOM    129  CG2 THR A 295      56.231   7.161  59.687  1.00  0.00           C  
ATOM    130  H   THR A 295      58.843   4.189  57.967  1.00  0.00           H  
ATOM    131  HA  THR A 295      56.826   6.176  57.214  1.00  0.00           H  
ATOM    132  HB  THR A 295      57.475   5.480  60.085  1.00  0.00           H  
ATOM    133  HG1 THR A 295      55.332   4.845  58.369  1.00  0.00           H  
ATOM    134 HG21 THR A 295      55.337   7.044  60.283  1.00  0.00           H  
ATOM    135 HG22 THR A 295      55.995   7.707  58.787  1.00  0.00           H  
ATOM    136 HG23 THR A 295      56.972   7.703  60.255  1.00  0.00           H  
ATOM    137  N   VAL A 296      58.403   8.076  57.654  1.00  0.00           N  
ATOM    138  CA  VAL A 296      59.412   9.129  57.698  1.00  0.00           C  
ATOM    139  C   VAL A 296      58.973  10.273  58.603  1.00  0.00           C  
ATOM    140  O   VAL A 296      57.779  10.532  58.763  1.00  0.00           O  
ATOM    141  CB  VAL A 296      59.705   9.684  56.292  1.00  0.00           C  
ATOM    142  CG1 VAL A 296      60.189   8.575  55.369  1.00  0.00           C  
ATOM    143  CG2 VAL A 296      58.471  10.364  55.720  1.00  0.00           C  
ATOM    144  H   VAL A 296      57.510   8.285  57.309  1.00  0.00           H  
ATOM    145  HA  VAL A 296      60.324   8.701  58.090  1.00  0.00           H  
ATOM    146  HB  VAL A 296      60.490  10.421  56.374  1.00  0.00           H  
ATOM    147 HG11 VAL A 296      60.980   8.023  55.856  1.00  0.00           H  
ATOM    148 HG12 VAL A 296      59.369   7.910  55.145  1.00  0.00           H  
ATOM    149 HG13 VAL A 296      60.564   9.008  54.453  1.00  0.00           H  
ATOM    150 HG21 VAL A 296      57.748   9.614  55.433  1.00  0.00           H  
ATOM    151 HG22 VAL A 296      58.038  11.013  56.467  1.00  0.00           H  
ATOM    152 HG23 VAL A 296      58.748  10.947  54.854  1.00  0.00           H  
ATOM    153  N   LYS A 297      59.944  10.958  59.196  1.00  0.00           N  
ATOM    154  CA  LYS A 297      59.660  12.078  60.086  1.00  0.00           C  
ATOM    155  C   LYS A 297      60.285  13.365  59.556  1.00  0.00           C  
ATOM    156  O   LYS A 297      61.420  13.365  59.077  1.00  0.00           O  
ATOM    157  CB  LYS A 297      60.184  11.785  61.493  1.00  0.00           C  
ATOM    158  CG  LYS A 297      59.599  12.691  62.562  1.00  0.00           C  
ATOM    159  CD  LYS A 297      59.661  12.046  63.936  1.00  0.00           C  
ATOM    160  CE  LYS A 297      61.069  12.088  64.508  1.00  0.00           C  
ATOM    161  NZ  LYS A 297      61.991  11.169  63.783  1.00  0.00           N  
ATOM    162  H   LYS A 297      60.877  10.704  59.031  1.00  0.00           H  
ATOM    163  HA  LYS A 297      58.589  12.203  60.129  1.00  0.00           H  
ATOM    164  HB2 LYS A 297      59.946  10.763  61.747  1.00  0.00           H  
ATOM    165  HB3 LYS A 297      61.259  11.906  61.496  1.00  0.00           H  
ATOM    166  HG2 LYS A 297      60.158  13.615  62.584  1.00  0.00           H  
ATOM    167  HG3 LYS A 297      58.567  12.900  62.318  1.00  0.00           H  
ATOM    168  HD2 LYS A 297      58.997  12.574  64.603  1.00  0.00           H  
ATOM    169  HD3 LYS A 297      59.346  11.014  63.854  1.00  0.00           H  
ATOM    170  HE2 LYS A 297      61.445  13.096  64.430  1.00  0.00           H  
ATOM    171  HE3 LYS A 297      61.029  11.799  65.548  1.00  0.00           H  
ATOM    172  HZ1 LYS A 297      62.722  11.717  63.286  1.00  0.00           H  
ATOM    173  HZ2 LYS A 297      61.461  10.607  63.089  1.00  0.00           H  
ATOM    174  HZ3 LYS A 297      62.454  10.524  64.455  1.00  0.00           H  
ATOM    175  N   LEU A 298      59.540  14.461  59.649  1.00  0.00           N  
ATOM    176  CA  LEU A 298      60.022  15.755  59.181  1.00  0.00           C  
ATOM    177  C   LEU A 298      59.913  16.807  60.280  1.00  0.00           C  
ATOM    178  O   LEU A 298      58.854  16.982  60.883  1.00  0.00           O  
ATOM    179  CB  LEU A 298      59.229  16.203  57.952  1.00  0.00           C  
ATOM    180  CG  LEU A 298      59.589  15.517  56.634  1.00  0.00           C  
ATOM    181  CD1 LEU A 298      58.989  14.121  56.577  1.00  0.00           C  
ATOM    182  CD2 LEU A 298      59.118  16.350  55.452  1.00  0.00           C  
ATOM    183  H   LEU A 298      58.644  14.398  60.040  1.00  0.00           H  
ATOM    184  HA  LEU A 298      61.061  15.643  58.908  1.00  0.00           H  
ATOM    185  HB2 LEU A 298      58.184  16.017  58.146  1.00  0.00           H  
ATOM    186  HB3 LEU A 298      59.386  17.266  57.826  1.00  0.00           H  
ATOM    187  HG  LEU A 298      60.665  15.419  56.569  1.00  0.00           H  
ATOM    188 HD11 LEU A 298      58.857  13.827  55.547  1.00  0.00           H  
ATOM    189 HD12 LEU A 298      58.032  14.120  57.077  1.00  0.00           H  
ATOM    190 HD13 LEU A 298      59.652  13.423  57.069  1.00  0.00           H  
ATOM    191 HD21 LEU A 298      58.311  16.996  55.765  1.00  0.00           H  
ATOM    192 HD22 LEU A 298      58.771  15.696  54.665  1.00  0.00           H  
ATOM    193 HD23 LEU A 298      59.938  16.951  55.086  1.00  0.00           H  
ATOM    194  N   ARG A 299      61.014  17.506  60.535  1.00  0.00           N  
ATOM    195  CA  ARG A 299      61.042  18.541  61.561  1.00  0.00           C  
ATOM    196  C   ARG A 299      61.676  19.821  61.025  1.00  0.00           C  
ATOM    197  O   ARG A 299      62.350  19.809  59.996  1.00  0.00           O  
ATOM    198  CB  ARG A 299      61.813  18.052  62.788  1.00  0.00           C  
ATOM    199  CG  ARG A 299      63.317  17.984  62.575  1.00  0.00           C  
ATOM    200  CD  ARG A 299      64.053  17.723  63.880  1.00  0.00           C  
ATOM    201  NE  ARG A 299      65.477  18.029  63.775  1.00  0.00           N  
ATOM    202  CZ  ARG A 299      66.349  17.810  64.753  1.00  0.00           C  
ATOM    203  NH1 ARG A 299      65.945  17.287  65.902  1.00  0.00           N  
ATOM    204  NH2 ARG A 299      67.630  18.115  64.582  1.00  0.00           N  
ATOM    205  H   ARG A 299      61.828  17.321  60.021  1.00  0.00           H  
ATOM    206  HA  ARG A 299      60.022  18.751  61.848  1.00  0.00           H  
ATOM    207  HB2 ARG A 299      61.619  18.723  63.613  1.00  0.00           H  
ATOM    208  HB3 ARG A 299      61.464  17.064  63.048  1.00  0.00           H  
ATOM    209  HG2 ARG A 299      63.538  17.184  61.884  1.00  0.00           H  
ATOM    210  HG3 ARG A 299      63.655  18.924  62.163  1.00  0.00           H  
ATOM    211  HD2 ARG A 299      63.619  18.340  64.653  1.00  0.00           H  
ATOM    212  HD3 ARG A 299      63.936  16.682  64.142  1.00  0.00           H  
ATOM    213  HE  ARG A 299      65.798  18.416  62.935  1.00  0.00           H  
ATOM    214 HH11 ARG A 299      64.982  17.056  66.033  1.00  0.00           H  
ATOM    215 HH12 ARG A 299      66.604  17.122  66.637  1.00  0.00           H  
ATOM    216 HH21 ARG A 299      67.938  18.510  63.717  1.00  0.00           H  
ATOM    217 HH22 ARG A 299      68.286  17.949  65.318  1.00  0.00           H  
ATOM    218  N   GLY A 300      61.455  20.926  61.732  1.00  0.00           N  
ATOM    219  CA  GLY A 300      62.010  22.199  61.311  1.00  0.00           C  
ATOM    220  C   GLY A 300      61.071  22.971  60.407  1.00  0.00           C  
ATOM    221  O   GLY A 300      61.512  23.758  59.569  1.00  0.00           O  
ATOM    222  H   GLY A 300      60.910  20.876  62.545  1.00  0.00           H  
ATOM    223  HA2 GLY A 300      62.221  22.794  62.187  1.00  0.00           H  
ATOM    224  HA3 GLY A 300      62.934  22.017  60.780  1.00  0.00           H  
ATOM    225  N   ALA A 301      59.772  22.746  60.575  1.00  0.00           N  
ATOM    226  CA  ALA A 301      58.768  23.427  59.768  1.00  0.00           C  
ATOM    227  C   ALA A 301      58.185  24.625  60.511  1.00  0.00           C  
ATOM    228  O   ALA A 301      58.077  24.632  61.738  1.00  0.00           O  
ATOM    229  CB  ALA A 301      57.663  22.460  59.372  1.00  0.00           C  
ATOM    230  H   ALA A 301      59.482  22.108  61.259  1.00  0.00           H  
ATOM    231  HA  ALA A 301      59.247  23.776  58.864  1.00  0.00           H  
ATOM    232  HB1 ALA A 301      57.256  22.751  58.415  1.00  0.00           H  
ATOM    233  HB2 ALA A 301      58.066  21.460  59.304  1.00  0.00           H  
ATOM    234  HB3 ALA A 301      56.882  22.483  60.118  1.00  0.00           H  
ATOM    235  N   PRO A 302      57.800  25.662  59.754  1.00  0.00           N  
ATOM    236  CA  PRO A 302      57.221  26.884  60.321  1.00  0.00           C  
ATOM    237  C   PRO A 302      55.826  26.654  60.890  1.00  0.00           C  
ATOM    238  O   PRO A 302      55.402  25.514  61.082  1.00  0.00           O  
ATOM    239  CB  PRO A 302      57.161  27.836  59.124  1.00  0.00           C  
ATOM    240  CG  PRO A 302      57.096  26.944  57.932  1.00  0.00           C  
ATOM    241  CD  PRO A 302      57.899  25.723  58.286  1.00  0.00           C  
ATOM    242  HA  PRO A 302      57.855  27.305  61.086  1.00  0.00           H  
ATOM    243  HB2 PRO A 302      56.281  28.460  59.201  1.00  0.00           H  
ATOM    244  HB3 PRO A 302      58.046  28.455  59.106  1.00  0.00           H  
ATOM    245  HG2 PRO A 302      56.070  26.674  57.732  1.00  0.00           H  
ATOM    246  HG3 PRO A 302      57.528  27.443  57.077  1.00  0.00           H  
ATOM    247  HD2 PRO A 302      57.466  24.843  57.834  1.00  0.00           H  
ATOM    248  HD3 PRO A 302      58.925  25.843  57.974  1.00  0.00           H  
ATOM    249  N   PHE A 303      55.114  27.745  61.157  1.00  0.00           N  
ATOM    250  CA  PHE A 303      53.764  27.662  61.705  1.00  0.00           C  
ATOM    251  C   PHE A 303      52.723  27.685  60.590  1.00  0.00           C  
ATOM    252  O   PHE A 303      51.554  27.373  60.813  1.00  0.00           O  
ATOM    253  CB  PHE A 303      53.514  28.818  62.676  1.00  0.00           C  
ATOM    254  CG  PHE A 303      54.477  28.852  63.828  1.00  0.00           C  
ATOM    255  CD1 PHE A 303      54.571  27.781  64.703  1.00  0.00           C  
ATOM    256  CD2 PHE A 303      55.289  29.954  64.036  1.00  0.00           C  
ATOM    257  CE1 PHE A 303      55.455  27.810  65.763  1.00  0.00           C  
ATOM    258  CE2 PHE A 303      56.177  29.990  65.096  1.00  0.00           C  
ATOM    259  CZ  PHE A 303      56.260  28.915  65.960  1.00  0.00           C  
ATOM    260  H   PHE A 303      55.506  28.627  60.982  1.00  0.00           H  
ATOM    261  HA  PHE A 303      53.682  26.729  62.240  1.00  0.00           H  
ATOM    262  HB2 PHE A 303      53.602  29.752  62.143  1.00  0.00           H  
ATOM    263  HB3 PHE A 303      52.516  28.729  63.078  1.00  0.00           H  
ATOM    264  HD1 PHE A 303      53.943  26.916  64.550  1.00  0.00           H  
ATOM    265  HD2 PHE A 303      55.225  30.796  63.360  1.00  0.00           H  
ATOM    266  HE1 PHE A 303      55.519  26.969  66.437  1.00  0.00           H  
ATOM    267  HE2 PHE A 303      56.805  30.856  65.246  1.00  0.00           H  
ATOM    268  HZ  PHE A 303      56.953  28.941  66.788  1.00  0.00           H  
ATOM    269  N   ASN A 304      53.156  28.058  59.391  1.00  0.00           N  
ATOM    270  CA  ASN A 304      52.262  28.123  58.240  1.00  0.00           C  
ATOM    271  C   ASN A 304      52.462  26.918  57.327  1.00  0.00           C  
ATOM    272  O   ASN A 304      52.223  26.993  56.121  1.00  0.00           O  
ATOM    273  CB  ASN A 304      52.498  29.416  57.457  1.00  0.00           C  
ATOM    274  CG  ASN A 304      52.464  30.644  58.345  1.00  0.00           C  
ATOM    275  OD1 ASN A 304      51.429  30.977  58.924  1.00  0.00           O  
ATOM    276  ND2 ASN A 304      53.597  31.326  58.457  1.00  0.00           N  
ATOM    277  H   ASN A 304      54.100  28.296  59.275  1.00  0.00           H  
ATOM    278  HA  ASN A 304      51.247  28.116  58.609  1.00  0.00           H  
ATOM    279  HB2 ASN A 304      53.465  29.368  56.979  1.00  0.00           H  
ATOM    280  HB3 ASN A 304      51.732  29.517  56.702  1.00  0.00           H  
ATOM    281 HD21 ASN A 304      54.383  31.003  57.966  1.00  0.00           H  
ATOM    282 HD22 ASN A 304      53.604  32.125  59.025  1.00  0.00           H  
ATOM    283  N   VAL A 305      52.901  25.807  57.910  1.00  0.00           N  
ATOM    284  CA  VAL A 305      53.132  24.584  57.149  1.00  0.00           C  
ATOM    285  C   VAL A 305      51.880  23.716  57.112  1.00  0.00           C  
ATOM    286  O   VAL A 305      51.151  23.615  58.099  1.00  0.00           O  
ATOM    287  CB  VAL A 305      54.294  23.766  57.741  1.00  0.00           C  
ATOM    288  CG1 VAL A 305      53.919  23.218  59.110  1.00  0.00           C  
ATOM    289  CG2 VAL A 305      54.688  22.640  56.797  1.00  0.00           C  
ATOM    290  H   VAL A 305      53.074  25.809  58.874  1.00  0.00           H  
ATOM    291  HA  VAL A 305      53.394  24.864  56.139  1.00  0.00           H  
ATOM    292  HB  VAL A 305      55.145  24.420  57.861  1.00  0.00           H  
ATOM    293 HG11 VAL A 305      54.808  22.864  59.612  1.00  0.00           H  
ATOM    294 HG12 VAL A 305      53.459  23.999  59.696  1.00  0.00           H  
ATOM    295 HG13 VAL A 305      53.224  22.399  58.991  1.00  0.00           H  
ATOM    296 HG21 VAL A 305      54.695  21.704  57.335  1.00  0.00           H  
ATOM    297 HG22 VAL A 305      53.975  22.583  55.986  1.00  0.00           H  
ATOM    298 HG23 VAL A 305      55.672  22.833  56.397  1.00  0.00           H  
ATOM    299  N   THR A 306      51.635  23.087  55.966  1.00  0.00           N  
ATOM    300  CA  THR A 306      50.470  22.228  55.799  1.00  0.00           C  
ATOM    301  C   THR A 306      50.824  20.969  55.015  1.00  0.00           C  
ATOM    302  O   THR A 306      51.975  20.774  54.624  1.00  0.00           O  
ATOM    303  CB  THR A 306      49.326  22.964  55.077  1.00  0.00           C  
ATOM    304  OG1 THR A 306      49.807  23.541  53.858  1.00  0.00           O  
ATOM    305  CG2 THR A 306      48.740  24.053  55.962  1.00  0.00           C  
ATOM    306  H   THR A 306      52.253  23.208  55.215  1.00  0.00           H  
ATOM    307  HA  THR A 306      50.123  21.942  56.781  1.00  0.00           H  
ATOM    308  HB  THR A 306      48.548  22.251  54.847  1.00  0.00           H  
ATOM    309  HG1 THR A 306      50.259  24.366  54.051  1.00  0.00           H  
ATOM    310 HG21 THR A 306      49.536  24.544  56.504  1.00  0.00           H  
ATOM    311 HG22 THR A 306      48.046  23.613  56.663  1.00  0.00           H  
ATOM    312 HG23 THR A 306      48.224  24.777  55.349  1.00  0.00           H  
ATOM    313  N   GLU A 307      49.827  20.120  54.787  1.00  0.00           N  
ATOM    314  CA  GLU A 307      50.036  18.880  54.048  1.00  0.00           C  
ATOM    315  C   GLU A 307      50.655  19.158  52.682  1.00  0.00           C  
ATOM    316  O   GLU A 307      51.476  18.383  52.189  1.00  0.00           O  
ATOM    317  CB  GLU A 307      48.711  18.133  53.878  1.00  0.00           C  
ATOM    318  CG  GLU A 307      48.216  17.470  55.152  1.00  0.00           C  
ATOM    319  CD  GLU A 307      46.721  17.217  55.137  1.00  0.00           C  
ATOM    320  OE1 GLU A 307      46.189  16.885  54.058  1.00  0.00           O  
ATOM    321  OE2 GLU A 307      46.086  17.352  56.202  1.00  0.00           O  
ATOM    322  H   GLU A 307      48.932  20.331  55.124  1.00  0.00           H  
ATOM    323  HA  GLU A 307      50.714  18.263  54.619  1.00  0.00           H  
ATOM    324  HB2 GLU A 307      47.958  18.832  53.544  1.00  0.00           H  
ATOM    325  HB3 GLU A 307      48.837  17.369  53.125  1.00  0.00           H  
ATOM    326  HG2 GLU A 307      48.725  16.526  55.272  1.00  0.00           H  
ATOM    327  HG3 GLU A 307      48.450  18.111  55.990  1.00  0.00           H  
ATOM    328  N   LYS A 308      50.256  20.270  52.072  1.00  0.00           N  
ATOM    329  CA  LYS A 308      50.770  20.653  50.764  1.00  0.00           C  
ATOM    330  C   LYS A 308      52.289  20.791  50.796  1.00  0.00           C  
ATOM    331  O   LYS A 308      53.000  20.103  50.064  1.00  0.00           O  
ATOM    332  CB  LYS A 308      50.136  21.969  50.309  1.00  0.00           C  
ATOM    333  CG  LYS A 308      50.089  22.132  48.799  1.00  0.00           C  
ATOM    334  CD  LYS A 308      49.674  23.539  48.403  1.00  0.00           C  
ATOM    335  CE  LYS A 308      49.806  23.757  46.904  1.00  0.00           C  
ATOM    336  NZ  LYS A 308      48.655  23.179  46.155  1.00  0.00           N  
ATOM    337  H   LYS A 308      49.599  20.847  52.515  1.00  0.00           H  
ATOM    338  HA  LYS A 308      50.506  19.875  50.062  1.00  0.00           H  
ATOM    339  HB2 LYS A 308      49.126  22.018  50.688  1.00  0.00           H  
ATOM    340  HB3 LYS A 308      50.706  22.790  50.720  1.00  0.00           H  
ATOM    341  HG2 LYS A 308      51.069  21.929  48.393  1.00  0.00           H  
ATOM    342  HG3 LYS A 308      49.377  21.428  48.393  1.00  0.00           H  
ATOM    343  HD2 LYS A 308      48.644  23.695  48.688  1.00  0.00           H  
ATOM    344  HD3 LYS A 308      50.305  24.249  48.919  1.00  0.00           H  
ATOM    345  HE2 LYS A 308      49.854  24.817  46.710  1.00  0.00           H  
ATOM    346  HE3 LYS A 308      50.717  23.289  46.563  1.00  0.00           H  
ATOM    347  HZ1 LYS A 308      48.853  22.189  45.904  1.00  0.00           H  
ATOM    348  HZ2 LYS A 308      48.489  23.719  45.282  1.00  0.00           H  
ATOM    349  HZ3 LYS A 308      47.796  23.212  46.740  1.00  0.00           H  
ATOM    350  N   ASN A 309      52.779  21.685  51.648  1.00  0.00           N  
ATOM    351  CA  ASN A 309      54.214  21.913  51.776  1.00  0.00           C  
ATOM    352  C   ASN A 309      54.970  20.590  51.860  1.00  0.00           C  
ATOM    353  O   ASN A 309      55.967  20.387  51.168  1.00  0.00           O  
ATOM    354  CB  ASN A 309      54.509  22.761  53.015  1.00  0.00           C  
ATOM    355  CG  ASN A 309      53.960  24.170  52.895  1.00  0.00           C  
ATOM    356  OD1 ASN A 309      52.914  24.490  53.459  1.00  0.00           O  
ATOM    357  ND2 ASN A 309      54.665  25.018  52.156  1.00  0.00           N  
ATOM    358  H   ASN A 309      52.162  22.204  52.205  1.00  0.00           H  
ATOM    359  HA  ASN A 309      54.544  22.447  50.898  1.00  0.00           H  
ATOM    360  HB2 ASN A 309      54.060  22.293  53.879  1.00  0.00           H  
ATOM    361  HB3 ASN A 309      55.577  22.821  53.157  1.00  0.00           H  
ATOM    362 HD21 ASN A 309      55.489  24.692  51.736  1.00  0.00           H  
ATOM    363 HD22 ASN A 309      54.333  25.935  52.062  1.00  0.00           H  
ATOM    364  N   VAL A 310      54.486  19.692  52.713  1.00  0.00           N  
ATOM    365  CA  VAL A 310      55.115  18.388  52.887  1.00  0.00           C  
ATOM    366  C   VAL A 310      55.167  17.623  51.569  1.00  0.00           C  
ATOM    367  O   VAL A 310      56.192  17.036  51.222  1.00  0.00           O  
ATOM    368  CB  VAL A 310      54.365  17.538  53.931  1.00  0.00           C  
ATOM    369  CG1 VAL A 310      55.041  16.187  54.105  1.00  0.00           C  
ATOM    370  CG2 VAL A 310      54.282  18.278  55.258  1.00  0.00           C  
ATOM    371  H   VAL A 310      53.689  19.912  53.238  1.00  0.00           H  
ATOM    372  HA  VAL A 310      56.123  18.547  53.241  1.00  0.00           H  
ATOM    373  HB  VAL A 310      53.360  17.370  53.574  1.00  0.00           H  
ATOM    374 HG11 VAL A 310      56.111  16.325  54.156  1.00  0.00           H  
ATOM    375 HG12 VAL A 310      54.692  15.725  55.018  1.00  0.00           H  
ATOM    376 HG13 VAL A 310      54.800  15.554  53.265  1.00  0.00           H  
ATOM    377 HG21 VAL A 310      55.231  18.207  55.768  1.00  0.00           H  
ATOM    378 HG22 VAL A 310      54.048  19.316  55.078  1.00  0.00           H  
ATOM    379 HG23 VAL A 310      53.511  17.836  55.870  1.00  0.00           H  
ATOM    380  N   MET A 311      54.057  17.635  50.840  1.00  0.00           N  
ATOM    381  CA  MET A 311      53.977  16.944  49.558  1.00  0.00           C  
ATOM    382  C   MET A 311      55.035  17.466  48.592  1.00  0.00           C  
ATOM    383  O   MET A 311      55.797  16.692  48.014  1.00  0.00           O  
ATOM    384  CB  MET A 311      52.584  17.113  48.949  1.00  0.00           C  
ATOM    385  CG  MET A 311      51.611  16.013  49.341  1.00  0.00           C  
ATOM    386  SD  MET A 311      51.896  14.479  48.438  1.00  0.00           S  
ATOM    387  CE  MET A 311      50.357  13.616  48.743  1.00  0.00           C  
ATOM    388  H   MET A 311      53.272  18.121  51.170  1.00  0.00           H  
ATOM    389  HA  MET A 311      54.157  15.894  49.737  1.00  0.00           H  
ATOM    390  HB2 MET A 311      52.174  18.059  49.272  1.00  0.00           H  
ATOM    391  HB3 MET A 311      52.672  17.117  47.872  1.00  0.00           H  
ATOM    392  HG2 MET A 311      51.717  15.816  50.397  1.00  0.00           H  
ATOM    393  HG3 MET A 311      50.606  16.353  49.140  1.00  0.00           H  
ATOM    394  HE1 MET A 311      50.429  13.067  49.672  1.00  0.00           H  
ATOM    395  HE2 MET A 311      49.550  14.330  48.810  1.00  0.00           H  
ATOM    396  HE3 MET A 311      50.163  12.928  47.933  1.00  0.00           H  
ATOM    397  N   GLU A 312      55.075  18.785  48.421  1.00  0.00           N  
ATOM    398  CA  GLU A 312      56.038  19.409  47.523  1.00  0.00           C  
ATOM    399  C   GLU A 312      57.466  19.181  48.013  1.00  0.00           C  
ATOM    400  O   GLU A 312      58.406  19.126  47.220  1.00  0.00           O  
ATOM    401  CB  GLU A 312      55.762  20.909  47.405  1.00  0.00           C  
ATOM    402  CG  GLU A 312      54.702  21.253  46.372  1.00  0.00           C  
ATOM    403  CD  GLU A 312      54.833  22.672  45.852  1.00  0.00           C  
ATOM    404  OE1 GLU A 312      55.955  23.060  45.464  1.00  0.00           O  
ATOM    405  OE2 GLU A 312      53.815  23.394  45.835  1.00  0.00           O  
ATOM    406  H   GLU A 312      54.440  19.350  48.910  1.00  0.00           H  
ATOM    407  HA  GLU A 312      55.929  18.955  46.550  1.00  0.00           H  
ATOM    408  HB2 GLU A 312      55.433  21.279  48.365  1.00  0.00           H  
ATOM    409  HB3 GLU A 312      56.678  21.411  47.131  1.00  0.00           H  
ATOM    410  HG2 GLU A 312      54.794  20.571  45.540  1.00  0.00           H  
ATOM    411  HG3 GLU A 312      53.728  21.139  46.823  1.00  0.00           H  
ATOM    412  N   PHE A 313      57.621  19.050  49.327  1.00  0.00           N  
ATOM    413  CA  PHE A 313      58.932  18.829  49.924  1.00  0.00           C  
ATOM    414  C   PHE A 313      59.393  17.391  49.708  1.00  0.00           C  
ATOM    415  O   PHE A 313      60.562  17.139  49.412  1.00  0.00           O  
ATOM    416  CB  PHE A 313      58.894  19.145  51.420  1.00  0.00           C  
ATOM    417  CG  PHE A 313      60.121  18.693  52.160  1.00  0.00           C  
ATOM    418  CD1 PHE A 313      60.341  17.347  52.405  1.00  0.00           C  
ATOM    419  CD2 PHE A 313      61.053  19.614  52.610  1.00  0.00           C  
ATOM    420  CE1 PHE A 313      61.468  16.928  53.086  1.00  0.00           C  
ATOM    421  CE2 PHE A 313      62.183  19.201  53.292  1.00  0.00           C  
ATOM    422  CZ  PHE A 313      62.391  17.856  53.529  1.00  0.00           C  
ATOM    423  H   PHE A 313      56.832  19.103  49.909  1.00  0.00           H  
ATOM    424  HA  PHE A 313      59.631  19.495  49.441  1.00  0.00           H  
ATOM    425  HB2 PHE A 313      58.802  20.213  51.554  1.00  0.00           H  
ATOM    426  HB3 PHE A 313      58.039  18.656  51.863  1.00  0.00           H  
ATOM    427  HD1 PHE A 313      59.621  16.621  52.058  1.00  0.00           H  
ATOM    428  HD2 PHE A 313      60.892  20.667  52.424  1.00  0.00           H  
ATOM    429  HE1 PHE A 313      61.629  15.876  53.269  1.00  0.00           H  
ATOM    430  HE2 PHE A 313      62.902  19.928  53.636  1.00  0.00           H  
ATOM    431  HZ  PHE A 313      63.272  17.531  54.061  1.00  0.00           H  
ATOM    432  N   LEU A 314      58.467  16.450  49.859  1.00  0.00           N  
ATOM    433  CA  LEU A 314      58.777  15.036  49.682  1.00  0.00           C  
ATOM    434  C   LEU A 314      58.763  14.656  48.205  1.00  0.00           C  
ATOM    435  O   LEU A 314      59.425  13.706  47.791  1.00  0.00           O  
ATOM    436  CB  LEU A 314      57.776  14.173  50.451  1.00  0.00           C  
ATOM    437  CG  LEU A 314      57.982  14.093  51.964  1.00  0.00           C  
ATOM    438  CD1 LEU A 314      56.781  13.442  52.634  1.00  0.00           C  
ATOM    439  CD2 LEU A 314      59.256  13.328  52.290  1.00  0.00           C  
ATOM    440  H   LEU A 314      57.553  16.712  50.096  1.00  0.00           H  
ATOM    441  HA  LEU A 314      59.768  14.862  50.076  1.00  0.00           H  
ATOM    442  HB2 LEU A 314      56.790  14.574  50.273  1.00  0.00           H  
ATOM    443  HB3 LEU A 314      57.832  13.169  50.056  1.00  0.00           H  
ATOM    444  HG  LEU A 314      58.081  15.095  52.361  1.00  0.00           H  
ATOM    445 HD11 LEU A 314      55.974  13.359  51.922  1.00  0.00           H  
ATOM    446 HD12 LEU A 314      56.464  14.047  53.470  1.00  0.00           H  
ATOM    447 HD13 LEU A 314      57.055  12.458  52.984  1.00  0.00           H  
ATOM    448 HD21 LEU A 314      59.616  12.834  51.400  1.00  0.00           H  
ATOM    449 HD22 LEU A 314      59.049  12.591  53.052  1.00  0.00           H  
ATOM    450 HD23 LEU A 314      60.008  14.016  52.648  1.00  0.00           H  
ATOM    451  N   ALA A 315      58.004  15.408  47.413  1.00  0.00           N  
ATOM    452  CA  ALA A 315      57.907  15.153  45.981  1.00  0.00           C  
ATOM    453  C   ALA A 315      59.285  14.930  45.369  1.00  0.00           C  
ATOM    454  O   ALA A 315      60.316  15.207  45.981  1.00  0.00           O  
ATOM    455  CB  ALA A 315      57.199  16.308  45.287  1.00  0.00           C  
ATOM    456  H   ALA A 315      57.499  16.153  47.802  1.00  0.00           H  
ATOM    457  HA  ALA A 315      57.313  14.262  45.840  1.00  0.00           H  
ATOM    458  HB1 ALA A 315      57.889  16.802  44.619  1.00  0.00           H  
ATOM    459  HB2 ALA A 315      56.361  15.928  44.723  1.00  0.00           H  
ATOM    460  HB3 ALA A 315      56.847  17.011  46.026  1.00  0.00           H  
ATOM    461  N   PRO A 316      59.307  14.415  44.130  1.00  0.00           N  
ATOM    462  CA  PRO A 316      58.086  14.079  43.391  1.00  0.00           C  
ATOM    463  C   PRO A 316      57.360  12.877  43.985  1.00  0.00           C  
ATOM    464  O   PRO A 316      56.282  12.500  43.524  1.00  0.00           O  
ATOM    465  CB  PRO A 316      58.599  13.755  41.987  1.00  0.00           C  
ATOM    466  CG  PRO A 316      60.011  13.322  42.190  1.00  0.00           C  
ATOM    467  CD  PRO A 316      60.523  14.119  43.356  1.00  0.00           C  
ATOM    468  HA  PRO A 316      57.407  14.919  43.343  1.00  0.00           H  
ATOM    469  HB2 PRO A 316      58.001  12.964  41.556  1.00  0.00           H  
ATOM    470  HB3 PRO A 316      58.543  14.637  41.365  1.00  0.00           H  
ATOM    471  HG2 PRO A 316      60.043  12.267  42.414  1.00  0.00           H  
ATOM    472  HG3 PRO A 316      60.591  13.537  41.305  1.00  0.00           H  
ATOM    473  HD2 PRO A 316      61.218  13.533  43.938  1.00  0.00           H  
ATOM    474  HD3 PRO A 316      60.993  15.031  43.014  1.00  0.00           H  
ATOM    475  N   LEU A 317      57.959  12.277  45.008  1.00  0.00           N  
ATOM    476  CA  LEU A 317      57.369  11.116  45.665  1.00  0.00           C  
ATOM    477  C   LEU A 317      55.935  11.405  46.099  1.00  0.00           C  
ATOM    478  O   LEU A 317      55.555  12.560  46.295  1.00  0.00           O  
ATOM    479  CB  LEU A 317      58.209  10.710  46.878  1.00  0.00           C  
ATOM    480  CG  LEU A 317      59.669  10.353  46.594  1.00  0.00           C  
ATOM    481  CD1 LEU A 317      60.499  10.451  47.863  1.00  0.00           C  
ATOM    482  CD2 LEU A 317      59.768   8.957  45.995  1.00  0.00           C  
ATOM    483  H   LEU A 317      58.817  12.622  45.330  1.00  0.00           H  
ATOM    484  HA  LEU A 317      57.360  10.302  44.955  1.00  0.00           H  
ATOM    485  HB2 LEU A 317      58.200  11.533  47.575  1.00  0.00           H  
ATOM    486  HB3 LEU A 317      57.739   9.850  47.332  1.00  0.00           H  
ATOM    487  HG  LEU A 317      60.071  11.054  45.877  1.00  0.00           H  
ATOM    488 HD11 LEU A 317      59.903  10.140  48.708  1.00  0.00           H  
ATOM    489 HD12 LEU A 317      60.820  11.472  48.006  1.00  0.00           H  
ATOM    490 HD13 LEU A 317      61.365   9.811  47.778  1.00  0.00           H  
ATOM    491 HD21 LEU A 317      58.925   8.364  46.320  1.00  0.00           H  
ATOM    492 HD22 LEU A 317      60.685   8.489  46.324  1.00  0.00           H  
ATOM    493 HD23 LEU A 317      59.766   9.026  44.918  1.00  0.00           H  
ATOM    494  N   LYS A 318      55.144  10.348  46.250  1.00  0.00           N  
ATOM    495  CA  LYS A 318      53.752  10.487  46.664  1.00  0.00           C  
ATOM    496  C   LYS A 318      53.430   9.537  47.813  1.00  0.00           C  
ATOM    497  O   LYS A 318      53.238   8.336  47.622  1.00  0.00           O  
ATOM    498  CB  LYS A 318      52.818  10.214  45.484  1.00  0.00           C  
ATOM    499  CG  LYS A 318      51.411  10.747  45.687  1.00  0.00           C  
ATOM    500  CD  LYS A 318      50.695  10.951  44.361  1.00  0.00           C  
ATOM    501  CE  LYS A 318      49.677  12.078  44.445  1.00  0.00           C  
ATOM    502  NZ  LYS A 318      50.279  13.396  44.098  1.00  0.00           N  
ATOM    503  H   LYS A 318      55.505   9.453  46.078  1.00  0.00           H  
ATOM    504  HA  LYS A 318      53.607  11.502  47.000  1.00  0.00           H  
ATOM    505  HB2 LYS A 318      53.231  10.675  44.598  1.00  0.00           H  
ATOM    506  HB3 LYS A 318      52.756   9.147  45.328  1.00  0.00           H  
ATOM    507  HG2 LYS A 318      50.850  10.042  46.282  1.00  0.00           H  
ATOM    508  HG3 LYS A 318      51.465  11.694  46.205  1.00  0.00           H  
ATOM    509  HD2 LYS A 318      51.424  11.194  43.603  1.00  0.00           H  
ATOM    510  HD3 LYS A 318      50.185  10.036  44.093  1.00  0.00           H  
ATOM    511  HE2 LYS A 318      48.870  11.869  43.760  1.00  0.00           H  
ATOM    512  HE3 LYS A 318      49.291  12.124  45.453  1.00  0.00           H  
ATOM    513  HZ1 LYS A 318      50.832  13.758  44.900  1.00  0.00           H  
ATOM    514  HZ2 LYS A 318      49.530  14.080  43.868  1.00  0.00           H  
ATOM    515  HZ3 LYS A 318      50.907  13.295  43.274  1.00  0.00           H  
ATOM    516  N   PRO A 319      53.367  10.085  49.035  1.00  0.00           N  
ATOM    517  CA  PRO A 319      53.066   9.304  50.238  1.00  0.00           C  
ATOM    518  C   PRO A 319      51.619   8.826  50.272  1.00  0.00           C  
ATOM    519  O   PRO A 319      50.846   9.087  49.349  1.00  0.00           O  
ATOM    520  CB  PRO A 319      53.329  10.291  51.378  1.00  0.00           C  
ATOM    521  CG  PRO A 319      53.135  11.636  50.767  1.00  0.00           C  
ATOM    522  CD  PRO A 319      53.586  11.509  49.337  1.00  0.00           C  
ATOM    523  HA  PRO A 319      53.726   8.454  50.336  1.00  0.00           H  
ATOM    524  HB2 PRO A 319      52.626  10.116  52.179  1.00  0.00           H  
ATOM    525  HB3 PRO A 319      54.338  10.166  51.743  1.00  0.00           H  
ATOM    526  HG2 PRO A 319      52.093  11.911  50.808  1.00  0.00           H  
ATOM    527  HG3 PRO A 319      53.739  12.365  51.286  1.00  0.00           H  
ATOM    528  HD2 PRO A 319      52.985  12.136  48.695  1.00  0.00           H  
ATOM    529  HD3 PRO A 319      54.631  11.766  49.247  1.00  0.00           H  
ATOM    530  N   VAL A 320      51.256   8.124  51.341  1.00  0.00           N  
ATOM    531  CA  VAL A 320      49.900   7.611  51.495  1.00  0.00           C  
ATOM    532  C   VAL A 320      49.083   8.491  52.432  1.00  0.00           C  
ATOM    533  O   VAL A 320      47.899   8.735  52.198  1.00  0.00           O  
ATOM    534  CB  VAL A 320      49.904   6.168  52.036  1.00  0.00           C  
ATOM    535  CG1 VAL A 320      48.500   5.583  52.005  1.00  0.00           C  
ATOM    536  CG2 VAL A 320      50.869   5.304  51.238  1.00  0.00           C  
ATOM    537  H   VAL A 320      51.916   7.948  52.043  1.00  0.00           H  
ATOM    538  HA  VAL A 320      49.432   7.607  50.521  1.00  0.00           H  
ATOM    539  HB  VAL A 320      50.238   6.192  53.063  1.00  0.00           H  
ATOM    540 HG11 VAL A 320      48.556   4.528  51.781  1.00  0.00           H  
ATOM    541 HG12 VAL A 320      48.029   5.724  52.967  1.00  0.00           H  
ATOM    542 HG13 VAL A 320      47.919   6.081  51.242  1.00  0.00           H  
ATOM    543 HG21 VAL A 320      50.370   4.397  50.934  1.00  0.00           H  
ATOM    544 HG22 VAL A 320      51.199   5.844  50.363  1.00  0.00           H  
ATOM    545 HG23 VAL A 320      51.722   5.057  51.852  1.00  0.00           H  
ATOM    546  N   ALA A 321      49.722   8.968  53.496  1.00  0.00           N  
ATOM    547  CA  ALA A 321      49.054   9.824  54.469  1.00  0.00           C  
ATOM    548  C   ALA A 321      50.061  10.688  55.221  1.00  0.00           C  
ATOM    549  O   ALA A 321      51.060  10.187  55.738  1.00  0.00           O  
ATOM    550  CB  ALA A 321      48.244   8.983  55.445  1.00  0.00           C  
ATOM    551  H   ALA A 321      50.665   8.738  53.629  1.00  0.00           H  
ATOM    552  HA  ALA A 321      48.371  10.467  53.933  1.00  0.00           H  
ATOM    553  HB1 ALA A 321      48.911   8.350  56.012  1.00  0.00           H  
ATOM    554  HB2 ALA A 321      47.704   9.632  56.117  1.00  0.00           H  
ATOM    555  HB3 ALA A 321      47.546   8.369  54.896  1.00  0.00           H  
ATOM    556  N   ILE A 322      49.791  11.987  55.278  1.00  0.00           N  
ATOM    557  CA  ILE A 322      50.673  12.921  55.968  1.00  0.00           C  
ATOM    558  C   ILE A 322      50.071  13.368  57.295  1.00  0.00           C  
ATOM    559  O   ILE A 322      49.211  14.249  57.332  1.00  0.00           O  
ATOM    560  CB  ILE A 322      50.966  14.162  55.105  1.00  0.00           C  
ATOM    561  CG1 ILE A 322      51.620  13.749  53.785  1.00  0.00           C  
ATOM    562  CG2 ILE A 322      51.856  15.136  55.862  1.00  0.00           C  
ATOM    563  CD1 ILE A 322      51.528  14.808  52.709  1.00  0.00           C  
ATOM    564  H   ILE A 322      48.979  12.327  54.848  1.00  0.00           H  
ATOM    565  HA  ILE A 322      51.608  12.414  56.162  1.00  0.00           H  
ATOM    566  HB  ILE A 322      50.029  14.656  54.896  1.00  0.00           H  
ATOM    567 HG12 ILE A 322      52.664  13.542  53.957  1.00  0.00           H  
ATOM    568 HG13 ILE A 322      51.135  12.857  53.416  1.00  0.00           H  
ATOM    569 HG21 ILE A 322      52.752  15.325  55.288  1.00  0.00           H  
ATOM    570 HG22 ILE A 322      51.325  16.063  56.015  1.00  0.00           H  
ATOM    571 HG23 ILE A 322      52.124  14.711  56.818  1.00  0.00           H  
ATOM    572 HD11 ILE A 322      50.842  15.583  53.021  1.00  0.00           H  
ATOM    573 HD12 ILE A 322      52.504  15.237  52.540  1.00  0.00           H  
ATOM    574 HD13 ILE A 322      51.170  14.360  51.793  1.00  0.00           H  
ATOM    575  N   ARG A 323      50.529  12.758  58.383  1.00  0.00           N  
ATOM    576  CA  ARG A 323      50.035  13.094  59.713  1.00  0.00           C  
ATOM    577  C   ARG A 323      50.927  14.139  60.376  1.00  0.00           C  
ATOM    578  O   ARG A 323      52.114  13.902  60.603  1.00  0.00           O  
ATOM    579  CB  ARG A 323      49.965  11.840  60.586  1.00  0.00           C  
ATOM    580  CG  ARG A 323      48.635  11.108  60.497  1.00  0.00           C  
ATOM    581  CD  ARG A 323      48.452  10.143  61.657  1.00  0.00           C  
ATOM    582  NE  ARG A 323      48.150  10.837  62.906  1.00  0.00           N  
ATOM    583  CZ  ARG A 323      47.022  11.506  63.122  1.00  0.00           C  
ATOM    584  NH1 ARG A 323      46.095  11.570  62.176  1.00  0.00           N  
ATOM    585  NH2 ARG A 323      46.821  12.112  64.284  1.00  0.00           N  
ATOM    586  H   ARG A 323      51.214  12.063  58.290  1.00  0.00           H  
ATOM    587  HA  ARG A 323      49.041  13.502  59.605  1.00  0.00           H  
ATOM    588  HB2 ARG A 323      50.745  11.159  60.282  1.00  0.00           H  
ATOM    589  HB3 ARG A 323      50.127  12.123  61.616  1.00  0.00           H  
ATOM    590  HG2 ARG A 323      47.835  11.834  60.517  1.00  0.00           H  
ATOM    591  HG3 ARG A 323      48.601  10.556  59.570  1.00  0.00           H  
ATOM    592  HD2 ARG A 323      47.638   9.472  61.424  1.00  0.00           H  
ATOM    593  HD3 ARG A 323      49.362   9.575  61.783  1.00  0.00           H  
ATOM    594  HE  ARG A 323      48.822  10.803  63.617  1.00  0.00           H  
ATOM    595 HH11 ARG A 323      46.243  11.113  61.299  1.00  0.00           H  
ATOM    596 HH12 ARG A 323      45.246  12.073  62.341  1.00  0.00           H  
ATOM    597 HH21 ARG A 323      47.518  12.067  64.999  1.00  0.00           H  
ATOM    598 HH22 ARG A 323      45.973  12.616  64.445  1.00  0.00           H  
ATOM    599  N   ILE A 324      50.348  15.295  60.682  1.00  0.00           N  
ATOM    600  CA  ILE A 324      51.090  16.376  61.319  1.00  0.00           C  
ATOM    601  C   ILE A 324      51.082  16.229  62.837  1.00  0.00           C  
ATOM    602  O   ILE A 324      50.022  16.149  63.458  1.00  0.00           O  
ATOM    603  CB  ILE A 324      50.512  17.753  60.945  1.00  0.00           C  
ATOM    604  CG1 ILE A 324      50.546  17.950  59.428  1.00  0.00           C  
ATOM    605  CG2 ILE A 324      51.285  18.861  61.646  1.00  0.00           C  
ATOM    606  CD1 ILE A 324      49.605  19.027  58.938  1.00  0.00           C  
ATOM    607  H   ILE A 324      49.399  15.423  60.477  1.00  0.00           H  
ATOM    608  HA  ILE A 324      52.112  16.329  60.970  1.00  0.00           H  
ATOM    609  HB  ILE A 324      49.488  17.792  61.284  1.00  0.00           H  
ATOM    610 HG12 ILE A 324      51.545  18.222  59.129  1.00  0.00           H  
ATOM    611 HG13 ILE A 324      50.270  17.022  58.947  1.00  0.00           H  
ATOM    612 HG21 ILE A 324      52.168  19.101  61.073  1.00  0.00           H  
ATOM    613 HG22 ILE A 324      50.661  19.737  61.729  1.00  0.00           H  
ATOM    614 HG23 ILE A 324      51.576  18.529  62.632  1.00  0.00           H  
ATOM    615 HD11 ILE A 324      49.540  18.986  57.861  1.00  0.00           H  
ATOM    616 HD12 ILE A 324      48.625  18.873  59.365  1.00  0.00           H  
ATOM    617 HD13 ILE A 324      49.979  19.996  59.238  1.00  0.00           H  
ATOM    618  N   VAL A 325      52.272  16.195  63.430  1.00  0.00           N  
ATOM    619  CA  VAL A 325      52.402  16.061  64.876  1.00  0.00           C  
ATOM    620  C   VAL A 325      51.826  17.276  65.595  1.00  0.00           C  
ATOM    621  O   VAL A 325      52.395  18.367  65.546  1.00  0.00           O  
ATOM    622  CB  VAL A 325      53.874  15.882  65.292  1.00  0.00           C  
ATOM    623  CG1 VAL A 325      53.984  15.691  66.798  1.00  0.00           C  
ATOM    624  CG2 VAL A 325      54.498  14.710  64.551  1.00  0.00           C  
ATOM    625  H   VAL A 325      53.080  16.264  62.882  1.00  0.00           H  
ATOM    626  HA  VAL A 325      51.854  15.181  65.180  1.00  0.00           H  
ATOM    627  HB  VAL A 325      54.414  16.778  65.026  1.00  0.00           H  
ATOM    628 HG11 VAL A 325      53.205  16.255  67.290  1.00  0.00           H  
ATOM    629 HG12 VAL A 325      53.877  14.643  67.036  1.00  0.00           H  
ATOM    630 HG13 VAL A 325      54.948  16.041  67.135  1.00  0.00           H  
ATOM    631 HG21 VAL A 325      55.035  15.075  63.689  1.00  0.00           H  
ATOM    632 HG22 VAL A 325      55.182  14.190  65.207  1.00  0.00           H  
ATOM    633 HG23 VAL A 325      53.721  14.031  64.231  1.00  0.00           H  
ATOM    634  N   ARG A 326      50.694  17.080  66.263  1.00  0.00           N  
ATOM    635  CA  ARG A 326      50.040  18.160  66.992  1.00  0.00           C  
ATOM    636  C   ARG A 326      50.352  18.077  68.483  1.00  0.00           C  
ATOM    637  O   ARG A 326      49.795  17.246  69.198  1.00  0.00           O  
ATOM    638  CB  ARG A 326      48.527  18.108  66.773  1.00  0.00           C  
ATOM    639  CG  ARG A 326      48.109  18.375  65.337  1.00  0.00           C  
ATOM    640  CD  ARG A 326      48.008  19.865  65.053  1.00  0.00           C  
ATOM    641  NE  ARG A 326      47.760  20.138  63.640  1.00  0.00           N  
ATOM    642  CZ  ARG A 326      47.477  21.346  63.164  1.00  0.00           C  
ATOM    643  NH1 ARG A 326      47.409  22.386  63.983  1.00  0.00           N  
ATOM    644  NH2 ARG A 326      47.263  21.514  61.865  1.00  0.00           N  
ATOM    645  H   ARG A 326      50.288  16.187  66.264  1.00  0.00           H  
ATOM    646  HA  ARG A 326      50.418  19.095  66.608  1.00  0.00           H  
ATOM    647  HB2 ARG A 326      48.168  17.129  67.053  1.00  0.00           H  
ATOM    648  HB3 ARG A 326      48.059  18.848  67.405  1.00  0.00           H  
ATOM    649  HG2 ARG A 326      48.843  17.941  64.672  1.00  0.00           H  
ATOM    650  HG3 ARG A 326      47.146  17.917  65.161  1.00  0.00           H  
ATOM    651  HD2 ARG A 326      47.198  20.275  65.638  1.00  0.00           H  
ATOM    652  HD3 ARG A 326      48.936  20.337  65.344  1.00  0.00           H  
ATOM    653  HE  ARG A 326      47.805  19.383  63.017  1.00  0.00           H  
ATOM    654 HH11 ARG A 326      47.570  22.262  64.962  1.00  0.00           H  
ATOM    655 HH12 ARG A 326      47.197  23.294  63.621  1.00  0.00           H  
ATOM    656 HH21 ARG A 326      47.315  20.732  61.244  1.00  0.00           H  
ATOM    657 HH22 ARG A 326      47.051  22.422  61.507  1.00  0.00           H  
ATOM    658  N   ASN A 327      51.249  18.943  68.943  1.00  0.00           N  
ATOM    659  CA  ASN A 327      51.637  18.967  70.349  1.00  0.00           C  
ATOM    660  C   ASN A 327      50.408  18.931  71.253  1.00  0.00           C  
ATOM    661  O   ASN A 327      49.275  19.011  70.781  1.00  0.00           O  
ATOM    662  CB  ASN A 327      52.468  20.215  70.649  1.00  0.00           C  
ATOM    663  CG  ASN A 327      51.608  21.413  71.000  1.00  0.00           C  
ATOM    664  OD1 ASN A 327      50.428  21.466  70.655  1.00  0.00           O  
ATOM    665  ND2 ASN A 327      52.197  22.384  71.689  1.00  0.00           N  
ATOM    666  H   ASN A 327      51.659  19.582  68.324  1.00  0.00           H  
ATOM    667  HA  ASN A 327      52.237  18.090  70.542  1.00  0.00           H  
ATOM    668  HB2 ASN A 327      53.125  20.012  71.484  1.00  0.00           H  
ATOM    669  HB3 ASN A 327      53.063  20.462  69.782  1.00  0.00           H  
ATOM    670 HD21 ASN A 327      53.141  22.273  71.930  1.00  0.00           H  
ATOM    671 HD22 ASN A 327      51.664  23.170  71.930  1.00  0.00           H  
ATOM    672  N   ALA A 328      50.643  18.813  72.556  1.00  0.00           N  
ATOM    673  CA  ALA A 328      49.556  18.770  73.527  1.00  0.00           C  
ATOM    674  C   ALA A 328      48.547  19.884  73.272  1.00  0.00           C  
ATOM    675  O   ALA A 328      47.356  19.628  73.090  1.00  0.00           O  
ATOM    676  CB  ALA A 328      50.108  18.868  74.941  1.00  0.00           C  
ATOM    677  H   ALA A 328      51.568  18.754  72.872  1.00  0.00           H  
ATOM    678  HA  ALA A 328      49.057  17.816  73.428  1.00  0.00           H  
ATOM    679  HB1 ALA A 328      51.162  19.102  74.900  1.00  0.00           H  
ATOM    680  HB2 ALA A 328      49.586  19.647  75.477  1.00  0.00           H  
ATOM    681  HB3 ALA A 328      49.967  17.926  75.449  1.00  0.00           H  
ATOM    682  N   HIS A 329      49.030  21.123  73.259  1.00  0.00           N  
ATOM    683  CA  HIS A 329      48.170  22.277  73.026  1.00  0.00           C  
ATOM    684  C   HIS A 329      48.009  22.541  71.532  1.00  0.00           C  
ATOM    685  O   HIS A 329      47.972  23.691  71.095  1.00  0.00           O  
ATOM    686  CB  HIS A 329      48.744  23.515  73.716  1.00  0.00           C  
ATOM    687  CG  HIS A 329      49.248  23.250  75.101  1.00  0.00           C  
ATOM    688  ND1 HIS A 329      50.550  23.490  75.487  1.00  0.00           N  
ATOM    689  CD2 HIS A 329      48.615  22.765  76.196  1.00  0.00           C  
ATOM    690  CE1 HIS A 329      50.697  23.161  76.759  1.00  0.00           C  
ATOM    691  NE2 HIS A 329      49.537  22.720  77.212  1.00  0.00           N  
ATOM    692  H   HIS A 329      49.988  21.263  73.410  1.00  0.00           H  
ATOM    693  HA  HIS A 329      47.201  22.059  73.447  1.00  0.00           H  
ATOM    694  HB2 HIS A 329      49.569  23.895  73.131  1.00  0.00           H  
ATOM    695  HB3 HIS A 329      47.976  24.272  73.780  1.00  0.00           H  
ATOM    696  HD1 HIS A 329      51.260  23.844  74.914  1.00  0.00           H  
ATOM    697  HD2 HIS A 329      47.578  22.468  76.258  1.00  0.00           H  
ATOM    698  HE1 HIS A 329      51.609  23.240  77.331  1.00  0.00           H  
ATOM    699  HE2 HIS A 329      49.390  22.331  78.099  1.00  0.00           H  
ATOM    700  N   GLY A 330      47.912  21.467  70.754  1.00  0.00           N  
ATOM    701  CA  GLY A 330      47.756  21.605  69.317  1.00  0.00           C  
ATOM    702  C   GLY A 330      48.692  22.642  68.729  1.00  0.00           C  
ATOM    703  O   GLY A 330      48.333  23.812  68.603  1.00  0.00           O  
ATOM    704  H   GLY A 330      47.946  20.576  71.158  1.00  0.00           H  
ATOM    705  HA2 GLY A 330      47.954  20.651  68.851  1.00  0.00           H  
ATOM    706  HA3 GLY A 330      46.738  21.895  69.103  1.00  0.00           H  
ATOM    707  N   ASN A 331      49.898  22.212  68.369  1.00  0.00           N  
ATOM    708  CA  ASN A 331      50.889  23.113  67.792  1.00  0.00           C  
ATOM    709  C   ASN A 331      51.930  22.336  66.993  1.00  0.00           C  
ATOM    710  O   ASN A 331      52.460  21.327  67.458  1.00  0.00           O  
ATOM    711  CB  ASN A 331      51.576  23.922  68.896  1.00  0.00           C  
ATOM    712  CG  ASN A 331      52.336  25.114  68.349  1.00  0.00           C  
ATOM    713  OD1 ASN A 331      52.978  25.029  67.302  1.00  0.00           O  
ATOM    714  ND2 ASN A 331      52.268  26.235  69.059  1.00  0.00           N  
ATOM    715  H   ASN A 331      50.126  21.267  68.494  1.00  0.00           H  
ATOM    716  HA  ASN A 331      50.375  23.791  67.129  1.00  0.00           H  
ATOM    717  HB2 ASN A 331      50.829  24.282  69.588  1.00  0.00           H  
ATOM    718  HB3 ASN A 331      52.270  23.284  69.422  1.00  0.00           H  
ATOM    719 HD21 ASN A 331      51.738  26.230  69.883  1.00  0.00           H  
ATOM    720 HD22 ASN A 331      52.749  27.022  68.728  1.00  0.00           H  
ATOM    721  N   LYS A 332      52.220  22.814  65.787  1.00  0.00           N  
ATOM    722  CA  LYS A 332      53.200  22.166  64.923  1.00  0.00           C  
ATOM    723  C   LYS A 332      54.620  22.454  65.398  1.00  0.00           C  
ATOM    724  O   LYS A 332      55.204  23.484  65.057  1.00  0.00           O  
ATOM    725  CB  LYS A 332      53.027  22.641  63.478  1.00  0.00           C  
ATOM    726  CG  LYS A 332      51.667  22.311  62.887  1.00  0.00           C  
ATOM    727  CD  LYS A 332      51.263  23.317  61.823  1.00  0.00           C  
ATOM    728  CE  LYS A 332      49.751  23.385  61.667  1.00  0.00           C  
ATOM    729  NZ  LYS A 332      49.301  24.731  61.218  1.00  0.00           N  
ATOM    730  H   LYS A 332      51.765  23.623  65.472  1.00  0.00           H  
ATOM    731  HA  LYS A 332      53.027  21.101  64.965  1.00  0.00           H  
ATOM    732  HB2 LYS A 332      53.160  23.713  63.445  1.00  0.00           H  
ATOM    733  HB3 LYS A 332      53.786  22.174  62.866  1.00  0.00           H  
ATOM    734  HG2 LYS A 332      51.708  21.328  62.441  1.00  0.00           H  
ATOM    735  HG3 LYS A 332      50.931  22.319  63.677  1.00  0.00           H  
ATOM    736  HD2 LYS A 332      51.629  24.293  62.104  1.00  0.00           H  
ATOM    737  HD3 LYS A 332      51.701  23.024  60.879  1.00  0.00           H  
ATOM    738  HE2 LYS A 332      49.445  22.651  60.938  1.00  0.00           H  
ATOM    739  HE3 LYS A 332      49.294  23.160  62.618  1.00  0.00           H  
ATOM    740  HZ1 LYS A 332      48.424  24.649  60.665  1.00  0.00           H  
ATOM    741  HZ2 LYS A 332      50.031  25.173  60.623  1.00  0.00           H  
ATOM    742  HZ3 LYS A 332      49.123  25.342  62.040  1.00  0.00           H  
ATOM    743  N   THR A 333      55.173  21.538  66.187  1.00  0.00           N  
ATOM    744  CA  THR A 333      56.524  21.694  66.708  1.00  0.00           C  
ATOM    745  C   THR A 333      57.529  20.908  65.874  1.00  0.00           C  
ATOM    746  O   THR A 333      58.022  19.864  66.298  1.00  0.00           O  
ATOM    747  CB  THR A 333      56.619  21.231  68.175  1.00  0.00           C  
ATOM    748  OG1 THR A 333      57.941  21.452  68.675  1.00  0.00           O  
ATOM    749  CG2 THR A 333      56.263  19.756  68.300  1.00  0.00           C  
ATOM    750  H   THR A 333      54.657  20.739  66.423  1.00  0.00           H  
ATOM    751  HA  THR A 333      56.779  22.743  66.668  1.00  0.00           H  
ATOM    752  HB  THR A 333      55.917  21.806  68.763  1.00  0.00           H  
ATOM    753  HG1 THR A 333      58.573  21.369  67.957  1.00  0.00           H  
ATOM    754 HG21 THR A 333      56.127  19.334  67.315  1.00  0.00           H  
ATOM    755 HG22 THR A 333      55.349  19.653  68.867  1.00  0.00           H  
ATOM    756 HG23 THR A 333      57.062  19.236  68.806  1.00  0.00           H  
ATOM    757  N   GLY A 334      57.832  21.419  64.684  1.00  0.00           N  
ATOM    758  CA  GLY A 334      58.778  20.752  63.809  1.00  0.00           C  
ATOM    759  C   GLY A 334      58.681  19.241  63.894  1.00  0.00           C  
ATOM    760  O   GLY A 334      59.577  18.584  64.424  1.00  0.00           O  
ATOM    761  H   GLY A 334      57.409  22.255  64.397  1.00  0.00           H  
ATOM    762  HA2 GLY A 334      58.587  21.058  62.791  1.00  0.00           H  
ATOM    763  HA3 GLY A 334      59.779  21.053  64.083  1.00  0.00           H  
ATOM    764  N   TYR A 335      57.591  18.690  63.372  1.00  0.00           N  
ATOM    765  CA  TYR A 335      57.378  17.248  63.396  1.00  0.00           C  
ATOM    766  C   TYR A 335      56.186  16.859  62.526  1.00  0.00           C  
ATOM    767  O   TYR A 335      55.068  17.328  62.742  1.00  0.00           O  
ATOM    768  CB  TYR A 335      57.155  16.767  64.830  1.00  0.00           C  
ATOM    769  CG  TYR A 335      58.437  16.561  65.606  1.00  0.00           C  
ATOM    770  CD1 TYR A 335      59.447  15.744  65.111  1.00  0.00           C  
ATOM    771  CD2 TYR A 335      58.637  17.179  66.833  1.00  0.00           C  
ATOM    772  CE1 TYR A 335      60.620  15.552  65.816  1.00  0.00           C  
ATOM    773  CE2 TYR A 335      59.808  16.994  67.544  1.00  0.00           C  
ATOM    774  CZ  TYR A 335      60.795  16.179  67.031  1.00  0.00           C  
ATOM    775  OH  TYR A 335      61.961  15.992  67.737  1.00  0.00           O  
ATOM    776  H   TYR A 335      56.912  19.266  62.964  1.00  0.00           H  
ATOM    777  HA  TYR A 335      58.266  16.775  63.002  1.00  0.00           H  
ATOM    778  HB2 TYR A 335      56.563  17.497  65.360  1.00  0.00           H  
ATOM    779  HB3 TYR A 335      56.625  15.826  64.810  1.00  0.00           H  
ATOM    780  HD1 TYR A 335      59.306  15.255  64.158  1.00  0.00           H  
ATOM    781  HD2 TYR A 335      57.862  17.816  67.232  1.00  0.00           H  
ATOM    782  HE1 TYR A 335      61.394  14.915  65.415  1.00  0.00           H  
ATOM    783  HE2 TYR A 335      59.945  17.485  68.496  1.00  0.00           H  
ATOM    784  HH  TYR A 335      62.443  16.820  67.787  1.00  0.00           H  
ATOM    785  N   ILE A 336      56.434  15.999  61.545  1.00  0.00           N  
ATOM    786  CA  ILE A 336      55.382  15.545  60.643  1.00  0.00           C  
ATOM    787  C   ILE A 336      55.598  14.093  60.233  1.00  0.00           C  
ATOM    788  O   ILE A 336      56.596  13.759  59.594  1.00  0.00           O  
ATOM    789  CB  ILE A 336      55.310  16.418  59.377  1.00  0.00           C  
ATOM    790  CG1 ILE A 336      55.067  17.882  59.754  1.00  0.00           C  
ATOM    791  CG2 ILE A 336      54.214  15.916  58.449  1.00  0.00           C  
ATOM    792  CD1 ILE A 336      55.320  18.848  58.617  1.00  0.00           C  
ATOM    793  H   ILE A 336      57.346  15.661  61.423  1.00  0.00           H  
ATOM    794  HA  ILE A 336      54.440  15.624  61.165  1.00  0.00           H  
ATOM    795  HB  ILE A 336      56.252  16.340  58.858  1.00  0.00           H  
ATOM    796 HG12 ILE A 336      54.042  18.001  60.067  1.00  0.00           H  
ATOM    797 HG13 ILE A 336      55.722  18.149  60.570  1.00  0.00           H  
ATOM    798 HG21 ILE A 336      54.256  14.839  58.394  1.00  0.00           H  
ATOM    799 HG22 ILE A 336      53.251  16.220  58.831  1.00  0.00           H  
ATOM    800 HG23 ILE A 336      54.358  16.333  57.463  1.00  0.00           H  
ATOM    801 HD11 ILE A 336      54.395  19.041  58.095  1.00  0.00           H  
ATOM    802 HD12 ILE A 336      55.711  19.774  59.012  1.00  0.00           H  
ATOM    803 HD13 ILE A 336      56.037  18.418  57.932  1.00  0.00           H  
ATOM    804  N   PHE A 337      54.656  13.232  60.604  1.00  0.00           N  
ATOM    805  CA  PHE A 337      54.742  11.814  60.275  1.00  0.00           C  
ATOM    806  C   PHE A 337      54.131  11.537  58.904  1.00  0.00           C  
ATOM    807  O   PHE A 337      52.955  11.816  58.667  1.00  0.00           O  
ATOM    808  CB  PHE A 337      54.033  10.977  61.341  1.00  0.00           C  
ATOM    809  CG  PHE A 337      54.713  11.012  62.680  1.00  0.00           C  
ATOM    810  CD1 PHE A 337      55.939  10.394  62.866  1.00  0.00           C  
ATOM    811  CD2 PHE A 337      54.126  11.663  63.753  1.00  0.00           C  
ATOM    812  CE1 PHE A 337      56.567  10.425  64.097  1.00  0.00           C  
ATOM    813  CE2 PHE A 337      54.749  11.698  64.986  1.00  0.00           C  
ATOM    814  CZ  PHE A 337      55.971  11.077  65.159  1.00  0.00           C  
ATOM    815  H   PHE A 337      53.884  13.559  61.112  1.00  0.00           H  
ATOM    816  HA  PHE A 337      55.786  11.543  60.251  1.00  0.00           H  
ATOM    817  HB2 PHE A 337      53.028  11.347  61.470  1.00  0.00           H  
ATOM    818  HB3 PHE A 337      53.995   9.948  61.014  1.00  0.00           H  
ATOM    819  HD1 PHE A 337      56.407   9.883  62.036  1.00  0.00           H  
ATOM    820  HD2 PHE A 337      53.170  12.148  63.620  1.00  0.00           H  
ATOM    821  HE1 PHE A 337      57.522   9.938  64.229  1.00  0.00           H  
ATOM    822  HE2 PHE A 337      54.281  12.208  65.814  1.00  0.00           H  
ATOM    823  HZ  PHE A 337      56.460  11.103  66.121  1.00  0.00           H  
ATOM    824  N   VAL A 338      54.938  10.985  58.004  1.00  0.00           N  
ATOM    825  CA  VAL A 338      54.478  10.668  56.657  1.00  0.00           C  
ATOM    826  C   VAL A 338      54.708   9.196  56.329  1.00  0.00           C  
ATOM    827  O   VAL A 338      55.795   8.663  56.552  1.00  0.00           O  
ATOM    828  CB  VAL A 338      55.189  11.535  55.602  1.00  0.00           C  
ATOM    829  CG1 VAL A 338      54.637  11.249  54.214  1.00  0.00           C  
ATOM    830  CG2 VAL A 338      55.052  13.011  55.946  1.00  0.00           C  
ATOM    831  H   VAL A 338      55.865  10.785  58.252  1.00  0.00           H  
ATOM    832  HA  VAL A 338      53.418  10.875  56.609  1.00  0.00           H  
ATOM    833  HB  VAL A 338      56.239  11.283  55.606  1.00  0.00           H  
ATOM    834 HG11 VAL A 338      54.036  12.084  53.887  1.00  0.00           H  
ATOM    835 HG12 VAL A 338      55.455  11.100  53.524  1.00  0.00           H  
ATOM    836 HG13 VAL A 338      54.026  10.359  54.247  1.00  0.00           H  
ATOM    837 HG21 VAL A 338      55.510  13.200  56.905  1.00  0.00           H  
ATOM    838 HG22 VAL A 338      55.544  13.604  55.189  1.00  0.00           H  
ATOM    839 HG23 VAL A 338      54.006  13.275  55.986  1.00  0.00           H  
ATOM    840  N   ASP A 339      53.679   8.546  55.799  1.00  0.00           N  
ATOM    841  CA  ASP A 339      53.769   7.136  55.438  1.00  0.00           C  
ATOM    842  C   ASP A 339      53.809   6.964  53.923  1.00  0.00           C  
ATOM    843  O   ASP A 339      53.427   7.865  53.175  1.00  0.00           O  
ATOM    844  CB  ASP A 339      52.586   6.361  56.021  1.00  0.00           C  
ATOM    845  CG  ASP A 339      52.667   6.230  57.529  1.00  0.00           C  
ATOM    846  OD1 ASP A 339      53.638   5.618  58.020  1.00  0.00           O  
ATOM    847  OD2 ASP A 339      51.758   6.738  58.219  1.00  0.00           O  
ATOM    848  H   ASP A 339      52.838   9.026  55.646  1.00  0.00           H  
ATOM    849  HA  ASP A 339      54.685   6.744  55.856  1.00  0.00           H  
ATOM    850  HB2 ASP A 339      51.669   6.876  55.772  1.00  0.00           H  
ATOM    851  HB3 ASP A 339      52.566   5.371  55.591  1.00  0.00           H  
ATOM    852  N   PHE A 340      54.275   5.802  53.476  1.00  0.00           N  
ATOM    853  CA  PHE A 340      54.367   5.513  52.050  1.00  0.00           C  
ATOM    854  C   PHE A 340      53.915   4.086  51.754  1.00  0.00           C  
ATOM    855  O   PHE A 340      53.734   3.279  52.666  1.00  0.00           O  
ATOM    856  CB  PHE A 340      55.800   5.718  51.558  1.00  0.00           C  
ATOM    857  CG  PHE A 340      56.176   7.163  51.391  1.00  0.00           C  
ATOM    858  CD1 PHE A 340      56.707   7.881  52.450  1.00  0.00           C  
ATOM    859  CD2 PHE A 340      55.998   7.803  50.175  1.00  0.00           C  
ATOM    860  CE1 PHE A 340      57.052   9.211  52.300  1.00  0.00           C  
ATOM    861  CE2 PHE A 340      56.342   9.132  50.018  1.00  0.00           C  
ATOM    862  CZ  PHE A 340      56.871   9.837  51.081  1.00  0.00           C  
ATOM    863  H   PHE A 340      54.565   5.124  54.122  1.00  0.00           H  
ATOM    864  HA  PHE A 340      53.715   6.199  51.531  1.00  0.00           H  
ATOM    865  HB2 PHE A 340      56.484   5.279  52.268  1.00  0.00           H  
ATOM    866  HB3 PHE A 340      55.918   5.231  50.602  1.00  0.00           H  
ATOM    867  HD1 PHE A 340      56.851   7.393  53.403  1.00  0.00           H  
ATOM    868  HD2 PHE A 340      55.584   7.252  49.342  1.00  0.00           H  
ATOM    869  HE1 PHE A 340      57.465   9.760  53.133  1.00  0.00           H  
ATOM    870  HE2 PHE A 340      56.198   9.619  49.064  1.00  0.00           H  
ATOM    871  HZ  PHE A 340      57.139  10.876  50.961  1.00  0.00           H  
ATOM    872  N   SER A 341      53.735   3.781  50.474  1.00  0.00           N  
ATOM    873  CA  SER A 341      53.300   2.454  50.057  1.00  0.00           C  
ATOM    874  C   SER A 341      54.491   1.509  49.923  1.00  0.00           C  
ATOM    875  O   SER A 341      54.583   0.506  50.629  1.00  0.00           O  
ATOM    876  CB  SER A 341      52.547   2.534  48.727  1.00  0.00           C  
ATOM    877  OG  SER A 341      52.442   1.256  48.122  1.00  0.00           O  
ATOM    878  H   SER A 341      53.896   4.468  49.792  1.00  0.00           H  
ATOM    879  HA  SER A 341      52.634   2.070  50.815  1.00  0.00           H  
ATOM    880  HB2 SER A 341      51.555   2.920  48.901  1.00  0.00           H  
ATOM    881  HB3 SER A 341      53.078   3.193  48.055  1.00  0.00           H  
ATOM    882  HG  SER A 341      51.558   1.144  47.764  1.00  0.00           H  
ATOM    883  N   ASN A 342      55.402   1.839  49.013  1.00  0.00           N  
ATOM    884  CA  ASN A 342      56.587   1.021  48.786  1.00  0.00           C  
ATOM    885  C   ASN A 342      57.799   1.609  49.501  1.00  0.00           C  
ATOM    886  O   ASN A 342      57.896   2.822  49.683  1.00  0.00           O  
ATOM    887  CB  ASN A 342      56.872   0.905  47.287  1.00  0.00           C  
ATOM    888  CG  ASN A 342      56.771   2.239  46.573  1.00  0.00           C  
ATOM    889  OD1 ASN A 342      57.644   3.097  46.711  1.00  0.00           O  
ATOM    890  ND2 ASN A 342      55.702   2.420  45.807  1.00  0.00           N  
ATOM    891  H   ASN A 342      55.272   2.652  48.481  1.00  0.00           H  
ATOM    892  HA  ASN A 342      56.391   0.036  49.183  1.00  0.00           H  
ATOM    893  HB2 ASN A 342      57.871   0.518  47.146  1.00  0.00           H  
ATOM    894  HB3 ASN A 342      56.162   0.224  46.843  1.00  0.00           H  
ATOM    895 HD21 ASN A 342      55.048   1.694  45.745  1.00  0.00           H  
ATOM    896 HD22 ASN A 342      55.612   3.274  45.334  1.00  0.00           H  
ATOM    897  N   GLU A 343      58.721   0.741  49.904  1.00  0.00           N  
ATOM    898  CA  GLU A 343      59.927   1.175  50.599  1.00  0.00           C  
ATOM    899  C   GLU A 343      60.674   2.229  49.787  1.00  0.00           C  
ATOM    900  O   GLU A 343      61.112   3.245  50.325  1.00  0.00           O  
ATOM    901  CB  GLU A 343      60.843  -0.020  50.872  1.00  0.00           C  
ATOM    902  CG  GLU A 343      61.931   0.267  51.893  1.00  0.00           C  
ATOM    903  CD  GLU A 343      63.063  -0.740  51.839  1.00  0.00           C  
ATOM    904  OE1 GLU A 343      63.341  -1.260  50.739  1.00  0.00           O  
ATOM    905  OE2 GLU A 343      63.672  -1.007  52.896  1.00  0.00           O  
ATOM    906  H   GLU A 343      58.587  -0.214  49.730  1.00  0.00           H  
ATOM    907  HA  GLU A 343      59.628   1.609  51.541  1.00  0.00           H  
ATOM    908  HB2 GLU A 343      60.245  -0.843  51.235  1.00  0.00           H  
ATOM    909  HB3 GLU A 343      61.317  -0.313  49.946  1.00  0.00           H  
ATOM    910  HG2 GLU A 343      62.335   1.250  51.704  1.00  0.00           H  
ATOM    911  HG3 GLU A 343      61.494   0.242  52.882  1.00  0.00           H  
ATOM    912  N   GLU A 344      60.817   1.976  48.490  1.00  0.00           N  
ATOM    913  CA  GLU A 344      61.512   2.901  47.604  1.00  0.00           C  
ATOM    914  C   GLU A 344      61.161   4.347  47.944  1.00  0.00           C  
ATOM    915  O   GLU A 344      62.020   5.126  48.355  1.00  0.00           O  
ATOM    916  CB  GLU A 344      61.159   2.609  46.145  1.00  0.00           C  
ATOM    917  CG  GLU A 344      62.076   1.590  45.489  1.00  0.00           C  
ATOM    918  CD  GLU A 344      61.985   0.222  46.136  1.00  0.00           C  
ATOM    919  OE1 GLU A 344      60.895  -0.385  46.089  1.00  0.00           O  
ATOM    920  OE2 GLU A 344      63.004  -0.241  46.691  1.00  0.00           O  
ATOM    921  H   GLU A 344      60.446   1.147  48.121  1.00  0.00           H  
ATOM    922  HA  GLU A 344      62.573   2.760  47.744  1.00  0.00           H  
ATOM    923  HB2 GLU A 344      60.146   2.234  46.100  1.00  0.00           H  
ATOM    924  HB3 GLU A 344      61.217   3.529  45.582  1.00  0.00           H  
ATOM    925  HG2 GLU A 344      61.804   1.497  44.448  1.00  0.00           H  
ATOM    926  HG3 GLU A 344      63.095   1.941  45.564  1.00  0.00           H  
ATOM    927  N   GLU A 345      59.890   4.698  47.768  1.00  0.00           N  
ATOM    928  CA  GLU A 345      59.426   6.051  48.054  1.00  0.00           C  
ATOM    929  C   GLU A 345      60.086   6.597  49.316  1.00  0.00           C  
ATOM    930  O   GLU A 345      60.558   7.734  49.341  1.00  0.00           O  
ATOM    931  CB  GLU A 345      57.904   6.067  48.213  1.00  0.00           C  
ATOM    932  CG  GLU A 345      57.152   5.868  46.908  1.00  0.00           C  
ATOM    933  CD  GLU A 345      56.857   7.176  46.199  1.00  0.00           C  
ATOM    934  OE1 GLU A 345      56.436   8.136  46.877  1.00  0.00           O  
ATOM    935  OE2 GLU A 345      57.048   7.237  44.966  1.00  0.00           O  
ATOM    936  H   GLU A 345      59.252   4.033  47.437  1.00  0.00           H  
ATOM    937  HA  GLU A 345      59.697   6.678  47.219  1.00  0.00           H  
ATOM    938  HB2 GLU A 345      57.616   5.280  48.894  1.00  0.00           H  
ATOM    939  HB3 GLU A 345      57.609   7.018  48.632  1.00  0.00           H  
ATOM    940  HG2 GLU A 345      57.750   5.249  46.255  1.00  0.00           H  
ATOM    941  HG3 GLU A 345      56.218   5.369  47.118  1.00  0.00           H  
ATOM    942  N   VAL A 346      60.116   5.779  50.363  1.00  0.00           N  
ATOM    943  CA  VAL A 346      60.719   6.178  51.629  1.00  0.00           C  
ATOM    944  C   VAL A 346      62.228   6.345  51.491  1.00  0.00           C  
ATOM    945  O   VAL A 346      62.787   7.378  51.856  1.00  0.00           O  
ATOM    946  CB  VAL A 346      60.425   5.153  52.740  1.00  0.00           C  
ATOM    947  CG1 VAL A 346      61.068   5.584  54.049  1.00  0.00           C  
ATOM    948  CG2 VAL A 346      58.925   4.966  52.909  1.00  0.00           C  
ATOM    949  H   VAL A 346      59.724   4.884  50.282  1.00  0.00           H  
ATOM    950  HA  VAL A 346      60.288   7.126  51.920  1.00  0.00           H  
ATOM    951  HB  VAL A 346      60.854   4.205  52.449  1.00  0.00           H  
ATOM    952 HG11 VAL A 346      60.409   5.344  54.869  1.00  0.00           H  
ATOM    953 HG12 VAL A 346      62.007   5.065  54.177  1.00  0.00           H  
ATOM    954 HG13 VAL A 346      61.246   6.649  54.029  1.00  0.00           H  
ATOM    955 HG21 VAL A 346      58.700   4.799  53.952  1.00  0.00           H  
ATOM    956 HG22 VAL A 346      58.411   5.852  52.566  1.00  0.00           H  
ATOM    957 HG23 VAL A 346      58.600   4.115  52.329  1.00  0.00           H  
ATOM    958  N   LYS A 347      62.884   5.318  50.961  1.00  0.00           N  
ATOM    959  CA  LYS A 347      64.330   5.348  50.772  1.00  0.00           C  
ATOM    960  C   LYS A 347      64.757   6.620  50.046  1.00  0.00           C  
ATOM    961  O   LYS A 347      65.778   7.221  50.378  1.00  0.00           O  
ATOM    962  CB  LYS A 347      64.787   4.120  49.982  1.00  0.00           C  
ATOM    963  CG  LYS A 347      64.987   2.884  50.842  1.00  0.00           C  
ATOM    964  CD  LYS A 347      65.216   1.645  49.994  1.00  0.00           C  
ATOM    965  CE  LYS A 347      66.676   1.505  49.593  1.00  0.00           C  
ATOM    966  NZ  LYS A 347      67.550   1.228  50.768  1.00  0.00           N  
ATOM    967  H   LYS A 347      62.383   4.520  50.689  1.00  0.00           H  
ATOM    968  HA  LYS A 347      64.792   5.332  51.747  1.00  0.00           H  
ATOM    969  HB2 LYS A 347      64.046   3.893  49.230  1.00  0.00           H  
ATOM    970  HB3 LYS A 347      65.724   4.349  49.495  1.00  0.00           H  
ATOM    971  HG2 LYS A 347      65.846   3.034  51.479  1.00  0.00           H  
ATOM    972  HG3 LYS A 347      64.107   2.734  51.451  1.00  0.00           H  
ATOM    973  HD2 LYS A 347      64.925   0.772  50.559  1.00  0.00           H  
ATOM    974  HD3 LYS A 347      64.612   1.715  49.100  1.00  0.00           H  
ATOM    975  HE2 LYS A 347      66.767   0.693  48.889  1.00  0.00           H  
ATOM    976  HE3 LYS A 347      66.998   2.424  49.126  1.00  0.00           H  
ATOM    977  HZ1 LYS A 347      67.017   1.372  51.650  1.00  0.00           H  
ATOM    978  HZ2 LYS A 347      68.369   1.869  50.763  1.00  0.00           H  
ATOM    979  HZ3 LYS A 347      67.890   0.246  50.737  1.00  0.00           H  
ATOM    980  N   GLN A 348      63.967   7.024  49.056  1.00  0.00           N  
ATOM    981  CA  GLN A 348      64.265   8.225  48.285  1.00  0.00           C  
ATOM    982  C   GLN A 348      63.975   9.482  49.099  1.00  0.00           C  
ATOM    983  O   GLN A 348      64.617  10.515  48.915  1.00  0.00           O  
ATOM    984  CB  GLN A 348      63.448   8.242  46.991  1.00  0.00           C  
ATOM    985  CG  GLN A 348      64.071   7.430  45.868  1.00  0.00           C  
ATOM    986  CD  GLN A 348      63.701   7.955  44.494  1.00  0.00           C  
ATOM    987  OE1 GLN A 348      62.570   7.789  44.038  1.00  0.00           O  
ATOM    988  NE2 GLN A 348      64.656   8.591  43.827  1.00  0.00           N  
ATOM    989  H   GLN A 348      63.167   6.502  48.838  1.00  0.00           H  
ATOM    990  HA  GLN A 348      65.315   8.208  48.036  1.00  0.00           H  
ATOM    991  HB2 GLN A 348      62.466   7.842  47.195  1.00  0.00           H  
ATOM    992  HB3 GLN A 348      63.349   9.264  46.655  1.00  0.00           H  
ATOM    993  HG2 GLN A 348      65.145   7.461  45.970  1.00  0.00           H  
ATOM    994  HG3 GLN A 348      63.732   6.408  45.949  1.00  0.00           H  
ATOM    995 HE21 GLN A 348      65.535   8.684  44.252  1.00  0.00           H  
ATOM    996 HE22 GLN A 348      64.445   8.940  42.936  1.00  0.00           H  
ATOM    997  N   ALA A 349      63.002   9.385  50.000  1.00  0.00           N  
ATOM    998  CA  ALA A 349      62.628  10.513  50.844  1.00  0.00           C  
ATOM    999  C   ALA A 349      63.827  11.027  51.635  1.00  0.00           C  
ATOM   1000  O   ALA A 349      63.959  12.230  51.867  1.00  0.00           O  
ATOM   1001  CB  ALA A 349      61.502  10.115  51.787  1.00  0.00           C  
ATOM   1002  H   ALA A 349      62.526   8.534  50.100  1.00  0.00           H  
ATOM   1003  HA  ALA A 349      62.265  11.303  50.203  1.00  0.00           H  
ATOM   1004  HB1 ALA A 349      60.872   9.383  51.305  1.00  0.00           H  
ATOM   1005  HB2 ALA A 349      61.921   9.693  52.689  1.00  0.00           H  
ATOM   1006  HB3 ALA A 349      60.917  10.987  52.036  1.00  0.00           H  
ATOM   1007  N   LEU A 350      64.695  10.111  52.047  1.00  0.00           N  
ATOM   1008  CA  LEU A 350      65.883  10.474  52.812  1.00  0.00           C  
ATOM   1009  C   LEU A 350      66.837  11.315  51.972  1.00  0.00           C  
ATOM   1010  O   LEU A 350      67.491  12.227  52.480  1.00  0.00           O  
ATOM   1011  CB  LEU A 350      66.598   9.215  53.308  1.00  0.00           C  
ATOM   1012  CG  LEU A 350      65.889   8.432  54.414  1.00  0.00           C  
ATOM   1013  CD1 LEU A 350      66.587   7.104  54.658  1.00  0.00           C  
ATOM   1014  CD2 LEU A 350      65.833   9.251  55.695  1.00  0.00           C  
ATOM   1015  H   LEU A 350      64.537   9.169  51.831  1.00  0.00           H  
ATOM   1016  HA  LEU A 350      65.563  11.055  53.664  1.00  0.00           H  
ATOM   1017  HB2 LEU A 350      66.725   8.554  52.465  1.00  0.00           H  
ATOM   1018  HB3 LEU A 350      67.567   9.511  53.680  1.00  0.00           H  
ATOM   1019  HG  LEU A 350      64.874   8.224  54.105  1.00  0.00           H  
ATOM   1020 HD11 LEU A 350      66.403   6.442  53.825  1.00  0.00           H  
ATOM   1021 HD12 LEU A 350      66.203   6.656  55.563  1.00  0.00           H  
ATOM   1022 HD13 LEU A 350      67.649   7.268  54.761  1.00  0.00           H  
ATOM   1023 HD21 LEU A 350      66.836   9.522  55.993  1.00  0.00           H  
ATOM   1024 HD22 LEU A 350      65.372   8.665  56.478  1.00  0.00           H  
ATOM   1025 HD23 LEU A 350      65.254  10.146  55.526  1.00  0.00           H  
ATOM   1026  N   LYS A 351      66.912  11.007  50.682  1.00  0.00           N  
ATOM   1027  CA  LYS A 351      67.783  11.736  49.768  1.00  0.00           C  
ATOM   1028  C   LYS A 351      67.648  13.242  49.974  1.00  0.00           C  
ATOM   1029  O   LYS A 351      68.645  13.949  50.124  1.00  0.00           O  
ATOM   1030  CB  LYS A 351      67.452  11.377  48.318  1.00  0.00           C  
ATOM   1031  CG  LYS A 351      67.757   9.932  47.964  1.00  0.00           C  
ATOM   1032  CD  LYS A 351      67.800   9.724  46.460  1.00  0.00           C  
ATOM   1033  CE  LYS A 351      68.508   8.428  46.096  1.00  0.00           C  
ATOM   1034  NZ  LYS A 351      68.555   8.215  44.623  1.00  0.00           N  
ATOM   1035  H   LYS A 351      66.367  10.268  50.336  1.00  0.00           H  
ATOM   1036  HA  LYS A 351      68.802  11.446  49.978  1.00  0.00           H  
ATOM   1037  HB2 LYS A 351      66.399  11.552  48.148  1.00  0.00           H  
ATOM   1038  HB3 LYS A 351      68.024  12.016  47.661  1.00  0.00           H  
ATOM   1039  HG2 LYS A 351      68.718   9.665  48.381  1.00  0.00           H  
ATOM   1040  HG3 LYS A 351      66.991   9.297  48.386  1.00  0.00           H  
ATOM   1041  HD2 LYS A 351      66.789   9.686  46.082  1.00  0.00           H  
ATOM   1042  HD3 LYS A 351      68.326  10.551  46.005  1.00  0.00           H  
ATOM   1043  HE2 LYS A 351      69.516   8.464  46.478  1.00  0.00           H  
ATOM   1044  HE3 LYS A 351      67.980   7.603  46.554  1.00  0.00           H  
ATOM   1045  HZ1 LYS A 351      69.511   8.411  44.264  1.00  0.00           H  
ATOM   1046  HZ2 LYS A 351      67.882   8.851  44.149  1.00  0.00           H  
ATOM   1047  HZ3 LYS A 351      68.304   7.231  44.395  1.00  0.00           H  
ATOM   1048  N   CYS A 352      66.410  13.724  49.981  1.00  0.00           N  
ATOM   1049  CA  CYS A 352      66.145  15.146  50.169  1.00  0.00           C  
ATOM   1050  C   CYS A 352      66.481  15.578  51.593  1.00  0.00           C  
ATOM   1051  O   CYS A 352      65.590  15.842  52.399  1.00  0.00           O  
ATOM   1052  CB  CYS A 352      64.680  15.458  49.861  1.00  0.00           C  
ATOM   1053  SG  CYS A 352      64.305  15.572  48.095  1.00  0.00           S  
ATOM   1054  H   CYS A 352      65.657  13.111  49.856  1.00  0.00           H  
ATOM   1055  HA  CYS A 352      66.773  15.693  49.483  1.00  0.00           H  
ATOM   1056  HB2 CYS A 352      64.059  14.680  50.278  1.00  0.00           H  
ATOM   1057  HB3 CYS A 352      64.418  16.401  50.316  1.00  0.00           H  
ATOM   1058  HG  CYS A 352      65.437  15.411  47.427  1.00  0.00           H  
ATOM   1059  N   ASN A 353      67.773  15.645  51.896  1.00  0.00           N  
ATOM   1060  CA  ASN A 353      68.228  16.044  53.224  1.00  0.00           C  
ATOM   1061  C   ASN A 353      68.834  17.443  53.194  1.00  0.00           C  
ATOM   1062  O   ASN A 353      69.249  17.929  52.142  1.00  0.00           O  
ATOM   1063  CB  ASN A 353      69.254  15.041  53.756  1.00  0.00           C  
ATOM   1064  CG  ASN A 353      70.576  15.121  53.018  1.00  0.00           C  
ATOM   1065  OD1 ASN A 353      70.673  14.743  51.851  1.00  0.00           O  
ATOM   1066  ND2 ASN A 353      71.604  15.616  53.698  1.00  0.00           N  
ATOM   1067  H   ASN A 353      68.438  15.423  51.211  1.00  0.00           H  
ATOM   1068  HA  ASN A 353      67.370  16.049  53.879  1.00  0.00           H  
ATOM   1069  HB2 ASN A 353      69.434  15.242  54.801  1.00  0.00           H  
ATOM   1070  HB3 ASN A 353      68.862  14.041  53.647  1.00  0.00           H  
ATOM   1071 HD21 ASN A 353      71.453  15.897  54.625  1.00  0.00           H  
ATOM   1072 HD22 ASN A 353      72.470  15.680  53.246  1.00  0.00           H  
ATOM   1073  N   ARG A 354      68.884  18.085  54.357  1.00  0.00           N  
ATOM   1074  CA  ARG A 354      69.439  19.428  54.465  1.00  0.00           C  
ATOM   1075  C   ARG A 354      68.759  20.378  53.483  1.00  0.00           C  
ATOM   1076  O   ARG A 354      69.424  21.138  52.779  1.00  0.00           O  
ATOM   1077  CB  ARG A 354      70.946  19.403  54.204  1.00  0.00           C  
ATOM   1078  CG  ARG A 354      71.775  19.122  55.448  1.00  0.00           C  
ATOM   1079  CD  ARG A 354      73.243  18.925  55.106  1.00  0.00           C  
ATOM   1080  NE  ARG A 354      74.104  19.093  56.274  1.00  0.00           N  
ATOM   1081  CZ  ARG A 354      75.421  18.918  56.248  1.00  0.00           C  
ATOM   1082  NH1 ARG A 354      76.024  18.571  55.120  1.00  0.00           N  
ATOM   1083  NH2 ARG A 354      76.136  19.089  57.352  1.00  0.00           N  
ATOM   1084  H   ARG A 354      68.537  17.645  55.161  1.00  0.00           H  
ATOM   1085  HA  ARG A 354      69.263  19.781  55.470  1.00  0.00           H  
ATOM   1086  HB2 ARG A 354      71.161  18.634  53.476  1.00  0.00           H  
ATOM   1087  HB3 ARG A 354      71.247  20.360  53.807  1.00  0.00           H  
ATOM   1088  HG2 ARG A 354      71.684  19.958  56.126  1.00  0.00           H  
ATOM   1089  HG3 ARG A 354      71.401  18.228  55.924  1.00  0.00           H  
ATOM   1090  HD2 ARG A 354      73.377  17.928  54.713  1.00  0.00           H  
ATOM   1091  HD3 ARG A 354      73.524  19.649  54.356  1.00  0.00           H  
ATOM   1092  HE  ARG A 354      73.678  19.350  57.118  1.00  0.00           H  
ATOM   1093 HH11 ARG A 354      75.488  18.442  54.286  1.00  0.00           H  
ATOM   1094 HH12 ARG A 354      77.016  18.441  55.102  1.00  0.00           H  
ATOM   1095 HH21 ARG A 354      75.684  19.351  58.204  1.00  0.00           H  
ATOM   1096 HH22 ARG A 354      77.126  18.957  57.332  1.00  0.00           H  
ATOM   1097  N   GLU A 355      67.431  20.329  53.443  1.00  0.00           N  
ATOM   1098  CA  GLU A 355      66.662  21.184  52.548  1.00  0.00           C  
ATOM   1099  C   GLU A 355      66.128  22.407  53.287  1.00  0.00           C  
ATOM   1100  O   GLU A 355      66.265  22.517  54.506  1.00  0.00           O  
ATOM   1101  CB  GLU A 355      65.502  20.401  51.929  1.00  0.00           C  
ATOM   1102  CG  GLU A 355      65.843  18.953  51.619  1.00  0.00           C  
ATOM   1103  CD  GLU A 355      66.601  18.799  50.315  1.00  0.00           C  
ATOM   1104  OE1 GLU A 355      67.843  18.931  50.331  1.00  0.00           O  
ATOM   1105  OE2 GLU A 355      65.952  18.545  49.278  1.00  0.00           O  
ATOM   1106  H   GLU A 355      66.958  19.702  54.029  1.00  0.00           H  
ATOM   1107  HA  GLU A 355      67.320  21.516  51.759  1.00  0.00           H  
ATOM   1108  HB2 GLU A 355      64.668  20.415  52.615  1.00  0.00           H  
ATOM   1109  HB3 GLU A 355      65.207  20.884  51.009  1.00  0.00           H  
ATOM   1110  HG2 GLU A 355      66.451  18.560  52.420  1.00  0.00           H  
ATOM   1111  HG3 GLU A 355      64.925  18.387  51.553  1.00  0.00           H  
ATOM   1112  N   TYR A 356      65.518  23.323  52.543  1.00  0.00           N  
ATOM   1113  CA  TYR A 356      64.965  24.538  53.127  1.00  0.00           C  
ATOM   1114  C   TYR A 356      63.616  24.879  52.501  1.00  0.00           C  
ATOM   1115  O   TYR A 356      63.528  25.165  51.307  1.00  0.00           O  
ATOM   1116  CB  TYR A 356      65.936  25.706  52.941  1.00  0.00           C  
ATOM   1117  CG  TYR A 356      67.323  25.431  53.476  1.00  0.00           C  
ATOM   1118  CD1 TYR A 356      68.121  24.441  52.919  1.00  0.00           C  
ATOM   1119  CD2 TYR A 356      67.836  26.164  54.540  1.00  0.00           C  
ATOM   1120  CE1 TYR A 356      69.389  24.186  53.405  1.00  0.00           C  
ATOM   1121  CE2 TYR A 356      69.103  25.918  55.032  1.00  0.00           C  
ATOM   1122  CZ  TYR A 356      69.875  24.927  54.462  1.00  0.00           C  
ATOM   1123  OH  TYR A 356      71.138  24.677  54.948  1.00  0.00           O  
ATOM   1124  H   TYR A 356      65.440  23.179  51.577  1.00  0.00           H  
ATOM   1125  HA  TYR A 356      64.825  24.364  54.184  1.00  0.00           H  
ATOM   1126  HB2 TYR A 356      66.025  25.927  51.888  1.00  0.00           H  
ATOM   1127  HB3 TYR A 356      65.548  26.574  53.454  1.00  0.00           H  
ATOM   1128  HD1 TYR A 356      67.737  23.861  52.090  1.00  0.00           H  
ATOM   1129  HD2 TYR A 356      67.229  26.938  54.985  1.00  0.00           H  
ATOM   1130  HE1 TYR A 356      69.994  23.411  52.958  1.00  0.00           H  
ATOM   1131  HE2 TYR A 356      69.484  26.497  55.860  1.00  0.00           H  
ATOM   1132  HH  TYR A 356      71.480  25.469  55.371  1.00  0.00           H  
ATOM   1133  N   MET A 357      62.568  24.847  53.316  1.00  0.00           N  
ATOM   1134  CA  MET A 357      61.223  25.154  52.844  1.00  0.00           C  
ATOM   1135  C   MET A 357      60.442  25.936  53.896  1.00  0.00           C  
ATOM   1136  O   MET A 357      60.616  25.725  55.095  1.00  0.00           O  
ATOM   1137  CB  MET A 357      60.477  23.867  52.491  1.00  0.00           C  
ATOM   1138  CG  MET A 357      60.121  23.019  53.701  1.00  0.00           C  
ATOM   1139  SD  MET A 357      58.625  22.043  53.450  1.00  0.00           S  
ATOM   1140  CE  MET A 357      58.808  20.807  54.733  1.00  0.00           C  
ATOM   1141  H   MET A 357      62.701  24.612  54.259  1.00  0.00           H  
ATOM   1142  HA  MET A 357      61.314  25.762  51.956  1.00  0.00           H  
ATOM   1143  HB2 MET A 357      59.563  24.123  51.976  1.00  0.00           H  
ATOM   1144  HB3 MET A 357      61.096  23.273  51.833  1.00  0.00           H  
ATOM   1145  HG2 MET A 357      60.940  22.347  53.908  1.00  0.00           H  
ATOM   1146  HG3 MET A 357      59.970  23.671  54.548  1.00  0.00           H  
ATOM   1147  HE1 MET A 357      58.035  20.940  55.475  1.00  0.00           H  
ATOM   1148  HE2 MET A 357      58.724  19.822  54.298  1.00  0.00           H  
ATOM   1149  HE3 MET A 357      59.776  20.914  55.201  1.00  0.00           H  
ATOM   1150  N   GLY A 358      59.581  26.839  53.437  1.00  0.00           N  
ATOM   1151  CA  GLY A 358      58.787  27.639  54.353  1.00  0.00           C  
ATOM   1152  C   GLY A 358      59.580  28.774  54.968  1.00  0.00           C  
ATOM   1153  O   GLY A 358      59.114  29.912  55.013  1.00  0.00           O  
ATOM   1154  H   GLY A 358      59.484  26.965  52.471  1.00  0.00           H  
ATOM   1155  HA2 GLY A 358      57.945  28.050  53.817  1.00  0.00           H  
ATOM   1156  HA3 GLY A 358      58.421  27.001  55.145  1.00  0.00           H  
ATOM   1157  N   GLY A 359      60.782  28.466  55.444  1.00  0.00           N  
ATOM   1158  CA  GLY A 359      61.622  29.481  56.055  1.00  0.00           C  
ATOM   1159  C   GLY A 359      62.384  28.956  57.256  1.00  0.00           C  
ATOM   1160  O   GLY A 359      62.603  29.682  58.225  1.00  0.00           O  
ATOM   1161  H   GLY A 359      61.102  27.542  55.380  1.00  0.00           H  
ATOM   1162  HA2 GLY A 359      62.328  29.837  55.320  1.00  0.00           H  
ATOM   1163  HA3 GLY A 359      60.998  30.304  56.371  1.00  0.00           H  
ATOM   1164  N   ARG A 360      62.789  27.692  57.191  1.00  0.00           N  
ATOM   1165  CA  ARG A 360      63.530  27.070  58.283  1.00  0.00           C  
ATOM   1166  C   ARG A 360      64.199  25.780  57.820  1.00  0.00           C  
ATOM   1167  O   ARG A 360      63.763  25.155  56.853  1.00  0.00           O  
ATOM   1168  CB  ARG A 360      62.596  26.780  59.459  1.00  0.00           C  
ATOM   1169  CG  ARG A 360      62.231  28.014  60.267  1.00  0.00           C  
ATOM   1170  CD  ARG A 360      61.836  27.653  61.691  1.00  0.00           C  
ATOM   1171  NE  ARG A 360      61.756  28.829  62.552  1.00  0.00           N  
ATOM   1172  CZ  ARG A 360      61.404  28.780  63.833  1.00  0.00           C  
ATOM   1173  NH1 ARG A 360      61.102  27.618  64.396  1.00  0.00           N  
ATOM   1174  NH2 ARG A 360      61.356  29.893  64.551  1.00  0.00           N  
ATOM   1175  H   ARG A 360      62.585  27.164  56.391  1.00  0.00           H  
ATOM   1176  HA  ARG A 360      64.293  27.764  58.603  1.00  0.00           H  
ATOM   1177  HB2 ARG A 360      61.684  26.342  59.081  1.00  0.00           H  
ATOM   1178  HB3 ARG A 360      63.078  26.074  60.119  1.00  0.00           H  
ATOM   1179  HG2 ARG A 360      63.083  28.677  60.300  1.00  0.00           H  
ATOM   1180  HG3 ARG A 360      61.402  28.514  59.788  1.00  0.00           H  
ATOM   1181  HD2 ARG A 360      60.872  27.168  61.670  1.00  0.00           H  
ATOM   1182  HD3 ARG A 360      62.572  26.972  62.091  1.00  0.00           H  
ATOM   1183  HE  ARG A 360      61.976  29.698  62.156  1.00  0.00           H  
ATOM   1184 HH11 ARG A 360      61.138  26.777  63.856  1.00  0.00           H  
ATOM   1185 HH12 ARG A 360      60.838  27.584  65.360  1.00  0.00           H  
ATOM   1186 HH21 ARG A 360      61.583  30.771  64.131  1.00  0.00           H  
ATOM   1187 HH22 ARG A 360      61.090  29.855  65.514  1.00  0.00           H  
ATOM   1188  N   TYR A 361      65.261  25.389  58.515  1.00  0.00           N  
ATOM   1189  CA  TYR A 361      65.994  24.175  58.174  1.00  0.00           C  
ATOM   1190  C   TYR A 361      65.172  22.932  58.506  1.00  0.00           C  
ATOM   1191  O   TYR A 361      64.598  22.826  59.590  1.00  0.00           O  
ATOM   1192  CB  TYR A 361      67.328  24.133  58.921  1.00  0.00           C  
ATOM   1193  CG  TYR A 361      67.210  23.641  60.346  1.00  0.00           C  
ATOM   1194  CD1 TYR A 361      66.955  22.302  60.621  1.00  0.00           C  
ATOM   1195  CD2 TYR A 361      67.350  24.514  61.418  1.00  0.00           C  
ATOM   1196  CE1 TYR A 361      66.845  21.848  61.920  1.00  0.00           C  
ATOM   1197  CE2 TYR A 361      67.243  24.068  62.720  1.00  0.00           C  
ATOM   1198  CZ  TYR A 361      66.991  22.735  62.968  1.00  0.00           C  
ATOM   1199  OH  TYR A 361      66.881  22.288  64.264  1.00  0.00           O  
ATOM   1200  H   TYR A 361      65.561  25.930  59.275  1.00  0.00           H  
ATOM   1201  HA  TYR A 361      66.188  24.192  57.113  1.00  0.00           H  
ATOM   1202  HB2 TYR A 361      68.005  23.473  58.399  1.00  0.00           H  
ATOM   1203  HB3 TYR A 361      67.750  25.127  58.947  1.00  0.00           H  
ATOM   1204  HD1 TYR A 361      66.841  21.610  59.798  1.00  0.00           H  
ATOM   1205  HD2 TYR A 361      67.548  25.558  61.221  1.00  0.00           H  
ATOM   1206  HE1 TYR A 361      66.647  20.804  62.114  1.00  0.00           H  
ATOM   1207  HE2 TYR A 361      67.357  24.762  63.540  1.00  0.00           H  
ATOM   1208  HH  TYR A 361      65.965  22.337  64.543  1.00  0.00           H  
ATOM   1209  N   ILE A 362      65.124  21.996  57.565  1.00  0.00           N  
ATOM   1210  CA  ILE A 362      64.375  20.760  57.756  1.00  0.00           C  
ATOM   1211  C   ILE A 362      65.312  19.560  57.856  1.00  0.00           C  
ATOM   1212  O   ILE A 362      66.337  19.503  57.178  1.00  0.00           O  
ATOM   1213  CB  ILE A 362      63.376  20.523  56.609  1.00  0.00           C  
ATOM   1214  CG1 ILE A 362      62.421  21.711  56.482  1.00  0.00           C  
ATOM   1215  CG2 ILE A 362      62.600  19.234  56.839  1.00  0.00           C  
ATOM   1216  CD1 ILE A 362      61.451  21.832  57.636  1.00  0.00           C  
ATOM   1217  H   ILE A 362      65.602  22.139  56.723  1.00  0.00           H  
ATOM   1218  HA  ILE A 362      63.819  20.846  58.679  1.00  0.00           H  
ATOM   1219  HB  ILE A 362      63.934  20.419  55.691  1.00  0.00           H  
ATOM   1220 HG12 ILE A 362      62.994  22.623  56.434  1.00  0.00           H  
ATOM   1221 HG13 ILE A 362      61.845  21.605  55.574  1.00  0.00           H  
ATOM   1222 HG21 ILE A 362      61.616  19.325  56.403  1.00  0.00           H  
ATOM   1223 HG22 ILE A 362      63.125  18.412  56.377  1.00  0.00           H  
ATOM   1224 HG23 ILE A 362      62.510  19.054  57.900  1.00  0.00           H  
ATOM   1225 HD11 ILE A 362      61.978  21.681  58.568  1.00  0.00           H  
ATOM   1226 HD12 ILE A 362      61.005  22.815  57.631  1.00  0.00           H  
ATOM   1227 HD13 ILE A 362      60.678  21.085  57.537  1.00  0.00           H  
ATOM   1228  N   GLU A 363      64.950  18.602  58.704  1.00  0.00           N  
ATOM   1229  CA  GLU A 363      65.758  17.403  58.891  1.00  0.00           C  
ATOM   1230  C   GLU A 363      64.897  16.147  58.801  1.00  0.00           C  
ATOM   1231  O   GLU A 363      64.042  15.904  59.653  1.00  0.00           O  
ATOM   1232  CB  GLU A 363      66.473  17.448  60.243  1.00  0.00           C  
ATOM   1233  CG  GLU A 363      67.518  18.547  60.344  1.00  0.00           C  
ATOM   1234  CD  GLU A 363      68.780  18.224  59.567  1.00  0.00           C  
ATOM   1235  OE1 GLU A 363      69.607  17.442  60.081  1.00  0.00           O  
ATOM   1236  OE2 GLU A 363      68.940  18.752  58.448  1.00  0.00           O  
ATOM   1237  H   GLU A 363      64.121  18.706  59.216  1.00  0.00           H  
ATOM   1238  HA  GLU A 363      66.498  17.376  58.105  1.00  0.00           H  
ATOM   1239  HB2 GLU A 363      65.739  17.606  61.020  1.00  0.00           H  
ATOM   1240  HB3 GLU A 363      66.962  16.500  60.410  1.00  0.00           H  
ATOM   1241  HG2 GLU A 363      67.098  19.462  59.953  1.00  0.00           H  
ATOM   1242  HG3 GLU A 363      67.777  18.686  61.383  1.00  0.00           H  
ATOM   1243  N   VAL A 364      65.127  15.352  57.760  1.00  0.00           N  
ATOM   1244  CA  VAL A 364      64.373  14.121  57.558  1.00  0.00           C  
ATOM   1245  C   VAL A 364      65.037  12.947  58.269  1.00  0.00           C  
ATOM   1246  O   VAL A 364      66.262  12.838  58.301  1.00  0.00           O  
ATOM   1247  CB  VAL A 364      64.236  13.787  56.060  1.00  0.00           C  
ATOM   1248  CG1 VAL A 364      63.286  12.616  55.860  1.00  0.00           C  
ATOM   1249  CG2 VAL A 364      63.762  15.007  55.285  1.00  0.00           C  
ATOM   1250  H   VAL A 364      65.822  15.599  57.115  1.00  0.00           H  
ATOM   1251  HA  VAL A 364      63.384  14.264  57.966  1.00  0.00           H  
ATOM   1252  HB  VAL A 364      65.207  13.503  55.685  1.00  0.00           H  
ATOM   1253 HG11 VAL A 364      62.307  12.879  56.232  1.00  0.00           H  
ATOM   1254 HG12 VAL A 364      63.222  12.381  54.807  1.00  0.00           H  
ATOM   1255 HG13 VAL A 364      63.657  11.756  56.398  1.00  0.00           H  
ATOM   1256 HG21 VAL A 364      64.557  15.358  54.645  1.00  0.00           H  
ATOM   1257 HG22 VAL A 364      62.906  14.741  54.682  1.00  0.00           H  
ATOM   1258 HG23 VAL A 364      63.484  15.789  55.976  1.00  0.00           H  
ATOM   1259  N   PHE A 365      64.219  12.069  58.838  1.00  0.00           N  
ATOM   1260  CA  PHE A 365      64.725  10.901  59.551  1.00  0.00           C  
ATOM   1261  C   PHE A 365      63.843   9.682  59.295  1.00  0.00           C  
ATOM   1262  O   PHE A 365      62.619   9.793  59.226  1.00  0.00           O  
ATOM   1263  CB  PHE A 365      64.800  11.186  61.052  1.00  0.00           C  
ATOM   1264  CG  PHE A 365      65.578  12.424  61.390  1.00  0.00           C  
ATOM   1265  CD1 PHE A 365      66.953  12.461  61.223  1.00  0.00           C  
ATOM   1266  CD2 PHE A 365      64.936  13.553  61.875  1.00  0.00           C  
ATOM   1267  CE1 PHE A 365      67.674  13.600  61.533  1.00  0.00           C  
ATOM   1268  CE2 PHE A 365      65.652  14.694  62.186  1.00  0.00           C  
ATOM   1269  CZ  PHE A 365      67.021  14.716  62.016  1.00  0.00           C  
ATOM   1270  H   PHE A 365      63.250  12.208  58.778  1.00  0.00           H  
ATOM   1271  HA  PHE A 365      65.718  10.695  59.183  1.00  0.00           H  
ATOM   1272  HB2 PHE A 365      63.799  11.308  61.438  1.00  0.00           H  
ATOM   1273  HB3 PHE A 365      65.271  10.350  61.546  1.00  0.00           H  
ATOM   1274  HD1 PHE A 365      67.465  11.587  60.845  1.00  0.00           H  
ATOM   1275  HD2 PHE A 365      63.864  13.535  62.011  1.00  0.00           H  
ATOM   1276  HE1 PHE A 365      68.745  13.614  61.397  1.00  0.00           H  
ATOM   1277  HE2 PHE A 365      65.139  15.566  62.565  1.00  0.00           H  
ATOM   1278  HZ  PHE A 365      67.582  15.608  62.257  1.00  0.00           H  
ATOM   1279  N   ARG A 366      64.474   8.521  59.156  1.00  0.00           N  
ATOM   1280  CA  ARG A 366      63.748   7.282  58.906  1.00  0.00           C  
ATOM   1281  C   ARG A 366      63.326   6.626  60.218  1.00  0.00           C  
ATOM   1282  O   ARG A 366      64.167   6.198  61.008  1.00  0.00           O  
ATOM   1283  CB  ARG A 366      64.612   6.314  58.095  1.00  0.00           C  
ATOM   1284  CG  ARG A 366      63.806   5.341  57.249  1.00  0.00           C  
ATOM   1285  CD  ARG A 366      64.705   4.336  56.548  1.00  0.00           C  
ATOM   1286  NE  ARG A 366      63.959   3.176  56.067  1.00  0.00           N  
ATOM   1287  CZ  ARG A 366      64.531   2.108  55.522  1.00  0.00           C  
ATOM   1288  NH1 ARG A 366      65.849   2.054  55.391  1.00  0.00           N  
ATOM   1289  NH2 ARG A 366      63.785   1.093  55.108  1.00  0.00           N  
ATOM   1290  H   ARG A 366      65.452   8.497  59.222  1.00  0.00           H  
ATOM   1291  HA  ARG A 366      62.863   7.525  58.338  1.00  0.00           H  
ATOM   1292  HB2 ARG A 366      65.250   6.885  57.436  1.00  0.00           H  
ATOM   1293  HB3 ARG A 366      65.227   5.744  58.774  1.00  0.00           H  
ATOM   1294  HG2 ARG A 366      63.118   4.807  57.889  1.00  0.00           H  
ATOM   1295  HG3 ARG A 366      63.253   5.897  56.507  1.00  0.00           H  
ATOM   1296  HD2 ARG A 366      65.178   4.822  55.708  1.00  0.00           H  
ATOM   1297  HD3 ARG A 366      65.461   4.003  57.243  1.00  0.00           H  
ATOM   1298  HE  ARG A 366      62.984   3.196  56.155  1.00  0.00           H  
ATOM   1299 HH11 ARG A 366      66.415   2.817  55.702  1.00  0.00           H  
ATOM   1300 HH12 ARG A 366      66.278   1.247  54.981  1.00  0.00           H  
ATOM   1301 HH21 ARG A 366      62.790   1.130  55.206  1.00  0.00           H  
ATOM   1302 HH22 ARG A 366      64.216   0.290  54.699  1.00  0.00           H  
ATOM   1303  N   GLU A 367      62.018   6.552  60.442  1.00  0.00           N  
ATOM   1304  CA  GLU A 367      61.484   5.949  61.658  1.00  0.00           C  
ATOM   1305  C   GLU A 367      61.454   4.428  61.543  1.00  0.00           C  
ATOM   1306  O   GLU A 367      60.554   3.858  60.927  1.00  0.00           O  
ATOM   1307  CB  GLU A 367      60.077   6.479  61.942  1.00  0.00           C  
ATOM   1308  CG  GLU A 367      60.056   7.914  62.441  1.00  0.00           C  
ATOM   1309  CD  GLU A 367      60.266   8.013  63.939  1.00  0.00           C  
ATOM   1310  OE1 GLU A 367      61.431   7.938  64.382  1.00  0.00           O  
ATOM   1311  OE2 GLU A 367      59.265   8.168  64.670  1.00  0.00           O  
ATOM   1312  H   GLU A 367      61.397   6.911  59.774  1.00  0.00           H  
ATOM   1313  HA  GLU A 367      62.133   6.223  62.476  1.00  0.00           H  
ATOM   1314  HB2 GLU A 367      59.496   6.427  61.033  1.00  0.00           H  
ATOM   1315  HB3 GLU A 367      59.614   5.853  62.690  1.00  0.00           H  
ATOM   1316  HG2 GLU A 367      60.840   8.466  61.946  1.00  0.00           H  
ATOM   1317  HG3 GLU A 367      59.099   8.352  62.196  1.00  0.00           H  
ATOM   1318  N   LYS A 368      62.445   3.776  62.142  1.00  0.00           N  
ATOM   1319  CA  LYS A 368      62.534   2.320  62.108  1.00  0.00           C  
ATOM   1320  C   LYS A 368      61.214   1.686  62.533  1.00  0.00           C  
ATOM   1321  O   LYS A 368      60.659   0.850  61.821  1.00  0.00           O  
ATOM   1322  CB  LYS A 368      63.662   1.837  63.022  1.00  0.00           C  
ATOM   1323  CG  LYS A 368      63.942   0.349  62.907  1.00  0.00           C  
ATOM   1324  CD  LYS A 368      65.145  -0.059  63.742  1.00  0.00           C  
ATOM   1325  CE  LYS A 368      66.447   0.155  62.985  1.00  0.00           C  
ATOM   1326  NZ  LYS A 368      67.519  -0.765  63.456  1.00  0.00           N  
ATOM   1327  H   LYS A 368      63.134   4.286  62.618  1.00  0.00           H  
ATOM   1328  HA  LYS A 368      62.752   2.024  61.093  1.00  0.00           H  
ATOM   1329  HB2 LYS A 368      64.566   2.373  62.773  1.00  0.00           H  
ATOM   1330  HB3 LYS A 368      63.397   2.054  64.047  1.00  0.00           H  
ATOM   1331  HG2 LYS A 368      63.076  -0.199  63.251  1.00  0.00           H  
ATOM   1332  HG3 LYS A 368      64.136   0.107  61.872  1.00  0.00           H  
ATOM   1333  HD2 LYS A 368      65.164   0.535  64.644  1.00  0.00           H  
ATOM   1334  HD3 LYS A 368      65.055  -1.105  64.000  1.00  0.00           H  
ATOM   1335  HE2 LYS A 368      66.270  -0.019  61.935  1.00  0.00           H  
ATOM   1336  HE3 LYS A 368      66.769   1.175  63.132  1.00  0.00           H  
ATOM   1337  HZ1 LYS A 368      67.272  -1.154  64.388  1.00  0.00           H  
ATOM   1338  HZ2 LYS A 368      68.420  -0.253  63.534  1.00  0.00           H  
ATOM   1339  HZ3 LYS A 368      67.636  -1.551  62.784  1.00  0.00           H  
ATOM   1340  N   SER A 369      60.716   2.089  63.698  1.00  0.00           N  
ATOM   1341  CA  SER A 369      59.462   1.557  64.219  1.00  0.00           C  
ATOM   1342  C   SER A 369      58.360   1.637  63.167  1.00  0.00           C  
ATOM   1343  O   SER A 369      57.766   0.626  62.795  1.00  0.00           O  
ATOM   1344  CB  SER A 369      59.040   2.323  65.474  1.00  0.00           C  
ATOM   1345  OG  SER A 369      57.730   1.963  65.875  1.00  0.00           O  
ATOM   1346  H   SER A 369      61.205   2.759  64.220  1.00  0.00           H  
ATOM   1347  HA  SER A 369      59.622   0.521  64.476  1.00  0.00           H  
ATOM   1348  HB2 SER A 369      59.725   2.095  66.278  1.00  0.00           H  
ATOM   1349  HB3 SER A 369      59.064   3.383  65.270  1.00  0.00           H  
ATOM   1350  HG  SER A 369      57.756   1.122  66.337  1.00  0.00           H  
ATOM   1351  N   GLY A 370      58.091   2.850  62.691  1.00  0.00           N  
ATOM   1352  CA  GLY A 370      57.061   3.040  61.687  1.00  0.00           C  
ATOM   1353  C   GLY A 370      55.866   3.805  62.220  1.00  0.00           C  
ATOM   1354  O   GLY A 370      55.853   5.036  62.254  1.00  0.00           O  
ATOM   1355  H   GLY A 370      58.597   3.620  63.024  1.00  0.00           H  
ATOM   1356  HA2 GLY A 370      57.482   3.586  60.855  1.00  0.00           H  
ATOM   1357  HA3 GLY A 370      56.729   2.074  61.339  1.00  0.00           H  
ATOM   1358  N   PRO A 371      54.831   3.068  62.650  1.00  0.00           N  
ATOM   1359  CA  PRO A 371      53.606   3.663  63.192  1.00  0.00           C  
ATOM   1360  C   PRO A 371      53.831   4.317  64.550  1.00  0.00           C  
ATOM   1361  O   PRO A 371      54.623   3.834  65.359  1.00  0.00           O  
ATOM   1362  CB  PRO A 371      52.659   2.467  63.324  1.00  0.00           C  
ATOM   1363  CG  PRO A 371      53.556   1.287  63.462  1.00  0.00           C  
ATOM   1364  CD  PRO A 371      54.777   1.597  62.640  1.00  0.00           C  
ATOM   1365  HA  PRO A 371      53.182   4.387  62.511  1.00  0.00           H  
ATOM   1366  HB2 PRO A 371      52.034   2.594  64.196  1.00  0.00           H  
ATOM   1367  HB3 PRO A 371      52.042   2.394  62.441  1.00  0.00           H  
ATOM   1368  HG2 PRO A 371      53.826   1.149  64.498  1.00  0.00           H  
ATOM   1369  HG3 PRO A 371      53.063   0.405  63.081  1.00  0.00           H  
ATOM   1370  HD2 PRO A 371      55.658   1.175  63.101  1.00  0.00           H  
ATOM   1371  HD3 PRO A 371      54.660   1.222  61.634  1.00  0.00           H  
ATOM   1372  N   SER A 372      53.128   5.418  64.796  1.00  0.00           N  
ATOM   1373  CA  SER A 372      53.253   6.139  66.057  1.00  0.00           C  
ATOM   1374  C   SER A 372      51.881   6.416  66.664  1.00  0.00           C  
ATOM   1375  O   SER A 372      51.649   6.160  67.846  1.00  0.00           O  
ATOM   1376  CB  SER A 372      54.003   7.456  65.843  1.00  0.00           C  
ATOM   1377  OG  SER A 372      53.190   8.403  65.172  1.00  0.00           O  
ATOM   1378  H   SER A 372      52.512   5.753  64.112  1.00  0.00           H  
ATOM   1379  HA  SER A 372      53.817   5.520  66.739  1.00  0.00           H  
ATOM   1380  HB2 SER A 372      54.292   7.862  66.800  1.00  0.00           H  
ATOM   1381  HB3 SER A 372      54.887   7.271  65.249  1.00  0.00           H  
ATOM   1382  HG  SER A 372      52.381   8.540  65.670  1.00  0.00           H  
ATOM   1383  N   SER A 373      50.974   6.941  65.847  1.00  0.00           N  
ATOM   1384  CA  SER A 373      49.626   7.257  66.302  1.00  0.00           C  
ATOM   1385  C   SER A 373      48.925   6.009  66.832  1.00  0.00           C  
ATOM   1386  O   SER A 373      48.604   5.095  66.073  1.00  0.00           O  
ATOM   1387  CB  SER A 373      48.809   7.868  65.162  1.00  0.00           C  
ATOM   1388  OG  SER A 373      49.001   9.271  65.093  1.00  0.00           O  
ATOM   1389  H   SER A 373      51.219   7.123  64.915  1.00  0.00           H  
ATOM   1390  HA  SER A 373      49.706   7.977  67.102  1.00  0.00           H  
ATOM   1391  HB2 SER A 373      49.117   7.429  64.226  1.00  0.00           H  
ATOM   1392  HB3 SER A 373      47.761   7.669  65.327  1.00  0.00           H  
ATOM   1393  HG  SER A 373      48.249   9.717  65.489  1.00  0.00           H  
ATOM   1394  N   GLY A 374      48.691   5.979  68.140  1.00  0.00           N  
ATOM   1395  CA  GLY A 374      48.030   4.840  68.750  1.00  0.00           C  
ATOM   1396  C   GLY A 374      48.900   3.598  68.751  1.00  0.00           C  
ATOM   1397  O   GLY A 374      50.091   3.668  69.051  1.00  0.00           O  
ATOM   1398  H   GLY A 374      48.969   6.737  68.696  1.00  0.00           H  
ATOM   1399  HA2 GLY A 374      47.775   5.089  69.769  1.00  0.00           H  
ATOM   1400  HA3 GLY A 374      47.123   4.629  68.203  1.00  0.00           H  
TER    1401      GLY A 374                                                      
END
MOLECULE T0487_26_96.pdb
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
END
