
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   81 ( 1213),  selected   81 , name 1x6g_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 1x6g_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S     178           -
LGA    S     2_A      L     179           -
LGA    S     3_A      E     180           -
LGA    G     4_A      A     181           -
LGA    S     5_A      W     182           -
LGA    S     6_A      L     183           -
LGA    G     7_A      A     184           -
LGA    R     8_A      Q     185           -
LGA    M     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    T    11_A      G     186          2.257
LGA    R    12_A      H     187          4.135
LGA    R    13_A      -       -           -
LGA    W    14_A      P     188          4.869
LGA    A    15_A      L     189          1.651
LGA    P    16_A      -       -           -
LGA    G    17_A      P     190          5.149
LGA    T    18_A      K     191          1.942
LGA    Q    19_A      R     192          0.977
LGA    C    20_A      V     193          0.783
LGA    I    21_A      R     194          0.344
LGA    T    22_A      N     195          0.470
LGA    K    23_A      A     196          1.274
LGA    C    24_A      Y     197          2.191
LGA    E    25_A      -       -           -
LGA    H    26_A      -       -           -
LGA    T    27_A      -       -           -
LGA    R    28_A      -       -           -
LGA    P    29_A      -       -           -
LGA    K    30_A      -       -           -
LGA    P    31_A      -       -           -
LGA    G    32_A      -       -           -
LGA    E    33_A      -       -           -
LGA    L    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    F    36_A      -       -           -
LGA    R    37_A      -       -           -
LGA    K    38_A      D     198          2.741
LGA    G    39_A      R     199          1.599
LGA    D    40_A      R     200          1.976
LGA    V    41_A      T     201          2.017
LGA    V    42_A      W     202          1.438
LGA    T    43_A      E     203          1.800
LGA    I    44_A      L     204          1.737
LGA    L    45_A      L     205          0.966
LGA    E    46_A      R     206          1.377
LGA    A    47_A      L     207          2.218
LGA    C    48_A      G     208          3.034
LGA    E    49_A      E     209          1.768
LGA    N    50_A      E     210          2.050
LGA    K    51_A      D     211          4.167
LGA    -       -      P     212           -
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    S    52_A      R     240          1.260
LGA    W    53_A      V     241          0.747
LGA    Y    54_A      A     242          0.466
LGA    R    55_A      W     243          0.638
LGA    V    56_A      V     244          1.290
LGA    K    57_A      A     245          0.949
LGA    H    58_A      D     246          0.917
LGA    H    59_A      P     247          1.001
LGA    T    60_A      K     248          2.746
LGA    S    61_A      D     249          3.834
LGA    G    62_A      P     250          3.377
LGA    -       -      R     251           -
LGA    Q    63_A      K     252          2.736
LGA    E    64_A      P     253          0.897
LGA    G    65_A      I     254          1.116
LGA    L    66_A      P     255          1.081
LGA    L    67_A      H     256          0.524
LGA    A    68_A      L     257          1.306
LGA    A    69_A      T     258          1.295
LGA    G    70_A      G     259          1.116
LGA    A    71_A      L     260          0.963
LGA    L    72_A      L     261          0.400
LGA    R    73_A      V     262          0.336
LGA    E    74_A      P     263          2.196
LGA    R    75_A      V     264          2.424
LGA    S    76_A      L     265           #
LGA    G    77_A      -       -           -
LGA    P    78_A      -       -           -
LGA    S    79_A      -       -           -
LGA    S    80_A      -       -           -
LGA    G    81_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   81   88    5.0     50    2.11    10.00     49.862     2.258

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.229892 * X  +   0.385271 * Y  +  -0.893709 * Z  +  46.943596
  Y_new =  -0.893519 * X  +  -0.447505 * Y  +   0.036927 * Z  +  38.464771
  Z_new =  -0.385713 * X  +   0.807035 * Y  +   0.447124 * Z  +  35.481308 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.064862   -2.076731  [ DEG:    61.0121   -118.9879 ]
  Theta =   0.395980    2.745612  [ DEG:    22.6880    157.3120 ]
  Phi   =  -1.822622    1.318970  [ DEG:  -104.4286     75.5714 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x6g_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x6g_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   81   88   5.0   50   2.11   10.00  49.862
REMARK  ---------------------------------------------------------- 
MOLECULE 1x6g_A
HEADER    SIGNALING PROTEIN                       17-MAY-05   1X6G              
TITLE     SOLUTION STRUCTURES OF THE SH3 DOMAIN OF HUMAN                        
TITLE    2 MEGAKARYOCYTE-ASSOCIATED TYROSINE-PROTEIN KINASE.                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MEGAKARYOCYTE-ASSOCIATED TYROSINE-PROTEIN KINASE;          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: TYROSINE-PROTEIN KINASE CTK, PROTEIN KINASE HYL,            
COMPND   6 HEMATOPOIETIC CONSENSUS TYROSINE-LACKING KINASE;                     
COMPND   7 EC: 2.7.1.112;                                                       
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MATK;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P041101-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    MATK, CTK, HYL, SH3 DOMAIN, STRUCTURAL GENOMICS, NPPSFA,              
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.SATO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN                    
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   17-NOV-05 1X6G    0                                                
JRNL        AUTH   M.SATO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA                 
JRNL        TITL   SOLUTION STRUCTURES OF THE SH3 DOMAIN OF HUMAN               
JRNL        TITL 2 MEGAKARYOCYTE-ASSOCIATED TYROSINE-PROTEIN KINASE.            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1X6G A    8    75  UNP    P42679   MATK_HUMAN      41    108             
SEQRES   1 A   81  GLY SER SER GLY SER SER GLY ARG MET PRO THR ARG ARG          
SEQRES   2 A   81  TRP ALA PRO GLY THR GLN CYS ILE THR LYS CYS GLU HIS          
SEQRES   3 A   81  THR ARG PRO LYS PRO GLY GLU LEU ALA PHE ARG LYS GLY          
SEQRES   4 A   81  ASP VAL VAL THR ILE LEU GLU ALA CYS GLU ASN LYS SER          
SEQRES   5 A   81  TRP TYR ARG VAL LYS HIS HIS THR SER GLY GLN GLU GLY          
SEQRES   6 A   81  LEU LEU ALA ALA GLY ALA LEU ARG GLU ARG SER GLY PRO          
SEQRES   7 A   81  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      31.692  57.088  35.548  1.00  0.00           N  
ATOM      2  CA  GLY A   1      32.634  56.373  34.702  1.00  0.00           C  
ATOM      3  C   GLY A   1      32.363  56.652  33.223  1.00  0.00           C  
ATOM      4  O   GLY A   1      31.237  56.968  32.843  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      33.652  56.672  34.952  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      32.560  55.303  34.894  1.00  0.00           H  
ATOM      7  H1  GLY A   1      30.823  56.619  35.703  1.00  0.00           H  
ATOM      8  N   SER A   2      33.415  56.528  32.428  1.00  0.00           N  
ATOM      9  CA  SER A   2      33.305  56.763  30.998  1.00  0.00           C  
ATOM     10  C   SER A   2      34.350  55.932  30.249  1.00  0.00           C  
ATOM     11  O   SER A   2      35.528  55.946  30.602  1.00  0.00           O  
ATOM     12  CB  SER A   2      33.473  58.248  30.670  1.00  0.00           C  
ATOM     13  OG  SER A   2      32.264  58.977  30.861  1.00  0.00           O  
ATOM     14  H   SER A   2      34.329  56.271  32.745  1.00  0.00           H  
ATOM     15  HA  SER A   2      32.298  56.444  30.730  1.00  0.00           H  
ATOM     16  HB2 SER A   2      34.255  58.671  31.299  1.00  0.00           H  
ATOM     17  HB3 SER A   2      33.803  58.355  29.636  1.00  0.00           H  
ATOM     18  HG  SER A   2      32.378  59.642  31.598  1.00  0.00           H  
ATOM     19  N   SER A   3      33.879  55.229  29.229  1.00  0.00           N  
ATOM     20  CA  SER A   3      34.758  54.394  28.428  1.00  0.00           C  
ATOM     21  C   SER A   3      34.805  54.914  26.990  1.00  0.00           C  
ATOM     22  O   SER A   3      33.878  55.583  26.537  1.00  0.00           O  
ATOM     23  CB  SER A   3      34.301  52.934  28.449  1.00  0.00           C  
ATOM     24  OG  SER A   3      35.345  52.054  28.855  1.00  0.00           O  
ATOM     25  H   SER A   3      32.919  55.224  28.949  1.00  0.00           H  
ATOM     26  HA  SER A   3      35.738  54.475  28.896  1.00  0.00           H  
ATOM     27  HB2 SER A   3      33.453  52.829  29.128  1.00  0.00           H  
ATOM     28  HB3 SER A   3      33.951  52.649  27.457  1.00  0.00           H  
ATOM     29  HG  SER A   3      36.230  52.416  28.564  1.00  0.00           H  
ATOM     30  N   GLY A   4      35.896  54.587  26.312  1.00  0.00           N  
ATOM     31  CA  GLY A   4      36.077  55.013  24.934  1.00  0.00           C  
ATOM     32  C   GLY A   4      35.414  54.032  23.965  1.00  0.00           C  
ATOM     33  O   GLY A   4      35.979  52.984  23.654  1.00  0.00           O  
ATOM     34  H   GLY A   4      36.645  54.043  26.687  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      35.650  56.008  24.798  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      37.140  55.089  24.710  1.00  0.00           H  
ATOM     37  N   SER A   5      34.224  54.405  23.516  1.00  0.00           N  
ATOM     38  CA  SER A   5      33.479  53.570  22.589  1.00  0.00           C  
ATOM     39  C   SER A   5      33.140  54.365  21.327  1.00  0.00           C  
ATOM     40  O   SER A   5      32.220  55.181  21.331  1.00  0.00           O  
ATOM     41  CB  SER A   5      32.201  53.034  23.238  1.00  0.00           C  
ATOM     42  OG  SER A   5      31.667  51.922  22.523  1.00  0.00           O  
ATOM     43  H   SER A   5      33.772  55.258  23.775  1.00  0.00           H  
ATOM     44  HA  SER A   5      34.142  52.739  22.351  1.00  0.00           H  
ATOM     45  HB2 SER A   5      32.414  52.735  24.264  1.00  0.00           H  
ATOM     46  HB3 SER A   5      31.457  53.828  23.283  1.00  0.00           H  
ATOM     47  HG  SER A   5      31.742  52.082  21.538  1.00  0.00           H  
ATOM     48  N   SER A   6      33.902  54.098  20.276  1.00  0.00           N  
ATOM     49  CA  SER A   6      33.693  54.778  19.009  1.00  0.00           C  
ATOM     50  C   SER A   6      32.842  53.908  18.082  1.00  0.00           C  
ATOM     51  O   SER A   6      31.730  54.287  17.717  1.00  0.00           O  
ATOM     52  CB  SER A   6      35.027  55.118  18.340  1.00  0.00           C  
ATOM     53  OG  SER A   6      35.282  56.520  18.338  1.00  0.00           O  
ATOM     54  H   SER A   6      34.648  53.432  20.280  1.00  0.00           H  
ATOM     55  HA  SER A   6      33.168  55.699  19.259  1.00  0.00           H  
ATOM     56  HB2 SER A   6      35.835  54.605  18.862  1.00  0.00           H  
ATOM     57  HB3 SER A   6      35.023  54.748  17.315  1.00  0.00           H  
ATOM     58  HG  SER A   6      35.939  56.750  19.055  1.00  0.00           H  
ATOM     59  N   GLY A   7      33.396  52.758  17.727  1.00  0.00           N  
ATOM     60  CA  GLY A   7      32.702  51.832  16.850  1.00  0.00           C  
ATOM     61  C   GLY A   7      33.082  50.384  17.169  1.00  0.00           C  
ATOM     62  O   GLY A   7      32.471  49.754  18.032  1.00  0.00           O  
ATOM     63  H   GLY A   7      34.301  52.457  18.028  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      31.625  51.960  16.958  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      32.947  52.054  15.812  1.00  0.00           H  
ATOM     66  N   ARG A   8      34.087  49.899  16.456  1.00  0.00           N  
ATOM     67  CA  ARG A   8      34.555  48.537  16.654  1.00  0.00           C  
ATOM     68  C   ARG A   8      36.085  48.503  16.691  1.00  0.00           C  
ATOM     69  O   ARG A   8      36.745  49.274  15.994  1.00  0.00           O  
ATOM     70  CB  ARG A   8      34.058  47.617  15.537  1.00  0.00           C  
ATOM     71  CG  ARG A   8      33.338  46.397  16.113  1.00  0.00           C  
ATOM     72  CD  ARG A   8      31.843  46.672  16.284  1.00  0.00           C  
ATOM     73  NE  ARG A   8      31.067  45.865  15.316  1.00  0.00           N  
ATOM     74  CZ  ARG A   8      29.749  45.640  15.411  1.00  0.00           C  
ATOM     75  NH1 ARG A   8      29.054  46.160  16.431  1.00  0.00           N  
ATOM     76  NH2 ARG A   8      29.128  44.896  14.486  1.00  0.00           N  
ATOM     77  H   ARG A   8      34.578  50.418  15.756  1.00  0.00           H  
ATOM     78  HA  ARG A   8      34.133  48.233  17.611  1.00  0.00           H  
ATOM     79  HB2 ARG A   8      33.383  48.167  14.882  1.00  0.00           H  
ATOM     80  HB3 ARG A   8      34.901  47.293  14.926  1.00  0.00           H  
ATOM     81  HG2 ARG A   8      33.481  45.540  15.454  1.00  0.00           H  
ATOM     82  HG3 ARG A   8      33.775  46.132  17.077  1.00  0.00           H  
ATOM     83  HD2 ARG A   8      31.534  46.431  17.301  1.00  0.00           H  
ATOM     84  HD3 ARG A   8      31.640  47.732  16.131  1.00  0.00           H  
ATOM     85  HE  ARG A   8      31.556  45.463  14.542  1.00  0.00           H  
ATOM     86 HH11 ARG A   8      29.517  46.715  17.122  1.00  0.00           H  
ATOM     87 HH12 ARG A   8      28.070  45.991  16.503  1.00  0.00           H  
ATOM     88 HH21 ARG A   8      29.647  44.509  13.724  1.00  0.00           H  
ATOM     89 HH22 ARG A   8      28.144  44.728  14.558  1.00  0.00           H  
ATOM     90  N   MET A   9      36.605  47.601  17.510  1.00  0.00           N  
ATOM     91  CA  MET A   9      38.044  47.456  17.647  1.00  0.00           C  
ATOM     92  C   MET A   9      38.435  45.984  17.797  1.00  0.00           C  
ATOM     93  O   MET A   9      37.653  45.179  18.300  1.00  0.00           O  
ATOM     94  CB  MET A   9      38.522  48.238  18.872  1.00  0.00           C  
ATOM     95  CG  MET A   9      38.492  49.744  18.607  1.00  0.00           C  
ATOM     96  SD  MET A   9      39.114  50.627  20.028  1.00  0.00           S  
ATOM     97  CE  MET A   9      40.363  51.633  19.246  1.00  0.00           C  
ATOM     98  H   MET A   9      36.062  46.978  18.073  1.00  0.00           H  
ATOM     99  HA  MET A   9      38.468  47.860  16.729  1.00  0.00           H  
ATOM    100  HB2 MET A   9      37.889  48.004  19.728  1.00  0.00           H  
ATOM    101  HB3 MET A   9      39.535  47.931  19.132  1.00  0.00           H  
ATOM    102  HG2 MET A   9      39.095  49.979  17.729  1.00  0.00           H  
ATOM    103  HG3 MET A   9      37.473  50.064  18.387  1.00  0.00           H  
ATOM    104  HE1 MET A   9      41.183  50.998  18.909  1.00  0.00           H  
ATOM    105  HE2 MET A   9      39.930  52.152  18.391  1.00  0.00           H  
ATOM    106  HE3 MET A   9      40.741  52.364  19.961  1.00  0.00           H  
ATOM    107  N   PRO A  10      39.676  45.670  17.339  1.00  0.00           N  
ATOM    108  CA  PRO A  10      40.180  44.309  17.416  1.00  0.00           C  
ATOM    109  C   PRO A  10      40.582  43.954  18.849  1.00  0.00           C  
ATOM    110  O   PRO A  10      40.682  44.832  19.705  1.00  0.00           O  
ATOM    111  CB  PRO A  10      41.348  44.266  16.444  1.00  0.00           C  
ATOM    112  CG  PRO A  10      41.747  45.714  16.207  1.00  0.00           C  
ATOM    113  CD  PRO A  10      40.629  46.598  16.736  1.00  0.00           C  
ATOM    114  HA  PRO A  10      39.463  43.659  17.164  1.00  0.00           H  
ATOM    115  HB2 PRO A  10      42.179  43.694  16.857  1.00  0.00           H  
ATOM    116  HB3 PRO A  10      41.061  43.782  15.511  1.00  0.00           H  
ATOM    117  HG2 PRO A  10      42.684  45.939  16.716  1.00  0.00           H  
ATOM    118  HG3 PRO A  10      41.908  45.896  15.145  1.00  0.00           H  
ATOM    119  HD2 PRO A  10      41.002  47.312  17.470  1.00  0.00           H  
ATOM    120  HD3 PRO A  10      40.167  47.174  15.935  1.00  0.00           H  
ATOM    121  N   THR A  11      40.800  42.665  19.066  1.00  0.00           N  
ATOM    122  CA  THR A  11      41.188  42.183  20.381  1.00  0.00           C  
ATOM    123  C   THR A  11      42.386  41.238  20.270  1.00  0.00           C  
ATOM    124  O   THR A  11      42.507  40.495  19.298  1.00  0.00           O  
ATOM    125  CB  THR A  11      39.962  41.536  21.029  1.00  0.00           C  
ATOM    126  OG1 THR A  11      40.430  41.106  22.304  1.00  0.00           O  
ATOM    127  CG2 THR A  11      39.545  40.243  20.329  1.00  0.00           C  
ATOM    128  H   THR A  11      40.716  41.957  18.365  1.00  0.00           H  
ATOM    129  HA  THR A  11      41.508  43.037  20.979  1.00  0.00           H  
ATOM    130  HB  THR A  11      39.131  42.240  21.076  1.00  0.00           H  
ATOM    131  HG1 THR A  11      39.897  41.544  23.029  1.00  0.00           H  
ATOM    132 HG21 THR A  11      38.922  39.650  21.001  1.00  0.00           H  
ATOM    133 HG22 THR A  11      38.980  40.483  19.428  1.00  0.00           H  
ATOM    134 HG23 THR A  11      40.434  39.671  20.059  1.00  0.00           H  
ATOM    135  N   ARG A  12      43.241  41.297  21.281  1.00  0.00           N  
ATOM    136  CA  ARG A  12      44.426  40.456  21.309  1.00  0.00           C  
ATOM    137  C   ARG A  12      44.743  40.034  22.745  1.00  0.00           C  
ATOM    138  O   ARG A  12      44.800  38.842  23.048  1.00  0.00           O  
ATOM    139  CB  ARG A  12      45.634  41.186  20.720  1.00  0.00           C  
ATOM    140  CG  ARG A  12      46.426  40.271  19.784  1.00  0.00           C  
ATOM    141  CD  ARG A  12      47.886  40.717  19.684  1.00  0.00           C  
ATOM    142  NE  ARG A  12      48.615  39.852  18.731  1.00  0.00           N  
ATOM    143  CZ  ARG A  12      49.076  38.630  19.027  1.00  0.00           C  
ATOM    144  NH1 ARG A  12      48.885  38.120  20.251  1.00  0.00           N  
ATOM    145  NH2 ARG A  12      49.728  37.916  18.099  1.00  0.00           N  
ATOM    146  H   ARG A  12      43.136  41.904  22.068  1.00  0.00           H  
ATOM    147  HA  ARG A  12      44.169  39.593  20.695  1.00  0.00           H  
ATOM    148  HB2 ARG A  12      45.301  42.069  20.176  1.00  0.00           H  
ATOM    149  HB3 ARG A  12      46.281  41.534  21.526  1.00  0.00           H  
ATOM    150  HG2 ARG A  12      46.380  39.245  20.148  1.00  0.00           H  
ATOM    151  HG3 ARG A  12      45.970  40.277  18.793  1.00  0.00           H  
ATOM    152  HD2 ARG A  12      47.935  41.756  19.357  1.00  0.00           H  
ATOM    153  HD3 ARG A  12      48.357  40.669  20.665  1.00  0.00           H  
ATOM    154  HE  ARG A  12      48.775  40.203  17.808  1.00  0.00           H  
ATOM    155 HH11 ARG A  12      48.399  38.652  20.944  1.00  0.00           H  
ATOM    156 HH12 ARG A  12      49.229  37.207  20.473  1.00  0.00           H  
ATOM    157 HH21 ARG A  12      49.871  38.296  17.185  1.00  0.00           H  
ATOM    158 HH22 ARG A  12      50.072  37.004  18.320  1.00  0.00           H  
ATOM    159  N   ARG A  13      44.941  41.034  23.591  1.00  0.00           N  
ATOM    160  CA  ARG A  13      45.252  40.782  24.988  1.00  0.00           C  
ATOM    161  C   ARG A  13      44.000  40.311  25.733  1.00  0.00           C  
ATOM    162  O   ARG A  13      42.904  40.310  25.175  1.00  0.00           O  
ATOM    163  CB  ARG A  13      45.798  42.039  25.668  1.00  0.00           C  
ATOM    164  CG  ARG A  13      47.112  42.483  25.021  1.00  0.00           C  
ATOM    165  CD  ARG A  13      48.220  41.459  25.272  1.00  0.00           C  
ATOM    166  NE  ARG A  13      49.514  42.150  25.465  1.00  0.00           N  
ATOM    167  CZ  ARG A  13      50.685  41.519  25.636  1.00  0.00           C  
ATOM    168  NH1 ARG A  13      50.730  40.180  25.639  1.00  0.00           N  
ATOM    169  NH2 ARG A  13      51.810  42.229  25.804  1.00  0.00           N  
ATOM    170  H   ARG A  13      44.893  42.000  23.337  1.00  0.00           H  
ATOM    171  HA  ARG A  13      46.012  40.002  24.968  1.00  0.00           H  
ATOM    172  HB2 ARG A  13      45.064  42.842  25.598  1.00  0.00           H  
ATOM    173  HB3 ARG A  13      45.957  41.844  26.727  1.00  0.00           H  
ATOM    174  HG2 ARG A  13      46.968  42.614  23.949  1.00  0.00           H  
ATOM    175  HG3 ARG A  13      47.409  43.452  25.424  1.00  0.00           H  
ATOM    176  HD2 ARG A  13      47.983  40.862  26.153  1.00  0.00           H  
ATOM    177  HD3 ARG A  13      48.288  40.771  24.430  1.00  0.00           H  
ATOM    178  HE  ARG A  13      49.516  43.150  25.468  1.00  0.00           H  
ATOM    179 HH11 ARG A  13      49.891  39.651  25.514  1.00  0.00           H  
ATOM    180 HH12 ARG A  13      51.603  39.710  25.767  1.00  0.00           H  
ATOM    181 HH21 ARG A  13      51.775  43.228  25.802  1.00  0.00           H  
ATOM    182 HH22 ARG A  13      52.682  41.759  25.932  1.00  0.00           H  
ATOM    183  N   TRP A  14      44.206  39.923  26.983  1.00  0.00           N  
ATOM    184  CA  TRP A  14      43.108  39.451  27.811  1.00  0.00           C  
ATOM    185  C   TRP A  14      42.319  40.672  28.290  1.00  0.00           C  
ATOM    186  O   TRP A  14      42.859  41.775  28.364  1.00  0.00           O  
ATOM    187  CB  TRP A  14      43.621  38.583  28.960  1.00  0.00           C  
ATOM    188  CG  TRP A  14      44.304  37.290  28.506  1.00  0.00           C  
ATOM    189  CD1 TRP A  14      43.823  36.349  27.683  1.00  0.00           C  
ATOM    190  CD2 TRP A  14      45.619  36.834  28.885  1.00  0.00           C  
ATOM    191  NE1 TRP A  14      44.729  35.322  27.505  1.00  0.00           N  
ATOM    192  CE2 TRP A  14      45.856  35.627  28.259  1.00  0.00           C  
ATOM    193  CE3 TRP A  14      46.578  37.421  29.729  1.00  0.00           C  
ATOM    194  CZ2 TRP A  14      47.046  34.905  28.411  1.00  0.00           C  
ATOM    195  CZ3 TRP A  14      47.761  36.688  29.870  1.00  0.00           C  
ATOM    196  CH2 TRP A  14      48.015  35.471  29.247  1.00  0.00           C  
ATOM    197  H   TRP A  14      45.100  39.928  27.431  1.00  0.00           H  
ATOM    198  HA  TRP A  14      42.473  38.817  27.192  1.00  0.00           H  
ATOM    199  HB2 TRP A  14      44.325  39.164  29.555  1.00  0.00           H  
ATOM    200  HB3 TRP A  14      42.785  38.329  29.612  1.00  0.00           H  
ATOM    201  HD1 TRP A  14      42.841  36.387  27.213  1.00  0.00           H  
ATOM    202  HE1 TRP A  14      44.586  34.436  26.886  1.00  0.00           H  
ATOM    203  HE3 TRP A  14      46.415  38.374  30.235  1.00  0.00           H  
ATOM    204  HZ2 TRP A  14      47.209  33.954  27.905  1.00  0.00           H  
ATOM    205  HZ3 TRP A  14      48.539  37.098  30.515  1.00  0.00           H  
ATOM    206  HH2 TRP A  14      48.964  34.960  29.409  1.00  0.00           H  
ATOM    207  N   ALA A  15      41.054  40.434  28.604  1.00  0.00           N  
ATOM    208  CA  ALA A  15      40.186  41.499  29.076  1.00  0.00           C  
ATOM    209  C   ALA A  15      39.940  41.327  30.576  1.00  0.00           C  
ATOM    210  O   ALA A  15      40.350  40.326  31.164  1.00  0.00           O  
ATOM    211  CB  ALA A  15      38.887  41.494  28.267  1.00  0.00           C  
ATOM    212  H   ALA A  15      40.622  39.533  28.542  1.00  0.00           H  
ATOM    213  HA  ALA A  15      40.701  42.446  28.906  1.00  0.00           H  
ATOM    214  HB1 ALA A  15      38.967  40.771  27.456  1.00  0.00           H  
ATOM    215  HB2 ALA A  15      38.056  41.220  28.917  1.00  0.00           H  
ATOM    216  HB3 ALA A  15      38.713  42.487  27.854  1.00  0.00           H  
ATOM    217  N   PRO A  16      39.256  42.342  31.166  1.00  0.00           N  
ATOM    218  CA  PRO A  16      38.951  42.311  32.587  1.00  0.00           C  
ATOM    219  C   PRO A  16      37.817  41.328  32.884  1.00  0.00           C  
ATOM    220  O   PRO A  16      36.694  41.513  32.419  1.00  0.00           O  
ATOM    221  CB  PRO A  16      38.602  43.746  32.945  1.00  0.00           C  
ATOM    222  CG  PRO A  16      38.272  44.435  31.631  1.00  0.00           C  
ATOM    223  CD  PRO A  16      38.756  43.541  30.502  1.00  0.00           C  
ATOM    224  HA  PRO A  16      39.741  41.982  33.104  1.00  0.00           H  
ATOM    225  HB2 PRO A  16      37.754  43.783  33.628  1.00  0.00           H  
ATOM    226  HB3 PRO A  16      39.436  44.239  33.446  1.00  0.00           H  
ATOM    227  HG2 PRO A  16      37.198  44.607  31.549  1.00  0.00           H  
ATOM    228  HG3 PRO A  16      38.755  45.411  31.580  1.00  0.00           H  
ATOM    229  HD2 PRO A  16      37.947  43.303  29.810  1.00  0.00           H  
ATOM    230  HD3 PRO A  16      39.539  44.027  29.920  1.00  0.00           H  
ATOM    231  N   GLY A  17      38.151  40.304  33.654  1.00  0.00           N  
ATOM    232  CA  GLY A  17      37.175  39.291  34.018  1.00  0.00           C  
ATOM    233  C   GLY A  17      37.619  37.906  33.545  1.00  0.00           C  
ATOM    234  O   GLY A  17      36.947  36.911  33.809  1.00  0.00           O  
ATOM    235  H   GLY A  17      39.067  40.160  34.028  1.00  0.00           H  
ATOM    236  HA2 GLY A  17      37.039  39.283  35.100  1.00  0.00           H  
ATOM    237  HA3 GLY A  17      36.209  39.537  33.578  1.00  0.00           H  
ATOM    238  N   THR A  18      38.749  37.887  32.854  1.00  0.00           N  
ATOM    239  CA  THR A  18      39.291  36.640  32.340  1.00  0.00           C  
ATOM    240  C   THR A  18      40.214  35.993  33.374  1.00  0.00           C  
ATOM    241  O   THR A  18      41.046  36.669  33.979  1.00  0.00           O  
ATOM    242  CB  THR A  18      39.985  36.939  31.009  1.00  0.00           C  
ATOM    243  OG1 THR A  18      38.914  37.215  30.113  1.00  0.00           O  
ATOM    244  CG2 THR A  18      40.662  35.702  30.411  1.00  0.00           C  
ATOM    245  H   THR A  18      39.291  38.701  32.643  1.00  0.00           H  
ATOM    246  HA  THR A  18      38.465  35.949  32.173  1.00  0.00           H  
ATOM    247  HB  THR A  18      40.697  37.757  31.116  1.00  0.00           H  
ATOM    248  HG1 THR A  18      38.336  36.406  30.011  1.00  0.00           H  
ATOM    249 HG21 THR A  18      40.274  35.527  29.408  1.00  0.00           H  
ATOM    250 HG22 THR A  18      41.738  35.866  30.362  1.00  0.00           H  
ATOM    251 HG23 THR A  18      40.454  34.836  31.038  1.00  0.00           H  
ATOM    252  N   GLN A  19      40.037  34.692  33.548  1.00  0.00           N  
ATOM    253  CA  GLN A  19      40.842  33.946  34.499  1.00  0.00           C  
ATOM    254  C   GLN A  19      42.181  33.554  33.870  1.00  0.00           C  
ATOM    255  O   GLN A  19      42.214  32.822  32.882  1.00  0.00           O  
ATOM    256  CB  GLN A  19      40.092  32.713  35.006  1.00  0.00           C  
ATOM    257  CG  GLN A  19      38.984  33.108  35.984  1.00  0.00           C  
ATOM    258  CD  GLN A  19      38.153  31.890  36.393  1.00  0.00           C  
ATOM    259  OE1 GLN A  19      38.165  30.854  35.749  1.00  0.00           O  
ATOM    260  NE2 GLN A  19      37.434  32.072  37.496  1.00  0.00           N  
ATOM    261  H   GLN A  19      39.358  34.149  33.052  1.00  0.00           H  
ATOM    262  HA  GLN A  19      41.012  34.628  35.333  1.00  0.00           H  
ATOM    263  HB2 GLN A  19      39.662  32.172  34.162  1.00  0.00           H  
ATOM    264  HB3 GLN A  19      40.790  32.034  35.496  1.00  0.00           H  
ATOM    265  HG2 GLN A  19      39.422  33.568  36.870  1.00  0.00           H  
ATOM    266  HG3 GLN A  19      38.337  33.855  35.523  1.00  0.00           H  
ATOM    267 HE21 GLN A  19      37.469  32.948  37.977  1.00  0.00           H  
ATOM    268 HE22 GLN A  19      36.857  31.333  37.845  1.00  0.00           H  
ATOM    269  N   CYS A  20      43.250  34.059  34.467  1.00  0.00           N  
ATOM    270  CA  CYS A  20      44.587  33.770  33.977  1.00  0.00           C  
ATOM    271  C   CYS A  20      45.296  32.887  35.005  1.00  0.00           C  
ATOM    272  O   CYS A  20      44.968  32.924  36.191  1.00  0.00           O  
ATOM    273  CB  CYS A  20      45.372  35.051  33.687  1.00  0.00           C  
ATOM    274  SG  CYS A  20      44.471  36.073  32.465  1.00  0.00           S  
ATOM    275  H   CYS A  20      43.213  34.653  35.271  1.00  0.00           H  
ATOM    276  HA  CYS A  20      44.466  33.241  33.031  1.00  0.00           H  
ATOM    277  HB2 CYS A  20      45.517  35.615  34.608  1.00  0.00           H  
ATOM    278  HB3 CYS A  20      46.362  34.802  33.305  1.00  0.00           H  
ATOM    279  HG  CYS A  20      43.251  35.710  32.851  1.00  0.00           H  
ATOM    280  N   ILE A  21      46.254  32.114  34.515  1.00  0.00           N  
ATOM    281  CA  ILE A  21      47.012  31.223  35.377  1.00  0.00           C  
ATOM    282  C   ILE A  21      48.485  31.636  35.362  1.00  0.00           C  
ATOM    283  O   ILE A  21      48.970  32.180  34.369  1.00  0.00           O  
ATOM    284  CB  ILE A  21      46.777  29.765  34.979  1.00  0.00           C  
ATOM    285  CG1 ILE A  21      45.312  29.525  34.609  1.00  0.00           C  
ATOM    286  CG2 ILE A  21      47.253  28.813  36.079  1.00  0.00           C  
ATOM    287  CD1 ILE A  21      44.378  30.048  35.703  1.00  0.00           C  
ATOM    288  H   ILE A  21      46.514  32.090  33.549  1.00  0.00           H  
ATOM    289  HA  ILE A  21      46.630  31.346  36.391  1.00  0.00           H  
ATOM    290  HB  ILE A  21      47.372  29.554  34.091  1.00  0.00           H  
ATOM    291 HG12 ILE A  21      45.086  30.022  33.665  1.00  0.00           H  
ATOM    292 HG13 ILE A  21      45.141  28.460  34.458  1.00  0.00           H  
ATOM    293 HG21 ILE A  21      46.536  28.817  36.898  1.00  0.00           H  
ATOM    294 HG22 ILE A  21      47.338  27.805  35.674  1.00  0.00           H  
ATOM    295 HG23 ILE A  21      48.226  29.140  36.446  1.00  0.00           H  
ATOM    296 HD11 ILE A  21      43.615  29.301  35.916  1.00  0.00           H  
ATOM    297 HD12 ILE A  21      44.954  30.248  36.607  1.00  0.00           H  
ATOM    298 HD13 ILE A  21      43.903  30.969  35.365  1.00  0.00           H  
ATOM    299  N   THR A  22      49.155  31.362  36.471  1.00  0.00           N  
ATOM    300  CA  THR A  22      50.563  31.699  36.596  1.00  0.00           C  
ATOM    301  C   THR A  22      51.429  30.628  35.931  1.00  0.00           C  
ATOM    302  O   THR A  22      51.113  29.441  35.994  1.00  0.00           O  
ATOM    303  CB  THR A  22      50.873  31.892  38.082  1.00  0.00           C  
ATOM    304  OG1 THR A  22      50.470  30.664  38.684  1.00  0.00           O  
ATOM    305  CG2 THR A  22      49.970  32.940  38.736  1.00  0.00           C  
ATOM    306  H   THR A  22      48.753  30.920  37.273  1.00  0.00           H  
ATOM    307  HA  THR A  22      50.742  32.632  36.063  1.00  0.00           H  
ATOM    308  HB  THR A  22      51.924  32.137  38.233  1.00  0.00           H  
ATOM    309  HG1 THR A  22      50.886  30.575  39.588  1.00  0.00           H  
ATOM    310 HG21 THR A  22      50.486  33.900  38.763  1.00  0.00           H  
ATOM    311 HG22 THR A  22      49.050  33.039  38.160  1.00  0.00           H  
ATOM    312 HG23 THR A  22      49.729  32.629  39.753  1.00  0.00           H  
ATOM    313  N   LYS A  23      52.505  31.086  35.307  1.00  0.00           N  
ATOM    314  CA  LYS A  23      53.418  30.182  34.630  1.00  0.00           C  
ATOM    315  C   LYS A  23      54.382  29.575  35.653  1.00  0.00           C  
ATOM    316  O   LYS A  23      54.797  28.426  35.514  1.00  0.00           O  
ATOM    317  CB  LYS A  23      54.120  30.896  33.473  1.00  0.00           C  
ATOM    318  CG  LYS A  23      53.455  30.559  32.136  1.00  0.00           C  
ATOM    319  CD  LYS A  23      54.038  31.407  31.005  1.00  0.00           C  
ATOM    320  CE  LYS A  23      53.278  32.727  30.860  1.00  0.00           C  
ATOM    321  NZ  LYS A  23      53.429  33.265  29.490  1.00  0.00           N  
ATOM    322  H   LYS A  23      52.755  32.052  35.260  1.00  0.00           H  
ATOM    323  HA  LYS A  23      52.822  29.378  34.198  1.00  0.00           H  
ATOM    324  HB2 LYS A  23      54.093  31.973  33.635  1.00  0.00           H  
ATOM    325  HB3 LYS A  23      55.170  30.604  33.444  1.00  0.00           H  
ATOM    326  HG2 LYS A  23      53.595  29.502  31.913  1.00  0.00           H  
ATOM    327  HG3 LYS A  23      52.381  30.730  32.207  1.00  0.00           H  
ATOM    328  HD2 LYS A  23      55.091  31.609  31.203  1.00  0.00           H  
ATOM    329  HD3 LYS A  23      53.991  30.852  30.068  1.00  0.00           H  
ATOM    330  HE2 LYS A  23      52.223  32.571  31.083  1.00  0.00           H  
ATOM    331  HE3 LYS A  23      53.653  33.450  31.584  1.00  0.00           H  
ATOM    332  HZ1 LYS A  23      52.588  33.737  29.224  1.00  0.00           H  
ATOM    333  HZ2 LYS A  23      54.194  33.908  29.467  1.00  0.00           H  
ATOM    334  HZ3 LYS A  23      53.605  32.514  28.855  1.00  0.00           H  
ATOM    335  N   CYS A  24      54.708  30.376  36.657  1.00  0.00           N  
ATOM    336  CA  CYS A  24      55.614  29.933  37.702  1.00  0.00           C  
ATOM    337  C   CYS A  24      55.046  30.379  39.051  1.00  0.00           C  
ATOM    338  O   CYS A  24      54.014  31.046  39.104  1.00  0.00           O  
ATOM    339  CB  CYS A  24      57.034  30.457  37.480  1.00  0.00           C  
ATOM    340  SG  CYS A  24      57.820  29.564  36.089  1.00  0.00           S  
ATOM    341  H   CYS A  24      54.366  31.310  36.762  1.00  0.00           H  
ATOM    342  HA  CYS A  24      55.656  28.846  37.641  1.00  0.00           H  
ATOM    343  HB2 CYS A  24      57.007  31.526  37.269  1.00  0.00           H  
ATOM    344  HB3 CYS A  24      57.626  30.327  38.387  1.00  0.00           H  
ATOM    345  HG  CYS A  24      58.166  28.489  36.791  1.00  0.00           H  
ATOM    346  N   GLU A  25      55.745  29.994  40.108  1.00  0.00           N  
ATOM    347  CA  GLU A  25      55.323  30.346  41.454  1.00  0.00           C  
ATOM    348  C   GLU A  25      56.148  31.523  41.977  1.00  0.00           C  
ATOM    349  O   GLU A  25      57.360  31.573  41.779  1.00  0.00           O  
ATOM    350  CB  GLU A  25      55.427  29.143  42.393  1.00  0.00           C  
ATOM    351  CG  GLU A  25      56.886  28.843  42.742  1.00  0.00           C  
ATOM    352  CD  GLU A  25      57.159  27.338  42.711  1.00  0.00           C  
ATOM    353  OE1 GLU A  25      56.639  26.649  43.616  1.00  0.00           O  
ATOM    354  OE2 GLU A  25      57.881  26.911  41.785  1.00  0.00           O  
ATOM    355  H   GLU A  25      56.584  29.451  40.058  1.00  0.00           H  
ATOM    356  HA  GLU A  25      54.278  30.638  41.362  1.00  0.00           H  
ATOM    357  HB2 GLU A  25      54.865  29.341  43.306  1.00  0.00           H  
ATOM    358  HB3 GLU A  25      54.975  28.270  41.924  1.00  0.00           H  
ATOM    359  HG2 GLU A  25      57.544  29.349  42.035  1.00  0.00           H  
ATOM    360  HG3 GLU A  25      57.117  29.239  43.731  1.00  0.00           H  
ATOM    361  N   HIS A  26      55.457  32.442  42.635  1.00  0.00           N  
ATOM    362  CA  HIS A  26      56.109  33.617  43.189  1.00  0.00           C  
ATOM    363  C   HIS A  26      55.789  33.726  44.681  1.00  0.00           C  
ATOM    364  O   HIS A  26      54.675  34.090  45.055  1.00  0.00           O  
ATOM    365  CB  HIS A  26      55.724  34.873  42.405  1.00  0.00           C  
ATOM    366  CG  HIS A  26      56.858  35.853  42.220  1.00  0.00           C  
ATOM    367  ND1 HIS A  26      58.170  35.455  42.032  1.00  0.00           N  
ATOM    368  CD2 HIS A  26      56.862  37.217  42.195  1.00  0.00           C  
ATOM    369  CE1 HIS A  26      58.921  36.539  41.902  1.00  0.00           C  
ATOM    370  NE2 HIS A  26      58.109  37.629  42.003  1.00  0.00           N  
ATOM    371  H   HIS A  26      54.470  32.394  42.792  1.00  0.00           H  
ATOM    372  HA  HIS A  26      57.182  33.465  43.067  1.00  0.00           H  
ATOM    373  HB2 HIS A  26      55.349  34.576  41.426  1.00  0.00           H  
ATOM    374  HB3 HIS A  26      54.905  35.374  42.921  1.00  0.00           H  
ATOM    375  HD1 HIS A  26      58.496  34.510  41.999  1.00  0.00           H  
ATOM    376  HD2 HIS A  26      55.989  37.859  42.312  1.00  0.00           H  
ATOM    377  HE1 HIS A  26      59.999  36.556  41.741  1.00  0.00           H  
ATOM    378  N   THR A  27      56.785  33.406  45.493  1.00  0.00           N  
ATOM    379  CA  THR A  27      56.623  33.464  46.935  1.00  0.00           C  
ATOM    380  C   THR A  27      57.088  34.821  47.470  1.00  0.00           C  
ATOM    381  O   THR A  27      56.619  35.274  48.513  1.00  0.00           O  
ATOM    382  CB  THR A  27      57.379  32.281  47.544  1.00  0.00           C  
ATOM    383  OG1 THR A  27      58.743  32.694  47.528  1.00  0.00           O  
ATOM    384  CG2 THR A  27      57.354  31.044  46.644  1.00  0.00           C  
ATOM    385  H   THR A  27      57.689  33.111  45.180  1.00  0.00           H  
ATOM    386  HA  THR A  27      55.562  33.376  47.166  1.00  0.00           H  
ATOM    387  HB  THR A  27      56.999  32.046  48.539  1.00  0.00           H  
ATOM    388  HG1 THR A  27      59.009  32.958  46.601  1.00  0.00           H  
ATOM    389 HG21 THR A  27      57.472  30.148  47.253  1.00  0.00           H  
ATOM    390 HG22 THR A  27      56.402  31.000  46.113  1.00  0.00           H  
ATOM    391 HG23 THR A  27      58.169  31.103  45.923  1.00  0.00           H  
ATOM    392  N   ARG A  28      58.001  35.431  46.730  1.00  0.00           N  
ATOM    393  CA  ARG A  28      58.534  36.726  47.116  1.00  0.00           C  
ATOM    394  C   ARG A  28      58.553  37.672  45.914  1.00  0.00           C  
ATOM    395  O   ARG A  28      59.528  37.712  45.166  1.00  0.00           O  
ATOM    396  CB  ARG A  28      59.952  36.595  47.676  1.00  0.00           C  
ATOM    397  CG  ARG A  28      59.934  35.991  49.081  1.00  0.00           C  
ATOM    398  CD  ARG A  28      60.316  37.035  50.131  1.00  0.00           C  
ATOM    399  NE  ARG A  28      61.554  36.621  50.829  1.00  0.00           N  
ATOM    400  CZ  ARG A  28      62.020  37.204  51.942  1.00  0.00           C  
ATOM    401  NH1 ARG A  28      61.355  38.229  52.490  1.00  0.00           N  
ATOM    402  NH2 ARG A  28      63.152  36.762  52.505  1.00  0.00           N  
ATOM    403  H   ARG A  28      58.377  35.055  45.883  1.00  0.00           H  
ATOM    404  HA  ARG A  28      57.855  37.087  47.889  1.00  0.00           H  
ATOM    405  HB2 ARG A  28      60.550  35.968  47.014  1.00  0.00           H  
ATOM    406  HB3 ARG A  28      60.428  37.575  47.703  1.00  0.00           H  
ATOM    407  HG2 ARG A  28      58.941  35.597  49.298  1.00  0.00           H  
ATOM    408  HG3 ARG A  28      60.626  35.151  49.128  1.00  0.00           H  
ATOM    409  HD2 ARG A  28      60.463  38.004  49.657  1.00  0.00           H  
ATOM    410  HD3 ARG A  28      59.505  37.152  50.851  1.00  0.00           H  
ATOM    411  HE  ARG A  28      62.076  35.859  50.446  1.00  0.00           H  
ATOM    412 HH11 ARG A  28      60.510  38.559  52.069  1.00  0.00           H  
ATOM    413 HH12 ARG A  28      61.703  38.664  53.320  1.00  0.00           H  
ATOM    414 HH21 ARG A  28      63.650  35.997  52.096  1.00  0.00           H  
ATOM    415 HH22 ARG A  28      63.501  37.198  53.336  1.00  0.00           H  
ATOM    416  N   PRO A  29      57.434  38.430  45.762  1.00  0.00           N  
ATOM    417  CA  PRO A  29      57.313  39.374  44.663  1.00  0.00           C  
ATOM    418  C   PRO A  29      58.165  40.619  44.913  1.00  0.00           C  
ATOM    419  O   PRO A  29      58.761  40.765  45.980  1.00  0.00           O  
ATOM    420  CB  PRO A  29      55.827  39.680  44.569  1.00  0.00           C  
ATOM    421  CG  PRO A  29      55.230  39.263  45.904  1.00  0.00           C  
ATOM    422  CD  PRO A  29      56.259  38.410  46.628  1.00  0.00           C  
ATOM    423  HA  PRO A  29      57.662  38.969  43.818  1.00  0.00           H  
ATOM    424  HB2 PRO A  29      55.657  40.740  44.379  1.00  0.00           H  
ATOM    425  HB3 PRO A  29      55.366  39.131  43.747  1.00  0.00           H  
ATOM    426  HG2 PRO A  29      54.975  40.141  46.498  1.00  0.00           H  
ATOM    427  HG3 PRO A  29      54.308  38.702  45.751  1.00  0.00           H  
ATOM    428  HD2 PRO A  29      56.487  38.817  47.614  1.00  0.00           H  
ATOM    429  HD3 PRO A  29      55.896  37.394  46.778  1.00  0.00           H  
ATOM    430  N   LYS A  30      58.196  41.488  43.913  1.00  0.00           N  
ATOM    431  CA  LYS A  30      58.965  42.716  44.011  1.00  0.00           C  
ATOM    432  C   LYS A  30      58.394  43.581  45.137  1.00  0.00           C  
ATOM    433  O   LYS A  30      57.381  43.232  45.741  1.00  0.00           O  
ATOM    434  CB  LYS A  30      59.018  43.425  42.656  1.00  0.00           C  
ATOM    435  CG  LYS A  30      60.452  43.489  42.127  1.00  0.00           C  
ATOM    436  CD  LYS A  30      60.717  44.821  41.420  1.00  0.00           C  
ATOM    437  CE  LYS A  30      61.338  44.596  40.041  1.00  0.00           C  
ATOM    438  NZ  LYS A  30      62.779  44.934  40.060  1.00  0.00           N  
ATOM    439  H   LYS A  30      57.708  41.362  43.049  1.00  0.00           H  
ATOM    440  HA  LYS A  30      59.987  42.441  44.271  1.00  0.00           H  
ATOM    441  HB2 LYS A  30      58.385  42.899  41.941  1.00  0.00           H  
ATOM    442  HB3 LYS A  30      58.616  44.434  42.754  1.00  0.00           H  
ATOM    443  HG2 LYS A  30      61.154  43.365  42.951  1.00  0.00           H  
ATOM    444  HG3 LYS A  30      60.625  42.666  41.434  1.00  0.00           H  
ATOM    445  HD2 LYS A  30      59.783  45.373  41.317  1.00  0.00           H  
ATOM    446  HD3 LYS A  30      61.383  45.432  42.028  1.00  0.00           H  
ATOM    447  HE2 LYS A  30      61.206  43.556  39.742  1.00  0.00           H  
ATOM    448  HE3 LYS A  30      60.824  45.207  39.299  1.00  0.00           H  
ATOM    449  HZ1 LYS A  30      63.099  45.083  39.124  1.00  0.00           H  
ATOM    450  HZ2 LYS A  30      62.918  45.767  40.596  1.00  0.00           H  
ATOM    451  HZ3 LYS A  30      63.292  44.182  40.472  1.00  0.00           H  
ATOM    452  N   PRO A  31      59.086  44.725  45.390  1.00  0.00           N  
ATOM    453  CA  PRO A  31      58.658  45.643  46.432  1.00  0.00           C  
ATOM    454  C   PRO A  31      57.432  46.443  45.988  1.00  0.00           C  
ATOM    455  O   PRO A  31      57.564  47.496  45.367  1.00  0.00           O  
ATOM    456  CB  PRO A  31      59.870  46.518  46.706  1.00  0.00           C  
ATOM    457  CG  PRO A  31      60.776  46.368  45.494  1.00  0.00           C  
ATOM    458  CD  PRO A  31      60.289  45.172  44.694  1.00  0.00           C  
ATOM    459  HA  PRO A  31      58.375  45.136  47.246  1.00  0.00           H  
ATOM    460  HB2 PRO A  31      59.577  47.558  46.849  1.00  0.00           H  
ATOM    461  HB3 PRO A  31      60.381  46.204  47.617  1.00  0.00           H  
ATOM    462  HG2 PRO A  31      60.750  47.272  44.885  1.00  0.00           H  
ATOM    463  HG3 PRO A  31      61.810  46.224  45.806  1.00  0.00           H  
ATOM    464  HD2 PRO A  31      60.071  45.448  43.662  1.00  0.00           H  
ATOM    465  HD3 PRO A  31      61.043  44.385  44.660  1.00  0.00           H  
ATOM    466  N   GLY A  32      56.265  45.912  46.324  1.00  0.00           N  
ATOM    467  CA  GLY A  32      55.016  46.563  45.969  1.00  0.00           C  
ATOM    468  C   GLY A  32      54.220  45.716  44.973  1.00  0.00           C  
ATOM    469  O   GLY A  32      53.381  46.237  44.240  1.00  0.00           O  
ATOM    470  H   GLY A  32      56.167  45.055  46.830  1.00  0.00           H  
ATOM    471  HA2 GLY A  32      54.421  46.731  46.866  1.00  0.00           H  
ATOM    472  HA3 GLY A  32      55.223  47.541  45.534  1.00  0.00           H  
ATOM    473  N   GLU A  33      54.511  44.422  44.981  1.00  0.00           N  
ATOM    474  CA  GLU A  33      53.833  43.498  44.088  1.00  0.00           C  
ATOM    475  C   GLU A  33      53.084  42.435  44.895  1.00  0.00           C  
ATOM    476  O   GLU A  33      53.252  42.339  46.109  1.00  0.00           O  
ATOM    477  CB  GLU A  33      54.820  42.853  43.115  1.00  0.00           C  
ATOM    478  CG  GLU A  33      55.103  43.776  41.927  1.00  0.00           C  
ATOM    479  CD  GLU A  33      56.059  43.114  40.933  1.00  0.00           C  
ATOM    480  OE1 GLU A  33      56.136  41.867  40.964  1.00  0.00           O  
ATOM    481  OE2 GLU A  33      56.689  43.870  40.163  1.00  0.00           O  
ATOM    482  H   GLU A  33      55.194  44.007  45.581  1.00  0.00           H  
ATOM    483  HA  GLU A  33      53.122  44.105  43.528  1.00  0.00           H  
ATOM    484  HB2 GLU A  33      55.752  42.625  43.632  1.00  0.00           H  
ATOM    485  HB3 GLU A  33      54.416  41.906  42.755  1.00  0.00           H  
ATOM    486  HG2 GLU A  33      54.168  44.028  41.427  1.00  0.00           H  
ATOM    487  HG3 GLU A  33      55.534  44.712  42.285  1.00  0.00           H  
ATOM    488  N   LEU A  34      52.272  41.664  44.186  1.00  0.00           N  
ATOM    489  CA  LEU A  34      51.497  40.613  44.820  1.00  0.00           C  
ATOM    490  C   LEU A  34      52.240  39.282  44.683  1.00  0.00           C  
ATOM    491  O   LEU A  34      53.055  39.113  43.777  1.00  0.00           O  
ATOM    492  CB  LEU A  34      50.074  40.581  44.258  1.00  0.00           C  
ATOM    493  CG  LEU A  34      49.354  39.232  44.327  1.00  0.00           C  
ATOM    494  CD1 LEU A  34      48.806  38.975  45.732  1.00  0.00           C  
ATOM    495  CD2 LEU A  34      48.262  39.139  43.259  1.00  0.00           C  
ATOM    496  H   LEU A  34      52.140  41.749  43.198  1.00  0.00           H  
ATOM    497  HA  LEU A  34      51.419  40.857  45.880  1.00  0.00           H  
ATOM    498  HB2 LEU A  34      49.476  41.318  44.796  1.00  0.00           H  
ATOM    499  HB3 LEU A  34      50.110  40.900  43.217  1.00  0.00           H  
ATOM    500  HG  LEU A  34      50.080  38.448  44.115  1.00  0.00           H  
ATOM    501 HD11 LEU A  34      48.890  37.914  45.965  1.00  0.00           H  
ATOM    502 HD12 LEU A  34      49.378  39.553  46.457  1.00  0.00           H  
ATOM    503 HD13 LEU A  34      47.758  39.275  45.774  1.00  0.00           H  
ATOM    504 HD21 LEU A  34      47.301  38.948  43.738  1.00  0.00           H  
ATOM    505 HD22 LEU A  34      48.214  40.077  42.706  1.00  0.00           H  
ATOM    506 HD23 LEU A  34      48.494  38.325  42.574  1.00  0.00           H  
ATOM    507  N   ALA A  35      51.934  38.372  45.596  1.00  0.00           N  
ATOM    508  CA  ALA A  35      52.564  37.062  45.587  1.00  0.00           C  
ATOM    509  C   ALA A  35      51.542  36.012  45.147  1.00  0.00           C  
ATOM    510  O   ALA A  35      50.340  36.193  45.338  1.00  0.00           O  
ATOM    511  CB  ALA A  35      53.145  36.766  46.971  1.00  0.00           C  
ATOM    512  H   ALA A  35      51.270  38.517  46.330  1.00  0.00           H  
ATOM    513  HA  ALA A  35      53.378  37.091  44.864  1.00  0.00           H  
ATOM    514  HB1 ALA A  35      54.072  36.204  46.865  1.00  0.00           H  
ATOM    515  HB2 ALA A  35      53.347  37.704  47.489  1.00  0.00           H  
ATOM    516  HB3 ALA A  35      52.428  36.181  47.549  1.00  0.00           H  
ATOM    517  N   PHE A  36      52.057  34.938  44.568  1.00  0.00           N  
ATOM    518  CA  PHE A  36      51.204  33.860  44.098  1.00  0.00           C  
ATOM    519  C   PHE A  36      52.019  32.593  43.830  1.00  0.00           C  
ATOM    520  O   PHE A  36      53.247  32.639  43.785  1.00  0.00           O  
ATOM    521  CB  PHE A  36      50.568  34.330  42.788  1.00  0.00           C  
ATOM    522  CG  PHE A  36      51.581  34.704  41.704  1.00  0.00           C  
ATOM    523  CD1 PHE A  36      52.043  35.979  41.616  1.00  0.00           C  
ATOM    524  CD2 PHE A  36      52.019  33.760  40.828  1.00  0.00           C  
ATOM    525  CE1 PHE A  36      52.983  36.326  40.610  1.00  0.00           C  
ATOM    526  CE2 PHE A  36      52.959  34.107  39.822  1.00  0.00           C  
ATOM    527  CZ  PHE A  36      53.421  35.383  39.734  1.00  0.00           C  
ATOM    528  H   PHE A  36      53.036  34.800  44.416  1.00  0.00           H  
ATOM    529  HA  PHE A  36      50.474  33.661  44.882  1.00  0.00           H  
ATOM    530  HB2 PHE A  36      49.919  33.541  42.408  1.00  0.00           H  
ATOM    531  HB3 PHE A  36      49.935  35.192  42.993  1.00  0.00           H  
ATOM    532  HD1 PHE A  36      51.692  36.736  42.319  1.00  0.00           H  
ATOM    533  HD2 PHE A  36      51.650  32.738  40.899  1.00  0.00           H  
ATOM    534  HE1 PHE A  36      53.353  37.349  40.540  1.00  0.00           H  
ATOM    535  HE2 PHE A  36      53.310  33.351  39.120  1.00  0.00           H  
ATOM    536  HZ  PHE A  36      54.143  35.650  38.961  1.00  0.00           H  
ATOM    537  N   ARG A  37      51.303  31.491  43.661  1.00  0.00           N  
ATOM    538  CA  ARG A  37      51.944  30.215  43.398  1.00  0.00           C  
ATOM    539  C   ARG A  37      51.742  29.808  41.937  1.00  0.00           C  
ATOM    540  O   ARG A  37      51.042  30.491  41.191  1.00  0.00           O  
ATOM    541  CB  ARG A  37      51.384  29.119  44.308  1.00  0.00           C  
ATOM    542  CG  ARG A  37      51.943  29.245  45.726  1.00  0.00           C  
ATOM    543  CD  ARG A  37      53.391  28.753  45.791  1.00  0.00           C  
ATOM    544  NE  ARG A  37      53.700  28.266  47.154  1.00  0.00           N  
ATOM    545  CZ  ARG A  37      54.921  27.889  47.558  1.00  0.00           C  
ATOM    546  NH1 ARG A  37      55.954  27.939  46.705  1.00  0.00           N  
ATOM    547  NH2 ARG A  37      55.109  27.461  48.813  1.00  0.00           N  
ATOM    548  H   ARG A  37      50.304  31.463  43.699  1.00  0.00           H  
ATOM    549  HA  ARG A  37      52.999  30.383  43.617  1.00  0.00           H  
ATOM    550  HB2 ARG A  37      50.296  29.186  44.335  1.00  0.00           H  
ATOM    551  HB3 ARG A  37      51.633  28.140  43.901  1.00  0.00           H  
ATOM    552  HG2 ARG A  37      51.894  30.285  46.050  1.00  0.00           H  
ATOM    553  HG3 ARG A  37      51.328  28.667  46.416  1.00  0.00           H  
ATOM    554  HD2 ARG A  37      53.544  27.953  45.066  1.00  0.00           H  
ATOM    555  HD3 ARG A  37      54.070  29.562  45.521  1.00  0.00           H  
ATOM    556  HE  ARG A  37      52.951  28.216  47.814  1.00  0.00           H  
ATOM    557 HH11 ARG A  37      55.814  28.258  45.767  1.00  0.00           H  
ATOM    558 HH12 ARG A  37      56.865  27.657  47.006  1.00  0.00           H  
ATOM    559 HH21 ARG A  37      54.338  27.423  49.448  1.00  0.00           H  
ATOM    560 HH22 ARG A  37      56.019  27.179  49.115  1.00  0.00           H  
ATOM    561  N   LYS A  38      52.366  28.698  41.573  1.00  0.00           N  
ATOM    562  CA  LYS A  38      52.262  28.193  40.215  1.00  0.00           C  
ATOM    563  C   LYS A  38      50.901  27.518  40.028  1.00  0.00           C  
ATOM    564  O   LYS A  38      50.550  26.604  40.773  1.00  0.00           O  
ATOM    565  CB  LYS A  38      53.448  27.282  39.890  1.00  0.00           C  
ATOM    566  CG  LYS A  38      53.396  26.812  38.435  1.00  0.00           C  
ATOM    567  CD  LYS A  38      54.073  25.449  38.275  1.00  0.00           C  
ATOM    568  CE  LYS A  38      55.470  25.600  37.669  1.00  0.00           C  
ATOM    569  NZ  LYS A  38      55.761  24.475  36.751  1.00  0.00           N  
ATOM    570  H   LYS A  38      52.933  28.148  42.187  1.00  0.00           H  
ATOM    571  HA  LYS A  38      52.319  29.049  39.542  1.00  0.00           H  
ATOM    572  HB2 LYS A  38      54.381  27.817  40.069  1.00  0.00           H  
ATOM    573  HB3 LYS A  38      53.443  26.420  40.555  1.00  0.00           H  
ATOM    574  HG2 LYS A  38      52.359  26.747  38.107  1.00  0.00           H  
ATOM    575  HG3 LYS A  38      53.887  27.543  37.794  1.00  0.00           H  
ATOM    576  HD2 LYS A  38      54.144  24.958  39.245  1.00  0.00           H  
ATOM    577  HD3 LYS A  38      53.463  24.809  37.638  1.00  0.00           H  
ATOM    578  HE2 LYS A  38      55.540  26.544  37.130  1.00  0.00           H  
ATOM    579  HE3 LYS A  38      56.216  25.629  38.463  1.00  0.00           H  
ATOM    580  HZ1 LYS A  38      55.420  24.695  35.836  1.00  0.00           H  
ATOM    581  HZ2 LYS A  38      56.748  24.324  36.711  1.00  0.00           H  
ATOM    582  HZ3 LYS A  38      55.310  23.647  37.085  1.00  0.00           H  
ATOM    583  N   GLY A  39      50.172  27.996  39.030  1.00  0.00           N  
ATOM    584  CA  GLY A  39      48.857  27.451  38.738  1.00  0.00           C  
ATOM    585  C   GLY A  39      47.788  28.091  39.625  1.00  0.00           C  
ATOM    586  O   GLY A  39      46.937  27.394  40.177  1.00  0.00           O  
ATOM    587  H   GLY A  39      50.464  28.740  38.430  1.00  0.00           H  
ATOM    588  HA2 GLY A  39      48.615  27.623  37.689  1.00  0.00           H  
ATOM    589  HA3 GLY A  39      48.864  26.372  38.890  1.00  0.00           H  
ATOM    590  N   ASP A  40      47.867  29.408  39.736  1.00  0.00           N  
ATOM    591  CA  ASP A  40      46.916  30.150  40.548  1.00  0.00           C  
ATOM    592  C   ASP A  40      45.902  30.842  39.634  1.00  0.00           C  
ATOM    593  O   ASP A  40      46.257  31.325  38.560  1.00  0.00           O  
ATOM    594  CB  ASP A  40      47.620  31.228  41.374  1.00  0.00           C  
ATOM    595  CG  ASP A  40      47.775  30.903  42.861  1.00  0.00           C  
ATOM    596  OD1 ASP A  40      46.726  30.802  43.533  1.00  0.00           O  
ATOM    597  OD2 ASP A  40      48.941  30.763  43.292  1.00  0.00           O  
ATOM    598  H   ASP A  40      48.562  29.967  39.284  1.00  0.00           H  
ATOM    599  HA  ASP A  40      46.453  29.407  41.196  1.00  0.00           H  
ATOM    600  HB2 ASP A  40      48.609  31.401  40.950  1.00  0.00           H  
ATOM    601  HB3 ASP A  40      47.063  32.159  41.277  1.00  0.00           H  
ATOM    602  N   VAL A  41      44.659  30.867  40.093  1.00  0.00           N  
ATOM    603  CA  VAL A  41      43.592  31.492  39.331  1.00  0.00           C  
ATOM    604  C   VAL A  41      43.412  32.936  39.803  1.00  0.00           C  
ATOM    605  O   VAL A  41      43.269  33.189  40.999  1.00  0.00           O  
ATOM    606  CB  VAL A  41      42.313  30.661  39.445  1.00  0.00           C  
ATOM    607  CG1 VAL A  41      41.114  31.420  38.870  1.00  0.00           C  
ATOM    608  CG2 VAL A  41      42.479  29.301  38.764  1.00  0.00           C  
ATOM    609  H   VAL A  41      44.379  30.472  40.968  1.00  0.00           H  
ATOM    610  HA  VAL A  41      43.897  31.500  38.284  1.00  0.00           H  
ATOM    611  HB  VAL A  41      42.121  30.484  40.504  1.00  0.00           H  
ATOM    612 HG11 VAL A  41      41.435  32.011  38.014  1.00  0.00           H  
ATOM    613 HG12 VAL A  41      40.351  30.706  38.556  1.00  0.00           H  
ATOM    614 HG13 VAL A  41      40.702  32.079  39.634  1.00  0.00           H  
ATOM    615 HG21 VAL A  41      41.498  28.854  38.600  1.00  0.00           H  
ATOM    616 HG22 VAL A  41      42.983  29.433  37.807  1.00  0.00           H  
ATOM    617 HG23 VAL A  41      43.074  28.646  39.400  1.00  0.00           H  
ATOM    618  N   VAL A  42      43.425  33.845  38.840  1.00  0.00           N  
ATOM    619  CA  VAL A  42      43.264  35.257  39.142  1.00  0.00           C  
ATOM    620  C   VAL A  42      42.338  35.894  38.104  1.00  0.00           C  
ATOM    621  O   VAL A  42      42.243  35.417  36.974  1.00  0.00           O  
ATOM    622  CB  VAL A  42      44.633  35.935  39.218  1.00  0.00           C  
ATOM    623  CG1 VAL A  42      45.456  35.382  40.383  1.00  0.00           C  
ATOM    624  CG2 VAL A  42      45.390  35.793  37.895  1.00  0.00           C  
ATOM    625  H   VAL A  42      43.541  33.631  37.870  1.00  0.00           H  
ATOM    626  HA  VAL A  42      42.796  35.332  40.123  1.00  0.00           H  
ATOM    627  HB  VAL A  42      44.472  36.999  39.397  1.00  0.00           H  
ATOM    628 HG11 VAL A  42      46.207  36.114  40.676  1.00  0.00           H  
ATOM    629 HG12 VAL A  42      44.798  35.178  41.227  1.00  0.00           H  
ATOM    630 HG13 VAL A  42      45.948  34.460  40.074  1.00  0.00           H  
ATOM    631 HG21 VAL A  42      44.977  34.957  37.329  1.00  0.00           H  
ATOM    632 HG22 VAL A  42      45.286  36.710  37.317  1.00  0.00           H  
ATOM    633 HG23 VAL A  42      46.445  35.608  38.098  1.00  0.00           H  
ATOM    634  N   THR A  43      41.678  36.964  38.524  1.00  0.00           N  
ATOM    635  CA  THR A  43      40.763  37.672  37.645  1.00  0.00           C  
ATOM    636  C   THR A  43      41.354  39.021  37.232  1.00  0.00           C  
ATOM    637  O   THR A  43      41.793  39.795  38.082  1.00  0.00           O  
ATOM    638  CB  THR A  43      39.416  37.792  38.363  1.00  0.00           C  
ATOM    639  OG1 THR A  43      38.907  36.461  38.372  1.00  0.00           O  
ATOM    640  CG2 THR A  43      38.387  38.579  37.548  1.00  0.00           C  
ATOM    641  H   THR A  43      41.760  37.347  39.445  1.00  0.00           H  
ATOM    642  HA  THR A  43      40.638  37.085  36.734  1.00  0.00           H  
ATOM    643  HB  THR A  43      39.542  38.226  39.355  1.00  0.00           H  
ATOM    644  HG1 THR A  43      39.598  35.833  38.730  1.00  0.00           H  
ATOM    645 HG21 THR A  43      38.685  39.626  37.500  1.00  0.00           H  
ATOM    646 HG22 THR A  43      38.334  38.171  36.539  1.00  0.00           H  
ATOM    647 HG23 THR A  43      37.410  38.501  38.024  1.00  0.00           H  
ATOM    648  N   ILE A  44      41.348  39.261  35.930  1.00  0.00           N  
ATOM    649  CA  ILE A  44      41.879  40.502  35.395  1.00  0.00           C  
ATOM    650  C   ILE A  44      41.047  41.676  35.918  1.00  0.00           C  
ATOM    651  O   ILE A  44      39.956  41.941  35.414  1.00  0.00           O  
ATOM    652  CB  ILE A  44      41.957  40.438  33.868  1.00  0.00           C  
ATOM    653  CG1 ILE A  44      42.842  39.275  33.414  1.00  0.00           C  
ATOM    654  CG2 ILE A  44      42.424  41.774  33.286  1.00  0.00           C  
ATOM    655  CD1 ILE A  44      44.322  39.595  33.631  1.00  0.00           C  
ATOM    656  H   ILE A  44      40.988  38.626  35.246  1.00  0.00           H  
ATOM    657  HA  ILE A  44      42.898  40.610  35.766  1.00  0.00           H  
ATOM    658  HB  ILE A  44      40.956  40.251  33.482  1.00  0.00           H  
ATOM    659 HG12 ILE A  44      42.577  38.375  33.966  1.00  0.00           H  
ATOM    660 HG13 ILE A  44      42.662  39.068  32.359  1.00  0.00           H  
ATOM    661 HG21 ILE A  44      41.668  42.155  32.599  1.00  0.00           H  
ATOM    662 HG22 ILE A  44      42.574  42.490  34.095  1.00  0.00           H  
ATOM    663 HG23 ILE A  44      43.362  41.629  32.751  1.00  0.00           H  
ATOM    664 HD11 ILE A  44      44.841  39.585  32.672  1.00  0.00           H  
ATOM    665 HD12 ILE A  44      44.418  40.581  34.085  1.00  0.00           H  
ATOM    666 HD13 ILE A  44      44.763  38.847  34.290  1.00  0.00           H  
ATOM    667  N   LEU A  45      41.593  42.345  36.923  1.00  0.00           N  
ATOM    668  CA  LEU A  45      40.914  43.483  37.519  1.00  0.00           C  
ATOM    669  C   LEU A  45      40.819  44.612  36.491  1.00  0.00           C  
ATOM    670  O   LEU A  45      39.743  45.167  36.272  1.00  0.00           O  
ATOM    671  CB  LEU A  45      41.604  43.895  38.821  1.00  0.00           C  
ATOM    672  CG  LEU A  45      41.584  42.860  39.948  1.00  0.00           C  
ATOM    673  CD1 LEU A  45      42.526  43.267  41.083  1.00  0.00           C  
ATOM    674  CD2 LEU A  45      40.157  42.618  40.446  1.00  0.00           C  
ATOM    675  H   LEU A  45      42.480  42.123  37.326  1.00  0.00           H  
ATOM    676  HA  LEU A  45      39.905  43.164  37.777  1.00  0.00           H  
ATOM    677  HB2 LEU A  45      42.643  44.140  38.598  1.00  0.00           H  
ATOM    678  HB3 LEU A  45      41.133  44.808  39.185  1.00  0.00           H  
ATOM    679  HG  LEU A  45      41.950  41.914  39.550  1.00  0.00           H  
ATOM    680 HD11 LEU A  45      43.011  42.379  41.488  1.00  0.00           H  
ATOM    681 HD12 LEU A  45      43.283  43.952  40.700  1.00  0.00           H  
ATOM    682 HD13 LEU A  45      41.955  43.759  41.871  1.00  0.00           H  
ATOM    683 HD21 LEU A  45      39.450  43.077  39.754  1.00  0.00           H  
ATOM    684 HD22 LEU A  45      39.969  41.546  40.501  1.00  0.00           H  
ATOM    685 HD23 LEU A  45      40.038  43.061  41.434  1.00  0.00           H  
ATOM    686  N   GLU A  46      41.958  44.917  35.886  1.00  0.00           N  
ATOM    687  CA  GLU A  46      42.016  45.969  34.886  1.00  0.00           C  
ATOM    688  C   GLU A  46      42.970  45.576  33.757  1.00  0.00           C  
ATOM    689  O   GLU A  46      43.549  44.491  33.778  1.00  0.00           O  
ATOM    690  CB  GLU A  46      42.429  47.302  35.515  1.00  0.00           C  
ATOM    691  CG  GLU A  46      41.243  48.264  35.590  1.00  0.00           C  
ATOM    692  CD  GLU A  46      41.136  48.894  36.980  1.00  0.00           C  
ATOM    693  OE1 GLU A  46      40.873  48.128  37.932  1.00  0.00           O  
ATOM    694  OE2 GLU A  46      41.318  50.128  37.060  1.00  0.00           O  
ATOM    695  H   GLU A  46      42.828  44.460  36.071  1.00  0.00           H  
ATOM    696  HA  GLU A  46      41.000  46.057  34.499  1.00  0.00           H  
ATOM    697  HB2 GLU A  46      42.826  47.128  36.515  1.00  0.00           H  
ATOM    698  HB3 GLU A  46      43.230  47.751  34.928  1.00  0.00           H  
ATOM    699  HG2 GLU A  46      41.356  49.047  34.839  1.00  0.00           H  
ATOM    700  HG3 GLU A  46      40.321  47.731  35.357  1.00  0.00           H  
ATOM    701  N   ALA A  47      43.104  46.479  32.797  1.00  0.00           N  
ATOM    702  CA  ALA A  47      43.978  46.240  31.661  1.00  0.00           C  
ATOM    703  C   ALA A  47      45.386  46.737  31.994  1.00  0.00           C  
ATOM    704  O   ALA A  47      45.547  47.735  32.693  1.00  0.00           O  
ATOM    705  CB  ALA A  47      43.398  46.920  30.419  1.00  0.00           C  
ATOM    706  H   ALA A  47      42.629  47.359  32.787  1.00  0.00           H  
ATOM    707  HA  ALA A  47      44.012  45.164  31.489  1.00  0.00           H  
ATOM    708  HB1 ALA A  47      43.385  46.211  29.590  1.00  0.00           H  
ATOM    709  HB2 ALA A  47      42.382  47.253  30.628  1.00  0.00           H  
ATOM    710  HB3 ALA A  47      44.016  47.778  30.153  1.00  0.00           H  
ATOM    711  N   CYS A  48      46.371  46.017  31.476  1.00  0.00           N  
ATOM    712  CA  CYS A  48      47.761  46.371  31.709  1.00  0.00           C  
ATOM    713  C   CYS A  48      47.909  47.882  31.520  1.00  0.00           C  
ATOM    714  O   CYS A  48      47.197  48.484  30.717  1.00  0.00           O  
ATOM    715  CB  CYS A  48      48.705  45.587  30.797  1.00  0.00           C  
ATOM    716  SG  CYS A  48      48.398  46.029  29.047  1.00  0.00           S  
ATOM    717  H   CYS A  48      46.232  45.205  30.907  1.00  0.00           H  
ATOM    718  HA  CYS A  48      47.989  46.086  32.736  1.00  0.00           H  
ATOM    719  HB2 CYS A  48      49.740  45.804  31.059  1.00  0.00           H  
ATOM    720  HB3 CYS A  48      48.559  44.516  30.941  1.00  0.00           H  
ATOM    721  HG  CYS A  48      47.317  45.267  28.901  1.00  0.00           H  
ATOM    722  N   GLU A  49      48.837  48.452  32.273  1.00  0.00           N  
ATOM    723  CA  GLU A  49      49.087  49.882  32.199  1.00  0.00           C  
ATOM    724  C   GLU A  49      50.392  50.230  32.919  1.00  0.00           C  
ATOM    725  O   GLU A  49      50.504  51.293  33.529  1.00  0.00           O  
ATOM    726  CB  GLU A  49      47.914  50.675  32.776  1.00  0.00           C  
ATOM    727  CG  GLU A  49      47.510  51.816  31.840  1.00  0.00           C  
ATOM    728  CD  GLU A  49      46.154  51.538  31.190  1.00  0.00           C  
ATOM    729  OE1 GLU A  49      45.137  51.901  31.820  1.00  0.00           O  
ATOM    730  OE2 GLU A  49      46.163  50.968  30.077  1.00  0.00           O  
ATOM    731  H   GLU A  49      49.412  47.956  32.924  1.00  0.00           H  
ATOM    732  HA  GLU A  49      49.182  50.105  31.137  1.00  0.00           H  
ATOM    733  HB2 GLU A  49      47.064  50.011  32.934  1.00  0.00           H  
ATOM    734  HB3 GLU A  49      48.187  51.080  33.751  1.00  0.00           H  
ATOM    735  HG2 GLU A  49      47.465  52.751  32.397  1.00  0.00           H  
ATOM    736  HG3 GLU A  49      48.268  51.942  31.066  1.00  0.00           H  
ATOM    737  N   ASN A  50      51.345  49.316  32.826  1.00  0.00           N  
ATOM    738  CA  ASN A  50      52.637  49.512  33.462  1.00  0.00           C  
ATOM    739  C   ASN A  50      53.731  48.908  32.580  1.00  0.00           C  
ATOM    740  O   ASN A  50      54.837  48.642  33.051  1.00  0.00           O  
ATOM    741  CB  ASN A  50      52.692  48.820  34.825  1.00  0.00           C  
ATOM    742  CG  ASN A  50      52.390  49.808  35.954  1.00  0.00           C  
ATOM    743  OD1 ASN A  50      52.305  51.009  35.756  1.00  0.00           O  
ATOM    744  ND2 ASN A  50      52.233  49.237  37.144  1.00  0.00           N  
ATOM    745  H   ASN A  50      51.246  48.453  32.328  1.00  0.00           H  
ATOM    746  HA  ASN A  50      52.740  50.592  33.573  1.00  0.00           H  
ATOM    747  HB2 ASN A  50      51.972  48.002  34.850  1.00  0.00           H  
ATOM    748  HB3 ASN A  50      53.678  48.382  34.975  1.00  0.00           H  
ATOM    749 HD21 ASN A  50      52.315  48.245  37.238  1.00  0.00           H  
ATOM    750 HD22 ASN A  50      52.032  49.799  37.947  1.00  0.00           H  
ATOM    751  N   LYS A  51      53.387  48.709  31.317  1.00  0.00           N  
ATOM    752  CA  LYS A  51      54.326  48.140  30.365  1.00  0.00           C  
ATOM    753  C   LYS A  51      54.639  46.697  30.764  1.00  0.00           C  
ATOM    754  O   LYS A  51      55.529  46.453  31.578  1.00  0.00           O  
ATOM    755  CB  LYS A  51      55.567  49.028  30.242  1.00  0.00           C  
ATOM    756  CG  LYS A  51      55.204  50.405  29.683  1.00  0.00           C  
ATOM    757  CD  LYS A  51      55.753  50.584  28.266  1.00  0.00           C  
ATOM    758  CE  LYS A  51      55.214  51.865  27.627  1.00  0.00           C  
ATOM    759  NZ  LYS A  51      55.124  51.712  26.157  1.00  0.00           N  
ATOM    760  H   LYS A  51      52.486  48.928  30.941  1.00  0.00           H  
ATOM    761  HA  LYS A  51      53.839  48.131  29.390  1.00  0.00           H  
ATOM    762  HB2 LYS A  51      56.037  49.140  31.220  1.00  0.00           H  
ATOM    763  HB3 LYS A  51      56.299  48.547  29.592  1.00  0.00           H  
ATOM    764  HG2 LYS A  51      54.120  50.523  29.674  1.00  0.00           H  
ATOM    765  HG3 LYS A  51      55.604  51.183  30.334  1.00  0.00           H  
ATOM    766  HD2 LYS A  51      56.843  50.619  28.297  1.00  0.00           H  
ATOM    767  HD3 LYS A  51      55.479  49.724  27.655  1.00  0.00           H  
ATOM    768  HE2 LYS A  51      54.230  52.095  28.035  1.00  0.00           H  
ATOM    769  HE3 LYS A  51      55.866  52.704  27.873  1.00  0.00           H  
ATOM    770  HZ1 LYS A  51      55.297  52.595  25.720  1.00  0.00           H  
ATOM    771  HZ2 LYS A  51      55.807  51.049  25.850  1.00  0.00           H  
ATOM    772  HZ3 LYS A  51      54.211  51.390  25.911  1.00  0.00           H  
ATOM    773  N   SER A  52      53.891  45.777  30.172  1.00  0.00           N  
ATOM    774  CA  SER A  52      54.077  44.365  30.455  1.00  0.00           C  
ATOM    775  C   SER A  52      53.781  44.083  31.930  1.00  0.00           C  
ATOM    776  O   SER A  52      54.652  43.621  32.665  1.00  0.00           O  
ATOM    777  CB  SER A  52      55.498  43.915  30.105  1.00  0.00           C  
ATOM    778  OG  SER A  52      55.890  44.348  28.805  1.00  0.00           O  
ATOM    779  H   SER A  52      53.170  45.984  29.511  1.00  0.00           H  
ATOM    780  HA  SER A  52      53.365  43.845  29.816  1.00  0.00           H  
ATOM    781  HB2 SER A  52      56.195  44.310  30.844  1.00  0.00           H  
ATOM    782  HB3 SER A  52      55.558  42.828  30.159  1.00  0.00           H  
ATOM    783  HG  SER A  52      56.873  44.220  28.683  1.00  0.00           H  
ATOM    784  N   TRP A  53      52.548  44.374  32.318  1.00  0.00           N  
ATOM    785  CA  TRP A  53      52.125  44.157  33.691  1.00  0.00           C  
ATOM    786  C   TRP A  53      50.597  44.220  33.731  1.00  0.00           C  
ATOM    787  O   TRP A  53      49.995  45.143  33.184  1.00  0.00           O  
ATOM    788  CB  TRP A  53      52.789  45.163  34.634  1.00  0.00           C  
ATOM    789  CG  TRP A  53      54.198  44.765  35.077  1.00  0.00           C  
ATOM    790  CD1 TRP A  53      55.370  45.194  34.587  1.00  0.00           C  
ATOM    791  CD2 TRP A  53      54.539  43.834  36.125  1.00  0.00           C  
ATOM    792  NE1 TRP A  53      56.435  44.610  35.240  1.00  0.00           N  
ATOM    793  CE2 TRP A  53      55.914  43.757  36.205  1.00  0.00           C  
ATOM    794  CE3 TRP A  53      53.712  43.081  36.978  1.00  0.00           C  
ATOM    795  CZ2 TRP A  53      56.584  42.940  37.124  1.00  0.00           C  
ATOM    796  CZ3 TRP A  53      54.397  42.269  37.890  1.00  0.00           C  
ATOM    797  CH2 TRP A  53      55.781  42.181  37.983  1.00  0.00           C  
ATOM    798  H   TRP A  53      51.845  44.750  31.713  1.00  0.00           H  
ATOM    799  HA  TRP A  53      52.466  43.167  33.993  1.00  0.00           H  
ATOM    800  HB2 TRP A  53      52.835  46.134  34.139  1.00  0.00           H  
ATOM    801  HB3 TRP A  53      52.162  45.285  35.518  1.00  0.00           H  
ATOM    802  HD1 TRP A  53      55.467  45.914  33.774  1.00  0.00           H  
ATOM    803  HE1 TRP A  53      57.491  44.787  35.037  1.00  0.00           H  
ATOM    804  HE3 TRP A  53      52.624  43.125  36.934  1.00  0.00           H  
ATOM    805  HZ2 TRP A  53      57.672  42.896  37.167  1.00  0.00           H  
ATOM    806  HZ3 TRP A  53      53.803  41.664  38.575  1.00  0.00           H  
ATOM    807  HH2 TRP A  53      56.239  41.523  38.722  1.00  0.00           H  
ATOM    808  N   TYR A  54      50.012  43.225  34.382  1.00  0.00           N  
ATOM    809  CA  TYR A  54      48.566  43.156  34.500  1.00  0.00           C  
ATOM    810  C   TYR A  54      48.137  43.117  35.968  1.00  0.00           C  
ATOM    811  O   TYR A  54      48.857  42.591  36.816  1.00  0.00           O  
ATOM    812  CB  TYR A  54      48.150  41.847  33.825  1.00  0.00           C  
ATOM    813  CG  TYR A  54      47.987  41.955  32.307  1.00  0.00           C  
ATOM    814  CD1 TYR A  54      46.791  42.389  31.771  1.00  0.00           C  
ATOM    815  CD2 TYR A  54      49.035  41.619  31.475  1.00  0.00           C  
ATOM    816  CE1 TYR A  54      46.638  42.490  30.343  1.00  0.00           C  
ATOM    817  CE2 TYR A  54      48.882  41.720  30.047  1.00  0.00           C  
ATOM    818  CZ  TYR A  54      47.691  42.151  29.552  1.00  0.00           C  
ATOM    819  OH  TYR A  54      47.546  42.247  28.202  1.00  0.00           O  
ATOM    820  H   TYR A  54      50.509  42.478  34.824  1.00  0.00           H  
ATOM    821  HA  TYR A  54      48.147  44.046  34.031  1.00  0.00           H  
ATOM    822  HB2 TYR A  54      48.895  41.083  34.046  1.00  0.00           H  
ATOM    823  HB3 TYR A  54      47.210  41.510  34.258  1.00  0.00           H  
ATOM    824  HD1 TYR A  54      45.963  42.654  32.429  1.00  0.00           H  
ATOM    825  HD2 TYR A  54      49.979  41.277  31.899  1.00  0.00           H  
ATOM    826  HE1 TYR A  54      45.699  42.830  29.907  1.00  0.00           H  
ATOM    827  HE2 TYR A  54      49.702  41.458  29.379  1.00  0.00           H  
ATOM    828  HH  TYR A  54      47.519  43.208  27.929  1.00  0.00           H  
ATOM    829  N   ARG A  55      46.965  43.679  36.225  1.00  0.00           N  
ATOM    830  CA  ARG A  55      46.431  43.715  37.575  1.00  0.00           C  
ATOM    831  C   ARG A  55      45.303  42.692  37.729  1.00  0.00           C  
ATOM    832  O   ARG A  55      44.230  42.856  37.150  1.00  0.00           O  
ATOM    833  CB  ARG A  55      45.898  45.108  37.920  1.00  0.00           C  
ATOM    834  CG  ARG A  55      45.551  45.209  39.407  1.00  0.00           C  
ATOM    835  CD  ARG A  55      44.699  46.449  39.687  1.00  0.00           C  
ATOM    836  NE  ARG A  55      44.910  46.903  41.080  1.00  0.00           N  
ATOM    837  CZ  ARG A  55      44.689  48.155  41.505  1.00  0.00           C  
ATOM    838  NH1 ARG A  55      44.248  49.084  40.646  1.00  0.00           N  
ATOM    839  NH2 ARG A  55      44.908  48.477  42.785  1.00  0.00           N  
ATOM    840  H   ARG A  55      46.385  44.104  35.529  1.00  0.00           H  
ATOM    841  HA  ARG A  55      47.276  43.465  38.216  1.00  0.00           H  
ATOM    842  HB2 ARG A  55      46.644  45.860  37.665  1.00  0.00           H  
ATOM    843  HB3 ARG A  55      45.013  45.320  37.321  1.00  0.00           H  
ATOM    844  HG2 ARG A  55      45.013  44.315  39.720  1.00  0.00           H  
ATOM    845  HG3 ARG A  55      46.467  45.252  39.996  1.00  0.00           H  
ATOM    846  HD2 ARG A  55      44.962  47.246  38.993  1.00  0.00           H  
ATOM    847  HD3 ARG A  55      43.646  46.220  39.527  1.00  0.00           H  
ATOM    848  HE  ARG A  55      45.239  46.234  41.747  1.00  0.00           H  
ATOM    849 HH11 ARG A  55      44.085  48.844  39.688  1.00  0.00           H  
ATOM    850 HH12 ARG A  55      44.083  50.019  40.962  1.00  0.00           H  
ATOM    851 HH21 ARG A  55      45.237  47.783  43.427  1.00  0.00           H  
ATOM    852 HH22 ARG A  55      44.742  49.411  43.102  1.00  0.00           H  
ATOM    853  N   VAL A  56      45.586  41.661  38.510  1.00  0.00           N  
ATOM    854  CA  VAL A  56      44.607  40.612  38.746  1.00  0.00           C  
ATOM    855  C   VAL A  56      44.298  40.537  40.243  1.00  0.00           C  
ATOM    856  O   VAL A  56      44.910  41.241  41.044  1.00  0.00           O  
ATOM    857  CB  VAL A  56      45.115  39.286  38.174  1.00  0.00           C  
ATOM    858  CG1 VAL A  56      45.602  39.462  36.734  1.00  0.00           C  
ATOM    859  CG2 VAL A  56      46.213  38.692  39.056  1.00  0.00           C  
ATOM    860  H   VAL A  56      46.460  41.536  38.978  1.00  0.00           H  
ATOM    861  HA  VAL A  56      43.697  40.884  38.213  1.00  0.00           H  
ATOM    862  HB  VAL A  56      44.280  38.586  38.162  1.00  0.00           H  
ATOM    863 HG11 VAL A  56      46.614  39.866  36.740  1.00  0.00           H  
ATOM    864 HG12 VAL A  56      45.599  38.496  36.229  1.00  0.00           H  
ATOM    865 HG13 VAL A  56      44.939  40.149  36.207  1.00  0.00           H  
ATOM    866 HG21 VAL A  56      45.807  38.471  40.043  1.00  0.00           H  
ATOM    867 HG22 VAL A  56      46.587  37.774  38.603  1.00  0.00           H  
ATOM    868 HG23 VAL A  56      47.030  39.408  39.151  1.00  0.00           H  
ATOM    869  N   LYS A  57      43.347  39.677  40.575  1.00  0.00           N  
ATOM    870  CA  LYS A  57      42.948  39.500  41.962  1.00  0.00           C  
ATOM    871  C   LYS A  57      43.094  38.027  42.346  1.00  0.00           C  
ATOM    872  O   LYS A  57      42.555  37.149  41.674  1.00  0.00           O  
ATOM    873  CB  LYS A  57      41.542  40.059  42.189  1.00  0.00           C  
ATOM    874  CG  LYS A  57      41.193  40.075  43.679  1.00  0.00           C  
ATOM    875  CD  LYS A  57      39.682  39.960  43.890  1.00  0.00           C  
ATOM    876  CE  LYS A  57      39.334  39.973  45.380  1.00  0.00           C  
ATOM    877  NZ  LYS A  57      38.588  41.203  45.728  1.00  0.00           N  
ATOM    878  H   LYS A  57      42.853  39.107  39.918  1.00  0.00           H  
ATOM    879  HA  LYS A  57      43.631  40.087  42.574  1.00  0.00           H  
ATOM    880  HB2 LYS A  57      41.477  41.069  41.785  1.00  0.00           H  
ATOM    881  HB3 LYS A  57      40.814  39.453  41.648  1.00  0.00           H  
ATOM    882  HG2 LYS A  57      41.698  39.251  44.183  1.00  0.00           H  
ATOM    883  HG3 LYS A  57      41.558  40.997  44.131  1.00  0.00           H  
ATOM    884  HD2 LYS A  57      39.177  40.786  43.388  1.00  0.00           H  
ATOM    885  HD3 LYS A  57      39.316  39.040  43.435  1.00  0.00           H  
ATOM    886  HE2 LYS A  57      38.736  39.096  45.627  1.00  0.00           H  
ATOM    887  HE3 LYS A  57      40.247  39.914  45.973  1.00  0.00           H  
ATOM    888  HZ1 LYS A  57      38.005  41.026  46.521  1.00  0.00           H  
ATOM    889  HZ2 LYS A  57      39.235  41.934  45.945  1.00  0.00           H  
ATOM    890  HZ3 LYS A  57      38.021  41.480  44.952  1.00  0.00           H  
ATOM    891  N   HIS A  58      43.827  37.801  43.427  1.00  0.00           N  
ATOM    892  CA  HIS A  58      44.051  36.448  43.910  1.00  0.00           C  
ATOM    893  C   HIS A  58      42.788  35.937  44.606  1.00  0.00           C  
ATOM    894  O   HIS A  58      42.329  36.529  45.581  1.00  0.00           O  
ATOM    895  CB  HIS A  58      45.288  36.390  44.807  1.00  0.00           C  
ATOM    896  CG  HIS A  58      45.994  35.055  44.796  1.00  0.00           C  
ATOM    897  ND1 HIS A  58      45.484  33.933  45.424  1.00  0.00           N  
ATOM    898  CD2 HIS A  58      47.173  34.675  44.225  1.00  0.00           C  
ATOM    899  CE1 HIS A  58      46.326  32.928  45.234  1.00  0.00           C  
ATOM    900  NE2 HIS A  58      47.373  33.390  44.492  1.00  0.00           N  
ATOM    901  H   HIS A  58      44.262  38.520  43.968  1.00  0.00           H  
ATOM    902  HA  HIS A  58      44.247  35.832  43.032  1.00  0.00           H  
ATOM    903  HB2 HIS A  58      45.990  37.163  44.492  1.00  0.00           H  
ATOM    904  HB3 HIS A  58      44.994  36.625  45.830  1.00  0.00           H  
ATOM    905  HD2 HIS A  58      47.837  35.317  43.648  1.00  0.00           H  
ATOM    906  HE1 HIS A  58      46.204  31.910  45.607  1.00  0.00           H  
ATOM    907  HE2 HIS A  58      48.132  32.836  44.149  1.00  0.00           H  
ATOM    908  N   HIS A  59      42.264  34.840  44.077  1.00  0.00           N  
ATOM    909  CA  HIS A  59      41.063  34.242  44.637  1.00  0.00           C  
ATOM    910  C   HIS A  59      41.323  33.827  46.085  1.00  0.00           C  
ATOM    911  O   HIS A  59      40.780  34.425  47.013  1.00  0.00           O  
ATOM    912  CB  HIS A  59      40.579  33.080  43.765  1.00  0.00           C  
ATOM    913  CG  HIS A  59      39.203  32.576  44.124  1.00  0.00           C  
ATOM    914  ND1 HIS A  59      38.043  33.250  43.780  1.00  0.00           N  
ATOM    915  CD2 HIS A  59      38.811  31.457  44.798  1.00  0.00           C  
ATOM    916  CE1 HIS A  59      37.007  32.558  44.233  1.00  0.00           C  
ATOM    917  NE2 HIS A  59      37.485  31.448  44.864  1.00  0.00           N  
ATOM    918  H   HIS A  59      42.644  34.364  43.284  1.00  0.00           H  
ATOM    919  HA  HIS A  59      40.292  35.012  44.620  1.00  0.00           H  
ATOM    920  HB2 HIS A  59      40.578  33.399  42.722  1.00  0.00           H  
ATOM    921  HB3 HIS A  59      41.290  32.258  43.846  1.00  0.00           H  
ATOM    922  HD1 HIS A  59      37.996  34.112  43.276  1.00  0.00           H  
ATOM    923  HD2 HIS A  59      39.475  30.698  45.213  1.00  0.00           H  
ATOM    924  HE1 HIS A  59      35.958  32.830  44.120  1.00  0.00           H  
ATOM    925  N   THR A  60      42.154  32.804  46.235  1.00  0.00           N  
ATOM    926  CA  THR A  60      42.493  32.303  47.555  1.00  0.00           C  
ATOM    927  C   THR A  60      42.824  33.461  48.498  1.00  0.00           C  
ATOM    928  O   THR A  60      42.152  33.656  49.509  1.00  0.00           O  
ATOM    929  CB  THR A  60      43.637  31.299  47.400  1.00  0.00           C  
ATOM    930  OG1 THR A  60      43.042  30.195  46.723  1.00  0.00           O  
ATOM    931  CG2 THR A  60      44.088  30.714  48.740  1.00  0.00           C  
ATOM    932  H   THR A  60      42.590  32.324  45.475  1.00  0.00           H  
ATOM    933  HA  THR A  60      41.618  31.798  47.965  1.00  0.00           H  
ATOM    934  HB  THR A  60      44.477  31.745  46.868  1.00  0.00           H  
ATOM    935  HG1 THR A  60      43.717  29.469  46.593  1.00  0.00           H  
ATOM    936 HG21 THR A  60      43.226  30.604  49.399  1.00  0.00           H  
ATOM    937 HG22 THR A  60      44.545  29.738  48.576  1.00  0.00           H  
ATOM    938 HG23 THR A  60      44.815  31.382  49.202  1.00  0.00           H  
ATOM    939  N   SER A  61      43.861  34.201  48.132  1.00  0.00           N  
ATOM    940  CA  SER A  61      44.290  35.335  48.933  1.00  0.00           C  
ATOM    941  C   SER A  61      43.154  36.353  49.049  1.00  0.00           C  
ATOM    942  O   SER A  61      42.526  36.469  50.100  1.00  0.00           O  
ATOM    943  CB  SER A  61      45.533  35.995  48.331  1.00  0.00           C  
ATOM    944  OG  SER A  61      46.663  35.889  49.193  1.00  0.00           O  
ATOM    945  H   SER A  61      44.403  34.035  47.308  1.00  0.00           H  
ATOM    946  HA  SER A  61      44.537  34.922  49.911  1.00  0.00           H  
ATOM    947  HB2 SER A  61      45.764  35.529  47.373  1.00  0.00           H  
ATOM    948  HB3 SER A  61      45.326  37.046  48.132  1.00  0.00           H  
ATOM    949  HG  SER A  61      47.428  35.468  48.704  1.00  0.00           H  
ATOM    950  N   GLY A  62      42.924  37.064  47.955  1.00  0.00           N  
ATOM    951  CA  GLY A  62      41.875  38.068  47.922  1.00  0.00           C  
ATOM    952  C   GLY A  62      42.466  39.476  47.824  1.00  0.00           C  
ATOM    953  O   GLY A  62      41.763  40.464  48.036  1.00  0.00           O  
ATOM    954  H   GLY A  62      43.440  36.964  47.105  1.00  0.00           H  
ATOM    955  HA2 GLY A  62      41.219  37.886  47.071  1.00  0.00           H  
ATOM    956  HA3 GLY A  62      41.262  37.989  48.820  1.00  0.00           H  
ATOM    957  N   GLN A  63      43.751  39.524  47.506  1.00  0.00           N  
ATOM    958  CA  GLN A  63      44.444  40.794  47.377  1.00  0.00           C  
ATOM    959  C   GLN A  63      44.463  41.243  45.914  1.00  0.00           C  
ATOM    960  O   GLN A  63      43.929  40.557  45.043  1.00  0.00           O  
ATOM    961  CB  GLN A  63      45.862  40.704  47.943  1.00  0.00           C  
ATOM    962  CG  GLN A  63      45.889  39.876  49.229  1.00  0.00           C  
ATOM    963  CD  GLN A  63      47.325  39.555  49.645  1.00  0.00           C  
ATOM    964  OE1 GLN A  63      48.079  40.410  50.079  1.00  0.00           O  
ATOM    965  NE2 GLN A  63      47.661  38.278  49.489  1.00  0.00           N  
ATOM    966  H   GLN A  63      44.315  38.715  47.336  1.00  0.00           H  
ATOM    967  HA  GLN A  63      43.866  41.500  47.973  1.00  0.00           H  
ATOM    968  HB2 GLN A  63      46.525  40.254  47.203  1.00  0.00           H  
ATOM    969  HB3 GLN A  63      46.242  41.707  48.143  1.00  0.00           H  
ATOM    970  HG2 GLN A  63      45.389  40.424  50.028  1.00  0.00           H  
ATOM    971  HG3 GLN A  63      45.333  38.950  49.081  1.00  0.00           H  
ATOM    972 HE21 GLN A  63      46.994  37.627  49.127  1.00  0.00           H  
ATOM    973 HE22 GLN A  63      48.581  37.970  49.733  1.00  0.00           H  
ATOM    974  N   GLU A  64      45.086  42.390  45.689  1.00  0.00           N  
ATOM    975  CA  GLU A  64      45.183  42.938  44.347  1.00  0.00           C  
ATOM    976  C   GLU A  64      46.580  43.515  44.108  1.00  0.00           C  
ATOM    977  O   GLU A  64      46.976  44.481  44.758  1.00  0.00           O  
ATOM    978  CB  GLU A  64      44.105  43.997  44.107  1.00  0.00           C  
ATOM    979  CG  GLU A  64      42.713  43.443  44.417  1.00  0.00           C  
ATOM    980  CD  GLU A  64      41.703  44.574  44.615  1.00  0.00           C  
ATOM    981  OE1 GLU A  64      41.590  45.403  43.685  1.00  0.00           O  
ATOM    982  OE2 GLU A  64      41.067  44.587  45.690  1.00  0.00           O  
ATOM    983  H   GLU A  64      45.519  42.941  46.403  1.00  0.00           H  
ATOM    984  HA  GLU A  64      45.010  42.096  43.676  1.00  0.00           H  
ATOM    985  HB2 GLU A  64      44.301  44.868  44.733  1.00  0.00           H  
ATOM    986  HB3 GLU A  64      44.144  44.334  43.072  1.00  0.00           H  
ATOM    987  HG2 GLU A  64      42.386  42.796  43.603  1.00  0.00           H  
ATOM    988  HG3 GLU A  64      42.755  42.827  45.316  1.00  0.00           H  
ATOM    989  N   GLY A  65      47.289  42.897  43.174  1.00  0.00           N  
ATOM    990  CA  GLY A  65      48.633  43.336  42.842  1.00  0.00           C  
ATOM    991  C   GLY A  65      48.901  43.195  41.342  1.00  0.00           C  
ATOM    992  O   GLY A  65      48.071  42.661  40.607  1.00  0.00           O  
ATOM    993  H   GLY A  65      46.959  42.112  42.650  1.00  0.00           H  
ATOM    994  HA2 GLY A  65      48.765  44.376  43.142  1.00  0.00           H  
ATOM    995  HA3 GLY A  65      49.360  42.748  43.402  1.00  0.00           H  
ATOM    996  N   LEU A  66      50.062  43.684  40.932  1.00  0.00           N  
ATOM    997  CA  LEU A  66      50.449  43.619  39.533  1.00  0.00           C  
ATOM    998  C   LEU A  66      51.033  42.237  39.234  1.00  0.00           C  
ATOM    999  O   LEU A  66      51.534  41.562  40.133  1.00  0.00           O  
ATOM   1000  CB  LEU A  66      51.392  44.773  39.184  1.00  0.00           C  
ATOM   1001  CG  LEU A  66      50.798  46.178  39.289  1.00  0.00           C  
ATOM   1002  CD1 LEU A  66      51.901  47.237  39.358  1.00  0.00           C  
ATOM   1003  CD2 LEU A  66      49.818  46.447  38.145  1.00  0.00           C  
ATOM   1004  H   LEU A  66      50.732  44.117  41.537  1.00  0.00           H  
ATOM   1005  HA  LEU A  66      49.546  43.749  38.938  1.00  0.00           H  
ATOM   1006  HB2 LEU A  66      52.260  44.717  39.840  1.00  0.00           H  
ATOM   1007  HB3 LEU A  66      51.751  44.626  38.165  1.00  0.00           H  
ATOM   1008  HG  LEU A  66      50.232  46.243  40.218  1.00  0.00           H  
ATOM   1009 HD11 LEU A  66      51.495  48.204  39.062  1.00  0.00           H  
ATOM   1010 HD12 LEU A  66      52.282  47.299  40.378  1.00  0.00           H  
ATOM   1011 HD13 LEU A  66      52.711  46.960  38.684  1.00  0.00           H  
ATOM   1012 HD21 LEU A  66      48.969  45.768  38.227  1.00  0.00           H  
ATOM   1013 HD22 LEU A  66      49.466  47.476  38.201  1.00  0.00           H  
ATOM   1014 HD23 LEU A  66      50.321  46.287  37.191  1.00  0.00           H  
ATOM   1015  N   LEU A  67      50.950  41.856  37.967  1.00  0.00           N  
ATOM   1016  CA  LEU A  67      51.464  40.567  37.539  1.00  0.00           C  
ATOM   1017  C   LEU A  67      52.220  40.737  36.220  1.00  0.00           C  
ATOM   1018  O   LEU A  67      51.870  41.589  35.405  1.00  0.00           O  
ATOM   1019  CB  LEU A  67      50.336  39.535  37.472  1.00  0.00           C  
ATOM   1020  CG  LEU A  67      50.533  38.270  38.308  1.00  0.00           C  
ATOM   1021  CD1 LEU A  67      49.205  37.538  38.516  1.00  0.00           C  
ATOM   1022  CD2 LEU A  67      51.597  37.363  37.688  1.00  0.00           C  
ATOM   1023  H   LEU A  67      50.542  42.411  37.243  1.00  0.00           H  
ATOM   1024  HA  LEU A  67      52.167  40.226  38.298  1.00  0.00           H  
ATOM   1025  HB2 LEU A  67      49.411  40.017  37.790  1.00  0.00           H  
ATOM   1026  HB3 LEU A  67      50.200  39.242  36.431  1.00  0.00           H  
ATOM   1027  HG  LEU A  67      50.895  38.565  39.293  1.00  0.00           H  
ATOM   1028 HD11 LEU A  67      48.850  37.710  39.531  1.00  0.00           H  
ATOM   1029 HD12 LEU A  67      48.469  37.912  37.805  1.00  0.00           H  
ATOM   1030 HD13 LEU A  67      49.352  36.469  38.357  1.00  0.00           H  
ATOM   1031 HD21 LEU A  67      52.581  37.648  38.062  1.00  0.00           H  
ATOM   1032 HD22 LEU A  67      51.393  36.327  37.956  1.00  0.00           H  
ATOM   1033 HD23 LEU A  67      51.577  37.468  36.603  1.00  0.00           H  
ATOM   1034  N   ALA A  68      53.243  39.912  36.050  1.00  0.00           N  
ATOM   1035  CA  ALA A  68      54.051  39.960  34.843  1.00  0.00           C  
ATOM   1036  C   ALA A  68      53.225  39.452  33.660  1.00  0.00           C  
ATOM   1037  O   ALA A  68      52.790  38.302  33.650  1.00  0.00           O  
ATOM   1038  CB  ALA A  68      55.331  39.148  35.053  1.00  0.00           C  
ATOM   1039  H   ALA A  68      53.521  39.221  36.717  1.00  0.00           H  
ATOM   1040  HA  ALA A  68      54.322  41.002  34.667  1.00  0.00           H  
ATOM   1041  HB1 ALA A  68      55.233  38.542  35.954  1.00  0.00           H  
ATOM   1042  HB2 ALA A  68      55.492  38.497  34.194  1.00  0.00           H  
ATOM   1043  HB3 ALA A  68      56.178  39.825  35.160  1.00  0.00           H  
ATOM   1044  N   ALA A  69      53.033  40.336  32.691  1.00  0.00           N  
ATOM   1045  CA  ALA A  69      52.266  39.992  31.506  1.00  0.00           C  
ATOM   1046  C   ALA A  69      52.895  38.770  30.834  1.00  0.00           C  
ATOM   1047  O   ALA A  69      52.230  38.058  30.084  1.00  0.00           O  
ATOM   1048  CB  ALA A  69      52.201  41.202  30.571  1.00  0.00           C  
ATOM   1049  H   ALA A  69      53.390  41.271  32.707  1.00  0.00           H  
ATOM   1050  HA  ALA A  69      51.255  39.740  31.826  1.00  0.00           H  
ATOM   1051  HB1 ALA A  69      51.610  40.949  29.691  1.00  0.00           H  
ATOM   1052  HB2 ALA A  69      51.737  42.038  31.092  1.00  0.00           H  
ATOM   1053  HB3 ALA A  69      53.210  41.478  30.264  1.00  0.00           H  
ATOM   1054  N   GLY A  70      54.171  38.563  31.128  1.00  0.00           N  
ATOM   1055  CA  GLY A  70      54.898  37.440  30.562  1.00  0.00           C  
ATOM   1056  C   GLY A  70      55.035  36.306  31.581  1.00  0.00           C  
ATOM   1057  O   GLY A  70      56.021  35.571  31.568  1.00  0.00           O  
ATOM   1058  H   GLY A  70      54.706  39.147  31.739  1.00  0.00           H  
ATOM   1059  HA2 GLY A  70      54.378  37.075  29.676  1.00  0.00           H  
ATOM   1060  HA3 GLY A  70      55.886  37.765  30.240  1.00  0.00           H  
ATOM   1061  N   ALA A  71      54.032  36.202  32.441  1.00  0.00           N  
ATOM   1062  CA  ALA A  71      54.030  35.171  33.465  1.00  0.00           C  
ATOM   1063  C   ALA A  71      52.596  34.687  33.692  1.00  0.00           C  
ATOM   1064  O   ALA A  71      52.297  34.079  34.718  1.00  0.00           O  
ATOM   1065  CB  ALA A  71      54.669  35.718  34.742  1.00  0.00           C  
ATOM   1066  H   ALA A  71      53.235  36.804  32.445  1.00  0.00           H  
ATOM   1067  HA  ALA A  71      54.632  34.338  33.100  1.00  0.00           H  
ATOM   1068  HB1 ALA A  71      54.159  35.302  35.611  1.00  0.00           H  
ATOM   1069  HB2 ALA A  71      55.722  35.438  34.771  1.00  0.00           H  
ATOM   1070  HB3 ALA A  71      54.582  36.805  34.756  1.00  0.00           H  
ATOM   1071  N   LEU A  72      51.746  34.978  32.717  1.00  0.00           N  
ATOM   1072  CA  LEU A  72      50.352  34.580  32.798  1.00  0.00           C  
ATOM   1073  C   LEU A  72      49.996  33.731  31.575  1.00  0.00           C  
ATOM   1074  O   LEU A  72      50.573  33.907  30.504  1.00  0.00           O  
ATOM   1075  CB  LEU A  72      49.454  35.806  32.976  1.00  0.00           C  
ATOM   1076  CG  LEU A  72      49.713  36.650  34.225  1.00  0.00           C  
ATOM   1077  CD1 LEU A  72      49.334  38.113  33.986  1.00  0.00           C  
ATOM   1078  CD2 LEU A  72      48.995  36.065  35.443  1.00  0.00           C  
ATOM   1079  H   LEU A  72      51.997  35.473  31.886  1.00  0.00           H  
ATOM   1080  HA  LEU A  72      50.238  33.965  33.690  1.00  0.00           H  
ATOM   1081  HB2 LEU A  72      49.567  36.445  32.100  1.00  0.00           H  
ATOM   1082  HB3 LEU A  72      48.416  35.473  32.996  1.00  0.00           H  
ATOM   1083  HG  LEU A  72      50.782  36.625  34.439  1.00  0.00           H  
ATOM   1084 HD11 LEU A  72      49.296  38.308  32.915  1.00  0.00           H  
ATOM   1085 HD12 LEU A  72      48.357  38.313  34.428  1.00  0.00           H  
ATOM   1086 HD13 LEU A  72      50.080  38.762  34.448  1.00  0.00           H  
ATOM   1087 HD21 LEU A  72      48.546  36.870  36.023  1.00  0.00           H  
ATOM   1088 HD22 LEU A  72      48.216  35.378  35.109  1.00  0.00           H  
ATOM   1089 HD23 LEU A  72      49.712  35.526  36.063  1.00  0.00           H  
ATOM   1090  N   ARG A  73      49.047  32.829  31.777  1.00  0.00           N  
ATOM   1091  CA  ARG A  73      48.607  31.952  30.705  1.00  0.00           C  
ATOM   1092  C   ARG A  73      47.088  31.784  30.746  1.00  0.00           C  
ATOM   1093  O   ARG A  73      46.436  32.216  31.696  1.00  0.00           O  
ATOM   1094  CB  ARG A  73      49.269  30.576  30.812  1.00  0.00           C  
ATOM   1095  CG  ARG A  73      48.924  29.904  32.143  1.00  0.00           C  
ATOM   1096  CD  ARG A  73      47.980  28.720  31.931  1.00  0.00           C  
ATOM   1097  NE  ARG A  73      48.193  27.707  32.989  1.00  0.00           N  
ATOM   1098  CZ  ARG A  73      49.258  26.897  33.050  1.00  0.00           C  
ATOM   1099  NH1 ARG A  73      50.214  26.976  32.113  1.00  0.00           N  
ATOM   1100  NH2 ARG A  73      49.368  26.008  34.045  1.00  0.00           N  
ATOM   1101  H   ARG A  73      48.581  32.692  32.652  1.00  0.00           H  
ATOM   1102  HA  ARG A  73      48.923  32.452  29.790  1.00  0.00           H  
ATOM   1103  HB2 ARG A  73      48.941  29.945  29.987  1.00  0.00           H  
ATOM   1104  HB3 ARG A  73      50.351  30.680  30.723  1.00  0.00           H  
ATOM   1105  HG2 ARG A  73      49.839  29.563  32.630  1.00  0.00           H  
ATOM   1106  HG3 ARG A  73      48.460  30.630  32.812  1.00  0.00           H  
ATOM   1107  HD2 ARG A  73      46.945  29.063  31.949  1.00  0.00           H  
ATOM   1108  HD3 ARG A  73      48.153  28.277  30.951  1.00  0.00           H  
ATOM   1109  HE  ARG A  73      47.498  27.622  33.703  1.00  0.00           H  
ATOM   1110 HH11 ARG A  73      50.131  27.639  31.369  1.00  0.00           H  
ATOM   1111 HH12 ARG A  73      51.009  26.371  32.158  1.00  0.00           H  
ATOM   1112 HH21 ARG A  73      48.656  25.948  34.744  1.00  0.00           H  
ATOM   1113 HH22 ARG A  73      50.163  25.402  34.090  1.00  0.00           H  
ATOM   1114  N   GLU A  74      46.566  31.154  29.703  1.00  0.00           N  
ATOM   1115  CA  GLU A  74      45.135  30.923  29.608  1.00  0.00           C  
ATOM   1116  C   GLU A  74      44.770  29.576  30.236  1.00  0.00           C  
ATOM   1117  O   GLU A  74      45.088  28.524  29.684  1.00  0.00           O  
ATOM   1118  CB  GLU A  74      44.663  30.996  28.154  1.00  0.00           C  
ATOM   1119  CG  GLU A  74      43.263  31.607  28.061  1.00  0.00           C  
ATOM   1120  CD  GLU A  74      42.473  30.994  26.903  1.00  0.00           C  
ATOM   1121  OE1 GLU A  74      42.719  29.802  26.616  1.00  0.00           O  
ATOM   1122  OE2 GLU A  74      41.642  31.731  26.331  1.00  0.00           O  
ATOM   1123  H   GLU A  74      47.102  30.805  28.934  1.00  0.00           H  
ATOM   1124  HA  GLU A  74      44.672  31.732  30.173  1.00  0.00           H  
ATOM   1125  HB2 GLU A  74      45.363  31.592  27.570  1.00  0.00           H  
ATOM   1126  HB3 GLU A  74      44.656  29.995  27.720  1.00  0.00           H  
ATOM   1127  HG2 GLU A  74      42.729  31.444  28.997  1.00  0.00           H  
ATOM   1128  HG3 GLU A  74      43.342  32.685  27.922  1.00  0.00           H  
ATOM   1129  N   ARG A  75      44.109  29.654  31.381  1.00  0.00           N  
ATOM   1130  CA  ARG A  75      43.699  28.453  32.090  1.00  0.00           C  
ATOM   1131  C   ARG A  75      43.141  27.421  31.108  1.00  0.00           C  
ATOM   1132  O   ARG A  75      42.043  27.589  30.582  1.00  0.00           O  
ATOM   1133  CB  ARG A  75      42.635  28.772  33.143  1.00  0.00           C  
ATOM   1134  CG  ARG A  75      42.482  27.617  34.135  1.00  0.00           C  
ATOM   1135  CD  ARG A  75      41.366  27.904  35.143  1.00  0.00           C  
ATOM   1136  NE  ARG A  75      40.995  26.661  35.854  1.00  0.00           N  
ATOM   1137  CZ  ARG A  75      40.106  26.605  36.855  1.00  0.00           C  
ATOM   1138  NH1 ARG A  75      39.494  27.722  37.270  1.00  0.00           N  
ATOM   1139  NH2 ARG A  75      39.831  25.432  37.443  1.00  0.00           N  
ATOM   1140  H   ARG A  75      43.854  30.513  31.823  1.00  0.00           H  
ATOM   1141  HA  ARG A  75      44.607  28.088  32.569  1.00  0.00           H  
ATOM   1142  HB2 ARG A  75      42.908  29.681  33.677  1.00  0.00           H  
ATOM   1143  HB3 ARG A  75      41.680  28.964  32.653  1.00  0.00           H  
ATOM   1144  HG2 ARG A  75      42.261  26.697  33.595  1.00  0.00           H  
ATOM   1145  HG3 ARG A  75      43.422  27.460  34.663  1.00  0.00           H  
ATOM   1146  HD2 ARG A  75      41.696  28.658  35.858  1.00  0.00           H  
ATOM   1147  HD3 ARG A  75      40.497  28.313  34.628  1.00  0.00           H  
ATOM   1148  HE  ARG A  75      41.433  25.808  35.568  1.00  0.00           H  
ATOM   1149 HH11 ARG A  75      39.700  28.597  36.833  1.00  0.00           H  
ATOM   1150 HH12 ARG A  75      38.832  27.681  38.018  1.00  0.00           H  
ATOM   1151 HH21 ARG A  75      40.289  24.598  37.133  1.00  0.00           H  
ATOM   1152 HH22 ARG A  75      39.169  25.391  38.190  1.00  0.00           H  
ATOM   1153  N   SER A  76      43.925  26.375  30.891  1.00  0.00           N  
ATOM   1154  CA  SER A  76      43.523  25.315  29.981  1.00  0.00           C  
ATOM   1155  C   SER A  76      44.509  24.148  30.070  1.00  0.00           C  
ATOM   1156  O   SER A  76      45.420  24.036  29.250  1.00  0.00           O  
ATOM   1157  CB  SER A  76      43.437  25.828  28.542  1.00  0.00           C  
ATOM   1158  OG  SER A  76      42.455  25.126  27.784  1.00  0.00           O  
ATOM   1159  H   SER A  76      44.817  26.245  31.323  1.00  0.00           H  
ATOM   1160  HA  SER A  76      42.534  25.006  30.317  1.00  0.00           H  
ATOM   1161  HB2 SER A  76      43.197  26.891  28.550  1.00  0.00           H  
ATOM   1162  HB3 SER A  76      44.409  25.724  28.061  1.00  0.00           H  
ATOM   1163  HG  SER A  76      42.237  24.258  28.227  1.00  0.00           H  
ATOM   1164  N   GLY A  77      44.294  23.309  31.072  1.00  0.00           N  
ATOM   1165  CA  GLY A  77      45.152  22.154  31.279  1.00  0.00           C  
ATOM   1166  C   GLY A  77      44.473  20.872  30.791  1.00  0.00           C  
ATOM   1167  O   GLY A  77      43.251  20.823  30.665  1.00  0.00           O  
ATOM   1168  H   GLY A  77      43.551  23.407  31.735  1.00  0.00           H  
ATOM   1169  HA2 GLY A  77      46.093  22.296  30.748  1.00  0.00           H  
ATOM   1170  HA3 GLY A  77      45.394  22.062  32.337  1.00  0.00           H  
ATOM   1171  N   PRO A  78      45.317  19.841  30.524  1.00  0.00           N  
ATOM   1172  CA  PRO A  78      44.812  18.563  30.053  1.00  0.00           C  
ATOM   1173  C   PRO A  78      44.159  17.777  31.193  1.00  0.00           C  
ATOM   1174  O   PRO A  78      44.574  16.660  31.498  1.00  0.00           O  
ATOM   1175  CB  PRO A  78      46.021  17.855  29.461  1.00  0.00           C  
ATOM   1176  CG  PRO A  78      47.239  18.560  30.036  1.00  0.00           C  
ATOM   1177  CD  PRO A  78      46.771  19.864  30.662  1.00  0.00           C  
ATOM   1178  HA  PRO A  78      44.094  18.703  29.372  1.00  0.00           H  
ATOM   1179  HB2 PRO A  78      46.022  16.798  29.723  1.00  0.00           H  
ATOM   1180  HB3 PRO A  78      46.013  17.914  28.373  1.00  0.00           H  
ATOM   1181  HG2 PRO A  78      47.726  17.932  30.782  1.00  0.00           H  
ATOM   1182  HG3 PRO A  78      47.972  18.754  29.253  1.00  0.00           H  
ATOM   1183  HD2 PRO A  78      47.069  19.930  31.709  1.00  0.00           H  
ATOM   1184  HD3 PRO A  78      47.204  20.725  30.153  1.00  0.00           H  
ATOM   1185  N   SER A  79      43.150  18.394  31.790  1.00  0.00           N  
ATOM   1186  CA  SER A  79      42.436  17.766  32.888  1.00  0.00           C  
ATOM   1187  C   SER A  79      41.018  18.336  32.985  1.00  0.00           C  
ATOM   1188  O   SER A  79      40.780  19.484  32.613  1.00  0.00           O  
ATOM   1189  CB  SER A  79      43.178  17.964  34.212  1.00  0.00           C  
ATOM   1190  OG  SER A  79      43.139  16.796  35.026  1.00  0.00           O  
ATOM   1191  H   SER A  79      42.819  19.303  31.535  1.00  0.00           H  
ATOM   1192  HA  SER A  79      42.406  16.705  32.646  1.00  0.00           H  
ATOM   1193  HB2 SER A  79      44.214  18.232  34.009  1.00  0.00           H  
ATOM   1194  HB3 SER A  79      42.734  18.799  34.754  1.00  0.00           H  
ATOM   1195  HG  SER A  79      43.442  16.002  34.498  1.00  0.00           H  
ATOM   1196  N   SER A  80      40.114  17.506  33.485  1.00  0.00           N  
ATOM   1197  CA  SER A  80      38.727  17.913  33.634  1.00  0.00           C  
ATOM   1198  C   SER A  80      38.100  18.150  32.258  1.00  0.00           C  
ATOM   1199  O   SER A  80      38.622  18.926  31.460  1.00  0.00           O  
ATOM   1200  CB  SER A  80      38.612  19.173  34.493  1.00  0.00           C  
ATOM   1201  OG  SER A  80      38.039  18.897  35.769  1.00  0.00           O  
ATOM   1202  H   SER A  80      40.316  16.574  33.785  1.00  0.00           H  
ATOM   1203  HA  SER A  80      38.236  17.082  34.140  1.00  0.00           H  
ATOM   1204  HB2 SER A  80      39.600  19.612  34.627  1.00  0.00           H  
ATOM   1205  HB3 SER A  80      38.002  19.911  33.974  1.00  0.00           H  
ATOM   1206  HG  SER A  80      37.081  19.184  35.783  1.00  0.00           H  
ATOM   1207  N   GLY A  81      36.991  17.466  32.023  1.00  0.00           N  
ATOM   1208  CA  GLY A  81      36.287  17.592  30.758  1.00  0.00           C  
ATOM   1209  C   GLY A  81      35.756  19.015  30.566  1.00  0.00           C  
ATOM   1210  O   GLY A  81      34.548  19.239  30.602  1.00  0.00           O  
ATOM   1211  H   GLY A  81      36.573  16.836  32.678  1.00  0.00           H  
ATOM   1212  HA2 GLY A  81      36.958  17.337  29.938  1.00  0.00           H  
ATOM   1213  HA3 GLY A  81      35.460  16.884  30.726  1.00  0.00           H  
TER    1214      GLY A  81                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
