
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 ( 1343),  selected   95 , name 2cp0_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 2cp0_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S     178           -
LGA    S     2_A      L     179           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    N     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    M    11_A      E     180           #
LGA    L    12_A      A     181           -
LGA    -       -      W     182           -
LGA    S    13_A      L     183          3.760
LGA    A    14_A      A     184          1.192
LGA    L    15_A      Q     185          4.316
LGA    G    16_A      G     186          4.576
LGA    L    17_A      H     187          4.186
LGA    R    18_A      P     188          2.805
LGA    L    19_A      L     189          3.259
LGA    G    20_A      P     190          5.291
LGA    D    21_A      K     191          1.549
LGA    R    22_A      R     192          0.882
LGA    V    23_A      V     193          0.802
LGA    L    24_A      R     194          0.395
LGA    L    25_A      N     195          2.080
LGA    D    26_A      A     196          3.861
LGA    -       -      Y     197           -
LGA    G    27_A      D     198          3.274
LGA    Q    28_A      R     199          1.503
LGA    K    29_A      R     200          1.409
LGA    T    30_A      T     201          1.210
LGA    G    31_A      W     202          1.245
LGA    T    32_A      E     203          1.713
LGA    L    33_A      L     204          1.593
LGA    R    34_A      L     205          1.676
LGA    F    35_A      R     206          1.560
LGA    C    36_A      L     207          1.351
LGA    G    37_A      G     208          3.952
LGA    T    38_A      E     209          1.496
LGA    T    39_A      E     210          1.313
LGA    E    40_A      -       -           -
LGA    F    41_A      -       -           -
LGA    A    42_A      -       -           -
LGA    S    43_A      D     211          1.346
LGA    G    44_A      -       -           -
LGA    Q    45_A      P     212           #
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    -       -      R     240           -
LGA    W    46_A      V     241          0.618
LGA    V    47_A      A     242          1.019
LGA    G    48_A      W     243          0.892
LGA    V    49_A      V     244          1.170
LGA    E    50_A      A     245          1.255
LGA    L    51_A      D     246          1.305
LGA    D    52_A      P     247          1.611
LGA    E    53_A      K     248          2.993
LGA    P    54_A      D     249          4.454
LGA    E    55_A      P     250           -
LGA    G    56_A      -       -           -
LGA    K    57_A      -       -           -
LGA    N    58_A      -       -           -
LGA    D    59_A      -       -           -
LGA    G    60_A      -       -           -
LGA    S    61_A      -       -           -
LGA    V    62_A      -       -           -
LGA    G    63_A      -       -           -
LGA    G    64_A      -       -           -
LGA    V    65_A      -       -           -
LGA    R    66_A      -       -           -
LGA    Y    67_A      -       -           -
LGA    F    68_A      -       -           -
LGA    I    69_A      -       -           -
LGA    C    70_A      R     251          1.106
LGA    P    71_A      -       -           -
LGA    P    72_A      -       -           -
LGA    K    73_A      -       -           -
LGA    Q    74_A      K     252          3.379
LGA    G    75_A      P     253          1.976
LGA    L    76_A      I     254          1.615
LGA    F    77_A      P     255          1.042
LGA    A    78_A      H     256          1.103
LGA    S    79_A      L     257          1.302
LGA    V    80_A      T     258          0.549
LGA    S    81_A      G     259          0.609
LGA    K    82_A      L     260          0.861
LGA    I    83_A      L     261          0.558
LGA    S    84_A      V     262          0.783
LGA    K    85_A      P     263          1.601
LGA    A    86_A      V     264          1.444
LGA    V    87_A      L     265          3.386
LGA    D    88_A      -       -           -
LGA    A    89_A      -       -           -
LGA    S    90_A      -       -           -
LGA    G    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    S    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    G    95_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   88    5.0     52    2.30    17.31     48.640     2.170

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.025342 * X  +  -0.419854 * Y  +  -0.907238 * Z  +  45.898849
  Y_new =  -0.549852 * X  +  -0.763773 * Y  +   0.338102 * Z  +  40.027191
  Z_new =  -0.834877 * X  +   0.490279 * Y  +  -0.250214 * Z  +  35.690445 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.042689   -1.098903  [ DEG:   117.0375    -62.9625 ]
  Theta =   0.987910    2.153683  [ DEG:    56.6031    123.3969 ]
  Phi   =  -1.524739    1.616853  [ DEG:   -87.3611     92.6389 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cp0_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cp0_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   88   5.0   52   2.30   17.31  48.640
REMARK  ---------------------------------------------------------- 
MOLECULE 2cp0_A
HEADER    PROTEIN BINDING                         19-MAY-05   2CP0              
TITLE     SOLUTION STRUCTURE OF THE 1ST CAP-GLY DOMAIN IN HUMAN CLIP-           
TITLE    2 170-RELATED PROTEIN CLIPR59                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CLIPR-59 PROTEIN;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CAP-GLY DOMAIN;                                            
COMPND   5 SYNONYM: CLIPR59;                                                    
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: IOH13590;                                                      
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040830-02;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    MICROTUBULE BINDING, CYTOSKELETON ASSOCIATED PROTEIN,                 
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN                   
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   19-NOV-05 2CP0    0                                                
JRNL        AUTH   K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA                
JRNL        TITL   SOLUTION STRUCTURE OF THE 1ST CAP-GLY DOMAIN IN              
JRNL        TITL 2 HUMAN CLIP-170-RELATED PROTEIN CLIPR59                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2CP0 A    8    89  UNP    Q96C99   Q96C99_HUMAN   176    257             
SEQRES   1 A   95  GLY SER SER GLY SER SER GLY GLY ASN LEU MET LEU SER          
SEQRES   2 A   95  ALA LEU GLY LEU ARG LEU GLY ASP ARG VAL LEU LEU ASP          
SEQRES   3 A   95  GLY GLN LYS THR GLY THR LEU ARG PHE CYS GLY THR THR          
SEQRES   4 A   95  GLU PHE ALA SER GLY GLN TRP VAL GLY VAL GLU LEU ASP          
SEQRES   5 A   95  GLU PRO GLU GLY LYS ASN ASP GLY SER VAL GLY GLY VAL          
SEQRES   6 A   95  ARG TYR PHE ILE CYS PRO PRO LYS GLN GLY LEU PHE ALA          
SEQRES   7 A   95  SER VAL SER LYS ILE SER LYS ALA VAL ASP ALA SER GLY          
SEQRES   8 A   95  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      26.208  43.985  27.738  1.00  0.00           N  
ATOM      2  CA  GLY A   1      26.645  45.199  26.994  1.00  0.00           C  
ATOM      3  C   GLY A   1      28.065  45.083  26.477  1.00  0.00           C  
ATOM      4  O   GLY A   1      28.362  45.505  25.359  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      25.980  45.354  26.158  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      26.583  46.052  27.654  1.00  0.00           H  
ATOM      7  H1  GLY A   1      26.511  43.129  27.231  1.00  0.00           H  
ATOM      8  H2  GLY A   1      25.172  43.973  27.827  1.00  0.00           H  
ATOM      9  H3  GLY A   1      26.627  43.977  28.690  1.00  0.00           H  
ATOM     10  N   SER A   2      28.945  44.511  27.293  1.00  0.00           N  
ATOM     11  CA  SER A   2      30.343  44.343  26.912  1.00  0.00           C  
ATOM     12  C   SER A   2      31.000  45.691  26.638  1.00  0.00           C  
ATOM     13  O   SER A   2      30.956  46.199  25.517  1.00  0.00           O  
ATOM     14  CB  SER A   2      30.451  43.449  25.673  1.00  0.00           C  
ATOM     15  OG  SER A   2      31.807  43.179  25.357  1.00  0.00           O  
ATOM     16  H   SER A   2      28.649  44.195  28.172  1.00  0.00           H  
ATOM     17  HA  SER A   2      30.857  43.866  27.733  1.00  0.00           H  
ATOM     18  HB2 SER A   2      29.946  42.515  25.862  1.00  0.00           H  
ATOM     19  HB3 SER A   2      29.991  43.946  24.833  1.00  0.00           H  
ATOM     20  HG  SER A   2      31.897  43.064  24.409  1.00  0.00           H  
ATOM     21  N   SER A   3      31.606  46.267  27.671  1.00  0.00           N  
ATOM     22  CA  SER A   3      32.272  47.558  27.543  1.00  0.00           C  
ATOM     23  C   SER A   3      33.319  47.741  28.637  1.00  0.00           C  
ATOM     24  O   SER A   3      33.414  46.933  29.561  1.00  0.00           O  
ATOM     25  CB  SER A   3      31.247  48.692  27.607  1.00  0.00           C  
ATOM     26  OG  SER A   3      30.193  48.378  28.501  1.00  0.00           O  
ATOM     27  H   SER A   3      31.607  45.814  28.540  1.00  0.00           H  
ATOM     28  HA  SER A   3      32.764  47.585  26.582  1.00  0.00           H  
ATOM     29  HB2 SER A   3      31.733  49.595  27.947  1.00  0.00           H  
ATOM     30  HB3 SER A   3      30.832  48.855  26.623  1.00  0.00           H  
ATOM     31  HG  SER A   3      30.560  48.052  29.327  1.00  0.00           H  
ATOM     32  N   GLY A   4      34.103  48.808  28.525  1.00  0.00           N  
ATOM     33  CA  GLY A   4      35.133  49.077  29.511  1.00  0.00           C  
ATOM     34  C   GLY A   4      36.447  49.494  28.880  1.00  0.00           C  
ATOM     35  O   GLY A   4      37.336  48.668  28.679  1.00  0.00           O  
ATOM     36  H   GLY A   4      33.982  49.418  27.769  1.00  0.00           H  
ATOM     37  HA2 GLY A   4      34.793  49.867  30.165  1.00  0.00           H  
ATOM     38  HA3 GLY A   4      35.297  48.185  30.099  1.00  0.00           H  
ATOM     39  N   SER A   5      36.568  50.781  28.568  1.00  0.00           N  
ATOM     40  CA  SER A   5      37.783  51.307  27.955  1.00  0.00           C  
ATOM     41  C   SER A   5      38.422  52.370  28.843  1.00  0.00           C  
ATOM     42  O   SER A   5      37.831  53.420  29.095  1.00  0.00           O  
ATOM     43  CB  SER A   5      37.470  51.897  26.579  1.00  0.00           C  
ATOM     44  OG  SER A   5      36.495  51.122  25.901  1.00  0.00           O  
ATOM     45  H   SER A   5      35.824  51.390  28.754  1.00  0.00           H  
ATOM     46  HA  SER A   5      38.477  50.489  27.838  1.00  0.00           H  
ATOM     47  HB2 SER A   5      37.093  52.901  26.695  1.00  0.00           H  
ATOM     48  HB3 SER A   5      38.373  51.917  25.986  1.00  0.00           H  
ATOM     49  HG  SER A   5      36.461  51.385  24.979  1.00  0.00           H  
ATOM     50  N   SER A   6      39.632  52.090  29.315  1.00  0.00           N  
ATOM     51  CA  SER A   6      40.353  53.022  30.174  1.00  0.00           C  
ATOM     52  C   SER A   6      41.600  53.555  29.476  1.00  0.00           C  
ATOM     53  O   SER A   6      41.952  54.725  29.620  1.00  0.00           O  
ATOM     54  CB  SER A   6      40.742  52.340  31.487  1.00  0.00           C  
ATOM     55  OG  SER A   6      39.602  51.825  32.152  1.00  0.00           O  
ATOM     56  H   SER A   6      40.052  51.236  29.078  1.00  0.00           H  
ATOM     57  HA  SER A   6      39.695  53.851  30.390  1.00  0.00           H  
ATOM     58  HB2 SER A   6      41.420  51.526  31.280  1.00  0.00           H  
ATOM     59  HB3 SER A   6      41.227  53.057  32.133  1.00  0.00           H  
ATOM     60  HG  SER A   6      39.642  50.866  32.161  1.00  0.00           H  
ATOM     61  N   GLY A   7      42.265  52.688  28.719  1.00  0.00           N  
ATOM     62  CA  GLY A   7      43.464  53.089  28.009  1.00  0.00           C  
ATOM     63  C   GLY A   7      44.575  52.064  28.120  1.00  0.00           C  
ATOM     64  O   GLY A   7      45.236  51.965  29.154  1.00  0.00           O  
ATOM     65  H   GLY A   7      41.936  51.767  28.642  1.00  0.00           H  
ATOM     66  HA2 GLY A   7      43.222  53.231  26.966  1.00  0.00           H  
ATOM     67  HA3 GLY A   7      43.813  54.028  28.416  1.00  0.00           H  
ATOM     68  N   GLY A   8      44.781  51.300  27.053  1.00  0.00           N  
ATOM     69  CA  GLY A   8      45.821  50.287  27.055  1.00  0.00           C  
ATOM     70  C   GLY A   8      45.298  48.917  26.670  1.00  0.00           C  
ATOM     71  O   GLY A   8      45.637  47.916  27.301  1.00  0.00           O  
ATOM     72  H   GLY A   8      44.223  51.425  26.257  1.00  0.00           H  
ATOM     73  HA2 GLY A   8      46.590  50.575  26.354  1.00  0.00           H  
ATOM     74  HA3 GLY A   8      46.252  50.230  28.044  1.00  0.00           H  
ATOM     75  N   ASN A   9      44.467  48.873  25.633  1.00  0.00           N  
ATOM     76  CA  ASN A   9      43.896  47.615  25.165  1.00  0.00           C  
ATOM     77  C   ASN A   9      44.589  47.144  23.890  1.00  0.00           C  
ATOM     78  O   ASN A   9      43.960  46.548  23.016  1.00  0.00           O  
ATOM     79  CB  ASN A   9      42.395  47.775  24.914  1.00  0.00           C  
ATOM     80  CG  ASN A   9      41.685  48.455  26.068  1.00  0.00           C  
ATOM     81  OD1 ASN A   9      42.024  48.242  27.233  1.00  0.00           O  
ATOM     82  ND2 ASN A   9      40.692  49.276  25.751  1.00  0.00           N  
ATOM     83  H   ASN A   9      44.235  49.705  25.171  1.00  0.00           H  
ATOM     84  HA  ASN A   9      44.046  46.875  25.938  1.00  0.00           H  
ATOM     85  HB2 ASN A   9      42.247  48.370  24.025  1.00  0.00           H  
ATOM     86  HB3 ASN A   9      41.955  46.801  24.767  1.00  0.00           H  
ATOM     87 HD21 ASN A   9      40.476  49.397  24.803  1.00  0.00           H  
ATOM     88 HD22 ASN A   9      40.214  49.729  26.478  1.00  0.00           H  
ATOM     89  N   LEU A  10      45.886  47.415  23.792  1.00  0.00           N  
ATOM     90  CA  LEU A  10      46.662  47.020  22.623  1.00  0.00           C  
ATOM     91  C   LEU A  10      47.462  45.749  22.901  1.00  0.00           C  
ATOM     92  O   LEU A  10      47.751  44.975  21.989  1.00  0.00           O  
ATOM     93  CB  LEU A  10      47.605  48.152  22.206  1.00  0.00           C  
ATOM     94  CG  LEU A  10      47.613  48.467  20.710  1.00  0.00           C  
ATOM     95  CD1 LEU A  10      46.234  48.920  20.253  1.00  0.00           C  
ATOM     96  CD2 LEU A  10      48.655  49.529  20.395  1.00  0.00           C  
ATOM     97  H   LEU A  10      46.330  47.894  24.521  1.00  0.00           H  
ATOM     98  HA  LEU A  10      45.971  46.824  21.818  1.00  0.00           H  
ATOM     99  HB2 LEU A  10      47.318  49.045  22.739  1.00  0.00           H  
ATOM    100  HB3 LEU A  10      48.609  47.884  22.499  1.00  0.00           H  
ATOM    101  HG  LEU A  10      47.869  47.573  20.160  1.00  0.00           H  
ATOM    102 HD11 LEU A  10      45.545  48.091  20.312  1.00  0.00           H  
ATOM    103 HD12 LEU A  10      46.290  49.269  19.232  1.00  0.00           H  
ATOM    104 HD13 LEU A  10      45.889  49.721  20.889  1.00  0.00           H  
ATOM    105 HD21 LEU A  10      48.505  49.896  19.389  1.00  0.00           H  
ATOM    106 HD22 LEU A  10      49.643  49.099  20.476  1.00  0.00           H  
ATOM    107 HD23 LEU A  10      48.559  50.346  21.095  1.00  0.00           H  
ATOM    108  N   MET A  11      47.818  45.541  24.165  1.00  0.00           N  
ATOM    109  CA  MET A  11      48.584  44.365  24.559  1.00  0.00           C  
ATOM    110  C   MET A  11      47.704  43.119  24.578  1.00  0.00           C  
ATOM    111  O   MET A  11      47.962  42.154  23.860  1.00  0.00           O  
ATOM    112  CB  MET A  11      49.215  44.580  25.936  1.00  0.00           C  
ATOM    113  CG  MET A  11      50.515  45.365  25.895  1.00  0.00           C  
ATOM    114  SD  MET A  11      50.250  47.140  25.717  1.00  0.00           S  
ATOM    115  CE  MET A  11      51.151  47.468  24.203  1.00  0.00           C  
ATOM    116  H   MET A  11      47.559  46.194  24.848  1.00  0.00           H  
ATOM    117  HA  MET A  11      49.369  44.225  23.832  1.00  0.00           H  
ATOM    118  HB2 MET A  11      48.515  45.117  26.561  1.00  0.00           H  
ATOM    119  HB3 MET A  11      49.415  43.617  26.382  1.00  0.00           H  
ATOM    120  HG2 MET A  11      51.057  45.188  26.810  1.00  0.00           H  
ATOM    121  HG3 MET A  11      51.103  45.018  25.056  1.00  0.00           H  
ATOM    122  HE1 MET A  11      51.571  46.547  23.829  1.00  0.00           H  
ATOM    123  HE2 MET A  11      51.945  48.172  24.403  1.00  0.00           H  
ATOM    124  HE3 MET A  11      50.479  47.882  23.467  1.00  0.00           H  
ATOM    125  N   LEU A  12      46.667  43.144  25.411  1.00  0.00           N  
ATOM    126  CA  LEU A  12      45.750  42.014  25.525  1.00  0.00           C  
ATOM    127  C   LEU A  12      45.104  41.696  24.182  1.00  0.00           C  
ATOM    128  O   LEU A  12      44.934  40.529  23.825  1.00  0.00           O  
ATOM    129  CB  LEU A  12      44.670  42.312  26.567  1.00  0.00           C  
ATOM    130  CG  LEU A  12      45.100  42.117  28.022  1.00  0.00           C  
ATOM    131  CD1 LEU A  12      43.923  42.338  28.959  1.00  0.00           C  
ATOM    132  CD2 LEU A  12      45.690  40.729  28.223  1.00  0.00           C  
ATOM    133  H   LEU A  12      46.515  43.941  25.961  1.00  0.00           H  
ATOM    134  HA  LEU A  12      46.322  41.158  25.847  1.00  0.00           H  
ATOM    135  HB2 LEU A  12      44.350  43.335  26.441  1.00  0.00           H  
ATOM    136  HB3 LEU A  12      43.829  41.662  26.375  1.00  0.00           H  
ATOM    137  HG  LEU A  12      45.862  42.843  28.266  1.00  0.00           H  
ATOM    138 HD11 LEU A  12      43.203  41.544  28.828  1.00  0.00           H  
ATOM    139 HD12 LEU A  12      43.458  43.287  28.737  1.00  0.00           H  
ATOM    140 HD13 LEU A  12      44.272  42.340  29.982  1.00  0.00           H  
ATOM    141 HD21 LEU A  12      46.768  40.784  28.167  1.00  0.00           H  
ATOM    142 HD22 LEU A  12      45.324  40.067  27.453  1.00  0.00           H  
ATOM    143 HD23 LEU A  12      45.399  40.349  29.193  1.00  0.00           H  
ATOM    144  N   SER A  13      44.743  42.736  23.438  1.00  0.00           N  
ATOM    145  CA  SER A  13      44.115  42.566  22.134  1.00  0.00           C  
ATOM    146  C   SER A  13      45.011  41.764  21.197  1.00  0.00           C  
ATOM    147  O   SER A  13      44.533  40.939  20.419  1.00  0.00           O  
ATOM    148  CB  SER A  13      43.795  43.927  21.516  1.00  0.00           C  
ATOM    149  OG  SER A  13      44.976  44.579  21.079  1.00  0.00           O  
ATOM    150  H   SER A  13      44.905  43.642  23.776  1.00  0.00           H  
ATOM    151  HA  SER A  13      43.192  42.022  22.280  1.00  0.00           H  
ATOM    152  HB2 SER A  13      43.143  43.791  20.667  1.00  0.00           H  
ATOM    153  HB3 SER A  13      43.305  44.549  22.250  1.00  0.00           H  
ATOM    154  HG  SER A  13      45.663  44.475  21.743  1.00  0.00           H  
ATOM    155  N   ALA A  14      46.314  42.016  21.274  1.00  0.00           N  
ATOM    156  CA  ALA A  14      47.277  41.318  20.432  1.00  0.00           C  
ATOM    157  C   ALA A  14      47.490  39.885  20.912  1.00  0.00           C  
ATOM    158  O   ALA A  14      47.731  38.981  20.113  1.00  0.00           O  
ATOM    159  CB  ALA A  14      48.599  42.069  20.408  1.00  0.00           C  
ATOM    160  H   ALA A  14      46.635  42.686  21.914  1.00  0.00           H  
ATOM    161  HA  ALA A  14      46.885  41.294  19.425  1.00  0.00           H  
ATOM    162  HB1 ALA A  14      48.607  42.756  19.574  1.00  0.00           H  
ATOM    163  HB2 ALA A  14      49.413  41.366  20.303  1.00  0.00           H  
ATOM    164  HB3 ALA A  14      48.717  42.620  21.330  1.00  0.00           H  
ATOM    165  N   LEU A  15      47.400  39.687  22.224  1.00  0.00           N  
ATOM    166  CA  LEU A  15      47.581  38.364  22.811  1.00  0.00           C  
ATOM    167  C   LEU A  15      46.362  37.485  22.559  1.00  0.00           C  
ATOM    168  O   LEU A  15      46.488  36.343  22.116  1.00  0.00           O  
ATOM    169  CB  LEU A  15      47.838  38.483  24.314  1.00  0.00           C  
ATOM    170  CG  LEU A  15      49.142  39.185  24.696  1.00  0.00           C  
ATOM    171  CD1 LEU A  15      49.207  39.409  26.198  1.00  0.00           C  
ATOM    172  CD2 LEU A  15      50.339  38.374  24.223  1.00  0.00           C  
ATOM    173  H   LEU A  15      47.205  40.448  22.809  1.00  0.00           H  
ATOM    174  HA  LEU A  15      48.442  37.910  22.343  1.00  0.00           H  
ATOM    175  HB2 LEU A  15      47.016  39.029  24.756  1.00  0.00           H  
ATOM    176  HB3 LEU A  15      47.854  37.489  24.735  1.00  0.00           H  
ATOM    177  HG  LEU A  15      49.178  40.149  24.212  1.00  0.00           H  
ATOM    178 HD11 LEU A  15      48.827  40.393  26.432  1.00  0.00           H  
ATOM    179 HD12 LEU A  15      50.232  39.332  26.530  1.00  0.00           H  
ATOM    180 HD13 LEU A  15      48.609  38.664  26.700  1.00  0.00           H  
ATOM    181 HD21 LEU A  15      51.248  38.916  24.440  1.00  0.00           H  
ATOM    182 HD22 LEU A  15      50.265  38.208  23.159  1.00  0.00           H  
ATOM    183 HD23 LEU A  15      50.357  37.424  24.736  1.00  0.00           H  
ATOM    184  N   GLY A  16      45.181  38.023  22.845  1.00  0.00           N  
ATOM    185  CA  GLY A  16      43.954  37.273  22.643  1.00  0.00           C  
ATOM    186  C   GLY A  16      43.180  37.070  23.931  1.00  0.00           C  
ATOM    187  O   GLY A  16      42.584  36.014  24.144  1.00  0.00           O  
ATOM    188  H   GLY A  16      45.142  38.938  23.195  1.00  0.00           H  
ATOM    189  HA2 GLY A  16      43.330  37.808  21.942  1.00  0.00           H  
ATOM    190  HA3 GLY A  16      44.200  36.308  22.226  1.00  0.00           H  
ATOM    191  N   LEU A  17      43.192  38.082  24.792  1.00  0.00           N  
ATOM    192  CA  LEU A  17      42.485  38.010  26.065  1.00  0.00           C  
ATOM    193  C   LEU A  17      41.759  39.319  26.360  1.00  0.00           C  
ATOM    194  O   LEU A  17      42.091  40.363  25.802  1.00  0.00           O  
ATOM    195  CB  LEU A  17      43.464  37.690  27.198  1.00  0.00           C  
ATOM    196  CG  LEU A  17      42.836  37.047  28.435  1.00  0.00           C  
ATOM    197  CD1 LEU A  17      42.246  35.689  28.089  1.00  0.00           C  
ATOM    198  CD2 LEU A  17      43.864  36.917  29.548  1.00  0.00           C  
ATOM    199  H   LEU A  17      43.686  38.898  24.565  1.00  0.00           H  
ATOM    200  HA  LEU A  17      41.758  37.216  25.997  1.00  0.00           H  
ATOM    201  HB2 LEU A  17      44.218  37.020  26.813  1.00  0.00           H  
ATOM    202  HB3 LEU A  17      43.943  38.609  27.502  1.00  0.00           H  
ATOM    203  HG  LEU A  17      42.033  37.678  28.791  1.00  0.00           H  
ATOM    204 HD11 LEU A  17      41.410  35.819  27.418  1.00  0.00           H  
ATOM    205 HD12 LEU A  17      41.909  35.202  28.993  1.00  0.00           H  
ATOM    206 HD13 LEU A  17      43.001  35.080  27.612  1.00  0.00           H  
ATOM    207 HD21 LEU A  17      44.354  37.868  29.699  1.00  0.00           H  
ATOM    208 HD22 LEU A  17      44.598  36.175  29.274  1.00  0.00           H  
ATOM    209 HD23 LEU A  17      43.371  36.617  30.461  1.00  0.00           H  
ATOM    210  N   ARG A  18      40.766  39.252  27.242  1.00  0.00           N  
ATOM    211  CA  ARG A  18      39.993  40.432  27.611  1.00  0.00           C  
ATOM    212  C   ARG A  18      39.907  40.573  29.128  1.00  0.00           C  
ATOM    213  O   ARG A  18      40.361  39.702  29.869  1.00  0.00           O  
ATOM    214  CB  ARG A  18      38.586  40.352  27.015  1.00  0.00           C  
ATOM    215  CG  ARG A  18      38.530  40.715  25.538  1.00  0.00           C  
ATOM    216  CD  ARG A  18      37.451  41.748  25.256  1.00  0.00           C  
ATOM    217  NE  ARG A  18      36.151  41.341  25.782  1.00  0.00           N  
ATOM    218  CZ  ARG A  18      34.996  41.897  25.420  1.00  0.00           C  
ATOM    219  NH1 ARG A  18      34.978  42.882  24.530  1.00  0.00           N  
ATOM    220  NH2 ARG A  18      33.858  41.466  25.947  1.00  0.00           N  
ATOM    221  H   ARG A  18      40.548  38.389  27.652  1.00  0.00           H  
ATOM    222  HA  ARG A  18      40.497  41.297  27.207  1.00  0.00           H  
ATOM    223  HB2 ARG A  18      38.214  39.344  27.130  1.00  0.00           H  
ATOM    224  HB3 ARG A  18      37.939  41.027  27.554  1.00  0.00           H  
ATOM    225  HG2 ARG A  18      39.486  41.117  25.239  1.00  0.00           H  
ATOM    226  HG3 ARG A  18      38.318  39.822  24.967  1.00  0.00           H  
ATOM    227  HD2 ARG A  18      37.737  42.683  25.715  1.00  0.00           H  
ATOM    228  HD3 ARG A  18      37.371  41.883  24.187  1.00  0.00           H  
ATOM    229  HE  ARG A  18      36.136  40.616  26.440  1.00  0.00           H  
ATOM    230 HH11 ARG A  18      35.833  43.211  24.129  1.00  0.00           H  
ATOM    231 HH12 ARG A  18      34.108  43.295  24.261  1.00  0.00           H  
ATOM    232 HH21 ARG A  18      33.867  40.724  26.617  1.00  0.00           H  
ATOM    233 HH22 ARG A  18      32.992  41.884  25.673  1.00  0.00           H  
ATOM    234  N   LEU A  19      39.322  41.677  29.581  1.00  0.00           N  
ATOM    235  CA  LEU A  19      39.178  41.933  31.009  1.00  0.00           C  
ATOM    236  C   LEU A  19      38.049  41.097  31.601  1.00  0.00           C  
ATOM    237  O   LEU A  19      37.098  40.738  30.905  1.00  0.00           O  
ATOM    238  CB  LEU A  19      38.912  43.419  31.259  1.00  0.00           C  
ATOM    239  CG  LEU A  19      40.064  44.353  30.883  1.00  0.00           C  
ATOM    240  CD1 LEU A  19      39.643  45.806  31.039  1.00  0.00           C  
ATOM    241  CD2 LEU A  19      41.289  44.056  31.734  1.00  0.00           C  
ATOM    242  H   LEU A  19      38.980  42.335  28.941  1.00  0.00           H  
ATOM    243  HA  LEU A  19      40.104  41.656  31.491  1.00  0.00           H  
ATOM    244  HB2 LEU A  19      38.042  43.708  30.688  1.00  0.00           H  
ATOM    245  HB3 LEU A  19      38.697  43.554  32.307  1.00  0.00           H  
ATOM    246  HG  LEU A  19      40.327  44.192  29.848  1.00  0.00           H  
ATOM    247 HD11 LEU A  19      40.110  46.401  30.269  1.00  0.00           H  
ATOM    248 HD12 LEU A  19      39.953  46.169  32.009  1.00  0.00           H  
ATOM    249 HD13 LEU A  19      38.570  45.883  30.953  1.00  0.00           H  
ATOM    250 HD21 LEU A  19      42.032  44.823  31.576  1.00  0.00           H  
ATOM    251 HD22 LEU A  19      41.697  43.096  31.455  1.00  0.00           H  
ATOM    252 HD23 LEU A  19      41.007  44.039  32.778  1.00  0.00           H  
ATOM    253  N   GLY A  20      38.159  40.789  32.889  1.00  0.00           N  
ATOM    254  CA  GLY A  20      37.140  39.998  33.553  1.00  0.00           C  
ATOM    255  C   GLY A  20      37.490  38.524  33.601  1.00  0.00           C  
ATOM    256  O   GLY A  20      37.232  37.850  34.599  1.00  0.00           O  
ATOM    257  H   GLY A  20      38.938  41.102  33.394  1.00  0.00           H  
ATOM    258  HA2 GLY A  20      37.019  40.360  34.563  1.00  0.00           H  
ATOM    259  HA3 GLY A  20      36.206  40.117  33.024  1.00  0.00           H  
ATOM    260  N   ASP A  21      38.081  38.022  32.521  1.00  0.00           N  
ATOM    261  CA  ASP A  21      38.465  36.619  32.443  1.00  0.00           C  
ATOM    262  C   ASP A  21      39.581  36.305  33.437  1.00  0.00           C  
ATOM    263  O   ASP A  21      40.273  37.206  33.912  1.00  0.00           O  
ATOM    264  CB  ASP A  21      38.918  36.271  31.023  1.00  0.00           C  
ATOM    265  CG  ASP A  21      38.375  34.934  30.556  1.00  0.00           C  
ATOM    266  OD1 ASP A  21      38.039  34.095  31.418  1.00  0.00           O  
ATOM    267  OD2 ASP A  21      38.283  34.728  29.327  1.00  0.00           O  
ATOM    268  H   ASP A  21      38.259  38.610  31.758  1.00  0.00           H  
ATOM    269  HA  ASP A  21      37.600  36.022  32.692  1.00  0.00           H  
ATOM    270  HB2 ASP A  21      38.572  37.035  30.344  1.00  0.00           H  
ATOM    271  HB3 ASP A  21      39.997  36.229  30.994  1.00  0.00           H  
ATOM    272  N   ARG A  22      39.748  35.024  33.747  1.00  0.00           N  
ATOM    273  CA  ARG A  22      40.777  34.593  34.685  1.00  0.00           C  
ATOM    274  C   ARG A  22      42.005  34.071  33.944  1.00  0.00           C  
ATOM    275  O   ARG A  22      41.918  33.668  32.784  1.00  0.00           O  
ATOM    276  CB  ARG A  22      40.229  33.509  35.614  1.00  0.00           C  
ATOM    277  CG  ARG A  22      39.130  34.000  36.541  1.00  0.00           C  
ATOM    278  CD  ARG A  22      38.271  32.853  37.048  1.00  0.00           C  
ATOM    279  NE  ARG A  22      36.848  33.178  37.013  1.00  0.00           N  
ATOM    280  CZ  ARG A  22      35.907  32.455  37.616  1.00  0.00           C  
ATOM    281  NH1 ARG A  22      36.233  31.367  38.302  1.00  0.00           N  
ATOM    282  NH2 ARG A  22      34.635  32.821  37.532  1.00  0.00           N  
ATOM    283  H   ARG A  22      39.163  34.352  33.336  1.00  0.00           H  
ATOM    284  HA  ARG A  22      41.066  35.448  35.276  1.00  0.00           H  
ATOM    285  HB2 ARG A  22      39.832  32.704  35.014  1.00  0.00           H  
ATOM    286  HB3 ARG A  22      41.038  33.128  36.220  1.00  0.00           H  
ATOM    287  HG2 ARG A  22      39.581  34.499  37.386  1.00  0.00           H  
ATOM    288  HG3 ARG A  22      38.504  34.697  36.002  1.00  0.00           H  
ATOM    289  HD2 ARG A  22      38.448  31.986  36.429  1.00  0.00           H  
ATOM    290  HD3 ARG A  22      38.554  32.631  38.067  1.00  0.00           H  
ATOM    291  HE  ARG A  22      36.578  33.977  36.513  1.00  0.00           H  
ATOM    292 HH11 ARG A  22      37.191  31.086  38.370  1.00  0.00           H  
ATOM    293 HH12 ARG A  22      35.523  30.829  38.754  1.00  0.00           H  
ATOM    294 HH21 ARG A  22      34.383  33.639  37.016  1.00  0.00           H  
ATOM    295 HH22 ARG A  22      33.928  32.277  37.986  1.00  0.00           H  
ATOM    296  N   VAL A  23      43.147  34.081  34.622  1.00  0.00           N  
ATOM    297  CA  VAL A  23      44.392  33.608  34.029  1.00  0.00           C  
ATOM    298  C   VAL A  23      45.170  32.734  35.006  1.00  0.00           C  
ATOM    299  O   VAL A  23      44.893  32.728  36.206  1.00  0.00           O  
ATOM    300  CB  VAL A  23      45.286  34.782  33.587  1.00  0.00           C  
ATOM    301  CG1 VAL A  23      44.734  35.428  32.325  1.00  0.00           C  
ATOM    302  CG2 VAL A  23      45.415  35.804  34.706  1.00  0.00           C  
ATOM    303  H   VAL A  23      43.154  34.413  35.544  1.00  0.00           H  
ATOM    304  HA  VAL A  23      44.145  33.022  33.156  1.00  0.00           H  
ATOM    305  HB  VAL A  23      46.270  34.395  33.366  1.00  0.00           H  
ATOM    306 HG11 VAL A  23      43.672  35.585  32.436  1.00  0.00           H  
ATOM    307 HG12 VAL A  23      44.917  34.781  31.480  1.00  0.00           H  
ATOM    308 HG13 VAL A  23      45.224  36.377  32.164  1.00  0.00           H  
ATOM    309 HG21 VAL A  23      45.957  35.367  35.531  1.00  0.00           H  
ATOM    310 HG22 VAL A  23      44.431  36.101  35.038  1.00  0.00           H  
ATOM    311 HG23 VAL A  23      45.949  36.669  34.344  1.00  0.00           H  
ATOM    312  N   LEU A  24      46.144  31.995  34.486  1.00  0.00           N  
ATOM    313  CA  LEU A  24      46.963  31.116  35.314  1.00  0.00           C  
ATOM    314  C   LEU A  24      48.273  31.797  35.698  1.00  0.00           C  
ATOM    315  O   LEU A  24      49.112  32.078  34.843  1.00  0.00           O  
ATOM    316  CB  LEU A  24      47.251  29.808  34.576  1.00  0.00           C  
ATOM    317  CG  LEU A  24      47.319  28.566  35.464  1.00  0.00           C  
ATOM    318  CD1 LEU A  24      46.010  28.375  36.216  1.00  0.00           C  
ATOM    319  CD2 LEU A  24      47.641  27.333  34.633  1.00  0.00           C  
ATOM    320  H   LEU A  24      46.317  32.042  33.522  1.00  0.00           H  
ATOM    321  HA  LEU A  24      46.408  30.897  36.214  1.00  0.00           H  
ATOM    322  HB2 LEU A  24      46.476  29.657  33.838  1.00  0.00           H  
ATOM    323  HB3 LEU A  24      48.197  29.909  34.064  1.00  0.00           H  
ATOM    324  HG  LEU A  24      48.106  28.693  36.192  1.00  0.00           H  
ATOM    325 HD11 LEU A  24      46.080  28.845  37.185  1.00  0.00           H  
ATOM    326 HD12 LEU A  24      45.817  27.320  36.342  1.00  0.00           H  
ATOM    327 HD13 LEU A  24      45.205  28.825  35.655  1.00  0.00           H  
ATOM    328 HD21 LEU A  24      47.843  26.497  35.288  1.00  0.00           H  
ATOM    329 HD22 LEU A  24      48.511  27.528  34.022  1.00  0.00           H  
ATOM    330 HD23 LEU A  24      46.801  27.097  33.996  1.00  0.00           H  
ATOM    331  N   LEU A  25      48.440  32.059  36.991  1.00  0.00           N  
ATOM    332  CA  LEU A  25      49.648  32.707  37.488  1.00  0.00           C  
ATOM    333  C   LEU A  25      50.735  31.679  37.785  1.00  0.00           C  
ATOM    334  O   LEU A  25      50.574  30.826  38.659  1.00  0.00           O  
ATOM    335  CB  LEU A  25      49.335  33.516  38.749  1.00  0.00           C  
ATOM    336  CG  LEU A  25      48.248  34.578  38.584  1.00  0.00           C  
ATOM    337  CD1 LEU A  25      47.966  35.265  39.910  1.00  0.00           C  
ATOM    338  CD2 LEU A  25      48.655  35.597  37.530  1.00  0.00           C  
ATOM    339  H   LEU A  25      47.735  31.811  37.624  1.00  0.00           H  
ATOM    340  HA  LEU A  25      50.006  33.377  36.721  1.00  0.00           H  
ATOM    341  HB2 LEU A  25      49.025  32.829  39.523  1.00  0.00           H  
ATOM    342  HB3 LEU A  25      50.241  34.008  39.069  1.00  0.00           H  
ATOM    343  HG  LEU A  25      47.336  34.101  38.255  1.00  0.00           H  
ATOM    344 HD11 LEU A  25      48.520  36.190  39.962  1.00  0.00           H  
ATOM    345 HD12 LEU A  25      48.268  34.620  40.721  1.00  0.00           H  
ATOM    346 HD13 LEU A  25      46.909  35.473  39.990  1.00  0.00           H  
ATOM    347 HD21 LEU A  25      48.263  36.568  37.796  1.00  0.00           H  
ATOM    348 HD22 LEU A  25      48.258  35.300  36.570  1.00  0.00           H  
ATOM    349 HD23 LEU A  25      49.732  35.646  37.473  1.00  0.00           H  
ATOM    350  N   ASP A  26      51.841  31.765  37.054  1.00  0.00           N  
ATOM    351  CA  ASP A  26      52.954  30.843  37.240  1.00  0.00           C  
ATOM    352  C   ASP A  26      52.523  29.404  36.972  1.00  0.00           C  
ATOM    353  O   ASP A  26      53.092  28.462  37.524  1.00  0.00           O  
ATOM    354  CB  ASP A  26      53.513  30.964  38.660  1.00  0.00           C  
ATOM    355  CG  ASP A  26      54.731  31.864  38.727  1.00  0.00           C  
ATOM    356  OD1 ASP A  26      54.582  33.084  38.500  1.00  0.00           O  
ATOM    357  OD2 ASP A  26      55.835  31.350  39.006  1.00  0.00           O  
ATOM    358  H   ASP A  26      51.909  32.467  36.374  1.00  0.00           H  
ATOM    359  HA  ASP A  26      53.727  31.111  36.535  1.00  0.00           H  
ATOM    360  HB2 ASP A  26      52.751  31.375  39.306  1.00  0.00           H  
ATOM    361  HB3 ASP A  26      53.793  29.984  39.016  1.00  0.00           H  
ATOM    362  N   GLY A  27      51.511  29.241  36.123  1.00  0.00           N  
ATOM    363  CA  GLY A  27      51.023  27.912  35.799  1.00  0.00           C  
ATOM    364  C   GLY A  27      50.580  27.141  37.027  1.00  0.00           C  
ATOM    365  O   GLY A  27      50.677  25.915  37.066  1.00  0.00           O  
ATOM    366  H   GLY A  27      51.095  30.027  35.713  1.00  0.00           H  
ATOM    367  HA2 GLY A  27      50.185  28.004  35.123  1.00  0.00           H  
ATOM    368  HA3 GLY A  27      51.810  27.361  35.306  1.00  0.00           H  
ATOM    369  N   GLN A  28      50.090  27.862  38.030  1.00  0.00           N  
ATOM    370  CA  GLN A  28      49.632  27.239  39.266  1.00  0.00           C  
ATOM    371  C   GLN A  28      48.455  28.008  39.858  1.00  0.00           C  
ATOM    372  O   GLN A  28      47.323  27.524  39.864  1.00  0.00           O  
ATOM    373  CB  GLN A  28      50.773  27.170  40.283  1.00  0.00           C  
ATOM    374  CG  GLN A  28      51.679  25.965  40.098  1.00  0.00           C  
ATOM    375  CD  GLN A  28      51.109  24.706  40.723  1.00  0.00           C  
ATOM    376  OE1 GLN A  28      51.416  24.371  41.866  1.00  0.00           O  
ATOM    377  NE2 GLN A  28      50.272  24.000  39.970  1.00  0.00           N  
ATOM    378  H   GLN A  28      50.039  28.837  37.939  1.00  0.00           H  
ATOM    379  HA  GLN A  28      49.309  26.236  39.032  1.00  0.00           H  
ATOM    380  HB2 GLN A  28      51.374  28.063  40.191  1.00  0.00           H  
ATOM    381  HB3 GLN A  28      50.352  27.129  41.277  1.00  0.00           H  
ATOM    382  HG2 GLN A  28      51.819  25.792  39.042  1.00  0.00           H  
ATOM    383  HG3 GLN A  28      52.635  26.175  40.556  1.00  0.00           H  
ATOM    384 HE21 GLN A  28      50.073  24.327  39.068  1.00  0.00           H  
ATOM    385 HE22 GLN A  28      49.888  23.182  40.349  1.00  0.00           H  
ATOM    386  N   LYS A  29      48.730  29.209  40.355  1.00  0.00           N  
ATOM    387  CA  LYS A  29      47.695  30.046  40.950  1.00  0.00           C  
ATOM    388  C   LYS A  29      46.709  30.527  39.891  1.00  0.00           C  
ATOM    389  O   LYS A  29      46.988  30.462  38.694  1.00  0.00           O  
ATOM    390  CB  LYS A  29      48.324  31.245  41.660  1.00  0.00           C  
ATOM    391  CG  LYS A  29      48.805  30.935  43.069  1.00  0.00           C  
ATOM    392  CD  LYS A  29      50.163  30.250  43.054  1.00  0.00           C  
ATOM    393  CE  LYS A  29      50.030  28.746  43.227  1.00  0.00           C  
ATOM    394  NZ  LYS A  29      49.523  28.384  44.580  1.00  0.00           N  
ATOM    395  H   LYS A  29      49.650  29.541  40.322  1.00  0.00           H  
ATOM    396  HA  LYS A  29      47.161  29.449  41.675  1.00  0.00           H  
ATOM    397  HB2 LYS A  29      49.168  31.588  41.082  1.00  0.00           H  
ATOM    398  HB3 LYS A  29      47.593  32.038  41.720  1.00  0.00           H  
ATOM    399  HG2 LYS A  29      48.885  31.857  43.623  1.00  0.00           H  
ATOM    400  HG3 LYS A  29      48.089  30.285  43.548  1.00  0.00           H  
ATOM    401  HD2 LYS A  29      50.648  30.452  42.111  1.00  0.00           H  
ATOM    402  HD3 LYS A  29      50.763  30.645  43.860  1.00  0.00           H  
ATOM    403  HE2 LYS A  29      49.343  28.370  42.484  1.00  0.00           H  
ATOM    404  HE3 LYS A  29      50.999  28.293  43.082  1.00  0.00           H  
ATOM    405  HZ1 LYS A  29      49.731  29.148  45.256  1.00  0.00           H  
ATOM    406  HZ2 LYS A  29      49.979  27.511  44.911  1.00  0.00           H  
ATOM    407  HZ3 LYS A  29      48.494  28.234  44.548  1.00  0.00           H  
ATOM    408  N   THR A  30      45.555  31.012  40.339  1.00  0.00           N  
ATOM    409  CA  THR A  30      44.528  31.506  39.430  1.00  0.00           C  
ATOM    410  C   THR A  30      43.984  32.850  39.901  1.00  0.00           C  
ATOM    411  O   THR A  30      43.738  33.048  41.092  1.00  0.00           O  
ATOM    412  CB  THR A  30      43.388  30.492  39.317  1.00  0.00           C  
ATOM    413  OG1 THR A  30      42.721  30.348  40.559  1.00  0.00           O  
ATOM    414  CG2 THR A  30      43.848  29.119  38.880  1.00  0.00           C  
ATOM    415  H   THR A  30      45.392  31.039  41.306  1.00  0.00           H  
ATOM    416  HA  THR A  30      44.980  31.636  38.458  1.00  0.00           H  
ATOM    417  HB  THR A  30      42.673  30.851  38.589  1.00  0.00           H  
ATOM    418  HG1 THR A  30      41.948  29.789  40.445  1.00  0.00           H  
ATOM    419 HG21 THR A  30      43.537  28.385  39.609  1.00  0.00           H  
ATOM    420 HG22 THR A  30      44.925  29.110  38.797  1.00  0.00           H  
ATOM    421 HG23 THR A  30      43.411  28.881  37.921  1.00  0.00           H  
ATOM    422  N   GLY A  31      43.800  33.771  38.961  1.00  0.00           N  
ATOM    423  CA  GLY A  31      43.286  35.085  39.302  1.00  0.00           C  
ATOM    424  C   GLY A  31      42.397  35.660  38.217  1.00  0.00           C  
ATOM    425  O   GLY A  31      42.331  35.125  37.111  1.00  0.00           O  
ATOM    426  H   GLY A  31      44.014  33.557  38.030  1.00  0.00           H  
ATOM    427  HA2 GLY A  31      42.717  35.010  40.217  1.00  0.00           H  
ATOM    428  HA3 GLY A  31      44.119  35.754  39.462  1.00  0.00           H  
ATOM    429  N   THR A  32      41.712  36.754  38.536  1.00  0.00           N  
ATOM    430  CA  THR A  32      40.822  37.403  37.580  1.00  0.00           C  
ATOM    431  C   THR A  32      41.453  38.675  37.026  1.00  0.00           C  
ATOM    432  O   THR A  32      41.960  39.507  37.779  1.00  0.00           O  
ATOM    433  CB  THR A  32      39.482  37.730  38.241  1.00  0.00           C  
ATOM    434  OG1 THR A  32      39.088  36.690  39.118  1.00  0.00           O  
ATOM    435  CG2 THR A  32      38.360  37.941  37.247  1.00  0.00           C  
ATOM    436  H   THR A  32      41.807  37.133  39.434  1.00  0.00           H  
ATOM    437  HA  THR A  32      40.653  36.715  36.765  1.00  0.00           H  
ATOM    438  HB  THR A  32      39.589  38.638  38.817  1.00  0.00           H  
ATOM    439  HG1 THR A  32      38.459  37.031  39.758  1.00  0.00           H  
ATOM    440 HG21 THR A  32      38.252  37.058  36.633  1.00  0.00           H  
ATOM    441 HG22 THR A  32      38.590  38.789  36.619  1.00  0.00           H  
ATOM    442 HG23 THR A  32      37.438  38.123  37.778  1.00  0.00           H  
ATOM    443  N   LEU A  33      41.419  38.821  35.706  1.00  0.00           N  
ATOM    444  CA  LEU A  33      41.988  39.994  35.051  1.00  0.00           C  
ATOM    445  C   LEU A  33      41.131  41.228  35.306  1.00  0.00           C  
ATOM    446  O   LEU A  33      39.902  41.155  35.304  1.00  0.00           O  
ATOM    447  CB  LEU A  33      42.119  39.751  33.547  1.00  0.00           C  
ATOM    448  CG  LEU A  33      43.325  40.420  32.884  1.00  0.00           C  
ATOM    449  CD1 LEU A  33      44.616  39.971  33.553  1.00  0.00           C  
ATOM    450  CD2 LEU A  33      43.357  40.107  31.396  1.00  0.00           C  
ATOM    451  H   LEU A  33      41.001  38.124  35.158  1.00  0.00           H  
ATOM    452  HA  LEU A  33      42.971  40.161  35.466  1.00  0.00           H  
ATOM    453  HB2 LEU A  33      42.187  38.686  33.379  1.00  0.00           H  
ATOM    454  HB3 LEU A  33      41.224  40.117  33.065  1.00  0.00           H  
ATOM    455  HG  LEU A  33      43.243  41.491  33.000  1.00  0.00           H  
ATOM    456 HD11 LEU A  33      45.449  40.165  32.893  1.00  0.00           H  
ATOM    457 HD12 LEU A  33      44.563  38.915  33.767  1.00  0.00           H  
ATOM    458 HD13 LEU A  33      44.752  40.519  34.474  1.00  0.00           H  
ATOM    459 HD21 LEU A  33      42.546  40.622  30.903  1.00  0.00           H  
ATOM    460 HD22 LEU A  33      43.248  39.042  31.250  1.00  0.00           H  
ATOM    461 HD23 LEU A  33      44.298  40.434  30.979  1.00  0.00           H  
ATOM    462  N   ARG A  34      41.786  42.363  35.526  1.00  0.00           N  
ATOM    463  CA  ARG A  34      41.083  43.615  35.783  1.00  0.00           C  
ATOM    464  C   ARG A  34      41.766  44.777  35.069  1.00  0.00           C  
ATOM    465  O   ARG A  34      41.111  45.581  34.404  1.00  0.00           O  
ATOM    466  CB  ARG A  34      41.020  43.888  37.286  1.00  0.00           C  
ATOM    467  CG  ARG A  34      40.200  42.865  38.056  1.00  0.00           C  
ATOM    468  CD  ARG A  34      39.666  43.441  39.359  1.00  0.00           C  
ATOM    469  NE  ARG A  34      38.222  43.256  39.488  1.00  0.00           N  
ATOM    470  CZ  ARG A  34      37.320  44.020  38.878  1.00  0.00           C  
ATOM    471  NH1 ARG A  34      37.706  45.020  38.095  1.00  0.00           N  
ATOM    472  NH2 ARG A  34      36.027  43.784  39.050  1.00  0.00           N  
ATOM    473  H   ARG A  34      42.766  42.358  35.515  1.00  0.00           H  
ATOM    474  HA  ARG A  34      40.078  43.514  35.401  1.00  0.00           H  
ATOM    475  HB2 ARG A  34      42.024  43.885  37.684  1.00  0.00           H  
ATOM    476  HB3 ARG A  34      40.582  44.863  37.444  1.00  0.00           H  
ATOM    477  HG2 ARG A  34      39.366  42.554  37.444  1.00  0.00           H  
ATOM    478  HG3 ARG A  34      40.823  42.013  38.280  1.00  0.00           H  
ATOM    479  HD2 ARG A  34      40.157  42.948  40.184  1.00  0.00           H  
ATOM    480  HD3 ARG A  34      39.888  44.498  39.390  1.00  0.00           H  
ATOM    481  HE  ARG A  34      37.909  42.524  40.060  1.00  0.00           H  
ATOM    482 HH11 ARG A  34      38.680  45.204  37.961  1.00  0.00           H  
ATOM    483 HH12 ARG A  34      37.023  45.592  37.641  1.00  0.00           H  
ATOM    484 HH21 ARG A  34      35.729  43.032  39.638  1.00  0.00           H  
ATOM    485 HH22 ARG A  34      35.348  44.359  38.592  1.00  0.00           H  
ATOM    486  N   PHE A  35      43.085  44.862  35.214  1.00  0.00           N  
ATOM    487  CA  PHE A  35      43.856  45.927  34.583  1.00  0.00           C  
ATOM    488  C   PHE A  35      44.735  45.372  33.467  1.00  0.00           C  
ATOM    489  O   PHE A  35      45.167  44.220  33.517  1.00  0.00           O  
ATOM    490  CB  PHE A  35      44.721  46.644  35.621  1.00  0.00           C  
ATOM    491  CG  PHE A  35      45.515  47.785  35.055  1.00  0.00           C  
ATOM    492  CD1 PHE A  35      44.889  48.961  34.674  1.00  0.00           C  
ATOM    493  CD2 PHE A  35      46.889  47.683  34.904  1.00  0.00           C  
ATOM    494  CE1 PHE A  35      45.617  50.013  34.152  1.00  0.00           C  
ATOM    495  CE2 PHE A  35      47.623  48.732  34.382  1.00  0.00           C  
ATOM    496  CZ  PHE A  35      46.985  49.898  34.006  1.00  0.00           C  
ATOM    497  H   PHE A  35      43.550  44.192  35.757  1.00  0.00           H  
ATOM    498  HA  PHE A  35      43.160  46.634  34.158  1.00  0.00           H  
ATOM    499  HB2 PHE A  35      44.086  47.036  36.401  1.00  0.00           H  
ATOM    500  HB3 PHE A  35      45.415  45.937  36.052  1.00  0.00           H  
ATOM    501  HD1 PHE A  35      43.818  49.052  34.787  1.00  0.00           H  
ATOM    502  HD2 PHE A  35      47.388  46.772  35.197  1.00  0.00           H  
ATOM    503  HE1 PHE A  35      45.117  50.924  33.858  1.00  0.00           H  
ATOM    504  HE2 PHE A  35      48.694  48.640  34.270  1.00  0.00           H  
ATOM    505  HZ  PHE A  35      47.557  50.720  33.598  1.00  0.00           H  
ATOM    506  N   CYS A  36      44.998  46.199  32.461  1.00  0.00           N  
ATOM    507  CA  CYS A  36      45.827  45.791  31.332  1.00  0.00           C  
ATOM    508  C   CYS A  36      46.400  47.007  30.611  1.00  0.00           C  
ATOM    509  O   CYS A  36      45.659  47.863  30.127  1.00  0.00           O  
ATOM    510  CB  CYS A  36      45.012  44.943  30.355  1.00  0.00           C  
ATOM    511  SG  CYS A  36      43.629  45.822  29.589  1.00  0.00           S  
ATOM    512  H   CYS A  36      44.625  47.105  32.477  1.00  0.00           H  
ATOM    513  HA  CYS A  36      46.642  45.198  31.717  1.00  0.00           H  
ATOM    514  HB2 CYS A  36      45.658  44.598  29.562  1.00  0.00           H  
ATOM    515  HB3 CYS A  36      44.608  44.090  30.881  1.00  0.00           H  
ATOM    516  HG  CYS A  36      43.257  46.417  30.243  1.00  0.00           H  
ATOM    517  N   GLY A  37      47.726  47.077  30.543  1.00  0.00           N  
ATOM    518  CA  GLY A  37      48.377  48.191  29.879  1.00  0.00           C  
ATOM    519  C   GLY A  37      49.668  48.599  30.562  1.00  0.00           C  
ATOM    520  O   GLY A  37      50.434  47.748  31.014  1.00  0.00           O  
ATOM    521  H   GLY A  37      48.266  46.366  30.946  1.00  0.00           H  
ATOM    522  HA2 GLY A  37      48.594  47.912  28.858  1.00  0.00           H  
ATOM    523  HA3 GLY A  37      47.703  49.036  29.873  1.00  0.00           H  
ATOM    524  N   THR A  38      49.910  49.903  30.635  1.00  0.00           N  
ATOM    525  CA  THR A  38      51.117  50.422  31.267  1.00  0.00           C  
ATOM    526  C   THR A  38      50.905  50.623  32.764  1.00  0.00           C  
ATOM    527  O   THR A  38      49.841  50.306  33.298  1.00  0.00           O  
ATOM    528  CB  THR A  38      51.529  51.744  30.617  1.00  0.00           C  
ATOM    529  OG1 THR A  38      50.620  52.775  30.957  1.00  0.00           O  
ATOM    530  CG2 THR A  38      51.599  51.672  29.107  1.00  0.00           C  
ATOM    531  H   THR A  38      49.260  50.532  30.256  1.00  0.00           H  
ATOM    532  HA  THR A  38      51.904  49.698  31.121  1.00  0.00           H  
ATOM    533  HB  THR A  38      52.509  52.022  30.981  1.00  0.00           H  
ATOM    534  HG1 THR A  38      49.720  52.462  30.835  1.00  0.00           H  
ATOM    535 HG21 THR A  38      51.917  50.685  28.808  1.00  0.00           H  
ATOM    536 HG22 THR A  38      52.306  52.404  28.746  1.00  0.00           H  
ATOM    537 HG23 THR A  38      50.624  51.878  28.693  1.00  0.00           H  
ATOM    538  N   THR A  39      51.924  51.148  33.435  1.00  0.00           N  
ATOM    539  CA  THR A  39      51.851  51.390  34.871  1.00  0.00           C  
ATOM    540  C   THR A  39      52.397  52.770  35.220  1.00  0.00           C  
ATOM    541  O   THR A  39      52.981  53.448  34.375  1.00  0.00           O  
ATOM    542  CB  THR A  39      52.630  50.316  35.631  1.00  0.00           C  
ATOM    543  OG1 THR A  39      53.716  49.840  34.856  1.00  0.00           O  
ATOM    544  CG2 THR A  39      51.783  49.120  36.014  1.00  0.00           C  
ATOM    545  H   THR A  39      52.746  51.378  32.953  1.00  0.00           H  
ATOM    546  HA  THR A  39      50.812  51.342  35.162  1.00  0.00           H  
ATOM    547  HB  THR A  39      53.024  50.745  36.540  1.00  0.00           H  
ATOM    548  HG1 THR A  39      54.279  49.285  35.399  1.00  0.00           H  
ATOM    549 HG21 THR A  39      51.400  48.649  35.121  1.00  0.00           H  
ATOM    550 HG22 THR A  39      50.957  49.446  36.630  1.00  0.00           H  
ATOM    551 HG23 THR A  39      52.385  48.413  36.564  1.00  0.00           H  
ATOM    552  N   GLU A  40      52.202  53.182  36.469  1.00  0.00           N  
ATOM    553  CA  GLU A  40      52.676  54.481  36.928  1.00  0.00           C  
ATOM    554  C   GLU A  40      53.882  54.327  37.848  1.00  0.00           C  
ATOM    555  O   GLU A  40      54.877  55.040  37.710  1.00  0.00           O  
ATOM    556  CB  GLU A  40      51.555  55.227  37.657  1.00  0.00           C  
ATOM    557  CG  GLU A  40      50.828  56.237  36.783  1.00  0.00           C  
ATOM    558  CD  GLU A  40      51.224  57.667  37.093  1.00  0.00           C  
ATOM    559  OE1 GLU A  40      51.181  58.051  38.280  1.00  0.00           O  
ATOM    560  OE2 GLU A  40      51.578  58.405  36.148  1.00  0.00           O  
ATOM    561  H   GLU A  40      51.729  52.595  37.096  1.00  0.00           H  
ATOM    562  HA  GLU A  40      52.970  55.052  36.060  1.00  0.00           H  
ATOM    563  HB2 GLU A  40      50.833  54.507  38.014  1.00  0.00           H  
ATOM    564  HB3 GLU A  40      51.976  55.752  38.502  1.00  0.00           H  
ATOM    565  HG2 GLU A  40      51.062  56.033  35.748  1.00  0.00           H  
ATOM    566  HG3 GLU A  40      49.765  56.131  36.939  1.00  0.00           H  
ATOM    567  N   PHE A  41      53.790  53.390  38.786  1.00  0.00           N  
ATOM    568  CA  PHE A  41      54.875  53.141  39.729  1.00  0.00           C  
ATOM    569  C   PHE A  41      56.049  52.449  39.042  1.00  0.00           C  
ATOM    570  O   PHE A  41      57.196  52.582  39.469  1.00  0.00           O  
ATOM    571  CB  PHE A  41      54.378  52.288  40.898  1.00  0.00           C  
ATOM    572  CG  PHE A  41      53.668  51.036  40.467  1.00  0.00           C  
ATOM    573  CD1 PHE A  41      54.384  49.892  40.155  1.00  0.00           C  
ATOM    574  CD2 PHE A  41      52.286  51.003  40.379  1.00  0.00           C  
ATOM    575  CE1 PHE A  41      53.733  48.738  39.758  1.00  0.00           C  
ATOM    576  CE2 PHE A  41      51.630  49.852  39.984  1.00  0.00           C  
ATOM    577  CZ  PHE A  41      52.355  48.719  39.674  1.00  0.00           C  
ATOM    578  H   PHE A  41      52.972  52.854  38.846  1.00  0.00           H  
ATOM    579  HA  PHE A  41      55.208  54.096  40.107  1.00  0.00           H  
ATOM    580  HB2 PHE A  41      55.221  51.999  41.507  1.00  0.00           H  
ATOM    581  HB3 PHE A  41      53.692  52.873  41.493  1.00  0.00           H  
ATOM    582  HD1 PHE A  41      55.461  49.906  40.220  1.00  0.00           H  
ATOM    583  HD2 PHE A  41      51.718  51.890  40.621  1.00  0.00           H  
ATOM    584  HE1 PHE A  41      54.302  47.853  39.516  1.00  0.00           H  
ATOM    585  HE2 PHE A  41      50.552  49.839  39.918  1.00  0.00           H  
ATOM    586  HZ  PHE A  41      51.845  47.818  39.365  1.00  0.00           H  
ATOM    587  N   ALA A  42      55.756  51.712  37.975  1.00  0.00           N  
ATOM    588  CA  ALA A  42      56.789  51.001  37.231  1.00  0.00           C  
ATOM    589  C   ALA A  42      56.737  51.356  35.750  1.00  0.00           C  
ATOM    590  O   ALA A  42      56.047  52.294  35.351  1.00  0.00           O  
ATOM    591  CB  ALA A  42      56.638  49.499  37.423  1.00  0.00           C  
ATOM    592  H   ALA A  42      54.824  51.642  37.681  1.00  0.00           H  
ATOM    593  HA  ALA A  42      57.749  51.296  37.629  1.00  0.00           H  
ATOM    594  HB1 ALA A  42      56.337  49.295  38.439  1.00  0.00           H  
ATOM    595  HB2 ALA A  42      57.581  49.014  37.222  1.00  0.00           H  
ATOM    596  HB3 ALA A  42      55.888  49.123  36.742  1.00  0.00           H  
ATOM    597  N   SER A  43      57.470  50.602  34.938  1.00  0.00           N  
ATOM    598  CA  SER A  43      57.505  50.841  33.500  1.00  0.00           C  
ATOM    599  C   SER A  43      57.245  49.551  32.728  1.00  0.00           C  
ATOM    600  O   SER A  43      57.106  48.480  33.318  1.00  0.00           O  
ATOM    601  CB  SER A  43      58.856  51.429  33.091  1.00  0.00           C  
ATOM    602  OG  SER A  43      59.860  50.432  33.060  1.00  0.00           O  
ATOM    603  H   SER A  43      58.000  49.869  35.314  1.00  0.00           H  
ATOM    604  HA  SER A  43      56.725  51.550  33.263  1.00  0.00           H  
ATOM    605  HB2 SER A  43      58.772  51.870  32.109  1.00  0.00           H  
ATOM    606  HB3 SER A  43      59.144  52.191  33.802  1.00  0.00           H  
ATOM    607  HG  SER A  43      60.180  50.326  32.160  1.00  0.00           H  
ATOM    608  N   GLY A  44      57.180  49.662  31.405  1.00  0.00           N  
ATOM    609  CA  GLY A  44      56.938  48.499  30.573  1.00  0.00           C  
ATOM    610  C   GLY A  44      55.467  48.138  30.494  1.00  0.00           C  
ATOM    611  O   GLY A  44      54.604  49.012  30.562  1.00  0.00           O  
ATOM    612  H   GLY A  44      57.299  50.542  30.989  1.00  0.00           H  
ATOM    613  HA2 GLY A  44      57.301  48.698  29.576  1.00  0.00           H  
ATOM    614  HA3 GLY A  44      57.481  47.658  30.981  1.00  0.00           H  
ATOM    615  N   GLN A  45      55.183  46.847  30.351  1.00  0.00           N  
ATOM    616  CA  GLN A  45      53.807  46.373  30.263  1.00  0.00           C  
ATOM    617  C   GLN A  45      53.460  45.486  31.454  1.00  0.00           C  
ATOM    618  O   GLN A  45      54.169  44.526  31.753  1.00  0.00           O  
ATOM    619  CB  GLN A  45      53.593  45.603  28.959  1.00  0.00           C  
ATOM    620  CG  GLN A  45      53.555  46.491  27.726  1.00  0.00           C  
ATOM    621  CD  GLN A  45      54.910  46.622  27.059  1.00  0.00           C  
ATOM    622  OE1 GLN A  45      55.589  47.638  27.197  1.00  0.00           O  
ATOM    623  NE2 GLN A  45      55.310  45.587  26.328  1.00  0.00           N  
ATOM    624  H   GLN A  45      55.914  46.199  30.304  1.00  0.00           H  
ATOM    625  HA  GLN A  45      53.157  47.237  30.270  1.00  0.00           H  
ATOM    626  HB2 GLN A  45      54.397  44.892  28.839  1.00  0.00           H  
ATOM    627  HB3 GLN A  45      52.657  45.067  29.019  1.00  0.00           H  
ATOM    628  HG2 GLN A  45      52.859  46.070  27.016  1.00  0.00           H  
ATOM    629  HG3 GLN A  45      53.218  47.476  28.018  1.00  0.00           H  
ATOM    630 HE21 GLN A  45      54.714  44.807  26.262  1.00  0.00           H  
ATOM    631 HE22 GLN A  45      56.186  45.645  25.883  1.00  0.00           H  
ATOM    632  N   TRP A  46      52.365  45.815  32.131  1.00  0.00           N  
ATOM    633  CA  TRP A  46      51.924  45.046  33.290  1.00  0.00           C  
ATOM    634  C   TRP A  46      50.424  44.777  33.226  1.00  0.00           C  
ATOM    635  O   TRP A  46      49.734  45.262  32.330  1.00  0.00           O  
ATOM    636  CB  TRP A  46      52.266  45.792  34.581  1.00  0.00           C  
ATOM    637  CG  TRP A  46      53.739  45.927  34.815  1.00  0.00           C  
ATOM    638  CD1 TRP A  46      54.602  46.753  34.155  1.00  0.00           C  
ATOM    639  CD2 TRP A  46      54.523  45.213  35.777  1.00  0.00           C  
ATOM    640  NE1 TRP A  46      55.876  46.597  34.648  1.00  0.00           N  
ATOM    641  CE2 TRP A  46      55.853  45.657  35.644  1.00  0.00           C  
ATOM    642  CE3 TRP A  46      54.231  44.241  36.739  1.00  0.00           C  
ATOM    643  CZ2 TRP A  46      56.887  45.163  36.436  1.00  0.00           C  
ATOM    644  CZ3 TRP A  46      55.259  43.751  37.524  1.00  0.00           C  
ATOM    645  CH2 TRP A  46      56.572  44.212  37.369  1.00  0.00           C  
ATOM    646  H   TRP A  46      51.839  46.591  31.845  1.00  0.00           H  
ATOM    647  HA  TRP A  46      52.448  44.103  33.281  1.00  0.00           H  
ATOM    648  HB2 TRP A  46      51.843  46.785  34.538  1.00  0.00           H  
ATOM    649  HB3 TRP A  46      51.841  45.261  35.420  1.00  0.00           H  
ATOM    650  HD1 TRP A  46      54.312  47.428  33.362  1.00  0.00           H  
ATOM    651  HE1 TRP A  46      56.669  47.081  34.337  1.00  0.00           H  
ATOM    652  HE3 TRP A  46      53.225  43.873  36.872  1.00  0.00           H  
ATOM    653  HZ2 TRP A  46      57.904  45.508  36.331  1.00  0.00           H  
ATOM    654  HZ3 TRP A  46      55.051  43.000  38.272  1.00  0.00           H  
ATOM    655  HH2 TRP A  46      57.341  43.801  38.004  1.00  0.00           H  
ATOM    656  N   VAL A  47      49.927  44.000  34.183  1.00  0.00           N  
ATOM    657  CA  VAL A  47      48.510  43.665  34.235  1.00  0.00           C  
ATOM    658  C   VAL A  47      48.063  43.381  35.666  1.00  0.00           C  
ATOM    659  O   VAL A  47      48.796  42.774  36.446  1.00  0.00           O  
ATOM    660  CB  VAL A  47      48.188  42.442  33.358  1.00  0.00           C  
ATOM    661  CG1 VAL A  47      48.435  42.755  31.890  1.00  0.00           C  
ATOM    662  CG2 VAL A  47      49.010  41.237  33.799  1.00  0.00           C  
ATOM    663  H   VAL A  47      50.528  43.643  34.869  1.00  0.00           H  
ATOM    664  HA  VAL A  47      47.953  44.509  33.856  1.00  0.00           H  
ATOM    665  HB  VAL A  47      47.143  42.200  33.481  1.00  0.00           H  
ATOM    666 HG11 VAL A  47      48.052  41.950  31.280  1.00  0.00           H  
ATOM    667 HG12 VAL A  47      49.496  42.864  31.719  1.00  0.00           H  
ATOM    668 HG13 VAL A  47      47.932  43.675  31.629  1.00  0.00           H  
ATOM    669 HG21 VAL A  47      48.585  40.339  33.377  1.00  0.00           H  
ATOM    670 HG22 VAL A  47      48.999  41.170  34.876  1.00  0.00           H  
ATOM    671 HG23 VAL A  47      50.027  41.352  33.455  1.00  0.00           H  
ATOM    672  N   GLY A  48      46.856  43.824  36.002  1.00  0.00           N  
ATOM    673  CA  GLY A  48      46.333  43.608  37.339  1.00  0.00           C  
ATOM    674  C   GLY A  48      45.467  42.367  37.428  1.00  0.00           C  
ATOM    675  O   GLY A  48      44.473  42.243  36.712  1.00  0.00           O  
ATOM    676  H   GLY A  48      46.317  44.302  35.338  1.00  0.00           H  
ATOM    677  HA2 GLY A  48      47.160  43.506  38.027  1.00  0.00           H  
ATOM    678  HA3 GLY A  48      45.744  44.466  37.626  1.00  0.00           H  
ATOM    679  N   VAL A  49      45.844  41.444  38.307  1.00  0.00           N  
ATOM    680  CA  VAL A  49      45.095  40.207  38.486  1.00  0.00           C  
ATOM    681  C   VAL A  49      44.694  40.010  39.944  1.00  0.00           C  
ATOM    682  O   VAL A  49      45.499  40.215  40.851  1.00  0.00           O  
ATOM    683  CB  VAL A  49      45.910  38.985  38.021  1.00  0.00           C  
ATOM    684  CG1 VAL A  49      45.045  37.733  38.025  1.00  0.00           C  
ATOM    685  CG2 VAL A  49      46.500  39.230  36.640  1.00  0.00           C  
ATOM    686  H   VAL A  49      46.647  41.600  38.849  1.00  0.00           H  
ATOM    687  HA  VAL A  49      44.202  40.268  37.882  1.00  0.00           H  
ATOM    688  HB  VAL A  49      46.723  38.835  38.716  1.00  0.00           H  
ATOM    689 HG11 VAL A  49      45.629  36.894  38.375  1.00  0.00           H  
ATOM    690 HG12 VAL A  49      44.695  37.534  37.023  1.00  0.00           H  
ATOM    691 HG13 VAL A  49      44.199  37.882  38.679  1.00  0.00           H  
ATOM    692 HG21 VAL A  49      47.208  40.044  36.691  1.00  0.00           H  
ATOM    693 HG22 VAL A  49      45.709  39.482  35.951  1.00  0.00           H  
ATOM    694 HG23 VAL A  49      47.004  38.337  36.301  1.00  0.00           H  
ATOM    695  N   GLU A  50      43.445  39.611  40.159  1.00  0.00           N  
ATOM    696  CA  GLU A  50      42.937  39.383  41.507  1.00  0.00           C  
ATOM    697  C   GLU A  50      43.041  37.909  41.887  1.00  0.00           C  
ATOM    698  O   GLU A  50      42.563  37.038  41.162  1.00  0.00           O  
ATOM    699  CB  GLU A  50      41.483  39.848  41.612  1.00  0.00           C  
ATOM    700  CG  GLU A  50      41.144  40.490  42.948  1.00  0.00           C  
ATOM    701  CD  GLU A  50      39.703  40.953  43.022  1.00  0.00           C  
ATOM    702  OE1 GLU A  50      38.820  40.106  43.272  1.00  0.00           O  
ATOM    703  OE2 GLU A  50      39.457  42.163  42.830  1.00  0.00           O  
ATOM    704  H   GLU A  50      42.852  39.463  39.394  1.00  0.00           H  
ATOM    705  HA  GLU A  50      43.541  39.963  42.190  1.00  0.00           H  
ATOM    706  HB2 GLU A  50      41.292  40.571  40.832  1.00  0.00           H  
ATOM    707  HB3 GLU A  50      40.835  38.998  41.470  1.00  0.00           H  
ATOM    708  HG2 GLU A  50      41.315  39.770  43.733  1.00  0.00           H  
ATOM    709  HG3 GLU A  50      41.790  41.343  43.096  1.00  0.00           H  
ATOM    710  N   LEU A  51      43.669  37.639  43.025  1.00  0.00           N  
ATOM    711  CA  LEU A  51      43.836  36.270  43.499  1.00  0.00           C  
ATOM    712  C   LEU A  51      42.510  35.697  43.988  1.00  0.00           C  
ATOM    713  O   LEU A  51      41.859  36.270  44.861  1.00  0.00           O  
ATOM    714  CB  LEU A  51      44.872  36.221  44.624  1.00  0.00           C  
ATOM    715  CG  LEU A  51      46.317  36.476  44.188  1.00  0.00           C  
ATOM    716  CD1 LEU A  51      47.244  36.488  45.392  1.00  0.00           C  
ATOM    717  CD2 LEU A  51      46.760  35.425  43.181  1.00  0.00           C  
ATOM    718  H   LEU A  51      44.031  38.377  43.560  1.00  0.00           H  
ATOM    719  HA  LEU A  51      44.189  35.674  42.671  1.00  0.00           H  
ATOM    720  HB2 LEU A  51      44.605  36.961  45.364  1.00  0.00           H  
ATOM    721  HB3 LEU A  51      44.827  35.244  45.084  1.00  0.00           H  
ATOM    722  HG  LEU A  51      46.375  37.443  43.711  1.00  0.00           H  
ATOM    723 HD11 LEU A  51      48.095  37.119  45.183  1.00  0.00           H  
ATOM    724 HD12 LEU A  51      47.582  35.484  45.597  1.00  0.00           H  
ATOM    725 HD13 LEU A  51      46.713  36.872  46.251  1.00  0.00           H  
ATOM    726 HD21 LEU A  51      46.332  34.469  43.445  1.00  0.00           H  
ATOM    727 HD22 LEU A  51      47.838  35.351  43.190  1.00  0.00           H  
ATOM    728 HD23 LEU A  51      46.428  35.708  42.193  1.00  0.00           H  
ATOM    729  N   ASP A  52      42.117  34.562  43.417  1.00  0.00           N  
ATOM    730  CA  ASP A  52      40.868  33.911  43.794  1.00  0.00           C  
ATOM    731  C   ASP A  52      40.921  33.427  45.240  1.00  0.00           C  
ATOM    732  O   ASP A  52      40.096  33.816  46.066  1.00  0.00           O  
ATOM    733  CB  ASP A  52      40.580  32.735  42.860  1.00  0.00           C  
ATOM    734  CG  ASP A  52      40.297  33.180  41.439  1.00  0.00           C  
ATOM    735  OD1 ASP A  52      39.147  33.578  41.159  1.00  0.00           O  
ATOM    736  OD2 ASP A  52      41.226  33.135  40.606  1.00  0.00           O  
ATOM    737  H   ASP A  52      42.679  34.155  42.727  1.00  0.00           H  
ATOM    738  HA  ASP A  52      40.074  34.637  43.700  1.00  0.00           H  
ATOM    739  HB2 ASP A  52      41.436  32.076  42.847  1.00  0.00           H  
ATOM    740  HB3 ASP A  52      39.720  32.194  43.227  1.00  0.00           H  
ATOM    741  N   GLU A  53      41.898  32.577  45.538  1.00  0.00           N  
ATOM    742  CA  GLU A  53      42.060  32.040  46.884  1.00  0.00           C  
ATOM    743  C   GLU A  53      42.339  33.159  47.885  1.00  0.00           C  
ATOM    744  O   GLU A  53      42.678  34.277  47.500  1.00  0.00           O  
ATOM    745  CB  GLU A  53      43.195  31.013  46.913  1.00  0.00           C  
ATOM    746  CG  GLU A  53      42.712  29.573  46.903  1.00  0.00           C  
ATOM    747  CD  GLU A  53      43.498  28.687  47.850  1.00  0.00           C  
ATOM    748  OE1 GLU A  53      43.991  29.205  48.875  1.00  0.00           O  
ATOM    749  OE2 GLU A  53      43.621  27.477  47.566  1.00  0.00           O  
ATOM    750  H   GLU A  53      42.525  32.304  44.836  1.00  0.00           H  
ATOM    751  HA  GLU A  53      41.137  31.551  47.158  1.00  0.00           H  
ATOM    752  HB2 GLU A  53      43.823  31.166  46.049  1.00  0.00           H  
ATOM    753  HB3 GLU A  53      43.782  31.167  47.807  1.00  0.00           H  
ATOM    754  HG2 GLU A  53      41.673  29.553  47.196  1.00  0.00           H  
ATOM    755  HG3 GLU A  53      42.810  29.182  45.900  1.00  0.00           H  
ATOM    756  N   PRO A  54      42.201  32.869  49.190  1.00  0.00           N  
ATOM    757  CA  PRO A  54      42.442  33.857  50.247  1.00  0.00           C  
ATOM    758  C   PRO A  54      43.918  34.210  50.383  1.00  0.00           C  
ATOM    759  O   PRO A  54      44.577  33.815  51.346  1.00  0.00           O  
ATOM    760  CB  PRO A  54      41.938  33.155  51.511  1.00  0.00           C  
ATOM    761  CG  PRO A  54      42.061  31.701  51.211  1.00  0.00           C  
ATOM    762  CD  PRO A  54      41.801  31.560  49.737  1.00  0.00           C  
ATOM    763  HA  PRO A  54      41.871  34.759  50.081  1.00  0.00           H  
ATOM    764  HB2 PRO A  54      42.553  33.440  52.352  1.00  0.00           H  
ATOM    765  HB3 PRO A  54      40.911  33.434  51.696  1.00  0.00           H  
ATOM    766  HG2 PRO A  54      43.057  31.359  51.452  1.00  0.00           H  
ATOM    767  HG3 PRO A  54      41.326  31.146  51.776  1.00  0.00           H  
ATOM    768  HD2 PRO A  54      42.408  30.766  49.322  1.00  0.00           H  
ATOM    769  HD3 PRO A  54      40.753  31.370  49.555  1.00  0.00           H  
ATOM    770  N   GLU A  55      44.435  34.958  49.412  1.00  0.00           N  
ATOM    771  CA  GLU A  55      45.834  35.366  49.422  1.00  0.00           C  
ATOM    772  C   GLU A  55      46.030  36.659  48.637  1.00  0.00           C  
ATOM    773  O   GLU A  55      45.122  37.119  47.944  1.00  0.00           O  
ATOM    774  CB  GLU A  55      46.713  34.261  48.833  1.00  0.00           C  
ATOM    775  CG  GLU A  55      48.084  34.163  49.483  1.00  0.00           C  
ATOM    776  CD  GLU A  55      49.211  34.119  48.469  1.00  0.00           C  
ATOM    777  OE1 GLU A  55      49.278  33.136  47.701  1.00  0.00           O  
ATOM    778  OE2 GLU A  55      50.024  35.065  48.444  1.00  0.00           O  
ATOM    779  H   GLU A  55      43.860  35.242  48.670  1.00  0.00           H  
ATOM    780  HA  GLU A  55      46.124  35.534  50.449  1.00  0.00           H  
ATOM    781  HB2 GLU A  55      46.211  33.312  48.958  1.00  0.00           H  
ATOM    782  HB3 GLU A  55      46.851  34.452  47.777  1.00  0.00           H  
ATOM    783  HG2 GLU A  55      48.228  35.022  50.120  1.00  0.00           H  
ATOM    784  HG3 GLU A  55      48.120  33.263  50.080  1.00  0.00           H  
ATOM    785  N   GLY A  56      47.218  37.241  48.753  1.00  0.00           N  
ATOM    786  CA  GLY A  56      47.510  38.476  48.049  1.00  0.00           C  
ATOM    787  C   GLY A  56      48.503  39.348  48.791  1.00  0.00           C  
ATOM    788  O   GLY A  56      49.112  38.914  49.769  1.00  0.00           O  
ATOM    789  H   GLY A  56      47.902  36.830  49.320  1.00  0.00           H  
ATOM    790  HA2 GLY A  56      47.915  38.236  47.077  1.00  0.00           H  
ATOM    791  HA3 GLY A  56      46.591  39.029  47.918  1.00  0.00           H  
ATOM    792  N   LYS A  57      48.669  40.582  48.325  1.00  0.00           N  
ATOM    793  CA  LYS A  57      49.597  41.517  48.952  1.00  0.00           C  
ATOM    794  C   LYS A  57      49.002  42.921  49.005  1.00  0.00           C  
ATOM    795  O   LYS A  57      48.847  43.500  50.082  1.00  0.00           O  
ATOM    796  CB  LYS A  57      50.922  41.541  48.187  1.00  0.00           C  
ATOM    797  CG  LYS A  57      52.143  41.598  49.090  1.00  0.00           C  
ATOM    798  CD  LYS A  57      53.431  41.645  48.283  1.00  0.00           C  
ATOM    799  CE  LYS A  57      53.963  40.250  48.001  1.00  0.00           C  
ATOM    800  NZ  LYS A  57      54.675  39.678  49.178  1.00  0.00           N  
ATOM    801  H   LYS A  57      48.156  40.871  47.542  1.00  0.00           H  
ATOM    802  HA  LYS A  57      49.780  41.178  49.959  1.00  0.00           H  
ATOM    803  HB2 LYS A  57      50.991  40.648  47.580  1.00  0.00           H  
ATOM    804  HB3 LYS A  57      50.938  42.410  47.541  1.00  0.00           H  
ATOM    805  HG2 LYS A  57      52.084  42.483  49.705  1.00  0.00           H  
ATOM    806  HG3 LYS A  57      52.154  40.721  49.719  1.00  0.00           H  
ATOM    807  HD2 LYS A  57      53.239  42.142  47.345  1.00  0.00           H  
ATOM    808  HD3 LYS A  57      54.172  42.198  48.840  1.00  0.00           H  
ATOM    809  HE2 LYS A  57      53.133  39.607  47.747  1.00  0.00           H  
ATOM    810  HE3 LYS A  57      54.647  40.299  47.167  1.00  0.00           H  
ATOM    811  HZ1 LYS A  57      54.507  38.652  49.234  1.00  0.00           H  
ATOM    812  HZ2 LYS A  57      54.331  40.122  50.054  1.00  0.00           H  
ATOM    813  HZ3 LYS A  57      55.698  39.846  49.093  1.00  0.00           H  
ATOM    814  N   ASN A  58      48.668  43.464  47.839  1.00  0.00           N  
ATOM    815  CA  ASN A  58      48.090  44.800  47.754  1.00  0.00           C  
ATOM    816  C   ASN A  58      46.581  44.729  47.551  1.00  0.00           C  
ATOM    817  O   ASN A  58      46.053  43.716  47.090  1.00  0.00           O  
ATOM    818  CB  ASN A  58      48.735  45.585  46.610  1.00  0.00           C  
ATOM    819  CG  ASN A  58      50.250  45.570  46.680  1.00  0.00           C  
ATOM    820  OD1 ASN A  58      50.847  46.156  47.581  1.00  0.00           O  
ATOM    821  ND2 ASN A  58      50.879  44.894  45.724  1.00  0.00           N  
ATOM    822  H   ASN A  58      48.816  42.953  47.016  1.00  0.00           H  
ATOM    823  HA  ASN A  58      48.292  45.307  48.686  1.00  0.00           H  
ATOM    824  HB2 ASN A  58      48.433  45.151  45.669  1.00  0.00           H  
ATOM    825  HB3 ASN A  58      48.401  46.611  46.653  1.00  0.00           H  
ATOM    826 HD21 ASN A  58      50.339  44.451  45.038  1.00  0.00           H  
ATOM    827 HD22 ASN A  58      51.858  44.867  45.745  1.00  0.00           H  
ATOM    828  N   ASP A  59      45.891  45.811  47.895  1.00  0.00           N  
ATOM    829  CA  ASP A  59      44.441  45.872  47.750  1.00  0.00           C  
ATOM    830  C   ASP A  59      44.053  46.572  46.451  1.00  0.00           C  
ATOM    831  O   ASP A  59      43.098  47.347  46.412  1.00  0.00           O  
ATOM    832  CB  ASP A  59      43.820  46.603  48.942  1.00  0.00           C  
ATOM    833  CG  ASP A  59      44.277  46.036  50.271  1.00  0.00           C  
ATOM    834  OD1 ASP A  59      45.503  45.911  50.472  1.00  0.00           O  
ATOM    835  OD2 ASP A  59      43.410  45.717  51.111  1.00  0.00           O  
ATOM    836  H   ASP A  59      46.369  46.587  48.256  1.00  0.00           H  
ATOM    837  HA  ASP A  59      44.068  44.860  47.726  1.00  0.00           H  
ATOM    838  HB2 ASP A  59      44.097  47.646  48.902  1.00  0.00           H  
ATOM    839  HB3 ASP A  59      42.743  46.520  48.887  1.00  0.00           H  
ATOM    840  N   GLY A  60      44.802  46.292  45.388  1.00  0.00           N  
ATOM    841  CA  GLY A  60      44.519  46.901  44.102  1.00  0.00           C  
ATOM    842  C   GLY A  60      44.641  48.412  44.137  1.00  0.00           C  
ATOM    843  O   GLY A  60      43.976  49.112  43.372  1.00  0.00           O  
ATOM    844  H   GLY A  60      45.550  45.666  45.479  1.00  0.00           H  
ATOM    845  HA2 GLY A  60      45.215  46.513  43.372  1.00  0.00           H  
ATOM    846  HA3 GLY A  60      43.516  46.638  43.803  1.00  0.00           H  
ATOM    847  N   SER A  61      45.490  48.916  45.027  1.00  0.00           N  
ATOM    848  CA  SER A  61      45.694  50.353  45.159  1.00  0.00           C  
ATOM    849  C   SER A  61      47.148  50.668  45.495  1.00  0.00           C  
ATOM    850  O   SER A  61      47.666  50.233  46.525  1.00  0.00           O  
ATOM    851  CB  SER A  61      44.773  50.924  46.239  1.00  0.00           C  
ATOM    852  OG  SER A  61      43.596  50.147  46.369  1.00  0.00           O  
ATOM    853  H   SER A  61      45.990  48.306  45.608  1.00  0.00           H  
ATOM    854  HA  SER A  61      45.450  50.811  44.213  1.00  0.00           H  
ATOM    855  HB2 SER A  61      45.293  50.928  47.187  1.00  0.00           H  
ATOM    856  HB3 SER A  61      44.497  51.934  45.977  1.00  0.00           H  
ATOM    857  HG  SER A  61      42.978  50.596  46.951  1.00  0.00           H  
ATOM    858  N   VAL A  62      47.803  51.426  44.622  1.00  0.00           N  
ATOM    859  CA  VAL A  62      49.197  51.799  44.827  1.00  0.00           C  
ATOM    860  C   VAL A  62      49.372  53.313  44.786  1.00  0.00           C  
ATOM    861  O   VAL A  62      49.233  53.936  43.733  1.00  0.00           O  
ATOM    862  CB  VAL A  62      50.111  51.160  43.765  1.00  0.00           C  
ATOM    863  CG1 VAL A  62      51.574  51.392  44.108  1.00  0.00           C  
ATOM    864  CG2 VAL A  62      49.817  49.672  43.633  1.00  0.00           C  
ATOM    865  H   VAL A  62      47.335  51.744  43.820  1.00  0.00           H  
ATOM    866  HA  VAL A  62      49.500  51.436  45.799  1.00  0.00           H  
ATOM    867  HB  VAL A  62      49.909  51.630  42.815  1.00  0.00           H  
ATOM    868 HG11 VAL A  62      51.861  50.743  44.924  1.00  0.00           H  
ATOM    869 HG12 VAL A  62      51.715  52.422  44.402  1.00  0.00           H  
ATOM    870 HG13 VAL A  62      52.186  51.176  43.246  1.00  0.00           H  
ATOM    871 HG21 VAL A  62      48.749  49.518  43.611  1.00  0.00           H  
ATOM    872 HG22 VAL A  62      50.241  49.146  44.474  1.00  0.00           H  
ATOM    873 HG23 VAL A  62      50.253  49.300  42.718  1.00  0.00           H  
ATOM    874  N   GLY A  63      49.679  53.900  45.939  1.00  0.00           N  
ATOM    875  CA  GLY A  63      49.867  55.336  46.013  1.00  0.00           C  
ATOM    876  C   GLY A  63      48.633  56.107  45.587  1.00  0.00           C  
ATOM    877  O   GLY A  63      47.573  55.982  46.200  1.00  0.00           O  
ATOM    878  H   GLY A  63      49.776  53.353  46.746  1.00  0.00           H  
ATOM    879  HA2 GLY A  63      50.112  55.604  47.031  1.00  0.00           H  
ATOM    880  HA3 GLY A  63      50.690  55.613  45.370  1.00  0.00           H  
ATOM    881  N   GLY A  64      48.771  56.905  44.534  1.00  0.00           N  
ATOM    882  CA  GLY A  64      47.650  57.686  44.044  1.00  0.00           C  
ATOM    883  C   GLY A  64      46.995  57.063  42.826  1.00  0.00           C  
ATOM    884  O   GLY A  64      46.389  57.761  42.014  1.00  0.00           O  
ATOM    885  H   GLY A  64      49.639  56.963  44.085  1.00  0.00           H  
ATOM    886  HA2 GLY A  64      46.915  57.771  44.830  1.00  0.00           H  
ATOM    887  HA3 GLY A  64      48.000  58.675  43.785  1.00  0.00           H  
ATOM    888  N   VAL A  65      47.117  55.745  42.699  1.00  0.00           N  
ATOM    889  CA  VAL A  65      46.532  55.029  41.572  1.00  0.00           C  
ATOM    890  C   VAL A  65      45.688  53.852  42.049  1.00  0.00           C  
ATOM    891  O   VAL A  65      46.114  53.072  42.901  1.00  0.00           O  
ATOM    892  CB  VAL A  65      47.619  54.508  40.610  1.00  0.00           C  
ATOM    893  CG1 VAL A  65      46.989  53.898  39.367  1.00  0.00           C  
ATOM    894  CG2 VAL A  65      48.583  55.623  40.234  1.00  0.00           C  
ATOM    895  H   VAL A  65      47.612  55.243  43.380  1.00  0.00           H  
ATOM    896  HA  VAL A  65      45.901  55.718  41.030  1.00  0.00           H  
ATOM    897  HB  VAL A  65      48.179  53.735  41.117  1.00  0.00           H  
ATOM    898 HG11 VAL A  65      46.656  52.895  39.586  1.00  0.00           H  
ATOM    899 HG12 VAL A  65      47.718  53.871  38.570  1.00  0.00           H  
ATOM    900 HG13 VAL A  65      46.144  54.498  39.061  1.00  0.00           H  
ATOM    901 HG21 VAL A  65      48.514  56.420  40.959  1.00  0.00           H  
ATOM    902 HG22 VAL A  65      48.327  56.005  39.256  1.00  0.00           H  
ATOM    903 HG23 VAL A  65      49.592  55.238  40.217  1.00  0.00           H  
ATOM    904  N   ARG A  66      44.485  53.731  41.496  1.00  0.00           N  
ATOM    905  CA  ARG A  66      43.579  52.649  41.865  1.00  0.00           C  
ATOM    906  C   ARG A  66      43.320  51.727  40.678  1.00  0.00           C  
ATOM    907  O   ARG A  66      43.086  52.188  39.562  1.00  0.00           O  
ATOM    908  CB  ARG A  66      42.256  53.219  42.382  1.00  0.00           C  
ATOM    909  CG  ARG A  66      41.616  52.375  43.471  1.00  0.00           C  
ATOM    910  CD  ARG A  66      40.163  52.760  43.692  1.00  0.00           C  
ATOM    911  NE  ARG A  66      40.023  54.153  44.116  1.00  0.00           N  
ATOM    912  CZ  ARG A  66      38.868  54.708  44.472  1.00  0.00           C  
ATOM    913  NH1 ARG A  66      37.749  53.994  44.458  1.00  0.00           N  
ATOM    914  NH2 ARG A  66      38.831  55.980  44.843  1.00  0.00           N  
ATOM    915  H   ARG A  66      44.200  54.384  40.823  1.00  0.00           H  
ATOM    916  HA  ARG A  66      44.047  52.080  42.653  1.00  0.00           H  
ATOM    917  HB2 ARG A  66      42.434  54.206  42.780  1.00  0.00           H  
ATOM    918  HB3 ARG A  66      41.562  53.291  41.557  1.00  0.00           H  
ATOM    919  HG2 ARG A  66      41.661  51.334  43.182  1.00  0.00           H  
ATOM    920  HG3 ARG A  66      42.161  52.519  44.392  1.00  0.00           H  
ATOM    921  HD2 ARG A  66      39.621  52.621  42.768  1.00  0.00           H  
ATOM    922  HD3 ARG A  66      39.744  52.120  44.455  1.00  0.00           H  
ATOM    923  HE  ARG A  66      40.835  54.702  44.135  1.00  0.00           H  
ATOM    924 HH11 ARG A  66      37.769  53.034  44.179  1.00  0.00           H  
ATOM    925 HH12 ARG A  66      36.883  54.418  44.728  1.00  0.00           H  
ATOM    926 HH21 ARG A  66      39.672  56.522  44.856  1.00  0.00           H  
ATOM    927 HH22 ARG A  66      37.963  56.397  45.112  1.00  0.00           H  
ATOM    928  N   TYR A  67      43.365  50.423  40.928  1.00  0.00           N  
ATOM    929  CA  TYR A  67      43.135  49.435  39.880  1.00  0.00           C  
ATOM    930  C   TYR A  67      41.847  48.659  40.137  1.00  0.00           C  
ATOM    931  O   TYR A  67      41.105  48.345  39.206  1.00  0.00           O  
ATOM    932  CB  TYR A  67      44.317  48.468  39.794  1.00  0.00           C  
ATOM    933  CG  TYR A  67      45.628  49.141  39.453  1.00  0.00           C  
ATOM    934  CD1 TYR A  67      46.269  49.962  40.371  1.00  0.00           C  
ATOM    935  CD2 TYR A  67      46.223  48.954  38.212  1.00  0.00           C  
ATOM    936  CE1 TYR A  67      47.466  50.579  40.064  1.00  0.00           C  
ATOM    937  CE2 TYR A  67      47.422  49.567  37.897  1.00  0.00           C  
ATOM    938  CZ  TYR A  67      48.038  50.378  38.825  1.00  0.00           C  
ATOM    939  OH  TYR A  67      49.230  50.991  38.515  1.00  0.00           O  
ATOM    940  H   TYR A  67      43.556  50.116  41.839  1.00  0.00           H  
ATOM    941  HA  TYR A  67      43.043  49.962  38.942  1.00  0.00           H  
ATOM    942  HB2 TYR A  67      44.438  47.972  40.746  1.00  0.00           H  
ATOM    943  HB3 TYR A  67      44.114  47.730  39.033  1.00  0.00           H  
ATOM    944  HD1 TYR A  67      45.818  50.118  41.341  1.00  0.00           H  
ATOM    945  HD2 TYR A  67      45.737  48.319  37.486  1.00  0.00           H  
ATOM    946  HE1 TYR A  67      47.949  51.214  40.792  1.00  0.00           H  
ATOM    947  HE2 TYR A  67      47.868  49.410  36.927  1.00  0.00           H  
ATOM    948  HH  TYR A  67      49.121  51.943  38.553  1.00  0.00           H  
ATOM    949  N   PHE A  68      41.587  48.356  41.404  1.00  0.00           N  
ATOM    950  CA  PHE A  68      40.389  47.618  41.784  1.00  0.00           C  
ATOM    951  C   PHE A  68      40.300  47.467  43.299  1.00  0.00           C  
ATOM    952  O   PHE A  68      41.319  47.426  43.990  1.00  0.00           O  
ATOM    953  CB  PHE A  68      40.381  46.239  41.122  1.00  0.00           C  
ATOM    954  CG  PHE A  68      41.675  45.491  41.280  1.00  0.00           C  
ATOM    955  CD1 PHE A  68      42.696  45.645  40.357  1.00  0.00           C  
ATOM    956  CD2 PHE A  68      41.867  44.633  42.352  1.00  0.00           C  
ATOM    957  CE1 PHE A  68      43.886  44.957  40.499  1.00  0.00           C  
ATOM    958  CE2 PHE A  68      43.057  43.943  42.498  1.00  0.00           C  
ATOM    959  CZ  PHE A  68      44.067  44.106  41.571  1.00  0.00           C  
ATOM    960  H   PHE A  68      42.218  48.635  42.102  1.00  0.00           H  
ATOM    961  HA  PHE A  68      39.531  48.177  41.439  1.00  0.00           H  
ATOM    962  HB2 PHE A  68      39.597  45.640  41.561  1.00  0.00           H  
ATOM    963  HB3 PHE A  68      40.190  46.355  40.065  1.00  0.00           H  
ATOM    964  HD1 PHE A  68      42.556  46.310  39.518  1.00  0.00           H  
ATOM    965  HD2 PHE A  68      41.079  44.505  43.076  1.00  0.00           H  
ATOM    966  HE1 PHE A  68      44.676  45.087  39.772  1.00  0.00           H  
ATOM    967  HE2 PHE A  68      43.195  43.278  43.338  1.00  0.00           H  
ATOM    968  HZ  PHE A  68      44.997  43.568  41.684  1.00  0.00           H  
ATOM    969  N   ILE A  69      39.076  47.385  43.811  1.00  0.00           N  
ATOM    970  CA  ILE A  69      38.854  47.239  45.244  1.00  0.00           C  
ATOM    971  C   ILE A  69      38.592  45.784  45.614  1.00  0.00           C  
ATOM    972  O   ILE A  69      37.478  45.286  45.462  1.00  0.00           O  
ATOM    973  CB  ILE A  69      37.669  48.099  45.721  1.00  0.00           C  
ATOM    974  CG1 ILE A  69      37.792  49.525  45.180  1.00  0.00           C  
ATOM    975  CG2 ILE A  69      37.597  48.105  47.241  1.00  0.00           C  
ATOM    976  CD1 ILE A  69      36.964  49.774  43.939  1.00  0.00           C  
ATOM    977  H   ILE A  69      38.303  47.425  43.209  1.00  0.00           H  
ATOM    978  HA  ILE A  69      39.745  47.576  45.754  1.00  0.00           H  
ATOM    979  HB  ILE A  69      36.759  47.657  45.344  1.00  0.00           H  
ATOM    980 HG12 ILE A  69      37.468  50.221  45.939  1.00  0.00           H  
ATOM    981 HG13 ILE A  69      38.826  49.721  44.935  1.00  0.00           H  
ATOM    982 HG21 ILE A  69      36.836  48.800  47.562  1.00  0.00           H  
ATOM    983 HG22 ILE A  69      38.553  48.405  47.644  1.00  0.00           H  
ATOM    984 HG23 ILE A  69      37.351  47.115  47.594  1.00  0.00           H  
ATOM    985 HD11 ILE A  69      36.249  48.973  43.815  1.00  0.00           H  
ATOM    986 HD12 ILE A  69      37.612  49.816  43.076  1.00  0.00           H  
ATOM    987 HD13 ILE A  69      36.438  50.712  44.039  1.00  0.00           H  
ATOM    988  N   CYS A  70      39.628  45.106  46.099  1.00  0.00           N  
ATOM    989  CA  CYS A  70      39.510  43.705  46.490  1.00  0.00           C  
ATOM    990  C   CYS A  70      39.689  43.545  47.998  1.00  0.00           C  
ATOM    991  O   CYS A  70      40.244  44.420  48.663  1.00  0.00           O  
ATOM    992  CB  CYS A  70      40.545  42.857  45.750  1.00  0.00           C  
ATOM    993  SG  CYS A  70      42.260  43.273  46.146  1.00  0.00           S  
ATOM    994  H   CYS A  70      40.492  45.557  46.196  1.00  0.00           H  
ATOM    995  HA  CYS A  70      38.520  43.368  46.220  1.00  0.00           H  
ATOM    996  HB2 CYS A  70      40.393  41.818  45.999  1.00  0.00           H  
ATOM    997  HB3 CYS A  70      40.412  42.990  44.686  1.00  0.00           H  
ATOM    998  HG  CYS A  70      42.258  43.812  46.941  1.00  0.00           H  
ATOM    999  N   PRO A  71      39.218  42.418  48.561  1.00  0.00           N  
ATOM   1000  CA  PRO A  71      39.328  42.146  49.997  1.00  0.00           C  
ATOM   1001  C   PRO A  71      40.757  42.302  50.509  1.00  0.00           C  
ATOM   1002  O   PRO A  71      41.673  42.594  49.738  1.00  0.00           O  
ATOM   1003  CB  PRO A  71      38.871  40.691  50.121  1.00  0.00           C  
ATOM   1004  CG  PRO A  71      37.984  40.471  48.947  1.00  0.00           C  
ATOM   1005  CD  PRO A  71      38.542  41.322  47.840  1.00  0.00           C  
ATOM   1006  HA  PRO A  71      38.671  42.783  50.571  1.00  0.00           H  
ATOM   1007  HB2 PRO A  71      39.731  40.039  50.095  1.00  0.00           H  
ATOM   1008  HB3 PRO A  71      38.338  40.555  51.051  1.00  0.00           H  
ATOM   1009  HG2 PRO A  71      38.000  39.429  48.663  1.00  0.00           H  
ATOM   1010  HG3 PRO A  71      36.976  40.781  49.185  1.00  0.00           H  
ATOM   1011  HD2 PRO A  71      39.247  40.758  47.249  1.00  0.00           H  
ATOM   1012  HD3 PRO A  71      37.745  41.704  47.219  1.00  0.00           H  
ATOM   1013  N   PRO A  72      40.970  42.108  51.822  1.00  0.00           N  
ATOM   1014  CA  PRO A  72      42.296  42.228  52.434  1.00  0.00           C  
ATOM   1015  C   PRO A  72      43.345  41.383  51.715  1.00  0.00           C  
ATOM   1016  O   PRO A  72      43.364  40.159  51.845  1.00  0.00           O  
ATOM   1017  CB  PRO A  72      42.081  41.713  53.859  1.00  0.00           C  
ATOM   1018  CG  PRO A  72      40.633  41.939  54.128  1.00  0.00           C  
ATOM   1019  CD  PRO A  72      39.934  41.755  52.811  1.00  0.00           C  
ATOM   1020  HA  PRO A  72      42.625  43.256  52.466  1.00  0.00           H  
ATOM   1021  HB2 PRO A  72      42.332  40.663  53.907  1.00  0.00           H  
ATOM   1022  HB3 PRO A  72      42.702  42.269  54.545  1.00  0.00           H  
ATOM   1023  HG2 PRO A  72      40.276  41.217  54.847  1.00  0.00           H  
ATOM   1024  HG3 PRO A  72      40.481  42.943  54.496  1.00  0.00           H  
ATOM   1025  HD2 PRO A  72      39.619  40.729  52.691  1.00  0.00           H  
ATOM   1026  HD3 PRO A  72      39.088  42.422  52.737  1.00  0.00           H  
ATOM   1027  N   LYS A  73      44.213  42.046  50.960  1.00  0.00           N  
ATOM   1028  CA  LYS A  73      45.265  41.356  50.221  1.00  0.00           C  
ATOM   1029  C   LYS A  73      44.673  40.351  49.239  1.00  0.00           C  
ATOM   1030  O   LYS A  73      44.530  39.170  49.555  1.00  0.00           O  
ATOM   1031  CB  LYS A  73      46.213  40.644  51.187  1.00  0.00           C  
ATOM   1032  CG  LYS A  73      46.838  41.568  52.220  1.00  0.00           C  
ATOM   1033  CD  LYS A  73      46.453  41.167  53.637  1.00  0.00           C  
ATOM   1034  CE  LYS A  73      47.183  42.010  54.671  1.00  0.00           C  
ATOM   1035  NZ  LYS A  73      46.362  43.167  55.125  1.00  0.00           N  
ATOM   1036  H   LYS A  73      44.146  43.021  50.898  1.00  0.00           H  
ATOM   1037  HA  LYS A  73      45.821  42.098  49.668  1.00  0.00           H  
ATOM   1038  HB2 LYS A  73      45.664  39.873  51.707  1.00  0.00           H  
ATOM   1039  HB3 LYS A  73      47.009  40.185  50.619  1.00  0.00           H  
ATOM   1040  HG2 LYS A  73      47.912  41.526  52.125  1.00  0.00           H  
ATOM   1041  HG3 LYS A  73      46.499  42.578  52.036  1.00  0.00           H  
ATOM   1042  HD2 LYS A  73      45.389  41.304  53.763  1.00  0.00           H  
ATOM   1043  HD3 LYS A  73      46.706  40.128  53.786  1.00  0.00           H  
ATOM   1044  HE2 LYS A  73      47.416  41.387  55.522  1.00  0.00           H  
ATOM   1045  HE3 LYS A  73      48.099  42.379  54.233  1.00  0.00           H  
ATOM   1046  HZ1 LYS A  73      46.928  43.784  55.742  1.00  0.00           H  
ATOM   1047  HZ2 LYS A  73      45.535  42.829  55.657  1.00  0.00           H  
ATOM   1048  HZ3 LYS A  73      46.035  43.716  54.305  1.00  0.00           H  
ATOM   1049  N   GLN A  74      44.329  40.828  48.046  1.00  0.00           N  
ATOM   1050  CA  GLN A  74      43.752  39.970  47.018  1.00  0.00           C  
ATOM   1051  C   GLN A  74      44.073  40.500  45.623  1.00  0.00           C  
ATOM   1052  O   GLN A  74      43.325  40.266  44.673  1.00  0.00           O  
ATOM   1053  CB  GLN A  74      42.237  39.866  47.205  1.00  0.00           C  
ATOM   1054  CG  GLN A  74      41.721  38.437  47.199  1.00  0.00           C  
ATOM   1055  CD  GLN A  74      40.208  38.364  47.124  1.00  0.00           C  
ATOM   1056  OE1 GLN A  74      39.550  37.918  48.063  1.00  0.00           O  
ATOM   1057  NE2 GLN A  74      39.650  38.802  46.002  1.00  0.00           N  
ATOM   1058  H   GLN A  74      44.468  41.779  47.853  1.00  0.00           H  
ATOM   1059  HA  GLN A  74      44.186  38.988  47.126  1.00  0.00           H  
ATOM   1060  HB2 GLN A  74      41.971  40.318  48.149  1.00  0.00           H  
ATOM   1061  HB3 GLN A  74      41.747  40.406  46.408  1.00  0.00           H  
ATOM   1062  HG2 GLN A  74      42.133  37.923  46.345  1.00  0.00           H  
ATOM   1063  HG3 GLN A  74      42.046  37.947  48.105  1.00  0.00           H  
ATOM   1064 HE21 GLN A  74      40.237  39.144  45.296  1.00  0.00           H  
ATOM   1065 HE22 GLN A  74      38.673  38.766  45.926  1.00  0.00           H  
ATOM   1066  N   GLY A  75      45.188  41.213  45.506  1.00  0.00           N  
ATOM   1067  CA  GLY A  75      45.586  41.763  44.223  1.00  0.00           C  
ATOM   1068  C   GLY A  75      47.078  41.653  43.982  1.00  0.00           C  
ATOM   1069  O   GLY A  75      47.880  41.966  44.863  1.00  0.00           O  
ATOM   1070  H   GLY A  75      45.747  41.369  46.296  1.00  0.00           H  
ATOM   1071  HA2 GLY A  75      45.066  41.232  43.440  1.00  0.00           H  
ATOM   1072  HA3 GLY A  75      45.302  42.804  44.186  1.00  0.00           H  
ATOM   1073  N   LEU A  76      47.452  41.207  42.788  1.00  0.00           N  
ATOM   1074  CA  LEU A  76      48.858  41.057  42.434  1.00  0.00           C  
ATOM   1075  C   LEU A  76      49.108  41.498  40.995  1.00  0.00           C  
ATOM   1076  O   LEU A  76      48.373  41.120  40.083  1.00  0.00           O  
ATOM   1077  CB  LEU A  76      49.298  39.603  42.619  1.00  0.00           C  
ATOM   1078  CG  LEU A  76      50.784  39.412  42.933  1.00  0.00           C  
ATOM   1079  CD1 LEU A  76      50.980  38.240  43.883  1.00  0.00           C  
ATOM   1080  CD2 LEU A  76      51.575  39.201  41.651  1.00  0.00           C  
ATOM   1081  H   LEU A  76      46.765  40.974  42.128  1.00  0.00           H  
ATOM   1082  HA  LEU A  76      49.435  41.686  43.095  1.00  0.00           H  
ATOM   1083  HB2 LEU A  76      48.721  39.175  43.425  1.00  0.00           H  
ATOM   1084  HB3 LEU A  76      49.073  39.064  41.711  1.00  0.00           H  
ATOM   1085  HG  LEU A  76      51.159  40.302  43.418  1.00  0.00           H  
ATOM   1086 HD11 LEU A  76      51.201  37.349  43.313  1.00  0.00           H  
ATOM   1087 HD12 LEU A  76      50.080  38.087  44.458  1.00  0.00           H  
ATOM   1088 HD13 LEU A  76      51.802  38.452  44.550  1.00  0.00           H  
ATOM   1089 HD21 LEU A  76      52.626  39.363  41.847  1.00  0.00           H  
ATOM   1090 HD22 LEU A  76      51.237  39.900  40.900  1.00  0.00           H  
ATOM   1091 HD23 LEU A  76      51.426  38.192  41.297  1.00  0.00           H  
ATOM   1092  N   PHE A  77      50.151  42.299  40.800  1.00  0.00           N  
ATOM   1093  CA  PHE A  77      50.499  42.790  39.471  1.00  0.00           C  
ATOM   1094  C   PHE A  77      51.697  42.033  38.908  1.00  0.00           C  
ATOM   1095  O   PHE A  77      52.675  41.786  39.613  1.00  0.00           O  
ATOM   1096  CB  PHE A  77      50.804  44.289  39.523  1.00  0.00           C  
ATOM   1097  CG  PHE A  77      49.707  45.103  40.147  1.00  0.00           C  
ATOM   1098  CD1 PHE A  77      48.554  45.396  39.435  1.00  0.00           C  
ATOM   1099  CD2 PHE A  77      49.830  45.577  41.443  1.00  0.00           C  
ATOM   1100  CE1 PHE A  77      47.544  46.145  40.007  1.00  0.00           C  
ATOM   1101  CE2 PHE A  77      48.823  46.328  42.019  1.00  0.00           C  
ATOM   1102  CZ  PHE A  77      47.678  46.612  41.300  1.00  0.00           C  
ATOM   1103  H   PHE A  77      50.700  42.565  41.566  1.00  0.00           H  
ATOM   1104  HA  PHE A  77      49.649  42.627  38.826  1.00  0.00           H  
ATOM   1105  HB2 PHE A  77      51.703  44.444  40.100  1.00  0.00           H  
ATOM   1106  HB3 PHE A  77      50.960  44.652  38.518  1.00  0.00           H  
ATOM   1107  HD1 PHE A  77      48.448  45.031  38.425  1.00  0.00           H  
ATOM   1108  HD2 PHE A  77      50.725  45.356  42.006  1.00  0.00           H  
ATOM   1109  HE1 PHE A  77      46.649  46.365  39.443  1.00  0.00           H  
ATOM   1110  HE2 PHE A  77      48.930  46.691  43.030  1.00  0.00           H  
ATOM   1111  HZ  PHE A  77      46.890  47.199  41.749  1.00  0.00           H  
ATOM   1112  N   ALA A  78      51.615  41.671  37.632  1.00  0.00           N  
ATOM   1113  CA  ALA A  78      52.692  40.943  36.974  1.00  0.00           C  
ATOM   1114  C   ALA A  78      52.674  41.181  35.467  1.00  0.00           C  
ATOM   1115  O   ALA A  78      51.696  41.688  34.921  1.00  0.00           O  
ATOM   1116  CB  ALA A  78      52.587  39.455  37.277  1.00  0.00           C  
ATOM   1117  H   ALA A  78      50.809  41.897  37.122  1.00  0.00           H  
ATOM   1118  HA  ALA A  78      53.629  41.302  37.374  1.00  0.00           H  
ATOM   1119  HB1 ALA A  78      52.002  39.313  38.174  1.00  0.00           H  
ATOM   1120  HB2 ALA A  78      53.575  39.047  37.422  1.00  0.00           H  
ATOM   1121  HB3 ALA A  78      52.106  38.953  36.451  1.00  0.00           H  
ATOM   1122  N   SER A  79      53.764  40.810  34.803  1.00  0.00           N  
ATOM   1123  CA  SER A  79      53.874  40.982  33.360  1.00  0.00           C  
ATOM   1124  C   SER A  79      53.104  39.891  32.621  1.00  0.00           C  
ATOM   1125  O   SER A  79      53.019  38.755  33.087  1.00  0.00           O  
ATOM   1126  CB  SER A  79      55.343  40.965  32.933  1.00  0.00           C  
ATOM   1127  OG  SER A  79      55.865  42.280  32.847  1.00  0.00           O  
ATOM   1128  H   SER A  79      54.511  40.410  35.295  1.00  0.00           H  
ATOM   1129  HA  SER A  79      53.445  41.941  33.107  1.00  0.00           H  
ATOM   1130  HB2 SER A  79      55.919  40.410  33.657  1.00  0.00           H  
ATOM   1131  HB3 SER A  79      55.430  40.492  31.965  1.00  0.00           H  
ATOM   1132  HG  SER A  79      55.594  42.782  33.618  1.00  0.00           H  
ATOM   1133  N   VAL A  80      52.548  40.244  31.467  1.00  0.00           N  
ATOM   1134  CA  VAL A  80      51.786  39.296  30.663  1.00  0.00           C  
ATOM   1135  C   VAL A  80      52.637  38.087  30.284  1.00  0.00           C  
ATOM   1136  O   VAL A  80      52.123  36.980  30.124  1.00  0.00           O  
ATOM   1137  CB  VAL A  80      51.248  39.954  29.379  1.00  0.00           C  
ATOM   1138  CG1 VAL A  80      50.180  40.983  29.712  1.00  0.00           C  
ATOM   1139  CG2 VAL A  80      52.383  40.587  28.590  1.00  0.00           C  
ATOM   1140  H   VAL A  80      52.650  41.164  31.148  1.00  0.00           H  
ATOM   1141  HA  VAL A  80      50.943  38.960  31.252  1.00  0.00           H  
ATOM   1142  HB  VAL A  80      50.798  39.186  28.768  1.00  0.00           H  
ATOM   1143 HG11 VAL A  80      49.204  40.527  29.637  1.00  0.00           H  
ATOM   1144 HG12 VAL A  80      50.247  41.808  29.019  1.00  0.00           H  
ATOM   1145 HG13 VAL A  80      50.331  41.346  30.718  1.00  0.00           H  
ATOM   1146 HG21 VAL A  80      52.727  39.896  27.835  1.00  0.00           H  
ATOM   1147 HG22 VAL A  80      53.198  40.825  29.258  1.00  0.00           H  
ATOM   1148 HG23 VAL A  80      52.032  41.491  28.116  1.00  0.00           H  
ATOM   1149  N   SER A  81      53.938  38.309  30.142  1.00  0.00           N  
ATOM   1150  CA  SER A  81      54.861  37.240  29.782  1.00  0.00           C  
ATOM   1151  C   SER A  81      54.906  36.167  30.865  1.00  0.00           C  
ATOM   1152  O   SER A  81      55.161  34.997  30.583  1.00  0.00           O  
ATOM   1153  CB  SER A  81      56.263  37.805  29.550  1.00  0.00           C  
ATOM   1154  OG  SER A  81      57.029  36.949  28.719  1.00  0.00           O  
ATOM   1155  H   SER A  81      54.288  39.214  30.282  1.00  0.00           H  
ATOM   1156  HA  SER A  81      54.508  36.793  28.863  1.00  0.00           H  
ATOM   1157  HB2 SER A  81      56.187  38.771  29.074  1.00  0.00           H  
ATOM   1158  HB3 SER A  81      56.768  37.910  30.500  1.00  0.00           H  
ATOM   1159  HG  SER A  81      57.353  36.208  29.236  1.00  0.00           H  
ATOM   1160  N   LYS A  82      54.657  36.574  32.106  1.00  0.00           N  
ATOM   1161  CA  LYS A  82      54.671  35.647  33.231  1.00  0.00           C  
ATOM   1162  C   LYS A  82      53.257  35.195  33.585  1.00  0.00           C  
ATOM   1163  O   LYS A  82      52.960  34.904  34.744  1.00  0.00           O  
ATOM   1164  CB  LYS A  82      55.330  36.298  34.448  1.00  0.00           C  
ATOM   1165  CG  LYS A  82      56.708  36.872  34.159  1.00  0.00           C  
ATOM   1166  CD  LYS A  82      57.463  37.182  35.441  1.00  0.00           C  
ATOM   1167  CE  LYS A  82      58.336  36.013  35.869  1.00  0.00           C  
ATOM   1168  NZ  LYS A  82      57.649  35.143  36.863  1.00  0.00           N  
ATOM   1169  H   LYS A  82      54.461  37.520  32.270  1.00  0.00           H  
ATOM   1170  HA  LYS A  82      55.249  34.782  32.940  1.00  0.00           H  
ATOM   1171  HB2 LYS A  82      54.697  37.100  34.800  1.00  0.00           H  
ATOM   1172  HB3 LYS A  82      55.427  35.559  35.230  1.00  0.00           H  
ATOM   1173  HG2 LYS A  82      57.273  36.152  33.586  1.00  0.00           H  
ATOM   1174  HG3 LYS A  82      56.595  37.781  33.588  1.00  0.00           H  
ATOM   1175  HD2 LYS A  82      58.090  38.046  35.279  1.00  0.00           H  
ATOM   1176  HD3 LYS A  82      56.750  37.394  36.224  1.00  0.00           H  
ATOM   1177  HE2 LYS A  82      58.582  35.426  34.999  1.00  0.00           H  
ATOM   1178  HE3 LYS A  82      59.243  36.402  36.309  1.00  0.00           H  
ATOM   1179  HZ1 LYS A  82      57.161  35.725  37.573  1.00  0.00           H  
ATOM   1180  HZ2 LYS A  82      58.342  34.536  37.346  1.00  0.00           H  
ATOM   1181  HZ3 LYS A  82      56.951  34.537  36.386  1.00  0.00           H  
ATOM   1182  N   ILE A  83      52.390  35.136  32.579  1.00  0.00           N  
ATOM   1183  CA  ILE A  83      51.008  34.719  32.786  1.00  0.00           C  
ATOM   1184  C   ILE A  83      50.529  33.826  31.645  1.00  0.00           C  
ATOM   1185  O   ILE A  83      51.016  33.925  30.520  1.00  0.00           O  
ATOM   1186  CB  ILE A  83      50.064  35.931  32.903  1.00  0.00           C  
ATOM   1187  CG1 ILE A  83      50.609  36.934  33.922  1.00  0.00           C  
ATOM   1188  CG2 ILE A  83      48.665  35.478  33.295  1.00  0.00           C  
ATOM   1189  CD1 ILE A  83      49.911  38.276  33.884  1.00  0.00           C  
ATOM   1190  H   ILE A  83      52.685  35.379  31.677  1.00  0.00           H  
ATOM   1191  HA  ILE A  83      50.962  34.162  33.710  1.00  0.00           H  
ATOM   1192  HB  ILE A  83      50.003  36.408  31.937  1.00  0.00           H  
ATOM   1193 HG12 ILE A  83      50.491  36.529  34.915  1.00  0.00           H  
ATOM   1194 HG13 ILE A  83      51.659  37.099  33.728  1.00  0.00           H  
ATOM   1195 HG21 ILE A  83      48.176  36.262  33.855  1.00  0.00           H  
ATOM   1196 HG22 ILE A  83      48.732  34.589  33.904  1.00  0.00           H  
ATOM   1197 HG23 ILE A  83      48.094  35.264  32.404  1.00  0.00           H  
ATOM   1198 HD11 ILE A  83      50.646  39.061  33.783  1.00  0.00           H  
ATOM   1199 HD12 ILE A  83      49.353  38.419  34.797  1.00  0.00           H  
ATOM   1200 HD13 ILE A  83      49.237  38.306  33.040  1.00  0.00           H  
ATOM   1201  N   SER A  84      49.571  32.955  31.946  1.00  0.00           N  
ATOM   1202  CA  SER A  84      49.025  32.045  30.946  1.00  0.00           C  
ATOM   1203  C   SER A  84      47.502  32.105  30.929  1.00  0.00           C  
ATOM   1204  O   SER A  84      46.875  32.497  31.914  1.00  0.00           O  
ATOM   1205  CB  SER A  84      49.486  30.612  31.225  1.00  0.00           C  
ATOM   1206  OG  SER A  84      50.670  30.309  30.506  1.00  0.00           O  
ATOM   1207  H   SER A  84      49.223  32.925  32.861  1.00  0.00           H  
ATOM   1208  HA  SER A  84      49.397  32.351  29.980  1.00  0.00           H  
ATOM   1209  HB2 SER A  84      49.684  30.499  32.280  1.00  0.00           H  
ATOM   1210  HB3 SER A  84      48.710  29.922  30.928  1.00  0.00           H  
ATOM   1211  HG  SER A  84      50.525  29.524  29.970  1.00  0.00           H  
ATOM   1212  N   LYS A  85      46.911  31.719  29.802  1.00  0.00           N  
ATOM   1213  CA  LYS A  85      45.461  31.731  29.658  1.00  0.00           C  
ATOM   1214  C   LYS A  85      44.839  30.499  30.308  1.00  0.00           C  
ATOM   1215  O   LYS A  85      45.019  29.377  29.835  1.00  0.00           O  
ATOM   1216  CB  LYS A  85      45.075  31.790  28.178  1.00  0.00           C  
ATOM   1217  CG  LYS A  85      45.087  33.197  27.603  1.00  0.00           C  
ATOM   1218  CD  LYS A  85      46.120  33.343  26.497  1.00  0.00           C  
ATOM   1219  CE  LYS A  85      45.486  33.217  25.123  1.00  0.00           C  
ATOM   1220  NZ  LYS A  85      44.666  34.410  24.777  1.00  0.00           N  
ATOM   1221  H   LYS A  85      47.465  31.418  29.053  1.00  0.00           H  
ATOM   1222  HA  LYS A  85      45.085  32.613  30.154  1.00  0.00           H  
ATOM   1223  HB2 LYS A  85      45.770  31.186  27.613  1.00  0.00           H  
ATOM   1224  HB3 LYS A  85      44.081  31.385  28.060  1.00  0.00           H  
ATOM   1225  HG2 LYS A  85      44.110  33.419  27.199  1.00  0.00           H  
ATOM   1226  HG3 LYS A  85      45.318  33.897  28.394  1.00  0.00           H  
ATOM   1227  HD2 LYS A  85      46.587  34.314  26.580  1.00  0.00           H  
ATOM   1228  HD3 LYS A  85      46.868  32.572  26.614  1.00  0.00           H  
ATOM   1229  HE2 LYS A  85      46.270  33.106  24.387  1.00  0.00           H  
ATOM   1230  HE3 LYS A  85      44.855  32.340  25.110  1.00  0.00           H  
ATOM   1231  HZ1 LYS A  85      43.826  34.120  24.235  1.00  0.00           H  
ATOM   1232  HZ2 LYS A  85      45.223  35.074  24.201  1.00  0.00           H  
ATOM   1233  HZ3 LYS A  85      44.358  34.895  25.643  1.00  0.00           H  
ATOM   1234  N   ALA A  86      44.105  30.717  31.395  1.00  0.00           N  
ATOM   1235  CA  ALA A  86      43.457  29.625  32.111  1.00  0.00           C  
ATOM   1236  C   ALA A  86      42.117  29.271  31.474  1.00  0.00           C  
ATOM   1237  O   ALA A  86      41.728  29.850  30.460  1.00  0.00           O  
ATOM   1238  CB  ALA A  86      43.267  29.994  33.575  1.00  0.00           C  
ATOM   1239  H   ALA A  86      43.999  31.634  31.724  1.00  0.00           H  
ATOM   1240  HA  ALA A  86      44.107  28.764  32.063  1.00  0.00           H  
ATOM   1241  HB1 ALA A  86      42.256  30.342  33.730  1.00  0.00           H  
ATOM   1242  HB2 ALA A  86      43.961  30.777  33.842  1.00  0.00           H  
ATOM   1243  HB3 ALA A  86      43.448  29.126  34.192  1.00  0.00           H  
ATOM   1244  N   VAL A  87      41.418  28.314  32.075  1.00  0.00           N  
ATOM   1245  CA  VAL A  87      40.121  27.882  31.568  1.00  0.00           C  
ATOM   1246  C   VAL A  87      40.255  27.251  30.186  1.00  0.00           C  
ATOM   1247  O   VAL A  87      40.917  27.797  29.305  1.00  0.00           O  
ATOM   1248  CB  VAL A  87      39.127  29.057  31.489  1.00  0.00           C  
ATOM   1249  CG1 VAL A  87      37.732  28.556  31.149  1.00  0.00           C  
ATOM   1250  CG2 VAL A  87      39.119  29.838  32.794  1.00  0.00           C  
ATOM   1251  H   VAL A  87      41.780  27.890  32.881  1.00  0.00           H  
ATOM   1252  HA  VAL A  87      39.722  27.147  32.252  1.00  0.00           H  
ATOM   1253  HB  VAL A  87      39.449  29.720  30.699  1.00  0.00           H  
ATOM   1254 HG11 VAL A  87      37.460  27.761  31.828  1.00  0.00           H  
ATOM   1255 HG12 VAL A  87      37.720  28.184  30.136  1.00  0.00           H  
ATOM   1256 HG13 VAL A  87      37.025  29.367  31.244  1.00  0.00           H  
ATOM   1257 HG21 VAL A  87      40.133  29.971  33.140  1.00  0.00           H  
ATOM   1258 HG22 VAL A  87      38.554  29.293  33.536  1.00  0.00           H  
ATOM   1259 HG23 VAL A  87      38.665  30.804  32.631  1.00  0.00           H  
ATOM   1260  N   ASP A  88      39.620  26.098  30.003  1.00  0.00           N  
ATOM   1261  CA  ASP A  88      39.666  25.392  28.729  1.00  0.00           C  
ATOM   1262  C   ASP A  88      41.101  25.020  28.367  1.00  0.00           C  
ATOM   1263  O   ASP A  88      41.823  25.809  27.757  1.00  0.00           O  
ATOM   1264  CB  ASP A  88      39.057  26.252  27.622  1.00  0.00           C  
ATOM   1265  CG  ASP A  88      37.541  26.277  27.679  1.00  0.00           C  
ATOM   1266  OD1 ASP A  88      36.951  25.315  28.211  1.00  0.00           O  
ATOM   1267  OD2 ASP A  88      36.945  27.261  27.192  1.00  0.00           O  
ATOM   1268  H   ASP A  88      39.106  25.712  30.745  1.00  0.00           H  
ATOM   1269  HA  ASP A  88      39.088  24.486  28.830  1.00  0.00           H  
ATOM   1270  HB2 ASP A  88      39.417  27.266  27.721  1.00  0.00           H  
ATOM   1271  HB3 ASP A  88      39.356  25.860  26.662  1.00  0.00           H  
ATOM   1272  N   ALA A  89      41.508  23.813  28.746  1.00  0.00           N  
ATOM   1273  CA  ALA A  89      42.856  23.336  28.460  1.00  0.00           C  
ATOM   1274  C   ALA A  89      42.832  22.191  27.453  1.00  0.00           C  
ATOM   1275  O   ALA A  89      43.693  21.311  27.477  1.00  0.00           O  
ATOM   1276  CB  ALA A  89      43.542  22.897  29.745  1.00  0.00           C  
ATOM   1277  H   ALA A  89      40.887  23.228  29.229  1.00  0.00           H  
ATOM   1278  HA  ALA A  89      43.418  24.158  28.041  1.00  0.00           H  
ATOM   1279  HB1 ALA A  89      44.566  22.624  29.531  1.00  0.00           H  
ATOM   1280  HB2 ALA A  89      43.023  22.046  30.158  1.00  0.00           H  
ATOM   1281  HB3 ALA A  89      43.528  23.708  30.456  1.00  0.00           H  
ATOM   1282  N   SER A  90      41.840  22.206  26.568  1.00  0.00           N  
ATOM   1283  CA  SER A  90      41.703  21.170  25.553  1.00  0.00           C  
ATOM   1284  C   SER A  90      41.808  21.766  24.153  1.00  0.00           C  
ATOM   1285  O   SER A  90      40.964  22.560  23.740  1.00  0.00           O  
ATOM   1286  CB  SER A  90      40.366  20.443  25.711  1.00  0.00           C  
ATOM   1287  OG  SER A  90      40.281  19.335  24.831  1.00  0.00           O  
ATOM   1288  H   SER A  90      41.184  22.934  26.600  1.00  0.00           H  
ATOM   1289  HA  SER A  90      42.506  20.462  25.690  1.00  0.00           H  
ATOM   1290  HB2 SER A  90      40.271  20.089  26.726  1.00  0.00           H  
ATOM   1291  HB3 SER A  90      39.559  21.126  25.490  1.00  0.00           H  
ATOM   1292  HG  SER A  90      39.366  19.204  24.568  1.00  0.00           H  
ATOM   1293  N   GLY A  91      42.854  21.379  23.427  1.00  0.00           N  
ATOM   1294  CA  GLY A  91      43.050  21.887  22.082  1.00  0.00           C  
ATOM   1295  C   GLY A  91      44.379  21.455  21.486  1.00  0.00           C  
ATOM   1296  O   GLY A  91      44.790  20.307  21.657  1.00  0.00           O  
ATOM   1297  H   GLY A  91      43.496  20.746  23.808  1.00  0.00           H  
ATOM   1298  HA2 GLY A  91      42.250  21.524  21.452  1.00  0.00           H  
ATOM   1299  HA3 GLY A  91      43.011  22.966  22.108  1.00  0.00           H  
ATOM   1300  N   PRO A  92      45.080  22.358  20.778  1.00  0.00           N  
ATOM   1301  CA  PRO A  92      46.374  22.043  20.161  1.00  0.00           C  
ATOM   1302  C   PRO A  92      47.343  21.390  21.143  1.00  0.00           C  
ATOM   1303  O   PRO A  92      47.497  21.847  22.275  1.00  0.00           O  
ATOM   1304  CB  PRO A  92      46.900  23.411  19.724  1.00  0.00           C  
ATOM   1305  CG  PRO A  92      45.677  24.233  19.512  1.00  0.00           C  
ATOM   1306  CD  PRO A  92      44.671  23.752  20.521  1.00  0.00           C  
ATOM   1307  HA  PRO A  92      46.255  21.407  19.297  1.00  0.00           H  
ATOM   1308  HB2 PRO A  92      47.524  23.825  20.501  1.00  0.00           H  
ATOM   1309  HB3 PRO A  92      47.469  23.307  18.812  1.00  0.00           H  
ATOM   1310  HG2 PRO A  92      45.903  25.277  19.675  1.00  0.00           H  
ATOM   1311  HG3 PRO A  92      45.303  24.083  18.510  1.00  0.00           H  
ATOM   1312  HD2 PRO A  92      44.729  24.343  21.423  1.00  0.00           H  
ATOM   1313  HD3 PRO A  92      43.674  23.790  20.107  1.00  0.00           H  
ATOM   1314  N   SER A  93      47.991  20.318  20.701  1.00  0.00           N  
ATOM   1315  CA  SER A  93      48.943  19.601  21.539  1.00  0.00           C  
ATOM   1316  C   SER A  93      49.803  18.658  20.704  1.00  0.00           C  
ATOM   1317  O   SER A  93      49.337  18.092  19.714  1.00  0.00           O  
ATOM   1318  CB  SER A  93      48.208  18.812  22.624  1.00  0.00           C  
ATOM   1319  OG  SER A  93      49.121  18.171  23.498  1.00  0.00           O  
ATOM   1320  H   SER A  93      47.825  20.002  19.789  1.00  0.00           H  
ATOM   1321  HA  SER A  93      49.585  20.330  22.010  1.00  0.00           H  
ATOM   1322  HB2 SER A  93      47.591  19.484  23.201  1.00  0.00           H  
ATOM   1323  HB3 SER A  93      47.584  18.062  22.160  1.00  0.00           H  
ATOM   1324  HG  SER A  93      49.773  18.805  23.801  1.00  0.00           H  
ATOM   1325  N   SER A  94      51.058  18.493  21.107  1.00  0.00           N  
ATOM   1326  CA  SER A  94      51.981  17.620  20.395  1.00  0.00           C  
ATOM   1327  C   SER A  94      53.043  17.063  21.337  1.00  0.00           C  
ATOM   1328  O   SER A  94      53.321  15.865  21.337  1.00  0.00           O  
ATOM   1329  CB  SER A  94      52.651  18.378  19.246  1.00  0.00           C  
ATOM   1330  OG  SER A  94      51.921  18.227  18.041  1.00  0.00           O  
ATOM   1331  H   SER A  94      51.371  18.972  21.903  1.00  0.00           H  
ATOM   1332  HA  SER A  94      51.413  16.798  19.987  1.00  0.00           H  
ATOM   1333  HB2 SER A  94      52.701  19.429  19.492  1.00  0.00           H  
ATOM   1334  HB3 SER A  94      53.650  17.994  19.098  1.00  0.00           H  
ATOM   1335  HG  SER A  94      52.426  18.597  17.313  1.00  0.00           H  
ATOM   1336  N   GLY A  95      53.631  17.943  22.143  1.00  0.00           N  
ATOM   1337  CA  GLY A  95      54.656  17.520  23.080  1.00  0.00           C  
ATOM   1338  C   GLY A  95      55.420  18.688  23.669  1.00  0.00           C  
ATOM   1339  O   GLY A  95      56.472  19.054  23.103  1.00  0.00           O  
ATOM   1340  OXT GLY A  95      54.968  19.240  24.695  1.00  0.00           O  
ATOM   1341  H   GLY A  95      53.369  18.886  22.099  1.00  0.00           H  
ATOM   1342  HA2 GLY A  95      54.187  16.970  23.883  1.00  0.00           H  
ATOM   1343  HA3 GLY A  95      55.349  16.870  22.569  1.00  0.00           H  
TER    1344      GLY A  95                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
