
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  168 ( 1294),  selected  168 , name 1ejb_A
# Molecule2: number of CA atoms  150 ( 1143),  selected  150 , name T0487_317_466.pdb
# PARAMETERS: 1ejb_A.T0487_317_466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      S     317           -
LGA    V     2_A      I     318           -
LGA    K     3_A      P     319           -
LGA    G     4_A      K     320           -
LGA    L     5_A      L     321           -
LGA    -       -      M     322           -
LGA    -       -      G     323           -
LGA    -       -      R     324           -
LGA    -       -      R     325           -
LGA    -       -      A     326           -
LGA    -       -      V     327           -
LGA    -       -      S     328           -
LGA    -       -      K     329           -
LGA    -       -      P     330           -
LGA    G     6_A      A     331          4.810
LGA    K     7_A      D     332          1.812
LGA    P     8_A      A     333          5.197
LGA    D     9_A      L     334           -
LGA    -       -      R     335           -
LGA    -       -      V     336           -
LGA    Q    10_A      G     337           #
LGA    V    11_A      F     338          3.091
LGA    Y    12_A      Y     339          4.385
LGA    D    13_A      R     340          4.516
LGA    G    14_A      A     341          4.490
LGA    S    15_A      Q     342          4.308
LGA    K    16_A      E     343          0.697
LGA    I    17_A      T     344          1.138
LGA    R    18_A      A     345          0.818
LGA    V    19_A      L     346          0.853
LGA    G    20_A      A     347          0.860
LGA    I    21_A      L     348          0.797
LGA    I    22_A      L     349          1.327
LGA    H    23_A      R     350          0.647
LGA    A    24_A      L     351          2.086
LGA    R    25_A      D     352          3.932
LGA    W    26_A      G     353          2.928
LGA    N    27_A      -       -           -
LGA    R    28_A      A     354          4.618
LGA    V    29_A      Q     355           -
LGA    I    30_A      -       -           -
LGA    I    31_A      -       -           -
LGA    D    32_A      G     356           #
LGA    A    33_A      -       -           -
LGA    L    34_A      W     357           #
LGA    V    35_A      P     358          3.308
LGA    K    36_A      E     359          3.131
LGA    G    37_A      F     360          3.424
LGA    A    38_A      L     361          3.109
LGA    I    39_A      R     362          2.412
LGA    E    40_A      R     363          2.430
LGA    R    41_A      A     364          2.486
LGA    M    42_A      L     365          2.133
LGA    A    43_A      L     366          1.760
LGA    S    44_A      R     367          2.473
LGA    L    45_A      A     368          2.469
LGA    G    46_A      F     369          1.077
LGA    -       -      G     370           -
LGA    -       -      A     371           -
LGA    -       -      S     372           -
LGA    -       -      G     373           -
LGA    V    47_A      A     374           #
LGA    E    48_A      S     375          3.953
LGA    E    49_A      L     376           #
LGA    N    50_A      -       -           -
LGA    N    51_A      R     377          1.118
LGA    I    52_A      L     378          1.008
LGA    I    53_A      H     379          0.409
LGA    I    54_A      T     380          0.950
LGA    E    55_A      L     381          1.979
LGA    T    56_A      H     382          3.692
LGA    V    57_A      A     383          4.933
LGA    P    58_A      H     384          5.071
LGA    G    59_A      -       -           -
LGA    S    60_A      -       -           -
LGA    Y    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    L    63_A      P     385          3.813
LGA    P    64_A      S     386          4.356
LGA    -       -      Q     387           -
LGA    -       -      G     388           -
LGA    -       -      L     389           -
LGA    W    65_A      A     390           #
LGA    G    66_A      F     391          3.494
LGA    T    67_A      -       -           -
LGA    K    68_A      R     392          3.960
LGA    R    69_A      E     393          3.091
LGA    F    70_A      A     394          2.907
LGA    V    71_A      L     395          2.543
LGA    D    72_A      R     396          0.833
LGA    R    73_A      K     397          1.431
LGA    Q    74_A      A     398          2.325
LGA    A    75_A      K     399          3.982
LGA    K    76_A      E     400          4.551
LGA    L    77_A      -       -           -
LGA    G    78_A      -       -           -
LGA    K    79_A      E     401          1.947
LGA    P    80_A      G     402          1.904
LGA    L    81_A      V     403          0.841
LGA    D    82_A      Q     404          1.087
LGA    V    83_A      A     405          1.065
LGA    V    84_A      V     406          1.080
LGA    I    85_A      L     407          1.033
LGA    P    86_A      V     408          1.775
LGA    I    87_A      L     409          1.402
LGA    G    88_A      T     410          1.622
LGA    V    89_A      P     411          2.563
LGA    L    90_A      P     412          4.666
LGA    I    91_A      -       -           -
LGA    K    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    T    95_A      -       -           -
LGA    M    96_A      -       -           -
LGA    H    97_A      -       -           -
LGA    F    98_A      -       -           -
LGA    E    99_A      -       -           -
LGA    Y   100_A      -       -           -
LGA    I   101_A      M     413           #
LGA    S   102_A      A     414          3.483
LGA    D   103_A      W     415          3.921
LGA    S   104_A      E     416          4.122
LGA    T   105_A      D     417          2.870
LGA    T   106_A      R     418          0.808
LGA    H   107_A      N     419          1.657
LGA    A   108_A      R     420          1.319
LGA    L   109_A      L     421          2.450
LGA    M   110_A      K     422          2.803
LGA    N   111_A      A     423          2.121
LGA    L   112_A      L     424          2.995
LGA    Q   113_A      L     425          4.753
LGA    E   114_A      L     426          3.613
LGA    K   115_A      R     427          0.632
LGA    V   116_A      E     428          2.042
LGA    D   117_A      G     429          1.978
LGA    M   118_A      L     430          3.293
LGA    P   119_A      P     431          1.538
LGA    V   120_A      S     432          0.901
LGA    I   121_A      Q     433          1.022
LGA    F   122_A      I     434          1.393
LGA    G   123_A      L     435          2.376
LGA    L   124_A      N     436          3.411
LGA    L   125_A      V     437          4.020
LGA    T   126_A      -       -           -
LGA    C   127_A      -       -           -
LGA    M   128_A      -       -           -
LGA    T   129_A      -       -           -
LGA    E   130_A      -       -           -
LGA    E   131_A      -       -           -
LGA    Q   132_A      -       -           -
LGA    A   133_A      P     438          2.290
LGA    L   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    R   136_A      -       -           -
LGA    A   137_A      L     439          1.585
LGA    G   138_A      R     440          2.129
LGA    I   139_A      -       -           -
LGA    D   140_A      -       -           -
LGA    E   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    H   143_A      E     441           #
LGA    S   144_A      E     442           #
LGA    M   145_A      E     443          3.624
LGA    H   146_A      R     444          3.045
LGA    N   147_A      H     445           #
LGA    H   148_A      R     446          3.624
LGA    G   149_A      W     447          3.769
LGA    E   150_A      E     448          3.636
LGA    D   151_A      N     449          2.875
LGA    W   152_A      A     450          2.438
LGA    G   153_A      L     451          2.472
LGA    A   154_A      L     452          2.506
LGA    A   155_A      G     453          1.917
LGA    A   156_A      L     454          1.529
LGA    V   157_A      L     455          1.556
LGA    E   158_A      A     456          1.777
LGA    M   159_A      K     457          1.621
LGA    A   160_A      A     458          1.439
LGA    V   161_A      G     459          2.454
LGA    -       -      L     460           -
LGA    K   162_A      Q     461          4.643
LGA    F   163_A      V     462           -
LGA    G   164_A      V     463           -
LGA    K   165_A      A     464           -
LGA    N   166_A      L     465           -
LGA    A   167_A      S     466           -
LGA    F   168_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  168  150    5.0    109    2.83     6.42     42.915     3.726

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.187852 * X  +  -0.654927 * Y  +  -0.731972 * Z  +  90.758041
  Y_new =   0.675036 * X  +  -0.455255 * Y  +   0.580576 * Z  + -22.883375
  Z_new =  -0.713469 * X  +  -0.603170 * Y  +   0.356579 * Z  + 107.219307 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.036892    2.104701  [ DEG:   -59.4095    120.5905 ]
  Theta =   0.794436    2.347156  [ DEG:    45.5179    134.4821 ]
  Phi   =   1.299379   -1.842213  [ DEG:    74.4489   -105.5511 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ejb_A                                        
REMARK     2: T0487_317_466.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ejb_A.T0487_317_466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  168  150   5.0  109   2.83    6.42  42.915
REMARK  ---------------------------------------------------------- 
MOLECULE 1ejb_A
HEADER    TRANSFERASE                             02-MAR-00   1EJB              
TITLE     LUMAZINE SYNTHASE FROM SACCHAROMYCES CEREVISIAE                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LUMAZINE SYNTHASE;                                         
COMPND   3 CHAIN: A, B, C, D, E;                                                
COMPND   4 EC: 2.5.1.9;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PNCO113                                   
KEYWDS    LUMAZINE SYNTHASE, SACCHAROMYCES CEREVISIAE, X-RAY                    
KEYWDS   2 STRUCTURE ANALYSIS, INHIBITOR COMPLEX, VITAMIN BIOSYNTHESIS          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    W.MEINING,S.MORTL,M.FISCHER,M.CUSHMAN,A.BACHER,R.LADENSTEIN           
REVDAT   1   02-MAR-01 1EJB    0                                                
JRNL        AUTH   W.MEINING,S.MORTL,M.FISCHER,M.CUSHMAN,A.BACHER,              
JRNL        AUTH 2 R.LADENSTEIN                                                 
JRNL        TITL   THE ATOMIC STRUCTURE OF PENTAMERIC LUMAZINE                  
JRNL        TITL 2 SYNTHASE FROM SACCHAROMYCES CEREVISIAE AT 1.85 A             
JRNL        TITL 3 RESOLUTION REVEALS THE BINDING MODE OF A                     
JRNL        TITL 4 PHOSPHONATE INTERMEDIATE ANALOGUE.                           
JRNL        REF    J.MOL.BIOL.                   V. 299   181 2000              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  1EJB A    1   168  UNP    P50861   RIB4_YEAST       2    169             
DBREF  1EJB B    1   168  UNP    P50861   RIB4_YEAST       2    169             
DBREF  1EJB C    1   168  UNP    P50861   RIB4_YEAST       2    169             
DBREF  1EJB D    1   168  UNP    P50861   RIB4_YEAST       2    169             
DBREF  1EJB E    1   168  UNP    P50861   RIB4_YEAST       2    169             
SEQRES   1 A  168  ALA VAL LYS GLY LEU GLY LYS PRO ASP GLN VAL TYR ASP          
SEQRES   2 A  168  GLY SER LYS ILE ARG VAL GLY ILE ILE HIS ALA ARG TRP          
SEQRES   3 A  168  ASN ARG VAL ILE ILE ASP ALA LEU VAL LYS GLY ALA ILE          
SEQRES   4 A  168  GLU ARG MET ALA SER LEU GLY VAL GLU GLU ASN ASN ILE          
SEQRES   5 A  168  ILE ILE GLU THR VAL PRO GLY SER TYR GLU LEU PRO TRP          
SEQRES   6 A  168  GLY THR LYS ARG PHE VAL ASP ARG GLN ALA LYS LEU GLY          
SEQRES   7 A  168  LYS PRO LEU ASP VAL VAL ILE PRO ILE GLY VAL LEU ILE          
SEQRES   8 A  168  LYS GLY SER THR MET HIS PHE GLU TYR ILE SER ASP SER          
SEQRES   9 A  168  THR THR HIS ALA LEU MET ASN LEU GLN GLU LYS VAL ASP          
SEQRES  10 A  168  MET PRO VAL ILE PHE GLY LEU LEU THR CYS MET THR GLU          
SEQRES  11 A  168  GLU GLN ALA LEU ALA ARG ALA GLY ILE ASP GLU ALA HIS          
SEQRES  12 A  168  SER MET HIS ASN HIS GLY GLU ASP TRP GLY ALA ALA ALA          
SEQRES  13 A  168  VAL GLU MET ALA VAL LYS PHE GLY LYS ASN ALA PHE              
SEQRES   1 B  168  ALA VAL LYS GLY LEU GLY LYS PRO ASP GLN VAL TYR ASP          
SEQRES   2 B  168  GLY SER LYS ILE ARG VAL GLY ILE ILE HIS ALA ARG TRP          
SEQRES   3 B  168  ASN ARG VAL ILE ILE ASP ALA LEU VAL LYS GLY ALA ILE          
SEQRES   4 B  168  GLU ARG MET ALA SER LEU GLY VAL GLU GLU ASN ASN ILE          
SEQRES   5 B  168  ILE ILE GLU THR VAL PRO GLY SER TYR GLU LEU PRO TRP          
SEQRES   6 B  168  GLY THR LYS ARG PHE VAL ASP ARG GLN ALA LYS LEU GLY          
SEQRES   7 B  168  LYS PRO LEU ASP VAL VAL ILE PRO ILE GLY VAL LEU ILE          
SEQRES   8 B  168  LYS GLY SER THR MET HIS PHE GLU TYR ILE SER ASP SER          
SEQRES   9 B  168  THR THR HIS ALA LEU MET ASN LEU GLN GLU LYS VAL ASP          
SEQRES  10 B  168  MET PRO VAL ILE PHE GLY LEU LEU THR CYS MET THR GLU          
SEQRES  11 B  168  GLU GLN ALA LEU ALA ARG ALA GLY ILE ASP GLU ALA HIS          
SEQRES  12 B  168  SER MET HIS ASN HIS GLY GLU ASP TRP GLY ALA ALA ALA          
SEQRES  13 B  168  VAL GLU MET ALA VAL LYS PHE GLY LYS ASN ALA PHE              
SEQRES   1 C  168  ALA VAL LYS GLY LEU GLY LYS PRO ASP GLN VAL TYR ASP          
SEQRES   2 C  168  GLY SER LYS ILE ARG VAL GLY ILE ILE HIS ALA ARG TRP          
SEQRES   3 C  168  ASN ARG VAL ILE ILE ASP ALA LEU VAL LYS GLY ALA ILE          
SEQRES   4 C  168  GLU ARG MET ALA SER LEU GLY VAL GLU GLU ASN ASN ILE          
SEQRES   5 C  168  ILE ILE GLU THR VAL PRO GLY SER TYR GLU LEU PRO TRP          
SEQRES   6 C  168  GLY THR LYS ARG PHE VAL ASP ARG GLN ALA LYS LEU GLY          
SEQRES   7 C  168  LYS PRO LEU ASP VAL VAL ILE PRO ILE GLY VAL LEU ILE          
SEQRES   8 C  168  LYS GLY SER THR MET HIS PHE GLU TYR ILE SER ASP SER          
SEQRES   9 C  168  THR THR HIS ALA LEU MET ASN LEU GLN GLU LYS VAL ASP          
SEQRES  10 C  168  MET PRO VAL ILE PHE GLY LEU LEU THR CYS MET THR GLU          
SEQRES  11 C  168  GLU GLN ALA LEU ALA ARG ALA GLY ILE ASP GLU ALA HIS          
SEQRES  12 C  168  SER MET HIS ASN HIS GLY GLU ASP TRP GLY ALA ALA ALA          
SEQRES  13 C  168  VAL GLU MET ALA VAL LYS PHE GLY LYS ASN ALA PHE              
SEQRES   1 D  168  ALA VAL LYS GLY LEU GLY LYS PRO ASP GLN VAL TYR ASP          
SEQRES   2 D  168  GLY SER LYS ILE ARG VAL GLY ILE ILE HIS ALA ARG TRP          
SEQRES   3 D  168  ASN ARG VAL ILE ILE ASP ALA LEU VAL LYS GLY ALA ILE          
SEQRES   4 D  168  GLU ARG MET ALA SER LEU GLY VAL GLU GLU ASN ASN ILE          
SEQRES   5 D  168  ILE ILE GLU THR VAL PRO GLY SER TYR GLU LEU PRO TRP          
SEQRES   6 D  168  GLY THR LYS ARG PHE VAL ASP ARG GLN ALA LYS LEU GLY          
SEQRES   7 D  168  LYS PRO LEU ASP VAL VAL ILE PRO ILE GLY VAL LEU ILE          
SEQRES   8 D  168  LYS GLY SER THR MET HIS PHE GLU TYR ILE SER ASP SER          
SEQRES   9 D  168  THR THR HIS ALA LEU MET ASN LEU GLN GLU LYS VAL ASP          
SEQRES  10 D  168  MET PRO VAL ILE PHE GLY LEU LEU THR CYS MET THR GLU          
SEQRES  11 D  168  GLU GLN ALA LEU ALA ARG ALA GLY ILE ASP GLU ALA HIS          
SEQRES  12 D  168  SER MET HIS ASN HIS GLY GLU ASP TRP GLY ALA ALA ALA          
SEQRES  13 D  168  VAL GLU MET ALA VAL LYS PHE GLY LYS ASN ALA PHE              
SEQRES   1 E  168  ALA VAL LYS GLY LEU GLY LYS PRO ASP GLN VAL TYR ASP          
SEQRES   2 E  168  GLY SER LYS ILE ARG VAL GLY ILE ILE HIS ALA ARG TRP          
SEQRES   3 E  168  ASN ARG VAL ILE ILE ASP ALA LEU VAL LYS GLY ALA ILE          
SEQRES   4 E  168  GLU ARG MET ALA SER LEU GLY VAL GLU GLU ASN ASN ILE          
SEQRES   5 E  168  ILE ILE GLU THR VAL PRO GLY SER TYR GLU LEU PRO TRP          
SEQRES   6 E  168  GLY THR LYS ARG PHE VAL ASP ARG GLN ALA LYS LEU GLY          
SEQRES   7 E  168  LYS PRO LEU ASP VAL VAL ILE PRO ILE GLY VAL LEU ILE          
SEQRES   8 E  168  LYS GLY SER THR MET HIS PHE GLU TYR ILE SER ASP SER          
SEQRES   9 E  168  THR THR HIS ALA LEU MET ASN LEU GLN GLU LYS VAL ASP          
SEQRES  10 E  168  MET PRO VAL ILE PHE GLY LEU LEU THR CYS MET THR GLU          
SEQRES  11 E  168  GLU GLN ALA LEU ALA ARG ALA GLY ILE ASP GLU ALA HIS          
SEQRES  12 E  168  SER MET HIS ASN HIS GLY GLU ASP TRP GLY ALA ALA ALA          
SEQRES  13 E  168  VAL GLU MET ALA VAL LYS PHE GLY LYS ASN ALA PHE              
HET    INJ    200      27                                                       
HET    INJ    300      27                                                       
HET    INJ    400      27                                                       
HET    INJ    600      27                                                       
HET    INJ    800      27                                                       
HETNAM     INJ 5-(6-D-RIBITYLAMINO-2,4-DIHYDROXYPYRIMIDIN-5-YL)-1-              
HETNAM   2 INJ  PENTYL-PHOSPHONIC ACID                                          
FORMUL   6  INJ    5(C14 H26 N3 O9 P)                                           
FORMUL  11  HOH   *550(H2 O)                                                    
CRYST1   82.893   82.893  298.842  90.00  90.00  90.00 P 41 21 2    40          
ATOM      1  N   ALA A   1      -4.897  30.587  33.832  1.00 55.47           N  
ATOM      2  CA  ALA A   1      -5.318  29.328  34.294  0.00 43.51           C  
ATOM      3  C   ALA A   1      -5.036  29.806  35.702  0.00 44.05           C  
ATOM      4  O   ALA A   1      -3.871  29.993  36.088  0.00 45.51           O  
ATOM      5  CB  ALA A   1      -4.624  28.176  34.316  1.00 54.20           C  
ATOM      6  N   VAL A   2      -6.030  29.835  36.307  1.00 33.74           N  
ATOM      7  CA  VAL A   2      -6.186  30.418  37.643  1.00 33.61           C  
ATOM      8  C   VAL A   2      -6.384  29.294  38.642  1.00 33.40           C  
ATOM      9  O   VAL A   2      -7.365  28.541  38.510  1.00 33.73           O  
ATOM     10  CB  VAL A   2      -7.342  31.437  37.645  1.00 34.19           C  
ATOM     11  CG1 VAL A   2      -7.473  32.186  39.138  0.00 36.54           C  
ATOM     12  CG2 VAL A   2      -7.325  32.540  36.728  0.00 38.24           C  
ATOM     13  N   LYS A   3      -5.536  29.163  39.662  1.00 32.56           N  
ATOM     14  CA  LYS A   3      -5.696  28.081  40.633  1.00 32.49           C  
ATOM     15  C   LYS A   3      -5.257  28.456  42.045  1.00 31.39           C  
ATOM     16  O   LYS A   3      -4.647  29.506  42.259  1.00 30.72           O  
ATOM     17  CB  LYS A   3      -4.923  26.840  40.168  1.00 34.06           C  
ATOM     18  CG  LYS A   3      -3.412  26.931  40.267  1.00 37.17           C  
ATOM     19  CD  LYS A   3      -2.738  25.824  39.462  1.00 38.56           C  
ATOM     20  CE  LYS A   3      -1.220  25.891  39.572  1.00 39.02           C  
ATOM     21  NZ  LYS A   3      -0.686  24.979  40.628  1.00 39.98           N  
ATOM     22  N   GLY A   4      -5.567  27.564  42.997  1.00 29.71           N  
ATOM     23  CA  GLY A   4      -5.176  27.816  44.387  1.00 30.28           C  
ATOM     24  C   GLY A   4      -3.664  27.938  44.525  1.00 31.28           C  
ATOM     25  O   GLY A   4      -2.929  27.149  43.926  1.00 30.37           O  
ATOM     26  N   LEU A   5      -3.168  28.847  45.366  1.00 29.75           N  
ATOM     27  CA  LEU A   5      -1.723  28.996  45.535  1.00 30.22           C  
ATOM     28  C   LEU A   5      -1.159  28.088  46.619  1.00 30.20           C  
ATOM     29  O   LEU A   5       0.045  28.130  46.872  1.00 30.35           O  
ATOM     30  CB  LEU A   5      -1.299  30.457  45.779  1.00 30.59           C  
ATOM     31  CG  LEU A   5      -1.736  31.448  44.866  0.00 36.87           C  
ATOM     32  CD1 LEU A   5      -3.052  32.190  45.114  0.00 38.16           C  
ATOM     33  CD2 LEU A   5      -0.667  32.537  44.730  0.00 38.09           C  
ATOM     34  N   GLY A   6      -1.963  27.219  47.220  1.00 29.00           N  
ATOM     35  CA  GLY A   6      -1.561  26.292  48.252  1.00 27.78           C  
ATOM     36  C   GLY A   6      -0.496  25.271  47.875  1.00 28.68           C  
ATOM     37  O   GLY A   6      -0.385  24.791  46.741  1.00 27.61           O  
ATOM     38  N   LYS A   7       0.356  24.930  48.834  1.00 27.65           N  
ATOM     39  CA  LYS A   7       1.419  23.923  48.663  1.00 28.08           C  
ATOM     40  C   LYS A   7       1.442  23.134  49.952  1.00 26.61           C  
ATOM     41  O   LYS A   7       1.259  23.749  51.018  1.00 26.79           O  
ATOM     42  CB  LYS A   7       2.775  24.562  48.368  1.00 29.05           C  
ATOM     43  CG  LYS A   7       2.880  25.201  46.996  1.00 31.89           C  
ATOM     44  CD  LYS A   7       4.261  25.791  46.743  1.00 34.33           C  
ATOM     45  CE  LYS A   7       4.735  26.140  45.498  0.00 40.69           C  
ATOM     46  NZ  LYS A   7       6.192  26.563  45.429  1.00 41.01           N  
ATOM     47  N   PRO A   8       1.620  21.822  49.915  1.00 25.25           N  
ATOM     48  CA  PRO A   8       1.525  20.986  51.089  1.00 24.61           C  
ATOM     49  C   PRO A   8       2.518  21.242  52.198  1.00 24.31           C  
ATOM     50  O   PRO A   8       2.198  20.847  53.322  1.00 27.42           O  
ATOM     51  CB  PRO A   8       1.700  19.549  50.581  1.00 23.62           C  
ATOM     52  CG  PRO A   8       2.325  19.707  49.254  1.00 24.14           C  
ATOM     53  CD  PRO A   8       1.852  21.023  48.688  1.00 25.07           C  
ATOM     54  N   ASP A   9       3.682  21.815  51.911  1.00 23.04           N  
ATOM     55  CA  ASP A   9       4.617  22.064  53.025  1.00 23.92           C  
ATOM     56  C   ASP A   9       4.582  23.541  53.399  1.00 23.98           C  
ATOM     57  O   ASP A   9       5.420  24.052  54.155  1.00 23.60           O  
ATOM     58  CB  ASP A   9       6.001  21.565  52.607  1.00 25.74           C  
ATOM     59  CG  ASP A   9       6.590  22.325  51.438  1.00 27.21           C  
ATOM     60  OD1 ASP A   9       7.845  22.423  51.357  1.00 26.99           O  
ATOM     61  OD2 ASP A   9       5.870  22.846  50.563  1.00 27.05           O  
ATOM     62  N   GLN A  10       3.603  24.282  52.860  1.00 21.83           N  
ATOM     63  CA  GLN A  10       3.513  25.714  53.125  1.00 23.45           C  
ATOM     64  C   GLN A  10       2.237  26.078  53.886  1.00 22.98           C  
ATOM     65  O   GLN A  10       1.903  27.253  53.973  1.00 22.64           O  
ATOM     66  CB  GLN A  10       3.576  26.505  51.826  1.00 23.66           C  
ATOM     67  CG  GLN A  10       4.902  26.344  51.087  1.00 25.18           C  
ATOM     68  CD  GLN A  10       4.991  27.201  49.862  1.00 26.98           C  
ATOM     69  OE1 GLN A  10       4.028  27.726  49.330  1.00 28.39           O  
ATOM     70  NE2 GLN A  10       6.216  27.361  49.333  1.00 29.06           N  
ATOM     71  N   VAL A  11       1.587  25.068  54.447  1.00 23.74           N  
ATOM     72  CA  VAL A  11       0.331  25.301  55.163  1.00 24.40           C  
ATOM     73  C   VAL A  11       0.530  25.877  56.546  1.00 26.28           C  
ATOM     74  O   VAL A  11       0.779  25.184  57.531  1.00 24.80           O  
ATOM     75  CB  VAL A  11      -0.527  24.023  55.242  1.00 24.97           C  
ATOM     76  CG1 VAL A  11      -1.838  24.340  55.948  1.00 25.34           C  
ATOM     77  CG2 VAL A  11      -0.795  23.544  53.826  1.00 24.89           C  
ATOM     78  N   TYR A  12       0.551  27.199  56.636  1.00 27.97           N  
ATOM     79  CA  TYR A  12       0.712  27.946  57.855  1.00 28.48           C  
ATOM     80  C   TYR A  12      -0.354  29.029  57.925  1.00 27.69           C  
ATOM     81  O   TYR A  12      -0.597  29.681  56.918  1.00 27.78           O  
ATOM     82  CB  TYR A  12       2.105  28.654  57.859  1.00 28.91           C  
ATOM     83  CG  TYR A  12       3.131  27.544  58.046  1.00 30.50           C  
ATOM     84  CD1 TYR A  12       3.780  26.962  56.970  1.00 30.45           C  
ATOM     85  CD2 TYR A  12       3.365  27.040  59.318  1.00 30.80           C  
ATOM     86  CE1 TYR A  12       4.651  25.908  57.152  1.00 31.72           C  
ATOM     87  CE2 TYR A  12       4.253  25.995  59.517  1.00 32.21           C  
ATOM     88  CZ  TYR A  12       4.892  25.434  58.427  1.00 32.66           C  
ATOM     89  OH  TYR A  12       5.781  24.390  58.597  1.00 33.53           O  
ATOM     90  N   ASP A  13      -0.951  29.169  59.093  1.00 26.00           N  
ATOM     91  CA  ASP A  13      -1.998  30.187  59.249  1.00 25.44           C  
ATOM     92  C   ASP A  13      -1.357  31.504  59.663  1.00 23.51           C  
ATOM     93  O   ASP A  13      -0.922  31.627  60.817  1.00 23.13           O  
ATOM     94  CB  ASP A  13      -2.972  29.657  60.295  1.00 27.31           C  
ATOM     95  CG  ASP A  13      -3.986  30.689  60.767  1.00 29.51           C  
ATOM     96  OD1 ASP A  13      -4.683  30.313  61.728  1.00 31.47           O  
ATOM     97  OD2 ASP A  13      -4.078  31.774  60.213  1.00 28.72           O  
ATOM     98  N   GLY A  14      -1.319  32.463  58.774  1.00 21.56           N  
ATOM     99  CA  GLY A  14      -0.735  33.775  58.999  1.00 21.59           C  
ATOM    100  C   GLY A  14      -1.718  34.808  59.513  1.00 21.76           C  
ATOM    101  O   GLY A  14      -1.387  35.991  59.581  1.00 21.02           O  
ATOM    102  N   SER A  15      -2.917  34.379  59.962  1.00 21.11           N  
ATOM    103  CA  SER A  15      -3.900  35.385  60.359  1.00 23.11           C  
ATOM    104  C   SER A  15      -3.453  36.299  61.493  1.00 22.52           C  
ATOM    105  O   SER A  15      -3.899  37.451  61.477  1.00 23.47           O  
ATOM    106  CB  SER A  15      -5.242  34.705  60.677  1.00 23.87           C  
ATOM    107  OG  SER A  15      -5.092  33.871  61.805  1.00 26.39           O  
ATOM    108  N   LYS A  16      -2.624  35.857  62.425  1.00 21.40           N  
ATOM    109  CA  LYS A  16      -2.207  36.704  63.533  1.00 22.58           C  
ATOM    110  C   LYS A  16      -0.894  37.447  63.285  1.00 22.81           C  
ATOM    111  O   LYS A  16      -0.455  38.148  64.211  1.00 22.77           O  
ATOM    112  CB  LYS A  16      -2.074  35.888  64.819  1.00 23.82           C  
ATOM    113  CG  LYS A  16      -3.293  35.031  65.176  1.00 25.58           C  
ATOM    114  CD  LYS A  16      -4.529  35.648  65.559  0.00 32.10           C  
ATOM    115  CE  LYS A  16      -5.729  34.691  65.579  0.00 34.76           C  
ATOM    116  NZ  LYS A  16      -6.068  34.173  64.245  0.00 33.03           N  
ATOM    117  N   ILE A  17      -0.284  37.339  62.099  1.00 20.50           N  
ATOM    118  CA  ILE A  17       1.015  38.032  62.011  1.00 20.37           C  
ATOM    119  C   ILE A  17       0.971  39.311  61.237  1.00 19.61           C  
ATOM    120  O   ILE A  17       0.108  39.547  60.379  1.00 19.64           O  
ATOM    121  CB  ILE A  17       2.090  37.072  61.433  1.00 22.19           C  
ATOM    122  CG1 ILE A  17       1.856  36.824  59.967  1.00 22.12           C  
ATOM    123  CG2 ILE A  17       2.112  35.772  62.244  1.00 21.85           C  
ATOM    124  CD1 ILE A  17       2.949  36.019  59.279  1.00 23.37           C  
ATOM    125  N   ARG A  18       2.001  40.142  61.485  1.00 16.97           N  
ATOM    126  CA  ARG A  18       2.184  41.388  60.775  1.00 16.08           C  
ATOM    127  C   ARG A  18       3.511  41.285  60.015  1.00 16.48           C  
ATOM    128  O   ARG A  18       4.522  40.935  60.644  1.00 16.41           O  
ATOM    129  CB  ARG A  18       2.217  42.566  61.774  1.00 15.77           C  
ATOM    130  CG  ARG A  18       2.375  43.887  61.023  1.00 16.66           C  
ATOM    131  CD  ARG A  18       2.312  45.109  61.942  1.00 18.38           C  
ATOM    132  NE  ARG A  18       1.017  45.162  62.635  1.00 19.27           N  
ATOM    133  CZ  ARG A  18       0.742  44.820  63.876  1.00 20.68           C  
ATOM    134  NH1 ARG A  18       1.626  44.409  64.770  1.00 19.46           N  
ATOM    135  NH2 ARG A  18      -0.534  44.919  64.306  1.00 22.23           N  
ATOM    136  N   VAL A  19       3.471  41.507  58.719  1.00 15.49           N  
ATOM    137  CA  VAL A  19       4.696  41.329  57.900  1.00 15.49           C  
ATOM    138  C   VAL A  19       5.080  42.650  57.274  1.00 15.20           C  
ATOM    139  O   VAL A  19       4.235  43.382  56.732  1.00 16.60           O  
ATOM    140  CB  VAL A  19       4.401  40.338  56.742  1.00 16.03           C  
ATOM    141  CG1 VAL A  19       5.649  40.111  55.890  1.00 15.23           C  
ATOM    142  CG2 VAL A  19       3.925  39.011  57.327  1.00 14.99           C  
ATOM    143  N   GLY A  20       6.368  42.984  57.334  1.00 13.84           N  
ATOM    144  CA  GLY A  20       6.858  44.160  56.642  1.00 13.23           C  
ATOM    145  C   GLY A  20       7.519  43.708  55.328  1.00 14.62           C  
ATOM    146  O   GLY A  20       8.145  42.641  55.214  1.00 15.81           O  
ATOM    147  N   ILE A  21       7.318  44.490  54.277  1.00 14.18           N  
ATOM    148  CA  ILE A  21       7.980  44.307  53.004  1.00 14.58           C  
ATOM    149  C   ILE A  21       8.731  45.614  52.785  1.00 14.89           C  
ATOM    150  O   ILE A  21       8.102  46.689  52.799  1.00 16.38           O  
ATOM    151  CB  ILE A  21       7.075  43.993  51.809  1.00 14.75           C  
ATOM    152  CG1 ILE A  21       6.370  42.639  51.985  1.00 15.76           C  
ATOM    153  CG2 ILE A  21       7.885  43.999  50.517  1.00 15.42           C  
ATOM    154  CD1 ILE A  21       5.235  42.486  50.938  1.00 17.32           C  
ATOM    155  N   ILE A  22      10.050  45.567  52.618  1.00 13.87           N  
ATOM    156  CA  ILE A  22      10.764  46.841  52.422  1.00 14.05           C  
ATOM    157  C   ILE A  22      11.554  46.676  51.140  1.00 15.31           C  
ATOM    158  O   ILE A  22      12.262  45.655  51.041  1.00 15.54           O  
ATOM    159  CB  ILE A  22      11.600  47.229  53.652  1.00 14.24           C  
ATOM    160  CG1 ILE A  22      12.393  48.504  53.316  1.00 13.79           C  
ATOM    161  CG2 ILE A  22      12.518  46.084  54.081  1.00 14.60           C  
ATOM    162  CD1 ILE A  22      13.051  49.137  54.533  1.00 13.83           C  
ATOM    163  N   HIS A  23      11.268  47.481  50.110  1.00 15.61           N  
ATOM    164  CA  HIS A  23      11.944  47.180  48.831  1.00 15.24           C  
ATOM    165  C   HIS A  23      12.726  48.345  48.281  1.00 14.93           C  
ATOM    166  O   HIS A  23      12.397  49.525  48.468  1.00 15.97           O  
ATOM    167  CB  HIS A  23      10.872  46.737  47.819  1.00 16.59           C  
ATOM    168  CG  HIS A  23       9.853  47.761  47.401  1.00 17.26           C  
ATOM    169  ND1 HIS A  23      10.090  48.758  46.469  1.00 18.53           N  
ATOM    170  CD2 HIS A  23       8.559  47.892  47.769  1.00 18.54           C  
ATOM    171  CE1 HIS A  23       8.999  49.451  46.265  1.00 19.18           C  
ATOM    172  NE2 HIS A  23       8.050  48.957  47.040  1.00 19.91           N  
ATOM    173  N   ALA A  24      13.792  48.013  47.553  1.00 14.82           N  
ATOM    174  CA  ALA A  24      14.621  48.971  46.847  1.00 15.87           C  
ATOM    175  C   ALA A  24      13.826  49.434  45.626  1.00 17.11           C  
ATOM    176  O   ALA A  24      12.765  48.867  45.358  1.00 17.48           O  
ATOM    177  CB  ALA A  24      15.945  48.369  46.415  1.00 16.28           C  
ATOM    178  N   ARG A  25      14.265  50.472  44.933  1.00 18.54           N  
ATOM    179  CA  ARG A  25      13.499  50.992  43.800  1.00 20.43           C  
ATOM    180  C   ARG A  25      14.273  50.912  42.492  1.00 22.83           C  
ATOM    181  O   ARG A  25      13.823  51.319  41.420  1.00 25.36           O  
ATOM    182  CB  ARG A  25      13.055  52.442  44.106  1.00 20.58           C  
ATOM    183  CG  ARG A  25      12.051  52.509  45.268  1.00 21.28           C  
ATOM    184  CD  ARG A  25      11.330  53.871  45.409  1.00 21.93           C  
ATOM    185  NE  ARG A  25      12.324  54.952  45.452  1.00 22.11           N  
ATOM    186  CZ  ARG A  25      12.931  55.401  46.552  1.00 21.35           C  
ATOM    187  NH1 ARG A  25      12.625  54.924  47.748  1.00 20.85           N  
ATOM    188  NH2 ARG A  25      13.851  56.344  46.400  1.00 19.87           N  
ATOM    189  N   TRP A  26      15.460  50.349  42.553  1.00 24.46           N  
ATOM    190  CA  TRP A  26      16.283  50.080  41.372  1.00 27.03           C  
ATOM    191  C   TRP A  26      15.640  48.916  40.634  1.00 26.74           C  
ATOM    192  O   TRP A  26      15.248  47.960  41.322  1.00 25.63           O  
ATOM    193  CB  TRP A  26      17.650  49.687  41.940  1.00 30.25           C  
ATOM    194  CG  TRP A  26      18.675  50.774  41.850  1.00 33.08           C  
ATOM    195  CD1 TRP A  26      18.959  51.785  42.717  1.00 33.95           C  
ATOM    196  CD2 TRP A  26      19.599  50.898  40.758  1.00 34.38           C  
ATOM    197  NE1 TRP A  26      20.012  52.541  42.229  1.00 35.05           N  
ATOM    198  CE2 TRP A  26      20.416  52.008  41.030  1.00 35.21           C  
ATOM    199  CE3 TRP A  26      19.803  50.157  39.579  1.00 34.98           C  
ATOM    200  CZ2 TRP A  26      21.422  52.411  40.151  1.00 36.36           C  
ATOM    201  CZ3 TRP A  26      20.796  50.570  38.714  1.00 35.83           C  
ATOM    202  CH2 TRP A  26      21.586  51.689  39.000  1.00 35.65           C  
ATOM    203  N   ASN A  27      15.462  48.956  39.317  1.00 24.43           N  
ATOM    204  CA  ASN A  27      14.823  47.862  38.572  1.00 23.97           C  
ATOM    205  C   ASN A  27      13.394  47.685  39.044  1.00 23.83           C  
ATOM    206  O   ASN A  27      12.919  46.590  39.328  1.00 23.90           O  
ATOM    207  CB  ASN A  27      15.628  46.562  38.760  1.00 24.66           C  
ATOM    208  CG  ASN A  27      17.047  46.686  38.271  1.00 25.57           C  
ATOM    209  OD1 ASN A  27      17.342  47.069  37.130  1.00 25.74           O  
ATOM    210  ND2 ASN A  27      18.010  46.394  39.142  1.00 24.09           N  
ATOM    211  N   ARG A  28      12.661  48.795  39.119  1.00 23.55           N  
ATOM    212  CA  ARG A  28      11.310  48.857  39.661  1.00 23.83           C  
ATOM    213  C   ARG A  28      10.256  47.997  39.055  1.00 23.52           C  
ATOM    214  O   ARG A  28       9.439  47.416  39.823  1.00 22.63           O  
ATOM    215  CB  ARG A  28      10.932  50.372  39.653  1.00 24.72           C  
ATOM    216  CG  ARG A  28       9.644  50.610  40.440  1.00 26.25           C  
ATOM    217  CD  ARG A  28       9.855  50.451  41.938  1.00 26.96           C  
ATOM    218  NE  ARG A  28       8.599  50.553  42.688  1.00 27.50           N  
ATOM    219  CZ  ARG A  28       8.124  51.661  43.237  1.00 28.88           C  
ATOM    220  NH1 ARG A  28       8.782  52.811  43.150  1.00 28.80           N  
ATOM    221  NH2 ARG A  28       6.971  51.610  43.899  1.00 29.40           N  
ATOM    222  N   VAL A  29      10.214  47.742  37.743  1.00 23.13           N  
ATOM    223  CA  VAL A  29       9.186  46.830  37.210  1.00 22.83           C  
ATOM    224  C   VAL A  29       9.346  45.436  37.790  1.00 20.59           C  
ATOM    225  O   VAL A  29       8.352  44.781  38.130  1.00 21.44           O  
ATOM    226  CB  VAL A  29       9.187  46.789  35.671  1.00 24.68           C  
ATOM    227  CG1 VAL A  29       8.336  45.673  35.089  1.00 25.03           C  
ATOM    228  CG2 VAL A  29       8.632  48.110  35.152  1.00 26.22           C  
ATOM    229  N   ILE A  30      10.586  44.961  37.936  1.00 20.40           N  
ATOM    230  CA  ILE A  30      10.816  43.641  38.525  1.00 19.17           C  
ATOM    231  C   ILE A  30      10.470  43.667  40.016  1.00 19.10           C  
ATOM    232  O   ILE A  30       9.774  42.763  40.478  1.00 17.90           O  
ATOM    233  CB  ILE A  30      12.262  43.196  38.296  1.00 20.37           C  
ATOM    234  CG1 ILE A  30      12.497  43.146  36.772  1.00 21.62           C  
ATOM    235  CG2 ILE A  30      12.558  41.856  38.952  1.00 19.97           C  
ATOM    236  CD1 ILE A  30      13.961  43.189  36.404  1.00 21.85           C  
ATOM    237  N   ILE A  31      10.946  44.686  40.719  1.00 18.36           N  
ATOM    238  CA  ILE A  31      10.617  44.846  42.147  1.00 18.55           C  
ATOM    239  C   ILE A  31       9.115  44.747  42.375  1.00 19.06           C  
ATOM    240  O   ILE A  31       8.634  43.951  43.194  1.00 18.28           O  
ATOM    241  CB  ILE A  31      11.119  46.227  42.655  1.00 18.40           C  
ATOM    242  CG1 ILE A  31      12.645  46.311  42.709  1.00 19.40           C  
ATOM    243  CG2 ILE A  31      10.467  46.526  44.007  1.00 19.52           C  
ATOM    244  CD1 ILE A  31      13.288  45.574  43.882  1.00 19.92           C  
ATOM    245  N   ASP A  32       8.339  45.575  41.661  1.00 19.85           N  
ATOM    246  CA  ASP A  32       6.885  45.541  41.814  1.00 20.95           C  
ATOM    247  C   ASP A  32       6.250  44.190  41.631  1.00 20.53           C  
ATOM    248  O   ASP A  32       5.301  43.845  42.360  1.00 19.29           O  
ATOM    249  CB  ASP A  32       6.193  46.551  40.883  1.00 22.95           C  
ATOM    250  CG  ASP A  32       6.454  47.975  41.340  1.00 25.60           C  
ATOM    251  OD1 ASP A  32       6.966  48.221  42.442  1.00 24.90           O  
ATOM    252  OD2 ASP A  32       6.182  48.906  40.545  1.00 26.91           O  
ATOM    253  N   ALA A  33       6.691  43.389  40.666  1.00 20.59           N  
ATOM    254  CA  ALA A  33       6.172  42.066  40.425  1.00 19.99           C  
ATOM    255  C   ALA A  33       6.517  41.140  41.597  1.00 18.91           C  
ATOM    256  O   ALA A  33       5.665  40.366  42.028  1.00 18.60           O  
ATOM    257  CB  ALA A  33       6.680  41.446  39.131  1.00 19.84           C  
ATOM    258  N   LEU A  34       7.750  41.263  42.104  1.00 18.04           N  
ATOM    259  CA  LEU A  34       8.113  40.415  43.260  1.00 17.20           C  
ATOM    260  C   LEU A  34       7.268  40.755  44.478  1.00 17.01           C  
ATOM    261  O   LEU A  34       6.720  39.860  45.136  1.00 17.71           O  
ATOM    262  CB  LEU A  34       9.586  40.679  43.599  1.00 16.49           C  
ATOM    263  CG  LEU A  34      10.571  40.155  42.535  1.00 16.77           C  
ATOM    264  CD1 LEU A  34      11.986  40.669  42.791  1.00 16.41           C  
ATOM    265  CD2 LEU A  34      10.603  38.627  42.581  1.00 16.93           C  
ATOM    266  N   VAL A  35       7.111  42.037  44.777  1.00 16.79           N  
ATOM    267  CA  VAL A  35       6.302  42.499  45.905  1.00 17.05           C  
ATOM    268  C   VAL A  35       4.887  42.007  45.786  1.00 17.94           C  
ATOM    269  O   VAL A  35       4.252  41.465  46.701  1.00 17.13           O  
ATOM    270  CB  VAL A  35       6.348  44.038  45.981  1.00 17.47           C  
ATOM    271  CG1 VAL A  35       5.286  44.573  46.953  1.00 17.41           C  
ATOM    272  CG2 VAL A  35       7.746  44.508  46.371  1.00 16.93           C  
ATOM    273  N   LYS A  36       4.338  42.166  44.559  1.00 18.46           N  
ATOM    274  CA  LYS A  36       2.960  41.721  44.362  1.00 21.10           C  
ATOM    275  C   LYS A  36       2.748  40.256  44.665  1.00 20.41           C  
ATOM    276  O   LYS A  36       1.754  39.850  45.268  1.00 20.58           O  
ATOM    277  CB  LYS A  36       2.525  41.998  42.902  1.00 23.41           C  
ATOM    278  CG  LYS A  36       1.738  43.308  42.874  1.00 26.54           C  
ATOM    279  CD  LYS A  36       2.328  44.221  41.704  0.00 35.83           C  
ATOM    280  CE  LYS A  36       1.288  45.150  41.076  0.00 37.76           C  
ATOM    281  NZ  LYS A  36       1.760  45.792  39.842  0.00 39.55           N  
ATOM    282  N   GLY A  37       3.704  39.447  44.199  1.00 18.47           N  
ATOM    283  CA  GLY A  37       3.638  37.999  44.413  1.00 18.75           C  
ATOM    284  C   GLY A  37       3.731  37.681  45.895  1.00 18.10           C  
ATOM    285  O   GLY A  37       3.011  36.809  46.376  1.00 18.36           O  
ATOM    286  N   ALA A  38       4.615  38.350  46.637  1.00 18.55           N  
ATOM    287  CA  ALA A  38       4.707  38.074  48.074  1.00 18.15           C  
ATOM    288  C   ALA A  38       3.393  38.430  48.764  1.00 17.57           C  
ATOM    289  O   ALA A  38       2.940  37.682  49.618  1.00 17.29           O  
ATOM    290  CB  ALA A  38       5.854  38.886  48.659  1.00 18.24           C  
ATOM    291  N   ILE A  39       2.838  39.589  48.415  1.00 17.92           N  
ATOM    292  CA  ILE A  39       1.563  39.983  49.036  1.00 19.67           C  
ATOM    293  C   ILE A  39       0.475  38.970  48.740  1.00 19.66           C  
ATOM    294  O   ILE A  39      -0.263  38.569  49.629  1.00 19.46           O  
ATOM    295  CB  ILE A  39       1.127  41.377  48.558  1.00 20.62           C  
ATOM    296  CG1 ILE A  39       2.083  42.439  49.125  1.00 20.44           C  
ATOM    297  CG2 ILE A  39      -0.319  41.644  48.986  1.00 21.22           C  
ATOM    298  CD1 ILE A  39       1.980  43.779  48.417  1.00 21.12           C  
ATOM    299  N   GLU A  40       0.377  38.583  47.469  1.00 20.75           N  
ATOM    300  CA  GLU A  40      -0.649  37.618  47.076  1.00 21.40           C  
ATOM    301  C   GLU A  40      -0.527  36.326  47.858  1.00 20.66           C  
ATOM    302  O   GLU A  40      -1.502  35.767  48.343  1.00 19.16           O  
ATOM    303  CB  GLU A  40      -0.565  37.290  45.571  1.00 22.56           C  
ATOM    304  CG  GLU A  40      -1.003  38.471  44.702  0.50 24.28           C  
ATOM    305  CD  GLU A  40      -0.825  38.671  43.295  0.00 37.88           C  
ATOM    306  OE1 GLU A  40      -0.184  37.724  42.714  0.00 40.46           O  
ATOM    307  OE2 GLU A  40      -1.220  39.590  42.589  0.50 28.55           O  
ATOM    308  N   ARG A  41       0.713  35.798  47.934  1.00 19.69           N  
ATOM    309  CA  ARG A  41       0.837  34.531  48.665  1.00 18.43           C  
ATOM    310  C   ARG A  41       0.534  34.682  50.134  1.00 17.74           C  
ATOM    311  O   ARG A  41      -0.090  33.803  50.721  1.00 19.48           O  
ATOM    312  CB  ARG A  41       2.248  33.992  48.408  1.00 17.92           C  
ATOM    313  CG  ARG A  41       2.535  32.590  48.879  1.00 18.99           C  
ATOM    314  CD  ARG A  41       1.665  31.471  48.280  1.00 21.34           C  
ATOM    315  NE  ARG A  41       1.852  30.174  48.892  1.00 22.46           N  
ATOM    316  CZ  ARG A  41       1.020  29.369  49.537  1.00 23.56           C  
ATOM    317  NH1 ARG A  41      -0.277  29.563  49.730  1.00 25.50           N  
ATOM    318  NH2 ARG A  41       1.535  28.243  50.019  1.00 23.21           N  
ATOM    319  N   MET A  42       0.984  35.756  50.783  1.00 18.20           N  
ATOM    320  CA  MET A  42       0.681  35.919  52.204  1.00 18.44           C  
ATOM    321  C   MET A  42      -0.828  36.089  52.430  1.00 19.16           C  
ATOM    322  O   MET A  42      -1.331  35.516  53.390  1.00 17.68           O  
ATOM    323  CB  MET A  42       1.428  37.122  52.795  1.00 19.18           C  
ATOM    324  CG  MET A  42       2.930  36.878  52.724  1.00 19.30           C  
ATOM    325  SD  MET A  42       3.871  38.064  53.684  1.00 19.38           S  
ATOM    326  CE  MET A  42       3.718  39.552  52.719  1.00 17.91           C  
ATOM    327  N   ALA A  43      -1.528  36.783  51.530  1.00 21.55           N  
ATOM    328  CA  ALA A  43      -2.985  36.918  51.642  1.00 23.79           C  
ATOM    329  C   ALA A  43      -3.666  35.560  51.552  1.00 24.12           C  
ATOM    330  O   ALA A  43      -4.524  35.153  52.355  1.00 24.85           O  
ATOM    331  CB  ALA A  43      -3.508  37.843  50.538  1.00 23.79           C  
ATOM    332  N   SER A  44      -3.173  34.700  50.656  1.00 23.06           N  
ATOM    333  CA  SER A  44      -3.674  33.344  50.517  1.00 24.15           C  
ATOM    334  C   SER A  44      -3.401  32.498  51.756  1.00 24.61           C  
ATOM    335  O   SER A  44      -4.080  31.491  51.956  1.00 23.48           O  
ATOM    336  CB  SER A  44      -3.124  32.655  49.266  1.00 24.73           C  
ATOM    337  OG  SER A  44      -1.800  32.170  49.482  1.00 26.61           O  
ATOM    338  N   LEU A  45      -2.431  32.878  52.595  1.00 21.83           N  
ATOM    339  CA  LEU A  45      -2.179  32.157  53.833  1.00 21.85           C  
ATOM    340  C   LEU A  45      -2.863  32.819  55.030  1.00 21.07           C  
ATOM    341  O   LEU A  45      -2.589  32.450  56.175  1.00 22.04           O  
ATOM    342  CB  LEU A  45      -0.660  32.054  54.081  1.00 21.29           C  
ATOM    343  CG  LEU A  45       0.054  31.220  52.980  1.00 22.24           C  
ATOM    344  CD1 LEU A  45       1.559  31.491  53.036  1.00 22.38           C  
ATOM    345  CD2 LEU A  45      -0.271  29.748  53.166  1.00 22.32           C  
ATOM    346  N   GLY A  46      -3.728  33.813  54.792  1.00 21.51           N  
ATOM    347  CA  GLY A  46      -4.470  34.404  55.905  1.00 21.42           C  
ATOM    348  C   GLY A  46      -3.944  35.724  56.420  1.00 21.14           C  
ATOM    349  O   GLY A  46      -4.560  36.327  57.312  1.00 20.70           O  
ATOM    350  N   VAL A  47      -2.786  36.206  55.951  1.00 20.56           N  
ATOM    351  CA  VAL A  47      -2.309  37.494  56.472  1.00 20.07           C  
ATOM    352  C   VAL A  47      -3.271  38.599  56.031  1.00 21.20           C  
ATOM    353  O   VAL A  47      -3.559  38.733  54.848  1.00 22.17           O  
ATOM    354  CB  VAL A  47      -0.886  37.821  56.015  1.00 19.65           C  
ATOM    355  CG1 VAL A  47      -0.380  39.125  56.633  1.00 18.54           C  
ATOM    356  CG2 VAL A  47       0.040  36.664  56.434  1.00 17.83           C  
ATOM    357  N   GLU A  48      -3.692  39.402  56.978  1.00 23.26           N  
ATOM    358  CA  GLU A  48      -4.649  40.477  56.674  1.00 25.61           C  
ATOM    359  C   GLU A  48      -3.979  41.629  55.976  1.00 24.73           C  
ATOM    360  O   GLU A  48      -2.850  42.012  56.251  1.00 21.39           O  
ATOM    361  CB  GLU A  48      -5.323  40.902  57.983  1.00 27.36           C  
ATOM    362  CG  GLU A  48      -6.078  39.755  58.625  1.00 32.66           C  
ATOM    363  CD  GLU A  48      -7.441  39.466  58.015  1.00 36.75           C  
ATOM    364  OE1 GLU A  48      -7.891  40.206  57.103  1.00 38.34           O  
ATOM    365  OE2 GLU A  48      -8.091  38.469  58.445  1.00 38.77           O  
ATOM    366  N   GLU A  49      -4.726  42.232  55.040  1.00 24.96           N  
ATOM    367  CA  GLU A  49      -4.249  43.364  54.285  1.00 24.79           C  
ATOM    368  C   GLU A  49      -3.771  44.492  55.187  1.00 24.86           C  
ATOM    369  O   GLU A  49      -2.721  45.050  54.845  1.00 24.67           O  
ATOM    370  CB  GLU A  49      -5.349  43.881  53.345  1.00 27.43           C  
ATOM    371  CG  GLU A  49      -5.332  45.335  52.973  0.00 37.22           C  
ATOM    372  CD  GLU A  49      -6.443  45.701  51.993  0.00 46.05           C  
ATOM    373  OE1 GLU A  49      -6.765  46.931  51.827  0.00 48.48           O  
ATOM    374  OE2 GLU A  49      -7.073  44.769  51.358  0.00 48.22           O  
ATOM    375  N   ASN A  50      -4.393  44.821  56.318  1.00 23.63           N  
ATOM    376  CA  ASN A  50      -3.849  45.897  57.141  1.00 24.76           C  
ATOM    377  C   ASN A  50      -2.565  45.479  57.879  1.00 23.08           C  
ATOM    378  O   ASN A  50      -1.981  46.321  58.557  1.00 22.76           O  
ATOM    379  CB  ASN A  50      -4.851  46.350  58.215  1.00 26.16           C  
ATOM    380  CG  ASN A  50      -5.340  45.147  59.025  1.00 28.47           C  
ATOM    381  OD1 ASN A  50      -5.864  44.192  58.290  0.00 20.00           O  
ATOM    382  ND2 ASN A  50      -5.694  45.381  60.189  0.00 20.00           N  
ATOM    383  N   ASN A  51      -2.236  44.200  57.871  1.00 20.79           N  
ATOM    384  CA  ASN A  51      -1.047  43.710  58.569  1.00 20.11           C  
ATOM    385  C   ASN A  51       0.119  43.472  57.619  1.00 19.86           C  
ATOM    386  O   ASN A  51       1.062  42.753  57.987  1.00 19.11           O  
ATOM    387  CB  ASN A  51      -1.393  42.456  59.371  1.00 20.52           C  
ATOM    388  CG  ASN A  51      -2.225  42.837  60.603  1.00 23.37           C  
ATOM    389  OD1 ASN A  51      -2.173  43.973  61.083  1.00 24.22           O  
ATOM    390  ND2 ASN A  51      -2.970  41.871  61.093  1.00 23.82           N  
ATOM    391  N   ILE A  52       0.035  43.972  56.400  1.00 18.20           N  
ATOM    392  CA  ILE A  52       1.162  43.899  55.446  1.00 18.45           C  
ATOM    393  C   ILE A  52       1.607  45.352  55.275  1.00 18.74           C  
ATOM    394  O   ILE A  52       0.839  46.192  54.784  1.00 18.32           O  
ATOM    395  CB  ILE A  52       0.803  43.265  54.104  1.00 18.25           C  
ATOM    396  CG1 ILE A  52       0.374  41.806  54.338  1.00 19.31           C  
ATOM    397  CG2 ILE A  52       2.003  43.282  53.151  1.00 18.73           C  
ATOM    398  CD1 ILE A  52      -0.107  41.109  53.075  1.00 20.57           C  
ATOM    399  N   ILE A  53       2.774  45.695  55.786  1.00 17.35           N  
ATOM    400  CA  ILE A  53       3.301  47.047  55.795  1.00 18.11           C  
ATOM    401  C   ILE A  53       4.414  47.257  54.782  1.00 18.36           C  
ATOM    402  O   ILE A  53       5.410  46.496  54.826  1.00 17.81           O  
ATOM    403  CB  ILE A  53       3.853  47.373  57.212  1.00 19.24           C  
ATOM    404  CG1 ILE A  53       2.908  46.913  58.325  1.00 21.53           C  
ATOM    405  CG2 ILE A  53       4.211  48.842  57.299  1.00 19.42           C  
ATOM    406  CD1 ILE A  53       1.546  47.593  58.336  1.00 22.98           C  
ATOM    407  N   ILE A  54       4.284  48.216  53.871  1.00 16.94           N  
ATOM    408  CA  ILE A  54       5.300  48.401  52.832  1.00 18.52           C  
ATOM    409  C   ILE A  54       6.148  49.632  53.089  1.00 18.66           C  
ATOM    410  O   ILE A  54       5.664  50.692  53.561  1.00 19.06           O  
ATOM    411  CB  ILE A  54       4.633  48.598  51.443  1.00 20.28           C  
ATOM    412  CG1 ILE A  54       3.552  47.541  51.185  1.00 22.15           C  
ATOM    413  CG2 ILE A  54       5.646  48.606  50.310  1.00 21.29           C  
ATOM    414  CD1 ILE A  54       3.997  46.103  51.141  1.00 23.62           C  
ATOM    415  N   GLU A  55       7.448  49.515  52.852  1.00 16.01           N  
ATOM    416  CA  GLU A  55       8.378  50.628  52.983  1.00 16.73           C  
ATOM    417  C   GLU A  55       9.376  50.524  51.832  1.00 16.13           C  
ATOM    418  O   GLU A  55       9.423  49.446  51.205  1.00 15.96           O  
ATOM    419  CB  GLU A  55       9.078  50.587  54.346  1.00 17.89           C  
ATOM    420  CG  GLU A  55      10.075  51.725  54.544  1.00 20.09           C  
ATOM    421  CD  GLU A  55       9.456  53.097  54.341  1.00 22.08           C  
ATOM    422  OE1 GLU A  55       9.029  53.668  55.371  1.00 24.91           O  
ATOM    423  OE2 GLU A  55       9.365  53.621  53.211  1.00 21.13           O  
ATOM    424  N   THR A  56      10.054  51.606  51.480  1.00 16.18           N  
ATOM    425  CA  THR A  56      10.982  51.556  50.352  1.00 17.32           C  
ATOM    426  C   THR A  56      12.290  52.225  50.710  1.00 16.44           C  
ATOM    427  O   THR A  56      12.365  53.041  51.644  1.00 16.88           O  
ATOM    428  CB  THR A  56      10.480  52.265  49.064  1.00 18.67           C  
ATOM    429  OG1 THR A  56      10.320  53.673  49.341  1.00 21.59           O  
ATOM    430  CG2 THR A  56       9.108  51.791  48.614  1.00 20.73           C  
ATOM    431  N   VAL A  57      13.344  51.890  49.957  1.00 15.04           N  
ATOM    432  CA  VAL A  57      14.667  52.510  50.089  1.00 14.95           C  
ATOM    433  C   VAL A  57      15.166  52.704  48.656  1.00 15.41           C  
ATOM    434  O   VAL A  57      14.621  52.083  47.750  1.00 16.33           O  
ATOM    435  CB  VAL A  57      15.713  51.677  50.869  1.00 15.40           C  
ATOM    436  CG1 VAL A  57      15.271  51.497  52.315  1.00 15.69           C  
ATOM    437  CG2 VAL A  57      15.904  50.310  50.223  1.00 15.26           C  
ATOM    438  N   PRO A  58      16.204  53.504  48.435  1.00 16.33           N  
ATOM    439  CA  PRO A  58      16.686  53.765  47.097  1.00 17.87           C  
ATOM    440  C   PRO A  58      17.275  52.544  46.416  1.00 16.94           C  
ATOM    441  O   PRO A  58      16.781  52.085  45.377  1.00 18.81           O  
ATOM    442  CB  PRO A  58      17.698  54.886  47.272  1.00 18.32           C  
ATOM    443  CG  PRO A  58      17.631  55.342  48.683  1.00 18.80           C  
ATOM    444  CD  PRO A  58      16.856  54.332  49.467  1.00 17.06           C  
ATOM    445  N   GLY A  59      18.292  51.944  47.022  1.00 16.25           N  
ATOM    446  CA  GLY A  59      18.981  50.799  46.417  1.00 14.67           C  
ATOM    447  C   GLY A  59      19.104  49.637  47.391  1.00 15.39           C  
ATOM    448  O   GLY A  59      18.827  49.749  48.590  1.00 14.21           O  
ATOM    449  N   SER A  60      19.532  48.469  46.862  1.00 14.28           N  
ATOM    450  CA  SER A  60      19.649  47.282  47.695  1.00 14.67           C  
ATOM    451  C   SER A  60      20.625  47.461  48.836  1.00 14.27           C  
ATOM    452  O   SER A  60      20.372  46.893  49.920  1.00 13.54           O  
ATOM    453  CB  SER A  60      20.110  46.047  46.886  1.00 15.54           C  
ATOM    454  OG  SER A  60      19.121  45.670  45.934  1.00 16.22           O  
ATOM    455  N   TYR A  61      21.681  48.260  48.678  1.00 13.75           N  
ATOM    456  CA  TYR A  61      22.604  48.463  49.790  1.00 14.05           C  
ATOM    457  C   TYR A  61      21.928  49.088  51.010  1.00 14.10           C  
ATOM    458  O   TYR A  61      22.374  48.880  52.125  1.00 14.15           O  
ATOM    459  CB  TYR A  61      23.749  49.388  49.356  1.00 14.44           C  
ATOM    460  CG  TYR A  61      24.925  49.447  50.290  1.00 14.73           C  
ATOM    461  CD1 TYR A  61      26.064  48.647  50.060  1.00 14.46           C  
ATOM    462  CD2 TYR A  61      24.933  50.274  51.404  1.00 14.26           C  
ATOM    463  CE1 TYR A  61      27.145  48.728  50.913  1.00 14.38           C  
ATOM    464  CE2 TYR A  61      25.995  50.347  52.264  1.00 14.70           C  
ATOM    465  CZ  TYR A  61      27.116  49.574  52.002  1.00 15.20           C  
ATOM    466  OH  TYR A  61      28.188  49.638  52.835  1.00 15.99           O  
ATOM    467  N   GLU A  62      20.844  49.840  50.822  1.00 13.96           N  
ATOM    468  CA  GLU A  62      20.142  50.479  51.936  1.00 13.44           C  
ATOM    469  C   GLU A  62      19.154  49.525  52.600  1.00 13.22           C  
ATOM    470  O   GLU A  62      18.568  49.915  53.615  1.00 13.50           O  
ATOM    471  CB  GLU A  62      19.329  51.689  51.444  1.00 14.54           C  
ATOM    472  CG  GLU A  62      20.152  52.910  51.106  1.00 14.32           C  
ATOM    473  CD  GLU A  62      21.059  52.754  49.903  1.00 16.97           C  
ATOM    474  OE1 GLU A  62      20.553  52.564  48.777  1.00 15.93           O  
ATOM    475  OE2 GLU A  62      22.296  52.814  50.088  1.00 17.84           O  
ATOM    476  N   LEU A  63      19.011  48.301  52.085  1.00 12.77           N  
ATOM    477  CA  LEU A  63      18.068  47.372  52.710  1.00 13.05           C  
ATOM    478  C   LEU A  63      18.376  47.005  54.149  1.00 13.09           C  
ATOM    479  O   LEU A  63      17.423  46.940  54.953  1.00 13.87           O  
ATOM    480  CB  LEU A  63      17.798  46.131  51.852  1.00 12.61           C  
ATOM    481  CG  LEU A  63      16.998  46.359  50.566  1.00 14.13           C  
ATOM    482  CD1 LEU A  63      17.138  45.132  49.632  1.00 14.64           C  
ATOM    483  CD2 LEU A  63      15.524  46.533  50.924  1.00 14.73           C  
ATOM    484  N   PRO A  64      19.614  46.730  54.530  1.00 13.49           N  
ATOM    485  CA  PRO A  64      19.913  46.305  55.892  1.00 12.33           C  
ATOM    486  C   PRO A  64      19.582  47.380  56.924  1.00 13.19           C  
ATOM    487  O   PRO A  64      18.813  47.087  57.854  1.00 13.04           O  
ATOM    488  CB  PRO A  64      21.381  45.907  55.864  1.00 13.41           C  
ATOM    489  CG  PRO A  64      21.601  45.484  54.420  1.00 13.05           C  
ATOM    490  CD  PRO A  64      20.808  46.569  53.658  1.00 13.04           C  
ATOM    491  N   TRP A  65      20.115  48.605  56.760  1.00 12.77           N  
ATOM    492  CA  TRP A  65      19.803  49.636  57.753  1.00 12.97           C  
ATOM    493  C   TRP A  65      18.358  50.111  57.624  1.00 13.03           C  
ATOM    494  O   TRP A  65      17.739  50.402  58.652  1.00 12.50           O  
ATOM    495  CB  TRP A  65      20.786  50.815  57.664  1.00 12.79           C  
ATOM    496  CG  TRP A  65      20.701  51.758  58.830  1.00 14.75           C  
ATOM    497  CD1 TRP A  65      20.290  53.067  58.789  1.00 14.39           C  
ATOM    498  CD2 TRP A  65      21.043  51.462  60.187  1.00 14.61           C  
ATOM    499  NE1 TRP A  65      20.347  53.592  60.072  1.00 14.06           N  
ATOM    500  CE2 TRP A  65      20.798  52.640  60.938  1.00 14.63           C  
ATOM    501  CE3 TRP A  65      21.486  50.331  60.879  1.00 15.46           C  
ATOM    502  CZ2 TRP A  65      20.994  52.707  62.306  1.00 15.35           C  
ATOM    503  CZ3 TRP A  65      21.693  50.393  62.255  1.00 15.87           C  
ATOM    504  CH2 TRP A  65      21.460  51.591  62.957  1.00 15.19           C  
ATOM    505  N   GLY A  66      17.858  50.137  56.396  1.00 12.79           N  
ATOM    506  CA  GLY A  66      16.438  50.525  56.226  1.00 13.27           C  
ATOM    507  C   GLY A  66      15.552  49.539  56.979  1.00 14.08           C  
ATOM    508  O   GLY A  66      14.582  49.932  57.665  1.00 13.73           O  
ATOM    509  N   THR A  67      15.859  48.251  56.860  1.00 13.06           N  
ATOM    510  CA  THR A  67      15.076  47.243  57.566  1.00 12.83           C  
ATOM    511  C   THR A  67      15.221  47.407  59.068  1.00 13.20           C  
ATOM    512  O   THR A  67      14.213  47.338  59.785  1.00 13.11           O  
ATOM    513  CB  THR A  67      15.539  45.822  57.185  1.00 13.26           C  
ATOM    514  OG1 THR A  67      15.338  45.619  55.780  1.00 13.26           O  
ATOM    515  CG2 THR A  67      14.775  44.754  57.951  1.00 12.86           C  
ATOM    516  N   LYS A  68      16.437  47.628  59.566  1.00 12.83           N  
ATOM    517  CA  LYS A  68      16.629  47.808  61.008  1.00 13.00           C  
ATOM    518  C   LYS A  68      15.729  48.957  61.497  1.00 12.53           C  
ATOM    519  O   LYS A  68      14.997  48.810  62.506  1.00 13.62           O  
ATOM    520  CB  LYS A  68      18.112  48.144  61.259  1.00 12.09           C  
ATOM    521  CG  LYS A  68      18.506  48.236  62.719  1.00 14.68           C  
ATOM    522  CD  LYS A  68      18.333  49.632  63.338  1.00 15.36           C  
ATOM    523  CE  LYS A  68      18.768  49.514  64.810  1.00 17.89           C  
ATOM    524  NZ  LYS A  68      18.431  50.729  65.595  1.00 18.86           N  
ATOM    525  N   ARG A  69      15.788  50.086  60.819  1.00 12.48           N  
ATOM    526  CA  ARG A  69      14.997  51.266  61.245  1.00 13.16           C  
ATOM    527  C   ARG A  69      13.504  51.114  60.992  1.00 13.30           C  
ATOM    528  O   ARG A  69      12.683  51.611  61.782  1.00 14.08           O  
ATOM    529  CB  ARG A  69      15.580  52.523  60.582  1.00 12.61           C  
ATOM    530  CG  ARG A  69      17.012  52.850  61.045  1.00 12.94           C  
ATOM    531  CD  ARG A  69      17.051  53.186  62.538  1.00 13.64           C  
ATOM    532  NE  ARG A  69      16.490  54.513  62.825  1.00 14.52           N  
ATOM    533  CZ  ARG A  69      15.917  54.869  63.967  1.00 16.56           C  
ATOM    534  NH1 ARG A  69      15.699  54.011  64.974  1.00 16.13           N  
ATOM    535  NH2 ARG A  69      15.517  56.146  64.121  1.00 16.25           N  
ATOM    536  N   PHE A  70      13.082  50.389  59.970  1.00 12.77           N  
ATOM    537  CA  PHE A  70      11.670  50.100  59.695  1.00 13.48           C  
ATOM    538  C   PHE A  70      11.110  49.284  60.849  1.00 13.62           C  
ATOM    539  O   PHE A  70      10.039  49.538  61.403  1.00 13.08           O  
ATOM    540  CB  PHE A  70      11.602  49.347  58.366  1.00 13.49           C  
ATOM    541  CG  PHE A  70      10.286  48.811  57.882  1.00 14.44           C  
ATOM    542  CD1 PHE A  70       9.092  49.473  58.142  1.00 14.30           C  
ATOM    543  CD2 PHE A  70      10.259  47.664  57.101  1.00 14.24           C  
ATOM    544  CE1 PHE A  70       7.900  48.983  57.629  1.00 14.86           C  
ATOM    545  CE2 PHE A  70       9.078  47.173  56.582  1.00 14.93           C  
ATOM    546  CZ  PHE A  70       7.889  47.848  56.852  1.00 15.20           C  
ATOM    547  N   VAL A  71      11.891  48.294  61.325  1.00 13.73           N  
ATOM    548  CA  VAL A  71      11.493  47.508  62.491  1.00 13.44           C  
ATOM    549  C   VAL A  71      11.362  48.418  63.703  1.00 14.44           C  
ATOM    550  O   VAL A  71      10.370  48.317  64.433  1.00 13.64           O  
ATOM    551  CB  VAL A  71      12.535  46.392  62.758  1.00 13.18           C  
ATOM    552  CG1 VAL A  71      12.435  45.837  64.178  1.00 13.32           C  
ATOM    553  CG2 VAL A  71      12.370  45.275  61.743  1.00 13.20           C  
ATOM    554  N   ASP A  72      12.337  49.307  63.935  1.00 13.44           N  
ATOM    555  CA  ASP A  72      12.263  50.214  65.060  1.00 14.62           C  
ATOM    556  C   ASP A  72      10.987  51.085  64.961  1.00 15.21           C  
ATOM    557  O   ASP A  72      10.316  51.284  65.972  1.00 15.51           O  
ATOM    558  CB  ASP A  72      13.429  51.223  65.085  1.00 14.30           C  
ATOM    559  CG  ASP A  72      14.741  50.543  65.483  1.00 16.59           C  
ATOM    560  OD1 ASP A  72      14.692  49.462  66.102  1.00 16.16           O  
ATOM    561  OD2 ASP A  72      15.828  51.069  65.171  1.00 16.65           O  
ATOM    562  N   ARG A  73      10.751  51.648  63.778  1.00 15.51           N  
ATOM    563  CA  ARG A  73       9.601  52.527  63.592  1.00 16.75           C  
ATOM    564  C   ARG A  73       8.286  51.803  63.898  1.00 16.38           C  
ATOM    565  O   ARG A  73       7.386  52.353  64.577  1.00 14.64           O  
ATOM    566  CB  ARG A  73       9.538  53.108  62.172  1.00 17.22           C  
ATOM    567  CG  ARG A  73       8.469  54.218  62.122  1.00 22.12           C  
ATOM    568  CD  ARG A  73       8.455  54.795  60.697  1.00 24.92           C  
ATOM    569  NE  ARG A  73       7.749  53.811  59.876  1.00 28.26           N  
ATOM    570  CZ  ARG A  73       7.892  53.206  58.797  0.00 35.10           C  
ATOM    571  NH1 ARG A  73       9.165  53.321  58.138  1.00 31.58           N  
ATOM    572  NH2 ARG A  73       7.008  52.356  58.364  1.00 27.53           N  
ATOM    573  N   GLN A  74       8.117  50.600  63.373  1.00 13.32           N  
ATOM    574  CA  GLN A  74       6.904  49.819  63.599  1.00 13.86           C  
ATOM    575  C   GLN A  74       6.705  49.493  65.067  1.00 14.33           C  
ATOM    576  O   GLN A  74       5.567  49.596  65.588  1.00 14.92           O  
ATOM    577  CB  GLN A  74       6.887  48.513  62.771  1.00 14.44           C  
ATOM    578  CG  GLN A  74       6.701  48.870  61.273  1.00 15.15           C  
ATOM    579  CD  GLN A  74       5.381  49.555  60.982  1.00 15.98           C  
ATOM    580  OE1 GLN A  74       4.309  49.157  61.503  1.00 17.70           O  
ATOM    581  NE2 GLN A  74       5.378  50.529  60.226  1.00 16.77           N  
ATOM    582  N   ALA A  75       7.768  49.133  65.776  1.00 14.14           N  
ATOM    583  CA  ALA A  75       7.655  48.828  67.199  1.00 14.24           C  
ATOM    584  C   ALA A  75       7.270  50.083  67.992  1.00 15.28           C  
ATOM    585  O   ALA A  75       6.451  50.009  68.902  1.00 15.91           O  
ATOM    586  CB  ALA A  75       8.975  48.292  67.764  1.00 14.70           C  
ATOM    587  N   LYS A  76       7.871  51.214  67.628  1.00 15.91           N  
ATOM    588  CA  LYS A  76       7.576  52.479  68.315  1.00 18.37           C  
ATOM    589  C   LYS A  76       6.125  52.892  68.091  1.00 17.80           C  
ATOM    590  O   LYS A  76       5.499  53.410  69.024  1.00 18.56           O  
ATOM    591  CB  LYS A  76       8.562  53.573  67.929  1.00 20.31           C  
ATOM    592  CG  LYS A  76       8.526  54.835  68.778  1.00 24.00           C  
ATOM    593  CD  LYS A  76       9.821  55.634  68.604  1.00 25.45           C  
ATOM    594  CE  LYS A  76      10.159  56.697  69.530  0.00 30.03           C  
ATOM    595  NZ  LYS A  76      11.586  57.016  69.709  0.00 30.21           N  
ATOM    596  N   LEU A  77       5.540  52.589  66.946  1.00 17.75           N  
ATOM    597  CA  LEU A  77       4.163  52.855  66.599  1.00 21.18           C  
ATOM    598  C   LEU A  77       3.199  51.914  67.294  1.00 19.67           C  
ATOM    599  O   LEU A  77       1.972  52.057  67.128  1.00 21.43           O  
ATOM    600  CB  LEU A  77       3.928  52.663  65.087  1.00 22.59           C  
ATOM    601  CG  LEU A  77       4.222  53.773  64.103  1.00 26.29           C  
ATOM    602  CD1 LEU A  77       5.428  54.602  64.486  1.00 28.99           C  
ATOM    603  CD2 LEU A  77       4.394  53.213  62.676  1.00 25.94           C  
ATOM    604  N   GLY A  78       3.669  50.864  67.942  1.00 17.73           N  
ATOM    605  CA  GLY A  78       2.837  49.869  68.568  1.00 16.57           C  
ATOM    606  C   GLY A  78       2.208  48.930  67.552  1.00 16.35           C  
ATOM    607  O   GLY A  78       1.237  48.209  67.795  1.00 15.21           O  
ATOM    608  N   LYS A  79       2.864  48.770  66.398  1.00 15.02           N  
ATOM    609  CA  LYS A  79       2.495  47.831  65.347  1.00 14.90           C  
ATOM    610  C   LYS A  79       3.738  47.025  64.914  1.00 14.39           C  
ATOM    611  O   LYS A  79       4.158  47.115  63.759  1.00 12.75           O  
ATOM    612  CB  LYS A  79       1.982  48.659  64.155  1.00 15.95           C  
ATOM    613  CG  LYS A  79       0.691  49.467  64.381  1.00 20.34           C  
ATOM    614  CD  LYS A  79      -0.467  48.533  64.690  1.00 23.75           C  
ATOM    615  CE  LYS A  79      -1.760  49.336  64.924  1.00 26.62           C  
ATOM    616  NZ  LYS A  79      -2.881  48.413  65.236  1.00 28.19           N  
ATOM    617  N   PRO A  80       4.369  46.324  65.834  1.00 14.91           N  
ATOM    618  CA  PRO A  80       5.633  45.653  65.568  1.00 15.25           C  
ATOM    619  C   PRO A  80       5.480  44.571  64.500  1.00 14.93           C  
ATOM    620  O   PRO A  80       4.476  43.868  64.467  1.00 14.48           O  
ATOM    621  CB  PRO A  80       6.046  45.051  66.894  1.00 15.75           C  
ATOM    622  CG  PRO A  80       4.751  44.834  67.624  1.00 16.70           C  
ATOM    623  CD  PRO A  80       3.966  46.097  67.245  1.00 15.85           C  
ATOM    624  N   LEU A  81       6.537  44.415  63.716  1.00 14.14           N  
ATOM    625  CA  LEU A  81       6.545  43.351  62.711  1.00 13.86           C  
ATOM    626  C   LEU A  81       6.899  42.014  63.350  1.00 14.45           C  
ATOM    627  O   LEU A  81       7.720  41.971  64.271  1.00 14.65           O  
ATOM    628  CB  LEU A  81       7.592  43.685  61.633  1.00 13.97           C  
ATOM    629  CG  LEU A  81       7.415  45.053  60.943  1.00 14.19           C  
ATOM    630  CD1 LEU A  81       8.526  45.212  59.893  1.00 14.89           C  
ATOM    631  CD2 LEU A  81       6.054  45.156  60.256  1.00 14.61           C  
ATOM    632  N   ASP A  82       6.356  40.926  62.793  1.00 13.23           N  
ATOM    633  CA  ASP A  82       6.714  39.595  63.237  1.00 13.95           C  
ATOM    634  C   ASP A  82       7.795  39.011  62.288  1.00 13.36           C  
ATOM    635  O   ASP A  82       8.447  38.056  62.684  1.00 13.50           O  
ATOM    636  CB  ASP A  82       5.530  38.604  63.180  1.00 14.33           C  
ATOM    637  CG  ASP A  82       4.468  39.079  64.198  1.00 16.87           C  
ATOM    638  OD1 ASP A  82       4.820  39.012  65.374  1.00 18.49           O  
ATOM    639  OD2 ASP A  82       3.391  39.499  63.777  1.00 16.23           O  
ATOM    640  N   VAL A  83       7.888  39.570  61.111  1.00 12.99           N  
ATOM    641  CA  VAL A  83       8.835  39.069  60.090  1.00 13.20           C  
ATOM    642  C   VAL A  83       8.941  40.132  59.024  1.00 13.60           C  
ATOM    643  O   VAL A  83       8.041  40.997  58.916  1.00 13.90           O  
ATOM    644  CB  VAL A  83       8.353  37.717  59.543  1.00 13.70           C  
ATOM    645  CG1 VAL A  83       6.985  37.850  58.853  1.00 13.26           C  
ATOM    646  CG2 VAL A  83       9.345  37.150  58.530  1.00 14.17           C  
ATOM    647  N   VAL A  84      10.080  40.227  58.334  1.00 12.45           N  
ATOM    648  CA  VAL A  84      10.237  41.259  57.320  1.00 13.03           C  
ATOM    649  C   VAL A  84      10.873  40.629  56.088  1.00 12.84           C  
ATOM    650  O   VAL A  84      11.602  39.634  56.153  1.00 14.29           O  
ATOM    651  CB  VAL A  84      11.046  42.456  57.891  1.00 14.69           C  
ATOM    652  CG1 VAL A  84      12.394  41.939  58.382  1.00 15.74           C  
ATOM    653  CG2 VAL A  84      11.165  43.570  56.871  1.00 15.33           C  
ATOM    654  N   ILE A  85      10.424  41.089  54.927  1.00 12.20           N  
ATOM    655  CA  ILE A  85      10.954  40.694  53.644  1.00 13.35           C  
ATOM    656  C   ILE A  85      11.599  41.826  52.870  1.00 13.96           C  
ATOM    657  O   ILE A  85      10.973  42.608  52.137  1.00 13.65           O  
ATOM    658  CB  ILE A  85       9.877  40.136  52.673  1.00 14.50           C  
ATOM    659  CG1 ILE A  85       8.923  39.208  53.385  1.00 13.81           C  
ATOM    660  CG2 ILE A  85      10.576  39.431  51.508  1.00 14.53           C  
ATOM    661  CD1 ILE A  85       7.757  38.577  52.637  1.00 15.62           C  
ATOM    662  N   PRO A  86      12.914  42.007  52.989  1.00 13.92           N  
ATOM    663  CA  PRO A  86      13.665  42.974  52.205  1.00 13.72           C  
ATOM    664  C   PRO A  86      13.790  42.464  50.764  1.00 14.95           C  
ATOM    665  O   PRO A  86      14.195  41.315  50.490  1.00 14.63           O  
ATOM    666  CB  PRO A  86      15.039  43.090  52.859  1.00 14.92           C  
ATOM    667  CG  PRO A  86      15.196  41.783  53.563  1.00 16.21           C  
ATOM    668  CD  PRO A  86      13.827  41.232  53.872  1.00 15.62           C  
ATOM    669  N   ILE A  87      13.401  43.326  49.833  1.00 14.12           N  
ATOM    670  CA  ILE A  87      13.400  42.924  48.408  1.00 14.45           C  
ATOM    671  C   ILE A  87      14.242  43.901  47.626  1.00 14.10           C  
ATOM    672  O   ILE A  87      14.060  45.126  47.689  1.00 14.90           O  
ATOM    673  CB  ILE A  87      11.964  42.869  47.854  1.00 14.33           C  
ATOM    674  CG1 ILE A  87      11.171  41.750  48.498  1.00 15.04           C  
ATOM    675  CG2 ILE A  87      11.967  42.678  46.323  1.00 14.85           C  
ATOM    676  CD1 ILE A  87       9.716  41.511  48.154  1.00 15.05           C  
ATOM    677  N   GLY A  88      15.165  43.356  46.801  1.00 15.03           N  
ATOM    678  CA  GLY A  88      15.999  44.248  45.971  1.00 14.63           C  
ATOM    679  C   GLY A  88      16.380  43.403  44.733  1.00 15.20           C  
ATOM    680  O   GLY A  88      16.262  42.191  44.760  1.00 15.41           O  
ATOM    681  N   VAL A  89      16.733  44.100  43.666  1.00 15.81           N  
ATOM    682  CA  VAL A  89      17.121  43.433  42.420  1.00 16.18           C  
ATOM    683  C   VAL A  89      18.456  44.010  41.969  1.00 16.43           C  
ATOM    684  O   VAL A  89      18.582  45.200  41.668  1.00 17.67           O  
ATOM    685  CB  VAL A  89      16.077  43.604  41.316  1.00 17.35           C  
ATOM    686  CG1 VAL A  89      16.597  42.980  40.008  1.00 18.28           C  
ATOM    687  CG2 VAL A  89      14.778  42.896  41.698  1.00 18.04           C  
ATOM    688  N   LEU A  90      19.488  43.184  41.963  1.00 17.20           N  
ATOM    689  CA  LEU A  90      20.823  43.526  41.556  1.00 17.67           C  
ATOM    690  C   LEU A  90      21.131  42.779  40.259  1.00 18.57           C  
ATOM    691  O   LEU A  90      20.908  41.583  40.160  1.00 19.14           O  
ATOM    692  CB  LEU A  90      21.835  43.109  42.622  1.00 18.72           C  
ATOM    693  CG  LEU A  90      21.748  44.006  43.871  1.00 19.33           C  
ATOM    694  CD1 LEU A  90      22.100  43.177  45.100  1.00 21.14           C  
ATOM    695  CD2 LEU A  90      22.709  45.178  43.722  1.00 20.42           C  
ATOM    696  N   ILE A  91      21.617  43.528  39.289  1.00 19.66           N  
ATOM    697  CA  ILE A  91      21.919  42.950  37.974  1.00 20.42           C  
ATOM    698  C   ILE A  91      23.348  43.340  37.614  1.00 20.76           C  
ATOM    699  O   ILE A  91      23.713  44.521  37.660  1.00 20.76           O  
ATOM    700  CB  ILE A  91      20.933  43.426  36.904  1.00 20.74           C  
ATOM    701  CG1 ILE A  91      19.504  42.948  37.215  1.00 21.65           C  
ATOM    702  CG2 ILE A  91      21.341  42.851  35.529  1.00 21.00           C  
ATOM    703  CD1 ILE A  91      18.403  43.698  36.493  1.00 22.75           C  
ATOM    704  N   LYS A  92      24.173  42.323  37.354  1.00 21.63           N  
ATOM    705  CA  LYS A  92      25.581  42.560  37.050  1.00 22.74           C  
ATOM    706  C   LYS A  92      25.756  43.590  35.945  1.00 23.95           C  
ATOM    707  O   LYS A  92      25.062  43.516  34.931  1.00 24.11           O  
ATOM    708  CB  LYS A  92      26.243  41.229  36.675  1.00 24.14           C  
ATOM    709  CG  LYS A  92      27.658  41.319  36.129  1.00 25.88           C  
ATOM    710  CD  LYS A  92      28.696  41.717  37.160  1.00 26.56           C  
ATOM    711  CE  LYS A  92      30.093  41.690  36.531  1.00 27.62           C  
ATOM    712  NZ  LYS A  92      31.149  42.160  37.465  1.00 27.44           N  
ATOM    713  N   GLY A  93      26.696  44.511  36.122  1.00 23.87           N  
ATOM    714  CA  GLY A  93      27.001  45.521  35.120  1.00 24.86           C  
ATOM    715  C   GLY A  93      28.437  45.285  34.635  1.00 25.57           C  
ATOM    716  O   GLY A  93      28.851  44.121  34.501  1.00 25.27           O  
ATOM    717  N   SER A  94      29.205  46.342  34.385  1.00 26.00           N  
ATOM    718  CA  SER A  94      30.579  46.146  33.935  1.00 26.69           C  
ATOM    719  C   SER A  94      31.609  46.140  35.057  1.00 27.02           C  
ATOM    720  O   SER A  94      32.718  45.642  34.829  1.00 26.02           O  
ATOM    721  CB  SER A  94      30.972  47.264  32.953  1.00 27.14           C  
ATOM    722  OG  SER A  94      30.053  47.204  31.879  1.00 30.03           O  
ATOM    723  N   THR A  95      31.304  46.756  36.202  1.00 25.73           N  
ATOM    724  CA  THR A  95      32.305  46.795  37.278  1.00 25.31           C  
ATOM    725  C   THR A  95      32.039  45.692  38.296  1.00 24.73           C  
ATOM    726  O   THR A  95      31.196  44.803  38.144  1.00 24.59           O  
ATOM    727  CB  THR A  95      32.317  48.148  38.012  1.00 26.06           C  
ATOM    728  OG1 THR A  95      31.121  48.257  38.810  1.00 25.47           O  
ATOM    729  CG2 THR A  95      32.335  49.329  37.034  1.00 24.94           C  
ATOM    730  N   MET A  96      32.725  45.794  39.432  1.00 25.86           N  
ATOM    731  CA  MET A  96      32.559  44.855  40.540  1.00 25.69           C  
ATOM    732  C   MET A  96      31.527  45.371  41.530  1.00 24.87           C  
ATOM    733  O   MET A  96      31.317  44.761  42.587  1.00 24.02           O  
ATOM    734  CB  MET A  96      33.879  44.602  41.280  1.00 27.60           C  
ATOM    735  CG  MET A  96      34.886  43.806  40.448  1.00 31.06           C  
ATOM    736  SD  MET A  96      34.155  42.310  39.752  1.00 34.88           S  
ATOM    737  CE  MET A  96      34.056  41.250  41.185  1.00 33.98           C  
ATOM    738  N   HIS A  97      30.828  46.448  41.187  1.00 23.65           N  
ATOM    739  CA  HIS A  97      29.823  46.968  42.116  1.00 24.40           C  
ATOM    740  C   HIS A  97      28.788  45.913  42.457  1.00 22.78           C  
ATOM    741  O   HIS A  97      28.420  45.747  43.619  1.00 21.62           O  
ATOM    742  CB  HIS A  97      29.135  48.178  41.479  1.00 27.93           C  
ATOM    743  CG  HIS A  97      29.261  49.355  42.401  1.00 31.06           C  
ATOM    744  ND1 HIS A  97      28.226  50.229  42.586  1.00 32.89           N  
ATOM    745  CD2 HIS A  97      30.309  49.763  43.171  1.00 32.36           C  
ATOM    746  CE1 HIS A  97      28.625  51.148  43.435  1.00 34.27           C  
ATOM    747  NE2 HIS A  97      29.881  50.908  43.801  1.00 34.40           N  
ATOM    748  N   PHE A  98      28.292  45.211  41.439  1.00 20.58           N  
ATOM    749  CA  PHE A  98      27.309  44.165  41.672  1.00 20.52           C  
ATOM    750  C   PHE A  98      27.773  43.208  42.750  1.00 20.41           C  
ATOM    751  O   PHE A  98      26.983  42.912  43.672  1.00 21.38           O  
ATOM    752  CB  PHE A  98      27.028  43.395  40.388  1.00 20.17           C  
ATOM    753  CG  PHE A  98      26.304  42.092  40.516  1.00 20.71           C  
ATOM    754  CD1 PHE A  98      24.911  42.049  40.603  1.00 20.43           C  
ATOM    755  CD2 PHE A  98      26.995  40.900  40.538  1.00 20.89           C  
ATOM    756  CE1 PHE A  98      24.247  40.843  40.680  1.00 20.31           C  
ATOM    757  CE2 PHE A  98      26.349  39.695  40.618  1.00 21.70           C  
ATOM    758  CZ  PHE A  98      24.966  39.667  40.701  1.00 21.41           C  
ATOM    759  N   GLU A  99      28.977  42.667  42.637  1.00 19.54           N  
ATOM    760  CA  GLU A  99      29.511  41.724  43.595  1.00 20.08           C  
ATOM    761  C   GLU A  99      29.682  42.316  44.993  1.00 19.66           C  
ATOM    762  O   GLU A  99      29.297  41.630  45.944  1.00 18.36           O  
ATOM    763  CB  GLU A  99      30.892  41.200  43.139  1.00 22.24           C  
ATOM    764  CG  GLU A  99      30.802  40.306  41.915  1.00 24.06           C  
ATOM    765  CD  GLU A  99      30.755  40.999  40.574  1.00 25.57           C  
ATOM    766  OE1 GLU A  99      30.508  42.208  40.385  1.00 24.02           O  
ATOM    767  OE2 GLU A  99      30.999  40.236  39.592  1.00 26.14           O  
ATOM    768  N   TYR A 100      30.290  43.507  45.096  1.00 19.18           N  
ATOM    769  CA  TYR A 100      30.484  44.077  46.436  1.00 18.83           C  
ATOM    770  C   TYR A 100      29.167  44.419  47.111  1.00 18.11           C  
ATOM    771  O   TYR A 100      29.040  44.151  48.307  1.00 17.93           O  
ATOM    772  CB  TYR A 100      31.454  45.278  46.407  1.00 18.94           C  
ATOM    773  CG  TYR A 100      32.844  44.724  46.067  1.00 20.21           C  
ATOM    774  CD1 TYR A 100      33.424  43.776  46.899  1.00 21.00           C  
ATOM    775  CD2 TYR A 100      33.494  45.098  44.908  1.00 20.82           C  
ATOM    776  CE1 TYR A 100      34.643  43.202  46.573  1.00 22.58           C  
ATOM    777  CE2 TYR A 100      34.731  44.547  44.583  1.00 21.81           C  
ATOM    778  CZ  TYR A 100      35.288  43.610  45.416  1.00 22.57           C  
ATOM    779  OH  TYR A 100      36.513  43.056  45.091  1.00 24.14           O  
ATOM    780  N   ILE A 101      28.200  44.984  46.392  1.00 17.45           N  
ATOM    781  CA  ILE A 101      26.898  45.271  47.013  1.00 17.20           C  
ATOM    782  C   ILE A 101      26.197  43.962  47.356  1.00 17.27           C  
ATOM    783  O   ILE A 101      25.638  43.817  48.448  1.00 16.62           O  
ATOM    784  CB  ILE A 101      26.000  46.099  46.078  1.00 17.47           C  
ATOM    785  CG1 ILE A 101      26.671  47.465  45.826  1.00 20.04           C  
ATOM    786  CG2 ILE A 101      24.607  46.295  46.694  1.00 17.64           C  
ATOM    787  CD1 ILE A 101      26.014  48.253  44.698  1.00 21.60           C  
ATOM    788  N   SER A 102      26.159  42.997  46.423  1.00 16.31           N  
ATOM    789  CA  SER A 102      25.480  41.744  46.710  1.00 17.05           C  
ATOM    790  C   SER A 102      26.018  41.059  47.958  1.00 16.52           C  
ATOM    791  O   SER A 102      25.246  40.554  48.788  1.00 16.00           O  
ATOM    792  CB  SER A 102      25.538  40.734  45.549  1.00 17.88           C  
ATOM    793  OG  SER A 102      24.836  41.278  44.437  1.00 18.29           O  
ATOM    794  N   ASP A 103      27.335  40.927  48.030  1.00 16.53           N  
ATOM    795  CA  ASP A 103      27.988  40.202  49.124  1.00 18.45           C  
ATOM    796  C   ASP A 103      27.739  40.882  50.460  1.00 17.02           C  
ATOM    797  O   ASP A 103      27.286  40.223  51.391  1.00 17.16           O  
ATOM    798  CB  ASP A 103      29.499  40.144  48.824  1.00 20.70           C  
ATOM    799  CG  ASP A 103      30.318  39.388  49.841  1.00 24.55           C  
ATOM    800  OD1 ASP A 103      29.814  38.444  50.454  1.00 25.95           O  
ATOM    801  OD2 ASP A 103      31.509  39.719  50.028  1.00 28.58           O  
ATOM    802  N   SER A 104      28.030  42.176  50.573  1.00 16.12           N  
ATOM    803  CA  SER A 104      27.806  42.854  51.848  1.00 16.61           C  
ATOM    804  C   SER A 104      26.324  42.918  52.211  1.00 15.98           C  
ATOM    805  O   SER A 104      26.017  42.770  53.389  1.00 14.78           O  
ATOM    806  CB  SER A 104      28.496  44.227  51.853  1.00 18.57           C  
ATOM    807  OG  SER A 104      27.847  45.019  50.829  1.00 22.87           O  
ATOM    808  N   THR A 105      25.429  43.111  51.238  1.00 14.00           N  
ATOM    809  CA  THR A 105      24.003  43.164  51.582  1.00 14.09           C  
ATOM    810  C   THR A 105      23.503  41.805  52.055  1.00 14.28           C  
ATOM    811  O   THR A 105      22.764  41.690  53.034  1.00 12.98           O  
ATOM    812  CB  THR A 105      23.165  43.666  50.392  1.00 14.24           C  
ATOM    813  OG1 THR A 105      23.659  44.953  50.013  1.00 14.95           O  
ATOM    814  CG2 THR A 105      21.696  43.771  50.814  1.00 14.55           C  
ATOM    815  N   THR A 106      23.907  40.731  51.363  1.00 13.33           N  
ATOM    816  CA  THR A 106      23.438  39.404  51.787  1.00 14.61           C  
ATOM    817  C   THR A 106      23.924  39.096  53.193  1.00 14.45           C  
ATOM    818  O   THR A 106      23.139  38.694  54.066  1.00 14.41           O  
ATOM    819  CB  THR A 106      23.937  38.327  50.799  1.00 14.99           C  
ATOM    820  OG1 THR A 106      23.391  38.668  49.513  1.00 15.17           O  
ATOM    821  CG2 THR A 106      23.444  36.940  51.205  1.00 15.38           C  
ATOM    822  N   HIS A 107      25.223  39.287  53.463  1.00 13.75           N  
ATOM    823  CA  HIS A 107      25.700  39.004  54.838  1.00 14.66           C  
ATOM    824  C   HIS A 107      25.003  39.886  55.877  1.00 14.01           C  
ATOM    825  O   HIS A 107      24.711  39.396  56.996  1.00 13.06           O  
ATOM    826  CB  HIS A 107      27.216  39.246  54.910  1.00 16.07           C  
ATOM    827  CG  HIS A 107      27.944  38.023  54.409  1.00 18.64           C  
ATOM    828  ND1 HIS A 107      28.326  37.867  53.092  1.00 21.54           N  
ATOM    829  CD2 HIS A 107      28.309  36.915  55.068  1.00 18.96           C  
ATOM    830  CE1 HIS A 107      28.951  36.705  52.978  1.00 20.04           C  
ATOM    831  NE2 HIS A 107      28.961  36.104  54.140  1.00 21.94           N  
ATOM    832  N   ALA A 108      24.817  41.174  55.581  1.00 13.92           N  
ATOM    833  CA  ALA A 108      24.181  42.088  56.528  1.00 14.08           C  
ATOM    834  C   ALA A 108      22.742  41.669  56.831  1.00 13.76           C  
ATOM    835  O   ALA A 108      22.343  41.740  58.011  1.00 12.89           O  
ATOM    836  CB  ALA A 108      24.238  43.543  56.027  1.00 14.00           C  
ATOM    837  N   LEU A 109      21.983  41.264  55.833  1.00 12.37           N  
ATOM    838  CA  LEU A 109      20.587  40.832  56.044  1.00 12.79           C  
ATOM    839  C   LEU A 109      20.569  39.580  56.903  1.00 13.38           C  
ATOM    840  O   LEU A 109      19.784  39.412  57.867  1.00 12.32           O  
ATOM    841  CB  LEU A 109      19.872  40.628  54.710  1.00 12.62           C  
ATOM    842  CG  LEU A 109      19.634  41.915  53.903  1.00 13.39           C  
ATOM    843  CD1 LEU A 109      19.024  41.564  52.548  1.00 13.66           C  
ATOM    844  CD2 LEU A 109      18.696  42.857  54.683  1.00 14.06           C  
ATOM    845  N   MET A 110      21.494  38.635  56.581  1.00 13.01           N  
ATOM    846  CA  MET A 110      21.532  37.413  57.399  1.00 13.52           C  
ATOM    847  C   MET A 110      21.851  37.725  58.859  1.00 14.47           C  
ATOM    848  O   MET A 110      21.192  37.251  59.802  1.00 14.54           O  
ATOM    849  CB  MET A 110      22.629  36.483  56.833  1.00 13.28           C  
ATOM    850  CG  MET A 110      22.933  35.302  57.750  1.00 14.20           C  
ATOM    851  SD  MET A 110      21.562  34.118  57.862  1.00 13.35           S  
ATOM    852  CE  MET A 110      21.622  33.420  56.215  1.00 14.59           C  
ATOM    853  N   ASN A 111      22.839  38.599  59.083  1.00 14.30           N  
ATOM    854  CA  ASN A 111      23.272  38.914  60.444  1.00 16.71           C  
ATOM    855  C   ASN A 111      22.330  39.879  61.155  1.00 14.99           C  
ATOM    856  O   ASN A 111      22.399  40.030  62.379  1.00 15.11           O  
ATOM    857  CB  ASN A 111      24.668  39.572  60.377  1.00 19.87           C  
ATOM    858  CG  ASN A 111      25.715  38.520  60.030  1.00 24.98           C  
ATOM    859  OD1 ASN A 111      25.622  37.372  60.467  1.00 27.67           O  
ATOM    860  ND2 ASN A 111      26.727  38.918  59.263  1.00 27.21           N  
ATOM    861  N   LEU A 112      21.441  40.510  60.408  1.00 13.96           N  
ATOM    862  CA  LEU A 112      20.506  41.491  61.000  1.00 13.93           C  
ATOM    863  C   LEU A 112      19.469  40.792  61.860  1.00 13.70           C  
ATOM    864  O   LEU A 112      18.939  41.365  62.838  1.00 13.22           O  
ATOM    865  CB  LEU A 112      19.816  42.248  59.865  1.00 14.27           C  
ATOM    866  CG  LEU A 112      18.757  43.282  60.306  1.00 16.53           C  
ATOM    867  CD1 LEU A 112      19.454  44.387  61.088  1.00 17.44           C  
ATOM    868  CD2 LEU A 112      18.050  43.901  59.104  1.00 16.68           C  
ATOM    869  N   GLN A 113      19.140  39.514  61.558  1.00 13.28           N  
ATOM    870  CA  GLN A 113      18.096  38.821  62.301  1.00 13.73           C  
ATOM    871  C   GLN A 113      18.259  38.815  63.806  1.00 14.37           C  
ATOM    872  O   GLN A 113      17.275  39.007  64.547  1.00 13.19           O  
ATOM    873  CB  GLN A 113      17.991  37.357  61.773  1.00 13.65           C  
ATOM    874  CG  GLN A 113      17.642  37.399  60.252  1.00 13.41           C  
ATOM    875  CD  GLN A 113      17.517  35.969  59.713  1.00 12.96           C  
ATOM    876  OE1 GLN A 113      16.412  35.428  59.626  1.00 13.50           O  
ATOM    877  NE2 GLN A 113      18.629  35.309  59.370  1.00 12.95           N  
ATOM    878  N   GLU A 114      19.484  38.605  64.300  1.00 14.48           N  
ATOM    879  CA  GLU A 114      19.730  38.616  65.749  1.00 16.69           C  
ATOM    880  C   GLU A 114      19.464  40.017  66.311  1.00 16.10           C  
ATOM    881  O   GLU A 114      19.048  40.109  67.463  1.00 16.85           O  
ATOM    882  CB  GLU A 114      21.209  38.274  65.973  1.00 21.20           C  
ATOM    883  CG  GLU A 114      21.623  38.220  67.429  1.00 27.47           C  
ATOM    884  CD  GLU A 114      23.119  38.010  67.582  1.00 31.45           C  
ATOM    885  OE1 GLU A 114      23.834  37.895  66.552  1.00 34.45           O  
ATOM    886  OE2 GLU A 114      23.566  37.977  68.756  1.00 34.14           O  
ATOM    887  N   LYS A 115      19.749  41.036  65.508  1.00 15.44           N  
ATOM    888  CA  LYS A 115      19.570  42.424  65.935  1.00 16.66           C  
ATOM    889  C   LYS A 115      18.116  42.860  65.940  1.00 16.20           C  
ATOM    890  O   LYS A 115      17.681  43.491  66.912  1.00 16.17           O  
ATOM    891  CB  LYS A 115      20.461  43.327  65.075  1.00 18.42           C  
ATOM    892  CG  LYS A 115      21.953  43.114  65.360  1.00 20.33           C  
ATOM    893  CD  LYS A 115      22.558  43.465  66.421  0.00 31.04           C  
ATOM    894  CE  LYS A 115      24.053  43.163  66.398  0.00 34.64           C  
ATOM    895  NZ  LYS A 115      24.726  43.522  67.648  0.00 34.75           N  
ATOM    896  N   VAL A 116      17.330  42.546  64.917  1.00 14.24           N  
ATOM    897  CA  VAL A 116      15.893  42.888  64.908  1.00 14.70           C  
ATOM    898  C   VAL A 116      15.109  41.814  65.637  1.00 14.86           C  
ATOM    899  O   VAL A 116      13.892  41.977  65.844  1.00 14.67           O  
ATOM    900  CB  VAL A 116      15.352  43.114  63.500  1.00 14.13           C  
ATOM    901  CG1 VAL A 116      16.009  44.363  62.915  1.00 15.35           C  
ATOM    902  CG2 VAL A 116      15.580  41.896  62.615  1.00 13.80           C  
ATOM    903  N   ASP A 117      15.701  40.682  65.978  1.00 14.19           N  
ATOM    904  CA  ASP A 117      15.098  39.622  66.740  1.00 15.96           C  
ATOM    905  C   ASP A 117      13.858  39.057  66.068  1.00 15.10           C  
ATOM    906  O   ASP A 117      12.822  38.805  66.707  1.00 15.18           O  
ATOM    907  CB  ASP A 117      14.806  40.126  68.161  1.00 18.24           C  
ATOM    908  CG  ASP A 117      14.759  39.031  69.187  1.00 20.45           C  
ATOM    909  OD1 ASP A 117      15.371  37.957  68.994  1.00 19.71           O  
ATOM    910  OD2 ASP A 117      14.107  39.215  70.233  1.00 22.51           O  
ATOM    911  N   MET A 118      13.949  38.868  64.754  1.00 13.61           N  
ATOM    912  CA  MET A 118      12.869  38.283  63.962  1.00 13.72           C  
ATOM    913  C   MET A 118      13.482  37.723  62.679  1.00 12.46           C  
ATOM    914  O   MET A 118      14.599  38.141  62.343  1.00 11.67           O  
ATOM    915  CB  MET A 118      11.759  39.290  63.626  1.00 13.77           C  
ATOM    916  CG  MET A 118      12.211  40.327  62.591  1.00 14.65           C  
ATOM    917  SD  MET A 118      10.858  41.512  62.291  1.00 13.64           S  
ATOM    918  CE  MET A 118      10.886  42.398  63.866  1.00 12.21           C  
ATOM    919  N   PRO A 119      12.785  36.835  61.987  1.00 12.91           N  
ATOM    920  CA  PRO A 119      13.260  36.306  60.724  1.00 12.35           C  
ATOM    921  C   PRO A 119      13.279  37.383  59.658  1.00 13.63           C  
ATOM    922  O   PRO A 119      12.410  38.257  59.587  1.00 13.69           O  
ATOM    923  CB  PRO A 119      12.225  35.231  60.352  1.00 12.62           C  
ATOM    924  CG  PRO A 119      11.488  34.975  61.628  1.00 12.50           C  
ATOM    925  CD  PRO A 119      11.451  36.331  62.323  1.00 12.78           C  
ATOM    926  N   VAL A 120      14.322  37.357  58.815  1.00 12.60           N  
ATOM    927  CA  VAL A 120      14.447  38.324  57.721  1.00 12.97           C  
ATOM    928  C   VAL A 120      14.573  37.452  56.463  1.00 13.82           C  
ATOM    929  O   VAL A 120      15.549  36.702  56.330  1.00 13.60           O  
ATOM    930  CB  VAL A 120      15.649  39.249  57.903  1.00 13.34           C  
ATOM    931  CG1 VAL A 120      15.825  40.179  56.700  1.00 14.47           C  
ATOM    932  CG2 VAL A 120      15.489  40.117  59.173  1.00 13.68           C  
ATOM    933  N   ILE A 121      13.561  37.448  55.621  1.00 12.94           N  
ATOM    934  CA  ILE A 121      13.498  36.608  54.427  1.00 13.75           C  
ATOM    935  C   ILE A 121      14.442  37.137  53.364  1.00 15.17           C  
ATOM    936  O   ILE A 121      14.572  38.351  53.198  1.00 15.99           O  
ATOM    937  CB  ILE A 121      12.046  36.506  53.916  1.00 14.51           C  
ATOM    938  CG1 ILE A 121      11.131  35.932  54.999  1.00 13.98           C  
ATOM    939  CG2 ILE A 121      11.976  35.636  52.651  1.00 15.13           C  
ATOM    940  CD1 ILE A 121      11.559  34.587  55.597  1.00 14.00           C  
ATOM    941  N   PHE A 122      15.149  36.260  52.642  1.00 13.96           N  
ATOM    942  CA  PHE A 122      16.108  36.773  51.633  1.00 15.18           C  
ATOM    943  C   PHE A 122      15.427  37.004  50.299  1.00 15.87           C  
ATOM    944  O   PHE A 122      15.233  36.051  49.531  1.00 17.12           O  
ATOM    945  CB  PHE A 122      17.246  35.766  51.457  1.00 15.71           C  
ATOM    946  CG  PHE A 122      18.359  36.223  50.554  1.00 17.22           C  
ATOM    947  CD1 PHE A 122      19.046  37.400  50.787  1.00 18.33           C  
ATOM    948  CD2 PHE A 122      18.710  35.424  49.470  1.00 18.64           C  
ATOM    949  CE1 PHE A 122      20.083  37.800  49.969  1.00 18.47           C  
ATOM    950  CE2 PHE A 122      19.756  35.828  48.630  1.00 19.40           C  
ATOM    951  CZ  PHE A 122      20.425  37.001  48.878  1.00 17.48           C  
ATOM    952  N   GLY A 123      15.020  38.255  50.070  1.00 15.93           N  
ATOM    953  CA  GLY A 123      14.316  38.630  48.855  1.00 15.54           C  
ATOM    954  C   GLY A 123      15.173  39.408  47.882  1.00 15.95           C  
ATOM    955  O   GLY A 123      14.659  40.250  47.120  1.00 16.08           O  
ATOM    956  N   LEU A 124      16.476  39.150  47.834  1.00 17.38           N  
ATOM    957  CA  LEU A 124      17.351  39.871  46.923  1.00 20.49           C  
ATOM    958  C   LEU A 124      17.578  39.016  45.670  1.00 21.34           C  
ATOM    959  O   LEU A 124      18.016  37.876  45.846  1.00 22.60           O  
ATOM    960  CB  LEU A 124      18.740  39.977  47.540  1.00 22.76           C  
ATOM    961  CG  LEU A 124      19.408  41.256  47.963  1.00 26.35           C  
ATOM    962  CD1 LEU A 124      20.900  40.978  48.168  1.00 24.45           C  
ATOM    963  CD2 LEU A 124      19.262  42.372  46.925  1.00 26.35           C  
ATOM    964  N   LEU A 125      17.350  39.544  44.480  1.00 19.08           N  
ATOM    965  CA  LEU A 125      17.736  38.794  43.275  1.00 18.92           C  
ATOM    966  C   LEU A 125      19.160  39.243  42.933  1.00 18.85           C  
ATOM    967  O   LEU A 125      19.435  40.438  43.047  1.00 18.90           O  
ATOM    968  CB  LEU A 125      16.860  39.083  42.065  1.00 19.20           C  
ATOM    969  CG  LEU A 125      15.420  38.554  42.158  1.00 20.01           C  
ATOM    970  CD1 LEU A 125      14.689  38.853  40.848  1.00 20.72           C  
ATOM    971  CD2 LEU A 125      15.381  37.060  42.485  1.00 20.25           C  
ATOM    972  N   THR A 126      20.042  38.310  42.592  1.00 18.60           N  
ATOM    973  CA  THR A 126      21.434  38.665  42.268  1.00 18.11           C  
ATOM    974  C   THR A 126      21.722  37.999  40.919  1.00 18.94           C  
ATOM    975  O   THR A 126      22.225  36.901  40.832  1.00 18.88           O  
ATOM    976  CB  THR A 126      22.429  38.155  43.314  1.00 18.25           C  
ATOM    977  OG1 THR A 126      22.249  36.746  43.464  1.00 18.11           O  
ATOM    978  CG2 THR A 126      22.229  38.887  44.632  1.00 18.30           C  
ATOM    979  N   CYS A 127      21.246  38.656  39.881  1.00 20.20           N  
ATOM    980  CA  CYS A 127      21.256  38.141  38.529  1.00 20.74           C  
ATOM    981  C   CYS A 127      22.389  38.675  37.674  1.00 21.81           C  
ATOM    982  O   CYS A 127      22.907  39.777  37.872  1.00 21.15           O  
ATOM    983  CB  CYS A 127      19.885  38.535  37.917  1.00 20.55           C  
ATOM    984  SG  CYS A 127      18.520  37.566  38.607  1.00 20.95           S  
ATOM    985  N   MET A 128      22.716  37.869  36.652  1.00 25.27           N  
ATOM    986  CA  MET A 128      23.753  38.284  35.714  1.00 28.68           C  
ATOM    987  C   MET A 128      23.123  39.174  34.646  1.00 28.16           C  
ATOM    988  O   MET A 128      23.774  40.024  34.042  1.00 27.33           O  
ATOM    989  CB  MET A 128      24.430  37.055  35.083  1.00 32.59           C  
ATOM    990  CG  MET A 128      25.012  36.061  36.079  1.00 35.77           C  
ATOM    991  SD  MET A 128      26.016  36.868  37.352  1.00 42.27           S  
ATOM    992  CE  MET A 128      27.178  37.983  36.419  0.00 43.00           C  
ATOM    993  N   THR A 129      21.840  38.938  34.338  1.00 27.99           N  
ATOM    994  CA  THR A 129      21.126  39.656  33.311  1.00 27.89           C  
ATOM    995  C   THR A 129      19.712  40.049  33.722  1.00 28.18           C  
ATOM    996  O   THR A 129      19.060  39.434  34.553  1.00 28.49           O  
ATOM    997  CB  THR A 129      20.927  38.820  32.021  1.00 27.99           C  
ATOM    998  OG1 THR A 129      20.052  37.717  32.305  1.00 26.07           O  
ATOM    999  CG2 THR A 129      22.231  38.270  31.457  1.00 28.69           C  
ATOM   1000  N   GLU A 130      19.179  41.020  32.997  1.00 28.57           N  
ATOM   1001  CA  GLU A 130      17.822  41.506  33.181  1.00 29.38           C  
ATOM   1002  C   GLU A 130      16.833  40.387  32.876  1.00 29.42           C  
ATOM   1003  O   GLU A 130      15.885  40.158  33.626  1.00 27.92           O  
ATOM   1004  CB  GLU A 130      17.585  42.709  32.271  1.00 30.30           C  
ATOM   1005  CG  GLU A 130      16.253  43.403  32.516  1.00 30.52           C  
ATOM   1006  CD  GLU A 130      15.626  44.332  31.622  0.00 45.31           C  
ATOM   1007  OE1 GLU A 130      15.711  44.012  30.378  0.00 45.86           O  
ATOM   1008  OE2 GLU A 130      14.999  45.407  31.973  0.00 47.79           O  
ATOM   1009  N   GLU A 131      17.087  39.615  31.800  1.00 29.42           N  
ATOM   1010  CA  GLU A 131      16.180  38.522  31.479  1.00 29.43           C  
ATOM   1011  C   GLU A 131      16.091  37.519  32.629  1.00 27.72           C  
ATOM   1012  O   GLU A 131      15.014  36.973  32.871  1.00 26.92           O  
ATOM   1013  CB  GLU A 131      16.573  37.779  30.192  1.00 31.81           C  
ATOM   1014  CG  GLU A 131      15.502  36.762  29.799  1.00 36.22           C  
ATOM   1015  CD  GLU A 131      14.242  37.361  29.209  1.00 39.39           C  
ATOM   1016  OE1 GLU A 131      14.082  38.596  29.099  1.00 40.70           O  
ATOM   1017  OE2 GLU A 131      13.342  36.575  28.819  1.00 41.47           O  
ATOM   1018  N   GLN A 132      17.211  37.212  33.285  1.00 25.74           N  
ATOM   1019  CA  GLN A 132      17.153  36.299  34.425  1.00 25.21           C  
ATOM   1020  C   GLN A 132      16.272  36.888  35.538  1.00 24.71           C  
ATOM   1021  O   GLN A 132      15.443  36.162  36.100  1.00 23.87           O  
ATOM   1022  CB  GLN A 132      18.537  36.011  34.976  1.00 25.18           C  
ATOM   1023  CG  GLN A 132      19.388  35.099  34.091  1.00 26.78           C  
ATOM   1024  CD  GLN A 132      20.845  35.158  34.504  1.00 27.56           C  
ATOM   1025  OE1 GLN A 132      21.221  35.945  35.375  1.00 26.98           O  
ATOM   1026  NE2 GLN A 132      21.675  34.338  33.845  1.00 27.12           N  
ATOM   1027  N   ALA A 133      16.450  38.170  35.834  1.00 23.92           N  
ATOM   1028  CA  ALA A 133      15.636  38.829  36.861  1.00 23.34           C  
ATOM   1029  C   ALA A 133      14.172  38.839  36.472  1.00 23.86           C  
ATOM   1030  O   ALA A 133      13.294  38.479  37.255  1.00 21.61           O  
ATOM   1031  CB  ALA A 133      16.142  40.243  37.119  1.00 22.55           C  
ATOM   1032  N   LEU A 134      13.845  39.226  35.232  1.00 24.61           N  
ATOM   1033  CA  LEU A 134      12.457  39.168  34.769  1.00 23.56           C  
ATOM   1034  C   LEU A 134      11.853  37.797  34.968  1.00 22.79           C  
ATOM   1035  O   LEU A 134      10.716  37.651  35.422  1.00 23.05           O  
ATOM   1036  CB  LEU A 134      12.394  39.544  33.274  1.00 25.56           C  
ATOM   1037  CG  LEU A 134      12.760  40.992  32.941  1.00 26.10           C  
ATOM   1038  CD1 LEU A 134      12.947  41.188  31.430  1.00 28.38           C  
ATOM   1039  CD2 LEU A 134      11.699  41.953  33.441  1.00 26.45           C  
ATOM   1040  N   ALA A 135      12.561  36.712  34.605  1.00 21.64           N  
ATOM   1041  CA  ALA A 135      12.043  35.356  34.734  1.00 21.56           C  
ATOM   1042  C   ALA A 135      11.755  34.966  36.181  1.00 21.43           C  
ATOM   1043  O   ALA A 135      10.758  34.303  36.486  1.00 20.96           O  
ATOM   1044  CB  ALA A 135      13.047  34.371  34.115  1.00 21.98           C  
ATOM   1045  N   ARG A 136      12.635  35.389  37.084  1.00 21.52           N  
ATOM   1046  CA  ARG A 136      12.468  35.065  38.514  1.00 21.33           C  
ATOM   1047  C   ARG A 136      11.397  35.880  39.198  1.00 21.37           C  
ATOM   1048  O   ARG A 136      11.060  35.626  40.344  1.00 21.54           O  
ATOM   1049  CB  ARG A 136      13.855  35.118  39.175  1.00 21.73           C  
ATOM   1050  CG  ARG A 136      14.659  33.871  38.733  1.00 22.00           C  
ATOM   1051  CD  ARG A 136      16.161  34.106  38.842  1.00 22.67           C  
ATOM   1052  NE  ARG A 136      16.909  32.910  38.389  1.00 24.37           N  
ATOM   1053  CZ  ARG A 136      17.075  32.598  37.101  1.00 24.85           C  
ATOM   1054  NH1 ARG A 136      16.589  33.351  36.118  1.00 23.73           N  
ATOM   1055  NH2 ARG A 136      17.755  31.505  36.737  1.00 24.22           N  
ATOM   1056  N   ALA A 137      10.811  36.867  38.522  1.00 21.17           N  
ATOM   1057  CA  ALA A 137       9.690  37.650  39.017  1.00 20.74           C  
ATOM   1058  C   ALA A 137       8.431  37.238  38.255  1.00 21.80           C  
ATOM   1059  O   ALA A 137       7.362  37.824  38.418  1.00 21.80           O  
ATOM   1060  CB  ALA A 137       9.950  39.130  38.836  1.00 21.51           C  
ATOM   1061  N   GLY A 138       8.569  36.228  37.393  1.00 22.68           N  
ATOM   1062  CA  GLY A 138       7.472  35.671  36.623  1.00 23.85           C  
ATOM   1063  C   GLY A 138       6.971  36.577  35.515  1.00 25.46           C  
ATOM   1064  O   GLY A 138       5.793  36.455  35.103  1.00 26.60           O  
ATOM   1065  N   ILE A 139       7.785  37.507  35.024  1.00 25.65           N  
ATOM   1066  CA  ILE A 139       7.373  38.452  34.014  1.00 27.05           C  
ATOM   1067  C   ILE A 139       8.208  38.436  32.742  1.00 28.24           C  
ATOM   1068  O   ILE A 139       8.188  39.443  32.009  1.00 30.00           O  
ATOM   1069  CB  ILE A 139       7.280  39.905  34.534  1.00 26.87           C  
ATOM   1070  CG1 ILE A 139       8.571  40.358  35.212  1.00 26.73           C  
ATOM   1071  CG2 ILE A 139       6.097  40.063  35.494  1.00 26.74           C  
ATOM   1072  CD1 ILE A 139       8.551  41.829  35.581  1.00 26.73           C  
ATOM   1073  N   ASP A 140       8.931  37.367  32.469  1.00 30.79           N  
ATOM   1074  CA  ASP A 140       9.668  37.257  31.206  1.00 34.00           C  
ATOM   1075  C   ASP A 140       8.622  36.983  30.122  1.00 35.74           C  
ATOM   1076  O   ASP A 140       7.563  36.434  30.451  1.00 35.52           O  
ATOM   1077  CB  ASP A 140      10.684  36.137  31.250  1.00 34.24           C  
ATOM   1078  CG  ASP A 140      10.147  34.794  31.681  1.00 35.49           C  
ATOM   1079  OD1 ASP A 140       9.247  34.714  32.548  1.00 35.52           O  
ATOM   1080  OD2 ASP A 140      10.649  33.764  31.173  1.00 36.58           O  
ATOM   1081  N   GLU A 141       8.898  37.322  28.864  1.00 38.38           N  
ATOM   1082  CA  GLU A 141       7.894  37.056  27.822  1.00 40.80           C  
ATOM   1083  C   GLU A 141       7.410  35.611  27.907  1.00 41.33           C  
ATOM   1084  O   GLU A 141       6.225  35.295  28.004  1.00 41.84           O  
ATOM   1085  CB  GLU A 141       8.443  37.357  26.430  1.00 41.54           C  
ATOM   1086  CG  GLU A 141       7.471  37.336  25.327  0.00 48.67           C  
ATOM   1087  CD  GLU A 141       6.517  38.530  25.424  0.00 50.93           C  
ATOM   1088  OE1 GLU A 141       6.688  39.420  26.343  0.00 52.20           O  
ATOM   1089  OE2 GLU A 141       5.543  38.649  24.586  0.00 52.39           O  
ATOM   1090  N   ALA A 142       8.362  34.687  27.907  1.00 42.15           N  
ATOM   1091  CA  ALA A 142       8.141  33.262  27.977  1.00 41.87           C  
ATOM   1092  C   ALA A 142       7.454  32.727  29.212  1.00 42.35           C  
ATOM   1093  O   ALA A 142       6.901  31.616  29.149  1.00 42.82           O  
ATOM   1094  CB  ALA A 142       9.523  32.597  27.871  1.00 41.81           C  
ATOM   1095  N   HIS A 143       7.529  33.380  30.375  1.00 42.66           N  
ATOM   1096  CA  HIS A 143       6.951  32.813  31.602  1.00 41.46           C  
ATOM   1097  C   HIS A 143       7.619  31.462  31.874  1.00 40.46           C  
ATOM   1098  O   HIS A 143       7.047  30.431  32.214  1.00 39.43           O  
ATOM   1099  CB  HIS A 143       5.438  32.682  31.520  1.00 43.34           C  
ATOM   1100  CG  HIS A 143       4.729  34.000  31.539  1.00 44.50           C  
ATOM   1101  ND1 HIS A 143       4.474  34.680  32.708  1.00 44.43           N  
ATOM   1102  CD2 HIS A 143       4.238  34.780  30.543  1.00 45.83           C  
ATOM   1103  CE1 HIS A 143       3.814  35.760  32.429  0.00 45.86           C  
ATOM   1104  NE2 HIS A 143       3.693  35.895  31.151  1.00 46.13           N  
ATOM   1105  N   SER A 144       8.942  31.479  31.753  1.00 39.56           N  
ATOM   1106  CA  SER A 144       9.805  30.332  31.892  1.00 39.36           C  
ATOM   1107  C   SER A 144       9.856  29.753  33.294  1.00 38.72           C  
ATOM   1108  O   SER A 144      10.087  28.548  33.460  1.00 39.11           O  
ATOM   1109  CB  SER A 144      11.238  30.746  31.489  1.00 40.03           C  
ATOM   1110  OG  SER A 144      11.693  31.788  32.347  1.00 40.07           O  
ATOM   1111  N   MET A 145       9.790  30.617  34.308  1.00 37.10           N  
ATOM   1112  CA  MET A 145       9.886  30.093  35.690  1.00 36.10           C  
ATOM   1113  C   MET A 145       8.628  30.453  36.456  1.00 35.04           C  
ATOM   1114  O   MET A 145       7.525  30.135  36.013  1.00 35.04           O  
ATOM   1115  CB  MET A 145      11.173  30.615  36.322  1.00 36.12           C  
ATOM   1116  CG  MET A 145      12.426  30.132  35.616  1.00 37.09           C  
ATOM   1117  SD  MET A 145      13.946  30.953  36.118  1.00 37.16           S  
ATOM   1118  CE  MET A 145      14.183  30.151  37.703  1.00 37.17           C  
ATOM   1119  N   HIS A 146       8.748  31.110  37.601  1.00 32.58           N  
ATOM   1120  CA  HIS A 146       7.579  31.534  38.369  1.00 29.85           C  
ATOM   1121  C   HIS A 146       8.040  32.723  39.209  1.00 28.11           C  
ATOM   1122  O   HIS A 146       9.251  32.970  39.302  1.00 27.46           O  
ATOM   1123  CB  HIS A 146       7.028  30.400  39.232  1.00 31.82           C  
ATOM   1124  CG  HIS A 146       7.948  30.105  40.377  1.00 32.71           C  
ATOM   1125  ND1 HIS A 146       9.135  29.434  40.206  1.00 33.00           N  
ATOM   1126  CD2 HIS A 146       7.872  30.441  41.696  1.00 33.62           C  
ATOM   1127  CE1 HIS A 146       9.752  29.347  41.378  1.00 34.23           C  
ATOM   1128  NE2 HIS A 146       9.013  29.962  42.292  1.00 33.48           N  
ATOM   1129  N   ASN A 147       7.094  33.440  39.795  1.00 23.84           N  
ATOM   1130  CA  ASN A 147       7.447  34.599  40.612  1.00 22.70           C  
ATOM   1131  C   ASN A 147       8.001  34.161  41.965  1.00 21.91           C  
ATOM   1132  O   ASN A 147       7.284  33.655  42.813  1.00 20.99           O  
ATOM   1133  CB  ASN A 147       6.176  35.449  40.765  1.00 21.72           C  
ATOM   1134  CG  ASN A 147       6.440  36.761  41.476  1.00 21.46           C  
ATOM   1135  OD1 ASN A 147       7.562  37.029  41.915  1.00 21.82           O  
ATOM   1136  ND2 ASN A 147       5.430  37.606  41.586  1.00 21.14           N  
ATOM   1137  N   HIS A 148       9.298  34.387  42.216  1.00 22.23           N  
ATOM   1138  CA  HIS A 148       9.929  34.003  43.476  1.00 22.38           C  
ATOM   1139  C   HIS A 148       9.402  34.807  44.658  1.00 20.67           C  
ATOM   1140  O   HIS A 148       9.473  34.344  45.800  1.00 19.82           O  
ATOM   1141  CB  HIS A 148      11.458  34.145  43.403  1.00 25.07           C  
ATOM   1142  CG  HIS A 148      12.071  33.085  42.533  1.00 29.20           C  
ATOM   1143  ND1 HIS A 148      13.386  32.701  42.673  1.00 31.79           N  
ATOM   1144  CD2 HIS A 148      11.566  32.358  41.513  1.00 30.53           C  
ATOM   1145  CE1 HIS A 148      13.648  31.762  41.780  1.00 32.06           C  
ATOM   1146  NE2 HIS A 148      12.570  31.527  41.068  1.00 31.54           N  
ATOM   1147  N   GLY A 149       8.787  35.960  44.394  1.00 19.51           N  
ATOM   1148  CA  GLY A 149       8.149  36.750  45.454  1.00 18.55           C  
ATOM   1149  C   GLY A 149       7.122  35.886  46.165  1.00 18.54           C  
ATOM   1150  O   GLY A 149       6.973  36.013  47.386  1.00 18.45           O  
ATOM   1151  N   GLU A 150       6.361  35.014  45.491  1.00 18.29           N  
ATOM   1152  CA  GLU A 150       5.431  34.121  46.144  1.00 18.66           C  
ATOM   1153  C   GLU A 150       6.096  33.221  47.187  1.00 18.45           C  
ATOM   1154  O   GLU A 150       5.604  33.073  48.316  1.00 18.18           O  
ATOM   1155  CB  GLU A 150       4.723  33.184  45.123  1.00 21.13           C  
ATOM   1156  CG  GLU A 150       3.873  34.056  44.178  1.00 24.27           C  
ATOM   1157  CD  GLU A 150       3.302  33.230  43.038  1.00 28.98           C  
ATOM   1158  OE1 GLU A 150       3.486  31.989  43.023  1.00 30.83           O  
ATOM   1159  OE2 GLU A 150       2.684  33.827  42.133  1.00 30.44           O  
ATOM   1160  N   ASP A 151       7.229  32.617  46.818  1.00 18.43           N  
ATOM   1161  CA  ASP A 151       7.965  31.771  47.754  1.00 19.81           C  
ATOM   1162  C   ASP A 151       8.407  32.584  48.982  1.00 17.02           C  
ATOM   1163  O   ASP A 151       8.412  32.075  50.112  1.00 17.15           O  
ATOM   1164  CB  ASP A 151       9.255  31.231  47.111  1.00 23.45           C  
ATOM   1165  CG  ASP A 151       9.031  30.539  45.776  1.00 28.05           C  
ATOM   1166  OD1 ASP A 151       7.961  29.990  45.550  1.00 30.27           O  
ATOM   1167  OD2 ASP A 151       9.975  30.556  44.945  1.00 31.12           O  
ATOM   1168  N   TRP A 152       8.835  33.830  48.744  1.00 16.21           N  
ATOM   1169  CA  TRP A 152       9.257  34.634  49.892  1.00 16.08           C  
ATOM   1170  C   TRP A 152       8.108  34.939  50.840  1.00 15.95           C  
ATOM   1171  O   TRP A 152       8.257  34.930  52.063  1.00 14.55           O  
ATOM   1172  CB  TRP A 152       9.941  35.912  49.445  1.00 15.98           C  
ATOM   1173  CG  TRP A 152      11.050  35.687  48.448  1.00 16.14           C  
ATOM   1174  CD1 TRP A 152      11.789  34.532  48.272  1.00 16.31           C  
ATOM   1175  CD2 TRP A 152      11.538  36.642  47.522  1.00 16.06           C  
ATOM   1176  NE1 TRP A 152      12.707  34.737  47.276  1.00 16.18           N  
ATOM   1177  CE2 TRP A 152      12.568  36.014  46.793  1.00 16.75           C  
ATOM   1178  CE3 TRP A 152      11.207  37.970  47.224  1.00 15.68           C  
ATOM   1179  CZ2 TRP A 152      13.292  36.668  45.798  1.00 16.91           C  
ATOM   1180  CZ3 TRP A 152      11.916  38.629  46.233  1.00 16.67           C  
ATOM   1181  CH2 TRP A 152      12.923  37.963  45.519  1.00 16.73           C  
ATOM   1182  N   GLY A 153       6.917  35.200  50.278  1.00 15.16           N  
ATOM   1183  CA  GLY A 153       5.738  35.448  51.107  1.00 15.81           C  
ATOM   1184  C   GLY A 153       5.417  34.209  51.936  1.00 15.40           C  
ATOM   1185  O   GLY A 153       5.082  34.286  53.121  1.00 15.27           O  
ATOM   1186  N   ALA A 154       5.483  33.028  51.313  1.00 15.30           N  
ATOM   1187  CA  ALA A 154       5.224  31.791  52.036  1.00 15.46           C  
ATOM   1188  C   ALA A 154       6.238  31.594  53.154  1.00 14.91           C  
ATOM   1189  O   ALA A 154       5.891  31.233  54.284  1.00 14.93           O  
ATOM   1190  CB  ALA A 154       5.248  30.587  51.090  1.00 16.49           C  
ATOM   1191  N   ALA A 155       7.533  31.833  52.835  1.00 14.04           N  
ATOM   1192  CA  ALA A 155       8.553  31.622  53.867  1.00 14.16           C  
ATOM   1193  C   ALA A 155       8.386  32.596  55.026  1.00 14.34           C  
ATOM   1194  O   ALA A 155       8.638  32.258  56.183  1.00 14.93           O  
ATOM   1195  CB  ALA A 155       9.931  31.786  53.215  1.00 14.93           C  
ATOM   1196  N   ALA A 156       7.933  33.804  54.725  1.00 13.68           N  
ATOM   1197  CA  ALA A 156       7.744  34.808  55.774  1.00 14.42           C  
ATOM   1198  C   ALA A 156       6.708  34.348  56.780  1.00 15.31           C  
ATOM   1199  O   ALA A 156       6.896  34.372  57.997  1.00 14.59           O  
ATOM   1200  CB  ALA A 156       7.353  36.160  55.198  1.00 14.39           C  
ATOM   1201  N   VAL A 157       5.590  33.795  56.273  1.00 14.56           N  
ATOM   1202  CA  VAL A 157       4.531  33.299  57.139  1.00 15.22           C  
ATOM   1203  C   VAL A 157       5.018  32.109  57.948  1.00 14.73           C  
ATOM   1204  O   VAL A 157       4.821  32.102  59.166  1.00 14.08           O  
ATOM   1205  CB  VAL A 157       3.273  32.926  56.316  1.00 15.48           C  
ATOM   1206  CG1 VAL A 157       2.215  32.323  57.227  1.00 15.95           C  
ATOM   1207  CG2 VAL A 157       2.771  34.194  55.621  1.00 15.99           C  
ATOM   1208  N   GLU A 158       5.634  31.124  57.303  1.00 14.23           N  
ATOM   1209  CA  GLU A 158       6.139  29.970  58.027  1.00 15.73           C  
ATOM   1210  C   GLU A 158       7.138  30.356  59.111  1.00 13.91           C  
ATOM   1211  O   GLU A 158       7.075  29.915  60.248  1.00 14.45           O  
ATOM   1212  CB  GLU A 158       6.831  28.981  57.070  1.00 15.57           C  
ATOM   1213  CG  GLU A 158       7.460  27.816  57.830  1.00 17.57           C  
ATOM   1214  CD  GLU A 158       8.081  26.760  56.923  1.00 17.98           C  
ATOM   1215  OE1 GLU A 158       7.910  26.842  55.706  1.00 18.24           O  
ATOM   1216  OE2 GLU A 158       8.722  25.854  57.489  1.00 18.41           O  
ATOM   1217  N   MET A 159       8.119  31.206  58.752  1.00 13.34           N  
ATOM   1218  CA  MET A 159       9.133  31.579  59.765  1.00 13.58           C  
ATOM   1219  C   MET A 159       8.497  32.327  60.920  1.00 13.14           C  
ATOM   1220  O   MET A 159       8.887  32.131  62.078  1.00 13.76           O  
ATOM   1221  CB  MET A 159      10.269  32.383  59.112  1.00 13.08           C  
ATOM   1222  CG  MET A 159      11.079  31.521  58.109  1.00 13.05           C  
ATOM   1223  SD  MET A 159      11.854  30.072  58.810  1.00 12.40           S  
ATOM   1224  CE  MET A 159      13.116  30.809  59.848  1.00 13.43           C  
ATOM   1225  N   ALA A 160       7.561  33.243  60.673  1.00 13.91           N  
ATOM   1226  CA  ALA A 160       6.898  33.954  61.766  1.00 14.46           C  
ATOM   1227  C   ALA A 160       6.060  33.030  62.625  1.00 15.08           C  
ATOM   1228  O   ALA A 160       6.111  33.099  63.881  1.00 15.07           O  
ATOM   1229  CB  ALA A 160       6.020  35.077  61.181  1.00 13.55           C  
ATOM   1230  N   VAL A 161       5.289  32.149  61.990  1.00 15.00           N  
ATOM   1231  CA  VAL A 161       4.399  31.258  62.732  1.00 16.23           C  
ATOM   1232  C   VAL A 161       5.138  30.266  63.582  1.00 17.30           C  
ATOM   1233  O   VAL A 161       4.843  29.953  64.735  1.00 15.67           O  
ATOM   1234  CB  VAL A 161       3.379  30.576  61.781  1.00 17.68           C  
ATOM   1235  CG1 VAL A 161       2.614  29.459  62.467  1.00 19.55           C  
ATOM   1236  CG2 VAL A 161       2.397  31.637  61.272  1.00 17.95           C  
ATOM   1237  N   LYS A 162       6.191  29.695  62.992  1.00 16.31           N  
ATOM   1238  CA  LYS A 162       6.971  28.654  63.646  1.00 18.26           C  
ATOM   1239  C   LYS A 162       8.046  29.149  64.580  1.00 17.35           C  
ATOM   1240  O   LYS A 162       8.321  28.553  65.633  1.00 17.75           O  
ATOM   1241  CB  LYS A 162       7.479  27.748  62.506  1.00 20.73           C  
ATOM   1242  CG  LYS A 162       8.229  26.498  62.913  1.00 24.87           C  
ATOM   1243  CD  LYS A 162       8.819  25.844  61.641  1.00 25.10           C  
ATOM   1244  CE  LYS A 162       7.880  24.973  60.875  1.00 25.22           C  
ATOM   1245  NZ  LYS A 162       8.576  24.327  59.705  1.00 22.13           N  
ATOM   1246  N   PHE A 163       8.717  30.242  64.193  1.00 15.91           N  
ATOM   1247  CA  PHE A 163       9.852  30.705  64.954  1.00 16.02           C  
ATOM   1248  C   PHE A 163       9.817  32.183  65.344  1.00 15.63           C  
ATOM   1249  O   PHE A 163      10.824  32.684  65.861  1.00 15.79           O  
ATOM   1250  CB  PHE A 163      11.130  30.577  64.063  1.00 16.10           C  
ATOM   1251  CG  PHE A 163      11.418  29.163  63.615  1.00 16.72           C  
ATOM   1252  CD1 PHE A 163      11.422  28.845  62.267  1.00 17.15           C  
ATOM   1253  CD2 PHE A 163      11.683  28.189  64.550  1.00 17.97           C  
ATOM   1254  CE1 PHE A 163      11.721  27.545  61.859  1.00 18.15           C  
ATOM   1255  CE2 PHE A 163      11.974  26.893  64.151  1.00 18.31           C  
ATOM   1256  CZ  PHE A 163      11.981  26.581  62.804  1.00 18.17           C  
ATOM   1257  N   GLY A 164       8.700  32.862  65.088  1.00 15.28           N  
ATOM   1258  CA  GLY A 164       8.697  34.308  65.410  1.00 15.17           C  
ATOM   1259  C   GLY A 164       8.849  34.524  66.911  1.00 15.44           C  
ATOM   1260  O   GLY A 164       8.647  33.655  67.757  1.00 16.31           O  
ATOM   1261  N   LYS A 165       9.112  35.756  67.295  1.00 14.38           N  
ATOM   1262  CA  LYS A 165       9.224  36.169  68.698  1.00 17.47           C  
ATOM   1263  C   LYS A 165       8.016  35.767  69.536  1.00 18.16           C  
ATOM   1264  O   LYS A 165       8.160  35.324  70.686  1.00 17.99           O  
ATOM   1265  CB  LYS A 165       9.350  37.703  68.656  1.00 18.57           C  
ATOM   1266  CG  LYS A 165       9.546  38.340  70.040  1.00 23.47           C  
ATOM   1267  CD  LYS A 165      10.923  37.962  70.539  1.00 25.85           C  
ATOM   1268  CE  LYS A 165      11.340  38.687  71.808  1.00 29.21           C  
ATOM   1269  NZ  LYS A 165      12.684  38.169  72.255  1.00 31.75           N  
ATOM   1270  N   ASN A 166       6.818  35.825  68.962  1.00 18.49           N  
ATOM   1271  CA  ASN A 166       5.614  35.459  69.709  1.00 21.33           C  
ATOM   1272  C   ASN A 166       5.149  34.038  69.492  1.00 22.65           C  
ATOM   1273  O   ASN A 166       4.085  33.657  70.018  1.00 21.86           O  
ATOM   1274  CB  ASN A 166       4.466  36.402  69.272  1.00 24.05           C  
ATOM   1275  CG  ASN A 166       4.783  37.845  69.613  1.00 26.53           C  
ATOM   1276  OD1 ASN A 166       5.421  38.090  70.631  1.00 27.46           O  
ATOM   1277  ND2 ASN A 166       4.371  38.780  68.768  1.00 28.55           N  
ATOM   1278  N   ALA A 167       5.923  33.194  68.803  1.00 20.46           N  
ATOM   1279  CA  ALA A 167       5.484  31.836  68.538  1.00 22.09           C  
ATOM   1280  C   ALA A 167       5.537  30.941  69.765  1.00 24.22           C  
ATOM   1281  O   ALA A 167       4.787  29.964  69.818  1.00 25.14           O  
ATOM   1282  CB  ALA A 167       6.326  31.228  67.410  1.00 21.27           C  
ATOM   1283  N   PHE A 168       6.439  31.197  70.689  1.00 23.77           N  
ATOM   1284  CA  PHE A 168       6.546  30.354  71.873  1.00 26.61           C  
ATOM   1285  C   PHE A 168       7.259  31.136  72.963  1.00 28.50           C  
ATOM   1286  O   PHE A 168       7.289  30.646  74.115  1.00 30.49           O  
ATOM   1287  CB  PHE A 168       7.287  29.032  71.582  1.00 24.86           C  
ATOM   1288  CG  PHE A 168       8.618  29.207  70.903  1.00 22.58           C  
ATOM   1289  CD1 PHE A 168       9.755  29.481  71.634  1.00 22.17           C  
ATOM   1290  CD2 PHE A 168       8.713  29.050  69.528  1.00 22.20           C  
ATOM   1291  CE1 PHE A 168      10.976  29.646  71.004  1.00 21.45           C  
ATOM   1292  CE2 PHE A 168       9.935  29.221  68.889  1.00 21.94           C  
ATOM   1293  CZ  PHE A 168      11.054  29.501  69.638  1.00 20.69           C  
ATOM   1294  OXT PHE A 168       7.847  32.181  72.622  1.00 29.46           O  
TER    1295      PHE A 168                                                      
END
MOLECULE T0487_317_466.pdb
ATOM   2444  N   SER   317      10.299   6.901  51.930  1.00 72.05           N  
ATOM   2445  CA  SER   317       8.876   7.205  52.027  1.00 73.18           C  
ATOM   2446  C   SER   317       8.623   8.710  51.941  1.00 73.42           C  
ATOM   2447  O   SER   317       9.277   9.512  52.608  1.00 72.85           O  
ATOM   2448  CB  SER   317       8.270   6.636  53.328  1.00 72.42           C  
ATOM   2449  OG  SER   317       8.847   7.196  54.491  1.00 72.42           O  
ATOM   2450  N   ILE   318       7.674   9.068  51.083  1.00 75.17           N  
ATOM   2451  CA  ILE   318       7.266  10.447  50.853  1.00 76.64           C  
ATOM   2452  C   ILE   318       6.534  10.963  52.093  1.00 76.34           C  
ATOM   2453  O   ILE   318       5.683  10.281  52.656  1.00 76.86           O  
ATOM   2454  CB  ILE   318       6.352  10.509  49.611  1.00 78.09           C  
ATOM   2455  CG1 ILE   318       7.160  10.092  48.375  1.00 79.57           C  
ATOM   2456  CG2 ILE   318       5.768  11.897  49.445  1.00 76.73           C  
ATOM   2457  CD1 ILE   318       6.323   9.856  47.120  1.00 81.63           C  
ATOM   2458  N   PRO   319       6.865  12.183  52.536  1.00 76.40           N  
ATOM   2459  CA  PRO   319       6.267  12.823  53.720  1.00 76.49           C  
ATOM   2460  C   PRO   319       4.781  13.233  53.662  1.00 75.57           C  
ATOM   2461  O   PRO   319       4.320  13.839  52.690  1.00 74.41           O  
ATOM   2462  CB  PRO   319       7.186  14.023  53.949  1.00 75.91           C  
ATOM   2463  CG  PRO   319       7.553  14.418  52.548  1.00 75.48           C  
ATOM   2464  CD  PRO   319       7.837  13.082  51.885  1.00 76.26           C  
ATOM   2465  N   LYS   320       4.042  12.891  54.714  1.00 75.02           N  
ATOM   2466  CA  LYS   320       2.638  13.259  54.798  1.00 74.69           C  
ATOM   2467  C   LYS   320       2.621  14.736  55.159  1.00 74.67           C  
ATOM   2468  O   LYS   320       2.709  15.105  56.328  1.00 74.28           O  
ATOM   2469  CB  LYS   320       1.932  12.449  55.874  1.00 73.82           C  
ATOM   2470  N   LEU   321       2.544  15.569  54.132  1.00 75.17           N  
ATOM   2471  CA  LEU   321       2.518  17.013  54.281  1.00 76.56           C  
ATOM   2472  C   LEU   321       1.089  17.463  54.459  1.00 78.23           C  
ATOM   2473  O   LEU   321       0.190  16.965  53.781  1.00 79.23           O  
ATOM   2474  CB  LEU   321       3.052  17.688  53.022  1.00 75.87           C  
ATOM   2475  CG  LEU   321       4.509  18.104  52.880  1.00 76.18           C  
ATOM   2476  CD1 LEU   321       5.429  16.953  53.216  1.00 76.87           C  
ATOM   2477  CD2 LEU   321       4.735  18.580  51.453  1.00 75.72           C  
ATOM   2478  N   MET   322       0.866  18.408  55.358  1.00 79.65           N  
ATOM   2479  CA  MET   322      -0.482  18.908  55.537  1.00 81.28           C  
ATOM   2480  C   MET   322      -0.584  20.268  56.194  1.00 78.82           C  
ATOM   2481  O   MET   322      -0.027  20.503  57.261  1.00 76.72           O  
ATOM   2482  CB  MET   322      -1.334  17.905  56.308  1.00 85.67           C  
ATOM   2483  CG  MET   322      -0.895  17.647  57.725  1.00 90.88           C  
ATOM   2484  SD  MET   322      -2.240  16.800  58.586  1.00 98.69           S  
ATOM   2485  CE  MET   322      -2.381  15.260  57.570  1.00 96.37           C  
ATOM   2486  N   GLY   323      -1.295  21.159  55.514  1.00 77.51           N  
ATOM   2487  CA  GLY   323      -1.525  22.499  56.020  1.00 77.01           C  
ATOM   2488  C   GLY   323      -2.858  22.439  56.735  1.00 75.76           C  
ATOM   2489  O   GLY   323      -3.016  21.619  57.629  1.00 74.22           O  
ATOM   2490  N   ARG   324      -3.817  23.278  56.344  1.00 76.29           N  
ATOM   2491  CA  ARG   324      -5.133  23.244  56.970  1.00 76.56           C  
ATOM   2492  C   ARG   324      -5.740  21.866  56.714  1.00 77.94           C  
ATOM   2493  O   ARG   324      -6.434  21.318  57.561  1.00 77.88           O  
ATOM   2494  CB  ARG   324      -6.037  24.331  56.420  1.00 75.07           C  
ATOM   2495  CG  ARG   324      -7.306  24.476  57.209  1.00 72.49           C  
ATOM   2496  CD  ARG   324      -7.929  25.815  56.969  1.00 71.41           C  
ATOM   2497  NE  ARG   324      -9.012  26.048  57.905  1.00 69.72           N  
ATOM   2498  CZ  ARG   324      -9.626  27.212  58.060  1.00 69.49           C  
ATOM   2499  NH1 ARG   324      -9.266  28.264  57.336  1.00 68.09           N  
ATOM   2500  NH2 ARG   324     -10.592  27.323  58.956  1.00 69.88           N  
ATOM   2501  N   ARG   325      -5.486  21.307  55.536  1.00 80.31           N  
ATOM   2502  CA  ARG   325      -5.921  19.952  55.201  1.00 83.03           C  
ATOM   2503  C   ARG   325      -4.787  19.299  54.425  1.00 83.42           C  
ATOM   2504  O   ARG   325      -3.901  19.997  53.932  1.00 83.67           O  
ATOM   2505  CB  ARG   325      -7.200  19.946  54.350  1.00 84.59           C  
ATOM   2506  CG  ARG   325      -7.142  20.755  53.100  1.00 85.86           C  
ATOM   2507  CD  ARG   325      -8.465  20.554  52.422  1.00 87.95           C  
ATOM   2508  NE  ARG   325      -8.730  21.537  51.397  1.00 91.35           N  
ATOM   2509  CZ  ARG   325      -8.532  21.361  50.099  1.00 93.28           C  
ATOM   2510  NH1 ARG   325      -8.052  20.208  49.637  1.00 94.64           N  
ATOM   2511  NH2 ARG   325      -8.831  22.360  49.268  1.00 94.28           N  
ATOM   2512  N   ALA   326      -4.820  17.968  54.319  1.00 83.71           N  
ATOM   2513  CA  ALA   326      -3.778  17.239  53.581  1.00 83.29           C  
ATOM   2514  C   ALA   326      -3.311  17.993  52.313  1.00 82.66           C  
ATOM   2515  O   ALA   326      -4.100  18.666  51.647  1.00 81.68           O  
ATOM   2516  CB  ALA   326      -4.252  15.841  53.207  1.00 83.45           C  
ATOM   2517  N   VAL   327      -2.027  17.867  51.980  1.00 82.72           N  
ATOM   2518  CA  VAL   327      -1.460  18.556  50.822  1.00 83.20           C  
ATOM   2519  C   VAL   327      -0.366  17.737  50.128  1.00 83.72           C  
ATOM   2520  O   VAL   327       0.341  16.953  50.764  1.00 83.40           O  
ATOM   2521  CB  VAL   327      -0.872  19.922  51.258  1.00 83.36           C  
ATOM   2522  CG1 VAL   327      -0.036  20.521  50.156  1.00 83.27           C  
ATOM   2523  CG2 VAL   327      -1.994  20.873  51.620  1.00 84.19           C  
ATOM   2524  N   SER   328      -0.233  17.929  48.821  1.00 83.97           N  
ATOM   2525  CA  SER   328       0.771  17.228  48.045  1.00 84.91           C  
ATOM   2526  C   SER   328       2.097  17.981  48.107  1.00 85.65           C  
ATOM   2527  O   SER   328       3.171  17.402  47.935  1.00 85.53           O  
ATOM   2528  CB  SER   328       0.301  17.095  46.599  1.00 84.91           C  
ATOM   2529  OG  SER   328       1.401  17.009  45.710  1.00 86.91           O  
ATOM   2530  N   LYS   329       2.023  19.283  48.347  1.00 86.24           N  
ATOM   2531  CA  LYS   329       3.237  20.063  48.446  1.00 86.83           C  
ATOM   2532  C   LYS   329       3.124  21.362  49.205  1.00 86.35           C  
ATOM   2533  O   LYS   329       2.105  22.052  49.174  1.00 86.11           O  
ATOM   2534  CB  LYS   329       3.810  20.353  47.086  1.00 87.59           C  
ATOM   2535  CG  LYS   329       3.021  19.841  45.927  1.00 89.31           C  
ATOM   2536  CD  LYS   329       2.947  20.916  44.871  1.00 90.93           C  
ATOM   2537  CE  LYS   329       3.957  22.034  45.133  1.00 90.94           C  
ATOM   2538  NZ  LYS   329       5.330  21.519  45.427  1.00 92.30           N  
ATOM   2539  N   PRO   330       4.220  21.745  49.855  1.00 85.48           N  
ATOM   2540  CA  PRO   330       4.249  22.967  50.641  1.00 84.14           C  
ATOM   2541  C   PRO   330       3.553  24.168  50.022  1.00 82.55           C  
ATOM   2542  O   PRO   330       2.716  24.777  50.677  1.00 82.62           O  
ATOM   2543  CB  PRO   330       5.738  23.175  50.875  1.00 84.95           C  
ATOM   2544  CG  PRO   330       6.245  21.754  50.946  1.00 85.65           C  
ATOM   2545  CD  PRO   330       5.576  21.184  49.732  1.00 85.80           C  
ATOM   2546  N   ALA   331       3.852  24.505  48.772  1.00 80.28           N  
ATOM   2547  CA  ALA   331       3.209  25.674  48.183  1.00 78.76           C  
ATOM   2548  C   ALA   331       1.684  25.571  48.081  1.00 78.45           C  
ATOM   2549  O   ALA   331       0.999  26.580  47.873  1.00 78.42           O  
ATOM   2550  CB  ALA   331       3.800  25.963  46.829  1.00 78.23           C  
ATOM   2551  N   ASP   332       1.146  24.365  48.242  1.00 77.36           N  
ATOM   2552  CA  ASP   332      -0.298  24.186  48.148  1.00 75.44           C  
ATOM   2553  C   ASP   332      -1.019  24.803  49.328  1.00 74.34           C  
ATOM   2554  O   ASP   332      -2.213  25.116  49.243  1.00 74.41           O  
ATOM   2555  CB  ASP   332      -0.653  22.702  48.034  1.00 74.57           C  
ATOM   2556  CG  ASP   332      -0.469  22.162  46.622  1.00 75.05           C  
ATOM   2557  OD1 ASP   332      -0.159  22.970  45.707  1.00 73.23           O  
ATOM   2558  OD2 ASP   332      -0.645  20.933  46.431  1.00 73.69           O  
ATOM   2559  N   ALA   333      -0.289  24.983  50.424  1.00 72.21           N  
ATOM   2560  CA  ALA   333      -0.862  25.572  51.621  1.00 71.76           C  
ATOM   2561  C   ALA   333      -1.219  27.033  51.378  1.00 70.41           C  
ATOM   2562  O   ALA   333      -2.051  27.615  52.076  1.00 69.75           O  
ATOM   2563  CB  ALA   333       0.114  25.461  52.762  1.00 73.24           C  
ATOM   2564  N   LEU   334      -0.576  27.618  50.379  1.00 68.45           N  
ATOM   2565  CA  LEU   334      -0.824  28.996  50.024  1.00 67.50           C  
ATOM   2566  C   LEU   334      -2.237  29.187  49.540  1.00 67.37           C  
ATOM   2567  O   LEU   334      -2.750  30.298  49.530  1.00 69.17           O  
ATOM   2568  CB  LEU   334       0.107  29.427  48.896  1.00 66.53           C  
ATOM   2569  CG  LEU   334       1.557  29.702  49.266  1.00 65.00           C  
ATOM   2570  CD1 LEU   334       2.364  29.994  48.013  1.00 61.76           C  
ATOM   2571  CD2 LEU   334       1.586  30.876  50.223  1.00 64.01           C  
ATOM   2572  N   ARG   335      -2.875  28.107  49.124  1.00 66.58           N  
ATOM   2573  CA  ARG   335      -4.210  28.243  48.588  1.00 64.78           C  
ATOM   2574  C   ARG   335      -5.225  27.398  49.319  1.00 64.81           C  
ATOM   2575  O   ARG   335      -6.430  27.566  49.159  1.00 64.78           O  
ATOM   2576  CB  ARG   335      -4.192  27.905  47.128  1.00 62.96           C  
ATOM   2577  N   VAL   336      -4.737  26.477  50.124  1.00 64.46           N  
ATOM   2578  CA  VAL   336      -5.622  25.653  50.891  1.00 64.79           C  
ATOM   2579  C   VAL   336      -5.602  26.124  52.346  1.00 66.07           C  
ATOM   2580  O   VAL   336      -6.460  25.745  53.143  1.00 66.01           O  
ATOM   2581  CB  VAL   336      -5.197  24.194  50.775  1.00 65.47           C  
ATOM   2582  CG1 VAL   336      -5.638  23.411  52.002  1.00 66.52           C  
ATOM   2583  CG2 VAL   336      -5.799  23.604  49.519  1.00 64.80           C  
ATOM   2584  N   GLY   337      -4.621  26.961  52.686  1.00 66.62           N  
ATOM   2585  CA  GLY   337      -4.520  27.473  54.044  1.00 65.36           C  
ATOM   2586  C   GLY   337      -3.439  26.816  54.888  1.00 64.29           C  
ATOM   2587  O   GLY   337      -3.198  25.612  54.786  1.00 64.43           O  
ATOM   2588  N   PHE   338      -2.809  27.604  55.749  1.00 62.48           N  
ATOM   2589  CA  PHE   338      -1.731  27.112  56.587  1.00 61.70           C  
ATOM   2590  C   PHE   338      -2.143  26.124  57.659  1.00 62.63           C  
ATOM   2591  O   PHE   338      -3.282  26.112  58.110  1.00 62.38           O  
ATOM   2592  CB  PHE   338      -1.028  28.284  57.237  1.00 60.40           C  
ATOM   2593  CG  PHE   338      -0.640  29.349  56.267  1.00 60.55           C  
ATOM   2594  CD1 PHE   338      -0.650  30.684  56.638  1.00 59.19           C  
ATOM   2595  CD2 PHE   338      -0.289  29.022  54.968  1.00 59.51           C  
ATOM   2596  CE1 PHE   338      -0.324  31.667  55.727  1.00 58.74           C  
ATOM   2597  CE2 PHE   338       0.040  30.005  54.056  1.00 58.01           C  
ATOM   2598  CZ  PHE   338       0.020  31.324  54.433  1.00 57.93           C  
ATOM   2599  N   TYR   339      -1.181  25.300  58.064  1.00 62.84           N  
ATOM   2600  CA  TYR   339      -1.387  24.304  59.103  1.00 62.87           C  
ATOM   2601  C   TYR   339      -1.874  24.943  60.403  1.00 63.24           C  
ATOM   2602  O   TYR   339      -2.826  24.471  61.006  1.00 62.89           O  
ATOM   2603  CB  TYR   339      -0.087  23.560  59.377  1.00 61.85           C  
ATOM   2604  CG  TYR   339      -0.212  22.537  60.464  1.00 60.92           C  
ATOM   2605  CD1 TYR   339      -0.963  21.392  60.270  1.00 61.61           C  
ATOM   2606  CD2 TYR   339       0.411  22.719  61.698  1.00 62.51           C  
ATOM   2607  CE1 TYR   339      -1.102  20.444  61.275  1.00 63.04           C  
ATOM   2608  CE2 TYR   339       0.283  21.778  62.712  1.00 62.88           C  
ATOM   2609  CZ  TYR   339      -0.481  20.642  62.489  1.00 63.39           C  
ATOM   2610  OH  TYR   339      -0.652  19.706  63.480  1.00 66.50           O  
ATOM   2611  N   ARG   340      -1.197  25.997  60.845  1.00 64.30           N  
ATOM   2612  CA  ARG   340      -1.583  26.685  62.071  1.00 66.36           C  
ATOM   2613  C   ARG   340      -1.273  28.167  61.950  1.00 66.52           C  
ATOM   2614  O   ARG   340      -0.112  28.559  62.007  1.00 67.27           O  
ATOM   2615  CB  ARG   340      -0.845  26.126  63.287  1.00 66.95           C  
ATOM   2616  CG  ARG   340      -1.298  26.826  64.529  1.00 71.43           C  
ATOM   2617  CD  ARG   340      -0.500  26.520  65.760  1.00 76.04           C  
ATOM   2618  NE  ARG   340      -0.982  27.383  66.835  1.00 81.26           N  
ATOM   2619  CZ  ARG   340      -0.518  27.372  68.079  1.00 83.99           C  
ATOM   2620  NH1 ARG   340       0.455  26.537  68.425  1.00 85.05           N  
ATOM   2621  NH2 ARG   340      -1.035  28.194  68.981  1.00 85.76           N  
ATOM   2622  N   ALA   341      -2.315  28.989  61.819  1.00 66.67           N  
ATOM   2623  CA  ALA   341      -2.146  30.433  61.644  1.00 65.57           C  
ATOM   2624  C   ALA   341      -2.135  31.319  62.895  1.00 65.62           C  
ATOM   2625  O   ALA   341      -2.280  30.852  64.032  1.00 65.57           O  
ATOM   2626  CB  ALA   341      -3.178  30.947  60.657  1.00 65.25           C  
ATOM   2627  N   GLN   342      -1.968  32.616  62.659  1.00 65.20           N  
ATOM   2628  CA  GLN   342      -1.876  33.610  63.722  1.00 64.89           C  
ATOM   2629  C   GLN   342      -1.941  34.975  63.068  1.00 63.30           C  
ATOM   2630  O   GLN   342      -1.803  35.091  61.853  1.00 61.88           O  
ATOM   2631  CB  GLN   342      -0.521  33.481  64.428  1.00 67.97           C  
ATOM   2632  CG  GLN   342       0.647  33.354  63.433  1.00 70.81           C  
ATOM   2633  CD  GLN   342       1.999  33.825  63.968  1.00 74.50           C  
ATOM   2634  OE1 GLN   342       2.528  33.286  64.954  1.00 76.38           O  
ATOM   2635  NE2 GLN   342       2.574  34.834  63.302  1.00 74.60           N  
ATOM   2636  N   GLU   343      -2.148  36.012  63.872  1.00 62.50           N  
ATOM   2637  CA  GLU   343      -2.179  37.373  63.339  1.00 61.34           C  
ATOM   2638  C   GLU   343      -0.776  37.547  62.772  1.00 59.29           C  
ATOM   2639  O   GLU   343       0.200  37.224  63.437  1.00 58.93           O  
ATOM   2640  CB  GLU   343      -2.417  38.366  64.471  1.00 62.57           C  
ATOM   2641  CG  GLU   343      -2.841  39.735  64.019  1.00 64.18           C  
ATOM   2642  CD  GLU   343      -3.261  40.597  65.192  1.00 65.96           C  
ATOM   2643  OE1 GLU   343      -3.604  40.012  66.248  1.00 66.64           O  
ATOM   2644  OE2 GLU   343      -3.265  41.847  65.055  1.00 66.30           O  
ATOM   2645  N   THR   344      -0.664  38.051  61.554  1.00 56.61           N  
ATOM   2646  CA  THR   344       0.648  38.177  60.944  1.00 53.90           C  
ATOM   2647  C   THR   344       0.938  39.539  60.334  1.00 53.83           C  
ATOM   2648  O   THR   344       0.088  40.109  59.640  1.00 52.77           O  
ATOM   2649  CB  THR   344       0.820  37.085  59.857  1.00 52.39           C  
ATOM   2650  OG1 THR   344       0.655  35.792  60.449  1.00 51.47           O  
ATOM   2651  CG2 THR   344       2.183  37.162  59.218  1.00 52.21           C  
ATOM   2652  N   ALA   345       2.138  40.060  60.607  1.00 53.69           N  
ATOM   2653  CA  ALA   345       2.558  41.347  60.049  1.00 54.53           C  
ATOM   2654  C   ALA   345       3.881  41.194  59.246  1.00 55.31           C  
ATOM   2655  O   ALA   345       4.909  40.764  59.771  1.00 55.22           O  
ATOM   2656  CB  ALA   345       2.707  42.386  61.165  1.00 50.73           C  
ATOM   2657  N   LEU   346       3.833  41.534  57.966  1.00 54.57           N  
ATOM   2658  CA  LEU   346       4.991  41.428  57.106  1.00 54.74           C  
ATOM   2659  C   LEU   346       5.260  42.771  56.501  1.00 56.30           C  
ATOM   2660  O   LEU   346       4.344  43.482  56.115  1.00 55.24           O  
ATOM   2661  CB  LEU   346       4.733  40.452  55.962  1.00 54.66           C  
ATOM   2662  CG  LEU   346       3.997  39.151  56.277  1.00 54.58           C  
ATOM   2663  CD1 LEU   346       3.827  38.410  54.973  1.00 54.37           C  
ATOM   2664  CD2 LEU   346       4.756  38.307  57.298  1.00 52.86           C  
ATOM   2665  N   ALA   347       6.532  43.120  56.414  1.00 60.46           N  
ATOM   2666  CA  ALA   347       6.919  44.376  55.812  1.00 63.30           C  
ATOM   2667  C   ALA   347       7.773  44.004  54.626  1.00 65.99           C  
ATOM   2668  O   ALA   347       8.550  43.055  54.685  1.00 66.09           O  
ATOM   2669  CB  ALA   347       7.712  45.204  56.785  1.00 62.72           C  
ATOM   2670  N   LEU   348       7.605  44.733  53.537  1.00 69.75           N  
ATOM   2671  CA  LEU   348       8.388  44.493  52.345  1.00 73.27           C  
ATOM   2672  C   LEU   348       9.425  45.598  52.249  1.00 76.28           C  
ATOM   2673  O   LEU   348       9.079  46.774  52.340  1.00 77.09           O  
ATOM   2674  CB  LEU   348       7.488  44.501  51.105  1.00 72.63           C  
ATOM   2675  CG  LEU   348       8.164  44.752  49.756  1.00 72.07           C  
ATOM   2676  CD1 LEU   348       7.439  44.008  48.661  1.00 72.10           C  
ATOM   2677  CD2 LEU   348       8.178  46.255  49.469  1.00 73.08           C  
ATOM   2678  N   LEU   349      10.692  45.211  52.089  1.00 80.36           N  
ATOM   2679  CA  LEU   349      11.800  46.161  51.948  1.00 84.04           C  
ATOM   2680  C   LEU   349      12.382  45.977  50.559  1.00 86.93           C  
ATOM   2681  O   LEU   349      13.096  45.008  50.253  1.00 87.77           O  
ATOM   2682  CB  LEU   349      12.885  45.930  52.997  1.00 82.81           C  
ATOM   2683  CG  LEU   349      13.916  47.051  53.179  1.00 81.98           C  
ATOM   2684  CD1 LEU   349      14.826  46.645  54.316  1.00 82.06           C  
ATOM   2685  CD2 LEU   349      14.735  47.285  51.920  1.00 81.21           C  
ATOM   2686  N   ARG   350      12.050  46.955  49.744  1.00 90.06           N  
ATOM   2687  CA  ARG   350      12.362  47.071  48.349  1.00 93.96           C  
ATOM   2688  C   ARG   350      13.733  47.732  48.103  1.00 95.24           C  
ATOM   2689  O   ARG   350      13.850  48.951  48.188  1.00 95.36           O  
ATOM   2690  CB  ARG   350      11.304  48.000  47.798  1.00 96.66           C  
ATOM   2691  CG  ARG   350      11.495  49.406  48.486  1.00101.76           C  
ATOM   2692  CD  ARG   350      10.590  49.798  49.693  1.00103.10           C  
ATOM   2693  NE  ARG   350       9.486  50.645  49.232  1.00105.61           N  
ATOM   2694  CZ  ARG   350       9.581  51.934  48.897  1.00106.47           C  
ATOM   2695  NH1 ARG   350      10.744  52.556  48.989  1.00106.98           N  
ATOM   2696  NH2 ARG   350       8.518  52.596  48.422  1.00106.24           N  
ATOM   2697  N   LEU   351      14.772  46.986  47.781  1.00 96.20           N  
ATOM   2698  CA  LEU   351      16.052  47.640  47.574  1.00 97.27           C  
ATOM   2699  C   LEU   351      16.377  47.802  46.092  1.00 98.60           C  
ATOM   2700  O   LEU   351      17.488  48.177  45.718  1.00 99.70           O  
ATOM   2701  CB  LEU   351      17.128  46.840  48.280  1.00 96.71           C  
ATOM   2702  CG  LEU   351      17.973  47.559  49.313  1.00 96.99           C  
ATOM   2703  CD1 LEU   351      18.417  46.551  50.364  1.00 95.95           C  
ATOM   2704  CD2 LEU   351      19.154  48.220  48.605  1.00 97.39           C  
ATOM   2705  N   ASP   352      15.377  47.541  45.256  1.00 99.78           N  
ATOM   2706  CA  ASP   352      15.518  47.618  43.820  1.00100.88           C  
ATOM   2707  C   ASP   352      15.245  48.992  43.210  1.00101.16           C  
ATOM   2708  O   ASP   352      16.144  49.594  42.620  1.00101.17           O  
ATOM   2709  CB  ASP   352      14.631  46.551  43.149  1.00101.28           C  
ATOM   2710  N   GLY   353      14.038  49.521  43.346  1.00101.29           N  
ATOM   2711  CA  GLY   353      13.770  50.777  42.704  1.00101.77           C  
ATOM   2712  C   GLY   353      12.365  51.307  42.835  1.00103.52           C  
ATOM   2713  O   GLY   353      12.059  52.375  42.223  1.00104.04           O  
ATOM   2714  N   ALA   354      11.433  50.548  43.432  1.00104.23           N  
ATOM   2715  CA  ALA   354      10.122  51.237  43.436  1.00105.23           C  
ATOM   2716  C   ALA   354       9.317  51.465  44.684  1.00105.23           C  
ATOM   2717  O   ALA   354       9.797  51.996  45.764  1.00106.68           O  
ATOM   2718  CB  ALA   354       9.247  50.850  42.267  1.00104.97           C  
ATOM   2719  N   GLN   355       8.039  51.034  44.588  1.00105.18           N  
ATOM   2720  CA  GLN   355       7.230  51.266  45.690  1.00103.76           C  
ATOM   2721  C   GLN   355       6.644  50.033  46.286  1.00102.50           C  
ATOM   2722  O   GLN   355       7.300  49.476  47.191  1.00104.04           O  
ATOM   2723  CB  GLN   355       6.271  52.454  45.430  1.00102.82           C  
ATOM   2724  N   GLY   356       5.533  49.482  45.854  1.00 99.31           N  
ATOM   2725  CA  GLY   356       5.135  48.337  46.613  1.00 94.67           C  
ATOM   2726  C   GLY   356       5.205  46.878  46.347  1.00 91.77           C  
ATOM   2727  O   GLY   356       6.062  46.223  45.659  1.00 92.95           O  
ATOM   2728  N   TRP   357       4.295  46.331  47.110  1.00 88.45           N  
ATOM   2729  CA  TRP   357       4.070  44.946  47.004  1.00 84.96           C  
ATOM   2730  C   TRP   357       3.775  44.540  45.507  1.00 84.34           C  
ATOM   2731  O   TRP   357       2.870  45.085  44.898  1.00 83.43           O  
ATOM   2732  CB  TRP   357       2.898  44.641  47.927  1.00 80.64           C  
ATOM   2733  CG  TRP   357       3.415  44.501  49.266  1.00 75.95           C  
ATOM   2734  CD1 TRP   357       3.373  45.378  50.319  1.00 75.26           C  
ATOM   2735  CD2 TRP   357       3.918  43.303  49.749  1.00 73.93           C  
ATOM   2736  NE1 TRP   357       3.801  44.740  51.462  1.00 73.89           N  
ATOM   2737  CE2 TRP   357       4.146  43.456  51.128  1.00 72.85           C  
ATOM   2738  CE3 TRP   357       4.192  42.081  49.138  1.00 73.29           C  
ATOM   2739  CZ2 TRP   357       4.634  42.417  51.909  1.00 71.22           C  
ATOM   2740  CZ3 TRP   357       4.669  41.054  49.898  1.00 73.42           C  
ATOM   2741  CH2 TRP   357       4.888  41.220  51.278  1.00 71.91           C  
ATOM   2742  N   PRO   358       4.555  43.599  44.879  1.00 83.85           N  
ATOM   2743  CA  PRO   358       4.178  43.251  43.483  1.00 83.32           C  
ATOM   2744  C   PRO   358       2.817  42.550  43.464  1.00 82.44           C  
ATOM   2745  O   PRO   358       2.635  41.525  44.114  1.00 80.88           O  
ATOM   2746  CB  PRO   358       5.290  42.288  43.023  1.00 83.67           C  
ATOM   2747  CG  PRO   358       6.463  42.786  43.779  1.00 83.65           C  
ATOM   2748  CD  PRO   358       5.885  43.023  45.172  1.00 83.90           C  
ATOM   2749  N   GLU   359       1.876  43.137  42.730  1.00 81.62           N  
ATOM   2750  CA  GLU   359       0.517  42.624  42.624  1.00 81.43           C  
ATOM   2751  C   GLU   359       0.384  41.119  42.848  1.00 79.12           C  
ATOM   2752  O   GLU   359      -0.442  40.695  43.647  1.00 78.89           O  
ATOM   2753  CB  GLU   359      -0.084  42.987  41.258  1.00 83.94           C  
ATOM   2754  CG  GLU   359      -1.484  43.618  41.319  1.00 88.17           C  
ATOM   2755  CD  GLU   359      -1.458  45.142  41.524  1.00 91.26           C  
ATOM   2756  OE1 GLU   359      -0.634  45.638  42.329  1.00 92.64           O  
ATOM   2757  OE2 GLU   359      -2.275  45.846  40.886  1.00 91.99           O  
ATOM   2758  N   PHE   360       1.188  40.307  42.163  1.00 76.68           N  
ATOM   2759  CA  PHE   360       1.048  38.869  42.349  1.00 75.12           C  
ATOM   2760  C   PHE   360       1.481  38.335  43.714  1.00 73.72           C  
ATOM   2761  O   PHE   360       1.085  37.231  44.102  1.00 73.90           O  
ATOM   2762  CB  PHE   360       1.722  38.075  41.212  1.00 74.23           C  
ATOM   2763  CG  PHE   360       3.163  38.382  41.007  1.00 74.14           C  
ATOM   2764  CD1 PHE   360       3.551  39.472  40.242  1.00 76.28           C  
ATOM   2765  CD2 PHE   360       4.141  37.555  41.540  1.00 74.67           C  
ATOM   2766  CE1 PHE   360       4.912  39.735  40.004  1.00 76.47           C  
ATOM   2767  CE2 PHE   360       5.493  37.805  41.314  1.00 74.78           C  
ATOM   2768  CZ  PHE   360       5.880  38.897  40.543  1.00 74.49           C  
ATOM   2769  N   LEU   361       2.271  39.117  44.448  1.00 71.70           N  
ATOM   2770  CA  LEU   361       2.702  38.721  45.787  1.00 69.76           C  
ATOM   2771  C   LEU   361       1.597  39.093  46.799  1.00 68.49           C  
ATOM   2772  O   LEU   361       1.280  38.318  47.716  1.00 68.53           O  
ATOM   2773  CB  LEU   361       4.036  39.394  46.131  1.00 70.03           C  
ATOM   2774  CG  LEU   361       5.244  38.756  45.419  1.00 70.77           C  
ATOM   2775  CD1 LEU   361       6.454  39.634  45.580  1.00 70.87           C  
ATOM   2776  CD2 LEU   361       5.518  37.356  45.972  1.00 69.38           C  
ATOM   2777  N   ARG   362       0.996  40.266  46.605  1.00 65.18           N  
ATOM   2778  CA  ARG   362      -0.097  40.729  47.453  1.00 63.12           C  
ATOM   2779  C   ARG   362      -1.265  39.715  47.361  1.00 62.00           C  
ATOM   2780  O   ARG   362      -1.849  39.309  48.377  1.00 60.91           O  
ATOM   2781  CB  ARG   362      -0.535  42.120  46.982  1.00 61.86           C  
ATOM   2782  CG  ARG   362      -1.712  42.717  47.716  1.00 61.96           C  
ATOM   2783  CD  ARG   362      -2.222  43.940  46.978  1.00 63.92           C  
ATOM   2784  NE  ARG   362      -1.195  44.977  46.840  1.00 66.76           N  
ATOM   2785  CZ  ARG   362      -0.951  45.649  45.713  1.00 67.73           C  
ATOM   2786  NH1 ARG   362      -1.654  45.392  44.608  1.00 64.71           N  
ATOM   2787  NH2 ARG   362      -0.018  46.598  45.697  1.00 66.28           N  
ATOM   2788  N   ARG   363      -1.568  39.292  46.136  1.00 59.81           N  
ATOM   2789  CA  ARG   363      -2.631  38.329  45.863  1.00 59.48           C  
ATOM   2790  C   ARG   363      -2.433  37.003  46.619  1.00 59.25           C  
ATOM   2791  O   ARG   363      -3.341  36.530  47.330  1.00 58.56           O  
ATOM   2792  CB  ARG   363      -2.696  38.023  44.352  1.00 60.89           C  
ATOM   2793  CG  ARG   363      -4.066  38.203  43.685  1.00 64.51           C  
ATOM   2794  CD  ARG   363      -4.328  37.220  42.502  1.00 68.23           C  
ATOM   2795  NE  ARG   363      -3.397  37.355  41.371  1.00 72.07           N  
ATOM   2796  CZ  ARG   363      -2.158  36.848  41.319  1.00 73.24           C  
ATOM   2797  NH1 ARG   363      -1.651  36.139  42.336  1.00 72.33           N  
ATOM   2798  NH2 ARG   363      -1.404  37.079  40.249  1.00 71.98           N  
ATOM   2799  N   ALA   364      -1.254  36.397  46.467  1.00 56.54           N  
ATOM   2800  CA  ALA   364      -1.015  35.110  47.110  1.00 54.65           C  
ATOM   2801  C   ALA   364      -1.153  35.200  48.615  1.00 53.48           C  
ATOM   2802  O   ALA   364      -1.774  34.348  49.250  1.00 51.50           O  
ATOM   2803  CB  ALA   364       0.361  34.571  46.733  1.00 54.14           C  
ATOM   2804  N   LEU   365      -0.568  36.246  49.179  1.00 52.92           N  
ATOM   2805  CA  LEU   365      -0.625  36.452  50.605  1.00 52.01           C  
ATOM   2806  C   LEU   365      -2.068  36.660  51.080  1.00 51.54           C  
ATOM   2807  O   LEU   365      -2.523  35.955  51.986  1.00 48.93           O  
ATOM   2808  CB  LEU   365       0.270  37.641  50.977  1.00 52.84           C  
ATOM   2809  CG  LEU   365       1.779  37.436  50.757  1.00 51.97           C  
ATOM   2810  CD1 LEU   365       2.499  38.700  51.212  1.00 50.86           C  
ATOM   2811  CD2 LEU   365       2.299  36.205  51.532  1.00 48.79           C  
ATOM   2812  N   LEU   366      -2.786  37.601  50.453  1.00 52.27           N  
ATOM   2813  CA  LEU   366      -4.187  37.900  50.812  1.00 53.19           C  
ATOM   2814  C   LEU   366      -5.049  36.684  50.700  1.00 54.43           C  
ATOM   2815  O   LEU   366      -5.990  36.454  51.462  1.00 54.27           O  
ATOM   2816  CB  LEU   366      -4.782  38.972  49.903  1.00 49.80           C  
ATOM   2817  CG  LEU   366      -4.097  40.310  50.135  1.00 50.24           C  
ATOM   2818  CD1 LEU   366      -4.751  41.377  49.288  1.00 47.66           C  
ATOM   2819  CD2 LEU   366      -4.150  40.648  51.622  1.00 47.10           C  
ATOM   2820  N   ARG   367      -4.719  35.891  49.719  1.00 56.43           N  
ATOM   2821  CA  ARG   367      -5.479  34.720  49.535  1.00 58.74           C  
ATOM   2822  C   ARG   367      -5.095  33.624  50.499  1.00 58.78           C  
ATOM   2823  O   ARG   367      -5.946  32.898  51.004  1.00 58.29           O  
ATOM   2824  CB  ARG   367      -5.288  34.266  48.141  1.00 63.80           C  
ATOM   2825  CG  ARG   367      -6.427  33.468  47.735  1.00 70.46           C  
ATOM   2826  CD  ARG   367      -6.042  32.818  46.520  1.00 75.79           C  
ATOM   2827  NE  ARG   367      -5.764  33.833  45.523  1.00 81.56           N  
ATOM   2828  CZ  ARG   367      -5.668  33.552  44.238  1.00 83.54           C  
ATOM   2829  NH1 ARG   367      -5.827  32.289  43.859  1.00 83.52           N  
ATOM   2830  NH2 ARG   367      -5.449  34.516  43.350  1.00 83.58           N  
ATOM   2831  N   ALA   368      -3.800  33.496  50.757  1.00 58.48           N  
ATOM   2832  CA  ALA   368      -3.341  32.473  51.677  1.00 56.99           C  
ATOM   2833  C   ALA   368      -3.985  32.690  53.041  1.00 56.60           C  
ATOM   2834  O   ALA   368      -4.560  31.764  53.625  1.00 53.99           O  
ATOM   2835  CB  ALA   368      -1.828  32.503  51.790  1.00 55.43           C  
ATOM   2836  N   PHE   369      -3.913  33.915  53.549  1.00 56.73           N  
ATOM   2837  CA  PHE   369      -4.508  34.166  54.856  1.00 57.88           C  
ATOM   2838  C   PHE   369      -6.007  34.064  54.834  1.00 57.49           C  
ATOM   2839  O   PHE   369      -6.598  33.692  55.833  1.00 57.23           O  
ATOM   2840  CB  PHE   369      -4.081  35.518  55.414  1.00 58.82           C  
ATOM   2841  CG  PHE   369      -2.689  35.515  55.940  1.00 61.44           C  
ATOM   2842  CD1 PHE   369      -1.603  35.490  55.065  1.00 61.63           C  
ATOM   2843  CD2 PHE   369      -2.456  35.435  57.309  1.00 62.48           C  
ATOM   2844  CE1 PHE   369      -0.309  35.376  55.540  1.00 62.22           C  
ATOM   2845  CE2 PHE   369      -1.162  35.318  57.797  1.00 64.00           C  
ATOM   2846  CZ  PHE   369      -0.084  35.288  56.909  1.00 63.33           C  
ATOM   2847  N   GLY   370      -6.618  34.391  53.697  1.00 57.31           N  
ATOM   2848  CA  GLY   370      -8.060  34.285  53.592  1.00 56.52           C  
ATOM   2849  C   GLY   370      -8.456  32.831  53.780  1.00 57.41           C  
ATOM   2850  O   GLY   370      -9.400  32.514  54.513  1.00 58.60           O  
ATOM   2851  N   ALA   371      -7.711  31.931  53.149  1.00 56.71           N  
ATOM   2852  CA  ALA   371      -8.013  30.503  53.247  1.00 56.52           C  
ATOM   2853  C   ALA   371      -7.740  29.949  54.635  1.00 55.56           C  
ATOM   2854  O   ALA   371      -8.270  28.907  55.020  1.00 55.91           O  
ATOM   2855  CB  ALA   371      -7.206  29.720  52.197  1.00 55.62           C  
ATOM   2856  N   SER   372      -6.898  30.650  55.380  1.00 56.44           N  
ATOM   2857  CA  SER   372      -6.534  30.237  56.727  1.00 55.52           C  
ATOM   2858  C   SER   372      -7.477  30.867  57.739  1.00 54.67           C  
ATOM   2859  O   SER   372      -7.694  30.328  58.818  1.00 56.25           O  
ATOM   2860  CB  SER   372      -5.094  30.660  57.019  1.00 57.69           C  
ATOM   2861  OG  SER   372      -4.201  30.111  56.058  1.00 58.74           O  
ATOM   2862  N   GLY   373      -8.057  32.002  57.377  1.00 53.05           N  
ATOM   2863  CA  GLY   373      -8.966  32.673  58.281  1.00 51.55           C  
ATOM   2864  C   GLY   373      -8.183  33.413  59.345  1.00 49.80           C  
ATOM   2865  O   GLY   373      -8.461  33.284  60.540  1.00 51.12           O  
ATOM   2866  N   ALA   374      -7.212  34.203  58.905  1.00 45.58           N  
ATOM   2867  CA  ALA   374      -6.372  34.929  59.819  1.00 43.74           C  
ATOM   2868  C   ALA   374      -6.066  36.331  59.336  1.00 44.12           C  
ATOM   2869  O   ALA   374      -6.093  36.619  58.137  1.00 39.91           O  
ATOM   2870  CB  ALA   374      -5.092  34.163  60.047  1.00 43.55           C  
ATOM   2871  N   SER   375      -5.770  37.194  60.302  1.00 44.81           N  
ATOM   2872  CA  SER   375      -5.476  38.588  60.046  1.00 48.94           C  
ATOM   2873  C   SER   375      -4.039  38.777  59.579  1.00 49.80           C  
ATOM   2874  O   SER   375      -3.107  38.224  60.165  1.00 50.45           O  
ATOM   2875  CB  SER   375      -5.716  39.388  61.323  1.00 50.97           C  
ATOM   2876  OG  SER   375      -6.877  38.897  61.969  1.00 56.08           O  
ATOM   2877  N   LEU   376      -3.882  39.578  58.531  1.00 49.83           N  
ATOM   2878  CA  LEU   376      -2.594  39.868  57.952  1.00 51.97           C  
ATOM   2879  C   LEU   376      -2.426  41.345  57.679  1.00 52.80           C  
ATOM   2880  O   LEU   376      -3.380  42.015  57.293  1.00 53.63           O  
ATOM   2881  CB  LEU   376      -2.440  39.135  56.623  1.00 55.03           C  
ATOM   2882  CG  LEU   376      -1.167  39.516  55.853  1.00 56.99           C  
ATOM   2883  CD1 LEU   376       0.013  38.851  56.535  1.00 55.71           C  
ATOM   2884  CD2 LEU   376      -1.254  39.096  54.395  1.00 56.77           C  
ATOM   2885  N   ARG   377      -1.213  41.854  57.872  1.00 53.29           N  
ATOM   2886  CA  ARG   377      -0.934  43.248  57.557  1.00 54.93           C  
ATOM   2887  C   ARG   377       0.223  43.263  56.586  1.00 53.45           C  
ATOM   2888  O   ARG   377       1.235  42.658  56.849  1.00 53.65           O  
ATOM   2889  CB  ARG   377      -0.572  44.053  58.800  1.00 56.22           C  
ATOM   2890  CG  ARG   377      -1.758  44.486  59.625  1.00 60.28           C  
ATOM   2891  CD  ARG   377      -1.266  45.202  60.861  1.00 65.36           C  
ATOM   2892  NE  ARG   377      -2.328  45.801  61.662  1.00 69.05           N  
ATOM   2893  CZ  ARG   377      -2.106  46.706  62.612  1.00 72.24           C  
ATOM   2894  NH1 ARG   377      -0.864  47.101  62.862  1.00 73.53           N  
ATOM   2895  NH2 ARG   377      -3.116  47.216  63.310  1.00 73.11           N  
ATOM   2896  N   LEU   378       0.056  43.941  55.458  1.00 53.65           N  
ATOM   2897  CA  LEU   378       1.102  44.038  54.450  1.00 53.25           C  
ATOM   2898  C   LEU   378       1.775  45.402  54.512  1.00 52.89           C  
ATOM   2899  O   LEU   378       1.424  46.325  53.785  1.00 51.49           O  
ATOM   2900  CB  LEU   378       0.513  43.792  53.058  1.00 53.19           C  
ATOM   2901  CG  LEU   378       1.009  42.538  52.327  1.00 53.58           C  
ATOM   2902  CD1 LEU   378       1.225  41.401  53.299  1.00 53.98           C  
ATOM   2903  CD2 LEU   378       0.007  42.146  51.272  1.00 54.10           C  
ATOM   2904  N   HIS   379       2.750  45.510  55.404  1.00 54.02           N  
ATOM   2905  CA  HIS   379       3.499  46.749  55.597  1.00 55.10           C  
ATOM   2906  C   HIS   379       4.432  47.007  54.418  1.00 56.02           C  
ATOM   2907  O   HIS   379       4.548  46.189  53.524  1.00 56.33           O  
ATOM   2908  CB  HIS   379       4.318  46.658  56.890  1.00 51.91           C  
ATOM   2909  CG  HIS   379       3.486  46.596  58.133  1.00 51.99           C  
ATOM   2910  ND1 HIS   379       3.350  47.666  58.992  1.00 50.80           N  
ATOM   2911  CD2 HIS   379       2.751  45.591  58.667  1.00 51.96           C  
ATOM   2912  CE1 HIS   379       2.568  47.320  60.001  1.00 51.49           C  
ATOM   2913  NE2 HIS   379       2.190  46.067  59.827  1.00 50.88           N  
ATOM   2914  N   THR   380       5.086  48.157  54.434  1.00 58.20           N  
ATOM   2915  CA  THR   380       6.041  48.542  53.410  1.00 61.65           C  
ATOM   2916  C   THR   380       7.079  49.474  54.042  1.00 65.35           C  
ATOM   2917  O   THR   380       6.730  50.523  54.583  1.00 66.79           O  
ATOM   2918  CB  THR   380       5.372  49.296  52.264  1.00 61.35           C  
ATOM   2919  OG1 THR   380       4.535  48.407  51.522  1.00 61.64           O  
ATOM   2920  CG2 THR   380       6.426  49.874  51.330  1.00 64.54           C  
ATOM   2921  N   LEU   381       8.355  49.113  53.984  1.00 68.20           N  
ATOM   2922  CA  LEU   381       9.359  49.979  54.575  1.00 70.75           C  
ATOM   2923  C   LEU   381       9.731  51.112  53.640  1.00 74.35           C  
ATOM   2924  O   LEU   381      10.439  50.909  52.660  1.00 75.47           O  
ATOM   2925  CB  LEU   381      10.595  49.172  54.967  1.00 68.81           C  
ATOM   2926  CG  LEU   381      10.455  48.371  56.270  1.00 67.11           C  
ATOM   2927  CD1 LEU   381      11.417  47.215  56.273  1.00 64.80           C  
ATOM   2928  CD2 LEU   381      10.700  49.272  57.465  1.00 65.73           C  
ATOM   2929  N   HIS   382       9.221  52.305  53.938  1.00 79.18           N  
ATOM   2930  CA  HIS   382       9.520  53.490  53.137  1.00 83.84           C  
ATOM   2931  C   HIS   382      10.849  54.066  53.619  1.00 86.36           C  
ATOM   2932  O   HIS   382      11.100  55.273  53.550  1.00 86.56           O  
ATOM   2933  CB  HIS   382       8.416  54.543  53.279  1.00 84.63           C  
ATOM   2934  CG  HIS   382       7.060  54.053  52.882  1.00 87.02           C  
ATOM   2935  ND1 HIS   382       6.098  53.697  53.803  1.00 87.85           N  
ATOM   2936  CD2 HIS   382       6.506  53.851  51.663  1.00 88.30           C  
ATOM   2937  CE1 HIS   382       5.009  53.300  53.169  1.00 88.78           C  
ATOM   2938  NE2 HIS   382       5.230  53.383  51.869  1.00 89.57           N  
ATOM   2939  N   ALA   383      11.692  53.184  54.138  1.00 89.15           N  
ATOM   2940  CA  ALA   383      13.005  53.574  54.610  1.00 91.84           C  
ATOM   2941  C   ALA   383      13.917  53.228  53.460  1.00 93.75           C  
ATOM   2942  O   ALA   383      13.750  52.189  52.821  1.00 93.47           O  
ATOM   2943  CB  ALA   383      13.385  52.775  55.829  1.00 93.33           C  
ATOM   2944  N   HIS   384      14.877  54.098  53.190  1.00 96.22           N  
ATOM   2945  CA  HIS   384      15.800  53.872  52.089  1.00 98.18           C  
ATOM   2946  C   HIS   384      16.596  52.601  52.335  1.00 97.41           C  
ATOM   2947  O   HIS   384      16.378  51.919  53.342  1.00 96.85           O  
ATOM   2948  CB  HIS   384      16.721  55.086  51.946  1.00100.90           C  
ATOM   2949  CG  HIS   384      15.990  56.349  51.601  1.00103.91           C  
ATOM   2950  ND1 HIS   384      15.006  56.883  52.407  1.00104.49           N  
ATOM   2951  CD2 HIS   384      16.070  57.160  50.517  1.00104.73           C  
ATOM   2952  CE1 HIS   384      14.510  57.966  51.834  1.00104.83           C  
ATOM   2953  NE2 HIS   384      15.138  58.156  50.686  1.00104.91           N  
ATOM   2954  N   PRO   385      17.494  52.235  51.398  1.00 97.04           N  
ATOM   2955  CA  PRO   385      18.282  51.020  51.619  1.00 96.77           C  
ATOM   2956  C   PRO   385      18.951  51.220  52.973  1.00 96.28           C  
ATOM   2957  O   PRO   385      18.740  52.248  53.619  1.00 95.78           O  
ATOM   2958  CB  PRO   385      19.289  51.050  50.469  1.00 96.63           C  
ATOM   2959  CG  PRO   385      18.515  51.686  49.365  1.00 96.27           C  
ATOM   2960  CD  PRO   385      17.789  52.818  50.075  1.00 97.05           C  
ATOM   2961  N   SER   386      19.749  50.265  53.422  1.00 95.39           N  
ATOM   2962  CA  SER   386      20.406  50.466  54.702  1.00 95.77           C  
ATOM   2963  C   SER   386      21.328  51.688  54.626  1.00 94.13           C  
ATOM   2964  O   SER   386      22.545  51.549  54.585  1.00 94.15           O  
ATOM   2965  CB  SER   386      21.218  49.230  55.095  1.00 97.84           C  
ATOM   2966  OG  SER   386      21.940  49.466  56.299  1.00 99.03           O  
ATOM   2967  N   GLN   387      20.748  52.883  54.617  1.00 92.28           N  
ATOM   2968  CA  GLN   387      21.545  54.101  54.538  1.00 90.28           C  
ATOM   2969  C   GLN   387      21.216  55.164  55.592  1.00 88.47           C  
ATOM   2970  O   GLN   387      20.457  56.114  55.339  1.00 86.81           O  
ATOM   2971  CB  GLN   387      21.411  54.710  53.150  1.00 90.16           C  
ATOM   2972  CG  GLN   387      21.453  53.688  52.057  1.00 90.14           C  
ATOM   2973  CD  GLN   387      21.724  54.319  50.723  1.00 91.48           C  
ATOM   2974  OE1 GLN   387      21.320  53.798  49.682  1.00 92.20           O  
ATOM   2975  NE2 GLN   387      22.426  55.451  50.739  1.00 91.98           N  
ATOM   2976  N   GLY   388      21.809  54.999  56.769  1.00 86.08           N  
ATOM   2977  CA  GLY   388      21.599  55.948  57.836  1.00 84.79           C  
ATOM   2978  C   GLY   388      21.163  55.283  59.116  1.00 84.07           C  
ATOM   2979  O   GLY   388      20.703  54.144  59.109  1.00 84.15           O  
ATOM   2980  N   LEU   389      21.336  55.980  60.229  1.00 82.60           N  
ATOM   2981  CA  LEU   389      20.898  55.431  61.490  1.00 81.50           C  
ATOM   2982  C   LEU   389      19.380  55.504  61.403  1.00 80.28           C  
ATOM   2983  O   LEU   389      18.666  54.872  62.175  1.00 79.39           O  
ATOM   2984  CB  LEU   389      21.437  56.265  62.658  1.00 82.67           C  
ATOM   2985  CG  LEU   389      22.819  55.850  63.191  1.00 83.07           C  
ATOM   2986  CD1 LEU   389      22.688  54.543  63.955  1.00 83.88           C  
ATOM   2987  CD2 LEU   389      23.815  55.691  62.053  1.00 82.66           C  
ATOM   2988  N   ALA   390      18.902  56.274  60.429  1.00 78.98           N  
ATOM   2989  CA  ALA   390      17.474  56.433  60.193  1.00 77.68           C  
ATOM   2990  C   ALA   390      16.870  55.076  59.822  1.00 77.25           C  
ATOM   2991  O   ALA   390      15.749  54.757  60.237  1.00 77.78           O  
ATOM   2992  CB  ALA   390      17.238  57.436  59.079  1.00 76.68           C  
ATOM   2993  N   PHE   391      17.614  54.291  59.038  1.00 74.91           N  
ATOM   2994  CA  PHE   391      17.179  52.955  58.625  1.00 72.52           C  
ATOM   2995  C   PHE   391      17.006  52.123  59.894  1.00 73.50           C  
ATOM   2996  O   PHE   391      15.972  51.495  60.104  1.00 75.23           O  
ATOM   2997  CB  PHE   391      18.231  52.306  57.724  1.00 68.50           C  
ATOM   2998  CG  PHE   391      17.837  50.951  57.198  1.00 64.58           C  
ATOM   2999  CD1 PHE   391      16.902  50.829  56.175  1.00 64.14           C  
ATOM   3000  CD2 PHE   391      18.389  49.792  57.740  1.00 61.18           C  
ATOM   3001  CE1 PHE   391      16.529  49.574  55.709  1.00 62.48           C  
ATOM   3002  CE2 PHE   391      18.019  48.535  57.282  1.00 57.17           C  
ATOM   3003  CZ  PHE   391      17.098  48.419  56.275  1.00 60.15           C  
ATOM   3004  N   ARG   392      18.031  52.119  60.738  1.00 73.50           N  
ATOM   3005  CA  ARG   392      17.980  51.395  62.001  1.00 73.90           C  
ATOM   3006  C   ARG   392      16.692  51.821  62.726  1.00 74.41           C  
ATOM   3007  O   ARG   392      16.064  51.017  63.420  1.00 74.51           O  
ATOM   3008  CB  ARG   392      19.218  51.762  62.844  1.00 73.67           C  
ATOM   3009  CG  ARG   392      19.276  51.216  64.285  1.00 74.97           C  
ATOM   3010  CD  ARG   392      19.768  49.772  64.351  1.00 76.08           C  
ATOM   3011  NE  ARG   392      19.942  49.281  65.722  1.00 76.87           N  
ATOM   3012  CZ  ARG   392      21.102  49.251  66.378  1.00 77.54           C  
ATOM   3013  NH1 ARG   392      22.204  49.691  65.792  1.00 77.89           N  
ATOM   3014  NH2 ARG   392      21.167  48.753  67.611  1.00 77.04           N  
ATOM   3015  N   GLU   393      16.310  53.089  62.542  1.00 73.97           N  
ATOM   3016  CA  GLU   393      15.130  53.675  63.178  1.00 73.57           C  
ATOM   3017  C   GLU   393      13.833  53.191  62.546  1.00 73.21           C  
ATOM   3018  O   GLU   393      12.904  52.816  63.251  1.00 74.45           O  
ATOM   3019  CB  GLU   393      15.213  55.213  63.118  1.00 74.67           C  
ATOM   3020  CG  GLU   393      14.123  55.986  63.886  1.00 75.44           C  
ATOM   3021  CD  GLU   393      13.875  55.449  65.294  1.00 76.45           C  
ATOM   3022  OE1 GLU   393      14.830  54.941  65.923  1.00 76.72           O  
ATOM   3023  OE2 GLU   393      12.725  55.546  65.777  1.00 75.61           O  
ATOM   3024  N   ALA   394      13.769  53.198  61.220  1.00 71.93           N  
ATOM   3025  CA  ALA   394      12.577  52.736  60.518  1.00 71.04           C  
ATOM   3026  C   ALA   394      12.267  51.281  60.885  1.00 70.73           C  
ATOM   3027  O   ALA   394      11.098  50.876  60.933  1.00 71.78           O  
ATOM   3028  CB  ALA   394      12.776  52.860  59.019  1.00 69.08           C  
ATOM   3029  N   LEU   395      13.321  50.511  61.140  1.00 68.84           N  
ATOM   3030  CA  LEU   395      13.198  49.113  61.499  1.00 68.10           C  
ATOM   3031  C   LEU   395      12.650  48.965  62.897  1.00 67.98           C  
ATOM   3032  O   LEU   395      11.709  48.209  63.120  1.00 68.98           O  
ATOM   3033  CB  LEU   395      14.555  48.414  61.433  1.00 68.67           C  
ATOM   3034  CG  LEU   395      15.317  48.286  60.110  1.00 68.06           C  
ATOM   3035  CD1 LEU   395      16.546  47.435  60.372  1.00 67.35           C  
ATOM   3036  CD2 LEU   395      14.458  47.638  59.033  1.00 67.32           C  
ATOM   3037  N   ARG   396      13.249  49.679  63.843  1.00 68.20           N  
ATOM   3038  CA  ARG   396      12.820  49.621  65.238  1.00 68.08           C  
ATOM   3039  C   ARG   396      11.334  49.948  65.310  1.00 69.44           C  
ATOM   3040  O   ARG   396      10.568  49.292  66.015  1.00 69.34           O  
ATOM   3041  CB  ARG   396      13.602  50.626  66.066  1.00 65.37           C  
ATOM   3042  CG  ARG   396      13.337  50.537  67.552  1.00 63.99           C  
ATOM   3043  CD  ARG   396      13.753  51.830  68.256  1.00 63.64           C  
ATOM   3044  NE  ARG   396      13.033  52.992  67.735  1.00 63.64           N  
ATOM   3045  CZ  ARG   396      11.753  53.260  67.986  1.00 65.07           C  
ATOM   3046  NH1 ARG   396      11.026  52.455  68.766  1.00 63.14           N  
ATOM   3047  NH2 ARG   396      11.189  54.331  67.439  1.00 64.87           N  
ATOM   3048  N   LYS   397      10.941  50.971  64.560  1.00 70.84           N  
ATOM   3049  CA  LYS   397       9.556  51.416  64.493  1.00 72.07           C  
ATOM   3050  C   LYS   397       8.665  50.269  64.002  1.00 71.46           C  
ATOM   3051  O   LYS   397       7.656  49.947  64.620  1.00 71.57           O  
ATOM   3052  CB  LYS   397       9.462  52.622  63.549  1.00 73.71           C  
ATOM   3053  CG  LYS   397       8.128  53.363  63.579  1.00 77.32           C  
ATOM   3054  CD  LYS   397       8.177  54.596  62.677  1.00 79.13           C  
ATOM   3055  CE  LYS   397       6.802  54.934  62.101  1.00 80.43           C  
ATOM   3056  NZ  LYS   397       6.876  55.967  61.015  1.00 80.60           N  
ATOM   3057  N   ALA   398       9.064  49.649  62.895  1.00 71.06           N  
ATOM   3058  CA  ALA   398       8.335  48.532  62.294  1.00 69.23           C  
ATOM   3059  C   ALA   398       8.118  47.336  63.233  1.00 68.53           C  
ATOM   3060  O   ALA   398       7.054  46.719  63.237  1.00 67.92           O  
ATOM   3061  CB  ALA   398       9.066  48.071  61.058  1.00 67.15           C  
ATOM   3062  N   LYS   399       9.134  47.003  64.017  1.00 67.52           N  
ATOM   3063  CA  LYS   399       9.043  45.872  64.922  1.00 66.89           C  
ATOM   3064  C   LYS   399       8.131  46.231  66.074  1.00 67.65           C  
ATOM   3065  O   LYS   399       7.403  45.389  66.604  1.00 67.39           O  
ATOM   3066  CB  LYS   399      10.432  45.532  65.445  1.00 65.46           C  
ATOM   3067  CG  LYS   399      10.641  44.082  65.808  1.00 65.45           C  
ATOM   3068  CD  LYS   399      10.024  43.744  67.130  1.00 66.96           C  
ATOM   3069  CE  LYS   399      10.511  42.392  67.622  1.00 68.58           C  
ATOM   3070  NZ  LYS   399      10.209  41.303  66.663  1.00 70.49           N  
ATOM   3071  N   GLU   400       8.177  47.499  66.454  1.00 68.34           N  
ATOM   3072  CA  GLU   400       7.376  47.996  67.557  1.00 68.69           C  
ATOM   3073  C   GLU   400       5.926  47.962  67.115  1.00 66.99           C  
ATOM   3074  O   GLU   400       5.038  47.610  67.880  1.00 67.27           O  
ATOM   3075  CB  GLU   400       7.795  49.425  67.880  1.00 71.17           C  
ATOM   3076  CG  GLU   400       7.492  49.880  69.288  1.00 75.33           C  
ATOM   3077  CD  GLU   400       8.040  51.266  69.547  1.00 79.00           C  
ATOM   3078  OE1 GLU   400       7.455  52.253  69.032  1.00 78.91           O  
ATOM   3079  OE2 GLU   400       9.073  51.362  70.250  1.00 81.55           O  
ATOM   3080  N   GLU   401       5.703  48.326  65.860  1.00 65.26           N  
ATOM   3081  CA  GLU   401       4.374  48.336  65.284  1.00 63.47           C  
ATOM   3082  C   GLU   401       3.846  46.935  64.992  1.00 60.72           C  
ATOM   3083  O   GLU   401       2.770  46.783  64.439  1.00 60.47           O  
ATOM   3084  CB  GLU   401       4.374  49.164  64.005  1.00 66.24           C  
ATOM   3085  CG  GLU   401       4.370  50.656  64.235  1.00 72.45           C  
ATOM   3086  CD  GLU   401       4.380  51.433  62.931  1.00 78.43           C  
ATOM   3087  OE1 GLU   401       4.260  52.681  62.978  1.00 82.26           O  
ATOM   3088  OE2 GLU   401       4.513  50.799  61.858  1.00 81.15           O  
ATOM   3089  N   GLY   402       4.608  45.909  65.349  1.00 59.20           N  
ATOM   3090  CA  GLY   402       4.150  44.545  65.121  1.00 55.54           C  
ATOM   3091  C   GLY   402       4.650  43.728  63.934  1.00 51.64           C  
ATOM   3092  O   GLY   402       4.179  42.613  63.745  1.00 49.52           O  
ATOM   3093  N   VAL   403       5.576  44.246  63.134  1.00 49.33           N  
ATOM   3094  CA  VAL   403       6.083  43.462  62.017  1.00 47.55           C  
ATOM   3095  C   VAL   403       6.810  42.258  62.589  1.00 48.03           C  
ATOM   3096  O   VAL   403       7.432  42.346  63.642  1.00 50.13           O  
ATOM   3097  CB  VAL   403       7.025  44.269  61.144  1.00 46.21           C  
ATOM   3098  CG1 VAL   403       7.603  43.379  60.085  1.00 48.28           C  
ATOM   3099  CG2 VAL   403       6.269  45.413  60.482  1.00 43.87           C  
ATOM   3100  N   GLN   404       6.716  41.123  61.909  1.00 48.46           N  
ATOM   3101  CA  GLN   404       7.325  39.892  62.389  1.00 47.90           C  
ATOM   3102  C   GLN   404       8.401  39.325  61.467  1.00 49.46           C  
ATOM   3103  O   GLN   404       9.112  38.389  61.828  1.00 50.28           O  
ATOM   3104  CB  GLN   404       6.241  38.840  62.586  1.00 47.42           C  
ATOM   3105  CG  GLN   404       4.989  39.362  63.281  1.00 49.38           C  
ATOM   3106  CD  GLN   404       3.879  38.315  63.362  1.00 51.56           C  
ATOM   3107  OE1 GLN   404       3.423  37.765  62.340  1.00 52.27           O  
ATOM   3108  NE2 GLN   404       3.446  38.028  64.578  1.00 48.42           N  
ATOM   3109  N   ALA   405       8.519  39.875  60.270  1.00 50.59           N  
ATOM   3110  CA  ALA   405       9.515  39.387  59.334  1.00 53.14           C  
ATOM   3111  C   ALA   405       9.501  40.323  58.174  1.00 54.84           C  
ATOM   3112  O   ALA   405       8.491  40.952  57.900  1.00 55.84           O  
ATOM   3113  CB  ALA   405       9.182  37.989  58.873  1.00 53.11           C  
ATOM   3114  N   VAL   406      10.625  40.419  57.486  1.00 56.75           N  
ATOM   3115  CA  VAL   406      10.725  41.317  56.358  1.00 57.07           C  
ATOM   3116  C   VAL   406      11.093  40.546  55.101  1.00 59.00           C  
ATOM   3117  O   VAL   406      11.885  39.610  55.138  1.00 59.03           O  
ATOM   3118  CB  VAL   406      11.780  42.401  56.637  1.00 55.96           C  
ATOM   3119  CG1 VAL   406      11.832  43.397  55.500  1.00 54.50           C  
ATOM   3120  CG2 VAL   406      11.456  43.101  57.945  1.00 54.72           C  
ATOM   3121  N   LEU   407      10.473  40.940  53.997  1.00 61.07           N  
ATOM   3122  CA  LEU   407      10.708  40.341  52.705  1.00 63.09           C  
ATOM   3123  C   LEU   407      11.606  41.325  51.987  1.00 66.55           C  
ATOM   3124  O   LEU   407      11.230  42.478  51.779  1.00 66.76           O  
ATOM   3125  CB  LEU   407       9.402  40.198  51.923  1.00 62.13           C  
ATOM   3126  CG  LEU   407       9.506  39.345  50.652  1.00 60.93           C  
ATOM   3127  CD1 LEU   407       9.824  37.936  51.067  1.00 57.60           C  
ATOM   3128  CD2 LEU   407       8.219  39.377  49.851  1.00 59.77           C  
ATOM   3129  N   VAL   408      12.793  40.874  51.603  1.00 69.70           N  
ATOM   3130  CA  VAL   408      13.719  41.751  50.920  1.00 71.94           C  
ATOM   3131  C   VAL   408      13.802  41.433  49.441  1.00 74.01           C  
ATOM   3132  O   VAL   408      14.261  40.358  49.057  1.00 74.62           O  
ATOM   3133  CB  VAL   408      15.127  41.655  51.532  1.00 71.44           C  
ATOM   3134  CG1 VAL   408      16.000  42.775  50.970  1.00 70.84           C  
ATOM   3135  CG2 VAL   408      15.041  41.724  53.056  1.00 69.41           C  
ATOM   3136  N   LEU   409      13.322  42.373  48.627  1.00 76.67           N  
ATOM   3137  CA  LEU   409      13.341  42.271  47.168  1.00 78.86           C  
ATOM   3138  C   LEU   409      14.599  43.029  46.779  1.00 81.23           C  
ATOM   3139  O   LEU   409      14.623  44.262  46.789  1.00 81.47           O  
ATOM   3140  CB  LEU   409      12.118  42.958  46.562  1.00 77.86           C  
ATOM   3141  CG  LEU   409      10.877  42.124  46.250  1.00 78.49           C  
ATOM   3142  CD1 LEU   409       9.748  43.062  45.860  1.00 77.07           C  
ATOM   3143  CD2 LEU   409      11.156  41.144  45.118  1.00 78.28           C  
ATOM   3144  N   THR   410      15.643  42.292  46.425  1.00 83.76           N  
ATOM   3145  CA  THR   410      16.915  42.917  46.113  1.00 85.94           C  
ATOM   3146  C   THR   410      17.734  42.218  45.040  1.00 87.27           C  
ATOM   3147  O   THR   410      17.673  41.000  44.893  1.00 86.80           O  
ATOM   3148  CB  THR   410      17.772  42.986  47.400  1.00 86.84           C  
ATOM   3149  OG1 THR   410      19.074  43.510  47.104  1.00 88.27           O  
ATOM   3150  CG2 THR   410      17.914  41.585  48.011  1.00 85.89           C  
ATOM   3151  N   PRO   411      18.498  42.996  44.259  1.00 89.39           N  
ATOM   3152  CA  PRO   411      19.346  42.434  43.208  1.00 90.75           C  
ATOM   3153  C   PRO   411      20.306  41.502  43.927  1.00 91.92           C  
ATOM   3154  O   PRO   411      20.536  41.655  45.122  1.00 91.90           O  
ATOM   3155  CB  PRO   411      20.054  43.659  42.653  1.00 91.13           C  
ATOM   3156  CG  PRO   411      18.998  44.711  42.750  1.00 91.57           C  
ATOM   3157  CD  PRO   411      18.410  44.464  44.131  1.00 90.65           C  
ATOM   3158  N   PRO   412      20.875  40.523  43.222  1.00 93.41           N  
ATOM   3159  CA  PRO   412      21.803  39.609  43.894  1.00 94.43           C  
ATOM   3160  C   PRO   412      22.856  40.305  44.760  1.00 95.63           C  
ATOM   3161  O   PRO   412      23.463  41.297  44.362  1.00 94.80           O  
ATOM   3162  CB  PRO   412      22.400  38.822  42.736  1.00 93.95           C  
ATOM   3163  CG  PRO   412      21.223  38.717  41.798  1.00 94.37           C  
ATOM   3164  CD  PRO   412      20.668  40.133  41.817  1.00 93.59           C  
ATOM   3165  N   MET   413      23.050  39.772  45.960  1.00 97.99           N  
ATOM   3166  CA  MET   413      24.012  40.322  46.908  1.00100.79           C  
ATOM   3167  C   MET   413      25.176  39.367  47.126  1.00102.04           C  
ATOM   3168  O   MET   413      25.036  38.155  46.964  1.00102.08           O  
ATOM   3169  CB  MET   413      23.355  40.557  48.272  1.00101.82           C  
ATOM   3170  CG  MET   413      22.213  41.553  48.312  1.00103.45           C  
ATOM   3171  SD  MET   413      21.362  41.420  49.911  1.00103.53           S  
ATOM   3172  CE  MET   413      22.331  42.552  50.928  1.00103.98           C  
ATOM   3173  N   ALA   414      26.320  39.927  47.509  1.00103.97           N  
ATOM   3174  CA  ALA   414      27.504  39.127  47.796  1.00105.85           C  
ATOM   3175  C   ALA   414      27.099  38.386  49.040  1.00106.38           C  
ATOM   3176  O   ALA   414      26.309  38.885  49.842  1.00106.75           O  
ATOM   3177  CB  ALA   414      28.689  40.019  48.087  1.00106.57           C  
ATOM   3178  N   TRP   415      27.599  37.203  49.275  1.00106.66           N  
ATOM   3179  CA  TRP   415      27.041  36.636  50.450  1.00107.75           C  
ATOM   3180  C   TRP   415      27.507  37.346  51.743  1.00108.51           C  
ATOM   3181  O   TRP   415      27.047  37.028  52.857  1.00107.71           O  
ATOM   3182  CB  TRP   415      27.362  35.183  50.507  1.00107.61           C  
ATOM   3183  CG  TRP   415      28.169  35.004  51.626  1.00107.74           C  
ATOM   3184  CD1 TRP   415      29.261  35.775  52.019  1.00108.18           C  
ATOM   3185  CD2 TRP   415      27.979  34.030  52.600  1.00106.65           C  
ATOM   3186  NE1 TRP   415      29.739  35.310  53.201  1.00107.61           N  
ATOM   3187  CE2 TRP   415      28.984  34.225  53.578  1.00106.40           C  
ATOM   3188  CE3 TRP   415      27.072  32.967  52.731  1.00105.06           C  
ATOM   3189  CZ2 TRP   415      29.077  33.414  54.703  1.00104.51           C  
ATOM   3190  CZ3 TRP   415      27.164  32.167  53.831  1.00104.32           C  
ATOM   3191  CH2 TRP   415      28.176  32.387  54.809  1.00104.02           C  
ATOM   3192  N   GLU   416      28.441  38.280  51.617  1.00109.72           N  
ATOM   3193  CA  GLU   416      28.915  38.997  52.791  1.00109.87           C  
ATOM   3194  C   GLU   416      27.858  40.047  53.051  1.00108.38           C  
ATOM   3195  O   GLU   416      27.329  40.143  54.153  1.00108.88           O  
ATOM   3196  CB  GLU   416      30.297  39.624  52.537  1.00111.95           C  
ATOM   3197  CG  GLU   416      31.351  38.602  52.158  1.00112.92           C  
ATOM   3198  CD  GLU   416      32.528  39.217  51.425  1.00113.76           C  
ATOM   3199  OE1 GLU   416      32.291  40.073  50.543  1.00114.47           O  
ATOM   3200  OE2 GLU   416      33.683  38.832  51.716  1.00112.91           O  
ATOM   3201  N   ASP   417      27.515  40.807  52.018  1.00106.97           N  
ATOM   3202  CA  ASP   417      26.489  41.844  52.145  1.00105.86           C  
ATOM   3203  C   ASP   417      25.119  41.269  52.552  1.00105.07           C  
ATOM   3204  O   ASP   417      24.281  41.965  53.133  1.00105.88           O  
ATOM   3205  CB  ASP   417      26.358  42.631  50.827  1.00104.58           C  
ATOM   3206  N   ARG   418      24.900  39.994  52.254  1.00103.19           N  
ATOM   3207  CA  ARG   418      23.652  39.296  52.559  1.00101.00           C  
ATOM   3208  C   ARG   418      23.593  38.969  54.032  1.00 99.87           C  
ATOM   3209  O   ARG   418      22.557  39.111  54.694  1.00100.01           O  
ATOM   3210  CB  ARG   418      23.588  38.011  51.736  1.00101.30           C  
ATOM   3211  CG  ARG   418      22.351  37.139  51.911  1.00 99.48           C  
ATOM   3212  CD  ARG   418      22.535  35.869  51.084  1.00 98.59           C  
ATOM   3213  NE  ARG   418      21.295  35.149  50.805  1.00 98.83           N  
ATOM   3214  CZ  ARG   418      20.674  34.339  51.660  1.00 98.71           C  
ATOM   3215  NH1 ARG   418      21.177  34.137  52.873  1.00 99.15           N  
ATOM   3216  NH2 ARG   418      19.557  33.718  51.294  1.00 97.51           N  
ATOM   3217  N   ASN   419      24.713  38.516  54.554  1.00 98.07           N  
ATOM   3218  CA  ASN   419      24.773  38.194  55.948  1.00 95.93           C  
ATOM   3219  C   ASN   419      24.805  39.446  56.809  1.00 94.17           C  
ATOM   3220  O   ASN   419      24.329  39.454  57.946  1.00 92.71           O  
ATOM   3221  CB  ASN   419      26.012  37.338  56.185  1.00 96.39           C  
ATOM   3222  CG  ASN   419      25.676  35.954  56.656  1.00 96.33           C  
ATOM   3223  OD1 ASN   419      24.680  35.333  56.221  1.00 96.82           O  
ATOM   3224  ND2 ASN   419      26.504  35.446  57.553  1.00 95.71           N  
ATOM   3225  N   ARG   420      25.334  40.522  56.238  1.00 92.86           N  
ATOM   3226  CA  ARG   420      25.388  41.782  56.964  1.00 90.97           C  
ATOM   3227  C   ARG   420      23.952  42.269  57.188  1.00 88.97           C  
ATOM   3228  O   ARG   420      23.499  42.421  58.332  1.00 87.55           O  
ATOM   3229  CB  ARG   420      26.210  42.830  56.191  1.00 92.12           C  
ATOM   3230  CG  ARG   420      26.701  43.988  57.043  1.00 93.45           C  
ATOM   3231  CD  ARG   420      27.931  44.649  56.428  1.00 95.52           C  
ATOM   3232  NE  ARG   420      29.094  43.758  56.398  1.00 96.90           N  
ATOM   3233  CZ  ARG   420      30.325  44.139  56.061  1.00 97.50           C  
ATOM   3234  NH1 ARG   420      30.561  45.401  55.724  1.00 97.74           N  
ATOM   3235  NH2 ARG   420      31.319  43.260  56.056  1.00 98.04           N  
ATOM   3236  N   LEU   421      23.230  42.473  56.089  1.00 85.67           N  
ATOM   3237  CA  LEU   421      21.845  42.931  56.149  1.00 82.38           C  
ATOM   3238  C   LEU   421      20.997  42.089  57.102  1.00 80.89           C  
ATOM   3239  O   LEU   421      20.285  42.628  57.947  1.00 80.23           O  
ATOM   3240  CB  LEU   421      21.217  42.936  54.747  1.00 80.13           C  
ATOM   3241  CG  LEU   421      19.820  43.568  54.650  1.00 78.25           C  
ATOM   3242  CD1 LEU   421      19.712  44.748  55.617  1.00 76.32           C  
ATOM   3243  CD2 LEU   421      19.550  44.012  53.211  1.00 76.38           C  
ATOM   3244  N   LYS   422      21.080  40.772  56.974  1.00 79.37           N  
ATOM   3245  CA  LYS   422      20.317  39.898  57.851  1.00 79.24           C  
ATOM   3246  C   LYS   422      20.703  40.148  59.290  1.00 78.84           C  
ATOM   3247  O   LYS   422      19.888  39.974  60.195  1.00 78.89           O  
ATOM   3248  CB  LYS   422      20.563  38.420  57.517  1.00 80.27           C  
ATOM   3249  CG  LYS   422      19.726  37.900  56.357  1.00 80.84           C  
ATOM   3250  CD  LYS   422      19.998  36.440  56.090  1.00 81.25           C  
ATOM   3251  CE  LYS   422      18.871  35.825  55.279  1.00 81.95           C  
ATOM   3252  NZ  LYS   422      17.671  35.600  56.125  1.00 81.02           N  
ATOM   3253  N   ALA   423      21.951  40.559  59.498  1.00 78.91           N  
ATOM   3254  CA  ALA   423      22.456  40.832  60.840  1.00 78.05           C  
ATOM   3255  C   ALA   423      21.864  42.120  61.391  1.00 76.96           C  
ATOM   3256  O   ALA   423      21.506  42.196  62.566  1.00 75.31           O  
ATOM   3257  CB  ALA   423      23.971  40.925  60.819  1.00 79.78           C  
ATOM   3258  N   LEU   424      21.764  43.132  60.538  1.00 76.20           N  
ATOM   3259  CA  LEU   424      21.203  44.404  60.956  1.00 77.10           C  
ATOM   3260  C   LEU   424      19.767  44.193  61.455  1.00 77.44           C  
ATOM   3261  O   LEU   424      19.431  44.543  62.588  1.00 77.02           O  
ATOM   3262  CB  LEU   424      21.193  45.384  59.789  1.00 77.44           C  
ATOM   3263  CG  LEU   424      21.116  46.836  60.254  1.00 79.53           C  
ATOM   3264  CD1 LEU   424      22.511  47.331  60.559  1.00 81.77           C  
ATOM   3265  CD2 LEU   424      20.514  47.694  59.182  1.00 80.78           C  
ATOM   3266  N   LEU   425      18.938  43.596  60.598  1.00 76.81           N  
ATOM   3267  CA  LEU   425      17.534  43.326  60.893  1.00 75.30           C  
ATOM   3268  C   LEU   425      17.276  42.463  62.116  1.00 76.29           C  
ATOM   3269  O   LEU   425      16.482  42.836  62.978  1.00 76.39           O  
ATOM   3270  CB  LEU   425      16.867  42.639  59.708  1.00 73.34           C  
ATOM   3271  CG  LEU   425      17.056  43.225  58.320  1.00 72.81           C  
ATOM   3272  CD1 LEU   425      16.266  42.380  57.348  1.00 71.97           C  
ATOM   3273  CD2 LEU   425      16.606  44.669  58.278  1.00 71.87           C  
ATOM   3274  N   LEU   426      17.915  41.290  62.161  1.00 77.66           N  
ATOM   3275  CA  LEU   426      17.749  40.326  63.259  1.00 77.59           C  
ATOM   3276  C   LEU   426      18.077  40.987  64.564  1.00 77.63           C  
ATOM   3277  O   LEU   426      17.692  40.541  65.643  1.00 76.70           O  
ATOM   3278  CB  LEU   426      18.687  39.136  63.097  1.00 77.39           C  
ATOM   3279  CG  LEU   426      18.287  37.996  64.031  1.00 78.31           C  
ATOM   3280  CD1 LEU   426      17.374  37.077  63.257  1.00 79.63           C  
ATOM   3281  CD2 LEU   426      19.485  37.231  64.532  1.00 78.88           C  
ATOM   3282  N   ARG   427      18.825  42.059  64.435  1.00 78.65           N  
ATOM   3283  CA  ARG   427      19.238  42.814  65.566  1.00 80.33           C  
ATOM   3284  C   ARG   427      18.067  43.345  66.284  1.00 79.47           C  
ATOM   3285  O   ARG   427      17.932  43.269  67.503  1.00 80.34           O  
ATOM   3286  CB  ARG   427      19.980  44.044  65.150  1.00 83.88           C  
ATOM   3287  CG  ARG   427      20.371  44.679  66.370  1.00 87.75           C  
ATOM   3288  CD  ARG   427      21.159  43.586  67.016  1.00 90.99           C  
ATOM   3289  NE  ARG   427      22.507  44.065  67.059  1.00 94.46           N  
ATOM   3290  CZ  ARG   427      23.002  44.617  68.148  1.00 96.65           C  
ATOM   3291  NH1 ARG   427      22.238  44.693  69.237  1.00 96.88           N  
ATOM   3292  NH2 ARG   427      24.206  45.170  68.127  1.00 96.72           N  
ATOM   3293  N   GLU   428      17.296  44.023  65.462  1.00 78.10           N  
ATOM   3294  CA  GLU   428      16.094  44.687  65.853  1.00 77.18           C  
ATOM   3295  C   GLU   428      14.976  43.677  66.021  1.00 75.63           C  
ATOM   3296  O   GLU   428      13.828  44.038  66.238  1.00 74.74           O  
ATOM   3297  CB  GLU   428      15.775  45.726  64.786  1.00 77.14           C  
ATOM   3298  CG  GLU   428      16.764  46.891  64.804  1.00 79.44           C  
ATOM   3299  CD  GLU   428      16.807  47.583  66.162  1.00 79.89           C  
ATOM   3300  OE1 GLU   428      17.534  47.112  67.067  1.00 79.73           O  
ATOM   3301  OE2 GLU   428      16.091  48.592  66.329  1.00 80.91           O  
ATOM   3302  N   GLY   429      15.336  42.402  65.931  1.00 74.63           N  
ATOM   3303  CA  GLY   429      14.360  41.334  66.080  1.00 72.55           C  
ATOM   3304  C   GLY   429      13.550  40.984  64.840  1.00 69.54           C  
ATOM   3305  O   GLY   429      12.543  40.285  64.954  1.00 69.46           O  
ATOM   3306  N   LEU   430      13.989  41.435  63.666  1.00 65.59           N  
ATOM   3307  CA  LEU   430      13.263  41.170  62.429  1.00 63.62           C  
ATOM   3308  C   LEU   430      13.808  40.068  61.507  1.00 63.34           C  
ATOM   3309  O   LEU   430      14.744  40.307  60.733  1.00 63.73           O  
ATOM   3310  CB  LEU   430      13.150  42.468  61.627  1.00 62.33           C  
ATOM   3311  CG  LEU   430      12.451  43.641  62.324  1.00 62.79           C  
ATOM   3312  CD1 LEU   430      12.677  44.896  61.493  1.00 60.07           C  
ATOM   3313  CD2 LEU   430      10.941  43.359  62.534  1.00 59.66           C  
ATOM   3314  N   PRO   431      13.237  38.846  61.578  1.00 62.40           N  
ATOM   3315  CA  PRO   431      13.720  37.774  60.703  1.00 61.39           C  
ATOM   3316  C   PRO   431      13.654  38.230  59.249  1.00 62.47           C  
ATOM   3317  O   PRO   431      13.092  39.280  58.951  1.00 63.84           O  
ATOM   3318  CB  PRO   431      12.780  36.632  61.035  1.00 61.00           C  
ATOM   3319  CG  PRO   431      12.651  36.783  62.523  1.00 59.95           C  
ATOM   3320  CD  PRO   431      12.419  38.284  62.671  1.00 61.72           C  
ATOM   3321  N   SER   432      14.226  37.468  58.328  1.00 63.15           N  
ATOM   3322  CA  SER   432      14.231  37.925  56.943  1.00 62.84           C  
ATOM   3323  C   SER   432      14.320  36.826  55.883  1.00 64.22           C  
ATOM   3324  O   SER   432      14.755  35.700  56.150  1.00 63.59           O  
ATOM   3325  CB  SER   432      15.376  38.915  56.771  1.00 62.93           C  
ATOM   3326  OG  SER   432      16.518  38.491  57.521  1.00 62.22           O  
ATOM   3327  N   GLN   433      13.897  37.176  54.675  1.00 64.53           N  
ATOM   3328  CA  GLN   433      13.890  36.257  53.551  1.00 64.83           C  
ATOM   3329  C   GLN   433      14.243  37.037  52.303  1.00 66.12           C  
ATOM   3330  O   GLN   433      13.609  38.038  51.995  1.00 64.22           O  
ATOM   3331  CB  GLN   433      12.503  35.645  53.391  1.00 63.12           C  
ATOM   3332  CG  GLN   433      12.286  34.935  52.083  1.00 61.22           C  
ATOM   3333  CD  GLN   433      13.009  33.623  52.021  1.00 61.81           C  
ATOM   3334  OE1 GLN   433      13.014  32.867  53.001  1.00 61.91           O  
ATOM   3335  NE2 GLN   433      13.616  33.321  50.866  1.00 58.69           N  
ATOM   3336  N   ILE   434      15.263  36.571  51.593  1.00 69.20           N  
ATOM   3337  CA  ILE   434      15.715  37.229  50.377  1.00 72.35           C  
ATOM   3338  C   ILE   434      14.969  36.697  49.164  1.00 73.45           C  
ATOM   3339  O   ILE   434      14.593  35.527  49.114  1.00 72.73           O  
ATOM   3340  CB  ILE   434      17.248  37.024  50.163  1.00 73.51           C  
ATOM   3341  CG1 ILE   434      18.024  37.634  51.339  1.00 74.36           C  
ATOM   3342  CG2 ILE   434      17.692  37.647  48.846  1.00 71.51           C  
ATOM   3343  CD1 ILE   434      17.862  39.133  51.482  1.00 75.29           C  
ATOM   3344  N   LEU   435      14.758  37.574  48.192  1.00 75.09           N  
ATOM   3345  CA  LEU   435      14.073  37.214  46.963  1.00 78.54           C  
ATOM   3346  C   LEU   435      14.667  38.145  45.911  1.00 80.79           C  
ATOM   3347  O   LEU   435      14.323  39.328  45.854  1.00 79.86           O  
ATOM   3348  CB  LEU   435      12.559  37.434  47.120  1.00 78.73           C  
ATOM   3349  CG  LEU   435      11.603  36.787  46.111  1.00 78.79           C  
ATOM   3350  CD1 LEU   435      10.169  36.994  46.563  1.00 78.83           C  
ATOM   3351  CD2 LEU   435      11.822  37.381  44.726  1.00 78.56           C  
ATOM   3352  N   ASN   436      15.569  37.600  45.090  1.00 84.19           N  
ATOM   3353  CA  ASN   436      16.274  38.370  44.055  1.00 86.14           C  
ATOM   3354  C   ASN   436      15.351  39.053  43.064  1.00 87.85           C  
ATOM   3355  O   ASN   436      14.460  38.432  42.503  1.00 88.11           O  
ATOM   3356  CB  ASN   436      17.297  37.478  43.354  1.00 85.32           C  
ATOM   3357  CG  ASN   436      18.254  36.808  44.345  1.00 84.74           C  
ATOM   3358  OD1 ASN   436      18.461  37.299  45.455  1.00 82.94           O  
ATOM   3359  ND2 ASN   436      18.844  35.692  43.941  1.00 85.31           N  
ATOM   3360  N   VAL   437      15.606  40.345  42.862  1.00 91.02           N  
ATOM   3361  CA  VAL   437      14.801  41.244  42.034  1.00 94.25           C  
ATOM   3362  C   VAL   437      14.242  40.875  40.643  1.00 96.47           C  
ATOM   3363  O   VAL   437      13.060  41.133  40.385  1.00 97.05           O  
ATOM   3364  CB  VAL   437      15.489  42.650  41.966  1.00 95.19           C  
ATOM   3365  CG1 VAL   437      16.833  42.558  41.273  1.00 96.70           C  
ATOM   3366  CG2 VAL   437      14.571  43.654  41.278  1.00 95.32           C  
ATOM   3367  N   PRO   438      15.054  40.305  39.722  1.00 97.89           N  
ATOM   3368  CA  PRO   438      14.426  39.983  38.426  1.00 98.05           C  
ATOM   3369  C   PRO   438      13.326  38.957  38.696  1.00 98.73           C  
ATOM   3370  O   PRO   438      13.587  37.755  38.766  1.00 98.98           O  
ATOM   3371  CB  PRO   438      15.574  39.379  37.616  1.00 97.76           C  
ATOM   3372  CG  PRO   438      16.801  39.983  38.240  1.00 98.23           C  
ATOM   3373  CD  PRO   438      16.479  39.932  39.716  1.00 98.00           C  
ATOM   3374  N   LEU   439      12.100  39.431  38.872  1.00 99.19           N  
ATOM   3375  CA  LEU   439      11.000  38.530  39.171  1.00 99.12           C  
ATOM   3376  C   LEU   439       9.855  38.740  38.206  1.00 99.09           C  
ATOM   3377  O   LEU   439       9.476  39.878  37.905  1.00 97.78           O  
ATOM   3378  CB  LEU   439      10.523  38.746  40.612  1.00 99.18           C  
ATOM   3379  CG  LEU   439       9.556  37.710  41.188  1.00 99.34           C  
ATOM   3380  CD1 LEU   439      10.187  36.331  41.109  1.00 99.23           C  
ATOM   3381  CD2 LEU   439       9.221  38.060  42.631  1.00100.08           C  
ATOM   3382  N   ARG   440       9.307  37.629  37.727  1.00 99.55           N  
ATOM   3383  CA  ARG   440       8.206  37.663  36.780  1.00100.12           C  
ATOM   3384  C   ARG   440       7.058  36.770  37.217  1.00 99.18           C  
ATOM   3385  O   ARG   440       7.274  35.663  37.708  1.00 98.60           O  
ATOM   3386  CB  ARG   440       8.708  37.234  35.401  1.00102.04           C  
ATOM   3387  CG  ARG   440       9.632  38.252  34.753  1.00105.17           C  
ATOM   3388  CD  ARG   440      10.368  37.669  33.555  1.00107.50           C  
ATOM   3389  NE  ARG   440      11.251  36.575  33.954  1.00108.82           N  
ATOM   3390  CZ  ARG   440      12.046  35.911  33.120  1.00108.98           C  
ATOM   3391  NH1 ARG   440      12.073  36.231  31.830  1.00109.58           N  
ATOM   3392  NH2 ARG   440      12.812  34.927  33.577  1.00107.31           N  
ATOM   3393  N   GLU   441       5.839  37.270  37.034  1.00 98.47           N  
ATOM   3394  CA  GLU   441       4.624  36.543  37.389  1.00 98.07           C  
ATOM   3395  C   GLU   441       4.774  35.022  37.320  1.00 98.27           C  
ATOM   3396  O   GLU   441       4.696  34.328  38.333  1.00 96.98           O  
ATOM   3397  CB  GLU   441       3.472  36.976  36.467  1.00 97.87           C  
ATOM   3398  CG  GLU   441       2.655  38.176  36.959  1.00 96.22           C  
ATOM   3399  CD  GLU   441       1.281  37.774  37.499  1.00 94.70           C  
ATOM   3400  OE1 GLU   441       1.184  36.752  38.215  1.00 92.70           O  
ATOM   3401  OE2 GLU   441       0.298  38.490  37.216  1.00 93.59           O  
ATOM   3402  N   GLU   442       5.012  34.514  36.117  1.00 99.34           N  
ATOM   3403  CA  GLU   442       5.123  33.076  35.897  1.00100.22           C  
ATOM   3404  C   GLU   442       6.396  32.373  36.399  1.00 99.72           C  
ATOM   3405  O   GLU   442       6.890  31.459  35.739  1.00100.23           O  
ATOM   3406  CB  GLU   442       4.916  32.774  34.401  1.00 99.48           C  
ATOM   3407  N   GLU   443       6.917  32.772  37.556  1.00 98.53           N  
ATOM   3408  CA  GLU   443       8.109  32.122  38.110  1.00 97.47           C  
ATOM   3409  C   GLU   443       7.723  31.454  39.424  1.00 96.61           C  
ATOM   3410  O   GLU   443       8.488  31.423  40.392  1.00 95.83           O  
ATOM   3411  CB  GLU   443       9.230  33.139  38.339  1.00 97.80           C  
ATOM   3412  CG  GLU   443       9.740  33.767  37.060  1.00 98.79           C  
ATOM   3413  CD  GLU   443      11.049  34.493  37.250  1.00 99.76           C  
ATOM   3414  OE1 GLU   443      12.030  33.843  37.675  1.00 98.85           O  
ATOM   3415  OE2 GLU   443      11.097  35.711  36.970  1.00101.08           O  
ATOM   3416  N   ARG   444       6.514  30.908  39.412  1.00 95.98           N  
ATOM   3417  CA  ARG   444       5.894  30.238  40.549  1.00 95.19           C  
ATOM   3418  C   ARG   444       6.783  29.458  41.515  1.00 94.13           C  
ATOM   3419  O   ARG   444       6.556  29.491  42.722  1.00 94.37           O  
ATOM   3420  CB  ARG   444       4.769  29.330  40.051  1.00 94.15           C  
ATOM   3421  N   HIS   445       7.793  28.758  41.024  1.00 92.74           N  
ATOM   3422  CA  HIS   445       8.605  27.986  41.946  1.00 91.04           C  
ATOM   3423  C   HIS   445       9.434  28.795  42.955  1.00 88.56           C  
ATOM   3424  O   HIS   445       9.388  28.538  44.160  1.00 87.28           O  
ATOM   3425  CB  HIS   445       9.521  27.039  41.176  1.00 92.78           C  
ATOM   3426  CG  HIS   445      10.366  26.180  42.063  1.00 95.26           C  
ATOM   3427  ND1 HIS   445       9.827  25.294  42.974  1.00 95.37           N  
ATOM   3428  CD2 HIS   445      11.710  26.112  42.221  1.00 96.05           C  
ATOM   3429  CE1 HIS   445      10.803  24.719  43.656  1.00 96.00           C  
ATOM   3430  NE2 HIS   445      11.956  25.198  43.218  1.00 96.62           N  
ATOM   3431  N   ARG   446      10.183  29.777  42.474  1.00 85.80           N  
ATOM   3432  CA  ARG   446      11.026  30.550  43.373  1.00 83.17           C  
ATOM   3433  C   ARG   446      10.257  31.370  44.410  1.00 82.01           C  
ATOM   3434  O   ARG   446      10.481  31.224  45.614  1.00 81.48           O  
ATOM   3435  CB  ARG   446      11.954  31.472  42.573  1.00 81.52           C  
ATOM   3436  CG  ARG   446      13.395  31.513  43.082  1.00 79.01           C  
ATOM   3437  CD  ARG   446      14.050  32.836  42.712  1.00 79.07           C  
ATOM   3438  NE  ARG   446      13.729  33.228  41.342  1.00 77.93           N  
ATOM   3439  CZ  ARG   446      13.788  34.475  40.887  1.00 77.82           C  
ATOM   3440  NH1 ARG   446      14.154  35.459  41.692  1.00 77.88           N  
ATOM   3441  NH2 ARG   446      13.474  34.741  39.626  1.00 78.13           N  
ATOM   3442  N   TRP   447       9.345  32.223  43.960  1.00 80.42           N  
ATOM   3443  CA  TRP   447       8.626  33.051  44.910  1.00 79.75           C  
ATOM   3444  C   TRP   447       7.647  32.348  45.853  1.00 79.40           C  
ATOM   3445  O   TRP   447       7.453  32.810  46.972  1.00 79.31           O  
ATOM   3446  CB  TRP   447       7.945  34.231  44.207  1.00 79.05           C  
ATOM   3447  CG  TRP   447       6.848  33.912  43.253  1.00 79.39           C  
ATOM   3448  CD1 TRP   447       6.945  33.817  41.896  1.00 79.71           C  
ATOM   3449  CD2 TRP   447       5.457  33.777  43.564  1.00 79.97           C  
ATOM   3450  NE1 TRP   447       5.699  33.646  41.339  1.00 79.51           N  
ATOM   3451  CE2 TRP   447       4.767  33.619  42.342  1.00 80.10           C  
ATOM   3452  CE3 TRP   447       4.723  33.780  44.758  1.00 79.53           C  
ATOM   3453  CZ2 TRP   447       3.376  33.468  42.281  1.00 79.48           C  
ATOM   3454  CZ3 TRP   447       3.341  33.628  44.695  1.00 78.13           C  
ATOM   3455  CH2 TRP   447       2.684  33.475  43.466  1.00 78.28           C  
ATOM   3456  N   GLU   448       7.031  31.246  45.437  1.00 78.76           N  
ATOM   3457  CA  GLU   448       6.119  30.557  46.347  1.00 78.69           C  
ATOM   3458  C   GLU   448       6.924  30.041  47.537  1.00 78.31           C  
ATOM   3459  O   GLU   448       6.443  29.999  48.672  1.00 78.83           O  
ATOM   3460  CB  GLU   448       5.406  29.377  45.666  1.00 79.68           C  
ATOM   3461  CG  GLU   448       4.414  29.783  44.566  1.00 80.69           C  
ATOM   3462  CD  GLU   448       3.314  28.751  44.348  1.00 79.85           C  
ATOM   3463  OE1 GLU   448       3.616  27.538  44.371  1.00 79.77           O  
ATOM   3464  OE2 GLU   448       2.150  29.162  44.144  1.00 78.03           O  
ATOM   3465  N   ASN   449       8.158  29.641  47.280  1.00 77.42           N  
ATOM   3466  CA  ASN   449       8.990  29.155  48.363  1.00 76.32           C  
ATOM   3467  C   ASN   449       9.466  30.350  49.206  1.00 74.54           C  
ATOM   3468  O   ASN   449       9.367  30.324  50.436  1.00 74.07           O  
ATOM   3469  CB  ASN   449      10.167  28.341  47.798  1.00 77.23           C  
ATOM   3470  CG  ASN   449       9.737  26.961  47.295  1.00 76.85           C  
ATOM   3471  OD1 ASN   449       8.791  26.838  46.516  1.00 77.04           O  
ATOM   3472  ND2 ASN   449      10.438  25.923  47.736  1.00 76.34           N  
ATOM   3473  N   ALA   450       9.957  31.403  48.553  1.00 71.90           N  
ATOM   3474  CA  ALA   450      10.417  32.578  49.285  1.00 69.69           C  
ATOM   3475  C   ALA   450       9.325  32.988  50.270  1.00 69.06           C  
ATOM   3476  O   ALA   450       9.602  33.286  51.436  1.00 68.21           O  
ATOM   3477  CB  ALA   450      10.716  33.720  48.321  1.00 68.92           C  
ATOM   3478  N   LEU   451       8.081  32.979  49.791  1.00 67.35           N  
ATOM   3479  CA  LEU   451       6.932  33.343  50.603  1.00 65.40           C  
ATOM   3480  C   LEU   451       6.769  32.384  51.762  1.00 65.21           C  
ATOM   3481  O   LEU   451       6.316  32.776  52.838  1.00 65.37           O  
ATOM   3482  CB  LEU   451       5.665  33.351  49.754  1.00 65.42           C  
ATOM   3483  CG  LEU   451       5.039  34.714  49.435  1.00 66.59           C  
ATOM   3484  CD1 LEU   451       6.106  35.781  49.206  1.00 66.15           C  
ATOM   3485  CD2 LEU   451       4.147  34.563  48.204  1.00 65.91           C  
ATOM   3486  N   LEU   452       7.135  31.126  51.557  1.00 64.26           N  
ATOM   3487  CA  LEU   452       7.025  30.157  52.639  1.00 64.26           C  
ATOM   3488  C   LEU   452       8.072  30.401  53.735  1.00 64.39           C  
ATOM   3489  O   LEU   452       7.779  30.242  54.928  1.00 63.61           O  
ATOM   3490  CB  LEU   452       7.151  28.734  52.095  1.00 64.86           C  
ATOM   3491  CG  LEU   452       5.905  28.180  51.404  1.00 65.27           C  
ATOM   3492  CD1 LEU   452       6.292  27.008  50.531  1.00 65.89           C  
ATOM   3493  CD2 LEU   452       4.871  27.768  52.440  1.00 62.60           C  
ATOM   3494  N   GLY   453       9.284  30.790  53.335  1.00 63.39           N  
ATOM   3495  CA  GLY   453      10.325  31.048  54.318  1.00 64.16           C  
ATOM   3496  C   GLY   453       9.997  32.271  55.155  1.00 63.73           C  
ATOM   3497  O   GLY   453      10.199  32.297  56.376  1.00 62.75           O  
ATOM   3498  N   LEU   454       9.486  33.290  54.473  1.00 62.79           N  
ATOM   3499  CA  LEU   454       9.093  34.525  55.112  1.00 62.41           C  
ATOM   3500  C   LEU   454       8.059  34.193  56.198  1.00 61.23           C  
ATOM   3501  O   LEU   454       8.178  34.644  57.346  1.00 60.74           O  
ATOM   3502  CB  LEU   454       8.503  35.477  54.059  1.00 63.32           C  
ATOM   3503  CG  LEU   454       8.546  37.017  54.194  1.00 65.10           C  
ATOM   3504  CD1 LEU   454       7.134  37.555  54.338  1.00 65.05           C  
ATOM   3505  CD2 LEU   454       9.424  37.452  55.365  1.00 65.74           C  
ATOM   3506  N   LEU   455       7.079  33.362  55.850  1.00 59.72           N  
ATOM   3507  CA  LEU   455       6.020  33.008  56.794  1.00 60.24           C  
ATOM   3508  C   LEU   455       6.484  32.094  57.910  1.00 59.72           C  
ATOM   3509  O   LEU   455       6.103  32.276  59.069  1.00 58.97           O  
ATOM   3510  CB  LEU   455       4.820  32.373  56.062  1.00 60.75           C  
ATOM   3511  CG  LEU   455       3.989  33.269  55.131  1.00 59.94           C  
ATOM   3512  CD1 LEU   455       3.138  32.408  54.250  1.00 59.53           C  
ATOM   3513  CD2 LEU   455       3.133  34.227  55.925  1.00 59.15           C  
ATOM   3514  N   ALA   456       7.298  31.106  57.561  1.00 60.17           N  
ATOM   3515  CA  ALA   456       7.823  30.175  58.555  1.00 60.06           C  
ATOM   3516  C   ALA   456       8.624  30.955  59.594  1.00 60.28           C  
ATOM   3517  O   ALA   456       8.566  30.655  60.789  1.00 59.15           O  
ATOM   3518  CB  ALA   456       8.707  29.141  57.886  1.00 60.54           C  
ATOM   3519  N   LYS   457       9.361  31.958  59.122  1.00 60.97           N  
ATOM   3520  CA  LYS   457      10.174  32.802  59.988  1.00 63.58           C  
ATOM   3521  C   LYS   457       9.310  33.738  60.813  1.00 64.57           C  
ATOM   3522  O   LYS   457       9.644  34.070  61.948  1.00 65.77           O  
ATOM   3523  CB  LYS   457      11.171  33.621  59.160  1.00 63.49           C  
ATOM   3524  CG  LYS   457      12.306  32.780  58.600  1.00 65.51           C  
ATOM   3525  CD  LYS   457      13.165  33.544  57.604  1.00 65.97           C  
ATOM   3526  CE  LYS   457      14.015  32.576  56.780  1.00 66.12           C  
ATOM   3527  NZ  LYS   457      14.828  33.275  55.741  1.00 65.64           N  
ATOM   3528  N   ALA   458       8.194  34.166  60.240  1.00 64.66           N  
ATOM   3529  CA  ALA   458       7.298  35.062  60.940  1.00 63.69           C  
ATOM   3530  C   ALA   458       6.669  34.391  62.151  1.00 62.73           C  
ATOM   3531  O   ALA   458       5.910  35.015  62.877  1.00 62.93           O  
ATOM   3532  CB  ALA   458       6.220  35.547  59.993  1.00 64.34           C  
ATOM   3533  N   GLY   459       6.994  33.127  62.375  1.00 63.10           N  
ATOM   3534  CA  GLY   459       6.427  32.405  63.503  1.00 64.91           C  
ATOM   3535  C   GLY   459       5.185  31.656  63.054  1.00 66.83           C  
ATOM   3536  O   GLY   459       4.467  31.025  63.838  1.00 66.40           O  
ATOM   3537  N   LEU   460       4.942  31.719  61.756  1.00 67.91           N  
ATOM   3538  CA  LEU   460       3.795  31.074  61.182  1.00 69.78           C  
ATOM   3539  C   LEU   460       4.116  29.664  60.684  1.00 70.34           C  
ATOM   3540  O   LEU   460       5.007  29.473  59.870  1.00 71.78           O  
ATOM   3541  CB  LEU   460       3.287  31.938  60.053  1.00 72.34           C  
ATOM   3542  CG  LEU   460       1.951  31.526  59.467  1.00 76.66           C  
ATOM   3543  CD1 LEU   460       0.855  31.575  60.530  1.00 76.70           C  
ATOM   3544  CD2 LEU   460       1.644  32.475  58.326  1.00 79.44           C  
ATOM   3545  N   GLN   461       3.375  28.679  61.177  1.00 69.76           N  
ATOM   3546  CA  GLN   461       3.576  27.289  60.788  1.00 68.59           C  
ATOM   3547  C   GLN   461       2.760  26.843  59.566  1.00 66.95           C  
ATOM   3548  O   GLN   461       1.694  26.238  59.684  1.00 64.83           O  
ATOM   3549  CB  GLN   461       3.263  26.392  61.974  1.00 70.27           C  
ATOM   3550  CG  GLN   461       3.561  24.941  61.752  1.00 72.88           C  
ATOM   3551  CD  GLN   461       3.683  24.214  63.062  1.00 76.21           C  
ATOM   3552  OE1 GLN   461       3.032  24.584  64.047  1.00 77.16           O  
ATOM   3553  NE2 GLN   461       4.511  23.169  63.092  1.00 77.22           N  
ATOM   3554  N   VAL   462       3.302  27.157  58.396  1.00 66.06           N  
ATOM   3555  CA  VAL   462       2.729  26.830  57.100  1.00 65.72           C  
ATOM   3556  C   VAL   462       2.292  25.381  56.927  1.00 66.48           C  
ATOM   3557  O   VAL   462       1.133  25.105  56.610  1.00 66.90           O  
ATOM   3558  CB  VAL   462       3.742  27.133  56.002  1.00 64.49           C  
ATOM   3559  CG1 VAL   462       3.473  26.260  54.800  1.00 63.68           C  
ATOM   3560  CG2 VAL   462       3.683  28.598  55.643  1.00 64.45           C  
ATOM   3561  N   VAL   463       3.239  24.468  57.105  1.00 66.83           N  
ATOM   3562  CA  VAL   463       2.992  23.044  56.959  1.00 67.98           C  
ATOM   3563  C   VAL   463       3.602  22.259  58.094  1.00 68.60           C  
ATOM   3564  O   VAL   463       4.584  22.682  58.686  1.00 69.47           O  
ATOM   3565  CB  VAL   463       3.617  22.500  55.670  1.00 69.08           C  
ATOM   3566  CG1 VAL   463       3.567  20.979  55.678  1.00 69.81           C  
ATOM   3567  CG2 VAL   463       2.886  23.046  54.453  1.00 69.83           C  
ATOM   3568  N   ALA   464       3.022  21.103  58.380  1.00 69.70           N  
ATOM   3569  CA  ALA   464       3.529  20.229  59.425  1.00 72.30           C  
ATOM   3570  C   ALA   464       3.805  18.852  58.807  1.00 74.52           C  
ATOM   3571  O   ALA   464       3.051  18.384  57.954  1.00 74.47           O  
ATOM   3572  CB  ALA   464       2.521  20.112  60.552  1.00 71.04           C  
ATOM   3573  N   LEU   465       4.900  18.219  59.222  1.00 76.38           N  
ATOM   3574  CA  LEU   465       5.264  16.905  58.703  1.00 77.84           C  
ATOM   3575  C   LEU   465       4.616  15.832  59.569  1.00 78.78           C  
ATOM   3576  O   LEU   465       4.476  16.025  60.779  1.00 78.89           O  
ATOM   3577  CB  LEU   465       6.787  16.747  58.695  1.00 78.40           C  
ATOM   3578  CG  LEU   465       7.559  17.587  57.665  1.00 78.96           C  
ATOM   3579  CD1 LEU   465       9.050  17.574  57.985  1.00 79.72           C  
ATOM   3580  CD2 LEU   465       7.317  17.041  56.271  1.00 77.67           C  
ATOM   3581  N   SER   466       4.214  14.725  58.936  1.00 79.81           N  
ATOM   3582  CA  SER   466       3.549  13.588  59.596  1.00 80.82           C  
ATOM   3583  C   SER   466       3.950  13.415  61.045  1.00 80.84           C  
ATOM   3584  O   SER   466       3.274  13.917  61.938  1.00 81.56           O  
ATOM   3585  CB  SER   466       3.839  12.291  58.838  1.00 82.93           C  
ATOM   3586  OG  SER   466       5.235  12.037  58.766  1.00 84.15           O  
END
