
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  704 ( 5864),  selected  704 , name 2f8s_A
# Molecule2: number of CA atoms  637 ( 4891),  selected  637 , name T0487.pdb
# PARAMETERS: 2f8s_A.T0487.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      H       3           -
LGA    -       -      L       4           -
LGA    -       -      G       5           -
LGA    -       -      K       6           -
LGA    K     3_A      T       7          4.045
LGA    E     4_A      E       8          3.525
LGA    A     5_A      V       9          2.000
LGA    L     6_A      F      10          1.001
LGA    L     7_A      L      11          0.893
LGA    N     8_A      N      12          0.776
LGA    L     9_A      R      13          0.375
LGA    Y    10_A      F      14          0.529
LGA    R    11_A      A      15          0.426
LGA    I    12_A      L      16          1.508
LGA    E    13_A      R      17          2.712
LGA    -       -      P      18           -
LGA    Y    14_A      L      19           #
LGA    R    15_A      N      20           #
LGA    P    16_A      P      21           -
LGA    K    17_A      -       -           -
LGA    D    18_A      -       -           -
LGA    T    19_A      E      22           #
LGA    T    20_A      E      23           #
LGA    F    21_A      L      24           -
LGA    T    22_A      R      25           -
LGA    -       -      P      26           -
LGA    V    23_A      W      27           #
LGA    F    24_A      R      28           #
LGA    K    25_A      L      29          3.578
LGA    P    26_A      E      30          4.652
LGA    T    27_A      V      31           #
LGA    H    28_A      V      32          1.993
LGA    E    29_A      L      33           #
LGA    I    30_A      D      34           -
LGA    -       -      P      35           -
LGA    -       -      P      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    -       -      E      41           -
LGA    Q    31_A      V      42          3.012
LGA    K    32_A      Y      43          2.092
LGA    E    33_A      P      44          1.765
LGA    K    34_A      L      45          2.162
LGA    L    35_A      L      46          2.772
LGA    N    36_A      A      47          2.877
LGA    K    37_A      Q      48          2.330
LGA    V    38_A      V      49          2.443
LGA    R    39_A      A      50          2.689
LGA    W    40_A      R      51          2.727
LGA    R    41_A      R      52          2.798
LGA    V    42_A      A      53          3.120
LGA    F    43_A      G      54          3.118
LGA    L    44_A      G      55           #
LGA    Q    45_A      -       -           -
LGA    T    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    L    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    T    50_A      V      56          1.215
LGA    F    51_A      T      57          3.149
LGA    R    52_A      V      58          3.103
LGA    R    53_A      R      59           #
LGA    E    54_A      M      60          3.841
LGA    D    55_A      G      61           #
LGA    -       -      D      62           -
LGA    -       -      G      63           -
LGA    -       -      L      64           -
LGA    E    56_A      A      65          3.773
LGA    F    57_A      S      66          2.953
LGA    W    58_A      W      67          3.120
LGA    C    59_A      S      68          1.634
LGA    A    60_A      P      69           #
LGA    G    61_A      -       -           -
LGA    K    62_A      P      70           #
LGA    V    63_A      E      71          4.168
LGA    E    64_A      V      72           #
LGA    K    65_A      -       -           -
LGA    D    66_A      -       -           -
LGA    T    67_A      L      73           #
LGA    L    68_A      V      74          2.500
LGA    -       -      L      75           -
LGA    Y    69_A      E      76          3.058
LGA    L    70_A      G      77          3.028
LGA    T    71_A      T      78          3.011
LGA    L    72_A      L      79          2.737
LGA    S    73_A      A      80          3.686
LGA    N    74_A      R      81           #
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    -       -      Q      84           -
LGA    G    75_A      T      85          4.925
LGA    E    76_A      Y      86          3.256
LGA    I    77_A      A      87          3.371
LGA    V    78_A      Y      88          2.457
LGA    E    79_A      R      89          3.020
LGA    L    80_A      L      90          3.323
LGA    K    81_A      Y      91           #
LGA    R    82_A      P      92           #
LGA    V    83_A      K      93           #
LGA    G    84_A      G      94           #
LGA    E    85_A      -       -           -
LGA    E    86_A      R      95           #
LGA    E    87_A      R      96           -
LGA    F    88_A      -       -           -
LGA    R    89_A      -       -           -
LGA    G    90_A      -       -           -
LGA    F    91_A      P      97           #
LGA    Q    92_A      L      98          4.264
LGA    -       -      D      99           -
LGA    -       -      P     100           -
LGA    -       -      K     101           -
LGA    -       -      D     102           -
LGA    -       -      P     103           -
LGA    -       -      G     104           -
LGA    -       -      E     105           -
LGA    -       -      R     106           -
LGA    -       -      S     107           -
LGA    -       -      V     108           -
LGA    N    93_A      L     109          2.275
LGA    E    94_A      S     110          1.716
LGA    R    95_A      A     111          1.789
LGA    E    96_A      L     112          1.588
LGA    C    97_A      A     113          1.829
LGA    Q    98_A      R     114          1.915
LGA    E    99_A      R     115          1.423
LGA    L   100_A      L     116          1.506
LGA    F   101_A      L     117          2.557
LGA    R   102_A      Q     118          2.280
LGA    D   103_A      E     119          0.987
LGA    F   104_A      R     120          1.429
LGA    L   105_A      L     121          2.019
LGA    T   106_A      R     122          1.624
LGA    K   107_A      R     123          1.820
LGA    T   108_A      L     124          2.875
LGA    K   109_A      E     125          3.618
LGA    V   110_A      -       -           -
LGA    K   111_A      -       -           -
LGA    D   112_A      G     126           #
LGA    K   113_A      V     127          2.897
LGA    F   114_A      W     128           #
LGA    -       -      V     129           -
LGA    -       -      E     130           -
LGA    -       -      G     131           -
LGA    -       -      L     132           -
LGA    -       -      A     133           -
LGA    I   115_A      V     134           #
LGA    S   116_A      Y     135           #
LGA    D   117_A      R     136          4.877
LGA    F   118_A      R     137          1.719
LGA    Y   119_A      E     138          0.442
LGA    K   120_A      -       -           -
LGA    K   121_A      -       -           -
LGA    F   122_A      H     139          2.418
LGA    R   123_A      A     140          2.052
LGA    D   124_A      R     141           #
LGA    K   125_A      -       -           -
LGA    I   126_A      -       -           -
LGA    T   127_A      G     142           #
LGA    V   128_A      P     143           -
LGA    Q   129_A      G     144           -
LGA    G   130_A      -       -           -
LGA    K   131_A      -       -           -
LGA    N   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    K   134_A      -       -           -
LGA    I   135_A      -       -           -
LGA    A   136_A      W     145           #
LGA    L   137_A      R     146           #
LGA    -       -      V     147           -
LGA    I   138_A      L     148          4.405
LGA    P   139_A      G     149          3.290
LGA    E   140_A      G     150           #
LGA    V   141_A      A     151          2.373
LGA    N   142_A      V     152          1.733
LGA    E   143_A      L     153          1.904
LGA    K   144_A      D     154          1.761
LGA    V   145_A      L     155          2.512
LGA    L   146_A      W     156          3.665
LGA    K   147_A      V     157          4.076
LGA    S   148_A      S     158          4.285
LGA    E   149_A      D     159          5.419
LGA    E   150_A      S     160          4.287
LGA    G   151_A      G     161          4.233
LGA    Y   152_A      A     162          3.502
LGA    F   153_A      F     163          2.748
LGA    L   154_A      L     164          1.063
LGA    L   155_A      L     165          0.623
LGA    H   156_A      E     166          1.150
LGA    L   157_A      V     167          1.372
LGA    D   158_A      D     168          1.505
LGA    L   159_A      P     169          1.737
LGA    K   160_A      A     170          1.931
LGA    F   161_A      Y     171          2.996
LGA    R   162_A      R     172          4.737
LGA    I   163_A      I     173           #
LGA    Q   164_A      L     174           #
LGA    P   165_A      -       -           -
LGA    F   166_A      C     175           #
LGA    E   167_A      E     176           -
LGA    -       -      M     177           -
LGA    T   168_A      S     178           #
LGA    L   169_A      L     179          4.623
LGA    Q   170_A      E     180          4.635
LGA    T   171_A      A     181           #
LGA    -       -      W     182           -
LGA    -       -      L     183           -
LGA    -       -      A     184           -
LGA    -       -      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    -       -      P     188           -
LGA    L   172_A      L     189          4.044
LGA    L   173_A      P     190           -
LGA    E   174_A      K     191           -
LGA    R   175_A      R     192           -
LGA    N   176_A      V     193           -
LGA    D   177_A      R     194           -
LGA    F   178_A      N     195           -
LGA    N   179_A      A     196           -
LGA    P   180_A      Y     197           -
LGA    -       -      D     198           -
LGA    -       -      R     199           -
LGA    -       -      R     200           -
LGA    -       -      T     201           -
LGA    -       -      W     202           -
LGA    -       -      E     203           -
LGA    -       -      L     204           -
LGA    K   181_A      L     205          3.551
LGA    R   182_A      R     206           -
LGA    I   183_A      L     207           -
LGA    R   184_A      G     208           -
LGA    V   185_A      E     209           -
LGA    K   186_A      -       -           -
LGA    P   187_A      -       -           -
LGA    I   188_A      -       -           -
LGA    G   189_A      -       -           -
LGA    I   190_A      -       -           -
LGA    D   191_A      -       -           -
LGA    F   192_A      -       -           -
LGA    V   193_A      -       -           -
LGA    G   194_A      -       -           -
LGA    R   195_A      -       -           -
LGA    V   196_A      -       -           -
LGA    Q   197_A      -       -           -
LGA    D   198_A      -       -           -
LGA    V   199_A      -       -           -
LGA    F   200_A      -       -           -
LGA    K   201_A      E     210           #
LGA    -       -      D     211           -
LGA    A   202_A      P     212          5.008
LGA    K   203_A      K     213          3.516
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    E   204_A      S     222          1.742
LGA    K   205_A      L     223          3.784
LGA    G   206_A      L     224           #
LGA    E   207_A      D     225          4.512
LGA    E   208_A      Y     226           #
LGA    F   209_A      H     227           #
LGA    F   210_A      A     228          4.018
LGA    R   211_A      S     229          3.516
LGA    L   212_A      K     230          3.879
LGA    C   213_A      -       -           -
LGA    M   214_A      -       -           -
LGA    E   215_A      -       -           -
LGA    R   216_A      -       -           -
LGA    S   217_A      -       -           -
LGA    T   218_A      -       -           -
LGA    H   219_A      -       -           -
LGA    K   220_A      -       -           -
LGA    S   221_A      -       -           -
LGA    S   222_A      -       -           -
LGA    K   223_A      -       -           -
LGA    K   224_A      -       -           -
LGA    A   225_A      -       -           -
LGA    W   226_A      G     231          4.675
LGA    E   227_A      R     232          3.036
LGA    E   228_A      -       -           -
LGA    L   229_A      L     233          1.710
LGA    L   230_A      Q     234          4.689
LGA    K   231_A      G     235           #
LGA    N   232_A      R     236           #
LGA    R   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    L   235_A      E     237          4.289
LGA    R   236_A      G     238          4.330
LGA    E   237_A      G     239           #
LGA    K   238_A      R     240          2.877
LGA    A   239_A      V     241          4.791
LGA    F   240_A      A     242          4.050
LGA    L   241_A      W     243           #
LGA    -       -      V     244           -
LGA    -       -      A     245           -
LGA    -       -      D     246           -
LGA    -       -      P     247           -
LGA    -       -      K     248           -
LGA    -       -      D     249           -
LGA    -       -      P     250           -
LGA    -       -      R     251           -
LGA    -       -      K     252           -
LGA    -       -      P     253           -
LGA    -       -      I     254           -
LGA    -       -      P     255           -
LGA    V   242_A      H     256          4.791
LGA    V   243_A      L     257           -
LGA    L   244_A      T     258           -
LGA    E   245_A      G     259           -
LGA    K   246_A      -       -           -
LGA    G   247_A      -       -           -
LGA    Y   248_A      -       -           -
LGA    T   249_A      -       -           -
LGA    Y   250_A      -       -           -
LGA    P   251_A      L     260          3.465
LGA    A   252_A      L     261          2.369
LGA    T   253_A      -       -           -
LGA    I   254_A      -       -           -
LGA    L   255_A      V     262          3.233
LGA    K   256_A      P     263          2.282
LGA    P   257_A      V     264          3.122
LGA    V   258_A      L     265           #
LGA    L   259_A      T     266          4.908
LGA    T   260_A      L     267           #
LGA    Y   261_A      -       -           -
LGA    E   262_A      -       -           -
LGA    N   263_A      -       -           -
LGA    L   264_A      E     268           #
LGA    E   265_A      D     269           -
LGA    D   266_A      L     270           -
LGA    E   267_A      -       -           -
LGA    E   268_A      H     271           #
LGA    R   269_A      E     272           -
LGA    N   270_A      -       -           -
LGA    E   271_A      S     276          1.924
LGA    V   272_A      L     277           #
LGA    A   273_A      -       -           -
LGA    D   274_A      A     278           #
LGA    I   275_A      L     279          1.842
LGA    V   276_A      S     280          3.385
LGA    R   277_A      -       -           -
LGA    M   278_A      L     281          1.609
LGA    E   279_A      P     282          1.226
LGA    P   280_A      W     283          1.646
LGA    G   281_A      E     284          1.888
LGA    K   282_A      E     285          0.808
LGA    R   283_A      R     286          1.164
LGA    L   284_A      R     287          1.668
LGA    N   285_A      R     288          1.300
LGA    L   286_A      R     289          1.294
LGA    I   287_A      T     290          1.322
LGA    R   288_A      R     291          1.479
LGA    Y   289_A      E     292          1.699
LGA    I   290_A      I     293          1.353
LGA    L   291_A      A     294          1.526
LGA    R   292_A      S     295          1.877
LGA    R   293_A      W     296          1.776
LGA    Y   294_A      I     297          1.502
LGA    V   295_A      G     298          2.143
LGA    K   296_A      R     299          2.258
LGA    A   297_A      R     300          2.071
LGA    L   298_A      L     301          3.004
LGA    R   299_A      G     302          2.846
LGA    D   300_A      -       -           -
LGA    Y   301_A      -       -           -
LGA    G   302_A      -       -           -
LGA    W   303_A      L     303          1.579
LGA    Y   304_A      G     304          1.177
LGA    I   305_A      T     305          3.298
LGA    S   306_A      P     306          2.150
LGA    P   307_A      E     307          3.557
LGA    E   308_A      -       -           -
LGA    E   309_A      A     308          1.821
LGA    E   310_A      V     309          1.285
LGA    R   311_A      R     310          1.694
LGA    A   312_A      A     311          2.849
LGA    K   313_A      Q     312          2.051
LGA    G   314_A      A     313          1.951
LGA    K   315_A      Y     314          1.195
LGA    L   316_A      R     315          4.243
LGA    N   317_A      L     316          1.716
LGA    F   318_A      S     317          4.006
LGA    K   319_A      I     318           #
LGA    D   320_A      P     319          1.481
LGA    T   321_A      K     320          1.460
LGA    V   322_A      L     321          0.440
LGA    L   323_A      M     322          0.235
LGA    D   324_A      G     323          0.544
LGA    A   325_A      R     324          2.062
LGA    K   326_A      R     325          3.378
LGA    G   327_A      -       -           -
LGA    K   328_A      A     326          1.376
LGA    N   329_A      V     327          4.052
LGA    T   330_A      -       -           -
LGA    K   331_A      -       -           -
LGA    V   332_A      -       -           -
LGA    I   333_A      S     328          2.570
LGA    T   334_A      -       -           -
LGA    N   335_A      -       -           -
LGA    L   336_A      K     329          4.975
LGA    R   337_A      P     330           -
LGA    K   338_A      A     331           -
LGA    F   339_A      D     332          4.579
LGA    L   340_A      A     333          5.357
LGA    E   341_A      L     334           #
LGA    L   342_A      R     335          5.062
LGA    C   343_A      V     336          2.453
LGA    R   344_A      G     337          1.562
LGA    P   345_A      F     338          2.061
LGA    F   346_A      Y     339          4.228
LGA    -       -      R     340           -
LGA    V   347_A      A     341          3.759
LGA    K   348_A      Q     342          3.574
LGA    K   349_A      E     343          4.927
LGA    D   350_A      T     344          4.841
LGA    V   351_A      A     345           #
LGA    L   352_A      L     346          4.662
LGA    S   353_A      A     347          4.708
LGA    -       -      L     348           -
LGA    -       -      L     349           -
LGA    -       -      R     350           -
LGA    -       -      L     351           -
LGA    -       -      D     352           -
LGA    -       -      G     353           -
LGA    -       -      A     354           -
LGA    -       -      Q     355           -
LGA    V   354_A      G     356          4.717
LGA    E   355_A      W     357          3.910
LGA    I   356_A      -       -           -
LGA    I   357_A      -       -           -
LGA    S   358_A      -       -           -
LGA    V   359_A      -       -           -
LGA    S   360_A      -       -           -
LGA    V   361_A      -       -           -
LGA    Y   362_A      -       -           -
LGA    K   363_A      -       -           -
LGA    K   364_A      -       -           -
LGA    L   365_A      -       -           -
LGA    E   366_A      -       -           -
LGA    W   367_A      -       -           -
LGA    R   368_A      -       -           -
LGA    K   369_A      -       -           -
LGA    E   370_A      P     358           #
LGA    E   371_A      -       -           -
LGA    F   372_A      -       -           -
LGA    L   373_A      E     359          3.263
LGA    K   374_A      F     360          5.107
LGA    E   375_A      -       -           -
LGA    L   376_A      L     361           #
LGA    I   377_A      R     362          4.106
LGA    N   378_A      R     363          4.071
LGA    F   379_A      A     364          4.562
LGA    L   380_A      L     365          3.771
LGA    K   381_A      L     366          2.981
LGA    N   382_A      R     367          3.180
LGA    K   383_A      A     368          2.671
LGA    G   384_A      F     369          2.406
LGA    I   385_A      G     370           #
LGA    -       -      A     371           -
LGA    -       -      S     372           -
LGA    -       -      G     373           -
LGA    -       -      A     374           -
LGA    -       -      S     375           -
LGA    -       -      L     376           -
LGA    K   386_A      R     377           #
LGA    L   387_A      L     378          5.108
LGA    K   388_A      -       -           -
LGA    I   389_A      H     379           #
LGA    K   390_A      T     380          4.749
LGA    G   391_A      L     381           -
LGA    K   392_A      H     382           -
LGA    S   393_A      A     383           -
LGA    L   394_A      -       -           -
LGA    I   395_A      -       -           -
LGA    L   396_A      -       -           -
LGA    A   397_A      -       -           -
LGA    Q   398_A      -       -           -
LGA    T   399_A      -       -           -
LGA    R   400_A      -       -           -
LGA    E   401_A      -       -           -
LGA    E   402_A      -       -           -
LGA    A   403_A      -       -           -
LGA    K   404_A      -       -           -
LGA    E   405_A      -       -           -
LGA    K   406_A      -       -           -
LGA    L   407_A      -       -           -
LGA    I   408_A      -       -           -
LGA    P   409_A      -       -           -
LGA    V   410_A      -       -           -
LGA    I   411_A      -       -           -
LGA    N   412_A      H     384          4.780
LGA    K   413_A      P     385          3.556
LGA    I   414_A      S     386           -
LGA    -       -      Q     387           -
LGA    -       -      G     388           -
LGA    -       -      L     389           -
LGA    -       -      A     390           -
LGA    K   415_A      F     391           #
LGA    -       -      R     392           -
LGA    -       -      E     393           -
LGA    D   416_A      A     394           #
LGA    -       -      L     395           -
LGA    -       -      R     396           -
LGA    -       -      K     397           -
LGA    -       -      A     398           -
LGA    -       -      K     399           -
LGA    -       -      E     400           -
LGA    -       -      E     401           -
LGA    -       -      G     402           -
LGA    -       -      V     403           -
LGA    -       -      Q     404           -
LGA    -       -      A     405           -
LGA    V   417_A      V     406           #
LGA    D   418_A      L     407          4.282
LGA    L   419_A      V     408          5.320
LGA    V   420_A      L     409          3.459
LGA    I   421_A      T     410           #
LGA    V   422_A      -       -           -
LGA    F   423_A      -       -           -
LGA    L   424_A      -       -           -
LGA    E   425_A      -       -           -
LGA    E   426_A      -       -           -
LGA    Y   427_A      -       -           -
LGA    P   428_A      -       -           -
LGA    K   429_A      -       -           -
LGA    V   430_A      -       -           -
LGA    D   431_A      -       -           -
LGA    P   432_A      -       -           -
LGA    Y   433_A      -       -           -
LGA    K   434_A      -       -           -
LGA    S   435_A      -       -           -
LGA    F   436_A      -       -           -
LGA    L   437_A      -       -           -
LGA    L   438_A      -       -           -
LGA    Y   439_A      -       -           -
LGA    D   440_A      -       -           -
LGA    F   441_A      -       -           -
LGA    V   442_A      P     411          0.450
LGA    K   443_A      P     412          3.059
LGA    R   444_A      M     413          1.570
LGA    E   445_A      A     414           -
LGA    L   446_A      W     415           -
LGA    -       -      E     416           -
LGA    -       -      D     417           -
LGA    L   447_A      R     418          4.318
LGA    -       -      N     419           -
LGA    K   448_A      R     420          5.102
LGA    K   449_A      L     421          3.611
LGA    M   450_A      K     422          3.851
LGA    I   451_A      A     423           -
LGA    -       -      L     424           -
LGA    -       -      L     425           -
LGA    -       -      L     426           -
LGA    -       -      R     427           -
LGA    -       -      E     428           -
LGA    -       -      G     429           -
LGA    -       -      L     430           -
LGA    -       -      P     431           -
LGA    -       -      S     432           -
LGA    P   452_A      Q     433          3.112
LGA    S   453_A      I     434          4.315
LGA    Q   454_A      L     435          3.661
LGA    V   455_A      N     436          4.110
LGA    -       -      V     437           -
LGA    -       -      P     438           -
LGA    I   456_A      L     439          1.166
LGA    L   457_A      R     440          4.671
LGA    N   458_A      -       -           -
LGA    R   459_A      -       -           -
LGA    T   460_A      -       -           -
LGA    L   461_A      -       -           -
LGA    K   462_A      -       -           -
LGA    N   463_A      -       -           -
LGA    E   464_A      -       -           -
LGA    N   465_A      -       -           -
LGA    L   466_A      E     441           #
LGA    K   467_A      -       -           -
LGA    F   468_A      E     442           #
LGA    V   469_A      E     443          3.875
LGA    L   470_A      R     444          4.358
LGA    L   471_A      H     445           #
LGA    N   472_A      R     446           #
LGA    V   473_A      W     447          3.186
LGA    A   474_A      E     448          3.284
LGA    E   475_A      -       -           -
LGA    Q   476_A      N     449          1.854
LGA    V   477_A      A     450          4.415
LGA    L   478_A      L     451          3.198
LGA    A   479_A      L     452          0.745
LGA    K   480_A      G     453          3.099
LGA    T   481_A      L     454          2.872
LGA    G   482_A      L     455          0.919
LGA    N   483_A      A     456           #
LGA    I   484_A      K     457           -
LGA    -       -      A     458           -
LGA    -       -      G     459           -
LGA    -       -      L     460           -
LGA    -       -      Q     461           -
LGA    P   485_A      V     462          3.937
LGA    Y   486_A      V     463          2.209
LGA    K   487_A      A     464          2.171
LGA    L   488_A      L     465          1.400
LGA    K   489_A      S     466          1.791
LGA    E   490_A      G     467          2.363
LGA    I   491_A      A     468           #
LGA    E   492_A      -       -           -
LGA    G   493_A      Y     469          3.085
LGA    K   494_A      P     470          3.157
LGA    V   495_A      A     471          1.137
LGA    D   496_A      E     472          2.067
LGA    A   497_A      L     473          0.949
LGA    F   498_A      A     474          0.333
LGA    V   499_A      V     475          0.879
LGA    G   500_A      G     476          0.917
LGA    I   501_A      F     477          0.995
LGA    D   502_A      D     478          1.334
LGA    I   503_A      A     479          2.147
LGA    S   504_A      G     480           #
LGA    -       -      G     481           -
LGA    R   505_A      R     482           #
LGA    -       -      E     483           -
LGA    -       -      S     484           -
LGA    -       -      F     485           -
LGA    -       -      R     486           -
LGA    I   506_A      F     487           #
LGA    T   507_A      -       -           -
LGA    R   508_A      -       -           -
LGA    D   509_A      -       -           -
LGA    G   510_A      -       -           -
LGA    K   511_A      -       -           -
LGA    T   512_A      -       -           -
LGA    V   513_A      -       -           -
LGA    N   514_A      -       -           -
LGA    A   515_A      -       -           -
LGA    V   516_A      G     488          1.948
LGA    A   517_A      G     489          1.502
LGA    F   518_A      A     490          0.776
LGA    T   519_A      A     491          0.921
LGA    K   520_A      C     492          1.170
LGA    I   521_A      A     493          1.367
LGA    F   522_A      V     494          1.345
LGA    N   523_A      G     495          1.188
LGA    S   524_A      G     496          2.177
LGA    K   525_A      D     497          1.132
LGA    G   526_A      G     498          3.084
LGA    E   527_A      G     499          2.613
LGA    L   528_A      H     500          1.572
LGA    V   529_A      L     501          1.076
LGA    R   530_A      L     502          1.781
LGA    Y   531_A      W     503          1.279
LGA    Y   532_A      T     504          0.893
LGA    L   533_A      L     505          3.095
LGA    T   534_A      P     506          3.273
LGA    -       -      E     507           -
LGA    S   535_A      A     508           #
LGA    Y   536_A      Q     509           #
LGA    P   537_A      A     510           #
LGA    A   538_A      G     511           #
LGA    F   539_A      E     512          1.624
LGA    G   540_A      R     513           #
LGA    E   541_A      -       -           -
LGA    K   542_A      -       -           -
LGA    L   543_A      I     514          1.937
LGA    T   544_A      P     515          1.135
LGA    E   545_A      Q     516          2.382
LGA    K   546_A      E     517          1.690
LGA    A   547_A      V     518          0.614
LGA    I   548_A      V     519          2.089
LGA    G   549_A      W     520          2.258
LGA    D   550_A      D     521          0.849
LGA    V   551_A      L     522          2.614
LGA    F   552_A      L     523          3.930
LGA    S   553_A      E     524          2.841
LGA    L   554_A      E     525          1.774
LGA    L   555_A      T     526          4.040
LGA    E   556_A      L     527          4.355
LGA    K   557_A      W     528          2.472
LGA    L   558_A      A     529          3.359
LGA    -       -      F     530           -
LGA    G   559_A      R     531          2.877
LGA    -       -      R     532           -
LGA    -       -      K     533           -
LGA    -       -      A     534           -
LGA    -       -      G     535           -
LGA    F   560_A      R     536          4.311
LGA    K   561_A      L     537          2.543
LGA    K   562_A      P     538           #
LGA    G   563_A      -       -           -
LGA    S   564_A      S     539          1.414
LGA    K   565_A      R     540          0.676
LGA    I   566_A      V     541          0.912
LGA    V   567_A      L     542          0.881
LGA    V   568_A      L     543          0.312
LGA    H   569_A      L     544          0.542
LGA    R   570_A      R     545          1.114
LGA    D   571_A      D     546          2.230
LGA    G   572_A      G     547          2.653
LGA    R   573_A      R     548          3.158
LGA    L   574_A      V     549          3.699
LGA    Y   575_A      P     550          1.675
LGA    R   576_A      Q     551          4.556
LGA    D   577_A      D     552          2.823
LGA    E   578_A      E     553          1.287
LGA    V   579_A      F     554          3.732
LGA    A   580_A      A     555          2.388
LGA    A   581_A      L     556          2.288
LGA    F   582_A      A     557          2.716
LGA    K   583_A      L     558          2.989
LGA    K   584_A      E     559          2.413
LGA    Y   585_A      A     560          1.527
LGA    G   586_A      L     561          2.565
LGA    E   587_A      A     562          2.621
LGA    L   588_A      R     563          3.120
LGA    Y   589_A      E     564          2.542
LGA    G   590_A      G     565          2.687
LGA    Y   591_A      I     566          1.228
LGA    S   592_A      A     567          1.180
LGA    L   593_A      Y     568          1.584
LGA    E   594_A      D     569          0.931
LGA    L   595_A      L     570          0.822
LGA    L   596_A      V     571          1.007
LGA    E   597_A      S     572          0.838
LGA    I   598_A      V     573          0.563
LGA    I   599_A      R     574          1.198
LGA    K   600_A      K     575          1.218
LGA    R   601_A      S     576          1.413
LGA    N   602_A      G     577          2.841
LGA    N   603_A      G     578          1.824
LGA    P   604_A      G     579          0.549
LGA    R   605_A      R     580          0.717
LGA    F   606_A      V     581          0.659
LGA    F   607_A      Y     582          1.599
LGA    S   608_A      P     583          2.390
LGA    -       -      V     584           -
LGA    -       -      Q     585           -
LGA    N   609_A      G     586          4.120
LGA    E   610_A      R     587          2.258
LGA    K   611_A      L     588          3.632
LGA    F   612_A      A     589          1.375
LGA    I   613_A      D     590          3.545
LGA    K   614_A      G     591          1.819
LGA    G   615_A      L     592          1.604
LGA    Y   616_A      Y     593          3.436
LGA    F   617_A      V     594          0.946
LGA    Y   618_A      P     595          3.462
LGA    K   619_A      L     596          1.085
LGA    L   620_A      E     597          3.119
LGA    S   621_A      -       -           -
LGA    E   622_A      D     598           #
LGA    D   623_A      K     599          1.200
LGA    S   624_A      T     600          1.676
LGA    V   625_A      F     601          1.678
LGA    I   626_A      L     602          2.498
LGA    L   627_A      L     603          2.380
LGA    A   628_A      L     604          1.754
LGA    T   629_A      T     605          3.666
LGA    Y   630_A      V     606          4.073
LGA    N   631_A      H     607          4.384
LGA    Q   632_A      R     608           #
LGA    V   633_A      D     609          3.918
LGA    Y   634_A      F     610          2.109
LGA    E   635_A      R     611          4.666
LGA    G   636_A      G     612           #
LGA    T   637_A      T     613          4.295
LGA    H   638_A      P     614          1.336
LGA    Q   639_A      R     615          0.703
LGA    P   640_A      P     616          0.721
LGA    I   641_A      L     617          0.789
LGA    K   642_A      K     618          0.906
LGA    V   643_A      L     619          0.547
LGA    R   644_A      V     620          0.574
LGA    K   645_A      H     621          0.977
LGA    V   646_A      E     622          1.060
LGA    Y   647_A      A     623          0.626
LGA    G   648_A      G     624          0.712
LGA    E   649_A      D     625          1.203
LGA    L   650_A      T     626          0.789
LGA    P   651_A      P     627          1.766
LGA    V   652_A      L     628          2.324
LGA    E   653_A      E     629          2.451
LGA    V   654_A      A     630          1.733
LGA    L   655_A      L     631          1.310
LGA    C   656_A      A     632          1.548
LGA    S   657_A      H     633          1.378
LGA    Q   658_A      Q     634          1.021
LGA    I   659_A      I     635          0.777
LGA    L   660_A      F     636          0.269
LGA    S   661_A      H     637          0.528
LGA    L   662_A      L     638          0.185
LGA    T   663_A      T     639          0.932
LGA    L   664_A      R     640          1.788
LGA    M   665_A      L     641          2.079
LGA    N   666_A      Y     642          1.249
LGA    Y   667_A      -       -           -
LGA    S   668_A      -       -           -
LGA    S   669_A      -       -           -
LGA    F   670_A      -       -           -
LGA    Q   671_A      -       -           -
LGA    P   672_A      -       -           -
LGA    I   673_A      -       -           -
LGA    K   674_A      -       -           -
LGA    L   675_A      -       -           -
LGA    P   676_A      -       -           -
LGA    A   677_A      -       -           -
LGA    T   678_A      -       -           -
LGA    V   679_A      -       -           -
LGA    H   680_A      -       -           -
LGA    Y   681_A      -       -           -
LGA    S   682_A      -       -           -
LGA    D   683_A      -       -           -
LGA    K   684_A      -       -           -
LGA    I   685_A      -       -           -
LGA    T   686_A      -       -           -
LGA    K   687_A      -       -           -
LGA    L   688_A      -       -           -
LGA    M   689_A      -       -           -
LGA    L   690_A      -       -           -
LGA    R   691_A      -       -           -
LGA    G   692_A      -       -           -
LGA    I   693_A      -       -           -
LGA    E   694_A      -       -           -
LGA    P   695_A      -       -           -
LGA    I   696_A      -       -           -
LGA    K   697_A      -       -           -
LGA    K   698_A      -       -           -
LGA    E   699_A      -       -           -
LGA    G   700_A      -       -           -
LGA    D   701_A      -       -           -
LGA    I   702_A      -       -           -
LGA    M   703_A      -       -           -
LGA    Y   704_A      -       -           -
LGA    W   705_A      -       -           -
LGA    L   706_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  704  637    5.0    386    2.78    17.10     34.806    13.383

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.839259 * X  +   0.206375 * Y  +  -0.503044 * Z  +  28.581699
  Y_new =   0.399762 * X  +   0.861306 * Y  +  -0.313595 * Z  +  30.830898
  Z_new =   0.368557 * X  +  -0.464286 * Y  +  -0.805360 * Z  +  63.862534 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.618636    0.522957  [ DEG:  -150.0368     29.9632 ]
  Theta =  -0.377457   -2.764136  [ DEG:   -21.6267   -158.3733 ]
  Phi   =   2.697062   -0.444531  [ DEG:   154.5302    -25.4698 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f8s_A                                        
REMARK     2: T0487.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f8s_A.T0487.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  704  637   5.0  386   2.78   17.10  34.806
REMARK  ---------------------------------------------------------- 
MOLECULE 2f8s_A
HEADER    RNA BINDING PROTEIN/RNA                 03-DEC-05   2F8S              
TITLE     CRYSTAL STRUCTURE OF AA-AGO WITH EXTERNALLY-BOUND SIRNA               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ARGONAUTE PROTEIN;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: 5'-                                                        
COMPND   7 R(P*AP*GP*AP*CP*AP*GP*CP*AP*UP*AP*UP*AP*UP*GP*CP*UP*GP*UP*C          
COMPND   8 P*UP*UP*U)-3';                                                       
COMPND   9 CHAIN: C, D;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B;                                   
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 SYNTHETIC: YES                                                       
KEYWDS    ARGONAUTE, SIRNA, RISC LOADING COMPLEX                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.R.YUAN,H.Y.CHEN,D.J.PATEL                                           
REVDAT   1   31-OCT-06 2F8S    0                                                
JRNL        AUTH   Y.R.YUAN,Y.PEI,H.Y.CHEN,T.TUSCHL,D.J.PATEL                   
JRNL        TITL   A POTENTIAL PROTEIN-RNA RECOGNITION EVENT ALONG              
JRNL        TITL 2 THE RISC-LOADING PATHWAY FROM THE STRUCTURE OF A.            
JRNL        TITL 3 AEOLICUS ARGONAUTE WITH EXTERNALLY BOUND SIRNA.              
JRNL        REF    STRUCTURE                     V.  14  1557 2006              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 3.00 ANGSTROMS.                                          
DBREF  2F8S A    1   706  UNP    O67434   O67434_AQUAE     1    706             
DBREF  2F8S B    1   706  UNP    O67434   O67434_AQUAE     1    706             
SEQRES   1 A  706  MET GLY LYS GLU ALA LEU LEU ASN LEU TYR ARG ILE GLU          
SEQRES   2 A  706  TYR ARG PRO LYS ASP THR THR PHE THR VAL PHE LYS PRO          
SEQRES   3 A  706  THR HIS GLU ILE GLN LYS GLU LYS LEU ASN LYS VAL ARG          
SEQRES   4 A  706  TRP ARG VAL PHE LEU GLN THR GLY LEU PRO THR PHE ARG          
SEQRES   5 A  706  ARG GLU ASP GLU PHE TRP CYS ALA GLY LYS VAL GLU LYS          
SEQRES   6 A  706  ASP THR LEU TYR LEU THR LEU SER ASN GLY GLU ILE VAL          
SEQRES   7 A  706  GLU LEU LYS ARG VAL GLY GLU GLU GLU PHE ARG GLY PHE          
SEQRES   8 A  706  GLN ASN GLU ARG GLU CYS GLN GLU LEU PHE ARG ASP PHE          
SEQRES   9 A  706  LEU THR LYS THR LYS VAL LYS ASP LYS PHE ILE SER ASP          
SEQRES  10 A  706  PHE TYR LYS LYS PHE ARG ASP LYS ILE THR VAL GLN GLY          
SEQRES  11 A  706  LYS ASN ARG LYS ILE ALA LEU ILE PRO GLU VAL ASN GLU          
SEQRES  12 A  706  LYS VAL LEU LYS SER GLU GLU GLY TYR PHE LEU LEU HIS          
SEQRES  13 A  706  LEU ASP LEU LYS PHE ARG ILE GLN PRO PHE GLU THR LEU          
SEQRES  14 A  706  GLN THR LEU LEU GLU ARG ASN ASP PHE ASN PRO LYS ARG          
SEQRES  15 A  706  ILE ARG VAL LYS PRO ILE GLY ILE ASP PHE VAL GLY ARG          
SEQRES  16 A  706  VAL GLN ASP VAL PHE LYS ALA LYS GLU LYS GLY GLU GLU          
SEQRES  17 A  706  PHE PHE ARG LEU CYS MET GLU ARG SER THR HIS LYS SER          
SEQRES  18 A  706  SER LYS LYS ALA TRP GLU GLU LEU LEU LYS ASN ARG GLU          
SEQRES  19 A  706  LEU ARG GLU LYS ALA PHE LEU VAL VAL LEU GLU LYS GLY          
SEQRES  20 A  706  TYR THR TYR PRO ALA THR ILE LEU LYS PRO VAL LEU THR          
SEQRES  21 A  706  TYR GLU ASN LEU GLU ASP GLU GLU ARG ASN GLU VAL ALA          
SEQRES  22 A  706  ASP ILE VAL ARG MET GLU PRO GLY LYS ARG LEU ASN LEU          
SEQRES  23 A  706  ILE ARG TYR ILE LEU ARG ARG TYR VAL LYS ALA LEU ARG          
SEQRES  24 A  706  ASP TYR GLY TRP TYR ILE SER PRO GLU GLU GLU ARG ALA          
SEQRES  25 A  706  LYS GLY LYS LEU ASN PHE LYS ASP THR VAL LEU ASP ALA          
SEQRES  26 A  706  LYS GLY LYS ASN THR LYS VAL ILE THR ASN LEU ARG LYS          
SEQRES  27 A  706  PHE LEU GLU LEU CYS ARG PRO PHE VAL LYS LYS ASP VAL          
SEQRES  28 A  706  LEU SER VAL GLU ILE ILE SER VAL SER VAL TYR LYS LYS          
SEQRES  29 A  706  LEU GLU TRP ARG LYS GLU GLU PHE LEU LYS GLU LEU ILE          
SEQRES  30 A  706  ASN PHE LEU LYS ASN LYS GLY ILE LYS LEU LYS ILE LYS          
SEQRES  31 A  706  GLY LYS SER LEU ILE LEU ALA GLN THR ARG GLU GLU ALA          
SEQRES  32 A  706  LYS GLU LYS LEU ILE PRO VAL ILE ASN LYS ILE LYS ASP          
SEQRES  33 A  706  VAL ASP LEU VAL ILE VAL PHE LEU GLU GLU TYR PRO LYS          
SEQRES  34 A  706  VAL ASP PRO TYR LYS SER PHE LEU LEU TYR ASP PHE VAL          
SEQRES  35 A  706  LYS ARG GLU LEU LEU LYS LYS MET ILE PRO SER GLN VAL          
SEQRES  36 A  706  ILE LEU ASN ARG THR LEU LYS ASN GLU ASN LEU LYS PHE          
SEQRES  37 A  706  VAL LEU LEU ASN VAL ALA GLU GLN VAL LEU ALA LYS THR          
SEQRES  38 A  706  GLY ASN ILE PRO TYR LYS LEU LYS GLU ILE GLU GLY LYS          
SEQRES  39 A  706  VAL ASP ALA PHE VAL GLY ILE ASP ILE SER ARG ILE THR          
SEQRES  40 A  706  ARG ASP GLY LYS THR VAL ASN ALA VAL ALA PHE THR LYS          
SEQRES  41 A  706  ILE PHE ASN SER LYS GLY GLU LEU VAL ARG TYR TYR LEU          
SEQRES  42 A  706  THR SER TYR PRO ALA PHE GLY GLU LYS LEU THR GLU LYS          
SEQRES  43 A  706  ALA ILE GLY ASP VAL PHE SER LEU LEU GLU LYS LEU GLY          
SEQRES  44 A  706  PHE LYS LYS GLY SER LYS ILE VAL VAL HIS ARG ASP GLY          
SEQRES  45 A  706  ARG LEU TYR ARG ASP GLU VAL ALA ALA PHE LYS LYS TYR          
SEQRES  46 A  706  GLY GLU LEU TYR GLY TYR SER LEU GLU LEU LEU GLU ILE          
SEQRES  47 A  706  ILE LYS ARG ASN ASN PRO ARG PHE PHE SER ASN GLU LYS          
SEQRES  48 A  706  PHE ILE LYS GLY TYR PHE TYR LYS LEU SER GLU ASP SER          
SEQRES  49 A  706  VAL ILE LEU ALA THR TYR ASN GLN VAL TYR GLU GLY THR          
SEQRES  50 A  706  HIS GLN PRO ILE LYS VAL ARG LYS VAL TYR GLY GLU LEU          
SEQRES  51 A  706  PRO VAL GLU VAL LEU CYS SER GLN ILE LEU SER LEU THR          
SEQRES  52 A  706  LEU MET ASN TYR SER SER PHE GLN PRO ILE LYS LEU PRO          
SEQRES  53 A  706  ALA THR VAL HIS TYR SER ASP LYS ILE THR LYS LEU MET          
SEQRES  54 A  706  LEU ARG GLY ILE GLU PRO ILE LYS LYS GLU GLY ASP ILE          
SEQRES  55 A  706  MET TYR TRP LEU                                              
SEQRES   1 B  706  MET GLY LYS GLU ALA LEU LEU ASN LEU TYR ARG ILE GLU          
SEQRES   2 B  706  TYR ARG PRO LYS ASP THR THR PHE THR VAL PHE LYS PRO          
SEQRES   3 B  706  THR HIS GLU ILE GLN LYS GLU LYS LEU ASN LYS VAL ARG          
SEQRES   4 B  706  TRP ARG VAL PHE LEU GLN THR GLY LEU PRO THR PHE ARG          
SEQRES   5 B  706  ARG GLU ASP GLU PHE TRP CYS ALA GLY LYS VAL GLU LYS          
SEQRES   6 B  706  ASP THR LEU TYR LEU THR LEU SER ASN GLY GLU ILE VAL          
SEQRES   7 B  706  GLU LEU LYS ARG VAL GLY GLU GLU GLU PHE ARG GLY PHE          
SEQRES   8 B  706  GLN ASN GLU ARG GLU CYS GLN GLU LEU PHE ARG ASP PHE          
SEQRES   9 B  706  LEU THR LYS THR LYS VAL LYS ASP LYS PHE ILE SER ASP          
SEQRES  10 B  706  PHE TYR LYS LYS PHE ARG ASP LYS ILE THR VAL GLN GLY          
SEQRES  11 B  706  LYS ASN ARG LYS ILE ALA LEU ILE PRO GLU VAL ASN GLU          
SEQRES  12 B  706  LYS VAL LEU LYS SER GLU GLU GLY TYR PHE LEU LEU HIS          
SEQRES  13 B  706  LEU ASP LEU LYS PHE ARG ILE GLN PRO PHE GLU THR LEU          
SEQRES  14 B  706  GLN THR LEU LEU GLU ARG ASN ASP PHE ASN PRO LYS ARG          
SEQRES  15 B  706  ILE ARG VAL LYS PRO ILE GLY ILE ASP PHE VAL GLY ARG          
SEQRES  16 B  706  VAL GLN ASP VAL PHE LYS ALA LYS GLU LYS GLY GLU GLU          
SEQRES  17 B  706  PHE PHE ARG LEU CYS MET GLU ARG SER THR HIS LYS SER          
SEQRES  18 B  706  SER LYS LYS ALA TRP GLU GLU LEU LEU LYS ASN ARG GLU          
SEQRES  19 B  706  LEU ARG GLU LYS ALA PHE LEU VAL VAL LEU GLU LYS GLY          
SEQRES  20 B  706  TYR THR TYR PRO ALA THR ILE LEU LYS PRO VAL LEU THR          
SEQRES  21 B  706  TYR GLU ASN LEU GLU ASP GLU GLU ARG ASN GLU VAL ALA          
SEQRES  22 B  706  ASP ILE VAL ARG MET GLU PRO GLY LYS ARG LEU ASN LEU          
SEQRES  23 B  706  ILE ARG TYR ILE LEU ARG ARG TYR VAL LYS ALA LEU ARG          
SEQRES  24 B  706  ASP TYR GLY TRP TYR ILE SER PRO GLU GLU GLU ARG ALA          
SEQRES  25 B  706  LYS GLY LYS LEU ASN PHE LYS ASP THR VAL LEU ASP ALA          
SEQRES  26 B  706  LYS GLY LYS ASN THR LYS VAL ILE THR ASN LEU ARG LYS          
SEQRES  27 B  706  PHE LEU GLU LEU CYS ARG PRO PHE VAL LYS LYS ASP VAL          
SEQRES  28 B  706  LEU SER VAL GLU ILE ILE SER VAL SER VAL TYR LYS LYS          
SEQRES  29 B  706  LEU GLU TRP ARG LYS GLU GLU PHE LEU LYS GLU LEU ILE          
SEQRES  30 B  706  ASN PHE LEU LYS ASN LYS GLY ILE LYS LEU LYS ILE LYS          
SEQRES  31 B  706  GLY LYS SER LEU ILE LEU ALA GLN THR ARG GLU GLU ALA          
SEQRES  32 B  706  LYS GLU LYS LEU ILE PRO VAL ILE ASN LYS ILE LYS ASP          
SEQRES  33 B  706  VAL ASP LEU VAL ILE VAL PHE LEU GLU GLU TYR PRO LYS          
SEQRES  34 B  706  VAL ASP PRO TYR LYS SER PHE LEU LEU TYR ASP PHE VAL          
SEQRES  35 B  706  LYS ARG GLU LEU LEU LYS LYS MET ILE PRO SER GLN VAL          
SEQRES  36 B  706  ILE LEU ASN ARG THR LEU LYS ASN GLU ASN LEU LYS PHE          
SEQRES  37 B  706  VAL LEU LEU ASN VAL ALA GLU GLN VAL LEU ALA LYS THR          
SEQRES  38 B  706  GLY ASN ILE PRO TYR LYS LEU LYS GLU ILE GLU GLY LYS          
SEQRES  39 B  706  VAL ASP ALA PHE VAL GLY ILE ASP ILE SER ARG ILE THR          
SEQRES  40 B  706  ARG ASP GLY LYS THR VAL ASN ALA VAL ALA PHE THR LYS          
SEQRES  41 B  706  ILE PHE ASN SER LYS GLY GLU LEU VAL ARG TYR TYR LEU          
SEQRES  42 B  706  THR SER TYR PRO ALA PHE GLY GLU LYS LEU THR GLU LYS          
SEQRES  43 B  706  ALA ILE GLY ASP VAL PHE SER LEU LEU GLU LYS LEU GLY          
SEQRES  44 B  706  PHE LYS LYS GLY SER LYS ILE VAL VAL HIS ARG ASP GLY          
SEQRES  45 B  706  ARG LEU TYR ARG ASP GLU VAL ALA ALA PHE LYS LYS TYR          
SEQRES  46 B  706  GLY GLU LEU TYR GLY TYR SER LEU GLU LEU LEU GLU ILE          
SEQRES  47 B  706  ILE LYS ARG ASN ASN PRO ARG PHE PHE SER ASN GLU LYS          
SEQRES  48 B  706  PHE ILE LYS GLY TYR PHE TYR LYS LEU SER GLU ASP SER          
SEQRES  49 B  706  VAL ILE LEU ALA THR TYR ASN GLN VAL TYR GLU GLY THR          
SEQRES  50 B  706  HIS GLN PRO ILE LYS VAL ARG LYS VAL TYR GLY GLU LEU          
SEQRES  51 B  706  PRO VAL GLU VAL LEU CYS SER GLN ILE LEU SER LEU THR          
SEQRES  52 B  706  LEU MET ASN TYR SER SER PHE GLN PRO ILE LYS LEU PRO          
SEQRES  53 B  706  ALA THR VAL HIS TYR SER ASP LYS ILE THR LYS LEU MET          
SEQRES  54 B  706  LEU ARG GLY ILE GLU PRO ILE LYS LYS GLU GLY ASP ILE          
SEQRES  55 B  706  MET TYR TRP LEU                                              
SEQRES   1 C   22    A   G   A   C   A   G   C   A   U   A   U   A   U          
SEQRES   2 C   22    G   C   U   G   U   C   U   U   U                          
SEQRES   1 D   22    A   G   A   C   A   G   C   A   U   A   U   A   U          
SEQRES   2 D   22    G   C   U   G   U   C   U   U   U                          
FORMUL   5  HOH   *30(H2 O)                                                     
CRYST1   79.697  117.516   98.620  90.00  99.12  90.00 P 1 21 1      4          
ATOM      1  N   LYS A   3      15.411   0.735  38.000  1.00 79.59           N  
ATOM      2  CA  LYS A   3      15.805   0.706  39.446  1.00 80.09           C  
ATOM      3  C   LYS A   3      17.243   0.164  39.704  1.00 80.14           C  
ATOM      4  O   LYS A   3      17.558  -0.294  40.801  1.00 80.64           O  
ATOM      5  CB  LYS A   3      14.720  -0.008  40.297  1.00 79.75           C  
ATOM      6  CG  LYS A   3      15.039  -0.211  41.794  1.00 79.84           C  
ATOM      7  CD  LYS A   3      13.755  -0.319  42.627  1.00 80.62           C  
ATOM      8  CE  LYS A   3      14.014  -0.440  44.123  1.00 79.13           C  
ATOM      9  NZ  LYS A   3      12.756  -0.089  44.797  1.00 76.10           N  
ATOM     10  N   GLU A   4      18.111   0.211  38.699  1.00 79.87           N  
ATOM     11  CA  GLU A   4      19.505  -0.189  38.891  1.00 79.70           C  
ATOM     12  C   GLU A   4      20.331   1.058  38.725  1.00 77.61           C  
ATOM     13  O   GLU A   4      20.265   1.722  37.703  1.00 77.91           O  
ATOM     14  CB  GLU A   4      19.937  -1.263  37.876  1.00 79.48           C  
ATOM     15  CG  GLU A   4      21.478  -1.365  37.646  1.00 82.26           C  
ATOM     16  CD  GLU A   4      21.914  -2.531  36.724  1.00 83.78           C  
ATOM     17  OE1 GLU A   4      21.045  -3.383  36.361  1.00 92.07           O  
ATOM     18  OE2 GLU A   4      23.122  -2.614  36.354  1.00 86.17           O  
ATOM     19  N   ALA A   5      21.106   1.401  39.727  1.00 75.74           N  
ATOM     20  CA  ALA A   5      21.873   2.601  39.600  1.00 73.95           C  
ATOM     21  C   ALA A   5      23.312   2.275  39.814  1.00 72.76           C  
ATOM     22  O   ALA A   5      23.687   1.693  40.813  1.00 71.97           O  
ATOM     23  CB  ALA A   5      21.396   3.656  40.573  1.00 74.22           C  
ATOM     24  N   LEU A   6      24.104   2.673  38.832  1.00 71.86           N  
ATOM     25  CA  LEU A   6      25.540   2.494  38.828  1.00 70.55           C  
ATOM     26  C   LEU A   6      26.216   3.753  39.303  1.00 69.74           C  
ATOM     27  O   LEU A   6      25.727   4.847  39.033  1.00 70.45           O  
ATOM     28  CB  LEU A   6      25.992   2.263  37.397  1.00 70.40           C  
ATOM     29  CG  LEU A   6      25.633   0.905  36.791  1.00 70.23           C  
ATOM     30  CD1 LEU A   6      26.772   0.477  35.893  1.00 70.43           C  
ATOM     31  CD2 LEU A   6      25.378  -0.148  37.854  1.00 67.95           C  
ATOM     32  N   LEU A   7      27.348   3.611  39.984  1.00 67.94           N  
ATOM     33  CA  LEU A   7      28.183   4.758  40.286  1.00 66.32           C  
ATOM     34  C   LEU A   7      29.543   4.636  39.618  1.00 65.46           C  
ATOM     35  O   LEU A   7      30.069   3.528  39.457  1.00 65.01           O  
ATOM     36  CB  LEU A   7      28.328   4.934  41.790  1.00 66.29           C  
ATOM     37  CG  LEU A   7      26.991   5.214  42.491  1.00 67.45           C  
ATOM     38  CD1 LEU A   7      26.340   3.912  42.954  1.00 68.01           C  
ATOM     39  CD2 LEU A   7      27.162   6.172  43.659  1.00 65.61           C  
ATOM     40  N   ASN A   8      30.099   5.781  39.211  1.00 64.38           N  
ATOM     41  CA  ASN A   8      31.469   5.861  38.706  1.00 62.70           C  
ATOM     42  C   ASN A   8      32.533   5.587  39.790  1.00 62.37           C  
ATOM     43  O   ASN A   8      33.448   6.378  40.030  1.00 62.30           O  
ATOM     44  CB  ASN A   8      31.686   7.194  38.006  1.00 62.45           C  
ATOM     45  CG  ASN A   8      31.539   8.380  38.937  1.00 62.76           C  
ATOM     46  OD1 ASN A   8      30.619   8.430  39.751  1.00 63.69           O  
ATOM     47  ND2 ASN A   8      32.448   9.357  38.812  1.00 62.84           N  
ATOM     48  N   LEU A   9      32.400   4.434  40.438  1.00 61.98           N  
ATOM     49  CA  LEU A   9      33.267   4.029  41.531  1.00 61.39           C  
ATOM     50  C   LEU A   9      33.684   2.619  41.206  1.00 61.71           C  
ATOM     51  O   LEU A   9      32.808   1.794  40.974  1.00 62.69           O  
ATOM     52  CB  LEU A   9      32.491   4.029  42.860  1.00 60.94           C  
ATOM     53  CG  LEU A   9      32.456   5.311  43.703  1.00 58.98           C  
ATOM     54  CD1 LEU A   9      31.407   5.284  44.784  1.00 55.72           C  
ATOM     55  CD2 LEU A   9      33.805   5.548  44.305  1.00 58.26           C  
ATOM     56  N   TYR A  10      34.994   2.350  41.189  1.00 61.38           N  
ATOM     57  CA  TYR A  10      35.547   1.075  40.757  1.00 61.36           C  
ATOM     58  C   TYR A  10      36.491   0.480  41.788  1.00 62.50           C  
ATOM     59  O   TYR A  10      37.493   1.091  42.166  1.00 62.59           O  
ATOM     60  CB  TYR A  10      36.278   1.249  39.425  1.00 60.82           C  
ATOM     61  CG  TYR A  10      35.391   1.801  38.352  1.00 59.70           C  
ATOM     62  CD1 TYR A  10      35.364   3.156  38.080  1.00 58.11           C  
ATOM     63  CD2 TYR A  10      34.547   0.970  37.632  1.00 60.55           C  
ATOM     64  CE1 TYR A  10      34.539   3.691  37.100  1.00 57.59           C  
ATOM     65  CE2 TYR A  10      33.702   1.484  36.659  1.00 61.55           C  
ATOM     66  CZ  TYR A  10      33.705   2.859  36.402  1.00 60.25           C  
ATOM     67  OH  TYR A  10      32.877   3.379  35.449  1.00 58.95           O  
ATOM     68  N   ARG A  11      36.170  -0.732  42.242  1.00 63.90           N  
ATOM     69  CA  ARG A  11      37.041  -1.496  43.144  1.00 64.07           C  
ATOM     70  C   ARG A  11      38.449  -1.573  42.601  1.00 63.86           C  
ATOM     71  O   ARG A  11      38.645  -1.758  41.395  1.00 63.94           O  
ATOM     72  CB  ARG A  11      36.514  -2.892  43.329  1.00 63.86           C  
ATOM     73  CG  ARG A  11      36.031  -3.114  44.704  1.00 67.35           C  
ATOM     74  CD  ARG A  11      35.325  -4.443  44.796  1.00 74.38           C  
ATOM     75  NE  ARG A  11      33.916  -4.347  44.415  1.00 77.30           N  
ATOM     76  CZ  ARG A  11      33.024  -5.294  44.657  1.00 77.55           C  
ATOM     77  NH1 ARG A  11      33.399  -6.412  45.269  1.00 78.68           N  
ATOM     78  NH2 ARG A  11      31.766  -5.111  44.306  1.00 77.63           N  
ATOM     79  N   ILE A  12      39.421  -1.424  43.501  1.00 63.46           N  
ATOM     80  CA  ILE A  12      40.817  -1.273  43.127  1.00 62.52           C  
ATOM     81  C   ILE A  12      41.715  -1.742  44.242  1.00 62.80           C  
ATOM     82  O   ILE A  12      41.456  -1.469  45.427  1.00 63.16           O  
ATOM     83  CB  ILE A  12      41.147   0.184  42.778  1.00 62.24           C  
ATOM     84  CG1 ILE A  12      42.650   0.382  42.647  1.00 61.45           C  
ATOM     85  CG2 ILE A  12      40.610   1.115  43.836  1.00 62.17           C  
ATOM     86  CD1 ILE A  12      43.056   1.592  41.824  1.00 62.05           C  
ATOM     87  N   GLU A  13      42.773  -2.460  43.859  1.00 62.75           N  
ATOM     88  CA  GLU A  13      43.815  -2.849  44.796  1.00 62.28           C  
ATOM     89  C   GLU A  13      45.181  -2.935  44.133  1.00 61.76           C  
ATOM     90  O   GLU A  13      45.262  -3.017  42.894  1.00 61.29           O  
ATOM     91  CB  GLU A  13      43.475  -4.170  45.454  1.00 62.56           C  
ATOM     92  CG  GLU A  13      43.219  -5.308  44.483  1.00 63.71           C  
ATOM     93  CD  GLU A  13      43.153  -6.624  45.227  1.00 65.64           C  
ATOM     94  OE1 GLU A  13      43.681  -6.655  46.380  1.00 65.36           O  
ATOM     95  OE2 GLU A  13      42.572  -7.600  44.675  1.00 64.92           O  
ATOM     96  N   TYR A  14      46.228  -2.953  44.984  1.00 61.00           N  
ATOM     97  CA  TYR A  14      47.613  -2.962  44.568  1.00 60.08           C  
ATOM     98  C   TYR A  14      48.348  -4.190  45.089  1.00 60.29           C  
ATOM     99  O   TYR A  14      48.645  -4.309  46.277  1.00 59.89           O  
ATOM    100  CB  TYR A  14      48.289  -1.705  45.073  1.00 59.88           C  
ATOM    101  CG  TYR A  14      49.701  -1.489  44.536  1.00 59.95           C  
ATOM    102  CD1 TYR A  14      49.949  -1.422  43.162  1.00 57.91           C  
ATOM    103  CD2 TYR A  14      50.784  -1.334  45.412  1.00 58.44           C  
ATOM    104  CE1 TYR A  14      51.227  -1.234  42.676  1.00 58.38           C  
ATOM    105  CE2 TYR A  14      52.073  -1.125  44.935  1.00 59.17           C  
ATOM    106  CZ  TYR A  14      52.301  -1.066  43.561  1.00 60.47           C  
ATOM    107  OH  TYR A  14      53.605  -0.846  43.074  1.00 60.95           O  
ATOM    108  N   ARG A  15      48.652  -5.116  44.200  1.00 60.60           N  
ATOM    109  CA  ARG A  15      49.330  -6.319  44.635  1.00 61.49           C  
ATOM    110  C   ARG A  15      50.358  -6.678  43.609  1.00 62.28           C  
ATOM    111  O   ARG A  15      50.102  -7.533  42.754  1.00 62.44           O  
ATOM    112  CB  ARG A  15      48.358  -7.483  44.790  1.00 61.42           C  
ATOM    113  CG  ARG A  15      47.083  -7.170  45.513  1.00 60.33           C  
ATOM    114  CD  ARG A  15      47.267  -7.171  47.003  1.00 60.04           C  
ATOM    115  NE  ARG A  15      46.018  -6.746  47.612  1.00 63.73           N  
ATOM    116  CZ  ARG A  15      45.895  -6.189  48.816  1.00 65.39           C  
ATOM    117  NH1 ARG A  15      46.969  -5.967  49.588  1.00 66.52           N  
ATOM    118  NH2 ARG A  15      44.681  -5.845  49.235  1.00 63.79           N  
ATOM    119  N   PRO A  16      51.520  -6.006  43.668  1.00 63.05           N  
ATOM    120  CA  PRO A  16      52.649  -6.239  42.763  1.00 63.14           C  
ATOM    121  C   PRO A  16      53.546  -7.358  43.243  1.00 63.38           C  
ATOM    122  O   PRO A  16      53.550  -7.698  44.441  1.00 62.80           O  
ATOM    123  CB  PRO A  16      53.409  -4.929  42.835  1.00 63.30           C  
ATOM    124  CG  PRO A  16      53.187  -4.480  44.259  1.00 63.43           C  
ATOM    125  CD  PRO A  16      51.804  -4.928  44.634  1.00 63.15           C  
ATOM    126  N   LYS A  17      54.296  -7.920  42.300  1.00 63.92           N  
ATOM    127  CA  LYS A  17      55.338  -8.902  42.605  1.00 64.91           C  
ATOM    128  C   LYS A  17      56.516  -8.276  43.375  1.00 65.44           C  
ATOM    129  O   LYS A  17      56.940  -8.813  44.384  1.00 66.04           O  
ATOM    130  CB  LYS A  17      55.813  -9.545  41.320  1.00 64.38           C  
ATOM    131  CG  LYS A  17      54.708  -9.555  40.337  1.00 66.16           C  
ATOM    132  CD  LYS A  17      55.107 -10.119  39.026  1.00 69.59           C  
ATOM    133  CE  LYS A  17      53.853 -10.575  38.293  1.00 72.45           C  
ATOM    134  NZ  LYS A  17      54.227 -11.737  37.412  1.00 77.81           N  
ATOM    135  N   ASP A  18      57.044  -7.147  42.902  1.00 66.10           N  
ATOM    136  CA  ASP A  18      58.019  -6.390  43.667  1.00 66.40           C  
ATOM    137  C   ASP A  18      57.270  -5.649  44.768  1.00 66.53           C  
ATOM    138  O   ASP A  18      56.339  -4.902  44.488  1.00 66.71           O  
ATOM    139  CB  ASP A  18      58.742  -5.396  42.762  1.00 66.62           C  
ATOM    140  CG  ASP A  18      60.097  -4.959  43.323  1.00 67.61           C  
ATOM    141  OD1 ASP A  18      60.240  -4.821  44.574  1.00 67.96           O  
ATOM    142  OD2 ASP A  18      61.016  -4.739  42.491  1.00 67.23           O  
ATOM    143  N   THR A  19      57.697  -5.851  46.011  1.00 66.48           N  
ATOM    144  CA  THR A  19      56.995  -5.338  47.179  1.00 66.40           C  
ATOM    145  C   THR A  19      57.912  -4.429  48.017  1.00 66.75           C  
ATOM    146  O   THR A  19      57.680  -4.199  49.216  1.00 66.72           O  
ATOM    147  CB  THR A  19      56.478  -6.547  47.952  1.00 66.14           C  
ATOM    148  OG1 THR A  19      55.328  -7.010  47.270  1.00 66.58           O  
ATOM    149  CG2 THR A  19      56.076  -6.240  49.366  1.00 65.98           C  
ATOM    150  N   THR A  20      58.943  -3.885  47.365  1.00 66.75           N  
ATOM    151  CA  THR A  20      60.084  -3.307  48.076  1.00 66.37           C  
ATOM    152  C   THR A  20      60.229  -1.831  47.882  1.00 65.44           C  
ATOM    153  O   THR A  20      60.669  -1.375  46.833  1.00 65.23           O  
ATOM    154  CB  THR A  20      61.369  -3.929  47.604  1.00 66.86           C  
ATOM    155  OG1 THR A  20      61.109  -5.282  47.188  1.00 68.44           O  
ATOM    156  CG2 THR A  20      62.407  -3.887  48.720  1.00 66.93           C  
ATOM    157  N   PHE A  21      59.884  -1.107  48.934  1.00 64.55           N  
ATOM    158  CA  PHE A  21      59.904   0.342  48.964  1.00 63.84           C  
ATOM    159  C   PHE A  21      61.123   0.843  49.698  1.00 63.36           C  
ATOM    160  O   PHE A  21      61.697   0.127  50.502  1.00 63.88           O  
ATOM    161  CB  PHE A  21      58.658   0.828  49.690  1.00 63.57           C  
ATOM    162  CG  PHE A  21      57.439   0.739  48.866  1.00 63.63           C  
ATOM    163  CD1 PHE A  21      57.034  -0.485  48.328  1.00 63.61           C  
ATOM    164  CD2 PHE A  21      56.707   1.885  48.570  1.00 63.01           C  
ATOM    165  CE1 PHE A  21      55.890  -0.571  47.527  1.00 63.52           C  
ATOM    166  CE2 PHE A  21      55.573   1.810  47.778  1.00 62.46           C  
ATOM    167  CZ  PHE A  21      55.160   0.578  47.259  1.00 63.01           C  
ATOM    168  N   THR A  22      61.530   2.068  49.432  1.00 62.53           N  
ATOM    169  CA  THR A  22      62.554   2.657  50.249  1.00 62.09           C  
ATOM    170  C   THR A  22      61.871   3.732  51.056  1.00 62.36           C  
ATOM    171  O   THR A  22      61.040   4.489  50.533  1.00 62.95           O  
ATOM    172  CB  THR A  22      63.692   3.201  49.417  1.00 61.82           C  
ATOM    173  OG1 THR A  22      64.169   2.176  48.535  1.00 61.78           O  
ATOM    174  CG2 THR A  22      64.821   3.605  50.312  1.00 62.34           C  
ATOM    175  N   VAL A  23      62.181   3.780  52.344  1.00 62.27           N  
ATOM    176  CA  VAL A  23      61.440   4.636  53.260  1.00 62.21           C  
ATOM    177  C   VAL A  23      62.353   5.708  53.839  1.00 62.49           C  
ATOM    178  O   VAL A  23      63.542   5.482  54.032  1.00 62.59           O  
ATOM    179  CB  VAL A  23      60.746   3.809  54.377  1.00 62.22           C  
ATOM    180  CG1 VAL A  23      59.771   4.670  55.192  1.00 61.85           C  
ATOM    181  CG2 VAL A  23      60.012   2.608  53.781  1.00 61.79           C  
ATOM    182  N   PHE A  24      61.777   6.876  54.110  1.00 62.72           N  
ATOM    183  CA  PHE A  24      62.522   8.049  54.504  1.00 62.88           C  
ATOM    184  C   PHE A  24      61.803   8.742  55.628  1.00 63.68           C  
ATOM    185  O   PHE A  24      60.581   8.789  55.645  1.00 63.90           O  
ATOM    186  CB  PHE A  24      62.625   8.990  53.322  1.00 62.43           C  
ATOM    187  CG  PHE A  24      63.421   8.437  52.183  1.00 61.83           C  
ATOM    188  CD1 PHE A  24      62.839   7.566  51.269  1.00 60.23           C  
ATOM    189  CD2 PHE A  24      64.762   8.792  52.022  1.00 61.91           C  
ATOM    190  CE1 PHE A  24      63.565   7.051  50.219  1.00 60.37           C  
ATOM    191  CE2 PHE A  24      65.508   8.283  50.969  1.00 61.94           C  
ATOM    192  CZ  PHE A  24      64.907   7.402  50.066  1.00 61.79           C  
ATOM    193  N   LYS A  25      62.564   9.300  56.557  1.00 64.75           N  
ATOM    194  CA  LYS A  25      62.004   9.864  57.768  1.00 66.07           C  
ATOM    195  C   LYS A  25      62.581  11.257  57.953  1.00 66.89           C  
ATOM    196  O   LYS A  25      63.767  11.459  57.729  1.00 67.12           O  
ATOM    197  CB  LYS A  25      62.382   8.972  58.948  1.00 66.31           C  
ATOM    198  CG  LYS A  25      61.477   9.051  60.177  1.00 66.70           C  
ATOM    199  CD  LYS A  25      62.010   8.149  61.312  1.00 66.60           C  
ATOM    200  CE  LYS A  25      63.467   8.486  61.716  1.00 66.72           C  
ATOM    201  NZ  LYS A  25      63.661   9.923  62.131  1.00 66.10           N  
ATOM    202  N   PRO A  26      61.742  12.229  58.346  1.00 67.71           N  
ATOM    203  CA  PRO A  26      62.186  13.611  58.487  1.00 68.34           C  
ATOM    204  C   PRO A  26      63.090  13.749  59.678  1.00 69.05           C  
ATOM    205  O   PRO A  26      63.068  12.898  60.563  1.00 69.37           O  
ATOM    206  CB  PRO A  26      60.881  14.392  58.723  1.00 68.32           C  
ATOM    207  CG  PRO A  26      59.772  13.455  58.348  1.00 68.53           C  
ATOM    208  CD  PRO A  26      60.316  12.088  58.666  1.00 68.18           C  
ATOM    209  N   THR A  27      63.882  14.811  59.695  1.00 69.88           N  
ATOM    210  CA  THR A  27      64.910  14.951  60.707  1.00 71.00           C  
ATOM    211  C   THR A  27      64.407  15.858  61.796  1.00 71.70           C  
ATOM    212  O   THR A  27      65.098  16.077  62.809  1.00 71.96           O  
ATOM    213  CB  THR A  27      66.204  15.550  60.128  1.00 71.07           C  
ATOM    214  OG1 THR A  27      66.005  16.944  59.835  1.00 71.26           O  
ATOM    215  CG2 THR A  27      66.642  14.782  58.876  1.00 70.88           C  
ATOM    216  N   HIS A  28      63.205  16.386  61.569  1.00 72.06           N  
ATOM    217  CA  HIS A  28      62.611  17.417  62.409  1.00 72.57           C  
ATOM    218  C   HIS A  28      61.132  17.424  62.084  1.00 72.99           C  
ATOM    219  O   HIS A  28      60.746  17.728  60.955  1.00 73.48           O  
ATOM    220  CB  HIS A  28      63.385  18.755  62.222  1.00 72.47           C  
ATOM    221  CG  HIS A  28      62.571  19.944  61.803  1.00 73.03           C  
ATOM    222  ND1 HIS A  28      61.247  20.127  62.141  1.00 73.62           N  
ATOM    223  CD2 HIS A  28      62.936  21.055  61.116  1.00 74.08           C  
ATOM    224  CE1 HIS A  28      60.816  21.272  61.641  1.00 73.76           C  
ATOM    225  NE2 HIS A  28      61.823  21.858  61.019  1.00 74.47           N  
ATOM    226  N   GLU A  29      60.307  17.029  63.054  1.00 73.39           N  
ATOM    227  CA  GLU A  29      58.878  16.771  62.806  1.00 74.20           C  
ATOM    228  C   GLU A  29      58.215  17.801  61.871  1.00 74.34           C  
ATOM    229  O   GLU A  29      58.181  18.998  62.197  1.00 74.49           O  
ATOM    230  CB  GLU A  29      58.102  16.684  64.122  1.00 74.42           C  
ATOM    231  CG  GLU A  29      56.888  15.749  64.051  1.00 75.38           C  
ATOM    232  CD  GLU A  29      55.587  16.407  64.511  1.00 76.70           C  
ATOM    233  OE1 GLU A  29      55.639  17.512  65.117  1.00 75.34           O  
ATOM    234  OE2 GLU A  29      54.508  15.812  64.242  1.00 77.03           O  
ATOM    235  N   ILE A  30      57.701  17.340  60.721  1.00 74.42           N  
ATOM    236  CA  ILE A  30      57.128  18.246  59.702  1.00 74.47           C  
ATOM    237  C   ILE A  30      55.802  18.846  60.124  1.00 74.67           C  
ATOM    238  O   ILE A  30      54.921  18.158  60.631  1.00 74.09           O  
ATOM    239  CB  ILE A  30      56.946  17.612  58.297  1.00 74.15           C  
ATOM    240  CG1 ILE A  30      58.206  16.867  57.865  1.00 74.87           C  
ATOM    241  CG2 ILE A  30      56.618  18.697  57.267  1.00 73.87           C  
ATOM    242  CD1 ILE A  30      58.144  16.272  56.463  1.00 74.66           C  
ATOM    243  N   GLN A  31      55.685  20.150  59.903  1.00 75.40           N  
ATOM    244  CA  GLN A  31      54.463  20.866  60.169  1.00 76.16           C  
ATOM    245  C   GLN A  31      53.430  20.375  59.158  1.00 76.01           C  
ATOM    246  O   GLN A  31      53.764  20.092  58.015  1.00 75.65           O  
ATOM    247  CB  GLN A  31      54.744  22.359  60.083  1.00 76.38           C  
ATOM    248  CG  GLN A  31      53.544  23.272  60.220  1.00 79.05           C  
ATOM    249  CD  GLN A  31      53.849  24.671  59.678  1.00 83.02           C  
ATOM    250  OE1 GLN A  31      54.699  25.397  60.234  1.00 84.76           O  
ATOM    251  NE2 GLN A  31      53.162  25.058  58.585  1.00 82.81           N  
ATOM    252  N   LYS A  32      52.184  20.263  59.597  1.00 76.65           N  
ATOM    253  CA  LYS A  32      51.163  19.478  58.888  1.00 77.48           C  
ATOM    254  C   LYS A  32      50.872  19.930  57.463  1.00 77.27           C  
ATOM    255  O   LYS A  32      50.856  19.127  56.523  1.00 77.38           O  
ATOM    256  CB  LYS A  32      49.869  19.457  59.692  1.00 77.71           C  
ATOM    257  CG  LYS A  32      50.107  19.413  61.196  1.00 80.92           C  
ATOM    258  CD  LYS A  32      49.113  18.461  61.856  1.00 84.81           C  
ATOM    259  CE  LYS A  32      49.114  18.600  63.372  1.00 85.51           C  
ATOM    260  NZ  LYS A  32      48.039  17.716  63.896  1.00 86.58           N  
ATOM    261  N   GLU A  33      50.660  21.227  57.306  1.00 77.00           N  
ATOM    262  CA  GLU A  33      50.331  21.790  56.011  1.00 76.54           C  
ATOM    263  C   GLU A  33      51.549  21.842  55.104  1.00 75.21           C  
ATOM    264  O   GLU A  33      51.450  22.276  53.965  1.00 75.55           O  
ATOM    265  CB  GLU A  33      49.697  23.175  56.176  1.00 77.35           C  
ATOM    266  CG  GLU A  33      50.248  24.004  57.369  1.00 80.43           C  
ATOM    267  CD  GLU A  33      49.136  24.732  58.146  1.00 84.41           C  
ATOM    268  OE1 GLU A  33      48.534  25.694  57.595  1.00 86.57           O  
ATOM    269  OE2 GLU A  33      48.862  24.333  59.308  1.00 84.68           O  
ATOM    270  N   LYS A  34      52.691  21.397  55.611  1.00 73.34           N  
ATOM    271  CA  LYS A  34      53.857  21.195  54.769  1.00 71.94           C  
ATOM    272  C   LYS A  34      53.955  19.771  54.203  1.00 71.04           C  
ATOM    273  O   LYS A  34      54.815  19.494  53.361  1.00 70.71           O  
ATOM    274  CB  LYS A  34      55.138  21.527  55.533  1.00 71.97           C  
ATOM    275  CG  LYS A  34      55.424  23.008  55.696  1.00 71.22           C  
ATOM    276  CD  LYS A  34      56.607  23.209  56.628  1.00 69.85           C  
ATOM    277  CE  LYS A  34      56.727  24.642  57.045  1.00 69.22           C  
ATOM    278  NZ  LYS A  34      57.905  24.798  57.915  1.00 68.92           N  
ATOM    279  N   LEU A  35      53.078  18.871  54.644  1.00 70.00           N  
ATOM    280  CA  LEU A  35      53.238  17.433  54.316  1.00 68.90           C  
ATOM    281  C   LEU A  35      53.056  17.033  52.827  1.00 68.04           C  
ATOM    282  O   LEU A  35      53.980  16.422  52.254  1.00 67.92           O  
ATOM    283  CB  LEU A  35      52.397  16.541  55.241  1.00 68.84           C  
ATOM    284  CG  LEU A  35      52.796  16.498  56.723  1.00 68.70           C  
ATOM    285  CD1 LEU A  35      51.671  15.898  57.549  1.00 67.71           C  
ATOM    286  CD2 LEU A  35      54.120  15.751  56.956  1.00 67.69           C  
ATOM    287  N   ASN A  36      51.907  17.395  52.220  1.00 66.23           N  
ATOM    288  CA  ASN A  36      51.652  17.197  50.778  1.00 64.84           C  
ATOM    289  C   ASN A  36      52.669  17.825  49.794  1.00 64.91           C  
ATOM    290  O   ASN A  36      52.838  17.330  48.665  1.00 65.33           O  
ATOM    291  CB  ASN A  36      50.274  17.712  50.397  1.00 64.30           C  
ATOM    292  CG  ASN A  36      49.139  16.899  50.992  1.00 62.77           C  
ATOM    293  OD1 ASN A  36      49.350  15.879  51.648  1.00 63.03           O  
ATOM    294  ND2 ASN A  36      47.913  17.358  50.757  1.00 58.82           N  
ATOM    295  N   LYS A  37      53.322  18.917  50.210  1.00 64.13           N  
ATOM    296  CA  LYS A  37      54.342  19.599  49.399  1.00 63.04           C  
ATOM    297  C   LYS A  37      55.667  18.872  49.468  1.00 62.41           C  
ATOM    298  O   LYS A  37      56.452  18.900  48.528  1.00 62.36           O  
ATOM    299  CB  LYS A  37      54.535  21.049  49.850  1.00 62.86           C  
ATOM    300  CG  LYS A  37      53.244  21.803  50.011  1.00 62.88           C  
ATOM    301  CD  LYS A  37      53.403  23.258  49.737  1.00 62.67           C  
ATOM    302  CE  LYS A  37      52.207  23.984  50.293  1.00 63.65           C  
ATOM    303  NZ  LYS A  37      51.948  25.232  49.534  1.00 65.94           N  
ATOM    304  N   VAL A  38      55.920  18.236  50.597  1.00 61.83           N  
ATOM    305  CA  VAL A  38      57.117  17.437  50.741  1.00 61.24           C  
ATOM    306  C   VAL A  38      56.971  16.179  49.907  1.00 60.85           C  
ATOM    307  O   VAL A  38      57.847  15.872  49.091  1.00 60.13           O  
ATOM    308  CB  VAL A  38      57.371  17.076  52.206  1.00 61.34           C  
ATOM    309  CG1 VAL A  38      58.494  16.091  52.305  1.00 61.02           C  
ATOM    310  CG2 VAL A  38      57.705  18.327  53.005  1.00 60.92           C  
ATOM    311  N   ARG A  39      55.843  15.484  50.111  1.00 60.80           N  
ATOM    312  CA  ARG A  39      55.515  14.230  49.404  1.00 60.72           C  
ATOM    313  C   ARG A  39      55.662  14.378  47.894  1.00 60.57           C  
ATOM    314  O   ARG A  39      56.482  13.682  47.251  1.00 60.41           O  
ATOM    315  CB  ARG A  39      54.093  13.755  49.712  1.00 60.62           C  
ATOM    316  CG  ARG A  39      53.792  12.369  49.132  1.00 60.48           C  
ATOM    317  CD  ARG A  39      52.350  12.230  48.665  1.00 61.05           C  
ATOM    318  NE  ARG A  39      52.097  12.974  47.430  1.00 64.56           N  
ATOM    319  CZ  ARG A  39      52.592  12.662  46.220  1.00 66.02           C  
ATOM    320  NH1 ARG A  39      53.391  11.614  46.032  1.00 64.63           N  
ATOM    321  NH2 ARG A  39      52.285  13.416  45.176  1.00 67.39           N  
ATOM    322  N   TRP A  40      54.868  15.295  47.339  1.00 59.70           N  
ATOM    323  CA  TRP A  40      55.025  15.677  45.956  1.00 59.04           C  
ATOM    324  C   TRP A  40      56.521  15.930  45.575  1.00 58.43           C  
ATOM    325  O   TRP A  40      57.025  15.387  44.592  1.00 57.37           O  
ATOM    326  CB  TRP A  40      54.143  16.880  45.686  1.00 59.36           C  
ATOM    327  CG  TRP A  40      54.549  17.629  44.490  1.00 59.86           C  
ATOM    328  CD1 TRP A  40      55.142  18.860  44.453  1.00 59.57           C  
ATOM    329  CD2 TRP A  40      54.426  17.192  43.142  1.00 60.12           C  
ATOM    330  NE1 TRP A  40      55.389  19.211  43.161  1.00 60.78           N  
ATOM    331  CE2 TRP A  40      54.955  18.208  42.330  1.00 60.75           C  
ATOM    332  CE3 TRP A  40      53.898  16.041  42.535  1.00 60.87           C  
ATOM    333  CZ2 TRP A  40      54.976  18.116  40.936  1.00 60.43           C  
ATOM    334  CZ3 TRP A  40      53.916  15.947  41.150  1.00 60.17           C  
ATOM    335  CH2 TRP A  40      54.459  16.976  40.368  1.00 60.08           C  
ATOM    336  N   ARG A  41      57.228  16.716  46.384  1.00 58.11           N  
ATOM    337  CA  ARG A  41      58.633  16.990  46.117  1.00 57.95           C  
ATOM    338  C   ARG A  41      59.471  15.735  46.127  1.00 57.68           C  
ATOM    339  O   ARG A  41      60.429  15.622  45.345  1.00 57.63           O  
ATOM    340  CB  ARG A  41      59.202  18.024  47.079  1.00 58.13           C  
ATOM    341  CG  ARG A  41      59.228  19.414  46.498  1.00 58.75           C  
ATOM    342  CD  ARG A  41      59.036  20.443  47.577  1.00 62.72           C  
ATOM    343  NE  ARG A  41      58.718  21.757  47.028  1.00 66.63           N  
ATOM    344  CZ  ARG A  41      57.485  22.188  46.757  1.00 68.70           C  
ATOM    345  NH1 ARG A  41      56.416  21.414  46.988  1.00 66.65           N  
ATOM    346  NH2 ARG A  41      57.326  23.411  46.252  1.00 69.43           N  
ATOM    347  N   VAL A  42      59.107  14.783  46.987  1.00 57.30           N  
ATOM    348  CA  VAL A  42      59.809  13.489  47.006  1.00 56.62           C  
ATOM    349  C   VAL A  42      59.613  12.728  45.699  1.00 56.07           C  
ATOM    350  O   VAL A  42      60.565  12.189  45.159  1.00 55.01           O  
ATOM    351  CB  VAL A  42      59.407  12.613  48.200  1.00 56.60           C  
ATOM    352  CG1 VAL A  42      60.017  11.222  48.075  1.00 56.98           C  
ATOM    353  CG2 VAL A  42      59.854  13.250  49.488  1.00 56.01           C  
ATOM    354  N   PHE A  43      58.381  12.716  45.185  1.00 56.32           N  
ATOM    355  CA  PHE A  43      58.085  12.019  43.916  1.00 56.50           C  
ATOM    356  C   PHE A  43      58.949  12.540  42.762  1.00 56.86           C  
ATOM    357  O   PHE A  43      59.613  11.737  42.098  1.00 57.06           O  
ATOM    358  CB  PHE A  43      56.578  12.020  43.588  1.00 56.12           C  
ATOM    359  CG  PHE A  43      56.243  11.634  42.165  1.00 55.89           C  
ATOM    360  CD1 PHE A  43      56.525  10.359  41.676  1.00 56.43           C  
ATOM    361  CD2 PHE A  43      55.601  12.535  41.324  1.00 55.55           C  
ATOM    362  CE1 PHE A  43      56.194  10.003  40.364  1.00 55.72           C  
ATOM    363  CE2 PHE A  43      55.283  12.198  40.010  1.00 55.01           C  
ATOM    364  CZ  PHE A  43      55.570  10.926  39.536  1.00 55.66           C  
ATOM    365  N   LEU A  44      58.979  13.868  42.568  1.00 56.91           N  
ATOM    366  CA  LEU A  44      59.794  14.488  41.519  1.00 57.04           C  
ATOM    367  C   LEU A  44      61.208  13.995  41.586  1.00 57.11           C  
ATOM    368  O   LEU A  44      61.708  13.427  40.619  1.00 56.60           O  
ATOM    369  CB  LEU A  44      59.812  16.000  41.638  1.00 57.02           C  
ATOM    370  CG  LEU A  44      58.469  16.726  41.656  1.00 59.24           C  
ATOM    371  CD1 LEU A  44      58.656  18.218  41.335  1.00 59.13           C  
ATOM    372  CD2 LEU A  44      57.446  16.065  40.707  1.00 59.73           C  
ATOM    373  N   GLN A  45      61.824  14.193  42.751  1.00 57.70           N  
ATOM    374  CA  GLN A  45      63.243  13.914  42.960  1.00 58.52           C  
ATOM    375  C   GLN A  45      63.569  12.472  42.672  1.00 58.56           C  
ATOM    376  O   GLN A  45      64.230  12.162  41.679  1.00 59.08           O  
ATOM    377  CB  GLN A  45      63.657  14.234  44.393  1.00 58.84           C  
ATOM    378  CG  GLN A  45      63.685  15.730  44.736  1.00 59.91           C  
ATOM    379  CD  GLN A  45      64.833  16.087  45.678  1.00 60.01           C  
ATOM    380  OE1 GLN A  45      65.952  15.594  45.507  1.00 59.08           O  
ATOM    381  NE2 GLN A  45      64.564  16.959  46.663  1.00 59.39           N  
ATOM    382  N   THR A  46      63.081  11.607  43.556  1.00 58.70           N  
ATOM    383  CA  THR A  46      63.164  10.153  43.438  1.00 58.37           C  
ATOM    384  C   THR A  46      62.788   9.683  42.056  1.00 58.02           C  
ATOM    385  O   THR A  46      63.433   8.811  41.524  1.00 57.70           O  
ATOM    386  CB  THR A  46      62.198   9.458  44.417  1.00 58.43           C  
ATOM    387  OG1 THR A  46      62.426   9.922  45.748  1.00 58.37           O  
ATOM    388  CG2 THR A  46      62.451   8.014  44.412  1.00 60.11           C  
ATOM    389  N   GLY A  47      61.736  10.258  41.482  1.00 58.03           N  
ATOM    390  CA  GLY A  47      61.162   9.723  40.256  1.00 57.99           C  
ATOM    391  C   GLY A  47      60.152   8.618  40.526  1.00 58.27           C  
ATOM    392  O   GLY A  47      59.349   8.299  39.655  1.00 58.82           O  
ATOM    393  N   LEU A  48      60.158   8.038  41.728  1.00 58.19           N  
ATOM    394  CA  LEU A  48      59.313   6.876  41.998  1.00 58.13           C  
ATOM    395  C   LEU A  48      58.037   7.269  42.677  1.00 58.60           C  
ATOM    396  O   LEU A  48      58.053   8.186  43.473  1.00 59.00           O  
ATOM    397  CB  LEU A  48      60.033   5.866  42.886  1.00 57.72           C  
ATOM    398  CG  LEU A  48      61.412   5.416  42.425  1.00 56.49           C  
ATOM    399  CD1 LEU A  48      62.134   4.863  43.623  1.00 55.93           C  
ATOM    400  CD2 LEU A  48      61.348   4.414  41.271  1.00 54.98           C  
ATOM    401  N   PRO A  49      56.921   6.569  42.372  1.00 59.17           N  
ATOM    402  CA  PRO A  49      55.691   6.720  43.160  1.00 59.47           C  
ATOM    403  C   PRO A  49      55.953   6.668  44.666  1.00 60.15           C  
ATOM    404  O   PRO A  49      56.927   6.052  45.124  1.00 59.81           O  
ATOM    405  CB  PRO A  49      54.842   5.528  42.719  1.00 58.89           C  
ATOM    406  CG  PRO A  49      55.253   5.283  41.340  1.00 58.68           C  
ATOM    407  CD  PRO A  49      56.724   5.627  41.253  1.00 59.05           C  
ATOM    408  N   THR A  50      55.074   7.322  45.418  1.00 60.90           N  
ATOM    409  CA  THR A  50      55.351   7.689  46.792  1.00 61.69           C  
ATOM    410  C   THR A  50      54.084   7.940  47.565  1.00 62.09           C  
ATOM    411  O   THR A  50      53.231   8.707  47.102  1.00 62.66           O  
ATOM    412  CB  THR A  50      56.131   9.015  46.814  1.00 61.69           C  
ATOM    413  OG1 THR A  50      57.365   8.855  46.104  1.00 61.99           O  
ATOM    414  CG2 THR A  50      56.406   9.474  48.244  1.00 61.51           C  
ATOM    415  N   PHE A  51      53.954   7.316  48.737  1.00 62.43           N  
ATOM    416  CA  PHE A  51      52.852   7.656  49.657  1.00 62.52           C  
ATOM    417  C   PHE A  51      53.375   7.980  51.048  1.00 62.78           C  
ATOM    418  O   PHE A  51      54.474   7.571  51.424  1.00 62.87           O  
ATOM    419  CB  PHE A  51      51.734   6.586  49.694  1.00 62.61           C  
ATOM    420  CG  PHE A  51      52.174   5.235  50.229  1.00 62.65           C  
ATOM    421  CD1 PHE A  51      52.432   5.049  51.593  1.00 62.89           C  
ATOM    422  CD2 PHE A  51      52.310   4.149  49.369  1.00 62.33           C  
ATOM    423  CE1 PHE A  51      52.841   3.826  52.080  1.00 62.74           C  
ATOM    424  CE2 PHE A  51      52.710   2.911  49.840  1.00 62.18           C  
ATOM    425  CZ  PHE A  51      52.978   2.744  51.198  1.00 63.56           C  
ATOM    426  N   ARG A  52      52.575   8.729  51.792  1.00 63.33           N  
ATOM    427  CA  ARG A  52      52.903   9.145  53.138  1.00 64.32           C  
ATOM    428  C   ARG A  52      52.312   8.126  54.078  1.00 65.09           C  
ATOM    429  O   ARG A  52      51.087   7.940  54.105  1.00 64.99           O  
ATOM    430  CB  ARG A  52      52.265  10.514  53.423  1.00 64.72           C  
ATOM    431  CG  ARG A  52      53.007  11.439  54.388  1.00 64.20           C  
ATOM    432  CD  ARG A  52      52.228  12.724  54.570  1.00 64.04           C  
ATOM    433  NE  ARG A  52      51.079  12.493  55.435  1.00 65.82           N  
ATOM    434  CZ  ARG A  52      49.826  12.876  55.183  1.00 68.58           C  
ATOM    435  NH1 ARG A  52      49.496  13.558  54.083  1.00 70.44           N  
ATOM    436  NH2 ARG A  52      48.883  12.590  56.063  1.00 69.42           N  
ATOM    437  N   ARG A  53      53.174   7.449  54.832  1.00 66.18           N  
ATOM    438  CA  ARG A  53      52.710   6.629  55.939  1.00 67.33           C  
ATOM    439  C   ARG A  53      53.173   7.261  57.227  1.00 68.44           C  
ATOM    440  O   ARG A  53      54.333   7.080  57.621  1.00 68.91           O  
ATOM    441  CB  ARG A  53      53.213   5.186  55.846  1.00 67.13           C  
ATOM    442  CG  ARG A  53      52.683   4.322  56.983  1.00 66.32           C  
ATOM    443  CD  ARG A  53      52.596   2.874  56.616  1.00 64.50           C  
ATOM    444  NE  ARG A  53      51.476   2.638  55.724  1.00 63.43           N  
ATOM    445  CZ  ARG A  53      51.392   1.596  54.907  1.00 63.59           C  
ATOM    446  NH1 ARG A  53      52.385   0.689  54.883  1.00 62.68           N  
ATOM    447  NH2 ARG A  53      50.331   1.470  54.110  1.00 61.35           N  
ATOM    448  N   GLU A  54      52.271   7.997  57.879  1.00 69.56           N  
ATOM    449  CA  GLU A  54      52.585   8.668  59.145  1.00 71.20           C  
ATOM    450  C   GLU A  54      53.580   9.802  58.906  1.00 71.17           C  
ATOM    451  O   GLU A  54      53.384  10.642  58.035  1.00 71.52           O  
ATOM    452  CB  GLU A  54      53.168   7.672  60.185  1.00 71.91           C  
ATOM    453  CG  GLU A  54      52.189   6.652  60.762  1.00 74.60           C  
ATOM    454  CD  GLU A  54      50.918   7.309  61.300  1.00 79.76           C  
ATOM    455  OE1 GLU A  54      51.022   8.382  61.964  1.00 79.81           O  
ATOM    456  OE2 GLU A  54      49.813   6.753  61.042  1.00 83.04           O  
ATOM    457  N   ASP A  55      54.657   9.810  59.674  1.00 70.95           N  
ATOM    458  CA  ASP A  55      55.735  10.748  59.429  1.00 71.00           C  
ATOM    459  C   ASP A  55      56.657  10.288  58.281  1.00 70.88           C  
ATOM    460  O   ASP A  55      57.512  11.070  57.845  1.00 71.60           O  
ATOM    461  CB  ASP A  55      56.551  11.027  60.719  1.00 71.03           C  
ATOM    462  CG  ASP A  55      56.697   9.784  61.641  1.00 70.77           C  
ATOM    463  OD1 ASP A  55      56.024   8.732  61.425  1.00 68.84           O  
ATOM    464  OD2 ASP A  55      57.484   9.886  62.610  1.00 70.21           O  
ATOM    465  N   GLU A  56      56.487   9.057  57.787  1.00 69.67           N  
ATOM    466  CA  GLU A  56      57.454   8.473  56.859  1.00 69.10           C  
ATOM    467  C   GLU A  56      56.998   8.369  55.398  1.00 68.79           C  
ATOM    468  O   GLU A  56      55.803   8.384  55.092  1.00 69.31           O  
ATOM    469  CB  GLU A  56      57.893   7.118  57.364  1.00 69.36           C  
ATOM    470  CG  GLU A  56      58.356   7.160  58.797  1.00 71.02           C  
ATOM    471  CD  GLU A  56      59.088   5.906  59.227  1.00 73.37           C  
ATOM    472  OE1 GLU A  56      58.614   4.785  58.886  1.00 73.88           O  
ATOM    473  OE2 GLU A  56      60.132   6.055  59.916  1.00 73.97           O  
ATOM    474  N   PHE A  57      57.964   8.260  54.495  1.00 67.70           N  
ATOM    475  CA  PHE A  57      57.695   8.426  53.082  1.00 66.68           C  
ATOM    476  C   PHE A  57      58.139   7.184  52.327  1.00 66.70           C  
ATOM    477  O   PHE A  57      59.303   6.786  52.389  1.00 66.40           O  
ATOM    478  CB  PHE A  57      58.421   9.669  52.552  1.00 66.44           C  
ATOM    479  CG  PHE A  57      57.882  10.980  53.082  1.00 65.62           C  
ATOM    480  CD1 PHE A  57      58.277  11.468  54.314  1.00 64.69           C  
ATOM    481  CD2 PHE A  57      56.989  11.739  52.329  1.00 66.73           C  
ATOM    482  CE1 PHE A  57      57.779  12.682  54.795  1.00 65.63           C  
ATOM    483  CE2 PHE A  57      56.477  12.963  52.802  1.00 66.28           C  
ATOM    484  CZ  PHE A  57      56.870  13.431  54.033  1.00 65.85           C  
ATOM    485  N   TRP A  58      57.213   6.579  51.591  1.00 66.81           N  
ATOM    486  CA  TRP A  58      57.461   5.269  50.988  1.00 66.84           C  
ATOM    487  C   TRP A  58      57.642   5.310  49.464  1.00 66.76           C  
ATOM    488  O   TRP A  58      56.708   5.709  48.758  1.00 66.74           O  
ATOM    489  CB  TRP A  58      56.320   4.326  51.371  1.00 66.87           C  
ATOM    490  CG  TRP A  58      56.339   3.868  52.802  1.00 66.77           C  
ATOM    491  CD1 TRP A  58      56.345   4.653  53.933  1.00 67.76           C  
ATOM    492  CD2 TRP A  58      56.332   2.522  53.255  1.00 67.10           C  
ATOM    493  NE1 TRP A  58      56.363   3.867  55.060  1.00 67.32           N  
ATOM    494  CE2 TRP A  58      56.349   2.554  54.672  1.00 67.38           C  
ATOM    495  CE3 TRP A  58      56.311   1.283  52.603  1.00 67.22           C  
ATOM    496  CZ2 TRP A  58      56.346   1.393  55.444  1.00 67.28           C  
ATOM    497  CZ3 TRP A  58      56.306   0.131  53.372  1.00 67.24           C  
ATOM    498  CH2 TRP A  58      56.322   0.195  54.779  1.00 67.09           C  
ATOM    499  N   CYS A  59      58.817   4.871  48.980  1.00 66.27           N  
ATOM    500  CA  CYS A  59      59.185   4.920  47.553  1.00 66.34           C  
ATOM    501  C   CYS A  59      59.155   3.599  46.801  1.00 65.76           C  
ATOM    502  O   CYS A  59      60.037   2.764  46.960  1.00 65.70           O  
ATOM    503  CB  CYS A  59      60.572   5.521  47.387  1.00 66.40           C  
ATOM    504  SG  CYS A  59      60.654   7.216  47.955  1.00 70.77           S  
ATOM    505  N   ALA A  60      58.146   3.441  45.945  1.00 65.78           N  
ATOM    506  CA  ALA A  60      57.962   2.259  45.080  1.00 65.24           C  
ATOM    507  C   ALA A  60      59.159   2.027  44.141  1.00 65.21           C  
ATOM    508  O   ALA A  60      59.041   2.101  42.909  1.00 65.31           O  
ATOM    509  CB  ALA A  60      56.654   2.382  44.290  1.00 64.41           C  
ATOM    510  N   GLY A  61      60.311   1.758  44.748  1.00 64.88           N  
ATOM    511  CA  GLY A  61      61.544   1.470  44.030  1.00 64.91           C  
ATOM    512  C   GLY A  61      62.666   1.350  45.038  1.00 64.95           C  
ATOM    513  O   GLY A  61      62.460   1.623  46.224  1.00 64.50           O  
ATOM    514  N   LYS A  62      63.838   0.909  44.588  1.00 65.22           N  
ATOM    515  CA  LYS A  62      65.024   0.936  45.449  1.00 65.75           C  
ATOM    516  C   LYS A  62      65.699   2.305  45.311  1.00 65.46           C  
ATOM    517  O   LYS A  62      65.707   2.903  44.231  1.00 65.35           O  
ATOM    518  CB  LYS A  62      65.995  -0.201  45.122  1.00 65.68           C  
ATOM    519  CG  LYS A  62      65.443  -1.576  45.437  1.00 66.16           C  
ATOM    520  CD  LYS A  62      66.402  -2.695  45.031  1.00 66.60           C  
ATOM    521  CE  LYS A  62      65.622  -3.987  44.660  1.00 68.43           C  
ATOM    522  NZ  LYS A  62      66.499  -5.226  44.620  1.00 69.08           N  
ATOM    523  N   VAL A  63      66.228   2.809  46.419  1.00 65.12           N  
ATOM    524  CA  VAL A  63      66.820   4.132  46.467  1.00 64.79           C  
ATOM    525  C   VAL A  63      68.093   4.035  47.277  1.00 64.93           C  
ATOM    526  O   VAL A  63      68.061   3.696  48.456  1.00 64.73           O  
ATOM    527  CB  VAL A  63      65.863   5.141  47.127  1.00 64.70           C  
ATOM    528  CG1 VAL A  63      66.584   6.422  47.486  1.00 64.99           C  
ATOM    529  CG2 VAL A  63      64.692   5.449  46.221  1.00 64.88           C  
ATOM    530  N   GLU A  64      69.223   4.324  46.647  1.00 65.40           N  
ATOM    531  CA  GLU A  64      70.495   4.171  47.346  1.00 65.73           C  
ATOM    532  C   GLU A  64      71.112   5.475  47.840  1.00 65.36           C  
ATOM    533  O   GLU A  64      72.189   5.445  48.421  1.00 65.78           O  
ATOM    534  CB  GLU A  64      71.491   3.314  46.557  1.00 65.91           C  
ATOM    535  CG  GLU A  64      71.458   3.480  45.047  1.00 68.42           C  
ATOM    536  CD  GLU A  64      72.826   3.190  44.402  1.00 73.35           C  
ATOM    537  OE1 GLU A  64      73.369   4.097  43.726  1.00 73.13           O  
ATOM    538  OE2 GLU A  64      73.373   2.068  44.577  1.00 75.32           O  
ATOM    539  N   LYS A  65      70.423   6.604  47.614  1.00 64.99           N  
ATOM    540  CA  LYS A  65      70.774   7.912  48.213  1.00 64.43           C  
ATOM    541  C   LYS A  65      70.288   7.981  49.665  1.00 63.92           C  
ATOM    542  O   LYS A  65      69.075   8.078  49.895  1.00 63.61           O  
ATOM    543  CB  LYS A  65      70.085   9.059  47.454  1.00 64.51           C  
ATOM    544  CG  LYS A  65      71.004  10.059  46.718  1.00 64.92           C  
ATOM    545  CD  LYS A  65      70.439  11.508  46.806  1.00 64.79           C  
ATOM    546  CE  LYS A  65      69.788  12.004  45.489  1.00 65.60           C  
ATOM    547  NZ  LYS A  65      68.651  11.126  44.953  1.00 65.76           N  
ATOM    548  N   ASP A  66      71.195   7.958  50.645  1.00 63.02           N  
ATOM    549  CA  ASP A  66      70.723   7.937  52.040  1.00 62.38           C  
ATOM    550  C   ASP A  66      70.190   9.269  52.583  1.00 61.60           C  
ATOM    551  O   ASP A  66      69.698   9.338  53.708  1.00 61.83           O  
ATOM    552  CB  ASP A  66      71.715   7.282  53.014  1.00 62.57           C  
ATOM    553  CG  ASP A  66      73.070   7.923  52.989  1.00 63.17           C  
ATOM    554  OD1 ASP A  66      73.842   7.606  52.056  1.00 64.10           O  
ATOM    555  OD2 ASP A  66      73.371   8.716  53.914  1.00 63.77           O  
ATOM    556  N   THR A  67      70.257  10.319  51.778  1.00 60.44           N  
ATOM    557  CA  THR A  67      69.660  11.585  52.172  1.00 59.33           C  
ATOM    558  C   THR A  67      68.913  12.238  51.004  1.00 58.62           C  
ATOM    559  O   THR A  67      69.162  11.937  49.834  1.00 58.67           O  
ATOM    560  CB  THR A  67      70.716  12.512  52.791  1.00 59.33           C  
ATOM    561  OG1 THR A  67      71.569  11.727  53.625  1.00 59.93           O  
ATOM    562  CG2 THR A  67      70.072  13.600  53.652  1.00 59.17           C  
ATOM    563  N   LEU A  68      67.971  13.108  51.342  1.00 57.59           N  
ATOM    564  CA  LEU A  68      67.128  13.741  50.372  1.00 56.95           C  
ATOM    565  C   LEU A  68      66.951  15.123  50.879  1.00 56.73           C  
ATOM    566  O   LEU A  68      66.424  15.308  51.972  1.00 56.92           O  
ATOM    567  CB  LEU A  68      65.758  13.059  50.353  1.00 56.97           C  
ATOM    568  CG  LEU A  68      65.205  12.551  49.019  1.00 56.58           C  
ATOM    569  CD1 LEU A  68      66.327  11.999  48.113  1.00 56.29           C  
ATOM    570  CD2 LEU A  68      64.182  11.479  49.298  1.00 54.66           C  
ATOM    571  N   TYR A  69      67.391  16.101  50.109  1.00 56.55           N  
ATOM    572  CA  TYR A  69      67.137  17.473  50.499  1.00 56.81           C  
ATOM    573  C   TYR A  69      66.106  18.057  49.564  1.00 56.98           C  
ATOM    574  O   TYR A  69      66.234  17.967  48.348  1.00 56.62           O  
ATOM    575  CB  TYR A  69      68.423  18.312  50.515  1.00 57.14           C  
ATOM    576  CG  TYR A  69      69.502  17.815  51.476  1.00 56.98           C  
ATOM    577  CD1 TYR A  69      70.595  17.076  51.007  1.00 57.31           C  
ATOM    578  CD2 TYR A  69      69.432  18.092  52.844  1.00 56.67           C  
ATOM    579  CE1 TYR A  69      71.593  16.617  51.880  1.00 57.84           C  
ATOM    580  CE2 TYR A  69      70.411  17.636  53.725  1.00 56.97           C  
ATOM    581  CZ  TYR A  69      71.494  16.899  53.243  1.00 57.45           C  
ATOM    582  OH  TYR A  69      72.470  16.452  54.119  1.00 56.45           O  
ATOM    583  N   LEU A  70      65.071  18.640  50.154  1.00 57.60           N  
ATOM    584  CA  LEU A  70      63.935  19.162  49.409  1.00 58.19           C  
ATOM    585  C   LEU A  70      63.613  20.601  49.845  1.00 59.19           C  
ATOM    586  O   LEU A  70      62.980  20.810  50.893  1.00 59.73           O  
ATOM    587  CB  LEU A  70      62.689  18.305  49.646  1.00 57.61           C  
ATOM    588  CG  LEU A  70      62.734  16.786  49.749  1.00 57.35           C  
ATOM    589  CD1 LEU A  70      62.049  16.360  51.024  1.00 56.67           C  
ATOM    590  CD2 LEU A  70      62.113  16.087  48.548  1.00 57.21           C  
ATOM    591  N   THR A  71      64.029  21.579  49.038  1.00 59.70           N  
ATOM    592  CA  THR A  71      63.584  22.963  49.165  1.00 60.33           C  
ATOM    593  C   THR A  71      62.094  23.146  48.818  1.00 60.95           C  
ATOM    594  O   THR A  71      61.646  22.723  47.745  1.00 60.38           O  
ATOM    595  CB  THR A  71      64.376  23.845  48.198  1.00 60.37           C  
ATOM    596  OG1 THR A  71      65.648  23.240  47.924  1.00 60.62           O  
ATOM    597  CG2 THR A  71      64.571  25.220  48.775  1.00 60.40           C  
ATOM    598  N   LEU A  72      61.334  23.777  49.720  1.00 62.09           N  
ATOM    599  CA  LEU A  72      59.987  24.268  49.378  1.00 63.68           C  
ATOM    600  C   LEU A  72      60.082  25.661  48.714  1.00 64.17           C  
ATOM    601  O   LEU A  72      61.180  26.199  48.528  1.00 63.94           O  
ATOM    602  CB  LEU A  72      59.045  24.360  50.595  1.00 64.18           C  
ATOM    603  CG  LEU A  72      58.957  23.541  51.908  1.00 66.06           C  
ATOM    604  CD1 LEU A  72      57.474  23.484  52.386  1.00 66.05           C  
ATOM    605  CD2 LEU A  72      59.547  22.127  51.855  1.00 67.08           C  
ATOM    606  N   SER A  73      58.930  26.245  48.368  1.00 64.86           N  
ATOM    607  CA  SER A  73      58.897  27.543  47.669  1.00 65.08           C  
ATOM    608  C   SER A  73      59.508  28.695  48.459  1.00 65.09           C  
ATOM    609  O   SER A  73      60.086  29.592  47.868  1.00 65.58           O  
ATOM    610  CB  SER A  73      57.476  27.896  47.234  1.00 65.03           C  
ATOM    611  OG  SER A  73      56.615  27.947  48.345  1.00 65.81           O  
ATOM    612  N   ASN A  74      59.378  28.654  49.787  1.00 65.10           N  
ATOM    613  CA  ASN A  74      59.997  29.623  50.702  1.00 64.56           C  
ATOM    614  C   ASN A  74      61.506  29.538  50.760  1.00 64.29           C  
ATOM    615  O   ASN A  74      62.150  30.357  51.413  1.00 64.38           O  
ATOM    616  CB  ASN A  74      59.485  29.391  52.115  1.00 64.67           C  
ATOM    617  CG  ASN A  74      58.051  29.796  52.278  1.00 65.50           C  
ATOM    618  OD1 ASN A  74      57.195  29.451  51.454  1.00 66.17           O  
ATOM    619  ND2 ASN A  74      57.766  30.523  53.354  1.00 66.21           N  
ATOM    620  N   GLY A  75      62.073  28.531  50.101  1.00 64.09           N  
ATOM    621  CA  GLY A  75      63.511  28.274  50.158  1.00 63.61           C  
ATOM    622  C   GLY A  75      63.865  27.429  51.362  1.00 63.28           C  
ATOM    623  O   GLY A  75      65.036  27.180  51.629  1.00 63.39           O  
ATOM    624  N   GLU A  76      62.838  26.993  52.085  1.00 63.04           N  
ATOM    625  CA  GLU A  76      62.996  26.179  53.271  1.00 63.13           C  
ATOM    626  C   GLU A  76      63.369  24.748  52.900  1.00 63.24           C  
ATOM    627  O   GLU A  76      62.626  24.092  52.154  1.00 63.92           O  
ATOM    628  CB  GLU A  76      61.698  26.183  54.073  1.00 63.10           C  
ATOM    629  CG  GLU A  76      61.720  25.199  55.227  1.00 63.48           C  
ATOM    630  CD  GLU A  76      60.469  25.255  56.056  1.00 64.93           C  
ATOM    631  OE1 GLU A  76      60.601  25.372  57.290  1.00 65.58           O  
ATOM    632  OE2 GLU A  76      59.356  25.190  55.485  1.00 65.68           O  
ATOM    633  N   ILE A  77      64.497  24.258  53.419  1.00 62.94           N  
ATOM    634  CA  ILE A  77      64.934  22.874  53.161  1.00 62.64           C  
ATOM    635  C   ILE A  77      64.475  21.897  54.256  1.00 62.75           C  
ATOM    636  O   ILE A  77      64.914  21.971  55.409  1.00 62.47           O  
ATOM    637  CB  ILE A  77      66.468  22.775  53.062  1.00 62.55           C  
ATOM    638  CG1 ILE A  77      66.987  23.655  51.922  1.00 61.94           C  
ATOM    639  CG2 ILE A  77      66.898  21.330  52.870  1.00 62.48           C  
ATOM    640  CD1 ILE A  77      68.492  23.806  51.904  1.00 20.00           C  
ATOM    641  N   VAL A  78      63.575  20.991  53.874  1.00 62.88           N  
ATOM    642  CA  VAL A  78      63.258  19.816  54.676  1.00 62.96           C  
ATOM    643  C   VAL A  78      64.253  18.705  54.324  1.00 63.48           C  
ATOM    644  O   VAL A  78      64.499  18.431  53.142  1.00 64.03           O  
ATOM    645  CB  VAL A  78      61.813  19.347  54.457  1.00 62.58           C  
ATOM    646  CG1 VAL A  78      61.621  17.975  55.023  1.00 62.66           C  
ATOM    647  CG2 VAL A  78      60.828  20.316  55.120  1.00 62.48           C  
ATOM    648  N   GLU A  79      64.850  18.094  55.344  1.00 63.51           N  
ATOM    649  CA  GLU A  79      65.787  16.994  55.135  1.00 63.51           C  
ATOM    650  C   GLU A  79      65.123  15.673  55.545  1.00 63.70           C  
ATOM    651  O   GLU A  79      64.394  15.625  56.543  1.00 63.71           O  
ATOM    652  CB  GLU A  79      67.065  17.243  55.940  1.00 63.13           C  
ATOM    653  CG  GLU A  79      68.108  16.130  55.880  1.00 63.21           C  
ATOM    654  CD  GLU A  79      69.228  16.334  56.892  1.00 63.53           C  
ATOM    655  OE1 GLU A  79      68.931  16.693  58.044  1.00 64.01           O  
ATOM    656  OE2 GLU A  79      70.409  16.139  56.547  1.00 63.52           O  
ATOM    657  N   LEU A  80      65.358  14.610  54.779  1.00 63.75           N  
ATOM    658  CA  LEU A  80      64.893  13.288  55.193  1.00 63.91           C  
ATOM    659  C   LEU A  80      66.030  12.316  55.217  1.00 64.13           C  
ATOM    660  O   LEU A  80      66.712  12.134  54.206  1.00 63.99           O  
ATOM    661  CB  LEU A  80      63.858  12.703  54.242  1.00 63.68           C  
ATOM    662  CG  LEU A  80      62.749  13.540  53.646  1.00 63.74           C  
ATOM    663  CD1 LEU A  80      62.331  12.875  52.373  1.00 64.39           C  
ATOM    664  CD2 LEU A  80      61.585  13.679  54.597  1.00 63.15           C  
ATOM    665  N   LYS A  81      66.206  11.668  56.364  1.00 64.67           N  
ATOM    666  CA  LYS A  81      67.085  10.506  56.461  1.00 64.87           C  
ATOM    667  C   LYS A  81      66.357   9.279  55.917  1.00 65.09           C  
ATOM    668  O   LYS A  81      65.122   9.201  55.967  1.00 64.74           O  
ATOM    669  CB  LYS A  81      67.560  10.268  57.899  1.00 64.90           C  
ATOM    670  CG  LYS A  81      68.272  11.451  58.543  1.00 64.26           C  
ATOM    671  CD  LYS A  81      68.849  11.069  59.900  1.00 64.82           C  
ATOM    672  CE  LYS A  81      68.653  12.200  60.902  1.00 66.23           C  
ATOM    673  NZ  LYS A  81      69.834  12.439  61.796  1.00 66.54           N  
ATOM    674  N   ARG A  82      67.153   8.350  55.383  1.00 65.54           N  
ATOM    675  CA  ARG A  82      66.699   7.104  54.756  1.00 65.60           C  
ATOM    676  C   ARG A  82      66.689   5.997  55.817  1.00 65.88           C  
ATOM    677  O   ARG A  82      67.736   5.641  56.343  1.00 65.79           O  
ATOM    678  CB  ARG A  82      67.648   6.753  53.597  1.00 65.18           C  
ATOM    679  CG  ARG A  82      67.346   5.494  52.827  1.00 65.22           C  
ATOM    680  CD  ARG A  82      68.604   5.005  52.114  1.00 66.43           C  
ATOM    681  NE  ARG A  82      68.329   3.923  51.167  1.00 67.07           N  
ATOM    682  CZ  ARG A  82      68.422   2.622  51.450  1.00 67.18           C  
ATOM    683  NH1 ARG A  82      68.784   2.228  52.664  1.00 67.63           N  
ATOM    684  NH2 ARG A  82      68.146   1.709  50.522  1.00 66.35           N  
ATOM    685  N   VAL A  83      65.501   5.484  56.142  1.00 66.44           N  
ATOM    686  CA  VAL A  83      65.334   4.398  57.116  1.00 66.78           C  
ATOM    687  C   VAL A  83      65.821   3.072  56.540  1.00 67.60           C  
ATOM    688  O   VAL A  83      66.693   2.406  57.116  1.00 67.62           O  
ATOM    689  CB  VAL A  83      63.860   4.257  57.520  1.00 66.81           C  
ATOM    690  CG1 VAL A  83      63.544   2.838  58.023  1.00 66.32           C  
ATOM    691  CG2 VAL A  83      63.476   5.328  58.539  1.00 66.27           C  
ATOM    692  N   GLY A  84      65.255   2.695  55.397  1.00 68.23           N  
ATOM    693  CA  GLY A  84      65.645   1.457  54.735  1.00 69.39           C  
ATOM    694  C   GLY A  84      64.496   0.790  54.010  1.00 69.92           C  
ATOM    695  O   GLY A  84      63.349   1.219  54.123  1.00 70.27           O  
ATOM    696  N   GLU A  85      64.808  -0.261  53.262  1.00 70.42           N  
ATOM    697  CA  GLU A  85      63.807  -0.957  52.487  1.00 71.18           C  
ATOM    698  C   GLU A  85      62.793  -1.565  53.474  1.00 72.21           C  
ATOM    699  O   GLU A  85      63.171  -2.000  54.568  1.00 72.63           O  
ATOM    700  CB  GLU A  85      64.443  -2.011  51.555  1.00 70.60           C  
ATOM    701  CG  GLU A  85      65.829  -1.643  51.049  1.00 70.78           C  
ATOM    702  CD  GLU A  85      66.032  -1.850  49.559  1.00 70.90           C  
ATOM    703  OE1 GLU A  85      66.504  -2.940  49.159  1.00 68.83           O  
ATOM    704  OE2 GLU A  85      65.760  -0.891  48.789  1.00 72.17           O  
ATOM    705  N   GLU A  86      61.504  -1.509  53.120  1.00 72.93           N  
ATOM    706  CA  GLU A  86      60.458  -2.274  53.802  1.00 73.56           C  
ATOM    707  C   GLU A  86      59.510  -2.881  52.781  1.00 73.91           C  
ATOM    708  O   GLU A  86      59.343  -2.354  51.674  1.00 73.73           O  
ATOM    709  CB  GLU A  86      59.677  -1.427  54.787  1.00 73.43           C  
ATOM    710  CG  GLU A  86      60.364  -1.216  56.089  1.00 74.55           C  
ATOM    711  CD  GLU A  86      59.504  -0.411  57.034  1.00 77.53           C  
ATOM    712  OE1 GLU A  86      58.418  -0.908  57.421  1.00 78.43           O  
ATOM    713  OE2 GLU A  86      59.909   0.723  57.392  1.00 78.52           O  
ATOM    714  N   GLU A  87      58.906  -3.999  53.164  1.00 74.35           N  
ATOM    715  CA  GLU A  87      58.047  -4.749  52.278  1.00 74.96           C  
ATOM    716  C   GLU A  87      56.586  -4.318  52.440  1.00 75.73           C  
ATOM    717  O   GLU A  87      56.015  -4.379  53.537  1.00 76.17           O  
ATOM    718  CB  GLU A  87      58.212  -6.238  52.552  1.00 74.95           C  
ATOM    719  CG  GLU A  87      59.570  -6.786  52.163  1.00 74.77           C  
ATOM    720  CD  GLU A  87      59.770  -6.818  50.662  1.00 75.25           C  
ATOM    721  OE1 GLU A  87      58.967  -7.471  49.955  1.00 74.64           O  
ATOM    722  OE2 GLU A  87      60.734  -6.176  50.193  1.00 75.54           O  
ATOM    723  N   PHE A  88      55.986  -3.865  51.348  1.00 76.10           N  
ATOM    724  CA  PHE A  88      54.627  -3.367  51.369  1.00 76.53           C  
ATOM    725  C   PHE A  88      53.654  -4.538  51.482  1.00 77.48           C  
ATOM    726  O   PHE A  88      53.439  -5.270  50.513  1.00 77.80           O  
ATOM    727  CB  PHE A  88      54.385  -2.557  50.096  1.00 76.23           C  
ATOM    728  CG  PHE A  88      52.948  -2.221  49.842  1.00 75.92           C  
ATOM    729  CD1 PHE A  88      52.342  -1.160  50.502  1.00 75.87           C  
ATOM    730  CD2 PHE A  88      52.204  -2.955  48.930  1.00 74.96           C  
ATOM    731  CE1 PHE A  88      51.017  -0.847  50.267  1.00 75.47           C  
ATOM    732  CE2 PHE A  88      50.888  -2.648  48.696  1.00 74.54           C  
ATOM    733  CZ  PHE A  88      50.291  -1.588  49.361  1.00 75.27           C  
ATOM    734  N   ARG A  89      53.080  -4.737  52.665  1.00 78.29           N  
ATOM    735  CA  ARG A  89      52.103  -5.806  52.830  1.00 79.13           C  
ATOM    736  C   ARG A  89      50.750  -5.284  52.324  1.00 78.22           C  
ATOM    737  O   ARG A  89      50.012  -6.019  51.658  1.00 78.55           O  
ATOM    738  CB  ARG A  89      52.058  -6.316  54.280  1.00 79.66           C  
ATOM    739  CG  ARG A  89      53.069  -7.463  54.574  1.00 81.69           C  
ATOM    740  CD  ARG A  89      53.362  -7.742  56.122  1.00 81.54           C  
ATOM    741  NE  ARG A  89      54.013  -9.062  56.359  1.00 86.02           N  
ATOM    742  CZ  ARG A  89      54.300  -9.600  57.567  1.00 90.21           C  
ATOM    743  NH1 ARG A  89      53.993  -8.948  58.700  1.00 91.52           N  
ATOM    744  NH2 ARG A  89      54.898 -10.805  57.657  1.00 89.26           N  
ATOM    745  N   GLY A  90      50.461  -4.006  52.588  1.00 77.25           N  
ATOM    746  CA  GLY A  90      49.217  -3.358  52.117  1.00 76.08           C  
ATOM    747  C   GLY A  90      48.999  -1.902  52.545  1.00 75.19           C  
ATOM    748  O   GLY A  90      49.826  -1.314  53.248  1.00 75.43           O  
ATOM    749  N   PHE A  91      47.875  -1.325  52.123  1.00 74.05           N  
ATOM    750  CA  PHE A  91      47.510   0.062  52.462  1.00 73.27           C  
ATOM    751  C   PHE A  91      46.785   0.270  53.794  1.00 72.60           C  
ATOM    752  O   PHE A  91      45.929  -0.517  54.177  1.00 72.84           O  
ATOM    753  CB  PHE A  91      46.624   0.669  51.363  1.00 73.29           C  
ATOM    754  CG  PHE A  91      47.350   1.009  50.083  1.00 72.95           C  
ATOM    755  CD1 PHE A  91      46.805   0.657  48.860  1.00 72.31           C  
ATOM    756  CD2 PHE A  91      48.559   1.701  50.104  1.00 71.91           C  
ATOM    757  CE1 PHE A  91      47.445   0.976  47.680  1.00 71.86           C  
ATOM    758  CE2 PHE A  91      49.200   1.996  48.947  1.00 70.86           C  
ATOM    759  CZ  PHE A  91      48.632   1.640  47.724  1.00 71.77           C  
ATOM    760  N   GLN A  92      47.086   1.374  54.460  1.00 71.84           N  
ATOM    761  CA  GLN A  92      46.368   1.755  55.674  1.00 71.06           C  
ATOM    762  C   GLN A  92      45.195   2.729  55.431  1.00 69.98           C  
ATOM    763  O   GLN A  92      44.401   2.987  56.335  1.00 70.24           O  
ATOM    764  CB  GLN A  92      47.337   2.341  56.707  1.00 71.08           C  
ATOM    765  CG  GLN A  92      48.410   1.374  57.198  1.00 71.84           C  
ATOM    766  CD  GLN A  92      49.273   1.949  58.325  1.00 71.98           C  
ATOM    767  OE1 GLN A  92      48.962   2.988  58.916  1.00 72.65           O  
ATOM    768  NE2 GLN A  92      50.370   1.267  58.622  1.00 73.99           N  
ATOM    769  N   ASN A  93      45.071   3.290  54.238  1.00 68.70           N  
ATOM    770  CA  ASN A  93      43.946   4.201  53.985  1.00 68.14           C  
ATOM    771  C   ASN A  93      43.912   4.797  52.597  1.00 67.51           C  
ATOM    772  O   ASN A  93      44.936   4.914  51.928  1.00 67.99           O  
ATOM    773  CB  ASN A  93      43.879   5.343  55.010  1.00 68.06           C  
ATOM    774  CG  ASN A  93      45.201   6.038  55.181  1.00 68.48           C  
ATOM    775  OD1 ASN A  93      45.722   6.670  54.251  1.00 68.75           O  
ATOM    776  ND2 ASN A  93      45.781   5.894  56.367  1.00 68.89           N  
ATOM    777  N   GLU A  94      42.723   5.216  52.197  1.00 66.41           N  
ATOM    778  CA  GLU A  94      42.512   5.739  50.891  1.00 65.88           C  
ATOM    779  C   GLU A  94      43.602   6.711  50.558  1.00 65.37           C  
ATOM    780  O   GLU A  94      44.075   6.719  49.431  1.00 65.24           O  
ATOM    781  CB  GLU A  94      41.216   6.464  50.909  1.00 65.90           C  
ATOM    782  CG  GLU A  94      40.962   6.932  52.281  1.00 68.24           C  
ATOM    783  CD  GLU A  94      39.505   7.072  52.548  1.00 73.42           C  
ATOM    784  OE1 GLU A  94      39.058   6.469  53.559  1.00 74.99           O  
ATOM    785  OE2 GLU A  94      38.809   7.752  51.735  1.00 74.47           O  
ATOM    786  N   ARG A  95      44.018   7.517  51.541  1.00 65.08           N  
ATOM    787  CA  ARG A  95      44.918   8.635  51.261  1.00 64.07           C  
ATOM    788  C   ARG A  95      46.215   8.136  50.705  1.00 64.08           C  
ATOM    789  O   ARG A  95      46.669   8.669  49.713  1.00 64.03           O  
ATOM    790  CB  ARG A  95      45.173   9.510  52.466  1.00 63.69           C  
ATOM    791  CG  ARG A  95      45.603  10.927  52.097  1.00 63.32           C  
ATOM    792  CD  ARG A  95      46.785  11.451  52.922  1.00 60.86           C  
ATOM    793  NE  ARG A  95      47.025  10.665  54.128  1.00 60.77           N  
ATOM    794  CZ  ARG A  95      48.120   9.939  54.368  1.00 61.57           C  
ATOM    795  NH1 ARG A  95      49.108   9.904  53.492  1.00 62.84           N  
ATOM    796  NH2 ARG A  95      48.236   9.242  55.495  1.00 60.83           N  
ATOM    797  N   GLU A  96      46.793   7.096  51.310  1.00 64.25           N  
ATOM    798  CA  GLU A  96      48.046   6.511  50.783  1.00 64.67           C  
ATOM    799  C   GLU A  96      47.799   5.916  49.415  1.00 63.62           C  
ATOM    800  O   GLU A  96      48.588   6.088  48.491  1.00 64.17           O  
ATOM    801  CB  GLU A  96      48.608   5.404  51.670  1.00 64.72           C  
ATOM    802  CG  GLU A  96      48.516   5.606  53.175  1.00 66.14           C  
ATOM    803  CD  GLU A  96      48.989   4.366  53.931  1.00 66.77           C  
ATOM    804  OE1 GLU A  96      48.718   3.234  53.443  1.00 69.34           O  
ATOM    805  OE2 GLU A  96      49.641   4.519  54.999  1.00 68.97           O  
ATOM    806  N   CYS A  97      46.690   5.207  49.294  1.00 62.62           N  
ATOM    807  CA  CYS A  97      46.318   4.560  48.057  1.00 61.32           C  
ATOM    808  C   CYS A  97      46.186   5.561  46.920  1.00 60.17           C  
ATOM    809  O   CYS A  97      46.718   5.338  45.853  1.00 59.64           O  
ATOM    810  CB  CYS A  97      44.999   3.835  48.262  1.00 61.50           C  
ATOM    811  SG  CYS A  97      44.486   2.975  46.812  1.00 63.50           S  
ATOM    812  N   GLN A  98      45.471   6.657  47.182  1.00 59.45           N  
ATOM    813  CA  GLN A  98      45.241   7.767  46.255  1.00 58.51           C  
ATOM    814  C   GLN A  98      46.549   8.336  45.765  1.00 58.25           C  
ATOM    815  O   GLN A  98      46.725   8.602  44.566  1.00 57.98           O  
ATOM    816  CB  GLN A  98      44.449   8.881  46.963  1.00 58.42           C  
ATOM    817  CG  GLN A  98      43.947  10.029  46.057  1.00 58.52           C  
ATOM    818  CD  GLN A  98      42.867  10.906  46.699  1.00 58.72           C  
ATOM    819  OE1 GLN A  98      43.056  12.099  46.895  1.00 60.98           O  
ATOM    820  NE2 GLN A  98      41.733  10.315  47.027  1.00 60.33           N  
ATOM    821  N   GLU A  99      47.471   8.526  46.697  1.00 57.90           N  
ATOM    822  CA  GLU A  99      48.692   9.200  46.366  1.00 58.44           C  
ATOM    823  C   GLU A  99      49.438   8.338  45.374  1.00 58.52           C  
ATOM    824  O   GLU A  99      49.582   8.702  44.213  1.00 58.84           O  
ATOM    825  CB  GLU A  99      49.499   9.478  47.617  1.00 58.39           C  
ATOM    826  CG  GLU A  99      48.922  10.621  48.418  1.00 60.63           C  
ATOM    827  CD  GLU A  99      49.401  10.641  49.871  1.00 64.95           C  
ATOM    828  OE1 GLU A  99      50.413   9.959  50.184  1.00 65.63           O  
ATOM    829  OE2 GLU A  99      48.763  11.351  50.691  1.00 65.73           O  
ATOM    830  N   LEU A 100      49.849   7.164  45.823  1.00 58.57           N  
ATOM    831  CA  LEU A 100      50.580   6.232  44.990  1.00 58.39           C  
ATOM    832  C   LEU A 100      49.949   6.044  43.616  1.00 58.62           C  
ATOM    833  O   LEU A 100      50.667   6.096  42.613  1.00 59.10           O  
ATOM    834  CB  LEU A 100      50.694   4.895  45.698  1.00 57.91           C  
ATOM    835  CG  LEU A 100      51.761   4.007  45.102  1.00 57.59           C  
ATOM    836  CD1 LEU A 100      53.118   4.271  45.768  1.00 58.84           C  
ATOM    837  CD2 LEU A 100      51.346   2.623  45.343  1.00 57.26           C  
ATOM    838  N   PHE A 101      48.626   5.852  43.573  1.00 58.42           N  
ATOM    839  CA  PHE A 101      47.912   5.645  42.315  1.00 59.05           C  
ATOM    840  C   PHE A 101      48.053   6.804  41.350  1.00 59.67           C  
ATOM    841  O   PHE A 101      48.399   6.593  40.185  1.00 59.41           O  
ATOM    842  CB  PHE A 101      46.430   5.378  42.538  1.00 59.50           C  
ATOM    843  CG  PHE A 101      45.647   5.229  41.261  1.00 59.87           C  
ATOM    844  CD1 PHE A 101      45.738   4.063  40.499  1.00 61.24           C  
ATOM    845  CD2 PHE A 101      44.828   6.241  40.816  1.00 60.82           C  
ATOM    846  CE1 PHE A 101      45.020   3.915  39.306  1.00 60.43           C  
ATOM    847  CE2 PHE A 101      44.094   6.103  39.611  1.00 61.22           C  
ATOM    848  CZ  PHE A 101      44.201   4.945  38.863  1.00 60.81           C  
ATOM    849  N   ARG A 102      47.773   8.024  41.827  1.00 60.17           N  
ATOM    850  CA  ARG A 102      47.984   9.226  41.005  1.00 60.17           C  
ATOM    851  C   ARG A 102      49.390   9.256  40.445  1.00 60.18           C  
ATOM    852  O   ARG A 102      49.539   9.449  39.263  1.00 59.96           O  
ATOM    853  CB  ARG A 102      47.670  10.515  41.760  1.00 59.84           C  
ATOM    854  CG  ARG A 102      46.202  10.705  42.110  1.00 60.33           C  
ATOM    855  CD  ARG A 102      45.918  12.153  42.433  1.00 60.73           C  
ATOM    856  NE  ARG A 102      44.523  12.427  42.759  1.00 63.66           N  
ATOM    857  CZ  ARG A 102      44.105  13.364  43.630  1.00 65.36           C  
ATOM    858  NH1 ARG A 102      44.990  14.110  44.282  1.00 65.24           N  
ATOM    859  NH2 ARG A 102      42.799  13.570  43.854  1.00 63.45           N  
ATOM    860  N   ASP A 103      50.397   9.020  41.288  1.00 61.16           N  
ATOM    861  CA  ASP A 103      51.813   9.095  40.905  1.00 62.74           C  
ATOM    862  C   ASP A 103      52.083   8.131  39.745  1.00 63.37           C  
ATOM    863  O   ASP A 103      52.873   8.422  38.805  1.00 62.63           O  
ATOM    864  CB  ASP A 103      52.712   8.661  42.070  1.00 63.23           C  
ATOM    865  CG  ASP A 103      53.170   9.816  42.964  1.00 65.36           C  
ATOM    866  OD1 ASP A 103      52.472  10.863  43.054  1.00 67.56           O  
ATOM    867  OD2 ASP A 103      54.236   9.636  43.620  1.00 66.44           O  
ATOM    868  N   PHE A 104      51.427   6.968  39.837  1.00 63.45           N  
ATOM    869  CA  PHE A 104      51.535   5.963  38.799  1.00 63.64           C  
ATOM    870  C   PHE A 104      50.930   6.416  37.476  1.00 64.34           C  
ATOM    871  O   PHE A 104      51.445   6.065  36.418  1.00 65.02           O  
ATOM    872  CB  PHE A 104      50.909   4.672  39.244  1.00 62.77           C  
ATOM    873  CG  PHE A 104      51.867   3.739  39.916  1.00 62.59           C  
ATOM    874  CD1 PHE A 104      51.848   3.578  41.307  1.00 60.99           C  
ATOM    875  CD2 PHE A 104      52.775   2.994  39.163  1.00 59.79           C  
ATOM    876  CE1 PHE A 104      52.718   2.685  41.928  1.00 59.43           C  
ATOM    877  CE2 PHE A 104      53.638   2.110  39.784  1.00 58.18           C  
ATOM    878  CZ  PHE A 104      53.610   1.955  41.165  1.00 59.01           C  
ATOM    879  N   LEU A 105      49.863   7.216  37.528  1.00 64.70           N  
ATOM    880  CA  LEU A 105      49.295   7.799  36.316  1.00 64.68           C  
ATOM    881  C   LEU A 105      50.304   8.733  35.725  1.00 64.95           C  
ATOM    882  O   LEU A 105      50.542   8.719  34.503  1.00 64.85           O  
ATOM    883  CB  LEU A 105      48.021   8.557  36.625  1.00 64.49           C  
ATOM    884  CG  LEU A 105      46.966   7.610  37.178  1.00 65.28           C  
ATOM    885  CD1 LEU A 105      45.854   8.402  37.811  1.00 64.72           C  
ATOM    886  CD2 LEU A 105      46.477   6.658  36.043  1.00 66.93           C  
ATOM    887  N   THR A 106      50.925   9.517  36.606  1.00 64.93           N  
ATOM    888  CA  THR A 106      51.818  10.532  36.154  1.00 65.75           C  
ATOM    889  C   THR A 106      52.981   9.855  35.485  1.00 66.33           C  
ATOM    890  O   THR A 106      53.425  10.288  34.408  1.00 66.50           O  
ATOM    891  CB  THR A 106      52.317  11.403  37.285  1.00 66.12           C  
ATOM    892  OG1 THR A 106      51.217  12.129  37.841  1.00 66.81           O  
ATOM    893  CG2 THR A 106      53.392  12.418  36.766  1.00 66.55           C  
ATOM    894  N   LYS A 107      53.465   8.779  36.114  1.00 66.81           N  
ATOM    895  CA  LYS A 107      54.684   8.120  35.632  1.00 66.17           C  
ATOM    896  C   LYS A 107      54.391   7.543  34.283  1.00 65.44           C  
ATOM    897  O   LYS A 107      55.261   7.519  33.440  1.00 65.66           O  
ATOM    898  CB  LYS A 107      55.196   7.031  36.579  1.00 66.12           C  
ATOM    899  CG  LYS A 107      56.733   6.848  36.546  1.00 68.11           C  
ATOM    900  CD  LYS A 107      57.186   5.334  36.422  1.00 71.68           C  
ATOM    901  CE  LYS A 107      57.016   4.468  37.728  1.00 70.14           C  
ATOM    902  NZ  LYS A 107      57.039   2.979  37.512  1.00 67.08           N  
ATOM    903  N   THR A 108      53.154   7.114  34.051  1.00 65.03           N  
ATOM    904  CA  THR A 108      52.898   6.338  32.834  1.00 64.60           C  
ATOM    905  C   THR A 108      52.384   7.165  31.678  1.00 63.82           C  
ATOM    906  O   THR A 108      52.572   6.806  30.526  1.00 63.22           O  
ATOM    907  CB  THR A 108      52.013   5.111  33.092  1.00 64.62           C  
ATOM    908  OG1 THR A 108      50.718   5.541  33.499  1.00 65.25           O  
ATOM    909  CG2 THR A 108      52.632   4.207  34.171  1.00 64.21           C  
ATOM    910  N   LYS A 109      51.758   8.289  32.005  1.00 63.50           N  
ATOM    911  CA  LYS A 109      51.391   9.300  31.014  1.00 63.11           C  
ATOM    912  C   LYS A 109      50.048   9.082  30.313  1.00 63.16           C  
ATOM    913  O   LYS A 109      49.807   9.654  29.250  1.00 62.86           O  
ATOM    914  CB  LYS A 109      52.506   9.453  29.991  1.00 62.61           C  
ATOM    915  CG  LYS A 109      53.600  10.375  30.453  1.00 63.62           C  
ATOM    916  CD  LYS A 109      54.143  11.201  29.292  1.00 65.51           C  
ATOM    917  CE  LYS A 109      55.606  11.511  29.515  1.00 66.71           C  
ATOM    918  NZ  LYS A 109      56.266  11.739  28.213  1.00 68.27           N  
ATOM    919  N   VAL A 110      49.171   8.280  30.935  1.00 63.38           N  
ATOM    920  CA  VAL A 110      47.938   7.778  30.319  1.00 62.99           C  
ATOM    921  C   VAL A 110      46.938   8.879  30.205  1.00 63.59           C  
ATOM    922  O   VAL A 110      46.496   9.206  29.113  1.00 64.13           O  
ATOM    923  CB  VAL A 110      47.291   6.740  31.171  1.00 62.72           C  
ATOM    924  CG1 VAL A 110      46.584   5.700  30.291  1.00 62.53           C  
ATOM    925  CG2 VAL A 110      48.322   6.130  32.094  1.00 62.28           C  
ATOM    926  N   LYS A 111      46.570   9.425  31.357  1.00 64.21           N  
ATOM    927  CA  LYS A 111      45.801  10.655  31.458  1.00 64.86           C  
ATOM    928  C   LYS A 111      46.279  11.648  30.373  1.00 65.74           C  
ATOM    929  O   LYS A 111      45.466  12.297  29.687  1.00 65.73           O  
ATOM    930  CB  LYS A 111      45.974  11.234  32.871  1.00 64.44           C  
ATOM    931  CG  LYS A 111      45.056  12.372  33.242  1.00 62.90           C  
ATOM    932  CD  LYS A 111      44.924  12.421  34.753  1.00 61.63           C  
ATOM    933  CE  LYS A 111      43.988  13.546  35.191  1.00 61.38           C  
ATOM    934  NZ  LYS A 111      43.644  13.468  36.652  1.00 57.79           N  
ATOM    935  N   ASP A 112      47.595  11.734  30.199  1.00 66.28           N  
ATOM    936  CA  ASP A 112      48.137  12.598  29.183  1.00 67.48           C  
ATOM    937  C   ASP A 112      47.819  12.109  27.784  1.00 67.86           C  
ATOM    938  O   ASP A 112      47.307  12.868  26.955  1.00 67.55           O  
ATOM    939  CB  ASP A 112      49.639  12.714  29.344  1.00 67.84           C  
ATOM    940  CG  ASP A 112      50.020  13.750  30.320  1.00 69.08           C  
ATOM    941  OD1 ASP A 112      49.124  14.221  31.067  1.00 70.97           O  
ATOM    942  OD2 ASP A 112      51.218  14.091  30.324  1.00 70.11           O  
ATOM    943  N   LYS A 113      48.135  10.845  27.521  1.00 68.51           N  
ATOM    944  CA  LYS A 113      47.959  10.328  26.194  1.00 69.79           C  
ATOM    945  C   LYS A 113      46.489  10.447  25.875  1.00 70.40           C  
ATOM    946  O   LYS A 113      46.118  10.632  24.717  1.00 71.15           O  
ATOM    947  CB  LYS A 113      48.445   8.891  26.070  1.00 69.43           C  
ATOM    948  CG  LYS A 113      48.626   8.428  24.615  1.00 70.36           C  
ATOM    949  CD  LYS A 113      49.302   7.062  24.544  1.00 71.29           C  
ATOM    950  CE  LYS A 113      48.638   6.153  23.480  1.00 74.71           C  
ATOM    951  NZ  LYS A 113      47.324   5.526  23.925  1.00 72.66           N  
ATOM    952  N   PHE A 114      45.654  10.401  26.915  1.00 70.90           N  
ATOM    953  CA  PHE A 114      44.221  10.507  26.743  1.00 70.82           C  
ATOM    954  C   PHE A 114      43.710  11.879  26.372  1.00 71.44           C  
ATOM    955  O   PHE A 114      42.915  12.012  25.459  1.00 71.55           O  
ATOM    956  CB  PHE A 114      43.473  10.060  27.972  1.00 70.49           C  
ATOM    957  CG  PHE A 114      42.018  10.312  27.860  1.00 71.15           C  
ATOM    958  CD1 PHE A 114      41.241   9.555  26.985  1.00 71.04           C  
ATOM    959  CD2 PHE A 114      41.421  11.359  28.553  1.00 71.76           C  
ATOM    960  CE1 PHE A 114      39.875   9.819  26.836  1.00 70.53           C  
ATOM    961  CE2 PHE A 114      40.066  11.621  28.407  1.00 72.08           C  
ATOM    962  CZ  PHE A 114      39.294  10.845  27.537  1.00 70.39           C  
ATOM    963  N   ILE A 115      44.109  12.911  27.097  1.00 72.53           N  
ATOM    964  CA  ILE A 115      43.660  14.245  26.714  1.00 73.73           C  
ATOM    965  C   ILE A 115      44.136  14.601  25.294  1.00 74.85           C  
ATOM    966  O   ILE A 115      43.501  15.410  24.578  1.00 75.31           O  
ATOM    967  CB  ILE A 115      44.055  15.308  27.752  1.00 73.66           C  
ATOM    968  CG1 ILE A 115      42.966  15.391  28.816  1.00 73.79           C  
ATOM    969  CG2 ILE A 115      44.196  16.696  27.099  1.00 73.84           C  
ATOM    970  CD1 ILE A 115      43.448  15.103  30.193  1.00 74.45           C  
ATOM    971  N   SER A 116      45.241  13.980  24.885  1.00 75.43           N  
ATOM    972  CA  SER A 116      45.761  14.188  23.562  1.00 76.27           C  
ATOM    973  C   SER A 116      44.864  13.561  22.496  1.00 76.53           C  
ATOM    974  O   SER A 116      44.378  14.254  21.593  1.00 76.61           O  
ATOM    975  CB  SER A 116      47.188  13.681  23.484  1.00 76.57           C  
ATOM    976  OG  SER A 116      48.041  14.645  24.077  1.00 77.91           O  
ATOM    977  N   ASP A 117      44.632  12.261  22.628  1.00 76.91           N  
ATOM    978  CA  ASP A 117      43.784  11.512  21.713  1.00 77.44           C  
ATOM    979  C   ASP A 117      42.425  12.187  21.573  1.00 77.67           C  
ATOM    980  O   ASP A 117      41.896  12.349  20.473  1.00 77.76           O  
ATOM    981  CB  ASP A 117      43.632  10.053  22.189  1.00 77.58           C  
ATOM    982  CG  ASP A 117      44.898   9.199  21.942  1.00 78.76           C  
ATOM    983  OD1 ASP A 117      45.798   9.585  21.156  1.00 80.24           O  
ATOM    984  OD2 ASP A 117      44.998   8.117  22.543  1.00 80.27           O  
ATOM    985  N   PHE A 118      41.878  12.614  22.701  1.00 78.24           N  
ATOM    986  CA  PHE A 118      40.582  13.237  22.709  1.00 78.39           C  
ATOM    987  C   PHE A 118      40.501  14.516  21.878  1.00 78.68           C  
ATOM    988  O   PHE A 118      39.497  14.757  21.213  1.00 78.48           O  
ATOM    989  CB  PHE A 118      40.136  13.524  24.121  1.00 78.21           C  
ATOM    990  CG  PHE A 118      38.726  13.981  24.187  1.00 78.71           C  
ATOM    991  CD1 PHE A 118      37.695  13.057  24.311  1.00 78.21           C  
ATOM    992  CD2 PHE A 118      38.413  15.329  24.062  1.00 78.35           C  
ATOM    993  CE1 PHE A 118      36.393  13.465  24.346  1.00 77.51           C  
ATOM    994  CE2 PHE A 118      37.109  15.742  24.092  1.00 78.41           C  
ATOM    995  CZ  PHE A 118      36.095  14.811  24.238  1.00 78.11           C  
ATOM    996  N   TYR A 119      41.540  15.342  21.946  1.00 79.41           N  
ATOM    997  CA  TYR A 119      41.676  16.481  21.039  1.00 80.04           C  
ATOM    998  C   TYR A 119      41.822  16.043  19.570  1.00 80.47           C  
ATOM    999  O   TYR A 119      41.008  16.404  18.720  1.00 80.07           O  
ATOM   1000  CB  TYR A 119      42.849  17.347  21.470  1.00 80.21           C  
ATOM   1001  CG  TYR A 119      42.453  18.486  22.365  1.00 80.47           C  
ATOM   1002  CD1 TYR A 119      42.482  18.359  23.753  1.00 80.44           C  
ATOM   1003  CD2 TYR A 119      42.052  19.703  21.821  1.00 80.72           C  
ATOM   1004  CE1 TYR A 119      42.111  19.433  24.576  1.00 80.39           C  
ATOM   1005  CE2 TYR A 119      41.688  20.772  22.629  1.00 81.05           C  
ATOM   1006  CZ  TYR A 119      41.717  20.629  23.997  1.00 80.53           C  
ATOM   1007  OH  TYR A 119      41.345  21.697  24.770  1.00 81.42           O  
ATOM   1008  N   LYS A 120      42.837  15.236  19.283  1.00 81.19           N  
ATOM   1009  CA  LYS A 120      43.002  14.702  17.943  1.00 82.54           C  
ATOM   1010  C   LYS A 120      41.649  14.318  17.355  1.00 83.63           C  
ATOM   1011  O   LYS A 120      41.453  14.400  16.147  1.00 84.16           O  
ATOM   1012  CB  LYS A 120      43.955  13.495  17.924  1.00 82.47           C  
ATOM   1013  CG  LYS A 120      45.456  13.821  18.161  1.00 82.67           C  
ATOM   1014  CD  LYS A 120      46.359  12.567  18.049  1.00 82.27           C  
ATOM   1015  CE  LYS A 120      47.801  12.832  18.521  1.00 81.86           C  
ATOM   1016  NZ  LYS A 120      48.864  12.248  17.617  1.00 78.88           N  
ATOM   1017  N   LYS A 121      40.710  13.929  18.211  1.00 84.76           N  
ATOM   1018  CA  LYS A 121      39.413  13.449  17.744  1.00 86.11           C  
ATOM   1019  C   LYS A 121      38.321  14.503  17.714  1.00 86.53           C  
ATOM   1020  O   LYS A 121      37.594  14.598  16.731  1.00 86.89           O  
ATOM   1021  CB  LYS A 121      38.937  12.248  18.574  1.00 86.43           C  
ATOM   1022  CG  LYS A 121      37.814  11.445  17.918  1.00 88.14           C  
ATOM   1023  CD  LYS A 121      37.885   9.963  18.329  1.00 92.03           C  
ATOM   1024  CE  LYS A 121      37.266   9.019  17.256  1.00 93.67           C  
ATOM   1025  NZ  LYS A 121      36.445   7.897  17.876  1.00 93.89           N  
ATOM   1026  N   PHE A 122      38.186  15.283  18.782  1.00 86.94           N  
ATOM   1027  CA  PHE A 122      37.040  16.163  18.897  1.00 87.25           C  
ATOM   1028  C   PHE A 122      37.439  17.597  18.990  1.00 87.54           C  
ATOM   1029  O   PHE A 122      36.618  18.429  19.328  1.00 87.57           O  
ATOM   1030  CB  PHE A 122      36.157  15.758  20.077  1.00 87.43           C  
ATOM   1031  CG  PHE A 122      35.587  14.373  19.944  1.00 88.21           C  
ATOM   1032  CD1 PHE A 122      35.958  13.367  20.826  1.00 88.70           C  
ATOM   1033  CD2 PHE A 122      34.704  14.060  18.911  1.00 89.77           C  
ATOM   1034  CE1 PHE A 122      35.450  12.066  20.691  1.00 89.16           C  
ATOM   1035  CE2 PHE A 122      34.190  12.755  18.759  1.00 90.37           C  
ATOM   1036  CZ  PHE A 122      34.567  11.758  19.652  1.00 89.34           C  
ATOM   1037  N   ARG A 123      38.691  17.886  18.643  1.00 88.34           N  
ATOM   1038  CA  ARG A 123      39.261  19.228  18.782  1.00 88.94           C  
ATOM   1039  C   ARG A 123      38.321  20.275  18.251  1.00 89.91           C  
ATOM   1040  O   ARG A 123      38.038  21.265  18.919  1.00 90.24           O  
ATOM   1041  CB  ARG A 123      40.586  19.339  18.036  1.00 88.93           C  
ATOM   1042  CG  ARG A 123      41.469  20.508  18.481  1.00 88.75           C  
ATOM   1043  CD  ARG A 123      42.730  20.667  17.610  1.00 88.12           C  
ATOM   1044  NE  ARG A 123      43.299  19.382  17.198  1.00 86.19           N  
ATOM   1045  CZ  ARG A 123      44.267  18.730  17.834  1.00 85.19           C  
ATOM   1046  NH1 ARG A 123      44.812  19.224  18.921  1.00 85.00           N  
ATOM   1047  NH2 ARG A 123      44.709  17.578  17.366  1.00 85.58           N  
ATOM   1048  N   ASP A 124      37.818  20.035  17.052  1.00 91.01           N  
ATOM   1049  CA  ASP A 124      37.003  21.010  16.351  1.00 92.25           C  
ATOM   1050  C   ASP A 124      35.681  21.256  17.053  1.00 92.76           C  
ATOM   1051  O   ASP A 124      35.342  22.395  17.351  1.00 92.92           O  
ATOM   1052  CB  ASP A 124      36.845  20.561  14.916  1.00 92.39           C  
ATOM   1053  CG  ASP A 124      38.156  20.027  14.357  1.00 93.82           C  
ATOM   1054  OD1 ASP A 124      38.930  20.838  13.787  1.00 93.99           O  
ATOM   1055  OD2 ASP A 124      38.440  18.814  14.562  1.00 94.95           O  
ATOM   1056  N   LYS A 125      34.973  20.183  17.376  1.00 93.70           N  
ATOM   1057  CA  LYS A 125      33.732  20.269  18.164  1.00 94.85           C  
ATOM   1058  C   LYS A 125      33.844  20.845  19.604  1.00 95.10           C  
ATOM   1059  O   LYS A 125      32.827  20.964  20.302  1.00 95.17           O  
ATOM   1060  CB  LYS A 125      33.039  18.894  18.188  1.00 95.15           C  
ATOM   1061  CG  LYS A 125      32.086  18.692  17.020  1.00 96.06           C  
ATOM   1062  CD  LYS A 125      32.179  17.305  16.445  1.00 97.09           C  
ATOM   1063  CE  LYS A 125      31.930  17.379  14.958  1.00 98.18           C  
ATOM   1064  NZ  LYS A 125      32.076  16.044  14.332  1.00 99.83           N  
ATOM   1065  N   ILE A 126      35.062  21.211  20.021  1.00 95.41           N  
ATOM   1066  CA  ILE A 126      35.378  21.632  21.403  1.00 95.36           C  
ATOM   1067  C   ILE A 126      35.587  23.142  21.538  1.00 95.54           C  
ATOM   1068  O   ILE A 126      35.483  23.699  22.629  1.00 95.28           O  
ATOM   1069  CB  ILE A 126      36.654  20.923  21.887  1.00 95.30           C  
ATOM   1070  CG1 ILE A 126      36.338  19.521  22.370  1.00 94.25           C  
ATOM   1071  CG2 ILE A 126      37.389  21.725  22.980  1.00 95.91           C  
ATOM   1072  CD1 ILE A 126      37.584  18.698  22.487  1.00 93.79           C  
ATOM   1073  N   THR A 127      35.920  23.782  20.423  1.00 96.15           N  
ATOM   1074  CA  THR A 127      36.059  25.228  20.358  1.00 96.49           C  
ATOM   1075  C   THR A 127      34.727  25.781  19.857  1.00 97.19           C  
ATOM   1076  O   THR A 127      34.079  25.165  19.017  1.00 97.33           O  
ATOM   1077  CB  THR A 127      37.185  25.630  19.387  1.00 96.38           C  
ATOM   1078  OG1 THR A 127      37.844  24.454  18.892  1.00 94.89           O  
ATOM   1079  CG2 THR A 127      38.188  26.546  20.078  1.00 95.52           C  
ATOM   1080  N   VAL A 128      34.317  26.935  20.367  1.00 98.13           N  
ATOM   1081  CA  VAL A 128      32.983  27.483  20.073  1.00 99.21           C  
ATOM   1082  C   VAL A 128      32.998  29.035  20.017  1.00 99.63           C  
ATOM   1083  O   VAL A 128      33.604  29.679  20.880  1.00 99.99           O  
ATOM   1084  CB  VAL A 128      31.939  26.920  21.115  1.00 99.22           C  
ATOM   1085  CG1 VAL A 128      30.751  27.844  21.293  1.00 99.81           C  
ATOM   1086  CG2 VAL A 128      31.465  25.508  20.728  1.00 99.21           C  
ATOM   1087  N   GLN A 129      32.343  29.631  19.015  1.00100.13           N  
ATOM   1088  CA  GLN A 129      32.292  31.122  18.865  1.00100.79           C  
ATOM   1089  C   GLN A 129      31.175  31.910  19.582  1.00100.90           C  
ATOM   1090  O   GLN A 129      30.633  31.497  20.622  1.00101.10           O  
ATOM   1091  CB  GLN A 129      32.276  31.511  17.385  1.00100.79           C  
ATOM   1092  CG  GLN A 129      33.482  32.320  16.964  1.00101.51           C  
ATOM   1093  CD  GLN A 129      34.119  31.783  15.699  1.00102.13           C  
ATOM   1094  OE1 GLN A 129      33.542  30.944  15.007  1.00102.96           O  
ATOM   1095  NE2 GLN A 129      35.323  32.257  15.394  1.00102.00           N  
ATOM   1096  N   GLY A 130      30.850  33.066  19.010  1.00100.89           N  
ATOM   1097  CA  GLY A 130      29.795  33.915  19.545  1.00101.21           C  
ATOM   1098  C   GLY A 130      30.204  35.375  19.593  1.00101.41           C  
ATOM   1099  O   GLY A 130      30.881  35.794  20.544  1.00101.52           O  
ATOM   1100  N   LYS A 131      29.771  36.127  18.570  1.00101.23           N  
ATOM   1101  CA  LYS A 131      30.065  37.576  18.345  1.00101.07           C  
ATOM   1102  C   LYS A 131      31.539  38.032  18.454  1.00100.75           C  
ATOM   1103  O   LYS A 131      32.233  38.113  17.433  1.00100.43           O  
ATOM   1104  CB  LYS A 131      29.102  38.525  19.111  1.00100.99           C  
ATOM   1105  CG  LYS A 131      29.345  38.621  20.620  1.00101.73           C  
ATOM   1106  CD  LYS A 131      29.005  39.982  21.204  1.00101.84           C  
ATOM   1107  CE  LYS A 131      29.418  40.013  22.666  1.00101.37           C  
ATOM   1108  NZ  LYS A 131      28.945  41.246  23.337  1.00102.50           N  
ATOM   1109  N   ASN A 132      31.997  38.330  19.676  1.00100.54           N  
ATOM   1110  CA  ASN A 132      33.348  38.857  19.900  1.00100.26           C  
ATOM   1111  C   ASN A 132      34.362  37.855  20.449  1.00 99.73           C  
ATOM   1112  O   ASN A 132      35.353  37.584  19.781  1.00 99.82           O  
ATOM   1113  CB  ASN A 132      33.331  40.168  20.710  1.00100.46           C  
ATOM   1114  CG  ASN A 132      33.392  41.432  19.810  1.00101.36           C  
ATOM   1115  OD1 ASN A 132      32.888  41.444  18.681  1.00102.20           O  
ATOM   1116  ND2 ASN A 132      34.006  42.497  20.327  1.00102.27           N  
ATOM   1117  N   ARG A 133      34.117  37.303  21.638  1.00 99.16           N  
ATOM   1118  CA  ARG A 133      35.042  36.311  22.241  1.00 98.72           C  
ATOM   1119  C   ARG A 133      35.047  34.933  21.514  1.00 97.77           C  
ATOM   1120  O   ARG A 133      34.165  34.638  20.686  1.00 97.72           O  
ATOM   1121  CB  ARG A 133      34.766  36.150  23.757  1.00 98.80           C  
ATOM   1122  CG  ARG A 133      36.008  35.820  24.619  1.00 99.13           C  
ATOM   1123  CD  ARG A 133      35.710  35.914  26.134  1.00 99.56           C  
ATOM   1124  NE  ARG A 133      36.854  36.455  26.892  1.00102.05           N  
ATOM   1125  CZ  ARG A 133      36.960  36.501  28.228  1.00102.72           C  
ATOM   1126  NH1 ARG A 133      35.988  36.027  29.015  1.00103.13           N  
ATOM   1127  NH2 ARG A 133      38.055  37.019  28.789  1.00101.83           N  
ATOM   1128  N   LYS A 134      36.057  34.112  21.809  1.00 96.45           N  
ATOM   1129  CA  LYS A 134      36.054  32.705  21.390  1.00 95.25           C  
ATOM   1130  C   LYS A 134      36.187  31.831  22.640  1.00 93.82           C  
ATOM   1131  O   LYS A 134      36.601  32.334  23.693  1.00 93.71           O  
ATOM   1132  CB  LYS A 134      37.171  32.421  20.378  1.00 95.69           C  
ATOM   1133  CG  LYS A 134      36.870  31.249  19.447  1.00 96.38           C  
ATOM   1134  CD  LYS A 134      37.735  31.296  18.187  1.00 97.44           C  
ATOM   1135  CE  LYS A 134      37.332  30.204  17.173  1.00 98.08           C  
ATOM   1136  NZ  LYS A 134      37.885  30.416  15.777  1.00 97.88           N  
ATOM   1137  N   ILE A 135      35.839  30.543  22.533  1.00 91.88           N  
ATOM   1138  CA  ILE A 135      35.748  29.662  23.715  1.00 90.11           C  
ATOM   1139  C   ILE A 135      36.172  28.189  23.549  1.00 88.70           C  
ATOM   1140  O   ILE A 135      35.831  27.524  22.567  1.00 88.58           O  
ATOM   1141  CB  ILE A 135      34.338  29.763  24.391  1.00 90.30           C  
ATOM   1142  CG1 ILE A 135      34.378  30.803  25.510  1.00 89.51           C  
ATOM   1143  CG2 ILE A 135      33.865  28.410  24.945  1.00 89.91           C  
ATOM   1144  CD1 ILE A 135      33.093  30.919  26.262  1.00 90.07           C  
ATOM   1145  N   ALA A 136      36.908  27.704  24.548  1.00 86.80           N  
ATOM   1146  CA  ALA A 136      37.288  26.305  24.664  1.00 85.10           C  
ATOM   1147  C   ALA A 136      36.589  25.608  25.862  1.00 84.16           C  
ATOM   1148  O   ALA A 136      36.208  26.247  26.853  1.00 83.80           O  
ATOM   1149  CB  ALA A 136      38.793  26.192  24.782  1.00 84.81           C  
ATOM   1150  N   LEU A 137      36.418  24.290  25.740  1.00 82.75           N  
ATOM   1151  CA  LEU A 137      35.926  23.426  26.817  1.00 81.12           C  
ATOM   1152  C   LEU A 137      36.857  22.240  26.930  1.00 79.56           C  
ATOM   1153  O   LEU A 137      36.783  21.331  26.109  1.00 79.58           O  
ATOM   1154  CB  LEU A 137      34.556  22.857  26.467  1.00 81.47           C  
ATOM   1155  CG  LEU A 137      33.617  23.644  25.575  1.00 81.46           C  
ATOM   1156  CD1 LEU A 137      32.811  22.654  24.759  1.00 82.15           C  
ATOM   1157  CD2 LEU A 137      32.731  24.485  26.453  1.00 81.62           C  
ATOM   1158  N   ILE A 138      37.715  22.223  27.940  1.00 77.38           N  
ATOM   1159  CA  ILE A 138      38.805  21.254  27.946  1.00 74.92           C  
ATOM   1160  C   ILE A 138      38.532  20.091  28.894  1.00 73.56           C  
ATOM   1161  O   ILE A 138      38.121  20.307  30.026  1.00 74.38           O  
ATOM   1162  CB  ILE A 138      40.083  21.953  28.274  1.00 74.59           C  
ATOM   1163  CG1 ILE A 138      40.148  23.250  27.459  1.00 74.16           C  
ATOM   1164  CG2 ILE A 138      41.222  21.061  27.925  1.00 74.83           C  
ATOM   1165  CD1 ILE A 138      40.930  24.349  28.086  1.00 73.57           C  
ATOM   1166  N   PRO A 139      38.722  18.847  28.434  1.00 71.78           N  
ATOM   1167  CA  PRO A 139      38.310  17.750  29.300  1.00 70.22           C  
ATOM   1168  C   PRO A 139      39.222  17.677  30.480  1.00 68.97           C  
ATOM   1169  O   PRO A 139      40.418  17.905  30.332  1.00 68.79           O  
ATOM   1170  CB  PRO A 139      38.509  16.520  28.425  1.00 70.43           C  
ATOM   1171  CG  PRO A 139      39.570  16.930  27.442  1.00 71.16           C  
ATOM   1172  CD  PRO A 139      39.293  18.368  27.163  1.00 71.85           C  
ATOM   1173  N   GLU A 140      38.650  17.390  31.641  1.00 67.92           N  
ATOM   1174  CA  GLU A 140      39.383  17.237  32.897  1.00 67.67           C  
ATOM   1175  C   GLU A 140      39.112  15.842  33.432  1.00 66.97           C  
ATOM   1176  O   GLU A 140      37.943  15.483  33.642  1.00 67.13           O  
ATOM   1177  CB  GLU A 140      38.845  18.192  33.965  1.00 67.61           C  
ATOM   1178  CG  GLU A 140      39.376  19.611  34.017  1.00 68.29           C  
ATOM   1179  CD  GLU A 140      38.867  20.378  35.258  1.00 69.25           C  
ATOM   1180  OE1 GLU A 140      38.143  19.765  36.098  1.00 71.22           O  
ATOM   1181  OE2 GLU A 140      39.185  21.595  35.391  1.00 71.39           O  
ATOM   1182  N   VAL A 141      40.162  15.064  33.683  1.00 66.05           N  
ATOM   1183  CA  VAL A 141      39.998  13.745  34.291  1.00 64.86           C  
ATOM   1184  C   VAL A 141      40.399  13.893  35.726  1.00 65.21           C  
ATOM   1185  O   VAL A 141      41.350  14.585  36.031  1.00 65.97           O  
ATOM   1186  CB  VAL A 141      40.857  12.694  33.586  1.00 64.39           C  
ATOM   1187  CG1 VAL A 141      40.785  11.371  34.273  1.00 62.16           C  
ATOM   1188  CG2 VAL A 141      40.416  12.568  32.149  1.00 64.33           C  
ATOM   1189  N   ASN A 142      39.658  13.261  36.615  1.00 65.72           N  
ATOM   1190  CA  ASN A 142      39.896  13.361  38.047  1.00 66.01           C  
ATOM   1191  C   ASN A 142      39.808  11.999  38.688  1.00 66.36           C  
ATOM   1192  O   ASN A 142      38.922  11.195  38.336  1.00 66.62           O  
ATOM   1193  CB  ASN A 142      38.852  14.278  38.692  1.00 65.88           C  
ATOM   1194  CG  ASN A 142      38.994  15.704  38.238  1.00 66.36           C  
ATOM   1195  OD1 ASN A 142      40.023  16.346  38.475  1.00 66.74           O  
ATOM   1196  ND2 ASN A 142      37.979  16.207  37.544  1.00 66.53           N  
ATOM   1197  N   GLU A 143      40.719  11.748  39.627  1.00 66.46           N  
ATOM   1198  CA  GLU A 143      40.712  10.512  40.404  1.00 67.02           C  
ATOM   1199  C   GLU A 143      40.783  10.805  41.878  1.00 66.43           C  
ATOM   1200  O   GLU A 143      41.599  11.577  42.299  1.00 66.69           O  
ATOM   1201  CB  GLU A 143      41.908   9.598  40.051  1.00 67.27           C  
ATOM   1202  CG  GLU A 143      42.336   9.607  38.630  1.00 68.57           C  
ATOM   1203  CD  GLU A 143      43.050  10.877  38.273  1.00 71.70           C  
ATOM   1204  OE1 GLU A 143      43.589  11.545  39.191  1.00 74.24           O  
ATOM   1205  OE2 GLU A 143      43.062  11.214  37.075  1.00 72.58           O  
ATOM   1206  N   LYS A 144      39.943  10.166  42.662  1.00 66.57           N  
ATOM   1207  CA  LYS A 144      40.142  10.113  44.095  1.00 67.49           C  
ATOM   1208  C   LYS A 144      39.963   8.667  44.486  1.00 67.42           C  
ATOM   1209  O   LYS A 144      39.431   7.878  43.698  1.00 67.61           O  
ATOM   1210  CB  LYS A 144      39.135  10.993  44.848  1.00 67.11           C  
ATOM   1211  CG  LYS A 144      39.491  12.493  44.994  1.00 68.06           C  
ATOM   1212  CD  LYS A 144      38.559  13.221  46.000  1.00 69.24           C  
ATOM   1213  CE  LYS A 144      38.673  12.637  47.490  1.00 74.55           C  
ATOM   1214  NZ  LYS A 144      37.414  12.726  48.351  1.00 71.47           N  
ATOM   1215  N   VAL A 145      40.411   8.310  45.686  1.00 67.60           N  
ATOM   1216  CA  VAL A 145      40.233   6.965  46.197  1.00 67.71           C  
ATOM   1217  C   VAL A 145      39.464   6.970  47.497  1.00 68.75           C  
ATOM   1218  O   VAL A 145      39.798   7.680  48.463  1.00 69.01           O  
ATOM   1219  CB  VAL A 145      41.542   6.270  46.450  1.00 67.40           C  
ATOM   1220  CG1 VAL A 145      41.274   4.840  46.878  1.00 67.10           C  
ATOM   1221  CG2 VAL A 145      42.425   6.320  45.212  1.00 67.67           C  
ATOM   1222  N   LEU A 146      38.436   6.135  47.526  1.00 69.77           N  
ATOM   1223  CA  LEU A 146      37.562   6.017  48.688  1.00 70.46           C  
ATOM   1224  C   LEU A 146      37.477   4.580  49.190  1.00 71.05           C  
ATOM   1225  O   LEU A 146      37.871   3.639  48.498  1.00 71.29           O  
ATOM   1226  CB  LEU A 146      36.164   6.524  48.325  1.00 70.42           C  
ATOM   1227  CG  LEU A 146      36.022   7.757  47.428  1.00 68.49           C  
ATOM   1228  CD1 LEU A 146      34.574   7.894  47.023  1.00 65.47           C  
ATOM   1229  CD2 LEU A 146      36.548   9.023  48.111  1.00 66.67           C  
ATOM   1230  N   LYS A 147      36.948   4.431  50.396  1.00 71.93           N  
ATOM   1231  CA  LYS A 147      36.775   3.135  51.035  1.00 72.89           C  
ATOM   1232  C   LYS A 147      35.275   2.824  51.181  1.00 73.41           C  
ATOM   1233  O   LYS A 147      34.549   3.544  51.833  1.00 73.87           O  
ATOM   1234  CB  LYS A 147      37.453   3.192  52.402  1.00 72.49           C  
ATOM   1235  CG  LYS A 147      38.167   1.943  52.778  1.00 73.54           C  
ATOM   1236  CD  LYS A 147      38.662   2.014  54.207  1.00 75.12           C  
ATOM   1237  CE  LYS A 147      39.261   0.692  54.656  1.00 76.06           C  
ATOM   1238  NZ  LYS A 147      38.965   0.381  56.086  1.00 76.54           N  
ATOM   1239  N   SER A 148      34.801   1.763  50.563  1.00 74.77           N  
ATOM   1240  CA  SER A 148      33.420   1.321  50.767  1.00 76.33           C  
ATOM   1241  C   SER A 148      33.210   0.809  52.191  1.00 77.27           C  
ATOM   1242  O   SER A 148      34.174   0.659  52.958  1.00 77.58           O  
ATOM   1243  CB  SER A 148      33.113   0.152  49.851  1.00 76.22           C  
ATOM   1244  OG  SER A 148      33.754  -1.000  50.393  1.00 76.62           O  
ATOM   1245  N   GLU A 149      31.954   0.483  52.503  1.00 77.95           N  
ATOM   1246  CA  GLU A 149      31.569  -0.106  53.782  1.00 78.85           C  
ATOM   1247  C   GLU A 149      32.260  -1.438  54.045  1.00 78.72           C  
ATOM   1248  O   GLU A 149      32.784  -1.664  55.124  1.00 78.83           O  
ATOM   1249  CB  GLU A 149      30.059  -0.312  53.828  1.00 78.91           C  
ATOM   1250  CG  GLU A 149      29.512  -0.465  55.238  1.00 79.86           C  
ATOM   1251  CD  GLU A 149      28.037  -0.864  55.263  1.00 80.50           C  
ATOM   1252  OE1 GLU A 149      27.499  -1.327  54.205  1.00 79.51           O  
ATOM   1253  OE2 GLU A 149      27.426  -0.708  56.363  1.00 82.63           O  
ATOM   1254  N   GLU A 150      32.264  -2.318  53.056  1.00 78.95           N  
ATOM   1255  CA  GLU A 150      32.886  -3.636  53.208  1.00 79.53           C  
ATOM   1256  C   GLU A 150      34.416  -3.569  53.267  1.00 78.99           C  
ATOM   1257  O   GLU A 150      35.070  -4.621  53.291  1.00 79.64           O  
ATOM   1258  CB  GLU A 150      32.487  -4.592  52.058  1.00 80.13           C  
ATOM   1259  CG  GLU A 150      31.020  -4.514  51.578  1.00 83.55           C  
ATOM   1260  CD  GLU A 150      30.777  -3.348  50.617  1.00 88.80           C  
ATOM   1261  OE1 GLU A 150      31.603  -3.184  49.679  1.00 90.76           O  
ATOM   1262  OE2 GLU A 150      29.777  -2.595  50.805  1.00 89.70           O  
ATOM   1263  N   GLY A 151      34.993  -2.361  53.236  1.00 77.74           N  
ATOM   1264  CA  GLY A 151      36.439  -2.221  53.241  1.00 75.92           C  
ATOM   1265  C   GLY A 151      37.192  -2.227  51.907  1.00 74.91           C  
ATOM   1266  O   GLY A 151      38.404  -2.039  51.889  1.00 75.30           O  
ATOM   1267  N   TYR A 152      36.535  -2.408  50.775  1.00 73.53           N  
ATOM   1268  CA  TYR A 152      37.297  -2.323  49.512  1.00 72.55           C  
ATOM   1269  C   TYR A 152      37.749  -0.881  49.233  1.00 70.21           C  
ATOM   1270  O   TYR A 152      37.018   0.063  49.515  1.00 70.00           O  
ATOM   1271  CB  TYR A 152      36.486  -2.830  48.295  1.00 74.25           C  
ATOM   1272  CG  TYR A 152      35.564  -4.011  48.542  1.00 76.87           C  
ATOM   1273  CD1 TYR A 152      34.303  -4.054  47.935  1.00 77.62           C  
ATOM   1274  CD2 TYR A 152      35.941  -5.079  49.409  1.00 78.38           C  
ATOM   1275  CE1 TYR A 152      33.430  -5.129  48.161  1.00 79.34           C  
ATOM   1276  CE2 TYR A 152      35.076  -6.153  49.651  1.00 79.40           C  
ATOM   1277  CZ  TYR A 152      33.814  -6.174  49.014  1.00 79.41           C  
ATOM   1278  OH  TYR A 152      32.930  -7.228  49.216  1.00 78.95           O  
ATOM   1279  N   PHE A 153      38.935  -0.695  48.668  1.00 66.96           N  
ATOM   1280  CA  PHE A 153      39.246   0.634  48.155  1.00 63.85           C  
ATOM   1281  C   PHE A 153      38.546   0.832  46.828  1.00 62.57           C  
ATOM   1282  O   PHE A 153      38.370  -0.144  46.092  1.00 62.06           O  
ATOM   1283  CB  PHE A 153      40.739   0.838  48.016  1.00 62.92           C  
ATOM   1284  CG  PHE A 153      41.436   1.045  49.322  1.00 61.72           C  
ATOM   1285  CD1 PHE A 153      42.762   0.701  49.476  1.00 61.12           C  
ATOM   1286  CD2 PHE A 153      40.769   1.589  50.408  1.00 61.96           C  
ATOM   1287  CE1 PHE A 153      43.399   0.892  50.679  1.00 59.38           C  
ATOM   1288  CE2 PHE A 153      41.412   1.780  51.624  1.00 58.86           C  
ATOM   1289  CZ  PHE A 153      42.716   1.432  51.750  1.00 59.72           C  
ATOM   1290  N   LEU A 154      38.155   2.078  46.522  1.00 60.70           N  
ATOM   1291  CA  LEU A 154      37.341   2.383  45.333  1.00 59.42           C  
ATOM   1292  C   LEU A 154      37.869   3.526  44.513  1.00 58.59           C  
ATOM   1293  O   LEU A 154      37.947   4.620  44.978  1.00 59.36           O  
ATOM   1294  CB  LEU A 154      35.923   2.753  45.751  1.00 59.15           C  
ATOM   1295  CG  LEU A 154      34.995   1.684  46.325  1.00 59.59           C  
ATOM   1296  CD1 LEU A 154      33.801   2.336  47.031  1.00 59.01           C  
ATOM   1297  CD2 LEU A 154      34.558   0.672  45.224  1.00 59.53           C  
ATOM   1298  N   LEU A 155      38.215   3.309  43.275  1.00 58.34           N  
ATOM   1299  CA  LEU A 155      38.651   4.438  42.457  1.00 58.30           C  
ATOM   1300  C   LEU A 155      37.442   5.292  42.083  1.00 58.88           C  
ATOM   1301  O   LEU A 155      36.485   4.797  41.496  1.00 59.91           O  
ATOM   1302  CB  LEU A 155      39.365   3.944  41.197  1.00 57.48           C  
ATOM   1303  CG  LEU A 155      39.592   4.969  40.115  1.00 56.34           C  
ATOM   1304  CD1 LEU A 155      40.614   5.955  40.653  1.00 57.85           C  
ATOM   1305  CD2 LEU A 155      40.099   4.324  38.851  1.00 55.07           C  
ATOM   1306  N   HIS A 156      37.468   6.576  42.421  1.00 59.02           N  
ATOM   1307  CA  HIS A 156      36.380   7.490  42.032  1.00 58.64           C  
ATOM   1308  C   HIS A 156      36.887   8.200  40.762  1.00 59.61           C  
ATOM   1309  O   HIS A 156      37.868   8.930  40.795  1.00 59.22           O  
ATOM   1310  CB  HIS A 156      36.043   8.387  43.239  1.00 57.70           C  
ATOM   1311  CG  HIS A 156      35.242   9.611  42.939  1.00 56.19           C  
ATOM   1312  ND1 HIS A 156      34.477   9.765  41.806  1.00 57.03           N  
ATOM   1313  CD2 HIS A 156      35.056  10.735  43.668  1.00 55.14           C  
ATOM   1314  CE1 HIS A 156      33.869  10.937  41.836  1.00 54.69           C  
ATOM   1315  NE2 HIS A 156      34.204  11.544  42.958  1.00 54.23           N  
ATOM   1316  N   LEU A 157      36.274   7.902  39.621  1.00 60.70           N  
ATOM   1317  CA  LEU A 157      36.798   8.371  38.359  1.00 62.12           C  
ATOM   1318  C   LEU A 157      35.791   9.232  37.608  1.00 63.96           C  
ATOM   1319  O   LEU A 157      34.727   8.737  37.250  1.00 64.38           O  
ATOM   1320  CB  LEU A 157      37.177   7.177  37.512  1.00 61.36           C  
ATOM   1321  CG  LEU A 157      37.634   7.464  36.090  1.00 61.03           C  
ATOM   1322  CD1 LEU A 157      38.928   8.202  36.086  1.00 61.64           C  
ATOM   1323  CD2 LEU A 157      37.830   6.163  35.406  1.00 62.10           C  
ATOM   1324  N   ASP A 158      36.110  10.508  37.350  1.00 65.45           N  
ATOM   1325  CA  ASP A 158      35.124  11.385  36.710  1.00 66.47           C  
ATOM   1326  C   ASP A 158      35.712  12.054  35.519  1.00 66.40           C  
ATOM   1327  O   ASP A 158      36.914  12.063  35.358  1.00 66.31           O  
ATOM   1328  CB  ASP A 158      34.590  12.442  37.677  1.00 67.31           C  
ATOM   1329  CG  ASP A 158      33.231  13.067  37.210  1.00 71.15           C  
ATOM   1330  OD1 ASP A 158      32.909  13.015  35.988  1.00 73.34           O  
ATOM   1331  OD2 ASP A 158      32.478  13.622  38.071  1.00 73.39           O  
ATOM   1332  N   LEU A 159      34.844  12.584  34.676  1.00 66.94           N  
ATOM   1333  CA  LEU A 159      35.233  13.393  33.565  1.00 68.23           C  
ATOM   1334  C   LEU A 159      34.415  14.677  33.555  1.00 70.36           C  
ATOM   1335  O   LEU A 159      33.188  14.635  33.538  1.00 70.77           O  
ATOM   1336  CB  LEU A 159      34.939  12.639  32.307  1.00 67.71           C  
ATOM   1337  CG  LEU A 159      35.003  13.375  30.974  1.00 67.65           C  
ATOM   1338  CD1 LEU A 159      36.325  14.081  30.793  1.00 65.86           C  
ATOM   1339  CD2 LEU A 159      34.738  12.360  29.836  1.00 68.22           C  
ATOM   1340  N   LYS A 160      35.087  15.825  33.540  1.00 72.05           N  
ATOM   1341  CA  LYS A 160      34.387  17.080  33.426  1.00 73.70           C  
ATOM   1342  C   LYS A 160      34.957  17.907  32.284  1.00 74.27           C  
ATOM   1343  O   LYS A 160      35.867  17.461  31.583  1.00 74.81           O  
ATOM   1344  CB  LYS A 160      34.475  17.840  34.729  1.00 74.34           C  
ATOM   1345  CG  LYS A 160      33.104  18.187  35.294  1.00 78.50           C  
ATOM   1346  CD  LYS A 160      33.012  19.683  35.642  1.00 83.96           C  
ATOM   1347  CE  LYS A 160      31.544  20.157  35.730  1.00 85.27           C  
ATOM   1348  NZ  LYS A 160      31.439  21.505  36.413  1.00 86.18           N  
ATOM   1349  N   PHE A 161      34.404  19.096  32.067  1.00 74.97           N  
ATOM   1350  CA  PHE A 161      34.936  20.031  31.066  1.00 75.61           C  
ATOM   1351  C   PHE A 161      35.001  21.378  31.732  1.00 75.60           C  
ATOM   1352  O   PHE A 161      33.991  21.844  32.304  1.00 75.96           O  
ATOM   1353  CB  PHE A 161      34.047  20.141  29.811  1.00 76.09           C  
ATOM   1354  CG  PHE A 161      34.076  18.926  28.936  1.00 76.63           C  
ATOM   1355  CD1 PHE A 161      33.377  17.774  29.290  1.00 77.56           C  
ATOM   1356  CD2 PHE A 161      34.799  18.932  27.752  1.00 78.30           C  
ATOM   1357  CE1 PHE A 161      33.418  16.635  28.486  1.00 78.42           C  
ATOM   1358  CE2 PHE A 161      34.851  17.793  26.935  1.00 78.47           C  
ATOM   1359  CZ  PHE A 161      34.164  16.650  27.305  1.00 78.64           C  
ATOM   1360  N   ARG A 162      36.177  21.998  31.682  1.00 74.84           N  
ATOM   1361  CA  ARG A 162      36.305  23.344  32.183  1.00 74.20           C  
ATOM   1362  C   ARG A 162      36.350  24.267  30.984  1.00 74.55           C  
ATOM   1363  O   ARG A 162      37.028  23.978  29.965  1.00 74.34           O  
ATOM   1364  CB  ARG A 162      37.502  23.522  33.128  1.00 74.19           C  
ATOM   1365  CG  ARG A 162      38.794  23.926  32.453  1.00 73.86           C  
ATOM   1366  CD  ARG A 162      39.978  23.978  33.389  1.00 73.52           C  
ATOM   1367  NE  ARG A 162      41.183  23.874  32.570  1.00 73.35           N  
ATOM   1368  CZ  ARG A 162      41.878  22.757  32.377  1.00 72.24           C  
ATOM   1369  NH1 ARG A 162      41.522  21.635  32.987  1.00 70.88           N  
ATOM   1370  NH2 ARG A 162      42.946  22.775  31.584  1.00 71.87           N  
ATOM   1371  N   ILE A 163      35.597  25.365  31.142  1.00 74.53           N  
ATOM   1372  CA  ILE A 163      35.327  26.372  30.126  1.00 73.88           C  
ATOM   1373  C   ILE A 163      36.343  27.492  30.284  1.00 74.28           C  
ATOM   1374  O   ILE A 163      36.534  27.998  31.376  1.00 74.49           O  
ATOM   1375  CB  ILE A 163      33.911  26.910  30.324  1.00 73.76           C  
ATOM   1376  CG1 ILE A 163      32.897  25.755  30.268  1.00 73.22           C  
ATOM   1377  CG2 ILE A 163      33.605  27.966  29.296  1.00 74.81           C  
ATOM   1378  CD1 ILE A 163      31.461  26.089  30.681  1.00 72.57           C  
ATOM   1379  N   GLN A 164      37.018  27.854  29.201  1.00 74.89           N  
ATOM   1380  CA  GLN A 164      38.137  28.796  29.260  1.00 75.57           C  
ATOM   1381  C   GLN A 164      38.255  29.515  27.936  1.00 75.93           C  
ATOM   1382  O   GLN A 164      37.983  28.928  26.896  1.00 75.73           O  
ATOM   1383  CB  GLN A 164      39.479  28.087  29.520  1.00 75.66           C  
ATOM   1384  CG  GLN A 164      39.664  27.424  30.894  1.00 76.48           C  
ATOM   1385  CD  GLN A 164      41.117  27.469  31.381  1.00 76.82           C  
ATOM   1386  OE1 GLN A 164      41.852  26.482  31.305  1.00 75.58           O  
ATOM   1387  NE2 GLN A 164      41.531  28.626  31.876  1.00 77.77           N  
ATOM   1388  N   PRO A 165      38.672  30.791  27.969  1.00 76.68           N  
ATOM   1389  CA  PRO A 165      38.901  31.556  26.762  1.00 77.38           C  
ATOM   1390  C   PRO A 165      40.324  31.422  26.227  1.00 78.39           C  
ATOM   1391  O   PRO A 165      41.110  30.609  26.721  1.00 78.23           O  
ATOM   1392  CB  PRO A 165      38.626  32.990  27.214  1.00 77.38           C  
ATOM   1393  CG  PRO A 165      38.846  33.007  28.680  1.00 76.62           C  
ATOM   1394  CD  PRO A 165      38.918  31.599  29.175  1.00 76.83           C  
ATOM   1395  N   PHE A 166      40.638  32.199  25.201  1.00 79.87           N  
ATOM   1396  CA  PHE A 166      41.979  32.207  24.654  1.00 81.87           C  
ATOM   1397  C   PHE A 166      42.671  33.490  25.088  1.00 83.23           C  
ATOM   1398  O   PHE A 166      43.332  34.143  24.281  1.00 83.30           O  
ATOM   1399  CB  PHE A 166      41.941  32.127  23.126  1.00 81.67           C  
ATOM   1400  CG  PHE A 166      41.528  30.783  22.582  1.00 81.82           C  
ATOM   1401  CD1 PHE A 166      40.221  30.308  22.744  1.00 81.61           C  
ATOM   1402  CD2 PHE A 166      42.435  30.013  21.861  1.00 81.62           C  
ATOM   1403  CE1 PHE A 166      39.828  29.076  22.220  1.00 80.54           C  
ATOM   1404  CE2 PHE A 166      42.053  28.783  21.333  1.00 82.06           C  
ATOM   1405  CZ  PHE A 166      40.740  28.313  21.518  1.00 81.39           C  
ATOM   1406  N   GLU A 167      42.519  33.854  26.361  1.00 84.92           N  
ATOM   1407  CA  GLU A 167      42.962  35.168  26.809  1.00 87.02           C  
ATOM   1408  C   GLU A 167      43.756  35.223  28.108  1.00 87.75           C  
ATOM   1409  O   GLU A 167      43.263  35.632  29.158  1.00 88.08           O  
ATOM   1410  CB  GLU A 167      41.803  36.163  26.811  1.00 87.30           C  
ATOM   1411  CG  GLU A 167      41.672  36.901  25.485  1.00 90.54           C  
ATOM   1412  CD  GLU A 167      40.269  37.444  25.225  1.00 94.45           C  
ATOM   1413  OE1 GLU A 167      39.399  37.366  26.132  1.00 95.66           O  
ATOM   1414  OE2 GLU A 167      40.042  37.949  24.096  1.00 95.95           O  
ATOM   1415  N   THR A 168      45.008  34.805  27.991  1.00 89.06           N  
ATOM   1416  CA  THR A 168      46.049  34.992  28.995  1.00 90.09           C  
ATOM   1417  C   THR A 168      45.938  36.336  29.713  1.00 90.94           C  
ATOM   1418  O   THR A 168      45.743  37.381  29.076  1.00 91.29           O  
ATOM   1419  CB  THR A 168      47.438  34.801  28.322  1.00 90.06           C  
ATOM   1420  OG1 THR A 168      48.000  33.546  28.731  1.00 90.33           O  
ATOM   1421  CG2 THR A 168      48.408  35.935  28.640  1.00 90.36           C  
ATOM   1422  N   LEU A 169      46.048  36.289  31.040  1.00 91.82           N  
ATOM   1423  CA  LEU A 169      45.960  37.476  31.897  1.00 92.64           C  
ATOM   1424  C   LEU A 169      46.826  38.654  31.462  1.00 93.76           C  
ATOM   1425  O   LEU A 169      46.388  39.808  31.501  1.00 93.51           O  
ATOM   1426  CB  LEU A 169      46.318  37.108  33.329  1.00 92.26           C  
ATOM   1427  CG  LEU A 169      45.141  37.076  34.287  1.00 91.13           C  
ATOM   1428  CD1 LEU A 169      45.404  36.049  35.348  1.00 90.54           C  
ATOM   1429  CD2 LEU A 169      44.901  38.444  34.902  1.00 90.29           C  
ATOM   1430  N   GLN A 170      48.059  38.362  31.064  1.00 95.32           N  
ATOM   1431  CA  GLN A 170      48.951  39.409  30.625  1.00 97.29           C  
ATOM   1432  C   GLN A 170      48.208  40.272  29.629  1.00 98.66           C  
ATOM   1433  O   GLN A 170      48.076  41.484  29.836  1.00 99.05           O  
ATOM   1434  CB  GLN A 170      50.217  38.840  29.985  1.00 97.44           C  
ATOM   1435  CG  GLN A 170      51.351  39.848  29.854  1.00 97.36           C  
ATOM   1436  CD  GLN A 170      51.914  40.225  31.201  1.00 97.89           C  
ATOM   1437  OE1 GLN A 170      51.705  41.338  31.679  1.00 97.91           O  
ATOM   1438  NE2 GLN A 170      52.609  39.286  31.841  1.00 98.50           N  
ATOM   1439  N   THR A 171      47.692  39.632  28.574  1.00100.01           N  
ATOM   1440  CA  THR A 171      47.014  40.329  27.481  1.00101.32           C  
ATOM   1441  C   THR A 171      45.857  41.175  27.996  1.00102.27           C  
ATOM   1442  O   THR A 171      45.695  42.337  27.582  1.00102.37           O  
ATOM   1443  CB  THR A 171      46.543  39.353  26.385  1.00101.08           C  
ATOM   1444  OG1 THR A 171      47.675  38.637  25.901  1.00101.03           O  
ATOM   1445  CG2 THR A 171      45.922  40.101  25.212  1.00101.52           C  
ATOM   1446  N   LEU A 172      45.086  40.604  28.919  1.00103.32           N  
ATOM   1447  CA  LEU A 172      43.937  41.298  29.471  1.00104.72           C  
ATOM   1448  C   LEU A 172      44.318  42.534  30.300  1.00105.56           C  
ATOM   1449  O   LEU A 172      43.696  43.584  30.156  1.00105.96           O  
ATOM   1450  CB  LEU A 172      43.016  40.344  30.251  1.00104.85           C  
ATOM   1451  CG  LEU A 172      42.286  39.195  29.518  1.00105.38           C  
ATOM   1452  CD1 LEU A 172      41.217  38.546  30.424  1.00105.15           C  
ATOM   1453  CD2 LEU A 172      41.662  39.621  28.172  1.00105.40           C  
ATOM   1454  N   LEU A 173      45.345  42.433  31.136  1.00106.43           N  
ATOM   1455  CA  LEU A 173      45.704  43.568  31.990  1.00107.40           C  
ATOM   1456  C   LEU A 173      46.491  44.630  31.230  1.00108.14           C  
ATOM   1457  O   LEU A 173      46.305  45.827  31.454  1.00108.00           O  
ATOM   1458  CB  LEU A 173      46.469  43.105  33.233  1.00107.51           C  
ATOM   1459  CG  LEU A 173      45.841  41.994  34.079  1.00107.36           C  
ATOM   1460  CD1 LEU A 173      46.457  41.965  35.472  1.00107.40           C  
ATOM   1461  CD2 LEU A 173      44.330  42.168  34.154  1.00107.09           C  
ATOM   1462  N   GLU A 174      47.366  44.162  30.340  1.00109.31           N  
ATOM   1463  CA  GLU A 174      48.162  44.999  29.443  1.00110.49           C  
ATOM   1464  C   GLU A 174      47.282  45.774  28.483  1.00111.50           C  
ATOM   1465  O   GLU A 174      47.023  46.968  28.659  1.00111.64           O  
ATOM   1466  CB  GLU A 174      49.042  44.113  28.562  1.00110.38           C  
ATOM   1467  CG  GLU A 174      50.467  43.893  28.978  1.00110.35           C  
ATOM   1468  CD  GLU A 174      51.214  43.084  27.928  1.00110.32           C  
ATOM   1469  OE1 GLU A 174      50.665  42.049  27.474  1.00109.29           O  
ATOM   1470  OE2 GLU A 174      52.336  43.488  27.544  1.00110.05           O  
ATOM   1471  N   ARG A 175      46.821  45.045  27.467  1.00112.75           N  
ATOM   1472  CA  ARG A 175      46.254  45.603  26.243  1.00113.92           C  
ATOM   1473  C   ARG A 175      44.843  46.160  26.423  1.00114.38           C  
ATOM   1474  O   ARG A 175      44.403  47.016  25.642  1.00114.51           O  
ATOM   1475  CB  ARG A 175      46.265  44.531  25.136  1.00114.07           C  
ATOM   1476  CG  ARG A 175      47.664  44.026  24.770  1.00114.33           C  
ATOM   1477  CD  ARG A 175      47.651  43.064  23.594  1.00114.25           C  
ATOM   1478  NE  ARG A 175      48.745  43.374  22.672  1.00115.07           N  
ATOM   1479  CZ  ARG A 175      49.266  42.531  21.783  1.00115.42           C  
ATOM   1480  NH1 ARG A 175      48.814  41.283  21.676  1.00115.12           N  
ATOM   1481  NH2 ARG A 175      50.258  42.943  21.002  1.00115.42           N  
ATOM   1482  N   ASN A 176      44.153  45.686  27.461  1.00114.87           N  
ATOM   1483  CA  ASN A 176      42.724  45.940  27.625  1.00115.28           C  
ATOM   1484  C   ASN A 176      42.317  46.858  28.786  1.00115.65           C  
ATOM   1485  O   ASN A 176      41.770  47.939  28.566  1.00115.78           O  
ATOM   1486  CB  ASN A 176      41.961  44.606  27.744  1.00115.09           C  
ATOM   1487  CG  ASN A 176      42.072  43.725  26.497  1.00114.91           C  
ATOM   1488  OD1 ASN A 176      43.045  43.785  25.729  1.00114.55           O  
ATOM   1489  ND2 ASN A 176      41.068  42.880  26.306  1.00114.25           N  
ATOM   1490  N   ASP A 177      42.620  46.437  30.011  1.00116.14           N  
ATOM   1491  CA  ASP A 177      41.753  46.730  31.162  1.00116.78           C  
ATOM   1492  C   ASP A 177      41.929  47.985  32.036  1.00116.81           C  
ATOM   1493  O   ASP A 177      42.484  49.014  31.624  1.00116.68           O  
ATOM   1494  CB  ASP A 177      41.681  45.496  32.074  1.00117.10           C  
ATOM   1495  CG  ASP A 177      40.369  44.740  31.937  1.00118.38           C  
ATOM   1496  OD1 ASP A 177      39.476  45.218  31.185  1.00119.79           O  
ATOM   1497  OD2 ASP A 177      40.234  43.676  32.595  1.00118.76           O  
ATOM   1498  N   PHE A 178      41.377  47.843  33.246  1.00116.88           N  
ATOM   1499  CA  PHE A 178      41.352  48.834  34.312  1.00116.88           C  
ATOM   1500  C   PHE A 178      41.629  48.118  35.640  1.00116.68           C  
ATOM   1501  O   PHE A 178      42.781  48.040  36.071  1.00116.71           O  
ATOM   1502  CB  PHE A 178      39.968  49.481  34.417  1.00117.12           C  
ATOM   1503  CG  PHE A 178      39.558  50.280  33.217  1.00117.40           C  
ATOM   1504  CD1 PHE A 178      38.924  49.665  32.136  1.00117.45           C  
ATOM   1505  CD2 PHE A 178      39.760  51.661  33.190  1.00117.50           C  
ATOM   1506  CE1 PHE A 178      38.528  50.403  31.035  1.00117.44           C  
ATOM   1507  CE2 PHE A 178      39.367  52.417  32.093  1.00117.64           C  
ATOM   1508  CZ  PHE A 178      38.750  51.786  31.012  1.00117.84           C  
ATOM   1509  N   ASN A 179      40.561  47.590  36.259  1.00116.33           N  
ATOM   1510  CA  ASN A 179      40.580  47.010  37.620  1.00116.04           C  
ATOM   1511  C   ASN A 179      40.106  45.539  37.688  1.00115.75           C  
ATOM   1512  O   ASN A 179      38.973  45.286  38.110  1.00115.79           O  
ATOM   1513  CB  ASN A 179      39.697  47.842  38.574  1.00115.97           C  
ATOM   1514  CG  ASN A 179      40.354  49.136  39.039  1.00116.08           C  
ATOM   1515  OD1 ASN A 179      41.426  49.525  38.570  1.00116.06           O  
ATOM   1516  ND2 ASN A 179      39.699  49.813  39.976  1.00116.28           N  
ATOM   1517  N   PRO A 180      40.974  44.568  37.308  1.00115.44           N  
ATOM   1518  CA  PRO A 180      40.570  43.139  37.187  1.00114.89           C  
ATOM   1519  C   PRO A 180      40.281  42.446  38.526  1.00114.07           C  
ATOM   1520  O   PRO A 180      39.440  42.924  39.299  1.00113.98           O  
ATOM   1521  CB  PRO A 180      41.784  42.495  36.509  1.00114.98           C  
ATOM   1522  CG  PRO A 180      42.946  43.359  36.944  1.00115.26           C  
ATOM   1523  CD  PRO A 180      42.403  44.763  36.977  1.00115.37           C  
ATOM   1524  N   LYS A 181      40.971  41.331  38.783  1.00113.06           N  
ATOM   1525  CA  LYS A 181      40.991  40.692  40.108  1.00112.38           C  
ATOM   1526  C   LYS A 181      39.696  39.940  40.414  1.00111.56           C  
ATOM   1527  O   LYS A 181      38.766  39.938  39.602  1.00111.71           O  
ATOM   1528  CB  LYS A 181      41.278  41.727  41.217  1.00112.70           C  
ATOM   1529  CG  LYS A 181      42.437  42.703  40.925  1.00112.96           C  
ATOM   1530  CD  LYS A 181      42.509  43.821  41.960  1.00112.52           C  
ATOM   1531  CE  LYS A 181      43.887  44.462  41.963  1.00112.38           C  
ATOM   1532  NZ  LYS A 181      44.308  44.829  43.341  1.00111.96           N  
ATOM   1533  N   ARG A 182      39.642  39.311  41.589  1.00110.27           N  
ATOM   1534  CA  ARG A 182      38.477  38.537  42.042  1.00109.38           C  
ATOM   1535  C   ARG A 182      38.217  37.265  41.217  1.00108.13           C  
ATOM   1536  O   ARG A 182      37.878  36.209  41.796  1.00108.04           O  
ATOM   1537  CB  ARG A 182      37.220  39.416  42.130  1.00109.41           C  
ATOM   1538  CG  ARG A 182      37.434  40.663  42.982  1.00110.43           C  
ATOM   1539  CD  ARG A 182      36.152  41.448  43.278  1.00110.63           C  
ATOM   1540  NE  ARG A 182      36.397  42.500  44.281  1.00113.22           N  
ATOM   1541  CZ  ARG A 182      35.472  43.328  44.780  1.00114.32           C  
ATOM   1542  NH1 ARG A 182      34.203  43.258  44.380  1.00115.14           N  
ATOM   1543  NH2 ARG A 182      35.819  44.237  45.691  1.00114.53           N  
ATOM   1544  N   ILE A 183      38.385  37.381  39.888  1.00106.37           N  
ATOM   1545  CA  ILE A 183      38.237  36.276  38.920  1.00104.54           C  
ATOM   1546  C   ILE A 183      39.285  35.191  39.146  1.00103.31           C  
ATOM   1547  O   ILE A 183      40.491  35.497  39.198  1.00103.15           O  
ATOM   1548  CB  ILE A 183      38.386  36.734  37.438  1.00104.47           C  
ATOM   1549  CG1 ILE A 183      37.380  37.835  37.082  1.00105.46           C  
ATOM   1550  CG2 ILE A 183      38.198  35.549  36.492  1.00104.01           C  
ATOM   1551  CD1 ILE A 183      37.299  38.184  35.568  1.00104.77           C  
ATOM   1552  N   ARG A 184      38.811  33.942  39.252  1.00101.27           N  
ATOM   1553  CA  ARG A 184      39.658  32.745  39.402  1.00 99.58           C  
ATOM   1554  C   ARG A 184      40.340  32.193  38.105  1.00 97.46           C  
ATOM   1555  O   ARG A 184      39.858  32.379  36.973  1.00 97.41           O  
ATOM   1556  CB  ARG A 184      38.894  31.636  40.149  1.00 99.99           C  
ATOM   1557  CG  ARG A 184      37.621  31.109  39.455  1.00100.90           C  
ATOM   1558  CD  ARG A 184      37.044  29.939  40.237  1.00101.11           C  
ATOM   1559  NE  ARG A 184      35.606  30.123  40.432  1.00105.98           N  
ATOM   1560  CZ  ARG A 184      34.825  29.336  41.173  1.00107.03           C  
ATOM   1561  NH1 ARG A 184      35.333  28.285  41.814  1.00106.82           N  
ATOM   1562  NH2 ARG A 184      33.526  29.608  41.268  1.00107.84           N  
ATOM   1563  N   VAL A 185      41.440  31.463  38.312  1.00 94.69           N  
ATOM   1564  CA  VAL A 185      42.471  31.225  37.294  1.00 91.63           C  
ATOM   1565  C   VAL A 185      43.094  29.783  37.303  1.00 89.46           C  
ATOM   1566  O   VAL A 185      42.881  29.012  38.239  1.00 89.14           O  
ATOM   1567  CB  VAL A 185      43.546  32.310  37.478  1.00 91.55           C  
ATOM   1568  CG1 VAL A 185      44.562  32.256  36.393  1.00 92.56           C  
ATOM   1569  CG2 VAL A 185      42.892  33.676  37.479  1.00 91.08           C  
ATOM   1570  N   LYS A 186      43.846  29.434  36.252  1.00 86.82           N  
ATOM   1571  CA  LYS A 186      44.505  28.122  36.105  1.00 84.03           C  
ATOM   1572  C   LYS A 186      45.778  28.248  35.296  1.00 82.75           C  
ATOM   1573  O   LYS A 186      45.740  28.677  34.155  1.00 82.48           O  
ATOM   1574  CB  LYS A 186      43.588  27.148  35.385  1.00 83.72           C  
ATOM   1575  CG  LYS A 186      43.964  25.696  35.520  1.00 81.48           C  
ATOM   1576  CD  LYS A 186      44.848  25.195  34.418  1.00 77.67           C  
ATOM   1577  CE  LYS A 186      44.744  23.688  34.353  1.00 75.08           C  
ATOM   1578  NZ  LYS A 186      45.996  23.031  33.904  1.00 73.04           N  
ATOM   1579  N   PRO A 187      46.915  27.874  35.882  1.00 81.62           N  
ATOM   1580  CA  PRO A 187      48.164  27.997  35.144  1.00 81.03           C  
ATOM   1581  C   PRO A 187      48.308  26.914  34.087  1.00 80.70           C  
ATOM   1582  O   PRO A 187      48.007  25.763  34.344  1.00 80.60           O  
ATOM   1583  CB  PRO A 187      49.234  27.825  36.223  1.00 80.61           C  
ATOM   1584  CG  PRO A 187      48.504  27.842  37.533  1.00 80.87           C  
ATOM   1585  CD  PRO A 187      47.128  27.373  37.244  1.00 81.31           C  
ATOM   1586  N   ILE A 188      48.739  27.299  32.893  1.00 80.52           N  
ATOM   1587  CA  ILE A 188      49.085  26.352  31.859  1.00 80.20           C  
ATOM   1588  C   ILE A 188      50.071  25.387  32.478  1.00 80.47           C  
ATOM   1589  O   ILE A 188      51.013  25.800  33.142  1.00 80.31           O  
ATOM   1590  CB  ILE A 188      49.765  27.047  30.668  1.00 80.15           C  
ATOM   1591  CG1 ILE A 188      48.946  28.237  30.187  1.00 80.25           C  
ATOM   1592  CG2 ILE A 188      49.935  26.090  29.518  1.00 79.99           C  
ATOM   1593  CD1 ILE A 188      49.718  29.150  29.259  1.00 81.80           C  
ATOM   1594  N   GLY A 189      49.827  24.098  32.285  1.00 81.07           N  
ATOM   1595  CA  GLY A 189      50.737  23.054  32.750  1.00 81.79           C  
ATOM   1596  C   GLY A 189      50.791  22.763  34.242  1.00 82.20           C  
ATOM   1597  O   GLY A 189      51.745  22.121  34.709  1.00 82.01           O  
ATOM   1598  N   ILE A 190      49.782  23.239  34.981  1.00 82.81           N  
ATOM   1599  CA  ILE A 190      49.686  23.079  36.443  1.00 83.64           C  
ATOM   1600  C   ILE A 190      48.243  22.836  36.788  1.00 84.82           C  
ATOM   1601  O   ILE A 190      47.359  23.443  36.198  1.00 84.50           O  
ATOM   1602  CB  ILE A 190      50.179  24.327  37.242  1.00 83.61           C  
ATOM   1603  CG1 ILE A 190      51.674  24.598  36.982  1.00 83.50           C  
ATOM   1604  CG2 ILE A 190      49.901  24.158  38.746  1.00 82.58           C  
ATOM   1605  CD1 ILE A 190      52.143  26.004  37.247  1.00 82.22           C  
ATOM   1606  N   ASP A 191      48.010  21.948  37.751  1.00 86.80           N  
ATOM   1607  CA  ASP A 191      46.660  21.480  38.049  1.00 88.53           C  
ATOM   1608  C   ASP A 191      45.838  22.567  38.726  1.00 89.37           C  
ATOM   1609  O   ASP A 191      44.929  23.119  38.112  1.00 89.73           O  
ATOM   1610  CB  ASP A 191      46.691  20.196  38.880  1.00 88.68           C  
ATOM   1611  CG  ASP A 191      45.487  19.301  38.624  1.00 89.92           C  
ATOM   1612  OD1 ASP A 191      44.486  19.804  38.071  1.00 90.81           O  
ATOM   1613  OD2 ASP A 191      45.541  18.094  38.976  1.00 91.59           O  
ATOM   1614  N   PHE A 192      46.176  22.876  39.973  1.00 90.35           N  
ATOM   1615  CA  PHE A 192      45.537  23.942  40.764  1.00 91.65           C  
ATOM   1616  C   PHE A 192      44.746  25.040  39.999  1.00 91.87           C  
ATOM   1617  O   PHE A 192      45.183  25.545  38.969  1.00 91.43           O  
ATOM   1618  CB  PHE A 192      46.609  24.562  41.671  1.00 92.20           C  
ATOM   1619  CG  PHE A 192      46.144  25.749  42.482  1.00 93.35           C  
ATOM   1620  CD1 PHE A 192      45.895  25.613  43.850  1.00 93.80           C  
ATOM   1621  CD2 PHE A 192      46.006  27.014  41.891  1.00 93.90           C  
ATOM   1622  CE1 PHE A 192      45.498  26.708  44.612  1.00 94.17           C  
ATOM   1623  CE2 PHE A 192      45.598  28.111  42.640  1.00 94.48           C  
ATOM   1624  CZ  PHE A 192      45.349  27.963  44.008  1.00 94.25           C  
ATOM   1625  N   VAL A 193      43.585  25.395  40.546  1.00 92.67           N  
ATOM   1626  CA  VAL A 193      42.711  26.453  40.017  1.00 93.71           C  
ATOM   1627  C   VAL A 193      42.202  27.343  41.166  1.00 94.39           C  
ATOM   1628  O   VAL A 193      41.662  26.814  42.129  1.00 94.93           O  
ATOM   1629  CB  VAL A 193      41.472  25.832  39.340  1.00 93.50           C  
ATOM   1630  CG1 VAL A 193      40.530  26.908  38.824  1.00 93.13           C  
ATOM   1631  CG2 VAL A 193      41.887  24.904  38.223  1.00 93.96           C  
ATOM   1632  N   GLY A 194      42.327  28.668  41.087  1.00 94.78           N  
ATOM   1633  CA  GLY A 194      41.815  29.486  42.190  1.00 95.62           C  
ATOM   1634  C   GLY A 194      41.702  30.983  42.027  1.00 96.42           C  
ATOM   1635  O   GLY A 194      42.292  31.568  41.133  1.00 96.19           O  
ATOM   1636  N   ARG A 195      40.944  31.599  42.928  1.00 97.53           N  
ATOM   1637  CA  ARG A 195      40.706  33.049  42.925  1.00 98.57           C  
ATOM   1638  C   ARG A 195      41.990  33.874  43.064  1.00 98.53           C  
ATOM   1639  O   ARG A 195      42.914  33.463  43.771  1.00 98.72           O  
ATOM   1640  CB  ARG A 195      39.720  33.437  44.048  1.00 99.21           C  
ATOM   1641  CG  ARG A 195      38.667  32.374  44.393  1.00100.97           C  
ATOM   1642  CD  ARG A 195      37.239  32.942  44.334  1.00103.98           C  
ATOM   1643  NE  ARG A 195      36.242  31.864  44.237  1.00106.02           N  
ATOM   1644  CZ  ARG A 195      34.971  32.013  43.856  1.00106.37           C  
ATOM   1645  NH1 ARG A 195      34.496  33.210  43.511  1.00106.87           N  
ATOM   1646  NH2 ARG A 195      34.172  30.953  43.819  1.00105.57           N  
ATOM   1647  N   VAL A 196      42.025  35.031  42.389  1.00 98.52           N  
ATOM   1648  CA  VAL A 196      43.101  36.045  42.496  1.00 98.30           C  
ATOM   1649  C   VAL A 196      42.940  36.879  43.776  1.00 98.23           C  
ATOM   1650  O   VAL A 196      41.815  37.189  44.179  1.00 97.89           O  
ATOM   1651  CB  VAL A 196      43.066  37.018  41.273  1.00 98.40           C  
ATOM   1652  CG1 VAL A 196      44.046  38.175  41.434  1.00 98.51           C  
ATOM   1653  CG2 VAL A 196      43.345  36.290  39.980  1.00 98.09           C  
ATOM   1654  N   GLN A 197      44.056  37.236  44.410  1.00 98.46           N  
ATOM   1655  CA  GLN A 197      44.027  38.038  45.647  1.00 98.96           C  
ATOM   1656  C   GLN A 197      45.149  39.075  45.802  1.00 98.94           C  
ATOM   1657  O   GLN A 197      45.388  39.525  46.924  1.00 98.93           O  
ATOM   1658  CB  GLN A 197      43.998  37.129  46.889  1.00 99.13           C  
ATOM   1659  CG  GLN A 197      42.630  36.516  47.185  1.00100.28           C  
ATOM   1660  CD  GLN A 197      42.724  35.060  47.596  1.00101.16           C  
ATOM   1661  OE1 GLN A 197      43.777  34.606  48.046  1.00102.21           O  
ATOM   1662  NE2 GLN A 197      41.624  34.319  47.441  1.00100.55           N  
ATOM   1663  N   ASP A 198      45.819  39.443  44.698  1.00 99.07           N  
ATOM   1664  CA  ASP A 198      46.928  40.436  44.686  1.00 99.23           C  
ATOM   1665  C   ASP A 198      47.642  40.566  43.347  1.00 98.86           C  
ATOM   1666  O   ASP A 198      48.118  39.575  42.811  1.00 98.75           O  
ATOM   1667  CB  ASP A 198      48.001  40.089  45.722  1.00 99.64           C  
ATOM   1668  CG  ASP A 198      48.096  41.109  46.839  1.00101.13           C  
ATOM   1669  OD1 ASP A 198      47.998  42.335  46.569  1.00102.40           O  
ATOM   1670  OD2 ASP A 198      48.288  40.670  47.996  1.00103.08           O  
ATOM   1671  N   VAL A 199      47.757  41.789  42.831  1.00 98.66           N  
ATOM   1672  CA  VAL A 199      48.548  42.040  41.614  1.00 98.48           C  
ATOM   1673  C   VAL A 199      49.564  43.183  41.777  1.00 98.41           C  
ATOM   1674  O   VAL A 199      49.245  44.257  42.322  1.00 98.37           O  
ATOM   1675  CB  VAL A 199      47.662  42.327  40.352  1.00 98.53           C  
ATOM   1676  CG1 VAL A 199      48.530  42.487  39.082  1.00 98.25           C  
ATOM   1677  CG2 VAL A 199      46.622  41.235  40.138  1.00 98.78           C  
ATOM   1678  N   PHE A 200      50.784  42.929  41.299  1.00 98.07           N  
ATOM   1679  CA  PHE A 200      51.805  43.968  41.110  1.00 97.82           C  
ATOM   1680  C   PHE A 200      52.621  43.738  39.840  1.00 97.23           C  
ATOM   1681  O   PHE A 200      52.858  42.597  39.451  1.00 97.16           O  
ATOM   1682  CB  PHE A 200      52.745  44.130  42.332  1.00 98.11           C  
ATOM   1683  CG  PHE A 200      52.660  43.011  43.362  1.00 98.51           C  
ATOM   1684  CD1 PHE A 200      53.196  41.748  43.102  1.00 98.15           C  
ATOM   1685  CD2 PHE A 200      52.083  43.254  44.621  1.00 98.77           C  
ATOM   1686  CE1 PHE A 200      53.127  40.741  44.065  1.00 98.66           C  
ATOM   1687  CE2 PHE A 200      52.007  42.252  45.593  1.00 98.42           C  
ATOM   1688  CZ  PHE A 200      52.528  40.994  45.315  1.00 98.58           C  
ATOM   1689  N   LYS A 201      53.046  44.825  39.197  1.00 96.53           N  
ATOM   1690  CA  LYS A 201      54.013  44.724  38.103  1.00 95.88           C  
ATOM   1691  C   LYS A 201      55.246  43.949  38.560  1.00 95.42           C  
ATOM   1692  O   LYS A 201      55.602  43.969  39.740  1.00 95.42           O  
ATOM   1693  CB  LYS A 201      54.434  46.103  37.580  1.00 95.82           C  
ATOM   1694  CG  LYS A 201      53.637  46.606  36.374  1.00 95.46           C  
ATOM   1695  CD  LYS A 201      54.406  47.677  35.607  1.00 94.66           C  
ATOM   1696  CE  LYS A 201      53.477  48.559  34.800  1.00 94.36           C  
ATOM   1697  NZ  LYS A 201      54.232  49.587  34.035  1.00 93.77           N  
ATOM   1698  N   ALA A 202      55.884  43.265  37.615  1.00 94.70           N  
ATOM   1699  CA  ALA A 202      57.098  42.501  37.883  1.00 93.90           C  
ATOM   1700  C   ALA A 202      58.332  43.390  37.995  1.00 93.29           C  
ATOM   1701  O   ALA A 202      59.333  42.999  38.608  1.00 92.91           O  
ATOM   1702  CB  ALA A 202      57.305  41.465  36.799  1.00 94.07           C  
ATOM   1703  N   LYS A 203      58.244  44.582  37.399  1.00 92.72           N  
ATOM   1704  CA  LYS A 203      59.373  45.519  37.284  1.00 91.96           C  
ATOM   1705  C   LYS A 203      59.900  45.959  38.654  1.00 91.33           C  
ATOM   1706  O   LYS A 203      61.034  46.425  38.770  1.00 90.93           O  
ATOM   1707  CB  LYS A 203      58.964  46.725  36.433  1.00 92.08           C  
ATOM   1708  CG  LYS A 203      60.109  47.510  35.793  1.00 92.05           C  
ATOM   1709  CD  LYS A 203      59.645  48.902  35.366  1.00 91.17           C  
ATOM   1710  CE  LYS A 203      58.993  49.637  36.534  1.00 91.61           C  
ATOM   1711  NZ  LYS A 203      59.132  51.108  36.418  1.00 93.10           N  
ATOM   1712  N   GLU A 204      59.060  45.789  39.678  1.00 90.77           N  
ATOM   1713  CA  GLU A 204      59.439  45.955  41.081  1.00 90.28           C  
ATOM   1714  C   GLU A 204      60.639  45.089  41.506  1.00 89.76           C  
ATOM   1715  O   GLU A 204      61.558  45.586  42.154  1.00 89.89           O  
ATOM   1716  CB  GLU A 204      58.270  45.572  41.989  1.00 90.28           C  
ATOM   1717  CG  GLU A 204      57.180  46.597  42.213  1.00 90.34           C  
ATOM   1718  CD  GLU A 204      56.158  46.085  43.229  1.00 90.64           C  
ATOM   1719  OE1 GLU A 204      56.501  45.165  44.008  1.00 90.54           O  
ATOM   1720  OE2 GLU A 204      55.012  46.587  43.260  1.00 91.42           O  
ATOM   1721  N   LYS A 205      60.618  43.802  41.145  1.00 88.97           N  
ATOM   1722  CA  LYS A 205      61.535  42.798  41.711  1.00 88.14           C  
ATOM   1723  C   LYS A 205      62.904  42.734  41.036  1.00 87.81           C  
ATOM   1724  O   LYS A 205      63.004  42.827  39.813  1.00 87.87           O  
ATOM   1725  CB  LYS A 205      60.882  41.411  41.690  1.00 88.09           C  
ATOM   1726  CG  LYS A 205      59.511  41.344  42.336  1.00 87.00           C  
ATOM   1727  CD  LYS A 205      59.574  41.585  43.823  1.00 85.70           C  
ATOM   1728  CE  LYS A 205      58.193  41.884  44.345  1.00 85.52           C  
ATOM   1729  NZ  LYS A 205      58.176  41.872  45.825  1.00 86.15           N  
ATOM   1730  N   GLY A 206      63.950  42.542  41.840  1.00 87.36           N  
ATOM   1731  CA  GLY A 206      65.339  42.579  41.359  1.00 86.88           C  
ATOM   1732  C   GLY A 206      65.763  41.320  40.626  1.00 86.43           C  
ATOM   1733  O   GLY A 206      64.928  40.588  40.106  1.00 86.54           O  
ATOM   1734  N   GLU A 207      67.068  41.070  40.578  1.00 85.99           N  
ATOM   1735  CA  GLU A 207      67.596  39.872  39.934  1.00 85.36           C  
ATOM   1736  C   GLU A 207      67.281  38.617  40.732  1.00 85.34           C  
ATOM   1737  O   GLU A 207      66.731  37.660  40.179  1.00 85.73           O  
ATOM   1738  CB  GLU A 207      69.101  39.992  39.679  1.00 85.47           C  
ATOM   1739  CG  GLU A 207      69.459  40.531  38.294  1.00 84.34           C  
ATOM   1740  CD  GLU A 207      68.990  39.617  37.172  1.00 81.95           C  
ATOM   1741  OE1 GLU A 207      68.673  38.443  37.445  1.00 80.89           O  
ATOM   1742  OE2 GLU A 207      68.944  40.071  36.013  1.00 80.73           O  
ATOM   1743  N   GLU A 208      67.601  38.632  42.028  1.00 84.91           N  
ATOM   1744  CA  GLU A 208      67.316  37.509  42.945  1.00 84.60           C  
ATOM   1745  C   GLU A 208      65.942  36.860  42.771  1.00 84.11           C  
ATOM   1746  O   GLU A 208      65.845  35.644  42.607  1.00 83.92           O  
ATOM   1747  CB  GLU A 208      67.436  37.962  44.401  1.00 84.71           C  
ATOM   1748  CG  GLU A 208      68.652  37.454  45.154  1.00 85.25           C  
ATOM   1749  CD  GLU A 208      68.993  38.344  46.346  1.00 85.93           C  
ATOM   1750  OE1 GLU A 208      68.096  38.593  47.180  1.00 85.58           O  
ATOM   1751  OE2 GLU A 208      70.156  38.806  46.446  1.00 86.43           O  
ATOM   1752  N   PHE A 209      64.894  37.682  42.813  1.00 83.50           N  
ATOM   1753  CA  PHE A 209      63.516  37.201  42.890  1.00 83.06           C  
ATOM   1754  C   PHE A 209      63.109  36.176  41.812  1.00 82.88           C  
ATOM   1755  O   PHE A 209      62.372  35.228  42.104  1.00 82.83           O  
ATOM   1756  CB  PHE A 209      62.535  38.370  42.915  1.00 82.93           C  
ATOM   1757  CG  PHE A 209      61.123  37.950  43.124  1.00 83.05           C  
ATOM   1758  CD1 PHE A 209      60.613  37.804  44.417  1.00 83.99           C  
ATOM   1759  CD2 PHE A 209      60.301  37.665  42.036  1.00 82.87           C  
ATOM   1760  CE1 PHE A 209      59.281  37.389  44.634  1.00 83.78           C  
ATOM   1761  CE2 PHE A 209      58.977  37.251  42.230  1.00 83.65           C  
ATOM   1762  CZ  PHE A 209      58.460  37.113  43.538  1.00 83.44           C  
ATOM   1763  N   PHE A 210      63.580  36.362  40.578  1.00 82.44           N  
ATOM   1764  CA  PHE A 210      63.295  35.399  39.511  1.00 81.74           C  
ATOM   1765  C   PHE A 210      64.334  34.288  39.452  1.00 81.30           C  
ATOM   1766  O   PHE A 210      64.016  33.199  38.987  1.00 81.00           O  
ATOM   1767  CB  PHE A 210      63.150  36.078  38.149  1.00 81.90           C  
ATOM   1768  CG  PHE A 210      62.457  37.413  38.206  1.00 82.42           C  
ATOM   1769  CD1 PHE A 210      63.182  38.595  38.040  1.00 82.98           C  
ATOM   1770  CD2 PHE A 210      61.088  37.496  38.436  1.00 82.46           C  
ATOM   1771  CE1 PHE A 210      62.548  39.842  38.092  1.00 82.61           C  
ATOM   1772  CE2 PHE A 210      60.448  38.739  38.490  1.00 82.58           C  
ATOM   1773  CZ  PHE A 210      61.181  39.912  38.320  1.00 82.22           C  
ATOM   1774  N   ARG A 211      65.564  34.551  39.917  1.00 80.99           N  
ATOM   1775  CA  ARG A 211      66.523  33.465  40.181  1.00 80.52           C  
ATOM   1776  C   ARG A 211      65.756  32.449  41.051  1.00 80.23           C  
ATOM   1777  O   ARG A 211      65.560  31.288  40.666  1.00 79.92           O  
ATOM   1778  CB  ARG A 211      67.807  33.954  40.899  1.00 80.40           C  
ATOM   1779  CG  ARG A 211      68.704  34.957  40.126  1.00 80.79           C  
ATOM   1780  CD  ARG A 211      70.201  34.965  40.589  1.00 80.56           C  
ATOM   1781  NE  ARG A 211      70.943  36.155  40.129  1.00 80.92           N  
ATOM   1782  CZ  ARG A 211      72.261  36.374  40.288  1.00 81.24           C  
ATOM   1783  NH1 ARG A 211      73.039  35.477  40.891  1.00 81.56           N  
ATOM   1784  NH2 ARG A 211      72.816  37.502  39.834  1.00 78.96           N  
ATOM   1785  N   LEU A 212      65.254  32.948  42.183  1.00 79.92           N  
ATOM   1786  CA  LEU A 212      64.580  32.157  43.219  1.00 79.27           C  
ATOM   1787  C   LEU A 212      63.301  31.438  42.791  1.00 78.95           C  
ATOM   1788  O   LEU A 212      63.095  30.292  43.164  1.00 79.05           O  
ATOM   1789  CB  LEU A 212      64.330  33.023  44.458  1.00 79.08           C  
ATOM   1790  CG  LEU A 212      65.607  33.534  45.142  1.00 78.39           C  
ATOM   1791  CD1 LEU A 212      65.279  34.487  46.289  1.00 77.73           C  
ATOM   1792  CD2 LEU A 212      66.485  32.371  45.612  1.00 76.84           C  
ATOM   1793  N   CYS A 213      62.448  32.095  42.014  1.00 78.59           N  
ATOM   1794  CA  CYS A 213      61.254  31.436  41.492  1.00 78.31           C  
ATOM   1795  C   CYS A 213      61.599  30.361  40.481  1.00 78.20           C  
ATOM   1796  O   CYS A 213      60.912  29.355  40.403  1.00 78.31           O  
ATOM   1797  CB  CYS A 213      60.327  32.432  40.824  1.00 78.14           C  
ATOM   1798  SG  CYS A 213      59.522  33.580  41.930  1.00 78.60           S  
ATOM   1799  N   MET A 214      62.646  30.584  39.697  1.00 78.14           N  
ATOM   1800  CA  MET A 214      63.061  29.617  38.695  1.00 78.37           C  
ATOM   1801  C   MET A 214      63.527  28.348  39.391  1.00 78.03           C  
ATOM   1802  O   MET A 214      63.022  27.262  39.112  1.00 78.25           O  
ATOM   1803  CB  MET A 214      64.183  30.178  37.817  1.00 78.36           C  
ATOM   1804  CG  MET A 214      64.351  29.475  36.480  1.00 78.66           C  
ATOM   1805  SD  MET A 214      66.070  29.467  35.905  1.00 79.47           S  
ATOM   1806  CE  MET A 214      66.540  27.752  36.243  1.00 78.55           C  
ATOM   1807  N   GLU A 215      64.474  28.502  40.313  1.00 77.66           N  
ATOM   1808  CA  GLU A 215      65.064  27.375  41.021  1.00 77.39           C  
ATOM   1809  C   GLU A 215      64.025  26.473  41.711  1.00 77.01           C  
ATOM   1810  O   GLU A 215      64.217  25.262  41.803  1.00 77.03           O  
ATOM   1811  CB  GLU A 215      66.105  27.878  42.023  1.00 77.26           C  
ATOM   1812  CG  GLU A 215      67.383  28.384  41.364  1.00 78.55           C  
ATOM   1813  CD  GLU A 215      68.066  29.542  42.125  1.00 80.55           C  
ATOM   1814  OE1 GLU A 215      67.534  29.995  43.172  1.00 81.90           O  
ATOM   1815  OE2 GLU A 215      69.138  30.010  41.665  1.00 79.71           O  
ATOM   1816  N   ARG A 216      62.912  27.063  42.140  1.00 76.41           N  
ATOM   1817  CA  ARG A 216      61.945  26.389  43.013  1.00 76.04           C  
ATOM   1818  C   ARG A 216      60.690  25.827  42.325  1.00 75.98           C  
ATOM   1819  O   ARG A 216      60.344  24.669  42.517  1.00 75.84           O  
ATOM   1820  CB  ARG A 216      61.536  27.335  44.138  1.00 75.97           C  
ATOM   1821  CG  ARG A 216      62.708  27.871  44.929  1.00 75.56           C  
ATOM   1822  CD  ARG A 216      62.301  29.043  45.781  1.00 73.78           C  
ATOM   1823  NE  ARG A 216      63.417  29.530  46.590  1.00 73.76           N  
ATOM   1824  CZ  ARG A 216      63.341  30.578  47.408  1.00 74.23           C  
ATOM   1825  NH1 ARG A 216      62.199  31.248  47.521  1.00 74.28           N  
ATOM   1826  NH2 ARG A 216      64.400  30.963  48.112  1.00 73.77           N  
ATOM   1827  N   SER A 217      60.012  26.657  41.536  1.00 76.13           N  
ATOM   1828  CA  SER A 217      58.799  26.263  40.814  1.00 76.02           C  
ATOM   1829  C   SER A 217      58.846  24.809  40.367  1.00 75.73           C  
ATOM   1830  O   SER A 217      59.722  24.397  39.608  1.00 75.88           O  
ATOM   1831  CB  SER A 217      58.549  27.197  39.620  1.00 76.12           C  
ATOM   1832  OG  SER A 217      59.598  27.116  38.666  1.00 76.39           O  
ATOM   1833  N   THR A 218      57.874  24.049  40.851  1.00 75.66           N  
ATOM   1834  CA  THR A 218      57.871  22.581  40.765  1.00 75.53           C  
ATOM   1835  C   THR A 218      57.344  22.033  39.425  1.00 75.32           C  
ATOM   1836  O   THR A 218      57.177  20.813  39.250  1.00 75.00           O  
ATOM   1837  CB  THR A 218      57.058  21.972  41.959  1.00 75.61           C  
ATOM   1838  OG1 THR A 218      55.993  22.866  42.323  1.00 74.90           O  
ATOM   1839  CG2 THR A 218      57.960  21.759  43.180  1.00 75.17           C  
ATOM   1840  N   HIS A 219      57.091  22.947  38.489  1.00 74.99           N  
ATOM   1841  CA  HIS A 219      56.478  22.608  37.213  1.00 74.44           C  
ATOM   1842  C   HIS A 219      57.229  23.215  36.055  1.00 74.09           C  
ATOM   1843  O   HIS A 219      57.852  24.268  36.199  1.00 74.08           O  
ATOM   1844  CB  HIS A 219      55.022  23.052  37.204  1.00 74.31           C  
ATOM   1845  CG  HIS A 219      54.182  22.314  38.192  1.00 74.43           C  
ATOM   1846  ND1 HIS A 219      53.437  21.201  37.856  1.00 75.43           N  
ATOM   1847  CD2 HIS A 219      54.004  22.499  39.520  1.00 73.86           C  
ATOM   1848  CE1 HIS A 219      52.827  20.742  38.932  1.00 74.80           C  
ATOM   1849  NE2 HIS A 219      53.151  21.516  39.953  1.00 74.21           N  
ATOM   1850  N   LYS A 220      57.162  22.547  34.909  1.00 73.64           N  
ATOM   1851  CA  LYS A 220      57.907  22.978  33.742  1.00 73.66           C  
ATOM   1852  C   LYS A 220      57.446  24.347  33.235  1.00 73.42           C  
ATOM   1853  O   LYS A 220      58.276  25.238  33.017  1.00 73.26           O  
ATOM   1854  CB  LYS A 220      57.856  21.911  32.658  1.00 73.39           C  
ATOM   1855  CG  LYS A 220      58.099  20.573  33.244  1.00 74.33           C  
ATOM   1856  CD  LYS A 220      58.891  19.686  32.329  1.00 77.04           C  
ATOM   1857  CE  LYS A 220      59.113  18.323  33.001  1.00 78.44           C  
ATOM   1858  NZ  LYS A 220      59.702  17.331  32.052  1.00 80.58           N  
ATOM   1859  N   SER A 221      56.128  24.502  33.097  1.00 73.18           N  
ATOM   1860  CA  SER A 221      55.508  25.755  32.654  1.00 73.09           C  
ATOM   1861  C   SER A 221      55.820  26.942  33.566  1.00 72.99           C  
ATOM   1862  O   SER A 221      56.201  28.009  33.080  1.00 73.22           O  
ATOM   1863  CB  SER A 221      53.992  25.593  32.491  1.00 73.22           C  
ATOM   1864  OG  SER A 221      53.370  25.190  33.699  1.00 72.94           O  
ATOM   1865  N   SER A 222      55.671  26.757  34.876  1.00 72.72           N  
ATOM   1866  CA  SER A 222      56.090  27.775  35.830  1.00 72.55           C  
ATOM   1867  C   SER A 222      57.607  28.043  35.739  1.00 73.15           C  
ATOM   1868  O   SER A 222      58.038  29.199  35.701  1.00 72.99           O  
ATOM   1869  CB  SER A 222      55.619  27.456  37.259  1.00 72.00           C  
ATOM   1870  OG  SER A 222      56.051  26.192  37.710  1.00 71.01           O  
ATOM   1871  N   LYS A 223      58.402  26.981  35.647  1.00 73.73           N  
ATOM   1872  CA  LYS A 223      59.856  27.126  35.597  1.00 74.58           C  
ATOM   1873  C   LYS A 223      60.366  27.817  34.324  1.00 75.42           C  
ATOM   1874  O   LYS A 223      61.250  28.705  34.395  1.00 75.25           O  
ATOM   1875  CB  LYS A 223      60.538  25.770  35.768  1.00 74.55           C  
ATOM   1876  CG  LYS A 223      61.879  25.865  36.440  1.00 74.00           C  
ATOM   1877  CD  LYS A 223      62.344  24.516  36.897  1.00 73.86           C  
ATOM   1878  CE  LYS A 223      63.831  24.549  37.149  1.00 74.80           C  
ATOM   1879  NZ  LYS A 223      64.398  23.184  37.084  1.00 75.10           N  
ATOM   1880  N   LYS A 224      59.825  27.398  33.171  1.00 75.97           N  
ATOM   1881  CA  LYS A 224      60.161  28.015  31.887  1.00 76.44           C  
ATOM   1882  C   LYS A 224      59.833  29.503  31.919  1.00 76.71           C  
ATOM   1883  O   LYS A 224      60.641  30.343  31.475  1.00 76.84           O  
ATOM   1884  CB  LYS A 224      59.429  27.332  30.729  1.00 76.53           C  
ATOM   1885  CG  LYS A 224      60.240  26.230  30.056  1.00 77.53           C  
ATOM   1886  CD  LYS A 224      59.384  25.351  29.151  1.00 79.13           C  
ATOM   1887  CE  LYS A 224      60.148  24.105  28.653  1.00 79.15           C  
ATOM   1888  NZ  LYS A 224      59.198  23.013  28.199  1.00 80.05           N  
ATOM   1889  N   ALA A 225      58.656  29.811  32.472  1.00 76.46           N  
ATOM   1890  CA  ALA A 225      58.122  31.163  32.505  1.00 76.22           C  
ATOM   1891  C   ALA A 225      58.965  32.125  33.349  1.00 76.34           C  
ATOM   1892  O   ALA A 225      59.263  33.231  32.899  1.00 76.54           O  
ATOM   1893  CB  ALA A 225      56.690  31.139  32.984  1.00 76.14           C  
ATOM   1894  N   TRP A 226      59.345  31.714  34.562  1.00 76.33           N  
ATOM   1895  CA  TRP A 226      60.237  32.524  35.408  1.00 76.10           C  
ATOM   1896  C   TRP A 226      61.605  32.669  34.767  1.00 76.68           C  
ATOM   1897  O   TRP A 226      62.265  33.697  34.950  1.00 76.86           O  
ATOM   1898  CB  TRP A 226      60.427  31.909  36.792  1.00 75.44           C  
ATOM   1899  CG  TRP A 226      59.233  31.946  37.656  1.00 74.24           C  
ATOM   1900  CD1 TRP A 226      58.485  30.889  38.037  1.00 73.72           C  
ATOM   1901  CD2 TRP A 226      58.646  33.098  38.267  1.00 74.06           C  
ATOM   1902  NE1 TRP A 226      57.457  31.294  38.844  1.00 73.85           N  
ATOM   1903  CE2 TRP A 226      57.527  32.650  39.005  1.00 74.09           C  
ATOM   1904  CE3 TRP A 226      58.947  34.470  38.257  1.00 73.62           C  
ATOM   1905  CZ2 TRP A 226      56.704  33.517  39.731  1.00 74.42           C  
ATOM   1906  CZ3 TRP A 226      58.137  35.334  38.983  1.00 73.70           C  
ATOM   1907  CH2 TRP A 226      57.023  34.853  39.710  1.00 74.04           C  
ATOM   1908  N   GLU A 227      62.034  31.636  34.033  1.00 77.27           N  
ATOM   1909  CA  GLU A 227      63.271  31.704  33.244  1.00 77.72           C  
ATOM   1910  C   GLU A 227      63.194  32.820  32.220  1.00 78.06           C  
ATOM   1911  O   GLU A 227      64.089  33.657  32.160  1.00 78.46           O  
ATOM   1912  CB  GLU A 227      63.577  30.382  32.540  1.00 77.90           C  
ATOM   1913  CG  GLU A 227      64.836  30.416  31.673  1.00 76.91           C  
ATOM   1914  CD  GLU A 227      65.697  29.191  31.876  1.00 76.52           C  
ATOM   1915  OE1 GLU A 227      65.203  28.053  31.700  1.00 76.32           O  
ATOM   1916  OE2 GLU A 227      66.873  29.370  32.232  1.00 76.35           O  
ATOM   1917  N   GLU A 228      62.132  32.834  31.421  1.00 78.25           N  
ATOM   1918  CA  GLU A 228      61.919  33.943  30.511  1.00 78.68           C  
ATOM   1919  C   GLU A 228      62.156  35.275  31.222  1.00 78.75           C  
ATOM   1920  O   GLU A 228      63.073  36.017  30.860  1.00 78.77           O  
ATOM   1921  CB  GLU A 228      60.521  33.897  29.915  1.00 78.74           C  
ATOM   1922  CG  GLU A 228      60.515  33.589  28.445  1.00 79.79           C  
ATOM   1923  CD  GLU A 228      59.251  32.895  28.018  1.00 81.75           C  
ATOM   1924  OE1 GLU A 228      58.175  33.548  27.944  1.00 80.95           O  
ATOM   1925  OE2 GLU A 228      59.345  31.674  27.765  1.00 83.93           O  
ATOM   1926  N   LEU A 229      61.356  35.544  32.252  1.00 78.77           N  
ATOM   1927  CA  LEU A 229      61.434  36.800  32.997  1.00 78.79           C  
ATOM   1928  C   LEU A 229      62.767  37.020  33.738  1.00 79.08           C  
ATOM   1929  O   LEU A 229      63.110  38.167  34.074  1.00 79.41           O  
ATOM   1930  CB  LEU A 229      60.233  36.974  33.944  1.00 78.62           C  
ATOM   1931  CG  LEU A 229      58.831  37.149  33.341  1.00 78.21           C  
ATOM   1932  CD1 LEU A 229      57.783  37.314  34.436  1.00 77.77           C  
ATOM   1933  CD2 LEU A 229      58.780  38.320  32.384  1.00 77.38           C  
ATOM   1934  N   LEU A 230      63.519  35.945  33.998  1.00 78.94           N  
ATOM   1935  CA  LEU A 230      64.897  36.142  34.435  1.00 78.98           C  
ATOM   1936  C   LEU A 230      65.633  36.814  33.277  1.00 78.92           C  
ATOM   1937  O   LEU A 230      66.017  37.983  33.376  1.00 78.80           O  
ATOM   1938  CB  LEU A 230      65.611  34.837  34.849  1.00 79.02           C  
ATOM   1939  CG  LEU A 230      67.125  35.018  35.126  1.00 78.60           C  
ATOM   1940  CD1 LEU A 230      67.395  35.373  36.579  1.00 78.53           C  
ATOM   1941  CD2 LEU A 230      67.977  33.829  34.714  1.00 77.98           C  
ATOM   1942  N   LYS A 231      65.750  36.083  32.169  1.00 78.67           N  
ATOM   1943  CA  LYS A 231      66.633  36.449  31.073  1.00 78.77           C  
ATOM   1944  C   LYS A 231      66.228  37.685  30.259  1.00 78.81           C  
ATOM   1945  O   LYS A 231      67.017  38.634  30.159  1.00 78.88           O  
ATOM   1946  CB  LYS A 231      66.879  35.241  30.176  1.00 78.72           C  
ATOM   1947  CG  LYS A 231      67.621  34.141  30.899  1.00 78.99           C  
ATOM   1948  CD  LYS A 231      67.953  32.988  29.986  1.00 80.17           C  
ATOM   1949  CE  LYS A 231      68.860  31.997  30.698  1.00 80.78           C  
ATOM   1950  NZ  LYS A 231      68.427  30.590  30.441  1.00 81.81           N  
ATOM   1951  N   ASN A 232      65.016  37.681  29.698  1.00 78.87           N  
ATOM   1952  CA  ASN A 232      64.571  38.781  28.832  1.00 78.96           C  
ATOM   1953  C   ASN A 232      64.310  40.091  29.549  1.00 79.22           C  
ATOM   1954  O   ASN A 232      63.302  40.293  30.234  1.00 78.74           O  
ATOM   1955  CB  ASN A 232      63.438  38.379  27.904  1.00 78.81           C  
ATOM   1956  CG  ASN A 232      63.912  37.498  26.770  1.00 79.01           C  
ATOM   1957  OD1 ASN A 232      64.835  37.854  26.023  1.00 77.41           O  
ATOM   1958  ND2 ASN A 232      63.293  36.324  26.643  1.00 79.81           N  
ATOM   1959  N   ARG A 233      65.264  40.982  29.296  1.00 80.03           N  
ATOM   1960  CA  ARG A 233      65.622  42.119  30.129  1.00 80.48           C  
ATOM   1961  C   ARG A 233      64.508  43.116  30.446  1.00 80.93           C  
ATOM   1962  O   ARG A 233      64.388  43.575  31.590  1.00 80.98           O  
ATOM   1963  CB  ARG A 233      66.833  42.815  29.501  1.00 80.45           C  
ATOM   1964  CG  ARG A 233      68.168  42.136  29.806  1.00 80.04           C  
ATOM   1965  CD  ARG A 233      68.688  42.611  31.160  1.00 79.22           C  
ATOM   1966  NE  ARG A 233      70.095  43.002  31.131  1.00 77.95           N  
ATOM   1967  CZ  ARG A 233      70.578  44.105  31.705  1.00 78.14           C  
ATOM   1968  NH1 ARG A 233      69.764  44.944  32.338  1.00 77.78           N  
ATOM   1969  NH2 ARG A 233      71.876  44.385  31.631  1.00 78.06           N  
ATOM   1970  N   GLU A 234      63.700  43.448  29.443  1.00 81.42           N  
ATOM   1971  CA  GLU A 234      62.640  44.442  29.617  1.00 81.81           C  
ATOM   1972  C   GLU A 234      61.267  43.810  29.820  1.00 82.06           C  
ATOM   1973  O   GLU A 234      60.303  44.512  30.145  1.00 81.94           O  
ATOM   1974  CB  GLU A 234      62.638  45.445  28.454  1.00 81.76           C  
ATOM   1975  CG  GLU A 234      63.746  46.489  28.562  1.00 81.61           C  
ATOM   1976  CD  GLU A 234      64.108  47.126  27.234  1.00 81.64           C  
ATOM   1977  OE1 GLU A 234      63.209  47.319  26.387  1.00 81.88           O  
ATOM   1978  OE2 GLU A 234      65.302  47.441  27.040  1.00 81.21           O  
ATOM   1979  N   LEU A 235      61.193  42.487  29.665  1.00 82.43           N  
ATOM   1980  CA  LEU A 235      59.922  41.776  29.790  1.00 83.09           C  
ATOM   1981  C   LEU A 235      59.276  41.905  31.179  1.00 83.31           C  
ATOM   1982  O   LEU A 235      58.067  41.696  31.322  1.00 83.09           O  
ATOM   1983  CB  LEU A 235      60.053  40.295  29.417  1.00 83.16           C  
ATOM   1984  CG  LEU A 235      60.650  39.770  28.105  1.00 84.06           C  
ATOM   1985  CD1 LEU A 235      59.813  38.560  27.643  1.00 84.65           C  
ATOM   1986  CD2 LEU A 235      60.785  40.802  26.978  1.00 84.73           C  
ATOM   1987  N   ARG A 236      60.082  42.254  32.184  1.00 83.60           N  
ATOM   1988  CA  ARG A 236      59.611  42.418  33.564  1.00 83.82           C  
ATOM   1989  C   ARG A 236      58.767  43.687  33.724  1.00 84.23           C  
ATOM   1990  O   ARG A 236      57.848  43.738  34.548  1.00 84.29           O  
ATOM   1991  CB  ARG A 236      60.788  42.459  34.540  1.00 83.64           C  
ATOM   1992  CG  ARG A 236      61.898  41.446  34.280  1.00 83.60           C  
ATOM   1993  CD  ARG A 236      63.232  42.080  34.613  1.00 84.36           C  
ATOM   1994  NE  ARG A 236      64.161  41.171  35.276  1.00 84.77           N  
ATOM   1995  CZ  ARG A 236      65.035  41.550  36.209  1.00 85.21           C  
ATOM   1996  NH1 ARG A 236      65.095  42.816  36.603  1.00 84.64           N  
ATOM   1997  NH2 ARG A 236      65.846  40.658  36.761  1.00 86.50           N  
ATOM   1998  N   GLU A 237      59.093  44.716  32.946  1.00 84.66           N  
ATOM   1999  CA  GLU A 237      58.288  45.923  32.926  1.00 85.09           C  
ATOM   2000  C   GLU A 237      56.920  45.604  32.357  1.00 85.63           C  
ATOM   2001  O   GLU A 237      55.894  45.987  32.923  1.00 85.75           O  
ATOM   2002  CB  GLU A 237      58.938  46.966  32.051  1.00 85.00           C  
ATOM   2003  CG  GLU A 237      60.403  47.155  32.277  1.00 84.59           C  
ATOM   2004  CD  GLU A 237      60.824  48.512  31.805  1.00 83.91           C  
ATOM   2005  OE1 GLU A 237      60.154  49.484  32.203  1.00 83.83           O  
ATOM   2006  OE2 GLU A 237      61.792  48.611  31.024  1.00 83.25           O  
ATOM   2007  N   LYS A 238      56.930  44.895  31.230  1.00 86.30           N  
ATOM   2008  CA  LYS A 238      55.716  44.458  30.542  1.00 87.00           C  
ATOM   2009  C   LYS A 238      54.906  43.379  31.288  1.00 87.72           C  
ATOM   2010  O   LYS A 238      53.668  43.394  31.257  1.00 87.84           O  
ATOM   2011  CB  LYS A 238      56.055  43.997  29.116  1.00 86.70           C  
ATOM   2012  CG  LYS A 238      56.071  45.117  28.112  1.00 86.08           C  
ATOM   2013  CD  LYS A 238      54.653  45.594  27.840  1.00 85.33           C  
ATOM   2014  CE  LYS A 238      54.579  47.104  27.768  1.00 84.77           C  
ATOM   2015  NZ  LYS A 238      55.429  47.631  26.669  1.00 84.77           N  
ATOM   2016  N   ALA A 239      55.600  42.449  31.946  1.00 88.35           N  
ATOM   2017  CA  ALA A 239      54.949  41.390  32.719  1.00 88.83           C  
ATOM   2018  C   ALA A 239      54.333  41.906  34.015  1.00 89.40           C  
ATOM   2019  O   ALA A 239      54.917  42.752  34.700  1.00 89.47           O  
ATOM   2020  CB  ALA A 239      55.923  40.281  33.021  1.00 88.71           C  
ATOM   2021  N   PHE A 240      53.142  41.394  34.328  1.00 90.07           N  
ATOM   2022  CA  PHE A 240      52.458  41.648  35.593  1.00 90.79           C  
ATOM   2023  C   PHE A 240      52.367  40.286  36.334  1.00 91.38           C  
ATOM   2024  O   PHE A 240      52.288  39.231  35.689  1.00 91.33           O  
ATOM   2025  CB  PHE A 240      51.058  42.249  35.333  1.00 90.89           C  
ATOM   2026  CG  PHE A 240      51.054  43.647  34.671  1.00 91.17           C  
ATOM   2027  CD1 PHE A 240      52.168  44.157  33.984  1.00 92.02           C  
ATOM   2028  CD2 PHE A 240      49.895  44.430  34.704  1.00 90.78           C  
ATOM   2029  CE1 PHE A 240      52.144  45.443  33.370  1.00 91.39           C  
ATOM   2030  CE2 PHE A 240      49.861  45.705  34.095  1.00 91.01           C  
ATOM   2031  CZ  PHE A 240      50.991  46.209  33.431  1.00 91.04           C  
ATOM   2032  N   LEU A 241      52.400  40.301  37.673  1.00 92.05           N  
ATOM   2033  CA  LEU A 241      52.415  39.060  38.487  1.00 92.51           C  
ATOM   2034  C   LEU A 241      51.236  38.894  39.442  1.00 93.06           C  
ATOM   2035  O   LEU A 241      50.939  39.778  40.246  1.00 93.08           O  
ATOM   2036  CB  LEU A 241      53.691  38.948  39.315  1.00 92.31           C  
ATOM   2037  CG  LEU A 241      55.013  39.251  38.638  1.00 92.85           C  
ATOM   2038  CD1 LEU A 241      56.158  39.126  39.647  1.00 93.53           C  
ATOM   2039  CD2 LEU A 241      55.209  38.342  37.438  1.00 92.98           C  
ATOM   2040  N   VAL A 242      50.619  37.716  39.379  1.00 94.00           N  
ATOM   2041  CA  VAL A 242      49.404  37.379  40.129  1.00 94.75           C  
ATOM   2042  C   VAL A 242      49.719  36.515  41.360  1.00 95.33           C  
ATOM   2043  O   VAL A 242      50.697  35.770  41.360  1.00 95.50           O  
ATOM   2044  CB  VAL A 242      48.376  36.664  39.204  1.00 94.65           C  
ATOM   2045  CG1 VAL A 242      47.043  36.455  39.910  1.00 95.23           C  
ATOM   2046  CG2 VAL A 242      48.164  37.464  37.926  1.00 93.98           C  
ATOM   2047  N   VAL A 243      48.907  36.662  42.409  1.00 96.19           N  
ATOM   2048  CA  VAL A 243      49.001  35.868  43.638  1.00 97.00           C  
ATOM   2049  C   VAL A 243      47.627  35.273  43.891  1.00 97.66           C  
ATOM   2050  O   VAL A 243      46.632  35.986  44.045  1.00 97.83           O  
ATOM   2051  CB  VAL A 243      49.448  36.707  44.875  1.00 96.99           C  
ATOM   2052  CG1 VAL A 243      49.398  35.866  46.162  1.00 96.51           C  
ATOM   2053  CG2 VAL A 243      50.853  37.294  44.662  1.00 96.93           C  
ATOM   2054  N   LEU A 244      47.578  33.953  43.936  1.00 98.30           N  
ATOM   2055  CA  LEU A 244      46.312  33.266  43.991  1.00 98.91           C  
ATOM   2056  C   LEU A 244      45.794  33.083  45.421  1.00 99.40           C  
ATOM   2057  O   LEU A 244      46.306  33.692  46.361  1.00 99.45           O  
ATOM   2058  CB  LEU A 244      46.431  31.931  43.240  1.00 99.05           C  
ATOM   2059  CG  LEU A 244      46.817  32.034  41.755  1.00 98.68           C  
ATOM   2060  CD1 LEU A 244      47.416  30.737  41.248  1.00 97.96           C  
ATOM   2061  CD2 LEU A 244      45.633  32.460  40.879  1.00 98.56           C  
ATOM   2062  N   GLU A 245      44.758  32.254  45.557  1.00100.12           N  
ATOM   2063  CA  GLU A 245      44.174  31.875  46.838  1.00100.68           C  
ATOM   2064  C   GLU A 245      45.187  31.264  47.804  1.00100.42           C  
ATOM   2065  O   GLU A 245      45.309  31.717  48.946  1.00100.59           O  
ATOM   2066  CB  GLU A 245      43.045  30.881  46.615  1.00101.04           C  
ATOM   2067  CG  GLU A 245      42.625  30.182  47.896  1.00104.04           C  
ATOM   2068  CD  GLU A 245      42.095  28.781  47.663  1.00107.86           C  
ATOM   2069  OE1 GLU A 245      41.635  28.485  46.529  1.00109.94           O  
ATOM   2070  OE2 GLU A 245      42.129  27.977  48.624  1.00109.08           O  
ATOM   2071  N   LYS A 246      45.888  30.223  47.351  1.00100.06           N  
ATOM   2072  CA  LYS A 246      46.938  29.586  48.156  1.00 99.61           C  
ATOM   2073  C   LYS A 246      48.307  30.207  47.861  1.00 99.22           C  
ATOM   2074  O   LYS A 246      49.268  29.492  47.530  1.00 99.34           O  
ATOM   2075  CB  LYS A 246      46.951  28.064  47.945  1.00 99.72           C  
ATOM   2076  CG  LYS A 246      45.742  27.350  48.544  1.00 99.71           C  
ATOM   2077  CD  LYS A 246      45.511  26.004  47.885  1.00100.60           C  
ATOM   2078  CE  LYS A 246      44.026  25.618  47.924  1.00101.30           C  
ATOM   2079  NZ  LYS A 246      43.699  24.365  47.177  1.00101.07           N  
ATOM   2080  N   GLY A 247      48.369  31.546  47.975  1.00 98.52           N  
ATOM   2081  CA  GLY A 247      49.597  32.348  47.822  1.00 97.07           C  
ATOM   2082  C   GLY A 247      50.676  31.622  47.046  1.00 96.10           C  
ATOM   2083  O   GLY A 247      51.759  31.349  47.568  1.00 95.86           O  
ATOM   2084  N   TYR A 248      50.357  31.289  45.800  1.00 95.14           N  
ATOM   2085  CA  TYR A 248      51.269  30.544  44.957  1.00 94.15           C  
ATOM   2086  C   TYR A 248      52.132  31.418  44.039  1.00 92.88           C  
ATOM   2087  O   TYR A 248      53.249  31.030  43.707  1.00 92.69           O  
ATOM   2088  CB  TYR A 248      50.520  29.479  44.164  1.00 94.86           C  
ATOM   2089  CG  TYR A 248      50.612  28.076  44.742  1.00 95.94           C  
ATOM   2090  CD1 TYR A 248      49.456  27.298  44.919  1.00 96.79           C  
ATOM   2091  CD2 TYR A 248      51.856  27.516  45.100  1.00 96.78           C  
ATOM   2092  CE1 TYR A 248      49.524  25.993  45.439  1.00 97.57           C  
ATOM   2093  CE2 TYR A 248      51.943  26.210  45.625  1.00 97.74           C  
ATOM   2094  CZ  TYR A 248      50.768  25.450  45.792  1.00 97.81           C  
ATOM   2095  OH  TYR A 248      50.831  24.160  46.304  1.00 97.23           O  
ATOM   2096  N   THR A 249      51.621  32.583  43.646  1.00 91.20           N  
ATOM   2097  CA  THR A 249      52.387  33.579  42.867  1.00 89.93           C  
ATOM   2098  C   THR A 249      52.982  33.107  41.525  1.00 88.90           C  
ATOM   2099  O   THR A 249      53.976  32.385  41.483  1.00 88.77           O  
ATOM   2100  CB  THR A 249      53.495  34.252  43.706  1.00 89.91           C  
ATOM   2101  OG1 THR A 249      53.046  34.387  45.061  1.00 90.14           O  
ATOM   2102  CG2 THR A 249      53.847  35.616  43.116  1.00 89.00           C  
ATOM   2103  N   TYR A 250      52.384  33.568  40.434  1.00 87.57           N  
ATOM   2104  CA  TYR A 250      52.783  33.160  39.099  1.00 86.53           C  
ATOM   2105  C   TYR A 250      52.886  34.376  38.163  1.00 86.38           C  
ATOM   2106  O   TYR A 250      52.324  35.423  38.488  1.00 86.44           O  
ATOM   2107  CB  TYR A 250      51.759  32.163  38.575  1.00 85.78           C  
ATOM   2108  CG  TYR A 250      51.799  30.821  39.277  1.00 84.97           C  
ATOM   2109  CD1 TYR A 250      50.813  30.452  40.195  1.00 83.60           C  
ATOM   2110  CD2 TYR A 250      52.821  29.915  39.010  1.00 84.13           C  
ATOM   2111  CE1 TYR A 250      50.849  29.204  40.827  1.00 82.71           C  
ATOM   2112  CE2 TYR A 250      52.871  28.684  39.636  1.00 83.99           C  
ATOM   2113  CZ  TYR A 250      51.887  28.323  40.545  1.00 83.64           C  
ATOM   2114  OH  TYR A 250      51.982  27.078  41.153  1.00 83.35           O  
ATOM   2115  N   PRO A 251      53.631  34.262  37.026  1.00 86.01           N  
ATOM   2116  CA  PRO A 251      53.548  35.243  35.929  1.00 85.83           C  
ATOM   2117  C   PRO A 251      52.114  35.467  35.461  1.00 85.93           C  
ATOM   2118  O   PRO A 251      51.177  34.959  36.068  1.00 86.12           O  
ATOM   2119  CB  PRO A 251      54.350  34.584  34.803  1.00 85.48           C  
ATOM   2120  CG  PRO A 251      55.329  33.759  35.486  1.00 85.54           C  
ATOM   2121  CD  PRO A 251      54.643  33.231  36.731  1.00 85.95           C  
ATOM   2122  N   ALA A 252      51.932  36.225  34.389  1.00 86.15           N  
ATOM   2123  CA  ALA A 252      50.585  36.436  33.873  1.00 86.01           C  
ATOM   2124  C   ALA A 252      50.345  35.575  32.642  1.00 85.77           C  
ATOM   2125  O   ALA A 252      49.273  34.975  32.505  1.00 85.74           O  
ATOM   2126  CB  ALA A 252      50.345  37.897  33.578  1.00 86.19           C  
ATOM   2127  N   THR A 253      51.362  35.494  31.782  1.00 85.24           N  
ATOM   2128  CA  THR A 253      51.291  34.737  30.536  1.00 85.13           C  
ATOM   2129  C   THR A 253      50.941  33.252  30.754  1.00 85.20           C  
ATOM   2130  O   THR A 253      50.558  32.545  29.814  1.00 85.19           O  
ATOM   2131  CB  THR A 253      52.610  34.848  29.745  1.00 85.08           C  
ATOM   2132  OG1 THR A 253      53.310  36.036  30.128  1.00 85.15           O  
ATOM   2133  CG2 THR A 253      52.333  34.895  28.248  1.00 85.21           C  
ATOM   2134  N   ILE A 254      51.070  32.807  32.002  1.00 85.19           N  
ATOM   2135  CA  ILE A 254      50.835  31.423  32.418  1.00 85.23           C  
ATOM   2136  C   ILE A 254      49.389  31.198  32.835  1.00 85.49           C  
ATOM   2137  O   ILE A 254      48.926  30.050  32.974  1.00 85.26           O  
ATOM   2138  CB  ILE A 254      51.749  31.084  33.604  1.00 85.16           C  
ATOM   2139  CG1 ILE A 254      52.887  30.191  33.144  1.00 86.06           C  
ATOM   2140  CG2 ILE A 254      51.007  30.414  34.730  1.00 84.57           C  
ATOM   2141  CD1 ILE A 254      53.730  29.685  34.290  1.00 87.62           C  
ATOM   2142  N   LEU A 255      48.675  32.307  33.026  1.00 85.64           N  
ATOM   2143  CA  LEU A 255      47.376  32.264  33.688  1.00 85.45           C  
ATOM   2144  C   LEU A 255      46.184  32.564  32.772  1.00 85.57           C  
ATOM   2145  O   LEU A 255      46.197  33.531  32.006  1.00 85.61           O  
ATOM   2146  CB  LEU A 255      47.396  33.154  34.932  1.00 85.04           C  
ATOM   2147  CG  LEU A 255      48.386  32.757  36.038  1.00 83.95           C  
ATOM   2148  CD1 LEU A 255      48.344  33.773  37.145  1.00 83.48           C  
ATOM   2149  CD2 LEU A 255      48.122  31.376  36.608  1.00 82.38           C  
ATOM   2150  N   LYS A 256      45.182  31.688  32.861  1.00 85.74           N  
ATOM   2151  CA  LYS A 256      43.967  31.733  32.063  1.00 86.27           C  
ATOM   2152  C   LYS A 256      42.758  31.628  33.002  1.00 86.95           C  
ATOM   2153  O   LYS A 256      42.848  31.001  34.044  1.00 86.70           O  
ATOM   2154  CB  LYS A 256      43.943  30.568  31.071  1.00 85.96           C  
ATOM   2155  CG  LYS A 256      44.872  30.690  29.872  1.00 85.91           C  
ATOM   2156  CD  LYS A 256      44.585  29.565  28.869  1.00 86.51           C  
ATOM   2157  CE  LYS A 256      45.710  29.394  27.854  1.00 87.20           C  
ATOM   2158  NZ  LYS A 256      45.829  27.979  27.378  1.00 87.08           N  
ATOM   2159  N   PRO A 257      41.617  32.245  32.641  1.00 87.98           N  
ATOM   2160  CA  PRO A 257      40.450  32.195  33.536  1.00 88.64           C  
ATOM   2161  C   PRO A 257      39.574  30.954  33.389  1.00 89.43           C  
ATOM   2162  O   PRO A 257      39.500  30.360  32.304  1.00 89.24           O  
ATOM   2163  CB  PRO A 257      39.635  33.425  33.131  1.00 88.65           C  
ATOM   2164  CG  PRO A 257      40.165  33.852  31.769  1.00 88.70           C  
ATOM   2165  CD  PRO A 257      41.358  33.027  31.415  1.00 88.01           C  
ATOM   2166  N   VAL A 258      38.906  30.571  34.473  1.00 90.25           N  
ATOM   2167  CA  VAL A 258      37.901  29.530  34.364  1.00 91.25           C  
ATOM   2168  C   VAL A 258      36.517  30.064  34.685  1.00 92.31           C  
ATOM   2169  O   VAL A 258      36.180  30.408  35.826  1.00 92.17           O  
ATOM   2170  CB  VAL A 258      38.239  28.271  35.176  1.00 91.18           C  
ATOM   2171  CG1 VAL A 258      37.207  27.166  34.907  1.00 90.70           C  
ATOM   2172  CG2 VAL A 258      39.628  27.796  34.820  1.00 91.20           C  
ATOM   2173  N   LEU A 259      35.727  30.118  33.629  1.00 93.90           N  
ATOM   2174  CA  LEU A 259      34.418  30.708  33.646  1.00 95.74           C  
ATOM   2175  C   LEU A 259      33.389  29.620  33.896  1.00 97.41           C  
ATOM   2176  O   LEU A 259      33.536  28.495  33.408  1.00 97.13           O  
ATOM   2177  CB  LEU A 259      34.149  31.352  32.285  1.00 95.48           C  
ATOM   2178  CG  LEU A 259      35.330  31.642  31.352  1.00 94.38           C  
ATOM   2179  CD1 LEU A 259      34.876  31.554  29.914  1.00 92.46           C  
ATOM   2180  CD2 LEU A 259      35.990  32.986  31.643  1.00 93.81           C  
ATOM   2181  N   THR A 260      32.353  29.960  34.662  1.00 99.89           N  
ATOM   2182  CA  THR A 260      31.207  29.075  34.816  1.00102.29           C  
ATOM   2183  C   THR A 260      30.178  29.378  33.752  1.00104.26           C  
ATOM   2184  O   THR A 260      29.956  30.542  33.394  1.00104.81           O  
ATOM   2185  CB  THR A 260      30.465  29.242  36.149  1.00102.00           C  
ATOM   2186  OG1 THR A 260      31.369  29.662  37.177  1.00102.05           O  
ATOM   2187  CG2 THR A 260      29.777  27.921  36.533  1.00102.23           C  
ATOM   2188  N   TYR A 261      29.571  28.305  33.255  1.00106.47           N  
ATOM   2189  CA  TYR A 261      28.279  28.316  32.590  1.00108.38           C  
ATOM   2190  C   TYR A 261      27.579  29.661  32.723  1.00109.19           C  
ATOM   2191  O   TYR A 261      27.601  30.470  31.806  1.00109.02           O  
ATOM   2192  CB  TYR A 261      27.420  27.258  33.265  1.00109.17           C  
ATOM   2193  CG  TYR A 261      26.592  26.440  32.331  1.00110.18           C  
ATOM   2194  CD1 TYR A 261      26.766  25.065  32.275  1.00110.82           C  
ATOM   2195  CD2 TYR A 261      25.627  27.028  31.508  1.00111.46           C  
ATOM   2196  CE1 TYR A 261      26.013  24.282  31.425  1.00111.82           C  
ATOM   2197  CE2 TYR A 261      24.857  26.252  30.642  1.00112.67           C  
ATOM   2198  CZ  TYR A 261      25.058  24.870  30.616  1.00112.04           C  
ATOM   2199  OH  TYR A 261      24.321  24.056  29.790  1.00111.66           O  
ATOM   2200  N   GLU A 262      26.973  29.887  33.887  1.00110.51           N  
ATOM   2201  CA  GLU A 262      26.317  31.152  34.209  1.00111.80           C  
ATOM   2202  C   GLU A 262      26.974  32.351  33.515  1.00112.30           C  
ATOM   2203  O   GLU A 262      26.390  32.926  32.601  1.00112.24           O  
ATOM   2204  CB  GLU A 262      26.277  31.345  35.727  1.00111.88           C  
ATOM   2205  CG  GLU A 262      25.513  30.246  36.448  1.00113.17           C  
ATOM   2206  CD  GLU A 262      26.341  29.569  37.534  1.00115.52           C  
ATOM   2207  OE1 GLU A 262      26.799  30.276  38.473  1.00115.29           O  
ATOM   2208  OE2 GLU A 262      26.529  28.325  37.441  1.00116.24           O  
ATOM   2209  N   ASN A 263      28.199  32.686  33.909  1.00113.20           N  
ATOM   2210  CA  ASN A 263      28.854  33.918  33.446  1.00114.11           C  
ATOM   2211  C   ASN A 263      29.379  33.881  32.006  1.00114.62           C  
ATOM   2212  O   ASN A 263      30.427  34.455  31.701  1.00114.59           O  
ATOM   2213  CB  ASN A 263      29.977  34.319  34.405  1.00114.22           C  
ATOM   2214  CG  ASN A 263      29.571  34.208  35.865  1.00114.76           C  
ATOM   2215  OD1 ASN A 263      28.855  33.280  36.263  1.00114.59           O  
ATOM   2216  ND2 ASN A 263      30.046  35.147  36.678  1.00114.81           N  
ATOM   2217  N   LEU A 264      28.650  33.194  31.131  1.00115.47           N  
ATOM   2218  CA  LEU A 264      28.869  33.275  29.684  1.00116.30           C  
ATOM   2219  C   LEU A 264      27.662  33.999  29.087  1.00116.94           C  
ATOM   2220  O   LEU A 264      26.763  34.407  29.821  1.00116.94           O  
ATOM   2221  CB  LEU A 264      29.001  31.876  29.048  1.00116.30           C  
ATOM   2222  CG  LEU A 264      29.914  30.776  29.612  1.00116.24           C  
ATOM   2223  CD1 LEU A 264      29.548  29.410  29.035  1.00115.74           C  
ATOM   2224  CD2 LEU A 264      31.378  31.084  29.376  1.00116.09           C  
ATOM   2225  N   GLU A 265      27.635  34.151  27.764  1.00117.90           N  
ATOM   2226  CA  GLU A 265      26.496  34.762  27.072  1.00118.93           C  
ATOM   2227  C   GLU A 265      25.308  33.805  26.883  1.00119.32           C  
ATOM   2228  O   GLU A 265      25.403  32.607  27.174  1.00119.42           O  
ATOM   2229  CB  GLU A 265      26.931  35.339  25.719  1.00119.15           C  
ATOM   2230  CG  GLU A 265      27.459  36.769  25.777  1.00119.78           C  
ATOM   2231  CD  GLU A 265      28.596  36.986  24.805  1.00120.96           C  
ATOM   2232  OE1 GLU A 265      28.409  36.725  23.591  1.00120.84           O  
ATOM   2233  OE2 GLU A 265      29.685  37.403  25.265  1.00121.24           O  
ATOM   2234  N   ASP A 266      24.188  34.357  26.413  1.00119.92           N  
ATOM   2235  CA  ASP A 266      22.998  33.574  26.055  1.00120.32           C  
ATOM   2236  C   ASP A 266      23.340  32.562  24.952  1.00120.51           C  
ATOM   2237  O   ASP A 266      23.153  31.343  25.127  1.00120.66           O  
ATOM   2238  CB  ASP A 266      21.852  34.503  25.585  1.00120.35           C  
ATOM   2239  CG  ASP A 266      21.058  35.111  26.738  1.00119.95           C  
ATOM   2240  OD1 ASP A 266      21.661  35.742  27.631  1.00119.73           O  
ATOM   2241  OD2 ASP A 266      19.816  34.973  26.736  1.00119.17           O  
ATOM   2242  N   GLU A 267      23.854  33.088  23.831  1.00120.50           N  
ATOM   2243  CA  GLU A 267      24.209  32.302  22.635  1.00120.35           C  
ATOM   2244  C   GLU A 267      25.355  31.316  22.883  1.00119.96           C  
ATOM   2245  O   GLU A 267      25.287  30.153  22.449  1.00120.10           O  
ATOM   2246  CB  GLU A 267      24.534  33.218  21.436  1.00120.35           C  
ATOM   2247  CG  GLU A 267      25.426  34.439  21.756  1.00120.75           C  
ATOM   2248  CD  GLU A 267      26.030  35.089  20.508  1.00120.63           C  
ATOM   2249  OE1 GLU A 267      26.779  34.403  19.766  1.00120.35           O  
ATOM   2250  OE2 GLU A 267      25.760  36.292  20.279  1.00120.20           O  
ATOM   2251  N   GLU A 268      26.391  31.787  23.584  1.00119.23           N  
ATOM   2252  CA  GLU A 268      27.518  30.951  23.975  1.00118.44           C  
ATOM   2253  C   GLU A 268      27.017  29.730  24.749  1.00117.83           C  
ATOM   2254  O   GLU A 268      27.211  28.585  24.314  1.00117.94           O  
ATOM   2255  CB  GLU A 268      28.517  31.750  24.818  1.00118.43           C  
ATOM   2256  CG  GLU A 268      29.421  32.691  24.025  1.00118.44           C  
ATOM   2257  CD  GLU A 268      30.496  33.334  24.894  1.00118.39           C  
ATOM   2258  OE1 GLU A 268      30.607  32.960  26.079  1.00117.76           O  
ATOM   2259  OE2 GLU A 268      31.236  34.215  24.397  1.00118.70           O  
ATOM   2260  N   ARG A 269      26.332  29.995  25.861  1.00116.74           N  
ATOM   2261  CA  ARG A 269      25.896  28.960  26.789  1.00115.89           C  
ATOM   2262  C   ARG A 269      25.097  27.829  26.185  1.00115.47           C  
ATOM   2263  O   ARG A 269      25.303  26.676  26.518  1.00115.40           O  
ATOM   2264  CB  ARG A 269      25.096  29.570  27.917  1.00115.81           C  
ATOM   2265  CG  ARG A 269      25.928  29.855  29.108  1.00115.23           C  
ATOM   2266  CD  ARG A 269      25.048  30.252  30.239  1.00114.80           C  
ATOM   2267  NE  ARG A 269      24.567  31.608  30.051  1.00113.34           N  
ATOM   2268  CZ  ARG A 269      23.679  32.195  30.836  1.00112.36           C  
ATOM   2269  NH1 ARG A 269      23.162  31.544  31.871  1.00111.59           N  
ATOM   2270  NH2 ARG A 269      23.313  33.439  30.577  1.00112.31           N  
ATOM   2271  N   ASN A 270      24.170  28.153  25.309  1.00115.15           N  
ATOM   2272  CA  ASN A 270      23.364  27.108  24.713  1.00114.85           C  
ATOM   2273  C   ASN A 270      24.173  26.185  23.770  1.00114.57           C  
ATOM   2274  O   ASN A 270      23.890  24.991  23.708  1.00114.55           O  
ATOM   2275  CB  ASN A 270      22.125  27.709  24.030  1.00114.86           C  
ATOM   2276  CG  ASN A 270      20.912  26.799  24.118  1.00113.99           C  
ATOM   2277  OD1 ASN A 270      20.426  26.313  23.097  1.00111.92           O  
ATOM   2278  ND2 ASN A 270      20.421  26.558  25.342  1.00112.69           N  
ATOM   2279  N   GLU A 271      25.169  26.739  23.062  1.00113.99           N  
ATOM   2280  CA  GLU A 271      26.088  25.969  22.201  1.00113.49           C  
ATOM   2281  C   GLU A 271      27.036  25.129  23.049  1.00113.00           C  
ATOM   2282  O   GLU A 271      27.177  23.923  22.864  1.00112.99           O  
ATOM   2283  CB  GLU A 271      26.928  26.906  21.326  1.00113.59           C  
ATOM   2284  CG  GLU A 271      26.429  27.136  19.890  1.00113.98           C  
ATOM   2285  CD  GLU A 271      27.140  28.317  19.196  1.00113.96           C  
ATOM   2286  OE1 GLU A 271      28.384  28.277  19.050  1.00114.17           O  
ATOM   2287  OE2 GLU A 271      26.455  29.287  18.795  1.00113.65           O  
ATOM   2288  N   VAL A 272      27.702  25.802  23.975  1.00112.36           N  
ATOM   2289  CA  VAL A 272      28.575  25.174  24.945  1.00111.77           C  
ATOM   2290  C   VAL A 272      27.861  24.043  25.694  1.00111.48           C  
ATOM   2291  O   VAL A 272      28.424  22.968  25.888  1.00111.27           O  
ATOM   2292  CB  VAL A 272      29.045  26.249  25.938  1.00111.64           C  
ATOM   2293  CG1 VAL A 272      29.645  25.639  27.158  1.00112.10           C  
ATOM   2294  CG2 VAL A 272      30.029  27.193  25.271  1.00111.72           C  
ATOM   2295  N   ALA A 273      26.609  24.307  26.070  1.00111.36           N  
ATOM   2296  CA  ALA A 273      25.788  23.467  26.959  1.00111.19           C  
ATOM   2297  C   ALA A 273      25.628  22.029  26.525  1.00111.08           C  
ATOM   2298  O   ALA A 273      25.579  21.125  27.351  1.00110.95           O  
ATOM   2299  CB  ALA A 273      24.414  24.085  27.115  1.00111.31           C  
ATOM   2300  N   ASP A 274      25.515  21.831  25.222  1.00111.14           N  
ATOM   2301  CA  ASP A 274      25.385  20.504  24.655  1.00111.45           C  
ATOM   2302  C   ASP A 274      26.533  19.632  25.154  1.00111.37           C  
ATOM   2303  O   ASP A 274      26.366  18.433  25.430  1.00111.35           O  
ATOM   2304  CB  ASP A 274      25.406  20.596  23.127  1.00111.57           C  
ATOM   2305  CG  ASP A 274      24.517  21.731  22.591  1.00112.76           C  
ATOM   2306  OD1 ASP A 274      23.268  21.645  22.705  1.00113.64           O  
ATOM   2307  OD2 ASP A 274      25.067  22.716  22.044  1.00113.17           O  
ATOM   2308  N   ILE A 275      27.689  20.266  25.315  1.00111.01           N  
ATOM   2309  CA  ILE A 275      28.915  19.544  25.563  1.00110.79           C  
ATOM   2310  C   ILE A 275      29.287  19.425  27.058  1.00110.44           C  
ATOM   2311  O   ILE A 275      29.598  18.325  27.519  1.00110.66           O  
ATOM   2312  CB  ILE A 275      30.058  20.092  24.687  1.00110.82           C  
ATOM   2313  CG1 ILE A 275      29.475  20.850  23.484  1.00111.14           C  
ATOM   2314  CG2 ILE A 275      30.945  18.943  24.222  1.00111.16           C  
ATOM   2315  CD1 ILE A 275      30.484  21.614  22.623  1.00110.91           C  
ATOM   2316  N   VAL A 276      29.234  20.529  27.808  1.00109.89           N  
ATOM   2317  CA  VAL A 276      29.550  20.507  29.253  1.00109.40           C  
ATOM   2318  C   VAL A 276      28.650  19.520  30.003  1.00109.19           C  
ATOM   2319  O   VAL A 276      29.150  18.631  30.690  1.00109.08           O  
ATOM   2320  CB  VAL A 276      29.498  21.934  29.930  1.00109.51           C  
ATOM   2321  CG1 VAL A 276      29.726  21.859  31.460  1.00108.85           C  
ATOM   2322  CG2 VAL A 276      30.513  22.855  29.315  1.00109.19           C  
ATOM   2323  N   ARG A 277      27.333  19.693  29.877  1.00108.91           N  
ATOM   2324  CA  ARG A 277      26.350  18.747  30.428  1.00108.79           C  
ATOM   2325  C   ARG A 277      26.012  17.760  29.307  1.00108.05           C  
ATOM   2326  O   ARG A 277      25.770  18.168  28.159  1.00108.53           O  
ATOM   2327  CB  ARG A 277      25.086  19.466  30.954  1.00108.87           C  
ATOM   2328  CG  ARG A 277      25.368  20.719  31.820  1.00109.85           C  
ATOM   2329  CD  ARG A 277      24.180  21.185  32.658  1.00109.75           C  
ATOM   2330  NE  ARG A 277      24.194  22.642  32.823  1.00112.53           N  
ATOM   2331  CZ  ARG A 277      23.373  23.360  33.602  1.00113.70           C  
ATOM   2332  NH1 ARG A 277      22.430  22.777  34.353  1.00112.55           N  
ATOM   2333  NH2 ARG A 277      23.507  24.687  33.631  1.00113.18           N  
ATOM   2334  N   MET A 278      26.025  16.469  29.626  1.00106.59           N  
ATOM   2335  CA  MET A 278      25.940  15.438  28.601  1.00105.43           C  
ATOM   2336  C   MET A 278      25.236  14.192  29.118  1.00103.87           C  
ATOM   2337  O   MET A 278      25.444  13.795  30.266  1.00103.62           O  
ATOM   2338  CB  MET A 278      27.351  15.099  28.109  1.00105.61           C  
ATOM   2339  CG  MET A 278      27.504  13.700  27.463  1.00106.43           C  
ATOM   2340  SD  MET A 278      29.202  13.040  27.317  1.00106.71           S  
ATOM   2341  CE  MET A 278      30.046  13.784  28.737  1.00104.84           C  
ATOM   2342  N   GLU A 279      24.410  13.580  28.268  1.00102.10           N  
ATOM   2343  CA  GLU A 279      23.748  12.309  28.603  1.00100.87           C  
ATOM   2344  C   GLU A 279      24.614  11.429  29.532  1.00 98.86           C  
ATOM   2345  O   GLU A 279      25.753  11.081  29.194  1.00 98.96           O  
ATOM   2346  CB  GLU A 279      23.372  11.519  27.332  1.00100.81           C  
ATOM   2347  CG  GLU A 279      22.604  12.313  26.261  1.00102.09           C  
ATOM   2348  CD  GLU A 279      22.143  11.446  25.072  1.00102.41           C  
ATOM   2349  OE1 GLU A 279      22.163  10.191  25.176  1.00104.46           O  
ATOM   2350  OE2 GLU A 279      21.751  12.023  24.029  1.00103.12           O  
ATOM   2351  N   PRO A 280      24.105  11.112  30.734  1.00 97.02           N  
ATOM   2352  CA  PRO A 280      24.779  10.131  31.620  1.00 95.65           C  
ATOM   2353  C   PRO A 280      25.435   8.900  30.948  1.00 93.86           C  
ATOM   2354  O   PRO A 280      26.579   8.590  31.274  1.00 93.71           O  
ATOM   2355  CB  PRO A 280      23.674   9.735  32.597  1.00 95.69           C  
ATOM   2356  CG  PRO A 280      22.865  11.007  32.717  1.00 96.06           C  
ATOM   2357  CD  PRO A 280      22.932  11.718  31.388  1.00 96.41           C  
ATOM   2358  N   GLY A 281      24.739   8.237  30.018  1.00 92.02           N  
ATOM   2359  CA  GLY A 281      25.247   7.021  29.361  1.00 89.08           C  
ATOM   2360  C   GLY A 281      26.522   7.284  28.589  1.00 87.29           C  
ATOM   2361  O   GLY A 281      27.491   6.525  28.677  1.00 86.99           O  
ATOM   2362  N   LYS A 282      26.495   8.373  27.832  1.00 85.38           N  
ATOM   2363  CA  LYS A 282      27.642   8.904  27.112  1.00 83.85           C  
ATOM   2364  C   LYS A 282      28.853   9.138  28.001  1.00 81.93           C  
ATOM   2365  O   LYS A 282      29.978   8.737  27.679  1.00 81.69           O  
ATOM   2366  CB  LYS A 282      27.265  10.259  26.512  1.00 84.38           C  
ATOM   2367  CG  LYS A 282      26.760  10.256  25.091  1.00 86.10           C  
ATOM   2368  CD  LYS A 282      27.332  11.494  24.411  1.00 88.54           C  
ATOM   2369  CE  LYS A 282      26.471  11.951  23.260  1.00 89.75           C  
ATOM   2370  NZ  LYS A 282      26.955  13.277  22.814  1.00 88.86           N  
ATOM   2371  N   ARG A 283      28.604   9.835  29.102  1.00 79.92           N  
ATOM   2372  CA  ARG A 283      29.640  10.215  30.040  1.00 77.90           C  
ATOM   2373  C   ARG A 283      30.218   8.962  30.650  1.00 76.07           C  
ATOM   2374  O   ARG A 283      31.439   8.791  30.699  1.00 75.88           O  
ATOM   2375  CB  ARG A 283      29.053  11.122  31.114  1.00 78.28           C  
ATOM   2376  CG  ARG A 283      30.061  11.706  32.077  1.00 79.95           C  
ATOM   2377  CD  ARG A 283      29.366  12.546  33.142  1.00 85.71           C  
ATOM   2378  NE  ARG A 283      29.391  13.986  32.839  1.00 91.22           N  
ATOM   2379  CZ  ARG A 283      30.043  14.896  33.568  1.00 93.39           C  
ATOM   2380  NH1 ARG A 283      30.728  14.524  34.656  1.00 94.55           N  
ATOM   2381  NH2 ARG A 283      30.013  16.179  33.221  1.00 93.68           N  
ATOM   2382  N   LEU A 284      29.330   8.075  31.082  1.00 73.85           N  
ATOM   2383  CA  LEU A 284      29.732   6.802  31.635  1.00 72.37           C  
ATOM   2384  C   LEU A 284      30.435   5.931  30.593  1.00 72.39           C  
ATOM   2385  O   LEU A 284      31.292   5.141  30.930  1.00 72.59           O  
ATOM   2386  CB  LEU A 284      28.522   6.085  32.189  1.00 71.61           C  
ATOM   2387  CG  LEU A 284      28.699   4.760  32.912  1.00 68.78           C  
ATOM   2388  CD1 LEU A 284      29.236   4.940  34.289  1.00 65.20           C  
ATOM   2389  CD2 LEU A 284      27.348   4.143  32.958  1.00 65.88           C  
ATOM   2390  N   ASN A 285      30.077   6.066  29.326  1.00 72.03           N  
ATOM   2391  CA  ASN A 285      30.837   5.385  28.311  1.00 71.76           C  
ATOM   2392  C   ASN A 285      32.239   5.947  28.219  1.00 70.67           C  
ATOM   2393  O   ASN A 285      33.199   5.174  28.095  1.00 71.12           O  
ATOM   2394  CB  ASN A 285      30.141   5.429  26.959  1.00 72.56           C  
ATOM   2395  CG  ASN A 285      29.010   4.410  26.852  1.00 75.15           C  
ATOM   2396  OD1 ASN A 285      29.007   3.375  27.549  1.00 77.46           O  
ATOM   2397  ND2 ASN A 285      28.030   4.701  25.973  1.00 77.07           N  
ATOM   2398  N   LEU A 286      32.374   7.267  28.298  1.00 68.50           N  
ATOM   2399  CA  LEU A 286      33.705   7.849  28.370  1.00 67.04           C  
ATOM   2400  C   LEU A 286      34.471   7.414  29.618  1.00 65.98           C  
ATOM   2401  O   LEU A 286      35.613   6.974  29.537  1.00 65.39           O  
ATOM   2402  CB  LEU A 286      33.630   9.352  28.320  1.00 67.23           C  
ATOM   2403  CG  LEU A 286      33.360   9.852  26.914  1.00 68.46           C  
ATOM   2404  CD1 LEU A 286      32.752  11.256  26.999  1.00 69.51           C  
ATOM   2405  CD2 LEU A 286      34.629   9.793  26.019  1.00 66.35           C  
ATOM   2406  N   ILE A 287      33.841   7.536  30.778  1.00 64.82           N  
ATOM   2407  CA  ILE A 287      34.488   7.136  32.008  1.00 63.36           C  
ATOM   2408  C   ILE A 287      35.034   5.720  31.868  1.00 63.43           C  
ATOM   2409  O   ILE A 287      36.176   5.473  32.217  1.00 63.90           O  
ATOM   2410  CB  ILE A 287      33.556   7.318  33.209  1.00 63.31           C  
ATOM   2411  CG1 ILE A 287      33.410   8.813  33.509  1.00 60.25           C  
ATOM   2412  CG2 ILE A 287      34.050   6.525  34.451  1.00 62.54           C  
ATOM   2413  CD1 ILE A 287      32.479   9.091  34.653  1.00 57.25           C  
ATOM   2414  N   ARG A 288      34.248   4.804  31.313  1.00 63.46           N  
ATOM   2415  CA  ARG A 288      34.710   3.431  31.040  1.00 63.57           C  
ATOM   2416  C   ARG A 288      35.890   3.418  30.072  1.00 63.94           C  
ATOM   2417  O   ARG A 288      36.818   2.618  30.222  1.00 63.58           O  
ATOM   2418  CB  ARG A 288      33.586   2.579  30.439  1.00 63.61           C  
ATOM   2419  CG  ARG A 288      32.583   2.114  31.439  1.00 63.31           C  
ATOM   2420  CD  ARG A 288      31.282   1.809  30.811  1.00 64.52           C  
ATOM   2421  NE  ARG A 288      30.404   1.449  31.911  1.00 69.01           N  
ATOM   2422  CZ  ARG A 288      29.129   1.056  31.811  1.00 70.44           C  
ATOM   2423  NH1 ARG A 288      28.496   0.954  30.643  1.00 70.60           N  
ATOM   2424  NH2 ARG A 288      28.477   0.760  32.916  1.00 70.84           N  
ATOM   2425  N   TYR A 289      35.835   4.302  29.068  1.00 64.01           N  
ATOM   2426  CA  TYR A 289      36.898   4.395  28.103  1.00 63.98           C  
ATOM   2427  C   TYR A 289      38.179   4.748  28.833  1.00 63.72           C  
ATOM   2428  O   TYR A 289      39.163   4.007  28.753  1.00 63.65           O  
ATOM   2429  CB  TYR A 289      36.574   5.442  27.068  1.00 64.95           C  
ATOM   2430  CG  TYR A 289      37.447   5.362  25.856  1.00 66.90           C  
ATOM   2431  CD1 TYR A 289      37.248   4.357  24.915  1.00 69.49           C  
ATOM   2432  CD2 TYR A 289      38.471   6.281  25.637  1.00 68.69           C  
ATOM   2433  CE1 TYR A 289      38.041   4.247  23.793  1.00 69.84           C  
ATOM   2434  CE2 TYR A 289      39.278   6.203  24.476  1.00 69.43           C  
ATOM   2435  CZ  TYR A 289      39.050   5.169  23.568  1.00 69.30           C  
ATOM   2436  OH  TYR A 289      39.800   5.024  22.417  1.00 69.33           O  
ATOM   2437  N   ILE A 290      38.154   5.852  29.580  1.00 62.89           N  
ATOM   2438  CA  ILE A 290      39.331   6.285  30.285  1.00 62.41           C  
ATOM   2439  C   ILE A 290      39.824   5.136  31.143  1.00 63.17           C  
ATOM   2440  O   ILE A 290      40.988   4.741  31.025  1.00 63.49           O  
ATOM   2441  CB  ILE A 290      39.098   7.547  31.114  1.00 62.13           C  
ATOM   2442  CG1 ILE A 290      38.755   8.725  30.206  1.00 61.26           C  
ATOM   2443  CG2 ILE A 290      40.335   7.895  31.931  1.00 60.89           C  
ATOM   2444  CD1 ILE A 290      37.920   9.851  30.893  1.00 60.58           C  
ATOM   2445  N   LEU A 291      38.947   4.567  31.969  1.00 63.64           N  
ATOM   2446  CA  LEU A 291      39.326   3.414  32.793  1.00 64.84           C  
ATOM   2447  C   LEU A 291      40.114   2.294  32.046  1.00 66.03           C  
ATOM   2448  O   LEU A 291      41.130   1.792  32.542  1.00 65.99           O  
ATOM   2449  CB  LEU A 291      38.100   2.820  33.450  1.00 64.27           C  
ATOM   2450  CG  LEU A 291      38.302   1.494  34.178  1.00 64.52           C  
ATOM   2451  CD1 LEU A 291      39.238   1.601  35.396  1.00 62.39           C  
ATOM   2452  CD2 LEU A 291      36.914   0.997  34.608  1.00 66.86           C  
ATOM   2453  N   ARG A 292      39.649   1.907  30.862  1.00 67.19           N  
ATOM   2454  CA  ARG A 292      40.334   0.860  30.119  1.00 68.46           C  
ATOM   2455  C   ARG A 292      41.766   1.260  29.797  1.00 68.34           C  
ATOM   2456  O   ARG A 292      42.686   0.472  30.024  1.00 68.62           O  
ATOM   2457  CB  ARG A 292      39.542   0.405  28.884  1.00 68.60           C  
ATOM   2458  CG  ARG A 292      38.505  -0.678  29.218  1.00 69.06           C  
ATOM   2459  CD  ARG A 292      37.662  -1.071  28.009  1.00 70.29           C  
ATOM   2460  NE  ARG A 292      36.467  -0.240  27.829  1.00 75.21           N  
ATOM   2461  CZ  ARG A 292      36.238   0.552  26.773  1.00 78.12           C  
ATOM   2462  NH1 ARG A 292      37.118   0.642  25.760  1.00 77.51           N  
ATOM   2463  NH2 ARG A 292      35.111   1.271  26.729  1.00 79.19           N  
ATOM   2464  N   ARG A 293      41.959   2.495  29.337  1.00 68.44           N  
ATOM   2465  CA  ARG A 293      43.316   3.044  29.186  1.00 68.54           C  
ATOM   2466  C   ARG A 293      44.172   2.788  30.450  1.00 68.98           C  
ATOM   2467  O   ARG A 293      45.207   2.097  30.373  1.00 68.80           O  
ATOM   2468  CB  ARG A 293      43.288   4.532  28.831  1.00 67.87           C  
ATOM   2469  CG  ARG A 293      42.445   4.851  27.637  1.00 67.19           C  
ATOM   2470  CD  ARG A 293      43.231   5.668  26.627  1.00 66.85           C  
ATOM   2471  NE  ARG A 293      42.534   5.914  25.348  1.00 65.17           N  
ATOM   2472  CZ  ARG A 293      43.107   6.481  24.285  1.00 62.97           C  
ATOM   2473  NH1 ARG A 293      44.384   6.856  24.350  1.00 63.32           N  
ATOM   2474  NH2 ARG A 293      42.420   6.684  23.169  1.00 60.14           N  
ATOM   2475  N   TYR A 294      43.698   3.316  31.588  1.00 69.22           N  
ATOM   2476  CA  TYR A 294      44.267   3.088  32.946  1.00 69.72           C  
ATOM   2477  C   TYR A 294      44.633   1.627  33.304  1.00 69.76           C  
ATOM   2478  O   TYR A 294      45.772   1.358  33.751  1.00 69.53           O  
ATOM   2479  CB  TYR A 294      43.317   3.619  34.032  1.00 69.58           C  
ATOM   2480  CG  TYR A 294      43.253   5.114  34.140  1.00 70.55           C  
ATOM   2481  CD1 TYR A 294      43.707   5.947  33.104  1.00 72.23           C  
ATOM   2482  CD2 TYR A 294      42.716   5.710  35.267  1.00 70.81           C  
ATOM   2483  CE1 TYR A 294      43.637   7.338  33.211  1.00 71.63           C  
ATOM   2484  CE2 TYR A 294      42.635   7.094  35.386  1.00 70.80           C  
ATOM   2485  CZ  TYR A 294      43.095   7.900  34.361  1.00 71.51           C  
ATOM   2486  OH  TYR A 294      42.996   9.271  34.501  1.00 72.18           O  
ATOM   2487  N   VAL A 295      43.665   0.714  33.133  1.00 69.03           N  
ATOM   2488  CA  VAL A 295      43.863  -0.699  33.406  1.00 68.41           C  
ATOM   2489  C   VAL A 295      45.036  -1.237  32.594  1.00 68.01           C  
ATOM   2490  O   VAL A 295      45.890  -1.949  33.114  1.00 66.97           O  
ATOM   2491  CB  VAL A 295      42.598  -1.504  33.064  1.00 68.51           C  
ATOM   2492  CG1 VAL A 295      42.859  -3.005  33.215  1.00 68.93           C  
ATOM   2493  CG2 VAL A 295      41.458  -1.097  33.954  1.00 68.85           C  
ATOM   2494  N   LYS A 296      45.060  -0.869  31.315  1.00 68.20           N  
ATOM   2495  CA  LYS A 296      46.080  -1.309  30.380  1.00 68.75           C  
ATOM   2496  C   LYS A 296      47.468  -0.700  30.708  1.00 68.34           C  
ATOM   2497  O   LYS A 296      48.492  -1.368  30.569  1.00 68.22           O  
ATOM   2498  CB  LYS A 296      45.632  -0.965  28.960  1.00 69.27           C  
ATOM   2499  CG  LYS A 296      46.233  -1.866  27.888  1.00 72.30           C  
ATOM   2500  CD  LYS A 296      45.494  -1.738  26.551  1.00 76.68           C  
ATOM   2501  CE  LYS A 296      46.072  -0.609  25.692  1.00 79.33           C  
ATOM   2502  NZ  LYS A 296      45.641  -0.753  24.264  1.00 82.62           N  
ATOM   2503  N   ALA A 297      47.490   0.554  31.168  1.00 67.87           N  
ATOM   2504  CA  ALA A 297      48.729   1.228  31.628  1.00 67.13           C  
ATOM   2505  C   ALA A 297      49.273   0.767  32.997  1.00 66.92           C  
ATOM   2506  O   ALA A 297      50.438   1.023  33.317  1.00 66.45           O  
ATOM   2507  CB  ALA A 297      48.537   2.754  31.637  1.00 66.55           C  
ATOM   2508  N   LEU A 298      48.433   0.114  33.810  1.00 66.62           N  
ATOM   2509  CA  LEU A 298      48.803  -0.132  35.202  1.00 66.01           C  
ATOM   2510  C   LEU A 298      48.797  -1.583  35.691  1.00 66.11           C  
ATOM   2511  O   LEU A 298      49.460  -1.875  36.677  1.00 66.11           O  
ATOM   2512  CB  LEU A 298      48.051   0.819  36.172  1.00 65.64           C  
ATOM   2513  CG  LEU A 298      48.402   2.327  36.188  1.00 64.42           C  
ATOM   2514  CD1 LEU A 298      47.600   3.049  37.204  1.00 63.80           C  
ATOM   2515  CD2 LEU A 298      49.859   2.634  36.462  1.00 63.43           C  
ATOM   2516  N   ARG A 299      48.101  -2.506  35.027  1.00 66.66           N  
ATOM   2517  CA  ARG A 299      48.138  -3.910  35.503  1.00 67.44           C  
ATOM   2518  C   ARG A 299      49.581  -4.361  35.650  1.00 67.80           C  
ATOM   2519  O   ARG A 299      49.988  -4.820  36.726  1.00 68.20           O  
ATOM   2520  CB  ARG A 299      47.413  -4.896  34.585  1.00 67.16           C  
ATOM   2521  CG  ARG A 299      47.068  -4.327  33.244  1.00 69.03           C  
ATOM   2522  CD  ARG A 299      46.561  -5.401  32.328  1.00 72.80           C  
ATOM   2523  NE  ARG A 299      46.937  -5.056  30.956  1.00 76.57           N  
ATOM   2524  CZ  ARG A 299      46.211  -5.321  29.875  1.00 78.59           C  
ATOM   2525  NH1 ARG A 299      45.034  -5.937  29.980  1.00 79.42           N  
ATOM   2526  NH2 ARG A 299      46.660  -4.950  28.684  1.00 80.44           N  
ATOM   2527  N   ASP A 300      50.356  -4.198  34.579  1.00 67.86           N  
ATOM   2528  CA  ASP A 300      51.769  -4.582  34.583  1.00 68.51           C  
ATOM   2529  C   ASP A 300      52.599  -4.116  35.804  1.00 68.06           C  
ATOM   2530  O   ASP A 300      53.672  -4.643  36.054  1.00 68.43           O  
ATOM   2531  CB  ASP A 300      52.450  -4.163  33.266  1.00 69.29           C  
ATOM   2532  CG  ASP A 300      52.038  -5.053  32.066  1.00 70.96           C  
ATOM   2533  OD1 ASP A 300      51.541  -6.190  32.303  1.00 71.89           O  
ATOM   2534  OD2 ASP A 300      52.213  -4.606  30.890  1.00 71.25           O  
ATOM   2535  N   TYR A 301      52.103  -3.142  36.558  1.00 67.29           N  
ATOM   2536  CA  TYR A 301      52.805  -2.651  37.730  1.00 66.20           C  
ATOM   2537  C   TYR A 301      52.098  -3.132  38.993  1.00 65.67           C  
ATOM   2538  O   TYR A 301      52.462  -2.729  40.110  1.00 65.39           O  
ATOM   2539  CB  TYR A 301      52.880  -1.123  37.687  1.00 66.51           C  
ATOM   2540  CG  TYR A 301      53.622  -0.602  36.487  1.00 66.44           C  
ATOM   2541  CD1 TYR A 301      52.951  -0.146  35.354  1.00 66.30           C  
ATOM   2542  CD2 TYR A 301      55.008  -0.579  36.482  1.00 67.91           C  
ATOM   2543  CE1 TYR A 301      53.666   0.332  34.241  1.00 66.74           C  
ATOM   2544  CE2 TYR A 301      55.725  -0.107  35.385  1.00 68.00           C  
ATOM   2545  CZ  TYR A 301      55.056   0.342  34.275  1.00 67.09           C  
ATOM   2546  OH  TYR A 301      55.823   0.778  33.224  1.00 66.65           O  
ATOM   2547  N   GLY A 302      51.086  -3.983  38.804  1.00 64.81           N  
ATOM   2548  CA  GLY A 302      50.442  -4.710  39.902  1.00 64.69           C  
ATOM   2549  C   GLY A 302      49.130  -4.136  40.421  1.00 64.81           C  
ATOM   2550  O   GLY A 302      48.635  -4.548  41.483  1.00 65.13           O  
ATOM   2551  N   TRP A 303      48.586  -3.168  39.688  1.00 64.10           N  
ATOM   2552  CA  TRP A 303      47.335  -2.518  40.024  1.00 63.65           C  
ATOM   2553  C   TRP A 303      46.170  -3.330  39.450  1.00 64.08           C  
ATOM   2554  O   TRP A 303      46.236  -3.794  38.296  1.00 64.33           O  
ATOM   2555  CB  TRP A 303      47.328  -1.115  39.413  1.00 63.13           C  
ATOM   2556  CG  TRP A 303      48.112  -0.124  40.220  1.00 63.02           C  
ATOM   2557  CD1 TRP A 303      49.415   0.279  40.022  1.00 61.43           C  
ATOM   2558  CD2 TRP A 303      47.645   0.588  41.365  1.00 60.82           C  
ATOM   2559  NE1 TRP A 303      49.765   1.196  40.971  1.00 59.62           N  
ATOM   2560  CE2 TRP A 303      48.702   1.394  41.814  1.00 60.50           C  
ATOM   2561  CE3 TRP A 303      46.430   0.633  42.039  1.00 59.43           C  
ATOM   2562  CZ2 TRP A 303      48.583   2.215  42.929  1.00 62.07           C  
ATOM   2563  CZ3 TRP A 303      46.312   1.455  43.141  1.00 61.41           C  
ATOM   2564  CH2 TRP A 303      47.381   2.231  43.579  1.00 61.93           C  
ATOM   2565  N   TYR A 304      45.102  -3.481  40.238  1.00 63.81           N  
ATOM   2566  CA  TYR A 304      43.955  -4.316  39.860  1.00 63.43           C  
ATOM   2567  C   TYR A 304      42.707  -3.518  39.990  1.00 63.78           C  
ATOM   2568  O   TYR A 304      42.294  -3.232  41.091  1.00 64.45           O  
ATOM   2569  CB  TYR A 304      43.836  -5.518  40.798  1.00 62.41           C  
ATOM   2570  CG  TYR A 304      44.812  -6.610  40.496  1.00 60.30           C  
ATOM   2571  CD1 TYR A 304      46.069  -6.596  41.052  1.00 59.29           C  
ATOM   2572  CD2 TYR A 304      44.479  -7.649  39.646  1.00 58.38           C  
ATOM   2573  CE1 TYR A 304      46.979  -7.576  40.774  1.00 59.47           C  
ATOM   2574  CE2 TYR A 304      45.376  -8.645  39.375  1.00 58.92           C  
ATOM   2575  CZ  TYR A 304      46.631  -8.597  39.942  1.00 59.40           C  
ATOM   2576  OH  TYR A 304      47.552  -9.564  39.687  1.00 59.06           O  
ATOM   2577  N   ILE A 305      42.087  -3.159  38.884  1.00 64.42           N  
ATOM   2578  CA  ILE A 305      40.889  -2.326  38.960  1.00 64.93           C  
ATOM   2579  C   ILE A 305      39.684  -3.032  38.371  1.00 65.03           C  
ATOM   2580  O   ILE A 305      39.655  -3.333  37.175  1.00 65.54           O  
ATOM   2581  CB  ILE A 305      41.054  -1.022  38.190  1.00 64.83           C  
ATOM   2582  CG1 ILE A 305      42.262  -0.256  38.663  1.00 65.03           C  
ATOM   2583  CG2 ILE A 305      39.835  -0.150  38.378  1.00 66.20           C  
ATOM   2584  CD1 ILE A 305      42.876   0.535  37.527  1.00 68.19           C  
ATOM   2585  N   SER A 306      38.685  -3.279  39.203  1.00 65.08           N  
ATOM   2586  CA  SER A 306      37.446  -3.863  38.742  1.00 65.34           C  
ATOM   2587  C   SER A 306      36.972  -3.172  37.469  1.00 65.67           C  
ATOM   2588  O   SER A 306      36.978  -1.945  37.359  1.00 65.44           O  
ATOM   2589  CB  SER A 306      36.376  -3.733  39.818  1.00 65.60           C  
ATOM   2590  OG  SER A 306      35.255  -4.534  39.512  1.00 66.21           O  
ATOM   2591  N   PRO A 307      36.582  -3.960  36.471  1.00 66.18           N  
ATOM   2592  CA  PRO A 307      36.047  -3.292  35.309  1.00 66.62           C  
ATOM   2593  C   PRO A 307      34.656  -2.743  35.547  1.00 67.52           C  
ATOM   2594  O   PRO A 307      34.187  -1.944  34.732  1.00 68.72           O  
ATOM   2595  CB  PRO A 307      36.004  -4.396  34.268  1.00 66.16           C  
ATOM   2596  CG  PRO A 307      35.887  -5.620  35.033  1.00 65.50           C  
ATOM   2597  CD  PRO A 307      36.642  -5.417  36.297  1.00 65.78           C  
ATOM   2598  N   GLU A 308      34.013  -3.124  36.646  1.00 68.02           N  
ATOM   2599  CA  GLU A 308      32.605  -2.786  36.831  1.00 69.31           C  
ATOM   2600  C   GLU A 308      32.222  -1.819  37.908  1.00 68.60           C  
ATOM   2601  O   GLU A 308      32.682  -1.923  39.044  1.00 69.03           O  
ATOM   2602  CB  GLU A 308      31.798  -4.027  37.066  1.00 70.42           C  
ATOM   2603  CG  GLU A 308      30.949  -4.368  35.881  1.00 76.26           C  
ATOM   2604  CD  GLU A 308      30.652  -5.845  35.830  1.00 83.89           C  
ATOM   2605  OE1 GLU A 308      30.200  -6.423  36.879  1.00 85.16           O  
ATOM   2606  OE2 GLU A 308      30.899  -6.413  34.732  1.00 87.59           O  
ATOM   2607  N   GLU A 309      31.320  -0.914  37.534  1.00 67.75           N  
ATOM   2608  CA  GLU A 309      30.775   0.116  38.420  1.00 67.24           C  
ATOM   2609  C   GLU A 309      30.177  -0.445  39.699  1.00 66.15           C  
ATOM   2610  O   GLU A 309      29.732  -1.583  39.736  1.00 66.37           O  
ATOM   2611  CB  GLU A 309      29.704   0.921  37.679  1.00 67.33           C  
ATOM   2612  CG  GLU A 309      30.267   1.823  36.587  1.00 69.32           C  
ATOM   2613  CD  GLU A 309      30.497   1.093  35.272  1.00 72.16           C  
ATOM   2614  OE1 GLU A 309      29.799   0.075  35.042  1.00 73.68           O  
ATOM   2615  OE2 GLU A 309      31.353   1.544  34.463  1.00 71.64           O  
ATOM   2616  N   GLU A 310      30.141   0.359  40.743  1.00 64.82           N  
ATOM   2617  CA  GLU A 310      29.480  -0.059  41.948  1.00 64.44           C  
ATOM   2618  C   GLU A 310      27.988   0.245  41.849  1.00 64.49           C  
ATOM   2619  O   GLU A 310      27.583   0.995  40.974  1.00 65.15           O  
ATOM   2620  CB  GLU A 310      30.141   0.611  43.137  1.00 64.58           C  
ATOM   2621  CG  GLU A 310      31.532   0.063  43.450  1.00 64.78           C  
ATOM   2622  CD  GLU A 310      31.473  -1.077  44.427  1.00 65.29           C  
ATOM   2623  OE1 GLU A 310      30.821  -0.880  45.469  1.00 65.08           O  
ATOM   2624  OE2 GLU A 310      32.050  -2.160  44.161  1.00 65.61           O  
ATOM   2625  N   ARG A 311      27.163  -0.346  42.717  1.00 64.61           N  
ATOM   2626  CA  ARG A 311      25.694  -0.198  42.629  1.00 64.69           C  
ATOM   2627  C   ARG A 311      25.014   0.434  43.827  1.00 64.71           C  
ATOM   2628  O   ARG A 311      25.286   0.119  44.969  1.00 64.83           O  
ATOM   2629  CB  ARG A 311      25.033  -1.538  42.318  1.00 64.18           C  
ATOM   2630  CG  ARG A 311      25.394  -1.976  40.966  1.00 67.10           C  
ATOM   2631  CD  ARG A 311      25.164  -3.431  40.680  1.00 74.96           C  
ATOM   2632  NE  ARG A 311      25.666  -3.719  39.321  1.00 81.81           N  
ATOM   2633  CZ  ARG A 311      25.070  -4.539  38.448  1.00 84.02           C  
ATOM   2634  NH1 ARG A 311      23.937  -5.176  38.786  1.00 83.75           N  
ATOM   2635  NH2 ARG A 311      25.595  -4.704  37.233  1.00 81.78           N  
ATOM   2636  N   ALA A 312      24.087   1.325  43.557  1.00 65.97           N  
ATOM   2637  CA  ALA A 312      23.259   1.885  44.615  1.00 67.30           C  
ATOM   2638  C   ALA A 312      22.895   0.784  45.599  1.00 68.04           C  
ATOM   2639  O   ALA A 312      22.419  -0.240  45.189  1.00 68.75           O  
ATOM   2640  CB  ALA A 312      22.002   2.474  44.001  1.00 66.94           C  
ATOM   2641  N   LYS A 313      23.103   0.939  46.893  1.00 69.35           N  
ATOM   2642  CA  LYS A 313      22.562  -0.126  47.767  1.00 70.43           C  
ATOM   2643  C   LYS A 313      21.031  -0.196  47.813  1.00 71.08           C  
ATOM   2644  O   LYS A 313      20.520  -1.142  48.360  1.00 71.72           O  
ATOM   2645  CB  LYS A 313      23.077  -0.069  49.208  1.00 70.35           C  
ATOM   2646  CG  LYS A 313      22.979  -1.429  49.911  1.00 69.35           C  
ATOM   2647  CD  LYS A 313      22.939  -1.259  51.411  1.00 70.05           C  
ATOM   2648  CE  LYS A 313      23.787  -2.278  52.112  1.00 69.79           C  
ATOM   2649  NZ  LYS A 313      24.273  -1.713  53.407  1.00 72.16           N  
ATOM   2650  N   GLY A 314      20.309   0.793  47.271  1.00 71.34           N  
ATOM   2651  CA  GLY A 314      18.851   0.837  47.405  1.00 71.34           C  
ATOM   2652  C   GLY A 314      18.274   2.241  47.383  1.00 71.56           C  
ATOM   2653  O   GLY A 314      18.942   3.175  46.943  1.00 72.42           O  
ATOM   2654  N   LYS A 315      17.031   2.380  47.842  1.00 71.01           N  
ATOM   2655  CA  LYS A 315      16.345   3.670  48.003  1.00 70.41           C  
ATOM   2656  C   LYS A 315      16.022   3.796  49.478  1.00 69.65           C  
ATOM   2657  O   LYS A 315      15.906   2.788  50.174  1.00 70.13           O  
ATOM   2658  CB  LYS A 315      15.039   3.634  47.213  1.00 70.73           C  
ATOM   2659  CG  LYS A 315      14.385   4.973  46.831  1.00 71.58           C  
ATOM   2660  CD  LYS A 315      13.179   4.705  45.898  1.00 70.79           C  
ATOM   2661  CE  LYS A 315      12.039   5.713  46.081  1.00 71.10           C  
ATOM   2662  NZ  LYS A 315      12.178   6.904  45.151  1.00 72.07           N  
ATOM   2663  N   LEU A 316      15.882   5.006  49.987  1.00 68.67           N  
ATOM   2664  CA  LEU A 316      15.443   5.141  51.371  1.00 67.88           C  
ATOM   2665  C   LEU A 316      14.148   5.865  51.316  1.00 68.32           C  
ATOM   2666  O   LEU A 316      13.962   6.744  50.478  1.00 68.52           O  
ATOM   2667  CB  LEU A 316      16.398   5.940  52.237  1.00 67.25           C  
ATOM   2668  CG  LEU A 316      17.910   5.743  52.205  1.00 66.13           C  
ATOM   2669  CD1 LEU A 316      18.596   6.885  52.950  1.00 63.08           C  
ATOM   2670  CD2 LEU A 316      18.295   4.407  52.752  1.00 62.53           C  
ATOM   2671  N   ASN A 317      13.231   5.450  52.176  1.00 68.94           N  
ATOM   2672  CA  ASN A 317      11.959   6.103  52.309  1.00 69.49           C  
ATOM   2673  C   ASN A 317      12.085   7.025  53.471  1.00 69.84           C  
ATOM   2674  O   ASN A 317      12.709   6.682  54.505  1.00 70.30           O  
ATOM   2675  CB  ASN A 317      10.867   5.094  52.597  1.00 69.95           C  
ATOM   2676  CG  ASN A 317      10.292   4.507  51.344  1.00 72.11           C  
ATOM   2677  OD1 ASN A 317      10.770   4.812  50.237  1.00 75.29           O  
ATOM   2678  ND2 ASN A 317       9.257   3.653  51.488  1.00 72.49           N  
ATOM   2679  N   PHE A 318      11.507   8.201  53.315  1.00 69.25           N  
ATOM   2680  CA  PHE A 318      11.471   9.125  54.399  1.00 69.46           C  
ATOM   2681  C   PHE A 318      10.021   9.603  54.530  1.00 70.30           C  
ATOM   2682  O   PHE A 318       9.147   9.311  53.677  1.00 69.97           O  
ATOM   2683  CB  PHE A 318      12.407  10.260  54.100  1.00 68.78           C  
ATOM   2684  CG  PHE A 318      12.174  10.829  52.771  1.00 69.59           C  
ATOM   2685  CD1 PHE A 318      11.295  11.912  52.610  1.00 68.45           C  
ATOM   2686  CD2 PHE A 318      12.760  10.236  51.645  1.00 68.64           C  
ATOM   2687  CE1 PHE A 318      11.038  12.410  51.351  1.00 68.50           C  
ATOM   2688  CE2 PHE A 318      12.507  10.733  50.382  1.00 68.33           C  
ATOM   2689  CZ  PHE A 318      11.645  11.822  50.229  1.00 68.14           C  
ATOM   2690  N   LYS A 319       9.769  10.295  55.635  1.00 70.81           N  
ATOM   2691  CA  LYS A 319       8.494  10.854  55.902  1.00 71.17           C  
ATOM   2692  C   LYS A 319       8.316  11.991  54.911  1.00 72.03           C  
ATOM   2693  O   LYS A 319       8.814  13.102  55.143  1.00 72.77           O  
ATOM   2694  CB  LYS A 319       8.503  11.362  57.330  1.00 71.14           C  
ATOM   2695  CG  LYS A 319       8.813  10.288  58.374  1.00 71.82           C  
ATOM   2696  CD  LYS A 319       7.933   9.072  58.154  1.00 72.87           C  
ATOM   2697  CE  LYS A 319       7.831   8.170  59.358  1.00 72.90           C  
ATOM   2698  NZ  LYS A 319       7.036   6.980  58.911  1.00 73.87           N  
ATOM   2699  N   ASP A 320       7.646  11.712  53.790  1.00 72.30           N  
ATOM   2700  CA  ASP A 320       7.405  12.736  52.777  1.00 72.87           C  
ATOM   2701  C   ASP A 320       5.996  13.260  52.881  1.00 72.80           C  
ATOM   2702  O   ASP A 320       5.547  14.037  52.059  1.00 73.59           O  
ATOM   2703  CB  ASP A 320       7.664  12.202  51.370  1.00 73.08           C  
ATOM   2704  CG  ASP A 320       6.799  11.027  51.047  1.00 74.29           C  
ATOM   2705  OD1 ASP A 320       5.975  10.690  51.921  1.00 75.96           O  
ATOM   2706  OD2 ASP A 320       6.929  10.457  49.940  1.00 74.99           O  
ATOM   2707  N   THR A 321       5.298  12.847  53.914  1.00 73.17           N  
ATOM   2708  CA  THR A 321       3.931  13.293  54.122  1.00 73.53           C  
ATOM   2709  C   THR A 321       3.807  14.661  54.833  1.00 73.07           C  
ATOM   2710  O   THR A 321       4.453  14.895  55.879  1.00 73.18           O  
ATOM   2711  CB  THR A 321       3.166  12.170  54.792  1.00 73.96           C  
ATOM   2712  OG1 THR A 321       2.783  11.247  53.763  1.00 75.32           O  
ATOM   2713  CG2 THR A 321       1.931  12.668  55.530  1.00 74.59           C  
ATOM   2714  N   VAL A 322       2.955  15.521  54.250  1.00 72.21           N  
ATOM   2715  CA  VAL A 322       2.912  16.984  54.474  1.00 71.91           C  
ATOM   2716  C   VAL A 322       1.461  17.543  54.501  1.00 72.00           C  
ATOM   2717  O   VAL A 322       0.647  17.184  53.646  1.00 72.03           O  
ATOM   2718  CB  VAL A 322       3.815  17.706  53.357  1.00 71.71           C  
ATOM   2719  CG1 VAL A 322       3.096  18.789  52.567  1.00 70.62           C  
ATOM   2720  CG2 VAL A 322       5.084  18.258  53.933  1.00 71.69           C  
ATOM   2721  N   LEU A 323       1.136  18.423  55.451  1.00 72.23           N  
ATOM   2722  CA  LEU A 323      -0.254  18.908  55.594  1.00 73.06           C  
ATOM   2723  C   LEU A 323      -0.423  20.381  55.886  1.00 74.09           C  
ATOM   2724  O   LEU A 323       0.459  21.017  56.477  1.00 74.58           O  
ATOM   2725  CB  LEU A 323      -1.012  18.161  56.701  1.00 73.03           C  
ATOM   2726  CG  LEU A 323      -0.642  18.462  58.165  1.00 71.83           C  
ATOM   2727  CD1 LEU A 323      -1.871  18.658  59.046  1.00 70.71           C  
ATOM   2728  CD2 LEU A 323       0.260  17.355  58.698  1.00 70.43           C  
ATOM   2729  N   ASP A 324      -1.604  20.894  55.532  1.00 75.02           N  
ATOM   2730  CA  ASP A 324      -1.958  22.308  55.751  1.00 75.51           C  
ATOM   2731  C   ASP A 324      -2.717  22.561  57.050  1.00 76.31           C  
ATOM   2732  O   ASP A 324      -2.865  21.680  57.892  1.00 76.48           O  
ATOM   2733  CB  ASP A 324      -2.752  22.873  54.556  1.00 75.30           C  
ATOM   2734  CG  ASP A 324      -4.170  22.287  54.429  1.00 75.06           C  
ATOM   2735  OD1 ASP A 324      -4.702  21.716  55.408  1.00 74.88           O  
ATOM   2736  OD2 ASP A 324      -4.765  22.423  53.337  1.00 74.19           O  
ATOM   2737  N   ALA A 325      -3.209  23.788  57.175  1.00 77.61           N  
ATOM   2738  CA  ALA A 325      -3.965  24.265  58.329  1.00 78.55           C  
ATOM   2739  C   ALA A 325      -5.328  23.595  58.511  1.00 79.50           C  
ATOM   2740  O   ALA A 325      -5.953  23.727  59.560  1.00 79.34           O  
ATOM   2741  CB  ALA A 325      -4.117  25.771  58.245  1.00 78.43           C  
ATOM   2742  N   LYS A 326      -5.785  22.880  57.493  1.00 81.12           N  
ATOM   2743  CA  LYS A 326      -6.956  22.044  57.642  1.00 82.91           C  
ATOM   2744  C   LYS A 326      -6.490  20.675  58.104  1.00 83.76           C  
ATOM   2745  O   LYS A 326      -6.832  20.230  59.200  1.00 84.32           O  
ATOM   2746  CB  LYS A 326      -7.745  21.951  56.335  1.00 83.25           C  
ATOM   2747  CG  LYS A 326      -8.376  23.264  55.885  1.00 84.32           C  
ATOM   2748  CD  LYS A 326      -9.106  23.953  57.034  1.00 86.38           C  
ATOM   2749  CE  LYS A 326      -9.764  25.237  56.564  1.00 87.66           C  
ATOM   2750  NZ  LYS A 326     -10.052  26.106  57.730  1.00 88.01           N  
ATOM   2751  N   GLY A 327      -5.667  20.028  57.298  1.00 84.63           N  
ATOM   2752  CA  GLY A 327      -5.180  18.706  57.637  1.00 86.42           C  
ATOM   2753  C   GLY A 327      -5.138  17.847  56.400  1.00 87.72           C  
ATOM   2754  O   GLY A 327      -5.274  16.631  56.478  1.00 87.33           O  
ATOM   2755  N   LYS A 328      -4.955  18.512  55.261  1.00 89.35           N  
ATOM   2756  CA  LYS A 328      -4.937  17.875  53.962  1.00 91.22           C  
ATOM   2757  C   LYS A 328      -3.526  17.378  53.702  1.00 92.37           C  
ATOM   2758  O   LYS A 328      -2.557  18.015  54.123  1.00 92.54           O  
ATOM   2759  CB  LYS A 328      -5.397  18.851  52.899  1.00 91.19           C  
ATOM   2760  CG  LYS A 328      -6.673  19.579  53.302  1.00 92.69           C  
ATOM   2761  CD  LYS A 328      -7.067  20.634  52.266  1.00 95.76           C  
ATOM   2762  CE  LYS A 328      -8.407  21.280  52.605  1.00 96.91           C  
ATOM   2763  NZ  LYS A 328      -8.785  22.273  51.561  1.00 97.58           N  
ATOM   2764  N   ASN A 329      -3.437  16.253  52.991  1.00 93.40           N  
ATOM   2765  CA  ASN A 329      -2.336  15.329  53.111  1.00 94.60           C  
ATOM   2766  C   ASN A 329      -1.628  15.066  51.802  1.00 96.20           C  
ATOM   2767  O   ASN A 329      -1.894  15.727  50.807  1.00 96.43           O  
ATOM   2768  CB  ASN A 329      -2.882  13.988  53.644  1.00 94.23           C  
ATOM   2769  CG  ASN A 329      -2.912  13.918  55.159  1.00 93.29           C  
ATOM   2770  OD1 ASN A 329      -3.414  14.819  55.813  1.00 93.42           O  
ATOM   2771  ND2 ASN A 329      -2.371  12.840  55.724  1.00 91.37           N  
ATOM   2772  N   THR A 330      -0.731  14.077  51.833  1.00 98.32           N  
ATOM   2773  CA  THR A 330      -0.231  13.366  50.656  1.00100.33           C  
ATOM   2774  C   THR A 330      -1.369  12.643  49.973  1.00101.61           C  
ATOM   2775  O   THR A 330      -1.199  12.172  48.845  1.00102.35           O  
ATOM   2776  CB  THR A 330       0.756  12.249  51.030  1.00100.81           C  
ATOM   2777  OG1 THR A 330       1.203  12.430  52.382  1.00102.63           O  
ATOM   2778  CG2 THR A 330       1.958  12.144  50.026  1.00 99.95           C  
ATOM   2779  N   LYS A 331      -2.499  12.508  50.679  1.00102.73           N  
ATOM   2780  CA  LYS A 331      -3.774  12.060  50.097  1.00103.66           C  
ATOM   2781  C   LYS A 331      -4.205  12.898  48.897  1.00104.16           C  
ATOM   2782  O   LYS A 331      -4.847  12.378  47.973  1.00104.11           O  
ATOM   2783  CB  LYS A 331      -4.879  11.999  51.162  1.00103.64           C  
ATOM   2784  CG  LYS A 331      -4.881  10.655  51.880  1.00104.48           C  
ATOM   2785  CD  LYS A 331      -5.246  10.715  53.369  1.00105.20           C  
ATOM   2786  CE  LYS A 331      -4.807   9.411  54.078  1.00104.79           C  
ATOM   2787  NZ  LYS A 331      -5.587   9.069  55.308  1.00104.22           N  
ATOM   2788  N   VAL A 332      -3.839  14.181  48.904  1.00104.87           N  
ATOM   2789  CA  VAL A 332      -3.977  15.017  47.705  1.00106.07           C  
ATOM   2790  C   VAL A 332      -2.689  15.038  46.862  1.00106.76           C  
ATOM   2791  O   VAL A 332      -2.741  15.125  45.621  1.00106.87           O  
ATOM   2792  CB  VAL A 332      -4.429  16.467  48.035  1.00105.94           C  
ATOM   2793  CG1 VAL A 332      -4.366  17.362  46.783  1.00105.46           C  
ATOM   2794  CG2 VAL A 332      -5.843  16.466  48.623  1.00106.40           C  
ATOM   2795  N   ILE A 333      -1.551  14.936  47.550  1.00107.46           N  
ATOM   2796  CA  ILE A 333      -0.213  15.118  46.957  1.00107.95           C  
ATOM   2797  C   ILE A 333       0.058  14.303  45.650  1.00108.43           C  
ATOM   2798  O   ILE A 333       1.132  14.430  45.029  1.00108.51           O  
ATOM   2799  CB  ILE A 333       0.929  14.986  48.069  1.00108.40           C  
ATOM   2800  CG1 ILE A 333       0.685  15.994  49.218  1.00107.46           C  
ATOM   2801  CG2 ILE A 333       2.389  15.062  47.455  1.00107.87           C  
ATOM   2802  CD1 ILE A 333       1.588  15.848  50.436  1.00107.12           C  
ATOM   2803  N   THR A 334      -0.925  13.510  45.220  1.00108.61           N  
ATOM   2804  CA  THR A 334      -0.884  12.894  43.881  1.00108.94           C  
ATOM   2805  C   THR A 334      -1.019  13.959  42.775  1.00108.60           C  
ATOM   2806  O   THR A 334      -0.936  13.646  41.576  1.00108.92           O  
ATOM   2807  CB  THR A 334      -1.912  11.738  43.729  1.00109.17           C  
ATOM   2808  OG1 THR A 334      -1.769  10.853  44.846  1.00109.99           O  
ATOM   2809  CG2 THR A 334      -1.686  10.937  42.424  1.00108.70           C  
ATOM   2810  N   ASN A 335      -1.229  15.209  43.193  1.00107.61           N  
ATOM   2811  CA  ASN A 335      -0.856  16.379  42.388  1.00106.93           C  
ATOM   2812  C   ASN A 335      -0.227  17.454  43.285  1.00106.09           C  
ATOM   2813  O   ASN A 335      -0.906  18.057  44.136  1.00106.12           O  
ATOM   2814  CB  ASN A 335      -2.040  16.951  41.593  1.00107.05           C  
ATOM   2815  CG  ASN A 335      -2.415  16.105  40.375  1.00108.07           C  
ATOM   2816  OD1 ASN A 335      -1.552  15.544  39.691  1.00109.97           O  
ATOM   2817  ND2 ASN A 335      -3.714  16.024  40.091  1.00108.52           N  
ATOM   2818  N   LEU A 336       1.075  17.675  43.112  1.00104.75           N  
ATOM   2819  CA  LEU A 336       1.777  18.689  43.893  1.00103.30           C  
ATOM   2820  C   LEU A 336       1.178  20.083  43.630  1.00101.80           C  
ATOM   2821  O   LEU A 336       0.957  20.857  44.567  1.00101.51           O  
ATOM   2822  CB  LEU A 336       3.292  18.641  43.625  1.00103.77           C  
ATOM   2823  CG  LEU A 336       4.070  17.443  44.209  1.00104.58           C  
ATOM   2824  CD1 LEU A 336       5.518  17.373  43.677  1.00104.82           C  
ATOM   2825  CD2 LEU A 336       4.052  17.458  45.735  1.00105.11           C  
ATOM   2826  N   ARG A 337       0.892  20.364  42.356  1.00 99.59           N  
ATOM   2827  CA  ARG A 337       0.182  21.568  41.943  1.00 97.65           C  
ATOM   2828  C   ARG A 337      -1.231  21.569  42.503  1.00 96.15           C  
ATOM   2829  O   ARG A 337      -1.625  22.480  43.252  1.00 96.04           O  
ATOM   2830  CB  ARG A 337       0.117  21.663  40.417  1.00 97.88           C  
ATOM   2831  CG  ARG A 337       1.474  21.607  39.684  1.00 98.37           C  
ATOM   2832  CD  ARG A 337       1.419  22.308  38.314  1.00 98.26           C  
ATOM   2833  NE  ARG A 337       2.570  21.954  37.480  1.00100.41           N  
ATOM   2834  CZ  ARG A 337       2.736  22.332  36.212  1.00100.50           C  
ATOM   2835  NH1 ARG A 337       1.825  23.095  35.613  1.00 99.02           N  
ATOM   2836  NH2 ARG A 337       3.822  21.944  35.546  1.00100.39           N  
ATOM   2837  N   LYS A 338      -1.998  20.540  42.155  1.00 93.98           N  
ATOM   2838  CA  LYS A 338      -3.350  20.433  42.680  1.00 92.00           C  
ATOM   2839  C   LYS A 338      -3.359  20.556  44.204  1.00 89.98           C  
ATOM   2840  O   LYS A 338      -4.388  20.892  44.780  1.00 89.47           O  
ATOM   2841  CB  LYS A 338      -4.044  19.146  42.208  1.00 92.12           C  
ATOM   2842  CG  LYS A 338      -5.575  19.094  42.453  1.00 92.92           C  
ATOM   2843  CD  LYS A 338      -6.288  18.057  41.573  1.00 92.65           C  
ATOM   2844  CE  LYS A 338      -6.294  18.468  40.072  1.00 95.19           C  
ATOM   2845  NZ  LYS A 338      -6.965  17.486  39.131  1.00 94.52           N  
ATOM   2846  N   PHE A 339      -2.218  20.315  44.846  1.00 87.79           N  
ATOM   2847  CA  PHE A 339      -2.156  20.431  46.301  1.00 86.27           C  
ATOM   2848  C   PHE A 339      -2.045  21.865  46.789  1.00 85.49           C  
ATOM   2849  O   PHE A 339      -2.606  22.222  47.826  1.00 84.88           O  
ATOM   2850  CB  PHE A 339      -1.018  19.606  46.911  1.00 85.76           C  
ATOM   2851  CG  PHE A 339      -0.955  19.692  48.420  1.00 84.29           C  
ATOM   2852  CD1 PHE A 339      -1.814  18.940  49.211  1.00 83.06           C  
ATOM   2853  CD2 PHE A 339      -0.057  20.539  49.045  1.00 83.20           C  
ATOM   2854  CE1 PHE A 339      -1.774  19.029  50.610  1.00 82.60           C  
ATOM   2855  CE2 PHE A 339      -0.009  20.619  50.444  1.00 83.66           C  
ATOM   2856  CZ  PHE A 339      -0.876  19.866  51.223  1.00 82.46           C  
ATOM   2857  N   LEU A 340      -1.306  22.673  46.044  1.00 84.64           N  
ATOM   2858  CA  LEU A 340      -0.969  23.998  46.501  1.00 83.75           C  
ATOM   2859  C   LEU A 340      -2.100  24.921  46.185  1.00 83.44           C  
ATOM   2860  O   LEU A 340      -2.355  25.852  46.935  1.00 83.31           O  
ATOM   2861  CB  LEU A 340       0.297  24.493  45.837  1.00 83.75           C  
ATOM   2862  CG  LEU A 340       1.565  23.684  46.075  1.00 83.80           C  
ATOM   2863  CD1 LEU A 340       2.350  23.635  44.786  1.00 83.58           C  
ATOM   2864  CD2 LEU A 340       2.395  24.283  47.217  1.00 84.50           C  
ATOM   2865  N   GLU A 341      -2.782  24.673  45.071  1.00 83.14           N  
ATOM   2866  CA  GLU A 341      -4.011  25.409  44.798  1.00 83.11           C  
ATOM   2867  C   GLU A 341      -4.963  25.301  45.990  1.00 82.69           C  
ATOM   2868  O   GLU A 341      -5.245  26.297  46.652  1.00 83.07           O  
ATOM   2869  CB  GLU A 341      -4.708  24.893  43.557  1.00 83.03           C  
ATOM   2870  CG  GLU A 341      -3.810  24.730  42.386  1.00 84.83           C  
ATOM   2871  CD  GLU A 341      -4.518  24.057  41.231  1.00 88.16           C  
ATOM   2872  OE1 GLU A 341      -5.693  24.409  40.943  1.00 88.21           O  
ATOM   2873  OE2 GLU A 341      -3.893  23.164  40.608  1.00 90.60           O  
ATOM   2874  N   LEU A 342      -5.426  24.088  46.285  1.00 82.00           N  
ATOM   2875  CA  LEU A 342      -6.442  23.883  47.311  1.00 81.29           C  
ATOM   2876  C   LEU A 342      -5.886  24.133  48.687  1.00 80.84           C  
ATOM   2877  O   LEU A 342      -6.605  24.588  49.565  1.00 81.51           O  
ATOM   2878  CB  LEU A 342      -7.019  22.470  47.251  1.00 81.34           C  
ATOM   2879  CG  LEU A 342      -7.345  21.887  45.872  1.00 81.85           C  
ATOM   2880  CD1 LEU A 342      -6.939  20.418  45.816  1.00 82.02           C  
ATOM   2881  CD2 LEU A 342      -8.815  22.106  45.465  1.00 81.39           C  
ATOM   2882  N   CYS A 343      -4.604  23.860  48.881  1.00 80.08           N  
ATOM   2883  CA  CYS A 343      -4.044  23.896  50.225  1.00 79.47           C  
ATOM   2884  C   CYS A 343      -4.316  25.212  50.943  1.00 78.21           C  
ATOM   2885  O   CYS A 343      -4.418  26.262  50.332  1.00 77.92           O  
ATOM   2886  CB  CYS A 343      -2.548  23.642  50.192  1.00 79.68           C  
ATOM   2887  SG  CYS A 343      -1.596  25.159  50.256  1.00 81.87           S  
ATOM   2888  N   ARG A 344      -4.411  25.149  52.255  1.00 77.14           N  
ATOM   2889  CA  ARG A 344      -4.739  26.333  52.999  1.00 76.60           C  
ATOM   2890  C   ARG A 344      -3.697  26.560  54.090  1.00 75.09           C  
ATOM   2891  O   ARG A 344      -3.631  25.814  55.050  1.00 74.80           O  
ATOM   2892  CB  ARG A 344      -6.178  26.230  53.517  1.00 77.51           C  
ATOM   2893  CG  ARG A 344      -7.133  25.634  52.445  1.00 80.13           C  
ATOM   2894  CD  ARG A 344      -8.491  26.300  52.431  1.00 86.01           C  
ATOM   2895  NE  ARG A 344      -9.530  25.453  51.821  1.00 90.63           N  
ATOM   2896  CZ  ARG A 344     -10.814  25.422  52.219  1.00 93.95           C  
ATOM   2897  NH1 ARG A 344     -11.239  26.177  53.244  1.00 94.04           N  
ATOM   2898  NH2 ARG A 344     -11.686  24.625  51.600  1.00 94.72           N  
ATOM   2899  N   PRO A 345      -2.863  27.596  53.915  1.00 73.83           N  
ATOM   2900  CA  PRO A 345      -1.628  27.808  54.650  1.00 72.69           C  
ATOM   2901  C   PRO A 345      -1.820  28.206  56.093  1.00 71.66           C  
ATOM   2902  O   PRO A 345      -2.848  28.769  56.459  1.00 71.56           O  
ATOM   2903  CB  PRO A 345      -1.004  28.988  53.915  1.00 72.67           C  
ATOM   2904  CG  PRO A 345      -2.161  29.763  53.454  1.00 72.89           C  
ATOM   2905  CD  PRO A 345      -3.087  28.689  52.952  1.00 73.71           C  
ATOM   2906  N   PHE A 346      -0.798  27.926  56.884  1.00 70.53           N  
ATOM   2907  CA  PHE A 346      -0.712  28.387  58.238  1.00 69.95           C  
ATOM   2908  C   PHE A 346      -0.383  29.869  58.321  1.00 69.72           C  
ATOM   2909  O   PHE A 346       0.813  30.252  58.264  1.00 69.28           O  
ATOM   2910  CB  PHE A 346       0.362  27.601  58.935  1.00 69.96           C  
ATOM   2911  CG  PHE A 346       0.034  26.181  59.081  1.00 69.08           C  
ATOM   2912  CD1 PHE A 346       0.454  25.269  58.130  1.00 69.08           C  
ATOM   2913  CD2 PHE A 346      -0.696  25.743  60.181  1.00 68.29           C  
ATOM   2914  CE1 PHE A 346       0.155  23.910  58.269  1.00 70.41           C  
ATOM   2915  CE2 PHE A 346      -1.008  24.413  60.341  1.00 68.01           C  
ATOM   2916  CZ  PHE A 346      -0.584  23.484  59.378  1.00 70.32           C  
ATOM   2917  N   VAL A 347      -1.444  30.682  58.490  1.00 69.16           N  
ATOM   2918  CA  VAL A 347      -1.355  32.149  58.394  1.00 68.40           C  
ATOM   2919  C   VAL A 347      -1.042  32.785  59.714  1.00 68.37           C  
ATOM   2920  O   VAL A 347      -1.850  32.735  60.612  1.00 68.45           O  
ATOM   2921  CB  VAL A 347      -2.644  32.813  57.898  1.00 67.85           C  
ATOM   2922  CG1 VAL A 347      -2.375  34.285  57.641  1.00 68.16           C  
ATOM   2923  CG2 VAL A 347      -3.157  32.164  56.639  1.00 67.11           C  
ATOM   2924  N   LYS A 348       0.122  33.404  59.833  1.00 68.66           N  
ATOM   2925  CA  LYS A 348       0.403  34.177  61.027  1.00 68.77           C  
ATOM   2926  C   LYS A 348       0.615  35.666  60.729  1.00 68.79           C  
ATOM   2927  O   LYS A 348       0.912  36.454  61.631  1.00 68.75           O  
ATOM   2928  CB  LYS A 348       1.554  33.561  61.816  1.00 69.03           C  
ATOM   2929  CG  LYS A 348       1.232  32.149  62.315  1.00 69.80           C  
ATOM   2930  CD  LYS A 348       2.229  31.692  63.344  1.00 70.92           C  
ATOM   2931  CE  LYS A 348       2.797  30.329  62.997  1.00 72.03           C  
ATOM   2932  NZ  LYS A 348       3.848  29.933  63.985  1.00 73.93           N  
ATOM   2933  N   LYS A 349       0.440  36.063  59.468  1.00 68.66           N  
ATOM   2934  CA  LYS A 349       0.415  37.492  59.152  1.00 68.29           C  
ATOM   2935  C   LYS A 349      -0.624  37.868  58.103  1.00 67.89           C  
ATOM   2936  O   LYS A 349      -0.326  37.946  56.927  1.00 68.23           O  
ATOM   2937  CB  LYS A 349       1.802  38.035  58.807  1.00 68.11           C  
ATOM   2938  CG  LYS A 349       1.848  39.529  58.984  1.00 68.04           C  
ATOM   2939  CD  LYS A 349       3.249  40.065  59.049  1.00 67.12           C  
ATOM   2940  CE  LYS A 349       3.198  41.545  59.353  1.00 65.73           C  
ATOM   2941  NZ  LYS A 349       4.543  42.147  59.324  1.00 65.33           N  
ATOM   2942  N   ASP A 350      -1.836  38.116  58.584  1.00 67.56           N  
ATOM   2943  CA  ASP A 350      -3.020  38.468  57.798  1.00 67.31           C  
ATOM   2944  C   ASP A 350      -2.766  39.494  56.690  1.00 66.38           C  
ATOM   2945  O   ASP A 350      -3.132  39.269  55.524  1.00 66.76           O  
ATOM   2946  CB  ASP A 350      -4.105  39.009  58.737  1.00 67.77           C  
ATOM   2947  CG  ASP A 350      -4.358  38.094  59.956  1.00 70.34           C  
ATOM   2948  OD1 ASP A 350      -5.554  37.796  60.194  1.00 72.06           O  
ATOM   2949  OD2 ASP A 350      -3.393  37.684  60.683  1.00 72.70           O  
ATOM   2950  N   VAL A 351      -2.149  40.616  57.055  1.00 64.79           N  
ATOM   2951  CA  VAL A 351      -1.801  41.669  56.092  1.00 62.72           C  
ATOM   2952  C   VAL A 351      -0.307  41.681  55.811  1.00 61.77           C  
ATOM   2953  O   VAL A 351       0.491  41.642  56.739  1.00 61.69           O  
ATOM   2954  CB  VAL A 351      -2.238  43.046  56.604  1.00 62.23           C  
ATOM   2955  CG1 VAL A 351      -1.675  44.163  55.739  1.00 60.84           C  
ATOM   2956  CG2 VAL A 351      -3.716  43.099  56.621  1.00 61.91           C  
ATOM   2957  N   LEU A 352       0.055  41.740  54.530  1.00 60.50           N  
ATOM   2958  CA  LEU A 352       1.455  41.867  54.099  1.00 59.45           C  
ATOM   2959  C   LEU A 352       1.748  43.212  53.462  1.00 58.90           C  
ATOM   2960  O   LEU A 352       0.970  43.650  52.623  1.00 59.60           O  
ATOM   2961  CB  LEU A 352       1.738  40.820  53.041  1.00 59.58           C  
ATOM   2962  CG  LEU A 352       1.831  39.398  53.534  1.00 59.38           C  
ATOM   2963  CD1 LEU A 352       2.618  38.610  52.500  1.00 58.11           C  
ATOM   2964  CD2 LEU A 352       2.507  39.430  54.927  1.00 59.37           C  
ATOM   2965  N   SER A 353       2.850  43.879  53.803  1.00 57.80           N  
ATOM   2966  CA  SER A 353       3.210  45.057  52.994  1.00 57.21           C  
ATOM   2967  C   SER A 353       4.404  44.850  52.027  1.00 57.01           C  
ATOM   2968  O   SER A 353       5.534  44.512  52.433  1.00 56.78           O  
ATOM   2969  CB  SER A 353       3.371  46.314  53.821  1.00 56.78           C  
ATOM   2970  OG  SER A 353       4.726  46.506  54.128  1.00 57.33           O  
ATOM   2971  N   VAL A 354       4.117  45.102  50.750  1.00 56.25           N  
ATOM   2972  CA  VAL A 354       4.973  44.718  49.633  1.00 55.66           C  
ATOM   2973  C   VAL A 354       5.513  45.922  48.873  1.00 55.23           C  
ATOM   2974  O   VAL A 354       4.807  46.925  48.684  1.00 55.08           O  
ATOM   2975  CB  VAL A 354       4.168  43.862  48.661  1.00 55.54           C  
ATOM   2976  CG1 VAL A 354       5.014  43.405  47.536  1.00 54.52           C  
ATOM   2977  CG2 VAL A 354       3.563  42.709  49.414  1.00 55.35           C  
ATOM   2978  N   GLU A 355       6.766  45.822  48.445  1.00 54.37           N  
ATOM   2979  CA  GLU A 355       7.381  46.909  47.690  1.00 54.09           C  
ATOM   2980  C   GLU A 355       7.788  46.382  46.310  1.00 53.74           C  
ATOM   2981  O   GLU A 355       8.518  45.366  46.181  1.00 54.11           O  
ATOM   2982  CB  GLU A 355       8.573  47.484  48.443  1.00 53.95           C  
ATOM   2983  CG  GLU A 355       9.042  48.813  47.936  1.00 55.23           C  
ATOM   2984  CD  GLU A 355       8.543  49.969  48.761  1.00 59.65           C  
ATOM   2985  OE1 GLU A 355       8.592  49.874  50.014  1.00 59.87           O  
ATOM   2986  OE2 GLU A 355       8.117  50.997  48.154  1.00 63.22           O  
ATOM   2987  N   ILE A 356       7.304  47.064  45.277  1.00 52.23           N  
ATOM   2988  CA  ILE A 356       7.419  46.532  43.932  1.00 50.85           C  
ATOM   2989  C   ILE A 356       8.478  47.248  43.108  1.00 49.77           C  
ATOM   2990  O   ILE A 356       8.425  48.483  42.932  1.00 48.82           O  
ATOM   2991  CB  ILE A 356       6.024  46.483  43.242  1.00 51.25           C  
ATOM   2992  CG1 ILE A 356       5.248  45.294  43.810  1.00 50.86           C  
ATOM   2993  CG2 ILE A 356       6.105  46.437  41.674  1.00 50.12           C  
ATOM   2994  CD1 ILE A 356       3.777  45.336  43.505  1.00 50.87           C  
ATOM   2995  N   ILE A 357       9.427  46.447  42.611  1.00 47.95           N  
ATOM   2996  CA  ILE A 357      10.455  46.948  41.720  1.00 46.87           C  
ATOM   2997  C   ILE A 357      10.370  46.339  40.334  1.00 46.42           C  
ATOM   2998  O   ILE A 357      10.544  45.149  40.162  1.00 46.73           O  
ATOM   2999  CB  ILE A 357      11.834  46.737  42.309  1.00 46.31           C  
ATOM   3000  CG1 ILE A 357      11.907  47.464  43.646  1.00 46.03           C  
ATOM   3001  CG2 ILE A 357      12.874  47.276  41.378  1.00 45.57           C  
ATOM   3002  CD1 ILE A 357      13.125  47.168  44.406  1.00 46.55           C  
ATOM   3003  N   SER A 358      10.102  47.162  39.338  1.00 45.91           N  
ATOM   3004  CA  SER A 358      10.181  46.679  37.984  1.00 46.01           C  
ATOM   3005  C   SER A 358      11.321  47.335  37.218  1.00 45.88           C  
ATOM   3006  O   SER A 358      11.471  48.558  37.220  1.00 45.32           O  
ATOM   3007  CB  SER A 358       8.857  46.847  37.256  1.00 46.16           C  
ATOM   3008  OG  SER A 358       8.860  46.124  36.030  1.00 47.32           O  
ATOM   3009  N   VAL A 359      12.132  46.485  36.595  1.00 46.11           N  
ATOM   3010  CA  VAL A 359      13.255  46.904  35.754  1.00 46.62           C  
ATOM   3011  C   VAL A 359      12.956  46.511  34.315  1.00 47.12           C  
ATOM   3012  O   VAL A 359      12.833  45.311  34.007  1.00 47.64           O  
ATOM   3013  CB  VAL A 359      14.550  46.148  36.127  1.00 46.13           C  
ATOM   3014  CG1 VAL A 359      15.750  46.709  35.387  1.00 44.11           C  
ATOM   3015  CG2 VAL A 359      14.757  46.176  37.611  1.00 47.19           C  
ATOM   3016  N   SER A 360      12.865  47.485  33.424  1.00 46.86           N  
ATOM   3017  CA  SER A 360      12.684  47.132  32.034  1.00 47.16           C  
ATOM   3018  C   SER A 360      13.341  48.092  31.026  1.00 46.67           C  
ATOM   3019  O   SER A 360      13.895  49.119  31.393  1.00 46.14           O  
ATOM   3020  CB  SER A 360      11.186  46.917  31.761  1.00 47.52           C  
ATOM   3021  OG  SER A 360      10.527  48.141  31.451  1.00 50.01           O  
ATOM   3022  N   VAL A 361      13.267  47.751  29.750  1.00 46.96           N  
ATOM   3023  CA  VAL A 361      13.894  48.565  28.732  1.00 47.38           C  
ATOM   3024  C   VAL A 361      12.994  49.651  28.228  1.00 47.85           C  
ATOM   3025  O   VAL A 361      13.493  50.615  27.706  1.00 48.09           O  
ATOM   3026  CB  VAL A 361      14.422  47.755  27.531  1.00 47.03           C  
ATOM   3027  CG1 VAL A 361      15.267  48.621  26.676  1.00 46.57           C  
ATOM   3028  CG2 VAL A 361      15.286  46.660  28.009  1.00 47.88           C  
ATOM   3029  N   TYR A 362      11.684  49.527  28.386  1.00 48.90           N  
ATOM   3030  CA  TYR A 362      10.771  50.484  27.739  1.00 49.65           C  
ATOM   3031  C   TYR A 362       9.646  50.882  28.650  1.00 50.15           C  
ATOM   3032  O   TYR A 362       9.628  50.439  29.788  1.00 51.00           O  
ATOM   3033  CB  TYR A 362      10.248  49.892  26.433  1.00 50.15           C  
ATOM   3034  CG  TYR A 362      11.287  49.889  25.316  1.00 50.41           C  
ATOM   3035  CD1 TYR A 362      11.995  48.725  24.975  1.00 49.92           C  
ATOM   3036  CD2 TYR A 362      11.573  51.057  24.621  1.00 49.97           C  
ATOM   3037  CE1 TYR A 362      12.946  48.732  23.965  1.00 49.41           C  
ATOM   3038  CE2 TYR A 362      12.524  51.077  23.630  1.00 51.26           C  
ATOM   3039  CZ  TYR A 362      13.199  49.918  23.299  1.00 51.29           C  
ATOM   3040  OH  TYR A 362      14.119  49.997  22.282  1.00 52.85           O  
ATOM   3041  N   LYS A 363       8.692  51.682  28.192  1.00 50.72           N  
ATOM   3042  CA  LYS A 363       7.829  52.336  29.180  1.00 52.37           C  
ATOM   3043  C   LYS A 363       6.390  51.848  29.359  1.00 53.13           C  
ATOM   3044  O   LYS A 363       5.855  51.857  30.488  1.00 53.82           O  
ATOM   3045  CB  LYS A 363       7.837  53.858  29.036  1.00 52.64           C  
ATOM   3046  CG  LYS A 363       7.373  54.569  30.313  1.00 53.56           C  
ATOM   3047  CD  LYS A 363       6.937  55.982  30.059  1.00 54.28           C  
ATOM   3048  CE  LYS A 363       6.929  56.756  31.358  1.00 55.82           C  
ATOM   3049  NZ  LYS A 363       6.660  58.216  31.100  1.00 57.28           N  
ATOM   3050  N   LYS A 364       5.735  51.473  28.273  1.00 53.53           N  
ATOM   3051  CA  LYS A 364       4.357  51.035  28.425  1.00 53.72           C  
ATOM   3052  C   LYS A 364       4.277  49.538  28.163  1.00 53.82           C  
ATOM   3053  O   LYS A 364       3.546  49.113  27.260  1.00 54.91           O  
ATOM   3054  CB  LYS A 364       3.410  51.774  27.468  1.00 53.39           C  
ATOM   3055  CG  LYS A 364       3.406  53.311  27.484  1.00 53.46           C  
ATOM   3056  CD  LYS A 364       2.719  53.759  26.155  1.00 53.99           C  
ATOM   3057  CE  LYS A 364       3.210  55.084  25.596  1.00 52.85           C  
ATOM   3058  NZ  LYS A 364       2.309  56.242  25.963  1.00 51.15           N  
ATOM   3059  N   LEU A 365       5.034  48.729  28.895  1.00 52.58           N  
ATOM   3060  CA  LEU A 365       4.903  47.303  28.707  1.00 51.84           C  
ATOM   3061  C   LEU A 365       5.087  46.619  30.053  1.00 52.20           C  
ATOM   3062  O   LEU A 365       6.004  45.813  30.252  1.00 52.16           O  
ATOM   3063  CB  LEU A 365       5.891  46.775  27.672  1.00 51.39           C  
ATOM   3064  CG  LEU A 365       6.026  47.417  26.282  1.00 51.04           C  
ATOM   3065  CD1 LEU A 365       7.466  47.336  25.843  1.00 50.69           C  
ATOM   3066  CD2 LEU A 365       5.125  46.822  25.193  1.00 50.05           C  
ATOM   3067  N   GLU A 366       4.199  46.957  30.985  1.00 51.90           N  
ATOM   3068  CA  GLU A 366       4.147  46.290  32.270  1.00 51.26           C  
ATOM   3069  C   GLU A 366       3.094  45.200  32.303  1.00 50.85           C  
ATOM   3070  O   GLU A 366       3.031  44.454  33.268  1.00 50.68           O  
ATOM   3071  CB  GLU A 366       3.890  47.300  33.392  1.00 51.75           C  
ATOM   3072  CG  GLU A 366       5.046  48.225  33.701  1.00 52.92           C  
ATOM   3073  CD  GLU A 366       6.369  47.556  33.430  1.00 56.48           C  
ATOM   3074  OE1 GLU A 366       6.877  46.831  34.324  1.00 55.77           O  
ATOM   3075  OE2 GLU A 366       6.882  47.755  32.300  1.00 58.65           O  
ATOM   3076  N   TRP A 367       2.285  45.093  31.253  1.00 50.70           N  
ATOM   3077  CA  TRP A 367       1.155  44.180  31.273  1.00 51.29           C  
ATOM   3078  C   TRP A 367       1.446  42.777  31.744  1.00 51.85           C  
ATOM   3079  O   TRP A 367       0.757  42.290  32.635  1.00 52.60           O  
ATOM   3080  CB  TRP A 367       0.346  44.166  29.982  1.00 51.54           C  
ATOM   3081  CG  TRP A 367       0.992  43.553  28.827  1.00 51.80           C  
ATOM   3082  CD1 TRP A 367       1.849  44.159  27.954  1.00 52.31           C  
ATOM   3083  CD2 TRP A 367       0.815  42.219  28.355  1.00 52.37           C  
ATOM   3084  NE1 TRP A 367       2.240  43.282  26.978  1.00 52.13           N  
ATOM   3085  CE2 TRP A 367       1.623  42.079  27.190  1.00 53.28           C  
ATOM   3086  CE3 TRP A 367       0.067  41.122  28.800  1.00 51.92           C  
ATOM   3087  CZ2 TRP A 367       1.703  40.873  26.456  1.00 52.86           C  
ATOM   3088  CZ3 TRP A 367       0.143  39.912  28.067  1.00 51.98           C  
ATOM   3089  CH2 TRP A 367       0.956  39.807  26.905  1.00 52.40           C  
ATOM   3090  N   ARG A 368       2.457  42.105  31.219  1.00 52.38           N  
ATOM   3091  CA  ARG A 368       2.625  40.717  31.667  1.00 52.86           C  
ATOM   3092  C   ARG A 368       2.827  40.717  33.184  1.00 53.64           C  
ATOM   3093  O   ARG A 368       2.372  39.822  33.891  1.00 54.44           O  
ATOM   3094  CB  ARG A 368       3.753  39.988  30.939  1.00 52.74           C  
ATOM   3095  CG  ARG A 368       3.499  39.740  29.453  1.00 51.66           C  
ATOM   3096  CD  ARG A 368       4.312  38.596  28.948  1.00 51.53           C  
ATOM   3097  NE  ARG A 368       3.965  38.282  27.575  1.00 55.05           N  
ATOM   3098  CZ  ARG A 368       4.622  38.762  26.520  1.00 59.80           C  
ATOM   3099  NH1 ARG A 368       5.662  39.578  26.691  1.00 62.83           N  
ATOM   3100  NH2 ARG A 368       4.246  38.441  25.286  1.00 59.79           N  
ATOM   3101  N   LYS A 369       3.457  41.770  33.679  1.00 53.79           N  
ATOM   3102  CA  LYS A 369       3.814  41.849  35.065  1.00 53.71           C  
ATOM   3103  C   LYS A 369       2.635  42.421  35.856  1.00 54.38           C  
ATOM   3104  O   LYS A 369       2.428  42.106  37.034  1.00 54.95           O  
ATOM   3105  CB  LYS A 369       5.068  42.717  35.216  1.00 53.78           C  
ATOM   3106  CG  LYS A 369       6.130  42.572  34.084  1.00 53.61           C  
ATOM   3107  CD  LYS A 369       7.414  43.334  34.443  1.00 53.17           C  
ATOM   3108  CE  LYS A 369       8.243  43.749  33.250  1.00 51.02           C  
ATOM   3109  NZ  LYS A 369       8.675  45.183  33.393  1.00 51.80           N  
ATOM   3110  N   GLU A 370       1.845  43.271  35.229  1.00 54.51           N  
ATOM   3111  CA  GLU A 370       0.658  43.731  35.917  1.00 54.75           C  
ATOM   3112  C   GLU A 370      -0.329  42.565  36.084  1.00 55.02           C  
ATOM   3113  O   GLU A 370      -0.818  42.301  37.179  1.00 54.26           O  
ATOM   3114  CB  GLU A 370       0.032  44.922  35.207  1.00 54.06           C  
ATOM   3115  CG  GLU A 370      -1.193  45.427  35.905  1.00 55.69           C  
ATOM   3116  CD  GLU A 370      -0.894  46.078  37.234  1.00 57.66           C  
ATOM   3117  OE1 GLU A 370       0.059  45.630  37.889  1.00 58.74           O  
ATOM   3118  OE2 GLU A 370      -1.610  47.043  37.628  1.00 60.39           O  
ATOM   3119  N   GLU A 371      -0.587  41.845  34.998  1.00 55.85           N  
ATOM   3120  CA  GLU A 371      -1.466  40.680  35.060  1.00 57.12           C  
ATOM   3121  C   GLU A 371      -1.024  39.661  36.103  1.00 57.04           C  
ATOM   3122  O   GLU A 371      -1.792  39.351  36.996  1.00 57.53           O  
ATOM   3123  CB  GLU A 371      -1.642  40.030  33.695  1.00 57.33           C  
ATOM   3124  CG  GLU A 371      -2.489  40.887  32.779  1.00 60.47           C  
ATOM   3125  CD  GLU A 371      -2.533  40.372  31.347  1.00 64.45           C  
ATOM   3126  OE1 GLU A 371      -2.140  39.179  31.136  1.00 64.36           O  
ATOM   3127  OE2 GLU A 371      -2.965  41.172  30.452  1.00 64.32           O  
ATOM   3128  N   PHE A 372       0.201  39.162  36.017  1.00 56.85           N  
ATOM   3129  CA  PHE A 372       0.712  38.303  37.078  1.00 57.15           C  
ATOM   3130  C   PHE A 372       0.426  38.847  38.486  1.00 57.33           C  
ATOM   3131  O   PHE A 372      -0.409  38.316  39.221  1.00 56.77           O  
ATOM   3132  CB  PHE A 372       2.205  38.059  36.910  1.00 56.96           C  
ATOM   3133  CG  PHE A 372       2.754  37.062  37.875  1.00 56.69           C  
ATOM   3134  CD1 PHE A 372       2.643  35.696  37.614  1.00 55.42           C  
ATOM   3135  CD2 PHE A 372       3.374  37.486  39.062  1.00 57.66           C  
ATOM   3136  CE1 PHE A 372       3.166  34.753  38.498  1.00 56.66           C  
ATOM   3137  CE2 PHE A 372       3.890  36.556  39.986  1.00 57.53           C  
ATOM   3138  CZ  PHE A 372       3.788  35.178  39.701  1.00 58.11           C  
ATOM   3139  N   LEU A 373       1.122  39.911  38.850  1.00 58.14           N  
ATOM   3140  CA  LEU A 373       0.893  40.572  40.114  1.00 59.33           C  
ATOM   3141  C   LEU A 373      -0.582  40.552  40.501  1.00 60.50           C  
ATOM   3142  O   LEU A 373      -0.923  40.151  41.586  1.00 60.33           O  
ATOM   3143  CB  LEU A 373       1.399  42.001  40.046  1.00 59.08           C  
ATOM   3144  CG  LEU A 373       1.607  42.671  41.391  1.00 58.90           C  
ATOM   3145  CD1 LEU A 373       2.747  41.996  42.108  1.00 59.09           C  
ATOM   3146  CD2 LEU A 373       1.910  44.117  41.161  1.00 58.75           C  
ATOM   3147  N   LYS A 374      -1.453  40.976  39.588  1.00 62.83           N  
ATOM   3148  CA  LYS A 374      -2.896  40.866  39.792  1.00 64.61           C  
ATOM   3149  C   LYS A 374      -3.345  39.464  40.187  1.00 65.75           C  
ATOM   3150  O   LYS A 374      -3.794  39.275  41.324  1.00 66.74           O  
ATOM   3151  CB  LYS A 374      -3.691  41.390  38.603  1.00 64.04           C  
ATOM   3152  CG  LYS A 374      -4.499  42.589  39.014  1.00 66.58           C  
ATOM   3153  CD  LYS A 374      -4.388  43.730  38.020  1.00 71.02           C  
ATOM   3154  CE  LYS A 374      -4.345  45.097  38.735  1.00 72.42           C  
ATOM   3155  NZ  LYS A 374      -4.642  46.218  37.761  1.00 73.98           N  
ATOM   3156  N   GLU A 375      -3.196  38.487  39.287  1.00 66.45           N  
ATOM   3157  CA  GLU A 375      -3.781  37.153  39.483  1.00 67.08           C  
ATOM   3158  C   GLU A 375      -3.229  36.440  40.739  1.00 67.12           C  
ATOM   3159  O   GLU A 375      -3.544  35.272  41.025  1.00 67.69           O  
ATOM   3160  CB  GLU A 375      -3.633  36.304  38.205  1.00 67.21           C  
ATOM   3161  CG  GLU A 375      -4.652  35.142  38.059  1.00 69.36           C  
ATOM   3162  CD  GLU A 375      -6.068  35.557  37.579  1.00 71.78           C  
ATOM   3163  OE1 GLU A 375      -6.519  36.707  37.823  1.00 72.76           O  
ATOM   3164  OE2 GLU A 375      -6.750  34.700  36.967  1.00 72.39           O  
ATOM   3165  N   LEU A 376      -2.461  37.185  41.516  1.00 66.63           N  
ATOM   3166  CA  LEU A 376      -1.642  36.614  42.543  1.00 66.64           C  
ATOM   3167  C   LEU A 376      -1.966  37.259  43.869  1.00 66.69           C  
ATOM   3168  O   LEU A 376      -1.995  36.587  44.903  1.00 67.31           O  
ATOM   3169  CB  LEU A 376      -0.217  36.865  42.140  1.00 66.93           C  
ATOM   3170  CG  LEU A 376       0.867  37.156  43.128  1.00 67.86           C  
ATOM   3171  CD1 LEU A 376       1.759  35.929  43.194  1.00 70.01           C  
ATOM   3172  CD2 LEU A 376       1.602  38.321  42.528  1.00 69.57           C  
ATOM   3173  N   ILE A 377      -2.212  38.564  43.842  1.00 66.28           N  
ATOM   3174  CA  ILE A 377      -2.942  39.213  44.909  1.00 65.67           C  
ATOM   3175  C   ILE A 377      -4.195  38.369  45.127  1.00 65.61           C  
ATOM   3176  O   ILE A 377      -4.508  37.980  46.256  1.00 65.89           O  
ATOM   3177  CB  ILE A 377      -3.364  40.630  44.520  1.00 65.55           C  
ATOM   3178  CG1 ILE A 377      -2.160  41.574  44.499  1.00 64.84           C  
ATOM   3179  CG2 ILE A 377      -4.477  41.150  45.469  1.00 66.06           C  
ATOM   3180  CD1 ILE A 377      -2.518  42.956  43.853  1.00 65.77           C  
ATOM   3181  N   ASN A 378      -4.881  38.083  44.022  1.00 65.22           N  
ATOM   3182  CA  ASN A 378      -6.086  37.278  43.985  1.00 65.29           C  
ATOM   3183  C   ASN A 378      -5.949  36.024  44.834  1.00 65.57           C  
ATOM   3184  O   ASN A 378      -6.542  35.886  45.904  1.00 65.42           O  
ATOM   3185  CB  ASN A 378      -6.333  36.874  42.536  1.00 65.26           C  
ATOM   3186  CG  ASN A 378      -7.795  36.672  42.214  1.00 65.74           C  
ATOM   3187  OD1 ASN A 378      -8.570  36.276  43.065  1.00 66.08           O  
ATOM   3188  ND2 ASN A 378      -8.180  36.956  40.962  1.00 67.37           N  
ATOM   3189  N   PHE A 379      -5.140  35.114  44.321  1.00 65.99           N  
ATOM   3190  CA  PHE A 379      -4.823  33.846  44.939  1.00 66.41           C  
ATOM   3191  C   PHE A 379      -4.476  33.958  46.435  1.00 66.29           C  
ATOM   3192  O   PHE A 379      -5.049  33.247  47.256  1.00 66.46           O  
ATOM   3193  CB  PHE A 379      -3.663  33.272  44.137  1.00 66.87           C  
ATOM   3194  CG  PHE A 379      -3.255  31.892  44.523  1.00 66.98           C  
ATOM   3195  CD1 PHE A 379      -3.856  30.795  43.929  1.00 67.42           C  
ATOM   3196  CD2 PHE A 379      -2.213  31.695  45.422  1.00 66.70           C  
ATOM   3197  CE1 PHE A 379      -3.450  29.510  44.252  1.00 68.38           C  
ATOM   3198  CE2 PHE A 379      -1.788  30.415  45.765  1.00 67.18           C  
ATOM   3199  CZ  PHE A 379      -2.405  29.315  45.179  1.00 68.09           C  
ATOM   3200  N   LEU A 380      -3.549  34.850  46.775  1.00 66.02           N  
ATOM   3201  CA  LEU A 380      -3.156  35.092  48.163  1.00 65.96           C  
ATOM   3202  C   LEU A 380      -4.294  35.570  49.076  1.00 65.86           C  
ATOM   3203  O   LEU A 380      -4.271  35.346  50.289  1.00 65.54           O  
ATOM   3204  CB  LEU A 380      -2.045  36.135  48.190  1.00 66.02           C  
ATOM   3205  CG  LEU A 380      -0.662  35.660  47.767  1.00 67.04           C  
ATOM   3206  CD1 LEU A 380       0.256  36.845  47.721  1.00 67.84           C  
ATOM   3207  CD2 LEU A 380      -0.112  34.639  48.730  1.00 67.47           C  
ATOM   3208  N   LYS A 381      -5.251  36.282  48.490  1.00 65.74           N  
ATOM   3209  CA  LYS A 381      -6.417  36.755  49.199  1.00 65.40           C  
ATOM   3210  C   LYS A 381      -7.340  35.597  49.500  1.00 64.69           C  
ATOM   3211  O   LYS A 381      -7.803  35.436  50.620  1.00 64.94           O  
ATOM   3212  CB  LYS A 381      -7.157  37.766  48.353  1.00 65.91           C  
ATOM   3213  CG  LYS A 381      -6.568  39.155  48.401  1.00 68.56           C  
ATOM   3214  CD  LYS A 381      -7.623  40.190  47.940  1.00 71.31           C  
ATOM   3215  CE  LYS A 381      -7.290  41.583  48.459  1.00 72.47           C  
ATOM   3216  NZ  LYS A 381      -7.199  42.518  47.305  1.00 73.89           N  
ATOM   3217  N   ASN A 382      -7.612  34.787  48.493  1.00 63.73           N  
ATOM   3218  CA  ASN A 382      -8.316  33.542  48.711  1.00 62.95           C  
ATOM   3219  C   ASN A 382      -7.640  32.624  49.697  1.00 61.81           C  
ATOM   3220  O   ASN A 382      -8.090  31.517  49.923  1.00 61.68           O  
ATOM   3221  CB  ASN A 382      -8.489  32.801  47.397  1.00 63.55           C  
ATOM   3222  CG  ASN A 382      -9.545  33.414  46.549  1.00 64.49           C  
ATOM   3223  OD1 ASN A 382     -10.045  34.505  46.851  1.00 64.35           O  
ATOM   3224  ND2 ASN A 382      -9.900  32.731  45.472  1.00 66.33           N  
ATOM   3225  N   LYS A 383      -6.553  33.064  50.283  1.00 60.84           N  
ATOM   3226  CA  LYS A 383      -5.982  32.271  51.331  1.00 60.89           C  
ATOM   3227  C   LYS A 383      -5.769  33.076  52.580  1.00 61.28           C  
ATOM   3228  O   LYS A 383      -5.011  32.684  53.448  1.00 61.34           O  
ATOM   3229  CB  LYS A 383      -4.722  31.575  50.857  1.00 60.79           C  
ATOM   3230  CG  LYS A 383      -5.078  30.388  49.997  1.00 61.03           C  
ATOM   3231  CD  LYS A 383      -4.046  30.047  48.975  1.00 60.05           C  
ATOM   3232  CE  LYS A 383      -4.499  28.773  48.322  1.00 61.03           C  
ATOM   3233  NZ  LYS A 383      -3.345  27.848  48.053  1.00 61.45           N  
ATOM   3234  N   GLY A 384      -6.475  34.200  52.663  1.00 61.78           N  
ATOM   3235  CA  GLY A 384      -6.532  35.011  53.867  1.00 62.40           C  
ATOM   3236  C   GLY A 384      -5.412  36.014  53.957  1.00 63.08           C  
ATOM   3237  O   GLY A 384      -5.075  36.491  55.049  1.00 63.18           O  
ATOM   3238  N   ILE A 385      -4.825  36.339  52.810  1.00 63.76           N  
ATOM   3239  CA  ILE A 385      -3.725  37.282  52.807  1.00 64.37           C  
ATOM   3240  C   ILE A 385      -3.863  38.405  51.786  1.00 64.88           C  
ATOM   3241  O   ILE A 385      -3.987  38.188  50.566  1.00 65.42           O  
ATOM   3242  CB  ILE A 385      -2.383  36.560  52.674  1.00 64.64           C  
ATOM   3243  CG1 ILE A 385      -2.386  35.288  53.543  1.00 63.43           C  
ATOM   3244  CG2 ILE A 385      -1.231  37.525  53.022  1.00 65.35           C  
ATOM   3245  CD1 ILE A 385      -1.045  34.874  54.049  1.00 62.40           C  
ATOM   3246  N   LYS A 386      -3.865  39.619  52.322  1.00 65.05           N  
ATOM   3247  CA  LYS A 386      -3.896  40.832  51.529  1.00 64.98           C  
ATOM   3248  C   LYS A 386      -2.479  41.356  51.425  1.00 64.87           C  
ATOM   3249  O   LYS A 386      -1.809  41.566  52.456  1.00 64.98           O  
ATOM   3250  CB  LYS A 386      -4.711  41.899  52.252  1.00 65.11           C  
ATOM   3251  CG  LYS A 386      -6.198  41.798  52.119  1.00 66.04           C  
ATOM   3252  CD  LYS A 386      -6.837  42.969  52.869  1.00 67.07           C  
ATOM   3253  CE  LYS A 386      -8.338  42.974  52.679  1.00 67.41           C  
ATOM   3254  NZ  LYS A 386      -9.010  43.505  53.888  1.00 68.53           N  
ATOM   3255  N   LEU A 387      -2.019  41.589  50.202  1.00 64.47           N  
ATOM   3256  CA  LEU A 387      -0.815  42.394  50.010  1.00 64.23           C  
ATOM   3257  C   LEU A 387      -1.211  43.838  49.861  1.00 64.15           C  
ATOM   3258  O   LEU A 387      -1.902  44.179  48.908  1.00 64.70           O  
ATOM   3259  CB  LEU A 387      -0.085  41.990  48.748  1.00 64.02           C  
ATOM   3260  CG  LEU A 387       0.066  40.498  48.564  1.00 64.16           C  
ATOM   3261  CD1 LEU A 387       0.111  40.240  47.109  1.00 64.38           C  
ATOM   3262  CD2 LEU A 387       1.313  40.000  49.278  1.00 63.69           C  
ATOM   3263  N   LYS A 388      -0.808  44.681  50.804  1.00 64.04           N  
ATOM   3264  CA  LYS A 388      -0.836  46.113  50.574  1.00 64.09           C  
ATOM   3265  C   LYS A 388       0.439  46.471  49.822  1.00 63.91           C  
ATOM   3266  O   LYS A 388       1.551  46.164  50.274  1.00 64.21           O  
ATOM   3267  CB  LYS A 388      -0.918  46.872  51.881  1.00 64.38           C  
ATOM   3268  CG  LYS A 388      -2.110  46.462  52.762  1.00 66.36           C  
ATOM   3269  CD  LYS A 388      -3.470  46.510  52.016  1.00 67.98           C  
ATOM   3270  CE  LYS A 388      -4.644  46.296  52.972  1.00 66.31           C  
ATOM   3271  NZ  LYS A 388      -4.709  47.418  53.939  1.00 65.95           N  
ATOM   3272  N   ILE A 389       0.280  47.057  48.638  1.00 63.05           N  
ATOM   3273  CA  ILE A 389       1.420  47.575  47.920  1.00 61.61           C  
ATOM   3274  C   ILE A 389       1.749  48.904  48.558  1.00 61.22           C  
ATOM   3275  O   ILE A 389       0.980  49.839  48.469  1.00 60.68           O  
ATOM   3276  CB  ILE A 389       1.116  47.802  46.459  1.00 61.53           C  
ATOM   3277  CG1 ILE A 389       0.895  46.463  45.770  1.00 60.86           C  
ATOM   3278  CG2 ILE A 389       2.247  48.589  45.805  1.00 60.64           C  
ATOM   3279  CD1 ILE A 389       0.490  46.597  44.322  1.00 63.16           C  
ATOM   3280  N   LYS A 390       2.887  48.948  49.238  1.00 60.86           N  
ATOM   3281  CA  LYS A 390       3.410  50.166  49.806  1.00 60.20           C  
ATOM   3282  C   LYS A 390       3.906  51.129  48.735  1.00 58.93           C  
ATOM   3283  O   LYS A 390       4.014  52.300  49.032  1.00 59.19           O  
ATOM   3284  CB  LYS A 390       4.552  49.851  50.771  1.00 60.76           C  
ATOM   3285  CG  LYS A 390       4.112  49.425  52.174  1.00 63.32           C  
ATOM   3286  CD  LYS A 390       5.165  49.790  53.262  1.00 63.48           C  
ATOM   3287  CE  LYS A 390       4.573  49.627  54.668  1.00 65.60           C  
ATOM   3288  NZ  LYS A 390       5.471  50.023  55.823  1.00 66.88           N  
ATOM   3289  N   GLY A 391       4.210  50.652  47.518  1.00 57.31           N  
ATOM   3290  CA  GLY A 391       4.748  51.499  46.443  1.00 55.70           C  
ATOM   3291  C   GLY A 391       5.485  50.735  45.359  1.00 55.05           C  
ATOM   3292  O   GLY A 391       6.108  49.725  45.656  1.00 55.83           O  
ATOM   3293  N   LYS A 392       5.387  51.193  44.098  1.00 53.88           N  
ATOM   3294  CA  LYS A 392       6.135  50.641  42.923  1.00 52.51           C  
ATOM   3295  C   LYS A 392       7.351  51.539  42.616  1.00 51.31           C  
ATOM   3296  O   LYS A 392       7.429  52.659  43.079  1.00 51.08           O  
ATOM   3297  CB  LYS A 392       5.212  50.533  41.668  1.00 52.61           C  
ATOM   3298  CG  LYS A 392       5.695  49.630  40.421  1.00 53.39           C  
ATOM   3299  CD  LYS A 392       4.614  49.558  39.236  1.00 52.63           C  
ATOM   3300  CE  LYS A 392       4.969  48.681  37.959  1.00 53.41           C  
ATOM   3301  NZ  LYS A 392       4.645  47.144  37.925  1.00 51.83           N  
ATOM   3302  N   SER A 393       8.316  51.029  41.861  1.00 50.36           N  
ATOM   3303  CA  SER A 393       9.382  51.843  41.268  1.00 48.53           C  
ATOM   3304  C   SER A 393       9.685  51.208  39.961  1.00 47.78           C  
ATOM   3305  O   SER A 393      10.142  50.071  39.916  1.00 48.06           O  
ATOM   3306  CB  SER A 393      10.661  51.819  42.096  1.00 48.24           C  
ATOM   3307  OG  SER A 393      10.392  52.113  43.445  1.00 47.47           O  
ATOM   3308  N   LEU A 394       9.429  51.928  38.893  1.00 47.13           N  
ATOM   3309  CA  LEU A 394       9.797  51.458  37.557  1.00 47.18           C  
ATOM   3310  C   LEU A 394      11.168  52.030  37.095  1.00 46.62           C  
ATOM   3311  O   LEU A 394      11.273  53.212  36.772  1.00 47.03           O  
ATOM   3312  CB  LEU A 394       8.673  51.811  36.571  1.00 47.09           C  
ATOM   3313  CG  LEU A 394       9.024  51.908  35.094  1.00 47.29           C  
ATOM   3314  CD1 LEU A 394       8.834  50.549  34.366  1.00 47.14           C  
ATOM   3315  CD2 LEU A 394       8.218  53.035  34.463  1.00 47.04           C  
ATOM   3316  N   ILE A 395      12.203  51.205  37.088  1.00 45.65           N  
ATOM   3317  CA  ILE A 395      13.493  51.630  36.584  1.00 45.59           C  
ATOM   3318  C   ILE A 395      13.620  51.293  35.091  1.00 46.14           C  
ATOM   3319  O   ILE A 395      13.500  50.104  34.714  1.00 45.94           O  
ATOM   3320  CB  ILE A 395      14.637  50.905  37.347  1.00 45.69           C  
ATOM   3321  CG1 ILE A 395      14.720  51.398  38.785  1.00 44.47           C  
ATOM   3322  CG2 ILE A 395      15.993  51.030  36.616  1.00 44.44           C  
ATOM   3323  CD1 ILE A 395      15.480  50.455  39.697  1.00 44.02           C  
ATOM   3324  N   LEU A 396      13.877  52.312  34.253  1.00 46.46           N  
ATOM   3325  CA  LEU A 396      14.258  52.081  32.819  1.00 46.79           C  
ATOM   3326  C   LEU A 396      15.781  51.940  32.679  1.00 47.39           C  
ATOM   3327  O   LEU A 396      16.518  52.701  33.279  1.00 48.01           O  
ATOM   3328  CB  LEU A 396      13.712  53.182  31.898  1.00 45.48           C  
ATOM   3329  CG  LEU A 396      12.239  53.559  32.080  1.00 44.02           C  
ATOM   3330  CD1 LEU A 396      11.800  54.626  31.106  1.00 43.61           C  
ATOM   3331  CD2 LEU A 396      11.298  52.383  31.966  1.00 43.36           C  
ATOM   3332  N   ALA A 397      16.265  50.972  31.921  1.00 48.22           N  
ATOM   3333  CA  ALA A 397      17.719  50.696  31.911  1.00 50.24           C  
ATOM   3334  C   ALA A 397      18.136  49.819  30.741  1.00 51.42           C  
ATOM   3335  O   ALA A 397      17.379  48.923  30.369  1.00 52.06           O  
ATOM   3336  CB  ALA A 397      18.145  50.023  33.234  1.00 50.15           C  
ATOM   3337  N   GLN A 398      19.332  50.017  30.179  1.00 52.84           N  
ATOM   3338  CA  GLN A 398      19.649  49.348  28.887  1.00 54.44           C  
ATOM   3339  C   GLN A 398      20.720  48.266  28.818  1.00 55.99           C  
ATOM   3340  O   GLN A 398      20.771  47.501  27.851  1.00 56.19           O  
ATOM   3341  CB  GLN A 398      19.851  50.368  27.794  1.00 53.94           C  
ATOM   3342  CG  GLN A 398      18.531  50.870  27.298  1.00 53.84           C  
ATOM   3343  CD  GLN A 398      18.649  52.189  26.631  1.00 53.98           C  
ATOM   3344  OE1 GLN A 398      19.478  52.386  25.739  1.00 53.37           O  
ATOM   3345  NE2 GLN A 398      17.819  53.122  27.056  1.00 56.55           N  
ATOM   3346  N   THR A 399      21.514  48.174  29.881  1.00 57.94           N  
ATOM   3347  CA  THR A 399      22.561  47.180  30.071  1.00 59.14           C  
ATOM   3348  C   THR A 399      22.233  46.567  31.415  1.00 60.18           C  
ATOM   3349  O   THR A 399      21.413  47.141  32.115  1.00 60.63           O  
ATOM   3350  CB  THR A 399      23.883  47.922  30.286  1.00 59.30           C  
ATOM   3351  OG1 THR A 399      23.815  49.248  29.720  1.00 58.35           O  
ATOM   3352  CG2 THR A 399      25.041  47.127  29.722  1.00 60.00           C  
ATOM   3353  N   ARG A 400      22.868  45.461  31.825  1.00 61.46           N  
ATOM   3354  CA  ARG A 400      22.785  45.039  33.250  1.00 62.74           C  
ATOM   3355  C   ARG A 400      23.480  46.068  34.120  1.00 63.37           C  
ATOM   3356  O   ARG A 400      23.061  46.338  35.242  1.00 63.93           O  
ATOM   3357  CB  ARG A 400      23.445  43.700  33.518  1.00 62.60           C  
ATOM   3358  CG  ARG A 400      23.181  42.661  32.478  1.00 65.58           C  
ATOM   3359  CD  ARG A 400      23.570  41.323  33.006  1.00 70.47           C  
ATOM   3360  NE  ARG A 400      24.006  40.391  31.967  1.00 73.00           N  
ATOM   3361  CZ  ARG A 400      24.370  39.129  32.225  1.00 75.64           C  
ATOM   3362  NH1 ARG A 400      24.346  38.660  33.481  1.00 75.36           N  
ATOM   3363  NH2 ARG A 400      24.760  38.328  31.237  1.00 76.74           N  
ATOM   3364  N   GLU A 401      24.552  46.633  33.576  1.00 63.99           N  
ATOM   3365  CA  GLU A 401      25.344  47.653  34.224  1.00 64.59           C  
ATOM   3366  C   GLU A 401      24.504  48.871  34.578  1.00 63.86           C  
ATOM   3367  O   GLU A 401      24.533  49.305  35.728  1.00 63.84           O  
ATOM   3368  CB  GLU A 401      26.553  48.013  33.348  1.00 65.34           C  
ATOM   3369  CG  GLU A 401      27.546  46.826  33.160  1.00 69.90           C  
ATOM   3370  CD  GLU A 401      28.027  46.608  31.686  1.00 75.21           C  
ATOM   3371  OE1 GLU A 401      27.804  47.504  30.818  1.00 74.78           O  
ATOM   3372  OE2 GLU A 401      28.637  45.524  31.413  1.00 76.55           O  
ATOM   3373  N   GLU A 402      23.745  49.408  33.617  1.00 63.39           N  
ATOM   3374  CA  GLU A 402      22.922  50.603  33.878  1.00 63.10           C  
ATOM   3375  C   GLU A 402      21.895  50.328  34.979  1.00 63.16           C  
ATOM   3376  O   GLU A 402      21.691  51.158  35.886  1.00 63.20           O  
ATOM   3377  CB  GLU A 402      22.198  51.092  32.624  1.00 62.87           C  
ATOM   3378  CG  GLU A 402      21.281  52.310  32.904  1.00 62.77           C  
ATOM   3379  CD  GLU A 402      20.621  52.935  31.657  1.00 63.19           C  
ATOM   3380  OE1 GLU A 402      20.735  52.384  30.540  1.00 64.91           O  
ATOM   3381  OE2 GLU A 402      19.971  53.994  31.791  1.00 62.73           O  
ATOM   3382  N   ALA A 403      21.263  49.154  34.870  1.00 62.81           N  
ATOM   3383  CA  ALA A 403      20.250  48.674  35.787  1.00 61.95           C  
ATOM   3384  C   ALA A 403      20.823  48.627  37.174  1.00 62.08           C  
ATOM   3385  O   ALA A 403      20.326  49.342  38.054  1.00 62.39           O  
ATOM   3386  CB  ALA A 403      19.797  47.314  35.375  1.00 61.89           C  
ATOM   3387  N   LYS A 404      21.879  47.815  37.354  1.00 61.80           N  
ATOM   3388  CA  LYS A 404      22.547  47.636  38.649  1.00 61.96           C  
ATOM   3389  C   LYS A 404      22.664  48.982  39.303  1.00 61.32           C  
ATOM   3390  O   LYS A 404      22.188  49.184  40.422  1.00 61.59           O  
ATOM   3391  CB  LYS A 404      23.937  47.000  38.497  1.00 61.78           C  
ATOM   3392  CG  LYS A 404      25.166  47.903  38.836  1.00 63.35           C  
ATOM   3393  CD  LYS A 404      26.550  47.147  38.652  1.00 64.30           C  
ATOM   3394  CE  LYS A 404      27.532  47.883  37.636  1.00 65.59           C  
ATOM   3395  NZ  LYS A 404      28.199  46.960  36.596  1.00 63.20           N  
ATOM   3396  N   GLU A 405      23.245  49.912  38.550  1.00 60.55           N  
ATOM   3397  CA  GLU A 405      23.498  51.258  39.002  1.00 59.63           C  
ATOM   3398  C   GLU A 405      22.263  51.969  39.536  1.00 58.75           C  
ATOM   3399  O   GLU A 405      22.332  52.615  40.591  1.00 58.91           O  
ATOM   3400  CB  GLU A 405      24.064  52.084  37.862  1.00 60.14           C  
ATOM   3401  CG  GLU A 405      25.178  51.458  37.065  1.00 60.53           C  
ATOM   3402  CD  GLU A 405      25.523  52.315  35.861  1.00 61.50           C  
ATOM   3403  OE1 GLU A 405      25.098  53.507  35.828  1.00 60.11           O  
ATOM   3404  OE2 GLU A 405      26.207  51.793  34.945  1.00 62.28           O  
ATOM   3405  N   LYS A 406      21.151  51.896  38.804  1.00 57.31           N  
ATOM   3406  CA  LYS A 406      19.944  52.584  39.257  1.00 56.31           C  
ATOM   3407  C   LYS A 406      19.268  51.790  40.378  1.00 56.23           C  
ATOM   3408  O   LYS A 406      18.713  52.378  41.325  1.00 56.72           O  
ATOM   3409  CB  LYS A 406      18.978  52.848  38.122  1.00 55.54           C  
ATOM   3410  CG  LYS A 406      19.610  53.557  36.972  1.00 55.20           C  
ATOM   3411  CD  LYS A 406      18.548  53.962  35.999  1.00 55.14           C  
ATOM   3412  CE  LYS A 406      19.139  54.660  34.809  1.00 55.47           C  
ATOM   3413  NZ  LYS A 406      18.078  55.298  33.986  1.00 55.47           N  
ATOM   3414  N   LEU A 407      19.346  50.461  40.301  1.00 54.62           N  
ATOM   3415  CA  LEU A 407      18.771  49.651  41.331  1.00 53.47           C  
ATOM   3416  C   LEU A 407      19.282  50.040  42.720  1.00 53.44           C  
ATOM   3417  O   LEU A 407      18.526  49.940  43.683  1.00 53.70           O  
ATOM   3418  CB  LEU A 407      19.025  48.176  41.045  1.00 53.52           C  
ATOM   3419  CG  LEU A 407      18.029  47.455  40.137  1.00 51.66           C  
ATOM   3420  CD1 LEU A 407      18.672  46.229  39.587  1.00 48.54           C  
ATOM   3421  CD2 LEU A 407      16.752  47.099  40.867  1.00 49.49           C  
ATOM   3422  N   ILE A 408      20.538  50.498  42.816  1.00 53.23           N  
ATOM   3423  CA  ILE A 408      21.204  50.828  44.114  1.00 52.73           C  
ATOM   3424  C   ILE A 408      20.463  51.865  44.999  1.00 52.70           C  
ATOM   3425  O   ILE A 408      20.014  51.525  46.101  1.00 52.54           O  
ATOM   3426  CB  ILE A 408      22.712  51.199  43.940  1.00 52.51           C  
ATOM   3427  CG1 ILE A 408      23.544  49.946  43.725  1.00 51.75           C  
ATOM   3428  CG2 ILE A 408      23.258  51.912  45.161  1.00 51.61           C  
ATOM   3429  CD1 ILE A 408      24.640  50.139  42.707  1.00 51.89           C  
ATOM   3430  N   PRO A 409      20.295  53.110  44.516  1.00 52.35           N  
ATOM   3431  CA  PRO A 409      19.597  54.018  45.412  1.00 52.60           C  
ATOM   3432  C   PRO A 409      18.176  53.536  45.702  1.00 52.94           C  
ATOM   3433  O   PRO A 409      17.697  53.741  46.820  1.00 53.84           O  
ATOM   3434  CB  PRO A 409      19.558  55.333  44.646  1.00 51.90           C  
ATOM   3435  CG  PRO A 409      20.602  55.200  43.618  1.00 52.48           C  
ATOM   3436  CD  PRO A 409      20.629  53.762  43.245  1.00 52.37           C  
ATOM   3437  N   VAL A 410      17.527  52.881  44.733  1.00 52.46           N  
ATOM   3438  CA  VAL A 410      16.189  52.312  44.948  1.00 51.75           C  
ATOM   3439  C   VAL A 410      16.168  51.294  46.116  1.00 51.98           C  
ATOM   3440  O   VAL A 410      15.469  51.522  47.110  1.00 52.24           O  
ATOM   3441  CB  VAL A 410      15.557  51.742  43.641  1.00 51.42           C  
ATOM   3442  CG1 VAL A 410      14.294  50.955  43.929  1.00 50.08           C  
ATOM   3443  CG2 VAL A 410      15.242  52.858  42.669  1.00 50.53           C  
ATOM   3444  N   ILE A 411      16.933  50.210  46.017  1.00 51.78           N  
ATOM   3445  CA  ILE A 411      16.955  49.181  47.072  1.00 52.03           C  
ATOM   3446  C   ILE A 411      17.382  49.790  48.390  1.00 53.20           C  
ATOM   3447  O   ILE A 411      16.808  49.532  49.442  1.00 53.18           O  
ATOM   3448  CB  ILE A 411      17.941  48.051  46.749  1.00 51.46           C  
ATOM   3449  CG1 ILE A 411      17.410  47.181  45.628  1.00 50.81           C  
ATOM   3450  CG2 ILE A 411      18.188  47.205  47.950  1.00 49.81           C  
ATOM   3451  CD1 ILE A 411      18.433  46.260  45.092  1.00 51.22           C  
ATOM   3452  N   ASN A 412      18.417  50.605  48.312  1.00 54.80           N  
ATOM   3453  CA  ASN A 412      18.890  51.369  49.436  1.00 55.90           C  
ATOM   3454  C   ASN A 412      17.761  51.892  50.318  1.00 55.89           C  
ATOM   3455  O   ASN A 412      17.804  51.715  51.509  1.00 56.21           O  
ATOM   3456  CB  ASN A 412      19.685  52.562  48.909  1.00 56.63           C  
ATOM   3457  CG  ASN A 412      20.834  52.939  49.811  1.00 58.52           C  
ATOM   3458  OD1 ASN A 412      20.671  53.671  50.836  1.00 57.67           O  
ATOM   3459  ND2 ASN A 412      22.030  52.435  49.444  1.00 59.47           N  
ATOM   3460  N   LYS A 413      16.752  52.528  49.730  1.00 55.89           N  
ATOM   3461  CA  LYS A 413      15.768  53.277  50.508  1.00 56.04           C  
ATOM   3462  C   LYS A 413      14.640  52.451  51.123  1.00 55.66           C  
ATOM   3463  O   LYS A 413      13.924  52.918  52.008  1.00 55.64           O  
ATOM   3464  CB  LYS A 413      15.235  54.435  49.677  1.00 55.84           C  
ATOM   3465  CG  LYS A 413      16.359  55.343  49.303  1.00 57.80           C  
ATOM   3466  CD  LYS A 413      15.961  56.310  48.233  1.00 63.11           C  
ATOM   3467  CE  LYS A 413      17.190  56.906  47.539  1.00 64.56           C  
ATOM   3468  NZ  LYS A 413      16.782  58.104  46.716  1.00 67.28           N  
ATOM   3469  N   ILE A 414      14.516  51.215  50.683  1.00 55.44           N  
ATOM   3470  CA  ILE A 414      13.442  50.356  51.152  1.00 56.13           C  
ATOM   3471  C   ILE A 414      13.546  50.010  52.657  1.00 57.04           C  
ATOM   3472  O   ILE A 414      14.418  49.240  53.086  1.00 57.02           O  
ATOM   3473  CB  ILE A 414      13.322  49.066  50.280  1.00 55.81           C  
ATOM   3474  CG1 ILE A 414      13.345  49.434  48.797  1.00 54.78           C  
ATOM   3475  CG2 ILE A 414      12.043  48.302  50.613  1.00 55.16           C  
ATOM   3476  CD1 ILE A 414      13.423  48.277  47.863  1.00 52.87           C  
ATOM   3477  N   LYS A 415      12.652  50.599  53.448  1.00 57.72           N  
ATOM   3478  CA  LYS A 415      12.585  50.301  54.869  1.00 58.37           C  
ATOM   3479  C   LYS A 415      11.298  49.578  55.110  1.00 58.54           C  
ATOM   3480  O   LYS A 415      10.393  49.660  54.293  1.00 58.71           O  
ATOM   3481  CB  LYS A 415      12.574  51.577  55.683  1.00 58.13           C  
ATOM   3482  CG  LYS A 415      13.694  52.507  55.344  1.00 59.83           C  
ATOM   3483  CD  LYS A 415      13.438  53.882  55.960  1.00 64.81           C  
ATOM   3484  CE  LYS A 415      13.962  54.006  57.409  1.00 66.16           C  
ATOM   3485  NZ  LYS A 415      14.049  55.461  57.762  1.00 67.92           N  
ATOM   3486  N   ASP A 416      11.227  48.851  56.220  1.00 58.98           N  
ATOM   3487  CA  ASP A 416       9.963  48.353  56.750  1.00 58.84           C  
ATOM   3488  C   ASP A 416       9.025  47.742  55.709  1.00 57.79           C  
ATOM   3489  O   ASP A 416       7.962  48.318  55.397  1.00 57.83           O  
ATOM   3490  CB  ASP A 416       9.241  49.491  57.495  1.00 59.30           C  
ATOM   3491  CG  ASP A 416       9.851  49.770  58.848  1.00 61.98           C  
ATOM   3492  OD1 ASP A 416      10.698  48.963  59.310  1.00 64.69           O  
ATOM   3493  OD2 ASP A 416       9.474  50.793  59.463  1.00 65.75           O  
ATOM   3494  N   VAL A 417       9.400  46.598  55.154  1.00 55.81           N  
ATOM   3495  CA  VAL A 417       8.429  45.879  54.362  1.00 54.64           C  
ATOM   3496  C   VAL A 417       8.512  44.435  54.678  1.00 53.33           C  
ATOM   3497  O   VAL A 417       9.560  43.934  55.062  1.00 52.30           O  
ATOM   3498  CB  VAL A 417       8.583  46.046  52.797  1.00 55.05           C  
ATOM   3499  CG1 VAL A 417       8.361  47.458  52.339  1.00 55.23           C  
ATOM   3500  CG2 VAL A 417       9.928  45.555  52.299  1.00 56.70           C  
ATOM   3501  N   ASP A 418       7.401  43.752  54.468  1.00 52.80           N  
ATOM   3502  CA  ASP A 418       7.404  42.314  54.583  1.00 52.71           C  
ATOM   3503  C   ASP A 418       7.935  41.639  53.328  1.00 52.97           C  
ATOM   3504  O   ASP A 418       8.329  40.475  53.385  1.00 53.77           O  
ATOM   3505  CB  ASP A 418       6.014  41.789  54.909  1.00 52.62           C  
ATOM   3506  CG  ASP A 418       5.446  42.385  56.180  1.00 52.27           C  
ATOM   3507  OD1 ASP A 418       6.042  42.232  57.282  1.00 49.52           O  
ATOM   3508  OD2 ASP A 418       4.377  43.012  56.055  1.00 55.01           O  
ATOM   3509  N   LEU A 419       7.970  42.360  52.205  1.00 52.72           N  
ATOM   3510  CA  LEU A 419       8.399  41.764  50.944  1.00 52.13           C  
ATOM   3511  C   LEU A 419       8.798  42.786  49.884  1.00 52.84           C  
ATOM   3512  O   LEU A 419       8.272  43.913  49.853  1.00 53.59           O  
ATOM   3513  CB  LEU A 419       7.281  40.865  50.404  1.00 52.04           C  
ATOM   3514  CG  LEU A 419       7.473  39.949  49.194  1.00 50.76           C  
ATOM   3515  CD1 LEU A 419       8.577  38.902  49.389  1.00 47.25           C  
ATOM   3516  CD2 LEU A 419       6.139  39.310  48.864  1.00 50.39           C  
ATOM   3517  N   VAL A 420       9.717  42.380  49.006  1.00 52.52           N  
ATOM   3518  CA  VAL A 420      10.069  43.170  47.841  1.00 52.38           C  
ATOM   3519  C   VAL A 420       9.854  42.279  46.634  1.00 52.76           C  
ATOM   3520  O   VAL A 420      10.357  41.147  46.582  1.00 53.21           O  
ATOM   3521  CB  VAL A 420      11.541  43.651  47.872  1.00 52.10           C  
ATOM   3522  CG1 VAL A 420      11.869  44.427  46.618  1.00 52.19           C  
ATOM   3523  CG2 VAL A 420      11.811  44.500  49.063  1.00 51.00           C  
ATOM   3524  N   ILE A 421       9.100  42.754  45.656  1.00 52.63           N  
ATOM   3525  CA  ILE A 421       9.031  41.989  44.419  1.00 52.54           C  
ATOM   3526  C   ILE A 421       9.736  42.728  43.281  1.00 52.67           C  
ATOM   3527  O   ILE A 421       9.577  43.956  43.113  1.00 53.31           O  
ATOM   3528  CB  ILE A 421       7.614  41.571  44.067  1.00 52.28           C  
ATOM   3529  CG1 ILE A 421       7.058  40.730  45.211  1.00 51.44           C  
ATOM   3530  CG2 ILE A 421       7.620  40.761  42.762  1.00 51.94           C  
ATOM   3531  CD1 ILE A 421       5.573  40.508  45.150  1.00 50.97           C  
ATOM   3532  N   VAL A 422      10.543  41.986  42.526  1.00 51.98           N  
ATOM   3533  CA  VAL A 422      11.377  42.588  41.512  1.00 51.16           C  
ATOM   3534  C   VAL A 422      11.121  41.885  40.226  1.00 51.32           C  
ATOM   3535  O   VAL A 422      11.324  40.674  40.135  1.00 51.73           O  
ATOM   3536  CB  VAL A 422      12.871  42.439  41.802  1.00 50.97           C  
ATOM   3537  CG1 VAL A 422      13.608  43.586  41.160  1.00 50.45           C  
ATOM   3538  CG2 VAL A 422      13.159  42.357  43.306  1.00 50.20           C  
ATOM   3539  N   PHE A 423      10.661  42.635  39.237  1.00 51.37           N  
ATOM   3540  CA  PHE A 423      10.536  42.110  37.902  1.00 51.97           C  
ATOM   3541  C   PHE A 423      11.731  42.625  37.126  1.00 52.67           C  
ATOM   3542  O   PHE A 423      11.904  43.851  36.942  1.00 52.38           O  
ATOM   3543  CB  PHE A 423       9.280  42.631  37.230  1.00 52.27           C  
ATOM   3544  CG  PHE A 423       8.011  42.176  37.852  1.00 52.09           C  
ATOM   3545  CD1 PHE A 423       7.246  43.073  38.619  1.00 50.66           C  
ATOM   3546  CD2 PHE A 423       7.550  40.863  37.653  1.00 52.20           C  
ATOM   3547  CE1 PHE A 423       6.037  42.676  39.220  1.00 50.09           C  
ATOM   3548  CE2 PHE A 423       6.332  40.448  38.236  1.00 52.85           C  
ATOM   3549  CZ  PHE A 423       5.572  41.373  39.030  1.00 52.00           C  
ATOM   3550  N   LEU A 424      12.547  41.690  36.663  1.00 53.34           N  
ATOM   3551  CA  LEU A 424      13.777  42.037  36.010  1.00 54.60           C  
ATOM   3552  C   LEU A 424      13.679  41.689  34.583  1.00 56.60           C  
ATOM   3553  O   LEU A 424      13.336  40.566  34.235  1.00 56.79           O  
ATOM   3554  CB  LEU A 424      14.903  41.214  36.563  1.00 54.10           C  
ATOM   3555  CG  LEU A 424      15.455  41.498  37.932  1.00 53.02           C  
ATOM   3556  CD1 LEU A 424      16.697  40.698  37.951  1.00 52.53           C  
ATOM   3557  CD2 LEU A 424      15.781  42.966  38.100  1.00 52.07           C  
ATOM   3558  N   GLU A 425      14.006  42.631  33.723  1.00 59.46           N  
ATOM   3559  CA  GLU A 425      14.151  42.229  32.358  1.00 62.29           C  
ATOM   3560  C   GLU A 425      15.507  41.654  32.091  1.00 64.09           C  
ATOM   3561  O   GLU A 425      16.424  41.748  32.899  1.00 64.11           O  
ATOM   3562  CB  GLU A 425      13.877  43.330  31.388  1.00 62.39           C  
ATOM   3563  CG  GLU A 425      13.728  42.745  30.024  1.00 64.26           C  
ATOM   3564  CD  GLU A 425      13.385  43.774  29.009  1.00 67.28           C  
ATOM   3565  OE1 GLU A 425      12.713  44.786  29.362  1.00 66.22           O  
ATOM   3566  OE2 GLU A 425      13.789  43.544  27.847  1.00 70.26           O  
ATOM   3567  N   GLU A 426      15.615  41.042  30.929  1.00 66.92           N  
ATOM   3568  CA  GLU A 426      16.769  40.245  30.615  1.00 69.70           C  
ATOM   3569  C   GLU A 426      17.734  41.089  29.818  1.00 70.31           C  
ATOM   3570  O   GLU A 426      17.349  41.717  28.854  1.00 70.34           O  
ATOM   3571  CB  GLU A 426      16.306  38.982  29.880  1.00 70.21           C  
ATOM   3572  CG  GLU A 426      16.639  38.924  28.412  1.00 73.83           C  
ATOM   3573  CD  GLU A 426      16.986  37.509  28.009  1.00 79.02           C  
ATOM   3574  OE1 GLU A 426      16.752  36.594  28.840  1.00 80.81           O  
ATOM   3575  OE2 GLU A 426      17.511  37.318  26.882  1.00 81.18           O  
ATOM   3576  N   TYR A 427      18.978  41.153  30.264  1.00 72.03           N  
ATOM   3577  CA  TYR A 427      19.986  41.905  29.528  1.00 73.75           C  
ATOM   3578  C   TYR A 427      21.021  40.933  28.932  1.00 76.55           C  
ATOM   3579  O   TYR A 427      21.804  40.292  29.656  1.00 76.67           O  
ATOM   3580  CB  TYR A 427      20.585  43.013  30.395  1.00 72.28           C  
ATOM   3581  CG  TYR A 427      19.563  44.047  30.814  1.00 70.18           C  
ATOM   3582  CD1 TYR A 427      18.693  43.806  31.875  1.00 67.89           C  
ATOM   3583  CD2 TYR A 427      19.450  45.255  30.140  1.00 68.58           C  
ATOM   3584  CE1 TYR A 427      17.743  44.723  32.245  1.00 66.38           C  
ATOM   3585  CE2 TYR A 427      18.504  46.189  30.518  1.00 67.56           C  
ATOM   3586  CZ  TYR A 427      17.657  45.919  31.574  1.00 67.90           C  
ATOM   3587  OH  TYR A 427      16.724  46.843  31.962  1.00 68.15           O  
ATOM   3588  N   PRO A 428      21.039  40.840  27.594  1.00 79.28           N  
ATOM   3589  CA  PRO A 428      21.476  39.580  26.976  1.00 81.38           C  
ATOM   3590  C   PRO A 428      22.965  39.327  27.172  1.00 83.67           C  
ATOM   3591  O   PRO A 428      23.389  38.194  27.438  1.00 83.65           O  
ATOM   3592  CB  PRO A 428      21.155  39.792  25.488  1.00 81.61           C  
ATOM   3593  CG  PRO A 428      21.119  41.329  25.292  1.00 80.28           C  
ATOM   3594  CD  PRO A 428      20.742  41.916  26.613  1.00 79.22           C  
ATOM   3595  N   LYS A 429      23.735  40.399  27.053  1.00 86.45           N  
ATOM   3596  CA  LYS A 429      25.175  40.321  26.997  1.00 89.79           C  
ATOM   3597  C   LYS A 429      25.752  41.120  28.145  1.00 91.36           C  
ATOM   3598  O   LYS A 429      25.019  41.442  29.090  1.00 91.78           O  
ATOM   3599  CB  LYS A 429      25.673  40.852  25.640  1.00 89.97           C  
ATOM   3600  CG  LYS A 429      25.682  39.794  24.521  1.00 90.84           C  
ATOM   3601  CD  LYS A 429      25.730  40.420  23.124  1.00 90.48           C  
ATOM   3602  CE  LYS A 429      25.395  39.393  22.069  1.00 91.12           C  
ATOM   3603  NZ  LYS A 429      25.896  38.043  22.478  1.00 92.65           N  
ATOM   3604  N   VAL A 430      27.063  41.397  28.053  1.00 93.43           N  
ATOM   3605  CA  VAL A 430      27.834  42.294  28.942  1.00 95.08           C  
ATOM   3606  C   VAL A 430      29.338  41.973  28.880  1.00 95.93           C  
ATOM   3607  O   VAL A 430      29.706  40.864  28.492  1.00 95.96           O  
ATOM   3608  CB  VAL A 430      27.261  42.315  30.408  1.00 95.48           C  
ATOM   3609  CG1 VAL A 430      28.293  41.862  31.486  1.00 95.33           C  
ATOM   3610  CG2 VAL A 430      26.594  43.693  30.703  1.00 95.38           C  
ATOM   3611  N   ASP A 431      30.194  42.940  29.236  1.00 97.13           N  
ATOM   3612  CA  ASP A 431      31.654  42.703  29.346  1.00 98.27           C  
ATOM   3613  C   ASP A 431      31.969  41.361  30.023  1.00 98.67           C  
ATOM   3614  O   ASP A 431      31.515  41.097  31.156  1.00 98.66           O  
ATOM   3615  CB  ASP A 431      32.382  43.843  30.090  1.00 98.62           C  
ATOM   3616  CG  ASP A 431      32.865  44.976  29.156  1.00 99.47           C  
ATOM   3617  OD1 ASP A 431      33.423  44.701  28.064  1.00100.33           O  
ATOM   3618  OD2 ASP A 431      32.702  46.161  29.537  1.00100.04           O  
ATOM   3619  N   PRO A 432      32.754  40.510  29.330  1.00 98.99           N  
ATOM   3620  CA  PRO A 432      32.973  39.143  29.792  1.00 99.17           C  
ATOM   3621  C   PRO A 432      33.700  39.073  31.146  1.00 99.46           C  
ATOM   3622  O   PRO A 432      33.690  38.018  31.790  1.00 99.85           O  
ATOM   3623  CB  PRO A 432      33.808  38.518  28.663  1.00 99.09           C  
ATOM   3624  CG  PRO A 432      33.622  39.422  27.472  1.00 98.93           C  
ATOM   3625  CD  PRO A 432      33.480  40.785  28.075  1.00 99.02           C  
ATOM   3626  N   TYR A 433      34.311  40.182  31.569  1.00 99.51           N  
ATOM   3627  CA  TYR A 433      34.910  40.266  32.905  1.00 99.65           C  
ATOM   3628  C   TYR A 433      33.938  40.869  33.919  1.00 99.15           C  
ATOM   3629  O   TYR A 433      33.747  40.299  35.012  1.00 99.33           O  
ATOM   3630  CB  TYR A 433      36.195  41.100  32.932  1.00100.32           C  
ATOM   3631  CG  TYR A 433      36.689  41.639  31.608  1.00101.52           C  
ATOM   3632  CD1 TYR A 433      36.362  42.953  31.192  1.00102.06           C  
ATOM   3633  CD2 TYR A 433      37.507  40.862  30.785  1.00102.39           C  
ATOM   3634  CE1 TYR A 433      36.827  43.466  29.979  1.00101.28           C  
ATOM   3635  CE2 TYR A 433      37.978  41.368  29.568  1.00103.22           C  
ATOM   3636  CZ  TYR A 433      37.633  42.664  29.173  1.00101.72           C  
ATOM   3637  OH  TYR A 433      38.113  43.124  27.973  1.00101.44           O  
ATOM   3638  N   LYS A 434      33.343  42.019  33.560  1.00 98.09           N  
ATOM   3639  CA  LYS A 434      32.363  42.728  34.412  1.00 96.89           C  
ATOM   3640  C   LYS A 434      31.090  41.913  34.735  1.00 96.18           C  
ATOM   3641  O   LYS A 434      30.093  42.462  35.220  1.00 95.41           O  
ATOM   3642  CB  LYS A 434      32.004  44.082  33.796  1.00 96.85           C  
ATOM   3643  CG  LYS A 434      33.103  45.126  33.938  1.00 96.70           C  
ATOM   3644  CD  LYS A 434      32.767  46.426  33.205  1.00 96.66           C  
ATOM   3645  CE  LYS A 434      34.027  47.256  32.951  1.00 95.79           C  
ATOM   3646  NZ  LYS A 434      33.830  48.281  31.895  1.00 94.99           N  
ATOM   3647  N   SER A 435      31.171  40.599  34.494  1.00 95.48           N  
ATOM   3648  CA  SER A 435      30.056  39.652  34.627  1.00 94.78           C  
ATOM   3649  C   SER A 435      29.437  39.517  36.033  1.00 93.95           C  
ATOM   3650  O   SER A 435      29.786  38.611  36.802  1.00 94.05           O  
ATOM   3651  CB  SER A 435      30.433  38.270  34.043  1.00 94.99           C  
ATOM   3652  OG  SER A 435      31.747  37.856  34.405  1.00 95.56           O  
ATOM   3653  N   PHE A 436      28.534  40.451  36.353  1.00 92.76           N  
ATOM   3654  CA  PHE A 436      27.545  40.301  37.437  1.00 91.24           C  
ATOM   3655  C   PHE A 436      26.393  39.405  36.933  1.00 89.34           C  
ATOM   3656  O   PHE A 436      26.171  39.288  35.724  1.00 89.13           O  
ATOM   3657  CB  PHE A 436      26.964  41.679  37.824  1.00 91.79           C  
ATOM   3658  CG  PHE A 436      27.766  42.442  38.877  1.00 93.50           C  
ATOM   3659  CD1 PHE A 436      28.164  43.779  38.636  1.00 94.49           C  
ATOM   3660  CD2 PHE A 436      28.082  41.851  40.126  1.00 93.98           C  
ATOM   3661  CE1 PHE A 436      28.894  44.513  39.612  1.00 94.76           C  
ATOM   3662  CE2 PHE A 436      28.808  42.570  41.109  1.00 94.21           C  
ATOM   3663  CZ  PHE A 436      29.216  43.905  40.851  1.00 94.34           C  
ATOM   3664  N   LEU A 437      25.661  38.766  37.838  1.00 86.84           N  
ATOM   3665  CA  LEU A 437      24.329  38.291  37.473  1.00 84.43           C  
ATOM   3666  C   LEU A 437      23.300  39.240  38.095  1.00 82.70           C  
ATOM   3667  O   LEU A 437      23.337  39.502  39.304  1.00 82.98           O  
ATOM   3668  CB  LEU A 437      24.097  36.858  37.931  1.00 84.56           C  
ATOM   3669  CG  LEU A 437      24.792  35.682  37.237  1.00 85.16           C  
ATOM   3670  CD1 LEU A 437      24.439  34.348  37.921  1.00 85.02           C  
ATOM   3671  CD2 LEU A 437      24.447  35.624  35.748  1.00 85.67           C  
ATOM   3672  N   LEU A 438      22.398  39.777  37.276  1.00 80.00           N  
ATOM   3673  CA  LEU A 438      21.461  40.792  37.748  1.00 76.93           C  
ATOM   3674  C   LEU A 438      20.607  40.273  38.898  1.00 75.36           C  
ATOM   3675  O   LEU A 438      20.492  40.928  39.927  1.00 74.78           O  
ATOM   3676  CB  LEU A 438      20.595  41.345  36.601  1.00 76.86           C  
ATOM   3677  CG  LEU A 438      20.052  42.760  36.835  1.00 76.24           C  
ATOM   3678  CD1 LEU A 438      21.153  43.680  37.331  1.00 76.32           C  
ATOM   3679  CD2 LEU A 438      19.390  43.370  35.610  1.00 76.18           C  
ATOM   3680  N   TYR A 439      20.042  39.081  38.723  1.00 73.59           N  
ATOM   3681  CA  TYR A 439      19.210  38.441  39.734  1.00 72.17           C  
ATOM   3682  C   TYR A 439      20.033  38.278  40.998  1.00 71.39           C  
ATOM   3683  O   TYR A 439      19.603  38.684  42.057  1.00 71.61           O  
ATOM   3684  CB  TYR A 439      18.701  37.116  39.191  1.00 72.35           C  
ATOM   3685  CG  TYR A 439      17.818  36.256  40.083  1.00 73.50           C  
ATOM   3686  CD1 TYR A 439      16.473  35.981  39.725  1.00 73.58           C  
ATOM   3687  CD2 TYR A 439      18.334  35.638  41.251  1.00 74.34           C  
ATOM   3688  CE1 TYR A 439      15.639  35.136  40.538  1.00 74.54           C  
ATOM   3689  CE2 TYR A 439      17.510  34.808  42.078  1.00 74.27           C  
ATOM   3690  CZ  TYR A 439      16.176  34.556  41.712  1.00 74.61           C  
ATOM   3691  OH  TYR A 439      15.399  33.747  42.514  1.00 74.07           O  
ATOM   3692  N   ASP A 440      21.235  37.733  40.874  1.00 70.35           N  
ATOM   3693  CA  ASP A 440      22.203  37.703  41.960  1.00 69.62           C  
ATOM   3694  C   ASP A 440      22.409  39.029  42.684  1.00 67.90           C  
ATOM   3695  O   ASP A 440      22.230  39.118  43.890  1.00 67.62           O  
ATOM   3696  CB  ASP A 440      23.537  37.227  41.415  1.00 70.78           C  
ATOM   3697  CG  ASP A 440      23.567  35.720  41.205  1.00 75.55           C  
ATOM   3698  OD1 ASP A 440      22.614  35.067  41.720  1.00 80.60           O  
ATOM   3699  OD2 ASP A 440      24.531  35.191  40.553  1.00 78.21           O  
ATOM   3700  N   PHE A 441      22.807  40.052  41.947  1.00 65.90           N  
ATOM   3701  CA  PHE A 441      23.000  41.354  42.534  1.00 64.38           C  
ATOM   3702  C   PHE A 441      21.810  41.758  43.431  1.00 63.82           C  
ATOM   3703  O   PHE A 441      21.997  42.067  44.614  1.00 63.34           O  
ATOM   3704  CB  PHE A 441      23.247  42.374  41.431  1.00 64.17           C  
ATOM   3705  CG  PHE A 441      23.263  43.784  41.912  1.00 63.87           C  
ATOM   3706  CD1 PHE A 441      24.402  44.317  42.508  1.00 64.88           C  
ATOM   3707  CD2 PHE A 441      22.142  44.588  41.775  1.00 63.13           C  
ATOM   3708  CE1 PHE A 441      24.422  45.660  42.965  1.00 65.47           C  
ATOM   3709  CE2 PHE A 441      22.146  45.924  42.223  1.00 64.15           C  
ATOM   3710  CZ  PHE A 441      23.288  46.462  42.824  1.00 64.11           C  
ATOM   3711  N   VAL A 442      20.600  41.732  42.855  1.00 62.97           N  
ATOM   3712  CA  VAL A 442      19.340  42.115  43.526  1.00 61.71           C  
ATOM   3713  C   VAL A 442      19.127  41.211  44.728  1.00 61.88           C  
ATOM   3714  O   VAL A 442      18.723  41.643  45.800  1.00 61.33           O  
ATOM   3715  CB  VAL A 442      18.124  42.029  42.539  1.00 61.09           C  
ATOM   3716  CG1 VAL A 442      16.836  42.281  43.209  1.00 59.83           C  
ATOM   3717  CG2 VAL A 442      18.254  43.018  41.465  1.00 59.94           C  
ATOM   3718  N   LYS A 443      19.436  39.942  44.528  1.00 62.52           N  
ATOM   3719  CA  LYS A 443      19.328  38.938  45.562  1.00 63.26           C  
ATOM   3720  C   LYS A 443      20.299  39.282  46.693  1.00 63.84           C  
ATOM   3721  O   LYS A 443      19.903  39.317  47.863  1.00 63.65           O  
ATOM   3722  CB  LYS A 443      19.630  37.576  44.952  1.00 62.82           C  
ATOM   3723  CG  LYS A 443      18.625  36.475  45.229  1.00 64.12           C  
ATOM   3724  CD  LYS A 443      17.289  36.916  45.841  1.00 65.33           C  
ATOM   3725  CE  LYS A 443      16.260  35.774  45.719  1.00 66.28           C  
ATOM   3726  NZ  LYS A 443      15.145  35.855  46.700  1.00 65.86           N  
ATOM   3727  N   ARG A 444      21.555  39.565  46.342  1.00 64.60           N  
ATOM   3728  CA  ARG A 444      22.544  39.971  47.341  1.00 65.33           C  
ATOM   3729  C   ARG A 444      22.080  41.199  48.127  1.00 64.79           C  
ATOM   3730  O   ARG A 444      21.939  41.130  49.349  1.00 65.41           O  
ATOM   3731  CB  ARG A 444      23.934  40.193  46.744  1.00 65.76           C  
ATOM   3732  CG  ARG A 444      24.591  38.921  46.252  1.00 69.99           C  
ATOM   3733  CD  ARG A 444      26.119  38.964  46.446  1.00 78.72           C  
ATOM   3734  NE  ARG A 444      26.817  38.796  45.148  1.00 86.05           N  
ATOM   3735  CZ  ARG A 444      27.071  39.821  44.286  1.00 89.02           C  
ATOM   3736  NH1 ARG A 444      26.696  41.100  44.597  1.00 89.02           N  
ATOM   3737  NH2 ARG A 444      27.709  39.580  43.117  1.00 90.45           N  
ATOM   3738  N   GLU A 445      21.805  42.306  47.437  1.00 63.76           N  
ATOM   3739  CA  GLU A 445      21.468  43.565  48.127  1.00 62.38           C  
ATOM   3740  C   GLU A 445      20.393  43.414  49.173  1.00 60.81           C  
ATOM   3741  O   GLU A 445      20.477  44.034  50.210  1.00 60.91           O  
ATOM   3742  CB  GLU A 445      21.090  44.696  47.144  1.00 62.77           C  
ATOM   3743  CG  GLU A 445      22.258  45.278  46.337  1.00 64.69           C  
ATOM   3744  CD  GLU A 445      23.612  44.987  46.980  1.00 68.60           C  
ATOM   3745  OE1 GLU A 445      23.944  45.647  47.978  1.00 71.42           O  
ATOM   3746  OE2 GLU A 445      24.340  44.078  46.508  1.00 70.59           O  
ATOM   3747  N   LEU A 446      19.393  42.583  48.897  1.00 59.55           N  
ATOM   3748  CA  LEU A 446      18.194  42.503  49.740  1.00 58.49           C  
ATOM   3749  C   LEU A 446      18.406  41.564  50.898  1.00 57.92           C  
ATOM   3750  O   LEU A 446      18.014  41.859  52.001  1.00 58.41           O  
ATOM   3751  CB  LEU A 446      16.951  42.073  48.942  1.00 58.23           C  
ATOM   3752  CG  LEU A 446      16.368  43.066  47.912  1.00 57.80           C  
ATOM   3753  CD1 LEU A 446      15.571  42.354  46.811  1.00 54.34           C  
ATOM   3754  CD2 LEU A 446      15.567  44.248  48.556  1.00 55.05           C  
ATOM   3755  N   LEU A 447      19.020  40.424  50.649  1.00 57.22           N  
ATOM   3756  CA  LEU A 447      19.423  39.567  51.733  1.00 56.34           C  
ATOM   3757  C   LEU A 447      20.213  40.359  52.758  1.00 56.27           C  
ATOM   3758  O   LEU A 447      19.885  40.307  53.943  1.00 56.66           O  
ATOM   3759  CB  LEU A 447      20.216  38.376  51.218  1.00 56.42           C  
ATOM   3760  CG  LEU A 447      19.343  37.255  50.656  1.00 55.02           C  
ATOM   3761  CD1 LEU A 447      20.241  36.191  50.046  1.00 52.41           C  
ATOM   3762  CD2 LEU A 447      18.443  36.679  51.772  1.00 52.46           C  
ATOM   3763  N   LYS A 448      21.219  41.116  52.307  1.00 55.93           N  
ATOM   3764  CA  LYS A 448      21.964  42.042  53.191  1.00 55.32           C  
ATOM   3765  C   LYS A 448      21.025  42.780  54.119  1.00 54.55           C  
ATOM   3766  O   LYS A 448      21.312  42.939  55.293  1.00 55.20           O  
ATOM   3767  CB  LYS A 448      22.797  43.050  52.402  1.00 54.83           C  
ATOM   3768  CG  LYS A 448      24.024  42.460  51.707  1.00 55.37           C  
ATOM   3769  CD  LYS A 448      24.789  43.554  50.958  1.00 56.58           C  
ATOM   3770  CE  LYS A 448      26.033  43.005  50.267  1.00 59.07           C  
ATOM   3771  NZ  LYS A 448      26.600  43.995  49.271  1.00 60.54           N  
ATOM   3772  N   LYS A 449      19.881  43.192  53.592  1.00 53.68           N  
ATOM   3773  CA  LYS A 449      18.887  43.947  54.345  1.00 52.76           C  
ATOM   3774  C   LYS A 449      17.961  43.087  55.213  1.00 52.19           C  
ATOM   3775  O   LYS A 449      17.160  43.614  55.963  1.00 51.96           O  
ATOM   3776  CB  LYS A 449      18.024  44.782  53.381  1.00 53.00           C  
ATOM   3777  CG  LYS A 449      18.744  45.861  52.564  1.00 52.39           C  
ATOM   3778  CD  LYS A 449      17.924  47.154  52.580  1.00 51.94           C  
ATOM   3779  CE  LYS A 449      18.755  48.320  52.063  1.00 52.71           C  
ATOM   3780  NZ  LYS A 449      18.852  49.461  53.014  1.00 48.33           N  
ATOM   3781  N   MET A 450      18.033  41.766  55.095  1.00 52.05           N  
ATOM   3782  CA  MET A 450      17.163  40.901  55.881  1.00 52.03           C  
ATOM   3783  C   MET A 450      15.693  40.945  55.437  1.00 51.90           C  
ATOM   3784  O   MET A 450      14.800  40.489  56.154  1.00 52.10           O  
ATOM   3785  CB  MET A 450      17.231  41.300  57.361  1.00 52.57           C  
ATOM   3786  CG  MET A 450      18.623  41.348  58.000  1.00 53.08           C  
ATOM   3787  SD  MET A 450      19.289  39.695  58.261  1.00 53.12           S  
ATOM   3788  CE  MET A 450      20.170  39.580  56.699  1.00 58.85           C  
ATOM   3789  N   ILE A 451      15.437  41.494  54.260  1.00 51.77           N  
ATOM   3790  CA  ILE A 451      14.092  41.617  53.718  1.00 51.19           C  
ATOM   3791  C   ILE A 451      13.836  40.472  52.741  1.00 51.50           C  
ATOM   3792  O   ILE A 451      14.584  40.284  51.778  1.00 50.80           O  
ATOM   3793  CB  ILE A 451      13.944  42.951  52.988  1.00 50.94           C  
ATOM   3794  CG1 ILE A 451      14.398  44.088  53.896  1.00 50.13           C  
ATOM   3795  CG2 ILE A 451      12.518  43.162  52.534  1.00 51.11           C  
ATOM   3796  CD1 ILE A 451      14.415  45.413  53.237  1.00 47.98           C  
ATOM   3797  N   PRO A 452      12.769  39.688  52.980  1.00 52.11           N  
ATOM   3798  CA  PRO A 452      12.474  38.585  52.047  1.00 52.09           C  
ATOM   3799  C   PRO A 452      12.279  39.183  50.660  1.00 51.72           C  
ATOM   3800  O   PRO A 452      11.755  40.275  50.561  1.00 52.44           O  
ATOM   3801  CB  PRO A 452      11.143  38.023  52.565  1.00 51.65           C  
ATOM   3802  CG  PRO A 452      11.104  38.435  54.005  1.00 52.54           C  
ATOM   3803  CD  PRO A 452      11.793  39.767  54.083  1.00 52.19           C  
ATOM   3804  N   SER A 453      12.675  38.491  49.600  1.00 50.77           N  
ATOM   3805  CA  SER A 453      12.397  39.007  48.269  1.00 49.24           C  
ATOM   3806  C   SER A 453      11.945  37.915  47.284  1.00 48.61           C  
ATOM   3807  O   SER A 453      12.293  36.765  47.423  1.00 48.40           O  
ATOM   3808  CB  SER A 453      13.630  39.725  47.752  1.00 48.98           C  
ATOM   3809  OG  SER A 453      14.723  38.823  47.703  1.00 48.40           O  
ATOM   3810  N   GLN A 454      11.152  38.287  46.293  1.00 47.89           N  
ATOM   3811  CA  GLN A 454      10.861  37.398  45.216  1.00 46.88           C  
ATOM   3812  C   GLN A 454      11.218  38.125  43.930  1.00 47.11           C  
ATOM   3813  O   GLN A 454      10.661  39.181  43.601  1.00 47.36           O  
ATOM   3814  CB  GLN A 454       9.410  37.055  45.217  1.00 46.95           C  
ATOM   3815  CG  GLN A 454       9.071  36.115  44.133  1.00 47.69           C  
ATOM   3816  CD  GLN A 454       9.419  34.760  44.552  1.00 50.93           C  
ATOM   3817  OE1 GLN A 454       9.339  34.447  45.741  1.00 52.74           O  
ATOM   3818  NE2 GLN A 454       9.810  33.916  43.605  1.00 52.17           N  
ATOM   3819  N   VAL A 455      12.163  37.544  43.212  1.00 46.72           N  
ATOM   3820  CA  VAL A 455      12.713  38.124  42.018  1.00 46.93           C  
ATOM   3821  C   VAL A 455      12.151  37.365  40.801  1.00 47.47           C  
ATOM   3822  O   VAL A 455      12.277  36.137  40.684  1.00 47.25           O  
ATOM   3823  CB  VAL A 455      14.269  38.100  42.081  1.00 46.60           C  
ATOM   3824  CG1 VAL A 455      14.890  38.666  40.835  1.00 46.50           C  
ATOM   3825  CG2 VAL A 455      14.732  38.918  43.216  1.00 46.40           C  
ATOM   3826  N   ILE A 456      11.499  38.093  39.910  1.00 47.59           N  
ATOM   3827  CA  ILE A 456      10.856  37.435  38.796  1.00 48.18           C  
ATOM   3828  C   ILE A 456      11.466  37.903  37.480  1.00 48.17           C  
ATOM   3829  O   ILE A 456      11.410  39.072  37.108  1.00 48.83           O  
ATOM   3830  CB  ILE A 456       9.292  37.521  38.879  1.00 47.98           C  
ATOM   3831  CG1 ILE A 456       8.806  36.637  40.016  1.00 50.44           C  
ATOM   3832  CG2 ILE A 456       8.657  36.897  37.693  1.00 47.23           C  
ATOM   3833  CD1 ILE A 456       7.579  37.137  40.760  1.00 51.15           C  
ATOM   3834  N   LEU A 457      12.093  36.966  36.805  1.00 48.14           N  
ATOM   3835  CA  LEU A 457      12.682  37.207  35.522  1.00 48.07           C  
ATOM   3836  C   LEU A 457      11.617  37.372  34.462  1.00 48.90           C  
ATOM   3837  O   LEU A 457      10.722  36.537  34.328  1.00 48.83           O  
ATOM   3838  CB  LEU A 457      13.539  36.004  35.151  1.00 47.86           C  
ATOM   3839  CG  LEU A 457      14.740  35.591  35.989  1.00 44.47           C  
ATOM   3840  CD1 LEU A 457      15.471  34.593  35.110  1.00 43.14           C  
ATOM   3841  CD2 LEU A 457      15.605  36.803  36.277  1.00 41.64           C  
ATOM   3842  N   ASN A 458      11.735  38.432  33.671  1.00 49.88           N  
ATOM   3843  CA  ASN A 458      10.843  38.605  32.549  1.00 50.57           C  
ATOM   3844  C   ASN A 458      10.853  37.448  31.542  1.00 50.95           C  
ATOM   3845  O   ASN A 458       9.820  37.162  30.932  1.00 50.21           O  
ATOM   3846  CB  ASN A 458      11.130  39.887  31.844  1.00 50.59           C  
ATOM   3847  CG  ASN A 458       9.882  40.586  31.475  1.00 54.31           C  
ATOM   3848  OD1 ASN A 458       9.347  40.423  30.378  1.00 56.71           O  
ATOM   3849  ND2 ASN A 458       9.357  41.356  32.418  1.00 59.10           N  
ATOM   3850  N   ARG A 459      11.999  36.779  31.362  1.00 51.79           N  
ATOM   3851  CA  ARG A 459      11.993  35.541  30.583  1.00 53.14           C  
ATOM   3852  C   ARG A 459      10.862  34.656  31.066  1.00 53.65           C  
ATOM   3853  O   ARG A 459      10.117  34.134  30.223  1.00 54.14           O  
ATOM   3854  CB  ARG A 459      13.267  34.724  30.714  1.00 53.41           C  
ATOM   3855  CG  ARG A 459      14.339  35.097  29.811  1.00 56.79           C  
ATOM   3856  CD  ARG A 459      15.398  34.003  29.774  1.00 62.59           C  
ATOM   3857  NE  ARG A 459      16.420  34.150  30.808  1.00 68.17           N  
ATOM   3858  CZ  ARG A 459      16.592  33.288  31.807  1.00 73.16           C  
ATOM   3859  NH1 ARG A 459      15.809  32.214  31.896  1.00 76.07           N  
ATOM   3860  NH2 ARG A 459      17.553  33.483  32.712  1.00 75.10           N  
ATOM   3861  N   THR A 460      10.736  34.483  32.397  1.00 53.27           N  
ATOM   3862  CA  THR A 460       9.801  33.516  32.929  1.00 53.76           C  
ATOM   3863  C   THR A 460       8.383  33.834  32.503  1.00 54.52           C  
ATOM   3864  O   THR A 460       7.655  32.951  32.067  1.00 54.84           O  
ATOM   3865  CB  THR A 460       9.823  33.457  34.440  1.00 54.39           C  
ATOM   3866  OG1 THR A 460      11.085  32.959  34.909  1.00 55.17           O  
ATOM   3867  CG2 THR A 460       8.710  32.546  34.949  1.00 53.74           C  
ATOM   3868  N   LEU A 461       7.987  35.099  32.608  1.00 55.23           N  
ATOM   3869  CA  LEU A 461       6.692  35.515  32.113  1.00 55.89           C  
ATOM   3870  C   LEU A 461       6.527  35.239  30.612  1.00 57.58           C  
ATOM   3871  O   LEU A 461       5.419  35.038  30.111  1.00 58.45           O  
ATOM   3872  CB  LEU A 461       6.460  36.983  32.429  1.00 55.15           C  
ATOM   3873  CG  LEU A 461       6.583  37.452  33.896  1.00 54.39           C  
ATOM   3874  CD1 LEU A 461       6.159  38.908  34.053  1.00 50.96           C  
ATOM   3875  CD2 LEU A 461       5.804  36.573  34.895  1.00 51.50           C  
ATOM   3876  N   LYS A 462       7.622  35.197  29.881  1.00 59.27           N  
ATOM   3877  CA  LYS A 462       7.508  35.090  28.448  1.00 61.25           C  
ATOM   3878  C   LYS A 462       7.467  33.665  27.946  1.00 62.35           C  
ATOM   3879  O   LYS A 462       6.820  33.376  26.954  1.00 62.52           O  
ATOM   3880  CB  LYS A 462       8.657  35.835  27.791  1.00 61.85           C  
ATOM   3881  CG  LYS A 462       8.374  37.294  27.518  1.00 62.04           C  
ATOM   3882  CD  LYS A 462       9.670  38.014  27.232  1.00 63.59           C  
ATOM   3883  CE  LYS A 462       9.357  39.356  26.643  1.00 65.84           C  
ATOM   3884  NZ  LYS A 462      10.414  40.350  26.947  1.00 69.57           N  
ATOM   3885  N   ASN A 463       8.167  32.783  28.635  1.00 63.81           N  
ATOM   3886  CA  ASN A 463       8.281  31.379  28.248  1.00 65.67           C  
ATOM   3887  C   ASN A 463       7.266  30.446  28.889  1.00 66.34           C  
ATOM   3888  O   ASN A 463       6.867  29.426  28.296  1.00 66.60           O  
ATOM   3889  CB  ASN A 463       9.671  30.899  28.623  1.00 65.66           C  
ATOM   3890  CG  ASN A 463      10.741  31.763  28.007  1.00 67.91           C  
ATOM   3891  OD1 ASN A 463      10.873  31.835  26.774  1.00 68.53           O  
ATOM   3892  ND2 ASN A 463      11.499  32.456  28.857  1.00 70.15           N  
ATOM   3893  N   GLU A 464       6.854  30.816  30.098  1.00 67.08           N  
ATOM   3894  CA  GLU A 464       6.176  29.925  31.000  1.00 67.76           C  
ATOM   3895  C   GLU A 464       4.748  30.323  31.269  1.00 67.82           C  
ATOM   3896  O   GLU A 464       4.396  31.509  31.261  1.00 67.74           O  
ATOM   3897  CB  GLU A 464       6.975  29.822  32.274  1.00 67.72           C  
ATOM   3898  CG  GLU A 464       8.284  29.167  32.024  1.00 72.42           C  
ATOM   3899  CD  GLU A 464       8.096  27.841  31.292  1.00 80.06           C  
ATOM   3900  OE1 GLU A 464       7.458  26.947  31.910  1.00 82.17           O  
ATOM   3901  OE2 GLU A 464       8.547  27.697  30.104  1.00 82.35           O  
ATOM   3902  N   ASN A 465       3.935  29.304  31.512  1.00 68.19           N  
ATOM   3903  CA  ASN A 465       2.488  29.448  31.573  1.00 68.90           C  
ATOM   3904  C   ASN A 465       2.117  30.134  32.863  1.00 68.41           C  
ATOM   3905  O   ASN A 465       2.669  29.814  33.912  1.00 68.29           O  
ATOM   3906  CB  ASN A 465       1.805  28.074  31.416  1.00 69.42           C  
ATOM   3907  CG  ASN A 465       2.348  27.284  30.168  1.00 73.07           C  
ATOM   3908  OD1 ASN A 465       1.903  27.509  29.017  1.00 73.46           O  
ATOM   3909  ND2 ASN A 465       3.343  26.377  30.407  1.00 74.39           N  
ATOM   3910  N   LEU A 466       1.211  31.103  32.780  1.00 67.99           N  
ATOM   3911  CA  LEU A 466       0.862  31.896  33.945  1.00 67.80           C  
ATOM   3912  C   LEU A 466       0.650  31.115  35.261  1.00 67.93           C  
ATOM   3913  O   LEU A 466       1.148  31.531  36.316  1.00 67.90           O  
ATOM   3914  CB  LEU A 466      -0.330  32.799  33.642  1.00 67.78           C  
ATOM   3915  CG  LEU A 466      -0.622  33.890  34.685  1.00 67.76           C  
ATOM   3916  CD1 LEU A 466       0.633  34.687  35.037  1.00 67.18           C  
ATOM   3917  CD2 LEU A 466      -1.787  34.835  34.260  1.00 67.45           C  
ATOM   3918  N   LYS A 467      -0.062  29.987  35.192  1.00 67.86           N  
ATOM   3919  CA  LYS A 467      -0.422  29.201  36.379  1.00 67.81           C  
ATOM   3920  C   LYS A 467       0.749  28.467  36.980  1.00 67.38           C  
ATOM   3921  O   LYS A 467       0.882  28.360  38.194  1.00 67.49           O  
ATOM   3922  CB  LYS A 467      -1.530  28.208  36.062  1.00 68.26           C  
ATOM   3923  CG  LYS A 467      -2.805  28.868  35.579  1.00 70.50           C  
ATOM   3924  CD  LYS A 467      -4.027  28.478  36.417  1.00 73.36           C  
ATOM   3925  CE  LYS A 467      -5.259  28.516  35.519  1.00 76.12           C  
ATOM   3926  NZ  LYS A 467      -5.121  27.565  34.330  1.00 75.24           N  
ATOM   3927  N   PHE A 468       1.595  27.944  36.117  1.00 67.37           N  
ATOM   3928  CA  PHE A 468       2.831  27.352  36.544  1.00 67.52           C  
ATOM   3929  C   PHE A 468       3.609  28.367  37.345  1.00 67.35           C  
ATOM   3930  O   PHE A 468       3.942  28.130  38.506  1.00 67.28           O  
ATOM   3931  CB  PHE A 468       3.642  26.903  35.348  1.00 67.91           C  
ATOM   3932  CG  PHE A 468       4.993  26.406  35.701  1.00 70.07           C  
ATOM   3933  CD1 PHE A 468       5.148  25.188  36.375  1.00 72.61           C  
ATOM   3934  CD2 PHE A 468       6.128  27.156  35.373  1.00 71.98           C  
ATOM   3935  CE1 PHE A 468       6.429  24.716  36.727  1.00 74.05           C  
ATOM   3936  CE2 PHE A 468       7.421  26.692  35.689  1.00 73.56           C  
ATOM   3937  CZ  PHE A 468       7.577  25.465  36.373  1.00 72.97           C  
ATOM   3938  N   VAL A 469       3.860  29.525  36.739  1.00 67.22           N  
ATOM   3939  CA  VAL A 469       4.628  30.571  37.410  1.00 66.42           C  
ATOM   3940  C   VAL A 469       3.928  31.062  38.653  1.00 66.46           C  
ATOM   3941  O   VAL A 469       4.575  31.304  39.673  1.00 66.47           O  
ATOM   3942  CB  VAL A 469       4.943  31.720  36.490  1.00 66.04           C  
ATOM   3943  CG1 VAL A 469       5.722  32.761  37.235  1.00 65.37           C  
ATOM   3944  CG2 VAL A 469       5.760  31.204  35.333  1.00 65.31           C  
ATOM   3945  N   LEU A 470       2.608  31.186  38.571  1.00 66.18           N  
ATOM   3946  CA  LEU A 470       1.824  31.563  39.729  1.00 66.15           C  
ATOM   3947  C   LEU A 470       2.076  30.653  40.917  1.00 65.96           C  
ATOM   3948  O   LEU A 470       2.308  31.125  42.027  1.00 66.18           O  
ATOM   3949  CB  LEU A 470       0.344  31.538  39.396  1.00 66.38           C  
ATOM   3950  CG  LEU A 470      -0.595  32.018  40.508  1.00 67.68           C  
ATOM   3951  CD1 LEU A 470      -0.498  33.537  40.754  1.00 66.87           C  
ATOM   3952  CD2 LEU A 470      -2.024  31.571  40.157  1.00 69.68           C  
ATOM   3953  N   LEU A 471       2.023  29.352  40.687  1.00 65.49           N  
ATOM   3954  CA  LEU A 471       2.172  28.426  41.782  1.00 65.66           C  
ATOM   3955  C   LEU A 471       3.575  28.502  42.396  1.00 65.79           C  
ATOM   3956  O   LEU A 471       3.699  28.930  43.549  1.00 66.00           O  
ATOM   3957  CB  LEU A 471       1.748  27.011  41.364  1.00 66.09           C  
ATOM   3958  CG  LEU A 471       0.206  26.840  41.285  1.00 66.40           C  
ATOM   3959  CD1 LEU A 471      -0.281  25.762  40.290  1.00 64.12           C  
ATOM   3960  CD2 LEU A 471      -0.428  26.647  42.681  1.00 64.30           C  
ATOM   3961  N   ASN A 472       4.616  28.153  41.627  1.00 65.64           N  
ATOM   3962  CA  ASN A 472       6.021  28.241  42.070  1.00 65.55           C  
ATOM   3963  C   ASN A 472       6.280  29.378  43.081  1.00 65.41           C  
ATOM   3964  O   ASN A 472       6.897  29.157  44.135  1.00 65.86           O  
ATOM   3965  CB  ASN A 472       6.974  28.458  40.887  1.00 65.66           C  
ATOM   3966  CG  ASN A 472       6.889  27.362  39.807  1.00 68.39           C  
ATOM   3967  OD1 ASN A 472       5.947  26.569  39.744  1.00 72.29           O  
ATOM   3968  ND2 ASN A 472       7.886  27.339  38.933  1.00 68.86           N  
ATOM   3969  N   VAL A 473       5.790  30.575  42.738  1.00 64.33           N  
ATOM   3970  CA  VAL A 473       6.095  31.819  43.418  1.00 63.56           C  
ATOM   3971  C   VAL A 473       5.273  31.888  44.678  1.00 63.66           C  
ATOM   3972  O   VAL A 473       5.767  32.249  45.757  1.00 64.35           O  
ATOM   3973  CB  VAL A 473       5.709  33.047  42.527  1.00 63.77           C  
ATOM   3974  CG1 VAL A 473       5.847  34.370  43.272  1.00 62.33           C  
ATOM   3975  CG2 VAL A 473       6.531  33.087  41.253  1.00 63.88           C  
ATOM   3976  N   ALA A 474       3.995  31.563  44.538  1.00 63.03           N  
ATOM   3977  CA  ALA A 474       3.082  31.599  45.656  1.00 61.82           C  
ATOM   3978  C   ALA A 474       3.608  30.700  46.776  1.00 61.50           C  
ATOM   3979  O   ALA A 474       3.541  31.075  47.947  1.00 61.26           O  
ATOM   3980  CB  ALA A 474       1.728  31.164  45.216  1.00 61.51           C  
ATOM   3981  N   GLU A 475       4.161  29.538  46.424  1.00 60.86           N  
ATOM   3982  CA  GLU A 475       4.615  28.610  47.463  1.00 61.00           C  
ATOM   3983  C   GLU A 475       5.720  29.215  48.334  1.00 60.52           C  
ATOM   3984  O   GLU A 475       5.704  29.070  49.569  1.00 60.93           O  
ATOM   3985  CB  GLU A 475       5.050  27.260  46.893  1.00 60.97           C  
ATOM   3986  CG  GLU A 475       5.724  26.344  47.906  1.00 60.78           C  
ATOM   3987  CD  GLU A 475       6.142  25.004  47.309  1.00 62.14           C  
ATOM   3988  OE1 GLU A 475       6.238  24.877  46.063  1.00 63.24           O  
ATOM   3989  OE2 GLU A 475       6.362  24.061  48.090  1.00 63.26           O  
ATOM   3990  N   GLN A 476       6.646  29.923  47.687  1.00 59.34           N  
ATOM   3991  CA  GLN A 476       7.771  30.552  48.357  1.00 57.66           C  
ATOM   3992  C   GLN A 476       7.382  31.793  49.050  1.00 56.90           C  
ATOM   3993  O   GLN A 476       7.784  32.030  50.188  1.00 56.21           O  
ATOM   3994  CB  GLN A 476       8.762  30.976  47.337  1.00 57.61           C  
ATOM   3995  CG  GLN A 476       9.770  29.967  47.104  1.00 58.21           C  
ATOM   3996  CD  GLN A 476      10.458  30.271  45.858  1.00 60.11           C  
ATOM   3997  OE1 GLN A 476      10.630  31.447  45.495  1.00 60.12           O  
ATOM   3998  NE2 GLN A 476      10.849  29.226  45.149  1.00 61.91           N  
ATOM   3999  N   VAL A 477       6.635  32.619  48.328  1.00 56.60           N  
ATOM   4000  CA  VAL A 477       6.225  33.901  48.878  1.00 56.10           C  
ATOM   4001  C   VAL A 477       5.558  33.672  50.214  1.00 56.34           C  
ATOM   4002  O   VAL A 477       5.834  34.401  51.136  1.00 56.44           O  
ATOM   4003  CB  VAL A 477       5.326  34.728  47.931  1.00 55.58           C  
ATOM   4004  CG1 VAL A 477       4.830  35.968  48.657  1.00 52.91           C  
ATOM   4005  CG2 VAL A 477       6.100  35.112  46.679  1.00 53.74           C  
ATOM   4006  N   LEU A 478       4.733  32.631  50.319  1.00 56.71           N  
ATOM   4007  CA  LEU A 478       4.083  32.268  51.579  1.00 57.47           C  
ATOM   4008  C   LEU A 478       5.058  31.887  52.694  1.00 57.81           C  
ATOM   4009  O   LEU A 478       5.019  32.458  53.795  1.00 58.10           O  
ATOM   4010  CB  LEU A 478       3.108  31.124  51.350  1.00 57.86           C  
ATOM   4011  CG  LEU A 478       1.768  31.480  50.710  1.00 58.25           C  
ATOM   4012  CD1 LEU A 478       1.174  30.245  50.016  1.00 57.10           C  
ATOM   4013  CD2 LEU A 478       0.858  32.030  51.794  1.00 57.79           C  
ATOM   4014  N   ALA A 479       5.919  30.918  52.398  1.00 57.91           N  
ATOM   4015  CA  ALA A 479       6.987  30.518  53.290  1.00 57.96           C  
ATOM   4016  C   ALA A 479       7.755  31.729  53.789  1.00 58.50           C  
ATOM   4017  O   ALA A 479       7.700  32.049  54.986  1.00 59.02           O  
ATOM   4018  CB  ALA A 479       7.908  29.586  52.578  1.00 58.10           C  
ATOM   4019  N   LYS A 480       8.484  32.375  52.877  1.00 58.92           N  
ATOM   4020  CA  LYS A 480       9.155  33.654  53.116  1.00 59.87           C  
ATOM   4021  C   LYS A 480       8.451  34.574  54.122  1.00 60.50           C  
ATOM   4022  O   LYS A 480       9.088  35.179  54.985  1.00 61.18           O  
ATOM   4023  CB  LYS A 480       9.238  34.438  51.799  1.00 60.38           C  
ATOM   4024  CG  LYS A 480      10.413  34.132  50.926  1.00 60.71           C  
ATOM   4025  CD  LYS A 480      10.241  34.759  49.583  1.00 59.28           C  
ATOM   4026  CE  LYS A 480      10.683  33.750  48.578  1.00 60.80           C  
ATOM   4027  NZ  LYS A 480      11.181  34.304  47.311  1.00 63.49           N  
ATOM   4028  N   THR A 481       7.142  34.712  54.006  1.00 60.76           N  
ATOM   4029  CA  THR A 481       6.474  35.671  54.834  1.00 61.71           C  
ATOM   4030  C   THR A 481       6.029  35.139  56.199  1.00 61.76           C  
ATOM   4031  O   THR A 481       5.593  35.886  57.047  1.00 60.97           O  
ATOM   4032  CB  THR A 481       5.341  36.319  54.073  1.00 62.17           C  
ATOM   4033  OG1 THR A 481       5.892  37.019  52.947  1.00 62.13           O  
ATOM   4034  CG2 THR A 481       4.657  37.333  54.973  1.00 64.17           C  
ATOM   4035  N   GLY A 482       6.177  33.841  56.402  1.00 63.07           N  
ATOM   4036  CA  GLY A 482       5.881  33.208  57.680  1.00 64.08           C  
ATOM   4037  C   GLY A 482       4.513  32.566  57.640  1.00 64.71           C  
ATOM   4038  O   GLY A 482       3.791  32.512  58.646  1.00 65.27           O  
ATOM   4039  N   ASN A 483       4.119  32.106  56.468  1.00 64.81           N  
ATOM   4040  CA  ASN A 483       2.804  31.537  56.372  1.00 65.45           C  
ATOM   4041  C   ASN A 483       2.887  30.122  55.847  1.00 65.72           C  
ATOM   4042  O   ASN A 483       1.906  29.568  55.384  1.00 66.81           O  
ATOM   4043  CB  ASN A 483       1.860  32.431  55.555  1.00 65.32           C  
ATOM   4044  CG  ASN A 483       1.850  33.872  56.045  1.00 65.66           C  
ATOM   4045  OD1 ASN A 483       1.074  34.255  56.923  1.00 65.42           O  
ATOM   4046  ND2 ASN A 483       2.724  34.680  55.467  1.00 67.27           N  
ATOM   4047  N   ILE A 484       4.082  29.553  55.883  1.00 65.42           N  
ATOM   4048  CA  ILE A 484       4.240  28.113  55.834  1.00 64.80           C  
ATOM   4049  C   ILE A 484       2.942  27.476  55.346  1.00 64.62           C  
ATOM   4050  O   ILE A 484       2.042  27.216  56.146  1.00 65.28           O  
ATOM   4051  CB  ILE A 484       4.690  27.628  57.248  1.00 64.78           C  
ATOM   4052  CG1 ILE A 484       6.193  27.902  57.405  1.00 64.72           C  
ATOM   4053  CG2 ILE A 484       4.380  26.145  57.509  1.00 64.09           C  
ATOM   4054  CD1 ILE A 484       6.614  28.693  58.678  1.00 64.84           C  
ATOM   4055  N   PRO A 485       2.840  27.230  54.028  1.00 64.20           N  
ATOM   4056  CA  PRO A 485       1.655  26.740  53.314  1.00 64.19           C  
ATOM   4057  C   PRO A 485       1.402  25.260  53.582  1.00 64.54           C  
ATOM   4058  O   PRO A 485       0.544  24.643  52.924  1.00 64.54           O  
ATOM   4059  CB  PRO A 485       2.067  26.873  51.841  1.00 63.84           C  
ATOM   4060  CG  PRO A 485       3.514  26.627  51.861  1.00 63.24           C  
ATOM   4061  CD  PRO A 485       3.988  27.354  53.114  1.00 64.20           C  
ATOM   4062  N   TYR A 486       2.229  24.696  54.464  1.00 64.61           N  
ATOM   4063  CA  TYR A 486       2.126  23.332  54.948  1.00 64.77           C  
ATOM   4064  C   TYR A 486       3.266  23.030  55.900  1.00 65.46           C  
ATOM   4065  O   TYR A 486       4.331  23.658  55.819  1.00 65.59           O  
ATOM   4066  CB  TYR A 486       2.109  22.319  53.819  1.00 64.20           C  
ATOM   4067  CG  TYR A 486       3.219  22.452  52.820  1.00 63.84           C  
ATOM   4068  CD1 TYR A 486       4.468  21.873  53.040  1.00 65.24           C  
ATOM   4069  CD2 TYR A 486       3.002  23.087  51.625  1.00 63.37           C  
ATOM   4070  CE1 TYR A 486       5.477  21.965  52.085  1.00 63.87           C  
ATOM   4071  CE2 TYR A 486       3.991  23.187  50.683  1.00 63.77           C  
ATOM   4072  CZ  TYR A 486       5.218  22.637  50.919  1.00 63.17           C  
ATOM   4073  OH  TYR A 486       6.167  22.774  49.963  1.00 63.45           O  
ATOM   4074  N   LYS A 487       3.008  22.088  56.814  1.00 66.08           N  
ATOM   4075  CA  LYS A 487       3.977  21.595  57.798  1.00 66.17           C  
ATOM   4076  C   LYS A 487       4.227  20.109  57.496  1.00 66.60           C  
ATOM   4077  O   LYS A 487       3.470  19.465  56.757  1.00 66.54           O  
ATOM   4078  CB  LYS A 487       3.427  21.778  59.230  1.00 66.21           C  
ATOM   4079  CG  LYS A 487       3.278  23.255  59.707  1.00 66.23           C  
ATOM   4080  CD  LYS A 487       2.693  23.453  61.138  1.00 65.63           C  
ATOM   4081  CE  LYS A 487       3.029  24.866  61.700  1.00 66.95           C  
ATOM   4082  NZ  LYS A 487       1.970  25.668  62.506  1.00 66.19           N  
ATOM   4083  N   LEU A 488       5.302  19.560  58.039  1.00 67.26           N  
ATOM   4084  CA  LEU A 488       5.478  18.104  58.013  1.00 68.01           C  
ATOM   4085  C   LEU A 488       4.660  17.382  59.134  1.00 69.12           C  
ATOM   4086  O   LEU A 488       4.533  17.863  60.297  1.00 68.96           O  
ATOM   4087  CB  LEU A 488       6.960  17.749  58.138  1.00 67.36           C  
ATOM   4088  CG  LEU A 488       7.861  17.754  56.913  1.00 66.71           C  
ATOM   4089  CD1 LEU A 488       9.214  18.268  57.333  1.00 66.16           C  
ATOM   4090  CD2 LEU A 488       7.974  16.370  56.287  1.00 66.66           C  
ATOM   4091  N   LYS A 489       4.107  16.228  58.774  1.00 69.76           N  
ATOM   4092  CA  LYS A 489       3.453  15.371  59.736  1.00 70.54           C  
ATOM   4093  C   LYS A 489       4.483  14.944  60.759  1.00 70.85           C  
ATOM   4094  O   LYS A 489       4.280  15.081  61.970  1.00 70.93           O  
ATOM   4095  CB  LYS A 489       2.883  14.155  59.010  1.00 70.72           C  
ATOM   4096  CG  LYS A 489       1.782  13.430  59.755  1.00 72.73           C  
ATOM   4097  CD  LYS A 489       0.990  12.513  58.826  1.00 75.18           C  
ATOM   4098  CE  LYS A 489      -0.117  11.793  59.590  1.00 77.58           C  
ATOM   4099  NZ  LYS A 489      -0.054  10.311  59.381  1.00 78.29           N  
ATOM   4100  N   GLU A 490       5.610  14.466  60.243  1.00 71.66           N  
ATOM   4101  CA  GLU A 490       6.649  13.801  61.029  1.00 73.02           C  
ATOM   4102  C   GLU A 490       7.960  13.616  60.253  1.00 72.90           C  
ATOM   4103  O   GLU A 490       7.979  13.545  59.024  1.00 72.85           O  
ATOM   4104  CB  GLU A 490       6.157  12.415  61.509  1.00 73.30           C  
ATOM   4105  CG  GLU A 490       5.378  11.610  60.421  1.00 73.69           C  
ATOM   4106  CD  GLU A 490       4.998  10.188  60.837  1.00 74.52           C  
ATOM   4107  OE1 GLU A 490       4.938   9.339  59.933  1.00 77.30           O  
ATOM   4108  OE2 GLU A 490       4.738   9.902  62.036  1.00 76.64           O  
ATOM   4109  N   ILE A 491       9.044  13.536  61.008  1.00 73.16           N  
ATOM   4110  CA  ILE A 491      10.332  13.133  60.514  1.00 73.70           C  
ATOM   4111  C   ILE A 491      10.723  11.936  61.366  1.00 74.01           C  
ATOM   4112  O   ILE A 491      10.529  11.952  62.578  1.00 74.49           O  
ATOM   4113  CB  ILE A 491      11.362  14.258  60.729  1.00 73.70           C  
ATOM   4114  CG1 ILE A 491      10.797  15.605  60.271  1.00 74.25           C  
ATOM   4115  CG2 ILE A 491      12.700  13.955  60.038  1.00 73.04           C  
ATOM   4116  CD1 ILE A 491      11.593  16.838  60.788  1.00 74.65           C  
ATOM   4117  N   GLU A 492      11.269  10.902  60.743  1.00 74.45           N  
ATOM   4118  CA  GLU A 492      11.761   9.741  61.459  1.00 75.77           C  
ATOM   4119  C   GLU A 492      12.789   9.994  62.536  1.00 75.77           C  
ATOM   4120  O   GLU A 492      13.702  10.804  62.373  1.00 75.83           O  
ATOM   4121  CB  GLU A 492      12.385   8.773  60.502  1.00 76.33           C  
ATOM   4122  CG  GLU A 492      11.392   7.885  59.882  1.00 80.63           C  
ATOM   4123  CD  GLU A 492      12.050   6.983  58.884  1.00 86.61           C  
ATOM   4124  OE1 GLU A 492      12.899   6.181  59.357  1.00 87.62           O  
ATOM   4125  OE2 GLU A 492      11.728   7.094  57.653  1.00 88.49           O  
ATOM   4126  N   GLY A 493      12.654   9.225  63.613  1.00 75.93           N  
ATOM   4127  CA  GLY A 493      13.481   9.358  64.810  1.00 76.14           C  
ATOM   4128  C   GLY A 493      12.707  10.100  65.885  1.00 76.25           C  
ATOM   4129  O   GLY A 493      11.543  10.480  65.696  1.00 76.15           O  
ATOM   4130  N   LYS A 494      13.347  10.328  67.014  1.00 76.07           N  
ATOM   4131  CA  LYS A 494      12.718  11.154  68.001  1.00 76.67           C  
ATOM   4132  C   LYS A 494      13.627  12.321  68.330  1.00 76.51           C  
ATOM   4133  O   LYS A 494      13.927  12.632  69.491  1.00 77.30           O  
ATOM   4134  CB  LYS A 494      12.277  10.320  69.206  1.00 77.38           C  
ATOM   4135  CG  LYS A 494      11.119   9.394  68.813  1.00 79.13           C  
ATOM   4136  CD  LYS A 494      10.921   8.268  69.788  1.00 81.70           C  
ATOM   4137  CE  LYS A 494      10.381   7.045  69.061  1.00 81.60           C  
ATOM   4138  NZ  LYS A 494      10.567   5.862  69.956  1.00 81.91           N  
ATOM   4139  N   VAL A 495      14.059  12.976  67.271  1.00 75.77           N  
ATOM   4140  CA  VAL A 495      14.802  14.197  67.394  1.00 74.99           C  
ATOM   4141  C   VAL A 495      13.889  15.264  67.951  1.00 74.63           C  
ATOM   4142  O   VAL A 495      12.685  15.262  67.686  1.00 74.56           O  
ATOM   4143  CB  VAL A 495      15.267  14.627  66.050  1.00 74.62           C  
ATOM   4144  CG1 VAL A 495      16.236  15.745  66.190  1.00 74.82           C  
ATOM   4145  CG2 VAL A 495      15.930  13.467  65.400  1.00 75.45           C  
ATOM   4146  N   ASP A 496      14.471  16.172  68.728  1.00 74.13           N  
ATOM   4147  CA  ASP A 496      13.721  17.287  69.316  1.00 73.35           C  
ATOM   4148  C   ASP A 496      14.104  18.637  68.741  1.00 72.12           C  
ATOM   4149  O   ASP A 496      13.326  19.586  68.856  1.00 71.81           O  
ATOM   4150  CB  ASP A 496      13.869  17.291  70.838  1.00 73.62           C  
ATOM   4151  CG  ASP A 496      13.323  16.021  71.478  1.00 75.11           C  
ATOM   4152  OD1 ASP A 496      12.501  15.299  70.833  1.00 74.99           O  
ATOM   4153  OD2 ASP A 496      13.724  15.751  72.635  1.00 77.57           O  
ATOM   4154  N   ALA A 497      15.302  18.703  68.146  1.00 70.87           N  
ATOM   4155  CA  ALA A 497      15.777  19.870  67.383  1.00 70.04           C  
ATOM   4156  C   ALA A 497      16.698  19.498  66.220  1.00 69.54           C  
ATOM   4157  O   ALA A 497      17.424  18.504  66.266  1.00 69.87           O  
ATOM   4158  CB  ALA A 497      16.472  20.861  68.284  1.00 69.98           C  
ATOM   4159  N   PHE A 498      16.671  20.312  65.171  1.00 68.66           N  
ATOM   4160  CA  PHE A 498      17.560  20.124  64.033  1.00 66.79           C  
ATOM   4161  C   PHE A 498      18.275  21.412  63.852  1.00 65.95           C  
ATOM   4162  O   PHE A 498      17.655  22.441  63.637  1.00 66.07           O  
ATOM   4163  CB  PHE A 498      16.778  19.797  62.784  1.00 66.23           C  
ATOM   4164  CG  PHE A 498      16.276  18.386  62.748  1.00 66.75           C  
ATOM   4165  CD1 PHE A 498      14.954  18.089  63.110  1.00 66.92           C  
ATOM   4166  CD2 PHE A 498      17.111  17.348  62.358  1.00 65.38           C  
ATOM   4167  CE1 PHE A 498      14.478  16.788  63.086  1.00 64.30           C  
ATOM   4168  CE2 PHE A 498      16.639  16.054  62.333  1.00 64.55           C  
ATOM   4169  CZ  PHE A 498      15.312  15.779  62.698  1.00 64.37           C  
ATOM   4170  N   VAL A 499      19.588  21.348  63.967  1.00 65.11           N  
ATOM   4171  CA  VAL A 499      20.411  22.533  63.943  1.00 64.26           C  
ATOM   4172  C   VAL A 499      21.344  22.627  62.731  1.00 64.24           C  
ATOM   4173  O   VAL A 499      22.279  21.827  62.578  1.00 64.57           O  
ATOM   4174  CB  VAL A 499      21.212  22.605  65.211  1.00 63.63           C  
ATOM   4175  CG1 VAL A 499      22.026  23.856  65.231  1.00 63.85           C  
ATOM   4176  CG2 VAL A 499      20.278  22.606  66.340  1.00 63.21           C  
ATOM   4177  N   GLY A 500      21.091  23.613  61.878  1.00 63.65           N  
ATOM   4178  CA  GLY A 500      22.021  23.922  60.813  1.00 63.78           C  
ATOM   4179  C   GLY A 500      23.125  24.821  61.317  1.00 64.06           C  
ATOM   4180  O   GLY A 500      22.866  25.788  62.025  1.00 64.66           O  
ATOM   4181  N   ILE A 501      24.361  24.515  60.947  1.00 64.12           N  
ATOM   4182  CA  ILE A 501      25.507  25.305  61.391  1.00 64.24           C  
ATOM   4183  C   ILE A 501      26.342  25.758  60.208  1.00 64.43           C  
ATOM   4184  O   ILE A 501      26.775  24.917  59.414  1.00 64.47           O  
ATOM   4185  CB  ILE A 501      26.300  24.498  62.469  1.00 64.21           C  
ATOM   4186  CG1 ILE A 501      26.155  25.202  63.794  1.00 64.61           C  
ATOM   4187  CG2 ILE A 501      27.767  24.267  62.152  1.00 63.72           C  
ATOM   4188  CD1 ILE A 501      25.683  24.272  64.866  1.00 66.45           C  
ATOM   4189  N   ASP A 502      26.524  27.070  60.060  1.00 64.60           N  
ATOM   4190  CA  ASP A 502      27.464  27.575  59.072  1.00 65.71           C  
ATOM   4191  C   ASP A 502      28.345  28.690  59.570  1.00 66.12           C  
ATOM   4192  O   ASP A 502      27.879  29.590  60.257  1.00 66.79           O  
ATOM   4193  CB  ASP A 502      26.755  28.042  57.808  1.00 66.39           C  
ATOM   4194  CG  ASP A 502      27.659  27.953  56.555  1.00 68.82           C  
ATOM   4195  OD1 ASP A 502      27.969  26.796  56.094  1.00 69.81           O  
ATOM   4196  OD2 ASP A 502      28.044  29.039  56.038  1.00 70.27           O  
ATOM   4197  N   ILE A 503      29.620  28.642  59.191  1.00 66.90           N  
ATOM   4198  CA  ILE A 503      30.611  29.645  59.598  1.00 67.37           C  
ATOM   4199  C   ILE A 503      31.611  29.978  58.471  1.00 67.96           C  
ATOM   4200  O   ILE A 503      32.189  29.090  57.870  1.00 68.44           O  
ATOM   4201  CB  ILE A 503      31.372  29.184  60.856  1.00 66.96           C  
ATOM   4202  CG1 ILE A 503      30.373  28.711  61.925  1.00 67.44           C  
ATOM   4203  CG2 ILE A 503      32.212  30.343  61.387  1.00 67.82           C  
ATOM   4204  CD1 ILE A 503      30.868  27.704  62.978  1.00 67.16           C  
ATOM   4205  N   SER A 504      31.795  31.255  58.174  1.00 68.83           N  
ATOM   4206  CA  SER A 504      32.865  31.684  57.278  1.00 70.23           C  
ATOM   4207  C   SER A 504      33.765  32.661  58.004  1.00 71.16           C  
ATOM   4208  O   SER A 504      33.325  33.357  58.917  1.00 71.45           O  
ATOM   4209  CB  SER A 504      32.307  32.378  56.036  1.00 70.27           C  
ATOM   4210  OG  SER A 504      31.219  31.678  55.469  1.00 71.77           O  
ATOM   4211  N   ARG A 505      35.018  32.749  57.589  1.00 72.48           N  
ATOM   4212  CA  ARG A 505      35.951  33.665  58.255  1.00 73.91           C  
ATOM   4213  C   ARG A 505      36.904  34.362  57.269  1.00 74.94           C  
ATOM   4214  O   ARG A 505      37.593  33.711  56.494  1.00 75.65           O  
ATOM   4215  CB  ARG A 505      36.735  32.899  59.333  1.00 73.66           C  
ATOM   4216  CG  ARG A 505      37.162  31.491  58.885  1.00 73.98           C  
ATOM   4217  CD  ARG A 505      37.833  30.700  59.994  1.00 73.74           C  
ATOM   4218  NE  ARG A 505      36.954  29.683  60.583  1.00 72.90           N  
ATOM   4219  CZ  ARG A 505      37.171  29.114  61.768  1.00 72.90           C  
ATOM   4220  NH1 ARG A 505      38.234  29.464  62.499  1.00 73.39           N  
ATOM   4221  NH2 ARG A 505      36.326  28.205  62.233  1.00 72.14           N  
ATOM   4222  N   ILE A 506      36.938  35.682  57.278  1.00 76.05           N  
ATOM   4223  CA  ILE A 506      37.991  36.391  56.550  1.00 77.58           C  
ATOM   4224  C   ILE A 506      39.374  36.094  57.179  1.00 78.74           C  
ATOM   4225  O   ILE A 506      39.464  35.737  58.362  1.00 79.04           O  
ATOM   4226  CB  ILE A 506      37.692  37.910  56.458  1.00 77.37           C  
ATOM   4227  CG1 ILE A 506      36.686  38.158  55.323  1.00 77.19           C  
ATOM   4228  CG2 ILE A 506      38.971  38.708  56.242  1.00 76.88           C  
ATOM   4229  CD1 ILE A 506      35.861  39.425  55.461  1.00 75.24           C  
ATOM   4230  N   THR A 507      40.441  36.218  56.386  1.00 79.82           N  
ATOM   4231  CA  THR A 507      41.784  35.850  56.845  1.00 80.93           C  
ATOM   4232  C   THR A 507      42.888  36.815  56.350  1.00 82.06           C  
ATOM   4233  O   THR A 507      42.825  37.328  55.233  1.00 82.51           O  
ATOM   4234  CB  THR A 507      42.086  34.387  56.457  1.00 80.79           C  
ATOM   4235  OG1 THR A 507      40.979  33.568  56.851  1.00 80.30           O  
ATOM   4236  CG2 THR A 507      43.356  33.863  57.123  1.00 80.35           C  
ATOM   4237  N   ARG A 508      43.871  37.082  57.210  1.00 83.08           N  
ATOM   4238  CA  ARG A 508      45.066  37.865  56.870  1.00 84.01           C  
ATOM   4239  C   ARG A 508      46.300  37.110  57.378  1.00 84.20           C  
ATOM   4240  O   ARG A 508      46.202  36.353  58.359  1.00 83.97           O  
ATOM   4241  CB  ARG A 508      45.025  39.252  57.522  1.00 84.04           C  
ATOM   4242  CG  ARG A 508      44.008  40.238  56.972  1.00 84.76           C  
ATOM   4243  CD  ARG A 508      44.373  41.667  57.419  1.00 85.02           C  
ATOM   4244  NE  ARG A 508      43.201  42.425  57.867  1.00 87.72           N  
ATOM   4245  CZ  ARG A 508      43.116  43.757  57.912  1.00 88.50           C  
ATOM   4246  NH1 ARG A 508      44.139  44.515  57.524  1.00 88.85           N  
ATOM   4247  NH2 ARG A 508      41.995  44.334  58.345  1.00 88.69           N  
ATOM   4248  N   ASP A 509      47.453  37.345  56.738  1.00 84.67           N  
ATOM   4249  CA  ASP A 509      48.707  36.589  56.977  1.00 85.18           C  
ATOM   4250  C   ASP A 509      48.404  35.105  56.935  1.00 85.45           C  
ATOM   4251  O   ASP A 509      48.578  34.469  55.896  1.00 85.69           O  
ATOM   4252  CB  ASP A 509      49.392  36.929  58.317  1.00 85.36           C  
ATOM   4253  CG  ASP A 509      49.155  38.370  58.777  1.00 85.55           C  
ATOM   4254  OD1 ASP A 509      49.061  39.276  57.918  1.00 85.47           O  
ATOM   4255  OD2 ASP A 509      49.073  38.590  60.012  1.00 85.69           O  
ATOM   4256  N   GLY A 510      47.949  34.571  58.074  1.00 85.64           N  
ATOM   4257  CA  GLY A 510      47.411  33.205  58.185  1.00 85.71           C  
ATOM   4258  C   GLY A 510      46.583  33.067  59.457  1.00 85.74           C  
ATOM   4259  O   GLY A 510      46.657  32.043  60.147  1.00 85.75           O  
ATOM   4260  N   LYS A 511      45.791  34.105  59.753  1.00 85.59           N  
ATOM   4261  CA  LYS A 511      45.052  34.251  61.027  1.00 85.27           C  
ATOM   4262  C   LYS A 511      43.546  34.622  60.838  1.00 85.19           C  
ATOM   4263  O   LYS A 511      43.205  35.463  59.995  1.00 85.51           O  
ATOM   4264  CB  LYS A 511      45.764  35.286  61.923  1.00 84.97           C  
ATOM   4265  CG  LYS A 511      47.276  35.091  62.011  1.00 84.72           C  
ATOM   4266  CD  LYS A 511      47.938  36.100  62.922  1.00 84.91           C  
ATOM   4267  CE  LYS A 511      49.385  35.718  63.216  1.00 84.41           C  
ATOM   4268  NZ  LYS A 511      49.809  36.160  64.576  1.00 83.31           N  
ATOM   4269  N   THR A 512      42.654  33.991  61.611  1.00 84.46           N  
ATOM   4270  CA  THR A 512      41.221  34.331  61.609  1.00 83.57           C  
ATOM   4271  C   THR A 512      40.989  35.772  62.086  1.00 82.70           C  
ATOM   4272  O   THR A 512      41.299  36.103  63.243  1.00 82.86           O  
ATOM   4273  CB  THR A 512      40.418  33.345  62.495  1.00 83.87           C  
ATOM   4274  OG1 THR A 512      40.079  32.174  61.732  1.00 84.34           O  
ATOM   4275  CG2 THR A 512      39.141  34.001  63.038  1.00 84.08           C  
ATOM   4276  N   VAL A 513      40.451  36.620  61.202  1.00 81.37           N  
ATOM   4277  CA  VAL A 513      40.227  38.056  61.529  1.00 79.93           C  
ATOM   4278  C   VAL A 513      38.740  38.401  61.835  1.00 78.60           C  
ATOM   4279  O   VAL A 513      38.367  38.573  62.994  1.00 78.76           O  
ATOM   4280  CB  VAL A 513      40.872  39.043  60.460  1.00 80.14           C  
ATOM   4281  CG1 VAL A 513      40.679  40.516  60.858  1.00 80.30           C  
ATOM   4282  CG2 VAL A 513      42.358  38.762  60.258  1.00 79.58           C  
ATOM   4283  N   ASN A 514      37.917  38.531  60.793  1.00 76.65           N  
ATOM   4284  CA  ASN A 514      36.478  38.716  60.915  1.00 74.33           C  
ATOM   4285  C   ASN A 514      35.937  37.291  60.885  1.00 72.76           C  
ATOM   4286  O   ASN A 514      36.686  36.372  60.559  1.00 72.65           O  
ATOM   4287  CB  ASN A 514      35.999  39.550  59.711  1.00 74.48           C  
ATOM   4288  CG  ASN A 514      34.509  39.945  59.777  1.00 75.28           C  
ATOM   4289  OD1 ASN A 514      33.799  39.650  60.745  1.00 77.33           O  
ATOM   4290  ND2 ASN A 514      34.039  40.628  58.730  1.00 74.68           N  
ATOM   4291  N   ALA A 515      34.674  37.091  61.248  1.00 70.93           N  
ATOM   4292  CA  ALA A 515      33.988  35.794  61.085  1.00 69.24           C  
ATOM   4293  C   ALA A 515      32.494  35.980  61.252  1.00 68.40           C  
ATOM   4294  O   ALA A 515      32.070  36.670  62.176  1.00 68.42           O  
ATOM   4295  CB  ALA A 515      34.485  34.773  62.092  1.00 69.15           C  
ATOM   4296  N   VAL A 516      31.700  35.371  60.360  1.00 67.36           N  
ATOM   4297  CA  VAL A 516      30.225  35.400  60.454  1.00 66.02           C  
ATOM   4298  C   VAL A 516      29.638  33.973  60.575  1.00 65.29           C  
ATOM   4299  O   VAL A 516      29.949  33.087  59.772  1.00 64.26           O  
ATOM   4300  CB  VAL A 516      29.532  36.203  59.277  1.00 66.08           C  
ATOM   4301  CG1 VAL A 516      28.098  36.543  59.631  1.00 65.39           C  
ATOM   4302  CG2 VAL A 516      30.268  37.494  58.946  1.00 65.61           C  
ATOM   4303  N   ALA A 517      28.797  33.783  61.599  1.00 64.71           N  
ATOM   4304  CA  ALA A 517      28.155  32.489  61.909  1.00 64.18           C  
ATOM   4305  C   ALA A 517      26.686  32.572  61.638  1.00 63.69           C  
ATOM   4306  O   ALA A 517      26.079  33.633  61.848  1.00 64.06           O  
ATOM   4307  CB  ALA A 517      28.352  32.118  63.370  1.00 64.26           C  
ATOM   4308  N   PHE A 518      26.107  31.451  61.218  1.00 62.46           N  
ATOM   4309  CA  PHE A 518      24.716  31.431  60.867  1.00 61.59           C  
ATOM   4310  C   PHE A 518      24.118  30.111  61.214  1.00 60.97           C  
ATOM   4311  O   PHE A 518      24.461  29.093  60.630  1.00 61.57           O  
ATOM   4312  CB  PHE A 518      24.573  31.690  59.384  1.00 61.84           C  
ATOM   4313  CG  PHE A 518      23.152  31.859  58.928  1.00 62.80           C  
ATOM   4314  CD1 PHE A 518      22.240  32.582  59.684  1.00 62.72           C  
ATOM   4315  CD2 PHE A 518      22.732  31.315  57.714  1.00 63.66           C  
ATOM   4316  CE1 PHE A 518      20.925  32.741  59.253  1.00 62.28           C  
ATOM   4317  CE2 PHE A 518      21.419  31.478  57.271  1.00 64.19           C  
ATOM   4318  CZ  PHE A 518      20.513  32.205  58.046  1.00 62.34           C  
ATOM   4319  N   THR A 519      23.191  30.141  62.149  1.00 60.16           N  
ATOM   4320  CA  THR A 519      22.687  28.937  62.773  1.00 59.90           C  
ATOM   4321  C   THR A 519      21.167  28.960  62.639  1.00 59.64           C  
ATOM   4322  O   THR A 519      20.566  30.009  62.797  1.00 59.95           O  
ATOM   4323  CB  THR A 519      23.129  28.889  64.309  1.00 60.32           C  
ATOM   4324  OG1 THR A 519      24.542  29.121  64.450  1.00 59.10           O  
ATOM   4325  CG2 THR A 519      22.760  27.569  64.987  1.00 59.75           C  
ATOM   4326  N   LYS A 520      20.524  27.836  62.348  1.00 59.39           N  
ATOM   4327  CA  LYS A 520      19.067  27.866  62.235  1.00 59.29           C  
ATOM   4328  C   LYS A 520      18.494  26.649  62.876  1.00 59.59           C  
ATOM   4329  O   LYS A 520      18.762  25.542  62.417  1.00 59.70           O  
ATOM   4330  CB  LYS A 520      18.579  27.846  60.787  1.00 59.59           C  
ATOM   4331  CG  LYS A 520      19.322  28.663  59.756  1.00 59.25           C  
ATOM   4332  CD  LYS A 520      18.719  28.357  58.433  1.00 59.13           C  
ATOM   4333  CE  LYS A 520      19.760  28.259  57.375  1.00 62.38           C  
ATOM   4334  NZ  LYS A 520      19.238  27.498  56.186  1.00 64.95           N  
ATOM   4335  N   ILE A 521      17.642  26.872  63.877  1.00 59.73           N  
ATOM   4336  CA  ILE A 521      17.068  25.817  64.710  1.00 59.61           C  
ATOM   4337  C   ILE A 521      15.618  25.497  64.316  1.00 60.19           C  
ATOM   4338  O   ILE A 521      14.757  26.386  64.252  1.00 59.58           O  
ATOM   4339  CB  ILE A 521      17.174  26.201  66.210  1.00 59.22           C  
ATOM   4340  CG1 ILE A 521      18.642  26.287  66.613  1.00 58.44           C  
ATOM   4341  CG2 ILE A 521      16.425  25.211  67.094  1.00 58.98           C  
ATOM   4342  CD1 ILE A 521      18.966  27.226  67.738  1.00 54.96           C  
ATOM   4343  N   PHE A 522      15.378  24.216  64.048  1.00 61.11           N  
ATOM   4344  CA  PHE A 522      14.062  23.702  63.680  1.00 62.28           C  
ATOM   4345  C   PHE A 522      13.532  22.740  64.719  1.00 63.44           C  
ATOM   4346  O   PHE A 522      14.304  21.952  65.301  1.00 63.62           O  
ATOM   4347  CB  PHE A 522      14.153  22.896  62.407  1.00 61.70           C  
ATOM   4348  CG  PHE A 522      14.433  23.704  61.192  1.00 62.21           C  
ATOM   4349  CD1 PHE A 522      15.722  24.123  60.900  1.00 62.56           C  
ATOM   4350  CD2 PHE A 522      13.406  24.029  60.314  1.00 61.67           C  
ATOM   4351  CE1 PHE A 522      15.974  24.859  59.763  1.00 61.69           C  
ATOM   4352  CE2 PHE A 522      13.657  24.748  59.174  1.00 60.04           C  
ATOM   4353  CZ  PHE A 522      14.930  25.159  58.892  1.00 60.58           C  
ATOM   4354  N   ASN A 523      12.211  22.761  64.910  1.00 64.42           N  
ATOM   4355  CA  ASN A 523      11.553  21.800  65.813  1.00 65.04           C  
ATOM   4356  C   ASN A 523      11.501  20.357  65.246  1.00 65.44           C  
ATOM   4357  O   ASN A 523      11.964  20.095  64.137  1.00 65.67           O  
ATOM   4358  CB  ASN A 523      10.172  22.320  66.286  1.00 64.91           C  
ATOM   4359  CG  ASN A 523       9.064  22.188  65.219  1.00 64.91           C  
ATOM   4360  OD1 ASN A 523       9.214  21.467  64.215  1.00 65.77           O  
ATOM   4361  ND2 ASN A 523       7.936  22.880  65.452  1.00 61.20           N  
ATOM   4362  N   SER A 524      10.934  19.437  66.014  1.00 65.77           N  
ATOM   4363  CA  SER A 524      10.959  18.027  65.678  1.00 66.12           C  
ATOM   4364  C   SER A 524      10.125  17.732  64.444  1.00 66.39           C  
ATOM   4365  O   SER A 524      10.311  16.694  63.808  1.00 66.75           O  
ATOM   4366  CB  SER A 524      10.436  17.203  66.846  1.00 66.20           C  
ATOM   4367  OG  SER A 524       9.024  17.042  66.754  1.00 66.91           O  
ATOM   4368  N   LYS A 525       9.189  18.626  64.140  1.00 66.21           N  
ATOM   4369  CA  LYS A 525       8.394  18.541  62.929  1.00 66.61           C  
ATOM   4370  C   LYS A 525       9.129  19.272  61.821  1.00 65.60           C  
ATOM   4371  O   LYS A 525       8.746  19.193  60.649  1.00 65.55           O  
ATOM   4372  CB  LYS A 525       7.065  19.260  63.125  1.00 66.82           C  
ATOM   4373  CG  LYS A 525       5.851  18.421  63.499  1.00 68.98           C  
ATOM   4374  CD  LYS A 525       4.578  19.333  63.478  1.00 68.79           C  
ATOM   4375  CE  LYS A 525       3.348  18.616  64.022  1.00 72.41           C  
ATOM   4376  NZ  LYS A 525       3.449  18.472  65.512  1.00 75.35           N  
ATOM   4377  N   GLY A 526      10.146  20.040  62.198  1.00 64.81           N  
ATOM   4378  CA  GLY A 526      10.882  20.840  61.221  1.00 64.09           C  
ATOM   4379  C   GLY A 526      10.265  22.171  60.793  1.00 63.48           C  
ATOM   4380  O   GLY A 526      10.557  22.648  59.685  1.00 62.50           O  
ATOM   4381  N   GLU A 527       9.397  22.744  61.646  1.00 62.65           N  
ATOM   4382  CA  GLU A 527       9.077  24.163  61.585  1.00 62.13           C  
ATOM   4383  C   GLU A 527      10.335  24.794  62.112  1.00 61.43           C  
ATOM   4384  O   GLU A 527      11.023  24.187  62.940  1.00 61.58           O  
ATOM   4385  CB  GLU A 527       7.940  24.558  62.524  1.00 62.40           C  
ATOM   4386  CG  GLU A 527       6.569  23.961  62.245  1.00 65.08           C  
ATOM   4387  CD  GLU A 527       5.742  23.732  63.532  1.00 68.78           C  
ATOM   4388  OE1 GLU A 527       5.185  24.696  64.092  1.00 68.79           O  
ATOM   4389  OE2 GLU A 527       5.648  22.571  63.993  1.00 70.82           O  
ATOM   4390  N   LEU A 528      10.650  25.992  61.618  1.00 60.59           N  
ATOM   4391  CA  LEU A 528      11.792  26.783  62.092  1.00 59.38           C  
ATOM   4392  C   LEU A 528      11.367  27.527  63.342  1.00 59.39           C  
ATOM   4393  O   LEU A 528      10.262  28.056  63.403  1.00 59.22           O  
ATOM   4394  CB  LEU A 528      12.281  27.763  61.021  1.00 58.33           C  
ATOM   4395  CG  LEU A 528      12.957  29.060  61.474  1.00 57.37           C  
ATOM   4396  CD1 LEU A 528      14.466  29.026  61.365  1.00 55.16           C  
ATOM   4397  CD2 LEU A 528      12.396  30.275  60.724  1.00 57.52           C  
ATOM   4398  N   VAL A 529      12.259  27.566  64.327  1.00 59.36           N  
ATOM   4399  CA  VAL A 529      11.945  28.079  65.634  1.00 59.24           C  
ATOM   4400  C   VAL A 529      12.589  29.438  65.770  1.00 59.51           C  
ATOM   4401  O   VAL A 529      11.943  30.397  66.196  1.00 60.72           O  
ATOM   4402  CB  VAL A 529      12.413  27.075  66.731  1.00 59.75           C  
ATOM   4403  CG1 VAL A 529      12.445  27.686  68.127  1.00 58.47           C  
ATOM   4404  CG2 VAL A 529      11.553  25.794  66.703  1.00 59.80           C  
ATOM   4405  N   ARG A 530      13.857  29.544  65.421  1.00 59.45           N  
ATOM   4406  CA  ARG A 530      14.527  30.850  65.375  1.00 60.37           C  
ATOM   4407  C   ARG A 530      15.783  30.668  64.537  1.00 59.70           C  
ATOM   4408  O   ARG A 530      16.222  29.532  64.357  1.00 60.27           O  
ATOM   4409  CB  ARG A 530      14.816  31.452  66.788  1.00 59.81           C  
ATOM   4410  CG  ARG A 530      13.660  32.334  67.370  1.00 60.94           C  
ATOM   4411  CD  ARG A 530      14.103  33.396  68.447  1.00 63.13           C  
ATOM   4412  NE  ARG A 530      13.920  32.955  69.853  1.00 70.43           N  
ATOM   4413  CZ  ARG A 530      14.193  33.670  70.972  1.00 73.94           C  
ATOM   4414  NH1 ARG A 530      14.688  34.913  70.925  1.00 75.30           N  
ATOM   4415  NH2 ARG A 530      13.966  33.140  72.186  1.00 74.58           N  
ATOM   4416  N   TYR A 531      16.311  31.754  63.973  1.00 59.10           N  
ATOM   4417  CA  TYR A 531      17.629  31.746  63.334  1.00 59.02           C  
ATOM   4418  C   TYR A 531      18.493  32.677  64.139  1.00 59.47           C  
ATOM   4419  O   TYR A 531      17.973  33.473  64.910  1.00 59.82           O  
ATOM   4420  CB  TYR A 531      17.591  32.147  61.825  1.00 58.59           C  
ATOM   4421  CG  TYR A 531      17.229  33.601  61.491  1.00 58.03           C  
ATOM   4422  CD1 TYR A 531      18.139  34.628  61.664  1.00 58.48           C  
ATOM   4423  CD2 TYR A 531      15.978  33.934  60.976  1.00 57.81           C  
ATOM   4424  CE1 TYR A 531      17.800  35.946  61.385  1.00 57.37           C  
ATOM   4425  CE2 TYR A 531      15.637  35.236  60.687  1.00 55.71           C  
ATOM   4426  CZ  TYR A 531      16.552  36.237  60.896  1.00 57.45           C  
ATOM   4427  OH  TYR A 531      16.229  37.550  60.612  1.00 58.48           O  
ATOM   4428  N   TYR A 532      19.810  32.588  63.989  1.00 60.04           N  
ATOM   4429  CA  TYR A 532      20.696  33.575  64.597  1.00 60.45           C  
ATOM   4430  C   TYR A 532      21.779  33.912  63.627  1.00 60.37           C  
ATOM   4431  O   TYR A 532      22.545  33.034  63.195  1.00 59.89           O  
ATOM   4432  CB  TYR A 532      21.313  33.074  65.895  1.00 61.34           C  
ATOM   4433  CG  TYR A 532      20.290  32.651  66.892  1.00 62.45           C  
ATOM   4434  CD1 TYR A 532      19.778  31.347  66.880  1.00 63.50           C  
ATOM   4435  CD2 TYR A 532      19.796  33.550  67.825  1.00 63.92           C  
ATOM   4436  CE1 TYR A 532      18.809  30.935  67.788  1.00 63.55           C  
ATOM   4437  CE2 TYR A 532      18.821  33.149  68.748  1.00 66.06           C  
ATOM   4438  CZ  TYR A 532      18.338  31.831  68.718  1.00 64.25           C  
ATOM   4439  OH  TYR A 532      17.379  31.431  69.615  1.00 64.18           O  
ATOM   4440  N   LEU A 533      21.824  35.191  63.283  1.00 60.32           N  
ATOM   4441  CA  LEU A 533      22.815  35.693  62.384  1.00 60.54           C  
ATOM   4442  C   LEU A 533      23.824  36.482  63.185  1.00 61.34           C  
ATOM   4443  O   LEU A 533      23.606  37.666  63.431  1.00 62.12           O  
ATOM   4444  CB  LEU A 533      22.158  36.578  61.345  1.00 59.72           C  
ATOM   4445  CG  LEU A 533      23.070  36.923  60.169  1.00 59.54           C  
ATOM   4446  CD1 LEU A 533      23.628  35.658  59.493  1.00 57.67           C  
ATOM   4447  CD2 LEU A 533      22.322  37.780  59.168  1.00 57.25           C  
ATOM   4448  N   THR A 534      24.927  35.835  63.584  1.00 61.99           N  
ATOM   4449  CA  THR A 534      25.969  36.474  64.439  1.00 62.33           C  
ATOM   4450  C   THR A 534      27.385  36.575  63.834  1.00 62.22           C  
ATOM   4451  O   THR A 534      27.845  35.655  63.131  1.00 62.47           O  
ATOM   4452  CB  THR A 534      26.100  35.736  65.789  1.00 62.49           C  
ATOM   4453  OG1 THR A 534      24.798  35.569  66.379  1.00 63.07           O  
ATOM   4454  CG2 THR A 534      27.023  36.504  66.735  1.00 61.91           C  
ATOM   4455  N   SER A 535      28.072  37.679  64.125  1.00 61.64           N  
ATOM   4456  CA  SER A 535      29.466  37.839  63.717  1.00 61.94           C  
ATOM   4457  C   SER A 535      30.428  37.881  64.912  1.00 62.28           C  
ATOM   4458  O   SER A 535      30.078  38.383  65.993  1.00 62.91           O  
ATOM   4459  CB  SER A 535      29.635  39.099  62.887  1.00 61.47           C  
ATOM   4460  OG  SER A 535      29.121  40.197  63.610  1.00 62.44           O  
ATOM   4461  N   TYR A 536      31.646  37.373  64.719  1.00 62.10           N  
ATOM   4462  CA  TYR A 536      32.673  37.462  65.757  1.00 62.02           C  
ATOM   4463  C   TYR A 536      33.882  38.259  65.290  1.00 62.33           C  
ATOM   4464  O   TYR A 536      34.199  38.284  64.090  1.00 62.50           O  
ATOM   4465  CB  TYR A 536      33.117  36.072  66.208  1.00 61.69           C  
ATOM   4466  CG  TYR A 536      31.978  35.172  66.632  1.00 61.46           C  
ATOM   4467  CD1 TYR A 536      31.318  34.350  65.709  1.00 61.94           C  
ATOM   4468  CD2 TYR A 536      31.550  35.142  67.948  1.00 60.39           C  
ATOM   4469  CE1 TYR A 536      30.268  33.512  66.112  1.00 60.87           C  
ATOM   4470  CE2 TYR A 536      30.504  34.324  68.343  1.00 59.60           C  
ATOM   4471  CZ  TYR A 536      29.877  33.524  67.429  1.00 59.67           C  
ATOM   4472  OH  TYR A 536      28.868  32.730  67.851  1.00 60.18           O  
ATOM   4473  N   PRO A 537      34.563  38.930  66.230  1.00 62.43           N  
ATOM   4474  CA  PRO A 537      35.851  39.516  65.893  1.00 62.36           C  
ATOM   4475  C   PRO A 537      36.936  38.496  66.240  1.00 62.19           C  
ATOM   4476  O   PRO A 537      36.609  37.358  66.564  1.00 62.41           O  
ATOM   4477  CB  PRO A 537      35.908  40.765  66.790  1.00 62.36           C  
ATOM   4478  CG  PRO A 537      35.014  40.443  67.955  1.00 62.87           C  
ATOM   4479  CD  PRO A 537      34.203  39.188  67.632  1.00 62.56           C  
ATOM   4480  N   ALA A 538      38.200  38.892  66.174  1.00 61.97           N  
ATOM   4481  CA  ALA A 538      39.310  37.967  66.327  1.00 62.25           C  
ATOM   4482  C   ALA A 538      39.363  37.193  67.650  1.00 62.79           C  
ATOM   4483  O   ALA A 538      39.386  37.769  68.732  1.00 62.93           O  
ATOM   4484  CB  ALA A 538      40.607  38.690  66.088  1.00 62.33           C  
ATOM   4485  N   PHE A 539      39.362  35.872  67.536  1.00 63.81           N  
ATOM   4486  CA  PHE A 539      39.737  34.969  68.618  1.00 64.56           C  
ATOM   4487  C   PHE A 539      40.671  33.993  67.960  1.00 65.45           C  
ATOM   4488  O   PHE A 539      40.340  33.431  66.896  1.00 66.23           O  
ATOM   4489  CB  PHE A 539      38.548  34.181  69.175  1.00 64.26           C  
ATOM   4490  CG  PHE A 539      37.461  35.030  69.760  1.00 63.57           C  
ATOM   4491  CD1 PHE A 539      36.421  35.483  68.973  1.00 63.66           C  
ATOM   4492  CD2 PHE A 539      37.459  35.348  71.105  1.00 64.01           C  
ATOM   4493  CE1 PHE A 539      35.400  36.257  69.512  1.00 64.33           C  
ATOM   4494  CE2 PHE A 539      36.449  36.131  71.656  1.00 63.88           C  
ATOM   4495  CZ  PHE A 539      35.415  36.579  70.855  1.00 63.88           C  
ATOM   4496  N   GLY A 540      41.834  33.804  68.570  1.00 65.94           N  
ATOM   4497  CA  GLY A 540      42.857  32.931  68.021  1.00 66.75           C  
ATOM   4498  C   GLY A 540      42.362  31.511  68.091  1.00 67.50           C  
ATOM   4499  O   GLY A 540      41.524  31.083  67.285  1.00 67.21           O  
ATOM   4500  N   GLU A 541      42.852  30.781  69.085  1.00 68.25           N  
ATOM   4501  CA  GLU A 541      42.466  29.381  69.232  1.00 69.13           C  
ATOM   4502  C   GLU A 541      41.087  29.222  69.860  1.00 68.41           C  
ATOM   4503  O   GLU A 541      40.573  28.121  69.986  1.00 68.32           O  
ATOM   4504  CB  GLU A 541      43.506  28.621  70.054  1.00 69.94           C  
ATOM   4505  CG  GLU A 541      44.821  28.379  69.315  1.00 72.61           C  
ATOM   4506  CD  GLU A 541      45.684  27.340  70.005  1.00 75.67           C  
ATOM   4507  OE1 GLU A 541      45.125  26.287  70.398  1.00 77.66           O  
ATOM   4508  OE2 GLU A 541      46.909  27.574  70.156  1.00 76.84           O  
ATOM   4509  N   LYS A 542      40.478  30.329  70.238  1.00 67.94           N  
ATOM   4510  CA  LYS A 542      39.268  30.227  71.015  1.00 67.37           C  
ATOM   4511  C   LYS A 542      38.007  30.356  70.166  1.00 66.96           C  
ATOM   4512  O   LYS A 542      36.914  30.124  70.672  1.00 67.54           O  
ATOM   4513  CB  LYS A 542      39.262  31.237  72.182  1.00 67.29           C  
ATOM   4514  CG  LYS A 542      40.377  31.079  73.196  1.00 65.70           C  
ATOM   4515  CD  LYS A 542      40.270  32.182  74.212  1.00 65.80           C  
ATOM   4516  CE  LYS A 542      41.580  32.399  74.923  1.00 65.66           C  
ATOM   4517  NZ  LYS A 542      41.705  33.804  75.394  1.00 65.17           N  
ATOM   4518  N   LEU A 543      38.122  30.704  68.893  1.00 65.98           N  
ATOM   4519  CA  LEU A 543      36.886  30.921  68.133  1.00 65.80           C  
ATOM   4520  C   LEU A 543      35.927  29.752  68.171  1.00 65.90           C  
ATOM   4521  O   LEU A 543      34.725  29.928  68.350  1.00 65.96           O  
ATOM   4522  CB  LEU A 543      37.153  31.268  66.674  1.00 65.82           C  
ATOM   4523  CG  LEU A 543      35.871  31.279  65.840  1.00 64.86           C  
ATOM   4524  CD1 LEU A 543      34.924  32.417  66.257  1.00 64.44           C  
ATOM   4525  CD2 LEU A 543      36.189  31.349  64.363  1.00 64.99           C  
ATOM   4526  N   THR A 544      36.472  28.558  67.998  1.00 66.19           N  
ATOM   4527  CA  THR A 544      35.667  27.385  67.783  1.00 66.50           C  
ATOM   4528  C   THR A 544      34.851  27.112  69.016  1.00 66.10           C  
ATOM   4529  O   THR A 544      33.620  27.039  68.947  1.00 66.30           O  
ATOM   4530  CB  THR A 544      36.547  26.193  67.362  1.00 67.04           C  
ATOM   4531  OG1 THR A 544      36.918  26.355  65.978  1.00 68.18           O  
ATOM   4532  CG2 THR A 544      35.808  24.858  67.538  1.00 67.99           C  
ATOM   4533  N   GLU A 545      35.536  27.007  70.150  1.00 65.72           N  
ATOM   4534  CA  GLU A 545      34.863  26.834  71.435  1.00 65.23           C  
ATOM   4535  C   GLU A 545      33.778  27.885  71.547  1.00 64.23           C  
ATOM   4536  O   GLU A 545      32.616  27.567  71.800  1.00 64.09           O  
ATOM   4537  CB  GLU A 545      35.836  26.951  72.623  1.00 65.24           C  
ATOM   4538  CG  GLU A 545      36.942  25.894  72.674  1.00 66.22           C  
ATOM   4539  CD  GLU A 545      37.425  25.577  74.099  1.00 67.87           C  
ATOM   4540  OE1 GLU A 545      37.847  26.515  74.814  1.00 68.49           O  
ATOM   4541  OE2 GLU A 545      37.397  24.382  74.500  1.00 68.74           O  
ATOM   4542  N   LYS A 546      34.151  29.131  71.311  1.00 63.29           N  
ATOM   4543  CA  LYS A 546      33.244  30.210  71.595  1.00 63.37           C  
ATOM   4544  C   LYS A 546      31.952  29.980  70.849  1.00 63.09           C  
ATOM   4545  O   LYS A 546      30.912  29.655  71.456  1.00 63.74           O  
ATOM   4546  CB  LYS A 546      33.841  31.563  71.244  1.00 63.38           C  
ATOM   4547  CG  LYS A 546      33.549  32.587  72.301  1.00 64.58           C  
ATOM   4548  CD  LYS A 546      33.198  33.926  71.693  1.00 68.19           C  
ATOM   4549  CE  LYS A 546      32.582  34.867  72.748  1.00 70.92           C  
ATOM   4550  NZ  LYS A 546      32.420  36.278  72.241  1.00 71.89           N  
ATOM   4551  N   ALA A 547      32.038  30.108  69.533  1.00 62.10           N  
ATOM   4552  CA  ALA A 547      30.888  29.941  68.661  1.00 61.44           C  
ATOM   4553  C   ALA A 547      30.111  28.651  68.848  1.00 60.60           C  
ATOM   4554  O   ALA A 547      28.903  28.632  68.662  1.00 60.83           O  
ATOM   4555  CB  ALA A 547      31.309  30.075  67.200  1.00 61.78           C  
ATOM   4556  N   ILE A 548      30.777  27.559  69.178  1.00 59.55           N  
ATOM   4557  CA  ILE A 548      30.011  26.348  69.320  1.00 59.19           C  
ATOM   4558  C   ILE A 548      29.100  26.442  70.558  1.00 59.15           C  
ATOM   4559  O   ILE A 548      27.883  26.275  70.466  1.00 57.51           O  
ATOM   4560  CB  ILE A 548      30.901  25.099  69.232  1.00 59.54           C  
ATOM   4561  CG1 ILE A 548      31.528  25.031  67.820  1.00 59.25           C  
ATOM   4562  CG2 ILE A 548      30.067  23.851  69.518  1.00 60.15           C  
ATOM   4563  CD1 ILE A 548      32.455  23.854  67.514  1.00 58.55           C  
ATOM   4564  N   GLY A 549      29.711  26.774  71.694  1.00 60.00           N  
ATOM   4565  CA  GLY A 549      28.994  27.084  72.929  1.00 60.92           C  
ATOM   4566  C   GLY A 549      27.835  28.054  72.779  1.00 61.55           C  
ATOM   4567  O   GLY A 549      26.743  27.818  73.305  1.00 61.36           O  
ATOM   4568  N   ASP A 550      28.064  29.150  72.066  1.00 62.41           N  
ATOM   4569  CA  ASP A 550      26.983  30.089  71.741  1.00 63.66           C  
ATOM   4570  C   ASP A 550      25.717  29.433  71.202  1.00 64.03           C  
ATOM   4571  O   ASP A 550      24.606  29.886  71.485  1.00 64.51           O  
ATOM   4572  CB  ASP A 550      27.463  31.148  70.760  1.00 63.65           C  
ATOM   4573  CG  ASP A 550      28.254  32.247  71.445  1.00 66.30           C  
ATOM   4574  OD1 ASP A 550      28.656  32.073  72.628  1.00 68.47           O  
ATOM   4575  OD2 ASP A 550      28.472  33.296  70.804  1.00 68.24           O  
ATOM   4576  N   VAL A 551      25.883  28.357  70.439  1.00 64.20           N  
ATOM   4577  CA  VAL A 551      24.754  27.685  69.855  1.00 64.18           C  
ATOM   4578  C   VAL A 551      24.043  26.897  70.947  1.00 64.50           C  
ATOM   4579  O   VAL A 551      22.809  26.874  71.003  1.00 64.42           O  
ATOM   4580  CB  VAL A 551      25.211  26.839  68.649  1.00 64.76           C  
ATOM   4581  CG1 VAL A 551      24.148  25.789  68.199  1.00 64.81           C  
ATOM   4582  CG2 VAL A 551      25.659  27.769  67.471  1.00 64.42           C  
ATOM   4583  N   PHE A 552      24.824  26.311  71.852  1.00 64.96           N  
ATOM   4584  CA  PHE A 552      24.277  25.515  72.967  1.00 65.16           C  
ATOM   4585  C   PHE A 552      23.459  26.330  73.938  1.00 65.30           C  
ATOM   4586  O   PHE A 552      22.341  25.922  74.280  1.00 65.81           O  
ATOM   4587  CB  PHE A 552      25.366  24.749  73.718  1.00 65.10           C  
ATOM   4588  CG  PHE A 552      25.765  23.480  73.045  1.00 65.14           C  
ATOM   4589  CD1 PHE A 552      26.541  23.511  71.877  1.00 65.76           C  
ATOM   4590  CD2 PHE A 552      25.344  22.265  73.539  1.00 64.69           C  
ATOM   4591  CE1 PHE A 552      26.901  22.351  71.223  1.00 64.92           C  
ATOM   4592  CE2 PHE A 552      25.703  21.089  72.905  1.00 65.74           C  
ATOM   4593  CZ  PHE A 552      26.491  21.130  71.740  1.00 66.00           C  
ATOM   4594  N   SER A 553      24.004  27.467  74.373  1.00 65.07           N  
ATOM   4595  CA  SER A 553      23.292  28.346  75.291  1.00 65.01           C  
ATOM   4596  C   SER A 553      21.997  28.815  74.651  1.00 65.01           C  
ATOM   4597  O   SER A 553      20.944  28.657  75.223  1.00 65.06           O  
ATOM   4598  CB  SER A 553      24.165  29.512  75.738  1.00 65.01           C  
ATOM   4599  OG  SER A 553      24.347  30.449  74.698  1.00 65.97           O  
ATOM   4600  N   LEU A 554      22.072  29.342  73.438  1.00 65.55           N  
ATOM   4601  CA  LEU A 554      20.874  29.629  72.656  1.00 66.13           C  
ATOM   4602  C   LEU A 554      19.817  28.515  72.660  1.00 65.97           C  
ATOM   4603  O   LEU A 554      18.616  28.792  72.665  1.00 65.55           O  
ATOM   4604  CB  LEU A 554      21.253  29.969  71.216  1.00 66.29           C  
ATOM   4605  CG  LEU A 554      21.817  31.380  71.019  1.00 68.00           C  
ATOM   4606  CD1 LEU A 554      22.165  31.591  69.547  1.00 68.99           C  
ATOM   4607  CD2 LEU A 554      20.883  32.511  71.553  1.00 69.05           C  
ATOM   4608  N   LEU A 555      20.260  27.263  72.646  1.00 66.22           N  
ATOM   4609  CA  LEU A 555      19.325  26.145  72.697  1.00 66.53           C  
ATOM   4610  C   LEU A 555      18.634  26.111  74.045  1.00 67.20           C  
ATOM   4611  O   LEU A 555      17.408  26.014  74.103  1.00 67.53           O  
ATOM   4612  CB  LEU A 555      20.002  24.812  72.377  1.00 66.10           C  
ATOM   4613  CG  LEU A 555      20.097  24.452  70.895  1.00 65.47           C  
ATOM   4614  CD1 LEU A 555      20.990  23.265  70.700  1.00 65.50           C  
ATOM   4615  CD2 LEU A 555      18.740  24.163  70.273  1.00 64.35           C  
ATOM   4616  N   GLU A 556      19.411  26.221  75.121  1.00 67.47           N  
ATOM   4617  CA  GLU A 556      18.850  26.344  76.469  1.00 68.34           C  
ATOM   4618  C   GLU A 556      17.929  27.552  76.622  1.00 67.61           C  
ATOM   4619  O   GLU A 556      16.964  27.482  77.369  1.00 67.80           O  
ATOM   4620  CB  GLU A 556      19.955  26.417  77.514  1.00 67.79           C  
ATOM   4621  CG  GLU A 556      19.455  26.386  78.942  1.00 69.89           C  
ATOM   4622  CD  GLU A 556      20.582  26.176  79.969  1.00 71.43           C  
ATOM   4623  OE1 GLU A 556      21.699  25.784  79.550  1.00 75.32           O  
ATOM   4624  OE2 GLU A 556      20.352  26.395  81.196  1.00 74.70           O  
ATOM   4625  N   LYS A 557      18.231  28.645  75.913  1.00 67.24           N  
ATOM   4626  CA  LYS A 557      17.459  29.886  75.978  1.00 66.74           C  
ATOM   4627  C   LYS A 557      16.115  29.734  75.322  1.00 66.34           C  
ATOM   4628  O   LYS A 557      15.194  30.486  75.586  1.00 65.92           O  
ATOM   4629  CB  LYS A 557      18.200  31.011  75.288  1.00 66.96           C  
ATOM   4630  CG  LYS A 557      19.463  31.440  75.977  1.00 69.08           C  
ATOM   4631  CD  LYS A 557      20.292  32.376  75.094  1.00 72.42           C  
ATOM   4632  CE  LYS A 557      21.522  32.884  75.854  1.00 74.51           C  
ATOM   4633  NZ  LYS A 557      21.980  34.210  75.352  1.00 76.05           N  
ATOM   4634  N   LEU A 558      16.012  28.763  74.435  1.00 66.54           N  
ATOM   4635  CA  LEU A 558      14.730  28.402  73.870  1.00 66.73           C  
ATOM   4636  C   LEU A 558      14.225  27.295  74.756  1.00 67.24           C  
ATOM   4637  O   LEU A 558      13.135  26.762  74.561  1.00 67.31           O  
ATOM   4638  CB  LEU A 558      14.897  27.945  72.420  1.00 66.47           C  
ATOM   4639  CG  LEU A 558      15.507  28.991  71.458  1.00 65.56           C  
ATOM   4640  CD1 LEU A 558      16.382  28.342  70.405  1.00 61.55           C  
ATOM   4641  CD2 LEU A 558      14.423  29.906  70.816  1.00 65.08           C  
ATOM   4642  N   GLY A 559      15.055  26.972  75.742  1.00 67.95           N  
ATOM   4643  CA  GLY A 559      14.798  25.932  76.720  1.00 68.86           C  
ATOM   4644  C   GLY A 559      14.420  24.604  76.124  1.00 69.61           C  
ATOM   4645  O   GLY A 559      13.298  24.168  76.291  1.00 70.13           O  
ATOM   4646  N   PHE A 560      15.326  23.963  75.401  1.00 70.23           N  
ATOM   4647  CA  PHE A 560      15.086  22.587  75.029  1.00 71.07           C  
ATOM   4648  C   PHE A 560      15.522  21.790  76.240  1.00 72.38           C  
ATOM   4649  O   PHE A 560      16.675  21.922  76.679  1.00 72.88           O  
ATOM   4650  CB  PHE A 560      15.924  22.199  73.828  1.00 70.49           C  
ATOM   4651  CG  PHE A 560      15.241  22.410  72.516  1.00 69.61           C  
ATOM   4652  CD1 PHE A 560      15.331  23.630  71.855  1.00 68.09           C  
ATOM   4653  CD2 PHE A 560      14.534  21.375  71.916  1.00 68.90           C  
ATOM   4654  CE1 PHE A 560      14.711  23.816  70.625  1.00 66.95           C  
ATOM   4655  CE2 PHE A 560      13.909  21.557  70.691  1.00 68.16           C  
ATOM   4656  CZ  PHE A 560      13.998  22.783  70.045  1.00 67.66           C  
ATOM   4657  N   LYS A 561      14.616  20.994  76.806  1.00 73.59           N  
ATOM   4658  CA  LYS A 561      14.908  20.303  78.085  1.00 74.86           C  
ATOM   4659  C   LYS A 561      16.065  19.298  77.990  1.00 75.01           C  
ATOM   4660  O   LYS A 561      16.274  18.669  76.949  1.00 75.25           O  
ATOM   4661  CB  LYS A 561      13.645  19.657  78.684  1.00 75.13           C  
ATOM   4662  CG  LYS A 561      12.772  20.666  79.444  1.00 76.31           C  
ATOM   4663  CD  LYS A 561      11.576  20.009  80.089  1.00 77.21           C  
ATOM   4664  CE  LYS A 561      10.653  21.066  80.648  1.00 77.86           C  
ATOM   4665  NZ  LYS A 561       9.969  20.533  81.846  1.00 79.29           N  
ATOM   4666  N   LYS A 562      16.826  19.174  79.076  1.00 75.02           N  
ATOM   4667  CA  LYS A 562      17.919  18.207  79.149  1.00 75.01           C  
ATOM   4668  C   LYS A 562      17.430  16.819  78.700  1.00 74.98           C  
ATOM   4669  O   LYS A 562      16.239  16.507  78.805  1.00 74.83           O  
ATOM   4670  CB  LYS A 562      18.506  18.175  80.560  1.00 74.93           C  
ATOM   4671  CG  LYS A 562      18.983  19.561  81.068  1.00 75.83           C  
ATOM   4672  CD  LYS A 562      19.597  19.470  82.477  1.00 75.00           C  
ATOM   4673  CE  LYS A 562      20.661  20.522  82.689  1.00 74.07           C  
ATOM   4674  NZ  LYS A 562      21.819  19.930  83.417  1.00 73.93           N  
ATOM   4675  N   GLY A 563      18.346  16.011  78.166  1.00 74.91           N  
ATOM   4676  CA  GLY A 563      18.003  14.734  77.563  1.00 74.86           C  
ATOM   4677  C   GLY A 563      17.277  14.845  76.224  1.00 75.00           C  
ATOM   4678  O   GLY A 563      16.829  13.841  75.676  1.00 74.81           O  
ATOM   4679  N   SER A 564      17.141  16.057  75.690  1.00 75.24           N  
ATOM   4680  CA  SER A 564      16.528  16.228  74.358  1.00 75.26           C  
ATOM   4681  C   SER A 564      17.543  15.852  73.276  1.00 75.16           C  
ATOM   4682  O   SER A 564      18.737  16.142  73.424  1.00 75.30           O  
ATOM   4683  CB  SER A 564      15.980  17.657  74.158  1.00 75.32           C  
ATOM   4684  OG  SER A 564      16.861  18.654  74.650  1.00 73.75           O  
ATOM   4685  N   LYS A 565      17.101  15.170  72.225  1.00 74.61           N  
ATOM   4686  CA  LYS A 565      18.058  14.777  71.203  1.00 74.81           C  
ATOM   4687  C   LYS A 565      18.226  15.975  70.305  1.00 73.57           C  
ATOM   4688  O   LYS A 565      17.246  16.639  69.942  1.00 73.66           O  
ATOM   4689  CB  LYS A 565      17.606  13.566  70.361  1.00 75.92           C  
ATOM   4690  CG  LYS A 565      16.761  12.534  71.088  1.00 79.53           C  
ATOM   4691  CD  LYS A 565      17.200  11.111  70.716  1.00 85.99           C  
ATOM   4692  CE  LYS A 565      16.831  10.153  71.875  1.00 88.86           C  
ATOM   4693  NZ  LYS A 565      17.831   9.051  72.101  1.00 90.12           N  
ATOM   4694  N   ILE A 566      19.461  16.260  69.933  1.00 71.69           N  
ATOM   4695  CA  ILE A 566      19.678  17.346  69.020  1.00 69.91           C  
ATOM   4696  C   ILE A 566      20.595  16.912  67.869  1.00 69.35           C  
ATOM   4697  O   ILE A 566      21.713  16.459  68.107  1.00 69.27           O  
ATOM   4698  CB  ILE A 566      20.181  18.549  69.792  1.00 69.53           C  
ATOM   4699  CG1 ILE A 566      19.113  18.942  70.806  1.00 69.63           C  
ATOM   4700  CG2 ILE A 566      20.445  19.696  68.870  1.00 69.13           C  
ATOM   4701  CD1 ILE A 566      19.367  20.207  71.569  1.00 71.38           C  
ATOM   4702  N   VAL A 567      20.104  17.023  66.633  1.00 68.09           N  
ATOM   4703  CA  VAL A 567      20.912  16.740  65.445  1.00 67.41           C  
ATOM   4704  C   VAL A 567      21.579  17.984  64.857  1.00 66.64           C  
ATOM   4705  O   VAL A 567      20.941  19.008  64.689  1.00 66.75           O  
ATOM   4706  CB  VAL A 567      20.047  16.115  64.359  1.00 67.76           C  
ATOM   4707  CG1 VAL A 567      20.895  15.613  63.207  1.00 67.95           C  
ATOM   4708  CG2 VAL A 567      19.260  14.967  64.930  1.00 68.13           C  
ATOM   4709  N   VAL A 568      22.856  17.893  64.520  1.00 66.00           N  
ATOM   4710  CA  VAL A 568      23.540  19.018  63.878  1.00 66.24           C  
ATOM   4711  C   VAL A 568      23.980  18.790  62.409  1.00 66.47           C  
ATOM   4712  O   VAL A 568      24.653  17.809  62.099  1.00 66.53           O  
ATOM   4713  CB  VAL A 568      24.751  19.439  64.682  1.00 65.98           C  
ATOM   4714  CG1 VAL A 568      25.509  20.496  63.937  1.00 66.61           C  
ATOM   4715  CG2 VAL A 568      24.315  19.970  66.010  1.00 65.86           C  
ATOM   4716  N   HIS A 569      23.604  19.690  61.504  1.00 66.52           N  
ATOM   4717  CA  HIS A 569      24.079  19.579  60.129  1.00 66.78           C  
ATOM   4718  C   HIS A 569      25.025  20.712  59.796  1.00 67.97           C  
ATOM   4719  O   HIS A 569      24.733  21.881  60.122  1.00 67.93           O  
ATOM   4720  CB  HIS A 569      22.933  19.635  59.141  1.00 66.14           C  
ATOM   4721  CG  HIS A 569      21.896  18.580  59.337  1.00 64.55           C  
ATOM   4722  ND1 HIS A 569      22.171  17.353  59.887  1.00 62.70           N  
ATOM   4723  CD2 HIS A 569      20.584  18.558  59.005  1.00 63.00           C  
ATOM   4724  CE1 HIS A 569      21.069  16.625  59.906  1.00 62.43           C  
ATOM   4725  NE2 HIS A 569      20.093  17.332  59.369  1.00 62.70           N  
ATOM   4726  N   ARG A 570      26.155  20.377  59.161  1.00 69.01           N  
ATOM   4727  CA  ARG A 570      27.037  21.399  58.604  1.00 70.33           C  
ATOM   4728  C   ARG A 570      27.304  21.101  57.172  1.00 71.33           C  
ATOM   4729  O   ARG A 570      27.582  19.944  56.819  1.00 71.79           O  
ATOM   4730  CB  ARG A 570      28.388  21.474  59.294  1.00 70.44           C  
ATOM   4731  CG  ARG A 570      29.235  22.670  58.810  1.00 71.00           C  
ATOM   4732  CD  ARG A 570      30.715  22.350  58.867  1.00 72.73           C  
ATOM   4733  NE  ARG A 570      31.557  23.364  59.515  1.00 74.97           N  
ATOM   4734  CZ  ARG A 570      31.707  23.498  60.838  1.00 74.66           C  
ATOM   4735  NH1 ARG A 570      31.053  22.718  61.665  1.00 75.37           N  
ATOM   4736  NH2 ARG A 570      32.512  24.418  61.352  1.00 75.32           N  
ATOM   4737  N   ASP A 571      27.231  22.165  56.364  1.00 72.36           N  
ATOM   4738  CA  ASP A 571      27.626  22.174  54.954  1.00 72.30           C  
ATOM   4739  C   ASP A 571      29.170  22.228  54.827  1.00 72.12           C  
ATOM   4740  O   ASP A 571      29.722  23.120  54.221  1.00 72.62           O  
ATOM   4741  CB  ASP A 571      26.933  23.362  54.250  1.00 72.52           C  
ATOM   4742  CG  ASP A 571      27.169  23.401  52.719  1.00 73.50           C  
ATOM   4743  OD1 ASP A 571      27.473  22.344  52.131  1.00 75.92           O  
ATOM   4744  OD2 ASP A 571      27.046  24.489  52.098  1.00 71.86           O  
ATOM   4745  N   GLY A 572      29.880  21.271  55.394  1.00 72.11           N  
ATOM   4746  CA  GLY A 572      31.310  21.245  55.178  1.00 72.53           C  
ATOM   4747  C   GLY A 572      32.050  20.427  56.199  1.00 72.96           C  
ATOM   4748  O   GLY A 572      31.599  20.224  57.314  1.00 72.94           O  
ATOM   4749  N   ARG A 573      33.209  19.954  55.800  1.00 73.40           N  
ATOM   4750  CA  ARG A 573      34.084  19.190  56.669  1.00 74.37           C  
ATOM   4751  C   ARG A 573      34.155  19.819  58.057  1.00 73.86           C  
ATOM   4752  O   ARG A 573      34.643  20.944  58.182  1.00 74.56           O  
ATOM   4753  CB  ARG A 573      35.468  19.240  56.029  1.00 75.04           C  
ATOM   4754  CG  ARG A 573      36.225  17.957  55.892  1.00 78.31           C  
ATOM   4755  CD  ARG A 573      37.616  18.362  55.431  1.00 83.33           C  
ATOM   4756  NE  ARG A 573      38.635  17.335  55.624  1.00 86.45           N  
ATOM   4757  CZ  ARG A 573      39.937  17.566  55.493  1.00 88.17           C  
ATOM   4758  NH1 ARG A 573      40.365  18.791  55.187  1.00 88.06           N  
ATOM   4759  NH2 ARG A 573      40.813  16.578  55.676  1.00 89.52           N  
ATOM   4760  N   LEU A 574      33.665  19.127  59.090  1.00 73.39           N  
ATOM   4761  CA  LEU A 574      33.938  19.530  60.479  1.00 73.38           C  
ATOM   4762  C   LEU A 574      35.272  18.953  60.841  1.00 74.33           C  
ATOM   4763  O   LEU A 574      35.556  17.808  60.498  1.00 75.24           O  
ATOM   4764  CB  LEU A 574      32.980  18.916  61.463  1.00 72.44           C  
ATOM   4765  CG  LEU A 574      31.530  18.721  61.135  1.00 72.61           C  
ATOM   4766  CD1 LEU A 574      31.196  17.316  61.487  1.00 72.96           C  
ATOM   4767  CD2 LEU A 574      30.697  19.684  61.931  1.00 72.41           C  
ATOM   4768  N   TYR A 575      36.090  19.708  61.558  1.00 75.26           N  
ATOM   4769  CA  TYR A 575      37.409  19.211  61.945  1.00 76.14           C  
ATOM   4770  C   TYR A 575      37.406  18.658  63.381  1.00 76.42           C  
ATOM   4771  O   TYR A 575      36.405  18.766  64.097  1.00 76.03           O  
ATOM   4772  CB  TYR A 575      38.483  20.282  61.678  1.00 76.77           C  
ATOM   4773  CG  TYR A 575      38.393  20.777  60.258  1.00 77.60           C  
ATOM   4774  CD1 TYR A 575      37.400  21.693  59.877  1.00 78.91           C  
ATOM   4775  CD2 TYR A 575      39.242  20.287  59.277  1.00 78.55           C  
ATOM   4776  CE1 TYR A 575      37.278  22.125  58.560  1.00 78.74           C  
ATOM   4777  CE2 TYR A 575      39.134  20.717  57.946  1.00 79.26           C  
ATOM   4778  CZ  TYR A 575      38.147  21.634  57.602  1.00 79.05           C  
ATOM   4779  OH  TYR A 575      38.036  22.061  56.300  1.00 79.11           O  
ATOM   4780  N   ARG A 576      38.523  18.049  63.778  1.00 76.98           N  
ATOM   4781  CA  ARG A 576      38.632  17.368  65.069  1.00 77.34           C  
ATOM   4782  C   ARG A 576      38.347  18.290  66.264  1.00 76.67           C  
ATOM   4783  O   ARG A 576      37.563  17.941  67.148  1.00 76.49           O  
ATOM   4784  CB  ARG A 576      40.019  16.741  65.237  1.00 78.16           C  
ATOM   4785  CG  ARG A 576      40.577  16.022  64.030  1.00 79.50           C  
ATOM   4786  CD  ARG A 576      42.022  15.652  64.300  1.00 81.76           C  
ATOM   4787  NE  ARG A 576      42.281  14.322  63.764  1.00 86.08           N  
ATOM   4788  CZ  ARG A 576      43.380  13.598  63.979  1.00 87.52           C  
ATOM   4789  NH1 ARG A 576      44.380  14.059  64.732  1.00 88.08           N  
ATOM   4790  NH2 ARG A 576      43.482  12.394  63.426  1.00 88.13           N  
ATOM   4791  N   ASP A 577      38.983  19.458  66.269  1.00 75.69           N  
ATOM   4792  CA  ASP A 577      38.800  20.447  67.314  1.00 75.23           C  
ATOM   4793  C   ASP A 577      37.342  20.842  67.526  1.00 74.83           C  
ATOM   4794  O   ASP A 577      36.971  21.296  68.606  1.00 75.02           O  
ATOM   4795  CB  ASP A 577      39.612  21.692  66.985  1.00 75.47           C  
ATOM   4796  CG  ASP A 577      39.006  22.507  65.852  1.00 76.80           C  
ATOM   4797  OD1 ASP A 577      38.476  21.914  64.873  1.00 78.77           O  
ATOM   4798  OD2 ASP A 577      39.062  23.753  65.944  1.00 76.68           O  
ATOM   4799  N   GLU A 578      36.526  20.681  66.491  1.00 74.45           N  
ATOM   4800  CA  GLU A 578      35.099  21.015  66.552  1.00 74.31           C  
ATOM   4801  C   GLU A 578      34.279  19.888  67.179  1.00 73.73           C  
ATOM   4802  O   GLU A 578      33.332  20.127  67.932  1.00 73.29           O  
ATOM   4803  CB  GLU A 578      34.564  21.328  65.144  1.00 74.42           C  
ATOM   4804  CG  GLU A 578      34.579  22.800  64.786  1.00 75.22           C  
ATOM   4805  CD  GLU A 578      34.884  23.057  63.320  1.00 76.99           C  
ATOM   4806  OE1 GLU A 578      34.039  22.779  62.442  1.00 76.90           O  
ATOM   4807  OE2 GLU A 578      35.989  23.560  63.047  1.00 78.82           O  
ATOM   4808  N   VAL A 579      34.641  18.658  66.834  1.00 73.15           N  
ATOM   4809  CA  VAL A 579      33.944  17.488  67.322  1.00 72.56           C  
ATOM   4810  C   VAL A 579      34.114  17.442  68.815  1.00 72.26           C  
ATOM   4811  O   VAL A 579      33.183  17.134  69.554  1.00 71.94           O  
ATOM   4812  CB  VAL A 579      34.567  16.205  66.770  1.00 72.45           C  
ATOM   4813  CG1 VAL A 579      33.628  15.033  66.998  1.00 72.56           C  
ATOM   4814  CG2 VAL A 579      34.887  16.360  65.308  1.00 72.53           C  
ATOM   4815  N   ALA A 580      35.330  17.741  69.250  1.00 72.14           N  
ATOM   4816  CA  ALA A 580      35.668  17.669  70.653  1.00 72.21           C  
ATOM   4817  C   ALA A 580      34.916  18.791  71.352  1.00 72.51           C  
ATOM   4818  O   ALA A 580      34.574  18.681  72.549  1.00 72.87           O  
ATOM   4819  CB  ALA A 580      37.145  17.806  70.840  1.00 71.80           C  
ATOM   4820  N   ALA A 581      34.644  19.850  70.581  1.00 72.24           N  
ATOM   4821  CA  ALA A 581      33.898  20.999  71.052  1.00 71.90           C  
ATOM   4822  C   ALA A 581      32.451  20.615  71.297  1.00 71.83           C  
ATOM   4823  O   ALA A 581      31.902  20.918  72.345  1.00 71.97           O  
ATOM   4824  CB  ALA A 581      33.990  22.124  70.055  1.00 71.99           C  
ATOM   4825  N   PHE A 582      31.846  19.917  70.343  1.00 71.91           N  
ATOM   4826  CA  PHE A 582      30.456  19.469  70.470  1.00 71.83           C  
ATOM   4827  C   PHE A 582      30.286  18.407  71.525  1.00 72.26           C  
ATOM   4828  O   PHE A 582      29.195  18.264  72.083  1.00 72.30           O  
ATOM   4829  CB  PHE A 582      29.921  18.935  69.139  1.00 71.39           C  
ATOM   4830  CG  PHE A 582      29.430  20.003  68.223  1.00 70.62           C  
ATOM   4831  CD1 PHE A 582      30.242  20.501  67.221  1.00 68.97           C  
ATOM   4832  CD2 PHE A 582      28.153  20.532  68.375  1.00 69.85           C  
ATOM   4833  CE1 PHE A 582      29.779  21.498  66.381  1.00 68.58           C  
ATOM   4834  CE2 PHE A 582      27.696  21.533  67.521  1.00 68.60           C  
ATOM   4835  CZ  PHE A 582      28.506  22.009  66.535  1.00 68.15           C  
ATOM   4836  N   LYS A 583      31.356  17.649  71.772  1.00 72.91           N  
ATOM   4837  CA  LYS A 583      31.360  16.624  72.817  1.00 73.60           C  
ATOM   4838  C   LYS A 583      31.283  17.288  74.187  1.00 73.79           C  
ATOM   4839  O   LYS A 583      30.479  16.875  75.042  1.00 73.41           O  
ATOM   4840  CB  LYS A 583      32.596  15.731  72.698  1.00 73.58           C  
ATOM   4841  CG  LYS A 583      32.456  14.627  71.667  1.00 74.29           C  
ATOM   4842  CD  LYS A 583      33.817  14.168  71.107  1.00 76.42           C  
ATOM   4843  CE  LYS A 583      33.714  12.745  70.495  1.00 77.91           C  
ATOM   4844  NZ  LYS A 583      34.619  12.547  69.311  1.00 77.76           N  
ATOM   4845  N   LYS A 584      32.096  18.332  74.363  1.00 74.22           N  
ATOM   4846  CA  LYS A 584      32.160  19.071  75.615  1.00 75.44           C  
ATOM   4847  C   LYS A 584      30.771  19.530  76.058  1.00 75.47           C  
ATOM   4848  O   LYS A 584      30.299  19.199  77.158  1.00 75.36           O  
ATOM   4849  CB  LYS A 584      33.072  20.303  75.492  1.00 75.71           C  
ATOM   4850  CG  LYS A 584      34.577  20.043  75.383  1.00 76.82           C  
ATOM   4851  CD  LYS A 584      35.422  21.203  76.010  1.00 76.71           C  
ATOM   4852  CE  LYS A 584      36.948  20.842  75.988  1.00 79.04           C  
ATOM   4853  NZ  LYS A 584      37.728  21.056  77.299  1.00 79.44           N  
ATOM   4854  N   TYR A 585      30.125  20.294  75.179  1.00 75.58           N  
ATOM   4855  CA  TYR A 585      28.876  20.976  75.501  1.00 75.49           C  
ATOM   4856  C   TYR A 585      27.724  19.977  75.417  1.00 75.38           C  
ATOM   4857  O   TYR A 585      26.690  20.120  76.092  1.00 75.17           O  
ATOM   4858  CB  TYR A 585      28.679  22.203  74.585  1.00 75.46           C  
ATOM   4859  CG  TYR A 585      29.813  23.240  74.659  1.00 75.70           C  
ATOM   4860  CD1 TYR A 585      30.822  23.269  73.695  1.00 75.46           C  
ATOM   4861  CD2 TYR A 585      29.877  24.185  75.692  1.00 75.81           C  
ATOM   4862  CE1 TYR A 585      31.857  24.194  73.744  1.00 74.50           C  
ATOM   4863  CE2 TYR A 585      30.916  25.121  75.747  1.00 75.64           C  
ATOM   4864  CZ  TYR A 585      31.903  25.111  74.765  1.00 75.34           C  
ATOM   4865  OH  TYR A 585      32.937  26.019  74.791  1.00 75.77           O  
ATOM   4866  N   GLY A 586      27.936  18.953  74.589  1.00 75.30           N  
ATOM   4867  CA  GLY A 586      27.094  17.773  74.578  1.00 75.11           C  
ATOM   4868  C   GLY A 586      26.796  17.426  76.008  1.00 74.84           C  
ATOM   4869  O   GLY A 586      25.647  17.517  76.428  1.00 75.03           O  
ATOM   4870  N   GLU A 587      27.850  17.085  76.754  1.00 74.72           N  
ATOM   4871  CA  GLU A 587      27.782  16.878  78.217  1.00 74.78           C  
ATOM   4872  C   GLU A 587      27.216  18.080  78.976  1.00 73.65           C  
ATOM   4873  O   GLU A 587      26.102  18.021  79.490  1.00 73.08           O  
ATOM   4874  CB  GLU A 587      29.166  16.545  78.797  1.00 74.82           C  
ATOM   4875  CG  GLU A 587      29.750  15.169  78.436  1.00 76.18           C  
ATOM   4876  CD  GLU A 587      31.285  15.114  78.620  1.00 76.61           C  
ATOM   4877  OE1 GLU A 587      31.784  15.312  79.768  1.00 78.73           O  
ATOM   4878  OE2 GLU A 587      31.990  14.870  77.607  1.00 78.16           O  
ATOM   4879  N   LEU A 588      27.986  19.170  79.025  1.00 73.12           N  
ATOM   4880  CA  LEU A 588      27.690  20.315  79.918  1.00 72.52           C  
ATOM   4881  C   LEU A 588      26.233  20.795  79.868  1.00 71.59           C  
ATOM   4882  O   LEU A 588      25.730  21.367  80.833  1.00 71.38           O  
ATOM   4883  CB  LEU A 588      28.664  21.498  79.717  1.00 72.71           C  
ATOM   4884  CG  LEU A 588      30.211  21.419  79.551  1.00 74.13           C  
ATOM   4885  CD1 LEU A 588      30.883  22.750  79.989  1.00 74.14           C  
ATOM   4886  CD2 LEU A 588      30.937  20.224  80.220  1.00 74.33           C  
ATOM   4887  N   TYR A 589      25.566  20.555  78.741  1.00 70.62           N  
ATOM   4888  CA  TYR A 589      24.145  20.888  78.601  1.00 69.49           C  
ATOM   4889  C   TYR A 589      23.281  19.636  78.782  1.00 69.43           C  
ATOM   4890  O   TYR A 589      22.151  19.698  79.302  1.00 69.29           O  
ATOM   4891  CB  TYR A 589      23.870  21.615  77.266  1.00 68.13           C  
ATOM   4892  CG  TYR A 589      24.258  23.088  77.301  1.00 66.46           C  
ATOM   4893  CD1 TYR A 589      25.600  23.482  77.194  1.00 65.36           C  
ATOM   4894  CD2 TYR A 589      23.302  24.079  77.464  1.00 64.41           C  
ATOM   4895  CE1 TYR A 589      25.973  24.824  77.231  1.00 64.27           C  
ATOM   4896  CE2 TYR A 589      23.674  25.435  77.508  1.00 63.72           C  
ATOM   4897  CZ  TYR A 589      25.009  25.800  77.390  1.00 64.55           C  
ATOM   4898  OH  TYR A 589      25.388  27.130  77.443  1.00 64.14           O  
ATOM   4899  N   GLY A 590      23.830  18.505  78.354  1.00 68.99           N  
ATOM   4900  CA  GLY A 590      23.221  17.219  78.611  1.00 68.98           C  
ATOM   4901  C   GLY A 590      22.196  16.796  77.591  1.00 69.08           C  
ATOM   4902  O   GLY A 590      21.070  16.468  77.957  1.00 69.40           O  
ATOM   4903  N   TYR A 591      22.597  16.781  76.316  1.00 69.03           N  
ATOM   4904  CA  TYR A 591      21.721  16.417  75.207  1.00 68.63           C  
ATOM   4905  C   TYR A 591      22.405  15.318  74.427  1.00 68.97           C  
ATOM   4906  O   TYR A 591      23.619  15.383  74.239  1.00 68.92           O  
ATOM   4907  CB  TYR A 591      21.594  17.573  74.231  1.00 68.56           C  
ATOM   4908  CG  TYR A 591      21.078  18.928  74.698  1.00 68.10           C  
ATOM   4909  CD1 TYR A 591      19.846  19.068  75.326  1.00 68.38           C  
ATOM   4910  CD2 TYR A 591      21.782  20.084  74.392  1.00 67.61           C  
ATOM   4911  CE1 TYR A 591      19.367  20.332  75.709  1.00 68.45           C  
ATOM   4912  CE2 TYR A 591      21.314  21.333  74.756  1.00 69.01           C  
ATOM   4913  CZ  TYR A 591      20.106  21.460  75.417  1.00 68.40           C  
ATOM   4914  OH  TYR A 591      19.652  22.717  75.764  1.00 67.83           O  
ATOM   4915  N   SER A 592      21.652  14.331  73.938  1.00 69.35           N  
ATOM   4916  CA  SER A 592      22.213  13.377  72.970  1.00 69.68           C  
ATOM   4917  C   SER A 592      22.214  14.000  71.570  1.00 69.77           C  
ATOM   4918  O   SER A 592      21.175  14.480  71.066  1.00 69.57           O  
ATOM   4919  CB  SER A 592      21.525  11.999  73.001  1.00 70.04           C  
ATOM   4920  OG  SER A 592      20.103  12.087  73.050  1.00 71.23           O  
ATOM   4921  N   LEU A 593      23.406  14.004  70.979  1.00 69.59           N  
ATOM   4922  CA  LEU A 593      23.730  14.820  69.827  1.00 69.65           C  
ATOM   4923  C   LEU A 593      24.107  13.954  68.675  1.00 70.05           C  
ATOM   4924  O   LEU A 593      24.927  13.053  68.824  1.00 70.62           O  
ATOM   4925  CB  LEU A 593      24.951  15.694  70.105  1.00 69.32           C  
ATOM   4926  CG  LEU A 593      24.865  17.020  70.847  1.00 69.87           C  
ATOM   4927  CD1 LEU A 593      25.707  18.069  70.107  1.00 68.69           C  
ATOM   4928  CD2 LEU A 593      23.413  17.483  70.977  1.00 70.41           C  
ATOM   4929  N   GLU A 594      23.554  14.251  67.505  1.00 70.08           N  
ATOM   4930  CA  GLU A 594      24.032  13.625  66.301  1.00 69.83           C  
ATOM   4931  C   GLU A 594      24.695  14.617  65.381  1.00 68.89           C  
ATOM   4932  O   GLU A 594      24.044  15.503  64.864  1.00 68.93           O  
ATOM   4933  CB  GLU A 594      22.908  12.886  65.610  1.00 70.37           C  
ATOM   4934  CG  GLU A 594      23.093  11.374  65.699  1.00 74.05           C  
ATOM   4935  CD  GLU A 594      22.414  10.773  66.912  1.00 77.51           C  
ATOM   4936  OE1 GLU A 594      21.364  10.135  66.722  1.00 79.84           O  
ATOM   4937  OE2 GLU A 594      22.908  10.938  68.051  1.00 79.34           O  
ATOM   4938  N   LEU A 595      26.000  14.454  65.201  1.00 68.24           N  
ATOM   4939  CA  LEU A 595      26.803  15.317  64.353  1.00 67.93           C  
ATOM   4940  C   LEU A 595      26.954  14.809  62.905  1.00 67.72           C  
ATOM   4941  O   LEU A 595      27.465  13.731  62.644  1.00 67.94           O  
ATOM   4942  CB  LEU A 595      28.168  15.545  64.993  1.00 67.89           C  
ATOM   4943  CG  LEU A 595      29.007  16.768  64.586  1.00 68.12           C  
ATOM   4944  CD1 LEU A 595      28.234  18.061  64.794  1.00 66.86           C  
ATOM   4945  CD2 LEU A 595      30.309  16.805  65.381  1.00 67.97           C  
ATOM   4946  N   LEU A 596      26.509  15.609  61.954  1.00 67.47           N  
ATOM   4947  CA  LEU A 596      26.542  15.205  60.570  1.00 66.89           C  
ATOM   4948  C   LEU A 596      27.370  16.194  59.808  1.00 66.72           C  
ATOM   4949  O   LEU A 596      27.279  17.406  60.027  1.00 66.39           O  
ATOM   4950  CB  LEU A 596      25.122  15.118  60.002  1.00 66.59           C  
ATOM   4951  CG  LEU A 596      24.495  13.733  60.121  1.00 66.20           C  
ATOM   4952  CD1 LEU A 596      23.013  13.711  59.941  1.00 66.20           C  
ATOM   4953  CD2 LEU A 596      25.111  12.811  59.109  1.00 67.00           C  
ATOM   4954  N   GLU A 597      28.203  15.662  58.931  1.00 66.52           N  
ATOM   4955  CA  GLU A 597      29.006  16.497  58.061  1.00 66.76           C  
ATOM   4956  C   GLU A 597      28.489  16.174  56.679  1.00 66.18           C  
ATOM   4957  O   GLU A 597      28.330  15.004  56.334  1.00 66.45           O  
ATOM   4958  CB  GLU A 597      30.504  16.194  58.244  1.00 66.50           C  
ATOM   4959  CG  GLU A 597      31.425  16.513  57.075  1.00 67.26           C  
ATOM   4960  CD  GLU A 597      32.799  15.799  57.171  1.00 68.16           C  
ATOM   4961  OE1 GLU A 597      33.017  14.772  56.475  1.00 70.92           O  
ATOM   4962  OE2 GLU A 597      33.668  16.251  57.950  1.00 70.63           O  
ATOM   4963  N   ILE A 598      28.177  17.220  55.916  1.00 65.71           N  
ATOM   4964  CA  ILE A 598      27.632  17.081  54.567  1.00 64.44           C  
ATOM   4965  C   ILE A 598      28.633  17.644  53.584  1.00 64.56           C  
ATOM   4966  O   ILE A 598      28.862  18.840  53.595  1.00 65.00           O  
ATOM   4967  CB  ILE A 598      26.315  17.849  54.443  1.00 63.68           C  
ATOM   4968  CG1 ILE A 598      25.252  17.144  55.279  1.00 62.91           C  
ATOM   4969  CG2 ILE A 598      25.909  17.999  52.973  1.00 62.46           C  
ATOM   4970  CD1 ILE A 598      24.055  17.956  55.556  1.00 62.09           C  
ATOM   4971  N   ILE A 599      29.266  16.812  52.770  1.00 64.29           N  
ATOM   4972  CA  ILE A 599      30.078  17.367  51.712  1.00 65.06           C  
ATOM   4973  C   ILE A 599      29.270  17.325  50.429  1.00 66.58           C  
ATOM   4974  O   ILE A 599      28.883  16.249  49.968  1.00 66.74           O  
ATOM   4975  CB  ILE A 599      31.426  16.649  51.546  1.00 64.72           C  
ATOM   4976  CG1 ILE A 599      32.464  17.198  52.511  1.00 63.15           C  
ATOM   4977  CG2 ILE A 599      31.996  16.873  50.133  1.00 65.50           C  
ATOM   4978  CD1 ILE A 599      32.418  16.602  53.833  1.00 62.84           C  
ATOM   4979  N   LYS A 600      29.009  18.497  49.847  1.00 68.40           N  
ATOM   4980  CA  LYS A 600      28.121  18.584  48.672  1.00 69.59           C  
ATOM   4981  C   LYS A 600      28.817  18.586  47.325  1.00 70.70           C  
ATOM   4982  O   LYS A 600      28.199  18.281  46.319  1.00 71.62           O  
ATOM   4983  CB  LYS A 600      27.223  19.814  48.750  1.00 69.39           C  
ATOM   4984  CG  LYS A 600      27.926  21.086  48.384  1.00 69.59           C  
ATOM   4985  CD  LYS A 600      27.025  22.268  48.579  1.00 68.61           C  
ATOM   4986  CE  LYS A 600      27.852  23.542  48.631  1.00 65.63           C  
ATOM   4987  NZ  LYS A 600      27.159  24.464  49.543  1.00 64.51           N  
ATOM   4988  N   ARG A 601      30.082  18.950  47.265  1.00 71.83           N  
ATOM   4989  CA  ARG A 601      30.694  19.010  45.942  1.00 73.29           C  
ATOM   4990  C   ARG A 601      31.554  17.802  45.546  1.00 72.08           C  
ATOM   4991  O   ARG A 601      32.284  17.245  46.363  1.00 73.65           O  
ATOM   4992  CB  ARG A 601      31.420  20.348  45.741  1.00 74.01           C  
ATOM   4993  CG  ARG A 601      30.451  21.546  45.465  1.00 75.57           C  
ATOM   4994  CD  ARG A 601      31.190  22.927  45.432  1.00 75.76           C  
ATOM   4995  NE  ARG A 601      30.291  24.076  45.178  1.00 80.64           N  
ATOM   4996  CZ  ARG A 601      29.875  24.958  46.111  1.00 85.68           C  
ATOM   4997  NH1 ARG A 601      30.271  24.839  47.394  1.00 86.06           N  
ATOM   4998  NH2 ARG A 601      29.060  25.973  45.767  1.00 85.91           N  
ATOM   4999  N   ASN A 602      31.425  17.384  44.298  1.00 70.45           N  
ATOM   5000  CA  ASN A 602      32.362  16.455  43.661  1.00 69.40           C  
ATOM   5001  C   ASN A 602      32.206  15.005  44.041  1.00 68.36           C  
ATOM   5002  O   ASN A 602      33.170  14.259  44.035  1.00 68.66           O  
ATOM   5003  CB  ASN A 602      33.809  16.866  43.926  1.00 69.65           C  
ATOM   5004  CG  ASN A 602      34.051  18.291  43.600  1.00 69.88           C  
ATOM   5005  OD1 ASN A 602      34.017  18.676  42.432  1.00 70.56           O  
ATOM   5006  ND2 ASN A 602      34.264  19.106  44.627  1.00 69.78           N  
ATOM   5007  N   ASN A 603      30.995  14.602  44.372  1.00 67.09           N  
ATOM   5008  CA  ASN A 603      30.775  13.273  44.867  1.00 65.32           C  
ATOM   5009  C   ASN A 603      30.571  12.416  43.672  1.00 65.14           C  
ATOM   5010  O   ASN A 603      30.382  12.959  42.590  1.00 65.12           O  
ATOM   5011  CB  ASN A 603      29.596  13.284  45.811  1.00 64.48           C  
ATOM   5012  CG  ASN A 603      29.906  14.062  47.069  1.00 64.75           C  
ATOM   5013  OD1 ASN A 603      31.018  14.007  47.588  1.00 64.07           O  
ATOM   5014  ND2 ASN A 603      28.948  14.821  47.545  1.00 67.20           N  
ATOM   5015  N   PRO A 604      30.696  11.079  43.821  1.00 64.77           N  
ATOM   5016  CA  PRO A 604      30.398  10.202  42.707  1.00 64.55           C  
ATOM   5017  C   PRO A 604      28.953  10.351  42.284  1.00 64.72           C  
ATOM   5018  O   PRO A 604      28.122  10.646  43.128  1.00 64.57           O  
ATOM   5019  CB  PRO A 604      30.651   8.837  43.299  1.00 64.26           C  
ATOM   5020  CG  PRO A 604      31.639   9.091  44.350  1.00 63.45           C  
ATOM   5021  CD  PRO A 604      31.169  10.306  44.975  1.00 64.16           C  
ATOM   5022  N   ARG A 605      28.680  10.202  40.987  1.00 65.25           N  
ATOM   5023  CA  ARG A 605      27.341  10.394  40.416  1.00 65.86           C  
ATOM   5024  C   ARG A 605      26.620   9.062  40.424  1.00 65.60           C  
ATOM   5025  O   ARG A 605      27.262   8.021  40.580  1.00 66.14           O  
ATOM   5026  CB  ARG A 605      27.446  10.866  38.976  1.00 66.22           C  
ATOM   5027  CG  ARG A 605      28.017  12.254  38.777  1.00 69.42           C  
ATOM   5028  CD  ARG A 605      28.651  12.324  37.386  1.00 76.25           C  
ATOM   5029  NE  ARG A 605      29.357  13.583  37.180  1.00 83.66           N  
ATOM   5030  CZ  ARG A 605      28.781  14.702  36.735  1.00 88.99           C  
ATOM   5031  NH1 ARG A 605      27.488  14.705  36.414  1.00 90.75           N  
ATOM   5032  NH2 ARG A 605      29.493  15.825  36.599  1.00 90.89           N  
ATOM   5033  N   PHE A 606      25.297   9.092  40.272  1.00 64.96           N  
ATOM   5034  CA  PHE A 606      24.523   7.879  40.028  1.00 64.74           C  
ATOM   5035  C   PHE A 606      24.122   7.914  38.552  1.00 65.53           C  
ATOM   5036  O   PHE A 606      23.510   8.901  38.113  1.00 66.23           O  
ATOM   5037  CB  PHE A 606      23.228   7.902  40.816  1.00 63.87           C  
ATOM   5038  CG  PHE A 606      23.372   7.634  42.267  1.00 63.24           C  
ATOM   5039  CD1 PHE A 606      23.408   8.682  43.175  1.00 60.59           C  
ATOM   5040  CD2 PHE A 606      23.405   6.315  42.750  1.00 65.00           C  
ATOM   5041  CE1 PHE A 606      23.496   8.443  44.531  1.00 59.64           C  
ATOM   5042  CE2 PHE A 606      23.485   6.045  44.122  1.00 62.32           C  
ATOM   5043  CZ  PHE A 606      23.526   7.118  45.012  1.00 62.33           C  
ATOM   5044  N   PHE A 607      24.438   6.863  37.790  1.00 65.65           N  
ATOM   5045  CA  PHE A 607      23.955   6.721  36.414  1.00 65.68           C  
ATOM   5046  C   PHE A 607      22.885   5.671  36.404  1.00 67.14           C  
ATOM   5047  O   PHE A 607      23.116   4.552  36.887  1.00 67.93           O  
ATOM   5048  CB  PHE A 607      25.052   6.254  35.514  1.00 64.81           C  
ATOM   5049  CG  PHE A 607      26.236   7.115  35.540  1.00 63.43           C  
ATOM   5050  CD1 PHE A 607      27.016   7.195  36.672  1.00 64.87           C  
ATOM   5051  CD2 PHE A 607      26.585   7.844  34.435  1.00 62.65           C  
ATOM   5052  CE1 PHE A 607      28.113   8.001  36.691  1.00 67.20           C  
ATOM   5053  CE2 PHE A 607      27.687   8.657  34.434  1.00 62.66           C  
ATOM   5054  CZ  PHE A 607      28.454   8.751  35.547  1.00 64.74           C  
ATOM   5055  N   SER A 608      21.723   6.017  35.854  1.00 68.24           N  
ATOM   5056  CA  SER A 608      20.540   5.199  36.043  1.00 69.55           C  
ATOM   5057  C   SER A 608      19.413   5.617  35.144  1.00 70.61           C  
ATOM   5058  O   SER A 608      19.287   6.767  34.779  1.00 70.94           O  
ATOM   5059  CB  SER A 608      20.075   5.274  37.511  1.00 69.33           C  
ATOM   5060  OG  SER A 608      18.832   4.605  37.718  1.00 69.06           O  
ATOM   5061  N   ASN A 609      18.566   4.663  34.828  1.00 72.58           N  
ATOM   5062  CA  ASN A 609      17.373   4.911  34.042  1.00 74.30           C  
ATOM   5063  C   ASN A 609      16.210   5.499  34.833  1.00 75.53           C  
ATOM   5064  O   ASN A 609      15.462   6.308  34.297  1.00 76.62           O  
ATOM   5065  CB  ASN A 609      16.946   3.625  33.339  1.00 74.35           C  
ATOM   5066  CG  ASN A 609      17.722   3.406  32.069  1.00 74.74           C  
ATOM   5067  OD1 ASN A 609      17.970   4.380  31.349  1.00 74.57           O  
ATOM   5068  ND2 ASN A 609      18.148   2.146  31.793  1.00 72.10           N  
ATOM   5069  N   GLU A 610      16.040   5.108  36.088  1.00 76.26           N  
ATOM   5070  CA  GLU A 610      14.992   5.706  36.879  1.00 77.57           C  
ATOM   5071  C   GLU A 610      15.110   7.246  37.006  1.00 77.64           C  
ATOM   5072  O   GLU A 610      16.141   7.756  37.475  1.00 78.43           O  
ATOM   5073  CB  GLU A 610      14.962   5.099  38.251  1.00 77.55           C  
ATOM   5074  CG  GLU A 610      13.937   5.829  39.038  1.00 82.62           C  
ATOM   5075  CD  GLU A 610      12.953   4.908  39.685  1.00 91.33           C  
ATOM   5076  OE1 GLU A 610      13.098   3.658  39.511  1.00 94.43           O  
ATOM   5077  OE2 GLU A 610      12.045   5.438  40.386  1.00 94.05           O  
ATOM   5078  N   LYS A 611      14.066   7.987  36.616  1.00 77.04           N  
ATOM   5079  CA  LYS A 611      14.092   9.441  36.770  1.00 76.56           C  
ATOM   5080  C   LYS A 611      13.964   9.856  38.219  1.00 75.48           C  
ATOM   5081  O   LYS A 611      14.343  10.962  38.566  1.00 75.22           O  
ATOM   5082  CB  LYS A 611      12.954  10.101  36.001  1.00 77.23           C  
ATOM   5083  CG  LYS A 611      13.092  11.652  35.884  1.00 78.40           C  
ATOM   5084  CD  LYS A 611      11.744  12.336  35.548  1.00 77.74           C  
ATOM   5085  CE  LYS A 611      11.863  13.890  35.485  1.00 79.08           C  
ATOM   5086  NZ  LYS A 611      10.618  14.642  34.956  1.00 78.89           N  
ATOM   5087  N   PHE A 612      13.396   8.983  39.053  1.00 74.56           N  
ATOM   5088  CA  PHE A 612      13.013   9.353  40.419  1.00 73.29           C  
ATOM   5089  C   PHE A 612      13.965   8.763  41.437  1.00 72.52           C  
ATOM   5090  O   PHE A 612      13.651   7.813  42.167  1.00 72.98           O  
ATOM   5091  CB  PHE A 612      11.545   9.045  40.676  1.00 73.17           C  
ATOM   5092  CG  PHE A 612      10.659   9.764  39.741  1.00 74.68           C  
ATOM   5093  CD1 PHE A 612      10.186   9.142  38.591  1.00 76.40           C  
ATOM   5094  CD2 PHE A 612      10.396  11.118  39.924  1.00 76.31           C  
ATOM   5095  CE1 PHE A 612       9.419   9.848  37.668  1.00 76.37           C  
ATOM   5096  CE2 PHE A 612       9.609  11.833  39.014  1.00 75.41           C  
ATOM   5097  CZ  PHE A 612       9.125  11.204  37.890  1.00 75.63           C  
ATOM   5098  N   ILE A 613      15.138   9.383  41.463  1.00 70.56           N  
ATOM   5099  CA  ILE A 613      16.292   8.931  42.179  1.00 69.03           C  
ATOM   5100  C   ILE A 613      16.301   9.284  43.673  1.00 67.87           C  
ATOM   5101  O   ILE A 613      16.742   8.501  44.478  1.00 67.76           O  
ATOM   5102  CB  ILE A 613      17.518   9.477  41.464  1.00 69.47           C  
ATOM   5103  CG1 ILE A 613      17.984   8.470  40.427  1.00 69.06           C  
ATOM   5104  CG2 ILE A 613      18.662   9.771  42.427  1.00 70.49           C  
ATOM   5105  CD1 ILE A 613      19.266   8.901  39.859  1.00 70.90           C  
ATOM   5106  N   LYS A 614      15.856  10.482  44.024  1.00 66.73           N  
ATOM   5107  CA  LYS A 614      15.644  10.897  45.406  1.00 65.00           C  
ATOM   5108  C   LYS A 614      15.578   9.679  46.317  1.00 65.22           C  
ATOM   5109  O   LYS A 614      14.698   8.842  46.152  1.00 65.07           O  
ATOM   5110  CB  LYS A 614      14.311  11.669  45.478  1.00 64.34           C  
ATOM   5111  CG  LYS A 614      14.346  13.051  46.098  1.00 59.33           C  
ATOM   5112  CD  LYS A 614      13.898  13.046  47.521  1.00 54.38           C  
ATOM   5113  CE  LYS A 614      13.224  14.367  47.934  1.00 56.72           C  
ATOM   5114  NZ  LYS A 614      14.031  15.648  48.060  1.00 54.31           N  
ATOM   5115  N   GLY A 615      16.507   9.583  47.269  1.00 65.71           N  
ATOM   5116  CA  GLY A 615      16.590   8.436  48.213  1.00 66.32           C  
ATOM   5117  C   GLY A 615      17.596   7.317  47.877  1.00 66.63           C  
ATOM   5118  O   GLY A 615      17.975   6.511  48.729  1.00 66.74           O  
ATOM   5119  N   TYR A 616      18.017   7.246  46.619  1.00 66.92           N  
ATOM   5120  CA  TYR A 616      19.038   6.312  46.205  1.00 66.93           C  
ATOM   5121  C   TYR A 616      20.297   6.565  47.010  1.00 67.00           C  
ATOM   5122  O   TYR A 616      20.623   7.721  47.325  1.00 67.60           O  
ATOM   5123  CB  TYR A 616      19.310   6.492  44.728  1.00 67.14           C  
ATOM   5124  CG  TYR A 616      18.469   5.589  43.846  1.00 69.10           C  
ATOM   5125  CD1 TYR A 616      17.072   5.731  43.771  1.00 69.84           C  
ATOM   5126  CD2 TYR A 616      19.070   4.581  43.080  1.00 69.90           C  
ATOM   5127  CE1 TYR A 616      16.306   4.890  42.959  1.00 69.11           C  
ATOM   5128  CE2 TYR A 616      18.309   3.737  42.276  1.00 69.37           C  
ATOM   5129  CZ  TYR A 616      16.942   3.900  42.226  1.00 68.59           C  
ATOM   5130  OH  TYR A 616      16.229   3.078  41.417  1.00 69.83           O  
ATOM   5131  N   PHE A 617      20.995   5.498  47.388  1.00 66.32           N  
ATOM   5132  CA  PHE A 617      22.193   5.674  48.182  1.00 65.50           C  
ATOM   5133  C   PHE A 617      23.214   4.565  48.047  1.00 64.60           C  
ATOM   5134  O   PHE A 617      22.925   3.459  47.562  1.00 64.15           O  
ATOM   5135  CB  PHE A 617      21.827   5.848  49.656  1.00 66.22           C  
ATOM   5136  CG  PHE A 617      21.464   4.567  50.345  1.00 67.97           C  
ATOM   5137  CD1 PHE A 617      22.200   4.119  51.426  1.00 67.33           C  
ATOM   5138  CD2 PHE A 617      20.391   3.790  49.901  1.00 70.19           C  
ATOM   5139  CE1 PHE A 617      21.868   2.920  52.064  1.00 66.39           C  
ATOM   5140  CE2 PHE A 617      20.078   2.576  50.537  1.00 70.32           C  
ATOM   5141  CZ  PHE A 617      20.828   2.159  51.617  1.00 66.93           C  
ATOM   5142  N   TYR A 618      24.406   4.887  48.529  1.00 63.34           N  
ATOM   5143  CA  TYR A 618      25.519   3.971  48.591  1.00 62.73           C  
ATOM   5144  C   TYR A 618      26.287   4.209  49.903  1.00 63.82           C  
ATOM   5145  O   TYR A 618      26.267   5.315  50.390  1.00 64.72           O  
ATOM   5146  CB  TYR A 618      26.397   4.213  47.398  1.00 60.56           C  
ATOM   5147  CG  TYR A 618      27.550   3.275  47.271  1.00 57.18           C  
ATOM   5148  CD1 TYR A 618      27.434   2.119  46.524  1.00 52.76           C  
ATOM   5149  CD2 TYR A 618      28.768   3.560  47.880  1.00 53.22           C  
ATOM   5150  CE1 TYR A 618      28.475   1.279  46.390  1.00 52.23           C  
ATOM   5151  CE2 TYR A 618      29.816   2.724  47.751  1.00 52.31           C  
ATOM   5152  CZ  TYR A 618      29.663   1.595  46.992  1.00 54.79           C  
ATOM   5153  OH  TYR A 618      30.718   0.760  46.837  1.00 58.01           O  
ATOM   5154  N   LYS A 619      26.933   3.189  50.483  1.00 64.94           N  
ATOM   5155  CA  LYS A 619      27.496   3.307  51.820  1.00 65.91           C  
ATOM   5156  C   LYS A 619      28.993   3.078  51.786  1.00 66.29           C  
ATOM   5157  O   LYS A 619      29.430   2.008  51.393  1.00 66.32           O  
ATOM   5158  CB  LYS A 619      26.813   2.320  52.771  1.00 66.32           C  
ATOM   5159  CG  LYS A 619      26.341   2.917  54.129  1.00 67.61           C  
ATOM   5160  CD  LYS A 619      26.316   1.840  55.264  1.00 66.81           C  
ATOM   5161  CE  LYS A 619      26.193   2.438  56.677  1.00 68.10           C  
ATOM   5162  NZ  LYS A 619      26.363   1.467  57.814  1.00 68.82           N  
ATOM   5163  N   LEU A 620      29.758   4.104  52.177  1.00 67.00           N  
ATOM   5164  CA  LEU A 620      31.212   4.051  52.310  1.00 68.04           C  
ATOM   5165  C   LEU A 620      31.709   3.687  53.733  1.00 69.97           C  
ATOM   5166  O   LEU A 620      30.921   3.413  54.661  1.00 70.89           O  
ATOM   5167  CB  LEU A 620      31.792   5.407  51.949  1.00 67.18           C  
ATOM   5168  CG  LEU A 620      31.494   5.979  50.572  1.00 66.78           C  
ATOM   5169  CD1 LEU A 620      31.552   7.468  50.637  1.00 66.08           C  
ATOM   5170  CD2 LEU A 620      32.469   5.477  49.519  1.00 67.07           C  
ATOM   5171  N   SER A 621      33.023   3.715  53.924  1.00 71.33           N  
ATOM   5172  CA  SER A 621      33.587   3.549  55.251  1.00 72.71           C  
ATOM   5173  C   SER A 621      33.080   4.584  56.244  1.00 73.43           C  
ATOM   5174  O   SER A 621      32.537   5.617  55.874  1.00 73.88           O  
ATOM   5175  CB  SER A 621      35.098   3.662  55.192  1.00 72.65           C  
ATOM   5176  OG  SER A 621      35.656   2.380  55.201  1.00 74.94           O  
ATOM   5177  N   GLU A 622      33.289   4.299  57.518  1.00 74.18           N  
ATOM   5178  CA  GLU A 622      33.126   5.295  58.561  1.00 74.56           C  
ATOM   5179  C   GLU A 622      31.809   6.039  58.531  1.00 73.08           C  
ATOM   5180  O   GLU A 622      31.803   7.249  58.695  1.00 73.88           O  
ATOM   5181  CB  GLU A 622      34.305   6.263  58.531  1.00 75.25           C  
ATOM   5182  CG  GLU A 622      35.396   5.863  59.538  1.00 81.55           C  
ATOM   5183  CD  GLU A 622      36.805   5.795  58.914  1.00 88.56           C  
ATOM   5184  OE1 GLU A 622      37.225   6.798  58.258  1.00 90.43           O  
ATOM   5185  OE2 GLU A 622      37.484   4.737  59.091  1.00 90.29           O  
ATOM   5186  N   ASP A 623      30.708   5.315  58.319  1.00 71.33           N  
ATOM   5187  CA  ASP A 623      29.351   5.863  58.451  1.00 69.77           C  
ATOM   5188  C   ASP A 623      29.018   7.007  57.535  1.00 67.86           C  
ATOM   5189  O   ASP A 623      28.387   7.973  57.933  1.00 67.23           O  
ATOM   5190  CB  ASP A 623      29.062   6.275  59.887  1.00 70.46           C  
ATOM   5191  CG  ASP A 623      28.512   5.146  60.700  1.00 73.24           C  
ATOM   5192  OD1 ASP A 623      27.850   4.255  60.093  1.00 76.44           O  
ATOM   5193  OD2 ASP A 623      28.757   5.145  61.933  1.00 76.18           O  
ATOM   5194  N   SER A 624      29.444   6.880  56.293  1.00 66.62           N  
ATOM   5195  CA  SER A 624      29.184   7.893  55.295  1.00 65.65           C  
ATOM   5196  C   SER A 624      28.531   7.296  54.042  1.00 64.79           C  
ATOM   5197  O   SER A 624      28.723   6.123  53.696  1.00 65.13           O  
ATOM   5198  CB  SER A 624      30.463   8.604  54.933  1.00 65.19           C  
ATOM   5199  OG  SER A 624      31.179   7.695  54.170  1.00 66.24           O  
ATOM   5200  N   VAL A 625      27.770   8.140  53.368  1.00 63.25           N  
ATOM   5201  CA  VAL A 625      26.727   7.706  52.485  1.00 61.91           C  
ATOM   5202  C   VAL A 625      26.622   8.649  51.283  1.00 61.79           C  
ATOM   5203  O   VAL A 625      26.309   9.821  51.431  1.00 62.24           O  
ATOM   5204  CB  VAL A 625      25.376   7.764  53.233  1.00 61.50           C  
ATOM   5205  CG1 VAL A 625      24.247   7.413  52.301  1.00 60.11           C  
ATOM   5206  CG2 VAL A 625      25.401   6.886  54.456  1.00 59.78           C  
ATOM   5207  N   ILE A 626      26.868   8.156  50.087  1.00 61.00           N  
ATOM   5208  CA  ILE A 626      26.484   8.943  48.940  1.00 60.49           C  
ATOM   5209  C   ILE A 626      24.957   8.961  48.836  1.00 60.42           C  
ATOM   5210  O   ILE A 626      24.339   7.966  48.538  1.00 60.80           O  
ATOM   5211  CB  ILE A 626      27.185   8.479  47.654  1.00 59.86           C  
ATOM   5212  CG1 ILE A 626      28.663   8.795  47.790  1.00 58.99           C  
ATOM   5213  CG2 ILE A 626      26.681   9.265  46.458  1.00 58.95           C  
ATOM   5214  CD1 ILE A 626      29.519   7.676  47.394  1.00 59.32           C  
ATOM   5215  N   LEU A 627      24.357  10.106  49.098  1.00 60.58           N  
ATOM   5216  CA  LEU A 627      22.918  10.230  49.029  1.00 60.92           C  
ATOM   5217  C   LEU A 627      22.483  11.156  47.901  1.00 61.60           C  
ATOM   5218  O   LEU A 627      23.007  12.242  47.769  1.00 61.83           O  
ATOM   5219  CB  LEU A 627      22.402  10.754  50.355  1.00 60.32           C  
ATOM   5220  CG  LEU A 627      20.920  10.968  50.503  1.00 59.56           C  
ATOM   5221  CD1 LEU A 627      20.219   9.726  50.070  1.00 61.84           C  
ATOM   5222  CD2 LEU A 627      20.663  11.221  51.936  1.00 59.21           C  
ATOM   5223  N   ALA A 628      21.522  10.718  47.097  1.00 62.25           N  
ATOM   5224  CA  ALA A 628      20.894  11.576  46.103  1.00 63.20           C  
ATOM   5225  C   ALA A 628      19.598  12.215  46.655  1.00 63.98           C  
ATOM   5226  O   ALA A 628      18.752  11.532  47.250  1.00 64.10           O  
ATOM   5227  CB  ALA A 628      20.611  10.781  44.855  1.00 63.04           C  
ATOM   5228  N   THR A 629      19.451  13.524  46.455  1.00 64.61           N  
ATOM   5229  CA  THR A 629      18.369  14.282  47.074  1.00 65.23           C  
ATOM   5230  C   THR A 629      17.303  14.773  46.120  1.00 66.40           C  
ATOM   5231  O   THR A 629      16.165  14.902  46.486  1.00 66.15           O  
ATOM   5232  CB  THR A 629      18.878  15.544  47.661  1.00 64.84           C  
ATOM   5233  OG1 THR A 629      20.021  15.272  48.450  1.00 64.74           O  
ATOM   5234  CG2 THR A 629      17.808  16.141  48.506  1.00 65.66           C  
ATOM   5235  N   TYR A 630      17.685  15.130  44.910  1.00 68.76           N  
ATOM   5236  CA  TYR A 630      16.712  15.594  43.957  1.00 70.55           C  
ATOM   5237  C   TYR A 630      16.655  14.596  42.843  1.00 72.01           C  
ATOM   5238  O   TYR A 630      17.575  13.766  42.696  1.00 71.39           O  
ATOM   5239  CB  TYR A 630      17.028  17.014  43.473  1.00 71.02           C  
ATOM   5240  CG  TYR A 630      18.379  17.243  42.813  1.00 70.93           C  
ATOM   5241  CD1 TYR A 630      18.472  17.386  41.409  1.00 71.39           C  
ATOM   5242  CD2 TYR A 630      19.545  17.376  43.576  1.00 68.73           C  
ATOM   5243  CE1 TYR A 630      19.695  17.623  40.775  1.00 70.63           C  
ATOM   5244  CE2 TYR A 630      20.777  17.601  42.961  1.00 70.00           C  
ATOM   5245  CZ  TYR A 630      20.850  17.717  41.559  1.00 71.69           C  
ATOM   5246  OH  TYR A 630      22.067  17.937  40.939  1.00 72.02           O  
ATOM   5247  N   ASN A 631      15.542  14.626  42.110  1.00 73.95           N  
ATOM   5248  CA  ASN A 631      15.377  13.720  40.984  1.00 75.88           C  
ATOM   5249  C   ASN A 631      16.114  14.271  39.800  1.00 77.94           C  
ATOM   5250  O   ASN A 631      16.487  15.446  39.796  1.00 78.44           O  
ATOM   5251  CB  ASN A 631      13.926  13.502  40.646  1.00 74.89           C  
ATOM   5252  CG  ASN A 631      13.164  12.952  41.784  1.00 73.75           C  
ATOM   5253  OD1 ASN A 631      13.381  11.835  42.206  1.00 72.70           O  
ATOM   5254  ND2 ASN A 631      12.259  13.740  42.305  1.00 73.97           N  
ATOM   5255  N   GLN A 632      16.360  13.410  38.821  1.00 80.45           N  
ATOM   5256  CA  GLN A 632      17.046  13.801  37.599  1.00 83.23           C  
ATOM   5257  C   GLN A 632      16.292  14.860  36.752  1.00 85.70           C  
ATOM   5258  O   GLN A 632      15.107  14.685  36.385  1.00 86.00           O  
ATOM   5259  CB  GLN A 632      17.380  12.555  36.763  1.00 83.13           C  
ATOM   5260  CG  GLN A 632      18.810  12.063  36.975  1.00 82.43           C  
ATOM   5261  CD  GLN A 632      19.058  10.634  36.541  1.00 80.58           C  
ATOM   5262  OE1 GLN A 632      18.159   9.788  36.540  1.00 77.06           O  
ATOM   5263  NE2 GLN A 632      20.307  10.353  36.196  1.00 80.76           N  
ATOM   5264  N   VAL A 633      16.973  15.970  36.478  1.00 88.06           N  
ATOM   5265  CA  VAL A 633      16.518  16.845  35.428  1.00 90.56           C  
ATOM   5266  C   VAL A 633      17.354  16.460  34.224  1.00 92.38           C  
ATOM   5267  O   VAL A 633      18.432  15.888  34.389  1.00 92.76           O  
ATOM   5268  CB  VAL A 633      16.702  18.323  35.754  1.00 90.68           C  
ATOM   5269  CG1 VAL A 633      15.558  19.112  35.117  1.00 90.60           C  
ATOM   5270  CG2 VAL A 633      16.758  18.563  37.281  1.00 90.65           C  
ATOM   5271  N   TYR A 634      16.839  16.733  33.027  1.00 94.67           N  
ATOM   5272  CA  TYR A 634      17.574  16.498  31.781  1.00 96.71           C  
ATOM   5273  C   TYR A 634      18.593  17.613  31.602  1.00 97.81           C  
ATOM   5274  O   TYR A 634      19.757  17.333  31.290  1.00 98.11           O  
ATOM   5275  CB  TYR A 634      16.613  16.420  30.580  1.00 97.35           C  
ATOM   5276  CG  TYR A 634      17.210  16.477  29.157  1.00 98.15           C  
ATOM   5277  CD1 TYR A 634      17.251  15.332  28.346  1.00 98.30           C  
ATOM   5278  CD2 TYR A 634      17.657  17.693  28.601  1.00 98.63           C  
ATOM   5279  CE1 TYR A 634      17.756  15.383  27.030  1.00 98.70           C  
ATOM   5280  CE2 TYR A 634      18.170  17.755  27.284  1.00 99.24           C  
ATOM   5281  CZ  TYR A 634      18.210  16.598  26.507  1.00 99.35           C  
ATOM   5282  OH  TYR A 634      18.714  16.654  25.217  1.00 99.40           O  
ATOM   5283  N   GLU A 635      18.166  18.868  31.804  1.00 98.90           N  
ATOM   5284  CA  GLU A 635      19.088  20.004  31.627  1.00 99.70           C  
ATOM   5285  C   GLU A 635      20.270  19.813  32.583  1.00 99.40           C  
ATOM   5286  O   GLU A 635      21.428  19.678  32.134  1.00 99.32           O  
ATOM   5287  CB  GLU A 635      18.439  21.386  31.877  1.00 99.96           C  
ATOM   5288  CG  GLU A 635      16.934  21.417  32.105  1.00101.85           C  
ATOM   5289  CD  GLU A 635      16.585  22.161  33.402  1.00104.54           C  
ATOM   5290  OE1 GLU A 635      17.452  22.219  34.311  1.00105.50           O  
ATOM   5291  OE2 GLU A 635      15.450  22.670  33.532  1.00104.83           O  
ATOM   5292  N   GLY A 636      19.944  19.758  33.884  1.00 98.94           N  
ATOM   5293  CA  GLY A 636      20.926  19.720  34.992  1.00 97.72           C  
ATOM   5294  C   GLY A 636      21.986  18.636  34.934  1.00 96.39           C  
ATOM   5295  O   GLY A 636      21.885  17.695  34.139  1.00 96.29           O  
ATOM   5296  N   THR A 637      23.017  18.795  35.764  1.00 95.12           N  
ATOM   5297  CA  THR A 637      23.985  17.717  36.040  1.00 93.93           C  
ATOM   5298  C   THR A 637      23.777  17.258  37.491  1.00 91.83           C  
ATOM   5299  O   THR A 637      24.239  17.926  38.415  1.00 91.80           O  
ATOM   5300  CB  THR A 637      25.477  18.176  35.817  1.00 94.63           C  
ATOM   5301  OG1 THR A 637      25.687  18.595  34.453  1.00 96.10           O  
ATOM   5302  CG2 THR A 637      26.455  17.062  36.155  1.00 94.09           C  
ATOM   5303  N   HIS A 638      23.063  16.143  37.682  1.00 89.28           N  
ATOM   5304  CA  HIS A 638      22.765  15.625  39.030  1.00 86.79           C  
ATOM   5305  C   HIS A 638      24.054  15.316  39.811  1.00 84.88           C  
ATOM   5306  O   HIS A 638      24.909  14.537  39.354  1.00 84.79           O  
ATOM   5307  CB  HIS A 638      21.788  14.396  39.015  1.00 87.08           C  
ATOM   5308  CG  HIS A 638      21.666  13.686  40.347  1.00 86.48           C  
ATOM   5309  ND1 HIS A 638      20.615  13.895  41.218  1.00 85.21           N  
ATOM   5310  CD2 HIS A 638      22.484  12.792  40.962  1.00 85.53           C  
ATOM   5311  CE1 HIS A 638      20.797  13.175  42.312  1.00 84.38           C  
ATOM   5312  NE2 HIS A 638      21.922  12.494  42.181  1.00 83.82           N  
ATOM   5313  N   GLN A 639      24.185  15.946  40.975  1.00 82.01           N  
ATOM   5314  CA  GLN A 639      25.256  15.624  41.880  1.00 79.96           C  
ATOM   5315  C   GLN A 639      24.679  15.381  43.262  1.00 77.96           C  
ATOM   5316  O   GLN A 639      24.071  16.280  43.852  1.00 77.76           O  
ATOM   5317  CB  GLN A 639      26.301  16.723  41.914  1.00 80.34           C  
ATOM   5318  CG  GLN A 639      27.239  16.740  40.738  1.00 82.61           C  
ATOM   5319  CD  GLN A 639      27.531  18.168  40.279  1.00 87.26           C  
ATOM   5320  OE1 GLN A 639      27.606  19.096  41.095  1.00 87.45           O  
ATOM   5321  NE2 GLN A 639      27.681  18.354  38.960  1.00 89.78           N  
ATOM   5322  N   PRO A 640      24.834  14.145  43.771  1.00 75.85           N  
ATOM   5323  CA  PRO A 640      24.409  13.813  45.107  1.00 74.31           C  
ATOM   5324  C   PRO A 640      25.331  14.349  46.166  1.00 72.77           C  
ATOM   5325  O   PRO A 640      26.452  14.770  45.906  1.00 72.32           O  
ATOM   5326  CB  PRO A 640      24.492  12.292  45.122  1.00 74.32           C  
ATOM   5327  CG  PRO A 640      25.542  11.987  44.190  1.00 74.75           C  
ATOM   5328  CD  PRO A 640      25.381  12.964  43.084  1.00 75.56           C  
ATOM   5329  N   ILE A 641      24.839  14.259  47.374  1.00 71.25           N  
ATOM   5330  CA  ILE A 641      25.489  14.764  48.518  1.00 70.15           C  
ATOM   5331  C   ILE A 641      26.150  13.625  49.328  1.00 69.89           C  
ATOM   5332  O   ILE A 641      25.747  12.457  49.257  1.00 69.68           O  
ATOM   5333  CB  ILE A 641      24.436  15.551  49.249  1.00 70.03           C  
ATOM   5334  CG1 ILE A 641      24.878  16.990  49.270  1.00 71.26           C  
ATOM   5335  CG2 ILE A 641      24.052  14.975  50.605  1.00 69.07           C  
ATOM   5336  CD1 ILE A 641      23.824  17.920  48.664  1.00 74.00           C  
ATOM   5337  N   LYS A 642      27.211  13.953  50.053  1.00 69.07           N  
ATOM   5338  CA  LYS A 642      27.847  12.966  50.897  1.00 68.30           C  
ATOM   5339  C   LYS A 642      27.600  13.326  52.350  1.00 68.41           C  
ATOM   5340  O   LYS A 642      27.939  14.411  52.813  1.00 68.82           O  
ATOM   5341  CB  LYS A 642      29.327  12.848  50.592  1.00 67.80           C  
ATOM   5342  CG  LYS A 642      30.062  12.022  51.593  1.00 66.28           C  
ATOM   5343  CD  LYS A 642      31.267  11.370  50.989  1.00 66.58           C  
ATOM   5344  CE  LYS A 642      32.456  12.303  50.855  1.00 67.20           C  
ATOM   5345  NZ  LYS A 642      33.647  11.442  51.061  1.00 70.61           N  
ATOM   5346  N   VAL A 643      26.963  12.409  53.050  1.00 68.51           N  
ATOM   5347  CA  VAL A 643      26.554  12.621  54.423  1.00 68.57           C  
ATOM   5348  C   VAL A 643      27.400  11.647  55.222  1.00 68.85           C  
ATOM   5349  O   VAL A 643      27.684  10.550  54.750  1.00 69.03           O  
ATOM   5350  CB  VAL A 643      25.054  12.288  54.606  1.00 68.41           C  
ATOM   5351  CG1 VAL A 643      24.676  12.290  56.054  1.00 67.20           C  
ATOM   5352  CG2 VAL A 643      24.173  13.249  53.824  1.00 67.92           C  
ATOM   5353  N   ARG A 644      27.787  12.042  56.425  1.00 68.66           N  
ATOM   5354  CA  ARG A 644      28.776  11.329  57.167  1.00 68.37           C  
ATOM   5355  C   ARG A 644      28.429  11.544  58.596  1.00 68.08           C  
ATOM   5356  O   ARG A 644      28.341  12.701  59.053  1.00 68.45           O  
ATOM   5357  CB  ARG A 644      30.130  11.955  56.887  1.00 68.83           C  
ATOM   5358  CG  ARG A 644      31.293  11.082  57.297  1.00 70.90           C  
ATOM   5359  CD  ARG A 644      32.533  11.910  57.520  1.00 72.11           C  
ATOM   5360  NE  ARG A 644      33.104  11.518  58.791  1.00 74.79           N  
ATOM   5361  CZ  ARG A 644      33.811  12.321  59.575  1.00 76.47           C  
ATOM   5362  NH1 ARG A 644      34.061  13.581  59.210  1.00 77.28           N  
ATOM   5363  NH2 ARG A 644      34.261  11.860  60.738  1.00 76.70           N  
ATOM   5364  N   LYS A 645      28.224  10.442  59.307  1.00 67.40           N  
ATOM   5365  CA  LYS A 645      27.874  10.495  60.714  1.00 66.86           C  
ATOM   5366  C   LYS A 645      29.150  10.575  61.486  1.00 66.76           C  
ATOM   5367  O   LYS A 645      29.841   9.601  61.640  1.00 66.97           O  
ATOM   5368  CB  LYS A 645      27.102   9.245  61.113  1.00 66.82           C  
ATOM   5369  CG  LYS A 645      26.589   9.236  62.527  1.00 66.26           C  
ATOM   5370  CD  LYS A 645      26.877   7.887  63.107  1.00 64.68           C  
ATOM   5371  CE  LYS A 645      26.091   7.608  64.371  1.00 62.34           C  
ATOM   5372  NZ  LYS A 645      25.990   6.119  64.584  1.00 58.88           N  
ATOM   5373  N   VAL A 646      29.480  11.758  61.953  1.00 67.53           N  
ATOM   5374  CA  VAL A 646      30.734  11.949  62.663  1.00 68.27           C  
ATOM   5375  C   VAL A 646      30.637  11.403  64.052  1.00 69.09           C  
ATOM   5376  O   VAL A 646      31.639  10.922  64.550  1.00 69.45           O  
ATOM   5377  CB  VAL A 646      31.152  13.412  62.751  1.00 68.16           C  
ATOM   5378  CG1 VAL A 646      32.178  13.605  63.850  1.00 68.14           C  
ATOM   5379  CG2 VAL A 646      31.715  13.850  61.452  1.00 68.27           C  
ATOM   5380  N   TYR A 647      29.464  11.513  64.687  1.00 70.24           N  
ATOM   5381  CA  TYR A 647      29.163  10.723  65.892  1.00 71.69           C  
ATOM   5382  C   TYR A 647      27.675  10.626  66.246  1.00 71.91           C  
ATOM   5383  O   TYR A 647      26.893  11.467  65.839  1.00 71.98           O  
ATOM   5384  CB  TYR A 647      30.017  11.174  67.093  1.00 72.35           C  
ATOM   5385  CG  TYR A 647      29.457  12.304  67.917  1.00 73.40           C  
ATOM   5386  CD1 TYR A 647      28.700  12.040  69.057  1.00 73.77           C  
ATOM   5387  CD2 TYR A 647      29.711  13.633  67.585  1.00 74.72           C  
ATOM   5388  CE1 TYR A 647      28.181  13.059  69.837  1.00 74.08           C  
ATOM   5389  CE2 TYR A 647      29.187  14.688  68.362  1.00 75.26           C  
ATOM   5390  CZ  TYR A 647      28.415  14.383  69.493  1.00 74.97           C  
ATOM   5391  OH  TYR A 647      27.887  15.394  70.295  1.00 75.15           O  
ATOM   5392  N   GLY A 648      27.290   9.593  66.995  1.00 72.08           N  
ATOM   5393  CA  GLY A 648      25.918   9.513  67.485  1.00 72.59           C  
ATOM   5394  C   GLY A 648      25.232   8.153  67.535  1.00 73.05           C  
ATOM   5395  O   GLY A 648      25.621   7.217  66.847  1.00 73.01           O  
ATOM   5396  N   GLU A 649      24.179   8.075  68.348  1.00 73.23           N  
ATOM   5397  CA  GLU A 649      23.460   6.843  68.631  1.00 73.28           C  
ATOM   5398  C   GLU A 649      22.533   6.340  67.517  1.00 73.22           C  
ATOM   5399  O   GLU A 649      21.991   5.246  67.660  1.00 73.91           O  
ATOM   5400  CB  GLU A 649      22.613   7.027  69.886  1.00 73.32           C  
ATOM   5401  CG  GLU A 649      23.347   7.624  71.047  1.00 76.27           C  
ATOM   5402  CD  GLU A 649      22.861   7.096  72.406  1.00 81.00           C  
ATOM   5403  OE1 GLU A 649      23.021   5.871  72.676  1.00 81.71           O  
ATOM   5404  OE2 GLU A 649      22.356   7.925  73.219  1.00 82.74           O  
ATOM   5405  N   LEU A 650      22.309   7.110  66.442  1.00 72.40           N  
ATOM   5406  CA  LEU A 650      21.382   6.671  65.385  1.00 71.43           C  
ATOM   5407  C   LEU A 650      22.076   6.135  64.131  1.00 70.82           C  
ATOM   5408  O   LEU A 650      23.218   6.492  63.849  1.00 70.83           O  
ATOM   5409  CB  LEU A 650      20.413   7.784  65.002  1.00 71.56           C  
ATOM   5410  CG  LEU A 650      19.119   7.848  65.811  1.00 72.51           C  
ATOM   5411  CD1 LEU A 650      18.649   9.281  66.022  1.00 72.64           C  
ATOM   5412  CD2 LEU A 650      18.024   7.038  65.136  1.00 74.29           C  
ATOM   5413  N   PRO A 651      21.388   5.264  63.374  1.00 69.94           N  
ATOM   5414  CA  PRO A 651      21.940   4.827  62.089  1.00 69.31           C  
ATOM   5415  C   PRO A 651      21.873   5.900  60.967  1.00 68.95           C  
ATOM   5416  O   PRO A 651      20.785   6.380  60.644  1.00 68.76           O  
ATOM   5417  CB  PRO A 651      21.069   3.602  61.746  1.00 69.12           C  
ATOM   5418  CG  PRO A 651      19.781   3.818  62.467  1.00 68.43           C  
ATOM   5419  CD  PRO A 651      20.100   4.606  63.688  1.00 69.59           C  
ATOM   5420  N   VAL A 652      23.015   6.236  60.354  1.00 68.32           N  
ATOM   5421  CA  VAL A 652      23.053   7.194  59.227  1.00 67.58           C  
ATOM   5422  C   VAL A 652      21.887   7.157  58.260  1.00 68.12           C  
ATOM   5423  O   VAL A 652      21.470   8.215  57.745  1.00 68.45           O  
ATOM   5424  CB  VAL A 652      24.268   7.061  58.332  1.00 66.81           C  
ATOM   5425  CG1 VAL A 652      25.361   7.905  58.849  1.00 67.07           C  
ATOM   5426  CG2 VAL A 652      24.670   5.634  58.171  1.00 66.32           C  
ATOM   5427  N   GLU A 653      21.374   5.960  57.982  1.00 67.95           N  
ATOM   5428  CA  GLU A 653      20.265   5.848  57.044  1.00 67.81           C  
ATOM   5429  C   GLU A 653      19.056   6.522  57.672  1.00 67.37           C  
ATOM   5430  O   GLU A 653      18.237   7.117  56.974  1.00 67.47           O  
ATOM   5431  CB  GLU A 653      19.946   4.396  56.646  1.00 67.97           C  
ATOM   5432  CG  GLU A 653      21.100   3.610  56.071  1.00 68.26           C  
ATOM   5433  CD  GLU A 653      22.031   3.033  57.148  1.00 70.74           C  
ATOM   5434  OE1 GLU A 653      21.916   3.397  58.345  1.00 72.88           O  
ATOM   5435  OE2 GLU A 653      22.892   2.203  56.800  1.00 70.75           O  
ATOM   5436  N   VAL A 654      18.944   6.455  58.988  1.00 66.67           N  
ATOM   5437  CA  VAL A 654      17.897   7.255  59.609  1.00 66.77           C  
ATOM   5438  C   VAL A 654      18.165   8.779  59.506  1.00 67.38           C  
ATOM   5439  O   VAL A 654      17.250   9.538  59.151  1.00 67.71           O  
ATOM   5440  CB  VAL A 654      17.577   6.823  61.038  1.00 66.30           C  
ATOM   5441  CG1 VAL A 654      16.908   7.981  61.808  1.00 64.54           C  
ATOM   5442  CG2 VAL A 654      16.716   5.580  60.982  1.00 64.79           C  
ATOM   5443  N   LEU A 655      19.400   9.200  59.811  1.00 67.15           N  
ATOM   5444  CA  LEU A 655      19.826  10.580  59.635  1.00 67.23           C  
ATOM   5445  C   LEU A 655      19.682  11.039  58.164  1.00 67.46           C  
ATOM   5446  O   LEU A 655      19.278  12.184  57.905  1.00 68.20           O  
ATOM   5447  CB  LEU A 655      21.270  10.763  60.089  1.00 67.25           C  
ATOM   5448  CG  LEU A 655      21.665  10.358  61.509  1.00 68.32           C  
ATOM   5449  CD1 LEU A 655      23.131  10.746  61.799  1.00 70.20           C  
ATOM   5450  CD2 LEU A 655      20.749  10.949  62.561  1.00 67.99           C  
ATOM   5451  N   CYS A 656      20.010  10.170  57.206  1.00 66.38           N  
ATOM   5452  CA  CYS A 656      19.757  10.494  55.824  1.00 65.82           C  
ATOM   5453  C   CYS A 656      18.271  10.678  55.535  1.00 65.72           C  
ATOM   5454  O   CYS A 656      17.899  11.663  54.914  1.00 66.60           O  
ATOM   5455  CB  CYS A 656      20.344   9.452  54.907  1.00 65.89           C  
ATOM   5456  SG  CYS A 656      22.136   9.530  54.754  1.00 68.40           S  
ATOM   5457  N   SER A 657      17.420   9.744  55.975  1.00 65.22           N  
ATOM   5458  CA  SER A 657      15.969   9.920  55.924  1.00 64.11           C  
ATOM   5459  C   SER A 657      15.554  11.331  56.460  1.00 63.22           C  
ATOM   5460  O   SER A 657      14.821  12.089  55.826  1.00 62.74           O  
ATOM   5461  CB  SER A 657      15.317   8.786  56.713  1.00 64.29           C  
ATOM   5462  OG  SER A 657      13.966   9.069  57.077  1.00 66.81           O  
ATOM   5463  N   GLN A 658      16.063  11.698  57.619  1.00 62.23           N  
ATOM   5464  CA  GLN A 658      15.770  13.010  58.159  1.00 62.12           C  
ATOM   5465  C   GLN A 658      16.107  14.073  57.116  1.00 61.87           C  
ATOM   5466  O   GLN A 658      15.273  14.926  56.767  1.00 62.11           O  
ATOM   5467  CB  GLN A 658      16.535  13.227  59.472  1.00 61.81           C  
ATOM   5468  CG  GLN A 658      16.232  12.131  60.492  1.00 62.45           C  
ATOM   5469  CD  GLN A 658      16.906  12.326  61.829  1.00 62.56           C  
ATOM   5470  OE1 GLN A 658      18.012  12.839  61.909  1.00 65.98           O  
ATOM   5471  NE2 GLN A 658      16.239  11.907  62.890  1.00 61.37           N  
ATOM   5472  N   ILE A 659      17.327  13.983  56.591  1.00 61.15           N  
ATOM   5473  CA  ILE A 659      17.826  14.966  55.665  1.00 59.81           C  
ATOM   5474  C   ILE A 659      16.876  15.066  54.478  1.00 59.67           C  
ATOM   5475  O   ILE A 659      16.444  16.159  54.126  1.00 60.12           O  
ATOM   5476  CB  ILE A 659      19.244  14.661  55.216  1.00 59.19           C  
ATOM   5477  CG1 ILE A 659      20.231  14.901  56.359  1.00 57.00           C  
ATOM   5478  CG2 ILE A 659      19.583  15.544  54.052  1.00 60.42           C  
ATOM   5479  CD1 ILE A 659      21.686  14.747  55.980  1.00 51.93           C  
ATOM   5480  N   LEU A 660      16.507  13.929  53.905  1.00 59.21           N  
ATOM   5481  CA  LEU A 660      15.483  13.909  52.859  1.00 59.27           C  
ATOM   5482  C   LEU A 660      14.174  14.638  53.263  1.00 59.25           C  
ATOM   5483  O   LEU A 660      13.635  15.463  52.501  1.00 59.09           O  
ATOM   5484  CB  LEU A 660      15.221  12.484  52.415  1.00 58.77           C  
ATOM   5485  CG  LEU A 660      16.408  11.843  51.703  1.00 59.84           C  
ATOM   5486  CD1 LEU A 660      16.108  10.385  51.414  1.00 62.59           C  
ATOM   5487  CD2 LEU A 660      16.759  12.565  50.398  1.00 58.66           C  
ATOM   5488  N   SER A 661      13.686  14.385  54.472  1.00 59.02           N  
ATOM   5489  CA  SER A 661      12.509  15.114  54.925  1.00 58.79           C  
ATOM   5490  C   SER A 661      12.735  16.633  54.860  1.00 58.10           C  
ATOM   5491  O   SER A 661      12.017  17.345  54.162  1.00 57.22           O  
ATOM   5492  CB  SER A 661      12.091  14.670  56.325  1.00 58.74           C  
ATOM   5493  OG  SER A 661      11.445  13.418  56.262  1.00 59.94           O  
ATOM   5494  N   LEU A 662      13.746  17.113  55.572  1.00 57.82           N  
ATOM   5495  CA  LEU A 662      14.013  18.548  55.628  1.00 57.75           C  
ATOM   5496  C   LEU A 662      14.150  19.243  54.238  1.00 57.65           C  
ATOM   5497  O   LEU A 662      13.736  20.380  54.085  1.00 57.80           O  
ATOM   5498  CB  LEU A 662      15.214  18.829  56.527  1.00 57.48           C  
ATOM   5499  CG  LEU A 662      15.077  18.364  57.967  1.00 57.41           C  
ATOM   5500  CD1 LEU A 662      16.187  18.938  58.846  1.00 57.28           C  
ATOM   5501  CD2 LEU A 662      13.722  18.737  58.524  1.00 58.20           C  
ATOM   5502  N   THR A 663      14.719  18.566  53.242  1.00 56.70           N  
ATOM   5503  CA  THR A 663      14.527  18.936  51.847  1.00 56.06           C  
ATOM   5504  C   THR A 663      13.187  19.616  51.504  1.00 56.01           C  
ATOM   5505  O   THR A 663      13.131  20.494  50.683  1.00 55.77           O  
ATOM   5506  CB  THR A 663      14.628  17.685  50.997  1.00 55.83           C  
ATOM   5507  OG1 THR A 663      15.914  17.647  50.384  1.00 56.31           O  
ATOM   5508  CG2 THR A 663      13.552  17.630  49.923  1.00 54.84           C  
ATOM   5509  N   LEU A 664      12.096  19.191  52.118  1.00 56.35           N  
ATOM   5510  CA  LEU A 664      10.798  19.640  51.676  1.00 56.35           C  
ATOM   5511  C   LEU A 664      10.531  20.938  52.401  1.00 56.68           C  
ATOM   5512  O   LEU A 664       9.651  21.715  52.035  1.00 57.82           O  
ATOM   5513  CB  LEU A 664       9.725  18.574  51.938  1.00 55.82           C  
ATOM   5514  CG  LEU A 664       9.930  17.207  51.246  1.00 57.06           C  
ATOM   5515  CD1 LEU A 664       9.480  16.030  52.083  1.00 58.86           C  
ATOM   5516  CD2 LEU A 664       9.235  17.124  49.919  1.00 59.80           C  
ATOM   5517  N   MET A 665      11.325  21.207  53.418  1.00 56.29           N  
ATOM   5518  CA  MET A 665      11.125  22.421  54.174  1.00 56.26           C  
ATOM   5519  C   MET A 665      11.750  23.598  53.502  1.00 56.73           C  
ATOM   5520  O   MET A 665      11.583  24.715  53.955  1.00 57.07           O  
ATOM   5521  CB  MET A 665      11.661  22.266  55.583  1.00 55.85           C  
ATOM   5522  CG  MET A 665      10.898  21.222  56.331  1.00 56.42           C  
ATOM   5523  SD  MET A 665       9.189  21.686  56.599  1.00 56.24           S  
ATOM   5524  CE  MET A 665       8.246  20.962  55.265  1.00 53.85           C  
ATOM   5525  N   ASN A 666      12.494  23.350  52.431  1.00 57.31           N  
ATOM   5526  CA  ASN A 666      12.950  24.430  51.583  1.00 57.89           C  
ATOM   5527  C   ASN A 666      11.791  25.102  50.854  1.00 57.61           C  
ATOM   5528  O   ASN A 666      11.942  26.208  50.361  1.00 57.48           O  
ATOM   5529  CB  ASN A 666      14.001  23.945  50.608  1.00 58.14           C  
ATOM   5530  CG  ASN A 666      15.310  23.662  51.285  1.00 60.52           C  
ATOM   5531  OD1 ASN A 666      15.808  24.490  52.045  1.00 64.94           O  
ATOM   5532  ND2 ASN A 666      15.882  22.481  51.024  1.00 62.60           N  
ATOM   5533  N   TYR A 667      10.636  24.447  50.825  1.00 57.37           N  
ATOM   5534  CA  TYR A 667       9.420  25.039  50.279  1.00 58.24           C  
ATOM   5535  C   TYR A 667       9.499  25.401  48.776  1.00 59.52           C  
ATOM   5536  O   TYR A 667       9.137  26.504  48.344  1.00 59.49           O  
ATOM   5537  CB  TYR A 667       8.957  26.218  51.146  1.00 57.51           C  
ATOM   5538  CG  TYR A 667       8.370  25.775  52.452  1.00 56.84           C  
ATOM   5539  CD1 TYR A 667       9.120  25.810  53.613  1.00 56.94           C  
ATOM   5540  CD2 TYR A 667       7.071  25.294  52.530  1.00 56.39           C  
ATOM   5541  CE1 TYR A 667       8.587  25.383  54.826  1.00 57.05           C  
ATOM   5542  CE2 TYR A 667       6.530  24.865  53.752  1.00 56.19           C  
ATOM   5543  CZ  TYR A 667       7.301  24.910  54.880  1.00 55.71           C  
ATOM   5544  OH  TYR A 667       6.806  24.494  56.069  1.00 56.18           O  
ATOM   5545  N   SER A 668       9.950  24.431  47.987  1.00 60.94           N  
ATOM   5546  CA  SER A 668      10.304  24.664  46.618  1.00 61.96           C  
ATOM   5547  C   SER A 668       9.998  23.439  45.779  1.00 63.15           C  
ATOM   5548  O   SER A 668      10.857  22.871  45.129  1.00 63.34           O  
ATOM   5549  CB  SER A 668      11.767  25.061  46.519  1.00 61.46           C  
ATOM   5550  OG  SER A 668      12.055  25.410  45.168  1.00 63.72           O  
ATOM   5551  N   SER A 669       8.734  23.044  45.796  1.00 65.08           N  
ATOM   5552  CA  SER A 669       8.260  21.865  45.084  1.00 66.54           C  
ATOM   5553  C   SER A 669       8.794  21.696  43.669  1.00 67.78           C  
ATOM   5554  O   SER A 669       9.118  20.586  43.262  1.00 68.54           O  
ATOM   5555  CB  SER A 669       6.741  21.903  45.043  1.00 66.20           C  
ATOM   5556  OG  SER A 669       6.209  21.585  46.314  1.00 68.64           O  
ATOM   5557  N   PHE A 670       8.880  22.796  42.922  1.00 69.39           N  
ATOM   5558  CA  PHE A 670       9.064  22.745  41.475  1.00 70.51           C  
ATOM   5559  C   PHE A 670      10.520  22.725  41.076  1.00 71.16           C  
ATOM   5560  O   PHE A 670      10.865  22.304  39.985  1.00 70.93           O  
ATOM   5561  CB  PHE A 670       8.435  23.966  40.854  1.00 70.86           C  
ATOM   5562  CG  PHE A 670       6.970  23.984  40.947  1.00 72.19           C  
ATOM   5563  CD1 PHE A 670       6.338  24.559  42.045  1.00 74.49           C  
ATOM   5564  CD2 PHE A 670       6.199  23.445  39.933  1.00 74.51           C  
ATOM   5565  CE1 PHE A 670       4.949  24.582  42.137  1.00 75.01           C  
ATOM   5566  CE2 PHE A 670       4.804  23.476  40.001  1.00 75.35           C  
ATOM   5567  CZ  PHE A 670       4.184  24.036  41.108  1.00 74.56           C  
ATOM   5568  N   GLN A 671      11.371  23.226  41.956  1.00 72.17           N  
ATOM   5569  CA  GLN A 671      12.782  23.279  41.674  1.00 73.03           C  
ATOM   5570  C   GLN A 671      13.590  22.471  42.691  1.00 72.75           C  
ATOM   5571  O   GLN A 671      13.549  22.724  43.905  1.00 71.89           O  
ATOM   5572  CB  GLN A 671      13.254  24.723  41.545  1.00 73.43           C  
ATOM   5573  CG  GLN A 671      12.445  25.466  40.473  1.00 78.04           C  
ATOM   5574  CD  GLN A 671      13.180  26.670  39.919  1.00 83.88           C  
ATOM   5575  OE1 GLN A 671      14.253  27.009  40.413  1.00 87.07           O  
ATOM   5576  NE2 GLN A 671      12.620  27.314  38.877  1.00 84.30           N  
ATOM   5577  N   PRO A 672      14.382  21.522  42.174  1.00 72.65           N  
ATOM   5578  CA  PRO A 672      15.114  20.582  42.985  1.00 72.62           C  
ATOM   5579  C   PRO A 672      15.980  21.420  43.915  1.00 72.45           C  
ATOM   5580  O   PRO A 672      16.507  22.448  43.473  1.00 73.36           O  
ATOM   5581  CB  PRO A 672      16.017  19.903  41.948  1.00 72.68           C  
ATOM   5582  CG  PRO A 672      16.156  20.947  40.853  1.00 72.22           C  
ATOM   5583  CD  PRO A 672      14.756  21.397  40.757  1.00 72.33           C  
ATOM   5584  N   ILE A 673      16.140  21.021  45.174  1.00 71.26           N  
ATOM   5585  CA  ILE A 673      17.143  21.684  46.011  1.00 69.37           C  
ATOM   5586  C   ILE A 673      18.039  20.660  46.706  1.00 68.08           C  
ATOM   5587  O   ILE A 673      17.570  19.876  47.493  1.00 68.23           O  
ATOM   5588  CB  ILE A 673      16.485  22.747  46.951  1.00 69.69           C  
ATOM   5589  CG1 ILE A 673      16.267  24.048  46.151  1.00 68.52           C  
ATOM   5590  CG2 ILE A 673      17.354  23.000  48.187  1.00 69.52           C  
ATOM   5591  CD1 ILE A 673      15.291  25.047  46.734  1.00 68.30           C  
ATOM   5592  N   LYS A 674      19.319  20.657  46.382  1.00 66.74           N  
ATOM   5593  CA  LYS A 674      20.255  19.631  46.855  1.00 65.94           C  
ATOM   5594  C   LYS A 674      20.236  19.441  48.390  1.00 65.31           C  
ATOM   5595  O   LYS A 674      20.280  18.309  48.889  1.00 64.59           O  
ATOM   5596  CB  LYS A 674      21.666  20.011  46.436  1.00 65.44           C  
ATOM   5597  CG  LYS A 674      22.362  18.984  45.642  1.00 68.40           C  
ATOM   5598  CD  LYS A 674      23.882  19.260  45.481  1.00 72.41           C  
ATOM   5599  CE  LYS A 674      24.203  20.369  44.432  1.00 76.15           C  
ATOM   5600  NZ  LYS A 674      25.509  21.088  44.685  1.00 74.02           N  
ATOM   5601  N   LEU A 675      20.146  20.554  49.122  1.00 63.98           N  
ATOM   5602  CA  LEU A 675      20.518  20.587  50.532  1.00 62.49           C  
ATOM   5603  C   LEU A 675      19.311  20.633  51.477  1.00 62.02           C  
ATOM   5604  O   LEU A 675      18.251  21.134  51.108  1.00 62.45           O  
ATOM   5605  CB  LEU A 675      21.482  21.772  50.782  1.00 62.23           C  
ATOM   5606  CG  LEU A 675      22.956  21.591  50.393  1.00 60.23           C  
ATOM   5607  CD1 LEU A 675      23.702  22.858  50.448  1.00 59.57           C  
ATOM   5608  CD2 LEU A 675      23.638  20.623  51.310  1.00 60.29           C  
ATOM   5609  N   PRO A 676      19.448  20.103  52.703  1.00 61.24           N  
ATOM   5610  CA  PRO A 676      18.233  20.158  53.502  1.00 60.84           C  
ATOM   5611  C   PRO A 676      18.062  21.555  54.020  1.00 60.31           C  
ATOM   5612  O   PRO A 676      19.036  22.296  54.113  1.00 60.10           O  
ATOM   5613  CB  PRO A 676      18.518  19.198  54.659  1.00 61.05           C  
ATOM   5614  CG  PRO A 676      20.006  19.216  54.810  1.00 61.44           C  
ATOM   5615  CD  PRO A 676      20.564  19.459  53.420  1.00 61.29           C  
ATOM   5616  N   ALA A 677      16.830  21.891  54.374  1.00 59.50           N  
ATOM   5617  CA  ALA A 677      16.497  23.221  54.804  1.00 58.31           C  
ATOM   5618  C   ALA A 677      17.412  23.736  55.918  1.00 58.33           C  
ATOM   5619  O   ALA A 677      17.663  24.945  55.992  1.00 59.15           O  
ATOM   5620  CB  ALA A 677      15.033  23.312  55.174  1.00 57.74           C  
ATOM   5621  N   THR A 678      17.956  22.852  56.748  1.00 58.06           N  
ATOM   5622  CA  THR A 678      18.848  23.286  57.852  1.00 58.38           C  
ATOM   5623  C   THR A 678      20.010  24.162  57.412  1.00 58.60           C  
ATOM   5624  O   THR A 678      20.340  25.158  58.067  1.00 58.71           O  
ATOM   5625  CB  THR A 678      19.496  22.109  58.540  1.00 58.04           C  
ATOM   5626  OG1 THR A 678      19.618  21.046  57.591  1.00 60.00           O  
ATOM   5627  CG2 THR A 678      18.655  21.655  59.691  1.00 58.19           C  
ATOM   5628  N   VAL A 679      20.626  23.780  56.298  1.00 58.75           N  
ATOM   5629  CA  VAL A 679      21.838  24.403  55.854  1.00 58.60           C  
ATOM   5630  C   VAL A 679      21.693  24.957  54.438  1.00 59.43           C  
ATOM   5631  O   VAL A 679      22.692  25.312  53.795  1.00 60.26           O  
ATOM   5632  CB  VAL A 679      23.001  23.396  55.908  1.00 58.23           C  
ATOM   5633  CG1 VAL A 679      23.345  23.021  57.314  1.00 55.87           C  
ATOM   5634  CG2 VAL A 679      22.640  22.168  55.114  1.00 58.94           C  
ATOM   5635  N   HIS A 680      20.466  25.026  53.933  1.00 60.04           N  
ATOM   5636  CA  HIS A 680      20.247  25.468  52.547  1.00 60.56           C  
ATOM   5637  C   HIS A 680      20.515  26.981  52.440  1.00 61.51           C  
ATOM   5638  O   HIS A 680      19.921  27.746  53.191  1.00 62.20           O  
ATOM   5639  CB  HIS A 680      18.826  25.122  52.063  1.00 59.57           C  
ATOM   5640  CG  HIS A 680      18.458  25.806  50.777  1.00 60.05           C  
ATOM   5641  ND1 HIS A 680      19.103  25.551  49.575  1.00 58.47           N  
ATOM   5642  CD2 HIS A 680      17.551  26.779  50.520  1.00 57.63           C  
ATOM   5643  CE1 HIS A 680      18.592  26.323  48.639  1.00 56.11           C  
ATOM   5644  NE2 HIS A 680      17.655  27.081  49.185  1.00 54.97           N  
ATOM   5645  N   TYR A 681      21.416  27.408  51.545  1.00 62.41           N  
ATOM   5646  CA  TYR A 681      21.770  28.836  51.388  1.00 63.47           C  
ATOM   5647  C   TYR A 681      22.568  29.382  52.533  1.00 63.57           C  
ATOM   5648  O   TYR A 681      22.946  30.548  52.504  1.00 64.00           O  
ATOM   5649  CB  TYR A 681      20.534  29.726  51.355  1.00 64.61           C  
ATOM   5650  CG  TYR A 681      20.066  30.289  50.040  1.00 66.40           C  
ATOM   5651  CD1 TYR A 681      19.449  31.527  50.003  1.00 67.67           C  
ATOM   5652  CD2 TYR A 681      20.185  29.581  48.852  1.00 67.67           C  
ATOM   5653  CE1 TYR A 681      18.969  32.056  48.824  1.00 68.77           C  
ATOM   5654  CE2 TYR A 681      19.716  30.106  47.643  1.00 68.31           C  
ATOM   5655  CZ  TYR A 681      19.096  31.341  47.638  1.00 68.73           C  
ATOM   5656  OH  TYR A 681      18.606  31.897  46.453  1.00 69.56           O  
ATOM   5657  N   SER A 682      22.748  28.595  53.584  1.00 63.53           N  
ATOM   5658  CA  SER A 682      23.481  29.065  54.737  1.00 63.59           C  
ATOM   5659  C   SER A 682      24.874  29.548  54.338  1.00 63.55           C  
ATOM   5660  O   SER A 682      25.314  30.587  54.800  1.00 63.55           O  
ATOM   5661  CB  SER A 682      23.576  27.974  55.788  1.00 63.72           C  
ATOM   5662  OG  SER A 682      22.298  27.632  56.271  1.00 64.85           O  
ATOM   5663  N   ASP A 683      25.551  28.819  53.459  1.00 63.72           N  
ATOM   5664  CA  ASP A 683      26.858  29.240  53.042  1.00 64.12           C  
ATOM   5665  C   ASP A 683      26.832  30.585  52.299  1.00 64.06           C  
ATOM   5666  O   ASP A 683      27.726  31.399  52.487  1.00 64.43           O  
ATOM   5667  CB  ASP A 683      27.550  28.176  52.214  1.00 64.47           C  
ATOM   5668  CG  ASP A 683      28.944  28.623  51.736  1.00 67.23           C  
ATOM   5669  OD1 ASP A 683      29.067  29.520  50.847  1.00 69.43           O  
ATOM   5670  OD2 ASP A 683      29.934  28.078  52.255  1.00 69.26           O  
ATOM   5671  N   LYS A 684      25.840  30.829  51.453  1.00 63.78           N  
ATOM   5672  CA  LYS A 684      25.774  32.120  50.774  1.00 63.82           C  
ATOM   5673  C   LYS A 684      25.604  33.265  51.795  1.00 63.39           C  
ATOM   5674  O   LYS A 684      26.281  34.321  51.711  1.00 63.03           O  
ATOM   5675  CB  LYS A 684      24.652  32.148  49.737  1.00 64.82           C  
ATOM   5676  CG  LYS A 684      24.797  31.084  48.674  1.00 67.57           C  
ATOM   5677  CD  LYS A 684      23.642  31.151  47.666  1.00 74.54           C  
ATOM   5678  CE  LYS A 684      23.658  29.929  46.662  1.00 75.17           C  
ATOM   5679  NZ  LYS A 684      23.077  30.312  45.279  1.00 79.30           N  
ATOM   5680  N   ILE A 685      24.725  33.036  52.775  1.00 62.23           N  
ATOM   5681  CA  ILE A 685      24.413  34.049  53.766  1.00 61.04           C  
ATOM   5682  C   ILE A 685      25.634  34.409  54.576  1.00 60.71           C  
ATOM   5683  O   ILE A 685      26.001  35.564  54.610  1.00 61.20           O  
ATOM   5684  CB  ILE A 685      23.218  33.673  54.624  1.00 60.80           C  
ATOM   5685  CG1 ILE A 685      21.957  34.027  53.851  1.00 60.64           C  
ATOM   5686  CG2 ILE A 685      23.210  34.457  55.897  1.00 60.25           C  
ATOM   5687  CD1 ILE A 685      20.733  33.353  54.330  1.00 62.10           C  
ATOM   5688  N   THR A 686      26.292  33.433  55.188  1.00 59.82           N  
ATOM   5689  CA  THR A 686      27.478  33.737  55.961  1.00 59.14           C  
ATOM   5690  C   THR A 686      28.423  34.510  55.086  1.00 59.07           C  
ATOM   5691  O   THR A 686      28.930  35.577  55.468  1.00 58.51           O  
ATOM   5692  CB  THR A 686      28.226  32.488  56.378  1.00 59.25           C  
ATOM   5693  OG1 THR A 686      28.514  31.722  55.212  1.00 58.85           O  
ATOM   5694  CG2 THR A 686      27.429  31.660  57.359  1.00 59.06           C  
ATOM   5695  N   LYS A 687      28.663  33.968  53.899  1.00 59.24           N  
ATOM   5696  CA  LYS A 687      29.641  34.578  52.999  1.00 59.97           C  
ATOM   5697  C   LYS A 687      29.262  35.990  52.608  1.00 59.97           C  
ATOM   5698  O   LYS A 687      30.110  36.877  52.479  1.00 59.97           O  
ATOM   5699  CB  LYS A 687      29.897  33.725  51.767  1.00 59.40           C  
ATOM   5700  CG  LYS A 687      31.320  33.262  51.739  1.00 60.78           C  
ATOM   5701  CD  LYS A 687      31.411  31.760  51.574  1.00 62.53           C  
ATOM   5702  CE  LYS A 687      32.772  31.242  51.966  1.00 62.15           C  
ATOM   5703  NZ  LYS A 687      32.847  29.809  51.560  1.00 66.86           N  
ATOM   5704  N   LEU A 688      27.977  36.189  52.427  1.00 60.07           N  
ATOM   5705  CA  LEU A 688      27.505  37.455  51.982  1.00 60.41           C  
ATOM   5706  C   LEU A 688      27.794  38.472  53.036  1.00 61.34           C  
ATOM   5707  O   LEU A 688      28.239  39.555  52.719  1.00 62.32           O  
ATOM   5708  CB  LEU A 688      26.019  37.358  51.718  1.00 60.17           C  
ATOM   5709  CG  LEU A 688      25.302  38.518  51.091  1.00 58.71           C  
ATOM   5710  CD1 LEU A 688      25.931  38.819  49.768  1.00 58.55           C  
ATOM   5711  CD2 LEU A 688      23.838  38.122  50.970  1.00 57.60           C  
ATOM   5712  N   MET A 689      27.586  38.106  54.298  1.00 62.42           N  
ATOM   5713  CA  MET A 689      27.676  39.061  55.400  1.00 63.13           C  
ATOM   5714  C   MET A 689      29.112  39.437  55.720  1.00 64.28           C  
ATOM   5715  O   MET A 689      29.357  40.529  56.162  1.00 64.71           O  
ATOM   5716  CB  MET A 689      26.957  38.553  56.654  1.00 62.66           C  
ATOM   5717  CG  MET A 689      25.466  38.220  56.483  1.00 61.37           C  
ATOM   5718  SD  MET A 689      24.369  39.605  56.058  1.00 61.10           S  
ATOM   5719  CE  MET A 689      24.878  39.934  54.374  1.00 57.93           C  
ATOM   5720  N   LEU A 690      30.050  38.530  55.485  1.00 65.94           N  
ATOM   5721  CA  LEU A 690      31.470  38.765  55.744  1.00 67.42           C  
ATOM   5722  C   LEU A 690      31.981  40.098  55.290  1.00 68.39           C  
ATOM   5723  O   LEU A 690      32.884  40.655  55.911  1.00 68.69           O  
ATOM   5724  CB  LEU A 690      32.343  37.699  55.069  1.00 67.64           C  
ATOM   5725  CG  LEU A 690      32.947  36.553  55.884  1.00 68.07           C  
ATOM   5726  CD1 LEU A 690      33.816  35.653  55.007  1.00 68.81           C  
ATOM   5727  CD2 LEU A 690      33.757  37.076  57.068  1.00 68.53           C  
ATOM   5728  N   ARG A 691      31.458  40.614  54.191  1.00 69.94           N  
ATOM   5729  CA  ARG A 691      31.978  41.901  53.724  1.00 72.18           C  
ATOM   5730  C   ARG A 691      31.414  43.012  54.580  1.00 72.37           C  
ATOM   5731  O   ARG A 691      32.131  43.938  54.971  1.00 72.15           O  
ATOM   5732  CB  ARG A 691      31.634  42.133  52.272  1.00 72.89           C  
ATOM   5733  CG  ARG A 691      31.890  40.934  51.403  1.00 76.07           C  
ATOM   5734  CD  ARG A 691      31.399  41.230  50.021  1.00 81.65           C  
ATOM   5735  NE  ARG A 691      31.729  40.123  49.151  1.00 86.87           N  
ATOM   5736  CZ  ARG A 691      30.992  39.721  48.121  1.00 89.83           C  
ATOM   5737  NH1 ARG A 691      29.851  40.344  47.808  1.00 91.82           N  
ATOM   5738  NH2 ARG A 691      31.396  38.673  47.412  1.00 90.79           N  
ATOM   5739  N   GLY A 692      30.118  42.875  54.863  1.00 73.12           N  
ATOM   5740  CA  GLY A 692      29.369  43.717  55.797  1.00 73.71           C  
ATOM   5741  C   GLY A 692      30.238  44.367  56.842  1.00 74.08           C  
ATOM   5742  O   GLY A 692      30.237  43.969  58.018  1.00 74.46           O  
ATOM   5743  N   ILE A 693      31.003  45.347  56.377  1.00 74.05           N  
ATOM   5744  CA  ILE A 693      31.749  46.247  57.227  1.00 74.29           C  
ATOM   5745  C   ILE A 693      30.890  46.561  58.449  1.00 74.22           C  
ATOM   5746  O   ILE A 693      29.897  47.280  58.332  1.00 74.57           O  
ATOM   5747  CB  ILE A 693      32.053  47.540  56.438  1.00 74.46           C  
ATOM   5748  CG1 ILE A 693      32.796  47.182  55.133  1.00 75.50           C  
ATOM   5749  CG2 ILE A 693      32.787  48.569  57.309  1.00 73.48           C  
ATOM   5750  CD1 ILE A 693      32.540  48.133  53.933  1.00 77.03           C  
ATOM   5751  N   GLU A 694      31.236  45.967  59.595  1.00 73.83           N  
ATOM   5752  CA  GLU A 694      30.562  46.239  60.865  1.00 73.56           C  
ATOM   5753  C   GLU A 694      29.748  45.065  61.449  1.00 73.66           C  
ATOM   5754  O   GLU A 694      29.158  44.268  60.691  1.00 73.72           O  
ATOM   5755  CB  GLU A 694      29.705  47.494  60.755  1.00 73.78           C  
ATOM   5756  CG  GLU A 694      28.582  47.598  61.729  1.00 75.02           C  
ATOM   5757  CD  GLU A 694      28.564  48.973  62.357  1.00 78.57           C  
ATOM   5758  OE1 GLU A 694      28.688  49.973  61.595  1.00 78.18           O  
ATOM   5759  OE2 GLU A 694      28.448  49.049  63.616  1.00 79.81           O  
ATOM   5760  N   PRO A 695      29.750  44.958  62.811  1.00 73.26           N  
ATOM   5761  CA  PRO A 695      29.042  44.035  63.712  1.00 72.42           C  
ATOM   5762  C   PRO A 695      27.600  43.732  63.358  1.00 71.39           C  
ATOM   5763  O   PRO A 695      26.882  44.571  62.812  1.00 71.24           O  
ATOM   5764  CB  PRO A 695      29.066  44.780  65.037  1.00 72.38           C  
ATOM   5765  CG  PRO A 695      30.358  45.470  65.020  1.00 73.27           C  
ATOM   5766  CD  PRO A 695      30.626  45.866  63.589  1.00 73.22           C  
ATOM   5767  N   ILE A 696      27.189  42.518  63.695  1.00 70.24           N  
ATOM   5768  CA  ILE A 696      25.892  42.011  63.326  1.00 69.28           C  
ATOM   5769  C   ILE A 696      25.453  41.081  64.444  1.00 68.41           C  
ATOM   5770  O   ILE A 696      26.228  40.245  64.929  1.00 67.61           O  
ATOM   5771  CB  ILE A 696      25.936  41.266  61.946  1.00 69.11           C  
ATOM   5772  CG1 ILE A 696      26.436  42.205  60.853  1.00 69.62           C  
ATOM   5773  CG2 ILE A 696      24.570  40.722  61.566  1.00 68.93           C  
ATOM   5774  CD1 ILE A 696      26.588  41.581  59.481  1.00 70.57           C  
ATOM   5775  N   LYS A 697      24.208  41.281  64.864  1.00 67.81           N  
ATOM   5776  CA  LYS A 697      23.503  40.384  65.758  1.00 67.43           C  
ATOM   5777  C   LYS A 697      22.027  40.438  65.430  1.00 66.79           C  
ATOM   5778  O   LYS A 697      21.338  41.397  65.769  1.00 66.88           O  
ATOM   5779  CB  LYS A 697      23.728  40.746  67.234  1.00 67.69           C  
ATOM   5780  CG  LYS A 697      24.512  39.687  67.996  1.00 69.38           C  
ATOM   5781  CD  LYS A 697      24.189  39.684  69.473  1.00 72.22           C  
ATOM   5782  CE  LYS A 697      25.237  38.880  70.255  1.00 74.07           C  
ATOM   5783  NZ  LYS A 697      25.524  39.487  71.598  1.00 74.84           N  
ATOM   5784  N   LYS A 698      21.543  39.414  64.749  1.00 65.92           N  
ATOM   5785  CA  LYS A 698      20.144  39.343  64.413  1.00 65.38           C  
ATOM   5786  C   LYS A 698      19.617  37.939  64.700  1.00 65.40           C  
ATOM   5787  O   LYS A 698      20.325  36.938  64.578  1.00 65.81           O  
ATOM   5788  CB  LYS A 698      19.928  39.685  62.934  1.00 65.05           C  
ATOM   5789  CG  LYS A 698      20.613  40.928  62.439  1.00 64.72           C  
ATOM   5790  CD  LYS A 698      19.686  41.675  61.506  1.00 66.04           C  
ATOM   5791  CE  LYS A 698      19.807  43.203  61.648  1.00 67.19           C  
ATOM   5792  NZ  LYS A 698      18.623  43.938  61.053  1.00 67.27           N  
ATOM   5793  N   GLU A 699      18.358  37.866  65.076  1.00 64.99           N  
ATOM   5794  CA  GLU A 699      17.677  36.608  65.132  1.00 64.58           C  
ATOM   5795  C   GLU A 699      16.329  36.842  64.505  1.00 63.89           C  
ATOM   5796  O   GLU A 699      15.953  37.984  64.278  1.00 64.07           O  
ATOM   5797  CB  GLU A 699      17.513  36.218  66.579  1.00 65.33           C  
ATOM   5798  CG  GLU A 699      16.603  37.142  67.370  1.00 67.31           C  
ATOM   5799  CD  GLU A 699      15.979  36.451  68.577  1.00 70.78           C  
ATOM   5800  OE1 GLU A 699      16.226  35.238  68.783  1.00 71.75           O  
ATOM   5801  OE2 GLU A 699      15.249  37.125  69.337  1.00 72.62           O  
ATOM   5802  N   GLY A 700      15.587  35.785  64.227  1.00 63.03           N  
ATOM   5803  CA  GLY A 700      14.262  35.964  63.671  1.00 63.10           C  
ATOM   5804  C   GLY A 700      13.590  34.635  63.642  1.00 63.42           C  
ATOM   5805  O   GLY A 700      14.192  33.672  64.056  1.00 63.91           O  
ATOM   5806  N   ASP A 701      12.355  34.575  63.154  1.00 64.08           N  
ATOM   5807  CA  ASP A 701      11.577  33.340  63.115  1.00 64.92           C  
ATOM   5808  C   ASP A 701      10.868  33.159  61.777  1.00 65.65           C  
ATOM   5809  O   ASP A 701       9.803  32.525  61.716  1.00 66.36           O  
ATOM   5810  CB  ASP A 701      10.525  33.390  64.206  1.00 65.23           C  
ATOM   5811  CG  ASP A 701       9.739  34.700  64.196  1.00 67.26           C  
ATOM   5812  OD1 ASP A 701       9.689  35.335  63.110  1.00 68.87           O  
ATOM   5813  OD2 ASP A 701       9.195  35.103  65.269  1.00 68.68           O  
ATOM   5814  N   ILE A 702      11.455  33.711  60.717  1.00 65.64           N  
ATOM   5815  CA  ILE A 702      10.820  33.787  59.414  1.00 65.64           C  
ATOM   5816  C   ILE A 702      11.866  33.478  58.347  1.00 65.71           C  
ATOM   5817  O   ILE A 702      12.932  34.097  58.324  1.00 65.90           O  
ATOM   5818  CB  ILE A 702      10.166  35.179  59.218  1.00 65.60           C  
ATOM   5819  CG1 ILE A 702       8.680  35.111  59.538  1.00 66.13           C  
ATOM   5820  CG2 ILE A 702      10.334  35.726  57.785  1.00 65.98           C  
ATOM   5821  CD1 ILE A 702       8.089  36.481  60.027  1.00 70.06           C  
ATOM   5822  N   MET A 703      11.577  32.523  57.471  1.00 65.46           N  
ATOM   5823  CA  MET A 703      12.595  32.067  56.523  1.00 65.96           C  
ATOM   5824  C   MET A 703      12.839  33.101  55.431  1.00 65.70           C  
ATOM   5825  O   MET A 703      12.528  32.869  54.244  1.00 66.01           O  
ATOM   5826  CB  MET A 703      12.219  30.720  55.925  1.00 65.62           C  
ATOM   5827  CG  MET A 703      11.446  29.873  56.905  1.00 66.91           C  
ATOM   5828  SD  MET A 703      11.186  28.192  56.358  1.00 67.57           S  
ATOM   5829  CE  MET A 703      12.864  27.541  56.415  1.00 66.82           C  
ATOM   5830  N   TYR A 704      13.421  34.234  55.833  1.00 64.87           N  
ATOM   5831  CA  TYR A 704      13.548  35.380  54.950  1.00 64.15           C  
ATOM   5832  C   TYR A 704      14.411  35.123  53.736  1.00 64.32           C  
ATOM   5833  O   TYR A 704      14.412  35.923  52.796  1.00 64.98           O  
ATOM   5834  CB  TYR A 704      14.099  36.584  55.704  1.00 63.81           C  
ATOM   5835  CG  TYR A 704      15.575  36.552  55.933  1.00 61.82           C  
ATOM   5836  CD1 TYR A 704      16.448  37.077  55.007  1.00 61.17           C  
ATOM   5837  CD2 TYR A 704      16.090  36.020  57.076  1.00 61.51           C  
ATOM   5838  CE1 TYR A 704      17.802  37.053  55.212  1.00 62.24           C  
ATOM   5839  CE2 TYR A 704      17.448  36.000  57.303  1.00 62.51           C  
ATOM   5840  CZ  TYR A 704      18.304  36.509  56.370  1.00 62.75           C  
ATOM   5841  OH  TYR A 704      19.668  36.462  56.586  1.00 62.83           O  
ATOM   5842  N   TRP A 705      15.142  34.017  53.747  1.00 64.18           N  
ATOM   5843  CA  TRP A 705      16.192  33.807  52.763  1.00 64.52           C  
ATOM   5844  C   TRP A 705      15.728  32.975  51.583  1.00 65.68           C  
ATOM   5845  O   TRP A 705      16.495  32.778  50.640  1.00 66.19           O  
ATOM   5846  CB  TRP A 705      17.434  33.173  53.407  1.00 63.65           C  
ATOM   5847  CG  TRP A 705      17.137  31.860  53.957  1.00 62.29           C  
ATOM   5848  CD1 TRP A 705      17.189  30.691  53.307  1.00 61.95           C  
ATOM   5849  CD2 TRP A 705      16.663  31.577  55.262  1.00 61.29           C  
ATOM   5850  NE1 TRP A 705      16.790  29.687  54.116  1.00 62.30           N  
ATOM   5851  CE2 TRP A 705      16.468  30.205  55.336  1.00 60.96           C  
ATOM   5852  CE3 TRP A 705      16.398  32.356  56.388  1.00 63.12           C  
ATOM   5853  CZ2 TRP A 705      16.018  29.577  56.485  1.00 62.19           C  
ATOM   5854  CZ3 TRP A 705      15.946  31.738  57.529  1.00 62.49           C  
ATOM   5855  CH2 TRP A 705      15.754  30.358  57.566  1.00 62.42           C  
ATOM   5856  N   LEU A 706      14.495  32.475  51.613  1.00 66.60           N  
ATOM   5857  CA  LEU A 706      14.003  31.737  50.454  1.00 68.01           C  
ATOM   5858  C   LEU A 706      13.713  32.640  49.214  1.00 68.91           C  
ATOM   5859  O   LEU A 706      13.473  32.141  48.091  1.00 69.27           O  
ATOM   5860  CB  LEU A 706      12.813  30.857  50.837  1.00 67.83           C  
ATOM   5861  CG  LEU A 706      13.084  29.793  51.925  1.00 69.50           C  
ATOM   5862  CD1 LEU A 706      11.910  28.858  51.961  1.00 69.71           C  
ATOM   5863  CD2 LEU A 706      14.410  28.970  51.826  1.00 69.22           C  
ATOM   5864  OXT LEU A 706      13.750  33.901  49.277  1.00 69.05           O  
TER    5865      LEU A 706                                                      
END
MOLECULE T0487.pdb
ATOM      1  N   HIS     3       6.444   3.101  48.834  1.00100.07           N  
ATOM      2  CA  HIS     3       7.887   3.258  48.495  1.00100.10           C  
ATOM      3  C   HIS     3       8.767   2.608  49.561  1.00100.38           C  
ATOM      4  O   HIS     3       9.001   3.170  50.631  1.00 99.89           O  
ATOM      5  CB  HIS     3       8.221   4.732  48.363  1.00100.17           C  
ATOM      6  N   LEU     4       9.248   1.411  49.254  1.00101.22           N  
ATOM      7  CA  LEU     4      10.099   0.642  50.163  1.00101.53           C  
ATOM      8  C   LEU     4      10.968  -0.280  49.298  1.00100.87           C  
ATOM      9  O   LEU     4      11.951  -0.859  49.776  1.00100.42           O  
ATOM     10  CB  LEU     4       9.234  -0.217  51.097  1.00102.35           C  
ATOM     11  CG  LEU     4       8.663  -1.477  50.415  1.00103.57           C  
ATOM     12  CD1 LEU     4       9.551  -2.686  50.735  1.00102.75           C  
ATOM     13  CD2 LEU     4       7.231  -1.727  50.870  1.00103.45           C  
ATOM     14  N   GLY     5      10.578  -0.410  48.028  1.00 99.44           N  
ATOM     15  CA  GLY     5      11.292  -1.261  47.092  1.00 98.33           C  
ATOM     16  C   GLY     5      12.740  -0.882  46.835  1.00 97.37           C  
ATOM     17  O   GLY     5      13.083   0.297  46.751  1.00 97.09           O  
ATOM     18  N   LYS     6      13.596  -1.892  46.707  1.00 96.15           N  
ATOM     19  CA  LYS     6      15.014  -1.665  46.456  1.00 95.16           C  
ATOM     20  C   LYS     6      15.289  -1.631  44.955  1.00 94.70           C  
ATOM     21  O   LYS     6      14.628  -2.312  44.167  1.00 94.81           O  
ATOM     22  CB  LYS     6      15.846  -2.747  47.123  1.00 94.76           C  
ATOM     23  N   THR     7      16.266  -0.824  44.562  1.00 93.91           N  
ATOM     24  CA  THR     7      16.623  -0.684  43.156  1.00 92.09           C  
ATOM     25  C   THR     7      18.126  -0.728  42.973  1.00 90.89           C  
ATOM     26  O   THR     7      18.849   0.108  43.509  1.00 92.51           O  
ATOM     27  CB  THR     7      16.097   0.644  42.578  1.00 92.12           C  
ATOM     28  OG1 THR     7      14.673   0.570  42.444  1.00 91.76           O  
ATOM     29  CG2 THR     7      16.723   0.929  41.223  1.00 91.89           C  
ATOM     30  N   GLU     8      18.587  -1.720  42.220  1.00 89.04           N  
ATOM     31  CA  GLU     8      20.005  -1.880  41.943  1.00 86.13           C  
ATOM     32  C   GLU     8      20.441  -0.604  41.234  1.00 83.12           C  
ATOM     33  O   GLU     8      19.669  -0.009  40.489  1.00 82.79           O  
ATOM     34  CB  GLU     8      20.238  -3.103  41.037  1.00 87.94           C  
ATOM     35  CG  GLU     8      19.639  -2.997  39.623  1.00 89.17           C  
ATOM     36  CD  GLU     8      18.185  -3.458  39.524  1.00 90.74           C  
ATOM     37  OE1 GLU     8      17.400  -3.210  40.469  1.00 91.91           O  
ATOM     38  OE2 GLU     8      17.822  -4.055  38.482  1.00 89.73           O  
ATOM     39  N   VAL     9      21.669  -0.171  41.467  1.00 80.15           N  
ATOM     40  CA  VAL     9      22.138   1.040  40.821  1.00 77.34           C  
ATOM     41  C   VAL     9      23.649   1.005  40.649  1.00 76.06           C  
ATOM     42  O   VAL     9      24.368   0.448  41.477  1.00 75.33           O  
ATOM     43  CB  VAL     9      21.714   2.285  41.645  1.00 77.24           C  
ATOM     44  CG1 VAL     9      22.823   2.702  42.630  1.00 74.28           C  
ATOM     45  CG2 VAL     9      21.328   3.405  40.707  1.00 75.83           C  
ATOM     46  N   PHE    10      24.131   1.579  39.556  1.00 75.53           N  
ATOM     47  CA  PHE    10      25.570   1.617  39.310  1.00 74.88           C  
ATOM     48  C   PHE    10      26.150   2.979  39.661  1.00 72.88           C  
ATOM     49  O   PHE    10      25.668   4.020  39.198  1.00 71.03           O  
ATOM     50  CB  PHE    10      25.901   1.317  37.840  1.00 77.26           C  
ATOM     51  CG  PHE    10      26.232  -0.125  37.563  1.00 79.72           C  
ATOM     52  CD1 PHE    10      27.288  -0.753  38.220  1.00 80.92           C  
ATOM     53  CD2 PHE    10      25.480  -0.860  36.648  1.00 80.62           C  
ATOM     54  CE1 PHE    10      27.588  -2.098  37.969  1.00 80.62           C  
ATOM     55  CE2 PHE    10      25.772  -2.197  36.393  1.00 80.67           C  
ATOM     56  CZ  PHE    10      26.827  -2.816  37.056  1.00 80.56           C  
ATOM     57  N   LEU    11      27.178   2.957  40.500  1.00 70.62           N  
ATOM     58  CA  LEU    11      27.883   4.167  40.885  1.00 69.43           C  
ATOM     59  C   LEU    11      29.014   4.315  39.873  1.00 68.78           C  
ATOM     60  O   LEU    11      29.307   3.379  39.126  1.00 70.60           O  
ATOM     61  CB  LEU    11      28.482   4.019  42.281  1.00 67.43           C  
ATOM     62  CG  LEU    11      27.514   3.779  43.442  1.00 66.66           C  
ATOM     63  CD1 LEU    11      28.327   3.702  44.721  1.00 65.31           C  
ATOM     64  CD2 LEU    11      26.482   4.889  43.537  1.00 64.31           C  
ATOM     65  N   ASN    12      29.646   5.479  39.824  1.00 67.02           N  
ATOM     66  CA  ASN    12      30.751   5.642  38.903  1.00 62.74           C  
ATOM     67  C   ASN    12      32.026   5.374  39.683  1.00 60.87           C  
ATOM     68  O   ASN    12      33.004   6.107  39.597  1.00 60.45           O  
ATOM     69  CB  ASN    12      30.726   7.031  38.246  1.00 63.10           C  
ATOM     70  CG  ASN    12      30.974   8.155  39.213  1.00 62.68           C  
ATOM     71  OD1 ASN    12      30.782   8.014  40.421  1.00 62.56           O  
ATOM     72  ND2 ASN    12      31.393   9.301  38.678  1.00 62.62           N  
ATOM     73  N   ARG    13      31.973   4.298  40.466  1.00 59.39           N  
ATOM     74  CA  ARG    13      33.105   3.822  41.263  1.00 59.66           C  
ATOM     75  C   ARG    13      33.481   2.448  40.739  1.00 58.30           C  
ATOM     76  O   ARG    13      32.677   1.781  40.081  1.00 57.95           O  
ATOM     77  CB  ARG    13      32.738   3.647  42.732  1.00 61.21           C  
ATOM     78  CG  ARG    13      32.238   4.874  43.367  1.00 64.16           C  
ATOM     79  CD  ARG    13      31.922   4.635  44.811  1.00 64.95           C  
ATOM     80  NE  ARG    13      31.799   5.931  45.453  1.00 67.21           N  
ATOM     81  CZ  ARG    13      31.859   6.124  46.754  1.00 67.14           C  
ATOM     82  NH1 ARG    13      32.031   5.086  47.557  1.00 67.21           N  
ATOM     83  NH2 ARG    13      31.788   7.358  47.235  1.00 67.78           N  
ATOM     84  N   PHE    14      34.693   2.018  41.061  1.00 56.41           N  
ATOM     85  CA  PHE    14      35.175   0.726  40.616  1.00 56.49           C  
ATOM     86  C   PHE    14      36.086   0.154  41.681  1.00 57.15           C  
ATOM     87  O   PHE    14      36.900   0.879  42.249  1.00 58.82           O  
ATOM     88  CB  PHE    14      35.932   0.875  39.278  1.00 53.89           C  
ATOM     89  CG  PHE    14      35.121   1.536  38.191  1.00 49.26           C  
ATOM     90  CD1 PHE    14      34.945   2.918  38.170  1.00 47.28           C  
ATOM     91  CD2 PHE    14      34.490   0.773  37.217  1.00 47.81           C  
ATOM     92  CE1 PHE    14      34.149   3.519  37.193  1.00 45.49           C  
ATOM     93  CE2 PHE    14      33.687   1.367  36.231  1.00 43.95           C  
ATOM     94  CZ  PHE    14      33.520   2.730  36.220  1.00 45.62           C  
ATOM     95  N   ALA    15      35.957  -1.144  41.949  1.00 58.08           N  
ATOM     96  CA  ALA    15      36.778  -1.786  42.977  1.00 58.87           C  
ATOM     97  C   ALA    15      38.078  -2.370  42.429  1.00 59.13           C  
ATOM     98  O   ALA    15      38.104  -2.971  41.355  1.00 58.72           O  
ATOM     99  CB  ALA    15      35.973  -2.871  43.685  1.00 57.67           C  
ATOM    100  N   LEU    16      39.158  -2.183  43.178  1.00 59.18           N  
ATOM    101  CA  LEU    16      40.451  -2.692  42.771  1.00 60.54           C  
ATOM    102  C   LEU    16      41.004  -3.676  43.799  1.00 62.32           C  
ATOM    103  O   LEU    16      40.410  -3.886  44.849  1.00 61.77           O  
ATOM    104  CB  LEU    16      41.408  -1.530  42.524  1.00 60.96           C  
ATOM    105  CG  LEU    16      40.958  -0.626  41.353  1.00 62.16           C  
ATOM    106  CD1 LEU    16      41.844   0.609  41.279  1.00 60.09           C  
ATOM    107  CD2 LEU    16      41.002  -1.395  40.025  1.00 60.38           C  
ATOM    108  N   ARG    17      42.132  -4.299  43.491  1.00 64.81           N  
ATOM    109  CA  ARG    17      42.691  -5.285  44.397  1.00 67.20           C  
ATOM    110  C   ARG    17      42.740  -4.768  45.820  1.00 70.61           C  
ATOM    111  O   ARG    17      42.742  -3.564  46.052  1.00 71.60           O  
ATOM    112  CB  ARG    17      44.097  -5.685  43.957  1.00 65.33           C  
ATOM    113  CG  ARG    17      45.128  -4.601  44.135  1.00 65.08           C  
ATOM    114  CD  ARG    17      46.521  -5.172  44.309  1.00 63.68           C  
ATOM    115  NE  ARG    17      47.310  -4.329  45.200  1.00 65.95           N  
ATOM    116  CZ  ARG    17      48.390  -3.652  44.826  1.00 68.32           C  
ATOM    117  NH1 ARG    17      48.821  -3.724  43.574  1.00 70.06           N  
ATOM    118  NH2 ARG    17      49.024  -2.876  45.692  1.00 68.14           N  
ATOM    119  N   PRO    18      42.737  -5.676  46.804  1.00 73.90           N  
ATOM    120  CA  PRO    18      42.797  -5.206  48.191  1.00 75.11           C  
ATOM    121  C   PRO    18      44.229  -4.734  48.409  1.00 76.77           C  
ATOM    122  O   PRO    18      45.119  -5.076  47.631  1.00 76.09           O  
ATOM    123  CB  PRO    18      42.485  -6.464  48.998  1.00 74.96           C  
ATOM    124  CG  PRO    18      41.629  -7.278  48.054  1.00 74.85           C  
ATOM    125  CD  PRO    18      42.363  -7.100  46.749  1.00 74.46           C  
ATOM    126  N   LEU    19      44.460  -3.939  49.445  1.00 79.33           N  
ATOM    127  CA  LEU    19      45.815  -3.482  49.711  1.00 81.93           C  
ATOM    128  C   LEU    19      46.609  -4.638  50.331  1.00 84.42           C  
ATOM    129  O   LEU    19      46.132  -5.323  51.247  1.00 84.14           O  
ATOM    130  CB  LEU    19      45.805  -2.274  50.657  1.00 81.55           C  
ATOM    131  CG  LEU    19      45.371  -0.907  50.111  1.00 82.04           C  
ATOM    132  CD1 LEU    19      43.983  -1.003  49.491  1.00 82.27           C  
ATOM    133  CD2 LEU    19      45.377   0.124  51.236  1.00 81.12           C  
ATOM    134  N   ASN    20      47.811  -4.867  49.810  1.00 86.67           N  
ATOM    135  CA  ASN    20      48.664  -5.925  50.321  1.00 89.22           C  
ATOM    136  C   ASN    20      49.231  -5.463  51.655  1.00 91.10           C  
ATOM    137  O   ASN    20      49.189  -4.273  51.968  1.00 91.62           O  
ATOM    138  CB  ASN    20      49.797  -6.223  49.332  1.00 90.95           C  
ATOM    139  CG  ASN    20      50.740  -5.042  49.129  1.00 92.05           C  
ATOM    140  OD1 ASN    20      51.271  -4.479  50.088  1.00 93.47           O  
ATOM    141  ND2 ASN    20      50.972  -4.680  47.872  1.00 91.60           N  
ATOM    142  N   PRO    21      49.758  -6.394  52.469  1.00 92.64           N  
ATOM    143  CA  PRO    21      50.329  -6.043  53.777  1.00 93.03           C  
ATOM    144  C   PRO    21      51.253  -4.819  53.795  1.00 93.26           C  
ATOM    145  O   PRO    21      51.094  -3.941  54.648  1.00 94.03           O  
ATOM    146  CB  PRO    21      51.036  -7.333  54.212  1.00 93.16           C  
ATOM    147  CG  PRO    21      51.168  -8.143  52.932  1.00 93.95           C  
ATOM    148  CD  PRO    21      49.887  -7.837  52.217  1.00 92.99           C  
ATOM    149  N   GLU    22      52.196  -4.748  52.855  1.00 92.42           N  
ATOM    150  CA  GLU    22      53.135  -3.621  52.783  1.00 92.25           C  
ATOM    151  C   GLU    22      52.464  -2.242  52.784  1.00 90.18           C  
ATOM    152  O   GLU    22      52.927  -1.316  53.438  1.00 88.53           O  
ATOM    153  CB  GLU    22      54.008  -3.731  51.525  1.00 94.48           C  
ATOM    154  CG  GLU    22      54.916  -4.942  51.487  1.00 98.22           C  
ATOM    155  CD  GLU    22      54.143  -6.239  51.645  1.00101.59           C  
ATOM    156  OE1 GLU    22      53.215  -6.484  50.842  1.00101.73           O  
ATOM    157  OE2 GLU    22      54.462  -7.014  52.577  1.00103.69           O  
ATOM    158  N   GLU    23      51.374  -2.113  52.040  1.00 89.02           N  
ATOM    159  CA  GLU    23      50.660  -0.849  51.932  1.00 87.43           C  
ATOM    160  C   GLU    23      49.761  -0.589  53.128  1.00 86.72           C  
ATOM    161  O   GLU    23      49.181   0.489  53.258  1.00 86.51           O  
ATOM    162  CB  GLU    23      49.844  -0.845  50.641  1.00 87.07           C  
ATOM    163  CG  GLU    23      50.691  -1.231  49.439  1.00 86.82           C  
ATOM    164  CD  GLU    23      49.876  -1.575  48.209  1.00 86.51           C  
ATOM    165  OE1 GLU    23      48.796  -2.186  48.354  1.00 86.21           O  
ATOM    166  OE2 GLU    23      50.334  -1.251  47.092  1.00 86.66           O  
ATOM    167  N   LEU    24      49.636  -1.585  53.998  1.00 85.54           N  
ATOM    168  CA  LEU    24      48.811  -1.436  55.182  1.00 84.08           C  
ATOM    169  C   LEU    24      49.744  -1.004  56.299  1.00 84.53           C  
ATOM    170  O   LEU    24      49.316  -0.552  57.365  1.00 84.00           O  
ATOM    171  CB  LEU    24      48.119  -2.760  55.510  1.00 82.17           C  
ATOM    172  CG  LEU    24      46.849  -3.050  54.707  1.00 80.47           C  
ATOM    173  CD1 LEU    24      46.452  -4.502  54.869  1.00 80.15           C  
ATOM    174  CD2 LEU    24      45.729  -2.132  55.171  1.00 79.01           C  
ATOM    175  N   ARG    25      51.035  -1.131  56.020  1.00 85.12           N  
ATOM    176  CA  ARG    25      52.076  -0.756  56.959  1.00 86.52           C  
ATOM    177  C   ARG    25      53.008   0.280  56.323  1.00 85.98           C  
ATOM    178  O   ARG    25      54.157  -0.004  56.002  1.00 85.01           O  
ATOM    179  CB  ARG    25      52.871  -1.998  57.377  1.00 89.00           C  
ATOM    180  CG  ARG    25      52.353  -2.724  58.619  1.00 90.63           C  
ATOM    181  CD  ARG    25      50.940  -3.226  58.432  1.00 91.79           C  
ATOM    182  NE  ARG    25      50.573  -4.153  59.492  1.00 93.59           N  
ATOM    183  CZ  ARG    25      49.434  -4.833  59.530  1.00 94.01           C  
ATOM    184  NH1 ARG    25      48.539  -4.690  58.562  1.00 92.90           N  
ATOM    185  NH2 ARG    25      49.196  -5.665  60.537  1.00 95.41           N  
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
ATOM    744  N   PRO    97      51.524   0.356  61.154  1.00 90.60           N  
ATOM    745  CA  PRO    97      50.191  -0.065  60.693  1.00 89.48           C  
ATOM    746  C   PRO    97      48.978   0.872  60.896  1.00 88.63           C  
ATOM    747  O   PRO    97      48.822   1.536  61.935  1.00 88.58           O  
ATOM    748  CB  PRO    97      49.981  -1.359  61.459  1.00 90.16           C  
ATOM    749  CG  PRO    97      50.550  -0.981  62.800  1.00 90.97           C  
ATOM    750  CD  PRO    97      51.837  -0.271  62.462  1.00 90.82           C  
ATOM    751  N   LEU    98      48.086   0.876  59.908  1.00 87.92           N  
ATOM    752  CA  LEU    98      46.852   1.679  59.909  1.00 87.54           C  
ATOM    753  C   LEU    98      45.641   0.780  59.628  1.00 86.35           C  
ATOM    754  O   LEU    98      45.745  -0.173  58.859  1.00 86.40           O  
ATOM    755  CB  LEU    98      46.911   2.768  58.822  1.00 89.09           C  
ATOM    756  CG  LEU    98      47.644   4.109  58.968  1.00 88.65           C  
ATOM    757  CD1 LEU    98      49.045   3.940  59.521  1.00 89.22           C  
ATOM    758  CD2 LEU    98      47.712   4.745  57.589  1.00 89.87           C  
ATOM    759  N   ASP    99      44.496   1.091  60.237  1.00 85.53           N  
ATOM    760  CA  ASP    99      43.278   0.289  60.041  1.00 84.74           C  
ATOM    761  C   ASP    99      42.159   0.999  59.284  1.00 81.33           C  
ATOM    762  O   ASP    99      41.670   2.054  59.692  1.00 80.11           O  
ATOM    763  CB  ASP    99      42.725  -0.242  61.384  1.00 88.35           C  
ATOM    764  CG  ASP    99      42.224   0.868  62.316  1.00 92.89           C  
ATOM    765  OD1 ASP    99      41.730   0.534  63.424  1.00 95.55           O  
ATOM    766  OD2 ASP    99      42.325   2.066  61.956  1.00 93.80           O  
ATOM    767  N   PRO   100      41.737   0.410  58.163  1.00 78.86           N  
ATOM    768  CA  PRO   100      40.674   0.945  57.306  1.00 78.44           C  
ATOM    769  C   PRO   100      39.360   1.178  58.059  1.00 77.45           C  
ATOM    770  O   PRO   100      38.489   1.927  57.613  1.00 75.53           O  
ATOM    771  CB  PRO   100      40.540  -0.128  56.220  1.00 78.10           C  
ATOM    772  CG  PRO   100      41.927  -0.685  56.129  1.00 77.63           C  
ATOM    773  CD  PRO   100      42.346  -0.792  57.566  1.00 77.31           C  
ATOM    774  N   LYS   101      39.234   0.528  59.207  1.00 78.45           N  
ATOM    775  CA  LYS   101      38.036   0.627  60.029  1.00 79.90           C  
ATOM    776  C   LYS   101      37.967   1.948  60.801  1.00 79.56           C  
ATOM    777  O   LYS   101      36.885   2.405  61.159  1.00 77.93           O  
ATOM    778  CB  LYS   101      37.991  -0.549  61.005  1.00 81.68           C  
ATOM    779  CG  LYS   101      38.480  -1.865  60.414  1.00 83.52           C  
ATOM    780  CD  LYS   101      40.002  -1.878  60.264  1.00 83.96           C  
ATOM    781  CE  LYS   101      40.473  -3.135  59.539  1.00 84.31           C  
ATOM    782  NZ  LYS   101      41.955  -3.210  59.437  1.00 84.04           N  
ATOM    783  N   ASP   102      39.129   2.551  61.041  1.00 80.64           N  
ATOM    784  CA  ASP   102      39.234   3.817  61.761  1.00 82.70           C  
ATOM    785  C   ASP   102      39.176   5.025  60.814  1.00 82.44           C  
ATOM    786  O   ASP   102      40.081   5.235  59.997  1.00 79.79           O  
ATOM    787  CB  ASP   102      40.541   3.850  62.555  1.00 85.74           C  
ATOM    788  CG  ASP   102      40.646   5.056  63.475  1.00 89.25           C  
ATOM    789  OD1 ASP   102      40.780   6.196  62.968  1.00 89.10           O  
ATOM    790  OD2 ASP   102      40.594   4.852  64.716  1.00 92.75           O  
ATOM    791  N   PRO   103      38.118   5.851  60.944  1.00 82.42           N  
ATOM    792  CA  PRO   103      37.898   7.046  60.124  1.00 82.10           C  
ATOM    793  C   PRO   103      39.133   7.908  59.860  1.00 80.70           C  
ATOM    794  O   PRO   103      39.308   8.421  58.753  1.00 80.86           O  
ATOM    795  CB  PRO   103      36.808   7.792  60.897  1.00 81.86           C  
ATOM    796  CG  PRO   103      35.983   6.671  61.431  1.00 81.48           C  
ATOM    797  CD  PRO   103      37.062   5.740  61.971  1.00 82.18           C  
ATOM    798  N   GLY   104      39.988   8.049  60.864  1.00 79.06           N  
ATOM    799  CA  GLY   104      41.177   8.864  60.700  1.00 78.37           C  
ATOM    800  C   GLY   104      42.316   8.198  59.953  1.00 78.10           C  
ATOM    801  O   GLY   104      42.884   8.779  59.025  1.00 77.03           O  
ATOM    802  N   GLU   105      42.659   6.981  60.360  1.00 78.40           N  
ATOM    803  CA  GLU   105      43.744   6.240  59.725  1.00 78.99           C  
ATOM    804  C   GLU   105      43.413   5.894  58.278  1.00 77.22           C  
ATOM    805  O   GLU   105      44.285   5.858  57.419  1.00 77.36           O  
ATOM    806  CB  GLU   105      44.048   4.974  60.528  1.00 81.54           C  
ATOM    807  CG  GLU   105      45.054   5.222  61.641  1.00 87.07           C  
ATOM    808  CD  GLU   105      44.955   4.232  62.795  1.00 90.76           C  
ATOM    809  OE1 GLU   105      45.013   3.005  62.546  1.00 92.73           O  
ATOM    810  OE2 GLU   105      44.829   4.689  63.957  1.00 92.21           O  
ATOM    811  N   ARG   106      42.142   5.654  58.013  1.00 75.03           N  
ATOM    812  CA  ARG   106      41.705   5.331  56.675  1.00 73.33           C  
ATOM    813  C   ARG   106      41.866   6.555  55.777  1.00 72.50           C  
ATOM    814  O   ARG   106      42.196   6.428  54.598  1.00 72.89           O  
ATOM    815  CB  ARG   106      40.243   4.905  56.703  1.00 73.84           C  
ATOM    816  CG  ARG   106      39.655   4.610  55.355  1.00 77.66           C  
ATOM    817  CD  ARG   106      38.140   4.759  55.372  1.00 81.26           C  
ATOM    818  NE  ARG   106      37.583   4.603  54.032  1.00 85.82           N  
ATOM    819  CZ  ARG   106      36.351   4.962  53.678  1.00 88.83           C  
ATOM    820  NH1 ARG   106      35.532   5.506  54.572  1.00 89.61           N  
ATOM    821  NH2 ARG   106      35.940   4.785  52.423  1.00 89.25           N  
ATOM    822  N   SER   107      41.633   7.742  56.333  1.00 70.78           N  
ATOM    823  CA  SER   107      41.744   8.972  55.549  1.00 67.82           C  
ATOM    824  C   SER   107      43.176   9.174  55.080  1.00 66.49           C  
ATOM    825  O   SER   107      43.404   9.793  54.035  1.00 66.15           O  
ATOM    826  CB  SER   107      41.315  10.190  56.368  1.00 66.66           C  
ATOM    827  OG  SER   107      42.429  10.756  57.037  1.00 68.47           O  
ATOM    828  N   VAL   108      44.127   8.651  55.858  1.00 64.47           N  
ATOM    829  CA  VAL   108      45.549   8.755  55.549  1.00 62.95           C  
ATOM    830  C   VAL   108      45.921   7.759  54.472  1.00 63.50           C  
ATOM    831  O   VAL   108      46.596   8.109  53.502  1.00 64.63           O  
ATOM    832  CB  VAL   108      46.429   8.496  56.800  1.00 62.97           C  
ATOM    833  CG1 VAL   108      47.877   8.232  56.397  1.00 60.07           C  
ATOM    834  CG2 VAL   108      46.361   9.699  57.725  1.00 63.07           C  
ATOM    835  N   LEU   109      45.482   6.515  54.632  1.00 63.15           N  
ATOM    836  CA  LEU   109      45.787   5.491  53.635  1.00 62.19           C  
ATOM    837  C   LEU   109      45.290   5.942  52.257  1.00 60.92           C  
ATOM    838  O   LEU   109      45.945   5.686  51.249  1.00 60.16           O  
ATOM    839  CB  LEU   109      45.147   4.145  54.026  1.00 60.53           C  
ATOM    840  CG  LEU   109      45.900   3.301  55.070  1.00 60.39           C  
ATOM    841  CD1 LEU   109      44.999   2.165  55.552  1.00 58.69           C  
ATOM    842  CD2 LEU   109      47.205   2.765  54.486  1.00 55.69           C  
ATOM    843  N   SER   110      44.140   6.616  52.240  1.00 58.67           N  
ATOM    844  CA  SER   110      43.528   7.117  51.015  1.00 58.92           C  
ATOM    845  C   SER   110      44.305   8.276  50.422  1.00 58.98           C  
ATOM    846  O   SER   110      44.239   8.524  49.218  1.00 58.97           O  
ATOM    847  CB  SER   110      42.092   7.587  51.269  1.00 58.40           C  
ATOM    848  OG  SER   110      41.194   6.498  51.302  1.00 59.26           O  
ATOM    849  N   ALA   111      45.009   9.006  51.277  1.00 57.94           N  
ATOM    850  CA  ALA   111      45.800  10.128  50.821  1.00 56.24           C  
ATOM    851  C   ALA   111      46.970   9.522  50.079  1.00 55.63           C  
ATOM    852  O   ALA   111      47.416  10.037  49.065  1.00 57.35           O  
ATOM    853  CB  ALA   111      46.282  10.926  51.989  1.00 55.30           C  
ATOM    854  N   LEU   112      47.472   8.416  50.595  1.00 54.79           N  
ATOM    855  CA  LEU   112      48.578   7.749  49.942  1.00 55.19           C  
ATOM    856  C   LEU   112      48.104   7.275  48.576  1.00 53.33           C  
ATOM    857  O   LEU   112      48.802   7.438  47.587  1.00 53.50           O  
ATOM    858  CB  LEU   112      49.076   6.573  50.794  1.00 55.11           C  
ATOM    859  CG  LEU   112      49.862   7.035  52.030  1.00 56.18           C  
ATOM    860  CD1 LEU   112      49.829   5.963  53.111  1.00 55.35           C  
ATOM    861  CD2 LEU   112      51.307   7.388  51.622  1.00 54.94           C  
ATOM    862  N   ALA   113      46.907   6.709  48.533  1.00 51.67           N  
ATOM    863  CA  ALA   113      46.326   6.221  47.292  1.00 51.20           C  
ATOM    864  C   ALA   113      46.153   7.357  46.274  1.00 50.60           C  
ATOM    865  O   ALA   113      46.504   7.200  45.117  1.00 50.46           O  
ATOM    866  CB  ALA   113      44.989   5.575  47.576  1.00 52.01           C  
ATOM    867  N   ARG   114      45.613   8.489  46.716  1.00 49.15           N  
ATOM    868  CA  ARG   114      45.409   9.632  45.856  1.00 49.51           C  
ATOM    869  C   ARG   114      46.769   9.996  45.270  1.00 51.04           C  
ATOM    870  O   ARG   114      46.915  10.198  44.061  1.00 51.84           O  
ATOM    871  CB  ARG   114      44.826  10.810  46.660  1.00 49.19           C  
ATOM    872  CG  ARG   114      44.355  12.000  45.807  1.00 52.27           C  
ATOM    873  CD  ARG   114      43.813  13.194  46.619  1.00 55.32           C  
ATOM    874  NE  ARG   114      44.149  14.496  46.007  1.00 61.37           N  
ATOM    875  CZ  ARG   114      44.054  15.691  46.618  1.00 65.98           C  
ATOM    876  NH1 ARG   114      43.627  15.784  47.883  1.00 65.95           N  
ATOM    877  NH2 ARG   114      44.396  16.812  45.970  1.00 64.49           N  
ATOM    878  N   ARG   115      47.781  10.034  46.127  1.00 52.10           N  
ATOM    879  CA  ARG   115      49.120  10.377  45.690  1.00 52.46           C  
ATOM    880  C   ARG   115      49.695   9.356  44.726  1.00 51.72           C  
ATOM    881  O   ARG   115      50.507   9.687  43.874  1.00 50.66           O  
ATOM    882  CB  ARG   115      50.034  10.504  46.893  1.00 54.19           C  
ATOM    883  CG  ARG   115      51.333  11.201  46.591  1.00 58.70           C  
ATOM    884  CD  ARG   115      51.122  12.658  46.193  1.00 64.25           C  
ATOM    885  NE  ARG   115      52.386  13.379  46.300  1.00 71.61           N  
ATOM    886  CZ  ARG   115      53.425  13.202  45.483  1.00 74.87           C  
ATOM    887  NH1 ARG   115      53.351  12.338  44.479  1.00 75.09           N  
ATOM    888  NH2 ARG   115      54.562  13.858  45.696  1.00 77.88           N  
ATOM    889  N   LEU   116      49.270   8.108  44.875  1.00 53.33           N  
ATOM    890  CA  LEU   116      49.737   7.024  44.025  1.00 53.58           C  
ATOM    891  C   LEU   116      49.196   7.267  42.632  1.00 54.07           C  
ATOM    892  O   LEU   116      49.904   7.129  41.641  1.00 53.57           O  
ATOM    893  CB  LEU   116      49.223   5.685  44.541  1.00 53.00           C  
ATOM    894  CG  LEU   116      49.707   4.495  43.700  1.00 55.61           C  
ATOM    895  CD1 LEU   116      51.238   4.431  43.760  1.00 55.15           C  
ATOM    896  CD2 LEU   116      49.088   3.196  44.202  1.00 52.60           C  
ATOM    897  N   LEU   117      47.927   7.644  42.575  1.00 55.37           N  
ATOM    898  CA  LEU   117      47.273   7.909  41.312  1.00 56.86           C  
ATOM    899  C   LEU   117      48.001   9.045  40.601  1.00 58.79           C  
ATOM    900  O   LEU   117      48.218   8.992  39.397  1.00 57.58           O  
ATOM    901  CB  LEU   117      45.817   8.285  41.549  1.00 54.08           C  
ATOM    902  CG  LEU   117      45.092   8.604  40.250  1.00 55.91           C  
ATOM    903  CD1 LEU   117      45.068   7.355  39.383  1.00 52.57           C  
ATOM    904  CD2 LEU   117      43.685   9.124  40.549  1.00 54.28           C  
ATOM    905  N   GLN   118      48.364  10.076  41.357  1.00 61.30           N  
ATOM    906  CA  GLN   118      49.087  11.212  40.813  1.00 64.01           C  
ATOM    907  C   GLN   118      50.420  10.789  40.208  1.00 65.87           C  
ATOM    908  O   GLN   118      50.724  11.114  39.060  1.00 66.18           O  
ATOM    909  CB  GLN   118      49.369  12.240  41.904  1.00 66.27           C  
ATOM    910  CG  GLN   118      48.333  13.338  42.033  1.00 70.48           C  
ATOM    911  CD  GLN   118      48.967  14.674  42.403  1.00 71.81           C  
ATOM    912  OE1 GLN   118      49.490  14.842  43.507  1.00 72.65           O  
ATOM    913  NE2 GLN   118      48.936  15.627  41.470  1.00 71.99           N  
ATOM    914  N   GLU   119      51.226  10.070  40.984  1.00 67.06           N  
ATOM    915  CA  GLU   119      52.523   9.645  40.494  1.00 67.50           C  
ATOM    916  C   GLU   119      52.431   8.820  39.221  1.00 67.60           C  
ATOM    917  O   GLU   119      53.225   9.003  38.302  1.00 68.48           O  
ATOM    918  CB  GLU   119      53.275   8.878  41.573  1.00 68.66           C  
ATOM    919  CG  GLU   119      53.928   9.767  42.620  1.00 71.97           C  
ATOM    920  CD  GLU   119      54.828  10.844  42.016  1.00 74.74           C  
ATOM    921  OE1 GLU   119      55.733  10.510  41.209  1.00 75.46           O  
ATOM    922  OE2 GLU   119      54.630  12.031  42.356  1.00 75.41           O  
ATOM    923  N   ARG   120      51.465   7.918  39.154  1.00 67.09           N  
ATOM    924  CA  ARG   120      51.316   7.101  37.962  1.00 67.86           C  
ATOM    925  C   ARG   120      50.855   7.967  36.786  1.00 67.81           C  
ATOM    926  O   ARG   120      51.320   7.796  35.664  1.00 67.79           O  
ATOM    927  CB  ARG   120      50.324   5.966  38.224  1.00 68.54           C  
ATOM    928  CG  ARG   120      50.763   5.028  39.331  1.00 70.24           C  
ATOM    929  CD  ARG   120      50.838   3.592  38.829  1.00 73.28           C  
ATOM    930  NE  ARG   120      51.951   2.858  39.433  1.00 74.70           N  
ATOM    931  CZ  ARG   120      51.835   1.959  40.406  1.00 75.34           C  
ATOM    932  NH1 ARG   120      50.644   1.651  40.908  1.00 76.24           N  
ATOM    933  NH2 ARG   120      52.925   1.377  40.890  1.00 75.76           N  
ATOM    934  N   LEU   121      49.947   8.899  37.050  1.00 68.08           N  
ATOM    935  CA  LEU   121      49.439   9.791  36.018  1.00 68.24           C  
ATOM    936  C   LEU   121      50.554  10.682  35.488  1.00 70.62           C  
ATOM    937  O   LEU   121      50.622  10.976  34.292  1.00 71.40           O  
ATOM    938  CB  LEU   121      48.317  10.687  36.563  1.00 64.60           C  
ATOM    939  CG  LEU   121      46.905  10.115  36.721  1.00 63.20           C  
ATOM    940  CD1 LEU   121      45.941  11.241  37.003  1.00 62.27           C  
ATOM    941  CD2 LEU   121      46.476   9.417  35.457  1.00 62.87           C  
ATOM    942  N   ARG   122      51.433  11.111  36.385  1.00 72.33           N  
ATOM    943  CA  ARG   122      52.519  11.988  35.998  1.00 73.62           C  
ATOM    944  C   ARG   122      53.534  11.322  35.066  1.00 74.20           C  
ATOM    945  O   ARG   122      54.229  12.009  34.319  1.00 74.67           O  
ATOM    946  CB  ARG   122      53.219  12.521  37.242  1.00 74.51           C  
ATOM    947  CG  ARG   122      54.192  13.639  36.940  1.00 78.84           C  
ATOM    948  CD  ARG   122      54.973  14.074  38.172  1.00 81.78           C  
ATOM    949  NE  ARG   122      55.975  13.088  38.585  1.00 85.00           N  
ATOM    950  CZ  ARG   122      57.036  12.739  37.856  1.00 86.41           C  
ATOM    951  NH1 ARG   122      57.243  13.290  36.664  1.00 87.13           N  
ATOM    952  NH2 ARG   122      57.900  11.843  38.322  1.00 85.88           N  
ATOM    953  N   ARG   123      53.609   9.995  35.087  1.00 74.20           N  
ATOM    954  CA  ARG   123      54.559   9.288  34.242  1.00 75.77           C  
ATOM    955  C   ARG   123      53.935   8.726  32.975  1.00 76.88           C  
ATOM    956  O   ARG   123      54.529   7.891  32.286  1.00 77.15           O  
ATOM    957  CB  ARG   123      55.226   8.171  35.042  1.00 77.07           C  
ATOM    958  CG  ARG   123      56.273   8.678  36.018  1.00 79.66           C  
ATOM    959  CD  ARG   123      56.275   7.859  37.307  1.00 84.37           C  
ATOM    960  NE  ARG   123      57.260   8.341  38.279  1.00 87.36           N  
ATOM    961  CZ  ARG   123      58.298   7.629  38.714  1.00 88.63           C  
ATOM    962  NH1 ARG   123      58.499   6.390  38.268  1.00 88.48           N  
ATOM    963  NH2 ARG   123      59.143   8.157  39.595  1.00 88.92           N  
ATOM    964  N   LEU   124      52.736   9.194  32.660  1.00 78.38           N  
ATOM    965  CA  LEU   124      52.048   8.723  31.472  1.00 79.17           C  
ATOM    966  C   LEU   124      52.505   9.401  30.195  1.00 81.39           C  
ATOM    967  O   LEU   124      52.708  10.620  30.141  1.00 80.31           O  
ATOM    968  CB  LEU   124      50.540   8.876  31.631  1.00 77.62           C  
ATOM    969  CG  LEU   124      49.923   7.711  32.394  1.00 76.01           C  
ATOM    970  CD1 LEU   124      48.422   7.901  32.513  1.00 75.32           C  
ATOM    971  CD2 LEU   124      50.252   6.424  31.660  1.00 75.36           C  
ATOM    972  N   GLU   125      52.652   8.574  29.164  1.00 84.49           N  
ATOM    973  CA  GLU   125      53.110   8.994  27.845  1.00 85.71           C  
ATOM    974  C   GLU   125      52.056   9.689  26.994  1.00 85.14           C  
ATOM    975  O   GLU   125      50.935   9.205  26.858  1.00 85.22           O  
ATOM    976  CB  GLU   125      53.637   7.770  27.105  1.00 87.34           C  
ATOM    977  CG  GLU   125      52.672   6.596  27.120  1.00 90.13           C  
ATOM    978  CD  GLU   125      53.277   5.342  26.503  1.00 93.48           C  
ATOM    979  OE1 GLU   125      52.526   4.364  26.264  1.00 93.88           O  
ATOM    980  OE2 GLU   125      54.508   5.332  26.262  1.00 94.50           O  
ATOM    981  N   GLY   126      52.432  10.827  26.421  1.00 84.38           N  
ATOM    982  CA  GLY   126      51.525  11.569  25.567  1.00 84.11           C  
ATOM    983  C   GLY   126      50.109  11.654  26.094  1.00 84.57           C  
ATOM    984  O   GLY   126      49.202  10.961  25.621  1.00 84.45           O  
ATOM    985  N   VAL   127      49.923  12.512  27.088  1.00 84.08           N  
ATOM    986  CA  VAL   127      48.620  12.718  27.692  1.00 82.67           C  
ATOM    987  C   VAL   127      48.748  13.875  28.618  1.00 81.90           C  
ATOM    988  O   VAL   127      49.804  14.183  29.172  1.00 82.37           O  
ATOM    989  CB  VAL   127      48.136  11.527  28.488  1.00 83.19           C  
ATOM    990  CG1 VAL   127      48.848  11.468  29.813  1.00 83.20           C  
ATOM    991  CG2 VAL   127      46.632  11.661  28.705  1.00 85.44           C  
ATOM    992  N   TRP   128      47.632  14.468  28.887  1.00 80.51           N  
ATOM    993  CA  TRP   128      47.734  15.623  29.638  1.00 80.52           C  
ATOM    994  C   TRP   128      47.141  15.645  31.061  1.00 79.00           C  
ATOM    995  O   TRP   128      45.951  15.445  31.262  1.00 77.99           O  
ATOM    996  CB  TRP   128      47.134  16.624  28.761  1.00 82.46           C  
ATOM    997  CG  TRP   128      46.958  17.666  29.437  1.00 85.61           C  
ATOM    998  CD1 TRP   128      46.005  17.899  30.373  1.00 86.56           C  
ATOM    999  CD2 TRP   128      47.763  18.784  29.346  1.00 86.36           C  
ATOM   1000  NE1 TRP   128      46.174  19.156  30.883  1.00 86.71           N  
ATOM   1001  CE2 TRP   128      47.266  19.720  30.273  1.00 86.60           C  
ATOM   1002  CE3 TRP   128      48.886  19.099  28.561  1.00 87.01           C  
ATOM   1003  CZ2 TRP   128      47.840  20.951  30.448  1.00 86.74           C  
ATOM   1004  CZ3 TRP   128      49.470  20.322  28.713  1.00 87.31           C  
ATOM   1005  CH2 TRP   128      48.950  21.250  29.666  1.00 87.56           C  
ATOM   1006  N   VAL   129      47.980  15.960  32.033  1.00 75.97           N  
ATOM   1007  CA  VAL   129      47.559  15.911  33.410  1.00 75.60           C  
ATOM   1008  C   VAL   129      47.448  17.230  34.159  1.00 76.75           C  
ATOM   1009  O   VAL   129      48.377  18.013  34.180  1.00 77.49           O  
ATOM   1010  CB  VAL   129      48.481  14.982  34.158  1.00 73.90           C  
ATOM   1011  CG1 VAL   129      47.937  14.678  35.508  1.00 72.70           C  
ATOM   1012  CG2 VAL   129      48.676  13.740  33.319  1.00 74.83           C  
ATOM   1013  N   GLU   130      46.312  17.452  34.812  1.00 77.77           N  
ATOM   1014  CA  GLU   130      46.095  18.674  35.558  1.00 78.92           C  
ATOM   1015  C   GLU   130      45.676  18.287  36.984  1.00 78.24           C  
ATOM   1016  O   GLU   130      44.547  18.553  37.417  1.00 78.14           O  
ATOM   1017  CB  GLU   130      45.014  19.508  34.858  1.00 81.69           C  
ATOM   1018  CG  GLU   130      45.052  21.006  35.164  1.00 87.16           C  
ATOM   1019  CD  GLU   130      44.100  21.814  34.283  1.00 90.28           C  
ATOM   1020  OE1 GLU   130      42.880  21.856  34.573  1.00 91.28           O  
ATOM   1021  OE2 GLU   130      44.580  22.401  33.286  1.00 92.44           O  
ATOM   1022  N   GLY   131      46.598  17.647  37.702  1.00 76.55           N  
ATOM   1023  CA  GLY   131      46.330  17.230  39.068  1.00 74.58           C  
ATOM   1024  C   GLY   131      45.865  15.791  39.106  1.00 73.64           C  
ATOM   1025  O   GLY   131      46.671  14.882  38.911  1.00 73.38           O  
ATOM   1026  N   LEU   132      44.571  15.590  39.366  1.00 72.73           N  
ATOM   1027  CA  LEU   132      43.975  14.258  39.397  1.00 71.14           C  
ATOM   1028  C   LEU   132      43.165  14.024  38.134  1.00 70.81           C  
ATOM   1029  O   LEU   132      42.451  13.033  38.009  1.00 70.97           O  
ATOM   1030  CB  LEU   132      43.082  14.082  40.626  1.00 69.55           C  
ATOM   1031  CG  LEU   132      43.854  13.777  41.914  1.00 69.71           C  
ATOM   1032  CD1 LEU   132      42.862  13.482  43.025  1.00 68.93           C  
ATOM   1033  CD2 LEU   132      44.797  12.593  41.702  1.00 67.63           C  
ATOM   1034  N   ALA   133      43.291  14.946  37.190  1.00 70.99           N  
ATOM   1035  CA  ALA   133      42.580  14.843  35.932  1.00 70.67           C  
ATOM   1036  C   ALA   133      43.492  14.341  34.812  1.00 70.47           C  
ATOM   1037  O   ALA   133      44.708  14.505  34.855  1.00 69.45           O  
ATOM   1038  CB  ALA   133      41.990  16.195  35.566  1.00 70.41           C  
ATOM   1039  N   VAL   134      42.892  13.691  33.827  1.00 70.67           N  
ATOM   1040  CA  VAL   134      43.635  13.193  32.689  1.00 71.29           C  
ATOM   1041  C   VAL   134      42.827  13.645  31.498  1.00 72.40           C  
ATOM   1042  O   VAL   134      41.604  13.543  31.505  1.00 71.80           O  
ATOM   1043  CB  VAL   134      43.695  11.657  32.623  1.00 70.65           C  
ATOM   1044  CG1 VAL   134      44.702  11.235  31.579  1.00 69.82           C  
ATOM   1045  CG2 VAL   134      44.058  11.080  33.954  1.00 72.45           C  
ATOM   1046  N   TYR   135      43.514  14.167  30.492  1.00 73.97           N  
ATOM   1047  CA  TYR   135      42.872  14.607  29.267  1.00 74.92           C  
ATOM   1048  C   TYR   135      43.616  13.860  28.175  1.00 76.66           C  
ATOM   1049  O   TYR   135      44.782  14.113  27.913  1.00 77.04           O  
ATOM   1050  CB  TYR   135      42.971  16.128  29.138  1.00 72.52           C  
ATOM   1051  CG  TYR   135      42.156  16.810  30.207  1.00 70.54           C  
ATOM   1052  CD1 TYR   135      42.708  17.125  31.442  1.00 70.96           C  
ATOM   1053  CD2 TYR   135      40.795  17.033  30.027  1.00 71.86           C  
ATOM   1054  CE1 TYR   135      41.918  17.651  32.484  1.00 70.63           C  
ATOM   1055  CE2 TYR   135      39.989  17.548  31.060  1.00 71.08           C  
ATOM   1056  CZ  TYR   135      40.559  17.855  32.283  1.00 70.70           C  
ATOM   1057  OH  TYR   135      39.771  18.361  33.292  1.00 68.68           O  
ATOM   1058  N   ARG   136      42.931  12.891  27.579  1.00 79.43           N  
ATOM   1059  CA  ARG   136      43.527  12.047  26.553  1.00 82.21           C  
ATOM   1060  C   ARG   136      43.487  12.561  25.112  1.00 82.50           C  
ATOM   1061  O   ARG   136      44.511  12.540  24.426  1.00 83.13           O  
ATOM   1062  CB  ARG   136      42.885  10.662  26.595  1.00 84.89           C  
ATOM   1063  CG  ARG   136      42.700  10.095  27.989  1.00 89.03           C  
ATOM   1064  CD  ARG   136      42.321   8.624  27.926  1.00 94.02           C  
ATOM   1065  NE  ARG   136      41.072   8.379  27.196  1.00 98.32           N  
ATOM   1066  CZ  ARG   136      40.660   7.178  26.773  1.00100.24           C  
ATOM   1067  NH1 ARG   136      41.394   6.092  26.997  1.00100.92           N  
ATOM   1068  NH2 ARG   136      39.507   7.054  26.123  1.00 99.02           N  
ATOM   1069  N   ARG   137      42.323  13.020  24.652  1.00 81.91           N  
ATOM   1070  CA  ARG   137      42.193  13.456  23.266  1.00 80.78           C  
ATOM   1071  C   ARG   137      41.467  14.750  22.926  1.00 81.03           C  
ATOM   1072  O   ARG   137      40.510  15.150  23.587  1.00 80.59           O  
ATOM   1073  CB  ARG   137      41.551  12.334  22.471  1.00 81.17           C  
ATOM   1074  CG  ARG   137      40.339  11.709  23.145  1.00 79.96           C  
ATOM   1075  CD  ARG   137      39.832  10.566  22.298  1.00 81.08           C  
ATOM   1076  NE  ARG   137      40.939   9.735  21.829  1.00 82.40           N  
ATOM   1077  CZ  ARG   137      41.252   8.539  22.320  1.00 83.14           C  
ATOM   1078  NH1 ARG   137      40.541   8.007  23.307  1.00 84.17           N  
ATOM   1079  NH2 ARG   137      42.283   7.872  21.823  1.00 82.61           N  
ATOM   1080  N   GLU   138      41.920  15.368  21.837  1.00 82.42           N  
ATOM   1081  CA  GLU   138      41.378  16.626  21.331  1.00 83.22           C  
ATOM   1082  C   GLU   138      39.941  16.567  20.846  1.00 83.78           C  
ATOM   1083  O   GLU   138      39.455  15.521  20.442  1.00 84.00           O  
ATOM   1084  CB  GLU   138      42.252  17.147  20.198  1.00 83.28           C  
ATOM   1085  CG  GLU   138      43.532  17.798  20.665  1.00 85.60           C  
ATOM   1086  CD  GLU   138      44.228  18.547  19.553  1.00 87.23           C  
ATOM   1087  OE1 GLU   138      43.518  19.061  18.659  1.00 87.20           O  
ATOM   1088  OE2 GLU   138      45.477  18.632  19.582  1.00 88.25           O  
ATOM   1089  N   HIS   139      39.271  17.713  20.880  1.00 85.40           N  
ATOM   1090  CA  HIS   139      37.882  17.815  20.449  1.00 87.35           C  
ATOM   1091  C   HIS   139      37.633  19.055  19.610  1.00 87.96           C  
ATOM   1092  O   HIS   139      36.544  19.230  19.068  1.00 89.27           O  
ATOM   1093  CB  HIS   139      36.934  17.840  21.652  1.00 88.46           C  
ATOM   1094  CG  HIS   139      36.643  16.485  22.219  1.00 91.04           C  
ATOM   1095  ND1 HIS   139      37.569  15.763  22.942  1.00 92.06           N  
ATOM   1096  CD2 HIS   139      35.540  15.704  22.138  1.00 91.59           C  
ATOM   1097  CE1 HIS   139      37.049  14.596  23.281  1.00 91.95           C  
ATOM   1098  NE2 HIS   139      35.818  14.536  22.806  1.00 91.16           N  
ATOM   1099  N   ALA   140      38.641  19.912  19.507  1.00 87.65           N  
ATOM   1100  CA  ALA   140      38.535  21.147  18.742  1.00 87.55           C  
ATOM   1101  C   ALA   140      39.808  21.893  19.044  1.00 88.15           C  
ATOM   1102  O   ALA   140      40.442  21.615  20.060  1.00 88.01           O  
ATOM   1103  CB  ALA   140      37.340  21.957  19.209  1.00 87.03           C  
ATOM   1104  N   ARG   141      40.194  22.829  18.180  1.00 88.44           N  
ATOM   1105  CA  ARG   141      41.412  23.568  18.440  1.00 89.04           C  
ATOM   1106  C   ARG   141      41.438  25.018  17.965  1.00 90.28           C  
ATOM   1107  O   ARG   141      41.049  25.905  18.701  1.00 90.53           O  
ATOM   1108  CB  ARG   141      42.622  22.784  17.912  1.00 87.72           C  
ATOM   1109  CG  ARG   141      42.749  22.703  16.423  1.00 88.27           C  
ATOM   1110  CD  ARG   141      43.439  21.425  15.983  1.00 90.32           C  
ATOM   1111  NE  ARG   141      44.515  20.972  16.866  1.00 92.61           N  
ATOM   1112  CZ  ARG   141      45.688  21.580  17.032  1.00 93.88           C  
ATOM   1113  NH1 ARG   141      45.969  22.699  16.373  1.00 95.14           N  
ATOM   1114  NH2 ARG   141      46.588  21.054  17.857  1.00 93.25           N  
ATOM   1115  N   GLY   142      41.885  25.290  16.753  1.00 91.38           N  
ATOM   1116  CA  GLY   142      41.936  26.682  16.346  1.00 91.80           C  
ATOM   1117  C   GLY   142      43.212  27.332  16.866  1.00 91.86           C  
ATOM   1118  O   GLY   142      43.961  26.711  17.629  1.00 91.91           O  
ATOM   1119  N   PRO   143      43.475  28.595  16.496  1.00 91.92           N  
ATOM   1120  CA  PRO   143      44.680  29.316  16.926  1.00 91.04           C  
ATOM   1121  C   PRO   143      44.930  29.490  18.429  1.00 90.18           C  
ATOM   1122  O   PRO   143      44.177  30.172  19.126  1.00 89.84           O  
ATOM   1123  CB  PRO   143      44.547  30.656  16.206  1.00 91.64           C  
ATOM   1124  CG  PRO   143      43.056  30.866  16.185  1.00 92.31           C  
ATOM   1125  CD  PRO   143      42.544  29.498  15.788  1.00 91.67           C  
ATOM   1126  N   GLY   144      45.996  28.861  18.917  1.00 89.03           N  
ATOM   1127  CA  GLY   144      46.369  28.993  20.315  1.00 87.46           C  
ATOM   1128  C   GLY   144      45.532  28.326  21.392  1.00 85.90           C  
ATOM   1129  O   GLY   144      45.972  28.235  22.530  1.00 85.97           O  
ATOM   1130  N   TRP   145      44.322  27.892  21.078  1.00 84.14           N  
ATOM   1131  CA  TRP   145      43.525  27.220  22.092  1.00 82.52           C  
ATOM   1132  C   TRP   145      43.294  25.798  21.635  1.00 80.56           C  
ATOM   1133  O   TRP   145      43.558  25.467  20.483  1.00 81.96           O  
ATOM   1134  CB  TRP   145      42.188  27.921  22.320  1.00 83.40           C  
ATOM   1135  CG  TRP   145      41.329  28.067  21.105  1.00 86.17           C  
ATOM   1136  CD1 TRP   145      41.407  29.047  20.155  1.00 86.41           C  
ATOM   1137  CD2 TRP   145      40.204  27.254  20.748  1.00 88.09           C  
ATOM   1138  NE1 TRP   145      40.395  28.901  19.238  1.00 87.17           N  
ATOM   1139  CE2 TRP   145      39.641  27.811  19.575  1.00 87.21           C  
ATOM   1140  CE3 TRP   145      39.615  26.105  21.305  1.00 88.76           C  
ATOM   1141  CZ2 TRP   145      38.517  27.262  18.950  1.00 87.59           C  
ATOM   1142  CZ3 TRP   145      38.490  25.557  20.676  1.00 88.82           C  
ATOM   1143  CH2 TRP   145      37.957  26.140  19.513  1.00 88.14           C  
ATOM   1144  N   ARG   146      42.825  24.949  22.537  1.00 77.09           N  
ATOM   1145  CA  ARG   146      42.575  23.562  22.194  1.00 74.62           C  
ATOM   1146  C   ARG   146      41.838  22.850  23.318  1.00 72.32           C  
ATOM   1147  O   ARG   146      42.250  22.868  24.464  1.00 72.39           O  
ATOM   1148  CB  ARG   146      43.904  22.878  21.828  1.00 75.07           C  
ATOM   1149  CG  ARG   146      44.366  21.686  22.648  1.00 75.81           C  
ATOM   1150  CD  ARG   146      45.612  21.142  21.964  1.00 77.61           C  
ATOM   1151  NE  ARG   146      46.308  20.063  22.664  1.00 80.87           N  
ATOM   1152  CZ  ARG   146      47.153  20.233  23.679  1.00 82.13           C  
ATOM   1153  NH1 ARG   146      47.413  21.449  24.142  1.00 82.86           N  
ATOM   1154  NH2 ARG   146      47.776  19.182  24.205  1.00 82.93           N  
ATOM   1155  N   VAL   147      40.711  22.250  22.975  1.00 70.54           N  
ATOM   1156  CA  VAL   147      39.896  21.549  23.948  1.00 68.67           C  
ATOM   1157  C   VAL   147      40.288  20.081  24.042  1.00 67.90           C  
ATOM   1158  O   VAL   147      40.510  19.431  23.023  1.00 67.92           O  
ATOM   1159  CB  VAL   147      38.405  21.628  23.568  1.00 68.06           C  
ATOM   1160  CG1 VAL   147      37.590  20.726  24.466  1.00 67.90           C  
ATOM   1161  CG2 VAL   147      37.924  23.049  23.674  1.00 66.33           C  
ATOM   1162  N   LEU   148      40.385  19.564  25.266  1.00 66.41           N  
ATOM   1163  CA  LEU   148      40.715  18.157  25.464  1.00 63.56           C  
ATOM   1164  C   LEU   148      39.663  17.514  26.337  1.00 62.01           C  
ATOM   1165  O   LEU   148      39.061  18.161  27.191  1.00 60.42           O  
ATOM   1166  CB  LEU   148      42.079  17.995  26.111  1.00 62.43           C  
ATOM   1167  CG  LEU   148      43.245  18.583  25.330  1.00 63.05           C  
ATOM   1168  CD1 LEU   148      44.543  18.188  25.999  1.00 64.18           C  
ATOM   1169  CD2 LEU   148      43.223  18.070  23.913  1.00 62.67           C  
ATOM   1170  N   GLY   149      39.428  16.234  26.100  1.00 61.64           N  
ATOM   1171  CA  GLY   149      38.447  15.521  26.884  1.00 60.17           C  
ATOM   1172  C   GLY   149      39.090  14.360  27.600  1.00 60.50           C  
ATOM   1173  O   GLY   149      39.861  13.596  27.007  1.00 60.87           O  
ATOM   1174  N   GLY   150      38.782  14.245  28.888  1.00 59.65           N  
ATOM   1175  CA  GLY   150      39.302  13.161  29.702  1.00 57.19           C  
ATOM   1176  C   GLY   150      38.365  12.972  30.881  1.00 56.01           C  
ATOM   1177  O   GLY   150      37.140  12.950  30.697  1.00 54.74           O  
ATOM   1178  N   ALA   151      38.928  12.848  32.086  1.00 53.87           N  
ATOM   1179  CA  ALA   151      38.128  12.676  33.295  1.00 52.26           C  
ATOM   1180  C   ALA   151      38.894  13.034  34.565  1.00 51.67           C  
ATOM   1181  O   ALA   151      40.091  12.764  34.670  1.00 49.71           O  
ATOM   1182  CB  ALA   151      37.633  11.231  33.393  1.00 50.92           C  
ATOM   1183  N   VAL   152      38.213  13.660  35.521  1.00 51.42           N  
ATOM   1184  CA  VAL   152      38.858  13.962  36.797  1.00 52.53           C  
ATOM   1185  C   VAL   152      38.692  12.631  37.517  1.00 52.46           C  
ATOM   1186  O   VAL   152      37.633  12.014  37.446  1.00 53.17           O  
ATOM   1187  CB  VAL   152      38.157  15.115  37.561  1.00 52.93           C  
ATOM   1188  CG1 VAL   152      38.479  16.431  36.899  1.00 53.90           C  
ATOM   1189  CG2 VAL   152      36.666  14.941  37.533  1.00 54.66           C  
ATOM   1190  N   LEU   153      39.746  12.170  38.173  1.00 51.56           N  
ATOM   1191  CA  LEU   153      39.712  10.876  38.824  1.00 50.97           C  
ATOM   1192  C   LEU   153      40.001  10.939  40.304  1.00 53.35           C  
ATOM   1193  O   LEU   153      40.428  11.971  40.836  1.00 54.32           O  
ATOM   1194  CB  LEU   153      40.769   9.964  38.211  1.00 49.44           C  
ATOM   1195  CG  LEU   153      40.998   9.830  36.703  1.00 48.15           C  
ATOM   1196  CD1 LEU   153      42.318   9.086  36.495  1.00 47.23           C  
ATOM   1197  CD2 LEU   153      39.854   9.103  36.040  1.00 43.93           C  
ATOM   1198  N   ASP   154      39.778   9.812  40.971  1.00 53.61           N  
ATOM   1199  CA  ASP   154      40.093   9.718  42.380  1.00 53.31           C  
ATOM   1200  C   ASP   154      40.356   8.268  42.720  1.00 52.51           C  
ATOM   1201  O   ASP   154      39.785   7.369  42.110  1.00 51.87           O  
ATOM   1202  CB  ASP   154      38.972  10.285  43.243  1.00 55.47           C  
ATOM   1203  CG  ASP   154      39.475  10.759  44.603  1.00 56.67           C  
ATOM   1204  OD1 ASP   154      40.692  10.605  44.873  1.00 57.83           O  
ATOM   1205  OD2 ASP   154      38.663  11.285  45.392  1.00 56.10           O  
ATOM   1206  N   LEU   155      41.244   8.056  43.685  1.00 52.57           N  
ATOM   1207  CA  LEU   155      41.630   6.720  44.124  1.00 53.42           C  
ATOM   1208  C   LEU   155      41.853   6.732  45.624  1.00 54.92           C  
ATOM   1209  O   LEU   155      42.752   7.407  46.127  1.00 54.74           O  
ATOM   1210  CB  LEU   155      42.924   6.262  43.422  1.00 50.84           C  
ATOM   1211  CG  LEU   155      43.420   4.864  43.802  1.00 49.30           C  
ATOM   1212  CD1 LEU   155      42.417   3.820  43.326  1.00 49.80           C  
ATOM   1213  CD2 LEU   155      44.763   4.594  43.167  1.00 50.73           C  
ATOM   1214  N   TRP   156      41.027   5.974  46.334  1.00 57.64           N  
ATOM   1215  CA  TRP   156      41.112   5.880  47.790  1.00 59.74           C  
ATOM   1216  C   TRP   156      40.881   4.461  48.283  1.00 60.15           C  
ATOM   1217  O   TRP   156      40.627   3.544  47.497  1.00 59.26           O  
ATOM   1218  CB  TRP   156      40.082   6.811  48.433  1.00 60.32           C  
ATOM   1219  CG  TRP   156      38.930   7.049  47.558  1.00 63.67           C  
ATOM   1220  CD1 TRP   156      38.922   7.740  46.375  1.00 66.54           C  
ATOM   1221  CD2 TRP   156      37.614   6.535  47.731  1.00 65.16           C  
ATOM   1222  NE1 TRP   156      37.676   7.679  45.794  1.00 67.32           N  
ATOM   1223  CE2 TRP   156      36.854   6.944  46.607  1.00 67.03           C  
ATOM   1224  CE3 TRP   156      37.004   5.767  48.719  1.00 64.21           C  
ATOM   1225  CZ2 TRP   156      35.516   6.607  46.452  1.00 67.24           C  
ATOM   1226  CZ3 TRP   156      35.688   5.436  48.568  1.00 66.86           C  
ATOM   1227  CH2 TRP   156      34.950   5.855  47.437  1.00 68.51           C  
ATOM   1228  N   VAL   157      40.981   4.293  49.597  1.00 61.19           N  
ATOM   1229  CA  VAL   157      40.770   3.000  50.236  1.00 62.27           C  
ATOM   1230  C   VAL   157      39.403   2.961  50.958  1.00 62.56           C  
ATOM   1231  O   VAL   157      38.846   3.998  51.318  1.00 62.00           O  
ATOM   1232  CB  VAL   157      41.919   2.723  51.219  1.00 62.30           C  
ATOM   1233  CG1 VAL   157      41.728   1.388  51.909  1.00 64.43           C  
ATOM   1234  CG2 VAL   157      43.237   2.727  50.465  1.00 62.97           C  
ATOM   1235  N   SER   158      38.845   1.767  51.135  1.00 64.49           N  
ATOM   1236  CA  SER   158      37.560   1.625  51.831  1.00 67.24           C  
ATOM   1237  C   SER   158      37.751   1.081  53.262  1.00 68.87           C  
ATOM   1238  O   SER   158      38.877   0.755  53.675  1.00 67.12           O  
ATOM   1239  CB  SER   158      36.631   0.699  51.042  1.00 66.15           C  
ATOM   1240  OG  SER   158      37.240  -0.564  50.826  1.00 66.46           O  
ATOM   1241  N   ASP   159      36.654   1.003  54.021  1.00 71.30           N  
ATOM   1242  CA  ASP   159      36.709   0.479  55.396  1.00 73.47           C  
ATOM   1243  C   ASP   159      36.947  -1.027  55.344  1.00 72.53           C  
ATOM   1244  O   ASP   159      37.199  -1.660  56.365  1.00 72.71           O  
ATOM   1245  CB  ASP   159      35.409   0.762  56.154  1.00 75.20           C  
ATOM   1246  CG  ASP   159      34.196   0.151  55.480  1.00 78.36           C  
ATOM   1247  OD1 ASP   159      34.355  -0.832  54.717  1.00 79.99           O  
ATOM   1248  OD2 ASP   159      33.077   0.646  55.723  1.00 79.78           O  
ATOM   1249  N   SER   160      36.855  -1.572  54.134  1.00 71.61           N  
ATOM   1250  CA  SER   160      37.073  -2.983  53.856  1.00 72.21           C  
ATOM   1251  C   SER   160      38.554  -3.179  53.541  1.00 72.10           C  
ATOM   1252  O   SER   160      39.067  -4.295  53.606  1.00 72.06           O  
ATOM   1253  CB  SER   160      36.235  -3.423  52.643  1.00 74.47           C  
ATOM   1254  OG  SER   160      34.848  -3.133  52.811  1.00 75.86           O  
ATOM   1255  N   GLY   161      39.231  -2.092  53.162  1.00 71.78           N  
ATOM   1256  CA  GLY   161      40.656  -2.168  52.869  1.00 69.97           C  
ATOM   1257  C   GLY   161      41.140  -2.440  51.454  1.00 68.35           C  
ATOM   1258  O   GLY   161      42.212  -3.023  51.264  1.00 67.64           O  
ATOM   1259  N   ALA   162      40.368  -2.026  50.456  1.00 67.82           N  
ATOM   1260  CA  ALA   162      40.768  -2.219  49.060  1.00 66.31           C  
ATOM   1261  C   ALA   162      40.673  -0.886  48.323  1.00 64.90           C  
ATOM   1262  O   ALA   162      39.918   0.005  48.734  1.00 64.15           O  
ATOM   1263  CB  ALA   162      39.865  -3.249  48.383  1.00 65.17           C  
ATOM   1264  N   PHE   163      41.429  -0.753  47.235  1.00 61.59           N  
ATOM   1265  CA  PHE   163      41.395   0.472  46.449  1.00 58.00           C  
ATOM   1266  C   PHE   163      40.062   0.678  45.768  1.00 57.52           C  
ATOM   1267  O   PHE   163      39.458  -0.259  45.278  1.00 59.00           O  
ATOM   1268  CB  PHE   163      42.460   0.447  45.377  1.00 54.06           C  
ATOM   1269  CG  PHE   163      43.837   0.594  45.902  1.00 50.52           C  
ATOM   1270  CD1 PHE   163      44.718  -0.477  45.875  1.00 49.21           C  
ATOM   1271  CD2 PHE   163      44.269   1.815  46.392  1.00 48.02           C  
ATOM   1272  CE1 PHE   163      46.015  -0.330  46.326  1.00 49.90           C  
ATOM   1273  CE2 PHE   163      45.562   1.973  46.844  1.00 48.71           C  
ATOM   1274  CZ  PHE   163      46.443   0.902  46.813  1.00 49.07           C  
ATOM   1275  N   LEU   164      39.614   1.920  45.728  1.00 57.55           N  
ATOM   1276  CA  LEU   164      38.365   2.263  45.075  1.00 57.26           C  
ATOM   1277  C   LEU   164      38.730   3.412  44.124  1.00 57.53           C  
ATOM   1278  O   LEU   164      39.370   4.387  44.533  1.00 56.25           O  
ATOM   1279  CB  LEU   164      37.349   2.697  46.131  1.00 57.98           C  
ATOM   1280  CG  LEU   164      35.912   2.189  45.989  1.00 59.74           C  
ATOM   1281  CD1 LEU   164      35.844   0.674  46.042  1.00 59.30           C  
ATOM   1282  CD2 LEU   164      35.095   2.751  47.116  1.00 62.37           C  
ATOM   1283  N   LEU   165      38.351   3.285  42.854  1.00 57.37           N  
ATOM   1284  CA  LEU   165      38.675   4.297  41.850  1.00 55.98           C  
ATOM   1285  C   LEU   165      37.434   5.036  41.363  1.00 55.73           C  
ATOM   1286  O   LEU   165      36.470   4.404  40.963  1.00 56.30           O  
ATOM   1287  CB  LEU   165      39.378   3.626  40.653  1.00 54.80           C  
ATOM   1288  CG  LEU   165      39.518   4.427  39.344  1.00 52.01           C  
ATOM   1289  CD1 LEU   165      40.715   5.304  39.447  1.00 50.99           C  
ATOM   1290  CD2 LEU   165      39.648   3.522  38.158  1.00 48.67           C  
ATOM   1291  N   GLU   166      37.469   6.369  41.388  1.00 56.74           N  
ATOM   1292  CA  GLU   166      36.346   7.198  40.921  1.00 58.45           C  
ATOM   1293  C   GLU   166      36.673   7.782  39.546  1.00 57.73           C  
ATOM   1294  O   GLU   166      37.808   8.165  39.281  1.00 57.50           O  
ATOM   1295  CB  GLU   166      36.070   8.357  41.899  1.00 61.94           C  
ATOM   1296  CG  GLU   166      34.696   9.057  41.715  1.00 66.38           C  
ATOM   1297  CD  GLU   166      34.790  10.579  41.505  1.00 70.05           C  
ATOM   1298  OE1 GLU   166      33.887  11.304  41.984  1.00 71.91           O  
ATOM   1299  OE2 GLU   166      35.747  11.063  40.848  1.00 72.07           O  
ATOM   1300  N   VAL   167      35.673   7.868  38.680  1.00 57.94           N  
ATOM   1301  CA  VAL   167      35.885   8.387  37.335  1.00 58.56           C  
ATOM   1302  C   VAL   167      34.695   9.207  36.828  1.00 60.05           C  
ATOM   1303  O   VAL   167      33.565   8.727  36.847  1.00 60.55           O  
ATOM   1304  CB  VAL   167      36.104   7.236  36.323  1.00 57.58           C  
ATOM   1305  CG1 VAL   167      36.498   7.800  34.973  1.00 57.01           C  
ATOM   1306  CG2 VAL   167      37.151   6.277  36.838  1.00 58.12           C  
ATOM   1307  N   ASP   168      34.953  10.435  36.377  1.00 59.99           N  
ATOM   1308  CA  ASP   168      33.906  11.282  35.832  1.00 60.21           C  
ATOM   1309  C   ASP   168      34.446  12.147  34.689  1.00 62.04           C  
ATOM   1310  O   ASP   168      35.305  13.009  34.887  1.00 62.04           O  
ATOM   1311  CB  ASP   168      33.289  12.169  36.918  1.00 60.99           C  
ATOM   1312  CG  ASP   168      31.954  12.776  36.487  1.00 61.77           C  
ATOM   1313  OD1 ASP   168      31.289  12.180  35.623  1.00 61.73           O  
ATOM   1314  OD2 ASP   168      31.555  13.836  37.012  1.00 64.32           O  
ATOM   1315  N   PRO   169      33.954  11.906  33.465  1.00 62.54           N  
ATOM   1316  CA  PRO   169      34.358  12.640  32.267  1.00 62.04           C  
ATOM   1317  C   PRO   169      34.256  14.144  32.449  1.00 62.31           C  
ATOM   1318  O   PRO   169      33.307  14.649  33.057  1.00 60.82           O  
ATOM   1319  CB  PRO   169      33.379  12.142  31.215  1.00 62.41           C  
ATOM   1320  CG  PRO   169      33.167  10.738  31.618  1.00 63.31           C  
ATOM   1321  CD  PRO   169      32.999  10.839  33.120  1.00 62.76           C  
ATOM   1322  N   ALA   170      35.250  14.837  31.903  1.00 62.45           N  
ATOM   1323  CA  ALA   170      35.341  16.285  31.947  1.00 63.07           C  
ATOM   1324  C   ALA   170      36.097  16.741  30.689  1.00 64.66           C  
ATOM   1325  O   ALA   170      36.689  15.924  29.973  1.00 64.85           O  
ATOM   1326  CB  ALA   170      36.084  16.710  33.195  1.00 60.17           C  
ATOM   1327  N   TYR   171      36.066  18.034  30.403  1.00 64.63           N  
ATOM   1328  CA  TYR   171      36.787  18.537  29.245  1.00 66.52           C  
ATOM   1329  C   TYR   171      37.591  19.713  29.740  1.00 67.32           C  
ATOM   1330  O   TYR   171      37.192  20.375  30.693  1.00 69.33           O  
ATOM   1331  CB  TYR   171      35.827  19.018  28.160  1.00 66.79           C  
ATOM   1332  CG  TYR   171      34.923  20.122  28.638  1.00 68.70           C  
ATOM   1333  CD1 TYR   171      33.812  19.838  29.431  1.00 70.55           C  
ATOM   1334  CD2 TYR   171      35.204  21.458  28.354  1.00 68.74           C  
ATOM   1335  CE1 TYR   171      33.002  20.857  29.935  1.00 70.62           C  
ATOM   1336  CE2 TYR   171      34.399  22.489  28.854  1.00 69.66           C  
ATOM   1337  CZ  TYR   171      33.303  22.179  29.645  1.00 69.77           C  
ATOM   1338  OH  TYR   171      32.513  23.173  30.169  1.00 67.58           O  
ATOM   1339  N   ARG   172      38.723  19.979  29.108  1.00 66.90           N  
ATOM   1340  CA  ARG   172      39.522  21.109  29.521  1.00 66.95           C  
ATOM   1341  C   ARG   172      39.938  21.934  28.310  1.00 66.95           C  
ATOM   1342  O   ARG   172      40.433  21.392  27.316  1.00 66.90           O  
ATOM   1343  CB  ARG   172      40.772  20.645  30.268  1.00 67.46           C  
ATOM   1344  CG  ARG   172      41.364  21.719  31.162  1.00 70.04           C  
ATOM   1345  CD  ARG   172      40.433  21.940  32.339  1.00 74.46           C  
ATOM   1346  NE  ARG   172      40.334  23.324  32.784  1.00 76.61           N  
ATOM   1347  CZ  ARG   172      39.466  23.734  33.706  1.00 79.04           C  
ATOM   1348  NH1 ARG   172      38.638  22.855  34.273  1.00 77.36           N  
ATOM   1349  NH2 ARG   172      39.403  25.023  34.046  1.00 79.54           N  
ATOM   1350  N   ILE   173      39.723  23.243  28.390  1.00 65.29           N  
ATOM   1351  CA  ILE   173      40.124  24.129  27.312  1.00 63.66           C  
ATOM   1352  C   ILE   173      41.474  24.704  27.680  1.00 62.98           C  
ATOM   1353  O   ILE   173      41.576  25.455  28.637  1.00 62.68           O  
ATOM   1354  CB  ILE   173      39.162  25.310  27.140  1.00 62.85           C  
ATOM   1355  CG1 ILE   173      37.725  24.814  27.040  1.00 61.85           C  
ATOM   1356  CG2 ILE   173      39.515  26.064  25.875  1.00 62.71           C  
ATOM   1357  CD1 ILE   173      36.719  25.914  26.921  1.00 62.07           C  
ATOM   1358  N   LEU   174      42.508  24.347  26.936  1.00 63.11           N  
ATOM   1359  CA  LEU   174      43.834  24.875  27.208  1.00 65.88           C  
ATOM   1360  C   LEU   174      44.241  26.025  26.270  1.00 67.64           C  
ATOM   1361  O   LEU   174      43.879  26.044  25.098  1.00 67.57           O  
ATOM   1362  CB  LEU   174      44.884  23.771  27.089  1.00 66.60           C  
ATOM   1363  CG  LEU   174      44.896  22.548  28.011  1.00 68.44           C  
ATOM   1364  CD1 LEU   174      46.192  21.798  27.738  1.00 67.09           C  
ATOM   1365  CD2 LEU   174      44.821  22.931  29.487  1.00 67.41           C  
ATOM   1366  N   CYS   175      45.002  26.984  26.786  1.00 69.71           N  
ATOM   1367  CA  CYS   175      45.479  28.083  25.957  1.00 71.26           C  
ATOM   1368  C   CYS   175      46.927  27.756  25.633  1.00 72.34           C  
ATOM   1369  O   CYS   175      47.711  27.487  26.534  1.00 72.52           O  
ATOM   1370  CB  CYS   175      45.416  29.397  26.713  1.00 71.46           C  
ATOM   1371  SG  CYS   175      45.466  30.815  25.626  1.00 75.01           S  
ATOM   1372  N   GLU   176      47.282  27.779  24.354  1.00 74.58           N  
ATOM   1373  CA  GLU   176      48.641  27.449  23.915  1.00 76.40           C  
ATOM   1374  C   GLU   176      49.640  28.604  23.900  1.00 75.71           C  
ATOM   1375  O   GLU   176      50.763  28.438  23.428  1.00 75.54           O  
ATOM   1376  CB  GLU   176      48.603  26.806  22.517  1.00 79.08           C  
ATOM   1377  CG  GLU   176      48.006  25.390  22.486  1.00 84.44           C  
ATOM   1378  CD  GLU   176      48.012  24.747  21.089  1.00 87.05           C  
ATOM   1379  OE1 GLU   176      47.703  23.537  21.000  1.00 87.91           O  
ATOM   1380  OE2 GLU   176      48.314  25.441  20.086  1.00 87.82           O  
ATOM   1381  N   MET   177      49.250  29.761  24.425  1.00 75.11           N  
ATOM   1382  CA  MET   177      50.144  30.912  24.433  1.00 75.61           C  
ATOM   1383  C   MET   177      50.024  31.799  25.686  1.00 74.77           C  
ATOM   1384  O   MET   177      49.167  31.573  26.546  1.00 74.38           O  
ATOM   1385  CB  MET   177      49.889  31.754  23.175  1.00 77.08           C  
ATOM   1386  CG  MET   177      48.444  32.201  23.032  1.00 79.47           C  
ATOM   1387  SD  MET   177      48.165  33.310  21.637  1.00 83.37           S  
ATOM   1388  CE  MET   177      47.304  32.242  20.499  1.00 81.96           C  
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
ATOM   2064  N   THR   266      37.458  29.804  28.952  1.00 78.13           N  
ATOM   2065  CA  THR   266      36.132  29.307  29.265  1.00 81.48           C  
ATOM   2066  C   THR   266      35.394  28.993  27.958  1.00 82.53           C  
ATOM   2067  O   THR   266      35.831  29.405  26.887  1.00 81.51           O  
ATOM   2068  CB  THR   266      35.382  30.392  30.090  1.00 82.69           C  
ATOM   2069  OG1 THR   266      34.736  29.785  31.214  1.00 84.93           O  
ATOM   2070  CG2 THR   266      34.357  31.120  29.241  1.00 83.39           C  
ATOM   2071  N   LEU   267      34.289  28.258  28.034  1.00 85.06           N  
ATOM   2072  CA  LEU   267      33.538  27.930  26.822  1.00 87.81           C  
ATOM   2073  C   LEU   267      33.097  29.220  26.135  1.00 90.40           C  
ATOM   2074  O   LEU   267      33.109  29.312  24.904  1.00 91.23           O  
ATOM   2075  CB  LEU   267      32.328  27.065  27.158  1.00 87.01           C  
ATOM   2076  N   GLU   268      32.720  30.217  26.928  1.00 93.17           N  
ATOM   2077  CA  GLU   268      32.305  31.494  26.368  1.00 96.22           C  
ATOM   2078  C   GLU   268      33.447  32.088  25.529  1.00 98.05           C  
ATOM   2079  O   GLU   268      33.271  32.346  24.335  1.00 98.94           O  
ATOM   2080  CB  GLU   268      31.903  32.467  27.494  1.00 96.56           C  
ATOM   2081  N   ASP   269      34.610  32.290  26.154  1.00 99.11           N  
ATOM   2082  CA  ASP   269      35.787  32.852  25.472  1.00100.45           C  
ATOM   2083  C   ASP   269      35.951  32.333  24.043  1.00101.21           C  
ATOM   2084  O   ASP   269      36.147  33.089  23.102  1.00101.19           O  
ATOM   2085  CB  ASP   269      37.060  32.559  26.279  1.00100.45           C  
ATOM   2086  CG  ASP   269      37.159  33.415  27.523  1.00100.14           C  
ATOM   2087  OD1 ASP   269      37.234  32.856  28.637  1.00 99.05           O  
ATOM   2088  OD2 ASP   269      37.164  34.656  27.381  1.00101.41           O  
ATOM   2089  N   LEU   270      35.856  31.033  23.874  1.00103.10           N  
ATOM   2090  CA  LEU   270      36.046  30.475  22.572  1.00105.14           C  
ATOM   2091  C   LEU   270      34.968  30.775  21.517  1.00107.79           C  
ATOM   2092  O   LEU   270      35.273  31.311  20.415  1.00108.10           O  
ATOM   2093  CB  LEU   270      36.139  28.948  22.655  1.00104.65           C  
ATOM   2094  CG  LEU   270      37.214  28.290  23.550  1.00105.31           C  
ATOM   2095  CD1 LEU   270      37.156  26.751  23.521  1.00105.07           C  
ATOM   2096  CD2 LEU   270      38.575  28.770  23.093  1.00105.27           C  
ATOM   2097  N   HIS   271      33.693  30.552  21.871  1.00110.62           N  
ATOM   2098  CA  HIS   271      32.525  30.463  20.921  1.00112.69           C  
ATOM   2099  C   HIS   271      32.858  29.985  19.531  1.00113.58           C  
ATOM   2100  O   HIS   271      33.267  28.858  19.405  1.00114.13           O  
ATOM   2101  CB  HIS   271      31.416  31.499  20.867  1.00114.37           C  
ATOM   2102  CG  HIS   271      31.840  32.922  20.708  1.00116.56           C  
ATOM   2103  ND1 HIS   271      32.651  33.401  19.696  1.00117.03           N  
ATOM   2104  CD2 HIS   271      31.531  33.990  21.479  1.00116.65           C  
ATOM   2105  CE1 HIS   271      32.840  34.701  19.877  1.00116.92           C  
ATOM   2106  NE2 HIS   271      32.176  35.080  20.954  1.00117.04           N  
ATOM   2107  N   GLU   272      32.549  30.701  18.453  1.00113.08           N  
ATOM   2108  CA  GLU   272      32.826  30.184  17.121  1.00112.43           C  
ATOM   2109  C   GLU   272      31.701  29.314  16.606  1.00112.07           C  
ATOM   2110  O   GLU   272      30.686  29.802  16.077  1.00111.29           O  
ATOM   2111  N   SER   276      27.567  26.867  21.326  1.00113.63           N  
ATOM   2112  CA  SER   276      27.122  25.678  20.605  1.00113.98           C  
ATOM   2113  C   SER   276      28.316  24.928  20.013  1.00113.89           C  
ATOM   2114  O   SER   276      28.318  24.593  18.828  1.00114.79           O  
ATOM   2115  CB  SER   276      26.147  26.076  19.492  1.00113.28           C  
ATOM   2116  N   LEU   277      29.326  24.661  20.839  1.00113.04           N  
ATOM   2117  CA  LEU   277      30.518  23.963  20.371  1.00112.13           C  
ATOM   2118  C   LEU   277      30.589  22.481  20.766  1.00111.68           C  
ATOM   2119  O   LEU   277      31.660  21.965  21.097  1.00111.55           O  
ATOM   2120  CB  LEU   277      31.782  24.705  20.835  1.00111.47           C  
ATOM   2121  CG  LEU   277      32.031  26.077  20.197  0.00111.35           C  
ATOM   2122  CD1 LEU   277      31.017  27.089  20.713  0.00111.16           C  
ATOM   2123  CD2 LEU   277      33.445  26.526  20.523  0.00111.16           C  
ATOM   2124  N   ALA   278      29.439  21.810  20.719  1.00110.83           N  
ATOM   2125  CA  ALA   278      29.321  20.378  21.022  1.00110.30           C  
ATOM   2126  C   ALA   278      29.948  19.886  22.320  1.00109.58           C  
ATOM   2127  O   ALA   278      30.546  18.809  22.346  1.00108.88           O  
ATOM   2128  CB  ALA   278      29.876  19.552  19.850  1.00110.46           C  
ATOM   2129  N   LEU   279      29.805  20.652  23.395  1.00109.00           N  
ATOM   2130  CA  LEU   279      30.370  20.237  24.671  1.00108.24           C  
ATOM   2131  C   LEU   279      29.331  20.179  25.793  1.00107.87           C  
ATOM   2132  O   LEU   279      29.055  21.182  26.460  1.00108.93           O  
ATOM   2133  CB  LEU   279      31.535  21.158  25.072  1.00108.28           C  
ATOM   2134  CG  LEU   279      31.312  22.649  25.343  0.00108.10           C  
ATOM   2135  CD1 LEU   279      32.594  23.251  25.900  0.00108.05           C  
ATOM   2136  CD2 LEU   279      30.896  23.366  24.069  0.00108.05           C  
ATOM   2137  N   SER   280      28.757  18.991  25.979  1.00105.80           N  
ATOM   2138  CA  SER   280      27.755  18.713  27.013  1.00103.96           C  
ATOM   2139  C   SER   280      27.431  17.231  26.867  1.00102.47           C  
ATOM   2140  O   SER   280      27.079  16.778  25.778  1.00102.27           O  
ATOM   2141  CB  SER   280      26.490  19.561  26.811  1.00104.00           C  
ATOM   2142  OG  SER   280      25.823  19.231  25.608  1.00105.38           O  
ATOM   2143  N   LEU   281      27.547  16.471  27.952  1.00100.32           N  
ATOM   2144  CA  LEU   281      27.312  15.037  27.863  1.00 98.40           C  
ATOM   2145  C   LEU   281      25.987  14.504  28.371  1.00 96.59           C  
ATOM   2146  O   LEU   281      25.641  14.662  29.547  1.00 96.47           O  
ATOM   2147  CB  LEU   281      28.435  14.265  28.565  1.00 99.09           C  
ATOM   2148  CG  LEU   281      29.870  14.426  28.069  1.00100.53           C  
ATOM   2149  CD1 LEU   281      30.394  15.823  28.408  1.00101.96           C  
ATOM   2150  CD2 LEU   281      30.733  13.368  28.735  1.00101.63           C  
ATOM   2151  N   PRO   282      25.226  13.848  27.481  1.00 94.24           N  
ATOM   2152  CA  PRO   282      23.941  13.287  27.889  1.00 92.61           C  
ATOM   2153  C   PRO   282      24.257  12.091  28.774  1.00 91.72           C  
ATOM   2154  O   PRO   282      25.284  11.446  28.600  1.00 91.28           O  
ATOM   2155  CB  PRO   282      23.291  12.903  26.558  1.00 92.49           C  
ATOM   2156  CG  PRO   282      24.456  12.596  25.675  1.00 91.76           C  
ATOM   2157  CD  PRO   282      25.454  13.669  26.035  1.00 93.15           C  
ATOM   2158  N   TRP   283      23.382  11.812  29.729  1.00 91.82           N  
ATOM   2159  CA  TRP   283      23.571  10.711  30.665  1.00 91.47           C  
ATOM   2160  C   TRP   283      24.045   9.390  30.051  1.00 88.73           C  
ATOM   2161  O   TRP   283      24.900   8.717  30.619  1.00 87.59           O  
ATOM   2162  CB  TRP   283      22.272  10.513  31.469  1.00 96.12           C  
ATOM   2163  CG  TRP   283      21.971   9.096  31.881  1.00100.96           C  
ATOM   2164  CD1 TRP   283      22.774   8.257  32.598  1.00102.27           C  
ATOM   2165  CD2 TRP   283      20.784   8.351  31.577  1.00102.94           C  
ATOM   2166  NE1 TRP   283      22.163   7.032  32.755  1.00103.93           N  
ATOM   2167  CE2 TRP   283      20.940   7.063  32.139  1.00103.62           C  
ATOM   2168  CE3 TRP   283      19.603   8.648  30.883  1.00104.12           C  
ATOM   2169  CZ2 TRP   283      19.960   6.071  32.028  1.00104.29           C  
ATOM   2170  CZ3 TRP   283      18.626   7.660  30.773  1.00105.43           C  
ATOM   2171  CH2 TRP   283      18.814   6.386  31.344  1.00105.15           C  
ATOM   2172  N   GLU   284      23.504   9.017  28.899  1.00 86.26           N  
ATOM   2173  CA  GLU   284      23.899   7.763  28.266  1.00 83.97           C  
ATOM   2174  C   GLU   284      25.357   7.827  27.799  1.00 80.36           C  
ATOM   2175  O   GLU   284      26.154   6.943  28.106  1.00 78.82           O  
ATOM   2176  CB  GLU   284      22.966   7.450  27.086  1.00 87.06           C  
ATOM   2177  CG  GLU   284      23.218   6.107  26.409  1.00 91.30           C  
ATOM   2178  CD  GLU   284      22.895   4.913  27.303  1.00 94.83           C  
ATOM   2179  OE1 GLU   284      23.423   4.841  28.441  1.00 96.21           O  
ATOM   2180  OE2 GLU   284      22.115   4.039  26.854  1.00 96.02           O  
ATOM   2181  N   GLU   285      25.700   8.880  27.066  1.00 76.86           N  
ATOM   2182  CA  GLU   285      27.062   9.063  26.573  1.00 74.61           C  
ATOM   2183  C   GLU   285      28.061   9.222  27.718  1.00 71.80           C  
ATOM   2184  O   GLU   285      29.205   8.810  27.624  1.00 70.09           O  
ATOM   2185  CB  GLU   285      27.130  10.281  25.663  1.00 75.14           C  
ATOM   2186  N   ARG   286      27.620   9.827  28.803  1.00 70.17           N  
ATOM   2187  CA  ARG   286      28.495  10.028  29.940  1.00 69.41           C  
ATOM   2188  C   ARG   286      28.888   8.721  30.571  1.00 68.08           C  
ATOM   2189  O   ARG   286      30.045   8.504  30.886  1.00 67.01           O  
ATOM   2190  CB  ARG   286      27.811  10.889  31.003  1.00 69.51           C  
ATOM   2191  CG  ARG   286      28.754  11.327  32.094  1.00 69.39           C  
ATOM   2192  CD  ARG   286      28.079  12.197  33.122  1.00 70.70           C  
ATOM   2193  NE  ARG   286      29.080  12.959  33.860  1.00 73.75           N  
ATOM   2194  CZ  ARG   286      29.819  13.932  33.328  1.00 74.85           C  
ATOM   2195  NH1 ARG   286      29.659  14.276  32.055  1.00 73.29           N  
ATOM   2196  NH2 ARG   286      30.757  14.529  34.058  1.00 75.58           N  
ATOM   2197  N   ARG   287      27.898   7.861  30.766  1.00 68.58           N  
ATOM   2198  CA  ARG   287      28.097   6.571  31.400  1.00 68.75           C  
ATOM   2199  C   ARG   287      29.068   5.671  30.648  1.00 67.31           C  
ATOM   2200  O   ARG   287      29.967   5.087  31.249  1.00 66.14           O  
ATOM   2201  CB  ARG   287      26.753   5.853  31.563  1.00 70.69           C  
ATOM   2202  CG  ARG   287      26.885   4.493  32.208  1.00 73.21           C  
ATOM   2203  CD  ARG   287      25.887   3.540  31.613  1.00 76.93           C  
ATOM   2204  NE  ARG   287      24.613   3.605  32.313  1.00 80.48           N  
ATOM   2205  CZ  ARG   287      23.507   2.997  31.903  1.00 80.95           C  
ATOM   2206  NH1 ARG   287      23.516   2.284  30.789  1.00 80.44           N  
ATOM   2207  NH2 ARG   287      22.400   3.084  32.625  1.00 83.02           N  
ATOM   2208  N   ARG   288      28.884   5.550  29.339  1.00 66.04           N  
ATOM   2209  CA  ARG   288      29.764   4.695  28.562  1.00 66.05           C  
ATOM   2210  C   ARG   288      31.187   5.248  28.582  1.00 64.44           C  
ATOM   2211  O   ARG   288      32.153   4.493  28.572  1.00 63.70           O  
ATOM   2212  CB  ARG   288      29.259   4.529  27.109  1.00 66.54           C  
ATOM   2213  CG  ARG   288      29.356   5.747  26.197  1.00 67.75           C  
ATOM   2214  CD  ARG   288      29.127   5.323  24.739  1.00 70.78           C  
ATOM   2215  NE  ARG   288      27.857   4.611  24.558  1.00 73.79           N  
ATOM   2216  CZ  ARG   288      26.690   5.196  24.279  1.00 73.76           C  
ATOM   2217  NH1 ARG   288      26.617   6.515  24.136  1.00 74.79           N  
ATOM   2218  NH2 ARG   288      25.590   4.465  24.159  1.00 71.85           N  
ATOM   2219  N   ARG   289      31.313   6.568  28.631  1.00 63.54           N  
ATOM   2220  CA  ARG   289      32.628   7.189  28.651  1.00 62.32           C  
ATOM   2221  C   ARG   289      33.343   6.981  29.956  1.00 61.76           C  
ATOM   2222  O   ARG   289      34.567   6.910  29.973  1.00 62.62           O  
ATOM   2223  CB  ARG   289      32.547   8.684  28.381  1.00 62.50           C  
ATOM   2224  CG  ARG   289      32.331   9.025  26.944  1.00 64.29           C  
ATOM   2225  CD  ARG   289      32.410  10.514  26.754  1.00 67.34           C  
ATOM   2226  NE  ARG   289      32.089  10.874  25.378  1.00 70.40           N  
ATOM   2227  CZ  ARG   289      32.444  12.019  24.808  1.00 70.25           C  
ATOM   2228  NH1 ARG   289      33.142  12.922  25.500  1.00 70.87           N  
ATOM   2229  NH2 ARG   289      32.095  12.259  23.551  1.00 68.30           N  
ATOM   2230  N   THR   290      32.606   6.891  31.057  1.00 59.53           N  
ATOM   2231  CA  THR   290      33.283   6.684  32.314  1.00 58.33           C  
ATOM   2232  C   THR   290      33.763   5.232  32.409  1.00 57.87           C  
ATOM   2233  O   THR   290      34.775   4.947  33.036  1.00 56.85           O  
ATOM   2234  CB  THR   290      32.403   7.173  33.536  1.00 57.40           C  
ATOM   2235  OG1 THR   290      32.421   6.213  34.595  1.00 56.08           O  
ATOM   2236  CG2 THR   290      30.998   7.462  33.109  1.00 56.36           C  
ATOM   2237  N   ARG   291      33.084   4.325  31.724  1.00 59.12           N  
ATOM   2238  CA  ARG   291      33.500   2.930  31.728  1.00 60.57           C  
ATOM   2239  C   ARG   291      34.683   2.723  30.864  1.00 59.82           C  
ATOM   2240  O   ARG   291      35.525   1.868  31.117  1.00 60.55           O  
ATOM   2241  CB  ARG   291      32.448   2.041  31.156  1.00 62.67           C  
ATOM   2242  CG  ARG   291      31.385   1.854  32.074  1.00 69.24           C  
ATOM   2243  CD  ARG   291      30.767   0.548  31.888  1.00 73.44           C  
ATOM   2244  NE  ARG   291      29.687   0.562  32.833  1.00 78.41           N  
ATOM   2245  CZ  ARG   291      29.336  -0.459  33.592  1.00 81.92           C  
ATOM   2246  NH1 ARG   291      29.988  -1.611  33.509  1.00 82.26           N  
ATOM   2247  NH2 ARG   291      28.342  -0.305  34.460  1.00 82.38           N  
ATOM   2248  N   GLU   292      34.684   3.470  29.785  1.00 57.40           N  
ATOM   2249  CA  GLU   292      35.740   3.390  28.837  1.00 56.82           C  
ATOM   2250  C   GLU   292      37.015   3.963  29.484  1.00 55.16           C  
ATOM   2251  O   GLU   292      38.040   3.275  29.519  1.00 54.83           O  
ATOM   2252  CB  GLU   292      35.321   4.150  27.584  1.00 60.91           C  
ATOM   2253  CG  GLU   292      36.085   3.755  26.350  1.00 66.48           C  
ATOM   2254  CD  GLU   292      35.946   4.784  25.250  1.00 70.14           C  
ATOM   2255  OE1 GLU   292      34.793   5.121  24.894  1.00 72.42           O  
ATOM   2256  OE2 GLU   292      36.986   5.251  24.741  1.00 71.34           O  
ATOM   2257  N   ILE   293      36.968   5.195  30.000  1.00 50.95           N  
ATOM   2258  CA  ILE   293      38.148   5.753  30.672  1.00 48.78           C  
ATOM   2259  C   ILE   293      38.625   4.821  31.795  1.00 49.38           C  
ATOM   2260  O   ILE   293      39.814   4.597  31.943  1.00 50.00           O  
ATOM   2261  CB  ILE   293      37.890   7.093  31.376  1.00 48.19           C  
ATOM   2262  CG1 ILE   293      37.427   8.164  30.389  1.00 47.57           C  
ATOM   2263  CG2 ILE   293      39.166   7.546  32.053  1.00 42.73           C  
ATOM   2264  CD1 ILE   293      38.441   8.492  29.366  1.00 46.54           C  
ATOM   2265  N   ALA   294      37.704   4.293  32.595  1.00 48.50           N  
ATOM   2266  CA  ALA   294      38.093   3.410  33.692  1.00 49.37           C  
ATOM   2267  C   ALA   294      38.888   2.204  33.207  1.00 49.06           C  
ATOM   2268  O   ALA   294      39.860   1.804  33.848  1.00 50.12           O  
ATOM   2269  CB  ALA   294      36.843   2.939  34.506  1.00 49.04           C  
ATOM   2270  N   SER   295      38.462   1.608  32.099  1.00 47.41           N  
ATOM   2271  CA  SER   295      39.177   0.473  31.546  1.00 46.91           C  
ATOM   2272  C   SER   295      40.586   0.914  31.214  1.00 47.78           C  
ATOM   2273  O   SER   295      41.557   0.215  31.499  1.00 45.29           O  
ATOM   2274  CB  SER   295      38.500  -0.017  30.286  1.00 47.12           C  
ATOM   2275  OG  SER   295      37.520  -0.984  30.617  1.00 53.48           O  
ATOM   2276  N   TRP   296      40.669   2.096  30.611  1.00 49.29           N  
ATOM   2277  CA  TRP   296      41.927   2.709  30.241  1.00 51.33           C  
ATOM   2278  C   TRP   296      42.837   2.943  31.446  1.00 51.69           C  
ATOM   2279  O   TRP   296      43.913   2.360  31.535  1.00 51.03           O  
ATOM   2280  CB  TRP   296      41.660   4.041  29.518  1.00 54.07           C  
ATOM   2281  CG  TRP   296      42.764   5.077  29.645  1.00 59.32           C  
ATOM   2282  CD1 TRP   296      42.922   6.013  30.646  1.00 62.64           C  
ATOM   2283  CD2 TRP   296      43.863   5.258  28.763  1.00 60.62           C  
ATOM   2284  NE1 TRP   296      44.055   6.761  30.433  1.00 62.23           N  
ATOM   2285  CE2 TRP   296      44.650   6.317  29.287  1.00 63.06           C  
ATOM   2286  CE3 TRP   296      44.261   4.632  27.587  1.00 62.21           C  
ATOM   2287  CZ2 TRP   296      45.816   6.754  28.663  1.00 65.71           C  
ATOM   2288  CZ3 TRP   296      45.423   5.071  26.962  1.00 66.53           C  
ATOM   2289  CH2 TRP   296      46.189   6.123  27.504  1.00 67.27           C  
ATOM   2290  N   ILE   297      42.411   3.782  32.387  1.00 51.44           N  
ATOM   2291  CA  ILE   297      43.280   4.072  33.505  1.00 52.59           C  
ATOM   2292  C   ILE   297      43.568   2.812  34.255  1.00 52.56           C  
ATOM   2293  O   ILE   297      44.579   2.710  34.916  1.00 54.75           O  
ATOM   2294  CB  ILE   297      42.704   5.160  34.460  1.00 53.37           C  
ATOM   2295  CG1 ILE   297      43.850   5.922  35.121  1.00 56.37           C  
ATOM   2296  CG2 ILE   297      41.983   4.537  35.630  1.00 54.37           C  
ATOM   2297  CD1 ILE   297      44.784   6.644  34.151  1.00 58.49           C  
ATOM   2298  N   GLY   298      42.687   1.836  34.137  1.00 53.37           N  
ATOM   2299  CA  GLY   298      42.905   0.584  34.831  1.00 54.13           C  
ATOM   2300  C   GLY   298      44.129  -0.161  34.322  1.00 55.78           C  
ATOM   2301  O   GLY   298      44.889  -0.713  35.113  1.00 56.14           O  
ATOM   2302  N   ARG   299      44.351  -0.184  33.011  1.00 56.49           N  
ATOM   2303  CA  ARG   299      45.499  -0.916  32.527  1.00 57.25           C  
ATOM   2304  C   ARG   299      46.753  -0.214  32.970  1.00 56.85           C  
ATOM   2305  O   ARG   299      47.729  -0.850  33.321  1.00 58.47           O  
ATOM   2306  CB  ARG   299      45.506  -1.066  31.002  1.00 58.73           C  
ATOM   2307  CG  ARG   299      46.268  -2.329  30.586  1.00 60.46           C  
ATOM   2308  CD  ARG   299      47.151  -2.150  29.378  1.00 63.73           C  
ATOM   2309  NE  ARG   299      46.482  -2.423  28.107  1.00 67.08           N  
ATOM   2310  CZ  ARG   299      45.789  -3.530  27.834  1.00 68.40           C  
ATOM   2311  NH1 ARG   299      45.653  -4.485  28.746  1.00 67.18           N  
ATOM   2312  NH2 ARG   299      45.253  -3.693  26.630  1.00 69.98           N  
ATOM   2313  N   ARG   300      46.717   1.105  32.979  1.00 56.74           N  
ATOM   2314  CA  ARG   300      47.865   1.891  33.389  1.00 56.46           C  
ATOM   2315  C   ARG   300      48.090   1.946  34.900  1.00 57.53           C  
ATOM   2316  O   ARG   300      49.160   2.339  35.356  1.00 59.87           O  
ATOM   2317  CB  ARG   300      47.730   3.293  32.809  1.00 55.09           C  
ATOM   2318  CG  ARG   300      47.955   3.281  31.310  1.00 58.90           C  
ATOM   2319  CD  ARG   300      47.009   4.184  30.518  1.00 61.61           C  
ATOM   2320  NE  ARG   300      47.162   3.913  29.091  1.00 63.08           N  
ATOM   2321  CZ  ARG   300      46.685   2.834  28.469  1.00 65.60           C  
ATOM   2322  NH1 ARG   300      46.001   1.912  29.131  1.00 67.13           N  
ATOM   2323  NH2 ARG   300      46.925   2.654  27.175  1.00 67.61           N  
ATOM   2324  N   LEU   301      47.105   1.528  35.681  1.00 57.46           N  
ATOM   2325  CA  LEU   301      47.239   1.565  37.124  1.00 59.08           C  
ATOM   2326  C   LEU   301      47.855   0.318  37.759  1.00 60.41           C  
ATOM   2327  O   LEU   301      48.461   0.406  38.825  1.00 60.51           O  
ATOM   2328  CB  LEU   301      45.879   1.813  37.765  1.00 61.05           C  
ATOM   2329  CG  LEU   301      45.667   3.121  38.528  1.00 61.22           C  
ATOM   2330  CD1 LEU   301      44.390   3.024  39.369  1.00 60.58           C  
ATOM   2331  CD2 LEU   301      46.852   3.381  39.418  1.00 60.26           C  
ATOM   2332  N   GLY   302      47.674  -0.839  37.131  1.00 61.31           N  
ATOM   2333  CA  GLY   302      48.230  -2.071  37.673  1.00 63.15           C  
ATOM   2334  C   GLY   302      47.728  -2.487  39.055  1.00 64.27           C  
ATOM   2335  O   GLY   302      48.470  -3.092  39.838  1.00 64.94           O  
ATOM   2336  N   LEU   303      46.471  -2.175  39.355  1.00 63.34           N  
ATOM   2337  CA  LEU   303      45.880  -2.518  40.639  1.00 62.86           C  
ATOM   2338  C   LEU   303      44.657  -3.411  40.411  1.00 63.13           C  
ATOM   2339  O   LEU   303      43.629  -3.279  41.084  1.00 63.03           O  
ATOM   2340  CB  LEU   303      45.480  -1.233  41.378  1.00 63.36           C  
ATOM   2341  CG  LEU   303      46.483  -0.496  42.284  1.00 63.68           C  
ATOM   2342  CD1 LEU   303      47.911  -0.759  41.860  1.00 64.24           C  
ATOM   2343  CD2 LEU   303      46.178   0.995  42.249  1.00 61.54           C  
ATOM   2344  N   GLY   304      44.774  -4.321  39.451  1.00 62.71           N  
ATOM   2345  CA  GLY   304      43.671  -5.208  39.147  1.00 61.55           C  
ATOM   2346  C   GLY   304      42.687  -4.553  38.204  1.00 62.77           C  
ATOM   2347  O   GLY   304      42.790  -3.370  37.888  1.00 64.41           O  
ATOM   2348  N   THR   305      41.712  -5.328  37.757  1.00 64.20           N  
ATOM   2349  CA  THR   305      40.703  -4.838  36.831  1.00 65.30           C  
ATOM   2350  C   THR   305      39.565  -4.091  37.526  1.00 66.49           C  
ATOM   2351  O   THR   305      39.062  -4.500  38.569  1.00 66.29           O  
ATOM   2352  CB  THR   305      40.105  -6.009  36.014  1.00 64.90           C  
ATOM   2353  OG1 THR   305      41.168  -6.769  35.439  1.00 65.27           O  
ATOM   2354  CG2 THR   305      39.212  -5.494  34.891  1.00 64.35           C  
ATOM   2355  N   PRO   306      39.153  -2.969  36.948  1.00 67.33           N  
ATOM   2356  CA  PRO   306      38.065  -2.192  37.538  1.00 68.13           C  
ATOM   2357  C   PRO   306      36.710  -2.883  37.440  1.00 67.91           C  
ATOM   2358  O   PRO   306      36.226  -3.131  36.344  1.00 68.25           O  
ATOM   2359  CB  PRO   306      38.107  -0.903  36.729  1.00 68.19           C  
ATOM   2360  CG  PRO   306      39.556  -0.756  36.446  1.00 67.64           C  
ATOM   2361  CD  PRO   306      39.934  -2.145  36.017  1.00 66.54           C  
ATOM   2362  N   GLU   307      36.106  -3.202  38.580  1.00 68.87           N  
ATOM   2363  CA  GLU   307      34.777  -3.822  38.589  1.00 69.87           C  
ATOM   2364  C   GLU   307      33.797  -2.751  39.058  1.00 69.54           C  
ATOM   2365  O   GLU   307      33.794  -2.367  40.226  1.00 69.63           O  
ATOM   2366  CB  GLU   307      34.707  -5.021  39.548  1.00 71.42           C  
ATOM   2367  CG  GLU   307      35.481  -6.278  39.132  1.00 74.98           C  
ATOM   2368  CD  GLU   307      35.079  -6.810  37.757  1.00 77.74           C  
ATOM   2369  OE1 GLU   307      33.986  -6.438  37.262  1.00 79.56           O  
ATOM   2370  OE2 GLU   307      35.855  -7.609  37.174  1.00 77.49           O  
ATOM   2371  N   ALA   308      32.978  -2.257  38.140  1.00 69.22           N  
ATOM   2372  CA  ALA   308      32.011  -1.221  38.475  1.00 70.10           C  
ATOM   2373  C   ALA   308      31.255  -1.558  39.748  1.00 69.75           C  
ATOM   2374  O   ALA   308      30.737  -2.656  39.898  1.00 70.62           O  
ATOM   2375  CB  ALA   308      31.027  -1.028  37.312  1.00 70.49           C  
ATOM   2376  N   VAL   309      31.195  -0.616  40.675  1.00 70.65           N  
ATOM   2377  CA  VAL   309      30.477  -0.869  41.912  1.00 71.44           C  
ATOM   2378  C   VAL   309      29.007  -0.610  41.756  1.00 72.10           C  
ATOM   2379  O   VAL   309      28.593   0.422  41.247  1.00 72.02           O  
ATOM   2380  CB  VAL   309      30.960  -0.003  43.055  1.00 70.93           C  
ATOM   2381  CG1 VAL   309      29.954  -0.070  44.206  1.00 70.23           C  
ATOM   2382  CG2 VAL   309      32.315  -0.492  43.508  1.00 69.44           C  
ATOM   2383  N   ARG   310      28.209  -1.556  42.212  1.00 73.62           N  
ATOM   2384  CA  ARG   310      26.782  -1.387  42.107  1.00 74.10           C  
ATOM   2385  C   ARG   310      26.201  -1.425  43.500  1.00 73.87           C  
ATOM   2386  O   ARG   310      26.722  -2.098  44.404  1.00 72.94           O  
ATOM   2387  CB  ARG   310      26.203  -2.489  41.290  1.00 74.85           C  
ATOM   2388  CG  ARG   310      26.276  -3.764  42.004  1.00 76.05           C  
ATOM   2389  CD  ARG   310      25.610  -4.750  41.159  1.00 78.99           C  
ATOM   2390  NE  ARG   310      26.530  -5.166  40.116  1.00 82.02           N  
ATOM   2391  CZ  ARG   310      26.175  -5.483  38.878  1.00 82.09           C  
ATOM   2392  NH1 ARG   310      24.900  -5.419  38.509  1.00 80.59           N  
ATOM   2393  NH2 ARG   310      27.101  -5.895  38.020  1.00 81.60           N  
ATOM   2394  N   ALA   311      25.105  -0.709  43.673  1.00 73.37           N  
ATOM   2395  CA  ALA   311      24.533  -0.634  44.995  1.00 73.62           C  
ATOM   2396  C   ALA   311      23.030  -0.634  45.066  1.00 72.34           C  
ATOM   2397  O   ALA   311      22.324  -0.431  44.079  1.00 69.53           O  
ATOM   2398  CB  ALA   311      25.084   0.594  45.712  1.00 74.22           C  
ATOM   2399  N   GLN   312      22.552  -0.874  46.274  1.00 73.69           N  
ATOM   2400  CA  GLN   312      21.130  -0.897  46.518  1.00 76.13           C  
ATOM   2401  C   GLN   312      20.688   0.518  46.872  1.00 75.73           C  
ATOM   2402  O   GLN   312      21.188   1.131  47.816  1.00 75.52           O  
ATOM   2403  CB  GLN   312      20.793  -1.900  47.636  1.00 77.68           C  
ATOM   2404  CG  GLN   312      22.000  -2.409  48.421  1.00 82.12           C  
ATOM   2405  CD  GLN   312      22.529  -1.396  49.428  1.00 85.92           C  
ATOM   2406  OE1 GLN   312      22.237  -1.485  50.630  1.00 87.52           O  
ATOM   2407  NE2 GLN   312      23.300  -0.418  48.943  1.00 85.97           N  
ATOM   2408  N   ALA   313      19.770   1.035  46.068  1.00 75.18           N  
ATOM   2409  CA  ALA   313      19.235   2.366  46.255  1.00 75.28           C  
ATOM   2410  C   ALA   313      17.768   2.284  46.666  1.00 75.23           C  
ATOM   2411  O   ALA   313      16.908   1.934  45.856  1.00 74.23           O  
ATOM   2412  CB  ALA   313      19.375   3.159  44.967  1.00 75.77           C  
ATOM   2413  N   TYR   314      17.499   2.613  47.929  1.00 75.56           N  
ATOM   2414  CA  TYR   314      16.149   2.595  48.488  1.00 75.55           C  
ATOM   2415  C   TYR   314      15.419   3.883  48.282  1.00 74.76           C  
ATOM   2416  O   TYR   314      15.954   4.968  48.495  1.00 74.85           O  
ATOM   2417  CB  TYR   314      16.179   2.375  49.978  1.00 76.97           C  
ATOM   2418  CG  TYR   314      16.938   1.168  50.371  1.00 79.66           C  
ATOM   2419  CD1 TYR   314      16.291  -0.037  50.613  1.00 80.27           C  
ATOM   2420  CD2 TYR   314      18.314   1.225  50.509  1.00 80.84           C  
ATOM   2421  CE1 TYR   314      17.006  -1.159  50.991  1.00 81.85           C  
ATOM   2422  CE2 TYR   314      19.038   0.116  50.880  1.00 82.23           C  
ATOM   2423  CZ  TYR   314      18.383  -1.070  51.123  1.00 82.34           C  
ATOM   2424  OH  TYR   314      19.117  -2.157  51.512  1.00 84.14           O  
ATOM   2425  N   ARG   315      14.161   3.747  47.920  1.00 74.63           N  
ATOM   2426  CA  ARG   315      13.322   4.896  47.704  1.00 75.28           C  
ATOM   2427  C   ARG   315      12.631   5.315  48.990  1.00 73.87           C  
ATOM   2428  O   ARG   315      11.697   4.660  49.418  1.00 73.32           O  
ATOM   2429  CB  ARG   315      12.279   4.554  46.692  1.00 77.06           C  
ATOM   2430  CG  ARG   315      11.474   5.726  46.399  1.00 79.66           C  
ATOM   2431  CD  ARG   315      11.018   5.577  45.041  1.00 83.22           C  
ATOM   2432  NE  ARG   315       9.782   4.829  45.037  1.00 87.80           N  
ATOM   2433  CZ  ARG   315       9.319   4.185  43.980  1.00 89.91           C  
ATOM   2434  NH1 ARG   315      10.009   4.190  42.846  1.00 91.11           N  
ATOM   2435  NH2 ARG   315       8.149   3.573  44.048  1.00 90.31           N  
ATOM   2436  N   LEU   316      13.062   6.415  49.590  1.00 73.39           N  
ATOM   2437  CA  LEU   316      12.480   6.855  50.857  1.00 73.13           C  
ATOM   2438  C   LEU   316      10.988   7.206  50.835  1.00 72.10           C  
ATOM   2439  O   LEU   316      10.474   7.747  49.853  1.00 71.20           O  
ATOM   2440  CB  LEU   316      13.281   8.040  51.399  1.00 72.76           C  
ATOM   2441  CG  LEU   316      14.747   7.758  51.739  1.00 72.22           C  
ATOM   2442  CD1 LEU   316      15.495   9.065  51.898  1.00 70.89           C  
ATOM   2443  CD2 LEU   316      14.845   6.924  52.997  1.00 70.91           C  
ATOM   2444  N   SER   317      10.299   6.901  51.930  1.00 72.05           N  
ATOM   2445  CA  SER   317       8.876   7.205  52.027  1.00 73.18           C  
ATOM   2446  C   SER   317       8.623   8.710  51.941  1.00 73.42           C  
ATOM   2447  O   SER   317       9.277   9.512  52.608  1.00 72.85           O  
ATOM   2448  CB  SER   317       8.270   6.636  53.328  1.00 72.42           C  
ATOM   2449  OG  SER   317       8.847   7.196  54.491  1.00 72.42           O  
ATOM   2450  N   ILE   318       7.674   9.068  51.083  1.00 75.17           N  
ATOM   2451  CA  ILE   318       7.266  10.447  50.853  1.00 76.64           C  
ATOM   2452  C   ILE   318       6.534  10.963  52.093  1.00 76.34           C  
ATOM   2453  O   ILE   318       5.683  10.281  52.656  1.00 76.86           O  
ATOM   2454  CB  ILE   318       6.352  10.509  49.611  1.00 78.09           C  
ATOM   2455  CG1 ILE   318       7.160  10.092  48.375  1.00 79.57           C  
ATOM   2456  CG2 ILE   318       5.768  11.897  49.445  1.00 76.73           C  
ATOM   2457  CD1 ILE   318       6.323   9.856  47.120  1.00 81.63           C  
ATOM   2458  N   PRO   319       6.865  12.183  52.536  1.00 76.40           N  
ATOM   2459  CA  PRO   319       6.267  12.823  53.720  1.00 76.49           C  
ATOM   2460  C   PRO   319       4.781  13.233  53.662  1.00 75.57           C  
ATOM   2461  O   PRO   319       4.320  13.839  52.690  1.00 74.41           O  
ATOM   2462  CB  PRO   319       7.186  14.023  53.949  1.00 75.91           C  
ATOM   2463  CG  PRO   319       7.553  14.418  52.548  1.00 75.48           C  
ATOM   2464  CD  PRO   319       7.837  13.082  51.885  1.00 76.26           C  
ATOM   2465  N   LYS   320       4.042  12.891  54.714  1.00 75.02           N  
ATOM   2466  CA  LYS   320       2.638  13.259  54.798  1.00 74.69           C  
ATOM   2467  C   LYS   320       2.621  14.736  55.159  1.00 74.67           C  
ATOM   2468  O   LYS   320       2.709  15.105  56.328  1.00 74.28           O  
ATOM   2469  CB  LYS   320       1.932  12.449  55.874  1.00 73.82           C  
ATOM   2470  N   LEU   321       2.544  15.569  54.132  1.00 75.17           N  
ATOM   2471  CA  LEU   321       2.518  17.013  54.281  1.00 76.56           C  
ATOM   2472  C   LEU   321       1.089  17.463  54.459  1.00 78.23           C  
ATOM   2473  O   LEU   321       0.190  16.965  53.781  1.00 79.23           O  
ATOM   2474  CB  LEU   321       3.052  17.688  53.022  1.00 75.87           C  
ATOM   2475  CG  LEU   321       4.509  18.104  52.880  1.00 76.18           C  
ATOM   2476  CD1 LEU   321       5.429  16.953  53.216  1.00 76.87           C  
ATOM   2477  CD2 LEU   321       4.735  18.580  51.453  1.00 75.72           C  
ATOM   2478  N   MET   322       0.866  18.408  55.358  1.00 79.65           N  
ATOM   2479  CA  MET   322      -0.482  18.908  55.537  1.00 81.28           C  
ATOM   2480  C   MET   322      -0.584  20.268  56.194  1.00 78.82           C  
ATOM   2481  O   MET   322      -0.027  20.503  57.261  1.00 76.72           O  
ATOM   2482  CB  MET   322      -1.334  17.905  56.308  1.00 85.67           C  
ATOM   2483  CG  MET   322      -0.895  17.647  57.725  1.00 90.88           C  
ATOM   2484  SD  MET   322      -2.240  16.800  58.586  1.00 98.69           S  
ATOM   2485  CE  MET   322      -2.381  15.260  57.570  1.00 96.37           C  
ATOM   2486  N   GLY   323      -1.295  21.159  55.514  1.00 77.51           N  
ATOM   2487  CA  GLY   323      -1.525  22.499  56.020  1.00 77.01           C  
ATOM   2488  C   GLY   323      -2.858  22.439  56.735  1.00 75.76           C  
ATOM   2489  O   GLY   323      -3.016  21.619  57.629  1.00 74.22           O  
ATOM   2490  N   ARG   324      -3.817  23.278  56.344  1.00 76.29           N  
ATOM   2491  CA  ARG   324      -5.133  23.244  56.970  1.00 76.56           C  
ATOM   2492  C   ARG   324      -5.740  21.866  56.714  1.00 77.94           C  
ATOM   2493  O   ARG   324      -6.434  21.318  57.561  1.00 77.88           O  
ATOM   2494  CB  ARG   324      -6.037  24.331  56.420  1.00 75.07           C  
ATOM   2495  CG  ARG   324      -7.306  24.476  57.209  1.00 72.49           C  
ATOM   2496  CD  ARG   324      -7.929  25.815  56.969  1.00 71.41           C  
ATOM   2497  NE  ARG   324      -9.012  26.048  57.905  1.00 69.72           N  
ATOM   2498  CZ  ARG   324      -9.626  27.212  58.060  1.00 69.49           C  
ATOM   2499  NH1 ARG   324      -9.266  28.264  57.336  1.00 68.09           N  
ATOM   2500  NH2 ARG   324     -10.592  27.323  58.956  1.00 69.88           N  
ATOM   2501  N   ARG   325      -5.486  21.307  55.536  1.00 80.31           N  
ATOM   2502  CA  ARG   325      -5.921  19.952  55.201  1.00 83.03           C  
ATOM   2503  C   ARG   325      -4.787  19.299  54.425  1.00 83.42           C  
ATOM   2504  O   ARG   325      -3.901  19.997  53.932  1.00 83.67           O  
ATOM   2505  CB  ARG   325      -7.200  19.946  54.350  1.00 84.59           C  
ATOM   2506  CG  ARG   325      -7.142  20.755  53.100  1.00 85.86           C  
ATOM   2507  CD  ARG   325      -8.465  20.554  52.422  1.00 87.95           C  
ATOM   2508  NE  ARG   325      -8.730  21.537  51.397  1.00 91.35           N  
ATOM   2509  CZ  ARG   325      -8.532  21.361  50.099  1.00 93.28           C  
ATOM   2510  NH1 ARG   325      -8.052  20.208  49.637  1.00 94.64           N  
ATOM   2511  NH2 ARG   325      -8.831  22.360  49.268  1.00 94.28           N  
ATOM   2512  N   ALA   326      -4.820  17.968  54.319  1.00 83.71           N  
ATOM   2513  CA  ALA   326      -3.778  17.239  53.581  1.00 83.29           C  
ATOM   2514  C   ALA   326      -3.311  17.993  52.313  1.00 82.66           C  
ATOM   2515  O   ALA   326      -4.100  18.666  51.647  1.00 81.68           O  
ATOM   2516  CB  ALA   326      -4.252  15.841  53.207  1.00 83.45           C  
ATOM   2517  N   VAL   327      -2.027  17.867  51.980  1.00 82.72           N  
ATOM   2518  CA  VAL   327      -1.460  18.556  50.822  1.00 83.20           C  
ATOM   2519  C   VAL   327      -0.366  17.737  50.128  1.00 83.72           C  
ATOM   2520  O   VAL   327       0.341  16.953  50.764  1.00 83.40           O  
ATOM   2521  CB  VAL   327      -0.872  19.922  51.258  1.00 83.36           C  
ATOM   2522  CG1 VAL   327      -0.036  20.521  50.156  1.00 83.27           C  
ATOM   2523  CG2 VAL   327      -1.994  20.873  51.620  1.00 84.19           C  
ATOM   2524  N   SER   328      -0.233  17.929  48.821  1.00 83.97           N  
ATOM   2525  CA  SER   328       0.771  17.228  48.045  1.00 84.91           C  
ATOM   2526  C   SER   328       2.097  17.981  48.107  1.00 85.65           C  
ATOM   2527  O   SER   328       3.171  17.402  47.935  1.00 85.53           O  
ATOM   2528  CB  SER   328       0.301  17.095  46.599  1.00 84.91           C  
ATOM   2529  OG  SER   328       1.401  17.009  45.710  1.00 86.91           O  
ATOM   2530  N   LYS   329       2.023  19.283  48.347  1.00 86.24           N  
ATOM   2531  CA  LYS   329       3.237  20.063  48.446  1.00 86.83           C  
ATOM   2532  C   LYS   329       3.124  21.362  49.205  1.00 86.35           C  
ATOM   2533  O   LYS   329       2.105  22.052  49.174  1.00 86.11           O  
ATOM   2534  CB  LYS   329       3.810  20.353  47.086  1.00 87.59           C  
ATOM   2535  CG  LYS   329       3.021  19.841  45.927  1.00 89.31           C  
ATOM   2536  CD  LYS   329       2.947  20.916  44.871  1.00 90.93           C  
ATOM   2537  CE  LYS   329       3.957  22.034  45.133  1.00 90.94           C  
ATOM   2538  NZ  LYS   329       5.330  21.519  45.427  1.00 92.30           N  
ATOM   2539  N   PRO   330       4.220  21.745  49.855  1.00 85.48           N  
ATOM   2540  CA  PRO   330       4.249  22.967  50.641  1.00 84.14           C  
ATOM   2541  C   PRO   330       3.553  24.168  50.022  1.00 82.55           C  
ATOM   2542  O   PRO   330       2.716  24.777  50.677  1.00 82.62           O  
ATOM   2543  CB  PRO   330       5.738  23.175  50.875  1.00 84.95           C  
ATOM   2544  CG  PRO   330       6.245  21.754  50.946  1.00 85.65           C  
ATOM   2545  CD  PRO   330       5.576  21.184  49.732  1.00 85.80           C  
ATOM   2546  N   ALA   331       3.852  24.505  48.772  1.00 80.28           N  
ATOM   2547  CA  ALA   331       3.209  25.674  48.183  1.00 78.76           C  
ATOM   2548  C   ALA   331       1.684  25.571  48.081  1.00 78.45           C  
ATOM   2549  O   ALA   331       0.999  26.580  47.873  1.00 78.42           O  
ATOM   2550  CB  ALA   331       3.800  25.963  46.829  1.00 78.23           C  
ATOM   2551  N   ASP   332       1.146  24.365  48.242  1.00 77.36           N  
ATOM   2552  CA  ASP   332      -0.298  24.186  48.148  1.00 75.44           C  
ATOM   2553  C   ASP   332      -1.019  24.803  49.328  1.00 74.34           C  
ATOM   2554  O   ASP   332      -2.213  25.116  49.243  1.00 74.41           O  
ATOM   2555  CB  ASP   332      -0.653  22.702  48.034  1.00 74.57           C  
ATOM   2556  CG  ASP   332      -0.469  22.162  46.622  1.00 75.05           C  
ATOM   2557  OD1 ASP   332      -0.159  22.970  45.707  1.00 73.23           O  
ATOM   2558  OD2 ASP   332      -0.645  20.933  46.431  1.00 73.69           O  
ATOM   2559  N   ALA   333      -0.289  24.983  50.424  1.00 72.21           N  
ATOM   2560  CA  ALA   333      -0.862  25.572  51.621  1.00 71.76           C  
ATOM   2561  C   ALA   333      -1.219  27.033  51.378  1.00 70.41           C  
ATOM   2562  O   ALA   333      -2.051  27.615  52.076  1.00 69.75           O  
ATOM   2563  CB  ALA   333       0.114  25.461  52.762  1.00 73.24           C  
ATOM   2564  N   LEU   334      -0.576  27.618  50.379  1.00 68.45           N  
ATOM   2565  CA  LEU   334      -0.824  28.996  50.024  1.00 67.50           C  
ATOM   2566  C   LEU   334      -2.237  29.187  49.540  1.00 67.37           C  
ATOM   2567  O   LEU   334      -2.750  30.298  49.530  1.00 69.17           O  
ATOM   2568  CB  LEU   334       0.107  29.427  48.896  1.00 66.53           C  
ATOM   2569  CG  LEU   334       1.557  29.702  49.266  1.00 65.00           C  
ATOM   2570  CD1 LEU   334       2.364  29.994  48.013  1.00 61.76           C  
ATOM   2571  CD2 LEU   334       1.586  30.876  50.223  1.00 64.01           C  
ATOM   2572  N   ARG   335      -2.875  28.107  49.124  1.00 66.58           N  
ATOM   2573  CA  ARG   335      -4.210  28.243  48.588  1.00 64.78           C  
ATOM   2574  C   ARG   335      -5.225  27.398  49.319  1.00 64.81           C  
ATOM   2575  O   ARG   335      -6.430  27.566  49.159  1.00 64.78           O  
ATOM   2576  CB  ARG   335      -4.192  27.905  47.128  1.00 62.96           C  
ATOM   2577  N   VAL   336      -4.737  26.477  50.124  1.00 64.46           N  
ATOM   2578  CA  VAL   336      -5.622  25.653  50.891  1.00 64.79           C  
ATOM   2579  C   VAL   336      -5.602  26.124  52.346  1.00 66.07           C  
ATOM   2580  O   VAL   336      -6.460  25.745  53.143  1.00 66.01           O  
ATOM   2581  CB  VAL   336      -5.197  24.194  50.775  1.00 65.47           C  
ATOM   2582  CG1 VAL   336      -5.638  23.411  52.002  1.00 66.52           C  
ATOM   2583  CG2 VAL   336      -5.799  23.604  49.519  1.00 64.80           C  
ATOM   2584  N   GLY   337      -4.621  26.961  52.686  1.00 66.62           N  
ATOM   2585  CA  GLY   337      -4.520  27.473  54.044  1.00 65.36           C  
ATOM   2586  C   GLY   337      -3.439  26.816  54.888  1.00 64.29           C  
ATOM   2587  O   GLY   337      -3.198  25.612  54.786  1.00 64.43           O  
ATOM   2588  N   PHE   338      -2.809  27.604  55.749  1.00 62.48           N  
ATOM   2589  CA  PHE   338      -1.731  27.112  56.587  1.00 61.70           C  
ATOM   2590  C   PHE   338      -2.143  26.124  57.659  1.00 62.63           C  
ATOM   2591  O   PHE   338      -3.282  26.112  58.110  1.00 62.38           O  
ATOM   2592  CB  PHE   338      -1.028  28.284  57.237  1.00 60.40           C  
ATOM   2593  CG  PHE   338      -0.640  29.349  56.267  1.00 60.55           C  
ATOM   2594  CD1 PHE   338      -0.650  30.684  56.638  1.00 59.19           C  
ATOM   2595  CD2 PHE   338      -0.289  29.022  54.968  1.00 59.51           C  
ATOM   2596  CE1 PHE   338      -0.324  31.667  55.727  1.00 58.74           C  
ATOM   2597  CE2 PHE   338       0.040  30.005  54.056  1.00 58.01           C  
ATOM   2598  CZ  PHE   338       0.020  31.324  54.433  1.00 57.93           C  
ATOM   2599  N   TYR   339      -1.181  25.300  58.064  1.00 62.84           N  
ATOM   2600  CA  TYR   339      -1.387  24.304  59.103  1.00 62.87           C  
ATOM   2601  C   TYR   339      -1.874  24.943  60.403  1.00 63.24           C  
ATOM   2602  O   TYR   339      -2.826  24.471  61.006  1.00 62.89           O  
ATOM   2603  CB  TYR   339      -0.087  23.560  59.377  1.00 61.85           C  
ATOM   2604  CG  TYR   339      -0.212  22.537  60.464  1.00 60.92           C  
ATOM   2605  CD1 TYR   339      -0.963  21.392  60.270  1.00 61.61           C  
ATOM   2606  CD2 TYR   339       0.411  22.719  61.698  1.00 62.51           C  
ATOM   2607  CE1 TYR   339      -1.102  20.444  61.275  1.00 63.04           C  
ATOM   2608  CE2 TYR   339       0.283  21.778  62.712  1.00 62.88           C  
ATOM   2609  CZ  TYR   339      -0.481  20.642  62.489  1.00 63.39           C  
ATOM   2610  OH  TYR   339      -0.652  19.706  63.480  1.00 66.50           O  
ATOM   2611  N   ARG   340      -1.197  25.997  60.845  1.00 64.30           N  
ATOM   2612  CA  ARG   340      -1.583  26.685  62.071  1.00 66.36           C  
ATOM   2613  C   ARG   340      -1.273  28.167  61.950  1.00 66.52           C  
ATOM   2614  O   ARG   340      -0.112  28.559  62.007  1.00 67.27           O  
ATOM   2615  CB  ARG   340      -0.845  26.126  63.287  1.00 66.95           C  
ATOM   2616  CG  ARG   340      -1.298  26.826  64.529  1.00 71.43           C  
ATOM   2617  CD  ARG   340      -0.500  26.520  65.760  1.00 76.04           C  
ATOM   2618  NE  ARG   340      -0.982  27.383  66.835  1.00 81.26           N  
ATOM   2619  CZ  ARG   340      -0.518  27.372  68.079  1.00 83.99           C  
ATOM   2620  NH1 ARG   340       0.455  26.537  68.425  1.00 85.05           N  
ATOM   2621  NH2 ARG   340      -1.035  28.194  68.981  1.00 85.76           N  
ATOM   2622  N   ALA   341      -2.315  28.989  61.819  1.00 66.67           N  
ATOM   2623  CA  ALA   341      -2.146  30.433  61.644  1.00 65.57           C  
ATOM   2624  C   ALA   341      -2.135  31.319  62.895  1.00 65.62           C  
ATOM   2625  O   ALA   341      -2.280  30.852  64.032  1.00 65.57           O  
ATOM   2626  CB  ALA   341      -3.178  30.947  60.657  1.00 65.25           C  
ATOM   2627  N   GLN   342      -1.968  32.616  62.659  1.00 65.20           N  
ATOM   2628  CA  GLN   342      -1.876  33.610  63.722  1.00 64.89           C  
ATOM   2629  C   GLN   342      -1.941  34.975  63.068  1.00 63.30           C  
ATOM   2630  O   GLN   342      -1.803  35.091  61.853  1.00 61.88           O  
ATOM   2631  CB  GLN   342      -0.521  33.481  64.428  1.00 67.97           C  
ATOM   2632  CG  GLN   342       0.647  33.354  63.433  1.00 70.81           C  
ATOM   2633  CD  GLN   342       1.999  33.825  63.968  1.00 74.50           C  
ATOM   2634  OE1 GLN   342       2.528  33.286  64.954  1.00 76.38           O  
ATOM   2635  NE2 GLN   342       2.574  34.834  63.302  1.00 74.60           N  
ATOM   2636  N   GLU   343      -2.148  36.012  63.872  1.00 62.50           N  
ATOM   2637  CA  GLU   343      -2.179  37.373  63.339  1.00 61.34           C  
ATOM   2638  C   GLU   343      -0.776  37.547  62.772  1.00 59.29           C  
ATOM   2639  O   GLU   343       0.200  37.224  63.437  1.00 58.93           O  
ATOM   2640  CB  GLU   343      -2.417  38.366  64.471  1.00 62.57           C  
ATOM   2641  CG  GLU   343      -2.841  39.735  64.019  1.00 64.18           C  
ATOM   2642  CD  GLU   343      -3.261  40.597  65.192  1.00 65.96           C  
ATOM   2643  OE1 GLU   343      -3.604  40.012  66.248  1.00 66.64           O  
ATOM   2644  OE2 GLU   343      -3.265  41.847  65.055  1.00 66.30           O  
ATOM   2645  N   THR   344      -0.664  38.051  61.554  1.00 56.61           N  
ATOM   2646  CA  THR   344       0.648  38.177  60.944  1.00 53.90           C  
ATOM   2647  C   THR   344       0.938  39.539  60.334  1.00 53.83           C  
ATOM   2648  O   THR   344       0.088  40.109  59.640  1.00 52.77           O  
ATOM   2649  CB  THR   344       0.820  37.085  59.857  1.00 52.39           C  
ATOM   2650  OG1 THR   344       0.655  35.792  60.449  1.00 51.47           O  
ATOM   2651  CG2 THR   344       2.183  37.162  59.218  1.00 52.21           C  
ATOM   2652  N   ALA   345       2.138  40.060  60.607  1.00 53.69           N  
ATOM   2653  CA  ALA   345       2.558  41.347  60.049  1.00 54.53           C  
ATOM   2654  C   ALA   345       3.881  41.194  59.246  1.00 55.31           C  
ATOM   2655  O   ALA   345       4.909  40.764  59.771  1.00 55.22           O  
ATOM   2656  CB  ALA   345       2.707  42.386  61.165  1.00 50.73           C  
ATOM   2657  N   LEU   346       3.833  41.534  57.966  1.00 54.57           N  
ATOM   2658  CA  LEU   346       4.991  41.428  57.106  1.00 54.74           C  
ATOM   2659  C   LEU   346       5.260  42.771  56.501  1.00 56.30           C  
ATOM   2660  O   LEU   346       4.344  43.482  56.115  1.00 55.24           O  
ATOM   2661  CB  LEU   346       4.733  40.452  55.962  1.00 54.66           C  
ATOM   2662  CG  LEU   346       3.997  39.151  56.277  1.00 54.58           C  
ATOM   2663  CD1 LEU   346       3.827  38.410  54.973  1.00 54.37           C  
ATOM   2664  CD2 LEU   346       4.756  38.307  57.298  1.00 52.86           C  
ATOM   2665  N   ALA   347       6.532  43.120  56.414  1.00 60.46           N  
ATOM   2666  CA  ALA   347       6.919  44.376  55.812  1.00 63.30           C  
ATOM   2667  C   ALA   347       7.773  44.004  54.626  1.00 65.99           C  
ATOM   2668  O   ALA   347       8.550  43.055  54.685  1.00 66.09           O  
ATOM   2669  CB  ALA   347       7.712  45.204  56.785  1.00 62.72           C  
ATOM   2670  N   LEU   348       7.605  44.733  53.537  1.00 69.75           N  
ATOM   2671  CA  LEU   348       8.388  44.493  52.345  1.00 73.27           C  
ATOM   2672  C   LEU   348       9.425  45.598  52.249  1.00 76.28           C  
ATOM   2673  O   LEU   348       9.079  46.774  52.340  1.00 77.09           O  
ATOM   2674  CB  LEU   348       7.488  44.501  51.105  1.00 72.63           C  
ATOM   2675  CG  LEU   348       8.164  44.752  49.756  1.00 72.07           C  
ATOM   2676  CD1 LEU   348       7.439  44.008  48.661  1.00 72.10           C  
ATOM   2677  CD2 LEU   348       8.178  46.255  49.469  1.00 73.08           C  
ATOM   2678  N   LEU   349      10.692  45.211  52.089  1.00 80.36           N  
ATOM   2679  CA  LEU   349      11.800  46.161  51.948  1.00 84.04           C  
ATOM   2680  C   LEU   349      12.382  45.977  50.559  1.00 86.93           C  
ATOM   2681  O   LEU   349      13.096  45.008  50.253  1.00 87.77           O  
ATOM   2682  CB  LEU   349      12.885  45.930  52.997  1.00 82.81           C  
ATOM   2683  CG  LEU   349      13.916  47.051  53.179  1.00 81.98           C  
ATOM   2684  CD1 LEU   349      14.826  46.645  54.316  1.00 82.06           C  
ATOM   2685  CD2 LEU   349      14.735  47.285  51.920  1.00 81.21           C  
ATOM   2686  N   ARG   350      12.050  46.955  49.744  1.00 90.06           N  
ATOM   2687  CA  ARG   350      12.362  47.071  48.349  1.00 93.96           C  
ATOM   2688  C   ARG   350      13.733  47.732  48.103  1.00 95.24           C  
ATOM   2689  O   ARG   350      13.850  48.951  48.188  1.00 95.36           O  
ATOM   2690  CB  ARG   350      11.304  48.000  47.798  1.00 96.66           C  
ATOM   2691  CG  ARG   350      11.495  49.406  48.486  1.00101.76           C  
ATOM   2692  CD  ARG   350      10.590  49.798  49.693  1.00103.10           C  
ATOM   2693  NE  ARG   350       9.486  50.645  49.232  1.00105.61           N  
ATOM   2694  CZ  ARG   350       9.581  51.934  48.897  1.00106.47           C  
ATOM   2695  NH1 ARG   350      10.744  52.556  48.989  1.00106.98           N  
ATOM   2696  NH2 ARG   350       8.518  52.596  48.422  1.00106.24           N  
ATOM   2697  N   LEU   351      14.772  46.986  47.781  1.00 96.20           N  
ATOM   2698  CA  LEU   351      16.052  47.640  47.574  1.00 97.27           C  
ATOM   2699  C   LEU   351      16.377  47.802  46.092  1.00 98.60           C  
ATOM   2700  O   LEU   351      17.488  48.177  45.718  1.00 99.70           O  
ATOM   2701  CB  LEU   351      17.128  46.840  48.280  1.00 96.71           C  
ATOM   2702  CG  LEU   351      17.973  47.559  49.313  1.00 96.99           C  
ATOM   2703  CD1 LEU   351      18.417  46.551  50.364  1.00 95.95           C  
ATOM   2704  CD2 LEU   351      19.154  48.220  48.605  1.00 97.39           C  
ATOM   2705  N   ASP   352      15.377  47.541  45.256  1.00 99.78           N  
ATOM   2706  CA  ASP   352      15.518  47.618  43.820  1.00100.88           C  
ATOM   2707  C   ASP   352      15.245  48.992  43.210  1.00101.16           C  
ATOM   2708  O   ASP   352      16.144  49.594  42.620  1.00101.17           O  
ATOM   2709  CB  ASP   352      14.631  46.551  43.149  1.00101.28           C  
ATOM   2710  N   GLY   353      14.038  49.521  43.346  1.00101.29           N  
ATOM   2711  CA  GLY   353      13.770  50.777  42.704  1.00101.77           C  
ATOM   2712  C   GLY   353      12.365  51.307  42.835  1.00103.52           C  
ATOM   2713  O   GLY   353      12.059  52.375  42.223  1.00104.04           O  
ATOM   2714  N   ALA   354      11.433  50.548  43.432  1.00104.23           N  
ATOM   2715  CA  ALA   354      10.122  51.237  43.436  1.00105.23           C  
ATOM   2716  C   ALA   354       9.317  51.465  44.684  1.00105.23           C  
ATOM   2717  O   ALA   354       9.797  51.996  45.764  1.00106.68           O  
ATOM   2718  CB  ALA   354       9.247  50.850  42.267  1.00104.97           C  
ATOM   2719  N   GLN   355       8.039  51.034  44.588  1.00105.18           N  
ATOM   2720  CA  GLN   355       7.230  51.266  45.690  1.00103.76           C  
ATOM   2721  C   GLN   355       6.644  50.033  46.286  1.00102.50           C  
ATOM   2722  O   GLN   355       7.300  49.476  47.191  1.00104.04           O  
ATOM   2723  CB  GLN   355       6.271  52.454  45.430  1.00102.82           C  
ATOM   2724  N   GLY   356       5.533  49.482  45.854  1.00 99.31           N  
ATOM   2725  CA  GLY   356       5.135  48.337  46.613  1.00 94.67           C  
ATOM   2726  C   GLY   356       5.205  46.878  46.347  1.00 91.77           C  
ATOM   2727  O   GLY   356       6.062  46.223  45.659  1.00 92.95           O  
ATOM   2728  N   TRP   357       4.295  46.331  47.110  1.00 88.45           N  
ATOM   2729  CA  TRP   357       4.070  44.946  47.004  1.00 84.96           C  
ATOM   2730  C   TRP   357       3.775  44.540  45.507  1.00 84.34           C  
ATOM   2731  O   TRP   357       2.870  45.085  44.898  1.00 83.43           O  
ATOM   2732  CB  TRP   357       2.898  44.641  47.927  1.00 80.64           C  
ATOM   2733  CG  TRP   357       3.415  44.501  49.266  1.00 75.95           C  
ATOM   2734  CD1 TRP   357       3.373  45.378  50.319  1.00 75.26           C  
ATOM   2735  CD2 TRP   357       3.918  43.303  49.749  1.00 73.93           C  
ATOM   2736  NE1 TRP   357       3.801  44.740  51.462  1.00 73.89           N  
ATOM   2737  CE2 TRP   357       4.146  43.456  51.128  1.00 72.85           C  
ATOM   2738  CE3 TRP   357       4.192  42.081  49.138  1.00 73.29           C  
ATOM   2739  CZ2 TRP   357       4.634  42.417  51.909  1.00 71.22           C  
ATOM   2740  CZ3 TRP   357       4.669  41.054  49.898  1.00 73.42           C  
ATOM   2741  CH2 TRP   357       4.888  41.220  51.278  1.00 71.91           C  
ATOM   2742  N   PRO   358       4.555  43.599  44.879  1.00 83.85           N  
ATOM   2743  CA  PRO   358       4.178  43.251  43.483  1.00 83.32           C  
ATOM   2744  C   PRO   358       2.817  42.550  43.464  1.00 82.44           C  
ATOM   2745  O   PRO   358       2.635  41.525  44.114  1.00 80.88           O  
ATOM   2746  CB  PRO   358       5.290  42.288  43.023  1.00 83.67           C  
ATOM   2747  CG  PRO   358       6.463  42.786  43.779  1.00 83.65           C  
ATOM   2748  CD  PRO   358       5.885  43.023  45.172  1.00 83.90           C  
ATOM   2749  N   GLU   359       1.876  43.137  42.730  1.00 81.62           N  
ATOM   2750  CA  GLU   359       0.517  42.624  42.624  1.00 81.43           C  
ATOM   2751  C   GLU   359       0.384  41.119  42.848  1.00 79.12           C  
ATOM   2752  O   GLU   359      -0.442  40.695  43.647  1.00 78.89           O  
ATOM   2753  CB  GLU   359      -0.084  42.987  41.258  1.00 83.94           C  
ATOM   2754  CG  GLU   359      -1.484  43.618  41.319  1.00 88.17           C  
ATOM   2755  CD  GLU   359      -1.458  45.142  41.524  1.00 91.26           C  
ATOM   2756  OE1 GLU   359      -0.634  45.638  42.329  1.00 92.64           O  
ATOM   2757  OE2 GLU   359      -2.275  45.846  40.886  1.00 91.99           O  
ATOM   2758  N   PHE   360       1.188  40.307  42.163  1.00 76.68           N  
ATOM   2759  CA  PHE   360       1.048  38.869  42.349  1.00 75.12           C  
ATOM   2760  C   PHE   360       1.481  38.335  43.714  1.00 73.72           C  
ATOM   2761  O   PHE   360       1.085  37.231  44.102  1.00 73.90           O  
ATOM   2762  CB  PHE   360       1.722  38.075  41.212  1.00 74.23           C  
ATOM   2763  CG  PHE   360       3.163  38.382  41.007  1.00 74.14           C  
ATOM   2764  CD1 PHE   360       3.551  39.472  40.242  1.00 76.28           C  
ATOM   2765  CD2 PHE   360       4.141  37.555  41.540  1.00 74.67           C  
ATOM   2766  CE1 PHE   360       4.912  39.735  40.004  1.00 76.47           C  
ATOM   2767  CE2 PHE   360       5.493  37.805  41.314  1.00 74.78           C  
ATOM   2768  CZ  PHE   360       5.880  38.897  40.543  1.00 74.49           C  
ATOM   2769  N   LEU   361       2.271  39.117  44.448  1.00 71.70           N  
ATOM   2770  CA  LEU   361       2.702  38.721  45.787  1.00 69.76           C  
ATOM   2771  C   LEU   361       1.597  39.093  46.799  1.00 68.49           C  
ATOM   2772  O   LEU   361       1.280  38.318  47.716  1.00 68.53           O  
ATOM   2773  CB  LEU   361       4.036  39.394  46.131  1.00 70.03           C  
ATOM   2774  CG  LEU   361       5.244  38.756  45.419  1.00 70.77           C  
ATOM   2775  CD1 LEU   361       6.454  39.634  45.580  1.00 70.87           C  
ATOM   2776  CD2 LEU   361       5.518  37.356  45.972  1.00 69.38           C  
ATOM   2777  N   ARG   362       0.996  40.266  46.605  1.00 65.18           N  
ATOM   2778  CA  ARG   362      -0.097  40.729  47.453  1.00 63.12           C  
ATOM   2779  C   ARG   362      -1.265  39.715  47.361  1.00 62.00           C  
ATOM   2780  O   ARG   362      -1.849  39.309  48.377  1.00 60.91           O  
ATOM   2781  CB  ARG   362      -0.535  42.120  46.982  1.00 61.86           C  
ATOM   2782  CG  ARG   362      -1.712  42.717  47.716  1.00 61.96           C  
ATOM   2783  CD  ARG   362      -2.222  43.940  46.978  1.00 63.92           C  
ATOM   2784  NE  ARG   362      -1.195  44.977  46.840  1.00 66.76           N  
ATOM   2785  CZ  ARG   362      -0.951  45.649  45.713  1.00 67.73           C  
ATOM   2786  NH1 ARG   362      -1.654  45.392  44.608  1.00 64.71           N  
ATOM   2787  NH2 ARG   362      -0.018  46.598  45.697  1.00 66.28           N  
ATOM   2788  N   ARG   363      -1.568  39.292  46.136  1.00 59.81           N  
ATOM   2789  CA  ARG   363      -2.631  38.329  45.863  1.00 59.48           C  
ATOM   2790  C   ARG   363      -2.433  37.003  46.619  1.00 59.25           C  
ATOM   2791  O   ARG   363      -3.341  36.530  47.330  1.00 58.56           O  
ATOM   2792  CB  ARG   363      -2.696  38.023  44.352  1.00 60.89           C  
ATOM   2793  CG  ARG   363      -4.066  38.203  43.685  1.00 64.51           C  
ATOM   2794  CD  ARG   363      -4.328  37.220  42.502  1.00 68.23           C  
ATOM   2795  NE  ARG   363      -3.397  37.355  41.371  1.00 72.07           N  
ATOM   2796  CZ  ARG   363      -2.158  36.848  41.319  1.00 73.24           C  
ATOM   2797  NH1 ARG   363      -1.651  36.139  42.336  1.00 72.33           N  
ATOM   2798  NH2 ARG   363      -1.404  37.079  40.249  1.00 71.98           N  
ATOM   2799  N   ALA   364      -1.254  36.397  46.467  1.00 56.54           N  
ATOM   2800  CA  ALA   364      -1.015  35.110  47.110  1.00 54.65           C  
ATOM   2801  C   ALA   364      -1.153  35.200  48.615  1.00 53.48           C  
ATOM   2802  O   ALA   364      -1.774  34.348  49.250  1.00 51.50           O  
ATOM   2803  CB  ALA   364       0.361  34.571  46.733  1.00 54.14           C  
ATOM   2804  N   LEU   365      -0.568  36.246  49.179  1.00 52.92           N  
ATOM   2805  CA  LEU   365      -0.625  36.452  50.605  1.00 52.01           C  
ATOM   2806  C   LEU   365      -2.068  36.660  51.080  1.00 51.54           C  
ATOM   2807  O   LEU   365      -2.523  35.955  51.986  1.00 48.93           O  
ATOM   2808  CB  LEU   365       0.270  37.641  50.977  1.00 52.84           C  
ATOM   2809  CG  LEU   365       1.779  37.436  50.757  1.00 51.97           C  
ATOM   2810  CD1 LEU   365       2.499  38.700  51.212  1.00 50.86           C  
ATOM   2811  CD2 LEU   365       2.299  36.205  51.532  1.00 48.79           C  
ATOM   2812  N   LEU   366      -2.786  37.601  50.453  1.00 52.27           N  
ATOM   2813  CA  LEU   366      -4.187  37.900  50.812  1.00 53.19           C  
ATOM   2814  C   LEU   366      -5.049  36.684  50.700  1.00 54.43           C  
ATOM   2815  O   LEU   366      -5.990  36.454  51.462  1.00 54.27           O  
ATOM   2816  CB  LEU   366      -4.782  38.972  49.903  1.00 49.80           C  
ATOM   2817  CG  LEU   366      -4.097  40.310  50.135  1.00 50.24           C  
ATOM   2818  CD1 LEU   366      -4.751  41.377  49.288  1.00 47.66           C  
ATOM   2819  CD2 LEU   366      -4.150  40.648  51.622  1.00 47.10           C  
ATOM   2820  N   ARG   367      -4.719  35.891  49.719  1.00 56.43           N  
ATOM   2821  CA  ARG   367      -5.479  34.720  49.535  1.00 58.74           C  
ATOM   2822  C   ARG   367      -5.095  33.624  50.499  1.00 58.78           C  
ATOM   2823  O   ARG   367      -5.946  32.898  51.004  1.00 58.29           O  
ATOM   2824  CB  ARG   367      -5.288  34.266  48.141  1.00 63.80           C  
ATOM   2825  CG  ARG   367      -6.427  33.468  47.735  1.00 70.46           C  
ATOM   2826  CD  ARG   367      -6.042  32.818  46.520  1.00 75.79           C  
ATOM   2827  NE  ARG   367      -5.764  33.833  45.523  1.00 81.56           N  
ATOM   2828  CZ  ARG   367      -5.668  33.552  44.238  1.00 83.54           C  
ATOM   2829  NH1 ARG   367      -5.827  32.289  43.859  1.00 83.52           N  
ATOM   2830  NH2 ARG   367      -5.449  34.516  43.350  1.00 83.58           N  
ATOM   2831  N   ALA   368      -3.800  33.496  50.757  1.00 58.48           N  
ATOM   2832  CA  ALA   368      -3.341  32.473  51.677  1.00 56.99           C  
ATOM   2833  C   ALA   368      -3.985  32.690  53.041  1.00 56.60           C  
ATOM   2834  O   ALA   368      -4.560  31.764  53.625  1.00 53.99           O  
ATOM   2835  CB  ALA   368      -1.828  32.503  51.790  1.00 55.43           C  
ATOM   2836  N   PHE   369      -3.913  33.915  53.549  1.00 56.73           N  
ATOM   2837  CA  PHE   369      -4.508  34.166  54.856  1.00 57.88           C  
ATOM   2838  C   PHE   369      -6.007  34.064  54.834  1.00 57.49           C  
ATOM   2839  O   PHE   369      -6.598  33.692  55.833  1.00 57.23           O  
ATOM   2840  CB  PHE   369      -4.081  35.518  55.414  1.00 58.82           C  
ATOM   2841  CG  PHE   369      -2.689  35.515  55.940  1.00 61.44           C  
ATOM   2842  CD1 PHE   369      -1.603  35.490  55.065  1.00 61.63           C  
ATOM   2843  CD2 PHE   369      -2.456  35.435  57.309  1.00 62.48           C  
ATOM   2844  CE1 PHE   369      -0.309  35.376  55.540  1.00 62.22           C  
ATOM   2845  CE2 PHE   369      -1.162  35.318  57.797  1.00 64.00           C  
ATOM   2846  CZ  PHE   369      -0.084  35.288  56.909  1.00 63.33           C  
ATOM   2847  N   GLY   370      -6.618  34.391  53.697  1.00 57.31           N  
ATOM   2848  CA  GLY   370      -8.060  34.285  53.592  1.00 56.52           C  
ATOM   2849  C   GLY   370      -8.456  32.831  53.780  1.00 57.41           C  
ATOM   2850  O   GLY   370      -9.400  32.514  54.513  1.00 58.60           O  
ATOM   2851  N   ALA   371      -7.711  31.931  53.149  1.00 56.71           N  
ATOM   2852  CA  ALA   371      -8.013  30.503  53.247  1.00 56.52           C  
ATOM   2853  C   ALA   371      -7.740  29.949  54.635  1.00 55.56           C  
ATOM   2854  O   ALA   371      -8.270  28.907  55.020  1.00 55.91           O  
ATOM   2855  CB  ALA   371      -7.206  29.720  52.197  1.00 55.62           C  
ATOM   2856  N   SER   372      -6.898  30.650  55.380  1.00 56.44           N  
ATOM   2857  CA  SER   372      -6.534  30.237  56.727  1.00 55.52           C  
ATOM   2858  C   SER   372      -7.477  30.867  57.739  1.00 54.67           C  
ATOM   2859  O   SER   372      -7.694  30.328  58.818  1.00 56.25           O  
ATOM   2860  CB  SER   372      -5.094  30.660  57.019  1.00 57.69           C  
ATOM   2861  OG  SER   372      -4.201  30.111  56.058  1.00 58.74           O  
ATOM   2862  N   GLY   373      -8.057  32.002  57.377  1.00 53.05           N  
ATOM   2863  CA  GLY   373      -8.966  32.673  58.281  1.00 51.55           C  
ATOM   2864  C   GLY   373      -8.183  33.413  59.345  1.00 49.80           C  
ATOM   2865  O   GLY   373      -8.461  33.284  60.540  1.00 51.12           O  
ATOM   2866  N   ALA   374      -7.212  34.203  58.905  1.00 45.58           N  
ATOM   2867  CA  ALA   374      -6.372  34.929  59.819  1.00 43.74           C  
ATOM   2868  C   ALA   374      -6.066  36.331  59.336  1.00 44.12           C  
ATOM   2869  O   ALA   374      -6.093  36.619  58.137  1.00 39.91           O  
ATOM   2870  CB  ALA   374      -5.092  34.163  60.047  1.00 43.55           C  
ATOM   2871  N   SER   375      -5.770  37.194  60.302  1.00 44.81           N  
ATOM   2872  CA  SER   375      -5.476  38.588  60.046  1.00 48.94           C  
ATOM   2873  C   SER   375      -4.039  38.777  59.579  1.00 49.80           C  
ATOM   2874  O   SER   375      -3.107  38.224  60.165  1.00 50.45           O  
ATOM   2875  CB  SER   375      -5.716  39.388  61.323  1.00 50.97           C  
ATOM   2876  OG  SER   375      -6.877  38.897  61.969  1.00 56.08           O  
ATOM   2877  N   LEU   376      -3.882  39.578  58.531  1.00 49.83           N  
ATOM   2878  CA  LEU   376      -2.594  39.868  57.952  1.00 51.97           C  
ATOM   2879  C   LEU   376      -2.426  41.345  57.679  1.00 52.80           C  
ATOM   2880  O   LEU   376      -3.380  42.015  57.293  1.00 53.63           O  
ATOM   2881  CB  LEU   376      -2.440  39.135  56.623  1.00 55.03           C  
ATOM   2882  CG  LEU   376      -1.167  39.516  55.853  1.00 56.99           C  
ATOM   2883  CD1 LEU   376       0.013  38.851  56.535  1.00 55.71           C  
ATOM   2884  CD2 LEU   376      -1.254  39.096  54.395  1.00 56.77           C  
ATOM   2885  N   ARG   377      -1.213  41.854  57.872  1.00 53.29           N  
ATOM   2886  CA  ARG   377      -0.934  43.248  57.557  1.00 54.93           C  
ATOM   2887  C   ARG   377       0.223  43.263  56.586  1.00 53.45           C  
ATOM   2888  O   ARG   377       1.235  42.658  56.849  1.00 53.65           O  
ATOM   2889  CB  ARG   377      -0.572  44.053  58.800  1.00 56.22           C  
ATOM   2890  CG  ARG   377      -1.758  44.486  59.625  1.00 60.28           C  
ATOM   2891  CD  ARG   377      -1.266  45.202  60.861  1.00 65.36           C  
ATOM   2892  NE  ARG   377      -2.328  45.801  61.662  1.00 69.05           N  
ATOM   2893  CZ  ARG   377      -2.106  46.706  62.612  1.00 72.24           C  
ATOM   2894  NH1 ARG   377      -0.864  47.101  62.862  1.00 73.53           N  
ATOM   2895  NH2 ARG   377      -3.116  47.216  63.310  1.00 73.11           N  
ATOM   2896  N   LEU   378       0.056  43.941  55.458  1.00 53.65           N  
ATOM   2897  CA  LEU   378       1.102  44.038  54.450  1.00 53.25           C  
ATOM   2898  C   LEU   378       1.775  45.402  54.512  1.00 52.89           C  
ATOM   2899  O   LEU   378       1.424  46.325  53.785  1.00 51.49           O  
ATOM   2900  CB  LEU   378       0.513  43.792  53.058  1.00 53.19           C  
ATOM   2901  CG  LEU   378       1.009  42.538  52.327  1.00 53.58           C  
ATOM   2902  CD1 LEU   378       1.225  41.401  53.299  1.00 53.98           C  
ATOM   2903  CD2 LEU   378       0.007  42.146  51.272  1.00 54.10           C  
ATOM   2904  N   HIS   379       2.750  45.510  55.404  1.00 54.02           N  
ATOM   2905  CA  HIS   379       3.499  46.749  55.597  1.00 55.10           C  
ATOM   2906  C   HIS   379       4.432  47.007  54.418  1.00 56.02           C  
ATOM   2907  O   HIS   379       4.548  46.189  53.524  1.00 56.33           O  
ATOM   2908  CB  HIS   379       4.318  46.658  56.890  1.00 51.91           C  
ATOM   2909  CG  HIS   379       3.486  46.596  58.133  1.00 51.99           C  
ATOM   2910  ND1 HIS   379       3.350  47.666  58.992  1.00 50.80           N  
ATOM   2911  CD2 HIS   379       2.751  45.591  58.667  1.00 51.96           C  
ATOM   2912  CE1 HIS   379       2.568  47.320  60.001  1.00 51.49           C  
ATOM   2913  NE2 HIS   379       2.190  46.067  59.827  1.00 50.88           N  
ATOM   2914  N   THR   380       5.086  48.157  54.434  1.00 58.20           N  
ATOM   2915  CA  THR   380       6.041  48.542  53.410  1.00 61.65           C  
ATOM   2916  C   THR   380       7.079  49.474  54.042  1.00 65.35           C  
ATOM   2917  O   THR   380       6.730  50.523  54.583  1.00 66.79           O  
ATOM   2918  CB  THR   380       5.372  49.296  52.264  1.00 61.35           C  
ATOM   2919  OG1 THR   380       4.535  48.407  51.522  1.00 61.64           O  
ATOM   2920  CG2 THR   380       6.426  49.874  51.330  1.00 64.54           C  
ATOM   2921  N   LEU   381       8.355  49.113  53.984  1.00 68.20           N  
ATOM   2922  CA  LEU   381       9.359  49.979  54.575  1.00 70.75           C  
ATOM   2923  C   LEU   381       9.731  51.112  53.640  1.00 74.35           C  
ATOM   2924  O   LEU   381      10.439  50.909  52.660  1.00 75.47           O  
ATOM   2925  CB  LEU   381      10.595  49.172  54.967  1.00 68.81           C  
ATOM   2926  CG  LEU   381      10.455  48.371  56.270  1.00 67.11           C  
ATOM   2927  CD1 LEU   381      11.417  47.215  56.273  1.00 64.80           C  
ATOM   2928  CD2 LEU   381      10.700  49.272  57.465  1.00 65.73           C  
ATOM   2929  N   HIS   382       9.221  52.305  53.938  1.00 79.18           N  
ATOM   2930  CA  HIS   382       9.520  53.490  53.137  1.00 83.84           C  
ATOM   2931  C   HIS   382      10.849  54.066  53.619  1.00 86.36           C  
ATOM   2932  O   HIS   382      11.100  55.273  53.550  1.00 86.56           O  
ATOM   2933  CB  HIS   382       8.416  54.543  53.279  1.00 84.63           C  
ATOM   2934  CG  HIS   382       7.060  54.053  52.882  1.00 87.02           C  
ATOM   2935  ND1 HIS   382       6.098  53.697  53.803  1.00 87.85           N  
ATOM   2936  CD2 HIS   382       6.506  53.851  51.663  1.00 88.30           C  
ATOM   2937  CE1 HIS   382       5.009  53.300  53.169  1.00 88.78           C  
ATOM   2938  NE2 HIS   382       5.230  53.383  51.869  1.00 89.57           N  
ATOM   2939  N   ALA   383      11.692  53.184  54.138  1.00 89.15           N  
ATOM   2940  CA  ALA   383      13.005  53.574  54.610  1.00 91.84           C  
ATOM   2941  C   ALA   383      13.917  53.228  53.460  1.00 93.75           C  
ATOM   2942  O   ALA   383      13.750  52.189  52.821  1.00 93.47           O  
ATOM   2943  CB  ALA   383      13.385  52.775  55.829  1.00 93.33           C  
ATOM   2944  N   HIS   384      14.877  54.098  53.190  1.00 96.22           N  
ATOM   2945  CA  HIS   384      15.800  53.872  52.089  1.00 98.18           C  
ATOM   2946  C   HIS   384      16.596  52.601  52.335  1.00 97.41           C  
ATOM   2947  O   HIS   384      16.378  51.919  53.342  1.00 96.85           O  
ATOM   2948  CB  HIS   384      16.721  55.086  51.946  1.00100.90           C  
ATOM   2949  CG  HIS   384      15.990  56.349  51.601  1.00103.91           C  
ATOM   2950  ND1 HIS   384      15.006  56.883  52.407  1.00104.49           N  
ATOM   2951  CD2 HIS   384      16.070  57.160  50.517  1.00104.73           C  
ATOM   2952  CE1 HIS   384      14.510  57.966  51.834  1.00104.83           C  
ATOM   2953  NE2 HIS   384      15.138  58.156  50.686  1.00104.91           N  
ATOM   2954  N   PRO   385      17.494  52.235  51.398  1.00 97.04           N  
ATOM   2955  CA  PRO   385      18.282  51.020  51.619  1.00 96.77           C  
ATOM   2956  C   PRO   385      18.951  51.220  52.973  1.00 96.28           C  
ATOM   2957  O   PRO   385      18.740  52.248  53.619  1.00 95.78           O  
ATOM   2958  CB  PRO   385      19.289  51.050  50.469  1.00 96.63           C  
ATOM   2959  CG  PRO   385      18.515  51.686  49.365  1.00 96.27           C  
ATOM   2960  CD  PRO   385      17.789  52.818  50.075  1.00 97.05           C  
ATOM   2961  N   SER   386      19.749  50.265  53.422  1.00 95.39           N  
ATOM   2962  CA  SER   386      20.406  50.466  54.702  1.00 95.77           C  
ATOM   2963  C   SER   386      21.328  51.688  54.626  1.00 94.13           C  
ATOM   2964  O   SER   386      22.545  51.549  54.585  1.00 94.15           O  
ATOM   2965  CB  SER   386      21.218  49.230  55.095  1.00 97.84           C  
ATOM   2966  OG  SER   386      21.940  49.466  56.299  1.00 99.03           O  
ATOM   2967  N   GLN   387      20.748  52.883  54.617  1.00 92.28           N  
ATOM   2968  CA  GLN   387      21.545  54.101  54.538  1.00 90.28           C  
ATOM   2969  C   GLN   387      21.216  55.164  55.592  1.00 88.47           C  
ATOM   2970  O   GLN   387      20.457  56.114  55.339  1.00 86.81           O  
ATOM   2971  CB  GLN   387      21.411  54.710  53.150  1.00 90.16           C  
ATOM   2972  CG  GLN   387      21.453  53.688  52.057  1.00 90.14           C  
ATOM   2973  CD  GLN   387      21.724  54.319  50.723  1.00 91.48           C  
ATOM   2974  OE1 GLN   387      21.320  53.798  49.682  1.00 92.20           O  
ATOM   2975  NE2 GLN   387      22.426  55.451  50.739  1.00 91.98           N  
ATOM   2976  N   GLY   388      21.809  54.999  56.769  1.00 86.08           N  
ATOM   2977  CA  GLY   388      21.599  55.948  57.836  1.00 84.79           C  
ATOM   2978  C   GLY   388      21.163  55.283  59.116  1.00 84.07           C  
ATOM   2979  O   GLY   388      20.703  54.144  59.109  1.00 84.15           O  
ATOM   2980  N   LEU   389      21.336  55.980  60.229  1.00 82.60           N  
ATOM   2981  CA  LEU   389      20.898  55.431  61.490  1.00 81.50           C  
ATOM   2982  C   LEU   389      19.380  55.504  61.403  1.00 80.28           C  
ATOM   2983  O   LEU   389      18.666  54.872  62.175  1.00 79.39           O  
ATOM   2984  CB  LEU   389      21.437  56.265  62.658  1.00 82.67           C  
ATOM   2985  CG  LEU   389      22.819  55.850  63.191  1.00 83.07           C  
ATOM   2986  CD1 LEU   389      22.688  54.543  63.955  1.00 83.88           C  
ATOM   2987  CD2 LEU   389      23.815  55.691  62.053  1.00 82.66           C  
ATOM   2988  N   ALA   390      18.902  56.274  60.429  1.00 78.98           N  
ATOM   2989  CA  ALA   390      17.474  56.433  60.193  1.00 77.68           C  
ATOM   2990  C   ALA   390      16.870  55.076  59.822  1.00 77.25           C  
ATOM   2991  O   ALA   390      15.749  54.757  60.237  1.00 77.78           O  
ATOM   2992  CB  ALA   390      17.238  57.436  59.079  1.00 76.68           C  
ATOM   2993  N   PHE   391      17.614  54.291  59.038  1.00 74.91           N  
ATOM   2994  CA  PHE   391      17.179  52.955  58.625  1.00 72.52           C  
ATOM   2995  C   PHE   391      17.006  52.123  59.894  1.00 73.50           C  
ATOM   2996  O   PHE   391      15.972  51.495  60.104  1.00 75.23           O  
ATOM   2997  CB  PHE   391      18.231  52.306  57.724  1.00 68.50           C  
ATOM   2998  CG  PHE   391      17.837  50.951  57.198  1.00 64.58           C  
ATOM   2999  CD1 PHE   391      16.902  50.829  56.175  1.00 64.14           C  
ATOM   3000  CD2 PHE   391      18.389  49.792  57.740  1.00 61.18           C  
ATOM   3001  CE1 PHE   391      16.529  49.574  55.709  1.00 62.48           C  
ATOM   3002  CE2 PHE   391      18.019  48.535  57.282  1.00 57.17           C  
ATOM   3003  CZ  PHE   391      17.098  48.419  56.275  1.00 60.15           C  
ATOM   3004  N   ARG   392      18.031  52.119  60.738  1.00 73.50           N  
ATOM   3005  CA  ARG   392      17.980  51.395  62.001  1.00 73.90           C  
ATOM   3006  C   ARG   392      16.692  51.821  62.726  1.00 74.41           C  
ATOM   3007  O   ARG   392      16.064  51.017  63.420  1.00 74.51           O  
ATOM   3008  CB  ARG   392      19.218  51.762  62.844  1.00 73.67           C  
ATOM   3009  CG  ARG   392      19.276  51.216  64.285  1.00 74.97           C  
ATOM   3010  CD  ARG   392      19.768  49.772  64.351  1.00 76.08           C  
ATOM   3011  NE  ARG   392      19.942  49.281  65.722  1.00 76.87           N  
ATOM   3012  CZ  ARG   392      21.102  49.251  66.378  1.00 77.54           C  
ATOM   3013  NH1 ARG   392      22.204  49.691  65.792  1.00 77.89           N  
ATOM   3014  NH2 ARG   392      21.167  48.753  67.611  1.00 77.04           N  
ATOM   3015  N   GLU   393      16.310  53.089  62.542  1.00 73.97           N  
ATOM   3016  CA  GLU   393      15.130  53.675  63.178  1.00 73.57           C  
ATOM   3017  C   GLU   393      13.833  53.191  62.546  1.00 73.21           C  
ATOM   3018  O   GLU   393      12.904  52.816  63.251  1.00 74.45           O  
ATOM   3019  CB  GLU   393      15.213  55.213  63.118  1.00 74.67           C  
ATOM   3020  CG  GLU   393      14.123  55.986  63.886  1.00 75.44           C  
ATOM   3021  CD  GLU   393      13.875  55.449  65.294  1.00 76.45           C  
ATOM   3022  OE1 GLU   393      14.830  54.941  65.923  1.00 76.72           O  
ATOM   3023  OE2 GLU   393      12.725  55.546  65.777  1.00 75.61           O  
ATOM   3024  N   ALA   394      13.769  53.198  61.220  1.00 71.93           N  
ATOM   3025  CA  ALA   394      12.577  52.736  60.518  1.00 71.04           C  
ATOM   3026  C   ALA   394      12.267  51.281  60.885  1.00 70.73           C  
ATOM   3027  O   ALA   394      11.098  50.876  60.933  1.00 71.78           O  
ATOM   3028  CB  ALA   394      12.776  52.860  59.019  1.00 69.08           C  
ATOM   3029  N   LEU   395      13.321  50.511  61.140  1.00 68.84           N  
ATOM   3030  CA  LEU   395      13.198  49.113  61.499  1.00 68.10           C  
ATOM   3031  C   LEU   395      12.650  48.965  62.897  1.00 67.98           C  
ATOM   3032  O   LEU   395      11.709  48.209  63.120  1.00 68.98           O  
ATOM   3033  CB  LEU   395      14.555  48.414  61.433  1.00 68.67           C  
ATOM   3034  CG  LEU   395      15.317  48.286  60.110  1.00 68.06           C  
ATOM   3035  CD1 LEU   395      16.546  47.435  60.372  1.00 67.35           C  
ATOM   3036  CD2 LEU   395      14.458  47.638  59.033  1.00 67.32           C  
ATOM   3037  N   ARG   396      13.249  49.679  63.843  1.00 68.20           N  
ATOM   3038  CA  ARG   396      12.820  49.621  65.238  1.00 68.08           C  
ATOM   3039  C   ARG   396      11.334  49.948  65.310  1.00 69.44           C  
ATOM   3040  O   ARG   396      10.568  49.292  66.015  1.00 69.34           O  
ATOM   3041  CB  ARG   396      13.602  50.626  66.066  1.00 65.37           C  
ATOM   3042  CG  ARG   396      13.337  50.537  67.552  1.00 63.99           C  
ATOM   3043  CD  ARG   396      13.753  51.830  68.256  1.00 63.64           C  
ATOM   3044  NE  ARG   396      13.033  52.992  67.735  1.00 63.64           N  
ATOM   3045  CZ  ARG   396      11.753  53.260  67.986  1.00 65.07           C  
ATOM   3046  NH1 ARG   396      11.026  52.455  68.766  1.00 63.14           N  
ATOM   3047  NH2 ARG   396      11.189  54.331  67.439  1.00 64.87           N  
ATOM   3048  N   LYS   397      10.941  50.971  64.560  1.00 70.84           N  
ATOM   3049  CA  LYS   397       9.556  51.416  64.493  1.00 72.07           C  
ATOM   3050  C   LYS   397       8.665  50.269  64.002  1.00 71.46           C  
ATOM   3051  O   LYS   397       7.656  49.947  64.620  1.00 71.57           O  
ATOM   3052  CB  LYS   397       9.462  52.622  63.549  1.00 73.71           C  
ATOM   3053  CG  LYS   397       8.128  53.363  63.579  1.00 77.32           C  
ATOM   3054  CD  LYS   397       8.177  54.596  62.677  1.00 79.13           C  
ATOM   3055  CE  LYS   397       6.802  54.934  62.101  1.00 80.43           C  
ATOM   3056  NZ  LYS   397       6.876  55.967  61.015  1.00 80.60           N  
ATOM   3057  N   ALA   398       9.064  49.649  62.895  1.00 71.06           N  
ATOM   3058  CA  ALA   398       8.335  48.532  62.294  1.00 69.23           C  
ATOM   3059  C   ALA   398       8.118  47.336  63.233  1.00 68.53           C  
ATOM   3060  O   ALA   398       7.054  46.719  63.237  1.00 67.92           O  
ATOM   3061  CB  ALA   398       9.066  48.071  61.058  1.00 67.15           C  
ATOM   3062  N   LYS   399       9.134  47.003  64.017  1.00 67.52           N  
ATOM   3063  CA  LYS   399       9.043  45.872  64.922  1.00 66.89           C  
ATOM   3064  C   LYS   399       8.131  46.231  66.074  1.00 67.65           C  
ATOM   3065  O   LYS   399       7.403  45.389  66.604  1.00 67.39           O  
ATOM   3066  CB  LYS   399      10.432  45.532  65.445  1.00 65.46           C  
ATOM   3067  CG  LYS   399      10.641  44.082  65.808  1.00 65.45           C  
ATOM   3068  CD  LYS   399      10.024  43.744  67.130  1.00 66.96           C  
ATOM   3069  CE  LYS   399      10.511  42.392  67.622  1.00 68.58           C  
ATOM   3070  NZ  LYS   399      10.209  41.303  66.663  1.00 70.49           N  
ATOM   3071  N   GLU   400       8.177  47.499  66.454  1.00 68.34           N  
ATOM   3072  CA  GLU   400       7.376  47.996  67.557  1.00 68.69           C  
ATOM   3073  C   GLU   400       5.926  47.962  67.115  1.00 66.99           C  
ATOM   3074  O   GLU   400       5.038  47.610  67.880  1.00 67.27           O  
ATOM   3075  CB  GLU   400       7.795  49.425  67.880  1.00 71.17           C  
ATOM   3076  CG  GLU   400       7.492  49.880  69.288  1.00 75.33           C  
ATOM   3077  CD  GLU   400       8.040  51.266  69.547  1.00 79.00           C  
ATOM   3078  OE1 GLU   400       7.455  52.253  69.032  1.00 78.91           O  
ATOM   3079  OE2 GLU   400       9.073  51.362  70.250  1.00 81.55           O  
ATOM   3080  N   GLU   401       5.703  48.326  65.860  1.00 65.26           N  
ATOM   3081  CA  GLU   401       4.374  48.336  65.284  1.00 63.47           C  
ATOM   3082  C   GLU   401       3.846  46.935  64.992  1.00 60.72           C  
ATOM   3083  O   GLU   401       2.770  46.783  64.439  1.00 60.47           O  
ATOM   3084  CB  GLU   401       4.374  49.164  64.005  1.00 66.24           C  
ATOM   3085  CG  GLU   401       4.370  50.656  64.235  1.00 72.45           C  
ATOM   3086  CD  GLU   401       4.380  51.433  62.931  1.00 78.43           C  
ATOM   3087  OE1 GLU   401       4.260  52.681  62.978  1.00 82.26           O  
ATOM   3088  OE2 GLU   401       4.513  50.799  61.858  1.00 81.15           O  
ATOM   3089  N   GLY   402       4.608  45.909  65.349  1.00 59.20           N  
ATOM   3090  CA  GLY   402       4.150  44.545  65.121  1.00 55.54           C  
ATOM   3091  C   GLY   402       4.650  43.728  63.934  1.00 51.64           C  
ATOM   3092  O   GLY   402       4.179  42.613  63.745  1.00 49.52           O  
ATOM   3093  N   VAL   403       5.576  44.246  63.134  1.00 49.33           N  
ATOM   3094  CA  VAL   403       6.083  43.462  62.017  1.00 47.55           C  
ATOM   3095  C   VAL   403       6.810  42.258  62.589  1.00 48.03           C  
ATOM   3096  O   VAL   403       7.432  42.346  63.642  1.00 50.13           O  
ATOM   3097  CB  VAL   403       7.025  44.269  61.144  1.00 46.21           C  
ATOM   3098  CG1 VAL   403       7.603  43.379  60.085  1.00 48.28           C  
ATOM   3099  CG2 VAL   403       6.269  45.413  60.482  1.00 43.87           C  
ATOM   3100  N   GLN   404       6.716  41.123  61.909  1.00 48.46           N  
ATOM   3101  CA  GLN   404       7.325  39.892  62.389  1.00 47.90           C  
ATOM   3102  C   GLN   404       8.401  39.325  61.467  1.00 49.46           C  
ATOM   3103  O   GLN   404       9.112  38.389  61.828  1.00 50.28           O  
ATOM   3104  CB  GLN   404       6.241  38.840  62.586  1.00 47.42           C  
ATOM   3105  CG  GLN   404       4.989  39.362  63.281  1.00 49.38           C  
ATOM   3106  CD  GLN   404       3.879  38.315  63.362  1.00 51.56           C  
ATOM   3107  OE1 GLN   404       3.423  37.765  62.340  1.00 52.27           O  
ATOM   3108  NE2 GLN   404       3.446  38.028  64.578  1.00 48.42           N  
ATOM   3109  N   ALA   405       8.519  39.875  60.270  1.00 50.59           N  
ATOM   3110  CA  ALA   405       9.515  39.387  59.334  1.00 53.14           C  
ATOM   3111  C   ALA   405       9.501  40.323  58.174  1.00 54.84           C  
ATOM   3112  O   ALA   405       8.491  40.952  57.900  1.00 55.84           O  
ATOM   3113  CB  ALA   405       9.182  37.989  58.873  1.00 53.11           C  
ATOM   3114  N   VAL   406      10.625  40.419  57.486  1.00 56.75           N  
ATOM   3115  CA  VAL   406      10.725  41.317  56.358  1.00 57.07           C  
ATOM   3116  C   VAL   406      11.093  40.546  55.101  1.00 59.00           C  
ATOM   3117  O   VAL   406      11.885  39.610  55.138  1.00 59.03           O  
ATOM   3118  CB  VAL   406      11.780  42.401  56.637  1.00 55.96           C  
ATOM   3119  CG1 VAL   406      11.832  43.397  55.500  1.00 54.50           C  
ATOM   3120  CG2 VAL   406      11.456  43.101  57.945  1.00 54.72           C  
ATOM   3121  N   LEU   407      10.473  40.940  53.997  1.00 61.07           N  
ATOM   3122  CA  LEU   407      10.708  40.341  52.705  1.00 63.09           C  
ATOM   3123  C   LEU   407      11.606  41.325  51.987  1.00 66.55           C  
ATOM   3124  O   LEU   407      11.230  42.478  51.779  1.00 66.76           O  
ATOM   3125  CB  LEU   407       9.402  40.198  51.923  1.00 62.13           C  
ATOM   3126  CG  LEU   407       9.506  39.345  50.652  1.00 60.93           C  
ATOM   3127  CD1 LEU   407       9.824  37.936  51.067  1.00 57.60           C  
ATOM   3128  CD2 LEU   407       8.219  39.377  49.851  1.00 59.77           C  
ATOM   3129  N   VAL   408      12.793  40.874  51.603  1.00 69.70           N  
ATOM   3130  CA  VAL   408      13.719  41.751  50.920  1.00 71.94           C  
ATOM   3131  C   VAL   408      13.802  41.433  49.441  1.00 74.01           C  
ATOM   3132  O   VAL   408      14.261  40.358  49.057  1.00 74.62           O  
ATOM   3133  CB  VAL   408      15.127  41.655  51.532  1.00 71.44           C  
ATOM   3134  CG1 VAL   408      16.000  42.775  50.970  1.00 70.84           C  
ATOM   3135  CG2 VAL   408      15.041  41.724  53.056  1.00 69.41           C  
ATOM   3136  N   LEU   409      13.322  42.373  48.627  1.00 76.67           N  
ATOM   3137  CA  LEU   409      13.341  42.271  47.168  1.00 78.86           C  
ATOM   3138  C   LEU   409      14.599  43.029  46.779  1.00 81.23           C  
ATOM   3139  O   LEU   409      14.623  44.262  46.789  1.00 81.47           O  
ATOM   3140  CB  LEU   409      12.118  42.958  46.562  1.00 77.86           C  
ATOM   3141  CG  LEU   409      10.877  42.124  46.250  1.00 78.49           C  
ATOM   3142  CD1 LEU   409       9.748  43.062  45.860  1.00 77.07           C  
ATOM   3143  CD2 LEU   409      11.156  41.144  45.118  1.00 78.28           C  
ATOM   3144  N   THR   410      15.643  42.292  46.425  1.00 83.76           N  
ATOM   3145  CA  THR   410      16.915  42.917  46.113  1.00 85.94           C  
ATOM   3146  C   THR   410      17.734  42.218  45.040  1.00 87.27           C  
ATOM   3147  O   THR   410      17.673  41.000  44.893  1.00 86.80           O  
ATOM   3148  CB  THR   410      17.772  42.986  47.400  1.00 86.84           C  
ATOM   3149  OG1 THR   410      19.074  43.510  47.104  1.00 88.27           O  
ATOM   3150  CG2 THR   410      17.914  41.585  48.011  1.00 85.89           C  
ATOM   3151  N   PRO   411      18.498  42.996  44.259  1.00 89.39           N  
ATOM   3152  CA  PRO   411      19.346  42.434  43.208  1.00 90.75           C  
ATOM   3153  C   PRO   411      20.306  41.502  43.927  1.00 91.92           C  
ATOM   3154  O   PRO   411      20.536  41.655  45.122  1.00 91.90           O  
ATOM   3155  CB  PRO   411      20.054  43.659  42.653  1.00 91.13           C  
ATOM   3156  CG  PRO   411      18.998  44.711  42.750  1.00 91.57           C  
ATOM   3157  CD  PRO   411      18.410  44.464  44.131  1.00 90.65           C  
ATOM   3158  N   PRO   412      20.875  40.523  43.222  1.00 93.41           N  
ATOM   3159  CA  PRO   412      21.803  39.609  43.894  1.00 94.43           C  
ATOM   3160  C   PRO   412      22.856  40.305  44.760  1.00 95.63           C  
ATOM   3161  O   PRO   412      23.463  41.297  44.362  1.00 94.80           O  
ATOM   3162  CB  PRO   412      22.400  38.822  42.736  1.00 93.95           C  
ATOM   3163  CG  PRO   412      21.223  38.717  41.798  1.00 94.37           C  
ATOM   3164  CD  PRO   412      20.668  40.133  41.817  1.00 93.59           C  
ATOM   3165  N   MET   413      23.050  39.772  45.960  1.00 97.99           N  
ATOM   3166  CA  MET   413      24.012  40.322  46.908  1.00100.79           C  
ATOM   3167  C   MET   413      25.176  39.367  47.126  1.00102.04           C  
ATOM   3168  O   MET   413      25.036  38.155  46.964  1.00102.08           O  
ATOM   3169  CB  MET   413      23.355  40.557  48.272  1.00101.82           C  
ATOM   3170  CG  MET   413      22.213  41.553  48.312  1.00103.45           C  
ATOM   3171  SD  MET   413      21.362  41.420  49.911  1.00103.53           S  
ATOM   3172  CE  MET   413      22.331  42.552  50.928  1.00103.98           C  
ATOM   3173  N   ALA   414      26.320  39.927  47.509  1.00103.97           N  
ATOM   3174  CA  ALA   414      27.504  39.127  47.796  1.00105.85           C  
ATOM   3175  C   ALA   414      27.099  38.386  49.040  1.00106.38           C  
ATOM   3176  O   ALA   414      26.309  38.885  49.842  1.00106.75           O  
ATOM   3177  CB  ALA   414      28.689  40.019  48.087  1.00106.57           C  
ATOM   3178  N   TRP   415      27.599  37.203  49.275  1.00106.66           N  
ATOM   3179  CA  TRP   415      27.041  36.636  50.450  1.00107.75           C  
ATOM   3180  C   TRP   415      27.507  37.346  51.743  1.00108.51           C  
ATOM   3181  O   TRP   415      27.047  37.028  52.857  1.00107.71           O  
ATOM   3182  CB  TRP   415      27.362  35.183  50.507  1.00107.61           C  
ATOM   3183  CG  TRP   415      28.169  35.004  51.626  1.00107.74           C  
ATOM   3184  CD1 TRP   415      29.261  35.775  52.019  1.00108.18           C  
ATOM   3185  CD2 TRP   415      27.979  34.030  52.600  1.00106.65           C  
ATOM   3186  NE1 TRP   415      29.739  35.310  53.201  1.00107.61           N  
ATOM   3187  CE2 TRP   415      28.984  34.225  53.578  1.00106.40           C  
ATOM   3188  CE3 TRP   415      27.072  32.967  52.731  1.00105.06           C  
ATOM   3189  CZ2 TRP   415      29.077  33.414  54.703  1.00104.51           C  
ATOM   3190  CZ3 TRP   415      27.164  32.167  53.831  1.00104.32           C  
ATOM   3191  CH2 TRP   415      28.176  32.387  54.809  1.00104.02           C  
ATOM   3192  N   GLU   416      28.441  38.280  51.617  1.00109.72           N  
ATOM   3193  CA  GLU   416      28.915  38.997  52.791  1.00109.87           C  
ATOM   3194  C   GLU   416      27.858  40.047  53.051  1.00108.38           C  
ATOM   3195  O   GLU   416      27.329  40.143  54.153  1.00108.88           O  
ATOM   3196  CB  GLU   416      30.297  39.624  52.537  1.00111.95           C  
ATOM   3197  CG  GLU   416      31.351  38.602  52.158  1.00112.92           C  
ATOM   3198  CD  GLU   416      32.528  39.217  51.425  1.00113.76           C  
ATOM   3199  OE1 GLU   416      32.291  40.073  50.543  1.00114.47           O  
ATOM   3200  OE2 GLU   416      33.683  38.832  51.716  1.00112.91           O  
ATOM   3201  N   ASP   417      27.515  40.807  52.018  1.00106.97           N  
ATOM   3202  CA  ASP   417      26.489  41.844  52.145  1.00105.86           C  
ATOM   3203  C   ASP   417      25.119  41.269  52.552  1.00105.07           C  
ATOM   3204  O   ASP   417      24.281  41.965  53.133  1.00105.88           O  
ATOM   3205  CB  ASP   417      26.358  42.631  50.827  1.00104.58           C  
ATOM   3206  N   ARG   418      24.900  39.994  52.254  1.00103.19           N  
ATOM   3207  CA  ARG   418      23.652  39.296  52.559  1.00101.00           C  
ATOM   3208  C   ARG   418      23.593  38.969  54.032  1.00 99.87           C  
ATOM   3209  O   ARG   418      22.557  39.111  54.694  1.00100.01           O  
ATOM   3210  CB  ARG   418      23.588  38.011  51.736  1.00101.30           C  
ATOM   3211  CG  ARG   418      22.351  37.139  51.911  1.00 99.48           C  
ATOM   3212  CD  ARG   418      22.535  35.869  51.084  1.00 98.59           C  
ATOM   3213  NE  ARG   418      21.295  35.149  50.805  1.00 98.83           N  
ATOM   3214  CZ  ARG   418      20.674  34.339  51.660  1.00 98.71           C  
ATOM   3215  NH1 ARG   418      21.177  34.137  52.873  1.00 99.15           N  
ATOM   3216  NH2 ARG   418      19.557  33.718  51.294  1.00 97.51           N  
ATOM   3217  N   ASN   419      24.713  38.516  54.554  1.00 98.07           N  
ATOM   3218  CA  ASN   419      24.773  38.194  55.948  1.00 95.93           C  
ATOM   3219  C   ASN   419      24.805  39.446  56.809  1.00 94.17           C  
ATOM   3220  O   ASN   419      24.329  39.454  57.946  1.00 92.71           O  
ATOM   3221  CB  ASN   419      26.012  37.338  56.185  1.00 96.39           C  
ATOM   3222  CG  ASN   419      25.676  35.954  56.656  1.00 96.33           C  
ATOM   3223  OD1 ASN   419      24.680  35.333  56.221  1.00 96.82           O  
ATOM   3224  ND2 ASN   419      26.504  35.446  57.553  1.00 95.71           N  
ATOM   3225  N   ARG   420      25.334  40.522  56.238  1.00 92.86           N  
ATOM   3226  CA  ARG   420      25.388  41.782  56.964  1.00 90.97           C  
ATOM   3227  C   ARG   420      23.952  42.269  57.188  1.00 88.97           C  
ATOM   3228  O   ARG   420      23.499  42.421  58.332  1.00 87.55           O  
ATOM   3229  CB  ARG   420      26.210  42.830  56.191  1.00 92.12           C  
ATOM   3230  CG  ARG   420      26.701  43.988  57.043  1.00 93.45           C  
ATOM   3231  CD  ARG   420      27.931  44.649  56.428  1.00 95.52           C  
ATOM   3232  NE  ARG   420      29.094  43.758  56.398  1.00 96.90           N  
ATOM   3233  CZ  ARG   420      30.325  44.139  56.061  1.00 97.50           C  
ATOM   3234  NH1 ARG   420      30.561  45.401  55.724  1.00 97.74           N  
ATOM   3235  NH2 ARG   420      31.319  43.260  56.056  1.00 98.04           N  
ATOM   3236  N   LEU   421      23.230  42.473  56.089  1.00 85.67           N  
ATOM   3237  CA  LEU   421      21.845  42.931  56.149  1.00 82.38           C  
ATOM   3238  C   LEU   421      20.997  42.089  57.102  1.00 80.89           C  
ATOM   3239  O   LEU   421      20.285  42.628  57.947  1.00 80.23           O  
ATOM   3240  CB  LEU   421      21.217  42.936  54.747  1.00 80.13           C  
ATOM   3241  CG  LEU   421      19.820  43.568  54.650  1.00 78.25           C  
ATOM   3242  CD1 LEU   421      19.712  44.748  55.617  1.00 76.32           C  
ATOM   3243  CD2 LEU   421      19.550  44.012  53.211  1.00 76.38           C  
ATOM   3244  N   LYS   422      21.080  40.772  56.974  1.00 79.37           N  
ATOM   3245  CA  LYS   422      20.317  39.898  57.851  1.00 79.24           C  
ATOM   3246  C   LYS   422      20.703  40.148  59.290  1.00 78.84           C  
ATOM   3247  O   LYS   422      19.888  39.974  60.195  1.00 78.89           O  
ATOM   3248  CB  LYS   422      20.563  38.420  57.517  1.00 80.27           C  
ATOM   3249  CG  LYS   422      19.726  37.900  56.357  1.00 80.84           C  
ATOM   3250  CD  LYS   422      19.998  36.440  56.090  1.00 81.25           C  
ATOM   3251  CE  LYS   422      18.871  35.825  55.279  1.00 81.95           C  
ATOM   3252  NZ  LYS   422      17.671  35.600  56.125  1.00 81.02           N  
ATOM   3253  N   ALA   423      21.951  40.559  59.498  1.00 78.91           N  
ATOM   3254  CA  ALA   423      22.456  40.832  60.840  1.00 78.05           C  
ATOM   3255  C   ALA   423      21.864  42.120  61.391  1.00 76.96           C  
ATOM   3256  O   ALA   423      21.506  42.196  62.566  1.00 75.31           O  
ATOM   3257  CB  ALA   423      23.971  40.925  60.819  1.00 79.78           C  
ATOM   3258  N   LEU   424      21.764  43.132  60.538  1.00 76.20           N  
ATOM   3259  CA  LEU   424      21.203  44.404  60.956  1.00 77.10           C  
ATOM   3260  C   LEU   424      19.767  44.193  61.455  1.00 77.44           C  
ATOM   3261  O   LEU   424      19.431  44.543  62.588  1.00 77.02           O  
ATOM   3262  CB  LEU   424      21.193  45.384  59.789  1.00 77.44           C  
ATOM   3263  CG  LEU   424      21.116  46.836  60.254  1.00 79.53           C  
ATOM   3264  CD1 LEU   424      22.511  47.331  60.559  1.00 81.77           C  
ATOM   3265  CD2 LEU   424      20.514  47.694  59.182  1.00 80.78           C  
ATOM   3266  N   LEU   425      18.938  43.596  60.598  1.00 76.81           N  
ATOM   3267  CA  LEU   425      17.534  43.326  60.893  1.00 75.30           C  
ATOM   3268  C   LEU   425      17.276  42.463  62.116  1.00 76.29           C  
ATOM   3269  O   LEU   425      16.482  42.836  62.978  1.00 76.39           O  
ATOM   3270  CB  LEU   425      16.867  42.639  59.708  1.00 73.34           C  
ATOM   3271  CG  LEU   425      17.056  43.225  58.320  1.00 72.81           C  
ATOM   3272  CD1 LEU   425      16.266  42.380  57.348  1.00 71.97           C  
ATOM   3273  CD2 LEU   425      16.606  44.669  58.278  1.00 71.87           C  
ATOM   3274  N   LEU   426      17.915  41.290  62.161  1.00 77.66           N  
ATOM   3275  CA  LEU   426      17.749  40.326  63.259  1.00 77.59           C  
ATOM   3276  C   LEU   426      18.077  40.987  64.564  1.00 77.63           C  
ATOM   3277  O   LEU   426      17.692  40.541  65.643  1.00 76.70           O  
ATOM   3278  CB  LEU   426      18.687  39.136  63.097  1.00 77.39           C  
ATOM   3279  CG  LEU   426      18.287  37.996  64.031  1.00 78.31           C  
ATOM   3280  CD1 LEU   426      17.374  37.077  63.257  1.00 79.63           C  
ATOM   3281  CD2 LEU   426      19.485  37.231  64.532  1.00 78.88           C  
ATOM   3282  N   ARG   427      18.825  42.059  64.435  1.00 78.65           N  
ATOM   3283  CA  ARG   427      19.238  42.814  65.566  1.00 80.33           C  
ATOM   3284  C   ARG   427      18.067  43.345  66.284  1.00 79.47           C  
ATOM   3285  O   ARG   427      17.932  43.269  67.503  1.00 80.34           O  
ATOM   3286  CB  ARG   427      19.980  44.044  65.150  1.00 83.88           C  
ATOM   3287  CG  ARG   427      20.371  44.679  66.370  1.00 87.75           C  
ATOM   3288  CD  ARG   427      21.159  43.586  67.016  1.00 90.99           C  
ATOM   3289  NE  ARG   427      22.507  44.065  67.059  1.00 94.46           N  
ATOM   3290  CZ  ARG   427      23.002  44.617  68.148  1.00 96.65           C  
ATOM   3291  NH1 ARG   427      22.238  44.693  69.237  1.00 96.88           N  
ATOM   3292  NH2 ARG   427      24.206  45.170  68.127  1.00 96.72           N  
ATOM   3293  N   GLU   428      17.296  44.023  65.462  1.00 78.10           N  
ATOM   3294  CA  GLU   428      16.094  44.687  65.853  1.00 77.18           C  
ATOM   3295  C   GLU   428      14.976  43.677  66.021  1.00 75.63           C  
ATOM   3296  O   GLU   428      13.828  44.038  66.238  1.00 74.74           O  
ATOM   3297  CB  GLU   428      15.775  45.726  64.786  1.00 77.14           C  
ATOM   3298  CG  GLU   428      16.764  46.891  64.804  1.00 79.44           C  
ATOM   3299  CD  GLU   428      16.807  47.583  66.162  1.00 79.89           C  
ATOM   3300  OE1 GLU   428      17.534  47.112  67.067  1.00 79.73           O  
ATOM   3301  OE2 GLU   428      16.091  48.592  66.329  1.00 80.91           O  
ATOM   3302  N   GLY   429      15.336  42.402  65.931  1.00 74.63           N  
ATOM   3303  CA  GLY   429      14.360  41.334  66.080  1.00 72.55           C  
ATOM   3304  C   GLY   429      13.550  40.984  64.840  1.00 69.54           C  
ATOM   3305  O   GLY   429      12.543  40.285  64.954  1.00 69.46           O  
ATOM   3306  N   LEU   430      13.989  41.435  63.666  1.00 65.59           N  
ATOM   3307  CA  LEU   430      13.263  41.170  62.429  1.00 63.62           C  
ATOM   3308  C   LEU   430      13.808  40.068  61.507  1.00 63.34           C  
ATOM   3309  O   LEU   430      14.744  40.307  60.733  1.00 63.73           O  
ATOM   3310  CB  LEU   430      13.150  42.468  61.627  1.00 62.33           C  
ATOM   3311  CG  LEU   430      12.451  43.641  62.324  1.00 62.79           C  
ATOM   3312  CD1 LEU   430      12.677  44.896  61.493  1.00 60.07           C  
ATOM   3313  CD2 LEU   430      10.941  43.359  62.534  1.00 59.66           C  
ATOM   3314  N   PRO   431      13.237  38.846  61.578  1.00 62.40           N  
ATOM   3315  CA  PRO   431      13.720  37.774  60.703  1.00 61.39           C  
ATOM   3316  C   PRO   431      13.654  38.230  59.249  1.00 62.47           C  
ATOM   3317  O   PRO   431      13.092  39.280  58.951  1.00 63.84           O  
ATOM   3318  CB  PRO   431      12.780  36.632  61.035  1.00 61.00           C  
ATOM   3319  CG  PRO   431      12.651  36.783  62.523  1.00 59.95           C  
ATOM   3320  CD  PRO   431      12.419  38.284  62.671  1.00 61.72           C  
ATOM   3321  N   SER   432      14.226  37.468  58.328  1.00 63.15           N  
ATOM   3322  CA  SER   432      14.231  37.925  56.943  1.00 62.84           C  
ATOM   3323  C   SER   432      14.320  36.826  55.883  1.00 64.22           C  
ATOM   3324  O   SER   432      14.755  35.700  56.150  1.00 63.59           O  
ATOM   3325  CB  SER   432      15.376  38.915  56.771  1.00 62.93           C  
ATOM   3326  OG  SER   432      16.518  38.491  57.521  1.00 62.22           O  
ATOM   3327  N   GLN   433      13.897  37.176  54.675  1.00 64.53           N  
ATOM   3328  CA  GLN   433      13.890  36.257  53.551  1.00 64.83           C  
ATOM   3329  C   GLN   433      14.243  37.037  52.303  1.00 66.12           C  
ATOM   3330  O   GLN   433      13.609  38.038  51.995  1.00 64.22           O  
ATOM   3331  CB  GLN   433      12.503  35.645  53.391  1.00 63.12           C  
ATOM   3332  CG  GLN   433      12.286  34.935  52.083  1.00 61.22           C  
ATOM   3333  CD  GLN   433      13.009  33.623  52.021  1.00 61.81           C  
ATOM   3334  OE1 GLN   433      13.014  32.867  53.001  1.00 61.91           O  
ATOM   3335  NE2 GLN   433      13.616  33.321  50.866  1.00 58.69           N  
ATOM   3336  N   ILE   434      15.263  36.571  51.593  1.00 69.20           N  
ATOM   3337  CA  ILE   434      15.715  37.229  50.377  1.00 72.35           C  
ATOM   3338  C   ILE   434      14.969  36.697  49.164  1.00 73.45           C  
ATOM   3339  O   ILE   434      14.593  35.527  49.114  1.00 72.73           O  
ATOM   3340  CB  ILE   434      17.248  37.024  50.163  1.00 73.51           C  
ATOM   3341  CG1 ILE   434      18.024  37.634  51.339  1.00 74.36           C  
ATOM   3342  CG2 ILE   434      17.692  37.647  48.846  1.00 71.51           C  
ATOM   3343  CD1 ILE   434      17.862  39.133  51.482  1.00 75.29           C  
ATOM   3344  N   LEU   435      14.758  37.574  48.192  1.00 75.09           N  
ATOM   3345  CA  LEU   435      14.073  37.214  46.963  1.00 78.54           C  
ATOM   3346  C   LEU   435      14.667  38.145  45.911  1.00 80.79           C  
ATOM   3347  O   LEU   435      14.323  39.328  45.854  1.00 79.86           O  
ATOM   3348  CB  LEU   435      12.559  37.434  47.120  1.00 78.73           C  
ATOM   3349  CG  LEU   435      11.603  36.787  46.111  1.00 78.79           C  
ATOM   3350  CD1 LEU   435      10.169  36.994  46.563  1.00 78.83           C  
ATOM   3351  CD2 LEU   435      11.822  37.381  44.726  1.00 78.56           C  
ATOM   3352  N   ASN   436      15.569  37.600  45.090  1.00 84.19           N  
ATOM   3353  CA  ASN   436      16.274  38.370  44.055  1.00 86.14           C  
ATOM   3354  C   ASN   436      15.351  39.053  43.064  1.00 87.85           C  
ATOM   3355  O   ASN   436      14.460  38.432  42.503  1.00 88.11           O  
ATOM   3356  CB  ASN   436      17.297  37.478  43.354  1.00 85.32           C  
ATOM   3357  CG  ASN   436      18.254  36.808  44.345  1.00 84.74           C  
ATOM   3358  OD1 ASN   436      18.461  37.299  45.455  1.00 82.94           O  
ATOM   3359  ND2 ASN   436      18.844  35.692  43.941  1.00 85.31           N  
ATOM   3360  N   VAL   437      15.606  40.345  42.862  1.00 91.02           N  
ATOM   3361  CA  VAL   437      14.801  41.244  42.034  1.00 94.25           C  
ATOM   3362  C   VAL   437      14.242  40.875  40.643  1.00 96.47           C  
ATOM   3363  O   VAL   437      13.060  41.133  40.385  1.00 97.05           O  
ATOM   3364  CB  VAL   437      15.489  42.650  41.966  1.00 95.19           C  
ATOM   3365  CG1 VAL   437      16.833  42.558  41.273  1.00 96.70           C  
ATOM   3366  CG2 VAL   437      14.571  43.654  41.278  1.00 95.32           C  
ATOM   3367  N   PRO   438      15.054  40.305  39.722  1.00 97.89           N  
ATOM   3368  CA  PRO   438      14.426  39.983  38.426  1.00 98.05           C  
ATOM   3369  C   PRO   438      13.326  38.957  38.696  1.00 98.73           C  
ATOM   3370  O   PRO   438      13.587  37.755  38.766  1.00 98.98           O  
ATOM   3371  CB  PRO   438      15.574  39.379  37.616  1.00 97.76           C  
ATOM   3372  CG  PRO   438      16.801  39.983  38.240  1.00 98.23           C  
ATOM   3373  CD  PRO   438      16.479  39.932  39.716  1.00 98.00           C  
ATOM   3374  N   LEU   439      12.100  39.431  38.872  1.00 99.19           N  
ATOM   3375  CA  LEU   439      11.000  38.530  39.171  1.00 99.12           C  
ATOM   3376  C   LEU   439       9.855  38.740  38.206  1.00 99.09           C  
ATOM   3377  O   LEU   439       9.476  39.878  37.905  1.00 97.78           O  
ATOM   3378  CB  LEU   439      10.523  38.746  40.612  1.00 99.18           C  
ATOM   3379  CG  LEU   439       9.556  37.710  41.188  1.00 99.34           C  
ATOM   3380  CD1 LEU   439      10.187  36.331  41.109  1.00 99.23           C  
ATOM   3381  CD2 LEU   439       9.221  38.060  42.631  1.00100.08           C  
ATOM   3382  N   ARG   440       9.307  37.629  37.727  1.00 99.55           N  
ATOM   3383  CA  ARG   440       8.206  37.663  36.780  1.00100.12           C  
ATOM   3384  C   ARG   440       7.058  36.770  37.217  1.00 99.18           C  
ATOM   3385  O   ARG   440       7.274  35.663  37.708  1.00 98.60           O  
ATOM   3386  CB  ARG   440       8.708  37.234  35.401  1.00102.04           C  
ATOM   3387  CG  ARG   440       9.632  38.252  34.753  1.00105.17           C  
ATOM   3388  CD  ARG   440      10.368  37.669  33.555  1.00107.50           C  
ATOM   3389  NE  ARG   440      11.251  36.575  33.954  1.00108.82           N  
ATOM   3390  CZ  ARG   440      12.046  35.911  33.120  1.00108.98           C  
ATOM   3391  NH1 ARG   440      12.073  36.231  31.830  1.00109.58           N  
ATOM   3392  NH2 ARG   440      12.812  34.927  33.577  1.00107.31           N  
ATOM   3393  N   GLU   441       5.839  37.270  37.034  1.00 98.47           N  
ATOM   3394  CA  GLU   441       4.624  36.543  37.389  1.00 98.07           C  
ATOM   3395  C   GLU   441       4.774  35.022  37.320  1.00 98.27           C  
ATOM   3396  O   GLU   441       4.696  34.328  38.333  1.00 96.98           O  
ATOM   3397  CB  GLU   441       3.472  36.976  36.467  1.00 97.87           C  
ATOM   3398  CG  GLU   441       2.655  38.176  36.959  1.00 96.22           C  
ATOM   3399  CD  GLU   441       1.281  37.774  37.499  1.00 94.70           C  
ATOM   3400  OE1 GLU   441       1.184  36.752  38.215  1.00 92.70           O  
ATOM   3401  OE2 GLU   441       0.298  38.490  37.216  1.00 93.59           O  
ATOM   3402  N   GLU   442       5.012  34.514  36.117  1.00 99.34           N  
ATOM   3403  CA  GLU   442       5.123  33.076  35.897  1.00100.22           C  
ATOM   3404  C   GLU   442       6.396  32.373  36.399  1.00 99.72           C  
ATOM   3405  O   GLU   442       6.890  31.459  35.739  1.00100.23           O  
ATOM   3406  CB  GLU   442       4.916  32.774  34.401  1.00 99.48           C  
ATOM   3407  N   GLU   443       6.917  32.772  37.556  1.00 98.53           N  
ATOM   3408  CA  GLU   443       8.109  32.122  38.110  1.00 97.47           C  
ATOM   3409  C   GLU   443       7.723  31.454  39.424  1.00 96.61           C  
ATOM   3410  O   GLU   443       8.488  31.423  40.392  1.00 95.83           O  
ATOM   3411  CB  GLU   443       9.230  33.139  38.339  1.00 97.80           C  
ATOM   3412  CG  GLU   443       9.740  33.767  37.060  1.00 98.79           C  
ATOM   3413  CD  GLU   443      11.049  34.493  37.250  1.00 99.76           C  
ATOM   3414  OE1 GLU   443      12.030  33.843  37.675  1.00 98.85           O  
ATOM   3415  OE2 GLU   443      11.097  35.711  36.970  1.00101.08           O  
ATOM   3416  N   ARG   444       6.514  30.908  39.412  1.00 95.98           N  
ATOM   3417  CA  ARG   444       5.894  30.238  40.549  1.00 95.19           C  
ATOM   3418  C   ARG   444       6.783  29.458  41.515  1.00 94.13           C  
ATOM   3419  O   ARG   444       6.556  29.491  42.722  1.00 94.37           O  
ATOM   3420  CB  ARG   444       4.769  29.330  40.051  1.00 94.15           C  
ATOM   3421  N   HIS   445       7.793  28.758  41.024  1.00 92.74           N  
ATOM   3422  CA  HIS   445       8.605  27.986  41.946  1.00 91.04           C  
ATOM   3423  C   HIS   445       9.434  28.795  42.955  1.00 88.56           C  
ATOM   3424  O   HIS   445       9.388  28.538  44.160  1.00 87.28           O  
ATOM   3425  CB  HIS   445       9.521  27.039  41.176  1.00 92.78           C  
ATOM   3426  CG  HIS   445      10.366  26.180  42.063  1.00 95.26           C  
ATOM   3427  ND1 HIS   445       9.827  25.294  42.974  1.00 95.37           N  
ATOM   3428  CD2 HIS   445      11.710  26.112  42.221  1.00 96.05           C  
ATOM   3429  CE1 HIS   445      10.803  24.719  43.656  1.00 96.00           C  
ATOM   3430  NE2 HIS   445      11.956  25.198  43.218  1.00 96.62           N  
ATOM   3431  N   ARG   446      10.183  29.777  42.474  1.00 85.80           N  
ATOM   3432  CA  ARG   446      11.026  30.550  43.373  1.00 83.17           C  
ATOM   3433  C   ARG   446      10.257  31.370  44.410  1.00 82.01           C  
ATOM   3434  O   ARG   446      10.481  31.224  45.614  1.00 81.48           O  
ATOM   3435  CB  ARG   446      11.954  31.472  42.573  1.00 81.52           C  
ATOM   3436  CG  ARG   446      13.395  31.513  43.082  1.00 79.01           C  
ATOM   3437  CD  ARG   446      14.050  32.836  42.712  1.00 79.07           C  
ATOM   3438  NE  ARG   446      13.729  33.228  41.342  1.00 77.93           N  
ATOM   3439  CZ  ARG   446      13.788  34.475  40.887  1.00 77.82           C  
ATOM   3440  NH1 ARG   446      14.154  35.459  41.692  1.00 77.88           N  
ATOM   3441  NH2 ARG   446      13.474  34.741  39.626  1.00 78.13           N  
ATOM   3442  N   TRP   447       9.345  32.223  43.960  1.00 80.42           N  
ATOM   3443  CA  TRP   447       8.626  33.051  44.910  1.00 79.75           C  
ATOM   3444  C   TRP   447       7.647  32.348  45.853  1.00 79.40           C  
ATOM   3445  O   TRP   447       7.453  32.810  46.972  1.00 79.31           O  
ATOM   3446  CB  TRP   447       7.945  34.231  44.207  1.00 79.05           C  
ATOM   3447  CG  TRP   447       6.848  33.912  43.253  1.00 79.39           C  
ATOM   3448  CD1 TRP   447       6.945  33.817  41.896  1.00 79.71           C  
ATOM   3449  CD2 TRP   447       5.457  33.777  43.564  1.00 79.97           C  
ATOM   3450  NE1 TRP   447       5.699  33.646  41.339  1.00 79.51           N  
ATOM   3451  CE2 TRP   447       4.767  33.619  42.342  1.00 80.10           C  
ATOM   3452  CE3 TRP   447       4.723  33.780  44.758  1.00 79.53           C  
ATOM   3453  CZ2 TRP   447       3.376  33.468  42.281  1.00 79.48           C  
ATOM   3454  CZ3 TRP   447       3.341  33.628  44.695  1.00 78.13           C  
ATOM   3455  CH2 TRP   447       2.684  33.475  43.466  1.00 78.28           C  
ATOM   3456  N   GLU   448       7.031  31.246  45.437  1.00 78.76           N  
ATOM   3457  CA  GLU   448       6.119  30.557  46.347  1.00 78.69           C  
ATOM   3458  C   GLU   448       6.924  30.041  47.537  1.00 78.31           C  
ATOM   3459  O   GLU   448       6.443  29.999  48.672  1.00 78.83           O  
ATOM   3460  CB  GLU   448       5.406  29.377  45.666  1.00 79.68           C  
ATOM   3461  CG  GLU   448       4.414  29.783  44.566  1.00 80.69           C  
ATOM   3462  CD  GLU   448       3.314  28.751  44.348  1.00 79.85           C  
ATOM   3463  OE1 GLU   448       3.616  27.538  44.371  1.00 79.77           O  
ATOM   3464  OE2 GLU   448       2.150  29.162  44.144  1.00 78.03           O  
ATOM   3465  N   ASN   449       8.158  29.641  47.280  1.00 77.42           N  
ATOM   3466  CA  ASN   449       8.990  29.155  48.363  1.00 76.32           C  
ATOM   3467  C   ASN   449       9.466  30.350  49.206  1.00 74.54           C  
ATOM   3468  O   ASN   449       9.367  30.324  50.436  1.00 74.07           O  
ATOM   3469  CB  ASN   449      10.167  28.341  47.798  1.00 77.23           C  
ATOM   3470  CG  ASN   449       9.737  26.961  47.295  1.00 76.85           C  
ATOM   3471  OD1 ASN   449       8.791  26.838  46.516  1.00 77.04           O  
ATOM   3472  ND2 ASN   449      10.438  25.923  47.736  1.00 76.34           N  
ATOM   3473  N   ALA   450       9.957  31.403  48.553  1.00 71.90           N  
ATOM   3474  CA  ALA   450      10.417  32.578  49.285  1.00 69.69           C  
ATOM   3475  C   ALA   450       9.325  32.988  50.270  1.00 69.06           C  
ATOM   3476  O   ALA   450       9.602  33.286  51.436  1.00 68.21           O  
ATOM   3477  CB  ALA   450      10.716  33.720  48.321  1.00 68.92           C  
ATOM   3478  N   LEU   451       8.081  32.979  49.791  1.00 67.35           N  
ATOM   3479  CA  LEU   451       6.932  33.343  50.603  1.00 65.40           C  
ATOM   3480  C   LEU   451       6.769  32.384  51.762  1.00 65.21           C  
ATOM   3481  O   LEU   451       6.316  32.776  52.838  1.00 65.37           O  
ATOM   3482  CB  LEU   451       5.665  33.351  49.754  1.00 65.42           C  
ATOM   3483  CG  LEU   451       5.039  34.714  49.435  1.00 66.59           C  
ATOM   3484  CD1 LEU   451       6.106  35.781  49.206  1.00 66.15           C  
ATOM   3485  CD2 LEU   451       4.147  34.563  48.204  1.00 65.91           C  
ATOM   3486  N   LEU   452       7.135  31.126  51.557  1.00 64.26           N  
ATOM   3487  CA  LEU   452       7.025  30.157  52.639  1.00 64.26           C  
ATOM   3488  C   LEU   452       8.072  30.401  53.735  1.00 64.39           C  
ATOM   3489  O   LEU   452       7.779  30.242  54.928  1.00 63.61           O  
ATOM   3490  CB  LEU   452       7.151  28.734  52.095  1.00 64.86           C  
ATOM   3491  CG  LEU   452       5.905  28.180  51.404  1.00 65.27           C  
ATOM   3492  CD1 LEU   452       6.292  27.008  50.531  1.00 65.89           C  
ATOM   3493  CD2 LEU   452       4.871  27.768  52.440  1.00 62.60           C  
ATOM   3494  N   GLY   453       9.284  30.790  53.335  1.00 63.39           N  
ATOM   3495  CA  GLY   453      10.325  31.048  54.318  1.00 64.16           C  
ATOM   3496  C   GLY   453       9.997  32.271  55.155  1.00 63.73           C  
ATOM   3497  O   GLY   453      10.199  32.297  56.376  1.00 62.75           O  
ATOM   3498  N   LEU   454       9.486  33.290  54.473  1.00 62.79           N  
ATOM   3499  CA  LEU   454       9.093  34.525  55.112  1.00 62.41           C  
ATOM   3500  C   LEU   454       8.059  34.193  56.198  1.00 61.23           C  
ATOM   3501  O   LEU   454       8.178  34.644  57.346  1.00 60.74           O  
ATOM   3502  CB  LEU   454       8.503  35.477  54.059  1.00 63.32           C  
ATOM   3503  CG  LEU   454       8.546  37.017  54.194  1.00 65.10           C  
ATOM   3504  CD1 LEU   454       7.134  37.555  54.338  1.00 65.05           C  
ATOM   3505  CD2 LEU   454       9.424  37.452  55.365  1.00 65.74           C  
ATOM   3506  N   LEU   455       7.079  33.362  55.850  1.00 59.72           N  
ATOM   3507  CA  LEU   455       6.020  33.008  56.794  1.00 60.24           C  
ATOM   3508  C   LEU   455       6.484  32.094  57.910  1.00 59.72           C  
ATOM   3509  O   LEU   455       6.103  32.276  59.069  1.00 58.97           O  
ATOM   3510  CB  LEU   455       4.820  32.373  56.062  1.00 60.75           C  
ATOM   3511  CG  LEU   455       3.989  33.269  55.131  1.00 59.94           C  
ATOM   3512  CD1 LEU   455       3.138  32.408  54.250  1.00 59.53           C  
ATOM   3513  CD2 LEU   455       3.133  34.227  55.925  1.00 59.15           C  
ATOM   3514  N   ALA   456       7.298  31.106  57.561  1.00 60.17           N  
ATOM   3515  CA  ALA   456       7.823  30.175  58.555  1.00 60.06           C  
ATOM   3516  C   ALA   456       8.624  30.955  59.594  1.00 60.28           C  
ATOM   3517  O   ALA   456       8.566  30.655  60.789  1.00 59.15           O  
ATOM   3518  CB  ALA   456       8.707  29.141  57.886  1.00 60.54           C  
ATOM   3519  N   LYS   457       9.361  31.958  59.122  1.00 60.97           N  
ATOM   3520  CA  LYS   457      10.174  32.802  59.988  1.00 63.58           C  
ATOM   3521  C   LYS   457       9.310  33.738  60.813  1.00 64.57           C  
ATOM   3522  O   LYS   457       9.644  34.070  61.948  1.00 65.77           O  
ATOM   3523  CB  LYS   457      11.171  33.621  59.160  1.00 63.49           C  
ATOM   3524  CG  LYS   457      12.306  32.780  58.600  1.00 65.51           C  
ATOM   3525  CD  LYS   457      13.165  33.544  57.604  1.00 65.97           C  
ATOM   3526  CE  LYS   457      14.015  32.576  56.780  1.00 66.12           C  
ATOM   3527  NZ  LYS   457      14.828  33.275  55.741  1.00 65.64           N  
ATOM   3528  N   ALA   458       8.194  34.166  60.240  1.00 64.66           N  
ATOM   3529  CA  ALA   458       7.298  35.062  60.940  1.00 63.69           C  
ATOM   3530  C   ALA   458       6.669  34.391  62.151  1.00 62.73           C  
ATOM   3531  O   ALA   458       5.910  35.015  62.877  1.00 62.93           O  
ATOM   3532  CB  ALA   458       6.220  35.547  59.993  1.00 64.34           C  
ATOM   3533  N   GLY   459       6.994  33.127  62.375  1.00 63.10           N  
ATOM   3534  CA  GLY   459       6.427  32.405  63.503  1.00 64.91           C  
ATOM   3535  C   GLY   459       5.185  31.656  63.054  1.00 66.83           C  
ATOM   3536  O   GLY   459       4.467  31.025  63.838  1.00 66.40           O  
ATOM   3537  N   LEU   460       4.942  31.719  61.756  1.00 67.91           N  
ATOM   3538  CA  LEU   460       3.795  31.074  61.182  1.00 69.78           C  
ATOM   3539  C   LEU   460       4.116  29.664  60.684  1.00 70.34           C  
ATOM   3540  O   LEU   460       5.007  29.473  59.870  1.00 71.78           O  
ATOM   3541  CB  LEU   460       3.287  31.938  60.053  1.00 72.34           C  
ATOM   3542  CG  LEU   460       1.951  31.526  59.467  1.00 76.66           C  
ATOM   3543  CD1 LEU   460       0.855  31.575  60.530  1.00 76.70           C  
ATOM   3544  CD2 LEU   460       1.644  32.475  58.326  1.00 79.44           C  
ATOM   3545  N   GLN   461       3.375  28.679  61.177  1.00 69.76           N  
ATOM   3546  CA  GLN   461       3.576  27.289  60.788  1.00 68.59           C  
ATOM   3547  C   GLN   461       2.760  26.843  59.566  1.00 66.95           C  
ATOM   3548  O   GLN   461       1.694  26.238  59.684  1.00 64.83           O  
ATOM   3549  CB  GLN   461       3.263  26.392  61.974  1.00 70.27           C  
ATOM   3550  CG  GLN   461       3.561  24.941  61.752  1.00 72.88           C  
ATOM   3551  CD  GLN   461       3.683  24.214  63.062  1.00 76.21           C  
ATOM   3552  OE1 GLN   461       3.032  24.584  64.047  1.00 77.16           O  
ATOM   3553  NE2 GLN   461       4.511  23.169  63.092  1.00 77.22           N  
ATOM   3554  N   VAL   462       3.302  27.157  58.396  1.00 66.06           N  
ATOM   3555  CA  VAL   462       2.729  26.830  57.100  1.00 65.72           C  
ATOM   3556  C   VAL   462       2.292  25.381  56.927  1.00 66.48           C  
ATOM   3557  O   VAL   462       1.133  25.105  56.610  1.00 66.90           O  
ATOM   3558  CB  VAL   462       3.742  27.133  56.002  1.00 64.49           C  
ATOM   3559  CG1 VAL   462       3.473  26.260  54.800  1.00 63.68           C  
ATOM   3560  CG2 VAL   462       3.683  28.598  55.643  1.00 64.45           C  
ATOM   3561  N   VAL   463       3.239  24.468  57.105  1.00 66.83           N  
ATOM   3562  CA  VAL   463       2.992  23.044  56.959  1.00 67.98           C  
ATOM   3563  C   VAL   463       3.602  22.259  58.094  1.00 68.60           C  
ATOM   3564  O   VAL   463       4.584  22.682  58.686  1.00 69.47           O  
ATOM   3565  CB  VAL   463       3.617  22.500  55.670  1.00 69.08           C  
ATOM   3566  CG1 VAL   463       3.567  20.979  55.678  1.00 69.81           C  
ATOM   3567  CG2 VAL   463       2.886  23.046  54.453  1.00 69.83           C  
ATOM   3568  N   ALA   464       3.022  21.103  58.380  1.00 69.70           N  
ATOM   3569  CA  ALA   464       3.529  20.229  59.425  1.00 72.30           C  
ATOM   3570  C   ALA   464       3.805  18.852  58.807  1.00 74.52           C  
ATOM   3571  O   ALA   464       3.051  18.384  57.954  1.00 74.47           O  
ATOM   3572  CB  ALA   464       2.521  20.112  60.552  1.00 71.04           C  
ATOM   3573  N   LEU   465       4.900  18.219  59.222  1.00 76.38           N  
ATOM   3574  CA  LEU   465       5.264  16.905  58.703  1.00 77.84           C  
ATOM   3575  C   LEU   465       4.616  15.832  59.569  1.00 78.78           C  
ATOM   3576  O   LEU   465       4.476  16.025  60.779  1.00 78.89           O  
ATOM   3577  CB  LEU   465       6.787  16.747  58.695  1.00 78.40           C  
ATOM   3578  CG  LEU   465       7.559  17.587  57.665  1.00 78.96           C  
ATOM   3579  CD1 LEU   465       9.050  17.574  57.985  1.00 79.72           C  
ATOM   3580  CD2 LEU   465       7.317  17.041  56.271  1.00 77.67           C  
ATOM   3581  N   SER   466       4.214  14.725  58.936  1.00 79.81           N  
ATOM   3582  CA  SER   466       3.549  13.588  59.596  1.00 80.82           C  
ATOM   3583  C   SER   466       3.950  13.415  61.045  1.00 80.84           C  
ATOM   3584  O   SER   466       3.274  13.917  61.938  1.00 81.56           O  
ATOM   3585  CB  SER   466       3.839  12.291  58.838  1.00 82.93           C  
ATOM   3586  OG  SER   466       5.235  12.037  58.766  1.00 84.15           O  
ATOM   3587  N   GLY   467       5.042  12.695  61.287  1.00 81.00           N  
ATOM   3588  CA  GLY   467       5.502  12.525  62.654  1.00 81.37           C  
ATOM   3589  C   GLY   467       6.572  11.474  62.865  1.00 81.75           C  
ATOM   3590  O   GLY   467       7.041  10.835  61.920  1.00 82.48           O  
ATOM   3591  N   ALA   468       6.974  11.322  64.124  1.00 81.68           N  
ATOM   3592  CA  ALA   468       7.961  10.327  64.533  1.00 80.99           C  
ATOM   3593  C   ALA   468       9.324  10.361  63.839  1.00 80.19           C  
ATOM   3594  O   ALA   468       9.623   9.523  62.979  1.00 79.92           O  
ATOM   3595  CB  ALA   468       7.351   8.924  64.402  1.00 82.22           C  
ATOM   3596  N   TYR   469      10.151  11.328  64.222  1.00 78.24           N  
ATOM   3597  CA  TYR   469      11.495  11.428  63.675  1.00 76.47           C  
ATOM   3598  C   TYR   469      12.491  11.352  64.831  1.00 75.83           C  
ATOM   3599  O   TYR   469      12.132  11.577  65.994  1.00 76.20           O  
ATOM   3600  CB  TYR   469      11.698  12.743  62.938  1.00 75.45           C  
ATOM   3601  CG  TYR   469      10.840  12.942  61.714  1.00 75.83           C  
ATOM   3602  CD1 TYR   469       9.533  13.408  61.824  1.00 77.11           C  
ATOM   3603  CD2 TYR   469      11.365  12.760  60.438  1.00 75.21           C  
ATOM   3604  CE1 TYR   469       8.771  13.704  60.692  1.00 76.69           C  
ATOM   3605  CE2 TYR   469      10.616  13.050  59.299  1.00 76.12           C  
ATOM   3606  CZ  TYR   469       9.319  13.528  59.432  1.00 77.17           C  
ATOM   3607  OH  TYR   469       8.586  13.861  58.306  1.00 78.60           O  
ATOM   3608  N   PRO   470      13.758  11.020  64.534  1.00 74.43           N  
ATOM   3609  CA  PRO   470      14.756  10.935  65.600  1.00 73.59           C  
ATOM   3610  C   PRO   470      14.874  12.222  66.436  1.00 72.92           C  
ATOM   3611  O   PRO   470      14.674  12.205  67.653  1.00 73.08           O  
ATOM   3612  CB  PRO   470      16.034  10.607  64.836  1.00 72.97           C  
ATOM   3613  CG  PRO   470      15.528   9.766  63.727  1.00 72.63           C  
ATOM   3614  CD  PRO   470      14.313  10.518  63.265  1.00 73.00           C  
ATOM   3615  N   ALA   471      15.193  13.334  65.781  1.00 71.13           N  
ATOM   3616  CA  ALA   471      15.343  14.602  66.480  1.00 69.59           C  
ATOM   3617  C   ALA   471      14.063  15.442  66.455  1.00 68.79           C  
ATOM   3618  O   ALA   471      13.316  15.422  65.484  1.00 69.37           O  
ATOM   3619  CB  ALA   471      16.487  15.385  65.865  1.00 68.16           C  
ATOM   3620  N   GLU   472      13.803  16.170  67.533  1.00 67.55           N  
ATOM   3621  CA  GLU   472      12.632  17.025  67.578  1.00 66.34           C  
ATOM   3622  C   GLU   472      13.095  18.461  67.347  1.00 64.82           C  
ATOM   3623  O   GLU   472      12.304  19.401  67.416  1.00 65.70           O  
ATOM   3624  CB  GLU   472      11.911  16.889  68.923  1.00 69.32           C  
ATOM   3625  CG  GLU   472      12.669  17.392  70.137  1.00 74.14           C  
ATOM   3626  CD  GLU   472      11.908  17.152  71.442  1.00 77.40           C  
ATOM   3627  OE1 GLU   472      10.710  17.519  71.521  1.00 79.69           O  
ATOM   3628  OE2 GLU   472      12.508  16.606  72.392  1.00 77.27           O  
ATOM   3629  N   LEU   473      14.392  18.605  67.073  1.00 61.73           N  
ATOM   3630  CA  LEU   473      15.036  19.880  66.790  1.00 58.59           C  
ATOM   3631  C   LEU   473      16.234  19.560  65.920  1.00 57.54           C  
ATOM   3632  O   LEU   473      17.077  18.783  66.342  1.00 59.96           O  
ATOM   3633  CB  LEU   473      15.538  20.550  68.070  1.00 58.06           C  
ATOM   3634  CG  LEU   473      16.521  21.715  67.809  1.00 59.46           C  
ATOM   3635  CD1 LEU   473      15.854  22.782  66.961  1.00 57.23           C  
ATOM   3636  CD2 LEU   473      17.009  22.320  69.126  1.00 59.28           C  
ATOM   3637  N   ALA   474      16.327  20.142  64.725  1.00 54.50           N  
ATOM   3638  CA  ALA   474      17.463  19.871  63.839  1.00 52.49           C  
ATOM   3639  C   ALA   474      18.077  21.167  63.396  1.00 53.04           C  
ATOM   3640  O   ALA   474      17.388  22.015  62.846  1.00 53.89           O  
ATOM   3641  CB  ALA   474      17.011  19.097  62.617  1.00 52.75           C  
ATOM   3642  N   VAL   475      19.373  21.342  63.603  1.00 52.65           N  
ATOM   3643  CA  VAL   475      19.961  22.595  63.190  1.00 52.65           C  
ATOM   3644  C   VAL   475      21.160  22.484  62.286  1.00 53.23           C  
ATOM   3645  O   VAL   475      22.094  21.755  62.569  1.00 52.96           O  
ATOM   3646  CB  VAL   475      20.290  23.498  64.413  1.00 52.11           C  
ATOM   3647  CG1 VAL   475      20.180  22.713  65.690  1.00 52.05           C  
ATOM   3648  CG2 VAL   475      21.664  24.129  64.251  1.00 51.25           C  
ATOM   3649  N   GLY   476      21.103  23.229  61.186  1.00 54.26           N  
ATOM   3650  CA  GLY   476      22.183  23.238  60.223  1.00 59.06           C  
ATOM   3651  C   GLY   476      23.190  24.330  60.532  1.00 62.56           C  
ATOM   3652  O   GLY   476      22.830  25.365  61.097  1.00 63.14           O  
ATOM   3653  N   PHE   477      24.454  24.091  60.189  1.00 64.87           N  
ATOM   3654  CA  PHE   477      25.509  25.066  60.426  1.00 67.11           C  
ATOM   3655  C   PHE   477      26.152  25.454  59.115  1.00 70.31           C  
ATOM   3656  O   PHE   477      26.238  24.652  58.189  1.00 70.80           O  
ATOM   3657  CB  PHE   477      26.564  24.519  61.373  1.00 65.03           C  
ATOM   3658  CG  PHE   477      26.047  24.253  62.738  1.00 65.27           C  
ATOM   3659  CD1 PHE   477      25.230  23.158  62.979  1.00 66.15           C  
ATOM   3660  CD2 PHE   477      26.319  25.127  63.775  1.00 64.65           C  
ATOM   3661  CE1 PHE   477      24.685  22.942  64.244  1.00 67.44           C  
ATOM   3662  CE2 PHE   477      25.782  24.926  65.040  1.00 66.38           C  
ATOM   3663  CZ  PHE   477      24.960  23.831  65.279  1.00 66.69           C  
ATOM   3664  N   ASP   478      26.605  26.697  59.040  1.00 74.12           N  
ATOM   3665  CA  ASP   478      27.212  27.187  57.821  1.00 77.69           C  
ATOM   3666  C   ASP   478      28.273  28.250  58.077  1.00 79.17           C  
ATOM   3667  O   ASP   478      28.054  29.205  58.829  1.00 78.70           O  
ATOM   3668  CB  ASP   478      26.118  27.737  56.905  1.00 79.42           C  
ATOM   3669  CG  ASP   478      26.672  28.385  55.665  1.00 81.71           C  
ATOM   3670  OD1 ASP   478      27.332  29.431  55.796  1.00 84.66           O  
ATOM   3671  OD2 ASP   478      26.455  27.853  54.560  1.00 83.29           O  
ATOM   3672  N   ALA   479      29.429  28.062  57.443  1.00 80.41           N  
ATOM   3673  CA  ALA   479      30.548  28.993  57.553  1.00 81.96           C  
ATOM   3674  C   ALA   479      30.863  29.489  56.134  1.00 82.56           C  
ATOM   3675  O   ALA   479      31.940  30.022  55.858  1.00 82.11           O  
ATOM   3676  CB  ALA   479      31.761  28.289  58.174  1.00 80.91           C  
ATOM   3677  N   GLY   480      29.891  29.291  55.248  1.00 83.91           N  
ATOM   3678  CA  GLY   480      29.998  29.702  53.857  1.00 85.47           C  
ATOM   3679  C   GLY   480      31.371  29.636  53.225  1.00 86.12           C  
ATOM   3680  O   GLY   480      32.058  30.646  53.139  1.00 86.47           O  
ATOM   3681  N   GLY   481      31.773  28.453  52.778  1.00 87.37           N  
ATOM   3682  CA  GLY   481      33.072  28.310  52.149  1.00 88.80           C  
ATOM   3683  C   GLY   481      34.242  28.308  53.115  1.00 90.41           C  
ATOM   3684  O   GLY   481      35.184  27.532  52.942  1.00 89.49           O  
ATOM   3685  N   ARG   482      34.187  29.165  54.135  1.00 92.39           N  
ATOM   3686  CA  ARG   482      35.268  29.256  55.123  1.00 94.48           C  
ATOM   3687  C   ARG   482      35.453  27.955  55.904  1.00 93.95           C  
ATOM   3688  O   ARG   482      34.539  27.503  56.590  1.00 95.02           O  
ATOM   3689  CB  ARG   482      35.010  30.408  56.105  1.00 96.04           C  
ATOM   3690  CG  ARG   482      34.852  31.768  55.439  1.00100.17           C  
ATOM   3691  CD  ARG   482      35.232  32.923  56.366  1.00102.80           C  
ATOM   3692  NE  ARG   482      36.649  32.880  56.721  1.00105.41           N  
ATOM   3693  CZ  ARG   482      37.146  32.178  57.734  1.00107.00           C  
ATOM   3694  NH1 ARG   482      36.339  31.462  58.509  1.00107.90           N  
ATOM   3695  NH2 ARG   482      38.450  32.186  57.969  1.00108.18           N  
ATOM   3696  N   GLU   483      36.643  27.369  55.808  1.00 92.62           N  
ATOM   3697  CA  GLU   483      36.943  26.116  56.480  1.00 91.36           C  
ATOM   3698  C   GLU   483      37.040  26.177  58.012  1.00 91.43           C  
ATOM   3699  O   GLU   483      37.798  25.412  58.605  1.00 91.71           O  
ATOM   3700  CB  GLU   483      38.225  25.523  55.904  1.00 90.34           C  
ATOM   3701  N   SER   484      36.280  27.063  58.655  1.00 91.34           N  
ATOM   3702  CA  SER   484      36.277  27.159  60.126  1.00 91.48           C  
ATOM   3703  C   SER   484      35.218  28.157  60.599  1.00 90.68           C  
ATOM   3704  O   SER   484      34.873  29.083  59.871  1.00 89.54           O  
ATOM   3705  CB  SER   484      37.642  27.588  60.657  1.00 91.50           C  
ATOM   3706  OG  SER   484      37.767  28.998  60.630  1.00 94.91           O  
ATOM   3707  N   PHE   485      34.722  27.985  61.822  1.00 90.60           N  
ATOM   3708  CA  PHE   485      33.676  28.865  62.341  1.00 91.42           C  
ATOM   3709  C   PHE   485      34.054  30.101  63.135  1.00 92.33           C  
ATOM   3710  O   PHE   485      33.250  30.608  63.917  1.00 90.61           O  
ATOM   3711  CB  PHE   485      32.675  28.074  63.170  1.00 91.82           C  
ATOM   3712  CG  PHE   485      31.661  27.351  62.349  1.00 92.06           C  
ATOM   3713  CD1 PHE   485      31.955  26.114  61.788  1.00 92.59           C  
ATOM   3714  CD2 PHE   485      30.429  27.933  62.086  1.00 91.29           C  
ATOM   3715  CE1 PHE   485      31.038  25.469  60.970  1.00 92.29           C  
ATOM   3716  CE2 PHE   485      29.505  27.299  61.271  1.00 91.80           C  
ATOM   3717  CZ  PHE   485      29.809  26.062  60.710  1.00 92.15           C  
ATOM   3718  N   ARG   486      35.266  30.591  62.947  1.00 94.68           N  
ATOM   3719  CA  ARG   486      35.687  31.792  63.645  1.00 96.24           C  
ATOM   3720  C   ARG   486      35.109  32.893  62.776  1.00 96.95           C  
ATOM   3721  O   ARG   486      34.168  33.614  63.130  1.00 97.63           O  
ATOM   3722  CB  ARG   486      37.211  31.874  63.629  1.00 96.08           C  
ATOM   3723  CG  ARG   486      37.823  32.746  64.693  1.00 96.93           C  
ATOM   3724  CD  ARG   486      38.939  33.582  64.100  1.00 99.26           C  
ATOM   3725  NE  ARG   486      40.310  33.184  64.428  1.00101.19           N  
ATOM   3726  CZ  ARG   486      41.373  33.916  64.095  1.00102.21           C  
ATOM   3727  NH1 ARG   486      41.203  35.047  63.442  1.00102.28           N  
ATOM   3728  NH2 ARG   486      42.603  33.543  64.414  1.00101.93           N  
ATOM   3729  N   PHE   487      35.666  32.959  61.585  1.00 96.79           N  
ATOM   3730  CA  PHE   487      35.287  33.962  60.636  1.00 96.17           C  
ATOM   3731  C   PHE   487      33.946  33.831  60.022  1.00 95.34           C  
ATOM   3732  O   PHE   487      33.775  33.531  58.835  1.00 96.58           O  
ATOM   3733  CB  PHE   487      36.393  34.052  59.634  1.00 96.46           C  
ATOM   3734  CG  PHE   487      37.624  34.505  60.273  1.00 96.31           C  
ATOM   3735  CD1 PHE   487      37.539  35.580  61.139  1.00 96.10           C  
ATOM   3736  CD2 PHE   487      38.842  33.895  60.060  1.00 96.33           C  
ATOM   3737  CE1 PHE   487      38.627  36.024  61.819  1.00 95.50           C  
ATOM   3738  CE2 PHE   487      39.954  34.342  60.746  1.00 95.96           C  
ATOM   3739  CZ  PHE   487      39.837  35.422  61.606  1.00 94.98           C  
ATOM   3740  N   GLY   488      32.983  34.111  60.879  1.00 93.35           N  
ATOM   3741  CA  GLY   488      31.602  34.022  60.495  1.00 90.98           C  
ATOM   3742  C   GLY   488      30.999  32.840  61.214  1.00 88.15           C  
ATOM   3743  O   GLY   488      31.613  32.224  62.085  1.00 88.43           O  
ATOM   3744  N   GLY   489      29.781  32.517  60.832  1.00 85.17           N  
ATOM   3745  CA  GLY   489      29.104  31.415  61.459  1.00 81.80           C  
ATOM   3746  C   GLY   489      27.641  31.759  61.468  1.00 79.88           C  
ATOM   3747  O   GLY   489      27.248  32.821  61.927  1.00 80.37           O  
ATOM   3748  N   ALA   490      26.832  30.865  60.930  1.00 77.48           N  
ATOM   3749  CA  ALA   490      25.405  31.074  60.876  1.00 73.63           C  
ATOM   3750  C   ALA   490      24.767  29.719  61.097  1.00 72.05           C  
ATOM   3751  O   ALA   490      25.328  28.691  60.737  1.00 70.51           O  
ATOM   3752  CB  ALA   490      25.013  31.632  59.532  1.00 72.13           C  
ATOM   3753  N   ALA   491      23.584  29.729  61.685  1.00 70.90           N  
ATOM   3754  CA  ALA   491      22.876  28.507  61.980  1.00 70.01           C  
ATOM   3755  C   ALA   491      21.375  28.687  61.790  1.00 70.81           C  
ATOM   3756  O   ALA   491      20.829  29.749  62.096  1.00 70.49           O  
ATOM   3757  CB  ALA   491      23.167  28.100  63.413  1.00 69.19           C  
ATOM   3758  N   CYS   492      20.716  27.656  61.267  1.00 70.70           N  
ATOM   3759  CA  CYS   492      19.268  27.689  61.096  1.00 71.54           C  
ATOM   3760  C   CYS   492      18.709  26.470  61.822  1.00 70.66           C  
ATOM   3761  O   CYS   492      19.222  25.366  61.692  1.00 69.51           O  
ATOM   3762  CB  CYS   492      18.872  27.642  59.623  1.00 72.08           C  
ATOM   3763  SG  CYS   492      19.323  26.117  58.795  1.00 79.76           S  
ATOM   3764  N   ALA   493      17.658  26.686  62.597  1.00 70.90           N  
ATOM   3765  CA  ALA   493      17.042  25.620  63.357  1.00 71.94           C  
ATOM   3766  C   ALA   493      15.631  25.349  62.873  1.00 72.42           C  
ATOM   3767  O   ALA   493      14.874  26.275  62.601  1.00 73.23           O  
ATOM   3768  CB  ALA   493      17.018  25.988  64.835  1.00 71.98           C  
ATOM   3769  N   VAL   494      15.284  24.075  62.761  1.00 72.69           N  
ATOM   3770  CA  VAL   494      13.954  23.693  62.339  1.00 73.22           C  
ATOM   3771  C   VAL   494      13.369  22.909  63.495  1.00 74.42           C  
ATOM   3772  O   VAL   494      13.993  21.992  64.021  1.00 72.90           O  
ATOM   3773  CB  VAL   494      13.998  22.855  61.058  1.00 73.08           C  
ATOM   3774  CG1 VAL   494      12.607  22.362  60.698  1.00 73.65           C  
ATOM   3775  CG2 VAL   494      14.546  23.704  59.929  1.00 73.27           C  
ATOM   3776  N   GLY   495      12.167  23.302  63.895  1.00 76.86           N  
ATOM   3777  CA  GLY   495      11.503  22.680  65.017  1.00 79.92           C  
ATOM   3778  C   GLY   495      11.186  21.209  64.940  1.00 82.73           C  
ATOM   3779  O   GLY   495      10.473  20.707  65.809  1.00 83.86           O  
ATOM   3780  N   GLY   496      11.711  20.504  63.941  1.00 85.18           N  
ATOM   3781  CA  GLY   496      11.417  19.083  63.830  1.00 87.81           C  
ATOM   3782  C   GLY   496       9.960  18.971  63.436  1.00 90.22           C  
ATOM   3783  O   GLY   496       9.078  19.504  64.123  1.00 91.12           O  
ATOM   3784  N   ASP   497       9.690  18.287  62.331  1.00 90.96           N  
ATOM   3785  CA  ASP   497       8.321  18.178  61.860  1.00 91.31           C  
ATOM   3786  C   ASP   497       7.727  19.594  61.684  1.00 92.12           C  
ATOM   3787  O   ASP   497       6.687  19.935  62.260  1.00 90.73           O  
ATOM   3788  CB  ASP   497       7.486  17.354  62.843  1.00 90.84           C  
ATOM   3789  N   GLY   498       8.444  20.417  60.916  1.00 93.38           N  
ATOM   3790  CA  GLY   498       8.013  21.772  60.581  1.00 95.00           C  
ATOM   3791  C   GLY   498       7.860  22.935  61.552  1.00 95.84           C  
ATOM   3792  O   GLY   498       7.714  24.068  61.096  1.00 95.78           O  
ATOM   3793  N   GLY   499       7.873  22.697  62.860  1.00 96.64           N  
ATOM   3794  CA  GLY   499       7.719  23.808  63.790  1.00 97.80           C  
ATOM   3795  C   GLY   499       8.861  24.815  63.729  1.00 98.62           C  
ATOM   3796  O   GLY   499       9.339  25.281  64.769  1.00 98.61           O  
ATOM   3797  N   HIS   500       9.287  25.157  62.512  1.00 98.19           N  
ATOM   3798  CA  HIS   500      10.393  26.089  62.270  1.00 99.04           C  
ATOM   3799  C   HIS   500      10.815  27.008  63.436  1.00100.49           C  
ATOM   3800  O   HIS   500      10.015  27.778  63.941  1.00101.06           O  
ATOM   3801  CB  HIS   500      10.078  26.979  61.077  1.00 96.88           C  
ATOM   3802  CG  HIS   500      11.241  27.810  60.651  1.00 96.37           C  
ATOM   3803  ND1 HIS   500      12.205  27.345  59.783  1.00 97.02           N  
ATOM   3804  CD2 HIS   500      11.648  29.040  61.040  1.00 96.19           C  
ATOM   3805  CE1 HIS   500      13.158  28.251  59.657  1.00 96.31           C  
ATOM   3806  NE2 HIS   500      12.845  29.290  60.411  1.00 96.67           N  
ATOM   3807  N   LEU   501      12.086  26.932  63.821  1.00101.76           N  
ATOM   3808  CA  LEU   501      12.651  27.742  64.895  1.00102.44           C  
ATOM   3809  C   LEU   501      13.311  28.987  64.269  1.00102.21           C  
ATOM   3810  O   LEU   501      12.643  29.684  63.524  1.00103.94           O  
ATOM   3811  CB  LEU   501      13.667  26.930  65.671  1.00102.72           C  
ATOM   3812  CG  LEU   501      14.103  27.558  66.982  1.00103.11           C  
ATOM   3813  CD1 LEU   501      12.873  27.701  67.863  1.00102.96           C  
ATOM   3814  CD2 LEU   501      15.165  26.699  67.644  1.00103.63           C  
ATOM   3815  N   LEU   502      14.593  29.295  64.542  1.00101.65           N  
ATOM   3816  CA  LEU   502      15.233  30.392  63.806  1.00100.88           C  
ATOM   3817  C   LEU   502      16.549  30.333  63.135  1.00 98.85           C  
ATOM   3818  O   LEU   502      17.147  29.302  62.825  1.00 97.87           O  
ATOM   3819  CB  LEU   502      15.087  31.793  64.352  1.00102.99           C  
ATOM   3820  N   TRP   503      16.965  31.545  62.892  1.00 96.87           N  
ATOM   3821  CA  TRP   503      18.125  31.843  62.159  1.00 95.68           C  
ATOM   3822  C   TRP   503      18.983  32.665  62.982  1.00 95.58           C  
ATOM   3823  O   TRP   503      18.500  33.601  63.562  1.00 95.38           O  
ATOM   3824  CB  TRP   503      17.801  32.754  61.088  1.00 93.80           C  
ATOM   3825  CG  TRP   503      18.775  32.622  60.239  1.00 92.23           C  
ATOM   3826  CD1 TRP   503      18.970  31.553  59.464  1.00 91.63           C  
ATOM   3827  CD2 TRP   503      19.814  33.545  59.973  1.00 92.13           C  
ATOM   3828  NE1 TRP   503      20.073  31.718  58.703  1.00 91.49           N  
ATOM   3829  CE2 TRP   503      20.616  32.944  58.982  1.00 92.12           C  
ATOM   3830  CE3 TRP   503      20.150  34.832  60.459  1.00 91.53           C  
ATOM   3831  CZ2 TRP   503      21.739  33.567  58.448  1.00 91.22           C  
ATOM   3832  CZ3 TRP   503      21.267  35.459  59.934  1.00 90.71           C  
ATOM   3833  CH2 TRP   503      22.054  34.817  58.925  1.00 91.00           C  
ATOM   3834  N   THR   504      20.269  32.422  62.984  1.00 96.21           N  
ATOM   3835  CA  THR   504      21.006  33.333  63.795  1.00 96.61           C  
ATOM   3836  C   THR   504      22.453  33.241  63.468  1.00 96.47           C  
ATOM   3837  O   THR   504      22.849  32.490  62.594  1.00 95.90           O  
ATOM   3838  CB  THR   504      20.796  32.999  65.235  1.00 97.21           C  
ATOM   3839  OG1 THR   504      21.339  34.045  66.053  1.00 97.80           O  
ATOM   3840  CG2 THR   504      21.545  31.694  65.521  1.00 96.14           C  
ATOM   3841  N   LEU   505      23.248  34.003  64.193  1.00 96.60           N  
ATOM   3842  CA  LEU   505      24.693  33.916  64.085  1.00 96.62           C  
ATOM   3843  C   LEU   505      25.296  34.488  65.329  1.00 97.06           C  
ATOM   3844  O   LEU   505      24.644  35.237  66.053  1.00 96.94           O  
ATOM   3845  CB  LEU   505      25.281  34.583  62.840  1.00 95.18           C  
ATOM   3846  CG  LEU   505      24.726  35.876  62.324  1.00 94.25           C  
ATOM   3847  CD1 LEU   505      23.855  35.480  61.207  1.00 93.84           C  
ATOM   3848  CD2 LEU   505      23.998  36.634  63.414  1.00 94.38           C  
ATOM   3849  N   PRO   506      26.564  34.152  65.577  1.00 97.45           N  
ATOM   3850  CA  PRO   506      27.325  34.585  66.742  1.00 97.82           C  
ATOM   3851  C   PRO   506      27.045  35.991  67.219  1.00 98.30           C  
ATOM   3852  O   PRO   506      27.296  36.965  66.511  1.00 98.51           O  
ATOM   3853  CB  PRO   506      28.774  34.398  66.297  1.00 97.52           C  
ATOM   3854  CG  PRO   506      28.677  33.301  65.281  1.00 97.67           C  
ATOM   3855  CD  PRO   506      27.486  33.727  64.509  1.00 97.61           C  
ATOM   3856  N   GLU   507      26.512  36.078  68.432  1.00 99.24           N  
ATOM   3857  CA  GLU   507      26.225  37.356  69.064  1.00100.50           C  
ATOM   3858  C   GLU   507      27.517  38.183  69.105  1.00100.40           C  
ATOM   3859  O   GLU   507      28.518  37.798  68.505  1.00101.08           O  
ATOM   3860  CB  GLU   507      25.710  37.111  70.480  1.00100.99           C  
ATOM   3861  CG  GLU   507      24.337  36.473  70.551  1.00102.84           C  
ATOM   3862  CD  GLU   507      23.236  37.492  70.776  1.00103.79           C  
ATOM   3863  OE1 GLU   507      22.296  37.183  71.539  1.00104.00           O  
ATOM   3864  OE2 GLU   507      23.304  38.596  70.191  1.00105.06           O  
ATOM   3865  N   ALA   508      27.512  39.298  69.830  1.00100.03           N  
ATOM   3866  CA  ALA   508      28.700  40.146  69.890  1.00 99.67           C  
ATOM   3867  C   ALA   508      29.566  40.049  71.148  1.00 99.04           C  
ATOM   3868  O   ALA   508      29.258  40.612  72.198  1.00 98.30           O  
ATOM   3869  CB  ALA   508      28.313  41.604  69.647  1.00 98.75           C  
ATOM   3870  N   GLN   509      30.668  39.333  71.033  1.00 98.74           N  
ATOM   3871  CA  GLN   509      31.581  39.225  72.145  1.00 98.53           C  
ATOM   3872  C   GLN   509      32.857  39.898  71.733  1.00 98.42           C  
ATOM   3873  O   GLN   509      32.955  40.438  70.640  1.00 98.71           O  
ATOM   3874  CB  GLN   509      31.897  37.808  72.412  1.00 98.40           C  
ATOM   3875  CG  GLN   509      31.501  37.351  73.705  1.00 98.23           C  
ATOM   3876  CD  GLN   509      31.629  35.903  73.669  1.00 98.32           C  
ATOM   3877  OE1 GLN   509      30.653  35.186  73.457  1.00 98.50           O  
ATOM   3878  NE2 GLN   509      32.860  35.434  73.784  1.00 97.43           N  
ATOM   3879  N   ALA   510      33.876  39.822  72.567  1.00 97.78           N  
ATOM   3880  CA  ALA   510      35.071  40.521  72.175  1.00 96.97           C  
ATOM   3881  C   ALA   510      36.388  39.821  72.388  1.00 95.63           C  
ATOM   3882  O   ALA   510      36.670  39.300  73.468  1.00 95.98           O  
ATOM   3883  CB  ALA   510      35.088  41.890  72.845  1.00 98.22           C  
ATOM   3884  N   GLY   511      37.200  39.845  71.336  1.00 93.45           N  
ATOM   3885  CA  GLY   511      38.506  39.230  71.388  1.00 91.43           C  
ATOM   3886  C   GLY   511      38.561  38.087  70.411  1.00 90.60           C  
ATOM   3887  O   GLY   511      37.519  37.671  69.912  1.00 90.46           O  
ATOM   3888  N   GLU   512      39.763  37.588  70.127  1.00 89.80           N  
ATOM   3889  CA  GLU   512      39.913  36.472  69.207  1.00 89.31           C  
ATOM   3890  C   GLU   512      38.947  35.368  69.637  1.00 88.94           C  
ATOM   3891  O   GLU   512      38.795  35.084  70.830  1.00 88.33           O  
ATOM   3892  CB  GLU   512      41.360  35.962  69.210  1.00 90.79           C  
ATOM   3893  CG  GLU   512      41.551  34.609  68.510  1.00 92.23           C  
ATOM   3894  CD  GLU   512      43.012  34.263  68.269  1.00 93.52           C  
ATOM   3895  OE1 GLU   512      43.893  34.922  68.871  1.00 93.79           O  
ATOM   3896  OE2 GLU   512      43.279  33.327  67.480  1.00 93.98           O  
ATOM   3897  N   ARG   513      38.299  34.746  68.659  1.00 88.19           N  
ATOM   3898  CA  ARG   513      37.316  33.712  68.940  1.00 87.95           C  
ATOM   3899  C   ARG   513      37.785  32.282  68.645  1.00 87.97           C  
ATOM   3900  O   ARG   513      38.332  31.993  67.579  1.00 87.55           O  
ATOM   3901  CB  ARG   513      36.039  34.018  68.147  1.00 87.51           C  
ATOM   3902  CG  ARG   513      34.753  33.596  68.824  1.00 88.14           C  
ATOM   3903  CD  ARG   513      34.147  34.711  69.659  1.00 89.44           C  
ATOM   3904  NE  ARG   513      32.872  34.287  70.228  1.00 91.22           N  
ATOM   3905  CZ  ARG   513      32.764  33.377  71.189  1.00 93.32           C  
ATOM   3906  NH1 ARG   513      33.858  32.810  71.690  1.00 94.09           N  
ATOM   3907  NH2 ARG   513      31.567  33.020  71.639  1.00 93.85           N  
ATOM   3908  N   ILE   514      37.562  31.395  69.609  1.00 88.83           N  
ATOM   3909  CA  ILE   514      37.917  29.987  69.481  1.00 89.59           C  
ATOM   3910  C   ILE   514      36.683  29.309  68.842  1.00 88.94           C  
ATOM   3911  O   ILE   514      35.598  29.291  69.433  1.00 88.81           O  
ATOM   3912  CB  ILE   514      38.254  29.406  70.893  1.00 91.15           C  
ATOM   3913  CG1 ILE   514      38.811  27.977  70.781  1.00 93.84           C  
ATOM   3914  CG2 ILE   514      37.034  29.503  71.806  1.00 91.95           C  
ATOM   3915  CD1 ILE   514      37.828  26.912  70.291  1.00 95.43           C  
ATOM   3916  N   PRO   515      36.832  28.759  67.617  1.00 88.22           N  
ATOM   3917  CA  PRO   515      35.729  28.097  66.901  1.00 87.35           C  
ATOM   3918  C   PRO   515      34.720  27.298  67.746  1.00 86.17           C  
ATOM   3919  O   PRO   515      33.506  27.497  67.621  1.00 85.92           O  
ATOM   3920  CB  PRO   515      36.453  27.240  65.846  1.00 86.45           C  
ATOM   3921  CG  PRO   515      37.851  27.105  66.379  1.00 88.11           C  
ATOM   3922  CD  PRO   515      38.114  28.470  66.953  1.00 88.10           C  
ATOM   3923  N   GLN   516      35.221  26.410  68.602  1.00 84.15           N  
ATOM   3924  CA  GLN   516      34.367  25.593  69.463  1.00 82.25           C  
ATOM   3925  C   GLN   516      33.397  26.432  70.289  1.00 80.38           C  
ATOM   3926  O   GLN   516      32.336  25.960  70.697  1.00 79.49           O  
ATOM   3927  CB  GLN   516      35.226  24.744  70.405  1.00 83.08           C  
ATOM   3928  CG  GLN   516      35.941  23.571  69.743  1.00 84.55           C  
ATOM   3929  CD  GLN   516      36.934  22.905  70.680  1.00 85.58           C  
ATOM   3930  OE1 GLN   516      37.185  21.706  70.585  1.00 85.77           O  
ATOM   3931  NE2 GLN   516      37.515  23.689  71.587  1.00 85.81           N  
ATOM   3932  N   GLU   517      33.770  27.679  70.544  1.00 78.86           N  
ATOM   3933  CA  GLU   517      32.927  28.573  71.318  1.00 76.82           C  
ATOM   3934  C   GLU   517      31.854  29.177  70.400  1.00 75.90           C  
ATOM   3935  O   GLU   517      30.717  29.418  70.832  1.00 74.44           O  
ATOM   3936  CB  GLU   517      33.780  29.662  71.959  1.00 76.50           C  
ATOM   3937  N   VAL   518      32.218  29.415  69.139  1.00 73.51           N  
ATOM   3938  CA  VAL   518      31.269  29.955  68.180  1.00 73.34           C  
ATOM   3939  C   VAL   518      30.178  28.915  68.048  1.00 72.98           C  
ATOM   3940  O   VAL   518      29.022  29.143  68.436  1.00 72.16           O  
ATOM   3941  CB  VAL   518      31.897  30.163  66.771  1.00 74.75           C  
ATOM   3942  CG1 VAL   518      30.785  30.226  65.694  1.00 73.79           C  
ATOM   3943  CG2 VAL   518      32.703  31.450  66.741  1.00 75.01           C  
ATOM   3944  N   VAL   519      30.579  27.773  67.490  1.00 72.38           N  
ATOM   3945  CA  VAL   519      29.697  26.647  67.276  1.00 71.36           C  
ATOM   3946  C   VAL   519      28.810  26.467  68.500  1.00 71.94           C  
ATOM   3947  O   VAL   519      27.582  26.441  68.375  1.00 73.35           O  
ATOM   3948  CB  VAL   519      30.512  25.366  66.997  1.00 71.25           C  
ATOM   3949  CG1 VAL   519      29.596  24.159  66.930  1.00 71.23           C  
ATOM   3950  CG2 VAL   519      31.254  25.507  65.678  1.00 70.30           C  
ATOM   3951  N   TRP   520      29.409  26.373  69.684  1.00 70.51           N  
ATOM   3952  CA  TRP   520      28.606  26.208  70.884  1.00 70.26           C  
ATOM   3953  C   TRP   520      27.534  27.287  71.023  1.00 71.83           C  
ATOM   3954  O   TRP   520      26.366  26.981  71.264  1.00 70.83           O  
ATOM   3955  CB  TRP   520      29.470  26.231  72.137  1.00 69.03           C  
ATOM   3956  CG  TRP   520      28.634  26.153  73.405  1.00 69.51           C  
ATOM   3957  CD1 TRP   520      28.813  26.876  74.554  1.00 69.58           C  
ATOM   3958  CD2 TRP   520      27.478  25.326  73.634  1.00 68.30           C  
ATOM   3959  NE1 TRP   520      27.843  26.555  75.475  1.00 68.00           N  
ATOM   3960  CE2 TRP   520      27.012  25.609  74.937  1.00 67.58           C  
ATOM   3961  CE3 TRP   520      26.791  24.379  72.863  1.00 66.74           C  
ATOM   3962  CZ2 TRP   520      25.892  24.979  75.486  1.00 67.64           C  
ATOM   3963  CZ3 TRP   520      25.682  23.756  73.409  1.00 66.32           C  
ATOM   3964  CH2 TRP   520      25.242  24.058  74.708  1.00 66.50           C  
ATOM   3965  N   ASP   521      27.927  28.552  70.882  1.00 74.28           N  
ATOM   3966  CA  ASP   521      26.964  29.645  71.018  1.00 75.89           C  
ATOM   3967  C   ASP   521      25.823  29.609  69.995  1.00 75.86           C  
ATOM   3968  O   ASP   521      24.672  29.874  70.344  1.00 75.73           O  
ATOM   3969  CB  ASP   521      27.676  31.008  71.001  1.00 76.97           C  
ATOM   3970  CG  ASP   521      28.237  31.387  72.371  1.00 79.73           C  
ATOM   3971  OD1 ASP   521      27.683  30.907  73.392  1.00 80.15           O  
ATOM   3972  OD2 ASP   521      29.215  32.169  72.440  1.00 80.34           O  
ATOM   3973  N   LEU   522      26.122  29.279  68.742  1.00 75.42           N  
ATOM   3974  CA  LEU   522      25.059  29.193  67.742  1.00 75.16           C  
ATOM   3975  C   LEU   522      23.983  28.198  68.215  1.00 76.83           C  
ATOM   3976  O   LEU   522      22.783  28.486  68.190  1.00 77.30           O  
ATOM   3977  CB  LEU   522      25.632  28.738  66.404  1.00 71.39           C  
ATOM   3978  CG  LEU   522      26.544  29.754  65.734  1.00 68.02           C  
ATOM   3979  CD1 LEU   522      27.111  29.196  64.449  1.00 65.86           C  
ATOM   3980  CD2 LEU   522      25.738  30.997  65.462  1.00 67.48           C  
ATOM   3981  N   LEU   523      24.430  27.028  68.653  1.00 77.61           N  
ATOM   3982  CA  LEU   523      23.535  25.998  69.138  1.00 78.18           C  
ATOM   3983  C   LEU   523      22.894  26.481  70.424  1.00 79.47           C  
ATOM   3984  O   LEU   523      21.709  26.248  70.664  1.00 80.21           O  
ATOM   3985  CB  LEU   523      24.330  24.719  69.397  1.00 78.76           C  
ATOM   3986  CG  LEU   523      23.613  23.488  69.944  1.00 77.73           C  
ATOM   3987  CD1 LEU   523      22.495  23.095  68.994  1.00 77.40           C  
ATOM   3988  CD2 LEU   523      24.618  22.360  70.113  1.00 76.61           C  
ATOM   3989  N   GLU   524      23.696  27.146  71.250  1.00 80.37           N  
ATOM   3990  CA  GLU   524      23.243  27.684  72.529  1.00 81.70           C  
ATOM   3991  C   GLU   524      22.000  28.526  72.311  1.00 82.34           C  
ATOM   3992  O   GLU   524      21.034  28.434  73.072  1.00 82.93           O  
ATOM   3993  CB  GLU   524      24.360  28.538  73.153  1.00 83.30           C  
ATOM   3994  CG  GLU   524      23.963  29.545  74.252  1.00 84.85           C  
ATOM   3995  CD  GLU   524      23.498  28.890  75.544  1.00 86.61           C  
ATOM   3996  OE1 GLU   524      23.533  29.546  76.612  1.00 85.70           O  
ATOM   3997  OE2 GLU   524      23.081  27.716  75.487  1.00 88.43           O  
ATOM   3998  N   GLU   525      22.013  29.334  71.256  1.00 81.97           N  
ATOM   3999  CA  GLU   525      20.875  30.194  70.975  1.00 81.91           C  
ATOM   4000  C   GLU   525      19.645  29.412  70.507  1.00 80.80           C  
ATOM   4001  O   GLU   525      18.531  29.616  71.009  1.00 79.38           O  
ATOM   4002  CB  GLU   525      21.260  31.247  69.936  1.00 83.38           C  
ATOM   4003  CG  GLU   525      20.441  32.510  70.076  1.00 86.89           C  
ATOM   4004  CD  GLU   525      20.401  33.011  71.519  1.00 87.75           C  
ATOM   4005  OE1 GLU   525      19.294  33.342  71.999  1.00 87.79           O  
ATOM   4006  OE2 GLU   525      21.469  33.074  72.169  1.00 88.20           O  
ATOM   4007  N   THR   526      19.858  28.510  69.552  1.00 79.63           N  
ATOM   4008  CA  THR   526      18.785  27.692  69.004  1.00 77.67           C  
ATOM   4009  C   THR   526      18.027  26.958  70.114  1.00 77.02           C  
ATOM   4010  O   THR   526      16.808  26.833  70.059  1.00 75.80           O  
ATOM   4011  CB  THR   526      19.344  26.666  68.020  1.00 77.01           C  
ATOM   4012  OG1 THR   526      20.236  25.797  68.724  1.00 78.88           O  
ATOM   4013  CG2 THR   526      20.117  27.357  66.896  1.00 76.06           C  
ATOM   4014  N   LEU   527      18.745  26.481  71.124  1.00 76.63           N  
ATOM   4015  CA  LEU   527      18.100  25.767  72.218  1.00 76.55           C  
ATOM   4016  C   LEU   527      17.154  26.684  72.984  1.00 76.95           C  
ATOM   4017  O   LEU   527      16.076  26.259  73.413  1.00 77.15           O  
ATOM   4018  CB  LEU   527      19.141  25.173  73.165  1.00 76.23           C  
ATOM   4019  CG  LEU   527      20.082  24.134  72.549  1.00 77.11           C  
ATOM   4020  CD1 LEU   527      21.139  23.722  73.575  1.00 76.73           C  
ATOM   4021  CD2 LEU   527      19.280  22.925  72.073  1.00 75.80           C  
ATOM   4022  N   TRP   528      17.547  27.940  73.169  1.00 76.82           N  
ATOM   4023  CA  TRP   528      16.673  28.879  73.862  1.00 76.26           C  
ATOM   4024  C   TRP   528      15.479  29.172  72.967  1.00 77.32           C  
ATOM   4025  O   TRP   528      14.335  29.194  73.427  1.00 76.87           O  
ATOM   4026  CB  TRP   528      17.420  30.163  74.200  1.00 75.00           C  
ATOM   4027  CG  TRP   528      18.397  29.945  75.295  1.00 75.62           C  
ATOM   4028  CD1 TRP   528      19.747  30.104  75.232  1.00 75.27           C  
ATOM   4029  CD2 TRP   528      18.106  29.457  76.610  1.00 76.17           C  
ATOM   4030  NE1 TRP   528      20.320  29.739  76.427  1.00 76.88           N  
ATOM   4031  CE2 TRP   528      19.335  29.339  77.291  1.00 76.98           C  
ATOM   4032  CE3 TRP   528      16.921  29.106  77.279  1.00 77.38           C  
ATOM   4033  CZ2 TRP   528      19.422  28.880  78.618  1.00 78.64           C  
ATOM   4034  CZ3 TRP   528      17.000  28.649  78.597  1.00 78.35           C  
ATOM   4035  CH2 TRP   528      18.246  28.540  79.252  1.00 79.66           C  
ATOM   4036  N   ALA   529      15.741  29.387  71.682  1.00 77.74           N  
ATOM   4037  CA  ALA   529      14.657  29.644  70.750  1.00 79.31           C  
ATOM   4038  C   ALA   529      13.641  28.519  70.939  1.00 80.36           C  
ATOM   4039  O   ALA   529      12.466  28.759  71.240  1.00 81.49           O  
ATOM   4040  CB  ALA   529      15.183  29.648  69.326  1.00 78.43           C  
ATOM   4041  N   PHE   530      14.124  27.293  70.776  1.00 80.60           N  
ATOM   4042  CA  PHE   530      13.321  26.091  70.926  1.00 81.33           C  
ATOM   4043  C   PHE   530      12.674  26.068  72.319  1.00 83.94           C  
ATOM   4044  O   PHE   530      11.543  25.604  72.484  1.00 83.94           O  
ATOM   4045  CB  PHE   530      14.220  24.859  70.741  1.00 79.61           C  
ATOM   4046  CG  PHE   530      13.476  23.557  70.719  1.00 77.24           C  
ATOM   4047  CD1 PHE   530      13.018  23.029  69.525  1.00 76.57           C  
ATOM   4048  CD2 PHE   530      13.193  22.885  71.902  1.00 76.88           C  
ATOM   4049  CE1 PHE   530      12.289  21.854  69.509  1.00 77.77           C  
ATOM   4050  CE2 PHE   530      12.463  21.707  71.899  1.00 76.90           C  
ATOM   4051  CZ  PHE   530      12.006  21.189  70.699  1.00 77.74           C  
ATOM   4052  N   ARG   531      13.392  26.568  73.320  1.00 86.31           N  
ATOM   4053  CA  ARG   531      12.872  26.591  74.687  1.00 89.16           C  
ATOM   4054  C   ARG   531      11.599  27.447  74.738  1.00 89.27           C  
ATOM   4055  O   ARG   531      10.489  26.942  74.932  1.00 88.23           O  
ATOM   4056  CB  ARG   531      13.947  27.148  75.643  1.00 91.22           C  
ATOM   4057  CG  ARG   531      13.719  26.897  77.149  1.00 94.99           C  
ATOM   4058  CD  ARG   531      12.780  27.929  77.790  1.00 99.95           C  
ATOM   4059  NE  ARG   531      13.309  29.301  77.743  1.00103.15           N  
ATOM   4060  CZ  ARG   531      12.595  30.398  78.011  1.00103.99           C  
ATOM   4061  NH1 ARG   531      13.163  31.597  77.943  1.00103.11           N  
ATOM   4062  NH2 ARG   531      11.309  30.299  78.342  1.00104.81           N  
ATOM   4063  N   ARG   532      11.777  28.745  74.539  1.00 90.06           N  
ATOM   4064  CA  ARG   532      10.679  29.697  74.566  1.00 90.78           C  
ATOM   4065  C   ARG   532       9.505  29.270  73.687  1.00 91.49           C  
ATOM   4066  O   ARG   532       8.347  29.346  74.100  1.00 90.93           O  
ATOM   4067  CB  ARG   532      11.196  31.066  74.114  1.00 90.56           C  
ATOM   4068  CG  ARG   532      12.433  31.520  74.882  1.00 91.51           C  
ATOM   4069  CD  ARG   532      12.911  32.899  74.459  1.00 91.80           C  
ATOM   4070  NE  ARG   532      13.413  32.923  73.090  1.00 92.06           N  
ATOM   4071  CZ  ARG   532      14.688  33.121  72.768  1.00 92.90           C  
ATOM   4072  NH1 ARG   532      15.592  33.314  73.722  1.00 92.91           N  
ATOM   4073  NH2 ARG   532      15.061  33.127  71.494  1.00 92.13           N  
ATOM   4074  N   LYS   533       9.819  28.801  72.483  1.00 91.81           N  
ATOM   4075  CA  LYS   533       8.807  28.400  71.512  1.00 90.99           C  
ATOM   4076  C   LYS   533       8.140  27.041  71.729  1.00 90.59           C  
ATOM   4077  O   LYS   533       7.175  26.714  71.036  1.00 90.66           O  
ATOM   4078  CB  LYS   533       9.410  28.457  70.108  1.00 89.79           C  
ATOM   4079  N   ALA   534       8.624  26.248  72.677  1.00 90.15           N  
ATOM   4080  CA  ALA   534       8.028  24.934  72.888  1.00 90.13           C  
ATOM   4081  C   ALA   534       7.892  24.537  74.348  1.00 90.85           C  
ATOM   4082  O   ALA   534       7.286  23.510  74.660  1.00 90.94           O  
ATOM   4083  CB  ALA   534       8.830  23.883  72.141  1.00 89.69           C  
ATOM   4084  N   GLY   535       8.469  25.337  75.243  1.00 91.59           N  
ATOM   4085  CA  GLY   535       8.364  25.048  76.665  1.00 91.25           C  
ATOM   4086  C   GLY   535       9.485  24.268  77.337  1.00 90.98           C  
ATOM   4087  O   GLY   535       9.657  24.376  78.555  1.00 91.43           O  
ATOM   4088  N   ARG   536      10.248  23.485  76.573  1.00 89.52           N  
ATOM   4089  CA  ARG   536      11.338  22.697  77.156  1.00 87.32           C  
ATOM   4090  C   ARG   536      12.491  22.431  76.190  1.00 84.87           C  
ATOM   4091  O   ARG   536      12.369  22.649  74.983  1.00 85.26           O  
ATOM   4092  CB  ARG   536      10.789  21.362  77.690  1.00 87.33           C  
ATOM   4093  N   LEU   537      13.612  21.963  76.735  1.00 81.90           N  
ATOM   4094  CA  LEU   537      14.782  21.638  75.924  1.00 79.59           C  
ATOM   4095  C   LEU   537      14.517  20.365  75.136  1.00 77.21           C  
ATOM   4096  O   LEU   537      13.911  19.429  75.656  1.00 77.15           O  
ATOM   4097  CB  LEU   537      16.009  21.401  76.795  1.00 79.37           C  
ATOM   4098  CG  LEU   537      16.710  22.590  77.426  1.00 79.79           C  
ATOM   4099  CD1 LEU   537      15.787  23.269  78.416  1.00 81.45           C  
ATOM   4100  CD2 LEU   537      17.963  22.099  78.125  1.00 81.28           C  
ATOM   4101  N   PRO   538      14.973  20.311  73.872  1.00 74.74           N  
ATOM   4102  CA  PRO   538      14.785  19.138  73.012  1.00 73.61           C  
ATOM   4103  C   PRO   538      15.467  17.904  73.597  1.00 73.15           C  
ATOM   4104  O   PRO   538      16.556  17.991  74.166  1.00 72.71           O  
ATOM   4105  CB  PRO   538      15.401  19.578  71.683  1.00 72.37           C  
ATOM   4106  CG  PRO   538      16.429  20.567  72.098  1.00 72.50           C  
ATOM   4107  CD  PRO   538      15.741  21.353  73.171  1.00 73.30           C  
ATOM   4108  N   SER   539      14.816  16.755  73.467  1.00 72.78           N  
ATOM   4109  CA  SER   539      15.365  15.512  73.991  1.00 72.75           C  
ATOM   4110  C   SER   539      16.538  15.026  73.139  1.00 71.68           C  
ATOM   4111  O   SER   539      17.512  14.479  73.669  1.00 72.12           O  
ATOM   4112  CB  SER   539      14.278  14.434  74.042  1.00 74.13           C  
ATOM   4113  OG  SER   539      13.808  14.123  72.740  1.00 77.38           O  
ATOM   4114  N   ARG   540      16.436  15.236  71.828  1.00 68.92           N  
ATOM   4115  CA  ARG   540      17.468  14.831  70.878  1.00 67.12           C  
ATOM   4116  C   ARG   540      17.623  15.899  69.796  1.00 64.84           C  
ATOM   4117  O   ARG   540      16.636  16.471  69.352  1.00 64.93           O  
ATOM   4118  CB  ARG   540      17.086  13.496  70.234  1.00 67.89           C  
ATOM   4119  CG  ARG   540      18.160  12.919  69.342  1.00 69.06           C  
ATOM   4120  CD  ARG   540      17.915  11.442  69.014  1.00 71.29           C  
ATOM   4121  NE  ARG   540      19.176  10.789  68.662  1.00 72.80           N  
ATOM   4122  CZ  ARG   540      19.806   9.890  69.414  1.00 72.93           C  
ATOM   4123  NH1 ARG   540      19.296   9.495  70.577  1.00 70.54           N  
ATOM   4124  NH2 ARG   540      20.985   9.422  69.018  1.00 74.92           N  
ATOM   4125  N   VAL   541      18.852  16.159  69.363  1.00 61.35           N  
ATOM   4126  CA  VAL   541      19.086  17.176  68.348  1.00 58.28           C  
ATOM   4127  C   VAL   541      19.887  16.614  67.187  1.00 58.28           C  
ATOM   4128  O   VAL   541      20.731  15.754  67.374  1.00 58.90           O  
ATOM   4129  CB  VAL   541      19.847  18.393  68.953  1.00 57.68           C  
ATOM   4130  CG1 VAL   541      20.188  19.428  67.879  1.00 54.80           C  
ATOM   4131  CG2 VAL   541      19.006  19.026  70.010  1.00 55.24           C  
ATOM   4132  N   LEU   542      19.610  17.099  65.984  1.00 57.06           N  
ATOM   4133  CA  LEU   542      20.321  16.658  64.796  1.00 56.94           C  
ATOM   4134  C   LEU   542      21.162  17.841  64.336  1.00 56.72           C  
ATOM   4135  O   LEU   542      20.625  18.893  64.024  1.00 58.77           O  
ATOM   4136  CB  LEU   542      19.317  16.256  63.713  1.00 56.22           C  
ATOM   4137  CG  LEU   542      19.809  15.860  62.318  1.00 57.58           C  
ATOM   4138  CD1 LEU   542      20.749  14.658  62.345  1.00 56.27           C  
ATOM   4139  CD2 LEU   542      18.598  15.533  61.490  1.00 58.90           C  
ATOM   4140  N   LEU   543      22.478  17.674  64.316  1.00 56.66           N  
ATOM   4141  CA  LEU   543      23.391  18.747  63.918  1.00 56.10           C  
ATOM   4142  C   LEU   543      23.975  18.447  62.548  1.00 56.09           C  
ATOM   4143  O   LEU   543      24.721  17.494  62.385  1.00 56.87           O  
ATOM   4144  CB  LEU   543      24.525  18.882  64.944  1.00 55.20           C  
ATOM   4145  CG  LEU   543      24.104  18.851  66.425  1.00 56.09           C  
ATOM   4146  CD1 LEU   543      25.231  18.341  67.256  1.00 55.56           C  
ATOM   4147  CD2 LEU   543      23.687  20.207  66.906  1.00 56.77           C  
ATOM   4148  N   LEU   544      23.621  19.249  61.557  1.00 56.75           N  
ATOM   4149  CA  LEU   544      24.140  19.048  60.216  1.00 58.15           C  
ATOM   4150  C   LEU   544      25.177  20.106  59.926  1.00 60.68           C  
ATOM   4151  O   LEU   544      24.902  21.298  60.038  1.00 61.33           O  
ATOM   4152  CB  LEU   544      23.027  19.175  59.201  1.00 57.70           C  
ATOM   4153  CG  LEU   544      21.809  18.287  59.388  1.00 56.10           C  
ATOM   4154  CD1 LEU   544      20.869  18.544  58.229  1.00 56.53           C  
ATOM   4155  CD2 LEU   544      22.220  16.837  59.419  1.00 55.62           C  
ATOM   4156  N   ARG   545      26.369  19.671  59.544  1.00 63.27           N  
ATOM   4157  CA  ARG   545      27.458  20.594  59.249  1.00 65.62           C  
ATOM   4158  C   ARG   545      28.051  20.363  57.862  1.00 67.80           C  
ATOM   4159  O   ARG   545      27.917  19.279  57.289  1.00 67.01           O  
ATOM   4160  CB  ARG   545      28.569  20.422  60.275  1.00 65.31           C  
ATOM   4161  CG  ARG   545      29.429  19.197  60.023  1.00 64.23           C  
ATOM   4162  CD  ARG   545      30.524  19.041  61.068  1.00 66.70           C  
ATOM   4163  NE  ARG   545      31.487  18.022  60.658  1.00 69.61           N  
ATOM   4164  CZ  ARG   545      32.363  18.170  59.663  1.00 70.75           C  
ATOM   4165  NH1 ARG   545      32.408  19.313  58.981  1.00 70.21           N  
ATOM   4166  NH2 ARG   545      33.168  17.163  59.320  1.00 68.64           N  
ATOM   4167  N   ASP   546      28.719  21.386  57.336  1.00 70.58           N  
ATOM   4168  CA  ASP   546      29.361  21.278  56.030  1.00 73.43           C  
ATOM   4169  C   ASP   546      30.657  20.486  56.173  1.00 74.77           C  
ATOM   4170  O   ASP   546      31.460  20.735  57.073  1.00 74.95           O  
ATOM   4171  CB  ASP   546      29.671  22.665  55.460  1.00 74.73           C  
ATOM   4172  CG  ASP   546      30.552  22.598  54.230  1.00 74.97           C  
ATOM   4173  OD1 ASP   546      30.236  21.814  53.319  1.00 74.59           O  
ATOM   4174  OD2 ASP   546      31.562  23.325  54.171  1.00 78.37           O  
ATOM   4175  N   GLY   547      30.854  19.535  55.272  1.00 76.20           N  
ATOM   4176  CA  GLY   547      32.040  18.698  55.313  1.00 78.31           C  
ATOM   4177  C   GLY   547      33.398  19.371  55.240  1.00 78.80           C  
ATOM   4178  O   GLY   547      34.322  18.952  55.929  1.00 79.07           O  
ATOM   4179  N   ARG   548      33.532  20.403  54.412  1.00 80.58           N  
ATOM   4180  CA  ARG   548      34.812  21.103  54.264  1.00 81.35           C  
ATOM   4181  C   ARG   548      35.481  21.366  55.617  1.00 81.16           C  
ATOM   4182  O   ARG   548      36.704  21.287  55.746  1.00 80.58           O  
ATOM   4183  CB  ARG   548      34.610  22.423  53.507  1.00 81.73           C  
ATOM   4184  N   VAL   549      34.671  21.666  56.624  1.00 81.15           N  
ATOM   4185  CA  VAL   549      35.182  21.940  57.963  1.00 80.87           C  
ATOM   4186  C   VAL   549      35.562  20.655  58.691  1.00 80.24           C  
ATOM   4187  O   VAL   549      34.995  19.596  58.427  1.00 80.21           O  
ATOM   4188  CB  VAL   549      34.130  22.680  58.792  1.00 81.36           C  
ATOM   4189  CG1 VAL   549      34.599  22.832  60.228  1.00 81.58           C  
ATOM   4190  CG2 VAL   549      33.847  24.035  58.161  1.00 81.60           C  
ATOM   4191  N   PRO   550      36.555  20.729  59.596  1.00 79.52           N  
ATOM   4192  CA  PRO   550      36.994  19.553  60.358  1.00 77.69           C  
ATOM   4193  C   PRO   550      36.137  19.411  61.613  1.00 75.49           C  
ATOM   4194  O   PRO   550      36.015  20.340  62.415  1.00 74.14           O  
ATOM   4195  CB  PRO   550      38.454  19.871  60.665  1.00 78.99           C  
ATOM   4196  CG  PRO   550      38.428  21.355  60.872  1.00 78.71           C  
ATOM   4197  CD  PRO   550      37.503  21.851  59.765  1.00 79.58           C  
ATOM   4198  N   GLN   551      35.560  18.233  61.784  1.00 73.56           N  
ATOM   4199  CA  GLN   551      34.674  17.988  62.899  1.00 73.36           C  
ATOM   4200  C   GLN   551      35.169  18.269  64.318  1.00 74.50           C  
ATOM   4201  O   GLN   551      34.379  18.219  65.256  1.00 74.41           O  
ATOM   4202  CB  GLN   551      34.138  16.566  62.818  1.00 72.76           C  
ATOM   4203  CG  GLN   551      34.977  15.521  63.497  1.00 71.87           C  
ATOM   4204  CD  GLN   551      34.207  14.230  63.689  1.00 70.02           C  
ATOM   4205  OE1 GLN   551      33.812  13.590  62.718  1.00 68.56           O  
ATOM   4206  NE2 GLN   551      33.983  13.847  64.947  1.00 68.29           N  
ATOM   4207  N   ASP   552      36.454  18.572  64.485  1.00 76.02           N  
ATOM   4208  CA  ASP   552      37.006  18.864  65.817  1.00 76.42           C  
ATOM   4209  C   ASP   552      36.272  20.038  66.469  1.00 75.72           C  
ATOM   4210  O   ASP   552      36.084  20.069  67.688  1.00 75.17           O  
ATOM   4211  CB  ASP   552      38.495  19.232  65.729  1.00 79.42           C  
ATOM   4212  CG  ASP   552      39.326  18.184  65.018  1.00 82.73           C  
ATOM   4213  OD1 ASP   552      38.939  17.775  63.895  1.00 85.08           O  
ATOM   4214  OD2 ASP   552      40.372  17.780  65.581  1.00 83.68           O  
ATOM   4215  N   GLU   553      35.859  20.997  65.639  1.00 74.79           N  
ATOM   4216  CA  GLU   553      35.175  22.214  66.091  1.00 72.91           C  
ATOM   4217  C   GLU   553      33.833  22.046  66.805  1.00 70.89           C  
ATOM   4218  O   GLU   553      33.320  23.007  67.383  1.00 69.92           O  
ATOM   4219  CB  GLU   553      35.008  23.178  64.906  1.00 70.93           C  
ATOM   4220  N   PHE   554      33.257  20.851  66.773  1.00 68.73           N  
ATOM   4221  CA  PHE   554      31.975  20.655  67.437  1.00 69.00           C  
ATOM   4222  C   PHE   554      32.106  19.947  68.784  1.00 68.75           C  
ATOM   4223  O   PHE   554      31.117  19.752  69.492  1.00 67.51           O  
ATOM   4224  CB  PHE   554      31.025  19.878  66.520  1.00 68.35           C  
ATOM   4225  CG  PHE   554      30.711  20.587  65.234  1.00 68.55           C  
ATOM   4226  CD1 PHE   554      31.723  20.908  64.327  1.00 68.74           C  
ATOM   4227  CD2 PHE   554      29.404  20.936  64.924  1.00 67.83           C  
ATOM   4228  CE1 PHE   554      31.425  21.567  63.125  1.00 67.77           C  
ATOM   4229  CE2 PHE   554      29.102  21.591  63.734  1.00 67.45           C  
ATOM   4230  CZ  PHE   554      30.111  21.907  62.834  1.00 66.30           C  
ATOM   4231  N   ALA   555      33.340  19.593  69.137  1.00 69.34           N  
ATOM   4232  CA  ALA   555      33.633  18.889  70.385  1.00 69.62           C  
ATOM   4233  C   ALA   555      33.032  19.542  71.622  1.00 69.66           C  
ATOM   4234  O   ALA   555      32.343  18.884  72.409  1.00 69.66           O  
ATOM   4235  CB  ALA   555      35.137  18.748  70.558  1.00 70.58           C  
ATOM   4236  N   LEU   556      33.302  20.831  71.806  1.00 69.35           N  
ATOM   4237  CA  LEU   556      32.761  21.540  72.963  1.00 68.54           C  
ATOM   4238  C   LEU   556      31.239  21.442  72.899  1.00 67.05           C  
ATOM   4239  O   LEU   556      30.585  21.096  73.882  1.00 65.66           O  
ATOM   4240  CB  LEU   556      33.211  23.017  72.951  1.00 69.05           C  
ATOM   4241  N   ALA   557      30.691  21.723  71.721  1.00 65.72           N  
ATOM   4242  CA  ALA   557      29.256  21.668  71.518  1.00 64.71           C  
ATOM   4243  C   ALA   557      28.672  20.314  71.932  1.00 64.77           C  
ATOM   4244  O   ALA   557      27.656  20.270  72.634  1.00 63.90           O  
ATOM   4245  CB  ALA   557      28.928  21.969  70.064  1.00 63.56           C  
ATOM   4246  N   LEU   558      29.305  19.218  71.509  1.00 64.48           N  
ATOM   4247  CA  LEU   558      28.823  17.881  71.858  1.00 65.96           C  
ATOM   4248  C   LEU   558      28.892  17.615  73.347  1.00 68.91           C  
ATOM   4249  O   LEU   558      27.976  17.037  73.929  1.00 69.45           O  
ATOM   4250  CB  LEU   558      29.612  16.793  71.132  1.00 63.25           C  
ATOM   4251  CG  LEU   558      29.345  16.722  69.631  1.00 61.20           C  
ATOM   4252  CD1 LEU   558      29.771  15.378  69.099  1.00 57.43           C  
ATOM   4253  CD2 LEU   558      27.866  16.956  69.382  1.00 59.20           C  
ATOM   4254  N   GLU   559      29.980  18.029  73.975  1.00 71.67           N  
ATOM   4255  CA  GLU   559      30.111  17.814  75.404  1.00 74.20           C  
ATOM   4256  C   GLU   559      29.097  18.597  76.208  1.00 74.06           C  
ATOM   4257  O   GLU   559      28.735  18.204  77.325  1.00 73.30           O  
ATOM   4258  CB  GLU   559      31.490  18.205  75.866  1.00 77.14           C  
ATOM   4259  CG  GLU   559      32.551  17.323  75.334  1.00 82.53           C  
ATOM   4260  CD  GLU   559      33.900  17.865  75.685  1.00 86.60           C  
ATOM   4261  OE1 GLU   559      34.906  17.241  75.297  1.00 88.60           O  
ATOM   4262  OE2 GLU   559      33.948  18.926  76.351  1.00 88.51           O  
ATOM   4263  N   ALA   560      28.656  19.719  75.653  1.00 72.69           N  
ATOM   4264  CA  ALA   560      27.677  20.538  76.339  1.00 71.58           C  
ATOM   4265  C   ALA   560      26.330  19.835  76.301  1.00 70.95           C  
ATOM   4266  O   ALA   560      25.626  19.763  77.306  1.00 71.46           O  
ATOM   4267  CB  ALA   560      27.579  21.891  75.689  1.00 71.08           C  
ATOM   4268  N   LEU   561      25.976  19.299  75.142  1.00 70.33           N  
ATOM   4269  CA  LEU   561      24.705  18.606  75.002  1.00 70.82           C  
ATOM   4270  C   LEU   561      24.662  17.404  75.942  1.00 71.66           C  
ATOM   4271  O   LEU   561      23.629  17.089  76.552  1.00 69.40           O  
ATOM   4272  CB  LEU   561      24.515  18.144  73.558  1.00 70.62           C  
ATOM   4273  CG  LEU   561      24.262  19.197  72.482  1.00 69.34           C  
ATOM   4274  CD1 LEU   561      24.259  18.523  71.128  1.00 68.95           C  
ATOM   4275  CD2 LEU   561      22.930  19.883  72.727  1.00 69.71           C  
ATOM   4276  N   ALA   562      25.803  16.734  76.045  1.00 73.00           N  
ATOM   4277  CA  ALA   562      25.930  15.569  76.903  1.00 72.97           C  
ATOM   4278  C   ALA   562      25.656  16.000  78.333  1.00 72.64           C  
ATOM   4279  O   ALA   562      24.880  15.360  79.041  1.00 71.75           O  
ATOM   4280  CB  ALA   562      27.329  14.982  76.779  1.00 73.22           C  
ATOM   4281  N   ARG   563      26.291  17.094  78.747  1.00 73.35           N  
ATOM   4282  CA  ARG   563      26.113  17.629  80.099  1.00 74.33           C  
ATOM   4283  C   ARG   563      24.642  17.975  80.343  1.00 73.12           C  
ATOM   4284  O   ARG   563      24.087  17.639  81.385  1.00 71.47           O  
ATOM   4285  CB  ARG   563      26.981  18.880  80.300  1.00 76.50           C  
ATOM   4286  CG  ARG   563      28.480  18.620  80.222  1.00 81.64           C  
ATOM   4287  CD  ARG   563      29.293  19.902  80.426  1.00 86.20           C  
ATOM   4288  NE  ARG   563      30.745  19.682  80.394  1.00 89.40           N  
ATOM   4289  CZ  ARG   563      31.571  20.179  79.469  1.00 89.91           C  
ATOM   4290  NH1 ARG   563      31.104  20.929  78.483  1.00 89.17           N  
ATOM   4291  NH2 ARG   563      32.874  19.936  79.536  1.00 90.96           N  
ATOM   4292  N   GLU   564      24.021  18.632  79.364  1.00 72.05           N  
ATOM   4293  CA  GLU   564      22.620  19.036  79.441  1.00 72.05           C  
ATOM   4294  C   GLU   564      21.615  17.886  79.463  1.00 71.31           C  
ATOM   4295  O   GLU   564      20.464  18.066  79.862  1.00 70.31           O  
ATOM   4296  CB  GLU   564      22.259  19.925  78.252  1.00 73.17           C  
ATOM   4297  CG  GLU   564      23.059  21.206  78.130  1.00 77.28           C  
ATOM   4298  CD  GLU   564      22.935  22.104  79.346  1.00 79.30           C  
ATOM   4299  OE1 GLU   564      21.806  22.233  79.887  1.00 80.51           O  
ATOM   4300  OE2 GLU   564      23.968  22.689  79.745  1.00 79.27           O  
ATOM   4301  N   GLY   565      22.035  16.710  79.009  1.00 70.78           N  
ATOM   4302  CA  GLY   565      21.119  15.583  78.965  1.00 68.36           C  
ATOM   4303  C   GLY   565      20.439  15.523  77.604  1.00 66.25           C  
ATOM   4304  O   GLY   565      19.378  14.916  77.446  1.00 66.53           O  
ATOM   4305  N   ILE   566      21.064  16.149  76.615  1.00 63.16           N  
ATOM   4306  CA  ILE   566      20.521  16.161  75.271  1.00 62.51           C  
ATOM   4307  C   ILE   566      21.248  15.220  74.301  1.00 61.42           C  
ATOM   4308  O   ILE   566      22.440  15.374  74.032  1.00 60.97           O  
ATOM   4309  CB  ILE   566      20.531  17.595  74.694  1.00 62.93           C  
ATOM   4310  CG1 ILE   566      19.636  18.482  75.552  1.00 63.12           C  
ATOM   4311  CG2 ILE   566      20.046  17.595  73.250  1.00 62.42           C  
ATOM   4312  CD1 ILE   566      19.625  19.909  75.126  1.00 63.14           C  
ATOM   4313  N   ALA   567      20.506  14.246  73.783  1.00 59.47           N  
ATOM   4314  CA  ALA   567      21.045  13.286  72.834  1.00 57.87           C  
ATOM   4315  C   ALA   567      21.298  14.020  71.521  1.00 58.02           C  
ATOM   4316  O   ALA   567      20.763  15.116  71.307  1.00 54.73           O  
ATOM   4317  CB  ALA   567      20.058  12.151  72.630  1.00 55.57           C  
ATOM   4318  N   TYR   568      22.106  13.408  70.647  1.00 59.50           N  
ATOM   4319  CA  TYR   568      22.456  14.006  69.355  1.00 59.67           C  
ATOM   4320  C   TYR   568      23.005  13.060  68.282  1.00 58.98           C  
ATOM   4321  O   TYR   568      23.343  11.913  68.546  1.00 61.20           O  
ATOM   4322  CB  TYR   568      23.484  15.128  69.554  1.00 59.98           C  
ATOM   4323  CG  TYR   568      24.755  14.669  70.223  1.00 61.08           C  
ATOM   4324  CD1 TYR   568      24.838  14.587  71.616  1.00 63.21           C  
ATOM   4325  CD2 TYR   568      25.865  14.277  69.466  1.00 60.42           C  
ATOM   4326  CE1 TYR   568      26.001  14.118  72.248  1.00 64.86           C  
ATOM   4327  CE2 TYR   568      27.031  13.806  70.076  1.00 61.12           C  
ATOM   4328  CZ  TYR   568      27.097  13.724  71.472  1.00 64.74           C  
ATOM   4329  OH  TYR   568      28.232  13.235  72.105  1.00 64.10           O  
ATOM   4330  N   ASP   569      23.090  13.585  67.067  1.00 57.85           N  
ATOM   4331  CA  ASP   569      23.615  12.890  65.908  1.00 56.33           C  
ATOM   4332  C   ASP   569      24.232  13.990  65.087  1.00 56.03           C  
ATOM   4333  O   ASP   569      23.559  14.938  64.737  1.00 56.12           O  
ATOM   4334  CB  ASP   569      22.510  12.251  65.079  1.00 56.77           C  
ATOM   4335  CG  ASP   569      21.946  11.018  65.717  1.00 57.76           C  
ATOM   4336  OD1 ASP   569      22.652   9.990  65.751  1.00 58.65           O  
ATOM   4337  OD2 ASP   569      20.792  11.081  66.185  1.00 58.90           O  
ATOM   4338  N   LEU   570      25.516  13.871  64.795  1.00 57.02           N  
ATOM   4339  CA  LEU   570      26.219  14.859  63.999  1.00 56.00           C  
ATOM   4340  C   LEU   570      26.467  14.252  62.639  1.00 56.31           C  
ATOM   4341  O   LEU   570      27.152  13.244  62.516  1.00 56.30           O  
ATOM   4342  CB  LEU   570      27.554  15.215  64.658  1.00 56.74           C  
ATOM   4343  CG  LEU   570      28.512  16.102  63.861  1.00 57.39           C  
ATOM   4344  CD1 LEU   570      27.901  17.490  63.652  1.00 56.03           C  
ATOM   4345  CD2 LEU   570      29.828  16.210  64.609  1.00 57.46           C  
ATOM   4346  N   VAL   571      25.876  14.855  61.617  1.00 57.93           N  
ATOM   4347  CA  VAL   571      26.042  14.394  60.245  1.00 58.55           C  
ATOM   4348  C   VAL   571      26.650  15.532  59.448  1.00 60.15           C  
ATOM   4349  O   VAL   571      26.253  16.687  59.621  1.00 60.53           O  
ATOM   4350  CB  VAL   571      24.708  14.032  59.609  1.00 57.13           C  
ATOM   4351  CG1 VAL   571      24.902  13.782  58.138  1.00 58.68           C  
ATOM   4352  CG2 VAL   571      24.136  12.794  60.270  1.00 57.22           C  
ATOM   4353  N   SER   572      27.614  15.207  58.591  1.00 60.73           N  
ATOM   4354  CA  SER   572      28.272  16.213  57.774  1.00 63.70           C  
ATOM   4355  C   SER   572      27.824  16.087  56.326  1.00 65.35           C  
ATOM   4356  O   SER   572      27.668  14.986  55.809  1.00 65.75           O  
ATOM   4357  CB  SER   572      29.799  16.081  57.877  1.00 64.28           C  
ATOM   4358  OG  SER   572      30.257  14.821  57.420  1.00 64.45           O  
ATOM   4359  N   VAL   573      27.622  17.224  55.673  1.00 67.61           N  
ATOM   4360  CA  VAL   573      27.164  17.233  54.294  1.00 69.83           C  
ATOM   4361  C   VAL   573      28.163  17.804  53.317  1.00 72.18           C  
ATOM   4362  O   VAL   573      28.861  18.765  53.619  1.00 72.98           O  
ATOM   4363  CB  VAL   573      25.869  18.034  54.155  1.00 68.88           C  
ATOM   4364  CG1 VAL   573      25.387  18.003  52.714  1.00 67.14           C  
ATOM   4365  CG2 VAL   573      24.824  17.462  55.087  1.00 68.95           C  
ATOM   4366  N   ARG   574      28.211  17.199  52.137  1.00 75.00           N  
ATOM   4367  CA  ARG   574      29.098  17.623  51.072  1.00 78.02           C  
ATOM   4368  C   ARG   574      28.379  17.353  49.754  1.00 81.00           C  
ATOM   4369  O   ARG   574      27.993  16.218  49.482  1.00 82.42           O  
ATOM   4370  CB  ARG   574      30.409  16.841  51.136  1.00 76.86           C  
ATOM   4371  N   LYS   575      28.177  18.402  48.957  1.00 84.03           N  
ATOM   4372  CA  LYS   575      27.520  18.293  47.653  1.00 85.84           C  
ATOM   4373  C   LYS   575      28.562  17.951  46.591  1.00 88.00           C  
ATOM   4374  O   LYS   575      28.231  17.704  45.430  1.00 88.17           O  
ATOM   4375  CB  LYS   575      26.836  19.606  47.304  1.00 85.96           C  
ATOM   4376  N   SER   576      29.824  17.948  47.013  1.00 90.55           N  
ATOM   4377  CA  SER   576      30.966  17.640  46.155  1.00 92.53           C  
ATOM   4378  C   SER   576      31.394  16.185  46.336  1.00 93.82           C  
ATOM   4379  O   SER   576      30.957  15.516  47.271  1.00 93.67           O  
ATOM   4380  CB  SER   576      32.142  18.548  46.519  1.00 92.82           C  
ATOM   4381  OG  SER   576      32.452  18.444  47.902  1.00 91.73           O  
ATOM   4382  N   GLY   577      32.254  15.708  45.440  1.00 94.85           N  
ATOM   4383  CA  GLY   577      32.746  14.342  45.521  1.00 96.13           C  
ATOM   4384  C   GLY   577      31.767  13.285  46.010  1.00 96.68           C  
ATOM   4385  O   GLY   577      32.093  12.471  46.883  1.00 96.76           O  
ATOM   4386  N   GLY   578      30.558  13.301  45.460  1.00 96.27           N  
ATOM   4387  CA  GLY   578      29.571  12.309  45.840  1.00 95.72           C  
ATOM   4388  C   GLY   578      29.510  11.290  44.719  1.00 95.23           C  
ATOM   4389  O   GLY   578      28.795  10.281  44.797  1.00 95.53           O  
ATOM   4390  N   GLY   579      30.283  11.570  43.669  1.00 93.89           N  
ATOM   4391  CA  GLY   579      30.337  10.708  42.503  1.00 89.91           C  
ATOM   4392  C   GLY   579      29.046  10.806  41.726  1.00 87.45           C  
ATOM   4393  O   GLY   579      28.294  11.763  41.877  1.00 88.09           O  
ATOM   4394  N   ARG   580      28.782   9.811  40.895  1.00 85.01           N  
ATOM   4395  CA  ARG   580      27.569   9.790  40.104  1.00 82.15           C  
ATOM   4396  C   ARG   580      26.792   8.532  40.426  1.00 81.17           C  
ATOM   4397  O   ARG   580      27.259   7.687  41.187  1.00 79.68           O  
ATOM   4398  CB  ARG   580      27.915   9.814  38.623  1.00 82.12           C  
ATOM   4399  CG  ARG   580      28.431  11.144  38.148  1.00 81.14           C  
ATOM   4400  CD  ARG   580      27.316  12.146  38.139  1.00 81.20           C  
ATOM   4401  NE  ARG   580      27.512  13.129  37.083  1.00 82.64           N  
ATOM   4402  CZ  ARG   580      28.253  14.221  37.199  1.00 83.10           C  
ATOM   4403  NH1 ARG   580      28.877  14.485  38.342  1.00 82.51           N  
ATOM   4404  NH2 ARG   580      28.375  15.039  36.163  1.00 82.89           N  
ATOM   4405  N   VAL   581      25.598   8.425  39.857  1.00 80.69           N  
ATOM   4406  CA  VAL   581      24.748   7.261  40.061  1.00 80.30           C  
ATOM   4407  C   VAL   581      23.931   7.044  38.812  1.00 79.97           C  
ATOM   4408  O   VAL   581      23.288   7.961  38.320  1.00 79.38           O  
ATOM   4409  CB  VAL   581      23.780   7.441  41.230  1.00 80.23           C  
ATOM   4410  CG1 VAL   581      22.936   6.193  41.375  1.00 80.02           C  
ATOM   4411  CG2 VAL   581      24.551   7.701  42.517  1.00 79.92           C  
ATOM   4412  N   TYR   582      23.958   5.819  38.309  1.00 81.01           N  
ATOM   4413  CA  TYR   582      23.234   5.465  37.093  1.00 81.67           C  
ATOM   4414  C   TYR   582      22.370   4.230  37.324  1.00 83.39           C  
ATOM   4415  O   TYR   582      22.650   3.415  38.214  1.00 83.10           O  
ATOM   4416  CB  TYR   582      24.232   5.152  35.973  1.00 79.16           C  
ATOM   4417  CG  TYR   582      25.244   6.238  35.710  1.00 75.47           C  
ATOM   4418  CD1 TYR   582      24.952   7.280  34.842  1.00 74.69           C  
ATOM   4419  CD2 TYR   582      26.480   6.243  36.357  1.00 74.02           C  
ATOM   4420  CE1 TYR   582      25.857   8.307  34.621  1.00 74.09           C  
ATOM   4421  CE2 TYR   582      27.398   7.266  36.148  1.00 72.95           C  
ATOM   4422  CZ  TYR   582      27.078   8.300  35.280  1.00 74.55           C  
ATOM   4423  OH  TYR   582      27.954   9.353  35.087  1.00 74.51           O  
ATOM   4424  N   PRO   583      21.298   4.079  36.535  1.00 85.17           N  
ATOM   4425  CA  PRO   583      20.438   2.904  36.700  1.00 87.05           C  
ATOM   4426  C   PRO   583      21.193   1.751  36.045  1.00 89.56           C  
ATOM   4427  O   PRO   583      22.038   1.988  35.167  1.00 89.90           O  
ATOM   4428  CB  PRO   583      19.187   3.255  35.893  1.00 85.33           C  
ATOM   4429  CG  PRO   583      19.231   4.738  35.766  1.00 85.86           C  
ATOM   4430  CD  PRO   583      20.694   5.038  35.600  1.00 85.84           C  
ATOM   4431  N   VAL   584      20.926   0.522  36.479  1.00 91.45           N  
ATOM   4432  CA  VAL   584      21.560  -0.637  35.862  1.00 93.41           C  
ATOM   4433  C   VAL   584      20.709  -0.863  34.621  1.00 94.92           C  
ATOM   4434  O   VAL   584      21.192  -1.296  33.576  1.00 94.27           O  
ATOM   4435  CB  VAL   584      21.489  -1.885  36.759  1.00 93.16           C  
ATOM   4436  CG1 VAL   584      21.967  -3.103  35.987  1.00 93.32           C  
ATOM   4437  CG2 VAL   584      22.347  -1.689  37.993  1.00 93.68           C  
ATOM   4438  N   GLN   585      19.430  -0.530  34.770  1.00 97.43           N  
ATOM   4439  CA  GLN   585      18.425  -0.644  33.720  1.00100.23           C  
ATOM   4440  C   GLN   585      17.187   0.164  34.134  1.00101.07           C  
ATOM   4441  O   GLN   585      16.930   0.340  35.331  1.00100.24           O  
ATOM   4442  CB  GLN   585      18.061  -2.118  33.503  1.00102.50           C  
ATOM   4443  CG  GLN   585      18.913  -2.824  32.447  1.00104.49           C  
ATOM   4444  CD  GLN   585      19.052  -4.315  32.702  1.00105.53           C  
ATOM   4445  OE1 GLN   585      19.126  -5.115  31.764  1.00106.64           O  
ATOM   4446  NE2 GLN   585      19.108  -4.696  33.975  1.00105.11           N  
ATOM   4447  N   GLY   586      16.435   0.648  33.145  1.00101.88           N  
ATOM   4448  CA  GLY   586      15.242   1.442  33.412  1.00103.73           C  
ATOM   4449  C   GLY   586      15.637   2.860  33.762  1.00105.16           C  
ATOM   4450  O   GLY   586      16.760   3.262  33.446  1.00105.31           O  
ATOM   4451  N   ARG   587      14.765   3.657  34.375  1.00106.46           N  
ATOM   4452  CA  ARG   587      15.239   4.977  34.756  1.00107.43           C  
ATOM   4453  C   ARG   587      15.252   5.112  36.263  1.00106.60           C  
ATOM   4454  O   ARG   587      14.850   4.211  37.005  1.00106.33           O  
ATOM   4455  CB  ARG   587      14.464   6.134  34.100  1.00109.57           C  
ATOM   4456  CG  ARG   587      15.450   7.254  33.709  1.00112.86           C  
ATOM   4457  CD  ARG   587      14.829   8.483  33.074  1.00114.93           C  
ATOM   4458  NE  ARG   587      15.392   9.672  33.716  1.00117.52           N  
ATOM   4459  CZ  ARG   587      15.407  10.904  33.215  1.00118.08           C  
ATOM   4460  NH1 ARG   587      15.968  11.876  33.926  1.00117.13           N  
ATOM   4461  NH2 ARG   587      14.891  11.164  32.018  1.00118.51           N  
ATOM   4462  N   LEU   588      15.712   6.276  36.684  1.00105.52           N  
ATOM   4463  CA  LEU   588      15.924   6.590  38.079  1.00103.82           C  
ATOM   4464  C   LEU   588      14.925   7.567  38.706  1.00102.35           C  
ATOM   4465  O   LEU   588      14.653   8.624  38.147  1.00102.83           O  
ATOM   4466  CB  LEU   588      17.341   7.116  38.167  1.00104.39           C  
ATOM   4467  CG  LEU   588      18.128   7.284  39.445  1.00104.70           C  
ATOM   4468  CD1 LEU   588      19.600   7.067  39.151  1.00104.13           C  
ATOM   4469  CD2 LEU   588      17.878   8.668  39.999  1.00106.26           C  
ATOM   4470  N   ALA   589      14.397   7.213  39.880  1.00100.07           N  
ATOM   4471  CA  ALA   589      13.420   8.049  40.579  1.00 97.60           C  
ATOM   4472  C   ALA   589      14.004   9.311  41.224  1.00 96.06           C  
ATOM   4473  O   ALA   589      15.141   9.698  40.947  1.00 96.48           O  
ATOM   4474  CB  ALA   589      12.695   7.228  41.623  1.00 97.97           C  
ATOM   4475  N   ASP   590      13.215   9.941  42.093  1.00 93.76           N  
ATOM   4476  CA  ASP   590      13.614  11.178  42.768  1.00 91.68           C  
ATOM   4477  C   ASP   590      14.342  11.028  44.109  1.00 88.22           C  
ATOM   4478  O   ASP   590      15.567  10.969  44.139  1.00 88.18           O  
ATOM   4479  CB  ASP   590      12.389  12.089  42.956  1.00 94.79           C  
ATOM   4480  CG  ASP   590      12.721  13.392  43.683  1.00 97.21           C  
ATOM   4481  OD1 ASP   590      11.790  14.193  43.924  1.00 98.56           O  
ATOM   4482  OD2 ASP   590      13.905  13.620  44.014  1.00 98.49           O  
ATOM   4483  N   GLY   591      13.595  10.983  45.212  1.00 83.81           N  
ATOM   4484  CA  GLY   591      14.213  10.884  46.528  1.00 78.73           C  
ATOM   4485  C   GLY   591      14.828   9.549  46.901  1.00 75.18           C  
ATOM   4486  O   GLY   591      14.240   8.782  47.663  1.00 75.18           O  
ATOM   4487  N   LEU   592      16.025   9.274  46.391  1.00 71.57           N  
ATOM   4488  CA  LEU   592      16.687   8.009  46.670  1.00 67.14           C  
ATOM   4489  C   LEU   592      17.739   8.053  47.745  1.00 64.47           C  
ATOM   4490  O   LEU   592      18.488   9.021  47.871  1.00 63.34           O  
ATOM   4491  CB  LEU   592      17.332   7.436  45.411  1.00 67.91           C  
ATOM   4492  CG  LEU   592      16.415   7.009  44.273  1.00 68.32           C  
ATOM   4493  CD1 LEU   592      17.212   6.185  43.276  1.00 67.64           C  
ATOM   4494  CD2 LEU   592      15.264   6.197  44.822  1.00 69.12           C  
ATOM   4495  N   TYR   593      17.778   6.965  48.505  1.00 61.49           N  
ATOM   4496  CA  TYR   593      18.712   6.760  49.596  1.00 59.33           C  
ATOM   4497  C   TYR   593      19.657   5.623  49.203  1.00 59.19           C  
ATOM   4498  O   TYR   593      19.235   4.480  49.050  1.00 59.52           O  
ATOM   4499  CB  TYR   593      17.939   6.385  50.860  1.00 57.12           C  
ATOM   4500  CG  TYR   593      18.775   5.767  51.958  1.00 54.35           C  
ATOM   4501  CD1 TYR   593      19.822   6.463  52.540  1.00 52.89           C  
ATOM   4502  CD2 TYR   593      18.479   4.501  52.448  1.00 54.03           C  
ATOM   4503  CE1 TYR   593      20.546   5.919  53.587  1.00 52.50           C  
ATOM   4504  CE2 TYR   593      19.195   3.951  53.488  1.00 52.80           C  
ATOM   4505  CZ  TYR   593      20.222   4.664  54.055  1.00 52.70           C  
ATOM   4506  OH  TYR   593      20.894   4.122  55.118  1.00 54.05           O  
ATOM   4507  N   VAL   594      20.935   5.933  49.028  1.00 57.64           N  
ATOM   4508  CA  VAL   594      21.898   4.908  48.653  1.00 55.45           C  
ATOM   4509  C   VAL   594      22.940   4.717  49.734  1.00 55.57           C  
ATOM   4510  O   VAL   594      23.868   5.500  49.858  1.00 57.23           O  
ATOM   4511  CB  VAL   594      22.608   5.263  47.335  1.00 53.89           C  
ATOM   4512  CG1 VAL   594      23.644   4.222  46.996  1.00 52.13           C  
ATOM   4513  CG2 VAL   594      21.598   5.343  46.221  1.00 54.77           C  
ATOM   4514  N   PRO   595      22.770   3.704  50.580  1.00 55.86           N  
ATOM   4515  CA  PRO   595      23.826   3.579  51.585  1.00 56.51           C  
ATOM   4516  C   PRO   595      25.071   2.972  50.913  1.00 58.78           C  
ATOM   4517  O   PRO   595      24.949   2.138  50.003  1.00 58.47           O  
ATOM   4518  CB  PRO   595      23.191   2.679  52.657  1.00 53.86           C  
ATOM   4519  CG  PRO   595      22.118   1.958  51.945  1.00 53.30           C  
ATOM   4520  CD  PRO   595      21.563   2.959  50.974  1.00 54.05           C  
ATOM   4521  N   LEU   596      26.251   3.413  51.349  1.00 59.89           N  
ATOM   4522  CA  LEU   596      27.518   2.958  50.793  1.00 61.44           C  
ATOM   4523  C   LEU   596      28.376   2.208  51.805  1.00 64.81           C  
ATOM   4524  O   LEU   596      28.847   1.107  51.532  1.00 68.23           O  
ATOM   4525  CB  LEU   596      28.300   4.151  50.233  1.00 59.77           C  
ATOM   4526  CG  LEU   596      28.053   4.557  48.768  1.00 60.61           C  
ATOM   4527  CD1 LEU   596      26.581   4.690  48.507  1.00 59.32           C  
ATOM   4528  CD2 LEU   596      28.762   5.879  48.451  1.00 60.21           C  
ATOM   4529  N   GLU   597      28.605   2.805  52.965  1.00 66.82           N  
ATOM   4530  CA  GLU   597      29.396   2.161  54.000  1.00 68.50           C  
ATOM   4531  C   GLU   597      28.570   2.218  55.282  1.00 69.94           C  
ATOM   4532  O   GLU   597      27.444   2.724  55.279  1.00 70.42           O  
ATOM   4533  CB  GLU   597      30.729   2.881  54.171  1.00 69.59           C  
ATOM   4534  CG  GLU   597      31.498   3.033  52.857  1.00 74.70           C  
ATOM   4535  CD  GLU   597      32.935   3.526  53.044  1.00 78.47           C  
ATOM   4536  OE1 GLU   597      33.126   4.665  53.534  1.00 79.24           O  
ATOM   4537  OE2 GLU   597      33.880   2.770  52.699  1.00 81.10           O  
ATOM   4538  N   ASP   598      29.109   1.700  56.377  1.00 70.61           N  
ATOM   4539  CA  ASP   598      28.364   1.685  57.632  1.00 70.40           C  
ATOM   4540  C   ASP   598      27.849   3.069  58.037  1.00 70.16           C  
ATOM   4541  O   ASP   598      26.738   3.193  58.577  1.00 70.08           O  
ATOM   4542  CB  ASP   598      29.233   1.095  58.753  1.00 70.00           C  
ATOM   4543  N   LYS   599      28.635   4.107  57.746  1.00 68.09           N  
ATOM   4544  CA  LYS   599      28.262   5.466  58.138  1.00 65.83           C  
ATOM   4545  C   LYS   599      28.104   6.512  57.026  1.00 63.72           C  
ATOM   4546  O   LYS   599      28.067   7.704  57.307  1.00 63.76           O  
ATOM   4547  CB  LYS   599      29.283   5.976  59.164  1.00 66.12           C  
ATOM   4548  CG  LYS   599      29.507   5.049  60.357  1.00 67.07           C  
ATOM   4549  CD  LYS   599      28.316   5.073  61.322  1.00 69.38           C  
ATOM   4550  CE  LYS   599      28.630   4.323  62.619  1.00 69.96           C  
ATOM   4551  NZ  LYS   599      27.603   4.535  63.678  1.00 70.19           N  
ATOM   4552  N   THR   600      27.999   6.092  55.772  1.00 62.28           N  
ATOM   4553  CA  THR   600      27.868   7.061  54.677  1.00 60.49           C  
ATOM   4554  C   THR   600      26.777   6.712  53.667  1.00 59.31           C  
ATOM   4555  O   THR   600      26.523   5.546  53.384  1.00 59.73           O  
ATOM   4556  CB  THR   600      29.200   7.211  53.892  1.00 59.11           C  
ATOM   4557  OG1 THR   600      29.642   5.914  53.479  1.00 61.64           O  
ATOM   4558  CG2 THR   600      30.279   7.848  54.750  1.00 57.54           C  
ATOM   4559  N   PHE   601      26.119   7.726  53.129  1.00 57.24           N  
ATOM   4560  CA  PHE   601      25.104   7.456  52.140  1.00 55.79           C  
ATOM   4561  C   PHE   601      24.916   8.621  51.210  1.00 56.02           C  
ATOM   4562  O   PHE   601      25.336   9.741  51.487  1.00 54.44           O  
ATOM   4563  CB  PHE   601      23.775   7.124  52.787  1.00 55.33           C  
ATOM   4564  CG  PHE   601      23.222   8.229  53.633  1.00 54.93           C  
ATOM   4565  CD1 PHE   601      23.719   8.460  54.911  1.00 53.15           C  
ATOM   4566  CD2 PHE   601      22.196   9.036  53.152  1.00 53.59           C  
ATOM   4567  CE1 PHE   601      23.204   9.470  55.697  1.00 53.33           C  
ATOM   4568  CE2 PHE   601      21.674  10.052  53.932  1.00 54.96           C  
ATOM   4569  CZ  PHE   601      22.176  10.272  55.209  1.00 54.27           C  
ATOM   4570  N   LEU   602      24.287   8.326  50.087  1.00 56.43           N  
ATOM   4571  CA  LEU   602      24.018   9.314  49.080  1.00 58.29           C  
ATOM   4572  C   LEU   602      22.537   9.606  49.142  1.00 60.23           C  
ATOM   4573  O   LEU   602      21.756   8.821  49.666  1.00 60.47           O  
ATOM   4574  CB  LEU   602      24.379   8.776  47.687  1.00 57.86           C  
ATOM   4575  CG  LEU   602      25.821   8.358  47.367  1.00 57.90           C  
ATOM   4576  CD1 LEU   602      25.891   7.927  45.906  1.00 55.45           C  
ATOM   4577  CD2 LEU   602      26.794   9.515  47.630  1.00 54.94           C  
ATOM   4578  N   LEU   603      22.161  10.747  48.595  1.00 62.75           N  
ATOM   4579  CA  LEU   603      20.780  11.165  48.558  1.00 63.76           C  
ATOM   4580  C   LEU   603      20.619  11.811  47.196  1.00 65.44           C  
ATOM   4581  O   LEU   603      21.305  12.772  46.886  1.00 65.49           O  
ATOM   4582  CB  LEU   603      20.528  12.182  49.667  1.00 62.83           C  
ATOM   4583  CG  LEU   603      19.254  12.036  50.488  1.00 61.28           C  
ATOM   4584  CD1 LEU   603      19.126  10.632  50.982  1.00 61.01           C  
ATOM   4585  CD2 LEU   603      19.299  12.984  51.657  1.00 61.14           C  
ATOM   4586  N   LEU   604      19.744  11.256  46.372  1.00 68.63           N  
ATOM   4587  CA  LEU   604      19.512  11.806  45.048  1.00 73.76           C  
ATOM   4588  C   LEU   604      18.130  12.402  44.950  1.00 77.67           C  
ATOM   4589  O   LEU   604      17.222  11.973  45.659  1.00 77.20           O  
ATOM   4590  CB  LEU   604      19.615  10.728  43.990  1.00 73.64           C  
ATOM   4591  CG  LEU   604      20.986  10.173  43.696  1.00 75.02           C  
ATOM   4592  CD1 LEU   604      21.069   8.751  44.231  1.00 75.61           C  
ATOM   4593  CD2 LEU   604      21.208  10.222  42.187  1.00 75.72           C  
ATOM   4594  N   THR   605      17.971  13.368  44.049  1.00 82.05           N  
ATOM   4595  CA  THR   605      16.682  14.024  43.829  1.00 87.99           C  
ATOM   4596  C   THR   605      16.614  14.656  42.427  1.00 92.06           C  
ATOM   4597  O   THR   605      17.018  15.804  42.282  1.00 91.89           O  
ATOM   4598  CB  THR   605      16.408  15.187  44.852  1.00 87.19           C  
ATOM   4599  OG1 THR   605      17.508  16.099  44.852  1.00 88.13           O  
ATOM   4600  CG2 THR   605      16.214  14.663  46.265  1.00 88.25           C  
ATOM   4601  N   VAL   606      16.122  13.967  41.380  1.00 96.37           N  
ATOM   4602  CA  VAL   606      16.043  14.652  40.051  1.00 99.98           C  
ATOM   4603  C   VAL   606      14.868  15.710  40.035  1.00102.78           C  
ATOM   4604  O   VAL   606      14.782  16.489  40.980  1.00103.31           O  
ATOM   4605  CB  VAL   606      15.964  13.628  38.912  1.00 99.96           C  
ATOM   4606  N   HIS   607      14.002  15.808  39.024  1.00105.50           N  
ATOM   4607  CA  HIS   607      12.937  16.829  39.087  1.00108.35           C  
ATOM   4608  C   HIS   607      12.801  17.743  37.864  1.00110.39           C  
ATOM   4609  O   HIS   607      13.573  18.687  37.710  1.00111.07           O  
ATOM   4610  N   ARG   608      11.798  17.485  37.022  1.00111.60           N  
ATOM   4611  CA  ARG   608      11.617  18.165  35.737  1.00112.49           C  
ATOM   4612  C   ARG   608      12.201  16.951  35.117  1.00113.49           C  
ATOM   4613  O   ARG   608      12.321  15.954  35.817  1.00114.46           O  
ATOM   4614  CB  ARG   608      12.600  19.350  35.586  1.00112.02           C  
ATOM   4615  N   ASP   609      12.595  16.951  33.862  1.00113.44           N  
ATOM   4616  CA  ASP   609      13.231  15.725  33.615  1.00113.39           C  
ATOM   4617  C   ASP   609      14.525  15.569  32.996  1.00112.81           C  
ATOM   4618  O   ASP   609      14.793  14.899  31.995  1.00112.71           O  
ATOM   4619  CB  ASP   609      12.259  14.637  33.353  1.00113.86           C  
ATOM   4620  CG  ASP   609      12.157  13.828  34.579  1.00114.74           C  
ATOM   4621  OD1 ASP   609      11.061  13.365  35.033  1.00115.24           O  
ATOM   4622  OD2 ASP   609      13.257  13.740  35.130  1.00115.56           O  
ATOM   4623  N   PHE   610      15.342  16.178  33.844  1.00111.79           N  
ATOM   4624  CA  PHE   610      16.726  16.349  33.707  1.00109.89           C  
ATOM   4625  C   PHE   610      17.336  15.471  32.658  1.00109.54           C  
ATOM   4626  O   PHE   610      17.175  14.243  32.650  1.00109.63           O  
ATOM   4627  CB  PHE   610      17.379  16.139  35.053  1.00108.86           C  
ATOM   4628  CG  PHE   610      18.446  17.118  35.325  1.00107.78           C  
ATOM   4629  CD1 PHE   610      18.135  18.455  35.589  1.00107.57           C  
ATOM   4630  CD2 PHE   610      19.767  16.720  35.326  1.00106.43           C  
ATOM   4631  CE1 PHE   610      19.150  19.374  35.857  1.00106.15           C  
ATOM   4632  CE2 PHE   610      20.779  17.620  35.589  1.00105.18           C  
ATOM   4633  CZ  PHE   610      20.477  18.947  35.860  1.00105.48           C  
ATOM   4634  N   ARG   611      18.003  16.138  31.728  1.00108.07           N  
ATOM   4635  CA  ARG   611      18.686  15.463  30.634  1.00106.59           C  
ATOM   4636  C   ARG   611      20.130  15.125  31.024  1.00105.26           C  
ATOM   4637  O   ARG   611      20.723  14.194  30.477  1.00105.05           O  
ATOM   4638  CB  ARG   611      18.713  16.330  29.367  1.00107.68           C  
ATOM   4639  CG  ARG   611      17.368  16.587  28.708  1.00109.30           C  
ATOM   4640  CD  ARG   611      17.569  17.092  27.281  1.00110.11           C  
ATOM   4641  NE  ARG   611      16.346  17.656  26.716  1.00112.12           N  
ATOM   4642  CZ  ARG   611      16.259  18.195  25.502  1.00112.47           C  
ATOM   4643  NH1 ARG   611      17.325  18.241  24.715  1.00112.71           N  
ATOM   4644  NH2 ARG   611      15.110  18.708  25.080  1.00112.47           N  
ATOM   4645  N   GLY   612      20.701  15.882  31.958  1.00103.30           N  
ATOM   4646  CA  GLY   612      22.066  15.617  32.380  1.00100.39           C  
ATOM   4647  C   GLY   612      22.114  14.554  33.457  1.00 98.56           C  
ATOM   4648  O   GLY   612      21.176  13.776  33.615  1.00 98.55           O  
ATOM   4649  N   THR   613      23.210  14.512  34.201  1.00 97.01           N  
ATOM   4650  CA  THR   613      23.356  13.537  35.277  1.00 95.66           C  
ATOM   4651  C   THR   613      23.316  14.265  36.631  1.00 93.38           C  
ATOM   4652  O   THR   613      23.884  15.350  36.790  1.00 92.42           O  
ATOM   4653  CB  THR   613      24.671  12.734  35.109  1.00 96.41           C  
ATOM   4654  OG1 THR   613      24.867  11.876  36.242  1.00 97.68           O  
ATOM   4655  CG2 THR   613      25.848  13.675  34.951  1.00 97.54           C  
ATOM   4656  N   PRO   614      22.633  13.675  37.625  1.00 91.41           N  
ATOM   4657  CA  PRO   614      22.537  14.311  38.942  1.00 89.38           C  
ATOM   4658  C   PRO   614      23.755  14.091  39.830  1.00 87.45           C  
ATOM   4659  O   PRO   614      24.312  13.000  39.862  1.00 87.58           O  
ATOM   4660  CB  PRO   614      21.281  13.678  39.552  1.00 89.43           C  
ATOM   4661  CG  PRO   614      20.746  12.689  38.469  1.00 90.29           C  
ATOM   4662  CD  PRO   614      21.934  12.380  37.622  1.00 90.38           C  
ATOM   4663  N   ARG   615      24.164  15.136  40.539  1.00 84.97           N  
ATOM   4664  CA  ARG   615      25.287  15.056  41.467  1.00 83.05           C  
ATOM   4665  C   ARG   615      24.654  14.870  42.845  1.00 80.76           C  
ATOM   4666  O   ARG   615      24.153  15.824  43.436  1.00 81.45           O  
ATOM   4667  CB  ARG   615      26.110  16.353  41.434  1.00 84.23           C  
ATOM   4668  CG  ARG   615      27.293  16.327  40.478  1.00 86.29           C  
ATOM   4669  CD  ARG   615      27.682  17.713  39.969  1.00 88.45           C  
ATOM   4670  NE  ARG   615      26.683  18.246  39.040  1.00 91.73           N  
ATOM   4671  CZ  ARG   615      26.888  19.260  38.197  1.00 92.76           C  
ATOM   4672  NH1 ARG   615      28.068  19.873  38.152  1.00 91.99           N  
ATOM   4673  NH2 ARG   615      25.907  19.656  37.389  1.00 92.59           N  
ATOM   4674  N   PRO   616      24.653  13.633  43.366  1.00 77.99           N  
ATOM   4675  CA  PRO   616      24.065  13.346  44.679  1.00 75.68           C  
ATOM   4676  C   PRO   616      24.794  14.010  45.848  1.00 74.01           C  
ATOM   4677  O   PRO   616      25.881  14.555  45.670  1.00 73.60           O  
ATOM   4678  CB  PRO   616      24.112  11.822  44.739  1.00 76.27           C  
ATOM   4679  CG  PRO   616      25.339  11.493  43.938  1.00 76.13           C  
ATOM   4680  CD  PRO   616      25.205  12.410  42.756  1.00 77.04           C  
ATOM   4681  N   LEU   617      24.180  13.979  47.033  1.00 71.30           N  
ATOM   4682  CA  LEU   617      24.781  14.562  48.236  1.00 68.30           C  
ATOM   4683  C   LEU   617      25.391  13.458  49.073  1.00 66.32           C  
ATOM   4684  O   LEU   617      24.703  12.500  49.418  1.00 65.75           O  
ATOM   4685  CB  LEU   617      23.732  15.259  49.105  1.00 69.03           C  
ATOM   4686  CG  LEU   617      23.004  16.529  48.659  1.00 69.07           C  
ATOM   4687  CD1 LEU   617      21.788  16.715  49.561  1.00 67.97           C  
ATOM   4688  CD2 LEU   617      23.936  17.745  48.717  1.00 66.95           C  
ATOM   4689  N   LYS   618      26.672  13.592  49.402  1.00 63.61           N  
ATOM   4690  CA  LYS   618      27.349  12.605  50.232  1.00 61.60           C  
ATOM   4691  C   LYS   618      27.148  13.045  51.683  1.00 58.76           C  
ATOM   4692  O   LYS   618      27.395  14.190  52.038  1.00 58.25           O  
ATOM   4693  CB  LYS   618      28.843  12.548  49.880  1.00 64.59           C  
ATOM   4694  CG  LYS   618      29.564  11.281  50.358  1.00 67.29           C  
ATOM   4695  CD  LYS   618      30.944  11.098  49.708  1.00 68.43           C  
ATOM   4696  CE  LYS   618      31.952  12.118  50.222  1.00 71.78           C  
ATOM   4697  NZ  LYS   618      33.316  11.959  49.624  1.00 73.75           N  
ATOM   4698  N   LEU   619      26.671  12.135  52.519  1.00 56.19           N  
ATOM   4699  CA  LEU   619      26.421  12.457  53.918  1.00 53.00           C  
ATOM   4700  C   LEU   619      27.130  11.458  54.791  1.00 50.95           C  
ATOM   4701  O   LEU   619      27.077  10.264  54.533  1.00 49.93           O  
ATOM   4702  CB  LEU   619      24.907  12.449  54.217  1.00 51.72           C  
ATOM   4703  CG  LEU   619      24.099  13.618  53.616  1.00 52.03           C  
ATOM   4704  CD1 LEU   619      23.492  13.242  52.249  1.00 48.17           C  
ATOM   4705  CD2 LEU   619      22.997  14.006  54.597  1.00 51.71           C  
ATOM   4706  N   VAL   620      27.793  11.950  55.829  1.00 50.06           N  
ATOM   4707  CA  VAL   620      28.520  11.072  56.722  1.00 50.88           C  
ATOM   4708  C   VAL   620      28.122  11.191  58.193  1.00 52.09           C  
ATOM   4709  O   VAL   620      28.237  12.243  58.819  1.00 52.98           O  
ATOM   4710  CB  VAL   620      30.047  11.288  56.582  1.00 50.70           C  
ATOM   4711  CG1 VAL   620      30.792  10.336  57.504  1.00 48.15           C  
ATOM   4712  CG2 VAL   620      30.467  11.064  55.122  1.00 49.58           C  
ATOM   4713  N   HIS   621      27.637  10.087  58.736  1.00 52.52           N  
ATOM   4714  CA  HIS   621      27.234  10.049  60.126  1.00 54.24           C  
ATOM   4715  C   HIS   621      28.535   9.986  60.943  1.00 55.51           C  
ATOM   4716  O   HIS   621      29.231   8.976  60.933  1.00 57.01           O  
ATOM   4717  CB  HIS   621      26.348   8.816  60.344  1.00 52.19           C  
ATOM   4718  CG  HIS   621      25.690   8.780  61.682  1.00 49.95           C  
ATOM   4719  ND1 HIS   621      25.554   9.901  62.470  1.00 49.79           N  
ATOM   4720  CD2 HIS   621      25.117   7.766  62.366  1.00 48.63           C  
ATOM   4721  CE1 HIS   621      24.926   9.577  63.585  1.00 49.12           C  
ATOM   4722  NE2 HIS   621      24.650   8.287  63.547  1.00 49.83           N  
ATOM   4723  N   GLU   622      28.863  11.071  61.636  1.00 56.25           N  
ATOM   4724  CA  GLU   622      30.098  11.141  62.403  1.00 57.05           C  
ATOM   4725  C   GLU   622      29.946  10.854  63.894  1.00 58.12           C  
ATOM   4726  O   GLU   622      30.845  10.281  64.511  1.00 59.02           O  
ATOM   4727  CB  GLU   622      30.747  12.507  62.184  1.00 58.06           C  
ATOM   4728  CG  GLU   622      30.819  12.889  60.709  1.00 62.39           C  
ATOM   4729  CD  GLU   622      31.334  14.314  60.467  1.00 66.12           C  
ATOM   4730  OE1 GLU   622      30.847  15.249  61.145  1.00 67.44           O  
ATOM   4731  OE2 GLU   622      32.212  14.503  59.587  1.00 67.38           O  
ATOM   4732  N   ALA   623      28.832  11.261  64.488  1.00 57.86           N  
ATOM   4733  CA  ALA   623      28.596  10.990  65.899  1.00 58.83           C  
ATOM   4734  C   ALA   623      27.132  10.643  65.987  1.00 60.26           C  
ATOM   4735  O   ALA   623      26.342  11.119  65.178  1.00 60.53           O  
ATOM   4736  CB  ALA   623      28.896  12.212  66.747  1.00 58.56           C  
ATOM   4737  N   GLY   624      26.755   9.818  66.953  1.00 60.83           N  
ATOM   4738  CA  GLY   624      25.357   9.455  67.051  1.00 62.40           C  
ATOM   4739  C   GLY   624      25.112   7.966  67.101  1.00 62.64           C  
ATOM   4740  O   GLY   624      25.976   7.169  66.793  1.00 63.72           O  
ATOM   4741  N   ASP   625      23.892   7.598  67.449  1.00 64.31           N  
ATOM   4742  CA  ASP   625      23.520   6.206  67.611  1.00 63.93           C  
ATOM   4743  C   ASP   625      22.377   5.831  66.665  1.00 63.33           C  
ATOM   4744  O   ASP   625      22.080   4.657  66.451  1.00 63.83           O  
ATOM   4745  CB  ASP   625      23.099   6.031  69.071  1.00 66.46           C  
ATOM   4746  CG  ASP   625      23.224   4.615  69.549  1.00 70.81           C  
ATOM   4747  OD1 ASP   625      24.043   3.864  68.973  1.00 73.03           O  
ATOM   4748  OD2 ASP   625      22.511   4.259  70.515  1.00 72.36           O  
ATOM   4749  N   THR   626      21.741   6.842  66.091  1.00 60.45           N  
ATOM   4750  CA  THR   626      20.617   6.622  65.200  1.00 57.55           C  
ATOM   4751  C   THR   626      20.964   5.897  63.913  1.00 55.50           C  
ATOM   4752  O   THR   626      21.995   6.142  63.312  1.00 54.83           O  
ATOM   4753  CB  THR   626      19.947   7.960  64.877  1.00 55.91           C  
ATOM   4754  OG1 THR   626      19.422   8.500  66.088  1.00 54.91           O  
ATOM   4755  CG2 THR   626      18.823   7.789  63.872  1.00 54.87           C  
ATOM   4756  N   PRO   627      20.097   4.975  63.483  1.00 54.84           N  
ATOM   4757  CA  PRO   627      20.298   4.197  62.252  1.00 54.85           C  
ATOM   4758  C   PRO   627      20.447   5.117  61.042  1.00 54.29           C  
ATOM   4759  O   PRO   627      19.838   6.167  61.002  1.00 53.53           O  
ATOM   4760  CB  PRO   627      19.029   3.360  62.177  1.00 53.12           C  
ATOM   4761  CG  PRO   627      18.713   3.141  63.608  1.00 53.59           C  
ATOM   4762  CD  PRO   627      18.916   4.493  64.218  1.00 53.08           C  
ATOM   4763  N   LEU   628      21.245   4.734  60.053  1.00 55.05           N  
ATOM   4764  CA  LEU   628      21.398   5.598  58.890  1.00 55.66           C  
ATOM   4765  C   LEU   628      20.067   5.861  58.195  1.00 55.81           C  
ATOM   4766  O   LEU   628      19.745   7.001  57.917  1.00 56.68           O  
ATOM   4767  CB  LEU   628      22.404   5.020  57.893  1.00 54.95           C  
ATOM   4768  CG  LEU   628      23.904   5.252  58.123  1.00 54.91           C  
ATOM   4769  CD1 LEU   628      24.670   4.834  56.866  1.00 55.51           C  
ATOM   4770  CD2 LEU   628      24.185   6.712  58.405  1.00 53.16           C  
ATOM   4771  N   GLU   629      19.296   4.813  57.931  1.00 56.89           N  
ATOM   4772  CA  GLU   629      18.000   4.940  57.274  1.00 58.00           C  
ATOM   4773  C   GLU   629      17.156   6.035  57.978  1.00 58.26           C  
ATOM   4774  O   GLU   629      16.634   6.937  57.321  1.00 59.42           O  
ATOM   4775  CB  GLU   629      17.262   3.577  57.298  1.00 59.16           C  
ATOM   4776  CG  GLU   629      16.349   3.285  56.081  1.00 63.27           C  
ATOM   4777  CD  GLU   629      15.484   1.990  56.223  1.00 67.20           C  
ATOM   4778  OE1 GLU   629      14.428   2.011  56.906  1.00 67.03           O  
ATOM   4779  OE2 GLU   629      15.860   0.941  55.646  1.00 68.18           O  
ATOM   4780  N   ALA   630      17.021   5.968  59.301  1.00 56.63           N  
ATOM   4781  CA  ALA   630      16.237   6.978  60.025  1.00 55.58           C  
ATOM   4782  C   ALA   630      16.773   8.395  59.768  1.00 54.83           C  
ATOM   4783  O   ALA   630      16.005   9.320  59.526  1.00 55.36           O  
ATOM   4784  CB  ALA   630      16.236   6.675  61.537  1.00 54.68           C  
ATOM   4785  N   LEU   631      18.092   8.552  59.827  1.00 53.44           N  
ATOM   4786  CA  LEU   631      18.755   9.827  59.581  1.00 53.08           C  
ATOM   4787  C   LEU   631      18.530  10.334  58.137  1.00 53.36           C  
ATOM   4788  O   LEU   631      18.319  11.534  57.904  1.00 52.55           O  
ATOM   4789  CB  LEU   631      20.251   9.663  59.842  1.00 52.55           C  
ATOM   4790  CG  LEU   631      21.003  10.435  60.932  1.00 51.06           C  
ATOM   4791  CD1 LEU   631      20.205  10.576  62.193  1.00 50.77           C  
ATOM   4792  CD2 LEU   631      22.285   9.672  61.215  1.00 50.40           C  
ATOM   4793  N   ALA   632      18.585   9.423  57.171  1.00 53.33           N  
ATOM   4794  CA  ALA   632      18.382   9.784  55.769  1.00 55.11           C  
ATOM   4795  C   ALA   632      16.951  10.290  55.536  1.00 56.54           C  
ATOM   4796  O   ALA   632      16.694  11.137  54.678  1.00 56.19           O  
ATOM   4797  CB  ALA   632      18.671   8.585  54.877  1.00 52.98           C  
ATOM   4798  N   HIS   633      16.018   9.772  56.310  1.00 58.41           N  
ATOM   4799  CA  HIS   633      14.639  10.180  56.175  1.00 61.72           C  
ATOM   4800  C   HIS   633      14.416  11.568  56.632  1.00 61.43           C  
ATOM   4801  O   HIS   633      13.736  12.361  55.993  1.00 62.04           O  
ATOM   4802  CB  HIS   633      13.759   9.332  57.043  1.00 66.12           C  
ATOM   4803  CG  HIS   633      13.138   8.199  56.324  1.00 70.02           C  
ATOM   4804  ND1 HIS   633      11.840   8.237  55.869  1.00 72.49           N  
ATOM   4805  CD2 HIS   633      13.638   6.994  55.967  1.00 71.51           C  
ATOM   4806  CE1 HIS   633      11.568   7.096  55.259  1.00 74.39           C  
ATOM   4807  NE2 HIS   633      12.641   6.325  55.305  1.00 72.34           N  
ATOM   4808  N   GLN   634      14.948  11.834  57.804  1.00 59.85           N  
ATOM   4809  CA  GLN   634      14.776  13.131  58.357  1.00 58.93           C  
ATOM   4810  C   GLN   634      15.453  14.177  57.500  1.00 57.39           C  
ATOM   4811  O   GLN   634      14.864  15.195  57.195  1.00 57.55           O  
ATOM   4812  CB  GLN   634      15.296  13.170  59.785  1.00 60.41           C  
ATOM   4813  CG  GLN   634      14.524  14.168  60.598  1.00 62.60           C  
ATOM   4814  CD  GLN   634      14.867  14.122  62.056  1.00 63.88           C  
ATOM   4815  OE1 GLN   634      15.418  13.134  62.552  1.00 65.00           O  
ATOM   4816  NE2 GLN   634      14.524  15.187  62.769  1.00 64.50           N  
ATOM   4817  N   ILE   635      16.680  13.929  57.081  1.00 56.39           N  
ATOM   4818  CA  ILE   635      17.350  14.926  56.277  1.00 55.93           C  
ATOM   4819  C   ILE   635      16.606  15.139  54.977  1.00 57.66           C  
ATOM   4820  O   ILE   635      16.287  16.282  54.614  1.00 57.88           O  
ATOM   4821  CB  ILE   635      18.800  14.525  56.005  1.00 53.28           C  
ATOM   4822  CG1 ILE   635      19.581  14.571  57.316  1.00 51.56           C  
ATOM   4823  CG2 ILE   635      19.419  15.466  55.005  1.00 49.92           C  
ATOM   4824  CD1 ILE   635      20.880  13.836  57.275  1.00 53.17           C  
ATOM   4825  N   PHE   636      16.303  14.036  54.295  1.00 59.01           N  
ATOM   4826  CA  PHE   636      15.593  14.093  53.021  1.00 59.73           C  
ATOM   4827  C   PHE   636      14.287  14.849  53.165  1.00 60.41           C  
ATOM   4828  O   PHE   636      13.950  15.665  52.303  1.00 58.94           O  
ATOM   4829  CB  PHE   636      15.318  12.686  52.489  1.00 59.50           C  
ATOM   4830  CG  PHE   636      14.426  12.660  51.282  1.00 59.22           C  
ATOM   4831  CD1 PHE   636      14.816  13.286  50.094  1.00 59.56           C  
ATOM   4832  CD2 PHE   636      13.180  12.033  51.336  1.00 58.45           C  
ATOM   4833  CE1 PHE   636      13.970  13.297  48.970  1.00 58.49           C  
ATOM   4834  CE2 PHE   636      12.325  12.033  50.219  1.00 58.88           C  
ATOM   4835  CZ  PHE   636      12.723  12.669  49.034  1.00 58.28           C  
ATOM   4836  N   HIS   637      13.557  14.587  54.251  1.00 61.30           N  
ATOM   4837  CA  HIS   637      12.292  15.281  54.473  1.00 64.05           C  
ATOM   4838  C   HIS   637      12.502  16.767  54.762  1.00 66.33           C  
ATOM   4839  O   HIS   637      11.690  17.592  54.366  1.00 67.78           O  
ATOM   4840  CB  HIS   637      11.483  14.626  55.600  1.00 62.63           C  
ATOM   4841  CG  HIS   637      10.771  13.369  55.183  1.00 62.33           C  
ATOM   4842  ND1 HIS   637       9.922  12.677  56.025  1.00 61.36           N  
ATOM   4843  CD2 HIS   637      10.772  12.691  54.011  1.00 59.59           C  
ATOM   4844  CE1 HIS   637       9.432  11.628  55.388  1.00 60.62           C  
ATOM   4845  NE2 HIS   637       9.933  11.613  54.165  1.00 60.24           N  
ATOM   4846  N   LEU   638      13.592  17.121  55.433  1.00 68.96           N  
ATOM   4847  CA  LEU   638      13.851  18.525  55.714  1.00 71.24           C  
ATOM   4848  C   LEU   638      14.179  19.234  54.413  1.00 72.96           C  
ATOM   4849  O   LEU   638      13.727  20.342  54.172  1.00 72.85           O  
ATOM   4850  CB  LEU   638      15.003  18.682  56.709  1.00 71.28           C  
ATOM   4851  CG  LEU   638      14.690  18.270  58.150  1.00 71.29           C  
ATOM   4852  CD1 LEU   638      15.908  18.516  59.032  1.00 70.20           C  
ATOM   4853  CD2 LEU   638      13.480  19.054  58.655  1.00 71.25           C  
ATOM   4854  N   THR   639      14.964  18.586  53.569  1.00 76.08           N  
ATOM   4855  CA  THR   639      15.320  19.160  52.282  1.00 79.92           C  
ATOM   4856  C   THR   639      14.111  19.624  51.473  1.00 83.99           C  
ATOM   4857  O   THR   639      14.052  20.783  51.066  1.00 84.97           O  
ATOM   4858  CB  THR   639      16.089  18.159  51.432  1.00 78.66           C  
ATOM   4859  OG1 THR   639      17.443  18.099  51.897  1.00 77.59           O  
ATOM   4860  CG2 THR   639      16.045  18.562  49.959  1.00 76.87           C  
ATOM   4861  N   ARG   640      13.162  18.724  51.219  1.00 87.69           N  
ATOM   4862  CA  ARG   640      11.972  19.086  50.447  1.00 90.86           C  
ATOM   4863  C   ARG   640      11.179  20.199  51.126  1.00 92.99           C  
ATOM   4864  O   ARG   640      10.896  21.232  50.509  1.00 93.79           O  
ATOM   4865  CB  ARG   640      11.049  17.876  50.247  1.00 92.32           C  
ATOM   4866  CG  ARG   640      11.269  17.077  48.961  1.00 94.07           C  
ATOM   4867  CD  ARG   640      12.554  16.264  49.014  1.00 96.16           C  
ATOM   4868  NE  ARG   640      13.709  16.964  48.456  1.00 97.05           N  
ATOM   4869  CZ  ARG   640      14.015  16.990  47.162  1.00 97.04           C  
ATOM   4870  NH1 ARG   640      13.250  16.353  46.283  1.00 96.78           N  
ATOM   4871  NH2 ARG   640      15.092  17.643  46.748  1.00 96.82           N  
ATOM   4872  N   LEU   641      10.825  19.984  52.393  1.00 94.26           N  
ATOM   4873  CA  LEU   641      10.053  20.958  53.157  1.00 94.92           C  
ATOM   4874  C   LEU   641      10.474  22.396  52.894  1.00 95.62           C  
ATOM   4875  O   LEU   641       9.624  23.276  52.789  1.00 95.48           O  
ATOM   4876  CB  LEU   641      10.150  20.661  54.653  1.00 95.89           C  
ATOM   4877  CG  LEU   641       9.438  21.651  55.582  1.00 97.68           C  
ATOM   4878  CD1 LEU   641       8.059  22.000  55.037  1.00 98.03           C  
ATOM   4879  CD2 LEU   641       9.329  21.040  56.973  1.00 98.61           C  
ATOM   4880  N   TYR   642      11.778  22.638  52.780  1.00 96.08           N  
ATOM   4881  CA  TYR   642      12.261  23.991  52.528  1.00 96.65           C  
ATOM   4882  C   TYR   642      13.021  24.118  51.208  1.00 96.48           C  
ATOM   4883  O   TYR   642      12.342  24.193  50.159  1.00 95.61           O  
ATOM   4884  CB  TYR   642      13.145  24.455  53.689  1.00 98.05           C  
ATOM   4885  CG  TYR   642      12.451  24.449  55.040  1.00 99.99           C  
ATOM   4886  CD1 TYR   642      12.547  23.347  55.897  1.00100.65           C  
ATOM   4887  CD2 TYR   642      11.692  25.546  55.462  1.00100.55           C  
ATOM   4888  CE1 TYR   642      11.906  23.338  57.144  1.00101.31           C  
ATOM   4889  CE2 TYR   642      11.044  25.546  56.706  1.00101.33           C  
ATOM   4890  CZ  TYR   642      11.155  24.439  57.542  1.00101.51           C  
ATOM   4891  OH  TYR   642      10.510  24.431  58.764  1.00101.44           O  
END
