
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  700),  selected   95 , name 1n7e_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 1n7e_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   667_A      S       1          3.676
LGA    A   668_A      M       2          2.080
LGA    I   669_A      E       3          0.716
LGA    I   670_A      I       4          0.059
LGA    Y   671_A      L       5          0.621
LGA    T   672_A      Q       6          0.429
LGA    V   673_A      V       7          1.061
LGA    E   674_A      A       8          1.000
LGA    L   675_A      L       9          0.869
LGA    K   676_A      H      10          0.505
LGA    R   677_A      K      11          1.365
LGA    Y   678_A      R      12          1.160
LGA    G   679_A      D      13          1.355
LGA    -       -      S      14           -
LGA    -       -      G      15           -
LGA    G   680_A      E      16          1.853
LGA    P   681_A      Q      17          1.486
LGA    L   682_A      L      18          1.051
LGA    G   683_A      G      19          1.054
LGA    I   684_A      I      20          1.038
LGA    T   685_A      K      21          1.094
LGA    I   686_A      L      22          0.761
LGA    S   687_A      V      23          0.761
LGA    G   688_A      R      24          0.880
LGA    T   689_A      R      25          5.750
LGA    E   690_A      T      26           -
LGA    E   691_A      D      27           -
LGA    P   692_A      -       -           -
LGA    F   693_A      E      28          6.554
LGA    D   694_A      P      29          1.610
LGA    P   695_A      G      30          1.824
LGA    I   696_A      V      31          0.875
LGA    I   697_A      F      32          0.896
LGA    I   698_A      I      33          0.738
LGA    S   699_A      L      34          0.727
LGA    S   700_A      D      35          1.363
LGA    L   701_A      L      36          0.920
LGA    T   702_A      L      37          1.126
LGA    K   703_A      E      38          0.759
LGA    G   704_A      G      39          1.080
LGA    G   705_A      G      40          1.106
LGA    L   706_A      L      41          1.199
LGA    A   707_A      A      42          0.752
LGA    E   708_A      A      43          0.675
LGA    R   709_A      Q      44          1.042
LGA    T   710_A      D      45          1.201
LGA    G   711_A      G      46          0.880
LGA    A   712_A      R      47          1.162
LGA    I   713_A      L      48          1.084
LGA    H   714_A      S      49          0.983
LGA    I   715_A      S      50          1.277
LGA    G   716_A      N      51          1.361
LGA    D   717_A      D      52          0.927
LGA    R   718_A      R      53          0.938
LGA    I   719_A      V      54          0.544
LGA    L   720_A      L      55          0.494
LGA    A   721_A      A      56          0.334
LGA    I   722_A      I      57          0.623
LGA    N   723_A      N      58          0.580
LGA    S   724_A      G      59          0.619
LGA    S   725_A      H      60          0.598
LGA    S   726_A      D      61          0.882
LGA    L   727_A      L      62          0.939
LGA    K   728_A      K      63          2.277
LGA    G   729_A      Y      64          2.216
LGA    K   730_A      G      65          2.036
LGA    P   731_A      T      66          2.611
LGA    L   732_A      P      67          2.611
LGA    S   733_A      E      68          1.990
LGA    E   734_A      L      69          1.321
LGA    A   735_A      A      70          1.625
LGA    I   736_A      A      71          1.846
LGA    H   737_A      Q      72          1.426
LGA    L   738_A      I      73          1.338
LGA    L   739_A      I      74          1.575
LGA    Q   740_A      Q      75          1.312
LGA    M   741_A      A      76          1.431
LGA    A   742_A      S      77          1.466
LGA    G   743_A      G      78          1.702
LGA    E   744_A      E      79          1.059
LGA    T   745_A      R      80          1.075
LGA    V   746_A      V      81          0.270
LGA    T   747_A      N      82          0.445
LGA    L   748_A      L      83          0.060
LGA    K   749_A      T      84          0.072
LGA    I   750_A      I      85          0.525
LGA    K   751_A      A      86          0.773
LGA    K   752_A      R      87          0.842
LGA    Q   753_A      P      88          2.788
LGA    T   754_A      G      89          1.559
LGA    D   755_A      K      90          4.612
LGA    A   756_A      P      91           -
LGA    Q   757_A      E      92           -
LGA    P   758_A      I      93           -
LGA    A   759_A      E      94           -
LGA    S   760_A      L      95           -
LGA    S   761_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   95    5.0     86    1.67    32.56     85.199     4.864

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.364148 * X  +   0.486055 * Y  +  -0.794448 * Z  +  50.466255
  Y_new =   0.192923 * X  +   0.795146 * Y  +   0.574911 * Z  + -41.975994
  Z_new =   0.911140 * X  +  -0.362620 * Y  +   0.195779 * Z  +   3.304758 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.075739    2.065854  [ DEG:   -61.6353    118.3647 ]
  Theta =  -1.146043   -1.995550  [ DEG:   -65.6634   -114.3366 ]
  Phi   =   0.487198   -2.654395  [ DEG:    27.9144   -152.0856 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1n7e_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1n7e_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   95   5.0   86   1.67   32.56  85.199
REMARK  ---------------------------------------------------------- 
MOLECULE 1n7e_A
HEADER    PROTEIN BINDING                         14-NOV-02   1N7E              
TITLE     CRYSTAL STRUCTURE OF THE SIXTH PDZ DOMAIN OF GRIP1                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AMPA RECEPTOR INTERACTING PROTEIN GRIP;                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SIXTH PDZ DOMAIN;                                          
COMPND   5 SYNONYM: GLUTAMATE RECEPTOR INTERACTING PROTEIN 1;                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: GRIP1;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PGEX-4T                                   
KEYWDS    PDZ, GRIP                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.J.IM,S.H.PARK,S.H.RHO,J.H.LEE,G.B.KANG,M.SHENG,E.KIM,               
AUTHOR   2 S.H.EOM                                                              
REVDAT   1   12-AUG-03 1N7E    0                                                
JRNL        AUTH   Y.J.IM,S.H.PARK,S.H.RHO,J.H.LEE,G.B.KANG,M.SHENG,            
JRNL        AUTH 2 E.KIM,S.H.EOM                                                
JRNL        TITL   CRYSTAL STRUCTURE OF GRIP1 PDZ6-PEPTIDE COMPLEX              
JRNL        TITL 2 REVEALS THE STRUCTURAL BASIS FOR CLASS II PDZ                
JRNL        TITL 3 TARGET RECOGNITION AND PDZ DOMAIN-MEDIATED                   
JRNL        TITL 4 MULTIMERIZATION                                              
JRNL        REF    J.BIOL.CHEM.                  V. 278  8501 2003              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1N7E A  665   761  UNP    P97879   GRIP1_RAT      665    761             
SEQRES   1 A   97  SER SER GLY ALA ILE ILE TYR THR VAL GLU LEU LYS ARG          
SEQRES   2 A   97  TYR GLY GLY PRO LEU GLY ILE THR ILE SER GLY THR GLU          
SEQRES   3 A   97  GLU PRO PHE ASP PRO ILE ILE ILE SER SER LEU THR LYS          
SEQRES   4 A   97  GLY GLY LEU ALA GLU ARG THR GLY ALA ILE HIS ILE GLY          
SEQRES   5 A   97  ASP ARG ILE LEU ALA ILE ASN SER SER SER LEU LYS GLY          
SEQRES   6 A   97  LYS PRO LEU SER GLU ALA ILE HIS LEU LEU GLN MET ALA          
SEQRES   7 A   97  GLY GLU THR VAL THR LEU LYS ILE LYS LYS GLN THR ASP          
SEQRES   8 A   97  ALA GLN PRO ALA SER SER                                      
FORMUL   2  HOH   *141(H2 O)                                                    
CRYST1   40.267   40.267  222.872  90.00  90.00 120.00 P 65 2 2     12          
ATOM      1  N   GLY A 667      24.388  11.051  22.681  1.00 38.75           N  
ATOM      2  CA  GLY A 667      24.392  12.438  22.112  1.00 37.03           C  
ATOM      3  C   GLY A 667      23.271  12.640  21.108  1.00 36.03           C  
ATOM      4  O   GLY A 667      22.666  11.671  20.648  1.00 37.12           O  
ATOM      5  N   ALA A 668      22.989  13.897  20.775  1.00 34.50           N  
ATOM      6  CA  ALA A 668      21.934  14.219  19.820  1.00 31.77           C  
ATOM      7  C   ALA A 668      22.370  13.823  18.428  1.00 29.46           C  
ATOM      8  O   ALA A 668      23.514  14.066  18.039  1.00 29.42           O  
ATOM      9  CB  ALA A 668      21.639  15.697  19.850  1.00 33.91           C  
ATOM     10  N   ILE A 669      21.462  13.212  17.677  1.00 25.54           N  
ATOM     11  CA  ILE A 669      21.776  12.803  16.315  1.00 23.05           C  
ATOM     12  C   ILE A 669      21.103  13.755  15.334  1.00 19.76           C  
ATOM     13  O   ILE A 669      19.878  13.802  15.240  1.00 18.24           O  
ATOM     14  CB  ILE A 669      21.300  11.352  16.021  1.00 24.93           C  
ATOM     15  CG1 ILE A 669      21.980  10.366  16.976  1.00 28.04           C  
ATOM     16  CG2 ILE A 669      21.636  10.973  14.579  1.00 27.08           C  
ATOM     17  CD1 ILE A 669      23.481  10.314  16.834  1.00 29.26           C  
ATOM     18  N   ILE A 670      21.920  14.521  14.622  1.00 18.30           N  
ATOM     19  CA  ILE A 670      21.424  15.469  13.638  1.00 18.06           C  
ATOM     20  C   ILE A 670      22.043  15.118  12.295  1.00 17.24           C  
ATOM     21  O   ILE A 670      23.262  14.996  12.191  1.00 18.23           O  
ATOM     22  CB  ILE A 670      21.828  16.908  13.996  1.00 17.85           C  
ATOM     23  CG1 ILE A 670      21.318  17.259  15.398  1.00 21.67           C  
ATOM     24  CG2 ILE A 670      21.262  17.875  12.975  1.00 19.05           C  
ATOM     25  CD1 ILE A 670      21.678  18.660  15.853  1.00 22.18           C  
ATOM     26  N   TYR A 671      21.208  14.932  11.277  1.00 15.91           N  
ATOM     27  CA  TYR A 671      21.694  14.610   9.935  1.00 15.33           C  
ATOM     28  C   TYR A 671      20.851  15.384   8.929  1.00 15.30           C  
ATOM     29  O   TYR A 671      19.801  15.931   9.276  1.00 15.37           O  
ATOM     30  CB  TYR A 671      21.616  13.092   9.663  1.00 15.76           C  
ATOM     31  CG  TYR A 671      20.216  12.539   9.514  1.00 15.99           C  
ATOM     32  CD1 TYR A 671      19.713  12.199   8.261  1.00 17.29           C  
ATOM     33  CD2 TYR A 671      19.392  12.361  10.624  1.00 17.54           C  
ATOM     34  CE1 TYR A 671      18.418  11.694   8.117  1.00 17.93           C  
ATOM     35  CE2 TYR A 671      18.097  11.864  10.493  1.00 15.96           C  
ATOM     36  CZ  TYR A 671      17.617  11.525   9.237  1.00 16.81           C  
ATOM     37  OH  TYR A 671      16.348  11.003   9.099  1.00 17.83           O  
ATOM     38  N   THR A 672      21.310  15.450   7.687  1.00 15.08           N  
ATOM     39  CA  THR A 672      20.568  16.182   6.678  1.00 15.98           C  
ATOM     40  C   THR A 672      20.244  15.305   5.477  1.00 15.78           C  
ATOM     41  O   THR A 672      21.057  14.477   5.064  1.00 16.79           O  
ATOM     42  CB  THR A 672      21.363  17.420   6.210  1.00 17.69           C  
ATOM     43  OG1 THR A 672      21.688  18.235   7.345  1.00 20.11           O  
ATOM     44  CG2 THR A 672      20.547  18.239   5.235  1.00 19.51           C  
ATOM     45  N   VAL A 673      19.044  15.473   4.930  1.00 15.97           N  
ATOM     46  CA  VAL A 673      18.644  14.707   3.763  1.00 16.54           C  
ATOM     47  C   VAL A 673      18.135  15.639   2.675  1.00 17.98           C  
ATOM     48  O   VAL A 673      17.424  16.606   2.946  1.00 17.93           O  
ATOM     49  CB  VAL A 673      17.541  13.686   4.090  1.00 18.58           C  
ATOM     50  CG1 VAL A 673      18.048  12.691   5.100  1.00 21.53           C  
ATOM     51  CG2 VAL A 673      16.331  14.384   4.624  1.00 20.31           C  
ATOM     52  N   GLU A 674      18.528  15.351   1.440  1.00 14.57           N  
ATOM     53  CA  GLU A 674      18.107  16.134   0.292  1.00 17.37           C  
ATOM     54  C   GLU A 674      17.254  15.221  -0.565  1.00 16.55           C  
ATOM     55  O   GLU A 674      17.705  14.158  -0.988  1.00 16.76           O  
ATOM     56  CB  GLU A 674      19.321  16.620  -0.497  1.00 18.09           C  
ATOM     57  CG  GLU A 674      18.971  17.285  -1.820  1.00 23.67           C  
ATOM     58  CD  GLU A 674      20.202  17.727  -2.590  1.00 27.77           C  
ATOM     59  OE1 GLU A 674      20.797  18.761  -2.222  1.00 31.51           O  
ATOM     60  OE2 GLU A 674      20.583  17.033  -3.558  1.00 30.44           O  
ATOM     61  N   LEU A 675      16.014  15.632  -0.805  1.00 18.35           N  
ATOM     62  CA  LEU A 675      15.082  14.842  -1.601  1.00 18.56           C  
ATOM     63  C   LEU A 675      14.688  15.605  -2.860  1.00 19.40           C  
ATOM     64  O   LEU A 675      14.537  16.826  -2.828  1.00 20.03           O  
ATOM     65  CB  LEU A 675      13.826  14.538  -0.781  1.00 21.01           C  
ATOM     66  CG  LEU A 675      13.971  13.747   0.519  1.00 21.19           C  
ATOM     67  CD1 LEU A 675      12.663  13.840   1.295  1.00 23.73           C  
ATOM     68  CD2 LEU A 675      14.320  12.311   0.225  1.00 23.72           C  
ATOM     69  N   LYS A 676      14.528  14.886  -3.966  1.00 20.21           N  
ATOM     70  CA  LYS A 676      14.139  15.504  -5.226  1.00 21.53           C  
ATOM     71  C   LYS A 676      12.698  15.077  -5.467  1.00 21.57           C  
ATOM     72  O   LYS A 676      12.444  13.922  -5.802  1.00 20.75           O  
ATOM     73  CB  LYS A 676      15.043  15.012  -6.359  1.00 23.23           C  
ATOM     74  CG  LYS A 676      14.962  15.864  -7.603  1.00 28.02           C  
ATOM     75  CD  LYS A 676      16.027  15.497  -8.614  1.00 31.00           C  
ATOM     76  CE  LYS A 676      15.960  16.409  -9.841  1.00 32.48           C  
ATOM     77  NZ  LYS A 676      16.992  16.042 -10.873  1.00 34.99           N  
ATOM     78  N   ARG A 677      11.758  16.006  -5.291  1.00 24.29           N  
ATOM     79  CA  ARG A 677      10.334  15.705  -5.445  1.00 25.98           C  
ATOM     80  C   ARG A 677       9.730  15.745  -6.859  1.00 27.59           C  
ATOM     81  O   ARG A 677       8.578  15.350  -7.048  1.00 27.03           O  
ATOM     82  CB  ARG A 677       9.516  16.598  -4.494  1.00 27.82           C  
ATOM     83  CG  ARG A 677       9.803  18.092  -4.603  1.00 29.11           C  
ATOM     84  CD  ARG A 677       9.070  18.892  -3.526  1.00 30.49           C  
ATOM     85  NE  ARG A 677       9.293  20.331  -3.668  1.00 32.28           N  
ATOM     86  CZ  ARG A 677       8.928  21.247  -2.770  1.00 33.62           C  
ATOM     87  NH1 ARG A 677       8.317  20.888  -1.645  1.00 34.13           N  
ATOM     88  NH2 ARG A 677       9.175  22.532  -2.997  1.00 34.73           N  
ATOM     89  N   TYR A 678      10.498  16.198  -7.850  1.00 30.16           N  
ATOM     90  CA  TYR A 678      10.017  16.257  -9.240  1.00 31.69           C  
ATOM     91  C   TYR A 678       8.565  16.699  -9.417  1.00 31.67           C  
ATOM     92  O   TYR A 678       7.731  15.931  -9.916  1.00 34.06           O  
ATOM     93  CB  TYR A 678      10.161  14.897  -9.930  1.00 32.94           C  
ATOM     94  CG  TYR A 678      11.579  14.453 -10.172  1.00 35.08           C  
ATOM     95  CD1 TYR A 678      12.290  13.771  -9.190  1.00 35.05           C  
ATOM     96  CD2 TYR A 678      12.219  14.730 -11.384  1.00 36.17           C  
ATOM     97  CE1 TYR A 678      13.600  13.372  -9.404  1.00 37.13           C  
ATOM     98  CE2 TYR A 678      13.531  14.340 -11.608  1.00 36.46           C  
ATOM     99  CZ  TYR A 678      14.216  13.659 -10.614  1.00 36.79           C  
ATOM    100  OH  TYR A 678      15.519  13.265 -10.826  1.00 37.47           O  
ATOM    101  N   GLY A 679       8.251  17.924  -9.026  1.00 29.71           N  
ATOM    102  CA  GLY A 679       6.889  18.392  -9.191  1.00 27.49           C  
ATOM    103  C   GLY A 679       5.881  17.683  -8.312  1.00 26.91           C  
ATOM    104  O   GLY A 679       4.698  18.026  -8.318  1.00 27.22           O  
ATOM    105  N   GLY A 680       6.340  16.686  -7.566  1.00 25.48           N  
ATOM    106  CA  GLY A 680       5.452  15.958  -6.676  1.00 25.66           C  
ATOM    107  C   GLY A 680       5.663  16.358  -5.222  1.00 24.21           C  
ATOM    108  O   GLY A 680       6.532  17.181  -4.911  1.00 22.08           O  
ATOM    109  N   PRO A 681       4.866  15.804  -4.300  1.00 23.12           N  
ATOM    110  CA  PRO A 681       5.028  16.151  -2.886  1.00 21.63           C  
ATOM    111  C   PRO A 681       6.129  15.324  -2.231  1.00 19.24           C  
ATOM    112  O   PRO A 681       6.611  14.352  -2.809  1.00 19.18           O  
ATOM    113  CB  PRO A 681       3.651  15.849  -2.307  1.00 22.89           C  
ATOM    114  CG  PRO A 681       3.228  14.658  -3.102  1.00 25.35           C  
ATOM    115  CD  PRO A 681       3.633  15.025  -4.515  1.00 24.97           C  
ATOM    116  N   LEU A 682       6.534  15.725  -1.033  1.00 18.49           N  
ATOM    117  CA  LEU A 682       7.559  14.988  -0.296  1.00 17.99           C  
ATOM    118  C   LEU A 682       6.937  13.756   0.367  1.00 18.57           C  
ATOM    119  O   LEU A 682       7.605  12.746   0.589  1.00 17.97           O  
ATOM    120  CB  LEU A 682       8.187  15.880   0.777  1.00 19.35           C  
ATOM    121  CG  LEU A 682       9.045  17.050   0.282  1.00 21.75           C  
ATOM    122  CD1 LEU A 682       9.435  17.914   1.447  1.00 23.67           C  
ATOM    123  CD2 LEU A 682      10.279  16.535  -0.420  1.00 23.17           C  
ATOM    124  N   GLY A 683       5.645  13.852   0.672  1.00 16.86           N  
ATOM    125  CA  GLY A 683       4.952  12.756   1.319  1.00 16.66           C  
ATOM    126  C   GLY A 683       5.213  12.797   2.814  1.00 16.54           C  
ATOM    127  O   GLY A 683       5.317  11.761   3.467  1.00 16.09           O  
ATOM    128  N   ILE A 684       5.313  14.009   3.350  1.00 17.10           N  
ATOM    129  CA  ILE A 684       5.583  14.216   4.775  1.00 18.03           C  
ATOM    130  C   ILE A 684       4.525  15.109   5.411  1.00 18.94           C  
ATOM    131  O   ILE A 684       4.175  16.145   4.853  1.00 18.95           O  
ATOM    132  CB  ILE A 684       6.951  14.913   4.991  1.00 21.19           C  
ATOM    133  CG1 ILE A 684       8.069  14.071   4.385  1.00 21.34           C  
ATOM    134  CG2 ILE A 684       7.197  15.148   6.474  1.00 21.96           C  
ATOM    135  CD1 ILE A 684       9.423  14.748   4.418  1.00 22.98           C  
ATOM    136  N   THR A 685       4.013  14.713   6.571  1.00 17.64           N  
ATOM    137  CA  THR A 685       3.041  15.541   7.262  1.00 18.93           C  
ATOM    138  C   THR A 685       3.723  16.018   8.541  1.00 18.21           C  
ATOM    139  O   THR A 685       4.250  15.199   9.291  1.00 19.48           O  
ATOM    140  CB  THR A 685       1.771  14.755   7.612  1.00 18.04           C  
ATOM    141  OG1 THR A 685       1.144  14.297   6.408  1.00 20.25           O  
ATOM    142  CG2 THR A 685       0.798  15.643   8.371  1.00 18.31           C  
ATOM    143  N   ILE A 686       3.741  17.332   8.769  1.00 17.69           N  
ATOM    144  CA  ILE A 686       4.378  17.889   9.957  1.00 17.56           C  
ATOM    145  C   ILE A 686       3.385  18.500  10.942  1.00 19.13           C  
ATOM    146  O   ILE A 686       2.296  18.935  10.563  1.00 19.22           O  
ATOM    147  CB  ILE A 686       5.427  18.980   9.599  1.00 17.48           C  
ATOM    148  CG1 ILE A 686       4.752  20.147   8.869  1.00 17.25           C  
ATOM    149  CG2 ILE A 686       6.548  18.373   8.756  1.00 17.49           C  
ATOM    150  CD1 ILE A 686       5.664  21.339   8.629  1.00 17.77           C  
ATOM    151  N   SER A 687       3.780  18.526  12.212  1.00 19.71           N  
ATOM    152  CA  SER A 687       2.950  19.083  13.272  1.00 19.44           C  
ATOM    153  C   SER A 687       3.704  20.137  14.060  1.00 19.64           C  
ATOM    154  O   SER A 687       4.936  20.137  14.095  1.00 18.03           O  
ATOM    155  CB  SER A 687       2.501  17.984  14.218  1.00 22.44           C  
ATOM    156  OG  SER A 687       1.560  17.156  13.575  1.00 28.12           O  
ATOM    157  N   GLY A 688       2.950  21.023  14.703  1.00 17.01           N  
ATOM    158  CA  GLY A 688       3.546  22.082  15.491  1.00 18.69           C  
ATOM    159  C   GLY A 688       2.487  23.108  15.853  1.00 18.37           C  
ATOM    160  O   GLY A 688       1.292  22.844  15.727  1.00 18.11           O  
ATOM    161  N   THR A 689       2.924  24.279  16.303  1.00 19.70           N  
ATOM    162  CA  THR A 689       2.017  25.360  16.683  1.00 21.81           C  
ATOM    163  C   THR A 689       2.637  26.681  16.243  1.00 23.30           C  
ATOM    164  O   THR A 689       3.677  26.691  15.566  1.00 22.28           O  
ATOM    165  CB  THR A 689       1.818  25.426  18.220  1.00 20.39           C  
ATOM    166  OG1 THR A 689       3.028  25.879  18.844  1.00 22.51           O  
ATOM    167  CG2 THR A 689       1.453  24.060  18.770  1.00 23.45           C  
ATOM    168  N   GLU A 690       2.015  27.792  16.640  1.00 24.31           N  
ATOM    169  CA  GLU A 690       2.542  29.104  16.294  1.00 26.01           C  
ATOM    170  C   GLU A 690       3.450  29.672  17.371  1.00 27.00           C  
ATOM    171  O   GLU A 690       3.910  30.810  17.265  1.00 27.82           O  
ATOM    172  CB  GLU A 690       1.412  30.084  15.986  1.00 27.23           C  
ATOM    173  CG  GLU A 690       0.716  29.798  14.656  1.00 28.41           C  
ATOM    174  CD  GLU A 690       1.659  29.893  13.458  1.00 28.18           C  
ATOM    175  OE1 GLU A 690       2.126  31.008  13.139  1.00 27.37           O  
ATOM    176  OE2 GLU A 690       1.940  28.847  12.837  1.00 28.48           O  
ATOM    177  N   GLU A 691       3.704  28.885  18.415  1.00 28.15           N  
ATOM    178  CA  GLU A 691       4.609  29.327  19.469  1.00 30.04           C  
ATOM    179  C   GLU A 691       6.009  29.254  18.859  1.00 30.13           C  
ATOM    180  O   GLU A 691       6.488  28.175  18.504  1.00 29.76           O  
ATOM    181  CB  GLU A 691       4.523  28.418  20.702  1.00 31.30           C  
ATOM    182  CG  GLU A 691       5.481  28.833  21.820  1.00 34.35           C  
ATOM    183  CD  GLU A 691       5.106  30.160  22.484  1.00 35.37           C  
ATOM    184  OE1 GLU A 691       5.983  30.755  23.147  1.00 36.92           O  
ATOM    185  OE2 GLU A 691       3.941  30.599  22.362  1.00 34.72           O  
ATOM    186  N   PRO A 692       6.682  30.408  18.733  1.00 30.66           N  
ATOM    187  CA  PRO A 692       8.025  30.517  18.162  1.00 30.67           C  
ATOM    188  C   PRO A 692       8.990  29.378  18.457  1.00 30.35           C  
ATOM    189  O   PRO A 692       9.687  28.913  17.550  1.00 30.47           O  
ATOM    190  CB  PRO A 692       8.527  31.847  18.716  1.00 31.38           C  
ATOM    191  CG  PRO A 692       7.293  32.664  18.716  1.00 31.58           C  
ATOM    192  CD  PRO A 692       6.267  31.704  19.303  1.00 30.76           C  
ATOM    193  N   PHE A 693       9.035  28.914  19.703  1.00 29.13           N  
ATOM    194  CA  PHE A 693       9.980  27.861  20.027  1.00 28.47           C  
ATOM    195  C   PHE A 693       9.520  26.419  20.159  1.00 26.10           C  
ATOM    196  O   PHE A 693      10.266  25.576  20.666  1.00 27.04           O  
ATOM    197  CB  PHE A 693      10.805  28.274  21.240  1.00 31.60           C  
ATOM    198  CG  PHE A 693      11.784  29.367  20.937  1.00 34.54           C  
ATOM    199  CD1 PHE A 693      11.368  30.695  20.880  1.00 36.51           C  
ATOM    200  CD2 PHE A 693      13.107  29.063  20.616  1.00 35.97           C  
ATOM    201  CE1 PHE A 693      12.256  31.707  20.515  1.00 37.69           C  
ATOM    202  CE2 PHE A 693      14.001  30.067  20.249  1.00 37.51           C  
ATOM    203  CZ  PHE A 693      13.570  31.391  20.195  1.00 37.30           C  
ATOM    204  N   ASP A 694       8.317  26.117  19.686  1.00 23.76           N  
ATOM    205  CA  ASP A 694       7.849  24.739  19.723  1.00 23.14           C  
ATOM    206  C   ASP A 694       8.541  24.000  18.581  1.00 22.68           C  
ATOM    207  O   ASP A 694       8.870  24.600  17.554  1.00 23.86           O  
ATOM    208  CB  ASP A 694       6.345  24.661  19.519  1.00 21.62           C  
ATOM    209  CG  ASP A 694       5.575  24.954  20.780  1.00 19.06           C  
ATOM    210  OD1 ASP A 694       4.356  24.699  20.784  1.00 20.43           O  
ATOM    211  OD2 ASP A 694       6.188  25.438  21.757  1.00 21.27           O  
ATOM    212  N   PRO A 695       8.771  22.686  18.738  1.00 21.69           N  
ATOM    213  CA  PRO A 695       9.437  21.956  17.657  1.00 19.93           C  
ATOM    214  C   PRO A 695       8.493  21.640  16.503  1.00 19.02           C  
ATOM    215  O   PRO A 695       7.278  21.549  16.690  1.00 19.47           O  
ATOM    216  CB  PRO A 695       9.920  20.691  18.354  1.00 21.43           C  
ATOM    217  CG  PRO A 695       8.814  20.414  19.326  1.00 21.02           C  
ATOM    218  CD  PRO A 695       8.489  21.798  19.884  1.00 21.87           C  
ATOM    219  N   ILE A 696       9.062  21.497  15.308  1.00 18.31           N  
ATOM    220  CA  ILE A 696       8.289  21.128  14.121  1.00 19.13           C  
ATOM    221  C   ILE A 696       8.569  19.638  13.993  1.00 16.37           C  
ATOM    222  O   ILE A 696       9.704  19.243  13.751  1.00 15.72           O  
ATOM    223  CB  ILE A 696       8.801  21.851  12.872  1.00 20.14           C  
ATOM    224  CG1 ILE A 696       8.823  23.363  13.126  1.00 24.07           C  
ATOM    225  CG2 ILE A 696       7.914  21.501  11.676  1.00 20.07           C  
ATOM    226  CD1 ILE A 696       7.480  23.947  13.427  1.00 25.27           C  
ATOM    227  N   ILE A 697       7.535  18.825  14.165  1.00 16.24           N  
ATOM    228  CA  ILE A 697       7.666  17.370  14.151  1.00 16.96           C  
ATOM    229  C   ILE A 697       7.068  16.656  12.944  1.00 17.43           C  
ATOM    230  O   ILE A 697       6.019  17.038  12.441  1.00 17.01           O  
ATOM    231  CB  ILE A 697       6.990  16.762  15.422  1.00 18.81           C  
ATOM    232  CG1 ILE A 697       7.552  17.423  16.681  1.00 23.11           C  
ATOM    233  CG2 ILE A 697       7.186  15.258  15.464  1.00 22.80           C  
ATOM    234  CD1 ILE A 697       9.042  17.269  16.836  1.00 22.16           C  
ATOM    235  N   ILE A 698       7.750  15.616  12.483  1.00 16.05           N  
ATOM    236  CA  ILE A 698       7.246  14.810  11.382  1.00 17.03           C  
ATOM    237  C   ILE A 698       6.204  13.927  12.080  1.00 18.93           C  
ATOM    238  O   ILE A 698       6.555  13.037  12.862  1.00 17.94           O  
ATOM    239  CB  ILE A 698       8.378  13.940  10.777  1.00 17.75           C  
ATOM    240  CG1 ILE A 698       9.502  14.853  10.275  1.00 20.44           C  
ATOM    241  CG2 ILE A 698       7.838  13.072   9.649  1.00 19.67           C  
ATOM    242  CD1 ILE A 698      10.777  14.129   9.891  1.00 21.47           C  
ATOM    243  N   SER A 699       4.924  14.185  11.825  1.00 16.90           N  
ATOM    244  CA  SER A 699       3.871  13.417  12.480  1.00 19.86           C  
ATOM    245  C   SER A 699       3.439  12.169  11.735  1.00 17.79           C  
ATOM    246  O   SER A 699       3.037  11.188  12.357  1.00 20.75           O  
ATOM    247  CB  SER A 699       2.658  14.309  12.762  1.00 20.95           C  
ATOM    248  OG  SER A 699       2.134  14.854  11.575  1.00 23.28           O  
ATOM    249  N   SER A 700       3.494  12.198  10.408  1.00 18.42           N  
ATOM    250  CA  SER A 700       3.134  11.020   9.616  1.00 16.52           C  
ATOM    251  C   SER A 700       3.708  11.121   8.216  1.00 15.93           C  
ATOM    252  O   SER A 700       4.157  12.179   7.799  1.00 15.50           O  
ATOM    253  CB  SER A 700       1.613  10.828   9.542  1.00 18.14           C  
ATOM    254  OG  SER A 700       0.995  11.881   8.831  1.00 19.97           O  
ATOM    255  N   LEU A 701       3.705   9.999   7.510  1.00 15.89           N  
ATOM    256  CA  LEU A 701       4.222   9.930   6.156  1.00 17.51           C  
ATOM    257  C   LEU A 701       3.154   9.331   5.263  1.00 17.42           C  
ATOM    258  O   LEU A 701       2.403   8.453   5.679  1.00 18.12           O  
ATOM    259  CB  LEU A 701       5.469   9.039   6.097  1.00 18.00           C  
ATOM    260  CG  LEU A 701       6.670   9.399   6.970  1.00 19.21           C  
ATOM    261  CD1 LEU A 701       7.721   8.317   6.825  1.00 21.92           C  
ATOM    262  CD2 LEU A 701       7.230  10.750   6.564  1.00 21.16           C  
ATOM    263  N   THR A 702       3.095   9.811   4.030  1.00 16.70           N  
ATOM    264  CA  THR A 702       2.132   9.299   3.071  1.00 17.40           C  
ATOM    265  C   THR A 702       2.573   7.915   2.620  1.00 17.76           C  
ATOM    266  O   THR A 702       3.709   7.720   2.181  1.00 17.39           O  
ATOM    267  CB  THR A 702       2.043  10.202   1.834  1.00 17.10           C  
ATOM    268  OG1 THR A 702       1.558  11.491   2.226  1.00 19.73           O  
ATOM    269  CG2 THR A 702       1.125   9.589   0.794  1.00 17.26           C  
ATOM    270  N   LYS A 703       1.678   6.946   2.738  1.00 18.39           N  
ATOM    271  CA  LYS A 703       2.003   5.601   2.317  1.00 21.72           C  
ATOM    272  C   LYS A 703       2.290   5.607   0.815  1.00 22.08           C  
ATOM    273  O   LYS A 703       1.444   5.996   0.009  1.00 22.49           O  
ATOM    274  CB  LYS A 703       0.843   4.664   2.612  1.00 22.56           C  
ATOM    275  CG  LYS A 703       1.097   3.250   2.161  1.00 27.46           C  
ATOM    276  CD  LYS A 703      -0.073   2.371   2.506  1.00 30.00           C  
ATOM    277  CE  LYS A 703       0.176   0.943   2.080  1.00 32.24           C  
ATOM    278  NZ  LYS A 703      -1.010   0.116   2.438  1.00 34.63           N  
ATOM    279  N   GLY A 704       3.490   5.175   0.445  1.00 23.16           N  
ATOM    280  CA  GLY A 704       3.863   5.138  -0.957  1.00 22.91           C  
ATOM    281  C   GLY A 704       4.448   6.454  -1.423  1.00 22.21           C  
ATOM    282  O   GLY A 704       4.797   6.608  -2.595  1.00 23.49           O  
ATOM    283  N   GLY A 705       4.550   7.412  -0.504  1.00 19.86           N  
ATOM    284  CA  GLY A 705       5.103   8.709  -0.851  1.00 19.11           C  
ATOM    285  C   GLY A 705       6.612   8.672  -0.991  1.00 16.53           C  
ATOM    286  O   GLY A 705       7.246   7.667  -0.674  1.00 18.02           O  
ATOM    287  N   LEU A 706       7.198   9.768  -1.457  1.00 17.27           N  
ATOM    288  CA  LEU A 706       8.647   9.823  -1.633  1.00 17.09           C  
ATOM    289  C   LEU A 706       9.398   9.613  -0.319  1.00 16.91           C  
ATOM    290  O   LEU A 706      10.296   8.773  -0.243  1.00 15.15           O  
ATOM    291  CB  LEU A 706       9.060  11.164  -2.245  1.00 18.04           C  
ATOM    292  CG  LEU A 706      10.568  11.424  -2.372  1.00 18.50           C  
ATOM    293  CD1 LEU A 706      11.230  10.337  -3.233  1.00 19.87           C  
ATOM    294  CD2 LEU A 706      10.788  12.804  -2.967  1.00 17.86           C  
ATOM    295  N   ALA A 707       9.025  10.374   0.710  1.00 14.91           N  
ATOM    296  CA  ALA A 707       9.673  10.275   2.019  1.00 15.96           C  
ATOM    297  C   ALA A 707       9.708   8.837   2.502  1.00 15.97           C  
ATOM    298  O   ALA A 707      10.763   8.330   2.887  1.00 15.21           O  
ATOM    299  CB  ALA A 707       8.951  11.152   3.045  1.00 15.10           C  
ATOM    300  N   GLU A 708       8.559   8.170   2.485  1.00 16.53           N  
ATOM    301  CA  GLU A 708       8.515   6.783   2.929  1.00 16.10           C  
ATOM    302  C   GLU A 708       9.377   5.840   2.077  1.00 16.77           C  
ATOM    303  O   GLU A 708      10.061   4.966   2.615  1.00 18.66           O  
ATOM    304  CB  GLU A 708       7.076   6.268   2.956  1.00 19.32           C  
ATOM    305  CG  GLU A 708       7.000   4.799   3.324  1.00 21.67           C  
ATOM    306  CD  GLU A 708       5.589   4.305   3.450  1.00 24.80           C  
ATOM    307  OE1 GLU A 708       4.963   4.568   4.499  1.00 26.94           O  
ATOM    308  OE2 GLU A 708       5.103   3.661   2.494  1.00 26.54           O  
ATOM    309  N   ARG A 709       9.342   6.015   0.758  1.00 16.56           N  
ATOM    310  CA  ARG A 709      10.118   5.171  -0.146  1.00 17.98           C  
ATOM    311  C   ARG A 709      11.625   5.273   0.060  1.00 17.65           C  
ATOM    312  O   ARG A 709      12.348   4.326  -0.221  1.00 17.70           O  
ATOM    313  CB  ARG A 709       9.788   5.497  -1.601  1.00 20.38           C  
ATOM    314  CG  ARG A 709       8.440   4.998  -2.033  1.00 25.53           C  
ATOM    315  CD  ARG A 709       8.146   5.394  -3.463  1.00 30.59           C  
ATOM    316  NE  ARG A 709       6.774   5.051  -3.833  1.00 36.23           N  
ATOM    317  CZ  ARG A 709       6.297   3.808  -3.876  1.00 38.36           C  
ATOM    318  NH1 ARG A 709       7.085   2.781  -3.572  1.00 41.05           N  
ATOM    319  NH2 ARG A 709       5.030   3.588  -4.222  1.00 40.71           N  
ATOM    320  N   THR A 710      12.104   6.417   0.537  1.00 16.69           N  
ATOM    321  CA  THR A 710      13.538   6.579   0.775  1.00 16.80           C  
ATOM    322  C   THR A 710      13.940   5.860   2.065  1.00 17.83           C  
ATOM    323  O   THR A 710      15.065   5.361   2.190  1.00 17.62           O  
ATOM    324  CB  THR A 710      13.939   8.062   0.956  1.00 17.87           C  
ATOM    325  OG1 THR A 710      13.342   8.574   2.159  1.00 17.80           O  
ATOM    326  CG2 THR A 710      13.508   8.898  -0.251  1.00 19.09           C  
ATOM    327  N   GLY A 711      13.009   5.830   3.019  1.00 18.27           N  
ATOM    328  CA  GLY A 711      13.267   5.214   4.309  1.00 19.31           C  
ATOM    329  C   GLY A 711      14.213   6.068   5.146  1.00 19.39           C  
ATOM    330  O   GLY A 711      14.731   5.615   6.162  1.00 21.35           O  
ATOM    331  N   ALA A 712      14.423   7.312   4.734  1.00 19.61           N  
ATOM    332  CA  ALA A 712      15.344   8.211   5.429  1.00 21.59           C  
ATOM    333  C   ALA A 712      14.661   9.278   6.272  1.00 20.28           C  
ATOM    334  O   ALA A 712      15.333  10.141   6.843  1.00 21.67           O  
ATOM    335  CB  ALA A 712      16.258   8.892   4.408  1.00 21.63           C  
ATOM    336  N   ILE A 713      13.332   9.228   6.320  1.00 18.96           N  
ATOM    337  CA  ILE A 713      12.530  10.193   7.070  1.00 18.55           C  
ATOM    338  C   ILE A 713      11.662   9.395   8.024  1.00 16.96           C  
ATOM    339  O   ILE A 713      10.977   8.454   7.608  1.00 18.74           O  
ATOM    340  CB  ILE A 713      11.601  11.004   6.134  1.00 19.07           C  
ATOM    341  CG1 ILE A 713      12.407  11.570   4.964  1.00 20.06           C  
ATOM    342  CG2 ILE A 713      10.929  12.134   6.901  1.00 19.92           C  
ATOM    343  CD1 ILE A 713      13.550  12.477   5.372  1.00 22.44           C  
ATOM    344  N   HIS A 714      11.669   9.774   9.296  1.00 16.93           N  
ATOM    345  CA  HIS A 714      10.888   9.038  10.285  1.00 17.90           C  
ATOM    346  C   HIS A 714       9.974   9.863  11.171  1.00 16.98           C  
ATOM    347  O   HIS A 714      10.292  10.992  11.560  1.00 17.24           O  
ATOM    348  CB  HIS A 714      11.821   8.203  11.167  1.00 20.24           C  
ATOM    349  CG  HIS A 714      12.688   7.272  10.394  1.00 22.27           C  
ATOM    350  ND1 HIS A 714      13.828   7.688   9.737  1.00 24.38           N  
ATOM    351  CD2 HIS A 714      12.547   5.956  10.096  1.00 23.83           C  
ATOM    352  CE1 HIS A 714      14.344   6.675   9.071  1.00 23.21           C  
ATOM    353  NE2 HIS A 714      13.582   5.610   9.274  1.00 24.94           N  
ATOM    354  N   ILE A 715       8.833   9.270  11.484  1.00 16.38           N  
ATOM    355  CA  ILE A 715       7.857   9.903  12.338  1.00 17.99           C  
ATOM    356  C   ILE A 715       8.473  10.155  13.711  1.00 17.98           C  
ATOM    357  O   ILE A 715       9.178   9.306  14.263  1.00 18.88           O  
ATOM    358  CB  ILE A 715       6.618   9.018  12.479  1.00 18.80           C  
ATOM    359  CG1 ILE A 715       5.913   8.916  11.126  1.00 21.36           C  
ATOM    360  CG2 ILE A 715       5.692   9.577  13.542  1.00 22.37           C  
ATOM    361  CD1 ILE A 715       4.632   8.103  11.171  1.00 25.52           C  
ATOM    362  N   GLY A 716       8.227  11.343  14.243  1.00 18.35           N  
ATOM    363  CA  GLY A 716       8.746  11.669  15.554  1.00 18.74           C  
ATOM    364  C   GLY A 716       9.977  12.537  15.535  1.00 19.12           C  
ATOM    365  O   GLY A 716      10.253  13.227  16.507  1.00 20.69           O  
ATOM    366  N   ASP A 717      10.733  12.511  14.447  1.00 16.68           N  
ATOM    367  CA  ASP A 717      11.921  13.344  14.398  1.00 17.62           C  
ATOM    368  C   ASP A 717      11.506  14.792  14.156  1.00 16.40           C  
ATOM    369  O   ASP A 717      10.405  15.056  13.668  1.00 17.43           O  
ATOM    370  CB  ASP A 717      12.879  12.864  13.304  1.00 17.56           C  
ATOM    371  CG  ASP A 717      13.396  11.457  13.557  1.00 19.23           C  
ATOM    372  OD1 ASP A 717      13.481  11.041  14.734  1.00 19.44           O  
ATOM    373  OD2 ASP A 717      13.730  10.767  12.573  1.00 19.26           O  
ATOM    374  N   ARG A 718      12.376  15.731  14.514  1.00 15.72           N  
ATOM    375  CA  ARG A 718      12.056  17.143  14.331  1.00 15.86           C  
ATOM    376  C   ARG A 718      12.891  17.776  13.236  1.00 15.90           C  
ATOM    377  O   ARG A 718      14.059  17.417  13.031  1.00 14.89           O  
ATOM    378  CB  ARG A 718      12.254  17.922  15.632  1.00 19.83           C  
ATOM    379  CG  ARG A 718      13.689  18.132  16.036  1.00 24.52           C  
ATOM    380  CD  ARG A 718      13.732  18.928  17.337  1.00 27.75           C  
ATOM    381  NE  ARG A 718      13.038  18.218  18.415  1.00 28.81           N  
ATOM    382  CZ  ARG A 718      12.594  18.788  19.537  1.00 28.29           C  
ATOM    383  NH1 ARG A 718      12.759  20.093  19.753  1.00 25.38           N  
ATOM    384  NH2 ARG A 718      11.976  18.048  20.446  1.00 27.26           N  
ATOM    385  N   ILE A 719      12.282  18.720  12.528  1.00 14.87           N  
ATOM    386  CA  ILE A 719      12.952  19.419  11.443  1.00 17.15           C  
ATOM    387  C   ILE A 719      13.568  20.689  12.001  1.00 17.30           C  
ATOM    388  O   ILE A 719      12.858  21.550  12.529  1.00 19.13           O  
ATOM    389  CB  ILE A 719      11.950  19.756  10.317  1.00 16.47           C  
ATOM    390  CG1 ILE A 719      11.355  18.453   9.770  1.00 18.56           C  
ATOM    391  CG2 ILE A 719      12.637  20.554   9.210  1.00 18.40           C  
ATOM    392  CD1 ILE A 719      10.240  18.653   8.757  1.00 20.18           C  
ATOM    393  N   LEU A 720      14.891  20.793  11.894  1.00 15.86           N  
ATOM    394  CA  LEU A 720      15.623  21.950  12.399  1.00 17.30           C  
ATOM    395  C   LEU A 720      15.818  23.054  11.352  1.00 18.75           C  
ATOM    396  O   LEU A 720      15.975  24.223  11.697  1.00 20.80           O  
ATOM    397  CB  LEU A 720      16.992  21.507  12.932  1.00 17.66           C  
ATOM    398  CG  LEU A 720      17.020  20.425  14.016  1.00 17.86           C  
ATOM    399  CD1 LEU A 720      18.462  20.140  14.417  1.00 18.93           C  
ATOM    400  CD2 LEU A 720      16.212  20.871  15.219  1.00 19.98           C  
ATOM    401  N   ALA A 721      15.813  22.681  10.076  1.00 19.25           N  
ATOM    402  CA  ALA A 721      15.993  23.653   9.002  1.00 18.79           C  
ATOM    403  C   ALA A 721      15.453  23.107   7.697  1.00 18.41           C  
ATOM    404  O   ALA A 721      15.430  21.896   7.487  1.00 18.02           O  
ATOM    405  CB  ALA A 721      17.471  23.993   8.844  1.00 19.70           C  
ATOM    406  N   ILE A 722      15.014  24.006   6.825  1.00 18.16           N  
ATOM    407  CA  ILE A 722      14.490  23.619   5.523  1.00 19.15           C  
ATOM    408  C   ILE A 722      15.226  24.436   4.475  1.00 20.03           C  
ATOM    409  O   ILE A 722      15.194  25.668   4.508  1.00 19.41           O  
ATOM    410  CB  ILE A 722      12.976  23.889   5.421  1.00 20.13           C  
ATOM    411  CG1 ILE A 722      12.229  23.020   6.437  1.00 20.97           C  
ATOM    412  CG2 ILE A 722      12.478  23.578   4.013  1.00 21.03           C  
ATOM    413  CD1 ILE A 722      10.729  23.270   6.483  1.00 21.14           C  
ATOM    414  N   ASN A 723      15.900  23.752   3.555  1.00 19.41           N  
ATOM    415  CA  ASN A 723      16.658  24.432   2.510  1.00 21.50           C  
ATOM    416  C   ASN A 723      17.600  25.456   3.131  1.00 21.25           C  
ATOM    417  O   ASN A 723      17.702  26.595   2.678  1.00 22.59           O  
ATOM    418  CB  ASN A 723      15.703  25.103   1.518  1.00 22.17           C  
ATOM    419  CG  ASN A 723      15.010  24.096   0.605  1.00 24.07           C  
ATOM    420  OD1 ASN A 723      13.941  24.367   0.060  1.00 25.70           O  
ATOM    421  ND2 ASN A 723      15.622  22.934   0.433  1.00 20.85           N  
ATOM    422  N   SER A 724      18.284  25.024   4.184  1.00 22.71           N  
ATOM    423  CA  SER A 724      19.244  25.845   4.905  1.00 24.53           C  
ATOM    424  C   SER A 724      18.655  27.017   5.688  1.00 24.65           C  
ATOM    425  O   SER A 724      19.395  27.819   6.254  1.00 25.44           O  
ATOM    426  CB  SER A 724      20.330  26.350   3.951  1.00 26.56           C  
ATOM    427  OG  SER A 724      21.198  25.292   3.566  1.00 31.96           O  
ATOM    428  N   SER A 725      17.329  27.111   5.720  1.00 22.77           N  
ATOM    429  CA  SER A 725      16.660  28.171   6.466  1.00 23.82           C  
ATOM    430  C   SER A 725      16.271  27.582   7.826  1.00 22.27           C  
ATOM    431  O   SER A 725      15.401  26.715   7.914  1.00 21.25           O  
ATOM    432  CB  SER A 725      15.415  28.643   5.715  1.00 24.11           C  
ATOM    433  OG  SER A 725      14.846  29.772   6.348  1.00 29.68           O  
ATOM    434  N   SER A 726      16.931  28.049   8.882  1.00 23.10           N  
ATOM    435  CA  SER A 726      16.685  27.552  10.233  1.00 23.46           C  
ATOM    436  C   SER A 726      15.268  27.781  10.748  1.00 23.30           C  
ATOM    437  O   SER A 726      14.651  28.806  10.463  1.00 23.70           O  
ATOM    438  CB  SER A 726      17.682  28.186  11.205  1.00 25.09           C  
ATOM    439  OG  SER A 726      17.445  27.743  12.530  1.00 25.68           O  
ATOM    440  N   LEU A 727      14.759  26.820  11.510  1.00 21.69           N  
ATOM    441  CA  LEU A 727      13.421  26.925  12.081  1.00 21.42           C  
ATOM    442  C   LEU A 727      13.481  27.310  13.561  1.00 20.68           C  
ATOM    443  O   LEU A 727      12.466  27.327  14.257  1.00 20.42           O  
ATOM    444  CB  LEU A 727      12.669  25.604  11.924  1.00 21.63           C  
ATOM    445  CG  LEU A 727      12.309  25.197  10.493  1.00 21.60           C  
ATOM    446  CD1 LEU A 727      11.484  23.920  10.519  1.00 21.23           C  
ATOM    447  CD2 LEU A 727      11.525  26.329   9.826  1.00 22.91           C  
ATOM    448  N   LYS A 728      14.677  27.630  14.033  1.00 22.00           N  
ATOM    449  CA  LYS A 728      14.843  28.017  15.422  1.00 23.60           C  
ATOM    450  C   LYS A 728      13.999  29.255  15.706  1.00 24.47           C  
ATOM    451  O   LYS A 728      14.182  30.294  15.072  1.00 24.26           O  
ATOM    452  CB  LYS A 728      16.307  28.322  15.714  1.00 25.38           C  
ATOM    453  CG  LYS A 728      16.593  28.622  17.171  1.00 29.96           C  
ATOM    454  CD  LYS A 728      18.064  28.924  17.373  1.00 33.71           C  
ATOM    455  CE  LYS A 728      18.377  29.283  18.822  1.00 36.02           C  
ATOM    456  NZ  LYS A 728      19.796  29.739  18.978  1.00 37.23           N  
ATOM    457  N   GLY A 729      13.072  29.135  16.651  1.00 24.57           N  
ATOM    458  CA  GLY A 729      12.227  30.261  17.000  1.00 25.46           C  
ATOM    459  C   GLY A 729      11.205  30.606  15.936  1.00 25.13           C  
ATOM    460  O   GLY A 729      10.600  31.678  15.976  1.00 26.73           O  
ATOM    461  N   LYS A 730      11.007  29.705  14.977  1.00 24.16           N  
ATOM    462  CA  LYS A 730      10.035  29.942  13.914  1.00 22.73           C  
ATOM    463  C   LYS A 730       8.783  29.099  14.136  1.00 21.76           C  
ATOM    464  O   LYS A 730       8.866  27.938  14.522  1.00 23.84           O  
ATOM    465  CB  LYS A 730      10.639  29.605  12.544  1.00 22.06           C  
ATOM    466  CG  LYS A 730      11.886  30.391  12.190  1.00 24.16           C  
ATOM    467  CD  LYS A 730      11.591  31.874  12.053  1.00 24.16           C  
ATOM    468  CE  LYS A 730      12.869  32.655  11.815  1.00 27.91           C  
ATOM    469  NZ  LYS A 730      12.580  34.096  11.565  1.00 30.29           N  
ATOM    470  N   PRO A 731       7.597  29.678  13.903  1.00 22.10           N  
ATOM    471  CA  PRO A 731       6.339  28.937  14.088  1.00 21.29           C  
ATOM    472  C   PRO A 731       6.055  27.946  12.947  1.00 21.01           C  
ATOM    473  O   PRO A 731       6.721  27.975  11.918  1.00 19.11           O  
ATOM    474  CB  PRO A 731       5.301  30.053  14.164  1.00 22.91           C  
ATOM    475  CG  PRO A 731       5.886  31.105  13.245  1.00 21.30           C  
ATOM    476  CD  PRO A 731       7.347  31.100  13.602  1.00 21.54           C  
ATOM    477  N   LEU A 732       5.068  27.076  13.124  1.00 20.54           N  
ATOM    478  CA  LEU A 732       4.732  26.102  12.089  1.00 20.24           C  
ATOM    479  C   LEU A 732       4.409  26.769  10.755  1.00 20.18           C  
ATOM    480  O   LEU A 732       4.752  26.249   9.696  1.00 20.12           O  
ATOM    481  CB  LEU A 732       3.536  25.251  12.521  1.00 21.64           C  
ATOM    482  CG  LEU A 732       3.081  24.181  11.524  1.00 22.46           C  
ATOM    483  CD1 LEU A 732       4.159  23.123  11.396  1.00 24.90           C  
ATOM    484  CD2 LEU A 732       1.789  23.552  11.977  1.00 23.49           C  
ATOM    485  N   SER A 733       3.743  27.916  10.806  1.00 19.93           N  
ATOM    486  CA  SER A 733       3.373  28.621   9.585  1.00 19.77           C  
ATOM    487  C   SER A 733       4.581  28.913   8.694  1.00 20.14           C  
ATOM    488  O   SER A 733       4.471  28.908   7.466  1.00 18.17           O  
ATOM    489  CB  SER A 733       2.636  29.924   9.929  1.00 18.54           C  
ATOM    490  OG  SER A 733       3.458  30.809  10.667  1.00 20.08           O  
ATOM    491  N   GLU A 734       5.734  29.161   9.305  1.00 20.09           N  
ATOM    492  CA  GLU A 734       6.946  29.433   8.542  1.00 20.40           C  
ATOM    493  C   GLU A 734       7.500  28.171   7.888  1.00 21.81           C  
ATOM    494  O   GLU A 734       8.007  28.224   6.765  1.00 20.48           O  
ATOM    495  CB  GLU A 734       8.015  30.050   9.437  1.00 22.64           C  
ATOM    496  CG  GLU A 734       7.691  31.459   9.880  1.00 25.90           C  
ATOM    497  CD  GLU A 734       7.684  32.443   8.731  1.00 27.86           C  
ATOM    498  OE1 GLU A 734       8.731  32.580   8.062  1.00 29.24           O  
ATOM    499  OE2 GLU A 734       6.637  33.079   8.500  1.00 27.80           O  
ATOM    500  N   ALA A 735       7.412  27.043   8.595  1.00 20.12           N  
ATOM    501  CA  ALA A 735       7.896  25.763   8.078  1.00 21.21           C  
ATOM    502  C   ALA A 735       7.045  25.370   6.868  1.00 20.28           C  
ATOM    503  O   ALA A 735       7.573  24.941   5.838  1.00 19.26           O  
ATOM    504  CB  ALA A 735       7.813  24.675   9.167  1.00 20.86           C  
ATOM    505  N   ILE A 736       5.727  25.520   6.996  1.00 19.92           N  
ATOM    506  CA  ILE A 736       4.810  25.201   5.906  1.00 19.41           C  
ATOM    507  C   ILE A 736       5.126  26.088   4.699  1.00 19.65           C  
ATOM    508  O   ILE A 736       5.120  25.625   3.561  1.00 20.23           O  
ATOM    509  CB  ILE A 736       3.346  25.417   6.341  1.00 19.86           C  
ATOM    510  CG1 ILE A 736       3.003  24.429   7.457  1.00 20.77           C  
ATOM    511  CG2 ILE A 736       2.395  25.244   5.151  1.00 20.59           C  
ATOM    512  CD1 ILE A 736       1.639  24.653   8.073  1.00 22.28           C  
ATOM    513  N   HIS A 737       5.416  27.360   4.957  1.00 19.48           N  
ATOM    514  CA  HIS A 737       5.751  28.300   3.896  1.00 19.00           C  
ATOM    515  C   HIS A 737       7.043  27.885   3.186  1.00 19.74           C  
ATOM    516  O   HIS A 737       7.099  27.856   1.958  1.00 20.49           O  
ATOM    517  CB  HIS A 737       5.912  29.698   4.480  1.00 19.16           C  
ATOM    518  CG  HIS A 737       6.291  30.732   3.471  1.00 19.13           C  
ATOM    519  ND1 HIS A 737       5.460  31.104   2.432  1.00 20.62           N  
ATOM    520  CD2 HIS A 737       7.412  31.481   3.332  1.00 19.60           C  
ATOM    521  CE1 HIS A 737       6.049  32.030   1.704  1.00 19.33           C  
ATOM    522  NE2 HIS A 737       7.239  32.280   2.231  1.00 22.30           N  
ATOM    523  N   LEU A 738       8.077  27.565   3.959  1.00 19.19           N  
ATOM    524  CA  LEU A 738       9.356  27.143   3.390  1.00 21.46           C  
ATOM    525  C   LEU A 738       9.195  25.911   2.508  1.00 23.06           C  
ATOM    526  O   LEU A 738       9.808  25.818   1.447  1.00 23.00           O  
ATOM    527  CB  LEU A 738      10.364  26.857   4.504  1.00 21.18           C  
ATOM    528  CG  LEU A 738      10.880  28.107   5.222  1.00 22.61           C  
ATOM    529  CD1 LEU A 738      11.631  27.735   6.489  1.00 22.19           C  
ATOM    530  CD2 LEU A 738      11.784  28.883   4.279  1.00 23.43           C  
ATOM    531  N   LEU A 739       8.357  24.973   2.937  1.00 24.21           N  
ATOM    532  CA  LEU A 739       8.132  23.754   2.174  1.00 27.04           C  
ATOM    533  C   LEU A 739       7.420  23.939   0.824  1.00 29.40           C  
ATOM    534  O   LEU A 739       7.797  23.310  -0.161  1.00 30.77           O  
ATOM    535  CB  LEU A 739       7.372  22.736   3.035  1.00 26.77           C  
ATOM    536  CG  LEU A 739       8.182  22.129   4.186  1.00 24.57           C  
ATOM    537  CD1 LEU A 739       7.268  21.387   5.145  1.00 22.36           C  
ATOM    538  CD2 LEU A 739       9.231  21.193   3.624  1.00 24.96           C  
ATOM    539  N   GLN A 740       6.403  24.792   0.766  1.00 31.34           N  
ATOM    540  CA  GLN A 740       5.678  25.001  -0.488  1.00 34.84           C  
ATOM    541  C   GLN A 740       6.387  25.984  -1.423  1.00 36.57           C  
ATOM    542  O   GLN A 740       5.930  26.240  -2.535  1.00 36.15           O  
ATOM    543  CB  GLN A 740       4.250  25.482  -0.197  1.00 35.47           C  
ATOM    544  CG  GLN A 740       4.165  26.794   0.562  1.00 37.61           C  
ATOM    545  CD  GLN A 740       4.322  28.006  -0.338  1.00 40.49           C  
ATOM    546  OE1 GLN A 740       3.494  28.250  -1.220  1.00 40.92           O  
ATOM    547  NE2 GLN A 740       5.388  28.775  -0.118  1.00 40.59           N  
ATOM    548  N   MET A 741       7.517  26.513  -0.972  1.00 39.24           N  
ATOM    549  CA  MET A 741       8.291  27.473  -1.753  1.00 42.15           C  
ATOM    550  C   MET A 741       9.678  26.907  -2.000  1.00 43.49           C  
ATOM    551  O   MET A 741      10.568  27.620  -2.447  1.00 44.44           O  
ATOM    552  CB  MET A 741       8.440  28.774  -0.962  1.00 43.64           C  
ATOM    553  CG  MET A 741       8.294  30.054  -1.765  1.00 46.39           C  
ATOM    554  SD  MET A 741       6.565  30.427  -2.144  1.00 47.27           S  
ATOM    555  CE  MET A 741       6.422  29.631  -3.767  1.00 49.09           C  
ATOM    556  N   ALA A 742       9.850  25.620  -1.714  1.00 44.36           N  
ATOM    557  CA  ALA A 742      11.147  24.950  -1.823  1.00 44.43           C  
ATOM    558  C   ALA A 742      11.838  24.790  -3.194  1.00 44.24           C  
ATOM    559  O   ALA A 742      13.016  25.150  -3.341  1.00 45.59           O  
ATOM    560  CB  ALA A 742      11.052  23.585  -1.137  1.00 44.66           C  
ATOM    561  N   GLY A 743      11.124  24.251  -4.184  1.00 42.61           N  
ATOM    562  CA  GLY A 743      11.718  24.020  -5.497  1.00 39.90           C  
ATOM    563  C   GLY A 743      11.805  22.518  -5.730  1.00 37.77           C  
ATOM    564  O   GLY A 743      11.348  21.744  -4.892  1.00 37.25           O  
ATOM    565  N   GLU A 744      12.397  22.095  -6.843  1.00 35.76           N  
ATOM    566  CA  GLU A 744      12.503  20.668  -7.159  1.00 34.09           C  
ATOM    567  C   GLU A 744      13.223  19.802  -6.132  1.00 31.25           C  
ATOM    568  O   GLU A 744      12.952  18.606  -6.024  1.00 30.10           O  
ATOM    569  CB  GLU A 744      13.163  20.463  -8.520  1.00 36.58           C  
ATOM    570  CG  GLU A 744      12.241  20.716  -9.699  1.00 40.10           C  
ATOM    571  CD  GLU A 744      12.789  20.131 -10.996  1.00 42.05           C  
ATOM    572  OE1 GLU A 744      12.112  20.266 -12.041  1.00 44.71           O  
ATOM    573  OE2 GLU A 744      13.894  19.536 -10.970  1.00 43.88           O  
ATOM    574  N   THR A 745      14.161  20.389  -5.400  1.00 28.94           N  
ATOM    575  CA  THR A 745      14.860  19.632  -4.373  1.00 27.83           C  
ATOM    576  C   THR A 745      14.633  20.317  -3.035  1.00 25.32           C  
ATOM    577  O   THR A 745      14.505  21.541  -2.962  1.00 26.83           O  
ATOM    578  CB  THR A 745      16.379  19.529  -4.642  1.00 29.97           C  
ATOM    579  OG1 THR A 745      16.958  20.837  -4.630  1.00 32.94           O  
ATOM    580  CG2 THR A 745      16.638  18.853  -5.981  1.00 30.58           C  
ATOM    581  N   VAL A 746      14.551  19.516  -1.982  1.00 21.49           N  
ATOM    582  CA  VAL A 746      14.332  20.035  -0.645  1.00 19.39           C  
ATOM    583  C   VAL A 746      15.332  19.389   0.297  1.00 17.57           C  
ATOM    584  O   VAL A 746      15.477  18.168   0.328  1.00 16.91           O  
ATOM    585  CB  VAL A 746      12.904  19.724  -0.147  1.00 17.45           C  
ATOM    586  CG1 VAL A 746      12.687  20.328   1.233  1.00 20.13           C  
ATOM    587  CG2 VAL A 746      11.886  20.263  -1.123  1.00 22.53           C  
ATOM    588  N   THR A 747      16.026  20.221   1.058  1.00 17.05           N  
ATOM    589  CA  THR A 747      17.011  19.751   2.008  1.00 17.40           C  
ATOM    590  C   THR A 747      16.431  19.944   3.402  1.00 17.95           C  
ATOM    591  O   THR A 747      15.989  21.043   3.751  1.00 20.35           O  
ATOM    592  CB  THR A 747      18.311  20.545   1.863  1.00 19.28           C  
ATOM    593  OG1 THR A 747      18.838  20.341   0.547  1.00 19.85           O  
ATOM    594  CG2 THR A 747      19.336  20.090   2.878  1.00 20.52           C  
ATOM    595  N   LEU A 748      16.419  18.875   4.190  1.00 14.91           N  
ATOM    596  CA  LEU A 748      15.880  18.937   5.543  1.00 14.69           C  
ATOM    597  C   LEU A 748      16.936  18.566   6.570  1.00 13.99           C  
ATOM    598  O   LEU A 748      17.553  17.511   6.471  1.00 15.21           O  
ATOM    599  CB  LEU A 748      14.705  17.968   5.689  1.00 13.62           C  
ATOM    600  CG  LEU A 748      13.492  18.110   4.769  1.00 14.86           C  
ATOM    601  CD1 LEU A 748      12.602  16.895   4.961  1.00 17.86           C  
ATOM    602  CD2 LEU A 748      12.734  19.403   5.058  1.00 14.31           C  
ATOM    603  N   LYS A 749      17.152  19.440   7.546  1.00 14.66           N  
ATOM    604  CA  LYS A 749      18.104  19.158   8.617  1.00 13.31           C  
ATOM    605  C   LYS A 749      17.206  18.559   9.696  1.00 14.46           C  
ATOM    606  O   LYS A 749      16.235  19.180  10.128  1.00 14.49           O  
ATOM    607  CB  LYS A 749      18.770  20.440   9.106  1.00 15.05           C  
ATOM    608  CG  LYS A 749      19.908  20.201  10.076  1.00 17.88           C  
ATOM    609  CD  LYS A 749      20.545  21.523  10.486  1.00 23.63           C  
ATOM    610  CE  LYS A 749      21.698  21.316  11.452  1.00 26.67           C  
ATOM    611  NZ  LYS A 749      22.236  22.617  11.926  1.00 29.50           N  
ATOM    612  N   ILE A 750      17.531  17.344  10.115  1.00 14.01           N  
ATOM    613  CA  ILE A 750      16.714  16.611  11.074  1.00 14.03           C  
ATOM    614  C   ILE A 750      17.435  16.148  12.336  1.00 13.90           C  
ATOM    615  O   ILE A 750      18.589  15.730  12.286  1.00 14.77           O  
ATOM    616  CB  ILE A 750      16.130  15.360  10.392  1.00 14.97           C  
ATOM    617  CG1 ILE A 750      15.348  15.774   9.144  1.00 17.60           C  
ATOM    618  CG2 ILE A 750      15.262  14.574  11.365  1.00 17.91           C  
ATOM    619  CD1 ILE A 750      14.856  14.600   8.325  1.00 21.63           C  
ATOM    620  N   LYS A 751      16.735  16.224  13.464  1.00 15.52           N  
ATOM    621  CA  LYS A 751      17.281  15.763  14.737  1.00 16.80           C  
ATOM    622  C   LYS A 751      16.458  14.543  15.169  1.00 15.98           C  
ATOM    623  O   LYS A 751      15.226  14.600  15.213  1.00 16.59           O  
ATOM    624  CB  LYS A 751      17.198  16.867  15.796  1.00 17.15           C  
ATOM    625  CG  LYS A 751      17.811  16.466  17.134  1.00 21.36           C  
ATOM    626  CD  LYS A 751      17.924  17.645  18.095  1.00 23.75           C  
ATOM    627  CE  LYS A 751      18.727  17.260  19.327  1.00 27.80           C  
ATOM    628  NZ  LYS A 751      19.055  18.439  20.187  1.00 28.31           N  
ATOM    629  N   LYS A 752      17.134  13.436  15.465  1.00 16.42           N  
ATOM    630  CA  LYS A 752      16.439  12.222  15.876  1.00 17.94           C  
ATOM    631  C   LYS A 752      15.753  12.413  17.220  1.00 19.44           C  
ATOM    632  O   LYS A 752      16.301  13.045  18.118  1.00 20.51           O  
ATOM    633  CB  LYS A 752      17.409  11.041  15.970  1.00 17.32           C  
ATOM    634  CG  LYS A 752      18.095  10.668  14.663  1.00 18.47           C  
ATOM    635  CD  LYS A 752      17.105  10.295  13.556  1.00 18.55           C  
ATOM    636  CE  LYS A 752      16.241   9.100  13.932  1.00 19.69           C  
ATOM    637  NZ  LYS A 752      15.433   8.598  12.776  1.00 17.72           N  
ATOM    638  N   GLN A 753      14.543  11.873  17.339  1.00 22.10           N  
ATOM    639  CA  GLN A 753      13.783  11.963  18.578  1.00 26.29           C  
ATOM    640  C   GLN A 753      14.529  11.157  19.627  1.00 28.74           C  
ATOM    641  O   GLN A 753      15.270  10.228  19.305  1.00 26.98           O  
ATOM    642  CB  GLN A 753      12.396  11.372  18.398  1.00 29.72           C  
ATOM    643  CG  GLN A 753      12.432   9.894  18.126  1.00 32.35           C  
ATOM    644  CD  GLN A 753      11.071   9.340  17.806  1.00 34.28           C  
ATOM    645  OE1 GLN A 753      10.149   9.396  18.631  1.00 34.25           O  
ATOM    646  NE2 GLN A 753      10.925   8.801  16.594  1.00 36.47           N  
ATOM    647  N   THR A 754      14.307  11.503  20.885  1.00 32.04           N  
ATOM    648  CA  THR A 754      14.981  10.841  21.983  1.00 37.14           C  
ATOM    649  C   THR A 754      14.041   9.981  22.808  1.00 39.53           C  
ATOM    650  O   THR A 754      12.868   9.813  22.473  1.00 39.88           O  
ATOM    651  CB  THR A 754      15.618  11.880  22.904  1.00 37.87           C  
ATOM    652  OG1 THR A 754      14.604  12.800  23.348  1.00 39.48           O  
ATOM    653  CG2 THR A 754      16.714  12.644  22.163  1.00 39.08           C  
ATOM    654  N   ASP A 755      14.583   9.453  23.902  1.00 43.15           N  
ATOM    655  CA  ASP A 755      13.858   8.599  24.846  1.00 46.03           C  
ATOM    656  C   ASP A 755      12.945   9.418  25.770  1.00 46.79           C  
ATOM    657  O   ASP A 755      13.237   9.585  26.958  1.00 47.42           O  
ATOM    658  CB  ASP A 755      14.874   7.832  25.692  1.00 47.31           C  
ATOM    659  CG  ASP A 755      16.024   8.722  26.162  1.00 49.36           C  
ATOM    660  OD1 ASP A 755      15.747   9.862  26.603  1.00 49.84           O  
ATOM    661  OD2 ASP A 755      17.199   8.285  26.094  1.00 50.55           O  
ATOM    662  N   ALA A 756      11.840   9.921  25.233  1.00 47.73           N  
ATOM    663  CA  ALA A 756      10.923  10.721  26.036  1.00 48.34           C  
ATOM    664  C   ALA A 756       9.739   9.890  26.520  1.00 48.37           C  
ATOM    665  O   ALA A 756       8.976   9.362  25.711  1.00 49.08           O  
ATOM    666  CB  ALA A 756      10.432  11.912  25.227  1.00 48.66           C  
ATOM    667  N   GLN A 757       9.591   9.785  27.841  1.00 47.82           N  
ATOM    668  CA  GLN A 757       8.502   9.015  28.457  1.00 46.61           C  
ATOM    669  C   GLN A 757       7.641   9.913  29.350  1.00 43.41           C  
ATOM    670  O   GLN A 757       8.167  10.728  30.106  1.00 43.38           O  
ATOM    671  CB  GLN A 757       9.079   7.866  29.289  1.00 49.58           C  
ATOM    672  CG  GLN A 757       8.072   6.805  29.692  0.00 53.81           C  
ATOM    673  CD  GLN A 757       8.698   5.741  30.569  0.00 56.08           C  
ATOM    674  OE1 GLN A 757       9.837   5.334  30.344  0.00 57.61           O  
ATOM    675  NE2 GLN A 757       7.955   5.280  31.567  0.00 57.61           N  
ATOM    676  N   PRO A 758       6.305   9.771  29.274  1.00 40.07           N  
ATOM    677  CA  PRO A 758       5.354  10.562  30.067  1.00 36.88           C  
ATOM    678  C   PRO A 758       5.509  10.355  31.574  1.00 33.93           C  
ATOM    679  O   PRO A 758       5.640   9.221  32.041  1.00 32.86           O  
ATOM    680  CB  PRO A 758       3.998  10.075  29.563  1.00 38.09           C  
ATOM    681  CG  PRO A 758       4.282   9.706  28.147  1.00 40.05           C  
ATOM    682  CD  PRO A 758       5.585   8.945  28.293  1.00 40.25           C  
ATOM    683  N   ALA A 759       5.487  11.449  32.330  1.00 29.67           N  
ATOM    684  CA  ALA A 759       5.632  11.378  33.779  1.00 26.64           C  
ATOM    685  C   ALA A 759       4.313  11.667  34.482  1.00 26.13           C  
ATOM    686  O   ALA A 759       3.669  12.683  34.217  1.00 24.52           O  
ATOM    687  CB  ALA A 759       6.692  12.359  34.245  1.00 26.03           C  
ATOM    688  N   SER A 760       3.918  10.769  35.382  1.00 26.04           N  
ATOM    689  CA  SER A 760       2.675  10.923  36.131  1.00 26.07           C  
ATOM    690  C   SER A 760       2.938  11.543  37.504  1.00 26.96           C  
ATOM    691  O   SER A 760       3.955  11.249  38.143  1.00 26.68           O  
ATOM    692  CB  SER A 760       1.990   9.566  36.294  1.00 27.77           C  
ATOM    693  OG  SER A 760       1.645   9.011  35.034  1.00 28.38           O  
ATOM    694  N   SER A 761       2.027  12.406  37.950  1.00 26.02           N  
ATOM    695  CA  SER A 761       2.171  13.057  39.247  1.00 27.02           C  
ATOM    696  C   SER A 761       0.818  13.246  39.934  1.00 26.81           C  
ATOM    697  O   SER A 761       0.809  13.793  41.060  1.00 27.69           O  
ATOM    698  CB  SER A 761       2.848  14.419  39.084  1.00 28.46           C  
ATOM    699  OG  SER A 761       1.971  15.335  38.455  1.00 31.07           O  
ATOM    700  OXT SER A 761      -0.213  12.843  39.349  1.00 24.75           O  
TER     701      SER A 761                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
