
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   94 (  698),  selected   94 , name 2fe5_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2fe5_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S   221_A      S       1          4.378
LGA    M   222_A      M       2          2.902
LGA    T   223_A      E       3          0.613
LGA    I   224_A      I       4          0.594
LGA    M   225_A      L       5          1.003
LGA    E   226_A      Q       6          0.483
LGA    V   227_A      V       7          0.672
LGA    N   228_A      A       8          0.749
LGA    L   229_A      L       9          0.621
LGA    L   230_A      H      10          0.503
LGA    K   231_A      K      11          1.702
LGA    G   232_A      R      12          2.425
LGA    P   233_A      D      13          5.635
LGA    K   234_A      S      14           -
LGA    -       -      G      15           -
LGA    -       -      E      16           -
LGA    G   235_A      Q      17          2.682
LGA    L   236_A      L      18          1.187
LGA    G   237_A      G      19          1.008
LGA    F   238_A      I      20          0.768
LGA    S   239_A      K      21          1.197
LGA    I   240_A      L      22          0.136
LGA    A   241_A      V      23          0.262
LGA    G   242_A      R      24          0.884
LGA    G   243_A      -       -           -
LGA    I   244_A      -       -           -
LGA    G   245_A      -       -           -
LGA    N   246_A      -       -           -
LGA    Q   247_A      -       -           -
LGA    H   248_A      R      25          1.165
LGA    I   249_A      T      26          4.062
LGA    P   250_A      D      27          1.071
LGA    G   251_A      E      28          3.474
LGA    D   252_A      -       -           -
LGA    N   253_A      P      29          1.567
LGA    S   254_A      G      30          0.967
LGA    I   255_A      V      31          0.546
LGA    Y   256_A      F      32          0.553
LGA    I   257_A      I      33          0.548
LGA    T   258_A      L      34          1.082
LGA    K   259_A      D      35          2.134
LGA    I   260_A      L      36          0.741
LGA    I   261_A      L      37          1.040
LGA    E   262_A      E      38          1.461
LGA    G   263_A      G      39          1.907
LGA    G   264_A      G      40          1.296
LGA    A   265_A      L      41          0.841
LGA    A   266_A      A      42          0.473
LGA    Q   267_A      A      43          0.883
LGA    K   268_A      Q      44          0.823
LGA    D   269_A      D      45          0.682
LGA    G   270_A      G      46          0.423
LGA    R   271_A      R      47          0.497
LGA    L   272_A      L      48          0.550
LGA    Q   273_A      S      49          0.870
LGA    I   274_A      S      50          1.278
LGA    G   275_A      N      51          1.232
LGA    D   276_A      D      52          0.760
LGA    R   277_A      R      53          0.679
LGA    L   278_A      V      54          0.627
LGA    L   279_A      L      55          0.722
LGA    A   280_A      A      56          0.529
LGA    V   281_A      I      57          0.126
LGA    N   282_A      N      58          0.703
LGA    N   283_A      G      59          1.087
LGA    T   284_A      H      60          0.420
LGA    N   285_A      D      61          0.808
LGA    L   286_A      L      62          0.331
LGA    Q   287_A      K      63          0.393
LGA    D   288_A      Y      64          0.452
LGA    V   289_A      G      65          1.688
LGA    R   290_A      T      66          2.928
LGA    H   291_A      P      67          2.742
LGA    E   292_A      E      68          1.534
LGA    E   293_A      L      69          1.251
LGA    A   294_A      A      70          2.013
LGA    V   295_A      A      71          1.753
LGA    A   296_A      Q      72          1.127
LGA    S   297_A      I      73          1.670
LGA    L   298_A      I      74          1.896
LGA    K   299_A      Q      75          1.611
LGA    N   300_A      A      76          1.961
LGA    T   301_A      S      77          1.004
LGA    S   302_A      G      78          0.895
LGA    D   303_A      E      79          0.704
LGA    M   304_A      R      80          0.942
LGA    V   305_A      V      81          0.943
LGA    Y   306_A      N      82          0.724
LGA    L   307_A      L      83          0.650
LGA    K   308_A      T      84          0.707
LGA    V   309_A      I      85          0.568
LGA    A   310_A      A      86          0.836
LGA    K   311_A      R      87          0.958
LGA    P   312_A      P      88          2.562
LGA    G   313_A      G      89          2.268
LGA    S   314_A      K      90          6.137
LGA    -       -      P      91           -
LGA    -       -      E      92           -
LGA    -       -      I      93           -
LGA    -       -      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   94   95    5.0     87    1.69    34.48     85.688     4.864

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.331996 * X  +  -0.821835 * Y  +   0.462997 * Z  +  24.060419
  Y_new =  -0.828319 * X  +   0.019168 * Y  +  -0.559929 * Z  +  25.931921
  Z_new =   0.451294 * X  +  -0.569403 * Y  +  -0.687105 * Z  +  20.728231 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.449596    0.691997  [ DEG:  -140.3515     39.6485 ]
  Theta =  -0.468215   -2.673378  [ DEG:   -26.8267   -153.1733 ]
  Phi   =  -1.951998    1.189595  [ DEG:  -111.8412     68.1588 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fe5_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fe5_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   94   95   5.0   87   1.69   34.48  85.688
REMARK  ---------------------------------------------------------- 
MOLECULE 2fe5_A
HEADER    STRUCTURAL PROTEIN                      15-DEC-05   2FE5              
TITLE     THE CRYSTAL STRUCTURE OF THE SECOND PDZ DOMAIN OF HUMAN DLG3          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRESYNAPTIC PROTEIN SAP102;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ2;                                                      
COMPND   5 SYNONYM: SYNAPSE-ASSOCIATED PROTEIN 102, NEUROENDOCRINE-             
COMPND   6 DLG, NE-DLG, DISCS LARGE HOMOLOG 3, DLG3, DLG3A;                     
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DLG3, KIAA1232;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    PDZ DOMAIN, DLG3, HUMAN, STRUCTURAL GENOMICS, STRUCTURAL              
KEYWDS   2 GENOMICS CONSORTIUM, SGC                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.UGOCHUKWU,C.PHILLIPS,G.SCHOCH,G.BERRIDGE,E.SALAH,                   
AUTHOR   2 S.COLEBROOK,C.SMEE,P.SAVITSKY,J.BRAY,J.ELKINS,D.DOYLE,               
AUTHOR   3 G.BUNKOCZI,J.DEBRECZENI,A.TURNBULL,F.GORREC,F.VON DELFT,             
AUTHOR   4 M.SUNDSTROM,C.ARROWSMITH,J.WEIGEL,A.EDWARDS,STRUCTURAL               
AUTHOR   5 GENOMICS CONSORTIUM (SGC)                                            
REVDAT   1   27-DEC-05 2FE5    0                                                
JRNL        AUTH   E.UGOCHUKWU,C.PHILLIPS,G.SCHOCH,G.BERRIDGE,E.SALAH,          
JRNL        AUTH 2 S.COLEBROOK,C.SMEE,P.SAVITSKY,J.BRAY,J.ELKINS,               
JRNL        AUTH 3 D.DOYLE,G.BUNKOCZI,J.DEBRECZENI,A.TURNBULL,                  
JRNL        AUTH 4 F.GORREC,F.VON DELFT,M.SUNDSTROM,C.ARROWSMITH,               
JRNL        AUTH 5 J.WEIGEL,A.EDWARDS,                                          
JRNL        AUTH 6 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE SECOND PDZ DOMAIN OF            
JRNL        TITL 2 HUMAN DLG3                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.10 ANGSTROMS.                                          
DBREF  2FE5 A  223   314  UNP    Q92796   DLG3_HUMAN     223    314             
SEQRES   1 A   94  SER MET THR ILE MET GLU VAL ASN LEU LEU LYS GLY PRO          
SEQRES   2 A   94  LYS GLY LEU GLY PHE SER ILE ALA GLY GLY ILE GLY ASN          
SEQRES   3 A   94  GLN HIS ILE PRO GLY ASP ASN SER ILE TYR ILE THR LYS          
SEQRES   4 A   94  ILE ILE GLU GLY GLY ALA ALA GLN LYS ASP GLY ARG LEU          
SEQRES   5 A   94  GLN ILE GLY ASP ARG LEU LEU ALA VAL ASN ASN THR ASN          
SEQRES   6 A   94  LEU GLN ASP VAL ARG HIS GLU GLU ALA VAL ALA SER LEU          
SEQRES   7 A   94  LYS ASN THR SER ASP MET VAL TYR LEU LYS VAL ALA LYS          
SEQRES   8 A   94  PRO GLY SER                                                  
HET    SO4    501       5                                                       
HET    GOL    401      12                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3  GOL    C3 H8 O3                                                     
FORMUL   4  HOH   *173(H2 O)                                                    
CRYST1   26.487   40.242   33.340  90.00  92.80  90.00 P 1 21 1      2          
ATOM      1  N   SER A 221      23.836  15.216  23.331  1.00 25.64           N  
ATOM      2  CA  SER A 221      23.925  15.821  21.975  1.00 23.18           C  
ATOM      3  C   SER A 221      22.745  15.397  21.122  1.00 21.62           C  
ATOM      4  O   SER A 221      22.098  14.385  21.374  1.00 22.06           O  
ATOM      5  CB  SER A 221      25.222  15.410  21.274  1.00 23.63           C  
ATOM      6  OG  SER A 221      26.331  16.103  21.818  1.00 29.25           O  
ATOM      7  N   MET A 222      22.503  16.174  20.082  1.00 20.13           N  
ATOM      8  CA  MET A 222      21.428  15.931  19.137  0.70 14.34           C  
ATOM     10  C   MET A 222      21.871  14.867  18.135  1.00 10.74           C  
ATOM     11  O   MET A 222      23.021  14.890  17.703  1.00 13.64           O  
ATOM     12  CB  MET A 222      21.187  17.247  18.418  0.70 17.13           C  
ATOM     14  CG  MET A 222      19.867  17.439  17.784  0.70 20.47           C  
ATOM     16  SD  MET A 222      19.784  19.210  17.454  0.70 14.34           S  
ATOM     18  CE  MET A 222      18.502  19.732  18.590  0.70 21.61           C  
ATOM     20  N   THR A 223      20.968  13.956  17.760  1.00  9.04           N  
ATOM     21  CA  THR A 223      21.207  12.999  16.680  1.00  8.08           C  
ATOM     22  C   THR A 223      20.677  13.634  15.398  1.00  6.77           C  
ATOM     23  O   THR A 223      19.472  13.683  15.176  1.00  8.67           O  
ATOM     24  CB  THR A 223      20.496  11.657  16.941  1.00  9.15           C  
ATOM     25  OG1 THR A 223      20.973  11.085  18.167  1.00 12.72           O  
ATOM     26  CG2 THR A 223      20.740  10.685  15.783  1.00 11.12           C  
ATOM     27  N   ILE A 224      21.570  14.165  14.578  1.00  6.70           N  
ATOM     28  CA  ILE A 224      21.179  14.953  13.427  1.00  7.17           C  
ATOM     29  C   ILE A 224      21.403  14.150  12.157  1.00  8.74           C  
ATOM     30  O   ILE A 224      22.428  13.498  12.008  1.00 12.94           O  
ATOM     31  CB  ILE A 224      21.938  16.297  13.411  1.00  8.19           C  
ATOM     32  CG1 ILE A 224      21.594  17.121  14.666  1.00  9.00           C  
ATOM     33  CG2 ILE A 224      21.603  17.093  12.134  1.00 10.24           C  
ATOM     34  CD1 ILE A 224      22.480  18.349  14.878  1.00 11.21           C  
ATOM     35  N   MET A 225      20.419  14.182  11.257  1.00  6.68           N  
ATOM     36  CA  MET A 225      20.535  13.582   9.937  1.00  6.84           C  
ATOM     37  C   MET A 225      20.189  14.625   8.880  1.00  5.09           C  
ATOM     38  O   MET A 225      19.308  15.458   9.087  1.00  6.38           O  
ATOM     39  CB  MET A 225      19.577  12.399   9.780  1.00  8.62           C  
ATOM     40  CG  MET A 225      19.929  11.102  10.510  1.00 12.65           C  
ATOM     41  SD  MET A 225      18.772   9.713  10.335  0.50  8.39           S  
ATOM     43  CE  MET A 225      19.018   9.261   8.627  0.50  5.81           C  
ATOM     45  N   GLU A 226      20.878  14.543   7.745  1.00  4.73           N  
ATOM     46  CA  GLU A 226      20.591  15.355   6.570  0.70  4.86           C  
ATOM     48  C   GLU A 226      20.040  14.453   5.474  1.00  5.62           C  
ATOM     49  O   GLU A 226      20.635  13.414   5.177  1.00  6.49           O  
ATOM     50  CB  GLU A 226      21.866  16.001   6.047  0.70  7.40           C  
ATOM     52  CG  GLU A 226      22.557  16.930   7.015  0.70  7.98           C  
ATOM     54  CD  GLU A 226      23.849  17.467   6.426  0.70  8.04           C  
ATOM     56  OE1 GLU A 226      24.591  16.692   5.792  0.70 13.68           O  
ATOM     58  OE2 GLU A 226      24.114  18.667   6.545  0.70  5.65           O  
ATOM     60  N   VAL A 227      18.932  14.856   4.871  1.00  5.28           N  
ATOM     61  CA  VAL A 227      18.246  14.067   3.849  1.00  7.51           C  
ATOM     62  C   VAL A 227      17.960  15.018   2.682  1.00  6.25           C  
ATOM     63  O   VAL A 227      17.296  16.043   2.877  1.00 10.83           O  
ATOM     64  CB  VAL A 227      16.912  13.459   4.421  1.00  8.82           C  
ATOM     65  CG1 VAL A 227      16.090  12.727   3.350  1.00  9.78           C  
ATOM     66  CG2 VAL A 227      17.206  12.532   5.597  1.00 10.65           C  
ATOM     67  N   ASN A 228      18.445  14.688   1.480  1.00  6.23           N  
ATOM     68  CA  ASN A 228      18.172  15.467   0.269  1.00  6.52           C  
ATOM     69  C   ASN A 228      17.161  14.693  -0.557  1.00  6.56           C  
ATOM     70  O   ASN A 228      17.454  13.593  -1.018  1.00 10.27           O  
ATOM     71  CB  ASN A 228      19.461  15.699  -0.524  1.00  7.57           C  
ATOM     72  CG  ASN A 228      20.403  16.681   0.176  1.00  8.27           C  
ATOM     73  OD1 ASN A 228      20.149  17.877   0.201  1.00 12.36           O  
ATOM     74  ND2 ASN A 228      21.456  16.168   0.790  1.00 11.85           N  
ATOM     75  N   LEU A 229      15.978  15.265  -0.734  1.00  5.71           N  
ATOM     76  CA  LEU A 229      14.884  14.609  -1.451  1.00  5.78           C  
ATOM     77  C   LEU A 229      14.548  15.319  -2.741  1.00  5.82           C  
ATOM     78  O   LEU A 229      14.615  16.538  -2.838  1.00  6.37           O  
ATOM     79  CB  LEU A 229      13.614  14.560  -0.590  1.00  6.05           C  
ATOM     80  CG  LEU A 229      13.661  13.747   0.705  1.00  7.49           C  
ATOM     81  CD1 LEU A 229      12.314  13.785   1.402  1.00  8.97           C  
ATOM     82  CD2 LEU A 229      14.091  12.320   0.443  1.00 10.09           C  
ATOM     83  N   LEU A 230      14.173  14.519  -3.727  1.00  5.54           N  
ATOM     84  CA  LEU A 230      13.619  14.985  -4.985  1.00  6.35           C  
ATOM     85  C   LEU A 230      12.104  14.948  -4.836  1.00  6.67           C  
ATOM     86  O   LEU A 230      11.535  13.902  -4.517  1.00  7.20           O  
ATOM     87  CB  LEU A 230      14.044  14.041  -6.110  1.00  8.58           C  
ATOM     88  CG  LEU A 230      13.459  14.332  -7.488  1.00 11.55           C  
ATOM     89  CD1 LEU A 230      13.776  15.746  -7.916  1.00 13.00           C  
ATOM     90  CD2 LEU A 230      13.966  13.335  -8.510  1.00 15.79           C  
ATOM     91  N   LYS A 231      11.429  16.066  -5.050  1.00  6.96           N  
ATOM     92  CA  LYS A 231       9.980  16.102  -4.790  1.00  8.29           C  
ATOM     93  C   LYS A 231       9.184  15.037  -5.570  1.00  8.22           C  
ATOM     94  O   LYS A 231       8.371  14.294  -5.010  1.00 10.58           O  
ATOM     95  CB  LYS A 231       9.413  17.488  -5.074  1.00 10.44           C  
ATOM     96  CG  LYS A 231       9.793  18.508  -4.045  1.00 14.41           C  
ATOM     97  CD  LYS A 231       8.960  19.796  -4.136  1.00 18.16           C  
ATOM     98  CE  LYS A 231       9.038  20.565  -2.831  1.00 17.25           C  
ATOM     99  NZ  LYS A 231       8.173  21.794  -2.754  1.00 21.40           N  
ATOM    100  N   GLY A 232       9.415  14.992  -6.859  1.00  7.72           N  
ATOM    101  CA  GLY A 232       8.815  14.017  -7.718  1.00  7.16           C  
ATOM    102  C   GLY A 232       7.315  14.174  -7.898  1.00  5.99           C  
ATOM    103  O   GLY A 232       6.699  15.140  -7.462  1.00  7.07           O  
ATOM    104  N   PRO A 233       6.696  13.194  -8.558  1.00  6.85           N  
ATOM    105  CA  PRO A 233       5.281  13.267  -8.923  1.00  6.59           C  
ATOM    106  C   PRO A 233       4.309  13.407  -7.775  1.00  7.11           C  
ATOM    107  O   PRO A 233       3.219  13.925  -7.978  1.00 11.03           O  
ATOM    108  CB  PRO A 233       5.041  11.953  -9.673  1.00  9.79           C  
ATOM    109  CG  PRO A 233       6.343  11.500 -10.113  1.00 11.80           C  
ATOM    110  CD  PRO A 233       7.347  12.008  -9.131  1.00  7.46           C  
ATOM    111  N   LYS A 234       4.661  12.909  -6.593  1.00  5.66           N  
ATOM    112  CA  LYS A 234       3.764  12.969  -5.443  1.00  6.56           C  
ATOM    113  C   LYS A 234       4.262  13.925  -4.362  1.00  6.52           C  
ATOM    114  O   LYS A 234       3.657  14.020  -3.306  1.00 10.17           O  
ATOM    115  CB  LYS A 234       3.555  11.564  -4.878  1.00  7.60           C  
ATOM    116  CG  LYS A 234       2.858  10.601  -5.847  1.00  7.77           C  
ATOM    117  CD  LYS A 234       1.444  11.025  -6.201  1.00  8.92           C  
ATOM    118  CE  LYS A 234       0.718   9.947  -6.986  1.00 10.91           C  
ATOM    119  NZ  LYS A 234      -0.722  10.303  -7.198  1.00 14.80           N  
ATOM    120  N   GLY A 235       5.318  14.683  -4.638  1.00  5.66           N  
ATOM    121  CA  GLY A 235       5.837  15.642  -3.680  1.00  6.22           C  
ATOM    122  C   GLY A 235       6.629  15.009  -2.556  1.00  5.50           C  
ATOM    123  O   GLY A 235       6.798  13.794  -2.481  1.00  7.28           O  
ATOM    124  N   LEU A 236       7.082  15.853  -1.639  1.00  5.20           N  
ATOM    125  CA  LEU A 236       7.851  15.395  -0.483  1.00  5.61           C  
ATOM    126  C   LEU A 236       7.077  14.395   0.368  1.00  5.81           C  
ATOM    127  O   LEU A 236       7.658  13.464   0.900  1.00  7.37           O  
ATOM    128  CB  LEU A 236       8.286  16.584   0.378  1.00  6.48           C  
ATOM    129  CG  LEU A 236       9.253  17.585  -0.271  1.00  7.90           C  
ATOM    130  CD1 LEU A 236       9.568  18.756   0.679  1.00 10.83           C  
ATOM    131  CD2 LEU A 236      10.541  16.890  -0.736  1.00  9.80           C  
ATOM    132  N   GLY A 237       5.785  14.624   0.545  1.00  5.65           N  
ATOM    133  CA  GLY A 237       4.923  13.625   1.183  1.00  7.46           C  
ATOM    134  C   GLY A 237       5.178  13.414   2.668  1.00  5.68           C  
ATOM    135  O   GLY A 237       5.332  12.285   3.131  1.00  6.26           O  
ATOM    136  N   PHE A 238       5.194  14.496   3.435  1.00  6.14           N  
ATOM    137  CA  PHE A 238       5.123  14.365   4.895  1.00  5.77           C  
ATOM    138  C   PHE A 238       4.407  15.553   5.494  1.00  6.60           C  
ATOM    139  O   PHE A 238       4.420  16.649   4.936  1.00  8.29           O  
ATOM    140  CB  PHE A 238       6.504  14.108   5.526  1.00  5.49           C  
ATOM    141  CG  PHE A 238       7.493  15.242   5.388  1.00  5.54           C  
ATOM    142  CD1 PHE A 238       8.351  15.298   4.305  1.00  5.64           C  
ATOM    143  CD2 PHE A 238       7.590  16.218   6.367  1.00  6.07           C  
ATOM    144  CE1 PHE A 238       9.289  16.310   4.201  1.00  6.82           C  
ATOM    145  CE2 PHE A 238       8.523  17.239   6.261  1.00  6.95           C  
ATOM    146  CZ  PHE A 238       9.373  17.275   5.180  1.00  6.55           C  
ATOM    147  N   SER A 239       3.768  15.319   6.626  1.00  5.92           N  
ATOM    148  CA  SER A 239       3.058  16.339   7.357  1.00  6.37           C  
ATOM    149  C   SER A 239       3.867  16.786   8.553  1.00  5.27           C  
ATOM    150  O   SER A 239       4.593  15.979   9.139  1.00  5.43           O  
ATOM    151  CB  SER A 239       1.727  15.794   7.832  1.00  8.01           C  
ATOM    152  OG  SER A 239       0.978  15.250   6.761  1.00 10.92           O  
ATOM    153  N   ILE A 240       3.675  18.046   8.938  1.00  5.06           N  
ATOM    154  CA  ILE A 240       4.352  18.619  10.083  1.00  5.07           C  
ATOM    155  C   ILE A 240       3.359  19.264  11.031  1.00  5.39           C  
ATOM    156  O   ILE A 240       2.351  19.839  10.602  1.00  6.62           O  
ATOM    157  CB  ILE A 240       5.445  19.657   9.682  1.00  5.28           C  
ATOM    158  CG1 ILE A 240       4.908  20.737   8.725  1.00  5.34           C  
ATOM    159  CG2 ILE A 240       6.660  18.934   9.095  1.00  6.68           C  
ATOM    160  CD1 ILE A 240       5.765  22.008   8.724  1.00  6.94           C  
ATOM    161  N   ALA A 241       3.684  19.205  12.313  1.00  4.82           N  
ATOM    162  CA  ALA A 241       2.990  19.927  13.362  1.00  5.56           C  
ATOM    163  C   ALA A 241       4.027  20.732  14.150  1.00  4.63           C  
ATOM    164  O   ALA A 241       5.189  20.816  13.759  1.00  6.02           O  
ATOM    165  CB  ALA A 241       2.234  18.952  14.274  1.00  8.98           C  
ATOM    166  N   GLY A 242       3.613  21.299  15.275  1.00  4.85           N  
ATOM    167  CA  GLY A 242       4.497  22.148  16.054  1.00  4.97           C  
ATOM    168  C   GLY A 242       4.575  23.573  15.540  1.00  4.60           C  
ATOM    169  O   GLY A 242       3.833  23.990  14.663  1.00  5.47           O  
ATOM    170  N   GLY A 243       5.484  24.329  16.132  1.00  5.61           N  
ATOM    171  CA  GLY A 243       5.687  25.744  15.834  1.00  5.24           C  
ATOM    172  C   GLY A 243       5.214  26.660  16.946  1.00  5.41           C  
ATOM    173  O   GLY A 243       4.409  26.286  17.809  1.00  6.08           O  
ATOM    174  N   ILE A 244       5.697  27.893  16.892  1.00  5.47           N  
ATOM    175  CA  ILE A 244       5.245  28.959  17.778  1.00  5.69           C  
ATOM    176  C   ILE A 244       3.734  29.069  17.683  1.00  6.53           C  
ATOM    177  O   ILE A 244       3.203  29.114  16.596  1.00  8.35           O  
ATOM    178  CB  ILE A 244       5.894  30.283  17.362  1.00  6.44           C  
ATOM    179  CG1 ILE A 244       7.406  30.238  17.623  1.00  7.68           C  
ATOM    180  CG2 ILE A 244       5.265  31.448  18.115  1.00  9.02           C  
ATOM    181  CD1 ILE A 244       8.171  31.401  17.012  1.00  9.33           C  
ATOM    182  N   GLY A 245       3.054  29.085  18.824  1.00  6.75           N  
ATOM    183  CA  GLY A 245       1.597  29.150  18.865  1.00  7.92           C  
ATOM    184  C   GLY A 245       0.887  27.850  18.504  1.00  6.74           C  
ATOM    185  O   GLY A 245      -0.333  27.835  18.380  1.00  8.12           O  
ATOM    186  N   ASN A 246       1.640  26.757  18.351  1.00  5.94           N  
ATOM    187  CA  ASN A 246       1.088  25.480  17.897  1.00  5.96           C  
ATOM    188  C   ASN A 246       1.907  24.334  18.487  1.00  5.63           C  
ATOM    189  O   ASN A 246       2.255  23.396  17.779  1.00  6.07           O  
ATOM    190  CB  ASN A 246       1.116  25.431  16.366  1.00  6.77           C  
ATOM    191  CG  ASN A 246       0.317  24.276  15.793  1.00  7.08           C  
ATOM    192  OD1 ASN A 246      -0.814  24.017  16.209  1.00  9.35           O  
ATOM    193  ND2 ASN A 246       0.893  23.585  14.811  1.00  6.93           N  
ATOM    194  N   GLN A 247       2.223  24.422  19.773  1.00  5.62           N  
ATOM    195  CA  GLN A 247       3.241  23.543  20.357  1.00  6.11           C  
ATOM    196  C   GLN A 247       2.846  22.073  20.355  1.00  5.46           C  
ATOM    197  O   GLN A 247       1.743  21.705  20.762  1.00  6.96           O  
ATOM    198  CB  GLN A 247       3.544  23.944  21.789  1.00  6.65           C  
ATOM    199  CG  GLN A 247       4.152  25.312  21.904  1.00  7.03           C  
ATOM    200  CD  GLN A 247       4.603  25.646  23.306  1.00  6.98           C  
ATOM    201  OE1 GLN A 247       4.037  25.168  24.303  1.00  7.63           O  
ATOM    202  NE2 GLN A 247       5.606  26.505  23.404  1.00  8.00           N  
ATOM    203  N   HIS A 248       3.783  21.235  19.948  1.00  5.87           N  
ATOM    204  CA  HIS A 248       3.631  19.790  19.982  1.00  6.86           C  
ATOM    205  C   HIS A 248       3.787  19.232  21.402  1.00  6.22           C  
ATOM    206  O   HIS A 248       3.145  18.239  21.753  1.00  8.85           O  
ATOM    207  CB  HIS A 248       4.683  19.196  19.037  1.00  7.40           C  
ATOM    208  CG  HIS A 248       4.604  17.716  18.843  1.00  8.13           C  
ATOM    209  ND1 HIS A 248       3.553  17.098  18.201  1.00 12.54           N  
ATOM    210  CD2 HIS A 248       5.484  16.736  19.159  1.00 10.13           C  
ATOM    211  CE1 HIS A 248       3.785  15.797  18.147  1.00 14.06           C  
ATOM    212  NE2 HIS A 248       4.949  15.552  18.722  1.00 12.90           N  
ATOM    213  N   ILE A 249       4.681  19.841  22.184  1.00  6.77           N  
ATOM    214  CA  ILE A 249       4.944  19.482  23.583  1.00  7.78           C  
ATOM    215  C   ILE A 249       5.028  20.806  24.338  1.00  7.57           C  
ATOM    216  O   ILE A 249       5.571  21.765  23.804  1.00  6.94           O  
ATOM    217  CB  ILE A 249       6.291  18.722  23.718  1.00  9.84           C  
ATOM    218  CG1 ILE A 249       6.231  17.395  22.951  1.00 11.06           C  
ATOM    219  CG2 ILE A 249       6.661  18.492  25.189  1.00 12.80           C  
ATOM    220  CD1 ILE A 249       7.594  16.793  22.664  1.00 14.39           C  
ATOM    221  N   PRO A 250       4.473  20.899  25.567  1.00  7.78           N  
ATOM    222  CA  PRO A 250       4.481  22.211  26.239  1.00  7.69           C  
ATOM    223  C   PRO A 250       5.868  22.790  26.465  1.00  7.04           C  
ATOM    224  O   PRO A 250       6.735  22.164  27.069  1.00  8.07           O  
ATOM    225  CB  PRO A 250       3.762  21.944  27.567  1.00  7.24           C  
ATOM    226  CG  PRO A 250       2.926  20.762  27.279  1.00  8.49           C  
ATOM    227  CD  PRO A 250       3.733  19.900  26.354  1.00  8.72           C  
ATOM    228  N   GLY A 251       6.062  24.011  25.974  1.00  7.45           N  
ATOM    229  CA  GLY A 251       7.341  24.697  26.025  1.00  8.89           C  
ATOM    230  C   GLY A 251       8.215  24.506  24.809  1.00  8.10           C  
ATOM    231  O   GLY A 251       9.244  25.165  24.697  1.00 11.03           O  
ATOM    232  N   ASP A 252       7.807  23.621  23.901  1.00  6.91           N  
ATOM    233  CA  ASP A 252       8.624  23.243  22.747  1.00  6.56           C  
ATOM    234  C   ASP A 252       7.960  23.765  21.477  1.00  5.74           C  
ATOM    235  O   ASP A 252       6.869  23.326  21.125  1.00  6.32           O  
ATOM    236  CB  ASP A 252       8.738  21.715  22.711  1.00  7.59           C  
ATOM    237  CG  ASP A 252       9.694  21.204  21.662  1.00  9.32           C  
ATOM    238  OD1 ASP A 252      10.188  21.985  20.823  1.00 13.91           O  
ATOM    239  OD2 ASP A 252       9.978  19.988  21.714  1.00 12.94           O  
ATOM    240  N   ASN A 253       8.614  24.708  20.806  1.00  5.80           N  
ATOM    241  CA  ASN A 253       8.130  25.245  19.538  1.00  5.06           C  
ATOM    242  C   ASN A 253       8.648  24.520  18.307  1.00  5.50           C  
ATOM    243  O   ASN A 253       8.364  24.953  17.194  1.00  5.72           O  
ATOM    244  CB  ASN A 253       8.489  26.730  19.433  1.00  7.05           C  
ATOM    245  CG  ASN A 253       7.764  27.564  20.452  1.00  7.30           C  
ATOM    246  OD1 ASN A 253       6.618  27.291  20.786  1.00  8.23           O  
ATOM    247  ND2 ASN A 253       8.419  28.614  20.936  1.00 12.97           N  
ATOM    248  N   SER A 254       9.385  23.426  18.490  1.00  5.04           N  
ATOM    249  CA  SER A 254       9.958  22.710  17.363  1.00  5.29           C  
ATOM    250  C   SER A 254       8.891  22.212  16.395  1.00  4.96           C  
ATOM    251  O   SER A 254       7.759  21.884  16.780  1.00  5.13           O  
ATOM    252  CB  SER A 254      10.758  21.491  17.840  1.00  6.76           C  
ATOM    253  OG  SER A 254      11.851  21.824  18.660  1.00  8.17           O  
ATOM    254  N   ILE A 255       9.297  22.085  15.136  1.00  4.50           N  
ATOM    255  CA  ILE A 255       8.487  21.476  14.088  1.00  4.29           C  
ATOM    256  C   ILE A 255       8.731  19.968  14.134  1.00  4.37           C  
ATOM    257  O   ILE A 255       9.888  19.524  14.114  1.00  4.78           O  
ATOM    258  CB  ILE A 255       8.887  22.052  12.704  1.00  4.39           C  
ATOM    259  CG1 ILE A 255       8.739  23.581  12.679  1.00  4.88           C  
ATOM    260  CG2 ILE A 255       8.078  21.385  11.615  1.00  5.37           C  
ATOM    261  CD1 ILE A 255       7.329  24.096  12.936  1.00  6.55           C  
ATOM    262  N   TYR A 256       7.652  19.182  14.158  1.00  4.37           N  
ATOM    263  CA  TYR A 256       7.731  17.716  14.202  1.00  4.82           C  
ATOM    264  C   TYR A 256       7.061  17.108  12.987  1.00  4.47           C  
ATOM    265  O   TYR A 256       5.984  17.533  12.592  1.00  5.13           O  
ATOM    266  CB  TYR A 256       7.032  17.163  15.457  1.00  5.78           C  
ATOM    267  CG  TYR A 256       7.786  17.354  16.749  1.00  6.11           C  
ATOM    268  CD1 TYR A 256       8.503  16.308  17.322  1.00  7.87           C  
ATOM    269  CD2 TYR A 256       7.754  18.572  17.429  1.00  5.68           C  
ATOM    270  CE1 TYR A 256       9.166  16.463  18.503  1.00 10.10           C  
ATOM    271  CE2 TYR A 256       8.442  18.740  18.633  1.00  6.68           C  
ATOM    272  CZ  TYR A 256       9.148  17.670  19.158  1.00  8.09           C  
ATOM    273  OH  TYR A 256       9.847  17.773  20.342  1.00 10.45           O  
ATOM    274  N   ILE A 257       7.675  16.074  12.435  1.00  4.69           N  
ATOM    275  CA  ILE A 257       7.046  15.279  11.391  1.00  5.10           C  
ATOM    276  C   ILE A 257       6.024  14.327  12.019  1.00  4.78           C  
ATOM    277  O   ILE A 257       6.358  13.514  12.894  1.00  6.12           O  
ATOM    278  CB  ILE A 257       8.100  14.481  10.604  1.00  5.81           C  
ATOM    279  CG1 ILE A 257       9.096  15.459   9.933  1.00  6.41           C  
ATOM    280  CG2 ILE A 257       7.405  13.561   9.581  1.00  6.43           C  
ATOM    281  CD1 ILE A 257      10.143  14.781   9.035  1.00  8.87           C  
ATOM    282  N   THR A 258       4.781  14.428  11.573  1.00  5.68           N  
ATOM    283  CA  THR A 258       3.685  13.660  12.157  1.00  6.10           C  
ATOM    284  C   THR A 258       3.107  12.577  11.248  1.00  5.63           C  
ATOM    285  O   THR A 258       2.400  11.700  11.739  1.00  6.86           O  
ATOM    286  CB  THR A 258       2.537  14.563  12.564  1.00  7.57           C  
ATOM    287  OG1 THR A 258       2.155  15.338  11.422  1.00  9.59           O  
ATOM    288  CG2 THR A 258       2.950  15.482  13.706  1.00 10.96           C  
ATOM    289  N   LYS A 259       3.373  12.631   9.941  1.00  5.62           N  
ATOM    290  CA  LYS A 259       2.870  11.638   8.987  1.00  5.99           C  
ATOM    291  C   LYS A 259       3.849  11.508   7.840  1.00  6.93           C  
ATOM    292  O   LYS A 259       4.406  12.522   7.407  1.00  7.55           O  
ATOM    293  CB  LYS A 259       1.485  12.019   8.492  0.60  7.34           C  
ATOM    295  CG  LYS A 259       0.758  10.873   7.838  0.60 11.12           C  
ATOM    297  CD  LYS A 259      -0.394  11.379   7.067  0.60 15.00           C  
ATOM    299  CE  LYS A 259      -1.631  11.481   7.871  0.60 18.43           C  
ATOM    301  NZ  LYS A 259      -2.615  11.863   6.876  0.60 12.18           N  
ATOM    303  N   ILE A 260       4.022  10.283   7.341  1.00  6.78           N  
ATOM    304  CA  ILE A 260       4.746  10.013   6.101  1.00  7.57           C  
ATOM    305  C   ILE A 260       3.685   9.547   5.114  1.00  7.97           C  
ATOM    306  O   ILE A 260       3.065   8.500   5.317  1.00 10.78           O  
ATOM    307  CB  ILE A 260       5.831   8.927   6.272  1.00  8.84           C  
ATOM    308  CG1 ILE A 260       6.842   9.293   7.369  1.00 10.32           C  
ATOM    309  CG2 ILE A 260       6.519   8.653   4.935  1.00 10.45           C  
ATOM    310  CD1 ILE A 260       7.662  10.529   7.106  1.00 11.06           C  
ATOM    311  N   ILE A 261       3.452  10.333   4.071  1.00  7.32           N  
ATOM    312  CA  ILE A 261       2.350  10.112   3.142  1.00  7.38           C  
ATOM    313  C   ILE A 261       2.705   8.989   2.158  1.00  6.37           C  
ATOM    314  O   ILE A 261       3.792   8.962   1.575  1.00  6.83           O  
ATOM    315  CB  ILE A 261       2.003  11.401   2.372  1.00  7.59           C  
ATOM    316  CG1 ILE A 261       1.768  12.591   3.307  0.70  9.83           C  
ATOM    318  CG2 ILE A 261       0.817  11.171   1.443  1.00  9.36           C  
ATOM    319  CD1 ILE A 261       0.697  12.404   4.286  0.70  9.26           C  
ATOM    321  N   GLU A 262       1.784   8.055   1.964  1.00  7.04           N  
ATOM    322  CA  GLU A 262       2.060   6.954   1.067  1.00  6.09           C  
ATOM    323  C   GLU A 262       2.278   7.479  -0.344  1.00  5.78           C  
ATOM    324  O   GLU A 262       1.479   8.273  -0.840  1.00  7.45           O  
ATOM    325  CB  GLU A 262       0.895   5.962   1.064  1.00  6.91           C  
ATOM    326  CG  GLU A 262       0.737   5.162   2.329  1.00 10.02           C  
ATOM    327  CD  GLU A 262       1.812   4.138   2.528  1.00  9.72           C  
ATOM    328  OE1 GLU A 262       2.120   3.371   1.583  1.00 10.01           O  
ATOM    329  OE2 GLU A 262       2.330   4.079   3.656  1.00 14.58           O  
ATOM    330  N   GLY A 263       3.342   7.007  -0.984  1.00  5.95           N  
ATOM    331  CA  GLY A 263       3.662   7.362  -2.367  1.00  6.75           C  
ATOM    332  C   GLY A 263       4.565   8.560  -2.543  1.00  5.53           C  
ATOM    333  O   GLY A 263       5.008   8.810  -3.657  1.00  6.37           O  
ATOM    334  N   GLY A 264       4.830   9.300  -1.477  1.00  4.89           N  
ATOM    335  CA  GLY A 264       5.653  10.498  -1.566  1.00  5.64           C  
ATOM    336  C   GLY A 264       7.137  10.196  -1.515  1.00  4.53           C  
ATOM    337  O   GLY A 264       7.571   9.069  -1.288  1.00  5.17           O  
ATOM    338  N   ALA A 265       7.930  11.240  -1.704  1.00  4.83           N  
ATOM    339  CA  ALA A 265       9.385  11.104  -1.743  1.00  5.30           C  
ATOM    340  C   ALA A 265       9.943  10.638  -0.401  1.00  4.50           C  
ATOM    341  O   ALA A 265      10.893   9.864  -0.363  1.00  5.38           O  
ATOM    342  CB  ALA A 265      10.036  12.423  -2.137  1.00  6.50           C  
ATOM    343  N   ALA A 266       9.378  11.127   0.693  1.00  4.71           N  
ATOM    344  CA  ALA A 266       9.896  10.770   2.007  1.00  5.24           C  
ATOM    345  C   ALA A 266       9.765   9.270   2.239  1.00  5.29           C  
ATOM    346  O   ALA A 266      10.681   8.633   2.758  1.00  5.19           O  
ATOM    347  CB  ALA A 266       9.195  11.562   3.101  1.00  5.78           C  
ATOM    348  N   GLN A 267       8.616   8.699   1.880  1.00  5.22           N  
ATOM    349  CA  GLN A 267       8.401   7.261   2.037  1.00  6.45           C  
ATOM    350  C   GLN A 267       9.399   6.483   1.182  1.00  6.52           C  
ATOM    351  O   GLN A 267      10.008   5.524   1.641  1.00  7.64           O  
ATOM    352  CB  GLN A 267       6.987   6.845   1.643  1.00  7.34           C  
ATOM    353  CG  GLN A 267       6.783   5.326   1.812  1.00 10.94           C  
ATOM    354  CD  GLN A 267       5.531   4.816   1.173  1.00  9.62           C  
ATOM    355  OE1 GLN A 267       5.183   5.228   0.065  1.00 10.25           O  
ATOM    356  NE2 GLN A 267       4.856   3.892   1.842  1.00 12.91           N  
ATOM    357  N   LYS A 268       9.510   6.854  -0.090  1.00  6.42           N  
ATOM    358  CA  LYS A 268      10.376   6.130  -1.006  1.00  7.74           C  
ATOM    359  C   LYS A 268      11.811   6.100  -0.482  1.00  6.48           C  
ATOM    360  O   LYS A 268      12.468   5.057  -0.466  1.00  8.60           O  
ATOM    361  CB  LYS A 268      10.318   6.765  -2.401  1.00  8.46           C  
ATOM    362  CG  LYS A 268      11.274   6.144  -3.404  1.00 10.29           C  
ATOM    363  CD  LYS A 268      11.196   6.849  -4.766  1.00 12.47           C  
ATOM    364  CE  LYS A 268      12.292   6.376  -5.705  1.00 15.03           C  
ATOM    365  NZ  LYS A 268      12.271   7.118  -6.999  1.00 16.77           N  
ATOM    366  N   ASP A 269      12.282   7.240  -0.006  1.00  5.94           N  
ATOM    367  CA  ASP A 269      13.641   7.349   0.494  1.00  5.25           C  
ATOM    368  C   ASP A 269      13.830   6.601   1.816  1.00  6.14           C  
ATOM    369  O   ASP A 269      14.883   6.010   2.043  1.00  7.13           O  
ATOM    370  CB  ASP A 269      14.012   8.821   0.634  1.00  5.37           C  
ATOM    371  CG  ASP A 269      15.319   9.017   1.363  1.00  5.27           C  
ATOM    372  OD1 ASP A 269      16.372   8.961   0.693  1.00  6.29           O  
ATOM    373  OD2 ASP A 269      15.280   9.204   2.600  1.00  5.20           O  
ATOM    374  N   GLY A 270      12.825   6.679   2.685  1.00  5.53           N  
ATOM    375  CA  GLY A 270      12.782   5.892   3.912  1.00  6.54           C  
ATOM    376  C   GLY A 270      13.500   6.438   5.137  1.00  5.82           C  
ATOM    377  O   GLY A 270      13.334   5.897   6.228  1.00  8.37           O  
ATOM    378  N   ARG A 271      14.304   7.484   5.002  1.00  5.22           N  
ATOM    379  CA  ARG A 271      15.113   7.961   6.130  1.00  5.93           C  
ATOM    380  C   ARG A 271      14.331   8.807   7.132  1.00  5.41           C  
ATOM    381  O   ARG A 271      14.575   8.716   8.339  1.00  6.58           O  
ATOM    382  CB  ARG A 271      16.340   8.713   5.637  1.00  5.91           C  
ATOM    383  CG  ARG A 271      17.364   7.815   4.966  1.00  6.26           C  
ATOM    384  CD  ARG A 271      18.527   8.592   4.433  1.00  6.29           C  
ATOM    385  NE  ARG A 271      18.148   9.339   3.244  1.00  6.61           N  
ATOM    386  CZ  ARG A 271      18.976  10.148   2.584  1.00  6.31           C  
ATOM    387  NH1 ARG A 271      20.188  10.391   3.065  1.00  7.33           N  
ATOM    388  NH2 ARG A 271      18.583  10.704   1.446  1.00  6.65           N  
ATOM    389  N   LEU A 272      13.415   9.636   6.650  1.00  5.25           N  
ATOM    390  CA  LEU A 272      12.587  10.435   7.544  1.00  5.33           C  
ATOM    391  C   LEU A 272      11.582   9.547   8.242  1.00  5.44           C  
ATOM    392  O   LEU A 272      11.049   8.608   7.655  1.00  7.97           O  
ATOM    393  CB  LEU A 272      11.868  11.543   6.784  1.00  5.38           C  
ATOM    394  CG  LEU A 272      12.765  12.602   6.133  1.00  6.02           C  
ATOM    395  CD1 LEU A 272      11.894  13.561   5.338  1.00 10.06           C  
ATOM    396  CD2 LEU A 272      13.597  13.334   7.173  1.00  8.81           C  
ATOM    397  N   GLN A 273      11.321   9.865   9.500  1.00  5.98           N  
ATOM    398  CA  GLN A 273      10.435   9.072  10.351  1.00  7.63           C  
ATOM    399  C   GLN A 273       9.496   9.986  11.134  1.00  5.95           C  
ATOM    400  O   GLN A 273       9.874  11.079  11.548  1.00  5.94           O  
ATOM    401  CB  GLN A 273      11.263   8.202  11.333  1.00  7.61           C  
ATOM    402  CG  GLN A 273      12.139   7.110  10.672  1.00  8.73           C  
ATOM    403  CD  GLN A 273      13.242   6.577  11.588  1.00  7.66           C  
ATOM    404  OE1 GLN A 273      14.187   7.299  11.905  1.00  9.59           O  
ATOM    405  NE2 GLN A 273      13.138   5.304  12.006  1.00 10.59           N  
ATOM    406  N   ILE A 274       8.282   9.510  11.390  1.00  5.79           N  
ATOM    407  CA  ILE A 274       7.388  10.182  12.329  1.00  5.27           C  
ATOM    408  C   ILE A 274       8.137  10.378  13.642  1.00  5.05           C  
ATOM    409  O   ILE A 274       8.794   9.454  14.146  1.00  5.61           O  
ATOM    410  CB  ILE A 274       6.075   9.409  12.544  1.00  5.91           C  
ATOM    411  CG1 ILE A 274       5.261   9.391  11.241  1.00  7.12           C  
ATOM    412  CG2 ILE A 274       5.270  10.020  13.688  1.00  6.19           C  
ATOM    413  CD1 ILE A 274       3.982   8.559  11.323  1.00  8.31           C  
ATOM    414  N   GLY A 275       8.057  11.596  14.168  1.00  4.95           N  
ATOM    415  CA  GLY A 275       8.722  11.960  15.413  1.00  5.48           C  
ATOM    416  C   GLY A 275       9.985  12.775  15.206  1.00  4.72           C  
ATOM    417  O   GLY A 275      10.504  13.357  16.162  1.00  5.06           O  
ATOM    418  N   ASP A 276      10.499  12.827  13.978  1.00  5.10           N  
ATOM    419  CA  ASP A 276      11.662  13.663  13.695  1.00  5.29           C  
ATOM    420  C   ASP A 276      11.316  15.128  13.890  1.00  4.38           C  
ATOM    421  O   ASP A 276      10.199  15.566  13.615  1.00  5.39           O  
ATOM    422  CB  ASP A 276      12.123  13.447  12.258  1.00  5.13           C  
ATOM    423  CG  ASP A 276      12.809  12.104  12.033  1.00  7.32           C  
ATOM    424  OD1 ASP A 276      13.055  11.363  13.006  1.00  8.51           O  
ATOM    425  OD2 ASP A 276      13.133  11.804  10.863  1.00  8.68           O  
ATOM    426  N   ARG A 277      12.292  15.895  14.363  1.00  4.46           N  
ATOM    427  CA  ARG A 277      12.168  17.347  14.450  1.00  5.36           C  
ATOM    428  C   ARG A 277      12.846  17.958  13.241  1.00  5.12           C  
ATOM    429  O   ARG A 277      14.005  17.664  12.960  1.00  6.09           O  
ATOM    430  CB  ARG A 277      12.793  17.859  15.730  0.70  7.14           C  
ATOM    432  CG  ARG A 277      11.871  17.766  16.913  0.70 10.05           C  
ATOM    434  CD  ARG A 277      12.667  17.916  18.180  0.70  9.83           C  
ATOM    436  NE  ARG A 277      13.480  16.733  18.421  0.70  8.04           N  
ATOM    438  CZ  ARG A 277      14.545  16.697  19.216  0.70  9.25           C  
ATOM    440  NH1 ARG A 277      14.949  17.773  19.868  0.70 13.35           N  
ATOM    442  NH2 ARG A 277      15.203  15.563  19.366  0.70 10.15           N  
ATOM    444  N   LEU A 278      12.123  18.805  12.529  1.00  4.68           N  
ATOM    445  CA  LEU A 278      12.651  19.434  11.326  1.00  5.26           C  
ATOM    446  C   LEU A 278      13.411  20.697  11.735  1.00  4.60           C  
ATOM    447  O   LEU A 278      12.806  21.700  12.135  1.00  5.29           O  
ATOM    448  CB  LEU A 278      11.516  19.737  10.347  1.00  5.99           C  
ATOM    449  CG  LEU A 278      11.919  20.362   9.009  1.00  5.47           C  
ATOM    450  CD1 LEU A 278      12.878  19.441   8.241  1.00  6.56           C  
ATOM    451  CD2 LEU A 278      10.681  20.668   8.191  1.00  6.45           C  
ATOM    452  N   LEU A 279      14.733  20.628  11.668  1.00  4.26           N  
ATOM    453  CA  LEU A 279      15.603  21.724  12.068  1.00  4.04           C  
ATOM    454  C   LEU A 279      15.799  22.801  11.002  1.00  4.36           C  
ATOM    455  O   LEU A 279      15.973  23.968  11.334  1.00  5.12           O  
ATOM    456  CB  LEU A 279      16.982  21.210  12.467  1.00  4.97           C  
ATOM    457  CG  LEU A 279      17.026  20.160  13.578  1.00  5.22           C  
ATOM    458  CD1 LEU A 279      18.464  19.706  13.801  1.00  7.50           C  
ATOM    459  CD2 LEU A 279      16.379  20.656  14.862  1.00  8.56           C  
ATOM    460  N   ALA A 280      15.835  22.388   9.731  1.00  4.23           N  
ATOM    461  CA  ALA A 280      16.083  23.322   8.628  1.00  4.93           C  
ATOM    462  C   ALA A 280      15.582  22.741   7.332  1.00  4.14           C  
ATOM    463  O   ALA A 280      15.565  21.517   7.143  1.00  4.63           O  
ATOM    464  CB  ALA A 280      17.589  23.634   8.486  1.00  5.49           C  
ATOM    465  N   VAL A 281      15.204  23.645   6.437  1.00  4.19           N  
ATOM    466  CA  VAL A 281      14.928  23.354   5.035  1.00  4.08           C  
ATOM    467  C   VAL A 281      15.890  24.230   4.243  1.00  4.14           C  
ATOM    468  O   VAL A 281      15.881  25.460   4.408  1.00  4.33           O  
ATOM    469  CB  VAL A 281      13.480  23.687   4.660  1.00  4.65           C  
ATOM    470  CG1 VAL A 281      13.258  23.561   3.146  1.00  6.34           C  
ATOM    471  CG2 VAL A 281      12.508  22.802   5.434  1.00  6.51           C  
ATOM    472  N   ASN A 282      16.736  23.627   3.420  1.00  4.51           N  
ATOM    473  CA  ASN A 282      17.776  24.383   2.716  1.00  5.87           C  
ATOM    474  C   ASN A 282      18.529  25.259   3.722  1.00  5.35           C  
ATOM    475  O   ASN A 282      19.003  24.718   4.728  1.00  6.50           O  
ATOM    476  CB  ASN A 282      17.185  25.125   1.518  1.00  5.97           C  
ATOM    477  CG  ASN A 282      16.675  24.175   0.450  1.00  6.57           C  
ATOM    478  OD1 ASN A 282      17.118  23.028   0.345  1.00  7.05           O  
ATOM    479  ND2 ASN A 282      15.735  24.640  -0.347  1.00  8.06           N  
ATOM    480  N   ASN A 283      18.633  26.569   3.493  1.00  6.10           N  
ATOM    481  CA  ASN A 283      19.331  27.475   4.412  1.00  7.17           C  
ATOM    482  C   ASN A 283      18.411  28.164   5.413  1.00  7.38           C  
ATOM    483  O   ASN A 283      18.809  29.169   6.016  1.00 10.12           O  
ATOM    484  CB  ASN A 283      20.069  28.574   3.627  1.00  9.23           C  
ATOM    485  CG  ASN A 283      21.547  28.330   3.495  1.00  9.53           C  
ATOM    486  OD1 ASN A 283      22.057  27.233   3.734  1.00 11.48           O  
ATOM    487  ND2 ASN A 283      22.266  29.382   3.107  1.00 13.63           N  
ATOM    488  N   THR A 284      17.192  27.660   5.579  1.00  6.05           N  
ATOM    489  CA  THR A 284      16.217  28.271   6.474  1.00  6.21           C  
ATOM    490  C   THR A 284      16.105  27.468   7.770  1.00  5.59           C  
ATOM    491  O   THR A 284      15.698  26.303   7.760  1.00  5.86           O  
ATOM    492  CB  THR A 284      14.848  28.357   5.799  1.00  5.44           C  
ATOM    493  OG1 THR A 284      14.986  29.105   4.583  1.00  6.27           O  
ATOM    494  CG2 THR A 284      13.825  29.032   6.686  1.00  6.85           C  
ATOM    495  N   ASN A 285      16.472  28.096   8.878  1.00  5.18           N  
ATOM    496  CA  ASN A 285      16.426  27.454  10.196  1.00  6.04           C  
ATOM    497  C   ASN A 285      14.997  27.503  10.734  1.00  5.06           C  
ATOM    498  O   ASN A 285      14.392  28.579  10.818  1.00  7.56           O  
ATOM    499  CB  ASN A 285      17.383  28.210  11.129  1.00  7.04           C  
ATOM    500  CG  ASN A 285      17.541  27.553  12.482  1.00  8.47           C  
ATOM    501  OD1 ASN A 285      16.571  27.190  13.111  1.00 12.01           O  
ATOM    502  ND2 ASN A 285      18.782  27.504  12.981  1.00 11.15           N  
ATOM    503  N   LEU A 286      14.471  26.342  11.097  1.00  4.67           N  
ATOM    504  CA  LEU A 286      13.089  26.206  11.565  1.00  5.10           C  
ATOM    505  C   LEU A 286      13.016  25.840  13.046  1.00  5.59           C  
ATOM    506  O   LEU A 286      11.987  25.351  13.513  1.00  6.05           O  
ATOM    507  CB  LEU A 286      12.339  25.160  10.722  1.00  5.79           C  
ATOM    508  CG  LEU A 286      12.245  25.470   9.227  1.00  7.07           C  
ATOM    509  CD1 LEU A 286      11.490  24.333   8.534  1.00  9.29           C  
ATOM    510  CD2 LEU A 286      11.587  26.811   8.923  1.00  7.64           C  
ATOM    511  N   GLN A 287      14.074  26.106  13.809  1.00  5.79           N  
ATOM    512  CA  GLN A 287      14.072  25.755  15.234  1.00  6.81           C  
ATOM    513  C   GLN A 287      13.107  26.605  16.059  1.00  8.53           C  
ATOM    514  O   GLN A 287      12.707  26.161  17.133  1.00 14.64           O  
ATOM    515  CB  GLN A 287      15.491  25.789  15.808  1.00  7.25           C  
ATOM    516  CG  GLN A 287      16.322  24.661  15.258  1.00  7.09           C  
ATOM    517  CD  GLN A 287      17.733  24.616  15.806  1.00  7.06           C  
ATOM    518  OE1 GLN A 287      18.654  25.149  15.195  1.00  8.30           O  
ATOM    519  NE2 GLN A 287      17.918  23.976  16.955  1.00  7.80           N  
ATOM    520  N   ASP A 288      12.735  27.790  15.590  1.00  7.64           N  
ATOM    521  CA  ASP A 288      11.823  28.656  16.342  1.00  8.66           C  
ATOM    522  C   ASP A 288      11.035  29.565  15.399  1.00  7.91           C  
ATOM    523  O   ASP A 288      11.342  30.752  15.261  1.00  9.05           O  
ATOM    524  CB  ASP A 288      12.612  29.456  17.380  1.00 12.08           C  
ATOM    525  CG  ASP A 288      11.722  30.216  18.340  1.00 15.22           C  
ATOM    526  OD1 ASP A 288      10.674  29.680  18.750  1.00 22.81           O  
ATOM    527  OD2 ASP A 288      12.087  31.348  18.690  1.00 24.68           O  
ATOM    528  N   VAL A 289      10.024  28.981  14.755  1.00  6.46           N  
ATOM    529  CA  VAL A 289       9.211  29.693  13.782  1.00  6.27           C  
ATOM    530  C   VAL A 289       7.749  29.314  13.979  1.00  5.78           C  
ATOM    531  O   VAL A 289       7.415  28.310  14.624  1.00  6.78           O  
ATOM    532  CB  VAL A 289       9.625  29.339  12.323  1.00  6.24           C  
ATOM    533  CG1 VAL A 289      11.061  29.748  12.040  1.00  7.64           C  
ATOM    534  CG2 VAL A 289       9.416  27.853  12.023  1.00  6.62           C  
ATOM    535  N   ARG A 290       6.880  30.113  13.376  1.00  6.06           N  
ATOM    536  CA  ARG A 290       5.465  29.770  13.248  1.00  6.32           C  
ATOM    537  C   ARG A 290       5.279  28.559  12.356  1.00  5.66           C  
ATOM    538  O   ARG A 290       6.031  28.363  11.406  1.00  5.64           O  
ATOM    539  CB  ARG A 290       4.714  30.950  12.632  1.00  7.95           C  
ATOM    540  CG  ARG A 290       4.554  32.123  13.575  1.00 11.64           C  
ATOM    541  CD  ARG A 290       3.356  31.941  14.462  1.00 12.54           C  
ATOM    542  NE  ARG A 290       2.085  32.039  13.738  1.00 12.44           N  
ATOM    543  CZ  ARG A 290       1.333  33.142  13.639  1.00 13.02           C  
ATOM    544  NH1 ARG A 290       1.704  34.301  14.159  1.00 15.07           N  
ATOM    545  NH2 ARG A 290       0.185  33.078  13.005  1.00 12.23           N  
ATOM    546  N   HIS A 291       4.238  27.768  12.627  1.00  5.35           N  
ATOM    547  CA  HIS A 291       3.909  26.641  11.756  1.00  5.07           C  
ATOM    548  C   HIS A 291       3.709  27.092  10.301  1.00  5.18           C  
ATOM    549  O   HIS A 291       4.141  26.412   9.365  1.00  5.44           O  
ATOM    550  CB  HIS A 291       2.660  25.929  12.287  1.00  5.42           C  
ATOM    551  CG  HIS A 291       2.303  24.678  11.547  1.00  5.07           C  
ATOM    552  ND1 HIS A 291       1.353  24.659  10.555  1.00  8.43           N  
ATOM    553  CD2 HIS A 291       2.776  23.412  11.641  1.00  6.03           C  
ATOM    554  CE1 HIS A 291       1.243  23.433  10.082  1.00  7.30           C  
ATOM    555  NE2 HIS A 291       2.101  22.656  10.718  1.00  5.98           N  
ATOM    556  N   GLU A 292       3.060  28.243  10.110  1.00  5.26           N  
ATOM    557  CA  GLU A 292       2.804  28.739   8.761  1.00  6.49           C  
ATOM    558  C   GLU A 292       4.108  29.001   8.006  1.00  5.74           C  
ATOM    559  O   GLU A 292       4.181  28.805   6.787  1.00  6.01           O  
ATOM    560  CB  GLU A 292       1.969  30.024   8.797  1.00  7.91           C  
ATOM    561  CG  GLU A 292       0.612  29.915   9.500  1.00  7.92           C  
ATOM    562  CD  GLU A 292       0.642  30.207  11.003  1.00  7.46           C  
ATOM    563  OE1 GLU A 292       1.700  30.117  11.652  1.00  8.18           O  
ATOM    564  OE2 GLU A 292      -0.426  30.563  11.553  1.00  9.65           O  
ATOM    565  N   GLU A 293       5.117  29.479   8.727  1.00  5.57           N  
ATOM    566  CA  GLU A 293       6.429  29.751   8.158  1.00  5.69           C  
ATOM    567  C   GLU A 293       7.163  28.465   7.802  1.00  4.86           C  
ATOM    568  O   GLU A 293       7.870  28.389   6.786  1.00  5.98           O  
ATOM    569  CB  GLU A 293       7.247  30.601   9.131  1.00  7.23           C  
ATOM    570  CG  GLU A 293       6.698  32.017   9.199  1.00 10.20           C  
ATOM    571  CD  GLU A 293       7.027  32.801  10.444  1.00 14.74           C  
ATOM    572  OE1 GLU A 293       7.644  32.270  11.388  1.00 13.81           O  
ATOM    573  OE2 GLU A 293       6.638  33.987  10.466  1.00 20.47           O  
ATOM    574  N   ALA A 294       7.022  27.431   8.634  1.00  4.67           N  
ATOM    575  CA  ALA A 294       7.621  26.137   8.331  1.00  4.90           C  
ATOM    576  C   ALA A 294       6.978  25.522   7.085  1.00  4.82           C  
ATOM    577  O   ALA A 294       7.662  24.999   6.209  1.00  4.55           O  
ATOM    578  CB  ALA A 294       7.502  25.185   9.520  1.00  5.64           C  
ATOM    579  N   VAL A 295       5.643  25.553   7.010  1.00  4.66           N  
ATOM    580  CA  VAL A 295       4.946  25.061   5.826  1.00  5.65           C  
ATOM    581  C   VAL A 295       5.414  25.819   4.590  1.00  6.34           C  
ATOM    582  O   VAL A 295       5.739  25.215   3.572  1.00  6.36           O  
ATOM    583  CB  VAL A 295       3.421  25.160   5.981  1.00  5.81           C  
ATOM    584  CG1 VAL A 295       2.717  24.839   4.654  1.00  7.44           C  
ATOM    585  CG2 VAL A 295       2.939  24.223   7.073  1.00  7.18           C  
ATOM    586  N   ALA A 296       5.488  27.143   4.690  1.00  5.85           N  
ATOM    587  CA  ALA A 296       5.923  27.967   3.551  1.00  7.13           C  
ATOM    588  C   ALA A 296       7.332  27.572   3.100  1.00  6.45           C  
ATOM    589  O   ALA A 296       7.598  27.478   1.907  1.00  7.15           O  
ATOM    590  CB  ALA A 296       5.883  29.460   3.902  1.00  8.98           C  
ATOM    591  N   SER A 297       8.226  27.335   4.048  1.00  6.11           N  
ATOM    592  CA  SER A 297       9.590  26.976   3.717  0.75  5.93           C  
ATOM    594  C   SER A 297       9.647  25.674   2.915  1.00  5.92           C  
ATOM    595  O   SER A 297      10.424  25.538   1.975  1.00  8.07           O  
ATOM    596  CB  SER A 297      10.393  26.869   5.004  0.75  7.17           C  
ATOM    598  OG  SER A 297      11.735  26.554   4.748  0.75  8.69           O  
ATOM    600  N   LEU A 298       8.801  24.715   3.270  1.00  5.73           N  
ATOM    601  CA  LEU A 298       8.735  23.452   2.529  1.00  6.59           C  
ATOM    602  C   LEU A 298       8.172  23.644   1.125  1.00  7.63           C  
ATOM    603  O   LEU A 298       8.601  22.987   0.184  1.00  9.64           O  
ATOM    604  CB  LEU A 298       7.899  22.434   3.308  1.00  7.23           C  
ATOM    605  CG  LEU A 298       8.605  21.869   4.543  1.00  7.02           C  
ATOM    606  CD1 LEU A 298       7.614  21.204   5.468  1.00  9.16           C  
ATOM    607  CD2 LEU A 298       9.677  20.890   4.120  1.00  6.99           C  
ATOM    608  N   LYS A 299       7.197  24.534   0.992  1.00  8.35           N  
ATOM    609  CA  LYS A 299       6.588  24.807  -0.309  1.00 10.07           C  
ATOM    610  C   LYS A 299       7.469  25.725  -1.201  1.00  9.99           C  
ATOM    611  O   LYS A 299       7.404  25.609  -2.434  1.00 16.40           O  
ATOM    612  CB  LYS A 299       5.177  25.379  -0.113  1.00 13.02           C  
ATOM    613  CG  LYS A 299       4.236  24.530   0.770  1.00 12.85           C  
ATOM    614  CD  LYS A 299       4.016  23.096   0.265  1.00 15.98           C  
ATOM    615  CE  LYS A 299       3.285  22.255   1.302  1.00 18.55           C  
ATOM    616  NZ  LYS A 299       2.987  20.882   0.825  1.00 25.14           N  
ATOM    617  N   ASN A 300       8.313  26.572  -0.604  0.50  9.03           N  
ATOM    619  CA  ASN A 300       9.186  27.500  -1.359  0.50 10.13           C  
ATOM    621  C   ASN A 300      10.420  26.799  -1.939  0.50 12.83           C  
ATOM    623  O   ASN A 300      11.350  27.465  -2.400  0.50 20.36           O  
ATOM    625  CB  ASN A 300       9.654  28.679  -0.476  0.50  9.09           C  
ATOM    627  CG  ASN A 300       8.535  29.653  -0.127  0.50  8.89           C  
ATOM    629  OD1 ASN A 300       7.542  29.771  -0.854  0.50 13.26           O  
ATOM    631  ND2 ASN A 300       8.700  30.369   0.991  0.50 11.92           N  
ATOM    633  N   THR A 301      10.434  25.465  -1.923  0.50 12.00           N  
ATOM    635  CA  THR A 301      11.588  24.702  -2.392  0.50 12.67           C  
ATOM    637  C   THR A 301      11.405  24.151  -3.808  0.50 14.61           C  
ATOM    639  O   THR A 301      10.282  23.846  -4.230  0.50 15.24           O  
ATOM    641  CB  THR A 301      11.903  23.519  -1.441  0.50 10.95           C  
ATOM    643  OG1 THR A 301      10.778  22.634  -1.369  0.50 12.22           O  
ATOM    645  CG2 THR A 301      12.249  24.016  -0.049  0.50 13.57           C  
ATOM    647  N   SER A 302      12.535  24.014  -4.507  0.50 13.83           N  
ATOM    649  CA  SER A 302      12.612  23.525  -5.895  0.50 12.93           C  
ATOM    651  C   SER A 302      12.517  21.995  -5.927  0.50 11.18           C  
ATOM    653  O   SER A 302      11.925  21.418  -5.021  0.50 11.46           O  
ATOM    655  CB  SER A 302      13.917  24.006  -6.550  0.50 12.90           C  
ATOM    657  OG  SER A 302      13.792  25.327  -7.059  0.50 16.35           O  
ATOM    659  N   ASP A 303      13.111  21.334  -6.927  0.50 12.52           N  
ATOM    661  CA  ASP A 303      12.977  19.873  -7.021  0.50 11.94           C  
ATOM    663  C   ASP A 303      13.830  19.105  -6.013  1.00 11.55           C  
ATOM    664  O   ASP A 303      13.337  18.183  -5.416  1.00 12.95           O  
ATOM    665  CB  ASP A 303      13.178  19.304  -8.437  1.00 15.77           C  
ATOM    666  CG  ASP A 303      14.590  19.418  -8.933  1.00 17.46           C  
ATOM    667  OD1 ASP A 303      15.286  20.367  -8.543  1.00 23.51           O  
ATOM    668  OD2 ASP A 303      14.964  18.563  -9.780  1.00 14.72           O  
ATOM    669  N   MET A 304      15.093  19.483  -5.808  1.00 12.20           N  
ATOM    670  CA  MET A 304      15.908  18.858  -4.739  1.00 10.17           C  
ATOM    671  C   MET A 304      15.827  19.726  -3.502  1.00 10.74           C  
ATOM    672  O   MET A 304      16.027  20.938  -3.579  1.00 10.85           O  
ATOM    673  CB  MET A 304      17.382  18.725  -5.108  1.00 13.45           C  
ATOM    674  CG  MET A 304      17.743  17.640  -6.118  1.00 16.02           C  
ATOM    675  SD  MET A 304      17.387  15.917  -5.674  1.00 11.92           S  
ATOM    676  CE  MET A 304      18.117  15.725  -4.077  1.00 12.03           C  
ATOM    677  N   VAL A 305      15.575  19.097  -2.364  1.00  6.29           N  
ATOM    678  CA  VAL A 305      15.321  19.792  -1.128  1.00  5.42           C  
ATOM    679  C   VAL A 305      16.171  19.195  -0.012  1.00  4.74           C  
ATOM    680  O   VAL A 305      16.117  18.001   0.247  1.00  5.86           O  
ATOM    681  CB  VAL A 305      13.837  19.673  -0.741  1.00  5.84           C  
ATOM    682  CG1 VAL A 305      13.544  20.518   0.493  1.00  7.00           C  
ATOM    683  CG2 VAL A 305      12.913  20.085  -1.927  1.00  8.46           C  
ATOM    684  N   TYR A 306      16.957  20.045   0.639  1.00  4.68           N  
ATOM    685  CA  TYR A 306      17.760  19.653   1.793  1.00  4.07           C  
ATOM    686  C   TYR A 306      16.916  19.773   3.053  1.00  4.10           C  
ATOM    687  O   TYR A 306      16.354  20.845   3.336  1.00  4.89           O  
ATOM    688  CB  TYR A 306      18.979  20.539   1.889  1.00  4.77           C  
ATOM    689  CG  TYR A 306      19.780  20.434   3.170  1.00  4.60           C  
ATOM    690  CD1 TYR A 306      20.841  19.538   3.267  1.00  5.13           C  
ATOM    691  CD2 TYR A 306      19.535  21.279   4.252  1.00  5.02           C  
ATOM    692  CE1 TYR A 306      21.632  19.484   4.406  1.00  5.04           C  
ATOM    693  CE2 TYR A 306      20.322  21.231   5.402  1.00  5.27           C  
ATOM    694  CZ  TYR A 306      21.373  20.329   5.467  1.00  5.53           C  
ATOM    695  OH  TYR A 306      22.183  20.319   6.575  1.00  6.48           O  
ATOM    696  N   LEU A 307      16.851  18.683   3.815  1.00  3.82           N  
ATOM    697  CA  LEU A 307      16.103  18.641   5.057  1.00  4.42           C  
ATOM    698  C   LEU A 307      17.057  18.172   6.146  1.00  4.70           C  
ATOM    699  O   LEU A 307      17.711  17.147   6.011  1.00  6.50           O  
ATOM    700  CB  LEU A 307      14.936  17.655   4.939  1.00  4.78           C  
ATOM    701  CG  LEU A 307      13.954  17.985   3.807  1.00  5.30           C  
ATOM    702  CD1 LEU A 307      13.005  16.837   3.555  1.00  8.21           C  
ATOM    703  CD2 LEU A 307      13.187  19.258   4.101  1.00  6.52           C  
ATOM    704  N   LYS A 308      17.143  18.919   7.228  1.00  3.98           N  
ATOM    705  CA  LYS A 308      17.983  18.553   8.359  1.00  4.43           C  
ATOM    706  C   LYS A 308      17.046  18.282   9.522  1.00  4.22           C  
ATOM    707  O   LYS A 308      16.222  19.136   9.854  1.00  4.68           O  
ATOM    708  CB  LYS A 308      18.951  19.690   8.694  1.00  4.76           C  
ATOM    709  CG  LYS A 308      19.883  19.351   9.843  1.00  5.51           C  
ATOM    710  CD  LYS A 308      21.021  20.344   9.965  1.00  6.40           C  
ATOM    711  CE  LYS A 308      20.531  21.734  10.271  1.00  7.09           C  
ATOM    712  NZ  LYS A 308      21.663  22.714  10.344  1.00  8.19           N  
ATOM    713  N   VAL A 309      17.177  17.101  10.124  1.00  4.26           N  
ATOM    714  CA  VAL A 309      16.295  16.672  11.202  1.00  4.66           C  
ATOM    715  C   VAL A 309      17.095  16.232  12.411  1.00  4.51           C  
ATOM    716  O   VAL A 309      18.244  15.794  12.294  1.00  5.55           O  
ATOM    717  CB  VAL A 309      15.337  15.537  10.770  1.00  5.35           C  
ATOM    718  CG1 VAL A 309      14.418  16.008   9.645  1.00  6.16           C  
ATOM    719  CG2 VAL A 309      16.093  14.264  10.380  1.00  6.79           C  
ATOM    720  N   ALA A 310      16.468  16.354  13.575  1.00  4.95           N  
ATOM    721  CA  ALA A 310      16.919  15.711  14.805  1.00  5.73           C  
ATOM    722  C   ALA A 310      16.040  14.514  15.068  1.00  5.69           C  
ATOM    723  O   ALA A 310      14.814  14.610  15.060  1.00  7.15           O  
ATOM    724  CB  ALA A 310      16.875  16.663  16.003  1.00  7.38           C  
ATOM    725  N   LYS A 311      16.676  13.379  15.323  1.00  7.08           N  
ATOM    726  CA  LYS A 311      15.961  12.159  15.652  1.00  7.07           C  
ATOM    727  C   LYS A 311      15.557  12.251  17.114  1.00  9.04           C  
ATOM    728  O   LYS A 311      16.026  13.135  17.838  1.00 10.67           O  
ATOM    729  CB  LYS A 311      16.816  10.936  15.328  1.00  8.41           C  
ATOM    730  CG  LYS A 311      17.445  10.968  13.921  1.00 10.58           C  
ATOM    731  CD  LYS A 311      16.463  11.108  12.764  1.00 12.84           C  
ATOM    732  CE  LYS A 311      15.776   9.805  12.455  1.00 13.07           C  
ATOM    733  NZ  LYS A 311      15.002   9.789  11.147  1.00  9.11           N  
ATOM    734  N   PRO A 312      14.602  11.418  17.536  1.00 10.51           N  
ATOM    735  CA  PRO A 312      14.131  11.524  18.920  1.00 11.10           C  
ATOM    736  C   PRO A 312      15.267  11.399  19.910  1.00 14.99           C  
ATOM    737  O   PRO A 312      16.163  10.580  19.735  1.00 15.89           O  
ATOM    738  CB  PRO A 312      13.125  10.378  19.042  1.00 12.01           C  
ATOM    739  CG  PRO A 312      12.620  10.207  17.631  1.00 12.34           C  
ATOM    740  CD  PRO A 312      13.831  10.427  16.769  1.00 10.78           C  
ATOM    741  N   GLY A 313      15.245  12.263  20.916  1.00 21.87           N  
ATOM    742  CA  GLY A 313      16.294  12.293  21.909  1.00 22.50           C  
ATOM    743  C   GLY A 313      15.890  11.516  23.137  1.00 29.42           C  
ATOM    744  O   GLY A 313      16.708  10.804  23.716  1.00 39.73           O  
ATOM    745  N   SER A 314      14.615  11.623  23.509  1.00 25.65           N  
ATOM    746  CA  SER A 314      14.146  11.197  24.824  1.00 22.39           C  
ATOM    747  C   SER A 314      13.264   9.950  24.787  1.00 25.13           C  
ATOM    748  O   SER A 314      13.334   9.149  23.855  1.00 27.49           O  
ATOM    749  CB  SER A 314      13.379  12.347  25.476  1.00 22.82           C  
ATOM    750  OG  SER A 314      12.255  12.735  24.696  1.00 25.70           O  
ATOM    751  OXT SER A 314      12.464   9.714  25.706  1.00 21.00           O  
TER     752      SER A 314                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
