
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  738),  selected   98 , name 2byg_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2byg_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    F   186_A      -       -           -
LGA    Q   187_A      -       -           -
LGA    S   188_A      S       1          2.012
LGA    M   189_A      M       2          1.331
LGA    T   190_A      E       3          0.548
LGA    V   191_A      I       4          0.298
LGA    V   192_A      L       5          0.338
LGA    E   193_A      Q       6          0.693
LGA    I   194_A      V       7          0.628
LGA    K   195_A      A       8          0.779
LGA    L   196_A      L       9          0.682
LGA    F   197_A      H      10          0.801
LGA    K   198_A      K      11          1.706
LGA    G   199_A      R      12          3.860
LGA    P   200_A      D      13          4.810
LGA    -       -      S      14           -
LGA    -       -      G      15           -
LGA    K   201_A      E      16          3.454
LGA    G   202_A      Q      17          1.938
LGA    L   203_A      L      18          1.414
LGA    G   204_A      G      19          1.484
LGA    F   205_A      I      20          1.132
LGA    S   206_A      K      21          1.858
LGA    I   207_A      L      22          0.504
LGA    A   208_A      V      23          0.837
LGA    G   209_A      R      24          1.240
LGA    G   210_A      -       -           -
LGA    V   211_A      -       -           -
LGA    G   212_A      -       -           -
LGA    N   213_A      -       -           -
LGA    Q   214_A      -       -           -
LGA    H   215_A      -       -           -
LGA    I   216_A      R      25          2.544
LGA    P   217_A      T      26          2.783
LGA    G   218_A      D      27          2.518
LGA    D   219_A      E      28          0.985
LGA    N   220_A      P      29          1.793
LGA    S   221_A      G      30          0.595
LGA    I   222_A      V      31          0.230
LGA    Y   223_A      F      32          0.571
LGA    V   224_A      I      33          0.988
LGA    T   225_A      L      34          1.697
LGA    K   226_A      D      35          2.398
LGA    I   227_A      L      36          0.794
LGA    I   228_A      L      37          1.445
LGA    D   229_A      E      38          1.520
LGA    G   230_A      G      39          1.400
LGA    G   231_A      G      40          1.305
LGA    A   232_A      L      41          1.091
LGA    A   233_A      A      42          0.749
LGA    Q   234_A      A      43          0.757
LGA    K   235_A      Q      44          0.956
LGA    D   236_A      D      45          0.823
LGA    G   237_A      G      46          0.839
LGA    R   238_A      R      47          0.294
LGA    L   239_A      L      48          0.432
LGA    Q   240_A      S      49          0.669
LGA    V   241_A      S      50          1.459
LGA    G   242_A      N      51          1.367
LGA    D   243_A      D      52          0.731
LGA    R   244_A      R      53          0.651
LGA    L   245_A      V      54          0.504
LGA    L   246_A      L      55          0.560
LGA    M   247_A      A      56          0.417
LGA    V   248_A      I      57          0.515
LGA    N   249_A      N      58          0.624
LGA    N   250_A      G      59          0.667
LGA    Y   251_A      H      60          0.124
LGA    S   252_A      D      61          0.310
LGA    L   253_A      L      62          0.180
LGA    E   254_A      K      63          1.422
LGA    E   255_A      Y      64          1.156
LGA    V   256_A      G      65          1.900
LGA    T   257_A      T      66          3.254
LGA    H   258_A      P      67          3.200
LGA    E   259_A      E      68          2.355
LGA    E   260_A      L      69          2.053
LGA    A   261_A      A      70          2.341
LGA    V   262_A      A      71          1.991
LGA    A   263_A      Q      72          1.183
LGA    I   264_A      I      73          1.612
LGA    L   265_A      I      74          2.006
LGA    K   266_A      Q      75          1.658
LGA    N   267_A      A      76          1.789
LGA    T   268_A      S      77          1.130
LGA    S   269_A      G      78          1.726
LGA    E   270_A      E      79          1.086
LGA    V   271_A      R      80          0.766
LGA    V   272_A      V      81          0.918
LGA    Y   273_A      N      82          0.885
LGA    L   274_A      L      83          0.727
LGA    K   275_A      T      84          0.284
LGA    V   276_A      I      85          0.576
LGA    G   277_A      A      86          0.747
LGA    K   278_A      R      87          0.909
LGA    P   279_A      P      88          1.997
LGA    T   280_A      G      89          2.446
LGA    T   281_A      K      90          1.125
LGA    I   282_A      P      91           -
LGA    Y   283_A      E      92           -
LGA    -       -      I      93           -
LGA    -       -      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   95    5.0     88    1.56    29.55     86.801     5.289

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.925238 * X  +  -0.176414 * Y  +  -0.335875 * Z  +  24.144388
  Y_new =   0.379307 * X  +  -0.412054 * Y  +  -0.828455 * Z  +  32.559761
  Z_new =   0.007753 * X  +  -0.893918 * Y  +   0.448164 * Z  +  20.922813 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.106071    2.035521  [ DEG:   -63.3732    116.6268 ]
  Theta =  -0.007753   -3.133840  [ DEG:    -0.4442   -179.5558 ]
  Phi   =   2.752533   -0.389060  [ DEG:   157.7085    -22.2915 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2byg_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2byg_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   95   5.0   88   1.56   29.55  86.801
REMARK  ---------------------------------------------------------- 
MOLECULE 2byg_A
HEADER    SIGNAL TRANSDUCTION                     19-JUL-05   2BYG              
TITLE     2ND PDZ DOMAIN OF DISCS LARGE HOMOLOGUE 2                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CHANNEL ASSOCIATED PROTEIN OF SYNAPSE-110;                 
COMPND   3 SYNONYM: CHAPSYN-110, DISCS LARGE HOMOLOG 2;                         
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: 2ND PDZ DOMAIN, RESIDUES 190-283;                          
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4;                              
SOURCE   4 EXPRESSION_SYSTEM_CELL_LINE: BL21(DE3);                              
SOURCE   5 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   6 ORGANISM_COMMON: HUMAN                                               
KEYWDS    DLG2, PDZ, PDZ DOMAIN, STRUCTURAL GENOMICS, STRUCTURAL                
KEYWDS   2 GENOMICS CONSORTIUM, SGC, PHOSPHORYLATION, SH3 DOMAIN,               
KEYWDS   3 SIGNAL TRANSDUCTION                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.M.ELKINS,G.A.SCHOCH,C.E.A.SMEE,G.BERRIDGE,E.SALAH,                  
AUTHOR   2 M.SUNDSTROM,A.EDWARDS,C.ARROWSMITH,J.WEIGELT,D.A.DOYLE,              
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   2   30-OCT-07 2BYG    1       JRNL                                     
REVDAT   1   04-AUG-05 2BYG    0                                                
JRNL        AUTH   J.M.ELKINS,E.PAPAGRIGORIOU,G.BERRIDGE,X.YANG,                
JRNL        AUTH 2 C.PHILLIPS,C.GILEADI,C.SAVITSKY,D.A.DOYLE                    
JRNL        TITL   STRUCTURE OF PICK1 AND OTHER PDZ DOMAINS OBTAINED            
JRNL        TITL 2 WITH THE HELP OF SELF-BINDING C-TERMINAL                     
JRNL        TITL 3 EXTENSIONS.                                                  
JRNL        REF    PROTEIN SCI.                  V.  16   683 2007              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  2BYG A  167   189  PDB    2BYG     2BYG           167    189             
DBREF  2BYG A  190   283  UNP    Q15700   DLG2_HUMAN     190    283             
SEQRES   1 A  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET THR VAL VAL          
SEQRES   3 A  117  GLU ILE LYS LEU PHE LYS GLY PRO LYS GLY LEU GLY PHE          
SEQRES   4 A  117  SER ILE ALA GLY GLY VAL GLY ASN GLN HIS ILE PRO GLY          
SEQRES   5 A  117  ASP ASN SER ILE TYR VAL THR LYS ILE ILE ASP GLY GLY          
SEQRES   6 A  117  ALA ALA GLN LYS ASP GLY ARG LEU GLN VAL GLY ASP ARG          
SEQRES   7 A  117  LEU LEU MET VAL ASN ASN TYR SER LEU GLU GLU VAL THR          
SEQRES   8 A  117  HIS GLU GLU ALA VAL ALA ILE LEU LYS ASN THR SER GLU          
SEQRES   9 A  117  VAL VAL TYR LEU LYS VAL GLY LYS PRO THR THR ILE TYR          
FORMUL   2  HOH   *100(H2 O1)                                                   
CRYST1   44.774   69.081   73.967  90.00  90.00  90.00 I 2 2 2       8          
ATOM      1  N   PHE A 186      19.115   9.714  29.180  1.00 52.07           N  
ATOM      2  CA  PHE A 186      18.413   8.568  28.525  1.00 52.38           C  
ATOM      3  C   PHE A 186      17.902   8.936  27.141  1.00 50.45           C  
ATOM      4  O   PHE A 186      17.918   8.095  26.257  1.00 47.29           O  
ATOM      5  CB  PHE A 186      17.244   8.068  29.379  1.00 52.15           C  
ATOM      6  CG  PHE A 186      16.653   6.768  28.899  1.00 49.64           C  
ATOM      7  N   GLN A 187      17.430  10.177  26.973  1.00 54.74           N  
ATOM      8  CA  GLN A 187      16.951  10.684  25.679  1.00 57.51           C  
ATOM      9  C   GLN A 187      17.859  11.800  25.152  1.00 57.47           C  
ATOM     10  O   GLN A 187      18.344  12.628  25.921  1.00 63.06           O  
ATOM     11  CB  GLN A 187      15.513  11.205  25.803  1.00 57.84           C  
ATOM     12  CG  GLN A 187      14.466  10.125  26.083  1.00 61.06           C  
ATOM     13  CD  GLN A 187      14.342   9.103  24.956  1.00 66.30           C  
ATOM     14  OE1 GLN A 187      14.555   7.902  25.168  1.00 59.41           O  
ATOM     15  NE2 GLN A 187      14.003   9.577  23.749  1.00 58.99           N  
ATOM     16  N   SER A 188      18.095  11.809  23.844  1.00 52.65           N  
ATOM     17  CA  SER A 188      18.928  12.834  23.210  1.00 52.39           C  
ATOM     18  C   SER A 188      18.400  13.121  21.794  1.00 49.50           C  
ATOM     19  O   SER A 188      17.294  12.689  21.458  1.00 47.51           O  
ATOM     20  CB  SER A 188      20.405  12.384  23.210  1.00 52.01           C  
ATOM     21  OG  SER A 188      21.199  13.148  22.312  1.00 61.06           O  
ATOM     22  N   MET A 189      19.167  13.856  20.988  1.00 48.87           N  
ATOM     23  CA  MET A 189      18.829  14.087  19.565  1.00 51.57           C  
ATOM     24  C   MET A 189      20.065  13.884  18.680  1.00 42.15           C  
ATOM     25  O   MET A 189      21.171  14.363  18.981  1.00 40.63           O  
ATOM     26  CB  MET A 189      18.264  15.497  19.370  1.00 50.86           C  
ATOM     27  CG  MET A 189      17.755  15.840  17.969  1.00 54.36           C  
ATOM     28  SD  MET A 189      17.025  17.514  17.886  1.00 66.57           S  
ATOM     29  CE  MET A 189      18.484  18.543  17.819  1.00 57.93           C  
ATOM     30  N   THR A 190      19.872  13.150  17.596  1.00 34.64           N  
ATOM     31  CA  THR A 190      20.916  12.978  16.590  1.00 35.54           C  
ATOM     32  C   THR A 190      20.544  13.831  15.387  1.00 37.57           C  
ATOM     33  O   THR A 190      19.431  13.735  14.898  1.00 36.06           O  
ATOM     34  CB  THR A 190      20.987  11.509  16.172  1.00 43.92           C  
ATOM     35  OG1 THR A 190      21.190  10.700  17.344  1.00 43.49           O  
ATOM     36  CG2 THR A 190      22.112  11.280  15.164  1.00 35.59           C  
ATOM     37  N   VAL A 191      21.466  14.670  14.932  1.00 32.90           N  
ATOM     38  CA  VAL A 191      21.219  15.550  13.802  1.00 36.12           C  
ATOM     39  C   VAL A 191      21.678  14.842  12.531  1.00 39.43           C  
ATOM     40  O   VAL A 191      22.807  14.339  12.450  1.00 33.20           O  
ATOM     41  CB  VAL A 191      21.920  16.916  13.994  1.00 37.02           C  
ATOM     42  CG1 VAL A 191      21.700  17.835  12.805  1.00 43.04           C  
ATOM     43  CG2 VAL A 191      21.436  17.573  15.325  1.00 45.02           C  
ATOM     44  N   VAL A 192      20.788  14.783  11.559  1.00 34.26           N  
ATOM     45  CA  VAL A 192      21.064  14.127  10.278  1.00 39.60           C  
ATOM     46  C   VAL A 192      20.638  15.015   9.115  1.00 35.46           C  
ATOM     47  O   VAL A 192      19.666  15.770   9.225  1.00 36.61           O  
ATOM     48  CB  VAL A 192      20.344  12.743  10.147  1.00 36.66           C  
ATOM     49  CG1 VAL A 192      20.897  11.733  11.148  1.00 44.57           C  
ATOM     50  CG2 VAL A 192      18.866  12.878  10.301  1.00 46.03           C  
ATOM     51  N   GLU A 193      21.381  14.922   8.018  1.00 35.84           N  
ATOM     52  CA  GLU A 193      21.046  15.600   6.783  1.00 38.86           C  
ATOM     53  C   GLU A 193      20.369  14.613   5.828  1.00 39.42           C  
ATOM     54  O   GLU A 193      20.861  13.518   5.599  1.00 41.40           O  
ATOM     55  CB  GLU A 193      22.295  16.190   6.118  1.00 39.79           C  
ATOM     56  CG  GLU A 193      22.973  17.322   6.897  1.00 39.00           C  
ATOM     57  CD  GLU A 193      22.076  18.561   7.131  1.00 38.83           C  
ATOM     58  OE1 GLU A 193      21.184  18.910   6.289  1.00 41.26           O  
ATOM     59  OE2 GLU A 193      22.319  19.203   8.164  1.00 51.73           O  
ATOM     60  N   ILE A 194      19.228  15.015   5.294  1.00 34.62           N  
ATOM     61  CA  ILE A 194      18.427  14.174   4.423  1.00 42.54           C  
ATOM     62  C   ILE A 194      18.141  15.012   3.176  1.00 42.98           C  
ATOM     63  O   ILE A 194      17.556  16.081   3.274  1.00 42.14           O  
ATOM     64  CB  ILE A 194      17.091  13.764   5.099  1.00 43.81           C  
ATOM     65  CG1 ILE A 194      17.357  12.899   6.342  1.00 44.08           C  
ATOM     66  CG2 ILE A 194      16.149  13.001   4.150  1.00 36.78           C  
ATOM     67  CD1 ILE A 194      16.104  12.667   7.180  1.00 49.06           C  
ATOM     68  N   LYS A 195      18.566  14.506   2.027  1.00 37.67           N  
ATOM     69  CA  LYS A 195      18.269  15.091   0.721  1.00 41.45           C  
ATOM     70  C   LYS A 195      17.140  14.339   0.048  1.00 38.96           C  
ATOM     71  O   LYS A 195      17.265  13.134  -0.215  1.00 33.72           O  
ATOM     72  CB  LYS A 195      19.515  15.012  -0.146  1.00 36.53           C  
ATOM     73  CG  LYS A 195      19.438  15.603  -1.551  1.00 36.48           C  
ATOM     74  CD  LYS A 195      20.588  14.972  -2.334  1.00 39.18           C  
ATOM     75  CE  LYS A 195      20.835  15.586  -3.668  1.00 59.82           C  
ATOM     76  NZ  LYS A 195      21.852  14.761  -4.388  1.00 46.54           N  
ATOM     77  N   LEU A 196      16.045  15.045  -0.240  1.00 35.53           N  
ATOM     78  CA  LEU A 196      14.920  14.456  -0.949  1.00 33.45           C  
ATOM     79  C   LEU A 196      14.690  15.110  -2.303  1.00 37.97           C  
ATOM     80  O   LEU A 196      14.905  16.308  -2.500  1.00 37.77           O  
ATOM     81  CB  LEU A 196      13.628  14.560  -0.139  1.00 33.14           C  
ATOM     82  CG  LEU A 196      13.523  13.822   1.198  1.00 35.17           C  
ATOM     83  CD1 LEU A 196      12.126  14.059   1.775  1.00 43.17           C  
ATOM     84  CD2 LEU A 196      13.808  12.336   1.050  1.00 39.68           C  
ATOM     85  N   PHE A 197      14.203  14.288  -3.221  1.00 38.44           N  
ATOM     86  CA  PHE A 197      13.834  14.714  -4.538  1.00 37.52           C  
ATOM     87  C   PHE A 197      12.311  14.649  -4.574  1.00 41.03           C  
ATOM     88  O   PHE A 197      11.721  13.575  -4.380  1.00 35.20           O  
ATOM     89  CB  PHE A 197      14.450  13.762  -5.568  1.00 37.71           C  
ATOM     90  CG  PHE A 197      15.955  13.715  -5.532  1.00 48.69           C  
ATOM     91  CD1 PHE A 197      16.621  12.652  -4.942  1.00 44.13           C  
ATOM     92  CD2 PHE A 197      16.702  14.733  -6.096  1.00 41.22           C  
ATOM     93  CE1 PHE A 197      18.017  12.611  -4.922  1.00 42.61           C  
ATOM     94  CE2 PHE A 197      18.087  14.691  -6.094  1.00 41.52           C  
ATOM     95  CZ  PHE A 197      18.747  13.629  -5.503  1.00 43.94           C  
ATOM     96  N   LYS A 198      11.669  15.788  -4.802  1.00 34.54           N  
ATOM     97  CA  LYS A 198      10.207  15.814  -4.888  1.00 41.78           C  
ATOM     98  C   LYS A 198       9.709  14.931  -5.990  1.00 41.80           C  
ATOM     99  O   LYS A 198      10.271  14.938  -7.077  1.00 40.39           O  
ATOM    100  CB  LYS A 198       9.680  17.213  -5.184  1.00 44.52           C  
ATOM    101  CG  LYS A 198       9.615  18.109  -4.032  1.00 50.91           C  
ATOM    102  CD  LYS A 198       8.727  19.273  -4.352  1.00 42.35           C  
ATOM    103  CE  LYS A 198       8.745  20.291  -3.257  1.00 41.45           C  
ATOM    104  NZ  LYS A 198       8.422  21.640  -3.784  1.00 45.04           N  
ATOM    105  N   GLY A 199       8.663  14.162  -5.696  1.00 45.09           N  
ATOM    106  CA  GLY A 199       7.879  13.459  -6.714  1.00 44.06           C  
ATOM    107  C   GLY A 199       6.743  14.362  -7.159  1.00 42.59           C  
ATOM    108  O   GLY A 199       6.632  15.487  -6.689  1.00 36.81           O  
ATOM    109  N   PRO A 200       5.889  13.885  -8.081  1.00 45.45           N  
ATOM    110  CA  PRO A 200       4.786  14.704  -8.561  1.00 47.22           C  
ATOM    111  C   PRO A 200       3.829  15.168  -7.454  1.00 51.74           C  
ATOM    112  O   PRO A 200       3.193  16.214  -7.595  1.00 53.36           O  
ATOM    113  CB  PRO A 200       4.055  13.776  -9.542  1.00 49.76           C  
ATOM    114  CG  PRO A 200       4.512  12.394  -9.193  1.00 55.38           C  
ATOM    115  CD  PRO A 200       5.922  12.568  -8.740  1.00 49.45           C  
ATOM    116  N   LYS A 201       3.744  14.402  -6.367  1.00 47.78           N  
ATOM    117  CA  LYS A 201       2.912  14.753  -5.228  1.00 45.35           C  
ATOM    118  C   LYS A 201       3.692  15.422  -4.073  1.00 43.23           C  
ATOM    119  O   LYS A 201       3.192  15.491  -2.959  1.00 44.65           O  
ATOM    120  CB  LYS A 201       2.200  13.493  -4.727  1.00 47.93           C  
ATOM    121  CG  LYS A 201       1.331  12.826  -5.791  1.00 54.53           C  
ATOM    122  CD  LYS A 201       0.680  11.532  -5.268  1.00 52.35           C  
ATOM    123  N   GLY A 202       4.907  15.904  -4.338  1.00 39.50           N  
ATOM    124  CA  GLY A 202       5.691  16.638  -3.351  1.00 36.28           C  
ATOM    125  C   GLY A 202       6.706  15.775  -2.604  1.00 35.63           C  
ATOM    126  O   GLY A 202       7.170  14.758  -3.105  1.00 35.57           O  
ATOM    127  N   LEU A 203       7.072  16.223  -1.405  1.00 38.24           N  
ATOM    128  CA  LEU A 203       8.084  15.525  -0.594  1.00 36.52           C  
ATOM    129  C   LEU A 203       7.497  14.275   0.085  1.00 33.12           C  
ATOM    130  O   LEU A 203       8.216  13.329   0.395  1.00 34.33           O  
ATOM    131  CB  LEU A 203       8.631  16.486   0.458  1.00 37.00           C  
ATOM    132  CG  LEU A 203       9.438  17.646  -0.133  1.00 37.13           C  
ATOM    133  CD1 LEU A 203       9.572  18.830   0.863  1.00 39.75           C  
ATOM    134  CD2 LEU A 203      10.798  17.124  -0.604  1.00 40.89           C  
ATOM    135  N   GLY A 204       6.179  14.302   0.323  1.00 33.68           N  
ATOM    136  CA  GLY A 204       5.447  13.190   0.920  1.00 34.28           C  
ATOM    137  C   GLY A 204       5.371  13.193   2.440  1.00 32.86           C  
ATOM    138  O   GLY A 204       5.436  12.131   3.054  1.00 37.10           O  
ATOM    139  N   PHE A 205       5.242  14.367   3.059  1.00 34.85           N  
ATOM    140  CA  PHE A 205       5.077  14.410   4.495  1.00 35.75           C  
ATOM    141  C   PHE A 205       4.305  15.652   4.948  1.00 35.24           C  
ATOM    142  O   PHE A 205       4.146  16.628   4.218  1.00 35.49           O  
ATOM    143  CB  PHE A 205       6.431  14.245   5.225  1.00 36.14           C  
ATOM    144  CG  PHE A 205       7.392  15.406   5.063  1.00 34.38           C  
ATOM    145  CD1 PHE A 205       7.319  16.514   5.919  1.00 34.68           C  
ATOM    146  CD2 PHE A 205       8.425  15.334   4.143  1.00 33.69           C  
ATOM    147  CE1 PHE A 205       8.218  17.577   5.777  1.00 40.91           C  
ATOM    148  CE2 PHE A 205       9.371  16.349   4.026  1.00 32.78           C  
ATOM    149  CZ  PHE A 205       9.249  17.495   4.849  1.00 40.47           C  
ATOM    150  N   SER A 206       3.821  15.577   6.169  1.00 35.07           N  
ATOM    151  CA  SER A 206       3.111  16.685   6.781  1.00 33.23           C  
ATOM    152  C   SER A 206       3.815  17.068   8.060  1.00 30.39           C  
ATOM    153  O   SER A 206       4.607  16.281   8.588  1.00 36.89           O  
ATOM    154  CB  SER A 206       1.674  16.275   7.070  1.00 37.19           C  
ATOM    155  OG  SER A 206       1.622  15.216   8.002  1.00 35.60           O  
ATOM    156  N   ILE A 207       3.509  18.273   8.546  1.00 37.11           N  
ATOM    157  CA  ILE A 207       4.167  18.829   9.731  1.00 37.34           C  
ATOM    158  C   ILE A 207       3.184  19.449  10.696  1.00 35.74           C  
ATOM    159  O   ILE A 207       2.081  19.821  10.314  1.00 32.82           O  
ATOM    160  CB  ILE A 207       5.208  19.915   9.367  1.00 35.06           C  
ATOM    161  CG1 ILE A 207       4.568  21.029   8.518  1.00 38.43           C  
ATOM    162  CG2 ILE A 207       6.390  19.270   8.648  1.00 36.69           C  
ATOM    163  CD1 ILE A 207       5.323  22.338   8.526  1.00 42.66           C  
ATOM    164  N   ALA A 208       3.615  19.559  11.947  1.00 36.57           N  
ATOM    165  CA  ALA A 208       2.873  20.305  12.944  1.00 38.95           C  
ATOM    166  C   ALA A 208       3.894  21.070  13.766  1.00 38.21           C  
ATOM    167  O   ALA A 208       5.099  20.764  13.725  1.00 36.28           O  
ATOM    168  CB  ALA A 208       2.030  19.356  13.830  1.00 40.73           C  
ATOM    169  N   GLY A 209       3.416  22.049  14.519  1.00 38.13           N  
ATOM    170  CA  GLY A 209       4.269  22.783  15.431  1.00 33.64           C  
ATOM    171  C   GLY A 209       4.455  24.212  15.017  1.00 37.08           C  
ATOM    172  O   GLY A 209       3.841  24.694  14.065  1.00 41.52           O  
ATOM    173  N   GLY A 210       5.308  24.900  15.759  1.00 37.71           N  
ATOM    174  CA  GLY A 210       5.577  26.302  15.514  1.00 41.61           C  
ATOM    175  C   GLY A 210       5.288  27.109  16.764  1.00 39.42           C  
ATOM    176  O   GLY A 210       4.569  26.651  17.672  1.00 44.81           O  
ATOM    177  N   VAL A 211       5.850  28.306  16.812  1.00 41.13           N  
ATOM    178  CA  VAL A 211       5.593  29.216  17.931  1.00 42.77           C  
ATOM    179  C   VAL A 211       4.126  29.631  17.818  1.00 43.84           C  
ATOM    180  O   VAL A 211       3.656  29.971  16.725  1.00 46.77           O  
ATOM    181  CB  VAL A 211       6.517  30.474  17.920  1.00 42.64           C  
ATOM    182  CG1 VAL A 211       7.988  30.102  17.884  1.00 46.60           C  
ATOM    183  CG2 VAL A 211       6.197  31.403  16.767  1.00 60.05           C  
ATOM    184  N   GLY A 212       3.400  29.584  18.931  1.00 43.75           N  
ATOM    185  CA  GLY A 212       1.976  29.914  18.949  1.00 44.68           C  
ATOM    186  C   GLY A 212       1.048  28.834  18.414  1.00 47.07           C  
ATOM    187  O   GLY A 212      -0.175  29.024  18.353  1.00 41.30           O  
ATOM    188  N   ASN A 213       1.620  27.698  18.019  1.00 47.42           N  
ATOM    189  CA  ASN A 213       0.842  26.592  17.501  1.00 48.42           C  
ATOM    190  C   ASN A 213       1.536  25.281  17.864  1.00 43.47           C  
ATOM    191  O   ASN A 213       1.723  24.410  17.013  1.00 48.31           O  
ATOM    192  CB  ASN A 213       0.677  26.756  15.987  1.00 52.40           C  
ATOM    193  CG  ASN A 213      -0.555  26.058  15.452  1.00 65.20           C  
ATOM    194  OD1 ASN A 213      -1.027  25.073  16.020  1.00 72.41           O  
ATOM    195  ND2 ASN A 213      -1.082  26.564  14.343  1.00 80.02           N  
ATOM    196  N   GLN A 214       1.911  25.156  19.139  1.00 40.00           N  
ATOM    197  CA  GLN A 214       2.836  24.109  19.599  1.00 38.94           C  
ATOM    198  C   GLN A 214       2.323  22.703  19.303  1.00 41.15           C  
ATOM    199  O   GLN A 214       1.179  22.394  19.615  1.00 43.06           O  
ATOM    200  CB  GLN A 214       3.105  24.226  21.100  1.00 39.99           C  
ATOM    201  CG  GLN A 214       3.834  25.490  21.500  1.00 38.97           C  
ATOM    202  CD  GLN A 214       4.162  25.522  22.975  1.00 46.57           C  
ATOM    203  OE1 GLN A 214       3.519  24.840  23.775  1.00 47.50           O  
ATOM    204  NE2 GLN A 214       5.173  26.305  23.345  1.00 38.39           N  
ATOM    205  N   HIS A 215       3.173  21.864  18.697  1.00 41.49           N  
ATOM    206  CA  HIS A 215       2.852  20.440  18.510  1.00 39.86           C  
ATOM    207  C   HIS A 215       2.864  19.756  19.865  1.00 41.49           C  
ATOM    208  O   HIS A 215       1.965  18.969  20.179  1.00 47.59           O  
ATOM    209  CB  HIS A 215       3.824  19.723  17.558  1.00 43.02           C  
ATOM    210  CG  HIS A 215       3.492  18.277  17.341  1.00 37.55           C  
ATOM    211  ND1 HIS A 215       2.224  17.850  17.013  1.00 38.81           N  
ATOM    212  CD2 HIS A 215       4.246  17.158  17.447  1.00 38.93           C  
ATOM    213  CE1 HIS A 215       2.219  16.533  16.888  1.00 43.81           C  
ATOM    214  NE2 HIS A 215       3.437  16.088  17.131  1.00 35.41           N  
ATOM    215  N   ILE A 216       3.864  20.085  20.671  1.00 39.49           N  
ATOM    216  CA  ILE A 216       4.061  19.476  21.987  1.00 36.87           C  
ATOM    217  C   ILE A 216       4.131  20.582  23.049  1.00 35.17           C  
ATOM    218  O   ILE A 216       4.790  21.602  22.842  1.00 37.82           O  
ATOM    219  CB  ILE A 216       5.376  18.641  22.016  1.00 39.65           C  
ATOM    220  CG1 ILE A 216       5.259  17.422  21.084  1.00 37.24           C  
ATOM    221  CG2 ILE A 216       5.719  18.207  23.443  1.00 41.28           C  
ATOM    222  CD1 ILE A 216       6.580  16.734  20.804  1.00 43.53           C  
ATOM    223  N   PRO A 217       3.430  20.401  24.179  1.00 40.76           N  
ATOM    224  CA  PRO A 217       3.513  21.416  25.232  1.00 42.21           C  
ATOM    225  C   PRO A 217       4.928  21.877  25.585  1.00 40.70           C  
ATOM    226  O   PRO A 217       5.816  21.056  25.888  1.00 36.67           O  
ATOM    227  CB  PRO A 217       2.838  20.732  26.420  1.00 42.44           C  
ATOM    228  CG  PRO A 217       1.783  19.910  25.776  1.00 45.37           C  
ATOM    229  CD  PRO A 217       2.456  19.353  24.527  1.00 41.44           C  
ATOM    230  N   GLY A 218       5.119  23.196  25.511  1.00 40.54           N  
ATOM    231  CA  GLY A 218       6.361  23.833  25.900  1.00 46.01           C  
ATOM    232  C   GLY A 218       7.415  23.828  24.821  1.00 44.45           C  
ATOM    233  O   GLY A 218       8.514  24.290  25.054  1.00 42.33           O  
ATOM    234  N   ASP A 219       7.069  23.322  23.636  1.00 46.97           N  
ATOM    235  CA  ASP A 219       8.033  23.056  22.578  1.00 44.22           C  
ATOM    236  C   ASP A 219       7.524  23.657  21.269  1.00 42.90           C  
ATOM    237  O   ASP A 219       6.467  23.264  20.778  1.00 40.32           O  
ATOM    238  CB  ASP A 219       8.216  21.540  22.446  1.00 45.27           C  
ATOM    239  CG  ASP A 219       9.227  21.148  21.373  1.00 52.37           C  
ATOM    240  OD1 ASP A 219       9.602  22.005  20.552  1.00 46.25           O  
ATOM    241  OD2 ASP A 219       9.649  19.969  21.361  1.00 42.45           O  
ATOM    242  N   ASN A 220       8.285  24.602  20.714  1.00 39.95           N  
ATOM    243  CA  ASN A 220       7.878  25.358  19.530  1.00 38.92           C  
ATOM    244  C   ASN A 220       8.372  24.756  18.208  1.00 38.47           C  
ATOM    245  O   ASN A 220       8.097  25.304  17.134  1.00 38.32           O  
ATOM    246  CB  ASN A 220       8.348  26.813  19.645  1.00 38.22           C  
ATOM    247  CG  ASN A 220       7.635  27.585  20.749  1.00 36.58           C  
ATOM    248  OD1 ASN A 220       6.471  27.315  21.070  1.00 50.01           O  
ATOM    249  ND2 ASN A 220       8.330  28.560  21.329  1.00 39.23           N  
ATOM    250  N   SER A 221       9.100  23.640  18.292  1.00 33.52           N  
ATOM    251  CA  SER A 221       9.731  23.040  17.132  1.00 38.67           C  
ATOM    252  C   SER A 221       8.728  22.510  16.133  1.00 38.45           C  
ATOM    253  O   SER A 221       7.579  22.196  16.463  1.00 35.38           O  
ATOM    254  CB  SER A 221      10.627  21.869  17.524  1.00 41.76           C  
ATOM    255  OG  SER A 221      11.601  22.247  18.467  1.00 47.84           O  
ATOM    256  N   ILE A 222       9.217  22.357  14.909  1.00 40.99           N  
ATOM    257  CA  ILE A 222       8.444  21.823  13.822  1.00 37.49           C  
ATOM    258  C   ILE A 222       8.687  20.321  13.747  1.00 38.04           C  
ATOM    259  O   ILE A 222       9.828  19.875  13.724  1.00 39.34           O  
ATOM    260  CB  ILE A 222       8.877  22.455  12.495  1.00 39.15           C  
ATOM    261  CG1 ILE A 222       8.778  23.997  12.578  1.00 38.52           C  
ATOM    262  CG2 ILE A 222       8.028  21.876  11.354  1.00 32.59           C  
ATOM    263  CD1 ILE A 222       7.345  24.517  12.734  1.00 41.48           C  
ATOM    264  N   TYR A 223       7.599  19.550  13.711  1.00 31.75           N  
ATOM    265  CA  TYR A 223       7.679  18.080  13.713  1.00 33.32           C  
ATOM    266  C   TYR A 223       7.001  17.478  12.519  1.00 35.26           C  
ATOM    267  O   TYR A 223       5.938  17.961  12.101  1.00 33.62           O  
ATOM    268  CB  TYR A 223       7.005  17.503  14.953  1.00 34.60           C  
ATOM    269  CG  TYR A 223       7.810  17.714  16.205  1.00 35.63           C  
ATOM    270  CD1 TYR A 223       7.612  18.832  16.988  1.00 38.79           C  
ATOM    271  CD2 TYR A 223       8.783  16.803  16.580  1.00 41.89           C  
ATOM    272  CE1 TYR A 223       8.336  19.040  18.120  1.00 38.57           C  
ATOM    273  CE2 TYR A 223       9.522  16.998  17.721  1.00 45.30           C  
ATOM    274  CZ  TYR A 223       9.299  18.122  18.485  1.00 39.51           C  
ATOM    275  OH  TYR A 223      10.046  18.331  19.619  1.00 44.19           O  
ATOM    276  N   VAL A 224       7.581  16.391  12.023  1.00 35.04           N  
ATOM    277  CA  VAL A 224       6.947  15.546  10.992  1.00 34.60           C  
ATOM    278  C   VAL A 224       5.825  14.721  11.642  1.00 37.36           C  
ATOM    279  O   VAL A 224       6.047  14.061  12.663  1.00 34.15           O  
ATOM    280  CB  VAL A 224       8.008  14.620  10.309  1.00 36.11           C  
ATOM    281  CG1 VAL A 224       7.349  13.695   9.306  1.00 37.64           C  
ATOM    282  CG2 VAL A 224       9.098  15.464   9.642  1.00 39.47           C  
ATOM    283  N   THR A 225       4.602  14.822  11.104  1.00 34.88           N  
ATOM    284  CA  THR A 225       3.447  14.156  11.701  1.00 37.17           C  
ATOM    285  C   THR A 225       2.929  12.965  10.902  1.00 37.23           C  
ATOM    286  O   THR A 225       2.289  12.078  11.469  1.00 34.44           O  
ATOM    287  CB  THR A 225       2.306  15.152  11.970  1.00 38.47           C  
ATOM    288  OG1 THR A 225       1.987  15.858  10.771  1.00 35.65           O  
ATOM    289  CG2 THR A 225       2.716  16.154  13.072  1.00 39.71           C  
ATOM    290  N   LYS A 226       3.217  12.934   9.601  1.00 37.65           N  
ATOM    291  CA  LYS A 226       2.830  11.820   8.748  1.00 39.86           C  
ATOM    292  C   LYS A 226       3.801  11.695   7.598  1.00 36.52           C  
ATOM    293  O   LYS A 226       4.326  12.704   7.109  1.00 36.29           O  
ATOM    294  CB  LYS A 226       1.433  12.061   8.197  1.00 36.34           C  
ATOM    295  CG  LYS A 226       0.751  10.832   7.594  1.00 44.63           C  
ATOM    296  CD  LYS A 226      -0.681  11.171   7.135  1.00 48.63           C  
ATOM    297  CE  LYS A 226      -1.697  10.083   7.515  1.00 60.61           C  
ATOM    298  NZ  LYS A 226      -1.252   8.693   7.192  1.00 53.33           N  
ATOM    299  N   ILE A 227       4.049  10.455   7.184  1.00 34.90           N  
ATOM    300  CA  ILE A 227       4.882  10.155   6.013  1.00 32.93           C  
ATOM    301  C   ILE A 227       4.022   9.316   5.064  1.00 38.89           C  
ATOM    302  O   ILE A 227       3.597   8.218   5.405  1.00 41.20           O  
ATOM    303  CB  ILE A 227       6.185   9.445   6.396  1.00 37.08           C  
ATOM    304  CG1 ILE A 227       7.180  10.474   6.945  1.00 46.35           C  
ATOM    305  CG2 ILE A 227       6.771   8.739   5.196  1.00 41.69           C  
ATOM    306  CD1 ILE A 227       8.316   9.903   7.698  1.00 50.65           C  
ATOM    307  N   ILE A 228       3.752   9.875   3.894  1.00 40.07           N  
ATOM    308  CA  ILE A 228       2.857   9.285   2.916  1.00 41.95           C  
ATOM    309  C   ILE A 228       3.436   8.041   2.294  1.00 39.71           C  
ATOM    310  O   ILE A 228       4.533   8.064   1.727  1.00 37.13           O  
ATOM    311  CB  ILE A 228       2.486  10.337   1.830  1.00 42.49           C  
ATOM    312  CG1 ILE A 228       1.667  11.469   2.471  1.00 48.76           C  
ATOM    313  CG2 ILE A 228       1.704   9.710   0.673  1.00 50.06           C  
ATOM    314  CD1 ILE A 228       0.502  10.994   3.320  1.00 55.80           C  
ATOM    315  N   ASP A 229       2.690   6.939   2.379  1.00 40.52           N  
ATOM    316  CA  ASP A 229       3.144   5.717   1.734  1.00 42.54           C  
ATOM    317  C   ASP A 229       3.339   5.925   0.235  1.00 34.91           C  
ATOM    318  O   ASP A 229       2.489   6.494  -0.425  1.00 40.58           O  
ATOM    319  CB  ASP A 229       2.179   4.559   1.975  1.00 42.69           C  
ATOM    320  CG  ASP A 229       2.688   3.246   1.389  1.00 49.95           C  
ATOM    321  OD1 ASP A 229       3.917   3.085   1.226  1.00 56.45           O  
ATOM    322  OD2 ASP A 229       1.854   2.369   1.086  1.00 68.10           O  
ATOM    323  N   GLY A 230       4.481   5.463  -0.274  1.00 36.26           N  
ATOM    324  CA  GLY A 230       4.850   5.588  -1.678  1.00 36.21           C  
ATOM    325  C   GLY A 230       5.512   6.901  -2.040  1.00 37.23           C  
ATOM    326  O   GLY A 230       5.944   7.082  -3.196  1.00 37.05           O  
ATOM    327  N   GLY A 231       5.587   7.823  -1.073  1.00 31.64           N  
ATOM    328  CA  GLY A 231       6.045   9.185  -1.339  1.00 32.37           C  
ATOM    329  C   GLY A 231       7.540   9.252  -1.229  1.00 30.27           C  
ATOM    330  O   GLY A 231       8.160   8.296  -0.751  1.00 33.18           O  
ATOM    331  N   ALA A 232       8.122  10.378  -1.659  1.00 37.63           N  
ATOM    332  CA  ALA A 232       9.584  10.542  -1.726  1.00 38.86           C  
ATOM    333  C   ALA A 232      10.248  10.267  -0.402  1.00 34.23           C  
ATOM    334  O   ALA A 232      11.240   9.568  -0.349  1.00 35.26           O  
ATOM    335  CB  ALA A 232       9.975  11.959  -2.228  1.00 38.98           C  
ATOM    336  N   ALA A 233       9.699  10.838   0.664  1.00 34.93           N  
ATOM    337  CA  ALA A 233      10.234  10.688   2.009  1.00 35.20           C  
ATOM    338  C   ALA A 233      10.210   9.244   2.488  1.00 37.93           C  
ATOM    339  O   ALA A 233      11.204   8.779   3.063  1.00 36.72           O  
ATOM    340  CB  ALA A 233       9.462  11.602   2.989  1.00 33.92           C  
ATOM    341  N   GLN A 234       9.091   8.550   2.238  1.00 43.11           N  
ATOM    342  CA  GLN A 234       8.931   7.114   2.576  1.00 37.50           C  
ATOM    343  C   GLN A 234       9.927   6.295   1.777  1.00 38.83           C  
ATOM    344  O   GLN A 234      10.681   5.528   2.355  1.00 37.97           O  
ATOM    345  CB  GLN A 234       7.495   6.614   2.305  1.00 38.49           C  
ATOM    346  CG  GLN A 234       7.230   5.133   2.654  1.00 43.61           C  
ATOM    347  CD  GLN A 234       7.427   4.185   1.474  1.00 34.65           C  
ATOM    348  OE1 GLN A 234       6.990   4.470   0.360  1.00 42.16           O  
ATOM    349  NE2 GLN A 234       8.073   3.050   1.715  1.00 41.35           N  
ATOM    350  N   LYS A 235       9.946   6.469   0.454  1.00 39.18           N  
ATOM    351  CA  LYS A 235      10.848   5.657  -0.390  1.00 36.38           C  
ATOM    352  C   LYS A 235      12.307   5.861   0.017  1.00 40.17           C  
ATOM    353  O   LYS A 235      13.085   4.906   0.039  1.00 37.18           O  
ATOM    354  CB  LYS A 235      10.681   5.985  -1.873  1.00 37.70           C  
ATOM    355  CG  LYS A 235       9.528   5.279  -2.562  1.00 40.10           C  
ATOM    356  CD  LYS A 235       9.203   5.995  -3.866  1.00 48.92           C  
ATOM    357  CE  LYS A 235       8.603   5.087  -4.917  1.00 56.11           C  
ATOM    358  NZ  LYS A 235       8.574   5.820  -6.215  1.00 61.60           N  
ATOM    359  N   ASP A 236      12.683   7.107   0.321  1.00 40.33           N  
ATOM    360  CA  ASP A 236      14.048   7.416   0.766  1.00 43.53           C  
ATOM    361  C   ASP A 236      14.401   6.659   2.047  1.00 44.26           C  
ATOM    362  O   ASP A 236      15.538   6.229   2.221  1.00 47.31           O  
ATOM    363  CB  ASP A 236      14.248   8.922   0.958  1.00 40.73           C  
ATOM    364  CG  ASP A 236      15.600   9.254   1.551  1.00 42.10           C  
ATOM    365  OD1 ASP A 236      15.678   9.415   2.784  1.00 39.08           O  
ATOM    366  OD2 ASP A 236      16.582   9.307   0.777  1.00 47.66           O  
ATOM    367  N   GLY A 237      13.444   6.519   2.947  1.00 46.01           N  
ATOM    368  CA  GLY A 237      13.602   5.621   4.089  1.00 45.56           C  
ATOM    369  C   GLY A 237      14.044   6.270   5.379  1.00 42.29           C  
ATOM    370  O   GLY A 237      13.826   5.709   6.441  1.00 46.76           O  
ATOM    371  N   ARG A 238      14.614   7.472   5.301  1.00 40.22           N  
ATOM    372  CA  ARG A 238      15.271   8.117   6.434  1.00 37.35           C  
ATOM    373  C   ARG A 238      14.364   8.934   7.354  1.00 39.56           C  
ATOM    374  O   ARG A 238      14.431   8.815   8.565  1.00 39.84           O  
ATOM    375  CB  ARG A 238      16.445   8.976   5.937  1.00 44.79           C  
ATOM    376  CG  ARG A 238      17.570   8.153   5.309  1.00 37.34           C  
ATOM    377  CD  ARG A 238      18.722   9.020   4.794  1.00 45.63           C  
ATOM    378  NE  ARG A 238      18.419   9.680   3.517  1.00 44.03           N  
ATOM    379  CZ  ARG A 238      19.210  10.585   2.940  1.00 40.97           C  
ATOM    380  NH1 ARG A 238      20.377  10.914   3.486  1.00 40.39           N  
ATOM    381  NH2 ARG A 238      18.856  11.138   1.788  1.00 39.36           N  
ATOM    382  N   LEU A 239      13.513   9.780   6.791  1.00 39.43           N  
ATOM    383  CA  LEU A 239      12.659  10.626   7.614  1.00 38.08           C  
ATOM    384  C   LEU A 239      11.633   9.743   8.356  1.00 35.69           C  
ATOM    385  O   LEU A 239      11.138   8.760   7.791  1.00 40.58           O  
ATOM    386  CB  LEU A 239      11.928  11.640   6.724  1.00 37.03           C  
ATOM    387  CG  LEU A 239      11.312  12.850   7.412  1.00 44.04           C  
ATOM    388  CD1 LEU A 239      12.437  13.803   7.920  1.00 39.21           C  
ATOM    389  CD2 LEU A 239      10.374  13.547   6.476  1.00 44.77           C  
ATOM    390  N   GLN A 240      11.319  10.114   9.597  1.00 40.00           N  
ATOM    391  CA  GLN A 240      10.377   9.367  10.439  1.00 42.31           C  
ATOM    392  C   GLN A 240       9.405  10.294  11.161  1.00 41.09           C  
ATOM    393  O   GLN A 240       9.725  11.451  11.470  1.00 37.64           O  
ATOM    394  CB  GLN A 240      11.135   8.519  11.471  1.00 39.21           C  
ATOM    395  CG  GLN A 240      12.026   7.424  10.858  1.00 50.58           C  
ATOM    396  CD  GLN A 240      11.242   6.412  10.010  1.00 63.98           C  
ATOM    397  OE1 GLN A 240      10.085   6.109  10.296  1.00 74.20           O  
ATOM    398  NE2 GLN A 240      11.875   5.897   8.960  1.00 52.92           N  
ATOM    399  N   VAL A 241       8.202   9.785  11.424  1.00 39.67           N  
ATOM    400  CA  VAL A 241       7.220  10.550  12.177  1.00 41.10           C  
ATOM    401  C   VAL A 241       7.839  10.828  13.547  1.00 37.97           C  
ATOM    402  O   VAL A 241       8.479   9.953  14.131  1.00 36.40           O  
ATOM    403  CB  VAL A 241       5.877   9.792  12.335  1.00 40.16           C  
ATOM    404  CG1 VAL A 241       4.961  10.516  13.317  1.00 41.33           C  
ATOM    405  CG2 VAL A 241       5.202   9.623  10.973  1.00 34.86           C  
ATOM    406  N   GLY A 242       7.638  12.044  14.041  1.00 38.59           N  
ATOM    407  CA  GLY A 242       8.200  12.479  15.305  1.00 37.41           C  
ATOM    408  C   GLY A 242       9.543  13.180  15.205  1.00 36.25           C  
ATOM    409  O   GLY A 242      10.013  13.724  16.199  1.00 37.56           O  
ATOM    410  N   ASP A 243      10.166  13.149  14.028  1.00 35.60           N  
ATOM    411  CA  ASP A 243      11.449  13.824  13.782  1.00 35.46           C  
ATOM    412  C   ASP A 243      11.226  15.323  13.759  1.00 34.83           C  
ATOM    413  O   ASP A 243      10.207  15.808  13.300  1.00 37.27           O  
ATOM    414  CB  ASP A 243      12.047  13.421  12.416  1.00 36.75           C  
ATOM    415  CG  ASP A 243      12.691  12.052  12.406  1.00 33.97           C  
ATOM    416  OD1 ASP A 243      12.877  11.425  13.474  1.00 38.87           O  
ATOM    417  OD2 ASP A 243      13.023  11.598  11.283  1.00 45.19           O  
ATOM    418  N   ARG A 244      12.193  16.066  14.277  1.00 34.98           N  
ATOM    419  CA  ARG A 244      12.166  17.515  14.251  1.00 37.60           C  
ATOM    420  C   ARG A 244      12.823  18.031  12.966  1.00 39.46           C  
ATOM    421  O   ARG A 244      13.904  17.583  12.606  1.00 40.07           O  
ATOM    422  CB  ARG A 244      12.926  18.037  15.455  1.00 36.32           C  
ATOM    423  CG  ARG A 244      12.657  19.443  15.865  1.00 50.78           C  
ATOM    424  CD  ARG A 244      13.563  19.829  17.036  1.00 50.60           C  
ATOM    425  NE  ARG A 244      13.189  19.153  18.276  1.00 52.46           N  
ATOM    426  CZ  ARG A 244      13.824  19.302  19.440  1.00 67.90           C  
ATOM    427  NH1 ARG A 244      14.886  20.106  19.537  1.00 59.61           N  
ATOM    428  NH2 ARG A 244      13.402  18.642  20.513  1.00 60.39           N  
ATOM    429  N   LEU A 245      12.133  18.927  12.268  1.00 36.18           N  
ATOM    430  CA  LEU A 245      12.703  19.681  11.151  1.00 35.59           C  
ATOM    431  C   LEU A 245      13.409  20.927  11.629  1.00 32.74           C  
ATOM    432  O   LEU A 245      12.793  21.862  12.125  1.00 36.24           O  
ATOM    433  CB  LEU A 245      11.631  20.072  10.136  1.00 40.52           C  
ATOM    434  CG  LEU A 245      10.888  18.915   9.492  1.00 49.87           C  
ATOM    435  CD1 LEU A 245      10.027  19.490   8.377  1.00 57.12           C  
ATOM    436  CD2 LEU A 245      11.852  17.841   8.953  1.00 45.44           C  
ATOM    437  N   LEU A 246      14.707  20.962  11.403  1.00 36.83           N  
ATOM    438  CA  LEU A 246      15.543  22.021  11.916  1.00 34.92           C  
ATOM    439  C   LEU A 246      15.869  23.118  10.905  1.00 37.11           C  
ATOM    440  O   LEU A 246      16.040  24.271  11.288  1.00 32.24           O  
ATOM    441  CB  LEU A 246      16.841  21.400  12.412  1.00 32.19           C  
ATOM    442  CG  LEU A 246      16.646  20.436  13.586  1.00 37.83           C  
ATOM    443  CD1 LEU A 246      17.954  19.709  13.867  1.00 38.44           C  
ATOM    444  CD2 LEU A 246      16.148  21.172  14.811  1.00 49.20           C  
ATOM    445  N   MET A 247      16.032  22.738   9.647  1.00 32.49           N  
ATOM    446  CA  MET A 247      16.423  23.653   8.596  1.00 30.17           C  
ATOM    447  C   MET A 247      16.041  23.052   7.254  1.00 31.75           C  
ATOM    448  O   MET A 247      16.097  21.820   7.085  1.00 34.12           O  
ATOM    449  CB  MET A 247      17.930  23.850   8.576  1.00 32.24           C  
ATOM    450  CG  MET A 247      18.384  25.108   7.853  1.00 40.77           C  
ATOM    451  SD  MET A 247      20.149  25.332   8.042  1.00 45.73           S  
ATOM    452  CE  MET A 247      20.246  25.764   9.769  1.00 52.41           C  
ATOM    453  N   VAL A 248      15.701  23.924   6.309  1.00 33.03           N  
ATOM    454  CA  VAL A 248      15.351  23.505   4.949  1.00 32.91           C  
ATOM    455  C   VAL A 248      16.071  24.452   4.014  1.00 33.85           C  
ATOM    456  O   VAL A 248      15.825  25.656   4.057  1.00 34.33           O  
ATOM    457  CB  VAL A 248      13.832  23.594   4.645  1.00 35.23           C  
ATOM    458  CG1 VAL A 248      13.543  23.176   3.193  1.00 36.89           C  
ATOM    459  CG2 VAL A 248      12.993  22.780   5.655  1.00 39.49           C  
ATOM    460  N   ASN A 249      17.030  23.928   3.262  1.00 32.89           N  
ATOM    461  CA  ASN A 249      17.748  24.701   2.240  1.00 33.37           C  
ATOM    462  C   ASN A 249      18.245  26.046   2.784  1.00 33.40           C  
ATOM    463  O   ASN A 249      18.023  27.117   2.182  1.00 31.17           O  
ATOM    464  CB  ASN A 249      16.851  24.910   1.016  1.00 32.24           C  
ATOM    465  CG  ASN A 249      16.591  23.627   0.252  1.00 34.11           C  
ATOM    466  OD1 ASN A 249      17.308  22.618   0.416  1.00 35.64           O  
ATOM    467  ND2 ASN A 249      15.594  23.673  -0.628  1.00 38.24           N  
ATOM    468  N   ASN A 250      18.937  25.947   3.919  1.00 32.68           N  
ATOM    469  CA  ASN A 250      19.503  27.068   4.656  1.00 31.76           C  
ATOM    470  C   ASN A 250      18.518  27.907   5.496  1.00 31.82           C  
ATOM    471  O   ASN A 250      18.956  28.808   6.219  1.00 36.33           O  
ATOM    472  CB  ASN A 250      20.317  28.021   3.742  1.00 32.12           C  
ATOM    473  CG  ASN A 250      21.473  27.350   3.056  1.00 37.47           C  
ATOM    474  OD1 ASN A 250      22.004  26.359   3.543  1.00 34.62           O  
ATOM    475  ND2 ASN A 250      21.888  27.904   1.907  1.00 31.09           N  
ATOM    476  N   TYR A 251      17.217  27.677   5.358  1.00 35.25           N  
ATOM    477  CA  TYR A 251      16.213  28.409   6.121  1.00 36.47           C  
ATOM    478  C   TYR A 251      15.967  27.694   7.453  1.00 38.25           C  
ATOM    479  O   TYR A 251      15.564  26.531   7.481  1.00 34.24           O  
ATOM    480  CB  TYR A 251      14.914  28.522   5.329  1.00 37.11           C  
ATOM    481  CG  TYR A 251      14.997  29.430   4.136  1.00 40.00           C  
ATOM    482  CD1 TYR A 251      15.252  28.923   2.873  1.00 50.70           C  
ATOM    483  CD2 TYR A 251      14.820  30.807   4.275  1.00 42.27           C  
ATOM    484  CE1 TYR A 251      15.334  29.762   1.772  1.00 47.21           C  
ATOM    485  CE2 TYR A 251      14.905  31.652   3.173  1.00 47.72           C  
ATOM    486  CZ  TYR A 251      15.151  31.110   1.928  1.00 40.28           C  
ATOM    487  OH  TYR A 251      15.238  31.924   0.835  1.00 51.85           O  
ATOM    488  N   SER A 252      16.240  28.385   8.552  1.00 34.82           N  
ATOM    489  CA  SER A 252      16.039  27.836   9.891  1.00 35.14           C  
ATOM    490  C   SER A 252      14.554  27.711  10.241  1.00 31.16           C  
ATOM    491  O   SER A 252      13.745  28.597   9.955  1.00 37.65           O  
ATOM    492  CB  SER A 252      16.734  28.720  10.933  1.00 41.90           C  
ATOM    493  OG  SER A 252      16.453  28.268  12.246  1.00 41.83           O  
ATOM    494  N   LEU A 253      14.213  26.591  10.860  1.00 37.09           N  
ATOM    495  CA  LEU A 253      12.894  26.388  11.429  1.00 36.56           C  
ATOM    496  C   LEU A 253      12.960  26.409  12.952  1.00 37.59           C  
ATOM    497  O   LEU A 253      12.096  25.847  13.615  1.00 38.74           O  
ATOM    498  CB  LEU A 253      12.323  25.055  10.958  1.00 36.68           C  
ATOM    499  CG  LEU A 253      12.169  24.894   9.443  1.00 38.91           C  
ATOM    500  CD1 LEU A 253      11.818  23.472   9.123  1.00 53.10           C  
ATOM    501  CD2 LEU A 253      11.114  25.813   8.949  1.00 43.05           C  
ATOM    502  N   GLU A 254      13.969  27.074  13.493  1.00 42.37           N  
ATOM    503  CA  GLU A 254      14.078  27.279  14.928  1.00 46.16           C  
ATOM    504  C   GLU A 254      13.223  28.467  15.325  1.00 42.67           C  
ATOM    505  O   GLU A 254      13.452  29.576  14.844  1.00 43.36           O  
ATOM    506  CB  GLU A 254      15.531  27.567  15.317  1.00 48.11           C  
ATOM    507  CG  GLU A 254      15.772  27.559  16.827  1.00 56.13           C  
ATOM    508  CD  GLU A 254      17.052  28.269  17.218  1.00 59.76           C  
ATOM    509  OE1 GLU A 254      17.109  29.509  17.070  1.00 76.06           O  
ATOM    510  OE2 GLU A 254      17.993  27.590  17.684  1.00 78.60           O  
ATOM    511  N   GLU A 255      12.249  28.234  16.202  1.00 39.55           N  
ATOM    512  CA  GLU A 255      11.389  29.291  16.730  1.00 42.42           C  
ATOM    513  C   GLU A 255      10.715  30.090  15.611  1.00 42.42           C  
ATOM    514  O   GLU A 255      10.758  31.321  15.573  1.00 44.91           O  
ATOM    515  CB  GLU A 255      12.169  30.211  17.680  1.00 49.09           C  
ATOM    516  CG  GLU A 255      12.775  29.492  18.883  1.00 55.18           C  
ATOM    517  CD  GLU A 255      11.728  28.795  19.756  1.00 56.52           C  
ATOM    518  OE1 GLU A 255      10.662  29.393  20.024  1.00 52.25           O  
ATOM    519  OE2 GLU A 255      11.977  27.640  20.168  1.00 56.77           O  
ATOM    520  N   VAL A 256      10.085  29.363  14.703  1.00 39.52           N  
ATOM    521  CA  VAL A 256       9.298  29.972  13.645  1.00 40.45           C  
ATOM    522  C   VAL A 256       7.850  29.660  13.905  1.00 38.95           C  
ATOM    523  O   VAL A 256       7.542  28.751  14.667  1.00 36.05           O  
ATOM    524  CB  VAL A 256       9.704  29.457  12.250  1.00 37.40           C  
ATOM    525  CG1 VAL A 256      11.155  29.787  11.970  1.00 44.41           C  
ATOM    526  CG2 VAL A 256       9.465  27.940  12.121  1.00 38.00           C  
ATOM    527  N   THR A 257       6.966  30.434  13.285  1.00 38.87           N  
ATOM    528  CA  THR A 257       5.559  30.116  13.284  1.00 36.61           C  
ATOM    529  C   THR A 257       5.298  28.968  12.323  1.00 45.03           C  
ATOM    530  O   THR A 257       6.137  28.684  11.431  1.00 36.18           O  
ATOM    531  CB  THR A 257       4.719  31.336  12.860  1.00 44.68           C  
ATOM    532  OG1 THR A 257       5.045  31.700  11.513  1.00 40.56           O  
ATOM    533  CG2 THR A 257       4.987  32.518  13.774  1.00 50.26           C  
ATOM    534  N   HIS A 258       4.145  28.313  12.492  1.00 42.95           N  
ATOM    535  CA  HIS A 258       3.719  27.273  11.571  1.00 44.70           C  
ATOM    536  C   HIS A 258       3.689  27.829  10.152  1.00 47.18           C  
ATOM    537  O   HIS A 258       4.200  27.193   9.213  1.00 44.27           O  
ATOM    538  CB  HIS A 258       2.350  26.687  11.961  1.00 42.39           C  
ATOM    539  CG  HIS A 258       1.986  25.463  11.177  1.00 40.87           C  
ATOM    540  ND1 HIS A 258       2.544  24.227  11.425  1.00 41.59           N  
ATOM    541  CD2 HIS A 258       1.154  25.296  10.122  1.00 43.90           C  
ATOM    542  CE1 HIS A 258       2.066  23.349  10.561  1.00 44.08           C  
ATOM    543  NE2 HIS A 258       1.225  23.974   9.754  1.00 41.93           N  
ATOM    544  N   GLU A 259       3.136  29.034  10.009  1.00 43.79           N  
ATOM    545  CA  GLU A 259       3.009  29.691   8.700  1.00 47.74           C  
ATOM    546  C   GLU A 259       4.370  29.997   8.051  1.00 41.99           C  
ATOM    547  O   GLU A 259       4.517  29.904   6.833  1.00 42.66           O  
ATOM    548  CB  GLU A 259       2.189  30.982   8.826  1.00 48.90           C  
ATOM    549  CG  GLU A 259       0.706  30.760   9.158  1.00 61.76           C  
ATOM    550  CD  GLU A 259       0.448  30.281  10.599  1.00 72.97           C  
ATOM    551  OE1 GLU A 259       1.075  30.816  11.542  1.00 64.75           O  
ATOM    552  OE2 GLU A 259      -0.387  29.364  10.784  1.00 73.31           O  
ATOM    553  N   GLU A 260       5.364  30.356   8.863  1.00 43.35           N  
ATOM    554  CA  GLU A 260       6.715  30.581   8.350  1.00 44.31           C  
ATOM    555  C   GLU A 260       7.294  29.271   7.814  1.00 47.16           C  
ATOM    556  O   GLU A 260       7.817  29.234   6.701  1.00 46.40           O  
ATOM    557  CB  GLU A 260       7.616  31.201   9.423  1.00 44.26           C  
ATOM    558  CG  GLU A 260       7.489  32.746   9.483  1.00 52.14           C  
ATOM    559  CD  GLU A 260       7.956  33.376  10.789  1.00 53.77           C  
ATOM    560  OE1 GLU A 260       8.445  32.664  11.683  1.00 48.37           O  
ATOM    561  OE2 GLU A 260       7.810  34.612  10.930  1.00 64.73           O  
ATOM    562  N   ALA A 261       7.181  28.211   8.619  1.00 43.02           N  
ATOM    563  CA  ALA A 261       7.514  26.837   8.210  1.00 42.62           C  
ATOM    564  C   ALA A 261       6.868  26.405   6.891  1.00 39.49           C  
ATOM    565  O   ALA A 261       7.520  25.862   5.997  1.00 40.43           O  
ATOM    566  CB  ALA A 261       7.105  25.853   9.310  1.00 42.99           C  
ATOM    567  N   VAL A 262       5.564  26.602   6.808  1.00 40.71           N  
ATOM    568  CA  VAL A 262       4.801  26.174   5.663  1.00 37.99           C  
ATOM    569  C   VAL A 262       5.287  26.889   4.400  1.00 38.29           C  
ATOM    570  O   VAL A 262       5.499  26.237   3.375  1.00 40.96           O  
ATOM    571  CB  VAL A 262       3.294  26.410   5.888  1.00 42.25           C  
ATOM    572  CG1 VAL A 262       2.536  26.370   4.565  1.00 41.63           C  
ATOM    573  CG2 VAL A 262       2.757  25.353   6.894  1.00 38.34           C  
ATOM    574  N   ALA A 263       5.480  28.206   4.507  1.00 39.24           N  
ATOM    575  CA  ALA A 263       6.022  29.020   3.405  1.00 40.64           C  
ATOM    576  C   ALA A 263       7.397  28.516   2.959  1.00 37.37           C  
ATOM    577  O   ALA A 263       7.664  28.390   1.766  1.00 41.00           O  
ATOM    578  CB  ALA A 263       6.097  30.467   3.817  1.00 41.24           C  
ATOM    579  N   ILE A 264       8.253  28.205   3.920  1.00 39.22           N  
ATOM    580  CA  ILE A 264       9.543  27.567   3.616  1.00 41.24           C  
ATOM    581  C   ILE A 264       9.378  26.242   2.840  1.00 39.03           C  
ATOM    582  O   ILE A 264      10.101  25.986   1.865  1.00 37.52           O  
ATOM    583  CB  ILE A 264      10.357  27.359   4.926  1.00 36.78           C  
ATOM    584  CG1 ILE A 264      10.870  28.707   5.425  1.00 40.40           C  
ATOM    585  CG2 ILE A 264      11.510  26.408   4.726  1.00 40.32           C  
ATOM    586  CD1 ILE A 264      11.286  28.706   6.880  1.00 41.73           C  
ATOM    587  N   LEU A 265       8.454  25.391   3.282  1.00 38.40           N  
ATOM    588  CA  LEU A 265       8.205  24.117   2.595  1.00 38.73           C  
ATOM    589  C   LEU A 265       7.561  24.299   1.219  1.00 44.57           C  
ATOM    590  O   LEU A 265       7.863  23.555   0.275  1.00 39.10           O  
ATOM    591  CB  LEU A 265       7.317  23.198   3.452  1.00 40.70           C  
ATOM    592  CG  LEU A 265       7.991  22.519   4.643  1.00 44.04           C  
ATOM    593  CD1 LEU A 265       7.012  21.545   5.289  1.00 47.32           C  
ATOM    594  CD2 LEU A 265       9.280  21.832   4.208  1.00 38.84           C  
ATOM    595  N   LYS A 266       6.660  25.272   1.107  1.00 41.20           N  
ATOM    596  CA  LYS A 266       6.059  25.589  -0.196  1.00 47.06           C  
ATOM    597  C   LYS A 266       7.091  26.206  -1.161  1.00 48.22           C  
ATOM    598  O   LYS A 266       7.068  25.915  -2.356  1.00 47.81           O  
ATOM    599  CB  LYS A 266       4.867  26.547  -0.025  1.00 46.58           C  
ATOM    600  CG  LYS A 266       3.592  25.880   0.439  1.00 48.73           C  
ATOM    601  CD  LYS A 266       2.408  26.847   0.323  1.00 54.67           C  
ATOM    602  CE  LYS A 266       1.091  26.194   0.738  1.00 57.72           C  
ATOM    603  NZ  LYS A 266       0.080  27.199   1.218  1.00 63.41           N  
ATOM    604  N   ASN A 267       7.994  27.041  -0.642  1.00 50.63           N  
ATOM    605  CA  ASN A 267       8.995  27.747  -1.470  1.00 50.51           C  
ATOM    606  C   ASN A 267       9.973  26.807  -2.200  1.00 48.20           C  
ATOM    607  O   ASN A 267      10.712  27.238  -3.074  1.00 59.33           O  
ATOM    608  CB  ASN A 267       9.774  28.757  -0.596  1.00 49.73           C  
ATOM    609  CG  ASN A 267      10.757  29.640  -1.402  1.00 58.83           C  
ATOM    610  OD1 ASN A 267      10.571  29.894  -2.595  1.00 72.57           O  
ATOM    611  ND2 ASN A 267      11.799  30.122  -0.725  1.00 62.42           N  
ATOM    612  N   THR A 268       9.934  25.520  -1.894  1.00 47.55           N  
ATOM    613  CA  THR A 268      10.943  24.590  -2.383  1.00 44.22           C  
ATOM    614  C   THR A 268      10.726  24.165  -3.832  1.00 46.71           C  
ATOM    615  O   THR A 268       9.593  24.122  -4.328  1.00 44.12           O  
ATOM    616  CB  THR A 268      11.005  23.321  -1.490  1.00 44.72           C  
ATOM    617  OG1 THR A 268       9.709  22.739  -1.380  1.00 43.69           O  
ATOM    618  CG2 THR A 268      11.493  23.663  -0.095  1.00 43.67           C  
ATOM    619  N   SER A 269      11.825  23.857  -4.508  1.00 44.28           N  
ATOM    620  CA  SER A 269      11.769  23.239  -5.823  1.00 43.98           C  
ATOM    621  C   SER A 269      12.064  21.741  -5.655  1.00 44.97           C  
ATOM    622  O   SER A 269      11.809  21.165  -4.585  1.00 53.58           O  
ATOM    623  CB  SER A 269      12.726  23.955  -6.795  1.00 47.66           C  
ATOM    624  OG  SER A 269      14.047  24.049  -6.275  1.00 45.82           O  
ATOM    625  N   GLU A 270      12.607  21.116  -6.684  1.00 34.88           N  
ATOM    626  CA  GLU A 270      12.681  19.671  -6.784  1.00 37.46           C  
ATOM    627  C   GLU A 270      13.616  19.023  -5.764  1.00 36.87           C  
ATOM    628  O   GLU A 270      13.259  17.986  -5.205  1.00 41.97           O  
ATOM    629  CB  GLU A 270      13.083  19.286  -8.215  1.00 37.31           C  
ATOM    630  CG  GLU A 270      13.444  17.845  -8.463  1.00 42.91           C  
ATOM    631  CD  GLU A 270      13.408  17.492  -9.955  1.00 38.15           C  
ATOM    632  OE1 GLU A 270      14.473  17.538 -10.624  1.00 37.49           O  
ATOM    633  OE2 GLU A 270      12.302  17.192 -10.459  1.00 40.00           O  
ATOM    634  N   VAL A 271      14.794  19.607  -5.527  1.00 33.18           N  
ATOM    635  CA  VAL A 271      15.796  19.014  -4.639  1.00 30.50           C  
ATOM    636  C   VAL A 271      15.772  19.762  -3.312  1.00 33.69           C  
ATOM    637  O   VAL A 271      15.960  20.982  -3.278  1.00 35.92           O  
ATOM    638  CB  VAL A 271      17.239  19.079  -5.196  1.00 35.27           C  
ATOM    639  CG1 VAL A 271      18.232  18.427  -4.213  1.00 40.83           C  
ATOM    640  CG2 VAL A 271      17.344  18.470  -6.562  1.00 43.43           C  
ATOM    641  N   VAL A 272      15.539  19.039  -2.216  1.00 33.92           N  
ATOM    642  CA  VAL A 272      15.379  19.676  -0.903  1.00 34.96           C  
ATOM    643  C   VAL A 272      16.300  19.028   0.130  1.00 37.91           C  
ATOM    644  O   VAL A 272      16.274  17.817   0.318  1.00 38.10           O  
ATOM    645  CB  VAL A 272      13.974  19.526  -0.431  1.00 32.52           C  
ATOM    646  CG1 VAL A 272      13.776  20.085   0.979  1.00 35.12           C  
ATOM    647  CG2 VAL A 272      12.992  20.168  -1.434  1.00 41.76           C  
ATOM    648  N   TYR A 273      17.103  19.853   0.790  1.00 37.82           N  
ATOM    649  CA  TYR A 273      18.018  19.414   1.842  1.00 34.90           C  
ATOM    650  C   TYR A 273      17.392  19.739   3.187  1.00 34.12           C  
ATOM    651  O   TYR A 273      17.111  20.909   3.479  1.00 38.29           O  
ATOM    652  CB  TYR A 273      19.353  20.144   1.729  1.00 35.06           C  
ATOM    653  CG  TYR A 273      20.053  19.854   0.438  1.00 32.36           C  
ATOM    654  CD1 TYR A 273      19.810  20.626  -0.700  1.00 37.63           C  
ATOM    655  CD2 TYR A 273      20.919  18.788   0.332  1.00 35.45           C  
ATOM    656  CE1 TYR A 273      20.445  20.338  -1.903  1.00 34.66           C  
ATOM    657  CE2 TYR A 273      21.559  18.508  -0.867  1.00 35.89           C  
ATOM    658  CZ  TYR A 273      21.301  19.284  -1.981  1.00 39.72           C  
ATOM    659  OH  TYR A 273      21.918  19.006  -3.205  1.00 38.80           O  
ATOM    660  N   LEU A 274      17.142  18.692   3.964  1.00 33.25           N  
ATOM    661  CA  LEU A 274      16.522  18.809   5.283  1.00 36.97           C  
ATOM    662  C   LEU A 274      17.536  18.449   6.355  1.00 32.96           C  
ATOM    663  O   LEU A 274      18.166  17.384   6.300  1.00 36.74           O  
ATOM    664  CB  LEU A 274      15.324  17.844   5.424  1.00 38.67           C  
ATOM    665  CG  LEU A 274      14.170  17.917   4.413  1.00 40.52           C  
ATOM    666  CD1 LEU A 274      13.281  16.665   4.498  1.00 48.49           C  
ATOM    667  CD2 LEU A 274      13.324  19.150   4.593  1.00 49.68           C  
ATOM    668  N   LYS A 275      17.656  19.326   7.345  1.00 33.79           N  
ATOM    669  CA  LYS A 275      18.396  19.042   8.553  1.00 35.72           C  
ATOM    670  C   LYS A 275      17.367  18.595   9.580  1.00 37.25           C  
ATOM    671  O   LYS A 275      16.410  19.341   9.872  1.00 34.10           O  
ATOM    672  CB  LYS A 275      19.146  20.272   9.046  1.00 36.42           C  
ATOM    673  CG  LYS A 275      20.065  19.982  10.221  1.00 35.83           C  
ATOM    674  CD  LYS A 275      20.570  21.229  10.868  1.00 38.05           C  
ATOM    675  CE  LYS A 275      21.483  22.040  10.003  1.00 48.79           C  
ATOM    676  NZ  LYS A 275      22.770  21.355   9.778  1.00 43.13           N  
ATOM    677  N   VAL A 276      17.564  17.393  10.114  1.00 37.02           N  
ATOM    678  CA  VAL A 276      16.534  16.716  10.904  1.00 40.00           C  
ATOM    679  C   VAL A 276      17.104  16.318  12.276  1.00 37.05           C  
ATOM    680  O   VAL A 276      18.239  15.851  12.373  1.00 36.56           O  
ATOM    681  CB  VAL A 276      16.038  15.468  10.154  1.00 42.23           C  
ATOM    682  CG1 VAL A 276      15.145  14.630  11.019  1.00 46.35           C  
ATOM    683  CG2 VAL A 276      15.311  15.879   8.837  1.00 46.28           C  
ATOM    684  N   GLY A 277      16.313  16.509  13.323  1.00 32.16           N  
ATOM    685  CA  GLY A 277      16.694  16.060  14.664  1.00 33.83           C  
ATOM    686  C   GLY A 277      15.902  14.821  14.983  1.00 37.94           C  
ATOM    687  O   GLY A 277      14.670  14.876  15.088  1.00 40.21           O  
ATOM    688  N   LYS A 278      16.603  13.697  15.108  1.00 38.03           N  
ATOM    689  CA  LYS A 278      15.974  12.421  15.428  1.00 38.69           C  
ATOM    690  C   LYS A 278      16.020  12.150  16.930  1.00 39.53           C  
ATOM    691  O   LYS A 278      17.112  12.135  17.512  1.00 39.01           O  
ATOM    692  CB  LYS A 278      16.672  11.295  14.659  1.00 38.16           C  
ATOM    693  CG  LYS A 278      16.394  11.355  13.167  1.00 47.87           C  
ATOM    694  CD  LYS A 278      16.877  10.115  12.437  1.00 47.39           C  
ATOM    695  CE  LYS A 278      16.120   9.912  11.142  1.00 44.86           C  
ATOM    696  NZ  LYS A 278      14.706   9.525  11.412  1.00 36.69           N  
ATOM    697  N   PRO A 279      14.849  11.939  17.571  1.00 41.03           N  
ATOM    698  CA  PRO A 279      14.881  11.579  18.992  1.00 43.50           C  
ATOM    699  C   PRO A 279      15.646  10.281  19.189  1.00 41.69           C  
ATOM    700  O   PRO A 279      15.443   9.332  18.428  1.00 42.65           O  
ATOM    701  CB  PRO A 279      13.405  11.385  19.352  1.00 46.08           C  
ATOM    702  CG  PRO A 279      12.701  11.200  18.044  1.00 45.64           C  
ATOM    703  CD  PRO A 279      13.467  12.009  17.060  1.00 44.44           C  
ATOM    704  N   THR A 280      16.535  10.254  20.172  1.00 34.33           N  
ATOM    705  CA  THR A 280      17.413   9.107  20.345  1.00 41.06           C  
ATOM    706  C   THR A 280      17.463   8.651  21.789  1.00 38.17           C  
ATOM    707  O   THR A 280      17.424   9.463  22.712  1.00 41.12           O  
ATOM    708  CB  THR A 280      18.847   9.381  19.797  1.00 46.56           C  
ATOM    709  OG1 THR A 280      19.547   8.148  19.621  1.00 60.90           O  
ATOM    710  CG2 THR A 280      19.646  10.257  20.721  1.00 51.33           C  
ATOM    711  N   THR A 281      17.530   7.337  21.963  1.00 35.81           N  
ATOM    712  CA  THR A 281      17.635   6.726  23.282  1.00 38.07           C  
ATOM    713  C   THR A 281      19.079   6.316  23.515  1.00 33.62           C  
ATOM    714  O   THR A 281      19.687   5.693  22.662  1.00 27.76           O  
ATOM    715  CB  THR A 281      16.696   5.524  23.400  1.00 39.14           C  
ATOM    716  OG1 THR A 281      15.340   5.990  23.272  1.00 38.79           O  
ATOM    717  CG2 THR A 281      16.862   4.835  24.748  1.00 43.60           C  
ATOM    718  N   ILE A 282      19.618   6.704  24.663  1.00 30.82           N  
ATOM    719  CA  ILE A 282      20.983   6.383  25.039  1.00 32.75           C  
ATOM    720  C   ILE A 282      20.984   5.112  25.897  1.00 33.44           C  
ATOM    721  O   ILE A 282      20.281   5.033  26.899  1.00 30.53           O  
ATOM    722  CB  ILE A 282      21.630   7.561  25.796  1.00 30.06           C  
ATOM    723  CG1 ILE A 282      21.659   8.839  24.941  1.00 36.40           C  
ATOM    724  CG2 ILE A 282      23.024   7.198  26.275  1.00 27.50           C  
ATOM    725  CD1 ILE A 282      22.464   8.765  23.658  1.00 42.26           C  
ATOM    726  N   TYR A 283      21.766   4.116  25.487  1.00 29.92           N  
ATOM    727  CA  TYR A 283      21.935   2.877  26.254  1.00 31.65           C  
ATOM    728  C   TYR A 283      23.271   2.925  26.977  1.00 30.09           C  
ATOM    729  O   TYR A 283      24.100   3.776  26.663  1.00 29.14           O  
ATOM    730  CB  TYR A 283      21.845   1.649  25.346  1.00 30.68           C  
ATOM    731  CG  TYR A 283      20.519   1.614  24.654  1.00 34.54           C  
ATOM    732  CD1 TYR A 283      20.396   2.040  23.336  1.00 40.64           C  
ATOM    733  CD2 TYR A 283      19.361   1.261  25.341  1.00 41.74           C  
ATOM    734  CE1 TYR A 283      19.179   2.074  22.717  1.00 40.28           C  
ATOM    735  CE2 TYR A 283      18.121   1.293  24.717  1.00 45.39           C  
ATOM    736  CZ  TYR A 283      18.040   1.703  23.400  1.00 47.50           C  
ATOM    737  OH  TYR A 283      16.823   1.747  22.751  1.00 48.95           O  
ATOM    738  OXT TYR A 283      23.524   2.096  27.858  1.00 30.40           O  
TER     739      TYR A 283                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
