
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  687),  selected   95 , name 2fne_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2fne_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M  1954_A      S       1          3.340
LGA    P  1955_A      M       2          0.772
LGA    Q  1956_A      E       3          0.724
LGA    C  1957_A      I       4          0.379
LGA    K  1958_A      L       5          0.340
LGA    S  1959_A      Q       6          0.523
LGA    I  1960_A      V       7          0.388
LGA    T  1961_A      A       8          0.519
LGA    L  1962_A      L       9          0.294
LGA    E  1963_A      H      10          0.933
LGA    R  1964_A      K      11          2.223
LGA    G  1965_A      R      12          4.932
LGA    P  1966_A      D      13           #
LGA    -       -      S      14           -
LGA    -       -      G      15           -
LGA    D  1967_A      E      16          4.390
LGA    G  1968_A      Q      17          0.759
LGA    L  1969_A      L      18          0.753
LGA    G  1970_A      G      19          1.002
LGA    F  1971_A      I      20          0.863
LGA    S  1972_A      K      21          0.822
LGA    I  1973_A      L      22          0.301
LGA    V  1974_A      V      23          0.254
LGA    G  1975_A      R      24          0.714
LGA    G  1976_A      -       -           -
LGA    Y  1977_A      -       -           -
LGA    G  1978_A      -       -           -
LGA    S  1979_A      -       -           -
LGA    P  1980_A      R      25           #
LGA    H  1981_A      T      26          2.448
LGA    G  1982_A      D      27          5.323
LGA    D  1983_A      E      28          5.560
LGA    L  1984_A      P      29          2.379
LGA    P  1985_A      G      30          0.373
LGA    I  1986_A      V      31          0.436
LGA    Y  1987_A      F      32          0.377
LGA    V  1988_A      I      33          0.444
LGA    K  1989_A      L      34          0.675
LGA    T  1990_A      D      35          1.147
LGA    V  1991_A      L      36          0.853
LGA    F  1992_A      L      37          1.277
LGA    A  1993_A      E      38          1.561
LGA    K  1994_A      G      39          0.707
LGA    G  1995_A      G      40          0.683
LGA    A  1996_A      L      41          0.523
LGA    A  1997_A      A      42          0.421
LGA    S  1998_A      A      43          0.611
LGA    E  1999_A      Q      44          0.677
LGA    D  2000_A      D      45          0.575
LGA    G  2001_A      G      46          0.593
LGA    R  2002_A      R      47          0.259
LGA    L  2003_A      L      48          0.259
LGA    K  2004_A      S      49          0.422
LGA    R  2005_A      S      50          0.380
LGA    G  2006_A      N      51          0.392
LGA    D  2007_A      D      52          0.395
LGA    Q  2008_A      R      53          0.426
LGA    I  2009_A      V      54          0.452
LGA    I  2010_A      L      55          0.456
LGA    A  2011_A      A      56          0.668
LGA    V  2012_A      I      57          0.621
LGA    N  2013_A      N      58          1.083
LGA    G  2014_A      G      59          1.076
LGA    Q  2015_A      H      60          1.098
LGA    S  2016_A      D      61          0.776
LGA    L  2017_A      L      62          0.577
LGA    E  2018_A      K      63          2.424
LGA    G  2019_A      Y      64          1.513
LGA    V  2020_A      G      65          1.689
LGA    T  2021_A      T      66          2.791
LGA    H  2022_A      P      67          2.775
LGA    E  2023_A      E      68          1.511
LGA    E  2024_A      L      69          1.563
LGA    A  2025_A      A      70          2.121
LGA    V  2026_A      A      71          1.748
LGA    A  2027_A      Q      72          1.065
LGA    I  2028_A      I      73          1.568
LGA    L  2029_A      I      74          2.437
LGA    K  2030_A      Q      75          2.235
LGA    R  2031_A      A      76          1.653
LGA    T  2032_A      S      77          1.824
LGA    K  2033_A      G      78          1.577
LGA    G  2034_A      E      79          1.517
LGA    T  2035_A      R      80          0.665
LGA    V  2036_A      V      81          0.810
LGA    T  2037_A      N      82          0.888
LGA    L  2038_A      L      83          0.558
LGA    M  2039_A      T      84          0.553
LGA    V  2040_A      I      85          0.291
LGA    L  2041_A      A      86          0.459
LGA    S  2042_A      R      87          1.152
LGA    S  2043_A      P      88          3.475
LGA    -       -      G      89           -
LGA    D  2044_A      K      90          4.371
LGA    E  2045_A      P      91          2.082
LGA    T  2046_A      E      92           -
LGA    S  2047_A      I      93           -
LGA    V  2048_A      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   95    5.0     86    1.73    24.42     85.355     4.690

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.416963 * X  +  -0.724115 * Y  +   0.549363 * Z  +  -8.753499
  Y_new =   0.897264 * X  +   0.424421 * Y  +  -0.121589 * Z  +   9.647202
  Z_new =  -0.145117 * X  +   0.543622 * Y  +   0.826690 * Z  +  -6.431507 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.581691   -2.559901  [ DEG:    33.3284   -146.6716 ]
  Theta =   0.145631    2.995962  [ DEG:     8.3440    171.6560 ]
  Phi   =   1.135781   -2.005812  [ DEG:    65.0755   -114.9245 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fne_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fne_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   95   5.0   86   1.73   24.42  85.355
REMARK  ---------------------------------------------------------- 
MOLECULE 2fne_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   11-JAN-06   2FNE              
TITLE     THE CRYSTAL STRUCTURE OF THE 13TH PDZ DOMAIN OF MPDZ                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MULTIPLE PDZ DOMAIN PROTEIN;                               
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: MPDZ DOMAIN, RESIDUES 1955-2042;                           
COMPND   5 SYNONYM: MULTI PDZ DOMAIN PROTEIN 1;                                 
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MPDZ, MUPP1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21(DE3)R3;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    STRUCTURAL PROTEIN, STRUCTURAL GENOMICS, SGC, STRUCTURAL              
KEYWDS   2 GENOMICS CONSORTIUM                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.PAPAGRIGORIOU,G.BERRIDGE,C.JOHANSSON,S.COLEBROOK,E.SALAH,           
AUTHOR   2 N.BURGESS,C.SMEE,P.SAVITSKY,J.BRAY,G.SCHOCH,C.PHILLIPS,              
AUTHOR   3 C.GILEADI,M.SOUNDARAJAN,X.YANG,J.ELKINS,F.GORREC,A.TURNBULL,         
AUTHOR   4 A.EDWARDS,C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,D.DOYLE,                
AUTHOR   5 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   24-JAN-06 2FNE    0                                                
JRNL        AUTH   E.PAPAGRIGORIOU,G.BERRIDGE,C.JOHANSSON,S.COLEBROOK,          
JRNL        AUTH 2 E.SALAH,N.BURGESS,C.SMEE,P.SAVITSKY,J.BRAY,                  
JRNL        AUTH 3 G.SCHOCH,C.PHILLIPS,C.GILEADI,M.SOUNDARAJAN,X.YANG,          
JRNL        AUTH 4 J.ELKINS,F.GORREC,A.TURNBULL,A.EDWARDS,                      
JRNL        AUTH 5 C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,D.DOYLE,                  
JRNL        AUTH 6 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE 13TH PDZ DOMAIN OF              
JRNL        TITL 2 MPDZ                                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.83 ANGSTROMS.                                          
DBREF  2FNE A 1954  2042  UNP    Q5VZ62   MPDZ_HUMAN       1     89             
DBREF  2FNE B 1954  2042  UNP    Q5VZ62   MPDZ_HUMAN       1     89             
DBREF  2FNE C 1954  2042  UNP    Q5VZ62   MPDZ_HUMAN       1     89             
SEQRES   1 A  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET PRO GLN CYS          
SEQRES   3 A  117  LYS SER ILE THR LEU GLU ARG GLY PRO ASP GLY LEU GLY          
SEQRES   4 A  117  PHE SER ILE VAL GLY GLY TYR GLY SER PRO HIS GLY ASP          
SEQRES   5 A  117  LEU PRO ILE TYR VAL LYS THR VAL PHE ALA LYS GLY ALA          
SEQRES   6 A  117  ALA SER GLU ASP GLY ARG LEU LYS ARG GLY ASP GLN ILE          
SEQRES   7 A  117  ILE ALA VAL ASN GLY GLN SER LEU GLU GLY VAL THR HIS          
SEQRES   8 A  117  GLU GLU ALA VAL ALA ILE LEU LYS ARG THR LYS GLY THR          
SEQRES   9 A  117  VAL THR LEU MET VAL LEU SER SER ASP GLU THR SER VAL          
SEQRES   1 B  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET PRO GLN CYS          
SEQRES   3 B  117  LYS SER ILE THR LEU GLU ARG GLY PRO ASP GLY LEU GLY          
SEQRES   4 B  117  PHE SER ILE VAL GLY GLY TYR GLY SER PRO HIS GLY ASP          
SEQRES   5 B  117  LEU PRO ILE TYR VAL LYS THR VAL PHE ALA LYS GLY ALA          
SEQRES   6 B  117  ALA SER GLU ASP GLY ARG LEU LYS ARG GLY ASP GLN ILE          
SEQRES   7 B  117  ILE ALA VAL ASN GLY GLN SER LEU GLU GLY VAL THR HIS          
SEQRES   8 B  117  GLU GLU ALA VAL ALA ILE LEU LYS ARG THR LYS GLY THR          
SEQRES   9 B  117  VAL THR LEU MET VAL LEU SER SER ASP GLU THR SER VAL          
SEQRES   1 C  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 C  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET PRO GLN CYS          
SEQRES   3 C  117  LYS SER ILE THR LEU GLU ARG GLY PRO ASP GLY LEU GLY          
SEQRES   4 C  117  PHE SER ILE VAL GLY GLY TYR GLY SER PRO HIS GLY ASP          
SEQRES   5 C  117  LEU PRO ILE TYR VAL LYS THR VAL PHE ALA LYS GLY ALA          
SEQRES   6 C  117  ALA SER GLU ASP GLY ARG LEU LYS ARG GLY ASP GLN ILE          
SEQRES   7 C  117  ILE ALA VAL ASN GLY GLN SER LEU GLU GLY VAL THR HIS          
SEQRES   8 C  117  GLU GLU ALA VAL ALA ILE LEU LYS ARG THR LYS GLY THR          
SEQRES   9 C  117  VAL THR LEU MET VAL LEU SER SER ASP GLU THR SER VAL          
FORMUL   4  HOH   *199(H2 O)                                                    
CRYST1   47.943   62.380   53.128  90.00 106.26  90.00 P 1 21 1      6          
ATOM      1  N   MET A1954      20.063   9.269  22.680  1.00 73.31           N  
ATOM      2  CA  MET A1954      21.220   9.855  21.937  1.00 72.14           C  
ATOM      3  C   MET A1954      20.764  10.603  20.671  1.00 70.46           C  
ATOM      4  O   MET A1954      20.715  10.012  19.588  1.00 69.11           O  
ATOM      5  CB  MET A1954      22.247   8.768  21.592  1.00 71.49           C  
ATOM      6  N   PRO A1955      20.444  11.908  20.806  1.00 68.98           N  
ATOM      7  CA  PRO A1955      19.862  12.706  19.712  1.00 66.85           C  
ATOM      8  C   PRO A1955      20.907  13.133  18.684  1.00 61.30           C  
ATOM      9  O   PRO A1955      21.900  13.777  19.032  1.00 64.70           O  
ATOM     10  CB  PRO A1955      19.257  13.919  20.429  1.00 68.79           C  
ATOM     11  CG  PRO A1955      20.003  14.039  21.705  1.00 74.64           C  
ATOM     12  CD  PRO A1955      20.641  12.705  22.032  1.00 71.96           C  
ATOM     13  N   GLN A1956      20.659  12.782  17.425  1.00 50.98           N  
ATOM     14  CA  GLN A1956      21.647  13.052  16.399  0.50 53.23           C  
ATOM     16  C   GLN A1956      21.140  13.893  15.228  1.00 48.74           C  
ATOM     17  O   GLN A1956      19.969  13.831  14.816  1.00 44.96           O  
ATOM     18  CB  GLN A1956      22.308  11.758  15.911  0.50 56.73           C  
ATOM     20  CG  GLN A1956      21.620  11.064  14.741  0.50 57.75           C  
ATOM     22  CD  GLN A1956      22.617  10.392  13.817  0.50 56.28           C  
ATOM     24  OE1 GLN A1956      23.826  10.628  13.906  0.50 57.00           O  
ATOM     26  NE2 GLN A1956      22.115   9.552  12.917  0.50 58.45           N  
ATOM     28  N   CYS A1957      22.059  14.707  14.714  1.00 46.57           N  
ATOM     29  CA  CYS A1957      21.790  15.538  13.540  1.00 45.22           C  
ATOM     30  C   CYS A1957      21.962  14.732  12.229  1.00 44.78           C  
ATOM     31  O   CYS A1957      22.975  14.064  12.054  1.00 48.36           O  
ATOM     32  CB  CYS A1957      22.768  16.711  13.541  1.00 46.53           C  
ATOM     33  SG  CYS A1957      22.102  17.967  12.435  1.00 64.76           S  
ATOM     34  N   LYS A1958      20.982  14.781  11.336  1.00 39.21           N  
ATOM     35  CA  LYS A1958      21.035  14.054  10.025  1.00 40.07           C  
ATOM     36  C   LYS A1958      20.741  15.047   8.883  1.00 40.50           C  
ATOM     37  O   LYS A1958      20.033  16.045   9.085  1.00 41.66           O  
ATOM     38  CB  LYS A1958      19.915  13.003   9.951  1.00 40.20           C  
ATOM     39  CG  LYS A1958      20.026  11.811  10.846  1.00 48.96           C  
ATOM     40  CD  LYS A1958      18.830  10.851  10.620  1.00 42.65           C  
ATOM     41  CE  LYS A1958      18.932   9.714  11.629  1.00 48.08           C  
ATOM     42  NZ  LYS A1958      17.742   8.789  11.632  1.00 47.24           N  
ATOM     43  N   SER A1959      21.222  14.757   7.675  1.00 36.38           N  
ATOM     44  CA  SER A1959      20.837  15.543   6.512  1.00 36.97           C  
ATOM     45  C   SER A1959      20.126  14.590   5.563  1.00 38.67           C  
ATOM     46  O   SER A1959      20.702  13.590   5.150  1.00 40.99           O  
ATOM     47  CB  SER A1959      22.062  16.131   5.816  1.00 40.57           C  
ATOM     48  OG  SER A1959      22.695  17.055   6.701  1.00 52.90           O  
ATOM     49  N   ILE A1960      18.873  14.892   5.246  1.00 38.39           N  
ATOM     50  CA  ILE A1960      18.037  14.014   4.436  1.00 38.54           C  
ATOM     51  C   ILE A1960      17.617  14.815   3.192  1.00 38.76           C  
ATOM     52  O   ILE A1960      17.113  15.916   3.304  1.00 41.81           O  
ATOM     53  CB  ILE A1960      16.810  13.503   5.254  1.00 35.37           C  
ATOM     54  CG1 ILE A1960      17.243  12.621   6.440  1.00 36.92           C  
ATOM     55  CG2 ILE A1960      15.759  12.751   4.372  1.00 36.63           C  
ATOM     56  CD1 ILE A1960      16.087  12.386   7.429  1.00 42.45           C  
ATOM     57  N   THR A1961      17.861  14.232   2.019  1.00 37.65           N  
ATOM     58  CA  THR A1961      17.650  14.893   0.745  1.00 38.37           C  
ATOM     59  C   THR A1961      16.529  14.195  -0.005  1.00 42.18           C  
ATOM     60  O   THR A1961      16.611  12.976  -0.263  1.00 39.56           O  
ATOM     61  CB  THR A1961      18.940  14.917  -0.073  1.00 42.37           C  
ATOM     62  OG1 THR A1961      19.914  15.667   0.661  1.00 42.61           O  
ATOM     63  CG2 THR A1961      18.712  15.575  -1.422  1.00 40.40           C  
ATOM     64  N   LEU A1962      15.480  14.971  -0.322  1.00 37.87           N  
ATOM     65  CA  LEU A1962      14.310  14.452  -1.036  1.00 39.46           C  
ATOM     66  C   LEU A1962      14.054  15.151  -2.359  1.00 40.77           C  
ATOM     67  O   LEU A1962      14.253  16.338  -2.448  1.00 39.62           O  
ATOM     68  CB  LEU A1962      13.069  14.635  -0.168  1.00 38.51           C  
ATOM     69  CG  LEU A1962      13.161  13.986   1.223  1.00 40.78           C  
ATOM     70  CD1 LEU A1962      11.992  14.404   2.088  1.00 43.60           C  
ATOM     71  CD2 LEU A1962      13.280  12.464   1.195  1.00 40.27           C  
ATOM     72  N   GLU A1963      13.571  14.409  -3.362  1.00 40.21           N  
ATOM     73  CA  GLU A1963      13.008  15.019  -4.581  1.00 44.43           C  
ATOM     74  C   GLU A1963      11.494  15.025  -4.431  1.00 45.10           C  
ATOM     75  O   GLU A1963      10.912  13.975  -4.187  1.00 44.72           O  
ATOM     76  CB  GLU A1963      13.383  14.208  -5.829  1.00 47.07           C  
ATOM     77  CG  GLU A1963      14.869  14.011  -6.028  1.00 60.29           C  
ATOM     78  CD  GLU A1963      15.569  15.226  -6.622  1.00 78.92           C  
ATOM     79  OE1 GLU A1963      14.948  16.314  -6.731  1.00 75.97           O  
ATOM     80  OE2 GLU A1963      16.757  15.081  -6.983  1.00 86.88           O  
ATOM     81  N   ARG A1964      10.847  16.180  -4.532  1.00 46.27           N  
ATOM     82  CA  ARG A1964       9.371  16.195  -4.440  1.00 54.41           C  
ATOM     83  C   ARG A1964       8.725  15.237  -5.436  1.00 56.86           C  
ATOM     84  O   ARG A1964       9.167  15.149  -6.596  1.00 57.01           O  
ATOM     85  CB  ARG A1964       8.815  17.566  -4.763  1.00 60.48           C  
ATOM     86  CG  ARG A1964       8.954  18.565  -3.691  1.00 60.14           C  
ATOM     87  CD  ARG A1964       8.914  19.954  -4.309  1.00 66.80           C  
ATOM     88  NE  ARG A1964       9.611  20.870  -3.421  1.00 59.85           N  
ATOM     89  CZ  ARG A1964       9.055  21.379  -2.334  1.00 60.98           C  
ATOM     90  NH1 ARG A1964       7.793  21.081  -2.043  1.00 61.73           N  
ATOM     91  NH2 ARG A1964       9.759  22.173  -1.553  1.00 46.65           N  
ATOM     92  N   GLY A1965       7.691  14.526  -4.987  1.00 52.95           N  
ATOM     93  CA  GLY A1965       6.816  13.796  -5.887  1.00 55.10           C  
ATOM     94  C   GLY A1965       5.685  14.717  -6.319  1.00 59.18           C  
ATOM     95  O   GLY A1965       5.760  15.936  -6.100  1.00 56.44           O  
ATOM     96  N   PRO A1966       4.623  14.148  -6.927  1.00 62.41           N  
ATOM     97  CA  PRO A1966       3.453  14.971  -7.262  1.00 64.09           C  
ATOM     98  C   PRO A1966       2.635  15.337  -6.010  1.00 63.61           C  
ATOM     99  O   PRO A1966       1.895  16.319  -6.028  1.00 64.04           O  
ATOM    100  CB  PRO A1966       2.649  14.086  -8.227  1.00 64.25           C  
ATOM    101  CG  PRO A1966       3.056  12.693  -7.924  1.00 64.74           C  
ATOM    102  CD  PRO A1966       4.447  12.737  -7.323  1.00 64.18           C  
ATOM    103  N   ASP A1967       2.801  14.562  -4.939  1.00 58.89           N  
ATOM    104  CA  ASP A1967       2.159  14.826  -3.648  1.00 57.77           C  
ATOM    105  C   ASP A1967       3.068  15.588  -2.656  1.00 55.34           C  
ATOM    106  O   ASP A1967       2.779  15.615  -1.455  1.00 59.66           O  
ATOM    107  CB  ASP A1967       1.686  13.507  -3.002  1.00 60.12           C  
ATOM    108  CG  ASP A1967       0.649  12.764  -3.844  1.00 69.69           C  
ATOM    109  OD1 ASP A1967       1.015  11.741  -4.458  1.00 74.65           O  
ATOM    110  OD2 ASP A1967      -0.528  13.190  -3.886  1.00 73.61           O  
ATOM    111  N   GLY A1968       4.159  16.191  -3.150  1.00 46.84           N  
ATOM    112  CA  GLY A1968       5.080  16.981  -2.312  1.00 43.58           C  
ATOM    113  C   GLY A1968       6.166  16.085  -1.736  1.00 43.22           C  
ATOM    114  O   GLY A1968       6.526  15.063  -2.375  1.00 43.54           O  
ATOM    115  N   LEU A1969       6.660  16.460  -0.536  1.00 43.30           N  
ATOM    116  CA  LEU A1969       7.730  15.759   0.159  1.00 41.08           C  
ATOM    117  C   LEU A1969       7.241  14.447   0.767  1.00 42.99           C  
ATOM    118  O   LEU A1969       8.031  13.521   1.008  1.00 40.11           O  
ATOM    119  CB  LEU A1969       8.394  16.669   1.204  1.00 40.65           C  
ATOM    120  CG  LEU A1969       9.033  17.953   0.627  1.00 43.61           C  
ATOM    121  CD1 LEU A1969       9.391  18.929   1.698  1.00 43.24           C  
ATOM    122  CD2 LEU A1969      10.252  17.653  -0.241  1.00 42.46           C  
ATOM    123  N   GLY A1970       5.925  14.359   0.984  1.00 39.32           N  
ATOM    124  CA  GLY A1970       5.302  13.140   1.474  1.00 36.14           C  
ATOM    125  C   GLY A1970       5.333  12.981   3.004  1.00 39.52           C  
ATOM    126  O   GLY A1970       5.436  11.848   3.545  1.00 37.54           O  
ATOM    127  N   PHE A1971       5.161  14.078   3.720  1.00 35.80           N  
ATOM    128  CA  PHE A1971       4.998  13.947   5.188  1.00 36.74           C  
ATOM    129  C   PHE A1971       4.213  15.115   5.740  1.00 38.62           C  
ATOM    130  O   PHE A1971       4.037  16.127   5.057  1.00 41.26           O  
ATOM    131  CB  PHE A1971       6.357  13.778   5.957  1.00 37.99           C  
ATOM    132  CG  PHE A1971       7.280  14.979   5.850  1.00 39.35           C  
ATOM    133  CD1 PHE A1971       7.243  16.007   6.806  1.00 44.42           C  
ATOM    134  CD2 PHE A1971       8.177  15.066   4.776  1.00 42.60           C  
ATOM    135  CE1 PHE A1971       8.114  17.132   6.700  1.00 39.60           C  
ATOM    136  CE2 PHE A1971       9.059  16.153   4.648  1.00 40.29           C  
ATOM    137  CZ  PHE A1971       9.034  17.193   5.603  1.00 41.58           C  
ATOM    138  N   SER A1972       3.731  14.960   6.974  1.00 39.06           N  
ATOM    139  CA  SER A1972       3.075  16.056   7.666  1.00 38.74           C  
ATOM    140  C   SER A1972       3.897  16.519   8.841  1.00 39.66           C  
ATOM    141  O   SER A1972       4.703  15.747   9.431  1.00 38.02           O  
ATOM    142  CB  SER A1972       1.677  15.672   8.189  1.00 41.23           C  
ATOM    143  OG  SER A1972       1.755  14.563   9.074  1.00 39.87           O  
ATOM    144  N   ILE A1973       3.651  17.764   9.206  1.00 39.44           N  
ATOM    145  CA  ILE A1973       4.286  18.374  10.360  1.00 36.32           C  
ATOM    146  C   ILE A1973       3.261  18.883  11.369  1.00 39.91           C  
ATOM    147  O   ILE A1973       2.114  19.197  11.018  1.00 38.58           O  
ATOM    148  CB  ILE A1973       5.237  19.544   9.948  1.00 38.01           C  
ATOM    149  CG1 ILE A1973       4.484  20.688   9.209  1.00 38.21           C  
ATOM    150  CG2 ILE A1973       6.401  19.006   9.089  1.00 40.50           C  
ATOM    151  CD1 ILE A1973       5.351  22.002   9.181  1.00 42.35           C  
ATOM    152  N   VAL A1974       3.674  18.913  12.632  1.00 36.84           N  
ATOM    153  CA  VAL A1974       2.961  19.583  13.713  1.00 35.13           C  
ATOM    154  C   VAL A1974       3.969  20.495  14.429  1.00 37.87           C  
ATOM    155  O   VAL A1974       5.171  20.417  14.170  1.00 38.70           O  
ATOM    156  CB  VAL A1974       2.339  18.591  14.731  1.00 35.83           C  
ATOM    157  CG1 VAL A1974       1.293  17.698  14.057  1.00 37.25           C  
ATOM    158  CG2 VAL A1974       3.412  17.661  15.399  1.00 42.01           C  
ATOM    159  N   GLY A1975       3.455  21.399  15.252  1.00 38.56           N  
ATOM    160  CA  GLY A1975       4.323  22.291  16.082  1.00 38.87           C  
ATOM    161  C   GLY A1975       4.447  23.683  15.500  1.00 39.05           C  
ATOM    162  O   GLY A1975       3.694  24.073  14.572  1.00 41.73           O  
ATOM    163  N   GLY A1976       5.393  24.452  16.021  1.00 37.28           N  
ATOM    164  CA  GLY A1976       5.510  25.829  15.584  1.00 35.78           C  
ATOM    165  C   GLY A1976       5.371  26.763  16.770  1.00 38.00           C  
ATOM    166  O   GLY A1976       4.766  26.429  17.809  1.00 38.46           O  
ATOM    167  N   TYR A1977       6.004  27.916  16.651  1.00 37.34           N  
ATOM    168  CA  TYR A1977       5.799  28.967  17.660  1.00 37.55           C  
ATOM    169  C   TYR A1977       4.314  29.352  17.701  1.00 42.68           C  
ATOM    170  O   TYR A1977       3.740  29.652  16.667  1.00 37.57           O  
ATOM    171  CB  TYR A1977       6.614  30.158  17.259  1.00 36.77           C  
ATOM    172  CG  TYR A1977       6.533  31.331  18.216  1.00 34.83           C  
ATOM    173  CD1 TYR A1977       7.100  31.242  19.482  1.00 34.62           C  
ATOM    174  CD2 TYR A1977       5.892  32.496  17.860  1.00 37.59           C  
ATOM    175  CE1 TYR A1977       7.054  32.314  20.376  1.00 36.36           C  
ATOM    176  CE2 TYR A1977       5.847  33.579  18.723  1.00 36.28           C  
ATOM    177  CZ  TYR A1977       6.419  33.481  19.984  1.00 35.46           C  
ATOM    178  OH  TYR A1977       6.354  34.553  20.832  1.00 37.81           O  
ATOM    179  N   GLY A1978       3.695  29.311  18.877  1.00 36.54           N  
ATOM    180  CA  GLY A1978       2.306  29.768  19.018  1.00 40.16           C  
ATOM    181  C   GLY A1978       1.339  28.740  18.447  1.00 38.55           C  
ATOM    182  O   GLY A1978       0.169  29.059  18.187  1.00 41.16           O  
ATOM    183  N   SER A1979       1.815  27.492  18.280  1.00 37.25           N  
ATOM    184  CA  SER A1979       0.987  26.364  17.775  1.00 41.35           C  
ATOM    185  C   SER A1979      -0.070  25.964  18.839  1.00 43.65           C  
ATOM    186  O   SER A1979       0.061  26.330  20.023  1.00 38.83           O  
ATOM    187  CB  SER A1979       1.906  25.178  17.418  1.00 39.07           C  
ATOM    188  OG  SER A1979       2.084  24.366  18.561  1.00 47.06           O  
ATOM    189  N   PRO A1980      -1.150  25.261  18.421  1.00 42.04           N  
ATOM    190  CA  PRO A1980      -2.138  24.806  19.391  1.00 44.88           C  
ATOM    191  C   PRO A1980      -1.561  24.015  20.565  1.00 45.19           C  
ATOM    192  O   PRO A1980      -2.164  24.021  21.617  1.00 43.44           O  
ATOM    193  CB  PRO A1980      -3.067  23.905  18.567  1.00 47.33           C  
ATOM    194  CG  PRO A1980      -2.955  24.422  17.187  1.00 48.12           C  
ATOM    195  CD  PRO A1980      -1.531  24.914  17.032  1.00 41.47           C  
ATOM    196  N   HIS A1981      -0.428  23.331  20.385  1.00 41.42           N  
ATOM    197  CA  HIS A1981       0.200  22.553  21.459  1.00 44.95           C  
ATOM    198  C   HIS A1981       1.163  23.377  22.336  1.00 48.48           C  
ATOM    199  O   HIS A1981       1.686  22.846  23.312  1.00 50.16           O  
ATOM    200  CB  HIS A1981       0.917  21.292  20.925  1.00 42.92           C  
ATOM    201  CG  HIS A1981      -0.011  20.224  20.418  1.00 38.48           C  
ATOM    202  ND1 HIS A1981      -0.181  19.956  19.075  1.00 46.92           N  
ATOM    203  CD2 HIS A1981      -0.848  19.394  21.075  1.00 39.52           C  
ATOM    204  CE1 HIS A1981      -1.057  18.977  18.932  1.00 43.84           C  
ATOM    205  NE2 HIS A1981      -1.480  18.621  20.128  1.00 53.26           N  
ATOM    206  N   GLY A1982       1.386  24.650  21.988  1.00 47.66           N  
ATOM    207  CA  GLY A1982       2.352  25.512  22.703  1.00 45.76           C  
ATOM    208  C   GLY A1982       3.429  26.004  21.744  1.00 42.60           C  
ATOM    209  O   GLY A1982       3.268  25.892  20.533  1.00 40.27           O  
ATOM    210  N   ASP A1983       4.511  26.577  22.274  1.00 40.69           N  
ATOM    211  CA  ASP A1983       5.593  27.065  21.421  1.00 38.24           C  
ATOM    212  C   ASP A1983       6.497  25.884  21.219  1.00 43.10           C  
ATOM    213  O   ASP A1983       7.245  25.504  22.138  1.00 40.03           O  
ATOM    214  CB  ASP A1983       6.363  28.219  22.097  1.00 37.95           C  
ATOM    215  CG  ASP A1983       5.500  29.449  22.272  1.00 41.67           C  
ATOM    216  OD1 ASP A1983       4.528  29.631  21.477  1.00 36.28           O  
ATOM    217  OD2 ASP A1983       5.792  30.213  23.199  1.00 38.62           O  
ATOM    218  N   LEU A1984       6.385  25.290  20.042  1.00 37.31           N  
ATOM    219  CA  LEU A1984       7.120  24.045  19.723  1.00 39.98           C  
ATOM    220  C   LEU A1984       7.978  24.227  18.503  1.00 40.38           C  
ATOM    221  O   LEU A1984       7.663  25.041  17.642  1.00 41.86           O  
ATOM    222  CB  LEU A1984       6.141  22.910  19.425  1.00 41.84           C  
ATOM    223  CG  LEU A1984       5.268  22.409  20.578  1.00 45.40           C  
ATOM    224  CD1 LEU A1984       4.593  21.139  20.134  1.00 48.38           C  
ATOM    225  CD2 LEU A1984       6.069  22.220  21.872  1.00 55.72           C  
ATOM    226  N   PRO A1985       9.049  23.441  18.409  1.00 40.93           N  
ATOM    227  CA  PRO A1985       9.763  23.280  17.158  1.00 41.36           C  
ATOM    228  C   PRO A1985       8.864  22.564  16.147  1.00 38.19           C  
ATOM    229  O   PRO A1985       7.686  22.239  16.452  1.00 38.61           O  
ATOM    230  CB  PRO A1985      10.904  22.320  17.498  1.00 40.17           C  
ATOM    231  CG  PRO A1985      10.773  21.940  18.911  1.00 49.38           C  
ATOM    232  CD  PRO A1985       9.632  22.655  19.527  1.00 44.38           C  
ATOM    233  N   ILE A1986       9.411  22.332  14.964  1.00 38.75           N  
ATOM    234  CA  ILE A1986       8.646  21.680  13.880  1.00 36.94           C  
ATOM    235  C   ILE A1986       9.000  20.201  13.866  1.00 42.71           C  
ATOM    236  O   ILE A1986      10.182  19.853  13.738  1.00 40.94           O  
ATOM    237  CB  ILE A1986       9.011  22.336  12.534  1.00 38.23           C  
ATOM    238  CG1 ILE A1986       8.707  23.848  12.593  1.00 42.03           C  
ATOM    239  CG2 ILE A1986       8.251  21.645  11.395  1.00 39.58           C  
ATOM    240  CD1 ILE A1986       7.185  24.147  12.802  1.00 39.75           C  
ATOM    241  N   TYR A1987       7.993  19.337  14.049  1.00 36.02           N  
ATOM    242  CA  TYR A1987       8.196  17.894  14.174  1.00 38.91           C  
ATOM    243  C   TYR A1987       7.487  17.211  13.036  1.00 41.31           C  
ATOM    244  O   TYR A1987       6.356  17.547  12.709  1.00 39.93           O  
ATOM    245  CB  TYR A1987       7.554  17.340  15.456  1.00 38.26           C  
ATOM    246  CG  TYR A1987       8.233  17.794  16.725  1.00 41.79           C  
ATOM    247  CD1 TYR A1987       7.586  18.662  17.601  1.00 43.83           C  
ATOM    248  CD2 TYR A1987       9.535  17.365  17.045  1.00 45.94           C  
ATOM    249  CE1 TYR A1987       8.214  19.081  18.783  1.00 45.82           C  
ATOM    250  CE2 TYR A1987      10.196  17.819  18.226  1.00 43.42           C  
ATOM    251  CZ  TYR A1987       9.510  18.664  19.083  1.00 49.37           C  
ATOM    252  OH  TYR A1987      10.108  19.094  20.247  1.00 48.54           O  
ATOM    253  N   VAL A1988       8.139  16.208  12.468  1.00 38.80           N  
ATOM    254  CA  VAL A1988       7.456  15.276  11.571  1.00 39.43           C  
ATOM    255  C   VAL A1988       6.415  14.443  12.343  1.00 41.33           C  
ATOM    256  O   VAL A1988       6.724  13.794  13.361  1.00 38.16           O  
ATOM    257  CB  VAL A1988       8.484  14.307  10.927  1.00 39.70           C  
ATOM    258  CG1 VAL A1988       7.756  13.269  10.080  1.00 39.63           C  
ATOM    259  CG2 VAL A1988       9.504  15.129  10.102  1.00 38.50           C  
ATOM    260  N   LYS A1989       5.185  14.432  11.855  1.00 37.26           N  
ATOM    261  CA  LYS A1989       4.116  13.627  12.497  1.00 35.86           C  
ATOM    262  C   LYS A1989       3.924  12.321  11.743  1.00 40.12           C  
ATOM    263  O   LYS A1989       4.041  11.244  12.317  1.00 43.57           O  
ATOM    264  CB  LYS A1989       2.786  14.386  12.502  1.00 37.35           C  
ATOM    265  CG  LYS A1989       1.655  13.514  13.128  1.00 39.60           C  
ATOM    266  CD  LYS A1989       0.349  14.234  13.298  1.00 42.01           C  
ATOM    267  CE  LYS A1989      -0.752  13.199  13.734  1.00 46.52           C  
ATOM    268  NZ  LYS A1989      -2.028  13.942  14.005  1.00 48.29           N  
ATOM    269  N   THR A1990       3.578  12.402  10.462  1.00 37.60           N  
ATOM    270  CA  THR A1990       3.388  11.154   9.703  1.00 40.25           C  
ATOM    271  C   THR A1990       4.224  11.164   8.428  1.00 41.63           C  
ATOM    272  O   THR A1990       4.248  12.180   7.732  1.00 40.58           O  
ATOM    273  CB  THR A1990       1.907  10.983   9.321  1.00 42.24           C  
ATOM    274  OG1 THR A1990       1.133  10.935  10.521  1.00 41.89           O  
ATOM    275  CG2 THR A1990       1.682   9.657   8.481  1.00 42.46           C  
ATOM    276  N   VAL A1991       4.868  10.040   8.113  1.00 38.95           N  
ATOM    277  CA  VAL A1991       5.529   9.853   6.818  1.00 38.04           C  
ATOM    278  C   VAL A1991       4.630   8.980   5.970  1.00 40.59           C  
ATOM    279  O   VAL A1991       4.371   7.832   6.316  1.00 39.65           O  
ATOM    280  CB  VAL A1991       6.978   9.266   6.984  1.00 41.71           C  
ATOM    281  CG1 VAL A1991       7.639   8.985   5.628  1.00 40.22           C  
ATOM    282  CG2 VAL A1991       7.835  10.246   7.775  1.00 38.46           C  
ATOM    283  N   PHE A1992       4.086   9.537   4.897  1.00 40.11           N  
ATOM    284  CA  PHE A1992       3.047   8.821   4.154  1.00 40.50           C  
ATOM    285  C   PHE A1992       3.562   7.667   3.280  1.00 42.90           C  
ATOM    286  O   PHE A1992       4.482   7.846   2.480  1.00 43.98           O  
ATOM    287  CB  PHE A1992       2.257   9.802   3.285  1.00 38.87           C  
ATOM    288  CG  PHE A1992       1.591  10.885   4.063  1.00 39.89           C  
ATOM    289  CD1 PHE A1992       0.616  10.567   5.007  1.00 47.38           C  
ATOM    290  CD2 PHE A1992       1.948  12.227   3.881  1.00 42.72           C  
ATOM    291  CE1 PHE A1992      -0.002  11.563   5.760  1.00 47.34           C  
ATOM    292  CE2 PHE A1992       1.330  13.242   4.639  1.00 40.09           C  
ATOM    293  CZ  PHE A1992       0.362  12.902   5.580  1.00 46.40           C  
ATOM    294  N   ALA A1993       2.893   6.517   3.364  1.00 40.64           N  
ATOM    295  CA  ALA A1993       3.178   5.416   2.422  1.00 40.76           C  
ATOM    296  C   ALA A1993       3.218   5.944   0.969  1.00 42.68           C  
ATOM    297  O   ALA A1993       2.426   6.806   0.579  1.00 47.24           O  
ATOM    298  CB  ALA A1993       2.151   4.285   2.591  1.00 44.71           C  
ATOM    299  N   LYS A1994       4.195   5.479   0.197  1.00 50.19           N  
ATOM    300  CA  LYS A1994       4.332   5.797  -1.236  1.00 52.68           C  
ATOM    301  C   LYS A1994       4.875   7.187  -1.587  1.00 53.96           C  
ATOM    302  O   LYS A1994       5.121   7.457  -2.758  1.00 53.85           O  
ATOM    303  CB  LYS A1994       3.033   5.496  -2.009  1.00 57.48           C  
ATOM    304  N   GLY A1995       5.080   8.064  -0.595  1.00 44.25           N  
ATOM    305  CA  GLY A1995       5.620   9.377  -0.880  1.00 43.75           C  
ATOM    306  C   GLY A1995       7.156   9.444  -0.918  1.00 42.21           C  
ATOM    307  O   GLY A1995       7.832   8.446  -0.719  1.00 40.75           O  
ATOM    308  N   ALA A1996       7.701  10.624  -1.162  1.00 39.49           N  
ATOM    309  CA  ALA A1996       9.133  10.750  -1.408  1.00 40.30           C  
ATOM    310  C   ALA A1996       9.891  10.470  -0.106  1.00 39.81           C  
ATOM    311  O   ALA A1996      10.892   9.739  -0.101  1.00 37.94           O  
ATOM    312  CB  ALA A1996       9.469  12.137  -1.916  1.00 39.69           C  
ATOM    313  N   ALA A1997       9.388  11.032   1.001  1.00 38.05           N  
ATOM    314  CA  ALA A1997      10.019  10.826   2.332  1.00 40.54           C  
ATOM    315  C   ALA A1997      10.017   9.323   2.686  1.00 42.82           C  
ATOM    316  O   ALA A1997      10.987   8.788   3.228  1.00 36.86           O  
ATOM    317  CB  ALA A1997       9.297  11.652   3.398  1.00 38.30           C  
ATOM    318  N   SER A1998       8.929   8.630   2.353  1.00 39.25           N  
ATOM    319  CA  SER A1998       8.837   7.189   2.670  1.00 40.99           C  
ATOM    320  C   SER A1998       9.772   6.336   1.802  1.00 39.47           C  
ATOM    321  O   SER A1998      10.450   5.407   2.291  1.00 42.52           O  
ATOM    322  CB  SER A1998       7.386   6.702   2.538  1.00 42.42           C  
ATOM    323  OG  SER A1998       7.343   5.311   2.695  1.00 44.34           O  
ATOM    324  N   GLU A1999       9.825   6.647   0.511  1.00 38.38           N  
ATOM    325  CA  GLU A1999      10.651   5.889  -0.416  1.00 41.21           C  
ATOM    326  C   GLU A1999      12.131   6.072  -0.065  1.00 41.52           C  
ATOM    327  O   GLU A1999      12.933   5.143  -0.195  1.00 40.67           O  
ATOM    328  CB  GLU A1999      10.413   6.333  -1.860  1.00 43.85           C  
ATOM    329  CG  GLU A1999       9.059   5.896  -2.458  1.00 52.75           C  
ATOM    330  CD  GLU A1999       8.902   4.381  -2.576  1.00 73.05           C  
ATOM    331  OE1 GLU A1999       9.785   3.725  -3.173  1.00 73.84           O  
ATOM    332  OE2 GLU A1999       7.888   3.851  -2.075  1.00 74.77           O  
ATOM    333  N   ASP A2000      12.478   7.271   0.395  1.00 37.59           N  
ATOM    334  CA  ASP A2000      13.841   7.559   0.805  1.00 39.04           C  
ATOM    335  C   ASP A2000      14.255   6.754   2.052  1.00 38.59           C  
ATOM    336  O   ASP A2000      15.425   6.302   2.171  1.00 41.08           O  
ATOM    337  CB  ASP A2000      13.976   9.050   1.081  1.00 38.29           C  
ATOM    338  CG  ASP A2000      15.339   9.394   1.626  1.00 46.63           C  
ATOM    339  OD1 ASP A2000      15.461   9.524   2.857  1.00 42.30           O  
ATOM    340  OD2 ASP A2000      16.290   9.487   0.841  1.00 42.73           O  
ATOM    341  N   GLY A2001      13.291   6.595   2.957  1.00 35.68           N  
ATOM    342  CA  GLY A2001      13.347   5.692   4.100  1.00 38.88           C  
ATOM    343  C   GLY A2001      14.016   6.222   5.362  1.00 44.59           C  
ATOM    344  O   GLY A2001      14.141   5.501   6.336  1.00 49.93           O  
ATOM    345  N   ARG A2002      14.465   7.469   5.353  1.00 39.47           N  
ATOM    346  CA  ARG A2002      15.175   8.012   6.530  1.00 38.50           C  
ATOM    347  C   ARG A2002      14.275   8.787   7.497  1.00 41.75           C  
ATOM    348  O   ARG A2002      14.298   8.567   8.738  1.00 39.07           O  
ATOM    349  CB  ARG A2002      16.357   8.865   6.069  1.00 37.35           C  
ATOM    350  CG  ARG A2002      17.501   8.075   5.491  1.00 37.42           C  
ATOM    351  CD  ARG A2002      18.586   9.022   4.974  1.00 42.73           C  
ATOM    352  NE  ARG A2002      18.173   9.750   3.758  1.00 37.45           N  
ATOM    353  CZ  ARG A2002      19.008  10.483   3.034  1.00 43.16           C  
ATOM    354  NH1 ARG A2002      18.581  11.068   1.926  1.00 39.24           N  
ATOM    355  NH2 ARG A2002      20.274  10.641   3.429  1.00 39.00           N  
ATOM    356  N   LEU A2003      13.474   9.701   6.953  1.00 34.76           N  
ATOM    357  CA  LEU A2003      12.670  10.580   7.814  1.00 36.56           C  
ATOM    358  C   LEU A2003      11.644   9.783   8.595  1.00 35.29           C  
ATOM    359  O   LEU A2003      11.075   8.790   8.073  1.00 36.77           O  
ATOM    360  CB  LEU A2003      11.925  11.612   6.958  1.00 39.42           C  
ATOM    361  CG  LEU A2003      11.334  12.817   7.667  1.00 36.75           C  
ATOM    362  CD1 LEU A2003      12.518  13.774   8.143  1.00 36.48           C  
ATOM    363  CD2 LEU A2003      10.492  13.573   6.648  1.00 42.84           C  
ATOM    364  N   LYS A2004      11.395  10.177   9.845  1.00 37.54           N  
ATOM    365  CA  LYS A2004      10.454   9.422  10.670  1.00 35.84           C  
ATOM    366  C   LYS A2004       9.720  10.289  11.675  1.00 38.16           C  
ATOM    367  O   LYS A2004      10.190  11.367  12.045  1.00 38.66           O  
ATOM    368  CB  LYS A2004      11.149   8.231  11.369  1.00 35.08           C  
ATOM    369  CG  LYS A2004      12.191   8.693  12.436  1.00 37.07           C  
ATOM    370  CD  LYS A2004      12.962   7.494  13.008  1.00 34.29           C  
ATOM    371  CE  LYS A2004      14.011   7.963  14.047  1.00 34.48           C  
ATOM    372  NZ  LYS A2004      14.697   6.822  14.649  1.00 34.91           N  
ATOM    373  N   ARG A2005       8.547   9.822  12.088  1.00 37.80           N  
ATOM    374  CA  ARG A2005       7.783  10.504  13.120  1.00 36.04           C  
ATOM    375  C   ARG A2005       8.668  10.887  14.309  1.00 36.06           C  
ATOM    376  O   ARG A2005       9.461  10.047  14.840  1.00 36.25           O  
ATOM    377  CB  ARG A2005       6.610   9.614  13.571  1.00 37.15           C  
ATOM    378  CG  ARG A2005       5.966  10.151  14.845  1.00 43.46           C  
ATOM    379  CD  ARG A2005       4.781   9.329  15.213  1.00 49.89           C  
ATOM    380  NE  ARG A2005       3.648   9.679  14.369  1.00 51.24           N  
ATOM    381  CZ  ARG A2005       2.391   9.644  14.795  1.00 53.51           C  
ATOM    382  NH1 ARG A2005       1.427   9.973  13.962  1.00 56.44           N  
ATOM    383  NH2 ARG A2005       2.116   9.303  16.060  1.00 50.82           N  
ATOM    384  N   GLY A2006       8.530  12.140  14.752  1.00 36.34           N  
ATOM    385  CA  GLY A2006       9.325  12.604  15.890  1.00 36.81           C  
ATOM    386  C   GLY A2006      10.559  13.413  15.512  1.00 40.80           C  
ATOM    387  O   GLY A2006      11.067  14.183  16.330  1.00 37.53           O  
ATOM    388  N   ASP A2007      11.057  13.238  14.293  1.00 36.46           N  
ATOM    389  CA  ASP A2007      12.182  14.104  13.794  1.00 39.87           C  
ATOM    390  C   ASP A2007      11.808  15.585  13.838  1.00 40.08           C  
ATOM    391  O   ASP A2007      10.709  15.955  13.522  1.00 40.58           O  
ATOM    392  CB  ASP A2007      12.629  13.745  12.359  1.00 37.80           C  
ATOM    393  CG  ASP A2007      13.257  12.352  12.255  1.00 42.61           C  
ATOM    394  OD1 ASP A2007      13.617  11.779  13.305  1.00 42.88           O  
ATOM    395  OD2 ASP A2007      13.392  11.849  11.111  1.00 40.56           O  
ATOM    396  N   GLN A2008      12.757  16.421  14.255  1.00 35.51           N  
ATOM    397  CA  GLN A2008      12.589  17.839  14.310  1.00 35.15           C  
ATOM    398  C   GLN A2008      13.320  18.409  13.132  1.00 38.83           C  
ATOM    399  O   GLN A2008      14.520  18.197  12.983  1.00 39.26           O  
ATOM    400  CB  GLN A2008      13.260  18.373  15.622  1.00 37.27           C  
ATOM    401  CG  GLN A2008      13.147  19.860  15.751  1.00 39.71           C  
ATOM    402  CD  GLN A2008      13.834  20.394  16.996  1.00 47.59           C  
ATOM    403  OE1 GLN A2008      14.069  19.645  17.960  1.00 46.21           O  
ATOM    404  NE2 GLN A2008      14.140  21.701  16.993  1.00 44.47           N  
ATOM    405  N   ILE A2009      12.605  19.178  12.330  1.00 38.77           N  
ATOM    406  CA  ILE A2009      13.193  19.783  11.159  1.00 39.32           C  
ATOM    407  C   ILE A2009      13.871  21.091  11.580  1.00 41.87           C  
ATOM    408  O   ILE A2009      13.241  22.036  12.021  1.00 41.72           O  
ATOM    409  CB  ILE A2009      12.169  20.038  10.107  1.00 38.14           C  
ATOM    410  CG1 ILE A2009      11.473  18.711   9.750  1.00 44.56           C  
ATOM    411  CG2 ILE A2009      12.861  20.553   8.814  1.00 39.68           C  
ATOM    412  CD1 ILE A2009      10.443  18.916   8.698  1.00 47.51           C  
ATOM    413  N   ILE A2010      15.178  21.085  11.489  1.00 35.59           N  
ATOM    414  CA  ILE A2010      16.004  22.209  11.914  1.00 36.60           C  
ATOM    415  C   ILE A2010      16.237  23.253  10.798  1.00 37.22           C  
ATOM    416  O   ILE A2010      16.316  24.491  11.062  1.00 36.02           O  
ATOM    417  CB  ILE A2010      17.421  21.684  12.338  1.00 36.76           C  
ATOM    418  CG1 ILE A2010      17.346  20.822  13.600  1.00 49.34           C  
ATOM    419  CG2 ILE A2010      18.353  22.846  12.549  1.00 42.40           C  
ATOM    420  CD1 ILE A2010      16.579  21.468  14.748  1.00 47.14           C  
ATOM    421  N   ALA A2011      16.434  22.761   9.572  1.00 37.68           N  
ATOM    422  CA  ALA A2011      16.635  23.643   8.427  1.00 35.64           C  
ATOM    423  C   ALA A2011      16.149  23.062   7.105  1.00 36.32           C  
ATOM    424  O   ALA A2011      16.085  21.859   6.935  1.00 39.48           O  
ATOM    425  CB  ALA A2011      18.122  24.093   8.291  1.00 36.92           C  
ATOM    426  N   VAL A2012      15.864  23.939   6.139  1.00 36.52           N  
ATOM    427  CA  VAL A2012      15.419  23.438   4.816  1.00 38.25           C  
ATOM    428  C   VAL A2012      16.311  24.122   3.807  1.00 38.95           C  
ATOM    429  O   VAL A2012      16.232  25.337   3.650  1.00 34.43           O  
ATOM    430  CB  VAL A2012      13.922  23.792   4.551  1.00 40.16           C  
ATOM    431  CG1 VAL A2012      13.448  23.259   3.157  1.00 40.01           C  
ATOM    432  CG2 VAL A2012      12.980  23.347   5.732  1.00 42.36           C  
ATOM    433  N   ASN A2013      17.193  23.363   3.143  1.00 36.14           N  
ATOM    434  CA  ASN A2013      18.176  23.944   2.212  1.00 40.15           C  
ATOM    435  C   ASN A2013      18.935  25.091   2.876  1.00 44.78           C  
ATOM    436  O   ASN A2013      19.140  26.171   2.299  1.00 39.52           O  
ATOM    437  CB  ASN A2013      17.519  24.414   0.906  1.00 41.70           C  
ATOM    438  CG  ASN A2013      17.184  23.263  -0.021  1.00 46.20           C  
ATOM    439  OD1 ASN A2013      17.397  22.106   0.311  1.00 47.13           O  
ATOM    440  ND2 ASN A2013      16.658  23.581  -1.186  1.00 49.19           N  
ATOM    441  N   GLY A2014      19.312  24.856   4.124  1.00 40.88           N  
ATOM    442  CA  GLY A2014      20.146  25.808   4.862  1.00 40.83           C  
ATOM    443  C   GLY A2014      19.394  26.932   5.516  1.00 39.76           C  
ATOM    444  O   GLY A2014      19.974  27.742   6.237  1.00 39.04           O  
ATOM    445  N   GLN A2015      18.096  27.018   5.252  1.00 37.88           N  
ATOM    446  CA  GLN A2015      17.299  28.072   5.851  1.00 38.90           C  
ATOM    447  C   GLN A2015      16.731  27.539   7.150  1.00 40.02           C  
ATOM    448  O   GLN A2015      15.945  26.625   7.155  1.00 36.97           O  
ATOM    449  CB  GLN A2015      16.152  28.462   4.901  1.00 42.40           C  
ATOM    450  CG  GLN A2015      16.619  29.320   3.707  1.00 38.97           C  
ATOM    451  CD  GLN A2015      17.026  30.712   4.137  1.00 48.39           C  
ATOM    452  OE1 GLN A2015      16.182  31.515   4.509  1.00 41.01           O  
ATOM    453  NE2 GLN A2015      18.327  31.000   4.097  1.00 43.45           N  
ATOM    454  N   SER A2016      17.113  28.151   8.264  1.00 38.13           N  
ATOM    455  CA  SER A2016      16.690  27.674   9.588  1.00 37.95           C  
ATOM    456  C   SER A2016      15.203  27.795   9.862  1.00 38.53           C  
ATOM    457  O   SER A2016      14.601  28.807   9.564  1.00 42.28           O  
ATOM    458  CB  SER A2016      17.404  28.489  10.674  1.00 41.01           C  
ATOM    459  OG  SER A2016      16.958  28.093  11.961  1.00 41.94           O  
ATOM    460  N   LEU A2017      14.648  26.789  10.517  1.00 37.54           N  
ATOM    461  CA  LEU A2017      13.292  26.875  11.043  1.00 38.56           C  
ATOM    462  C   LEU A2017      13.247  27.356  12.503  1.00 42.95           C  
ATOM    463  O   LEU A2017      12.197  27.304  13.116  1.00 39.74           O  
ATOM    464  CB  LEU A2017      12.538  25.539  10.919  1.00 39.70           C  
ATOM    465  CG  LEU A2017      12.379  24.959   9.530  1.00 40.14           C  
ATOM    466  CD1 LEU A2017      11.301  23.838   9.515  1.00 39.64           C  
ATOM    467  CD2 LEU A2017      11.994  26.030   8.479  1.00 41.78           C  
ATOM    468  N   GLU A2018      14.351  27.892  13.036  1.00 41.15           N  
ATOM    469  CA  GLU A2018      14.364  28.247  14.449  1.00 39.97           C  
ATOM    470  C   GLU A2018      13.220  29.214  14.761  1.00 39.87           C  
ATOM    471  O   GLU A2018      13.075  30.256  14.102  1.00 39.66           O  
ATOM    472  CB  GLU A2018      15.708  28.873  14.852  1.00 41.09           C  
ATOM    473  CG  GLU A2018      15.716  29.387  16.288  1.00 47.65           C  
ATOM    474  CD  GLU A2018      16.993  30.149  16.605  1.00 52.96           C  
ATOM    475  OE1 GLU A2018      17.147  31.307  16.163  1.00 49.18           O  
ATOM    476  OE2 GLU A2018      17.862  29.575  17.272  1.00 50.14           O  
ATOM    477  N   GLY A2019      12.404  28.852  15.740  1.00 40.27           N  
ATOM    478  CA  GLY A2019      11.325  29.739  16.228  1.00 45.68           C  
ATOM    479  C   GLY A2019      10.176  30.083  15.291  1.00 40.03           C  
ATOM    480  O   GLY A2019       9.367  30.953  15.620  1.00 40.97           O  
ATOM    481  N   VAL A2020      10.084  29.409  14.134  1.00 36.54           N  
ATOM    482  CA  VAL A2020       9.082  29.787  13.124  1.00 39.55           C  
ATOM    483  C   VAL A2020       7.703  29.339  13.580  1.00 39.50           C  
ATOM    484  O   VAL A2020       7.608  28.399  14.366  1.00 35.93           O  
ATOM    485  CB  VAL A2020       9.334  29.200  11.691  1.00 39.59           C  
ATOM    486  CG1 VAL A2020      10.624  29.749  11.019  1.00 45.68           C  
ATOM    487  CG2 VAL A2020       9.233  27.705  11.685  1.00 41.43           C  
ATOM    488  N   THR A2021       6.652  29.998  13.082  1.00 37.10           N  
ATOM    489  CA  THR A2021       5.277  29.560  13.309  1.00 37.98           C  
ATOM    490  C   THR A2021       5.031  28.328  12.425  1.00 39.42           C  
ATOM    491  O   THR A2021       5.781  28.077  11.457  1.00 39.96           O  
ATOM    492  CB  THR A2021       4.241  30.656  12.904  1.00 39.70           C  
ATOM    493  OG1 THR A2021       4.327  30.876  11.480  1.00 37.31           O  
ATOM    494  CG2 THR A2021       4.513  31.980  13.654  1.00 36.73           C  
ATOM    495  N   HIS A2022       3.961  27.587  12.725  1.00 38.90           N  
ATOM    496  CA  HIS A2022       3.538  26.490  11.879  1.00 37.76           C  
ATOM    497  C   HIS A2022       3.453  26.972  10.420  1.00 38.57           C  
ATOM    498  O   HIS A2022       3.980  26.339   9.505  1.00 37.25           O  
ATOM    499  CB  HIS A2022       2.151  25.981  12.321  1.00 36.65           C  
ATOM    500  CG  HIS A2022       1.761  24.679  11.677  1.00 37.95           C  
ATOM    501  ND1 HIS A2022       2.123  23.451  12.187  1.00 38.45           N  
ATOM    502  CD2 HIS A2022       1.017  24.418  10.572  1.00 41.27           C  
ATOM    503  CE1 HIS A2022       1.626  22.485  11.422  1.00 34.50           C  
ATOM    504  NE2 HIS A2022       0.963  23.049  10.431  1.00 40.86           N  
ATOM    505  N   GLU A2023       2.724  28.061  10.203  1.00 38.49           N  
ATOM    506  CA  GLU A2023       2.470  28.541   8.815  1.00 40.66           C  
ATOM    507  C   GLU A2023       3.759  28.944   8.122  1.00 41.09           C  
ATOM    508  O   GLU A2023       3.929  28.706   6.926  1.00 40.10           O  
ATOM    509  CB  GLU A2023       1.475  29.689   8.813  1.00 42.26           C  
ATOM    510  CG  GLU A2023       0.081  29.280   9.325  1.00 53.03           C  
ATOM    511  CD  GLU A2023       0.054  28.929  10.824  1.00 59.82           C  
ATOM    512  OE1 GLU A2023      -0.785  28.079  11.197  1.00 66.34           O  
ATOM    513  OE2 GLU A2023       0.871  29.480  11.620  1.00 47.92           O  
ATOM    514  N   GLU A2024       4.677  29.521   8.882  1.00 40.78           N  
ATOM    515  CA  GLU A2024       5.984  29.870   8.316  1.00 39.30           C  
ATOM    516  C   GLU A2024       6.745  28.633   7.838  1.00 39.68           C  
ATOM    517  O   GLU A2024       7.373  28.657   6.767  1.00 40.33           O  
ATOM    518  CB  GLU A2024       6.818  30.629   9.321  1.00 38.19           C  
ATOM    519  CG  GLU A2024       6.391  32.107   9.366  1.00 42.23           C  
ATOM    520  CD  GLU A2024       6.835  32.860  10.594  1.00 53.05           C  
ATOM    521  OE1 GLU A2024       7.521  32.297  11.492  1.00 41.76           O  
ATOM    522  OE2 GLU A2024       6.454  34.045  10.651  1.00 56.40           O  
ATOM    523  N   ALA A2025       6.735  27.576   8.653  1.00 37.69           N  
ATOM    524  CA  ALA A2025       7.424  26.323   8.318  1.00 38.12           C  
ATOM    525  C   ALA A2025       6.809  25.710   7.053  1.00 37.59           C  
ATOM    526  O   ALA A2025       7.527  25.264   6.139  1.00 34.95           O  
ATOM    527  CB  ALA A2025       7.330  25.365   9.499  1.00 41.11           C  
ATOM    528  N   VAL A2026       5.472  25.713   6.971  1.00 40.33           N  
ATOM    529  CA  VAL A2026       4.780  25.131   5.813  1.00 38.42           C  
ATOM    530  C   VAL A2026       5.195  25.900   4.547  1.00 37.15           C  
ATOM    531  O   VAL A2026       5.474  25.288   3.494  1.00 39.31           O  
ATOM    532  CB  VAL A2026       3.223  25.203   5.991  1.00 42.69           C  
ATOM    533  CG1 VAL A2026       2.496  24.833   4.672  1.00 44.18           C  
ATOM    534  CG2 VAL A2026       2.788  24.285   7.158  1.00 37.35           C  
ATOM    535  N   ALA A2027       5.226  27.231   4.636  1.00 38.48           N  
ATOM    536  CA  ALA A2027       5.636  28.059   3.485  1.00 41.24           C  
ATOM    537  C   ALA A2027       7.048  27.732   3.021  1.00 39.39           C  
ATOM    538  O   ALA A2027       7.268  27.552   1.837  1.00 42.09           O  
ATOM    539  CB  ALA A2027       5.493  29.573   3.788  1.00 39.75           C  
ATOM    540  N   ILE A2028       7.987  27.626   3.960  1.00 43.42           N  
ATOM    541  CA  ILE A2028       9.389  27.321   3.615  1.00 44.27           C  
ATOM    542  C   ILE A2028       9.489  25.921   2.997  1.00 47.40           C  
ATOM    543  O   ILE A2028      10.120  25.750   1.959  1.00 47.93           O  
ATOM    544  CB  ILE A2028      10.302  27.454   4.836  1.00 40.52           C  
ATOM    545  CG1 ILE A2028      10.387  28.898   5.307  1.00 47.22           C  
ATOM    546  CG2 ILE A2028      11.664  26.860   4.569  1.00 45.58           C  
ATOM    547  CD1 ILE A2028      10.995  29.013   6.677  1.00 41.14           C  
ATOM    548  N   LEU A2029       8.809  24.941   3.600  1.00 42.44           N  
ATOM    549  CA  LEU A2029       8.783  23.574   3.084  1.00 39.17           C  
ATOM    550  C   LEU A2029       8.150  23.448   1.701  1.00 47.06           C  
ATOM    551  O   LEU A2029       8.617  22.686   0.876  1.00 46.97           O  
ATOM    552  CB  LEU A2029       8.017  22.662   4.053  1.00 38.01           C  
ATOM    553  CG  LEU A2029       8.933  22.342   5.262  1.00 41.92           C  
ATOM    554  CD1 LEU A2029       8.131  21.789   6.441  1.00 44.95           C  
ATOM    555  CD2 LEU A2029      10.054  21.362   4.870  1.00 42.47           C  
ATOM    556  N   LYS A2030       7.077  24.194   1.468  1.00 46.48           N  
ATOM    557  CA  LYS A2030       6.346  24.103   0.208  1.00 50.59           C  
ATOM    558  C   LYS A2030       6.880  24.970  -0.947  1.00 49.44           C  
ATOM    559  O   LYS A2030       6.572  24.690  -2.111  1.00 53.09           O  
ATOM    560  CB  LYS A2030       4.830  24.286   0.431  1.00 50.77           C  
ATOM    561  CG  LYS A2030       4.252  23.238   1.450  1.00 55.27           C  
ATOM    562  CD  LYS A2030       2.767  22.882   1.206  1.00 61.52           C  
ATOM    563  CE  LYS A2030       1.836  24.087   1.364  1.00 69.03           C  
ATOM    564  NZ  LYS A2030       0.409  23.678   1.537  1.00 76.91           N  
ATOM    565  N   ARG A2031       7.657  26.010  -0.651  1.00 47.20           N  
ATOM    566  CA  ARG A2031       8.128  26.908  -1.717  1.00 57.69           C  
ATOM    567  C   ARG A2031       9.571  26.627  -2.141  1.00 55.83           C  
ATOM    568  O   ARG A2031       9.990  27.069  -3.209  1.00 56.77           O  
ATOM    569  CB  ARG A2031       7.996  28.389  -1.312  1.00 56.05           C  
ATOM    570  CG  ARG A2031       9.246  28.943  -0.615  1.00 62.84           C  
ATOM    571  CD  ARG A2031       9.203  30.468  -0.446  1.00 70.70           C  
ATOM    572  NE  ARG A2031       8.741  30.860   0.891  1.00 81.28           N  
ATOM    573  CZ  ARG A2031       9.544  31.129   1.921  1.00 81.88           C  
ATOM    574  NH1 ARG A2031      10.858  31.061   1.778  1.00 81.40           N  
ATOM    575  NH2 ARG A2031       9.033  31.471   3.099  1.00 76.55           N  
ATOM    576  N   THR A2032      10.327  25.907  -1.306  1.00 55.93           N  
ATOM    577  CA  THR A2032      11.759  25.695  -1.554  1.00 57.45           C  
ATOM    578  C   THR A2032      11.939  24.845  -2.783  1.00 58.02           C  
ATOM    579  O   THR A2032      11.421  23.718  -2.860  1.00 57.98           O  
ATOM    580  CB  THR A2032      12.535  25.080  -0.338  1.00 58.28           C  
ATOM    581  OG1 THR A2032      11.928  23.850   0.068  1.00 69.76           O  
ATOM    582  CG2 THR A2032      12.527  26.056   0.834  1.00 49.14           C  
ATOM    583  N   LYS A2033      12.685  25.412  -3.731  1.00 54.22           N  
ATOM    584  CA  LYS A2033      12.725  24.940  -5.097  1.00 56.01           C  
ATOM    585  C   LYS A2033      13.679  23.773  -5.288  1.00 55.85           C  
ATOM    586  O   LYS A2033      14.801  23.778  -4.760  1.00 55.97           O  
ATOM    587  CB  LYS A2033      13.112  26.098  -6.043  1.00 56.54           C  
ATOM    588  N   GLY A2034      13.218  22.781  -6.053  1.00 53.73           N  
ATOM    589  CA  GLY A2034      14.040  21.642  -6.443  1.00 51.85           C  
ATOM    590  C   GLY A2034      14.322  20.660  -5.327  1.00 51.84           C  
ATOM    591  O   GLY A2034      13.517  20.520  -4.403  1.00 55.46           O  
ATOM    592  N   THR A2035      15.463  19.975  -5.443  1.00 49.24           N  
ATOM    593  CA  THR A2035      15.973  19.012  -4.470  1.00 50.59           C  
ATOM    594  C   THR A2035      16.032  19.643  -3.076  1.00 45.29           C  
ATOM    595  O   THR A2035      16.564  20.754  -2.902  1.00 44.38           O  
ATOM    596  CB  THR A2035      17.364  18.531  -4.896  1.00 52.84           C  
ATOM    597  OG1 THR A2035      17.292  18.036  -6.240  1.00 63.59           O  
ATOM    598  CG2 THR A2035      17.878  17.434  -3.996  1.00 52.62           C  
ATOM    599  N   VAL A2036      15.464  18.946  -2.089  1.00 40.80           N  
ATOM    600  CA  VAL A2036      15.257  19.543  -0.774  1.00 41.38           C  
ATOM    601  C   VAL A2036      16.130  18.787   0.200  1.00 44.16           C  
ATOM    602  O   VAL A2036      15.983  17.584   0.306  1.00 42.03           O  
ATOM    603  CB  VAL A2036      13.780  19.462  -0.335  1.00 41.48           C  
ATOM    604  CG1 VAL A2036      13.600  20.117   1.045  1.00 44.91           C  
ATOM    605  CG2 VAL A2036      12.867  20.134  -1.389  1.00 48.50           C  
ATOM    606  N   THR A2037      17.074  19.481   0.843  1.00 41.98           N  
ATOM    607  CA  THR A2037      17.898  18.861   1.886  1.00 40.81           C  
ATOM    608  C   THR A2037      17.381  19.362   3.241  1.00 41.42           C  
ATOM    609  O   THR A2037      17.482  20.550   3.531  1.00 42.13           O  
ATOM    610  CB  THR A2037      19.368  19.233   1.766  1.00 43.77           C  
ATOM    611  OG1 THR A2037      19.877  18.736   0.527  1.00 45.17           O  
ATOM    612  CG2 THR A2037      20.167  18.626   2.920  1.00 34.80           C  
ATOM    613  N   LEU A2038      16.885  18.442   4.062  1.00 37.75           N  
ATOM    614  CA  LEU A2038      16.364  18.780   5.369  1.00 40.79           C  
ATOM    615  C   LEU A2038      17.464  18.484   6.396  1.00 39.97           C  
ATOM    616  O   LEU A2038      18.013  17.371   6.432  1.00 38.93           O  
ATOM    617  CB  LEU A2038      15.164  17.875   5.654  1.00 39.55           C  
ATOM    618  CG  LEU A2038      13.932  18.018   4.769  1.00 40.76           C  
ATOM    619  CD1 LEU A2038      12.896  16.968   5.217  1.00 44.82           C  
ATOM    620  CD2 LEU A2038      13.335  19.456   4.795  1.00 40.54           C  
ATOM    621  N   MET A2039      17.767  19.443   7.260  1.00 36.33           N  
ATOM    622  CA  MET A2039      18.662  19.127   8.368  1.00 33.48           C  
ATOM    623  C   MET A2039      17.687  18.792   9.499  1.00 41.15           C  
ATOM    624  O   MET A2039      16.786  19.575   9.778  1.00 40.13           O  
ATOM    625  CB  MET A2039      19.527  20.351   8.728  1.00 39.35           C  
ATOM    626  CG  MET A2039      20.211  20.214  10.067  1.00 44.73           C  
ATOM    627  SD  MET A2039      21.265  21.668  10.429  1.00 54.85           S  
ATOM    628  CE  MET A2039      21.784  22.106   8.764  1.00 53.28           C  
ATOM    629  N   VAL A2040      17.839  17.616  10.111  1.00 35.20           N  
ATOM    630  CA  VAL A2040      16.870  17.187  11.153  1.00 36.95           C  
ATOM    631  C   VAL A2040      17.631  16.711  12.391  1.00 33.10           C  
ATOM    632  O   VAL A2040      18.794  16.247  12.306  1.00 37.86           O  
ATOM    633  CB  VAL A2040      15.818  16.124  10.646  1.00 42.12           C  
ATOM    634  CG1 VAL A2040      15.143  16.525   9.296  1.00 46.40           C  
ATOM    635  CG2 VAL A2040      16.427  14.773  10.524  1.00 43.43           C  
ATOM    636  N   LEU A2041      17.000  16.848  13.568  1.00 34.87           N  
ATOM    637  CA  LEU A2041      17.504  16.252  14.790  1.00 33.89           C  
ATOM    638  C   LEU A2041      16.653  15.013  15.042  1.00 36.56           C  
ATOM    639  O   LEU A2041      15.423  15.115  15.156  1.00 37.84           O  
ATOM    640  CB  LEU A2041      17.317  17.227  15.976  1.00 35.63           C  
ATOM    641  CG  LEU A2041      18.137  18.509  16.046  1.00 45.54           C  
ATOM    642  CD1 LEU A2041      17.955  19.144  17.451  1.00 53.77           C  
ATOM    643  CD2 LEU A2041      19.641  18.322  15.737  1.00 60.25           C  
ATOM    644  N   SER A2042      17.300  13.860  15.136  1.00 35.58           N  
ATOM    645  CA  SER A2042      16.571  12.601  15.130  1.00 40.27           C  
ATOM    646  C   SER A2042      16.943  11.738  16.342  1.00 43.40           C  
ATOM    647  O   SER A2042      18.046  11.833  16.874  1.00 47.39           O  
ATOM    648  CB  SER A2042      16.849  11.887  13.812  1.00 39.44           C  
ATOM    649  OG  SER A2042      16.139  10.669  13.740  1.00 44.12           O  
ATOM    650  N   SER A2043      16.003  10.940  16.824  1.00 42.40           N  
ATOM    651  CA  SER A2043      16.279  10.070  17.949  1.00 43.36           C  
ATOM    652  C   SER A2043      16.685   8.731  17.422  1.00 42.20           C  
ATOM    653  O   SER A2043      16.402   8.387  16.278  1.00 42.42           O  
ATOM    654  CB  SER A2043      15.050   9.913  18.853  1.00 48.76           C  
ATOM    655  OG  SER A2043      13.890   9.695  18.053  1.00 52.76           O  
ATOM    656  N   ASP A2044      17.384   8.007  18.285  1.00 37.25           N  
ATOM    657  CA  ASP A2044      17.752   6.641  18.068  0.50 38.51           C  
ATOM    659  C   ASP A2044      16.491   5.759  17.984  1.00 40.18           C  
ATOM    660  O   ASP A2044      16.444   4.798  17.217  1.00 44.27           O  
ATOM    661  CB  ASP A2044      18.643   6.243  19.236  0.50 42.01           C  
ATOM    663  CG  ASP A2044      18.470   7.179  20.443  0.50 44.45           C  
ATOM    665  OD1 ASP A2044      18.397   8.442  20.285  0.50 30.21           O  
ATOM    667  OD2 ASP A2044      18.399   6.646  21.555  0.50 45.13           O  
ATOM    669  N   GLU A2045      15.473   6.101  18.775  1.00 36.20           N  
ATOM    670  CA  GLU A2045      14.263   5.269  18.820  1.00 37.36           C  
ATOM    671  C   GLU A2045      13.322   5.557  17.643  1.00 33.84           C  
ATOM    672  O   GLU A2045      13.341   6.671  17.055  1.00 34.45           O  
ATOM    673  CB  GLU A2045      13.543   5.373  20.167  1.00 39.62           C  
ATOM    674  CG  GLU A2045      12.612   6.501  20.249  1.00 38.77           C  
ATOM    675  CD  GLU A2045      12.330   6.910  21.664  1.00 50.49           C  
ATOM    676  OE1 GLU A2045      11.622   6.169  22.374  1.00 45.64           O  
ATOM    677  OE2 GLU A2045      12.810   7.996  22.057  1.00 56.95           O  
ATOM    678  N   THR A2046      12.527   4.545  17.278  1.00 33.33           N  
ATOM    679  CA  THR A2046      11.586   4.695  16.141  1.00 32.40           C  
ATOM    680  C   THR A2046      10.197   4.191  16.563  1.00 30.29           C  
ATOM    681  O   THR A2046      10.094   3.098  17.099  1.00 30.11           O  
ATOM    682  CB  THR A2046      12.066   3.913  14.883  1.00 35.49           C  
ATOM    683  OG1 THR A2046      13.321   4.456  14.412  1.00 35.55           O  
ATOM    684  CG2 THR A2046      11.040   4.055  13.759  1.00 32.18           C  
ATOM    685  N   SER A2047       9.157   5.000  16.308  1.00 33.36           N  
ATOM    686  CA  SER A2047       7.779   4.618  16.684  1.00 29.73           C  
ATOM    687  C   SER A2047       7.280   3.599  15.661  1.00 36.21           C  
ATOM    688  O   SER A2047       7.565   3.727  14.450  1.00 35.46           O  
ATOM    689  CB  SER A2047       6.840   5.818  16.674  1.00 37.07           C  
ATOM    690  OG  SER A2047       7.334   6.805  17.544  1.00 52.46           O  
ATOM    691  N   VAL A2048       6.550   2.604  16.147  1.00 36.76           N  
ATOM    692  CA  VAL A2048       5.913   1.593  15.304  1.00 35.92           C  
ATOM    693  C   VAL A2048       4.447   1.430  15.764  1.00 43.30           C  
ATOM    694  O   VAL A2048       4.024   2.002  16.790  1.00 42.06           O  
ATOM    695  CB  VAL A2048       6.662   0.220  15.333  1.00 36.73           C  
ATOM    696  CG1 VAL A2048       8.118   0.345  14.857  1.00 36.30           C  
ATOM    697  CG2 VAL A2048       6.589  -0.433  16.717  1.00 32.02           C  
ATOM    698  OXT VAL A2048       3.647   0.692  15.158  1.00 43.04           O  
TER     699      VAL A2048                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
