
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  739),  selected   98 , name 2jik_B
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2jik_B.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -1_B      -       -           -
LGA    M     0_B      -       -           -
LGA    D     6_B      -       -           -
LGA    Y     7_B      -       -           -
LGA    L     8_B      S       1          2.991
LGA    V     9_B      M       2          0.975
LGA    T    10_B      E       3          0.824
LGA    E    11_B      I       4          1.101
LGA    E    12_B      L       5          0.944
LGA    E    13_B      Q       6          1.074
LGA    I    14_B      V       7          0.783
LGA    N    15_B      A       8          0.656
LGA    L    16_B      L       9          0.530
LGA    T    17_B      H      10          0.364
LGA    R    18_B      K      11          1.530
LGA    G    19_B      R      12          4.216
LGA    P    20_B      D      13          5.249
LGA    -       -      S      14           -
LGA    -       -      G      15           -
LGA    S    21_B      E      16          3.811
LGA    G    22_B      Q      17          1.205
LGA    L    23_B      L      18          0.930
LGA    G    24_B      G      19          1.096
LGA    F    25_B      I      20          0.913
LGA    N    26_B      K      21          1.058
LGA    I    27_B      L      22          0.515
LGA    V    28_B      V      23          0.577
LGA    G    29_B      R      24          1.490
LGA    G    30_B      -       -           -
LGA    T    31_B      -       -           -
LGA    D    32_B      -       -           -
LGA    Q    33_B      R      25          4.232
LGA    Q    34_B      T      26          3.274
LGA    Y    35_B      D      27          4.830
LGA    D    39_B      E      28          0.740
LGA    S    40_B      P      29          1.526
LGA    G    41_B      G      30          0.811
LGA    I    42_B      V      31          0.883
LGA    Y    43_B      F      32          0.791
LGA    V    44_B      I      33          0.697
LGA    S    45_B      L      34          0.704
LGA    R    46_B      D      35          1.131
LGA    I    47_B      L      36          0.719
LGA    K    48_B      L      37          1.232
LGA    E    49_B      E      38          1.491
LGA    N    50_B      G      39          1.280
LGA    G    51_B      G      40          0.904
LGA    A    52_B      L      41          0.741
LGA    A    53_B      A      42          0.854
LGA    A    54_B      A      43          0.982
LGA    L    55_B      Q      44          0.983
LGA    D    56_B      D      45          1.097
LGA    G    57_B      G      46          1.155
LGA    R    58_B      R      47          1.115
LGA    L    59_B      L      48          0.977
LGA    Q    60_B      S      49          1.227
LGA    E    61_B      S      50          1.394
LGA    G    62_B      N      51          1.176
LGA    D    63_B      D      52          0.829
LGA    K    64_B      R      53          0.824
LGA    I    65_B      V      54          0.905
LGA    L    66_B      L      55          0.597
LGA    S    67_B      A      56          0.457
LGA    V    68_B      I      57          0.319
LGA    N    69_B      N      58          0.325
LGA    G    70_B      G      59          0.315
LGA    Q    71_B      H      60          0.440
LGA    D    72_B      D      61          0.373
LGA    L    73_B      L      62          0.183
LGA    K    74_B      K      63          1.941
LGA    N    75_B      Y      64          1.478
LGA    L    76_B      G      65          2.187
LGA    L    77_B      T      66          3.621
LGA    H    78_B      P      67          3.368
LGA    Q    79_B      E      68          1.673
LGA    D    80_B      L      69          2.078
LGA    A    81_B      A      70          2.869
LGA    V    82_B      A      71          2.323
LGA    D    83_B      Q      72          1.320
LGA    L    84_B      I      73          1.831
LGA    F    85_B      I      74          2.216
LGA    R    86_B      Q      75          2.144
LGA    N    87_B      A      76          1.723
LGA    A    88_B      S      77          1.439
LGA    G    89_B      G      78          1.819
LGA    Y    90_B      E      79          1.243
LGA    A    91_B      R      80          0.633
LGA    V    92_B      V      81          0.591
LGA    S    93_B      N      82          0.871
LGA    L    94_B      L      83          0.991
LGA    R    95_B      T      84          0.789
LGA    V    96_B      I      85          0.771
LGA    Q    97_B      A      86          1.288
LGA    H    98_B      R      87          1.735
LGA    R    99_B      P      88          2.114
LGA    L   100_B      G      89          2.501
LGA    E   101_B      K      90          6.472
LGA    S   102_B      P      91           -
LGA    S   103_B      E      92           -
LGA    I   104_B      I      93           -
LGA    -       -      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   95    5.0     88    1.87    27.27     85.637     4.457

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.859615 * X  +   0.510747 * Y  +   0.014098 * Z  +  29.671843
  Y_new =  -0.273260 * X  +  -0.482876 * Y  +   0.831961 * Z  +   0.722406
  Z_new =   0.431729 * X  +   0.711314 * Y  +   0.554654 * Z  + -15.924755 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.908519   -2.233073  [ DEG:    52.0543   -127.9457 ]
  Theta =  -0.446409   -2.695184  [ DEG:   -25.5774   -154.4226 ]
  Phi   =  -2.833808    0.307785  [ DEG:  -162.3652     17.6348 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jik_B                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jik_B.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   95   5.0   88   1.87   27.27  85.637
REMARK  ---------------------------------------------------------- 
MOLECULE 2jik_B
HEADER    MEMBRANE PROTEIN                        28-JUN-07   2JIK              
TITLE     CRYSTAL STRUCTURE OF PDZ DOMAIN OF SYNAPTOJANIN-2 BINDING             
TITLE    2 PROTEIN                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SYNAPTOJANIN-2 BINDING PROTEIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: PDZ DOMAIN, RESIDUES 6-100;                                
COMPND   5 SYNONYM: MITOCHONDRIAL OUTER MEMBRANE PROTEIN 25;                    
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VARIANT: R3-PRARE2;                                
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    TRANSMEMBRANE, OUTER MEMBRANE, MITOCHONDRIA DISTRIBUTION,             
KEYWDS   2 PDZ, MEMBRANE, SCAFFOLD, MITOCHONDRION, MEMBRANE PROTEIN             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.TICKLE,C.PHILLIPS,A.C.W.PIKE,C.COOPER,E.SALAH,J.ELKINS,             
AUTHOR   2 A.P.TURNBULL,A.EDWARDS,C.H.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,         
AUTHOR   3 D.DOYLE                                                              
REVDAT   1   10-JUL-07 2JIK    0                                                
JRNL        AUTH   J.TICKLE,C.PHILLIPS,A.C.W.PIKE,C.COOPER,E.SALAH,             
JRNL        AUTH 2 J.ELKINS,A.P.TURNBULL,A.EDWARDS,C.H.ARROWSMITH,              
JRNL        AUTH 3 J.WEIGELT,M.SUNDSTROM,D.DOYLE                                
JRNL        TITL   CRYSTAL STRUCTURE OF PDZ DOMAIN OF SYNAPTOJANIN-2            
JRNL        TITL 2 BINDING PROTEIN                                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.35 ANGSTROMS.                                          
DBREF  2JIK A   -1     0  PDB    2JIK     2JIK            -1      0             
DBREF  2JIK A    6   100  UNP    P57105   SYJ2B_HUMAN      6    100             
DBREF  2JIK A  101   104  PDB    2JIK     2JIK            101   104             
DBREF  2JIK B   -1     0  PDB    2JIK     2JIK            -1      0             
DBREF  2JIK B    6   100  UNP    P57105   SYJ2B_HUMAN      6    100             
DBREF  2JIK B  101   104  PDB    2JIK     2JIK            101   104             
SEQRES   1 A  101  SER MET ASP TYR LEU VAL THR GLU GLU GLU ILE ASN LEU          
SEQRES   2 A  101  THR ARG GLY PRO SER GLY LEU GLY PHE ASN ILE VAL GLY          
SEQRES   3 A  101  GLY THR ASP GLN GLN TYR VAL SER ASN ASP SER GLY ILE          
SEQRES   4 A  101  TYR VAL SER ARG ILE LYS GLU ASN GLY ALA ALA ALA LEU          
SEQRES   5 A  101  ASP GLY ARG LEU GLN GLU GLY ASP LYS ILE LEU SER VAL          
SEQRES   6 A  101  ASN GLY GLN ASP LEU LYS ASN LEU LEU HIS GLN ASP ALA          
SEQRES   7 A  101  VAL ASP LEU PHE ARG ASN ALA GLY TYR ALA VAL SER LEU          
SEQRES   8 A  101  ARG VAL GLN HIS ARG LEU GLU SER SER ILE                      
SEQRES   1 B  101  SER MET ASP TYR LEU VAL THR GLU GLU GLU ILE ASN LEU          
SEQRES   2 B  101  THR ARG GLY PRO SER GLY LEU GLY PHE ASN ILE VAL GLY          
SEQRES   3 B  101  GLY THR ASP GLN GLN TYR VAL SER ASN ASP SER GLY ILE          
SEQRES   4 B  101  TYR VAL SER ARG ILE LYS GLU ASN GLY ALA ALA ALA LEU          
SEQRES   5 B  101  ASP GLY ARG LEU GLN GLU GLY ASP LYS ILE LEU SER VAL          
SEQRES   6 B  101  ASN GLY GLN ASP LEU LYS ASN LEU LEU HIS GLN ASP ALA          
SEQRES   7 B  101  VAL ASP LEU PHE ARG ASN ALA GLY TYR ALA VAL SER LEU          
SEQRES   8 B  101  ARG VAL GLN HIS ARG LEU GLU SER SER ILE                      
FORMUL   3  HOH   *237(H2 O)                                                    
CRYST1   36.482   38.335   60.745  90.00 101.01  90.00 P 1 21 1      4          
ATOM    808  N   SER B  -1      25.056  15.741  30.084  1.00 28.79           N  
ATOM    809  CA  SER B  -1      24.188  15.882  28.875  1.00 25.30           C  
ATOM    810  C   SER B  -1      23.632  14.518  28.443  1.00 24.82           C  
ATOM    811  O   SER B  -1      24.227  13.486  28.760  1.00 29.42           O  
ATOM    812  CB  SER B  -1      24.988  16.510  27.730  1.00 27.01           C  
ATOM    813  N   MET B   0      22.485  14.517  27.750  1.00 19.40           N  
ATOM    814  CA  MET B   0      21.907  13.282  27.171  1.00 16.66           C  
ATOM    815  C   MET B   0      22.012  13.304  25.634  1.00 12.86           C  
ATOM    816  O   MET B   0      21.062  13.007  24.896  1.00 12.34           O  
ATOM    817  CB  MET B   0      20.446  13.071  27.610  1.00 18.01           C  
ATOM    818  CG  MET B   0      20.271  12.840  29.118  1.00 18.01           C  
ATOM    819  SD  MET B   0      18.563  12.569  29.643  1.00 25.73           S  
ATOM    820  CE  MET B   0      17.862  14.180  29.315  1.00 27.81           C  
ATOM    821  N   ASP B   6      23.203  13.636  25.159  1.00 12.50           N  
ATOM    822  CA  ASP B   6      23.472  13.677  23.716  1.00 11.41           C  
ATOM    823  C   ASP B   6      23.177  12.372  22.993  1.00  9.43           C  
ATOM    824  O   ASP B   6      22.889  12.381  21.789  1.00 10.34           O  
ATOM    825  CB  ASP B   6      24.924  14.067  23.455  1.00 14.20           C  
ATOM    826  CG  ASP B   6      25.229  15.483  23.888  1.00 12.80           C  
ATOM    827  OD1 ASP B   6      24.287  16.275  24.125  1.00 18.60           O  
ATOM    828  OD2 ASP B   6      26.422  15.807  23.986  1.00 18.58           O  
ATOM    829  N   TYR B   7      23.243  11.258  23.734  1.00  9.71           N  
ATOM    830  CA  TYR B   7      23.025   9.925  23.166  1.00  9.21           C  
ATOM    831  C   TYR B   7      21.590   9.695  22.693  1.00 10.68           C  
ATOM    832  O   TYR B   7      21.339   8.732  21.955  1.00 13.44           O  
ATOM    833  CB  TYR B   7      23.431   8.816  24.149  1.00 13.30           C  
ATOM    834  CG  TYR B   7      22.835   8.965  25.526  1.00 16.78           C  
ATOM    835  CD1 TYR B   7      23.471   9.737  26.507  1.00 16.99           C  
ATOM    836  CD2 TYR B   7      21.634   8.348  25.852  1.00 20.00           C  
ATOM    837  CE1 TYR B   7      22.930   9.878  27.782  1.00 14.25           C  
ATOM    838  CE2 TYR B   7      21.074   8.485  27.124  1.00 18.66           C  
ATOM    839  CZ  TYR B   7      21.727   9.255  28.082  1.00 19.10           C  
ATOM    840  OH  TYR B   7      21.183   9.386  29.345  1.00 22.23           O  
ATOM    841  N   LEU B   8      20.671  10.565  23.116  1.00  9.88           N  
ATOM    842  CA  LEU B   8      19.277  10.489  22.669  1.00  9.25           C  
ATOM    843  C   LEU B   8      19.009  11.104  21.299  1.00  9.51           C  
ATOM    844  O   LEU B   8      17.906  10.984  20.826  1.00 10.15           O  
ATOM    845  CB  LEU B   8      18.358  11.162  23.698  1.00 12.72           C  
ATOM    846  CG  LEU B   8      18.395  10.565  25.108  1.00 16.23           C  
ATOM    847  CD1 LEU B   8      17.490  11.329  26.068  1.00 19.51           C  
ATOM    848  CD2 LEU B   8      18.015   9.101  25.059  1.00 17.20           C  
ATOM    849  N   VAL B   9      19.997  11.790  20.708  1.00  7.53           N  
ATOM    850  CA  VAL B   9      19.834  12.530  19.467  1.00  9.23           C  
ATOM    851  C   VAL B   9      20.992  12.273  18.516  1.00  6.76           C  
ATOM    852  O   VAL B   9      22.121  12.177  18.936  1.00  8.86           O  
ATOM    853  CB  VAL B   9      19.693  14.048  19.716  0.60  9.94           C  
ATOM    855  CG1 VAL B   9      18.380  14.360  20.417  0.60 12.57           C  
ATOM    857  CG2 VAL B   9      20.828  14.566  20.548  0.60 11.08           C  
ATOM    859  N   THR B  10      20.666  12.164  17.225  0.50  8.72           N  
ATOM    861  CA  THR B  10      21.637  12.018  16.151  0.50  8.16           C  
ATOM    863  C   THR B  10      21.160  12.834  14.955  0.50  8.15           C  
ATOM    865  O   THR B  10      20.006  12.724  14.558  0.50  8.51           O  
ATOM    867  CB  THR B  10      21.805  10.551  15.693  0.50  8.62           C  
ATOM    869  OG1 THR B  10      20.678  10.154  14.907  0.50 19.30           O  
ATOM    871  CG2 THR B  10      21.953   9.614  16.871  0.50 11.95           C  
ATOM    873  N   GLU B  11      22.041  13.655  14.394  0.50  7.12           N  
ATOM    875  CA  GLU B  11      21.690  14.442  13.229  0.50  8.04           C  
ATOM    877  C   GLU B  11      21.966  13.736  11.910  0.50  7.43           C  
ATOM    879  O   GLU B  11      22.777  12.805  11.837  0.50  9.93           O  
ATOM    881  CB  GLU B  11      22.395  15.791  13.273  0.50 11.41           C  
ATOM    883  CG  GLU B  11      21.874  16.679  14.396  0.50 14.26           C  
ATOM    885  CD  GLU B  11      22.323  18.123  14.279  0.50 15.23           C  
ATOM    887  OE1 GLU B  11      22.775  18.529  13.186  0.50 19.16           O  
ATOM    889  OE2 GLU B  11      22.211  18.856  15.289  0.50 25.99           O  
ATOM    891  N   GLU B  12      21.266  14.176  10.870  1.00  7.98           N  
ATOM    892  CA  GLU B  12      21.477  13.680   9.527  1.00  8.89           C  
ATOM    893  C   GLU B  12      21.063  14.746   8.532  1.00  7.38           C  
ATOM    894  O   GLU B  12      20.035  15.383   8.724  1.00  7.35           O  
ATOM    895  CB  GLU B  12      20.619  12.425   9.281  1.00  8.24           C  
ATOM    896  CG  GLU B  12      21.041  11.652   8.018  1.00 11.64           C  
ATOM    897  CD  GLU B  12      20.375  10.317   7.829  1.00 11.12           C  
ATOM    898  OE1 GLU B  12      19.399   9.983   8.515  1.00 10.71           O  
ATOM    899  OE2 GLU B  12      20.821   9.570   6.937  1.00 13.42           O  
ATOM    900  N   GLU B  13      21.827  14.885   7.451  1.00  8.12           N  
ATOM    901  CA  GLU B  13      21.391  15.638   6.272  1.00  6.55           C  
ATOM    902  C   GLU B  13      20.632  14.697   5.363  1.00  7.58           C  
ATOM    903  O   GLU B  13      21.134  13.630   5.037  1.00  9.55           O  
ATOM    904  CB  GLU B  13      22.604  16.226   5.536  1.00  9.43           C  
ATOM    905  CG  GLU B  13      22.306  17.380   4.551  1.00 13.69           C  
ATOM    906  CD  GLU B  13      22.143  18.756   5.232  1.00 14.01           C  
ATOM    907  OE1 GLU B  13      22.280  18.875   6.473  1.00 16.58           O  
ATOM    908  OE2 GLU B  13      21.887  19.718   4.503  1.00 21.30           O  
ATOM    909  N   ILE B  14      19.421  15.092   4.970  1.00  6.35           N  
ATOM    910  CA  ILE B  14      18.571  14.310   4.072  1.00  7.41           C  
ATOM    911  C   ILE B  14      18.221  15.230   2.911  1.00  7.98           C  
ATOM    912  O   ILE B  14      17.772  16.354   3.115  1.00 12.08           O  
ATOM    913  CB  ILE B  14      17.290  13.843   4.774  1.00  7.10           C  
ATOM    914  CG1 ILE B  14      17.630  12.934   5.956  1.00  8.90           C  
ATOM    915  CG2 ILE B  14      16.307  13.183   3.793  1.00  8.35           C  
ATOM    916  CD1 ILE B  14      16.417  12.571   6.798  1.00  8.88           C  
ATOM    917  N   ASN B  15      18.409  14.737   1.693  1.00  6.80           N  
ATOM    918  CA  ASN B  15      18.174  15.480   0.488  1.00  6.60           C  
ATOM    919  C   ASN B  15      17.124  14.741  -0.301  1.00  6.51           C  
ATOM    920  O   ASN B  15      17.342  13.590  -0.678  1.00  8.33           O  
ATOM    921  CB  ASN B  15      19.456  15.609  -0.324  1.00  8.66           C  
ATOM    922  CG  ASN B  15      20.478  16.429   0.369  1.00 11.25           C  
ATOM    923  OD1 ASN B  15      20.431  17.648   0.315  1.00 19.95           O  
ATOM    924  ND2 ASN B  15      21.386  15.774   1.059  1.00 11.75           N  
ATOM    925  N   LEU B  16      15.988  15.400  -0.523  1.00  7.09           N  
ATOM    926  CA  LEU B  16      14.848  14.820  -1.206  1.00  7.34           C  
ATOM    927  C   LEU B  16      14.622  15.472  -2.555  1.00  7.94           C  
ATOM    928  O   LEU B  16      14.891  16.665  -2.739  1.00  9.03           O  
ATOM    929  CB  LEU B  16      13.579  14.995  -0.363  1.00  6.39           C  
ATOM    930  CG  LEU B  16      13.560  14.369   1.013  1.00  6.43           C  
ATOM    931  CD1 LEU B  16      12.217  14.647   1.710  1.00  8.53           C  
ATOM    932  CD2 LEU B  16      13.823  12.884   0.930  1.00  7.37           C  
ATOM    933  N   THR B  17      14.122  14.677  -3.493  1.00  8.21           N  
ATOM    934  CA  THR B  17      13.612  15.142  -4.763  1.00  9.13           C  
ATOM    935  C   THR B  17      12.091  15.104  -4.697  1.00 10.62           C  
ATOM    936  O   THR B  17      11.487  14.065  -4.431  1.00  9.68           O  
ATOM    937  CB  THR B  17      14.092  14.240  -5.911  1.00  9.14           C  
ATOM    938  OG1 THR B  17      15.521  14.288  -5.975  1.00  9.31           O  
ATOM    939  CG2 THR B  17      13.522  14.715  -7.243  1.00 10.35           C  
ATOM    940  N   ARG B  18      11.466  16.238  -4.962  1.00 10.81           N  
ATOM    941  CA  ARG B  18      10.022  16.348  -4.873  1.00 12.20           C  
ATOM    942  C   ARG B  18       9.337  15.433  -5.885  1.00 12.57           C  
ATOM    943  O   ARG B  18       9.756  15.362  -7.039  1.00 14.27           O  
ATOM    944  CB  ARG B  18       9.604  17.797  -5.072  1.00 13.04           C  
ATOM    945  CG  ARG B  18       8.129  18.051  -4.832  1.00 15.93           C  
ATOM    946  CD  ARG B  18       7.762  19.492  -5.168  1.00 21.55           C  
ATOM    947  NE  ARG B  18       8.432  20.439  -4.282  1.00 31.79           N  
ATOM    948  CZ  ARG B  18       8.121  20.615  -2.997  1.00 35.77           C  
ATOM    949  NH1 ARG B  18       7.128  19.930  -2.436  1.00 39.65           N  
ATOM    950  NH2 ARG B  18       8.800  21.492  -2.262  1.00 32.85           N  
ATOM    951  N   GLY B  19       8.311  14.723  -5.426  1.00 14.05           N  
ATOM    952  CA  GLY B  19       7.500  13.877  -6.291  1.00 18.24           C  
ATOM    953  C   GLY B  19       6.312  14.650  -6.810  1.00 20.89           C  
ATOM    954  O   GLY B  19       6.109  15.813  -6.434  1.00 18.10           O  
ATOM    955  N   PRO B  20       5.505  14.006  -7.669  1.00 23.49           N  
ATOM    956  CA  PRO B  20       4.325  14.653  -8.223  1.00 26.36           C  
ATOM    957  C   PRO B  20       3.192  14.841  -7.208  1.00 26.07           C  
ATOM    958  O   PRO B  20       2.141  15.351  -7.581  1.00 30.76           O  
ATOM    959  CB  PRO B  20       3.897  13.696  -9.344  1.00 26.12           C  
ATOM    960  CG  PRO B  20       4.345  12.365  -8.879  1.00 28.63           C  
ATOM    961  CD  PRO B  20       5.663  12.631  -8.176  1.00 21.97           C  
ATOM    962  N   SER B  21       3.402  14.423  -5.956  1.00 22.40           N  
ATOM    963  CA  SER B  21       2.490  14.723  -4.853  1.00 21.09           C  
ATOM    964  C   SER B  21       3.171  15.484  -3.701  1.00 20.85           C  
ATOM    965  O   SER B  21       2.596  15.598  -2.621  1.00 22.02           O  
ATOM    966  CB  SER B  21       1.899  13.427  -4.306  1.00 26.35           C  
ATOM    967  OG  SER B  21       2.918  12.621  -3.728  1.00 34.95           O  
ATOM    968  N   GLY B  22       4.383  15.994  -3.921  1.00 20.03           N  
ATOM    969  CA  GLY B  22       5.103  16.766  -2.896  1.00 18.20           C  
ATOM    970  C   GLY B  22       6.206  15.944  -2.248  1.00 13.62           C  
ATOM    971  O   GLY B  22       6.719  15.008  -2.863  1.00 14.92           O  
ATOM    972  N   LEU B  23       6.578  16.291  -1.014  1.00 12.91           N  
ATOM    973  CA  LEU B  23       7.677  15.589  -0.329  1.00 11.13           C  
ATOM    974  C   LEU B  23       7.190  14.331   0.393  1.00 11.05           C  
ATOM    975  O   LEU B  23       7.990  13.429   0.684  1.00 10.77           O  
ATOM    976  CB  LEU B  23       8.383  16.537   0.655  1.00 12.24           C  
ATOM    977  CG  LEU B  23       9.110  17.744   0.030  1.00 11.26           C  
ATOM    978  CD1 LEU B  23       9.891  18.508   1.107  1.00 18.99           C  
ATOM    979  CD2 LEU B  23      10.027  17.287  -1.092  1.00 18.96           C  
ATOM    980  N   GLY B  24       5.907  14.304   0.742  1.00 11.81           N  
ATOM    981  CA  GLY B  24       5.311  13.123   1.342  1.00 12.60           C  
ATOM    982  C   GLY B  24       5.440  12.967   2.846  1.00 10.50           C  
ATOM    983  O   GLY B  24       5.545  11.853   3.373  1.00 11.19           O  
ATOM    984  N   PHE B  25       5.364  14.076   3.570  1.00  7.54           N  
ATOM    985  CA  PHE B  25       5.287  13.988   5.028  1.00  9.95           C  
ATOM    986  C   PHE B  25       4.491  15.156   5.562  1.00  9.69           C  
ATOM    987  O   PHE B  25       4.301  16.161   4.851  1.00 10.94           O  
ATOM    988  CB  PHE B  25       6.666  13.881   5.694  1.00  8.06           C  
ATOM    989  CG  PHE B  25       7.578  15.021   5.433  1.00  8.29           C  
ATOM    990  CD1 PHE B  25       8.380  15.048   4.287  1.00  8.15           C  
ATOM    991  CD2 PHE B  25       7.649  16.082   6.344  1.00  8.49           C  
ATOM    992  CE1 PHE B  25       9.239  16.101   4.072  1.00 10.50           C  
ATOM    993  CE2 PHE B  25       8.504  17.133   6.126  1.00 10.36           C  
ATOM    994  CZ  PHE B  25       9.295  17.152   4.990  1.00 10.78           C  
ATOM    995  N   ASN B  26       4.022  14.995   6.794  1.00  9.48           N  
ATOM    996  CA  ASN B  26       3.307  16.042   7.507  1.00  9.72           C  
ATOM    997  C   ASN B  26       4.209  16.562   8.614  1.00  9.80           C  
ATOM    998  O   ASN B  26       4.996  15.804   9.201  1.00  9.13           O  
ATOM    999  CB  ASN B  26       2.029  15.513   8.175  1.00 11.30           C  
ATOM   1000  CG  ASN B  26       0.997  15.042   7.193  1.00 14.28           C  
ATOM   1001  OD1 ASN B  26       1.085  15.297   5.993  1.00 16.04           O  
ATOM   1002  ND2 ASN B  26       0.019  14.309   7.696  1.00 16.01           N  
ATOM   1003  N   ILE B  27       4.036  17.841   8.935  1.00  8.34           N  
ATOM   1004  CA  ILE B  27       4.731  18.475  10.035  1.00  7.61           C  
ATOM   1005  C   ILE B  27       3.786  19.059  11.064  1.00  7.46           C  
ATOM   1006  O   ILE B  27       2.703  19.529  10.739  1.00  9.63           O  
ATOM   1007  CB  ILE B  27       5.721  19.556   9.562  1.00  7.34           C  
ATOM   1008  CG1 ILE B  27       5.039  20.688   8.785  1.00  9.52           C  
ATOM   1009  CG2 ILE B  27       6.870  18.887   8.794  1.00  9.25           C  
ATOM   1010  CD1 ILE B  27       5.996  21.801   8.445  1.00 11.44           C  
ATOM   1011  N   VAL B  28       4.221  19.006  12.313  1.00  8.80           N  
ATOM   1012  CA  VAL B  28       3.589  19.724  13.397  1.00  7.89           C  
ATOM   1013  C   VAL B  28       4.592  20.682  14.022  1.00  8.05           C  
ATOM   1014  O   VAL B  28       5.810  20.573  13.831  1.00  8.48           O  
ATOM   1015  CB  VAL B  28       3.090  18.775  14.482  1.00 11.43           C  
ATOM   1016  CG1 VAL B  28       1.999  17.839  13.892  1.00 12.91           C  
ATOM   1017  CG2 VAL B  28       4.283  18.005  15.124  1.00 10.97           C  
ATOM   1018  N   GLY B  29       4.079  21.614  14.798  1.00  9.19           N  
ATOM   1019  CA  GLY B  29       4.921  22.483  15.594  1.00  9.49           C  
ATOM   1020  C   GLY B  29       4.852  23.944  15.278  1.00 11.31           C  
ATOM   1021  O   GLY B  29       4.025  24.418  14.496  1.00 13.57           O  
ATOM   1022  N   GLY B  30       5.778  24.667  15.875  1.00 10.34           N  
ATOM   1023  CA  GLY B  30       5.761  26.095  15.831  1.00 10.17           C  
ATOM   1024  C   GLY B  30       5.394  26.620  17.198  1.00 10.44           C  
ATOM   1025  O   GLY B  30       4.884  25.894  18.073  1.00 11.81           O  
ATOM   1026  N   THR B  31       5.693  27.887  17.383  1.00 10.77           N  
ATOM   1027  CA  THR B  31       5.466  28.550  18.661  1.00 10.67           C  
ATOM   1028  C   THR B  31       3.978  28.607  19.038  1.00 14.55           C  
ATOM   1029  O   THR B  31       3.657  28.790  20.210  1.00 16.79           O  
ATOM   1030  CB  THR B  31       6.069  29.952  18.630  1.00 12.52           C  
ATOM   1031  OG1 THR B  31       5.521  30.655  17.517  1.00 12.88           O  
ATOM   1032  CG2 THR B  31       7.577  29.897  18.540  1.00 14.16           C  
ATOM   1033  N   ASP B  32       3.088  28.431  18.058  1.00 14.11           N  
ATOM   1034  CA  ASP B  32       1.627  28.353  18.313  1.00 13.50           C  
ATOM   1035  C   ASP B  32       1.115  26.920  18.638  1.00 16.45           C  
ATOM   1036  O   ASP B  32      -0.087  26.734  18.917  1.00 19.66           O  
ATOM   1037  CB  ASP B  32       0.789  29.046  17.204  1.00 20.45           C  
ATOM   1038  CG  ASP B  32       1.461  29.061  15.821  1.00 21.86           C  
ATOM   1039  OD1 ASP B  32       2.338  28.210  15.554  1.00 16.31           O  
ATOM   1040  OD2 ASP B  32       1.083  29.941  14.995  1.00 20.55           O  
ATOM   1041  N   GLN B  33       2.025  25.944  18.676  1.00 14.30           N  
ATOM   1042  CA  GLN B  33       1.730  24.573  19.106  1.00 17.92           C  
ATOM   1043  C   GLN B  33       2.571  24.106  20.299  1.00 17.34           C  
ATOM   1044  O   GLN B  33       2.586  22.892  20.650  1.00 17.48           O  
ATOM   1045  CB  GLN B  33       1.960  23.629  17.944  1.00 15.65           C  
ATOM   1046  CG  GLN B  33       1.098  23.984  16.734  1.00 18.27           C  
ATOM   1047  CD  GLN B  33       1.060  22.867  15.707  1.00 16.75           C  
ATOM   1048  OE1 GLN B  33       1.524  21.772  15.965  1.00 15.73           O  
ATOM   1049  NE2 GLN B  33       0.541  23.162  14.527  1.00 15.72           N  
ATOM   1050  N   GLN B  34       3.264  25.050  20.944  1.00 19.59           N  
ATOM   1051  CA  GLN B  34       4.049  24.740  22.137  1.00 20.45           C  
ATOM   1052  C   GLN B  34       3.170  24.253  23.308  1.00 22.79           C  
ATOM   1053  O   GLN B  34       3.654  23.529  24.210  1.00 20.03           O  
ATOM   1054  CB  GLN B  34       4.911  25.943  22.552  1.00 22.56           C  
ATOM   1055  CG  GLN B  34       5.900  25.619  23.678  1.00 21.26           C  
ATOM   1056  CD  GLN B  34       6.966  26.675  23.873  1.00 25.20           C  
ATOM   1057  OE1 GLN B  34       6.722  27.875  23.690  1.00 25.68           O  
ATOM   1058  NE2 GLN B  34       8.160  26.235  24.271  1.00 30.27           N  
ATOM   1059  N   TYR B  35       1.886  24.617  23.291  1.00 19.79           N  
ATOM   1060  CA  TYR B  35       0.939  24.143  24.306  1.00 23.00           C  
ATOM   1061  C   TYR B  35       0.749  22.629  24.228  1.00 26.65           C  
ATOM   1062  O   TYR B  35       0.285  22.009  25.195  1.00 24.12           O  
ATOM   1063  CB  TYR B  35      -0.415  24.853  24.161  1.00 25.13           C  
ATOM   1064  CG  TYR B  35      -1.290  24.341  23.034  1.00 21.45           C  
ATOM   1065  CD1 TYR B  35      -1.175  24.855  21.745  1.00 20.49           C  
ATOM   1066  CD2 TYR B  35      -2.244  23.355  23.261  1.00 29.14           C  
ATOM   1067  CE1 TYR B  35      -1.974  24.388  20.711  1.00 22.74           C  
ATOM   1068  CE2 TYR B  35      -3.049  22.881  22.233  1.00 30.92           C  
ATOM   1069  CZ  TYR B  35      -2.907  23.402  20.962  1.00 27.88           C  
ATOM   1070  OH  TYR B  35      -3.701  22.938  19.940  1.00 25.63           O  
ATOM   1071  N   ASP B  39       7.211  22.214  23.551  1.00 23.24           N  
ATOM   1072  CA  ASP B  39       8.299  22.784  22.726  1.00 25.07           C  
ATOM   1073  C   ASP B  39       7.860  23.225  21.314  1.00 24.20           C  
ATOM   1074  O   ASP B  39       6.820  22.785  20.811  1.00 27.46           O  
ATOM   1075  CB  ASP B  39       9.478  21.809  22.644  1.00 29.47           C  
ATOM   1076  CG  ASP B  39       9.090  20.452  22.047  1.00 35.75           C  
ATOM   1077  OD1 ASP B  39       7.937  20.294  21.594  1.00 33.57           O  
ATOM   1078  OD2 ASP B  39       9.942  19.535  22.038  1.00 48.87           O  
ATOM   1079  N   SER B  40       8.653  24.086  20.675  1.00 17.34           N  
ATOM   1080  CA  SER B  40       8.155  24.797  19.463  1.00 13.47           C  
ATOM   1081  C   SER B  40       8.803  24.418  18.127  1.00 12.20           C  
ATOM   1082  O   SER B  40       8.533  25.061  17.096  1.00 13.59           O  
ATOM   1083  CB  SER B  40       8.299  26.301  19.637  0.50 11.91           C  
ATOM   1085  OG  SER B  40       7.560  26.766  20.748  0.50  8.71           O  
ATOM   1087  N   GLY B  41       9.633  23.379  18.146  1.00 11.87           N  
ATOM   1088  CA  GLY B  41      10.306  22.925  16.956  1.00 10.48           C  
ATOM   1089  C   GLY B  41       9.324  22.361  15.981  1.00 11.97           C  
ATOM   1090  O   GLY B  41       8.152  22.131  16.292  1.00 12.47           O  
ATOM   1091  N   ILE B  42       9.830  22.140  14.784  1.00  7.38           N  
ATOM   1092  CA  ILE B  42       9.061  21.528  13.719  1.00  6.42           C  
ATOM   1093  C   ILE B  42       9.397  20.046  13.707  1.00  6.23           C  
ATOM   1094  O   ILE B  42      10.569  19.681  13.618  1.00  7.21           O  
ATOM   1095  CB  ILE B  42       9.378  22.187  12.349  1.00  7.60           C  
ATOM   1096  CG1 ILE B  42       9.101  23.696  12.414  1.00  7.66           C  
ATOM   1097  CG2 ILE B  42       8.649  21.468  11.226  1.00  7.25           C  
ATOM   1098  CD1 ILE B  42       7.668  24.048  12.775  1.00 12.35           C  
ATOM   1099  N   TYR B  43       8.370  19.207  13.791  1.00  6.62           N  
ATOM   1100  CA  TYR B  43       8.553  17.757  13.861  1.00  6.63           C  
ATOM   1101  C   TYR B  43       7.745  17.048  12.783  1.00  6.78           C  
ATOM   1102  O   TYR B  43       6.662  17.493  12.417  1.00  8.68           O  
ATOM   1103  CB  TYR B  43       8.148  17.201  15.237  1.00  8.88           C  
ATOM   1104  CG  TYR B  43       8.944  17.780  16.364  1.00 11.14           C  
ATOM   1105  CD1 TYR B  43      10.041  17.102  16.883  1.00 10.88           C  
ATOM   1106  CD2 TYR B  43       8.610  19.002  16.905  1.00  9.54           C  
ATOM   1107  CE1 TYR B  43      10.783  17.640  17.930  1.00 13.92           C  
ATOM   1108  CE2 TYR B  43       9.352  19.560  17.949  1.00 14.50           C  
ATOM   1109  CZ  TYR B  43      10.451  18.868  18.450  1.00 14.05           C  
ATOM   1110  OH  TYR B  43      11.200  19.389  19.484  1.00 16.33           O  
ATOM   1111  N   VAL B  44       8.267  15.912  12.340  1.00  7.88           N  
ATOM   1112  CA  VAL B  44       7.558  15.057  11.390  1.00  7.63           C  
ATOM   1113  C   VAL B  44       6.504  14.259  12.158  1.00  8.11           C  
ATOM   1114  O   VAL B  44       6.827  13.520  13.077  1.00 11.08           O  
ATOM   1115  CB  VAL B  44       8.532  14.086  10.708  1.00  8.38           C  
ATOM   1116  CG1 VAL B  44       7.819  13.150   9.785  1.00 10.69           C  
ATOM   1117  CG2 VAL B  44       9.604  14.891   9.951  1.00  8.94           C  
ATOM   1118  N   SER B  45       5.237  14.450  11.812  1.00  9.37           N  
ATOM   1119  CA  SER B  45       4.172  13.689  12.483  1.00  9.78           C  
ATOM   1120  C   SER B  45       3.782  12.412  11.746  1.00 12.46           C  
ATOM   1121  O   SER B  45       3.314  11.467  12.364  1.00 17.72           O  
ATOM   1122  CB  SER B  45       2.930  14.556  12.638  1.00 10.96           C  
ATOM   1123  OG  SER B  45       2.543  15.109  11.385  1.00 11.19           O  
ATOM   1124  N   ARG B  46       3.945  12.396  10.425  1.00  9.60           N  
ATOM   1125  CA  ARG B  46       3.586  11.257   9.605  1.00 12.80           C  
ATOM   1126  C   ARG B  46       4.391  11.273   8.321  1.00 11.79           C  
ATOM   1127  O   ARG B  46       4.644  12.320   7.741  1.00 13.60           O  
ATOM   1128  CB  ARG B  46       2.088  11.299   9.256  1.00 18.34           C  
ATOM   1129  CG  ARG B  46       1.611  10.069   8.502  1.00 28.49           C  
ATOM   1130  N   ILE B  47       4.779  10.092   7.870  1.00 11.35           N  
ATOM   1131  CA  ILE B  47       5.375   9.929   6.561  1.00 13.03           C  
ATOM   1132  C   ILE B  47       4.405   9.124   5.690  1.00 15.15           C  
ATOM   1133  O   ILE B  47       3.988   8.028   6.062  1.00 15.99           O  
ATOM   1134  CB  ILE B  47       6.714   9.218   6.680  1.00 12.99           C  
ATOM   1135  CG1 ILE B  47       7.655  10.077   7.535  1.00 12.19           C  
ATOM   1136  CG2 ILE B  47       7.288   8.959   5.307  1.00 13.68           C  
ATOM   1137  CD1 ILE B  47       8.978   9.482   7.753  1.00 17.25           C  
ATOM   1138  N   LYS B  48       4.080   9.675   4.526  1.00 13.99           N  
ATOM   1139  CA  LYS B  48       3.100   9.097   3.621  1.00 17.04           C  
ATOM   1140  C   LYS B  48       3.638   7.864   2.883  1.00 16.53           C  
ATOM   1141  O   LYS B  48       4.739   7.872   2.344  1.00 13.89           O  
ATOM   1142  CB  LYS B  48       2.650  10.159   2.614  1.00 16.35           C  
ATOM   1143  CG  LYS B  48       2.083  11.415   3.253  1.00 26.33           C  
ATOM   1144  N   GLU B  49       2.826   6.815   2.830  1.00 19.49           N  
ATOM   1145  CA  GLU B  49       3.190   5.611   2.104  1.00 20.13           C  
ATOM   1146  C   GLU B  49       3.477   5.986   0.652  1.00 19.91           C  
ATOM   1147  O   GLU B  49       2.765   6.806   0.073  1.00 18.82           O  
ATOM   1148  CB  GLU B  49       2.039   4.603   2.153  1.00 24.40           C  
ATOM   1149  CG  GLU B  49       2.388   3.234   1.605  1.00 32.44           C  
ATOM   1150  N   ASN B  50       4.547   5.420   0.094  1.00 22.59           N  
ATOM   1151  CA  ASN B  50       4.952   5.630  -1.296  1.00 20.70           C  
ATOM   1152  C   ASN B  50       5.219   7.080  -1.720  1.00 20.37           C  
ATOM   1153  O   ASN B  50       5.293   7.376  -2.917  1.00 20.39           O  
ATOM   1154  CB  ASN B  50       3.946   4.953  -2.250  1.00 25.37           C  
ATOM   1155  CG  ASN B  50       3.887   3.437  -2.067  1.00 32.89           C  
ATOM   1156  OD1 ASN B  50       2.803   2.855  -1.960  1.00 44.06           O  
ATOM   1157  ND2 ASN B  50       5.052   2.795  -2.021  1.00 33.77           N  
ATOM   1158  N   GLY B  51       5.413   7.978  -0.750  1.00 15.72           N  
ATOM   1159  CA  GLY B  51       5.800   9.357  -1.060  1.00 13.04           C  
ATOM   1160  C   GLY B  51       7.310   9.491  -1.114  1.00 10.40           C  
ATOM   1161  O   GLY B  51       8.018   8.544  -0.757  1.00 10.79           O  
ATOM   1162  N   ALA B  52       7.806  10.659  -1.526  1.00 10.77           N  
ATOM   1163  CA  ALA B  52       9.254  10.812  -1.743  1.00 10.22           C  
ATOM   1164  C   ALA B  52      10.053  10.508  -0.480  1.00  8.81           C  
ATOM   1165  O   ALA B  52      11.068   9.823  -0.516  1.00  9.15           O  
ATOM   1166  CB  ALA B  52       9.596  12.210  -2.257  1.00 10.27           C  
ATOM   1167  N   ALA B  53       9.617  11.046   0.644  1.00  8.80           N  
ATOM   1168  CA  ALA B  53      10.334  10.819   1.899  1.00  8.14           C  
ATOM   1169  C   ALA B  53      10.372   9.361   2.317  1.00  9.07           C  
ATOM   1170  O   ALA B  53      11.394   8.861   2.831  1.00  8.81           O  
ATOM   1171  CB  ALA B  53       9.721  11.662   3.012  1.00 10.14           C  
ATOM   1172  N   ALA B  54       9.257   8.684   2.113  1.00 10.63           N  
ATOM   1173  CA  ALA B  54       9.169   7.278   2.424  1.00 10.10           C  
ATOM   1174  C   ALA B  54      10.111   6.480   1.533  1.00 11.88           C  
ATOM   1175  O   ALA B  54      10.841   5.635   2.025  1.00 13.36           O  
ATOM   1176  CB  ALA B  54       7.758   6.798   2.278  1.00 13.75           C  
ATOM   1177  N   LEU B  55      10.105   6.779   0.237  1.00 10.80           N  
ATOM   1178  CA  LEU B  55      10.921   6.040  -0.722  1.00 11.03           C  
ATOM   1179  C   LEU B  55      12.402   6.191  -0.466  1.00  8.28           C  
ATOM   1180  O   LEU B  55      13.162   5.247  -0.658  1.00  8.74           O  
ATOM   1181  CB  LEU B  55      10.615   6.493  -2.147  1.00 14.83           C  
ATOM   1182  CG  LEU B  55       9.173   6.266  -2.628  1.00 25.11           C  
ATOM   1183  CD1 LEU B  55       9.016   6.810  -4.026  1.00 27.29           C  
ATOM   1184  CD2 LEU B  55       8.773   4.804  -2.568  1.00 26.10           C  
ATOM   1185  N   ASP B  56      12.810   7.391  -0.058  1.00  8.15           N  
ATOM   1186  CA  ASP B  56      14.199   7.687   0.294  1.00  7.02           C  
ATOM   1187  C   ASP B  56      14.601   6.919   1.555  1.00  6.81           C  
ATOM   1188  O   ASP B  56      15.734   6.432   1.654  1.00  8.70           O  
ATOM   1189  CB  ASP B  56      14.364   9.215   0.489  1.00  6.54           C  
ATOM   1190  CG  ASP B  56      15.699   9.597   1.053  1.00  6.69           C  
ATOM   1191  OD1 ASP B  56      16.609   9.945   0.281  1.00  8.47           O  
ATOM   1192  OD2 ASP B  56      15.819   9.564   2.288  1.00  7.08           O  
ATOM   1193  N   GLY B  57      13.701   6.844   2.530  1.00  9.07           N  
ATOM   1194  CA  GLY B  57      13.868   5.981   3.689  1.00  7.84           C  
ATOM   1195  C   GLY B  57      14.504   6.593   4.919  1.00  9.72           C  
ATOM   1196  O   GLY B  57      14.446   5.979   5.981  1.00 10.30           O  
ATOM   1197  N   ARG B  58      15.147   7.763   4.793  1.00  8.17           N  
ATOM   1198  CA  ARG B  58      15.932   8.298   5.912  1.00  7.77           C  
ATOM   1199  C   ARG B  58      15.085   9.069   6.925  1.00  7.97           C  
ATOM   1200  O   ARG B  58      15.320   9.000   8.122  1.00  9.36           O  
ATOM   1201  CB  ARG B  58      17.078   9.162   5.402  1.00  5.98           C  
ATOM   1202  CG  ARG B  58      18.130   8.343   4.654  1.00  7.85           C  
ATOM   1203  CD  ARG B  58      19.197   9.222   4.038  1.00  8.43           C  
ATOM   1204  NE  ARG B  58      18.684  10.015   2.916  1.00  8.25           N  
ATOM   1205  CZ  ARG B  58      19.418  10.861   2.199  1.00  7.28           C  
ATOM   1206  NH1 ARG B  58      20.674  11.078   2.525  1.00  8.45           N  
ATOM   1207  NH2 ARG B  58      18.878  11.563   1.209  1.00  6.95           N  
ATOM   1208  N   LEU B  59      14.102   9.815   6.453  1.00  6.38           N  
ATOM   1209  CA  LEU B  59      13.277  10.613   7.350  1.00  6.89           C  
ATOM   1210  C   LEU B  59      12.459   9.666   8.233  1.00  7.93           C  
ATOM   1211  O   LEU B  59      11.956   8.638   7.769  1.00 11.09           O  
ATOM   1212  CB  LEU B  59      12.369  11.550   6.560  1.00  6.91           C  
ATOM   1213  CG  LEU B  59      11.694  12.680   7.331  1.00  7.12           C  
ATOM   1214  CD1 LEU B  59      12.719  13.717   7.767  1.00  7.53           C  
ATOM   1215  CD2 LEU B  59      10.608  13.323   6.501  1.00  8.46           C  
ATOM   1216  N   GLN B  60      12.316  10.022   9.503  1.00  8.95           N  
ATOM   1217  CA  GLN B  60      11.587   9.192  10.465  1.00  9.92           C  
ATOM   1218  C   GLN B  60      10.488  10.020  11.146  1.00 11.46           C  
ATOM   1219  O   GLN B  60      10.666  11.211  11.444  1.00 10.13           O  
ATOM   1220  CB  GLN B  60      12.512   8.649  11.570  1.00 12.00           C  
ATOM   1221  CG  GLN B  60      13.755   7.861  11.151  0.50 10.37           C  
ATOM   1223  CD  GLN B  60      14.766   7.655  12.307  0.50 13.48           C  
ATOM   1225  OE1 GLN B  60      14.472   7.913  13.483  0.50 18.98           O  
ATOM   1227  NE2 GLN B  60      15.965   7.197  11.959  0.50 16.93           N  
ATOM   1229  N   GLU B  61       9.379   9.361  11.466  1.00 13.51           N  
ATOM   1230  CA  GLU B  61       8.344   9.985  12.275  1.00 12.96           C  
ATOM   1231  C   GLU B  61       8.995  10.387  13.591  1.00 12.05           C  
ATOM   1232  O   GLU B  61       9.763   9.622  14.192  1.00 16.79           O  
ATOM   1233  CB  GLU B  61       7.148   9.036  12.492  1.00 16.73           C  
ATOM   1234  CG  GLU B  61       6.063   9.577  13.439  1.00 16.41           C  
ATOM   1235  CD  GLU B  61       4.744   8.808  13.362  1.00 24.42           C  
ATOM   1236  OE1 GLU B  61       4.619   7.871  12.530  1.00 37.44           O  
ATOM   1237  OE2 GLU B  61       3.821   9.164  14.126  1.00 31.53           O  
ATOM   1238  N   GLY B  62       8.693  11.597  14.035  1.00 10.03           N  
ATOM   1239  CA  GLY B  62       9.317  12.136  15.235  1.00  9.58           C  
ATOM   1240  C   GLY B  62      10.575  12.965  15.033  1.00  9.27           C  
ATOM   1241  O   GLY B  62      11.035  13.638  15.955  1.00 11.47           O  
ATOM   1242  N   ASP B  63      11.134  12.936  13.827  1.00  8.53           N  
ATOM   1243  CA  ASP B  63      12.334  13.721  13.556  1.00  7.09           C  
ATOM   1244  C   ASP B  63      12.021  15.202  13.754  1.00  7.40           C  
ATOM   1245  O   ASP B  63      10.922  15.675  13.368  1.00  8.01           O  
ATOM   1246  CB  ASP B  63      12.812  13.551  12.112  1.00  7.35           C  
ATOM   1247  CG  ASP B  63      13.578  12.298  11.872  1.00  9.14           C  
ATOM   1248  OD1 ASP B  63      13.872  11.535  12.837  1.00  9.68           O  
ATOM   1249  OD2 ASP B  63      13.860  12.057  10.673  1.00  7.88           O  
ATOM   1250  N   LYS B  64      12.982  15.931  14.329  1.00  6.18           N  
ATOM   1251  CA  LYS B  64      12.924  17.380  14.366  1.00  6.74           C  
ATOM   1252  C   LYS B  64      13.599  17.892  13.089  1.00  6.15           C  
ATOM   1253  O   LYS B  64      14.671  17.430  12.747  1.00  8.16           O  
ATOM   1254  CB  LYS B  64      13.634  17.916  15.618  1.00  7.94           C  
ATOM   1255  CG  LYS B  64      13.438  19.380  15.878  1.00 10.69           C  
ATOM   1256  CD  LYS B  64      14.185  19.780  17.126  1.00 13.32           C  
ATOM   1257  CE  LYS B  64      14.079  21.263  17.403  1.00 16.74           C  
ATOM   1258  NZ  LYS B  64      14.575  21.576  18.782  1.00 21.06           N  
ATOM   1259  N   ILE B  65      13.001  18.862  12.403  1.00  5.71           N  
ATOM   1260  CA  ILE B  65      13.619  19.423  11.214  1.00  5.42           C  
ATOM   1261  C   ILE B  65      14.188  20.786  11.619  1.00  6.13           C  
ATOM   1262  O   ILE B  65      13.451  21.676  12.015  1.00  6.29           O  
ATOM   1263  CB  ILE B  65      12.664  19.535  10.026  1.00  8.19           C  
ATOM   1264  CG1 ILE B  65      12.025  18.176   9.733  1.00 10.03           C  
ATOM   1265  CG2 ILE B  65      13.418  19.968   8.783  1.00  7.15           C  
ATOM   1266  CD1 ILE B  65      11.145  18.162   8.489  1.00 10.88           C  
ATOM   1267  N   LEU B  66      15.509  20.913  11.554  1.00  6.16           N  
ATOM   1268  CA  LEU B  66      16.228  22.101  12.010  1.00  6.13           C  
ATOM   1269  C   LEU B  66      16.322  23.176  10.945  1.00  6.59           C  
ATOM   1270  O   LEU B  66      16.310  24.352  11.249  1.00  8.27           O  
ATOM   1271  CB  LEU B  66      17.623  21.686  12.448  1.00  7.64           C  
ATOM   1272  CG  LEU B  66      17.752  20.696  13.611  1.00 11.00           C  
ATOM   1273  CD1 LEU B  66      19.208  20.285  13.815  1.00 14.27           C  
ATOM   1274  CD2 LEU B  66      17.209  21.309  14.889  1.00 14.38           C  
ATOM   1275  N   SER B  67      16.414  22.765   9.684  1.00  5.84           N  
ATOM   1276  CA  SER B  67      16.484  23.690   8.592  1.00  7.95           C  
ATOM   1277  C   SER B  67      16.011  23.054   7.316  1.00  7.58           C  
ATOM   1278  O   SER B  67      16.090  21.821   7.166  1.00  6.52           O  
ATOM   1279  CB  SER B  67      17.881  24.240   8.415  0.50 10.30           C  
ATOM   1281  OG  SER B  67      18.751  23.210   8.056  0.50  7.53           O  
ATOM   1283  N   VAL B  68      15.537  23.909   6.397  1.00  6.57           N  
ATOM   1284  CA  VAL B  68      15.175  23.482   5.051  1.00  6.20           C  
ATOM   1285  C   VAL B  68      15.837  24.412   4.040  1.00  6.32           C  
ATOM   1286  O   VAL B  68      15.690  25.637   4.111  1.00  7.29           O  
ATOM   1287  CB  VAL B  68      13.639  23.441   4.859  1.00  7.25           C  
ATOM   1288  CG1 VAL B  68      12.975  24.745   5.244  1.00 11.21           C  
ATOM   1289  CG2 VAL B  68      13.301  23.031   3.451  1.00  9.87           C  
ATOM   1290  N   ASN B  69      16.624  23.827   3.155  1.00  7.46           N  
ATOM   1291  CA  ASN B  69      17.434  24.610   2.210  1.00  6.49           C  
ATOM   1292  C   ASN B  69      18.176  25.776   2.849  1.00  6.84           C  
ATOM   1293  O   ASN B  69      18.249  26.883   2.296  1.00  7.88           O  
ATOM   1294  CB  ASN B  69      16.598  25.069   1.015  1.00  8.37           C  
ATOM   1295  CG  ASN B  69      16.208  23.924   0.101  1.00 10.84           C  
ATOM   1296  OD1 ASN B  69      16.893  22.908   0.040  1.00 15.72           O  
ATOM   1297  ND2 ASN B  69      15.108  24.096  -0.635  1.00 18.38           N  
ATOM   1298  N   GLY B  70      18.737  25.501   4.031  1.00  6.83           N  
ATOM   1299  CA  GLY B  70      19.596  26.449   4.709  1.00  8.12           C  
ATOM   1300  C   GLY B  70      18.836  27.525   5.452  1.00  8.59           C  
ATOM   1301  O   GLY B  70      19.440  28.459   5.969  1.00 13.77           O  
ATOM   1302  N   GLN B  71      17.511  27.385   5.510  1.00  6.96           N  
ATOM   1303  CA  GLN B  71      16.654  28.328   6.222  1.00  7.98           C  
ATOM   1304  C   GLN B  71      16.215  27.696   7.532  1.00  7.92           C  
ATOM   1305  O   GLN B  71      15.632  26.619   7.561  1.00  8.44           O  
ATOM   1306  CB  GLN B  71      15.433  28.677   5.395  1.00  8.24           C  
ATOM   1307  CG  GLN B  71      15.765  29.228   4.038  1.00  9.73           C  
ATOM   1308  CD  GLN B  71      14.545  29.412   3.195  1.00 12.98           C  
ATOM   1309  OE1 GLN B  71      13.966  28.445   2.668  1.00 17.19           O  
ATOM   1310  NE2 GLN B  71      14.140  30.643   3.055  1.00 13.60           N  
ATOM   1311  N   ASP B  72      16.513  28.373   8.636  1.00  8.14           N  
ATOM   1312  CA  ASP B  72      16.300  27.809   9.947  1.00 10.04           C  
ATOM   1313  C   ASP B  72      14.825  27.747  10.308  1.00  9.35           C  
ATOM   1314  O   ASP B  72      14.038  28.603   9.926  1.00 11.21           O  
ATOM   1315  CB  ASP B  72      17.101  28.606  10.975  1.00 12.87           C  
ATOM   1316  CG  ASP B  72      18.588  28.492  10.743  1.00 21.70           C  
ATOM   1317  OD1 ASP B  72      19.024  27.429  10.241  1.00 23.11           O  
ATOM   1318  OD2 ASP B  72      19.320  29.457  11.046  1.00 28.90           O  
ATOM   1319  N   LEU B  73      14.481  26.725  11.084  1.00  8.90           N  
ATOM   1320  CA  LEU B  73      13.106  26.477  11.529  1.00  7.75           C  
ATOM   1321  C   LEU B  73      12.955  26.576  13.049  1.00  8.70           C  
ATOM   1322  O   LEU B  73      12.197  25.831  13.676  1.00 10.68           O  
ATOM   1323  CB  LEU B  73      12.681  25.089  11.048  1.00  8.83           C  
ATOM   1324  CG  LEU B  73      12.607  24.907   9.529  1.00  8.45           C  
ATOM   1325  CD1 LEU B  73      12.637  23.433   9.145  1.00 12.66           C  
ATOM   1326  CD2 LEU B  73      11.399  25.616   8.937  1.00 10.09           C  
ATOM   1327  N   LYS B  74      13.692  27.506  13.623  1.00 10.32           N  
ATOM   1328  CA  LYS B  74      13.752  27.735  15.059  1.00 11.46           C  
ATOM   1329  C   LYS B  74      12.736  28.786  15.483  1.00 11.84           C  
ATOM   1330  O   LYS B  74      12.781  29.910  15.011  1.00 11.12           O  
ATOM   1331  CB  LYS B  74      15.159  28.251  15.398  1.00 14.17           C  
ATOM   1332  CG  LYS B  74      15.391  28.631  16.837  1.00 20.28           C  
ATOM   1333  CD  LYS B  74      15.410  27.411  17.712  1.00 19.17           C  
ATOM   1334  CE  LYS B  74      16.369  27.592  18.871  1.00 22.44           C  
ATOM   1335  NZ  LYS B  74      16.296  26.414  19.768  1.00 30.68           N  
ATOM   1336  N   ASN B  75      11.853  28.411  16.404  1.00 10.44           N  
ATOM   1337  CA  ASN B  75      10.898  29.321  16.997  1.00 10.32           C  
ATOM   1338  C   ASN B  75      10.111  30.102  15.971  1.00 11.46           C  
ATOM   1339  O   ASN B  75      10.004  31.331  16.046  1.00 11.67           O  
ATOM   1340  CB  ASN B  75      11.596  30.273  17.966  1.00 13.40           C  
ATOM   1341  CG  ASN B  75      12.194  29.558  19.138  1.00 12.31           C  
ATOM   1342  OD1 ASN B  75      11.615  28.626  19.669  1.00 18.64           O  
ATOM   1343  ND2 ASN B  75      13.370  29.999  19.548  1.00 18.68           N  
ATOM   1344  N   LEU B  76       9.546  29.378  15.007  1.00  9.47           N  
ATOM   1345  CA  LEU B  76       8.688  30.004  14.015  1.00 11.59           C  
ATOM   1346  C   LEU B  76       7.227  29.713  14.291  1.00 11.32           C  
ATOM   1347  O   LEU B  76       6.886  28.727  14.936  1.00 11.22           O  
ATOM   1348  CB  LEU B  76       9.024  29.490  12.620  1.00 11.81           C  
ATOM   1349  CG  LEU B  76      10.423  29.629  12.050  1.00 10.77           C  
ATOM   1350  CD1 LEU B  76      10.391  29.003  10.665  1.00 11.76           C  
ATOM   1351  CD2 LEU B  76      10.897  31.063  12.040  1.00 14.22           C  
ATOM   1352  N   LEU B  77       6.365  30.582  13.772  1.00 13.08           N  
ATOM   1353  CA  LEU B  77       4.954  30.246  13.678  1.00 13.89           C  
ATOM   1354  C   LEU B  77       4.781  29.068  12.725  1.00 10.41           C  
ATOM   1355  O   LEU B  77       5.501  28.953  11.718  1.00 10.84           O  
ATOM   1356  CB  LEU B  77       4.135  31.427  13.156  1.00 13.93           C  
ATOM   1357  CG  LEU B  77       4.073  32.672  14.035  1.00 12.25           C  
ATOM   1358  CD1 LEU B  77       3.355  33.768  13.273  1.00 12.79           C  
ATOM   1359  CD2 LEU B  77       3.411  32.401  15.369  1.00 13.60           C  
ATOM   1360  N   HIS B  78       3.813  28.204  13.029  1.00 11.60           N  
ATOM   1361  CA  HIS B  78       3.580  26.996  12.239  1.00  9.52           C  
ATOM   1362  C   HIS B  78       3.477  27.347  10.754  1.00 10.65           C  
ATOM   1363  O   HIS B  78       4.144  26.740   9.933  1.00 10.92           O  
ATOM   1364  CB  HIS B  78       2.296  26.297  12.703  1.00 11.16           C  
ATOM   1365  CG  HIS B  78       1.996  25.034  11.960  1.00 10.98           C  
ATOM   1366  ND1 HIS B  78       2.575  23.823  12.268  1.00 12.08           N  
ATOM   1367  CD2 HIS B  78       1.190  24.798  10.897  1.00 11.96           C  
ATOM   1368  CE1 HIS B  78       2.129  22.892  11.444  1.00 12.39           C  
ATOM   1369  NE2 HIS B  78       1.293  23.462  10.594  1.00 13.18           N  
ATOM   1370  N   GLN B  79       2.659  28.337  10.402  1.00 12.27           N  
ATOM   1371  CA  GLN B  79       2.420  28.606   8.983  1.00 12.79           C  
ATOM   1372  C   GLN B  79       3.661  29.123   8.266  1.00 11.18           C  
ATOM   1373  O   GLN B  79       3.860  28.837   7.078  1.00 13.44           O  
ATOM   1374  CB  GLN B  79       1.267  29.593   8.771  1.00 13.03           C  
ATOM   1375  CG  GLN B  79       0.887  29.798   7.286  1.00 15.64           C  
ATOM   1376  CD  GLN B  79       0.416  28.501   6.640  1.00 20.93           C  
ATOM   1377  OE1 GLN B  79      -0.376  27.751   7.226  1.00 25.26           O  
ATOM   1378  NE2 GLN B  79       0.909  28.222   5.431  1.00 21.91           N  
ATOM   1379  N   ASP B  80       4.507  29.862   8.965  1.00 11.51           N  
ATOM   1380  CA  ASP B  80       5.732  30.366   8.374  1.00 11.95           C  
ATOM   1381  C   ASP B  80       6.708  29.228   8.095  1.00 10.11           C  
ATOM   1382  O   ASP B  80       7.360  29.215   7.068  1.00 11.43           O  
ATOM   1383  CB  ASP B  80       6.372  31.415   9.286  1.00 15.07           C  
ATOM   1384  CG  ASP B  80       5.546  32.683   9.388  1.00 19.71           C  
ATOM   1385  OD1 ASP B  80       4.675  32.918   8.512  1.00 23.69           O  
ATOM   1386  OD2 ASP B  80       5.761  33.430  10.359  1.00 20.51           O  
ATOM   1387  N   ALA B  81       6.782  28.262   9.004  1.00  9.96           N  
ATOM   1388  CA  ALA B  81       7.551  27.061   8.729  1.00  9.06           C  
ATOM   1389  C   ALA B  81       6.984  26.334   7.504  1.00 11.12           C  
ATOM   1390  O   ALA B  81       7.718  25.982   6.584  1.00  9.74           O  
ATOM   1391  CB  ALA B  81       7.598  26.158   9.952  1.00 10.52           C  
ATOM   1392  N   VAL B  82       5.671  26.146   7.465  1.00 10.23           N  
ATOM   1393  CA  VAL B  82       5.022  25.477   6.341  1.00 10.91           C  
ATOM   1394  C   VAL B  82       5.390  26.149   5.025  1.00 10.67           C  
ATOM   1395  O   VAL B  82       5.759  25.480   4.056  1.00 10.71           O  
ATOM   1396  CB  VAL B  82       3.470  25.424   6.501  1.00 11.10           C  
ATOM   1397  CG1 VAL B  82       2.819  24.832   5.233  1.00 12.29           C  
ATOM   1398  CG2 VAL B  82       3.115  24.578   7.699  1.00 12.34           C  
ATOM   1399  N   ASP B  83       5.322  27.474   4.995  1.00 11.17           N  
ATOM   1400  CA  ASP B  83       5.618  28.198   3.765  1.00 10.86           C  
ATOM   1401  C   ASP B  83       7.055  27.967   3.292  1.00 11.67           C  
ATOM   1402  O   ASP B  83       7.323  27.931   2.084  1.00 11.75           O  
ATOM   1403  CB  ASP B  83       5.386  29.704   3.967  1.00 12.14           C  
ATOM   1404  CG  ASP B  83       3.919  30.066   4.148  1.00 19.51           C  
ATOM   1405  OD1 ASP B  83       3.040  29.236   3.841  1.00 19.93           O  
ATOM   1406  OD2 ASP B  83       3.654  31.209   4.596  1.00 24.47           O  
ATOM   1407  N   LEU B  84       7.986  27.806   4.230  1.00 11.57           N  
ATOM   1408  CA  LEU B  84       9.366  27.553   3.841  1.00 11.08           C  
ATOM   1409  C   LEU B  84       9.500  26.233   3.097  1.00 11.53           C  
ATOM   1410  O   LEU B  84      10.258  26.135   2.121  1.00 13.43           O  
ATOM   1411  CB  LEU B  84      10.324  27.575   5.035  1.00 10.45           C  
ATOM   1412  CG  LEU B  84      10.525  28.941   5.698  1.00 11.72           C  
ATOM   1413  CD1 LEU B  84      11.382  28.806   6.964  1.00 14.21           C  
ATOM   1414  CD2 LEU B  84      11.106  29.984   4.741  1.00 14.24           C  
ATOM   1415  N   PHE B  85       8.772  25.215   3.545  1.00 10.80           N  
ATOM   1416  CA  PHE B  85       8.800  23.943   2.854  1.00 11.33           C  
ATOM   1417  C   PHE B  85       8.085  24.066   1.518  1.00 10.14           C  
ATOM   1418  O   PHE B  85       8.561  23.568   0.495  1.00 12.53           O  
ATOM   1419  CB  PHE B  85       8.106  22.859   3.675  1.00 11.79           C  
ATOM   1420  CG  PHE B  85       8.878  22.404   4.877  1.00  8.53           C  
ATOM   1421  CD1 PHE B  85       9.802  21.376   4.786  1.00 11.33           C  
ATOM   1422  CD2 PHE B  85       8.685  23.006   6.107  1.00 11.67           C  
ATOM   1423  CE1 PHE B  85      10.503  20.935   5.891  1.00 10.46           C  
ATOM   1424  CE2 PHE B  85       9.390  22.583   7.231  1.00  8.60           C  
ATOM   1425  CZ  PHE B  85      10.292  21.550   7.122  1.00  9.42           C  
ATOM   1426  N   ARG B  86       6.913  24.679   1.532  1.00  8.77           N  
ATOM   1427  CA  ARG B  86       6.077  24.633   0.327  1.00 11.97           C  
ATOM   1428  C   ARG B  86       6.639  25.473  -0.817  1.00 10.74           C  
ATOM   1429  O   ARG B  86       6.311  25.220  -1.977  1.00 13.17           O  
ATOM   1430  CB  ARG B  86       4.616  24.977   0.643  1.00 10.48           C  
ATOM   1431  CG  ARG B  86       3.900  23.892   1.473  1.00 12.98           C  
ATOM   1432  CD  ARG B  86       2.480  24.280   1.763  1.00 16.10           C  
ATOM   1433  NE  ARG B  86       1.780  23.226   2.497  1.00 18.36           N  
ATOM   1434  CZ  ARG B  86       0.607  23.367   3.094  1.00 20.38           C  
ATOM   1435  NH1 ARG B  86      -0.036  24.540   3.083  1.00 25.78           N  
ATOM   1436  NH2 ARG B  86       0.082  22.335   3.733  1.00 16.94           N  
ATOM   1437  N   ASN B  87       7.467  26.472  -0.493  1.00 10.24           N  
ATOM   1438  CA  ASN B  87       8.138  27.319  -1.500  1.00 10.85           C  
ATOM   1439  C   ASN B  87       9.432  26.699  -1.990  1.00 13.71           C  
ATOM   1440  O   ASN B  87      10.095  27.246  -2.865  1.00 20.02           O  
ATOM   1441  CB  ASN B  87       8.467  28.723  -0.956  1.00 12.13           C  
ATOM   1442  CG  ASN B  87       7.294  29.662  -0.973  1.00 14.39           C  
ATOM   1443  OD1 ASN B  87       7.144  30.478  -0.065  1.00 22.22           O  
ATOM   1444  ND2 ASN B  87       6.465  29.569  -1.997  1.00 12.56           N  
ATOM   1445  N   ALA B  88       9.812  25.574  -1.414  1.00 13.03           N  
ATOM   1446  CA  ALA B  88      10.966  24.870  -1.908  1.00 17.49           C  
ATOM   1447  C   ALA B  88      10.720  24.384  -3.345  1.00 14.87           C  
ATOM   1448  O   ALA B  88       9.582  24.201  -3.784  1.00 23.05           O  
ATOM   1449  CB  ALA B  88      11.287  23.735  -1.006  1.00 16.21           C  
ATOM   1450  N   GLY B  89      11.783  24.244  -4.092  1.00 17.13           N  
ATOM   1451  CA  GLY B  89      11.677  23.696  -5.400  1.00 15.74           C  
ATOM   1452  C   GLY B  89      11.711  22.187  -5.351  1.00 15.74           C  
ATOM   1453  O   GLY B  89      11.212  21.535  -4.415  1.00 15.89           O  
ATOM   1454  N   TYR B  90      12.341  21.633  -6.372  1.00 12.80           N  
ATOM   1455  CA  TYR B  90      12.325  20.211  -6.637  1.00 12.30           C  
ATOM   1456  C   TYR B  90      13.348  19.448  -5.819  1.00 13.50           C  
ATOM   1457  O   TYR B  90      13.175  18.255  -5.576  1.00 20.74           O  
ATOM   1458  CB  TYR B  90      12.571  20.006  -8.123  1.00 15.70           C  
ATOM   1459  CG  TYR B  90      11.506  20.660  -8.965  1.00 19.71           C  
ATOM   1460  CD1 TYR B  90      10.319  20.000  -9.250  1.00 26.96           C  
ATOM   1461  CD2 TYR B  90      11.681  21.951  -9.456  1.00 22.96           C  
ATOM   1462  N   ALA B  91      14.413  20.124  -5.414  1.00 11.43           N  
ATOM   1463  CA  ALA B  91      15.456  19.514  -4.581  1.00 11.81           C  
ATOM   1464  C   ALA B  91      15.454  20.187  -3.216  1.00 13.89           C  
ATOM   1465  O   ALA B  91      15.600  21.404  -3.119  1.00 14.88           O  
ATOM   1466  CB  ALA B  91      16.822  19.667  -5.248  1.00 17.84           C  
ATOM   1467  N   VAL B  92      15.288  19.393  -2.160  1.00  9.19           N  
ATOM   1468  CA  VAL B  92      15.063  19.940  -0.833  1.00  9.75           C  
ATOM   1469  C   VAL B  92      16.056  19.325   0.157  1.00  9.12           C  
ATOM   1470  O   VAL B  92      16.083  18.120   0.329  1.00 10.81           O  
ATOM   1471  CB  VAL B  92      13.594  19.717  -0.414  1.00  9.29           C  
ATOM   1472  CG1 VAL B  92      13.352  20.330   0.943  1.00 12.10           C  
ATOM   1473  CG2 VAL B  92      12.644  20.312  -1.475  1.00 13.96           C  
ATOM   1474  N   SER B  93      16.903  20.165   0.757  1.00  8.61           N  
ATOM   1475  CA  SER B  93      17.878  19.730   1.748  1.00  6.91           C  
ATOM   1476  C   SER B  93      17.312  19.971   3.132  1.00  7.10           C  
ATOM   1477  O   SER B  93      16.851  21.074   3.461  1.00  9.82           O  
ATOM   1478  CB  SER B  93      19.185  20.506   1.587  0.33  7.33           C  
ATOM   1481  OG  SER B  93      20.192  19.965   2.414  0.33 11.39           O  
ATOM   1484  N   LEU B  94      17.338  18.928   3.952  1.00  7.06           N  
ATOM   1485  CA  LEU B  94      16.814  18.989   5.291  1.00  8.84           C  
ATOM   1486  C   LEU B  94      17.921  18.644   6.260  1.00  8.26           C  
ATOM   1487  O   LEU B  94      18.630  17.673   6.073  1.00 10.27           O  
ATOM   1488  CB  LEU B  94      15.686  17.980   5.453  1.00  6.84           C  
ATOM   1489  CG  LEU B  94      14.484  18.094   4.523  1.00  9.94           C  
ATOM   1490  CD1 LEU B  94      13.575  16.943   4.772  1.00 12.46           C  
ATOM   1491  CD2 LEU B  94      13.711  19.398   4.727  1.00  8.40           C  
ATOM   1492  N   ARG B  95      18.070  19.436   7.292  1.00  6.99           N  
ATOM   1493  CA  ARG B  95      18.910  19.026   8.414  1.00  6.94           C  
ATOM   1494  C   ARG B  95      17.957  18.542   9.468  1.00  6.15           C  
ATOM   1495  O   ARG B  95      17.135  19.318   9.938  1.00  6.52           O  
ATOM   1496  CB  ARG B  95      19.800  20.144   8.962  1.00  8.91           C  
ATOM   1497  CG  ARG B  95      20.601  19.618  10.177  1.00 13.99           C  
ATOM   1498  CD  ARG B  95      21.611  20.624  10.726  0.50 16.94           C  
ATOM   1500  NE  ARG B  95      22.260  21.431   9.697  0.50 19.65           N  
ATOM   1502  CZ  ARG B  95      22.071  22.733   9.473  0.50 17.98           C  
ATOM   1504  NH1 ARG B  95      21.200  23.473  10.166  0.50 15.09           N  
ATOM   1506  NH2 ARG B  95      22.776  23.300   8.508  0.50 15.62           N  
ATOM   1508  N   VAL B  96      18.078  17.275   9.856  1.00  5.92           N  
ATOM   1509  CA  VAL B  96      17.162  16.709  10.849  1.00  5.93           C  
ATOM   1510  C   VAL B  96      17.900  16.161  12.058  1.00  5.72           C  
ATOM   1511  O   VAL B  96      19.084  15.855  12.005  1.00  6.77           O  
ATOM   1512  CB  VAL B  96      16.253  15.608  10.252  1.00  7.48           C  
ATOM   1513  CG1 VAL B  96      15.641  16.078   8.920  1.00  9.35           C  
ATOM   1514  CG2 VAL B  96      16.994  14.286  10.085  1.00 11.01           C  
ATOM   1515  N   GLN B  97      17.157  16.068  13.145  1.00  7.29           N  
ATOM   1516  CA  GLN B  97      17.576  15.436  14.376  1.00  6.92           C  
ATOM   1517  C   GLN B  97      16.693  14.216  14.595  1.00  7.51           C  
ATOM   1518  O   GLN B  97      15.478  14.355  14.758  1.00  7.97           O  
ATOM   1519  CB  GLN B  97      17.389  16.427  15.530  1.00 12.06           C  
ATOM   1520  CG  GLN B  97      18.181  16.055  16.778  0.70 15.38           C  
ATOM   1522  CD  GLN B  97      17.891  16.946  17.988  0.70 11.12           C  
ATOM   1524  OE1 GLN B  97      16.739  17.186  18.345  0.70 15.07           O  
ATOM   1526  NE2 GLN B  97      18.946  17.440  18.615  0.70 14.78           N  
ATOM   1528  N   HIS B  98      17.280  13.024  14.522  1.00  6.48           N  
ATOM   1529  CA  HIS B  98      16.596  11.814  14.921  1.00  6.33           C  
ATOM   1530  C   HIS B  98      16.590  11.767  16.444  1.00  8.11           C  
ATOM   1531  O   HIS B  98      17.628  11.973  17.050  1.00  9.20           O  
ATOM   1532  CB  HIS B  98      17.292  10.580  14.371  1.00  6.96           C  
ATOM   1533  CG  HIS B  98      17.399  10.569  12.881  1.00  7.70           C  
ATOM   1534  ND1 HIS B  98      16.296  10.648  12.053  1.00  8.53           N  
ATOM   1535  CD2 HIS B  98      18.474  10.447  12.064  1.00 10.04           C  
ATOM   1536  CE1 HIS B  98      16.691  10.587  10.794  1.00  9.10           C  
ATOM   1537  NE2 HIS B  98      18.009  10.463  10.773  1.00  8.50           N  
ATOM   1538  N   ARG B  99      15.432  11.487  17.033  1.00  8.05           N  
ATOM   1539  CA  ARG B  99      15.213  11.641  18.452  1.00  7.49           C  
ATOM   1540  C   ARG B  99      14.650  10.367  19.056  1.00  8.20           C  
ATOM   1541  O   ARG B  99      13.640   9.860  18.595  1.00 11.06           O  
ATOM   1542  CB  ARG B  99      14.196  12.745  18.662  1.00  9.77           C  
ATOM   1543  CG  ARG B  99      14.728  14.125  18.395  1.00 11.05           C  
ATOM   1544  CD  ARG B  99      13.583  15.135  18.419  1.00 13.12           C  
ATOM   1545  NE  ARG B  99      12.933  15.234  19.734  1.00 17.15           N  
ATOM   1546  CZ  ARG B  99      11.686  14.843  20.038  1.00 22.52           C  
ATOM   1547  NH1 ARG B  99      10.856  14.288  19.144  1.00 19.27           N  
ATOM   1548  NH2 ARG B  99      11.253  15.023  21.280  1.00 26.76           N  
ATOM   1549  N   LEU B 100      15.277   9.865  20.114  1.00  7.50           N  
ATOM   1550  CA  LEU B 100      14.706   8.757  20.870  1.00  7.20           C  
ATOM   1551  C   LEU B 100      13.592   9.225  21.806  1.00  7.16           C  
ATOM   1552  O   LEU B 100      12.700   8.448  22.149  1.00  9.04           O  
ATOM   1553  CB  LEU B 100      15.791   8.046  21.684  1.00 10.25           C  
ATOM   1554  CG  LEU B 100      16.910   7.386  20.878  1.00 12.49           C  
ATOM   1555  CD1 LEU B 100      17.908   6.638  21.805  1.00 18.91           C  
ATOM   1556  CD2 LEU B 100      16.371   6.449  19.811  1.00 16.05           C  
ATOM   1557  N   GLU B 101      13.639  10.487  22.229  1.00  9.48           N  
ATOM   1558  CA  GLU B 101      12.614  11.025  23.125  1.00 10.49           C  
ATOM   1559  C   GLU B 101      11.386  11.549  22.416  1.00 10.77           C  
ATOM   1560  O   GLU B 101      11.478  12.080  21.316  1.00 12.44           O  
ATOM   1561  CB  GLU B 101      13.122  12.227  23.900  1.00 13.77           C  
ATOM   1562  CG  GLU B 101      14.230  11.999  24.843  1.00 15.54           C  
ATOM   1563  CD  GLU B 101      14.570  13.290  25.566  1.00 18.05           C  
ATOM   1564  OE1 GLU B 101      14.981  14.256  24.885  1.00 29.20           O  
ATOM   1565  OE2 GLU B 101      14.416  13.381  26.799  1.00 16.68           O  
ATOM   1566  N   SER B 102      10.252  11.460  23.095  1.00 11.15           N  
ATOM   1567  CA  SER B 102       9.037  12.161  22.698  1.00  8.78           C  
ATOM   1568  C   SER B 102       8.509  12.903  23.904  1.00 11.55           C  
ATOM   1569  O   SER B 102       8.513  12.360  25.014  1.00 11.03           O  
ATOM   1570  CB  SER B 102       7.970  11.204  22.178  1.00 10.56           C  
ATOM   1571  OG  SER B 102       8.456  10.446  21.090  1.00 14.02           O  
ATOM   1572  N   SER B 103       8.001  14.115  23.667  1.00 10.94           N  
ATOM   1573  CA  SER B 103       7.464  14.958  24.734  0.70 10.79           C  
ATOM   1575  C   SER B 103       5.982  14.677  24.937  1.00 11.98           C  
ATOM   1576  O   SER B 103       5.219  14.576  23.981  1.00 13.33           O  
ATOM   1577  CB  SER B 103       7.721  16.449  24.423  0.70 14.23           C  
ATOM   1579  OG  SER B 103       7.149  16.829  23.193  0.70 21.84           O  
ATOM   1581  N   ILE B 104       5.614  14.550  26.213  1.00 12.44           N  
ATOM   1582  CA  ILE B 104       4.242  14.297  26.659  1.00 14.48           C  
ATOM   1583  C   ILE B 104       3.742  15.456  27.516  1.00 15.43           C  
ATOM   1584  O   ILE B 104       4.567  16.150  28.115  1.00 15.08           O  
ATOM   1585  CB  ILE B 104       4.204  13.022  27.534  1.00 15.09           C  
ATOM   1586  CG1 ILE B 104       4.888  11.852  26.815  1.00 13.21           C  
ATOM   1587  CG2 ILE B 104       2.775  12.678  27.972  1.00 15.85           C  
ATOM   1588  CD1 ILE B 104       4.445  11.615  25.358  1.00 13.65           C  
ATOM   1589  OXT ILE B 104       2.531  15.723  27.653  1.00 14.91           O  
TER    1590      ILE B 104                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
