
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  340 ( 2733),  selected  340 , name 2du8_A
# Molecule2: number of CA atoms  366 ( 2688),  selected  366 , name T0490.pdb
# PARAMETERS: 2du8_A.T0490.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       3           -
LGA    -       -      D       4           -
LGA    M     1_A      I       5           #
LGA    R     2_A      D       6          1.416
LGA    V     3_A      C       7          0.584
LGA    V     4_A      I       8          0.555
LGA    V     5_A      V       9          0.193
LGA    I     6_A      I      10          0.542
LGA    G     7_A      G      11          0.914
LGA    A     8_A      A      12          1.065
LGA    G     9_A      G      13          1.027
LGA    V    10_A      V      14          1.103
LGA    I    11_A      V      15          0.926
LGA    G    12_A      G      16          0.264
LGA    L    13_A      L      17          0.376
LGA    S    14_A      A      18          0.546
LGA    T    15_A      I      19          0.911
LGA    A    16_A      A      20          0.884
LGA    L    17_A      R      21          0.529
LGA    C    18_A      A      22          1.445
LGA    I    19_A      L      23          1.729
LGA    H    20_A      A      24          1.316
LGA    E    21_A      A      25          1.139
LGA    R    22_A      G      26          2.422
LGA    Y    23_A      -       -           -
LGA    H    24_A      G      27          0.597
LGA    S    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    L    27_A      -       -           -
LGA    Q    28_A      -       -           -
LGA    P    29_A      -       -           -
LGA    L    30_A      H      28          3.042
LGA    D    31_A      E      29          2.140
LGA    I    32_A      V      30          0.590
LGA    K    33_A      L      31          0.627
LGA    V    34_A      V      32          0.662
LGA    Y    35_A      A      33          0.906
LGA    A    36_A      E      34          1.399
LGA    D    37_A      A      35          1.655
LGA    R    38_A      A      36          2.593
LGA    -       -      E      37           -
LGA    F    39_A      G      38          3.444
LGA    T    40_A      I      39          2.850
LGA    P    41_A      G      40          4.912
LGA    L    42_A      T      41          2.012
LGA    T    43_A      G      42          1.159
LGA    T    44_A      T      43          0.870
LGA    T    45_A      S      44          1.077
LGA    D    46_A      S      45          1.009
LGA    V    47_A      R      46          1.283
LGA    A    48_A      N      47          1.251
LGA    A    49_A      S      48          1.739
LGA    G    50_A      E      49          1.697
LGA    L    51_A      V      50          1.232
LGA    W    52_A      I      51          2.544
LGA    Q    53_A      H      52          2.654
LGA    P    54_A      A      53           #
LGA    Y    55_A      G      54           #
LGA    L    56_A      I      55           #
LGA    S    57_A      Y      56          4.253
LGA    D    58_A      Y      57          3.681
LGA    -       -      P      58           -
LGA    P    59_A      A      59           #
LGA    N    60_A      -       -           -
LGA    N    61_A      -       -           -
LGA    P    62_A      D      60          1.590
LGA    Q    63_A      S      61          4.390
LGA    E    64_A      L      62          1.857
LGA    -       -      K      63           -
LGA    A    65_A      A      64          2.214
LGA    D    66_A      R      65          2.021
LGA    W    67_A      L      66          1.427
LGA    S    68_A      C      67          1.554
LGA    Q    69_A      V      68          1.634
LGA    Q    70_A      R      69          1.004
LGA    T    71_A      G      70          0.980
LGA    F    72_A      K      71          1.685
LGA    D    73_A      H      72          1.585
LGA    Y    74_A      L      73          1.540
LGA    L    75_A      L      74          2.560
LGA    L    76_A      Y      75          3.198
LGA    S    77_A      E      76          3.281
LGA    H    78_A      Y      77          4.440
LGA    V    79_A      C      78           #
LGA    H    80_A      A      79          4.371
LGA    S    81_A      A      80          4.180
LGA    P    82_A      -       -           -
LGA    N    83_A      R      81          2.809
LGA    A    84_A      G      82          3.247
LGA    E    85_A      V      83          3.763
LGA    N    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    G    88_A      P      84          2.725
LGA    L    89_A      H      85          2.227
LGA    F    90_A      Q      86          1.860
LGA    L    91_A      R      87          0.525
LGA    I    92_A      L      88          1.089
LGA    S    93_A      G      89          1.375
LGA    G    94_A      K      90          2.117
LGA    Y    95_A      L      91          1.041
LGA    N    96_A      I      92          0.706
LGA    L    97_A      V      93          1.588
LGA    F    98_A      A      94          2.918
LGA    H    99_A      T      95          4.516
LGA    -       -      S      96           -
LGA    -       -      D      97           -
LGA    -       -      A      98           -
LGA    E   100_A      E      99          1.883
LGA    A   101_A      A     100          4.058
LGA    -       -      S     101           -
LGA    I   102_A      Q     102          1.769
LGA    -       -      L     103           -
LGA    -       -      D     104           -
LGA    P   103_A      S     105          1.226
LGA    D   104_A      I     106          2.118
LGA    -       -      A     107           -
LGA    P   105_A      R     108          5.216
LGA    S   106_A      R     109          3.015
LGA    W   107_A      A     110          3.012
LGA    K   108_A      G     111          3.642
LGA    -       -      A     112           -
LGA    -       -      N     113           -
LGA    -       -      G     114           -
LGA    D   109_A      V     115          2.060
LGA    T   110_A      D     116          5.288
LGA    V   111_A      -       -           -
LGA    L   112_A      -       -           -
LGA    G   113_A      D     117          3.073
LGA    F   114_A      L     118          0.824
LGA    R   115_A      Q     119          1.168
LGA    K   116_A      H     120          1.032
LGA    L   117_A      I     121          2.401
LGA    T   118_A      D     122          1.690
LGA    P   119_A      G     123          3.458
LGA    R   120_A      A     124          0.547
LGA    E   121_A      A     125          3.474
LGA    L   122_A      A     126           #
LGA    D   123_A      -       -           -
LGA    M   124_A      R     127          4.395
LGA    -       -      R     128           -
LGA    -       -      L     129           -
LGA    -       -      E     130           -
LGA    -       -      P     131           -
LGA    -       -      A     132           -
LGA    F   125_A      L     133          4.481
LGA    P   126_A      H     134          4.227
LGA    D   127_A      -       -           -
LGA    Y   128_A      C     135          4.255
LGA    G   129_A      T     136          2.845
LGA    Y   130_A      A     137          3.776
LGA    G   131_A      A     138          2.709
LGA    W   132_A      L     139          0.870
LGA    F   133_A      V     140          1.006
LGA    H   134_A      S     141          1.734
LGA    T   135_A      P     142          1.075
LGA    S   136_A      S     143          2.542
LGA    -       -      T     144           -
LGA    L   137_A      G     145          2.149
LGA    I   138_A      I     146          1.727
LGA    L   139_A      V     147          2.301
LGA    E   140_A      D     148          2.522
LGA    G   141_A      S     149          1.531
LGA    K   142_A      H     150          1.804
LGA    N   143_A      A     151          1.729
LGA    Y   144_A      L     152          1.035
LGA    L   145_A      M     153          1.283
LGA    Q   146_A      L     154          1.878
LGA    W   147_A      A     155          1.618
LGA    L   148_A      Y     156          1.460
LGA    T   149_A      Q     157          1.874
LGA    E   150_A      G     158          2.246
LGA    R   151_A      D     159          2.204
LGA    L   152_A      A     160          2.307
LGA    T   153_A      E     161          2.740
LGA    E   154_A      S     162          2.755
LGA    R   155_A      D     163          2.601
LGA    G   156_A      G     164          2.341
LGA    V   157_A      A     165          1.291
LGA    K   158_A      Q     166          1.213
LGA    F   159_A      L     167          1.236
LGA    F   160_A      V     168          1.512
LGA    Q   161_A      F     169          2.221
LGA    R   162_A      H     170          3.843
LGA    -       -      T     171           -
LGA    K   163_A      P     172          1.718
LGA    V   164_A      L     173          1.215
LGA    E   165_A      I     174          1.508
LGA    S   166_A      A     175          2.479
LGA    F   167_A      G     176          3.180
LGA    E   168_A      R     177          2.262
LGA    -       -      V     178           -
LGA    -       -      R     179           -
LGA    -       -      P     180           -
LGA    -       -      E     181           -
LGA    -       -      G     182           -
LGA    -       -      G     183           -
LGA    -       -      F     184           -
LGA    -       -      E     185           -
LGA    E   169_A      L     186          2.624
LGA    V   170_A      D     187           #
LGA    A   171_A      F     188           -
LGA    R   172_A      G     189           -
LGA    -       -      G     190           -
LGA    -       -      A     191           -
LGA    -       -      E     192           -
LGA    -       -      P     193           -
LGA    -       -      M     194           -
LGA    -       -      T     195           -
LGA    E   173_A      L     196          2.501
LGA    G   174_A      S     197          1.046
LGA    A   175_A      C     198          1.236
LGA    D   176_A      R     199          1.005
LGA    V   177_A      V     200          0.759
LGA    I   178_A      L     201          0.535
LGA    V   179_A      I     202          0.347
LGA    N   180_A      N     203          0.969
LGA    C   181_A      A     204          0.613
LGA    T   182_A      A     205          0.921
LGA    G   183_A      G     206          1.064
LGA    V   184_A      L     207          1.765
LGA    W   185_A      H     208          1.346
LGA    A   186_A      A     209          1.339
LGA    G   187_A      P     210          2.219
LGA    A   188_A      G     211          1.644
LGA    L   189_A      L     212          1.604
LGA    Q   190_A      A     213          2.920
LGA    -       -      R     214           -
LGA    -       -      R     215           -
LGA    -       -      I     216           -
LGA    -       -      E     217           -
LGA    -       -      G     218           -
LGA    -       -      I     219           -
LGA    -       -      P     220           -
LGA    -       -      R     221           -
LGA    -       -      D     222           -
LGA    -       -      S     223           -
LGA    R   191_A      I     224          4.673
LGA    D   192_A      P     225          1.966
LGA    P   193_A      P     226          1.886
LGA    L   194_A      -       -           -
LGA    L   195_A      E     227          4.245
LGA    Q   196_A      Y     228          2.303
LGA    P   197_A      L     229          1.851
LGA    G   198_A      C     230          2.051
LGA    R   199_A      K     231          0.930
LGA    G   200_A      G     232          0.443
LGA    Q   201_A      S     233          0.707
LGA    I   202_A      Y     234          1.191
LGA    M   203_A      F     235          2.336
LGA    K   204_A      T     236          3.599
LGA    V   205_A      L     237          3.509
LGA    D   206_A      A     238          3.924
LGA    A   207_A      G     239          4.061
LGA    P   208_A      R     240          3.165
LGA    W   209_A      A     241          4.433
LGA    -       -      P     242           -
LGA    M   210_A      F     243          3.432
LGA    K   211_A      S     244          1.474
LGA    H   212_A      R     245          0.932
LGA    F   213_A      L     246          0.507
LGA    I   214_A      I     247          0.593
LGA    L   215_A      Y     248          0.795
LGA    T   216_A      P     249          1.374
LGA    H   217_A      V     250          3.308
LGA    D   218_A      P     251           #
LGA    P   219_A      Q     252          3.228
LGA    E   220_A      H     253           #
LGA    R   221_A      A     254          4.056
LGA    G   222_A      G     255           #
LGA    I   223_A      -       -           -
LGA    Y   224_A      -       -           -
LGA    N   225_A      L     256          3.660
LGA    S   226_A      G     257          0.953
LGA    P   227_A      V     258          1.180
LGA    Y   228_A      H     259          1.166
LGA    I   229_A      L     260          0.921
LGA    I   230_A      T     261          0.705
LGA    P   231_A      L     262          1.090
LGA    G   232_A      D     263          1.377
LGA    T   233_A      L     264          0.504
LGA    Q   234_A      G     265          1.942
LGA    -       -      G     266           -
LGA    T   235_A      Q     267          3.094
LGA    V   236_A      A     268          2.416
LGA    T   237_A      K     269          2.316
LGA    L   238_A      F     270          1.358
LGA    G   239_A      G     271          0.752
LGA    G   240_A      P     272          3.764
LGA    I   241_A      D     273          0.356
LGA    F   242_A      T     274          1.551
LGA    Q   243_A      E     275          2.186
LGA    L   244_A      W     276          3.206
LGA    G   245_A      I     277          4.084
LGA    N   246_A      A     278          4.855
LGA    W   247_A      T     279          3.362
LGA    S   248_A      E     280           #
LGA    E   249_A      D     281          2.107
LGA    -       -      Y     282           -
LGA    L   250_A      T     283          1.191
LGA    N   251_A      L     284          0.724
LGA    N   252_A      D     285          1.407
LGA    I   253_A      P     286          2.481
LGA    Q   254_A      R     287          2.618
LGA    D   255_A      R     288          1.474
LGA    H   256_A      A     289          2.638
LGA    N   257_A      D     290          2.571
LGA    T   258_A      V     291          2.936
LGA    I   259_A      F     292          3.613
LGA    W   260_A      Y     293          5.276
LGA    E   261_A      A     294          5.435
LGA    G   262_A      A     295          3.525
LGA    C   263_A      V     296          3.394
LGA    C   264_A      -       -           -
LGA    R   265_A      R     297          1.670
LGA    L   266_A      S     298          5.055
LGA    -       -      Y     299           -
LGA    E   267_A      W     300          2.983
LGA    P   268_A      P     301          5.076
LGA    T   269_A      A     302          5.510
LGA    L   270_A      L     303          4.928
LGA    K   271_A      P     304          3.315
LGA    N   272_A      D     305           -
LGA    -       -      G     306           -
LGA    A   273_A      A     307           #
LGA    R   274_A      L     308           #
LGA    I   275_A      A     309          4.469
LGA    I   276_A      -       -           -
LGA    G   277_A      P     310           #
LGA    E   278_A      G     311          1.656
LGA    R   279_A      Y     312          1.289
LGA    T   280_A      T     313          1.294
LGA    G   281_A      G     314          1.212
LGA    F   282_A      I     315          1.125
LGA    R   283_A      R     316          1.231
LGA    P   284_A      P     317          1.531
LGA    V   285_A      K     318          2.469
LGA    R   286_A      I     319          3.496
LGA    -       -      S     320           -
LGA    -       -      G     321           -
LGA    -       -      P     322           -
LGA    -       -      H     323           -
LGA    -       -      E     324           -
LGA    -       -      P     325           -
LGA    -       -      A     326           -
LGA    P   287_A      A     327          0.880
LGA    Q   288_A      D     328          1.613
LGA    I   289_A      F     329          1.530
LGA    R   290_A      A     330          1.486
LGA    L   291_A      I     331          0.727
LGA    E   292_A      A     332          2.163
LGA    R   293_A      G     333          1.194
LGA    E   294_A      P     334          3.509
LGA    -       -      A     335           -
LGA    -       -      S     336           -
LGA    -       -      H     337           -
LGA    Q   295_A      G     338          4.409
LGA    L   296_A      V     339          4.653
LGA    R   297_A      -       -           -
LGA    T   298_A      -       -           -
LGA    G   299_A      -       -           -
LGA    P   300_A      -       -           -
LGA    S   301_A      -       -           -
LGA    N   302_A      -       -           -
LGA    T   303_A      A     340           #
LGA    E   304_A      G     341          2.177
LGA    V   305_A      L     342          0.867
LGA    I   306_A      V     343          0.948
LGA    H   307_A      N     344          1.547
LGA    N   308_A      L     345          2.064
LGA    Y   309_A      Y     346          2.695
LGA    G   310_A      G     347          1.102
LGA    H   311_A      I     348          1.928
LGA    G   312_A      E     349          2.196
LGA    G   313_A      S     350          2.126
LGA    Y   314_A      P     351          1.254
LGA    G   315_A      G     352          0.830
LGA    L   316_A      L     353          1.256
LGA    T   317_A      T     354          2.208
LGA    I   318_A      A     355          1.608
LGA    H   319_A      S     356          1.521
LGA    W   320_A      L     357          1.700
LGA    G   321_A      A     358          1.336
LGA    C   322_A      I     359          1.107
LGA    A   323_A      A     360          0.689
LGA    L   324_A      E     361          0.372
LGA    E   325_A      E     362          0.933
LGA    A   326_A      T     363          0.874
LGA    A   327_A      L     364          1.651
LGA    K   328_A      A     365          1.925
LGA    L   329_A      R     366          2.759
LGA    F   330_A      L     367          3.581
LGA    G   331_A      A     368          4.211
LGA    R   332_A      -       -           -
LGA    I   333_A      -       -           -
LGA    L   334_A      -       -           -
LGA    E   335_A      -       -           -
LGA    E   336_A      -       -           -
LGA    K   337_A      -       -           -
LGA    K   338_A      -       -           -
LGA    L   339_A      -       -           -
LGA    S   340_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  340  366    5.0    286    2.43    14.34     49.180    11.315

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.473444 * X  +  -0.878188 * Y  +   0.068091 * Z  +  47.419273
  Y_new =   0.537334 * X  +  -0.349207 * Y  +  -0.767677 * Z  +  38.391426
  Z_new =   0.697942 * X  +  -0.326864 * Y  +   0.637210 * Z  +  -2.550315 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.473963    2.667630  [ DEG:   -27.1561    152.8439 ]
  Theta =  -0.772520   -2.369072  [ DEG:   -44.2622   -135.7378 ]
  Phi   =   2.293070   -0.848523  [ DEG:   131.3832    -48.6168 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2du8_A                                        
REMARK     2: T0490.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2du8_A.T0490.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  340  366   5.0  286   2.43   14.34  49.180
REMARK  ---------------------------------------------------------- 
MOLECULE 2du8_A
HEADER    OXIDOREDUCTASE                          20-JUL-06   2DU8              
TITLE     CRYSTAL STRUCTURE OF HUMAN D-AMINO ACID OXIDASE                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: D-AMINO-ACID OXIDASE;                                      
COMPND   3 CHAIN: A, B, G, J;                                                   
COMPND   4 SYNONYM: DAMOX, DAO, DAAO;                                           
COMPND   5 EC: 1.4.3.3;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11B                                    
KEYWDS    STRUCTURALLY AMBIVALENT PEPTIDES, CONFORMATIONAL VARIABILITY          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.KAWAZOE,H.TSUGE,K.FUKUI                                             
REVDAT   2   12-DEC-06 2DU8    1       JRNL                                     
REVDAT   1   21-NOV-06 2DU8    0                                                
JRNL        AUTH   T.KAWAZOE,H.TSUGE,M.S.PILONE,K.FUKUI                         
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN D-AMINO ACID OXIDASE:             
JRNL        TITL 2 CONTEXT-DEPENDENT VARIABILITY OF THE BACKBONE                
JRNL        TITL 3 CONFORMATION OF THE VAAGL HYDROPHOBIC STRETCH                
JRNL        TITL 4 LOCATED AT THE SI-FACE OF THE FLAVIN RING                    
JRNL        REF    PROTEIN SCI.                  V.  15  2708 2006              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2DU8 A    1   347  UNP    P14920   OXDA_HUMAN       1    347             
DBREF  2DU8 B 1001  1347  UNP    P14920   OXDA_HUMAN       1    347             
DBREF  2DU8 G 2001  2347  UNP    P14920   OXDA_HUMAN       1    347             
DBREF  2DU8 J 3001  3347  UNP    P14920   OXDA_HUMAN       1    347             
SEQRES   1 A  347  MET ARG VAL VAL VAL ILE GLY ALA GLY VAL ILE GLY LEU          
SEQRES   2 A  347  SER THR ALA LEU CYS ILE HIS GLU ARG TYR HIS SER VAL          
SEQRES   3 A  347  LEU GLN PRO LEU ASP ILE LYS VAL TYR ALA ASP ARG PHE          
SEQRES   4 A  347  THR PRO LEU THR THR THR ASP VAL ALA ALA GLY LEU TRP          
SEQRES   5 A  347  GLN PRO TYR LEU SER ASP PRO ASN ASN PRO GLN GLU ALA          
SEQRES   6 A  347  ASP TRP SER GLN GLN THR PHE ASP TYR LEU LEU SER HIS          
SEQRES   7 A  347  VAL HIS SER PRO ASN ALA GLU ASN LEU GLY LEU PHE LEU          
SEQRES   8 A  347  ILE SER GLY TYR ASN LEU PHE HIS GLU ALA ILE PRO ASP          
SEQRES   9 A  347  PRO SER TRP LYS ASP THR VAL LEU GLY PHE ARG LYS LEU          
SEQRES  10 A  347  THR PRO ARG GLU LEU ASP MET PHE PRO ASP TYR GLY TYR          
SEQRES  11 A  347  GLY TRP PHE HIS THR SER LEU ILE LEU GLU GLY LYS ASN          
SEQRES  12 A  347  TYR LEU GLN TRP LEU THR GLU ARG LEU THR GLU ARG GLY          
SEQRES  13 A  347  VAL LYS PHE PHE GLN ARG LYS VAL GLU SER PHE GLU GLU          
SEQRES  14 A  347  VAL ALA ARG GLU GLY ALA ASP VAL ILE VAL ASN CYS THR          
SEQRES  15 A  347  GLY VAL TRP ALA GLY ALA LEU GLN ARG ASP PRO LEU LEU          
SEQRES  16 A  347  GLN PRO GLY ARG GLY GLN ILE MET LYS VAL ASP ALA PRO          
SEQRES  17 A  347  TRP MET LYS HIS PHE ILE LEU THR HIS ASP PRO GLU ARG          
SEQRES  18 A  347  GLY ILE TYR ASN SER PRO TYR ILE ILE PRO GLY THR GLN          
SEQRES  19 A  347  THR VAL THR LEU GLY GLY ILE PHE GLN LEU GLY ASN TRP          
SEQRES  20 A  347  SER GLU LEU ASN ASN ILE GLN ASP HIS ASN THR ILE TRP          
SEQRES  21 A  347  GLU GLY CYS CYS ARG LEU GLU PRO THR LEU LYS ASN ALA          
SEQRES  22 A  347  ARG ILE ILE GLY GLU ARG THR GLY PHE ARG PRO VAL ARG          
SEQRES  23 A  347  PRO GLN ILE ARG LEU GLU ARG GLU GLN LEU ARG THR GLY          
SEQRES  24 A  347  PRO SER ASN THR GLU VAL ILE HIS ASN TYR GLY HIS GLY          
SEQRES  25 A  347  GLY TYR GLY LEU THR ILE HIS TRP GLY CYS ALA LEU GLU          
SEQRES  26 A  347  ALA ALA LYS LEU PHE GLY ARG ILE LEU GLU GLU LYS LYS          
SEQRES  27 A  347  LEU SER ARG MET PRO PRO SER HIS LEU                          
SEQRES   1 B  347  MET ARG VAL VAL VAL ILE GLY ALA GLY VAL ILE GLY LEU          
SEQRES   2 B  347  SER THR ALA LEU CYS ILE HIS GLU ARG TYR HIS SER VAL          
SEQRES   3 B  347  LEU GLN PRO LEU ASP ILE LYS VAL TYR ALA ASP ARG PHE          
SEQRES   4 B  347  THR PRO LEU THR THR THR ASP VAL ALA ALA GLY LEU TRP          
SEQRES   5 B  347  GLN PRO TYR LEU SER ASP PRO ASN ASN PRO GLN GLU ALA          
SEQRES   6 B  347  ASP TRP SER GLN GLN THR PHE ASP TYR LEU LEU SER HIS          
SEQRES   7 B  347  VAL HIS SER PRO ASN ALA GLU ASN LEU GLY LEU PHE LEU          
SEQRES   8 B  347  ILE SER GLY TYR ASN LEU PHE HIS GLU ALA ILE PRO ASP          
SEQRES   9 B  347  PRO SER TRP LYS ASP THR VAL LEU GLY PHE ARG LYS LEU          
SEQRES  10 B  347  THR PRO ARG GLU LEU ASP MET PHE PRO ASP TYR GLY TYR          
SEQRES  11 B  347  GLY TRP PHE HIS THR SER LEU ILE LEU GLU GLY LYS ASN          
SEQRES  12 B  347  TYR LEU GLN TRP LEU THR GLU ARG LEU THR GLU ARG GLY          
SEQRES  13 B  347  VAL LYS PHE PHE GLN ARG LYS VAL GLU SER PHE GLU GLU          
SEQRES  14 B  347  VAL ALA ARG GLU GLY ALA ASP VAL ILE VAL ASN CYS THR          
SEQRES  15 B  347  GLY VAL TRP ALA GLY ALA LEU GLN ARG ASP PRO LEU LEU          
SEQRES  16 B  347  GLN PRO GLY ARG GLY GLN ILE MET LYS VAL ASP ALA PRO          
SEQRES  17 B  347  TRP MET LYS HIS PHE ILE LEU THR HIS ASP PRO GLU ARG          
SEQRES  18 B  347  GLY ILE TYR ASN SER PRO TYR ILE ILE PRO GLY THR GLN          
SEQRES  19 B  347  THR VAL THR LEU GLY GLY ILE PHE GLN LEU GLY ASN TRP          
SEQRES  20 B  347  SER GLU LEU ASN ASN ILE GLN ASP HIS ASN THR ILE TRP          
SEQRES  21 B  347  GLU GLY CYS CYS ARG LEU GLU PRO THR LEU LYS ASN ALA          
SEQRES  22 B  347  ARG ILE ILE GLY GLU ARG THR GLY PHE ARG PRO VAL ARG          
SEQRES  23 B  347  PRO GLN ILE ARG LEU GLU ARG GLU GLN LEU ARG THR GLY          
SEQRES  24 B  347  PRO SER ASN THR GLU VAL ILE HIS ASN TYR GLY HIS GLY          
SEQRES  25 B  347  GLY TYR GLY LEU THR ILE HIS TRP GLY CYS ALA LEU GLU          
SEQRES  26 B  347  ALA ALA LYS LEU PHE GLY ARG ILE LEU GLU GLU LYS LYS          
SEQRES  27 B  347  LEU SER ARG MET PRO PRO SER HIS LEU                          
SEQRES   1 G  347  MET ARG VAL VAL VAL ILE GLY ALA GLY VAL ILE GLY LEU          
SEQRES   2 G  347  SER THR ALA LEU CYS ILE HIS GLU ARG TYR HIS SER VAL          
SEQRES   3 G  347  LEU GLN PRO LEU ASP ILE LYS VAL TYR ALA ASP ARG PHE          
SEQRES   4 G  347  THR PRO LEU THR THR THR ASP VAL ALA ALA GLY LEU TRP          
SEQRES   5 G  347  GLN PRO TYR LEU SER ASP PRO ASN ASN PRO GLN GLU ALA          
SEQRES   6 G  347  ASP TRP SER GLN GLN THR PHE ASP TYR LEU LEU SER HIS          
SEQRES   7 G  347  VAL HIS SER PRO ASN ALA GLU ASN LEU GLY LEU PHE LEU          
SEQRES   8 G  347  ILE SER GLY TYR ASN LEU PHE HIS GLU ALA ILE PRO ASP          
SEQRES   9 G  347  PRO SER TRP LYS ASP THR VAL LEU GLY PHE ARG LYS LEU          
SEQRES  10 G  347  THR PRO ARG GLU LEU ASP MET PHE PRO ASP TYR GLY TYR          
SEQRES  11 G  347  GLY TRP PHE HIS THR SER LEU ILE LEU GLU GLY LYS ASN          
SEQRES  12 G  347  TYR LEU GLN TRP LEU THR GLU ARG LEU THR GLU ARG GLY          
SEQRES  13 G  347  VAL LYS PHE PHE GLN ARG LYS VAL GLU SER PHE GLU GLU          
SEQRES  14 G  347  VAL ALA ARG GLU GLY ALA ASP VAL ILE VAL ASN CYS THR          
SEQRES  15 G  347  GLY VAL TRP ALA GLY ALA LEU GLN ARG ASP PRO LEU LEU          
SEQRES  16 G  347  GLN PRO GLY ARG GLY GLN ILE MET LYS VAL ASP ALA PRO          
SEQRES  17 G  347  TRP MET LYS HIS PHE ILE LEU THR HIS ASP PRO GLU ARG          
SEQRES  18 G  347  GLY ILE TYR ASN SER PRO TYR ILE ILE PRO GLY THR GLN          
SEQRES  19 G  347  THR VAL THR LEU GLY GLY ILE PHE GLN LEU GLY ASN TRP          
SEQRES  20 G  347  SER GLU LEU ASN ASN ILE GLN ASP HIS ASN THR ILE TRP          
SEQRES  21 G  347  GLU GLY CYS CYS ARG LEU GLU PRO THR LEU LYS ASN ALA          
SEQRES  22 G  347  ARG ILE ILE GLY GLU ARG THR GLY PHE ARG PRO VAL ARG          
SEQRES  23 G  347  PRO GLN ILE ARG LEU GLU ARG GLU GLN LEU ARG THR GLY          
SEQRES  24 G  347  PRO SER ASN THR GLU VAL ILE HIS ASN TYR GLY HIS GLY          
SEQRES  25 G  347  GLY TYR GLY LEU THR ILE HIS TRP GLY CYS ALA LEU GLU          
SEQRES  26 G  347  ALA ALA LYS LEU PHE GLY ARG ILE LEU GLU GLU LYS LYS          
SEQRES  27 G  347  LEU SER ARG MET PRO PRO SER HIS LEU                          
SEQRES   1 J  347  MET ARG VAL VAL VAL ILE GLY ALA GLY VAL ILE GLY LEU          
SEQRES   2 J  347  SER THR ALA LEU CYS ILE HIS GLU ARG TYR HIS SER VAL          
SEQRES   3 J  347  LEU GLN PRO LEU ASP ILE LYS VAL TYR ALA ASP ARG PHE          
SEQRES   4 J  347  THR PRO LEU THR THR THR ASP VAL ALA ALA GLY LEU TRP          
SEQRES   5 J  347  GLN PRO TYR LEU SER ASP PRO ASN ASN PRO GLN GLU ALA          
SEQRES   6 J  347  ASP TRP SER GLN GLN THR PHE ASP TYR LEU LEU SER HIS          
SEQRES   7 J  347  VAL HIS SER PRO ASN ALA GLU ASN LEU GLY LEU PHE LEU          
SEQRES   8 J  347  ILE SER GLY TYR ASN LEU PHE HIS GLU ALA ILE PRO ASP          
SEQRES   9 J  347  PRO SER TRP LYS ASP THR VAL LEU GLY PHE ARG LYS LEU          
SEQRES  10 J  347  THR PRO ARG GLU LEU ASP MET PHE PRO ASP TYR GLY TYR          
SEQRES  11 J  347  GLY TRP PHE HIS THR SER LEU ILE LEU GLU GLY LYS ASN          
SEQRES  12 J  347  TYR LEU GLN TRP LEU THR GLU ARG LEU THR GLU ARG GLY          
SEQRES  13 J  347  VAL LYS PHE PHE GLN ARG LYS VAL GLU SER PHE GLU GLU          
SEQRES  14 J  347  VAL ALA ARG GLU GLY ALA ASP VAL ILE VAL ASN CYS THR          
SEQRES  15 J  347  GLY VAL TRP ALA GLY ALA LEU GLN ARG ASP PRO LEU LEU          
SEQRES  16 J  347  GLN PRO GLY ARG GLY GLN ILE MET LYS VAL ASP ALA PRO          
SEQRES  17 J  347  TRP MET LYS HIS PHE ILE LEU THR HIS ASP PRO GLU ARG          
SEQRES  18 J  347  GLY ILE TYR ASN SER PRO TYR ILE ILE PRO GLY THR GLN          
SEQRES  19 J  347  THR VAL THR LEU GLY GLY ILE PHE GLN LEU GLY ASN TRP          
SEQRES  20 J  347  SER GLU LEU ASN ASN ILE GLN ASP HIS ASN THR ILE TRP          
SEQRES  21 J  347  GLU GLY CYS CYS ARG LEU GLU PRO THR LEU LYS ASN ALA          
SEQRES  22 J  347  ARG ILE ILE GLY GLU ARG THR GLY PHE ARG PRO VAL ARG          
SEQRES  23 J  347  PRO GLN ILE ARG LEU GLU ARG GLU GLN LEU ARG THR GLY          
SEQRES  24 J  347  PRO SER ASN THR GLU VAL ILE HIS ASN TYR GLY HIS GLY          
SEQRES  25 J  347  GLY TYR GLY LEU THR ILE HIS TRP GLY CYS ALA LEU GLU          
SEQRES  26 J  347  ALA ALA LYS LEU PHE GLY ARG ILE LEU GLU GLU LYS LYS          
SEQRES  27 J  347  LEU SER ARG MET PRO PRO SER HIS LEU                          
HET    FAD    351      53                                                       
HET    BEZ    352       9                                                       
HET    FAD   1351      53                                                       
HET    BEZ   1352       9                                                       
HET    FAD   2351      53                                                       
HET    BEZ   2352       9                                                       
HET    FAD   3351      53                                                       
HET    BEZ   3352       9                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     BEZ BENZOIC ACID                                                     
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   6  BEZ    4(C7 H6 O2)                                                  
FORMUL  13  HOH   *256(H2 O)                                                    
CRYST1  150.976  183.184   51.075  90.00  90.00  90.00 P 21 21 2    16          
ATOM      1  N   MET A   1      18.270  65.522   8.077  1.00 58.43           N  
ATOM      2  CA  MET A   1      17.873  64.995   9.411  1.00 58.71           C  
ATOM      3  C   MET A   1      17.770  63.474   9.347  1.00 57.93           C  
ATOM      4  O   MET A   1      16.762  62.935   8.910  1.00 57.78           O  
ATOM      5  CB  MET A   1      16.553  65.632   9.855  1.00 59.10           C  
ATOM      6  CG  MET A   1      15.893  65.034  11.085  1.00 61.52           C  
ATOM      7  SD  MET A   1      16.728  65.410  12.638  1.00 69.00           S  
ATOM      8  CE  MET A   1      17.715  63.932  12.863  1.00 66.55           C  
ATOM      9  N   ARG A   2      18.830  62.801   9.788  1.00 57.12           N  
ATOM     10  CA  ARG A   2      18.928  61.355   9.718  1.00 56.55           C  
ATOM     11  C   ARG A   2      18.507  60.665  11.025  1.00 55.74           C  
ATOM     12  O   ARG A   2      19.204  60.780  12.052  1.00 55.30           O  
ATOM     13  CB  ARG A   2      20.355  60.940   9.359  1.00 56.90           C  
ATOM     14  CG  ARG A   2      20.811  61.389   7.998  1.00 59.35           C  
ATOM     15  CD  ARG A   2      22.255  60.960   7.723  1.00 63.10           C  
ATOM     16  NE  ARG A   2      22.583  61.221   6.327  1.00 69.27           N  
ATOM     17  CZ  ARG A   2      22.180  60.468   5.296  1.00 72.42           C  
ATOM     18  NH1 ARG A   2      21.442  59.369   5.491  1.00 74.01           N  
ATOM     19  NH2 ARG A   2      22.519  60.808   4.059  1.00 73.45           N  
ATOM     20  N   VAL A   3      17.396  59.921  10.952  1.00 54.24           N  
ATOM     21  CA  VAL A   3      16.806  59.223  12.098  1.00 53.01           C  
ATOM     22  C   VAL A   3      17.004  57.728  11.987  1.00 51.72           C  
ATOM     23  O   VAL A   3      16.521  57.122  11.036  1.00 52.31           O  
ATOM     24  CB  VAL A   3      15.307  59.461  12.158  1.00 53.04           C  
ATOM     25  CG1 VAL A   3      14.789  59.119  13.522  1.00 53.62           C  
ATOM     26  CG2 VAL A   3      15.010  60.908  11.852  1.00 54.46           C  
ATOM     27  N   VAL A   4      17.714  57.131  12.944  1.00 49.73           N  
ATOM     28  CA  VAL A   4      17.907  55.682  12.955  1.00 47.78           C  
ATOM     29  C   VAL A   4      17.103  55.052  14.072  1.00 46.54           C  
ATOM     30  O   VAL A   4      17.359  55.308  15.241  1.00 46.37           O  
ATOM     31  CB  VAL A   4      19.373  55.263  13.118  1.00 47.72           C  
ATOM     32  CG1 VAL A   4      19.463  53.728  13.154  1.00 47.65           C  
ATOM     33  CG2 VAL A   4      20.216  55.803  11.978  1.00 47.43           C  
ATOM     34  N   VAL A   5      16.122  54.237  13.703  1.00 45.22           N  
ATOM     35  CA  VAL A   5      15.310  53.509  14.677  1.00 43.92           C  
ATOM     36  C   VAL A   5      15.880  52.103  14.886  1.00 43.03           C  
ATOM     37  O   VAL A   5      16.013  51.338  13.920  1.00 42.91           O  
ATOM     38  CB  VAL A   5      13.868  53.420  14.215  1.00 43.94           C  
ATOM     39  CG1 VAL A   5      13.006  52.618  15.219  1.00 43.58           C  
ATOM     40  CG2 VAL A   5      13.316  54.812  14.017  1.00 44.01           C  
ATOM     41  N   ILE A   6      16.248  51.783  16.131  1.00 41.78           N  
ATOM     42  CA  ILE A   6      16.751  50.439  16.448  1.00 40.73           C  
ATOM     43  C   ILE A   6      15.631  49.553  17.008  1.00 39.43           C  
ATOM     44  O   ILE A   6      14.992  49.903  17.999  1.00 38.95           O  
ATOM     45  CB  ILE A   6      17.914  50.458  17.450  1.00 40.90           C  
ATOM     46  CG1 ILE A   6      18.910  51.580  17.137  1.00 42.64           C  
ATOM     47  CG2 ILE A   6      18.634  49.113  17.454  1.00 40.45           C  
ATOM     48  CD1 ILE A   6      20.153  51.623  18.104  1.00 40.61           C  
ATOM     49  N   GLY A   7      15.400  48.411  16.365  1.00 38.07           N  
ATOM     50  CA  GLY A   7      14.315  47.505  16.758  1.00 37.12           C  
ATOM     51  C   GLY A   7      13.133  47.475  15.791  1.00 36.33           C  
ATOM     52  O   GLY A   7      12.643  48.529  15.397  1.00 35.56           O  
ATOM     53  N   ALA A   8      12.688  46.271  15.418  1.00 34.87           N  
ATOM     54  CA  ALA A   8      11.574  46.079  14.491  1.00 34.13           C  
ATOM     55  C   ALA A   8      10.359  45.373  15.124  1.00 34.60           C  
ATOM     56  O   ALA A   8       9.590  44.720  14.431  1.00 35.59           O  
ATOM     57  CB  ALA A   8      12.038  45.311  13.275  1.00 33.29           C  
ATOM     58  N   GLY A   9      10.182  45.502  16.433  1.00 34.08           N  
ATOM     59  CA  GLY A   9       9.000  44.986  17.081  1.00 32.66           C  
ATOM     60  C   GLY A   9       7.894  45.994  16.994  1.00 32.71           C  
ATOM     61  O   GLY A   9       8.052  47.087  16.428  1.00 31.93           O  
ATOM     62  N   VAL A  10       6.752  45.661  17.564  1.00 32.91           N  
ATOM     63  CA  VAL A  10       5.680  46.633  17.534  1.00 34.14           C  
ATOM     64  C   VAL A  10       6.149  48.041  17.956  1.00 34.96           C  
ATOM     65  O   VAL A  10       5.653  49.026  17.424  1.00 36.31           O  
ATOM     66  CB  VAL A  10       4.494  46.238  18.398  1.00 34.07           C  
ATOM     67  CG1 VAL A  10       4.890  46.228  19.900  1.00 32.94           C  
ATOM     68  CG2 VAL A  10       3.336  47.194  18.126  1.00 32.93           C  
ATOM     69  N   ILE A  11       7.088  48.142  18.893  1.00 35.12           N  
ATOM     70  CA  ILE A  11       7.512  49.468  19.371  1.00 35.77           C  
ATOM     71  C   ILE A  11       8.322  50.263  18.336  1.00 36.17           C  
ATOM     72  O   ILE A  11       8.036  51.435  18.088  1.00 35.98           O  
ATOM     73  CB  ILE A  11       8.212  49.425  20.755  1.00 35.65           C  
ATOM     74  CG1 ILE A  11       7.342  48.685  21.782  1.00 32.31           C  
ATOM     75  CG2 ILE A  11       8.442  50.849  21.255  1.00 35.41           C  
ATOM     76  CD1 ILE A  11       5.988  49.347  22.030  1.00 27.17           C  
ATOM     77  N   GLY A  12       9.306  49.601  17.736  1.00 36.73           N  
ATOM     78  CA  GLY A  12      10.133  50.175  16.684  1.00 37.07           C  
ATOM     79  C   GLY A  12       9.361  50.611  15.448  1.00 37.70           C  
ATOM     80  O   GLY A  12       9.569  51.720  14.925  1.00 38.73           O  
ATOM     81  N   LEU A  13       8.463  49.759  14.978  1.00 37.50           N  
ATOM     82  CA  LEU A  13       7.740  50.033  13.740  1.00 36.97           C  
ATOM     83  C   LEU A  13       6.678  51.077  13.945  1.00 37.70           C  
ATOM     84  O   LEU A  13       6.537  51.984  13.128  1.00 37.30           O  
ATOM     85  CB  LEU A  13       7.136  48.757  13.175  1.00 36.60           C  
ATOM     86  CG  LEU A  13       8.220  47.776  12.726  1.00 36.61           C  
ATOM     87  CD1 LEU A  13       7.612  46.624  11.958  1.00 36.12           C  
ATOM     88  CD2 LEU A  13       9.268  48.474  11.884  1.00 35.69           C  
ATOM     89  N   SER A  14       5.932  50.964  15.039  1.00 38.41           N  
ATOM     90  CA  SER A  14       4.892  51.938  15.290  1.00 39.87           C  
ATOM     91  C   SER A  14       5.490  53.343  15.510  1.00 40.42           C  
ATOM     92  O   SER A  14       5.041  54.299  14.894  1.00 41.08           O  
ATOM     93  CB  SER A  14       3.984  51.500  16.441  1.00 39.54           C  
ATOM     94  OG  SER A  14       4.704  51.475  17.661  1.00 41.03           O  
ATOM     95  N   THR A  15       6.522  53.449  16.351  1.00 41.41           N  
ATOM     96  CA  THR A  15       7.275  54.697  16.531  1.00 41.80           C  
ATOM     97  C   THR A  15       7.784  55.214  15.191  1.00 42.57           C  
ATOM     98  O   THR A  15       7.461  56.343  14.818  1.00 42.79           O  
ATOM     99  CB  THR A  15       8.426  54.546  17.554  1.00 41.76           C  
ATOM    100  OG1 THR A  15       7.900  54.034  18.782  1.00 41.55           O  
ATOM    101  CG2 THR A  15       9.104  55.887  17.831  1.00 40.38           C  
ATOM    102  N   ALA A  16       8.512  54.378  14.449  1.00 43.03           N  
ATOM    103  CA  ALA A  16       8.937  54.743  13.097  1.00 44.05           C  
ATOM    104  C   ALA A  16       7.817  55.357  12.254  1.00 45.62           C  
ATOM    105  O   ALA A  16       8.000  56.436  11.661  1.00 45.76           O  
ATOM    106  CB  ALA A  16       9.510  53.567  12.398  1.00 43.79           C  
ATOM    107  N   LEU A  17       6.660  54.687  12.213  1.00 46.57           N  
ATOM    108  CA  LEU A  17       5.546  55.132  11.387  1.00 47.91           C  
ATOM    109  C   LEU A  17       5.004  56.450  11.892  1.00 49.19           C  
ATOM    110  O   LEU A  17       4.818  57.415  11.143  1.00 50.03           O  
ATOM    111  CB  LEU A  17       4.410  54.101  11.372  1.00 47.65           C  
ATOM    112  CG  LEU A  17       3.108  54.486  10.642  1.00 48.26           C  
ATOM    113  CD1 LEU A  17       3.379  54.869   9.166  1.00 48.06           C  
ATOM    114  CD2 LEU A  17       2.069  53.381  10.707  1.00 48.09           C  
ATOM    115  N   CYS A  18       4.726  56.474  13.177  1.00 49.96           N  
ATOM    116  CA  CYS A  18       4.116  57.619  13.789  1.00 51.13           C  
ATOM    117  C   CYS A  18       5.005  58.879  13.648  1.00 51.35           C  
ATOM    118  O   CYS A  18       4.509  59.994  13.601  1.00 51.76           O  
ATOM    119  CB  CYS A  18       3.880  57.266  15.240  1.00 50.88           C  
ATOM    120  SG  CYS A  18       2.700  58.231  16.047  1.00 54.24           S  
ATOM    121  N   ILE A  19       6.315  58.694  13.574  1.00 51.44           N  
ATOM    122  CA  ILE A  19       7.220  59.807  13.387  1.00 51.71           C  
ATOM    123  C   ILE A  19       7.196  60.251  11.922  1.00 52.68           C  
ATOM    124  O   ILE A  19       7.044  61.448  11.637  1.00 52.70           O  
ATOM    125  CB  ILE A  19       8.660  59.454  13.844  1.00 51.26           C  
ATOM    126  CG1 ILE A  19       8.724  59.361  15.369  1.00 49.93           C  
ATOM    127  CG2 ILE A  19       9.689  60.466  13.291  1.00 51.18           C  
ATOM    128  CD1 ILE A  19      10.087  58.995  15.878  1.00 48.78           C  
ATOM    129  N   HIS A  20       7.327  59.292  10.999  1.00 53.64           N  
ATOM    130  CA  HIS A  20       7.333  59.611   9.566  1.00 54.75           C  
ATOM    131  C   HIS A  20       6.054  60.288   9.129  1.00 55.66           C  
ATOM    132  O   HIS A  20       6.106  61.312   8.467  1.00 55.96           O  
ATOM    133  CB  HIS A  20       7.581  58.399   8.670  1.00 54.56           C  
ATOM    134  CG  HIS A  20       7.797  58.763   7.236  1.00 53.96           C  
ATOM    135  ND1 HIS A  20       6.773  59.179   6.413  1.00 54.25           N  
ATOM    136  CD2 HIS A  20       8.924  58.803   6.484  1.00 55.09           C  
ATOM    137  CE1 HIS A  20       7.257  59.443   5.211  1.00 54.69           C  
ATOM    138  NE2 HIS A  20       8.560  59.223   5.227  1.00 54.91           N  
ATOM    139  N   GLU A  21       4.911  59.720   9.491  1.00 56.78           N  
ATOM    140  CA  GLU A  21       3.640  60.319   9.113  1.00 58.38           C  
ATOM    141  C   GLU A  21       3.459  61.747   9.643  1.00 58.62           C  
ATOM    142  O   GLU A  21       2.696  62.525   9.078  1.00 59.06           O  
ATOM    143  CB  GLU A  21       2.455  59.420   9.494  1.00 58.49           C  
ATOM    144  CG  GLU A  21       1.892  59.622  10.887  1.00 60.93           C  
ATOM    145  CD  GLU A  21       0.792  58.599  11.236  1.00 65.18           C  
ATOM    146  OE1 GLU A  21       0.104  58.793  12.274  1.00 65.49           O  
ATOM    147  OE2 GLU A  21       0.617  57.604  10.478  1.00 65.72           O  
ATOM    148  N   ARG A  22       4.186  62.106  10.692  1.00 59.00           N  
ATOM    149  CA  ARG A  22       3.958  63.391  11.327  1.00 59.51           C  
ATOM    150  C   ARG A  22       5.000  64.475  10.995  1.00 59.32           C  
ATOM    151  O   ARG A  22       4.739  65.649  11.205  1.00 58.84           O  
ATOM    152  CB  ARG A  22       3.797  63.201  12.840  1.00 59.68           C  
ATOM    153  CG  ARG A  22       3.865  64.490  13.646  1.00 62.15           C  
ATOM    154  CD  ARG A  22       3.421  64.289  15.078  1.00 65.62           C  
ATOM    155  NE  ARG A  22       3.953  65.319  15.979  1.00 67.09           N  
ATOM    156  CZ  ARG A  22       3.298  65.804  17.035  1.00 68.25           C  
ATOM    157  NH1 ARG A  22       3.865  66.727  17.800  1.00 67.97           N  
ATOM    158  NH2 ARG A  22       2.067  65.378  17.323  1.00 67.91           N  
ATOM    159  N   TYR A  23       6.162  64.087  10.472  1.00 59.68           N  
ATOM    160  CA  TYR A  23       7.256  65.041  10.273  1.00 60.16           C  
ATOM    161  C   TYR A  23       7.959  64.965   8.925  1.00 60.93           C  
ATOM    162  O   TYR A  23       9.000  65.610   8.742  1.00 60.84           O  
ATOM    163  CB  TYR A  23       8.316  64.922  11.389  1.00 60.02           C  
ATOM    164  CG  TYR A  23       7.805  65.284  12.759  1.00 58.90           C  
ATOM    165  CD1 TYR A  23       7.451  66.595  13.071  1.00 57.20           C  
ATOM    166  CD2 TYR A  23       7.660  64.308  13.740  1.00 58.43           C  
ATOM    167  CE1 TYR A  23       6.973  66.925  14.327  1.00 57.36           C  
ATOM    168  CE2 TYR A  23       7.183  64.625  15.001  1.00 58.20           C  
ATOM    169  CZ  TYR A  23       6.846  65.932  15.288  1.00 57.78           C  
ATOM    170  OH  TYR A  23       6.361  66.232  16.530  1.00 56.91           O  
ATOM    171  N   HIS A  24       7.421  64.189   7.985  1.00 61.66           N  
ATOM    172  CA  HIS A  24       8.032  64.113   6.656  1.00 62.44           C  
ATOM    173  C   HIS A  24       7.769  65.389   5.836  1.00 63.09           C  
ATOM    174  O   HIS A  24       8.562  65.739   4.962  1.00 63.21           O  
ATOM    175  CB  HIS A  24       7.530  62.898   5.904  1.00 62.26           C  
ATOM    176  CG  HIS A  24       6.111  63.023   5.470  1.00 62.35           C  
ATOM    177  ND1 HIS A  24       5.757  63.228   4.154  1.00 62.41           N  
ATOM    178  CD2 HIS A  24       4.956  63.019   6.180  1.00 62.30           C  
ATOM    179  CE1 HIS A  24       4.439  63.305   4.070  1.00 63.13           C  
ATOM    180  NE2 HIS A  24       3.930  63.189   5.285  1.00 62.23           N  
ATOM    181  N   SER A  25       6.663  66.069   6.141  1.00 63.76           N  
ATOM    182  CA  SER A  25       6.285  67.316   5.471  1.00 64.77           C  
ATOM    183  C   SER A  25       7.014  68.560   6.033  1.00 65.53           C  
ATOM    184  O   SER A  25       7.184  69.566   5.314  1.00 65.70           O  
ATOM    185  CB  SER A  25       4.760  67.522   5.524  1.00 64.54           C  
ATOM    186  OG  SER A  25       4.346  67.964   6.807  1.00 64.80           O  
ATOM    187  N   VAL A  26       7.424  68.497   7.306  1.00 65.72           N  
ATOM    188  CA  VAL A  26       8.108  69.623   7.957  1.00 66.02           C  
ATOM    189  C   VAL A  26       9.629  69.425   8.098  1.00 66.10           C  
ATOM    190  O   VAL A  26      10.239  69.888   9.056  1.00 66.50           O  
ATOM    191  CB  VAL A  26       7.437  70.004   9.321  1.00 66.28           C  
ATOM    192  CG1 VAL A  26       5.956  70.360   9.117  1.00 66.46           C  
ATOM    193  CG2 VAL A  26       7.583  68.886  10.355  1.00 66.73           C  
ATOM    194  N   LEU A  27      10.230  68.744   7.126  1.00 66.10           N  
ATOM    195  CA  LEU A  27      11.658  68.421   7.122  1.00 65.94           C  
ATOM    196  C   LEU A  27      12.000  67.910   5.745  1.00 65.45           C  
ATOM    197  O   LEU A  27      11.439  66.893   5.317  1.00 65.85           O  
ATOM    198  CB  LEU A  27      11.970  67.299   8.118  1.00 66.29           C  
ATOM    199  CG  LEU A  27      12.148  67.545   9.617  1.00 67.01           C  
ATOM    200  CD1 LEU A  27      12.443  66.216  10.297  1.00 66.82           C  
ATOM    201  CD2 LEU A  27      13.270  68.545   9.895  1.00 67.30           C  
ATOM    202  N   GLN A  28      12.919  68.584   5.050  1.00 64.56           N  
ATOM    203  CA  GLN A  28      13.174  68.215   3.659  1.00 63.85           C  
ATOM    204  C   GLN A  28      13.950  66.885   3.527  1.00 62.21           C  
ATOM    205  O   GLN A  28      13.447  65.923   2.923  1.00 62.97           O  
ATOM    206  CB  GLN A  28      13.834  69.348   2.865  1.00 64.32           C  
ATOM    207  CG  GLN A  28      13.557  69.284   1.348  1.00 66.91           C  
ATOM    208  CD  GLN A  28      14.219  68.098   0.627  1.00 69.96           C  
ATOM    209  OE1 GLN A  28      15.443  68.027   0.507  1.00 72.22           O  
ATOM    210  NE2 GLN A  28      13.402  67.170   0.133  1.00 71.36           N  
ATOM    211  N   PRO A  29      15.183  66.817   4.049  1.00 59.81           N  
ATOM    212  CA  PRO A  29      15.693  65.452   4.099  1.00 57.38           C  
ATOM    213  C   PRO A  29      15.354  64.765   5.437  1.00 54.61           C  
ATOM    214  O   PRO A  29      16.099  64.918   6.415  1.00 54.85           O  
ATOM    215  CB  PRO A  29      17.213  65.641   3.909  1.00 57.75           C  
ATOM    216  CG  PRO A  29      17.468  67.200   3.997  1.00 59.14           C  
ATOM    217  CD  PRO A  29      16.179  67.795   4.522  1.00 60.02           C  
ATOM    218  N   LEU A  30      14.218  64.058   5.487  1.00 50.68           N  
ATOM    219  CA  LEU A  30      13.915  63.152   6.608  1.00 46.51           C  
ATOM    220  C   LEU A  30      14.129  61.700   6.196  1.00 45.13           C  
ATOM    221  O   LEU A  30      13.167  60.993   5.900  1.00 45.22           O  
ATOM    222  CB  LEU A  30      12.499  63.349   7.186  1.00 47.04           C  
ATOM    223  CG  LEU A  30      12.081  62.424   8.363  1.00 48.13           C  
ATOM    224  CD1 LEU A  30      13.098  62.434   9.498  1.00 48.30           C  
ATOM    225  CD2 LEU A  30      10.707  62.717   8.928  1.00 48.13           C  
ATOM    226  N   ASP A  31      15.385  61.234   6.239  1.00 35.24           N  
ATOM    227  CA  ASP A  31      15.740  59.848   5.864  1.00 35.24           C  
ATOM    228  C   ASP A  31      15.782  58.913   7.135  1.00 35.24           C  
ATOM    229  O   ASP A  31      16.726  58.972   7.949  1.00 41.55           O  
ATOM    230  CB  ASP A  31      16.978  59.842   4.968  1.00 34.38           C  
ATOM    231  CG  ASP A  31      16.631  60.464   3.586  1.00 35.24           C  
ATOM    232  OD1 ASP A  31      16.197  61.714   3.513  1.00 30.55           O  
ATOM    233  OD2 ASP A  31      16.665  59.711   2.522  1.00 30.92           O  
ATOM    234  N   ILE A  32      14.699  58.127   7.270  1.00 40.56           N  
ATOM    235  CA  ILE A  32      14.484  57.195   8.377  1.00 43.01           C  
ATOM    236  C   ILE A  32      14.847  55.762   8.000  1.00 44.36           C  
ATOM    237  O   ILE A  32      14.319  55.215   7.030  1.00 45.68           O  
ATOM    238  CB  ILE A  32      13.031  57.186   8.841  1.00 42.84           C  
ATOM    239  CG1 ILE A  32      12.515  58.620   8.987  1.00 44.14           C  
ATOM    240  CG2 ILE A  32      12.921  56.398  10.149  1.00 43.43           C  
ATOM    241  CD1 ILE A  32      11.158  58.747   9.658  1.00 45.61           C  
ATOM    242  N   LYS A  33      15.742  55.158   8.777  1.00 45.31           N  
ATOM    243  CA  LYS A  33      16.147  53.772   8.556  1.00 46.13           C  
ATOM    244  C   LYS A  33      15.871  52.952   9.802  1.00 46.22           C  
ATOM    245  O   LYS A  33      15.962  53.468  10.924  1.00 46.60           O  
ATOM    246  CB  LYS A  33      17.633  53.675   8.197  1.00 46.56           C  
ATOM    247  CG  LYS A  33      18.040  54.441   6.945  1.00 47.50           C  
ATOM    248  CD  LYS A  33      19.427  55.050   7.071  1.00 50.51           C  
ATOM    249  CE  LYS A  33      20.490  54.027   7.404  1.00 52.02           C  
ATOM    250  NZ  LYS A  33      21.838  54.659   7.611  1.00 55.11           N  
ATOM    251  N   VAL A  34      15.518  51.683   9.605  1.00 45.76           N  
ATOM    252  CA  VAL A  34      15.319  50.782  10.727  1.00 45.26           C  
ATOM    253  C   VAL A  34      16.458  49.771  10.750  1.00 45.79           C  
ATOM    254  O   VAL A  34      16.701  49.064   9.745  1.00 45.41           O  
ATOM    255  CB  VAL A  34      13.945  50.079  10.679  1.00 45.18           C  
ATOM    256  CG1 VAL A  34      13.844  48.998  11.766  1.00 43.87           C  
ATOM    257  CG2 VAL A  34      12.816  51.095  10.826  1.00 44.34           C  
ATOM    258  N   TYR A  35      17.175  49.735  11.877  1.00 45.72           N  
ATOM    259  CA  TYR A  35      18.222  48.726  12.100  1.00 46.72           C  
ATOM    260  C   TYR A  35      17.688  47.702  13.091  1.00 46.42           C  
ATOM    261  O   TYR A  35      17.235  48.082  14.180  1.00 46.19           O  
ATOM    262  CB  TYR A  35      19.491  49.353  12.699  1.00 46.74           C  
ATOM    263  CG  TYR A  35      20.333  50.207  11.787  1.00 48.64           C  
ATOM    264  CD1 TYR A  35      19.907  50.535  10.496  1.00 49.86           C  
ATOM    265  CD2 TYR A  35      21.554  50.725  12.238  1.00 49.71           C  
ATOM    266  CE1 TYR A  35      20.683  51.322   9.674  1.00 51.79           C  
ATOM    267  CE2 TYR A  35      22.341  51.511  11.427  1.00 51.00           C  
ATOM    268  CZ  TYR A  35      21.900  51.814  10.144  1.00 53.58           C  
ATOM    269  OH  TYR A  35      22.679  52.601   9.317  1.00 56.80           O  
ATOM    270  N   ALA A  36      17.742  46.421  12.730  1.00 46.55           N  
ATOM    271  CA  ALA A  36      17.307  45.347  13.652  1.00 46.93           C  
ATOM    272  C   ALA A  36      18.043  44.036  13.475  1.00 47.50           C  
ATOM    273  O   ALA A  36      18.501  43.696  12.379  1.00 46.34           O  
ATOM    274  CB  ALA A  36      15.806  45.120  13.575  1.00 46.69           C  
ATOM    275  N   ASP A  37      18.155  43.309  14.585  1.00 49.17           N  
ATOM    276  CA  ASP A  37      18.760  41.979  14.605  1.00 50.63           C  
ATOM    277  C   ASP A  37      17.786  40.948  14.049  1.00 50.95           C  
ATOM    278  O   ASP A  37      18.116  40.216  13.121  1.00 50.97           O  
ATOM    279  CB  ASP A  37      19.196  41.602  16.026  1.00 51.14           C  
ATOM    280  CG  ASP A  37      20.056  40.349  16.058  1.00 53.78           C  
ATOM    281  OD1 ASP A  37      20.952  40.208  15.197  1.00 57.21           O  
ATOM    282  OD2 ASP A  37      19.836  39.486  16.934  1.00 57.90           O  
ATOM    283  N   ARG A  38      16.583  40.920  14.614  1.00 51.91           N  
ATOM    284  CA  ARG A  38      15.527  40.002  14.187  1.00 53.30           C  
ATOM    285  C   ARG A  38      14.293  40.762  13.667  1.00 52.64           C  
ATOM    286  O   ARG A  38      13.902  41.789  14.229  1.00 52.19           O  
ATOM    287  CB  ARG A  38      15.181  38.992  15.308  1.00 53.60           C  
ATOM    288  CG  ARG A  38      14.806  39.631  16.659  1.00 58.22           C  
ATOM    289  CD  ARG A  38      15.557  38.998  17.897  1.00 63.27           C  
ATOM    290  NE  ARG A  38      16.021  40.035  18.844  1.00 65.87           N  
ATOM    291  CZ  ARG A  38      17.301  40.291  19.160  1.00 67.07           C  
ATOM    292  NH1 ARG A  38      18.293  39.567  18.662  1.00 67.26           N  
ATOM    293  NH2 ARG A  38      17.597  41.261  20.013  1.00 67.31           N  
ATOM    294  N   PHE A  39      13.704  40.256  12.585  1.00 52.43           N  
ATOM    295  CA  PHE A  39      12.535  40.893  11.986  1.00 52.93           C  
ATOM    296  C   PHE A  39      11.224  40.144  12.144  1.00 53.96           C  
ATOM    297  O   PHE A  39      11.159  39.058  12.707  1.00 54.21           O  
ATOM    298  CB  PHE A  39      12.764  41.261  10.500  1.00 52.35           C  
ATOM    299  CG  PHE A  39      13.512  42.549  10.308  1.00 50.51           C  
ATOM    300  CD1 PHE A  39      12.848  43.767  10.366  1.00 48.50           C  
ATOM    301  CD2 PHE A  39      14.891  42.547  10.115  1.00 48.73           C  
ATOM    302  CE1 PHE A  39      13.536  44.960  10.213  1.00 48.40           C  
ATOM    303  CE2 PHE A  39      15.596  43.739   9.962  1.00 48.16           C  
ATOM    304  CZ  PHE A  39      14.919  44.950  10.005  1.00 47.66           C  
ATOM    305  N   THR A  40      10.206  40.773  11.571  1.00 55.45           N  
ATOM    306  CA  THR A  40       8.761  40.458  11.622  1.00 56.36           C  
ATOM    307  C   THR A  40       8.176  39.085  11.892  1.00 56.17           C  
ATOM    308  O   THR A  40       7.034  39.038  12.356  1.00 56.58           O  
ATOM    309  CB  THR A  40       8.019  41.022  10.371  1.00 56.54           C  
ATOM    310  OG1 THR A  40       6.632  40.668  10.441  1.00 57.89           O  
ATOM    311  CG2 THR A  40       8.628  40.475   9.064  1.00 58.30           C  
ATOM    312  N   PRO A  41       8.843  37.987  11.477  1.00 55.79           N  
ATOM    313  CA  PRO A  41       8.374  36.702  12.035  1.00 55.28           C  
ATOM    314  C   PRO A  41       9.048  36.173  13.337  1.00 54.44           C  
ATOM    315  O   PRO A  41       8.512  35.270  13.976  1.00 54.51           O  
ATOM    316  CB  PRO A  41       8.591  35.727  10.870  1.00 55.61           C  
ATOM    317  CG  PRO A  41       9.755  36.323  10.096  1.00 56.13           C  
ATOM    318  CD  PRO A  41       9.874  37.795  10.439  1.00 55.64           C  
ATOM    319  N   LEU A  42      10.182  36.740  13.740  1.00 53.46           N  
ATOM    320  CA  LEU A  42      11.007  36.156  14.810  1.00 51.97           C  
ATOM    321  C   LEU A  42      11.251  37.069  16.030  1.00 51.22           C  
ATOM    322  O   LEU A  42      12.279  36.953  16.718  1.00 51.60           O  
ATOM    323  CB  LEU A  42      12.342  35.693  14.218  1.00 52.31           C  
ATOM    324  CG  LEU A  42      12.233  35.102  12.797  1.00 53.05           C  
ATOM    325  CD1 LEU A  42      13.457  35.397  11.941  1.00 52.47           C  
ATOM    326  CD2 LEU A  42      11.911  33.599  12.824  1.00 54.00           C  
ATOM    327  N   THR A  43      10.306  37.959  16.303  1.00 49.35           N  
ATOM    328  CA  THR A  43      10.403  38.878  17.423  1.00 48.00           C  
ATOM    329  C   THR A  43       9.418  38.496  18.516  1.00 47.67           C  
ATOM    330  O   THR A  43       8.486  37.720  18.285  1.00 48.18           O  
ATOM    331  CB  THR A  43      10.099  40.364  16.995  1.00 48.22           C  
ATOM    332  OG1 THR A  43       8.679  40.560  16.857  1.00 46.47           O  
ATOM    333  CG2 THR A  43      10.805  40.720  15.685  1.00 46.42           C  
ATOM    334  N   THR A  44       9.613  39.078  19.695  1.00 46.50           N  
ATOM    335  CA  THR A  44       8.716  38.917  20.834  1.00 45.92           C  
ATOM    336  C   THR A  44       7.270  39.260  20.501  1.00 45.44           C  
ATOM    337  O   THR A  44       6.337  38.550  20.913  1.00 44.96           O  
ATOM    338  CB  THR A  44       9.185  39.806  21.990  1.00 45.76           C  
ATOM    339  OG1 THR A  44      10.536  39.453  22.304  1.00 48.01           O  
ATOM    340  CG2 THR A  44       8.314  39.632  23.227  1.00 44.21           C  
ATOM    341  N   THR A  45       7.093  40.358  19.765  1.00 45.15           N  
ATOM    342  CA  THR A  45       5.783  40.768  19.285  1.00 44.75           C  
ATOM    343  C   THR A  45       5.034  39.657  18.550  1.00 45.09           C  
ATOM    344  O   THR A  45       3.820  39.541  18.690  1.00 45.41           O  
ATOM    345  CB  THR A  45       5.870  42.033  18.424  1.00 44.71           C  
ATOM    346  OG1 THR A  45       6.449  43.082  19.211  1.00 43.73           O  
ATOM    347  CG2 THR A  45       4.469  42.461  17.952  1.00 42.57           C  
ATOM    348  N   ASP A  46       5.758  38.830  17.801  1.00 45.92           N  
ATOM    349  CA  ASP A  46       5.169  37.656  17.122  1.00 46.61           C  
ATOM    350  C   ASP A  46       4.601  36.566  18.034  1.00 46.66           C  
ATOM    351  O   ASP A  46       3.725  35.823  17.618  1.00 47.27           O  
ATOM    352  CB  ASP A  46       6.197  37.026  16.175  1.00 46.73           C  
ATOM    353  CG  ASP A  46       6.673  38.000  15.129  1.00 47.90           C  
ATOM    354  OD1 ASP A  46       7.900  38.257  15.029  1.00 48.73           O  
ATOM    355  OD2 ASP A  46       5.799  38.548  14.429  1.00 49.03           O  
ATOM    356  N   VAL A  47       5.118  36.474  19.257  1.00 46.72           N  
ATOM    357  CA  VAL A  47       4.733  35.459  20.232  1.00 46.52           C  
ATOM    358  C   VAL A  47       3.480  35.896  20.985  1.00 45.79           C  
ATOM    359  O   VAL A  47       2.803  35.090  21.587  1.00 45.58           O  
ATOM    360  CB  VAL A  47       5.855  35.279  21.284  1.00 46.94           C  
ATOM    361  CG1 VAL A  47       5.520  34.138  22.262  1.00 48.46           C  
ATOM    362  CG2 VAL A  47       7.211  35.051  20.609  1.00 47.35           C  
ATOM    363  N   ALA A  48       3.196  37.189  20.981  1.00 45.32           N  
ATOM    364  CA  ALA A  48       2.114  37.726  21.781  1.00 44.63           C  
ATOM    365  C   ALA A  48       0.730  37.399  21.187  1.00 45.01           C  
ATOM    366  O   ALA A  48       0.542  37.488  19.974  1.00 45.09           O  
ATOM    367  CB  ALA A  48       2.303  39.195  21.935  1.00 43.82           C  
ATOM    368  N   ALA A  49      -0.241  37.025  22.034  1.00 45.04           N  
ATOM    369  CA  ALA A  49      -1.612  36.804  21.545  1.00 44.82           C  
ATOM    370  C   ALA A  49      -2.220  38.091  20.970  1.00 44.51           C  
ATOM    371  O   ALA A  49      -2.963  38.076  19.983  1.00 44.76           O  
ATOM    372  CB  ALA A  49      -2.493  36.242  22.627  1.00 44.27           C  
ATOM    373  N   GLY A  50      -1.878  39.204  21.587  1.00 43.90           N  
ATOM    374  CA  GLY A  50      -2.405  40.469  21.165  1.00 43.64           C  
ATOM    375  C   GLY A  50      -3.570  40.985  21.970  1.00 43.77           C  
ATOM    376  O   GLY A  50      -4.186  41.956  21.557  1.00 44.16           O  
ATOM    377  N   LEU A  51      -3.887  40.378  23.114  1.00 43.66           N  
ATOM    378  CA  LEU A  51      -5.068  40.841  23.866  1.00 44.16           C  
ATOM    379  C   LEU A  51      -4.821  42.215  24.494  1.00 44.56           C  
ATOM    380  O   LEU A  51      -3.761  42.471  25.069  1.00 45.14           O  
ATOM    381  CB  LEU A  51      -5.542  39.806  24.903  1.00 43.44           C  
ATOM    382  CG  LEU A  51      -6.655  40.188  25.896  1.00 44.70           C  
ATOM    383  CD1 LEU A  51      -7.979  40.633  25.219  1.00 44.87           C  
ATOM    384  CD2 LEU A  51      -6.925  39.064  26.904  1.00 44.26           C  
ATOM    385  N   TRP A  52      -5.781  43.111  24.343  1.00 44.75           N  
ATOM    386  CA  TRP A  52      -5.692  44.388  25.025  1.00 45.45           C  
ATOM    387  C   TRP A  52      -6.162  44.227  26.456  1.00 45.51           C  
ATOM    388  O   TRP A  52      -7.319  43.889  26.711  1.00 44.74           O  
ATOM    389  CB  TRP A  52      -6.517  45.472  24.328  1.00 45.36           C  
ATOM    390  CG  TRP A  52      -6.197  46.864  24.825  1.00 45.50           C  
ATOM    391  CD1 TRP A  52      -5.384  47.759  24.226  1.00 45.82           C  
ATOM    392  CD2 TRP A  52      -6.694  47.503  26.012  1.00 44.93           C  
ATOM    393  NE1 TRP A  52      -5.336  48.919  24.950  1.00 46.41           N  
ATOM    394  CE2 TRP A  52      -6.128  48.788  26.057  1.00 45.25           C  
ATOM    395  CE3 TRP A  52      -7.570  47.115  27.035  1.00 46.84           C  
ATOM    396  CZ2 TRP A  52      -6.395  49.702  27.090  1.00 46.38           C  
ATOM    397  CZ3 TRP A  52      -7.848  48.025  28.069  1.00 46.70           C  
ATOM    398  CH2 TRP A  52      -7.256  49.303  28.087  1.00 46.48           C  
ATOM    399  N   GLN A  53      -5.235  44.467  27.371  1.00 46.50           N  
ATOM    400  CA  GLN A  53      -5.486  44.487  28.809  1.00 47.47           C  
ATOM    401  C   GLN A  53      -4.191  44.848  29.523  1.00 48.41           C  
ATOM    402  O   GLN A  53      -3.222  44.076  29.468  1.00 47.81           O  
ATOM    403  CB  GLN A  53      -5.999  43.130  29.324  1.00 47.68           C  
ATOM    404  CG  GLN A  53      -6.683  43.197  30.711  1.00 45.86           C  
ATOM    405  CD  GLN A  53      -7.368  41.902  31.091  1.00 43.27           C  
ATOM    406  OE1 GLN A  53      -8.247  41.422  30.373  1.00 43.67           O  
ATOM    407  NE2 GLN A  53      -6.963  41.323  32.224  1.00 40.48           N  
ATOM    408  N   PRO A  54      -4.173  46.018  30.199  1.00 49.65           N  
ATOM    409  CA  PRO A  54      -3.037  46.422  31.017  1.00 50.87           C  
ATOM    410  C   PRO A  54      -2.964  45.556  32.260  1.00 52.48           C  
ATOM    411  O   PRO A  54      -3.915  44.800  32.542  1.00 52.67           O  
ATOM    412  CB  PRO A  54      -3.376  47.869  31.400  1.00 50.62           C  
ATOM    413  CG  PRO A  54      -4.469  48.287  30.465  1.00 49.82           C  
ATOM    414  CD  PRO A  54      -5.234  47.038  30.230  1.00 49.52           C  
ATOM    415  N   TYR A  55      -1.849  45.653  32.989  1.00 54.57           N  
ATOM    416  CA  TYR A  55      -1.727  44.988  34.278  1.00 56.71           C  
ATOM    417  C   TYR A  55      -2.931  45.306  35.187  1.00 58.10           C  
ATOM    418  O   TYR A  55      -3.633  46.312  35.026  1.00 57.76           O  
ATOM    419  CB  TYR A  55      -0.397  45.323  34.986  1.00 56.88           C  
ATOM    420  CG  TYR A  55       0.869  44.727  34.379  1.00 56.55           C  
ATOM    421  CD1 TYR A  55       0.829  43.610  33.522  1.00 57.33           C  
ATOM    422  CD2 TYR A  55       2.119  45.277  34.680  1.00 56.52           C  
ATOM    423  CE1 TYR A  55       2.022  43.064  32.957  1.00 56.84           C  
ATOM    424  CE2 TYR A  55       3.310  44.752  34.138  1.00 57.03           C  
ATOM    425  CZ  TYR A  55       3.259  43.649  33.275  1.00 57.87           C  
ATOM    426  OH  TYR A  55       4.444  43.151  32.759  1.00 57.07           O  
ATOM    427  N   LEU A  56      -3.162  44.410  36.134  1.00 60.38           N  
ATOM    428  CA  LEU A  56      -4.310  44.488  37.015  1.00 62.74           C  
ATOM    429  C   LEU A  56      -4.221  45.662  38.011  1.00 64.28           C  
ATOM    430  O   LEU A  56      -5.213  46.351  38.265  1.00 64.42           O  
ATOM    431  CB  LEU A  56      -4.435  43.152  37.741  1.00 62.92           C  
ATOM    432  CG  LEU A  56      -5.792  42.477  37.806  1.00 62.91           C  
ATOM    433  CD1 LEU A  56      -6.737  43.370  38.595  1.00 63.97           C  
ATOM    434  CD2 LEU A  56      -6.303  42.202  36.404  1.00 63.72           C  
ATOM    435  N   SER A  57      -3.030  45.897  38.559  1.00 66.33           N  
ATOM    436  CA  SER A  57      -2.830  47.014  39.480  1.00 68.16           C  
ATOM    437  C   SER A  57      -2.298  48.248  38.759  1.00 69.43           C  
ATOM    438  O   SER A  57      -1.510  48.136  37.814  1.00 69.63           O  
ATOM    439  CB  SER A  57      -1.910  46.618  40.645  1.00 68.21           C  
ATOM    440  OG  SER A  57      -0.576  46.393  40.215  1.00 68.51           O  
ATOM    441  N   ASP A  58      -2.747  49.416  39.223  1.00 71.04           N  
ATOM    442  CA  ASP A  58      -2.328  50.731  38.708  1.00 72.66           C  
ATOM    443  C   ASP A  58      -0.803  50.861  38.524  1.00 73.32           C  
ATOM    444  O   ASP A  58      -0.029  50.364  39.355  1.00 73.46           O  
ATOM    445  CB  ASP A  58      -2.843  51.844  39.635  1.00 72.95           C  
ATOM    446  CG  ASP A  58      -4.362  51.834  39.789  1.00 74.76           C  
ATOM    447  OD1 ASP A  58      -4.944  50.754  40.038  1.00 76.48           O  
ATOM    448  OD2 ASP A  58      -4.984  52.914  39.670  1.00 77.24           O  
ATOM    449  N   PRO A  59      -0.368  51.525  37.429  1.00 73.98           N  
ATOM    450  CA  PRO A  59       1.066  51.684  37.120  1.00 74.32           C  
ATOM    451  C   PRO A  59       1.751  52.840  37.877  1.00 74.79           C  
ATOM    452  O   PRO A  59       1.170  53.925  38.027  1.00 74.68           O  
ATOM    453  CB  PRO A  59       1.062  51.954  35.614  1.00 74.48           C  
ATOM    454  CG  PRO A  59      -0.261  52.642  35.352  1.00 74.13           C  
ATOM    455  CD  PRO A  59      -1.232  52.166  36.414  1.00 73.79           C  
ATOM    456  N   ASN A  60       2.984  52.613  38.336  1.00 75.32           N  
ATOM    457  CA  ASN A  60       3.738  53.625  39.100  1.00 75.71           C  
ATOM    458  C   ASN A  60       3.948  54.920  38.288  1.00 75.64           C  
ATOM    459  O   ASN A  60       4.462  55.915  38.795  1.00 75.61           O  
ATOM    460  CB  ASN A  60       5.069  53.033  39.616  1.00 76.03           C  
ATOM    461  CG  ASN A  60       5.620  53.759  40.863  1.00 76.62           C  
ATOM    462  OD1 ASN A  60       6.306  54.776  40.759  1.00 77.82           O  
ATOM    463  ND2 ASN A  60       5.352  53.204  42.037  1.00 77.49           N  
ATOM    464  N   ASN A  61       3.519  54.888  37.026  1.00 75.64           N  
ATOM    465  CA  ASN A  61       3.549  56.035  36.121  1.00 75.18           C  
ATOM    466  C   ASN A  61       2.157  56.209  35.492  1.00 74.65           C  
ATOM    467  O   ASN A  61       1.811  55.499  34.553  1.00 74.89           O  
ATOM    468  CB  ASN A  61       4.625  55.806  35.051  1.00 75.40           C  
ATOM    469  CG  ASN A  61       4.604  56.852  33.941  1.00 76.47           C  
ATOM    470  OD1 ASN A  61       3.922  57.877  34.035  1.00 77.48           O  
ATOM    471  ND2 ASN A  61       5.362  56.587  32.876  1.00 76.93           N  
ATOM    472  N   PRO A  62       1.349  57.145  36.019  1.00 74.03           N  
ATOM    473  CA  PRO A  62      -0.029  57.366  35.546  1.00 73.36           C  
ATOM    474  C   PRO A  62      -0.193  57.788  34.070  1.00 72.56           C  
ATOM    475  O   PRO A  62      -1.313  57.774  33.559  1.00 72.52           O  
ATOM    476  CB  PRO A  62      -0.549  58.471  36.483  1.00 73.49           C  
ATOM    477  CG  PRO A  62       0.679  59.149  37.002  1.00 73.59           C  
ATOM    478  CD  PRO A  62       1.699  58.057  37.126  1.00 74.04           C  
ATOM    479  N   GLN A  63       0.896  58.168  33.400  1.00 71.68           N  
ATOM    480  CA  GLN A  63       0.859  58.445  31.953  1.00 70.83           C  
ATOM    481  C   GLN A  63       0.489  57.184  31.167  1.00 69.89           C  
ATOM    482  O   GLN A  63      -0.071  57.277  30.069  1.00 69.70           O  
ATOM    483  CB  GLN A  63       2.208  58.949  31.427  1.00 70.90           C  
ATOM    484  CG  GLN A  63       2.663  60.320  31.903  1.00 72.02           C  
ATOM    485  CD  GLN A  63       4.112  60.608  31.503  1.00 73.84           C  
ATOM    486  OE1 GLN A  63       4.418  60.830  30.324  1.00 74.80           O  
ATOM    487  NE2 GLN A  63       5.011  60.592  32.483  1.00 74.27           N  
ATOM    488  N   GLU A  64       0.825  56.020  31.732  1.00 68.52           N  
ATOM    489  CA  GLU A  64       0.566  54.722  31.100  1.00 67.47           C  
ATOM    490  C   GLU A  64      -0.937  54.441  30.924  1.00 66.84           C  
ATOM    491  O   GLU A  64      -1.369  53.960  29.869  1.00 66.42           O  
ATOM    492  CB  GLU A  64       1.301  53.590  31.841  1.00 67.29           C  
ATOM    493  CG  GLU A  64       2.844  53.662  31.671  1.00 67.35           C  
ATOM    494  CD  GLU A  64       3.587  52.404  32.125  1.00 68.29           C  
ATOM    495  OE1 GLU A  64       2.990  51.303  32.096  1.00 68.95           O  
ATOM    496  OE2 GLU A  64       4.779  52.515  32.503  1.00 68.59           O  
ATOM    497  N   ALA A  65      -1.723  54.785  31.950  1.00 66.00           N  
ATOM    498  CA  ALA A  65      -3.178  54.706  31.899  1.00 64.90           C  
ATOM    499  C   ALA A  65      -3.712  55.437  30.668  1.00 64.52           C  
ATOM    500  O   ALA A  65      -4.577  54.924  29.940  1.00 64.40           O  
ATOM    501  CB  ALA A  65      -3.767  55.299  33.159  1.00 65.13           C  
ATOM    502  N   ASP A  66      -3.188  56.633  30.419  1.00 63.49           N  
ATOM    503  CA  ASP A  66      -3.578  57.357  29.220  1.00 62.73           C  
ATOM    504  C   ASP A  66      -3.045  56.726  27.930  1.00 61.72           C  
ATOM    505  O   ASP A  66      -3.779  56.615  26.953  1.00 61.77           O  
ATOM    506  CB  ASP A  66      -3.255  58.846  29.334  1.00 62.72           C  
ATOM    507  CG  ASP A  66      -4.402  59.623  29.947  1.00 64.24           C  
ATOM    508  OD1 ASP A  66      -5.478  59.675  29.308  1.00 64.84           O  
ATOM    509  OD2 ASP A  66      -4.247  60.161  31.070  1.00 66.27           O  
ATOM    510  N   TRP A  67      -1.787  56.289  27.944  1.00 60.31           N  
ATOM    511  CA  TRP A  67      -1.185  55.664  26.773  1.00 59.27           C  
ATOM    512  C   TRP A  67      -1.960  54.423  26.299  1.00 58.67           C  
ATOM    513  O   TRP A  67      -2.039  54.152  25.104  1.00 58.15           O  
ATOM    514  CB  TRP A  67       0.284  55.312  27.034  1.00 58.92           C  
ATOM    515  CG  TRP A  67       1.186  56.495  27.171  1.00 58.33           C  
ATOM    516  CD1 TRP A  67       0.952  57.778  26.734  1.00 57.43           C  
ATOM    517  CD2 TRP A  67       2.490  56.505  27.753  1.00 57.67           C  
ATOM    518  NE1 TRP A  67       2.022  58.577  27.032  1.00 56.04           N  
ATOM    519  CE2 TRP A  67       2.985  57.821  27.649  1.00 56.93           C  
ATOM    520  CE3 TRP A  67       3.291  55.526  28.366  1.00 57.62           C  
ATOM    521  CZ2 TRP A  67       4.243  58.187  28.139  1.00 57.71           C  
ATOM    522  CZ3 TRP A  67       4.538  55.888  28.845  1.00 55.77           C  
ATOM    523  CH2 TRP A  67       4.998  57.210  28.739  1.00 56.67           C  
ATOM    524  N   SER A  68      -2.531  53.687  27.248  1.00 57.95           N  
ATOM    525  CA  SER A  68      -3.297  52.486  26.948  1.00 57.35           C  
ATOM    526  C   SER A  68      -4.665  52.851  26.415  1.00 56.89           C  
ATOM    527  O   SER A  68      -5.178  52.187  25.507  1.00 57.26           O  
ATOM    528  CB  SER A  68      -3.441  51.617  28.189  1.00 57.12           C  
ATOM    529  OG  SER A  68      -2.177  51.114  28.562  1.00 56.91           O  
ATOM    530  N   GLN A  69      -5.246  53.904  26.993  1.00 56.22           N  
ATOM    531  CA  GLN A  69      -6.566  54.406  26.616  1.00 55.15           C  
ATOM    532  C   GLN A  69      -6.507  54.896  25.201  1.00 53.85           C  
ATOM    533  O   GLN A  69      -7.380  54.579  24.398  1.00 54.02           O  
ATOM    534  CB  GLN A  69      -6.994  55.564  27.527  1.00 55.72           C  
ATOM    535  CG  GLN A  69      -8.223  56.346  27.035  1.00 56.92           C  
ATOM    536  CD  GLN A  69      -9.513  55.575  27.248  1.00 59.60           C  
ATOM    537  OE1 GLN A  69     -10.275  55.320  26.305  1.00 60.93           O  
ATOM    538  NE2 GLN A  69      -9.760  55.178  28.490  1.00 60.20           N  
ATOM    539  N   GLN A  70      -5.475  55.673  24.903  1.00 52.33           N  
ATOM    540  CA  GLN A  70      -5.302  56.243  23.581  1.00 51.56           C  
ATOM    541  C   GLN A  70      -5.188  55.113  22.570  1.00 50.51           C  
ATOM    542  O   GLN A  70      -5.735  55.217  21.477  1.00 50.36           O  
ATOM    543  CB  GLN A  70      -4.045  57.119  23.497  1.00 51.67           C  
ATOM    544  CG  GLN A  70      -3.997  58.315  24.412  1.00 53.33           C  
ATOM    545  CD  GLN A  70      -2.612  58.950  24.436  1.00 56.56           C  
ATOM    546  OE1 GLN A  70      -1.638  58.347  24.897  1.00 56.91           O  
ATOM    547  NE2 GLN A  70      -2.516  60.177  23.925  1.00 59.80           N  
ATOM    548  N   THR A  71      -4.477  54.044  22.940  1.00 49.53           N  
ATOM    549  CA  THR A  71      -4.317  52.866  22.078  1.00 48.49           C  
ATOM    550  C   THR A  71      -5.670  52.187  21.835  1.00 47.79           C  
ATOM    551  O   THR A  71      -6.005  51.875  20.702  1.00 47.33           O  
ATOM    552  CB  THR A  71      -3.280  51.843  22.636  1.00 48.85           C  
ATOM    553  OG1 THR A  71      -1.961  52.434  22.689  1.00 49.21           O  
ATOM    554  CG2 THR A  71      -3.228  50.589  21.757  1.00 47.65           C  
ATOM    555  N   PHE A  72      -6.453  52.001  22.892  1.00 46.94           N  
ATOM    556  CA  PHE A  72      -7.740  51.344  22.769  1.00 46.78           C  
ATOM    557  C   PHE A  72      -8.702  52.065  21.833  1.00 47.30           C  
ATOM    558  O   PHE A  72      -9.366  51.426  21.021  1.00 48.01           O  
ATOM    559  CB  PHE A  72      -8.379  51.149  24.136  1.00 46.45           C  
ATOM    560  CG  PHE A  72      -9.564  50.238  24.126  1.00 44.92           C  
ATOM    561  CD1 PHE A  72      -9.408  48.886  24.367  1.00 44.16           C  
ATOM    562  CD2 PHE A  72     -10.842  50.737  23.878  1.00 46.15           C  
ATOM    563  CE1 PHE A  72     -10.491  48.031  24.358  1.00 44.75           C  
ATOM    564  CE2 PHE A  72     -11.954  49.887  23.869  1.00 43.64           C  
ATOM    565  CZ  PHE A  72     -11.770  48.532  24.117  1.00 45.30           C  
ATOM    566  N   ASP A  73      -8.771  53.385  21.928  1.00 48.10           N  
ATOM    567  CA  ASP A  73      -9.743  54.150  21.155  1.00 48.99           C  
ATOM    568  C   ASP A  73      -9.358  54.160  19.698  1.00 48.68           C  
ATOM    569  O   ASP A  73     -10.210  54.189  18.819  1.00 49.22           O  
ATOM    570  CB  ASP A  73      -9.839  55.584  21.666  1.00 49.64           C  
ATOM    571  CG  ASP A  73     -10.482  55.676  23.026  1.00 52.28           C  
ATOM    572  OD1 ASP A  73     -11.386  54.871  23.340  1.00 55.64           O  
ATOM    573  OD2 ASP A  73     -10.080  56.573  23.789  1.00 57.20           O  
ATOM    574  N   TYR A  74      -8.057  54.130  19.459  1.00 48.37           N  
ATOM    575  CA  TYR A  74      -7.500  54.122  18.117  1.00 48.05           C  
ATOM    576  C   TYR A  74      -7.884  52.843  17.366  1.00 47.52           C  
ATOM    577  O   TYR A  74      -8.444  52.896  16.262  1.00 47.24           O  
ATOM    578  CB  TYR A  74      -5.982  54.277  18.216  1.00 47.98           C  
ATOM    579  CG  TYR A  74      -5.246  54.093  16.927  1.00 48.99           C  
ATOM    580  CD1 TYR A  74      -5.405  54.996  15.873  1.00 50.25           C  
ATOM    581  CD2 TYR A  74      -4.369  53.026  16.764  1.00 49.97           C  
ATOM    582  CE1 TYR A  74      -4.717  54.821  14.681  1.00 51.96           C  
ATOM    583  CE2 TYR A  74      -3.681  52.843  15.576  1.00 52.22           C  
ATOM    584  CZ  TYR A  74      -3.858  53.743  14.544  1.00 52.90           C  
ATOM    585  OH  TYR A  74      -3.169  53.558  13.376  1.00 55.64           O  
ATOM    586  N   LEU A  75      -7.609  51.699  17.989  1.00 46.90           N  
ATOM    587  CA  LEU A  75      -7.933  50.400  17.400  1.00 46.24           C  
ATOM    588  C   LEU A  75      -9.446  50.207  17.295  1.00 46.42           C  
ATOM    589  O   LEU A  75      -9.932  49.663  16.316  1.00 46.04           O  
ATOM    590  CB  LEU A  75      -7.278  49.276  18.200  1.00 45.42           C  
ATOM    591  CG  LEU A  75      -5.760  49.390  18.315  1.00 43.48           C  
ATOM    592  CD1 LEU A  75      -5.215  48.353  19.267  1.00 39.40           C  
ATOM    593  CD2 LEU A  75      -5.113  49.286  16.920  1.00 41.40           C  
ATOM    594  N   LEU A  76     -10.180  50.691  18.291  1.00 46.76           N  
ATOM    595  CA  LEU A  76     -11.628  50.538  18.312  1.00 47.58           C  
ATOM    596  C   LEU A  76     -12.287  51.250  17.135  1.00 48.64           C  
ATOM    597  O   LEU A  76     -13.177  50.696  16.485  1.00 49.09           O  
ATOM    598  CB  LEU A  76     -12.220  51.043  19.632  1.00 46.96           C  
ATOM    599  CG  LEU A  76     -13.744  50.963  19.718  1.00 46.46           C  
ATOM    600  CD1 LEU A  76     -14.249  49.537  19.512  1.00 45.54           C  
ATOM    601  CD2 LEU A  76     -14.229  51.525  21.054  1.00 45.64           C  
ATOM    602  N   SER A  77     -11.855  52.469  16.852  1.00 49.34           N  
ATOM    603  CA  SER A  77     -12.416  53.193  15.725  1.00 50.17           C  
ATOM    604  C   SER A  77     -11.941  52.622  14.389  1.00 51.00           C  
ATOM    605  O   SER A  77     -12.378  53.076  13.336  1.00 51.90           O  
ATOM    606  CB  SER A  77     -12.093  54.689  15.821  1.00 50.15           C  
ATOM    607  OG  SER A  77     -10.699  54.909  15.799  1.00 48.83           O  
ATOM    608  N   HIS A  78     -11.043  51.644  14.419  1.00 51.30           N  
ATOM    609  CA  HIS A  78     -10.617  51.006  13.177  1.00 52.19           C  
ATOM    610  C   HIS A  78     -11.146  49.566  13.027  1.00 52.45           C  
ATOM    611  O   HIS A  78     -10.868  48.890  12.037  1.00 51.73           O  
ATOM    612  CB  HIS A  78      -9.086  51.045  13.038  1.00 52.41           C  
ATOM    613  CG  HIS A  78      -8.549  52.360  12.553  1.00 53.84           C  
ATOM    614  ND1 HIS A  78      -7.410  52.937  13.074  1.00 55.16           N  
ATOM    615  CD2 HIS A  78      -8.992  53.206  11.592  1.00 54.60           C  
ATOM    616  CE1 HIS A  78      -7.176  54.081  12.455  1.00 54.97           C  
ATOM    617  NE2 HIS A  78      -8.125  54.269  11.555  1.00 54.23           N  
ATOM    618  N   VAL A  79     -11.917  49.108  14.005  1.00 53.38           N  
ATOM    619  CA  VAL A  79     -12.356  47.717  14.017  1.00 54.77           C  
ATOM    620  C   VAL A  79     -13.240  47.340  12.839  1.00 55.58           C  
ATOM    621  O   VAL A  79     -13.222  46.193  12.415  1.00 56.29           O  
ATOM    622  CB  VAL A  79     -13.016  47.287  15.365  1.00 54.58           C  
ATOM    623  CG1 VAL A  79     -14.416  47.888  15.530  1.00 54.60           C  
ATOM    624  CG2 VAL A  79     -13.091  45.782  15.434  1.00 54.56           C  
ATOM    625  N   HIS A  80     -13.987  48.296  12.307  1.00 56.78           N  
ATOM    626  CA  HIS A  80     -14.940  48.015  11.238  1.00 58.28           C  
ATOM    627  C   HIS A  80     -14.508  48.553   9.890  1.00 59.01           C  
ATOM    628  O   HIS A  80     -15.308  48.660   8.972  1.00 59.99           O  
ATOM    629  CB  HIS A  80     -16.346  48.508  11.614  1.00 58.30           C  
ATOM    630  CG  HIS A  80     -17.072  47.580  12.542  1.00 60.04           C  
ATOM    631  ND1 HIS A  80     -18.446  47.470  12.566  1.00 61.61           N  
ATOM    632  CD2 HIS A  80     -16.609  46.688  13.452  1.00 60.89           C  
ATOM    633  CE1 HIS A  80     -18.798  46.568  13.467  1.00 61.87           C  
ATOM    634  NE2 HIS A  80     -17.702  46.081  14.021  1.00 61.13           N  
ATOM    635  N   SER A  81     -13.235  48.877   9.758  1.00 59.89           N  
ATOM    636  CA  SER A  81     -12.702  49.289   8.465  1.00 60.69           C  
ATOM    637  C   SER A  81     -12.359  48.078   7.571  1.00 60.95           C  
ATOM    638  O   SER A  81     -12.383  46.937   8.029  1.00 60.47           O  
ATOM    639  CB  SER A  81     -11.492  50.195   8.669  1.00 60.81           C  
ATOM    640  OG  SER A  81     -10.424  49.461   9.227  1.00 62.45           O  
ATOM    641  N   PRO A  82     -12.072  48.320   6.274  1.00 61.69           N  
ATOM    642  CA  PRO A  82     -11.652  47.204   5.413  1.00 61.65           C  
ATOM    643  C   PRO A  82     -10.228  46.732   5.718  1.00 61.44           C  
ATOM    644  O   PRO A  82      -9.819  45.676   5.246  1.00 61.75           O  
ATOM    645  CB  PRO A  82     -11.704  47.816   4.011  1.00 62.09           C  
ATOM    646  CG  PRO A  82     -11.427  49.305   4.240  1.00 61.87           C  
ATOM    647  CD  PRO A  82     -12.133  49.606   5.535  1.00 61.72           C  
ATOM    648  N   ASN A  83      -9.482  47.524   6.491  1.00 60.97           N  
ATOM    649  CA  ASN A  83      -8.112  47.177   6.913  1.00 60.40           C  
ATOM    650  C   ASN A  83      -7.996  46.234   8.129  1.00 58.67           C  
ATOM    651  O   ASN A  83      -6.915  45.712   8.404  1.00 58.57           O  
ATOM    652  CB  ASN A  83      -7.309  48.456   7.195  1.00 61.30           C  
ATOM    653  CG  ASN A  83      -7.237  49.381   5.994  1.00 64.29           C  
ATOM    654  OD1 ASN A  83      -8.270  49.720   5.392  1.00 68.20           O  
ATOM    655  ND2 ASN A  83      -6.017  49.804   5.642  1.00 65.56           N  
ATOM    656  N   ALA A  84      -9.101  46.020   8.841  1.00 56.59           N  
ATOM    657  CA  ALA A  84      -9.110  45.246  10.089  1.00 54.86           C  
ATOM    658  C   ALA A  84      -8.506  43.838   9.983  1.00 53.52           C  
ATOM    659  O   ALA A  84      -7.718  43.436  10.833  1.00 52.86           O  
ATOM    660  CB  ALA A  84     -10.517  45.192  10.680  1.00 54.58           C  
ATOM    661  N   GLU A  85      -8.871  43.114   8.930  1.00 52.14           N  
ATOM    662  CA  GLU A  85      -8.361  41.769   8.690  1.00 50.70           C  
ATOM    663  C   GLU A  85      -6.858  41.828   8.502  1.00 49.26           C  
ATOM    664  O   GLU A  85      -6.140  40.978   9.019  1.00 48.94           O  
ATOM    665  CB  GLU A  85      -9.031  41.133   7.462  1.00 50.78           C  
ATOM    666  CG  GLU A  85      -8.462  39.744   7.129  1.00 53.85           C  
ATOM    667  CD  GLU A  85      -9.143  39.022   5.958  1.00 56.33           C  
ATOM    668  OE1 GLU A  85      -9.977  39.619   5.239  1.00 57.34           O  
ATOM    669  OE2 GLU A  85      -8.818  37.831   5.753  1.00 58.07           O  
ATOM    670  N   ASN A  86      -6.404  42.839   7.762  1.00 47.78           N  
ATOM    671  CA  ASN A  86      -4.987  43.057   7.479  1.00 46.47           C  
ATOM    672  C   ASN A  86      -4.127  43.310   8.725  1.00 45.16           C  
ATOM    673  O   ASN A  86      -3.023  42.778   8.854  1.00 44.10           O  
ATOM    674  CB  ASN A  86      -4.824  44.234   6.507  1.00 46.83           C  
ATOM    675  CG  ASN A  86      -5.027  43.836   5.065  1.00 47.16           C  
ATOM    676  OD1 ASN A  86      -4.480  42.836   4.597  1.00 49.80           O  
ATOM    677  ND2 ASN A  86      -5.790  44.631   4.339  1.00 47.91           N  
ATOM    678  N   LEU A  87      -4.644  44.143   9.625  1.00 44.30           N  
ATOM    679  CA  LEU A  87      -3.986  44.437  10.888  1.00 43.59           C  
ATOM    680  C   LEU A  87      -4.097  43.297  11.895  1.00 42.96           C  
ATOM    681  O   LEU A  87      -3.294  43.239  12.814  1.00 43.01           O  
ATOM    682  CB  LEU A  87      -4.560  45.705  11.519  1.00 44.11           C  
ATOM    683  CG  LEU A  87      -4.312  47.070  10.868  1.00 45.21           C  
ATOM    684  CD1 LEU A  87      -5.124  47.160   9.610  1.00 46.75           C  
ATOM    685  CD2 LEU A  87      -4.703  48.184  11.807  1.00 46.24           C  
ATOM    686  N   GLY A  88      -5.083  42.406  11.726  1.00 41.95           N  
ATOM    687  CA  GLY A  88      -5.381  41.357  12.708  1.00 40.65           C  
ATOM    688  C   GLY A  88      -6.124  41.899  13.926  1.00 40.37           C  
ATOM    689  O   GLY A  88      -5.829  41.517  15.074  1.00 39.92           O  
ATOM    690  N   LEU A  89      -7.075  42.798  13.673  1.00 39.37           N  
ATOM    691  CA  LEU A  89      -7.812  43.504  14.715  1.00 39.49           C  
ATOM    692  C   LEU A  89      -9.214  42.940  14.741  1.00 39.04           C  
ATOM    693  O   LEU A  89      -9.786  42.681  13.696  1.00 40.16           O  
ATOM    694  CB  LEU A  89      -7.890  44.993  14.373  1.00 39.51           C  
ATOM    695  CG  LEU A  89      -7.908  46.142  15.394  1.00 41.32           C  
ATOM    696  CD1 LEU A  89      -8.141  47.466  14.654  1.00 41.94           C  
ATOM    697  CD2 LEU A  89      -8.933  45.985  16.504  1.00 41.17           C  
ATOM    698  N   PHE A  90      -9.761  42.708  15.922  1.00 38.86           N  
ATOM    699  CA  PHE A  90     -11.146  42.233  16.057  1.00 38.24           C  
ATOM    700  C   PHE A  90     -11.644  42.324  17.507  1.00 38.13           C  
ATOM    701  O   PHE A  90     -10.843  42.417  18.439  1.00 37.13           O  
ATOM    702  CB  PHE A  90     -11.340  40.824  15.452  1.00 38.15           C  
ATOM    703  CG  PHE A  90     -10.549  39.727  16.133  1.00 37.71           C  
ATOM    704  CD1 PHE A  90      -9.294  39.375  15.670  1.00 35.66           C  
ATOM    705  CD2 PHE A  90     -11.087  39.026  17.216  1.00 37.95           C  
ATOM    706  CE1 PHE A  90      -8.580  38.381  16.284  1.00 37.09           C  
ATOM    707  CE2 PHE A  90     -10.356  38.029  17.854  1.00 37.55           C  
ATOM    708  CZ  PHE A  90      -9.106  37.698  17.385  1.00 36.21           C  
ATOM    709  N   LEU A  91     -12.962  42.344  17.688  1.00 38.52           N  
ATOM    710  CA  LEU A  91     -13.545  42.442  19.028  1.00 39.32           C  
ATOM    711  C   LEU A  91     -13.666  41.060  19.642  1.00 39.45           C  
ATOM    712  O   LEU A  91     -14.084  40.120  18.956  1.00 40.04           O  
ATOM    713  CB  LEU A  91     -14.931  43.092  19.002  1.00 39.06           C  
ATOM    714  CG  LEU A  91     -15.139  44.604  19.109  1.00 40.60           C  
ATOM    715  CD1 LEU A  91     -16.649  44.885  19.239  1.00 38.15           C  
ATOM    716  CD2 LEU A  91     -14.408  45.201  20.296  1.00 40.51           C  
ATOM    717  N   ILE A  92     -13.325  40.945  20.924  1.00 39.40           N  
ATOM    718  CA  ILE A  92     -13.514  39.700  21.661  1.00 39.51           C  
ATOM    719  C   ILE A  92     -13.934  39.969  23.096  1.00 39.86           C  
ATOM    720  O   ILE A  92     -13.390  40.854  23.723  1.00 41.04           O  
ATOM    721  CB  ILE A  92     -12.234  38.840  21.635  1.00 39.59           C  
ATOM    722  CG1 ILE A  92     -12.523  37.418  22.116  1.00 38.05           C  
ATOM    723  CG2 ILE A  92     -11.097  39.529  22.417  1.00 39.31           C  
ATOM    724  CD1 ILE A  92     -11.419  36.479  21.834  1.00 37.10           C  
ATOM    725  N   SER A  93     -14.905  39.218  23.602  1.00 39.92           N  
ATOM    726  CA  SER A  93     -15.309  39.275  25.011  1.00 39.97           C  
ATOM    727  C   SER A  93     -14.697  38.138  25.810  1.00 41.06           C  
ATOM    728  O   SER A  93     -14.210  37.158  25.237  1.00 40.69           O  
ATOM    729  CB  SER A  93     -16.818  39.150  25.147  1.00 39.08           C  
ATOM    730  OG  SER A  93     -17.495  40.139  24.398  1.00 38.91           O  
ATOM    731  N   GLY A  94     -14.738  38.254  27.141  1.00 42.35           N  
ATOM    732  CA  GLY A  94     -14.247  37.178  27.998  1.00 43.84           C  
ATOM    733  C   GLY A  94     -14.227  37.425  29.492  1.00 44.79           C  
ATOM    734  O   GLY A  94     -14.697  38.457  29.984  1.00 44.73           O  
ATOM    735  N   TYR A  95     -13.654  36.460  30.208  1.00 45.95           N  
ATOM    736  CA  TYR A  95     -13.744  36.371  31.675  1.00 46.95           C  
ATOM    737  C   TYR A  95     -12.378  36.611  32.315  1.00 47.56           C  
ATOM    738  O   TYR A  95     -11.358  36.133  31.797  1.00 47.94           O  
ATOM    739  CB  TYR A  95     -14.274  34.986  32.103  1.00 46.64           C  
ATOM    740  CG  TYR A  95     -15.540  34.554  31.382  1.00 46.63           C  
ATOM    741  CD1 TYR A  95     -15.485  33.914  30.128  1.00 45.33           C  
ATOM    742  CD2 TYR A  95     -16.786  34.782  31.944  1.00 45.51           C  
ATOM    743  CE1 TYR A  95     -16.645  33.524  29.468  1.00 44.01           C  
ATOM    744  CE2 TYR A  95     -17.952  34.395  31.285  1.00 45.55           C  
ATOM    745  CZ  TYR A  95     -17.877  33.780  30.048  1.00 45.40           C  
ATOM    746  OH  TYR A  95     -19.051  33.428  29.402  1.00 45.96           O  
ATOM    747  N   ASN A  96     -12.368  37.374  33.415  1.00 48.31           N  
ATOM    748  CA  ASN A  96     -11.242  37.381  34.359  1.00 48.74           C  
ATOM    749  C   ASN A  96     -11.674  36.714  35.657  1.00 49.72           C  
ATOM    750  O   ASN A  96     -12.540  37.228  36.357  1.00 49.74           O  
ATOM    751  CB  ASN A  96     -10.768  38.803  34.618  1.00 48.04           C  
ATOM    752  CG  ASN A  96      -9.939  39.339  33.484  1.00 47.76           C  
ATOM    753  OD1 ASN A  96      -8.727  39.150  33.462  1.00 45.85           O  
ATOM    754  ND2 ASN A  96     -10.585  40.004  32.522  1.00 46.04           N  
ATOM    755  N   LEU A  97     -11.088  35.560  35.968  1.00 51.03           N  
ATOM    756  CA  LEU A  97     -11.478  34.799  37.163  1.00 52.36           C  
ATOM    757  C   LEU A  97     -10.463  34.910  38.309  1.00 53.44           C  
ATOM    758  O   LEU A  97      -9.253  34.820  38.085  1.00 53.40           O  
ATOM    759  CB  LEU A  97     -11.719  33.327  36.808  1.00 51.92           C  
ATOM    760  CG  LEU A  97     -12.622  33.054  35.607  1.00 52.27           C  
ATOM    761  CD1 LEU A  97     -12.404  31.634  35.117  1.00 52.33           C  
ATOM    762  CD2 LEU A  97     -14.087  33.294  35.949  1.00 51.41           C  
ATOM    763  N   PHE A  98     -10.989  35.091  39.525  1.00 54.90           N  
ATOM    764  CA  PHE A  98     -10.206  35.246  40.758  1.00 56.32           C  
ATOM    765  C   PHE A  98     -10.775  34.353  41.839  1.00 57.84           C  
ATOM    766  O   PHE A  98     -11.926  33.908  41.745  1.00 58.32           O  
ATOM    767  CB  PHE A  98     -10.295  36.677  41.288  1.00 55.72           C  
ATOM    768  CG  PHE A  98      -9.981  37.715  40.278  1.00 54.98           C  
ATOM    769  CD1 PHE A  98      -8.687  38.192  40.145  1.00 53.85           C  
ATOM    770  CD2 PHE A  98     -10.982  38.219  39.444  1.00 53.71           C  
ATOM    771  CE1 PHE A  98      -8.395  39.152  39.206  1.00 52.80           C  
ATOM    772  CE2 PHE A  98     -10.692  39.172  38.499  1.00 51.88           C  
ATOM    773  CZ  PHE A  98      -9.401  39.640  38.382  1.00 52.18           C  
ATOM    774  N   HIS A  99      -9.980  34.111  42.878  1.00 59.36           N  
ATOM    775  CA  HIS A  99     -10.496  33.440  44.056  1.00 61.19           C  
ATOM    776  C   HIS A  99     -11.249  34.442  44.941  1.00 62.19           C  
ATOM    777  O   HIS A  99     -12.473  34.395  45.036  1.00 62.44           O  
ATOM    778  CB  HIS A  99      -9.377  32.711  44.788  1.00 60.98           C  
ATOM    779  CG  HIS A  99      -8.589  31.795  43.900  1.00 62.20           C  
ATOM    780  ND1 HIS A  99      -9.049  30.552  43.513  1.00 62.25           N  
ATOM    781  CD2 HIS A  99      -7.381  31.952  43.302  1.00 62.85           C  
ATOM    782  CE1 HIS A  99      -8.152  29.977  42.729  1.00 62.78           C  
ATOM    783  NE2 HIS A  99      -7.130  30.806  42.585  1.00 62.47           N  
ATOM    784  N   GLU A 100     -10.534  35.380  45.541  1.00 63.67           N  
ATOM    785  CA  GLU A 100     -11.182  36.352  46.417  1.00 65.07           C  
ATOM    786  C   GLU A 100     -11.644  37.593  45.658  1.00 65.65           C  
ATOM    787  O   GLU A 100     -11.373  37.744  44.471  1.00 65.72           O  
ATOM    788  CB  GLU A 100     -10.253  36.733  47.582  1.00 65.22           C  
ATOM    789  CG  GLU A 100      -9.873  35.570  48.509  1.00 66.75           C  
ATOM    790  CD  GLU A 100     -11.082  34.835  49.123  1.00 69.82           C  
ATOM    791  OE1 GLU A 100     -12.165  35.443  49.334  1.00 69.72           O  
ATOM    792  OE2 GLU A 100     -10.938  33.626  49.403  1.00 71.51           O  
ATOM    793  N   ALA A 101     -12.353  38.482  46.348  1.00 66.61           N  
ATOM    794  CA  ALA A 101     -12.667  39.796  45.792  1.00 67.16           C  
ATOM    795  C   ALA A 101     -11.388  40.609  45.550  1.00 67.56           C  
ATOM    796  O   ALA A 101     -10.385  40.474  46.268  1.00 67.67           O  
ATOM    797  CB  ALA A 101     -13.644  40.562  46.699  1.00 67.49           C  
ATOM    798  N   ILE A 102     -11.443  41.445  44.519  1.00 67.76           N  
ATOM    799  CA  ILE A 102     -10.344  42.307  44.109  1.00 67.94           C  
ATOM    800  C   ILE A 102     -11.035  43.596  43.662  1.00 67.97           C  
ATOM    801  O   ILE A 102     -12.193  43.551  43.238  1.00 67.88           O  
ATOM    802  CB  ILE A 102      -9.500  41.642  42.970  1.00 68.07           C  
ATOM    803  CG1 ILE A 102      -8.515  42.623  42.319  1.00 68.32           C  
ATOM    804  CG2 ILE A 102     -10.403  41.034  41.898  1.00 67.94           C  
ATOM    805  CD1 ILE A 102      -7.189  42.760  43.053  1.00 70.11           C  
ATOM    806  N   PRO A 103     -10.371  44.758  43.830  1.00 68.02           N  
ATOM    807  CA  PRO A 103     -10.960  45.995  43.305  1.00 67.85           C  
ATOM    808  C   PRO A 103     -10.945  46.101  41.775  1.00 67.64           C  
ATOM    809  O   PRO A 103     -10.063  45.549  41.110  1.00 67.25           O  
ATOM    810  CB  PRO A 103     -10.083  47.090  43.919  1.00 67.78           C  
ATOM    811  CG  PRO A 103      -8.772  46.423  44.166  1.00 68.14           C  
ATOM    812  CD  PRO A 103      -9.112  45.017  44.556  1.00 68.03           C  
ATOM    813  N   ASP A 104     -11.924  46.821  41.239  1.00 67.35           N  
ATOM    814  CA  ASP A 104     -11.965  47.155  39.824  1.00 67.03           C  
ATOM    815  C   ASP A 104     -10.659  47.787  39.344  1.00 66.67           C  
ATOM    816  O   ASP A 104      -9.991  48.476  40.109  1.00 66.52           O  
ATOM    817  CB  ASP A 104     -13.149  48.083  39.555  1.00 67.01           C  
ATOM    818  CG  ASP A 104     -14.469  47.422  39.853  1.00 67.32           C  
ATOM    819  OD1 ASP A 104     -14.522  46.654  40.835  1.00 68.46           O  
ATOM    820  OD2 ASP A 104     -15.442  47.657  39.110  1.00 67.17           O  
ATOM    821  N   PRO A 105     -10.290  47.553  38.070  1.00 66.38           N  
ATOM    822  CA  PRO A 105      -9.052  48.130  37.569  1.00 65.85           C  
ATOM    823  C   PRO A 105      -9.274  49.557  37.100  1.00 65.48           C  
ATOM    824  O   PRO A 105     -10.414  49.977  36.914  1.00 65.66           O  
ATOM    825  CB  PRO A 105      -8.720  47.239  36.372  1.00 65.94           C  
ATOM    826  CG  PRO A 105     -10.046  46.832  35.837  1.00 65.79           C  
ATOM    827  CD  PRO A 105     -10.989  46.767  37.031  1.00 66.41           C  
ATOM    828  N   SER A 106      -8.182  50.279  36.895  1.00 65.13           N  
ATOM    829  CA  SER A 106      -8.225  51.645  36.395  1.00 64.97           C  
ATOM    830  C   SER A 106      -8.838  51.727  34.985  1.00 64.40           C  
ATOM    831  O   SER A 106      -9.566  52.680  34.661  1.00 64.43           O  
ATOM    832  CB  SER A 106      -6.805  52.206  36.361  1.00 65.32           C  
ATOM    833  OG  SER A 106      -5.995  51.438  35.468  1.00 66.91           O  
ATOM    834  N   TRP A 107      -8.533  50.722  34.161  1.00 63.37           N  
ATOM    835  CA  TRP A 107      -9.024  50.636  32.783  1.00 62.02           C  
ATOM    836  C   TRP A 107     -10.461  50.108  32.678  1.00 61.58           C  
ATOM    837  O   TRP A 107     -10.879  49.639  31.629  1.00 61.93           O  
ATOM    838  CB  TRP A 107      -8.069  49.782  31.929  1.00 61.57           C  
ATOM    839  CG  TRP A 107      -7.604  48.484  32.577  1.00 59.92           C  
ATOM    840  CD1 TRP A 107      -6.436  48.277  33.260  1.00 59.16           C  
ATOM    841  CD2 TRP A 107      -8.291  47.223  32.575  1.00 57.64           C  
ATOM    842  NE1 TRP A 107      -6.355  46.970  33.686  1.00 58.07           N  
ATOM    843  CE2 TRP A 107      -7.480  46.303  33.275  1.00 57.06           C  
ATOM    844  CE3 TRP A 107      -9.516  46.782  32.048  1.00 56.17           C  
ATOM    845  CZ2 TRP A 107      -7.860  44.977  33.480  1.00 55.47           C  
ATOM    846  CZ3 TRP A 107      -9.888  45.463  32.242  1.00 54.57           C  
ATOM    847  CH2 TRP A 107      -9.062  44.578  32.957  1.00 54.85           C  
ATOM    848  N   LYS A 108     -11.229  50.198  33.754  1.00 60.92           N  
ATOM    849  CA  LYS A 108     -12.580  49.653  33.733  1.00 60.66           C  
ATOM    850  C   LYS A 108     -13.569  50.439  32.850  1.00 60.00           C  
ATOM    851  O   LYS A 108     -14.634  49.919  32.519  1.00 59.86           O  
ATOM    852  CB  LYS A 108     -13.117  49.479  35.161  1.00 61.04           C  
ATOM    853  CG  LYS A 108     -13.914  50.651  35.716  1.00 62.01           C  
ATOM    854  CD  LYS A 108     -14.508  50.294  37.068  1.00 64.90           C  
ATOM    855  CE  LYS A 108     -15.561  51.302  37.505  1.00 67.35           C  
ATOM    856  NZ  LYS A 108     -14.977  52.638  37.834  1.00 68.54           N  
ATOM    857  N   ASP A 109     -13.227  51.675  32.480  1.00 59.07           N  
ATOM    858  CA  ASP A 109     -14.107  52.481  31.634  1.00 58.65           C  
ATOM    859  C   ASP A 109     -13.593  52.577  30.224  1.00 57.85           C  
ATOM    860  O   ASP A 109     -14.267  53.141  29.366  1.00 57.88           O  
ATOM    861  CB  ASP A 109     -14.292  53.899  32.185  1.00 59.17           C  
ATOM    862  CG  ASP A 109     -14.999  53.916  33.525  1.00 60.59           C  
ATOM    863  OD1 ASP A 109     -16.158  53.419  33.620  1.00 60.72           O  
ATOM    864  OD2 ASP A 109     -14.372  54.418  34.491  1.00 62.59           O  
ATOM    865  N   THR A 110     -12.391  52.049  30.001  1.00 56.84           N  
ATOM    866  CA  THR A 110     -11.784  52.004  28.677  1.00 56.03           C  
ATOM    867  C   THR A 110     -12.488  50.946  27.824  1.00 55.51           C  
ATOM    868  O   THR A 110     -12.982  51.236  26.711  1.00 55.19           O  
ATOM    869  CB  THR A 110     -10.303  51.630  28.751  1.00 56.19           C  
ATOM    870  OG1 THR A 110      -9.646  52.423  29.745  1.00 55.88           O  
ATOM    871  CG2 THR A 110      -9.641  51.849  27.393  1.00 56.89           C  
ATOM    872  N   VAL A 111     -12.535  49.723  28.363  1.00 54.10           N  
ATOM    873  CA  VAL A 111     -13.165  48.596  27.677  1.00 52.73           C  
ATOM    874  C   VAL A 111     -14.675  48.807  27.506  1.00 52.35           C  
ATOM    875  O   VAL A 111     -15.215  49.839  27.919  1.00 52.73           O  
ATOM    876  CB  VAL A 111     -12.882  47.234  28.380  1.00 52.51           C  
ATOM    877  CG1 VAL A 111     -11.394  46.961  28.448  1.00 50.43           C  
ATOM    878  CG2 VAL A 111     -13.535  47.178  29.759  1.00 52.07           C  
ATOM    879  N   LEU A 112     -15.340  47.824  26.891  1.00 51.27           N  
ATOM    880  CA  LEU A 112     -16.787  47.878  26.646  1.00 49.88           C  
ATOM    881  C   LEU A 112     -17.565  46.992  27.609  1.00 48.57           C  
ATOM    882  O   LEU A 112     -17.225  45.831  27.815  1.00 47.37           O  
ATOM    883  CB  LEU A 112     -17.104  47.463  25.198  1.00 49.95           C  
ATOM    884  CG  LEU A 112     -16.574  48.265  24.009  1.00 50.54           C  
ATOM    885  CD1 LEU A 112     -16.539  49.776  24.288  1.00 50.00           C  
ATOM    886  CD2 LEU A 112     -15.207  47.770  23.630  1.00 51.90           C  
ATOM    887  N   GLY A 113     -18.613  47.566  28.186  1.00 48.35           N  
ATOM    888  CA  GLY A 113     -19.545  46.855  29.061  1.00 48.26           C  
ATOM    889  C   GLY A 113     -18.946  46.031  30.177  1.00 48.91           C  
ATOM    890  O   GLY A 113     -19.426  44.925  30.458  1.00 47.75           O  
ATOM    891  N   PHE A 114     -17.889  46.561  30.799  1.00 50.33           N  
ATOM    892  CA  PHE A 114     -17.258  45.931  31.948  1.00 51.78           C  
ATOM    893  C   PHE A 114     -18.295  45.767  33.057  1.00 53.39           C  
ATOM    894  O   PHE A 114     -18.993  46.729  33.401  1.00 53.98           O  
ATOM    895  CB  PHE A 114     -16.094  46.783  32.466  1.00 51.78           C  
ATOM    896  CG  PHE A 114     -15.519  46.279  33.760  1.00 51.59           C  
ATOM    897  CD1 PHE A 114     -16.140  46.558  34.973  1.00 52.83           C  
ATOM    898  CD2 PHE A 114     -14.381  45.497  33.767  1.00 51.33           C  
ATOM    899  CE1 PHE A 114     -15.625  46.058  36.166  1.00 52.83           C  
ATOM    900  CE2 PHE A 114     -13.853  45.001  34.953  1.00 51.33           C  
ATOM    901  CZ  PHE A 114     -14.472  45.284  36.152  1.00 52.66           C  
ATOM    902  N   ARG A 115     -18.385  44.557  33.602  1.00 54.67           N  
ATOM    903  CA  ARG A 115     -19.256  44.247  34.725  1.00 56.68           C  
ATOM    904  C   ARG A 115     -18.769  43.021  35.505  1.00 58.05           C  
ATOM    905  O   ARG A 115     -17.758  42.392  35.131  1.00 58.24           O  
ATOM    906  CB  ARG A 115     -20.731  44.057  34.303  1.00 57.17           C  
ATOM    907  CG  ARG A 115     -21.051  43.595  32.865  1.00 58.61           C  
ATOM    908  CD  ARG A 115     -20.313  42.332  32.429  1.00 61.40           C  
ATOM    909  NE  ARG A 115     -20.939  41.083  32.865  1.00 63.14           N  
ATOM    910  CZ  ARG A 115     -21.751  40.348  32.111  1.00 62.64           C  
ATOM    911  NH1 ARG A 115     -22.065  40.750  30.884  1.00 64.17           N  
ATOM    912  NH2 ARG A 115     -22.250  39.217  32.588  1.00 60.88           N  
ATOM    913  N   LYS A 116     -19.482  42.696  36.587  1.00 58.85           N  
ATOM    914  CA  LYS A 116     -19.115  41.576  37.457  1.00 60.37           C  
ATOM    915  C   LYS A 116     -19.820  40.288  37.046  1.00 60.86           C  
ATOM    916  O   LYS A 116     -20.992  40.306  36.636  1.00 61.29           O  
ATOM    917  CB  LYS A 116     -19.450  41.883  38.924  1.00 60.64           C  
ATOM    918  CG  LYS A 116     -18.946  43.238  39.445  1.00 62.24           C  
ATOM    919  CD  LYS A 116     -17.425  43.241  39.655  1.00 64.11           C  
ATOM    920  CE  LYS A 116     -16.915  44.616  40.087  1.00 66.00           C  
ATOM    921  NZ  LYS A 116     -17.611  45.137  41.316  1.00 67.13           N  
ATOM    922  N   LEU A 117     -19.102  39.172  37.176  1.00 61.18           N  
ATOM    923  CA  LEU A 117     -19.660  37.851  36.909  1.00 61.16           C  
ATOM    924  C   LEU A 117     -20.809  37.520  37.864  1.00 61.89           C  
ATOM    925  O   LEU A 117     -20.671  37.624  39.088  1.00 61.95           O  
ATOM    926  CB  LEU A 117     -18.565  36.784  36.963  1.00 60.75           C  
ATOM    927  CG  LEU A 117     -17.542  36.857  35.821  1.00 60.10           C  
ATOM    928  CD1 LEU A 117     -16.414  35.908  36.042  1.00 58.62           C  
ATOM    929  CD2 LEU A 117     -18.188  36.587  34.476  1.00 58.86           C  
ATOM    930  N   THR A 118     -21.945  37.152  37.276  1.00 62.31           N  
ATOM    931  CA  THR A 118     -23.142  36.758  38.000  1.00 62.83           C  
ATOM    932  C   THR A 118     -22.990  35.337  38.523  1.00 63.62           C  
ATOM    933  O   THR A 118     -22.215  34.559  37.961  1.00 64.22           O  
ATOM    934  CB  THR A 118     -24.352  36.762  37.070  1.00 62.84           C  
ATOM    935  OG1 THR A 118     -24.158  35.779  36.033  1.00 62.91           O  
ATOM    936  CG2 THR A 118     -24.584  38.155  36.470  1.00 62.11           C  
ATOM    937  N   PRO A 119     -23.734  34.977  39.593  1.00 64.24           N  
ATOM    938  CA  PRO A 119     -23.655  33.600  40.115  1.00 64.73           C  
ATOM    939  C   PRO A 119     -23.694  32.512  39.040  1.00 65.23           C  
ATOM    940  O   PRO A 119     -22.870  31.593  39.070  1.00 65.23           O  
ATOM    941  CB  PRO A 119     -24.872  33.483  41.052  1.00 64.36           C  
ATOM    942  CG  PRO A 119     -25.607  34.812  40.948  1.00 64.62           C  
ATOM    943  CD  PRO A 119     -24.639  35.816  40.402  1.00 64.02           C  
ATOM    944  N   ARG A 120     -24.633  32.629  38.099  1.00 66.07           N  
ATOM    945  CA  ARG A 120     -24.820  31.618  37.048  1.00 66.86           C  
ATOM    946  C   ARG A 120     -23.544  31.413  36.229  1.00 66.62           C  
ATOM    947  O   ARG A 120     -23.219  30.289  35.836  1.00 66.59           O  
ATOM    948  CB  ARG A 120     -25.986  31.994  36.121  1.00 67.51           C  
ATOM    949  CG  ARG A 120     -27.376  31.509  36.557  1.00 70.16           C  
ATOM    950  CD  ARG A 120     -27.715  30.149  35.946  1.00 75.89           C  
ATOM    951  NE  ARG A 120     -26.924  29.065  36.547  1.00 81.32           N  
ATOM    952  CZ  ARG A 120     -26.968  27.776  36.189  1.00 83.64           C  
ATOM    953  NH1 ARG A 120     -26.191  26.896  36.828  1.00 84.52           N  
ATOM    954  NH2 ARG A 120     -27.774  27.362  35.205  1.00 83.73           N  
ATOM    955  N   GLU A 121     -22.827  32.507  35.990  1.00 66.28           N  
ATOM    956  CA  GLU A 121     -21.617  32.483  35.188  1.00 65.92           C  
ATOM    957  C   GLU A 121     -20.482  31.826  35.945  1.00 65.48           C  
ATOM    958  O   GLU A 121     -19.738  31.012  35.388  1.00 64.95           O  
ATOM    959  CB  GLU A 121     -21.224  33.902  34.785  1.00 65.94           C  
ATOM    960  CG  GLU A 121     -21.966  34.420  33.585  1.00 66.48           C  
ATOM    961  CD  GLU A 121     -21.805  35.913  33.403  1.00 67.82           C  
ATOM    962  OE1 GLU A 121     -21.792  36.375  32.244  1.00 67.85           O  
ATOM    963  OE2 GLU A 121     -21.688  36.634  34.416  1.00 69.33           O  
ATOM    964  N   LEU A 122     -20.366  32.189  37.222  1.00 65.15           N  
ATOM    965  CA  LEU A 122     -19.325  31.659  38.101  1.00 64.62           C  
ATOM    966  C   LEU A 122     -19.414  30.153  38.329  1.00 63.99           C  
ATOM    967  O   LEU A 122     -18.405  29.531  38.631  1.00 63.96           O  
ATOM    968  CB  LEU A 122     -19.319  32.405  39.438  1.00 64.71           C  
ATOM    969  CG  LEU A 122     -18.720  33.818  39.462  1.00 65.15           C  
ATOM    970  CD1 LEU A 122     -19.075  34.508  40.768  1.00 66.18           C  
ATOM    971  CD2 LEU A 122     -17.205  33.822  39.257  1.00 66.13           C  
ATOM    972  N   ASP A 123     -20.613  29.582  38.178  1.00 63.58           N  
ATOM    973  CA  ASP A 123     -20.830  28.124  38.275  1.00 63.44           C  
ATOM    974  C   ASP A 123     -20.190  27.328  37.134  1.00 63.01           C  
ATOM    975  O   ASP A 123     -19.872  26.149  37.309  1.00 62.84           O  
ATOM    976  CB  ASP A 123     -22.320  27.782  38.363  1.00 63.53           C  
ATOM    977  CG  ASP A 123     -22.974  28.322  39.624  1.00 65.11           C  
ATOM    978  OD1 ASP A 123     -22.378  28.222  40.727  1.00 66.53           O  
ATOM    979  OD2 ASP A 123     -24.099  28.847  39.511  1.00 66.47           O  
ATOM    980  N   MET A 124     -20.009  27.973  35.976  1.00 62.58           N  
ATOM    981  CA  MET A 124     -19.282  27.387  34.846  1.00 61.83           C  
ATOM    982  C   MET A 124     -17.828  27.172  35.210  1.00 61.32           C  
ATOM    983  O   MET A 124     -17.100  26.439  34.529  1.00 61.02           O  
ATOM    984  CB  MET A 124     -19.338  28.303  33.637  1.00 61.92           C  
ATOM    985  CG  MET A 124     -20.722  28.506  33.046  1.00 63.11           C  
ATOM    986  SD  MET A 124     -20.642  29.399  31.473  1.00 63.58           S  
ATOM    987  CE  MET A 124     -20.272  31.058  32.032  1.00 61.18           C  
ATOM    988  N   PHE A 125     -17.407  27.840  36.278  1.00 60.81           N  
ATOM    989  CA  PHE A 125     -16.047  27.720  36.764  1.00 60.69           C  
ATOM    990  C   PHE A 125     -16.053  27.330  38.254  1.00 60.58           C  
ATOM    991  O   PHE A 125     -16.280  28.171  39.138  1.00 60.66           O  
ATOM    992  CB  PHE A 125     -15.266  29.019  36.497  1.00 60.69           C  
ATOM    993  CG  PHE A 125     -15.319  29.490  35.056  1.00 59.60           C  
ATOM    994  CD1 PHE A 125     -14.740  28.746  34.042  1.00 59.01           C  
ATOM    995  CD2 PHE A 125     -15.939  30.687  34.725  1.00 59.45           C  
ATOM    996  CE1 PHE A 125     -14.784  29.183  32.718  1.00 58.77           C  
ATOM    997  CE2 PHE A 125     -15.978  31.138  33.410  1.00 59.49           C  
ATOM    998  CZ  PHE A 125     -15.402  30.386  32.405  1.00 58.59           C  
ATOM    999  N   PRO A 126     -15.842  26.033  38.537  1.00 60.43           N  
ATOM   1000  CA  PRO A 126     -15.852  25.550  39.933  1.00 60.01           C  
ATOM   1001  C   PRO A 126     -14.718  26.124  40.812  1.00 59.53           C  
ATOM   1002  O   PRO A 126     -14.972  26.454  41.972  1.00 59.97           O  
ATOM   1003  CB  PRO A 126     -15.716  24.029  39.793  1.00 60.07           C  
ATOM   1004  CG  PRO A 126     -15.958  23.712  38.310  1.00 60.38           C  
ATOM   1005  CD  PRO A 126     -15.590  24.953  37.562  1.00 60.41           C  
ATOM   1006  N   ASP A 127     -13.509  26.274  40.259  1.00 58.54           N  
ATOM   1007  CA  ASP A 127     -12.322  26.714  41.027  1.00 57.93           C  
ATOM   1008  C   ASP A 127     -12.229  28.220  41.328  1.00 57.20           C  
ATOM   1009  O   ASP A 127     -11.222  28.680  41.898  1.00 57.45           O  
ATOM   1010  CB  ASP A 127     -11.020  26.284  40.339  1.00 57.87           C  
ATOM   1011  CG  ASP A 127     -11.010  24.820  39.963  1.00 59.50           C  
ATOM   1012  OD1 ASP A 127     -11.901  24.382  39.211  1.00 61.22           O  
ATOM   1013  OD2 ASP A 127     -10.096  24.099  40.401  1.00 62.38           O  
ATOM   1014  N   TYR A 128     -13.251  28.984  40.935  1.00 55.91           N  
ATOM   1015  CA  TYR A 128     -13.240  30.444  41.092  1.00 54.92           C  
ATOM   1016  C   TYR A 128     -14.557  30.951  41.671  1.00 55.24           C  
ATOM   1017  O   TYR A 128     -15.616  30.343  41.463  1.00 55.44           O  
ATOM   1018  CB  TYR A 128     -12.875  31.138  39.763  1.00 54.35           C  
ATOM   1019  CG  TYR A 128     -11.542  30.647  39.248  1.00 52.45           C  
ATOM   1020  CD1 TYR A 128     -11.448  29.469  38.490  1.00 50.11           C  
ATOM   1021  CD2 TYR A 128     -10.364  31.309  39.577  1.00 51.08           C  
ATOM   1022  CE1 TYR A 128     -10.218  28.984  38.067  1.00 48.80           C  
ATOM   1023  CE2 TYR A 128      -9.124  30.834  39.138  1.00 49.84           C  
ATOM   1024  CZ  TYR A 128      -9.066  29.676  38.390  1.00 48.82           C  
ATOM   1025  OH  TYR A 128      -7.851  29.208  37.978  1.00 48.65           O  
ATOM   1026  N   GLY A 129     -14.481  32.047  42.423  1.00 54.96           N  
ATOM   1027  CA  GLY A 129     -15.649  32.597  43.087  1.00 55.07           C  
ATOM   1028  C   GLY A 129     -15.846  34.072  42.800  1.00 55.34           C  
ATOM   1029  O   GLY A 129     -16.839  34.680  43.232  1.00 55.80           O  
ATOM   1030  N   TYR A 130     -14.901  34.663  42.083  1.00 54.93           N  
ATOM   1031  CA  TYR A 130     -15.047  36.052  41.686  1.00 54.95           C  
ATOM   1032  C   TYR A 130     -14.464  36.302  40.295  1.00 54.31           C  
ATOM   1033  O   TYR A 130     -13.597  35.545  39.828  1.00 54.30           O  
ATOM   1034  CB  TYR A 130     -14.423  36.989  42.724  1.00 55.14           C  
ATOM   1035  CG  TYR A 130     -14.870  38.432  42.590  1.00 57.10           C  
ATOM   1036  CD1 TYR A 130     -16.218  38.788  42.731  1.00 59.14           C  
ATOM   1037  CD2 TYR A 130     -13.943  39.450  42.336  1.00 59.26           C  
ATOM   1038  CE1 TYR A 130     -16.634  40.124  42.613  1.00 60.54           C  
ATOM   1039  CE2 TYR A 130     -14.339  40.789  42.225  1.00 60.22           C  
ATOM   1040  CZ  TYR A 130     -15.686  41.117  42.364  1.00 62.35           C  
ATOM   1041  OH  TYR A 130     -16.081  42.439  42.247  1.00 64.41           O  
ATOM   1042  N   GLY A 131     -14.949  37.359  39.648  1.00 52.90           N  
ATOM   1043  CA  GLY A 131     -14.459  37.733  38.338  1.00 51.51           C  
ATOM   1044  C   GLY A 131     -15.228  38.819  37.607  1.00 50.31           C  
ATOM   1045  O   GLY A 131     -16.291  39.264  38.059  1.00 50.23           O  
ATOM   1046  N   TRP A 132     -14.677  39.231  36.467  1.00 48.84           N  
ATOM   1047  CA  TRP A 132     -15.305  40.232  35.617  1.00 48.26           C  
ATOM   1048  C   TRP A 132     -15.627  39.661  34.258  1.00 47.44           C  
ATOM   1049  O   TRP A 132     -15.130  38.604  33.884  1.00 47.71           O  
ATOM   1050  CB  TRP A 132     -14.374  41.435  35.394  1.00 48.26           C  
ATOM   1051  CG  TRP A 132     -13.598  41.888  36.608  1.00 48.75           C  
ATOM   1052  CD1 TRP A 132     -14.079  42.067  37.880  1.00 48.83           C  
ATOM   1053  CD2 TRP A 132     -12.211  42.241  36.652  1.00 47.23           C  
ATOM   1054  NE1 TRP A 132     -13.071  42.494  38.703  1.00 48.99           N  
ATOM   1055  CE2 TRP A 132     -11.918  42.616  37.977  1.00 47.59           C  
ATOM   1056  CE3 TRP A 132     -11.194  42.280  35.701  1.00 45.67           C  
ATOM   1057  CZ2 TRP A 132     -10.654  43.015  38.374  1.00 47.50           C  
ATOM   1058  CZ3 TRP A 132      -9.954  42.679  36.087  1.00 47.04           C  
ATOM   1059  CH2 TRP A 132      -9.686  43.044  37.420  1.00 47.57           C  
ATOM   1060  N   PHE A 133     -16.431  40.402  33.507  1.00 46.27           N  
ATOM   1061  CA  PHE A 133     -16.700  40.088  32.125  1.00 45.67           C  
ATOM   1062  C   PHE A 133     -16.665  41.389  31.318  1.00 45.23           C  
ATOM   1063  O   PHE A 133     -17.186  42.391  31.766  1.00 45.20           O  
ATOM   1064  CB  PHE A 133     -18.059  39.386  31.999  1.00 44.97           C  
ATOM   1065  CG  PHE A 133     -18.404  38.991  30.599  1.00 45.71           C  
ATOM   1066  CD1 PHE A 133     -18.172  37.685  30.151  1.00 45.40           C  
ATOM   1067  CD2 PHE A 133     -18.948  39.929  29.699  1.00 46.65           C  
ATOM   1068  CE1 PHE A 133     -18.476  37.310  28.822  1.00 44.19           C  
ATOM   1069  CE2 PHE A 133     -19.253  39.562  28.362  1.00 46.24           C  
ATOM   1070  CZ  PHE A 133     -19.013  38.249  27.932  1.00 44.47           C  
ATOM   1071  N   HIS A 134     -16.037  41.385  30.148  1.00 44.55           N  
ATOM   1072  CA  HIS A 134     -16.090  42.560  29.276  1.00 43.69           C  
ATOM   1073  C   HIS A 134     -15.718  42.242  27.826  1.00 43.33           C  
ATOM   1074  O   HIS A 134     -15.466  41.096  27.494  1.00 42.81           O  
ATOM   1075  CB  HIS A 134     -15.182  43.658  29.813  1.00 43.79           C  
ATOM   1076  CG  HIS A 134     -13.728  43.301  29.807  1.00 43.71           C  
ATOM   1077  ND1 HIS A 134     -13.172  42.429  30.717  1.00 43.67           N  
ATOM   1078  CD2 HIS A 134     -12.713  43.710  29.008  1.00 43.09           C  
ATOM   1079  CE1 HIS A 134     -11.871  42.330  30.488  1.00 43.90           C  
ATOM   1080  NE2 HIS A 134     -11.567  43.094  29.454  1.00 41.83           N  
ATOM   1081  N   THR A 135     -15.683  43.285  26.984  1.00 42.87           N  
ATOM   1082  CA  THR A 135     -15.354  43.192  25.578  1.00 41.74           C  
ATOM   1083  C   THR A 135     -14.103  43.991  25.270  1.00 41.96           C  
ATOM   1084  O   THR A 135     -14.050  45.195  25.474  1.00 42.21           O  
ATOM   1085  CB  THR A 135     -16.485  43.733  24.731  1.00 41.43           C  
ATOM   1086  OG1 THR A 135     -17.624  42.887  24.870  1.00 41.45           O  
ATOM   1087  CG2 THR A 135     -16.095  43.790  23.274  1.00 41.39           C  
ATOM   1088  N   SER A 136     -13.090  43.314  24.762  1.00 42.06           N  
ATOM   1089  CA  SER A 136     -11.847  43.965  24.466  1.00 42.26           C  
ATOM   1090  C   SER A 136     -11.518  43.845  22.979  1.00 42.88           C  
ATOM   1091  O   SER A 136     -12.411  43.640  22.152  1.00 42.78           O  
ATOM   1092  CB  SER A 136     -10.739  43.395  25.337  1.00 42.09           C  
ATOM   1093  OG  SER A 136      -9.595  44.227  25.275  1.00 42.74           O  
ATOM   1094  N   LEU A 137     -10.240  44.003  22.651  1.00 43.30           N  
ATOM   1095  CA  LEU A 137      -9.755  43.899  21.282  1.00 43.89           C  
ATOM   1096  C   LEU A 137      -8.562  42.991  21.297  1.00 43.62           C  
ATOM   1097  O   LEU A 137      -7.836  42.929  22.288  1.00 43.81           O  
ATOM   1098  CB  LEU A 137      -9.287  45.263  20.747  1.00 43.87           C  
ATOM   1099  CG  LEU A 137     -10.331  46.354  20.565  1.00 46.10           C  
ATOM   1100  CD1 LEU A 137      -9.648  47.706  20.324  1.00 47.25           C  
ATOM   1101  CD2 LEU A 137     -11.298  46.012  19.418  1.00 47.04           C  
ATOM   1102  N   ILE A 138      -8.372  42.311  20.173  1.00 43.67           N  
ATOM   1103  CA  ILE A 138      -7.158  41.598  19.866  1.00 43.87           C  
ATOM   1104  C   ILE A 138      -6.476  42.193  18.644  1.00 44.07           C  
ATOM   1105  O   ILE A 138      -7.109  42.465  17.615  1.00 44.17           O  
ATOM   1106  CB  ILE A 138      -7.412  40.104  19.660  1.00 43.99           C  
ATOM   1107  CG1 ILE A 138      -7.698  39.464  21.017  1.00 44.94           C  
ATOM   1108  CG2 ILE A 138      -6.210  39.426  18.937  1.00 43.39           C  
ATOM   1109  CD1 ILE A 138      -7.817  37.969  20.971  1.00 47.74           C  
ATOM   1110  N   LEU A 139      -5.172  42.390  18.799  1.00 44.37           N  
ATOM   1111  CA  LEU A 139      -4.297  42.841  17.750  1.00 45.01           C  
ATOM   1112  C   LEU A 139      -3.136  41.854  17.626  1.00 45.45           C  
ATOM   1113  O   LEU A 139      -2.144  41.952  18.354  1.00 45.58           O  
ATOM   1114  CB  LEU A 139      -3.792  44.241  18.082  1.00 44.66           C  
ATOM   1115  CG  LEU A 139      -3.046  45.017  17.006  1.00 45.09           C  
ATOM   1116  CD1 LEU A 139      -3.980  45.500  15.891  1.00 43.88           C  
ATOM   1117  CD2 LEU A 139      -2.336  46.196  17.672  1.00 46.13           C  
ATOM   1118  N   GLU A 140      -3.270  40.904  16.706  1.00 45.84           N  
ATOM   1119  CA  GLU A 140      -2.301  39.836  16.559  1.00 46.66           C  
ATOM   1120  C   GLU A 140      -1.002  40.386  15.998  1.00 47.16           C  
ATOM   1121  O   GLU A 140      -0.971  40.926  14.884  1.00 47.51           O  
ATOM   1122  CB  GLU A 140      -2.865  38.732  15.668  1.00 46.41           C  
ATOM   1123  CG  GLU A 140      -4.097  38.079  16.255  1.00 49.04           C  
ATOM   1124  CD  GLU A 140      -4.643  36.924  15.414  1.00 50.93           C  
ATOM   1125  OE1 GLU A 140      -4.966  37.148  14.222  1.00 53.59           O  
ATOM   1126  OE2 GLU A 140      -4.771  35.803  15.954  1.00 48.08           O  
ATOM   1127  N   GLY A 141       0.067  40.244  16.780  1.00 47.87           N  
ATOM   1128  CA  GLY A 141       1.368  40.850  16.475  1.00 48.37           C  
ATOM   1129  C   GLY A 141       1.903  40.490  15.109  1.00 49.20           C  
ATOM   1130  O   GLY A 141       2.446  41.342  14.401  1.00 49.46           O  
ATOM   1131  N   LYS A 142       1.728  39.233  14.718  1.00 50.01           N  
ATOM   1132  CA  LYS A 142       2.289  38.756  13.458  1.00 51.15           C  
ATOM   1133  C   LYS A 142       1.717  39.517  12.252  1.00 50.96           C  
ATOM   1134  O   LYS A 142       2.467  39.936  11.372  1.00 51.32           O  
ATOM   1135  CB  LYS A 142       2.072  37.248  13.322  1.00 51.87           C  
ATOM   1136  CG  LYS A 142       3.168  36.528  12.544  1.00 54.54           C  
ATOM   1137  CD  LYS A 142       2.894  35.015  12.479  1.00 58.09           C  
ATOM   1138  CE  LYS A 142       3.775  34.333  11.410  1.00 61.15           C  
ATOM   1139  NZ  LYS A 142       3.341  34.617   9.988  1.00 63.60           N  
ATOM   1140  N   ASN A 143       0.393  39.695  12.231  1.00 50.52           N  
ATOM   1141  CA  ASN A 143      -0.294  40.444  11.181  1.00 49.89           C  
ATOM   1142  C   ASN A 143       0.019  41.931  11.261  1.00 48.78           C  
ATOM   1143  O   ASN A 143       0.379  42.558  10.263  1.00 48.81           O  
ATOM   1144  CB  ASN A 143      -1.809  40.271  11.308  1.00 50.87           C  
ATOM   1145  CG  ASN A 143      -2.292  38.921  10.842  1.00 52.65           C  
ATOM   1146  OD1 ASN A 143      -3.164  38.315  11.472  1.00 55.33           O  
ATOM   1147  ND2 ASN A 143      -1.748  38.450   9.725  1.00 56.81           N  
ATOM   1148  N   TYR A 144      -0.132  42.482  12.463  1.00 47.21           N  
ATOM   1149  CA  TYR A 144       0.125  43.881  12.733  1.00 45.88           C  
ATOM   1150  C   TYR A 144       1.532  44.327  12.278  1.00 45.68           C  
ATOM   1151  O   TYR A 144       1.694  45.348  11.594  1.00 44.91           O  
ATOM   1152  CB  TYR A 144      -0.120  44.176  14.221  1.00 45.58           C  
ATOM   1153  CG  TYR A 144      -0.195  45.661  14.500  1.00 45.17           C  
ATOM   1154  CD1 TYR A 144      -1.056  46.478  13.752  1.00 44.38           C  
ATOM   1155  CD2 TYR A 144       0.596  46.257  15.486  1.00 43.63           C  
ATOM   1156  CE1 TYR A 144      -1.118  47.842  13.973  1.00 44.55           C  
ATOM   1157  CE2 TYR A 144       0.539  47.644  15.720  1.00 43.80           C  
ATOM   1158  CZ  TYR A 144      -0.322  48.422  14.948  1.00 44.83           C  
ATOM   1159  OH  TYR A 144      -0.431  49.777  15.138  1.00 46.56           O  
ATOM   1160  N   LEU A 145       2.534  43.529  12.641  1.00 45.31           N  
ATOM   1161  CA  LEU A 145       3.926  43.778  12.305  1.00 45.03           C  
ATOM   1162  C   LEU A 145       4.151  43.808  10.779  1.00 44.84           C  
ATOM   1163  O   LEU A 145       5.004  44.545  10.248  1.00 44.35           O  
ATOM   1164  CB  LEU A 145       4.770  42.680  12.956  1.00 45.07           C  
ATOM   1165  CG  LEU A 145       6.002  43.052  13.782  1.00 45.99           C  
ATOM   1166  CD1 LEU A 145       5.706  44.147  14.794  1.00 46.24           C  
ATOM   1167  CD2 LEU A 145       6.555  41.818  14.481  1.00 45.40           C  
ATOM   1168  N   GLN A 146       3.362  42.998  10.087  1.00 44.74           N  
ATOM   1169  CA  GLN A 146       3.433  42.873   8.652  1.00 44.28           C  
ATOM   1170  C   GLN A 146       2.765  44.087   7.988  1.00 43.12           C  
ATOM   1171  O   GLN A 146       3.264  44.611   6.992  1.00 42.23           O  
ATOM   1172  CB  GLN A 146       2.775  41.560   8.235  1.00 44.75           C  
ATOM   1173  CG  GLN A 146       2.846  41.288   6.762  1.00 48.36           C  
ATOM   1174  CD  GLN A 146       4.269  41.352   6.273  1.00 53.38           C  
ATOM   1175  OE1 GLN A 146       5.038  40.425   6.497  1.00 55.19           O  
ATOM   1176  NE2 GLN A 146       4.639  42.464   5.613  1.00 56.00           N  
ATOM   1177  N   TRP A 147       1.651  44.521   8.566  1.00 42.01           N  
ATOM   1178  CA  TRP A 147       0.962  45.727   8.147  1.00 42.34           C  
ATOM   1179  C   TRP A 147       1.841  46.987   8.346  1.00 41.98           C  
ATOM   1180  O   TRP A 147       2.041  47.777   7.407  1.00 41.81           O  
ATOM   1181  CB  TRP A 147      -0.375  45.859   8.901  1.00 42.58           C  
ATOM   1182  CG  TRP A 147      -1.224  46.995   8.404  1.00 45.21           C  
ATOM   1183  CD1 TRP A 147      -2.132  46.946   7.380  1.00 46.97           C  
ATOM   1184  CD2 TRP A 147      -1.238  48.348   8.888  1.00 46.21           C  
ATOM   1185  NE1 TRP A 147      -2.708  48.185   7.193  1.00 48.54           N  
ATOM   1186  CE2 TRP A 147      -2.177  49.067   8.096  1.00 47.78           C  
ATOM   1187  CE3 TRP A 147      -0.551  49.024   9.905  1.00 46.92           C  
ATOM   1188  CZ2 TRP A 147      -2.462  50.435   8.299  1.00 50.02           C  
ATOM   1189  CZ3 TRP A 147      -0.820  50.394  10.103  1.00 49.47           C  
ATOM   1190  CH2 TRP A 147      -1.776  51.083   9.301  1.00 50.22           C  
ATOM   1191  N   LEU A 148       2.375  47.166   9.561  1.00 41.22           N  
ATOM   1192  CA  LEU A 148       3.271  48.293   9.856  1.00 40.23           C  
ATOM   1193  C   LEU A 148       4.402  48.354   8.848  1.00 40.28           C  
ATOM   1194  O   LEU A 148       4.717  49.428   8.319  1.00 39.82           O  
ATOM   1195  CB  LEU A 148       3.835  48.193  11.270  1.00 39.32           C  
ATOM   1196  CG  LEU A 148       2.814  48.434  12.369  1.00 38.28           C  
ATOM   1197  CD1 LEU A 148       3.452  48.125  13.716  1.00 36.84           C  
ATOM   1198  CD2 LEU A 148       2.222  49.865  12.318  1.00 36.46           C  
ATOM   1199  N   THR A 149       4.984  47.187   8.587  1.00 40.15           N  
ATOM   1200  CA  THR A 149       6.044  47.034   7.610  1.00 41.20           C  
ATOM   1201  C   THR A 149       5.655  47.551   6.221  1.00 42.53           C  
ATOM   1202  O   THR A 149       6.341  48.414   5.675  1.00 42.09           O  
ATOM   1203  CB  THR A 149       6.501  45.557   7.523  1.00 41.04           C  
ATOM   1204  OG1 THR A 149       6.952  45.132   8.815  1.00 39.08           O  
ATOM   1205  CG2 THR A 149       7.641  45.355   6.484  1.00 40.91           C  
ATOM   1206  N   GLU A 150       4.562  47.049   5.652  1.00 44.14           N  
ATOM   1207  CA  GLU A 150       4.214  47.464   4.294  1.00 46.30           C  
ATOM   1208  C   GLU A 150       3.919  48.960   4.201  1.00 46.64           C  
ATOM   1209  O   GLU A 150       4.294  49.609   3.221  1.00 46.18           O  
ATOM   1210  CB  GLU A 150       3.124  46.581   3.652  1.00 47.05           C  
ATOM   1211  CG  GLU A 150       1.890  46.334   4.491  1.00 49.93           C  
ATOM   1212  CD  GLU A 150       1.091  45.109   4.040  1.00 54.10           C  
ATOM   1213  OE1 GLU A 150       1.717  44.058   3.733  1.00 53.74           O  
ATOM   1214  OE2 GLU A 150      -0.168  45.201   4.025  1.00 56.00           O  
ATOM   1215  N   ARG A 151       3.282  49.502   5.236  1.00 47.24           N  
ATOM   1216  CA  ARG A 151       3.095  50.942   5.350  1.00 48.64           C  
ATOM   1217  C   ARG A 151       4.447  51.709   5.335  1.00 49.11           C  
ATOM   1218  O   ARG A 151       4.601  52.681   4.595  1.00 49.39           O  
ATOM   1219  CB  ARG A 151       2.285  51.271   6.617  1.00 49.20           C  
ATOM   1220  CG  ARG A 151       0.943  52.004   6.380  1.00 51.64           C  
ATOM   1221  CD  ARG A 151      -0.159  51.046   5.858  1.00 55.49           C  
ATOM   1222  NE  ARG A 151       0.232  50.417   4.586  1.00 60.51           N  
ATOM   1223  CZ  ARG A 151      -0.221  49.249   4.116  1.00 62.28           C  
ATOM   1224  NH1 ARG A 151       0.239  48.802   2.948  1.00 64.20           N  
ATOM   1225  NH2 ARG A 151      -1.121  48.523   4.791  1.00 63.07           N  
ATOM   1226  N   LEU A 152       5.422  51.261   6.131  1.00 48.87           N  
ATOM   1227  CA  LEU A 152       6.731  51.911   6.191  1.00 48.96           C  
ATOM   1228  C   LEU A 152       7.470  51.810   4.879  1.00 49.57           C  
ATOM   1229  O   LEU A 152       8.125  52.761   4.474  1.00 49.94           O  
ATOM   1230  CB  LEU A 152       7.603  51.296   7.302  1.00 48.53           C  
ATOM   1231  CG  LEU A 152       7.640  51.913   8.699  1.00 47.61           C  
ATOM   1232  CD1 LEU A 152       6.320  52.505   9.100  1.00 47.05           C  
ATOM   1233  CD2 LEU A 152       8.046  50.864   9.704  1.00 48.05           C  
ATOM   1234  N   THR A 153       7.388  50.640   4.246  1.00 50.18           N  
ATOM   1235  CA  THR A 153       8.024  50.362   2.964  1.00 51.29           C  
ATOM   1236  C   THR A 153       7.536  51.351   1.891  1.00 51.96           C  
ATOM   1237  O   THR A 153       8.338  51.952   1.173  1.00 52.44           O  
ATOM   1238  CB  THR A 153       7.724  48.909   2.522  1.00 51.32           C  
ATOM   1239  OG1 THR A 153       8.056  48.006   3.586  1.00 52.67           O  
ATOM   1240  CG2 THR A 153       8.519  48.532   1.284  1.00 51.36           C  
ATOM   1241  N   GLU A 154       6.223  51.541   1.815  1.00 52.33           N  
ATOM   1242  CA  GLU A 154       5.649  52.520   0.909  1.00 52.85           C  
ATOM   1243  C   GLU A 154       5.836  53.981   1.356  1.00 52.45           C  
ATOM   1244  O   GLU A 154       5.568  54.918   0.583  1.00 52.55           O  
ATOM   1245  CB  GLU A 154       4.181  52.209   0.642  1.00 53.32           C  
ATOM   1246  CG  GLU A 154       3.239  52.417   1.795  1.00 56.10           C  
ATOM   1247  CD  GLU A 154       2.007  51.521   1.672  1.00 61.40           C  
ATOM   1248  OE1 GLU A 154       2.151  50.350   1.232  1.00 62.10           O  
ATOM   1249  OE2 GLU A 154       0.896  51.981   2.023  1.00 63.64           O  
ATOM   1250  N   ARG A 155       6.289  54.188   2.586  1.00 51.35           N  
ATOM   1251  CA  ARG A 155       6.658  55.538   3.001  1.00 50.44           C  
ATOM   1252  C   ARG A 155       8.122  55.789   2.730  1.00 49.99           C  
ATOM   1253  O   ARG A 155       8.633  56.860   3.036  1.00 51.46           O  
ATOM   1254  CB  ARG A 155       6.250  55.829   4.446  1.00 49.79           C  
ATOM   1255  CG  ARG A 155       4.734  55.716   4.614  1.00 50.57           C  
ATOM   1256  CD  ARG A 155       4.245  56.173   5.937  1.00 53.92           C  
ATOM   1257  NE  ARG A 155       4.119  57.624   5.968  1.00 59.38           N  
ATOM   1258  CZ  ARG A 155       2.961  58.276   5.884  1.00 61.52           C  
ATOM   1259  NH1 ARG A 155       1.817  57.603   5.784  1.00 61.91           N  
ATOM   1260  NH2 ARG A 155       2.949  59.605   5.906  1.00 63.28           N  
ATOM   1261  N   GLY A 156       8.801  54.808   2.148  1.00 49.17           N  
ATOM   1262  CA  GLY A 156      10.220  54.943   1.840  1.00 48.57           C  
ATOM   1263  C   GLY A 156      11.189  54.742   2.995  1.00 48.44           C  
ATOM   1264  O   GLY A 156      12.388  55.046   2.875  1.00 47.76           O  
ATOM   1265  N   VAL A 157      10.683  54.222   4.115  1.00 48.14           N  
ATOM   1266  CA  VAL A 157      11.545  53.829   5.229  1.00 47.79           C  
ATOM   1267  C   VAL A 157      12.339  52.562   4.862  1.00 48.26           C  
ATOM   1268  O   VAL A 157      11.737  51.528   4.564  1.00 48.52           O  
ATOM   1269  CB  VAL A 157      10.714  53.588   6.491  1.00 47.85           C  
ATOM   1270  CG1 VAL A 157      11.621  53.349   7.685  1.00 46.75           C  
ATOM   1271  CG2 VAL A 157       9.790  54.771   6.739  1.00 46.88           C  
ATOM   1272  N   LYS A 158      13.677  52.632   4.883  1.00 48.33           N  
ATOM   1273  CA  LYS A 158      14.504  51.441   4.575  1.00 48.47           C  
ATOM   1274  C   LYS A 158      14.801  50.575   5.812  1.00 47.70           C  
ATOM   1275  O   LYS A 158      15.001  51.089   6.909  1.00 48.01           O  
ATOM   1276  CB  LYS A 158      15.816  51.843   3.896  1.00 49.02           C  
ATOM   1277  CG  LYS A 158      15.664  52.775   2.682  1.00 51.59           C  
ATOM   1278  CD  LYS A 158      15.276  52.035   1.401  1.00 55.69           C  
ATOM   1279  CE  LYS A 158      13.752  51.855   1.246  1.00 56.84           C  
ATOM   1280  NZ  LYS A 158      13.409  51.355  -0.137  1.00 56.74           N  
ATOM   1281  N   PHE A 159      14.830  49.264   5.620  1.00 46.74           N  
ATOM   1282  CA  PHE A 159      15.047  48.316   6.702  1.00 46.01           C  
ATOM   1283  C   PHE A 159      16.408  47.680   6.505  1.00 45.38           C  
ATOM   1284  O   PHE A 159      16.793  47.382   5.388  1.00 44.73           O  
ATOM   1285  CB  PHE A 159      13.968  47.222   6.695  1.00 45.97           C  
ATOM   1286  CG  PHE A 159      12.612  47.652   7.255  1.00 47.29           C  
ATOM   1287  CD1 PHE A 159      11.752  46.709   7.809  1.00 47.70           C  
ATOM   1288  CD2 PHE A 159      12.185  48.977   7.215  1.00 47.97           C  
ATOM   1289  CE1 PHE A 159      10.502  47.088   8.308  1.00 48.98           C  
ATOM   1290  CE2 PHE A 159      10.942  49.355   7.721  1.00 46.97           C  
ATOM   1291  CZ  PHE A 159      10.102  48.415   8.263  1.00 47.29           C  
ATOM   1292  N   PHE A 160      17.129  47.455   7.593  1.00 45.13           N  
ATOM   1293  CA  PHE A 160      18.419  46.800   7.519  1.00 45.58           C  
ATOM   1294  C   PHE A 160      18.555  45.773   8.618  1.00 46.07           C  
ATOM   1295  O   PHE A 160      18.174  46.009   9.769  1.00 46.14           O  
ATOM   1296  CB  PHE A 160      19.552  47.824   7.609  1.00 45.46           C  
ATOM   1297  CG  PHE A 160      19.635  48.728   6.421  1.00 45.73           C  
ATOM   1298  CD1 PHE A 160      18.944  49.935   6.400  1.00 45.72           C  
ATOM   1299  CD2 PHE A 160      20.399  48.371   5.320  1.00 46.70           C  
ATOM   1300  CE1 PHE A 160      19.010  50.771   5.307  1.00 46.80           C  
ATOM   1301  CE2 PHE A 160      20.476  49.217   4.207  1.00 48.18           C  
ATOM   1302  CZ  PHE A 160      19.766  50.408   4.202  1.00 47.70           C  
ATOM   1303  N   GLN A 161      19.103  44.627   8.261  1.00 46.79           N  
ATOM   1304  CA  GLN A 161      19.288  43.566   9.224  1.00 47.43           C  
ATOM   1305  C   GLN A 161      20.719  43.564   9.720  1.00 47.77           C  
ATOM   1306  O   GLN A 161      21.637  43.165   8.989  1.00 48.10           O  
ATOM   1307  CB  GLN A 161      18.884  42.205   8.630  1.00 47.60           C  
ATOM   1308  CG  GLN A 161      18.783  41.070   9.660  1.00 46.75           C  
ATOM   1309  CD  GLN A 161      20.122  40.407   9.945  1.00 46.72           C  
ATOM   1310  OE1 GLN A 161      20.377  40.009  11.067  1.00 47.19           O  
ATOM   1311  NE2 GLN A 161      20.975  40.276   8.924  1.00 47.39           N  
ATOM   1312  N   ARG A 162      20.885  44.017  10.962  1.00 48.15           N  
ATOM   1313  CA  ARG A 162      22.188  44.118  11.624  1.00 49.37           C  
ATOM   1314  C   ARG A 162      22.077  44.344  13.137  1.00 49.40           C  
ATOM   1315  O   ARG A 162      21.120  44.958  13.634  1.00 49.01           O  
ATOM   1316  CB  ARG A 162      23.031  45.236  11.001  1.00 50.17           C  
ATOM   1317  CG  ARG A 162      22.359  46.612  11.042  1.00 52.26           C  
ATOM   1318  CD  ARG A 162      23.269  47.663  10.453  1.00 56.40           C  
ATOM   1319  NE  ARG A 162      24.411  47.909  11.329  1.00 59.18           N  
ATOM   1320  CZ  ARG A 162      25.270  48.914  11.192  1.00 59.80           C  
ATOM   1321  NH1 ARG A 162      25.142  49.799  10.205  1.00 60.16           N  
ATOM   1322  NH2 ARG A 162      26.259  49.035  12.059  1.00 60.77           N  
ATOM   1323  N   LYS A 163      23.078  43.849  13.859  1.00 49.68           N  
ATOM   1324  CA  LYS A 163      23.141  43.991  15.303  1.00 49.91           C  
ATOM   1325  C   LYS A 163      23.989  45.213  15.638  1.00 49.90           C  
ATOM   1326  O   LYS A 163      25.154  45.291  15.287  1.00 49.56           O  
ATOM   1327  CB  LYS A 163      23.735  42.720  15.925  1.00 50.36           C  
ATOM   1328  CG  LYS A 163      23.642  42.620  17.447  1.00 50.76           C  
ATOM   1329  CD  LYS A 163      23.830  41.188  17.893  1.00 51.50           C  
ATOM   1330  CE  LYS A 163      24.620  41.116  19.201  1.00 55.44           C  
ATOM   1331  NZ  LYS A 163      26.104  40.924  18.967  1.00 56.52           N  
ATOM   1332  N   VAL A 164      23.383  46.170  16.320  1.00 50.36           N  
ATOM   1333  CA  VAL A 164      24.053  47.414  16.675  1.00 51.02           C  
ATOM   1334  C   VAL A 164      24.803  47.230  17.997  1.00 52.04           C  
ATOM   1335  O   VAL A 164      24.191  46.908  19.018  1.00 52.04           O  
ATOM   1336  CB  VAL A 164      23.021  48.546  16.803  1.00 50.63           C  
ATOM   1337  CG1 VAL A 164      23.619  49.750  17.471  1.00 49.39           C  
ATOM   1338  CG2 VAL A 164      22.450  48.893  15.441  1.00 50.05           C  
ATOM   1339  N   GLU A 165      26.117  47.436  17.967  1.00 53.16           N  
ATOM   1340  CA  GLU A 165      26.990  47.199  19.117  1.00 54.51           C  
ATOM   1341  C   GLU A 165      26.893  48.298  20.150  1.00 54.87           C  
ATOM   1342  O   GLU A 165      26.958  48.037  21.361  1.00 54.78           O  
ATOM   1343  CB  GLU A 165      28.430  47.092  18.654  1.00 55.19           C  
ATOM   1344  CG  GLU A 165      28.621  46.054  17.583  1.00 58.52           C  
ATOM   1345  CD  GLU A 165      28.630  44.687  18.175  1.00 63.49           C  
ATOM   1346  OE1 GLU A 165      29.669  44.346  18.791  1.00 66.39           O  
ATOM   1347  OE2 GLU A 165      27.606  43.963  18.048  1.00 66.78           O  
ATOM   1348  N   SER A 166      26.746  49.533  19.671  1.00 55.37           N  
ATOM   1349  CA  SER A 166      26.625  50.691  20.551  1.00 55.46           C  
ATOM   1350  C   SER A 166      26.026  51.881  19.836  1.00 55.81           C  
ATOM   1351  O   SER A 166      26.080  51.989  18.610  1.00 55.72           O  
ATOM   1352  CB  SER A 166      27.993  51.086  21.121  1.00 55.41           C  
ATOM   1353  OG  SER A 166      28.810  51.676  20.129  1.00 54.58           O  
ATOM   1354  N   PHE A 167      25.476  52.787  20.629  1.00 56.42           N  
ATOM   1355  CA  PHE A 167      24.962  54.046  20.131  1.00 57.30           C  
ATOM   1356  C   PHE A 167      26.060  54.826  19.410  1.00 58.00           C  
ATOM   1357  O   PHE A 167      25.812  55.403  18.350  1.00 58.37           O  
ATOM   1358  CB  PHE A 167      24.397  54.867  21.284  1.00 57.01           C  
ATOM   1359  CG  PHE A 167      23.227  54.226  21.986  1.00 57.94           C  
ATOM   1360  CD1 PHE A 167      22.303  53.438  21.282  1.00 58.79           C  
ATOM   1361  CD2 PHE A 167      23.012  54.455  23.344  1.00 57.78           C  
ATOM   1362  CE1 PHE A 167      21.206  52.860  21.936  1.00 58.95           C  
ATOM   1363  CE2 PHE A 167      21.921  53.889  24.005  1.00 58.20           C  
ATOM   1364  CZ  PHE A 167      21.011  53.090  23.306  1.00 58.63           C  
ATOM   1365  N   GLU A 168      27.270  54.822  19.983  1.00 58.72           N  
ATOM   1366  CA  GLU A 168      28.439  55.497  19.410  1.00 59.25           C  
ATOM   1367  C   GLU A 168      28.627  55.129  17.946  1.00 59.06           C  
ATOM   1368  O   GLU A 168      28.715  56.022  17.104  1.00 59.09           O  
ATOM   1369  CB  GLU A 168      29.718  55.168  20.192  1.00 59.97           C  
ATOM   1370  CG  GLU A 168      29.560  55.118  21.716  1.00 62.43           C  
ATOM   1371  CD  GLU A 168      29.288  56.476  22.320  1.00 65.15           C  
ATOM   1372  OE1 GLU A 168      28.168  56.655  22.856  1.00 66.41           O  
ATOM   1373  OE2 GLU A 168      30.186  57.359  22.249  1.00 66.40           O  
ATOM   1374  N   GLU A 169      28.658  53.824  17.650  1.00 58.64           N  
ATOM   1375  CA  GLU A 169      28.712  53.322  16.270  1.00 58.67           C  
ATOM   1376  C   GLU A 169      27.694  54.004  15.322  1.00 58.28           C  
ATOM   1377  O   GLU A 169      28.031  54.367  14.185  1.00 58.69           O  
ATOM   1378  CB  GLU A 169      28.515  51.801  16.254  1.00 58.82           C  
ATOM   1379  CG  GLU A 169      28.319  51.165  14.855  1.00 60.76           C  
ATOM   1380  CD  GLU A 169      27.987  49.659  14.907  1.00 63.69           C  
ATOM   1381  OE1 GLU A 169      28.371  48.932  13.954  1.00 62.64           O  
ATOM   1382  OE2 GLU A 169      27.357  49.203  15.901  1.00 63.48           O  
ATOM   1383  N   VAL A 170      26.468  54.190  15.801  1.00 57.35           N  
ATOM   1384  CA  VAL A 170      25.372  54.703  14.978  1.00 56.67           C  
ATOM   1385  C   VAL A 170      25.492  56.214  14.763  1.00 56.16           C  
ATOM   1386  O   VAL A 170      25.275  56.717  13.664  1.00 55.48           O  
ATOM   1387  CB  VAL A 170      23.986  54.304  15.584  1.00 56.83           C  
ATOM   1388  CG1 VAL A 170      22.829  54.831  14.744  1.00 56.57           C  
ATOM   1389  CG2 VAL A 170      23.892  52.784  15.703  1.00 56.08           C  
ATOM   1390  N   ALA A 171      25.851  56.932  15.820  1.00 56.14           N  
ATOM   1391  CA  ALA A 171      26.152  58.349  15.694  1.00 55.92           C  
ATOM   1392  C   ALA A 171      27.365  58.520  14.771  1.00 55.81           C  
ATOM   1393  O   ALA A 171      27.299  59.243  13.787  1.00 55.42           O  
ATOM   1394  CB  ALA A 171      26.398  58.972  17.070  1.00 55.61           C  
ATOM   1395  N   ARG A 172      28.445  57.806  15.069  1.00 56.05           N  
ATOM   1396  CA  ARG A 172      29.663  57.864  14.265  1.00 57.06           C  
ATOM   1397  C   ARG A 172      29.414  57.755  12.768  1.00 56.95           C  
ATOM   1398  O   ARG A 172      30.193  58.281  11.967  1.00 56.94           O  
ATOM   1399  CB  ARG A 172      30.651  56.763  14.687  1.00 57.65           C  
ATOM   1400  CG  ARG A 172      31.730  57.189  15.718  1.00 60.25           C  
ATOM   1401  CD  ARG A 172      31.142  57.744  17.043  1.00 65.78           C  
ATOM   1402  NE  ARG A 172      32.184  57.956  18.055  1.00 70.33           N  
ATOM   1403  CZ  ARG A 172      32.916  59.079  18.167  1.00 72.38           C  
ATOM   1404  NH1 ARG A 172      33.847  59.155  19.116  1.00 72.22           N  
ATOM   1405  NH2 ARG A 172      32.725  60.128  17.334  1.00 72.95           N  
ATOM   1406  N   GLU A 173      28.338  57.071  12.383  1.00 56.95           N  
ATOM   1407  CA  GLU A 173      28.105  56.830  10.963  1.00 56.79           C  
ATOM   1408  C   GLU A 173      27.118  57.817  10.367  1.00 55.88           C  
ATOM   1409  O   GLU A 173      26.852  57.778   9.162  1.00 56.29           O  
ATOM   1410  CB  GLU A 173      27.702  55.374  10.684  1.00 57.22           C  
ATOM   1411  CG  GLU A 173      26.354  54.990  11.266  1.00 59.66           C  
ATOM   1412  CD  GLU A 173      25.602  53.981  10.410  1.00 62.67           C  
ATOM   1413  OE1 GLU A 173      24.356  53.982  10.505  1.00 63.84           O  
ATOM   1414  OE2 GLU A 173      26.240  53.202   9.652  1.00 63.11           O  
ATOM   1415  N   GLY A 174      26.570  58.700  11.197  1.00 54.98           N  
ATOM   1416  CA  GLY A 174      25.827  59.850  10.675  1.00 54.02           C  
ATOM   1417  C   GLY A 174      24.428  60.108  11.194  1.00 53.39           C  
ATOM   1418  O   GLY A 174      23.736  60.997  10.692  1.00 53.71           O  
ATOM   1419  N   ALA A 175      23.999  59.354  12.197  1.00 52.67           N  
ATOM   1420  CA  ALA A 175      22.664  59.548  12.753  1.00 52.42           C  
ATOM   1421  C   ALA A 175      22.574  60.859  13.530  1.00 52.31           C  
ATOM   1422  O   ALA A 175      23.481  61.201  14.277  1.00 52.81           O  
ATOM   1423  CB  ALA A 175      22.276  58.371  13.635  1.00 51.96           C  
ATOM   1424  N   ASP A 176      21.488  61.591  13.338  1.00 52.05           N  
ATOM   1425  CA  ASP A 176      21.222  62.784  14.133  1.00 52.17           C  
ATOM   1426  C   ASP A 176      20.247  62.491  15.284  1.00 51.56           C  
ATOM   1427  O   ASP A 176      20.305  63.149  16.315  1.00 51.87           O  
ATOM   1428  CB  ASP A 176      20.661  63.922  13.268  1.00 52.69           C  
ATOM   1429  CG  ASP A 176      21.577  64.306  12.120  1.00 55.24           C  
ATOM   1430  OD1 ASP A 176      21.470  63.702  11.011  1.00 57.43           O  
ATOM   1431  OD2 ASP A 176      22.385  65.248  12.325  1.00 57.97           O  
ATOM   1432  N   VAL A 177      19.325  61.544  15.093  1.00 50.46           N  
ATOM   1433  CA  VAL A 177      18.470  61.071  16.176  1.00 49.16           C  
ATOM   1434  C   VAL A 177      18.443  59.560  16.141  1.00 48.34           C  
ATOM   1435  O   VAL A 177      18.290  58.975  15.073  1.00 47.87           O  
ATOM   1436  CB  VAL A 177      17.020  61.597  16.084  1.00 49.42           C  
ATOM   1437  CG1 VAL A 177      16.148  60.943  17.140  1.00 48.51           C  
ATOM   1438  CG2 VAL A 177      16.969  63.110  16.254  1.00 49.78           C  
ATOM   1439  N   ILE A 178      18.609  58.944  17.316  1.00 46.94           N  
ATOM   1440  CA  ILE A 178      18.484  57.505  17.485  1.00 45.21           C  
ATOM   1441  C   ILE A 178      17.270  57.173  18.340  1.00 45.67           C  
ATOM   1442  O   ILE A 178      17.127  57.687  19.462  1.00 45.88           O  
ATOM   1443  CB  ILE A 178      19.733  56.890  18.126  1.00 45.05           C  
ATOM   1444  CG1 ILE A 178      20.939  57.143  17.228  1.00 43.54           C  
ATOM   1445  CG2 ILE A 178      19.527  55.378  18.421  1.00 42.17           C  
ATOM   1446  CD1 ILE A 178      22.231  56.973  17.912  1.00 44.18           C  
ATOM   1447  N   VAL A 179      16.395  56.319  17.803  1.00 45.14           N  
ATOM   1448  CA  VAL A 179      15.211  55.871  18.537  1.00 44.62           C  
ATOM   1449  C   VAL A 179      15.489  54.481  19.092  1.00 44.70           C  
ATOM   1450  O   VAL A 179      15.715  53.529  18.334  1.00 45.12           O  
ATOM   1451  CB  VAL A 179      13.975  55.841  17.649  1.00 44.46           C  
ATOM   1452  CG1 VAL A 179      12.729  55.665  18.502  1.00 44.17           C  
ATOM   1453  CG2 VAL A 179      13.891  57.123  16.838  1.00 43.76           C  
ATOM   1454  N   ASN A 180      15.513  54.369  20.413  1.00 44.22           N  
ATOM   1455  CA  ASN A 180      15.910  53.122  21.033  1.00 43.82           C  
ATOM   1456  C   ASN A 180      14.704  52.261  21.423  1.00 43.55           C  
ATOM   1457  O   ASN A 180      14.004  52.543  22.418  1.00 43.98           O  
ATOM   1458  CB  ASN A 180      16.820  53.383  22.232  1.00 44.06           C  
ATOM   1459  CG  ASN A 180      17.457  52.120  22.751  1.00 43.27           C  
ATOM   1460  OD1 ASN A 180      18.051  51.341  21.995  1.00 43.45           O  
ATOM   1461  ND2 ASN A 180      17.333  51.903  24.041  1.00 42.51           N  
ATOM   1462  N   CYS A 181      14.467  51.225  20.621  1.00 42.31           N  
ATOM   1463  CA  CYS A 181      13.278  50.386  20.744  1.00 41.77           C  
ATOM   1464  C   CYS A 181      13.659  48.915  20.756  1.00 41.19           C  
ATOM   1465  O   CYS A 181      13.003  48.095  20.126  1.00 41.37           O  
ATOM   1466  CB  CYS A 181      12.330  50.647  19.578  1.00 41.52           C  
ATOM   1467  SG  CYS A 181      11.891  52.380  19.390  1.00 42.58           S  
ATOM   1468  N   THR A 182      14.720  48.608  21.498  1.00 40.37           N  
ATOM   1469  CA  THR A 182      15.402  47.329  21.483  1.00 39.39           C  
ATOM   1470  C   THR A 182      14.785  46.330  22.457  1.00 40.00           C  
ATOM   1471  O   THR A 182      15.343  45.265  22.698  1.00 40.08           O  
ATOM   1472  CB  THR A 182      16.863  47.535  21.858  1.00 39.18           C  
ATOM   1473  OG1 THR A 182      16.944  48.498  22.930  1.00 38.29           O  
ATOM   1474  CG2 THR A 182      17.631  48.051  20.662  1.00 36.48           C  
ATOM   1475  N   GLY A 183      13.634  46.691  23.015  1.00 40.47           N  
ATOM   1476  CA  GLY A 183      12.913  45.827  23.927  1.00 41.23           C  
ATOM   1477  C   GLY A 183      13.745  45.338  25.097  1.00 42.04           C  
ATOM   1478  O   GLY A 183      14.435  46.122  25.757  1.00 42.73           O  
ATOM   1479  N   VAL A 184      13.682  44.031  25.349  1.00 41.88           N  
ATOM   1480  CA  VAL A 184      14.275  43.444  26.535  1.00 41.15           C  
ATOM   1481  C   VAL A 184      15.799  43.461  26.466  1.00 40.84           C  
ATOM   1482  O   VAL A 184      16.457  43.322  27.493  1.00 40.71           O  
ATOM   1483  CB  VAL A 184      13.749  41.978  26.750  1.00 41.25           C  
ATOM   1484  CG1 VAL A 184      14.550  40.968  25.925  1.00 39.15           C  
ATOM   1485  CG2 VAL A 184      13.784  41.611  28.227  1.00 41.60           C  
ATOM   1486  N   TRP A 185      16.349  43.605  25.255  1.00 40.20           N  
ATOM   1487  CA  TRP A 185      17.794  43.602  25.066  1.00 39.91           C  
ATOM   1488  C   TRP A 185      18.395  44.994  25.171  1.00 39.72           C  
ATOM   1489  O   TRP A 185      19.573  45.169  24.850  1.00 39.91           O  
ATOM   1490  CB  TRP A 185      18.163  42.998  23.726  1.00 39.50           C  
ATOM   1491  CG  TRP A 185      17.724  41.597  23.597  1.00 42.73           C  
ATOM   1492  CD1 TRP A 185      18.400  40.501  24.022  1.00 44.65           C  
ATOM   1493  CD2 TRP A 185      16.494  41.117  23.027  1.00 44.56           C  
ATOM   1494  NE1 TRP A 185      17.672  39.362  23.753  1.00 47.15           N  
ATOM   1495  CE2 TRP A 185      16.501  39.713  23.141  1.00 45.96           C  
ATOM   1496  CE3 TRP A 185      15.391  41.736  22.426  1.00 47.44           C  
ATOM   1497  CZ2 TRP A 185      15.452  38.907  22.665  1.00 48.78           C  
ATOM   1498  CZ3 TRP A 185      14.326  40.920  21.953  1.00 48.17           C  
ATOM   1499  CH2 TRP A 185      14.375  39.532  22.077  1.00 47.86           C  
ATOM   1500  N   ALA A 186      17.612  45.981  25.617  1.00 39.00           N  
ATOM   1501  CA  ALA A 186      18.111  47.364  25.675  1.00 39.86           C  
ATOM   1502  C   ALA A 186      19.402  47.516  26.491  1.00 40.09           C  
ATOM   1503  O   ALA A 186      20.314  48.286  26.116  1.00 39.63           O  
ATOM   1504  CB  ALA A 186      17.029  48.317  26.200  1.00 40.22           C  
ATOM   1505  N   GLY A 187      19.469  46.772  27.603  1.00 40.22           N  
ATOM   1506  CA  GLY A 187      20.600  46.816  28.518  1.00 39.80           C  
ATOM   1507  C   GLY A 187      21.934  46.511  27.864  1.00 40.47           C  
ATOM   1508  O   GLY A 187      22.962  46.935  28.372  1.00 40.12           O  
ATOM   1509  N   ALA A 188      21.941  45.787  26.742  1.00 40.87           N  
ATOM   1510  CA  ALA A 188      23.198  45.546  26.016  1.00 41.97           C  
ATOM   1511  C   ALA A 188      23.762  46.811  25.348  1.00 43.38           C  
ATOM   1512  O   ALA A 188      24.880  46.797  24.846  1.00 43.47           O  
ATOM   1513  CB  ALA A 188      23.020  44.450  24.979  1.00 41.70           C  
ATOM   1514  N   LEU A 189      22.992  47.897  25.310  1.00 44.63           N  
ATOM   1515  CA  LEU A 189      23.513  49.160  24.765  1.00 45.90           C  
ATOM   1516  C   LEU A 189      23.769  50.229  25.861  1.00 47.04           C  
ATOM   1517  O   LEU A 189      24.657  51.069  25.732  1.00 46.79           O  
ATOM   1518  CB  LEU A 189      22.587  49.702  23.662  1.00 45.51           C  
ATOM   1519  CG  LEU A 189      22.180  48.769  22.517  1.00 45.47           C  
ATOM   1520  CD1 LEU A 189      20.900  49.261  21.908  1.00 45.24           C  
ATOM   1521  CD2 LEU A 189      23.261  48.650  21.433  1.00 45.91           C  
ATOM   1522  N   GLN A 190      22.972  50.198  26.926  1.00 48.26           N  
ATOM   1523  CA  GLN A 190      23.182  51.073  28.068  1.00 49.43           C  
ATOM   1524  C   GLN A 190      22.691  50.371  29.309  1.00 50.88           C  
ATOM   1525  O   GLN A 190      21.490  50.154  29.469  1.00 51.56           O  
ATOM   1526  CB  GLN A 190      22.468  52.421  27.889  1.00 49.26           C  
ATOM   1527  CG  GLN A 190      22.609  53.378  29.064  1.00 46.51           C  
ATOM   1528  CD  GLN A 190      21.746  54.611  28.886  1.00 47.43           C  
ATOM   1529  OE1 GLN A 190      20.698  54.760  29.537  1.00 44.98           O  
ATOM   1530  NE2 GLN A 190      22.162  55.501  27.974  1.00 47.51           N  
ATOM   1531  N   ARG A 191      23.635  50.010  30.172  1.00 52.21           N  
ATOM   1532  CA  ARG A 191      23.364  49.418  31.482  1.00 54.01           C  
ATOM   1533  C   ARG A 191      22.047  49.934  32.091  1.00 54.46           C  
ATOM   1534  O   ARG A 191      21.794  51.141  32.129  1.00 54.51           O  
ATOM   1535  CB  ARG A 191      24.536  49.761  32.420  1.00 54.36           C  
ATOM   1536  CG  ARG A 191      25.196  48.581  33.148  1.00 56.51           C  
ATOM   1537  CD  ARG A 191      24.564  48.300  34.523  1.00 60.25           C  
ATOM   1538  NE  ARG A 191      24.409  49.506  35.343  1.00 61.92           N  
ATOM   1539  CZ  ARG A 191      23.982  49.517  36.603  1.00 62.14           C  
ATOM   1540  NH1 ARG A 191      23.676  48.385  37.213  1.00 62.53           N  
ATOM   1541  NH2 ARG A 191      23.854  50.667  37.250  1.00 62.89           N  
ATOM   1542  N   ASP A 192      21.205  49.021  32.554  1.00 55.26           N  
ATOM   1543  CA  ASP A 192      20.001  49.407  33.289  1.00 55.96           C  
ATOM   1544  C   ASP A 192      19.487  48.191  34.048  1.00 56.14           C  
ATOM   1545  O   ASP A 192      18.839  47.324  33.477  1.00 56.34           O  
ATOM   1546  CB  ASP A 192      18.952  50.020  32.338  1.00 55.91           C  
ATOM   1547  CG  ASP A 192      17.563  50.144  32.958  1.00 56.10           C  
ATOM   1548  OD1 ASP A 192      17.411  50.021  34.201  1.00 55.47           O  
ATOM   1549  OD2 ASP A 192      16.614  50.370  32.164  1.00 55.02           O  
ATOM   1550  N   PRO A 193      19.793  48.127  35.350  1.00 56.36           N  
ATOM   1551  CA  PRO A 193      19.482  46.943  36.150  1.00 56.31           C  
ATOM   1552  C   PRO A 193      17.971  46.728  36.406  1.00 56.23           C  
ATOM   1553  O   PRO A 193      17.566  45.643  36.858  1.00 56.37           O  
ATOM   1554  CB  PRO A 193      20.230  47.214  37.457  1.00 56.47           C  
ATOM   1555  CG  PRO A 193      20.294  48.729  37.546  1.00 56.49           C  
ATOM   1556  CD  PRO A 193      20.441  49.196  36.141  1.00 56.19           C  
ATOM   1557  N   LEU A 194      17.149  47.743  36.131  1.00 55.53           N  
ATOM   1558  CA  LEU A 194      15.699  47.632  36.350  1.00 54.87           C  
ATOM   1559  C   LEU A 194      15.018  46.764  35.283  1.00 53.62           C  
ATOM   1560  O   LEU A 194      14.075  46.022  35.574  1.00 54.33           O  
ATOM   1561  CB  LEU A 194      15.042  49.015  36.433  1.00 54.92           C  
ATOM   1562  CG  LEU A 194      15.526  49.917  37.580  1.00 56.97           C  
ATOM   1563  CD1 LEU A 194      14.836  51.297  37.542  1.00 57.82           C  
ATOM   1564  CD2 LEU A 194      15.341  49.258  38.959  1.00 57.37           C  
ATOM   1565  N   LEU A 195      15.524  46.854  34.061  1.00 51.72           N  
ATOM   1566  CA  LEU A 195      15.006  46.090  32.942  1.00 49.98           C  
ATOM   1567  C   LEU A 195      15.394  44.632  33.051  1.00 49.47           C  
ATOM   1568  O   LEU A 195      16.576  44.313  32.982  1.00 49.00           O  
ATOM   1569  CB  LEU A 195      15.495  46.681  31.599  1.00 49.16           C  
ATOM   1570  CG  LEU A 195      15.156  45.971  30.281  1.00 45.30           C  
ATOM   1571  CD1 LEU A 195      13.697  46.030  30.002  1.00 44.81           C  
ATOM   1572  CD2 LEU A 195      15.883  46.595  29.136  1.00 45.27           C  
ATOM   1573  N   GLN A 196      14.390  43.763  33.192  1.00 49.47           N  
ATOM   1574  CA  GLN A 196      14.601  42.292  33.287  1.00 49.91           C  
ATOM   1575  C   GLN A 196      13.607  41.470  32.458  1.00 48.89           C  
ATOM   1576  O   GLN A 196      12.454  41.865  32.307  1.00 48.72           O  
ATOM   1577  CB  GLN A 196      14.582  41.824  34.752  1.00 50.31           C  
ATOM   1578  CG  GLN A 196      13.582  42.599  35.655  1.00 53.98           C  
ATOM   1579  CD  GLN A 196      13.444  42.029  37.075  1.00 56.79           C  
ATOM   1580  OE1 GLN A 196      12.611  42.494  37.863  1.00 57.17           O  
ATOM   1581  NE2 GLN A 196      14.245  41.007  37.393  1.00 57.57           N  
ATOM   1582  N   PRO A 197      14.057  40.322  31.907  1.00 48.42           N  
ATOM   1583  CA  PRO A 197      13.206  39.388  31.148  1.00 47.58           C  
ATOM   1584  C   PRO A 197      12.083  38.767  31.973  1.00 46.98           C  
ATOM   1585  O   PRO A 197      12.330  38.279  33.078  1.00 46.32           O  
ATOM   1586  CB  PRO A 197      14.165  38.262  30.745  1.00 47.52           C  
ATOM   1587  CG  PRO A 197      15.501  38.812  30.913  1.00 48.44           C  
ATOM   1588  CD  PRO A 197      15.450  39.850  31.982  1.00 48.61           C  
ATOM   1589  N   GLY A 198      10.863  38.817  31.431  1.00 46.39           N  
ATOM   1590  CA  GLY A 198       9.750  37.987  31.899  1.00 45.70           C  
ATOM   1591  C   GLY A 198       9.437  36.874  30.901  1.00 44.74           C  
ATOM   1592  O   GLY A 198       8.547  37.029  30.052  1.00 44.84           O  
ATOM   1593  N   ARG A 199      10.159  35.757  30.995  1.00 43.60           N  
ATOM   1594  CA  ARG A 199       9.967  34.634  30.068  1.00 42.91           C  
ATOM   1595  C   ARG A 199       8.515  34.143  30.050  1.00 43.27           C  
ATOM   1596  O   ARG A 199       7.854  34.100  31.084  1.00 43.19           O  
ATOM   1597  CB  ARG A 199      10.919  33.488  30.394  1.00 42.23           C  
ATOM   1598  CG  ARG A 199      11.111  32.469  29.276  1.00 40.27           C  
ATOM   1599  CD  ARG A 199      11.914  31.294  29.753  1.00 37.62           C  
ATOM   1600  NE  ARG A 199      11.765  30.126  28.886  1.00 38.46           N  
ATOM   1601  CZ  ARG A 199      10.797  29.202  28.967  1.00 37.43           C  
ATOM   1602  NH1 ARG A 199       9.836  29.275  29.870  1.00 35.06           N  
ATOM   1603  NH2 ARG A 199      10.783  28.200  28.101  1.00 39.48           N  
ATOM   1604  N   GLY A 200       8.030  33.815  28.855  1.00 43.61           N  
ATOM   1605  CA  GLY A 200       6.720  33.195  28.658  1.00 43.67           C  
ATOM   1606  C   GLY A 200       6.831  32.050  27.669  1.00 44.02           C  
ATOM   1607  O   GLY A 200       7.800  31.964  26.908  1.00 43.81           O  
ATOM   1608  N   GLN A 201       5.851  31.145  27.706  1.00 44.82           N  
ATOM   1609  CA  GLN A 201       5.806  30.006  26.791  1.00 45.08           C  
ATOM   1610  C   GLN A 201       4.377  29.665  26.435  1.00 45.39           C  
ATOM   1611  O   GLN A 201       3.718  28.932  27.159  1.00 47.18           O  
ATOM   1612  CB  GLN A 201       6.477  28.769  27.375  1.00 44.35           C  
ATOM   1613  CG  GLN A 201       6.412  27.562  26.443  1.00 44.61           C  
ATOM   1614  CD  GLN A 201       7.290  26.390  26.867  1.00 46.08           C  
ATOM   1615  OE1 GLN A 201       7.037  25.238  26.502  1.00 46.70           O  
ATOM   1616  NE2 GLN A 201       8.345  26.681  27.604  1.00 46.91           N  
ATOM   1617  N   ILE A 202       3.896  30.172  25.317  1.00 45.10           N  
ATOM   1618  CA  ILE A 202       2.551  29.850  24.888  1.00 44.93           C  
ATOM   1619  C   ILE A 202       2.485  28.596  24.013  1.00 45.41           C  
ATOM   1620  O   ILE A 202       3.494  28.079  23.538  1.00 45.86           O  
ATOM   1621  CB  ILE A 202       1.909  31.016  24.139  1.00 44.75           C  
ATOM   1622  CG1 ILE A 202       2.783  31.378  22.924  1.00 45.39           C  
ATOM   1623  CG2 ILE A 202       1.626  32.195  25.116  1.00 43.72           C  
ATOM   1624  CD1 ILE A 202       2.126  32.294  21.921  1.00 48.01           C  
ATOM   1625  N   MET A 203       1.257  28.149  23.798  1.00 45.85           N  
ATOM   1626  CA  MET A 203       0.917  26.979  23.011  1.00 46.15           C  
ATOM   1627  C   MET A 203      -0.255  27.401  22.095  1.00 45.64           C  
ATOM   1628  O   MET A 203      -1.239  27.985  22.556  1.00 45.16           O  
ATOM   1629  CB  MET A 203       0.521  25.878  24.000  1.00 46.30           C  
ATOM   1630  CG  MET A 203       0.230  24.499  23.483  1.00 47.99           C  
ATOM   1631  SD  MET A 203      -0.097  23.390  24.910  1.00 50.85           S  
ATOM   1632  CE  MET A 203       1.422  23.563  25.830  1.00 46.91           C  
ATOM   1633  N   LYS A 204      -0.116  27.153  20.799  1.00 45.81           N  
ATOM   1634  CA  LYS A 204      -1.177  27.442  19.823  1.00 46.05           C  
ATOM   1635  C   LYS A 204      -1.960  26.160  19.531  1.00 45.49           C  
ATOM   1636  O   LYS A 204      -1.381  25.134  19.167  1.00 44.82           O  
ATOM   1637  CB  LYS A 204      -0.588  27.981  18.515  1.00 46.53           C  
ATOM   1638  CG  LYS A 204       0.403  29.162  18.642  1.00 49.08           C  
ATOM   1639  CD  LYS A 204      -0.301  30.503  18.672  1.00 51.96           C  
ATOM   1640  CE  LYS A 204       0.541  31.583  18.006  1.00 55.62           C  
ATOM   1641  NZ  LYS A 204      -0.290  32.797  17.605  1.00 56.42           N  
ATOM   1642  N   VAL A 205      -3.275  26.226  19.684  1.00 45.04           N  
ATOM   1643  CA  VAL A 205      -4.103  25.041  19.563  1.00 44.99           C  
ATOM   1644  C   VAL A 205      -5.296  25.317  18.651  1.00 45.02           C  
ATOM   1645  O   VAL A 205      -5.748  26.456  18.558  1.00 45.35           O  
ATOM   1646  CB  VAL A 205      -4.533  24.539  20.979  1.00 44.86           C  
ATOM   1647  CG1 VAL A 205      -5.819  25.194  21.457  1.00 44.29           C  
ATOM   1648  CG2 VAL A 205      -4.699  23.070  20.976  1.00 46.19           C  
ATOM   1649  N   ASP A 206      -5.797  24.281  17.982  1.00 45.03           N  
ATOM   1650  CA  ASP A 206      -6.969  24.387  17.096  1.00 45.17           C  
ATOM   1651  C   ASP A 206      -8.295  24.056  17.800  1.00 43.66           C  
ATOM   1652  O   ASP A 206      -8.698  22.902  17.843  1.00 43.70           O  
ATOM   1653  CB  ASP A 206      -6.822  23.463  15.877  1.00 46.21           C  
ATOM   1654  CG  ASP A 206      -7.681  23.913  14.702  1.00 50.86           C  
ATOM   1655  OD1 ASP A 206      -8.788  23.344  14.525  1.00 53.60           O  
ATOM   1656  OD2 ASP A 206      -7.254  24.854  13.963  1.00 55.53           O  
ATOM   1657  N   ALA A 207      -8.977  25.077  18.312  1.00 41.72           N  
ATOM   1658  CA  ALA A 207     -10.212  24.893  19.023  1.00 39.99           C  
ATOM   1659  C   ALA A 207     -11.248  25.937  18.567  1.00 39.15           C  
ATOM   1660  O   ALA A 207     -11.638  26.807  19.330  1.00 38.72           O  
ATOM   1661  CB  ALA A 207      -9.940  25.002  20.511  1.00 40.14           C  
ATOM   1662  N   PRO A 208     -11.722  25.843  17.316  1.00 38.57           N  
ATOM   1663  CA  PRO A 208     -12.387  27.021  16.783  1.00 38.44           C  
ATOM   1664  C   PRO A 208     -13.724  27.350  17.449  1.00 38.98           C  
ATOM   1665  O   PRO A 208     -14.250  28.441  17.232  1.00 39.80           O  
ATOM   1666  CB  PRO A 208     -12.560  26.679  15.313  1.00 38.34           C  
ATOM   1667  CG  PRO A 208     -12.647  25.212  15.297  1.00 37.78           C  
ATOM   1668  CD  PRO A 208     -11.695  24.742  16.338  1.00 37.65           C  
ATOM   1669  N   TRP A 209     -14.260  26.446  18.268  1.00 39.07           N  
ATOM   1670  CA  TRP A 209     -15.475  26.753  19.031  1.00 39.22           C  
ATOM   1671  C   TRP A 209     -15.271  27.766  20.156  1.00 40.23           C  
ATOM   1672  O   TRP A 209     -16.244  28.371  20.607  1.00 40.13           O  
ATOM   1673  CB  TRP A 209     -16.144  25.492  19.581  1.00 39.16           C  
ATOM   1674  CG  TRP A 209     -15.271  24.691  20.475  1.00 37.07           C  
ATOM   1675  CD1 TRP A 209     -15.249  24.709  21.838  1.00 34.05           C  
ATOM   1676  CD2 TRP A 209     -14.290  23.742  20.064  1.00 35.99           C  
ATOM   1677  NE1 TRP A 209     -14.303  23.834  22.304  1.00 35.41           N  
ATOM   1678  CE2 TRP A 209     -13.699  23.223  21.235  1.00 37.33           C  
ATOM   1679  CE3 TRP A 209     -13.850  23.277  18.815  1.00 36.18           C  
ATOM   1680  CZ2 TRP A 209     -12.676  22.260  21.195  1.00 36.69           C  
ATOM   1681  CZ3 TRP A 209     -12.838  22.321  18.776  1.00 36.40           C  
ATOM   1682  CH2 TRP A 209     -12.256  21.831  19.963  1.00 35.53           C  
ATOM   1683  N   MET A 210     -14.026  27.954  20.611  1.00 41.25           N  
ATOM   1684  CA  MET A 210     -13.734  28.938  21.660  1.00 42.57           C  
ATOM   1685  C   MET A 210     -13.976  30.374  21.184  1.00 42.41           C  
ATOM   1686  O   MET A 210     -13.225  30.892  20.338  1.00 43.24           O  
ATOM   1687  CB  MET A 210     -12.292  28.828  22.180  1.00 43.42           C  
ATOM   1688  CG  MET A 210     -11.912  27.551  22.932  1.00 47.04           C  
ATOM   1689  SD  MET A 210     -12.677  27.329  24.548  1.00 57.39           S  
ATOM   1690  CE  MET A 210     -13.041  29.018  25.103  1.00 54.83           C  
ATOM   1691  N   LYS A 211     -14.995  31.028  21.734  1.00 41.41           N  
ATOM   1692  CA  LYS A 211     -15.284  32.408  21.332  1.00 41.03           C  
ATOM   1693  C   LYS A 211     -14.961  33.453  22.409  1.00 40.84           C  
ATOM   1694  O   LYS A 211     -15.115  34.630  22.149  1.00 41.20           O  
ATOM   1695  CB  LYS A 211     -16.752  32.574  20.866  1.00 41.22           C  
ATOM   1696  CG  LYS A 211     -17.266  31.555  19.830  1.00 39.51           C  
ATOM   1697  CD  LYS A 211     -16.556  31.727  18.482  1.00 38.92           C  
ATOM   1698  CE  LYS A 211     -17.009  30.678  17.463  1.00 36.80           C  
ATOM   1699  NZ  LYS A 211     -15.929  30.445  16.473  1.00 38.42           N  
ATOM   1700  N   HIS A 212     -14.524  33.034  23.603  1.00 40.33           N  
ATOM   1701  CA  HIS A 212     -14.186  33.989  24.673  1.00 39.29           C  
ATOM   1702  C   HIS A 212     -12.770  33.807  25.166  1.00 39.46           C  
ATOM   1703  O   HIS A 212     -12.283  32.685  25.215  1.00 40.71           O  
ATOM   1704  CB  HIS A 212     -15.114  33.802  25.870  1.00 38.95           C  
ATOM   1705  CG  HIS A 212     -16.550  34.104  25.582  1.00 37.10           C  
ATOM   1706  ND1 HIS A 212     -17.485  33.118  25.351  1.00 36.25           N  
ATOM   1707  CD2 HIS A 212     -17.216  35.281  25.508  1.00 35.60           C  
ATOM   1708  CE1 HIS A 212     -18.666  33.679  25.142  1.00 36.99           C  
ATOM   1709  NE2 HIS A 212     -18.529  34.991  25.230  1.00 34.26           N  
ATOM   1710  N   PHE A 213     -12.105  34.890  25.557  1.00 39.35           N  
ATOM   1711  CA  PHE A 213     -10.858  34.748  26.313  1.00 39.24           C  
ATOM   1712  C   PHE A 213     -11.177  34.430  27.763  1.00 39.83           C  
ATOM   1713  O   PHE A 213     -12.186  34.898  28.301  1.00 39.97           O  
ATOM   1714  CB  PHE A 213      -9.962  35.995  26.231  1.00 38.87           C  
ATOM   1715  CG  PHE A 213     -10.589  37.250  26.772  1.00 37.90           C  
ATOM   1716  CD1 PHE A 213     -10.545  37.541  28.142  1.00 37.86           C  
ATOM   1717  CD2 PHE A 213     -11.179  38.169  25.910  1.00 35.39           C  
ATOM   1718  CE1 PHE A 213     -11.114  38.706  28.648  1.00 36.73           C  
ATOM   1719  CE2 PHE A 213     -11.740  39.340  26.402  1.00 35.56           C  
ATOM   1720  CZ  PHE A 213     -11.708  39.609  27.782  1.00 36.94           C  
ATOM   1721  N   ILE A 214     -10.328  33.625  28.386  1.00 40.51           N  
ATOM   1722  CA  ILE A 214     -10.480  33.293  29.806  1.00 41.24           C  
ATOM   1723  C   ILE A 214      -9.145  33.505  30.495  1.00 41.72           C  
ATOM   1724  O   ILE A 214      -8.180  32.787  30.216  1.00 41.26           O  
ATOM   1725  CB  ILE A 214     -10.934  31.826  30.020  1.00 41.07           C  
ATOM   1726  CG1 ILE A 214     -12.148  31.509  29.163  1.00 40.19           C  
ATOM   1727  CG2 ILE A 214     -11.236  31.563  31.515  1.00 41.79           C  
ATOM   1728  CD1 ILE A 214     -12.760  30.177  29.477  1.00 40.94           C  
ATOM   1729  N   LEU A 215      -9.092  34.506  31.370  1.00 42.95           N  
ATOM   1730  CA  LEU A 215      -7.879  34.808  32.143  1.00 44.69           C  
ATOM   1731  C   LEU A 215      -8.030  34.526  33.649  1.00 45.71           C  
ATOM   1732  O   LEU A 215      -8.906  35.088  34.314  1.00 45.65           O  
ATOM   1733  CB  LEU A 215      -7.459  36.263  31.945  1.00 44.76           C  
ATOM   1734  CG  LEU A 215      -7.185  36.870  30.576  1.00 46.52           C  
ATOM   1735  CD1 LEU A 215      -6.762  38.289  30.809  1.00 47.82           C  
ATOM   1736  CD2 LEU A 215      -6.074  36.150  29.840  1.00 49.58           C  
ATOM   1737  N   THR A 216      -7.180  33.661  34.185  1.00 47.70           N  
ATOM   1738  CA  THR A 216      -7.245  33.363  35.616  1.00 50.17           C  
ATOM   1739  C   THR A 216      -6.104  34.038  36.346  1.00 51.94           C  
ATOM   1740  O   THR A 216      -4.991  34.148  35.821  1.00 51.81           O  
ATOM   1741  CB  THR A 216      -7.208  31.856  35.932  1.00 49.81           C  
ATOM   1742  OG1 THR A 216      -5.953  31.312  35.518  1.00 49.18           O  
ATOM   1743  CG2 THR A 216      -8.342  31.124  35.236  1.00 49.44           C  
ATOM   1744  N   HIS A 217      -6.398  34.476  37.564  1.00 54.31           N  
ATOM   1745  CA  HIS A 217      -5.406  35.130  38.411  1.00 56.97           C  
ATOM   1746  C   HIS A 217      -5.177  34.456  39.773  1.00 58.56           C  
ATOM   1747  O   HIS A 217      -5.985  33.658  40.261  1.00 57.95           O  
ATOM   1748  CB  HIS A 217      -5.767  36.599  38.588  1.00 56.66           C  
ATOM   1749  CG  HIS A 217      -6.077  37.282  37.302  1.00 57.15           C  
ATOM   1750  ND1 HIS A 217      -5.120  37.953  36.571  1.00 58.00           N  
ATOM   1751  CD2 HIS A 217      -7.228  37.366  36.592  1.00 57.68           C  
ATOM   1752  CE1 HIS A 217      -5.671  38.434  35.471  1.00 57.74           C  
ATOM   1753  NE2 HIS A 217      -6.951  38.094  35.462  1.00 57.51           N  
ATOM   1754  N   ASP A 218      -4.031  34.791  40.351  1.00 61.38           N  
ATOM   1755  CA  ASP A 218      -3.608  34.311  41.650  1.00 63.84           C  
ATOM   1756  C   ASP A 218      -2.398  35.133  42.070  1.00 65.26           C  
ATOM   1757  O   ASP A 218      -1.348  35.056  41.428  1.00 65.37           O  
ATOM   1758  CB  ASP A 218      -3.234  32.835  41.587  1.00 64.18           C  
ATOM   1759  CG  ASP A 218      -3.172  32.190  42.961  1.00 65.92           C  
ATOM   1760  OD1 ASP A 218      -2.620  32.807  43.901  1.00 67.48           O  
ATOM   1761  OD2 ASP A 218      -3.672  31.050  43.095  1.00 66.96           O  
ATOM   1762  N   PRO A 219      -2.548  35.946  43.138  1.00 66.92           N  
ATOM   1763  CA  PRO A 219      -1.404  36.656  43.723  1.00 67.90           C  
ATOM   1764  C   PRO A 219      -0.380  35.695  44.353  1.00 68.79           C  
ATOM   1765  O   PRO A 219       0.822  35.992  44.340  1.00 69.12           O  
ATOM   1766  CB  PRO A 219      -2.051  37.536  44.803  1.00 68.16           C  
ATOM   1767  CG  PRO A 219      -3.355  36.859  45.134  1.00 67.84           C  
ATOM   1768  CD  PRO A 219      -3.811  36.245  43.843  1.00 67.09           C  
ATOM   1769  N   GLU A 220      -0.852  34.557  44.880  1.00 69.22           N  
ATOM   1770  CA  GLU A 220       0.031  33.536  45.480  1.00 70.04           C  
ATOM   1771  C   GLU A 220       0.951  32.886  44.449  1.00 69.50           C  
ATOM   1772  O   GLU A 220       1.683  31.956  44.781  1.00 69.68           O  
ATOM   1773  CB  GLU A 220      -0.773  32.426  46.189  1.00 70.49           C  
ATOM   1774  CG  GLU A 220      -1.804  32.902  47.218  1.00 73.05           C  
ATOM   1775  CD  GLU A 220      -1.221  33.077  48.610  1.00 75.96           C  
ATOM   1776  OE1 GLU A 220      -0.353  33.969  48.790  1.00 76.62           O  
ATOM   1777  OE2 GLU A 220      -1.648  32.325  49.525  1.00 77.08           O  
ATOM   1778  N   ARG A 221       0.908  33.372  43.210  1.00 69.09           N  
ATOM   1779  CA  ARG A 221       1.666  32.764  42.117  1.00 68.53           C  
ATOM   1780  C   ARG A 221       2.257  33.778  41.113  1.00 67.48           C  
ATOM   1781  O   ARG A 221       3.237  33.471  40.419  1.00 67.43           O  
ATOM   1782  CB  ARG A 221       0.805  31.710  41.419  1.00 68.92           C  
ATOM   1783  CG  ARG A 221       1.579  30.470  40.947  1.00 71.62           C  
ATOM   1784  CD  ARG A 221       0.691  29.222  40.814  1.00 75.46           C  
ATOM   1785  NE  ARG A 221      -0.568  29.470  40.101  1.00 79.26           N  
ATOM   1786  CZ  ARG A 221      -1.767  29.560  40.692  1.00 82.19           C  
ATOM   1787  NH1 ARG A 221      -2.858  29.785  39.961  1.00 82.87           N  
ATOM   1788  NH2 ARG A 221      -1.881  29.422  42.017  1.00 82.67           N  
ATOM   1789  N   GLY A 222       1.680  34.980  41.044  1.00 66.00           N  
ATOM   1790  CA  GLY A 222       2.232  36.047  40.203  1.00 64.06           C  
ATOM   1791  C   GLY A 222       1.429  36.321  38.944  1.00 62.66           C  
ATOM   1792  O   GLY A 222       0.609  35.502  38.538  1.00 62.43           O  
ATOM   1793  N   ILE A 223       1.683  37.479  38.330  1.00 61.28           N  
ATOM   1794  CA  ILE A 223       0.994  37.928  37.115  1.00 59.68           C  
ATOM   1795  C   ILE A 223       1.335  37.058  35.908  1.00 58.79           C  
ATOM   1796  O   ILE A 223       2.481  36.690  35.702  1.00 58.84           O  
ATOM   1797  CB  ILE A 223       1.276  39.446  36.803  1.00 59.92           C  
ATOM   1798  CG1 ILE A 223       0.390  39.974  35.660  1.00 58.86           C  
ATOM   1799  CG2 ILE A 223       2.764  39.702  36.519  1.00 59.73           C  
ATOM   1800  CD1 ILE A 223      -1.124  39.743  35.859  1.00 57.15           C  
ATOM   1801  N   TYR A 224       0.310  36.733  35.130  1.00 57.52           N  
ATOM   1802  CA  TYR A 224       0.421  35.887  33.945  1.00 56.42           C  
ATOM   1803  C   TYR A 224       1.166  34.594  34.222  1.00 55.65           C  
ATOM   1804  O   TYR A 224       1.879  34.056  33.362  1.00 55.92           O  
ATOM   1805  CB  TYR A 224       1.000  36.673  32.754  1.00 56.46           C  
ATOM   1806  CG  TYR A 224       0.147  37.872  32.393  1.00 56.26           C  
ATOM   1807  CD1 TYR A 224      -1.255  37.782  32.427  1.00 56.44           C  
ATOM   1808  CD2 TYR A 224       0.722  39.091  32.038  1.00 55.43           C  
ATOM   1809  CE1 TYR A 224      -2.060  38.859  32.116  1.00 57.03           C  
ATOM   1810  CE2 TYR A 224      -0.088  40.198  31.714  1.00 56.96           C  
ATOM   1811  CZ  TYR A 224      -1.483  40.062  31.754  1.00 57.60           C  
ATOM   1812  OH  TYR A 224      -2.315  41.120  31.452  1.00 59.68           O  
ATOM   1813  N   ASN A 225       0.989  34.093  35.437  1.00 54.24           N  
ATOM   1814  CA  ASN A 225       1.585  32.821  35.820  1.00 53.16           C  
ATOM   1815  C   ASN A 225       0.498  31.821  36.169  1.00 52.49           C  
ATOM   1816  O   ASN A 225       0.754  30.753  36.723  1.00 52.30           O  
ATOM   1817  CB  ASN A 225       2.541  33.023  36.976  1.00 53.25           C  
ATOM   1818  CG  ASN A 225       3.736  32.155  36.866  1.00 52.65           C  
ATOM   1819  OD1 ASN A 225       3.664  30.960  37.094  1.00 55.42           O  
ATOM   1820  ND2 ASN A 225       4.853  32.744  36.517  1.00 53.54           N  
ATOM   1821  N   SER A 226      -0.718  32.213  35.803  1.00 51.48           N  
ATOM   1822  CA  SER A 226      -1.943  31.480  36.019  1.00 50.59           C  
ATOM   1823  C   SER A 226      -2.543  31.178  34.616  1.00 49.75           C  
ATOM   1824  O   SER A 226      -2.384  31.986  33.700  1.00 50.48           O  
ATOM   1825  CB  SER A 226      -2.858  32.393  36.845  1.00 50.57           C  
ATOM   1826  OG  SER A 226      -3.895  31.692  37.499  1.00 50.83           O  
ATOM   1827  N   PRO A 227      -3.235  30.036  34.435  1.00 48.43           N  
ATOM   1828  CA  PRO A 227      -3.705  29.648  33.092  1.00 47.35           C  
ATOM   1829  C   PRO A 227      -4.553  30.686  32.363  1.00 46.49           C  
ATOM   1830  O   PRO A 227      -5.394  31.378  32.959  1.00 46.44           O  
ATOM   1831  CB  PRO A 227      -4.549  28.395  33.363  1.00 47.40           C  
ATOM   1832  CG  PRO A 227      -4.826  28.420  34.822  1.00 47.52           C  
ATOM   1833  CD  PRO A 227      -3.632  29.043  35.441  1.00 48.13           C  
ATOM   1834  N   TYR A 228      -4.321  30.807  31.066  1.00 45.66           N  
ATOM   1835  CA  TYR A 228      -5.186  31.658  30.241  1.00 44.96           C  
ATOM   1836  C   TYR A 228      -5.363  31.111  28.820  1.00 43.69           C  
ATOM   1837  O   TYR A 228      -4.461  30.509  28.248  1.00 43.06           O  
ATOM   1838  CB  TYR A 228      -4.720  33.126  30.243  1.00 44.83           C  
ATOM   1839  CG  TYR A 228      -3.350  33.362  29.627  1.00 46.33           C  
ATOM   1840  CD1 TYR A 228      -3.151  33.287  28.243  1.00 46.64           C  
ATOM   1841  CD2 TYR A 228      -2.256  33.679  30.419  1.00 46.99           C  
ATOM   1842  CE1 TYR A 228      -1.888  33.505  27.671  1.00 46.67           C  
ATOM   1843  CE2 TYR A 228      -0.994  33.915  29.852  1.00 47.61           C  
ATOM   1844  CZ  TYR A 228      -0.820  33.823  28.484  1.00 47.34           C  
ATOM   1845  OH  TYR A 228       0.424  34.049  27.942  1.00 48.19           O  
ATOM   1846  N   ILE A 229      -6.552  31.332  28.290  1.00 43.02           N  
ATOM   1847  CA  ILE A 229      -6.969  30.854  26.983  1.00 42.52           C  
ATOM   1848  C   ILE A 229      -7.402  32.072  26.178  1.00 42.77           C  
ATOM   1849  O   ILE A 229      -8.322  32.799  26.573  1.00 42.56           O  
ATOM   1850  CB  ILE A 229      -8.172  29.887  27.127  1.00 42.33           C  
ATOM   1851  CG1 ILE A 229      -7.760  28.640  27.937  1.00 42.49           C  
ATOM   1852  CG2 ILE A 229      -8.722  29.483  25.754  1.00 41.50           C  
ATOM   1853  CD1 ILE A 229      -8.921  27.866  28.549  1.00 41.71           C  
ATOM   1854  N   ILE A 230      -6.735  32.322  25.063  1.00 42.47           N  
ATOM   1855  CA  ILE A 230      -7.074  33.501  24.280  1.00 42.42           C  
ATOM   1856  C   ILE A 230      -7.271  33.120  22.820  1.00 42.21           C  
ATOM   1857  O   ILE A 230      -6.291  32.828  22.131  1.00 42.70           O  
ATOM   1858  CB  ILE A 230      -5.987  34.597  24.404  1.00 42.35           C  
ATOM   1859  CG1 ILE A 230      -5.801  34.989  25.868  1.00 42.78           C  
ATOM   1860  CG2 ILE A 230      -6.365  35.824  23.573  1.00 42.12           C  
ATOM   1861  CD1 ILE A 230      -4.489  35.651  26.173  1.00 44.03           C  
ATOM   1862  N   PRO A 231      -8.531  33.103  22.348  1.00 42.02           N  
ATOM   1863  CA  PRO A 231      -8.829  32.734  20.952  1.00 42.65           C  
ATOM   1864  C   PRO A 231      -8.286  33.736  19.952  1.00 43.14           C  
ATOM   1865  O   PRO A 231      -8.535  34.923  20.090  1.00 43.00           O  
ATOM   1866  CB  PRO A 231     -10.369  32.719  20.903  1.00 42.58           C  
ATOM   1867  CG  PRO A 231     -10.819  32.646  22.317  1.00 41.50           C  
ATOM   1868  CD  PRO A 231      -9.761  33.381  23.109  1.00 42.11           C  
ATOM   1869  N   GLY A 232      -7.522  33.258  18.972  1.00 44.13           N  
ATOM   1870  CA  GLY A 232      -6.979  34.116  17.920  1.00 44.81           C  
ATOM   1871  C   GLY A 232      -7.750  33.971  16.619  1.00 46.02           C  
ATOM   1872  O   GLY A 232      -8.842  33.393  16.576  1.00 46.36           O  
ATOM   1873  N   THR A 233      -7.190  34.487  15.535  1.00 46.73           N  
ATOM   1874  CA  THR A 233      -7.888  34.416  14.262  1.00 47.35           C  
ATOM   1875  C   THR A 233      -7.946  32.976  13.723  1.00 47.55           C  
ATOM   1876  O   THR A 233      -9.023  32.497  13.377  1.00 48.21           O  
ATOM   1877  CB  THR A 233      -7.330  35.410  13.206  1.00 47.17           C  
ATOM   1878  OG1 THR A 233      -8.114  35.302  12.021  1.00 49.18           O  
ATOM   1879  CG2 THR A 233      -5.863  35.118  12.830  1.00 47.38           C  
ATOM   1880  N   GLN A 234      -6.803  32.290  13.686  1.00 47.32           N  
ATOM   1881  CA  GLN A 234      -6.702  30.961  13.077  1.00 47.43           C  
ATOM   1882  C   GLN A 234      -6.515  29.840  14.111  1.00 46.51           C  
ATOM   1883  O   GLN A 234      -6.502  28.660  13.760  1.00 47.02           O  
ATOM   1884  CB  GLN A 234      -5.536  30.918  12.059  1.00 48.08           C  
ATOM   1885  CG  GLN A 234      -5.714  31.774  10.775  1.00 50.06           C  
ATOM   1886  CD  GLN A 234      -6.879  31.310   9.885  1.00 53.41           C  
ATOM   1887  OE1 GLN A 234      -7.041  30.118   9.621  1.00 56.20           O  
ATOM   1888  NE2 GLN A 234      -7.686  32.258   9.421  1.00 54.35           N  
ATOM   1889  N   THR A 235      -6.363  30.212  15.375  1.00 45.10           N  
ATOM   1890  CA  THR A 235      -5.948  29.280  16.420  1.00 43.40           C  
ATOM   1891  C   THR A 235      -6.177  29.872  17.817  1.00 41.21           C  
ATOM   1892  O   THR A 235      -6.431  31.055  17.945  1.00 40.58           O  
ATOM   1893  CB  THR A 235      -4.460  28.813  16.218  1.00 43.97           C  
ATOM   1894  OG1 THR A 235      -4.132  27.843  17.226  1.00 47.60           O  
ATOM   1895  CG2 THR A 235      -3.466  29.979  16.304  1.00 42.68           C  
ATOM   1896  N   VAL A 236      -6.134  29.039  18.852  1.00 39.43           N  
ATOM   1897  CA  VAL A 236      -6.338  29.512  20.233  1.00 38.18           C  
ATOM   1898  C   VAL A 236      -5.025  29.454  21.034  1.00 37.79           C  
ATOM   1899  O   VAL A 236      -4.294  28.440  20.983  1.00 37.57           O  
ATOM   1900  CB  VAL A 236      -7.446  28.699  20.961  1.00 38.29           C  
ATOM   1901  CG1 VAL A 236      -7.537  29.089  22.440  1.00 37.73           C  
ATOM   1902  CG2 VAL A 236      -8.814  28.868  20.279  1.00 36.46           C  
ATOM   1903  N   THR A 237      -4.715  30.542  21.743  1.00 36.58           N  
ATOM   1904  CA  THR A 237      -3.497  30.609  22.549  1.00 35.69           C  
ATOM   1905  C   THR A 237      -3.799  30.086  23.943  1.00 35.67           C  
ATOM   1906  O   THR A 237      -4.825  30.443  24.544  1.00 35.04           O  
ATOM   1907  CB  THR A 237      -2.926  32.061  22.660  1.00 35.08           C  
ATOM   1908  OG1 THR A 237      -2.554  32.525  21.373  1.00 35.14           O  
ATOM   1909  CG2 THR A 237      -1.678  32.107  23.519  1.00 34.85           C  
ATOM   1910  N   LEU A 238      -2.883  29.258  24.441  1.00 36.28           N  
ATOM   1911  CA  LEU A 238      -2.903  28.735  25.821  1.00 37.06           C  
ATOM   1912  C   LEU A 238      -1.614  29.165  26.462  1.00 37.49           C  
ATOM   1913  O   LEU A 238      -0.541  28.909  25.920  1.00 36.51           O  
ATOM   1914  CB  LEU A 238      -2.959  27.205  25.812  1.00 37.09           C  
ATOM   1915  CG  LEU A 238      -4.283  26.431  25.663  1.00 38.02           C  
ATOM   1916  CD1 LEU A 238      -5.464  27.261  25.124  1.00 37.50           C  
ATOM   1917  CD2 LEU A 238      -4.081  25.171  24.836  1.00 36.72           C  
ATOM   1918  N   GLY A 239      -1.717  29.828  27.607  1.00 39.02           N  
ATOM   1919  CA  GLY A 239      -0.542  30.296  28.345  1.00 40.73           C  
ATOM   1920  C   GLY A 239      -0.775  30.371  29.846  1.00 42.10           C  
ATOM   1921  O   GLY A 239      -1.750  29.842  30.352  1.00 42.42           O  
ATOM   1922  N   GLY A 240       0.131  31.061  30.540  1.00 43.65           N  
ATOM   1923  CA  GLY A 240       0.208  31.128  32.007  1.00 44.86           C  
ATOM   1924  C   GLY A 240       1.643  30.940  32.519  1.00 45.70           C  
ATOM   1925  O   GLY A 240       1.872  30.170  33.447  1.00 46.16           O  
ATOM   1926  N   ILE A 241       2.611  31.634  31.916  1.00 46.44           N  
ATOM   1927  CA  ILE A 241       4.033  31.485  32.282  1.00 47.42           C  
ATOM   1928  C   ILE A 241       4.784  32.818  32.315  1.00 48.16           C  
ATOM   1929  O   ILE A 241       4.975  33.465  31.274  1.00 48.23           O  
ATOM   1930  CB  ILE A 241       4.785  30.490  31.357  1.00 46.97           C  
ATOM   1931  CG1 ILE A 241       4.341  29.062  31.652  1.00 47.69           C  
ATOM   1932  CG2 ILE A 241       6.264  30.562  31.611  1.00 46.51           C  
ATOM   1933  CD1 ILE A 241       4.661  28.113  30.556  1.00 51.03           C  
ATOM   1934  N   PHE A 242       5.217  33.204  33.520  1.00 48.95           N  
ATOM   1935  CA  PHE A 242       5.970  34.436  33.750  1.00 49.00           C  
ATOM   1936  C   PHE A 242       7.158  34.170  34.661  1.00 48.71           C  
ATOM   1937  O   PHE A 242       6.990  34.102  35.884  1.00 48.23           O  
ATOM   1938  CB  PHE A 242       5.079  35.492  34.400  1.00 49.51           C  
ATOM   1939  CG  PHE A 242       5.742  36.864  34.534  1.00 52.65           C  
ATOM   1940  CD1 PHE A 242       6.775  37.085  35.463  1.00 53.81           C  
ATOM   1941  CD2 PHE A 242       5.314  37.941  33.747  1.00 54.36           C  
ATOM   1942  CE1 PHE A 242       7.383  38.345  35.582  1.00 54.99           C  
ATOM   1943  CE2 PHE A 242       5.903  39.209  33.873  1.00 54.52           C  
ATOM   1944  CZ  PHE A 242       6.945  39.409  34.789  1.00 54.72           C  
ATOM   1945  N   GLN A 243       8.354  34.054  34.078  1.00 48.31           N  
ATOM   1946  CA  GLN A 243       9.568  33.792  34.865  1.00 47.91           C  
ATOM   1947  C   GLN A 243      10.629  34.884  34.807  1.00 48.33           C  
ATOM   1948  O   GLN A 243      11.398  34.972  33.843  1.00 48.62           O  
ATOM   1949  CB  GLN A 243      10.171  32.452  34.475  1.00 47.19           C  
ATOM   1950  CG  GLN A 243       9.218  31.333  34.718  1.00 46.12           C  
ATOM   1951  CD  GLN A 243       9.504  30.136  33.858  1.00 45.94           C  
ATOM   1952  OE1 GLN A 243       8.772  29.154  33.909  1.00 46.99           O  
ATOM   1953  NE2 GLN A 243      10.562  30.204  33.051  1.00 45.69           N  
ATOM   1954  N   LEU A 244      10.680  35.698  35.863  1.00 48.77           N  
ATOM   1955  CA  LEU A 244      11.681  36.779  35.995  1.00 48.65           C  
ATOM   1956  C   LEU A 244      13.111  36.263  35.938  1.00 48.20           C  
ATOM   1957  O   LEU A 244      13.473  35.351  36.672  1.00 49.14           O  
ATOM   1958  CB  LEU A 244      11.482  37.553  37.296  1.00 48.79           C  
ATOM   1959  CG  LEU A 244      10.608  38.812  37.250  1.00 50.87           C  
ATOM   1960  CD1 LEU A 244      10.559  39.499  38.631  1.00 51.21           C  
ATOM   1961  CD2 LEU A 244      11.097  39.796  36.154  1.00 51.28           C  
ATOM   1962  N   GLY A 245      13.911  36.836  35.048  1.00 47.65           N  
ATOM   1963  CA  GLY A 245      15.330  36.529  34.969  1.00 46.68           C  
ATOM   1964  C   GLY A 245      15.716  35.339  34.114  1.00 45.88           C  
ATOM   1965  O   GLY A 245      16.893  35.082  33.932  1.00 45.80           O  
ATOM   1966  N   ASN A 246      14.744  34.601  33.595  1.00 45.04           N  
ATOM   1967  CA  ASN A 246      15.073  33.450  32.760  1.00 44.70           C  
ATOM   1968  C   ASN A 246      15.278  33.893  31.295  1.00 45.26           C  
ATOM   1969  O   ASN A 246      14.381  34.496  30.702  1.00 45.30           O  
ATOM   1970  CB  ASN A 246      13.990  32.369  32.898  1.00 44.02           C  
ATOM   1971  CG  ASN A 246      14.346  31.071  32.188  1.00 42.68           C  
ATOM   1972  OD1 ASN A 246      15.282  31.001  31.398  1.00 42.12           O  
ATOM   1973  ND2 ASN A 246      13.583  30.033  32.469  1.00 40.89           N  
ATOM   1974  N   TRP A 247      16.457  33.592  30.748  1.00 45.52           N  
ATOM   1975  CA  TRP A 247      16.911  34.026  29.423  1.00 46.12           C  
ATOM   1976  C   TRP A 247      16.965  32.877  28.451  1.00 46.64           C  
ATOM   1977  O   TRP A 247      17.553  33.006  27.374  1.00 46.81           O  
ATOM   1978  CB  TRP A 247      18.338  34.595  29.496  1.00 46.07           C  
ATOM   1979  CG  TRP A 247      18.406  36.017  29.919  1.00 47.06           C  
ATOM   1980  CD1 TRP A 247      18.800  36.496  31.135  1.00 46.41           C  
ATOM   1981  CD2 TRP A 247      18.052  37.163  29.125  1.00 48.17           C  
ATOM   1982  NE1 TRP A 247      18.702  37.875  31.154  1.00 48.15           N  
ATOM   1983  CE2 TRP A 247      18.253  38.307  29.931  1.00 47.97           C  
ATOM   1984  CE3 TRP A 247      17.573  37.330  27.808  1.00 48.05           C  
ATOM   1985  CZ2 TRP A 247      18.006  39.603  29.461  1.00 47.99           C  
ATOM   1986  CZ3 TRP A 247      17.326  38.606  27.347  1.00 47.24           C  
ATOM   1987  CH2 TRP A 247      17.542  39.730  28.173  1.00 49.36           C  
ATOM   1988  N   SER A 248      16.394  31.744  28.835  1.00 47.09           N  
ATOM   1989  CA  SER A 248      16.398  30.587  27.967  1.00 47.84           C  
ATOM   1990  C   SER A 248      15.251  30.659  26.939  1.00 48.17           C  
ATOM   1991  O   SER A 248      14.070  30.479  27.291  1.00 48.14           O  
ATOM   1992  CB  SER A 248      16.313  29.288  28.767  1.00 47.85           C  
ATOM   1993  OG  SER A 248      16.414  28.171  27.875  1.00 49.81           O  
ATOM   1994  N   GLU A 249      15.622  30.919  25.684  1.00 48.07           N  
ATOM   1995  CA  GLU A 249      14.703  30.922  24.558  1.00 48.10           C  
ATOM   1996  C   GLU A 249      14.662  29.519  23.972  1.00 47.46           C  
ATOM   1997  O   GLU A 249      15.345  29.204  23.003  1.00 47.59           O  
ATOM   1998  CB  GLU A 249      15.137  31.944  23.502  1.00 48.50           C  
ATOM   1999  CG  GLU A 249      14.160  32.119  22.330  1.00 50.40           C  
ATOM   2000  CD  GLU A 249      14.692  33.093  21.279  1.00 54.78           C  
ATOM   2001  OE1 GLU A 249      15.680  32.759  20.580  1.00 57.62           O  
ATOM   2002  OE2 GLU A 249      14.124  34.196  21.153  1.00 55.99           O  
ATOM   2003  N   LEU A 250      13.852  28.684  24.595  1.00 46.86           N  
ATOM   2004  CA  LEU A 250      13.686  27.296  24.233  1.00 46.56           C  
ATOM   2005  C   LEU A 250      12.481  26.846  24.991  1.00 46.17           C  
ATOM   2006  O   LEU A 250      12.303  27.191  26.174  1.00 46.14           O  
ATOM   2007  CB  LEU A 250      14.901  26.484  24.655  1.00 47.35           C  
ATOM   2008  CG  LEU A 250      14.906  24.965  24.762  1.00 48.35           C  
ATOM   2009  CD1 LEU A 250      14.918  24.340  23.382  1.00 50.14           C  
ATOM   2010  CD2 LEU A 250      16.163  24.558  25.530  1.00 49.90           C  
ATOM   2011  N   ASN A 251      11.628  26.111  24.292  1.00 45.89           N  
ATOM   2012  CA  ASN A 251      10.442  25.522  24.891  1.00 45.87           C  
ATOM   2013  C   ASN A 251      10.814  24.470  25.930  1.00 45.61           C  
ATOM   2014  O   ASN A 251      11.631  23.572  25.683  1.00 44.23           O  
ATOM   2015  CB  ASN A 251       9.505  24.967  23.806  1.00 45.91           C  
ATOM   2016  CG  ASN A 251       8.949  26.072  22.889  1.00 47.86           C  
ATOM   2017  OD1 ASN A 251       8.705  27.212  23.331  1.00 48.29           O  
ATOM   2018  ND2 ASN A 251       8.753  25.738  21.609  1.00 48.44           N  
ATOM   2019  N   ASN A 252      10.226  24.644  27.108  1.00 46.07           N  
ATOM   2020  CA  ASN A 252      10.412  23.774  28.263  1.00 46.63           C  
ATOM   2021  C   ASN A 252       9.205  22.821  28.422  1.00 46.94           C  
ATOM   2022  O   ASN A 252       8.050  23.279  28.553  1.00 47.06           O  
ATOM   2023  CB  ASN A 252      10.575  24.659  29.501  1.00 46.13           C  
ATOM   2024  CG  ASN A 252      11.097  23.904  30.694  1.00 47.55           C  
ATOM   2025  OD1 ASN A 252      12.307  23.736  30.865  1.00 48.65           O  
ATOM   2026  ND2 ASN A 252      10.191  23.467  31.546  1.00 49.07           N  
ATOM   2027  N   ILE A 253       9.473  21.511  28.404  1.00 47.47           N  
ATOM   2028  CA  ILE A 253       8.474  20.460  28.735  1.00 47.46           C  
ATOM   2029  C   ILE A 253       7.649  20.714  30.023  1.00 47.31           C  
ATOM   2030  O   ILE A 253       6.428  20.582  30.017  1.00 47.49           O  
ATOM   2031  CB  ILE A 253       9.140  19.064  28.772  1.00 47.81           C  
ATOM   2032  CG1 ILE A 253       9.258  18.496  27.358  1.00 48.94           C  
ATOM   2033  CG2 ILE A 253       8.380  18.089  29.676  1.00 47.70           C  
ATOM   2034  CD1 ILE A 253       7.920  17.957  26.766  1.00 51.11           C  
ATOM   2035  N   GLN A 254       8.303  21.092  31.114  1.00 46.87           N  
ATOM   2036  CA  GLN A 254       7.599  21.368  32.371  1.00 47.13           C  
ATOM   2037  C   GLN A 254       6.605  22.500  32.217  1.00 46.61           C  
ATOM   2038  O   GLN A 254       5.562  22.517  32.886  1.00 46.79           O  
ATOM   2039  CB  GLN A 254       8.595  21.731  33.502  1.00 47.67           C  
ATOM   2040  CG  GLN A 254       9.238  20.557  34.251  1.00 50.20           C  
ATOM   2041  CD  GLN A 254       9.442  19.336  33.375  1.00 53.70           C  
ATOM   2042  OE1 GLN A 254      10.349  19.291  32.524  1.00 54.08           O  
ATOM   2043  NE2 GLN A 254       8.568  18.335  33.560  1.00 55.78           N  
ATOM   2044  N   ASP A 255       6.959  23.478  31.378  1.00 45.88           N  
ATOM   2045  CA  ASP A 255       6.094  24.635  31.119  1.00 45.16           C  
ATOM   2046  C   ASP A 255       4.896  24.202  30.256  1.00 44.09           C  
ATOM   2047  O   ASP A 255       3.754  24.514  30.582  1.00 42.70           O  
ATOM   2048  CB  ASP A 255       6.897  25.811  30.502  1.00 45.24           C  
ATOM   2049  CG  ASP A 255       7.855  26.478  31.522  1.00 45.69           C  
ATOM   2050  OD1 ASP A 255       7.534  26.521  32.736  1.00 46.45           O  
ATOM   2051  OD2 ASP A 255       8.937  26.959  31.118  1.00 43.80           O  
ATOM   2052  N   HIS A 256       5.188  23.446  29.195  1.00 43.74           N  
ATOM   2053  CA  HIS A 256       4.190  22.760  28.398  1.00 44.14           C  
ATOM   2054  C   HIS A 256       3.095  22.130  29.275  1.00 44.72           C  
ATOM   2055  O   HIS A 256       1.931  22.578  29.235  1.00 44.92           O  
ATOM   2056  CB  HIS A 256       4.864  21.700  27.523  1.00 44.28           C  
ATOM   2057  CG  HIS A 256       3.916  20.992  26.604  1.00 46.33           C  
ATOM   2058  ND1 HIS A 256       3.810  21.302  25.262  1.00 47.38           N  
ATOM   2059  CD2 HIS A 256       3.001  20.018  26.840  1.00 47.32           C  
ATOM   2060  CE1 HIS A 256       2.885  20.534  24.708  1.00 48.67           C  
ATOM   2061  NE2 HIS A 256       2.374  19.752  25.645  1.00 49.08           N  
ATOM   2062  N   ASN A 257       3.477  21.130  30.089  1.00 44.59           N  
ATOM   2063  CA  ASN A 257       2.539  20.411  30.956  1.00 44.43           C  
ATOM   2064  C   ASN A 257       1.719  21.344  31.834  1.00 44.58           C  
ATOM   2065  O   ASN A 257       0.497  21.155  31.986  1.00 44.34           O  
ATOM   2066  CB  ASN A 257       3.268  19.361  31.807  1.00 44.62           C  
ATOM   2067  CG  ASN A 257       3.923  18.259  30.953  1.00 45.04           C  
ATOM   2068  OD1 ASN A 257       3.360  17.804  29.964  1.00 44.93           O  
ATOM   2069  ND2 ASN A 257       5.112  17.843  31.341  1.00 44.28           N  
ATOM   2070  N   THR A 258       2.374  22.364  32.387  1.00 44.14           N  
ATOM   2071  CA  THR A 258       1.687  23.375  33.202  1.00 44.28           C  
ATOM   2072  C   THR A 258       0.644  24.141  32.390  1.00 44.43           C  
ATOM   2073  O   THR A 258      -0.472  24.385  32.876  1.00 44.01           O  
ATOM   2074  CB  THR A 258       2.692  24.385  33.804  1.00 44.49           C  
ATOM   2075  OG1 THR A 258       3.736  23.671  34.485  1.00 44.64           O  
ATOM   2076  CG2 THR A 258       1.998  25.386  34.771  1.00 44.31           C  
ATOM   2077  N   ILE A 259       1.015  24.541  31.169  1.00 44.77           N  
ATOM   2078  CA  ILE A 259       0.081  25.252  30.284  1.00 45.24           C  
ATOM   2079  C   ILE A 259      -1.087  24.304  30.009  1.00 44.70           C  
ATOM   2080  O   ILE A 259      -2.244  24.624  30.256  1.00 42.32           O  
ATOM   2081  CB  ILE A 259       0.721  25.666  28.897  1.00 45.73           C  
ATOM   2082  CG1 ILE A 259       1.921  26.596  29.053  1.00 47.42           C  
ATOM   2083  CG2 ILE A 259      -0.319  26.319  27.978  1.00 44.56           C  
ATOM   2084  CD1 ILE A 259       1.567  27.899  29.721  1.00 53.41           C  
ATOM   2085  N   TRP A 260      -0.734  23.133  29.493  1.00 45.50           N  
ATOM   2086  CA  TRP A 260      -1.706  22.133  29.097  1.00 47.09           C  
ATOM   2087  C   TRP A 260      -2.615  21.688  30.243  1.00 47.91           C  
ATOM   2088  O   TRP A 260      -3.818  21.606  30.048  1.00 49.14           O  
ATOM   2089  CB  TRP A 260      -1.036  20.939  28.395  1.00 46.80           C  
ATOM   2090  CG  TRP A 260      -2.039  19.957  27.950  1.00 47.54           C  
ATOM   2091  CD1 TRP A 260      -2.424  18.836  28.617  1.00 48.42           C  
ATOM   2092  CD2 TRP A 260      -2.840  20.017  26.759  1.00 47.53           C  
ATOM   2093  NE1 TRP A 260      -3.407  18.181  27.918  1.00 48.12           N  
ATOM   2094  CE2 TRP A 260      -3.689  18.880  26.775  1.00 48.14           C  
ATOM   2095  CE3 TRP A 260      -2.923  20.914  25.682  1.00 46.18           C  
ATOM   2096  CZ2 TRP A 260      -4.624  18.612  25.752  1.00 48.22           C  
ATOM   2097  CZ3 TRP A 260      -3.851  20.658  24.666  1.00 48.25           C  
ATOM   2098  CH2 TRP A 260      -4.688  19.499  24.704  1.00 47.55           C  
ATOM   2099  N   GLU A 261      -2.079  21.430  31.433  1.00 48.73           N  
ATOM   2100  CA  GLU A 261      -2.951  20.966  32.532  1.00 49.75           C  
ATOM   2101  C   GLU A 261      -3.874  22.040  33.041  1.00 49.65           C  
ATOM   2102  O   GLU A 261      -5.071  21.796  33.199  1.00 50.37           O  
ATOM   2103  CB  GLU A 261      -2.185  20.347  33.711  1.00 50.16           C  
ATOM   2104  CG  GLU A 261      -2.017  18.845  33.603  1.00 53.50           C  
ATOM   2105  CD  GLU A 261      -0.664  18.429  33.028  1.00 59.16           C  
ATOM   2106  OE1 GLU A 261       0.327  18.391  33.801  1.00 61.23           O  
ATOM   2107  OE2 GLU A 261      -0.595  18.122  31.810  1.00 62.38           O  
ATOM   2108  N   GLY A 262      -3.331  23.223  33.300  1.00 49.25           N  
ATOM   2109  CA  GLY A 262      -4.134  24.308  33.849  1.00 49.00           C  
ATOM   2110  C   GLY A 262      -5.260  24.769  32.931  1.00 48.92           C  
ATOM   2111  O   GLY A 262      -6.298  25.236  33.413  1.00 48.91           O  
ATOM   2112  N   CYS A 263      -5.059  24.641  31.615  1.00 48.61           N  
ATOM   2113  CA  CYS A 263      -6.068  25.082  30.625  1.00 48.60           C  
ATOM   2114  C   CYS A 263      -7.166  24.049  30.420  1.00 49.35           C  
ATOM   2115  O   CYS A 263      -8.328  24.408  30.220  1.00 48.49           O  
ATOM   2116  CB  CYS A 263      -5.437  25.463  29.285  1.00 48.19           C  
ATOM   2117  SG  CYS A 263      -4.408  26.945  29.339  1.00 45.53           S  
ATOM   2118  N   CYS A 264      -6.797  22.773  30.503  1.00 50.54           N  
ATOM   2119  CA  CYS A 264      -7.780  21.713  30.513  1.00 52.08           C  
ATOM   2120  C   CYS A 264      -8.667  21.790  31.733  1.00 52.70           C  
ATOM   2121  O   CYS A 264      -9.884  21.668  31.625  1.00 53.11           O  
ATOM   2122  CB  CYS A 264      -7.118  20.359  30.437  1.00 52.04           C  
ATOM   2123  SG  CYS A 264      -6.615  20.051  28.794  1.00 54.61           S  
ATOM   2124  N   ARG A 265      -8.083  22.012  32.896  1.00 53.37           N  
ATOM   2125  CA  ARG A 265      -8.922  22.134  34.066  1.00 54.34           C  
ATOM   2126  C   ARG A 265      -9.922  23.231  33.796  1.00 53.79           C  
ATOM   2127  O   ARG A 265     -11.114  23.044  34.032  1.00 54.70           O  
ATOM   2128  CB  ARG A 265      -8.120  22.433  35.340  1.00 54.94           C  
ATOM   2129  CG  ARG A 265      -8.592  21.635  36.564  1.00 58.64           C  
ATOM   2130  CD  ARG A 265      -8.321  20.108  36.388  1.00 65.41           C  
ATOM   2131  NE  ARG A 265      -7.029  19.854  35.716  1.00 70.02           N  
ATOM   2132  CZ  ARG A 265      -6.327  18.721  35.785  1.00 71.98           C  
ATOM   2133  NH1 ARG A 265      -5.162  18.630  35.133  1.00 72.06           N  
ATOM   2134  NH2 ARG A 265      -6.777  17.684  36.505  1.00 72.57           N  
ATOM   2135  N   LEU A 266      -9.437  24.350  33.263  1.00 52.81           N  
ATOM   2136  CA  LEU A 266     -10.258  25.546  33.065  1.00 51.96           C  
ATOM   2137  C   LEU A 266     -11.320  25.360  31.981  1.00 51.80           C  
ATOM   2138  O   LEU A 266     -12.435  25.851  32.130  1.00 51.98           O  
ATOM   2139  CB  LEU A 266      -9.368  26.732  32.688  1.00 51.91           C  
ATOM   2140  CG  LEU A 266      -9.547  28.142  33.249  1.00 50.13           C  
ATOM   2141  CD1 LEU A 266      -9.017  29.117  32.214  1.00 48.95           C  
ATOM   2142  CD2 LEU A 266     -10.960  28.490  33.633  1.00 47.50           C  
ATOM   2143  N   GLU A 267     -10.971  24.670  30.889  1.00 51.28           N  
ATOM   2144  CA  GLU A 267     -11.918  24.389  29.809  1.00 51.03           C  
ATOM   2145  C   GLU A 267     -11.738  22.963  29.277  1.00 50.21           C  
ATOM   2146  O   GLU A 267     -10.943  22.725  28.376  1.00 49.76           O  
ATOM   2147  CB  GLU A 267     -11.773  25.425  28.692  1.00 51.22           C  
ATOM   2148  CG  GLU A 267     -12.656  25.185  27.470  1.00 54.15           C  
ATOM   2149  CD  GLU A 267     -14.042  25.782  27.606  1.00 59.11           C  
ATOM   2150  OE1 GLU A 267     -15.029  25.002  27.569  1.00 60.68           O  
ATOM   2151  OE2 GLU A 267     -14.150  27.033  27.750  1.00 61.10           O  
ATOM   2152  N   PRO A 268     -12.477  21.999  29.847  1.00 50.13           N  
ATOM   2153  CA  PRO A 268     -12.317  20.564  29.502  1.00 50.09           C  
ATOM   2154  C   PRO A 268     -12.488  20.131  28.035  1.00 50.08           C  
ATOM   2155  O   PRO A 268     -12.001  19.067  27.669  1.00 50.19           O  
ATOM   2156  CB  PRO A 268     -13.330  19.865  30.414  1.00 49.85           C  
ATOM   2157  CG  PRO A 268     -13.516  20.824  31.577  1.00 49.75           C  
ATOM   2158  CD  PRO A 268     -13.469  22.188  30.923  1.00 50.12           C  
ATOM   2159  N   THR A 269     -13.130  20.948  27.199  1.00 50.30           N  
ATOM   2160  CA  THR A 269     -13.301  20.627  25.781  1.00 50.47           C  
ATOM   2161  C   THR A 269     -11.977  20.763  25.032  1.00 50.99           C  
ATOM   2162  O   THR A 269     -11.862  20.437  23.833  1.00 50.32           O  
ATOM   2163  CB  THR A 269     -14.302  21.566  25.130  1.00 50.79           C  
ATOM   2164  OG1 THR A 269     -13.754  22.894  25.120  1.00 53.13           O  
ATOM   2165  CG2 THR A 269     -15.624  21.556  25.880  1.00 49.58           C  
ATOM   2166  N   LEU A 270     -10.971  21.249  25.760  1.00 51.51           N  
ATOM   2167  CA  LEU A 270      -9.651  21.467  25.222  1.00 51.96           C  
ATOM   2168  C   LEU A 270      -8.893  20.155  25.021  1.00 52.77           C  
ATOM   2169  O   LEU A 270      -8.011  20.075  24.180  1.00 52.35           O  
ATOM   2170  CB  LEU A 270      -8.899  22.377  26.176  1.00 52.01           C  
ATOM   2171  CG  LEU A 270      -8.361  23.728  25.702  1.00 51.41           C  
ATOM   2172  CD1 LEU A 270      -9.273  24.380  24.677  1.00 50.04           C  
ATOM   2173  CD2 LEU A 270      -8.241  24.616  26.912  1.00 49.63           C  
ATOM   2174  N   LYS A 271      -9.261  19.130  25.787  1.00 54.29           N  
ATOM   2175  CA  LYS A 271      -8.578  17.828  25.786  1.00 55.47           C  
ATOM   2176  C   LYS A 271      -8.307  17.266  24.397  1.00 55.80           C  
ATOM   2177  O   LYS A 271      -7.205  16.785  24.125  1.00 56.46           O  
ATOM   2178  CB  LYS A 271      -9.396  16.804  26.569  1.00 56.05           C  
ATOM   2179  CG  LYS A 271      -8.609  16.044  27.607  1.00 57.27           C  
ATOM   2180  CD  LYS A 271      -8.545  16.844  28.904  1.00 60.00           C  
ATOM   2181  CE  LYS A 271      -9.884  16.804  29.674  1.00 60.11           C  
ATOM   2182  NZ  LYS A 271      -9.747  17.370  31.069  1.00 62.06           N  
ATOM   2183  N   ASN A 272      -9.314  17.317  23.530  1.00 56.10           N  
ATOM   2184  CA  ASN A 272      -9.220  16.753  22.176  1.00 56.16           C  
ATOM   2185  C   ASN A 272      -8.722  17.744  21.113  1.00 55.72           C  
ATOM   2186  O   ASN A 272      -8.734  17.430  19.925  1.00 56.26           O  
ATOM   2187  CB  ASN A 272     -10.577  16.164  21.745  1.00 56.63           C  
ATOM   2188  CG  ASN A 272     -10.990  14.945  22.585  1.00 58.56           C  
ATOM   2189  OD1 ASN A 272     -10.595  13.808  22.294  1.00 60.44           O  
ATOM   2190  ND2 ASN A 272     -11.798  15.181  23.619  1.00 58.20           N  
ATOM   2191  N   ALA A 273      -8.274  18.927  21.522  1.00 54.66           N  
ATOM   2192  CA  ALA A 273      -7.826  19.924  20.554  1.00 53.99           C  
ATOM   2193  C   ALA A 273      -6.446  19.602  19.993  1.00 53.50           C  
ATOM   2194  O   ALA A 273      -5.592  19.079  20.690  1.00 53.56           O  
ATOM   2195  CB  ALA A 273      -7.862  21.327  21.159  1.00 54.00           C  
ATOM   2196  N   ARG A 274      -6.245  19.923  18.724  1.00 53.34           N  
ATOM   2197  CA  ARG A 274      -4.989  19.663  18.032  1.00 53.47           C  
ATOM   2198  C   ARG A 274      -3.961  20.782  18.306  1.00 52.35           C  
ATOM   2199  O   ARG A 274      -4.271  21.967  18.176  1.00 51.69           O  
ATOM   2200  CB  ARG A 274      -5.251  19.502  16.517  1.00 54.28           C  
ATOM   2201  CG  ARG A 274      -4.331  18.491  15.777  1.00 58.24           C  
ATOM   2202  CD  ARG A 274      -4.688  17.013  16.094  1.00 63.70           C  
ATOM   2203  NE  ARG A 274      -4.230  16.581  17.427  1.00 67.03           N  
ATOM   2204  CZ  ARG A 274      -4.775  15.600  18.151  1.00 68.39           C  
ATOM   2205  NH1 ARG A 274      -4.279  15.303  19.347  1.00 69.84           N  
ATOM   2206  NH2 ARG A 274      -5.821  14.917  17.698  1.00 69.76           N  
ATOM   2207  N   ILE A 275      -2.747  20.380  18.692  1.00 51.42           N  
ATOM   2208  CA  ILE A 275      -1.646  21.303  19.005  1.00 50.38           C  
ATOM   2209  C   ILE A 275      -0.893  21.717  17.733  1.00 49.73           C  
ATOM   2210  O   ILE A 275      -0.270  20.902  17.058  1.00 49.32           O  
ATOM   2211  CB  ILE A 275      -0.673  20.701  20.057  1.00 50.37           C  
ATOM   2212  CG1 ILE A 275      -1.430  20.424  21.368  1.00 49.91           C  
ATOM   2213  CG2 ILE A 275       0.528  21.637  20.282  1.00 50.36           C  
ATOM   2214  CD1 ILE A 275      -0.631  19.761  22.451  1.00 48.31           C  
ATOM   2215  N   ILE A 276      -0.967  22.999  17.411  1.00 48.88           N  
ATOM   2216  CA  ILE A 276      -0.431  23.481  16.159  1.00 48.12           C  
ATOM   2217  C   ILE A 276       1.034  23.793  16.363  1.00 47.42           C  
ATOM   2218  O   ILE A 276       1.875  23.345  15.583  1.00 48.13           O  
ATOM   2219  CB  ILE A 276      -1.228  24.716  15.640  1.00 48.46           C  
ATOM   2220  CG1 ILE A 276      -2.725  24.381  15.509  1.00 48.29           C  
ATOM   2221  CG2 ILE A 276      -0.668  25.249  14.300  1.00 48.79           C  
ATOM   2222  CD1 ILE A 276      -3.044  23.286  14.496  1.00 47.40           C  
ATOM   2223  N   GLY A 277       1.341  24.524  17.430  1.00 46.15           N  
ATOM   2224  CA  GLY A 277       2.699  24.998  17.665  1.00 44.75           C  
ATOM   2225  C   GLY A 277       2.886  25.529  19.070  1.00 44.29           C  
ATOM   2226  O   GLY A 277       1.921  25.622  19.843  1.00 43.96           O  
ATOM   2227  N   GLU A 278       4.136  25.881  19.386  1.00 43.25           N  
ATOM   2228  CA  GLU A 278       4.537  26.334  20.707  1.00 42.75           C  
ATOM   2229  C   GLU A 278       5.729  27.302  20.610  1.00 41.40           C  
ATOM   2230  O   GLU A 278       6.605  27.100  19.789  1.00 40.99           O  
ATOM   2231  CB  GLU A 278       4.922  25.124  21.536  1.00 43.22           C  
ATOM   2232  CG  GLU A 278       4.929  25.373  23.032  1.00 46.80           C  
ATOM   2233  CD  GLU A 278       4.807  24.077  23.839  1.00 52.01           C  
ATOM   2234  OE1 GLU A 278       4.411  24.173  25.022  1.00 52.16           O  
ATOM   2235  OE2 GLU A 278       5.103  22.977  23.289  1.00 52.54           O  
ATOM   2236  N   ARG A 279       5.766  28.336  21.446  1.00 40.10           N  
ATOM   2237  CA  ARG A 279       6.799  29.377  21.336  1.00 39.48           C  
ATOM   2238  C   ARG A 279       7.212  29.998  22.661  1.00 39.38           C  
ATOM   2239  O   ARG A 279       6.388  30.115  23.602  1.00 39.28           O  
ATOM   2240  CB  ARG A 279       6.318  30.515  20.408  1.00 39.62           C  
ATOM   2241  CG  ARG A 279       6.244  30.158  18.921  1.00 39.49           C  
ATOM   2242  CD  ARG A 279       7.638  29.954  18.318  1.00 42.20           C  
ATOM   2243  NE  ARG A 279       8.465  31.161  18.394  1.00 43.52           N  
ATOM   2244  CZ  ARG A 279       8.284  32.247  17.639  1.00 45.65           C  
ATOM   2245  NH1 ARG A 279       7.308  32.299  16.726  1.00 46.09           N  
ATOM   2246  NH2 ARG A 279       9.091  33.288  17.787  1.00 47.57           N  
ATOM   2247  N   THR A 280       8.458  30.468  22.712  1.00 39.46           N  
ATOM   2248  CA  THR A 280       8.994  31.187  23.885  1.00 40.05           C  
ATOM   2249  C   THR A 280       9.353  32.649  23.572  1.00 40.45           C  
ATOM   2250  O   THR A 280       9.848  32.940  22.480  1.00 41.02           O  
ATOM   2251  CB  THR A 280      10.243  30.471  24.425  1.00 39.74           C  
ATOM   2252  OG1 THR A 280       9.857  29.202  24.950  1.00 40.52           O  
ATOM   2253  CG2 THR A 280      10.915  31.264  25.524  1.00 40.29           C  
ATOM   2254  N   GLY A 281       9.136  33.546  24.541  1.00 40.24           N  
ATOM   2255  CA  GLY A 281       9.523  34.949  24.419  1.00 39.35           C  
ATOM   2256  C   GLY A 281       9.806  35.686  25.725  1.00 39.54           C  
ATOM   2257  O   GLY A 281       9.561  35.167  26.817  1.00 39.94           O  
ATOM   2258  N   PHE A 282      10.305  36.919  25.609  1.00 38.73           N  
ATOM   2259  CA  PHE A 282      10.746  37.673  26.763  1.00 37.67           C  
ATOM   2260  C   PHE A 282      10.045  39.000  26.885  1.00 37.64           C  
ATOM   2261  O   PHE A 282      10.312  39.917  26.105  1.00 36.86           O  
ATOM   2262  CB  PHE A 282      12.265  37.888  26.723  1.00 36.86           C  
ATOM   2263  CG  PHE A 282      13.040  36.618  26.633  1.00 37.13           C  
ATOM   2264  CD1 PHE A 282      12.977  35.672  27.651  1.00 36.84           C  
ATOM   2265  CD2 PHE A 282      13.827  36.350  25.528  1.00 38.31           C  
ATOM   2266  CE1 PHE A 282      13.691  34.485  27.568  1.00 35.70           C  
ATOM   2267  CE2 PHE A 282      14.553  35.144  25.430  1.00 39.74           C  
ATOM   2268  CZ  PHE A 282      14.479  34.210  26.459  1.00 38.50           C  
ATOM   2269  N   ARG A 283       9.181  39.115  27.894  1.00 37.62           N  
ATOM   2270  CA  ARG A 283       8.556  40.379  28.187  1.00 38.92           C  
ATOM   2271  C   ARG A 283       9.631  41.305  28.778  1.00 40.31           C  
ATOM   2272  O   ARG A 283      10.341  40.906  29.706  1.00 40.92           O  
ATOM   2273  CB  ARG A 283       7.404  40.220  29.175  1.00 38.77           C  
ATOM   2274  CG  ARG A 283       6.317  39.212  28.836  1.00 39.68           C  
ATOM   2275  CD  ARG A 283       5.495  38.914  30.106  1.00 41.20           C  
ATOM   2276  NE  ARG A 283       4.430  37.926  29.885  1.00 43.98           N  
ATOM   2277  CZ  ARG A 283       4.572  36.602  30.004  1.00 43.39           C  
ATOM   2278  NH1 ARG A 283       5.746  36.064  30.327  1.00 43.40           N  
ATOM   2279  NH2 ARG A 283       3.534  35.812  29.764  1.00 40.39           N  
ATOM   2280  N   PRO A 284       9.779  42.533  28.228  1.00 41.04           N  
ATOM   2281  CA  PRO A 284      10.719  43.499  28.791  1.00 41.36           C  
ATOM   2282  C   PRO A 284      10.161  44.129  30.059  1.00 41.59           C  
ATOM   2283  O   PRO A 284       9.553  45.210  30.007  1.00 41.30           O  
ATOM   2284  CB  PRO A 284      10.858  44.542  27.678  1.00 40.96           C  
ATOM   2285  CG  PRO A 284       9.570  44.511  26.996  1.00 41.50           C  
ATOM   2286  CD  PRO A 284       9.114  43.070  27.026  1.00 41.29           C  
ATOM   2287  N   VAL A 285      10.380  43.447  31.180  1.00 41.63           N  
ATOM   2288  CA  VAL A 285       9.873  43.892  32.463  1.00 42.30           C  
ATOM   2289  C   VAL A 285      10.691  45.043  33.017  1.00 42.70           C  
ATOM   2290  O   VAL A 285      11.920  44.969  33.089  1.00 42.53           O  
ATOM   2291  CB  VAL A 285       9.850  42.750  33.500  1.00 42.45           C  
ATOM   2292  CG1 VAL A 285       9.091  43.196  34.770  1.00 42.59           C  
ATOM   2293  CG2 VAL A 285       9.217  41.493  32.902  1.00 42.89           C  
ATOM   2294  N   ARG A 286       9.979  46.100  33.400  1.00 43.29           N  
ATOM   2295  CA  ARG A 286      10.542  47.272  34.046  1.00 44.72           C  
ATOM   2296  C   ARG A 286       9.426  47.893  34.897  1.00 45.12           C  
ATOM   2297  O   ARG A 286       8.268  47.858  34.503  1.00 44.61           O  
ATOM   2298  CB  ARG A 286      11.054  48.278  33.000  1.00 45.00           C  
ATOM   2299  CG  ARG A 286      12.507  48.673  33.223  1.00 46.62           C  
ATOM   2300  CD  ARG A 286      12.985  49.856  32.402  1.00 45.56           C  
ATOM   2301  NE  ARG A 286      12.361  51.083  32.862  1.00 44.96           N  
ATOM   2302  CZ  ARG A 286      12.996  52.230  33.073  1.00 43.41           C  
ATOM   2303  NH1 ARG A 286      14.304  52.324  32.880  1.00 40.98           N  
ATOM   2304  NH2 ARG A 286      12.301  53.283  33.485  1.00 43.03           N  
ATOM   2305  N   PRO A 287       9.767  48.442  36.081  1.00 46.07           N  
ATOM   2306  CA  PRO A 287       8.752  49.019  36.992  1.00 46.47           C  
ATOM   2307  C   PRO A 287       7.890  50.025  36.255  1.00 46.94           C  
ATOM   2308  O   PRO A 287       6.734  50.239  36.603  1.00 47.15           O  
ATOM   2309  CB  PRO A 287       9.593  49.744  38.055  1.00 46.51           C  
ATOM   2310  CG  PRO A 287      10.897  49.059  38.041  1.00 46.32           C  
ATOM   2311  CD  PRO A 287      11.126  48.524  36.640  1.00 45.99           C  
ATOM   2312  N   GLN A 288       8.474  50.646  35.240  1.00 47.47           N  
ATOM   2313  CA  GLN A 288       7.734  51.474  34.319  1.00 47.98           C  
ATOM   2314  C   GLN A 288       8.546  51.615  33.041  1.00 47.91           C  
ATOM   2315  O   GLN A 288       9.780  51.434  33.038  1.00 47.64           O  
ATOM   2316  CB  GLN A 288       7.465  52.840  34.930  1.00 48.83           C  
ATOM   2317  CG  GLN A 288       8.684  53.773  34.977  1.00 50.55           C  
ATOM   2318  CD  GLN A 288       8.469  54.915  35.933  1.00 54.02           C  
ATOM   2319  OE1 GLN A 288       8.261  56.053  35.521  1.00 55.07           O  
ATOM   2320  NE2 GLN A 288       8.484  54.612  37.231  1.00 56.97           N  
ATOM   2321  N   ILE A 289       7.840  51.962  31.968  1.00 47.17           N  
ATOM   2322  CA  ILE A 289       8.426  52.090  30.649  1.00 46.61           C  
ATOM   2323  C   ILE A 289       9.393  53.257  30.689  1.00 46.44           C  
ATOM   2324  O   ILE A 289       9.103  54.276  31.325  1.00 45.69           O  
ATOM   2325  CB  ILE A 289       7.327  52.349  29.578  1.00 46.70           C  
ATOM   2326  CG1 ILE A 289       6.295  51.206  29.580  1.00 47.70           C  
ATOM   2327  CG2 ILE A 289       7.949  52.544  28.202  1.00 45.75           C  
ATOM   2328  CD1 ILE A 289       5.002  51.495  28.849  1.00 48.36           C  
ATOM   2329  N   ARG A 290      10.540  53.080  30.034  1.00 46.16           N  
ATOM   2330  CA  ARG A 290      11.470  54.160  29.798  1.00 46.76           C  
ATOM   2331  C   ARG A 290      11.155  54.802  28.452  1.00 47.37           C  
ATOM   2332  O   ARG A 290      11.444  54.229  27.383  1.00 46.51           O  
ATOM   2333  CB  ARG A 290      12.926  53.677  29.820  1.00 46.98           C  
ATOM   2334  CG  ARG A 290      13.930  54.842  29.867  1.00 46.28           C  
ATOM   2335  CD  ARG A 290      15.355  54.363  29.890  1.00 44.58           C  
ATOM   2336  NE  ARG A 290      16.332  55.449  29.885  1.00 40.59           N  
ATOM   2337  CZ  ARG A 290      17.604  55.287  29.525  1.00 42.24           C  
ATOM   2338  NH1 ARG A 290      18.055  54.089  29.130  1.00 38.80           N  
ATOM   2339  NH2 ARG A 290      18.437  56.325  29.547  1.00 42.37           N  
ATOM   2340  N   LEU A 291      10.548  55.984  28.527  1.00 47.97           N  
ATOM   2341  CA  LEU A 291      10.150  56.723  27.342  1.00 49.24           C  
ATOM   2342  C   LEU A 291      10.537  58.160  27.541  1.00 49.41           C  
ATOM   2343  O   LEU A 291       9.752  58.971  28.009  1.00 49.06           O  
ATOM   2344  CB  LEU A 291       8.645  56.578  27.037  1.00 49.33           C  
ATOM   2345  CG  LEU A 291       8.122  57.159  25.702  1.00 49.67           C  
ATOM   2346  CD1 LEU A 291       8.993  56.810  24.507  1.00 48.66           C  
ATOM   2347  CD2 LEU A 291       6.699  56.698  25.447  1.00 51.13           C  
ATOM   2348  N   GLU A 292      11.777  58.458  27.183  1.00 50.56           N  
ATOM   2349  CA  GLU A 292      12.402  59.697  27.605  1.00 51.55           C  
ATOM   2350  C   GLU A 292      13.508  60.070  26.642  1.00 51.84           C  
ATOM   2351  O   GLU A 292      14.004  59.237  25.896  1.00 50.60           O  
ATOM   2352  CB  GLU A 292      12.920  59.582  29.062  1.00 51.38           C  
ATOM   2353  CG  GLU A 292      13.862  58.378  29.315  1.00 53.17           C  
ATOM   2354  CD  GLU A 292      14.266  58.169  30.794  1.00 55.21           C  
ATOM   2355  OE1 GLU A 292      13.460  58.447  31.725  1.00 55.06           O  
ATOM   2356  OE2 GLU A 292      15.403  57.688  31.020  1.00 57.33           O  
ATOM   2357  N   ARG A 293      13.874  61.346  26.668  1.00 53.76           N  
ATOM   2358  CA  ARG A 293      14.955  61.863  25.838  1.00 55.52           C  
ATOM   2359  C   ARG A 293      16.270  61.735  26.580  1.00 56.57           C  
ATOM   2360  O   ARG A 293      16.286  61.707  27.806  1.00 56.50           O  
ATOM   2361  CB  ARG A 293      14.696  63.323  25.477  1.00 55.58           C  
ATOM   2362  CG  ARG A 293      13.591  63.544  24.429  1.00 56.05           C  
ATOM   2363  CD  ARG A 293      13.448  65.035  24.085  1.00 56.78           C  
ATOM   2364  NE  ARG A 293      14.740  65.644  23.736  1.00 56.36           N  
ATOM   2365  CZ  ARG A 293      14.952  66.948  23.564  1.00 54.83           C  
ATOM   2366  NH1 ARG A 293      13.957  67.813  23.700  1.00 54.77           N  
ATOM   2367  NH2 ARG A 293      16.166  67.384  23.259  1.00 53.09           N  
ATOM   2368  N   GLU A 294      17.362  61.624  25.828  1.00 58.40           N  
ATOM   2369  CA  GLU A 294      18.720  61.628  26.377  1.00 60.49           C  
ATOM   2370  C   GLU A 294      19.664  62.247  25.352  1.00 62.13           C  
ATOM   2371  O   GLU A 294      19.375  62.207  24.151  1.00 62.64           O  
ATOM   2372  CB  GLU A 294      19.180  60.216  26.751  1.00 59.75           C  
ATOM   2373  CG  GLU A 294      20.681  60.090  26.991  1.00 60.75           C  
ATOM   2374  CD  GLU A 294      21.078  58.906  27.881  1.00 62.15           C  
ATOM   2375  OE1 GLU A 294      22.266  58.804  28.248  1.00 62.16           O  
ATOM   2376  OE2 GLU A 294      20.216  58.075  28.217  1.00 62.65           O  
ATOM   2377  N   GLN A 295      20.767  62.833  25.828  1.00 63.87           N  
ATOM   2378  CA  GLN A 295      21.832  63.346  24.964  1.00 65.82           C  
ATOM   2379  C   GLN A 295      23.041  62.450  25.096  1.00 66.92           C  
ATOM   2380  O   GLN A 295      23.568  62.271  26.186  1.00 67.53           O  
ATOM   2381  CB  GLN A 295      22.257  64.761  25.365  1.00 65.93           C  
ATOM   2382  CG  GLN A 295      21.206  65.569  26.083  1.00 67.62           C  
ATOM   2383  CD  GLN A 295      20.253  66.229  25.131  1.00 68.97           C  
ATOM   2384  OE1 GLN A 295      20.651  67.083  24.340  1.00 70.15           O  
ATOM   2385  NE2 GLN A 295      18.982  65.848  25.203  1.00 69.16           N  
ATOM   2386  N   LEU A 296      23.485  61.891  23.987  1.00 68.54           N  
ATOM   2387  CA  LEU A 296      24.677  61.080  23.980  1.00 70.37           C  
ATOM   2388  C   LEU A 296      25.874  61.992  23.709  1.00 71.29           C  
ATOM   2389  O   LEU A 296      25.873  62.724  22.722  1.00 71.29           O  
ATOM   2390  CB  LEU A 296      24.549  60.020  22.894  1.00 70.71           C  
ATOM   2391  CG  LEU A 296      25.318  58.711  23.094  1.00 72.57           C  
ATOM   2392  CD1 LEU A 296      24.560  57.743  24.030  1.00 72.70           C  
ATOM   2393  CD2 LEU A 296      25.570  58.072  21.721  1.00 73.92           C  
ATOM   2394  N   ARG A 297      26.883  61.960  24.585  1.00 72.55           N  
ATOM   2395  CA  ARG A 297      28.054  62.853  24.460  1.00 73.55           C  
ATOM   2396  C   ARG A 297      29.101  62.309  23.484  1.00 73.61           C  
ATOM   2397  O   ARG A 297      30.278  62.197  23.816  1.00 73.84           O  
ATOM   2398  CB  ARG A 297      28.697  63.103  25.833  1.00 73.95           C  
ATOM   2399  CG  ARG A 297      28.248  64.383  26.573  1.00 75.45           C  
ATOM   2400  CD  ARG A 297      26.896  64.268  27.305  1.00 77.93           C  
ATOM   2401  NE  ARG A 297      26.521  62.895  27.678  1.00 80.86           N  
ATOM   2402  CZ  ARG A 297      27.023  62.197  28.701  1.00 81.47           C  
ATOM   2403  NH1 ARG A 297      26.584  60.963  28.931  1.00 81.21           N  
ATOM   2404  NH2 ARG A 297      27.964  62.714  29.484  1.00 81.42           N  
ATOM   2405  N   THR A 298      28.659  61.987  22.276  1.00 73.86           N  
ATOM   2406  CA  THR A 298      29.502  61.351  21.264  1.00 73.89           C  
ATOM   2407  C   THR A 298      30.211  62.389  20.387  1.00 73.73           C  
ATOM   2408  O   THR A 298      29.609  62.972  19.475  1.00 74.06           O  
ATOM   2409  CB  THR A 298      28.674  60.348  20.386  1.00 74.05           C  
ATOM   2410  OG1 THR A 298      29.531  59.680  19.442  1.00 74.57           O  
ATOM   2411  CG2 THR A 298      27.515  61.067  19.649  1.00 73.71           C  
ATOM   2412  N   GLY A 299      31.489  62.621  20.669  1.00 73.30           N  
ATOM   2413  CA  GLY A 299      32.294  63.523  19.840  1.00 72.82           C  
ATOM   2414  C   GLY A 299      32.008  65.006  20.049  1.00 72.12           C  
ATOM   2415  O   GLY A 299      31.615  65.412  21.149  1.00 72.14           O  
ATOM   2416  N   PRO A 300      32.178  65.815  18.982  1.00 71.66           N  
ATOM   2417  CA  PRO A 300      32.122  67.293  19.060  1.00 71.48           C  
ATOM   2418  C   PRO A 300      30.740  67.805  19.500  1.00 71.21           C  
ATOM   2419  O   PRO A 300      30.621  68.565  20.467  1.00 71.40           O  
ATOM   2420  CB  PRO A 300      32.438  67.738  17.618  1.00 71.39           C  
ATOM   2421  CG  PRO A 300      32.104  66.549  16.757  1.00 71.09           C  
ATOM   2422  CD  PRO A 300      32.409  65.342  17.602  1.00 71.54           C  
ATOM   2423  N   SER A 301      29.717  67.364  18.778  1.00 70.49           N  
ATOM   2424  CA  SER A 301      28.337  67.679  19.065  1.00 69.78           C  
ATOM   2425  C   SER A 301      27.664  66.384  19.497  1.00 69.05           C  
ATOM   2426  O   SER A 301      27.953  65.308  18.959  1.00 68.87           O  
ATOM   2427  CB  SER A 301      27.655  68.228  17.809  1.00 69.91           C  
ATOM   2428  OG  SER A 301      28.096  67.530  16.651  1.00 69.83           O  
ATOM   2429  N   ASN A 302      26.774  66.483  20.474  1.00 67.88           N  
ATOM   2430  CA  ASN A 302      26.091  65.301  20.947  1.00 66.78           C  
ATOM   2431  C   ASN A 302      24.879  64.946  20.085  1.00 65.35           C  
ATOM   2432  O   ASN A 302      24.254  65.824  19.496  1.00 65.36           O  
ATOM   2433  CB  ASN A 302      25.758  65.409  22.448  1.00 67.36           C  
ATOM   2434  CG  ASN A 302      25.249  66.778  22.851  1.00 67.93           C  
ATOM   2435  OD1 ASN A 302      24.846  67.576  21.999  1.00 70.15           O  
ATOM   2436  ND2 ASN A 302      25.248  67.051  24.160  1.00 66.52           N  
ATOM   2437  N   THR A 303      24.583  63.652  19.983  1.00 63.39           N  
ATOM   2438  CA  THR A 303      23.401  63.189  19.255  1.00 61.57           C  
ATOM   2439  C   THR A 303      22.223  62.868  20.181  1.00 60.07           C  
ATOM   2440  O   THR A 303      22.400  62.430  21.321  1.00 59.19           O  
ATOM   2441  CB  THR A 303      23.710  61.978  18.320  1.00 61.83           C  
ATOM   2442  OG1 THR A 303      24.215  60.884  19.091  1.00 62.04           O  
ATOM   2443  CG2 THR A 303      24.732  62.364  17.232  1.00 61.65           C  
ATOM   2444  N   GLU A 304      21.016  63.093  19.670  1.00 58.46           N  
ATOM   2445  CA  GLU A 304      19.796  62.875  20.436  1.00 57.03           C  
ATOM   2446  C   GLU A 304      19.406  61.409  20.448  1.00 55.78           C  
ATOM   2447  O   GLU A 304      19.685  60.670  19.504  1.00 55.98           O  
ATOM   2448  CB  GLU A 304      18.643  63.682  19.841  1.00 57.31           C  
ATOM   2449  CG  GLU A 304      18.922  65.144  19.674  1.00 58.08           C  
ATOM   2450  CD  GLU A 304      19.173  65.828  20.991  1.00 60.07           C  
ATOM   2451  OE1 GLU A 304      18.278  65.778  21.868  1.00 61.58           O  
ATOM   2452  OE2 GLU A 304      20.265  66.416  21.142  1.00 60.82           O  
ATOM   2453  N   VAL A 305      18.736  60.998  21.515  1.00 54.36           N  
ATOM   2454  CA  VAL A 305      18.264  59.625  21.667  1.00 52.50           C  
ATOM   2455  C   VAL A 305      16.865  59.608  22.300  1.00 51.79           C  
ATOM   2456  O   VAL A 305      16.657  60.182  23.382  1.00 51.57           O  
ATOM   2457  CB  VAL A 305      19.238  58.774  22.510  1.00 52.44           C  
ATOM   2458  CG1 VAL A 305      18.669  57.360  22.758  1.00 51.38           C  
ATOM   2459  CG2 VAL A 305      20.591  58.689  21.825  1.00 51.74           C  
ATOM   2460  N   ILE A 306      15.909  58.975  21.611  1.00 50.32           N  
ATOM   2461  CA  ILE A 306      14.597  58.741  22.198  1.00 49.46           C  
ATOM   2462  C   ILE A 306      14.473  57.277  22.654  1.00 49.10           C  
ATOM   2463  O   ILE A 306      14.440  56.372  21.823  1.00 49.79           O  
ATOM   2464  CB  ILE A 306      13.437  59.168  21.257  1.00 49.04           C  
ATOM   2465  CG1 ILE A 306      13.716  60.556  20.661  1.00 48.52           C  
ATOM   2466  CG2 ILE A 306      12.110  59.140  22.011  1.00 49.42           C  
ATOM   2467  CD1 ILE A 306      12.574  61.190  19.894  1.00 47.15           C  
ATOM   2468  N   HIS A 307      14.450  57.054  23.972  1.00 48.49           N  
ATOM   2469  CA  HIS A 307      14.280  55.698  24.546  1.00 48.13           C  
ATOM   2470  C   HIS A 307      12.809  55.323  24.637  1.00 47.63           C  
ATOM   2471  O   HIS A 307      12.009  56.084  25.198  1.00 46.86           O  
ATOM   2472  CB  HIS A 307      14.903  55.583  25.947  1.00 48.00           C  
ATOM   2473  CG  HIS A 307      16.388  55.416  25.940  1.00 48.31           C  
ATOM   2474  ND1 HIS A 307      17.254  56.423  26.314  1.00 49.75           N  
ATOM   2475  CD2 HIS A 307      17.163  54.363  25.594  1.00 49.34           C  
ATOM   2476  CE1 HIS A 307      18.500  56.000  26.197  1.00 48.91           C  
ATOM   2477  NE2 HIS A 307      18.473  54.756  25.751  1.00 50.37           N  
ATOM   2478  N   ASN A 308      12.468  54.158  24.085  1.00 47.27           N  
ATOM   2479  CA  ASN A 308      11.115  53.614  24.165  1.00 47.28           C  
ATOM   2480  C   ASN A 308      11.183  52.104  24.311  1.00 47.19           C  
ATOM   2481  O   ASN A 308      11.138  51.379  23.320  1.00 47.39           O  
ATOM   2482  CB  ASN A 308      10.304  54.005  22.932  1.00 47.62           C  
ATOM   2483  CG  ASN A 308       8.814  53.702  23.070  1.00 48.98           C  
ATOM   2484  OD1 ASN A 308       8.290  53.503  24.168  1.00 51.89           O  
ATOM   2485  ND2 ASN A 308       8.119  53.711  21.946  1.00 49.52           N  
ATOM   2486  N   TYR A 309      11.329  51.638  25.551  1.00 46.91           N  
ATOM   2487  CA  TYR A 309      11.386  50.200  25.858  1.00 46.57           C  
ATOM   2488  C   TYR A 309      10.918  49.903  27.300  1.00 46.15           C  
ATOM   2489  O   TYR A 309      10.768  50.830  28.117  1.00 46.34           O  
ATOM   2490  CB  TYR A 309      12.782  49.650  25.623  1.00 46.61           C  
ATOM   2491  CG  TYR A 309      13.792  50.181  26.603  1.00 48.93           C  
ATOM   2492  CD1 TYR A 309      13.978  49.559  27.839  1.00 50.72           C  
ATOM   2493  CD2 TYR A 309      14.552  51.317  26.312  1.00 49.61           C  
ATOM   2494  CE1 TYR A 309      14.896  50.038  28.750  1.00 51.78           C  
ATOM   2495  CE2 TYR A 309      15.476  51.808  27.224  1.00 50.77           C  
ATOM   2496  CZ  TYR A 309      15.643  51.158  28.440  1.00 51.60           C  
ATOM   2497  OH  TYR A 309      16.556  51.617  29.360  1.00 53.33           O  
ATOM   2498  N   GLY A 310      10.678  48.619  27.592  1.00 45.13           N  
ATOM   2499  CA  GLY A 310      10.192  48.179  28.890  1.00 44.23           C  
ATOM   2500  C   GLY A 310       8.679  48.118  28.970  1.00 44.62           C  
ATOM   2501  O   GLY A 310       8.060  48.642  29.915  1.00 44.68           O  
ATOM   2502  N   HIS A 311       8.062  47.464  27.987  1.00 44.06           N  
ATOM   2503  CA  HIS A 311       6.607  47.461  27.924  1.00 43.36           C  
ATOM   2504  C   HIS A 311       5.979  46.237  28.585  1.00 43.31           C  
ATOM   2505  O   HIS A 311       4.738  46.128  28.666  1.00 43.81           O  
ATOM   2506  CB  HIS A 311       6.136  47.681  26.484  1.00 43.05           C  
ATOM   2507  CG  HIS A 311       6.567  49.002  25.921  1.00 42.24           C  
ATOM   2508  ND1 HIS A 311       7.864  49.256  25.536  1.00 41.09           N  
ATOM   2509  CD2 HIS A 311       5.883  50.155  25.729  1.00 42.88           C  
ATOM   2510  CE1 HIS A 311       7.955  50.498  25.097  1.00 42.61           C  
ATOM   2511  NE2 HIS A 311       6.765  51.062  25.200  1.00 44.57           N  
ATOM   2512  N   GLY A 312       6.829  45.348  29.098  1.00 42.49           N  
ATOM   2513  CA  GLY A 312       6.367  44.254  29.948  1.00 41.76           C  
ATOM   2514  C   GLY A 312       5.517  43.303  29.150  1.00 41.48           C  
ATOM   2515  O   GLY A 312       5.888  42.921  28.047  1.00 41.97           O  
ATOM   2516  N   GLY A 313       4.375  42.924  29.697  1.00 41.19           N  
ATOM   2517  CA  GLY A 313       3.459  42.058  28.986  1.00 41.22           C  
ATOM   2518  C   GLY A 313       2.255  42.810  28.462  1.00 41.92           C  
ATOM   2519  O   GLY A 313       1.176  42.230  28.345  1.00 42.75           O  
ATOM   2520  N   TYR A 314       2.426  44.096  28.147  1.00 41.29           N  
ATOM   2521  CA  TYR A 314       1.332  44.914  27.668  1.00 41.00           C  
ATOM   2522  C   TYR A 314       1.780  45.881  26.566  1.00 40.39           C  
ATOM   2523  O   TYR A 314       1.227  46.972  26.422  1.00 40.01           O  
ATOM   2524  CB  TYR A 314       0.618  45.648  28.831  1.00 41.83           C  
ATOM   2525  CG  TYR A 314       1.520  46.558  29.665  1.00 44.11           C  
ATOM   2526  CD1 TYR A 314       2.151  46.079  30.815  1.00 46.80           C  
ATOM   2527  CD2 TYR A 314       1.744  47.882  29.294  1.00 44.01           C  
ATOM   2528  CE1 TYR A 314       3.003  46.898  31.576  1.00 48.57           C  
ATOM   2529  CE2 TYR A 314       2.578  48.705  30.032  1.00 47.42           C  
ATOM   2530  CZ  TYR A 314       3.210  48.208  31.186  1.00 49.59           C  
ATOM   2531  OH  TYR A 314       4.048  49.027  31.941  1.00 50.84           O  
ATOM   2532  N   GLY A 315       2.769  45.470  25.782  1.00 39.36           N  
ATOM   2533  CA  GLY A 315       3.246  46.277  24.675  1.00 39.03           C  
ATOM   2534  C   GLY A 315       2.246  46.548  23.551  1.00 39.75           C  
ATOM   2535  O   GLY A 315       2.209  47.662  23.001  1.00 39.64           O  
ATOM   2536  N   LEU A 316       1.449  45.543  23.167  1.00 39.49           N  
ATOM   2537  CA  LEU A 316       0.477  45.756  22.104  1.00 39.01           C  
ATOM   2538  C   LEU A 316      -0.626  46.637  22.657  1.00 39.16           C  
ATOM   2539  O   LEU A 316      -1.166  47.479  21.944  1.00 39.51           O  
ATOM   2540  CB  LEU A 316      -0.075  44.439  21.546  1.00 38.66           C  
ATOM   2541  CG  LEU A 316       0.786  43.611  20.575  1.00 38.90           C  
ATOM   2542  CD1 LEU A 316       1.151  44.341  19.308  1.00 39.44           C  
ATOM   2543  CD2 LEU A 316       2.054  43.193  21.242  1.00 44.23           C  
ATOM   2544  N   THR A 317      -0.930  46.450  23.935  1.00 38.78           N  
ATOM   2545  CA  THR A 317      -1.967  47.192  24.613  1.00 39.24           C  
ATOM   2546  C   THR A 317      -1.695  48.688  24.638  1.00 39.54           C  
ATOM   2547  O   THR A 317      -2.626  49.493  24.625  1.00 39.75           O  
ATOM   2548  CB  THR A 317      -2.091  46.692  26.064  1.00 39.38           C  
ATOM   2549  OG1 THR A 317      -2.658  45.372  26.066  1.00 40.05           O  
ATOM   2550  CG2 THR A 317      -2.941  47.652  26.930  1.00 37.81           C  
ATOM   2551  N   ILE A 318      -0.411  49.049  24.691  1.00 39.90           N  
ATOM   2552  CA  ILE A 318       0.009  50.422  24.931  1.00 39.76           C  
ATOM   2553  C   ILE A 318       0.790  51.061  23.767  1.00 40.44           C  
ATOM   2554  O   ILE A 318       1.045  52.271  23.773  1.00 40.84           O  
ATOM   2555  CB  ILE A 318       0.818  50.515  26.266  1.00 39.36           C  
ATOM   2556  CG1 ILE A 318       0.514  51.854  26.969  1.00 40.24           C  
ATOM   2557  CG2 ILE A 318       2.301  50.258  26.026  1.00 37.17           C  
ATOM   2558  CD1 ILE A 318       0.996  51.975  28.400  1.00 37.49           C  
ATOM   2559  N   HIS A 319       1.137  50.252  22.768  1.00 40.51           N  
ATOM   2560  CA  HIS A 319       2.089  50.640  21.736  1.00 41.75           C  
ATOM   2561  C   HIS A 319       1.798  51.980  21.059  1.00 42.65           C  
ATOM   2562  O   HIS A 319       2.720  52.732  20.745  1.00 43.04           O  
ATOM   2563  CB  HIS A 319       2.233  49.537  20.668  1.00 41.51           C  
ATOM   2564  CG  HIS A 319       1.102  49.516  19.689  1.00 40.43           C  
ATOM   2565  ND1 HIS A 319       1.120  50.248  18.517  1.00 38.34           N  
ATOM   2566  CD2 HIS A 319      -0.109  48.915  19.740  1.00 38.05           C  
ATOM   2567  CE1 HIS A 319      -0.026  50.086  17.882  1.00 36.77           C  
ATOM   2568  NE2 HIS A 319      -0.781  49.271  18.593  1.00 38.74           N  
ATOM   2569  N   TRP A 320       0.527  52.265  20.819  1.00 44.03           N  
ATOM   2570  CA  TRP A 320       0.158  53.436  20.024  1.00 45.88           C  
ATOM   2571  C   TRP A 320       0.380  54.740  20.795  1.00 46.66           C  
ATOM   2572  O   TRP A 320       0.871  55.724  20.218  1.00 46.65           O  
ATOM   2573  CB  TRP A 320      -1.287  53.343  19.498  1.00 46.09           C  
ATOM   2574  CG  TRP A 320      -1.678  54.489  18.590  1.00 47.67           C  
ATOM   2575  CD1 TRP A 320      -2.617  55.463  18.842  1.00 48.66           C  
ATOM   2576  CD2 TRP A 320      -1.132  54.788  17.303  1.00 49.54           C  
ATOM   2577  NE1 TRP A 320      -2.689  56.344  17.789  1.00 50.07           N  
ATOM   2578  CE2 TRP A 320      -1.783  55.958  16.832  1.00 51.84           C  
ATOM   2579  CE3 TRP A 320      -0.148  54.194  16.506  1.00 51.29           C  
ATOM   2580  CZ2 TRP A 320      -1.486  56.533  15.588  1.00 54.46           C  
ATOM   2581  CZ3 TRP A 320       0.157  54.766  15.276  1.00 54.30           C  
ATOM   2582  CH2 TRP A 320      -0.517  55.921  14.822  1.00 55.82           C  
ATOM   2583  N   GLY A 321       0.028  54.739  22.084  1.00 46.57           N  
ATOM   2584  CA  GLY A 321       0.212  55.920  22.926  1.00 46.74           C  
ATOM   2585  C   GLY A 321       1.686  56.234  23.113  1.00 47.15           C  
ATOM   2586  O   GLY A 321       2.105  57.399  23.091  1.00 47.09           O  
ATOM   2587  N   CYS A 322       2.484  55.186  23.272  1.00 47.50           N  
ATOM   2588  CA  CYS A 322       3.930  55.346  23.369  1.00 47.92           C  
ATOM   2589  C   CYS A 322       4.512  56.010  22.129  1.00 47.51           C  
ATOM   2590  O   CYS A 322       5.369  56.879  22.237  1.00 47.72           O  
ATOM   2591  CB  CYS A 322       4.591  54.001  23.615  1.00 47.75           C  
ATOM   2592  SG  CYS A 322       4.253  53.408  25.270  1.00 51.56           S  
ATOM   2593  N   ALA A 323       4.025  55.601  20.960  1.00 47.22           N  
ATOM   2594  CA  ALA A 323       4.568  56.051  19.694  1.00 46.80           C  
ATOM   2595  C   ALA A 323       4.186  57.505  19.473  1.00 46.76           C  
ATOM   2596  O   ALA A 323       4.935  58.251  18.857  1.00 46.44           O  
ATOM   2597  CB  ALA A 323       4.062  55.181  18.564  1.00 46.64           C  
ATOM   2598  N   LEU A 324       3.032  57.910  19.998  1.00 46.78           N  
ATOM   2599  CA  LEU A 324       2.615  59.306  19.918  1.00 47.06           C  
ATOM   2600  C   LEU A 324       3.495  60.197  20.803  1.00 47.11           C  
ATOM   2601  O   LEU A 324       3.908  61.290  20.388  1.00 46.65           O  
ATOM   2602  CB  LEU A 324       1.141  59.454  20.272  1.00 47.18           C  
ATOM   2603  CG  LEU A 324       0.114  58.919  19.260  1.00 47.98           C  
ATOM   2604  CD1 LEU A 324      -1.303  59.058  19.815  1.00 46.41           C  
ATOM   2605  CD2 LEU A 324       0.246  59.604  17.884  1.00 47.81           C  
ATOM   2606  N   GLU A 325       3.807  59.694  21.997  1.00 47.62           N  
ATOM   2607  CA  GLU A 325       4.680  60.376  22.950  1.00 48.25           C  
ATOM   2608  C   GLU A 325       6.104  60.512  22.424  1.00 48.12           C  
ATOM   2609  O   GLU A 325       6.680  61.595  22.472  1.00 48.47           O  
ATOM   2610  CB  GLU A 325       4.667  59.635  24.281  1.00 48.93           C  
ATOM   2611  CG  GLU A 325       5.641  60.155  25.321  1.00 51.49           C  
ATOM   2612  CD  GLU A 325       5.367  61.581  25.729  1.00 54.82           C  
ATOM   2613  OE1 GLU A 325       4.184  61.983  25.756  1.00 56.72           O  
ATOM   2614  OE2 GLU A 325       6.348  62.295  26.033  1.00 56.57           O  
ATOM   2615  N   ALA A 326       6.666  59.423  21.904  1.00 47.62           N  
ATOM   2616  CA  ALA A 326       7.963  59.472  21.259  1.00 47.24           C  
ATOM   2617  C   ALA A 326       7.974  60.534  20.168  1.00 47.30           C  
ATOM   2618  O   ALA A 326       8.876  61.358  20.118  1.00 46.97           O  
ATOM   2619  CB  ALA A 326       8.294  58.130  20.664  1.00 47.13           C  
ATOM   2620  N   ALA A 327       6.979  60.498  19.286  1.00 47.67           N  
ATOM   2621  CA  ALA A 327       6.864  61.472  18.212  1.00 48.45           C  
ATOM   2622  C   ALA A 327       6.846  62.895  18.767  1.00 49.44           C  
ATOM   2623  O   ALA A 327       7.527  63.773  18.237  1.00 49.10           O  
ATOM   2624  CB  ALA A 327       5.637  61.211  17.391  1.00 48.08           C  
ATOM   2625  N   LYS A 328       6.081  63.111  19.844  1.00 50.44           N  
ATOM   2626  CA  LYS A 328       6.034  64.404  20.524  1.00 51.45           C  
ATOM   2627  C   LYS A 328       7.433  64.828  20.989  1.00 51.77           C  
ATOM   2628  O   LYS A 328       7.872  65.964  20.747  1.00 52.27           O  
ATOM   2629  CB  LYS A 328       5.071  64.347  21.693  1.00 51.86           C  
ATOM   2630  CG  LYS A 328       5.029  65.610  22.527  1.00 55.09           C  
ATOM   2631  CD  LYS A 328       4.132  65.441  23.769  1.00 60.05           C  
ATOM   2632  CE  LYS A 328       2.715  64.920  23.420  1.00 62.16           C  
ATOM   2633  NZ  LYS A 328       1.960  65.822  22.500  1.00 63.82           N  
ATOM   2634  N   LEU A 329       8.140  63.912  21.631  1.00 51.28           N  
ATOM   2635  CA  LEU A 329       9.519  64.156  21.976  1.00 51.51           C  
ATOM   2636  C   LEU A 329      10.388  64.412  20.753  1.00 51.69           C  
ATOM   2637  O   LEU A 329      11.356  65.169  20.834  1.00 51.97           O  
ATOM   2638  CB  LEU A 329      10.088  63.005  22.813  1.00 51.30           C  
ATOM   2639  CG  LEU A 329       9.477  62.858  24.215  1.00 50.89           C  
ATOM   2640  CD1 LEU A 329      10.095  61.689  24.972  1.00 49.12           C  
ATOM   2641  CD2 LEU A 329       9.626  64.158  25.000  1.00 50.09           C  
ATOM   2642  N   PHE A 330      10.055  63.794  19.625  1.00 51.93           N  
ATOM   2643  CA  PHE A 330      10.789  64.065  18.382  1.00 52.32           C  
ATOM   2644  C   PHE A 330      10.569  65.529  17.932  1.00 53.21           C  
ATOM   2645  O   PHE A 330      11.486  66.188  17.461  1.00 53.06           O  
ATOM   2646  CB  PHE A 330      10.409  63.071  17.274  1.00 51.63           C  
ATOM   2647  CG  PHE A 330      11.221  63.220  16.027  1.00 49.90           C  
ATOM   2648  CD1 PHE A 330      12.416  62.547  15.882  1.00 48.37           C  
ATOM   2649  CD2 PHE A 330      10.801  64.053  15.002  1.00 48.44           C  
ATOM   2650  CE1 PHE A 330      13.186  62.689  14.718  1.00 48.29           C  
ATOM   2651  CE2 PHE A 330      11.561  64.207  13.841  1.00 46.70           C  
ATOM   2652  CZ  PHE A 330      12.753  63.520  13.694  1.00 46.55           C  
ATOM   2653  N   GLY A 331       9.355  66.031  18.116  1.00 54.53           N  
ATOM   2654  CA  GLY A 331       9.029  67.412  17.808  1.00 56.61           C  
ATOM   2655  C   GLY A 331       9.773  68.433  18.644  1.00 58.27           C  
ATOM   2656  O   GLY A 331      10.158  69.481  18.118  1.00 58.54           O  
ATOM   2657  N   ARG A 332       9.977  68.127  19.933  1.00 59.68           N  
ATOM   2658  CA  ARG A 332      10.647  69.037  20.875  1.00 61.21           C  
ATOM   2659  C   ARG A 332      12.097  69.189  20.502  1.00 61.63           C  
ATOM   2660  O   ARG A 332      12.679  70.249  20.693  1.00 61.85           O  
ATOM   2661  CB  ARG A 332      10.563  68.550  22.332  1.00 61.68           C  
ATOM   2662  CG  ARG A 332       9.203  68.068  22.805  1.00 63.83           C  
ATOM   2663  CD  ARG A 332       8.076  69.092  22.562  1.00 68.35           C  
ATOM   2664  NE  ARG A 332       7.693  69.812  23.778  1.00 71.15           N  
ATOM   2665  CZ  ARG A 332       7.148  69.243  24.857  1.00 72.26           C  
ATOM   2666  NH1 ARG A 332       6.930  67.924  24.896  1.00 72.66           N  
ATOM   2667  NH2 ARG A 332       6.834  69.994  25.908  1.00 71.69           N  
ATOM   2668  N   ILE A 333      12.671  68.110  19.978  1.00 62.48           N  
ATOM   2669  CA  ILE A 333      14.019  68.130  19.420  1.00 63.06           C  
ATOM   2670  C   ILE A 333      14.088  69.109  18.259  1.00 64.41           C  
ATOM   2671  O   ILE A 333      15.042  69.888  18.165  1.00 64.13           O  
ATOM   2672  CB  ILE A 333      14.486  66.725  18.940  1.00 62.39           C  
ATOM   2673  CG1 ILE A 333      14.617  65.768  20.129  1.00 61.15           C  
ATOM   2674  CG2 ILE A 333      15.812  66.823  18.157  1.00 61.76           C  
ATOM   2675  CD1 ILE A 333      14.965  64.351  19.765  1.00 58.76           C  
ATOM   2676  N   LEU A 334      13.079  69.068  17.389  1.00 66.12           N  
ATOM   2677  CA  LEU A 334      13.124  69.828  16.138  1.00 68.38           C  
ATOM   2678  C   LEU A 334      13.193  71.336  16.379  1.00 69.66           C  
ATOM   2679  O   LEU A 334      14.049  72.023  15.809  1.00 69.54           O  
ATOM   2680  CB  LEU A 334      11.956  69.472  15.204  1.00 68.39           C  
ATOM   2681  CG  LEU A 334      11.975  68.134  14.445  1.00 68.85           C  
ATOM   2682  CD1 LEU A 334      10.732  68.007  13.599  1.00 69.05           C  
ATOM   2683  CD2 LEU A 334      13.213  67.959  13.575  1.00 68.25           C  
ATOM   2684  N   GLU A 335      12.303  71.826  17.241  1.00 71.40           N  
ATOM   2685  CA  GLU A 335      12.224  73.248  17.547  1.00 73.22           C  
ATOM   2686  C   GLU A 335      13.488  73.778  18.220  1.00 73.91           C  
ATOM   2687  O   GLU A 335      13.964  74.874  17.890  1.00 74.15           O  
ATOM   2688  CB  GLU A 335      10.979  73.559  18.383  1.00 73.48           C  
ATOM   2689  CG  GLU A 335      10.652  72.557  19.459  1.00 75.25           C  
ATOM   2690  CD  GLU A 335       9.664  73.112  20.475  1.00 78.44           C  
ATOM   2691  OE1 GLU A 335       9.984  74.151  21.107  1.00 79.40           O  
ATOM   2692  OE2 GLU A 335       8.574  72.508  20.648  1.00 80.01           O  
ATOM   2693  N   GLU A 336      14.025  72.987  19.147  1.00 74.92           N  
ATOM   2694  CA  GLU A 336      15.291  73.290  19.810  1.00 75.72           C  
ATOM   2695  C   GLU A 336      16.461  73.345  18.827  1.00 76.50           C  
ATOM   2696  O   GLU A 336      17.314  74.227  18.930  1.00 76.93           O  
ATOM   2697  CB  GLU A 336      15.570  72.277  20.913  1.00 75.53           C  
ATOM   2698  CG  GLU A 336      14.667  72.417  22.141  1.00 75.82           C  
ATOM   2699  CD  GLU A 336      14.908  71.324  23.174  1.00 75.14           C  
ATOM   2700  OE1 GLU A 336      15.819  70.487  22.956  1.00 75.36           O  
ATOM   2701  OE2 GLU A 336      14.191  71.303  24.205  1.00 75.38           O  
ATOM   2702  N   LYS A 337      16.492  72.418  17.870  1.00 77.31           N  
ATOM   2703  CA  LYS A 337      17.496  72.432  16.802  1.00 78.08           C  
ATOM   2704  C   LYS A 337      17.162  73.501  15.763  1.00 78.71           C  
ATOM   2705  O   LYS A 337      17.822  73.596  14.725  1.00 78.64           O  
ATOM   2706  CB  LYS A 337      17.582  71.060  16.132  1.00 78.11           C  
ATOM   2707  CG  LYS A 337      18.988  70.629  15.745  1.00 78.67           C  
ATOM   2708  CD  LYS A 337      19.055  69.107  15.614  1.00 80.16           C  
ATOM   2709  CE  LYS A 337      20.484  68.565  15.716  1.00 80.70           C  
ATOM   2710  NZ  LYS A 337      21.089  68.770  17.067  1.00 80.50           N  
ATOM   2711  N   LYS A 338      16.136  74.303  16.063  1.00 79.68           N  
ATOM   2712  CA  LYS A 338      15.645  75.382  15.197  1.00 80.64           C  
ATOM   2713  C   LYS A 338      15.289  74.882  13.776  1.00 81.14           C  
ATOM   2714  O   LYS A 338      15.861  75.341  12.776  1.00 81.20           O  
ATOM   2715  CB  LYS A 338      16.628  76.572  15.185  1.00 80.80           C  
ATOM   2716  CG  LYS A 338      16.813  77.244  16.564  1.00 81.39           C  
ATOM   2717  CD  LYS A 338      17.808  78.427  16.543  1.00 81.50           C  
ATOM   2718  CE  LYS A 338      19.262  77.982  16.307  1.00 81.21           C  
ATOM   2719  NZ  LYS A 338      19.716  76.930  17.264  1.00 80.00           N  
ATOM   2720  N   LEU A 339      14.344  73.937  13.718  1.00 81.60           N  
ATOM   2721  CA  LEU A 339      13.925  73.264  12.474  1.00 82.01           C  
ATOM   2722  C   LEU A 339      12.408  73.020  12.379  1.00 82.17           C  
ATOM   2723  O   LEU A 339      11.949  72.298  11.483  1.00 82.21           O  
ATOM   2724  CB  LEU A 339      14.678  71.931  12.290  1.00 82.05           C  
ATOM   2725  CG  LEU A 339      15.874  71.813  11.324  1.00 82.90           C  
ATOM   2726  CD1 LEU A 339      17.079  72.690  11.711  1.00 82.88           C  
ATOM   2727  CD2 LEU A 339      16.312  70.352  11.211  1.00 83.41           C  
ATOM   2728  N   SER A 340      11.635  73.616  13.296  1.00 82.38           N  
ATOM   2729  CA  SER A 340      10.169  73.456  13.289  1.00 82.42           C  
ATOM   2730  C   SER A 340       9.459  74.726  12.805  1.00 82.34           C  
ATOM   2731  O   SER A 340       8.928  74.728  11.672  1.00 82.33           O  
ATOM   2732  CB  SER A 340       9.638  73.037  14.674  1.00 82.45           C  
ATOM   2733  OG  SER A 340       9.596  74.135  15.584  1.00 82.65           O  
TER    2734      SER A 340                                                      
END
MOLECULE T0490.pdb
ATOM      1  N   THR     3      26.547  61.762   4.288  1.00 30.83           N  
ATOM      2  CA  THR     3      25.686  62.760   4.970  1.00 30.86           C  
ATOM      3  CB  THR     3      24.743  63.446   3.956  1.00 31.28           C  
ATOM      4  OG1 THR     3      23.857  62.472   3.394  1.00 33.76           O  
ATOM      5  CG2 THR     3      25.545  64.077   2.829  1.00 32.39           C  
ATOM      6  C   THR     3      24.875  62.112   6.108  1.00 29.87           C  
ATOM      7  O   THR     3      24.664  60.894   6.139  1.00 30.04      A    O  
ATOM      8  N   ASP     4      24.420  62.918   7.058  1.00 28.40      A    N  
ATOM      9  CA  ASP     4      23.613  62.360   8.116  1.00 26.82      A    C  
ATOM     10  CB  ASP     4      23.315  63.426   9.167  1.00 27.09      A    C  
ATOM     11  CG  ASP     4      24.568  63.956   9.804  1.00 27.99      A    C  
ATOM     12  OD1 ASP     4      25.591  63.256   9.689  1.00 27.47      A    O  
ATOM     13  OD2 ASP     4      24.539  65.052  10.415  1.00 27.69      A    O  
ATOM     14  C   ASP     4      22.302  61.824   7.536  1.00 25.43      A    C  
ATOM     15  O   ASP     4      21.692  62.460   6.668  1.00 25.65      A    O  
ATOM     16  N   ILE     5      21.883  60.651   7.993  1.00 22.86      A    N  
ATOM     17  CA  ILE     5      20.492  60.264   7.862  1.00 20.85      A    C  
ATOM     18  CB  ILE     5      20.306  58.784   8.160  1.00 21.43      A    C  
ATOM     19  CG1 ILE     5      21.076  57.962   7.130  1.00 21.60      A    C  
ATOM     20  CD1 ILE     5      21.089  56.510   7.429  1.00 24.74      A    C  
ATOM     21  CG2 ILE     5      18.821  58.422   8.197  1.00 20.64      A    C  
ATOM     22  C   ILE     5      19.787  61.060   8.943  1.00 19.56      A    C  
ATOM     23  O   ILE     5      20.360  61.305   9.993  1.00 19.01      A    O  
ATOM     24  N   ASP     6      18.561  61.493   8.697  1.00 17.68      A    N  
ATOM     25  CA  ASP     6      17.886  62.313   9.686  1.00 16.70      A    C  
ATOM     26  CB  ASP     6      16.604  62.919   9.115  1.00 17.32      A    C  
ATOM     27  CG  ASP     6      15.998  63.962  10.033  1.00 19.64      A    C  
ATOM     28  OD1 ASP     6      16.705  64.927  10.417  1.00 24.36      A    O  
ATOM     29  OD2 ASP     6      14.808  63.830  10.357  1.00 23.29      A    O  
ATOM     30  C   ASP     6      17.603  61.482  10.948  1.00 15.36      A    C  
ATOM     31  O   ASP     6      18.145  61.771  12.016  1.00 15.11      A    O  
ATOM     32  N   CYS     7      16.783  60.442  10.808  1.00 13.88      A    N  
ATOM     33  CA  CYS     7      16.381  59.596  11.951  1.00 13.17      A    C  
ATOM     34  CB  CYS     7      14.860  59.633  12.129  1.00 13.41      A    C  
ATOM     35  SG  CYS     7      14.137  61.228  12.616  1.00 16.56      A    S  
ATOM     36  C   CYS     7      16.756  58.134  11.726  1.00 12.09      A    C  
ATOM     37  O   CYS     7      16.460  57.589  10.666  1.00 12.24      A    O  
ATOM     38  N   ILE     8      17.398  57.503  12.711  1.00 10.67      A    N  
ATOM     39  CA  ILE     8      17.606  56.048  12.667  1.00  8.90      A    C  
ATOM     40  CB  ILE     8      19.105  55.697  12.732  1.00  9.01      A    C  
ATOM     41  CG1 ILE     8      19.794  56.208  11.453  1.00  9.20      A    C  
ATOM     42  CD1 ILE     8      21.275  55.875  11.355  1.00  9.32      A    C  
ATOM     43  CG2 ILE     8      19.326  54.187  12.879  1.00  8.23      A    C  
ATOM     44  C   ILE     8      16.821  55.421  13.821  1.00  8.24      A    C  
ATOM     45  O   ILE     8      16.911  55.882  14.954  1.00  9.14      A    O  
ATOM     46  N   VAL     9      16.027  54.403  13.517  1.00  8.44      A    N  
ATOM     47  CA  VAL     9      15.312  53.637  14.533  1.00  8.39      A    C  
ATOM     48  CB  VAL     9      13.837  53.445  14.168  1.00  9.16      A    C  
ATOM     49  CG1 VAL     9      13.112  52.551  15.201  1.00  8.57      A    C  
ATOM     50  CG2 VAL     9      13.157  54.814  14.075  1.00 10.05      A    C  
ATOM     51  C   VAL     9      15.979  52.270  14.583  1.00  8.12      A    C  
ATOM     52  O   VAL     9      16.114  51.620  13.546  1.00  8.73      A    O  
ATOM     53  N   ILE    10      16.414  51.866  15.771  1.00  7.97      A    N  
ATOM     54  CA  ILE    10      16.989  50.533  15.970  1.00  7.82      A    C  
ATOM     55  CB  ILE    10      18.113  50.529  17.022  1.00  7.94      A    C  
ATOM     56  CG1 ILE    10      19.161  51.610  16.720  1.00  7.84      A    C  
ATOM     57  CD1 ILE    10      19.863  51.460  15.338  1.00  7.30      A    C  
ATOM     58  CG2 ILE    10      18.748  49.133  17.093  1.00  8.58      A    C  
ATOM     59  C   ILE    10      15.903  49.556  16.437  1.00  7.58      A    C  
ATOM     60  O   ILE    10      15.336  49.713  17.523  1.00  7.74      A    O  
ATOM     61  N   GLY    11      15.625  48.558  15.613  1.00  7.35      A    N  
ATOM     62  CA  GLY    11      14.606  47.553  15.893  1.00  8.11      A    C  
ATOM     63  C   GLY    11      13.362  47.716  15.036  1.00  9.10      A    C  
ATOM     64  O   GLY    11      12.773  48.817  14.973  1.00  9.00      A    O  
ATOM     65  N   ALA    12      12.956  46.614  14.403  1.00  8.90      A    N  
ATOM     66  CA  ALA    12      11.758  46.579  13.569  1.00  8.90      A    C  
ATOM     67  CB  ALA    12      12.082  46.117  12.142  1.00  9.90      A    C  
ATOM     68  C   ALA    12      10.692  45.694  14.182  1.00  8.86      A    C  
ATOM     69  O   ALA    12       9.985  44.978  13.475  1.00  9.63      A    O  
ATOM     70  N   GLY    13      10.574  45.748  15.504  1.00  8.06      A    N  
ATOM     71  CA  GLY    13       9.417  45.172  16.161  1.00  7.81      A    C  
ATOM     72  C   GLY    13       8.215  46.092  16.025  1.00  8.37      A    C  
ATOM     73  O   GLY    13       8.281  47.120  15.348  1.00  8.18      A    O  
ATOM     74  N   VAL    14       7.115  45.726  16.671  1.00  8.40      A    N  
ATOM     75  CA  VAL    14       5.877  46.483  16.459  1.00  9.52      A    C  
ATOM     76  CB  VAL    14       4.647  45.799  17.117  1.00  9.86      A    C  
ATOM     77  CG1 VAL    14       4.414  44.410  16.512  1.00 12.57      A    C  
ATOM     78  CG2 VAL    14       4.782  45.739  18.645  1.00 10.08      A    C  
ATOM     79  C   VAL    14       6.022  47.925  16.935  1.00 10.04      A    C  
ATOM     80  O   VAL    14       5.447  48.863  16.341  1.00 10.04      A    O  
ATOM     81  N   VAL    15       6.785  48.101  18.012  1.00  9.60      A    N  
ATOM     82  CA  VAL    15       7.004  49.416  18.599  1.00  9.62      A    C  
ATOM     83  CB  VAL    15       7.469  49.304  20.083  1.00  9.21      A    C  
ATOM     84  CG1 VAL    15       7.758  50.667  20.637  1.00 11.32      A    C  
ATOM     85  CG2 VAL    15       6.403  48.606  20.926  1.00 10.95      A    C  
ATOM     86  C   VAL    15       7.987  50.241  17.773  1.00  9.54      A    C  
ATOM     87  O   VAL    15       7.739  51.404  17.481  1.00  9.33      A    O  
ATOM     88  N   GLY    16       9.116  49.647  17.386  1.00  9.32      A    N  
ATOM     89  CA  GLY    16      10.039  50.332  16.493  1.00  9.59      A    C  
ATOM     90  C   GLY    16       9.346  50.773  15.215  1.00  9.25      A    C  
ATOM     91  O   GLY    16       9.593  51.880  14.705  1.00  9.62      A    O  
ATOM     92  N   LEU    17       8.508  49.896  14.661  1.00  9.19      A    N  
ATOM     93  CA  LEU    17       7.808  50.214  13.417  1.00  9.11      A    C  
ATOM     94  CB  LEU    17       7.173  48.974  12.782  1.00  9.20      A    C  
ATOM     95  CG  LEU    17       8.167  47.975  12.167  1.00 10.80      A    C  
ATOM     96  CD1 LEU    17       7.497  46.667  11.777  1.00 12.92      A    C  
ATOM     97  CD2 LEU    17       8.900  48.605  10.984  1.00 13.27      A    C  
ATOM     98  C   LEU    17       6.765  51.313  13.615  1.00  9.25      A    C  
ATOM     99  O   LEU    17       6.627  52.185  12.752  1.00  9.50      A    O  
ATOM    100  N   ALA    18       6.044  51.281  14.733  1.00  8.68      A    N  
ATOM    101  CA  ALA    18       5.076  52.366  15.005  1.00  8.79      A    C  
ATOM    102  CB  ALA    18       4.306  52.119  16.285  1.00  8.59      A    C  
ATOM    103  C   ALA    18       5.797  53.708  15.076  1.00  9.13      A    C  
ATOM    104  O   ALA    18       5.309  54.716  14.585  1.00  9.58      A    O  
ATOM    105  N   ILE    19       6.962  53.724  15.714  1.00  8.73      A    N  
ATOM    106  CA  ILE    19       7.751  54.945  15.795  1.00  9.02      A    C  
ATOM    107  CB  ILE    19       8.926  54.770  16.785  1.00  8.31      A    C  
ATOM    108  CG1 ILE    19       8.387  54.535  18.208  1.00  8.79      A    C  
ATOM    109  CD1 ILE    19       9.436  53.989  19.182  1.00  8.74      A    C  
ATOM    110  CG2 ILE    19       9.870  55.980  16.722  1.00  8.49      A    C  
ATOM    111  C   ILE    19       8.283  55.405  14.433  1.00  8.99      A    C  
ATOM    112  O   ILE    19       8.202  56.591  14.106  1.00  9.86      A    O  
ATOM    113  N   ALA    20       8.825  54.478  13.641  1.00  9.69      A    N  
ATOM    114  CA  ALA    20       9.303  54.808  12.295  1.00 10.16      A    C  
ATOM    115  CB  ALA    20       9.826  53.564  11.598  1.00 10.60      A    C  
ATOM    116  C   ALA    20       8.146  55.403  11.487  1.00 10.95      A    C  
ATOM    117  O   ALA    20       8.307  56.412  10.795  1.00 12.16      A    O  
ATOM    118  N   ARG    21       6.989  54.763  11.580  1.00 10.83      A    N  
ATOM    119  CA  ARG    21       5.778  55.252  10.926  1.00 11.56      A    C  
ATOM    120  CB  ARG    21       4.606  54.300  11.199  1.00 10.87      A    C  
ATOM    121  CG  ARG    21       3.228  54.819  10.767  1.00 13.06      A    C  
ATOM    122  CD  ARG    21       2.157  53.773  11.067  1.00 13.28      A    C  
ATOM    123  NE  ARG    21       0.846  54.186  10.573  1.00 14.54      A    N  
ATOM    124  CZ  ARG    21       0.054  55.051  11.190  1.00 16.67      A    C  
ATOM    125  NH1 ARG    21       0.435  55.614  12.331  1.00 17.57      A    N  
ATOM    126  NH2 ARG    21      -1.126  55.365  10.653  1.00 16.89      A    N  
ATOM    127  C   ARG    21       5.448  56.697  11.329  1.00 11.67      A    C  
ATOM    128  O   ARG    21       5.183  57.543  10.456  1.00 12.36      A    O  
ATOM    129  N   ALA    22       5.460  56.983  12.631  1.00 12.00      A    N  
ATOM    130  CA  ALA    22       5.177  58.338  13.121  1.00 12.31      A    C  
ATOM    131  CB  ALA    22       5.071  58.339  14.617  1.00 12.63      A    C  
ATOM    132  C   ALA    22       6.227  59.361  12.649  1.00 13.41      A    C  
ATOM    133  O   ALA    22       5.882  60.457  12.175  1.00 13.54      A    O  
ATOM    134  N   LEU    23       7.504  59.011  12.786  1.00 13.21      A    N  
ATOM    135  CA  LEU    23       8.567  59.890  12.307  1.00 13.66      A    C  
ATOM    136  CB  LEU    23       9.949  59.314  12.635  1.00 13.40      A    C  
ATOM    137  CG  LEU    23      10.337  59.315  14.116  1.00 12.88      A    C  
ATOM    138  CD1 LEU    23      11.577  58.449  14.320  1.00 12.59      A    C  
ATOM    139  CD2 LEU    23      10.563  60.741  14.646  1.00 12.46      A    C  
ATOM    140  C   LEU    23       8.444  60.169  10.803  1.00 14.15      A    C  
ATOM    141  O   LEU    23       8.563  61.325  10.364  1.00 15.00      A    O  
ATOM    142  N   ALA    24       8.181  59.140  10.012  1.00 14.11      A    N  
ATOM    143  CA  ALA    24       8.135  59.318   8.565  1.00 14.56      A    C  
ATOM    144  CB  ALA    24       8.095  57.977   7.855  1.00 14.78      A    C  
ATOM    145  C   ALA    24       6.921  60.177   8.190  1.00 15.33      A    C  
ATOM    146  O   ALA    24       7.010  61.038   7.309  1.00 15.33      A    O  
ATOM    147  N   ALA    25       5.807  59.961   8.884  1.00 15.07      A    N  
ATOM    148  CA  ALA    25       4.586  60.736   8.636  1.00 15.64      A    C  
ATOM    149  CB  ALA    25       3.403  60.147   9.414  1.00 15.31      A    C  
ATOM    150  C   ALA    25       4.798  62.204   8.994  1.00 16.35      A    C  
ATOM    151  O   ALA    25       4.101  63.093   8.478  1.00 17.36      A    O  
ATOM    152  N   GLY    26       5.761  62.466   9.870  1.00 16.03      A    N  
ATOM    153  CA  GLY    26       6.092  63.834  10.270  1.00 17.08      A    C  
ATOM    154  C   GLY    26       7.062  64.494   9.305  1.00 17.67      A    C  
ATOM    155  O   GLY    26       7.528  65.605   9.554  1.00 18.13      A    O  
ATOM    156  N   GLY    27       7.380  63.800   8.214  1.00 17.65      A    N  
ATOM    157  CA  GLY    27       8.239  64.358   7.159  1.00 18.53      A    C  
ATOM    158  C   GLY    27       9.727  64.060   7.277  1.00 18.76      A    C  
ATOM    159  O   GLY    27      10.549  64.617   6.533  1.00 19.47      A    O  
ATOM    160  N   HIS    28      10.090  63.180   8.203  1.00 17.87      A    N  
ATOM    161  CA  HIS    28      11.503  62.880   8.442  1.00 17.67      A    C  
ATOM    162  CB  HIS    28      11.738  62.632   9.932  1.00 17.58      A    C  
ATOM    163  CG  HIS    28      11.363  63.797  10.788  1.00 19.97      A    C  
ATOM    164  ND1 HIS    28      12.159  64.917  10.907  1.00 21.82      A    N  
ATOM    165  CE1 HIS    28      11.565  65.792  11.698  1.00 22.25      A    C  
ATOM    166  NE2 HIS    28      10.411  65.282  12.092  1.00 23.06      A    N  
ATOM    167  CD2 HIS    28      10.257  64.038  11.533  1.00 19.91      A    C  
ATOM    168  C   HIS    28      11.987  61.688   7.643  1.00 16.83      A    C  
ATOM    169  O   HIS    28      11.272  60.712   7.498  1.00 17.40      A    O  
ATOM    170  N   GLU    29      13.212  61.773   7.130  1.00 15.93      A    N  
ATOM    171  CA  GLU    29      13.850  60.630   6.492  1.00 15.15      A    C  
ATOM    172  CB  GLU    29      15.151  61.067   5.819  1.00 14.89      A    C  
ATOM    173  CG  GLU    29      16.082  59.945   5.429  1.00 16.89      A    C  
ATOM    174  CD  GLU    29      17.484  60.441   5.095  1.00 19.01      A    C  
ATOM    175  OE1 GLU    29      17.990  61.372   5.763  1.00 19.10      A    O  
ATOM    176  OE2 GLU    29      18.076  59.895   4.146  1.00 22.56      A    O  
ATOM    177  C   GLU    29      14.141  59.630   7.600  1.00 13.93      A    C  
ATOM    178  O   GLU    29      14.684  60.003   8.626  1.00 13.78      A    O  
ATOM    179  N   VAL    30      13.751  58.379   7.396  1.00 14.02      A    N  
ATOM    180  CA  VAL    30      13.918  57.353   8.423  1.00 13.80      A    C  
ATOM    181  CB  VAL    30      12.555  56.933   9.059  1.00 13.96      A    C  
ATOM    182  CG1 VAL    30      12.774  55.824  10.061  1.00 15.38      A    C  
ATOM    183  CG2 VAL    30      11.896  58.121   9.750  1.00 13.74      A    C  
ATOM    184  C   VAL    30      14.603  56.112   7.866  1.00 13.21      A    C  
ATOM    185  O   VAL    30      14.210  55.588   6.819  1.00 13.14      A    O  
ATOM    186  N   LEU    31      15.638  55.652   8.564  1.00 12.24      A    N  
ATOM    187  CA  LEU    31      16.211  54.336   8.290  1.00 11.94      A    C  
ATOM    188  CB  LEU    31      17.712  54.442   8.031  1.00 12.23      A    C  
ATOM    189  CG  LEU    31      18.406  53.094   7.757  1.00 13.44      A    C  
ATOM    190  CD1 LEU    31      17.915  52.455   6.462  1.00 14.49      A    C  
ATOM    191  CD2 LEU    31      19.935  53.264   7.747  1.00 15.66      A    C  
ATOM    192  C   LEU    31      15.982  53.457   9.513  1.00 11.02      A    C  
ATOM    193  O   LEU    31      16.349  53.834  10.607  1.00 11.03      A    O  
ATOM    194  N   VAL    32      15.350  52.309   9.321  1.00 10.82      A    N  
ATOM    195  CA  VAL    32      15.185  51.346  10.408  1.00 10.63      A    C  
ATOM    196  CB  VAL    32      13.792  50.708  10.395  1.00 11.15      A    C  
ATOM    197  CG1 VAL    32      13.662  49.752  11.568  1.00 11.21      A    C  
ATOM    198  CG2 VAL    32      12.716  51.788  10.455  1.00 11.23      A    C  
ATOM    199  C   VAL    32      16.201  50.221  10.253  1.00 10.43      A    C  
ATOM    200  O   VAL    32      16.208  49.525   9.238  1.00 10.08      A    O  
ATOM    201  N   ALA    33      17.040  50.034  11.267  1.00  9.72      A    N  
ATOM    202  CA  ALA    33      18.043  48.965  11.245  1.00  9.59      A    C  
ATOM    203  CB  ALA    33      19.388  49.493  11.716  1.00  9.71      A    C  
ATOM    204  C   ALA    33      17.588  47.814  12.139  1.00  9.51      A    C  
ATOM    205  O   ALA    33      17.351  48.005  13.321  1.00  9.72      A    O  
ATOM    206  N   GLU    34      17.486  46.627  11.555  1.00  9.06      A    N  
ATOM    207  CA  GLU    34      17.053  45.430  12.279  1.00  9.62      A    C  
ATOM    208  CB  GLU    34      15.703  44.965  11.711  1.00  9.26      A    C  
ATOM    209  CG  GLU    34      15.284  43.565  12.117  1.00 10.47      A    C  
ATOM    210  CD  GLU    34      15.182  43.388  13.624  1.00 10.26      A    C  
ATOM    211  OE1 GLU    34      14.447  44.153  14.296  1.00 10.24      A    O  
ATOM    212  OE2 GLU    34      15.829  42.465  14.149  1.00 11.78      A    O  
ATOM    213  C   GLU    34      18.117  44.334  12.166  1.00  9.66      A    C  
ATOM    214  O   GLU    34      18.593  44.042  11.074  1.00  9.88      A    O  
ATOM    215  N   ALA    35      18.485  43.738  13.296  1.00 10.29      A    N  
ATOM    216  CA  ALA    35      19.537  42.707  13.337  1.00 11.68      A    C  
ATOM    217  CB  ALA    35      19.993  42.478  14.780  1.00 10.93      A    C  
ATOM    218  C   ALA    35      19.102  41.395  12.694  1.00 12.64      A    C  
ATOM    219  O   ALA    35      19.916  40.686  12.076  1.00 12.39      A    O  
ATOM    220  N   ALA    36      17.819  41.066  12.838  1.00 13.65      A    N  
ATOM    221  CA  ALA    36      17.259  39.828  12.264  1.00 15.76      A    C  
ATOM    222  CB  ALA    36      15.907  39.496  12.917  1.00 15.54      A    C  
ATOM    223  C   ALA    36      17.099  39.912  10.748  1.00 17.64      A    C  
ATOM    224  O   ALA    36      17.257  40.973  10.168  1.00 16.16      A    O  
ATOM    225  N   GLU    37      16.740  38.789  10.120  1.00 21.32      A    N  
ATOM    226  CA  GLU    37      16.543  38.737   8.662  1.00 25.10      A    C  
ATOM    227  CB  GLU    37      16.706  37.291   8.155  1.00 25.58      A    C  
ATOM    228  CG  GLU    37      18.139  36.772   8.251  1.00 28.03      A    C  
ATOM    229  CD  GLU    37      19.061  37.370   7.182  1.00 31.75      A    C  
ATOM    230  OE1 GLU    37      18.559  38.078   6.282  1.00 34.60      A    O  
ATOM    231  OE2 GLU    37      20.285  37.133   7.239  1.00 33.38      A    O  
ATOM    232  C   GLU    37      15.234  39.372   8.138  1.00 27.36      A    C  
ATOM    233  O   GLU    37      15.129  39.691   6.946  1.00 27.94      A    O  
ATOM    234  N   GLY    38      14.247  39.567   9.012  1.00 29.61      A    N  
ATOM    235  CA  GLY    38      13.013  40.275   8.631  1.00 32.31      A    C  
ATOM    236  C   GLY    38      12.423  41.152   9.732  1.00 34.12      A    C  
ATOM    237  O   GLY    38      13.052  41.363  10.775  1.00 34.47      A    O  
ATOM    238  N   ILE    39      11.209  41.664   9.516  1.00 35.49      A    N  
ATOM    239  CA  ILE    39      10.524  42.431  10.563  1.00 36.78      A    C  
ATOM    240  CB  ILE    39       9.467  43.442  10.014  1.00 36.73      A    C  
ATOM    241  CG1 ILE    39       8.369  42.722   9.231  1.00 37.04      A    C  
ATOM    242  CD1 ILE    39       7.213  43.626   8.867  1.00 37.54      A    C  
ATOM    243  CG2 ILE    39      10.108  44.550   9.176  1.00 37.15      A    C  
ATOM    244  C   ILE    39       9.801  41.492  11.518  1.00 37.50      A    C  
ATOM    245  O   ILE    39       9.383  40.394  11.129  1.00 37.79      A    O  
ATOM    246  N   GLY    40       9.663  41.931  12.769  1.00 38.27      A    N  
ATOM    247  CA  GLY    40       8.746  41.302  13.719  1.00 38.99      A    C  
ATOM    248  C   GLY    40       9.009  39.844  14.042  1.00 39.46      A    C  
ATOM    249  O   GLY    40       8.075  39.071  14.270  1.00 39.75      A    O  
ATOM    250  N   THR    41      10.280  39.465  14.078  1.00 39.76      A    N  
ATOM    251  CA  THR    41      10.646  38.101  14.442  1.00 40.02      A    C  
ATOM    252  CB  THR    41      11.921  37.625  13.691  1.00 40.19      A    C  
ATOM    253  OG1 THR    41      13.008  38.527  13.944  1.00 40.65      A    O  
ATOM    254  CG2 THR    41      11.668  37.549  12.190  1.00 40.45      A    C  
ATOM    255  C   THR    41      10.842  37.957  15.957  1.00 39.91      A    C  
ATOM    256  O   THR    41      10.828  36.844  16.491  1.00 40.18      A    O  
ATOM    257  N   GLY    42      11.005  39.086  16.642  1.00 39.45      A    N  
ATOM    258  CA  GLY    42      11.349  39.084  18.060  1.00 39.18      A    C  
ATOM    259  C   GLY    42      10.189  38.908  19.023  1.00 38.90      A    C  
ATOM    260  O   GLY    42       9.378  37.998  18.874  1.00 38.88      A    O  
ATOM    261  N   THR    43      10.113  39.784  20.020  1.00 38.61      A    N  
ATOM    262  CA  THR    43       9.056  39.694  21.025  1.00 38.22      A    C  
ATOM    263  CB  THR    43       9.366  40.552  22.261  1.00 38.49      A    C  
ATOM    264  OG1 THR    43      10.627  40.151  22.808  1.00 38.92      A    O  
ATOM    265  CG2 THR    43       8.276  40.392  23.324  1.00 38.36      A    C  
ATOM    266  C   THR    43       7.712  40.111  20.454  1.00 37.63      A    C  
ATOM    267  O   THR    43       6.685  40.041  21.140  1.00 37.79      A    O  
ATOM    268  N   SER    44       7.730  40.550  19.199  1.00 36.71      A    N  
ATOM    269  CA  SER    44       6.498  40.889  18.488  1.00 35.10      A    C  
ATOM    270  CB  SER    44       6.731  42.056  17.524  1.00 35.16      A    C  
ATOM    271  OG  SER    44       7.150  43.214  18.225  1.00 27.29      A    O  
ATOM    272  C   SER    44       5.930  39.685  17.746  1.00 35.80      A    C  
ATOM    273  O   SER    44       4.904  39.792  17.070  1.00 36.07      A    O  
ATOM    274  N   SER    45       6.594  38.537  17.879  1.00 35.56      A    N  
ATOM    275  CA  SER    45       6.102  37.300  17.270  1.00 35.56      A    C  
ATOM    276  CB  SER    45       7.049  36.835  16.158  1.00 35.80      A    C  
ATOM    277  OG  SER    45       8.348  36.576  16.666  1.00 37.39      A    O  
ATOM    278  C   SER    45       5.905  36.197  18.314  1.00 35.04      A    C  
ATOM    279  O   SER    45       5.666  35.030  17.980  1.00 35.06      A    O  
ATOM    280  N   ARG    46       6.002  36.576  19.585  1.00 34.21      A    N  
ATOM    281  CA  ARG    46       5.930  35.604  20.671  1.00 33.05      A    C  
ATOM    282  CB  ARG    46       7.337  35.261  21.164  1.00 33.02      A    C  
ATOM    283  CG  ARG    46       8.279  34.710  20.077  1.00 33.79      A    C  
ATOM    284  CD  ARG    46       9.714  34.607  20.592  1.00 33.38      A    C  
ATOM    285  NE  ARG    46      10.592  33.854  19.694  1.00 33.18      A    N  
ATOM    286  CZ  ARG    46      10.528  32.538  19.512  1.00 32.21      A    C  
ATOM    287  NH1 ARG    46       9.608  31.816  20.140  1.00 29.99      A    N  
ATOM    288  NH2 ARG    46      11.376  31.945  18.678  1.00 32.48      A    N  
ATOM    289  C   ARG    46       5.062  36.126  21.822  1.00 32.25      A    C  
ATOM    290  O   ARG    46       5.469  36.100  22.979  1.00 31.54      A    O  
ATOM    291  N   ASN    47       3.861  36.601  21.490  1.00 31.32      A    N  
ATOM    292  CA  ASN    47       2.918  37.090  22.497  1.00 29.78      A    C  
ATOM    293  CB  ASN    47       2.924  38.641  22.557  1.00 30.79      A    C  
ATOM    294  CG  ASN    47       2.389  39.297  21.283  1.00 32.17      A    C  
ATOM    295  OD1 ASN    47       3.152  39.631  20.366  1.00 36.00      A    O  
ATOM    296  ND2 ASN    47       1.077  39.465  21.213  1.00 33.08      A    N  
ATOM    297  C   ASN    47       1.509  36.517  22.264  1.00 28.90      A    C  
ATOM    298  O   ASN    47       1.308  35.725  21.326  1.00 28.04      A    O  
ATOM    299  N   SER    48       0.549  36.905  23.115  1.00 27.12      A    N  
ATOM    300  CA  SER    48      -0.833  36.384  23.042  1.00 25.17      A    C  
ATOM    301  CB  SER    48      -1.567  36.576  24.377  1.00 25.29      A    C  
ATOM    302  OG  SER    48      -0.702  36.976  25.409  1.00 24.10      A    O  
ATOM    303  C   SER    48      -1.642  37.094  21.956  1.00 23.84      A    C  
ATOM    304  O   SER    48      -2.697  36.612  21.513  1.00 24.97      A    O  
ATOM    305  N   GLU    49      -1.155  38.258  21.547  1.00 20.63      A    N  
ATOM    306  CA  GLU    49      -1.794  39.025  20.517  1.00 16.82      A    C  
ATOM    307  CB  GLU    49      -2.003  38.175  19.271  1.00 16.62      A    C  
ATOM    308  CG  GLU    49      -0.705  37.888  18.511  1.00 22.04      A    C  
ATOM    309  CD  GLU    49      -0.908  36.953  17.316  1.00 26.81      A    C  
ATOM    310  OE1 GLU    49      -1.726  36.017  17.441  1.00 28.52      A    O  
ATOM    311  OE2 GLU    49      -0.254  37.164  16.263  1.00 27.42      A    O  
ATOM    312  C   GLU    49      -3.114  39.565  21.036  1.00 13.38      A    C  
ATOM    313  O   GLU    49      -4.050  39.731  20.274  1.00 12.75      A    O  
ATOM    314  N   VAL    50      -3.167  39.840  22.335  1.00 10.42      A    N  
ATOM    315  CA  VAL    50      -4.378  40.409  22.941  1.00  8.31      A    C  
ATOM    316  CB  VAL    50      -4.558  39.926  24.400  1.00  8.28      A    C  
ATOM    317  CG1 VAL    50      -5.753  40.589  25.055  1.00  8.43      A    C  
ATOM    318  CG2 VAL    50      -4.737  38.411  24.448  1.00  7.04      A    C  
ATOM    319  C   VAL    50      -4.383  41.937  22.890  1.00  8.10      A    C  
ATOM    320  O   VAL    50      -3.400  42.596  23.240  1.00  7.33      A    O  
ATOM    321  N   ILE    51      -5.504  42.502  22.439  1.00  7.64      A    N  
ATOM    322  CA  ILE    51      -5.712  43.948  22.519  1.00  6.60      A    C  
ATOM    323  CB  ILE    51      -6.682  44.451  21.428  1.00  7.25      A    C  
ATOM    324  CG1 ILE    51      -6.131  44.141  20.020  1.00  6.76      A    C  
ATOM    325  CD1 ILE    51      -7.089  44.499  18.857  1.00 10.48      A    C  
ATOM    326  CG2 ILE    51      -6.880  45.976  21.583  1.00  6.93      A    C  
ATOM    327  C   ILE    51      -6.311  44.196  23.907  1.00  7.08      A    C  
ATOM    328  O   ILE    51      -7.489  43.905  24.157  1.00  7.14      A    O  
ATOM    329  N   HIS    52      -5.487  44.704  24.817  1.00  6.56      A    N  
ATOM    330  CA  HIS    52      -5.903  44.856  26.214  1.00  7.08      A    C  
ATOM    331  CB  HIS    52      -4.669  44.922  27.115  1.00  7.43      A    C  
ATOM    332  CG  HIS    52      -4.032  43.589  27.330  1.00  7.92      A    C  
ATOM    333  ND1 HIS    52      -4.608  42.624  28.125  1.00  9.54      A    N  
ATOM    334  CE1 HIS    52      -3.831  41.553  28.146  1.00  9.18      A    C  
ATOM    335  NE2 HIS    52      -2.778  41.786  27.379  1.00  7.63      A    N  
ATOM    336  CD2 HIS    52      -2.876  43.056  26.863  1.00 10.24      A    C  
ATOM    337  C   HIS    52      -6.789  46.076  26.439  1.00  7.45      A    C  
ATOM    338  O   HIS    52      -6.610  47.118  25.810  1.00  8.19      A    O  
ATOM    339  N   ALA    53      -7.735  45.928  27.364  1.00  7.73      A    N  
ATOM    340  CA  ALA    53      -8.663  47.015  27.686  1.00  7.27      A    C  
ATOM    341  CB  ALA    53      -9.899  46.476  28.408  1.00  7.32      A    C  
ATOM    342  C   ALA    53      -8.033  48.173  28.476  1.00  7.41      A    C  
ATOM    343  O   ALA    53      -8.426  49.313  28.268  1.00  7.13      A    O  
ATOM    344  N   GLY    54      -7.075  47.876  29.361  1.00  7.59      A    N  
ATOM    345  CA  GLY    54      -6.435  48.884  30.232  1.00  7.25      A    C  
ATOM    346  C   GLY    54      -6.926  48.780  31.676  1.00  7.60      A    C  
ATOM    347  O   GLY    54      -7.012  49.777  32.400  1.00  7.73      A    O  
ATOM    348  N   ILE    55      -7.203  47.555  32.105  1.00  7.33      A    N  
ATOM    349  CA  ILE    55      -7.931  47.305  33.337  1.00  8.04      A    C  
ATOM    350  CB  ILE    55      -8.519  45.865  33.313  1.00  7.29      A    C  
ATOM    351  CG1 ILE    55      -9.633  45.786  32.256  1.00  7.56      A    C  
ATOM    352  CD1 ILE    55     -10.121  44.377  31.956  1.00  7.54      A    C  
ATOM    353  CG2 ILE    55      -9.027  45.417  34.712  1.00  7.10      A    C  
ATOM    354  C   ILE    55      -7.106  47.531  34.608  1.00  8.84      A    C  
ATOM    355  O   ILE    55      -7.498  48.309  35.478  1.00 10.00      A    O  
ATOM    356  N   TYR    56      -5.962  46.861  34.741  1.00  8.60      A    N  
ATOM    357  CA  TYR    56      -5.373  46.812  36.077  1.00  9.77      A    C  
ATOM    358  CB  TYR    56      -5.237  45.357  36.541  1.00 10.58      A    C  
ATOM    359  CG  TYR    56      -5.254  45.189  38.057  1.00 11.81      A    C  
ATOM    360  CD1 TYR    56      -6.344  45.630  38.814  1.00 14.23      A    C  
ATOM    361  CE1 TYR    56      -6.365  45.504  40.192  1.00 14.92      A    C  
ATOM    362  CZ  TYR    56      -5.289  44.904  40.837  1.00 16.04      A    C  
ATOM    363  OH  TYR    56      -5.311  44.764  42.206  1.00 17.65      A    O  
ATOM    364  CE2 TYR    56      -4.201  44.442  40.110  1.00 15.78      A    C  
ATOM    365  CD2 TYR    56      -4.188  44.589  38.721  1.00 15.35      A    C  
ATOM    366  C   TYR    56      -4.061  47.572  36.277  1.00  8.88      A    C  
ATOM    367  O   TYR    56      -3.445  47.492  37.345  1.00  9.87      A    O  
ATOM    368  N   TYR    57      -3.624  48.308  35.266  1.00  8.78      A    N  
ATOM    369  CA  TYR    57      -2.401  49.107  35.405  1.00  8.91      A    C  
ATOM    370  CB  TYR    57      -1.951  49.615  34.030  1.00  8.86      A    C  
ATOM    371  CG  TYR    57      -2.024  48.506  32.997  1.00  8.56      A    C  
ATOM    372  CD1 TYR    57      -1.156  47.419  33.063  1.00  9.52      A    C  
ATOM    373  CE1 TYR    57      -1.227  46.398  32.155  1.00 10.07      A    C  
ATOM    374  CZ  TYR    57      -2.189  46.421  31.165  1.00 11.26      A    C  
ATOM    375  OH  TYR    57      -2.252  45.384  30.268  1.00 11.50      A    O  
ATOM    376  CE2 TYR    57      -3.067  47.473  31.072  1.00  9.78      A    C  
ATOM    377  CD2 TYR    57      -2.993  48.509  32.010  1.00  8.62      A    C  
ATOM    378  C   TYR    57      -2.623  50.258  36.385  1.00  9.94      A    C  
ATOM    379  O   TYR    57      -3.727  50.794  36.484  1.00 10.15      A    O  
ATOM    380  N   PRO    58      -1.570  50.640  37.121  1.00 10.87      A    N  
ATOM    381  CA  PRO    58      -1.763  51.662  38.139  1.00 11.03      A    C  
ATOM    382  CB  PRO    58      -0.398  51.719  38.847  1.00 11.42      A    C  
ATOM    383  CG  PRO    58       0.265  50.391  38.549  1.00 12.06      A    C  
ATOM    384  CD  PRO    58      -0.230  50.027  37.174  1.00 10.77      A    C  
ATOM    385  C   PRO    58      -2.124  53.026  37.526  1.00 11.15      A    C  
ATOM    386  O   PRO    58      -1.664  53.374  36.433  1.00 11.25      A    O  
ATOM    387  N   ALA    59      -2.940  53.791  38.235  1.00 11.77      A    N  
ATOM    388  CA  ALA    59      -3.418  55.068  37.707  1.00 11.98      A    C  
ATOM    389  CB  ALA    59      -4.204  55.826  38.771  1.00 11.82      A    C  
ATOM    390  C   ALA    59      -2.287  55.950  37.162  1.00 12.46      A    C  
ATOM    391  O   ALA    59      -1.243  56.110  37.801  1.00 12.86      A    O  
ATOM    392  N   ASP    60      -2.518  56.508  35.975  1.00 12.85      A    N  
ATOM    393  CA  ASP    60      -1.603  57.462  35.342  1.00 13.80      A    C  
ATOM    394  CB  ASP    60      -1.455  58.719  36.198  1.00 14.86      A    C  
ATOM    395  CG  ASP    60      -2.760  59.484  36.335  1.00 18.07      A    C  
ATOM    396  OD1 ASP    60      -3.581  59.464  35.387  1.00 20.90      A    O  
ATOM    397  OD2 ASP    60      -2.964  60.121  37.398  1.00 23.61      A    O  
ATOM    398  C   ASP    60      -0.225  56.918  34.959  1.00 13.27      A    C  
ATOM    399  O   ASP    60       0.628  57.689  34.488  1.00 13.16      A    O  
ATOM    400  N   SER    61      -0.012  55.611  35.146  1.00 12.05      A    N  
ATOM    401  CA  SER    61       1.183  54.962  34.605  1.00 10.82      A    C  
ATOM    402  CB  SER    61       1.258  53.491  35.044  1.00 11.12      A    C  
ATOM    403  OG  SER    61       0.143  52.726  34.564  1.00  8.94      A    O  
ATOM    404  C   SER    61       1.191  55.059  33.087  1.00 10.60      A    C  
ATOM    405  O   SER    61       0.143  55.250  32.457  1.00  9.42      A    O  
ATOM    406  N   LEU    62       2.368  54.912  32.480  1.00  9.61      A    N  
ATOM    407  CA  LEU    62       2.418  54.839  31.024  1.00  9.93      A    C  
ATOM    408  CB  LEU    62       3.853  54.802  30.503  1.00 10.55      A    C  
ATOM    409  CG  LEU    62       4.588  56.137  30.557  1.00 11.66      A    C  
ATOM    410  CD1 LEU    62       5.974  55.960  29.987  1.00 11.95      A    C  
ATOM    411  CD2 LEU    62       3.797  57.185  29.753  1.00 12.15      A    C  
ATOM    412  C   LEU    62       1.660  53.623  30.529  1.00  9.43      A    C  
ATOM    413  O   LEU    62       0.955  53.709  29.526  1.00  8.87      A    O  
ATOM    414  N   LYS    63       1.788  52.494  31.226  1.00  8.82      A    N  
ATOM    415  CA  LYS    63       1.018  51.327  30.853  1.00  8.38      A    C  
ATOM    416  CB  LYS    63       1.293  50.141  31.792  1.00  8.35      A    C  
ATOM    417  CG  LYS    63       2.664  49.466  31.545  1.00  8.97      A    C  
ATOM    418  CD  LYS    63       2.842  48.265  32.505  1.00 11.67      A    C  
ATOM    419  CE  LYS    63       4.199  47.588  32.325  1.00 15.61      A    C  
ATOM    420  NZ  LYS    63       4.418  47.274  30.925  1.00 22.22      A    N  
ATOM    421  C   LYS    63      -0.475  51.667  30.827  1.00  7.93      A    C  
ATOM    422  O   LYS    63      -1.169  51.331  29.887  1.00  7.25      A    O  
ATOM    423  N   ALA    64      -0.977  52.337  31.856  1.00  8.01      A    N  
ATOM    424  CA  ALA    64      -2.415  52.628  31.866  1.00  7.83      A    C  
ATOM    425  CB  ALA    64      -2.823  53.189  33.204  1.00  7.78      A    C  
ATOM    426  C   ALA    64      -2.786  53.594  30.729  1.00  8.03      A    C  
ATOM    427  O   ALA    64      -3.722  53.360  29.968  1.00  7.77      A    O  
ATOM    428  N   ARG    65      -2.067  54.701  30.642  1.00  7.68      A    N  
ATOM    429  CA  ARG    65      -2.438  55.763  29.712  1.00  8.18      A    C  
ATOM    430  CB  ARG    65      -1.611  57.009  29.993  1.00  8.94      A    C  
ATOM    431  CG  ARG    65      -1.873  58.120  29.013  1.00 11.92      A    C  
ATOM    432  CD  ARG    65      -1.428  59.454  29.582  1.00 17.28      A    C  
ATOM    433  NE  ARG    65       0.007  59.690  29.473  1.00 21.96      A    N  
ATOM    434  CZ  ARG    65       0.886  59.562  30.457  1.00 25.98      A    C  
ATOM    435  NH1 ARG    65       0.505  59.150  31.664  1.00 28.44      A    N  
ATOM    436  NH2 ARG    65       2.167  59.836  30.219  1.00 28.46      A    N  
ATOM    437  C   ARG    65      -2.286  55.331  28.260  1.00  7.67      A    C  
ATOM    438  O   ARG    65      -3.163  55.560  27.420  1.00  7.78      A    O  
ATOM    439  N   LEU    66      -1.157  54.696  27.969  1.00  7.04      A    N  
ATOM    440  CA  LEU    66      -0.856  54.285  26.610  1.00  6.40      A    C  
ATOM    441  CB  LEU    66       0.653  54.100  26.422  1.00  6.40      A    C  
ATOM    442  CG  LEU    66       1.497  55.346  26.757  1.00  6.64      A    C  
ATOM    443  CD1 LEU    66       2.959  55.113  26.363  1.00  8.12      A    C  
ATOM    444  CD2 LEU    66       0.965  56.618  26.099  1.00  8.63      A    C  
ATOM    445  C   LEU    66      -1.626  53.032  26.210  1.00  6.58      A    C  
ATOM    446  O   LEU    66      -1.909  52.843  25.034  1.00  6.70      A    O  
ATOM    447  N   CYS    67      -1.986  52.178  27.169  1.00  6.22      A    N  
ATOM    448  CA  CYS    67      -2.799  51.021  26.801  1.00  6.53      A    C  
ATOM    449  CB  CYS    67      -2.938  50.019  27.953  1.00  6.79      A    C  
ATOM    450  SG  CYS    67      -3.829  48.505  27.463  1.00  7.60      A    S  
ATOM    451  C   CYS    67      -4.172  51.491  26.335  1.00  7.50      A    C  
ATOM    452  O   CYS    67      -4.685  51.016  25.323  1.00  6.74      A    O  
ATOM    453  N   VAL    68      -4.757  52.444  27.056  1.00  8.07      A    N  
ATOM    454  CA  VAL    68      -6.140  52.835  26.752  1.00  9.14      A    C  
ATOM    455  CB  VAL    68      -6.800  53.558  27.944  1.00  9.33      A    C  
ATOM    456  CG1 VAL    68      -8.160  54.155  27.542  1.00 11.40      A    C  
ATOM    457  CG2 VAL    68      -6.967  52.597  29.137  1.00  9.68      A    C  
ATOM    458  C   VAL    68      -6.174  53.673  25.474  1.00  9.38      A    C  
ATOM    459  O   VAL    68      -6.969  53.417  24.555  1.00  9.98      A    O  
ATOM    460  N   ARG    69      -5.298  54.655  25.390  1.00  9.31      A    N  
ATOM    461  CA  ARG    69      -5.156  55.434  24.158  1.00  9.28      A    C  
ATOM    462  CB  ARG    69      -4.072  56.484  24.362  1.00  9.91      A    C  
ATOM    463  CG  ARG    69      -3.657  57.204  23.105  1.00 13.50      A    C  
ATOM    464  CD  ARG    69      -4.612  58.275  22.754  1.00 16.88      A    C  
ATOM    465  NE  ARG    69      -4.147  59.054  21.603  1.00 17.05      A    N  
ATOM    466  CZ  ARG    69      -4.958  59.788  20.852  1.00 19.86      A    C  
ATOM    467  NH1 ARG    69      -6.254  59.846  21.154  1.00 20.22      A    N  
ATOM    468  NH2 ARG    69      -4.482  60.465  19.804  1.00 17.58      A    N  
ATOM    469  C   ARG    69      -4.792  54.536  22.970  1.00  8.86      A    C  
ATOM    470  O   ARG    69      -5.351  54.656  21.882  1.00  8.88      A    O  
ATOM    471  N   GLY    70      -3.825  53.644  23.185  1.00  6.96      A    N  
ATOM    472  CA  GLY    70      -3.346  52.752  22.137  1.00  6.63      A    C  
ATOM    473  C   GLY    70      -4.444  51.845  21.631  1.00  6.86      A    C  
ATOM    474  O   GLY    70      -4.516  51.578  20.426  1.00  6.60      A    O  
ATOM    475  N   LYS    71      -5.287  51.355  22.550  1.00  6.80      A    N  
ATOM    476  CA  LYS    71      -6.410  50.489  22.187  1.00  7.04      A    C  
ATOM    477  CB  LYS    71      -7.204  50.086  23.441  1.00  7.45      A    C  
ATOM    478  CG  LYS    71      -8.485  49.291  23.146  1.00  8.10      A    C  
ATOM    479  CD  LYS    71      -9.225  48.959  24.463  1.00  9.88      A    C  
ATOM    480  CE  LYS    71      -9.950  50.190  25.052  1.00 10.93      A    C  
ATOM    481  NZ  LYS    71     -10.581  49.920  26.392  1.00 10.98      A    N  
ATOM    482  C   LYS    71      -7.337  51.212  21.221  1.00  7.19      A    C  
ATOM    483  O   LYS    71      -7.713  50.679  20.193  1.00  7.76      A    O  
ATOM    484  N   HIS    72      -7.697  52.436  21.561  1.00  7.71      A    N  
ATOM    485  CA  HIS    72      -8.559  53.212  20.675  1.00  8.31      A    C  
ATOM    486  CB  HIS    72      -8.929  54.525  21.356  1.00  9.02      A    C  
ATOM    487  CG  HIS    72      -9.755  54.321  22.590  1.00 11.38      A    C  
ATOM    488  ND1 HIS    72     -10.778  53.395  22.649  1.00 15.33      A    N  
ATOM    489  CE1 HIS    72     -11.328  53.430  23.849  1.00 15.31      A    C  
ATOM    490  NE2 HIS    72     -10.690  54.336  24.573  1.00 16.23      A    N  
ATOM    491  CD2 HIS    72      -9.711  54.914  23.805  1.00 14.76      A    C  
ATOM    492  C   HIS    72      -7.909  53.442  19.307  1.00  7.82      A    C  
ATOM    493  O   HIS    72      -8.525  53.210  18.269  1.00  8.41      A    O  
ATOM    494  N   LEU    73      -6.662  53.880  19.303  1.00  8.35      A    N  
ATOM    495  CA  LEU    73      -5.962  54.085  18.038  1.00  8.19      A    C  
ATOM    496  CB  LEU    73      -4.558  54.631  18.286  1.00  8.54      A    C  
ATOM    497  CG  LEU    73      -4.514  56.027  18.872  1.00  9.09      A    C  
ATOM    498  CD1 LEU    73      -3.078  56.401  19.189  1.00  9.03      A    C  
ATOM    499  CD2 LEU    73      -5.127  57.016  17.846  1.00 12.63      A    C  
ATOM    500  C   LEU    73      -5.873  52.797  17.231  1.00  8.07      A    C  
ATOM    501  O   LEU    73      -6.002  52.823  16.005  1.00  8.49      A    O  
ATOM    502  N   LEU    74      -5.630  51.673  17.912  1.00  7.61      A    N  
ATOM    503  CA  LEU    74      -5.379  50.408  17.221  1.00  7.20      A    C  
ATOM    504  CB  LEU    74      -4.742  49.391  18.193  1.00  7.34      A    C  
ATOM    505  CG  LEU    74      -4.428  48.008  17.635  1.00  7.42      A    C  
ATOM    506  CD1 LEU    74      -3.462  48.134  16.483  1.00  8.05      A    C  
ATOM    507  CD2 LEU    74      -3.859  47.098  18.756  1.00  7.72      A    C  
ATOM    508  C   LEU    74      -6.677  49.840  16.622  1.00  7.35      A    C  
ATOM    509  O   LEU    74      -6.686  49.339  15.503  1.00  7.49      A    O  
ATOM    510  N   TYR    75      -7.785  49.914  17.360  1.00  7.06      A    N  
ATOM    511  CA  TYR    75      -9.043  49.410  16.805  1.00  7.41      A    C  
ATOM    512  CB  TYR    75     -10.165  49.489  17.844  1.00  7.37      A    C  
ATOM    513  CG  TYR    75     -10.304  48.244  18.673  1.00  7.53      A    C  
ATOM    514  CD1 TYR    75     -10.485  47.002  18.068  1.00  8.31      A    C  
ATOM    515  CE1 TYR    75     -10.617  45.851  18.832  1.00  8.00      A    C  
ATOM    516  CZ  TYR    75     -10.585  45.945  20.213  1.00  7.54      A    C  
ATOM    517  OH  TYR    75     -10.723  44.817  20.970  1.00  9.44      A    O  
ATOM    518  CE2 TYR    75     -10.406  47.172  20.830  1.00  6.93      A    C  
ATOM    519  CD2 TYR    75     -10.262  48.302  20.059  1.00  6.95      A    C  
ATOM    520  C   TYR    75      -9.418  50.220  15.567  1.00  7.93      A    C  
ATOM    521  O   TYR    75      -9.854  49.670  14.558  1.00  8.51      A    O  
ATOM    522  N   GLU    76      -9.219  51.529  15.648  1.00  8.56      A    N  
ATOM    523  CA  GLU    76      -9.482  52.387  14.496  1.00  9.57      A    C  
ATOM    524  CB  GLU    76      -9.352  53.849  14.892  1.00 10.16      A    C  
ATOM    525  CG  GLU    76      -9.505  54.835  13.749  1.00 11.30      A    C  
ATOM    526  CD  GLU    76      -9.489  56.253  14.271  1.00 14.87      A    C  
ATOM    527  OE1 GLU    76      -8.435  56.654  14.801  1.00 17.31      A    O  
ATOM    528  OE2 GLU    76     -10.522  56.955  14.177  1.00 14.89      A    O  
ATOM    529  C   GLU    76      -8.549  52.039  13.324  1.00  9.62      A    C  
ATOM    530  O   GLU    76      -8.989  51.897  12.185  1.00  9.61      A    O  
ATOM    531  N   TYR    77      -7.254  51.884  13.622  1.00  9.34      A    N  
ATOM    532  CA  TYR    77      -6.245  51.540  12.617  1.00  9.97      A    C  
ATOM    533  CB  TYR    77      -4.843  51.445  13.269  1.00  9.16      A    C  
ATOM    534  CG  TYR    77      -3.741  51.179  12.267  1.00  9.29      A    C  
ATOM    535  CD1 TYR    77      -3.079  52.228  11.645  1.00 12.12      A    C  
ATOM    536  CE1 TYR    77      -2.077  51.991  10.716  1.00 12.93      A    C  
ATOM    537  CZ  TYR    77      -1.740  50.692  10.413  1.00 12.43      A    C  
ATOM    538  OH  TYR    77      -0.748  50.415   9.491  1.00 13.90      A    O  
ATOM    539  CE2 TYR    77      -2.390  49.645  11.012  1.00 12.32      A    C  
ATOM    540  CD2 TYR    77      -3.382  49.893  11.940  1.00 11.30      A    C  
ATOM    541  C   TYR    77      -6.588  50.227  11.932  1.00 10.77      A    C  
ATOM    542  O   TYR    77      -6.526  50.118  10.713  1.00 11.12      A    O  
ATOM    543  N   CYS    78      -6.971  49.224  12.714  1.00 11.11      A    N  
ATOM    544  CA  CYS    78      -7.256  47.917  12.148  1.00 12.12      A    C  
ATOM    545  CB  CYS    78      -7.457  46.883  13.238  1.00 12.01      A    C  
ATOM    546  SG  CYS    78      -5.887  46.440  14.033  1.00 12.83      A    S  
ATOM    547  C   CYS    78      -8.461  47.969  11.218  1.00 12.71      A    C  
ATOM    548  O   CYS    78      -8.450  47.364  10.154  1.00 13.65      A    O  
ATOM    549  N   ALA    79      -9.493  48.696  11.619  1.00 13.19      A    N  
ATOM    550  CA  ALA    79     -10.673  48.839  10.770  1.00 14.27      A    C  
ATOM    551  CB  ALA    79     -11.831  49.481  11.538  1.00 14.37      A    C  
ATOM    552  C   ALA    79     -10.336  49.651   9.517  1.00 14.88      A    C  
ATOM    553  O   ALA    79     -10.793  49.332   8.413  1.00 16.04      A    O  
ATOM    554  N   ALA    80      -9.535  50.694   9.683  1.00 15.58      A    N  
ATOM    555  CA  ALA    80      -9.218  51.596   8.580  1.00 16.51      A    C  
ATOM    556  CB  ALA    80      -8.522  52.842   9.096  1.00 16.50      A    C  
ATOM    557  C   ALA    80      -8.359  50.908   7.528  1.00 17.40      A    C  
ATOM    558  O   ALA    80      -8.511  51.158   6.324  1.00 17.37      A    O  
ATOM    559  N   ARG    81      -7.473  50.019   7.978  1.00 17.86      A    N  
ATOM    560  CA  ARG    81      -6.459  49.440   7.105  1.00 18.60      A    C  
ATOM    561  CB  ARG    81      -5.071  49.521   7.750  1.00 18.91      A    C  
ATOM    562  CG  ARG    81      -4.677  50.897   8.239  1.00 21.65      A    C  
ATOM    563  CD  ARG    81      -4.958  51.991   7.242  1.00 28.32      A    C  
ATOM    564  NE  ARG    81      -4.214  53.181   7.637  1.00 31.43      A    N  
ATOM    565  CZ  ARG    81      -2.958  53.413   7.270  1.00 32.72      A    C  
ATOM    566  NH1 ARG    81      -2.340  52.543   6.478  1.00 34.15      A    N  
ATOM    567  NH2 ARG    81      -2.329  54.509   7.685  1.00 32.17      A    N  
ATOM    568  C   ARG    81      -6.736  47.997   6.758  1.00 18.28      A    C  
ATOM    569  O   ARG    81      -6.026  47.422   5.933  1.00 19.97      A    O  
ATOM    570  N   GLY    82      -7.733  47.391   7.401  1.00 16.96      A    N  
ATOM    571  CA  GLY    82      -8.090  46.009   7.102  1.00 15.99      A    C  
ATOM    572  C   GLY    82      -7.157  44.976   7.705  1.00 15.51      A    C  
ATOM    573  O   GLY    82      -6.957  43.901   7.128  1.00 15.97      A    O  
ATOM    574  N   VAL    83      -6.578  45.293   8.863  1.00 14.33      A    N  
ATOM    575  CA  VAL    83      -5.756  44.326   9.604  1.00 13.75      A    C  
ATOM    576  CB  VAL    83      -4.874  45.009  10.675  1.00 13.17      A    C  
ATOM    577  CG1 VAL    83      -4.049  43.961  11.402  1.00 12.94      A    C  
ATOM    578  CG2 VAL    83      -3.988  46.093  10.074  1.00 13.13      A    C  
ATOM    579  C   VAL    83      -6.678  43.371  10.340  1.00 13.66      A    C  
ATOM    580  O   VAL    83      -7.575  43.813  11.072  1.00 13.98      A    O  
ATOM    581  N   PRO    84      -6.477  42.061  10.158  1.00 13.63      A    N  
ATOM    582  CA  PRO    84      -7.341  41.084  10.834  1.00 13.76      A    C  
ATOM    583  CB  PRO    84      -6.753  39.730  10.398  1.00 14.02      A    C  
ATOM    584  CG  PRO    84      -6.072  40.025   9.089  1.00 14.50      A    C  
ATOM    585  CD  PRO    84      -5.524  41.421   9.228  1.00 14.23      A    C  
ATOM    586  C   PRO    84      -7.322  41.236  12.372  1.00 13.22      A    C  
ATOM    587  O   PRO    84      -6.259  41.271  13.008  1.00 12.96      A    O  
ATOM    588  N   HIS    85      -8.508  41.339  12.953  1.00 12.91      A    N  
ATOM    589  CA  HIS    85      -8.643  41.461  14.404  1.00 12.37      A    C  
ATOM    590  CB  HIS    85      -8.352  42.893  14.842  1.00 12.88      A    C  
ATOM    591  CG  HIS    85      -9.386  43.869  14.385  1.00 13.86      A    C  
ATOM    592  ND1 HIS    85      -9.571  44.175  13.056  1.00 13.97      A    N  
ATOM    593  CE1 HIS    85     -10.551  45.056  12.943  1.00 15.14      A    C  
ATOM    594  NE2 HIS    85     -11.020  45.317  14.151  1.00 14.84      A    N  
ATOM    595  CD2 HIS    85     -10.309  44.585  15.073  1.00 14.88      A    C  
ATOM    596  C   HIS    85     -10.068  41.123  14.780  1.00 12.31      A    C  
ATOM    597  O   HIS    85     -10.965  41.143  13.926  1.00 13.00      A    O  
ATOM    598  N   GLN    86     -10.291  40.837  16.058  1.00 11.53      A    N  
ATOM    599  CA  GLN    86     -11.628  40.510  16.564  1.00 11.67      A    C  
ATOM    600  CB  GLN    86     -11.820  38.994  16.655  1.00 11.93      A    C  
ATOM    601  CG  GLN    86     -11.932  38.285  15.303  1.00 13.88      A    C  
ATOM    602  CD  GLN    86     -11.704  36.774  15.374  1.00 17.56      A    C  
ATOM    603  OE1 GLN    86     -11.899  36.136  16.414  1.00 17.76      A    O  
ATOM    604  NE2 GLN    86     -11.292  36.193  14.239  1.00 19.92      A    N  
ATOM    605  C   GLN    86     -11.823  41.102  17.946  1.00 11.71      A    C  
ATOM    606  O   GLN    86     -11.004  40.885  18.844  1.00 11.32      A    O  
ATOM    607  N   ARG    87     -12.933  41.809  18.136  1.00 11.69      A    N  
ATOM    608  CA  ARG    87     -13.265  42.348  19.462  1.00 11.99      A    C  
ATOM    609  CB  ARG    87     -14.031  43.668  19.309  1.00 12.89      A    C  
ATOM    610  CG  ARG    87     -14.273  44.445  20.605  1.00 14.41      A    C  
ATOM    611  CD  ARG    87     -15.091  45.710  20.314  1.00 20.91      A    C  
ATOM    612  NE  ARG    87     -14.431  46.515  19.294  1.00 25.76      A    N  
ATOM    613  CZ  ARG    87     -14.793  46.590  18.015  1.00 26.20      A    C  
ATOM    614  NH1 ARG    87     -15.862  45.927  17.562  1.00 27.13      A    N  
ATOM    615  NH2 ARG    87     -14.078  47.337  17.184  1.00 25.93      A    N  
ATOM    616  C   ARG    87     -14.096  41.313  20.202  1.00 12.26      A    C  
ATOM    617  O   ARG    87     -15.322  41.471  20.361  1.00 12.43      A    O  
ATOM    618  N   LEU    88     -13.453  40.236  20.648  1.00 10.62      A    N  
ATOM    619  CA  LEU    88     -14.241  39.100  21.116  1.00 11.30      A    C  
ATOM    620  CB  LEU    88     -13.617  37.759  20.741  1.00 12.92      A    C  
ATOM    621  CG  LEU    88     -12.107  37.634  20.707  1.00 16.29      A    C  
ATOM    622  CD1 LEU    88     -11.483  38.125  21.990  1.00 18.49      A    C  
ATOM    623  CD2 LEU    88     -11.729  36.191  20.433  1.00 18.42      A    C  
ATOM    624  C   LEU    88     -14.594  39.127  22.586  1.00  9.68      A    C  
ATOM    625  O   LEU    88     -15.452  38.364  23.027  1.00  9.63      A    O  
ATOM    626  N   GLY    89     -13.950  40.009  23.345  1.00  8.23      A    N  
ATOM    627  CA  GLY    89     -14.279  40.148  24.753  1.00  8.07      A    C  
ATOM    628  C   GLY    89     -13.477  39.183  25.614  1.00  7.92      A    C  
ATOM    629  O   GLY    89     -12.870  38.230  25.114  1.00  7.11      A    O  
ATOM    630  N   LYS    90     -13.508  39.426  26.918  1.00  7.81      A    N  
ATOM    631  CA  LYS    90     -12.735  38.656  27.887  1.00  7.49      A    C  
ATOM    632  CB  LYS    90     -11.427  39.394  28.131  1.00  7.84      A    C  
ATOM    633  CG  LYS    90     -10.691  39.060  29.412  1.00  9.00      A    C  
ATOM    634  CD  LYS    90      -9.432  39.914  29.414  1.00 13.02      A    C  
ATOM    635  CE  LYS    90      -8.967  40.280  30.789  1.00 16.81      A    C  
ATOM    636  NZ  LYS    90      -7.546  40.741  30.725  1.00 15.31      A    N  
ATOM    637  C   LYS    90     -13.507  38.559  29.184  1.00  7.93      A    C  
ATOM    638  O   LYS    90     -14.272  39.470  29.515  1.00  7.95      A    O  
ATOM    639  N   LEU    91     -13.337  37.448  29.903  1.00  7.09      A    N  
ATOM    640  CA  LEU    91     -13.840  37.326  31.272  1.00  7.34      A    C  
ATOM    641  CB  LEU    91     -14.664  36.055  31.441  1.00  8.01      A    C  
ATOM    642  CG  LEU    91     -15.830  35.856  30.473  1.00 12.27      A    C  
ATOM    643  CD1 LEU    91     -16.554  34.549  30.737  1.00 15.66      A    C  
ATOM    644  CD2 LEU    91     -16.777  37.000  30.617  1.00 14.57      A    C  
ATOM    645  C   LEU    91     -12.650  37.235  32.212  1.00  7.37      A    C  
ATOM    646  O   LEU    91     -11.741  36.422  31.976  1.00  6.40      A    O  
ATOM    647  N   ILE    92     -12.639  38.075  33.247  1.00  6.71      A    N  
ATOM    648  CA  ILE    92     -11.746  37.875  34.380  1.00  7.10      A    C  
ATOM    649  CB  ILE    92     -11.371  39.195  35.053  1.00  6.40      A    C  
ATOM    650  CG1 ILE    92     -10.573  40.055  34.080  1.00  8.68      A    C  
ATOM    651  CD1 ILE    92     -10.285  41.480  34.618  1.00  8.17      A    C  
ATOM    652  CG2 ILE    92     -10.529  38.921  36.285  1.00  8.16      A    C  
ATOM    653  C   ILE    92     -12.543  37.035  35.353  1.00  7.55      A    C  
ATOM    654  O   ILE    92     -13.602  37.474  35.808  1.00  7.25      A    O  
ATOM    655  N   VAL    93     -12.060  35.828  35.642  1.00  6.72      A    N  
ATOM    656  CA  VAL    93     -12.872  34.870  36.404  1.00  7.87      A    C  
ATOM    657  CB  VAL    93     -13.009  33.514  35.645  1.00  7.58      A    C  
ATOM    658  CG1 VAL    93     -13.709  33.730  34.311  1.00  8.64      A    C  
ATOM    659  CG2 VAL    93     -11.628  32.870  35.444  1.00  7.96      A    C  
ATOM    660  C   VAL    93     -12.333  34.642  37.802  1.00  8.68      A    C  
ATOM    661  O   VAL    93     -11.124  34.456  37.980  1.00  8.93      A    O  
ATOM    662  N   ALA    94     -13.237  34.689  38.788  1.00  8.80      A    N  
ATOM    663  CA  ALA    94     -12.923  34.353  40.179  1.00  9.50      A    C  
ATOM    664  CB  ALA    94     -13.704  35.269  41.152  1.00  9.26      A    C  
ATOM    665  C   ALA    94     -13.302  32.890  40.411  1.00 10.61      A    C  
ATOM    666  O   ALA    94     -14.404  32.470  40.052  1.00 11.06      A    O  
ATOM    667  N   THR    95     -12.400  32.114  41.003  1.00 11.54      A    N  
ATOM    668  CA  THR    95     -12.683  30.697  41.212  1.00 12.50      A    C  
ATOM    669  CB  THR    95     -11.698  29.798  40.436  1.00 12.97      A    C  
ATOM    670  OG1 THR    95     -10.366  30.087  40.852  1.00 13.56      A    O  
ATOM    671  CG2 THR    95     -11.841  30.043  38.944  1.00 14.34      A    C  
ATOM    672  C   THR    95     -12.754  30.313  42.701  1.00 12.82      A    C  
ATOM    673  O   THR    95     -12.652  29.134  43.063  1.00 13.39      A    O  
ATOM    674  N   SER    96     -12.962  31.318  43.548  1.00 12.55      A    N  
ATOM    675  CA  SER    96     -13.217  31.103  44.967  1.00 12.29      A    C  
ATOM    676  CB  SER    96     -11.906  30.932  45.746  1.00 12.43      A    C  
ATOM    677  OG  SER    96     -11.225  32.172  45.884  1.00 10.79      A    O  
ATOM    678  C   SER    96     -13.987  32.317  45.482  1.00 13.35      A    C  
ATOM    679  O   SER    96     -14.070  33.341  44.799  1.00 13.14      A    O  
ATOM    680  N   ASP    97     -14.578  32.201  46.668  1.00 13.76      A    N  
ATOM    681  CA  ASP    97     -15.234  33.357  47.273  1.00 14.33      A    C  
ATOM    682  CB  ASP    97     -15.897  32.977  48.602  1.00 15.48      A    C  
ATOM    683  CG  ASP    97     -17.086  32.073  48.430  1.00 18.72      A    C  
ATOM    684  OD1 ASP    97     -17.653  31.983  47.316  1.00 20.38      A    O  
ATOM    685  OD2 ASP    97     -17.480  31.454  49.447  1.00 22.82      A    O  
ATOM    686  C   ASP    97     -14.245  34.495  47.533  1.00 13.36      A    C  
ATOM    687  O   ASP    97     -14.590  35.664  47.345  1.00 13.75      A    O  
ATOM    688  N   ALA    98     -13.033  34.171  47.982  1.00 12.77      A    N  
ATOM    689  CA  ALA    98     -12.038  35.218  48.256  1.00 12.41      A    C  
ATOM    690  CB  ALA    98     -10.769  34.619  48.857  1.00 13.38      A    C  
ATOM    691  C   ALA    98     -11.716  35.984  46.972  1.00 11.71      A    C  
ATOM    692  O   ALA    98     -11.676  37.212  46.954  1.00 10.94      A    O  
ATOM    693  N   GLU    99     -11.518  35.254  45.877  1.00 11.04      A    N  
ATOM    694  CA  GLU    99     -11.274  35.910  44.589  1.00 10.61      A    C  
ATOM    695  CB  GLU    99     -10.896  34.877  43.532  1.00 10.42      A    C  
ATOM    696  CG  GLU    99      -9.552  34.251  43.837  1.00 10.44      A    C  
ATOM    697  CD  GLU    99      -9.021  33.408  42.695  1.00 11.98      A    C  
ATOM    698  OE1 GLU    99      -9.779  33.116  41.748  1.00 11.82      A    O  
ATOM    699  OE2 GLU    99      -7.832  33.046  42.759  1.00 14.81      A    O  
ATOM    700  C   GLU    99     -12.462  36.727  44.108  1.00 10.14      A    C  
ATOM    701  O   GLU    99     -12.287  37.799  43.506  1.00  9.42      A    O  
ATOM    702  N   ALA   100     -13.669  36.220  44.353  1.00  9.81      A    N  
ATOM    703  CA  ALA   100     -14.864  36.939  43.928  1.00  9.80      A    C  
ATOM    704  CB  ALA   100     -16.112  36.138  44.236  1.00 10.31      A    C  
ATOM    705  C   ALA   100     -14.913  38.301  44.619  1.00  9.95      A    C  
ATOM    706  O   ALA   100     -15.399  39.279  44.038  1.00  9.60      A    O  
ATOM    707  N   SER   101     -14.411  38.347  45.851  1.00  9.51      A    N  
ATOM    708  CA  SER   101     -14.391  39.583  46.635  1.00 10.70      A    C  
ATOM    709  CB  SER   101     -14.057  39.273  48.093  1.00 11.53      A    C  
ATOM    710  OG  SER   101     -15.161  38.608  48.693  1.00 17.43      A    O  
ATOM    711  C   SER   101     -13.428  40.629  46.090  1.00 10.14      A    C  
ATOM    712  O   SER   101     -13.536  41.822  46.439  1.00 10.35      A    O  
ATOM    713  N   GLN   102     -12.500  40.189  45.241  1.00  8.68      A    N  
ATOM    714  CA  GLN   102     -11.491  41.073  44.649  1.00  7.88      A    C  
ATOM    715  CB  GLN   102     -10.244  40.253  44.285  1.00  7.99      A    C  
ATOM    716  CG  GLN   102      -9.545  39.752  45.539  1.00  9.55      A    C  
ATOM    717  CD  GLN   102      -8.329  38.929  45.250  1.00 12.22      A    C  
ATOM    718  OE1 GLN   102      -8.312  38.164  44.297  1.00 11.23      A    O  
ATOM    719  NE2 GLN   102      -7.296  39.067  46.084  1.00 14.05      A    N  
ATOM    720  C   GLN   102     -12.004  41.836  43.439  1.00  7.47      A    C  
ATOM    721  O   GLN   102     -11.404  42.827  43.019  1.00  7.61      A    O  
ATOM    722  N   LEU   103     -13.133  41.379  42.883  1.00  7.16      A    N  
ATOM    723  CA  LEU   103     -13.582  41.909  41.593  1.00  7.26      A    C  
ATOM    724  CB  LEU   103     -14.694  41.030  41.005  1.00  6.51      A    C  
ATOM    725  CG  LEU   103     -14.328  39.589  40.608  1.00  7.86      A    C  
ATOM    726  CD1 LEU   103     -15.549  38.902  39.995  1.00  7.61      A    C  
ATOM    727  CD2 LEU   103     -13.159  39.544  39.646  1.00  8.32      A    C  
ATOM    728  C   LEU   103     -14.023  43.379  41.668  1.00  7.37      A    C  
ATOM    729  O   LEU   103     -13.803  44.160  40.728  1.00  7.45      A    O  
ATOM    730  N   ASP   104     -14.645  43.770  42.775  1.00  8.24      A    N  
ATOM    731  CA  ASP   104     -15.186  45.132  42.828  1.00  8.79      A    C  
ATOM    732  CB  ASP   104     -15.919  45.389  44.137  1.00  9.63      A    C  
ATOM    733  CG  ASP   104     -17.371  44.900  44.122  1.00 13.58      A    C  
ATOM    734  OD1 ASP   104     -17.931  44.588  43.046  1.00 16.04      A    O  
ATOM    735  OD2 ASP   104     -17.967  44.853  45.217  1.00 16.17      A    O  
ATOM    736  C   ASP   104     -14.042  46.140  42.666  1.00  8.10      A    C  
ATOM    737  O   ASP   104     -14.156  47.117  41.920  1.00  8.37      A    O  
ATOM    738  N   SER   105     -12.935  45.909  43.370  1.00  7.66      A    N  
ATOM    739  CA  SER   105     -11.822  46.866  43.350  1.00  7.70      A    C  
ATOM    740  CB  SER   105     -10.786  46.490  44.418  1.00  8.34      A    C  
ATOM    741  OG  SER   105      -9.675  47.379  44.362  1.00 13.63      A    O  
ATOM    742  C   SER   105     -11.162  46.878  41.977  1.00  7.19      A    C  
ATOM    743  O   SER   105     -10.722  47.915  41.467  1.00  7.04      A    O  
ATOM    744  N   ILE   106     -11.082  45.702  41.368  1.00  6.71      A    N  
ATOM    745  CA  ILE   106     -10.522  45.617  40.020  1.00  6.69      A    C  
ATOM    746  CB  ILE   106     -10.476  44.143  39.556  1.00  6.42      A    C  
ATOM    747  CG1 ILE   106      -9.456  43.362  40.384  1.00  6.41      A    C  
ATOM    748  CD1 ILE   106      -9.572  41.854  40.154  1.00  7.76      A    C  
ATOM    749  CG2 ILE   106     -10.096  44.037  38.076  1.00  7.38      A    C  
ATOM    750  C   ILE   106     -11.352  46.464  39.041  1.00  6.80      A    C  
ATOM    751  O   ILE   106     -10.811  47.213  38.229  1.00  7.18      A    O  
ATOM    752  N   ALA   107     -12.677  46.348  39.115  1.00  7.29      A    N  
ATOM    753  CA  ALA   107     -13.541  47.146  38.238  1.00  7.35      A    C  
ATOM    754  CB  ALA   107     -15.003  46.727  38.393  1.00  8.25      A    C  
ATOM    755  C   ALA   107     -13.392  48.646  38.508  1.00  8.04      A    C  
ATOM    756  O   ALA   107     -13.462  49.456  37.579  1.00  7.76      A    O  
ATOM    757  N   ARG   108     -13.203  49.020  39.767  1.00  7.42      A    N  
ATOM    758  CA  ARG   108     -12.992  50.438  40.090  1.00  7.90      A    C  
ATOM    759  CB  ARG   108     -13.087  50.666  41.605  1.00  8.29      A    C  
ATOM    760  CG  ARG   108     -14.499  50.462  42.121  1.00  9.36      A    C  
ATOM    761  CD  ARG   108     -14.615  50.678  43.605  1.00 15.68      A    C  
ATOM    762  NE  ARG   108     -15.910  50.199  44.077  1.00 20.10      A    N  
ATOM    763  CZ  ARG   108     -16.080  49.241  44.985  1.00 22.84      A    C  
ATOM    764  NH1 ARG   108     -15.032  48.639  45.554  1.00 22.97      A    N  
ATOM    765  NH2 ARG   108     -17.309  48.878  45.326  1.00 23.77      A    N  
ATOM    766  C   ARG   108     -11.668  50.945  39.519  1.00  7.91      A    C  
ATOM    767  O   ARG   108     -11.569  52.084  39.044  1.00  9.07      A    O  
ATOM    768  N   ARG   109     -10.638  50.104  39.542  1.00  7.76      A    N  
ATOM    769  CA  ARG   109      -9.363  50.538  38.958  1.00  8.02      A    C  
ATOM    770  CB  ARG   109      -8.236  49.535  39.225  1.00  7.91      A    C  
ATOM    771  CG  ARG   109      -6.935  50.049  38.675  1.00  7.80      A    C  
ATOM    772  CD  ARG   109      -5.766  49.156  39.053  1.00  7.81      A    C  
ATOM    773  NE  ARG   109      -5.528  49.147  40.493  1.00  9.55      A    N  
ATOM    774  CZ  ARG   109      -4.473  48.561  41.060  1.00 11.61      A    C  
ATOM    775  NH1 ARG   109      -3.556  47.968  40.289  1.00 11.06      A    N  
ATOM    776  NH2 ARG   109      -4.335  48.572  42.383  1.00 10.41      A    N  
ATOM    777  C   ARG   109      -9.514  50.766  37.464  1.00  8.06      A    C  
ATOM    778  O   ARG   109      -9.035  51.774  36.924  1.00  7.99      A    O  
ATOM    779  N   ALA   110     -10.196  49.840  36.796  1.00  8.57      A    N  
ATOM    780  CA  ALA   110     -10.429  49.939  35.355  1.00  8.03      A    C  
ATOM    781  CB  ALA   110     -11.232  48.750  34.872  1.00  8.74      A    C  
ATOM    782  C   ALA   110     -11.189  51.233  35.070  1.00  8.42      A    C  
ATOM    783  O   ALA   110     -10.843  51.970  34.155  1.00  8.72      A    O  
ATOM    784  N   GLY   111     -12.226  51.499  35.849  1.00  8.72      A    N  
ATOM    785  CA  GLY   111     -13.012  52.725  35.640  1.00  9.25      A    C  
ATOM    786  C   GLY   111     -12.139  53.965  35.705  1.00 10.46      A    C  
ATOM    787  O   GLY   111     -12.298  54.901  34.900  1.00 11.07      A    O  
ATOM    788  N   ALA   112     -11.207  53.982  36.647  1.00  9.87      A    N  
ATOM    789  CA  ALA   112     -10.353  55.142  36.839  1.00 10.21      A    C  
ATOM    790  CB  ALA   112      -9.618  55.060  38.163  1.00 10.82      A    C  
ATOM    791  C   ALA   112      -9.377  55.306  35.689  1.00 10.06      A    C  
ATOM    792  O   ALA   112      -8.877  56.405  35.445  1.00 11.14      A    O  
ATOM    793  N   ASN   113      -9.088  54.201  34.993  1.00  9.16      A    N  
ATOM    794  CA  ASN   113      -8.221  54.236  33.813  1.00  8.58      A    C  
ATOM    795  CB  ASN   113      -7.544  52.867  33.610  1.00  8.54      A    C  
ATOM    796  CG  ASN   113      -6.440  52.615  34.610  1.00  8.49      A    C  
ATOM    797  OD1 ASN   113      -5.916  53.557  35.226  1.00 10.25      A    O  
ATOM    798  ND2 ASN   113      -6.090  51.336  34.802  1.00  8.99      A    N  
ATOM    799  C   ASN   113      -8.962  54.614  32.529  1.00  9.31      A    C  
ATOM    800  O   ASN   113      -8.355  54.705  31.436  1.00  8.68      A    O  
ATOM    801  N   GLY   114     -10.267  54.817  32.654  1.00  9.70      A    N  
ATOM    802  CA  GLY   114     -11.121  55.088  31.496  1.00 11.28      A    C  
ATOM    803  C   GLY   114     -11.697  53.858  30.805  1.00 11.74      A    C  
ATOM    804  O   GLY   114     -12.109  53.922  29.638  1.00 13.21      A    O  
ATOM    805  N   VAL   115     -11.737  52.734  31.515  1.00 11.48      A    N  
ATOM    806  CA  VAL   115     -12.386  51.534  31.014  1.00 11.45      A    C  
ATOM    807  CB  VAL   115     -11.535  50.271  31.295  1.00 10.60      A    C  
ATOM    808  CG1 VAL   115     -12.212  49.040  30.711  1.00 12.53      A    C  
ATOM    809  CG2 VAL   115     -10.120  50.450  30.738  1.00 13.32      A    C  
ATOM    810  C   VAL   115     -13.709  51.420  31.746  1.00 12.02      A    C  
ATOM    811  O   VAL   115     -13.766  51.014  32.895  1.00 11.16      A    O  
ATOM    812  N   ASP   116     -14.784  51.832  31.103  1.00 13.59      A    N  
ATOM    813  CA  ASP   116     -15.992  51.963  31.880  1.00 15.54      A    C  
ATOM    814  CB  ASP   116     -16.457  53.432  31.940  1.00 16.87      A    C  
ATOM    815  CG  ASP   116     -15.604  54.279  32.907  1.00 19.81      A    C  
ATOM    816  OD1 ASP   116     -16.016  54.458  34.075  1.00 26.33      A    O  
ATOM    817  OD2 ASP   116     -14.505  54.740  32.527  1.00 21.36      A    O  
ATOM    818  C   ASP   116     -17.075  50.984  31.423  1.00 15.16      A    C  
ATOM    819  O   ASP   116     -18.230  51.092  31.840  1.00 17.09      A    O  
ATOM    820  N   ASP   117     -16.672  49.982  30.643  1.00 12.69      A    N  
ATOM    821  CA  ASP   117     -17.614  48.992  30.133  1.00 11.33      A    C  
ATOM    822  CB  ASP   117     -17.478  48.839  28.616  1.00 11.97      A    C  
ATOM    823  CG  ASP   117     -16.115  48.341  28.197  1.00 13.56      A    C  
ATOM    824  OD1 ASP   117     -15.264  48.117  29.083  1.00 11.65      A    O  
ATOM    825  OD2 ASP   117     -15.912  48.155  26.981  1.00 15.47      A    O  
ATOM    826  C   ASP   117     -17.543  47.618  30.804  1.00 10.19      A    C  
ATOM    827  O   ASP   117     -18.091  46.648  30.269  1.00  9.96      A    O  
ATOM    828  N   LEU   118     -16.887  47.511  31.957  1.00  9.45      A    N  
ATOM    829  CA  LEU   118     -16.838  46.185  32.609  1.00  9.46      A    C  
ATOM    830  CB  LEU   118     -15.809  46.120  33.738  1.00  9.00      A    C  
ATOM    831  CG  LEU   118     -14.355  46.415  33.367  1.00 11.18      A    C  
ATOM    832  CD1 LEU   118     -13.426  45.906  34.467  1.00 11.89      A    C  
ATOM    833  CD2 LEU   118     -13.983  45.779  32.025  1.00 12.04      A    C  
ATOM    834  C   LEU   118     -18.208  45.804  33.146  1.00 10.13      A    C  
ATOM    835  O   LEU   118     -19.002  46.675  33.507  1.00 10.94      A    O  
ATOM    836  N   GLN   119     -18.492  44.506  33.183  1.00  8.74      A    N  
ATOM    837  CA  GLN   119     -19.769  44.023  33.699  1.00  8.51      A    C  
ATOM    838  CB  GLN   119     -20.575  43.355  32.575  1.00  8.34      A    C  
ATOM    839  CG  GLN   119     -20.815  44.275  31.368  1.00 11.21      A    C  
ATOM    840  CD  GLN   119     -21.022  43.542  30.044  1.00 16.69      A    C  
ATOM    841  OE1 GLN   119     -20.068  43.037  29.427  1.00 21.22      A    O  
ATOM    842  NE2 GLN   119     -22.261  43.521  29.578  1.00 19.52      A    N  
ATOM    843  C   GLN   119     -19.476  42.994  34.781  1.00  8.64      A    C  
ATOM    844  O   GLN   119     -18.814  41.996  34.511  1.00  9.81      A    O  
ATOM    845  N   HIS   120     -19.995  43.216  35.983  1.00  8.48      A    N  
ATOM    846  CA  HIS   120     -19.736  42.320  37.103  1.00  8.47      A    C  
ATOM    847  CB  HIS   120     -19.609  43.152  38.379  1.00  8.76      A    C  
ATOM    848  CG  HIS   120     -19.097  42.399  39.565  1.00 10.10      A    C  
ATOM    849  ND1 HIS   120     -18.554  43.039  40.655  1.00 10.85      A    N  
ATOM    850  CE1 HIS   120     -18.200  42.140  41.560  1.00 11.17      A    C  
ATOM    851  NE2 HIS   120     -18.493  40.940  41.091  1.00 12.17      A    N  
ATOM    852  CD2 HIS   120     -19.053  41.074  39.841  1.00 11.02      A    C  
ATOM    853  C   HIS   120     -20.913  41.373  37.203  1.00  8.24      A    C  
ATOM    854  O   HIS   120     -22.040  41.826  37.399  1.00  9.20      A    O  
ATOM    855  N   ILE   121     -20.655  40.073  37.061  1.00  8.14      A    N  
ATOM    856  CA  ILE   121     -21.726  39.069  37.013  1.00  8.68      A    C  
ATOM    857  CB  ILE   121     -22.019  38.603  35.555  1.00  8.35      A    C  
ATOM    858  CG1 ILE   121     -20.833  37.820  34.976  1.00  9.73      A    C  
ATOM    859  CD1 ILE   121     -21.018  37.429  33.522  1.00  9.21      A    C  
ATOM    860  CG2 ILE   121     -22.390  39.799  34.670  1.00 10.25      A    C  
ATOM    861  C   ILE   121     -21.387  37.870  37.897  1.00  9.26      A    C  
ATOM    862  O   ILE   121     -20.231  37.678  38.255  1.00  9.54      A    O  
ATOM    863  N   ASP   122     -22.405  37.092  38.269  1.00  9.73      A    N  
ATOM    864  CA  ASP   122     -22.188  35.908  39.106  1.00 10.86      A    C  
ATOM    865  CB  ASP   122     -23.354  35.676  40.093  1.00 11.61      A    C  
ATOM    866  CG  ASP   122     -24.672  35.249  39.421  1.00 13.45      A    C  
ATOM    867  OD1 ASP   122     -24.695  34.799  38.247  1.00 14.14      A    O  
ATOM    868  OD2 ASP   122     -25.716  35.331  40.126  1.00 15.48      A    O  
ATOM    869  C   ASP   122     -21.845  34.691  38.265  1.00 10.57      A    C  
ATOM    870  O   ASP   122     -21.785  34.777  37.039  1.00 10.96      A    O  
ATOM    871  N   GLY   123     -21.563  33.559  38.908  1.00 11.14      A    N  
ATOM    872  CA  GLY   123     -21.061  32.405  38.165  1.00 11.24      A    C  
ATOM    873  C   GLY   123     -22.102  31.799  37.236  1.00 10.96      A    C  
ATOM    874  O   GLY   123     -21.777  31.279  36.165  1.00 10.79      A    O  
ATOM    875  N   ALA   124     -23.365  31.871  37.641  1.00 11.37      A    N  
ATOM    876  CA  ALA   124     -24.425  31.317  36.818  1.00 11.90      A    C  
ATOM    877  CB  ALA   124     -25.736  31.283  37.574  1.00 12.51      A    C  
ATOM    878  C   ALA   124     -24.551  32.145  35.559  1.00 11.88      A    C  
ATOM    879  O   ALA   124     -24.719  31.600  34.460  1.00 12.27      A    O  
ATOM    880  N   ALA   125     -24.464  33.468  35.710  1.00 11.08      A    N  
ATOM    881  CA  ALA   125     -24.471  34.355  34.540  1.00 11.35      A    C  
ATOM    882  CB  ALA   125     -24.527  35.840  34.954  1.00 10.70      A    C  
ATOM    883  C   ALA   125     -23.276  34.090  33.625  1.00 11.48      A    C  
ATOM    884  O   ALA   125     -23.409  34.069  32.397  1.00 12.27      A    O  
ATOM    885  N   ALA   126     -22.113  33.851  34.226  1.00 11.56      A    N  
ATOM    886  CA  ALA   126     -20.917  33.609  33.443  1.00 11.94      A    C  
ATOM    887  CB  ALA   126     -19.703  33.540  34.342  1.00 11.91      A    C  
ATOM    888  C   ALA   126     -21.073  32.313  32.670  1.00 12.63      A    C  
ATOM    889  O   ALA   126     -20.632  32.228  31.526  1.00 12.77      A    O  
ATOM    890  N   ARG   127     -21.703  31.312  33.290  1.00 13.27      A    N  
ATOM    891  CA  ARG   127     -21.963  30.046  32.598  1.00 15.12      A    C  
ATOM    892  CB  ARG   127     -22.409  28.938  33.557  1.00 15.73      A    C  
ATOM    893  CG  ARG   127     -22.422  27.574  32.871  1.00 19.72      A    C  
ATOM    894  CD  ARG   127     -23.038  26.512  33.742  1.00 28.32      A    C  
ATOM    895  NE  ARG   127     -22.144  26.082  34.814  1.00 32.45      A    N  
ATOM    896  CZ  ARG   127     -20.915  25.609  34.628  1.00 34.53      A    C  
ATOM    897  NH1 ARG   127     -20.399  25.526  33.410  1.00 36.22      A    N  
ATOM    898  NH2 ARG   127     -20.192  25.241  35.674  1.00 35.62      A    N  
ATOM    899  C   ARG   127     -22.977  30.194  31.455  1.00 15.15      A    C  
ATOM    900  O   ARG   127     -22.910  29.453  30.475  1.00 15.26      A    O  
ATOM    901  N   ARG   128     -23.908  31.142  31.563  1.00 15.50      A    N  
ATOM    902  CA  ARG   128     -24.790  31.443  30.424  1.00 16.16      A    C  
ATOM    903  CB  ARG   128     -25.851  32.486  30.767  1.00 16.85      A    C  
ATOM    904  CG  ARG   128     -26.902  32.009  31.742  1.00 20.03      A    C  
ATOM    905  CD  ARG   128     -28.158  32.920  31.714  1.00 23.38      A    C  
ATOM    906  NE  ARG   128     -27.918  34.274  32.227  1.00 25.47      A    N  
ATOM    907  CZ  ARG   128     -27.910  34.592  33.519  1.00 27.33      A    C  
ATOM    908  NH1 ARG   128     -28.118  33.653  34.446  1.00 27.69      A    N  
ATOM    909  NH2 ARG   128     -27.688  35.847  33.891  1.00 26.88      A    N  
ATOM    910  C   ARG   128     -23.991  31.946  29.232  1.00 15.98      A    C  
ATOM    911  O   ARG   128     -24.267  31.573  28.086  1.00 15.86      A    O  
ATOM    912  N   LEU   129     -23.008  32.801  29.506  1.00 14.53      A    N  
ATOM    913  CA  LEU   129     -22.157  33.354  28.466  1.00 14.54      A    C  
ATOM    914  CB  LEU   129     -21.324  34.523  29.013  1.00 14.23      A    C  
ATOM    915  CG  LEU   129     -22.077  35.802  29.379  1.00 15.66      A    C  
ATOM    916  CD1 LEU   129     -21.063  36.888  29.787  1.00 13.86      A    C  
ATOM    917  CD2 LEU   129     -22.936  36.264  28.210  1.00 17.99      A    C  
ATOM    918  C   LEU   129     -21.224  32.286  27.899  1.00 14.19      A    C  
ATOM    919  O   LEU   129     -20.954  32.262  26.691  1.00 14.72      A    O  
ATOM    920  N   GLU   130     -20.714  31.429  28.780  1.00 13.72      A    N  
ATOM    921  CA  GLU   130     -19.693  30.447  28.403  1.00 13.56      A    C  
ATOM    922  CB  GLU   130     -18.301  30.918  28.843  1.00 13.55      A    C  
ATOM    923  CG  GLU   130     -17.812  32.200  28.176  1.00 12.68      A    C  
ATOM    924  CD  GLU   130     -17.538  32.055  26.680  1.00 15.70      A    C  
ATOM    925  OE1 GLU   130     -17.409  30.913  26.192  1.00 15.22      A    O  
ATOM    926  OE2 GLU   130     -17.450  33.099  25.993  1.00 16.47      A    O  
ATOM    927  C   GLU   130     -19.994  29.120  29.069  1.00 13.88      A    C  
ATOM    928  O   GLU   130     -19.589  28.887  30.202  1.00 13.11      A    O  
ATOM    929  N   PRO   131     -20.737  28.253  28.372  1.00 14.53      A    N  
ATOM    930  CA  PRO   131     -21.213  26.989  28.923  1.00 15.31      A    C  
ATOM    931  CB  PRO   131     -21.841  26.302  27.703  1.00 15.14      A    C  
ATOM    932  CG  PRO   131     -22.378  27.450  26.909  1.00 15.68      A    C  
ATOM    933  CD  PRO   131     -21.346  28.545  27.061  1.00 15.28      A    C  
ATOM    934  C   PRO   131     -20.140  26.105  29.568  1.00 15.38      A    C  
ATOM    935  O   PRO   131     -20.448  25.354  30.491  1.00 16.32      A    O  
ATOM    936  N   ALA   132     -18.896  26.197  29.118  1.00 15.33      A    N  
ATOM    937  CA  ALA   132     -17.847  25.328  29.668  1.00 15.52      A    C  
ATOM    938  CB  ALA   132     -16.771  25.078  28.617  1.00 16.38      A    C  
ATOM    939  C   ALA   132     -17.208  25.875  30.945  1.00 15.75      A    C  
ATOM    940  O   ALA   132     -16.409  25.189  31.603  1.00 15.42      A    O  
ATOM    941  N   LEU   133     -17.577  27.104  31.303  1.00 14.25      A    N  
ATOM    942  CA  LEU   133     -16.881  27.834  32.363  1.00 14.20      A    C  
ATOM    943  CB  LEU   133     -17.013  29.332  32.104  1.00 13.32      A    C  
ATOM    944  CG  LEU   133     -16.291  30.281  33.061  1.00 13.73      A    C  
ATOM    945  CD1 LEU   133     -14.819  30.063  32.911  1.00 13.50      A    C  
ATOM    946  CD2 LEU   133     -16.631  31.749  32.722  1.00 13.79      A    C  
ATOM    947  C   LEU   133     -17.400  27.519  33.770  1.00 14.47      A    C  
ATOM    948  O   LEU   133     -18.607  27.572  34.019  1.00 15.12      A    O  
ATOM    949  N   HIS   134     -16.478  27.225  34.686  1.00 14.03      A    N  
ATOM    950  CA  HIS   134     -16.791  27.085  36.108  1.00 14.76      A    C  
ATOM    951  CB  HIS   134     -16.326  25.724  36.611  1.00 15.90      A    C  
ATOM    952  CG  HIS   134     -17.110  24.582  36.049  1.00 20.20      A    C  
ATOM    953  ND1 HIS   134     -17.115  24.268  34.704  1.00 24.70      A    N  
ATOM    954  CE1 HIS   134     -17.893  23.216  34.503  1.00 24.55      A    C  
ATOM    955  NE2 HIS   134     -18.387  22.834  35.668  1.00 26.33      A    N  
ATOM    956  CD2 HIS   134     -17.918  23.674  36.651  1.00 24.33      A    C  
ATOM    957  C   HIS   134     -16.131  28.199  36.914  1.00 13.53      A    C  
ATOM    958  O   HIS   134     -14.913  28.234  37.069  1.00 13.85      A    O  
ATOM    959  N   CYS   135     -16.927  29.153  37.383  1.00 12.51      A    N  
ATOM    960  CA  CYS   135     -16.371  30.209  38.219  1.00 11.65      A    C  
ATOM    961  CB  CYS   135     -15.875  31.389  37.375  1.00 11.43      A    C  
ATOM    962  SG  CYS   135     -17.216  32.398  36.638  1.00 12.32      A    S  
ATOM    963  C   CYS   135     -17.401  30.688  39.230  1.00 11.62      A    C  
ATOM    964  O   CYS   135     -18.592  30.391  39.108  1.00 12.40      A    O  
ATOM    965  N   THR   136     -16.925  31.458  40.205  1.00 10.92      A    N  
ATOM    966  CA  THR   136     -17.759  31.963  41.287  1.00 10.56      A    C  
ATOM    967  CB  THR   136     -16.915  32.176  42.555  1.00 11.24      A    C  
ATOM    968  OG1 THR   136     -16.345  30.909  42.944  1.00 13.55      A    O  
ATOM    969  CG2 THR   136     -17.777  32.718  43.690  1.00 11.81      A    C  
ATOM    970  C   THR   136     -18.403  33.284  40.877  1.00 10.16      A    C  
ATOM    971  O   THR   136     -19.545  33.552  41.213  1.00 10.24      A    O  
ATOM    972  N   ALA   137     -17.646  34.092  40.140  1.00  9.44      A    N  
ATOM    973  CA  ALA   137     -18.134  35.370  39.620  1.00  7.84      A    C  
ATOM    974  CB  ALA   137     -18.210  36.398  40.727  1.00  8.66      A    C  
ATOM    975  C   ALA   137     -17.164  35.822  38.552  1.00  7.88      A    C  
ATOM    976  O   ALA   137     -16.083  35.261  38.427  1.00  7.58      A    O  
ATOM    977  N   ALA   138     -17.527  36.831  37.767  1.00  6.45      A    N  
ATOM    978  CA  ALA   138     -16.600  37.287  36.739  1.00  6.77      A    C  
ATOM    979  CB  ALA   138     -16.755  36.458  35.465  1.00  5.81      A    C  
ATOM    980  C   ALA   138     -16.801  38.758  36.441  1.00  6.16      A    C  
ATOM    981  O   ALA   138     -17.863  39.324  36.754  1.00  7.09      A    O  
ATOM    982  N   LEU   139     -15.778  39.366  35.855  1.00  6.31      A    N  
ATOM    983  CA  LEU   139     -15.931  40.662  35.194  1.00  6.22      A    C  
ATOM    984  CB  LEU   139     -14.799  41.612  35.585  1.00  5.90      A    C  
ATOM    985  CG  LEU   139     -14.821  42.073  37.031  1.00  6.27      A    C  
ATOM    986  CD1 LEU   139     -13.501  42.801  37.369  1.00  8.20      A    C  
ATOM    987  CD2 LEU   139     -16.055  42.965  37.215  1.00  8.08      A    C  
ATOM    988  C   LEU   139     -15.845  40.430  33.699  1.00  6.93      A    C  
ATOM    989  O   LEU   139     -14.862  39.866  33.209  1.00  6.95      A    O  
ATOM    990  N   VAL   140     -16.857  40.882  32.971  1.00  6.51      A    N  
ATOM    991  CA  VAL   140     -16.795  40.888  31.522  1.00  7.14      A    C  
ATOM    992  CB  VAL   140     -18.203  40.794  30.884  1.00  7.16      A    C  
ATOM    993  CG1 VAL   140     -18.077  40.514  29.383  1.00  8.41      A    C  
ATOM    994  CG2 VAL   140     -19.015  39.715  31.557  1.00  8.16      A    C  
ATOM    995  C   VAL   140     -16.126  42.163  31.029  1.00  6.55      A    C  
ATOM    996  O   VAL   140     -16.484  43.262  31.452  1.00  7.58      A    O  
ATOM    997  N   SER   141     -15.179  42.009  30.103  1.00  6.10      A    N  
ATOM    998  CA  SER   141     -14.471  43.144  29.483  1.00  6.48      A    C  
ATOM    999  CB  SER   141     -12.967  43.087  29.802  1.00  5.90      A    C  
ATOM   1000  OG  SER   141     -12.256  44.072  29.083  1.00  6.81      A    O  
ATOM   1001  C   SER   141     -14.717  43.098  27.978  1.00  7.17      A    C  
ATOM   1002  O   SER   141     -13.993  42.443  27.229  1.00  7.47      A    O  
ATOM   1003  N   PRO   142     -15.766  43.796  27.523  1.00  7.70      A    N  
ATOM   1004  CA  PRO   142     -16.172  43.629  26.122  1.00  8.72      A    C  
ATOM   1005  CB  PRO   142     -17.576  44.249  26.053  1.00  9.16      A    C  
ATOM   1006  CG  PRO   142     -17.902  44.720  27.403  1.00  9.02      A    C  
ATOM   1007  CD  PRO   142     -16.733  44.549  28.335  1.00  8.19      A    C  
ATOM   1008  C   PRO   142     -15.234  44.264  25.106  1.00  9.17      A    C  
ATOM   1009  O   PRO   142     -15.268  43.884  23.930  1.00 10.78      A    O  
ATOM   1010  N   SER   143     -14.380  45.190  25.538  1.00  9.07      A    N  
ATOM   1011  CA  SER   143     -13.504  45.889  24.594  1.00  9.08      A    C  
ATOM   1012  CB  SER   143     -13.225  47.319  25.066  1.00  9.83      A    C  
ATOM   1013  OG  SER   143     -12.209  47.392  26.069  1.00 10.75      A    O  
ATOM   1014  C   SER   143     -12.193  45.128  24.333  1.00  8.98      A    C  
ATOM   1015  O   SER   143     -11.432  45.488  23.444  1.00  9.13      A    O  
ATOM   1016  N   THR   144     -11.939  44.088  25.121  1.00  7.62      A    N  
ATOM   1017  CA  THR   144     -10.721  43.289  24.934  1.00  7.76      A    C  
ATOM   1018  CB  THR   144     -10.529  42.313  26.113  1.00  7.89      A    C  
ATOM   1019  OG1 THR   144     -10.479  43.049  27.344  1.00  7.88      A    O  
ATOM   1020  CG2 THR   144      -9.238  41.507  25.945  1.00  7.59      A    C  
ATOM   1021  C   THR   144     -10.845  42.512  23.636  1.00  7.77      A    C  
ATOM   1022  O   THR   144     -11.920  41.986  23.336  1.00  8.55      A    O  
ATOM   1023  N   GLY   145      -9.767  42.459  22.853  1.00  7.14      A    N  
ATOM   1024  CA  GLY   145      -9.798  41.770  21.569  1.00  7.26      A    C  
ATOM   1025  C   GLY   145      -8.525  41.004  21.284  1.00  7.74      A    C  
ATOM   1026  O   GLY   145      -7.682  40.821  22.182  1.00  7.64      A    O  
ATOM   1027  N   ILE   146      -8.416  40.529  20.041  1.00  7.82      A    N  
ATOM   1028  CA  ILE   146      -7.192  39.904  19.534  1.00  8.08      A    C  
ATOM   1029  CB  ILE   146      -7.332  38.378  19.409  1.00  8.11      A    C  
ATOM   1030  CG1 ILE   146      -8.470  38.015  18.452  1.00  8.73      A    C  
ATOM   1031  CD1 ILE   146      -8.649  36.472  18.277  1.00  9.10      A    C  
ATOM   1032  CG2 ILE   146      -7.492  37.716  20.799  1.00  7.93      A    C  
ATOM   1033  C   ILE   146      -6.826  40.473  18.172  1.00  8.45      A    C  
ATOM   1034  O   ILE   146      -7.678  40.956  17.430  1.00  8.53      A    O  
ATOM   1035  N   VAL   147      -5.542  40.442  17.863  1.00  9.05      A    N  
ATOM   1036  CA  VAL   147      -5.032  40.986  16.605  1.00 10.93      A    C  
ATOM   1037  CB  VAL   147      -4.579  42.453  16.777  1.00 10.90      A    C  
ATOM   1038  CG1 VAL   147      -3.412  42.552  17.811  1.00 11.75      A    C  
ATOM   1039  CG2 VAL   147      -4.243  43.114  15.426  1.00 11.05      A    C  
ATOM   1040  C   VAL   147      -3.884  40.130  16.090  1.00 12.52      A    C  
ATOM   1041  O   VAL   147      -3.128  39.532  16.863  1.00 12.11      A    O  
ATOM   1042  N   ASP   148      -3.770  40.097  14.769  1.00 14.47      A    N  
ATOM   1043  CA  ASP   148      -2.664  39.450  14.093  1.00 16.95      A    C  
ATOM   1044  CB  ASP   148      -3.085  39.112  12.665  1.00 17.58      A    C  
ATOM   1045  CG  ASP   148      -1.964  38.477  11.847  1.00 21.13      A    C  
ATOM   1046  OD1 ASP   148      -0.775  38.668  12.182  1.00 23.02      A    O  
ATOM   1047  OD2 ASP   148      -2.295  37.779  10.861  1.00 24.53      A    O  
ATOM   1048  C   ASP   148      -1.506  40.422  14.093  1.00 16.87      A    C  
ATOM   1049  O   ASP   148      -1.511  41.396  13.345  1.00 17.36      A    O  
ATOM   1050  N   SER   149      -0.532  40.165  14.958  1.00 17.72      A    N  
ATOM   1051  CA  SER   149       0.528  41.121  15.224  1.00 18.68      A    C  
ATOM   1052  CB  SER   149       1.254  40.764  16.510  1.00 19.12      A    C  
ATOM   1053  OG  SER   149       1.909  39.516  16.379  1.00 22.53      A    O  
ATOM   1054  C   SER   149       1.504  41.170  14.066  1.00 18.52      A    C  
ATOM   1055  O   SER   149       2.071  42.227  13.770  1.00 18.58      A    O  
ATOM   1056  N   HIS   150       1.681  40.029  13.399  1.00 18.36      A    N  
ATOM   1057  CA  HIS   150       2.470  40.003  12.167  1.00 18.02      A    C  
ATOM   1058  CB  HIS   150       2.681  38.572  11.657  1.00 18.68      A    C  
ATOM   1059  CG  HIS   150       3.558  38.503  10.447  1.00 21.09      A    C  
ATOM   1060  ND1 HIS   150       4.884  38.882  10.472  1.00 25.40      A    N  
ATOM   1061  CE1 HIS   150       5.406  38.726   9.268  1.00 25.84      A    C  
ATOM   1062  NE2 HIS   150       4.462  38.273   8.461  1.00 25.44      A    N  
ATOM   1063  CD2 HIS   150       3.296  38.129   9.173  1.00 24.21      A    C  
ATOM   1064  C   HIS   150       1.853  40.888  11.079  1.00 16.84      A    C  
ATOM   1065  O   HIS   150       2.546  41.695  10.446  1.00 16.16      A    O  
ATOM   1066  N   ALA   151       0.545  40.763  10.873  1.00 16.24      A    N  
ATOM   1067  CA  ALA   151      -0.139  41.625   9.928  1.00 15.86      A    C  
ATOM   1068  CB  ALA   151      -1.597  41.246   9.813  1.00 16.38      A    C  
ATOM   1069  C   ALA   151      -0.014  43.080  10.356  1.00 15.47      A    C  
ATOM   1070  O   ALA   151       0.171  43.956   9.528  1.00 15.17      A    O  
ATOM   1071  N   LEU   152      -0.137  43.335  11.653  1.00 14.77      A    N  
ATOM   1072  CA  LEU   152      -0.056  44.710  12.140  1.00 14.27      A    C  
ATOM   1073  CB  LEU   152      -0.319  44.751  13.639  1.00 13.97      A    C  
ATOM   1074  CG  LEU   152      -0.373  46.128  14.281  1.00 13.87      A    C  
ATOM   1075  CD1 LEU   152      -1.591  46.910  13.748  1.00 11.37      A    C  
ATOM   1076  CD2 LEU   152      -0.468  45.935  15.789  1.00 11.28      A    C  
ATOM   1077  C   LEU   152       1.311  45.289  11.822  1.00 14.19      A    C  
ATOM   1078  O   LEU   152       1.419  46.393  11.319  1.00 13.70      A    O  
ATOM   1079  N   MET   153       2.357  44.515  12.099  1.00 14.92      A    N  
ATOM   1080  CA  MET   153       3.723  44.933  11.785  1.00 15.94      A    C  
ATOM   1081  CB  MET   153       4.716  43.865  12.236  1.00 16.58      A    C  
ATOM   1082  CG  MET   153       4.994  43.954  13.716  1.00 18.71      A    C  
ATOM   1083  SD  MET   153       6.135  42.731  14.333  1.00 25.55      A    S  
ATOM   1084  CE  MET   153       5.900  41.338  13.214  1.00 19.88      A    C  
ATOM   1085  C   MET   153       3.916  45.278  10.304  1.00 15.59      A    C  
ATOM   1086  O   MET   153       4.469  46.313   9.967  1.00 14.87      A    O  
ATOM   1087  N   LEU   154       3.444  44.406   9.426  1.00 15.91      A    N  
ATOM   1088  CA  LEU   154       3.581  44.625   7.994  1.00 16.35      A    C  
ATOM   1089  CB  LEU   154       3.024  43.412   7.241  1.00 17.02      A    C  
ATOM   1090  CG  LEU   154       3.863  42.144   7.359  1.00 19.65      A    C  
ATOM   1091  CD1 LEU   154       3.184  40.943   6.698  1.00 22.42      A    C  
ATOM   1092  CD2 LEU   154       5.226  42.393   6.731  1.00 22.25      A    C  
ATOM   1093  C   LEU   154       2.850  45.893   7.581  1.00 15.80      A    C  
ATOM   1094  O   LEU   154       3.295  46.623   6.696  1.00 15.54      A    O  
ATOM   1095  N   ALA   155       1.715  46.155   8.232  1.00 15.23      A    N  
ATOM   1096  CA  ALA   155       0.925  47.329   7.924  1.00 14.47      A    C  
ATOM   1097  CB  ALA   155      -0.490  47.232   8.577  1.00 14.80      A    C  
ATOM   1098  C   ALA   155       1.656  48.596   8.352  1.00 14.00      A    C  
ATOM   1099  O   ALA   155       1.692  49.576   7.606  1.00 14.23      A    O  
ATOM   1100  N   TYR   156       2.246  48.586   9.552  1.00 13.09      A    N  
ATOM   1101  CA  TYR   156       3.050  49.728  10.006  1.00 12.38      A    C  
ATOM   1102  CB  TYR   156       3.629  49.514  11.406  1.00 12.10      A    C  
ATOM   1103  CG  TYR   156       2.652  49.504  12.567  1.00 10.97      A    C  
ATOM   1104  CD1 TYR   156       1.308  49.845  12.400  1.00  9.82      A    C  
ATOM   1105  CE1 TYR   156       0.416  49.822  13.489  1.00 10.69      A    C  
ATOM   1106  CZ  TYR   156       0.891  49.518  14.757  1.00  9.74      A    C  
ATOM   1107  OH  TYR   156       0.036  49.505  15.850  1.00 10.56      A    O  
ATOM   1108  CE2 TYR   156       2.219  49.206  14.943  1.00 10.96      A    C  
ATOM   1109  CD2 TYR   156       3.096  49.209  13.850  1.00 11.32      A    C  
ATOM   1110  C   TYR   156       4.220  49.940   9.049  1.00 12.81      A    C  
ATOM   1111  O   TYR   156       4.559  51.070   8.709  1.00 12.43      A    O  
ATOM   1112  N   GLN   157       4.851  48.841   8.658  1.00 13.85      A    N  
ATOM   1113  CA  GLN   157       5.981  48.904   7.726  1.00 14.67      A    C  
ATOM   1114  CB  GLN   157       6.560  47.517   7.449  1.00 15.34      A    C  
ATOM   1115  CG  GLN   157       7.733  47.581   6.475  1.00 17.21      A    C  
ATOM   1116  CD  GLN   157       8.411  46.240   6.247  1.00 20.78      A    C  
ATOM   1117  OE1 GLN   157       8.147  45.261   6.941  1.00 23.92      A    O  
ATOM   1118  NE2 GLN   157       9.297  46.194   5.262  1.00 22.71      A    N  
ATOM   1119  C   GLN   157       5.576  49.552   6.417  1.00 14.89      A    C  
ATOM   1120  O   GLN   157       6.260  50.448   5.940  1.00 14.44      A    O  
ATOM   1121  N   GLY   158       4.482  49.068   5.828  1.00 15.07      A    N  
ATOM   1122  CA  GLY   158       3.913  49.666   4.616  1.00 15.81      A    C  
ATOM   1123  C   GLY   158       3.687  51.163   4.711  1.00 16.14      A    C  
ATOM   1124  O   GLY   158       4.078  51.917   3.818  1.00 16.18      A    O  
ATOM   1125  N   ASP   159       3.055  51.611   5.797  1.00 15.83      A    N  
ATOM   1126  CA  ASP   159       2.843  53.032   6.002  1.00 16.31      A    C  
ATOM   1127  CB  ASP   159       2.101  53.288   7.321  1.00 16.20      A    C  
ATOM   1128  CG  ASP   159       0.697  52.694   7.341  1.00 18.03      A    C  
ATOM   1129  OD1 ASP   159       0.209  52.235   6.279  1.00 18.03      A    O  
ATOM   1130  OD2 ASP   159       0.075  52.701   8.435  1.00 15.54      A    O  
ATOM   1131  C   ASP   159       4.153  53.809   6.029  1.00 16.11      A    C  
ATOM   1132  O   ASP   159       4.287  54.834   5.371  1.00 16.51      A    O  
ATOM   1133  N   ALA   160       5.122  53.338   6.809  1.00 16.03      A    N  
ATOM   1134  CA  ALA   160       6.379  54.061   6.948  1.00 15.64      A    C  
ATOM   1135  CB  ALA   160       7.279  53.375   7.976  1.00 15.92      A    C  
ATOM   1136  C   ALA   160       7.084  54.161   5.598  1.00 16.30      A    C  
ATOM   1137  O   ALA   160       7.596  55.223   5.225  1.00 15.95      A    O  
ATOM   1138  N   GLU   161       7.102  53.052   4.871  1.00 16.77      A    N  
ATOM   1139  CA  GLU   161       7.720  53.023   3.542  1.00 17.91      A    C  
ATOM   1140  CB  GLU   161       7.720  51.607   2.973  1.00 17.88      A    C  
ATOM   1141  CG  GLU   161       8.741  50.677   3.637  1.00 20.21      A    C  
ATOM   1142  CD  GLU   161       8.599  49.224   3.201  1.00 23.52      A    C  
ATOM   1143  OE1 GLU   161       7.532  48.844   2.680  1.00 26.93      A    O  
ATOM   1144  OE2 GLU   161       9.559  48.452   3.386  1.00 25.88      A    O  
ATOM   1145  C   GLU   161       7.024  53.986   2.584  1.00 18.29      A    C  
ATOM   1146  O   GLU   161       7.673  54.645   1.777  1.00 18.44      A    O  
ATOM   1147  N   SER   162       5.704  54.080   2.684  1.00 18.99      A    N  
ATOM   1148  CA  SER   162       4.956  55.017   1.843  1.00 19.41      A    C  
ATOM   1149  CB  SER   162       3.447  54.841   2.046  1.00 19.38      A    C  
ATOM   1150  OG  SER   162       2.985  55.633   3.131  1.00 23.20      A    O  
ATOM   1151  C   SER   162       5.377  56.468   2.090  1.00 19.47      A    C  
ATOM   1152  O   SER   162       5.243  57.324   1.206  1.00 19.90      A    O  
ATOM   1153  N   ASP   163       5.894  56.741   3.287  1.00 18.85      A    N  
ATOM   1154  CA  ASP   163       6.424  58.053   3.621  1.00 18.86      A    C  
ATOM   1155  CB  ASP   163       5.941  58.495   5.008  1.00 18.79      A    C  
ATOM   1156  CG  ASP   163       4.470  58.866   5.021  1.00 20.54      A    C  
ATOM   1157  OD1 ASP   163       3.996  59.411   3.996  1.00 20.38      A    O  
ATOM   1158  OD2 ASP   163       3.791  58.631   6.055  1.00 20.98      A    O  
ATOM   1159  C   ASP   163       7.952  58.064   3.563  1.00 18.06      A    C  
ATOM   1160  O   ASP   163       8.595  58.866   4.225  1.00 18.31      A    O  
ATOM   1161  N   GLY   164       8.512  57.166   2.760  1.00 18.01      A    N  
ATOM   1162  CA  GLY   164       9.936  57.192   2.425  1.00 17.80      A    C  
ATOM   1163  C   GLY   164      10.883  56.463   3.359  1.00 17.55      A    C  
ATOM   1164  O   GLY   164      12.110  56.488   3.159  1.00 17.16      A    O  
ATOM   1165  N   ALA   165      10.347  55.821   4.392  1.00 16.59      A    N  
ATOM   1166  CA  ALA   165      11.226  55.078   5.299  1.00 15.88      A    C  
ATOM   1167  CB  ALA   165      10.464  54.611   6.531  1.00 15.49      A    C  
ATOM   1168  C   ALA   165      11.848  53.895   4.581  1.00 15.99      A    C  
ATOM   1169  O   ALA   165      11.227  53.301   3.702  1.00 16.08      A    O  
ATOM   1170  N   GLN   166      13.089  53.572   4.946  1.00 15.87      A    N  
ATOM   1171  CA  GLN   166      13.783  52.403   4.409  1.00 16.04      A    C  
ATOM   1172  CB  GLN   166      15.063  52.818   3.694  1.00 16.57      A    C  
ATOM   1173  CG  GLN   166      14.817  53.598   2.408  1.00 17.98      A    C  
ATOM   1174  CD  GLN   166      16.094  53.867   1.628  1.00 21.08      A    C  
ATOM   1175  OE1 GLN   166      16.923  52.979   1.448  1.00 23.16      A    O  
ATOM   1176  NE2 GLN   166      16.249  55.097   1.157  1.00 20.86      A    N  
ATOM   1177  C   GLN   166      14.134  51.479   5.564  1.00 15.97      A    C  
ATOM   1178  O   GLN   166      14.580  51.938   6.615  1.00 16.12      A    O  
ATOM   1179  N   LEU   167      13.920  50.188   5.373  1.00 15.41      A    N  
ATOM   1180  CA  LEU   167      14.239  49.197   6.385  1.00 16.04      A    C  
ATOM   1181  CB  LEU   167      13.047  48.288   6.632  1.00 16.45      A    C  
ATOM   1182  CG  LEU   167      11.863  48.925   7.362  1.00 18.85      A    C  
ATOM   1183  CD1 LEU   167      10.928  49.624   6.390  1.00 21.28      A    C  
ATOM   1184  CD2 LEU   167      11.135  47.861   8.152  1.00 20.90      A    C  
ATOM   1185  C   LEU   167      15.400  48.358   5.908  1.00 15.59      A    C  
ATOM   1186  O   LEU   167      15.386  47.864   4.770  1.00 15.57      A    O  
ATOM   1187  N   VAL   168      16.401  48.187   6.769  1.00 14.78      A    N  
ATOM   1188  CA  VAL   168      17.559  47.372   6.415  1.00 14.56      A    C  
ATOM   1189  CB  VAL   168      18.876  48.187   6.329  1.00 14.89      A    C  
ATOM   1190  CG1 VAL   168      18.823  49.156   5.161  1.00 16.13      A    C  
ATOM   1191  CG2 VAL   168      19.174  48.941   7.626  1.00 15.18      A    C  
ATOM   1192  C   VAL   168      17.697  46.230   7.410  1.00 14.04      A    C  
ATOM   1193  O   VAL   168      17.853  46.465   8.608  1.00 13.41      A    O  
ATOM   1194  N   PHE   169      17.589  45.004   6.905  1.00 13.28      A    N  
ATOM   1195  CA  PHE   169      17.640  43.818   7.757  1.00 13.58      A    C  
ATOM   1196  CB  PHE   169      16.650  42.755   7.264  1.00 13.70      A    C  
ATOM   1197  CG  PHE   169      15.212  43.168   7.435  1.00 15.53      A    C  
ATOM   1198  CD1 PHE   169      14.573  43.012   8.668  1.00 16.84      A    C  
ATOM   1199  CE1 PHE   169      13.258  43.403   8.842  1.00 18.53      A    C  
ATOM   1200  CZ  PHE   169      12.567  43.973   7.779  1.00 18.35      A    C  
ATOM   1201  CE2 PHE   169      13.193  44.145   6.547  1.00 17.55      A    C  
ATOM   1202  CD2 PHE   169      14.508  43.728   6.375  1.00 16.64      A    C  
ATOM   1203  C   PHE   169      19.067  43.272   7.865  1.00 13.19      A    C  
ATOM   1204  O   PHE   169      19.973  43.773   7.201  1.00 13.60      A    O  
ATOM   1205  N   HIS   170      19.252  42.277   8.726  1.00 12.99      A    N  
ATOM   1206  CA  HIS   170      20.580  41.741   9.069  1.00 13.34      A    C  
ATOM   1207  CB  HIS   170      21.019  40.628   8.092  1.00 14.56      A    C  
ATOM   1208  CG  HIS   170      20.910  40.999   6.648  1.00 18.57      A    C  
ATOM   1209  ND1 HIS   170      21.886  41.712   5.986  1.00 21.37      A    N  
ATOM   1210  CE1 HIS   170      21.520  41.890   4.728  1.00 22.64      A    C  
ATOM   1211  NE2 HIS   170      20.346  41.311   4.549  1.00 23.50      A    N  
ATOM   1212  CD2 HIS   170      19.945  40.738   5.732  1.00 20.09      A    C  
ATOM   1213  C   HIS   170      21.641  42.840   9.242  1.00 12.40      A    C  
ATOM   1214  O   HIS   170      22.780  42.732   8.777  1.00 11.98      A    O  
ATOM   1215  N   THR   171      21.243  43.884   9.960  1.00 10.20      A    N  
ATOM   1216  CA  THR   171      22.069  45.048  10.175  1.00 10.29      A    C  
ATOM   1217  CB  THR   171      21.558  46.211   9.305  1.00  9.65      A    C  
ATOM   1218  OG1 THR   171      21.615  45.801   7.930  1.00 11.88      A    O  
ATOM   1219  CG2 THR   171      22.400  47.460   9.509  1.00 10.17      A    C  
ATOM   1220  C   THR   171      22.068  45.398  11.669  1.00  9.25      A    C  
ATOM   1221  O   THR   171      21.277  46.224  12.139  1.00 10.00      A    O  
ATOM   1222  N   PRO   172      22.937  44.735  12.440  1.00  8.33      A    N  
ATOM   1223  CA  PRO   172      22.975  44.938  13.879  1.00  8.52      A    C  
ATOM   1224  CB  PRO   172      23.712  43.681  14.377  1.00  8.27      A    C  
ATOM   1225  CG  PRO   172      24.641  43.370  13.295  1.00  8.48      A    C  
ATOM   1226  CD  PRO   172      23.925  43.729  12.001  1.00  8.85      A    C  
ATOM   1227  C   PRO   172      23.779  46.177  14.265  1.00  8.15      A    C  
ATOM   1228  O   PRO   172      24.909  46.344  13.810  1.00  8.40      A    O  
ATOM   1229  N   LEU   173      23.199  47.047  15.087  1.00  7.89      A    N  
ATOM   1230  CA  LEU   173      23.974  48.130  15.697  1.00  7.87      A    C  
ATOM   1231  CB  LEU   173      23.061  49.217  16.291  1.00  7.05      A    C  
ATOM   1232  CG  LEU   173      23.786  50.364  16.999  1.00  7.37      A    C  
ATOM   1233  CD1 LEU   173      24.775  51.011  16.041  1.00  9.34      A    C  
ATOM   1234  CD2 LEU   173      22.811  51.424  17.509  1.00  7.46      A    C  
ATOM   1235  C   LEU   173      24.885  47.573  16.790  1.00  8.11      A    C  
ATOM   1236  O   LEU   173      24.426  46.892  17.713  1.00  8.12      A    O  
ATOM   1237  N   ILE   174      26.179  47.863  16.681  1.00  8.09      A    N  
ATOM   1238  CA  ILE   174      27.158  47.291  17.621  1.00  8.42      A    C  
ATOM   1239  CB  ILE   174      28.356  46.670  16.853  1.00  8.26      A    C  
ATOM   1240  CG1 ILE   174      27.865  45.676  15.789  1.00  7.67      A    C  
ATOM   1241  CD1 ILE   174      27.054  44.487  16.336  1.00  7.85      A    C  
ATOM   1242  CG2 ILE   174      29.361  46.028  17.830  1.00  8.43      A    C  
ATOM   1243  C   ILE   174      27.652  48.314  18.624  1.00  9.03      A    C  
ATOM   1244  O   ILE   174      27.699  48.070  19.829  1.00  9.28      A    O  
ATOM   1245  N   ALA   175      28.047  49.480  18.136  1.00  9.51      A    N  
ATOM   1246  CA  ALA   175      28.565  50.498  19.019  1.00 10.45      A    C  
ATOM   1247  CB  ALA   175      30.071  50.393  19.129  1.00 10.90      A    C  
ATOM   1248  C   ALA   175      28.188  51.837  18.435  1.00 11.08      A    C  
ATOM   1249  O   ALA   175      27.962  51.946  17.233  1.00 11.71      A    O  
ATOM   1250  N   GLY   176      28.139  52.854  19.278  1.00 12.21      A    N  
ATOM   1251  CA  GLY   176      27.846  54.194  18.798  1.00 13.05      A    C  
ATOM   1252  C   GLY   176      28.436  55.230  19.731  1.00 13.92      A    C  
ATOM   1253  O   GLY   176      28.990  54.894  20.775  1.00 13.64      A    O  
ATOM   1254  N   ARG   177      28.294  56.498  19.359  1.00 15.36      A    N  
ATOM   1255  CA  ARG   177      28.721  57.593  20.213  1.00 16.27      A    C  
ATOM   1256  CB  ARG   177      30.206  57.909  20.017  1.00 17.42      A    C  
ATOM   1257  CG  ARG   177      30.658  57.827  18.593  1.00 20.25      A    C  
ATOM   1258  CD  ARG   177      31.969  57.019  18.473  1.00 23.95      A    C  
ATOM   1259  NE  ARG   177      32.031  56.407  17.152  1.00 27.37      A    N  
ATOM   1260  CZ  ARG   177      31.792  55.125  16.912  1.00 27.14      A    C  
ATOM   1261  NH1 ARG   177      31.522  54.286  17.913  1.00 26.52      A    N  
ATOM   1262  NH2 ARG   177      31.845  54.676  15.669  1.00 29.80      A    N  
ATOM   1263  C   ARG   177      27.896  58.829  19.927  1.00 16.34      A    C  
ATOM   1264  O   ARG   177      27.538  59.091  18.788  1.00 15.95      A    O  
ATOM   1265  N   VAL   178      27.570  59.556  20.980  1.00 17.04      A    N  
ATOM   1266  CA  VAL   178      26.987  60.887  20.836  1.00 18.33      A    C  
ATOM   1267  CB  VAL   178      26.464  61.400  22.181  1.00 17.81      A    C  
ATOM   1268  CG1 VAL   178      25.794  62.775  22.007  1.00 19.49      A    C  
ATOM   1269  CG2 VAL   178      25.498  60.391  22.792  1.00 18.84      A    C  
ATOM   1270  C   VAL   178      28.092  61.799  20.348  1.00 19.19      A    C  
ATOM   1271  O   VAL   178      29.158  61.865  20.962  1.00 19.66      A    O  
ATOM   1272  N   ARG   179      27.849  62.492  19.244  1.00 20.46      A    N  
ATOM   1273  CA  ARG   179      28.847  63.385  18.655  1.00 22.18      A    C  
ATOM   1274  CB  ARG   179      28.556  63.618  17.170  1.00 21.81      A    C  
ATOM   1275  CG  ARG   179      28.576  62.372  16.315  1.00 21.76      A    C  
ATOM   1276  CD  ARG   179      28.501  62.735  14.854  1.00 21.65      A    C  
ATOM   1277  NE  ARG   179      27.341  63.577  14.565  1.00 21.68      A    N  
ATOM   1278  CZ  ARG   179      26.933  63.870  13.336  1.00 21.54      A    C  
ATOM   1279  NH1 ARG   179      27.594  63.391  12.291  1.00 21.08      A    N  
ATOM   1280  NH2 ARG   179      25.867  64.630  13.152  1.00 22.04      A    N  
ATOM   1281  C   ARG   179      28.893  64.723  19.376  1.00 23.47      A    C  
ATOM   1282  O   ARG   179      27.849  65.298  19.694  1.00 23.29      A    O  
ATOM   1283  N   PRO   180      30.113  65.232  19.616  1.00 25.00      A    N  
ATOM   1284  CA  PRO   180      30.317  66.517  20.281  1.00 25.94      A    C  
ATOM   1285  CB  PRO   180      31.798  66.812  20.025  1.00 26.04      A    C  
ATOM   1286  CG  PRO   180      32.425  65.461  19.860  1.00 26.63      A    C  
ATOM   1287  CD  PRO   180      31.381  64.610  19.192  1.00 25.14      A    C  
ATOM   1288  C   PRO   180      29.443  67.608  19.658  1.00 26.39      A    C  
ATOM   1289  O   PRO   180      28.883  68.438  20.378  1.00 27.48      A    O  
ATOM   1290  N   GLU   181      29.326  67.591  18.334  1.00 26.33      A    N  
ATOM   1291  CA  GLU   181      28.523  68.571  17.599  1.00 26.44      A    C  
ATOM   1292  CB  GLU   181      29.034  68.689  16.167  1.00 26.54      A    C  
ATOM   1293  CG  GLU   181      28.729  67.484  15.304  1.00 28.19      A    C  
ATOM   1294  CD  GLU   181      29.889  66.499  15.219  1.00 30.24      A    C  
ATOM   1295  OE1 GLU   181      30.617  66.327  16.229  1.00 30.67      A    O  
ATOM   1296  OE2 GLU   181      30.074  65.903  14.133  1.00 31.19      A    O  
ATOM   1297  C   GLU   181      27.020  68.258  17.548  1.00 25.87      A    C  
ATOM   1298  O   GLU   181      26.256  68.990  16.909  1.00 26.59      A    O  
ATOM   1299  N   GLY   182      26.596  67.182  18.206  1.00 24.64      A    N  
ATOM   1300  CA  GLY   182      25.198  66.750  18.146  1.00 22.42      A    C  
ATOM   1301  C   GLY   182      25.047  65.597  17.171  1.00 21.04      A    C  
ATOM   1302  O   GLY   182      25.896  65.402  16.308  1.00 20.92      A    O  
ATOM   1303  N   GLY   183      23.974  64.819  17.302  1.00 18.80      A    N  
ATOM   1304  CA  GLY   183      23.797  63.658  16.435  1.00 16.53      A    C  
ATOM   1305  C   GLY   183      24.635  62.485  16.927  1.00 14.99      A    C  
ATOM   1306  O   GLY   183      25.215  62.537  18.016  1.00 14.84      A    O  
ATOM   1307  N   PHE   184      24.726  61.456  16.094  1.00 13.93      A    N  
ATOM   1308  CA  PHE   184      25.298  60.172  16.507  1.00 13.13      A    C  
ATOM   1309  CB  PHE   184      24.152  59.206  16.850  1.00 12.83      A    C  
ATOM   1310  CG  PHE   184      23.183  59.768  17.842  1.00 13.91      A    C  
ATOM   1311  CD1 PHE   184      23.331  59.531  19.195  1.00 12.71      A    C  
ATOM   1312  CE1 PHE   184      22.449  60.071  20.115  1.00 12.74      A    C  
ATOM   1313  CZ  PHE   184      21.412  60.880  19.677  1.00 13.24      A    C  
ATOM   1314  CE2 PHE   184      21.257  61.124  18.330  1.00 11.65      A    C  
ATOM   1315  CD2 PHE   184      22.135  60.567  17.414  1.00 12.37      A    C  
ATOM   1316  C   PHE   184      26.144  59.580  15.403  1.00 12.91      A    C  
ATOM   1317  O   PHE   184      25.842  59.757  14.227  1.00 12.12      A    O  
ATOM   1318  N   GLU   185      27.199  58.855  15.786  1.00 12.91      A    N  
ATOM   1319  CA  GLU   185      27.953  58.058  14.831  1.00 13.21      A    C  
ATOM   1320  CB  GLU   185      29.432  58.434  14.829  1.00 13.69      A    C  
ATOM   1321  CG  GLU   185      30.186  57.732  13.726  1.00 17.84      A    C  
ATOM   1322  CD  GLU   185      31.647  58.112  13.682  1.00 23.25      A    C  
ATOM   1323  OE1 GLU   185      32.325  57.987  14.729  1.00 26.33      A    O  
ATOM   1324  OE2 GLU   185      32.115  58.509  12.593  1.00 25.75      A    O  
ATOM   1325  C   GLU   185      27.767  56.613  15.255  1.00 12.22      A    C  
ATOM   1326  O   GLU   185      27.908  56.294  16.442  1.00 12.86      A    O  
ATOM   1327  N   LEU   186      27.440  55.760  14.295  1.00 11.73      A    N  
ATOM   1328  CA  LEU   186      26.991  54.399  14.607  1.00 11.35      A    C  
ATOM   1329  CB  LEU   186      25.497  54.254  14.280  1.00 11.21      A    C  
ATOM   1330  CG  LEU   186      24.556  55.239  14.990  1.00 12.19      A    C  
ATOM   1331  CD1 LEU   186      23.129  54.999  14.522  1.00 12.80      A    C  
ATOM   1332  CD2 LEU   186      24.645  55.154  16.513  1.00 11.56      A    C  
ATOM   1333  C   LEU   186      27.740  53.346  13.809  1.00 10.81      A    C  
ATOM   1334  O   LEU   186      27.823  53.435  12.582  1.00 11.13      A    O  
ATOM   1335  N   ASP   187      28.236  52.317  14.502  1.00 10.47      A    N  
ATOM   1336  CA  ASP   187      28.934  51.222  13.856  1.00 10.57      A    C  
ATOM   1337  CB  ASP   187      30.211  50.862  14.629  1.00 10.52      A    C  
ATOM   1338  CG  ASP   187      31.160  52.039  14.749  1.00 13.54      A    C  
ATOM   1339  OD1 ASP   187      31.164  52.898  13.832  1.00 16.27      A    O  
ATOM   1340  OD2 ASP   187      31.895  52.108  15.756  1.00 17.11      A    O  
ATOM   1341  C   ASP   187      28.041  50.007  13.800  1.00  9.88      A    C  
ATOM   1342  O   ASP   187      27.648  49.475  14.844  1.00  9.11      A    O  
ATOM   1343  N   PHE   188      27.708  49.589  12.580  1.00  9.80      A    N  
ATOM   1344  CA  PHE   188      26.895  48.413  12.359  1.00 10.64      A    C  
ATOM   1345  CB  PHE   188      25.886  48.681  11.251  1.00 10.49      A    C  
ATOM   1346  CG  PHE   188      24.868  49.720  11.615  1.00  9.97      A    C  
ATOM   1347  CD1 PHE   188      23.687  49.348  12.231  1.00 11.29      A    C  
ATOM   1348  CE1 PHE   188      22.736  50.296  12.573  1.00 11.93      A    C  
ATOM   1349  CZ  PHE   188      22.965  51.633  12.295  1.00 12.62      A    C  
ATOM   1350  CE2 PHE   188      24.144  52.018  11.667  1.00 11.53      A    C  
ATOM   1351  CD2 PHE   188      25.090  51.058  11.336  1.00 12.05      A    C  
ATOM   1352  C   PHE   188      27.766  47.210  12.026  1.00 10.85      A    C  
ATOM   1353  O   PHE   188      28.836  47.340  11.404  1.00 11.32      A    O  
ATOM   1354  N   GLY   189      27.317  46.036  12.454  1.00 11.23      A    N  
ATOM   1355  CA  GLY   189      28.084  44.809  12.255  1.00 11.21      A    C  
ATOM   1356  C   GLY   189      27.490  43.887  11.205  1.00 11.49      A    C  
ATOM   1357  O   GLY   189      27.011  44.338  10.148  1.00 11.13      A    O  
ATOM   1358  N   GLY   190      27.496  42.591  11.501  1.00 10.38      A    N  
ATOM   1359  CA  GLY   190      27.004  41.572  10.579  1.00 11.23      A    C  
ATOM   1360  C   GLY   190      27.962  41.298   9.425  1.00 12.17      A    C  
ATOM   1361  O   GLY   190      29.160  41.543   9.529  1.00 11.35      A    O  
ATOM   1362  N   ALA   191      27.407  40.794   8.326  1.00 13.23      A    N  
ATOM   1363  CA  ALA   191      28.196  40.384   7.170  1.00 14.28      A    C  
ATOM   1364  CB  ALA   191      27.352  39.556   6.231  1.00 14.72      A    C  
ATOM   1365  C   ALA   191      28.794  41.571   6.423  1.00 14.38      A    C  
ATOM   1366  O   ALA   191      29.802  41.424   5.738  1.00 15.35      A    O  
ATOM   1367  N   GLU   192      28.172  42.735   6.558  1.00 13.71      A    N  
ATOM   1368  CA  GLU   192      28.578  43.918   5.805  1.00 14.16      A    C  
ATOM   1369  CB  GLU   192      27.563  44.223   4.703  1.00 14.36      A    C  
ATOM   1370  CG  GLU   192      27.275  43.073   3.758  1.00 17.88      A    C  
ATOM   1371  CD  GLU   192      26.044  43.352   2.920  1.00 22.75      A    C  
ATOM   1372  OE1 GLU   192      26.112  44.221   2.011  1.00 23.54      A    O  
ATOM   1373  OE2 GLU   192      24.996  42.720   3.189  1.00 25.37      A    O  
ATOM   1374  C   GLU   192      28.691  45.132   6.723  1.00 13.02      A    C  
ATOM   1375  O   GLU   192      27.886  46.059   6.632  1.00 12.59      A    O  
ATOM   1376  N   PRO   193      29.699  45.130   7.599  1.00 12.63      A    N  
ATOM   1377  CA  PRO   193      29.825  46.204   8.582  1.00 12.57      A    C  
ATOM   1378  CB  PRO   193      31.100  45.837   9.369  1.00 12.27      A    C  
ATOM   1379  CG  PRO   193      31.795  44.797   8.571  1.00 12.67      A    C  
ATOM   1380  CD  PRO   193      30.728  44.088   7.782  1.00 12.37      A    C  
ATOM   1381  C   PRO   193      29.993  47.543   7.913  1.00 12.99      A    C  
ATOM   1382  O   PRO   193      30.588  47.639   6.827  1.00 12.51      A    O  
ATOM   1383  N   MET   194      29.452  48.570   8.546  1.00 12.97      A    N  
ATOM   1384  CA  MET   194      29.477  49.906   7.968  1.00 13.24      A    C  
ATOM   1385  CB  MET   194      28.362  50.039   6.926  1.00 13.37      A    C  
ATOM   1386  CG  MET   194      26.958  50.127   7.541  1.00 14.71      A    C  
ATOM   1387  SD  MET   194      25.659  50.420   6.309  1.00 15.17      A    S  
ATOM   1388  CE  MET   194      25.838  48.946   5.359  1.00 18.02      A    C  
ATOM   1389  C   MET   194      29.243  50.911   9.075  1.00 13.51      A    C  
ATOM   1390  O   MET   194      28.750  50.551  10.138  1.00 13.59      A    O  
ATOM   1391  N   THR   195      29.579  52.177   8.826  1.00 13.34      A    N  
ATOM   1392  CA  THR   195      29.300  53.238   9.789  1.00 13.81      A    C  
ATOM   1393  CB  THR   195      30.589  53.926  10.251  1.00 13.18      A    C  
ATOM   1394  OG1 THR   195      31.392  52.988  10.983  1.00 16.01      A    O  
ATOM   1395  CG2 THR   195      30.281  55.119  11.140  1.00 14.43      A    C  
ATOM   1396  C   THR   195      28.364  54.261   9.154  1.00 13.99      A    C  
ATOM   1397  O   THR   195      28.519  54.598   7.981  1.00 13.93      A    O  
ATOM   1398  N   LEU   196      27.372  54.709   9.912  1.00 14.13      A    N  
ATOM   1399  CA  LEU   196      26.428  55.747   9.455  1.00 14.52      A    C  
ATOM   1400  CB  LEU   196      25.045  55.160   9.131  1.00 14.58      A    C  
ATOM   1401  CG  LEU   196      24.874  54.032   8.104  1.00 15.95      A    C  
ATOM   1402  CD1 LEU   196      23.415  53.563   8.044  1.00 17.10      A    C  
ATOM   1403  CD2 LEU   196      25.362  54.456   6.716  1.00 19.76      A    C  
ATOM   1404  C   LEU   196      26.275  56.754  10.570  1.00 14.91      A    C  
ATOM   1405  O   LEU   196      26.500  56.436  11.735  1.00 15.15      A    O  
ATOM   1406  N   SER   197      25.879  57.976  10.227  1.00 14.77      A    N  
ATOM   1407  CA  SER   197      25.653  58.990  11.245  1.00 14.47      A    C  
ATOM   1408  CB  SER   197      26.655  60.123  11.101  1.00 15.04      A    C  
ATOM   1409  OG  SER   197      26.461  60.772   9.858  1.00 18.23      A    O  
ATOM   1410  C   SER   197      24.242  59.537  11.079  1.00 13.78      A    C  
ATOM   1411  O   SER   197      23.646  59.401  10.007  1.00 13.97      A    O  
ATOM   1412  N   CYS   198      23.705  60.116  12.144  1.00 13.16      A    N  
ATOM   1413  CA  CYS   198      22.302  60.558  12.139  1.00 13.65      A    C  
ATOM   1414  CB  CYS   198      21.353  59.382  12.389  1.00 13.61      A    C  
ATOM   1415  SG  CYS   198      21.509  58.584  14.007  1.00 14.33      A    S  
ATOM   1416  C   CYS   198      22.010  61.678  13.128  1.00 13.53      A    C  
ATOM   1417  O   CYS   198      22.767  61.933  14.060  1.00 13.00      A    O  
ATOM   1418  N   ARG   199      20.892  62.364  12.925  1.00 13.13      A    N  
ATOM   1419  CA  ARG   199      20.540  63.455  13.826  1.00 13.43      A    C  
ATOM   1420  CB  ARG   199      19.746  64.518  13.055  1.00 14.01      A    C  
ATOM   1421  CG  ARG   199      19.304  65.698  13.885  1.00 15.90      A    C  
ATOM   1422  CD  ARG   199      18.369  66.620  13.076  1.00 17.46      A    C  
ATOM   1423  NE  ARG   199      17.089  65.989  12.728  1.00 19.34      A    N  
ATOM   1424  CZ  ARG   199      15.982  66.055  13.471  1.00 19.42      A    C  
ATOM   1425  NH1 ARG   199      15.968  66.733  14.612  1.00 21.71      A    N  
ATOM   1426  NH2 ARG   199      14.877  65.449  13.059  1.00 19.05      A    N  
ATOM   1427  C   ARG   199      19.737  62.938  15.022  1.00 12.85      A    C  
ATOM   1428  O   ARG   199      19.931  63.371  16.153  1.00 13.63      A    O  
ATOM   1429  N   VAL   200      18.833  62.006  14.757  1.00 12.54      A    N  
ATOM   1430  CA  VAL   200      17.954  61.466  15.784  1.00 12.29      A    C  
ATOM   1431  CB  VAL   200      16.479  61.745  15.431  1.00 12.66      A    C  
ATOM   1432  CG1 VAL   200      15.559  60.936  16.316  1.00 13.14      A    C  
ATOM   1433  CG2 VAL   200      16.178  63.230  15.586  1.00 12.74      A    C  
ATOM   1434  C   VAL   200      18.160  59.963  15.875  1.00 10.71      A    C  
ATOM   1435  O   VAL   200      18.263  59.305  14.858  1.00 10.98      A    O  
ATOM   1436  N   LEU   201      18.227  59.441  17.095  1.00 10.20      A    N  
ATOM   1437  CA  LEU   201      18.374  57.997  17.309  1.00  9.78      A    C  
ATOM   1438  CB  LEU   201      19.724  57.686  17.957  1.00  9.15      A    C  
ATOM   1439  CG  LEU   201      20.035  56.192  18.146  1.00  9.59      A    C  
ATOM   1440  CD1 LEU   201      19.935  55.405  16.828  1.00 13.48      A    C  
ATOM   1441  CD2 LEU   201      21.396  56.032  18.799  1.00 10.99      A    C  
ATOM   1442  C   LEU   201      17.288  57.474  18.229  1.00  9.04      A    C  
ATOM   1443  O   LEU   201      17.150  57.940  19.348  1.00 10.07      A    O  
ATOM   1444  N   ILE   202      16.556  56.463  17.769  1.00  9.03      A    N  
ATOM   1445  CA  ILE   202      15.549  55.818  18.598  1.00  8.77      A    C  
ATOM   1446  CB  ILE   202      14.187  55.717  17.900  1.00  9.02      A    C  
ATOM   1447  CG1 ILE   202      13.730  57.073  17.344  1.00 10.37      A    C  
ATOM   1448  CD1 ILE   202      13.604  58.141  18.384  1.00  9.20      A    C  
ATOM   1449  CG2 ILE   202      13.136  55.128  18.844  1.00 10.32      A    C  
ATOM   1450  C   ILE   202      16.027  54.389  18.860  1.00  7.84      A    C  
ATOM   1451  O   ILE   202      16.199  53.596  17.934  1.00  7.98      A    O  
ATOM   1452  N   ASN   203      16.245  54.083  20.122  1.00  8.20      A    N  
ATOM   1453  CA  ASN   203      16.652  52.743  20.538  1.00  8.37      A    C  
ATOM   1454  CB  ASN   203      17.694  52.858  21.657  1.00  8.39      A    C  
ATOM   1455  CG  ASN   203      17.922  51.553  22.401  1.00  8.59      A    C  
ATOM   1456  OD1 ASN   203      17.550  50.486  21.940  1.00  8.93      A    O  
ATOM   1457  ND2 ASN   203      18.553  51.647  23.571  1.00  9.50      A    N  
ATOM   1458  C   ASN   203      15.397  51.984  20.984  1.00  7.68      A    C  
ATOM   1459  O   ASN   203      14.888  52.183  22.098  1.00  7.64      A    O  
ATOM   1460  N   ALA   204      14.887  51.160  20.074  1.00  8.08      A    N  
ATOM   1461  CA  ALA   204      13.676  50.382  20.278  1.00  7.97      A    C  
ATOM   1462  CB  ALA   204      12.617  50.733  19.203  1.00  7.84      A    C  
ATOM   1463  C   ALA   204      14.055  48.906  20.221  1.00  8.03      A    C  
ATOM   1464  O   ALA   204      13.329  48.084  19.673  1.00  8.35      A    O  
ATOM   1465  N   ALA   205      15.205  48.581  20.810  1.00  8.09      A    N  
ATOM   1466  CA  ALA   205      15.783  47.246  20.649  1.00  8.95      A    C  
ATOM   1467  CB  ALA   205      17.323  47.335  20.785  1.00  8.85      A    C  
ATOM   1468  C   ALA   205      15.215  46.155  21.572  1.00  9.22      A    C  
ATOM   1469  O   ALA   205      15.742  45.027  21.623  1.00  8.90      A    O  
ATOM   1470  N   GLY   206      14.148  46.473  22.303  1.00  8.62      A    N  
ATOM   1471  CA  GLY   206      13.441  45.455  23.082  1.00  9.18      A    C  
ATOM   1472  C   GLY   206      14.242  44.835  24.216  1.00  9.37      A    C  
ATOM   1473  O   GLY   206      14.713  45.534  25.108  1.00  9.50      A    O  
ATOM   1474  N   LEU   207      14.366  43.508  24.188  1.00 10.01      A    N  
ATOM   1475  CA  LEU   207      15.168  42.779  25.166  1.00 11.08      A    C  
ATOM   1476  CB  LEU   207      15.341  41.325  24.703  1.00 10.79      A    C  
ATOM   1477  CG  LEU   207      14.086  40.490  24.532  1.00 14.13      A    C  
ATOM   1478  CD1 LEU   207      14.495  39.061  24.245  1.00 15.21      A    C  
ATOM   1479  CD2 LEU   207      13.256  40.564  25.800  1.00 15.53      A    C  
ATOM   1480  C   LEU   207      16.565  43.363  25.332  1.00 10.50      A    C  
ATOM   1481  O   LEU   207      17.194  43.224  26.401  1.00 11.39      A    O  
ATOM   1482  N   HIS   208      17.064  43.974  24.261  1.00  9.20      A    N  
ATOM   1483  CA  HIS   208      18.441  44.424  24.218  1.00  8.94      A    C  
ATOM   1484  CB  HIS   208      19.105  43.942  22.930  1.00  9.54      A    C  
ATOM   1485  CG  HIS   208      19.232  42.457  22.868  1.00 11.80      A    C  
ATOM   1486  ND1 HIS   208      20.119  41.767  23.659  1.00 17.06      A    N  
ATOM   1487  CE1 HIS   208      20.003  40.473  23.421  1.00 16.40      A    C  
ATOM   1488  NE2 HIS   208      19.063  40.303  22.513  1.00 15.08      A    N  
ATOM   1489  CD2 HIS   208      18.547  41.528  22.166  1.00 14.31      A    C  
ATOM   1490  C   HIS   208      18.590  45.914  24.354  1.00  8.24      A    C  
ATOM   1491  O   HIS   208      19.693  46.431  24.272  1.00  7.88      A    O  
ATOM   1492  N   ALA   209      17.491  46.621  24.599  1.00  7.48      A    N  
ATOM   1493  CA  ALA   209      17.611  48.071  24.654  1.00  7.41      A    C  
ATOM   1494  CB  ALA   209      16.193  48.767  24.727  1.00  8.13      A    C  
ATOM   1495  C   ALA   209      18.562  48.604  25.741  1.00  7.41      A    C  
ATOM   1496  O   ALA   209      19.333  49.533  25.484  1.00  7.52      A    O  
ATOM   1497  N   PRO   210      18.484  48.065  26.966  1.00  6.70      A    N  
ATOM   1498  CA  PRO   210      19.398  48.607  27.994  1.00  6.94      A    C  
ATOM   1499  CB  PRO   210      18.953  47.884  29.264  1.00  6.78      A    C  
ATOM   1500  CG  PRO   210      17.477  47.528  28.989  1.00  6.88      A    C  
ATOM   1501  CD  PRO   210      17.471  47.149  27.541  1.00  6.88      A    C  
ATOM   1502  C   PRO   210      20.876  48.325  27.692  1.00  7.62      A    C  
ATOM   1503  O   PRO   210      21.725  49.223  27.831  1.00  8.12      A    O  
ATOM   1504  N   GLY   211      21.164  47.109  27.247  1.00  7.83      A    N  
ATOM   1505  CA  GLY   211      22.535  46.752  26.915  1.00  7.75      A    C  
ATOM   1506  C   GLY   211      23.031  47.566  25.745  1.00  7.91      A    C  
ATOM   1507  O   GLY   211      24.186  47.983  25.703  1.00  8.44      A    O  
ATOM   1508  N   LEU   212      22.143  47.820  24.794  1.00  7.61      A    N  
ATOM   1509  CA  LEU   212      22.512  48.622  23.633  1.00  7.74      A    C  
ATOM   1510  CB  LEU   212      21.436  48.570  22.557  1.00  7.89      A    C  
ATOM   1511  CG  LEU   212      21.705  49.413  21.301  1.00  7.60      A    C  
ATOM   1512  CD1 LEU   212      23.016  49.006  20.629  1.00  9.65      A    C  
ATOM   1513  CD2 LEU   212      20.533  49.272  20.355  1.00  8.22      A    C  
ATOM   1514  C   LEU   212      22.791  50.056  24.048  1.00  7.66      A    C  
ATOM   1515  O   LEU   212      23.723  50.670  23.558  1.00  7.84      A    O  
ATOM   1516  N   ALA   213      21.984  50.606  24.951  1.00  7.71      A    N  
ATOM   1517  CA  ALA   213      22.288  51.968  25.437  1.00  8.99      A    C  
ATOM   1518  CB  ALA   213      21.227  52.432  26.418  1.00  9.47      A    C  
ATOM   1519  C   ALA   213      23.686  52.047  26.062  1.00  8.46      A    C  
ATOM   1520  O   ALA   213      24.410  53.014  25.880  1.00  9.13      A    O  
ATOM   1521  N   ARG   214      24.073  51.000  26.781  1.00  9.00      A    N  
ATOM   1522  CA  ARG   214      25.387  50.963  27.392  1.00  9.47      A    C  
ATOM   1523  CB  ARG   214      25.490  49.759  28.333  1.00  9.19      A    C  
ATOM   1524  CG  ARG   214      26.846  49.622  29.014  1.00 12.69      A    C  
ATOM   1525  CD  ARG   214      27.115  50.790  29.974  1.00 16.75      A    C  
ATOM   1526  NE  ARG   214      28.464  50.719  30.532  1.00 19.03      A    N  
ATOM   1527  CZ  ARG   214      29.546  51.176  29.911  1.00 18.83      A    C  
ATOM   1528  NH1 ARG   214      29.426  51.726  28.720  1.00 18.92      A    N  
ATOM   1529  NH2 ARG   214      30.753  51.075  30.474  1.00 17.01      A    N  
ATOM   1530  C   ARG   214      26.487  50.910  26.311  1.00  9.83      A    C  
ATOM   1531  O   ARG   214      27.655  51.227  26.581  1.00 10.62      A    O  
ATOM   1532  N   ARG   215      26.115  50.507  25.104  1.00  9.86      A    N  
ATOM   1533  CA  ARG   215      27.077  50.438  23.990  1.00 10.74      A    C  
ATOM   1534  CB  ARG   215      26.759  49.243  23.082  1.00 10.72      A    C  
ATOM   1535  CG  ARG   215      26.999  47.900  23.784  1.00 11.69      A    C  
ATOM   1536  CD  ARG   215      26.810  46.732  22.814  1.00 11.45      A    C  
ATOM   1537  NE  ARG   215      25.406  46.368  22.525  1.00 12.73      A    N  
ATOM   1538  CZ  ARG   215      24.625  45.579  23.276  1.00 15.53      A    C  
ATOM   1539  NH1 ARG   215      25.019  45.086  24.459  1.00 17.00      A    N  
ATOM   1540  NH2 ARG   215      23.397  45.310  22.863  1.00 17.23      A    N  
ATOM   1541  C   ARG   215      27.151  51.731  23.177  1.00 11.21      A    C  
ATOM   1542  O   ARG   215      27.825  51.787  22.141  1.00 10.82      A    O  
ATOM   1543  N   ILE   216      26.442  52.764  23.634  1.00 11.14      A    N  
ATOM   1544  CA  ILE   216      26.522  54.064  22.991  1.00 11.93      A    C  
ATOM   1545  CB  ILE   216      25.128  54.655  22.678  1.00 12.14      A    C  
ATOM   1546  CG1 ILE   216      24.269  53.654  21.887  1.00 13.07      A    C  
ATOM   1547  CD1 ILE   216      24.841  53.271  20.606  1.00 15.02      A    C  
ATOM   1548  CG2 ILE   216      25.289  55.973  21.908  1.00 11.88      A    C  
ATOM   1549  C   ILE   216      27.221  55.029  23.931  1.00 12.85      A    C  
ATOM   1550  O   ILE   216      26.660  55.409  24.958  1.00 12.73      A    O  
ATOM   1551  N   GLU   217      28.447  55.414  23.590  1.00 14.04      A    N  
ATOM   1552  CA  GLU   217      29.184  56.384  24.393  1.00 15.53      A    C  
ATOM   1553  CB  GLU   217      30.568  56.656  23.802  1.00 15.92      A    C  
ATOM   1554  CG  GLU   217      31.439  55.460  23.526  1.00 20.85      A    C  
ATOM   1555  CD  GLU   217      32.748  55.894  22.888  1.00 25.38      A    C  
ATOM   1556  OE1 GLU   217      33.386  56.827  23.434  1.00 27.71      A    O  
ATOM   1557  OE2 GLU   217      33.120  55.340  21.830  1.00 28.41      A    O  
ATOM   1558  C   GLU   217      28.430  57.701  24.432  1.00 15.44      A    C  
ATOM   1559  O   GLU   217      27.964  58.193  23.396  1.00 15.76      A    O  
ATOM   1560  N   GLY   218      28.322  58.278  25.623  1.00 15.55      A    N  
ATOM   1561  CA  GLY   218      27.629  59.549  25.763  1.00 15.38      A    C  
ATOM   1562  C   GLY   218      26.256  59.414  26.402  1.00 14.83      A    C  
ATOM   1563  O   GLY   218      25.655  60.407  26.805  1.00 15.66      A    O  
ATOM   1564  N   ILE   219      25.738  58.196  26.491  1.00 14.36      A    N  
ATOM   1565  CA  ILE   219      24.507  57.981  27.258  1.00 13.63      A    C  
ATOM   1566  CB  ILE   219      23.720  56.762  26.737  1.00 13.20      A    C  
ATOM   1567  CG1 ILE   219      23.383  56.947  25.259  1.00 12.65      A    C  
ATOM   1568  CD1 ILE   219      22.522  55.819  24.641  1.00 11.72      A    C  
ATOM   1569  CG2 ILE   219      22.481  56.531  27.603  1.00 13.03      A    C  
ATOM   1570  C   ILE   219      24.870  57.738  28.723  1.00 14.02      A    C  
ATOM   1571  O   ILE   219      25.614  56.810  29.028  1.00 13.55      A    O  
ATOM   1572  N   PRO   220      24.356  58.565  29.649  1.00 13.92      A    N  
ATOM   1573  CA  PRO   220      24.803  58.390  31.036  1.00 14.13      A    C  
ATOM   1574  CB  PRO   220      23.957  59.410  31.804  1.00 14.37      A    C  
ATOM   1575  CG  PRO   220      23.595  60.440  30.772  1.00 14.39      A    C  
ATOM   1576  CD  PRO   220      23.421  59.697  29.497  1.00 14.34      A    C  
ATOM   1577  C   PRO   220      24.544  56.977  31.571  1.00 14.69      A    C  
ATOM   1578  O   PRO   220      23.426  56.480  31.479  1.00 14.21      A    O  
ATOM   1579  N   ARG   221      25.565  56.337  32.133  1.00 15.12      A    N  
ATOM   1580  CA  ARG   221      25.393  54.954  32.591  1.00 15.77      A    C  
ATOM   1581  CB  ARG   221      26.740  54.327  32.944  1.00 16.21      A    C  
ATOM   1582  CG  ARG   221      27.657  54.279  31.760  1.00 19.37      A    C  
ATOM   1583  CD  ARG   221      29.022  53.739  32.141  1.00 23.16      A    C  
ATOM   1584  NE  ARG   221      29.941  53.847  31.016  1.00 27.81      A    N  
ATOM   1585  CZ  ARG   221      30.828  54.824  30.866  1.00 30.65      A    C  
ATOM   1586  NH1 ARG   221      30.918  55.786  31.779  1.00 32.89      A    N  
ATOM   1587  NH2 ARG   221      31.627  54.834  29.807  1.00 31.61      A    N  
ATOM   1588  C   ARG   221      24.430  54.824  33.763  1.00 16.47      A    C  
ATOM   1589  O   ARG   221      23.794  53.783  33.936  1.00 15.20      A    O  
ATOM   1590  N   ASP   222      24.306  55.874  34.572  1.00 17.16      A    N  
ATOM   1591  CA  ASP   222      23.375  55.801  35.692  1.00 19.11      A    C  
ATOM   1592  CB  ASP   222      23.709  56.840  36.789  1.00 19.64      A    C  
ATOM   1593  CG  ASP   222      23.653  58.271  36.293  1.00 23.52      A    C  
ATOM   1594  OD1 ASP   222      23.065  58.536  35.223  1.00 26.62      A    O  
ATOM   1595  OD2 ASP   222      24.207  59.158  36.992  1.00 29.09      A    O  
ATOM   1596  C   ASP   222      21.902  55.879  35.257  1.00 18.79      A    C  
ATOM   1597  O   ASP   222      21.004  55.567  36.042  1.00 20.87      A    O  
ATOM   1598  N   SER   223      21.656  56.272  34.015  1.00 18.16      A    N  
ATOM   1599  CA  SER   223      20.290  56.390  33.488  1.00 17.11      A    C  
ATOM   1600  CB  SER   223      20.219  57.467  32.377  1.00 17.33      A    C  
ATOM   1601  OG  SER   223      20.706  57.016  31.092  1.00 17.09      A    O  
ATOM   1602  C   SER   223      19.755  55.061  32.957  1.00 16.25      A    C  
ATOM   1603  O   SER   223      18.566  54.931  32.666  1.00 16.02      A    O  
ATOM   1604  N   ILE   224      20.641  54.087  32.783  1.00 14.35      A    N  
ATOM   1605  CA  ILE   224      20.266  52.866  32.073  1.00 14.06      A    C  
ATOM   1606  CB  ILE   224      21.425  52.377  31.184  1.00 13.42      A    C  
ATOM   1607  CG1 ILE   224      21.955  53.519  30.317  1.00 13.48      A    C  
ATOM   1608  CD1 ILE   224      23.278  53.178  29.555  1.00 14.75      A    C  
ATOM   1609  CG2 ILE   224      20.973  51.196  30.311  1.00 14.05      A    C  
ATOM   1610  C   ILE   224      19.903  51.759  33.048  1.00 14.44      A    C  
ATOM   1611  O   ILE   224      20.720  51.386  33.879  1.00 14.31      A    O  
ATOM   1612  N   PRO   225      18.678  51.210  32.942  1.00 14.92      A    N  
ATOM   1613  CA  PRO   225      18.260  50.130  33.847  1.00 15.89      A    C  
ATOM   1614  CB  PRO   225      16.753  50.016  33.570  1.00 15.86      A    C  
ATOM   1615  CG  PRO   225      16.613  50.457  32.143  1.00 15.53      A    C  
ATOM   1616  CD  PRO   225      17.620  51.568  31.977  1.00 14.98      A    C  
ATOM   1617  C   PRO   225      18.969  48.803  33.560  1.00 16.42      A    C  
ATOM   1618  O   PRO   225      19.573  48.631  32.494  1.00 16.92      A    O  
ATOM   1619  N   PRO   226      18.947  47.877  34.528  1.00 17.30      A    N  
ATOM   1620  CA  PRO   226      19.551  46.559  34.305  1.00 18.02      A    C  
ATOM   1621  CB  PRO   226      19.604  45.934  35.710  1.00 17.82      A    C  
ATOM   1622  CG  PRO   226      18.649  46.759  36.560  1.00 18.52      A    C  
ATOM   1623  CD  PRO   226      18.459  48.084  35.900  1.00 17.38      A    C  
ATOM   1624  C   PRO   226      18.660  45.766  33.343  1.00 18.20      A    C  
ATOM   1625  O   PRO   226      17.467  46.069  33.226  1.00 19.50      A    O  
ATOM   1626  N   GLU   227      19.240  44.824  32.602  1.00 17.79      A    N  
ATOM   1627  CA  GLU   227      18.504  44.119  31.564  1.00 17.57      A    C  
ATOM   1628  CB  GLU   227      19.393  44.052  30.323  1.00 18.16      A    C  
ATOM   1629  CG  GLU   227      18.828  43.351  29.100  1.00 19.27      A    C  
ATOM   1630  CD  GLU   227      19.810  43.380  27.923  1.00 21.02      A    C  
ATOM   1631  OE1 GLU   227      20.648  44.303  27.863  1.00 15.20      A    O  
ATOM   1632  OE2 GLU   227      19.731  42.479  27.061  1.00 24.76      A    O  
ATOM   1633  C   GLU   227      18.165  42.706  32.067  1.00 17.55      A    C  
ATOM   1634  O   GLU   227      19.070  41.859  32.133  1.00 17.14      A    O  
ATOM   1635  N   TYR   228      16.903  42.446  32.448  1.00 16.08      A    N  
ATOM   1636  CA  TYR   228      16.514  41.076  32.876  1.00 15.05      A    C  
ATOM   1637  CB  TYR   228      15.735  41.023  34.203  1.00 14.76      A    C  
ATOM   1638  CG  TYR   228      16.276  41.816  35.388  1.00 15.14      A    C  
ATOM   1639  CD1 TYR   228      17.088  41.220  36.346  1.00 13.64      A    C  
ATOM   1640  CE1 TYR   228      17.550  41.942  37.441  1.00 13.97      A    C  
ATOM   1641  CZ  TYR   228      17.189  43.272  37.592  1.00 16.03      A    C  
ATOM   1642  OH  TYR   228      17.642  44.003  38.674  1.00 17.70      A    O  
ATOM   1643  CE2 TYR   228      16.367  43.880  36.667  1.00 15.34      A    C  
ATOM   1644  CD2 TYR   228      15.913  43.151  35.573  1.00 15.34      A    C  
ATOM   1645  C   TYR   228      15.647  40.405  31.810  1.00 14.44      A    C  
ATOM   1646  O   TYR   228      15.128  41.067  30.911  1.00 14.49      A    O  
ATOM   1647  N   LEU   229      15.489  39.093  31.927  1.00 13.32      A    N  
ATOM   1648  CA  LEU   229      14.704  38.316  30.970  1.00 12.69      A    C  
ATOM   1649  CB  LEU   229      15.624  37.410  30.137  1.00 12.91      A    C  
ATOM   1650  CG  LEU   229      16.713  38.104  29.320  1.00 13.86      A    C  
ATOM   1651  CD1 LEU   229      17.614  37.056  28.648  1.00 15.17      A    C  
ATOM   1652  CD2 LEU   229      16.093  39.053  28.283  1.00 14.82      A    C  
ATOM   1653  C   LEU   229      13.694  37.447  31.702  1.00 12.18      A    C  
ATOM   1654  O   LEU   229      14.059  36.702  32.600  1.00 11.13      A    O  
ATOM   1655  N   CYS   230      12.418  37.551  31.320  1.00 10.88      A    N  
ATOM   1656  CA  CYS   230      11.374  36.735  31.931  1.00 11.08      A    C  
ATOM   1657  CB  CYS   230      10.411  37.568  32.793  1.00 11.08      A    C  
ATOM   1658  SG  CYS   230       9.250  36.533  33.681  1.00 14.08      A    S  
ATOM   1659  C   CYS   230      10.608  36.025  30.832  1.00 10.66      A    C  
ATOM   1660  O   CYS   230       9.745  36.610  30.179  1.00 11.14      A    O  
ATOM   1661  N   LYS   231      10.937  34.756  30.624  1.00 10.29      A    N  
ATOM   1662  CA  LYS   231      10.368  33.967  29.558  1.00  9.63      A    C  
ATOM   1663  CB  LYS   231      11.241  32.718  29.365  1.00  9.58      A    C  
ATOM   1664  CG  LYS   231      10.856  31.787  28.219  1.00 10.04      A    C  
ATOM   1665  CD  LYS   231      11.997  30.778  28.038  1.00 10.56      A    C  
ATOM   1666  CE  LYS   231      11.748  29.766  26.939  1.00 11.08      A    C  
ATOM   1667  NZ  LYS   231      12.935  28.823  26.874  1.00 11.14      A    N  
ATOM   1668  C   LYS   231       8.926  33.562  29.848  1.00  9.99      A    C  
ATOM   1669  O   LYS   231       8.500  33.465  31.008  1.00  9.09      A    O  
ATOM   1670  N   GLY   232       8.178  33.324  28.778  1.00 10.35      A    N  
ATOM   1671  CA  GLY   232       6.808  32.826  28.886  1.00 10.08      A    C  
ATOM   1672  C   GLY   232       6.544  31.773  27.822  1.00  9.90      A    C  
ATOM   1673  O   GLY   232       6.889  31.947  26.656  1.00 10.29      A    O  
ATOM   1674  N   SER   233       5.935  30.681  28.237  1.00  9.00      A    N  
ATOM   1675  CA  SER   233       5.628  29.575  27.322  1.00  9.36      A    C  
ATOM   1676  CB  SER   233       6.169  28.264  27.884  1.00  9.85      A    C  
ATOM   1677  OG  SER   233       7.594  28.307  27.972  1.00 10.35      A    O  
ATOM   1678  C   SER   233       4.126  29.446  27.139  1.00  9.52      A    C  
ATOM   1679  O   SER   233       3.358  29.584  28.101  1.00  8.77      A    O  
ATOM   1680  N   TYR   234       3.729  29.161  25.904  1.00  9.82      A    N  
ATOM   1681  CA  TYR   234       2.329  28.898  25.569  1.00  9.97      A    C  
ATOM   1682  CB  TYR   234       1.892  29.765  24.397  1.00 10.24      A    C  
ATOM   1683  CG  TYR   234       1.810  31.257  24.618  1.00 10.05      A    C  
ATOM   1684  CD1 TYR   234       0.588  31.870  24.924  1.00 11.14      A    C  
ATOM   1685  CE1 TYR   234       0.492  33.248  25.099  1.00 12.66      A    C  
ATOM   1686  CZ  TYR   234       1.615  34.033  24.938  1.00 13.31      A    C  
ATOM   1687  OH  TYR   234       1.518  35.410  25.101  1.00 14.00      A    O  
ATOM   1688  CE2 TYR   234       2.834  33.457  24.629  1.00 12.53      A    C  
ATOM   1689  CD2 TYR   234       2.934  32.064  24.471  1.00 12.37      A    C  
ATOM   1690  C   TYR   234       2.158  27.456  25.098  1.00 10.53      A    C  
ATOM   1691  O   TYR   234       3.051  26.898  24.445  1.00 10.21      A    O  
ATOM   1692  N   PHE   235       0.994  26.888  25.385  1.00 10.27      A    N  
ATOM   1693  CA  PHE   235       0.609  25.583  24.859  1.00 11.24      A    C  
ATOM   1694  CB  PHE   235       0.581  24.562  25.987  1.00 11.15      A    C  
ATOM   1695  CG  PHE   235       1.929  24.390  26.604  1.00 12.28      A    C  
ATOM   1696  CD1 PHE   235       2.827  23.487  26.062  1.00 11.31      A    C  
ATOM   1697  CE1 PHE   235       4.105  23.345  26.609  1.00 12.46      A    C  
ATOM   1698  CZ  PHE   235       4.499  24.155  27.670  1.00 12.52      A    C  
ATOM   1699  CE2 PHE   235       3.608  25.073  28.199  1.00 13.39      A    C  
ATOM   1700  CD2 PHE   235       2.339  25.199  27.650  1.00 11.84      A    C  
ATOM   1701  C   PHE   235      -0.701  25.693  24.145  1.00 11.95      A    C  
ATOM   1702  O   PHE   235      -1.514  26.550  24.463  1.00 12.43      A    O  
ATOM   1703  N   THR   236      -0.892  24.839  23.150  1.00 12.35      A    N  
ATOM   1704  CA  THR   236      -2.040  24.959  22.281  1.00 12.91      A    C  
ATOM   1705  CB  THR   236      -1.617  25.096  20.816  1.00 12.85      A    C  
ATOM   1706  OG1 THR   236      -0.869  23.935  20.432  1.00 14.79      A    O  
ATOM   1707  CG2 THR   236      -0.759  26.369  20.609  1.00 13.66      A    C  
ATOM   1708  C   THR   236      -2.992  23.785  22.460  1.00 13.85      A    C  
ATOM   1709  O   THR   236      -2.622  22.726  22.976  1.00 13.49      A    O  
ATOM   1710  N   LEU   237      -4.235  23.997  22.050  1.00 14.70      A    N  
ATOM   1711  CA  LEU   237      -5.272  22.996  22.164  1.00 16.57      A    C  
ATOM   1712  CB  LEU   237      -6.407  23.511  23.054  1.00 16.03      A    C  
ATOM   1713  CG  LEU   237      -7.596  22.577  23.295  1.00 16.60      A    C  
ATOM   1714  CD1 LEU   237      -7.296  21.552  24.388  1.00 14.34      A    C  
ATOM   1715  CD2 LEU   237      -8.818  23.386  23.687  1.00 16.05      A    C  
ATOM   1716  C   LEU   237      -5.783  22.717  20.758  1.00 18.19      A    C  
ATOM   1717  O   LEU   237      -6.296  23.612  20.087  1.00 18.01      A    O  
ATOM   1718  N   ALA   238      -5.606  21.483  20.304  1.00 20.35      A    N  
ATOM   1719  CA  ALA   238      -6.154  21.067  19.021  1.00 22.96      A    C  
ATOM   1720  CB  ALA   238      -5.573  19.715  18.604  1.00 22.72      A    C  
ATOM   1721  C   ALA   238      -7.670  20.985  19.103  1.00 24.35      A    C  
ATOM   1722  O   ALA   238      -8.237  20.646  20.142  1.00 25.10      A    O  
ATOM   1723  N   GLY   239      -8.338  21.295  18.002  1.00 26.36      A    N  
ATOM   1724  CA  GLY   239      -9.763  21.013  17.913  1.00 27.67      A    C  
ATOM   1725  C   GLY   239     -10.698  22.091  18.429  1.00 28.61      A    C  
ATOM   1726  O   GLY   239     -11.655  21.801  19.148  1.00 29.28      A    O  
ATOM   1727  N   ARG   240     -10.440  23.340  18.061  1.00 29.10           N  
ATOM   1728  CA  ARG   240     -11.454  24.383  18.262  1.00 29.55           C  
ATOM   1729  CB  ARG   240     -12.710  24.092  17.430  1.00 30.53           C  
ATOM   1730  CG  ARG   240     -12.474  24.085  15.925  1.00 33.58           C  
ATOM   1731  CD  ARG   240     -13.762  23.880  15.149  1.00 38.33           C  
ATOM   1732  NE  ARG   240     -13.495  23.869  13.714  1.00 41.74           N  
ATOM   1733  CZ  ARG   240     -14.407  24.096  12.772  1.00 43.52           C  
ATOM   1734  NH1 ARG   240     -15.671  24.360  13.105  1.00 44.69           N  
ATOM   1735  NH2 ARG   240     -14.051  24.066  11.490  1.00 43.91           N  
ATOM   1736  C   ARG   240     -11.832  24.549  19.739  1.00 28.00           C  
ATOM   1737  O   ARG   240     -12.019  23.574  20.478  1.00 28.31      A    O  
ATOM   1738  N   ALA   241     -11.964  25.806  20.141  1.00 26.48      A    N  
ATOM   1739  CA  ALA   241     -11.861  26.187  21.535  1.00 23.91      A    C  
ATOM   1740  CB  ALA   241     -11.409  27.635  21.645  1.00 23.72      A    C  
ATOM   1741  C   ALA   241     -13.132  25.949  22.341  1.00 22.42      A    C  
ATOM   1742  O   ALA   241     -14.230  25.928  21.794  1.00 22.61      A    O  
ATOM   1743  N   PRO   242     -12.979  25.758  23.655  1.00 20.76      A    N  
ATOM   1744  CA  PRO   242     -14.138  25.532  24.494  1.00 19.21      A    C  
ATOM   1745  CB  PRO   242     -13.541  24.895  25.752  1.00 19.39      A    C  
ATOM   1746  CG  PRO   242     -12.134  25.379  25.811  1.00 20.04      A    C  
ATOM   1747  CD  PRO   242     -11.704  25.592  24.385  1.00 20.59      A    C  
ATOM   1748  C   PRO   242     -14.856  26.844  24.850  1.00 17.67      A    C  
ATOM   1749  O   PRO   242     -15.957  26.801  25.390  1.00 16.99      A    O  
ATOM   1750  N   PHE   243     -14.235  27.983  24.528  1.00 15.95      A    N  
ATOM   1751  CA  PHE   243     -14.766  29.293  24.913  1.00 14.67      A    C  
ATOM   1752  CB  PHE   243     -13.920  29.905  26.044  1.00 15.00      A    C  
ATOM   1753  CG  PHE   243     -13.950  29.112  27.324  1.00 15.67      A    C  
ATOM   1754  CD1 PHE   243     -15.092  29.062  28.094  1.00 18.34      A    C  
ATOM   1755  CE1 PHE   243     -15.122  28.326  29.287  1.00 20.63      A    C  
ATOM   1756  CZ  PHE   243     -14.010  27.635  29.693  1.00 19.05      A    C  
ATOM   1757  CE2 PHE   243     -12.865  27.676  28.938  1.00 19.00      A    C  
ATOM   1758  CD2 PHE   243     -12.835  28.420  27.751  1.00 18.95      A    C  
ATOM   1759  C   PHE   243     -14.781  30.240  23.722  1.00 13.78      A    C  
ATOM   1760  O   PHE   243     -13.987  30.084  22.784  1.00 13.18      A    O  
ATOM   1761  N   SER   244     -15.669  31.232  23.775  1.00 12.52      A    N  
ATOM   1762  CA  SER   244     -15.759  32.234  22.717  1.00 11.90      A    C  
ATOM   1763  CB  SER   244     -17.221  32.484  22.335  1.00 12.90      A    C  
ATOM   1764  OG  SER   244     -17.848  33.361  23.254  1.00 15.35      A    O  
ATOM   1765  C   SER   244     -15.059  33.551  23.088  1.00 10.91      A    C  
ATOM   1766  O   SER   244     -14.860  34.409  22.236  1.00 10.95      A    O  
ATOM   1767  N   ARG   245     -14.731  33.699  24.369  1.00  9.65      A    N  
ATOM   1768  CA  ARG   245     -14.036  34.882  24.894  1.00  8.30      A    C  
ATOM   1769  CB  ARG   245     -14.911  35.562  25.960  1.00  8.39      A    C  
ATOM   1770  CG  ARG   245     -16.202  36.209  25.429  1.00 10.64      A    C  
ATOM   1771  CD  ARG   245     -17.111  36.590  26.583  1.00 15.14      A    C  
ATOM   1772  NE  ARG   245     -18.334  37.245  26.104  1.00 15.71      A    N  
ATOM   1773  CZ  ARG   245     -19.429  36.586  25.752  1.00 17.46      A    C  
ATOM   1774  NH1 ARG   245     -19.447  35.253  25.794  1.00 18.23      A    N  
ATOM   1775  NH2 ARG   245     -20.500  37.252  25.340  1.00 18.18      A    N  
ATOM   1776  C   ARG   245     -12.728  34.434  25.539  1.00  7.69      A    C  
ATOM   1777  O   ARG   245     -12.555  33.255  25.883  1.00  7.79      A    O  
ATOM   1778  N   LEU   246     -11.809  35.383  25.711  1.00  6.72      A    N  
ATOM   1779  CA  LEU   246     -10.589  35.142  26.482  1.00  6.91      A    C  
ATOM   1780  CB  LEU   246      -9.657  36.349  26.374  1.00  6.90      A    C  
ATOM   1781  CG  LEU   246      -9.406  36.891  24.966  1.00  7.52      A    C  
ATOM   1782  CD1 LEU   246      -8.399  38.008  25.075  1.00  7.96      A    C  
ATOM   1783  CD2 LEU   246      -8.882  35.808  24.008  1.00  7.60      A    C  
ATOM   1784  C   LEU   246     -10.946  34.918  27.944  1.00  6.90      A    C  
ATOM   1785  O   LEU   246     -11.898  35.516  28.459  1.00  6.64      A    O  
ATOM   1786  N   ILE   247     -10.188  34.049  28.622  1.00  6.47      A    N  
ATOM   1787  CA  ILE   247     -10.391  33.828  30.046  1.00  7.04      A    C  
ATOM   1788  CB  ILE   247     -10.809  32.383  30.359  1.00  7.69      A    C  
ATOM   1789  CG1 ILE   247     -12.036  31.980  29.524  1.00  7.94      A    C  
ATOM   1790  CD1 ILE   247     -13.328  32.787  29.804  1.00  9.23      A    C  
ATOM   1791  CG2 ILE   247     -11.017  32.201  31.879  1.00  7.54      A    C  
ATOM   1792  C   ILE   247      -9.096  34.128  30.808  1.00  7.59      A    C  
ATOM   1793  O   ILE   247      -8.041  33.566  30.490  1.00  7.66      A    O  
ATOM   1794  N   TYR   248      -9.183  35.037  31.774  1.00  6.63      A    N  
ATOM   1795  CA  TYR   248      -8.061  35.387  32.656  1.00  7.52      A    C  
ATOM   1796  CB  TYR   248      -7.717  36.877  32.522  1.00  6.90      A    C  
ATOM   1797  CG  TYR   248      -6.871  37.252  31.325  1.00  6.89      A    C  
ATOM   1798  CD1 TYR   248      -7.283  36.959  30.031  1.00  8.25      A    C  
ATOM   1799  CE1 TYR   248      -6.493  37.307  28.918  1.00  7.50      A    C  
ATOM   1800  CZ  TYR   248      -5.300  37.970  29.107  1.00  8.26      A    C  
ATOM   1801  OH  TYR   248      -4.527  38.327  28.006  1.00  8.26      A    O  
ATOM   1802  CE2 TYR   248      -4.879  38.296  30.388  1.00  8.23      A    C  
ATOM   1803  CD2 TYR   248      -5.665  37.933  31.488  1.00  6.66      A    C  
ATOM   1804  C   TYR   248      -8.436  35.148  34.119  1.00  7.85      A    C  
ATOM   1805  O   TYR   248      -9.444  35.664  34.588  1.00  7.69      A    O  
ATOM   1806  N   PRO   249      -7.607  34.411  34.878  1.00  8.01      A    N  
ATOM   1807  CA  PRO   249      -7.784  34.403  36.333  1.00  8.05      A    C  
ATOM   1808  CB  PRO   249      -6.676  33.436  36.809  1.00  8.48      A    C  
ATOM   1809  CG  PRO   249      -6.459  32.531  35.608  1.00  8.53      A    C  
ATOM   1810  CD  PRO   249      -6.546  33.480  34.439  1.00  8.42      A    C  
ATOM   1811  C   PRO   249      -7.554  35.811  36.915  1.00  8.25      A    C  
ATOM   1812  O   PRO   249      -7.012  36.677  36.224  1.00  8.85      A    O  
ATOM   1813  N   VAL   250      -7.979  36.049  38.151  1.00  8.72      A    N  
ATOM   1814  CA  VAL   250      -7.806  37.380  38.754  1.00  9.24      A    C  
ATOM   1815  CB  VAL   250      -8.527  37.510  40.115  1.00  8.62      A    C  
ATOM   1816  CG1 VAL   250     -10.028  37.359  39.916  1.00  9.05      A    C  
ATOM   1817  CG2 VAL   250      -7.981  36.471  41.143  1.00  9.59      A    C  
ATOM   1818  C   VAL   250      -6.325  37.732  38.890  1.00 10.19      A    C  
ATOM   1819  O   VAL   250      -5.478  36.850  38.996  1.00 11.06      A    O  
ATOM   1820  N   PRO   251      -6.013  39.032  38.878  1.00 11.49      A    N  
ATOM   1821  CA  PRO   251      -4.615  39.468  38.860  1.00 12.67      A    C  
ATOM   1822  CB  PRO   251      -4.699  40.998  38.995  1.00 13.04      A    C  
ATOM   1823  CG  PRO   251      -6.090  41.374  38.662  1.00 13.39      A    C  
ATOM   1824  CD  PRO   251      -6.975  40.144  38.748  1.00 11.42      A    C  
ATOM   1825  C   PRO   251      -3.823  38.892  40.025  1.00 13.50      A    C  
ATOM   1826  O   PRO   251      -2.634  38.547  39.869  1.00 14.04      A    O  
ATOM   1827  N   GLN   252      -4.471  38.784  41.184  1.00 13.91      A    N  
ATOM   1828  CA  GLN   252      -3.800  38.367  42.401  1.00 15.27      A    C  
ATOM   1829  CB  GLN   252      -4.293  39.199  43.597  1.00 15.31      A    C  
ATOM   1830  CG  GLN   252      -3.215  39.549  44.587  1.00 17.01      A    C  
ATOM   1831  CD  GLN   252      -3.704  40.492  45.674  1.00 18.72      A    C  
ATOM   1832  OE1 GLN   252      -4.049  41.651  45.402  1.00 17.92      A    O  
ATOM   1833  NE2 GLN   252      -3.720  40.005  46.915  1.00 17.66      A    N  
ATOM   1834  C   GLN   252      -3.961  36.884  42.701  1.00 15.14      A    C  
ATOM   1835  O   GLN   252      -3.677  36.432  43.816  1.00 16.38      A    O  
ATOM   1836  N   HIS   253      -4.431  36.124  41.717  1.00 15.20      A    N  
ATOM   1837  CA  HIS   253      -4.524  34.676  41.858  1.00 14.68      A    C  
ATOM   1838  CB  HIS   253      -4.903  34.044  40.513  1.00 14.79      A    C  
ATOM   1839  CG  HIS   253      -5.038  32.553  40.563  1.00 14.76      A    C  
ATOM   1840  ND1 HIS   253      -6.113  31.921  41.152  1.00 15.27      A    N  
ATOM   1841  CE1 HIS   253      -5.958  30.611  41.054  1.00 15.48      A    C  
ATOM   1842  NE2 HIS   253      -4.822  30.372  40.421  1.00 16.56      A    N  
ATOM   1843  CD2 HIS   253      -4.224  31.569  40.107  1.00 15.28      A    C  
ATOM   1844  C   HIS   253      -3.184  34.118  42.317  1.00 14.76      A    C  
ATOM   1845  O   HIS   253      -2.138  34.479  41.782  1.00 14.89      A    O  
ATOM   1846  N   ALA   254      -3.223  33.213  43.285  1.00 15.30      A    N  
ATOM   1847  CA  ALA   254      -1.996  32.664  43.859  1.00 16.18      A    C  
ATOM   1848  CB  ALA   254      -2.328  31.861  45.092  1.00 16.78      A    C  
ATOM   1849  C   ALA   254      -1.238  31.789  42.859  1.00 16.59      A    C  
ATOM   1850  O   ALA   254      -1.829  30.920  42.214  1.00 17.65      A    O  
ATOM   1851  N   GLY   255       0.063  32.029  42.727  1.00 16.56      A    N  
ATOM   1852  CA  GLY   255       0.907  31.172  41.884  1.00 16.33      A    C  
ATOM   1853  C   GLY   255       0.601  31.357  40.410  1.00 15.39      A    C  
ATOM   1854  O   GLY   255       0.450  32.485  39.937  1.00 16.73      A    O  
ATOM   1855  N   LEU   256       0.508  30.252  39.678  1.00 13.88      A    N  
ATOM   1856  CA  LEU   256       0.411  30.324  38.224  1.00 13.15      A    C  
ATOM   1857  CB  LEU   256       0.780  28.971  37.623  1.00 12.51      A    C  
ATOM   1858  CG  LEU   256       0.705  28.845  36.106  1.00 12.90      A    C  
ATOM   1859  CD1 LEU   256       1.749  29.690  35.464  1.00 11.55      A    C  
ATOM   1860  CD2 LEU   256       0.904  27.395  35.692  1.00 13.45      A    C  
ATOM   1861  C   LEU   256      -0.984  30.708  37.755  1.00 12.43      A    C  
ATOM   1862  O   LEU   256      -1.940  29.997  38.006  1.00 12.30      A    O  
ATOM   1863  N   GLY   257      -1.093  31.831  37.057  1.00 12.39      A    N  
ATOM   1864  CA  GLY   257      -2.366  32.215  36.455  1.00 11.94      A    C  
ATOM   1865  C   GLY   257      -2.323  31.976  34.962  1.00 11.42      A    C  
ATOM   1866  O   GLY   257      -1.634  32.696  34.248  1.00 12.25      A    O  
ATOM   1867  N   VAL   258      -3.048  30.961  34.498  1.00 10.57      A    N  
ATOM   1868  CA  VAL   258      -2.984  30.582  33.097  1.00  9.65      A    C  
ATOM   1869  CB  VAL   258      -3.137  29.058  32.912  1.00  9.42      A    C  
ATOM   1870  CG1 VAL   258      -3.011  28.718  31.435  1.00  9.96      A    C  
ATOM   1871  CG2 VAL   258      -2.075  28.321  33.719  1.00 10.25      A    C  
ATOM   1872  C   VAL   258      -4.097  31.250  32.313  1.00  8.69      A    C  
ATOM   1873  O   VAL   258      -5.276  31.018  32.589  1.00  8.82      A    O  
ATOM   1874  N   HIS   259      -3.720  32.091  31.355  1.00  8.69      A    N  
ATOM   1875  CA  HIS   259      -4.708  32.697  30.470  1.00  8.52      A    C  
ATOM   1876  CB  HIS   259      -4.157  33.940  29.775  1.00  8.94      A    C  
ATOM   1877  CG  HIS   259      -3.517  34.931  30.699  1.00  8.70      A    C  
ATOM   1878  ND1 HIS   259      -2.588  35.855  30.264  1.00 11.17      A    N  
ATOM   1879  CE1 HIS   259      -2.184  36.584  31.289  1.00  9.89      A    C  
ATOM   1880  NE2 HIS   259      -2.829  36.173  32.373  1.00  9.26      A    N  
ATOM   1881  CD2 HIS   259      -3.662  35.135  32.027  1.00  9.65      A    C  
ATOM   1882  C   HIS   259      -5.134  31.723  29.387  1.00  8.75      A    C  
ATOM   1883  O   HIS   259      -4.316  30.982  28.842  1.00  8.21      A    O  
ATOM   1884  N   LEU   260      -6.416  31.751  29.058  1.00  8.61      A    N  
ATOM   1885  CA  LEU   260      -6.900  31.053  27.879  1.00  9.66      A    C  
ATOM   1886  CB  LEU   260      -8.147  30.251  28.227  1.00 10.52      A    C  
ATOM   1887  CG  LEU   260      -8.652  29.286  27.155  1.00 13.49      A    C  
ATOM   1888  CD1 LEU   260      -9.657  28.342  27.788  1.00 17.17      A    C  
ATOM   1889  CD2 LEU   260      -9.279  30.057  26.026  1.00 16.43      A    C  
ATOM   1890  C   LEU   260      -7.185  32.131  26.839  1.00 10.52      A    C  
ATOM   1891  O   LEU   260      -8.030  33.010  27.054  1.00 11.23      A    O  
ATOM   1892  N   THR   261      -6.423  32.130  25.758  1.00 10.04      A    N  
ATOM   1893  CA  THR   261      -6.660  33.112  24.697  1.00 10.77      A    C  
ATOM   1894  CB  THR   261      -5.520  34.133  24.573  1.00 11.63      A    C  
ATOM   1895  OG1 THR   261      -4.338  33.465  24.116  1.00 11.35      A    O  
ATOM   1896  CG2 THR   261      -5.246  34.799  25.932  1.00 10.48      A    C  
ATOM   1897  C   THR   261      -6.942  32.398  23.365  1.00 10.91      A    C  
ATOM   1898  O   THR   261      -6.902  31.169  23.287  1.00 10.94      A    O  
ATOM   1899  N   LEU   262      -7.303  33.167  22.346  1.00 11.44      A    N  
ATOM   1900  CA  LEU   262      -7.759  32.573  21.086  1.00 12.06      A    C  
ATOM   1901  CB  LEU   262      -9.257  32.816  20.886  1.00 11.86      A    C  
ATOM   1902  CG  LEU   262     -10.225  32.119  21.861  1.00 13.23      A    C  
ATOM   1903  CD1 LEU   262     -11.575  32.859  21.908  1.00 16.99      A    C  
ATOM   1904  CD2 LEU   262     -10.415  30.624  21.528  1.00 17.13      A    C  
ATOM   1905  C   LEU   262      -6.988  33.223  19.957  1.00 12.69      A    C  
ATOM   1906  O   LEU   262      -6.642  34.406  20.032  1.00 12.48      A    O  
ATOM   1907  N   ASP   263      -6.687  32.449  18.921  1.00 13.40      A    N  
ATOM   1908  CA  ASP   263      -6.116  33.060  17.729  1.00 15.29      A    C  
ATOM   1909  CB  ASP   263      -5.002  32.205  17.105  1.00 16.06      A    C  
ATOM   1910  CG  ASP   263      -5.496  30.896  16.566  1.00 18.95      A    C  
ATOM   1911  OD1 ASP   263      -6.674  30.822  16.152  1.00 22.94      A    O  
ATOM   1912  OD2 ASP   263      -4.685  29.936  16.531  1.00 24.02      A    O  
ATOM   1913  C   ASP   263      -7.252  33.389  16.761  1.00 15.40      A    C  
ATOM   1914  O   ASP   263      -8.402  33.042  17.010  1.00 15.48      A    O  
ATOM   1915  N   LEU   264      -6.938  34.090  15.680  1.00 16.38      A    N  
ATOM   1916  CA  LEU   264      -7.959  34.531  14.748  1.00 17.60      A    C  
ATOM   1917  CB  LEU   264      -7.346  35.483  13.731  1.00 18.04      A    C  
ATOM   1918  CG  LEU   264      -7.108  36.889  14.284  1.00 18.95      A    C  
ATOM   1919  CD1 LEU   264      -6.402  37.738  13.241  1.00 20.48      A    C  
ATOM   1920  CD2 LEU   264      -8.429  37.520  14.675  1.00 20.84      A    C  
ATOM   1921  C   LEU   264      -8.685  33.378  14.051  1.00 18.29      A    C  
ATOM   1922  O   LEU   264      -9.833  33.525  13.620  1.00 18.22      A    O  
ATOM   1923  N   GLY   265      -8.016  32.234  13.960  1.00 18.52      A    N  
ATOM   1924  CA  GLY   265      -8.620  31.038  13.369  1.00 19.30      A    C  
ATOM   1925  C   GLY   265      -9.548  30.300  14.320  1.00 19.32      A    C  
ATOM   1926  O   GLY   265     -10.167  29.304  13.942  1.00 20.36      A    O  
ATOM   1927  N   GLY   266      -9.637  30.771  15.565  1.00 18.85      A    N  
ATOM   1928  CA  GLY   266     -10.577  30.211  16.536  1.00 17.59      A    C  
ATOM   1929  C   GLY   266      -9.999  29.184  17.493  1.00 17.14      A    C  
ATOM   1930  O   GLY   266     -10.731  28.623  18.318  1.00 17.58      A    O  
ATOM   1931  N   GLN   267      -8.692  28.935  17.395  1.00 16.26      A    N  
ATOM   1932  CA  GLN   267      -8.055  27.892  18.210  1.00 15.98      A    C  
ATOM   1933  CB  GLN   267      -6.863  27.292  17.476  1.00 16.35      A    C  
ATOM   1934  CG  GLN   267      -7.210  26.755  16.080  1.00 21.10      A    C  
ATOM   1935  CD  GLN   267      -7.859  25.373  16.091  1.00 26.43      A    C  
ATOM   1936  OE1 GLN   267      -8.851  25.129  16.782  1.00 30.29      A    O  
ATOM   1937  NE2 GLN   267      -7.306  24.463  15.290  1.00 30.58      A    N  
ATOM   1938  C   GLN   267      -7.609  28.471  19.541  1.00 14.60      A    C  
ATOM   1939  O   GLN   267      -7.183  29.624  19.593  1.00 14.37      A    O  
ATOM   1940  N   ALA   268      -7.710  27.676  20.606  1.00 13.38      A    N  
ATOM   1941  CA  ALA   268      -7.384  28.160  21.941  1.00 12.52      A    C  
ATOM   1942  CB  ALA   268      -8.259  27.471  22.988  1.00 13.02      A    C  
ATOM   1943  C   ALA   268      -5.915  27.917  22.246  1.00 11.90      A    C  
ATOM   1944  O   ALA   268      -5.331  26.927  21.801  1.00 12.23      A    O  
ATOM   1945  N   LYS   269      -5.314  28.826  22.995  1.00 10.24      A    N  
ATOM   1946  CA  LYS   269      -3.986  28.578  23.550  1.00 10.60      A    C  
ATOM   1947  CB  LYS   269      -2.871  29.230  22.738  1.00 11.48      A    C  
ATOM   1948  CG  LYS   269      -2.947  30.716  22.716  1.00 13.20      A    C  
ATOM   1949  CD  LYS   269      -1.853  31.356  21.843  1.00 17.38      A    C  
ATOM   1950  CE  LYS   269      -2.293  32.753  21.451  1.00 20.16      A    C  
ATOM   1951  NZ  LYS   269      -1.334  33.490  20.577  1.00 20.54      A    N  
ATOM   1952  C   LYS   269      -3.938  28.996  25.012  1.00 10.06      A    C  
ATOM   1953  O   LYS   269      -4.770  29.771  25.472  1.00  9.28      A    O  
ATOM   1954  N   PHE   270      -2.968  28.441  25.735  1.00  8.64      A    N  
ATOM   1955  CA  PHE   270      -2.882  28.636  27.175  1.00  9.31      A    C  
ATOM   1956  CB  PHE   270      -3.107  27.301  27.876  1.00 10.08      A    C  
ATOM   1957  CG  PHE   270      -4.514  26.808  27.745  1.00 11.56      A    C  
ATOM   1958  CD1 PHE   270      -5.493  27.252  28.622  1.00 15.06      A    C  
ATOM   1959  CE1 PHE   270      -6.813  26.837  28.497  1.00 15.20      A    C  
ATOM   1960  CZ  PHE   270      -7.158  25.955  27.482  1.00 15.93      A    C  
ATOM   1961  CE2 PHE   270      -6.192  25.526  26.583  1.00 14.70      A    C  
ATOM   1962  CD2 PHE   270      -4.866  25.956  26.722  1.00 16.44      A    C  
ATOM   1963  C   PHE   270      -1.530  29.190  27.518  1.00  8.87      A    C  
ATOM   1964  O   PHE   270      -0.529  28.749  26.955  1.00  8.57      A    O  
ATOM   1965  N   GLY   271      -1.503  30.146  28.445  1.00  8.10      A    N  
ATOM   1966  CA  GLY   271      -0.254  30.823  28.796  1.00  8.35      A    C  
ATOM   1967  C   GLY   271      -0.336  32.310  28.536  1.00  8.42      A    C  
ATOM   1968  O   GLY   271      -1.385  32.808  28.124  1.00  8.25      A    O  
ATOM   1969  N   PRO   272       0.782  33.024  28.732  1.00  8.68      A    N  
ATOM   1970  CA  PRO   272       2.107  32.459  29.043  1.00  8.92      A    C  
ATOM   1971  CB  PRO   272       3.045  33.569  28.563  1.00  9.05      A    C  
ATOM   1972  CG  PRO   272       2.256  34.840  28.942  1.00  9.03      A    C  
ATOM   1973  CD  PRO   272       0.841  34.490  28.557  1.00  8.18      A    C  
ATOM   1974  C   PRO   272       2.352  32.239  30.533  1.00  9.61      A    C  
ATOM   1975  O   PRO   272       1.695  32.863  31.384  1.00  9.74      A    O  
ATOM   1976  N   ASP   273       3.305  31.366  30.862  1.00  9.99      A    N  
ATOM   1977  CA  ASP   273       3.746  31.278  32.240  1.00  9.85      A    C  
ATOM   1978  CB  ASP   273       4.195  29.841  32.616  1.00  9.69      A    C  
ATOM   1979  CG  ASP   273       5.453  29.387  31.881  1.00 10.66      A    C  
ATOM   1980  OD1 ASP   273       5.979  30.139  31.040  1.00 10.49      A    O  
ATOM   1981  OD2 ASP   273       5.917  28.246  32.154  1.00 12.27      A    O  
ATOM   1982  C   ASP   273       4.850  32.299  32.470  1.00  9.78      A    C  
ATOM   1983  O   ASP   273       5.055  33.214  31.638  1.00  9.27      A    O  
ATOM   1984  N   THR   274       5.547  32.158  33.595  1.00 10.55      A    N  
ATOM   1985  CA  THR   274       6.660  33.056  33.909  1.00 11.27      A    C  
ATOM   1986  CB  THR   274       6.322  34.072  35.011  1.00 12.04      A    C  
ATOM   1987  OG1 THR   274       5.862  33.379  36.167  1.00 14.76      A    O  
ATOM   1988  CG2 THR   274       5.248  35.032  34.541  1.00 11.04      A    C  
ATOM   1989  C   THR   274       7.901  32.272  34.325  1.00 11.15      A    C  
ATOM   1990  O   THR   274       7.835  31.367  35.162  1.00 12.09      A    O  
ATOM   1991  N   GLU   275       9.025  32.653  33.741  1.00 10.62      A    N  
ATOM   1992  CA  GLU   275      10.268  31.926  33.968  1.00 10.76      A    C  
ATOM   1993  CB  GLU   275      10.368  30.782  32.959  1.00 10.82      A    C  
ATOM   1994  CG  GLU   275      11.597  29.872  33.165  1.00 12.29      A    C  
ATOM   1995  CD  GLU   275      11.835  28.931  32.002  1.00 15.29      A    C  
ATOM   1996  OE1 GLU   275      12.893  28.229  32.001  1.00 14.65      A    O  
ATOM   1997  OE2 GLU   275      10.980  28.881  31.084  1.00 11.82      A    O  
ATOM   1998  C   GLU   275      11.452  32.866  33.805  1.00 10.62      A    C  
ATOM   1999  O   GLU   275      11.833  33.208  32.686  1.00  9.94      A    O  
ATOM   2000  N   TRP   276      12.040  33.279  34.925  1.00 11.47      A    N  
ATOM   2001  CA  TRP   276      13.182  34.184  34.858  1.00 11.40      A    C  
ATOM   2002  CB  TRP   276      13.425  34.853  36.213  1.00 11.92      A    C  
ATOM   2003  CG  TRP   276      12.284  35.761  36.620  1.00 12.48      A    C  
ATOM   2004  CD1 TRP   276      11.097  35.382  37.190  1.00 14.61      A    C  
ATOM   2005  NE1 TRP   276      10.303  36.489  37.406  1.00 16.05      A    N  
ATOM   2006  CE2 TRP   276      10.974  37.606  36.980  1.00 15.55      A    C  
ATOM   2007  CD2 TRP   276      12.226  37.186  36.478  1.00 13.93      A    C  
ATOM   2008  CE3 TRP   276      13.108  38.147  35.968  1.00 13.89      A    C  
ATOM   2009  CZ3 TRP   276      12.724  39.483  35.988  1.00 12.81      A    C  
ATOM   2010  CH2 TRP   276      11.482  39.870  36.505  1.00 13.78      A    C  
ATOM   2011  CZ2 TRP   276      10.590  38.953  36.999  1.00 13.37      A    C  
ATOM   2012  C   TRP   276      14.406  33.401  34.418  1.00 11.85      A    C  
ATOM   2013  O   TRP   276      14.698  32.349  34.993  1.00 12.20      A    O  
ATOM   2014  N   ILE   277      15.088  33.904  33.392  1.00 11.57      A    N  
ATOM   2015  CA  ILE   277      16.202  33.196  32.775  1.00 11.71      A    C  
ATOM   2016  CB  ILE   277      15.816  32.558  31.422  1.00 11.61      A    C  
ATOM   2017  CG1 ILE   277      15.292  33.628  30.441  1.00 12.57      A    C  
ATOM   2018  CD1 ILE   277      15.054  33.139  29.003  1.00 13.97      A    C  
ATOM   2019  CG2 ILE   277      14.806  31.459  31.656  1.00 10.36      A    C  
ATOM   2020  C   ILE   277      17.420  34.094  32.591  1.00 12.72      A    C  
ATOM   2021  O   ILE   277      17.313  35.316  32.642  1.00 13.24      A    O  
ATOM   2022  N   ALA   278      18.573  33.473  32.357  1.00 13.28      A    N  
ATOM   2023  CA  ALA   278      19.847  34.188  32.279  1.00 14.04      A    C  
ATOM   2024  CB  ALA   278      20.958  33.315  32.878  1.00 14.41      A    C  
ATOM   2025  C   ALA   278      20.253  34.618  30.868  1.00 14.68      A    C  
ATOM   2026  O   ALA   278      21.076  35.527  30.702  1.00 15.66      A    O  
ATOM   2027  N   THR   279      19.738  33.921  29.859  1.00 14.41      A    N  
ATOM   2028  CA  THR   279      20.135  34.169  28.482  1.00 15.06      A    C  
ATOM   2029  CB  THR   279      21.205  33.163  27.999  1.00 14.74      A    C  
ATOM   2030  OG1 THR   279      20.605  31.872  27.844  1.00 16.89      A    O  
ATOM   2031  CG2 THR   279      22.352  33.056  29.002  1.00 17.10      A    C  
ATOM   2032  C   THR   279      18.933  34.054  27.565  1.00 14.88      A    C  
ATOM   2033  O   THR   279      17.903  33.500  27.955  1.00 14.75      A    O  
ATOM   2034  N   GLU   280      19.082  34.572  26.346  1.00 15.09      A    N  
ATOM   2035  CA  GLU   280      17.990  34.642  25.385  1.00 15.97      A    C  
ATOM   2036  CB  GLU   280      18.277  35.734  24.351  1.00 16.40      A    C  
ATOM   2037  CG  GLU   280      17.062  36.105  23.512  1.00 16.26      A    C  
ATOM   2038  CD  GLU   280      17.353  37.197  22.503  1.00 17.86      A    C  
ATOM   2039  OE1 GLU   280      18.480  37.743  22.516  1.00 17.75      A    O  
ATOM   2040  OE2 GLU   280      16.447  37.510  21.699  1.00 15.48      A    O  
ATOM   2041  C   GLU   280      17.781  33.319  24.672  1.00 16.35      A    C  
ATOM   2042  O   GLU   280      18.318  33.093  23.575  1.00 17.34      A    O  
ATOM   2043  N   ASP   281      16.976  32.459  25.280  1.00 16.27      A    N  
ATOM   2044  CA  ASP   281      16.787  31.103  24.811  1.00 15.94      A    C  
ATOM   2045  CB  ASP   281      17.349  30.156  25.848  1.00 16.71      A    C  
ATOM   2046  CG  ASP   281      17.211  28.714  25.451  1.00 19.98      A    C  
ATOM   2047  OD1 ASP   281      16.590  28.437  24.404  1.00 22.88      A    O  
ATOM   2048  OD2 ASP   281      17.740  27.860  26.198  1.00 24.64      A    O  
ATOM   2049  C   ASP   281      15.296  30.830  24.614  1.00 15.49      A    C  
ATOM   2050  O   ASP   281      14.542  30.828  25.582  1.00 15.13      A    O  
ATOM   2051  N   TYR   282      14.884  30.622  23.368  1.00 15.22      A    N  
ATOM   2052  CA  TYR   282      13.450  30.475  23.022  1.00 15.44      A    C  
ATOM   2053  CB  TYR   282      13.120  31.173  21.694  1.00 15.29      A    C  
ATOM   2054  CG  TYR   282      13.325  32.658  21.760  1.00 16.45      A    C  
ATOM   2055  CD1 TYR   282      12.366  33.484  22.340  1.00 16.25      A    C  
ATOM   2056  CE1 TYR   282      12.565  34.837  22.436  1.00 16.29      A    C  
ATOM   2057  CZ  TYR   282      13.737  35.389  21.938  1.00 16.47      A    C  
ATOM   2058  OH  TYR   282      13.940  36.741  22.031  1.00 18.48      A    O  
ATOM   2059  CE2 TYR   282      14.695  34.591  21.355  1.00 16.16      A    C  
ATOM   2060  CD2 TYR   282      14.487  33.236  21.274  1.00 15.31      A    C  
ATOM   2061  C   TYR   282      12.974  29.036  22.964  1.00 15.74      A    C  
ATOM   2062  O   TYR   282      11.809  28.772  22.639  1.00 15.76      A    O  
ATOM   2063  N   THR   283      13.872  28.106  23.270  1.00 16.29      A    N  
ATOM   2064  CA  THR   283      13.540  26.694  23.216  1.00 16.87      A    C  
ATOM   2065  CB  THR   283      14.729  25.826  23.644  1.00 17.42      A    C  
ATOM   2066  OG1 THR   283      15.899  26.263  22.946  1.00 19.92      A    O  
ATOM   2067  CG2 THR   283      14.468  24.360  23.320  1.00 18.08      A    C  
ATOM   2068  C   THR   283      12.339  26.359  24.096  1.00 16.86      A    C  
ATOM   2069  O   THR   283      12.297  26.708  25.266  1.00 15.97      A    O  
ATOM   2070  N   LEU   284      11.362  25.665  23.519  1.00 17.40      A    N  
ATOM   2071  CA  LEU   284      10.183  25.252  24.271  1.00 17.56      A    C  
ATOM   2072  CB  LEU   284       8.997  25.061  23.323  1.00 17.84      A    C  
ATOM   2073  CG  LEU   284       7.692  24.549  23.951  1.00 18.55      A    C  
ATOM   2074  CD1 LEU   284       7.000  25.612  24.813  1.00 20.18      A    C  
ATOM   2075  CD2 LEU   284       6.745  24.055  22.881  1.00 20.17      A    C  
ATOM   2076  C   LEU   284      10.419  23.968  25.070  1.00 17.57      A    C  
ATOM   2077  O   LEU   284      10.850  22.939  24.518  1.00 18.00      A    O  
ATOM   2078  N   ASP   285      10.145  24.030  26.370  1.00 16.60      A    N  
ATOM   2079  CA  ASP   285      10.186  22.856  27.220  1.00 17.28      A    C  
ATOM   2080  CB  ASP   285      10.779  23.206  28.585  1.00 17.02      A    C  
ATOM   2081  CG  ASP   285      10.878  22.006  29.514  1.00 18.78      A    C  
ATOM   2082  OD1 ASP   285      10.399  20.910  29.164  1.00 18.34      A    O  
ATOM   2083  OD2 ASP   285      11.442  22.164  30.619  1.00 21.24      A    O  
ATOM   2084  C   ASP   285       8.764  22.347  27.380  1.00 17.24      A    C  
ATOM   2085  O   ASP   285       7.975  22.935  28.125  1.00 16.97      A    O  
ATOM   2086  N   PRO   286       8.418  21.263  26.667  1.00 17.26      A    N  
ATOM   2087  CA  PRO   286       7.056  20.743  26.719  1.00 17.54      A    C  
ATOM   2088  CB  PRO   286       7.129  19.466  25.872  1.00 17.50      A    C  
ATOM   2089  CG  PRO   286       8.298  19.666  24.974  1.00 18.33      A    C  
ATOM   2090  CD  PRO   286       9.285  20.459  25.791  1.00 17.69      A    C  
ATOM   2091  C   PRO   286       6.624  20.394  28.135  1.00 17.34      A    C  
ATOM   2092  O   PRO   286       5.423  20.382  28.431  1.00 17.57      A    O  
ATOM   2093  N   ARG   287       7.586  20.103  29.006  1.00 17.57      A    N  
ATOM   2094  CA  ARG   287       7.267  19.708  30.374  1.00 17.64      A    C  
ATOM   2095  CB  ARG   287       8.468  19.049  31.063  1.00 18.31      A    C  
ATOM   2096  CG  ARG   287       8.897  17.733  30.394  1.00 22.54      A    C  
ATOM   2097  CD  ARG   287       7.687  16.877  30.034  1.00 27.59      A    C  
ATOM   2098  NE  ARG   287       7.130  16.192  31.197  1.00 32.67      A    N  
ATOM   2099  CZ  ARG   287       5.889  15.711  31.256  1.00 35.40      A    C  
ATOM   2100  NH1 ARG   287       5.064  15.869  30.231  1.00 36.13      A    N  
ATOM   2101  NH2 ARG   287       5.461  15.091  32.355  1.00 37.15      A    N  
ATOM   2102  C   ARG   287       6.716  20.853  31.216  1.00 16.94      A    C  
ATOM   2103  O   ARG   287       6.134  20.629  32.268  1.00 17.31      A    O  
ATOM   2104  N   ARG   288       6.875  22.083  30.734  1.00 15.87      A    N  
ATOM   2105  CA  ARG   288       6.365  23.230  31.472  1.00 14.59      A    C  
ATOM   2106  CB  ARG   288       6.936  24.536  30.909  1.00 14.24      A    C  
ATOM   2107  CG  ARG   288       8.441  24.735  31.179  1.00 13.41      A    C  
ATOM   2108  CD  ARG   288       8.886  26.175  30.981  1.00 14.26      A    C  
ATOM   2109  NE  ARG   288       8.313  27.029  32.022  1.00 13.59      A    N  
ATOM   2110  CZ  ARG   288       8.821  27.191  33.239  1.00 14.84      A    C  
ATOM   2111  NH1 ARG   288       9.934  26.549  33.599  1.00 13.13      A    N  
ATOM   2112  NH2 ARG   288       8.203  27.985  34.105  1.00 13.55      A    N  
ATOM   2113  C   ARG   288       4.829  23.257  31.479  1.00 13.80      A    C  
ATOM   2114  O   ARG   288       4.213  23.954  32.300  1.00 12.53      A    O  
ATOM   2115  N   ALA   289       4.217  22.487  30.581  1.00 13.00      A    N  
ATOM   2116  CA  ALA   289       2.752  22.351  30.572  1.00 12.95      A    C  
ATOM   2117  CB  ALA   289       2.268  21.718  29.257  1.00 13.05      A    C  
ATOM   2118  C   ALA   289       2.201  21.553  31.762  1.00 12.66      A    C  
ATOM   2119  O   ALA   289       1.017  21.620  32.074  1.00 12.60      A    O  
ATOM   2120  N   ASP   290       3.044  20.760  32.417  1.00 13.55      A    N  
ATOM   2121  CA  ASP   290       2.541  19.898  33.475  1.00 13.88      A    C  
ATOM   2122  CB  ASP   290       3.702  19.117  34.111  1.00 14.93      A    C  
ATOM   2123  CG  ASP   290       4.303  18.102  33.169  1.00 18.97      A    C  
ATOM   2124  OD1 ASP   290       3.702  17.847  32.102  1.00 22.29      A    O  
ATOM   2125  OD2 ASP   290       5.366  17.529  33.510  1.00 22.42      A    O  
ATOM   2126  C   ASP   290       1.740  20.647  34.558  1.00 13.43      A    C  
ATOM   2127  O   ASP   290       0.681  20.189  34.999  1.00 12.95      A    O  
ATOM   2128  N   VAL   291       2.241  21.805  34.979  1.00 12.94      A    N  
ATOM   2129  CA  VAL   291       1.579  22.575  36.025  1.00 12.20      A    C  
ATOM   2130  CB  VAL   291       2.554  23.571  36.672  1.00 12.87      A    C  
ATOM   2131  CG1 VAL   291       3.669  22.836  37.399  1.00 13.57      A    C  
ATOM   2132  CG2 VAL   291       3.136  24.471  35.635  1.00 12.19      A    C  
ATOM   2133  C   VAL   291       0.364  23.350  35.495  1.00 12.43      A    C  
ATOM   2134  O   VAL   291      -0.433  23.885  36.280  1.00 12.01      A    O  
ATOM   2135  N   PHE   292       0.240  23.442  34.168  1.00 11.95      A    N  
ATOM   2136  CA  PHE   292      -0.914  24.152  33.578  1.00 10.92      A    C  
ATOM   2137  CB  PHE   292      -0.783  24.271  32.058  1.00 11.04      A    C  
ATOM   2138  CG  PHE   292       0.084  25.418  31.582  1.00 10.23      A    C  
ATOM   2139  CD1 PHE   292       1.360  25.624  32.097  1.00 10.82      A    C  
ATOM   2140  CE1 PHE   292       2.176  26.666  31.613  1.00 11.82      A    C  
ATOM   2141  CZ  PHE   292       1.696  27.517  30.616  1.00 10.93      A    C  
ATOM   2142  CE2 PHE   292       0.426  27.298  30.083  1.00 10.64      A    C  
ATOM   2143  CD2 PHE   292      -0.366  26.258  30.563  1.00 10.22      A    C  
ATOM   2144  C   PHE   292      -2.238  23.453  33.884  1.00 11.02      A    C  
ATOM   2145  O   PHE   292      -3.282  24.107  34.008  1.00 10.60      A    O  
ATOM   2146  N   TYR   293      -2.209  22.127  33.970  1.00  9.73      A    N  
ATOM   2147  CA  TYR   293      -3.455  21.374  34.016  1.00  9.69      A    C  
ATOM   2148  CB  TYR   293      -3.162  19.869  33.976  1.00  9.58      A    C  
ATOM   2149  CG  TYR   293      -2.775  19.407  32.593  1.00  9.06      A    C  
ATOM   2150  CD1 TYR   293      -3.750  18.990  31.689  1.00 11.13      A    C  
ATOM   2151  CE1 TYR   293      -3.423  18.569  30.413  1.00 10.53      A    C  
ATOM   2152  CZ  TYR   293      -2.108  18.560  30.016  1.00 10.33      A    C  
ATOM   2153  OH  TYR   293      -1.790  18.143  28.740  1.00 13.17      A    O  
ATOM   2154  CE2 TYR   293      -1.109  18.985  30.880  1.00 10.09      A    C  
ATOM   2155  CD2 TYR   293      -1.456  19.412  32.178  1.00  9.39      A    C  
ATOM   2156  C   TYR   293      -4.368  21.737  35.191  1.00  9.92      A    C  
ATOM   2157  O   TYR   293      -5.554  22.004  34.993  1.00  9.94      A    O  
ATOM   2158  N   ALA   294      -3.819  21.748  36.400  1.00 10.38      A    N  
ATOM   2159  CA  ALA   294      -4.618  22.040  37.593  1.00 10.88      A    C  
ATOM   2160  CB  ALA   294      -3.809  21.778  38.852  1.00 11.48      A    C  
ATOM   2161  C   ALA   294      -5.071  23.488  37.567  1.00 11.10      A    C  
ATOM   2162  O   ALA   294      -6.197  23.799  37.969  1.00 12.44      A    O  
ATOM   2163  N   ALA   295      -4.189  24.367  37.093  1.00 10.94      A    N  
ATOM   2164  CA  ALA   295      -4.506  25.802  37.020  1.00 10.51      A    C  
ATOM   2165  CB  ALA   295      -3.292  26.570  36.554  1.00 10.31      A    C  
ATOM   2166  C   ALA   295      -5.687  26.045  36.078  1.00 10.79      A    C  
ATOM   2167  O   ALA   295      -6.684  26.696  36.446  1.00 10.82      A    O  
ATOM   2168  N   VAL   296      -5.594  25.507  34.864  1.00 10.01      A    N  
ATOM   2169  CA  VAL   296      -6.707  25.622  33.914  1.00  9.87      A    C  
ATOM   2170  CB  VAL   296      -6.340  25.059  32.527  1.00  9.10      A    C  
ATOM   2171  CG1 VAL   296      -7.574  25.046  31.617  1.00  9.19      A    C  
ATOM   2172  CG2 VAL   296      -5.215  25.853  31.908  1.00  9.41      A    C  
ATOM   2173  C   VAL   296      -7.986  24.962  34.400  1.00  9.86      A    C  
ATOM   2174  O   VAL   296      -9.065  25.507  34.250  1.00  9.68      A    O  
ATOM   2175  N   ARG   297      -7.878  23.776  35.000  1.00 10.21      A    N  
ATOM   2176  CA  ARG   297      -9.074  23.057  35.450  1.00 11.00      A    C  
ATOM   2177  CB  ARG   297      -8.706  21.631  35.865  1.00 10.72      A    C  
ATOM   2178  CG  ARG   297      -8.517  20.756  34.627  1.00  9.80      A    C  
ATOM   2179  CD  ARG   297      -7.831  19.429  34.941  1.00  9.74      A    C  
ATOM   2180  NE  ARG   297      -7.725  18.609  33.735  1.00 11.40      A    N  
ATOM   2181  CZ  ARG   297      -6.859  17.608  33.583  1.00 11.89      A    C  
ATOM   2182  NH1 ARG   297      -6.002  17.315  34.561  1.00 11.87      A    N  
ATOM   2183  NH2 ARG   297      -6.852  16.905  32.448  1.00 12.00      A    N  
ATOM   2184  C   ARG   297      -9.886  23.767  36.537  1.00 11.44      A    C  
ATOM   2185  O   ARG   297     -11.049  23.446  36.770  1.00 12.42      A    O  
ATOM   2186  N   SER   298      -9.278  24.756  37.179  1.00 12.40      A    N  
ATOM   2187  CA  SER   298     -10.018  25.583  38.114  1.00 13.04      A    C  
ATOM   2188  CB  SER   298      -9.102  26.591  38.787  1.00 13.52      A    C  
ATOM   2189  OG  SER   298      -8.259  25.925  39.715  1.00 16.65      A    O  
ATOM   2190  C   SER   298     -11.214  26.290  37.472  1.00 12.51      A    C  
ATOM   2191  O   SER   298     -12.263  26.428  38.120  1.00 13.57      A    O  
ATOM   2192  N   TYR   299     -11.059  26.734  36.222  1.00 10.89      A    N  
ATOM   2193  CA  TYR   299     -12.162  27.386  35.502  1.00 10.28      A    C  
ATOM   2194  CB  TYR   299     -11.774  28.812  35.075  1.00  9.50      A    C  
ATOM   2195  CG  TYR   299     -10.564  28.908  34.167  1.00  9.27      A    C  
ATOM   2196  CD1 TYR   299     -10.662  28.631  32.804  1.00  8.31      A    C  
ATOM   2197  CE1 TYR   299      -9.543  28.723  31.962  1.00  7.83      A    C  
ATOM   2198  CZ  TYR   299      -8.324  29.135  32.495  1.00  9.02      A    C  
ATOM   2199  OH  TYR   299      -7.223  29.242  31.688  1.00 10.26      A    O  
ATOM   2200  CE2 TYR   299      -8.210  29.418  33.844  1.00  8.89      A    C  
ATOM   2201  CD2 TYR   299      -9.322  29.302  34.670  1.00  8.08      A    C  
ATOM   2202  C   TYR   299     -12.696  26.591  34.297  1.00 10.61      A    C  
ATOM   2203  O   TYR   299     -13.793  26.865  33.793  1.00 11.06      A    O  
ATOM   2204  N   TRP   300     -11.914  25.624  33.828  1.00 10.62      A    N  
ATOM   2205  CA  TRP   300     -12.352  24.744  32.739  1.00 11.34      A    C  
ATOM   2206  CB  TRP   300     -11.674  25.096  31.415  1.00 11.18      A    C  
ATOM   2207  CG  TRP   300     -12.158  24.197  30.274  1.00 11.38      A    C  
ATOM   2208  CD1 TRP   300     -13.417  23.712  30.106  1.00 11.92      A    C  
ATOM   2209  NE1 TRP   300     -13.485  22.936  28.964  1.00 13.28      A    N  
ATOM   2210  CE2 TRP   300     -12.242  22.897  28.387  1.00 12.66      A    C  
ATOM   2211  CD2 TRP   300     -11.376  23.671  29.189  1.00 11.25      A    C  
ATOM   2212  CE3 TRP   300     -10.036  23.800  28.807  1.00 11.05      A    C  
ATOM   2213  CZ3 TRP   300      -9.602  23.139  27.663  1.00 12.96      A    C  
ATOM   2214  CH2 TRP   300     -10.484  22.368  26.900  1.00 11.99      A    C  
ATOM   2215  CZ2 TRP   300     -11.803  22.232  27.243  1.00 13.03      A    C  
ATOM   2216  C   TRP   300     -12.051  23.295  33.111  1.00 11.84      A    C  
ATOM   2217  O   TRP   300     -11.083  22.702  32.627  1.00 11.54      A    O  
ATOM   2218  N   PRO   301     -12.873  22.733  33.992  1.00 12.67      A    N  
ATOM   2219  CA  PRO   301     -12.551  21.392  34.504  1.00 13.02      A    C  
ATOM   2220  CB  PRO   301     -13.652  21.113  35.531  1.00 13.41      A    C  
ATOM   2221  CG  PRO   301     -14.550  22.298  35.535  1.00 14.04      A    C  
ATOM   2222  CD  PRO   301     -13.949  23.403  34.745  1.00 12.33      A    C  
ATOM   2223  C   PRO   301     -12.527  20.306  33.418  1.00 13.72      A    C  
ATOM   2224  O   PRO   301     -11.853  19.276  33.604  1.00 14.48      A    O  
ATOM   2225  N   ALA   302     -13.201  20.548  32.290  1.00 13.88      A    N  
ATOM   2226  CA  ALA   302     -13.247  19.568  31.188  1.00 13.62      A    C  
ATOM   2227  CB  ALA   302     -14.469  19.799  30.299  1.00 14.40      A    C  
ATOM   2228  C   ALA   302     -11.973  19.471  30.327  1.00 13.21      A    C  
ATOM   2229  O   ALA   302     -11.924  18.685  29.372  1.00 12.71      A    O  
ATOM   2230  N   LEU   303     -10.953  20.269  30.636  1.00 12.15      A    N  
ATOM   2231  CA  LEU   303      -9.669  20.124  29.963  1.00 11.78      A    C  
ATOM   2232  CB  LEU   303      -8.616  21.028  30.628  1.00 12.03      A    C  
ATOM   2233  CG  LEU   303      -7.164  20.732  30.254  1.00 10.30      A    C  
ATOM   2234  CD1 LEU   303      -6.941  21.017  28.784  1.00 10.85      A    C  
ATOM   2235  CD2 LEU   303      -6.222  21.572  31.101  1.00 12.46      A    C  
ATOM   2236  C   LEU   303      -9.219  18.658  29.996  1.00 12.31      A    C  
ATOM   2237  O   LEU   303      -9.025  18.088  31.064  1.00 11.62      A    O  
ATOM   2238  N   PRO   304      -9.072  18.028  28.824  1.00 12.54      A    N  
ATOM   2239  CA  PRO   304      -8.681  16.600  28.863  1.00 12.74      A    C  
ATOM   2240  CB  PRO   304      -8.928  16.141  27.426  1.00 12.86      A    C  
ATOM   2241  CG  PRO   304      -9.958  17.104  26.883  1.00 12.88      A    C  
ATOM   2242  CD  PRO   304      -9.506  18.431  27.479  1.00 13.01      A    C  
ATOM   2243  C   PRO   304      -7.220  16.355  29.202  1.00 12.69      A    C  
ATOM   2244  O   PRO   304      -6.372  17.183  28.892  1.00 12.47      A    O  
ATOM   2245  N   ASP   305      -6.912  15.192  29.782  1.00 12.85      A    N  
ATOM   2246  CA  ASP   305      -5.510  14.814  29.972  1.00 13.93      A    C  
ATOM   2247  CB  ASP   305      -5.380  13.382  30.520  1.00 14.21      A    C  
ATOM   2248  CG  ASP   305      -5.872  13.231  31.946  1.00 17.28      A    C  
ATOM   2249  OD1 ASP   305      -6.049  14.241  32.660  1.00 18.05      A    O  
ATOM   2250  OD2 ASP   305      -6.076  12.062  32.361  1.00 18.72      A    O  
ATOM   2251  C   ASP   305      -4.754  14.865  28.637  1.00 13.61      A    C  
ATOM   2252  O   ASP   305      -5.281  14.452  27.591  1.00 13.18      A    O  
ATOM   2253  N   GLY   306      -3.521  15.358  28.694  1.00 14.09      A    N  
ATOM   2254  CA  GLY   306      -2.581  15.336  27.573  1.00 15.47      A    C  
ATOM   2255  C   GLY   306      -2.878  16.305  26.452  1.00 15.97      A    C  
ATOM   2256  O   GLY   306      -2.157  16.342  25.442  1.00 16.58      A    O  
ATOM   2257  N   ALA   307      -3.924  17.114  26.627  1.00 15.64      A    N  
ATOM   2258  CA  ALA   307      -4.410  17.981  25.550  1.00 15.84      A    C  
ATOM   2259  CB  ALA   307      -5.864  18.338  25.764  1.00 15.75      A    C  
ATOM   2260  C   ALA   307      -3.595  19.248  25.320  1.00 15.38      A    C  
ATOM   2261  O   ALA   307      -3.788  19.926  24.314  1.00 16.04      A    O  
ATOM   2262  N   LEU   308      -2.702  19.580  26.238  1.00 15.35      A    N  
ATOM   2263  CA  LEU   308      -1.890  20.798  26.078  1.00 15.06      A    C  
ATOM   2264  CB  LEU   308      -1.536  21.397  27.435  1.00 15.18      A    C  
ATOM   2265  CG  LEU   308      -2.718  21.870  28.281  1.00 14.77      A    C  
ATOM   2266  CD1 LEU   308      -2.198  22.497  29.562  1.00 14.10      A    C  
ATOM   2267  CD2 LEU   308      -3.618  22.855  27.503  1.00 14.87      A    C  
ATOM   2268  C   LEU   308      -0.638  20.554  25.233  1.00 15.79      A    C  
ATOM   2269  O   LEU   308       0.415  20.143  25.748  1.00 16.90      A    O  
ATOM   2270  N   ALA   309      -0.765  20.814  23.933  1.00 15.13      A    N  
ATOM   2271  CA  ALA   309       0.294  20.542  22.959  1.00 15.57      A    C  
ATOM   2272  CB  ALA   309      -0.291  20.418  21.570  1.00 15.95      A    C  
ATOM   2273  C   ALA   309       1.339  21.638  22.982  1.00 15.67      A    C  
ATOM   2274  O   ALA   309       1.038  22.791  23.307  1.00 15.40      A    O  
ATOM   2275  N   PRO   310       2.583  21.291  22.620  1.00 15.20      A    N  
ATOM   2276  CA  PRO   310       3.639  22.296  22.612  1.00 15.54      A    C  
ATOM   2277  CB  PRO   310       4.845  21.522  22.066  1.00 16.09      A    C  
ATOM   2278  CG  PRO   310       4.594  20.132  22.520  1.00 15.08      A    C  
ATOM   2279  CD  PRO   310       3.105  19.946  22.318  1.00 15.93      A    C  
ATOM   2280  C   PRO   310       3.283  23.481  21.715  1.00 15.55      A    C  
ATOM   2281  O   PRO   310       2.832  23.304  20.573  1.00 16.49      A    O  
ATOM   2282  N   GLY   311       3.466  24.683  22.245  1.00 14.91      A    N  
ATOM   2283  CA  GLY   311       3.155  25.880  21.499  1.00 13.85      A    C  
ATOM   2284  C   GLY   311       4.416  26.604  21.094  1.00 13.91      A    C  
ATOM   2285  O   GLY   311       5.090  26.215  20.126  1.00 13.87      A    O  
ATOM   2286  N   TYR   312       4.751  27.644  21.848  1.00 12.49      A    N  
ATOM   2287  CA  TYR   312       5.884  28.490  21.525  1.00 12.61      A    C  
ATOM   2288  CB  TYR   312       5.543  29.393  20.332  1.00 12.89      A    C  
ATOM   2289  CG  TYR   312       4.403  30.366  20.585  1.00 12.92      A    C  
ATOM   2290  CD1 TYR   312       4.656  31.712  20.897  1.00 14.66      A    C  
ATOM   2291  CE1 TYR   312       3.604  32.609  21.121  1.00 12.57      A    C  
ATOM   2292  CZ  TYR   312       2.301  32.162  21.036  1.00 15.48      A    C  
ATOM   2293  OH  TYR   312       1.251  33.029  21.263  1.00 14.99      A    O  
ATOM   2294  CE2 TYR   312       2.029  30.838  20.730  1.00 14.43      A    C  
ATOM   2295  CD2 TYR   312       3.085  29.949  20.505  1.00 14.65      A    C  
ATOM   2296  C   TYR   312       6.198  29.334  22.752  1.00 12.62      A    C  
ATOM   2297  O   TYR   312       5.443  29.319  23.726  1.00 12.46      A    O  
ATOM   2298  N   THR   313       7.307  30.060  22.692  1.00 12.54      A    N  
ATOM   2299  CA  THR   313       7.735  30.902  23.798  1.00 11.75      A    C  
ATOM   2300  CB  THR   313       9.086  30.437  24.360  1.00 12.16      A    C  
ATOM   2301  OG1 THR   313      10.093  30.686  23.378  1.00 13.42      A    O  
ATOM   2302  CG2 THR   313       9.062  28.946  24.713  1.00 12.33      A    C  
ATOM   2303  C   THR   313       7.926  32.344  23.362  1.00 11.63      A    C  
ATOM   2304  O   THR   313       8.047  32.664  22.165  1.00 12.08      A    O  
ATOM   2305  N   GLY   314       7.943  33.223  24.350  1.00 11.01      A    N  
ATOM   2306  CA  GLY   314       8.393  34.583  24.177  1.00 10.25      A    C  
ATOM   2307  C   GLY   314       9.214  34.979  25.387  1.00  9.80      A    C  
ATOM   2308  O   GLY   314       9.208  34.285  26.403  1.00  9.57      A    O  
ATOM   2309  N   ILE   315       9.910  36.110  25.289  1.00  9.50      A    N  
ATOM   2310  CA  ILE   315      10.694  36.606  26.413  1.00  8.89      A    C  
ATOM   2311  CB  ILE   315      12.210  36.391  26.192  1.00  9.19      A    C  
ATOM   2312  CG1 ILE   315      12.471  34.898  26.003  1.00  9.37      A    C  
ATOM   2313  CD1 ILE   315      13.918  34.578  25.628  1.00  8.98      A    C  
ATOM   2314  CG2 ILE   315      13.009  36.900  27.376  1.00  8.33      A    C  
ATOM   2315  C   ILE   315      10.362  38.082  26.642  1.00  9.46      A    C  
ATOM   2316  O   ILE   315      10.390  38.883  25.711  1.00 10.01      A    O  
ATOM   2317  N   ARG   316       9.992  38.406  27.875  1.00  8.59      A    N  
ATOM   2318  CA  ARG   316       9.627  39.775  28.254  1.00  8.99      A    C  
ATOM   2319  CB  ARG   316       8.751  39.735  29.500  1.00  8.88      A    C  
ATOM   2320  CG  ARG   316       7.509  38.861  29.385  1.00  8.68      A    C  
ATOM   2321  CD  ARG   316       6.861  38.746  30.754  1.00  9.10      A    C  
ATOM   2322  NE  ARG   316       5.680  37.885  30.804  1.00  8.89      A    N  
ATOM   2323  CZ  ARG   316       5.706  36.555  30.910  1.00  9.60      A    C  
ATOM   2324  NH1 ARG   316       6.872  35.903  30.925  1.00  8.63      A    N  
ATOM   2325  NH2 ARG   316       4.561  35.876  31.000  1.00  9.36      A    N  
ATOM   2326  C   ARG   316      10.877  40.593  28.594  1.00  9.46      A    C  
ATOM   2327  O   ARG   316      11.767  40.105  29.306  1.00  9.72      A    O  
ATOM   2328  N   PRO   317      10.934  41.846  28.120  1.00  9.31      A    N  
ATOM   2329  CA  PRO   317      12.016  42.739  28.504  1.00  9.89      A    C  
ATOM   2330  CB  PRO   317      11.975  43.827  27.427  1.00  9.59      A    C  
ATOM   2331  CG  PRO   317      10.495  43.886  26.999  1.00  8.43      A    C  
ATOM   2332  CD  PRO   317       9.954  42.483  27.213  1.00  9.11      A    C  
ATOM   2333  C   PRO   317      11.744  43.320  29.878  1.00 11.45      A    C  
ATOM   2334  O   PRO   317      10.881  44.201  30.043  1.00 13.08      A    O  
ATOM   2335  N   LYS   318      12.463  42.824  30.871  1.00 11.27      A    N  
ATOM   2336  CA  LYS   318      12.249  43.260  32.233  1.00 12.41      A    C  
ATOM   2337  CB  LYS   318      12.263  42.066  33.191  1.00 12.01      A    C  
ATOM   2338  CG  LYS   318      11.083  41.103  33.038  1.00 13.09      A    C  
ATOM   2339  CD  LYS   318       9.795  41.777  33.503  1.00 13.40      A    C  
ATOM   2340  CE  LYS   318       8.691  40.776  33.707  1.00 17.34      A    C  
ATOM   2341  NZ  LYS   318       7.410  41.441  34.119  1.00 16.28      A    N  
ATOM   2342  C   LYS   318      13.319  44.268  32.614  1.00 12.36      A    C  
ATOM   2343  O   LYS   318      14.477  44.162  32.192  1.00 13.03      A    O  
ATOM   2344  N   ILE   319      12.920  45.273  33.384  1.00 12.75      A    N  
ATOM   2345  CA  ILE   319      13.884  46.257  33.881  1.00 13.42      A    C  
ATOM   2346  CB  ILE   319      13.723  47.645  33.185  1.00 12.92      A    C  
ATOM   2347  CG1 ILE   319      12.313  48.210  33.413  1.00 12.47      A    C  
ATOM   2348  CD1 ILE   319      12.049  49.541  32.682  1.00 14.80      A    C  
ATOM   2349  CG2 ILE   319      14.100  47.515  31.707  1.00 11.76      A    C  
ATOM   2350  C   ILE   319      13.804  46.382  35.397  1.00 14.59      A    C  
ATOM   2351  O   ILE   319      14.383  47.310  35.989  1.00 15.37      A    O  
ATOM   2352  N   SER   320      13.069  45.449  36.003  1.00 15.21      A    N  
ATOM   2353  CA  SER   320      13.081  45.230  37.452  1.00 16.19      A    C  
ATOM   2354  CB  SER   320      11.847  45.846  38.087  1.00 16.25      A    C  
ATOM   2355  OG  SER   320      10.670  45.381  37.458  1.00 18.25      A    O  
ATOM   2356  C   SER   320      13.129  43.712  37.712  1.00 16.19      A    C  
ATOM   2357  O   SER   320      12.763  42.920  36.849  1.00 15.55      A    O  
ATOM   2358  N   GLY   321      13.602  43.316  38.890  1.00 16.52      A    N  
ATOM   2359  CA  GLY   321      13.882  41.896  39.162  1.00 16.25      A    C  
ATOM   2360  C   GLY   321      12.718  41.085  39.696  1.00 17.17      A    C  
ATOM   2361  O   GLY   321      11.627  41.608  39.944  1.00 16.94      A    O  
ATOM   2362  N   PRO   322      12.945  39.789  39.908  1.00 17.42      A    N  
ATOM   2363  CA  PRO   322      11.844  38.905  40.261  1.00 18.52      A    C  
ATOM   2364  CB  PRO   322      12.500  37.519  40.303  1.00 18.42      A    C  
ATOM   2365  CG  PRO   322      13.974  37.795  40.469  1.00 17.83      A    C  
ATOM   2366  CD  PRO   322      14.204  39.052  39.695  1.00 17.21      A    C  
ATOM   2367  C   PRO   322      11.161  39.229  41.593  1.00 19.93      A    C  
ATOM   2368  O   PRO   322      10.013  38.843  41.782  1.00 20.35      A    O  
ATOM   2369  N   HIS   323      11.829  39.942  42.494  1.00 20.90      A    N  
ATOM   2370  CA  HIS   323      11.185  40.255  43.772  1.00 22.55      A    C  
ATOM   2371  CB  HIS   323      12.080  39.837  44.937  1.00 22.90      A    C  
ATOM   2372  CG  HIS   323      12.218  38.359  45.062  1.00 24.46      A    C  
ATOM   2373  ND1 HIS   323      11.126  37.521  45.140  1.00 26.17      A    N  
ATOM   2374  CE1 HIS   323      11.543  36.271  45.231  1.00 27.59      A    C  
ATOM   2375  NE2 HIS   323      12.865  36.271  45.223  1.00 26.79      A    N  
ATOM   2376  CD2 HIS   323      13.311  37.563  45.110  1.00 24.98      A    C  
ATOM   2377  C   HIS   323      10.749  41.697  43.916  1.00 23.21      A    C  
ATOM   2378  O   HIS   323      10.418  42.147  45.020  1.00 23.62      A    O  
ATOM   2379  N   GLU   324      10.749  42.424  42.806  1.00 23.33      A    N  
ATOM   2380  CA  GLU   324      10.331  43.819  42.824  1.00 24.07      A    C  
ATOM   2381  CB  GLU   324      11.335  44.697  42.077  1.00 24.29      A    C  
ATOM   2382  CG  GLU   324      12.749  44.691  42.607  1.00 25.23      A    C  
ATOM   2383  CD  GLU   324      13.650  45.578  41.777  1.00 27.39      A    C  
ATOM   2384  OE1 GLU   324      14.561  45.049  41.103  1.00 27.69      A    O  
ATOM   2385  OE2 GLU   324      13.426  46.808  41.776  1.00 29.72      A    O  
ATOM   2386  C   GLU   324       8.980  43.948  42.152  1.00 24.06      A    C  
ATOM   2387  O   GLU   324       8.636  43.158  41.274  1.00 24.04      A    O  
ATOM   2388  N   PRO   325       8.210  44.973  42.541  1.00 24.33      A    N  
ATOM   2389  CA  PRO   325       6.961  45.220  41.834  1.00 24.05      A    C  
ATOM   2390  CB  PRO   325       6.363  46.420  42.576  1.00 23.88      A    C  
ATOM   2391  CG  PRO   325       7.544  47.123  43.205  1.00 24.83      A    C  
ATOM   2392  CD  PRO   325       8.617  46.083  43.422  1.00 24.45      A    C  
ATOM   2393  C   PRO   325       7.278  45.555  40.375  1.00 23.37      A    C  
ATOM   2394  O   PRO   325       8.368  46.047  40.082  1.00 23.94      A    O  
ATOM   2395  N   ALA   326       6.351  45.273  39.470  1.00 22.84      A    N  
ATOM   2396  CA  ALA   326       6.627  45.446  38.055  1.00 21.74      A    C  
ATOM   2397  CB  ALA   326       5.493  44.889  37.217  1.00 22.03      A    C  
ATOM   2398  C   ALA   326       6.882  46.916  37.723  1.00 21.03      A    C  
ATOM   2399  O   ALA   326       6.162  47.801  38.194  1.00 21.31      A    O  
ATOM   2400  N   ALA   327       7.918  47.163  36.928  1.00 19.59      A    N  
ATOM   2401  CA  ALA   327       8.256  48.506  36.477  1.00 17.91      A    C  
ATOM   2402  CB  ALA   327       9.683  48.549  35.945  1.00 18.12      A    C  
ATOM   2403  C   ALA   327       7.284  48.951  35.395  1.00 16.70      A    C  
ATOM   2404  O   ALA   327       6.733  48.127  34.673  1.00 16.86      A    O  
ATOM   2405  N   ASP   328       7.086  50.261  35.279  1.00 14.08      A    N  
ATOM   2406  CA  ASP   328       6.267  50.816  34.199  1.00 12.69      A    C  
ATOM   2407  CB  ASP   328       5.993  52.285  34.514  1.00 12.36      A    C  
ATOM   2408  CG  ASP   328       4.814  52.868  33.745  1.00 11.56      A    C  
ATOM   2409  OD1 ASP   328       4.097  52.156  33.009  1.00  9.11      A    O  
ATOM   2410  OD2 ASP   328       4.601  54.092  33.904  1.00 12.11      A    O  
ATOM   2411  C   ASP   328       7.076  50.712  32.908  1.00 11.31      A    C  
ATOM   2412  O   ASP   328       8.271  50.381  32.944  1.00 11.06      A    O  
ATOM   2413  N   PHE   329       6.435  50.966  31.769  1.00  9.85      A    N  
ATOM   2414  CA  PHE   329       7.165  51.233  30.527  1.00  9.04      A    C  
ATOM   2415  CB  PHE   329       6.235  51.797  29.445  1.00  8.38      A    C  
ATOM   2416  CG  PHE   329       5.243  50.814  28.869  1.00  7.77      A    C  
ATOM   2417  CD1 PHE   329       5.485  49.457  28.838  1.00  6.76      A    C  
ATOM   2418  CE1 PHE   329       4.554  48.588  28.282  1.00  8.22      A    C  
ATOM   2419  CZ  PHE   329       3.376  49.084  27.736  1.00  8.19      A    C  
ATOM   2420  CE2 PHE   329       3.129  50.427  27.770  1.00  8.16      A    C  
ATOM   2421  CD2 PHE   329       4.060  51.289  28.330  1.00  6.55      A    C  
ATOM   2422  C   PHE   329       8.139  52.371  30.813  1.00  9.21      A    C  
ATOM   2423  O   PHE   329       7.837  53.265  31.617  1.00  9.11      A    O  
ATOM   2424  N   ALA   330       9.288  52.361  30.140  1.00  9.36      A    N  
ATOM   2425  CA  ALA   330      10.223  53.476  30.229  1.00  9.70      A    C  
ATOM   2426  CB  ALA   330      11.544  53.016  30.846  1.00 10.09      A    C  
ATOM   2427  C   ALA   330      10.446  54.064  28.848  1.00  9.72      A    C  
ATOM   2428  O   ALA   330      10.839  53.360  27.921  1.00 10.20      A    O  
ATOM   2429  N   ILE   331      10.128  55.345  28.688  1.00  9.12      A    N  
ATOM   2430  CA  ILE   331      10.407  56.050  27.438  1.00 10.05      A    C  
ATOM   2431  CB  ILE   331       9.101  56.490  26.710  1.00  9.64      A    C  
ATOM   2432  CG1 ILE   331       8.202  55.268  26.558  1.00  9.54      A    C  
ATOM   2433  CD1 ILE   331       6.788  55.563  26.050  1.00 11.62      A    C  
ATOM   2434  CG2 ILE   331       9.426  57.131  25.363  1.00 10.71      A    C  
ATOM   2435  C   ILE   331      11.314  57.227  27.765  1.00 10.54      A    C  
ATOM   2436  O   ILE   331      10.850  58.291  28.174  1.00 11.51      A    O  
ATOM   2437  N   ALA   332      12.623  57.009  27.657  1.00 10.84      A    N  
ATOM   2438  CA  ALA   332      13.598  57.980  28.152  1.00 11.17      A    C  
ATOM   2439  CB  ALA   332      14.781  57.246  28.838  1.00 10.60      A    C  
ATOM   2440  C   ALA   332      14.107  58.910  27.061  1.00 11.87      A    C  
ATOM   2441  O   ALA   332      14.918  58.521  26.203  1.00 11.49      A    O  
ATOM   2442  N   GLY   333      13.631  60.155  27.101  1.00 13.02      A    N  
ATOM   2443  CA  GLY   333      14.023  61.183  26.144  1.00 14.29      A    C  
ATOM   2444  C   GLY   333      15.041  62.142  26.761  1.00 15.51      A    C  
ATOM   2445  O   GLY   333      15.561  61.891  27.845  1.00 15.60      A    O  
ATOM   2446  N   PRO   334      15.343  63.241  26.061  1.00 16.59      A    N  
ATOM   2447  CA  PRO   334      16.346  64.208  26.526  1.00 17.80      A    C  
ATOM   2448  CB  PRO   334      16.278  65.305  25.463  1.00 17.73      A    C  
ATOM   2449  CG  PRO   334      15.925  64.575  24.229  1.00 17.84      A    C  
ATOM   2450  CD  PRO   334      14.950  63.494  24.668  1.00 16.65      A    C  
ATOM   2451  C   PRO   334      16.105  64.778  27.933  1.00 18.66      A    C  
ATOM   2452  O   PRO   334      17.066  65.110  28.642  1.00 18.90      A    O  
ATOM   2453  N   ALA   335      14.846  64.858  28.356  1.00 19.40      A    N  
ATOM   2454  CA  ALA   335      14.533  65.424  29.665  1.00 20.51      A    C  
ATOM   2455  CB  ALA   335      13.043  65.693  29.788  1.00 20.69      A    C  
ATOM   2456  C   ALA   335      15.004  64.562  30.824  1.00 20.87      A    C  
ATOM   2457  O   ALA   335      15.080  65.028  31.956  1.00 21.60      A    O  
ATOM   2458  N   SER   336      15.310  63.295  30.562  1.00 21.26      A    N  
ATOM   2459  CA  SER   336      15.780  62.454  31.650  1.00 21.23      A    C  
ATOM   2460  CB  SER   336      14.891  61.229  31.844  1.00 22.07      A    C  
ATOM   2461  OG  SER   336      15.031  60.332  30.775  1.00 22.98      A    O  
ATOM   2462  C   SER   336      17.250  62.070  31.532  1.00 20.80      A    C  
ATOM   2463  O   SER   336      17.946  62.003  32.538  1.00 21.80      A    O  
ATOM   2464  N   HIS   337      17.733  61.838  30.318  1.00 19.40      A    N  
ATOM   2465  CA  HIS   337      19.129  61.435  30.158  1.00 18.27      A    C  
ATOM   2466  CB  HIS   337      19.247  60.170  29.305  1.00 17.22      A    C  
ATOM   2467  CG  HIS   337      18.637  60.284  27.943  1.00 16.05      A    C  
ATOM   2468  ND1 HIS   337      18.946  61.299  27.062  1.00 12.91      A    N  
ATOM   2469  CE1 HIS   337      18.270  61.122  25.939  1.00 14.15      A    C  
ATOM   2470  NE2 HIS   337      17.539  60.027  26.059  1.00 11.99      A    N  
ATOM   2471  CD2 HIS   337      17.742  59.489  27.304  1.00 13.08      A    C  
ATOM   2472  C   HIS   337      20.038  62.544  29.623  1.00 17.98      A    C  
ATOM   2473  O   HIS   337      21.265  62.390  29.586  1.00 18.39      A    O  
ATOM   2474  N   GLY   338      19.438  63.655  29.205  1.00 17.54      A    N  
ATOM   2475  CA  GLY   338      20.212  64.820  28.790  1.00 17.18      A    C  
ATOM   2476  C   GLY   338      20.767  64.798  27.381  1.00 17.65      A    C  
ATOM   2477  O   GLY   338      21.467  65.726  26.968  1.00 17.52      A    O  
ATOM   2478  N   VAL   339      20.475  63.743  26.624  1.00 16.83      A    N  
ATOM   2479  CA  VAL   339      21.014  63.639  25.279  1.00 16.57      A    C  
ATOM   2480  CB  VAL   339      21.485  62.209  24.959  1.00 15.97      A    C  
ATOM   2481  CG1 VAL   339      22.114  62.166  23.571  1.00 16.43      A    C  
ATOM   2482  CG2 VAL   339      22.463  61.726  26.015  1.00 16.35      A    C  
ATOM   2483  C   VAL   339      20.024  64.098  24.207  1.00 16.67      A    C  
ATOM   2484  O   VAL   339      19.030  63.424  23.915  1.00 16.40      A    O  
ATOM   2485  N   ALA   340      20.305  65.248  23.600  1.00 16.95      A    N  
ATOM   2486  CA  ALA   340      19.451  65.739  22.533  1.00 16.86      A    C  
ATOM   2487  CB  ALA   340      19.970  67.078  22.003  1.00 17.42      A    C  
ATOM   2488  C   ALA   340      19.325  64.715  21.393  1.00 15.91      A    C  
ATOM   2489  O   ALA   340      20.316  64.135  20.941  1.00 16.33      A    O  
ATOM   2490  N   GLY   341      18.104  64.496  20.927  1.00 14.96      A    N  
ATOM   2491  CA  GLY   341      17.891  63.665  19.740  1.00 13.79      A    C  
ATOM   2492  C   GLY   341      17.781  62.163  19.993  1.00 12.87      A    C  
ATOM   2493  O   GLY   341      17.668  61.381  19.052  1.00 12.89      A    O  
ATOM   2494  N   LEU   342      17.785  61.773  21.258  1.00 12.27      A    N  
ATOM   2495  CA  LEU   342      17.794  60.352  21.629  1.00 11.43      A    C  
ATOM   2496  CB  LEU   342      19.079  60.047  22.405  1.00 11.60      A    C  
ATOM   2497  CG  LEU   342      19.194  58.643  23.006  1.00 10.88      A    C  
ATOM   2498  CD1 LEU   342      19.352  57.606  21.904  1.00 10.65      A    C  
ATOM   2499  CD2 LEU   342      20.336  58.587  24.016  1.00 12.16      A    C  
ATOM   2500  C   LEU   342      16.579  59.938  22.470  1.00 10.74      A    C  
ATOM   2501  O   LEU   342      16.264  60.570  23.478  1.00 10.56      A    O  
ATOM   2502  N   VAL   343      15.904  58.858  22.071  1.00  9.89      A    N  
ATOM   2503  CA  VAL   343      14.918  58.247  22.940  1.00  9.41      A    C  
ATOM   2504  CB  VAL   343      13.479  58.361  22.398  1.00  9.37      A    C  
ATOM   2505  CG1 VAL   343      12.513  57.679  23.376  1.00  9.75      A    C  
ATOM   2506  CG2 VAL   343      13.097  59.851  22.249  1.00 10.33      A    C  
ATOM   2507  C   VAL   343      15.283  56.773  23.089  1.00  9.14      A    C  
ATOM   2508  O   VAL   343      15.464  56.072  22.095  1.00  8.81      A    O  
ATOM   2509  N   ASN   344      15.429  56.336  24.326  1.00  9.10      A    N  
ATOM   2510  CA  ASN   344      15.610  54.911  24.618  1.00  9.14      A    C  
ATOM   2511  CB  ASN   344      16.651  54.718  25.727  1.00  9.42      A    C  
ATOM   2512  CG  ASN   344      18.044  55.142  25.315  1.00  9.13      A    C  
ATOM   2513  OD1 ASN   344      18.576  54.657  24.325  1.00  9.81      A    O  
ATOM   2514  ND2 ASN   344      18.647  56.061  26.079  1.00 10.83      A    N  
ATOM   2515  C   ASN   344      14.281  54.391  25.125  1.00  9.30      A    C  
ATOM   2516  O   ASN   344      13.667  55.005  26.011  1.00  9.51      A    O  
ATOM   2517  N   LEU   345      13.826  53.261  24.601  1.00  9.17      A    N  
ATOM   2518  CA  LEU   345      12.637  52.643  25.164  1.00  8.30      A    C  
ATOM   2519  CB  LEU   345      11.612  52.314  24.088  1.00  8.45      A    C  
ATOM   2520  CG  LEU   345      10.956  53.550  23.454  1.00  7.71      A    C  
ATOM   2521  CD1 LEU   345      11.731  54.027  22.238  1.00  7.74      A    C  
ATOM   2522  CD2 LEU   345       9.519  53.222  23.079  1.00 10.22      A    C  
ATOM   2523  C   LEU   345      13.041  51.379  25.906  1.00  8.26      A    C  
ATOM   2524  O   LEU   345      13.699  50.507  25.325  1.00  8.86      A    O  
ATOM   2525  N   TYR   346      12.675  51.290  27.178  1.00  7.95      A    N  
ATOM   2526  CA  TYR   346      13.024  50.130  27.996  1.00  7.85      A    C  
ATOM   2527  CB  TYR   346      13.941  50.515  29.159  1.00  8.77      A    C  
ATOM   2528  CG  TYR   346      15.152  51.358  28.854  1.00  8.37      A    C  
ATOM   2529  CD1 TYR   346      16.120  50.933  27.964  1.00  7.75      A    C  
ATOM   2530  CE1 TYR   346      17.258  51.695  27.710  1.00  8.11      A    C  
ATOM   2531  CZ  TYR   346      17.440  52.888  28.373  1.00  9.48      A    C  
ATOM   2532  OH  TYR   346      18.565  53.655  28.134  1.00 11.19      A    O  
ATOM   2533  CE2 TYR   346      16.490  53.340  29.271  1.00  9.35      A    C  
ATOM   2534  CD2 TYR   346      15.352  52.564  29.512  1.00  8.85      A    C  
ATOM   2535  C   TYR   346      11.794  49.490  28.617  1.00  7.97      A    C  
ATOM   2536  O   TYR   346      10.821  50.171  28.959  1.00  8.23      A    O  
ATOM   2537  N   GLY   347      11.829  48.171  28.779  1.00  7.68      A    N  
ATOM   2538  CA  GLY   347      10.769  47.465  29.501  1.00  7.05      A    C  
ATOM   2539  C   GLY   347       9.404  47.523  28.830  1.00  6.74      A    C  
ATOM   2540  O   GLY   347       8.374  47.561  29.511  1.00  7.05      A    O  
ATOM   2541  N   ILE   348       9.395  47.483  27.504  1.00  6.52      A    N  
ATOM   2542  CA  ILE   348       8.136  47.526  26.752  1.00  6.03      A    C  
ATOM   2543  CB  ILE   348       8.285  48.276  25.391  1.00  6.46      A    C  
ATOM   2544  CG1 ILE   348       8.997  49.627  25.558  1.00  7.27      A    C  
ATOM   2545  CD1 ILE   348       8.354  50.642  26.522  1.00  9.00      A    C  
ATOM   2546  CG2 ILE   348       6.892  48.424  24.700  1.00  5.84      A    C  
ATOM   2547  C   ILE   348       7.610  46.099  26.584  1.00  5.80      A    C  
ATOM   2548  O   ILE   348       7.639  45.509  25.484  1.00  6.23      A    O  
ATOM   2549  N   GLU   349       7.145  45.554  27.706  1.00  5.60      A    N  
ATOM   2550  CA  GLU   349       6.560  44.224  27.760  1.00  6.88      A    C  
ATOM   2551  CB  GLU   349       6.842  43.567  29.129  1.00  7.34      A    C  
ATOM   2552  CG  GLU   349       6.362  44.402  30.347  1.00  7.51      A    C  
ATOM   2553  CD  GLU   349       6.334  43.614  31.656  1.00 13.20      A    C  
ATOM   2554  OE1 GLU   349       6.539  42.377  31.618  1.00 13.64      A    O  
ATOM   2555  OE2 GLU   349       6.083  44.247  32.718  1.00 11.20      A    O  
ATOM   2556  C   GLU   349       5.065  44.414  27.514  1.00  6.72      A    C  
ATOM   2557  O   GLU   349       4.665  45.454  26.982  1.00  6.59      A    O  
ATOM   2558  N   SER   350       4.238  43.448  27.888  1.00  6.51      A    N  
ATOM   2559  CA  SER   350       2.787  43.679  27.786  1.00  6.93      A    C  
ATOM   2560  CB  SER   350       2.037  42.462  28.298  1.00  7.61      A    C  
ATOM   2561  OG  SER   350       0.649  42.645  28.093  1.00  6.79      A    O  
ATOM   2562  C   SER   350       2.385  44.915  28.609  1.00  6.47      A    C  
ATOM   2563  O   SER   350       2.844  45.095  29.734  1.00  6.32      A    O  
ATOM   2564  N   PRO   351       1.469  45.748  28.091  1.00  6.20      A    N  
ATOM   2565  CA  PRO   351       0.677  45.615  26.860  1.00  6.13      A    C  
ATOM   2566  CB  PRO   351      -0.680  46.177  27.290  1.00  5.56      A    C  
ATOM   2567  CG  PRO   351      -0.291  47.324  28.201  1.00  5.26      A    C  
ATOM   2568  CD  PRO   351       0.923  46.802  28.979  1.00  6.27      A    C  
ATOM   2569  C   PRO   351       1.247  46.469  25.724  1.00  6.66      A    C  
ATOM   2570  O   PRO   351       0.535  47.297  25.141  1.00  6.93      A    O  
ATOM   2571  N   GLY   352       2.528  46.279  25.424  1.00  6.23      A    N  
ATOM   2572  CA  GLY   352       3.221  47.057  24.393  1.00  6.36      A    C  
ATOM   2573  C   GLY   352       2.611  46.989  23.010  1.00  6.31      A    C  
ATOM   2574  O   GLY   352       2.661  47.968  22.254  1.00  7.52      A    O  
ATOM   2575  N   LEU   353       2.054  45.835  22.642  1.00  6.27      A    N  
ATOM   2576  CA  LEU   353       1.455  45.707  21.318  1.00  7.16      A    C  
ATOM   2577  CB  LEU   353       1.095  44.255  21.030  1.00  7.99      A    C  
ATOM   2578  CG  LEU   353       0.158  43.990  19.855  1.00 10.82      A    C  
ATOM   2579  CD1 LEU   353       0.843  44.264  18.547  1.00 16.56      A    C  
ATOM   2580  CD2 LEU   353      -0.289  42.509  19.923  1.00 16.29      A    C  
ATOM   2581  C   LEU   353       0.205  46.589  21.288  1.00  6.93      A    C  
ATOM   2582  O   LEU   353       0.004  47.385  20.364  1.00  6.88      A    O  
ATOM   2583  N   THR   354      -0.602  46.474  22.336  1.00  6.61      A    N  
ATOM   2584  CA  THR   354      -1.850  47.248  22.409  1.00  6.44      A    C  
ATOM   2585  CB  THR   354      -2.632  46.903  23.689  1.00  6.43      A    C  
ATOM   2586  OG1 THR   354      -2.966  45.514  23.667  1.00  6.69      A    O  
ATOM   2587  CG2 THR   354      -3.918  47.731  23.786  1.00  6.28      A    C  
ATOM   2588  C   THR   354      -1.521  48.732  22.408  1.00  6.59      A    C  
ATOM   2589  O   THR   354      -2.214  49.544  21.765  1.00  6.88      A    O  
ATOM   2590  N   ALA   355      -0.462  49.090  23.129  1.00  6.00      A    N  
ATOM   2591  CA  ALA   355      -0.102  50.497  23.329  1.00  6.80      A    C  
ATOM   2592  CB  ALA   355       0.702  50.665  24.630  1.00  7.17      A    C  
ATOM   2593  C   ALA   355       0.702  51.076  22.167  1.00  6.95      A    C  
ATOM   2594  O   ALA   355       1.009  52.271  22.176  1.00  7.73      A    O  
ATOM   2595  N   SER   356       1.078  50.238  21.199  1.00  6.68      A    N  
ATOM   2596  CA  SER   356       2.108  50.626  20.216  1.00  7.20      A    C  
ATOM   2597  CB  SER   356       2.309  49.550  19.137  1.00  7.64      A    C  
ATOM   2598  OG  SER   356       1.102  49.228  18.463  1.00  8.71      A    O  
ATOM   2599  C   SER   356       1.936  52.014  19.569  1.00  7.23      A    C  
ATOM   2600  O   SER   356       2.903  52.768  19.483  1.00  7.57      A    O  
ATOM   2601  N   LEU   357       0.734  52.340  19.085  1.00  7.09      A    N  
ATOM   2602  CA  LEU   357       0.583  53.618  18.388  1.00  7.54      A    C  
ATOM   2603  CB  LEU   357      -0.721  53.673  17.576  1.00  8.40      A    C  
ATOM   2604  CG  LEU   357      -0.855  52.660  16.434  1.00  6.87      A    C  
ATOM   2605  CD1 LEU   357       0.102  52.998  15.300  1.00  8.88      A    C  
ATOM   2606  CD2 LEU   357      -2.316  52.682  15.929  1.00  9.76      A    C  
ATOM   2607  C   LEU   357       0.663  54.774  19.379  1.00  8.05      A    C  
ATOM   2608  O   LEU   357       1.137  55.866  19.034  1.00  8.30      A    O  
ATOM   2609  N   ALA   358       0.199  54.545  20.604  1.00  7.75      A    N  
ATOM   2610  CA  ALA   358       0.332  55.540  21.651  1.00  7.72      A    C  
ATOM   2611  CB  ALA   358      -0.617  55.235  22.814  1.00  8.67      A    C  
ATOM   2612  C   ALA   358       1.774  55.692  22.127  1.00  8.33      A    C  
ATOM   2613  O   ALA   358       2.228  56.795  22.417  1.00  8.54      A    O  
ATOM   2614  N   ILE   359       2.510  54.587  22.163  1.00  6.73      A    N  
ATOM   2615  CA  ILE   359       3.923  54.675  22.489  1.00  6.96      A    C  
ATOM   2616  CB  ILE   359       4.563  53.285  22.609  1.00  6.82      A    C  
ATOM   2617  CG1 ILE   359       4.046  52.571  23.861  1.00  6.31      A    C  
ATOM   2618  CD1 ILE   359       4.282  51.015  23.857  1.00  6.58      A    C  
ATOM   2619  CG2 ILE   359       6.101  53.411  22.632  1.00  6.91      A    C  
ATOM   2620  C   ILE   359       4.661  55.508  21.424  1.00  6.55      A    C  
ATOM   2621  O   ILE   359       5.545  56.303  21.766  1.00  6.92      A    O  
ATOM   2622  N   ALA   360       4.304  55.328  20.155  1.00  7.28      A    N  
ATOM   2623  CA  ALA   360       4.848  56.173  19.077  1.00  8.37      A    C  
ATOM   2624  CB  ALA   360       4.310  55.746  17.727  1.00  9.00      A    C  
ATOM   2625  C   ALA   360       4.545  57.654  19.335  1.00  9.08      A    C  
ATOM   2626  O   ALA   360       5.440  58.502  19.249  1.00  9.65      A    O  
ATOM   2627  N   GLU   361       3.298  57.979  19.666  1.00  9.42      A    N  
ATOM   2628  CA  GLU   361       2.973  59.374  19.992  1.00 10.25      A    C  
ATOM   2629  CB  GLU   361       1.509  59.498  20.414  1.00 10.25      A    C  
ATOM   2630  CG  GLU   361       0.531  59.274  19.276  1.00 11.45      A    C  
ATOM   2631  CD  GLU   361      -0.930  59.463  19.712  1.00 14.44      A    C  
ATOM   2632  OE1 GLU   361      -1.268  59.103  20.852  1.00 15.38      A    O  
ATOM   2633  OE2 GLU   361      -1.737  59.988  18.903  1.00 14.41      A    O  
ATOM   2634  C   GLU   361       3.852  59.908  21.114  1.00 10.18      A    C  
ATOM   2635  O   GLU   361       4.403  61.010  21.021  1.00 10.62      A    O  
ATOM   2636  N   GLU   362       3.984  59.117  22.175  1.00  9.87      A    N  
ATOM   2637  CA  GLU   362       4.710  59.542  23.368  1.00 10.55      A    C  
ATOM   2638  CB  GLU   362       4.427  58.588  24.539  1.00 10.82      A    C  
ATOM   2639  CG  GLU   362       4.983  59.077  25.887  1.00 12.80      A    C  
ATOM   2640  CD  GLU   362       4.281  60.333  26.433  1.00 15.84      A    C  
ATOM   2641  OE1 GLU   362       4.832  60.978  27.346  1.00 18.23      A    O  
ATOM   2642  OE2 GLU   362       3.172  60.661  25.981  1.00 15.97      A    O  
ATOM   2643  C   GLU   362       6.216  59.691  23.116  1.00 10.27      A    C  
ATOM   2644  O   GLU   362       6.875  60.577  23.677  1.00  9.43      A    O  
ATOM   2645  N   THR   363       6.759  58.832  22.261  1.00 10.60      A    N  
ATOM   2646  CA  THR   363       8.173  58.925  21.908  1.00 11.59      A    C  
ATOM   2647  CB  THR   363       8.630  57.753  21.039  1.00 12.17      A    C  
ATOM   2648  OG1 THR   363       7.900  57.757  19.815  1.00 19.07      A    O  
ATOM   2649  CG2 THR   363       8.370  56.466  21.742  1.00  7.00      A    C  
ATOM   2650  C   THR   363       8.461  60.226  21.185  1.00 12.00      A    C  
ATOM   2651  O   THR   363       9.432  60.916  21.505  1.00 12.55      A    O  
ATOM   2652  N   LEU   364       7.611  60.579  20.231  1.00 12.00      A    N  
ATOM   2653  CA  LEU   364       7.800  61.838  19.521  1.00 13.53      A    C  
ATOM   2654  CB  LEU   364       6.855  61.939  18.322  1.00 13.46      A    C  
ATOM   2655  CG  LEU   364       7.391  61.374  17.002  1.00 13.50      A    C  
ATOM   2656  CD1 LEU   364       6.438  61.706  15.872  1.00 14.21      A    C  
ATOM   2657  CD2 LEU   364       7.620  59.850  17.065  1.00 13.39      A    C  
ATOM   2658  C   LEU   364       7.650  63.028  20.473  1.00 14.28      A    C  
ATOM   2659  O   LEU   364       8.400  63.993  20.387  1.00 14.05      A    O  
ATOM   2660  N   ALA   365       6.701  62.940  21.399  1.00 14.54      A    N  
ATOM   2661  CA  ALA   365       6.456  64.017  22.362  1.00 15.78      A    C  
ATOM   2662  CB  ALA   365       5.235  63.692  23.210  1.00 15.20      A    C  
ATOM   2663  C   ALA   365       7.659  64.240  23.260  1.00 16.57      A    C  
ATOM   2664  O   ALA   365       7.978  65.380  23.628  1.00 17.17      A    O  
ATOM   2665  N   ARG   366       8.301  63.148  23.646  1.00 16.44      A    N  
ATOM   2666  CA  ARG   366       9.441  63.150  24.544  1.00 17.63      A    C  
ATOM   2667  CB  ARG   366       9.579  61.799  25.280  1.00 17.68      A    C  
ATOM   2668  CG  ARG   366       8.565  61.657  26.343  1.00 18.23      A    C  
ATOM   2669  CD  ARG   366       8.601  60.446  27.266  1.00 21.06      A    C  
ATOM   2670  NE  ARG   366       7.442  60.466  28.144  1.00 25.26      A    N  
ATOM   2671  CZ  ARG   366       7.358  59.790  29.262  1.00 22.92      A    C  
ATOM   2672  NH1 ARG   366       8.347  59.006  29.599  1.00 28.39      A    N  
ATOM   2673  NH2 ARG   366       6.331  59.852  30.060  1.00 22.15      A    N  
ATOM   2674  C   ARG   366      10.719  63.557  23.788  1.00 18.21      A    C  
ATOM   2675  O   ARG   366      11.569  64.197  24.315  1.00 18.20      A    O  
ATOM   2676  N   LEU   367      10.815  63.138  22.551  1.00 18.40      A    N  
ATOM   2677  CA  LEU   367      11.953  63.482  21.718  1.00 19.46      A    C  
ATOM   2678  CB  LEU   367      11.813  62.827  20.343  1.00 19.34      A    C  
ATOM   2679  CG  LEU   367      12.834  63.151  19.259  1.00 18.92      A    C  
ATOM   2680  CD1 LEU   367      12.482  62.407  17.961  1.00 17.71      A    C  
ATOM   2681  CD2 LEU   367      14.232  62.824  19.732  1.00 19.16      A    C  
ATOM   2682  C   LEU   367      12.005  65.005  21.610  1.00 20.53      A    C  
ATOM   2683  O   LEU   367      13.077  65.601  21.550  1.00 20.59      A    O  
ATOM   2684  N   ALA   368      10.835  65.630  21.629  1.00 21.55      A    N  
ATOM   2685  CA  ALA   368      10.751  67.091  21.637  1.00 22.12      A    C  
ATOM   2686  CB  ALA   368       9.365  67.529  21.211  1.00 22.49      A    C  
ATOM   2687  C   ALA   368      11.095  67.663  23.015  1.00 22.64      A    C  
ATOM   2688  O   ALA   368      11.340  68.879  23.162  1.00 23.74      A    O  
END
