
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 (  781),  selected  106 , name 1ue6_C
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1ue6_C.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_C      -       -           -
LGA    D     4_C      M       1          0.303
LGA    T     5_C      N       2          1.349
LGA    T     6_C      T       3          1.310
LGA    I     7_C      L       4          1.530
LGA    T     8_C      E       5          1.022
LGA    I     9_C      L       6          0.536
LGA    V    10_C      S       7          0.506
LGA    G    11_C      A       8          1.050
LGA    N    12_C      R       9          0.703
LGA    L    13_C      V      10          1.063
LGA    T    14_C      L      11          1.094
LGA    A    15_C      E      12          1.518
LGA    D    16_C      C      13          2.519
LGA    P    17_C      G      14          3.922
LGA    E    18_C      A      15          3.025
LGA    L    19_C      M      16          1.720
LGA    R    20_C      R      17          1.159
LGA    F    21_C      H      18          0.762
LGA    T    22_C      T      19          3.461
LGA    P    23_C      P      20          1.950
LGA    S    24_C      A      21          4.177
LGA    G    25_C      G      22          5.895
LGA    A    26_C      L      23          1.591
LGA    A    27_C      P      24          0.827
LGA    V    28_C      A      25          0.695
LGA    A    29_C      L      26          1.048
LGA    N    30_C      E      27          0.965
LGA    F    31_C      L      28          0.383
LGA    T    32_C      L      29          1.572
LGA    V    33_C      L      30          1.054
LGA    A    34_C      V      31          0.226
LGA    S    35_C      H      32          0.523
LGA    T    36_C      E      33          2.190
LGA    P    37_C      S      34          2.449
LGA    -       -      E      35           -
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    -       -      P      42           -
LGA    -       -      R      43           -
LGA    -       -      R      44           -
LGA    E    51_C      V      45          3.813
LGA    A    52_C      E      46          1.855
LGA    L    53_C      L      47          0.835
LGA    F    54_C      T      48          1.176
LGA    L    55_C      I      49          1.527
LGA    R    56_C      S      50          1.120
LGA    C    57_C      A      51          1.023
LGA    N    58_C      V      52          1.348
LGA    I    59_C      A      53          1.289
LGA    W    60_C      L      54          1.358
LGA    R    61_C      G      55          1.334
LGA    E    62_C      D      56          2.198
LGA    A    63_C      L      57          2.073
LGA    A    64_C      A      58          0.621
LGA    E    65_C      L      59          1.624
LGA    N    66_C      L      60          1.980
LGA    V    67_C      L      61          0.802
LGA    A    68_C      A      62          0.459
LGA    E    69_C      D      63          3.823
LGA    S    70_C      -       -           -
LGA    L    71_C      T      64          1.122
LGA    T    72_C      P      65          1.547
LGA    R    73_C      L      66          1.239
LGA    G    74_C      G      67          1.052
LGA    A    75_C      T      68          0.813
LGA    R    76_C      E      69          0.990
LGA    V    77_C      M      70          0.468
LGA    I    78_C      Q      71          0.366
LGA    V    79_C      V      72          0.379
LGA    S    80_C      Q      73          1.310
LGA    G    81_C      G      74          1.297
LGA    R    82_C      F      75          1.584
LGA    L    83_C      L      76          1.541
LGA    K    84_C      A      77          1.603
LGA    Q    85_C      P      78          1.769
LGA    R    86_C      A      79          2.614
LGA    S    87_C      R      80          1.763
LGA    F    88_C      K      81          4.891
LGA    E    89_C      -       -           -
LGA    T    90_C      -       -           -
LGA    R    91_C      -       -           -
LGA    E    92_C      -       -           -
LGA    G    93_C      -       -           -
LGA    E    94_C      -       -           -
LGA    K    95_C      D      82          5.814
LGA    R    96_C      S      83          2.954
LGA    T    97_C      V      84          3.412
LGA    V    98_C      K      85          1.904
LGA    I    99_C      V      86          1.245
LGA    E   100_C      K      87          1.279
LGA    V   101_C      L      88          1.107
LGA    E   102_C      H      89          1.207
LGA    V   103_C      L      90          0.829
LGA    D   104_C      Q      91          1.022
LGA    E   105_C      Q      92          1.025
LGA    I   106_C      A      93          0.755
LGA    G   107_C      R      94          1.314
LGA    P   108_C      R      95          1.241
LGA    S   109_C      I      96          1.618
LGA    L   110_C      A      97          3.332
LGA    R   111_C      -       -           -
LGA    Y   112_C      -       -           -
LGA    A   113_C      -       -           -
LGA    T   114_C      G      98          4.136
LGA    A   115_C      -       -           -
LGA    K   116_C      -       -           -
LGA    V   117_C      -       -           -
LGA    N   118_C      -       -           -
LGA    K   119_C      -       -           -
LGA    A   120_C      -       -           -
LGA    S   121_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106   98    5.0     88    2.02    13.64     81.648     4.152

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.875461 * X  +   0.233808 * Y  +  -0.422967 * Z  +  46.561497
  Y_new =   0.225568 * X  +  -0.971691 * Y  +  -0.070249 * Z  +  64.303345
  Z_new =  -0.427418 * X  +  -0.033908 * Y  +  -0.903418 * Z  + 171.833832 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.104078    0.037515  [ DEG:  -177.8505      2.1495 ]
  Theta =   0.441635    2.699958  [ DEG:    25.3038    154.6962 ]
  Phi   =   0.252171   -2.889421  [ DEG:    14.4484   -165.5516 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue6_C                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue6_C.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106   98   5.0   88   2.02   13.64  81.648
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue6_C
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE6              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE6    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE6    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1UE6 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *229(H2 O)                                                    
CRYST1   60.363  117.620  175.228  90.00  90.00  90.00 I 21 21 21   32          
ATOM   1538  N   GLY C   3      28.726  29.616  26.367  1.00 60.34           N  
ATOM   1539  CA  GLY C   3      28.356  28.316  27.031  1.00 69.31           C  
ATOM   1540  C   GLY C   3      27.053  27.713  26.526  1.00 65.42           C  
ATOM   1541  O   GLY C   3      26.010  28.372  26.524  1.00 63.98           O  
ATOM   1542  N   ASP C   4      27.102  26.456  26.097  1.00 55.49           N  
ATOM   1543  CA  ASP C   4      25.901  25.808  25.590  1.00 53.14           C  
ATOM   1544  C   ASP C   4      24.868  25.627  26.684  1.00 41.76           C  
ATOM   1545  O   ASP C   4      23.665  25.721  26.448  1.00 52.82           O  
ATOM   1546  CB  ASP C   4      26.232  24.447  24.976  1.00 63.21           C  
ATOM   1547  CG  ASP C   4      26.969  24.570  23.657  1.00 76.33           C  
ATOM   1548  OD1 ASP C   4      28.111  25.076  23.663  1.00 84.77           O  
ATOM   1549  OD2 ASP C   4      26.403  24.163  22.616  1.00 75.44           O  
ATOM   1550  N   THR C   5      25.338  25.381  27.893  1.00 30.89           N  
ATOM   1551  CA  THR C   5      24.435  25.175  29.008  1.00 38.64           C  
ATOM   1552  C   THR C   5      24.935  25.855  30.261  1.00 37.70           C  
ATOM   1553  O   THR C   5      25.843  25.352  30.911  1.00 50.17           O  
ATOM   1554  CB  THR C   5      24.265  23.677  29.315  1.00 48.63           C  
ATOM   1555  OG1 THR C   5      23.823  23.516  30.667  1.00 60.13           O  
ATOM   1556  CG2 THR C   5      25.582  22.938  29.139  1.00 56.50           C  
ATOM   1557  N   THR C   6      24.331  26.988  30.608  1.00 40.92           N  
ATOM   1558  CA  THR C   6      24.718  27.729  31.806  1.00 29.07           C  
ATOM   1559  C   THR C   6      23.555  27.853  32.786  1.00 22.95           C  
ATOM   1560  O   THR C   6      22.450  28.213  32.396  1.00 36.71           O  
ATOM   1561  CB  THR C   6      25.200  29.147  31.446  1.00 50.65           C  
ATOM   1562  OG1 THR C   6      24.110  29.900  30.900  1.00 57.02           O  
ATOM   1563  CG2 THR C   6      26.322  29.079  30.413  1.00 54.84           C  
ATOM   1564  N   ILE C   7      23.802  27.544  34.056  1.00 26.15           N  
ATOM   1565  CA  ILE C   7      22.776  27.649  35.098  1.00 26.42           C  
ATOM   1566  C   ILE C   7      23.264  28.483  36.255  1.00 27.88           C  
ATOM   1567  O   ILE C   7      24.459  28.694  36.423  1.00 22.09           O  
ATOM   1568  CB  ILE C   7      22.405  26.292  35.747  1.00 27.75           C  
ATOM   1569  CG1 ILE C   7      23.620  25.368  35.746  1.00 40.98           C  
ATOM   1570  CG2 ILE C   7      21.223  25.687  35.076  1.00 54.84           C  
ATOM   1571  CD1 ILE C   7      24.729  25.827  36.652  1.00 24.48           C  
ATOM   1572  N   THR C   8      22.311  28.949  37.054  1.00 37.69           N  
ATOM   1573  CA  THR C   8      22.595  29.692  38.269  1.00 28.91           C  
ATOM   1574  C   THR C   8      21.607  29.088  39.245  1.00 30.78           C  
ATOM   1575  O   THR C   8      20.399  29.136  39.027  1.00 37.14           O  
ATOM   1576  CB  THR C   8      22.342  31.205  38.143  1.00 12.46           C  
ATOM   1577  OG1 THR C   8      23.194  31.760  37.131  1.00 43.39           O  
ATOM   1578  CG2 THR C   8      22.676  31.883  39.446  1.00  6.47           C  
ATOM   1579  N   ILE C   9      22.133  28.480  40.301  1.00 35.54           N  
ATOM   1580  CA  ILE C   9      21.305  27.837  41.310  1.00 33.68           C  
ATOM   1581  C   ILE C   9      21.397  28.556  42.637  1.00 22.99           C  
ATOM   1582  O   ILE C   9      22.357  29.266  42.917  1.00 29.93           O  
ATOM   1583  CB  ILE C   9      21.738  26.354  41.567  1.00 42.93           C  
ATOM   1584  CG1 ILE C   9      21.648  25.529  40.283  1.00 42.94           C  
ATOM   1585  CG2 ILE C   9      20.839  25.718  42.614  1.00 44.13           C  
ATOM   1586  CD1 ILE C   9      22.904  25.525  39.454  1.00 33.75           C  
ATOM   1587  N   VAL C  10      20.373  28.357  43.451  1.00 25.16           N  
ATOM   1588  CA  VAL C  10      20.311  28.925  44.782  1.00 26.21           C  
ATOM   1589  C   VAL C  10      19.656  27.843  45.619  1.00 28.06           C  
ATOM   1590  O   VAL C  10      18.661  27.253  45.206  1.00 30.05           O  
ATOM   1591  CB  VAL C  10      19.441  30.202  44.832  1.00 34.29           C  
ATOM   1592  CG1 VAL C  10      19.471  30.801  46.236  1.00 37.18           C  
ATOM   1593  CG2 VAL C  10      19.943  31.211  43.831  1.00 24.27           C  
ATOM   1594  N   GLY C  11      20.230  27.568  46.783  1.00 34.14           N  
ATOM   1595  CA  GLY C  11      19.676  26.541  47.642  1.00 39.63           C  
ATOM   1596  C   GLY C  11      20.537  26.250  48.853  1.00 48.98           C  
ATOM   1597  O   GLY C  11      21.449  27.014  49.190  1.00 42.42           O  
ATOM   1598  N   ASN C  12      20.246  25.131  49.506  1.00 55.85           N  
ATOM   1599  CA  ASN C  12      20.987  24.736  50.684  1.00 55.36           C  
ATOM   1600  C   ASN C  12      21.698  23.412  50.470  1.00 56.12           C  
ATOM   1601  O   ASN C  12      21.206  22.518  49.779  1.00 37.49           O  
ATOM   1602  CB  ASN C  12      20.026  24.673  51.870  1.00 54.48           C  
ATOM   1603  CG  ASN C  12      19.300  25.984  52.070  1.00 66.20           C  
ATOM   1604  OD1 ASN C  12      19.903  26.986  52.470  1.00 58.46           O  
ATOM   1605  ND2 ASN C  12      18.003  25.998  51.770  1.00 68.97           N  
ATOM   1606  N   LEU C  13      22.877  23.287  51.076  1.00 54.70           N  
ATOM   1607  CA  LEU C  13      23.720  22.079  50.969  1.00 54.26           C  
ATOM   1608  C   LEU C  13      23.400  20.580  51.245  1.00 67.82           C  
ATOM   1609  O   LEU C  13      24.231  19.757  50.738  1.00 87.95           O  
ATOM   1610  CB  LEU C  13      25.067  22.487  51.688  1.00 22.40           C  
ATOM   1611  CG  LEU C  13      25.994  23.622  51.170  1.00 34.07           C  
ATOM   1612  CD1 LEU C  13      27.347  23.507  51.852  1.00 28.66           C  
ATOM   1613  CD2 LEU C  13      26.166  23.523  49.666  1.00 30.26           C  
ATOM   1614  N   THR C  14      22.329  20.122  51.931  1.00 60.42           N  
ATOM   1615  CA  THR C  14      22.095  18.725  52.433  1.00 59.20           C  
ATOM   1616  C   THR C  14      23.233  18.288  53.369  1.00 58.02           C  
ATOM   1617  O   THR C  14      23.004  17.550  54.358  1.00 70.49           O  
ATOM   1618  CB  THR C  14      21.841  17.475  51.350  1.00 61.98           C  
ATOM   1619  OG1 THR C  14      23.060  16.874  50.905  1.00 54.82           O  
ATOM   1620  CG2 THR C  14      20.969  17.906  50.219  1.00 51.48           C  
ATOM   1621  N   ALA C  15      24.451  18.780  53.173  1.00 51.91           N  
ATOM   1622  CA  ALA C  15      25.491  18.352  54.069  1.00 52.41           C  
ATOM   1623  C   ALA C  15      26.765  19.170  53.961  1.00 49.53           C  
ATOM   1624  O   ALA C  15      26.820  20.139  53.227  1.00 48.05           O  
ATOM   1625  CB  ALA C  15      25.783  16.867  53.777  1.00 44.98           C  
ATOM   1626  N   ASP C  16      27.800  18.754  54.689  1.00 55.06           N  
ATOM   1627  CA  ASP C  16      29.082  19.437  54.619  1.00 53.89           C  
ATOM   1628  C   ASP C  16      29.691  19.078  53.278  1.00 53.48           C  
ATOM   1629  O   ASP C  16      29.480  17.978  52.769  1.00 56.85           O  
ATOM   1630  CB  ASP C  16      30.023  18.950  55.730  1.00 69.75           C  
ATOM   1631  CG  ASP C  16      29.757  19.609  57.074  1.00 71.93           C  
ATOM   1632  OD1 ASP C  16      28.585  19.636  57.509  1.00 72.58           O  
ATOM   1633  OD2 ASP C  16      30.730  20.088  57.700  1.00 68.84           O  
ATOM   1634  N   PRO C  17      30.455  19.995  52.682  1.00 52.38           N  
ATOM   1635  CA  PRO C  17      31.078  19.704  51.388  1.00 62.22           C  
ATOM   1636  C   PRO C  17      32.267  18.756  51.534  1.00 62.26           C  
ATOM   1637  O   PRO C  17      33.233  19.077  52.220  1.00 73.25           O  
ATOM   1638  CB  PRO C  17      31.503  21.084  50.894  1.00 68.00           C  
ATOM   1639  CG  PRO C  17      31.835  21.799  52.170  1.00 71.62           C  
ATOM   1640  CD  PRO C  17      30.691  21.392  53.082  1.00 53.28           C  
ATOM   1641  N   GLU C  18      32.192  17.594  50.890  1.00 66.48           N  
ATOM   1642  CA  GLU C  18      33.269  16.606  50.945  1.00 64.35           C  
ATOM   1643  C   GLU C  18      34.476  17.026  50.109  1.00 61.61           C  
ATOM   1644  O   GLU C  18      34.334  17.758  49.126  1.00 65.17           O  
ATOM   1645  CB  GLU C  18      32.755  15.256  50.455  1.00 65.62           C  
ATOM   1646  CG  GLU C  18      31.772  14.608  51.402  1.00 85.94           C  
ATOM   1647  CD  GLU C  18      30.885  13.606  50.709  1.00 97.22           C  
ATOM   1648  OE1 GLU C  18      30.003  14.039  49.935  1.00102.87           O  
ATOM   1649  OE2 GLU C  18      31.071  12.391  50.931  1.00103.69           O  
ATOM   1650  N   LEU C  19      35.659  16.560  50.502  1.00 44.17           N  
ATOM   1651  CA  LEU C  19      36.886  16.897  49.785  1.00 49.88           C  
ATOM   1652  C   LEU C  19      37.581  15.617  49.320  1.00 56.17           C  
ATOM   1653  O   LEU C  19      37.513  14.585  49.990  1.00 57.00           O  
ATOM   1654  CB  LEU C  19      37.824  17.705  50.685  1.00 48.26           C  
ATOM   1655  CG  LEU C  19      38.522  18.924  50.070  1.00 53.45           C  
ATOM   1656  CD1 LEU C  19      39.501  19.486  51.083  1.00 63.29           C  
ATOM   1657  CD2 LEU C  19      39.254  18.550  48.795  1.00 54.85           C  
ATOM   1658  N   ARG C  20      38.253  15.688  48.173  1.00 58.87           N  
ATOM   1659  CA  ARG C  20      38.932  14.527  47.611  1.00 58.63           C  
ATOM   1660  C   ARG C  20      40.145  14.927  46.783  1.00 63.01           C  
ATOM   1661  O   ARG C  20      40.206  16.034  46.244  1.00 59.88           O  
ATOM   1662  CB  ARG C  20      37.953  13.735  46.738  1.00 57.00           C  
ATOM   1663  CG  ARG C  20      36.838  13.051  47.521  1.00 68.45           C  
ATOM   1664  CD  ARG C  20      35.690  12.637  46.619  1.00 80.72           C  
ATOM   1665  NE  ARG C  20      36.158  11.957  45.416  1.00 91.84           N  
ATOM   1666  CZ  ARG C  20      35.358  11.448  44.485  1.00 96.95           C  
ATOM   1667  NH1 ARG C  20      34.040  11.535  44.616  1.00 90.68           N  
ATOM   1668  NH2 ARG C  20      35.879  10.858  43.418  1.00103.85           N  
ATOM   1669  N   PHE C  21      41.112  14.018  46.688  1.00 71.43           N  
ATOM   1670  CA  PHE C  21      42.324  14.277  45.922  1.00 79.87           C  
ATOM   1671  C   PHE C  21      42.682  13.167  44.947  1.00 94.09           C  
ATOM   1672  O   PHE C  21      41.990  12.923  43.954  1.00 91.61           O  
ATOM   1673  CB  PHE C  21      43.537  14.471  46.837  1.00 72.92           C  
ATOM   1674  CG  PHE C  21      43.527  15.742  47.614  1.00 64.79           C  
ATOM   1675  CD1 PHE C  21      42.969  15.790  48.883  1.00 51.08           C  
ATOM   1676  CD2 PHE C  21      44.095  16.893  47.084  1.00 60.16           C  
ATOM   1677  CE1 PHE C  21      42.978  16.968  49.615  1.00 50.16           C  
ATOM   1678  CE2 PHE C  21      44.110  18.073  47.807  1.00 65.76           C  
ATOM   1679  CZ  PHE C  21      43.550  18.111  49.076  1.00 57.65           C  
ATOM   1680  N   THR C  22      43.790  12.507  45.280  1.00111.86           N  
ATOM   1681  CA  THR C  22      44.397  11.433  44.503  1.00118.63           C  
ATOM   1682  C   THR C  22      45.359  12.132  43.547  1.00120.06           C  
ATOM   1683  O   THR C  22      44.928  12.938  42.722  1.00122.54           O  
ATOM   1684  CB  THR C  22      43.338  10.651  43.724  1.00129.85           C  
ATOM   1685  N   PRO C  23      46.678  11.865  43.670  1.00114.48           N  
ATOM   1686  CA  PRO C  23      47.673  12.492  42.789  1.00108.98           C  
ATOM   1687  C   PRO C  23      47.095  12.646  41.382  1.00101.52           C  
ATOM   1688  O   PRO C  23      47.453  13.552  40.627  1.00 90.65           O  
ATOM   1689  CB  PRO C  23      48.842  11.520  42.867  1.00109.92           C  
ATOM   1690  CG  PRO C  23      48.805  11.131  44.325  1.00106.21           C  
ATOM   1691  CD  PRO C  23      47.321  10.897  44.581  1.00111.62           C  
ATOM   1692  N   SER C  24      46.185  11.737  41.058  1.00 98.91           N  
ATOM   1693  CA  SER C  24      45.466  11.742  39.799  1.00102.67           C  
ATOM   1694  C   SER C  24      44.198  12.520  40.142  1.00106.80           C  
ATOM   1695  O   SER C  24      43.369  12.054  40.927  1.00110.29           O  
ATOM   1696  CB  SER C  24      45.107  10.316  39.403  1.00105.57           C  
ATOM   1697  OG  SER C  24      44.371   9.691  40.439  1.00106.46           O  
ATOM   1698  N   GLY C  25      44.054  13.711  39.572  1.00105.50           N  
ATOM   1699  CA  GLY C  25      42.894  14.522  39.881  1.00 94.54           C  
ATOM   1700  C   GLY C  25      43.108  15.159  41.242  1.00 97.43           C  
ATOM   1701  O   GLY C  25      42.888  14.515  42.272  1.00 90.32           O  
ATOM   1702  N   ALA C  26      43.549  16.418  41.239  1.00 96.74           N  
ATOM   1703  CA  ALA C  26      43.828  17.179  42.457  1.00 83.49           C  
ATOM   1704  C   ALA C  26      42.631  17.281  43.397  1.00 76.51           C  
ATOM   1705  O   ALA C  26      41.821  16.363  43.493  1.00 76.15           O  
ATOM   1706  CB  ALA C  26      44.325  18.580  42.093  1.00 81.67           C  
ATOM   1707  N   ALA C  27      42.527  18.409  44.092  1.00 73.25           N  
ATOM   1708  CA  ALA C  27      41.442  18.629  45.041  1.00 59.77           C  
ATOM   1709  C   ALA C  27      40.090  18.726  44.342  1.00 52.92           C  
ATOM   1710  O   ALA C  27      39.939  19.432  43.343  1.00 40.64           O  
ATOM   1711  CB  ALA C  27      41.708  19.889  45.841  1.00 69.20           C  
ATOM   1712  N   VAL C  28      39.105  18.016  44.877  1.00 35.86           N  
ATOM   1713  CA  VAL C  28      37.779  18.025  44.294  1.00 44.70           C  
ATOM   1714  C   VAL C  28      36.693  17.972  45.356  1.00 53.04           C  
ATOM   1715  O   VAL C  28      36.568  16.991  46.091  1.00 48.60           O  
ATOM   1716  CB  VAL C  28      37.593  16.837  43.326  1.00 52.18           C  
ATOM   1717  CG1 VAL C  28      36.122  16.689  42.943  1.00 42.50           C  
ATOM   1718  CG2 VAL C  28      38.439  17.056  42.084  1.00 52.73           C  
ATOM   1719  N   ALA C  29      35.902  19.036  45.427  1.00 54.05           N  
ATOM   1720  CA  ALA C  29      34.826  19.097  46.399  1.00 46.52           C  
ATOM   1721  C   ALA C  29      33.538  18.631  45.757  1.00 39.23           C  
ATOM   1722  O   ALA C  29      33.317  18.855  44.569  1.00 35.60           O  
ATOM   1723  CB  ALA C  29      34.662  20.525  46.911  1.00 53.61           C  
ATOM   1724  N   ASN C  30      32.701  17.969  46.546  1.00 34.40           N  
ATOM   1725  CA  ASN C  30      31.408  17.503  46.071  1.00 36.38           C  
ATOM   1726  C   ASN C  30      30.386  17.818  47.144  1.00 40.97           C  
ATOM   1727  O   ASN C  30      30.713  17.862  48.327  1.00 39.38           O  
ATOM   1728  CB  ASN C  30      31.403  15.993  45.804  1.00 48.81           C  
ATOM   1729  CG  ASN C  30      32.379  15.584  44.711  1.00 63.33           C  
ATOM   1730  OD1 ASN C  30      32.389  16.153  43.619  1.00 75.08           O  
ATOM   1731  ND2 ASN C  30      33.198  14.579  44.999  1.00 74.76           N  
ATOM   1732  N   PHE C  31      29.154  18.054  46.714  1.00 44.52           N  
ATOM   1733  CA  PHE C  31      28.042  18.353  47.604  1.00 40.20           C  
ATOM   1734  C   PHE C  31      26.809  18.509  46.740  1.00 42.21           C  
ATOM   1735  O   PHE C  31      26.924  18.650  45.526  1.00 49.35           O  
ATOM   1736  CB  PHE C  31      28.289  19.650  48.379  1.00 47.39           C  
ATOM   1737  CG  PHE C  31      28.661  20.818  47.515  1.00 44.56           C  
ATOM   1738  CD1 PHE C  31      29.985  21.049  47.171  1.00 55.54           C  
ATOM   1739  CD2 PHE C  31      27.688  21.686  47.036  1.00 49.28           C  
ATOM   1740  CE1 PHE C  31      30.335  22.130  46.361  1.00 49.36           C  
ATOM   1741  CE2 PHE C  31      28.032  22.769  46.222  1.00 50.29           C  
ATOM   1742  CZ  PHE C  31      29.358  22.989  45.885  1.00 34.39           C  
ATOM   1743  N   THR C  32      25.628  18.457  47.341  1.00 37.15           N  
ATOM   1744  CA  THR C  32      24.419  18.642  46.557  1.00 46.05           C  
ATOM   1745  C   THR C  32      23.640  19.817  47.123  1.00 53.71           C  
ATOM   1746  O   THR C  32      23.404  19.892  48.333  1.00 49.00           O  
ATOM   1747  CB  THR C  32      23.501  17.401  46.559  1.00 38.36           C  
ATOM   1748  OG1 THR C  32      22.912  17.241  47.850  1.00 49.29           O  
ATOM   1749  CG2 THR C  32      24.282  16.168  46.208  1.00 23.13           C  
ATOM   1750  N   VAL C  33      23.256  20.743  46.247  1.00 51.07           N  
ATOM   1751  CA  VAL C  33      22.495  21.911  46.670  1.00 50.17           C  
ATOM   1752  C   VAL C  33      21.003  21.596  46.573  1.00 45.61           C  
ATOM   1753  O   VAL C  33      20.543  21.007  45.598  1.00 47.72           O  
ATOM   1754  CB  VAL C  33      22.872  23.166  45.828  1.00 29.88           C  
ATOM   1755  CG1 VAL C  33      22.878  22.847  44.356  1.00 54.60           C  
ATOM   1756  CG2 VAL C  33      21.897  24.279  46.105  1.00 51.49           C  
ATOM   1757  N   ALA C  34      20.257  21.960  47.611  1.00 56.30           N  
ATOM   1758  CA  ALA C  34      18.825  21.689  47.654  1.00 60.73           C  
ATOM   1759  C   ALA C  34      17.971  22.899  47.304  1.00 63.90           C  
ATOM   1760  O   ALA C  34      17.807  23.814  48.111  1.00 62.17           O  
ATOM   1761  CB  ALA C  34      18.444  21.169  49.030  1.00 60.97           C  
ATOM   1762  N   SER C  35      17.440  22.898  46.086  1.00 66.58           N  
ATOM   1763  CA  SER C  35      16.577  23.974  45.616  1.00 76.85           C  
ATOM   1764  C   SER C  35      15.174  23.369  45.611  1.00 89.47           C  
ATOM   1765  O   SER C  35      15.025  22.162  45.418  1.00 96.07           O  
ATOM   1766  CB  SER C  35      16.983  24.410  44.201  1.00 71.73           C  
ATOM   1767  OG  SER C  35      18.297  24.952  44.171  1.00 55.62           O  
ATOM   1768  N   THR C  36      14.147  24.183  45.829  1.00 98.67           N  
ATOM   1769  CA  THR C  36      12.789  23.645  45.860  1.00105.04           C  
ATOM   1770  C   THR C  36      11.763  24.231  44.886  1.00110.36           C  
ATOM   1771  O   THR C  36      11.062  23.482  44.203  1.00112.68           O  
ATOM   1772  CB  THR C  36      12.205  23.723  47.286  1.00102.49           C  
ATOM   1773  OG1 THR C  36      12.333  25.060  47.785  1.00105.00           O  
ATOM   1774  CG2 THR C  36      12.933  22.762  48.215  1.00 97.51           C  
ATOM   1775  N   PRO C  37      11.661  25.571  44.799  1.00112.50           N  
ATOM   1776  CA  PRO C  37      10.690  26.194  43.890  1.00116.14           C  
ATOM   1777  C   PRO C  37      10.897  25.885  42.406  1.00117.27           C  
ATOM   1778  O   PRO C  37      10.671  26.797  41.581  1.00113.31           O  
ATOM   1779  CB  PRO C  37      10.845  27.681  44.200  1.00116.76           C  
ATOM   1780  CG  PRO C  37      12.295  27.789  44.538  1.00111.02           C  
ATOM   1781  CD  PRO C  37      12.496  26.600  45.444  1.00113.37           C  
ATOM   1782  N   GLU C  51       7.923  20.269  44.994  1.00 82.38           N  
ATOM   1783  CA  GLU C  51       8.772  20.125  43.780  1.00 80.11           C  
ATOM   1784  C   GLU C  51      10.121  19.504  44.137  1.00 80.26           C  
ATOM   1785  O   GLU C  51      10.433  18.401  43.694  1.00 88.68           O  
ATOM   1786  CB  GLU C  51       8.976  21.490  43.129  1.00 89.56           C  
ATOM   1787  N   ALA C  52      10.911  20.220  44.936  1.00 70.92           N  
ATOM   1788  CA  ALA C  52      12.232  19.766  45.382  1.00 68.07           C  
ATOM   1789  C   ALA C  52      13.162  19.280  44.270  1.00 66.81           C  
ATOM   1790  O   ALA C  52      12.866  18.307  43.578  1.00 72.49           O  
ATOM   1791  CB  ALA C  52      12.081  18.677  46.428  1.00 52.78           C  
ATOM   1792  N   LEU C  53      14.299  19.957  44.124  1.00 59.45           N  
ATOM   1793  CA  LEU C  53      15.297  19.616  43.110  1.00 52.99           C  
ATOM   1794  C   LEU C  53      16.655  19.512  43.804  1.00 48.23           C  
ATOM   1795  O   LEU C  53      17.056  20.415  44.534  1.00 53.18           O  
ATOM   1796  CB  LEU C  53      15.306  20.698  42.010  1.00 43.96           C  
ATOM   1797  CG  LEU C  53      16.216  20.736  40.767  1.00 38.33           C  
ATOM   1798  CD1 LEU C  53      17.330  21.703  41.031  1.00 39.68           C  
ATOM   1799  CD2 LEU C  53      16.755  19.368  40.386  1.00 21.28           C  
ATOM   1800  N   PHE C  54      17.354  18.401  43.591  1.00 49.94           N  
ATOM   1801  CA  PHE C  54      18.659  18.197  44.212  1.00 49.38           C  
ATOM   1802  C   PHE C  54      19.754  18.164  43.150  1.00 52.86           C  
ATOM   1803  O   PHE C  54      19.654  17.406  42.181  1.00 59.04           O  
ATOM   1804  CB  PHE C  54      18.665  16.885  45.002  1.00 54.13           C  
ATOM   1805  CG  PHE C  54      17.568  16.786  46.027  1.00 69.97           C  
ATOM   1806  CD1 PHE C  54      16.251  16.554  45.637  1.00 75.36           C  
ATOM   1807  CD2 PHE C  54      17.848  16.935  47.385  1.00 70.35           C  
ATOM   1808  CE1 PHE C  54      15.230  16.472  46.584  1.00 78.59           C  
ATOM   1809  CE2 PHE C  54      16.834  16.854  48.338  1.00 69.91           C  
ATOM   1810  CZ  PHE C  54      15.524  16.623  47.937  1.00 75.57           C  
ATOM   1811  N   LEU C  55      20.800  18.971  43.335  1.00 37.69           N  
ATOM   1812  CA  LEU C  55      21.881  19.022  42.358  1.00 42.24           C  
ATOM   1813  C   LEU C  55      23.258  18.765  42.929  1.00 43.34           C  
ATOM   1814  O   LEU C  55      23.726  19.523  43.774  1.00 40.06           O  
ATOM   1815  CB  LEU C  55      21.886  20.383  41.658  1.00 29.34           C  
ATOM   1816  CG  LEU C  55      20.556  20.777  41.024  1.00 44.71           C  
ATOM   1817  CD1 LEU C  55      20.601  22.225  40.541  1.00 38.32           C  
ATOM   1818  CD2 LEU C  55      20.257  19.816  39.886  1.00 19.94           C  
ATOM   1819  N   ARG C  56      23.907  17.702  42.450  1.00 44.24           N  
ATOM   1820  CA  ARG C  56      25.257  17.347  42.894  1.00 51.30           C  
ATOM   1821  C   ARG C  56      26.238  18.269  42.172  1.00 40.92           C  
ATOM   1822  O   ARG C  56      26.269  18.319  40.944  1.00 44.56           O  
ATOM   1823  CB  ARG C  56      25.560  15.883  42.548  1.00 51.40           C  
ATOM   1824  CG  ARG C  56      26.174  15.051  43.673  1.00 67.29           C  
ATOM   1825  CD  ARG C  56      27.570  15.519  44.060  1.00 93.71           C  
ATOM   1826  NE  ARG C  56      28.245  14.583  44.963  1.00106.15           N  
ATOM   1827  CZ  ARG C  56      27.856  14.309  46.206  1.00106.50           C  
ATOM   1828  NH1 ARG C  56      26.786  14.896  46.725  1.00104.15           N  
ATOM   1829  NH2 ARG C  56      28.545  13.442  46.934  1.00107.21           N  
ATOM   1830  N   CYS C  57      27.046  18.995  42.930  1.00 40.31           N  
ATOM   1831  CA  CYS C  57      27.993  19.925  42.325  1.00 49.13           C  
ATOM   1832  C   CYS C  57      29.448  19.529  42.549  1.00 46.78           C  
ATOM   1833  O   CYS C  57      29.762  18.772  43.465  1.00 45.35           O  
ATOM   1834  CB  CYS C  57      27.762  21.333  42.883  1.00 34.81           C  
ATOM   1835  SG  CYS C  57      26.045  21.776  42.971  1.00 37.60           S  
ATOM   1836  N   ASN C  58      30.330  20.074  41.716  1.00 46.93           N  
ATOM   1837  CA  ASN C  58      31.752  19.789  41.811  1.00 42.85           C  
ATOM   1838  C   ASN C  58      32.587  21.047  41.647  1.00 48.35           C  
ATOM   1839  O   ASN C  58      32.365  21.825  40.719  1.00 50.71           O  
ATOM   1840  CB  ASN C  58      32.163  18.811  40.716  1.00 38.50           C  
ATOM   1841  CG  ASN C  58      31.105  17.782  40.434  1.00 43.55           C  
ATOM   1842  OD1 ASN C  58      30.672  17.062  41.333  1.00 37.24           O  
ATOM   1843  ND2 ASN C  58      30.675  17.701  39.173  1.00 35.18           N  
ATOM   1844  N   ILE C  59      33.543  21.245  42.555  1.00 48.08           N  
ATOM   1845  CA  ILE C  59      34.449  22.381  42.469  1.00 43.09           C  
ATOM   1846  C   ILE C  59      35.828  21.762  42.320  1.00 47.67           C  
ATOM   1847  O   ILE C  59      36.061  20.640  42.770  1.00 41.16           O  
ATOM   1848  CB  ILE C  59      34.441  23.275  43.726  1.00 46.89           C  
ATOM   1849  CG1 ILE C  59      33.252  22.927  44.616  1.00 43.10           C  
ATOM   1850  CG2 ILE C  59      34.384  24.766  43.295  1.00 25.67           C  
ATOM   1851  CD1 ILE C  59      31.925  23.223  43.969  1.00 69.79           C  
ATOM   1852  N   TRP C  60      36.741  22.487  41.688  1.00 57.42           N  
ATOM   1853  CA  TRP C  60      38.077  21.968  41.467  1.00 67.28           C  
ATOM   1854  C   TRP C  60      39.199  22.825  42.018  1.00 72.19           C  
ATOM   1855  O   TRP C  60      39.154  24.055  41.960  1.00 76.85           O  
ATOM   1856  CB  TRP C  60      38.301  21.733  39.966  1.00 73.78           C  
ATOM   1857  CG  TRP C  60      38.358  20.276  39.596  1.00 87.68           C  
ATOM   1858  CD1 TRP C  60      39.464  19.469  39.583  1.00 87.29           C  
ATOM   1859  CD2 TRP C  60      37.248  19.434  39.271  1.00 88.91           C  
ATOM   1860  NE1 TRP C  60      39.107  18.178  39.277  1.00 82.51           N  
ATOM   1861  CE2 TRP C  60      37.754  18.128  39.083  1.00 91.12           C  
ATOM   1862  CE3 TRP C  60      35.871  19.657  39.129  1.00 92.82           C  
ATOM   1863  CZ2 TRP C  60      36.930  17.047  38.755  1.00100.31           C  
ATOM   1864  CZ3 TRP C  60      35.052  18.582  38.804  1.00105.05           C  
ATOM   1865  CH2 TRP C  60      35.585  17.292  38.622  1.00109.96           C  
ATOM   1866  N   ARG C  61      40.204  22.151  42.565  1.00 73.18           N  
ATOM   1867  CA  ARG C  61      41.378  22.811  43.101  1.00 70.94           C  
ATOM   1868  C   ARG C  61      41.026  23.829  44.178  1.00 69.52           C  
ATOM   1869  O   ARG C  61      40.160  23.576  45.016  1.00 63.50           O  
ATOM   1870  CB  ARG C  61      42.118  23.485  41.950  1.00 73.38           C  
ATOM   1871  CG  ARG C  61      42.112  22.646  40.682  1.00 79.54           C  
ATOM   1872  CD  ARG C  61      41.571  23.440  39.503  1.00 95.33           C  
ATOM   1873  NE  ARG C  61      41.113  22.574  38.417  1.00101.61           N  
ATOM   1874  CZ  ARG C  61      40.502  23.011  37.320  1.00 99.88           C  
ATOM   1875  NH1 ARG C  61      40.275  24.308  37.156  1.00 96.45           N  
ATOM   1876  NH2 ARG C  61      40.101  22.150  36.396  1.00103.00           N  
ATOM   1877  N   GLU C  62      41.710  24.972  44.143  1.00 68.65           N  
ATOM   1878  CA  GLU C  62      41.505  26.058  45.104  1.00 79.87           C  
ATOM   1879  C   GLU C  62      40.100  26.125  45.689  1.00 75.75           C  
ATOM   1880  O   GLU C  62      39.858  25.699  46.818  1.00 72.08           O  
ATOM   1881  CB  GLU C  62      41.817  27.410  44.457  1.00 94.80           C  
ATOM   1882  CG  GLU C  62      43.292  27.732  44.280  1.00114.59           C  
ATOM   1883  CD  GLU C  62      43.509  29.164  43.813  1.00123.56           C  
ATOM   1884  OE1 GLU C  62      43.036  29.508  42.707  1.00133.69           O  
ATOM   1885  OE2 GLU C  62      44.148  29.945  44.552  1.00117.79           O  
ATOM   1886  N   ALA C  63      39.182  26.687  44.911  1.00 72.97           N  
ATOM   1887  CA  ALA C  63      37.800  26.833  45.332  1.00 71.38           C  
ATOM   1888  C   ALA C  63      37.352  25.624  46.143  1.00 66.76           C  
ATOM   1889  O   ALA C  63      36.778  25.769  47.224  1.00 62.30           O  
ATOM   1890  CB  ALA C  63      36.905  27.009  44.108  1.00 75.29           C  
ATOM   1891  N   ALA C  64      37.632  24.436  45.616  1.00 65.40           N  
ATOM   1892  CA  ALA C  64      37.244  23.212  46.292  1.00 67.57           C  
ATOM   1893  C   ALA C  64      37.531  23.246  47.780  1.00 66.18           C  
ATOM   1894  O   ALA C  64      36.641  23.030  48.609  1.00 56.54           O  
ATOM   1895  N   GLU C  65      38.780  23.537  48.119  1.00 60.35           N  
ATOM   1896  CA  GLU C  65      39.194  23.583  49.508  1.00 65.44           C  
ATOM   1897  C   GLU C  65      38.459  24.674  50.273  1.00 63.98           C  
ATOM   1898  O   GLU C  65      37.921  24.421  51.357  1.00 60.57           O  
ATOM   1899  CB  GLU C  65      40.707  23.777  49.579  1.00 68.35           C  
ATOM   1900  CG  GLU C  65      41.451  22.759  48.732  1.00 86.18           C  
ATOM   1901  CD  GLU C  65      42.952  22.811  48.910  1.00 94.28           C  
ATOM   1902  OE1 GLU C  65      43.539  23.906  48.762  1.00100.04           O  
ATOM   1903  OE2 GLU C  65      43.545  21.747  49.191  1.00 96.71           O  
ATOM   1904  N   ASN C  66      38.433  25.880  49.708  1.00 55.78           N  
ATOM   1905  CA  ASN C  66      37.740  26.992  50.348  1.00 53.76           C  
ATOM   1906  C   ASN C  66      36.324  26.527  50.679  1.00 43.64           C  
ATOM   1907  O   ASN C  66      35.866  26.652  51.810  1.00 33.89           O  
ATOM   1908  CB  ASN C  66      37.692  28.214  49.422  1.00 49.59           C  
ATOM   1909  CG  ASN C  66      39.073  28.765  49.108  1.00 53.02           C  
ATOM   1910  OD1 ASN C  66      39.918  28.891  49.992  1.00 69.99           O  
ATOM   1911  ND2 ASN C  66      39.301  29.109  47.847  1.00 58.97           N  
ATOM   1912  N   VAL C  67      35.637  25.975  49.688  1.00 35.30           N  
ATOM   1913  CA  VAL C  67      34.289  25.477  49.905  1.00 41.16           C  
ATOM   1914  C   VAL C  67      34.275  24.491  51.070  1.00 40.81           C  
ATOM   1915  O   VAL C  67      33.452  24.596  51.973  1.00 46.58           O  
ATOM   1916  CB  VAL C  67      33.751  24.767  48.648  1.00 38.16           C  
ATOM   1917  CG1 VAL C  67      32.417  24.119  48.946  1.00 28.75           C  
ATOM   1918  CG2 VAL C  67      33.610  25.764  47.511  1.00 45.87           C  
ATOM   1919  N   ALA C  68      35.200  23.539  51.043  1.00 46.86           N  
ATOM   1920  CA  ALA C  68      35.287  22.521  52.079  1.00 51.65           C  
ATOM   1921  C   ALA C  68      35.522  23.104  53.468  1.00 46.75           C  
ATOM   1922  O   ALA C  68      34.872  22.715  54.445  1.00 42.93           O  
ATOM   1923  CB  ALA C  68      36.392  21.538  51.734  1.00 55.83           C  
ATOM   1924  N   GLU C  69      36.446  24.051  53.552  1.00 48.64           N  
ATOM   1925  CA  GLU C  69      36.773  24.668  54.828  1.00 56.00           C  
ATOM   1926  C   GLU C  69      35.971  25.897  55.251  1.00 51.29           C  
ATOM   1927  O   GLU C  69      36.316  26.528  56.251  1.00 57.19           O  
ATOM   1928  CB  GLU C  69      38.264  25.014  54.862  1.00 75.06           C  
ATOM   1929  CG  GLU C  69      38.741  25.880  53.712  1.00 87.59           C  
ATOM   1930  CD  GLU C  69      40.138  26.419  53.944  1.00 97.16           C  
ATOM   1931  OE1 GLU C  69      40.336  27.140  54.948  1.00102.45           O  
ATOM   1932  OE2 GLU C  69      41.031  26.124  53.127  1.00 85.73           O  
ATOM   1933  N   SER C  70      34.914  26.251  54.521  1.00 59.93           N  
ATOM   1934  CA  SER C  70      34.123  27.422  54.902  1.00 53.20           C  
ATOM   1935  C   SER C  70      32.616  27.357  54.650  1.00 49.37           C  
ATOM   1936  O   SER C  70      31.974  28.391  54.489  1.00 66.30           O  
ATOM   1937  CB  SER C  70      34.691  28.680  54.238  1.00 50.87           C  
ATOM   1938  OG  SER C  70      34.416  28.714  52.855  1.00 49.74           O  
ATOM   1939  N   LEU C  71      32.056  26.152  54.623  1.00 47.54           N  
ATOM   1940  CA  LEU C  71      30.619  25.951  54.419  1.00 46.18           C  
ATOM   1941  C   LEU C  71      30.211  24.667  55.123  1.00 55.59           C  
ATOM   1942  O   LEU C  71      30.980  23.709  55.178  1.00 67.01           O  
ATOM   1943  CB  LEU C  71      30.261  25.814  52.928  1.00 43.62           C  
ATOM   1944  CG  LEU C  71      30.272  27.000  51.961  1.00 36.06           C  
ATOM   1945  CD1 LEU C  71      29.775  26.524  50.620  1.00 41.14           C  
ATOM   1946  CD2 LEU C  71      29.380  28.114  52.461  1.00 22.61           C  
ATOM   1947  N   THR C  72      28.995  24.640  55.652  1.00 52.33           N  
ATOM   1948  CA  THR C  72      28.502  23.460  56.342  1.00 52.79           C  
ATOM   1949  C   THR C  72      27.109  23.149  55.833  1.00 53.72           C  
ATOM   1950  O   THR C  72      26.516  23.960  55.126  1.00 57.13           O  
ATOM   1951  CB  THR C  72      28.439  23.699  57.848  1.00 55.29           C  
ATOM   1952  OG1 THR C  72      27.516  24.760  58.130  1.00 61.50           O  
ATOM   1953  CG2 THR C  72      29.809  24.082  58.357  1.00 60.36           C  
ATOM   1954  N   ARG C  73      26.583  21.982  56.191  1.00 49.62           N  
ATOM   1955  CA  ARG C  73      25.256  21.609  55.737  1.00 53.08           C  
ATOM   1956  C   ARG C  73      24.279  22.736  56.016  1.00 49.34           C  
ATOM   1957  O   ARG C  73      24.500  23.538  56.924  1.00 50.88           O  
ATOM   1958  CB  ARG C  73      24.772  20.342  56.437  1.00 59.61           C  
ATOM   1959  CG  ARG C  73      24.465  20.513  57.905  1.00 71.77           C  
ATOM   1960  CD  ARG C  73      23.693  19.312  58.427  1.00 79.22           C  
ATOM   1961  NE  ARG C  73      22.357  19.229  57.844  1.00 82.18           N  
ATOM   1962  CZ  ARG C  73      21.501  18.240  58.071  1.00 85.33           C  
ATOM   1963  NH1 ARG C  73      20.305  18.250  57.499  1.00 94.40           N  
ATOM   1964  NH2 ARG C  73      21.840  17.234  58.864  1.00 94.13           N  
ATOM   1965  N   GLY C  74      23.214  22.796  55.219  1.00 50.78           N  
ATOM   1966  CA  GLY C  74      22.193  23.816  55.391  1.00 48.81           C  
ATOM   1967  C   GLY C  74      22.503  25.242  54.954  1.00 47.02           C  
ATOM   1968  O   GLY C  74      21.651  26.115  55.106  1.00 56.22           O  
ATOM   1969  N   ALA C  75      23.692  25.499  54.413  1.00 36.35           N  
ATOM   1970  CA  ALA C  75      24.029  26.858  53.989  1.00 46.72           C  
ATOM   1971  C   ALA C  75      23.372  27.231  52.657  1.00 48.36           C  
ATOM   1972  O   ALA C  75      23.468  26.486  51.683  1.00 61.95           O  
ATOM   1973  CB  ALA C  75      25.559  27.024  53.889  1.00 22.08           C  
ATOM   1974  N   ARG C  76      22.691  28.375  52.628  1.00 43.28           N  
ATOM   1975  CA  ARG C  76      22.053  28.850  51.407  1.00 28.61           C  
ATOM   1976  C   ARG C  76      23.202  29.374  50.561  1.00 33.32           C  
ATOM   1977  O   ARG C  76      23.986  30.219  51.014  1.00 37.98           O  
ATOM   1978  CB  ARG C  76      21.063  29.978  51.706  1.00 30.57           C  
ATOM   1979  CG  ARG C  76      20.066  30.265  50.569  1.00 35.03           C  
ATOM   1980  CD  ARG C  76      19.067  31.347  50.969  1.00 35.99           C  
ATOM   1981  NE  ARG C  76      17.871  31.344  50.127  1.00 31.15           N  
ATOM   1982  CZ  ARG C  76      17.693  32.096  49.045  1.00 47.02           C  
ATOM   1983  NH1 ARG C  76      18.632  32.947  48.631  1.00 62.94           N  
ATOM   1984  NH2 ARG C  76      16.558  31.996  48.371  1.00 53.28           N  
ATOM   1985  N   VAL C  77      23.301  28.882  49.332  1.00 24.98           N  
ATOM   1986  CA  VAL C  77      24.397  29.277  48.457  1.00 24.29           C  
ATOM   1987  C   VAL C  77      23.923  29.693  47.074  1.00 23.15           C  
ATOM   1988  O   VAL C  77      22.801  29.380  46.682  1.00 24.08           O  
ATOM   1989  CB  VAL C  77      25.412  28.089  48.289  1.00 29.74           C  
ATOM   1990  CG1 VAL C  77      26.014  27.710  49.617  1.00 31.56           C  
ATOM   1991  CG2 VAL C  77      24.713  26.875  47.723  1.00 17.37           C  
ATOM   1992  N   ILE C  78      24.776  30.427  46.355  1.00 21.25           N  
ATOM   1993  CA  ILE C  78      24.487  30.821  44.981  1.00 20.75           C  
ATOM   1994  C   ILE C  78      25.564  30.085  44.195  1.00 32.36           C  
ATOM   1995  O   ILE C  78      26.745  30.192  44.519  1.00 38.42           O  
ATOM   1996  CB  ILE C  78      24.677  32.330  44.709  1.00 28.05           C  
ATOM   1997  CG1 ILE C  78      23.945  33.161  45.756  1.00 46.34           C  
ATOM   1998  CG2 ILE C  78      24.108  32.678  43.314  1.00 12.72           C  
ATOM   1999  CD1 ILE C  78      23.986  34.666  45.486  1.00 41.99           C  
ATOM   2000  N   VAL C  79      25.164  29.338  43.173  1.00 33.54           N  
ATOM   2001  CA  VAL C  79      26.115  28.585  42.360  1.00 35.45           C  
ATOM   2002  C   VAL C  79      25.937  28.915  40.889  1.00 32.35           C  
ATOM   2003  O   VAL C  79      24.817  28.994  40.395  1.00 39.34           O  
ATOM   2004  CB  VAL C  79      25.899  27.036  42.477  1.00 38.83           C  
ATOM   2005  CG1 VAL C  79      27.057  26.291  41.834  1.00 27.90           C  
ATOM   2006  CG2 VAL C  79      25.731  26.621  43.903  1.00 15.80           C  
ATOM   2007  N   SER C  80      27.040  29.103  40.181  1.00 23.27           N  
ATOM   2008  CA  SER C  80      26.946  29.350  38.755  1.00 28.17           C  
ATOM   2009  C   SER C  80      27.832  28.284  38.135  1.00 35.31           C  
ATOM   2010  O   SER C  80      28.862  27.922  38.698  1.00 38.18           O  
ATOM   2011  CB  SER C  80      27.453  30.742  38.390  1.00 33.87           C  
ATOM   2012  OG  SER C  80      28.864  30.785  38.388  1.00 60.88           O  
ATOM   2013  N   GLY C  81      27.423  27.757  36.993  1.00 33.63           N  
ATOM   2014  CA  GLY C  81      28.217  26.736  36.346  1.00 27.12           C  
ATOM   2015  C   GLY C  81      27.506  26.149  35.153  1.00 27.99           C  
ATOM   2016  O   GLY C  81      26.554  26.721  34.636  1.00 39.75           O  
ATOM   2017  N   ARG C  82      27.966  24.993  34.710  1.00 39.25           N  
ATOM   2018  CA  ARG C  82      27.346  24.349  33.575  1.00 36.14           C  
ATOM   2019  C   ARG C  82      26.869  22.971  33.963  1.00 33.55           C  
ATOM   2020  O   ARG C  82      27.269  22.439  34.991  1.00 39.69           O  
ATOM   2021  CB  ARG C  82      28.334  24.253  32.417  1.00 35.48           C  
ATOM   2022  CG  ARG C  82      29.704  23.755  32.783  1.00 36.27           C  
ATOM   2023  CD  ARG C  82      30.488  23.365  31.531  1.00 76.06           C  
ATOM   2024  NE  ARG C  82      30.162  24.192  30.364  1.00 98.27           N  
ATOM   2025  CZ  ARG C  82      29.173  23.938  29.505  1.00100.95           C  
ATOM   2026  NH1 ARG C  82      28.402  22.870  29.675  1.00 99.42           N  
ATOM   2027  NH2 ARG C  82      28.952  24.749  28.474  1.00 84.16           N  
ATOM   2028  N   LEU C  83      25.994  22.407  33.142  1.00 37.08           N  
ATOM   2029  CA  LEU C  83      25.469  21.083  33.405  1.00 35.95           C  
ATOM   2030  C   LEU C  83      26.378  20.024  32.821  1.00 32.30           C  
ATOM   2031  O   LEU C  83      26.947  20.204  31.751  1.00 33.42           O  
ATOM   2032  CB  LEU C  83      24.071  20.941  32.813  1.00 42.94           C  
ATOM   2033  CG  LEU C  83      23.056  21.916  33.402  1.00 34.77           C  
ATOM   2034  CD1 LEU C  83      21.666  21.523  32.958  1.00 44.39           C  
ATOM   2035  CD2 LEU C  83      23.154  21.887  34.915  1.00 45.26           C  
ATOM   2036  N   LYS C  84      26.511  18.917  33.537  1.00 37.39           N  
ATOM   2037  CA  LYS C  84      27.353  17.823  33.082  1.00 42.44           C  
ATOM   2038  C   LYS C  84      26.596  16.525  33.279  1.00 44.06           C  
ATOM   2039  O   LYS C  84      25.715  16.444  34.132  1.00 59.25           O  
ATOM   2040  CB  LYS C  84      28.649  17.799  33.888  1.00 47.03           C  
ATOM   2041  CG  LYS C  84      29.754  16.978  33.267  1.00 63.21           C  
ATOM   2042  CD  LYS C  84      31.104  17.384  33.838  1.00 67.98           C  
ATOM   2043  CE  LYS C  84      32.241  16.718  33.081  1.00 77.34           C  
ATOM   2044  NZ  LYS C  84      32.200  17.034  31.619  1.00 82.66           N  
ATOM   2045  N   GLN C  85      26.913  15.520  32.470  1.00 52.68           N  
ATOM   2046  CA  GLN C  85      26.271  14.214  32.593  1.00 47.23           C  
ATOM   2047  C   GLN C  85      27.395  13.326  33.061  1.00 41.92           C  
ATOM   2048  O   GLN C  85      28.455  13.303  32.427  1.00 42.26           O  
ATOM   2049  CB  GLN C  85      25.743  13.737  31.244  1.00 45.32           C  
ATOM   2050  CG  GLN C  85      24.342  13.141  31.312  1.00 50.01           C  
ATOM   2051  CD  GLN C  85      23.721  12.947  29.934  1.00 67.42           C  
ATOM   2052  OE1 GLN C  85      24.238  12.193  29.106  1.00 80.88           O  
ATOM   2053  NE2 GLN C  85      22.608  13.628  29.683  1.00 36.15           N  
ATOM   2054  N   ARG C  86      27.198  12.608  34.154  1.00 46.15           N  
ATOM   2055  CA  ARG C  86      28.262  11.746  34.717  1.00 53.92           C  
ATOM   2056  C   ARG C  86      28.434  10.369  34.095  1.00 61.11           C  
ATOM   2057  O   ARG C  86      29.475  10.133  33.394  1.00 65.62           O  
ATOM   2058  CB  ARG C  86      28.057  11.606  36.218  1.00 39.67           C  
ATOM   2059  CG  ARG C  86      29.349  11.616  37.023  1.00 46.49           C  
ATOM   2060  CD  ARG C  86      29.057  11.408  38.499  1.00 38.76           C  
ATOM   2061  NE  ARG C  86      28.530  10.067  38.725  1.00 56.47           N  
ATOM   2062  CZ  ARG C  86      27.827   9.697  39.789  1.00 47.22           C  
ATOM   2063  NH1 ARG C  86      27.550  10.569  40.748  1.00 50.67           N  
ATOM   2064  NH2 ARG C  86      27.409   8.445  39.892  1.00 53.34           N  
ATOM   2065  N   SER C  87      27.455   9.448  34.285  1.00 48.37           N  
ATOM   2066  CA  SER C  87      27.514   8.111  33.708  1.00 56.96           C  
ATOM   2067  C   SER C  87      28.247   7.133  34.596  1.00 51.18           C  
ATOM   2068  O   SER C  87      29.420   7.222  34.872  1.00 57.06           O  
ATOM   2069  CB  SER C  87      28.134   8.091  32.273  1.00 52.10           C  
ATOM   2070  OG  SER C  87      29.543   8.090  32.235  1.00 74.39           O  
ATOM   2071  N   PHE C  88      27.465   6.187  35.022  1.00 58.13           N  
ATOM   2072  CA  PHE C  88      27.986   5.192  35.927  1.00 51.06           C  
ATOM   2073  C   PHE C  88      27.225   3.885  35.888  1.00 55.74           C  
ATOM   2074  O   PHE C  88      26.057   3.843  35.490  1.00 48.72           O  
ATOM   2075  CB  PHE C  88      27.937   5.772  37.325  1.00 48.07           C  
ATOM   2076  CG  PHE C  88      26.550   6.071  37.803  1.00 48.18           C  
ATOM   2077  CD1 PHE C  88      25.892   7.225  37.406  1.00 25.06           C  
ATOM   2078  CD2 PHE C  88      25.873   5.153  38.602  1.00 47.75           C  
ATOM   2079  CE1 PHE C  88      24.580   7.455  37.791  1.00 34.09           C  
ATOM   2080  CE2 PHE C  88      24.559   5.378  38.989  1.00 39.87           C  
ATOM   2081  CZ  PHE C  88      23.912   6.526  38.582  1.00 41.15           C  
ATOM   2082  N   GLU C  89      27.901   2.823  36.321  1.00 46.91           N  
ATOM   2083  CA  GLU C  89      27.281   1.502  36.359  1.00 40.33           C  
ATOM   2084  C   GLU C  89      26.823   1.079  37.750  1.00 29.99           C  
ATOM   2085  O   GLU C  89      27.586   1.126  38.702  1.00 37.24           O  
ATOM   2086  CB  GLU C  89      28.226   0.437  35.803  1.00 49.78           C  
ATOM   2087  CG  GLU C  89      28.246   0.343  34.286  1.00 67.43           C  
ATOM   2088  CD  GLU C  89      28.743  -1.006  33.790  1.00 72.33           C  
ATOM   2089  OE1 GLU C  89      29.889  -1.381  34.121  1.00 72.75           O  
ATOM   2090  OE2 GLU C  89      27.984  -1.690  33.070  1.00 74.71           O  
ATOM   2091  N   THR C  90      25.571   0.654  37.860  1.00 32.94           N  
ATOM   2092  CA  THR C  90      25.022   0.202  39.139  1.00 44.61           C  
ATOM   2093  C   THR C  90      25.703  -1.088  39.628  1.00 45.92           C  
ATOM   2094  O   THR C  90      26.504  -1.688  38.921  1.00 33.40           O  
ATOM   2095  CB  THR C  90      23.514  -0.078  39.022  1.00 41.07           C  
ATOM   2096  OG1 THR C  90      23.288  -1.101  38.039  1.00 40.21           O  
ATOM   2097  CG2 THR C  90      22.777   1.188  38.617  1.00 43.25           C  
ATOM   2098  N   ARG C  91      25.378  -1.520  40.839  1.00 49.63           N  
ATOM   2099  CA  ARG C  91      25.972  -2.742  41.369  1.00 52.58           C  
ATOM   2100  C   ARG C  91      25.747  -3.884  40.382  1.00 48.14           C  
ATOM   2101  O   ARG C  91      26.673  -4.629  40.045  1.00 53.69           O  
ATOM   2102  CB  ARG C  91      25.351  -3.102  42.719  1.00 45.94           C  
ATOM   2103  CG  ARG C  91      26.090  -4.206  43.427  1.00 62.77           C  
ATOM   2104  CD  ARG C  91      25.503  -4.535  44.788  1.00 69.32           C  
ATOM   2105  NE  ARG C  91      26.431  -5.387  45.528  1.00 78.44           N  
ATOM   2106  CZ  ARG C  91      26.772  -6.621  45.164  1.00 69.90           C  
ATOM   2107  NH1 ARG C  91      26.257  -7.168  44.072  1.00 84.82           N  
ATOM   2108  NH2 ARG C  91      27.657  -7.300  45.879  1.00 68.45           N  
ATOM   2109  N   GLU C  92      24.508  -4.007  39.920  1.00 44.95           N  
ATOM   2110  CA  GLU C  92      24.126  -5.044  38.971  1.00 48.32           C  
ATOM   2111  C   GLU C  92      24.835  -4.886  37.627  1.00 41.82           C  
ATOM   2112  O   GLU C  92      25.014  -5.857  36.894  1.00 57.92           O  
ATOM   2113  CB  GLU C  92      22.601  -5.053  38.770  1.00 49.85           C  
ATOM   2114  CG  GLU C  92      21.801  -5.813  39.848  1.00 57.45           C  
ATOM   2115  CD  GLU C  92      21.568  -5.014  41.131  1.00 68.28           C  
ATOM   2116  OE1 GLU C  92      22.552  -4.571  41.757  1.00 84.70           O  
ATOM   2117  OE2 GLU C  92      20.394  -4.833  41.522  1.00 75.69           O  
ATOM   2118  N   GLY C  93      25.235  -3.665  37.300  1.00 44.76           N  
ATOM   2119  CA  GLY C  93      25.942  -3.449  36.050  1.00 61.18           C  
ATOM   2120  C   GLY C  93      25.224  -2.680  34.954  1.00 69.21           C  
ATOM   2121  O   GLY C  93      25.703  -2.641  33.814  1.00 63.75           O  
ATOM   2122  N   GLU C  94      24.092  -2.060  35.272  1.00 69.00           N  
ATOM   2123  CA  GLU C  94      23.381  -1.318  34.247  1.00 79.38           C  
ATOM   2124  C   GLU C  94      23.834   0.129  34.126  1.00 79.11           C  
ATOM   2125  O   GLU C  94      24.055   0.810  35.127  1.00 77.99           O  
ATOM   2126  CB  GLU C  94      21.875  -1.374  34.480  1.00 87.05           C  
ATOM   2127  CG  GLU C  94      21.096  -0.834  33.292  1.00114.14           C  
ATOM   2128  CD  GLU C  94      21.536  -1.428  31.953  1.00120.19           C  
ATOM   2129  OE1 GLU C  94      21.038  -0.958  30.908  1.00123.17           O  
ATOM   2130  OE2 GLU C  94      22.372  -2.360  31.939  1.00126.48           O  
ATOM   2131  N   LYS C  95      23.974   0.591  32.884  1.00 81.40           N  
ATOM   2132  CA  LYS C  95      24.417   1.955  32.613  1.00 84.05           C  
ATOM   2133  C   LYS C  95      23.423   3.020  33.063  1.00 79.86           C  
ATOM   2134  O   LYS C  95      22.223   2.922  32.811  1.00 80.43           O  
ATOM   2135  CB  LYS C  95      24.725   2.129  31.125  1.00 91.33           C  
ATOM   2136  CG  LYS C  95      25.972   1.379  30.670  1.00110.32           C  
ATOM   2137  CD  LYS C  95      25.703  -0.097  30.405  1.00112.80           C  
ATOM   2138  CE  LYS C  95      25.143  -0.309  29.007  1.00114.81           C  
ATOM   2139  NZ  LYS C  95      26.093   0.156  27.950  1.00104.87           N  
ATOM   2140  N   ARG C  96      23.947   4.036  33.738  1.00 71.67           N  
ATOM   2141  CA  ARG C  96      23.144   5.133  34.251  1.00 58.34           C  
ATOM   2142  C   ARG C  96      23.878   6.441  34.017  1.00 56.96           C  
ATOM   2143  O   ARG C  96      25.048   6.446  33.642  1.00 58.08           O  
ATOM   2144  CB  ARG C  96      22.916   4.959  35.752  1.00 58.64           C  
ATOM   2145  CG  ARG C  96      22.017   3.802  36.115  1.00 61.18           C  
ATOM   2146  CD  ARG C  96      20.599   4.084  35.673  1.00 67.90           C  
ATOM   2147  NE  ARG C  96      19.758   2.898  35.745  1.00 72.40           N  
ATOM   2148  CZ  ARG C  96      19.449   2.267  36.872  1.00 75.74           C  
ATOM   2149  NH1 ARG C  96      19.913   2.715  38.032  1.00 73.49           N  
ATOM   2150  NH2 ARG C  96      18.681   1.184  36.835  1.00 63.05           N  
ATOM   2151  N   THR C  97      23.172   7.547  34.222  1.00 56.91           N  
ATOM   2152  CA  THR C  97      23.746   8.886  34.091  1.00 51.62           C  
ATOM   2153  C   THR C  97      23.045   9.798  35.082  1.00 47.02           C  
ATOM   2154  O   THR C  97      21.910   9.546  35.509  1.00 31.55           O  
ATOM   2155  CB  THR C  97      23.561   9.510  32.683  1.00 43.66           C  
ATOM   2156  OG1 THR C  97      22.168   9.517  32.330  1.00 47.11           O  
ATOM   2157  CG2 THR C  97      24.375   8.758  31.652  1.00 48.29           C  
ATOM   2158  N   VAL C  98      23.722  10.870  35.452  1.00 44.73           N  
ATOM   2159  CA  VAL C  98      23.122  11.791  36.383  1.00 47.76           C  
ATOM   2160  C   VAL C  98      23.513  13.217  36.030  1.00 47.25           C  
ATOM   2161  O   VAL C  98      24.656  13.496  35.668  1.00 41.54           O  
ATOM   2162  CB  VAL C  98      23.536  11.438  37.836  1.00 51.88           C  
ATOM   2163  CG1 VAL C  98      25.036  11.601  38.006  1.00 51.74           C  
ATOM   2164  CG2 VAL C  98      22.743  12.280  38.836  1.00 31.31           C  
ATOM   2165  N   ILE C  99      22.532  14.109  36.088  1.00 41.68           N  
ATOM   2166  CA  ILE C  99      22.770  15.509  35.805  1.00 39.19           C  
ATOM   2167  C   ILE C  99      23.469  16.131  37.015  1.00 38.72           C  
ATOM   2168  O   ILE C  99      22.987  16.043  38.146  1.00 26.12           O  
ATOM   2169  CB  ILE C  99      21.440  16.251  35.532  1.00 39.39           C  
ATOM   2170  CG1 ILE C  99      20.944  15.915  34.125  1.00 48.36           C  
ATOM   2171  CG2 ILE C  99      21.624  17.753  35.695  1.00 45.97           C  
ATOM   2172  CD1 ILE C  99      21.955  16.201  33.035  1.00 32.79           C  
ATOM   2173  N   GLU C 100      24.623  16.736  36.779  1.00 23.54           N  
ATOM   2174  CA  GLU C 100      25.347  17.383  37.850  1.00 30.33           C  
ATOM   2175  C   GLU C 100      25.806  18.758  37.395  1.00 35.72           C  
ATOM   2176  O   GLU C 100      25.681  19.118  36.226  1.00 34.46           O  
ATOM   2177  CB  GLU C 100      26.549  16.549  38.265  1.00 25.84           C  
ATOM   2178  CG  GLU C 100      26.208  15.105  38.572  1.00 46.83           C  
ATOM   2179  CD  GLU C 100      27.381  14.348  39.161  1.00 32.69           C  
ATOM   2180  OE1 GLU C 100      28.516  14.527  38.669  1.00 43.52           O  
ATOM   2181  OE2 GLU C 100      27.165  13.571  40.110  1.00 50.74           O  
ATOM   2182  N   VAL C 101      26.359  19.516  38.325  1.00 30.49           N  
ATOM   2183  CA  VAL C 101      26.813  20.852  38.020  1.00 31.29           C  
ATOM   2184  C   VAL C 101      28.305  21.015  38.199  1.00 28.61           C  
ATOM   2185  O   VAL C 101      28.837  20.736  39.271  1.00 44.90           O  
ATOM   2186  CB  VAL C 101      26.104  21.882  38.945  1.00 34.06           C  
ATOM   2187  CG1 VAL C 101      26.690  23.267  38.738  1.00 21.19           C  
ATOM   2188  CG2 VAL C 101      24.606  21.879  38.680  1.00 22.96           C  
ATOM   2189  N   GLU C 102      28.984  21.470  37.156  1.00 28.46           N  
ATOM   2190  CA  GLU C 102      30.412  21.726  37.274  1.00 34.36           C  
ATOM   2191  C   GLU C 102      30.459  23.197  37.698  1.00 32.94           C  
ATOM   2192  O   GLU C 102      30.245  24.088  36.887  1.00 32.48           O  
ATOM   2193  CB  GLU C 102      31.119  21.524  35.931  1.00 27.21           C  
ATOM   2194  CG  GLU C 102      32.577  21.037  36.043  1.00 71.70           C  
ATOM   2195  CD  GLU C 102      32.706  19.592  36.556  1.00 78.84           C  
ATOM   2196  OE1 GLU C 102      32.504  19.346  37.765  1.00 76.38           O  
ATOM   2197  OE2 GLU C 102      33.007  18.698  35.738  1.00 82.62           O  
ATOM   2198  N   VAL C 103      30.715  23.433  38.982  1.00 29.39           N  
ATOM   2199  CA  VAL C 103      30.756  24.774  39.536  1.00 21.23           C  
ATOM   2200  C   VAL C 103      31.868  25.678  39.032  1.00 24.84           C  
ATOM   2201  O   VAL C 103      33.038  25.350  39.120  1.00 36.48           O  
ATOM   2202  CB  VAL C 103      30.834  24.735  41.070  1.00 24.23           C  
ATOM   2203  CG1 VAL C 103      30.919  26.150  41.620  1.00 30.50           C  
ATOM   2204  CG2 VAL C 103      29.607  24.042  41.638  1.00 12.57           C  
ATOM   2205  N   ASP C 104      31.479  26.831  38.506  1.00 26.52           N  
ATOM   2206  CA  ASP C 104      32.423  27.812  38.003  1.00 28.31           C  
ATOM   2207  C   ASP C 104      32.671  28.805  39.135  1.00 30.37           C  
ATOM   2208  O   ASP C 104      33.793  29.242  39.350  1.00 47.80           O  
ATOM   2209  CB  ASP C 104      31.844  28.521  36.767  1.00 20.73           C  
ATOM   2210  N   GLU C 105      31.603  29.151  39.851  1.00 36.42           N  
ATOM   2211  CA  GLU C 105      31.656  30.064  40.989  1.00 27.26           C  
ATOM   2212  C   GLU C 105      30.542  29.660  41.956  1.00 32.17           C  
ATOM   2213  O   GLU C 105      29.446  29.291  41.527  1.00 27.53           O  
ATOM   2214  CB  GLU C 105      31.467  31.507  40.533  1.00 45.89           C  
ATOM   2215  N   ILE C 106      30.843  29.722  43.255  1.00 31.34           N  
ATOM   2216  CA  ILE C 106      29.921  29.362  44.334  1.00 25.27           C  
ATOM   2217  C   ILE C 106      30.190  30.261  45.539  1.00 35.07           C  
ATOM   2218  O   ILE C 106      31.340  30.608  45.817  1.00 43.42           O  
ATOM   2219  CB  ILE C 106      30.125  27.894  44.761  1.00 35.62           C  
ATOM   2220  CG1 ILE C 106      29.381  27.593  46.064  1.00 36.81           C  
ATOM   2221  CG2 ILE C 106      31.597  27.623  44.978  1.00 49.54           C  
ATOM   2222  CD1 ILE C 106      27.890  27.596  45.944  1.00 50.76           C  
ATOM   2223  N   GLY C 107      29.134  30.645  46.253  1.00 44.61           N  
ATOM   2224  CA  GLY C 107      29.301  31.510  47.413  1.00 36.11           C  
ATOM   2225  C   GLY C 107      28.148  31.452  48.401  1.00 36.95           C  
ATOM   2226  O   GLY C 107      27.046  31.022  48.057  1.00 39.88           O  
ATOM   2227  N   PRO C 108      28.375  31.876  49.651  1.00 31.27           N  
ATOM   2228  CA  PRO C 108      27.341  31.869  50.690  1.00 32.59           C  
ATOM   2229  C   PRO C 108      26.369  33.032  50.452  1.00 37.35           C  
ATOM   2230  O   PRO C 108      26.797  34.187  50.292  1.00 24.34           O  
ATOM   2231  CB  PRO C 108      28.137  32.059  51.989  1.00 37.10           C  
ATOM   2232  CG  PRO C 108      29.596  31.874  51.592  1.00 29.85           C  
ATOM   2233  CD  PRO C 108      29.649  32.378  50.185  1.00 34.40           C  
ATOM   2234  N   SER C 109      25.072  32.726  50.440  1.00 34.70           N  
ATOM   2235  CA  SER C 109      24.038  33.739  50.212  1.00 44.38           C  
ATOM   2236  C   SER C 109      23.821  34.635  51.433  1.00 47.05           C  
ATOM   2237  O   SER C 109      23.432  34.165  52.513  1.00 35.25           O  
ATOM   2238  CB  SER C 109      22.716  33.068  49.830  1.00 35.92           C  
ATOM   2239  OG  SER C 109      21.655  34.010  49.788  1.00 49.82           O  
ATOM   2240  N   LEU C 110      24.060  35.928  51.246  1.00 37.04           N  
ATOM   2241  CA  LEU C 110      23.910  36.892  52.324  1.00 31.19           C  
ATOM   2242  C   LEU C 110      22.462  37.277  52.590  1.00 36.87           C  
ATOM   2243  O   LEU C 110      22.195  38.285  53.241  1.00 49.02           O  
ATOM   2244  CB  LEU C 110      24.723  38.143  52.011  1.00 30.71           C  
ATOM   2245  CG  LEU C 110      26.225  37.897  51.887  1.00 31.88           C  
ATOM   2246  CD1 LEU C 110      26.946  39.210  51.613  1.00 32.51           C  
ATOM   2247  CD2 LEU C 110      26.722  37.259  53.172  1.00 27.17           C  
ATOM   2248  N   ARG C 111      21.526  36.478  52.093  1.00 46.35           N  
ATOM   2249  CA  ARG C 111      20.112  36.772  52.301  1.00 60.35           C  
ATOM   2250  C   ARG C 111      19.684  36.472  53.739  1.00 66.40           C  
ATOM   2251  O   ARG C 111      18.934  37.245  54.332  1.00 73.70           O  
ATOM   2252  CB  ARG C 111      19.240  35.966  51.331  1.00 64.98           C  
ATOM   2253  CG  ARG C 111      17.756  36.273  51.461  1.00 70.72           C  
ATOM   2254  CD  ARG C 111      16.865  35.333  50.653  1.00 84.21           C  
ATOM   2255  NE  ARG C 111      16.708  35.733  49.256  1.00 91.90           N  
ATOM   2256  CZ  ARG C 111      15.802  35.212  48.433  1.00 94.31           C  
ATOM   2257  NH1 ARG C 111      14.974  34.270  48.865  1.00 94.21           N  
ATOM   2258  NH2 ARG C 111      15.721  35.633  47.179  1.00101.18           N  
ATOM   2259  N   TYR C 112      20.158  35.354  54.292  1.00 63.64           N  
ATOM   2260  CA  TYR C 112      19.816  34.959  55.660  1.00 63.80           C  
ATOM   2261  C   TYR C 112      21.043  34.729  56.548  1.00 71.69           C  
ATOM   2262  O   TYR C 112      20.922  34.188  57.654  1.00 73.64           O  
ATOM   2263  CB  TYR C 112      18.986  33.670  55.655  1.00 67.55           C  
ATOM   2264  CG  TYR C 112      17.664  33.760  54.936  1.00 61.25           C  
ATOM   2265  CD1 TYR C 112      16.953  32.606  54.618  1.00 60.85           C  
ATOM   2266  CD2 TYR C 112      17.139  34.989  54.538  1.00 63.98           C  
ATOM   2267  CE1 TYR C 112      15.759  32.670  53.907  1.00 69.39           C  
ATOM   2268  CE2 TYR C 112      15.943  35.067  53.829  1.00 69.10           C  
ATOM   2269  CZ  TYR C 112      15.261  33.904  53.511  1.00 70.76           C  
ATOM   2270  OH  TYR C 112      14.114  33.975  52.758  1.00 68.84           O  
ATOM   2271  N   ALA C 113      22.217  35.128  56.070  1.00 62.00           N  
ATOM   2272  CA  ALA C 113      23.440  34.937  56.832  1.00 47.42           C  
ATOM   2273  C   ALA C 113      24.319  36.179  56.757  1.00 54.18           C  
ATOM   2274  O   ALA C 113      23.947  37.153  56.115  1.00 58.43           O  
ATOM   2275  CB  ALA C 113      24.187  33.733  56.308  1.00 63.87           C  
ATOM   2276  N   THR C 114      25.491  36.122  57.403  1.00 43.08           N  
ATOM   2277  CA  THR C 114      26.414  37.254  57.441  1.00 47.82           C  
ATOM   2278  C   THR C 114      27.778  36.975  56.804  1.00 47.33           C  
ATOM   2279  O   THR C 114      28.183  37.654  55.908  1.00 63.69           O  
ATOM   2280  CB  THR C 114      26.596  37.740  58.861  1.00 62.18           C  
ATOM   2281  OG1 THR C 114      25.329  38.201  59.350  1.00 62.83           O  
ATOM   2282  CG2 THR C 114      27.606  38.866  58.898  1.00 67.02           C  
ATOM   2283  N   ALA C 115      28.495  35.979  57.276  1.00 45.50           N  
ATOM   2284  CA  ALA C 115      29.754  35.650  56.638  1.00 48.78           C  
ATOM   2285  C   ALA C 115      30.825  36.674  56.738  1.00 44.26           C  
ATOM   2286  O   ALA C 115      30.673  37.805  56.272  1.00 42.01           O  
ATOM   2287  N   LYS C 116      31.968  36.237  57.248  1.00 39.53           N  
ATOM   2288  CA  LYS C 116      33.123  37.080  57.401  1.00 33.15           C  
ATOM   2289  C   LYS C 116      34.139  36.668  56.365  1.00 48.78           C  
ATOM   2290  O   LYS C 116      34.828  35.661  56.522  1.00 47.63           O  
ATOM   2291  CB  LYS C 116      33.697  36.925  58.816  1.00 41.05           C  
ATOM   2292  N   VAL C 117      34.224  37.462  55.310  1.00 55.19           N  
ATOM   2293  CA  VAL C 117      35.118  37.171  54.208  1.00 58.66           C  
ATOM   2294  C   VAL C 117      36.610  37.356  54.464  1.00 62.23           C  
ATOM   2295  O   VAL C 117      37.115  38.481  54.496  1.00 53.57           O  
ATOM   2296  CB  VAL C 117      34.716  38.005  52.974  1.00 60.08           C  
ATOM   2297  CG1 VAL C 117      35.618  37.681  51.798  1.00 58.19           C  
ATOM   2298  CG2 VAL C 117      33.268  37.728  52.627  1.00 49.24           C  
ATOM   2299  N   ASN C 118      37.310  36.239  54.633  1.00 70.69           N  
ATOM   2300  CA  ASN C 118      38.754  36.253  54.849  1.00 80.28           C  
ATOM   2301  C   ASN C 118      39.375  35.856  53.515  1.00 83.64           C  
ATOM   2302  O   ASN C 118      39.069  34.792  52.981  1.00 87.53           O  
ATOM   2303  CB  ASN C 118      39.139  35.251  55.930  1.00 84.35           C  
ATOM   2304  N   LYS C 119      40.244  36.701  52.974  1.00 85.73           N  
ATOM   2305  CA  LYS C 119      40.849  36.409  51.682  1.00 89.67           C  
ATOM   2306  C   LYS C 119      42.359  36.180  51.687  1.00 99.08           C  
ATOM   2307  O   LYS C 119      43.061  36.525  52.642  1.00 99.56           O  
ATOM   2308  CB  LYS C 119      40.500  37.519  50.699  1.00 80.07           C  
ATOM   2309  N   ALA C 120      42.840  35.590  50.592  1.00106.62           N  
ATOM   2310  CA  ALA C 120      44.255  35.294  50.396  1.00108.96           C  
ATOM   2311  C   ALA C 120      44.851  36.323  49.431  1.00114.13           C  
ATOM   2312  O   ALA C 120      44.133  36.889  48.606  1.00118.49           O  
ATOM   2313  CB  ALA C 120      44.414  33.887  49.831  1.00106.64           C  
ATOM   2314  N   SER C 121      46.160  36.556  49.533  1.00115.66           N  
ATOM   2315  CA  SER C 121      46.853  37.530  48.682  1.00112.77           C  
ATOM   2316  C   SER C 121      47.053  37.075  47.233  1.00112.27           C  
ATOM   2317  O   SER C 121      46.818  37.899  46.319  1.00103.13           O  
ATOM   2318  CB  SER C 121      48.199  37.891  49.303  1.00105.59           C  
TER    2319      SER C 121                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
