
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  849),  selected  110 , name 1v1q_A
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1v1q_A.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P    -4_A      -       -           -
LGA    N    -3_A      -       -           -
LGA    S    -2_A      -       -           -
LGA    L    -1_A      -       -           -
LGA    M     1_A      -       -           -
LGA    T     2_A      M       1          0.636
LGA    N     3_A      N       2          0.915
LGA    R     4_A      T       3          0.774
LGA    L     5_A      L       4          0.595
LGA    V     6_A      E       5          0.977
LGA    L     7_A      L       6          1.067
LGA    S     8_A      S       7          1.342
LGA    G     9_A      A       8          1.535
LGA    T    10_A      R       9          1.363
LGA    V    11_A      V      10          0.957
LGA    C    12_A      L      11          1.025
LGA    R    13_A      E      12          0.995
LGA    A    14_A      C      13          2.369
LGA    P    15_A      G      14          3.259
LGA    L    16_A      A      15          2.208
LGA    R    17_A      M      16          1.492
LGA    K    18_A      R      17          1.553
LGA    V    19_A      H      18          1.360
LGA    S    20_A      T      19          1.676
LGA    P    21_A      P      20          2.714
LGA    S    22_A      A      21          2.872
LGA    G    23_A      G      22          2.262
LGA    I    24_A      L      23          1.793
LGA    P    25_A      P      24          1.256
LGA    H    26_A      A      25          0.566
LGA    C    27_A      L      26          1.088
LGA    Q    28_A      E      27          0.836
LGA    F    29_A      L      28          0.728
LGA    V    30_A      L      29          0.320
LGA    L    31_A      L      30          0.163
LGA    E    32_A      V      31          0.995
LGA    H    33_A      H      32          1.264
LGA    R    34_A      E      33          1.731
LGA    S    35_A      S      34          1.635
LGA    V    36_A      E      35          1.297
LGA    Q    37_A      V      36          1.240
LGA    E    38_A      V      37          1.812
LGA    E    39_A      E      38          1.225
LGA    A    40_A      A      39          1.514
LGA    G    41_A      G      40          1.787
LGA    F    42_A      H      41          1.313
LGA    H    43_A      P      42          1.241
LGA    R    44_A      R      43          1.712
LGA    Q    45_A      R      44          1.675
LGA    A    46_A      V      45          1.458
LGA    W    47_A      E      46          1.786
LGA    C    48_A      L      47          1.506
LGA    Q    49_A      T      48          1.087
LGA    M    50_A      I      49          0.624
LGA    P    51_A      S      50          0.355
LGA    V    52_A      A      51          0.607
LGA    I    53_A      V      52          0.815
LGA    V    54_A      A      53          0.783
LGA    S    55_A      L      54          0.706
LGA    G    56_A      G      55          1.679
LGA    H    57_A      -       -           -
LGA    E    58_A      D      56          2.754
LGA    N    59_A      L      57          3.022
LGA    Q    60_A      A      58          3.001
LGA    A    61_A      L      59          3.909
LGA    I    62_A      L      60          2.729
LGA    T    63_A      L      61          1.135
LGA    H    64_A      A      62          4.226
LGA    S    65_A      D      63          6.110
LGA    I    66_A      T      64          1.578
LGA    T    67_A      P      65          2.073
LGA    V    68_A      L      66          1.379
LGA    G    69_A      G      67          1.448
LGA    S    70_A      T      68          1.013
LGA    R    71_A      E      69          1.387
LGA    I    72_A      M      70          0.987
LGA    T    73_A      Q      71          1.397
LGA    V    74_A      V      72          1.331
LGA    Q    75_A      Q      73          1.072
LGA    G    76_A      G      74          1.058
LGA    F    77_A      F      75          1.048
LGA    I    78_A      L      76          1.006
LGA    S    79_A      A      77          0.781
LGA    C    80_A      P      78          1.120
LGA    H    81_A      A      79          3.876
LGA    -       -      R      80           -
LGA    -       -      K      81           -
LGA    K    82_A      D      82          2.467
LGA    A    83_A      S      83          2.865
LGA    K    84_A      -       -           -
LGA    N    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    L    87_A      V      84          1.701
LGA    S    88_A      K      85          1.960
LGA    K    89_A      -       -           -
LGA    M    90_A      V      86          1.041
LGA    V    91_A      K      87          0.945
LGA    L    92_A      L      88          0.833
LGA    H    93_A      H      89          0.997
LGA    A    94_A      L      90          1.041
LGA    E    95_A      Q      91          1.486
LGA    Q    96_A      Q      92          1.540
LGA    I    97_A      A      93          1.432
LGA    E    98_A      R      94          1.905
LGA    L    99_A      R      95          2.025
LGA    I   100_A      I      96          2.326
LGA    D   101_A      A      97          2.563
LGA    S   102_A      G      98          4.657
LGA    V   103_A      -       -           -
LGA    D   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    L   106_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   98    5.0     96    1.87    26.04     89.290     4.875

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.768486 * X  +   0.113480 * Y  +   0.629724 * Z  +  16.107473
  Y_new =  -0.517191 * X  +  -0.689627 * Y  +  -0.506881 * Z  +  45.667564
  Z_new =   0.376754 * X  +  -0.715218 * Y  +   0.588659 * Z  +  40.415703 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.882158    2.259434  [ DEG:   -50.5439    129.4561 ]
  Theta =  -0.386290   -2.755303  [ DEG:   -22.1328   -157.8672 ]
  Phi   =  -2.549218    0.592374  [ DEG:  -146.0594     33.9405 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1v1q_A                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1v1q_A.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   98   5.0   96   1.87   26.04  89.290
REMARK  ---------------------------------------------------------- 
MOLECULE 1v1q_A
HEADER    DNA BINDING                             22-APR-04   1V1Q              
TITLE     CRYSTAL STRUCTURE OF PRIB- A PRIMOSOMAL DNA REPLICATION               
TITLE    2 PROTEIN OF ESCHERICHIA COLI                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRIMOSOMAL REPLICATION PROTEIN N;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: K12;                                                         
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET21B-PRIB                               
KEYWDS    PRIMOSOME, DNA REPLICATION, DNA BINDING                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.-H.LIU,T.-W.CHANG,C.-Y.HUANG,M.-C.CHANG,S.-U.CHEN,H.-N.WU,          
AUTHOR   2 C.-D.HSIAO                                                           
REVDAT   2   03-MAY-05 1V1Q    1       JRNL                                     
REVDAT   1   25-OCT-04 1V1Q    0                                                
JRNL        AUTH   J.H.LIU,T.W.CHANG,C.Y.HUANG,S.U.CHEN,H.N.WU,                 
JRNL        AUTH 2 M.C.CHANG,C.D.HSIAO                                          
JRNL        TITL   CRYSTAL STRUCTURE OF PRIB, A PRIMOSOMAL DNA                  
JRNL        TITL 2 REPLICATION PROTEIN OF ESCHERICHIA COLI.                     
JRNL        REF    J.BIOL.CHEM.                  V. 279 50465 2004              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1V1Q A  -17    -1  UNP    P07013   PRIB_ECOLI     -17     -1             
DBREF  1V1Q A    1   104  UNP    P07013   PRIB_ECOLI       1    104             
DBREF  1V1Q A  105   117  UNP    P07013   PRIB_ECOLI     105    117             
DBREF  1V1Q B  -17    -1  UNP    P07013   PRIB_ECOLI     -17     -1             
DBREF  1V1Q B    1   104  UNP    P07013   PRIB_ECOLI       1    104             
DBREF  1V1Q B  105   117  UNP    P07013   PRIB_ECOLI     105    117             
SEQRES   1 A  134  MET ALA SER MET THR GLY GLY GLN GLN MET GLY ARG ASP          
SEQRES   2 A  134  PRO ASN SER LEU MET THR ASN ARG LEU VAL LEU SER GLY          
SEQRES   3 A  134  THR VAL CYS ARG ALA PRO LEU ARG LYS VAL SER PRO SER          
SEQRES   4 A  134  GLY ILE PRO HIS CYS GLN PHE VAL LEU GLU HIS ARG SER          
SEQRES   5 A  134  VAL GLN GLU GLU ALA GLY PHE HIS ARG GLN ALA TRP CYS          
SEQRES   6 A  134  GLN MET PRO VAL ILE VAL SER GLY HIS GLU ASN GLN ALA          
SEQRES   7 A  134  ILE THR HIS SER ILE THR VAL GLY SER ARG ILE THR VAL          
SEQRES   8 A  134  GLN GLY PHE ILE SER CYS HIS LYS ALA LYS ASN GLY LEU          
SEQRES   9 A  134  SER LYS MET VAL LEU HIS ALA GLU GLN ILE GLU LEU ILE          
SEQRES  10 A  134  ASP SER VAL ASP LYS LEU ALA ALA ALA LEU GLU HIS HIS          
SEQRES  11 A  134  HIS HIS HIS HIS                                              
SEQRES   1 B  134  MET ALA SER MET THR GLY GLY GLN GLN MET GLY ARG ASP          
SEQRES   2 B  134  PRO ASN SER LEU MET THR ASN ARG LEU VAL LEU SER GLY          
SEQRES   3 B  134  THR VAL CYS ARG ALA PRO LEU ARG LYS VAL SER PRO SER          
SEQRES   4 B  134  GLY ILE PRO HIS CYS GLN PHE VAL LEU GLU HIS ARG SER          
SEQRES   5 B  134  VAL GLN GLU GLU ALA GLY PHE HIS ARG GLN ALA TRP CYS          
SEQRES   6 B  134  GLN MET PRO VAL ILE VAL SER GLY HIS GLU ASN GLN ALA          
SEQRES   7 B  134  ILE THR HIS SER ILE THR VAL GLY SER ARG ILE THR VAL          
SEQRES   8 B  134  GLN GLY PHE ILE SER CYS HIS LYS ALA LYS ASN GLY LEU          
SEQRES   9 B  134  SER LYS MET VAL LEU HIS ALA GLU GLN ILE GLU LEU ILE          
SEQRES  10 B  134  ASP SER VAL ASP LYS LEU ALA ALA ALA LEU GLU HIS HIS          
SEQRES  11 B  134  HIS HIS HIS HIS                                              
HET    CYS  A 201       7                                                       
HET    CYS  A 202       7                                                       
HET    CYS  B 203       7                                                       
HETNAM     CYS CYSTEINE                                                         
FORMUL   3  CYS    3(C3 H7 N O2 S)                                              
FORMUL   5  HOH   *134(H2 O)                                                    
CRYST1   39.322   57.358   97.019  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   PRO A  -4      31.830  26.244  15.994  1.00 85.53           N  
ATOM      2  CA  PRO A  -4      31.382  25.080  16.794  1.00 85.05           C  
ATOM      3  C   PRO A  -4      30.631  25.427  18.080  1.00 84.22           C  
ATOM      4  O   PRO A  -4      29.554  24.893  18.335  1.00 84.32           O  
ATOM      5  CB  PRO A  -4      32.623  24.248  17.105  1.00 85.14           C  
ATOM      6  CG  PRO A  -4      33.750  25.269  16.896  1.00 85.96           C  
ATOM      7  CD  PRO A  -4      33.273  26.134  15.726  1.00 84.92           C  
ATOM      8  N   ASN A  -3      31.193  26.329  18.878  1.00 81.92           N  
ATOM      9  CA  ASN A  -3      30.591  26.732  20.155  1.00 79.68           C  
ATOM     10  C   ASN A  -3      29.143  27.233  20.143  1.00 77.28           C  
ATOM     11  O   ASN A  -3      28.645  27.701  21.167  1.00 76.61           O  
ATOM     12  CB  ASN A  -3      31.460  27.799  20.824  1.00 80.36           C  
ATOM     13  CG  ASN A  -3      31.608  29.043  19.972  1.00 81.86           C  
ATOM     14  OD1 ASN A  -3      30.616  29.643  19.552  1.00 81.95           O  
ATOM     15  ND2 ASN A  -3      32.847  29.442  19.713  1.00 82.07           N  
ATOM     16  N   SER A  -2      28.463  27.142  19.006  1.00 74.08           N  
ATOM     17  CA  SER A  -2      27.083  27.607  18.943  1.00 71.22           C  
ATOM     18  C   SER A  -2      26.157  26.669  19.722  1.00 68.64           C  
ATOM     19  O   SER A  -2      25.214  27.110  20.387  1.00 69.40           O  
ATOM     20  CB  SER A  -2      26.614  27.703  17.487  1.00 71.88           C  
ATOM     21  OG  SER A  -2      25.363  28.358  17.404  1.00 71.42           O  
ATOM     22  N   LEU A  -1      26.453  25.375  19.650  1.00 63.91           N  
ATOM     23  CA  LEU A  -1      25.660  24.344  20.309  1.00 59.12           C  
ATOM     24  C   LEU A  -1      26.260  23.907  21.651  1.00 55.26           C  
ATOM     25  O   LEU A  -1      25.964  22.815  22.147  1.00 53.91           O  
ATOM     26  CB  LEU A  -1      25.560  23.135  19.377  1.00 60.29           C  
ATOM     27  CG  LEU A  -1      24.528  22.040  19.636  1.00 61.61           C  
ATOM     28  CD1 LEU A  -1      23.129  22.607  19.482  1.00 61.54           C  
ATOM     29  CD2 LEU A  -1      24.751  20.909  18.647  1.00 61.94           C  
ATOM     30  N   MET A   1      27.083  24.763  22.249  1.00 50.08           N  
ATOM     31  CA  MET A   1      27.730  24.414  23.508  1.00 45.89           C  
ATOM     32  C   MET A   1      27.185  25.077  24.772  1.00 41.12           C  
ATOM     33  O   MET A   1      27.636  24.759  25.869  1.00 42.42           O  
ATOM     34  CB  MET A   1      29.238  24.679  23.409  1.00 46.70           C  
ATOM     35  CG  MET A   1      29.935  23.917  22.287  1.00 47.86           C  
ATOM     36  SD  MET A   1      31.602  23.375  22.735  1.00 48.14           S  
ATOM     37  CE  MET A   1      32.574  24.842  22.383  1.00 47.75           C  
ATOM     38  N   THR A   2      26.222  25.980  24.631  1.00 35.40           N  
ATOM     39  CA  THR A   2      25.653  26.653  25.795  1.00 31.00           C  
ATOM     40  C   THR A   2      25.312  25.668  26.923  1.00 28.73           C  
ATOM     41  O   THR A   2      24.599  24.683  26.718  1.00 28.64           O  
ATOM     42  CB  THR A   2      24.401  27.474  25.401  1.00 31.10           C  
ATOM     43  OG1 THR A   2      24.802  28.579  24.583  1.00 31.24           O  
ATOM     44  CG2 THR A   2      23.686  28.013  26.627  1.00 29.57           C  
ATOM     45  N   ASN A   3      25.849  25.938  28.111  1.00 25.17           N  
ATOM     46  CA  ASN A   3      25.633  25.092  29.281  1.00 21.78           C  
ATOM     47  C   ASN A   3      25.871  25.901  30.553  1.00 23.16           C  
ATOM     48  O   ASN A   3      27.015  26.117  30.959  1.00 21.60           O  
ATOM     49  CB  ASN A   3      26.594  23.900  29.252  1.00 21.20           C  
ATOM     50  CG  ASN A   3      26.303  22.876  30.350  1.00 19.32           C  
ATOM     51  OD1 ASN A   3      25.746  23.209  31.401  1.00 17.83           O  
ATOM     52  ND2 ASN A   3      26.706  21.622  30.115  1.00 15.54           N  
ATOM     53  N   ARG A   4      24.795  26.350  31.186  1.00 22.30           N  
ATOM     54  CA  ARG A   4      24.934  27.112  32.407  1.00 21.84           C  
ATOM     55  C   ARG A   4      23.729  26.950  33.322  1.00 23.01           C  
ATOM     56  O   ARG A   4      22.585  27.147  32.909  1.00 20.89           O  
ATOM     57  CB  ARG A   4      25.147  28.589  32.105  1.00 23.23           C  
ATOM     58  CG  ARG A   4      25.129  29.455  33.346  1.00 28.44           C  
ATOM     59  CD  ARG A   4      26.422  30.225  33.487  1.00 37.23           C  
ATOM     60  NE  ARG A   4      26.178  31.615  33.876  1.00 42.45           N  
ATOM     61  CZ  ARG A   4      27.141  32.502  34.104  1.00 45.91           C  
ATOM     62  NH1 ARG A   4      26.828  33.741  34.453  1.00 45.50           N  
ATOM     63  NH2 ARG A   4      28.417  32.142  33.986  1.00 47.98           N  
ATOM     64  N   LEU A   5      24.006  26.586  34.570  1.00 20.73           N  
ATOM     65  CA  LEU A   5      22.980  26.399  35.577  1.00 21.73           C  
ATOM     66  C   LEU A   5      23.297  27.232  36.807  1.00 22.05           C  
ATOM     67  O   LEU A   5      24.444  27.273  37.264  1.00 22.97           O  
ATOM     68  CB  LEU A   5      22.877  24.918  35.981  1.00 23.17           C  
ATOM     69  CG  LEU A   5      22.068  24.664  37.264  1.00 22.37           C  
ATOM     70  CD1 LEU A   5      20.648  25.172  37.042  1.00 23.57           C  
ATOM     71  CD2 LEU A   5      22.057  23.182  37.633  1.00 21.87           C  
ATOM     72  N   VAL A   6      22.282  27.923  37.313  1.00 21.66           N  
ATOM     73  CA  VAL A   6      22.400  28.726  38.524  1.00 21.70           C  
ATOM     74  C   VAL A   6      21.303  28.158  39.422  1.00 21.41           C  
ATOM     75  O   VAL A   6      20.131  28.144  39.051  1.00 18.69           O  
ATOM     76  CB  VAL A   6      22.154  30.231  38.256  1.00 21.10           C  
ATOM     77  CG1 VAL A   6      22.351  31.025  39.547  1.00 24.44           C  
ATOM     78  CG2 VAL A   6      23.142  30.737  37.210  1.00 24.54           C  
ATOM     79  N   LEU A   7      21.695  27.674  40.592  1.00 19.88           N  
ATOM     80  CA  LEU A   7      20.747  27.068  41.503  1.00 22.92           C  
ATOM     81  C   LEU A   7      21.089  27.347  42.965  1.00 23.30           C  
ATOM     82  O   LEU A   7      22.233  27.168  43.403  1.00 26.67           O  
ATOM     83  CB  LEU A   7      20.713  25.557  41.248  1.00 21.13           C  
ATOM     84  CG  LEU A   7      19.703  24.647  41.956  1.00 20.28           C  
ATOM     85  CD1 LEU A   7      18.319  24.821  41.361  1.00 20.60           C  
ATOM     86  CD2 LEU A   7      20.165  23.201  41.780  1.00 21.26           C  
ATOM     87  N   SER A   8      20.086  27.803  43.704  1.00 22.59           N  
ATOM     88  CA  SER A   8      20.226  28.106  45.115  1.00 23.03           C  
ATOM     89  C   SER A   8      19.624  26.964  45.916  1.00 23.10           C  
ATOM     90  O   SER A   8      18.720  26.264  45.450  1.00 22.10           O  
ATOM     91  CB  SER A   8      19.495  29.409  45.455  1.00 23.93           C  
ATOM     92  OG  SER A   8      20.052  30.499  44.730  1.00 25.11           O  
ATOM     93  N   GLY A   9      20.142  26.764  47.120  1.00 21.93           N  
ATOM     94  CA  GLY A   9      19.631  25.703  47.960  1.00 21.99           C  
ATOM     95  C   GLY A   9      20.363  25.644  49.281  1.00 20.88           C  
ATOM     96  O   GLY A   9      21.141  26.534  49.620  1.00 19.57           O  
ATOM     97  N   THR A  10      20.104  24.576  50.020  1.00 21.56           N  
ATOM     98  CA  THR A  10      20.709  24.356  51.315  1.00 22.40           C  
ATOM     99  C   THR A  10      21.590  23.120  51.228  1.00 23.60           C  
ATOM    100  O   THR A  10      21.150  22.070  50.750  1.00 24.42           O  
ATOM    101  CB  THR A  10      19.631  24.125  52.387  1.00 23.65           C  
ATOM    102  OG1 THR A  10      18.749  25.253  52.415  1.00 23.87           O  
ATOM    103  CG2 THR A  10      20.261  23.946  53.758  1.00 18.11           C  
ATOM    104  N   VAL A  11      22.835  23.245  51.675  1.00 23.97           N  
ATOM    105  CA  VAL A  11      23.755  22.120  51.652  1.00 26.13           C  
ATOM    106  C   VAL A  11      23.233  21.106  52.672  1.00 28.62           C  
ATOM    107  O   VAL A  11      23.200  21.380  53.870  1.00 27.47           O  
ATOM    108  CB  VAL A  11      25.186  22.566  52.034  1.00 25.15           C  
ATOM    109  CG1 VAL A  11      26.135  21.380  51.975  1.00 22.30           C  
ATOM    110  CG2 VAL A  11      25.650  23.670  51.100  1.00 22.31           C  
ATOM    111  N   CYS A  12      22.812  19.943  52.184  1.00 32.86           N  
ATOM    112  CA  CYS A  12      22.268  18.898  53.046  1.00 38.12           C  
ATOM    113  C   CYS A  12      23.258  17.768  53.285  1.00 41.07           C  
ATOM    114  O   CYS A  12      23.038  16.905  54.136  1.00 42.89           O  
ATOM    115  CB  CYS A  12      20.967  18.343  52.443  1.00 40.41           C  
ATOM    116  SG  CYS A  12      21.059  17.886  50.678  1.00 40.05           S  
ATOM    117  N   ARG A  13      24.346  17.777  52.523  1.00 42.23           N  
ATOM    118  CA  ARG A  13      25.401  16.770  52.639  1.00 42.22           C  
ATOM    119  C   ARG A  13      26.692  17.546  52.905  1.00 41.62           C  
ATOM    120  O   ARG A  13      27.082  18.390  52.105  1.00 42.30           O  
ATOM    121  CB  ARG A  13      25.513  15.978  51.325  1.00 42.87           C  
ATOM    122  CG  ARG A  13      26.564  14.859  51.313  1.00 43.76           C  
ATOM    123  CD  ARG A  13      26.003  13.544  51.820  1.00 44.12           C  
ATOM    124  NE  ARG A  13      25.029  12.953  50.893  1.00 44.01           N  
ATOM    125  CZ  ARG A  13      25.342  12.228  49.818  1.00 42.38           C  
ATOM    126  NH1 ARG A  13      24.382  11.738  49.046  1.00 41.06           N  
ATOM    127  NH2 ARG A  13      26.611  11.984  49.520  1.00 42.76           N  
ATOM    128  N   ALA A  14      27.343  17.269  54.032  1.00 40.07           N  
ATOM    129  CA  ALA A  14      28.579  17.962  54.386  1.00 38.03           C  
ATOM    130  C   ALA A  14      29.631  17.843  53.283  1.00 37.25           C  
ATOM    131  O   ALA A  14      29.885  16.752  52.766  1.00 37.29           O  
ATOM    132  CB  ALA A  14      29.129  17.413  55.692  1.00 38.63           C  
ATOM    133  N   PRO A  15      30.255  18.973  52.913  1.00 36.28           N  
ATOM    134  CA  PRO A  15      31.287  19.065  51.874  1.00 37.09           C  
ATOM    135  C   PRO A  15      32.506  18.178  52.118  1.00 37.44           C  
ATOM    136  O   PRO A  15      33.330  18.479  52.973  1.00 38.96           O  
ATOM    137  CB  PRO A  15      31.652  20.550  51.882  1.00 36.85           C  
ATOM    138  CG  PRO A  15      30.384  21.209  52.338  1.00 36.59           C  
ATOM    139  CD  PRO A  15      29.951  20.306  53.459  1.00 36.12           C  
ATOM    140  N   LEU A  16      32.618  17.093  51.358  1.00 38.11           N  
ATOM    141  CA  LEU A  16      33.743  16.174  51.493  1.00 39.21           C  
ATOM    142  C   LEU A  16      34.803  16.419  50.428  1.00 39.73           C  
ATOM    143  O   LEU A  16      34.488  16.550  49.243  1.00 38.61           O  
ATOM    144  CB  LEU A  16      33.263  14.730  51.386  1.00 40.71           C  
ATOM    145  CG  LEU A  16      32.474  14.178  52.579  1.00 44.17           C  
ATOM    146  CD1 LEU A  16      31.806  12.870  52.193  1.00 45.15           C  
ATOM    147  CD2 LEU A  16      33.414  13.978  53.767  1.00 46.41           C  
ATOM    148  N   ARG A  17      36.060  16.468  50.848  1.00 38.93           N  
ATOM    149  CA  ARG A  17      37.144  16.685  49.905  1.00 40.91           C  
ATOM    150  C   ARG A  17      37.815  15.379  49.488  1.00 40.55           C  
ATOM    151  O   ARG A  17      38.211  14.577  50.329  1.00 40.95           O  
ATOM    152  CB  ARG A  17      38.191  17.637  50.495  1.00 41.73           C  
ATOM    153  CG  ARG A  17      39.397  17.830  49.590  1.00 45.44           C  
ATOM    154  CD  ARG A  17      40.197  19.078  49.935  1.00 49.19           C  
ATOM    155  NE  ARG A  17      39.413  20.301  49.745  1.00 51.40           N  
ATOM    156  CZ  ARG A  17      39.931  21.527  49.766  1.00 51.73           C  
ATOM    157  NH1 ARG A  17      41.237  21.692  49.965  1.00 51.71           N  
ATOM    158  NH2 ARG A  17      39.144  22.583  49.605  1.00 50.44           N  
ATOM    159  N   LYS A  18      37.925  15.165  48.182  1.00 39.97           N  
ATOM    160  CA  LYS A  18      38.572  13.971  47.653  1.00 39.94           C  
ATOM    161  C   LYS A  18      39.666  14.417  46.695  1.00 40.21           C  
ATOM    162  O   LYS A  18      39.602  15.509  46.134  1.00 39.84           O  
ATOM    163  CB  LYS A  18      37.578  13.084  46.905  1.00 40.61           C  
ATOM    164  CG  LYS A  18      36.493  12.487  47.771  1.00 43.22           C  
ATOM    165  CD  LYS A  18      35.526  11.676  46.936  1.00 45.73           C  
ATOM    166  CE  LYS A  18      34.386  11.136  47.783  1.00 47.49           C  
ATOM    167  NZ  LYS A  18      33.343  10.497  46.935  1.00 46.70           N  
ATOM    168  N   VAL A  19      40.668  13.567  46.514  1.00 39.98           N  
ATOM    169  CA  VAL A  19      41.778  13.880  45.629  1.00 39.22           C  
ATOM    170  C   VAL A  19      41.864  12.817  44.547  1.00 38.57           C  
ATOM    171  O   VAL A  19      41.831  11.617  44.835  1.00 39.31           O  
ATOM    172  CB  VAL A  19      43.100  13.927  46.408  1.00 39.61           C  
ATOM    173  CG1 VAL A  19      44.198  14.499  45.534  1.00 38.64           C  
ATOM    174  CG2 VAL A  19      42.927  14.772  47.667  1.00 40.39           C  
ATOM    175  N   SER A  20      41.963  13.267  43.302  1.00 35.63           N  
ATOM    176  CA  SER A  20      42.046  12.372  42.154  1.00 32.86           C  
ATOM    177  C   SER A  20      43.370  11.616  42.169  1.00 32.08           C  
ATOM    178  O   SER A  20      44.316  12.023  42.841  1.00 29.68           O  
ATOM    179  CB  SER A  20      41.958  13.176  40.855  1.00 31.78           C  
ATOM    180  OG  SER A  20      43.179  13.854  40.612  1.00 31.41           O  
ATOM    181  N   PRO A  21      43.456  10.507  41.416  1.00 31.59           N  
ATOM    182  CA  PRO A  21      44.703   9.738  41.379  1.00 31.45           C  
ATOM    183  C   PRO A  21      45.906  10.641  41.067  1.00 30.67           C  
ATOM    184  O   PRO A  21      46.983  10.455  41.624  1.00 29.94           O  
ATOM    185  CB  PRO A  21      44.428   8.702  40.286  1.00 32.67           C  
ATOM    186  CG  PRO A  21      42.948   8.445  40.452  1.00 32.30           C  
ATOM    187  CD  PRO A  21      42.408   9.851  40.611  1.00 32.54           C  
ATOM    188  N   SER A  22      45.711  11.628  40.197  1.00 30.75           N  
ATOM    189  CA  SER A  22      46.776  12.561  39.825  1.00 30.79           C  
ATOM    190  C   SER A  22      47.101  13.566  40.937  1.00 31.68           C  
ATOM    191  O   SER A  22      48.074  14.318  40.836  1.00 30.47           O  
ATOM    192  CB  SER A  22      46.388  13.340  38.565  1.00 30.34           C  
ATOM    193  OG  SER A  22      45.366  14.289  38.837  1.00 30.70           O  
ATOM    194  N   GLY A  23      46.276  13.596  41.980  1.00 30.76           N  
ATOM    195  CA  GLY A  23      46.525  14.520  43.075  1.00 32.80           C  
ATOM    196  C   GLY A  23      45.773  15.837  42.980  1.00 33.75           C  
ATOM    197  O   GLY A  23      46.138  16.818  43.635  1.00 34.56           O  
ATOM    198  N   ILE A  24      44.723  15.862  42.164  1.00 31.88           N  
ATOM    199  CA  ILE A  24      43.906  17.059  41.993  1.00 31.52           C  
ATOM    200  C   ILE A  24      42.794  17.073  43.044  1.00 30.55           C  
ATOM    201  O   ILE A  24      42.022  16.118  43.158  1.00 29.83           O  
ATOM    202  CB  ILE A  24      43.240  17.092  40.601  1.00 31.73           C  
ATOM    203  CG1 ILE A  24      44.304  17.057  39.499  1.00 32.72           C  
ATOM    204  CG2 ILE A  24      42.374  18.338  40.477  1.00 31.26           C  
ATOM    205  CD1 ILE A  24      45.177  18.295  39.427  1.00 32.93           C  
ATOM    206  N   PRO A  25      42.690  18.162  43.820  1.00 29.24           N  
ATOM    207  CA  PRO A  25      41.657  18.266  44.855  1.00 28.31           C  
ATOM    208  C   PRO A  25      40.254  18.546  44.304  1.00 28.22           C  
ATOM    209  O   PRO A  25      40.102  19.241  43.302  1.00 26.25           O  
ATOM    210  CB  PRO A  25      42.173  19.405  45.732  1.00 29.88           C  
ATOM    211  CG  PRO A  25      42.808  20.316  44.723  1.00 27.96           C  
ATOM    212  CD  PRO A  25      43.564  19.351  43.826  1.00 28.05           C  
ATOM    213  N   HIS A  26      39.245  17.980  44.962  1.00 26.51           N  
ATOM    214  CA  HIS A  26      37.845  18.165  44.598  1.00 25.77           C  
ATOM    215  C   HIS A  26      37.000  18.270  45.862  1.00 26.88           C  
ATOM    216  O   HIS A  26      37.314  17.664  46.892  1.00 26.07           O  
ATOM    217  CB  HIS A  26      37.301  16.988  43.784  1.00 25.19           C  
ATOM    218  CG  HIS A  26      37.910  16.855  42.428  1.00 26.58           C  
ATOM    219  ND1 HIS A  26      39.112  16.217  42.212  1.00 23.99           N  
ATOM    220  CD2 HIS A  26      37.506  17.319  41.224  1.00 24.54           C  
ATOM    221  CE1 HIS A  26      39.424  16.296  40.931  1.00 26.17           C  
ATOM    222  NE2 HIS A  26      38.466  16.961  40.309  1.00 26.22           N  
ATOM    223  N   CYS A  27      35.920  19.034  45.777  1.00 25.81           N  
ATOM    224  CA  CYS A  27      35.016  19.178  46.907  1.00 25.73           C  
ATOM    225  C   CYS A  27      33.641  18.767  46.416  1.00 25.30           C  
ATOM    226  O   CYS A  27      33.155  19.292  45.421  1.00 25.70           O  
ATOM    227  CB  CYS A  27      34.973  20.623  47.390  1.00 24.49           C  
ATOM    228  SG  CYS A  27      33.840  20.843  48.801  1.00 30.71           S  
ATOM    229  N   GLN A  28      33.030  17.824  47.118  1.00 25.39           N  
ATOM    230  CA  GLN A  28      31.715  17.320  46.764  1.00 25.19           C  
ATOM    231  C   GLN A  28      30.686  17.489  47.865  1.00 24.94           C  
ATOM    232  O   GLN A  28      30.995  17.322  49.042  1.00 23.55           O  
ATOM    233  CB  GLN A  28      31.796  15.832  46.429  1.00 25.53           C  
ATOM    234  CG  GLN A  28      32.511  15.513  45.141  1.00 27.51           C  
ATOM    235  CD  GLN A  28      32.638  14.018  44.919  1.00 29.31           C  
ATOM    236  OE1 GLN A  28      33.401  13.326  45.608  1.00 29.73           O  
ATOM    237  NE2 GLN A  28      31.883  13.507  43.963  1.00 29.93           N  
ATOM    238  N   PHE A  29      29.460  17.825  47.472  1.00 23.43           N  
ATOM    239  CA  PHE A  29      28.352  17.956  48.408  1.00 22.91           C  
ATOM    240  C   PHE A  29      27.054  17.902  47.618  1.00 23.01           C  
ATOM    241  O   PHE A  29      27.072  17.850  46.386  1.00 24.25           O  
ATOM    242  CB  PHE A  29      28.431  19.252  49.240  1.00 24.16           C  
ATOM    243  CG  PHE A  29      28.394  20.519  48.432  1.00 23.61           C  
ATOM    244  CD1 PHE A  29      29.559  21.037  47.878  1.00 23.51           C  
ATOM    245  CD2 PHE A  29      27.194  21.200  48.236  1.00 22.85           C  
ATOM    246  CE1 PHE A  29      29.536  22.223  47.135  1.00 22.55           C  
ATOM    247  CE2 PHE A  29      27.157  22.385  47.494  1.00 23.38           C  
ATOM    248  CZ  PHE A  29      28.331  22.899  46.943  1.00 22.16           C  
ATOM    249  N   VAL A  30      25.934  17.877  48.321  1.00 22.28           N  
ATOM    250  CA  VAL A  30      24.633  17.825  47.679  1.00 21.19           C  
ATOM    251  C   VAL A  30      23.889  19.077  48.087  1.00 22.77           C  
ATOM    252  O   VAL A  30      23.944  19.497  49.246  1.00 20.29           O  
ATOM    253  CB  VAL A  30      23.838  16.567  48.115  1.00 22.80           C  
ATOM    254  CG1 VAL A  30      22.431  16.591  47.509  1.00 22.43           C  
ATOM    255  CG2 VAL A  30      24.578  15.319  47.669  1.00 20.36           C  
ATOM    256  N   LEU A  31      23.213  19.686  47.123  1.00 22.14           N  
ATOM    257  CA  LEU A  31      22.473  20.917  47.369  1.00 21.92           C  
ATOM    258  C   LEU A  31      20.977  20.660  47.286  1.00 21.94           C  
ATOM    259  O   LEU A  31      20.482  20.215  46.258  1.00 20.87           O  
ATOM    260  CB  LEU A  31      22.867  21.968  46.322  1.00 22.02           C  
ATOM    261  CG  LEU A  31      22.293  23.371  46.474  1.00 23.43           C  
ATOM    262  CD1 LEU A  31      22.950  24.040  47.666  1.00 21.77           C  
ATOM    263  CD2 LEU A  31      22.537  24.175  45.206  1.00 22.85           C  
ATOM    264  N   GLU A  32      20.255  20.927  48.364  1.00 22.00           N  
ATOM    265  CA  GLU A  32      18.823  20.717  48.324  1.00 23.92           C  
ATOM    266  C   GLU A  32      18.102  21.996  47.907  1.00 24.19           C  
ATOM    267  O   GLU A  32      18.132  23.003  48.624  1.00 25.27           O  
ATOM    268  CB  GLU A  32      18.282  20.245  49.668  1.00 24.84           C  
ATOM    269  CG  GLU A  32      16.767  20.163  49.653  1.00 29.34           C  
ATOM    270  CD  GLU A  32      16.199  19.317  50.770  1.00 33.55           C  
ATOM    271  OE1 GLU A  32      16.418  19.659  51.952  1.00 35.57           O  
ATOM    272  OE2 GLU A  32      15.527  18.310  50.450  1.00 35.84           O  
ATOM    273  N   HIS A  33      17.470  21.935  46.734  1.00 23.38           N  
ATOM    274  CA  HIS A  33      16.725  23.042  46.143  1.00 23.30           C  
ATOM    275  C   HIS A  33      15.216  22.875  46.241  1.00 24.37           C  
ATOM    276  O   HIS A  33      14.680  21.835  45.873  1.00 24.09           O  
ATOM    277  CB  HIS A  33      17.046  23.194  44.655  1.00 23.44           C  
ATOM    278  CG  HIS A  33      16.172  24.200  43.974  1.00 24.08           C  
ATOM    279  ND1 HIS A  33      16.407  25.554  44.043  1.00 24.04           N  
ATOM    280  CD2 HIS A  33      14.999  24.057  43.307  1.00 25.60           C  
ATOM    281  CE1 HIS A  33      15.423  26.204  43.452  1.00 24.25           C  
ATOM    282  NE2 HIS A  33      14.554  25.322  42.999  1.00 23.03           N  
ATOM    283  N   ARG A  34      14.534  23.928  46.682  1.00 24.46           N  
ATOM    284  CA  ARG A  34      13.078  23.916  46.819  1.00 26.52           C  
ATOM    285  C   ARG A  34      12.539  25.306  46.482  1.00 25.64           C  
ATOM    286  O   ARG A  34      12.868  26.277  47.153  1.00 22.73           O  
ATOM    287  CB  ARG A  34      12.692  23.553  48.260  1.00 29.56           C  
ATOM    288  CG  ARG A  34      11.220  23.787  48.605  1.00 34.60           C  
ATOM    289  CD  ARG A  34      10.322  22.671  48.094  1.00 37.76           C  
ATOM    290  NE  ARG A  34      10.470  21.437  48.872  1.00 41.13           N  
ATOM    291  CZ  ARG A  34       9.938  20.270  48.522  1.00 42.70           C  
ATOM    292  NH1 ARG A  34      10.124  19.203  49.285  1.00 42.59           N  
ATOM    293  NH2 ARG A  34       9.228  20.170  47.401  1.00 42.86           N  
ATOM    294  N   SER A  35      11.710  25.412  45.453  1.00 24.66           N  
ATOM    295  CA  SER A  35      11.177  26.720  45.094  1.00 24.90           C  
ATOM    296  C   SER A  35       9.930  26.613  44.243  1.00 23.51           C  
ATOM    297  O   SER A  35       9.439  25.525  43.956  1.00 22.82           O  
ATOM    298  CB  SER A  35      12.224  27.533  44.310  1.00 22.76           C  
ATOM    299  OG  SER A  35      12.322  27.047  42.973  1.00 22.20           O  
ATOM    300  N   VAL A  36       9.430  27.775  43.849  1.00 23.46           N  
ATOM    301  CA  VAL A  36       8.274  27.866  42.985  1.00 24.50           C  
ATOM    302  C   VAL A  36       8.753  28.678  41.793  1.00 24.59           C  
ATOM    303  O   VAL A  36       9.250  29.787  41.960  1.00 25.07           O  
ATOM    304  CB  VAL A  36       7.111  28.597  43.670  1.00 26.15           C  
ATOM    305  CG1 VAL A  36       5.986  28.804  42.675  1.00 27.87           C  
ATOM    306  CG2 VAL A  36       6.608  27.778  44.863  1.00 24.63           C  
ATOM    307  N   GLN A  37       8.633  28.120  40.595  1.00 25.38           N  
ATOM    308  CA  GLN A  37       9.071  28.814  39.394  1.00 26.15           C  
ATOM    309  C   GLN A  37       7.905  29.121  38.464  1.00 28.24           C  
ATOM    310  O   GLN A  37       6.830  28.516  38.547  1.00 26.97           O  
ATOM    311  CB  GLN A  37      10.091  27.970  38.623  1.00 25.50           C  
ATOM    312  CG  GLN A  37      11.341  27.573  39.388  1.00 23.15           C  
ATOM    313  CD  GLN A  37      12.215  28.752  39.741  1.00 23.05           C  
ATOM    314  OE1 GLN A  37      12.448  29.639  38.917  1.00 26.44           O  
ATOM    315  NE2 GLN A  37      12.723  28.761  40.963  1.00 23.20           N  
ATOM    316  N   GLU A  38       8.148  30.065  37.566  1.00 29.21           N  
ATOM    317  CA  GLU A  38       7.162  30.484  36.590  1.00 31.71           C  
ATOM    318  C   GLU A  38       7.110  29.503  35.431  1.00 31.81           C  
ATOM    319  O   GLU A  38       8.131  29.200  34.813  1.00 32.51           O  
ATOM    320  CB  GLU A  38       7.520  31.863  36.045  1.00 34.80           C  
ATOM    321  CG  GLU A  38       7.248  33.009  36.994  1.00 38.81           C  
ATOM    322  CD  GLU A  38       6.085  33.844  36.536  1.00 41.08           C  
ATOM    323  OE1 GLU A  38       5.802  34.887  37.178  1.00 43.36           O  
ATOM    324  OE2 GLU A  38       5.446  33.458  35.530  1.00 43.00           O  
ATOM    325  N   GLU A  39       5.918  29.006  35.131  1.00 30.91           N  
ATOM    326  CA  GLU A  39       5.764  28.086  34.022  1.00 28.95           C  
ATOM    327  C   GLU A  39       4.466  28.344  33.271  1.00 28.54           C  
ATOM    328  O   GLU A  39       3.374  28.183  33.812  1.00 28.36           O  
ATOM    329  CB  GLU A  39       5.809  26.649  34.512  1.00 28.52           C  
ATOM    330  CG  GLU A  39       5.724  25.653  33.387  1.00 30.93           C  
ATOM    331  CD  GLU A  39       5.856  24.237  33.868  1.00 32.83           C  
ATOM    332  OE1 GLU A  39       5.029  23.816  34.707  1.00 33.47           O  
ATOM    333  OE2 GLU A  39       6.787  23.547  33.400  1.00 31.80           O  
ATOM    334  N   ALA A  40       4.607  28.746  32.011  1.00 27.34           N  
ATOM    335  CA  ALA A  40       3.477  29.050  31.142  1.00 27.88           C  
ATOM    336  C   ALA A  40       2.515  30.056  31.776  1.00 26.18           C  
ATOM    337  O   ALA A  40       1.325  30.045  31.481  1.00 27.02           O  
ATOM    338  CB  ALA A  40       2.740  27.767  30.775  1.00 26.47           C  
ATOM    339  N   GLY A  41       3.037  30.918  32.644  1.00 24.14           N  
ATOM    340  CA  GLY A  41       2.204  31.927  33.281  1.00 24.13           C  
ATOM    341  C   GLY A  41       1.720  31.515  34.661  1.00 24.20           C  
ATOM    342  O   GLY A  41       1.217  32.339  35.420  1.00 22.71           O  
ATOM    343  N   PHE A  42       1.864  30.237  34.988  1.00 22.79           N  
ATOM    344  CA  PHE A  42       1.439  29.744  36.288  1.00 25.35           C  
ATOM    345  C   PHE A  42       2.625  29.461  37.202  1.00 25.79           C  
ATOM    346  O   PHE A  42       3.778  29.625  36.801  1.00 27.68           O  
ATOM    347  CB  PHE A  42       0.578  28.493  36.108  1.00 23.70           C  
ATOM    348  CG  PHE A  42      -0.772  28.780  35.531  1.00 22.27           C  
ATOM    349  CD1 PHE A  42      -0.972  28.766  34.153  1.00 21.76           C  
ATOM    350  CD2 PHE A  42      -1.828  29.149  36.364  1.00 21.84           C  
ATOM    351  CE1 PHE A  42      -2.206  29.114  33.608  1.00 22.41           C  
ATOM    352  CE2 PHE A  42      -3.068  29.501  35.832  1.00 21.72           C  
ATOM    353  CZ  PHE A  42      -3.260  29.489  34.456  1.00 21.14           C  
ATOM    354  N   HIS A  43       2.340  29.049  38.430  1.00 26.08           N  
ATOM    355  CA  HIS A  43       3.395  28.764  39.398  1.00 27.95           C  
ATOM    356  C   HIS A  43       3.576  27.273  39.625  1.00 28.15           C  
ATOM    357  O   HIS A  43       2.654  26.578  40.044  1.00 27.36           O  
ATOM    358  CB  HIS A  43       3.094  29.463  40.723  1.00 29.16           C  
ATOM    359  CG  HIS A  43       3.189  30.956  40.647  1.00 29.06           C  
ATOM    360  ND1 HIS A  43       3.012  31.765  41.749  1.00 27.53           N  
ATOM    361  CD2 HIS A  43       3.436  31.784  39.605  1.00 29.19           C  
ATOM    362  CE1 HIS A  43       3.145  33.031  41.387  1.00 30.31           C  
ATOM    363  NE2 HIS A  43       3.401  33.070  40.092  1.00 31.61           N  
ATOM    364  N   ARG A  44       4.783  26.791  39.356  1.00 28.73           N  
ATOM    365  CA  ARG A  44       5.103  25.377  39.497  1.00 28.28           C  
ATOM    366  C   ARG A  44       6.161  25.142  40.573  1.00 27.27           C  
ATOM    367  O   ARG A  44       7.183  25.820  40.604  1.00 24.60           O  
ATOM    368  CB  ARG A  44       5.590  24.850  38.146  1.00 31.78           C  
ATOM    369  CG  ARG A  44       6.027  23.391  38.112  1.00 32.95           C  
ATOM    370  CD  ARG A  44       4.876  22.454  38.404  1.00 36.32           C  
ATOM    371  NE  ARG A  44       5.238  21.055  38.184  1.00 40.55           N  
ATOM    372  CZ  ARG A  44       5.493  20.532  36.990  1.00 43.69           C  
ATOM    373  NH1 ARG A  44       5.813  19.251  36.883  1.00 45.18           N  
ATOM    374  NH2 ARG A  44       5.428  21.288  35.899  1.00 44.81           N  
ATOM    375  N   GLN A  45       5.907  24.189  41.466  1.00 27.67           N  
ATOM    376  CA  GLN A  45       6.878  23.885  42.505  1.00 28.88           C  
ATOM    377  C   GLN A  45       8.027  23.104  41.880  1.00 28.13           C  
ATOM    378  O   GLN A  45       7.805  22.230  41.052  1.00 26.12           O  
ATOM    379  CB  GLN A  45       6.245  23.058  43.623  1.00 31.81           C  
ATOM    380  CG  GLN A  45       5.111  23.765  44.338  1.00 35.81           C  
ATOM    381  CD  GLN A  45       4.472  22.898  45.399  1.00 39.19           C  
ATOM    382  OE1 GLN A  45       4.343  21.684  45.229  1.00 41.01           O  
ATOM    383  NE2 GLN A  45       4.053  23.516  46.491  1.00 40.40           N  
ATOM    384  N   ALA A  46       9.254  23.431  42.268  1.00 27.79           N  
ATOM    385  CA  ALA A  46      10.419  22.741  41.739  1.00 28.28           C  
ATOM    386  C   ALA A  46      11.273  22.261  42.898  1.00 29.37           C  
ATOM    387  O   ALA A  46      11.589  23.029  43.808  1.00 29.84           O  
ATOM    388  CB  ALA A  46      11.224  23.670  40.843  1.00 28.97           C  
ATOM    389  N   TRP A  47      11.638  20.985  42.870  1.00 28.66           N  
ATOM    390  CA  TRP A  47      12.451  20.413  43.930  1.00 30.10           C  
ATOM    391  C   TRP A  47      13.564  19.558  43.346  1.00 29.26           C  
ATOM    392  O   TRP A  47      13.379  18.857  42.346  1.00 27.87           O  
ATOM    393  CB  TRP A  47      11.593  19.550  44.860  1.00 31.81           C  
ATOM    394  CG  TRP A  47      12.407  18.795  45.870  1.00 36.15           C  
ATOM    395  CD1 TRP A  47      13.002  19.300  46.994  1.00 36.23           C  
ATOM    396  CD2 TRP A  47      12.764  17.406  45.818  1.00 37.89           C  
ATOM    397  NE1 TRP A  47      13.707  18.308  47.643  1.00 38.91           N  
ATOM    398  CE2 TRP A  47      13.574  17.138  46.944  1.00 37.66           C  
ATOM    399  CE3 TRP A  47      12.472  16.361  44.930  1.00 39.67           C  
ATOM    400  CZ2 TRP A  47      14.104  15.870  47.201  1.00 40.54           C  
ATOM    401  CZ3 TRP A  47      12.998  15.097  45.185  1.00 41.41           C  
ATOM    402  CH2 TRP A  47      13.803  14.862  46.315  1.00 41.29           C  
ATOM    403  N   CYS A  48      14.727  19.610  43.975  1.00 28.64           N  
ATOM    404  CA  CYS A  48      15.828  18.807  43.496  1.00 31.33           C  
ATOM    405  C   CYS A  48      16.988  18.724  44.475  1.00 29.81           C  
ATOM    406  O   CYS A  48      17.317  19.693  45.159  1.00 28.53           O  
ATOM    407  CB  CYS A  48      16.334  19.355  42.157  1.00 35.65           C  
ATOM    408  SG  CYS A  48      17.487  18.205  41.349  1.00 45.31           S  
ATOM    409  N   GLN A  49      17.580  17.538  44.562  1.00 27.79           N  
ATOM    410  CA  GLN A  49      18.747  17.340  45.399  1.00 26.87           C  
ATOM    411  C   GLN A  49      19.825  17.209  44.347  1.00 26.99           C  
ATOM    412  O   GLN A  49      19.947  16.185  43.663  1.00 23.27           O  
ATOM    413  CB  GLN A  49      18.645  16.066  46.230  1.00 29.63           C  
ATOM    414  CG  GLN A  49      17.505  16.085  47.218  1.00 32.92           C  
ATOM    415  CD  GLN A  49      17.709  15.103  48.352  1.00 35.65           C  
ATOM    416  OE1 GLN A  49      18.057  13.941  48.128  1.00 37.23           O  
ATOM    417  NE2 GLN A  49      17.489  15.564  49.584  1.00 35.84           N  
ATOM    418  N   MET A  50      20.583  18.285  44.205  1.00 24.26           N  
ATOM    419  CA  MET A  50      21.619  18.370  43.203  1.00 23.76           C  
ATOM    420  C   MET A  50      23.034  18.164  43.721  1.00 21.97           C  
ATOM    421  O   MET A  50      23.530  18.932  44.536  1.00 21.98           O  
ATOM    422  CB  MET A  50      21.515  19.736  42.504  1.00 24.60           C  
ATOM    423  CG  MET A  50      22.593  20.046  41.474  1.00 23.44           C  
ATOM    424  SD  MET A  50      22.565  18.946  40.063  1.00 25.83           S  
ATOM    425  CE  MET A  50      21.054  19.435  39.247  1.00 25.11           C  
ATOM    426  N   PRO A  51      23.694  17.096  43.269  1.00 22.40           N  
ATOM    427  CA  PRO A  51      25.061  16.901  43.745  1.00 23.07           C  
ATOM    428  C   PRO A  51      25.919  17.963  43.055  1.00 22.93           C  
ATOM    429  O   PRO A  51      25.690  18.313  41.893  1.00 25.09           O  
ATOM    430  CB  PRO A  51      25.392  15.461  43.323  1.00 22.33           C  
ATOM    431  CG  PRO A  51      24.436  15.142  42.242  1.00 23.33           C  
ATOM    432  CD  PRO A  51      23.181  15.914  42.556  1.00 23.05           C  
ATOM    433  N   VAL A  52      26.883  18.488  43.792  1.00 22.53           N  
ATOM    434  CA  VAL A  52      27.759  19.519  43.276  1.00 21.07           C  
ATOM    435  C   VAL A  52      29.214  19.125  43.494  1.00 22.96           C  
ATOM    436  O   VAL A  52      29.553  18.410  44.444  1.00 20.10           O  
ATOM    437  CB  VAL A  52      27.505  20.865  44.002  1.00 20.06           C  
ATOM    438  CG1 VAL A  52      28.495  21.917  43.544  1.00 17.70           C  
ATOM    439  CG2 VAL A  52      26.077  21.325  43.761  1.00 18.87           C  
ATOM    440  N   ILE A  53      30.073  19.601  42.604  1.00 22.74           N  
ATOM    441  CA  ILE A  53      31.486  19.323  42.709  1.00 22.04           C  
ATOM    442  C   ILE A  53      32.272  20.574  42.320  1.00 23.66           C  
ATOM    443  O   ILE A  53      31.910  21.271  41.372  1.00 21.49           O  
ATOM    444  CB  ILE A  53      31.862  18.140  41.795  1.00 24.60           C  
ATOM    445  CG1 ILE A  53      33.357  17.829  41.935  1.00 25.15           C  
ATOM    446  CG2 ILE A  53      31.497  18.457  40.345  1.00 25.27           C  
ATOM    447  CD1 ILE A  53      33.763  16.508  41.303  1.00 24.19           C  
ATOM    448  N   VAL A  54      33.321  20.868  43.088  1.00 23.52           N  
ATOM    449  CA  VAL A  54      34.204  22.003  42.843  1.00 23.84           C  
ATOM    450  C   VAL A  54      35.567  21.376  42.579  1.00 25.99           C  
ATOM    451  O   VAL A  54      36.199  20.853  43.494  1.00 27.13           O  
ATOM    452  CB  VAL A  54      34.306  22.930  44.091  1.00 26.06           C  
ATOM    453  CG1 VAL A  54      35.196  24.130  43.785  1.00 24.25           C  
ATOM    454  CG2 VAL A  54      32.924  23.389  44.516  1.00 22.36           C  
ATOM    455  N   SER A  55      36.012  21.420  41.326  1.00 27.84           N  
ATOM    456  CA  SER A  55      37.279  20.805  40.919  1.00 27.50           C  
ATOM    457  C   SER A  55      38.454  21.774  40.743  1.00 28.08           C  
ATOM    458  O   SER A  55      38.289  22.875  40.227  1.00 25.82           O  
ATOM    459  CB  SER A  55      37.040  20.046  39.609  1.00 28.73           C  
ATOM    460  OG  SER A  55      38.269  19.660  38.997  1.00 32.98           O  
ATOM    461  N   GLY A  56      39.639  21.355  41.172  1.00 30.04           N  
ATOM    462  CA  GLY A  56      40.805  22.202  41.026  1.00 31.55           C  
ATOM    463  C   GLY A  56      41.262  22.864  42.306  1.00 33.49           C  
ATOM    464  O   GLY A  56      40.454  23.185  43.180  1.00 33.85           O  
ATOM    465  N   HIS A  57      42.570  23.076  42.408  1.00 34.03           N  
ATOM    466  CA  HIS A  57      43.162  23.693  43.583  1.00 35.89           C  
ATOM    467  C   HIS A  57      42.633  25.092  43.868  1.00 36.84           C  
ATOM    468  O   HIS A  57      42.075  25.348  44.933  1.00 36.30           O  
ATOM    469  CB  HIS A  57      44.679  23.773  43.436  1.00 38.72           C  
ATOM    470  CG  HIS A  57      45.322  24.691  44.429  1.00 42.50           C  
ATOM    471  ND1 HIS A  57      45.370  24.412  45.779  1.00 43.74           N  
ATOM    472  CD2 HIS A  57      45.888  25.912  44.279  1.00 43.68           C  
ATOM    473  CE1 HIS A  57      45.936  25.421  46.416  1.00 45.74           C  
ATOM    474  NE2 HIS A  57      46.259  26.345  45.529  1.00 45.68           N  
ATOM    475  N   GLU A  58      42.822  26.001  42.917  1.00 36.90           N  
ATOM    476  CA  GLU A  58      42.378  27.367  43.117  1.00 37.75           C  
ATOM    477  C   GLU A  58      40.879  27.483  43.329  1.00 37.18           C  
ATOM    478  O   GLU A  58      40.414  28.376  44.042  1.00 37.68           O  
ATOM    479  CB  GLU A  58      42.810  28.249  41.946  1.00 40.23           C  
ATOM    480  CG  GLU A  58      42.226  27.876  40.604  1.00 44.18           C  
ATOM    481  CD  GLU A  58      42.586  28.893  39.534  1.00 47.74           C  
ATOM    482  OE1 GLU A  58      42.123  28.739  38.378  1.00 49.87           O  
ATOM    483  OE2 GLU A  58      43.333  29.848  39.854  1.00 48.31           O  
ATOM    484  N   ASN A  59      40.122  26.574  42.727  1.00 35.02           N  
ATOM    485  CA  ASN A  59      38.669  26.589  42.863  1.00 34.54           C  
ATOM    486  C   ASN A  59      38.229  26.236  44.287  1.00 31.99           C  
ATOM    487  O   ASN A  59      37.138  26.609  44.714  1.00 29.32           O  
ATOM    488  CB  ASN A  59      38.041  25.612  41.871  1.00 35.07           C  
ATOM    489  CG  ASN A  59      37.361  26.317  40.706  1.00 37.53           C  
ATOM    490  OD1 ASN A  59      37.834  27.352  40.219  1.00 38.19           O  
ATOM    491  ND2 ASN A  59      36.256  25.751  40.242  1.00 38.78           N  
ATOM    492  N   GLN A  60      39.085  25.531  45.020  1.00 30.03           N  
ATOM    493  CA  GLN A  60      38.772  25.128  46.383  1.00 30.69           C  
ATOM    494  C   GLN A  60      38.504  26.321  47.294  1.00 32.13           C  
ATOM    495  O   GLN A  60      37.827  26.202  48.327  1.00 31.59           O  
ATOM    496  CB  GLN A  60      39.907  24.283  46.952  1.00 30.21           C  
ATOM    497  CG  GLN A  60      40.171  23.035  46.138  1.00 28.19           C  
ATOM    498  CD  GLN A  60      38.906  22.232  45.904  1.00 27.22           C  
ATOM    499  OE1 GLN A  60      38.264  21.778  46.854  1.00 24.13           O  
ATOM    500  NE2 GLN A  60      38.540  22.055  44.635  1.00 24.19           N  
ATOM    501  N   ALA A  61      39.028  27.474  46.898  1.00 31.65           N  
ATOM    502  CA  ALA A  61      38.864  28.705  47.660  1.00 32.94           C  
ATOM    503  C   ALA A  61      37.408  29.101  47.892  1.00 32.68           C  
ATOM    504  O   ALA A  61      37.088  29.736  48.894  1.00 33.14           O  
ATOM    505  CB  ALA A  61      39.583  29.834  46.950  1.00 33.07           C  
ATOM    506  N   ILE A  62      36.526  28.726  46.970  1.00 31.26           N  
ATOM    507  CA  ILE A  62      35.119  29.088  47.095  1.00 30.42           C  
ATOM    508  C   ILE A  62      34.277  28.141  47.950  1.00 29.02           C  
ATOM    509  O   ILE A  62      33.065  28.292  48.030  1.00 28.06           O  
ATOM    510  CB  ILE A  62      34.454  29.210  45.701  1.00 31.59           C  
ATOM    511  CG1 ILE A  62      34.332  27.837  45.039  1.00 30.96           C  
ATOM    512  CG2 ILE A  62      35.287  30.126  44.816  1.00 31.90           C  
ATOM    513  CD1 ILE A  62      33.554  27.857  43.734  1.00 32.66           C  
ATOM    514  N   THR A  63      34.912  27.182  48.605  1.00 30.17           N  
ATOM    515  CA  THR A  63      34.170  26.221  49.411  1.00 30.70           C  
ATOM    516  C   THR A  63      34.613  26.205  50.861  1.00 31.51           C  
ATOM    517  O   THR A  63      34.119  25.410  51.659  1.00 33.05           O  
ATOM    518  CB  THR A  63      34.381  24.807  48.888  1.00 29.74           C  
ATOM    519  OG1 THR A  63      35.746  24.422  49.114  1.00 31.09           O  
ATOM    520  CG2 THR A  63      34.077  24.745  47.406  1.00 31.21           C  
ATOM    521  N   HIS A  64      35.544  27.077  51.205  1.00 31.74           N  
ATOM    522  CA  HIS A  64      36.071  27.090  52.558  1.00 31.38           C  
ATOM    523  C   HIS A  64      35.139  27.529  53.669  1.00 30.43           C  
ATOM    524  O   HIS A  64      35.437  27.310  54.840  1.00 28.69           O  
ATOM    525  CB  HIS A  64      37.354  27.923  52.597  1.00 31.84           C  
ATOM    526  CG  HIS A  64      38.490  27.303  51.846  1.00 32.23           C  
ATOM    527  ND1 HIS A  64      38.678  25.938  51.779  1.00 33.52           N  
ATOM    528  CD2 HIS A  64      39.519  27.857  51.166  1.00 32.03           C  
ATOM    529  CE1 HIS A  64      39.777  25.679  51.093  1.00 32.47           C  
ATOM    530  NE2 HIS A  64      40.306  26.826  50.711  1.00 32.47           N  
ATOM    531  N   SER A  65      34.008  28.133  53.330  1.00 29.47           N  
ATOM    532  CA  SER A  65      33.111  28.573  54.386  1.00 29.69           C  
ATOM    533  C   SER A  65      31.800  27.823  54.424  1.00 29.15           C  
ATOM    534  O   SER A  65      30.949  28.119  55.248  1.00 30.56           O  
ATOM    535  CB  SER A  65      32.826  30.065  54.258  1.00 30.90           C  
ATOM    536  OG  SER A  65      32.103  30.328  53.076  1.00 36.25           O  
ATOM    537  N   ILE A  66      31.628  26.842  53.552  1.00 28.41           N  
ATOM    538  CA  ILE A  66      30.372  26.116  53.551  1.00 28.49           C  
ATOM    539  C   ILE A  66      30.374  24.873  54.442  1.00 27.46           C  
ATOM    540  O   ILE A  66      31.402  24.228  54.618  1.00 27.00           O  
ATOM    541  CB  ILE A  66      29.978  25.680  52.124  1.00 30.55           C  
ATOM    542  CG1 ILE A  66      31.026  24.718  51.572  1.00 30.17           C  
ATOM    543  CG2 ILE A  66      29.854  26.894  51.230  1.00 31.06           C  
ATOM    544  CD1 ILE A  66      30.636  24.097  50.252  1.00 33.73           C  
ATOM    545  N   THR A  67      29.214  24.570  55.021  1.00 26.74           N  
ATOM    546  CA  THR A  67      29.021  23.381  55.850  1.00 26.71           C  
ATOM    547  C   THR A  67      27.567  22.952  55.672  1.00 25.82           C  
ATOM    548  O   THR A  67      26.815  23.572  54.922  1.00 26.31           O  
ATOM    549  CB  THR A  67      29.247  23.637  57.380  1.00 27.89           C  
ATOM    550  OG1 THR A  67      28.487  24.782  57.809  1.00 27.47           O  
ATOM    551  CG2 THR A  67      30.706  23.844  57.682  1.00 27.07           C  
ATOM    552  N   VAL A  68      27.178  21.883  56.355  1.00 25.85           N  
ATOM    553  CA  VAL A  68      25.806  21.403  56.282  1.00 25.78           C  
ATOM    554  C   VAL A  68      24.945  22.564  56.780  1.00 24.83           C  
ATOM    555  O   VAL A  68      25.325  23.269  57.719  1.00 25.03           O  
ATOM    556  CB  VAL A  68      25.611  20.183  57.196  1.00 28.07           C  
ATOM    557  CG1 VAL A  68      26.202  20.476  58.564  1.00 28.42           C  
ATOM    558  CG2 VAL A  68      24.131  19.841  57.328  1.00 27.72           C  
ATOM    559  N   GLY A  69      23.802  22.789  56.146  1.00 22.97           N  
ATOM    560  CA  GLY A  69      22.953  23.886  56.580  1.00 20.83           C  
ATOM    561  C   GLY A  69      23.191  25.206  55.874  1.00 20.44           C  
ATOM    562  O   GLY A  69      22.319  26.073  55.877  1.00 20.93           O  
ATOM    563  N   SER A  70      24.365  25.373  55.268  1.00 20.44           N  
ATOM    564  CA  SER A  70      24.685  26.614  54.556  1.00 21.27           C  
ATOM    565  C   SER A  70      23.715  26.851  53.403  1.00 20.80           C  
ATOM    566  O   SER A  70      23.398  25.933  52.652  1.00 21.01           O  
ATOM    567  CB  SER A  70      26.107  26.556  53.984  1.00 20.86           C  
ATOM    568  OG  SER A  70      27.075  26.517  55.014  1.00 21.75           O  
ATOM    569  N   ARG A  71      23.245  28.083  53.266  1.00 20.23           N  
ATOM    570  CA  ARG A  71      22.351  28.423  52.179  1.00 21.15           C  
ATOM    571  C   ARG A  71      23.184  29.171  51.133  1.00 21.81           C  
ATOM    572  O   ARG A  71      23.753  30.229  51.420  1.00 22.96           O  
ATOM    573  CB  ARG A  71      21.191  29.275  52.707  1.00 21.28           C  
ATOM    574  CG  ARG A  71      20.383  28.547  53.799  1.00 22.76           C  
ATOM    575  CD  ARG A  71      19.099  29.265  54.154  1.00 22.19           C  
ATOM    576  NE  ARG A  71      19.331  30.647  54.549  1.00 24.80           N  
ATOM    577  CZ  ARG A  71      18.369  31.497  54.894  1.00 27.85           C  
ATOM    578  NH1 ARG A  71      17.101  31.105  54.896  1.00 28.98           N  
ATOM    579  NH2 ARG A  71      18.672  32.739  55.232  1.00 26.55           N  
ATOM    580  N   ILE A  72      23.273  28.614  49.928  1.00 21.27           N  
ATOM    581  CA  ILE A  72      24.084  29.225  48.870  1.00 22.96           C  
ATOM    582  C   ILE A  72      23.496  29.170  47.461  1.00 21.34           C  
ATOM    583  O   ILE A  72      22.450  28.558  47.227  1.00 21.05           O  
ATOM    584  CB  ILE A  72      25.465  28.545  48.786  1.00 21.90           C  
ATOM    585  CG1 ILE A  72      25.304  27.114  48.278  1.00 20.86           C  
ATOM    586  CG2 ILE A  72      26.123  28.530  50.158  1.00 23.83           C  
ATOM    587  CD1 ILE A  72      26.610  26.360  48.131  1.00 23.38           C  
ATOM    588  N   THR A  73      24.201  29.813  46.531  1.00 20.50           N  
ATOM    589  CA  THR A  73      23.820  29.841  45.126  1.00 21.20           C  
ATOM    590  C   THR A  73      25.017  29.404  44.304  1.00 21.80           C  
ATOM    591  O   THR A  73      26.047  30.080  44.269  1.00 22.56           O  
ATOM    592  CB  THR A  73      23.406  31.244  44.645  1.00 21.06           C  
ATOM    593  OG1 THR A  73      22.347  31.729  45.468  1.00 19.53           O  
ATOM    594  CG2 THR A  73      22.923  31.187  43.199  1.00 20.17           C  
ATOM    595  N   VAL A  74      24.868  28.263  43.644  1.00 22.31           N  
ATOM    596  CA  VAL A  74      25.927  27.710  42.830  1.00 22.60           C  
ATOM    597  C   VAL A  74      25.692  27.985  41.364  1.00 23.12           C  
ATOM    598  O   VAL A  74      24.575  27.852  40.866  1.00 22.84           O  
ATOM    599  CB  VAL A  74      26.041  26.196  43.023  1.00 21.45           C  
ATOM    600  CG1 VAL A  74      27.227  25.669  42.234  1.00 21.14           C  
ATOM    601  CG2 VAL A  74      26.195  25.878  44.499  1.00 22.80           C  
ATOM    602  N   GLN A  75      26.761  28.370  40.678  1.00 23.82           N  
ATOM    603  CA  GLN A  75      26.704  28.662  39.256  1.00 25.39           C  
ATOM    604  C   GLN A  75      27.794  27.827  38.586  1.00 24.77           C  
ATOM    605  O   GLN A  75      28.911  27.743  39.091  1.00 23.93           O  
ATOM    606  CB  GLN A  75      26.941  30.150  39.042  1.00 28.02           C  
ATOM    607  CG  GLN A  75      26.619  30.655  37.655  1.00 34.54           C  
ATOM    608  CD  GLN A  75      26.444  32.177  37.630  1.00 38.44           C  
ATOM    609  OE1 GLN A  75      26.086  32.760  36.600  1.00 38.34           O  
ATOM    610  NE2 GLN A  75      26.689  32.825  38.775  1.00 40.08           N  
ATOM    611  N   GLY A  76      27.462  27.192  37.468  1.00 23.31           N  
ATOM    612  CA  GLY A  76      28.437  26.366  36.778  1.00 23.27           C  
ATOM    613  C   GLY A  76      27.809  25.612  35.625  1.00 23.01           C  
ATOM    614  O   GLY A  76      26.792  26.051  35.082  1.00 23.45           O  
ATOM    615  N   PHE A  77      28.406  24.490  35.233  1.00 20.40           N  
ATOM    616  CA  PHE A  77      27.845  23.708  34.141  1.00 20.47           C  
ATOM    617  C   PHE A  77      27.457  22.312  34.599  1.00 20.40           C  
ATOM    618  O   PHE A  77      28.049  21.770  35.523  1.00 18.24           O  
ATOM    619  CB  PHE A  77      28.828  23.618  32.959  1.00 18.70           C  
ATOM    620  CG  PHE A  77      30.092  22.865  33.258  1.00 20.35           C  
ATOM    621  CD1 PHE A  77      31.182  23.508  33.838  1.00 19.10           C  
ATOM    622  CD2 PHE A  77      30.195  21.510  32.952  1.00 19.90           C  
ATOM    623  CE1 PHE A  77      32.359  22.808  34.111  1.00 18.53           C  
ATOM    624  CE2 PHE A  77      31.366  20.797  33.223  1.00 17.82           C  
ATOM    625  CZ  PHE A  77      32.450  21.446  33.801  1.00 20.24           C  
ATOM    626  N   ILE A  78      26.444  21.734  33.968  1.00 23.15           N  
ATOM    627  CA  ILE A  78      26.021  20.399  34.349  1.00 26.74           C  
ATOM    628  C   ILE A  78      26.595  19.354  33.405  1.00 28.40           C  
ATOM    629  O   ILE A  78      26.944  19.646  32.253  1.00 27.34           O  
ATOM    630  CB  ILE A  78      24.477  20.268  34.395  1.00 27.40           C  
ATOM    631  CG1 ILE A  78      23.851  20.863  33.140  1.00 27.01           C  
ATOM    632  CG2 ILE A  78      23.946  20.957  35.639  1.00 29.40           C  
ATOM    633  CD1 ILE A  78      23.990  20.019  31.926  1.00 26.24           C  
ATOM    634  N   SER A  79      26.704  18.140  33.921  1.00 28.26           N  
ATOM    635  CA  SER A  79      27.218  17.004  33.173  1.00 33.06           C  
ATOM    636  C   SER A  79      26.443  15.804  33.696  1.00 34.56           C  
ATOM    637  O   SER A  79      25.986  15.804  34.838  1.00 33.30           O  
ATOM    638  CB  SER A  79      28.713  16.816  33.444  1.00 32.13           C  
ATOM    639  OG  SER A  79      29.257  15.779  32.633  1.00 32.71           O  
ATOM    640  N   CYS A  80      26.282  14.784  32.871  1.00 37.57           N  
ATOM    641  CA  CYS A  80      25.541  13.629  33.322  1.00 41.31           C  
ATOM    642  C   CYS A  80      26.247  12.330  32.970  1.00 45.90           C  
ATOM    643  O   CYS A  80      27.287  12.327  32.304  1.00 44.10           O  
ATOM    644  CB  CYS A  80      24.118  13.665  32.739  1.00 38.70           C  
ATOM    645  SG  CYS A  80      23.364  15.326  32.823  1.00 36.07           S  
ATOM    646  N   HIS A  81      25.682  11.232  33.460  1.00 52.71           N  
ATOM    647  CA  HIS A  81      26.201   9.894  33.222  1.00 59.30           C  
ATOM    648  C   HIS A  81      24.996   9.082  32.756  1.00 63.89           C  
ATOM    649  O   HIS A  81      23.860   9.412  33.108  1.00 64.47           O  
ATOM    650  CB  HIS A  81      26.759   9.313  34.528  1.00 60.18           C  
ATOM    651  CG  HIS A  81      27.346   7.943  34.379  1.00 62.78           C  
ATOM    652  ND1 HIS A  81      28.356   7.660  33.485  1.00 63.97           N  
ATOM    653  CD2 HIS A  81      27.069   6.778  35.013  1.00 64.08           C  
ATOM    654  CE1 HIS A  81      28.676   6.381  33.573  1.00 65.39           C  
ATOM    655  NE2 HIS A  81      27.910   5.823  34.494  1.00 65.55           N  
ATOM    656  N   LYS A  82      25.226   8.049  31.949  1.00 69.17           N  
ATOM    657  CA  LYS A  82      24.126   7.214  31.480  1.00 73.75           C  
ATOM    658  C   LYS A  82      23.404   6.658  32.710  1.00 76.61           C  
ATOM    659  O   LYS A  82      22.175   6.673  32.794  1.00 76.95           O  
ATOM    660  CB  LYS A  82      24.665   6.062  30.636  1.00 74.44           C  
ATOM    661  CG  LYS A  82      25.777   5.301  31.334  1.00 76.67           C  
ATOM    662  CD  LYS A  82      25.881   3.858  30.879  1.00 77.46           C  
ATOM    663  CE  LYS A  82      26.903   3.115  31.727  1.00 77.92           C  
ATOM    664  NZ  LYS A  82      27.029   1.689  31.327  1.00 77.72           N  
ATOM    665  N   ALA A  83      24.198   6.169  33.658  1.00 79.51           N  
ATOM    666  CA  ALA A  83      23.692   5.606  34.900  1.00 82.09           C  
ATOM    667  C   ALA A  83      22.779   4.409  34.667  1.00 84.32           C  
ATOM    668  O   ALA A  83      22.110   3.944  35.591  1.00 84.98           O  
ATOM    669  CB  ALA A  83      22.957   6.676  35.690  1.00 80.86           C  
ATOM    670  N   LYS A  84      22.758   3.906  33.435  1.00 86.56           N  
ATOM    671  CA  LYS A  84      21.919   2.764  33.092  1.00 88.90           C  
ATOM    672  C   LYS A  84      20.472   3.126  33.419  1.00 90.25           C  
ATOM    673  O   LYS A  84      19.642   2.262  33.703  1.00 90.45           O  
ATOM    674  CB  LYS A  84      22.348   1.532  33.899  1.00 89.53           C  
ATOM    675  CG  LYS A  84      23.809   1.143  33.722  1.00 90.56           C  
ATOM    676  CD  LYS A  84      24.220   0.017  34.663  1.00 91.01           C  
ATOM    677  CE  LYS A  84      24.246   0.466  36.121  1.00 91.50           C  
ATOM    678  NZ  LYS A  84      22.896   0.776  36.667  1.00 92.00           N  
ATOM    679  N   ASN A  85      20.182   4.423  33.373  1.00 91.68           N  
ATOM    680  CA  ASN A  85      18.853   4.940  33.677  1.00 92.96           C  
ATOM    681  C   ASN A  85      18.598   6.208  32.852  1.00 93.56           C  
ATOM    682  O   ASN A  85      19.540   6.855  32.390  1.00 94.21           O  
ATOM    683  CB  ASN A  85      18.768   5.244  35.181  1.00 93.17           C  
ATOM    684  CG  ASN A  85      17.380   5.664  35.624  1.00 92.97           C  
ATOM    685  OD1 ASN A  85      16.908   6.754  35.295  1.00 92.76           O  
ATOM    686  ND2 ASN A  85      16.717   4.797  36.382  1.00 93.18           N  
ATOM    687  N   GLY A  86      17.325   6.551  32.667  1.00 93.78           N  
ATOM    688  CA  GLY A  86      16.976   7.736  31.899  1.00 93.29           C  
ATOM    689  C   GLY A  86      17.413   9.020  32.578  1.00 92.31           C  
ATOM    690  O   GLY A  86      16.596   9.732  33.167  1.00 92.62           O  
ATOM    691  N   LEU A  87      18.707   9.317  32.484  1.00 90.50           N  
ATOM    692  CA  LEU A  87      19.283  10.505  33.098  1.00 88.20           C  
ATOM    693  C   LEU A  87      19.119  10.380  34.608  1.00 86.09           C  
ATOM    694  O   LEU A  87      18.121  10.827  35.179  1.00 86.44           O  
ATOM    695  CB  LEU A  87      18.582  11.771  32.587  1.00 88.63           C  
ATOM    696  CG  LEU A  87      19.251  13.120  32.887  1.00 88.38           C  
ATOM    697  CD1 LEU A  87      19.129  13.468  34.360  1.00 87.91           C  
ATOM    698  CD2 LEU A  87      20.710  13.056  32.465  1.00 87.52           C  
ATOM    699  N   SER A  88      20.104   9.755  35.246  1.00 82.48           N  
ATOM    700  CA  SER A  88      20.073   9.553  36.689  1.00 78.82           C  
ATOM    701  C   SER A  88      21.202  10.288  37.400  1.00 75.00           C  
ATOM    702  O   SER A  88      20.968  10.975  38.393  1.00 75.40           O  
ATOM    703  CB  SER A  88      20.156   8.059  37.009  1.00 80.20           C  
ATOM    704  OG  SER A  88      20.106   7.837  38.407  1.00 81.69           O  
ATOM    705  N   LYS A  89      22.423  10.140  36.893  1.00 69.50           N  
ATOM    706  CA  LYS A  89      23.574  10.794  37.501  1.00 64.62           C  
ATOM    707  C   LYS A  89      23.861  12.161  36.891  1.00 59.85           C  
ATOM    708  O   LYS A  89      24.543  12.269  35.873  1.00 58.82           O  
ATOM    709  CB  LYS A  89      24.824   9.915  37.376  1.00 66.20           C  
ATOM    710  CG  LYS A  89      24.740   8.567  38.091  1.00 68.78           C  
ATOM    711  CD  LYS A  89      26.096   7.863  38.099  1.00 69.85           C  
ATOM    712  CE  LYS A  89      26.002   6.441  38.642  1.00 70.88           C  
ATOM    713  NZ  LYS A  89      25.245   5.533  37.724  1.00 71.31           N  
ATOM    714  N   MET A  90      23.332  13.202  37.527  1.00 53.85           N  
ATOM    715  CA  MET A  90      23.535  14.576  37.078  1.00 49.30           C  
ATOM    716  C   MET A  90      24.412  15.269  38.114  1.00 43.30           C  
ATOM    717  O   MET A  90      24.279  15.013  39.307  1.00 42.03           O  
ATOM    718  CB  MET A  90      22.194  15.305  36.969  1.00 51.85           C  
ATOM    719  CG  MET A  90      21.481  15.515  38.303  1.00 56.34           C  
ATOM    720  SD  MET A  90      21.133  13.971  39.197  1.00 61.46           S  
ATOM    721  CE  MET A  90      19.488  13.596  38.597  1.00 58.37           C  
ATOM    722  N   VAL A  91      25.308  16.139  37.662  1.00 37.55           N  
ATOM    723  CA  VAL A  91      26.202  16.838  38.574  1.00 32.35           C  
ATOM    724  C   VAL A  91      26.461  18.269  38.140  1.00 28.73           C  
ATOM    725  O   VAL A  91      26.664  18.539  36.959  1.00 27.94           O  
ATOM    726  CB  VAL A  91      27.567  16.128  38.670  1.00 32.02           C  
ATOM    727  CG1 VAL A  91      28.437  16.818  39.710  1.00 31.74           C  
ATOM    728  CG2 VAL A  91      27.368  14.662  39.017  1.00 33.24           C  
ATOM    729  N   LEU A  92      26.456  19.188  39.096  1.00 25.42           N  
ATOM    730  CA  LEU A  92      26.713  20.585  38.791  1.00 23.03           C  
ATOM    731  C   LEU A  92      28.173  20.917  39.078  1.00 22.22           C  
ATOM    732  O   LEU A  92      28.600  20.923  40.231  1.00 19.38           O  
ATOM    733  CB  LEU A  92      25.816  21.493  39.636  1.00 22.15           C  
ATOM    734  CG  LEU A  92      26.076  23.002  39.534  1.00 20.82           C  
ATOM    735  CD1 LEU A  92      25.872  23.477  38.091  1.00 16.25           C  
ATOM    736  CD2 LEU A  92      25.150  23.733  40.474  1.00 18.52           C  
ATOM    737  N   HIS A  93      28.940  21.178  38.029  1.00 21.21           N  
ATOM    738  CA  HIS A  93      30.338  21.532  38.217  1.00 22.80           C  
ATOM    739  C   HIS A  93      30.376  23.004  38.537  1.00 22.47           C  
ATOM    740  O   HIS A  93      30.270  23.846  37.656  1.00 21.93           O  
ATOM    741  CB  HIS A  93      31.130  21.215  36.961  1.00 22.78           C  
ATOM    742  CG  HIS A  93      31.142  19.759  36.641  1.00 25.42           C  
ATOM    743  ND1 HIS A  93      32.230  18.949  36.879  1.00 25.55           N  
ATOM    744  CD2 HIS A  93      30.155  18.942  36.200  1.00 25.09           C  
ATOM    745  CE1 HIS A  93      31.912  17.697  36.604  1.00 24.30           C  
ATOM    746  NE2 HIS A  93      30.661  17.666  36.192  1.00 25.21           N  
ATOM    747  N   ALA A  94      30.525  23.305  39.818  1.00 23.38           N  
ATOM    748  CA  ALA A  94      30.523  24.677  40.284  1.00 24.32           C  
ATOM    749  C   ALA A  94      31.736  25.507  39.897  1.00 26.59           C  
ATOM    750  O   ALA A  94      32.886  25.079  40.030  1.00 25.76           O  
ATOM    751  CB  ALA A  94      30.343  24.703  41.795  1.00 23.06           C  
ATOM    752  N   GLU A  95      31.450  26.712  39.424  1.00 25.91           N  
ATOM    753  CA  GLU A  95      32.477  27.658  39.034  1.00 28.56           C  
ATOM    754  C   GLU A  95      32.444  28.856  39.974  1.00 28.05           C  
ATOM    755  O   GLU A  95      33.442  29.547  40.134  1.00 26.13           O  
ATOM    756  CB  GLU A  95      32.258  28.110  37.590  1.00 28.03           C  
ATOM    757  CG  GLU A  95      32.626  27.033  36.592  1.00 32.11           C  
ATOM    758  CD  GLU A  95      32.301  27.411  35.166  1.00 31.91           C  
ATOM    759  OE1 GLU A  95      32.893  26.808  34.249  1.00 31.94           O  
ATOM    760  OE2 GLU A  95      31.448  28.294  34.962  1.00 34.16           O  
ATOM    761  N   GLN A  96      31.291  29.090  40.593  1.00 28.17           N  
ATOM    762  CA  GLN A  96      31.127  30.195  41.525  1.00 29.51           C  
ATOM    763  C   GLN A  96      30.103  29.834  42.587  1.00 30.46           C  
ATOM    764  O   GLN A  96      29.105  29.169  42.299  1.00 29.14           O  
ATOM    765  CB  GLN A  96      30.699  31.462  40.778  1.00 30.86           C  
ATOM    766  CG  GLN A  96      31.827  32.049  39.951  1.00 36.53           C  
ATOM    767  CD  GLN A  96      31.371  33.050  38.913  1.00 38.77           C  
ATOM    768  OE1 GLN A  96      32.196  33.620  38.196  1.00 42.26           O  
ATOM    769  NE2 GLN A  96      30.063  33.271  38.821  1.00 41.49           N  
ATOM    770  N   ILE A  97      30.370  30.256  43.821  1.00 30.05           N  
ATOM    771  CA  ILE A  97      29.477  29.989  44.935  1.00 30.11           C  
ATOM    772  C   ILE A  97      29.236  31.267  45.717  1.00 32.01           C  
ATOM    773  O   ILE A  97      30.169  32.006  46.006  1.00 34.55           O  
ATOM    774  CB  ILE A  97      30.065  28.905  45.865  1.00 28.39           C  
ATOM    775  CG1 ILE A  97      29.986  27.548  45.167  1.00 23.30           C  
ATOM    776  CG2 ILE A  97      29.337  28.908  47.212  1.00 26.58           C  
ATOM    777  CD1 ILE A  97      30.417  26.365  46.036  1.00 26.96           C  
ATOM    778  N   GLU A  98      27.972  31.536  46.027  1.00 32.43           N  
ATOM    779  CA  GLU A  98      27.598  32.730  46.773  1.00 32.77           C  
ATOM    780  C   GLU A  98      26.847  32.349  48.039  1.00 32.61           C  
ATOM    781  O   GLU A  98      25.942  31.516  48.007  1.00 33.26           O  
ATOM    782  CB  GLU A  98      26.711  33.641  45.914  1.00 33.38           C  
ATOM    783  CG  GLU A  98      26.150  34.841  46.666  1.00 35.24           C  
ATOM    784  CD  GLU A  98      25.207  35.675  45.821  1.00 36.39           C  
ATOM    785  OE1 GLU A  98      25.672  36.306  44.850  1.00 38.68           O  
ATOM    786  OE2 GLU A  98      23.992  35.696  46.122  1.00 37.57           O  
ATOM    787  N   LEU A  99      27.237  32.950  49.156  1.00 32.80           N  
ATOM    788  CA  LEU A  99      26.575  32.690  50.427  1.00 32.79           C  
ATOM    789  C   LEU A  99      25.523  33.779  50.577  1.00 33.23           C  
ATOM    790  O   LEU A  99      25.848  34.935  50.862  1.00 30.60           O  
ATOM    791  CB  LEU A  99      27.571  32.780  51.580  1.00 33.17           C  
ATOM    792  CG  LEU A  99      28.904  32.064  51.389  1.00 33.87           C  
ATOM    793  CD1 LEU A  99      29.777  32.338  52.599  1.00 34.76           C  
ATOM    794  CD2 LEU A  99      28.689  30.571  51.205  1.00 33.95           C  
ATOM    795  N   ILE A 100      24.263  33.409  50.387  1.00 34.57           N  
ATOM    796  CA  ILE A 100      23.183  34.379  50.466  1.00 35.61           C  
ATOM    797  C   ILE A 100      23.029  35.080  51.807  1.00 36.29           C  
ATOM    798  O   ILE A 100      22.503  36.193  51.862  1.00 35.51           O  
ATOM    799  CB  ILE A 100      21.846  33.746  50.083  1.00 35.52           C  
ATOM    800  CG1 ILE A 100      21.463  32.666  51.079  1.00 36.46           C  
ATOM    801  CG2 ILE A 100      21.947  33.125  48.708  1.00 36.60           C  
ATOM    802  CD1 ILE A 100      20.160  31.984  50.702  1.00 35.53           C  
ATOM    803  N   ASP A 101      23.502  34.443  52.874  1.00 36.45           N  
ATOM    804  CA  ASP A 101      23.401  35.018  54.212  1.00 39.56           C  
ATOM    805  C   ASP A 101      24.660  35.763  54.626  1.00 42.35           C  
ATOM    806  O   ASP A 101      24.873  36.015  55.813  1.00 44.68           O  
ATOM    807  CB  ASP A 101      23.105  33.931  55.240  1.00 38.09           C  
ATOM    808  CG  ASP A 101      21.857  33.140  54.907  1.00 39.85           C  
ATOM    809  OD1 ASP A 101      20.879  33.757  54.424  1.00 39.18           O  
ATOM    810  OD2 ASP A 101      21.851  31.909  55.136  1.00 39.03           O  
ATOM    811  N   SER A 102      25.492  36.112  53.651  1.00 44.85           N  
ATOM    812  CA  SER A 102      26.723  36.836  53.924  1.00 48.00           C  
ATOM    813  C   SER A 102      26.851  38.040  53.006  1.00 50.25           C  
ATOM    814  O   SER A 102      26.060  38.215  52.080  1.00 48.91           O  
ATOM    815  CB  SER A 102      27.933  35.917  53.746  1.00 48.68           C  
ATOM    816  OG  SER A 102      27.966  34.913  54.743  1.00 48.09           O  
ATOM    817  N   VAL A 103      27.849  38.875  53.265  1.00 54.67           N  
ATOM    818  CA  VAL A 103      28.065  40.063  52.451  1.00 59.64           C  
ATOM    819  C   VAL A 103      29.427  40.009  51.780  1.00 63.92           C  
ATOM    820  O   VAL A 103      30.164  40.999  51.749  1.00 65.34           O  
ATOM    821  CB  VAL A 103      27.969  41.344  53.302  1.00 58.93           C  
ATOM    822  CG1 VAL A 103      26.534  41.567  53.737  1.00 58.91           C  
ATOM    823  CG2 VAL A 103      28.875  41.229  54.521  1.00 59.11           C  
ATOM    824  N   ASP A 104      29.751  38.837  51.243  1.00 68.96           N  
ATOM    825  CA  ASP A 104      31.020  38.605  50.566  1.00 73.40           C  
ATOM    826  C   ASP A 104      32.178  38.462  51.538  1.00 77.17           C  
ATOM    827  O   ASP A 104      33.231  37.937  51.174  1.00 78.10           O  
ATOM    828  CB  ASP A 104      31.338  39.742  49.586  1.00 73.52           C  
ATOM    829  CG  ASP A 104      32.724  39.612  48.965  1.00 73.39           C  
ATOM    830  OD1 ASP A 104      33.734  39.837  49.669  1.00 73.78           O  
ATOM    831  OD2 ASP A 104      32.800  39.268  47.767  1.00 74.10           O  
ATOM    832  N   LYS A 105      31.998  38.899  52.780  1.00 80.86           N  
ATOM    833  CA  LYS A 105      33.105  38.832  53.733  1.00 83.57           C  
ATOM    834  C   LYS A 105      33.236  37.641  54.657  1.00 85.33           C  
ATOM    835  O   LYS A 105      32.394  37.407  55.520  1.00 85.41           O  
ATOM    836  CB  LYS A 105      33.155  40.119  54.568  1.00 84.34           C  
ATOM    837  CG  LYS A 105      33.780  41.280  53.827  1.00 85.25           C  
ATOM    838  CD  LYS A 105      32.897  41.733  52.680  1.00 85.23           C  
ATOM    839  CE  LYS A 105      33.520  42.886  51.924  1.00 85.13           C  
ATOM    840  NZ  LYS A 105      32.540  43.511  50.996  1.00 85.18           N  
ATOM    841  N   LEU A 106      34.310  36.887  54.457  1.00 86.97           N  
ATOM    842  CA  LEU A 106      34.610  35.739  55.295  1.00 88.42           C  
ATOM    843  C   LEU A 106      35.407  36.392  56.425  1.00 89.12           C  
ATOM    844  O   LEU A 106      36.633  36.125  56.501  1.00 89.47           O  
ATOM    845  CB  LEU A 106      35.498  34.710  54.556  1.00 89.12           C  
ATOM    846  CG  LEU A 106      34.958  33.312  54.247  1.00 89.75           C  
ATOM    847  CD1 LEU A 106      34.040  33.284  53.042  1.00 89.97           C  
ATOM    848  CD2 LEU A 106      36.129  32.443  53.922  1.00 89.53           C  
ATOM    849  N   ALA A 107      34.811  37.172  57.210  1.00 89.64           N  
TER     850      ALA A 107                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
