
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   94 (  729),  selected   94 , name 2pnh_B
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 2pnh_B.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_B      -       -           -
LGA    T     2_B      M       1          0.312
LGA    N     3_B      N       2          0.299
LGA    R     4_B      T       3          0.174
LGA    L     5_B      L       4          0.386
LGA    V     6_B      E       5          0.567
LGA    L     7_B      L       6          0.805
LGA    S     8_B      S       7          0.803
LGA    G     9_B      A       8          0.974
LGA    T    10_B      R       9          0.754
LGA    V    11_B      V      10          0.978
LGA    C    12_B      L      11          1.042
LGA    R    13_B      E      12          1.374
LGA    A    14_B      C      13          2.782
LGA    P    15_B      G      14          2.847
LGA    L    16_B      A      15          2.262
LGA    R    17_B      M      16          1.402
LGA    K    18_B      R      17          1.688
LGA    V    19_B      H      18          1.654
LGA    S    20_B      T      19          1.837
LGA    P    21_B      P      20          2.742
LGA    S    22_B      A      21          3.206
LGA    G    23_B      G      22          2.259
LGA    I    24_B      L      23          1.517
LGA    P    25_B      P      24          1.569
LGA    H    26_B      A      25          1.000
LGA    C    27_B      L      26          1.165
LGA    Q    28_B      E      27          0.771
LGA    F    29_B      L      28          0.719
LGA    V    30_B      L      29          0.344
LGA    L    31_B      L      30          0.204
LGA    E    32_B      V      31          0.365
LGA    H    33_B      H      32          0.562
LGA    R    34_B      E      33          0.883
LGA    S    35_B      S      34          0.733
LGA    V    36_B      E      35          0.326
LGA    Q    37_B      V      36          0.471
LGA    E    38_B      V      37          0.524
LGA    A    39_B      E      38          0.554
LGA    A    40_B      A      39          1.183
LGA    G    41_B      G      40          0.944
LGA    F    42_B      H      41          0.797
LGA    H    43_B      P      42          0.574
LGA    R    44_B      R      43          0.924
LGA    Q    45_B      R      44          1.072
LGA    A    46_B      V      45          1.139
LGA    W    47_B      E      46          1.414
LGA    C    48_B      L      47          1.011
LGA    Q    49_B      T      48          0.724
LGA    M    50_B      I      49          0.878
LGA    P    51_B      S      50          0.420
LGA    V    52_B      A      51          0.517
LGA    I    53_B      V      52          0.585
LGA    V    54_B      A      53          0.857
LGA    S    55_B      L      54          0.876
LGA    G    56_B      G      55          1.085
LGA    H    57_B      D      56          2.717
LGA    E    58_B      L      57          5.476
LGA    N    59_B      A      58          5.087
LGA    Q    60_B      L      59          1.918
LGA    A    61_B      L      60          3.608
LGA    I    62_B      -       -           -
LGA    T    63_B      L      61          1.077
LGA    H    64_B      A      62          2.865
LGA    S    65_B      D      63          4.936
LGA    I    66_B      T      64          0.916
LGA    T    67_B      P      65          1.780
LGA    V    68_B      L      66          1.112
LGA    G    69_B      G      67          0.512
LGA    S    70_B      T      68          0.815
LGA    R    71_B      E      69          0.527
LGA    I    72_B      M      70          0.365
LGA    T    73_B      Q      71          0.880
LGA    V    74_B      V      72          1.031
LGA    Q    75_B      Q      73          0.539
LGA    G    76_B      G      74          0.361
LGA    F    77_B      F      75          0.267
LGA    I    78_B      L      76          0.370
LGA    S    79_B      A      77          0.282
LGA    C    80_B      P      78          0.756
LGA    H    81_B      A      79          2.932
LGA    -       -      R      80           -
LGA    -       -      K      81           -
LGA    -       -      D      82           -
LGA    K    82_B      S      83          2.352
LGA    -       -      V      84           -
LGA    K    89_B      K      85          2.020
LGA    M    90_B      V      86          1.055
LGA    V    91_B      K      87          0.637
LGA    L    92_B      L      88          0.353
LGA    H    93_B      H      89          0.393
LGA    A    94_B      L      90          0.307
LGA    E    95_B      Q      91          0.635
LGA    Q    96_B      Q      92          0.506
LGA    I    97_B      A      93          0.506
LGA    E    98_B      R      94          0.538
LGA    L    99_B      R      95          0.791
LGA    I   100_B      I      96          1.712
LGA    -       -      A      97           -
LGA    -       -      G      98           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   94   98    5.0     92    1.60    27.17     87.930     5.408

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.638152 * X  +  -0.695738 * Y  +   0.329714 * Z  +  22.448048
  Y_new =  -0.194648 * X  +  -0.560131 * Y  +  -0.805211 * Z  +  56.116577
  Z_new =   0.744899 * X  +   0.449669 * Y  +  -0.492873 * Z  +  21.674784 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.402001   -0.739592  [ DEG:   137.6245    -42.3755 ]
  Theta =  -0.840383   -2.301209  [ DEG:   -48.1504   -131.8496 ]
  Phi   =  -0.296055    2.845538  [ DEG:   -16.9627    163.0373 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pnh_B                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pnh_B.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   94   98   5.0   92   1.60   27.17  87.930
REMARK  ---------------------------------------------------------- 
MOLECULE 2pnh_B
HEADER    DNA BINDING PROTEIN                     24-APR-07   2PNH              
TITLE     ESCHERICHIA COLI PRIB E39A VARIANT                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRIMOSOMAL REPLICATION PROTEIN N;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 GENE: PRIB;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    BETA BARREL, OB FOLD, DNA BINDING PROTEIN                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.LOPPER,J.L.KECK                                                   
REVDAT   1   07-AUG-07 2PNH    0                                                
JRNL        AUTH   M.LOPPER,R.BOONSOMBAT,S.J.SANDLER,J.L.KECK                   
JRNL        TITL   A HAND-OFF MECHANISM FOR PRIMOSOME ASSEMBLY IN               
JRNL        TITL 2 REPLICATION RESTART.                                         
JRNL        REF    MOL.CELL                      V.  26   781 2007              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 2.25 ANGSTROMS.                                          
DBREF  2PNH A    1   104  UNP    P07013   PRIB_ECOLI       1    104             
DBREF  2PNH B    1   104  UNP    P07013   PRIB_ECOLI       1    104             
SEQRES   1 A  107  GLY SER HIS MET THR ASN ARG LEU VAL LEU SER GLY THR          
SEQRES   2 A  107  VAL CYS ARG ALA PRO LEU ARG LYS VAL SER PRO SER GLY          
SEQRES   3 A  107  ILE PRO HIS CYS GLN PHE VAL LEU GLU HIS ARG SER VAL          
SEQRES   4 A  107  GLN GLU ALA ALA GLY PHE HIS ARG GLN ALA TRP CYS GLN          
SEQRES   5 A  107  MET PRO VAL ILE VAL SER GLY HIS GLU ASN GLN ALA ILE          
SEQRES   6 A  107  THR HIS SER ILE THR VAL GLY SER ARG ILE THR VAL GLN          
SEQRES   7 A  107  GLY PHE ILE SER CYS HIS LYS ALA LYS ASN GLY LEU SER          
SEQRES   8 A  107  LYS MET VAL LEU HIS ALA GLU GLN ILE GLU LEU ILE ASP          
SEQRES   9 A  107  SER GLY ASP                                                  
SEQRES   1 B  107  GLY SER HIS MET THR ASN ARG LEU VAL LEU SER GLY THR          
SEQRES   2 B  107  VAL CYS ARG ALA PRO LEU ARG LYS VAL SER PRO SER GLY          
SEQRES   3 B  107  ILE PRO HIS CYS GLN PHE VAL LEU GLU HIS ARG SER VAL          
SEQRES   4 B  107  GLN GLU ALA ALA GLY PHE HIS ARG GLN ALA TRP CYS GLN          
SEQRES   5 B  107  MET PRO VAL ILE VAL SER GLY HIS GLU ASN GLN ALA ILE          
SEQRES   6 B  107  THR HIS SER ILE THR VAL GLY SER ARG ILE THR VAL GLN          
SEQRES   7 B  107  GLY PHE ILE SER CYS HIS LYS ALA LYS ASN GLY LEU SER          
SEQRES   8 B  107  LYS MET VAL LEU HIS ALA GLU GLN ILE GLU LEU ILE ASP          
SEQRES   9 B  107  SER GLY ASP                                                  
FORMUL   3  HOH   *43(H2 O)                                                     
CRYST1   49.978   60.685   66.273  90.00  90.00  90.00 P 21 21 21    8          
ATOM    745  N   MET B   1      28.484  24.483  22.362  1.00 61.32           N  
ATOM    746  CA  MET B   1      27.149  24.169  22.964  1.00 61.31           C  
ATOM    747  C   MET B   1      26.981  24.689  24.396  1.00 60.59           C  
ATOM    748  O   MET B   1      27.698  24.274  25.311  1.00 60.84           O  
ATOM    749  CB  MET B   1      26.873  22.659  22.920  1.00 61.78           C  
ATOM    750  CG  MET B   1      26.823  22.049  21.511  1.00 63.37           C  
ATOM    751  SD  MET B   1      25.387  22.530  20.522  1.00 66.84           S  
ATOM    752  CE  MET B   1      26.131  23.566  19.259  1.00 65.91           C  
ATOM    753  N   THR B   2      26.011  25.583  24.575  1.00 59.69           N  
ATOM    754  CA  THR B   2      25.687  26.152  25.877  1.00 58.51           C  
ATOM    755  C   THR B   2      25.331  25.053  26.871  1.00 58.21           C  
ATOM    756  O   THR B   2      24.505  24.191  26.606  1.00 57.78           O  
ATOM    757  CB  THR B   2      24.501  27.145  25.798  1.00 58.70           C  
ATOM    758  OG1 THR B   2      24.720  28.090  24.750  1.00 57.97           O  
ATOM    759  CG2 THR B   2      24.321  27.894  27.120  1.00 57.93           C  
ATOM    760  N   ASN B   3      25.994  25.090  28.013  1.00 58.08           N  
ATOM    761  CA  ASN B   3      25.647  24.263  29.138  1.00 57.98           C  
ATOM    762  C   ASN B   3      25.903  25.067  30.410  1.00 58.14           C  
ATOM    763  O   ASN B   3      27.017  25.106  30.914  1.00 58.02           O  
ATOM    764  CB  ASN B   3      26.458  22.964  29.103  1.00 57.30           C  
ATOM    765  CG  ASN B   3      26.149  22.057  30.262  1.00 56.13           C  
ATOM    766  OD1 ASN B   3      25.567  22.479  31.275  1.00 55.10           O  
ATOM    767  ND2 ASN B   3      26.540  20.802  30.135  1.00 53.06           N  
ATOM    768  N   ARG B   4      24.863  25.719  30.919  1.00 58.79           N  
ATOM    769  CA  ARG B   4      25.020  26.626  32.059  1.00 59.08           C  
ATOM    770  C   ARG B   4      23.834  26.523  33.007  1.00 59.10           C  
ATOM    771  O   ARG B   4      22.698  26.886  32.654  1.00 58.83           O  
ATOM    772  CB  ARG B   4      25.212  28.082  31.572  1.00 58.97           C  
ATOM    773  CG  ARG B   4      25.866  29.029  32.577  1.00 59.27           C  
ATOM    774  CD  ARG B   4      25.584  30.516  32.240  1.00 60.64           C  
ATOM    775  NE  ARG B   4      26.267  30.962  31.011  1.00 64.71           N  
ATOM    776  CZ  ARG B   4      25.668  31.283  29.861  1.00 64.93           C  
ATOM    777  NH1 ARG B   4      24.344  31.246  29.736  1.00 64.53           N  
ATOM    778  NH2 ARG B   4      26.405  31.654  28.824  1.00 65.74           N  
ATOM    779  N   LEU B   5      24.110  26.015  34.210  1.00 59.02           N  
ATOM    780  CA  LEU B   5      23.150  25.989  35.296  1.00 58.94           C  
ATOM    781  C   LEU B   5      23.559  26.950  36.422  1.00 58.91           C  
ATOM    782  O   LEU B   5      24.716  26.979  36.855  1.00 58.56           O  
ATOM    783  CB  LEU B   5      22.994  24.569  35.839  1.00 59.00           C  
ATOM    784  CG  LEU B   5      21.848  24.341  36.824  1.00 60.69           C  
ATOM    785  CD1 LEU B   5      20.504  24.431  36.116  1.00 61.72           C  
ATOM    786  CD2 LEU B   5      21.995  22.997  37.522  1.00 59.04           C  
ATOM    787  N   VAL B   6      22.591  27.740  36.859  1.00 58.72           N  
ATOM    788  CA  VAL B   6      22.732  28.636  38.002  1.00 58.83           C  
ATOM    789  C   VAL B   6      21.658  28.201  38.997  1.00 59.45           C  
ATOM    790  O   VAL B   6      20.459  28.240  38.701  1.00 59.66           O  
ATOM    791  CB  VAL B   6      22.591  30.136  37.608  1.00 58.88           C  
ATOM    792  CG1 VAL B   6      22.868  31.034  38.802  1.00 58.05           C  
ATOM    793  CG2 VAL B   6      23.545  30.499  36.471  1.00 56.64           C  
ATOM    794  N   LEU B   7      22.100  27.718  40.149  1.00 59.80           N  
ATOM    795  CA  LEU B   7      21.192  27.149  41.117  1.00 60.55           C  
ATOM    796  C   LEU B   7      21.523  27.589  42.540  1.00 60.80           C  
ATOM    797  O   LEU B   7      22.653  27.410  43.008  1.00 60.84           O  
ATOM    798  CB  LEU B   7      21.187  25.623  41.019  1.00 60.47           C  
ATOM    799  CG  LEU B   7      19.962  24.869  41.548  1.00 60.77           C  
ATOM    800  CD1 LEU B   7      18.691  25.170  40.748  1.00 62.35           C  
ATOM    801  CD2 LEU B   7      20.243  23.376  41.545  1.00 61.36           C  
ATOM    802  N   SER B   8      20.523  28.159  43.208  1.00 60.72           N  
ATOM    803  CA  SER B   8      20.600  28.476  44.629  1.00 61.61           C  
ATOM    804  C   SER B   8      19.882  27.394  45.400  1.00 61.62           C  
ATOM    805  O   SER B   8      18.894  26.823  44.920  1.00 61.56           O  
ATOM    806  CB  SER B   8      19.927  29.817  44.950  1.00 61.39           C  
ATOM    807  OG  SER B   8      20.364  30.823  44.067  1.00 62.28           O  
ATOM    808  N   GLY B   9      20.371  27.145  46.607  1.00 61.66           N  
ATOM    809  CA  GLY B   9      19.758  26.191  47.506  1.00 61.78           C  
ATOM    810  C   GLY B   9      20.470  26.114  48.834  1.00 61.85           C  
ATOM    811  O   GLY B   9      21.236  27.003  49.201  1.00 61.45           O  
ATOM    812  N   THR B  10      20.200  25.037  49.558  1.00 62.34           N  
ATOM    813  CA  THR B  10      20.844  24.787  50.835  1.00 62.77           C  
ATOM    814  C   THR B  10      21.572  23.445  50.798  1.00 62.81           C  
ATOM    815  O   THR B  10      21.111  22.493  50.160  1.00 62.14           O  
ATOM    816  CB  THR B  10      19.860  24.927  52.047  1.00 62.73           C  
ATOM    817  OG1 THR B  10      20.486  24.458  53.249  1.00 63.31           O  
ATOM    818  CG2 THR B  10      18.566  24.166  51.828  1.00 63.41           C  
ATOM    819  N   VAL B  11      22.733  23.399  51.452  1.00 63.16           N  
ATOM    820  CA  VAL B  11      23.536  22.181  51.538  1.00 63.62           C  
ATOM    821  C   VAL B  11      22.811  21.173  52.439  1.00 63.79           C  
ATOM    822  O   VAL B  11      22.504  21.474  53.591  1.00 63.64           O  
ATOM    823  CB  VAL B  11      24.953  22.469  52.087  1.00 63.63           C  
ATOM    824  CG1 VAL B  11      25.836  21.230  51.983  1.00 63.61           C  
ATOM    825  CG2 VAL B  11      25.592  23.633  51.339  1.00 64.32           C  
ATOM    826  N   CYS B  12      22.539  19.989  51.898  1.00 64.09           N  
ATOM    827  CA  CYS B  12      21.762  18.975  52.597  1.00 64.79           C  
ATOM    828  C   CYS B  12      22.580  17.719  52.877  1.00 65.41           C  
ATOM    829  O   CYS B  12      22.085  16.775  53.496  1.00 65.81           O  
ATOM    830  CB  CYS B  12      20.493  18.629  51.805  1.00 64.66           C  
ATOM    831  SG  CYS B  12      20.805  17.932  50.171  1.00 64.37           S  
ATOM    832  N   ARG B  13      23.824  17.714  52.408  1.00 66.29           N  
ATOM    833  CA  ARG B  13      24.791  16.662  52.719  1.00 66.73           C  
ATOM    834  C   ARG B  13      26.144  17.312  52.991  1.00 66.63           C  
ATOM    835  O   ARG B  13      26.550  18.211  52.262  1.00 66.52           O  
ATOM    836  CB  ARG B  13      24.919  15.680  51.554  1.00 66.95           C  
ATOM    837  CG  ARG B  13      25.283  14.255  51.973  1.00 68.04           C  
ATOM    838  CD  ARG B  13      24.036  13.384  52.107  1.00 69.63           C  
ATOM    839  NE  ARG B  13      23.271  13.346  50.858  1.00 70.98           N  
ATOM    840  CZ  ARG B  13      22.027  12.877  50.742  1.00 71.65           C  
ATOM    841  NH1 ARG B  13      21.384  12.393  51.797  1.00 69.90           N  
ATOM    842  NH2 ARG B  13      21.426  12.897  49.558  1.00 71.61           N  
ATOM    843  N   ALA B  14      26.822  16.864  54.049  1.00 66.74           N  
ATOM    844  CA  ALA B  14      28.127  17.406  54.431  1.00 66.57           C  
ATOM    845  C   ALA B  14      29.119  17.344  53.270  1.00 66.53           C  
ATOM    846  O   ALA B  14      29.253  16.298  52.633  1.00 66.29           O  
ATOM    847  CB  ALA B  14      28.681  16.669  55.646  1.00 66.61           C  
ATOM    848  N   PRO B  15      29.791  18.476  52.976  1.00 66.54           N  
ATOM    849  CA  PRO B  15      30.822  18.519  51.944  1.00 66.66           C  
ATOM    850  C   PRO B  15      32.008  17.618  52.280  1.00 66.78           C  
ATOM    851  O   PRO B  15      32.424  17.532  53.441  1.00 66.85           O  
ATOM    852  CB  PRO B  15      31.255  19.991  51.933  1.00 66.58           C  
ATOM    853  CG  PRO B  15      30.840  20.530  53.239  1.00 66.56           C  
ATOM    854  CD  PRO B  15      29.603  19.792  53.613  1.00 66.68           C  
ATOM    855  N   LEU B  16      32.522  16.932  51.268  1.00 66.90           N  
ATOM    856  CA  LEU B  16      33.699  16.093  51.429  1.00 67.26           C  
ATOM    857  C   LEU B  16      34.761  16.425  50.390  1.00 67.53           C  
ATOM    858  O   LEU B  16      34.458  16.585  49.202  1.00 67.27           O  
ATOM    859  CB  LEU B  16      33.329  14.600  51.421  1.00 67.34           C  
ATOM    860  CG  LEU B  16      32.312  14.032  50.425  1.00 67.12           C  
ATOM    861  CD1 LEU B  16      33.046  13.448  49.235  1.00 67.99           C  
ATOM    862  CD2 LEU B  16      31.455  12.963  51.082  1.00 65.41           C  
ATOM    863  N   ARG B  17      35.998  16.560  50.863  1.00 67.65           N  
ATOM    864  CA  ARG B  17      37.136  16.827  50.002  1.00 68.15           C  
ATOM    865  C   ARG B  17      37.754  15.507  49.586  1.00 67.93           C  
ATOM    866  O   ARG B  17      38.224  14.746  50.430  1.00 67.92           O  
ATOM    867  CB  ARG B  17      38.185  17.687  50.716  1.00 68.60           C  
ATOM    868  CG  ARG B  17      37.625  18.728  51.683  1.00 70.19           C  
ATOM    869  CD  ARG B  17      37.354  20.077  51.024  1.00 73.77           C  
ATOM    870  NE  ARG B  17      36.712  20.988  51.970  1.00 75.38           N  
ATOM    871  CZ  ARG B  17      35.399  21.149  52.072  1.00 76.81           C  
ATOM    872  NH1 ARG B  17      34.588  20.472  51.275  1.00 77.74           N  
ATOM    873  NH2 ARG B  17      34.895  21.990  52.968  1.00 77.31           N  
ATOM    874  N   LYS B  18      37.734  15.244  48.285  1.00 67.81           N  
ATOM    875  CA  LYS B  18      38.334  14.051  47.704  1.00 67.79           C  
ATOM    876  C   LYS B  18      39.578  14.453  46.915  1.00 68.06           C  
ATOM    877  O   LYS B  18      39.850  15.636  46.723  1.00 67.85           O  
ATOM    878  CB  LYS B  18      37.335  13.345  46.780  1.00 67.81           C  
ATOM    879  CG  LYS B  18      36.135  12.696  47.470  1.00 67.35           C  
ATOM    880  CD  LYS B  18      36.446  11.279  47.948  1.00 66.94           C  
ATOM    881  CE  LYS B  18      35.173  10.488  48.240  1.00 67.10           C  
ATOM    882  NZ  LYS B  18      35.468   9.162  48.864  1.00 66.84           N  
ATOM    883  N   VAL B  19      40.341  13.462  46.471  1.00 68.56           N  
ATOM    884  CA  VAL B  19      41.500  13.715  45.618  1.00 69.05           C  
ATOM    885  C   VAL B  19      41.400  12.851  44.363  1.00 69.32           C  
ATOM    886  O   VAL B  19      41.299  11.625  44.454  1.00 69.45           O  
ATOM    887  CB  VAL B  19      42.841  13.451  46.358  1.00 68.91           C  
ATOM    888  CG1 VAL B  19      44.029  13.660  45.430  1.00 69.42           C  
ATOM    889  CG2 VAL B  19      42.972  14.349  47.578  1.00 68.89           C  
ATOM    890  N   SER B  20      41.398  13.502  43.198  1.00 69.43           N  
ATOM    891  CA  SER B  20      41.478  12.796  41.918  1.00 69.41           C  
ATOM    892  C   SER B  20      42.852  12.124  41.762  1.00 69.37           C  
ATOM    893  O   SER B  20      43.857  12.643  42.269  1.00 69.25           O  
ATOM    894  CB  SER B  20      41.226  13.760  40.754  1.00 69.51           C  
ATOM    895  OG  SER B  20      42.380  14.540  40.477  1.00 69.34           O  
ATOM    896  N   PRO B  21      42.907  10.973  41.060  1.00 69.32           N  
ATOM    897  CA  PRO B  21      44.198  10.298  40.851  1.00 69.18           C  
ATOM    898  C   PRO B  21      45.238  11.194  40.167  1.00 69.22           C  
ATOM    899  O   PRO B  21      46.440  10.913  40.241  1.00 69.10           O  
ATOM    900  CB  PRO B  21      43.836   9.112  39.950  1.00 69.09           C  
ATOM    901  CG  PRO B  21      42.378   8.873  40.206  1.00 69.42           C  
ATOM    902  CD  PRO B  21      41.792  10.232  40.437  1.00 69.10           C  
ATOM    903  N   SER B  22      44.775  12.271  39.533  1.00 69.14           N  
ATOM    904  CA  SER B  22      45.657  13.220  38.852  1.00 69.29           C  
ATOM    905  C   SER B  22      46.137  14.382  39.738  1.00 69.33           C  
ATOM    906  O   SER B  22      46.580  15.411  39.230  1.00 69.53           O  
ATOM    907  CB  SER B  22      44.977  13.765  37.591  1.00 69.17           C  
ATOM    908  OG  SER B  22      43.924  14.647  37.925  1.00 69.40           O  
ATOM    909  N   GLY B  23      46.047  14.219  41.056  1.00 69.41           N  
ATOM    910  CA  GLY B  23      46.557  15.222  41.997  1.00 69.28           C  
ATOM    911  C   GLY B  23      45.646  16.413  42.255  1.00 69.20           C  
ATOM    912  O   GLY B  23      45.986  17.292  43.051  1.00 69.26           O  
ATOM    913  N   ILE B  24      44.492  16.439  41.590  1.00 68.90           N  
ATOM    914  CA  ILE B  24      43.525  17.530  41.735  1.00 68.85           C  
ATOM    915  C   ILE B  24      42.487  17.221  42.823  1.00 68.67           C  
ATOM    916  O   ILE B  24      41.710  16.268  42.692  1.00 68.39           O  
ATOM    917  CB  ILE B  24      42.782  17.843  40.403  1.00 68.78           C  
ATOM    918  CG1 ILE B  24      43.749  17.786  39.214  1.00 69.06           C  
ATOM    919  CG2 ILE B  24      42.070  19.196  40.491  1.00 68.57           C  
ATOM    920  CD1 ILE B  24      43.085  17.907  37.859  1.00 69.01           C  
ATOM    921  N   PRO B  25      42.492  18.003  43.917  1.00 68.59           N  
ATOM    922  CA  PRO B  25      41.385  17.896  44.868  1.00 68.38           C  
ATOM    923  C   PRO B  25      40.082  18.490  44.337  1.00 68.05           C  
ATOM    924  O   PRO B  25      40.095  19.342  43.438  1.00 67.91           O  
ATOM    925  CB  PRO B  25      41.877  18.682  46.090  1.00 68.46           C  
ATOM    926  CG  PRO B  25      42.930  19.591  45.584  1.00 68.84           C  
ATOM    927  CD  PRO B  25      43.522  18.965  44.354  1.00 68.65           C  
ATOM    928  N   HIS B  26      38.971  18.007  44.878  1.00 67.58           N  
ATOM    929  CA  HIS B  26      37.660  18.595  44.635  1.00 67.22           C  
ATOM    930  C   HIS B  26      36.755  18.449  45.860  1.00 67.07           C  
ATOM    931  O   HIS B  26      36.986  17.605  46.735  1.00 66.95           O  
ATOM    932  CB  HIS B  26      37.001  18.006  43.378  1.00 67.16           C  
ATOM    933  CG  HIS B  26      36.713  16.544  43.477  1.00 66.78           C  
ATOM    934  ND1 HIS B  26      37.621  15.580  43.096  1.00 68.12           N  
ATOM    935  CD2 HIS B  26      35.624  15.880  43.925  1.00 67.25           C  
ATOM    936  CE1 HIS B  26      37.101  14.384  43.302  1.00 67.70           C  
ATOM    937  NE2 HIS B  26      35.890  14.538  43.801  1.00 67.29           N  
ATOM    938  N   CYS B  27      35.731  19.288  45.921  1.00 66.97           N  
ATOM    939  CA  CYS B  27      34.778  19.252  47.015  1.00 66.66           C  
ATOM    940  C   CYS B  27      33.388  18.852  46.513  1.00 66.33           C  
ATOM    941  O   CYS B  27      32.858  19.454  45.583  1.00 66.18           O  
ATOM    942  CB  CYS B  27      34.734  20.608  47.710  1.00 66.53           C  
ATOM    943  SG  CYS B  27      33.516  20.700  49.006  1.00 67.60           S  
ATOM    944  N   GLN B  28      32.816  17.826  47.139  1.00 65.92           N  
ATOM    945  CA  GLN B  28      31.501  17.323  46.774  1.00 65.64           C  
ATOM    946  C   GLN B  28      30.524  17.499  47.919  1.00 65.12           C  
ATOM    947  O   GLN B  28      30.842  17.216  49.081  1.00 64.69           O  
ATOM    948  CB  GLN B  28      31.548  15.838  46.455  1.00 66.02           C  
ATOM    949  CG  GLN B  28      32.525  15.412  45.392  1.00 67.18           C  
ATOM    950  CD  GLN B  28      32.679  13.903  45.370  1.00 68.97           C  
ATOM    951  OE1 GLN B  28      31.911  13.181  46.019  1.00 69.23           O  
ATOM    952  NE2 GLN B  28      33.667  13.417  44.625  1.00 68.11           N  
ATOM    953  N   PHE B  29      29.332  17.961  47.566  1.00 64.30           N  
ATOM    954  CA  PHE B  29      28.208  18.071  48.479  1.00 63.90           C  
ATOM    955  C   PHE B  29      26.932  17.955  47.647  1.00 63.63           C  
ATOM    956  O   PHE B  29      26.992  17.875  46.419  1.00 63.41           O  
ATOM    957  CB  PHE B  29      28.255  19.392  49.263  1.00 63.88           C  
ATOM    958  CG  PHE B  29      28.375  20.611  48.400  1.00 63.82           C  
ATOM    959  CD1 PHE B  29      27.238  21.277  47.956  1.00 65.13           C  
ATOM    960  CD2 PHE B  29      29.627  21.095  48.025  1.00 64.81           C  
ATOM    961  CE1 PHE B  29      27.343  22.403  47.153  1.00 64.68           C  
ATOM    962  CE2 PHE B  29      29.751  22.220  47.221  1.00 63.69           C  
ATOM    963  CZ  PHE B  29      28.607  22.876  46.786  1.00 65.25           C  
ATOM    964  N   VAL B  30      25.784  17.920  48.315  1.00 63.27           N  
ATOM    965  CA  VAL B  30      24.500  17.883  47.626  1.00 62.89           C  
ATOM    966  C   VAL B  30      23.774  19.176  47.962  1.00 62.57           C  
ATOM    967  O   VAL B  30      23.753  19.608  49.118  1.00 62.67           O  
ATOM    968  CB  VAL B  30      23.662  16.633  48.014  1.00 62.81           C  
ATOM    969  CG1 VAL B  30      22.340  16.573  47.208  1.00 63.14           C  
ATOM    970  CG2 VAL B  30      24.476  15.360  47.798  1.00 62.47           C  
ATOM    971  N   LEU B  31      23.200  19.795  46.940  1.00 62.22           N  
ATOM    972  CA  LEU B  31      22.540  21.075  47.087  1.00 62.12           C  
ATOM    973  C   LEU B  31      21.033  20.918  46.863  1.00 62.33           C  
ATOM    974  O   LEU B  31      20.597  20.466  45.798  1.00 62.66           O  
ATOM    975  CB  LEU B  31      23.143  22.079  46.100  1.00 61.91           C  
ATOM    976  CG  LEU B  31      22.606  23.502  46.001  1.00 61.30           C  
ATOM    977  CD1 LEU B  31      23.022  24.324  47.203  1.00 62.39           C  
ATOM    978  CD2 LEU B  31      23.136  24.132  44.756  1.00 62.63           C  
ATOM    979  N   GLU B  32      20.250  21.315  47.862  1.00 62.18           N  
ATOM    980  CA  GLU B  32      18.799  21.213  47.795  1.00 62.43           C  
ATOM    981  C   GLU B  32      18.172  22.551  47.431  1.00 62.11           C  
ATOM    982  O   GLU B  32      18.305  23.535  48.152  1.00 62.34           O  
ATOM    983  CB  GLU B  32      18.207  20.679  49.107  1.00 62.42           C  
ATOM    984  CG  GLU B  32      16.709  20.414  49.021  1.00 63.21           C  
ATOM    985  CD  GLU B  32      16.209  19.482  50.098  1.00 64.41           C  
ATOM    986  OE1 GLU B  32      15.504  18.505  49.770  1.00 64.96           O  
ATOM    987  OE2 GLU B  32      16.526  19.719  51.274  1.00 66.44           O  
ATOM    988  N   HIS B  33      17.484  22.558  46.298  1.00 62.05           N  
ATOM    989  CA  HIS B  33      16.827  23.741  45.787  1.00 61.61           C  
ATOM    990  C   HIS B  33      15.333  23.599  46.005  1.00 61.64           C  
ATOM    991  O   HIS B  33      14.774  22.523  45.790  1.00 61.86           O  
ATOM    992  CB  HIS B  33      17.105  23.907  44.289  1.00 61.37           C  
ATOM    993  CG  HIS B  33      16.254  24.952  43.641  1.00 60.50           C  
ATOM    994  ND1 HIS B  33      16.522  26.301  43.753  1.00 58.94           N  
ATOM    995  CD2 HIS B  33      15.120  24.852  42.907  1.00 58.97           C  
ATOM    996  CE1 HIS B  33      15.598  26.984  43.104  1.00 58.70           C  
ATOM    997  NE2 HIS B  33      14.735  26.130  42.584  1.00 59.35           N  
ATOM    998  N   ARG B  34      14.698  24.690  46.415  1.00 61.31           N  
ATOM    999  CA  ARG B  34      13.253  24.742  46.540  1.00 61.62           C  
ATOM   1000  C   ARG B  34      12.812  26.170  46.225  1.00 61.77           C  
ATOM   1001  O   ARG B  34      13.169  27.108  46.942  1.00 62.04           O  
ATOM   1002  CB  ARG B  34      12.814  24.301  47.951  1.00 61.56           C  
ATOM   1003  CG  ARG B  34      11.327  23.963  48.086  1.00 62.06           C  
ATOM   1004  CD  ARG B  34      10.942  23.497  49.505  1.00 61.41           C  
ATOM   1005  NE  ARG B  34      11.471  22.173  49.847  1.00 60.38           N  
ATOM   1006  CZ  ARG B  34      10.889  21.014  49.542  1.00 60.79           C  
ATOM   1007  NH1 ARG B  34       9.740  20.981  48.874  1.00 60.92           N  
ATOM   1008  NH2 ARG B  34      11.465  19.877  49.904  1.00 60.16           N  
ATOM   1009  N   SER B  35      12.054  26.332  45.139  1.00 61.77           N  
ATOM   1010  CA  SER B  35      11.585  27.649  44.710  1.00 61.62           C  
ATOM   1011  C   SER B  35      10.176  27.622  44.133  1.00 61.99           C  
ATOM   1012  O   SER B  35       9.633  26.562  43.827  1.00 61.98           O  
ATOM   1013  CB  SER B  35      12.538  28.247  43.667  1.00 61.79           C  
ATOM   1014  OG  SER B  35      12.376  27.633  42.393  1.00 59.92           O  
ATOM   1015  N   VAL B  36       9.609  28.809  43.967  1.00 62.28           N  
ATOM   1016  CA  VAL B  36       8.369  28.977  43.238  1.00 63.18           C  
ATOM   1017  C   VAL B  36       8.694  29.525  41.846  1.00 63.53           C  
ATOM   1018  O   VAL B  36       9.374  30.549  41.716  1.00 63.05           O  
ATOM   1019  CB  VAL B  36       7.368  29.907  43.989  1.00 63.08           C  
ATOM   1020  CG1 VAL B  36       6.056  30.024  43.213  1.00 63.73           C  
ATOM   1021  CG2 VAL B  36       7.098  29.383  45.392  1.00 62.92           C  
ATOM   1022  N   GLN B  37       8.220  28.820  40.816  1.00 64.32           N  
ATOM   1023  CA  GLN B  37       8.419  29.227  39.426  1.00 65.33           C  
ATOM   1024  C   GLN B  37       7.084  29.413  38.705  1.00 66.04           C  
ATOM   1025  O   GLN B  37       6.045  28.959  39.191  1.00 66.16           O  
ATOM   1026  CB  GLN B  37       9.293  28.207  38.681  1.00 65.70           C  
ATOM   1027  CG  GLN B  37      10.701  28.011  39.266  1.00 65.68           C  
ATOM   1028  CD  GLN B  37      11.553  29.264  39.184  1.00 66.36           C  
ATOM   1029  OE1 GLN B  37      11.392  30.079  38.273  1.00 67.24           O  
ATOM   1030  NE2 GLN B  37      12.471  29.423  40.135  1.00 66.11           N  
ATOM   1031  N   GLU B  38       7.116  30.066  37.544  1.00 66.89           N  
ATOM   1032  CA  GLU B  38       5.885  30.391  36.812  1.00 68.03           C  
ATOM   1033  C   GLU B  38       5.744  29.595  35.511  1.00 68.40           C  
ATOM   1034  O   GLU B  38       6.655  29.582  34.680  1.00 68.68           O  
ATOM   1035  CB  GLU B  38       5.805  31.901  36.547  1.00 67.99           C  
ATOM   1036  CG  GLU B  38       4.391  32.452  36.458  1.00 68.79           C  
ATOM   1037  CD  GLU B  38       4.268  33.861  37.027  1.00 69.73           C  
ATOM   1038  OE1 GLU B  38       5.301  34.550  37.182  1.00 69.88           O  
ATOM   1039  OE2 GLU B  38       3.132  34.283  37.326  1.00 70.32           O  
ATOM   1040  N   ALA B  39       4.600  28.929  35.347  1.00 68.82           N  
ATOM   1041  CA  ALA B  39       4.345  28.110  34.155  1.00 69.17           C  
ATOM   1042  C   ALA B  39       2.874  28.100  33.752  1.00 69.28           C  
ATOM   1043  O   ALA B  39       1.992  27.876  34.583  1.00 69.27           O  
ATOM   1044  CB  ALA B  39       4.852  26.691  34.363  1.00 69.29           C  
ATOM   1045  N   ALA B  40       2.624  28.344  32.466  1.00 69.48           N  
ATOM   1046  CA  ALA B  40       1.275  28.395  31.901  1.00 69.35           C  
ATOM   1047  C   ALA B  40       0.355  29.355  32.665  1.00 69.66           C  
ATOM   1048  O   ALA B  40      -0.864  29.153  32.730  1.00 69.34           O  
ATOM   1049  CB  ALA B  40       0.669  26.992  31.823  1.00 69.35           C  
ATOM   1050  N   GLY B  41       0.958  30.400  33.234  1.00 69.82           N  
ATOM   1051  CA  GLY B  41       0.235  31.386  34.036  1.00 70.07           C  
ATOM   1052  C   GLY B  41      -0.075  30.899  35.440  1.00 70.18           C  
ATOM   1053  O   GLY B  41      -1.000  31.393  36.078  1.00 69.98           O  
ATOM   1054  N   PHE B  42       0.701  29.930  35.923  1.00 70.33           N  
ATOM   1055  CA  PHE B  42       0.485  29.372  37.258  1.00 70.39           C  
ATOM   1056  C   PHE B  42       1.771  29.217  38.054  1.00 70.31           C  
ATOM   1057  O   PHE B  42       2.859  29.073  37.489  1.00 70.53           O  
ATOM   1058  CB  PHE B  42      -0.278  28.042  37.182  1.00 70.54           C  
ATOM   1059  CG  PHE B  42      -1.775  28.208  37.143  1.00 70.64           C  
ATOM   1060  CD1 PHE B  42      -2.476  28.030  35.959  1.00 70.91           C  
ATOM   1061  CD2 PHE B  42      -2.479  28.557  38.294  1.00 70.96           C  
ATOM   1062  CE1 PHE B  42      -3.866  28.191  35.919  1.00 71.37           C  
ATOM   1063  CE2 PHE B  42      -3.865  28.723  38.269  1.00 70.83           C  
ATOM   1064  CZ  PHE B  42      -4.559  28.539  37.078  1.00 71.06           C  
ATOM   1065  N   HIS B  43       1.644  29.256  39.376  1.00 70.10           N  
ATOM   1066  CA  HIS B  43       2.808  29.107  40.235  1.00 69.77           C  
ATOM   1067  C   HIS B  43       3.114  27.638  40.478  1.00 69.63           C  
ATOM   1068  O   HIS B  43       2.324  26.921  41.097  1.00 69.96           O  
ATOM   1069  CB  HIS B  43       2.629  29.878  41.544  1.00 69.66           C  
ATOM   1070  CG  HIS B  43       2.481  31.353  41.348  1.00 69.21           C  
ATOM   1071  ND1 HIS B  43       3.448  32.121  40.736  1.00 68.66           N  
ATOM   1072  CD2 HIS B  43       1.476  32.200  41.672  1.00 68.88           C  
ATOM   1073  CE1 HIS B  43       3.044  33.378  40.693  1.00 68.99           C  
ATOM   1074  NE2 HIS B  43       1.852  33.453  41.256  1.00 68.70           N  
ATOM   1075  N   ARG B  44       4.260  27.205  39.960  1.00 69.10           N  
ATOM   1076  CA  ARG B  44       4.735  25.834  40.113  1.00 68.53           C  
ATOM   1077  C   ARG B  44       5.822  25.784  41.174  1.00 67.48           C  
ATOM   1078  O   ARG B  44       6.670  26.680  41.255  1.00 67.61           O  
ATOM   1079  CB  ARG B  44       5.295  25.286  38.791  1.00 68.48           C  
ATOM   1080  CG  ARG B  44       4.456  25.594  37.553  1.00 70.24           C  
ATOM   1081  CD  ARG B  44       3.234  24.676  37.392  1.00 72.30           C  
ATOM   1082  NE  ARG B  44       2.119  25.044  38.266  1.00 73.17           N  
ATOM   1083  CZ  ARG B  44       0.931  24.445  38.266  1.00 73.84           C  
ATOM   1084  NH1 ARG B  44       0.686  23.438  37.437  1.00 73.92           N  
ATOM   1085  NH2 ARG B  44      -0.018  24.852  39.100  1.00 73.99           N  
ATOM   1086  N   GLN B  45       5.776  24.741  41.994  1.00 66.15           N  
ATOM   1087  CA  GLN B  45       6.849  24.450  42.923  1.00 64.81           C  
ATOM   1088  C   GLN B  45       7.918  23.667  42.153  1.00 64.43           C  
ATOM   1089  O   GLN B  45       7.606  22.735  41.403  1.00 63.38           O  
ATOM   1090  CB  GLN B  45       6.335  23.661  44.133  1.00 64.72           C  
ATOM   1091  CG  GLN B  45       5.076  24.259  44.833  1.00 65.22           C  
ATOM   1092  CD  GLN B  45       5.331  25.578  45.560  1.00 64.83           C  
ATOM   1093  OE1 GLN B  45       6.474  25.993  45.750  1.00 64.79           O  
ATOM   1094  NE2 GLN B  45       4.250  26.240  45.979  1.00 67.32           N  
ATOM   1095  N   ALA B  46       9.164  24.098  42.317  1.00 63.54           N  
ATOM   1096  CA  ALA B  46      10.314  23.452  41.739  1.00 63.30           C  
ATOM   1097  C   ALA B  46      11.225  23.037  42.888  1.00 63.30           C  
ATOM   1098  O   ALA B  46      11.558  23.852  43.744  1.00 63.18           O  
ATOM   1099  CB  ALA B  46      11.028  24.399  40.793  1.00 62.94           C  
ATOM   1100  N   TRP B  47      11.572  21.756  42.927  1.00 63.19           N  
ATOM   1101  CA  TRP B  47      12.502  21.223  43.909  1.00 64.03           C  
ATOM   1102  C   TRP B  47      13.510  20.360  43.179  1.00 64.63           C  
ATOM   1103  O   TRP B  47      13.180  19.698  42.196  1.00 63.79           O  
ATOM   1104  CB  TRP B  47      11.786  20.380  44.979  1.00 63.54           C  
ATOM   1105  CG  TRP B  47      12.698  19.445  45.772  1.00 63.20           C  
ATOM   1106  CD1 TRP B  47      13.345  19.727  46.943  1.00 63.47           C  
ATOM   1107  CD2 TRP B  47      13.052  18.090  45.442  1.00 63.30           C  
ATOM   1108  NE1 TRP B  47      14.063  18.637  47.367  1.00 62.88           N  
ATOM   1109  CE2 TRP B  47      13.904  17.621  46.465  1.00 63.38           C  
ATOM   1110  CE3 TRP B  47      12.730  17.228  44.383  1.00 64.17           C  
ATOM   1111  CZ2 TRP B  47      14.445  16.331  46.458  1.00 63.78           C  
ATOM   1112  CZ3 TRP B  47      13.260  15.938  44.378  1.00 63.49           C  
ATOM   1113  CH2 TRP B  47      14.110  15.505  45.412  1.00 63.99           C  
ATOM   1114  N   CYS B  48      14.732  20.353  43.693  1.00 66.56           N  
ATOM   1115  CA  CYS B  48      15.748  19.443  43.211  1.00 66.86           C  
ATOM   1116  C   CYS B  48      16.813  19.240  44.267  1.00 66.61           C  
ATOM   1117  O   CYS B  48      17.033  20.112  45.100  1.00 66.66           O  
ATOM   1118  CB  CYS B  48      16.379  19.984  41.932  1.00 66.80           C  
ATOM   1119  SG  CYS B  48      17.632  18.881  41.298  1.00 71.90           S  
ATOM   1120  N   GLN B  49      17.460  18.079  44.230  1.00 66.61           N  
ATOM   1121  CA  GLN B  49      18.685  17.847  44.981  1.00 66.52           C  
ATOM   1122  C   GLN B  49      19.812  17.572  43.998  1.00 66.74           C  
ATOM   1123  O   GLN B  49      19.877  16.503  43.383  1.00 66.88           O  
ATOM   1124  CB  GLN B  49      18.524  16.709  45.991  1.00 66.56           C  
ATOM   1125  CG  GLN B  49      17.880  17.127  47.311  1.00 66.03           C  
ATOM   1126  CD  GLN B  49      17.674  15.964  48.272  1.00 66.48           C  
ATOM   1127  OE1 GLN B  49      18.083  14.840  48.001  1.00 66.84           O  
ATOM   1128  NE2 GLN B  49      17.034  16.236  49.404  1.00 65.21           N  
ATOM   1129  N   MET B  50      20.680  18.567  43.840  1.00 66.80           N  
ATOM   1130  CA  MET B  50      21.788  18.520  42.898  1.00 67.17           C  
ATOM   1131  C   MET B  50      23.109  18.184  43.581  1.00 66.19           C  
ATOM   1132  O   MET B  50      23.567  18.944  44.435  1.00 65.64           O  
ATOM   1133  CB  MET B  50      21.949  19.874  42.196  1.00 67.36           C  
ATOM   1134  CG  MET B  50      21.343  19.977  40.814  1.00 71.33           C  
ATOM   1135  SD  MET B  50      22.378  19.258  39.537  1.00 75.20           S  
ATOM   1136  CE  MET B  50      21.725  17.601  39.479  1.00 77.68           C  
ATOM   1137  N   PRO B  51      23.736  17.060  43.186  1.00 65.83           N  
ATOM   1138  CA  PRO B  51      25.143  16.850  43.519  1.00 65.65           C  
ATOM   1139  C   PRO B  51      26.021  17.890  42.817  1.00 65.70           C  
ATOM   1140  O   PRO B  51      25.804  18.213  41.647  1.00 65.06           O  
ATOM   1141  CB  PRO B  51      25.428  15.431  43.011  1.00 65.68           C  
ATOM   1142  CG  PRO B  51      24.077  14.795  42.861  1.00 65.69           C  
ATOM   1143  CD  PRO B  51      23.174  15.913  42.455  1.00 65.81           C  
ATOM   1144  N   VAL B  52      26.974  18.435  43.561  1.00 65.56           N  
ATOM   1145  CA  VAL B  52      27.817  19.517  43.088  1.00 65.82           C  
ATOM   1146  C   VAL B  52      29.272  19.167  43.350  1.00 65.83           C  
ATOM   1147  O   VAL B  52      29.624  18.734  44.450  1.00 65.40           O  
ATOM   1148  CB  VAL B  52      27.467  20.872  43.785  1.00 65.93           C  
ATOM   1149  CG1 VAL B  52      28.427  21.979  43.351  1.00 66.19           C  
ATOM   1150  CG2 VAL B  52      26.044  21.282  43.487  1.00 65.62           C  
ATOM   1151  N   ILE B  53      30.094  19.338  42.316  1.00 66.33           N  
ATOM   1152  CA  ILE B  53      31.533  19.149  42.397  1.00 66.35           C  
ATOM   1153  C   ILE B  53      32.228  20.483  42.129  1.00 66.49           C  
ATOM   1154  O   ILE B  53      31.988  21.129  41.117  1.00 66.09           O  
ATOM   1155  CB  ILE B  53      32.011  18.038  41.425  1.00 66.30           C  
ATOM   1156  CG1 ILE B  53      31.460  16.675  41.889  1.00 66.69           C  
ATOM   1157  CG2 ILE B  53      33.528  18.023  41.322  1.00 66.02           C  
ATOM   1158  CD1 ILE B  53      31.847  15.473  41.012  1.00 66.38           C  
ATOM   1159  N   VAL B  54      33.064  20.896  43.076  1.00 67.27           N  
ATOM   1160  CA  VAL B  54      33.854  22.121  42.974  1.00 67.37           C  
ATOM   1161  C   VAL B  54      35.313  21.704  42.938  1.00 67.82           C  
ATOM   1162  O   VAL B  54      35.818  21.162  43.920  1.00 67.99           O  
ATOM   1163  CB  VAL B  54      33.624  23.050  44.202  1.00 67.73           C  
ATOM   1164  CG1 VAL B  54      34.306  24.409  44.004  1.00 67.28           C  
ATOM   1165  CG2 VAL B  54      32.134  23.230  44.498  1.00 67.03           C  
ATOM   1166  N   SER B  55      35.982  21.923  41.808  1.00 68.00           N  
ATOM   1167  CA  SER B  55      37.410  21.628  41.706  1.00 68.75           C  
ATOM   1168  C   SER B  55      38.251  22.892  41.514  1.00 68.98           C  
ATOM   1169  O   SER B  55      37.722  23.965  41.225  1.00 69.53           O  
ATOM   1170  CB  SER B  55      37.720  20.571  40.627  1.00 68.85           C  
ATOM   1171  OG  SER B  55      36.653  20.395  39.715  1.00 69.63           O  
ATOM   1172  N   GLY B  56      39.558  22.764  41.702  1.00 69.08           N  
ATOM   1173  CA  GLY B  56      40.456  23.912  41.605  1.00 69.08           C  
ATOM   1174  C   GLY B  56      40.583  24.652  42.923  1.00 68.73           C  
ATOM   1175  O   GLY B  56      39.586  24.942  43.581  1.00 68.64           O  
ATOM   1176  N   HIS B  57      41.818  24.993  43.271  1.00 68.66           N  
ATOM   1177  CA  HIS B  57      42.177  25.498  44.600  1.00 68.48           C  
ATOM   1178  C   HIS B  57      41.626  26.876  44.988  1.00 68.53           C  
ATOM   1179  O   HIS B  57      41.620  27.221  46.174  1.00 68.38           O  
ATOM   1180  CB  HIS B  57      43.698  25.506  44.740  1.00 68.35           C  
ATOM   1181  CG  HIS B  57      44.374  26.553  43.909  1.00 68.20           C  
ATOM   1182  ND1 HIS B  57      44.521  26.444  42.544  1.00 67.83           N  
ATOM   1183  CD2 HIS B  57      44.949  27.730  44.255  1.00 68.10           C  
ATOM   1184  CE1 HIS B  57      45.160  27.503  42.084  1.00 67.67           C  
ATOM   1185  NE2 HIS B  57      45.432  28.299  43.102  1.00 67.73           N  
ATOM   1186  N   GLU B  58      41.191  27.661  44.000  1.00 68.74           N  
ATOM   1187  CA  GLU B  58      40.755  29.047  44.232  1.00 69.21           C  
ATOM   1188  C   GLU B  58      39.479  29.139  45.070  1.00 69.84           C  
ATOM   1189  O   GLU B  58      39.269  30.105  45.810  1.00 69.70           O  
ATOM   1190  CB  GLU B  58      40.599  29.813  42.910  1.00 69.00           C  
ATOM   1191  CG  GLU B  58      39.517  29.295  41.963  1.00 68.34           C  
ATOM   1192  CD  GLU B  58      40.035  28.324  40.916  1.00 67.49           C  
ATOM   1193  OE1 GLU B  58      41.099  27.706  41.116  1.00 67.59           O  
ATOM   1194  OE2 GLU B  58      39.367  28.181  39.875  1.00 67.66           O  
ATOM   1195  N   ASN B  59      38.641  28.118  44.948  1.00 70.74           N  
ATOM   1196  CA  ASN B  59      37.446  27.995  45.760  1.00 71.80           C  
ATOM   1197  C   ASN B  59      37.720  27.060  46.939  1.00 72.52           C  
ATOM   1198  O   ASN B  59      37.224  25.927  46.963  1.00 73.27           O  
ATOM   1199  CB  ASN B  59      36.281  27.445  44.923  1.00 71.72           C  
ATOM   1200  CG  ASN B  59      36.213  28.052  43.527  1.00 71.63           C  
ATOM   1201  OD1 ASN B  59      36.726  27.479  42.564  1.00 70.26           O  
ATOM   1202  ND2 ASN B  59      35.577  29.214  43.415  1.00 71.95           N  
ATOM   1203  N   GLN B  60      38.528  27.517  47.897  1.00 72.83           N  
ATOM   1204  CA  GLN B  60      38.773  26.742  49.117  1.00 73.03           C  
ATOM   1205  C   GLN B  60      38.335  27.468  50.393  1.00 72.81           C  
ATOM   1206  O   GLN B  60      37.845  26.831  51.317  1.00 72.51           O  
ATOM   1207  CB  GLN B  60      40.229  26.254  49.213  1.00 73.34           C  
ATOM   1208  CG  GLN B  60      40.670  25.249  48.114  1.00 74.90           C  
ATOM   1209  CD  GLN B  60      39.639  24.157  47.808  1.00 77.64           C  
ATOM   1210  OE1 GLN B  60      39.201  23.420  48.701  1.00 80.25           O  
ATOM   1211  NE2 GLN B  60      39.246  24.050  46.541  1.00 78.04           N  
ATOM   1212  N   ALA B  61      38.488  28.790  50.436  1.00 72.83           N  
ATOM   1213  CA  ALA B  61      38.059  29.569  51.607  1.00 73.03           C  
ATOM   1214  C   ALA B  61      36.536  29.573  51.749  1.00 73.13           C  
ATOM   1215  O   ALA B  61      36.000  29.524  52.861  1.00 73.05           O  
ATOM   1216  CB  ALA B  61      38.604  30.994  51.551  1.00 72.99           C  
ATOM   1217  N   ILE B  62      35.849  29.636  50.613  1.00 73.22           N  
ATOM   1218  CA  ILE B  62      34.396  29.520  50.575  1.00 73.51           C  
ATOM   1219  C   ILE B  62      33.962  28.068  50.805  1.00 73.48           C  
ATOM   1220  O   ILE B  62      33.078  27.796  51.618  1.00 73.57           O  
ATOM   1221  CB  ILE B  62      33.811  30.090  49.258  1.00 73.68           C  
ATOM   1222  CG1 ILE B  62      34.804  29.900  48.099  1.00 73.75           C  
ATOM   1223  CG2 ILE B  62      33.475  31.566  49.437  1.00 73.97           C  
ATOM   1224  CD1 ILE B  62      34.437  30.638  46.813  1.00 73.56           C  
ATOM   1225  N   THR B  63      34.615  27.146  50.105  1.00 73.42           N  
ATOM   1226  CA  THR B  63      34.385  25.707  50.236  1.00 73.35           C  
ATOM   1227  C   THR B  63      34.581  25.155  51.666  1.00 73.17           C  
ATOM   1228  O   THR B  63      33.760  24.364  52.136  1.00 72.93           O  
ATOM   1229  CB  THR B  63      35.234  24.955  49.184  1.00 73.39           C  
ATOM   1230  OG1 THR B  63      34.430  24.705  48.026  1.00 74.24           O  
ATOM   1231  CG2 THR B  63      35.789  23.643  49.703  1.00 74.28           C  
ATOM   1232  N   HIS B  64      35.647  25.589  52.346  1.00 72.95           N  
ATOM   1233  CA  HIS B  64      35.943  25.167  53.729  1.00 72.85           C  
ATOM   1234  C   HIS B  64      34.965  25.752  54.754  1.00 72.38           C  
ATOM   1235  O   HIS B  64      34.858  25.249  55.876  1.00 72.15           O  
ATOM   1236  CB  HIS B  64      37.376  25.553  54.134  1.00 73.08           C  
ATOM   1237  CG  HIS B  64      38.449  24.723  53.493  1.00 74.01           C  
ATOM   1238  ND1 HIS B  64      38.542  24.539  52.129  1.00 75.26           N  
ATOM   1239  CD2 HIS B  64      39.506  24.069  54.031  1.00 75.11           C  
ATOM   1240  CE1 HIS B  64      39.597  23.790  51.857  1.00 75.45           C  
ATOM   1241  NE2 HIS B  64      40.200  23.491  52.994  1.00 75.52           N  
ATOM   1242  N   SER B  65      34.273  26.824  54.371  1.00 71.90           N  
ATOM   1243  CA  SER B  65      33.299  27.484  55.241  1.00 71.54           C  
ATOM   1244  C   SER B  65      31.888  26.904  55.082  1.00 71.14           C  
ATOM   1245  O   SER B  65      30.978  27.250  55.843  1.00 71.03           O  
ATOM   1246  CB  SER B  65      33.281  28.993  54.971  1.00 71.65           C  
ATOM   1247  OG  SER B  65      32.630  29.286  53.744  1.00 71.47           O  
ATOM   1248  N   ILE B  66      31.724  26.021  54.099  1.00 70.60           N  
ATOM   1249  CA  ILE B  66      30.428  25.427  53.767  1.00 70.32           C  
ATOM   1250  C   ILE B  66      30.050  24.270  54.692  1.00 70.03           C  
ATOM   1251  O   ILE B  66      30.815  23.325  54.872  1.00 69.88           O  
ATOM   1252  CB  ILE B  66      30.379  24.970  52.288  1.00 70.24           C  
ATOM   1253  CG1 ILE B  66      30.179  26.175  51.369  1.00 70.41           C  
ATOM   1254  CG2 ILE B  66      29.274  23.940  52.059  1.00 70.43           C  
ATOM   1255  CD1 ILE B  66      30.424  25.872  49.895  1.00 71.18           C  
ATOM   1256  N   THR B  67      28.852  24.363  55.261  1.00 69.77           N  
ATOM   1257  CA  THR B  67      28.309  23.319  56.122  1.00 69.65           C  
ATOM   1258  C   THR B  67      26.853  22.987  55.754  1.00 69.31           C  
ATOM   1259  O   THR B  67      26.238  23.677  54.940  1.00 68.93           O  
ATOM   1260  CB  THR B  67      28.405  23.732  57.599  1.00 69.77           C  
ATOM   1261  OG1 THR B  67      28.168  22.589  58.428  1.00 70.49           O  
ATOM   1262  CG2 THR B  67      27.395  24.841  57.929  1.00 70.01           C  
ATOM   1263  N   VAL B  68      26.311  21.926  56.352  1.00 69.00           N  
ATOM   1264  CA  VAL B  68      24.906  21.566  56.170  1.00 68.49           C  
ATOM   1265  C   VAL B  68      24.040  22.730  56.648  1.00 68.35           C  
ATOM   1266  O   VAL B  68      24.137  23.150  57.800  1.00 68.34           O  
ATOM   1267  CB  VAL B  68      24.536  20.268  56.928  1.00 68.46           C  
ATOM   1268  CG1 VAL B  68      23.036  19.982  56.823  1.00 68.14           C  
ATOM   1269  CG2 VAL B  68      25.339  19.092  56.395  1.00 68.11           C  
ATOM   1270  N   GLY B  69      23.226  23.269  55.746  1.00 68.06           N  
ATOM   1271  CA  GLY B  69      22.414  24.443  56.051  1.00 67.63           C  
ATOM   1272  C   GLY B  69      22.949  25.736  55.459  1.00 67.28           C  
ATOM   1273  O   GLY B  69      22.338  26.791  55.623  1.00 67.18           O  
ATOM   1274  N   SER B  70      24.098  25.662  54.788  1.00 66.92           N  
ATOM   1275  CA  SER B  70      24.655  26.814  54.073  1.00 66.91           C  
ATOM   1276  C   SER B  70      23.811  27.157  52.849  1.00 66.56           C  
ATOM   1277  O   SER B  70      23.435  26.271  52.087  1.00 66.17           O  
ATOM   1278  CB  SER B  70      26.090  26.542  53.623  1.00 66.91           C  
ATOM   1279  OG  SER B  70      26.932  26.289  54.730  1.00 67.66           O  
ATOM   1280  N   ARG B  71      23.525  28.447  52.685  1.00 66.51           N  
ATOM   1281  CA  ARG B  71      22.773  28.965  51.551  1.00 66.65           C  
ATOM   1282  C   ARG B  71      23.742  29.465  50.478  1.00 66.22           C  
ATOM   1283  O   ARG B  71      24.393  30.497  50.641  1.00 65.96           O  
ATOM   1284  CB  ARG B  71      21.831  30.099  51.989  1.00 66.85           C  
ATOM   1285  CG  ARG B  71      20.674  29.688  52.894  1.00 68.39           C  
ATOM   1286  CD  ARG B  71      19.584  28.937  52.116  1.00 72.13           C  
ATOM   1287  NE  ARG B  71      18.535  28.368  52.971  1.00 74.29           N  
ATOM   1288  CZ  ARG B  71      18.726  27.802  54.164  1.00 75.56           C  
ATOM   1289  NH1 ARG B  71      19.943  27.688  54.681  1.00 75.47           N  
ATOM   1290  NH2 ARG B  71      17.684  27.333  54.842  1.00 75.90           N  
ATOM   1291  N   ILE B  72      23.844  28.720  49.384  1.00 65.90           N  
ATOM   1292  CA  ILE B  72      24.769  29.082  48.316  1.00 65.51           C  
ATOM   1293  C   ILE B  72      24.081  29.209  46.952  1.00 65.59           C  
ATOM   1294  O   ILE B  72      23.062  28.562  46.705  1.00 65.00           O  
ATOM   1295  CB  ILE B  72      25.967  28.094  48.220  1.00 65.70           C  
ATOM   1296  CG1 ILE B  72      25.487  26.661  47.955  1.00 65.76           C  
ATOM   1297  CG2 ILE B  72      26.869  28.189  49.454  1.00 64.56           C  
ATOM   1298  CD1 ILE B  72      26.600  25.652  47.813  1.00 65.40           C  
ATOM   1299  N   THR B  73      24.631  30.073  46.094  1.00 65.65           N  
ATOM   1300  CA  THR B  73      24.298  30.083  44.670  1.00 65.84           C  
ATOM   1301  C   THR B  73      25.485  29.482  43.904  1.00 66.01           C  
ATOM   1302  O   THR B  73      26.636  29.888  44.093  1.00 66.22           O  
ATOM   1303  CB  THR B  73      23.957  31.490  44.135  1.00 65.70           C  
ATOM   1304  OG1 THR B  73      22.937  32.076  44.945  1.00 67.18           O  
ATOM   1305  CG2 THR B  73      23.444  31.431  42.696  1.00 65.62           C  
ATOM   1306  N   VAL B  74      25.188  28.504  43.058  1.00 65.92           N  
ATOM   1307  CA  VAL B  74      26.205  27.747  42.344  1.00 65.96           C  
ATOM   1308  C   VAL B  74      26.003  27.942  40.839  1.00 66.05           C  
ATOM   1309  O   VAL B  74      24.869  27.959  40.357  1.00 65.96           O  
ATOM   1310  CB  VAL B  74      26.154  26.238  42.723  1.00 65.59           C  
ATOM   1311  CG1 VAL B  74      27.200  25.451  41.975  1.00 66.84           C  
ATOM   1312  CG2 VAL B  74      26.397  26.050  44.208  1.00 65.60           C  
ATOM   1313  N   GLN B  75      27.110  28.085  40.114  1.00 66.21           N  
ATOM   1314  CA  GLN B  75      27.093  28.234  38.659  1.00 66.43           C  
ATOM   1315  C   GLN B  75      28.138  27.349  37.997  1.00 66.03           C  
ATOM   1316  O   GLN B  75      29.305  27.346  38.402  1.00 66.14           O  
ATOM   1317  CB  GLN B  75      27.331  29.692  38.263  1.00 66.28           C  
ATOM   1318  CG  GLN B  75      27.317  29.926  36.763  1.00 67.27           C  
ATOM   1319  CD  GLN B  75      27.555  31.374  36.392  1.00 67.19           C  
ATOM   1320  OE1 GLN B  75      27.332  32.278  37.198  1.00 68.92           O  
ATOM   1321  NE2 GLN B  75      28.010  31.601  35.166  1.00 67.12           N  
ATOM   1322  N   GLY B  76      27.709  26.610  36.978  1.00 65.76           N  
ATOM   1323  CA  GLY B  76      28.591  25.731  36.209  1.00 64.92           C  
ATOM   1324  C   GLY B  76      27.883  24.957  35.113  1.00 64.66           C  
ATOM   1325  O   GLY B  76      26.808  25.345  34.658  1.00 64.90           O  
ATOM   1326  N   PHE B  77      28.498  23.858  34.680  1.00 64.48           N  
ATOM   1327  CA  PHE B  77      27.911  22.983  33.658  1.00 63.58           C  
ATOM   1328  C   PHE B  77      27.440  21.648  34.249  1.00 63.42           C  
ATOM   1329  O   PHE B  77      28.020  21.140  35.203  1.00 63.00           O  
ATOM   1330  CB  PHE B  77      28.888  22.766  32.482  1.00 63.42           C  
ATOM   1331  CG  PHE B  77      30.096  21.940  32.831  1.00 63.29           C  
ATOM   1332  CD1 PHE B  77      30.062  20.548  32.734  1.00 61.19           C  
ATOM   1333  CD2 PHE B  77      31.274  22.555  33.262  1.00 63.35           C  
ATOM   1334  CE1 PHE B  77      31.169  19.788  33.071  1.00 60.87           C  
ATOM   1335  CE2 PHE B  77      32.396  21.796  33.595  1.00 62.59           C  
ATOM   1336  CZ  PHE B  77      32.344  20.411  33.488  1.00 62.18           C  
ATOM   1337  N   ILE B  78      26.385  21.088  33.665  1.00 63.12           N  
ATOM   1338  CA  ILE B  78      25.847  19.802  34.092  1.00 62.98           C  
ATOM   1339  C   ILE B  78      26.395  18.646  33.254  1.00 63.33           C  
ATOM   1340  O   ILE B  78      26.708  18.794  32.067  1.00 62.43           O  
ATOM   1341  CB  ILE B  78      24.271  19.767  34.085  1.00 63.40           C  
ATOM   1342  CG1 ILE B  78      23.698  19.958  32.667  1.00 62.91           C  
ATOM   1343  CG2 ILE B  78      23.696  20.796  35.066  1.00 63.58           C  
ATOM   1344  CD1 ILE B  78      22.207  19.580  32.516  1.00 62.96           C  
ATOM   1345  N   SER B  79      26.520  17.491  33.890  1.00 63.74           N  
ATOM   1346  CA  SER B  79      26.924  16.289  33.187  1.00 64.61           C  
ATOM   1347  C   SER B  79      26.310  15.061  33.820  1.00 65.06           C  
ATOM   1348  O   SER B  79      26.056  15.040  35.019  1.00 64.48           O  
ATOM   1349  CB  SER B  79      28.442  16.157  33.120  1.00 64.54           C  
ATOM   1350  OG  SER B  79      28.794  15.387  31.979  1.00 64.35           O  
ATOM   1351  N   CYS B  80      26.082  14.037  33.002  1.00 66.34           N  
ATOM   1352  CA  CYS B  80      25.335  12.868  33.434  1.00 66.67           C  
ATOM   1353  C   CYS B  80      26.074  11.536  33.316  1.00 66.89           C  
ATOM   1354  O   CYS B  80      26.775  11.265  32.330  1.00 66.53           O  
ATOM   1355  CB  CYS B  80      23.981  12.798  32.727  1.00 66.65           C  
ATOM   1356  SG  CYS B  80      23.289  11.130  32.705  1.00 69.06           S  
ATOM   1357  N   HIS B  81      25.876  10.706  34.336  1.00 67.28           N  
ATOM   1358  CA  HIS B  81      26.598   9.451  34.496  1.00 67.90           C  
ATOM   1359  C   HIS B  81      25.610   8.317  34.797  1.00 67.85           C  
ATOM   1360  O   HIS B  81      24.672   8.493  35.587  1.00 67.84           O  
ATOM   1361  CB  HIS B  81      27.639   9.589  35.614  1.00 68.01           C  
ATOM   1362  CG  HIS B  81      28.570  10.752  35.436  1.00 69.01           C  
ATOM   1363  ND1 HIS B  81      28.209  12.050  35.745  1.00 69.68           N  
ATOM   1364  CD2 HIS B  81      29.841  10.816  34.968  1.00 69.59           C  
ATOM   1365  CE1 HIS B  81      29.221  12.860  35.484  1.00 69.61           C  
ATOM   1366  NE2 HIS B  81      30.222  12.138  35.011  1.00 69.55           N  
ATOM   1367  N   LYS B  82      25.823   7.171  34.147  1.00 67.78           N  
ATOM   1368  CA  LYS B  82      24.933   6.000  34.237  1.00 67.96           C  
ATOM   1369  C   LYS B  82      23.491   6.301  33.824  1.00 67.91           C  
ATOM   1370  O   LYS B  82      23.176   6.361  32.635  1.00 67.79           O  
ATOM   1371  CB  LYS B  82      24.966   5.360  35.632  1.00 68.06           C  
ATOM   1372  CG  LYS B  82      26.196   4.499  35.903  1.00 68.64           C  
ATOM   1373  CD  LYS B  82      27.371   5.297  36.473  1.00 69.50           C  
ATOM   1374  CE  LYS B  82      27.168   5.623  37.951  1.00 70.16           C  
ATOM   1375  NZ  LYS B  82      28.466   5.706  38.680  1.00 70.22           N  
ATOM   1376  N   LYS B  89      22.490   9.410  36.709  1.00 74.90           N  
ATOM   1377  CA  LYS B  89      22.810  10.429  37.706  1.00 75.03           C  
ATOM   1378  C   LYS B  89      23.240  11.741  37.057  1.00 74.94           C  
ATOM   1379  O   LYS B  89      23.893  11.751  36.020  1.00 74.96           O  
ATOM   1380  CB  LYS B  89      23.919   9.955  38.651  1.00 75.01           C  
ATOM   1381  CG  LYS B  89      23.854   8.493  39.068  1.00 76.04           C  
ATOM   1382  CD  LYS B  89      22.734   8.205  40.064  1.00 76.90           C  
ATOM   1383  CE  LYS B  89      22.833   6.766  40.555  1.00 76.78           C  
ATOM   1384  NZ  LYS B  89      21.719   6.400  41.467  1.00 77.21           N  
ATOM   1385  N   MET B  90      22.881  12.848  37.693  1.00 74.69           N  
ATOM   1386  CA  MET B  90      23.262  14.168  37.221  1.00 74.86           C  
ATOM   1387  C   MET B  90      24.157  14.890  38.222  1.00 73.69           C  
ATOM   1388  O   MET B  90      23.817  14.988  39.404  1.00 74.08           O  
ATOM   1389  CB  MET B  90      22.018  15.012  36.969  1.00 74.71           C  
ATOM   1390  CG  MET B  90      21.414  14.853  35.593  1.00 75.98           C  
ATOM   1391  SD  MET B  90      20.884  16.458  34.950  1.00 77.67           S  
ATOM   1392  CE  MET B  90      21.941  17.557  35.889  1.00 77.11           C  
ATOM   1393  N   VAL B  91      25.298  15.395  37.754  1.00 72.29           N  
ATOM   1394  CA  VAL B  91      26.119  16.279  38.587  1.00 71.17           C  
ATOM   1395  C   VAL B  91      26.329  17.667  37.972  1.00 70.25           C  
ATOM   1396  O   VAL B  91      26.398  17.829  36.755  1.00 69.44           O  
ATOM   1397  CB  VAL B  91      27.469  15.628  39.062  1.00 71.22           C  
ATOM   1398  CG1 VAL B  91      27.215  14.291  39.776  1.00 71.59           C  
ATOM   1399  CG2 VAL B  91      28.443  15.436  37.919  1.00 72.04           C  
ATOM   1400  N   LEU B  92      26.403  18.664  38.842  1.00 69.67           N  
ATOM   1401  CA  LEU B  92      26.737  20.013  38.460  1.00 69.08           C  
ATOM   1402  C   LEU B  92      28.210  20.230  38.752  1.00 69.52           C  
ATOM   1403  O   LEU B  92      28.660  20.061  39.886  1.00 69.85           O  
ATOM   1404  CB  LEU B  92      25.895  21.010  39.256  1.00 69.06           C  
ATOM   1405  CG  LEU B  92      26.137  22.517  39.136  1.00 68.40           C  
ATOM   1406  CD1 LEU B  92      25.916  23.001  37.718  1.00 67.63           C  
ATOM   1407  CD2 LEU B  92      25.204  23.262  40.114  1.00 68.56           C  
ATOM   1408  N   HIS B  93      28.959  20.598  37.723  1.00 69.42           N  
ATOM   1409  CA  HIS B  93      30.359  20.925  37.896  1.00 69.63           C  
ATOM   1410  C   HIS B  93      30.517  22.418  38.091  1.00 69.76           C  
ATOM   1411  O   HIS B  93      30.376  23.202  37.152  1.00 69.28           O  
ATOM   1412  CB  HIS B  93      31.162  20.403  36.723  1.00 69.51           C  
ATOM   1413  CG  HIS B  93      31.281  18.913  36.709  1.00 69.59           C  
ATOM   1414  ND1 HIS B  93      32.398  18.251  37.171  1.00 68.71           N  
ATOM   1415  CD2 HIS B  93      30.408  17.956  36.317  1.00 68.79           C  
ATOM   1416  CE1 HIS B  93      32.215  16.950  37.051  1.00 68.75           C  
ATOM   1417  NE2 HIS B  93      31.018  16.744  36.534  1.00 69.87           N  
ATOM   1418  N   ALA B  94      30.782  22.791  39.336  1.00 70.12           N  
ATOM   1419  CA  ALA B  94      30.745  24.182  39.761  1.00 71.10           C  
ATOM   1420  C   ALA B  94      31.982  24.953  39.360  1.00 71.58           C  
ATOM   1421  O   ALA B  94      33.113  24.499  39.540  1.00 71.74           O  
ATOM   1422  CB  ALA B  94      30.509  24.295  41.261  1.00 70.82           C  
ATOM   1423  N   GLU B  95      31.722  26.132  38.812  1.00 72.39           N  
ATOM   1424  CA  GLU B  95      32.730  27.058  38.339  1.00 73.47           C  
ATOM   1425  C   GLU B  95      32.779  28.215  39.341  1.00 73.56           C  
ATOM   1426  O   GLU B  95      33.833  28.510  39.910  1.00 73.48           O  
ATOM   1427  CB  GLU B  95      32.325  27.536  36.941  1.00 73.42           C  
ATOM   1428  CG  GLU B  95      33.295  28.453  36.248  1.00 75.90           C  
ATOM   1429  CD  GLU B  95      32.649  29.197  35.088  1.00 79.03           C  
ATOM   1430  OE1 GLU B  95      33.308  30.102  34.527  1.00 79.89           O  
ATOM   1431  OE2 GLU B  95      31.482  28.886  34.745  1.00 80.16           O  
ATOM   1432  N   GLN B  96      31.618  28.838  39.555  1.00 73.83           N  
ATOM   1433  CA  GLN B  96      31.428  29.909  40.526  1.00 74.19           C  
ATOM   1434  C   GLN B  96      30.643  29.373  41.716  1.00 74.22           C  
ATOM   1435  O   GLN B  96      29.752  28.539  41.558  1.00 74.40           O  
ATOM   1436  CB  GLN B  96      30.656  31.084  39.904  1.00 74.29           C  
ATOM   1437  CG  GLN B  96      31.492  32.070  39.081  1.00 75.88           C  
ATOM   1438  CD  GLN B  96      31.710  31.633  37.631  1.00 77.56           C  
ATOM   1439  OE1 GLN B  96      32.837  31.642  37.132  1.00 78.50           O  
ATOM   1440  NE2 GLN B  96      30.633  31.263  36.948  1.00 78.31           N  
ATOM   1441  N   ILE B  97      30.972  29.862  42.905  1.00 74.15           N  
ATOM   1442  CA  ILE B  97      30.240  29.505  44.116  1.00 74.15           C  
ATOM   1443  C   ILE B  97      30.231  30.687  45.092  1.00 74.05           C  
ATOM   1444  O   ILE B  97      31.286  31.185  45.487  1.00 74.02           O  
ATOM   1445  CB  ILE B  97      30.763  28.172  44.753  1.00 74.08           C  
ATOM   1446  CG1 ILE B  97      29.838  27.712  45.875  1.00 74.96           C  
ATOM   1447  CG2 ILE B  97      32.209  28.295  45.236  1.00 73.83           C  
ATOM   1448  CD1 ILE B  97      29.931  26.231  46.173  1.00 76.75           C  
ATOM   1449  N   GLU B  98      29.032  31.154  45.435  1.00 74.04           N  
ATOM   1450  CA  GLU B  98      28.862  32.293  46.337  1.00 74.44           C  
ATOM   1451  C   GLU B  98      28.047  31.887  47.553  1.00 74.45           C  
ATOM   1452  O   GLU B  98      27.068  31.157  47.432  1.00 74.46           O  
ATOM   1453  CB  GLU B  98      28.131  33.449  45.649  1.00 74.53           C  
ATOM   1454  CG  GLU B  98      28.513  33.711  44.203  1.00 75.14           C  
ATOM   1455  CD  GLU B  98      27.412  34.439  43.451  1.00 75.78           C  
ATOM   1456  OE1 GLU B  98      27.089  35.596  43.819  1.00 75.30           O  
ATOM   1457  OE2 GLU B  98      26.870  33.849  42.491  1.00 74.80           O  
ATOM   1458  N   LEU B  99      28.450  32.369  48.722  1.00 74.53           N  
ATOM   1459  CA  LEU B  99      27.655  32.209  49.930  1.00 74.66           C  
ATOM   1460  C   LEU B  99      26.607  33.318  49.961  1.00 74.67           C  
ATOM   1461  O   LEU B  99      26.945  34.486  50.160  1.00 74.58           O  
ATOM   1462  CB  LEU B  99      28.549  32.255  51.177  1.00 74.56           C  
ATOM   1463  CG  LEU B  99      29.099  30.931  51.725  1.00 74.56           C  
ATOM   1464  CD1 LEU B  99      29.977  30.187  50.721  1.00 74.38           C  
ATOM   1465  CD2 LEU B  99      29.862  31.177  53.011  1.00 74.83           C  
ATOM   1466  N   ILE B 100      25.344  32.955  49.738  1.00 74.77           N  
ATOM   1467  CA  ILE B 100      24.262  33.939  49.693  1.00 75.05           C  
ATOM   1468  C   ILE B 100      23.608  34.156  51.056  1.00 75.06           C  
ATOM   1469  O   ILE B 100      24.261  34.589  52.006  1.00 74.93           O  
ATOM   1470  CB  ILE B 100      23.204  33.593  48.621  1.00 75.24           C  
ATOM   1471  CG1 ILE B 100      22.573  34.876  48.069  1.00 75.72           C  
ATOM   1472  CG2 ILE B 100      22.153  32.614  49.164  1.00 75.29           C  
ATOM   1473  CD1 ILE B 100      22.136  34.775  46.606  1.00 75.77           C  
TER    1474      ILE B 100                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
