
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  820),  selected  110 , name 1x3e_A
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1x3e_A.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_A      -       -           -
LGA    D     4_A      M       1          3.027
LGA    T     5_A      N       2          0.953
LGA    T     6_A      T       3          0.250
LGA    I     7_A      L       4          0.672
LGA    T     8_A      E       5          0.381
LGA    V     9_A      L       6          0.607
LGA    V    10_A      S       7          0.427
LGA    G    11_A      A       8          0.919
LGA    N    12_A      R       9          0.580
LGA    L    13_A      V      10          0.919
LGA    T    14_A      L      11          1.029
LGA    A    15_A      E      12          1.176
LGA    D    16_A      C      13          2.472
LGA    P    17_A      G      14          3.637
LGA    E    18_A      A      15          2.818
LGA    L    19_A      M      16          1.458
LGA    R    20_A      R      17          0.593
LGA    F    21_A      H      18          0.922
LGA    T    22_A      T      19          1.466
LGA    P    23_A      P      20          2.514
LGA    S    24_A      A      21          2.383
LGA    G    25_A      G      22          1.406
LGA    A    26_A      L      23          1.268
LGA    A    27_A      P      24          0.535
LGA    V    28_A      A      25          0.470
LGA    A    29_A      L      26          0.868
LGA    N    30_A      E      27          0.759
LGA    F    31_A      L      28          0.439
LGA    T    32_A      L      29          1.468
LGA    V    33_A      L      30          1.092
LGA    A    34_A      V      31          0.395
LGA    S    35_A      H      32          0.233
LGA    T    36_A      E      33          1.426
LGA    P    37_A      S      34          1.461
LGA    R    38_A      -       -           -
LGA    M    39_A      E      35          4.964
LGA    E    46_A      V      36           -
LGA    W    47_A      V      37           -
LGA    K    48_A      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    -       -      P      42           -
LGA    D    49_A      R      43           #
LGA    G    50_A      R      44          2.098
LGA    E    51_A      V      45          3.485
LGA    A    52_A      E      46          1.594
LGA    L    53_A      L      47          0.932
LGA    F    54_A      T      48          1.128
LGA    L    55_A      I      49          1.568
LGA    R    56_A      S      50          1.117
LGA    C    57_A      A      51          0.787
LGA    N    58_A      V      52          0.848
LGA    I    59_A      A      53          1.211
LGA    W    60_A      L      54          1.212
LGA    R    61_A      G      55          1.273
LGA    E    62_A      D      56          2.560
LGA    A    63_A      L      57          2.107
LGA    A    64_A      A      58          0.768
LGA    E    65_A      L      59          1.421
LGA    N    66_A      L      60          1.677
LGA    V    67_A      L      61          0.794
LGA    A    68_A      A      62          0.382
LGA    E    69_A      D      63          4.233
LGA    S    70_A      -       -           -
LGA    L    71_A      T      64          1.361
LGA    T    72_A      P      65          2.001
LGA    R    73_A      L      66          1.292
LGA    G    74_A      G      67          0.808
LGA    S    75_A      T      68          0.761
LGA    R    76_A      E      69          0.570
LGA    V    77_A      M      70          0.223
LGA    I    78_A      Q      71          0.356
LGA    V    79_A      V      72          0.569
LGA    T    80_A      Q      73          0.539
LGA    G    81_A      G      74          0.533
LGA    R    82_A      F      75          0.829
LGA    L    83_A      L      76          1.585
LGA    K    84_A      A      77          1.624
LGA    Q    85_A      P      78          2.543
LGA    R    86_A      A      79          4.803
LGA    -       -      R      80           -
LGA    -       -      K      81           -
LGA    S    87_A      D      82          2.816
LGA    F    88_A      S      83          3.575
LGA    E    89_A      -       -           -
LGA    T    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    E    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    R    96_A      -       -           -
LGA    T    97_A      V      84          1.617
LGA    V    98_A      K      85          0.802
LGA    V    99_A      V      86          0.597
LGA    E   100_A      K      87          1.015
LGA    V   101_A      L      88          1.156
LGA    E   102_A      H      89          1.110
LGA    V   103_A      L      90          0.630
LGA    D   104_A      Q      91          0.718
LGA    E   105_A      Q      92          0.667
LGA    I   106_A      A      93          0.455
LGA    G   107_A      R      94          0.800
LGA    P   108_A      R      95          1.047
LGA    S   109_A      I      96          1.824
LGA    L   110_A      A      97          3.994
LGA    R   111_A      -       -           -
LGA    Y   112_A      -       -           -
LGA    A   113_A      G      98          0.761
LGA    T   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    K   116_A      -       -           -
LGA    V   117_A      -       -           -
LGA    N   118_A      -       -           -
LGA    K   119_A      -       -           -
LGA    A   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   98    5.0     88    1.72    14.77     83.145     4.829

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.580178 * X  +  -0.453248 * Y  +  -0.676728 * Z  +  50.842426
  Y_new =  -0.659027 * X  +  -0.749474 * Y  +  -0.063032 * Z  +  63.959957
  Z_new =  -0.478621 * X  +   0.482551 * Y  +  -0.733530 * Z  +  56.476955 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.559721   -0.581872  [ DEG:   146.6612    -33.3388 ]
  Theta =   0.499083    2.642509  [ DEG:    28.5954    151.4046 ]
  Phi   =  -0.848941    2.292651  [ DEG:   -48.6407    131.3593 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x3e_A                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x3e_A.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   98   5.0   88   1.72   14.77  83.145
REMARK  ---------------------------------------------------------- 
MOLECULE 1x3e_A
HEADER    DNA BINDING PROTEIN                     04-MAY-05   1X3E              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM SMEGMATIS                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN, SSB, HELIX-            
COMPND   5 DESTABILIZING PROTEIN;                                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM SMEGMATIS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET17B                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,G.P.MANJUNATH,P.SINGH,J.JEYAKANTHAN,Z.DAUTER,           
AUTHOR   2 K.SEKAR,K.MUNIYAPPA,M.VIJAYAN                                        
REVDAT   1   15-AUG-05 1X3E    0                                                
JRNL        AUTH   K.SAIKRISHNAN,G.P.MANJUNATH,P.SINGH,J.JEYAKANTHAN,           
JRNL        AUTH 2 Z.DAUTER,K.SEKAR,K.MUNIYAPPA,M.VIJAYAN                       
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM SMEGMATIS                         
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN AND A                    
JRNL        TITL 3 COMPARATIVE STUDY INVOLVING HOMOLOGUS SSBS:                  
JRNL        TITL 4 BIOLOGICAL IMPLICATIONS OF STRUCTURAL PLASTICITY             
JRNL        TITL 5 AND VARIABILITY IN QUATERNARY ASSOCIATION.                   
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  61  1140 2005              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.15 ANGSTROMS.                                          
DBREF  1X3E A    1   165  UNP    Q9AFI5   SSB_MYCSM        1    165             
DBREF  1X3E B    1   165  UNP    Q9AFI5   SSB_MYCSM        1    165             
SEQRES   1 A  165  MET ALA GLY ASP THR THR ILE THR VAL VAL GLY ASN LEU          
SEQRES   2 A  165  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  165  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG MET          
SEQRES   4 A  165  PHE ASP ARG GLN SER GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  165  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  165  ASN VAL ALA GLU SER LEU THR ARG GLY SER ARG VAL ILE          
SEQRES   7 A  165  VAL THR GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  165  GLU GLY GLU LYS ARG THR VAL VAL GLU VAL GLU VAL ASP          
SEQRES   9 A  165  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  165  ASN LYS ALA SER ARG SER GLY GLY GLY GLY GLY GLY PHE          
SEQRES  11 A  165  GLY SER GLY GLY GLY GLY SER ARG GLN SER GLU PRO LYS          
SEQRES  12 A  165  ASP ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE          
SEQRES  13 A  165  SER GLY ALA ASP ASP GLU PRO PRO PHE                          
SEQRES   1 B  165  MET ALA GLY ASP THR THR ILE THR VAL VAL GLY ASN LEU          
SEQRES   2 B  165  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  165  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG MET          
SEQRES   4 B  165  PHE ASP ARG GLN SER GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  165  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  165  ASN VAL ALA GLU SER LEU THR ARG GLY SER ARG VAL ILE          
SEQRES   7 B  165  VAL THR GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  165  GLU GLY GLU LYS ARG THR VAL VAL GLU VAL GLU VAL ASP          
SEQRES   9 B  165  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  165  ASN LYS ALA SER ARG SER GLY GLY GLY GLY GLY GLY PHE          
SEQRES  11 B  165  GLY SER GLY GLY GLY GLY SER ARG GLN SER GLU PRO LYS          
SEQRES  12 B  165  ASP ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE          
SEQRES  13 B  165  SER GLY ALA ASP ASP GLU PRO PRO PHE                          
HET     CD   1001       1                                                       
HETNAM      CD CADMIUM ION                                                      
FORMUL   3   CD    CD 2+                                                        
FORMUL   4  HOH   *243(H2 O)                                                    
CRYST1   78.620   78.620   79.834  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   GLY A   3      28.499  26.310  23.491  1.00 30.46           N  
ATOM      2  CA  GLY A   3      27.588  25.162  23.214  1.00 30.82           C  
ATOM      3  C   GLY A   3      27.273  24.416  24.502  1.00 30.50           C  
ATOM      4  O   GLY A   3      26.444  23.493  24.511  1.00 30.57           O  
ATOM      5  N   ASP A   4      27.946  24.816  25.584  1.00 29.97           N  
ATOM      6  CA  ASP A   4      27.744  24.203  26.876  1.00 30.02           C  
ATOM      7  C   ASP A   4      26.524  24.814  27.485  1.00 28.42           C  
ATOM      8  O   ASP A   4      26.363  26.032  27.447  1.00 29.54           O  
ATOM      9  CB  ASP A   4      28.915  24.453  27.831  1.00 31.07           C  
ATOM     10  CG  ASP A   4      29.979  23.374  27.752  1.00 34.60           C  
ATOM     11  OD1 ASP A   4      31.027  23.539  28.427  1.00 40.36           O  
ATOM     12  OD2 ASP A   4      29.878  22.343  27.039  1.00 38.04           O  
ATOM     13  N   THR A   5      25.718  23.960  28.106  1.00 25.90           N  
ATOM     14  CA  THR A   5      24.501  24.363  28.757  1.00 24.05           C  
ATOM     15  C   THR A   5      24.872  24.803  30.138  1.00 24.10           C  
ATOM     16  O   THR A   5      25.397  24.031  30.898  1.00 23.30           O  
ATOM     17  CB  THR A   5      23.529  23.188  28.802  1.00 23.80           C  
ATOM     18  OG1 THR A   5      23.250  22.731  27.466  1.00 22.90           O  
ATOM     19  CG2 THR A   5      22.177  23.608  29.395  1.00 22.44           C  
ATOM     20  N   THR A   6      24.617  26.058  30.457  1.00 24.33           N  
ATOM     21  CA  THR A   6      24.916  26.554  31.780  1.00 25.47           C  
ATOM     22  C   THR A   6      23.648  26.665  32.643  1.00 25.65           C  
ATOM     23  O   THR A   6      22.529  26.724  32.152  1.00 25.05           O  
ATOM     24  CB  THR A   6      25.607  27.912  31.725  1.00 25.53           C  
ATOM     25  OG1 THR A   6      24.716  28.892  31.173  1.00 28.77           O  
ATOM     26  CG2 THR A   6      26.801  27.884  30.774  1.00 25.93           C  
ATOM     27  N   ILE A   7      23.869  26.687  33.946  1.00 25.42           N  
ATOM     28  CA  ILE A   7      22.809  26.771  34.898  1.00 26.06           C  
ATOM     29  C   ILE A   7      23.278  27.549  36.103  1.00 25.45           C  
ATOM     30  O   ILE A   7      24.468  27.525  36.472  1.00 24.16           O  
ATOM     31  CB  ILE A   7      22.366  25.340  35.290  1.00 27.78           C  
ATOM     32  CG1 ILE A   7      21.151  25.368  36.211  1.00 29.78           C  
ATOM     33  CG2 ILE A   7      23.497  24.567  35.963  1.00 27.02           C  
ATOM     34  CD1 ILE A   7      20.602  24.017  36.426  1.00 31.86           C  
ATOM     35  N   THR A   8      22.340  28.283  36.685  1.00 25.24           N  
ATOM     36  CA  THR A   8      22.526  28.933  37.959  1.00 25.62           C  
ATOM     37  C   THR A   8      21.516  28.300  38.898  1.00 26.16           C  
ATOM     38  O   THR A   8      20.336  28.194  38.566  1.00 26.14           O  
ATOM     39  CB  THR A   8      22.289  30.437  37.871  1.00 26.11           C  
ATOM     40  OG1 THR A   8      23.329  31.051  37.111  1.00 23.64           O  
ATOM     41  CG2 THR A   8      22.453  31.107  39.287  1.00 27.71           C  
ATOM     42  N   VAL A   9      21.983  27.819  40.047  1.00 26.08           N  
ATOM     43  CA  VAL A   9      21.080  27.327  41.079  1.00 26.11           C  
ATOM     44  C   VAL A   9      21.349  27.958  42.441  1.00 25.94           C  
ATOM     45  O   VAL A   9      22.502  28.153  42.845  1.00 24.69           O  
ATOM     46  CB  VAL A   9      21.074  25.783  41.160  1.00 26.89           C  
ATOM     47  CG1 VAL A   9      22.415  25.212  41.571  1.00 28.76           C  
ATOM     48  CG2 VAL A   9      20.015  25.331  42.135  1.00 28.87           C  
ATOM     49  N   VAL A  10      20.253  28.286  43.125  1.00 25.20           N  
ATOM     50  CA  VAL A  10      20.276  28.819  44.479  1.00 25.82           C  
ATOM     51  C   VAL A  10      19.633  27.770  45.404  1.00 25.63           C  
ATOM     52  O   VAL A  10      18.517  27.309  45.164  1.00 26.29           O  
ATOM     53  CB  VAL A  10      19.493  30.178  44.580  1.00 25.71           C  
ATOM     54  CG1 VAL A  10      19.521  30.762  46.021  1.00 26.60           C  
ATOM     55  CG2 VAL A  10      20.052  31.217  43.570  1.00 27.06           C  
ATOM     56  N   GLY A  11      20.316  27.410  46.473  1.00 25.37           N  
ATOM     57  CA  GLY A  11      19.712  26.493  47.432  1.00 25.18           C  
ATOM     58  C   GLY A  11      20.610  26.218  48.606  1.00 24.37           C  
ATOM     59  O   GLY A  11      21.554  26.955  48.821  1.00 23.97           O  
ATOM     60  N   ASN A  12      20.297  25.178  49.369  1.00 24.07           N  
ATOM     61  CA  ASN A  12      21.032  24.844  50.579  1.00 24.02           C  
ATOM     62  C   ASN A  12      21.780  23.517  50.481  1.00 23.72           C  
ATOM     63  O   ASN A  12      21.265  22.536  49.936  1.00 23.28           O  
ATOM     64  CB  ASN A  12      20.086  24.814  51.778  1.00 24.38           C  
ATOM     65  CG  ASN A  12      19.389  26.137  51.992  1.00 25.94           C  
ATOM     66  OD1 ASN A  12      18.310  26.333  51.483  1.00 30.81           O  
ATOM     67  ND2 ASN A  12      20.016  27.059  52.726  1.00 25.75           N  
ATOM     68  N   LEU A  13      23.010  23.480  51.000  1.00 23.19           N  
ATOM     69  CA  LEU A  13      23.779  22.247  50.935  1.00 23.62           C  
ATOM     70  C   LEU A  13      23.018  21.207  51.726  1.00 23.27           C  
ATOM     71  O   LEU A  13      22.558  21.505  52.843  1.00 21.95           O  
ATOM     72  CB  LEU A  13      25.170  22.418  51.536  1.00 23.72           C  
ATOM     73  CG  LEU A  13      26.169  23.325  50.818  1.00 25.92           C  
ATOM     74  CD1 LEU A  13      27.540  22.906  51.179  1.00 26.28           C  
ATOM     75  CD2 LEU A  13      26.010  23.343  49.305  1.00 27.18           C  
ATOM     76  N   THR A  14      22.890  19.996  51.187  1.00 23.17           N  
ATOM     77  CA  THR A  14      22.195  18.947  51.937  1.00 24.08           C  
ATOM     78  C   THR A  14      23.100  18.401  53.021  1.00 24.51           C  
ATOM     79  O   THR A  14      22.638  17.743  53.955  1.00 24.88           O  
ATOM     80  CB  THR A  14      21.778  17.776  51.060  1.00 24.05           C  
ATOM     81  OG1 THR A  14      22.962  17.207  50.453  1.00 25.27           O  
ATOM     82  CG2 THR A  14      20.879  18.232  49.890  1.00 24.03           C  
ATOM     83  N   ALA A  15      24.397  18.599  52.846  1.00 25.37           N  
ATOM     84  CA  ALA A  15      25.394  18.080  53.787  1.00 25.77           C  
ATOM     85  C   ALA A  15      26.656  18.855  53.602  1.00 25.90           C  
ATOM     86  O   ALA A  15      26.821  19.531  52.580  1.00 25.89           O  
ATOM     87  CB  ALA A  15      25.659  16.584  53.546  1.00 26.29           C  
ATOM     88  N   ASP A  16      27.530  18.762  54.601  1.00 25.63           N  
ATOM     89  CA  ASP A  16      28.843  19.369  54.556  1.00 26.27           C  
ATOM     90  C   ASP A  16      29.573  18.887  53.299  1.00 26.20           C  
ATOM     91  O   ASP A  16      29.474  17.704  52.936  1.00 26.06           O  
ATOM     92  CB  ASP A  16      29.669  18.961  55.782  1.00 26.51           C  
ATOM     93  CG  ASP A  16      29.084  19.478  57.076  1.00 27.15           C  
ATOM     94  OD1 ASP A  16      28.612  20.623  57.099  1.00 24.68           O  
ATOM     95  OD2 ASP A  16      29.079  18.815  58.136  1.00 31.66           O  
ATOM     96  N   PRO A  17      30.293  19.787  52.638  1.00 26.13           N  
ATOM     97  CA  PRO A  17      31.048  19.411  51.435  1.00 26.69           C  
ATOM     98  C   PRO A  17      32.098  18.341  51.791  1.00 26.81           C  
ATOM     99  O   PRO A  17      32.685  18.404  52.882  1.00 26.09           O  
ATOM    100  CB  PRO A  17      31.720  20.728  50.983  1.00 26.86           C  
ATOM    101  CG  PRO A  17      31.069  21.839  51.769  1.00 27.21           C  
ATOM    102  CD  PRO A  17      30.469  21.208  52.991  1.00 26.59           C  
ATOM    103  N   GLU A  18      32.286  17.364  50.909  1.00 26.70           N  
ATOM    104  CA  GLU A  18      33.275  16.308  51.122  1.00 27.02           C  
ATOM    105  C   GLU A  18      34.499  16.650  50.285  1.00 26.60           C  
ATOM    106  O   GLU A  18      34.430  16.650  49.047  1.00 26.74           O  
ATOM    107  CB  GLU A  18      32.730  14.929  50.703  1.00 27.71           C  
ATOM    108  CG  GLU A  18      31.473  14.477  51.453  1.00 30.99           C  
ATOM    109  CD  GLU A  18      30.773  13.233  50.862  1.00 34.52           C  
ATOM    110  OE1 GLU A  18      29.693  12.838  51.398  1.00 35.43           O  
ATOM    111  OE2 GLU A  18      31.280  12.629  49.875  1.00 35.30           O  
ATOM    112  N   LEU A  19      35.604  16.963  50.956  1.00 26.07           N  
ATOM    113  CA  LEU A  19      36.867  17.273  50.295  1.00 26.17           C  
ATOM    114  C   LEU A  19      37.767  16.045  50.172  1.00 26.72           C  
ATOM    115  O   LEU A  19      38.032  15.331  51.158  1.00 26.24           O  
ATOM    116  CB  LEU A  19      37.620  18.367  51.056  1.00 25.71           C  
ATOM    117  CG  LEU A  19      38.953  18.839  50.464  1.00 24.84           C  
ATOM    118  CD1 LEU A  19      38.700  19.678  49.224  1.00 24.94           C  
ATOM    119  CD2 LEU A  19      39.773  19.630  51.494  1.00 23.81           C  
ATOM    120  N   ARG A  20      38.249  15.825  48.957  1.00 27.27           N  
ATOM    121  CA  ARG A  20      39.239  14.787  48.691  1.00 28.05           C  
ATOM    122  C   ARG A  20      40.373  15.283  47.812  1.00 28.11           C  
ATOM    123  O   ARG A  20      40.366  16.406  47.338  1.00 27.80           O  
ATOM    124  CB  ARG A  20      38.582  13.639  47.973  1.00 28.49           C  
ATOM    125  CG  ARG A  20      37.411  13.049  48.670  1.00 29.91           C  
ATOM    126  CD  ARG A  20      36.782  11.966  47.821  1.00 32.76           C  
ATOM    127  NE  ARG A  20      35.362  11.790  48.063  1.00 34.05           N  
ATOM    128  CZ  ARG A  20      34.432  12.716  47.871  1.00 34.72           C  
ATOM    129  NH1 ARG A  20      34.718  13.953  47.420  1.00 34.12           N  
ATOM    130  NH2 ARG A  20      33.175  12.386  48.122  1.00 35.93           N  
ATOM    131  N   PHE A  21      41.352  14.415  47.600  1.00 29.05           N  
ATOM    132  CA  PHE A  21      42.474  14.692  46.699  1.00 29.27           C  
ATOM    133  C   PHE A  21      42.622  13.531  45.723  1.00 28.97           C  
ATOM    134  O   PHE A  21      42.613  12.378  46.123  1.00 29.63           O  
ATOM    135  CB  PHE A  21      43.737  14.959  47.508  1.00 28.77           C  
ATOM    136  CG  PHE A  21      43.617  16.172  48.384  1.00 30.25           C  
ATOM    137  CD1 PHE A  21      43.059  16.076  49.647  1.00 31.45           C  
ATOM    138  CD2 PHE A  21      43.997  17.433  47.920  1.00 30.72           C  
ATOM    139  CE1 PHE A  21      42.908  17.219  50.448  1.00 31.01           C  
ATOM    140  CE2 PHE A  21      43.855  18.565  48.708  1.00 29.90           C  
ATOM    141  CZ  PHE A  21      43.302  18.463  49.968  1.00 30.37           C  
ATOM    142  N   THR A  22      42.684  13.830  44.433  1.00 28.69           N  
ATOM    143  CA  THR A  22      42.879  12.785  43.441  1.00 28.50           C  
ATOM    144  C   THR A  22      44.214  12.131  43.772  1.00 28.37           C  
ATOM    145  O   THR A  22      45.014  12.713  44.502  1.00 28.13           O  
ATOM    146  CB  THR A  22      42.928  13.373  42.024  1.00 28.45           C  
ATOM    147  OG1 THR A  22      44.041  14.264  41.920  1.00 28.66           O  
ATOM    148  CG2 THR A  22      41.717  14.255  41.734  1.00 28.24           C  
ATOM    149  N   PRO A  23      44.478  10.936  43.255  1.00 28.44           N  
ATOM    150  CA  PRO A  23      45.811  10.343  43.419  1.00 28.55           C  
ATOM    151  C   PRO A  23      46.927  11.315  42.974  1.00 28.55           C  
ATOM    152  O   PRO A  23      48.028  11.275  43.528  1.00 28.38           O  
ATOM    153  CB  PRO A  23      45.750   9.089  42.531  1.00 28.59           C  
ATOM    154  CG  PRO A  23      44.295   8.734  42.483  1.00 28.59           C  
ATOM    155  CD  PRO A  23      43.566  10.053  42.504  1.00 28.45           C  
ATOM    156  N   SER A  24      46.613  12.185  42.011  1.00 28.53           N  
ATOM    157  CA  SER A  24      47.543  13.201  41.501  1.00 28.48           C  
ATOM    158  C   SER A  24      47.889  14.300  42.512  1.00 28.13           C  
ATOM    159  O   SER A  24      48.953  14.912  42.430  1.00 28.39           O  
ATOM    160  CB  SER A  24      46.959  13.857  40.243  1.00 28.70           C  
ATOM    161  OG  SER A  24      46.526  12.888  39.298  1.00 29.11           O  
ATOM    162  N   GLY A  25      46.989  14.551  43.452  1.00 27.57           N  
ATOM    163  CA  GLY A  25      47.193  15.555  44.484  1.00 27.34           C  
ATOM    164  C   GLY A  25      46.228  16.730  44.371  1.00 27.23           C  
ATOM    165  O   GLY A  25      46.295  17.668  45.172  1.00 27.15           O  
ATOM    166  N   ALA A  26      45.328  16.667  43.385  1.00 26.94           N  
ATOM    167  CA  ALA A  26      44.387  17.738  43.082  1.00 26.42           C  
ATOM    168  C   ALA A  26      43.198  17.688  44.019  1.00 25.90           C  
ATOM    169  O   ALA A  26      42.603  16.632  44.236  1.00 25.87           O  
ATOM    170  CB  ALA A  26      43.907  17.627  41.645  1.00 26.66           C  
ATOM    171  N   ALA A  27      42.832  18.846  44.544  1.00 24.82           N  
ATOM    172  CA  ALA A  27      41.734  18.937  45.489  1.00 24.30           C  
ATOM    173  C   ALA A  27      40.418  18.902  44.729  1.00 23.45           C  
ATOM    174  O   ALA A  27      40.284  19.539  43.688  1.00 23.82           O  
ATOM    175  CB  ALA A  27      41.845  20.201  46.292  1.00 24.12           C  
ATOM    176  N   VAL A  28      39.458  18.140  45.235  1.00 22.45           N  
ATOM    177  CA  VAL A  28      38.111  18.134  44.672  1.00 21.93           C  
ATOM    178  C   VAL A  28      37.080  18.149  45.801  1.00 22.27           C  
ATOM    179  O   VAL A  28      37.274  17.505  46.832  1.00 21.30           O  
ATOM    180  CB  VAL A  28      37.892  16.924  43.739  1.00 21.65           C  
ATOM    181  CG1 VAL A  28      38.003  15.601  44.490  1.00 20.91           C  
ATOM    182  CG2 VAL A  28      36.564  17.043  43.064  1.00 23.95           C  
ATOM    183  N   ALA A  29      36.002  18.915  45.612  1.00 22.77           N  
ATOM    184  CA  ALA A  29      34.893  18.956  46.559  1.00 23.42           C  
ATOM    185  C   ALA A  29      33.589  18.529  45.915  1.00 23.81           C  
ATOM    186  O   ALA A  29      33.238  18.986  44.829  1.00 24.99           O  
ATOM    187  CB  ALA A  29      34.725  20.356  47.122  1.00 23.58           C  
ATOM    188  N   ASN A  30      32.840  17.698  46.622  1.00 23.47           N  
ATOM    189  CA  ASN A  30      31.529  17.305  46.185  1.00 23.43           C  
ATOM    190  C   ASN A  30      30.497  17.773  47.201  1.00 23.94           C  
ATOM    191  O   ASN A  30      30.690  17.636  48.402  1.00 23.79           O  
ATOM    192  CB  ASN A  30      31.473  15.786  46.020  1.00 22.84           C  
ATOM    193  CG  ASN A  30      32.172  15.329  44.789  1.00 21.63           C  
ATOM    194  OD1 ASN A  30      33.381  15.089  44.798  1.00 20.01           O  
ATOM    195  ND2 ASN A  30      31.433  15.221  43.708  1.00 21.87           N  
ATOM    196  N   PHE A  31      29.409  18.323  46.696  1.00 24.06           N  
ATOM    197  CA  PHE A  31      28.284  18.710  47.522  1.00 24.82           C  
ATOM    198  C   PHE A  31      27.010  18.689  46.686  1.00 25.02           C  
ATOM    199  O   PHE A  31      27.053  18.801  45.475  1.00 24.98           O  
ATOM    200  CB  PHE A  31      28.507  20.120  48.122  1.00 24.70           C  
ATOM    201  CG  PHE A  31      28.937  21.172  47.110  1.00 24.00           C  
ATOM    202  CD1 PHE A  31      30.266  21.347  46.800  1.00 24.87           C  
ATOM    203  CD2 PHE A  31      28.010  22.004  46.513  1.00 24.70           C  
ATOM    204  CE1 PHE A  31      30.661  22.324  45.874  1.00 26.14           C  
ATOM    205  CE2 PHE A  31      28.382  22.956  45.596  1.00 25.39           C  
ATOM    206  CZ  PHE A  31      29.718  23.131  45.290  1.00 26.05           C  
ATOM    207  N   THR A  32      25.866  18.604  47.350  1.00 25.78           N  
ATOM    208  CA  THR A  32      24.604  18.638  46.667  1.00 25.16           C  
ATOM    209  C   THR A  32      23.802  19.827  47.109  1.00 25.38           C  
ATOM    210  O   THR A  32      23.614  20.046  48.287  1.00 26.06           O  
ATOM    211  CB  THR A  32      23.834  17.323  46.910  1.00 26.01           C  
ATOM    212  OG1 THR A  32      24.516  16.228  46.262  1.00 24.63           O  
ATOM    213  CG2 THR A  32      22.408  17.374  46.238  1.00 23.35           C  
ATOM    214  N   VAL A  33      23.297  20.586  46.146  1.00 25.33           N  
ATOM    215  CA  VAL A  33      22.456  21.741  46.427  1.00 25.73           C  
ATOM    216  C   VAL A  33      20.967  21.361  46.342  1.00 25.24           C  
ATOM    217  O   VAL A  33      20.503  20.878  45.309  1.00 24.39           O  
ATOM    218  CB  VAL A  33      22.750  22.908  45.461  1.00 25.56           C  
ATOM    219  CG1 VAL A  33      21.838  24.069  45.722  1.00 26.14           C  
ATOM    220  CG2 VAL A  33      24.199  23.333  45.564  1.00 26.77           C  
ATOM    221  N   ALA A  34      20.245  21.564  47.443  1.00 24.50           N  
ATOM    222  CA  ALA A  34      18.795  21.403  47.471  1.00 24.29           C  
ATOM    223  C   ALA A  34      18.131  22.746  47.242  1.00 23.51           C  
ATOM    224  O   ALA A  34      18.292  23.663  48.024  1.00 23.56           O  
ATOM    225  CB  ALA A  34      18.371  20.855  48.783  1.00 25.20           C  
ATOM    226  N   SER A  35      17.421  22.870  46.152  1.00 23.05           N  
ATOM    227  CA  SER A  35      16.744  24.102  45.836  1.00 23.60           C  
ATOM    228  C   SER A  35      15.257  23.882  46.079  1.00 24.02           C  
ATOM    229  O   SER A  35      14.644  23.135  45.389  1.00 22.41           O  
ATOM    230  CB  SER A  35      16.964  24.451  44.386  1.00 23.08           C  
ATOM    231  OG  SER A  35      16.252  25.620  44.051  1.00 23.06           O  
ATOM    232  N   THR A  36      14.693  24.534  47.078  1.00 25.19           N  
ATOM    233  CA  THR A  36      13.272  24.398  47.370  1.00 25.82           C  
ATOM    234  C   THR A  36      12.640  25.761  47.120  1.00 25.55           C  
ATOM    235  O   THR A  36      12.763  26.685  47.941  1.00 25.88           O  
ATOM    236  CB  THR A  36      13.054  23.947  48.808  1.00 25.93           C  
ATOM    237  OG1 THR A  36      13.662  24.884  49.700  1.00 27.57           O  
ATOM    238  CG2 THR A  36      13.809  22.641  49.089  1.00 26.56           C  
ATOM    239  N   PRO A  37      11.995  25.894  45.969  1.00 24.92           N  
ATOM    240  CA  PRO A  37      11.233  27.103  45.661  1.00 25.23           C  
ATOM    241  C   PRO A  37      10.109  27.281  46.684  1.00 25.15           C  
ATOM    242  O   PRO A  37       9.615  26.275  47.188  1.00 24.44           O  
ATOM    243  CB  PRO A  37      10.626  26.811  44.277  1.00 25.25           C  
ATOM    244  CG  PRO A  37      11.247  25.584  43.789  1.00 25.14           C  
ATOM    245  CD  PRO A  37      11.889  24.880  44.916  1.00 24.58           C  
ATOM    246  N   ARG A  38       9.749  28.527  46.984  1.00 25.64           N  
ATOM    247  CA  ARG A  38       8.559  28.855  47.783  1.00 25.94           C  
ATOM    248  C   ARG A  38       7.825  30.055  47.173  1.00 26.08           C  
ATOM    249  O   ARG A  38       8.431  30.887  46.492  1.00 26.11           O  
ATOM    250  CB  ARG A  38       8.949  29.157  49.228  1.00 26.00           C  
ATOM    251  N   MET A  39       6.519  30.139  47.408  1.00 26.34           N  
ATOM    252  CA  MET A  39       5.720  31.300  46.977  1.00 26.62           C  
ATOM    253  C   MET A  39       4.623  31.608  47.969  1.00 26.37           C  
ATOM    254  O   MET A  39       3.945  32.616  47.826  1.00 27.00           O  
ATOM    255  CB  MET A  39       5.117  31.076  45.589  1.00 26.62           C  
ATOM    256  N   GLU A  46       6.068  31.932  52.486  1.00 29.46           N  
ATOM    257  CA  GLU A  46       5.575  31.166  53.629  1.00 29.37           C  
ATOM    258  C   GLU A  46       4.210  30.529  53.340  1.00 29.37           C  
ATOM    259  O   GLU A  46       3.268  30.620  54.136  1.00 29.27           O  
ATOM    260  CB  GLU A  46       5.506  32.039  54.839  1.00 29.35           C  
ATOM    261  N   TRP A  47       4.131  29.886  52.183  1.00 29.41           N  
ATOM    262  CA  TRP A  47       2.945  29.173  51.741  1.00 29.34           C  
ATOM    263  C   TRP A  47       3.334  28.371  50.496  1.00 29.54           C  
ATOM    264  O   TRP A  47       3.740  28.938  49.475  1.00 29.53           O  
ATOM    265  CB  TRP A  47       1.801  30.143  51.433  1.00 29.21           C  
ATOM    266  N   LYS A  48       3.242  27.051  50.617  1.00 29.65           N  
ATOM    267  CA  LYS A  48       3.477  26.109  49.524  1.00 29.50           C  
ATOM    268  C   LYS A  48       4.914  26.066  49.009  1.00 29.45           C  
ATOM    269  O   LYS A  48       5.327  26.880  48.169  1.00 29.37           O  
ATOM    270  CB  LYS A  48       2.494  26.335  48.360  1.00 29.66           C  
ATOM    271  CG  LYS A  48       1.495  25.189  48.165  1.00 30.10           C  
ATOM    272  CD  LYS A  48       2.203  23.851  47.840  1.00 30.08           C  
ATOM    273  CE  LYS A  48       1.434  22.654  48.400  1.00 30.28           C  
ATOM    274  NZ  LYS A  48       0.433  22.135  47.433  1.00 30.17           N  
ATOM    275  N   ASP A  49       5.663  25.091  49.530  1.00 29.33           N  
ATOM    276  CA  ASP A  49       6.921  24.644  48.938  1.00 29.03           C  
ATOM    277  C   ASP A  49       6.618  24.047  47.574  1.00 28.80           C  
ATOM    278  O   ASP A  49       5.593  23.395  47.394  1.00 28.50           O  
ATOM    279  CB  ASP A  49       7.572  23.563  49.814  1.00 29.15           C  
ATOM    280  CG  ASP A  49       8.269  24.137  51.047  1.00 29.57           C  
ATOM    281  OD1 ASP A  49       7.633  24.200  52.116  1.00 30.28           O  
ATOM    282  OD2 ASP A  49       9.453  24.545  51.044  1.00 30.62           O  
ATOM    283  N   GLY A  50       7.506  24.276  46.615  1.00 28.82           N  
ATOM    284  CA  GLY A  50       7.467  23.602  45.326  1.00 28.99           C  
ATOM    285  C   GLY A  50       8.271  22.318  45.388  1.00 29.08           C  
ATOM    286  O   GLY A  50       8.725  21.923  46.463  1.00 28.95           O  
ATOM    287  N   GLU A  51       8.440  21.662  44.244  1.00 29.32           N  
ATOM    288  CA  GLU A  51       9.298  20.488  44.194  1.00 29.73           C  
ATOM    289  C   GLU A  51      10.764  20.895  44.440  1.00 29.80           C  
ATOM    290  O   GLU A  51      11.243  21.905  43.923  1.00 29.79           O  
ATOM    291  CB  GLU A  51       9.139  19.757  42.860  1.00 30.01           C  
ATOM    292  N   ALA A  52      11.396  19.999  45.188  1.00 30.10           N  
ATOM    293  CA  ALA A  52      12.691  20.252  45.817  1.00 30.38           C  
ATOM    294  C   ALA A  52      13.958  20.076  44.947  1.00 30.83           C  
ATOM    295  O   ALA A  52      14.708  21.017  44.761  1.00 32.13           O  
ATOM    296  CB  ALA A  52      12.819  19.426  47.079  1.00 30.59           C  
ATOM    297  N   LEU A  53      14.232  19.519  43.796  1.00 30.88           N  
ATOM    298  CA  LEU A  53      15.484  19.677  42.959  1.00 30.05           C  
ATOM    299  C   LEU A  53      16.817  19.616  43.749  1.00 28.48           C  
ATOM    300  O   LEU A  53      17.220  20.561  44.405  1.00 26.72           O  
ATOM    301  CB  LEU A  53      15.433  20.994  42.175  1.00 30.22           C  
ATOM    302  CG  LEU A  53      16.076  21.154  40.798  1.00 34.06           C  
ATOM    303  CD1 LEU A  53      17.481  21.549  40.881  1.00 36.98           C  
ATOM    304  CD2 LEU A  53      15.986  19.900  39.964  1.00 37.23           C  
ATOM    305  N   PHE A  54      17.526  18.498  43.628  1.00 27.29           N  
ATOM    306  CA  PHE A  54      18.775  18.240  44.333  1.00 26.28           C  
ATOM    307  C   PHE A  54      19.822  18.051  43.258  1.00 26.60           C  
ATOM    308  O   PHE A  54      19.790  17.053  42.516  1.00 26.17           O  
ATOM    309  CB  PHE A  54      18.674  16.960  45.194  1.00 26.21           C  
ATOM    310  CG  PHE A  54      17.566  16.993  46.215  1.00 26.12           C  
ATOM    311  CD1 PHE A  54      16.267  16.626  45.869  1.00 29.15           C  
ATOM    312  CD2 PHE A  54      17.814  17.403  47.517  1.00 26.83           C  
ATOM    313  CE1 PHE A  54      15.212  16.667  46.833  1.00 30.34           C  
ATOM    314  CE2 PHE A  54      16.799  17.447  48.475  1.00 28.35           C  
ATOM    315  CZ  PHE A  54      15.488  17.084  48.145  1.00 28.74           C  
ATOM    316  N   LEU A  55      20.729  19.020  43.147  1.00 25.90           N  
ATOM    317  CA  LEU A  55      21.785  18.971  42.158  1.00 26.23           C  
ATOM    318  C   LEU A  55      23.137  18.649  42.763  1.00 25.60           C  
ATOM    319  O   LEU A  55      23.685  19.425  43.512  1.00 25.48           O  
ATOM    320  CB  LEU A  55      21.880  20.290  41.414  1.00 26.15           C  
ATOM    321  CG  LEU A  55      20.764  20.431  40.376  1.00 29.40           C  
ATOM    322  CD1 LEU A  55      20.583  21.894  39.943  1.00 31.36           C  
ATOM    323  CD2 LEU A  55      21.055  19.557  39.185  1.00 32.54           C  
ATOM    324  N   ARG A  56      23.662  17.501  42.383  1.00 24.92           N  
ATOM    325  CA  ARG A  56      25.029  17.122  42.669  1.00 24.97           C  
ATOM    326  C   ARG A  56      25.976  18.109  42.000  1.00 24.76           C  
ATOM    327  O   ARG A  56      25.804  18.453  40.833  1.00 25.85           O  
ATOM    328  CB  ARG A  56      25.296  15.733  42.124  1.00 24.53           C  
ATOM    329  CG  ARG A  56      24.408  14.623  42.679  1.00 26.57           C  
ATOM    330  CD  ARG A  56      24.957  13.222  42.352  1.00 28.16           C  
ATOM    331  NE  ARG A  56      25.009  13.084  40.915  1.00 32.23           N  
ATOM    332  CZ  ARG A  56      26.071  12.805  40.160  1.00 29.41           C  
ATOM    333  NH1 ARG A  56      25.892  12.749  38.852  1.00 30.78           N  
ATOM    334  NH2 ARG A  56      27.273  12.571  40.666  1.00 30.34           N  
ATOM    335  N   CYS A  57      26.970  18.563  42.747  1.00 25.02           N  
ATOM    336  CA  CYS A  57      27.928  19.546  42.274  1.00 24.75           C  
ATOM    337  C   CYS A  57      29.348  19.051  42.533  1.00 25.17           C  
ATOM    338  O   CYS A  57      29.626  18.454  43.583  1.00 24.45           O  
ATOM    339  CB  CYS A  57      27.706  20.884  42.974  1.00 24.50           C  
ATOM    340  SG  CYS A  57      26.128  21.705  42.614  1.00 24.93           S  
ATOM    341  N   ASN A  58      30.238  19.292  41.567  1.00 26.02           N  
ATOM    342  CA  ASN A  58      31.678  19.136  41.785  1.00 26.95           C  
ATOM    343  C   ASN A  58      32.490  20.395  41.403  1.00 26.54           C  
ATOM    344  O   ASN A  58      32.156  21.105  40.473  1.00 24.25           O  
ATOM    345  CB  ASN A  58      32.229  17.873  41.119  1.00 28.72           C  
ATOM    346  CG  ASN A  58      31.964  17.816  39.656  1.00 32.05           C  
ATOM    347  OD1 ASN A  58      31.159  18.568  39.131  1.00 43.22           O  
ATOM    348  ND2 ASN A  58      32.611  16.906  38.981  1.00 38.56           N  
ATOM    349  N   ILE A  59      33.549  20.668  42.167  1.00 26.79           N  
ATOM    350  CA  ILE A  59      34.437  21.809  41.907  1.00 27.60           C  
ATOM    351  C   ILE A  59      35.871  21.431  42.237  1.00 28.62           C  
ATOM    352  O   ILE A  59      36.090  20.547  43.046  1.00 29.06           O  
ATOM    353  CB  ILE A  59      33.976  23.019  42.709  1.00 27.11           C  
ATOM    354  CG1 ILE A  59      34.621  24.300  42.187  1.00 27.96           C  
ATOM    355  CG2 ILE A  59      34.212  22.818  44.196  1.00 26.94           C  
ATOM    356  CD1 ILE A  59      34.095  25.599  42.895  1.00 29.30           C  
ATOM    357  N   TRP A  60      36.837  22.098  41.617  1.00 29.95           N  
ATOM    358  CA  TRP A  60      38.238  21.692  41.700  1.00 30.83           C  
ATOM    359  C   TRP A  60      39.172  22.816  42.140  1.00 30.46           C  
ATOM    360  O   TRP A  60      38.798  23.967  42.147  1.00 30.74           O  
ATOM    361  CB  TRP A  60      38.675  21.212  40.326  1.00 31.28           C  
ATOM    362  CG  TRP A  60      38.627  19.749  40.164  1.00 36.20           C  
ATOM    363  CD1 TRP A  60      39.640  18.849  40.424  1.00 41.00           C  
ATOM    364  CD2 TRP A  60      37.534  18.986  39.675  1.00 40.56           C  
ATOM    365  NE1 TRP A  60      39.221  17.573  40.125  1.00 43.86           N  
ATOM    366  CE2 TRP A  60      37.928  17.632  39.668  1.00 43.20           C  
ATOM    367  CE3 TRP A  60      36.257  19.310  39.227  1.00 43.39           C  
ATOM    368  CZ2 TRP A  60      37.086  16.607  39.231  1.00 45.72           C  
ATOM    369  CZ3 TRP A  60      35.424  18.302  38.806  1.00 46.10           C  
ATOM    370  CH2 TRP A  60      35.836  16.962  38.809  1.00 45.45           C  
ATOM    371  N   ARG A  61      40.400  22.445  42.492  1.00 30.78           N  
ATOM    372  CA  ARG A  61      41.487  23.384  42.800  1.00 30.72           C  
ATOM    373  C   ARG A  61      41.272  24.114  44.137  1.00 29.86           C  
ATOM    374  O   ARG A  61      40.667  23.571  45.053  1.00 29.56           O  
ATOM    375  CB  ARG A  61      41.702  24.369  41.628  1.00 31.32           C  
ATOM    376  CG  ARG A  61      42.009  23.697  40.278  1.00 32.81           C  
ATOM    377  CD  ARG A  61      42.278  24.667  39.123  1.00 34.40           C  
ATOM    378  NE  ARG A  61      43.288  24.165  38.190  1.00 34.81           N  
ATOM    379  CZ  ARG A  61      44.605  24.409  38.261  1.00 36.21           C  
ATOM    380  NH1 ARG A  61      45.404  23.894  37.341  1.00 35.64           N  
ATOM    381  NH2 ARG A  61      45.139  25.164  39.228  1.00 35.64           N  
ATOM    382  N   GLU A  62      41.785  25.333  44.241  1.00 29.10           N  
ATOM    383  CA  GLU A  62      41.707  26.125  45.463  1.00 28.67           C  
ATOM    384  C   GLU A  62      40.265  26.350  45.885  1.00 27.12           C  
ATOM    385  O   GLU A  62      39.949  26.345  47.081  1.00 26.23           O  
ATOM    386  CB  GLU A  62      42.406  27.476  45.260  1.00 28.95           C  
ATOM    387  CG  GLU A  62      42.691  28.238  46.551  1.00 30.62           C  
ATOM    388  CD  GLU A  62      42.817  29.748  46.349  1.00 31.87           C  
ATOM    389  OE1 GLU A  62      43.711  30.194  45.577  1.00 34.88           O  
ATOM    390  OE2 GLU A  62      42.045  30.497  46.984  1.00 30.74           O  
ATOM    391  N   ALA A  63      39.397  26.532  44.889  1.00 25.94           N  
ATOM    392  CA  ALA A  63      37.976  26.732  45.110  1.00 24.58           C  
ATOM    393  C   ALA A  63      37.382  25.596  45.929  1.00 23.77           C  
ATOM    394  O   ALA A  63      36.577  25.840  46.835  1.00 23.67           O  
ATOM    395  CB  ALA A  63      37.270  26.827  43.785  1.00 24.87           C  
ATOM    396  N   ALA A  64      37.761  24.361  45.578  1.00 22.31           N  
ATOM    397  CA  ALA A  64      37.411  23.161  46.332  1.00 21.43           C  
ATOM    398  C   ALA A  64      37.757  23.303  47.817  1.00 20.84           C  
ATOM    399  O   ALA A  64      36.885  23.110  48.678  1.00 19.85           O  
ATOM    400  CB  ALA A  64      38.098  21.952  45.756  1.00 21.24           C  
ATOM    401  N   GLU A  65      39.001  23.673  48.113  1.00 20.10           N  
ATOM    402  CA  GLU A  65      39.420  23.894  49.497  1.00 20.98           C  
ATOM    403  C   GLU A  65      38.677  25.061  50.188  1.00 21.60           C  
ATOM    404  O   GLU A  65      38.326  24.973  51.358  1.00 21.15           O  
ATOM    405  CB  GLU A  65      40.929  24.114  49.561  1.00 20.81           C  
ATOM    406  CG  GLU A  65      41.702  22.926  49.025  1.00 21.66           C  
ATOM    407  CD  GLU A  65      43.178  23.077  49.222  1.00 24.01           C  
ATOM    408  OE1 GLU A  65      43.594  23.185  50.388  1.00 25.08           O  
ATOM    409  OE2 GLU A  65      43.914  23.100  48.216  1.00 27.45           O  
ATOM    410  N   ASN A  66      38.415  26.143  49.463  1.00 22.30           N  
ATOM    411  CA  ASN A  66      37.700  27.268  50.052  1.00 23.30           C  
ATOM    412  C   ASN A  66      36.232  26.915  50.407  1.00 23.81           C  
ATOM    413  O   ASN A  66      35.702  27.345  51.435  1.00 23.43           O  
ATOM    414  CB  ASN A  66      37.760  28.482  49.140  1.00 23.22           C  
ATOM    415  CG  ASN A  66      39.168  28.935  48.870  1.00 22.94           C  
ATOM    416  OD1 ASN A  66      40.077  28.744  49.681  1.00 24.43           O  
ATOM    417  ND2 ASN A  66      39.364  29.550  47.726  1.00 22.61           N  
ATOM    418  N   VAL A  67      35.619  26.101  49.567  1.00 24.65           N  
ATOM    419  CA  VAL A  67      34.271  25.597  49.781  1.00 24.94           C  
ATOM    420  C   VAL A  67      34.237  24.764  51.070  1.00 25.64           C  
ATOM    421  O   VAL A  67      33.363  24.961  51.920  1.00 25.48           O  
ATOM    422  CB  VAL A  67      33.831  24.729  48.590  1.00 25.35           C  
ATOM    423  CG1 VAL A  67      32.596  23.900  48.934  1.00 27.00           C  
ATOM    424  CG2 VAL A  67      33.538  25.598  47.353  1.00 26.41           C  
ATOM    425  N   ALA A  68      35.191  23.838  51.206  1.00 25.78           N  
ATOM    426  CA  ALA A  68      35.224  22.909  52.324  1.00 26.13           C  
ATOM    427  C   ALA A  68      35.462  23.649  53.635  1.00 27.16           C  
ATOM    428  O   ALA A  68      34.934  23.272  54.690  1.00 27.43           O  
ATOM    429  CB  ALA A  68      36.318  21.879  52.112  1.00 26.30           C  
ATOM    430  N   GLU A  69      36.267  24.701  53.559  1.00 27.42           N  
ATOM    431  CA  GLU A  69      36.564  25.542  54.709  1.00 27.74           C  
ATOM    432  C   GLU A  69      35.411  26.495  55.088  1.00 27.37           C  
ATOM    433  O   GLU A  69      35.258  26.840  56.254  1.00 25.70           O  
ATOM    434  CB  GLU A  69      37.798  26.379  54.415  1.00 28.31           C  
ATOM    435  CG  GLU A  69      38.322  27.116  55.628  1.00 32.03           C  
ATOM    436  CD  GLU A  69      39.735  27.616  55.458  1.00 35.55           C  
ATOM    437  OE1 GLU A  69      40.573  26.894  54.876  1.00 39.85           O  
ATOM    438  OE2 GLU A  69      40.015  28.736  55.931  1.00 40.89           O  
ATOM    439  N   SER A  70      34.608  26.897  54.107  1.00 26.20           N  
ATOM    440  CA  SER A  70      33.663  28.000  54.291  1.00 26.68           C  
ATOM    441  C   SER A  70      32.214  27.563  54.418  1.00 26.24           C  
ATOM    442  O   SER A  70      31.423  28.289  54.983  1.00 27.19           O  
ATOM    443  CB  SER A  70      33.746  29.003  53.125  1.00 26.30           C  
ATOM    444  OG  SER A  70      35.083  29.430  52.888  1.00 27.51           O  
ATOM    445  N   LEU A  71      31.849  26.400  53.883  1.00 25.99           N  
ATOM    446  CA  LEU A  71      30.440  26.015  53.787  1.00 24.83           C  
ATOM    447  C   LEU A  71      30.171  24.736  54.562  1.00 25.35           C  
ATOM    448  O   LEU A  71      31.050  23.887  54.719  1.00 24.45           O  
ATOM    449  CB  LEU A  71      30.042  25.801  52.328  1.00 24.41           C  
ATOM    450  CG  LEU A  71      30.221  27.006  51.404  1.00 24.13           C  
ATOM    451  CD1 LEU A  71      29.837  26.626  50.002  1.00 22.89           C  
ATOM    452  CD2 LEU A  71      29.418  28.224  51.867  1.00 22.90           C  
ATOM    453  N   THR A  72      28.932  24.607  55.025  1.00 25.36           N  
ATOM    454  CA  THR A  72      28.481  23.434  55.734  1.00 25.56           C  
ATOM    455  C   THR A  72      27.085  23.039  55.292  1.00 25.65           C  
ATOM    456  O   THR A  72      26.448  23.734  54.489  1.00 24.75           O  
ATOM    457  CB  THR A  72      28.461  23.706  57.284  1.00 26.16           C  
ATOM    458  OG1 THR A  72      27.653  24.857  57.584  1.00 25.76           O  
ATOM    459  CG2 THR A  72      29.861  24.069  57.786  1.00 26.76           C  
ATOM    460  N   ARG A  73      26.615  21.933  55.857  1.00 25.57           N  
ATOM    461  CA  ARG A  73      25.228  21.534  55.748  1.00 26.76           C  
ATOM    462  C   ARG A  73      24.356  22.743  56.110  1.00 26.11           C  
ATOM    463  O   ARG A  73      24.540  23.361  57.132  1.00 25.33           O  
ATOM    464  CB  ARG A  73      24.924  20.380  56.696  1.00 27.44           C  
ATOM    465  CG  ARG A  73      23.606  19.703  56.416  1.00 30.53           C  
ATOM    466  CD  ARG A  73      23.271  18.593  57.401  1.00 33.80           C  
ATOM    467  NE  ARG A  73      22.582  19.170  58.542  1.00 37.27           N  
ATOM    468  CZ  ARG A  73      23.137  19.486  59.711  1.00 40.06           C  
ATOM    469  NH1 ARG A  73      24.428  19.259  59.943  1.00 42.08           N  
ATOM    470  NH2 ARG A  73      22.392  20.041  60.664  1.00 39.91           N  
ATOM    471  N   GLY A  74      23.461  23.096  55.214  1.00 26.21           N  
ATOM    472  CA  GLY A  74      22.488  24.128  55.474  1.00 26.61           C  
ATOM    473  C   GLY A  74      22.841  25.455  54.840  1.00 26.51           C  
ATOM    474  O   GLY A  74      21.955  26.281  54.675  1.00 27.31           O  
ATOM    475  N   SER A  75      24.116  25.653  54.509  1.00 26.27           N  
ATOM    476  CA  SER A  75      24.614  26.901  53.971  1.00 26.37           C  
ATOM    477  C   SER A  75      23.888  27.215  52.690  1.00 26.39           C  
ATOM    478  O   SER A  75      23.801  26.363  51.807  1.00 26.89           O  
ATOM    479  CB  SER A  75      26.107  26.821  53.630  1.00 26.67           C  
ATOM    480  OG  SER A  75      26.881  26.551  54.764  1.00 27.25           O  
ATOM    481  N   ARG A  76      23.384  28.442  52.591  1.00 25.83           N  
ATOM    482  CA  ARG A  76      22.692  28.913  51.403  1.00 25.17           C  
ATOM    483  C   ARG A  76      23.711  29.435  50.426  1.00 24.84           C  
ATOM    484  O   ARG A  76      24.563  30.257  50.765  1.00 25.39           O  
ATOM    485  CB  ARG A  76      21.689  29.992  51.760  1.00 25.20           C  
ATOM    486  CG  ARG A  76      20.706  30.307  50.652  1.00 25.68           C  
ATOM    487  CD  ARG A  76      19.902  31.552  50.910  1.00 26.75           C  
ATOM    488  NE  ARG A  76      19.055  31.947  49.789  1.00 27.23           N  
ATOM    489  CZ  ARG A  76      17.866  31.395  49.530  1.00 31.80           C  
ATOM    490  NH1 ARG A  76      17.122  31.808  48.506  1.00 31.97           N  
ATOM    491  NH2 ARG A  76      17.415  30.406  50.286  1.00 34.79           N  
ATOM    492  N   VAL A  77      23.640  28.932  49.208  1.00 24.84           N  
ATOM    493  CA  VAL A  77      24.660  29.161  48.214  1.00 24.47           C  
ATOM    494  C   VAL A  77      24.082  29.537  46.879  1.00 24.46           C  
ATOM    495  O   VAL A  77      22.960  29.204  46.553  1.00 24.37           O  
ATOM    496  CB  VAL A  77      25.583  27.909  48.032  1.00 25.02           C  
ATOM    497  CG1 VAL A  77      26.272  27.538  49.321  1.00 23.75           C  
ATOM    498  CG2 VAL A  77      24.834  26.705  47.515  1.00 24.51           C  
ATOM    499  N   ILE A  78      24.886  30.246  46.108  1.00 24.81           N  
ATOM    500  CA  ILE A  78      24.593  30.580  44.722  1.00 24.62           C  
ATOM    501  C   ILE A  78      25.656  29.843  43.917  1.00 24.66           C  
ATOM    502  O   ILE A  78      26.837  30.024  44.171  1.00 24.79           O  
ATOM    503  CB  ILE A  78      24.727  32.088  44.495  1.00 25.15           C  
ATOM    504  CG1 ILE A  78      23.873  32.849  45.511  1.00 27.44           C  
ATOM    505  CG2 ILE A  78      24.303  32.477  43.065  1.00 24.93           C  
ATOM    506  CD1 ILE A  78      24.194  34.318  45.591  1.00 30.33           C  
ATOM    507  N   VAL A  79      25.224  29.032  42.953  1.00 24.06           N  
ATOM    508  CA  VAL A  79      26.104  28.193  42.165  1.00 24.30           C  
ATOM    509  C   VAL A  79      25.812  28.395  40.691  1.00 24.15           C  
ATOM    510  O   VAL A  79      24.664  28.308  40.277  1.00 24.10           O  
ATOM    511  CB  VAL A  79      25.955  26.684  42.521  1.00 24.06           C  
ATOM    512  CG1 VAL A  79      26.731  25.814  41.563  1.00 24.25           C  
ATOM    513  CG2 VAL A  79      26.415  26.434  43.895  1.00 25.52           C  
ATOM    514  N   THR A  80      26.854  28.686  39.913  1.00 23.59           N  
ATOM    515  CA  THR A  80      26.749  28.661  38.454  1.00 24.01           C  
ATOM    516  C   THR A  80      27.798  27.690  37.886  1.00 23.72           C  
ATOM    517  O   THR A  80      28.896  27.587  38.425  1.00 24.30           O  
ATOM    518  CB  THR A  80      26.919  30.067  37.867  1.00 24.51           C  
ATOM    519  OG1 THR A  80      26.610  30.034  36.453  1.00 26.43           O  
ATOM    520  CG2 THR A  80      28.393  30.541  37.962  1.00 23.50           C  
ATOM    521  N   GLY A  81      27.433  26.972  36.834  1.00 23.25           N  
ATOM    522  CA  GLY A  81      28.274  25.975  36.228  1.00 22.77           C  
ATOM    523  C   GLY A  81      27.631  25.357  35.011  1.00 23.58           C  
ATOM    524  O   GLY A  81      26.648  25.863  34.467  1.00 23.05           O  
ATOM    525  N   ARG A  82      28.242  24.273  34.540  1.00 23.75           N  
ATOM    526  CA  ARG A  82      27.810  23.588  33.355  1.00 24.62           C  
ATOM    527  C   ARG A  82      27.058  22.338  33.770  1.00 23.02           C  
ATOM    528  O   ARG A  82      27.495  21.582  34.622  1.00 21.62           O  
ATOM    529  CB  ARG A  82      28.985  23.210  32.464  1.00 25.55           C  
ATOM    530  CG  ARG A  82      29.528  24.378  31.660  1.00 31.09           C  
ATOM    531  CD  ARG A  82      30.781  25.032  32.273  1.00 37.79           C  
ATOM    532  NE  ARG A  82      31.942  24.120  32.285  1.00 41.37           N  
ATOM    533  CZ  ARG A  82      32.635  23.773  33.377  1.00 42.06           C  
ATOM    534  NH1 ARG A  82      32.326  24.247  34.594  1.00 40.49           N  
ATOM    535  NH2 ARG A  82      33.651  22.933  33.239  1.00 44.35           N  
ATOM    536  N   LEU A  83      25.918  22.156  33.143  1.00 22.18           N  
ATOM    537  CA  LEU A  83      25.061  21.017  33.400  1.00 22.77           C  
ATOM    538  C   LEU A  83      25.572  19.827  32.612  1.00 22.37           C  
ATOM    539  O   LEU A  83      25.786  19.897  31.410  1.00 22.32           O  
ATOM    540  CB  LEU A  83      23.621  21.336  33.005  1.00 23.09           C  
ATOM    541  CG  LEU A  83      22.526  20.348  33.412  1.00 23.94           C  
ATOM    542  CD1 LEU A  83      22.552  20.003  34.861  1.00 23.01           C  
ATOM    543  CD2 LEU A  83      21.227  20.999  33.097  1.00 26.69           C  
ATOM    544  N   LYS A  84      25.777  18.743  33.331  1.00 22.22           N  
ATOM    545  CA  LYS A  84      26.249  17.525  32.760  1.00 22.64           C  
ATOM    546  C   LYS A  84      25.300  16.397  33.099  1.00 21.64           C  
ATOM    547  O   LYS A  84      24.645  16.391  34.113  1.00 22.20           O  
ATOM    548  CB  LYS A  84      27.658  17.177  33.261  1.00 23.62           C  
ATOM    549  CG  LYS A  84      28.771  18.213  32.887  1.00 27.43           C  
ATOM    550  CD  LYS A  84      28.886  18.390  31.360  1.00 32.15           C  
ATOM    551  CE  LYS A  84      30.158  19.161  30.911  1.00 34.83           C  
ATOM    552  NZ  LYS A  84      30.048  19.572  29.482  1.00 34.01           N  
ATOM    553  N   GLN A  85      25.312  15.421  32.218  1.00 21.45           N  
ATOM    554  CA  GLN A  85      24.442  14.276  32.264  1.00 21.62           C  
ATOM    555  C   GLN A  85      25.220  13.024  31.867  1.00 22.12           C  
ATOM    556  O   GLN A  85      26.033  13.037  30.948  1.00 22.03           O  
ATOM    557  CB  GLN A  85      23.278  14.440  31.291  1.00 21.43           C  
ATOM    558  CG  GLN A  85      22.378  13.238  31.216  1.00 21.48           C  
ATOM    559  CD  GLN A  85      21.243  13.444  30.256  1.00 20.80           C  
ATOM    560  OE1 GLN A  85      20.091  13.653  30.668  1.00 22.97           O  
ATOM    561  NE2 GLN A  85      21.554  13.428  28.992  1.00 17.09           N  
ATOM    562  N   ARG A  86      24.911  11.937  32.559  1.00 22.80           N  
ATOM    563  CA  ARG A  86      25.413  10.620  32.249  1.00 23.51           C  
ATOM    564  C   ARG A  86      24.260   9.633  32.113  1.00 23.67           C  
ATOM    565  O   ARG A  86      23.286   9.734  32.845  1.00 22.88           O  
ATOM    566  CB  ARG A  86      26.280  10.152  33.387  1.00 23.95           C  
ATOM    567  CG  ARG A  86      27.574  10.905  33.498  1.00 26.05           C  
ATOM    568  CD  ARG A  86      28.674  10.072  33.302  1.00 26.22           C  
ATOM    569  NE  ARG A  86      29.916  10.619  33.818  1.00 26.91           N  
ATOM    570  CZ  ARG A  86      31.070  10.062  33.584  1.00 21.83           C  
ATOM    571  NH1 ARG A  86      31.108   8.952  32.880  1.00 22.20           N  
ATOM    572  NH2 ARG A  86      32.165  10.572  34.098  1.00 24.52           N  
ATOM    573  N   SER A  87      24.382   8.678  31.191  1.00 24.06           N  
ATOM    574  CA  SER A  87      23.488   7.514  31.148  1.00 24.86           C  
ATOM    575  C   SER A  87      24.262   6.197  31.385  1.00 25.42           C  
ATOM    576  O   SER A  87      25.305   5.931  30.793  1.00 25.00           O  
ATOM    577  CB  SER A  87      22.685   7.445  29.843  1.00 24.60           C  
ATOM    578  OG  SER A  87      23.504   7.122  28.738  1.00 25.68           O  
ATOM    579  N   PHE A  88      23.742   5.416  32.319  1.00 26.42           N  
ATOM    580  CA  PHE A  88      24.245   4.094  32.635  1.00 26.91           C  
ATOM    581  C   PHE A  88      23.230   3.142  32.048  1.00 28.06           C  
ATOM    582  O   PHE A  88      22.128   2.914  32.573  1.00 27.64           O  
ATOM    583  CB  PHE A  88      24.421   3.927  34.130  1.00 26.66           C  
ATOM    584  CG  PHE A  88      25.209   5.031  34.742  1.00 26.06           C  
ATOM    585  CD1 PHE A  88      24.581   6.059  35.431  1.00 25.99           C  
ATOM    586  CD2 PHE A  88      26.582   5.078  34.572  1.00 25.51           C  
ATOM    587  CE1 PHE A  88      25.327   7.087  36.000  1.00 26.52           C  
ATOM    588  CE2 PHE A  88      27.324   6.109  35.113  1.00 25.91           C  
ATOM    589  CZ  PHE A  88      26.694   7.116  35.833  1.00 25.81           C  
ATOM    590  N   GLU A  89      23.640   2.649  30.893  1.00 29.04           N  
ATOM    591  CA  GLU A  89      22.813   1.926  29.970  1.00 29.88           C  
ATOM    592  C   GLU A  89      23.119   0.489  30.381  1.00 30.40           C  
ATOM    593  O   GLU A  89      24.285   0.173  30.655  1.00 30.81           O  
ATOM    594  CB  GLU A  89      23.256   2.313  28.542  1.00 30.21           C  
ATOM    595  CG  GLU A  89      23.315   3.852  28.313  1.00 30.36           C  
ATOM    596  CD  GLU A  89      24.577   4.376  27.595  1.00 31.16           C  
ATOM    597  OE1 GLU A  89      25.440   5.026  28.254  1.00 31.43           O  
ATOM    598  OE2 GLU A  89      24.703   4.172  26.358  1.00 31.23           O  
ATOM    599  N   THR A  90      22.117  -0.376  30.494  1.00 30.64           N  
ATOM    600  CA  THR A  90      22.309  -1.481  31.421  1.00 30.71           C  
ATOM    601  C   THR A  90      21.423  -2.709  31.290  1.00 30.83           C  
ATOM    602  O   THR A  90      20.602  -2.838  30.374  1.00 30.87           O  
ATOM    603  CB  THR A  90      22.214  -0.919  32.861  1.00 30.84           C  
ATOM    604  N   ARG A  91      21.681  -3.624  32.223  1.00 31.03           N  
ATOM    605  CA  ARG A  91      21.000  -4.914  32.364  1.00 31.33           C  
ATOM    606  C   ARG A  91      19.486  -4.865  32.162  1.00 31.30           C  
ATOM    607  O   ARG A  91      18.820  -5.907  32.167  1.00 31.37           O  
ATOM    608  CB  ARG A  91      21.328  -5.526  33.747  1.00 31.43           C  
ATOM    609  CG  ARG A  91      21.337  -4.527  34.941  1.00 31.46           C  
ATOM    610  CD  ARG A  91      20.908  -5.152  36.282  1.00 31.38           C  
ATOM    611  NE  ARG A  91      21.923  -6.018  36.897  1.00 30.82           N  
ATOM    612  CZ  ARG A  91      22.925  -5.602  37.678  1.00 30.18           C  
ATOM    613  NH1 ARG A  91      23.095  -4.314  37.958  1.00 30.51           N  
ATOM    614  NH2 ARG A  91      23.774  -6.489  38.181  1.00 30.30           N  
ATOM    615  N   GLU A  94      17.731  -1.818  31.102  1.00 26.18           N  
ATOM    616  CA  GLU A  94      17.691  -1.032  32.332  1.00 26.23           C  
ATOM    617  C   GLU A  94      18.457   0.294  32.143  1.00 26.29           C  
ATOM    618  O   GLU A  94      19.682   0.296  32.013  1.00 26.30           O  
ATOM    619  CB  GLU A  94      18.255  -1.856  33.513  1.00 26.31           C  
ATOM    620  CG  GLU A  94      17.201  -2.627  34.323  1.00 26.80           C  
ATOM    621  CD  GLU A  94      17.363  -4.149  34.317  1.00 27.55           C  
ATOM    622  OE1 GLU A  94      18.209  -4.673  35.069  1.00 27.68           O  
ATOM    623  OE2 GLU A  94      16.621  -4.843  33.580  1.00 27.44           O  
ATOM    624  N   LYS A  95      17.734   1.415  32.126  1.00 25.88           N  
ATOM    625  CA  LYS A  95      18.314   2.710  31.778  1.00 25.97           C  
ATOM    626  C   LYS A  95      18.312   3.647  32.971  1.00 24.96           C  
ATOM    627  O   LYS A  95      17.294   3.839  33.605  1.00 25.44           O  
ATOM    628  CB  LYS A  95      17.554   3.345  30.624  1.00 26.41           C  
ATOM    629  CG  LYS A  95      17.706   2.588  29.307  1.00 28.32           C  
ATOM    630  CD  LYS A  95      19.055   2.904  28.647  1.00 29.52           C  
ATOM    631  CE  LYS A  95      19.276   2.037  27.412  1.00 30.36           C  
ATOM    632  NZ  LYS A  95      20.555   2.397  26.732  1.00 30.70           N  
ATOM    633  N   ARG A  96      19.470   4.203  33.279  1.00 23.85           N  
ATOM    634  CA  ARG A  96      19.648   5.036  34.460  1.00 23.47           C  
ATOM    635  C   ARG A  96      20.413   6.306  34.054  1.00 22.95           C  
ATOM    636  O   ARG A  96      21.428   6.220  33.373  1.00 21.20           O  
ATOM    637  CB  ARG A  96      20.412   4.247  35.515  1.00 23.78           C  
ATOM    638  CG  ARG A  96      20.785   4.972  36.833  1.00 25.36           C  
ATOM    639  CD  ARG A  96      21.907   4.232  37.620  1.00 26.52           C  
ATOM    640  NE  ARG A  96      21.939   4.560  39.041  1.00 26.67           N  
ATOM    641  CZ  ARG A  96      22.632   3.888  39.963  1.00 27.74           C  
ATOM    642  NH1 ARG A  96      23.359   2.825  39.635  1.00 28.46           N  
ATOM    643  NH2 ARG A  96      22.585   4.272  41.237  1.00 27.94           N  
ATOM    644  N   THR A  97      19.893   7.479  34.435  1.00 22.14           N  
ATOM    645  CA  THR A  97      20.596   8.729  34.209  1.00 22.32           C  
ATOM    646  C   THR A  97      20.771   9.508  35.495  1.00 22.20           C  
ATOM    647  O   THR A  97      19.933   9.434  36.401  1.00 21.91           O  
ATOM    648  CB  THR A  97      19.866   9.593  33.159  1.00 22.15           C  
ATOM    649  OG1 THR A  97      18.494   9.809  33.541  1.00 23.84           O  
ATOM    650  CG2 THR A  97      19.734   8.827  31.863  1.00 23.46           C  
ATOM    651  N   VAL A  98      21.880  10.242  35.566  1.00 22.14           N  
ATOM    652  CA  VAL A  98      22.090  11.291  36.557  1.00 22.21           C  
ATOM    653  C   VAL A  98      22.559  12.586  35.899  1.00 22.03           C  
ATOM    654  O   VAL A  98      23.143  12.571  34.825  1.00 21.80           O  
ATOM    655  CB  VAL A  98      23.139  10.871  37.627  1.00 22.66           C  
ATOM    656  CG1 VAL A  98      22.628   9.682  38.441  1.00 23.79           C  
ATOM    657  CG2 VAL A  98      24.497  10.535  36.983  1.00 22.59           C  
ATOM    658  N   VAL A  99      22.323  13.695  36.571  1.00 21.58           N  
ATOM    659  CA  VAL A  99      22.913  14.948  36.197  1.00 22.04           C  
ATOM    660  C   VAL A  99      23.900  15.413  37.237  1.00 22.00           C  
ATOM    661  O   VAL A  99      24.017  14.847  38.310  1.00 22.43           O  
ATOM    662  CB  VAL A  99      21.870  16.047  35.840  1.00 21.99           C  
ATOM    663  CG1 VAL A  99      20.947  15.493  34.789  1.00 23.68           C  
ATOM    664  CG2 VAL A  99      21.105  16.556  37.040  1.00 23.87           C  
ATOM    665  N   GLU A 100      24.643  16.425  36.858  1.00 21.95           N  
ATOM    666  CA  GLU A 100      25.613  17.028  37.719  1.00 22.30           C  
ATOM    667  C   GLU A 100      26.021  18.393  37.123  1.00 22.01           C  
ATOM    668  O   GLU A 100      25.970  18.602  35.911  1.00 21.89           O  
ATOM    669  CB  GLU A 100      26.775  16.073  37.807  1.00 22.20           C  
ATOM    670  CG  GLU A 100      28.085  16.681  38.142  1.00 24.11           C  
ATOM    671  CD  GLU A 100      29.161  15.622  38.204  1.00 24.73           C  
ATOM    672  OE1 GLU A 100      29.114  14.795  39.161  1.00 24.55           O  
ATOM    673  OE2 GLU A 100      30.060  15.656  37.322  1.00 25.33           O  
ATOM    674  N   VAL A 101      26.406  19.307  38.004  1.00 22.18           N  
ATOM    675  CA  VAL A 101      26.864  20.627  37.645  1.00 21.99           C  
ATOM    676  C   VAL A 101      28.368  20.669  37.889  1.00 22.41           C  
ATOM    677  O   VAL A 101      28.829  20.431  39.001  1.00 21.86           O  
ATOM    678  CB  VAL A 101      26.195  21.687  38.516  1.00 21.91           C  
ATOM    679  CG1 VAL A 101      26.718  23.107  38.219  1.00 21.63           C  
ATOM    680  CG2 VAL A 101      24.677  21.635  38.378  1.00 23.21           C  
ATOM    681  N   GLU A 102      29.118  20.973  36.844  1.00 22.67           N  
ATOM    682  CA  GLU A 102      30.542  21.272  36.957  1.00 23.53           C  
ATOM    683  C   GLU A 102      30.605  22.743  37.323  1.00 22.22           C  
ATOM    684  O   GLU A 102      30.346  23.599  36.487  1.00 20.48           O  
ATOM    685  CB  GLU A 102      31.249  21.068  35.631  1.00 24.03           C  
ATOM    686  CG  GLU A 102      31.714  19.662  35.335  1.00 31.23           C  
ATOM    687  CD  GLU A 102      32.374  19.519  33.944  1.00 37.19           C  
ATOM    688  OE1 GLU A 102      32.456  18.367  33.420  1.00 41.06           O  
ATOM    689  OE2 GLU A 102      32.817  20.551  33.360  1.00 43.55           O  
ATOM    690  N   VAL A 103      30.915  23.026  38.574  1.00 21.82           N  
ATOM    691  CA  VAL A 103      30.801  24.375  39.114  1.00 22.44           C  
ATOM    692  C   VAL A 103      31.884  25.305  38.563  1.00 22.61           C  
ATOM    693  O   VAL A 103      33.059  25.008  38.650  1.00 21.49           O  
ATOM    694  CB  VAL A 103      30.839  24.346  40.655  1.00 22.87           C  
ATOM    695  CG1 VAL A 103      30.847  25.779  41.284  1.00 21.96           C  
ATOM    696  CG2 VAL A 103      29.616  23.549  41.193  1.00 23.39           C  
ATOM    697  N   ASP A 104      31.470  26.417  37.964  1.00 23.29           N  
ATOM    698  CA  ASP A 104      32.389  27.504  37.661  1.00 24.82           C  
ATOM    699  C   ASP A 104      32.632  28.432  38.841  1.00 24.42           C  
ATOM    700  O   ASP A 104      33.768  28.680  39.212  1.00 23.83           O  
ATOM    701  CB  ASP A 104      31.884  28.283  36.457  1.00 26.11           C  
ATOM    702  CG  ASP A 104      31.925  27.455  35.194  1.00 28.96           C  
ATOM    703  OD1 ASP A 104      32.999  26.849  34.924  1.00 31.02           O  
ATOM    704  OD2 ASP A 104      30.946  27.365  34.413  1.00 34.70           O  
ATOM    705  N   GLU A 105      31.566  28.944  39.444  1.00 24.84           N  
ATOM    706  CA  GLU A 105      31.699  29.724  40.676  1.00 24.83           C  
ATOM    707  C   GLU A 105      30.614  29.396  41.658  1.00 24.72           C  
ATOM    708  O   GLU A 105      29.516  28.957  41.299  1.00 23.94           O  
ATOM    709  CB  GLU A 105      31.658  31.247  40.446  1.00 25.66           C  
ATOM    710  CG  GLU A 105      32.442  31.771  39.273  1.00 25.34           C  
ATOM    711  CD  GLU A 105      33.733  32.484  39.611  1.00 23.55           C  
ATOM    712  OE1 GLU A 105      33.950  33.028  40.713  1.00 21.02           O  
ATOM    713  OE2 GLU A 105      34.537  32.524  38.690  1.00 26.23           O  
ATOM    714  N   ILE A 106      30.942  29.651  42.916  1.00 24.36           N  
ATOM    715  CA  ILE A 106      30.036  29.396  44.018  1.00 25.05           C  
ATOM    716  C   ILE A 106      30.359  30.420  45.098  1.00 25.38           C  
ATOM    717  O   ILE A 106      31.524  30.752  45.333  1.00 24.44           O  
ATOM    718  CB  ILE A 106      30.173  27.943  44.592  1.00 25.25           C  
ATOM    719  CG1 ILE A 106      29.319  27.784  45.849  1.00 26.38           C  
ATOM    720  CG2 ILE A 106      31.625  27.618  44.960  1.00 25.67           C  
ATOM    721  CD1 ILE A 106      29.057  26.369  46.235  1.00 28.34           C  
ATOM    722  N   GLY A 107      29.312  30.880  45.771  1.00 25.41           N  
ATOM    723  CA  GLY A 107      29.465  31.740  46.940  1.00 25.39           C  
ATOM    724  C   GLY A 107      28.285  31.584  47.856  1.00 24.63           C  
ATOM    725  O   GLY A 107      27.198  31.188  47.384  1.00 25.50           O  
ATOM    726  N   PRO A 108      28.451  31.871  49.146  1.00 24.09           N  
ATOM    727  CA  PRO A 108      27.302  31.843  50.049  1.00 23.67           C  
ATOM    728  C   PRO A 108      26.470  33.075  49.796  1.00 22.85           C  
ATOM    729  O   PRO A 108      27.006  34.163  49.605  1.00 22.40           O  
ATOM    730  CB  PRO A 108      27.937  31.842  51.449  1.00 23.43           C  
ATOM    731  CG  PRO A 108      29.240  32.536  51.253  1.00 24.33           C  
ATOM    732  CD  PRO A 108      29.684  32.248  49.862  1.00 24.02           C  
ATOM    733  N   SER A 109      25.167  32.888  49.745  1.00 23.16           N  
ATOM    734  CA  SER A 109      24.237  34.000  49.557  1.00 23.53           C  
ATOM    735  C   SER A 109      24.211  34.902  50.782  1.00 22.91           C  
ATOM    736  O   SER A 109      24.270  34.419  51.911  1.00 22.70           O  
ATOM    737  CB  SER A 109      22.831  33.481  49.325  1.00 22.95           C  
ATOM    738  OG  SER A 109      21.970  34.574  49.089  1.00 25.64           O  
ATOM    739  N   LEU A 110      24.089  36.197  50.528  1.00 22.67           N  
ATOM    740  CA  LEU A 110      23.971  37.228  51.550  1.00 22.39           C  
ATOM    741  C   LEU A 110      22.521  37.681  51.726  1.00 22.15           C  
ATOM    742  O   LEU A 110      22.216  38.730  52.341  1.00 21.67           O  
ATOM    743  CB  LEU A 110      24.850  38.418  51.161  1.00 22.74           C  
ATOM    744  CG  LEU A 110      26.346  38.077  51.047  1.00 21.34           C  
ATOM    745  CD1 LEU A 110      27.103  39.279  50.619  1.00 23.28           C  
ATOM    746  CD2 LEU A 110      26.909  37.596  52.374  1.00 21.76           C  
ATOM    747  N   ARG A 111      21.611  36.879  51.214  1.00 21.60           N  
ATOM    748  CA  ARG A 111      20.205  37.195  51.353  1.00 23.36           C  
ATOM    749  C   ARG A 111      19.761  37.148  52.821  1.00 22.82           C  
ATOM    750  O   ARG A 111      19.040  38.001  53.288  1.00 21.38           O  
ATOM    751  CB  ARG A 111      19.370  36.215  50.529  1.00 24.31           C  
ATOM    752  CG  ARG A 111      17.885  36.424  50.736  1.00 29.41           C  
ATOM    753  CD  ARG A 111      17.127  36.621  49.454  1.00 36.02           C  
ATOM    754  NE  ARG A 111      16.235  35.531  49.142  1.00 39.33           N  
ATOM    755  CZ  ARG A 111      15.358  35.539  48.132  1.00 44.83           C  
ATOM    756  NH1 ARG A 111      15.264  36.596  47.314  1.00 48.20           N  
ATOM    757  NH2 ARG A 111      14.577  34.479  47.926  1.00 43.96           N  
ATOM    758  N   TYR A 112      20.198  36.117  53.522  1.00 23.75           N  
ATOM    759  CA  TYR A 112      19.776  35.865  54.881  1.00 24.78           C  
ATOM    760  C   TYR A 112      20.990  35.742  55.788  1.00 24.99           C  
ATOM    761  O   TYR A 112      20.882  35.194  56.876  1.00 25.60           O  
ATOM    762  CB  TYR A 112      18.956  34.560  54.938  1.00 25.27           C  
ATOM    763  CG  TYR A 112      17.679  34.559  54.086  1.00 26.74           C  
ATOM    764  CD1 TYR A 112      17.424  33.525  53.171  1.00 26.43           C  
ATOM    765  CD2 TYR A 112      16.719  35.571  54.232  1.00 27.07           C  
ATOM    766  CE1 TYR A 112      16.254  33.512  52.397  1.00 27.31           C  
ATOM    767  CE2 TYR A 112      15.533  35.572  53.474  1.00 29.57           C  
ATOM    768  CZ  TYR A 112      15.308  34.540  52.556  1.00 30.24           C  
ATOM    769  OH  TYR A 112      14.154  34.552  51.797  1.00 32.13           O  
ATOM    770  N   ALA A 113      22.134  36.246  55.343  1.00 24.09           N  
ATOM    771  CA  ALA A 113      23.363  36.098  56.101  1.00 24.39           C  
ATOM    772  C   ALA A 113      24.394  37.134  55.726  1.00 23.95           C  
ATOM    773  O   ALA A 113      24.345  37.745  54.665  1.00 22.90           O  
ATOM    774  CB  ALA A 113      23.966  34.710  55.901  1.00 25.08           C  
ATOM    775  N   THR A 114      25.328  37.322  56.637  1.00 24.07           N  
ATOM    776  CA  THR A 114      26.491  38.133  56.378  1.00 24.09           C  
ATOM    777  C   THR A 114      27.671  37.206  56.275  1.00 24.15           C  
ATOM    778  O   THR A 114      27.597  36.038  56.691  1.00 24.02           O  
ATOM    779  CB  THR A 114      26.692  39.134  57.518  1.00 23.92           C  
ATOM    780  OG1 THR A 114      26.886  38.430  58.756  1.00 23.78           O  
ATOM    781  CG2 THR A 114      25.420  39.941  57.730  1.00 24.26           C  
ATOM    782  N   ALA A 115      28.780  37.730  55.755  1.00 24.44           N  
ATOM    783  CA  ALA A 115      30.012  36.968  55.706  1.00 24.50           C  
ATOM    784  C   ALA A 115      31.263  37.832  55.883  1.00 25.23           C  
ATOM    785  O   ALA A 115      31.355  38.975  55.422  1.00 25.69           O  
ATOM    786  CB  ALA A 115      30.075  36.176  54.437  1.00 24.26           C  
ATOM    787  N   LYS A 116      32.228  37.291  56.604  1.00 25.63           N  
ATOM    788  CA  LYS A 116      33.525  37.917  56.693  1.00 26.12           C  
ATOM    789  C   LYS A 116      34.310  37.244  55.580  1.00 26.34           C  
ATOM    790  O   LYS A 116      34.450  36.037  55.593  1.00 26.17           O  
ATOM    791  CB  LYS A 116      34.161  37.658  58.068  1.00 25.73           C  
ATOM    792  N   VAL A 117      34.790  38.020  54.619  1.00 27.01           N  
ATOM    793  CA  VAL A 117      35.483  37.484  53.469  1.00 28.23           C  
ATOM    794  C   VAL A 117      36.980  37.712  53.588  1.00 29.72           C  
ATOM    795  O   VAL A 117      37.427  38.770  54.022  1.00 30.35           O  
ATOM    796  CB  VAL A 117      34.962  38.106  52.156  1.00 28.31           C  
ATOM    797  CG1 VAL A 117      35.604  37.440  50.972  1.00 28.03           C  
ATOM    798  CG2 VAL A 117      33.454  37.954  52.050  1.00 27.69           C  
ATOM    799  N   ASN A 118      37.757  36.715  53.186  1.00 31.36           N  
ATOM    800  CA  ASN A 118      39.203  36.784  53.278  1.00 32.91           C  
ATOM    801  C   ASN A 118      39.896  36.228  52.032  1.00 34.25           C  
ATOM    802  O   ASN A 118      39.910  35.012  51.782  1.00 34.54           O  
ATOM    803  CB  ASN A 118      39.670  36.075  54.539  1.00 33.14           C  
ATOM    804  CG  ASN A 118      39.176  36.775  55.808  1.00 34.64           C  
ATOM    805  OD1 ASN A 118      39.757  37.772  56.274  1.00 34.24           O  
ATOM    806  ND2 ASN A 118      38.075  36.268  56.355  1.00 37.50           N  
ATOM    807  N   LYS A 119      40.448  37.151  51.246  1.00 35.56           N  
ATOM    808  CA  LYS A 119      41.139  36.838  50.005  1.00 36.41           C  
ATOM    809  C   LYS A 119      42.391  36.011  50.267  1.00 37.08           C  
ATOM    810  O   LYS A 119      43.216  36.364  51.107  1.00 37.07           O  
ATOM    811  CB  LYS A 119      41.526  38.130  49.247  1.00 36.83           C  
ATOM    812  CG  LYS A 119      40.727  38.384  47.959  1.00 37.71           C  
ATOM    813  CD  LYS A 119      41.061  37.353  46.854  1.00 38.85           C  
ATOM    814  CE  LYS A 119      42.384  37.635  46.137  1.00 39.51           C  
ATOM    815  NZ  LYS A 119      43.250  36.411  46.100  1.00 40.66           N  
ATOM    816  N   ALA A 120      42.490  34.895  49.544  1.00 38.16           N  
ATOM    817  CA  ALA A 120      43.715  34.112  49.402  1.00 38.66           C  
ATOM    818  C   ALA A 120      44.069  33.327  50.677  1.00 39.30           C  
ATOM    819  O   ALA A 120      45.145  32.702  50.766  1.00 40.34           O  
ATOM    820  CB  ALA A 120      44.884  35.008  48.966  1.00 38.76           C  
TER     821      ALA A 120                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
