
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1111),  selected   75 , name 2gcx_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 2gcx_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      F       2           #
LGA    -       -      S       3           -
LGA    -       -      L       4           -
LGA    -       -      R       5           -
LGA    Q     2_A      D       6          4.223
LGA    F     3_A      A       7          2.453
LGA    T     4_A      K       8          2.048
LGA    P     5_A      C       9          1.544
LGA    D     6_A      G      10          0.875
LGA    S     7_A      Q      11          0.925
LGA    A     8_A      T      12          0.658
LGA    W     9_A      V      13          0.663
LGA    K    10_A      K      14          1.035
LGA    I    11_A      V      15          2.138
LGA    T    12_A      V      16          3.115
LGA    G    13_A      K      17          4.380
LGA    F    14_A      L      18          1.834
LGA    S    15_A      H      19          1.498
LGA    R    16_A      -       -           -
LGA    D    17_A      G      20          3.785
LGA    I    18_A      T      21          3.020
LGA    S    19_A      G      22          3.538
LGA    P    20_A      A      23          0.876
LGA    A    21_A      -       -           -
LGA    Y    22_A      L      24          2.693
LGA    R    23_A      K      25          1.880
LGA    Q    24_A      R      26          1.834
LGA    K    25_A      R      27          2.179
LGA    L    26_A      I      28          3.287
LGA    L    27_A      M      29          3.478
LGA    S    28_A      D      30          2.971
LGA    L    29_A      M      31          4.022
LGA    G    30_A      G      32          4.454
LGA    M    31_A      I      33          3.971
LGA    L    32_A      T      34          2.431
LGA    P    33_A      R      35          1.138
LGA    G    34_A      G      36          1.650
LGA    S    35_A      C      37          1.196
LGA    S    36_A      E      38          0.197
LGA    F    37_A      I      39          0.959
LGA    H    38_A      Y      40          0.727
LGA    V    39_A      I      41          0.941
LGA    V    40_A      R      42          1.492
LGA    R    41_A      K      43          1.220
LGA    V    42_A      V      44          1.310
LGA    A    43_A      A      45          4.148
LGA    P    44_A      -       -           -
LGA    L    45_A      -       -           -
LGA    G    46_A      G      48          2.037
LGA    D    47_A      D      49          2.331
LGA    P    48_A      P      50          0.785
LGA    V    49_A      I      51          0.755
LGA    H    50_A      Q      52          1.310
LGA    I    51_A      I      53          1.237
LGA    E    52_A      N      54          0.377
LGA    T    53_A      V      55          1.175
LGA    R    54_A      R      56          1.781
LGA    R    55_A      G      57          1.594
LGA    V    56_A      Y      58          1.120
LGA    S    57_A      E      59          1.978
LGA    L    58_A      L      60          3.059
LGA    V    59_A      S      61          1.880
LGA    L    60_A      L      62          1.658
LGA    R    61_A      R      63          2.627
LGA    K    62_A      K      64          2.766
LGA    K    63_A      S      65          3.157
LGA    D    64_A      A      66          2.266
LGA    L    65_A      A      67          1.772
LGA    A    66_A      E      68          1.965
LGA    L    67_A      M      69          1.226
LGA    I    68_A      I      70          1.143
LGA    E    69_A      E      71          0.542
LGA    L    70_A      V      72          1.053
LGA    E    71_A      E      73          0.872
LGA    A    72_A      -       -           -
LGA    V    73_A      -       -           -
LGA    A    74_A      -       -           -
LGA    Q    75_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75   70    5.0     66    2.24    25.76     68.474     2.816

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.886884 * X  +  -0.410770 * Y  +   0.211437 * Z  +  -1.225043
  Y_new =   0.021447 * X  +  -0.420562 * Y  +  -0.907010 * Z  +  -0.199256
  Z_new =   0.461495 * X  +   0.808947 * Y  +  -0.364180 * Z  +  -0.807207 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.993808   -1.147785  [ DEG:   114.2368    -65.7632 ]
  Theta =  -0.479679   -2.661913  [ DEG:   -27.4836   -152.5164 ]
  Phi   =   0.024178   -3.117414  [ DEG:     1.3853   -178.6147 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gcx_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gcx_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75   70   5.0   66   2.24   25.76  68.474
REMARK  ---------------------------------------------------------- 
MOLECULE 2gcx_A
HEADER    TRANSPORT PROTEIN                       14-MAR-06   2GCX              
TITLE     SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT PROTEIN A                
TITLE    2 (FEOA) OF KLEBSIELLA PNEUMONIAE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERROUS IRON TRANSPORT PROTEIN A;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: FEOA;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: KLEBSIELLA PNEUMONIAE;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-22B(+)                                
KEYWDS    KLEBSIELLA PNEUMONIAE, FEOA, FERROUS IRON TRANSPORT PROTEIN           
KEYWDS   2 A, NMR                                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,S.-F.TSAI,          
AUTHOR   2 T.-H.HUANG                                                           
REVDAT   1   20-MAR-07 2GCX    0                                                
JRNL        AUTH   K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,           
JRNL        AUTH 2 S.-F.TSAI,T.-H.HUANG                                         
JRNL        TITL   SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT                 
JRNL        TITL 2 PROTEIN A (FEOA) OF KLEBSIELLA PNEUMONIAE                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
SEQRES   1 A   75  MET GLN PHE THR PRO ASP SER ALA TRP LYS ILE THR GLY          
SEQRES   2 A   75  PHE SER ARG ASP ILE SER PRO ALA TYR ARG GLN LYS LEU          
SEQRES   3 A   75  LEU SER LEU GLY MET LEU PRO GLY SER SER PHE HIS VAL          
SEQRES   4 A   75  VAL ARG VAL ALA PRO LEU GLY ASP PRO VAL HIS ILE GLU          
SEQRES   5 A   75  THR ARG ARG VAL SER LEU VAL LEU ARG LYS LYS ASP LEU          
SEQRES   6 A   75  ALA LEU ILE GLU LEU GLU ALA VAL ALA GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -8.372  -2.070  11.132  1.00  3.33           N  
ATOM      2  CA  MET A   1      -6.983  -1.829  11.600  1.00  2.78           C  
ATOM      3  C   MET A   1      -5.990  -2.698  10.835  1.00  2.08           C  
ATOM      4  O   MET A   1      -4.940  -2.222  10.403  1.00  2.36           O  
ATOM      5  CB  MET A   1      -6.876  -2.118  13.099  1.00  2.93           C  
ATOM      6  CG  MET A   1      -5.485  -1.880  13.666  1.00  3.53           C  
ATOM      7  SD  MET A   1      -4.976  -0.154  13.556  1.00  4.37           S  
ATOM      8  CE  MET A   1      -3.323  -0.243  14.243  1.00  5.17           C  
ATOM      9  H2  MET A   1      -8.439  -1.903  10.108  1.00  3.82           H  
ATOM     10  HA  MET A   1      -6.742  -0.789  11.422  1.00  3.41           H  
ATOM     11  HB2 MET A   1      -7.570  -1.481  13.627  1.00  2.98           H  
ATOM     12  HG2 MET A   1      -5.478  -2.177  14.704  1.00  3.81           H  
ATOM     13  HE1 MET A   1      -3.374  -0.612  15.257  1.00  5.58           H  
ATOM     14  HE2 MET A   1      -2.721  -0.909  13.646  1.00  5.32           H  
ATOM     15  HE3 MET A   1      -2.880   0.743  14.240  1.00  5.50           H  
ATOM     16  H1  MET A   1      -8.650  -3.052  11.330  1.00  3.63           H  
ATOM     17  H3  MET A   1      -9.030  -1.429  11.619  1.00  3.53           H  
ATOM     18  N   GLN A   2      -6.329  -3.973  10.672  1.00  1.56           N  
ATOM     19  CA  GLN A   2      -5.464  -4.907   9.963  1.00  0.99           C  
ATOM     20  C   GLN A   2      -5.719  -4.855   8.460  1.00  0.83           C  
ATOM     21  O   GLN A   2      -6.738  -4.331   8.010  1.00  1.25           O  
ATOM     22  CB  GLN A   2      -5.687  -6.329  10.481  1.00  1.05           C  
ATOM     23  CG  GLN A   2      -5.531  -6.455  11.984  1.00  1.64           C  
ATOM     24  CD  GLN A   2      -5.947  -7.818  12.503  1.00  2.33           C  
ATOM     25  OE1 GLN A   2      -5.827  -8.825  11.803  1.00  2.91           O  
ATOM     26  NE2 GLN A   2      -6.438  -7.858  13.736  1.00  2.94           N  
ATOM     27  H   GLN A   2      -7.179  -4.292  11.038  1.00  1.91           H  
ATOM     28  HA  GLN A   2      -4.441  -4.621  10.152  1.00  1.23           H  
ATOM     29  HB2 GLN A   2      -6.682  -6.648  10.213  1.00  1.72           H  
ATOM     30  HG2 GLN A   2      -4.496  -6.294  12.235  1.00  2.05           H  
ATOM     31 HE21 GLN A   2      -6.504  -7.016  14.235  1.00  3.09           H  
ATOM     32 HE22 GLN A   2      -6.713  -8.727  14.098  1.00  3.52           H  
ATOM     33  N   PHE A   3      -4.785  -5.403   7.689  1.00  0.64           N  
ATOM     34  CA  PHE A   3      -4.905  -5.422   6.236  1.00  0.59           C  
ATOM     35  C   PHE A   3      -5.122  -6.845   5.729  1.00  0.50           C  
ATOM     36  O   PHE A   3      -4.220  -7.680   5.795  1.00  0.55           O  
ATOM     37  CB  PHE A   3      -3.653  -4.822   5.593  1.00  0.80           C  
ATOM     38  CG  PHE A   3      -3.408  -3.390   5.974  1.00  0.75           C  
ATOM     39  CD1 PHE A   3      -2.646  -3.074   7.087  1.00  0.80           C  
ATOM     40  CD2 PHE A   3      -3.939  -2.357   5.216  1.00  1.47           C  
ATOM     41  CE1 PHE A   3      -2.419  -1.757   7.438  1.00  1.39           C  
ATOM     42  CE2 PHE A   3      -3.715  -1.038   5.562  1.00  2.25           C  
ATOM     43  CZ  PHE A   3      -2.955  -0.738   6.676  1.00  2.18           C  
ATOM     44  H   PHE A   3      -3.994  -5.804   8.109  1.00  0.92           H  
ATOM     45  HA  PHE A   3      -5.761  -4.822   5.967  1.00  0.71           H  
ATOM     46  HB2 PHE A   3      -2.791  -5.398   5.894  1.00  1.45           H  
ATOM     47  HD1 PHE A   3      -2.228  -3.871   7.685  1.00  0.91           H  
ATOM     48  HD2 PHE A   3      -4.535  -2.592   4.347  1.00  1.57           H  
ATOM     49  HE1 PHE A   3      -1.823  -1.526   8.308  1.00  1.42           H  
ATOM     50  HE2 PHE A   3      -4.135  -0.243   4.965  1.00  2.96           H  
ATOM     51  HZ  PHE A   3      -2.778   0.293   6.949  1.00  2.81           H  
ATOM     52  N   THR A   4      -6.323  -7.112   5.226  1.00  0.53           N  
ATOM     53  CA  THR A   4      -6.657  -8.434   4.710  1.00  0.49           C  
ATOM     54  C   THR A   4      -6.780  -8.424   3.188  1.00  0.45           C  
ATOM     55  O   THR A   4      -7.150  -7.410   2.596  1.00  0.45           O  
ATOM     56  CB  THR A   4      -7.970  -8.959   5.314  1.00  0.57           C  
ATOM     57  OG1 THR A   4      -9.001  -7.971   5.181  1.00  0.61           O  
ATOM     58  CG2 THR A   4      -7.783  -9.316   6.781  1.00  0.66           C  
ATOM     59  H   THR A   4      -7.000  -6.405   5.205  1.00  0.66           H  
ATOM     60  HA  THR A   4      -5.863  -9.112   4.988  1.00  0.50           H  
ATOM     61  HB  THR A   4      -8.266  -9.849   4.778  1.00  0.57           H  
ATOM     62  HG1 THR A   4      -9.745  -8.205   5.742  1.00  1.09           H  
ATOM     63 HG21 THR A   4      -8.720  -9.667   7.189  1.00  1.23           H  
ATOM     64 HG22 THR A   4      -7.459  -8.442   7.325  1.00  1.30           H  
ATOM     65 HG23 THR A   4      -7.039 -10.093   6.869  1.00  1.11           H  
ATOM     66  N   PRO A   5      -6.471  -9.559   2.537  1.00  0.47           N  
ATOM     67  CA  PRO A   5      -6.550  -9.678   1.081  1.00  0.51           C  
ATOM     68  C   PRO A   5      -7.990  -9.705   0.578  1.00  0.51           C  
ATOM     69  O   PRO A   5      -8.572 -10.771   0.383  1.00  0.65           O  
ATOM     70  CB  PRO A   5      -5.858 -11.014   0.798  1.00  0.62           C  
ATOM     71  CG  PRO A   5      -6.043 -11.806   2.046  1.00  0.58           C  
ATOM     72  CD  PRO A   5      -6.019 -10.813   3.174  1.00  0.53           C  
ATOM     73  HA  PRO A   5      -6.013  -8.881   0.589  1.00  0.60           H  
ATOM     74  HB2 PRO A   5      -6.325 -11.493  -0.050  1.00  0.77           H  
ATOM     75  HG2 PRO A   5      -6.992 -12.320   2.018  1.00  0.73           H  
ATOM     76  HD2 PRO A   5      -6.700 -11.115   3.957  1.00  0.56           H  
ATOM     77  N   ASP A   6      -8.559  -8.520   0.375  1.00  0.74           N  
ATOM     78  CA  ASP A   6      -9.931  -8.399  -0.107  1.00  0.84           C  
ATOM     79  C   ASP A   6     -10.349  -6.936  -0.195  1.00  0.71           C  
ATOM     80  O   ASP A   6     -11.031  -6.532  -1.138  1.00  0.67           O  
ATOM     81  CB  ASP A   6     -10.889  -9.156   0.818  1.00  1.07           C  
ATOM     82  CG  ASP A   6     -10.822  -8.663   2.249  1.00  2.06           C  
ATOM     83  OD1 ASP A   6      -9.991  -9.186   3.020  1.00  2.69           O  
ATOM     84  OD2 ASP A   6     -11.598  -7.749   2.598  1.00  2.51           O  
ATOM     85  H   ASP A   6      -8.044  -7.706   0.555  1.00  0.97           H  
ATOM     86  HA  ASP A   6      -9.976  -8.835  -1.093  1.00  0.95           H  
ATOM     87  HB2 ASP A   6     -11.898  -9.028   0.460  1.00  1.14           H  
ATOM     88  N   SER A   7      -9.941  -6.147   0.791  1.00  0.77           N  
ATOM     89  CA  SER A   7     -10.275  -4.729   0.824  1.00  0.72           C  
ATOM     90  C   SER A   7      -9.281  -3.914   0.000  1.00  0.54           C  
ATOM     91  O   SER A   7      -8.201  -4.396  -0.341  1.00  0.67           O  
ATOM     92  CB  SER A   7     -10.300  -4.224   2.267  1.00  0.96           C  
ATOM     93  OG  SER A   7     -10.607  -2.842   2.318  1.00  1.89           O  
ATOM     94  H   SER A   7      -9.402  -6.529   1.516  1.00  0.90           H  
ATOM     95  HA  SER A   7     -11.259  -4.611   0.394  1.00  0.72           H  
ATOM     96  HB2 SER A   7     -11.047  -4.767   2.824  1.00  1.05           H  
ATOM     97  HG  SER A   7      -9.859  -2.360   2.681  1.00  2.32           H  
ATOM     98  N   ALA A   8      -9.653  -2.678  -0.313  1.00  0.47           N  
ATOM     99  CA  ALA A   8      -8.795  -1.797  -1.100  1.00  0.35           C  
ATOM    100  C   ALA A   8      -8.120  -0.751  -0.219  1.00  0.31           C  
ATOM    101  O   ALA A   8      -8.514  -0.543   0.930  1.00  0.38           O  
ATOM    102  CB  ALA A   8      -9.603  -1.121  -2.200  1.00  0.44           C  
ATOM    103  H   ALA A   8     -10.525  -2.348  -0.008  1.00  0.66           H  
ATOM    104  HA  ALA A   8      -8.034  -2.404  -1.567  1.00  0.35           H  
ATOM    105  HB1 ALA A   8     -10.318  -0.444  -1.757  1.00  1.16           H  
ATOM    106  HB2 ALA A   8      -8.937  -0.569  -2.846  1.00  1.04           H  
ATOM    107  HB3 ALA A   8     -10.125  -1.870  -2.775  1.00  1.13           H  
ATOM    108  N   TRP A   9      -7.099  -0.094  -0.764  1.00  0.30           N  
ATOM    109  CA  TRP A   9      -6.365   0.933  -0.030  1.00  0.30           C  
ATOM    110  C   TRP A   9      -5.707   1.920  -0.990  1.00  0.32           C  
ATOM    111  O   TRP A   9      -5.746   1.736  -2.207  1.00  0.39           O  
ATOM    112  CB  TRP A   9      -5.305   0.291   0.865  1.00  0.34           C  
ATOM    113  CG  TRP A   9      -5.858  -0.753   1.786  1.00  0.35           C  
ATOM    114  CD1 TRP A   9      -6.044  -2.076   1.506  1.00  0.40           C  
ATOM    115  CD2 TRP A   9      -6.296  -0.562   3.137  1.00  0.42           C  
ATOM    116  NE1 TRP A   9      -6.571  -2.718   2.599  1.00  0.41           N  
ATOM    117  CE2 TRP A   9      -6.735  -1.813   3.613  1.00  0.42           C  
ATOM    118  CE3 TRP A   9      -6.360   0.543   3.991  1.00  0.56           C  
ATOM    119  CZ2 TRP A   9      -7.231  -1.987   4.903  1.00  0.52           C  
ATOM    120  CZ3 TRP A   9      -6.852   0.368   5.271  1.00  0.69           C  
ATOM    121  CH2 TRP A   9      -7.281  -0.887   5.716  1.00  0.66           C  
ATOM    122  H   TRP A   9      -6.832  -0.306  -1.682  1.00  0.34           H  
ATOM    123  HA  TRP A   9      -7.072   1.467   0.590  1.00  0.31           H  
ATOM    124  HB2 TRP A   9      -4.556  -0.176   0.244  1.00  0.36           H  
ATOM    125  HD1 TRP A   9      -5.807  -2.535   0.558  1.00  0.49           H  
ATOM    126  HE1 TRP A   9      -6.794  -3.673   2.645  1.00  0.47           H  
ATOM    127  HE3 TRP A   9      -6.034   1.519   3.665  1.00  0.60           H  
ATOM    128  HZ2 TRP A   9      -7.565  -2.948   5.262  1.00  0.54           H  
ATOM    129  HZ3 TRP A   9      -6.909   1.212   5.945  1.00  0.84           H  
ATOM    130  HH2 TRP A   9      -7.659  -0.977   6.724  1.00  0.77           H  
ATOM    131  N   LYS A  10      -5.102   2.968  -0.437  1.00  0.34           N  
ATOM    132  CA  LYS A  10      -4.435   3.979  -1.247  1.00  0.37           C  
ATOM    133  C   LYS A  10      -3.002   4.205  -0.771  1.00  0.34           C  
ATOM    134  O   LYS A  10      -2.750   4.331   0.428  1.00  0.34           O  
ATOM    135  CB  LYS A  10      -5.215   5.295  -1.207  1.00  0.43           C  
ATOM    136  CG  LYS A  10      -6.619   5.184  -1.780  1.00  1.01           C  
ATOM    137  CD  LYS A  10      -7.391   6.483  -1.620  1.00  1.03           C  
ATOM    138  CE  LYS A  10      -8.775   6.386  -2.243  1.00  1.28           C  
ATOM    139  NZ  LYS A  10      -9.563   7.633  -2.042  1.00  2.04           N  
ATOM    140  H   LYS A  10      -5.106   3.063   0.538  1.00  0.40           H  
ATOM    141  HA  LYS A  10      -4.408   3.620  -2.266  1.00  0.42           H  
ATOM    142  HB2 LYS A  10      -5.291   5.622  -0.180  1.00  0.74           H  
ATOM    143  HG2 LYS A  10      -6.550   4.943  -2.829  1.00  1.60           H  
ATOM    144  HD2 LYS A  10      -7.495   6.703  -0.569  1.00  1.63           H  
ATOM    145  HE2 LYS A  10      -8.667   6.205  -3.301  1.00  1.73           H  
ATOM    146  HZ1 LYS A  10      -9.709   7.805  -1.027  1.00  2.50           H  
ATOM    147  HZ2 LYS A  10     -10.491   7.547  -2.505  1.00  2.52           H  
ATOM    148  HZ3 LYS A  10      -9.059   8.445  -2.452  1.00  2.42           H  
ATOM    149  N   ILE A  11      -2.068   4.257  -1.717  1.00  0.36           N  
ATOM    150  CA  ILE A  11      -0.663   4.463  -1.396  1.00  0.36           C  
ATOM    151  C   ILE A  11      -0.389   5.910  -1.004  1.00  0.32           C  
ATOM    152  O   ILE A  11      -0.719   6.839  -1.743  1.00  0.38           O  
ATOM    153  CB  ILE A  11       0.245   4.083  -2.581  1.00  0.41           C  
ATOM    154  CG1 ILE A  11      -0.007   2.631  -2.998  1.00  0.48           C  
ATOM    155  CG2 ILE A  11       1.710   4.288  -2.222  1.00  0.43           C  
ATOM    156  CD1 ILE A  11       0.861   2.172  -4.150  1.00  0.56           C  
ATOM    157  H   ILE A  11      -2.333   4.157  -2.654  1.00  0.39           H  
ATOM    158  HA  ILE A  11      -0.415   3.822  -0.562  1.00  0.38           H  
ATOM    159  HB  ILE A  11       0.009   4.732  -3.411  1.00  0.41           H  
ATOM    160 HG12 ILE A  11       0.190   1.984  -2.158  1.00  0.50           H  
ATOM    161 HG21 ILE A  11       2.330   4.014  -3.063  1.00  1.11           H  
ATOM    162 HG22 ILE A  11       1.877   5.326  -1.974  1.00  0.98           H  
ATOM    163 HG23 ILE A  11       1.961   3.671  -1.372  1.00  1.04           H  
ATOM    164 HD11 ILE A  11       1.901   2.267  -3.879  1.00  1.01           H  
ATOM    165 HD12 ILE A  11       0.638   1.140  -4.376  1.00  1.20           H  
ATOM    166 HD13 ILE A  11       0.658   2.783  -5.019  1.00  1.21           H  
ATOM    167  N   THR A  12       0.217   6.089   0.167  1.00  0.28           N  
ATOM    168  CA  THR A  12       0.545   7.415   0.670  1.00  0.27           C  
ATOM    169  C   THR A  12       1.919   7.412   1.332  1.00  0.27           C  
ATOM    170  O   THR A  12       2.092   7.912   2.443  1.00  0.30           O  
ATOM    171  CB  THR A  12      -0.510   7.904   1.682  1.00  0.30           C  
ATOM    172  OG1 THR A  12      -1.825   7.697   1.156  1.00  0.91           O  
ATOM    173  CG2 THR A  12      -0.317   9.381   2.000  1.00  0.97           C  
ATOM    174  H   THR A  12       0.450   5.304   0.705  1.00  0.31           H  
ATOM    175  HA  THR A  12       0.558   8.097  -0.167  1.00  0.27           H  
ATOM    176  HB  THR A  12      -0.400   7.337   2.595  1.00  0.71           H  
ATOM    177  HG1 THR A  12      -2.082   6.781   1.287  1.00  1.25           H  
ATOM    178 HG21 THR A  12      -0.348   9.951   1.085  1.00  1.46           H  
ATOM    179 HG22 THR A  12       0.638   9.525   2.483  1.00  1.48           H  
ATOM    180 HG23 THR A  12      -1.106   9.712   2.658  1.00  1.64           H  
ATOM    181  N   GLY A  13       2.896   6.836   0.638  1.00  0.29           N  
ATOM    182  CA  GLY A  13       4.247   6.771   1.167  1.00  0.33           C  
ATOM    183  C   GLY A  13       4.759   8.115   1.645  1.00  0.37           C  
ATOM    184  O   GLY A  13       5.327   8.884   0.869  1.00  0.45           O  
ATOM    185  H   GLY A  13       2.694   6.447  -0.236  1.00  0.31           H  
ATOM    186  HA2 GLY A  13       4.266   6.077   1.994  1.00  0.31           H  
ATOM    187  HA3 GLY A  13       4.904   6.404   0.392  1.00  0.39           H  
ATOM    188  N   PHE A  14       4.556   8.401   2.926  1.00  0.34           N  
ATOM    189  CA  PHE A  14       5.003   9.659   3.513  1.00  0.41           C  
ATOM    190  C   PHE A  14       5.402   9.464   4.972  1.00  0.39           C  
ATOM    191  O   PHE A  14       4.549   9.463   5.861  1.00  0.43           O  
ATOM    192  CB  PHE A  14       3.906  10.719   3.406  1.00  0.50           C  
ATOM    193  CG  PHE A  14       4.276  12.030   4.036  1.00  0.60           C  
ATOM    194  CD1 PHE A  14       4.004  12.275   5.372  1.00  0.69           C  
ATOM    195  CD2 PHE A  14       4.894  13.022   3.289  1.00  0.70           C  
ATOM    196  CE1 PHE A  14       4.347  13.482   5.954  1.00  0.79           C  
ATOM    197  CE2 PHE A  14       5.237  14.229   3.865  1.00  0.81           C  
ATOM    198  CZ  PHE A  14       4.962  14.461   5.198  1.00  0.81           C  
ATOM    199  H   PHE A  14       4.093   7.750   3.493  1.00  0.30           H  
ATOM    200  HA  PHE A  14       5.869   9.993   2.959  1.00  0.45           H  
ATOM    201  HB2 PHE A  14       3.689  10.899   2.364  1.00  0.53           H  
ATOM    202  HD1 PHE A  14       3.524  11.511   5.964  1.00  0.75           H  
ATOM    203  HD2 PHE A  14       5.110  12.842   2.246  1.00  0.77           H  
ATOM    204  HE1 PHE A  14       4.130  13.660   6.997  1.00  0.91           H  
ATOM    205  HE2 PHE A  14       5.719  14.994   3.272  1.00  0.93           H  
ATOM    206  HZ  PHE A  14       5.229  15.406   5.651  1.00  0.90           H  
ATOM    207  N   SER A  15       6.698   9.290   5.212  1.00  0.40           N  
ATOM    208  CA  SER A  15       7.201   9.093   6.567  1.00  0.41           C  
ATOM    209  C   SER A  15       7.905  10.348   7.071  1.00  0.43           C  
ATOM    210  O   SER A  15       7.922  11.377   6.396  1.00  0.48           O  
ATOM    211  CB  SER A  15       8.166   7.907   6.607  1.00  0.39           C  
ATOM    212  OG  SER A  15       7.591   6.760   6.008  1.00  0.76           O  
ATOM    213  H   SER A  15       7.329   9.294   4.464  1.00  0.43           H  
ATOM    214  HA  SER A  15       6.358   8.884   7.208  1.00  0.45           H  
ATOM    215  HB2 SER A  15       9.067   8.163   6.074  1.00  0.73           H  
ATOM    216  HG  SER A  15       7.439   6.927   5.074  1.00  1.26           H  
ATOM    217  N   ARG A  16       8.481  10.255   8.265  1.00  0.57           N  
ATOM    218  CA  ARG A  16       9.189  11.382   8.861  1.00  0.61           C  
ATOM    219  C   ARG A  16      10.642  11.424   8.396  1.00  0.59           C  
ATOM    220  O   ARG A  16      11.289  12.470   8.450  1.00  0.63           O  
ATOM    221  CB  ARG A  16       9.138  11.297  10.388  1.00  0.69           C  
ATOM    222  CG  ARG A  16       7.730  11.337  10.962  1.00  1.14           C  
ATOM    223  CD  ARG A  16       6.971  10.050  10.679  1.00  1.37           C  
ATOM    224  NE  ARG A  16       5.770   9.935  11.503  1.00  2.19           N  
ATOM    225  CZ  ARG A  16       4.901   8.935  11.400  1.00  2.67           C  
ATOM    226  NH1 ARG A  16       5.095   7.975  10.506  1.00  2.41           N  
ATOM    227  NH2 ARG A  16       3.836   8.895  12.190  1.00  3.58           N  
ATOM    228  H   ARG A  16       8.431   9.409   8.756  1.00  0.72           H  
ATOM    229  HA  ARG A  16       8.696  12.288   8.544  1.00  0.65           H  
ATOM    230  HB2 ARG A  16       9.602  10.372  10.701  1.00  1.39           H  
ATOM    231  HG2 ARG A  16       7.792  11.478  12.032  1.00  1.69           H  
ATOM    232  HD2 ARG A  16       6.682  10.037   9.639  1.00  1.50           H  
ATOM    233  HE  ARG A  16       5.606  10.636  12.167  1.00  2.55           H  
ATOM    234 HH11 ARG A  16       5.896   8.003   9.909  1.00  1.97           H  
ATOM    235 HH12 ARG A  16       4.441   7.224  10.430  1.00  2.83           H  
ATOM    236 HH21 ARG A  16       3.687   9.620  12.864  1.00  3.94           H  
ATOM    237 HH22 ARG A  16       3.183   8.143  12.112  1.00  3.96           H  
ATOM    238  N   ASP A  17      11.152  10.284   7.941  1.00  0.58           N  
ATOM    239  CA  ASP A  17      12.533  10.198   7.474  1.00  0.63           C  
ATOM    240  C   ASP A  17      12.670   9.182   6.343  1.00  0.57           C  
ATOM    241  O   ASP A  17      13.732   8.592   6.155  1.00  0.62           O  
ATOM    242  CB  ASP A  17      13.455   9.813   8.632  1.00  0.77           C  
ATOM    243  CG  ASP A  17      13.066   8.492   9.269  1.00  1.61           C  
ATOM    244  OD1 ASP A  17      12.249   8.508  10.214  1.00  2.48           O  
ATOM    245  OD2 ASP A  17      13.577   7.444   8.821  1.00  1.86           O  
ATOM    246  H   ASP A  17      10.591   9.481   7.920  1.00  0.56           H  
ATOM    247  HA  ASP A  17      12.819  11.172   7.106  1.00  0.66           H  
ATOM    248  HB2 ASP A  17      14.466   9.730   8.265  1.00  1.47           H  
ATOM    249  N   ILE A  18      11.591   8.990   5.586  1.00  0.51           N  
ATOM    250  CA  ILE A  18      11.594   8.042   4.474  1.00  0.50           C  
ATOM    251  C   ILE A  18      12.845   8.200   3.612  1.00  0.50           C  
ATOM    252  O   ILE A  18      13.118   9.281   3.089  1.00  0.57           O  
ATOM    253  CB  ILE A  18      10.351   8.218   3.581  1.00  0.48           C  
ATOM    254  CG1 ILE A  18      10.356   7.186   2.453  1.00  0.52           C  
ATOM    255  CG2 ILE A  18      10.298   9.628   3.017  1.00  0.47           C  
ATOM    256  CD1 ILE A  18       9.112   7.226   1.594  1.00  0.56           C  
ATOM    257  H   ILE A  18      10.773   9.491   5.783  1.00  0.50           H  
ATOM    258  HA  ILE A  18      11.577   7.045   4.885  1.00  0.56           H  
ATOM    259  HB  ILE A  18       9.473   8.070   4.191  1.00  0.53           H  
ATOM    260 HG12 ILE A  18      11.208   7.366   1.813  1.00  0.51           H  
ATOM    261 HG21 ILE A  18       9.366   9.774   2.491  1.00  1.10           H  
ATOM    262 HG22 ILE A  18      10.369  10.343   3.824  1.00  1.06           H  
ATOM    263 HG23 ILE A  18      11.123   9.775   2.335  1.00  1.17           H  
ATOM    264 HD11 ILE A  18       8.246   7.013   2.204  1.00  1.15           H  
ATOM    265 HD12 ILE A  18       9.009   8.207   1.154  1.00  1.11           H  
ATOM    266 HD13 ILE A  18       9.189   6.486   0.810  1.00  1.13           H  
ATOM    267  N   SER A  19      13.599   7.115   3.470  1.00  0.57           N  
ATOM    268  CA  SER A  19      14.822   7.131   2.675  1.00  0.59           C  
ATOM    269  C   SER A  19      14.502   7.192   1.185  1.00  0.52           C  
ATOM    270  O   SER A  19      13.424   6.781   0.755  1.00  0.50           O  
ATOM    271  CB  SER A  19      15.666   5.893   2.978  1.00  0.70           C  
ATOM    272  OG  SER A  19      14.955   4.704   2.674  1.00  1.50           O  
ATOM    273  H   SER A  19      13.326   6.283   3.912  1.00  0.68           H  
ATOM    274  HA  SER A  19      15.382   8.013   2.946  1.00  0.59           H  
ATOM    275  HB2 SER A  19      16.568   5.919   2.382  1.00  1.12           H  
ATOM    276  HG  SER A  19      15.573   4.023   2.394  1.00  2.01           H  
ATOM    277  N   PRO A  20      15.442   7.710   0.373  1.00  0.54           N  
ATOM    278  CA  PRO A  20      15.255   7.822  -1.076  1.00  0.51           C  
ATOM    279  C   PRO A  20      15.181   6.462  -1.756  1.00  0.53           C  
ATOM    280  O   PRO A  20      14.551   6.313  -2.802  1.00  0.51           O  
ATOM    281  CB  PRO A  20      16.499   8.586  -1.543  1.00  0.55           C  
ATOM    282  CG  PRO A  20      17.518   8.340  -0.486  1.00  0.61           C  
ATOM    283  CD  PRO A  20      16.757   8.219   0.804  1.00  0.61           C  
ATOM    284  HA  PRO A  20      14.369   8.392  -1.317  1.00  0.49           H  
ATOM    285  HB2 PRO A  20      16.820   8.203  -2.501  1.00  0.56           H  
ATOM    286  HG2 PRO A  20      18.050   7.423  -0.695  1.00  0.64           H  
ATOM    287  HD2 PRO A  20      17.244   7.517   1.466  1.00  0.68           H  
ATOM    288  N   ALA A  21      15.824   5.467  -1.157  1.00  0.58           N  
ATOM    289  CA  ALA A  21      15.819   4.117  -1.709  1.00  0.64           C  
ATOM    290  C   ALA A  21      14.396   3.663  -2.019  1.00  0.62           C  
ATOM    291  O   ALA A  21      14.129   3.104  -3.080  1.00  0.65           O  
ATOM    292  CB  ALA A  21      16.488   3.149  -0.744  1.00  0.71           C  
ATOM    293  H   ALA A  21      16.315   5.645  -0.328  1.00  0.61           H  
ATOM    294  HA  ALA A  21      16.391   4.130  -2.625  1.00  0.66           H  
ATOM    295  HB1 ALA A  21      17.509   3.456  -0.575  1.00  1.32           H  
ATOM    296  HB2 ALA A  21      15.952   3.150   0.195  1.00  1.13           H  
ATOM    297  HB3 ALA A  21      16.475   2.155  -1.166  1.00  1.30           H  
ATOM    298  N   TYR A  22      13.489   3.909  -1.079  1.00  0.60           N  
ATOM    299  CA  TYR A  22      12.090   3.531  -1.248  1.00  0.61           C  
ATOM    300  C   TYR A  22      11.315   4.612  -1.997  1.00  0.54           C  
ATOM    301  O   TYR A  22      10.437   4.311  -2.806  1.00  0.57           O  
ATOM    302  CB  TYR A  22      11.440   3.277   0.113  1.00  0.66           C  
ATOM    303  CG  TYR A  22      12.052   2.123   0.874  1.00  0.90           C  
ATOM    304  CD1 TYR A  22      11.712   0.810   0.571  1.00  0.99           C  
ATOM    305  CD2 TYR A  22      12.972   2.347   1.891  1.00  1.28           C  
ATOM    306  CE1 TYR A  22      12.268  -0.247   1.264  1.00  1.34           C  
ATOM    307  CE2 TYR A  22      13.533   1.292   2.588  1.00  1.72           C  
ATOM    308  CZ  TYR A  22      13.178  -0.001   2.270  1.00  1.72           C  
ATOM    309  OH  TYR A  22      13.734  -1.053   2.963  1.00  2.17           O  
ATOM    310  H   TYR A  22      13.767   4.354  -0.252  1.00  0.60           H  
ATOM    311  HA  TYR A  22      12.062   2.620  -1.824  1.00  0.66           H  
ATOM    312  HB2 TYR A  22      11.540   4.163   0.722  1.00  0.78           H  
ATOM    313  HD1 TYR A  22      11.001   0.622  -0.219  1.00  0.96           H  
ATOM    314  HD2 TYR A  22      13.248   3.360   2.136  1.00  1.30           H  
ATOM    315  HE1 TYR A  22      11.991  -1.261   1.015  1.00  1.41           H  
ATOM    316  HE2 TYR A  22      14.246   1.485   3.376  1.00  2.11           H  
ATOM    317  HH  TYR A  22      13.972  -1.751   2.349  1.00  2.53           H  
ATOM    318  N   ARG A  23      11.644   5.870  -1.721  1.00  0.48           N  
ATOM    319  CA  ARG A  23      10.970   6.994  -2.363  1.00  0.44           C  
ATOM    320  C   ARG A  23      11.349   7.100  -3.839  1.00  0.45           C  
ATOM    321  O   ARG A  23      10.493   6.992  -4.719  1.00  0.45           O  
ATOM    322  CB  ARG A  23      11.323   8.299  -1.646  1.00  0.45           C  
ATOM    323  CG  ARG A  23      10.646   9.522  -2.241  1.00  0.54           C  
ATOM    324  CD  ARG A  23       9.137   9.452  -2.085  1.00  0.53           C  
ATOM    325  NE  ARG A  23       8.471  10.621  -2.652  1.00  0.70           N  
ATOM    326  CZ  ARG A  23       7.245  11.005  -2.316  1.00  1.08           C  
ATOM    327  NH1 ARG A  23       6.551  10.310  -1.424  1.00  1.57           N  
ATOM    328  NH2 ARG A  23       6.711  12.083  -2.871  1.00  1.47           N  
ATOM    329  H   ARG A  23      12.356   6.046  -1.071  1.00  0.51           H  
ATOM    330  HA  ARG A  23       9.906   6.831  -2.288  1.00  0.44           H  
ATOM    331  HB2 ARG A  23      11.027   8.218  -0.611  1.00  0.49           H  
ATOM    332  HG2 ARG A  23      11.009  10.405  -1.734  1.00  0.91           H  
ATOM    333  HD2 ARG A  23       8.777   8.566  -2.588  1.00  0.89           H  
ATOM    334  HE  ARG A  23       8.965  11.148  -3.314  1.00  1.08           H  
ATOM    335 HH11 ARG A  23       6.950   9.493  -1.005  1.00  1.70           H  
ATOM    336 HH12 ARG A  23       5.628  10.602  -1.171  1.00  2.02           H  
ATOM    337 HH21 ARG A  23       7.231  12.610  -3.543  1.00  1.70           H  
ATOM    338 HH22 ARG A  23       5.787  12.371  -2.617  1.00  1.78           H  
ATOM    339  N   GLN A  24      12.634   7.307  -4.100  1.00  0.49           N  
ATOM    340  CA  GLN A  24      13.131   7.435  -5.464  1.00  0.55           C  
ATOM    341  C   GLN A  24      12.804   6.197  -6.299  1.00  0.58           C  
ATOM    342  O   GLN A  24      12.830   6.246  -7.528  1.00  0.66           O  
ATOM    343  CB  GLN A  24      14.644   7.666  -5.453  1.00  0.69           C  
ATOM    344  CG  GLN A  24      15.239   7.883  -6.837  1.00  1.52           C  
ATOM    345  CD  GLN A  24      16.744   8.052  -6.804  1.00  2.03           C  
ATOM    346  OE1 GLN A  24      17.303   8.547  -5.825  1.00  2.61           O  
ATOM    347  NE2 GLN A  24      17.409   7.644  -7.877  1.00  2.69           N  
ATOM    348  H   GLN A  24      13.268   7.377  -3.353  1.00  0.51           H  
ATOM    349  HA  GLN A  24      12.651   8.291  -5.912  1.00  0.55           H  
ATOM    350  HB2 GLN A  24      14.859   8.539  -4.853  1.00  1.07           H  
ATOM    351  HG2 GLN A  24      15.000   7.029  -7.454  1.00  2.31           H  
ATOM    352 HE21 GLN A  24      16.898   7.260  -8.621  1.00  2.90           H  
ATOM    353 HE22 GLN A  24      18.385   7.741  -7.884  1.00  3.29           H  
ATOM    354  N   LYS A  25      12.498   5.091  -5.629  1.00  0.59           N  
ATOM    355  CA  LYS A  25      12.172   3.849  -6.310  1.00  0.68           C  
ATOM    356  C   LYS A  25      10.766   3.899  -6.904  1.00  0.61           C  
ATOM    357  O   LYS A  25      10.583   3.720  -8.108  1.00  0.71           O  
ATOM    358  CB  LYS A  25      12.294   2.677  -5.338  1.00  0.79           C  
ATOM    359  CG  LYS A  25      11.784   1.364  -5.899  1.00  0.99           C  
ATOM    360  CD  LYS A  25      11.794   0.268  -4.847  1.00  1.43           C  
ATOM    361  CE  LYS A  25      13.193   0.031  -4.302  1.00  2.05           C  
ATOM    362  NZ  LYS A  25      14.140  -0.401  -5.366  1.00  2.59           N  
ATOM    363  H   LYS A  25      12.488   5.107  -4.650  1.00  0.60           H  
ATOM    364  HA  LYS A  25      12.884   3.715  -7.112  1.00  0.77           H  
ATOM    365  HB2 LYS A  25      13.333   2.550  -5.072  1.00  1.21           H  
ATOM    366  HG2 LYS A  25      10.772   1.510  -6.245  1.00  1.59           H  
ATOM    367  HD2 LYS A  25      11.145   0.556  -4.034  1.00  1.99           H  
ATOM    368  HE2 LYS A  25      13.553   0.951  -3.864  1.00  2.54           H  
ATOM    369  HZ1 LYS A  25      13.808  -1.286  -5.802  1.00  3.07           H  
ATOM    370  HZ2 LYS A  25      15.084  -0.561  -4.960  1.00  2.83           H  
ATOM    371  HZ3 LYS A  25      14.209   0.331  -6.102  1.00  2.95           H  
ATOM    372  N   LEU A  26       9.776   4.140  -6.051  1.00  0.55           N  
ATOM    373  CA  LEU A  26       8.387   4.205  -6.493  1.00  0.57           C  
ATOM    374  C   LEU A  26       8.238   5.130  -7.697  1.00  0.60           C  
ATOM    375  O   LEU A  26       7.372   4.924  -8.547  1.00  0.68           O  
ATOM    376  CB  LEU A  26       7.487   4.682  -5.351  1.00  0.55           C  
ATOM    377  CG  LEU A  26       7.481   3.780  -4.115  1.00  0.69           C  
ATOM    378  CD1 LEU A  26       6.526   4.322  -3.061  1.00  1.30           C  
ATOM    379  CD2 LEU A  26       7.100   2.358  -4.498  1.00  1.29           C  
ATOM    380  H   LEU A  26       9.983   4.278  -5.103  1.00  0.57           H  
ATOM    381  HA  LEU A  26       8.087   3.209  -6.781  1.00  0.69           H  
ATOM    382  HB2 LEU A  26       7.814   5.666  -5.050  1.00  0.66           H  
ATOM    383  HG  LEU A  26       8.473   3.758  -3.687  1.00  1.38           H  
ATOM    384 HD11 LEU A  26       6.510   3.654  -2.213  1.00  1.69           H  
ATOM    385 HD12 LEU A  26       6.857   5.300  -2.744  1.00  1.94           H  
ATOM    386 HD13 LEU A  26       5.533   4.396  -3.479  1.00  1.82           H  
ATOM    387 HD21 LEU A  26       7.829   1.965  -5.193  1.00  1.87           H  
ATOM    388 HD22 LEU A  26       7.078   1.739  -3.612  1.00  1.79           H  
ATOM    389 HD23 LEU A  26       6.125   2.358  -4.961  1.00  1.79           H  
ATOM    390  N   LEU A  27       9.087   6.150  -7.765  1.00  0.59           N  
ATOM    391  CA  LEU A  27       9.051   7.101  -8.866  1.00  0.71           C  
ATOM    392  C   LEU A  27       9.075   6.383 -10.212  1.00  0.82           C  
ATOM    393  O   LEU A  27       8.466   6.836 -11.181  1.00  0.95           O  
ATOM    394  CB  LEU A  27      10.231   8.070  -8.772  1.00  0.75           C  
ATOM    395  CG  LEU A  27      10.294   8.896  -7.487  1.00  0.71           C  
ATOM    396  CD1 LEU A  27      11.480   9.847  -7.520  1.00  0.82           C  
ATOM    397  CD2 LEU A  27       8.995   9.662  -7.284  1.00  0.77           C  
ATOM    398  H   LEU A  27       9.752   6.267  -7.057  1.00  0.56           H  
ATOM    399  HA  LEU A  27       8.132   7.661  -8.785  1.00  0.73           H  
ATOM    400  HB2 LEU A  27      11.146   7.498  -8.852  1.00  0.74           H  
ATOM    401  HG  LEU A  27      10.424   8.231  -6.645  1.00  0.62           H  
ATOM    402 HD11 LEU A  27      11.383  10.514  -8.363  1.00  1.38           H  
ATOM    403 HD12 LEU A  27      11.505  10.423  -6.606  1.00  1.21           H  
ATOM    404 HD13 LEU A  27      12.395   9.280  -7.613  1.00  1.25           H  
ATOM    405 HD21 LEU A  27       9.056  10.241  -6.375  1.00  1.22           H  
ATOM    406 HD22 LEU A  27       8.835  10.325  -8.124  1.00  1.16           H  
ATOM    407 HD23 LEU A  27       8.173   8.967  -7.215  1.00  1.45           H  
ATOM    408  N   SER A  28       9.784   5.259 -10.264  1.00  0.84           N  
ATOM    409  CA  SER A  28       9.892   4.479 -11.493  1.00  0.98           C  
ATOM    410  C   SER A  28       8.529   3.952 -11.930  1.00  0.89           C  
ATOM    411  O   SER A  28       8.280   3.760 -13.120  1.00  0.99           O  
ATOM    412  CB  SER A  28      10.862   3.312 -11.298  1.00  1.15           C  
ATOM    413  OG  SER A  28      10.420   2.447 -10.265  1.00  1.64           O  
ATOM    414  H   SER A  28      10.246   4.948  -9.458  1.00  0.80           H  
ATOM    415  HA  SER A  28      10.276   5.128 -12.263  1.00  1.11           H  
ATOM    416  HB2 SER A  28      10.933   2.748 -12.215  1.00  1.60           H  
ATOM    417  HG  SER A  28      10.023   1.665 -10.652  1.00  2.09           H  
ATOM    418  N   LEU A  29       7.650   3.719 -10.962  1.00  0.78           N  
ATOM    419  CA  LEU A  29       6.314   3.210 -11.251  1.00  0.78           C  
ATOM    420  C   LEU A  29       5.345   4.352 -11.541  1.00  0.74           C  
ATOM    421  O   LEU A  29       4.335   4.164 -12.217  1.00  0.82           O  
ATOM    422  CB  LEU A  29       5.801   2.375 -10.076  1.00  0.86           C  
ATOM    423  CG  LEU A  29       6.669   1.169  -9.714  1.00  1.06           C  
ATOM    424  CD1 LEU A  29       6.062   0.412  -8.543  1.00  1.64           C  
ATOM    425  CD2 LEU A  29       6.834   0.252 -10.915  1.00  1.42           C  
ATOM    426  H   LEU A  29       7.905   3.892 -10.032  1.00  0.77           H  
ATOM    427  HA  LEU A  29       6.381   2.581 -12.125  1.00  0.85           H  
ATOM    428  HB2 LEU A  29       5.729   3.016  -9.210  1.00  0.86           H  
ATOM    429  HG  LEU A  29       7.648   1.515  -9.416  1.00  1.79           H  
ATOM    430 HD11 LEU A  29       5.065   0.089  -8.802  1.00  2.13           H  
ATOM    431 HD12 LEU A  29       6.673  -0.449  -8.314  1.00  2.08           H  
ATOM    432 HD13 LEU A  29       6.016   1.061  -7.680  1.00  2.13           H  
ATOM    433 HD21 LEU A  29       7.284   0.803 -11.729  1.00  1.99           H  
ATOM    434 HD22 LEU A  29       7.469  -0.580 -10.650  1.00  1.91           H  
ATOM    435 HD23 LEU A  29       5.867  -0.118 -11.223  1.00  1.87           H  
ATOM    436  N   GLY A  30       5.661   5.536 -11.021  1.00  0.68           N  
ATOM    437  CA  GLY A  30       4.810   6.689 -11.238  1.00  0.73           C  
ATOM    438  C   GLY A  30       3.658   6.753 -10.254  1.00  0.71           C  
ATOM    439  O   GLY A  30       2.651   7.416 -10.509  1.00  0.82           O  
ATOM    440  H   GLY A  30       6.474   5.623 -10.484  1.00  0.67           H  
ATOM    441  HA2 GLY A  30       5.404   7.585 -11.136  1.00  0.76           H  
ATOM    442  HA3 GLY A  30       4.409   6.646 -12.239  1.00  0.82           H  
ATOM    443  N   MET A  31       3.804   6.063  -9.129  1.00  0.63           N  
ATOM    444  CA  MET A  31       2.769   6.043  -8.105  1.00  0.66           C  
ATOM    445  C   MET A  31       3.134   6.965  -6.945  1.00  0.56           C  
ATOM    446  O   MET A  31       3.808   6.556  -6.001  1.00  0.54           O  
ATOM    447  CB  MET A  31       2.555   4.616  -7.596  1.00  0.74           C  
ATOM    448  CG  MET A  31       2.067   3.657  -8.670  1.00  0.94           C  
ATOM    449  SD  MET A  31       0.425   4.080  -9.284  1.00  1.95           S  
ATOM    450  CE  MET A  31       0.222   2.857 -10.578  1.00  2.55           C  
ATOM    451  H   MET A  31       4.629   5.553  -8.983  1.00  0.62           H  
ATOM    452  HA  MET A  31       1.852   6.396  -8.554  1.00  0.75           H  
ATOM    453  HB2 MET A  31       3.490   4.242  -7.206  1.00  0.83           H  
ATOM    454  HG2 MET A  31       2.763   3.680  -9.496  1.00  1.20           H  
ATOM    455  HE1 MET A  31       0.848   3.117 -11.421  1.00  2.97           H  
ATOM    456  HE2 MET A  31       0.506   1.885 -10.203  1.00  2.93           H  
ATOM    457  HE3 MET A  31      -0.812   2.833 -10.891  1.00  2.92           H  
ATOM    458  N   LEU A  32       2.690   8.215  -7.032  1.00  0.56           N  
ATOM    459  CA  LEU A  32       2.964   9.202  -5.993  1.00  0.49           C  
ATOM    460  C   LEU A  32       1.891   9.161  -4.908  1.00  0.44           C  
ATOM    461  O   LEU A  32       0.795   8.650  -5.130  1.00  0.45           O  
ATOM    462  CB  LEU A  32       3.037  10.604  -6.602  1.00  0.52           C  
ATOM    463  CG  LEU A  32       4.264  10.870  -7.478  1.00  0.59           C  
ATOM    464  CD1 LEU A  32       4.291   9.919  -8.664  1.00  0.69           C  
ATOM    465  CD2 LEU A  32       4.278  12.317  -7.948  1.00  0.66           C  
ATOM    466  H   LEU A  32       2.164   8.480  -7.815  1.00  0.64           H  
ATOM    467  HA  LEU A  32       3.919   8.961  -5.548  1.00  0.50           H  
ATOM    468  HB2 LEU A  32       2.153  10.758  -7.205  1.00  0.56           H  
ATOM    469  HG  LEU A  32       5.158  10.699  -6.894  1.00  0.56           H  
ATOM    470 HD11 LEU A  32       3.347   9.970  -9.187  1.00  1.11           H  
ATOM    471 HD12 LEU A  32       5.089  10.202  -9.333  1.00  1.34           H  
ATOM    472 HD13 LEU A  32       4.455   8.911  -8.315  1.00  1.07           H  
ATOM    473 HD21 LEU A  32       4.293  12.974  -7.091  1.00  1.09           H  
ATOM    474 HD22 LEU A  32       5.157  12.490  -8.550  1.00  1.20           H  
ATOM    475 HD23 LEU A  32       3.393  12.512  -8.536  1.00  1.23           H  
ATOM    476  N   PRO A  33       2.197   9.702  -3.715  1.00  0.41           N  
ATOM    477  CA  PRO A  33       1.254   9.725  -2.597  1.00  0.40           C  
ATOM    478  C   PRO A  33      -0.160  10.086  -3.037  1.00  0.38           C  
ATOM    479  O   PRO A  33      -0.423  11.210  -3.462  1.00  0.51           O  
ATOM    480  CB  PRO A  33       1.832  10.807  -1.690  1.00  0.43           C  
ATOM    481  CG  PRO A  33       3.302  10.733  -1.920  1.00  0.45           C  
ATOM    482  CD  PRO A  33       3.485  10.332  -3.362  1.00  0.43           C  
ATOM    483  HA  PRO A  33       1.238   8.781  -2.071  1.00  0.41           H  
ATOM    484  HB2 PRO A  33       1.434  11.770  -1.973  1.00  0.44           H  
ATOM    485  HG2 PRO A  33       3.751  11.697  -1.739  1.00  0.48           H  
ATOM    486  HD2 PRO A  33       3.667  11.203  -3.973  1.00  0.44           H  
ATOM    487  N   GLY A  34      -1.067   9.120  -2.932  1.00  0.34           N  
ATOM    488  CA  GLY A  34      -2.445   9.347  -3.327  1.00  0.33           C  
ATOM    489  C   GLY A  34      -2.891   8.414  -4.434  1.00  0.31           C  
ATOM    490  O   GLY A  34      -3.744   8.770  -5.248  1.00  0.40           O  
ATOM    491  H   GLY A  34      -0.799   8.247  -2.582  1.00  0.40           H  
ATOM    492  HA2 GLY A  34      -3.084   9.201  -2.468  1.00  0.35           H  
ATOM    493  HA3 GLY A  34      -2.547  10.368  -3.666  1.00  0.35           H  
ATOM    494  N   SER A  35      -2.319   7.215  -4.464  1.00  0.28           N  
ATOM    495  CA  SER A  35      -2.664   6.228  -5.483  1.00  0.28           C  
ATOM    496  C   SER A  35      -3.603   5.168  -4.918  1.00  0.28           C  
ATOM    497  O   SER A  35      -3.888   5.154  -3.722  1.00  0.37           O  
ATOM    498  CB  SER A  35      -1.399   5.568  -6.034  1.00  0.31           C  
ATOM    499  OG  SER A  35      -1.716   4.612  -7.032  1.00  0.62           O  
ATOM    500  H   SER A  35      -1.652   6.985  -3.781  1.00  0.33           H  
ATOM    501  HA  SER A  35      -3.169   6.746  -6.285  1.00  0.31           H  
ATOM    502  HB2 SER A  35      -0.760   6.323  -6.468  1.00  0.56           H  
ATOM    503  HG  SER A  35      -1.098   3.879  -6.980  1.00  1.01           H  
ATOM    504  N   SER A  36      -4.082   4.284  -5.789  1.00  0.25           N  
ATOM    505  CA  SER A  36      -4.989   3.217  -5.378  1.00  0.25           C  
ATOM    506  C   SER A  36      -4.380   1.846  -5.658  1.00  0.23           C  
ATOM    507  O   SER A  36      -3.764   1.631  -6.702  1.00  0.28           O  
ATOM    508  CB  SER A  36      -6.328   3.351  -6.106  1.00  0.30           C  
ATOM    509  OG  SER A  36      -7.222   2.318  -5.725  1.00  1.30           O  
ATOM    510  H   SER A  36      -3.819   4.352  -6.731  1.00  0.30           H  
ATOM    511  HA  SER A  36      -5.154   3.314  -4.316  1.00  0.27           H  
ATOM    512  HB2 SER A  36      -6.775   4.302  -5.860  1.00  1.06           H  
ATOM    513  HG  SER A  36      -6.975   1.502  -6.168  1.00  1.75           H  
ATOM    514  N   PHE A  37      -4.556   0.921  -4.718  1.00  0.22           N  
ATOM    515  CA  PHE A  37      -4.019  -0.428  -4.867  1.00  0.23           C  
ATOM    516  C   PHE A  37      -4.843  -1.437  -4.072  1.00  0.23           C  
ATOM    517  O   PHE A  37      -5.568  -1.069  -3.147  1.00  0.33           O  
ATOM    518  CB  PHE A  37      -2.558  -0.470  -4.404  1.00  0.25           C  
ATOM    519  CG  PHE A  37      -2.394  -0.380  -2.912  1.00  0.26           C  
ATOM    520  CD1 PHE A  37      -2.522   0.834  -2.259  1.00  0.32           C  
ATOM    521  CD2 PHE A  37      -2.120  -1.514  -2.164  1.00  0.27           C  
ATOM    522  CE1 PHE A  37      -2.376   0.917  -0.886  1.00  0.36           C  
ATOM    523  CE2 PHE A  37      -1.973  -1.437  -0.791  1.00  0.30           C  
ATOM    524  CZ  PHE A  37      -2.101  -0.220  -0.152  1.00  0.33           C  
ATOM    525  H   PHE A  37      -5.056   1.152  -3.908  1.00  0.25           H  
ATOM    526  HA  PHE A  37      -4.064  -0.688  -5.915  1.00  0.25           H  
ATOM    527  HB2 PHE A  37      -2.111  -1.397  -4.732  1.00  0.28           H  
ATOM    528  HD1 PHE A  37      -2.738   1.724  -2.830  1.00  0.37           H  
ATOM    529  HD2 PHE A  37      -2.019  -2.466  -2.662  1.00  0.32           H  
ATOM    530  HE1 PHE A  37      -2.476   1.870  -0.387  1.00  0.44           H  
ATOM    531  HE2 PHE A  37      -1.761  -2.329  -0.220  1.00  0.34           H  
ATOM    532  HZ  PHE A  37      -1.988  -0.158   0.920  1.00  0.37           H  
ATOM    533  N   HIS A  38      -4.728  -2.710  -4.438  1.00  0.21           N  
ATOM    534  CA  HIS A  38      -5.458  -3.771  -3.751  1.00  0.24           C  
ATOM    535  C   HIS A  38      -4.497  -4.712  -3.031  1.00  0.24           C  
ATOM    536  O   HIS A  38      -3.307  -4.757  -3.340  1.00  0.40           O  
ATOM    537  CB  HIS A  38      -6.313  -4.558  -4.745  1.00  0.28           C  
ATOM    538  CG  HIS A  38      -7.341  -3.724  -5.440  1.00  1.17           C  
ATOM    539  ND1 HIS A  38      -7.124  -3.125  -6.663  1.00  2.13           N  
ATOM    540  CD2 HIS A  38      -8.602  -3.388  -5.078  1.00  1.98           C  
ATOM    541  CE1 HIS A  38      -8.206  -2.457  -7.022  1.00  2.94           C  
ATOM    542  NE2 HIS A  38      -9.117  -2.602  -6.078  1.00  2.82           N  
ATOM    543  H   HIS A  38      -4.138  -2.940  -5.187  1.00  0.24           H  
ATOM    544  HA  HIS A  38      -6.104  -3.307  -3.022  1.00  0.27           H  
ATOM    545  HB2 HIS A  38      -5.674  -4.992  -5.497  1.00  0.92           H  
ATOM    546  HD1 HIS A  38      -6.299  -3.180  -7.188  1.00  2.50           H  
ATOM    547  HD2 HIS A  38      -9.110  -3.687  -4.171  1.00  2.38           H  
ATOM    548  HE1 HIS A  38      -8.326  -1.891  -7.934  1.00  3.83           H  
ATOM    549  HE2 HIS A  38      -9.986  -2.151  -6.059  1.00  3.50           H  
ATOM    550  N   VAL A  39      -5.023  -5.461  -2.067  1.00  0.27           N  
ATOM    551  CA  VAL A  39      -4.214  -6.398  -1.298  1.00  0.27           C  
ATOM    552  C   VAL A  39      -4.353  -7.818  -1.835  1.00  0.28           C  
ATOM    553  O   VAL A  39      -5.461  -8.283  -2.106  1.00  0.40           O  
ATOM    554  CB  VAL A  39      -4.611  -6.386   0.192  1.00  0.39           C  
ATOM    555  CG1 VAL A  39      -3.747  -7.352   0.987  1.00  1.28           C  
ATOM    556  CG2 VAL A  39      -4.513  -4.979   0.757  1.00  0.88           C  
ATOM    557  H   VAL A  39      -5.978  -5.380  -1.867  1.00  0.41           H  
ATOM    558  HA  VAL A  39      -3.180  -6.093  -1.374  1.00  0.27           H  
ATOM    559  HB  VAL A  39      -5.639  -6.710   0.270  1.00  1.11           H  
ATOM    560 HG11 VAL A  39      -3.875  -8.353   0.602  1.00  1.84           H  
ATOM    561 HG12 VAL A  39      -2.709  -7.063   0.901  1.00  1.81           H  
ATOM    562 HG13 VAL A  39      -4.042  -7.326   2.027  1.00  1.88           H  
ATOM    563 HG21 VAL A  39      -4.831  -4.982   1.789  1.00  1.59           H  
ATOM    564 HG22 VAL A  39      -3.489  -4.637   0.695  1.00  1.56           H  
ATOM    565 HG23 VAL A  39      -5.148  -4.319   0.187  1.00  1.36           H  
ATOM    566  N   VAL A  40      -3.224  -8.502  -1.985  1.00  0.24           N  
ATOM    567  CA  VAL A  40      -3.224  -9.871  -2.488  1.00  0.34           C  
ATOM    568  C   VAL A  40      -3.219 -10.878  -1.340  1.00  0.37           C  
ATOM    569  O   VAL A  40      -4.021 -11.808  -1.314  1.00  0.54           O  
ATOM    570  CB  VAL A  40      -2.010 -10.134  -3.398  1.00  0.41           C  
ATOM    571  CG1 VAL A  40      -2.029 -11.562  -3.921  1.00  0.54           C  
ATOM    572  CG2 VAL A  40      -1.980  -9.138  -4.547  1.00  0.43           C  
ATOM    573  H   VAL A  40      -2.372  -8.077  -1.759  1.00  0.23           H  
ATOM    574  HA  VAL A  40      -4.123 -10.011  -3.072  1.00  0.41           H  
ATOM    575  HB  VAL A  40      -1.112 -10.002  -2.812  1.00  0.40           H  
ATOM    576 HG11 VAL A  40      -1.201 -11.708  -4.598  1.00  1.22           H  
ATOM    577 HG12 VAL A  40      -1.945 -12.250  -3.094  1.00  1.16           H  
ATOM    578 HG13 VAL A  40      -2.957 -11.742  -4.446  1.00  1.13           H  
ATOM    579 HG21 VAL A  40      -2.845  -9.287  -5.176  1.00  1.07           H  
ATOM    580 HG22 VAL A  40      -1.991  -8.133  -4.152  1.00  1.12           H  
ATOM    581 HG23 VAL A  40      -1.082  -9.286  -5.129  1.00  1.01           H  
ATOM    582  N   ARG A  41      -2.308 -10.680  -0.391  1.00  0.27           N  
ATOM    583  CA  ARG A  41      -2.200 -11.569   0.761  1.00  0.31           C  
ATOM    584  C   ARG A  41      -1.443 -10.892   1.899  1.00  0.31           C  
ATOM    585  O   ARG A  41      -0.438 -10.218   1.674  1.00  0.40           O  
ATOM    586  CB  ARG A  41      -1.491 -12.866   0.364  1.00  0.40           C  
ATOM    587  CG  ARG A  41      -0.050 -12.662  -0.070  1.00  0.47           C  
ATOM    588  CD  ARG A  41       0.652 -13.988  -0.310  1.00  0.57           C  
ATOM    589  NE  ARG A  41      -0.024 -14.790  -1.325  1.00  1.37           N  
ATOM    590  CZ  ARG A  41       0.258 -16.065  -1.567  1.00  1.62           C  
ATOM    591  NH1 ARG A  41       1.199 -16.681  -0.865  1.00  0.94           N  
ATOM    592  NH2 ARG A  41      -0.399 -16.724  -2.510  1.00  2.80           N  
ATOM    593  H   ARG A  41      -1.693  -9.920  -0.469  1.00  0.26           H  
ATOM    594  HA  ARG A  41      -3.199 -11.802   1.094  1.00  0.34           H  
ATOM    595  HB2 ARG A  41      -1.498 -13.538   1.210  1.00  0.44           H  
ATOM    596  HG2 ARG A  41      -0.037 -12.090  -0.986  1.00  0.47           H  
ATOM    597  HD2 ARG A  41       1.663 -13.792  -0.635  1.00  1.21           H  
ATOM    598  HE  ARG A  41      -0.726 -14.353  -1.855  1.00  2.08           H  
ATOM    599 HH11 ARG A  41       1.696 -16.188  -0.152  1.00  0.93           H  
ATOM    600 HH12 ARG A  41       1.410 -17.643  -1.048  1.00  1.14           H  
ATOM    601 HH21 ARG A  41      -1.110 -16.261  -3.041  1.00  3.53           H  
ATOM    602 HH22 ARG A  41      -0.183 -17.684  -2.693  1.00  3.00           H  
ATOM    603  N   VAL A  42      -1.929 -11.076   3.122  1.00  0.33           N  
ATOM    604  CA  VAL A  42      -1.295 -10.475   4.290  1.00  0.39           C  
ATOM    605  C   VAL A  42      -1.417 -11.377   5.516  1.00  0.43           C  
ATOM    606  O   VAL A  42      -2.296 -12.237   5.583  1.00  0.49           O  
ATOM    607  CB  VAL A  42      -1.911  -9.102   4.613  1.00  0.52           C  
ATOM    608  CG1 VAL A  42      -1.104  -8.391   5.688  1.00  0.97           C  
ATOM    609  CG2 VAL A  42      -2.005  -8.252   3.356  1.00  1.20           C  
ATOM    610  H   VAL A  42      -2.732 -11.626   3.243  1.00  0.38           H  
ATOM    611  HA  VAL A  42      -0.247 -10.332   4.065  1.00  0.41           H  
ATOM    612  HB  VAL A  42      -2.911  -9.257   4.990  1.00  1.31           H  
ATOM    613 HG11 VAL A  42      -1.126  -8.971   6.598  1.00  1.59           H  
ATOM    614 HG12 VAL A  42      -0.084  -8.278   5.355  1.00  1.47           H  
ATOM    615 HG13 VAL A  42      -1.532  -7.416   5.873  1.00  1.66           H  
ATOM    616 HG21 VAL A  42      -2.540  -7.340   3.575  1.00  1.73           H  
ATOM    617 HG22 VAL A  42      -1.010  -8.012   3.008  1.00  1.79           H  
ATOM    618 HG23 VAL A  42      -2.529  -8.801   2.587  1.00  1.76           H  
ATOM    619  N   ALA A  43      -0.526 -11.177   6.484  1.00  0.47           N  
ATOM    620  CA  ALA A  43      -0.532 -11.964   7.711  1.00  0.55           C  
ATOM    621  C   ALA A  43      -0.638 -11.064   8.940  1.00  0.69           C  
ATOM    622  O   ALA A  43      -0.131  -9.943   8.941  1.00  0.81           O  
ATOM    623  CB  ALA A  43       0.718 -12.826   7.792  1.00  0.55           C  
ATOM    624  H   ALA A  43       0.152 -10.478   6.368  1.00  0.49           H  
ATOM    625  HA  ALA A  43      -1.392 -12.618   7.682  1.00  0.64           H  
ATOM    626  HB1 ALA A  43       0.794 -13.436   6.906  1.00  1.05           H  
ATOM    627  HB2 ALA A  43       1.589 -12.190   7.866  1.00  1.25           H  
ATOM    628  HB3 ALA A  43       0.662 -13.462   8.664  1.00  1.18           H  
ATOM    629  N   PRO A  44      -1.300 -11.547  10.006  1.00  0.83           N  
ATOM    630  CA  PRO A  44      -1.474 -10.780  11.245  1.00  1.00           C  
ATOM    631  C   PRO A  44      -0.193 -10.697  12.070  1.00  0.98           C  
ATOM    632  O   PRO A  44      -0.045  -9.814  12.913  1.00  1.15           O  
ATOM    633  CB  PRO A  44      -2.541 -11.576  11.998  1.00  1.14           C  
ATOM    634  CG  PRO A  44      -2.368 -12.977  11.522  1.00  1.34           C  
ATOM    635  CD  PRO A  44      -1.939 -12.876  10.084  1.00  1.00           C  
ATOM    636  HA  PRO A  44      -1.838  -9.784  11.046  1.00  1.10           H  
ATOM    637  HB2 PRO A  44      -2.372 -11.494  13.061  1.00  1.18           H  
ATOM    638  HG2 PRO A  44      -1.606 -13.472  12.106  1.00  1.63           H  
ATOM    639  HD2 PRO A  44      -1.234 -13.658   9.844  1.00  1.00           H  
ATOM    640  N   LEU A  45       0.730 -11.619  11.822  1.00  0.85           N  
ATOM    641  CA  LEU A  45       1.995 -11.648  12.548  1.00  0.90           C  
ATOM    642  C   LEU A  45       3.074 -10.867  11.802  1.00  0.91           C  
ATOM    643  O   LEU A  45       3.799 -10.070  12.397  1.00  1.23           O  
ATOM    644  CB  LEU A  45       2.450 -13.092  12.763  1.00  0.90           C  
ATOM    645  CG  LEU A  45       3.767 -13.252  13.526  1.00  1.76           C  
ATOM    646  CD1 LEU A  45       3.631 -12.721  14.944  1.00  2.51           C  
ATOM    647  CD2 LEU A  45       4.195 -14.713  13.540  1.00  2.25           C  
ATOM    648  H   LEU A  45       0.558 -12.297  11.134  1.00  0.79           H  
ATOM    649  HA  LEU A  45       1.834 -11.185  13.509  1.00  1.00           H  
ATOM    650  HB2 LEU A  45       1.676 -13.614  13.307  1.00  1.22           H  
ATOM    651  HG  LEU A  45       4.535 -12.680  13.028  1.00  2.42           H  
ATOM    652 HD11 LEU A  45       4.573 -12.829  15.461  1.00  2.79           H  
ATOM    653 HD12 LEU A  45       3.354 -11.678  14.914  1.00  3.06           H  
ATOM    654 HD13 LEU A  45       2.869 -13.279  15.468  1.00  2.90           H  
ATOM    655 HD21 LEU A  45       3.434 -15.308  14.019  1.00  2.49           H  
ATOM    656 HD22 LEU A  45       4.336 -15.055  12.525  1.00  2.73           H  
ATOM    657 HD23 LEU A  45       5.124 -14.809  14.085  1.00  2.66           H  
ATOM    658  N   GLY A  46       3.176 -11.105  10.499  1.00  0.72           N  
ATOM    659  CA  GLY A  46       4.170 -10.417   9.695  1.00  0.72           C  
ATOM    660  C   GLY A  46       4.614 -11.240   8.501  1.00  0.66           C  
ATOM    661  O   GLY A  46       5.439 -12.141   8.634  1.00  0.77           O  
ATOM    662  H   GLY A  46       2.572 -11.754  10.080  1.00  0.74           H  
ATOM    663  HA2 GLY A  46       3.750  -9.488   9.344  1.00  0.73           H  
ATOM    664  HA3 GLY A  46       5.030 -10.203  10.312  1.00  0.79           H  
ATOM    665  N   ASP A  47       4.065 -10.926   7.333  1.00  0.53           N  
ATOM    666  CA  ASP A  47       4.403 -11.645   6.111  1.00  0.49           C  
ATOM    667  C   ASP A  47       4.540 -10.687   4.932  1.00  0.46           C  
ATOM    668  O   ASP A  47       4.212  -9.506   5.041  1.00  0.46           O  
ATOM    669  CB  ASP A  47       3.338 -12.703   5.813  1.00  0.45           C  
ATOM    670  CG  ASP A  47       3.433 -13.896   6.746  1.00  0.78           C  
ATOM    671  OD1 ASP A  47       3.235 -13.713   7.966  1.00  0.94           O  
ATOM    672  OD2 ASP A  47       3.712 -15.010   6.257  1.00  1.07           O  
ATOM    673  H   ASP A  47       3.417 -10.192   7.290  1.00  0.49           H  
ATOM    674  HA  ASP A  47       5.351 -12.134   6.267  1.00  0.56           H  
ATOM    675  HB2 ASP A  47       2.360 -12.261   5.928  1.00  0.57           H  
ATOM    676  N   PRO A  48       5.029 -11.185   3.784  1.00  0.47           N  
ATOM    677  CA  PRO A  48       5.209 -10.380   2.583  1.00  0.47           C  
ATOM    678  C   PRO A  48       3.926 -10.295   1.766  1.00  0.37           C  
ATOM    679  O   PRO A  48       3.421 -11.303   1.273  1.00  0.38           O  
ATOM    680  CB  PRO A  48       6.292 -11.134   1.794  1.00  0.56           C  
ATOM    681  CG  PRO A  48       6.586 -12.386   2.568  1.00  0.61           C  
ATOM    682  CD  PRO A  48       5.474 -12.561   3.563  1.00  0.53           C  
ATOM    683  HA  PRO A  48       5.554  -9.385   2.820  1.00  0.50           H  
ATOM    684  HB2 PRO A  48       5.921 -11.363   0.806  1.00  0.55           H  
ATOM    685  HG2 PRO A  48       6.619 -13.230   1.895  1.00  0.65           H  
ATOM    686  HD2 PRO A  48       4.680 -13.163   3.143  1.00  0.51           H  
ATOM    687  N   VAL A  49       3.407  -9.082   1.628  1.00  0.32           N  
ATOM    688  CA  VAL A  49       2.179  -8.854   0.884  1.00  0.26           C  
ATOM    689  C   VAL A  49       2.472  -8.192  -0.459  1.00  0.28           C  
ATOM    690  O   VAL A  49       3.506  -7.548  -0.636  1.00  0.39           O  
ATOM    691  CB  VAL A  49       1.194  -7.986   1.702  1.00  0.27           C  
ATOM    692  CG1 VAL A  49       1.917  -6.794   2.310  1.00  0.35           C  
ATOM    693  CG2 VAL A  49       0.013  -7.526   0.853  1.00  0.31           C  
ATOM    694  H   VAL A  49       3.866  -8.319   2.037  1.00  0.37           H  
ATOM    695  HA  VAL A  49       1.714  -9.814   0.706  1.00  0.27           H  
ATOM    696  HB  VAL A  49       0.810  -8.588   2.513  1.00  0.28           H  
ATOM    697 HG11 VAL A  49       2.667  -7.145   3.007  1.00  1.15           H  
ATOM    698 HG12 VAL A  49       2.393  -6.222   1.527  1.00  1.00           H  
ATOM    699 HG13 VAL A  49       1.209  -6.168   2.830  1.00  1.09           H  
ATOM    700 HG21 VAL A  49       0.376  -6.952   0.013  1.00  1.10           H  
ATOM    701 HG22 VAL A  49      -0.530  -8.386   0.493  1.00  1.01           H  
ATOM    702 HG23 VAL A  49      -0.643  -6.910   1.451  1.00  1.09           H  
ATOM    703  N   HIS A  50       1.548  -8.356  -1.398  1.00  0.29           N  
ATOM    704  CA  HIS A  50       1.698  -7.780  -2.726  1.00  0.31           C  
ATOM    705  C   HIS A  50       0.542  -6.838  -3.039  1.00  0.29           C  
ATOM    706  O   HIS A  50      -0.617  -7.148  -2.761  1.00  0.31           O  
ATOM    707  CB  HIS A  50       1.771  -8.888  -3.778  1.00  0.34           C  
ATOM    708  CG  HIS A  50       2.831  -9.908  -3.501  1.00  0.37           C  
ATOM    709  ND1 HIS A  50       4.006  -9.990  -4.217  1.00  1.13           N  
ATOM    710  CD2 HIS A  50       2.887 -10.899  -2.577  1.00  1.08           C  
ATOM    711  CE1 HIS A  50       4.739 -10.984  -3.749  1.00  0.85           C  
ATOM    712  NE2 HIS A  50       4.083 -11.551  -2.754  1.00  0.68           N  
ATOM    713  H   HIS A  50       0.746  -8.880  -1.192  1.00  0.37           H  
ATOM    714  HA  HIS A  50       2.620  -7.219  -2.743  1.00  0.34           H  
ATOM    715  HB2 HIS A  50       0.821  -9.400  -3.820  1.00  0.34           H  
ATOM    716  HD1 HIS A  50       4.266  -9.404  -4.960  1.00  1.97           H  
ATOM    717  HD2 HIS A  50       2.133 -11.131  -1.840  1.00  2.03           H  
ATOM    718  HE1 HIS A  50       5.709 -11.284  -4.118  1.00  1.44           H  
ATOM    719  HE2 HIS A  50       4.361 -12.365  -2.284  1.00  1.13           H  
ATOM    720  N   ILE A  51       0.865  -5.686  -3.616  1.00  0.32           N  
ATOM    721  CA  ILE A  51      -0.145  -4.697  -3.963  1.00  0.32           C  
ATOM    722  C   ILE A  51      -0.458  -4.731  -5.454  1.00  0.32           C  
ATOM    723  O   ILE A  51       0.426  -4.956  -6.280  1.00  0.31           O  
ATOM    724  CB  ILE A  51       0.300  -3.272  -3.578  1.00  0.34           C  
ATOM    725  CG1 ILE A  51       1.579  -2.889  -4.324  1.00  0.34           C  
ATOM    726  CG2 ILE A  51       0.512  -3.172  -2.076  1.00  0.36           C  
ATOM    727  CD1 ILE A  51       2.060  -1.490  -4.009  1.00  0.36           C  
ATOM    728  H   ILE A  51       1.809  -5.496  -3.810  1.00  0.36           H  
ATOM    729  HA  ILE A  51      -1.045  -4.930  -3.413  1.00  0.34           H  
ATOM    730  HB  ILE A  51      -0.487  -2.587  -3.853  1.00  0.35           H  
ATOM    731 HG12 ILE A  51       2.365  -3.579  -4.057  1.00  0.36           H  
ATOM    732 HG21 ILE A  51       1.266  -3.883  -1.770  1.00  1.07           H  
ATOM    733 HG22 ILE A  51       0.836  -2.173  -1.825  1.00  1.00           H  
ATOM    734 HG23 ILE A  51      -0.414  -3.390  -1.566  1.00  1.12           H  
ATOM    735 HD11 ILE A  51       2.955  -1.280  -4.575  1.00  1.09           H  
ATOM    736 HD12 ILE A  51       1.293  -0.776  -4.271  1.00  1.00           H  
ATOM    737 HD13 ILE A  51       2.277  -1.413  -2.953  1.00  1.07           H  
ATOM    738  N   GLU A  52      -1.723  -4.510  -5.792  1.00  0.36           N  
ATOM    739  CA  GLU A  52      -2.154  -4.510  -7.184  1.00  0.39           C  
ATOM    740  C   GLU A  52      -2.443  -3.092  -7.660  1.00  0.42           C  
ATOM    741  O   GLU A  52      -3.412  -2.466  -7.225  1.00  0.43           O  
ATOM    742  CB  GLU A  52      -3.396  -5.386  -7.358  1.00  0.45           C  
ATOM    743  CG  GLU A  52      -3.174  -6.838  -6.965  1.00  1.01           C  
ATOM    744  CD  GLU A  52      -2.176  -7.539  -7.865  1.00  1.46           C  
ATOM    745  OE1 GLU A  52      -0.958  -7.354  -7.659  1.00  2.13           O  
ATOM    746  OE2 GLU A  52      -2.610  -8.278  -8.773  1.00  1.91           O  
ATOM    747  H   GLU A  52      -2.384  -4.342  -5.087  1.00  0.40           H  
ATOM    748  HA  GLU A  52      -1.350  -4.919  -7.778  1.00  0.36           H  
ATOM    749  HB2 GLU A  52      -4.191  -4.987  -6.746  1.00  0.94           H  
ATOM    750  HG2 GLU A  52      -2.809  -6.874  -5.950  1.00  1.62           H  
ATOM    751  N   THR A  53      -1.595  -2.590  -8.549  1.00  0.52           N  
ATOM    752  CA  THR A  53      -1.751  -1.246  -9.085  1.00  0.58           C  
ATOM    753  C   THR A  53      -2.116  -1.285 -10.566  1.00  0.61           C  
ATOM    754  O   THR A  53      -2.341  -2.357 -11.130  1.00  0.60           O  
ATOM    755  CB  THR A  53      -0.465  -0.419  -8.899  1.00  0.59           C  
ATOM    756  OG1 THR A  53       0.622  -1.041  -9.593  1.00  0.55           O  
ATOM    757  CG2 THR A  53      -0.119  -0.290  -7.422  1.00  0.64           C  
ATOM    758  H   THR A  53      -0.842  -3.140  -8.852  1.00  0.58           H  
ATOM    759  HA  THR A  53      -2.549  -0.760  -8.540  1.00  0.65           H  
ATOM    760  HB  THR A  53      -0.626   0.569  -9.303  1.00  0.66           H  
ATOM    761  HG1 THR A  53       1.442  -0.594  -9.372  1.00  1.07           H  
ATOM    762 HG21 THR A  53       0.778   0.300  -7.312  1.00  1.28           H  
ATOM    763 HG22 THR A  53       0.043  -1.272  -7.003  1.00  1.25           H  
ATOM    764 HG23 THR A  53      -0.933   0.192  -6.902  1.00  1.07           H  
ATOM    765  N   ARG A  54      -2.170  -0.117 -11.194  1.00  0.68           N  
ATOM    766  CA  ARG A  54      -2.514  -0.021 -12.609  1.00  0.73           C  
ATOM    767  C   ARG A  54      -1.643  -0.940 -13.459  1.00  0.67           C  
ATOM    768  O   ARG A  54      -0.539  -0.572 -13.857  1.00  0.69           O  
ATOM    769  CB  ARG A  54      -2.372   1.423 -13.094  1.00  0.84           C  
ATOM    770  CG  ARG A  54      -3.299   2.396 -12.385  1.00  1.47           C  
ATOM    771  CD  ARG A  54      -4.757   2.010 -12.572  1.00  1.53           C  
ATOM    772  NE  ARG A  54      -5.664   2.992 -11.985  1.00  2.10           N  
ATOM    773  CZ  ARG A  54      -6.988   2.891 -12.035  1.00  2.32           C  
ATOM    774  NH1 ARG A  54      -7.554   1.855 -12.638  1.00  1.97           N  
ATOM    775  NH2 ARG A  54      -7.748   3.827 -11.480  1.00  3.04           N  
ATOM    776  H   ARG A  54      -1.977   0.704 -10.694  1.00  0.72           H  
ATOM    777  HA  ARG A  54      -3.544  -0.327 -12.718  1.00  0.79           H  
ATOM    778  HB2 ARG A  54      -1.354   1.744 -12.933  1.00  1.09           H  
ATOM    779  HG2 ARG A  54      -3.069   2.394 -11.330  1.00  1.91           H  
ATOM    780  HD2 ARG A  54      -4.962   1.931 -13.629  1.00  1.59           H  
ATOM    781  HE  ARG A  54      -5.265   3.765 -11.534  1.00  2.46           H  
ATOM    782 HH11 ARG A  54      -6.984   1.149 -13.057  1.00  1.66           H  
ATOM    783 HH12 ARG A  54      -8.550   1.779 -12.672  1.00  2.17           H  
ATOM    784 HH21 ARG A  54      -7.326   4.609 -11.023  1.00  3.43           H  
ATOM    785 HH22 ARG A  54      -8.745   3.748 -11.520  1.00  3.23           H  
ATOM    786  N   ARG A  55      -2.147  -2.141 -13.728  1.00  0.66           N  
ATOM    787  CA  ARG A  55      -1.428  -3.115 -14.540  1.00  0.66           C  
ATOM    788  C   ARG A  55      -0.016  -3.359 -14.010  1.00  0.62           C  
ATOM    789  O   ARG A  55       0.924  -3.528 -14.786  1.00  0.70           O  
ATOM    790  CB  ARG A  55      -1.357  -2.643 -15.992  1.00  0.73           C  
ATOM    791  CG  ARG A  55      -2.716  -2.467 -16.647  1.00  1.06           C  
ATOM    792  CD  ARG A  55      -2.583  -1.983 -18.082  1.00  1.67           C  
ATOM    793  NE  ARG A  55      -1.837  -2.927 -18.910  1.00  2.43           N  
ATOM    794  CZ  ARG A  55      -1.358  -2.629 -20.114  1.00  3.17           C  
ATOM    795  NH1 ARG A  55      -1.555  -1.424 -20.630  1.00  3.34           N  
ATOM    796  NH2 ARG A  55      -0.682  -3.538 -20.803  1.00  4.11           N  
ATOM    797  H   ARG A  55      -3.025  -2.381 -13.368  1.00  0.70           H  
ATOM    798  HA  ARG A  55      -1.979  -4.041 -14.500  1.00  0.69           H  
ATOM    799  HB2 ARG A  55      -0.842  -1.693 -16.023  1.00  0.99           H  
ATOM    800  HG2 ARG A  55      -3.233  -3.416 -16.643  1.00  1.30           H  
ATOM    801  HD2 ARG A  55      -3.571  -1.853 -18.498  1.00  2.09           H  
ATOM    802  HE  ARG A  55      -1.684  -3.825 -18.550  1.00  2.75           H  
ATOM    803 HH11 ARG A  55      -2.065  -0.736 -20.115  1.00  3.11           H  
ATOM    804 HH12 ARG A  55      -1.194  -1.203 -21.536  1.00  3.99           H  
ATOM    805 HH21 ARG A  55      -0.532  -4.449 -20.419  1.00  4.44           H  
ATOM    806 HH22 ARG A  55      -0.321  -3.314 -21.709  1.00  4.67           H  
ATOM    807  N   VAL A  56       0.127  -3.384 -12.690  1.00  0.58           N  
ATOM    808  CA  VAL A  56       1.429  -3.611 -12.072  1.00  0.57           C  
ATOM    809  C   VAL A  56       1.277  -4.184 -10.667  1.00  0.49           C  
ATOM    810  O   VAL A  56       0.493  -3.678  -9.863  1.00  0.50           O  
ATOM    811  CB  VAL A  56       2.258  -2.314 -12.000  1.00  0.66           C  
ATOM    812  CG1 VAL A  56       3.611  -2.576 -11.359  1.00  1.02           C  
ATOM    813  CG2 VAL A  56       2.428  -1.713 -13.388  1.00  1.23           C  
ATOM    814  H   VAL A  56      -0.658  -3.250 -12.118  1.00  0.60           H  
ATOM    815  HA  VAL A  56       1.965  -4.324 -12.682  1.00  0.64           H  
ATOM    816  HB  VAL A  56       1.726  -1.604 -11.387  1.00  1.22           H  
ATOM    817 HG11 VAL A  56       4.144  -3.322 -11.933  1.00  1.71           H  
ATOM    818 HG12 VAL A  56       4.185  -1.661 -11.340  1.00  1.42           H  
ATOM    819 HG13 VAL A  56       3.468  -2.933 -10.350  1.00  1.57           H  
ATOM    820 HG21 VAL A  56       3.050  -0.833 -13.325  1.00  1.63           H  
ATOM    821 HG22 VAL A  56       2.893  -2.437 -14.040  1.00  1.71           H  
ATOM    822 HG23 VAL A  56       1.461  -1.439 -13.782  1.00  1.87           H  
ATOM    823  N   SER A  57       2.029  -5.242 -10.379  1.00  0.48           N  
ATOM    824  CA  SER A  57       1.972  -5.886  -9.072  1.00  0.43           C  
ATOM    825  C   SER A  57       3.275  -5.689  -8.304  1.00  0.42           C  
ATOM    826  O   SER A  57       4.298  -6.288  -8.636  1.00  0.46           O  
ATOM    827  CB  SER A  57       1.685  -7.379  -9.232  1.00  0.51           C  
ATOM    828  OG  SER A  57       1.614  -8.026  -7.973  1.00  0.64           O  
ATOM    829  H   SER A  57       2.636  -5.599 -11.061  1.00  0.55           H  
ATOM    830  HA  SER A  57       1.167  -5.434  -8.513  1.00  0.42           H  
ATOM    831  HB2 SER A  57       0.743  -7.512  -9.742  1.00  0.73           H  
ATOM    832  HG  SER A  57       2.250  -8.747  -7.945  1.00  1.07           H  
ATOM    833  N   LEU A  58       3.228  -4.849  -7.277  1.00  0.38           N  
ATOM    834  CA  LEU A  58       4.402  -4.582  -6.453  1.00  0.40           C  
ATOM    835  C   LEU A  58       4.325  -5.359  -5.144  1.00  0.37           C  
ATOM    836  O   LEU A  58       3.238  -5.695  -4.675  1.00  0.38           O  
ATOM    837  CB  LEU A  58       4.523  -3.084  -6.162  1.00  0.43           C  
ATOM    838  CG  LEU A  58       5.769  -2.678  -5.372  1.00  0.96           C  
ATOM    839  CD1 LEU A  58       7.029  -3.063  -6.129  1.00  1.50           C  
ATOM    840  CD2 LEU A  58       5.755  -1.183  -5.085  1.00  1.54           C  
ATOM    841  H   LEU A  58       2.384  -4.396  -7.067  1.00  0.38           H  
ATOM    842  HA  LEU A  58       5.273  -4.906  -7.003  1.00  0.42           H  
ATOM    843  HB2 LEU A  58       4.529  -2.554  -7.105  1.00  1.02           H  
ATOM    844  HG  LEU A  58       5.774  -3.200  -4.427  1.00  1.80           H  
ATOM    845 HD11 LEU A  58       7.897  -2.790  -5.547  1.00  1.96           H  
ATOM    846 HD12 LEU A  58       7.032  -4.128  -6.304  1.00  2.01           H  
ATOM    847 HD13 LEU A  58       7.053  -2.545  -7.076  1.00  2.03           H  
ATOM    848 HD21 LEU A  58       4.872  -0.934  -4.516  1.00  2.10           H  
ATOM    849 HD22 LEU A  58       6.636  -0.917  -4.522  1.00  2.10           H  
ATOM    850 HD23 LEU A  58       5.747  -0.637  -6.018  1.00  1.89           H  
ATOM    851  N   VAL A  59       5.482  -5.646  -4.560  1.00  0.41           N  
ATOM    852  CA  VAL A  59       5.536  -6.385  -3.305  1.00  0.40           C  
ATOM    853  C   VAL A  59       5.925  -5.474  -2.144  1.00  0.40           C  
ATOM    854  O   VAL A  59       6.801  -4.620  -2.277  1.00  0.47           O  
ATOM    855  CB  VAL A  59       6.535  -7.554  -3.384  1.00  0.45           C  
ATOM    856  CG1 VAL A  59       7.949  -7.035  -3.600  1.00  0.50           C  
ATOM    857  CG2 VAL A  59       6.456  -8.408  -2.127  1.00  0.45           C  
ATOM    858  H   VAL A  59       6.318  -5.357  -4.981  1.00  0.48           H  
ATOM    859  HA  VAL A  59       4.553  -6.793  -3.117  1.00  0.40           H  
ATOM    860  HB  VAL A  59       6.270  -8.171  -4.230  1.00  0.47           H  
ATOM    861 HG11 VAL A  59       8.222  -6.386  -2.782  1.00  1.11           H  
ATOM    862 HG12 VAL A  59       8.635  -7.869  -3.644  1.00  1.07           H  
ATOM    863 HG13 VAL A  59       7.992  -6.483  -4.527  1.00  1.10           H  
ATOM    864 HG21 VAL A  59       6.678  -7.798  -1.265  1.00  1.09           H  
ATOM    865 HG22 VAL A  59       5.461  -8.816  -2.034  1.00  1.09           H  
ATOM    866 HG23 VAL A  59       7.173  -9.213  -2.193  1.00  1.06           H  
ATOM    867  N   LEU A  60       5.266  -5.665  -1.005  1.00  0.39           N  
ATOM    868  CA  LEU A  60       5.540  -4.863   0.183  1.00  0.40           C  
ATOM    869  C   LEU A  60       5.770  -5.758   1.398  1.00  0.38           C  
ATOM    870  O   LEU A  60       5.466  -6.951   1.372  1.00  0.48           O  
ATOM    871  CB  LEU A  60       4.385  -3.898   0.454  1.00  0.45           C  
ATOM    872  CG  LEU A  60       4.127  -2.873  -0.653  1.00  0.61           C  
ATOM    873  CD1 LEU A  60       2.987  -1.944  -0.266  1.00  0.77           C  
ATOM    874  CD2 LEU A  60       5.390  -2.076  -0.945  1.00  0.97           C  
ATOM    875  H   LEU A  60       4.577  -6.359  -0.962  1.00  0.41           H  
ATOM    876  HA  LEU A  60       6.438  -4.294  -0.002  1.00  0.47           H  
ATOM    877  HB2 LEU A  60       3.484  -4.476   0.599  1.00  0.60           H  
ATOM    878  HG  LEU A  60       3.842  -3.392  -1.556  1.00  0.89           H  
ATOM    879 HD11 LEU A  60       3.237  -1.428   0.649  1.00  1.22           H  
ATOM    880 HD12 LEU A  60       2.827  -1.223  -1.054  1.00  1.35           H  
ATOM    881 HD13 LEU A  60       2.085  -2.522  -0.119  1.00  1.37           H  
ATOM    882 HD21 LEU A  60       6.170  -2.747  -1.274  1.00  1.42           H  
ATOM    883 HD22 LEU A  60       5.188  -1.352  -1.719  1.00  1.56           H  
ATOM    884 HD23 LEU A  60       5.708  -1.567  -0.048  1.00  1.46           H  
ATOM    885  N   ARG A  61       6.304  -5.172   2.466  1.00  0.51           N  
ATOM    886  CA  ARG A  61       6.583  -5.917   3.688  1.00  0.58           C  
ATOM    887  C   ARG A  61       5.898  -5.267   4.887  1.00  0.54           C  
ATOM    888  O   ARG A  61       5.925  -4.047   5.042  1.00  0.59           O  
ATOM    889  CB  ARG A  61       8.091  -5.993   3.923  1.00  0.69           C  
ATOM    890  CG  ARG A  61       8.844  -6.701   2.808  1.00  1.34           C  
ATOM    891  CD  ARG A  61      10.343  -6.692   3.051  1.00  1.51           C  
ATOM    892  NE  ARG A  61      11.070  -7.440   2.029  1.00  2.06           N  
ATOM    893  CZ  ARG A  61      12.335  -7.824   2.158  1.00  2.47           C  
ATOM    894  NH1 ARG A  61      13.008  -7.536   3.265  1.00  2.45           N  
ATOM    895  NH2 ARG A  61      12.930  -8.501   1.185  1.00  3.32           N  
ATOM    896  H   ARG A  61       6.509  -4.217   2.433  1.00  0.67           H  
ATOM    897  HA  ARG A  61       6.194  -6.916   3.564  1.00  0.67           H  
ATOM    898  HB2 ARG A  61       8.482  -4.989   4.011  1.00  0.91           H  
ATOM    899  HG2 ARG A  61       8.505  -7.726   2.752  1.00  1.91           H  
ATOM    900  HD2 ARG A  61      10.690  -5.669   3.048  1.00  1.87           H  
ATOM    901  HE  ARG A  61      10.591  -7.663   1.203  1.00  2.52           H  
ATOM    902 HH11 ARG A  61      12.564  -7.029   4.002  1.00  2.39           H  
ATOM    903 HH12 ARG A  61      13.960  -7.827   3.361  1.00  2.86           H  
ATOM    904 HH21 ARG A  61      12.426  -8.721   0.350  1.00  3.81           H  
ATOM    905 HH22 ARG A  61      13.881  -8.791   1.285  1.00  3.64           H  
ATOM    906  N   LYS A  62       5.292  -6.093   5.736  1.00  0.69           N  
ATOM    907  CA  LYS A  62       4.595  -5.602   6.922  1.00  0.74           C  
ATOM    908  C   LYS A  62       5.434  -4.567   7.667  1.00  0.68           C  
ATOM    909  O   LYS A  62       4.897  -3.672   8.320  1.00  0.76           O  
ATOM    910  CB  LYS A  62       4.253  -6.765   7.857  1.00  0.92           C  
ATOM    911  CG  LYS A  62       3.491  -6.345   9.104  1.00  1.88           C  
ATOM    912  CD  LYS A  62       1.986  -6.367   8.881  1.00  2.95           C  
ATOM    913  CE  LYS A  62       1.570  -5.449   7.743  1.00  3.60           C  
ATOM    914  NZ  LYS A  62       0.094  -5.269   7.685  1.00  4.70           N  
ATOM    915  H   LYS A  62       5.310  -7.056   5.559  1.00  0.86           H  
ATOM    916  HA  LYS A  62       3.682  -5.134   6.595  1.00  0.78           H  
ATOM    917  HB2 LYS A  62       3.650  -7.480   7.316  1.00  1.41           H  
ATOM    918  HG2 LYS A  62       3.735  -7.023   9.907  1.00  2.24           H  
ATOM    919  HD2 LYS A  62       1.682  -7.375   8.645  1.00  3.28           H  
ATOM    920  HE2 LYS A  62       2.036  -4.485   7.885  1.00  3.61           H  
ATOM    921  HZ1 LYS A  62      -0.159  -4.628   6.906  1.00  5.05           H  
ATOM    922  HZ2 LYS A  62      -0.253  -4.864   8.579  1.00  5.09           H  
ATOM    923  HZ3 LYS A  62      -0.372  -6.186   7.531  1.00  5.08           H  
ATOM    924  N   LYS A  63       6.755  -4.693   7.566  1.00  0.64           N  
ATOM    925  CA  LYS A  63       7.661  -3.763   8.226  1.00  0.71           C  
ATOM    926  C   LYS A  63       7.873  -2.526   7.362  1.00  0.63           C  
ATOM    927  O   LYS A  63       8.080  -1.424   7.873  1.00  0.73           O  
ATOM    928  CB  LYS A  63       9.003  -4.435   8.523  1.00  0.88           C  
ATOM    929  CG  LYS A  63       9.645  -5.081   7.308  1.00  0.88           C  
ATOM    930  CD  LYS A  63      11.025  -5.632   7.637  1.00  1.10           C  
ATOM    931  CE  LYS A  63      11.587  -6.448   6.486  1.00  1.67           C  
ATOM    932  NZ  LYS A  63      10.777  -7.668   6.224  1.00  2.28           N  
ATOM    933  H   LYS A  63       7.125  -5.427   7.036  1.00  0.65           H  
ATOM    934  HA  LYS A  63       7.204  -3.460   9.157  1.00  0.78           H  
ATOM    935  HB2 LYS A  63       9.685  -3.693   8.912  1.00  0.98           H  
ATOM    936  HG2 LYS A  63       9.017  -5.890   6.968  1.00  0.84           H  
ATOM    937  HD2 LYS A  63      11.690  -4.807   7.840  1.00  1.57           H  
ATOM    938  HE2 LYS A  63      11.598  -5.835   5.598  1.00  2.11           H  
ATOM    939  HZ1 LYS A  63      10.721  -8.251   7.082  1.00  2.66           H  
ATOM    940  HZ2 LYS A  63      11.211  -8.229   5.464  1.00  2.72           H  
ATOM    941  HZ3 LYS A  63       9.813  -7.401   5.934  1.00  2.64           H  
ATOM    942  N   ASP A  64       7.819  -2.717   6.048  1.00  0.54           N  
ATOM    943  CA  ASP A  64       7.996  -1.619   5.106  1.00  0.54           C  
ATOM    944  C   ASP A  64       6.805  -0.666   5.161  1.00  0.46           C  
ATOM    945  O   ASP A  64       6.961   0.547   5.026  1.00  0.56           O  
ATOM    946  CB  ASP A  64       8.166  -2.161   3.686  1.00  0.56           C  
ATOM    947  CG  ASP A  64       8.367  -1.060   2.663  1.00  1.38           C  
ATOM    948  OD1 ASP A  64       9.530  -0.664   2.437  1.00  1.49           O  
ATOM    949  OD2 ASP A  64       7.361  -0.594   2.086  1.00  2.30           O  
ATOM    950  H   ASP A  64       7.658  -3.619   5.703  1.00  0.56           H  
ATOM    951  HA  ASP A  64       8.889  -1.079   5.386  1.00  0.64           H  
ATOM    952  HB2 ASP A  64       9.026  -2.814   3.657  1.00  1.10           H  
ATOM    953  N   LEU A  65       5.616  -1.226   5.365  1.00  0.39           N  
ATOM    954  CA  LEU A  65       4.397  -0.427   5.441  1.00  0.41           C  
ATOM    955  C   LEU A  65       4.445   0.533   6.628  1.00  0.45           C  
ATOM    956  O   LEU A  65       3.762   1.558   6.636  1.00  0.52           O  
ATOM    957  CB  LEU A  65       3.167  -1.332   5.554  1.00  0.51           C  
ATOM    958  CG  LEU A  65       2.735  -2.012   4.254  1.00  0.49           C  
ATOM    959  CD1 LEU A  65       3.744  -3.071   3.840  1.00  0.67           C  
ATOM    960  CD2 LEU A  65       1.350  -2.623   4.407  1.00  0.70           C  
ATOM    961  H   LEU A  65       5.556  -2.200   5.466  1.00  0.40           H  
ATOM    962  HA  LEU A  65       4.324   0.151   4.533  1.00  0.41           H  
ATOM    963  HB2 LEU A  65       3.378  -2.100   6.285  1.00  0.54           H  
ATOM    964  HG  LEU A  65       2.688  -1.272   3.468  1.00  0.71           H  
ATOM    965 HD11 LEU A  65       3.802  -3.828   4.606  1.00  1.13           H  
ATOM    966 HD12 LEU A  65       3.429  -3.523   2.911  1.00  1.41           H  
ATOM    967 HD13 LEU A  65       4.713  -2.613   3.707  1.00  1.19           H  
ATOM    968 HD21 LEU A  65       1.060  -3.095   3.480  1.00  1.32           H  
ATOM    969 HD22 LEU A  65       1.367  -3.362   5.194  1.00  1.30           H  
ATOM    970 HD23 LEU A  65       0.640  -1.849   4.654  1.00  1.04           H  
ATOM    971  N   ALA A  66       5.252   0.195   7.628  1.00  0.46           N  
ATOM    972  CA  ALA A  66       5.385   1.025   8.820  1.00  0.52           C  
ATOM    973  C   ALA A  66       5.784   2.453   8.460  1.00  0.50           C  
ATOM    974  O   ALA A  66       5.384   3.406   9.128  1.00  0.66           O  
ATOM    975  CB  ALA A  66       6.403   0.417   9.774  1.00  0.60           C  
ATOM    976  H   ALA A  66       5.769  -0.636   7.566  1.00  0.46           H  
ATOM    977  HA  ALA A  66       4.428   1.046   9.319  1.00  0.56           H  
ATOM    978  HB1 ALA A  66       7.379   0.423   9.312  1.00  1.20           H  
ATOM    979  HB2 ALA A  66       6.434   0.998  10.686  1.00  1.18           H  
ATOM    980  HB3 ALA A  66       6.118  -0.599  10.006  1.00  1.16           H  
ATOM    981  N   LEU A  67       6.573   2.598   7.398  1.00  0.37           N  
ATOM    982  CA  LEU A  67       7.026   3.912   6.955  1.00  0.35           C  
ATOM    983  C   LEU A  67       5.978   4.591   6.080  1.00  0.31           C  
ATOM    984  O   LEU A  67       5.471   5.660   6.419  1.00  0.30           O  
ATOM    985  CB  LEU A  67       8.344   3.792   6.187  1.00  0.38           C  
ATOM    986  CG  LEU A  67       9.502   3.170   6.972  1.00  0.43           C  
ATOM    987  CD1 LEU A  67      10.744   3.074   6.099  1.00  0.48           C  
ATOM    988  CD2 LEU A  67       9.788   3.984   8.226  1.00  0.47           C  
ATOM    989  H   LEU A  67       6.853   1.800   6.899  1.00  0.37           H  
ATOM    990  HA  LEU A  67       7.189   4.516   7.834  1.00  0.37           H  
ATOM    991  HB2 LEU A  67       8.170   3.192   5.305  1.00  0.37           H  
ATOM    992  HG  LEU A  67       9.227   2.171   7.275  1.00  0.45           H  
ATOM    993 HD11 LEU A  67      11.039   4.063   5.780  1.00  1.15           H  
ATOM    994 HD12 LEU A  67      11.547   2.625   6.667  1.00  1.08           H  
ATOM    995 HD13 LEU A  67      10.531   2.465   5.233  1.00  1.15           H  
ATOM    996 HD21 LEU A  67       8.897   4.030   8.835  1.00  1.09           H  
ATOM    997 HD22 LEU A  67      10.584   3.514   8.784  1.00  1.10           H  
ATOM    998 HD23 LEU A  67      10.085   4.983   7.945  1.00  1.16           H  
ATOM    999  N   ILE A  68       5.654   3.963   4.955  1.00  0.31           N  
ATOM   1000  CA  ILE A  68       4.671   4.514   4.031  1.00  0.30           C  
ATOM   1001  C   ILE A  68       3.284   4.557   4.664  1.00  0.30           C  
ATOM   1002  O   ILE A  68       2.918   3.673   5.439  1.00  0.37           O  
ATOM   1003  CB  ILE A  68       4.607   3.692   2.728  1.00  0.34           C  
ATOM   1004  CG1 ILE A  68       4.201   2.249   3.029  1.00  0.38           C  
ATOM   1005  CG2 ILE A  68       5.946   3.733   2.011  1.00  0.38           C  
ATOM   1006  CD1 ILE A  68       4.169   1.364   1.803  1.00  0.43           C  
ATOM   1007  H   ILE A  68       6.087   3.111   4.742  1.00  0.34           H  
ATOM   1008  HA  ILE A  68       4.975   5.521   3.782  1.00  0.30           H  
ATOM   1009  HB  ILE A  68       3.866   4.141   2.084  1.00  0.34           H  
ATOM   1010 HG12 ILE A  68       4.905   1.823   3.728  1.00  0.40           H  
ATOM   1011 HG21 ILE A  68       6.709   3.308   2.645  1.00  1.00           H  
ATOM   1012 HG22 ILE A  68       5.881   3.161   1.095  1.00  1.00           H  
ATOM   1013 HG23 ILE A  68       6.200   4.755   1.777  1.00  1.07           H  
ATOM   1014 HD11 ILE A  68       3.827   0.377   2.079  1.00  1.08           H  
ATOM   1015 HD12 ILE A  68       3.495   1.785   1.071  1.00  1.12           H  
ATOM   1016 HD13 ILE A  68       5.161   1.297   1.382  1.00  1.12           H  
ATOM   1017  N   GLU A  69       2.521   5.592   4.332  1.00  0.29           N  
ATOM   1018  CA  GLU A  69       1.176   5.754   4.872  1.00  0.32           C  
ATOM   1019  C   GLU A  69       0.138   5.142   3.937  1.00  0.31           C  
ATOM   1020  O   GLU A  69       0.364   5.031   2.731  1.00  0.37           O  
ATOM   1021  CB  GLU A  69       0.871   7.237   5.093  1.00  0.34           C  
ATOM   1022  CG  GLU A  69      -0.370   7.484   5.934  1.00  0.44           C  
ATOM   1023  CD  GLU A  69      -0.590   8.954   6.229  1.00  1.30           C  
ATOM   1024  OE1 GLU A  69      -1.238   9.636   5.407  1.00  2.29           O  
ATOM   1025  OE2 GLU A  69      -0.112   9.426   7.283  1.00  1.26           O  
ATOM   1026  H   GLU A  69       2.868   6.262   3.705  1.00  0.30           H  
ATOM   1027  HA  GLU A  69       1.136   5.241   5.821  1.00  0.35           H  
ATOM   1028  HB2 GLU A  69       1.714   7.695   5.585  1.00  0.35           H  
ATOM   1029  HG2 GLU A  69      -1.231   7.107   5.405  1.00  1.00           H  
ATOM   1030  N   LEU A  70      -1.000   4.749   4.498  1.00  0.32           N  
ATOM   1031  CA  LEU A  70      -2.070   4.145   3.712  1.00  0.33           C  
ATOM   1032  C   LEU A  70      -3.414   4.797   4.025  1.00  0.33           C  
ATOM   1033  O   LEU A  70      -3.651   5.250   5.144  1.00  0.45           O  
ATOM   1034  CB  LEU A  70      -2.148   2.641   3.986  1.00  0.38           C  
ATOM   1035  CG  LEU A  70      -0.877   1.854   3.659  1.00  0.95           C  
ATOM   1036  CD1 LEU A  70      -1.053   0.387   4.019  1.00  1.25           C  
ATOM   1037  CD2 LEU A  70      -0.520   2.003   2.187  1.00  1.85           C  
ATOM   1038  H   LEU A  70      -1.124   4.867   5.464  1.00  0.37           H  
ATOM   1039  HA  LEU A  70      -1.842   4.300   2.668  1.00  0.35           H  
ATOM   1040  HB2 LEU A  70      -2.374   2.498   5.032  1.00  0.72           H  
ATOM   1041  HG  LEU A  70      -0.058   2.244   4.244  1.00  1.72           H  
ATOM   1042 HD11 LEU A  70      -1.255   0.298   5.077  1.00  1.77           H  
ATOM   1043 HD12 LEU A  70      -1.879  -0.025   3.460  1.00  1.79           H  
ATOM   1044 HD13 LEU A  70      -0.150  -0.154   3.779  1.00  1.66           H  
ATOM   1045 HD21 LEU A  70      -0.382   3.050   1.954  1.00  2.39           H  
ATOM   1046 HD22 LEU A  70       0.392   1.465   1.982  1.00  2.36           H  
ATOM   1047 HD23 LEU A  70      -1.319   1.602   1.580  1.00  2.28           H  
ATOM   1048  N   GLU A  71      -4.290   4.837   3.027  1.00  0.35           N  
ATOM   1049  CA  GLU A  71      -5.612   5.427   3.193  1.00  0.38           C  
ATOM   1050  C   GLU A  71      -6.684   4.526   2.591  1.00  0.37           C  
ATOM   1051  O   GLU A  71      -6.713   4.303   1.381  1.00  0.52           O  
ATOM   1052  CB  GLU A  71      -5.667   6.811   2.542  1.00  0.47           C  
ATOM   1053  CG  GLU A  71      -7.030   7.474   2.642  1.00  0.54           C  
ATOM   1054  CD  GLU A  71      -7.062   8.848   2.001  1.00  1.31           C  
ATOM   1055  OE1 GLU A  71      -7.350   8.931   0.788  1.00  2.24           O  
ATOM   1056  OE2 GLU A  71      -6.800   9.841   2.712  1.00  1.26           O  
ATOM   1057  H   GLU A  71      -4.039   4.461   2.157  1.00  0.43           H  
ATOM   1058  HA  GLU A  71      -5.797   5.529   4.251  1.00  0.42           H  
ATOM   1059  HB2 GLU A  71      -4.942   7.451   3.023  1.00  0.53           H  
ATOM   1060  HG2 GLU A  71      -7.759   6.847   2.148  1.00  1.00           H  
ATOM   1061  N   ALA A  72      -7.563   4.009   3.444  1.00  0.45           N  
ATOM   1062  CA  ALA A  72      -8.636   3.131   2.994  1.00  0.52           C  
ATOM   1063  C   ALA A  72      -9.571   3.857   2.033  1.00  0.44           C  
ATOM   1064  O   ALA A  72      -9.816   5.056   2.172  1.00  0.53           O  
ATOM   1065  CB  ALA A  72      -9.414   2.594   4.185  1.00  0.76           C  
ATOM   1066  H   ALA A  72      -7.488   4.222   4.397  1.00  0.58           H  
ATOM   1067  HA  ALA A  72      -8.189   2.295   2.479  1.00  0.58           H  
ATOM   1068  HB1 ALA A  72      -9.875   3.415   4.714  1.00  1.26           H  
ATOM   1069  HB2 ALA A  72     -10.178   1.914   3.839  1.00  1.30           H  
ATOM   1070  HB3 ALA A  72      -8.741   2.071   4.849  1.00  1.34           H  
ATOM   1071  N   VAL A  73     -10.089   3.121   1.055  1.00  0.58           N  
ATOM   1072  CA  VAL A  73     -11.002   3.692   0.071  1.00  0.64           C  
ATOM   1073  C   VAL A  73     -12.254   4.246   0.737  1.00  0.83           C  
ATOM   1074  O   VAL A  73     -12.396   4.196   1.958  1.00  0.99           O  
ATOM   1075  CB  VAL A  73     -11.412   2.650  -0.984  1.00  0.78           C  
ATOM   1076  CG1 VAL A  73     -10.202   2.205  -1.793  1.00  1.01           C  
ATOM   1077  CG2 VAL A  73     -12.086   1.457  -0.325  1.00  1.16           C  
ATOM   1078  H   VAL A  73      -9.853   2.172   0.993  1.00  0.78           H  
ATOM   1079  HA  VAL A  73     -10.487   4.499  -0.432  1.00  0.66           H  
ATOM   1080  HB  VAL A  73     -12.119   3.108  -1.660  1.00  0.90           H  
ATOM   1081 HG11 VAL A  73      -9.470   1.766  -1.133  1.00  1.40           H  
ATOM   1082 HG12 VAL A  73     -10.509   1.476  -2.528  1.00  1.45           H  
ATOM   1083 HG13 VAL A  73      -9.769   3.059  -2.292  1.00  1.65           H  
ATOM   1084 HG21 VAL A  73     -12.947   1.793   0.235  1.00  1.42           H  
ATOM   1085 HG22 VAL A  73     -12.401   0.755  -1.083  1.00  1.62           H  
ATOM   1086 HG23 VAL A  73     -11.390   0.974   0.345  1.00  1.76           H  
ATOM   1087  N   ALA A  74     -13.166   4.772  -0.076  1.00  0.99           N  
ATOM   1088  CA  ALA A  74     -14.408   5.338   0.435  1.00  1.25           C  
ATOM   1089  C   ALA A  74     -15.505   4.282   0.511  1.00  1.66           C  
ATOM   1090  O   ALA A  74     -16.112   3.929  -0.499  1.00  2.28           O  
ATOM   1091  CB  ALA A  74     -14.853   6.502  -0.438  1.00  1.57           C  
ATOM   1092  H   ALA A  74     -12.997   4.780  -1.042  1.00  1.02           H  
ATOM   1093  HA  ALA A  74     -14.216   5.717   1.428  1.00  1.32           H  
ATOM   1094  HB1 ALA A  74     -14.065   7.239  -0.484  1.00  2.22           H  
ATOM   1095  HB2 ALA A  74     -15.072   6.144  -1.433  1.00  1.69           H  
ATOM   1096  HB3 ALA A  74     -15.740   6.950  -0.014  1.00  1.93           H  
ATOM   1097  N   GLN A  75     -15.753   3.782   1.718  1.00  1.95           N  
ATOM   1098  CA  GLN A  75     -16.781   2.769   1.927  1.00  2.53           C  
ATOM   1099  C   GLN A  75     -18.144   3.277   1.470  1.00  2.88           C  
ATOM   1100  O   GLN A  75     -18.496   4.435   1.703  1.00  3.14           O  
ATOM   1101  CB  GLN A  75     -16.840   2.372   3.402  1.00  3.27           C  
ATOM   1102  CG  GLN A  75     -15.546   1.765   3.920  1.00  3.83           C  
ATOM   1103  CD  GLN A  75     -15.164   0.496   3.184  1.00  4.50           C  
ATOM   1104  OE1 GLN A  75     -15.548  -0.606   3.578  1.00  4.86           O  
ATOM   1105  NE2 GLN A  75     -14.404   0.644   2.104  1.00  5.13           N  
ATOM   1106  H   GLN A  75     -15.232   4.099   2.484  1.00  2.15           H  
ATOM   1107  HA  GLN A  75     -16.517   1.902   1.339  1.00  2.76           H  
ATOM   1108  HB2 GLN A  75     -17.061   3.250   3.991  1.00  3.74           H  
ATOM   1109  HG2 GLN A  75     -14.752   2.485   3.799  1.00  4.02           H  
ATOM   1110 HE21 GLN A  75     -14.136   1.551   1.847  1.00  5.14           H  
ATOM   1111 HE22 GLN A  75     -14.143  -0.160   1.609  1.00  5.77           H  
TER    1112      GLN A  75                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
