
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   64 ( 1024),  selected   64 , name 2juf_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 2juf_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y    14_A      F       2          3.646
LGA    G    15_A      S       3          3.583
LGA    E    16_A      L       4           -
LGA    Y    17_A      -       -           -
LGA    V    18_A      -       -           -
LGA    Q    19_A      R       5          3.565
LGA    Q    20_A      D       6          4.534
LGA    T    21_A      -       -           -
LGA    L    22_A      A       7          1.995
LGA    Q    23_A      K       8          2.715
LGA    P    24_A      C       9          2.466
LGA    G    25_A      G      10          1.676
LGA    M    26_A      Q      11          1.281
LGA    R    27_A      T      12          1.020
LGA    V    28_A      V      13          1.614
LGA    R    29_A      K      14          2.082
LGA    M    30_A      V      15          2.761
LGA    -       -      V      16           -
LGA    L    31_A      K      17          2.892
LGA    D    32_A      L      18          2.878
LGA    -       -      H      19           -
LGA    -       -      G      20           -
LGA    -       -      T      21           -
LGA    -       -      G      22           -
LGA    -       -      A      23           -
LGA    -       -      L      24           -
LGA    D    33_A      K      25          4.828
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    Y    34_A      I      28          1.894
LGA    -       -      M      29           -
LGA    E    35_A      D      30          2.708
LGA    E    36_A      M      31          2.227
LGA    I    37_A      G      32          1.316
LGA    -       -      I      33           -
LGA    S    38_A      T      34          2.078
LGA    A    39_A      R      35          2.102
LGA    G    40_A      G      36          1.754
LGA    D    41_A      C      37          1.194
LGA    E    42_A      E      38          1.124
LGA    G    43_A      I      39          1.408
LGA    E    44_A      Y      40          0.185
LGA    F    45_A      I      41          0.625
LGA    R    46_A      R      42          0.231
LGA    Q    47_A      K      43          0.511
LGA    S    48_A      V      44          1.316
LGA    N    49_A      A      45          2.195
LGA    N    50_A      G      48          2.371
LGA    G    51_A      -       -           -
LGA    I    52_A      D      49          2.299
LGA    P    53_A      -       -           -
LGA    P    54_A      P      50          3.782
LGA    V    55_A      I      51          1.429
LGA    Q    56_A      Q      52          1.649
LGA    V    57_A      I      53          0.953
LGA    F    58_A      N      54          0.498
LGA    W    59_A      V      55          0.650
LGA    Q    60_A      R      56          2.428
LGA    S    61_A      -       -           -
LGA    T    62_A      -       -           -
LGA    G    63_A      G      57          1.472
LGA    R    64_A      Y      58          0.611
LGA    T    65_A      E      59          1.591
LGA    Y    66_A      L      60          2.685
LGA    W    67_A      S      61          3.081
LGA    V    68_A      L      62          3.154
LGA    -       -      R      63           -
LGA    -       -      K      64           -
LGA    -       -      S      65           -
LGA    H    69_A      A      66          2.530
LGA    W    70_A      A      67          2.442
LGA    H    71_A      E      68          2.677
LGA    -       -      M      69           -
LGA    M    72_A      I      70          0.550
LGA    L    73_A      E      71          4.785
LGA    E    74_A      V      72          1.197
LGA    I    75_A      E      73          2.318
LGA    L    76_A      -       -           -
LGA    G    77_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   64   70    5.0     54    2.34    14.81     59.180     2.209

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.395906 * X  +  -0.891597 * Y  +  -0.219803 * Z  +  -0.089017
  Y_new =  -0.648233 * X  +   0.101812 * Y  +   0.754605 * Z  +  -1.465736
  Z_new =  -0.650425 * X  +   0.441236 * Y  +  -0.618270 * Z  +  -0.540707 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.521756   -0.619836  [ DEG:   144.4860    -35.5140 ]
  Theta =   0.708144    2.433449  [ DEG:    40.5737    139.4263 ]
  Phi   =  -2.119080    1.022512  [ DEG:  -121.4144     58.5856 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2juf_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2juf_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   64   70   5.0   54   2.34   14.81  59.180
REMARK  ---------------------------------------------------------- 
MOLECULE 2juf_A
HEADER    GENE REGULATION                         23-AUG-07   2JUF              
TITLE     NMR SOLUTION STRUCTURE OF PARC CPH DOMAIN. NESG TARGET                
TITLE    2 HR3443B/SGC-TORONTO                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P53-ASSOCIATED PARKIN-LIKE CYTOPLASMIC PROTEIN;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CPH DOMAIN: RESIDUES 366-466;                              
COMPND   5 SYNONYM: UBCH7-ASSOCIATED PROTEIN 1;                                 
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PARC, H7AP1, KIAA0708;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    CPH DOMAIN, STRUCTURAL GENOMICS CONSORTIUM, SGC, NORTHEAST            
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, NESG, ALTERNATIVE SPLICING,          
KEYWDS   3 ATP-BINDING, COILED COIL, CYTOPLASM, METAL-BINDING,                  
KEYWDS   4 NUCLEOTIDE-BINDING, UBL CONJUGATION, UBL CONJUGATION                 
KEYWDS   5 PATHWAY, ZINC, ZINC-FINGER, PSI-2, PROTEIN STRUCTURE                 
KEYWDS   6 INITIATIVE, GENE REGULATION                                          
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    L.KAUSTOV,J.C.C.LIAO,S.LEMAK,S.DUAN,R.MUHANDIRAM,M.KARRA,             
AUTHOR   2 S.H.SRISAILAM,M.SUNDSTROM,J.WEIGELT,A.M.EDWARDS,S.DHE-               
AUTHOR   3 PAGANON,C.H.ARROWSMITH,STRUCTURAL GENOMICS CONSORTIUM (SGC),         
AUTHOR   4 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   16-OCT-07 2JUF    0                                                
JRNL        AUTH   L.KAUSTOV,J.C.C.LIAO,S.LEMAK,S.DUAN,R.MUHANDIRAM,            
JRNL        AUTH 2 M.KARRA,S.H.SRISAILAM,M.SUNDSTROM,J.WEIGELT,                 
JRNL        AUTH 3 A.M.EDWARDS,S.DHE-PAGANON,C.H.ARROWSMITH                     
JRNL        TITL   NMR SOLUTION STRUCTURE OF PARC CPH DOMAIN.                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JUF A    5   105  UNP    Q8IWT3   PARC_HUMAN     366    466             
SEQRES   1 A  105  GLY SER HIS MET ARG SER GLU PHE SER SER ARG GLY GLY          
SEQRES   2 A  105  TYR GLY GLU TYR VAL GLN GLN THR LEU GLN PRO GLY MET          
SEQRES   3 A  105  ARG VAL ARG MET LEU ASP ASP TYR GLU GLU ILE SER ALA          
SEQRES   4 A  105  GLY ASP GLU GLY GLU PHE ARG GLN SER ASN ASN GLY ILE          
SEQRES   5 A  105  PRO PRO VAL GLN VAL PHE TRP GLN SER THR GLY ARG THR          
SEQRES   6 A  105  TYR TRP VAL HIS TRP HIS MET LEU GLU ILE LEU GLY PRO          
SEQRES   7 A  105  GLU GLU ALA THR GLU ASP LYS ALA SER ALA ALA VAL GLU          
SEQRES   8 A  105  LYS GLY ALA GLY ALA THR VAL LEU GLY THR ALA PHE PRO          
SEQRES   9 A  105  SER                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   TYR A  14       2.185   3.600  12.483  1.00  0.00           N  
ATOM      2  CA  TYR A  14       1.042   3.606  11.549  1.00  0.00           C  
ATOM      3  C   TYR A  14       0.971   2.271  10.777  1.00  0.00           C  
ATOM      4  O   TYR A  14      -0.118   1.804  10.412  1.00  0.00           O  
ATOM      5  CB  TYR A  14       1.175   4.804  10.568  1.00  0.00           C  
ATOM      6  CG  TYR A  14       0.040   4.895   9.530  1.00  0.00           C  
ATOM      7  CD1 TYR A  14      -1.253   5.256   9.919  1.00  0.00           C  
ATOM      8  CD2 TYR A  14       0.250   4.588   8.176  1.00  0.00           C  
ATOM      9  CE1 TYR A  14      -2.287   5.301   9.011  1.00  0.00           C  
ATOM     10  CE2 TYR A  14      -0.787   4.642   7.262  1.00  0.00           C  
ATOM     11  CZ  TYR A  14      -2.054   4.998   7.688  1.00  0.00           C  
ATOM     12  OH  TYR A  14      -3.101   5.033   6.794  1.00  0.00           O  
ATOM     13  H   TYR A  14       2.940   4.188  12.293  1.00  0.00           H  
ATOM     14  HA  TYR A  14       0.134   3.725  12.135  1.00  0.00           H  
ATOM     15  HB2 TYR A  14       1.179   5.726  11.140  1.00  0.00           H  
ATOM     16  HB3 TYR A  14       2.123   4.724  10.040  1.00  0.00           H  
ATOM     17  HD1 TYR A  14      -1.444   5.501  10.959  1.00  0.00           H  
ATOM     18  HD2 TYR A  14       1.243   4.307   7.845  1.00  0.00           H  
ATOM     19  HE1 TYR A  14      -3.280   5.582   9.340  1.00  0.00           H  
ATOM     20  HE2 TYR A  14      -0.604   4.403   6.218  1.00  0.00           H  
ATOM     21  HH  TYR A  14      -3.574   5.869   6.887  1.00  0.00           H  
ATOM     22  N   GLY A  15       2.159   1.674  10.559  1.00  0.00           N  
ATOM     23  CA  GLY A  15       2.287   0.379   9.898  1.00  0.00           C  
ATOM     24  C   GLY A  15       1.612  -0.746  10.662  1.00  0.00           C  
ATOM     25  O   GLY A  15       1.099  -1.687  10.055  1.00  0.00           O  
ATOM     26  H   GLY A  15       2.969   2.126  10.869  1.00  0.00           H  
ATOM     27  HA2 GLY A  15       1.855   0.446   8.905  1.00  0.00           H  
ATOM     28  HA3 GLY A  15       3.337   0.146   9.800  1.00  0.00           H  
ATOM     29  N   GLU A  16       1.617  -0.634  12.000  1.00  0.00           N  
ATOM     30  CA  GLU A  16       0.900  -1.560  12.886  1.00  0.00           C  
ATOM     31  C   GLU A  16      -0.609  -1.483  12.625  1.00  0.00           C  
ATOM     32  O   GLU A  16      -1.247  -2.512  12.402  1.00  0.00           O  
ATOM     33  CB  GLU A  16       1.194  -1.213  14.359  1.00  0.00           C  
ATOM     34  CG  GLU A  16       0.513  -2.125  15.401  1.00  0.00           C  
ATOM     35  CD  GLU A  16       0.784  -1.678  16.848  1.00  0.00           C  
ATOM     36  OE1 GLU A  16       0.054  -0.795  17.357  1.00  0.00           O  
ATOM     37  OE2 GLU A  16       1.731  -2.194  17.481  1.00  0.00           O  
ATOM     38  H   GLU A  16       2.127   0.100  12.406  1.00  0.00           H  
ATOM     39  HA  GLU A  16       1.254  -2.568  12.681  1.00  0.00           H  
ATOM     40  HB2 GLU A  16       2.267  -1.272  14.509  1.00  0.00           H  
ATOM     41  HB3 GLU A  16       0.880  -0.186  14.544  1.00  0.00           H  
ATOM     42  HG2 GLU A  16      -0.561  -2.118  15.225  1.00  0.00           H  
ATOM     43  HG3 GLU A  16       0.879  -3.140  15.268  1.00  0.00           H  
ATOM     44  N   TYR A  17      -1.143  -0.235  12.592  1.00  0.00           N  
ATOM     45  CA  TYR A  17      -2.589   0.021  12.425  1.00  0.00           C  
ATOM     46  C   TYR A  17      -3.110  -0.614  11.127  1.00  0.00           C  
ATOM     47  O   TYR A  17      -4.093  -1.367  11.156  1.00  0.00           O  
ATOM     48  CB  TYR A  17      -2.882   1.562  12.431  1.00  0.00           C  
ATOM     49  CG  TYR A  17      -4.202   1.966  11.730  1.00  0.00           C  
ATOM     50  CD1 TYR A  17      -5.449   1.627  12.265  1.00  0.00           C  
ATOM     51  CD2 TYR A  17      -4.188   2.637  10.499  1.00  0.00           C  
ATOM     52  CE1 TYR A  17      -6.622   1.948  11.606  1.00  0.00           C  
ATOM     53  CE2 TYR A  17      -5.359   2.948   9.835  1.00  0.00           C  
ATOM     54  CZ  TYR A  17      -6.571   2.604  10.393  1.00  0.00           C  
ATOM     55  OH  TYR A  17      -7.739   2.898   9.725  1.00  0.00           O  
ATOM     56  H   TYR A  17      -0.540   0.533  12.672  1.00  0.00           H  
ATOM     57  HA  TYR A  17      -3.103  -0.434  13.266  1.00  0.00           H  
ATOM     58  HB2 TYR A  17      -2.934   1.911  13.454  1.00  0.00           H  
ATOM     59  HB3 TYR A  17      -2.067   2.077  11.933  1.00  0.00           H  
ATOM     60  HD1 TYR A  17      -5.493   1.110  13.215  1.00  0.00           H  
ATOM     61  HD2 TYR A  17      -3.237   2.912  10.061  1.00  0.00           H  
ATOM     62  HE1 TYR A  17      -7.572   1.677  12.042  1.00  0.00           H  
ATOM     63  HE2 TYR A  17      -5.316   3.467   8.882  1.00  0.00           H  
ATOM     64  HH  TYR A  17      -7.649   2.645   8.799  1.00  0.00           H  
ATOM     65  N   VAL A  18      -2.416  -0.340  10.007  1.00  0.00           N  
ATOM     66  CA  VAL A  18      -2.842  -0.831   8.694  1.00  0.00           C  
ATOM     67  C   VAL A  18      -2.708  -2.361   8.616  1.00  0.00           C  
ATOM     68  O   VAL A  18      -3.600  -3.027   8.107  1.00  0.00           O  
ATOM     69  CB  VAL A  18      -2.105  -0.122   7.497  1.00  0.00           C  
ATOM     70  CG1 VAL A  18      -2.481   1.375   7.423  1.00  0.00           C  
ATOM     71  CG2 VAL A  18      -0.583  -0.307   7.573  1.00  0.00           C  
ATOM     72  H   VAL A  18      -1.598   0.204  10.074  1.00  0.00           H  
ATOM     73  HA  VAL A  18      -3.905  -0.593   8.604  1.00  0.00           H  
ATOM     74  HB  VAL A  18      -2.450  -0.585   6.572  1.00  0.00           H  
ATOM     75 HG11 VAL A  18      -2.178   1.875   8.337  1.00  0.00           H  
ATOM     76 HG12 VAL A  18      -3.552   1.481   7.299  1.00  0.00           H  
ATOM     77 HG13 VAL A  18      -1.980   1.838   6.581  1.00  0.00           H  
ATOM     78 HG21 VAL A  18      -0.107   0.183   6.730  1.00  0.00           H  
ATOM     79 HG22 VAL A  18      -0.339  -1.364   7.551  1.00  0.00           H  
ATOM     80 HG23 VAL A  18      -0.206   0.123   8.492  1.00  0.00           H  
ATOM     81  N   GLN A  19      -1.626  -2.909   9.204  1.00  0.00           N  
ATOM     82  CA  GLN A  19      -1.386  -4.367   9.256  1.00  0.00           C  
ATOM     83  C   GLN A  19      -2.561  -5.116   9.930  1.00  0.00           C  
ATOM     84  O   GLN A  19      -2.869  -6.265   9.575  1.00  0.00           O  
ATOM     85  CB  GLN A  19      -0.057  -4.665  10.000  1.00  0.00           C  
ATOM     86  CG  GLN A  19       0.326  -6.157  10.046  1.00  0.00           C  
ATOM     87  CD  GLN A  19       1.570  -6.466  10.884  1.00  0.00           C  
ATOM     88  OE1 GLN A  19       2.506  -5.667  10.965  1.00  0.00           O  
ATOM     89  NE2 GLN A  19       1.571  -7.624  11.528  1.00  0.00           N  
ATOM     90  H   GLN A  19      -0.964  -2.314   9.617  1.00  0.00           H  
ATOM     91  HA  GLN A  19      -1.296  -4.717   8.230  1.00  0.00           H  
ATOM     92  HB2 GLN A  19       0.745  -4.125   9.505  1.00  0.00           H  
ATOM     93  HB3 GLN A  19      -0.137  -4.299  11.022  1.00  0.00           H  
ATOM     94  HG2 GLN A  19      -0.510  -6.713  10.456  1.00  0.00           H  
ATOM     95  HG3 GLN A  19       0.506  -6.497   9.032  1.00  0.00           H  
ATOM     96 HE21 GLN A  19       0.783  -8.208  11.437  1.00  0.00           H  
ATOM     97 HE22 GLN A  19       2.355  -7.848  12.071  1.00  0.00           H  
ATOM     98  N   GLN A  20      -3.227  -4.442  10.886  1.00  0.00           N  
ATOM     99  CA  GLN A  20      -4.328  -5.040  11.661  1.00  0.00           C  
ATOM    100  C   GLN A  20      -5.657  -4.980  10.878  1.00  0.00           C  
ATOM    101  O   GLN A  20      -6.440  -5.936  10.903  1.00  0.00           O  
ATOM    102  CB  GLN A  20      -4.504  -4.323  13.030  1.00  0.00           C  
ATOM    103  CG  GLN A  20      -3.263  -4.309  13.951  1.00  0.00           C  
ATOM    104  CD  GLN A  20      -2.617  -5.682  14.148  1.00  0.00           C  
ATOM    105  OE1 GLN A  20      -2.998  -6.436  15.042  1.00  0.00           O  
ATOM    106  NE2 GLN A  20      -1.622  -6.006  13.326  1.00  0.00           N  
ATOM    107  H   GLN A  20      -2.986  -3.503  11.055  1.00  0.00           H  
ATOM    108  HA  GLN A  20      -4.072  -6.084  11.846  1.00  0.00           H  
ATOM    109  HB2 GLN A  20      -4.787  -3.292  12.844  1.00  0.00           H  
ATOM    110  HB3 GLN A  20      -5.316  -4.804  13.571  1.00  0.00           H  
ATOM    111  HG2 GLN A  20      -2.525  -3.639  13.531  1.00  0.00           H  
ATOM    112  HG3 GLN A  20      -3.558  -3.925  14.922  1.00  0.00           H  
ATOM    113 HE21 GLN A  20      -1.356  -5.355  12.644  1.00  0.00           H  
ATOM    114 HE22 GLN A  20      -1.196  -6.884  13.436  1.00  0.00           H  
ATOM    115  N   THR A  21      -5.907  -3.846  10.192  1.00  0.00           N  
ATOM    116  CA  THR A  21      -7.232  -3.537   9.594  1.00  0.00           C  
ATOM    117  C   THR A  21      -7.300  -3.816   8.068  1.00  0.00           C  
ATOM    118  O   THR A  21      -8.379  -3.704   7.474  1.00  0.00           O  
ATOM    119  CB  THR A  21      -7.624  -2.048   9.899  1.00  0.00           C  
ATOM    120  OG1 THR A  21      -8.960  -1.760   9.443  1.00  0.00           O  
ATOM    121  CG2 THR A  21      -6.641  -1.053   9.266  1.00  0.00           C  
ATOM    122  H   THR A  21      -5.183  -3.186  10.095  1.00  0.00           H  
ATOM    123  HA  THR A  21      -7.974  -4.169  10.080  1.00  0.00           H  
ATOM    124  HB  THR A  21      -7.601  -1.905  10.976  1.00  0.00           H  
ATOM    125  HG1 THR A  21      -9.034  -1.961   8.505  1.00  0.00           H  
ATOM    126 HG21 THR A  21      -6.644  -1.169   8.189  1.00  0.00           H  
ATOM    127 HG22 THR A  21      -5.643  -1.233   9.640  1.00  0.00           H  
ATOM    128 HG23 THR A  21      -6.935  -0.040   9.513  1.00  0.00           H  
ATOM    129  N   LEU A  22      -6.163  -4.172   7.434  1.00  0.00           N  
ATOM    130  CA  LEU A  22      -6.120  -4.451   5.975  1.00  0.00           C  
ATOM    131  C   LEU A  22      -6.871  -5.764   5.649  1.00  0.00           C  
ATOM    132  O   LEU A  22      -6.395  -6.862   5.959  1.00  0.00           O  
ATOM    133  CB  LEU A  22      -4.642  -4.480   5.431  1.00  0.00           C  
ATOM    134  CG  LEU A  22      -4.213  -3.268   4.534  1.00  0.00           C  
ATOM    135  CD1 LEU A  22      -5.056  -3.178   3.258  1.00  0.00           C  
ATOM    136  CD2 LEU A  22      -4.275  -1.944   5.303  1.00  0.00           C  
ATOM    137  H   LEU A  22      -5.339  -4.258   7.955  1.00  0.00           H  
ATOM    138  HA  LEU A  22      -6.647  -3.631   5.486  1.00  0.00           H  
ATOM    139  HB2 LEU A  22      -3.965  -4.522   6.281  1.00  0.00           H  
ATOM    140  HB3 LEU A  22      -4.491  -5.386   4.852  1.00  0.00           H  
ATOM    141  HG  LEU A  22      -3.184  -3.413   4.225  1.00  0.00           H  
ATOM    142 HD11 LEU A  22      -4.694  -2.368   2.641  1.00  0.00           H  
ATOM    143 HD12 LEU A  22      -6.094  -2.997   3.508  1.00  0.00           H  
ATOM    144 HD13 LEU A  22      -4.981  -4.103   2.706  1.00  0.00           H  
ATOM    145 HD21 LEU A  22      -3.963  -1.131   4.660  1.00  0.00           H  
ATOM    146 HD22 LEU A  22      -3.611  -1.994   6.151  1.00  0.00           H  
ATOM    147 HD23 LEU A  22      -5.284  -1.758   5.651  1.00  0.00           H  
ATOM    148  N   GLN A  23      -8.051  -5.616   5.025  1.00  0.00           N  
ATOM    149  CA  GLN A  23      -8.941  -6.733   4.668  1.00  0.00           C  
ATOM    150  C   GLN A  23      -8.565  -7.301   3.283  1.00  0.00           C  
ATOM    151  O   GLN A  23      -8.176  -6.529   2.400  1.00  0.00           O  
ATOM    152  CB  GLN A  23     -10.417  -6.260   4.649  1.00  0.00           C  
ATOM    153  CG  GLN A  23     -10.935  -5.710   5.989  1.00  0.00           C  
ATOM    154  CD  GLN A  23     -12.410  -5.316   5.929  1.00  0.00           C  
ATOM    155  OE1 GLN A  23     -12.751  -4.183   5.597  1.00  0.00           O  
ATOM    156  NE2 GLN A  23     -13.291  -6.254   6.231  1.00  0.00           N  
ATOM    157  H   GLN A  23      -8.330  -4.711   4.788  1.00  0.00           H  
ATOM    158  HA  GLN A  23      -8.828  -7.512   5.417  1.00  0.00           H  
ATOM    159  HB2 GLN A  23     -10.519  -5.473   3.903  1.00  0.00           H  
ATOM    160  HB3 GLN A  23     -11.047  -7.096   4.357  1.00  0.00           H  
ATOM    161  HG2 GLN A  23     -10.802  -6.461   6.760  1.00  0.00           H  
ATOM    162  HG3 GLN A  23     -10.351  -4.832   6.252  1.00  0.00           H  
ATOM    163 HE21 GLN A  23     -12.955  -7.140   6.474  1.00  0.00           H  
ATOM    164 HE22 GLN A  23     -14.242  -6.023   6.204  1.00  0.00           H  
ATOM    165  N   PRO A  24      -8.648  -8.663   3.096  1.00  0.00           N  
ATOM    166  CA  PRO A  24      -8.387  -9.330   1.793  1.00  0.00           C  
ATOM    167  C   PRO A  24      -9.322  -8.862   0.645  1.00  0.00           C  
ATOM    168  O   PRO A  24     -10.308  -9.530   0.328  1.00  0.00           O  
ATOM    169  CB  PRO A  24      -8.558 -10.846   2.117  1.00  0.00           C  
ATOM    170  CG  PRO A  24      -8.358 -10.938   3.598  1.00  0.00           C  
ATOM    171  CD  PRO A  24      -8.950  -9.669   4.156  1.00  0.00           C  
ATOM    172  HA  PRO A  24      -7.367  -9.155   1.484  1.00  0.00           H  
ATOM    173  HB2 PRO A  24      -9.551 -11.188   1.827  1.00  0.00           H  
ATOM    174  HB3 PRO A  24      -7.814 -11.425   1.581  1.00  0.00           H  
ATOM    175  HG2 PRO A  24      -8.869 -11.809   3.992  1.00  0.00           H  
ATOM    176  HG3 PRO A  24      -7.297 -10.994   3.829  1.00  0.00           H  
ATOM    177  HD2 PRO A  24     -10.023  -9.768   4.304  1.00  0.00           H  
ATOM    178  HD3 PRO A  24      -8.468  -9.407   5.093  1.00  0.00           H  
ATOM    179  N   GLY A  25      -9.020  -7.683   0.054  1.00  0.00           N  
ATOM    180  CA  GLY A  25      -9.728  -7.192  -1.133  1.00  0.00           C  
ATOM    181  C   GLY A  25     -10.183  -5.747  -0.998  1.00  0.00           C  
ATOM    182  O   GLY A  25     -11.075  -5.318  -1.738  1.00  0.00           O  
ATOM    183  H   GLY A  25      -8.320  -7.115   0.448  1.00  0.00           H  
ATOM    184  HA2 GLY A  25      -9.058  -7.260  -1.980  1.00  0.00           H  
ATOM    185  HA3 GLY A  25     -10.600  -7.813  -1.332  1.00  0.00           H  
ATOM    186  N   MET A  26      -9.578  -4.982  -0.062  1.00  0.00           N  
ATOM    187  CA  MET A  26      -9.942  -3.558   0.150  1.00  0.00           C  
ATOM    188  C   MET A  26      -9.020  -2.631  -0.661  1.00  0.00           C  
ATOM    189  O   MET A  26      -8.037  -3.072  -1.250  1.00  0.00           O  
ATOM    190  CB  MET A  26      -9.919  -3.153   1.656  1.00  0.00           C  
ATOM    191  CG  MET A  26      -8.545  -3.223   2.340  1.00  0.00           C  
ATOM    192  SD  MET A  26      -8.361  -2.027   3.692  1.00  0.00           S  
ATOM    193  CE  MET A  26      -9.794  -2.340   4.721  1.00  0.00           C  
ATOM    194  H   MET A  26      -8.866  -5.374   0.480  1.00  0.00           H  
ATOM    195  HA  MET A  26     -10.955  -3.419  -0.222  1.00  0.00           H  
ATOM    196  HB2 MET A  26     -10.282  -2.134   1.742  1.00  0.00           H  
ATOM    197  HB3 MET A  26     -10.603  -3.799   2.202  1.00  0.00           H  
ATOM    198  HG2 MET A  26      -8.397  -4.217   2.740  1.00  0.00           H  
ATOM    199  HG3 MET A  26      -7.769  -3.022   1.607  1.00  0.00           H  
ATOM    200  HE1 MET A  26      -9.785  -1.667   5.565  1.00  0.00           H  
ATOM    201  HE2 MET A  26      -9.765  -3.360   5.074  1.00  0.00           H  
ATOM    202  HE3 MET A  26     -10.699  -2.183   4.148  1.00  0.00           H  
ATOM    203  N   ARG A  27      -9.338  -1.336  -0.624  1.00  0.00           N  
ATOM    204  CA  ARG A  27      -8.711  -0.296  -1.450  1.00  0.00           C  
ATOM    205  C   ARG A  27      -7.610   0.395  -0.634  1.00  0.00           C  
ATOM    206  O   ARG A  27      -7.860   0.871   0.483  1.00  0.00           O  
ATOM    207  CB  ARG A  27      -9.803   0.713  -1.891  1.00  0.00           C  
ATOM    208  CG  ARG A  27      -9.338   1.932  -2.723  1.00  0.00           C  
ATOM    209  CD  ARG A  27      -8.800   1.557  -4.114  1.00  0.00           C  
ATOM    210  NE  ARG A  27      -8.705   2.733  -4.998  1.00  0.00           N  
ATOM    211  CZ  ARG A  27      -8.453   2.705  -6.313  1.00  0.00           C  
ATOM    212  NH1 ARG A  27      -8.198   1.564  -6.940  1.00  0.00           N  
ATOM    213  NH2 ARG A  27      -8.445   3.842  -6.993  1.00  0.00           N  
ATOM    214  H   ARG A  27     -10.003  -1.057   0.026  1.00  0.00           H  
ATOM    215  HA  ARG A  27      -8.276  -0.761  -2.332  1.00  0.00           H  
ATOM    216  HB2 ARG A  27     -10.541   0.175  -2.477  1.00  0.00           H  
ATOM    217  HB3 ARG A  27     -10.297   1.086  -1.003  1.00  0.00           H  
ATOM    218  HG2 ARG A  27     -10.178   2.606  -2.850  1.00  0.00           H  
ATOM    219  HG3 ARG A  27      -8.558   2.450  -2.174  1.00  0.00           H  
ATOM    220  HD2 ARG A  27      -7.815   1.121  -4.000  1.00  0.00           H  
ATOM    221  HD3 ARG A  27      -9.464   0.828  -4.568  1.00  0.00           H  
ATOM    222  HE  ARG A  27      -8.848   3.607  -4.576  1.00  0.00           H  
ATOM    223 HH11 ARG A  27      -8.186   0.699  -6.428  1.00  0.00           H  
ATOM    224 HH12 ARG A  27      -8.014   1.560  -7.926  1.00  0.00           H  
ATOM    225 HH21 ARG A  27      -8.623   4.710  -6.524  1.00  0.00           H  
ATOM    226 HH22 ARG A  27      -8.242   3.841  -7.976  1.00  0.00           H  
ATOM    227  N   VAL A  28      -6.397   0.449  -1.206  1.00  0.00           N  
ATOM    228  CA  VAL A  28      -5.198   0.965  -0.528  1.00  0.00           C  
ATOM    229  C   VAL A  28      -4.685   2.228  -1.250  1.00  0.00           C  
ATOM    230  O   VAL A  28      -5.185   2.588  -2.318  1.00  0.00           O  
ATOM    231  CB  VAL A  28      -4.059  -0.127  -0.435  1.00  0.00           C  
ATOM    232  CG1 VAL A  28      -4.601  -1.463   0.126  1.00  0.00           C  
ATOM    233  CG2 VAL A  28      -3.335  -0.347  -1.788  1.00  0.00           C  
ATOM    234  H   VAL A  28      -6.306   0.134  -2.128  1.00  0.00           H  
ATOM    235  HA  VAL A  28      -5.479   1.248   0.488  1.00  0.00           H  
ATOM    236  HB  VAL A  28      -3.313   0.242   0.276  1.00  0.00           H  
ATOM    237 HG11 VAL A  28      -3.795  -2.185   0.207  1.00  0.00           H  
ATOM    238 HG12 VAL A  28      -5.363  -1.856  -0.536  1.00  0.00           H  
ATOM    239 HG13 VAL A  28      -5.031  -1.301   1.107  1.00  0.00           H  
ATOM    240 HG21 VAL A  28      -2.537  -1.070  -1.669  1.00  0.00           H  
ATOM    241 HG22 VAL A  28      -2.913   0.591  -2.137  1.00  0.00           H  
ATOM    242 HG23 VAL A  28      -4.038  -0.711  -2.521  1.00  0.00           H  
ATOM    243  N   ARG A  29      -3.699   2.880  -0.643  1.00  0.00           N  
ATOM    244  CA  ARG A  29      -3.161   4.183  -1.062  1.00  0.00           C  
ATOM    245  C   ARG A  29      -1.646   4.191  -0.790  1.00  0.00           C  
ATOM    246  O   ARG A  29      -1.190   3.648   0.216  1.00  0.00           O  
ATOM    247  CB  ARG A  29      -3.860   5.315  -0.255  1.00  0.00           C  
ATOM    248  CG  ARG A  29      -3.404   6.757  -0.587  1.00  0.00           C  
ATOM    249  CD  ARG A  29      -3.849   7.240  -1.977  1.00  0.00           C  
ATOM    250  NE  ARG A  29      -3.620   8.692  -2.166  1.00  0.00           N  
ATOM    251  CZ  ARG A  29      -4.343   9.500  -2.970  1.00  0.00           C  
ATOM    252  NH1 ARG A  29      -5.376   9.033  -3.667  1.00  0.00           N  
ATOM    253  NH2 ARG A  29      -4.023  10.784  -3.080  1.00  0.00           N  
ATOM    254  H   ARG A  29      -3.287   2.457   0.132  1.00  0.00           H  
ATOM    255  HA  ARG A  29      -3.343   4.320  -2.126  1.00  0.00           H  
ATOM    256  HB2 ARG A  29      -4.931   5.252  -0.428  1.00  0.00           H  
ATOM    257  HB3 ARG A  29      -3.684   5.142   0.804  1.00  0.00           H  
ATOM    258  HG2 ARG A  29      -3.817   7.429   0.157  1.00  0.00           H  
ATOM    259  HG3 ARG A  29      -2.319   6.801  -0.530  1.00  0.00           H  
ATOM    260  HD2 ARG A  29      -3.289   6.698  -2.732  1.00  0.00           H  
ATOM    261  HD3 ARG A  29      -4.906   7.029  -2.100  1.00  0.00           H  
ATOM    262  HE  ARG A  29      -2.873   9.086  -1.659  1.00  0.00           H  
ATOM    263 HH11 ARG A  29      -5.639   8.068  -3.600  1.00  0.00           H  
ATOM    264 HH12 ARG A  29      -5.899   9.648  -4.260  1.00  0.00           H  
ATOM    265 HH21 ARG A  29      -3.252  11.161  -2.559  1.00  0.00           H  
ATOM    266 HH22 ARG A  29      -4.551  11.387  -3.686  1.00  0.00           H  
ATOM    267  N   MET A  30      -0.879   4.783  -1.702  1.00  0.00           N  
ATOM    268  CA  MET A  30       0.578   4.913  -1.576  1.00  0.00           C  
ATOM    269  C   MET A  30       0.897   6.328  -1.060  1.00  0.00           C  
ATOM    270  O   MET A  30       0.645   7.307  -1.764  1.00  0.00           O  
ATOM    271  CB  MET A  30       1.240   4.641  -2.962  1.00  0.00           C  
ATOM    272  CG  MET A  30       2.744   4.308  -2.940  1.00  0.00           C  
ATOM    273  SD  MET A  30       3.127   2.556  -2.639  1.00  0.00           S  
ATOM    274  CE  MET A  30       2.875   2.348  -0.873  1.00  0.00           C  
ATOM    275  H   MET A  30      -1.309   5.164  -2.488  1.00  0.00           H  
ATOM    276  HA  MET A  30       0.937   4.178  -0.859  1.00  0.00           H  
ATOM    277  HB2 MET A  30       0.737   3.800  -3.423  1.00  0.00           H  
ATOM    278  HB3 MET A  30       1.089   5.510  -3.599  1.00  0.00           H  
ATOM    279  HG2 MET A  30       3.173   4.577  -3.899  1.00  0.00           H  
ATOM    280  HG3 MET A  30       3.224   4.903  -2.171  1.00  0.00           H  
ATOM    281  HE1 MET A  30       3.080   1.324  -0.598  1.00  0.00           H  
ATOM    282  HE2 MET A  30       1.851   2.586  -0.622  1.00  0.00           H  
ATOM    283  HE3 MET A  30       3.541   3.005  -0.331  1.00  0.00           H  
ATOM    284  N   LEU A  31       1.412   6.448   0.185  1.00  0.00           N  
ATOM    285  CA  LEU A  31       1.709   7.770   0.799  1.00  0.00           C  
ATOM    286  C   LEU A  31       3.145   8.245   0.485  1.00  0.00           C  
ATOM    287  O   LEU A  31       3.527   9.360   0.864  1.00  0.00           O  
ATOM    288  CB  LEU A  31       1.416   7.752   2.339  1.00  0.00           C  
ATOM    289  CG  LEU A  31       2.256   6.771   3.240  1.00  0.00           C  
ATOM    290  CD1 LEU A  31       3.644   7.337   3.634  1.00  0.00           C  
ATOM    291  CD2 LEU A  31       1.471   6.340   4.501  1.00  0.00           C  
ATOM    292  H   LEU A  31       1.590   5.633   0.706  1.00  0.00           H  
ATOM    293  HA  LEU A  31       1.034   8.491   0.348  1.00  0.00           H  
ATOM    294  HB2 LEU A  31       1.554   8.761   2.722  1.00  0.00           H  
ATOM    295  HB3 LEU A  31       0.366   7.503   2.460  1.00  0.00           H  
ATOM    296  HG  LEU A  31       2.443   5.872   2.669  1.00  0.00           H  
ATOM    297 HD11 LEU A  31       4.222   7.527   2.740  1.00  0.00           H  
ATOM    298 HD12 LEU A  31       4.171   6.617   4.247  1.00  0.00           H  
ATOM    299 HD13 LEU A  31       3.522   8.260   4.187  1.00  0.00           H  
ATOM    300 HD21 LEU A  31       1.240   7.208   5.108  1.00  0.00           H  
ATOM    301 HD22 LEU A  31       2.066   5.645   5.082  1.00  0.00           H  
ATOM    302 HD23 LEU A  31       0.552   5.855   4.206  1.00  0.00           H  
ATOM    303  N   ASP A  32       3.929   7.402  -0.204  1.00  0.00           N  
ATOM    304  CA  ASP A  32       5.327   7.713  -0.576  1.00  0.00           C  
ATOM    305  C   ASP A  32       5.588   7.190  -1.991  1.00  0.00           C  
ATOM    306  O   ASP A  32       4.932   6.252  -2.419  1.00  0.00           O  
ATOM    307  CB  ASP A  32       6.306   7.058   0.435  1.00  0.00           C  
ATOM    308  CG  ASP A  32       7.718   7.666   0.395  1.00  0.00           C  
ATOM    309  OD1 ASP A  32       8.520   7.286  -0.479  1.00  0.00           O  
ATOM    310  OD2 ASP A  32       8.026   8.542   1.236  1.00  0.00           O  
ATOM    311  H   ASP A  32       3.558   6.540  -0.488  1.00  0.00           H  
ATOM    312  HA  ASP A  32       5.458   8.793  -0.569  1.00  0.00           H  
ATOM    313  HB2 ASP A  32       5.905   7.172   1.437  1.00  0.00           H  
ATOM    314  HB3 ASP A  32       6.383   5.998   0.222  1.00  0.00           H  
ATOM    315  N   ASP A  33       6.543   7.792  -2.716  1.00  0.00           N  
ATOM    316  CA  ASP A  33       6.852   7.371  -4.099  1.00  0.00           C  
ATOM    317  C   ASP A  33       7.651   6.060  -4.087  1.00  0.00           C  
ATOM    318  O   ASP A  33       8.670   5.935  -3.395  1.00  0.00           O  
ATOM    319  CB  ASP A  33       7.591   8.484  -4.893  1.00  0.00           C  
ATOM    320  CG  ASP A  33       8.907   8.950  -4.255  1.00  0.00           C  
ATOM    321  OD1 ASP A  33       8.855   9.750  -3.296  1.00  0.00           O  
ATOM    322  OD2 ASP A  33       9.998   8.522  -4.701  1.00  0.00           O  
ATOM    323  H   ASP A  33       7.078   8.499  -2.298  1.00  0.00           H  
ATOM    324  HA  ASP A  33       5.895   7.186  -4.593  1.00  0.00           H  
ATOM    325  HB2 ASP A  33       7.798   8.124  -5.900  1.00  0.00           H  
ATOM    326  HB3 ASP A  33       6.932   9.342  -4.975  1.00  0.00           H  
ATOM    327  N   TYR A  34       7.152   5.076  -4.840  1.00  0.00           N  
ATOM    328  CA  TYR A  34       7.751   3.736  -4.936  1.00  0.00           C  
ATOM    329  C   TYR A  34       8.438   3.536  -6.293  1.00  0.00           C  
ATOM    330  O   TYR A  34       8.341   4.382  -7.190  1.00  0.00           O  
ATOM    331  CB  TYR A  34       6.687   2.620  -4.644  1.00  0.00           C  
ATOM    332  CG  TYR A  34       6.905   1.918  -3.309  1.00  0.00           C  
ATOM    333  CD1 TYR A  34       6.569   2.543  -2.105  1.00  0.00           C  
ATOM    334  CD2 TYR A  34       7.478   0.642  -3.247  1.00  0.00           C  
ATOM    335  CE1 TYR A  34       6.792   1.922  -0.899  1.00  0.00           C  
ATOM    336  CE2 TYR A  34       7.695   0.019  -2.041  1.00  0.00           C  
ATOM    337  CZ  TYR A  34       7.357   0.663  -0.871  1.00  0.00           C  
ATOM    338  OH  TYR A  34       7.584   0.044   0.332  1.00  0.00           O  
ATOM    339  H   TYR A  34       6.343   5.264  -5.365  1.00  0.00           H  
ATOM    340  HA  TYR A  34       8.535   3.674  -4.175  1.00  0.00           H  
ATOM    341  HB2 TYR A  34       5.693   3.057  -4.623  1.00  0.00           H  
ATOM    342  HB3 TYR A  34       6.705   1.865  -5.429  1.00  0.00           H  
ATOM    343  HD1 TYR A  34       6.127   3.534  -2.125  1.00  0.00           H  
ATOM    344  HD2 TYR A  34       7.746   0.137  -4.168  1.00  0.00           H  
ATOM    345  HE1 TYR A  34       6.525   2.422   0.024  1.00  0.00           H  
ATOM    346  HE2 TYR A  34       8.138  -0.968  -2.015  1.00  0.00           H  
ATOM    347  HH  TYR A  34       8.458  -0.359   0.318  1.00  0.00           H  
ATOM    348  N   GLU A  35       9.140   2.394  -6.392  1.00  0.00           N  
ATOM    349  CA  GLU A  35      10.025   2.010  -7.526  1.00  0.00           C  
ATOM    350  C   GLU A  35       9.345   2.164  -8.913  1.00  0.00           C  
ATOM    351  O   GLU A  35       9.993   2.536  -9.897  1.00  0.00           O  
ATOM    352  CB  GLU A  35      10.486   0.536  -7.315  1.00  0.00           C  
ATOM    353  CG  GLU A  35      11.015   0.208  -5.889  1.00  0.00           C  
ATOM    354  CD  GLU A  35      12.322   0.929  -5.510  1.00  0.00           C  
ATOM    355  OE1 GLU A  35      12.273   2.081  -5.021  1.00  0.00           O  
ATOM    356  OE2 GLU A  35      13.411   0.339  -5.690  1.00  0.00           O  
ATOM    357  H   GLU A  35       9.065   1.765  -5.643  1.00  0.00           H  
ATOM    358  HA  GLU A  35      10.902   2.653  -7.494  1.00  0.00           H  
ATOM    359  HB2 GLU A  35       9.642  -0.124  -7.512  1.00  0.00           H  
ATOM    360  HB3 GLU A  35      11.273   0.305  -8.030  1.00  0.00           H  
ATOM    361  HG2 GLU A  35      10.248   0.483  -5.169  1.00  0.00           H  
ATOM    362  HG3 GLU A  35      11.170  -0.867  -5.822  1.00  0.00           H  
ATOM    363  N   GLU A  36       8.035   1.875  -8.964  1.00  0.00           N  
ATOM    364  CA  GLU A  36       7.218   1.946 -10.204  1.00  0.00           C  
ATOM    365  C   GLU A  36       5.839   2.565  -9.927  1.00  0.00           C  
ATOM    366  O   GLU A  36       4.985   2.647 -10.820  1.00  0.00           O  
ATOM    367  CB  GLU A  36       7.061   0.520 -10.783  1.00  0.00           C  
ATOM    368  CG  GLU A  36       6.530  -0.522  -9.771  1.00  0.00           C  
ATOM    369  CD  GLU A  36       6.540  -1.951 -10.323  1.00  0.00           C  
ATOM    370  OE1 GLU A  36       7.621  -2.419 -10.744  1.00  0.00           O  
ATOM    371  OE2 GLU A  36       5.484  -2.615 -10.332  1.00  0.00           O  
ATOM    372  H   GLU A  36       7.592   1.595  -8.137  1.00  0.00           H  
ATOM    373  HA  GLU A  36       7.737   2.571 -10.926  1.00  0.00           H  
ATOM    374  HB2 GLU A  36       6.384   0.550 -11.634  1.00  0.00           H  
ATOM    375  HB3 GLU A  36       8.024   0.185 -11.129  1.00  0.00           H  
ATOM    376  HG2 GLU A  36       7.152  -0.498  -8.882  1.00  0.00           H  
ATOM    377  HG3 GLU A  36       5.515  -0.248  -9.492  1.00  0.00           H  
ATOM    378  N   ILE A  37       5.637   2.994  -8.675  1.00  0.00           N  
ATOM    379  CA  ILE A  37       4.346   3.479  -8.159  1.00  0.00           C  
ATOM    380  C   ILE A  37       4.515   4.941  -7.719  1.00  0.00           C  
ATOM    381  O   ILE A  37       5.575   5.316  -7.216  1.00  0.00           O  
ATOM    382  CB  ILE A  37       3.907   2.588  -6.942  1.00  0.00           C  
ATOM    383  CG1 ILE A  37       3.894   1.066  -7.337  1.00  0.00           C  
ATOM    384  CG2 ILE A  37       2.543   3.019  -6.359  1.00  0.00           C  
ATOM    385  CD1 ILE A  37       4.341   0.128  -6.238  1.00  0.00           C  
ATOM    386  H   ILE A  37       6.403   3.016  -8.068  1.00  0.00           H  
ATOM    387  HA  ILE A  37       3.592   3.413  -8.944  1.00  0.00           H  
ATOM    388  HB  ILE A  37       4.642   2.735  -6.162  1.00  0.00           H  
ATOM    389 HG12 ILE A  37       2.889   0.769  -7.614  1.00  0.00           H  
ATOM    390 HG13 ILE A  37       4.548   0.895  -8.187  1.00  0.00           H  
ATOM    391 HG21 ILE A  37       2.591   4.051  -6.027  1.00  0.00           H  
ATOM    392 HG22 ILE A  37       2.292   2.389  -5.514  1.00  0.00           H  
ATOM    393 HG23 ILE A  37       1.772   2.922  -7.114  1.00  0.00           H  
ATOM    394 HD11 ILE A  37       4.292  -0.887  -6.604  1.00  0.00           H  
ATOM    395 HD12 ILE A  37       3.691   0.229  -5.379  1.00  0.00           H  
ATOM    396 HD13 ILE A  37       5.360   0.355  -5.956  1.00  0.00           H  
ATOM    397  N   SER A  38       3.485   5.760  -7.918  1.00  0.00           N  
ATOM    398  CA  SER A  38       3.508   7.179  -7.536  1.00  0.00           C  
ATOM    399  C   SER A  38       2.956   7.374  -6.116  1.00  0.00           C  
ATOM    400  O   SER A  38       2.150   6.565  -5.635  1.00  0.00           O  
ATOM    401  CB  SER A  38       2.665   7.982  -8.544  1.00  0.00           C  
ATOM    402  OG  SER A  38       3.153   7.814  -9.870  1.00  0.00           O  
ATOM    403  H   SER A  38       2.671   5.399  -8.326  1.00  0.00           H  
ATOM    404  HA  SER A  38       4.537   7.534  -7.574  1.00  0.00           H  
ATOM    405  HB2 SER A  38       1.642   7.635  -8.509  1.00  0.00           H  
ATOM    406  HB3 SER A  38       2.698   9.036  -8.296  1.00  0.00           H  
ATOM    407  HG  SER A  38       3.867   7.158  -9.868  1.00  0.00           H  
ATOM    408  N   ALA A  39       3.402   8.452  -5.448  1.00  0.00           N  
ATOM    409  CA  ALA A  39       2.762   8.941  -4.224  1.00  0.00           C  
ATOM    410  C   ALA A  39       1.421   9.581  -4.615  1.00  0.00           C  
ATOM    411  O   ALA A  39       1.390  10.572  -5.357  1.00  0.00           O  
ATOM    412  CB  ALA A  39       3.669   9.947  -3.505  1.00  0.00           C  
ATOM    413  H   ALA A  39       4.183   8.931  -5.795  1.00  0.00           H  
ATOM    414  HA  ALA A  39       2.588   8.092  -3.558  1.00  0.00           H  
ATOM    415  HB1 ALA A  39       4.608   9.471  -3.252  1.00  0.00           H  
ATOM    416  HB2 ALA A  39       3.190  10.292  -2.599  1.00  0.00           H  
ATOM    417  HB3 ALA A  39       3.866  10.796  -4.152  1.00  0.00           H  
ATOM    418  N   GLY A  40       0.329   8.984  -4.129  1.00  0.00           N  
ATOM    419  CA  GLY A  40      -1.028   9.363  -4.525  1.00  0.00           C  
ATOM    420  C   GLY A  40      -1.710   8.286  -5.364  1.00  0.00           C  
ATOM    421  O   GLY A  40      -2.898   8.411  -5.679  1.00  0.00           O  
ATOM    422  H   GLY A  40       0.446   8.259  -3.488  1.00  0.00           H  
ATOM    423  HA2 GLY A  40      -1.613   9.520  -3.630  1.00  0.00           H  
ATOM    424  HA3 GLY A  40      -1.010  10.287  -5.093  1.00  0.00           H  
ATOM    425  N   ASP A  41      -0.957   7.221  -5.720  1.00  0.00           N  
ATOM    426  CA  ASP A  41      -1.505   6.067  -6.466  1.00  0.00           C  
ATOM    427  C   ASP A  41      -2.267   5.137  -5.513  1.00  0.00           C  
ATOM    428  O   ASP A  41      -2.012   5.135  -4.308  1.00  0.00           O  
ATOM    429  CB  ASP A  41      -0.375   5.294  -7.198  1.00  0.00           C  
ATOM    430  CG  ASP A  41      -0.896   4.178  -8.129  1.00  0.00           C  
ATOM    431  OD1 ASP A  41      -1.874   4.425  -8.861  1.00  0.00           O  
ATOM    432  OD2 ASP A  41      -0.315   3.076  -8.165  1.00  0.00           O  
ATOM    433  H   ASP A  41      -0.010   7.207  -5.470  1.00  0.00           H  
ATOM    434  HA  ASP A  41      -2.201   6.451  -7.206  1.00  0.00           H  
ATOM    435  HB2 ASP A  41       0.201   5.993  -7.794  1.00  0.00           H  
ATOM    436  HB3 ASP A  41       0.286   4.852  -6.454  1.00  0.00           H  
ATOM    437  N   GLU A  42      -3.207   4.349  -6.060  1.00  0.00           N  
ATOM    438  CA  GLU A  42      -4.082   3.469  -5.270  1.00  0.00           C  
ATOM    439  C   GLU A  42      -4.088   2.044  -5.835  1.00  0.00           C  
ATOM    440  O   GLU A  42      -3.760   1.816  -7.006  1.00  0.00           O  
ATOM    441  CB  GLU A  42      -5.506   4.060  -5.211  1.00  0.00           C  
ATOM    442  CG  GLU A  42      -5.604   5.367  -4.401  1.00  0.00           C  
ATOM    443  CD  GLU A  42      -7.022   5.932  -4.316  1.00  0.00           C  
ATOM    444  OE1 GLU A  42      -7.878   5.290  -3.681  1.00  0.00           O  
ATOM    445  OE2 GLU A  42      -7.284   7.019  -4.870  1.00  0.00           O  
ATOM    446  H   GLU A  42      -3.303   4.343  -7.036  1.00  0.00           H  
ATOM    447  HA  GLU A  42      -3.688   3.418  -4.252  1.00  0.00           H  
ATOM    448  HB2 GLU A  42      -5.853   4.255  -6.223  1.00  0.00           H  
ATOM    449  HB3 GLU A  42      -6.173   3.332  -4.754  1.00  0.00           H  
ATOM    450  HG2 GLU A  42      -5.254   5.171  -3.390  1.00  0.00           H  
ATOM    451  HG3 GLU A  42      -4.945   6.107  -4.853  1.00  0.00           H  
ATOM    452  N   GLY A  43      -4.461   1.095  -4.966  1.00  0.00           N  
ATOM    453  CA  GLY A  43      -4.374  -0.331  -5.262  1.00  0.00           C  
ATOM    454  C   GLY A  43      -5.446  -1.135  -4.559  1.00  0.00           C  
ATOM    455  O   GLY A  43      -6.395  -0.568  -4.019  1.00  0.00           O  
ATOM    456  H   GLY A  43      -4.812   1.373  -4.099  1.00  0.00           H  
ATOM    457  HA2 GLY A  43      -4.456  -0.506  -6.318  1.00  0.00           H  
ATOM    458  HA3 GLY A  43      -3.407  -0.688  -4.933  1.00  0.00           H  
ATOM    459  N   GLU A  44      -5.278  -2.465  -4.554  1.00  0.00           N  
ATOM    460  CA  GLU A  44      -6.159  -3.387  -3.821  1.00  0.00           C  
ATOM    461  C   GLU A  44      -5.306  -4.418  -3.090  1.00  0.00           C  
ATOM    462  O   GLU A  44      -4.329  -4.915  -3.660  1.00  0.00           O  
ATOM    463  CB  GLU A  44      -7.145  -4.113  -4.772  1.00  0.00           C  
ATOM    464  CG  GLU A  44      -8.095  -5.101  -4.060  1.00  0.00           C  
ATOM    465  CD  GLU A  44      -8.990  -5.896  -5.020  1.00  0.00           C  
ATOM    466  OE1 GLU A  44      -8.511  -6.897  -5.599  1.00  0.00           O  
ATOM    467  OE2 GLU A  44     -10.171  -5.530  -5.195  1.00  0.00           O  
ATOM    468  H   GLU A  44      -4.525  -2.846  -5.054  1.00  0.00           H  
ATOM    469  HA  GLU A  44      -6.728  -2.812  -3.087  1.00  0.00           H  
ATOM    470  HB2 GLU A  44      -7.747  -3.370  -5.283  1.00  0.00           H  
ATOM    471  HB3 GLU A  44      -6.575  -4.664  -5.519  1.00  0.00           H  
ATOM    472  HG2 GLU A  44      -7.495  -5.805  -3.487  1.00  0.00           H  
ATOM    473  HG3 GLU A  44      -8.719  -4.541  -3.366  1.00  0.00           H  
ATOM    474  N   PHE A  45      -5.691  -4.747  -1.846  1.00  0.00           N  
ATOM    475  CA  PHE A  45      -5.036  -5.794  -1.056  1.00  0.00           C  
ATOM    476  C   PHE A  45      -5.341  -7.160  -1.682  1.00  0.00           C  
ATOM    477  O   PHE A  45      -6.502  -7.559  -1.782  1.00  0.00           O  
ATOM    478  CB  PHE A  45      -5.519  -5.722   0.416  1.00  0.00           C  
ATOM    479  CG  PHE A  45      -4.822  -6.695   1.383  1.00  0.00           C  
ATOM    480  CD1 PHE A  45      -5.222  -8.022   1.476  1.00  0.00           C  
ATOM    481  CD2 PHE A  45      -3.806  -6.270   2.228  1.00  0.00           C  
ATOM    482  CE1 PHE A  45      -4.638  -8.888   2.371  1.00  0.00           C  
ATOM    483  CE2 PHE A  45      -3.215  -7.137   3.120  1.00  0.00           C  
ATOM    484  CZ  PHE A  45      -3.637  -8.444   3.194  1.00  0.00           C  
ATOM    485  H   PHE A  45      -6.447  -4.271  -1.452  1.00  0.00           H  
ATOM    486  HA  PHE A  45      -3.966  -5.615  -1.083  1.00  0.00           H  
ATOM    487  HB2 PHE A  45      -5.358  -4.714   0.785  1.00  0.00           H  
ATOM    488  HB3 PHE A  45      -6.586  -5.925   0.449  1.00  0.00           H  
ATOM    489  HD1 PHE A  45      -6.006  -8.377   0.828  1.00  0.00           H  
ATOM    490  HD2 PHE A  45      -3.466  -5.245   2.177  1.00  0.00           H  
ATOM    491  HE1 PHE A  45      -4.967  -9.917   2.423  1.00  0.00           H  
ATOM    492  HE2 PHE A  45      -2.423  -6.788   3.772  1.00  0.00           H  
ATOM    493  HZ  PHE A  45      -3.177  -9.122   3.898  1.00  0.00           H  
ATOM    494  N   ARG A  46      -4.280  -7.863  -2.098  1.00  0.00           N  
ATOM    495  CA  ARG A  46      -4.382  -9.165  -2.777  1.00  0.00           C  
ATOM    496  C   ARG A  46      -4.021 -10.275  -1.783  1.00  0.00           C  
ATOM    497  O   ARG A  46      -4.728 -11.277  -1.670  1.00  0.00           O  
ATOM    498  CB  ARG A  46      -3.420  -9.177  -3.997  1.00  0.00           C  
ATOM    499  CG  ARG A  46      -3.465  -7.896  -4.856  1.00  0.00           C  
ATOM    500  CD  ARG A  46      -4.799  -7.694  -5.594  1.00  0.00           C  
ATOM    501  NE  ARG A  46      -4.901  -8.586  -6.762  1.00  0.00           N  
ATOM    502  CZ  ARG A  46      -5.766  -8.459  -7.779  1.00  0.00           C  
ATOM    503  NH1 ARG A  46      -6.738  -7.564  -7.742  1.00  0.00           N  
ATOM    504  NH2 ARG A  46      -5.663  -9.258  -8.830  1.00  0.00           N  
ATOM    505  H   ARG A  46      -3.388  -7.492  -1.942  1.00  0.00           H  
ATOM    506  HA  ARG A  46      -5.404  -9.311  -3.120  1.00  0.00           H  
ATOM    507  HB2 ARG A  46      -2.404  -9.297  -3.637  1.00  0.00           H  
ATOM    508  HB3 ARG A  46      -3.663 -10.026  -4.631  1.00  0.00           H  
ATOM    509  HG2 ARG A  46      -3.292  -7.037  -4.209  1.00  0.00           H  
ATOM    510  HG3 ARG A  46      -2.664  -7.940  -5.589  1.00  0.00           H  
ATOM    511  HD2 ARG A  46      -5.621  -7.891  -4.915  1.00  0.00           H  
ATOM    512  HD3 ARG A  46      -4.853  -6.660  -5.926  1.00  0.00           H  
ATOM    513  HE  ARG A  46      -4.247  -9.317  -6.806  1.00  0.00           H  
ATOM    514 HH11 ARG A  46      -6.855  -6.974  -6.939  1.00  0.00           H  
ATOM    515 HH12 ARG A  46      -7.374  -7.474  -8.514  1.00  0.00           H  
ATOM    516 HH21 ARG A  46      -4.949  -9.964  -8.863  1.00  0.00           H  
ATOM    517 HH22 ARG A  46      -6.307  -9.168  -9.596  1.00  0.00           H  
ATOM    518  N   GLN A  47      -2.902 -10.049  -1.069  1.00  0.00           N  
ATOM    519  CA  GLN A  47      -2.393 -10.931  -0.001  1.00  0.00           C  
ATOM    520  C   GLN A  47      -1.212 -10.236   0.700  1.00  0.00           C  
ATOM    521  O   GLN A  47      -0.547  -9.370   0.106  1.00  0.00           O  
ATOM    522  CB  GLN A  47      -1.936 -12.334  -0.539  1.00  0.00           C  
ATOM    523  CG  GLN A  47      -0.656 -12.339  -1.426  1.00  0.00           C  
ATOM    524  CD  GLN A  47      -0.825 -11.634  -2.777  1.00  0.00           C  
ATOM    525  OE1 GLN A  47      -1.167 -12.257  -3.780  1.00  0.00           O  
ATOM    526  NE2 GLN A  47      -0.634 -10.320  -2.797  1.00  0.00           N  
ATOM    527  H   GLN A  47      -2.382  -9.242  -1.276  1.00  0.00           H  
ATOM    528  HA  GLN A  47      -3.195 -11.066   0.721  1.00  0.00           H  
ATOM    529  HB2 GLN A  47      -1.756 -12.987   0.312  1.00  0.00           H  
ATOM    530  HB3 GLN A  47      -2.749 -12.756  -1.119  1.00  0.00           H  
ATOM    531  HG2 GLN A  47       0.147 -11.851  -0.884  1.00  0.00           H  
ATOM    532  HG3 GLN A  47      -0.365 -13.371  -1.611  1.00  0.00           H  
ATOM    533 HE21 GLN A  47      -0.397  -9.866  -1.956  1.00  0.00           H  
ATOM    534 HE22 GLN A  47      -0.731  -9.847  -3.651  1.00  0.00           H  
ATOM    535  N   SER A  48      -0.943 -10.636   1.943  1.00  0.00           N  
ATOM    536  CA  SER A  48       0.195 -10.134   2.729  1.00  0.00           C  
ATOM    537  C   SER A  48       1.022 -11.297   3.266  1.00  0.00           C  
ATOM    538  O   SER A  48       0.700 -12.474   3.048  1.00  0.00           O  
ATOM    539  CB  SER A  48      -0.317  -9.275   3.900  1.00  0.00           C  
ATOM    540  OG  SER A  48      -1.201 -10.006   4.740  1.00  0.00           O  
ATOM    541  H   SER A  48      -1.533 -11.297   2.363  1.00  0.00           H  
ATOM    542  HA  SER A  48       0.828  -9.524   2.089  1.00  0.00           H  
ATOM    543  HB2 SER A  48       0.517  -8.925   4.496  1.00  0.00           H  
ATOM    544  HB3 SER A  48      -0.850  -8.416   3.509  1.00  0.00           H  
ATOM    545  HG  SER A  48      -0.965  -9.857   5.661  1.00  0.00           H  
ATOM    546  N   ASN A  49       2.105 -10.943   3.964  1.00  0.00           N  
ATOM    547  CA  ASN A  49       2.912 -11.888   4.740  1.00  0.00           C  
ATOM    548  C   ASN A  49       2.850 -11.450   6.212  1.00  0.00           C  
ATOM    549  O   ASN A  49       2.940 -10.249   6.501  1.00  0.00           O  
ATOM    550  CB  ASN A  49       4.369 -11.911   4.222  1.00  0.00           C  
ATOM    551  CG  ASN A  49       4.483 -12.223   2.726  1.00  0.00           C  
ATOM    552  OD1 ASN A  49       4.540 -13.380   2.325  1.00  0.00           O  
ATOM    553  ND2 ASN A  49       4.525 -11.187   1.893  1.00  0.00           N  
ATOM    554  H   ASN A  49       2.373  -9.996   3.965  1.00  0.00           H  
ATOM    555  HA  ASN A  49       2.479 -12.886   4.646  1.00  0.00           H  
ATOM    556  HB2 ASN A  49       4.829 -10.945   4.402  1.00  0.00           H  
ATOM    557  HB3 ASN A  49       4.927 -12.664   4.770  1.00  0.00           H  
ATOM    558 HD21 ASN A  49       4.484 -10.283   2.276  1.00  0.00           H  
ATOM    559 HD22 ASN A  49       4.598 -11.365   0.931  1.00  0.00           H  
ATOM    560  N   ASN A  50       2.669 -12.418   7.129  1.00  0.00           N  
ATOM    561  CA  ASN A  50       2.490 -12.144   8.577  1.00  0.00           C  
ATOM    562  C   ASN A  50       3.784 -11.592   9.194  1.00  0.00           C  
ATOM    563  O   ASN A  50       3.781 -10.538   9.842  1.00  0.00           O  
ATOM    564  CB  ASN A  50       2.053 -13.426   9.339  1.00  0.00           C  
ATOM    565  CG  ASN A  50       0.692 -13.968   8.898  1.00  0.00           C  
ATOM    566  OD1 ASN A  50      -0.350 -13.566   9.419  1.00  0.00           O  
ATOM    567  ND2 ASN A  50       0.692 -14.891   7.948  1.00  0.00           N  
ATOM    568  H   ASN A  50       2.659 -13.349   6.827  1.00  0.00           H  
ATOM    569  HA  ASN A  50       1.713 -11.399   8.679  1.00  0.00           H  
ATOM    570  HB2 ASN A  50       2.796 -14.203   9.184  1.00  0.00           H  
ATOM    571  HB3 ASN A  50       2.003 -13.211  10.403  1.00  0.00           H  
ATOM    572 HD21 ASN A  50       1.553 -15.175   7.579  1.00  0.00           H  
ATOM    573 HD22 ASN A  50      -0.170 -15.254   7.658  1.00  0.00           H  
ATOM    574  N   GLY A  51       4.882 -12.330   8.974  1.00  0.00           N  
ATOM    575  CA  GLY A  51       6.188 -11.995   9.535  1.00  0.00           C  
ATOM    576  C   GLY A  51       7.019 -11.095   8.631  1.00  0.00           C  
ATOM    577  O   GLY A  51       7.928 -10.413   9.107  1.00  0.00           O  
ATOM    578  H   GLY A  51       4.798 -13.124   8.406  1.00  0.00           H  
ATOM    579  HA2 GLY A  51       6.057 -11.505  10.496  1.00  0.00           H  
ATOM    580  HA3 GLY A  51       6.730 -12.915   9.696  1.00  0.00           H  
ATOM    581  N   ILE A  52       6.728 -11.108   7.319  1.00  0.00           N  
ATOM    582  CA  ILE A  52       7.492 -10.328   6.322  1.00  0.00           C  
ATOM    583  C   ILE A  52       6.673  -9.062   5.965  1.00  0.00           C  
ATOM    584  O   ILE A  52       5.581  -9.188   5.405  1.00  0.00           O  
ATOM    585  CB  ILE A  52       7.789 -11.167   5.010  1.00  0.00           C  
ATOM    586  CG1 ILE A  52       8.095 -12.672   5.322  1.00  0.00           C  
ATOM    587  CG2 ILE A  52       8.953 -10.550   4.199  1.00  0.00           C  
ATOM    588  CD1 ILE A  52       9.333 -12.931   6.173  1.00  0.00           C  
ATOM    589  H   ILE A  52       5.971 -11.647   7.008  1.00  0.00           H  
ATOM    590  HA  ILE A  52       8.443 -10.035   6.767  1.00  0.00           H  
ATOM    591  HB  ILE A  52       6.899 -11.116   4.387  1.00  0.00           H  
ATOM    592 HG12 ILE A  52       7.252 -13.099   5.849  1.00  0.00           H  
ATOM    593 HG13 ILE A  52       8.222 -13.208   4.389  1.00  0.00           H  
ATOM    594 HG21 ILE A  52       9.851 -10.532   4.805  1.00  0.00           H  
ATOM    595 HG22 ILE A  52       8.702  -9.543   3.908  1.00  0.00           H  
ATOM    596 HG23 ILE A  52       9.135 -11.141   3.311  1.00  0.00           H  
ATOM    597 HD11 ILE A  52       9.449 -13.996   6.318  1.00  0.00           H  
ATOM    598 HD12 ILE A  52       9.222 -12.450   7.136  1.00  0.00           H  
ATOM    599 HD13 ILE A  52      10.208 -12.541   5.674  1.00  0.00           H  
ATOM    600  N   PRO A  53       7.163  -7.829   6.308  1.00  0.00           N  
ATOM    601  CA  PRO A  53       6.390  -6.574   6.102  1.00  0.00           C  
ATOM    602  C   PRO A  53       5.945  -6.201   4.636  1.00  0.00           C  
ATOM    603  O   PRO A  53       4.888  -5.566   4.504  1.00  0.00           O  
ATOM    604  CB  PRO A  53       7.290  -5.473   6.732  1.00  0.00           C  
ATOM    605  CG  PRO A  53       8.664  -6.072   6.796  1.00  0.00           C  
ATOM    606  CD  PRO A  53       8.455  -7.558   7.001  1.00  0.00           C  
ATOM    607  HA  PRO A  53       5.482  -6.649   6.683  1.00  0.00           H  
ATOM    608  HB2 PRO A  53       7.275  -4.574   6.119  1.00  0.00           H  
ATOM    609  HB3 PRO A  53       6.922  -5.226   7.724  1.00  0.00           H  
ATOM    610  HG2 PRO A  53       9.193  -5.888   5.859  1.00  0.00           H  
ATOM    611  HG3 PRO A  53       9.221  -5.647   7.624  1.00  0.00           H  
ATOM    612  HD2 PRO A  53       9.267  -8.122   6.553  1.00  0.00           H  
ATOM    613  HD3 PRO A  53       8.378  -7.792   8.058  1.00  0.00           H  
ATOM    614  N   PRO A  54       6.702  -6.501   3.516  1.00  0.00           N  
ATOM    615  CA  PRO A  54       6.201  -6.217   2.149  1.00  0.00           C  
ATOM    616  C   PRO A  54       4.901  -6.999   1.818  1.00  0.00           C  
ATOM    617  O   PRO A  54       4.904  -8.232   1.700  1.00  0.00           O  
ATOM    618  CB  PRO A  54       7.385  -6.604   1.222  1.00  0.00           C  
ATOM    619  CG  PRO A  54       8.216  -7.531   2.045  1.00  0.00           C  
ATOM    620  CD  PRO A  54       8.083  -7.029   3.461  1.00  0.00           C  
ATOM    621  HA  PRO A  54       6.001  -5.152   2.040  1.00  0.00           H  
ATOM    622  HB2 PRO A  54       7.026  -7.083   0.314  1.00  0.00           H  
ATOM    623  HB3 PRO A  54       7.945  -5.713   0.952  1.00  0.00           H  
ATOM    624  HG2 PRO A  54       7.835  -8.546   1.963  1.00  0.00           H  
ATOM    625  HG3 PRO A  54       9.250  -7.498   1.728  1.00  0.00           H  
ATOM    626  HD2 PRO A  54       8.217  -7.837   4.172  1.00  0.00           H  
ATOM    627  HD3 PRO A  54       8.792  -6.237   3.672  1.00  0.00           H  
ATOM    628  N   VAL A  55       3.785  -6.256   1.773  1.00  0.00           N  
ATOM    629  CA  VAL A  55       2.486  -6.738   1.263  1.00  0.00           C  
ATOM    630  C   VAL A  55       2.399  -6.474  -0.253  1.00  0.00           C  
ATOM    631  O   VAL A  55       2.804  -5.408  -0.733  1.00  0.00           O  
ATOM    632  CB  VAL A  55       1.268  -6.063   2.019  1.00  0.00           C  
ATOM    633  CG1 VAL A  55       1.447  -4.529   2.152  1.00  0.00           C  
ATOM    634  CG2 VAL A  55      -0.093  -6.398   1.343  1.00  0.00           C  
ATOM    635  H   VAL A  55       3.837  -5.336   2.111  1.00  0.00           H  
ATOM    636  HA  VAL A  55       2.438  -7.812   1.435  1.00  0.00           H  
ATOM    637  HB  VAL A  55       1.243  -6.477   3.029  1.00  0.00           H  
ATOM    638 HG11 VAL A  55       2.362  -4.318   2.694  1.00  0.00           H  
ATOM    639 HG12 VAL A  55       0.611  -4.103   2.692  1.00  0.00           H  
ATOM    640 HG13 VAL A  55       1.505  -4.082   1.167  1.00  0.00           H  
ATOM    641 HG21 VAL A  55      -0.204  -7.477   1.248  1.00  0.00           H  
ATOM    642 HG22 VAL A  55      -0.130  -5.955   0.356  1.00  0.00           H  
ATOM    643 HG23 VAL A  55      -0.909  -6.011   1.939  1.00  0.00           H  
ATOM    644  N   GLN A  56       1.901  -7.475  -1.001  1.00  0.00           N  
ATOM    645  CA  GLN A  56       1.698  -7.364  -2.449  1.00  0.00           C  
ATOM    646  C   GLN A  56       0.270  -6.832  -2.711  1.00  0.00           C  
ATOM    647  O   GLN A  56      -0.726  -7.428  -2.270  1.00  0.00           O  
ATOM    648  CB  GLN A  56       1.932  -8.723  -3.172  1.00  0.00           C  
ATOM    649  CG  GLN A  56       3.361  -9.305  -3.130  1.00  0.00           C  
ATOM    650  CD  GLN A  56       3.848  -9.687  -1.722  1.00  0.00           C  
ATOM    651  OE1 GLN A  56       3.619 -10.796  -1.246  1.00  0.00           O  
ATOM    652  NE2 GLN A  56       4.517  -8.769  -1.048  1.00  0.00           N  
ATOM    653  H   GLN A  56       1.647  -8.310  -0.554  1.00  0.00           H  
ATOM    654  HA  GLN A  56       2.423  -6.645  -2.833  1.00  0.00           H  
ATOM    655  HB2 GLN A  56       1.267  -9.458  -2.745  1.00  0.00           H  
ATOM    656  HB3 GLN A  56       1.657  -8.602  -4.217  1.00  0.00           H  
ATOM    657  HG2 GLN A  56       3.386 -10.199  -3.746  1.00  0.00           H  
ATOM    658  HG3 GLN A  56       4.045  -8.576  -3.555  1.00  0.00           H  
ATOM    659 HE21 GLN A  56       4.664  -7.897  -1.472  1.00  0.00           H  
ATOM    660 HE22 GLN A  56       4.850  -9.002  -0.158  1.00  0.00           H  
ATOM    661  N   VAL A  57       0.202  -5.711  -3.439  1.00  0.00           N  
ATOM    662  CA  VAL A  57      -1.040  -4.961  -3.726  1.00  0.00           C  
ATOM    663  C   VAL A  57      -1.028  -4.546  -5.195  1.00  0.00           C  
ATOM    664  O   VAL A  57       0.013  -4.129  -5.702  1.00  0.00           O  
ATOM    665  CB  VAL A  57      -1.181  -3.682  -2.793  1.00  0.00           C  
ATOM    666  CG1 VAL A  57      -2.031  -3.979  -1.549  1.00  0.00           C  
ATOM    667  CG2 VAL A  57       0.202  -3.146  -2.368  1.00  0.00           C  
ATOM    668  H   VAL A  57       1.038  -5.364  -3.822  1.00  0.00           H  
ATOM    669  HA  VAL A  57      -1.898  -5.623  -3.561  1.00  0.00           H  
ATOM    670  HB  VAL A  57      -1.686  -2.892  -3.350  1.00  0.00           H  
ATOM    671 HG11 VAL A  57      -3.050  -4.187  -1.864  1.00  0.00           H  
ATOM    672 HG12 VAL A  57      -2.039  -3.118  -0.894  1.00  0.00           H  
ATOM    673 HG13 VAL A  57      -1.634  -4.839  -1.024  1.00  0.00           H  
ATOM    674 HG21 VAL A  57       0.081  -2.236  -1.787  1.00  0.00           H  
ATOM    675 HG22 VAL A  57       0.790  -2.921  -3.251  1.00  0.00           H  
ATOM    676 HG23 VAL A  57       0.723  -3.885  -1.773  1.00  0.00           H  
ATOM    677  N   PHE A  58      -2.177  -4.695  -5.878  1.00  0.00           N  
ATOM    678  CA  PHE A  58      -2.288  -4.422  -7.322  1.00  0.00           C  
ATOM    679  C   PHE A  58      -2.489  -2.918  -7.543  1.00  0.00           C  
ATOM    680  O   PHE A  58      -3.585  -2.401  -7.320  1.00  0.00           O  
ATOM    681  CB  PHE A  58      -3.466  -5.242  -7.916  1.00  0.00           C  
ATOM    682  CG  PHE A  58      -3.581  -5.206  -9.441  1.00  0.00           C  
ATOM    683  CD1 PHE A  58      -2.916  -6.143 -10.228  1.00  0.00           C  
ATOM    684  CD2 PHE A  58      -4.363  -4.243 -10.086  1.00  0.00           C  
ATOM    685  CE1 PHE A  58      -3.027  -6.120 -11.602  1.00  0.00           C  
ATOM    686  CE2 PHE A  58      -4.473  -4.222 -11.460  1.00  0.00           C  
ATOM    687  CZ  PHE A  58      -3.805  -5.161 -12.218  1.00  0.00           C  
ATOM    688  H   PHE A  58      -2.974  -4.988  -5.392  1.00  0.00           H  
ATOM    689  HA  PHE A  58      -1.362  -4.739  -7.804  1.00  0.00           H  
ATOM    690  HB2 PHE A  58      -3.354  -6.280  -7.622  1.00  0.00           H  
ATOM    691  HB3 PHE A  58      -4.400  -4.875  -7.501  1.00  0.00           H  
ATOM    692  HD1 PHE A  58      -2.301  -6.898  -9.755  1.00  0.00           H  
ATOM    693  HD2 PHE A  58      -4.888  -3.503  -9.492  1.00  0.00           H  
ATOM    694  HE1 PHE A  58      -2.502  -6.856 -12.199  1.00  0.00           H  
ATOM    695  HE2 PHE A  58      -5.083  -3.469 -11.943  1.00  0.00           H  
ATOM    696  HZ  PHE A  58      -3.892  -5.146 -13.296  1.00  0.00           H  
ATOM    697  N   TRP A  59      -1.429  -2.246  -8.007  1.00  0.00           N  
ATOM    698  CA  TRP A  59      -1.404  -0.787  -8.219  1.00  0.00           C  
ATOM    699  C   TRP A  59      -1.860  -0.447  -9.632  1.00  0.00           C  
ATOM    700  O   TRP A  59      -1.365  -1.036 -10.600  1.00  0.00           O  
ATOM    701  CB  TRP A  59       0.015  -0.248  -7.963  1.00  0.00           C  
ATOM    702  CG  TRP A  59       0.475  -0.471  -6.553  1.00  0.00           C  
ATOM    703  CD1 TRP A  59       1.310  -1.447  -6.100  1.00  0.00           C  
ATOM    704  CD2 TRP A  59       0.081   0.286  -5.405  1.00  0.00           C  
ATOM    705  NE1 TRP A  59       1.484  -1.324  -4.753  1.00  0.00           N  
ATOM    706  CE2 TRP A  59       0.731  -0.266  -4.301  1.00  0.00           C  
ATOM    707  CE3 TRP A  59      -0.755   1.385  -5.215  1.00  0.00           C  
ATOM    708  CZ2 TRP A  59       0.567   0.243  -3.013  1.00  0.00           C  
ATOM    709  CZ3 TRP A  59      -0.919   1.887  -3.944  1.00  0.00           C  
ATOM    710  CH2 TRP A  59      -0.261   1.316  -2.855  1.00  0.00           C  
ATOM    711  H   TRP A  59      -0.620  -2.752  -8.211  1.00  0.00           H  
ATOM    712  HA  TRP A  59      -2.084  -0.324  -7.504  1.00  0.00           H  
ATOM    713  HB2 TRP A  59       0.714  -0.739  -8.629  1.00  0.00           H  
ATOM    714  HB3 TRP A  59       0.040   0.820  -8.157  1.00  0.00           H  
ATOM    715  HD1 TRP A  59       1.775  -2.194  -6.730  1.00  0.00           H  
ATOM    716  HE1 TRP A  59       2.047  -1.906  -4.202  1.00  0.00           H  
ATOM    717  HE3 TRP A  59      -1.275   1.843  -6.050  1.00  0.00           H  
ATOM    718  HZ2 TRP A  59       1.073  -0.191  -2.159  1.00  0.00           H  
ATOM    719  HZ3 TRP A  59      -1.571   2.736  -3.785  1.00  0.00           H  
ATOM    720  HH2 TRP A  59      -0.420   1.743  -1.870  1.00  0.00           H  
ATOM    721  N   GLN A  60      -2.800   0.505  -9.737  1.00  0.00           N  
ATOM    722  CA  GLN A  60      -3.438   0.866 -11.010  1.00  0.00           C  
ATOM    723  C   GLN A  60      -2.477   1.602 -11.973  1.00  0.00           C  
ATOM    724  O   GLN A  60      -2.617   1.463 -13.192  1.00  0.00           O  
ATOM    725  CB  GLN A  60      -4.729   1.699 -10.766  1.00  0.00           C  
ATOM    726  CG  GLN A  60      -4.516   3.015 -10.001  1.00  0.00           C  
ATOM    727  CD  GLN A  60      -5.749   3.906  -9.969  1.00  0.00           C  
ATOM    728  OE1 GLN A  60      -6.582   3.819  -9.069  1.00  0.00           O  
ATOM    729  NE2 GLN A  60      -5.880   4.756 -10.970  1.00  0.00           N  
ATOM    730  H   GLN A  60      -3.065   0.991  -8.925  1.00  0.00           H  
ATOM    731  HA  GLN A  60      -3.731  -0.064 -11.490  1.00  0.00           H  
ATOM    732  HB2 GLN A  60      -5.182   1.929 -11.725  1.00  0.00           H  
ATOM    733  HB3 GLN A  60      -5.428   1.090 -10.198  1.00  0.00           H  
ATOM    734  HG2 GLN A  60      -4.233   2.784  -8.981  1.00  0.00           H  
ATOM    735  HG3 GLN A  60      -3.703   3.566 -10.465  1.00  0.00           H  
ATOM    736 HE21 GLN A  60      -5.189   4.752 -11.667  1.00  0.00           H  
ATOM    737 HE22 GLN A  60      -6.644   5.360 -10.969  1.00  0.00           H  
ATOM    738  N   SER A  61      -1.509   2.382 -11.432  1.00  0.00           N  
ATOM    739  CA  SER A  61      -0.575   3.173 -12.270  1.00  0.00           C  
ATOM    740  C   SER A  61       0.418   2.265 -13.022  1.00  0.00           C  
ATOM    741  O   SER A  61       0.635   2.434 -14.230  1.00  0.00           O  
ATOM    742  CB  SER A  61       0.197   4.199 -11.414  1.00  0.00           C  
ATOM    743  OG  SER A  61       1.057   5.004 -12.200  1.00  0.00           O  
ATOM    744  H   SER A  61      -1.433   2.441 -10.450  1.00  0.00           H  
ATOM    745  HA  SER A  61      -1.175   3.719 -12.998  1.00  0.00           H  
ATOM    746  HB2 SER A  61      -0.506   4.846 -10.912  1.00  0.00           H  
ATOM    747  HB3 SER A  61       0.788   3.681 -10.670  1.00  0.00           H  
ATOM    748  HG  SER A  61       0.827   5.933 -12.073  1.00  0.00           H  
ATOM    749  N   THR A  62       1.004   1.291 -12.300  1.00  0.00           N  
ATOM    750  CA  THR A  62       1.962   0.331 -12.883  1.00  0.00           C  
ATOM    751  C   THR A  62       1.216  -0.881 -13.502  1.00  0.00           C  
ATOM    752  O   THR A  62       1.778  -1.612 -14.331  1.00  0.00           O  
ATOM    753  CB  THR A  62       3.023  -0.134 -11.826  1.00  0.00           C  
ATOM    754  OG1 THR A  62       3.992  -0.993 -12.442  1.00  0.00           O  
ATOM    755  CG2 THR A  62       2.390  -0.853 -10.623  1.00  0.00           C  
ATOM    756  H   THR A  62       0.786   1.213 -11.349  1.00  0.00           H  
ATOM    757  HA  THR A  62       2.502   0.839 -13.681  1.00  0.00           H  
ATOM    758  HB  THR A  62       3.544   0.747 -11.460  1.00  0.00           H  
ATOM    759  HG1 THR A  62       4.326  -1.617 -11.790  1.00  0.00           H  
ATOM    760 HG21 THR A  62       1.860  -1.735 -10.961  1.00  0.00           H  
ATOM    761 HG22 THR A  62       1.694  -0.189 -10.126  1.00  0.00           H  
ATOM    762 HG23 THR A  62       3.161  -1.148  -9.922  1.00  0.00           H  
ATOM    763  N   GLY A  63      -0.059  -1.067 -13.096  1.00  0.00           N  
ATOM    764  CA  GLY A  63      -0.923  -2.123 -13.641  1.00  0.00           C  
ATOM    765  C   GLY A  63      -0.610  -3.519 -13.120  1.00  0.00           C  
ATOM    766  O   GLY A  63      -0.999  -4.513 -13.751  1.00  0.00           O  
ATOM    767  H   GLY A  63      -0.424  -0.464 -12.415  1.00  0.00           H  
ATOM    768  HA2 GLY A  63      -1.948  -1.889 -13.395  1.00  0.00           H  
ATOM    769  HA3 GLY A  63      -0.822  -2.129 -14.722  1.00  0.00           H  
ATOM    770  N   ARG A  64       0.089  -3.608 -11.970  1.00  0.00           N  
ATOM    771  CA  ARG A  64       0.575  -4.898 -11.434  1.00  0.00           C  
ATOM    772  C   ARG A  64       0.730  -4.871  -9.908  1.00  0.00           C  
ATOM    773  O   ARG A  64       0.755  -3.805  -9.284  1.00  0.00           O  
ATOM    774  CB  ARG A  64       1.907  -5.277 -12.131  1.00  0.00           C  
ATOM    775  CG  ARG A  64       3.029  -4.245 -11.930  1.00  0.00           C  
ATOM    776  CD  ARG A  64       4.264  -4.526 -12.791  1.00  0.00           C  
ATOM    777  NE  ARG A  64       4.854  -5.857 -12.521  1.00  0.00           N  
ATOM    778  CZ  ARG A  64       6.070  -6.087 -12.001  1.00  0.00           C  
ATOM    779  NH1 ARG A  64       6.835  -5.091 -11.569  1.00  0.00           N  
ATOM    780  NH2 ARG A  64       6.501  -7.333 -11.890  1.00  0.00           N  
ATOM    781  H   ARG A  64       0.271  -2.789 -11.463  1.00  0.00           H  
ATOM    782  HA  ARG A  64      -0.168  -5.660 -11.663  1.00  0.00           H  
ATOM    783  HB2 ARG A  64       2.251  -6.238 -11.752  1.00  0.00           H  
ATOM    784  HB3 ARG A  64       1.721  -5.376 -13.196  1.00  0.00           H  
ATOM    785  HG2 ARG A  64       2.649  -3.258 -12.184  1.00  0.00           H  
ATOM    786  HG3 ARG A  64       3.325  -4.246 -10.883  1.00  0.00           H  
ATOM    787  HD2 ARG A  64       3.972  -4.480 -13.836  1.00  0.00           H  
ATOM    788  HD3 ARG A  64       5.003  -3.753 -12.599  1.00  0.00           H  
ATOM    789  HE  ARG A  64       4.310  -6.636 -12.776  1.00  0.00           H  
ATOM    790 HH11 ARG A  64       6.506  -4.137 -11.622  1.00  0.00           H  
ATOM    791 HH12 ARG A  64       7.744  -5.275 -11.193  1.00  0.00           H  
ATOM    792 HH21 ARG A  64       5.921  -8.094 -12.192  1.00  0.00           H  
ATOM    793 HH22 ARG A  64       7.415  -7.522 -11.519  1.00  0.00           H  
ATOM    794  N   THR A  65       0.858  -6.078  -9.340  1.00  0.00           N  
ATOM    795  CA  THR A  65       0.971  -6.307  -7.906  1.00  0.00           C  
ATOM    796  C   THR A  65       2.444  -6.209  -7.475  1.00  0.00           C  
ATOM    797  O   THR A  65       3.288  -6.956  -7.985  1.00  0.00           O  
ATOM    798  CB  THR A  65       0.396  -7.726  -7.571  1.00  0.00           C  
ATOM    799  OG1 THR A  65      -0.757  -7.989  -8.390  1.00  0.00           O  
ATOM    800  CG2 THR A  65      -0.023  -7.829  -6.122  1.00  0.00           C  
ATOM    801  H   THR A  65       0.852  -6.864  -9.916  1.00  0.00           H  
ATOM    802  HA  THR A  65       0.383  -5.553  -7.381  1.00  0.00           H  
ATOM    803  HB  THR A  65       1.152  -8.483  -7.764  1.00  0.00           H  
ATOM    804  HG1 THR A  65      -0.917  -8.938  -8.422  1.00  0.00           H  
ATOM    805 HG21 THR A  65      -0.813  -7.116  -5.933  1.00  0.00           H  
ATOM    806 HG22 THR A  65       0.818  -7.604  -5.481  1.00  0.00           H  
ATOM    807 HG23 THR A  65      -0.380  -8.824  -5.910  1.00  0.00           H  
ATOM    808  N   TYR A  66       2.752  -5.292  -6.541  1.00  0.00           N  
ATOM    809  CA  TYR A  66       4.141  -5.004  -6.139  1.00  0.00           C  
ATOM    810  C   TYR A  66       4.294  -5.020  -4.606  1.00  0.00           C  
ATOM    811  O   TYR A  66       3.324  -4.811  -3.867  1.00  0.00           O  
ATOM    812  CB  TYR A  66       4.569  -3.630  -6.719  1.00  0.00           C  
ATOM    813  CG  TYR A  66       6.090  -3.402  -6.750  1.00  0.00           C  
ATOM    814  CD1 TYR A  66       6.884  -4.102  -7.660  1.00  0.00           C  
ATOM    815  CD2 TYR A  66       6.731  -2.502  -5.890  1.00  0.00           C  
ATOM    816  CE1 TYR A  66       8.248  -3.915  -7.712  1.00  0.00           C  
ATOM    817  CE2 TYR A  66       8.096  -2.314  -5.943  1.00  0.00           C  
ATOM    818  CZ  TYR A  66       8.850  -3.022  -6.857  1.00  0.00           C  
ATOM    819  OH  TYR A  66      10.216  -2.850  -6.903  1.00  0.00           O  
ATOM    820  H   TYR A  66       2.026  -4.781  -6.122  1.00  0.00           H  
ATOM    821  HA  TYR A  66       4.790  -5.780  -6.552  1.00  0.00           H  
ATOM    822  HB2 TYR A  66       4.204  -3.546  -7.737  1.00  0.00           H  
ATOM    823  HB3 TYR A  66       4.118  -2.837  -6.127  1.00  0.00           H  
ATOM    824  HD1 TYR A  66       6.415  -4.805  -8.339  1.00  0.00           H  
ATOM    825  HD2 TYR A  66       6.139  -1.948  -5.168  1.00  0.00           H  
ATOM    826  HE1 TYR A  66       8.840  -4.468  -8.428  1.00  0.00           H  
ATOM    827  HE2 TYR A  66       8.570  -1.610  -5.270  1.00  0.00           H  
ATOM    828  HH  TYR A  66      10.498  -2.768  -7.822  1.00  0.00           H  
ATOM    829  N   TRP A  67       5.545  -5.249  -4.168  1.00  0.00           N  
ATOM    830  CA  TRP A  67       5.932  -5.343  -2.752  1.00  0.00           C  
ATOM    831  C   TRP A  67       6.058  -3.935  -2.141  1.00  0.00           C  
ATOM    832  O   TRP A  67       6.926  -3.160  -2.560  1.00  0.00           O  
ATOM    833  CB  TRP A  67       7.297  -6.088  -2.633  1.00  0.00           C  
ATOM    834  CG  TRP A  67       7.353  -7.432  -3.323  1.00  0.00           C  
ATOM    835  CD1 TRP A  67       7.045  -8.641  -2.781  1.00  0.00           C  
ATOM    836  CD2 TRP A  67       7.768  -7.701  -4.673  1.00  0.00           C  
ATOM    837  NE1 TRP A  67       7.204  -9.630  -3.708  1.00  0.00           N  
ATOM    838  CE2 TRP A  67       7.652  -9.085  -4.875  1.00  0.00           C  
ATOM    839  CE3 TRP A  67       8.211  -6.903  -5.730  1.00  0.00           C  
ATOM    840  CZ2 TRP A  67       7.966  -9.692  -6.088  1.00  0.00           C  
ATOM    841  CZ3 TRP A  67       8.531  -7.502  -6.934  1.00  0.00           C  
ATOM    842  CH2 TRP A  67       8.402  -8.887  -7.108  1.00  0.00           C  
ATOM    843  H   TRP A  67       6.249  -5.354  -4.835  1.00  0.00           H  
ATOM    844  HA  TRP A  67       5.169  -5.907  -2.224  1.00  0.00           H  
ATOM    845  HB2 TRP A  67       8.077  -5.475  -3.067  1.00  0.00           H  
ATOM    846  HB3 TRP A  67       7.526  -6.244  -1.583  1.00  0.00           H  
ATOM    847  HD1 TRP A  67       6.701  -8.783  -1.766  1.00  0.00           H  
ATOM    848  HE1 TRP A  67       7.031 -10.579  -3.553  1.00  0.00           H  
ATOM    849  HE3 TRP A  67       8.317  -5.831  -5.613  1.00  0.00           H  
ATOM    850  HZ2 TRP A  67       7.867 -10.760  -6.237  1.00  0.00           H  
ATOM    851  HZ3 TRP A  67       8.881  -6.896  -7.761  1.00  0.00           H  
ATOM    852  HH2 TRP A  67       8.663  -9.316  -8.067  1.00  0.00           H  
ATOM    853  N   VAL A  68       5.178  -3.597  -1.173  1.00  0.00           N  
ATOM    854  CA  VAL A  68       5.229  -2.298  -0.457  1.00  0.00           C  
ATOM    855  C   VAL A  68       5.198  -2.517   1.065  1.00  0.00           C  
ATOM    856  O   VAL A  68       4.672  -3.520   1.548  1.00  0.00           O  
ATOM    857  CB  VAL A  68       4.067  -1.315  -0.883  1.00  0.00           C  
ATOM    858  CG1 VAL A  68       4.004  -1.132  -2.423  1.00  0.00           C  
ATOM    859  CG2 VAL A  68       2.705  -1.758  -0.308  1.00  0.00           C  
ATOM    860  H   VAL A  68       4.477  -4.236  -0.930  1.00  0.00           H  
ATOM    861  HA  VAL A  68       6.176  -1.817  -0.703  1.00  0.00           H  
ATOM    862  HB  VAL A  68       4.296  -0.334  -0.457  1.00  0.00           H  
ATOM    863 HG11 VAL A  68       4.952  -0.754  -2.787  1.00  0.00           H  
ATOM    864 HG12 VAL A  68       3.222  -0.427  -2.680  1.00  0.00           H  
ATOM    865 HG13 VAL A  68       3.793  -2.084  -2.897  1.00  0.00           H  
ATOM    866 HG21 VAL A  68       1.925  -1.080  -0.635  1.00  0.00           H  
ATOM    867 HG22 VAL A  68       2.749  -1.752   0.777  1.00  0.00           H  
ATOM    868 HG23 VAL A  68       2.473  -2.759  -0.647  1.00  0.00           H  
ATOM    869  N   HIS A  69       5.736  -1.541   1.806  1.00  0.00           N  
ATOM    870  CA  HIS A  69       5.875  -1.608   3.273  1.00  0.00           C  
ATOM    871  C   HIS A  69       4.618  -1.040   3.950  1.00  0.00           C  
ATOM    872  O   HIS A  69       4.025  -0.082   3.439  1.00  0.00           O  
ATOM    873  CB  HIS A  69       7.130  -0.807   3.704  1.00  0.00           C  
ATOM    874  CG  HIS A  69       7.539  -1.007   5.139  1.00  0.00           C  
ATOM    875  ND1 HIS A  69       7.397  -0.041   6.113  1.00  0.00           N  
ATOM    876  CD2 HIS A  69       8.115  -2.065   5.752  1.00  0.00           C  
ATOM    877  CE1 HIS A  69       7.874  -0.498   7.256  1.00  0.00           C  
ATOM    878  NE2 HIS A  69       8.314  -1.720   7.063  1.00  0.00           N  
ATOM    879  H   HIS A  69       6.047  -0.737   1.347  1.00  0.00           H  
ATOM    880  HA  HIS A  69       6.000  -2.651   3.560  1.00  0.00           H  
ATOM    881  HB2 HIS A  69       7.969  -1.107   3.086  1.00  0.00           H  
ATOM    882  HB3 HIS A  69       6.954   0.254   3.550  1.00  0.00           H  
ATOM    883  HD1 HIS A  69       7.042   0.861   5.978  1.00  0.00           H  
ATOM    884  HD2 HIS A  69       8.372  -3.011   5.291  1.00  0.00           H  
ATOM    885  HE1 HIS A  69       7.894   0.043   8.194  1.00  0.00           H  
ATOM    886  HE2 HIS A  69       8.832  -2.240   7.714  1.00  0.00           H  
ATOM    887  N   TRP A  70       4.260  -1.603   5.126  1.00  0.00           N  
ATOM    888  CA  TRP A  70       3.033  -1.232   5.868  1.00  0.00           C  
ATOM    889  C   TRP A  70       3.007   0.259   6.262  1.00  0.00           C  
ATOM    890  O   TRP A  70       1.973   0.906   6.137  1.00  0.00           O  
ATOM    891  CB  TRP A  70       2.861  -2.094   7.140  1.00  0.00           C  
ATOM    892  CG  TRP A  70       2.648  -3.565   6.879  1.00  0.00           C  
ATOM    893  CD1 TRP A  70       3.540  -4.575   7.092  1.00  0.00           C  
ATOM    894  CD2 TRP A  70       1.456  -4.186   6.367  1.00  0.00           C  
ATOM    895  NE1 TRP A  70       2.991  -5.777   6.739  1.00  0.00           N  
ATOM    896  CE2 TRP A  70       1.710  -5.567   6.297  1.00  0.00           C  
ATOM    897  CE3 TRP A  70       0.199  -3.708   5.964  1.00  0.00           C  
ATOM    898  CZ2 TRP A  70       0.763  -6.473   5.840  1.00  0.00           C  
ATOM    899  CZ3 TRP A  70      -0.743  -4.613   5.508  1.00  0.00           C  
ATOM    900  CH2 TRP A  70      -0.457  -5.981   5.453  1.00  0.00           C  
ATOM    901  H   TRP A  70       4.833  -2.304   5.499  1.00  0.00           H  
ATOM    902  HA  TRP A  70       2.191  -1.425   5.208  1.00  0.00           H  
ATOM    903  HB2 TRP A  70       3.738  -1.985   7.764  1.00  0.00           H  
ATOM    904  HB3 TRP A  70       1.998  -1.736   7.697  1.00  0.00           H  
ATOM    905  HD1 TRP A  70       4.543  -4.432   7.473  1.00  0.00           H  
ATOM    906  HE1 TRP A  70       3.450  -6.645   6.795  1.00  0.00           H  
ATOM    907  HE3 TRP A  70      -0.039  -2.653   6.003  1.00  0.00           H  
ATOM    908  HZ2 TRP A  70       0.967  -7.535   5.790  1.00  0.00           H  
ATOM    909  HZ3 TRP A  70      -1.718  -4.264   5.190  1.00  0.00           H  
ATOM    910  HH2 TRP A  70      -1.224  -6.657   5.087  1.00  0.00           H  
ATOM    911  N   HIS A  71       4.149   0.803   6.732  1.00  0.00           N  
ATOM    912  CA  HIS A  71       4.216   2.208   7.210  1.00  0.00           C  
ATOM    913  C   HIS A  71       4.006   3.209   6.048  1.00  0.00           C  
ATOM    914  O   HIS A  71       3.576   4.342   6.269  1.00  0.00           O  
ATOM    915  CB  HIS A  71       5.556   2.485   7.943  1.00  0.00           C  
ATOM    916  CG  HIS A  71       5.564   3.721   8.821  1.00  0.00           C  
ATOM    917  ND1 HIS A  71       6.689   4.154   9.487  1.00  0.00           N  
ATOM    918  CD2 HIS A  71       4.569   4.564   9.198  1.00  0.00           C  
ATOM    919  CE1 HIS A  71       6.380   5.198  10.234  1.00  0.00           C  
ATOM    920  NE2 HIS A  71       5.104   5.465  10.076  1.00  0.00           N  
ATOM    921  H   HIS A  71       4.954   0.247   6.775  1.00  0.00           H  
ATOM    922  HA  HIS A  71       3.401   2.343   7.919  1.00  0.00           H  
ATOM    923  HB2 HIS A  71       5.789   1.643   8.582  1.00  0.00           H  
ATOM    924  HB3 HIS A  71       6.347   2.593   7.216  1.00  0.00           H  
ATOM    925  HD1 HIS A  71       7.588   3.769   9.410  1.00  0.00           H  
ATOM    926  HD2 HIS A  71       3.536   4.524   8.870  1.00  0.00           H  
ATOM    927  HE1 HIS A  71       7.053   5.731  10.887  1.00  0.00           H  
ATOM    928  HE2 HIS A  71       4.656   6.275  10.405  1.00  0.00           H  
ATOM    929  N   MET A  72       4.315   2.771   4.811  1.00  0.00           N  
ATOM    930  CA  MET A  72       4.085   3.580   3.596  1.00  0.00           C  
ATOM    931  C   MET A  72       2.798   3.154   2.865  1.00  0.00           C  
ATOM    932  O   MET A  72       2.416   3.774   1.865  1.00  0.00           O  
ATOM    933  CB  MET A  72       5.330   3.533   2.673  1.00  0.00           C  
ATOM    934  CG  MET A  72       6.535   4.308   3.238  1.00  0.00           C  
ATOM    935  SD  MET A  72       8.002   4.228   2.186  1.00  0.00           S  
ATOM    936  CE  MET A  72       8.416   2.485   2.257  1.00  0.00           C  
ATOM    937  H   MET A  72       4.689   1.873   4.708  1.00  0.00           H  
ATOM    938  HA  MET A  72       3.938   4.612   3.913  1.00  0.00           H  
ATOM    939  HB2 MET A  72       5.626   2.499   2.525  1.00  0.00           H  
ATOM    940  HB3 MET A  72       5.079   3.962   1.705  1.00  0.00           H  
ATOM    941  HG2 MET A  72       6.258   5.348   3.347  1.00  0.00           H  
ATOM    942  HG3 MET A  72       6.785   3.906   4.214  1.00  0.00           H  
ATOM    943  HE1 MET A  72       8.584   2.192   3.282  1.00  0.00           H  
ATOM    944  HE2 MET A  72       9.307   2.307   1.677  1.00  0.00           H  
ATOM    945  HE3 MET A  72       7.598   1.901   1.844  1.00  0.00           H  
ATOM    946  N   LEU A  73       2.121   2.127   3.395  1.00  0.00           N  
ATOM    947  CA  LEU A  73       0.797   1.705   2.927  1.00  0.00           C  
ATOM    948  C   LEU A  73      -0.260   2.431   3.786  1.00  0.00           C  
ATOM    949  O   LEU A  73      -0.279   2.306   5.010  1.00  0.00           O  
ATOM    950  CB  LEU A  73       0.671   0.144   3.014  1.00  0.00           C  
ATOM    951  CG  LEU A  73      -0.492  -0.550   2.213  1.00  0.00           C  
ATOM    952  CD1 LEU A  73      -1.877  -0.346   2.860  1.00  0.00           C  
ATOM    953  CD2 LEU A  73      -0.494  -0.097   0.737  1.00  0.00           C  
ATOM    954  H   LEU A  73       2.519   1.640   4.140  1.00  0.00           H  
ATOM    955  HA  LEU A  73       0.686   2.014   1.888  1.00  0.00           H  
ATOM    956  HB2 LEU A  73       1.603  -0.279   2.661  1.00  0.00           H  
ATOM    957  HB3 LEU A  73       0.567  -0.132   4.060  1.00  0.00           H  
ATOM    958  HG  LEU A  73      -0.310  -1.619   2.214  1.00  0.00           H  
ATOM    959 HD11 LEU A  73      -2.623  -0.902   2.308  1.00  0.00           H  
ATOM    960 HD12 LEU A  73      -2.136   0.707   2.853  1.00  0.00           H  
ATOM    961 HD13 LEU A  73      -1.852  -0.700   3.882  1.00  0.00           H  
ATOM    962 HD21 LEU A  73      -0.691   0.967   0.674  1.00  0.00           H  
ATOM    963 HD22 LEU A  73      -1.260  -0.634   0.192  1.00  0.00           H  
ATOM    964 HD23 LEU A  73       0.467  -0.309   0.292  1.00  0.00           H  
ATOM    965  N   GLU A  74      -1.116   3.195   3.114  1.00  0.00           N  
ATOM    966  CA  GLU A  74      -2.252   3.913   3.714  1.00  0.00           C  
ATOM    967  C   GLU A  74      -3.552   3.336   3.138  1.00  0.00           C  
ATOM    968  O   GLU A  74      -3.537   2.786   2.044  1.00  0.00           O  
ATOM    969  CB  GLU A  74      -2.121   5.435   3.395  1.00  0.00           C  
ATOM    970  CG  GLU A  74      -3.303   6.320   3.851  1.00  0.00           C  
ATOM    971  CD  GLU A  74      -3.055   7.823   3.636  1.00  0.00           C  
ATOM    972  OE1 GLU A  74      -2.960   8.259   2.470  1.00  0.00           O  
ATOM    973  OE2 GLU A  74      -2.934   8.574   4.632  1.00  0.00           O  
ATOM    974  H   GLU A  74      -0.990   3.276   2.154  1.00  0.00           H  
ATOM    975  HA  GLU A  74      -2.240   3.766   4.790  1.00  0.00           H  
ATOM    976  HB2 GLU A  74      -1.224   5.806   3.878  1.00  0.00           H  
ATOM    977  HB3 GLU A  74      -2.000   5.558   2.320  1.00  0.00           H  
ATOM    978  HG2 GLU A  74      -4.191   6.031   3.291  1.00  0.00           H  
ATOM    979  HG3 GLU A  74      -3.487   6.133   4.905  1.00  0.00           H  
ATOM    980  N   ILE A  75      -4.660   3.383   3.889  1.00  0.00           N  
ATOM    981  CA  ILE A  75      -6.004   3.075   3.345  1.00  0.00           C  
ATOM    982  C   ILE A  75      -6.897   4.327   3.357  1.00  0.00           C  
ATOM    983  O   ILE A  75      -7.094   4.954   4.402  1.00  0.00           O  
ATOM    984  CB  ILE A  75      -6.702   1.876   4.094  1.00  0.00           C  
ATOM    985  CG1 ILE A  75      -6.610   2.038   5.648  1.00  0.00           C  
ATOM    986  CG2 ILE A  75      -6.091   0.541   3.620  1.00  0.00           C  
ATOM    987  CD1 ILE A  75      -7.276   0.934   6.447  1.00  0.00           C  
ATOM    988  H   ILE A  75      -4.581   3.652   4.831  1.00  0.00           H  
ATOM    989  HA  ILE A  75      -5.877   2.776   2.298  1.00  0.00           H  
ATOM    990  HB  ILE A  75      -7.752   1.865   3.803  1.00  0.00           H  
ATOM    991 HG12 ILE A  75      -5.568   2.062   5.945  1.00  0.00           H  
ATOM    992 HG13 ILE A  75      -7.074   2.973   5.933  1.00  0.00           H  
ATOM    993 HG21 ILE A  75      -6.585  -0.291   4.110  1.00  0.00           H  
ATOM    994 HG22 ILE A  75      -5.035   0.517   3.861  1.00  0.00           H  
ATOM    995 HG23 ILE A  75      -6.211   0.443   2.547  1.00  0.00           H  
ATOM    996 HD11 ILE A  75      -7.187   1.156   7.501  1.00  0.00           H  
ATOM    997 HD12 ILE A  75      -6.788  -0.013   6.241  1.00  0.00           H  
ATOM    998 HD13 ILE A  75      -8.320   0.868   6.178  1.00  0.00           H  
ATOM    999  N   LEU A  76      -7.411   4.690   2.171  1.00  0.00           N  
ATOM   1000  CA  LEU A  76      -8.395   5.780   1.995  1.00  0.00           C  
ATOM   1001  C   LEU A  76      -9.677   5.228   1.333  1.00  0.00           C  
ATOM   1002  O   LEU A  76     -10.592   5.990   1.014  1.00  0.00           O  
ATOM   1003  CB  LEU A  76      -7.796   6.938   1.139  1.00  0.00           C  
ATOM   1004  CG  LEU A  76      -6.551   7.684   1.729  1.00  0.00           C  
ATOM   1005  CD1 LEU A  76      -6.094   8.830   0.800  1.00  0.00           C  
ATOM   1006  CD2 LEU A  76      -6.820   8.208   3.158  1.00  0.00           C  
ATOM   1007  H   LEU A  76      -7.130   4.192   1.372  1.00  0.00           H  
ATOM   1008  HA  LEU A  76      -8.664   6.167   2.974  1.00  0.00           H  
ATOM   1009  HB2 LEU A  76      -7.513   6.528   0.174  1.00  0.00           H  
ATOM   1010  HB3 LEU A  76      -8.580   7.674   0.969  1.00  0.00           H  
ATOM   1011  HG  LEU A  76      -5.727   6.979   1.795  1.00  0.00           H  
ATOM   1012 HD11 LEU A  76      -5.212   9.303   1.216  1.00  0.00           H  
ATOM   1013 HD12 LEU A  76      -6.881   9.569   0.701  1.00  0.00           H  
ATOM   1014 HD13 LEU A  76      -5.853   8.432  -0.177  1.00  0.00           H  
ATOM   1015 HD21 LEU A  76      -7.048   7.375   3.811  1.00  0.00           H  
ATOM   1016 HD22 LEU A  76      -7.654   8.899   3.150  1.00  0.00           H  
ATOM   1017 HD23 LEU A  76      -5.938   8.715   3.532  1.00  0.00           H  
ATOM   1018  N   GLY A  77      -9.703   3.893   1.117  1.00  0.00           N  
ATOM   1019  CA  GLY A  77     -10.865   3.195   0.564  1.00  0.00           C  
ATOM   1020  C   GLY A  77     -12.053   3.148   1.524  1.00  0.00           C  
ATOM   1021  O   GLY A  77     -13.151   3.606   1.169  1.00  0.00           O  
ATOM   1022  H   GLY A  77      -8.907   3.373   1.338  1.00  0.00           H  
ATOM   1023  HA2 GLY A  77     -11.163   3.679  -0.356  1.00  0.00           H  
ATOM   1024  HA3 GLY A  77     -10.571   2.182   0.333  1.00  0.00           H  
TER    1025      GLY A  77                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
