
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  995),  selected  124 , name 1ob9_A
# Molecule2: number of CA atoms  139 ( 1110),  selected  139 , name T0495_5_143.pdb
# PARAMETERS: 1ob9_A.T0495_5_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L       5           -
LGA    -       -      D       6           -
LGA    -       -      L       7           -
LGA    -       -      Q       8           -
LGA    -       -      P       9           -
LGA    G     6_A      G      10          2.593
LGA    K     7_A      Q      11          2.252
LGA    N     8_A      R      12          2.698
LGA    A     9_A      L      13          2.453
LGA    E    10_A      A      14          1.560
LGA    R    11_A      R      15          2.075
LGA    E    12_A      G      16          2.423
LGA    L    13_A      V      17          1.679
LGA    V    14_A      A      18          1.137
LGA    S    15_A      R      19          1.529
LGA    I    16_A      H      20          1.799
LGA    L    17_A      L      21          1.483
LGA    R    18_A      R      22          1.034
LGA    G    19_A      A      23          1.354
LGA    E    20_A      H      24          2.131
LGA    G    21_A      G      25          1.773
LGA    F    22_A      F      26          0.974
LGA    N    23_A      V      27          0.849
LGA    A    24_A      S      28          1.075
LGA    V    25_A      V      29          0.959
LGA    R    26_A      E      30          0.645
LGA    I    27_A      E      31          1.495
LGA    P    28_A      F      32           #
LGA    T    29_A      -       -           -
LGA    S    30_A      V      33           #
LGA    N    31_A      P      34           -
LGA    S    32_A      A      35           -
LGA    S    33_A      R      36           -
LGA    P    34_A      G      37          2.217
LGA    N    35_A      L      38          2.467
LGA    P    36_A      -       -           -
LGA    L    37_A      R      39          2.587
LGA    P    38_A      V      40          1.106
LGA    D    39_A      D      41          0.833
LGA    I    40_A      V      42          0.670
LGA    F    41_A      M      43          0.510
LGA    A    42_A      G      44          0.290
LGA    T    43_A      L      45          1.783
LGA    K    44_A      G      46          1.569
LGA    G    45_A      P      47          3.510
LGA    -       -      K      48           -
LGA    N    46_A      G      49          4.054
LGA    T    47_A      E      50          2.281
LGA    L    48_A      I      51          1.399
LGA    L    49_A      W      52          0.740
LGA    S    50_A      V      53          0.804
LGA    I    51_A      I      54          1.311
LGA    E    52_A      E      55          0.931
LGA    C    53_A      C      56          0.687
LGA    K    54_A      K      57          1.830
LGA    S    55_A      S      58          2.358
LGA    T    56_A      S      59          3.922
LGA    W    57_A      -       -           -
LGA    E    58_A      -       -           -
LGA    N    59_A      -       -           -
LGA    K    60_A      R      60          4.938
LGA    V    61_A      A      61          5.801
LGA    K    62_A      D      62          5.902
LGA    V    63_A      F      63          2.244
LGA    K    64_A      Q      64          4.275
LGA    -       -      A      65           -
LGA    E    65_A      D      66          5.142
LGA    H    66_A      A      67          4.443
LGA    Q    67_A      K      68          4.414
LGA    V    68_A      W      69          0.705
LGA    R    69_A      Q      70          3.602
LGA    K    70_A      G      71          4.287
LGA    L    71_A      Y      72          1.959
LGA    L    72_A      L      73          1.888
LGA    D    73_A      E      74          3.908
LGA    F    74_A      W      75          2.417
LGA    L    75_A      C      76          2.511
LGA    S    76_A      -       -           -
LGA    M    77_A      -       -           -
LGA    F    78_A      -       -           -
LGA    T    79_A      -       -           -
LGA    M    80_A      -       -           -
LGA    K    81_A      -       -           -
LGA    G    82_A      D      77          0.507
LGA    V    83_A      R      78          0.599
LGA    P    84_A      Y      79          0.810
LGA    L    85_A      F      80          1.054
LGA    I    86_A      W      81          1.437
LGA    A    87_A      A      82          1.147
LGA    I    88_A      V      83          0.998
LGA    K    89_A      D      84          1.649
LGA    F    90_A      M      85          2.527
LGA    K    91_A      E      86           #
LGA    Q    92_A      F      87           #
LGA    V    93_A      P      88           -
LGA    H    94_A      -       -           -
LGA    E    95_A      -       -           -
LGA    W    96_A      -       -           -
LGA    R    97_A      A      89           #
LGA    V    98_A      E      90           -
LGA    -       -      L      91           -
LGA    -       -      L      92           -
LGA    -       -      P      93           -
LGA    -       -      A      94           -
LGA    L    99_A      E      95           #
LGA    V   100_A      S      96          0.807
LGA    P   101_A      G      97           #
LGA    E   102_A      -       -           -
LGA    K   103_A      -       -           -
LGA    A   104_A      -       -           -
LGA    E   105_A      -       -           -
LGA    D   106_A      -       -           -
LGA    I   107_A      -       -           -
LGA    I   108_A      -       -           -
LGA    V   109_A      -       -           -
LGA    T   110_A      -       -           -
LGA    I   111_A      -       -           -
LGA    D   112_A      -       -           -
LGA    N   113_A      -       -           -
LGA    S   114_A      -       -           -
LGA    I   115_A      L      98          5.173
LGA    P   116_A      L      99          5.163
LGA    I   117_A      I     100          5.009
LGA    -       -      A     101           -
LGA    -       -      D     102           -
LGA    -       -      A     103           -
LGA    -       -      Y     104           -
LGA    -       -      D     105           -
LGA    -       -      A     106           -
LGA    -       -      E     107           -
LGA    E   118_A      I     108          3.151
LGA    D   119_A      V     109          3.337
LGA    L   120_A      R     110          3.720
LGA    F   121_A      M     111           #
LGA    K   122_A      -       -           -
LGA    I   123_A      -       -           -
LGA    L   124_A      A     112           #
LGA    E   125_A      P     113           -
LGA    K   126_A      E     114           -
LGA    R   127_A      Q     115           -
LGA    I   128_A      K     116           -
LGA    E   129_A      L     117           -
LGA    -       -      A     118           -
LGA    -       -      P     119           -
LGA    -       -      A     120           -
LGA    -       -      R     121           -
LGA    -       -      R     122           -
LGA    -       -      K     123           -
LGA    -       -      V     124           -
LGA    -       -      L     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      K     128           -
LGA    -       -      F     129           -
LGA    -       -      A     130           -
LGA    -       -      T     131           -
LGA    -       -      H     132           -
LGA    -       -      A     133           -
LGA    -       -      A     134           -
LGA    -       -      R     135           -
LGA    -       -      R     136           -
LGA    -       -      L     137           -
LGA    -       -      Q     138           -
LGA    -       -      A     139           -
LGA    -       -      L     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      P     143           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124  139    5.0     76    2.65    21.05     39.130     2.759

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.775734 * X  +  -0.621571 * Y  +   0.109024 * Z  +  24.967834
  Y_new =   0.431377 * X  +   0.396203 * Y  +  -0.810516 * Z  +  32.548462
  Z_new =   0.460598 * X  +   0.675776 * Y  +   0.575480 * Z  +  -9.792729 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.865383   -2.276209  [ DEG:    49.5828   -130.4172 ]
  Theta =  -0.478668   -2.662924  [ DEG:   -27.4257   -152.5743 ]
  Phi   =   0.507506   -2.634087  [ DEG:    29.0780   -150.9220 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ob9_A                                        
REMARK     2: T0495_5_143.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ob9_A.T0495_5_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124  139   5.0   76   2.65   21.05  39.130
REMARK  ---------------------------------------------------------- 
MOLECULE 1ob9_A
HEADER    HYDROLASE                               28-JAN-03   1OB9              
TITLE     HOLLIDAY JUNCTION RESOLVING ENZYME                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HOLLIDAY JUNCTION RESOLVASE;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SULFOLOBUS SOLFATARICUS;                        
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: DE3;                                       
SOURCE   5 EXPRESSION_SYSTEM_VARIANT: RIL;                                      
SOURCE   6 EXPRESSION_SYSTEM_CELL_LINE: BL21;                                   
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET19B                                    
KEYWDS    ENZYME, HOMOLOGOUS RECOMBINATION, HOLLIDAY JUNCTION                   
KEYWDS   2 RESOLVING ENZYME, NUCLEASE, ARCHAEA, THERMOPHILE, HYDROLASE          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.L.MIDDLETON,J.L.PARKER,D.J.RICHARD,M.F.WHITE,C.S.BOND               
REVDAT   1   15-OCT-04 1OB9    0                                                
JRNL        AUTH   C.L.MIDDLETON,J.L.PARKER,D.J.RICHARD,M.F.WHITE,              
JRNL        AUTH 2 C.S.BOND                                                     
JRNL        TITL   SUBSTRATE RECOGNITION AND CATALYSIS BY THE                   
JRNL        TITL 2 HOLLIDAY JUNCTION RESOLVING ENZYME HJE.                      
JRNL        REF    NUCLEIC ACIDS RES.            V.  32  5442 2004              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1OB9 A    1   135  UNP    Q97YX6   Q97YX6_SULSO     1    135             
SEQRES   1 A  135  MET ASN ARG ASP ILE GLY LYS ASN ALA GLU ARG GLU LEU          
SEQRES   2 A  135  VAL SER ILE LEU ARG GLY GLU GLY PHE ASN ALA VAL ARG          
SEQRES   3 A  135  ILE PRO THR SER ASN SER SER PRO ASN PRO LEU PRO ASP          
SEQRES   4 A  135  ILE PHE ALA THR LYS GLY ASN THR LEU LEU SER ILE GLU          
SEQRES   5 A  135  CYS LYS SER THR TRP GLU ASN LYS VAL LYS VAL LYS GLU          
SEQRES   6 A  135  HIS GLN VAL ARG LYS LEU LEU ASP PHE LEU SER MET PHE          
SEQRES   7 A  135  THR MET LYS GLY VAL PRO LEU ILE ALA ILE LYS PHE LYS          
SEQRES   8 A  135  GLN VAL HIS GLU TRP ARG VAL LEU VAL PRO GLU LYS ALA          
SEQRES   9 A  135  GLU ASP ILE ILE VAL THR ILE ASP ASN SER ILE PRO ILE          
SEQRES  10 A  135  GLU ASP LEU PHE LYS ILE LEU GLU LYS ARG ILE GLU GLU          
SEQRES  11 A  135  LYS ILE LEU THR PRO                                          
HET    EDO  A1130       4                                                       
HET    FMT  A1131       3                                                       
HET    FMT  A1132       3                                                       
HET    FMT  A1133       3                                                       
HET    FMT  A1134       3                                                       
HET    FMT  A1135       3                                                       
HET    FMT  A1136       3                                                       
HET    FMT  A1137       3                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     FMT FORMIC ACID                                                      
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   2  EDO    C2 H6 O2                                                     
FORMUL   3  FMT    7(C H2 O2)                                                   
FORMUL  10  HOH   *151(H2 O)                                                    
CRYST1   76.570   76.570   88.944  90.00  90.00  90.00 I 41          8          
ATOM      1  N   GLY A   6      43.833  32.346  10.557  0.67 52.07           N  
ATOM      3  CA  GLY A   6      44.475  33.687  10.742  0.67 52.10           C  
ATOM      5  C   GLY A   6      45.448  33.958   9.610  1.00 52.13           C  
ATOM      6  O   GLY A   6      45.161  34.754   8.704  1.00 51.93           O  
ATOM      7  N   LYS A   7      46.562  33.228   9.630  1.00 51.52           N  
ATOM      8  CA  LYS A   7      47.601  33.311   8.607  1.00 51.20           C  
ATOM      9  C   LYS A   7      47.091  33.053   7.188  1.00 49.69           C  
ATOM     10  O   LYS A   7      47.492  33.720   6.240  1.00 49.27           O  
ATOM     11  CB  LYS A   7      48.738  32.331   8.941  1.00 51.68           C  
ATOM     12  CG  LYS A   7      50.062  32.611   8.211  1.00 53.65           C  
ATOM     13  CD  LYS A   7      51.320  32.192   9.036  1.00 55.58           C  
ATOM     14  CE  LYS A   7      51.502  33.030  10.328  1.00 56.43           C  
ATOM     15  NZ  LYS A   7      52.822  33.762  10.421  1.00 57.02           N  
ATOM     16  N   ASN A   8      46.182  32.106   7.049  1.00 48.17           N  
ATOM     17  CA  ASN A   8      45.730  31.672   5.731  1.00 46.87           C  
ATOM     18  C   ASN A   8      44.779  32.636   5.017  1.00 44.59           C  
ATOM     19  O   ASN A   8      44.869  32.838   3.811  1.00 43.99           O  
ATOM     20  CB  ASN A   8      45.112  30.286   5.866  1.00 47.64           C  
ATOM     21  CG  ASN A   8      46.125  29.270   6.335  1.00 49.37           C  
ATOM     22  OD1 ASN A   8      47.212  29.164   5.758  1.00 51.18           O  
ATOM     23  ND2 ASN A   8      45.800  28.544   7.397  1.00 51.25           N  
ATOM     24  N   ALA A   9      43.857  33.203   5.774  1.00 42.44           N  
ATOM     25  CA  ALA A   9      42.968  34.240   5.282  1.00 40.97           C  
ATOM     26  C   ALA A   9      43.759  35.491   4.883  1.00 39.31           C  
ATOM     27  O   ALA A   9      43.475  36.095   3.862  1.00 39.15           O  
ATOM     28  CB  ALA A   9      41.933  34.579   6.359  1.00 40.47           C  
ATOM     29  N   GLU A  10      44.749  35.864   5.685  1.00 38.00           N  
ATOM     30  CA  GLU A  10      45.600  37.000   5.367  1.00 37.63           C  
ATOM     31  C   GLU A  10      46.335  36.771   4.054  1.00 36.98           C  
ATOM     32  O   GLU A  10      46.313  37.620   3.180  1.00 36.35           O  
ATOM     33  CB  GLU A  10      46.596  37.284   6.490  1.00 37.18           C  
ATOM     34  CG  GLU A  10      45.976  38.032   7.650  1.00 38.05           C  
ATOM     35  CD  GLU A  10      46.943  38.320   8.790  1.00 37.92           C  
ATOM     36  OE1 GLU A  10      48.155  38.171   8.615  1.00 39.35           O  
ATOM     37  OE2 GLU A  10      46.480  38.711   9.876  1.00 42.49           O  
ATOM     38  N   ARG A  11      46.946  35.605   3.908  1.00 36.55           N  
ATOM     39  CA  ARG A  11      47.671  35.271   2.676  1.00 37.80           C  
ATOM     40  C   ARG A  11      46.736  35.278   1.478  1.00 36.66           C  
ATOM     41  O   ARG A  11      47.118  35.689   0.382  1.00 37.30           O  
ATOM     42  CB  ARG A  11      48.398  33.920   2.794  1.00 37.90           C  
ATOM     43  CG  ARG A  11      49.656  33.958   3.665  1.00 41.50           C  
ATOM     44  CD  ARG A  11      50.339  32.577   3.815  1.00 47.46           C  
ATOM     45  NE  ARG A  11      51.580  32.630   4.604  1.00 52.95           N  
ATOM     46  CZ  ARG A  11      51.963  31.717   5.517  1.00 57.03           C  
ATOM     47  NH1 ARG A  11      51.215  30.642   5.780  1.00 57.98           N  
ATOM     48  NH2 ARG A  11      53.119  31.874   6.172  1.00 58.35           N  
ATOM     49  N   GLU A  12      45.489  34.870   1.685  1.00 36.42           N  
ATOM     50  CA  GLU A  12      44.511  34.918   0.615  1.00 35.59           C  
ATOM     51  C   GLU A  12      44.168  36.379   0.249  1.00 34.94           C  
ATOM     52  O   GLU A  12      44.124  36.754  -0.934  1.00 34.71           O  
ATOM     53  CB  GLU A  12      43.256  34.125   1.012  1.00 35.91           C  
ATOM     54  CG  GLU A  12      42.161  34.124  -0.040  1.00 37.29           C  
ATOM     55  CD  GLU A  12      40.972  33.249   0.366  1.00 39.36           C  
ATOM     56  OE1 GLU A  12      41.190  32.089   0.750  1.00 44.53           O  
ATOM     57  OE2 GLU A  12      39.828  33.699   0.302  1.00 34.40           O  
ATOM     58  N   LEU A  13      43.944  37.216   1.256  1.00 34.08           N  
ATOM     59  CA  LEU A  13      43.648  38.619   0.998  1.00 33.41           C  
ATOM     60  C   LEU A  13      44.788  39.313   0.258  1.00 32.53           C  
ATOM     61  O   LEU A  13      44.545  40.096  -0.626  1.00 30.04           O  
ATOM     62  CB  LEU A  13      43.317  39.373   2.293  1.00 33.23           C  
ATOM     63  CG  LEU A  13      42.857  40.833   2.130  1.00 32.70           C  
ATOM     64  CD1 LEU A  13      41.688  40.982   1.186  1.00 33.33           C  
ATOM     65  CD2 LEU A  13      42.515  41.413   3.470  1.00 31.63           C  
ATOM     66  N   VAL A  14      46.016  39.068   0.693  1.00 33.41           N  
ATOM     67  CA  VAL A  14      47.213  39.582   0.033  1.00 34.47           C  
ATOM     68  C   VAL A  14      47.212  39.176  -1.444  1.00 34.53           C  
ATOM     69  O   VAL A  14      47.461  40.002  -2.307  1.00 34.75           O  
ATOM     70  CB  VAL A  14      48.493  39.099   0.747  1.00 34.21           C  
ATOM     71  CG1 VAL A  14      49.760  39.314  -0.116  1.00 35.16           C  
ATOM     72  CG2 VAL A  14      48.638  39.827   2.078  1.00 35.33           C  
ATOM     73  N   SER A  15      46.879  37.921  -1.743  1.00 35.13           N  
ATOM     74  CA  SER A  15      46.885  37.458  -3.129  1.00 34.88           C  
ATOM     75  C   SER A  15      45.808  38.180  -3.948  1.00 35.62           C  
ATOM     76  O   SER A  15      46.027  38.511  -5.112  1.00 35.29           O  
ATOM     77  CB  SER A  15      46.684  35.933  -3.214  0.67 35.56           C  
ATOM     79  OG  SER A  15      46.279  35.553  -4.521  0.67 33.81           O  
ATOM     81  N   ILE A  16      44.648  38.431  -3.347  1.00 35.37           N  
ATOM     82  CA  ILE A  16      43.570  39.168  -4.018  1.00 35.89           C  
ATOM     83  C   ILE A  16      43.970  40.631  -4.257  1.00 35.75           C  
ATOM     84  O   ILE A  16      43.648  41.224  -5.286  1.00 36.35           O  
ATOM     85  CB  ILE A  16      42.272  39.149  -3.139  1.00 35.35           C  
ATOM     86  CG1 ILE A  16      41.630  37.757  -3.171  1.00 36.57           C  
ATOM     87  CG2 ILE A  16      41.294  40.235  -3.554  1.00 34.72           C  
ATOM     88  CD1 ILE A  16      40.372  37.662  -2.330  1.00 37.00           C  
ATOM     89  N   LEU A  17      44.625  41.221  -3.275  1.00 35.95           N  
ATOM     90  CA  LEU A  17      45.131  42.596  -3.403  1.00 36.16           C  
ATOM     91  C   LEU A  17      46.124  42.698  -4.566  1.00 36.67           C  
ATOM     92  O   LEU A  17      46.013  43.587  -5.392  1.00 36.24           O  
ATOM     93  CB  LEU A  17      45.778  43.057  -2.092  1.00 35.63           C  
ATOM     94  CG  LEU A  17      44.752  43.345  -0.991  1.00 34.24           C  
ATOM     95  CD1 LEU A  17      45.424  43.417   0.355  1.00 32.87           C  
ATOM     96  CD2 LEU A  17      43.988  44.617  -1.277  1.00 34.04           C  
ATOM     97  N   ARG A  18      47.067  41.763  -4.625  1.00 37.74           N  
ATOM     98  CA  ARG A  18      48.077  41.720  -5.689  1.00 38.23           C  
ATOM     99  C   ARG A  18      47.461  41.556  -7.086  1.00 38.36           C  
ATOM    100  O   ARG A  18      47.936  42.148  -8.037  1.00 38.00           O  
ATOM    101  CB  ARG A  18      49.088  40.611  -5.415  1.00 38.41           C  
ATOM    102  CG  ARG A  18      50.087  40.959  -4.356  1.00 40.22           C  
ATOM    103  CD  ARG A  18      50.839  39.771  -3.813  1.00 43.77           C  
ATOM    104  NE  ARG A  18      51.719  40.126  -2.697  1.00 45.57           N  
ATOM    105  CZ  ARG A  18      52.479  39.248  -2.032  1.00 47.22           C  
ATOM    106  NH1 ARG A  18      52.456  37.954  -2.345  1.00 46.88           N  
ATOM    107  NH2 ARG A  18      53.248  39.659  -1.028  1.00 46.96           N  
ATOM    108  N   GLY A  19      46.382  40.789  -7.199  1.00 38.67           N  
ATOM    109  CA  GLY A  19      45.686  40.641  -8.466  1.00 38.94           C  
ATOM    110  C   GLY A  19      44.885  41.854  -8.889  1.00 39.41           C  
ATOM    111  O   GLY A  19      44.492  41.978 -10.048  1.00 40.25           O  
ATOM    112  N   GLU A  20      44.593  42.735  -7.943  1.00 39.02           N  
ATOM    113  CA  GLU A  20      43.979  44.016  -8.237  1.00 38.79           C  
ATOM    114  C   GLU A  20      45.059  45.073  -8.601  1.00 37.93           C  
ATOM    115  O   GLU A  20      44.732  46.149  -9.066  1.00 37.62           O  
ATOM    116  CB  GLU A  20      43.134  44.465  -7.035  1.00 39.17           C  
ATOM    117  CG  GLU A  20      42.392  45.797  -7.165  1.00 39.65           C  
ATOM    118  CD  GLU A  20      41.357  45.841  -8.299  1.00 42.25           C  
ATOM    119  OE1 GLU A  20      40.939  44.755  -8.776  1.00 39.79           O  
ATOM    120  OE2 GLU A  20      40.969  46.980  -8.706  1.00 42.73           O  
ATOM    121  N   GLY A  21      46.331  44.750  -8.402  1.00 37.07           N  
ATOM    122  CA  GLY A  21      47.425  45.630  -8.796  1.00 37.49           C  
ATOM    123  C   GLY A  21      48.109  46.341  -7.631  1.00 37.22           C  
ATOM    124  O   GLY A  21      48.977  47.191  -7.839  1.00 37.15           O  
ATOM    125  N   PHE A  22      47.718  45.984  -6.405  1.00 36.98           N  
ATOM    126  CA  PHE A  22      48.323  46.513  -5.180  1.00 36.65           C  
ATOM    127  C   PHE A  22      49.558  45.699  -4.787  1.00 36.72           C  
ATOM    128  O   PHE A  22      49.567  44.478  -4.887  1.00 37.55           O  
ATOM    129  CB  PHE A  22      47.315  46.440  -4.002  1.00 36.70           C  
ATOM    130  CG  PHE A  22      46.270  47.530  -3.993  1.00 36.87           C  
ATOM    131  CD1 PHE A  22      45.137  47.435  -4.780  1.00 38.33           C  
ATOM    132  CD2 PHE A  22      46.406  48.636  -3.162  1.00 37.98           C  
ATOM    133  CE1 PHE A  22      44.166  48.418  -4.748  1.00 38.27           C  
ATOM    134  CE2 PHE A  22      45.448  49.627  -3.139  1.00 37.58           C  
ATOM    135  CZ  PHE A  22      44.331  49.528  -3.929  1.00 38.69           C  
ATOM    136  N   ASN A  23      50.608  46.372  -4.346  1.00 36.71           N  
ATOM    137  CA  ASN A  23      51.616  45.742  -3.513  1.00 36.20           C  
ATOM    138  C   ASN A  23      50.991  45.538  -2.125  1.00 35.35           C  
ATOM    139  O   ASN A  23      50.433  46.452  -1.561  1.00 34.66           O  
ATOM    140  CB  ASN A  23      52.853  46.626  -3.412  1.00 36.50           C  
ATOM    141  CG  ASN A  23      53.794  46.460  -4.612  1.00 39.47           C  
ATOM    142  OD1 ASN A  23      54.500  45.444  -4.739  1.00 46.39           O  
ATOM    143  ND2 ASN A  23      53.809  47.444  -5.480  1.00 39.09           N  
ATOM    144  N   ALA A  24      51.017  44.323  -1.621  1.00 34.41           N  
ATOM    145  CA  ALA A  24      50.449  44.034  -0.318  1.00 34.63           C  
ATOM    146  C   ALA A  24      51.406  43.192   0.508  1.00 34.74           C  
ATOM    147  O   ALA A  24      52.113  42.327  -0.018  1.00 35.32           O  
ATOM    148  CB  ALA A  24      49.097  43.346  -0.478  1.00 34.05           C  
ATOM    149  N   VAL A  25      51.401  43.423   1.810  1.00 34.21           N  
ATOM    150  CA  VAL A  25      52.325  42.758   2.715  1.00 34.57           C  
ATOM    151  C   VAL A  25      51.637  42.497   4.057  1.00 35.01           C  
ATOM    152  O   VAL A  25      51.000  43.387   4.621  1.00 34.20           O  
ATOM    153  CB  VAL A  25      53.593  43.615   2.945  1.00 34.21           C  
ATOM    154  CG1 VAL A  25      54.560  42.902   3.883  1.00 35.17           C  
ATOM    155  CG2 VAL A  25      54.293  43.947   1.609  1.00 35.58           C  
ATOM    156  N   ARG A  26      51.781  41.278   4.554  1.00 36.17           N  
ATOM    157  CA  ARG A  26      51.346  40.889   5.895  1.00 38.27           C  
ATOM    158  C   ARG A  26      52.352  41.348   6.954  1.00 38.87           C  
ATOM    159  O   ARG A  26      53.543  41.214   6.740  1.00 37.82           O  
ATOM    160  CB  ARG A  26      51.292  39.366   6.010  1.00 39.45           C  
ATOM    161  CG  ARG A  26      50.082  38.673   5.493  1.00 43.03           C  
ATOM    162  CD  ARG A  26      50.075  37.159   5.847  1.00 47.64           C  
ATOM    163  NE  ARG A  26      51.014  36.906   6.941  1.00 51.81           N  
ATOM    164  CZ  ARG A  26      50.725  36.414   8.152  1.00 54.80           C  
ATOM    165  NH1 ARG A  26      49.496  36.051   8.483  1.00 56.12           N  
ATOM    166  NH2 ARG A  26      51.699  36.283   9.054  1.00 54.25           N  
ATOM    167  N   ILE A  27      51.870  41.825   8.104  1.00 39.79           N  
ATOM    168  CA  ILE A  27      52.720  42.146   9.247  1.00 42.29           C  
ATOM    169  C   ILE A  27      52.473  41.078  10.311  1.00 45.70           C  
ATOM    170  O   ILE A  27      51.323  40.837  10.704  1.00 44.54           O  
ATOM    171  CB  ILE A  27      52.440  43.572   9.797  1.00 41.49           C  
ATOM    172  CG1 ILE A  27      52.755  44.628   8.738  1.00 40.03           C  
ATOM    173  CG2 ILE A  27      53.266  43.867  11.059  1.00 42.02           C  
ATOM    174  CD1 ILE A  27      52.435  46.026   9.176  1.00 40.58           C  
ATOM    175  N   PRO A  28      53.559  40.443  10.767  1.00 50.31           N  
ATOM    176  CA  PRO A  28      53.471  39.147  11.451  1.00 53.03           C  
ATOM    177  C   PRO A  28      52.842  39.186  12.826  1.00 55.77           C  
ATOM    178  O   PRO A  28      51.770  38.596  13.007  1.00 56.00           O  
ATOM    179  CB  PRO A  28      54.934  38.693  11.550  1.00 53.14           C  
ATOM    180  CG  PRO A  28      55.754  39.978  11.513  1.00 51.90           C  
ATOM    181  CD  PRO A  28      54.956  40.923  10.668  1.00 50.45           C  
ATOM    182  N   THR A  29      53.485  39.853  13.779  1.00 59.05           N  
ATOM    183  CA  THR A  29      53.112  39.696  15.189  1.00 61.43           C  
ATOM    184  C   THR A  29      52.262  40.863  15.661  1.00 63.39           C  
ATOM    185  O   THR A  29      52.172  41.126  16.873  1.00 64.07           O  
ATOM    186  CB  THR A  29      54.380  39.435  16.091  1.00 61.76           C  
ATOM    187  OG1 THR A  29      54.502  38.030  16.352  1.00 62.72           O  
ATOM    188  CG2 THR A  29      54.298  40.047  17.521  1.00 61.61           C  
ATOM    189  N   SER A  30      51.616  41.560  14.723  1.00 64.89           N  
ATOM    190  CA  SER A  30      50.534  42.442  15.118  1.00 65.99           C  
ATOM    191  C   SER A  30      49.739  41.634  16.148  1.00 67.23           C  
ATOM    192  O   SER A  30      48.945  40.755  15.792  1.00 68.23           O  
ATOM    193  CB  SER A  30      49.660  42.830  13.925  1.00 65.90           C  
ATOM    194  OG  SER A  30      50.405  43.580  12.992  1.00 65.30           O  
ATOM    195  N   ASN A  31      50.023  41.893  17.424  1.00 68.09           N  
ATOM    196  CA  ASN A  31      49.335  41.267  18.543  1.00 68.63           C  
ATOM    197  C   ASN A  31      48.610  42.400  19.260  1.00 68.81           C  
ATOM    198  O   ASN A  31      48.882  43.572  18.974  1.00 69.12           O  
ATOM    199  CB  ASN A  31      50.352  40.591  19.487  1.00 68.86           C  
ATOM    200  CG  ASN A  31      49.874  39.228  20.008  1.00 70.05           C  
ATOM    201  OD1 ASN A  31      48.790  39.110  20.601  1.00 70.97           O  
ATOM    202  ND2 ASN A  31      50.694  38.195  19.799  1.00 71.23           N  
ATOM    203  N   SER A  32      47.718  42.066  20.198  1.00 68.81           N  
ATOM    204  CA  SER A  32      47.055  43.064  21.060  1.00 68.37           C  
ATOM    205  C   SER A  32      47.993  44.142  21.674  1.00 67.47           C  
ATOM    206  O   SER A  32      47.503  45.127  22.253  1.00 68.29           O  
ATOM    207  CB  SER A  32      46.276  42.354  22.178  1.00 68.84           C  
ATOM    208  OG  SER A  32      45.191  41.602  21.646  1.00 69.94           O  
ATOM    209  N   SER A  33      49.315  43.913  21.584  1.00 65.73           N  
ATOM    210  CA  SER A  33      50.398  44.919  21.773  1.00 63.98           C  
ATOM    211  C   SER A  33      50.089  46.404  21.398  1.00 61.84           C  
ATOM    212  O   SER A  33      49.086  46.703  20.754  1.00 61.96           O  
ATOM    213  CB  SER A  33      51.662  44.431  21.020  1.00 64.17           C  
ATOM    214  OG  SER A  33      52.026  45.275  19.936  1.00 64.53           O  
ATOM    215  N   PRO A  34      50.948  47.340  21.803  1.00 58.94           N  
ATOM    216  CA  PRO A  34      50.654  48.770  21.597  1.00 57.02           C  
ATOM    217  C   PRO A  34      50.944  49.313  20.187  1.00 54.37           C  
ATOM    218  O   PRO A  34      50.349  50.326  19.793  1.00 54.16           O  
ATOM    219  CB  PRO A  34      51.569  49.460  22.620  1.00 57.18           C  
ATOM    220  CG  PRO A  34      52.744  48.539  22.754  1.00 58.26           C  
ATOM    221  CD  PRO A  34      52.233  47.140  22.500  1.00 58.94           C  
ATOM    222  N   ASN A  35      51.844  48.664  19.453  1.00 51.33           N  
ATOM    223  CA  ASN A  35      52.309  49.193  18.181  1.00 49.01           C  
ATOM    224  C   ASN A  35      51.155  49.412  17.183  1.00 46.05           C  
ATOM    225  O   ASN A  35      50.324  48.518  16.987  1.00 45.12           O  
ATOM    226  CB  ASN A  35      53.398  48.287  17.583  1.00 49.46           C  
ATOM    227  CG  ASN A  35      54.731  48.382  18.343  1.00 51.35           C  
ATOM    228  OD1 ASN A  35      54.956  49.317  19.118  1.00 54.59           O  
ATOM    229  ND2 ASN A  35      55.618  47.412  18.113  1.00 51.60           N  
ATOM    230  N   PRO A  36      51.086  50.618  16.604  1.00 43.06           N  
ATOM    231  CA  PRO A  36      50.096  50.936  15.572  1.00 40.94           C  
ATOM    232  C   PRO A  36      50.440  50.270  14.232  1.00 39.51           C  
ATOM    233  O   PRO A  36      51.010  50.929  13.345  1.00 38.77           O  
ATOM    234  CB  PRO A  36      50.178  52.473  15.472  1.00 41.77           C  
ATOM    235  CG  PRO A  36      51.598  52.815  15.875  1.00 41.39           C  
ATOM    236  CD  PRO A  36      51.973  51.770  16.883  1.00 42.41           C  
ATOM    237  N   LEU A  37      50.115  48.976  14.109  1.00 37.15           N  
ATOM    238  CA  LEU A  37      50.412  48.187  12.923  1.00 35.68           C  
ATOM    239  C   LEU A  37      49.158  47.427  12.467  1.00 33.91           C  
ATOM    240  O   LEU A  37      48.532  46.762  13.253  1.00 34.21           O  
ATOM    241  CB  LEU A  37      51.532  47.188  13.199  1.00 35.33           C  
ATOM    242  CG  LEU A  37      52.875  47.725  13.690  1.00 36.24           C  
ATOM    243  CD1 LEU A  37      53.805  46.561  13.986  1.00 37.85           C  
ATOM    244  CD2 LEU A  37      53.513  48.691  12.694  1.00 37.45           C  
ATOM    245  N   PRO A  38      48.798  47.535  11.202  1.00 32.43           N  
ATOM    246  CA  PRO A  38      47.691  46.754  10.661  1.00 31.72           C  
ATOM    247  C   PRO A  38      48.125  45.301  10.473  1.00 31.15           C  
ATOM    248  O   PRO A  38      49.290  44.984  10.633  1.00 29.57           O  
ATOM    249  CB  PRO A  38      47.427  47.422   9.313  1.00 31.54           C  
ATOM    250  CG  PRO A  38      48.756  47.935   8.906  1.00 32.65           C  
ATOM    251  CD  PRO A  38      49.433  48.384  10.180  1.00 32.17           C  
ATOM    252  N   ASP A  39      47.178  44.420  10.170  1.00 31.48           N  
ATOM    253  CA  ASP A  39      47.519  43.050   9.812  1.00 31.09           C  
ATOM    254  C   ASP A  39      48.184  43.063   8.446  1.00 31.15           C  
ATOM    255  O   ASP A  39      49.111  42.291   8.192  1.00 31.49           O  
ATOM    256  CB  ASP A  39      46.267  42.173   9.760  1.00 31.51           C  
ATOM    257  CG  ASP A  39      45.634  41.970  11.114  1.00 31.71           C  
ATOM    258  OD1 ASP A  39      46.373  41.979  12.132  1.00 34.34           O  
ATOM    259  OD2 ASP A  39      44.400  41.800  11.248  1.00 29.92           O  
ATOM    260  N   ILE A  40      47.673  43.918   7.564  1.00 30.73           N  
ATOM    261  CA  ILE A  40      48.153  44.022   6.193  1.00 30.24           C  
ATOM    262  C   ILE A  40      48.184  45.484   5.803  1.00 31.22           C  
ATOM    263  O   ILE A  40      47.281  46.245   6.153  1.00 30.77           O  
ATOM    264  CB  ILE A  40      47.200  43.248   5.199  1.00 30.08           C  
ATOM    265  CG1 ILE A  40      47.317  41.741   5.387  1.00 30.22           C  
ATOM    266  CG2 ILE A  40      47.530  43.626   3.765  1.00 30.93           C  
ATOM    267  CD1 ILE A  40      46.159  40.951   4.889  1.00 31.55           C  
ATOM    268  N   PHE A  41      49.212  45.889   5.065  1.00 30.71           N  
ATOM    269  CA  PHE A  41      49.158  47.160   4.398  1.00 31.19           C  
ATOM    270  C   PHE A  41      49.385  46.927   2.928  1.00 30.13           C  
ATOM    271  O   PHE A  41      50.018  45.951   2.548  1.00 29.55           O  
ATOM    272  CB  PHE A  41      50.141  48.181   5.005  1.00 31.20           C  
ATOM    273  CG  PHE A  41      51.574  47.897   4.731  1.00 32.45           C  
ATOM    274  CD1 PHE A  41      52.288  47.031   5.546  1.00 36.11           C  
ATOM    275  CD2 PHE A  41      52.244  48.541   3.692  1.00 36.40           C  
ATOM    276  CE1 PHE A  41      53.635  46.766   5.305  1.00 36.10           C  
ATOM    277  CE2 PHE A  41      53.592  48.286   3.452  1.00 36.89           C  
ATOM    278  CZ  PHE A  41      54.284  47.394   4.262  1.00 36.33           C  
ATOM    279  N   ALA A  42      48.829  47.809   2.112  1.00 30.24           N  
ATOM    280  CA  ALA A  42      48.884  47.666   0.638  1.00 30.13           C  
ATOM    281  C   ALA A  42      48.920  49.034  -0.016  1.00 30.65           C  
ATOM    282  O   ALA A  42      48.295  49.970   0.481  1.00 28.90           O  
ATOM    283  CB  ALA A  42      47.685  46.906   0.145  1.00 30.07           C  
ATOM    284  N   THR A  43      49.647  49.156  -1.135  1.00 30.82           N  
ATOM    285  CA  THR A  43      49.666  50.379  -1.912  1.00 30.60           C  
ATOM    286  C   THR A  43      49.471  50.145  -3.420  1.00 31.54           C  
ATOM    287  O   THR A  43      49.840  49.096  -3.982  1.00 29.79           O  
ATOM    288  CB  THR A  43      51.004  51.117  -1.755  1.00 31.41           C  
ATOM    289  OG1 THR A  43      52.052  50.289  -2.277  1.00 29.23           O  
ATOM    290  CG2 THR A  43      51.361  51.345  -0.298  1.00 30.24           C  
ATOM    291  N   LYS A  44      48.901  51.170  -4.039  1.00 32.49           N  
ATOM    292  CA  LYS A  44      48.740  51.274  -5.489  1.00 33.54           C  
ATOM    293  C   LYS A  44      48.670  52.755  -5.789  1.00 33.55           C  
ATOM    294  O   LYS A  44      47.793  53.437  -5.270  1.00 32.49           O  
ATOM    295  CB  LYS A  44      47.444  50.602  -5.928  1.00 33.20           C  
ATOM    296  CG  LYS A  44      47.302  50.572  -7.441  1.00 35.25           C  
ATOM    297  CD  LYS A  44      46.112  49.737  -7.860  1.00 34.55           C  
ATOM    298  CE  LYS A  44      46.038  49.708  -9.392  1.00 36.82           C  
ATOM    299  NZ  LYS A  44      44.809  49.057  -9.819  1.00 36.75           N  
ATOM    300  N   GLY A  45      49.626  53.262  -6.576  1.00 34.19           N  
ATOM    301  CA  GLY A  45      49.768  54.695  -6.763  1.00 34.81           C  
ATOM    302  C   GLY A  45      49.991  55.405  -5.441  1.00 34.75           C  
ATOM    303  O   GLY A  45      50.778  54.950  -4.620  1.00 35.92           O  
ATOM    304  N   ASN A  46      49.257  56.487  -5.220  1.00 34.11           N  
ATOM    305  CA  ASN A  46      49.362  57.280  -4.010  1.00 33.94           C  
ATOM    306  C   ASN A  46      48.383  56.850  -2.899  1.00 32.88           C  
ATOM    307  O   ASN A  46      48.199  57.570  -1.914  1.00 32.88           O  
ATOM    308  CB  ASN A  46      49.137  58.760  -4.382  1.00 33.78           C  
ATOM    309  CG  ASN A  46      49.557  59.732  -3.285  1.00 35.20           C  
ATOM    310  OD1 ASN A  46      48.797  60.643  -2.923  1.00 36.83           O  
ATOM    311  ND2 ASN A  46      50.774  59.569  -2.770  1.00 35.60           N  
ATOM    312  N   THR A  47      47.734  55.705  -3.076  1.00 32.23           N  
ATOM    313  CA  THR A  47      46.821  55.150  -2.072  1.00 32.14           C  
ATOM    314  C   THR A  47      47.457  54.066  -1.207  1.00 31.17           C  
ATOM    315  O   THR A  47      48.008  53.096  -1.735  1.00 31.40           O  
ATOM    316  CB  THR A  47      45.604  54.538  -2.775  1.00 32.28           C  
ATOM    317  OG1 THR A  47      44.833  55.574  -3.397  1.00 32.31           O  
ATOM    318  CG2 THR A  47      44.648  53.903  -1.787  1.00 32.52           C  
ATOM    319  N   LEU A  48      47.291  54.200   0.107  1.00 29.75           N  
ATOM    320  CA  LEU A  48      47.719  53.212   1.096  1.00 29.75           C  
ATOM    321  C   LEU A  48      46.528  52.625   1.830  1.00 29.15           C  
ATOM    322  O   LEU A  48      45.743  53.371   2.403  1.00 29.05           O  
ATOM    323  CB  LEU A  48      48.662  53.875   2.112  1.00 28.67           C  
ATOM    324  CG  LEU A  48      49.119  53.154   3.395  1.00 29.02           C  
ATOM    325  CD1 LEU A  48      50.032  52.000   3.120  1.00 31.55           C  
ATOM    326  CD2 LEU A  48      49.863  54.152   4.294  1.00 30.41           C  
ATOM    327  N   LEU A  49      46.383  51.297   1.816  1.00 29.27           N  
ATOM    328  CA  LEU A  49      45.368  50.611   2.633  1.00 29.46           C  
ATOM    329  C   LEU A  49      45.924  50.124   3.972  1.00 29.51           C  
ATOM    330  O   LEU A  49      47.014  49.565   4.030  1.00 29.29           O  
ATOM    331  CB  LEU A  49      44.786  49.406   1.884  1.00 30.37           C  
ATOM    332  CG  LEU A  49      44.314  49.639   0.449  1.00 29.64           C  
ATOM    333  CD1 LEU A  49      43.591  48.409  -0.077  1.00 31.29           C  
ATOM    334  CD2 LEU A  49      43.417  50.844   0.388  1.00 31.39           C  
ATOM    335  N   SER A  50      45.148  50.307   5.041  1.00 29.30           N  
ATOM    336  CA  SER A  50      45.519  49.849   6.376  1.00 29.25           C  
ATOM    337  C   SER A  50      44.426  48.896   6.851  1.00 29.52           C  
ATOM    338  O   SER A  50      43.325  49.330   7.184  1.00 29.73           O  
ATOM    339  CB  SER A  50      45.627  51.037   7.313  1.00 28.65           C  
ATOM    340  OG  SER A  50      46.179  50.697   8.566  1.00 27.91           O  
ATOM    341  N   ILE A  51      44.748  47.607   6.930  1.00 30.69           N  
ATOM    342  CA  ILE A  51      43.715  46.556   6.992  1.00 31.27           C  
ATOM    343  C   ILE A  51      43.787  45.704   8.272  1.00 32.05           C  
ATOM    344  O   ILE A  51      44.843  45.149   8.607  1.00 30.46           O  
ATOM    345  CB  ILE A  51      43.861  45.639   5.765  1.00 31.51           C  
ATOM    346  CG1 ILE A  51      43.668  46.426   4.452  1.00 31.06           C  
ATOM    347  CG2 ILE A  51      42.877  44.418   5.828  1.00 31.76           C  
ATOM    348  CD1 ILE A  51      44.242  45.689   3.219  1.00 31.48           C  
ATOM    349  N   GLU A  52      42.650  45.605   8.966  1.00 33.33           N  
ATOM    350  CA  GLU A  52      42.410  44.545   9.935  1.00 34.11           C  
ATOM    351  C   GLU A  52      41.653  43.409   9.227  1.00 34.36           C  
ATOM    352  O   GLU A  52      40.597  43.603   8.629  1.00 32.41           O  
ATOM    353  CB  GLU A  52      41.674  45.014  11.197  1.00 35.27           C  
ATOM    354  CG  GLU A  52      41.361  43.829  12.137  1.00 38.17           C  
ATOM    355  CD  GLU A  52      41.090  44.209  13.587  1.00 44.83           C  
ATOM    356  OE1 GLU A  52      40.632  45.343  13.839  1.00 45.33           O  
ATOM    357  OE2 GLU A  52      41.289  43.340  14.482  1.00 48.72           O  
ATOM    358  N   CYS A  53      42.257  42.230   9.269  1.00 34.57           N  
ATOM    359  CA  CYS A  53      41.804  41.089   8.502  1.00 35.36           C  
ATOM    360  C   CYS A  53      41.266  40.015   9.436  1.00 35.72           C  
ATOM    361  O   CYS A  53      41.951  39.579  10.352  1.00 35.05           O  
ATOM    362  CB  CYS A  53      42.962  40.508   7.703  1.00 35.61           C  
ATOM    363  SG  CYS A  53      42.422  39.150   6.671  1.00 36.64           S  
ATOM    364  N   LYS A  54      40.055  39.565   9.157  1.00 36.40           N  
ATOM    365  CA  LYS A  54      39.381  38.551   9.956  1.00 36.84           C  
ATOM    366  C   LYS A  54      38.528  37.683   9.037  1.00 36.41           C  
ATOM    367  O   LYS A  54      38.006  38.151   8.047  1.00 35.41           O  
ATOM    368  CB  LYS A  54      38.503  39.205  11.029  1.00 37.52           C  
ATOM    369  CG  LYS A  54      39.282  39.835  12.217  1.00 42.47           C  
ATOM    370  CD  LYS A  54      38.387  40.074  13.456  1.00 46.38           C  
ATOM    371  CE  LYS A  54      39.182  40.126  14.772  1.00 48.50           C  
ATOM    372  NZ  LYS A  54      38.411  39.511  15.925  1.00 49.85           N  
ATOM    373  N   SER A  55      38.443  36.398   9.349  1.00 36.32           N  
ATOM    374  CA  SER A  55      37.522  35.498   8.673  1.00 36.66           C  
ATOM    375  C   SER A  55      36.657  34.880   9.752  1.00 36.14           C  
ATOM    376  O   SER A  55      37.097  34.725  10.893  1.00 36.43           O  
ATOM    377  CB  SER A  55      38.268  34.428   7.887  1.00 36.69           C  
ATOM    378  OG  SER A  55      39.111  33.680   8.738  1.00 39.88           O  
ATOM    379  N   THR A  56      35.428  34.529   9.397  1.00 35.81           N  
ATOM    380  CA  THR A  56      34.491  33.993  10.381  1.00 34.74           C  
ATOM    381  C   THR A  56      33.397  33.173   9.725  1.00 34.29           C  
ATOM    382  O   THR A  56      33.037  33.380   8.564  1.00 33.24           O  
ATOM    383  CB  THR A  56      33.895  35.170  11.206  1.00 34.87           C  
ATOM    384  OG1 THR A  56      33.044  34.683  12.258  1.00 34.13           O  
ATOM    385  CG2 THR A  56      33.002  36.050  10.337  1.00 35.20           C  
ATOM    386  N   TRP A  57      32.847  32.241  10.485  1.00 34.26           N  
ATOM    387  CA  TRP A  57      31.678  31.505  10.025  1.00 34.34           C  
ATOM    388  C   TRP A  57      30.379  32.064  10.599  1.00 34.46           C  
ATOM    389  O   TRP A  57      29.307  31.588  10.265  1.00 34.25           O  
ATOM    390  CB  TRP A  57      31.826  30.029  10.354  1.00 34.07           C  
ATOM    391  CG  TRP A  57      32.763  29.261   9.439  1.00 32.42           C  
ATOM    392  CD1 TRP A  57      34.032  28.857   9.735  1.00 32.68           C  
ATOM    393  CD2 TRP A  57      32.467  28.728   8.144  1.00 31.76           C  
ATOM    394  NE1 TRP A  57      34.560  28.128   8.695  1.00 31.38           N  
ATOM    395  CE2 TRP A  57      33.623  28.033   7.701  1.00 31.39           C  
ATOM    396  CE3 TRP A  57      31.347  28.773   7.302  1.00 29.44           C  
ATOM    397  CZ2 TRP A  57      33.701  27.415   6.456  1.00 29.83           C  
ATOM    398  CZ3 TRP A  57      31.415  28.153   6.071  1.00 31.12           C  
ATOM    399  CH2 TRP A  57      32.579  27.460   5.658  1.00 31.05           C  
ATOM    400  N   GLU A  58      30.488  33.056  11.476  1.00 35.88           N  
ATOM    401  CA  GLU A  58      29.323  33.828  11.923  1.00 36.03           C  
ATOM    402  C   GLU A  58      28.951  34.884  10.885  1.00 36.86           C  
ATOM    403  O   GLU A  58      29.655  35.084   9.881  1.00 36.20           O  
ATOM    404  CB  GLU A  58      29.546  34.449  13.303  0.67 36.07           C  
ATOM    406  CG  GLU A  58      28.892  33.679  14.439  0.67 34.99           C  
ATOM    408  CD  GLU A  58      27.388  33.944  14.617  0.67 34.00           C  
ATOM    410  OE1 GLU A  58      26.646  34.275  13.641  0.67 32.40           O  
ATOM    412  OE2 GLU A  58      26.932  33.778  15.764  0.67 32.73           O  
ATOM    414  N   ASN A  59      27.827  35.545  11.124  1.00 37.60           N  
ATOM    415  CA  ASN A  59      27.308  36.562  10.222  1.00 38.96           C  
ATOM    416  C   ASN A  59      27.641  37.978  10.706  1.00 39.44           C  
ATOM    417  O   ASN A  59      27.172  38.945  10.148  1.00 40.26           O  
ATOM    418  CB  ASN A  59      25.792  36.373  10.035  1.00 39.27           C  
ATOM    419  CG  ASN A  59      24.984  36.781  11.259  1.00 39.62           C  
ATOM    420  OD1 ASN A  59      25.508  36.903  12.366  1.00 40.38           O  
ATOM    421  ND2 ASN A  59      23.694  36.999  11.056  1.00 41.25           N  
ATOM    422  N   LYS A  60      28.453  38.070  11.754  1.00 40.20           N  
ATOM    423  CA  LYS A  60      28.933  39.337  12.272  1.00 40.87           C  
ATOM    424  C   LYS A  60      30.270  39.154  12.979  1.00 40.31           C  
ATOM    425  O   LYS A  60      30.599  38.054  13.428  1.00 40.59           O  
ATOM    426  CB  LYS A  60      27.909  39.946  13.248  1.00 41.16           C  
ATOM    427  CG  LYS A  60      27.685  39.156  14.541  1.00 43.95           C  
ATOM    428  CD  LYS A  60      26.191  39.146  14.973  1.00 47.34           C  
ATOM    429  CE  LYS A  60      25.624  40.559  15.233  1.00 48.18           C  
ATOM    430  NZ  LYS A  60      24.374  40.851  14.453  1.00 49.38           N  
ATOM    431  N   VAL A  61      31.025  40.238  13.079  1.00 39.87           N  
ATOM    432  CA  VAL A  61      32.348  40.239  13.715  1.00 40.46           C  
ATOM    433  C   VAL A  61      32.512  41.535  14.485  1.00 40.17           C  
ATOM    434  O   VAL A  61      32.306  42.612  13.933  1.00 38.51           O  
ATOM    435  CB  VAL A  61      33.480  40.210  12.665  1.00 40.33           C  
ATOM    436  CG1 VAL A  61      34.865  40.309  13.331  1.00 42.14           C  
ATOM    437  CG2 VAL A  61      33.388  38.975  11.827  1.00 41.50           C  
ATOM    438  N   LYS A  62      32.924  41.419  15.739  1.00 40.68           N  
ATOM    439  CA  LYS A  62      33.187  42.569  16.562  1.00 41.55           C  
ATOM    440  C   LYS A  62      34.663  42.840  16.475  1.00 41.26           C  
ATOM    441  O   LYS A  62      35.477  41.945  16.615  1.00 41.57           O  
ATOM    442  CB  LYS A  62      32.816  42.305  18.012  1.00 42.34           C  
ATOM    443  CG  LYS A  62      32.909  43.537  18.893  1.00 44.44           C  
ATOM    444  CD  LYS A  62      32.429  43.214  20.300  1.00 47.66           C  
ATOM    445  CE  LYS A  62      31.804  44.418  20.993  1.00 49.53           C  
ATOM    446  NZ  LYS A  62      30.691  43.989  21.892  1.00 49.50           N  
ATOM    447  N   VAL A  63      35.004  44.085  16.218  1.00 41.39           N  
ATOM    448  CA  VAL A  63      36.389  44.500  16.234  1.00 41.32           C  
ATOM    449  C   VAL A  63      36.504  45.561  17.306  1.00 41.43           C  
ATOM    450  O   VAL A  63      35.601  46.361  17.470  1.00 41.76           O  
ATOM    451  CB  VAL A  63      36.795  45.009  14.846  1.00 41.33           C  
ATOM    452  CG1 VAL A  63      38.109  45.726  14.926  1.00 42.15           C  
ATOM    453  CG2 VAL A  63      36.891  43.855  13.908  1.00 39.91           C  
ATOM    454  N   LYS A  64      37.595  45.545  18.062  1.00 42.10           N  
ATOM    455  CA  LYS A  64      37.724  46.420  19.219  1.00 42.66           C  
ATOM    456  C   LYS A  64      38.412  47.740  18.889  1.00 42.38           C  
ATOM    457  O   LYS A  64      39.241  47.813  17.977  1.00 41.96           O  
ATOM    458  CB  LYS A  64      38.482  45.695  20.332  1.00 43.45           C  
ATOM    459  CG  LYS A  64      37.753  44.424  20.854  1.00 45.86           C  
ATOM    460  CD  LYS A  64      36.450  44.767  21.591  1.00 49.16           C  
ATOM    461  CE  LYS A  64      36.581  44.571  23.094  1.00 51.75           C  
ATOM    462  NZ  LYS A  64      37.685  45.411  23.647  1.00 53.62           N  
ATOM    463  N   GLU A  65      38.072  48.766  19.664  1.00 42.29           N  
ATOM    464  CA  GLU A  65      38.599  50.112  19.506  1.00 42.09           C  
ATOM    465  C   GLU A  65      40.117  50.100  19.427  1.00 41.74           C  
ATOM    466  O   GLU A  65      40.699  50.751  18.567  1.00 41.37           O  
ATOM    467  CB  GLU A  65      38.145  50.987  20.700  1.00 42.65           C  
ATOM    468  CG  GLU A  65      38.657  52.424  20.673  1.00 43.82           C  
ATOM    469  CD  GLU A  65      38.239  53.236  21.892  1.00 47.15           C  
ATOM    470  OE1 GLU A  65      37.428  52.744  22.704  1.00 48.03           O  
ATOM    471  OE2 GLU A  65      38.717  54.381  22.037  1.00 47.03           O  
ATOM    472  N   HIS A  66      40.746  49.338  20.317  1.00 41.28           N  
ATOM    473  CA  HIS A  66      42.205  49.280  20.421  1.00 41.19           C  
ATOM    474  C   HIS A  66      42.791  48.805  19.076  1.00 39.36           C  
ATOM    475  O   HIS A  66      43.796  49.330  18.641  1.00 37.90           O  
ATOM    476  CB  HIS A  66      42.609  48.354  21.589  1.00 42.04           C  
ATOM    477  CG  HIS A  66      44.089  48.273  21.845  1.00 46.92           C  
ATOM    478  ND1 HIS A  66      44.826  49.341  22.319  1.00 51.69           N  
ATOM    479  CD2 HIS A  66      44.959  47.238  21.735  1.00 50.24           C  
ATOM    480  CE1 HIS A  66      46.090  48.972  22.465  1.00 52.29           C  
ATOM    481  NE2 HIS A  66      46.196  47.699  22.129  1.00 49.88           N  
ATOM    482  N   GLN A  67      42.120  47.862  18.409  1.00 37.88           N  
ATOM    483  CA  GLN A  67      42.574  47.341  17.112  1.00 37.39           C  
ATOM    484  C   GLN A  67      42.276  48.279  15.952  1.00 35.54           C  
ATOM    485  O   GLN A  67      43.102  48.450  15.055  1.00 35.80           O  
ATOM    486  CB  GLN A  67      41.971  45.962  16.828  1.00 37.82           C  
ATOM    487  CG  GLN A  67      42.176  44.930  17.929  1.00 40.89           C  
ATOM    488  CD  GLN A  67      43.609  44.809  18.378  1.00 42.61           C  
ATOM    489  OE1 GLN A  67      44.492  44.517  17.577  1.00 44.93           O  
ATOM    490  NE2 GLN A  67      43.849  45.038  19.660  1.00 43.49           N  
ATOM    491  N   VAL A  68      41.098  48.879  15.957  1.00 34.41           N  
ATOM    492  CA  VAL A  68      40.736  49.845  14.946  1.00 33.02           C  
ATOM    493  C   VAL A  68      41.715  51.012  14.972  1.00 32.95           C  
ATOM    494  O   VAL A  68      42.126  51.511  13.908  1.00 31.55           O  
ATOM    495  CB  VAL A  68      39.323  50.401  15.132  1.00 33.36           C  
ATOM    496  CG1 VAL A  68      39.026  51.421  14.048  1.00 32.00           C  
ATOM    497  CG2 VAL A  68      38.245  49.263  15.100  1.00 33.40           C  
ATOM    498  N   ARG A  69      42.073  51.441  16.183  1.00 32.40           N  
ATOM    499  CA  ARG A  69      42.958  52.590  16.381  1.00 33.06           C  
ATOM    500  C   ARG A  69      44.329  52.363  15.767  1.00 32.55           C  
ATOM    501  O   ARG A  69      44.936  53.308  15.282  1.00 33.00           O  
ATOM    502  CB  ARG A  69      43.120  52.925  17.880  1.00 33.21           C  
ATOM    503  CG  ARG A  69      43.692  54.330  18.152  1.00 35.02           C  
ATOM    504  CD  ARG A  69      43.848  54.706  19.643  1.00 38.97           C  
ATOM    505  NE  ARG A  69      42.562  54.933  20.328  1.00 41.33           N  
ATOM    506  CZ  ARG A  69      41.761  55.989  20.150  1.00 42.75           C  
ATOM    507  NH1 ARG A  69      42.052  56.957  19.280  1.00 42.24           N  
ATOM    508  NH2 ARG A  69      40.636  56.071  20.849  1.00 43.18           N  
ATOM    509  N   LYS A  70      44.838  51.127  15.824  1.00 32.48           N  
ATOM    510  CA  LYS A  70      46.109  50.792  15.167  1.00 32.30           C  
ATOM    511  C   LYS A  70      46.066  51.100  13.675  1.00 31.38           C  
ATOM    512  O   LYS A  70      47.052  51.581  13.110  1.00 31.81           O  
ATOM    513  CB  LYS A  70      46.451  49.306  15.315  1.00 32.26           C  
ATOM    514  CG  LYS A  70      46.678  48.827  16.743  1.00 34.20           C  
ATOM    515  CD  LYS A  70      46.952  47.342  16.772  1.00 34.61           C  
ATOM    516  CE  LYS A  70      47.556  46.902  18.076  1.00 38.36           C  
ATOM    517  NZ  LYS A  70      47.381  45.421  18.264  1.00 40.83           N  
ATOM    518  N   LEU A  71      44.941  50.791  13.030  1.00 31.11           N  
ATOM    519  CA  LEU A  71      44.792  51.057  11.611  1.00 30.26           C  
ATOM    520  C   LEU A  71      44.966  52.564  11.318  1.00 30.17           C  
ATOM    521  O   LEU A  71      45.682  52.956  10.393  1.00 28.68           O  
ATOM    522  CB  LEU A  71      43.427  50.588  11.113  1.00 30.14           C  
ATOM    523  CG  LEU A  71      43.054  49.103  11.281  1.00 30.69           C  
ATOM    524  CD1 LEU A  71      41.743  48.887  10.574  1.00 33.73           C  
ATOM    525  CD2 LEU A  71      44.139  48.139  10.729  1.00 31.06           C  
ATOM    526  N   LEU A  72      44.298  53.380  12.128  1.00 29.40           N  
ATOM    527  CA  LEU A  72      44.262  54.826  11.957  1.00 30.15           C  
ATOM    528  C   LEU A  72      45.580  55.518  12.330  1.00 30.31           C  
ATOM    529  O   LEU A  72      46.035  56.413  11.632  1.00 31.24           O  
ATOM    530  CB  LEU A  72      43.109  55.401  12.789  1.00 30.19           C  
ATOM    531  CG  LEU A  72      41.738  54.718  12.605  1.00 31.28           C  
ATOM    532  CD1 LEU A  72      40.648  55.470  13.387  1.00 33.75           C  
ATOM    533  CD2 LEU A  72      41.386  54.586  11.115  1.00 31.23           C  
ATOM    534  N   ASP A  73      46.165  55.117  13.441  1.00 30.66           N  
ATOM    535  CA  ASP A  73      47.442  55.656  13.857  1.00 31.34           C  
ATOM    536  C   ASP A  73      48.492  55.325  12.816  1.00 30.56           C  
ATOM    537  O   ASP A  73      49.345  56.151  12.566  1.00 31.22           O  
ATOM    538  CB  ASP A  73      47.864  55.127  15.213  1.00 31.18           C  
ATOM    539  CG  ASP A  73      47.095  55.760  16.363  1.00 33.20           C  
ATOM    540  OD1 ASP A  73      46.259  56.686  16.169  1.00 33.30           O  
ATOM    541  OD2 ASP A  73      47.257  55.344  17.520  1.00 35.24           O  
ATOM    542  N   PHE A  74      48.387  54.149  12.180  1.00 30.15           N  
ATOM    543  CA  PHE A  74      49.319  53.744  11.124  1.00 29.00           C  
ATOM    544  C   PHE A  74      49.205  54.727   9.956  1.00 29.05           C  
ATOM    545  O   PHE A  74      50.186  55.291   9.535  1.00 29.22           O  
ATOM    546  CB  PHE A  74      49.024  52.301  10.654  1.00 29.31           C  
ATOM    547  CG  PHE A  74      49.874  51.833   9.488  1.00 29.67           C  
ATOM    548  CD1 PHE A  74      51.184  51.407   9.690  1.00 30.95           C  
ATOM    549  CD2 PHE A  74      49.350  51.771   8.211  1.00 30.95           C  
ATOM    550  CE1 PHE A  74      51.972  50.953   8.608  1.00 31.11           C  
ATOM    551  CE2 PHE A  74      50.128  51.316   7.135  1.00 31.12           C  
ATOM    552  CZ  PHE A  74      51.435  50.912   7.345  1.00 30.28           C  
ATOM    553  N   LEU A  75      47.989  54.949   9.466  1.00 28.82           N  
ATOM    554  CA  LEU A  75      47.730  55.822   8.335  1.00 28.84           C  
ATOM    555  C   LEU A  75      48.184  57.262   8.589  1.00 29.48           C  
ATOM    556  O   LEU A  75      48.674  57.933   7.680  1.00 29.24           O  
ATOM    557  CB  LEU A  75      46.235  55.816   7.980  1.00 28.66           C  
ATOM    558  CG  LEU A  75      45.696  54.576   7.283  1.00 29.41           C  
ATOM    559  CD1 LEU A  75      44.174  54.693   6.979  1.00 29.72           C  
ATOM    560  CD2 LEU A  75      46.482  54.353   5.975  1.00 28.74           C  
ATOM    561  N   SER A  76      48.065  57.722   9.824  1.00 29.76           N  
ATOM    562  CA  SER A  76      48.326  59.120  10.121  1.00 30.21           C  
ATOM    563  C   SER A  76      49.805  59.451  10.010  1.00 30.26           C  
ATOM    564  O   SER A  76      50.186  60.620   9.942  1.00 29.30           O  
ATOM    565  CB  SER A  76      47.793  59.486  11.518  0.67 30.55           C  
ATOM    567  OG  SER A  76      48.514  58.823  12.547  0.67 32.79           O  
ATOM    569  N   MET A  77      50.637  58.415   9.950  1.00 30.57           N  
ATOM    570  CA  MET A  77      52.057  58.606   9.802  1.00 31.12           C  
ATOM    571  C   MET A  77      52.481  58.843   8.348  1.00 30.22           C  
ATOM    572  O   MET A  77      53.622  59.198   8.101  1.00 29.90           O  
ATOM    573  CB  MET A  77      52.807  57.394  10.340  1.00 31.63           C  
ATOM    574  CG  MET A  77      52.549  57.048  11.774  1.00 33.55           C  
ATOM    575  SD  MET A  77      53.353  55.444  12.142  1.00 39.82           S  
ATOM    576  CE  MET A  77      55.085  55.801  11.793  1.00 42.44           C  
ATOM    577  N   PHE A  78      51.569  58.631   7.405  1.00 30.05           N  
ATOM    578  CA  PHE A  78      51.876  58.727   5.982  1.00 30.38           C  
ATOM    579  C   PHE A  78      51.141  59.873   5.290  1.00 30.59           C  
ATOM    580  O   PHE A  78      50.030  60.211   5.662  1.00 32.77           O  
ATOM    581  CB  PHE A  78      51.582  57.407   5.278  1.00 30.36           C  
ATOM    582  CG  PHE A  78      52.335  56.240   5.847  1.00 29.79           C  
ATOM    583  CD1 PHE A  78      51.820  55.535   6.920  1.00 29.13           C  
ATOM    584  CD2 PHE A  78      53.547  55.818   5.293  1.00 28.71           C  
ATOM    585  CE1 PHE A  78      52.476  54.453   7.436  1.00 29.39           C  
ATOM    586  CE2 PHE A  78      54.220  54.725   5.821  1.00 27.35           C  
ATOM    587  CZ  PHE A  78      53.684  54.042   6.889  1.00 27.71           C  
ATOM    588  N   THR A  79      51.780  60.482   4.297  1.00 30.26           N  
ATOM    589  CA  THR A  79      51.165  61.550   3.515  1.00 30.68           C  
ATOM    590  C   THR A  79      50.443  61.047   2.277  1.00 30.61           C  
ATOM    591  O   THR A  79      49.824  61.842   1.558  1.00 32.39           O  
ATOM    592  CB  THR A  79      52.198  62.550   3.069  1.00 31.20           C  
ATOM    593  OG1 THR A  79      53.227  61.846   2.373  1.00 31.26           O  
ATOM    594  CG2 THR A  79      52.880  63.221   4.261  1.00 30.61           C  
ATOM    595  N   MET A  80      50.510  59.754   2.016  1.00 30.00           N  
ATOM    596  CA  MET A  80      49.668  59.136   0.987  1.00 29.34           C  
ATOM    597  C   MET A  80      48.173  59.158   1.360  1.00 29.86           C  
ATOM    598  O   MET A  80      47.793  59.199   2.548  1.00 29.05           O  
ATOM    599  CB  MET A  80      50.127  57.689   0.767  1.00 30.47           C  
ATOM    600  CG  MET A  80      51.547  57.553   0.255  1.00 29.40           C  
ATOM    601  SD  MET A  80      52.155  55.850   0.027  1.00 30.81           S  
ATOM    602  CE  MET A  80      51.067  55.188  -1.254  1.00 30.56           C  
ATOM    603  N   LYS A  81      47.318  59.125   0.344  1.00 29.98           N  
ATOM    604  CA  LYS A  81      45.917  58.797   0.567  1.00 30.20           C  
ATOM    605  C   LYS A  81      45.817  57.509   1.351  1.00 30.06           C  
ATOM    606  O   LYS A  81      46.394  56.496   0.971  1.00 30.55           O  
ATOM    607  CB  LYS A  81      45.125  58.698  -0.743  1.00 29.78           C  
ATOM    608  CG  LYS A  81      43.658  58.297  -0.512  1.00 30.07           C  
ATOM    609  CD  LYS A  81      42.852  58.373  -1.787  1.00 31.06           C  
ATOM    610  CE  LYS A  81      41.519  57.603  -1.670  1.00 32.76           C  
ATOM    611  NZ  LYS A  81      40.809  57.787  -2.969  1.00 35.84           N  
ATOM    612  N   GLY A  82      45.096  57.557   2.468  1.00 29.16           N  
ATOM    613  CA  GLY A  82      45.053  56.461   3.395  1.00 28.59           C  
ATOM    614  C   GLY A  82      43.636  56.010   3.633  1.00 28.40           C  
ATOM    615  O   GLY A  82      42.806  56.793   4.042  1.00 27.99           O  
ATOM    616  N   VAL A  83      43.373  54.741   3.381  1.00 28.63           N  
ATOM    617  CA  VAL A  83      42.064  54.148   3.582  1.00 28.46           C  
ATOM    618  C   VAL A  83      42.168  52.980   4.549  1.00 27.87           C  
ATOM    619  O   VAL A  83      42.803  51.950   4.228  1.00 27.47           O  
ATOM    620  CB  VAL A  83      41.507  53.630   2.255  1.00 28.60           C  
ATOM    621  CG1 VAL A  83      40.114  53.098   2.431  1.00 30.79           C  
ATOM    622  CG2 VAL A  83      41.535  54.744   1.211  1.00 30.36           C  
ATOM    623  N   PRO A  84      41.548  53.113   5.715  1.00 26.31           N  
ATOM    624  CA  PRO A  84      41.491  52.016   6.669  1.00 27.07           C  
ATOM    625  C   PRO A  84      40.343  51.062   6.316  1.00 27.14           C  
ATOM    626  O   PRO A  84      39.313  51.512   5.824  1.00 27.58           O  
ATOM    627  CB  PRO A  84      41.224  52.727   7.999  1.00 26.91           C  
ATOM    628  CG  PRO A  84      40.426  53.922   7.597  1.00 25.63           C  
ATOM    629  CD  PRO A  84      40.821  54.304   6.209  1.00 26.84           C  
ATOM    630  N   LEU A  85      40.571  49.769   6.503  1.00 29.05           N  
ATOM    631  CA  LEU A  85      39.613  48.714   6.157  1.00 29.82           C  
ATOM    632  C   LEU A  85      39.552  47.648   7.231  1.00 30.00           C  
ATOM    633  O   LEU A  85      40.582  47.188   7.731  1.00 30.42           O  
ATOM    634  CB  LEU A  85      40.047  48.023   4.873  1.00 30.26           C  
ATOM    635  CG  LEU A  85      40.131  48.843   3.604  1.00 31.89           C  
ATOM    636  CD1 LEU A  85      40.812  47.968   2.538  1.00 34.70           C  
ATOM    637  CD2 LEU A  85      38.767  49.308   3.151  1.00 33.04           C  
ATOM    638  N   ILE A  86      38.335  47.249   7.576  1.00 30.48           N  
ATOM    639  CA  ILE A  86      38.098  45.990   8.249  1.00 30.81           C  
ATOM    640  C   ILE A  86      37.692  45.052   7.151  1.00 30.96           C  
ATOM    641  O   ILE A  86      36.586  45.153   6.616  1.00 30.41           O  
ATOM    642  CB  ILE A  86      36.965  46.048   9.287  1.00 30.78           C  
ATOM    643  CG1 ILE A  86      37.036  47.303  10.165  1.00 32.43           C  
ATOM    644  CG2 ILE A  86      36.972  44.769  10.109  1.00 30.20           C  
ATOM    645  CD1 ILE A  86      38.091  47.316  11.192  1.00 35.49           C  
ATOM    646  N   ALA A  87      38.597  44.158   6.795  1.00 31.47           N  
ATOM    647  CA  ALA A  87      38.349  43.213   5.733  1.00 31.93           C  
ATOM    648  C   ALA A  87      38.000  41.897   6.377  1.00 32.13           C  
ATOM    649  O   ALA A  87      38.812  41.316   7.098  1.00 33.06           O  
ATOM    650  CB  ALA A  87      39.560  43.086   4.854  1.00 31.69           C  
ATOM    651  N   ILE A  88      36.782  41.445   6.099  1.00 32.32           N  
ATOM    652  CA  ILE A  88      36.199  40.267   6.697  1.00 32.59           C  
ATOM    653  C   ILE A  88      35.840  39.265   5.625  1.00 32.29           C  
ATOM    654  O   ILE A  88      35.078  39.577   4.683  1.00 32.66           O  
ATOM    655  CB  ILE A  88      34.877  40.605   7.411  1.00 32.62           C  
ATOM    656  CG1 ILE A  88      35.044  41.705   8.472  1.00 32.98           C  
ATOM    657  CG2 ILE A  88      34.266  39.312   8.002  1.00 33.41           C  
ATOM    658  CD1 ILE A  88      36.054  41.417   9.564  1.00 33.48           C  
ATOM    659  N   LYS A  89      36.326  38.047   5.777  1.00 32.35           N  
ATOM    660  CA  LYS A  89      35.828  36.978   4.945  1.00 32.96           C  
ATOM    661  C   LYS A  89      34.636  36.333   5.634  1.00 32.33           C  
ATOM    662  O   LYS A  89      34.795  35.565   6.575  1.00 32.37           O  
ATOM    663  CB  LYS A  89      36.898  35.931   4.658  1.00 33.79           C  
ATOM    664  CG  LYS A  89      36.425  34.938   3.654  1.00 35.74           C  
ATOM    665  CD  LYS A  89      37.460  33.910   3.280  1.00 38.31           C  
ATOM    666  CE  LYS A  89      37.014  33.245   1.985  1.00 40.79           C  
ATOM    667  NZ  LYS A  89      37.855  32.062   1.648  1.00 42.67           N  
ATOM    668  N   PHE A  90      33.446  36.676   5.171  1.00 31.63           N  
ATOM    669  CA  PHE A  90      32.223  36.038   5.624  1.00 31.49           C  
ATOM    670  C   PHE A  90      32.127  34.672   4.924  1.00 31.04           C  
ATOM    671  O   PHE A  90      31.698  34.578   3.791  1.00 31.26           O  
ATOM    672  CB  PHE A  90      31.035  36.959   5.318  1.00 31.01           C  
ATOM    673  CG  PHE A  90      30.929  38.165   6.273  1.00 31.43           C  
ATOM    674  CD1 PHE A  90      30.431  38.012   7.565  1.00 32.48           C  
ATOM    675  CD2 PHE A  90      31.307  39.445   5.857  1.00 32.81           C  
ATOM    676  CE1 PHE A  90      30.299  39.116   8.428  1.00 33.58           C  
ATOM    677  CE2 PHE A  90      31.204  40.545   6.716  1.00 31.67           C  
ATOM    678  CZ  PHE A  90      30.694  40.380   7.995  1.00 33.51           C  
ATOM    679  N   LYS A  91      32.577  33.625   5.596  1.00 31.51           N  
ATOM    680  CA  LYS A  91      32.708  32.314   4.968  1.00 32.21           C  
ATOM    681  C   LYS A  91      31.366  31.666   4.658  1.00 32.73           C  
ATOM    682  O   LYS A  91      31.308  30.800   3.813  1.00 31.88           O  
ATOM    683  CB  LYS A  91      33.525  31.373   5.842  1.00 32.76           C  
ATOM    684  CG  LYS A  91      35.020  31.752   5.887  1.00 35.08           C  
ATOM    685  CD  LYS A  91      35.764  31.041   6.998  1.00 35.68           C  
ATOM    686  CE  LYS A  91      37.046  30.420   6.503  1.00 36.48           C  
ATOM    687  NZ  LYS A  91      37.829  29.835   7.625  1.00 39.19           N  
ATOM    688  N   GLN A  92      30.309  32.080   5.354  1.00 32.59           N  
ATOM    689  CA  GLN A  92      28.961  31.573   5.099  1.00 33.26           C  
ATOM    690  C   GLN A  92      28.542  31.799   3.665  1.00 33.11           C  
ATOM    691  O   GLN A  92      27.938  30.933   3.070  1.00 33.87           O  
ATOM    692  CB  GLN A  92      27.905  32.244   5.994  1.00 32.86           C  
ATOM    693  CG  GLN A  92      27.949  31.817   7.415  1.00 32.81           C  
ATOM    694  CD  GLN A  92      26.748  32.288   8.239  1.00 32.06           C  
ATOM    695  OE1 GLN A  92      25.693  32.659   7.698  1.00 32.62           O  
ATOM    696  NE2 GLN A  92      26.903  32.229   9.560  1.00 29.73           N  
ATOM    697  N   VAL A  93      28.851  32.979   3.135  1.00 33.49           N  
ATOM    698  CA  VAL A  93      28.568  33.336   1.736  1.00 34.29           C  
ATOM    699  C   VAL A  93      29.829  33.336   0.829  1.00 34.71           C  
ATOM    700  O   VAL A  93      29.768  33.745  -0.348  1.00 33.88           O  
ATOM    701  CB  VAL A  93      27.878  34.712   1.684  1.00 34.38           C  
ATOM    702  CG1 VAL A  93      26.499  34.635   2.330  1.00 34.67           C  
ATOM    703  CG2 VAL A  93      28.706  35.788   2.421  1.00 34.94           C  
ATOM    704  N   HIS A  94      30.953  32.882   1.384  1.00 34.86           N  
ATOM    705  CA  HIS A  94      32.220  32.762   0.651  1.00 36.56           C  
ATOM    706  C   HIS A  94      32.650  34.091   0.041  1.00 36.27           C  
ATOM    707  O   HIS A  94      33.049  34.157  -1.113  1.00 37.45           O  
ATOM    708  CB  HIS A  94      32.124  31.652  -0.395  1.00 37.52           C  
ATOM    709  CG  HIS A  94      31.552  30.393   0.164  1.00 39.06           C  
ATOM    710  ND1 HIS A  94      32.002  29.847   1.351  1.00 43.57           N  
ATOM    711  CD2 HIS A  94      30.503  29.638  -0.223  1.00 40.88           C  
ATOM    712  CE1 HIS A  94      31.280  28.777   1.643  1.00 42.03           C  
ATOM    713  NE2 HIS A  94      30.373  28.621   0.696  1.00 41.41           N  
ATOM    714  N   GLU A  95      32.586  35.138   0.858  1.00 36.38           N  
ATOM    715  CA  GLU A  95      32.733  36.516   0.402  1.00 36.37           C  
ATOM    716  C   GLU A  95      33.653  37.360   1.266  1.00 35.34           C  
ATOM    717  O   GLU A  95      33.477  37.435   2.484  1.00 35.09           O  
ATOM    718  CB  GLU A  95      31.375  37.178   0.465  1.00 37.26           C  
ATOM    719  CG  GLU A  95      30.742  37.507  -0.851  1.00 40.12           C  
ATOM    720  CD  GLU A  95      29.806  38.689  -0.726  1.00 44.54           C  
ATOM    721  OE1 GLU A  95      28.840  38.582   0.074  1.00 47.07           O  
ATOM    722  OE2 GLU A  95      30.037  39.716  -1.414  1.00 46.18           O  
ATOM    723  N   TRP A  96      34.590  38.039   0.622  1.00 33.75           N  
ATOM    724  CA  TRP A  96      35.342  39.111   1.262  1.00 33.38           C  
ATOM    725  C   TRP A  96      34.531  40.401   1.186  1.00 32.81           C  
ATOM    726  O   TRP A  96      34.118  40.818   0.103  1.00 33.56           O  
ATOM    727  CB  TRP A  96      36.693  39.308   0.582  1.00 32.75           C  
ATOM    728  CG  TRP A  96      37.672  38.264   0.909  1.00 31.88           C  
ATOM    729  CD1 TRP A  96      37.961  37.166   0.159  1.00 30.60           C  
ATOM    730  CD2 TRP A  96      38.505  38.181   2.083  1.00 30.00           C  
ATOM    731  NE1 TRP A  96      38.925  36.406   0.778  1.00 31.42           N  
ATOM    732  CE2 TRP A  96      39.289  37.015   1.954  1.00 31.44           C  
ATOM    733  CE3 TRP A  96      38.674  38.976   3.219  1.00 30.38           C  
ATOM    734  CZ2 TRP A  96      40.221  36.616   2.926  1.00 32.16           C  
ATOM    735  CZ3 TRP A  96      39.608  38.589   4.190  1.00 29.12           C  
ATOM    736  CH2 TRP A  96      40.361  37.413   4.037  1.00 31.68           C  
ATOM    737  N   ARG A  97      34.250  40.979   2.346  1.00 32.64           N  
ATOM    738  CA  ARG A  97      33.597  42.278   2.465  1.00 32.37           C  
ATOM    739  C   ARG A  97      34.446  43.197   3.345  1.00 31.85           C  
ATOM    740  O   ARG A  97      35.223  42.734   4.170  1.00 32.03           O  
ATOM    741  CB  ARG A  97      32.187  42.128   3.054  1.00 32.89           C  
ATOM    742  CG  ARG A  97      31.318  41.093   2.315  1.00 33.13           C  
ATOM    743  CD  ARG A  97      29.886  40.982   2.829  1.00 34.35           C  
ATOM    744  NE  ARG A  97      29.085  42.182   2.570  1.00 35.12           N  
ATOM    745  CZ  ARG A  97      28.337  42.397   1.489  1.00 35.94           C  
ATOM    746  NH1 ARG A  97      28.253  41.505   0.520  1.00 37.11           N  
ATOM    747  NH2 ARG A  97      27.656  43.525   1.377  1.00 36.03           N  
ATOM    748  N   VAL A  98      34.290  44.503   3.151  1.00 31.60           N  
ATOM    749  CA  VAL A  98      35.042  45.498   3.907  1.00 31.39           C  
ATOM    750  C   VAL A  98      34.115  46.572   4.469  1.00 30.96           C  
ATOM    751  O   VAL A  98      33.070  46.913   3.895  1.00 30.90           O  
ATOM    752  CB  VAL A  98      36.125  46.202   3.060  1.00 30.62           C  
ATOM    753  CG1 VAL A  98      37.190  45.187   2.549  1.00 30.99           C  
ATOM    754  CG2 VAL A  98      35.497  46.976   1.924  1.00 31.69           C  
ATOM    755  N   LEU A  99      34.535  47.098   5.597  1.00 31.29           N  
ATOM    756  CA  LEU A  99      33.953  48.269   6.202  1.00 30.78           C  
ATOM    757  C   LEU A  99      35.097  49.278   6.437  1.00 31.08           C  
ATOM    758  O   LEU A  99      36.181  48.912   6.906  1.00 29.97           O  
ATOM    759  CB  LEU A  99      33.247  47.859   7.490  1.00 31.35           C  
ATOM    760  CG  LEU A  99      32.527  48.950   8.292  1.00 30.81           C  
ATOM    761  CD1 LEU A  99      31.361  48.346   9.050  1.00 33.43           C  
ATOM    762  CD2 LEU A  99      33.495  49.626   9.259  1.00 33.14           C  
ATOM    763  N   VAL A 100      34.867  50.529   6.045  1.00 31.82           N  
ATOM    764  CA  VAL A 100      35.820  51.617   6.283  1.00 32.25           C  
ATOM    765  C   VAL A 100      35.406  52.260   7.602  1.00 32.76           C  
ATOM    766  O   VAL A 100      34.337  52.831   7.669  1.00 32.45           O  
ATOM    767  CB  VAL A 100      35.774  52.680   5.179  1.00 32.62           C  
ATOM    768  CG1 VAL A 100      36.728  53.850   5.489  1.00 31.75           C  
ATOM    769  CG2 VAL A 100      36.090  52.082   3.827  1.00 33.45           C  
ATOM    770  N   PRO A 101      36.216  52.143   8.652  1.00 32.88           N  
ATOM    771  CA  PRO A 101      35.866  52.729   9.957  1.00 33.81           C  
ATOM    772  C   PRO A 101      35.867  54.277   9.956  1.00 34.54           C  
ATOM    773  O   PRO A 101      36.722  54.881   9.339  1.00 34.48           O  
ATOM    774  CB  PRO A 101      36.940  52.159  10.888  1.00 33.60           C  
ATOM    775  CG  PRO A 101      38.093  51.829   9.998  1.00 33.54           C  
ATOM    776  CD  PRO A 101      37.499  51.429   8.692  1.00 33.15           C  
ATOM    777  N   GLU A 102      34.883  54.892  10.605  1.00 35.73           N  
ATOM    778  CA  GLU A 102      34.804  56.350  10.710  1.00 36.83           C  
ATOM    779  C   GLU A 102      35.898  56.873  11.613  1.00 35.72           C  
ATOM    780  O   GLU A 102      36.504  57.903  11.340  1.00 35.28           O  
ATOM    781  CB  GLU A 102      33.493  56.796  11.350  1.00 37.85           C  
ATOM    782  CG  GLU A 102      32.255  56.670  10.499  1.00 43.48           C  
ATOM    783  CD  GLU A 102      30.987  56.895  11.313  1.00 48.44           C  
ATOM    784  OE1 GLU A 102      31.007  57.758  12.240  1.00 52.21           O  
ATOM    785  OE2 GLU A 102      29.983  56.193  11.032  1.00 53.18           O  
ATOM    786  N   LYS A 103      36.090  56.151  12.707  1.00 35.62           N  
ATOM    787  CA  LYS A 103      36.965  56.547  13.807  1.00 35.77           C  
ATOM    788  C   LYS A 103      37.280  55.328  14.691  1.00 35.58           C  
ATOM    789  O   LYS A 103      36.724  54.251  14.485  1.00 36.01           O  
ATOM    790  CB  LYS A 103      36.269  57.641  14.630  1.00 35.41           C  
ATOM    791  CG  LYS A 103      35.167  57.114  15.520  1.00 36.82           C  
ATOM    792  CD  LYS A 103      34.402  58.237  16.210  1.00 39.62           C  
ATOM    793  CE  LYS A 103      33.162  57.687  16.894  1.00 39.75           C  
ATOM    794  NZ  LYS A 103      32.503  58.739  17.760  1.00 43.94           N  
ATOM    795  N   ALA A 104      38.155  55.507  15.677  1.00 35.58           N  
ATOM    796  CA  ALA A 104      38.542  54.433  16.571  1.00 36.23           C  
ATOM    797  C   ALA A 104      37.404  54.226  17.581  1.00 37.00           C  
ATOM    798  O   ALA A 104      37.184  55.058  18.436  1.00 36.96           O  
ATOM    799  CB  ALA A 104      39.835  54.771  17.292  1.00 35.75           C  
ATOM    800  N   GLU A 105      36.671  53.133  17.407  1.00 37.97           N  
ATOM    801  CA  GLU A 105      35.610  52.704  18.310  1.00 38.76           C  
ATOM    802  C   GLU A 105      35.398  51.200  18.102  1.00 39.33           C  
ATOM    803  O   GLU A 105      35.938  50.600  17.150  1.00 38.87           O  
ATOM    804  CB  GLU A 105      34.305  53.462  18.018  1.00 39.06           C  
ATOM    805  CG  GLU A 105      33.831  53.376  16.565  1.00 41.05           C  
ATOM    806  CD  GLU A 105      32.564  54.183  16.290  1.00 43.63           C  
ATOM    807  OE1 GLU A 105      31.940  54.679  17.259  1.00 48.10           O  
ATOM    808  OE2 GLU A 105      32.188  54.322  15.104  1.00 45.08           O  
ATOM    809  N   ASP A 106      34.615  50.592  18.984  1.00 39.96           N  
ATOM    810  CA  ASP A 106      34.168  49.205  18.794  1.00 40.37           C  
ATOM    811  C   ASP A 106      33.234  49.188  17.582  1.00 40.00           C  
ATOM    812  O   ASP A 106      32.375  50.070  17.443  1.00 40.36           O  
ATOM    813  CB  ASP A 106      33.382  48.682  20.005  1.00 40.53           C  
ATOM    814  CG  ASP A 106      34.254  48.317  21.201  1.00 41.77           C  
ATOM    815  OD1 ASP A 106      35.499  48.228  21.109  1.00 42.26           O  
ATOM    816  OD2 ASP A 106      33.735  48.066  22.306  1.00 46.35           O  
ATOM    817  N   ILE A 107      33.377  48.190  16.715  1.00 39.66           N  
ATOM    818  CA  ILE A 107      32.540  48.085  15.518  1.00 39.36           C  
ATOM    819  C   ILE A 107      32.051  46.652  15.280  1.00 39.10           C  
ATOM    820  O   ILE A 107      32.835  45.711  15.250  1.00 38.19           O  
ATOM    821  CB  ILE A 107      33.289  48.594  14.265  1.00 39.73           C  
ATOM    822  CG1 ILE A 107      33.864  50.009  14.477  1.00 39.76           C  
ATOM    823  CG2 ILE A 107      32.344  48.586  13.066  1.00 40.58           C  
ATOM    824  CD1 ILE A 107      34.621  50.556  13.261  1.00 40.39           C  
ATOM    825  N   ILE A 108      30.748  46.490  15.101  1.00 39.01           N  
ATOM    826  CA  ILE A 108      30.203  45.193  14.717  1.00 39.18           C  
ATOM    827  C   ILE A 108      29.999  45.197  13.206  1.00 38.70           C  
ATOM    828  O   ILE A 108      29.162  45.912  12.677  1.00 37.83           O  
ATOM    829  CB  ILE A 108      28.895  44.879  15.487  1.00 39.40           C  
ATOM    830  CG1 ILE A 108      29.218  44.612  16.965  1.00 40.45           C  
ATOM    831  CG2 ILE A 108      28.187  43.666  14.879  1.00 39.76           C  
ATOM    832  CD1 ILE A 108      28.001  44.671  17.923  1.00 41.45           C  
ATOM    833  N   VAL A 109      30.809  44.418  12.505  1.00 38.16           N  
ATOM    834  CA  VAL A 109      30.710  44.350  11.057  1.00 37.68           C  
ATOM    835  C   VAL A 109      29.720  43.250  10.671  1.00 38.05           C  
ATOM    836  O   VAL A 109      29.853  42.132  11.110  1.00 38.18           O  
ATOM    837  CB  VAL A 109      32.107  44.121  10.440  1.00 37.25           C  
ATOM    838  CG1 VAL A 109      32.048  44.180   8.935  1.00 36.85           C  
ATOM    839  CG2 VAL A 109      33.103  45.170  10.985  1.00 36.58           C  
ATOM    840  N   THR A 110      28.714  43.596   9.872  1.00 38.99           N  
ATOM    841  CA  THR A 110      27.738  42.643   9.320  1.00 39.85           C  
ATOM    842  C   THR A 110      27.749  42.686   7.793  1.00 40.18           C  
ATOM    843  O   THR A 110      28.503  43.459   7.198  1.00 39.63           O  
ATOM    844  CB  THR A 110      26.317  42.998   9.812  1.00 39.96           C  
ATOM    845  OG1 THR A 110      25.833  44.139   9.091  1.00 41.52           O  
ATOM    846  CG2 THR A 110      26.320  43.473  11.263  1.00 40.14           C  
ATOM    847  N   ILE A 111      26.891  41.891   7.144  1.00 40.95           N  
ATOM    848  CA  ILE A 111      26.702  42.014   5.688  1.00 41.83           C  
ATOM    849  C   ILE A 111      26.092  43.378   5.353  1.00 42.00           C  
ATOM    850  O   ILE A 111      26.432  43.981   4.329  1.00 41.80           O  
ATOM    851  CB  ILE A 111      25.805  40.859   5.098  1.00 42.30           C  
ATOM    852  CG1 ILE A 111      26.668  39.724   4.532  1.00 44.30           C  
ATOM    853  CG2 ILE A 111      24.901  41.366   3.974  1.00 43.10           C  
ATOM    854  CD1 ILE A 111      27.170  38.763   5.582  1.00 44.40           C  
ATOM    855  N   ASP A 112      25.180  43.839   6.208  1.00 42.33           N  
ATOM    856  CA  ASP A 112      24.437  45.069   5.976  1.00 42.94           C  
ATOM    857  C   ASP A 112      25.249  46.332   5.970  1.00 42.51           C  
ATOM    858  O   ASP A 112      24.907  47.243   5.230  1.00 43.19           O  
ATOM    859  CB  ASP A 112      23.325  45.239   7.016  1.00 43.62           C  
ATOM    860  CG  ASP A 112      22.242  44.222   6.848  1.00 46.25           C  
ATOM    861  OD1 ASP A 112      21.814  44.033   5.699  1.00 50.55           O  
ATOM    862  OD2 ASP A 112      21.784  43.543   7.788  1.00 52.45           O  
ATOM    863  N   ASN A 113      26.282  46.415   6.814  1.00 41.65           N  
ATOM    864  CA  ASN A 113      27.113  47.621   6.890  1.00 40.62           C  
ATOM    865  C   ASN A 113      28.508  47.484   6.217  1.00 39.67           C  
ATOM    866  O   ASN A 113      29.369  48.351   6.360  1.00 38.87           O  
ATOM    867  CB  ASN A 113      27.229  48.106   8.346  1.00 40.32           C  
ATOM    868  CG  ASN A 113      28.078  47.192   9.221  1.00 41.00           C  
ATOM    869  OD1 ASN A 113      28.665  46.212   8.746  1.00 40.25           O  
ATOM    870  ND2 ASN A 113      28.171  47.531  10.509  1.00 37.10           N  
ATOM    871  N   SER A 114      28.712  46.382   5.503  1.00 38.69           N  
ATOM    872  CA  SER A 114      29.916  46.189   4.717  1.00 37.48           C  
ATOM    873  C   SER A 114      29.565  46.159   3.242  1.00 37.13           C  
ATOM    874  O   SER A 114      28.397  46.035   2.863  1.00 37.60           O  
ATOM    875  CB  SER A 114      30.620  44.899   5.119  1.00 37.01           C  
ATOM    876  OG  SER A 114      29.758  43.779   4.968  1.00 36.17           O  
ATOM    877  N   ILE A 115      30.581  46.267   2.402  1.00 36.40           N  
ATOM    878  CA  ILE A 115      30.406  46.095   0.953  1.00 36.55           C  
ATOM    879  C   ILE A 115      31.352  45.025   0.429  1.00 36.06           C  
ATOM    880  O   ILE A 115      32.370  44.745   1.027  1.00 35.26           O  
ATOM    881  CB  ILE A 115      30.614  47.428   0.193  1.00 36.09           C  
ATOM    882  CG1 ILE A 115      32.058  47.918   0.328  1.00 37.41           C  
ATOM    883  CG2 ILE A 115      29.611  48.500   0.687  1.00 36.80           C  
ATOM    884  CD1 ILE A 115      32.334  49.147  -0.483  1.00 37.62           C  
ATOM    885  N   PRO A 116      31.020  44.434  -0.698  1.00 37.33           N  
ATOM    886  CA  PRO A 116      31.940  43.507  -1.367  1.00 37.47           C  
ATOM    887  C   PRO A 116      33.255  44.208  -1.640  1.00 37.60           C  
ATOM    888  O   PRO A 116      33.225  45.399  -1.948  1.00 37.85           O  
ATOM    889  CB  PRO A 116      31.234  43.198  -2.686  1.00 37.61           C  
ATOM    890  CG  PRO A 116      29.790  43.555  -2.471  1.00 37.64           C  
ATOM    891  CD  PRO A 116      29.747  44.602  -1.431  1.00 37.43           C  
ATOM    892  N   ILE A 117      34.379  43.510  -1.530  1.00 37.50           N  
ATOM    893  CA  ILE A 117      35.673  44.158  -1.692  1.00 37.41           C  
ATOM    894  C   ILE A 117      35.869  44.715  -3.131  1.00 38.15           C  
ATOM    895  O   ILE A 117      36.519  45.740  -3.321  1.00 37.48           O  
ATOM    896  CB  ILE A 117      36.831  43.213  -1.250  1.00 37.70           C  
ATOM    897  CG1 ILE A 117      38.103  44.030  -0.986  1.00 35.72           C  
ATOM    898  CG2 ILE A 117      37.110  42.098  -2.289  1.00 36.92           C  
ATOM    899  CD1 ILE A 117      39.241  43.191  -0.504  1.00 37.29           C  
ATOM    900  N   GLU A 118      35.277  44.071  -4.134  1.00 38.71           N  
ATOM    901  CA  GLU A 118      35.365  44.578  -5.514  1.00 39.71           C  
ATOM    902  C   GLU A 118      34.649  45.912  -5.688  1.00 39.17           C  
ATOM    903  O   GLU A 118      35.036  46.699  -6.539  1.00 39.58           O  
ATOM    904  CB  GLU A 118      34.864  43.533  -6.534  1.00 41.04           C  
ATOM    905  CG  GLU A 118      35.708  42.251  -6.542  1.00 44.28           C  
ATOM    906  CD  GLU A 118      37.022  42.377  -7.322  1.00 50.87           C  
ATOM    907  OE1 GLU A 118      37.057  43.134  -8.341  1.00 55.03           O  
ATOM    908  OE2 GLU A 118      38.023  41.711  -6.917  1.00 52.99           O  
ATOM    909  N   ASP A 119      33.630  46.177  -4.873  1.00 38.82           N  
ATOM    910  CA  ASP A 119      33.006  47.501  -4.827  1.00 39.12           C  
ATOM    911  C   ASP A 119      33.959  48.560  -4.278  1.00 38.99           C  
ATOM    912  O   ASP A 119      33.994  49.671  -4.786  1.00 38.01           O  
ATOM    913  CB  ASP A 119      31.705  47.478  -4.015  1.00 39.02           C  
ATOM    914  CG  ASP A 119      30.586  46.727  -4.732  1.00 40.61           C  
ATOM    915  OD1 ASP A 119      30.780  46.268  -5.883  1.00 42.07           O  
ATOM    916  OD2 ASP A 119      29.485  46.533  -4.215  1.00 44.71           O  
ATOM    917  N   LEU A 120      34.716  48.225  -3.240  1.00 39.24           N  
ATOM    918  CA  LEU A 120      35.730  49.149  -2.749  1.00 39.96           C  
ATOM    919  C   LEU A 120      36.722  49.496  -3.852  1.00 40.39           C  
ATOM    920  O   LEU A 120      37.064  50.666  -4.028  1.00 40.46           O  
ATOM    921  CB  LEU A 120      36.466  48.563  -1.549  1.00 40.02           C  
ATOM    922  CG  LEU A 120      37.673  49.391  -1.117  1.00 41.18           C  
ATOM    923  CD1 LEU A 120      37.228  50.667  -0.393  1.00 41.64           C  
ATOM    924  CD2 LEU A 120      38.585  48.579  -0.272  1.00 43.72           C  
ATOM    925  N   PHE A 121      37.205  48.478  -4.561  1.00 40.83           N  
ATOM    926  CA  PHE A 121      38.134  48.667  -5.671  1.00 42.55           C  
ATOM    927  C   PHE A 121      37.539  49.581  -6.736  1.00 43.68           C  
ATOM    928  O   PHE A 121      38.250  50.396  -7.313  1.00 44.25           O  
ATOM    929  CB  PHE A 121      38.528  47.331  -6.328  1.00 42.58           C  
ATOM    930  CG  PHE A 121      39.288  46.384  -5.433  1.00 41.95           C  
ATOM    931  CD1 PHE A 121      40.139  46.846  -4.435  1.00 41.89           C  
ATOM    932  CD2 PHE A 121      39.187  45.013  -5.631  1.00 40.74           C  
ATOM    933  CE1 PHE A 121      40.861  45.960  -3.640  1.00 41.75           C  
ATOM    934  CE2 PHE A 121      39.894  44.119  -4.827  1.00 41.73           C  
ATOM    935  CZ  PHE A 121      40.731  44.597  -3.825  1.00 41.60           C  
ATOM    936  N   LYS A 122      36.234  49.474  -6.967  1.00 45.20           N  
ATOM    937  CA  LYS A 122      35.555  50.329  -7.937  1.00 46.63           C  
ATOM    938  C   LYS A 122      35.503  51.778  -7.475  1.00 47.10           C  
ATOM    939  O   LYS A 122      35.760  52.674  -8.261  1.00 47.26           O  
ATOM    940  CB  LYS A 122      34.153  49.808  -8.262  1.00 47.02           C  
ATOM    941  CG  LYS A 122      34.160  48.636  -9.251  1.00 50.03           C  
ATOM    942  CD  LYS A 122      32.742  48.262  -9.750  1.00 53.33           C  
ATOM    943  CE  LYS A 122      32.451  46.746  -9.666  1.00 55.42           C  
ATOM    944  NZ  LYS A 122      32.403  46.088 -11.015  1.00 56.14           N  
ATOM    945  N   ILE A 123      35.191  51.999  -6.202  1.00 47.61           N  
ATOM    946  CA  ILE A 123      35.179  53.336  -5.632  1.00 48.28           C  
ATOM    947  C   ILE A 123      36.534  54.024  -5.790  1.00 49.18           C  
ATOM    948  O   ILE A 123      36.580  55.219  -6.058  1.00 49.39           O  
ATOM    949  CB  ILE A 123      34.773  53.300  -4.133  1.00 48.11           C  
ATOM    950  CG1 ILE A 123      33.277  52.995  -3.997  1.00 47.95           C  
ATOM    951  CG2 ILE A 123      35.116  54.628  -3.442  1.00 47.38           C  
ATOM    952  CD1 ILE A 123      32.822  52.583  -2.566  1.00 47.49           C  
ATOM    953  N   LEU A 124      37.627  53.282  -5.632  1.00 50.31           N  
ATOM    954  CA  LEU A 124      38.959  53.868  -5.738  1.00 51.66           C  
ATOM    955  C   LEU A 124      39.268  54.244  -7.197  1.00 53.57           C  
ATOM    956  O   LEU A 124      39.819  55.312  -7.457  1.00 53.88           O  
ATOM    957  CB  LEU A 124      40.016  52.925  -5.160  1.00 50.77           C  
ATOM    958  CG  LEU A 124      39.827  52.578  -3.679  1.00 49.98           C  
ATOM    959  CD1 LEU A 124      40.740  51.447  -3.267  1.00 49.28           C  
ATOM    960  CD2 LEU A 124      40.031  53.800  -2.773  1.00 49.37           C  
ATOM    961  N   GLU A 125      38.875  53.379  -8.134  1.00 55.76           N  
ATOM    962  CA  GLU A 125      39.045  53.607  -9.580  1.00 57.74           C  
ATOM    963  C   GLU A 125      38.228  54.816 -10.071  1.00 58.57           C  
ATOM    964  O   GLU A 125      38.725  55.634 -10.840  1.00 58.68           O  
ATOM    965  CB  GLU A 125      38.703  52.309 -10.373  1.00 58.21           C  
ATOM    966  CG  GLU A 125      37.832  52.441 -11.634  1.00 60.37           C  
ATOM    967  CD  GLU A 125      36.682  51.420 -11.691  1.00 63.48           C  
ATOM    968  OE1 GLU A 125      36.970  50.192 -11.638  1.00 66.16           O  
ATOM    969  OE2 GLU A 125      35.492  51.837 -11.792  1.00 63.38           O  
ATOM    970  N   LYS A 126      36.982  54.914  -9.614  1.00 59.89           N  
ATOM    971  CA  LYS A 126      36.083  56.008  -9.983  1.00 60.96           C  
ATOM    972  C   LYS A 126      36.617  57.365  -9.542  1.00 62.10           C  
ATOM    973  O   LYS A 126      36.314  58.384 -10.168  1.00 61.88           O  
ATOM    974  CB  LYS A 126      34.687  55.796  -9.376  1.00 61.06           C  
ATOM    975  CG  LYS A 126      33.739  54.975 -10.254  1.00 61.37           C  
ATOM    976  CD  LYS A 126      32.266  55.277  -9.939  1.00 61.77           C  
ATOM    977  CE  LYS A 126      31.775  56.589 -10.581  1.00 61.81           C  
ATOM    978  NZ  LYS A 126      31.290  57.555  -9.553  1.00 60.28           N  
ATOM    979  N   ARG A 127      37.393  57.376  -8.460  1.00 63.48           N  
ATOM    980  CA  ARG A 127      38.021  58.605  -7.974  1.00 64.95           C  
ATOM    981  C   ARG A 127      39.171  59.046  -8.896  1.00 65.97           C  
ATOM    982  O   ARG A 127      39.364  60.246  -9.107  1.00 66.24           O  
ATOM    983  CB  ARG A 127      38.510  58.436  -6.524  1.00 64.95           C  
ATOM    984  CG  ARG A 127      39.094  59.707  -5.883  1.00 65.39           C  
ATOM    985  CD  ARG A 127      38.178  60.938  -5.900  1.00 66.18           C  
ATOM    986  NE  ARG A 127      36.854  60.647  -5.354  1.00 66.83           N  
ATOM    987  CZ  ARG A 127      35.796  61.452  -5.448  1.00 67.40           C  
ATOM    988  NH1 ARG A 127      35.881  62.629  -6.063  1.00 67.86           N  
ATOM    989  NH2 ARG A 127      34.637  61.077  -4.919  1.00 67.08           N  
ATOM    990  N   ILE A 128      39.914  58.081  -9.448  1.00 67.29           N  
ATOM    991  CA  ILE A 128      40.992  58.379 -10.408  1.00 68.20           C  
ATOM    992  C   ILE A 128      40.492  59.261 -11.572  1.00 69.16           C  
ATOM    993  O   ILE A 128      41.221  60.135 -12.046  1.00 69.15           O  
ATOM    994  CB  ILE A 128      41.654  57.072 -10.956  1.00 68.32           C  
ATOM    995  CG1 ILE A 128      42.171  56.166  -9.817  1.00 68.61           C  
ATOM    996  CG2 ILE A 128      42.787  57.404 -11.932  1.00 68.11           C  
ATOM    997  CD1 ILE A 128      43.205  56.788  -8.900  1.00 68.61           C  
ATOM    998  N   GLU A 129      39.252  59.019 -12.019  1.00 70.33           N  
ATOM    999  CA  GLU A 129      38.543  59.885 -12.982  1.00 71.06           C  
ATOM   1000  C   GLU A 129      39.342  60.154 -14.256  1.00 71.39           C  
ATOM   1001  O   GLU A 129      39.160  59.472 -15.267  1.00 72.20           O  
ATOM   1002  CB  GLU A 129      38.142  61.212 -12.332  1.00 71.22           C  
ATOM   1003  CG  GLU A 129      36.978  61.087 -11.358  1.00 72.28           C  
ATOM   1004  CD  GLU A 129      36.623  62.399 -10.680  1.00 74.52           C  
ATOM   1005  OE1 GLU A 129      37.325  63.411 -10.926  1.00 76.34           O  
ATOM   1006  OE2 GLU A 129      35.641  62.415  -9.897  1.00 74.56           O  
TER    1007      GLU A 129                                                      
END
MOLECULE T0495_5_143.pdb
ATOM      1  N   LEU     5      45.969  23.478   3.252  1.00 38.14           N  
ATOM      2  CA  LEU     5      46.490  24.710   3.921  1.00 38.30           C  
ATOM      3  C   LEU     5      46.362  24.598   5.434  1.00 38.70           C  
ATOM      4  O   LEU     5      45.265  24.375   5.947  1.00 38.88           O  
ATOM      5  CB  LEU     5      45.724  25.958   3.463  1.00 37.92           C  
ATOM      6  CG  LEU     5      45.678  26.334   1.977  1.00 37.39           C  
ATOM      7  CD1 LEU     5      45.154  27.777   1.825  1.00 35.18           C  
ATOM      8  CD2 LEU     5      47.048  26.165   1.302  1.00 36.39           C  
ATOM      9  N   ASP     6      47.483  24.733   6.143  1.00 39.19           N  
ATOM     10  CA  ASP     6      47.446  25.021   7.581  1.00 39.51           C  
ATOM     11  C   ASP     6      47.751  26.510   7.753  1.00 39.87           C  
ATOM     12  O   ASP     6      48.840  26.914   8.171  1.00 39.97           O  
ATOM     13  CB  ASP     6      48.340  24.100   8.452  1.00 39.40           C  
ATOM     14  CG  ASP     6      49.600  23.620   7.748  1.00 39.37           C  
ATOM     15  OD1 ASP     6      50.647  23.504   8.421  1.00 38.77           O  
ATOM     16  OD2 ASP     6      49.544  23.326   6.537  1.00 39.57           O  
ATOM     17  N   LEU     7      46.768  27.313   7.358  1.00 40.08           N  
ATOM     18  CA  LEU     7      46.722  28.728   7.677  1.00 40.61           C  
ATOM     19  C   LEU     7      45.600  28.932   8.688  1.00 41.15           C  
ATOM     20  O   LEU     7      44.546  28.297   8.592  1.00 40.41           O  
ATOM     21  CB  LEU     7      46.399  29.569   6.436  1.00 40.38           C  
ATOM     22  CG  LEU     7      47.368  29.613   5.253  1.00 40.99           C  
ATOM     23  CD1 LEU     7      46.776  30.487   4.151  1.00 40.42           C  
ATOM     24  CD2 LEU     7      48.755  30.110   5.651  1.00 40.43           C  
ATOM     25  N   GLN     8      45.822  29.829   9.645  1.00 42.24           N  
ATOM     26  CA  GLN     8      44.777  30.227  10.594  0.50 42.53           C  
ATOM     28  C   GLN     8      43.743  31.071   9.854  1.00 42.85           C  
ATOM     29  O   GLN     8      44.022  31.579   8.770  1.00 42.28           O  
ATOM     30  CB  GLN     8      45.380  31.029  11.755  0.50 42.65           C  
ATOM     32  CG  GLN     8      46.000  30.178  12.865  0.50 42.48           C  
ATOM     34  CD  GLN     8      46.979  30.965  13.716  0.50 41.89           C  
ATOM     36  OE1 GLN     8      47.364  32.081  13.364  0.50 41.95           O  
ATOM     38  NE2 GLN     8      47.383  30.391  14.844  0.50 42.22           N  
ATOM     40  N   PRO     9      42.535  31.223  10.429  1.00 43.65           N  
ATOM     41  CA  PRO     9      41.490  32.001   9.715  1.00 44.43           C  
ATOM     42  C   PRO     9      41.901  33.416   9.236  1.00 44.22           C  
ATOM     43  O   PRO     9      41.615  33.806   8.091  1.00 43.49           O  
ATOM     44  CB  PRO     9      40.349  32.054  10.740  1.00 44.78           C  
ATOM     45  CG  PRO     9      40.523  30.818  11.560  1.00 44.24           C  
ATOM     46  CD  PRO     9      42.019  30.661  11.700  1.00 43.75           C  
ATOM     47  N   GLY    10      42.574  34.186  10.086  1.00 44.09           N  
ATOM     48  CA  GLY    10      43.013  35.529   9.648  1.00 43.34           C  
ATOM     49  C   GLY    10      44.032  35.469   8.522  1.00 42.61           C  
ATOM     50  O   GLY    10      44.066  36.326   7.604  1.00 41.75           O  
ATOM     51  N   GLN    11      44.888  34.449   8.568  1.00 41.40           N  
ATOM     52  CA  GLN    11      45.884  34.302   7.538  1.00 40.04           C  
ATOM     53  C   GLN    11      45.242  33.961   6.211  1.00 38.83           C  
ATOM     54  O   GLN    11      45.787  34.295   5.169  1.00 39.89           O  
ATOM     55  CB  GLN    11      46.923  33.237   7.912  1.00 40.06           C  
ATOM     56  CG  GLN    11      47.873  33.655   9.035  1.00 40.33           C  
ATOM     57  CD  GLN    11      48.812  32.554   9.432  1.00 39.18           C  
ATOM     58  OE1 GLN    11      48.393  31.427   9.692  1.00 35.18           O  
ATOM     59  NE2 GLN    11      50.104  32.878   9.507  1.00 42.19           N  
ATOM     60  N   ARG    12      44.143  33.225   6.264  1.00 38.76           N  
ATOM     61  CA  ARG    12      43.395  32.852   5.071  1.00 37.01           C  
ATOM     62  C   ARG    12      42.862  34.084   4.372  1.00 34.65           C  
ATOM     63  O   ARG    12      43.071  34.264   3.181  1.00 34.81           O  
ATOM     64  CB  ARG    12      42.259  31.896   5.463  1.00 37.53           C  
ATOM     65  CG  ARG    12      42.702  30.436   5.681  1.00 38.59           C  
ATOM     66  CD  ARG    12      41.510  29.554   5.999  1.00 40.97           C  
ATOM     67  NE  ARG    12      41.799  28.128   5.848  1.00 43.25           N  
ATOM     68  CZ  ARG    12      41.525  27.376   4.772  1.00 44.47           C  
ATOM     69  NH1 ARG    12      41.831  26.083   4.792  1.00 45.36           N  
ATOM     70  NH2 ARG    12      40.948  27.879   3.678  1.00 44.66           N  
ATOM     71  N   LEU    13      42.158  34.928   5.123  1.00 32.91           N  
ATOM     72  CA  LEU    13      41.636  36.175   4.576  1.00 32.29           C  
ATOM     73  C   LEU    13      42.781  37.003   3.992  1.00 31.74           C  
ATOM     74  O   LEU    13      42.652  37.507   2.888  1.00 32.08           O  
ATOM     75  CB  LEU    13      40.873  36.994   5.637  1.00 32.92           C  
ATOM     76  CG  LEU    13      39.624  36.366   6.268  1.00 32.94           C  
ATOM     77  CD1 LEU    13      39.141  37.186   7.487  1.00 32.58           C  
ATOM     78  CD2 LEU    13      38.540  36.270   5.227  1.00 33.66           C  
ATOM     79  N   ALA    14      43.911  37.089   4.709  1.00 30.28           N  
ATOM     80  CA  ALA    14      45.002  37.910   4.250  1.00 30.35           C  
ATOM     81  C   ALA    14      45.583  37.382   2.911  1.00 29.01           C  
ATOM     82  O   ALA    14      46.110  38.152   2.106  1.00 29.67           O  
ATOM     83  CB  ALA    14      46.100  38.001   5.295  1.00 28.79           C  
ATOM     84  N   ARG    15      45.564  36.067   2.742  1.00 29.40           N  
ATOM     85  CA  ARG    15      46.005  35.465   1.454  1.00 29.83           C  
ATOM     86  C   ARG    15      45.180  35.916   0.310  1.00 29.24           C  
ATOM     87  O   ARG    15      45.718  36.353  -0.705  1.00 29.13           O  
ATOM     88  CB  ARG    15      46.007  33.936   1.546  1.00 30.37           C  
ATOM     89  CG  ARG    15      46.706  33.192   0.384  1.00 33.54           C  
ATOM     90  CD  ARG    15      46.524  31.724   0.763  1.00 39.34           C  
ATOM     91  NE  ARG    15      47.240  30.768  -0.023  1.00 41.73           N  
ATOM     92  CZ  ARG    15      46.689  29.951  -0.914  1.00 45.31           C  
ATOM     93  NH1 ARG    15      47.475  29.075  -1.533  1.00 45.52           N  
ATOM     94  NH2 ARG    15      45.386  30.002  -1.208  1.00 44.25           N  
ATOM     95  N   GLY    16      43.861  35.891   0.491  1.00 30.12           N  
ATOM     96  CA  GLY    16      42.936  36.343  -0.551  1.00 29.24           C  
ATOM     97  C   GLY    16      43.027  37.801  -0.808  1.00 29.52           C  
ATOM     98  O   GLY    16      43.063  38.242  -1.969  1.00 28.36           O  
ATOM     99  N   VAL    17      43.194  38.586   0.266  1.00 28.25           N  
ATOM    100  CA  VAL    17      43.387  40.014   0.101  1.00 27.59           C  
ATOM    101  C   VAL    17      44.646  40.337  -0.728  1.00 28.51           C  
ATOM    102  O   VAL    17      44.596  41.192  -1.661  1.00 28.26           O  
ATOM    103  CB  VAL    17      43.427  40.759   1.499  1.00 26.92           C  
ATOM    104  CG1 VAL    17      43.811  42.212   1.297  1.00 28.67           C  
ATOM    105  CG2 VAL    17      42.063  40.649   2.219  1.00 28.70           C  
ATOM    106  N   ALA    18      45.763  39.686  -0.367  1.00 28.55           N  
ATOM    107  CA  ALA    18      47.044  39.873  -1.053  1.00 27.98           C  
ATOM    108  C   ALA    18      46.959  39.510  -2.562  1.00 28.27           C  
ATOM    109  O   ALA    18      47.528  40.229  -3.403  1.00 27.57           O  
ATOM    110  CB  ALA    18      48.130  39.095  -0.372  1.00 27.73           C  
ATOM    111  N   ARG    19      46.283  38.412  -2.870  1.00 30.15           N  
ATOM    112  CA  ARG    19      46.061  38.000  -4.298  1.00 30.28           C  
ATOM    113  C   ARG    19      45.359  39.097  -5.014  1.00 30.51           C  
ATOM    114  O   ARG    19      45.758  39.480  -6.116  1.00 31.11           O  
ATOM    115  CB  ARG    19      45.260  36.717  -4.396  1.00 30.44           C  
ATOM    116  CG  ARG    19      45.997  35.514  -3.985  1.00 32.15           C  
ATOM    117  CD  ARG    19      45.114  34.276  -3.945  1.00 30.90           C  
ATOM    118  NE  ARG    19      45.927  33.072  -3.860  1.00 30.71           N  
ATOM    119  CZ  ARG    19      45.606  31.900  -4.405  1.00 34.06           C  
ATOM    120  NH1 ARG    19      44.443  31.701  -5.024  1.00 34.11           N  
ATOM    121  NH2 ARG    19      46.432  30.889  -4.286  1.00 36.45           N  
ATOM    122  N   HIS    20      44.283  39.638  -4.396  1.00 31.84           N  
ATOM    123  CA  HIS    20      43.448  40.623  -5.069  1.00 30.13           C  
ATOM    124  C   HIS    20      44.146  41.962  -5.243  1.00 29.99           C  
ATOM    125  O   HIS    20      44.067  42.583  -6.320  1.00 29.25           O  
ATOM    126  CB  HIS    20      42.099  40.805  -4.311  1.00 32.18           C  
ATOM    127  CG  HIS    20      41.118  41.669  -5.043  1.00 32.57           C  
ATOM    128  ND1 HIS    20      40.643  41.347  -6.295  1.00 33.23           N  
ATOM    129  CD2 HIS    20      40.597  42.888  -4.744  1.00 33.95           C  
ATOM    130  CE1 HIS    20      39.823  42.289  -6.703  1.00 33.99           C  
ATOM    131  NE2 HIS    20      39.783  43.238  -5.787  1.00 34.24           N  
ATOM    132  N   LEU    21      44.868  42.414  -4.211  1.00 28.80           N  
ATOM    133  CA  LEU    21      45.686  43.625  -4.315  1.00 30.87           C  
ATOM    134  C   LEU    21      46.682  43.491  -5.482  1.00 29.17           C  
ATOM    135  O   LEU    21      46.804  44.376  -6.308  1.00 29.80           O  
ATOM    136  CB  LEU    21      46.482  43.894  -3.033  1.00 30.12           C  
ATOM    137  CG  LEU    21      45.643  44.421  -1.869  1.00 34.58           C  
ATOM    138  CD1 LEU    21      46.525  44.462  -0.604  1.00 34.39           C  
ATOM    139  CD2 LEU    21      45.094  45.789  -2.178  1.00 36.07           C  
ATOM    140  N   ARG    22      47.320  42.351  -5.570  1.00 30.71           N  
ATOM    141  CA  ARG    22      48.371  42.149  -6.583  1.00 30.39           C  
ATOM    142  C   ARG    22      47.770  42.163  -8.013  1.00 30.86           C  
ATOM    143  O   ARG    22      48.362  42.730  -8.958  1.00 30.07           O  
ATOM    144  CB  ARG    22      49.180  40.892  -6.278  1.00 30.93           C  
ATOM    145  CG  ARG    22      50.300  40.579  -7.284  1.00 33.89           C  
ATOM    146  CD  ARG    22      50.938  39.237  -7.047  1.00 35.51           C  
ATOM    147  NE  ARG    22      51.936  39.087  -8.082  1.00 34.57           N  
ATOM    148  CZ  ARG    22      53.195  38.696  -7.913  1.00 35.50           C  
ATOM    149  NH1 ARG    22      53.656  38.311  -6.722  1.00 33.15           N  
ATOM    150  NH2 ARG    22      53.992  38.675  -8.980  1.00 34.96           N  
ATOM    151  N   ALA    23      46.619  41.553  -8.157  1.00 31.76           N  
ATOM    152  CA  ALA    23      45.849  41.569  -9.439  1.00 32.88           C  
ATOM    153  C   ALA    23      45.550  42.992  -9.922  1.00 34.72           C  
ATOM    154  O   ALA    23      45.422  43.265 -11.137  1.00 34.07           O  
ATOM    155  CB  ALA    23      44.571  40.794  -9.272  1.00 32.37           C  
ATOM    156  N   HIS    24      45.474  43.934  -8.975  1.00 36.04           N  
ATOM    157  CA  HIS    24      45.250  45.334  -9.327  1.00 36.14           C  
ATOM    158  C   HIS    24      46.427  46.284  -9.110  1.00 36.10           C  
ATOM    159  O   HIS    24      46.213  47.500  -8.923  1.00 36.57           O  
ATOM    160  CB  HIS    24      44.025  45.790  -8.591  1.00 36.62           C  
ATOM    161  CG  HIS    24      42.773  45.148  -9.090  1.00 39.20           C  
ATOM    162  ND1 HIS    24      42.127  45.574 -10.237  1.00 41.39           N  
ATOM    163  CD2 HIS    24      42.067  44.098  -8.626  1.00 39.99           C  
ATOM    164  CE1 HIS    24      41.058  44.825 -10.430  1.00 39.92           C  
ATOM    165  NE2 HIS    24      40.992  43.935  -9.463  1.00 41.57           N  
ATOM    166  N   GLY    25      47.648  45.767  -9.216  1.00 34.51           N  
ATOM    167  CA  GLY    25      48.872  46.573  -9.196  1.00 34.38           C  
ATOM    168  C   GLY    25      49.382  47.076  -7.851  1.00 33.84           C  
ATOM    169  O   GLY    25      50.367  47.828  -7.794  1.00 34.39           O  
ATOM    170  N   PHE    26      48.728  46.641  -6.770  1.00 33.03           N  
ATOM    171  CA  PHE    26      49.200  46.859  -5.425  1.00 32.41           C  
ATOM    172  C   PHE    26      50.146  45.720  -5.008  1.00 32.82           C  
ATOM    173  O   PHE    26      50.234  44.666  -5.664  1.00 32.25           O  
ATOM    174  CB  PHE    26      48.025  46.976  -4.449  1.00 32.87           C  
ATOM    175  CG  PHE    26      47.435  48.362  -4.362  1.00 32.59           C  
ATOM    176  CD1 PHE    26      46.831  48.948  -5.485  1.00 34.19           C  
ATOM    177  CD2 PHE    26      47.400  49.042  -3.149  1.00 32.00           C  
ATOM    178  CE1 PHE    26      46.270  50.199  -5.411  1.00 37.10           C  
ATOM    179  CE2 PHE    26      46.877  50.306  -3.076  1.00 33.19           C  
ATOM    180  CZ  PHE    26      46.282  50.893  -4.197  1.00 35.86           C  
ATOM    181  N   VAL    27      50.932  45.975  -3.970  1.00 30.86           N  
ATOM    182  CA  VAL    27      51.683  44.924  -3.297  1.00 29.69           C  
ATOM    183  C   VAL    27      51.322  44.998  -1.817  1.00 29.17           C  
ATOM    184  O   VAL    27      50.713  45.972  -1.374  1.00 30.58           O  
ATOM    185  CB  VAL    27      53.209  45.090  -3.475  1.00 29.88           C  
ATOM    186  CG1 VAL    27      53.601  44.831  -4.983  1.00 29.49           C  
ATOM    187  CG2 VAL    27      53.673  46.482  -3.043  1.00 28.47           C  
ATOM    188  N   SER    28      51.737  44.016  -1.055  1.00 28.60           N  
ATOM    189  CA  SER    28      51.295  43.942   0.339  1.00 27.97           C  
ATOM    190  C   SER    28      52.312  43.216   1.192  1.00 26.85           C  
ATOM    191  O   SER    28      53.161  42.470   0.690  1.00 26.63           O  
ATOM    192  CB  SER    28      49.943  43.289   0.447  1.00 27.40           C  
ATOM    193  OG  SER    28      49.995  41.929   0.001  1.00 28.09           O  
ATOM    194  N   VAL    29      52.217  43.471   2.498  1.00 26.32           N  
ATOM    195  CA  VAL    29      52.868  42.663   3.499  1.00 26.09           C  
ATOM    196  C   VAL    29      51.869  42.358   4.612  1.00 26.69           C  
ATOM    197  O   VAL    29      50.835  43.029   4.767  1.00 25.06           O  
ATOM    198  CB  VAL    29      54.155  43.294   4.125  1.00 25.96           C  
ATOM    199  CG1 VAL    29      55.258  43.478   3.036  1.00 26.47           C  
ATOM    200  CG2 VAL    29      53.900  44.569   4.878  1.00 24.70           C  
ATOM    201  N   GLU    30      52.207  41.357   5.394  1.00 26.99           N  
ATOM    202  CA  GLU    30      51.408  41.000   6.527  1.00 28.70           C  
ATOM    203  C   GLU    30      52.057  41.354   7.867  1.00 27.60           C  
ATOM    204  O   GLU    30      53.291  41.412   8.015  1.00 27.17           O  
ATOM    205  CB  GLU    30      51.109  39.498   6.493  1.00 29.53           C  
ATOM    206  CG  GLU    30      50.082  39.067   5.504  1.00 35.04           C  
ATOM    207  CD  GLU    30      49.665  37.586   5.712  1.00 43.13           C  
ATOM    208  OE1 GLU    30      49.320  37.173   6.875  1.00 48.65           O  
ATOM    209  OE2 GLU    30      49.648  36.838   4.713  1.00 39.81           O  
ATOM    210  N   GLU    31      51.198  41.593   8.857  1.00 27.51           N  
ATOM    211  CA  GLU    31      51.636  41.860  10.236  0.50 27.73           C  
ATOM    213  C   GLU    31      52.614  43.012  10.285  1.00 26.70           C  
ATOM    214  O   GLU    31      53.692  42.906  10.816  1.00 26.95           O  
ATOM    215  CB  GLU    31      52.244  40.596  10.829  0.50 28.41           C  
ATOM    217  CG  GLU    31      51.309  39.425  10.700  0.50 31.21           C  
ATOM    219  CD  GLU    31      51.797  38.212  11.432  0.50 35.16           C  
ATOM    221  OE1 GLU    31      52.986  37.874  11.284  0.50 39.43           O  
ATOM    223  OE2 GLU    31      50.974  37.584  12.139  0.50 39.69           O  
ATOM    225  N   PHE    32      52.203  44.124   9.708  1.00 26.33           N  
ATOM    226  CA  PHE    32      53.002  45.304   9.636  1.00 25.68           C  
ATOM    227  C   PHE    32      52.885  46.230  10.859  1.00 24.65           C  
ATOM    228  O   PHE    32      51.773  46.526  11.312  1.00 24.12           O  
ATOM    229  CB  PHE    32      52.590  46.095   8.426  1.00 25.46           C  
ATOM    230  CG  PHE    32      53.404  47.298   8.222  1.00 24.52           C  
ATOM    231  CD1 PHE    32      52.884  48.541   8.491  1.00 25.16           C  
ATOM    232  CD2 PHE    32      54.720  47.194   7.800  1.00 25.34           C  
ATOM    233  CE1 PHE    32      53.623  49.672   8.297  1.00 26.20           C  
ATOM    234  CE2 PHE    32      55.472  48.331   7.635  1.00 25.96           C  
ATOM    235  CZ  PHE    32      54.918  49.579   7.866  1.00 25.05           C  
ATOM    236  N   VAL    33      54.016  46.731  11.327  1.00 24.23           N  
ATOM    237  CA  VAL    33      54.088  47.595  12.530  1.00 23.50           C  
ATOM    238  C   VAL    33      54.357  49.052  12.142  1.00 24.37           C  
ATOM    239  O   VAL    33      55.509  49.435  11.869  1.00 24.23           O  
ATOM    240  CB  VAL    33      55.151  47.131  13.517  1.00 24.23           C  
ATOM    241  CG1 VAL    33      55.280  48.117  14.691  1.00 22.24           C  
ATOM    242  CG2 VAL    33      54.843  45.743  14.017  1.00 24.19           C  
ATOM    243  N   PRO    34      53.306  49.884  12.111  1.00 24.54           N  
ATOM    244  CA  PRO    34      53.506  51.294  11.752  1.00 25.71           C  
ATOM    245  C   PRO    34      54.085  52.172  12.867  1.00 26.84           C  
ATOM    246  O   PRO    34      54.626  53.251  12.588  1.00 27.21           O  
ATOM    247  CB  PRO    34      52.098  51.740  11.346  1.00 25.67           C  
ATOM    248  CG  PRO    34      51.161  50.843  12.130  1.00 25.17           C  
ATOM    249  CD  PRO    34      51.885  49.550  12.356  1.00 25.17           C  
ATOM    250  N   ALA    35      53.966  51.715  14.109  1.00 27.43           N  
ATOM    251  CA  ALA    35      54.412  52.460  15.275  1.00 29.07           C  
ATOM    252  C   ALA    35      54.355  51.486  16.435  1.00 29.37           C  
ATOM    253  O   ALA    35      53.620  50.492  16.383  1.00 27.54           O  
ATOM    254  CB  ALA    35      53.500  53.676  15.555  1.00 29.70           C  
ATOM    255  N   ARG    36      55.150  51.776  17.457  1.00 29.82           N  
ATOM    256  CA  ARG    36      55.188  50.979  18.677  1.00 30.96           C  
ATOM    257  C   ARG    36      53.791  50.685  19.158  1.00 31.11           C  
ATOM    258  O   ARG    36      52.973  51.593  19.233  1.00 31.88           O  
ATOM    259  CB  ARG    36      55.896  51.743  19.794  1.00 31.37           C  
ATOM    260  CG  ARG    36      57.369  51.514  19.876  1.00 33.43           C  
ATOM    261  CD  ARG    36      57.850  51.860  21.265  1.00 34.81           C  
ATOM    262  NE  ARG    36      59.263  51.560  21.469  1.00 36.64           N  
ATOM    263  CZ  ARG    36      59.757  50.402  21.907  1.00 37.17           C  
ATOM    264  NH1 ARG    36      58.960  49.382  22.198  1.00 37.94           N  
ATOM    265  NH2 ARG    36      61.069  50.274  22.059  1.00 38.12           N  
ATOM    266  N   GLY    37      53.529  49.430  19.510  1.00 31.00           N  
ATOM    267  CA  GLY    37      52.245  49.046  20.079  1.00 30.64           C  
ATOM    268  C   GLY    37      51.116  48.804  19.096  1.00 30.47           C  
ATOM    269  O   GLY    37      50.028  48.446  19.510  1.00 30.27           O  
ATOM    270  N   LEU    38      51.349  48.994  17.798  1.00 30.30           N  
ATOM    271  CA  LEU    38      50.332  48.695  16.792  1.00 30.44           C  
ATOM    272  C   LEU    38      50.824  47.654  15.805  1.00 29.85           C  
ATOM    273  O   LEU    38      52.008  47.579  15.498  1.00 27.66           O  
ATOM    274  CB  LEU    38      49.958  49.950  15.999  1.00 30.96           C  
ATOM    275  CG  LEU    38      49.282  51.087  16.761  1.00 34.65           C  
ATOM    276  CD1 LEU    38      49.226  52.317  15.860  1.00 37.20           C  
ATOM    277  CD2 LEU    38      47.864  50.657  17.221  1.00 37.06           C  
ATOM    278  N   ARG    39      49.894  46.878  15.287  1.00 30.06           N  
ATOM    279  CA  ARG    39      50.195  45.952  14.207  1.00 30.98           C  
ATOM    280  C   ARG    39      48.987  45.811  13.308  1.00 30.64           C  
ATOM    281  O   ARG    39      47.862  45.679  13.803  1.00 30.53           O  
ATOM    282  CB  ARG    39      50.602  44.602  14.753  1.00 31.70           C  
ATOM    283  CG  ARG    39      51.344  43.770  13.727  1.00 36.13           C  
ATOM    284  CD  ARG    39      51.801  42.461  14.311  1.00 41.67           C  
ATOM    285  NE  ARG    39      50.644  41.636  14.613  1.00 46.35           N  
ATOM    286  CZ  ARG    39      50.683  40.374  15.039  1.00 52.33           C  
ATOM    287  NH1 ARG    39      51.852  39.736  15.191  1.00 53.52           N  
ATOM    288  NH2 ARG    39      49.527  39.738  15.289  1.00 53.35           N  
ATOM    289  N   VAL    40      49.193  45.911  11.997  1.00 29.25           N  
ATOM    290  CA  VAL    40      48.084  45.806  11.073  1.00 29.29           C  
ATOM    291  C   VAL    40      48.180  44.491  10.303  1.00 29.28           C  
ATOM    292  O   VAL    40      49.260  44.038   9.971  1.00 28.16           O  
ATOM    293  CB  VAL    40      47.979  47.025  10.097  1.00 30.38           C  
ATOM    294  CG1 VAL    40      48.048  48.386  10.835  1.00 30.15           C  
ATOM    295  CG2 VAL    40      48.965  46.949   9.024  1.00 31.10           C  
ATOM    296  N   ASP    41      47.031  43.890  10.016  1.00 28.82           N  
ATOM    297  CA  ASP    41      46.989  42.539   9.423  1.00 28.90           C  
ATOM    298  C   ASP    41      47.559  42.493   7.997  1.00 29.20           C  
ATOM    299  O   ASP    41      48.356  41.616   7.681  1.00 28.96           O  
ATOM    300  CB  ASP    41      45.553  42.025   9.428  1.00 29.05           C  
ATOM    301  CG  ASP    41      45.003  41.835  10.844  1.00 29.68           C  
ATOM    302  OD1 ASP    41      45.807  41.624  11.776  1.00 28.41           O  
ATOM    303  OD2 ASP    41      43.761  41.888  10.974  1.00 29.44           O  
ATOM    304  N   VAL    42      47.146  43.451   7.170  1.00 29.53           N  
ATOM    305  CA  VAL    42      47.725  43.629   5.860  1.00 29.37           C  
ATOM    306  C   VAL    42      47.958  45.118   5.626  1.00 29.29           C  
ATOM    307  O   VAL    42      47.066  45.944   5.858  1.00 28.58           O  
ATOM    308  CB  VAL    42      46.839  43.039   4.739  1.00 30.24           C  
ATOM    309  CG1 VAL    42      47.444  43.342   3.341  1.00 29.49           C  
ATOM    310  CG2 VAL    42      46.690  41.534   4.922  1.00 29.51           C  
ATOM    311  N   MET    43      49.169  45.445   5.159  1.00 28.21           N  
ATOM    312  CA  MET    43      49.415  46.759   4.580  1.00 28.70           C  
ATOM    313  C   MET    43      49.538  46.629   3.083  1.00 29.05           C  
ATOM    314  O   MET    43      50.300  45.777   2.615  1.00 28.30           O  
ATOM    315  CB  MET    43      50.658  47.424   5.172  1.00 27.94           C  
ATOM    316  CG  MET    43      50.883  48.859   4.561  1.00 31.25           C  
ATOM    317  SD  MET    43      52.353  49.878   5.187  0.65 32.79          SE  
ATOM    318  CE  MET    43      52.924  50.775   3.501  1.00 36.03           C  
ATOM    319  N   GLY    44      48.790  47.465   2.347  1.00 29.66           N  
ATOM    320  CA  GLY    44      48.888  47.517   0.887  1.00 29.92           C  
ATOM    321  C   GLY    44      49.589  48.774   0.442  1.00 30.19           C  
ATOM    322  O   GLY    44      49.381  49.850   1.036  1.00 29.23           O  
ATOM    323  N   LEU    45      50.448  48.642  -0.590  1.00 30.88           N  
ATOM    324  CA  LEU    45      51.158  49.743  -1.171  1.00 31.78           C  
ATOM    325  C   LEU    45      50.853  49.835  -2.667  1.00 32.94           C  
ATOM    326  O   LEU    45      51.083  48.871  -3.439  1.00 32.14           O  
ATOM    327  CB  LEU    45      52.661  49.601  -0.943  1.00 31.03           C  
ATOM    328  CG  LEU    45      53.568  50.630  -1.591  1.00 32.51           C  
ATOM    329  CD1 LEU    45      53.290  52.041  -1.032  1.00 29.99           C  
ATOM    330  CD2 LEU    45      55.079  50.228  -1.445  1.00 29.43           C  
ATOM    331  N   GLY    46      50.318  50.986  -3.040  1.00 34.05           N  
ATOM    332  CA  GLY    46      49.879  51.284  -4.410  1.00 35.87           C  
ATOM    333  C   GLY    46      51.019  51.765  -5.274  1.00 37.83           C  
ATOM    334  O   GLY    46      52.109  52.125  -4.761  1.00 38.53           O  
ATOM    335  N   PRO    47      50.825  51.719  -6.603  1.00 39.46           N  
ATOM    336  CA  PRO    47      51.963  52.055  -7.492  1.00 40.90           C  
ATOM    337  C   PRO    47      52.426  53.525  -7.400  1.00 42.26           C  
ATOM    338  O   PRO    47      53.544  53.846  -7.840  1.00 43.50           O  
ATOM    339  CB  PRO    47      51.435  51.731  -8.910  1.00 40.67           C  
ATOM    340  CG  PRO    47      49.957  51.675  -8.775  1.00 40.80           C  
ATOM    341  CD  PRO    47      49.632  51.293  -7.341  1.00 38.82           C  
ATOM    342  N   LYS    48      51.595  54.390  -6.829  1.00 42.99           N  
ATOM    343  CA  LYS    48      51.946  55.797  -6.637  1.00 43.80           C  
ATOM    344  C   LYS    48      52.193  56.090  -5.162  1.00 42.11           C  
ATOM    345  O   LYS    48      52.254  57.247  -4.766  1.00 41.20           O  
ATOM    346  CB  LYS    48      50.823  56.696  -7.171  1.00 45.43           C  
ATOM    347  CG  LYS    48      50.573  56.567  -8.695  1.00 49.60           C  
ATOM    348  CD  LYS    48      49.446  57.511  -9.190  1.00 54.59           C  
ATOM    349  CE  LYS    48      48.163  56.754  -9.578  1.00 57.03           C  
ATOM    350  NZ  LYS    48      48.451  55.682 -10.606  1.00 58.42           N  
ATOM    351  N   GLY    49      52.349  55.039  -4.357  1.00 39.55           N  
ATOM    352  CA  GLY    49      52.672  55.189  -2.959  1.00 37.96           C  
ATOM    353  C   GLY    49      51.472  55.318  -2.034  1.00 36.76           C  
ATOM    354  O   GLY    49      51.631  55.663  -0.895  1.00 35.86           O  
ATOM    355  N   GLU    50      50.286  54.994  -2.516  1.00 35.39           N  
ATOM    356  CA  GLU    50      49.063  54.967  -1.695  1.00 36.06           C  
ATOM    357  C   GLU    50      49.233  53.877  -0.595  1.00 34.85           C  
ATOM    358  O   GLU    50      49.797  52.810  -0.849  1.00 34.55           O  
ATOM    359  CB  GLU    50      47.843  54.679  -2.589  1.00 36.91           C  
ATOM    360  CG  GLU    50      47.721  55.553  -3.900  1.00 42.02           C  
ATOM    361  CD  GLU    50      48.240  54.853  -5.207  1.00 46.63           C  
ATOM    362  OE1 GLU    50      47.541  54.840  -6.245  1.00 54.54           O  
ATOM    363  OE2 GLU    50      49.329  54.311  -5.222  1.00 41.20           O  
ATOM    364  N   ILE    51      48.834  54.170   0.638  1.00 32.72           N  
ATOM    365  CA  ILE    51      48.962  53.206   1.739  1.00 31.02           C  
ATOM    366  C   ILE    51      47.550  52.829   2.220  1.00 30.71           C  
ATOM    367  O   ILE    51      46.739  53.693   2.571  1.00 29.10           O  
ATOM    368  CB  ILE    51      49.842  53.760   2.910  1.00 31.37           C  
ATOM    369  CG1 ILE    51      51.291  53.948   2.439  1.00 33.61           C  
ATOM    370  CG2 ILE    51      49.866  52.793   4.125  1.00 29.15           C  
ATOM    371  CD1 ILE    51      52.022  55.011   3.209  1.00 36.59           C  
ATOM    372  N   TRP    52      47.278  51.515   2.200  1.00 30.35           N  
ATOM    373  CA  TRP    52      46.037  50.925   2.665  1.00 30.78           C  
ATOM    374  C   TRP    52      46.306  50.010   3.836  1.00 29.52           C  
ATOM    375  O   TRP    52      47.279  49.268   3.846  1.00 29.52           O  
ATOM    376  CB  TRP    52      45.424  50.083   1.556  1.00 31.80           C  
ATOM    377  CG  TRP    52      44.858  50.853   0.411  1.00 32.99           C  
ATOM    378  CD1 TRP    52      45.021  52.174   0.125  1.00 34.79           C  
ATOM    379  CD2 TRP    52      44.058  50.312  -0.642  1.00 33.33           C  
ATOM    380  NE1 TRP    52      44.387  52.489  -1.058  1.00 35.95           N  
ATOM    381  CE2 TRP    52      43.779  51.360  -1.540  1.00 36.05           C  
ATOM    382  CE3 TRP    52      43.586  49.048  -0.923  1.00 33.32           C  
ATOM    383  CZ2 TRP    52      43.012  51.183  -2.686  1.00 34.77           C  
ATOM    384  CZ3 TRP    52      42.800  48.874  -2.076  1.00 34.80           C  
ATOM    385  CH2 TRP    52      42.536  49.944  -2.927  1.00 35.32           C  
ATOM    386  N   VAL    53      45.469  50.098   4.847  1.00 29.67           N  
ATOM    387  CA  VAL    53      45.486  49.168   5.949  1.00 28.16           C  
ATOM    388  C   VAL    53      44.216  48.335   5.810  1.00 28.83           C  
ATOM    389  O   VAL    53      43.091  48.875   5.642  1.00 26.41           O  
ATOM    390  CB  VAL    53      45.524  49.899   7.297  1.00 29.11           C  
ATOM    391  CG1 VAL    53      45.002  48.988   8.448  1.00 27.78           C  
ATOM    392  CG2 VAL    53      46.940  50.456   7.540  1.00 28.12           C  
ATOM    393  N   ILE    54      44.398  47.020   5.880  1.00 28.50           N  
ATOM    394  CA  ILE    54      43.285  46.084   5.847  1.00 29.08           C  
ATOM    395  C   ILE    54      43.358  45.195   7.076  1.00 28.55           C  
ATOM    396  O   ILE    54      44.330  44.453   7.275  1.00 28.15           O  
ATOM    397  CB  ILE    54      43.272  45.213   4.565  1.00 29.43           C  
ATOM    398  CG1 ILE    54      43.212  46.102   3.335  1.00 31.46           C  
ATOM    399  CG2 ILE    54      42.083  44.228   4.538  1.00 30.38           C  
ATOM    400  CD1 ILE    54      44.488  46.089   2.575  1.00 34.04           C  
ATOM    401  N   GLU    55      42.313  45.285   7.902  1.00 26.85           N  
ATOM    402  CA  GLU    55      42.162  44.439   9.044  1.00 26.66           C  
ATOM    403  C   GLU    55      41.252  43.269   8.697  1.00 28.23           C  
ATOM    404  O   GLU    55      40.051  43.473   8.371  1.00 28.33           O  
ATOM    405  CB  GLU    55      41.580  45.241  10.223  1.00 26.95           C  
ATOM    406  CG  GLU    55      42.539  46.184  10.860  1.00 26.27           C  
ATOM    407  CD  GLU    55      43.671  45.464  11.554  1.00 28.92           C  
ATOM    408  OE1 GLU    55      43.450  44.953  12.672  1.00 30.37           O  
ATOM    409  OE2 GLU    55      44.779  45.412  10.987  1.00 26.72           O  
ATOM    410  N   CYS    56      41.792  42.077   8.878  1.00 29.07           N  
ATOM    411  CA  CYS    56      41.168  40.830   8.506  1.00 30.82           C  
ATOM    412  C   CYS    56      40.524  40.220   9.729  1.00 30.88           C  
ATOM    413  O   CYS    56      41.192  39.664  10.573  1.00 31.72           O  
ATOM    414  CB  CYS    56      42.194  39.878   7.881  1.00 30.80           C  
ATOM    415  SG  CYS    56      42.965  40.559   6.395  1.00 33.27           S  
ATOM    416  N   LYS    57      39.200  40.314   9.830  1.00 31.20           N  
ATOM    417  CA  LYS    57      38.504  39.778  10.992  1.00 32.78           C  
ATOM    418  C   LYS    57      37.786  38.473  10.639  1.00 33.46           C  
ATOM    419  O   LYS    57      36.905  38.436   9.806  1.00 32.62           O  
ATOM    420  CB  LYS    57      37.546  40.818  11.544  1.00 32.90           C  
ATOM    421  CG  LYS    57      38.238  42.112  11.931  1.00 35.60           C  
ATOM    422  CD  LYS    57      39.230  41.804  13.049  1.00 38.77           C  
ATOM    423  CE  LYS    57      39.999  42.990  13.468  1.00 42.21           C  
ATOM    424  NZ  LYS    57      40.988  42.670  14.570  1.00 43.45           N  
ATOM    425  N   SER    58      38.177  37.406  11.314  1.00 34.39           N  
ATOM    426  CA  SER    58      37.759  36.075  10.947  1.00 35.27           C  
ATOM    427  C   SER    58      36.486  35.655  11.695  1.00 35.26           C  
ATOM    428  O   SER    58      35.881  34.626  11.349  1.00 35.69           O  
ATOM    429  CB  SER    58      38.909  35.128  11.231  1.00 35.37           C  
ATOM    430  OG  SER    58      39.287  35.218  12.615  1.00 40.50           O  
ATOM    431  N   SER    59      36.088  36.486  12.679  1.00 34.46           N  
ATOM    432  CA  SER    59      34.943  36.235  13.568  0.50 34.53           C  
ATOM    434  C   SER    59      34.438  37.565  14.128  1.00 34.32           C  
ATOM    435  O   SER    59      35.182  38.525  14.196  1.00 33.74           O  
ATOM    436  CB  SER    59      35.378  35.365  14.771  0.50 34.93           C  
ATOM    438  OG  SER    59      34.823  34.065  14.735  0.50 34.74           O  
ATOM    440  N   ARG    60      33.193  37.599  14.584  1.00 35.75           N  
ATOM    441  CA  ARG    60      32.698  38.720  15.407  1.00 36.62           C  
ATOM    442  C   ARG    60      33.565  39.036  16.632  1.00 36.50           C  
ATOM    443  O   ARG    60      33.778  40.208  16.965  1.00 36.82           O  
ATOM    444  CB  ARG    60      31.297  38.420  15.900  1.00 37.23           C  
ATOM    445  CG  ARG    60      30.263  38.651  14.860  1.00 38.79           C  
ATOM    446  CD  ARG    60      28.912  38.625  15.475  1.00 40.20           C  
ATOM    447  NE  ARG    60      28.666  39.815  16.293  1.00 41.47           N  
ATOM    448  CZ  ARG    60      27.469  40.177  16.734  1.00 42.08           C  
ATOM    449  NH1 ARG    60      26.401  39.449  16.442  1.00 43.37           N  
ATOM    450  NH2 ARG    60      27.334  41.270  17.477  1.00 44.05           N  
ATOM    451  N   ALA    61      34.067  38.001  17.303  1.00 36.87           N  
ATOM    452  CA  ALA    61      34.974  38.201  18.469  1.00 36.31           C  
ATOM    453  C   ALA    61      36.273  38.886  18.035  1.00 36.59           C  
ATOM    454  O   ALA    61      36.788  39.761  18.745  1.00 36.73           O  
ATOM    455  CB  ALA    61      35.277  36.897  19.149  1.00 36.61           C  
ATOM    456  N   ASP    62      36.789  38.512  16.862  1.00 35.46           N  
ATOM    457  CA  ASP    62      37.976  39.126  16.337  1.00 35.64           C  
ATOM    458  C   ASP    62      37.748  40.632  16.174  1.00 34.83           C  
ATOM    459  O   ASP    62      38.657  41.446  16.416  1.00 35.10           O  
ATOM    460  CB  ASP    62      38.337  38.498  14.985  1.00 36.39           C  
ATOM    461  CG  ASP    62      39.794  38.623  14.654  1.00 39.25           C  
ATOM    462  OD1 ASP    62      40.637  38.680  15.583  1.00 40.62           O  
ATOM    463  OD2 ASP    62      40.114  38.638  13.450  1.00 38.77           O  
ATOM    464  N   PHE    63      36.537  40.996  15.744  1.00 32.94           N  
ATOM    465  CA  PHE    63      36.179  42.398  15.477  1.00 32.11           C  
ATOM    466  C   PHE    63      36.010  43.121  16.817  1.00 32.58           C  
ATOM    467  O   PHE    63      36.473  44.247  16.995  1.00 33.27           O  
ATOM    468  CB  PHE    63      34.899  42.469  14.593  1.00 31.56           C  
ATOM    469  CG  PHE    63      34.233  43.797  14.589  1.00 28.81           C  
ATOM    470  CD1 PHE    63      34.871  44.893  14.078  1.00 28.17           C  
ATOM    471  CD2 PHE    63      32.950  43.943  15.088  1.00 30.00           C  
ATOM    472  CE1 PHE    63      34.249  46.153  14.108  1.00 28.32           C  
ATOM    473  CE2 PHE    63      32.322  45.178  15.078  1.00 30.25           C  
ATOM    474  CZ  PHE    63      32.984  46.282  14.580  1.00 27.83           C  
ATOM    475  N   GLN    64      35.367  42.451  17.756  1.00 32.42           N  
ATOM    476  CA  GLN    64      35.174  42.992  19.090  1.00 33.60           C  
ATOM    477  C   GLN    64      36.503  43.384  19.776  1.00 34.10           C  
ATOM    478  O   GLN    64      36.585  44.416  20.447  1.00 34.13           O  
ATOM    479  CB  GLN    64      34.339  42.001  19.920  1.00 33.32           C  
ATOM    480  CG  GLN    64      32.896  41.839  19.354  1.00 34.10           C  
ATOM    481  CD  GLN    64      32.197  40.512  19.741  1.00 36.83           C  
ATOM    482  OE1 GLN    64      32.667  39.775  20.614  1.00 36.11           O  
ATOM    483  NE2 GLN    64      31.044  40.241  19.116  1.00 35.53           N  
ATOM    484  N   ALA    65      37.536  42.579  19.568  1.00 34.84           N  
ATOM    485  CA  ALA    65      38.888  42.850  20.073  1.00 35.88           C  
ATOM    486  C   ALA    65      39.640  44.026  19.386  1.00 36.86           C  
ATOM    487  O   ALA    65      40.586  44.555  19.953  1.00 37.09           O  
ATOM    488  CB  ALA    65      39.730  41.571  19.976  1.00 36.04           C  
ATOM    489  N   ASP    66      39.240  44.431  18.182  1.00 37.60           N  
ATOM    490  CA  ASP    66      39.887  45.567  17.476  1.00 38.20           C  
ATOM    491  C   ASP    66      39.131  46.910  17.766  1.00 38.27           C  
ATOM    492  O   ASP    66      38.944  47.742  16.855  1.00 38.55           O  
ATOM    493  CB  ASP    66      39.892  45.279  15.965  1.00 38.37           C  
ATOM    494  CG  ASP    66      41.248  45.575  15.260  1.00 40.27           C  
ATOM    495  OD1 ASP    66      42.284  45.891  15.898  1.00 38.46           O  
ATOM    496  OD2 ASP    66      41.267  45.439  14.011  1.00 42.28           O  
ATOM    497  N   ALA    67      38.724  47.103  19.020  1.00 37.94           N  
ATOM    498  CA  ALA    67      37.974  48.306  19.476  1.00 38.18           C  
ATOM    499  C   ALA    67      38.679  49.661  19.239  1.00 37.68           C  
ATOM    500  O   ALA    67      38.021  50.673  18.984  1.00 37.88           O  
ATOM    501  CB  ALA    67      37.598  48.168  20.949  1.00 37.97           C  
ATOM    502  N   LYS    68      40.010  49.669  19.296  1.00 36.84           N  
ATOM    503  CA  LYS    68      40.799  50.888  19.048  1.00 35.73           C  
ATOM    504  C   LYS    68      41.176  51.071  17.554  1.00 34.00           C  
ATOM    505  O   LYS    68      42.146  51.766  17.261  1.00 33.51           O  
ATOM    506  CB  LYS    68      42.086  50.896  19.910  1.00 36.00           C  
ATOM    507  CG  LYS    68      41.893  50.587  21.402  1.00 36.85           C  
ATOM    508  CD  LYS    68      41.016  51.628  22.134  1.00 38.26           C  
ATOM    509  CE  LYS    68      40.923  51.324  23.629  1.00 39.01           C  
ATOM    510  NZ  LYS    68      40.768  52.534  24.508  1.00 39.85           N  
ATOM    511  N   TRP    69      40.385  50.487  16.640  1.00 31.74           N  
ATOM    512  CA  TRP    69      40.667  50.500  15.197  1.00 30.62           C  
ATOM    513  C   TRP    69      40.785  51.913  14.634  1.00 29.24           C  
ATOM    514  O   TRP    69      41.469  52.122  13.638  1.00 28.58           O  
ATOM    515  CB  TRP    69      39.585  49.721  14.388  1.00 30.33           C  
ATOM    516  CG  TRP    69      38.240  50.371  14.427  1.00 29.23           C  
ATOM    517  CD1 TRP    69      37.264  50.197  15.372  1.00 29.94           C  
ATOM    518  CD2 TRP    69      37.727  51.339  13.498  1.00 28.17           C  
ATOM    519  NE1 TRP    69      36.185  51.017  15.101  1.00 27.93           N  
ATOM    520  CE2 TRP    69      36.441  51.727  13.958  1.00 29.02           C  
ATOM    521  CE3 TRP    69      38.243  51.944  12.353  1.00 30.65           C  
ATOM    522  CZ2 TRP    69      35.660  52.686  13.298  1.00 28.93           C  
ATOM    523  CZ3 TRP    69      37.462  52.892  11.686  1.00 31.23           C  
ATOM    524  CH2 TRP    69      36.181  53.244  12.154  1.00 29.10           C  
ATOM    525  N   GLN    70      40.075  52.870  15.219  1.00 28.41           N  
ATOM    526  CA  GLN    70      40.212  54.247  14.743  1.00 28.68           C  
ATOM    527  C   GLN    70      41.675  54.745  14.825  1.00 27.89           C  
ATOM    528  O   GLN    70      42.046  55.631  14.071  1.00 27.19           O  
ATOM    529  CB  GLN    70      39.254  55.186  15.435  1.00 29.10           C  
ATOM    530  CG  GLN    70      37.903  55.186  14.729  1.00 32.33           C  
ATOM    531  CD  GLN    70      36.780  55.565  15.629  1.00 36.45           C  
ATOM    532  OE1 GLN    70      36.146  56.603  15.447  1.00 39.10           O  
ATOM    533  NE2 GLN    70      36.514  54.724  16.628  1.00 40.07           N  
ATOM    534  N   GLY    71      42.485  54.128  15.692  1.00 27.12           N  
ATOM    535  CA  GLY    71      43.918  54.424  15.785  1.00 27.41           C  
ATOM    536  C   GLY    71      44.742  54.035  14.580  1.00 27.35           C  
ATOM    537  O   GLY    71      45.866  54.548  14.401  1.00 27.03           O  
ATOM    538  N   TYR    72      44.216  53.130  13.754  1.00 26.61           N  
ATOM    539  CA  TYR    72      44.875  52.798  12.505  1.00 26.99           C  
ATOM    540  C   TYR    72      44.747  53.886  11.439  1.00 27.21           C  
ATOM    541  O   TYR    72      45.543  53.935  10.512  1.00 26.79           O  
ATOM    542  CB  TYR    72      44.345  51.508  11.900  1.00 27.27           C  
ATOM    543  CG  TYR    72      44.484  50.262  12.727  1.00 27.75           C  
ATOM    544  CD1 TYR    72      43.357  49.517  13.068  1.00 28.90           C  
ATOM    545  CD2 TYR    72      45.732  49.788  13.133  1.00 30.26           C  
ATOM    546  CE1 TYR    72      43.455  48.343  13.795  1.00 29.21           C  
ATOM    547  CE2 TYR    72      45.842  48.595  13.883  1.00 29.26           C  
ATOM    548  CZ  TYR    72      44.699  47.889  14.212  1.00 31.18           C  
ATOM    549  OH  TYR    72      44.749  46.721  14.939  1.00 29.57           O  
ATOM    550  N   LEU    73      43.746  54.745  11.560  1.00 27.33           N  
ATOM    551  CA  LEU    73      43.444  55.725  10.512  1.00 27.22           C  
ATOM    552  C   LEU    73      44.593  56.676  10.138  1.00 26.79           C  
ATOM    553  O   LEU    73      44.805  56.986   8.953  1.00 26.50           O  
ATOM    554  CB  LEU    73      42.182  56.510  10.914  1.00 27.40           C  
ATOM    555  CG  LEU    73      40.896  55.651  10.984  1.00 26.60           C  
ATOM    556  CD1 LEU    73      39.633  56.515  11.140  1.00 25.98           C  
ATOM    557  CD2 LEU    73      40.786  54.743   9.750  1.00 25.85           C  
ATOM    558  N   GLU    74      45.315  57.149  11.151  1.00 26.70           N  
ATOM    559  CA  GLU    74      46.412  58.063  10.955  1.00 27.00           C  
ATOM    560  C   GLU    74      47.628  57.423  10.287  1.00 27.17           C  
ATOM    561  O   GLU    74      48.600  58.110   9.988  1.00 26.94           O  
ATOM    562  CB  GLU    74      46.822  58.705  12.295  1.00 27.76           C  
ATOM    563  CG  GLU    74      47.378  57.758  13.380  1.00 27.43           C  
ATOM    564  CD  GLU    74      48.101  58.532  14.471  1.00 30.96           C  
ATOM    565  OE1 GLU    74      48.632  59.626  14.155  1.00 29.86           O  
ATOM    566  OE2 GLU    74      48.148  58.061  15.633  1.00 31.00           O  
ATOM    567  N   TRP    75      47.585  56.116  10.063  1.00 27.84           N  
ATOM    568  CA  TRP    75      48.713  55.401   9.472  1.00 28.52           C  
ATOM    569  C   TRP    75      48.442  54.918   8.057  1.00 29.51           C  
ATOM    570  O   TRP    75      49.194  54.082   7.563  1.00 29.23           O  
ATOM    571  CB  TRP    75      49.091  54.215  10.359  1.00 28.34           C  
ATOM    572  CG  TRP    75      49.499  54.652  11.707  1.00 27.70           C  
ATOM    573  CD1 TRP    75      48.796  54.501  12.861  1.00 28.32           C  
ATOM    574  CD2 TRP    75      50.698  55.368  12.052  1.00 28.02           C  
ATOM    575  NE1 TRP    75      49.489  55.068  13.914  1.00 26.63           N  
ATOM    576  CE2 TRP    75      50.656  55.606  13.443  1.00 26.73           C  
ATOM    577  CE3 TRP    75      51.801  55.832  11.317  1.00 26.37           C  
ATOM    578  CZ2 TRP    75      51.671  56.264  14.113  1.00 28.27           C  
ATOM    579  CZ3 TRP    75      52.808  56.476  11.976  1.00 27.45           C  
ATOM    580  CH2 TRP    75      52.738  56.701  13.368  1.00 28.83           C  
ATOM    581  N   CYS    76      47.378  55.432   7.421  1.00 30.37           N  
ATOM    582  CA  CYS    76      47.009  55.020   6.068  1.00 30.52           C  
ATOM    583  C   CYS    76      46.244  56.096   5.308  1.00 30.62           C  
ATOM    584  O   CYS    76      45.786  57.063   5.885  1.00 30.35           O  
ATOM    585  CB  CYS    76      46.196  53.716   6.100  1.00 29.95           C  
ATOM    586  SG  CYS    76      44.615  53.781   6.963  1.00 33.52           S  
ATOM    587  N   ASP    77      46.205  55.957   3.990  1.00 30.59           N  
ATOM    588  CA  ASP    77      45.364  56.773   3.143  1.00 30.05           C  
ATOM    589  C   ASP    77      43.938  56.224   3.149  1.00 30.40           C  
ATOM    590  O   ASP    77      43.001  57.002   3.152  1.00 30.16           O  
ATOM    591  CB  ASP    77      45.881  56.791   1.713  1.00 30.00           C  
ATOM    592  CG  ASP    77      47.242  57.385   1.598  1.00 29.91           C  
ATOM    593  OD1 ASP    77      47.476  58.506   2.117  1.00 29.20           O  
ATOM    594  OD2 ASP    77      48.076  56.757   0.963  1.00 28.27           O  
ATOM    595  N   ARG    78      43.790  54.896   3.164  1.00 29.42           N  
ATOM    596  CA  ARG    78      42.491  54.227   3.170  1.00 30.31           C  
ATOM    597  C   ARG    78      42.547  53.037   4.126  1.00 30.99           C  
ATOM    598  O   ARG    78      43.531  52.321   4.164  1.00 30.71           O  
ATOM    599  CB  ARG    78      42.104  53.747   1.780  1.00 28.64           C  
ATOM    600  CG  ARG    78      41.965  54.859   0.751  1.00 30.72           C  
ATOM    601  CD  ARG    78      41.314  54.348  -0.506  1.00 30.48           C  
ATOM    602  NE  ARG    78      41.571  55.200  -1.659  1.00 32.15           N  
ATOM    603  CZ  ARG    78      40.678  55.961  -2.286  1.00 32.66           C  
ATOM    604  NH1 ARG    78      41.056  56.684  -3.326  1.00 32.79           N  
ATOM    605  NH2 ARG    78      39.419  55.982  -1.928  1.00 32.58           N  
ATOM    606  N   TYR    79      41.504  52.900   4.921  1.00 31.70           N  
ATOM    607  CA  TYR    79      41.309  51.824   5.903  1.00 31.79           C  
ATOM    608  C   TYR    79      40.117  50.941   5.538  1.00 32.08           C  
ATOM    609  O   TYR    79      38.991  51.439   5.249  1.00 31.39           O  
ATOM    610  CB  TYR    79      41.068  52.422   7.300  1.00 32.61           C  
ATOM    611  CG  TYR    79      40.800  51.366   8.318  1.00 31.46           C  
ATOM    612  CD1 TYR    79      41.838  50.715   8.945  1.00 35.19           C  
ATOM    613  CD2 TYR    79      39.485  51.014   8.662  1.00 34.21           C  
ATOM    614  CE1 TYR    79      41.600  49.708   9.871  1.00 34.13           C  
ATOM    615  CE2 TYR    79      39.236  50.004   9.565  1.00 34.41           C  
ATOM    616  CZ  TYR    79      40.307  49.385  10.195  1.00 35.70           C  
ATOM    617  OH  TYR    79      40.092  48.395  11.112  1.00 36.52           O  
ATOM    618  N   PHE    80      40.364  49.625   5.526  1.00 32.04           N  
ATOM    619  CA  PHE    80      39.387  48.598   5.133  1.00 31.79           C  
ATOM    620  C   PHE    80      39.313  47.502   6.169  1.00 32.70           C  
ATOM    621  O   PHE    80      40.330  47.155   6.826  1.00 30.72           O  
ATOM    622  CB  PHE    80      39.748  47.846   3.853  1.00 31.81           C  
ATOM    623  CG  PHE    80      39.922  48.711   2.634  1.00 30.72           C  
ATOM    624  CD1 PHE    80      38.977  48.736   1.631  1.00 31.33           C  
ATOM    625  CD2 PHE    80      41.078  49.473   2.485  1.00 31.26           C  
ATOM    626  CE1 PHE    80      39.166  49.520   0.490  1.00 31.56           C  
ATOM    627  CE2 PHE    80      41.276  50.243   1.358  1.00 28.69           C  
ATOM    628  CZ  PHE    80      40.313  50.285   0.368  1.00 31.86           C  
ATOM    629  N   TRP    81      38.103  46.939   6.278  1.00 31.67           N  
ATOM    630  CA  TRP    81      37.898  45.626   6.873  1.00 32.90           C  
ATOM    631  C   TRP    81      37.907  44.570   5.785  1.00 32.20           C  
ATOM    632  O   TRP    81      37.542  44.863   4.660  1.00 32.23           O  
ATOM    633  CB  TRP    81      36.585  45.564   7.622  1.00 34.68           C  
ATOM    634  CG  TRP    81      36.425  46.615   8.659  1.00 34.01           C  
ATOM    635  CD1 TRP    81      35.813  47.807   8.501  1.00 36.49           C  
ATOM    636  CD2 TRP    81      36.884  46.564  10.020  1.00 34.58           C  
ATOM    637  NE1 TRP    81      35.847  48.515   9.689  1.00 37.61           N  
ATOM    638  CE2 TRP    81      36.529  47.772  10.620  1.00 35.18           C  
ATOM    639  CE3 TRP    81      37.571  45.606  10.778  1.00 36.93           C  
ATOM    640  CZ2 TRP    81      36.810  48.046  11.954  1.00 37.41           C  
ATOM    641  CZ3 TRP    81      37.868  45.885  12.090  1.00 37.27           C  
ATOM    642  CH2 TRP    81      37.502  47.087  12.661  1.00 36.57           C  
ATOM    643  N   ALA    82      38.366  43.369   6.115  1.00 31.59           N  
ATOM    644  CA  ALA    82      38.247  42.185   5.236  1.00 31.92           C  
ATOM    645  C   ALA    82      37.638  41.056   6.088  1.00 30.84           C  
ATOM    646  O   ALA    82      38.151  40.731   7.143  1.00 30.63           O  
ATOM    647  CB  ALA    82      39.603  41.768   4.638  1.00 31.84           C  
ATOM    648  N   VAL    83      36.521  40.514   5.618  1.00 31.32           N  
ATOM    649  CA  VAL    83      35.763  39.465   6.294  1.00 30.64           C  
ATOM    650  C   VAL    83      35.287  38.454   5.271  1.00 31.95           C  
ATOM    651  O   VAL    83      35.279  38.730   4.050  1.00 31.88           O  
ATOM    652  CB  VAL    83      34.547  40.051   7.056  1.00 31.36           C  
ATOM    653  CG1 VAL    83      35.014  41.082   8.109  1.00 30.90           C  
ATOM    654  CG2 VAL    83      33.498  40.665   6.110  1.00 26.79           C  
ATOM    655  N   ASP    84      34.864  37.288   5.742  1.00 31.62           N  
ATOM    656  CA  ASP    84      34.318  36.324   4.835  1.00 31.95           C  
ATOM    657  C   ASP    84      32.794  36.515   4.712  1.00 31.17           C  
ATOM    658  O   ASP    84      32.190  37.331   5.409  1.00 29.18           O  
ATOM    659  CB  ASP    84      34.732  34.908   5.241  1.00 32.92           C  
ATOM    660  CG  ASP    84      34.059  34.396   6.503  1.00 34.47           C  
ATOM    661  OD1 ASP    84      32.989  34.896   6.988  1.00 34.31           O  
ATOM    662  OD2 ASP    84      34.622  33.393   7.008  1.00 41.19           O  
ATOM    663  N   MET    85      32.191  35.692   3.879  1.00 32.20           N  
ATOM    664  CA  MET    85      30.760  35.790   3.578  0.60 33.07           C  
ATOM    666  C   MET    85      29.846  35.354   4.727  1.00 33.77           C  
ATOM    667  O   MET    85      28.611  35.550   4.649  1.00 33.86           O  
ATOM    668  CB  MET    85      30.430  35.009   2.289  0.60 33.52           C  
ATOM    670  CG  MET    85      30.604  33.478   2.356  0.60 34.27           C  
ATOM    672  SD  MET    85      30.588  32.530   0.595  0.39 34.96          SE  
ATOM    674  CE  MET    85      30.777  30.720   1.349  0.60 39.15           C  
ATOM    676  N   GLU    86      30.414  34.741   5.778  1.00 34.54           N  
ATOM    677  CA  GLU    86      29.642  34.341   6.979  0.50 34.80           C  
ATOM    679  C   GLU    86      29.586  35.463   8.020  1.00 34.52           C  
ATOM    680  O   GLU    86      28.776  35.419   8.932  1.00 33.91           O  
ATOM    681  CB  GLU    86      30.258  33.118   7.664  0.50 35.25           C  
ATOM    683  CG  GLU    86      29.928  31.766   7.060  0.50 37.34           C  
ATOM    685  CD  GLU    86      30.082  30.639   8.082  0.50 39.05           C  
ATOM    687  OE1 GLU    86      31.231  30.281   8.424  0.50 40.29           O  
ATOM    689  OE2 GLU    86      29.047  30.136   8.562  0.50 41.01           O  
ATOM    691  N   PHE    87      30.459  36.460   7.881  1.00 33.43           N  
ATOM    692  CA  PHE    87      30.514  37.608   8.799  1.00 32.14           C  
ATOM    693  C   PHE    87      29.291  38.555   8.647  1.00 33.28           C  
ATOM    694  O   PHE    87      28.853  38.836   7.525  1.00 32.13           O  
ATOM    695  CB  PHE    87      31.831  38.369   8.601  1.00 32.08           C  
ATOM    696  CG  PHE    87      32.117  39.391   9.671  1.00 31.34           C  
ATOM    697  CD1 PHE    87      32.996  39.101  10.712  1.00 33.19           C  
ATOM    698  CD2 PHE    87      31.495  40.627   9.658  1.00 29.19           C  
ATOM    699  CE1 PHE    87      33.261  40.043  11.719  1.00 32.29           C  
ATOM    700  CE2 PHE    87      31.737  41.582  10.675  1.00 30.70           C  
ATOM    701  CZ  PHE    87      32.628  41.276  11.707  1.00 33.57           C  
ATOM    702  N   PRO    88      28.731  39.060   9.777  1.00 32.74           N  
ATOM    703  CA  PRO    88      27.627  40.050   9.723  1.00 32.84           C  
ATOM    704  C   PRO    88      28.187  41.443   9.366  1.00 32.72           C  
ATOM    705  O   PRO    88      28.366  42.318  10.232  1.00 32.91           O  
ATOM    706  CB  PRO    88      27.043  39.997  11.167  1.00 33.17           C  
ATOM    707  CG  PRO    88      28.226  39.725  11.959  1.00 33.49           C  
ATOM    708  CD  PRO    88      29.088  38.758  11.175  1.00 33.24           C  
ATOM    709  N   ALA    89      28.484  41.624   8.075  1.00 31.13           N  
ATOM    710  CA  ALA    89      29.129  42.815   7.561  1.00 30.72           C  
ATOM    711  C   ALA    89      28.449  44.156   7.895  1.00 30.38           C  
ATOM    712  O   ALA    89      29.130  45.181   7.983  1.00 31.56           O  
ATOM    713  CB  ALA    89      29.312  42.676   5.982  1.00 30.19           C  
ATOM    714  N   GLU    90      27.137  44.157   8.098  1.00 30.99           N  
ATOM    715  CA  GLU    90      26.377  45.371   8.444  1.00 31.12           C  
ATOM    716  C   GLU    90      26.762  45.985   9.776  1.00 32.02           C  
ATOM    717  O   GLU    90      26.505  47.156  10.024  1.00 33.10           O  
ATOM    718  CB  GLU    90      24.871  45.089   8.446  1.00 31.81           C  
ATOM    719  CG  GLU    90      24.254  45.011   7.027  1.00 29.73           C  
ATOM    720  CD  GLU    90      22.794  44.731   6.953  1.00 33.74           C  
ATOM    721  OE1 GLU    90      22.035  44.680   7.990  1.00 34.20           O  
ATOM    722  OE2 GLU    90      22.331  44.553   5.798  1.00 31.05           O  
ATOM    723  N   LEU    91      27.346  45.173  10.634  1.00 32.63           N  
ATOM    724  CA  LEU    91      27.817  45.612  11.959  1.00 34.26           C  
ATOM    725  C   LEU    91      29.124  46.366  11.898  1.00 34.34           C  
ATOM    726  O   LEU    91      29.487  47.004  12.865  1.00 34.35           O  
ATOM    727  CB  LEU    91      27.953  44.408  12.899  1.00 34.39           C  
ATOM    728  CG  LEU    91      26.625  43.659  13.155  1.00 36.53           C  
ATOM    729  CD1 LEU    91      26.799  42.696  14.337  1.00 38.24           C  
ATOM    730  CD2 LEU    91      25.377  44.560  13.379  1.00 39.11           C  
ATOM    731  N   LEU    92      29.845  46.295  10.770  1.00 34.27           N  
ATOM    732  CA  LEU    92      31.108  47.030  10.663  1.00 34.20           C  
ATOM    733  C   LEU    92      30.811  48.550  10.494  1.00 35.17           C  
ATOM    734  O   LEU    92      29.763  48.939   9.946  1.00 33.79           O  
ATOM    735  CB  LEU    92      31.972  46.516   9.532  1.00 32.57           C  
ATOM    736  CG  LEU    92      32.376  45.057   9.589  1.00 33.16           C  
ATOM    737  CD1 LEU    92      32.911  44.474   8.185  1.00 32.52           C  
ATOM    738  CD2 LEU    92      33.408  44.895  10.689  1.00 32.37           C  
ATOM    739  N   PRO    93      31.734  49.401  10.978  1.00 35.81           N  
ATOM    740  CA  PRO    93      31.588  50.865  10.836  1.00 37.22           C  
ATOM    741  C   PRO    93      31.281  51.285   9.374  1.00 38.57           C  
ATOM    742  O   PRO    93      31.985  50.864   8.435  1.00 37.83           O  
ATOM    743  CB  PRO    93      32.946  51.397  11.245  1.00 37.53           C  
ATOM    744  CG  PRO    93      33.556  50.341  12.105  1.00 37.95           C  
ATOM    745  CD  PRO    93      32.951  49.019  11.699  1.00 37.38           C  
ATOM    746  N   ALA    94      30.265  52.121   9.212  1.00 39.21           N  
ATOM    747  CA  ALA    94      29.795  52.547   7.908  1.00 40.64           C  
ATOM    748  C   ALA    94      30.846  53.293   7.097  1.00 41.69           C  
ATOM    749  O   ALA    94      30.839  53.220   5.871  1.00 43.45           O  
ATOM    750  CB  ALA    94      28.594  53.435   8.093  1.00 40.53           C  
ATOM    751  N   GLU    95      31.727  54.001   7.795  1.00 42.61           N  
ATOM    752  CA  GLU    95      32.748  54.890   7.206  0.50 43.01           C  
ATOM    754  C   GLU    95      33.948  54.142   6.627  1.00 42.97           C  
ATOM    755  O   GLU    95      34.721  54.703   5.853  1.00 45.71           O  
ATOM    756  CB  GLU    95      33.224  55.927   8.244  0.50 42.81           C  
ATOM    758  CG  GLU    95      33.351  55.423   9.716  0.50 43.53           C  
ATOM    760  CD  GLU    95      31.991  55.154  10.401  0.50 42.38           C  
ATOM    762  OE1 GLU    95      30.966  55.697   9.959  0.50 44.03           O  
ATOM    764  OE2 GLU    95      31.944  54.374  11.363  0.50 42.48           O  
ATOM    766  N   SER    96      34.114  52.886   7.026  1.00 41.41           N  
ATOM    767  CA  SER    96      35.207  52.049   6.582  1.00 40.17           C  
ATOM    768  C   SER    96      35.003  51.437   5.201  1.00 37.08           C  
ATOM    769  O   SER    96      33.889  51.255   4.728  1.00 35.17           O  
ATOM    770  CB  SER    96      35.375  50.924   7.590  1.00 40.72           C  
ATOM    771  OG  SER    96      35.655  51.500   8.866  1.00 45.53           O  
ATOM    772  N   GLY    97      36.105  51.139   4.543  1.00 34.07           N  
ATOM    773  CA  GLY    97      36.084  50.291   3.371  1.00 32.64           C  
ATOM    774  C   GLY    97      35.839  48.835   3.746  1.00 31.97           C  
ATOM    775  O   GLY    97      35.950  48.465   4.912  1.00 29.99           O  
ATOM    776  N   LEU    98      35.454  48.020   2.750  1.00 31.37           N  
ATOM    777  CA  LEU    98      35.116  46.642   3.021  1.00 31.04           C  
ATOM    778  C   LEU    98      35.460  45.738   1.870  1.00 30.64           C  
ATOM    779  O   LEU    98      35.038  45.971   0.717  1.00 30.06           O  
ATOM    780  CB  LEU    98      33.600  46.511   3.358  1.00 30.97           C  
ATOM    781  CG  LEU    98      33.051  45.099   3.698  1.00 32.31           C  
ATOM    782  CD1 LEU    98      33.697  44.497   4.956  1.00 31.26           C  
ATOM    783  CD2 LEU    98      31.482  45.121   3.898  1.00 30.70           C  
ATOM    784  N   LEU    99      36.162  44.651   2.197  1.00 30.07           N  
ATOM    785  CA  LEU    99      36.381  43.569   1.266  1.00 30.81           C  
ATOM    786  C   LEU    99      35.723  42.331   1.801  1.00 30.99           C  
ATOM    787  O   LEU    99      35.727  42.091   3.010  1.00 30.71           O  
ATOM    788  CB  LEU    99      37.885  43.238   1.058  1.00 32.25           C  
ATOM    789  CG  LEU    99      38.770  44.242   0.321  1.00 32.98           C  
ATOM    790  CD1 LEU    99      39.193  45.320   1.271  1.00 36.62           C  
ATOM    791  CD2 LEU    99      39.975  43.565  -0.229  1.00 33.97           C  
ATOM    792  N   ILE   100      35.168  41.546   0.897  1.00 30.41           N  
ATOM    793  CA  ILE   100      34.792  40.177   1.217  1.00 31.12           C  
ATOM    794  C   ILE   100      35.857  39.246   0.639  1.00 30.61           C  
ATOM    795  O   ILE   100      36.181  39.339  -0.545  1.00 30.06           O  
ATOM    796  CB  ILE   100      33.400  39.807   0.645  1.00 31.37           C  
ATOM    797  CG1 ILE   100      32.316  40.838   1.017  1.00 32.21           C  
ATOM    798  CG2 ILE   100      33.034  38.396   1.054  1.00 30.76           C  
ATOM    799  CD1 ILE   100      32.001  40.891   2.463  1.00 32.10           C  
ATOM    800  N   ALA   101      36.414  38.375   1.482  1.00 31.06           N  
ATOM    801  CA  ALA   101      37.602  37.608   1.150  1.00 31.30           C  
ATOM    802  C   ALA   101      37.462  36.157   1.616  1.00 32.07           C  
ATOM    803  O   ALA   101      36.580  35.821   2.438  1.00 29.94           O  
ATOM    804  CB  ALA   101      38.853  38.257   1.800  1.00 30.94           C  
ATOM    805  N   ASP   102      38.309  35.310   1.033  1.00 31.99           N  
ATOM    806  CA  ASP   102      38.595  33.959   1.547  1.00 32.72           C  
ATOM    807  C   ASP   102      40.051  33.647   1.231  1.00 31.93           C  
ATOM    808  O   ASP   102      40.771  34.553   0.879  1.00 31.12           O  
ATOM    809  CB  ASP   102      37.619  32.888   1.009  1.00 33.33           C  
ATOM    810  CG  ASP   102      37.670  32.697  -0.519  1.00 34.59           C  
ATOM    811  OD1 ASP   102      38.603  33.128  -1.228  1.00 33.45           O  
ATOM    812  OD2 ASP   102      36.735  32.065  -1.039  1.00 37.52           O  
ATOM    813  N   ALA   103      40.484  32.386   1.337  1.00 31.51           N  
ATOM    814  CA  ALA   103      41.897  32.076   1.133  1.00 31.02           C  
ATOM    815  C   ALA   103      42.311  32.249  -0.308  1.00 30.32           C  
ATOM    816  O   ALA   103      43.492  32.289  -0.557  1.00 30.88           O  
ATOM    817  CB  ALA   103      42.253  30.645   1.612  1.00 32.43           C  
ATOM    818  N   TYR   104      41.363  32.384  -1.245  1.00 28.87           N  
ATOM    819  CA  TYR   104      41.695  32.281  -2.640  1.00 28.34           C  
ATOM    820  C   TYR   104      41.545  33.554  -3.446  1.00 28.54           C  
ATOM    821  O   TYR   104      42.086  33.648  -4.556  1.00 27.28           O  
ATOM    822  CB  TYR   104      40.829  31.212  -3.278  1.00 29.91           C  
ATOM    823  CG  TYR   104      40.922  29.917  -2.508  1.00 31.41           C  
ATOM    824  CD1 TYR   104      42.062  29.153  -2.586  1.00 34.46           C  
ATOM    825  CD2 TYR   104      39.903  29.514  -1.639  1.00 31.16           C  
ATOM    826  CE1 TYR   104      42.179  27.950  -1.899  1.00 36.23           C  
ATOM    827  CE2 TYR   104      40.014  28.327  -0.920  1.00 33.40           C  
ATOM    828  CZ  TYR   104      41.157  27.549  -1.064  1.00 35.57           C  
ATOM    829  OH  TYR   104      41.324  26.371  -0.378  1.00 36.02           O  
ATOM    830  N   ASP   105      40.810  34.511  -2.908  1.00 28.70           N  
ATOM    831  CA  ASP   105      40.516  35.766  -3.623  1.00 30.60           C  
ATOM    832  C   ASP   105      39.815  36.739  -2.694  1.00 29.56           C  
ATOM    833  O   ASP   105      39.558  36.423  -1.538  1.00 29.98           O  
ATOM    834  CB  ASP   105      39.662  35.489  -4.837  1.00 31.52           C  
ATOM    835  CG  ASP   105      39.812  36.551  -5.961  1.00 35.65           C  
ATOM    836  OD1 ASP   105      40.466  37.614  -5.812  1.00 38.92           O  
ATOM    837  OD2 ASP   105      39.239  36.279  -7.007  1.00 38.82           O  
ATOM    838  N   ALA   106      39.534  37.941  -3.196  1.00 29.26           N  
ATOM    839  CA  ALA   106      38.810  38.950  -2.472  1.00 28.38           C  
ATOM    840  C   ALA   106      38.166  39.942  -3.425  1.00 29.35           C  
ATOM    841  O   ALA   106      38.511  40.010  -4.609  1.00 28.75           O  
ATOM    842  CB  ALA   106      39.710  39.672  -1.485  1.00 28.01           C  
ATOM    843  N   GLU   107      37.169  40.682  -2.940  1.00 29.53           N  
ATOM    844  CA  GLU   107      36.594  41.794  -3.723  1.00 29.12           C  
ATOM    845  C   GLU   107      36.297  42.980  -2.834  1.00 28.84           C  
ATOM    846  O   GLU   107      35.868  42.822  -1.713  1.00 30.23           O  
ATOM    847  CB  GLU   107      35.334  41.359  -4.476  1.00 31.03           C  
ATOM    848  CG  GLU   107      34.201  40.871  -3.577  1.00 31.48           C  
ATOM    849  CD  GLU   107      32.986  40.326  -4.320  1.00 36.07           C  
ATOM    850  OE1 GLU   107      32.978  40.275  -5.558  1.00 29.32           O  
ATOM    851  OE2 GLU   107      32.007  39.912  -3.637  1.00 32.19           O  
ATOM    852  N   ILE   108      36.489  44.178  -3.326  1.00 28.49           N  
ATOM    853  CA  ILE   108      36.142  45.373  -2.566  1.00 29.19           C  
ATOM    854  C   ILE   108      34.641  45.582  -2.845  1.00 29.79           C  
ATOM    855  O   ILE   108      34.221  45.650  -4.002  1.00 31.57           O  
ATOM    856  CB  ILE   108      36.910  46.589  -3.041  1.00 30.58           C  
ATOM    857  CG1 ILE   108      38.430  46.385  -2.854  1.00 31.34           C  
ATOM    858  CG2 ILE   108      36.395  47.861  -2.347  1.00 29.43           C  
ATOM    859  CD1 ILE   108      39.242  47.503  -3.377  1.00 30.62           C  
ATOM    860  N   VAL   109      33.844  45.597  -1.808  1.00 29.31           N  
ATOM    861  CA  VAL   109      32.410  45.850  -1.989  1.00 29.33           C  
ATOM    862  C   VAL   109      32.060  47.292  -1.589  1.00 30.06           C  
ATOM    863  O   VAL   109      30.997  47.791  -1.952  1.00 29.09           O  
ATOM    864  CB  VAL   109      31.540  44.803  -1.274  1.00 28.67           C  
ATOM    865  CG1 VAL   109      31.664  43.424  -2.020  1.00 28.48           C  
ATOM    866  CG2 VAL   109      31.878  44.678   0.186  1.00 27.23           C  
ATOM    867  N   ARG   110      32.957  47.921  -0.833  1.00 30.48           N  
ATOM    868  CA  ARG   110      32.838  49.302  -0.415  1.00 31.76           C  
ATOM    869  C   ARG   110      34.221  49.948  -0.323  1.00 31.92           C  
ATOM    870  O   ARG   110      35.073  49.527   0.469  1.00 30.40           O  
ATOM    871  CB  ARG   110      32.121  49.351   0.949  1.00 33.34           C  
ATOM    872  CG  ARG   110      31.775  50.723   1.408  1.00 32.47           C  
ATOM    873  CD  ARG   110      30.784  50.639   2.558  1.00 34.55           C  
ATOM    874  NE  ARG   110      31.397  50.331   3.818  1.00 33.13           N  
ATOM    875  CZ  ARG   110      30.895  49.500   4.742  1.00 38.01           C  
ATOM    876  NH1 ARG   110      31.545  49.328   5.885  1.00 38.34           N  
ATOM    877  NH2 ARG   110      29.748  48.860   4.549  1.00 38.93           N  
ATOM    878  N   MET   111      34.440  50.976  -1.143  1.00 32.39           N  
ATOM    879  CA  MET   111      35.747  51.614  -1.248  1.00 32.61           C  
ATOM    880  C   MET   111      35.901  52.493  -0.031  1.00 32.80           C  
ATOM    881  O   MET   111      34.948  53.179   0.350  1.00 34.31           O  
ATOM    882  CB  MET   111      35.831  52.404  -2.563  1.00 32.09           C  
ATOM    883  CG  MET   111      37.074  53.170  -2.762  1.00 32.99           C  
ATOM    884  SD  MET   111      38.685  52.092  -2.676  0.65 32.64          SE  
ATOM    885  CE  MET   111      38.431  50.909  -4.191  1.00 29.40           C  
ATOM    886  N   ALA   112      37.062  52.452   0.621  1.00 31.88           N  
ATOM    887  CA  ALA   112      37.270  53.287   1.767  1.00 32.18           C  
ATOM    888  C   ALA   112      37.368  54.764   1.359  1.00 31.82           C  
ATOM    889  O   ALA   112      37.847  55.099   0.267  1.00 31.28           O  
ATOM    890  CB  ALA   112      38.475  52.826   2.516  1.00 32.74           C  
ATOM    891  N   PRO   113      36.904  55.676   2.233  1.00 32.37           N  
ATOM    892  CA  PRO   113      37.153  57.097   1.969  1.00 32.98           C  
ATOM    893  C   PRO   113      38.671  57.422   2.065  1.00 34.37           C  
ATOM    894  O   PRO   113      39.385  56.746   2.804  1.00 33.27           O  
ATOM    895  CB  PRO   113      36.361  57.804   3.071  1.00 33.32           C  
ATOM    896  CG  PRO   113      36.246  56.845   4.164  1.00 33.19           C  
ATOM    897  CD  PRO   113      36.175  55.470   3.501  1.00 32.47           C  
ATOM    898  N   GLU   114      39.137  58.416   1.302  1.00 36.51           N  
ATOM    899  CA  GLU   114      40.559  58.817   1.305  1.00 38.56           C  
ATOM    900  C   GLU   114      40.847  59.871   2.385  1.00 39.40           C  
ATOM    901  O   GLU   114      40.219  60.919   2.412  1.00 39.23           O  
ATOM    902  CB  GLU   114      41.010  59.331  -0.076  1.00 38.96           C  
ATOM    903  CG  GLU   114      42.488  59.786  -0.083  1.00 42.79           C  
ATOM    904  CD  GLU   114      43.315  59.213  -1.225  1.00 47.89           C  
ATOM    905  OE1 GLU   114      42.714  58.779  -2.224  1.00 53.14           O  
ATOM    906  OE2 GLU   114      44.570  59.197  -1.131  1.00 48.25           O  
ATOM    907  N   GLN   115      41.783  59.548   3.275  1.00 40.80           N  
ATOM    908  CA  GLN   115      42.268  60.446   4.317  0.50 41.99           C  
ATOM    910  C   GLN   115      43.793  60.544   4.173  1.00 42.34           C  
ATOM    911  O   GLN   115      44.534  60.025   5.015  1.00 42.61           O  
ATOM    912  CB  GLN   115      41.880  59.905   5.712  0.50 42.46           C  
ATOM    914  CG  GLN   115      40.818  58.772   5.706  0.50 44.17           C  
ATOM    916  CD  GLN   115      39.800  58.895   6.827  0.50 45.73           C  
ATOM    918  OE1 GLN   115      38.600  58.789   6.585  0.50 47.54           O  
ATOM    920  NE2 GLN   115      40.271  59.125   8.052  0.50 47.44           N  
ATOM    922  N   LYS   116      44.249  61.179   3.097  1.00 42.86           N  
ATOM    923  CA  LYS   116      45.673  61.190   2.744  1.00 43.55           C  
ATOM    924  C   LYS   116      46.675  61.487   3.886  1.00 43.30           C  
ATOM    925  O   LYS   116      46.454  62.315   4.770  1.00 42.24           O  
ATOM    926  CB  LYS   116      45.944  62.167   1.595  1.00 44.43           C  
ATOM    927  CG  LYS   116      45.694  61.624   0.183  1.00 46.12           C  
ATOM    928  CD  LYS   116      46.476  62.501  -0.855  1.00 48.81           C  
ATOM    929  CE  LYS   116      45.588  63.021  -2.009  1.00 50.12           C  
ATOM    930  NZ  LYS   116      45.068  61.926  -2.889  1.00 51.16           N  
ATOM    931  N   LEU   117      47.795  60.786   3.801  1.00 43.26           N  
ATOM    932  CA  LEU   117      48.880  60.847   4.762  1.00 43.52           C  
ATOM    933  C   LEU   117      49.768  62.060   4.391  1.00 43.97           C  
ATOM    934  O   LEU   117      49.868  62.431   3.218  1.00 43.20           O  
ATOM    935  CB  LEU   117      49.662  59.524   4.650  1.00 43.32           C  
ATOM    936  CG  LEU   117      49.971  58.514   5.768  1.00 42.50           C  
ATOM    937  CD1 LEU   117      49.035  58.460   6.894  1.00 38.84           C  
ATOM    938  CD2 LEU   117      50.079  57.121   5.121  1.00 41.84           C  
ATOM    939  N   ALA   118      50.407  62.680   5.379  1.00 45.49           N  
ATOM    940  CA  ALA   118      51.416  63.721   5.118  1.00 46.60           C  
ATOM    941  C   ALA   118      52.688  63.104   4.473  1.00 47.17           C  
ATOM    942  O   ALA   118      52.980  61.941   4.739  1.00 46.34           O  
ATOM    943  CB  ALA   118      51.750  64.457   6.420  1.00 47.88           C  
ATOM    944  N   PRO   119      53.399  63.850   3.574  1.00 47.51           N  
ATOM    945  CA  PRO   119      54.599  63.389   2.842  1.00 47.59           C  
ATOM    946  C   PRO   119      55.693  62.724   3.689  1.00 47.35           C  
ATOM    947  O   PRO   119      56.294  61.727   3.249  1.00 46.86           O  
ATOM    948  CB  PRO   119      55.169  64.678   2.206  1.00 47.81           C  
ATOM    949  CG  PRO   119      53.996  65.589   2.057  1.00 48.09           C  
ATOM    950  CD  PRO   119      52.975  65.194   3.127  1.00 48.21           C  
ATOM    951  N   ALA   120      55.949  63.290   4.875  1.00 46.56           N  
ATOM    952  CA  ALA   120      57.009  62.781   5.740  1.00 46.24           C  
ATOM    953  C   ALA   120      56.628  61.425   6.315  1.00 44.99           C  
ATOM    954  O   ALA   120      57.461  60.542   6.467  1.00 43.76           O  
ATOM    955  CB  ALA   120      57.310  63.767   6.869  1.00 46.49           C  
ATOM    956  N   ARG   121      55.364  61.273   6.649  1.00 44.79           N  
ATOM    957  CA  ARG   121      54.872  60.019   7.199  1.00 44.89           C  
ATOM    958  C   ARG   121      54.772  58.924   6.150  1.00 43.80           C  
ATOM    959  O   ARG   121      55.066  57.770   6.436  1.00 43.62           O  
ATOM    960  CB  ARG   121      53.491  60.228   7.743  1.00 45.15           C  
ATOM    961  CG  ARG   121      52.984  59.105   8.616  1.00 47.67           C  
ATOM    962  CD  ARG   121      53.018  59.592  10.052  1.00 48.71           C  
ATOM    963  NE  ARG   121      51.957  59.036  10.799  1.00 47.08           N  
ATOM    964  CZ  ARG   121      51.534  59.475  11.983  1.00 45.97           C  
ATOM    965  NH1 ARG   121      50.526  58.854  12.536  1.00 42.19           N  
ATOM    966  NH2 ARG   121      52.105  60.484  12.633  1.00 42.92           N  
ATOM    967  N   ARG   122      54.295  59.281   4.962  1.00 42.61           N  
ATOM    968  CA  ARG   122      54.302  58.366   3.838  1.00 42.30           C  
ATOM    969  C   ARG   122      55.717  57.791   3.628  1.00 42.47           C  
ATOM    970  O   ARG   122      55.894  56.603   3.371  1.00 41.94           O  
ATOM    971  CB  ARG   122      53.861  59.088   2.582  1.00 41.69           C  
ATOM    972  CG  ARG   122      53.694  58.186   1.376  1.00 41.56           C  
ATOM    973  CD  ARG   122      53.218  58.964   0.170  1.00 41.36           C  
ATOM    974  NE  ARG   122      52.043  59.741   0.536  1.00 40.48           N  
ATOM    975  CZ  ARG   122      50.842  59.221   0.739  1.00 43.83           C  
ATOM    976  NH1 ARG   122      50.639  57.914   0.587  1.00 45.33           N  
ATOM    977  NH2 ARG   122      49.835  60.018   1.125  1.00 40.81           N  
ATOM    978  N   LYS   123      56.719  58.642   3.707  1.00 42.91           N  
ATOM    979  CA  LYS   123      58.126  58.207   3.531  1.00 43.36           C  
ATOM    980  C   LYS   123      58.548  57.179   4.554  1.00 42.40           C  
ATOM    981  O   LYS   123      59.149  56.157   4.210  1.00 42.17           O  
ATOM    982  CB  LYS   123      59.087  59.375   3.697  1.00 45.04           C  
ATOM    983  CG  LYS   123      59.344  60.143   2.450  1.00 49.40           C  
ATOM    984  CD  LYS   123      60.707  60.818   2.482  1.00 54.56           C  
ATOM    985  CE  LYS   123      60.650  62.240   1.878  1.00 57.35           C  
ATOM    986  NZ  LYS   123      59.260  62.655   1.400  1.00 57.21           N  
ATOM    987  N   VAL   124      58.269  57.467   5.819  1.00 41.11           N  
ATOM    988  CA  VAL   124      58.646  56.570   6.908  1.00 40.38           C  
ATOM    989  C   VAL   124      58.011  55.204   6.725  1.00 39.67           C  
ATOM    990  O   VAL   124      58.674  54.169   6.875  1.00 38.37           O  
ATOM    991  CB  VAL   124      58.257  57.153   8.287  1.00 40.77           C  
ATOM    992  CG1 VAL   124      58.451  56.116   9.393  1.00 42.42           C  
ATOM    993  CG2 VAL   124      59.092  58.337   8.592  1.00 40.80           C  
ATOM    994  N   LEU   125      56.715  55.188   6.383  1.00 38.13           N  
ATOM    995  CA  LEU   125      56.004  53.955   6.266  1.00 37.40           C  
ATOM    996  C   LEU   125      56.437  53.132   5.049  1.00 36.22           C  
ATOM    997  O   LEU   125      56.467  51.932   5.119  1.00 36.07           O  
ATOM    998  CB  LEU   125      54.501  54.230   6.178  1.00 37.35           C  
ATOM    999  CG  LEU   125      53.866  54.793   7.444  1.00 38.53           C  
ATOM   1000  CD1 LEU   125      52.439  55.234   7.103  1.00 36.55           C  
ATOM   1001  CD2 LEU   125      53.867  53.719   8.560  1.00 36.32           C  
ATOM   1002  N   ILE   126      56.713  53.779   3.931  1.00 36.14           N  
ATOM   1003  CA  ILE   126      57.241  53.080   2.749  1.00 35.99           C  
ATOM   1004  C   ILE   126      58.612  52.438   3.014  1.00 35.57           C  
ATOM   1005  O   ILE   126      58.883  51.300   2.576  1.00 35.09           O  
ATOM   1006  CB  ILE   126      57.222  53.984   1.480  1.00 35.88           C  
ATOM   1007  CG1 ILE   126      55.759  54.345   1.163  1.00 36.66           C  
ATOM   1008  CG2 ILE   126      57.978  53.277   0.261  1.00 35.04           C  
ATOM   1009  CD1 ILE   126      55.552  55.126  -0.092  1.00 37.14           C  
ATOM   1010  N   GLN   127      59.435  53.122   3.788  1.00 35.49           N  
ATOM   1011  CA  GLN   127      60.748  52.618   4.177  1.00 35.94           C  
ATOM   1012  C   GLN   127      60.589  51.363   5.038  1.00 36.10           C  
ATOM   1013  O   GLN   127      61.335  50.365   4.870  1.00 34.83           O  
ATOM   1014  CB  GLN   127      61.554  53.697   4.921  1.00 37.03           C  
ATOM   1015  CG  GLN   127      62.818  53.214   5.609  1.00 37.55           C  
ATOM   1016  CD  GLN   127      63.933  53.025   4.659  1.00 40.37           C  
ATOM   1017  OE1 GLN   127      64.111  53.833   3.752  1.00 42.14           O  
ATOM   1018  NE2 GLN   127      64.746  51.989   4.882  1.00 41.30           N  
ATOM   1019  N   LYS   128      59.604  51.410   5.936  1.00 35.63           N  
ATOM   1020  CA  LYS   128      59.332  50.301   6.848  1.00 34.77           C  
ATOM   1021  C   LYS   128      58.790  49.110   6.089  1.00 34.02           C  
ATOM   1022  O   LYS   128      59.157  47.982   6.371  1.00 33.41           O  
ATOM   1023  CB  LYS   128      58.342  50.717   7.931  1.00 34.60           C  
ATOM   1024  CG  LYS   128      58.969  51.487   9.048  1.00 39.61           C  
ATOM   1025  CD  LYS   128      57.941  52.005  10.052  1.00 41.93           C  
ATOM   1026  CE  LYS   128      58.606  53.085  10.914  1.00 46.04           C  
ATOM   1027  NZ  LYS   128      58.280  52.892  12.368  1.00 46.57           N  
ATOM   1028  N   PHE   129      57.890  49.380   5.153  1.00 32.95           N  
ATOM   1029  CA  PHE   129      57.306  48.360   4.312  1.00 33.01           C  
ATOM   1030  C   PHE   129      58.395  47.649   3.492  1.00 33.38           C  
ATOM   1031  O   PHE   129      58.469  46.406   3.489  1.00 33.16           O  
ATOM   1032  CB  PHE   129      56.273  49.021   3.422  1.00 32.46           C  
ATOM   1033  CG  PHE   129      55.574  48.100   2.489  1.00 31.79           C  
ATOM   1034  CD1 PHE   129      54.278  47.682   2.758  1.00 32.57           C  
ATOM   1035  CD2 PHE   129      56.158  47.685   1.311  1.00 31.11           C  
ATOM   1036  CE1 PHE   129      53.610  46.856   1.869  1.00 30.91           C  
ATOM   1037  CE2 PHE   129      55.499  46.864   0.425  1.00 32.46           C  
ATOM   1038  CZ  PHE   129      54.230  46.422   0.702  1.00 31.79           C  
ATOM   1039  N   ALA   130      59.221  48.448   2.818  1.00 33.33           N  
ATOM   1040  CA  ALA   130      60.407  47.950   2.052  1.00 33.63           C  
ATOM   1041  C   ALA   130      61.277  47.025   2.897  1.00 32.83           C  
ATOM   1042  O   ALA   130      61.613  45.899   2.523  1.00 31.42           O  
ATOM   1043  CB  ALA   130      61.250  49.124   1.558  1.00 32.72           C  
ATOM   1044  N   THR   131      61.591  47.500   4.073  1.00 32.85           N  
ATOM   1045  CA  THR   131      62.413  46.753   4.979  1.00 33.64           C  
ATOM   1046  C   THR   131      61.783  45.448   5.399  1.00 32.48           C  
ATOM   1047  O   THR   131      62.454  44.430   5.442  1.00 31.61           O  
ATOM   1048  CB  THR   131      62.747  47.599   6.186  1.00 34.24           C  
ATOM   1049  OG1 THR   131      63.439  48.756   5.711  1.00 34.28           O  
ATOM   1050  CG2 THR   131      63.637  46.820   7.134  1.00 36.35           C  
ATOM   1051  N   HIS   132      60.485  45.489   5.691  1.00 33.22           N  
ATOM   1052  CA  HIS   132      59.739  44.311   6.126  1.00 32.97           C  
ATOM   1053  C   HIS   132      59.736  43.274   5.015  1.00 32.06           C  
ATOM   1054  O   HIS   132      60.071  42.089   5.202  1.00 30.93           O  
ATOM   1055  CB  HIS   132      58.309  44.767   6.490  1.00 33.23           C  
ATOM   1056  CG  HIS   132      57.380  43.673   6.899  1.00 33.85           C  
ATOM   1057  ND1 HIS   132      56.700  43.700   8.101  1.00 33.95           N  
ATOM   1058  CD2 HIS   132      56.937  42.569   6.243  1.00 33.16           C  
ATOM   1059  CE1 HIS   132      55.908  42.643   8.179  1.00 32.64           C  
ATOM   1060  NE2 HIS   132      56.031  41.942   7.065  1.00 30.46           N  
ATOM   1061  N   ALA   133      59.328  43.727   3.837  1.00 31.75           N  
ATOM   1062  CA  ALA   133      59.244  42.852   2.693  1.00 30.24           C  
ATOM   1063  C   ALA   133      60.567  42.187   2.369  1.00 29.49           C  
ATOM   1064  O   ALA   133      60.622  40.971   2.107  1.00 30.73           O  
ATOM   1065  CB  ALA   133      58.757  43.650   1.511  1.00 29.31           C  
ATOM   1066  N   ALA   134      61.631  42.982   2.316  1.00 28.49           N  
ATOM   1067  CA  ALA   134      62.926  42.475   1.881  1.00 27.28           C  
ATOM   1068  C   ALA   134      63.539  41.515   2.914  1.00 28.08           C  
ATOM   1069  O   ALA   134      64.128  40.517   2.524  1.00 26.06           O  
ATOM   1070  CB  ALA   134      63.887  43.601   1.497  1.00 28.12           C  
ATOM   1071  N   ARG   135      63.335  41.771   4.208  1.00 29.15           N  
ATOM   1072  CA  ARG   135      63.798  40.846   5.246  1.00 29.60           C  
ATOM   1073  C   ARG   135      63.136  39.496   5.099  1.00 30.00           C  
ATOM   1074  O   ARG   135      63.804  38.471   5.096  1.00 30.62           O  
ATOM   1075  CB  ARG   135      63.525  41.364   6.672  1.00 29.23           C  
ATOM   1076  CG  ARG   135      64.605  42.218   7.201  1.00 34.62           C  
ATOM   1077  CD  ARG   135      64.358  42.618   8.697  1.00 38.89           C  
ATOM   1078  NE  ARG   135      65.422  43.550   9.090  1.00 47.15           N  
ATOM   1079  CZ  ARG   135      65.246  44.733   9.701  1.00 50.14           C  
ATOM   1080  NH1 ARG   135      64.028  45.160  10.070  1.00 50.63           N  
ATOM   1081  NH2 ARG   135      66.312  45.488   9.974  1.00 49.80           N  
ATOM   1082  N   ARG   136      61.790  39.495   5.037  1.00 30.67           N  
ATOM   1083  CA  ARG   136      61.048  38.243   4.931  1.00 30.83           C  
ATOM   1084  C   ARG   136      61.417  37.475   3.691  1.00 29.56           C  
ATOM   1085  O   ARG   136      61.473  36.261   3.712  1.00 29.65           O  
ATOM   1086  CB  ARG   136      59.524  38.505   4.909  1.00 31.76           C  
ATOM   1087  CG  ARG   136      59.014  39.294   6.065  1.00 36.83           C  
ATOM   1088  CD  ARG   136      59.004  38.556   7.316  1.00 42.45           C  
ATOM   1089  NE  ARG   136      58.221  39.289   8.324  1.00 48.18           N  
ATOM   1090  CZ  ARG   136      58.682  40.286   9.099  1.00 51.11           C  
ATOM   1091  NH1 ARG   136      59.940  40.731   8.999  1.00 52.60           N  
ATOM   1092  NH2 ARG   136      57.870  40.847   9.986  1.00 52.86           N  
ATOM   1093  N   LEU   137      61.579  38.178   2.582  1.00 29.38           N  
ATOM   1094  CA  LEU   137      61.999  37.561   1.329  1.00 28.94           C  
ATOM   1095  C   LEU   137      63.352  36.874   1.462  1.00 29.34           C  
ATOM   1096  O   LEU   137      63.513  35.689   1.113  1.00 30.12           O  
ATOM   1097  CB  LEU   137      62.057  38.612   0.245  1.00 28.19           C  
ATOM   1098  CG  LEU   137      62.578  38.237  -1.144  1.00 28.63           C  
ATOM   1099  CD1 LEU   137      61.872  37.025  -1.693  1.00 28.56           C  
ATOM   1100  CD2 LEU   137      62.419  39.454  -2.036  1.00 27.13           C  
ATOM   1101  N   GLN   138      64.330  37.599   2.009  1.00 28.89           N  
ATOM   1102  CA  GLN   138      65.664  37.027   2.177  1.00 27.63           C  
ATOM   1103  C   GLN   138      65.642  35.771   3.076  1.00 28.06           C  
ATOM   1104  O   GLN   138      66.330  34.810   2.799  1.00 28.10           O  
ATOM   1105  CB  GLN   138      66.680  38.080   2.654  1.00 27.43           C  
ATOM   1106  CG  GLN   138      68.167  37.618   2.581  1.00 25.72           C  
ATOM   1107  CD  GLN   138      68.624  36.982   3.883  1.00 28.91           C  
ATOM   1108  OE1 GLN   138      67.839  36.922   4.854  1.00 30.24           O  
ATOM   1109  NE2 GLN   138      69.870  36.485   3.921  1.00 24.05           N  
ATOM   1110  N   ALA   139      64.847  35.800   4.132  1.00 29.36           N  
ATOM   1111  CA  ALA   139      64.735  34.690   5.035  1.00 30.23           C  
ATOM   1112  C   ALA   139      64.095  33.433   4.382  1.00 32.15           C  
ATOM   1113  O   ALA   139      64.429  32.303   4.759  1.00 33.40           O  
ATOM   1114  CB  ALA   139      63.982  35.118   6.266  1.00 29.95           C  
ATOM   1115  N   LEU   140      63.170  33.615   3.445  1.00 32.96           N  
ATOM   1116  CA  LEU   140      62.568  32.490   2.722  1.00 34.03           C  
ATOM   1117  C   LEU   140      63.532  31.926   1.724  1.00 35.42           C  
ATOM   1118  O   LEU   140      63.681  30.714   1.620  1.00 35.86           O  
ATOM   1119  CB  LEU   140      61.274  32.916   2.012  1.00 33.87           C  
ATOM   1120  CG  LEU   140      60.018  32.982   2.847  1.00 35.13           C  
ATOM   1121  CD1 LEU   140      58.791  33.326   1.930  1.00 32.30           C  
ATOM   1122  CD2 LEU   140      59.794  31.673   3.641  1.00 35.34           C  
ATOM   1123  N   ARG   141      64.276  32.801   1.047  1.00 36.64           N  
ATOM   1124  CA  ARG   141      65.287  32.352   0.075  1.00 37.91           C  
ATOM   1125  C   ARG   141      66.548  31.761   0.649  1.00 37.87           C  
ATOM   1126  O   ARG   141      67.213  30.962  -0.007  1.00 37.13           O  
ATOM   1127  CB  ARG   141      65.639  33.496  -0.864  1.00 38.46           C  
ATOM   1128  CG  ARG   141      64.421  34.078  -1.487  1.00 41.46           C  
ATOM   1129  CD  ARG   141      64.562  34.460  -2.929  1.00 47.70           C  
ATOM   1130  NE  ARG   141      65.693  35.313  -3.174  1.00 52.73           N  
ATOM   1131  CZ  ARG   141      66.759  34.994  -3.922  1.00 57.69           C  
ATOM   1132  NH1 ARG   141      67.731  35.873  -4.045  1.00 57.08           N  
ATOM   1133  NH2 ARG   141      66.877  33.820  -4.558  1.00 60.85           N  
ATOM   1134  N   ASP   142      66.873  32.133   1.894  1.00 36.79           N  
ATOM   1135  CA  ASP   142      68.116  31.738   2.528  1.00 35.37           C  
ATOM   1136  C   ASP   142      67.823  31.607   4.025  1.00 35.29           C  
ATOM   1137  O   ASP   142      68.215  32.455   4.788  1.00 33.42           O  
ATOM   1138  CB  ASP   142      69.171  32.819   2.244  1.00 35.26           C  
ATOM   1139  CG  ASP   142      70.549  32.503   2.793  1.00 34.73           C  
ATOM   1140  OD1 ASP   142      70.806  31.384   3.324  1.00 36.25           O  
ATOM   1141  OD2 ASP   142      71.403  33.419   2.715  1.00 29.26           O  
ATOM   1142  N   PRO   143      67.130  30.523   4.427  1.00 36.28           N  
ATOM   1143  CA  PRO   143      66.664  30.323   5.800  1.00 35.81           C  
ATOM   1144  C   PRO   143      67.740  30.476   6.879  1.00 35.40           C  
ATOM   1145  O   PRO   143      67.446  31.016   7.961  1.00 34.44           O  
ATOM   1146  CB  PRO   143      66.105  28.904   5.789  1.00 36.12           C  
ATOM   1147  CG  PRO   143      65.852  28.569   4.361  1.00 37.43           C  
ATOM   1148  CD  PRO   143      66.667  29.454   3.512  1.00 37.57           C  
END
