
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1087),  selected  138 , name 2hq9_B
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2hq9_B.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      -       -           -
LGA    L     2_B      -       -           -
LGA    V     3_B      -       -           -
LGA    R     4_B      -       -           -
LGA    T     5_B      -       -           -
LGA    L     6_B      M       1           #
LGA    -       -      A       2           -
LGA    S     7_B      D       3          4.406
LGA    A     8_B      P       4          3.571
LGA    L     9_B      K       5          3.652
LGA    -       -      E       6           -
LGA    -       -      L       7           -
LGA    -       -      Q       8           -
LGA    -       -      D       9           -
LGA    E    10_B      K      10          2.569
LGA    C    11_B      F      11          2.231
LGA    T    12_B      W      12          2.306
LGA    K    13_B      K      13          2.305
LGA    V    14_B      A      14          2.151
LGA    L    15_B      L      15          1.888
LGA    T    16_B      K      16          2.429
LGA    A    17_B      S      17          2.516
LGA    N    18_B      D      18          1.878
LGA    R    19_B      R      19          1.726
LGA    V    20_B      T      20          1.326
LGA    G    21_B      V      21          1.328
LGA    R    22_B      M      22          0.809
LGA    L    23_B      L      23          0.916
LGA    A    24_B      G      24          0.871
LGA    C    25_B      L      25          1.301
LGA    A    26_B      D      26          4.611
LGA    K    27_B      G      27           #
LGA    D    28_B      V      28          4.441
LGA    G    29_B      E      29          4.014
LGA    Q    30_B      D      30          3.378
LGA    P    31_B      G      31          1.808
LGA    Y    32_B      H      32          1.949
LGA    V    33_B      A      33          0.230
LGA    V    34_B      R      34          0.383
LGA    P    35_B      P      35          0.781
LGA    L    36_B      M      36          0.503
LGA    Y    37_B      T      37          1.113
LGA    Y    38_B      A      38          1.702
LGA    A    39_B      Q      39          0.584
LGA    Y    40_B      I      40          1.999
LGA    S    41_B      E      41          3.073
LGA    -       -      G      42           -
LGA    -       -      D      43           -
LGA    -       -      S      44           -
LGA    D    42_B      G      45          3.534
LGA    A    43_B      G      46          1.421
LGA    H    44_B      P      47          1.457
LGA    L    45_B      I      48          1.013
LGA    Y    46_B      W      49          0.905
LGA    A    47_B      F      50          1.424
LGA    F    48_B      F      51          1.391
LGA    S    49_B      T      52          1.191
LGA    X    50_B      S      53          0.932
LGA    P    51_B      K      54          1.932
LGA    G    52_B      D      55          2.568
LGA    -       -      N      56           -
LGA    K    53_B      A      57          0.920
LGA    K    54_B      L      58          1.451
LGA    I    55_B      I      59          1.042
LGA    E    56_B      A      60          1.406
LGA    W    57_B      M      61          2.241
LGA    X    58_B      L      62          2.498
LGA    R    59_B      G      63          3.081
LGA    A    60_B      Q      64           #
LGA    N    61_B      G      65          5.568
LGA    P    62_B      R      66          1.382
LGA    R    63_B      R      67          0.908
LGA    V    64_B      V      68          0.904
LGA    S    65_B      I      69          1.208
LGA    V    66_B      G      70          1.043
LGA    Q    67_B      A      71          1.740
LGA    V    68_B      F      72          1.599
LGA    D    69_B      S      73          0.998
LGA    E    70_B      S      74          1.598
LGA    H    71_B      K      75          3.884
LGA    G    72_B      G      76          3.655
LGA    Q    73_B      H      77           -
LGA    G    74_B      -       -           -
LGA    R    75_B      -       -           -
LGA    G    76_B      -       -           -
LGA    W    77_B      D      78          2.221
LGA    K    78_B      L      79          0.929
LGA    S    79_B      F      80          1.053
LGA    V    80_B      A      81          1.261
LGA    V    81_B      S      82          1.300
LGA    V    82_B      I      83          0.785
LGA    D    83_B      S      84          0.439
LGA    G    84_B      G      85          1.127
LGA    R    85_B      S      86          0.724
LGA    Y    86_B      L      87          1.146
LGA    E    87_B      R      88          2.902
LGA    E    88_B      E      89          1.681
LGA    L    89_B      D      90          1.321
LGA    P    90_B      T      91          3.525
LGA    D    91_B      -       -           -
LGA    L    92_B      -       -           -
LGA    I    93_B      -       -           -
LGA    G    94_B      -       -           -
LGA    H    95_B      D      92          3.066
LGA    K    96_B      P      93          2.617
LGA    L    97_B      A      94          2.475
LGA    Q    98_B      V      95          1.389
LGA    R    99_B      V      96          1.113
LGA    D   100_B      D      97          0.604
LGA    H   101_B      R      98          1.335
LGA    A   102_B      L      99          1.226
LGA    W   103_B      W     100          2.055
LGA    S   104_B      N     101          1.974
LGA    V   105_B      P     102           #
LGA    L   106_B      Y     103          4.744
LGA    S   107_B      V     104          1.484
LGA    K   108_B      A     105          4.789
LGA    H   109_B      A     106           #
LGA    T   110_B      -       -           -
LGA    D   111_B      W     107          2.619
LGA    W   112_B      Y     108           -
LGA    W   113_B      -       -           -
LGA    E   114_B      -       -           -
LGA    P   115_B      -       -           -
LGA    G   116_B      E     109           #
LGA    A   117_B      G     110           #
LGA    L   118_B      G     111           -
LGA    S   128_B      K     112          2.721
LGA    A   129_B      D     113          2.868
LGA    P   130_B      D     114          3.924
LGA    -       -      P     115           -
LGA    -       -      K     116           -
LGA    H   131_B      L     117          0.492
LGA    V   132_B      A     118          0.892
LGA    F   133_B      L     119          1.341
LGA    F   134_B      L     120          1.987
LGA    R   135_B      R     121          1.056
LGA    I   136_B      L     122          0.586
LGA    L   137_B      D     123          0.831
LGA    I   138_B      A     124          0.839
LGA    E   139_B      D     125          0.537
LGA    Q   140_B      H     126          0.980
LGA    V   141_B      A     127          1.144
LGA    S   142_B      Q     128          1.651
LGA    G   143_B      I     129          0.914
LGA    R   144_B      W     130          0.756
LGA    E   145_B      L     131          1.274
LGA    A   146_B      N     132          1.189
LGA    S   147_B      G     133          2.247
LGA    -       -      S     134           -
LGA    -       -      S     135           -
LGA    -       -      L     136           -
LGA    -       -      L     137           -
LGA    -       -      A     138           -
LGA    -       -      G     139           -
LGA    -       -      I     140           -
LGA    -       -      K     141           -
LGA    -       -      V     142           -
LGA    -       -      L     143           -
LGA    -       -      L     144           -
LGA    -       -      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  145    5.0    112    2.15    13.39     54.931     4.968

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.478401 * X  +  -0.503603 * Y  +  -0.719386 * Z  +  37.353500
  Y_new =   0.451528 * X  +   0.843693 * Y  +  -0.290353 * Z  + -29.368122
  Z_new =   0.753164 * X  +  -0.185918 * Y  +   0.631014 * Z  + -13.236484 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.286526    2.855067  [ DEG:   -16.4167    163.5833 ]
  Theta =  -0.852858   -2.288734  [ DEG:   -48.8652   -131.1348 ]
  Phi   =   0.756508   -2.385084  [ DEG:    43.3447   -136.6553 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hq9_B                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hq9_B.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  145   5.0  112   2.15   13.39  54.931
REMARK  ---------------------------------------------------------- 
MOLECULE 2hq9_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-JUL-06   2HQ9              
TITLE     CRYSTAL STRUCTURE OF A FAD-BINDING PROTEIN (NP_107146.1)              
TITLE    2 FROM MESORHIZOBIUM LOTI AT 1.95 A RESOLUTION                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MLL6688 PROTEIN;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHIZOBIUM LOTI;                                 
SOURCE   3 ORGANISM_COMMON: MESORHIZOBIUM LOTI;                                 
SOURCE   4 GENE: NP_107146.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_107146.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2HQ9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_107146.1) FROM MESORHIZOBIUM LOTI AT 1.95 A              
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2HQ9 A    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
DBREF  2HQ9 B    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
SEQRES   1 A  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 A  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 A  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 A  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 A  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 A  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 A  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 A  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 A  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 A  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 A  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 A  149  GLY ARG GLU ALA SER GLU                                      
SEQRES   1 B  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 B  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 B  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 B  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 B  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 B  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 B  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 B  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 B  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 B  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 B  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 B  149  GLY ARG GLU ALA SER GLU                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  58       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  58       8                                                       
HET     CL      1       1                                                       
HET    FAD  A 200      53                                                       
HET    FAD  B 200      53                                                       
HET    EDO      2       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   6  EDO    C2 H6 O2                                                     
FORMUL   7  HOH   *178(H2 O)                                                    
CRYST1   47.852   74.895   84.626  90.00  90.00  90.00 P 21 21 21    8          
HETATM 1091  N   MSE B   1      29.329  36.268  14.138  1.00 46.39           N  
HETATM 1092  CA  MSE B   1      27.836  36.336  14.059  1.00 46.28           C  
HETATM 1093  C   MSE B   1      27.241  37.177  15.185  1.00 44.25           C  
HETATM 1094  O   MSE B   1      27.374  36.817  16.374  1.00 44.80           O  
HETATM 1095  CB  MSE B   1      27.223  34.921  14.124  1.00 47.65           C  
HETATM 1096  CG  MSE B   1      27.691  33.991  13.000  1.00 50.54           C  
HETATM 1097 SE   MSE B   1      26.884  34.373  11.277  0.75 56.80          SE  
HETATM 1098  CE  MSE B   1      28.296  33.627  10.029  1.00 54.20           C  
ATOM   1099  N   LEU B   2      26.582  38.276  14.818  1.00 41.23           N  
ATOM   1100  CA  LEU B   2      25.627  38.901  15.723  1.00 39.08           C  
ATOM   1101  C   LEU B   2      24.628  37.798  16.049  1.00 37.07           C  
ATOM   1102  O   LEU B   2      23.975  37.316  15.149  1.00 36.38           O  
ATOM   1103  CB  LEU B   2      24.896  40.078  15.069  1.00 38.77           C  
ATOM   1104  N   VAL B   3      24.566  37.374  17.307  1.00 34.89           N  
ATOM   1105  CA  VAL B   3      23.460  36.544  17.796  1.00 33.94           C  
ATOM   1106  C   VAL B   3      22.606  37.343  18.782  1.00 32.88           C  
ATOM   1107  O   VAL B   3      23.116  38.005  19.683  1.00 32.69           O  
ATOM   1108  CB  VAL B   3      23.974  35.247  18.467  1.00 34.20           C  
ATOM   1109  CG1 VAL B   3      22.834  34.396  18.985  1.00 32.37           C  
ATOM   1110  CG2 VAL B   3      24.858  34.447  17.482  1.00 34.67           C  
ATOM   1111  N   ARG B   4      21.297  37.278  18.614  1.00 31.81           N  
ATOM   1112  CA  ARG B   4      20.382  38.035  19.458  1.00 31.24           C  
ATOM   1113  C   ARG B   4      19.122  37.222  19.679  1.00 29.75           C  
ATOM   1114  O   ARG B   4      18.814  36.333  18.889  1.00 26.62           O  
ATOM   1115  CB  ARG B   4      20.016  39.341  18.778  1.00 32.33           C  
ATOM   1116  CG  ARG B   4      19.990  39.226  17.267  1.00 36.25           C  
ATOM   1117  CD  ARG B   4      19.555  40.530  16.609  1.00 40.75           C  
ATOM   1118  NE  ARG B   4      18.103  40.737  16.684  1.00 42.12           N  
ATOM   1119  CZ  ARG B   4      17.198  40.035  15.998  1.00 43.89           C  
ATOM   1120  NH1 ARG B   4      17.579  39.045  15.186  1.00 44.50           N  
ATOM   1121  NH2 ARG B   4      15.897  40.310  16.130  1.00 41.40           N  
ATOM   1122  N   THR B   5      18.395  37.565  20.734  1.00 28.02           N  
ATOM   1123  CA  THR B   5      17.163  36.899  21.026  1.00 28.34           C  
ATOM   1124  C   THR B   5      16.035  37.543  20.233  1.00 27.71           C  
ATOM   1125  O   THR B   5      16.090  38.712  19.927  1.00 26.56           O  
ATOM   1126  CB  THR B   5      16.804  36.951  22.517  1.00 28.16           C  
ATOM   1127  OG1 THR B   5      16.397  38.274  22.852  1.00 30.93           O  
ATOM   1128  CG2 THR B   5      17.976  36.524  23.385  1.00 28.73           C  
ATOM   1129  N   LEU B   6      14.981  36.773  19.963  1.00 26.54           N  
ATOM   1130  CA  LEU B   6      13.929  37.221  19.101  1.00 26.65           C  
ATOM   1131  C   LEU B   6      12.793  37.686  19.986  1.00 27.22           C  
ATOM   1132  O   LEU B   6      12.613  37.197  21.084  1.00 28.41           O  
ATOM   1133  CB  LEU B   6      13.419  36.085  18.193  1.00 26.12           C  
ATOM   1134  CG  LEU B   6      14.311  35.548  17.081  1.00 25.83           C  
ATOM   1135  CD1 LEU B   6      13.633  34.400  16.332  1.00 25.14           C  
ATOM   1136  CD2 LEU B   6      14.707  36.624  16.114  1.00 25.72           C  
ATOM   1137  N   SER B   7      11.995  38.592  19.481  1.00 27.89           N  
ATOM   1138  CA  SER B   7      10.833  39.081  20.230  1.00 28.49           C  
ATOM   1139  C   SER B   7       9.789  37.988  20.204  1.00 28.98           C  
ATOM   1140  O   SER B   7       9.870  37.065  19.379  1.00 29.04           O  
ATOM   1141  CB  SER B   7      10.291  40.318  19.542  1.00 28.35           C  
ATOM   1142  OG  SER B   7       9.868  39.971  18.243  1.00 28.20           O  
ATOM   1143  N   ALA B   8       8.782  38.081  21.065  1.00 29.28           N  
ATOM   1144  CA  ALA B   8       7.684  37.129  21.004  1.00 29.28           C  
ATOM   1145  C   ALA B   8       7.040  37.075  19.605  1.00 29.42           C  
ATOM   1146  O   ALA B   8       6.742  36.010  19.088  1.00 29.91           O  
ATOM   1147  CB  ALA B   8       6.639  37.461  22.057  1.00 30.11           C  
ATOM   1148  N   LEU B   9       6.855  38.222  18.974  1.00 29.51           N  
ATOM   1149  CA  LEU B   9       6.216  38.267  17.655  1.00 29.19           C  
ATOM   1150  C   LEU B   9       7.128  37.657  16.550  1.00 29.36           C  
ATOM   1151  O   LEU B   9       6.658  37.000  15.612  1.00 28.40           O  
ATOM   1152  CB  LEU B   9       5.812  39.716  17.361  1.00 30.49           C  
ATOM   1153  CG  LEU B   9       4.888  40.390  18.429  1.00 32.24           C  
ATOM   1154  CD1 LEU B   9       4.659  41.844  18.130  1.00 33.09           C  
ATOM   1155  CD2 LEU B   9       3.542  39.680  18.585  1.00 33.74           C  
ATOM   1156  N   GLU B  10       8.447  37.826  16.688  1.00 28.95           N  
ATOM   1157  CA  GLU B  10       9.386  37.210  15.737  1.00 29.37           C  
ATOM   1158  C   GLU B  10       9.324  35.671  15.846  1.00 27.75           C  
ATOM   1159  O   GLU B  10       9.435  34.965  14.855  1.00 27.20           O  
ATOM   1160  CB  GLU B  10      10.816  37.707  15.972  1.00 29.03           C  
ATOM   1161  CG  GLU B  10      11.035  39.187  15.596  1.00 31.79           C  
ATOM   1162  CD  GLU B  10      12.473  39.658  15.809  1.00 32.67           C  
ATOM   1163  OE1 GLU B  10      12.930  39.689  16.981  1.00 36.93           O  
ATOM   1164  OE2 GLU B  10      13.134  40.021  14.804  1.00 38.87           O  
ATOM   1165  N   CYS B  11       9.147  35.167  17.059  1.00 27.75           N  
ATOM   1166  CA  CYS B  11       9.072  33.729  17.285  1.00 27.32           C  
ATOM   1167  C   CYS B  11       7.860  33.135  16.579  1.00 27.17           C  
ATOM   1168  O   CYS B  11       7.967  32.178  15.813  1.00 26.87           O  
ATOM   1169  CB  CYS B  11       9.054  33.398  18.775  1.00 27.52           C  
ATOM   1170  SG  CYS B  11      10.538  33.766  19.665  1.00 27.17           S  
ATOM   1171  N   THR B  12       6.717  33.759  16.781  1.00 26.62           N  
ATOM   1172  CA  THR B  12       5.513  33.408  16.044  1.00 27.12           C  
ATOM   1173  C   THR B  12       5.697  33.352  14.527  1.00 25.75           C  
ATOM   1174  O   THR B  12       5.222  32.410  13.901  1.00 24.52           O  
ATOM   1175  CB  THR B  12       4.336  34.316  16.440  1.00 27.68           C  
ATOM   1176  OG1 THR B  12       4.178  34.229  17.867  1.00 30.86           O  
ATOM   1177  CG2 THR B  12       3.046  33.861  15.769  1.00 29.66           C  
ATOM   1178  N   LYS B  13       6.420  34.300  13.944  1.00 24.87           N  
ATOM   1179  CA  LYS B  13       6.653  34.320  12.482  1.00 24.99           C  
ATOM   1180  C   LYS B  13       7.448  33.134  11.985  1.00 24.66           C  
ATOM   1181  O   LYS B  13       7.212  32.628  10.901  1.00 24.48           O  
ATOM   1182  CB  LYS B  13       7.428  35.583  12.034  1.00 24.41           C  
ATOM   1183  CG  LYS B  13       6.574  36.787  11.776  1.00 25.95           C  
ATOM   1184  N   VAL B  14       8.437  32.722  12.767  1.00 25.13           N  
ATOM   1185  CA  VAL B  14       9.225  31.554  12.430  1.00 25.06           C  
ATOM   1186  C   VAL B  14       8.315  30.314  12.500  1.00 24.49           C  
ATOM   1187  O   VAL B  14       8.290  29.551  11.580  1.00 25.12           O  
ATOM   1188  CB  VAL B  14      10.482  31.428  13.364  1.00 24.88           C  
ATOM   1189  CG1 VAL B  14      11.152  30.099  13.197  1.00 26.19           C  
ATOM   1190  CG2 VAL B  14      11.466  32.548  13.100  1.00 23.62           C  
ATOM   1191  N   LEU B  15       7.559  30.142  13.573  1.00 26.01           N  
ATOM   1192  CA  LEU B  15       6.681  28.970  13.714  1.00 26.97           C  
ATOM   1193  C   LEU B  15       5.629  28.892  12.616  1.00 28.75           C  
ATOM   1194  O   LEU B  15       5.354  27.833  12.066  1.00 29.26           O  
ATOM   1195  CB  LEU B  15       5.964  28.982  15.051  1.00 25.97           C  
ATOM   1196  CG  LEU B  15       6.818  28.806  16.274  1.00 25.29           C  
ATOM   1197  CD1 LEU B  15       5.948  29.004  17.465  1.00 28.02           C  
ATOM   1198  CD2 LEU B  15       7.425  27.423  16.311  1.00 24.05           C  
ATOM   1199  N   THR B  16       5.067  30.046  12.289  1.00 30.46           N  
ATOM   1200  CA  THR B  16       4.005  30.138  11.312  1.00 32.35           C  
ATOM   1201  C   THR B  16       4.522  29.731   9.943  1.00 33.21           C  
ATOM   1202  O   THR B  16       3.859  28.985   9.215  1.00 34.22           O  
ATOM   1203  CB  THR B  16       3.470  31.585  11.282  1.00 32.75           C  
ATOM   1204  OG1 THR B  16       2.811  31.891  12.534  1.00 33.36           O  
ATOM   1205  CG2 THR B  16       2.524  31.789  10.137  1.00 34.11           C  
ATOM   1206  N   ALA B  17       5.725  30.199   9.619  1.00 32.90           N  
ATOM   1207  CA  ALA B  17       6.326  30.028   8.307  1.00 32.15           C  
ATOM   1208  C   ALA B  17       6.868  28.643   8.021  1.00 31.49           C  
ATOM   1209  O   ALA B  17       7.057  28.291   6.863  1.00 31.46           O  
ATOM   1210  CB  ALA B  17       7.467  31.058   8.104  1.00 32.69           C  
ATOM   1211  N   ASN B  18       7.152  27.858   9.055  1.00 30.36           N  
ATOM   1212  CA  ASN B  18       7.773  26.577   8.848  1.00 29.25           C  
ATOM   1213  C   ASN B  18       6.802  25.427   9.105  1.00 28.07           C  
ATOM   1214  O   ASN B  18       5.706  25.616   9.631  1.00 27.52           O  
ATOM   1215  CB  ASN B  18       9.038  26.503   9.707  1.00 29.49           C  
ATOM   1216  CG  ASN B  18      10.125  27.387   9.180  1.00 30.04           C  
ATOM   1217  OD1 ASN B  18      10.764  27.056   8.184  1.00 30.15           O  
ATOM   1218  ND2 ASN B  18      10.296  28.561   9.787  1.00 28.20           N  
ATOM   1219  N   ARG B  19       7.214  24.252   8.677  1.00 28.41           N  
ATOM   1220  CA  ARG B  19       6.382  23.023   8.683  1.00 28.87           C  
ATOM   1221  C   ARG B  19       7.024  21.809   9.338  1.00 27.98           C  
ATOM   1222  O   ARG B  19       6.412  20.801   9.453  1.00 26.27           O  
ATOM   1223  CB  ARG B  19       6.038  22.616   7.246  1.00 30.01           C  
ATOM   1224  CG  ARG B  19       7.231  22.248   6.355  1.00 31.49           C  
ATOM   1225  N   VAL B  20       8.291  21.897   9.673  1.00 27.14           N  
ATOM   1226  CA  VAL B  20       8.982  20.797  10.272  1.00 28.37           C  
ATOM   1227  C   VAL B  20       9.686  21.283  11.523  1.00 27.21           C  
ATOM   1228  O   VAL B  20      10.218  22.394  11.586  1.00 27.47           O  
ATOM   1229  CB  VAL B  20       9.953  20.091   9.285  1.00 29.41           C  
ATOM   1230  CG1 VAL B  20      11.107  20.955   8.941  1.00 31.08           C  
ATOM   1231  CG2 VAL B  20      10.468  18.759   9.892  1.00 33.49           C  
ATOM   1232  N   GLY B  21       9.616  20.454  12.544  1.00 25.37           N  
ATOM   1233  CA  GLY B  21      10.303  20.719  13.762  1.00 25.95           C  
ATOM   1234  C   GLY B  21      10.872  19.411  14.288  1.00 24.94           C  
ATOM   1235  O   GLY B  21      10.654  18.358  13.679  1.00 25.82           O  
ATOM   1236  N   ARG B  22      11.604  19.501  15.396  1.00 23.41           N  
ATOM   1237  CA  ARG B  22      12.010  18.349  16.166  1.00 23.42           C  
ATOM   1238  C   ARG B  22      11.259  18.378  17.484  1.00 23.27           C  
ATOM   1239  O   ARG B  22      11.240  19.380  18.198  1.00 25.73           O  
ATOM   1240  CB  ARG B  22      13.525  18.287  16.377  1.00 22.99           C  
ATOM   1241  CG  ARG B  22      14.252  17.567  15.269  1.00 25.30           C  
ATOM   1242  CD  ARG B  22      14.263  18.401  14.061  1.00 27.71           C  
ATOM   1243  NE  ARG B  22      15.016  17.804  12.954  1.00 28.39           N  
ATOM   1244  CZ  ARG B  22      15.203  18.419  11.790  1.00 31.60           C  
ATOM   1245  NH1 ARG B  22      14.687  19.622  11.574  1.00 30.08           N  
ATOM   1246  NH2 ARG B  22      15.909  17.828  10.832  1.00 34.30           N  
ATOM   1247  N   LEU B  23      10.615  17.279  17.796  1.00 23.05           N  
ATOM   1248  CA  LEU B  23       9.813  17.144  18.987  1.00 23.63           C  
ATOM   1249  C   LEU B  23      10.521  16.246  19.980  1.00 23.87           C  
ATOM   1250  O   LEU B  23      10.875  15.117  19.645  1.00 24.54           O  
ATOM   1251  CB  LEU B  23       8.505  16.479  18.601  1.00 24.81           C  
ATOM   1252  CG  LEU B  23       7.604  16.029  19.763  1.00 27.36           C  
ATOM   1253  CD1 LEU B  23       7.005  17.190  20.430  1.00 26.05           C  
ATOM   1254  CD2 LEU B  23       6.542  15.148  19.126  1.00 32.63           C  
ATOM   1255  N   ALA B  24      10.676  16.736  21.203  1.00 22.96           N  
ATOM   1256  CA  ALA B  24      11.259  15.975  22.259  1.00 23.23           C  
ATOM   1257  C   ALA B  24      10.267  15.693  23.369  1.00 23.75           C  
ATOM   1258  O   ALA B  24       9.552  16.583  23.804  1.00 23.89           O  
ATOM   1259  CB  ALA B  24      12.421  16.725  22.825  1.00 23.07           C  
ATOM   1260  N   CYS B  25      10.287  14.452  23.849  1.00 24.60           N  
ATOM   1261  CA  CYS B  25       9.515  14.007  24.979  1.00 23.41           C  
ATOM   1262  C   CYS B  25      10.488  13.282  25.915  1.00 23.30           C  
ATOM   1263  O   CYS B  25      11.699  13.158  25.613  1.00 22.67           O  
ATOM   1264  CB  CYS B  25       8.385  13.101  24.550  1.00 23.94           C  
ATOM   1265  SG  CYS B  25       8.825  11.606  23.603  1.00 27.21           S  
ATOM   1266  N   ALA B  26       9.984  12.839  27.055  1.00 21.97           N  
ATOM   1267  CA  ALA B  26      10.849  12.154  28.026  1.00 22.60           C  
ATOM   1268  C   ALA B  26      10.107  11.134  28.862  1.00 22.65           C  
ATOM   1269  O   ALA B  26       8.889  11.250  29.077  1.00 23.80           O  
ATOM   1270  CB  ALA B  26      11.521  13.195  28.956  1.00 22.42           C  
ATOM   1271  N   LYS B  27      10.858  10.149  29.343  1.00 23.45           N  
ATOM   1272  CA  LYS B  27      10.367   9.163  30.299  1.00 22.99           C  
ATOM   1273  C   LYS B  27      11.490   8.792  31.232  1.00 23.66           C  
ATOM   1274  O   LYS B  27      12.567   8.365  30.782  1.00 22.40           O  
ATOM   1275  CB  LYS B  27       9.921   7.895  29.604  1.00 23.32           C  
ATOM   1276  CG  LYS B  27       9.331   6.844  30.536  1.00 26.59           C  
ATOM   1277  CD  LYS B  27       9.185   5.524  29.791  1.00 33.83           C  
ATOM   1278  CE  LYS B  27       7.838   4.915  29.979  1.00 39.78           C  
ATOM   1279  NZ  LYS B  27       6.813   5.796  29.335  1.00 41.00           N  
ATOM   1280  N   ASP B  28      11.204   8.904  32.525  1.00 24.65           N  
ATOM   1281  CA  ASP B  28      12.162   8.592  33.600  1.00 26.63           C  
ATOM   1282  C   ASP B  28      13.524   9.269  33.350  1.00 26.68           C  
ATOM   1283  O   ASP B  28      14.575   8.649  33.501  1.00 28.90           O  
ATOM   1284  CB  ASP B  28      12.296   7.075  33.779  1.00 27.98           C  
ATOM   1285  CG  ASP B  28      10.947   6.418  34.132  1.00 31.49           C  
ATOM   1286  OD1 ASP B  28      10.115   7.113  34.760  1.00 36.26           O  
ATOM   1287  OD2 ASP B  28      10.701   5.243  33.761  1.00 35.87           O  
ATOM   1288  N   GLY B  29      13.499  10.533  32.938  1.00 25.71           N  
ATOM   1289  CA  GLY B  29      14.744  11.295  32.767  1.00 25.14           C  
ATOM   1290  C   GLY B  29      15.416  11.109  31.419  1.00 24.38           C  
ATOM   1291  O   GLY B  29      16.390  11.808  31.122  1.00 24.21           O  
ATOM   1292  N   GLN B  30      14.907  10.175  30.599  1.00 23.01           N  
ATOM   1293  CA  GLN B  30      15.485   9.890  29.288  1.00 22.43           C  
ATOM   1294  C   GLN B  30      14.704  10.661  28.265  1.00 22.50           C  
ATOM   1295  O   GLN B  30      13.488  10.443  28.146  1.00 21.99           O  
ATOM   1296  CB  GLN B  30      15.379   8.414  28.939  1.00 22.67           C  
ATOM   1297  CG  GLN B  30      15.867   8.045  27.562  1.00 21.13           C  
ATOM   1298  CD  GLN B  30      17.314   8.385  27.361  1.00 22.57           C  
ATOM   1299  OE1 GLN B  30      18.170   7.993  28.157  1.00 23.79           O  
ATOM   1300  NE2 GLN B  30      17.596   9.150  26.343  1.00 19.52           N  
ATOM   1301  N   PRO B  31      15.371  11.572  27.535  1.00 21.78           N  
ATOM   1302  CA  PRO B  31      14.720  12.193  26.387  1.00 20.94           C  
ATOM   1303  C   PRO B  31      14.644  11.325  25.128  1.00 21.60           C  
ATOM   1304  O   PRO B  31      15.400  10.341  24.952  1.00 20.20           O  
ATOM   1305  CB  PRO B  31      15.590  13.448  26.137  1.00 21.39           C  
ATOM   1306  CG  PRO B  31      16.502  13.558  27.356  1.00 22.02           C  
ATOM   1307  CD  PRO B  31      16.708  12.140  27.739  1.00 21.94           C  
ATOM   1308  N   TYR B  32      13.738  11.734  24.245  1.00 22.08           N  
ATOM   1309  CA  TYR B  32      13.567  11.119  22.963  1.00 23.10           C  
ATOM   1310  C   TYR B  32      13.134  12.184  21.979  1.00 22.42           C  
ATOM   1311  O   TYR B  32      12.228  12.931  22.267  1.00 23.31           O  
ATOM   1312  CB  TYR B  32      12.549  10.003  23.116  1.00 22.59           C  
ATOM   1313  CG  TYR B  32      12.147   9.319  21.865  1.00 22.96           C  
ATOM   1314  CD1 TYR B  32      13.091   8.782  20.998  1.00 23.68           C  
ATOM   1315  CD2 TYR B  32      10.829   9.211  21.518  1.00 22.31           C  
ATOM   1316  CE1 TYR B  32      12.679   8.142  19.819  1.00 24.18           C  
ATOM   1317  CE2 TYR B  32      10.418   8.558  20.333  1.00 22.64           C  
ATOM   1318  CZ  TYR B  32      11.322   8.031  19.516  1.00 24.27           C  
ATOM   1319  OH  TYR B  32      10.883   7.344  18.403  1.00 24.77           O  
ATOM   1320  N   VAL B  33      13.890  12.351  20.895  1.00 23.11           N  
ATOM   1321  CA  VAL B  33      13.622  13.414  19.947  1.00 23.23           C  
ATOM   1322  C   VAL B  33      13.514  12.889  18.524  1.00 22.86           C  
ATOM   1323  O   VAL B  33      14.343  12.124  18.094  1.00 22.66           O  
ATOM   1324  CB  VAL B  33      14.654  14.571  20.089  1.00 24.20           C  
ATOM   1325  CG1 VAL B  33      16.059  14.108  19.948  1.00 24.19           C  
ATOM   1326  CG2 VAL B  33      14.337  15.700  19.129  1.00 24.50           C  
ATOM   1327  N   VAL B  34      12.454  13.290  17.811  1.00 22.23           N  
ATOM   1328  CA  VAL B  34      12.245  12.880  16.423  1.00 23.14           C  
ATOM   1329  C   VAL B  34      11.720  14.047  15.586  1.00 22.81           C  
ATOM   1330  O   VAL B  34      11.145  14.969  16.128  1.00 22.17           O  
ATOM   1331  CB  VAL B  34      11.228  11.714  16.313  1.00 24.24           C  
ATOM   1332  CG1 VAL B  34      11.787  10.478  16.963  1.00 25.68           C  
ATOM   1333  CG2 VAL B  34       9.890  12.111  16.946  1.00 26.23           C  
ATOM   1334  N   PRO B  35      11.915  13.991  14.270  1.00 23.35           N  
ATOM   1335  CA  PRO B  35      11.350  15.029  13.437  1.00 25.11           C  
ATOM   1336  C   PRO B  35       9.829  14.857  13.254  1.00 25.86           C  
ATOM   1337  O   PRO B  35       9.317  13.725  13.192  1.00 27.41           O  
ATOM   1338  CB  PRO B  35      12.097  14.869  12.124  1.00 25.28           C  
ATOM   1339  CG  PRO B  35      12.591  13.450  12.088  1.00 25.07           C  
ATOM   1340  CD  PRO B  35      12.690  12.986  13.500  1.00 24.72           C  
ATOM   1341  N   LEU B  36       9.145  15.975  13.061  1.00 26.13           N  
ATOM   1342  CA  LEU B  36       7.702  15.979  12.938  1.00 26.68           C  
ATOM   1343  C   LEU B  36       7.234  17.116  12.057  1.00 25.57           C  
ATOM   1344  O   LEU B  36       7.746  18.225  12.168  1.00 24.47           O  
ATOM   1345  CB  LEU B  36       7.106  16.151  14.312  1.00 27.35           C  
ATOM   1346  CG  LEU B  36       5.596  15.974  14.458  1.00 31.66           C  
ATOM   1347  CD1 LEU B  36       5.271  14.535  14.874  1.00 33.59           C  
ATOM   1348  CD2 LEU B  36       5.107  16.970  15.479  1.00 34.07           C  
ATOM   1349  N   TYR B  37       6.262  16.840  11.190  1.00 24.92           N  
ATOM   1350  CA  TYR B  37       5.625  17.895  10.415  1.00 24.34           C  
ATOM   1351  C   TYR B  37       4.521  18.474  11.263  1.00 24.32           C  
ATOM   1352  O   TYR B  37       3.771  17.712  11.913  1.00 24.01           O  
ATOM   1353  CB  TYR B  37       5.035  17.332   9.147  1.00 26.36           C  
ATOM   1354  CG  TYR B  37       6.014  17.022   8.078  1.00 27.45           C  
ATOM   1355  CD1 TYR B  37       6.919  17.978   7.641  1.00 30.76           C  
ATOM   1356  CD2 TYR B  37       5.987  15.797   7.435  1.00 31.27           C  
ATOM   1357  CE1 TYR B  37       7.830  17.698   6.625  1.00 33.05           C  
ATOM   1358  CE2 TYR B  37       6.869  15.509   6.404  1.00 30.79           C  
ATOM   1359  CZ  TYR B  37       7.779  16.463   6.002  1.00 31.10           C  
ATOM   1360  OH  TYR B  37       8.666  16.177   5.007  1.00 33.11           O  
ATOM   1361  N   TYR B  38       4.381  19.799  11.281  1.00 22.39           N  
ATOM   1362  CA  TYR B  38       3.299  20.413  12.062  1.00 22.49           C  
ATOM   1363  C   TYR B  38       2.618  21.513  11.266  1.00 23.10           C  
ATOM   1364  O   TYR B  38       3.160  22.003  10.252  1.00 23.46           O  
ATOM   1365  CB  TYR B  38       3.845  20.973  13.405  1.00 22.84           C  
ATOM   1366  CG  TYR B  38       4.677  22.195  13.171  1.00 20.71           C  
ATOM   1367  CD1 TYR B  38       6.044  22.100  12.895  1.00 23.53           C  
ATOM   1368  CD2 TYR B  38       4.097  23.456  13.154  1.00 25.09           C  
ATOM   1369  CE1 TYR B  38       6.799  23.226  12.627  1.00 22.80           C  
ATOM   1370  CE2 TYR B  38       4.871  24.611  12.850  1.00 22.22           C  
ATOM   1371  CZ  TYR B  38       6.192  24.476  12.597  1.00 23.35           C  
ATOM   1372  OH  TYR B  38       6.886  25.616  12.314  1.00 23.75           O  
ATOM   1373  N   ALA B  39       1.450  21.919  11.730  1.00 23.15           N  
ATOM   1374  CA  ALA B  39       0.778  23.118  11.181  1.00 24.46           C  
ATOM   1375  C   ALA B  39       0.474  24.036  12.362  1.00 24.59           C  
ATOM   1376  O   ALA B  39      -0.094  23.584  13.322  1.00 24.59           O  
ATOM   1377  CB  ALA B  39      -0.541  22.726  10.463  1.00 24.03           C  
ATOM   1378  N   TYR B  40       0.905  25.293  12.301  1.00 25.00           N  
ATOM   1379  CA  TYR B  40       0.640  26.264  13.358  1.00 25.65           C  
ATOM   1380  C   TYR B  40      -0.782  26.865  13.268  1.00 26.10           C  
ATOM   1381  O   TYR B  40      -1.216  27.309  12.200  1.00 24.55           O  
ATOM   1382  CB  TYR B  40       1.666  27.416  13.285  1.00 26.69           C  
ATOM   1383  CG  TYR B  40       1.355  28.503  14.257  1.00 27.10           C  
ATOM   1384  CD1 TYR B  40       1.816  28.427  15.567  1.00 31.74           C  
ATOM   1385  CD2 TYR B  40       0.557  29.569  13.902  1.00 28.64           C  
ATOM   1386  CE1 TYR B  40       1.469  29.381  16.492  1.00 31.25           C  
ATOM   1387  CE2 TYR B  40       0.198  30.540  14.816  1.00 28.69           C  
ATOM   1388  CZ  TYR B  40       0.657  30.439  16.104  1.00 30.32           C  
ATOM   1389  OH  TYR B  40       0.309  31.394  17.014  1.00 31.27           O  
ATOM   1390  N   SER B  41      -1.472  26.938  14.406  1.00 25.52           N  
ATOM   1391  CA  SER B  41      -2.676  27.777  14.528  1.00 27.13           C  
ATOM   1392  C   SER B  41      -2.990  28.035  15.984  1.00 27.03           C  
ATOM   1393  O   SER B  41      -2.903  27.126  16.798  1.00 26.15           O  
ATOM   1394  CB  SER B  41      -3.908  27.129  13.892  1.00 26.84           C  
ATOM   1395  OG  SER B  41      -4.991  28.040  13.908  1.00 28.52           O  
ATOM   1396  N   ASP B  42      -3.349  29.264  16.294  1.00 27.80           N  
ATOM   1397  CA  ASP B  42      -3.966  29.604  17.582  1.00 30.11           C  
ATOM   1398  C   ASP B  42      -3.057  29.178  18.770  1.00 30.16           C  
ATOM   1399  O   ASP B  42      -3.553  28.633  19.729  1.00 31.29           O  
ATOM   1400  CB  ASP B  42      -5.459  29.066  17.717  1.00 30.85           C  
ATOM   1401  CG  ASP B  42      -5.654  27.468  17.482  1.00 36.94           C  
ATOM   1402  OD1 ASP B  42      -5.374  26.626  18.390  1.00 43.15           O  
ATOM   1403  OD2 ASP B  42      -6.186  27.047  16.399  1.00 41.40           O  
ATOM   1404  N   ALA B  43      -1.741  29.409  18.659  1.00 29.51           N  
ATOM   1405  CA  ALA B  43      -0.737  29.065  19.706  1.00 29.20           C  
ATOM   1406  C   ALA B  43      -0.668  27.576  20.007  1.00 28.73           C  
ATOM   1407  O   ALA B  43      -0.343  27.153  21.128  1.00 29.33           O  
ATOM   1408  CB  ALA B  43      -0.980  29.838  20.973  1.00 30.46           C  
ATOM   1409  N   HIS B  44      -0.961  26.796  18.974  1.00 26.16           N  
ATOM   1410  CA  HIS B  44      -0.778  25.383  18.989  1.00 25.98           C  
ATOM   1411  C   HIS B  44      -0.048  24.952  17.738  1.00 23.85           C  
ATOM   1412  O   HIS B  44      -0.224  25.535  16.651  1.00 22.28           O  
ATOM   1413  CB  HIS B  44      -2.113  24.675  19.005  1.00 26.69           C  
ATOM   1414  CG  HIS B  44      -2.955  24.966  20.206  1.00 29.32           C  
ATOM   1415  ND1 HIS B  44      -3.942  25.921  20.197  1.00 33.69           N  
ATOM   1416  CD2 HIS B  44      -3.017  24.365  21.422  1.00 33.61           C  
ATOM   1417  CE1 HIS B  44      -4.550  25.935  21.373  1.00 35.54           C  
ATOM   1418  NE2 HIS B  44      -4.021  24.985  22.126  1.00 35.82           N  
ATOM   1419  N   LEU B  45       0.689  23.874  17.883  1.00 22.36           N  
ATOM   1420  CA  LEU B  45       1.232  23.126  16.760  1.00 22.99           C  
ATOM   1421  C   LEU B  45       0.477  21.816  16.568  1.00 23.69           C  
ATOM   1422  O   LEU B  45       0.502  20.960  17.437  1.00 24.47           O  
ATOM   1423  CB  LEU B  45       2.698  22.815  17.020  1.00 21.08           C  
ATOM   1424  CG  LEU B  45       3.538  23.977  17.494  1.00 24.26           C  
ATOM   1425  CD1 LEU B  45       4.970  23.558  17.723  1.00 24.82           C  
ATOM   1426  CD2 LEU B  45       3.527  25.137  16.532  1.00 21.67           C  
ATOM   1427  N   TYR B  46      -0.184  21.654  15.426  1.00 24.62           N  
ATOM   1428  CA  TYR B  46      -0.999  20.468  15.136  1.00 23.88           C  
ATOM   1429  C   TYR B  46      -0.220  19.479  14.305  1.00 23.68           C  
ATOM   1430  O   TYR B  46       0.593  19.846  13.431  1.00 24.96           O  
ATOM   1431  CB  TYR B  46      -2.309  20.866  14.382  1.00 24.25           C  
ATOM   1432  CG  TYR B  46      -3.300  21.662  15.202  1.00 24.65           C  
ATOM   1433  CD1 TYR B  46      -3.173  23.039  15.373  1.00 24.71           C  
ATOM   1434  CD2 TYR B  46      -4.372  21.033  15.826  1.00 25.90           C  
ATOM   1435  CE1 TYR B  46      -4.077  23.734  16.138  1.00 26.96           C  
ATOM   1436  CE2 TYR B  46      -5.272  21.747  16.592  1.00 25.52           C  
ATOM   1437  CZ  TYR B  46      -5.137  23.055  16.735  1.00 24.80           C  
ATOM   1438  OH  TYR B  46      -6.085  23.705  17.533  1.00 27.16           O  
ATOM   1439  N   ALA B  47      -0.454  18.202  14.570  1.00 23.60           N  
ATOM   1440  CA  ALA B  47       0.260  17.158  13.898  1.00 23.10           C  
ATOM   1441  C   ALA B  47      -0.507  15.840  13.984  1.00 23.63           C  
ATOM   1442  O   ALA B  47      -1.476  15.701  14.756  1.00 23.80           O  
ATOM   1443  CB  ALA B  47       1.733  17.037  14.448  1.00 22.40           C  
ATOM   1444  N   PHE B  48      -0.101  14.908  13.133  1.00 23.57           N  
ATOM   1445  CA  PHE B  48      -0.640  13.551  13.086  1.00 24.18           C  
ATOM   1446  C   PHE B  48       0.499  12.604  13.344  1.00 25.56           C  
ATOM   1447  O   PHE B  48       1.645  12.913  12.998  1.00 24.37           O  
ATOM   1448  CB  PHE B  48      -1.283  13.243  11.718  1.00 23.98           C  
ATOM   1449  CG  PHE B  48      -2.596  13.916  11.518  1.00 24.43           C  
ATOM   1450  CD1 PHE B  48      -2.657  15.199  10.999  1.00 25.13           C  
ATOM   1451  CD2 PHE B  48      -3.778  13.287  11.885  1.00 27.13           C  
ATOM   1452  CE1 PHE B  48      -3.867  15.856  10.889  1.00 26.41           C  
ATOM   1453  CE2 PHE B  48      -4.970  13.946  11.765  1.00 27.50           C  
ATOM   1454  CZ  PHE B  48      -5.013  15.221  11.247  1.00 23.62           C  
ATOM   1455  N   SER B  49       0.192  11.465  13.957  1.00 25.73           N  
ATOM   1456  CA  SER B  49       1.164  10.394  14.141  1.00 27.00           C  
ATOM   1457  C   SER B  49       0.472   9.029  14.008  1.00 27.37           C  
ATOM   1458  O   SER B  49      -0.725   8.901  14.250  1.00 28.52           O  
ATOM   1459  CB  SER B  49       1.831  10.514  15.531  1.00 26.98           C  
ATOM   1460  OG  SER B  49       2.764   9.462  15.752  1.00 28.66           O  
HETATM 1461  N   MSE B  50       1.222   8.011  13.632  1.00 27.66           N  
HETATM 1462  CA  MSE B  50       0.758   6.641  13.851  1.00 28.40           C  
HETATM 1463  C   MSE B  50       1.074   6.279  15.308  1.00 27.82           C  
HETATM 1464  O   MSE B  50       1.895   6.950  15.964  1.00 27.40           O  
HETATM 1465  CB  MSE B  50       1.420   5.686  12.856  1.00 29.11           C  
HETATM 1466  CG  MSE B  50       1.016   5.936  11.382  1.00 33.06           C  
HETATM 1467 SE   MSE B  50      -0.908   5.725  11.133  0.75 41.83          SE  
HETATM 1468  CE  MSE B  50      -0.991   3.845  11.302  1.00 40.95           C  
ATOM   1469  N   PRO B  51       0.412   5.249  15.847  1.00 28.22           N  
ATOM   1470  CA  PRO B  51       0.772   4.780  17.183  1.00 28.18           C  
ATOM   1471  C   PRO B  51       2.239   4.473  17.294  1.00 27.90           C  
ATOM   1472  O   PRO B  51       2.853   4.044  16.313  1.00 28.26           O  
ATOM   1473  CB  PRO B  51       0.003   3.473  17.314  1.00 28.66           C  
ATOM   1474  CG  PRO B  51      -1.148   3.635  16.396  1.00 30.26           C  
ATOM   1475  CD  PRO B  51      -0.669   4.449  15.251  1.00 28.43           C  
ATOM   1476  N   GLY B  52       2.805   4.625  18.487  1.00 27.52           N  
ATOM   1477  CA  GLY B  52       4.238   4.353  18.675  1.00 25.83           C  
ATOM   1478  C   GLY B  52       4.845   4.995  19.896  1.00 25.63           C  
ATOM   1479  O   GLY B  52       4.141   5.591  20.699  1.00 25.15           O  
ATOM   1480  N   LYS B  53       6.165   4.887  20.017  1.00 24.44           N  
ATOM   1481  CA  LYS B  53       6.904   5.379  21.191  1.00 24.50           C  
ATOM   1482  C   LYS B  53       6.595   6.797  21.578  1.00 23.85           C  
ATOM   1483  O   LYS B  53       6.216   7.051  22.721  1.00 23.54           O  
ATOM   1484  CB  LYS B  53       8.427   5.215  20.957  1.00 24.44           C  
ATOM   1485  CG  LYS B  53       9.292   5.342  22.175  1.00 24.89           C  
ATOM   1486  CD  LYS B  53      10.776   5.114  21.887  1.00 24.32           C  
ATOM   1487  CE  LYS B  53      11.654   5.669  22.978  1.00 27.61           C  
ATOM   1488  NZ  LYS B  53      13.059   5.195  22.829  1.00 26.61           N  
ATOM   1489  N   LYS B  54       6.741   7.742  20.670  1.00 22.01           N  
ATOM   1490  CA  LYS B  54       6.520   9.136  21.075  1.00 22.11           C  
ATOM   1491  C   LYS B  54       5.095   9.386  21.587  1.00 22.20           C  
ATOM   1492  O   LYS B  54       4.919  10.107  22.547  1.00 20.99           O  
ATOM   1493  CB  LYS B  54       6.836  10.122  19.990  1.00 22.40           C  
ATOM   1494  CG  LYS B  54       6.020  10.014  18.764  1.00 24.70           C  
ATOM   1495  CD  LYS B  54       6.505  10.984  17.693  1.00 27.53           C  
ATOM   1496  CE  LYS B  54       5.594  11.020  16.524  1.00 27.99           C  
ATOM   1497  NZ  LYS B  54       5.264   9.614  15.986  1.00 29.75           N  
ATOM   1498  N   ILE B  55       4.107   8.793  20.961  1.00 22.20           N  
ATOM   1499  CA  ILE B  55       2.740   8.906  21.461  1.00 23.45           C  
ATOM   1500  C   ILE B  55       2.620   8.254  22.840  1.00 23.86           C  
ATOM   1501  O   ILE B  55       2.004   8.825  23.751  1.00 25.45           O  
ATOM   1502  CB  ILE B  55       1.743   8.312  20.463  1.00 23.59           C  
ATOM   1503  CG1 ILE B  55       1.761   9.121  19.158  1.00 23.69           C  
ATOM   1504  CG2 ILE B  55       0.339   8.304  21.022  1.00 22.77           C  
ATOM   1505  CD1 ILE B  55       1.444  10.629  19.344  1.00 24.56           C  
ATOM   1506  N   GLU B  56       3.157   7.053  23.014  1.00 23.95           N  
ATOM   1507  CA  GLU B  56       3.085   6.432  24.336  1.00 24.79           C  
ATOM   1508  C   GLU B  56       3.743   7.296  25.439  1.00 24.28           C  
ATOM   1509  O   GLU B  56       3.189   7.476  26.538  1.00 24.60           O  
ATOM   1510  CB  GLU B  56       3.698   5.044  24.326  1.00 25.30           C  
ATOM   1511  CG  GLU B  56       2.923   4.022  23.541  1.00 26.13           C  
ATOM   1512  CD  GLU B  56       1.463   3.944  23.986  1.00 28.97           C  
ATOM   1513  OE1 GLU B  56       1.208   3.269  24.999  1.00 28.71           O  
ATOM   1514  OE2 GLU B  56       0.599   4.566  23.320  1.00 30.98           O  
ATOM   1515  N   TRP B  57       4.918   7.829  25.149  1.00 24.42           N  
ATOM   1516  CA  TRP B  57       5.650   8.652  26.110  1.00 24.41           C  
ATOM   1517  C   TRP B  57       4.954   9.975  26.418  1.00 25.21           C  
ATOM   1518  O   TRP B  57       4.975  10.439  27.576  1.00 26.32           O  
ATOM   1519  CB  TRP B  57       7.075   8.877  25.608  1.00 24.18           C  
ATOM   1520  CG  TRP B  57       7.984   7.708  25.809  1.00 24.75           C  
ATOM   1521  CD1 TRP B  57       7.649   6.386  25.897  1.00 22.93           C  
ATOM   1522  CD2 TRP B  57       9.395   7.781  25.967  1.00 22.33           C  
ATOM   1523  NE1 TRP B  57       8.778   5.632  26.106  1.00 24.57           N  
ATOM   1524  CE2 TRP B  57       9.861   6.477  26.166  1.00 24.68           C  
ATOM   1525  CE3 TRP B  57      10.306   8.850  26.011  1.00 22.03           C  
ATOM   1526  CZ2 TRP B  57      11.199   6.201  26.361  1.00 24.04           C  
ATOM   1527  CZ3 TRP B  57      11.611   8.581  26.191  1.00 23.40           C  
ATOM   1528  CH2 TRP B  57      12.065   7.276  26.349  1.00 23.16           C  
HETATM 1529  N   MSE B  58       4.323  10.586  25.422  1.00 24.31           N  
HETATM 1530  CA  MSE B  58       3.609  11.852  25.664  1.00 23.63           C  
HETATM 1531  C   MSE B  58       2.262  11.670  26.365  1.00 23.64           C  
HETATM 1532  O   MSE B  58       1.828  12.535  27.113  1.00 21.50           O  
HETATM 1533  CB  MSE B  58       3.429  12.613  24.336  1.00 24.12           C  
HETATM 1534  CG  MSE B  58       4.746  13.051  23.778  1.00 23.83           C  
HETATM 1535 SE   MSE B  58       4.621  14.224  22.236  0.75 21.77          SE  
HETATM 1536  CE  MSE B  58       3.828  12.921  20.999  1.00 28.17           C  
ATOM   1537  N   ARG B  59       1.629  10.513  26.148  1.00 23.42           N  
ATOM   1538  CA  ARG B  59       0.433  10.136  26.859  1.00 23.54           C  
ATOM   1539  C   ARG B  59       0.766  10.031  28.325  1.00 23.69           C  
ATOM   1540  O   ARG B  59      -0.018  10.473  29.161  1.00 25.18           O  
ATOM   1541  CB  ARG B  59      -0.162   8.808  26.332  1.00 23.01           C  
ATOM   1542  CG  ARG B  59      -1.054   8.947  25.058  1.00 22.17           C  
ATOM   1543  CD  ARG B  59      -1.340   7.587  24.466  1.00 23.09           C  
ATOM   1544  NE  ARG B  59      -2.188   7.774  23.307  1.00 23.33           N  
ATOM   1545  CZ  ARG B  59      -2.450   6.865  22.389  1.00 23.10           C  
ATOM   1546  NH1 ARG B  59      -1.940   5.641  22.479  1.00 21.39           N  
ATOM   1547  NH2 ARG B  59      -3.258   7.207  21.360  1.00 22.06           N  
ATOM   1548  N   ALA B  60       1.898   9.440  28.659  1.00 23.31           N  
ATOM   1549  CA  ALA B  60       2.295   9.336  30.075  1.00 23.81           C  
ATOM   1550  C   ALA B  60       2.901  10.632  30.713  1.00 23.89           C  
ATOM   1551  O   ALA B  60       2.729  10.884  31.922  1.00 22.59           O  
ATOM   1552  CB  ALA B  60       3.236   8.154  30.268  1.00 24.68           C  
ATOM   1553  N   ASN B  61       3.623  11.412  29.927  1.00 23.96           N  
ATOM   1554  CA  ASN B  61       4.253  12.662  30.347  1.00 24.75           C  
ATOM   1555  C   ASN B  61       4.015  13.703  29.260  1.00 23.76           C  
ATOM   1556  O   ASN B  61       4.712  13.712  28.276  1.00 23.92           O  
ATOM   1557  CB  ASN B  61       5.787  12.512  30.527  1.00 25.13           C  
ATOM   1558  CG  ASN B  61       6.481  13.859  30.847  1.00 27.45           C  
ATOM   1559  OD1 ASN B  61       5.793  14.849  31.208  1.00 24.65           O  
ATOM   1560  ND2 ASN B  61       7.850  13.894  30.750  1.00 23.16           N  
ATOM   1561  N   PRO B  62       3.034  14.585  29.433  1.00 23.12           N  
ATOM   1562  CA  PRO B  62       2.783  15.494  28.340  1.00 24.13           C  
ATOM   1563  C   PRO B  62       3.728  16.697  28.224  1.00 22.77           C  
ATOM   1564  O   PRO B  62       3.508  17.500  27.358  1.00 21.89           O  
ATOM   1565  CB  PRO B  62       1.326  15.915  28.559  1.00 23.36           C  
ATOM   1566  CG  PRO B  62       1.171  15.853  29.994  1.00 25.85           C  
ATOM   1567  CD  PRO B  62       2.103  14.804  30.546  1.00 25.44           C  
ATOM   1568  N   ARG B  63       4.807  16.801  29.024  1.00 21.90           N  
ATOM   1569  CA  ARG B  63       5.787  17.875  28.833  0.50 21.69           C  
ATOM   1571  C   ARG B  63       6.651  17.607  27.600  1.00 21.53           C  
ATOM   1572  O   ARG B  63       7.247  16.537  27.477  1.00 22.53           O  
ATOM   1573  CB  ARG B  63       6.687  18.023  30.079  0.50 22.00           C  
ATOM   1575  CG  ARG B  63       5.955  18.193  31.390  0.50 21.76           C  
ATOM   1577  CD  ARG B  63       6.939  18.094  32.549  0.50 22.19           C  
ATOM   1579  NE  ARG B  63       6.366  18.282  33.877  0.50 22.59           N  
ATOM   1581  CZ  ARG B  63       5.578  17.405  34.506  0.50 23.49           C  
ATOM   1583  NH1 ARG B  63       5.192  16.281  33.900  0.50 24.91           N  
ATOM   1585  NH2 ARG B  63       5.135  17.682  35.721  0.50 22.97           N  
ATOM   1587  N   VAL B  64       6.730  18.586  26.686  1.00 20.55           N  
ATOM   1588  CA  VAL B  64       7.548  18.454  25.528  1.00 23.05           C  
ATOM   1589  C   VAL B  64       8.332  19.735  25.245  1.00 21.68           C  
ATOM   1590  O   VAL B  64       8.053  20.791  25.781  1.00 22.37           O  
ATOM   1591  CB  VAL B  64       6.705  18.110  24.238  1.00 23.09           C  
ATOM   1592  CG1 VAL B  64       5.897  16.836  24.479  1.00 24.13           C  
ATOM   1593  CG2 VAL B  64       5.813  19.266  23.824  1.00 25.15           C  
ATOM   1594  N   SER B  65       9.268  19.609  24.330  1.00 23.10           N  
ATOM   1595  CA  SER B  65       9.946  20.763  23.741  1.00 23.90           C  
ATOM   1596  C   SER B  65       9.963  20.546  22.234  1.00 24.28           C  
ATOM   1597  O   SER B  65      10.084  19.388  21.755  1.00 24.90           O  
ATOM   1598  CB  SER B  65      11.354  20.899  24.324  1.00 24.06           C  
ATOM   1599  OG  SER B  65      12.098  21.933  23.706  1.00 25.21           O  
ATOM   1600  N   VAL B  66       9.803  21.639  21.476  1.00 23.68           N  
ATOM   1601  CA  VAL B  66       9.867  21.600  20.006  1.00 23.15           C  
ATOM   1602  C   VAL B  66      10.813  22.669  19.499  1.00 22.69           C  
ATOM   1603  O   VAL B  66      10.751  23.797  19.936  1.00 21.72           O  
ATOM   1604  CB  VAL B  66       8.461  21.838  19.368  1.00 23.26           C  
ATOM   1605  CG1 VAL B  66       8.514  21.688  17.873  1.00 25.14           C  
ATOM   1606  CG2 VAL B  66       7.452  20.859  19.884  1.00 24.57           C  
ATOM   1607  N   GLN B  67      11.682  22.303  18.574  1.00 22.12           N  
ATOM   1608  CA  GLN B  67      12.624  23.211  17.984  1.00 22.60           C  
ATOM   1609  C   GLN B  67      12.408  23.345  16.476  1.00 21.78           C  
ATOM   1610  O   GLN B  67      12.256  22.341  15.757  1.00 20.00           O  
ATOM   1611  CB  GLN B  67      14.059  22.745  18.280  1.00 23.38           C  
ATOM   1612  CG  GLN B  67      15.091  23.775  17.881  1.00 23.82           C  
ATOM   1613  CD  GLN B  67      15.595  23.563  16.439  1.00 23.88           C  
ATOM   1614  OE1 GLN B  67      15.565  22.434  15.904  1.00 21.87           O  
ATOM   1615  NE2 GLN B  67      16.070  24.643  15.816  1.00 21.61           N  
ATOM   1616  N   VAL B  68      12.390  24.593  15.998  1.00 22.49           N  
ATOM   1617  CA  VAL B  68      12.067  24.896  14.619  1.00 21.21           C  
ATOM   1618  C   VAL B  68      13.078  25.908  14.172  1.00 21.73           C  
ATOM   1619  O   VAL B  68      13.388  26.824  14.905  1.00 21.53           O  
ATOM   1620  CB  VAL B  68      10.640  25.482  14.506  1.00 21.16           C  
ATOM   1621  CG1 VAL B  68      10.300  25.919  13.079  1.00 21.77           C  
ATOM   1622  CG2 VAL B  68       9.604  24.465  15.032  1.00 20.42           C  
ATOM   1623  N   ASP B  69      13.617  25.757  12.972  1.00 22.49           N  
ATOM   1624  CA  ASP B  69      14.509  26.781  12.464  1.00 24.55           C  
ATOM   1625  C   ASP B  69      14.436  26.983  10.974  1.00 25.87           C  
ATOM   1626  O   ASP B  69      13.848  26.191  10.262  1.00 25.04           O  
ATOM   1627  CB  ASP B  69      15.964  26.533  12.902  1.00 24.99           C  
ATOM   1628  CG  ASP B  69      16.480  25.181  12.470  1.00 29.53           C  
ATOM   1629  OD1 ASP B  69      16.425  24.887  11.257  1.00 32.48           O  
ATOM   1630  OD2 ASP B  69      16.929  24.411  13.358  1.00 35.29           O  
ATOM   1631  N   GLU B  70      15.068  28.053  10.501  1.00 27.22           N  
ATOM   1632  CA  GLU B  70      15.084  28.342   9.102  1.00 30.39           C  
ATOM   1633  C   GLU B  70      16.391  29.036   8.777  1.00 32.51           C  
ATOM   1634  O   GLU B  70      17.033  29.615   9.640  1.00 30.69           O  
ATOM   1635  CB  GLU B  70      13.879  29.224   8.719  1.00 30.08           C  
ATOM   1636  CG  GLU B  70      13.880  30.582   9.440  1.00 30.63           C  
ATOM   1637  CD  GLU B  70      12.702  31.489   9.080  1.00 31.59           C  
ATOM   1638  OE1 GLU B  70      11.552  31.005   8.851  1.00 30.40           O  
ATOM   1639  OE2 GLU B  70      12.929  32.726   9.073  1.00 32.76           O  
ATOM   1640  N   HIS B  71      16.790  28.939   7.516  1.00 36.88           N  
ATOM   1641  CA  HIS B  71      17.885  29.763   7.005  1.00 39.91           C  
ATOM   1642  C   HIS B  71      17.478  31.215   6.817  1.00 41.30           C  
ATOM   1643  O   HIS B  71      16.311  31.546   6.570  1.00 40.92           O  
ATOM   1644  CB  HIS B  71      18.385  29.244   5.658  1.00 41.44           C  
ATOM   1645  CG  HIS B  71      19.132  27.957   5.769  1.00 45.16           C  
ATOM   1646  ND1 HIS B  71      18.719  26.798   5.145  1.00 49.35           N  
ATOM   1647  CD2 HIS B  71      20.245  27.634   6.470  1.00 49.49           C  
ATOM   1648  CE1 HIS B  71      19.554  25.818   5.445  1.00 50.23           C  
ATOM   1649  NE2 HIS B  71      20.491  26.299   6.246  1.00 50.73           N  
ATOM   1650  N   GLY B  72      18.476  32.079   6.933  1.00 42.98           N  
ATOM   1651  CA  GLY B  72      18.366  33.414   6.427  1.00 44.16           C  
ATOM   1652  C   GLY B  72      19.423  33.556   5.355  1.00 45.33           C  
ATOM   1653  O   GLY B  72      19.622  32.665   4.509  1.00 46.16           O  
ATOM   1654  N   GLN B  73      20.152  34.660   5.467  1.00 46.14           N  
ATOM   1655  CA  GLN B  73      21.041  35.179   4.445  1.00 46.21           C  
ATOM   1656  C   GLN B  73      22.424  34.653   4.765  1.00 45.42           C  
ATOM   1657  O   GLN B  73      22.787  34.553   5.937  1.00 45.57           O  
ATOM   1658  CB  GLN B  73      21.037  36.721   4.495  1.00 46.88           C  
ATOM   1659  CG  GLN B  73      21.219  37.321   5.938  1.00 49.54           C  
ATOM   1660  CD  GLN B  73      20.012  37.077   6.859  1.00 51.62           C  
ATOM   1661  OE1 GLN B  73      18.878  37.395   6.498  1.00 54.74           O  
ATOM   1662  NE2 GLN B  73      20.255  36.481   8.036  1.00 53.62           N  
ATOM   1663  N   GLY B  74      23.196  34.325   3.734  1.00 44.46           N  
ATOM   1664  CA  GLY B  74      24.504  33.711   3.924  1.00 43.59           C  
ATOM   1665  C   GLY B  74      24.419  32.537   4.889  1.00 42.90           C  
ATOM   1666  O   GLY B  74      23.625  31.621   4.686  1.00 42.68           O  
ATOM   1667  N   ARG B  75      25.230  32.576   5.945  1.00 41.82           N  
ATOM   1668  CA  ARG B  75      25.217  31.547   6.982  1.00 40.99           C  
ATOM   1669  C   ARG B  75      24.201  31.862   8.100  1.00 39.44           C  
ATOM   1670  O   ARG B  75      24.180  31.176   9.132  1.00 40.05           O  
ATOM   1671  CB  ARG B  75      26.642  31.385   7.569  1.00 41.59           C  
ATOM   1672  N   GLY B  76      23.373  32.892   7.896  1.00 37.39           N  
ATOM   1673  CA  GLY B  76      22.333  33.285   8.856  1.00 36.22           C  
ATOM   1674  C   GLY B  76      21.294  32.204   9.149  1.00 34.57           C  
ATOM   1675  O   GLY B  76      21.126  31.253   8.368  1.00 34.33           O  
ATOM   1676  N   TRP B  77      20.607  32.352  10.287  1.00 32.70           N  
ATOM   1677  CA  TRP B  77      19.514  31.471  10.670  1.00 30.66           C  
ATOM   1678  C   TRP B  77      18.667  32.067  11.807  1.00 28.89           C  
ATOM   1679  O   TRP B  77      19.078  33.026  12.485  1.00 27.59           O  
ATOM   1680  CB  TRP B  77      20.025  30.099  11.097  1.00 31.50           C  
ATOM   1681  CG  TRP B  77      21.068  30.122  12.146  1.00 31.56           C  
ATOM   1682  CD1 TRP B  77      22.420  30.031  11.940  1.00 33.25           C  
ATOM   1683  CD2 TRP B  77      20.887  30.210  13.580  1.00 32.62           C  
ATOM   1684  NE1 TRP B  77      23.093  30.082  13.153  1.00 33.54           N  
ATOM   1685  CE2 TRP B  77      22.175  30.188  14.171  1.00 33.31           C  
ATOM   1686  CE3 TRP B  77      19.765  30.335  14.425  1.00 31.41           C  
ATOM   1687  CZ2 TRP B  77      22.367  30.282  15.560  1.00 32.59           C  
ATOM   1688  CZ3 TRP B  77      19.963  30.418  15.797  1.00 31.69           C  
ATOM   1689  CH2 TRP B  77      21.255  30.402  16.353  1.00 31.54           C  
ATOM   1690  N   LYS B  78      17.476  31.511  11.960  1.00 25.99           N  
ATOM   1691  CA  LYS B  78      16.562  31.865  13.024  1.00 25.33           C  
ATOM   1692  C   LYS B  78      16.087  30.549  13.592  1.00 24.47           C  
ATOM   1693  O   LYS B  78      15.807  29.600  12.828  1.00 22.86           O  
ATOM   1694  CB  LYS B  78      15.358  32.635  12.521  1.00 25.48           C  
ATOM   1695  CG  LYS B  78      15.655  34.024  12.068  1.00 27.96           C  
ATOM   1696  CD  LYS B  78      14.360  34.805  11.851  1.00 30.07           C  
ATOM   1697  CE  LYS B  78      14.536  35.910  10.882  1.00 31.90           C  
ATOM   1698  NZ  LYS B  78      15.246  37.039  11.509  1.00 34.49           N  
ATOM   1699  N   SER B  79      16.041  30.456  14.917  1.00 24.47           N  
ATOM   1700  CA  SER B  79      15.598  29.218  15.581  1.00 24.02           C  
ATOM   1701  C   SER B  79      14.646  29.596  16.701  1.00 25.25           C  
ATOM   1702  O   SER B  79      14.905  30.601  17.397  1.00 25.50           O  
ATOM   1703  CB  SER B  79      16.815  28.521  16.197  1.00 24.34           C  
ATOM   1704  OG  SER B  79      16.442  27.397  17.000  1.00 23.11           O  
ATOM   1705  N   VAL B  80      13.626  28.755  16.912  1.00 24.77           N  
ATOM   1706  CA  VAL B  80      12.654  28.905  17.993  1.00 24.22           C  
ATOM   1707  C   VAL B  80      12.639  27.628  18.831  1.00 23.92           C  
ATOM   1708  O   VAL B  80      12.709  26.505  18.280  1.00 23.19           O  
ATOM   1709  CB  VAL B  80      11.243  29.236  17.389  1.00 24.92           C  
ATOM   1710  CG1 VAL B  80      10.128  29.103  18.415  1.00 25.80           C  
ATOM   1711  CG2 VAL B  80      11.271  30.654  16.870  1.00 24.62           C  
ATOM   1712  N   VAL B  81      12.562  27.790  20.150  1.00 22.37           N  
ATOM   1713  CA  VAL B  81      12.308  26.666  21.032  1.00 23.14           C  
ATOM   1714  C   VAL B  81      11.005  26.887  21.762  1.00 23.14           C  
ATOM   1715  O   VAL B  81      10.781  27.955  22.360  1.00 23.11           O  
ATOM   1716  CB  VAL B  81      13.484  26.341  21.979  1.00 23.59           C  
ATOM   1717  CG1 VAL B  81      13.111  25.199  22.919  1.00 23.62           C  
ATOM   1718  CG2 VAL B  81      14.709  25.974  21.159  1.00 27.07           C  
ATOM   1719  N   VAL B  82      10.135  25.882  21.664  1.00 25.61           N  
ATOM   1720  CA  VAL B  82       8.810  25.915  22.313  1.00 26.69           C  
ATOM   1721  C   VAL B  82       8.813  24.940  23.468  1.00 27.09           C  
ATOM   1722  O   VAL B  82       9.195  23.783  23.307  1.00 26.42           O  
ATOM   1723  CB  VAL B  82       7.710  25.483  21.357  1.00 27.63           C  
ATOM   1724  CG1 VAL B  82       6.454  24.953  22.134  1.00 29.91           C  
ATOM   1725  CG2 VAL B  82       7.346  26.632  20.427  1.00 27.65           C  
ATOM   1726  N   ASP B  83       8.339  25.392  24.621  1.00 26.77           N  
ATOM   1727  CA  ASP B  83       8.098  24.482  25.694  1.00 27.20           C  
ATOM   1728  C   ASP B  83       6.625  24.328  25.825  1.00 26.17           C  
ATOM   1729  O   ASP B  83       5.849  25.287  25.925  1.00 25.30           O  
ATOM   1730  CB  ASP B  83       8.850  24.897  26.931  1.00 28.63           C  
ATOM   1731  CG  ASP B  83      10.398  24.915  26.670  1.00 34.25           C  
ATOM   1732  OD1 ASP B  83      10.988  23.966  26.005  1.00 40.10           O  
ATOM   1733  OD2 ASP B  83      11.021  25.900  27.100  1.00 40.71           O  
ATOM   1734  N   GLY B  84       6.225  23.086  25.725  1.00 26.44           N  
ATOM   1735  CA  GLY B  84       4.856  22.775  25.410  1.00 26.02           C  
ATOM   1736  C   GLY B  84       4.228  21.668  26.226  1.00 25.33           C  
ATOM   1737  O   GLY B  84       4.891  20.970  27.035  1.00 22.06           O  
ATOM   1738  N   ARG B  85       2.947  21.508  25.943  1.00 24.23           N  
ATOM   1739  CA  ARG B  85       2.168  20.436  26.489  1.00 25.97           C  
ATOM   1740  C   ARG B  85       1.473  19.662  25.360  1.00 25.59           C  
ATOM   1741  O   ARG B  85       0.787  20.252  24.505  1.00 25.01           O  
ATOM   1742  CB  ARG B  85       1.158  21.033  27.471  1.00 26.89           C  
ATOM   1743  CG  ARG B  85      -0.001  20.139  27.694  1.00 28.81           C  
ATOM   1744  CD  ARG B  85      -1.150  20.713  28.581  1.00 29.81           C  
ATOM   1745  NE  ARG B  85      -0.923  22.007  29.240  1.00 32.24           N  
ATOM   1746  CZ  ARG B  85      -1.761  22.469  30.173  1.00 31.41           C  
ATOM   1747  NH1 ARG B  85      -2.803  21.726  30.518  1.00 34.01           N  
ATOM   1748  NH2 ARG B  85      -1.567  23.629  30.771  1.00 30.74           N  
ATOM   1749  N   TYR B  86       1.704  18.354  25.308  1.00 25.47           N  
ATOM   1750  CA  TYR B  86       0.936  17.455  24.408  1.00 24.65           C  
ATOM   1751  C   TYR B  86      -0.558  17.391  24.766  1.00 26.02           C  
ATOM   1752  O   TYR B  86      -0.884  17.149  25.933  1.00 25.23           O  
ATOM   1753  CB  TYR B  86       1.495  16.069  24.562  1.00 24.87           C  
ATOM   1754  CG  TYR B  86       0.750  14.940  23.815  1.00 24.21           C  
ATOM   1755  CD1 TYR B  86       0.929  14.739  22.459  1.00 25.90           C  
ATOM   1756  CD2 TYR B  86      -0.066  14.047  24.502  1.00 24.59           C  
ATOM   1757  CE1 TYR B  86       0.285  13.690  21.787  1.00 25.31           C  
ATOM   1758  CE2 TYR B  86      -0.705  12.973  23.836  1.00 23.62           C  
ATOM   1759  CZ  TYR B  86      -0.523  12.816  22.484  1.00 25.37           C  
ATOM   1760  OH  TYR B  86      -1.136  11.792  21.796  1.00 25.13           O  
ATOM   1761  N   GLU B  87      -1.452  17.594  23.790  1.00 25.57           N  
ATOM   1762  CA  GLU B  87      -2.893  17.357  24.000  1.00 27.84           C  
ATOM   1763  C   GLU B  87      -3.391  16.502  22.888  1.00 26.83           C  
ATOM   1764  O   GLU B  87      -3.393  16.928  21.743  1.00 26.44           O  
ATOM   1765  CB  GLU B  87      -3.677  18.651  23.970  1.00 29.41           C  
ATOM   1766  CG  GLU B  87      -3.131  19.691  24.951  1.00 35.08           C  
ATOM   1767  CD  GLU B  87      -3.569  21.115  24.646  1.00 44.19           C  
ATOM   1768  OE1 GLU B  87      -4.602  21.286  23.964  1.00 47.92           O  
ATOM   1769  OE2 GLU B  87      -2.877  22.060  25.108  1.00 51.77           O  
ATOM   1770  N   GLU B  88      -3.766  15.268  23.199  1.00 26.91           N  
ATOM   1771  CA  GLU B  88      -4.325  14.373  22.159  1.00 25.83           C  
ATOM   1772  C   GLU B  88      -5.695  14.890  21.772  1.00 26.25           C  
ATOM   1773  O   GLU B  88      -6.395  15.448  22.612  1.00 26.57           O  
ATOM   1774  CB  GLU B  88      -4.431  12.954  22.675  1.00 27.20           C  
ATOM   1775  CG  GLU B  88      -4.739  11.935  21.572  1.00 26.61           C  
ATOM   1776  CD  GLU B  88      -4.279  10.542  21.880  1.00 29.02           C  
ATOM   1777  OE1 GLU B  88      -3.276  10.375  22.606  1.00 26.98           O  
ATOM   1778  OE2 GLU B  88      -4.906   9.600  21.350  1.00 27.71           O  
ATOM   1779  N   LEU B  89      -6.060  14.756  20.509  1.00 25.87           N  
ATOM   1780  CA  LEU B  89      -7.354  15.211  20.054  1.00 26.57           C  
ATOM   1781  C   LEU B  89      -8.159  14.002  19.580  1.00 25.83           C  
ATOM   1782  O   LEU B  89      -8.123  13.681  18.401  1.00 26.78           O  
ATOM   1783  CB  LEU B  89      -7.175  16.245  18.958  1.00 26.21           C  
ATOM   1784  CG  LEU B  89      -6.375  17.494  19.380  1.00 27.06           C  
ATOM   1785  CD1 LEU B  89      -5.870  18.239  18.116  1.00 29.68           C  
ATOM   1786  CD2 LEU B  89      -7.098  18.414  20.323  1.00 28.47           C  
ATOM   1787  N   PRO B  90      -8.927  13.358  20.486  1.00 24.94           N  
ATOM   1788  CA  PRO B  90      -9.621  12.154  20.093  1.00 25.09           C  
ATOM   1789  C   PRO B  90     -10.565  12.373  18.945  1.00 23.43           C  
ATOM   1790  O   PRO B  90     -11.054  13.503  18.773  1.00 21.46           O  
ATOM   1791  CB  PRO B  90     -10.431  11.781  21.340  1.00 25.65           C  
ATOM   1792  CG  PRO B  90      -9.773  12.419  22.410  1.00 26.97           C  
ATOM   1793  CD  PRO B  90      -9.254  13.712  21.872  1.00 26.72           C  
ATOM   1794  N   ASP B  91     -10.844  11.296  18.200  1.00 22.44           N  
ATOM   1795  CA  ASP B  91     -11.677  11.363  17.027  1.00 23.18           C  
ATOM   1796  C   ASP B  91     -13.167  11.451  17.386  1.00 22.88           C  
ATOM   1797  O   ASP B  91     -13.954  10.551  17.113  1.00 21.27           O  
ATOM   1798  CB  ASP B  91     -11.433  10.186  16.079  1.00 22.85           C  
ATOM   1799  CG  ASP B  91     -12.021  10.422  14.699  1.00 27.26           C  
ATOM   1800  OD1 ASP B  91     -12.573  11.516  14.401  1.00 28.92           O  
ATOM   1801  OD2 ASP B  91     -11.916   9.499  13.890  1.00 28.34           O  
ATOM   1802  N   LEU B  92     -13.525  12.591  17.960  1.00 23.30           N  
ATOM   1803  CA  LEU B  92     -14.884  12.884  18.396  1.00 23.98           C  
ATOM   1804  C   LEU B  92     -15.312  14.120  17.635  1.00 23.61           C  
ATOM   1805  O   LEU B  92     -14.481  14.885  17.150  1.00 23.13           O  
ATOM   1806  CB  LEU B  92     -14.933  13.173  19.900  1.00 23.94           C  
ATOM   1807  CG  LEU B  92     -14.339  12.089  20.806  1.00 27.81           C  
ATOM   1808  CD1 LEU B  92     -14.140  12.693  22.181  1.00 31.01           C  
ATOM   1809  CD2 LEU B  92     -15.225  10.860  20.850  1.00 29.49           C  
ATOM   1810  N   ILE B  93     -16.605  14.330  17.560  1.00 24.49           N  
ATOM   1811  CA  ILE B  93     -17.164  15.375  16.695  1.00 26.12           C  
ATOM   1812  C   ILE B  93     -16.683  16.780  17.057  1.00 26.66           C  
ATOM   1813  O   ILE B  93     -16.519  17.634  16.169  1.00 26.16           O  
ATOM   1814  CB  ILE B  93     -18.723  15.275  16.614  1.00 27.03           C  
ATOM   1815  CG1 ILE B  93     -19.308  16.184  15.514  1.00 28.27           C  
ATOM   1816  CG2 ILE B  93     -19.350  15.563  17.982  1.00 30.09           C  
ATOM   1817  CD1 ILE B  93     -18.827  15.855  14.072  1.00 30.15           C  
ATOM   1818  N   GLY B  94     -16.377  16.994  18.336  1.00 28.28           N  
ATOM   1819  CA  GLY B  94     -15.888  18.287  18.799  1.00 29.18           C  
ATOM   1820  C   GLY B  94     -14.524  18.660  18.235  1.00 30.07           C  
ATOM   1821  O   GLY B  94     -14.143  19.847  18.279  1.00 30.98           O  
ATOM   1822  N   HIS B  95     -13.772  17.664  17.745  1.00 28.19           N  
ATOM   1823  CA  HIS B  95     -12.449  17.887  17.132  1.00 26.77           C  
ATOM   1824  C   HIS B  95     -12.422  17.615  15.629  1.00 25.63           C  
ATOM   1825  O   HIS B  95     -11.379  17.721  15.000  1.00 25.54           O  
ATOM   1826  CB  HIS B  95     -11.377  17.019  17.823  1.00 26.82           C  
ATOM   1827  CG  HIS B  95     -11.224  17.295  19.279  1.00 29.35           C  
ATOM   1828  ND1 HIS B  95     -10.912  18.547  19.770  1.00 31.07           N  
ATOM   1829  CD2 HIS B  95     -11.350  16.485  20.362  1.00 31.36           C  
ATOM   1830  CE1 HIS B  95     -10.821  18.484  21.091  1.00 32.91           C  
ATOM   1831  NE2 HIS B  95     -11.079  17.245  21.472  1.00 32.15           N  
ATOM   1832  N   LYS B  96     -13.584  17.363  15.023  1.00 26.33           N  
ATOM   1833  CA  LYS B  96     -13.643  16.934  13.644  1.00 26.30           C  
ATOM   1834  C   LYS B  96     -13.196  18.046  12.687  1.00 26.54           C  
ATOM   1835  O   LYS B  96     -12.407  17.806  11.770  1.00 25.56           O  
ATOM   1836  CB  LYS B  96     -15.040  16.457  13.296  1.00 27.19           C  
ATOM   1837  CG  LYS B  96     -15.199  16.038  11.844  1.00 29.25           C  
ATOM   1838  CD  LYS B  96     -14.154  15.039  11.411  1.00 33.24           C  
ATOM   1839  CE  LYS B  96     -14.592  14.250  10.167  1.00 35.05           C  
ATOM   1840  NZ  LYS B  96     -13.497  13.301   9.759  1.00 37.61           N  
ATOM   1841  N   LEU B  97     -13.634  19.269  12.958  1.00 26.11           N  
ATOM   1842  CA  LEU B  97     -13.294  20.371  12.084  1.00 26.76           C  
ATOM   1843  C   LEU B  97     -11.783  20.646  12.190  1.00 25.80           C  
ATOM   1844  O   LEU B  97     -11.131  20.826  11.176  1.00 25.13           O  
ATOM   1845  CB  LEU B  97     -14.165  21.583  12.404  1.00 26.73           C  
ATOM   1846  CG  LEU B  97     -13.845  22.853  11.616  1.00 30.08           C  
ATOM   1847  CD1 LEU B  97     -14.204  22.647  10.138  1.00 30.70           C  
ATOM   1848  CD2 LEU B  97     -14.576  24.029  12.253  1.00 29.18           C  
ATOM   1849  N   GLN B  98     -11.241  20.633  13.409  1.00 25.90           N  
ATOM   1850  CA  GLN B  98      -9.785  20.757  13.636  1.00 26.26           C  
ATOM   1851  C   GLN B  98      -9.064  19.678  12.876  1.00 24.89           C  
ATOM   1852  O   GLN B  98      -8.080  19.926  12.179  1.00 25.09           O  
ATOM   1853  CB  GLN B  98      -9.433  20.582  15.114  1.00 26.72           C  
ATOM   1854  CG  GLN B  98      -9.921  21.717  15.992  1.00 31.69           C  
ATOM   1855  CD  GLN B  98      -9.835  21.396  17.448  1.00 36.32           C  
ATOM   1856  OE1 GLN B  98     -10.184  20.303  17.878  1.00 40.42           O  
ATOM   1857  NE2 GLN B  98      -9.401  22.368  18.237  1.00 40.14           N  
ATOM   1858  N   ARG B  99      -9.581  18.459  12.981  1.00 24.47           N  
ATOM   1859  CA  ARG B  99      -8.975  17.304  12.304  1.00 23.50           C  
ATOM   1860  C   ARG B  99      -8.999  17.465  10.792  1.00 23.81           C  
ATOM   1861  O   ARG B  99      -7.976  17.277  10.115  1.00 22.19           O  
ATOM   1862  CB  ARG B  99      -9.687  16.008  12.692  1.00 23.54           C  
ATOM   1863  CG  ARG B  99      -8.906  14.760  12.312  1.00 24.05           C  
ATOM   1864  CD  ARG B  99      -9.665  13.528  12.639  1.00 26.12           C  
ATOM   1865  NE  ARG B  99      -8.813  12.350  12.548  1.00 27.80           N  
ATOM   1866  CZ  ARG B  99      -8.264  11.699  13.582  1.00 28.58           C  
ATOM   1867  NH1 ARG B  99      -8.485  12.044  14.834  1.00 27.13           N  
ATOM   1868  NH2 ARG B  99      -7.496  10.642  13.343  1.00 32.10           N  
ATOM   1869  N   ASP B 100     -10.170  17.798  10.260  1.00 23.93           N  
ATOM   1870  CA  ASP B 100     -10.299  17.988   8.812  1.00 24.51           C  
ATOM   1871  C   ASP B 100      -9.380  19.086   8.288  1.00 24.26           C  
ATOM   1872  O   ASP B 100      -8.652  18.889   7.307  1.00 23.36           O  
ATOM   1873  CB  ASP B 100     -11.747  18.277   8.434  1.00 25.09           C  
ATOM   1874  CG  ASP B 100     -12.665  17.063   8.606  1.00 28.04           C  
ATOM   1875  OD1 ASP B 100     -12.179  15.891   8.771  1.00 31.70           O  
ATOM   1876  OD2 ASP B 100     -13.882  17.318   8.617  1.00 29.09           O  
ATOM   1877  N   HIS B 101      -9.386  20.231   8.968  1.00 24.61           N  
ATOM   1878  CA  HIS B 101      -8.492  21.339   8.603  1.00 25.03           C  
ATOM   1879  C   HIS B 101      -7.035  20.950   8.618  1.00 24.69           C  
ATOM   1880  O   HIS B 101      -6.330  21.163   7.637  1.00 24.61           O  
ATOM   1881  CB  HIS B 101      -8.642  22.507   9.578  1.00 25.40           C  
ATOM   1882  CG  HIS B 101      -9.930  23.246   9.441  1.00 26.45           C  
ATOM   1883  ND1 HIS B 101     -10.407  24.080  10.423  1.00 27.61           N  
ATOM   1884  CD2 HIS B 101     -10.818  23.313   8.419  1.00 27.79           C  
ATOM   1885  CE1 HIS B 101     -11.550  24.616  10.019  1.00 28.85           C  
ATOM   1886  NE2 HIS B 101     -11.818  24.165   8.807  1.00 26.72           N  
ATOM   1887  N   ALA B 102      -6.593  20.383   9.729  1.00 24.65           N  
ATOM   1888  CA  ALA B 102      -5.182  19.950   9.876  1.00 25.14           C  
ATOM   1889  C   ALA B 102      -4.793  18.925   8.820  1.00 24.99           C  
ATOM   1890  O   ALA B 102      -3.695  18.986   8.269  1.00 23.88           O  
ATOM   1891  CB  ALA B 102      -4.899  19.381  11.262  1.00 25.77           C  
ATOM   1892  N   TRP B 103      -5.687  17.971   8.563  1.00 25.09           N  
ATOM   1893  CA  TRP B 103      -5.374  16.869   7.658  1.00 25.35           C  
ATOM   1894  C   TRP B 103      -5.200  17.394   6.232  1.00 25.71           C  
ATOM   1895  O   TRP B 103      -4.340  16.910   5.478  1.00 25.59           O  
ATOM   1896  CB  TRP B 103      -6.474  15.818   7.690  1.00 25.61           C  
ATOM   1897  CG  TRP B 103      -6.206  14.714   6.764  1.00 25.44           C  
ATOM   1898  CD1 TRP B 103      -6.851  14.443   5.569  1.00 27.85           C  
ATOM   1899  CD2 TRP B 103      -5.172  13.761   6.884  1.00 25.23           C  
ATOM   1900  NE1 TRP B 103      -6.290  13.355   4.981  1.00 26.17           N  
ATOM   1901  CE2 TRP B 103      -5.257  12.909   5.766  1.00 26.24           C  
ATOM   1902  CE3 TRP B 103      -4.188  13.514   7.861  1.00 27.08           C  
ATOM   1903  CZ2 TRP B 103      -4.392  11.813   5.590  1.00 27.97           C  
ATOM   1904  CZ3 TRP B 103      -3.328  12.423   7.693  1.00 28.00           C  
ATOM   1905  CH2 TRP B 103      -3.422  11.603   6.554  1.00 26.12           C  
ATOM   1906  N   SER B 104      -6.015  18.370   5.863  1.00 25.62           N  
ATOM   1907  CA  SER B 104      -5.950  18.915   4.509  0.50 26.52           C  
ATOM   1909  C   SER B 104      -4.611  19.611   4.284  1.00 26.85           C  
ATOM   1910  O   SER B 104      -4.053  19.519   3.204  1.00 27.73           O  
ATOM   1911  CB  SER B 104      -7.148  19.827   4.184  0.50 26.32           C  
ATOM   1913  OG  SER B 104      -7.139  21.048   4.898  0.50 27.03           O  
ATOM   1915  N   VAL B 105      -4.072  20.259   5.325  1.00 28.73           N  
ATOM   1916  CA  VAL B 105      -2.765  20.933   5.230  1.00 29.59           C  
ATOM   1917  C   VAL B 105      -1.611  19.931   5.306  1.00 29.54           C  
ATOM   1918  O   VAL B 105      -0.618  20.059   4.591  1.00 29.18           O  
ATOM   1919  CB  VAL B 105      -2.621  21.999   6.316  1.00 29.82           C  
ATOM   1920  CG1 VAL B 105      -1.178  22.441   6.455  1.00 32.46           C  
ATOM   1921  CG2 VAL B 105      -3.531  23.158   6.006  1.00 30.23           C  
ATOM   1922  N   LEU B 106      -1.757  18.921   6.143  1.00 29.88           N  
ATOM   1923  CA  LEU B 106      -0.682  17.970   6.390  1.00 31.15           C  
ATOM   1924  C   LEU B 106      -0.757  16.693   5.561  1.00 33.12           C  
ATOM   1925  O   LEU B 106       0.155  15.864   5.612  1.00 33.88           O  
ATOM   1926  CB  LEU B 106      -0.652  17.615   7.877  1.00 30.91           C  
ATOM   1927  CG  LEU B 106      -0.193  18.739   8.807  1.00 29.44           C  
ATOM   1928  CD1 LEU B 106      -0.552  18.375  10.232  1.00 28.44           C  
ATOM   1929  CD2 LEU B 106       1.310  19.040   8.675  1.00 30.82           C  
ATOM   1930  N   SER B 107      -1.851  16.523   4.819  1.00 34.62           N  
ATOM   1931  CA  SER B 107      -2.127  15.272   4.105  1.00 36.41           C  
ATOM   1932  C   SER B 107      -1.019  14.929   3.142  1.00 37.57           C  
ATOM   1933  O   SER B 107      -0.560  13.787   3.126  1.00 38.48           O  
ATOM   1934  CB  SER B 107      -3.430  15.385   3.331  1.00 35.67           C  
ATOM   1935  OG  SER B 107      -3.462  14.444   2.287  1.00 39.86           O  
ATOM   1936  N   LYS B 108      -0.617  15.912   2.336  1.00 38.68           N  
ATOM   1937  CA  LYS B 108       0.516  15.790   1.419  1.00 40.68           C  
ATOM   1938  C   LYS B 108       1.818  15.371   2.136  1.00 41.16           C  
ATOM   1939  O   LYS B 108       2.499  14.418   1.721  1.00 40.70           O  
ATOM   1940  CB  LYS B 108       0.737  17.141   0.707  1.00 41.20           C  
ATOM   1941  CG  LYS B 108       1.687  17.091  -0.510  1.00 43.48           C  
ATOM   1942  CD  LYS B 108       2.669  18.297  -0.542  1.00 44.45           C  
ATOM   1943  CE  LYS B 108       3.355  18.475  -1.920  1.00 44.83           C  
ATOM   1944  NZ  LYS B 108       4.592  19.339  -1.840  1.00 45.30           N  
ATOM   1945  N   HIS B 109       2.136  16.104   3.208  1.00 41.95           N  
ATOM   1946  CA  HIS B 109       3.365  15.896   3.997  1.00 42.49           C  
ATOM   1947  C   HIS B 109       3.352  14.534   4.636  1.00 41.62           C  
ATOM   1948  O   HIS B 109       4.386  13.869   4.689  1.00 41.57           O  
ATOM   1949  CB  HIS B 109       3.534  16.999   5.065  1.00 43.15           C  
ATOM   1950  CG  HIS B 109       3.778  18.349   4.477  1.00 46.82           C  
ATOM   1951  ND1 HIS B 109       5.039  18.790   4.130  1.00 51.88           N  
ATOM   1952  CD2 HIS B 109       2.920  19.325   4.094  1.00 49.36           C  
ATOM   1953  CE1 HIS B 109       4.949  19.988   3.576  1.00 51.37           C  
ATOM   1954  NE2 HIS B 109       3.673  20.338   3.546  1.00 50.44           N  
ATOM   1955  N   THR B 110       2.173  14.124   5.104  1.00 41.30           N  
ATOM   1956  CA  THR B 110       1.969  12.811   5.730  1.00 41.28           C  
ATOM   1957  C   THR B 110       2.334  11.691   4.765  1.00 41.40           C  
ATOM   1958  O   THR B 110       2.804  10.636   5.176  1.00 41.05           O  
ATOM   1959  CB  THR B 110       0.505  12.624   6.238  1.00 41.21           C  
ATOM   1960  OG1 THR B 110       0.205  13.623   7.227  1.00 40.04           O  
ATOM   1961  CG2 THR B 110       0.301  11.226   6.828  1.00 41.28           C  
ATOM   1962  N   ASP B 111       2.171  11.943   3.473  1.00 41.58           N  
ATOM   1963  CA  ASP B 111       2.583  10.948   2.493  1.00 42.31           C  
ATOM   1964  C   ASP B 111       4.083  10.762   2.463  1.00 42.03           C  
ATOM   1965  O   ASP B 111       4.540   9.796   1.866  1.00 41.71           O  
ATOM   1966  CB  ASP B 111       2.069  11.293   1.086  1.00 42.51           C  
ATOM   1967  CG  ASP B 111       0.577  11.118   0.969  1.00 44.23           C  
ATOM   1968  OD1 ASP B 111       0.034  10.200   1.642  1.00 45.73           O  
ATOM   1969  OD2 ASP B 111      -0.053  11.892   0.222  1.00 45.73           O  
ATOM   1970  N   TRP B 112       4.840  11.669   3.092  1.00 41.87           N  
ATOM   1971  CA  TRP B 112       6.303  11.588   3.095  1.00 41.63           C  
ATOM   1972  C   TRP B 112       6.925  10.876   4.314  1.00 40.92           C  
ATOM   1973  O   TRP B 112       8.142  10.683   4.333  1.00 40.68           O  
ATOM   1974  CB  TRP B 112       6.941  12.968   2.903  1.00 42.21           C  
ATOM   1975  CG  TRP B 112       6.402  13.723   1.722  1.00 43.02           C  
ATOM   1976  CD1 TRP B 112       5.797  13.209   0.602  1.00 43.70           C  
ATOM   1977  CD2 TRP B 112       6.418  15.139   1.548  1.00 44.52           C  
ATOM   1978  NE1 TRP B 112       5.424  14.221  -0.245  1.00 43.63           N  
ATOM   1979  CE2 TRP B 112       5.796  15.417   0.311  1.00 44.09           C  
ATOM   1980  CE3 TRP B 112       6.876  16.209   2.334  1.00 44.33           C  
ATOM   1981  CZ2 TRP B 112       5.650  16.724  -0.177  1.00 44.33           C  
ATOM   1982  CZ3 TRP B 112       6.725  17.507   1.858  1.00 43.35           C  
ATOM   1983  CH2 TRP B 112       6.114  17.753   0.615  1.00 44.07           C  
ATOM   1984  N   TRP B 113       6.116  10.458   5.295  1.00 39.34           N  
ATOM   1985  CA  TRP B 113       6.624   9.613   6.399  1.00 38.50           C  
ATOM   1986  C   TRP B 113       5.771   8.391   6.711  1.00 38.02           C  
ATOM   1987  O   TRP B 113       6.285   7.418   7.254  1.00 36.71           O  
ATOM   1988  CB  TRP B 113       6.794  10.434   7.701  1.00 37.50           C  
ATOM   1989  CG  TRP B 113       5.537  11.124   8.144  1.00 37.36           C  
ATOM   1990  CD1 TRP B 113       5.177  12.412   7.881  1.00 36.72           C  
ATOM   1991  CD2 TRP B 113       4.475  10.568   8.943  1.00 36.12           C  
ATOM   1992  NE1 TRP B 113       3.967  12.698   8.456  1.00 36.44           N  
ATOM   1993  CE2 TRP B 113       3.505  11.582   9.107  1.00 37.10           C  
ATOM   1994  CE3 TRP B 113       4.259   9.317   9.546  1.00 36.76           C  
ATOM   1995  CZ2 TRP B 113       2.330  11.385   9.840  1.00 36.24           C  
ATOM   1996  CZ3 TRP B 113       3.093   9.118  10.268  1.00 37.02           C  
ATOM   1997  CH2 TRP B 113       2.132  10.139  10.391  1.00 36.95           C  
ATOM   1998  N   GLU B 114       4.466   8.471   6.430  1.00 38.35           N  
ATOM   1999  CA  GLU B 114       3.521   7.396   6.778  1.00 39.07           C  
ATOM   2000  C   GLU B 114       3.883   6.061   6.090  1.00 39.21           C  
ATOM   2001  O   GLU B 114       3.872   5.982   4.859  1.00 38.57           O  
ATOM   2002  CB  GLU B 114       2.100   7.823   6.387  1.00 39.48           C  
ATOM   2003  CG  GLU B 114       0.989   6.860   6.772  1.00 41.57           C  
ATOM   2004  CD  GLU B 114      -0.279   7.168   5.982  1.00 46.27           C  
ATOM   2005  OE1 GLU B 114      -1.053   8.070   6.392  1.00 47.00           O  
ATOM   2006  OE2 GLU B 114      -0.469   6.532   4.914  1.00 49.40           O  
ATOM   2007  N   PRO B 115       4.182   5.007   6.878  1.00 39.27           N  
ATOM   2008  CA  PRO B 115       4.514   3.734   6.235  1.00 40.06           C  
ATOM   2009  C   PRO B 115       3.291   3.104   5.559  1.00 40.59           C  
ATOM   2010  O   PRO B 115       2.202   3.014   6.155  1.00 39.93           O  
ATOM   2011  CB  PRO B 115       5.024   2.858   7.391  1.00 39.84           C  
ATOM   2012  CG  PRO B 115       5.167   3.793   8.576  1.00 40.13           C  
ATOM   2013  CD  PRO B 115       4.224   4.906   8.349  1.00 39.95           C  
ATOM   2014  N   GLY B 116       3.468   2.696   4.311  1.00 41.81           N  
ATOM   2015  CA  GLY B 116       2.408   1.987   3.585  1.00 42.86           C  
ATOM   2016  C   GLY B 116       2.185   0.599   4.150  1.00 43.55           C  
ATOM   2017  O   GLY B 116       3.047   0.078   4.864  1.00 43.78           O  
ATOM   2018  N   ALA B 117       1.022   0.014   3.841  1.00 44.40           N  
ATOM   2019  CA  ALA B 117       0.749  -1.401   4.141  1.00 44.85           C  
ATOM   2020  C   ALA B 117       1.686  -2.283   3.304  1.00 45.28           C  
ATOM   2021  O   ALA B 117       1.888  -2.013   2.124  1.00 45.06           O  
ATOM   2022  CB  ALA B 117      -0.731  -1.749   3.886  1.00 44.74           C  
ATOM   2023  N   LEU B 118       2.264  -3.305   3.944  1.00 46.07           N  
ATOM   2024  CA  LEU B 118       3.330  -4.160   3.372  1.00 46.30           C  
ATOM   2025  C   LEU B 118       4.363  -3.409   2.501  1.00 46.48           C  
ATOM   2026  O   LEU B 118       4.862  -2.335   2.865  1.00 47.05           O  
ATOM   2027  CB  LEU B 118       2.727  -5.324   2.572  1.00 46.35           C  
ATOM   2028  CG  LEU B 118       2.070  -6.523   3.262  1.00 46.46           C  
ATOM   2029  CD1 LEU B 118       0.677  -6.158   3.795  1.00 47.32           C  
ATOM   2030  CD2 LEU B 118       1.982  -7.721   2.300  1.00 46.32           C  
ATOM   2031  N   SER B 128      -6.932   9.756   7.826  1.00 60.42           N  
ATOM   2032  CA  SER B 128      -6.727  10.118   9.233  1.00 58.84           C  
ATOM   2033  C   SER B 128      -7.654   9.300  10.176  1.00 60.98           C  
ATOM   2034  O   SER B 128      -8.236   9.842  11.103  1.00 64.55           O  
ATOM   2035  CB  SER B 128      -6.915  11.633   9.420  1.00 57.75           C  
ATOM   2036  OG  SER B 128      -8.240  12.057   9.106  1.00 48.80           O  
ATOM   2037  N   ALA B 129      -7.819   8.005   9.925  1.00 59.48           N  
ATOM   2038  CA  ALA B 129      -8.605   7.175  10.824  1.00 58.51           C  
ATOM   2039  C   ALA B 129      -7.718   6.506  11.891  1.00 58.40           C  
ATOM   2040  O   ALA B 129      -7.912   6.782  13.070  1.00 61.09           O  
ATOM   2041  CB  ALA B 129      -9.456   6.152  10.054  1.00 58.73           C  
ATOM   2042  N   PRO B 130      -6.710   5.668  11.501  1.00 55.36           N  
ATOM   2043  CA  PRO B 130      -5.896   5.022  12.568  1.00 50.87           C  
ATOM   2044  C   PRO B 130      -4.815   5.977  13.080  1.00 45.59           C  
ATOM   2045  O   PRO B 130      -3.953   5.581  13.868  1.00 45.54           O  
ATOM   2046  CB  PRO B 130      -5.241   3.846  11.852  1.00 50.94           C  
ATOM   2047  CG  PRO B 130      -5.045   4.356  10.422  1.00 55.12           C  
ATOM   2048  CD  PRO B 130      -6.203   5.335  10.152  1.00 56.34           C  
ATOM   2049  N   HIS B 131      -4.880   7.207  12.598  1.00 39.87           N  
ATOM   2050  CA  HIS B 131      -3.956   8.227  13.000  1.00 37.52           C  
ATOM   2051  C   HIS B 131      -4.322   8.769  14.348  1.00 34.37           C  
ATOM   2052  O   HIS B 131      -5.496   8.931  14.684  1.00 32.09           O  
ATOM   2053  CB  HIS B 131      -3.959   9.373  12.010  1.00 38.32           C  
ATOM   2054  CG  HIS B 131      -3.310   9.032  10.721  1.00 40.49           C  
ATOM   2055  ND1 HIS B 131      -1.957   9.202  10.516  1.00 43.40           N  
ATOM   2056  CD2 HIS B 131      -3.805   8.479   9.592  1.00 41.64           C  
ATOM   2057  CE1 HIS B 131      -1.651   8.786   9.300  1.00 45.61           C  
ATOM   2058  NE2 HIS B 131      -2.757   8.347   8.718  1.00 43.65           N  
ATOM   2059  N   VAL B 132      -3.283   9.100  15.093  1.00 31.17           N  
ATOM   2060  CA  VAL B 132      -3.444   9.889  16.283  1.00 29.68           C  
ATOM   2061  C   VAL B 132      -3.256  11.345  15.867  1.00 28.05           C  
ATOM   2062  O   VAL B 132      -2.215  11.723  15.318  1.00 27.12           O  
ATOM   2063  CB  VAL B 132      -2.405   9.516  17.348  1.00 28.37           C  
ATOM   2064  CG1 VAL B 132      -2.576  10.418  18.551  1.00 29.42           C  
ATOM   2065  CG2 VAL B 132      -2.520   8.078  17.704  1.00 29.73           C  
ATOM   2066  N   PHE B 133      -4.279  12.152  16.107  1.00 26.32           N  
ATOM   2067  CA  PHE B 133      -4.220  13.596  15.881  1.00 24.97           C  
ATOM   2068  C   PHE B 133      -3.942  14.252  17.228  1.00 24.68           C  
ATOM   2069  O   PHE B 133      -4.504  13.844  18.251  1.00 23.08           O  
ATOM   2070  CB  PHE B 133      -5.590  14.043  15.360  1.00 24.57           C  
ATOM   2071  CG  PHE B 133      -5.723  15.509  15.104  1.00 24.44           C  
ATOM   2072  CD1 PHE B 133      -4.707  16.241  14.550  1.00 21.72           C  
ATOM   2073  CD2 PHE B 133      -6.933  16.141  15.369  1.00 24.91           C  
ATOM   2074  CE1 PHE B 133      -4.876  17.558  14.310  1.00 24.50           C  
ATOM   2075  CE2 PHE B 133      -7.106  17.456  15.126  1.00 23.53           C  
ATOM   2076  CZ  PHE B 133      -6.089  18.169  14.582  1.00 24.82           C  
ATOM   2077  N   PHE B 134      -3.075  15.256  17.245  1.00 23.20           N  
ATOM   2078  CA  PHE B 134      -2.727  15.903  18.501  1.00 23.97           C  
ATOM   2079  C   PHE B 134      -2.239  17.299  18.248  1.00 23.50           C  
ATOM   2080  O   PHE B 134      -1.904  17.669  17.096  1.00 24.28           O  
ATOM   2081  CB  PHE B 134      -1.689  15.087  19.297  1.00 23.31           C  
ATOM   2082  CG  PHE B 134      -0.295  15.062  18.695  1.00 23.33           C  
ATOM   2083  CD1 PHE B 134       0.048  14.107  17.763  1.00 23.93           C  
ATOM   2084  CD2 PHE B 134       0.676  15.990  19.054  1.00 25.15           C  
ATOM   2085  CE1 PHE B 134       1.331  14.089  17.200  1.00 24.28           C  
ATOM   2086  CE2 PHE B 134       1.976  15.939  18.511  1.00 26.21           C  
ATOM   2087  CZ  PHE B 134       2.293  15.015  17.586  1.00 23.57           C  
ATOM   2088  N   ARG B 135      -2.179  18.057  19.333  1.00 25.28           N  
ATOM   2089  CA  ARG B 135      -1.529  19.360  19.308  1.00 26.04           C  
ATOM   2090  C   ARG B 135      -0.567  19.548  20.471  1.00 25.81           C  
ATOM   2091  O   ARG B 135      -0.739  18.998  21.562  1.00 25.97           O  
ATOM   2092  CB  ARG B 135      -2.530  20.509  19.253  1.00 25.78           C  
ATOM   2093  CG  ARG B 135      -3.503  20.606  20.382  1.00 25.38           C  
ATOM   2094  CD  ARG B 135      -4.618  21.620  20.089  1.00 26.99           C  
ATOM   2095  NE  ARG B 135      -5.399  21.804  21.304  1.00 27.42           N  
ATOM   2096  CZ  ARG B 135      -6.525  22.512  21.416  1.00 32.13           C  
ATOM   2097  NH1 ARG B 135      -7.072  23.127  20.390  1.00 31.52           N  
ATOM   2098  NH2 ARG B 135      -7.138  22.584  22.584  1.00 31.29           N  
ATOM   2099  N   ILE B 136       0.442  20.364  20.215  1.00 25.29           N  
ATOM   2100  CA  ILE B 136       1.302  20.908  21.225  1.00 24.25           C  
ATOM   2101  C   ILE B 136       0.872  22.336  21.547  1.00 25.03           C  
ATOM   2102  O   ILE B 136       0.949  23.237  20.694  1.00 23.91           O  
ATOM   2103  CB  ILE B 136       2.770  20.912  20.749  1.00 24.42           C  
ATOM   2104  CG1 ILE B 136       3.236  19.517  20.334  1.00 24.93           C  
ATOM   2105  CG2 ILE B 136       3.651  21.455  21.809  1.00 23.41           C  
ATOM   2106  CD1 ILE B 136       2.999  18.365  21.301  1.00 24.59           C  
ATOM   2107  N   LEU B 137       0.385  22.542  22.765  1.00 25.20           N  
ATOM   2108  CA  LEU B 137       0.111  23.891  23.261  1.00 26.69           C  
ATOM   2109  C   LEU B 137       1.401  24.580  23.611  1.00 24.45           C  
ATOM   2110  O   LEU B 137       2.238  24.017  24.328  1.00 24.62           O  
ATOM   2111  CB  LEU B 137      -0.777  23.819  24.475  1.00 27.01           C  
ATOM   2112  CG  LEU B 137      -1.005  25.121  25.216  1.00 32.06           C  
ATOM   2113  CD1 LEU B 137      -1.474  26.330  24.341  1.00 33.93           C  
ATOM   2114  CD2 LEU B 137      -2.055  24.815  26.275  1.00 36.32           C  
ATOM   2115  N   ILE B 138       1.602  25.761  23.035  1.00 24.55           N  
ATOM   2116  CA  ILE B 138       2.823  26.527  23.218  1.00 24.96           C  
ATOM   2117  C   ILE B 138       2.677  27.286  24.533  1.00 25.87           C  
ATOM   2118  O   ILE B 138       1.878  28.199  24.636  1.00 26.25           O  
ATOM   2119  CB  ILE B 138       3.046  27.513  22.025  1.00 23.88           C  
ATOM   2120  CG1 ILE B 138       3.200  26.724  20.731  1.00 25.66           C  
ATOM   2121  CG2 ILE B 138       4.284  28.420  22.267  1.00 25.99           C  
ATOM   2122  CD1 ILE B 138       3.116  27.533  19.451  1.00 25.36           C  
ATOM   2123  N   GLU B 139       3.436  26.900  25.558  1.00 26.08           N  
ATOM   2124  CA  GLU B 139       3.346  27.578  26.835  1.00 26.49           C  
ATOM   2125  C   GLU B 139       4.448  28.613  27.007  1.00 27.01           C  
ATOM   2126  O   GLU B 139       4.191  29.725  27.457  1.00 27.70           O  
ATOM   2127  CB  GLU B 139       3.342  26.558  27.970  1.00 26.32           C  
ATOM   2128  CG  GLU B 139       2.153  25.607  27.822  1.00 27.49           C  
ATOM   2129  CD  GLU B 139       1.815  24.822  29.045  1.00 29.13           C  
ATOM   2130  OE1 GLU B 139       2.639  24.770  29.979  1.00 27.63           O  
ATOM   2131  OE2 GLU B 139       0.706  24.256  29.052  1.00 28.86           O  
ATOM   2132  N   GLN B 140       5.675  28.247  26.693  1.00 27.07           N  
ATOM   2133  CA  GLN B 140       6.801  29.201  26.697  1.00 26.84           C  
ATOM   2134  C   GLN B 140       7.447  29.102  25.320  1.00 26.51           C  
ATOM   2135  O   GLN B 140       7.418  28.042  24.666  1.00 25.97           O  
ATOM   2136  CB  GLN B 140       7.863  28.854  27.761  1.00 27.13           C  
ATOM   2137  CG  GLN B 140       7.295  28.376  29.106  1.00 30.96           C  
ATOM   2138  CD  GLN B 140       6.557  29.483  29.861  1.00 35.12           C  
ATOM   2139  OE1 GLN B 140       6.831  30.667  29.626  1.00 36.73           O  
ATOM   2140  NE2 GLN B 140       5.634  29.108  30.788  1.00 30.93           N  
ATOM   2141  N   VAL B 141       7.984  30.208  24.843  1.00 26.56           N  
ATOM   2142  CA  VAL B 141       8.659  30.225  23.534  1.00 27.08           C  
ATOM   2143  C   VAL B 141       9.804  31.216  23.604  1.00 26.48           C  
ATOM   2144  O   VAL B 141       9.673  32.274  24.216  1.00 25.69           O  
ATOM   2145  CB  VAL B 141       7.685  30.540  22.354  1.00 27.89           C  
ATOM   2146  CG1 VAL B 141       7.099  31.861  22.462  1.00 29.67           C  
ATOM   2147  CG2 VAL B 141       8.408  30.438  20.972  1.00 27.50           C  
ATOM   2148  N   SER B 142      10.939  30.829  23.036  1.00 26.47           N  
ATOM   2149  CA  SER B 142      12.111  31.665  22.911  1.00 27.07           C  
ATOM   2150  C   SER B 142      12.654  31.521  21.497  1.00 26.56           C  
ATOM   2151  O   SER B 142      12.369  30.538  20.812  1.00 25.30           O  
ATOM   2152  CB  SER B 142      13.198  31.256  23.902  1.00 27.75           C  
ATOM   2153  OG  SER B 142      13.640  29.934  23.572  1.00 31.92           O  
ATOM   2154  N   GLY B 143      13.419  32.520  21.075  1.00 25.29           N  
ATOM   2155  CA  GLY B 143      13.957  32.575  19.717  1.00 25.86           C  
ATOM   2156  C   GLY B 143      15.363  33.154  19.719  1.00 25.69           C  
ATOM   2157  O   GLY B 143      15.713  33.952  20.587  1.00 26.02           O  
ATOM   2158  N   ARG B 144      16.163  32.733  18.742  1.00 25.77           N  
ATOM   2159  CA  ARG B 144      17.496  33.244  18.515  1.00 26.62           C  
ATOM   2160  C   ARG B 144      17.699  33.491  17.034  1.00 26.63           C  
ATOM   2161  O   ARG B 144      17.207  32.741  16.218  1.00 24.57           O  
ATOM   2162  CB  ARG B 144      18.580  32.234  18.907  1.00 27.65           C  
ATOM   2163  CG  ARG B 144      18.690  31.899  20.374  1.00 31.23           C  
ATOM   2164  CD  ARG B 144      19.378  33.002  21.109  1.00 34.16           C  
ATOM   2165  NE  ARG B 144      19.410  32.794  22.561  1.00 36.40           N  
ATOM   2166  CZ  ARG B 144      20.415  32.239  23.232  1.00 38.33           C  
ATOM   2167  NH1 ARG B 144      21.517  31.816  22.619  1.00 40.51           N  
ATOM   2168  NH2 ARG B 144      20.334  32.144  24.548  1.00 39.30           N  
ATOM   2169  N   GLU B 145      18.477  34.509  16.689  1.00 25.72           N  
ATOM   2170  CA  GLU B 145      18.900  34.691  15.309  1.00 27.21           C  
ATOM   2171  C   GLU B 145      20.402  34.952  15.264  1.00 27.50           C  
ATOM   2172  O   GLU B 145      20.895  35.713  16.060  1.00 26.96           O  
ATOM   2173  CB  GLU B 145      18.195  35.875  14.660  1.00 27.92           C  
ATOM   2174  CG  GLU B 145      18.677  36.118  13.226  1.00 32.23           C  
ATOM   2175  CD  GLU B 145      18.280  37.438  12.674  1.00 37.60           C  
ATOM   2176  OE1 GLU B 145      17.069  37.641  12.493  1.00 40.58           O  
ATOM   2177  OE2 GLU B 145      19.183  38.291  12.424  1.00 44.09           O  
ATOM   2178  N   ALA B 146      21.095  34.289  14.349  1.00 28.31           N  
ATOM   2179  CA  ALA B 146      22.467  34.598  13.965  1.00 29.73           C  
ATOM   2180  C   ALA B 146      22.456  35.387  12.664  1.00 30.62           C  
ATOM   2181  O   ALA B 146      21.860  34.944  11.676  1.00 30.95           O  
ATOM   2182  CB  ALA B 146      23.264  33.312  13.751  1.00 29.89           C  
ATOM   2183  N   SER B 147      23.094  36.548  12.669  1.00 31.84           N  
ATOM   2184  CA  SER B 147      23.405  37.312  11.438  1.00 32.99           C  
ATOM   2185  C   SER B 147      24.882  37.140  11.081  1.00 33.33           C  
ATOM   2186  O   SER B 147      25.406  37.833  10.207  1.00 34.32           O  
ATOM   2187  CB  SER B 147      23.132  38.807  11.638  1.00 33.33           C  
ATOM   2188  OG  SER B 147      21.875  39.015  12.256  1.00 35.46           O  
TER    2189      SER B 147                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
