
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  194 ( 1574),  selected  194 , name 2i51_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2i51_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      M       1           -
LGA    S     2_A      A       2           -
LGA    L     3_A      D       3           -
LGA    A     4_A      -       -           -
LGA    P     5_A      -       -           -
LGA    W     6_A      P       4           #
LGA    R     7_A      K       5           #
LGA    -       -      E       6           -
LGA    -       -      L       7           -
LGA    -       -      Q       8           -
LGA    G     8_A      D       9          1.096
LGA    A     9_A      K      10          1.314
LGA    I    10_A      F      11          1.938
LGA    A    11_A      W      12          4.312
LGA    H    12_A      K      13          4.474
LGA    A    13_A      A      14          3.247
LGA    L    14_A      L      15           #
LGA    -       -      K      16           -
LGA    H    15_A      S      17           #
LGA    R    16_A      -       -           -
LGA    N    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    S    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    V    21_A      -       -           -
LGA    Y    22_A      -       -           -
LGA    A    23_A      D      18          3.581
LGA    R    24_A      R      19          2.648
LGA    Y    25_A      T      20          1.720
LGA    L    26_A      V      21          1.821
LGA    Q    27_A      M      22          0.307
LGA    L    28_A      L      23          0.546
LGA    A    29_A      G      24          0.965
LGA    T    30_A      L      25          1.022
LGA    V    31_A      D      26          4.414
LGA    Q    32_A      -       -           -
LGA    P    33_A      -       -           -
LGA    N    34_A      G      27           #
LGA    G    35_A      V      28          3.088
LGA    R    36_A      E      29          1.284
LGA    P    37_A      D      30          3.742
LGA    A    38_A      G      31          1.783
LGA    -       -      H      32           -
LGA    N    39_A      A      33          0.613
LGA    R    40_A      R      34          0.466
LGA    T    41_A      P      35          0.534
LGA    L    42_A      M      36          0.629
LGA    V    43_A      T      37          1.388
LGA    F    44_A      A      38          1.891
LGA    R    45_A      Q      39          2.349
LGA    G    46_A      I      40          3.084
LGA    F    47_A      -       -           -
LGA    L    48_A      E      41          2.928
LGA    E    49_A      G      42          4.467
LGA    D    50_A      D      43           -
LGA    T    51_A      S      44           #
LGA    N    52_A      G      45          2.059
LGA    Q    53_A      G      46          1.743
LGA    -       -      P      47           -
LGA    L    54_A      I      48          1.163
LGA    R    55_A      W      49          1.553
LGA    F    56_A      F      50          0.978
LGA    I    57_A      F      51          0.712
LGA    T    58_A      T      52          1.044
LGA    D    59_A      S      53          1.110
LGA    T    60_A      K      54          1.314
LGA    R    61_A      D      55          1.372
LGA    S    62_A      N      56          1.618
LGA    A    63_A      A      57          0.946
LGA    K    64_A      L      58          1.118
LGA    A    65_A      I      59          0.661
LGA    D    66_A      A      60          0.875
LGA    Q    67_A      M      61          2.032
LGA    I    68_A      L      62          2.121
LGA    Q    69_A      G      63          2.483
LGA    Q    70_A      Q      64           #
LGA    Q    71_A      G      65          5.010
LGA    P    72_A      R      66          1.956
LGA    W    73_A      R      67          1.345
LGA    A    74_A      V      68          1.064
LGA    E    75_A      I      69          1.024
LGA    I    76_A      G      70          0.412
LGA    C    77_A      A      71          0.639
LGA    W    78_A      F      72          0.379
LGA    Y    79_A      S      73          1.235
LGA    F    80_A      S      74          1.854
LGA    P    81_A      K      75          4.045
LGA    N    82_A      G      76          1.287
LGA    T    83_A      H      77          4.018
LGA    R    84_A      D      78          2.826
LGA    E    85_A      L      79          1.713
LGA    Q    86_A      F      80          0.362
LGA    F    87_A      A      81          0.701
LGA    R    88_A      S      82          0.749
LGA    X    89_A      I      83          0.721
LGA    A    90_A      S      84          0.525
LGA    G    91_A      G      85          0.630
LGA    D    92_A      S      86          1.067
LGA    L    93_A      L      87          1.652
LGA    T    94_A      R      88          2.991
LGA    L    95_A      E      89          0.886
LGA    I    96_A      D      90          1.641
LGA    S    97_A      T      91          3.262
LGA    S    98_A      D      92           #
LGA    D    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    S   101_A      -       -           -
LGA    H   102_A      -       -           -
LGA    Q   103_A      -       -           -
LGA    D   104_A      -       -           -
LGA    L   105_A      -       -           -
LGA    Q   106_A      P      93          3.086
LGA    P   107_A      A      94          0.672
LGA    A   108_A      V      95          0.597
LGA    R   109_A      V      96          2.250
LGA    I   110_A      D      97          3.089
LGA    A   111_A      R      98          2.756
LGA    X   112_A      L      99          2.718
LGA    W   113_A      W     100          3.951
LGA    Q   114_A      -       -           -
LGA    E   115_A      N     101          1.995
LGA    L   116_A      P     102          3.895
LGA    S   117_A      Y     103          3.483
LGA    -       -      V     104           -
LGA    D   118_A      A     105          3.659
LGA    A   119_A      A     106          1.851
LGA    A   120_A      W     107          1.589
LGA    R   121_A      Y     108          1.676
LGA    L   122_A      E     109          2.394
LGA    Q   123_A      -       -           -
LGA    F   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    W   126_A      -       -           -
LGA    P   127_A      -       -           -
LGA    Y   128_A      -       -           -
LGA    P   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    K   131_A      -       -           -
LGA    P   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    I   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    S   137_A      -       -           -
LGA    G   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    E   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    P   144_A      -       -           -
LGA    P   145_A      G     110          1.969
LGA    D   146_A      G     111          4.355
LGA    P   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    E   149_A      K     112          3.793
LGA    P   150_A      D     113          2.907
LGA    V   151_A      D     114          2.124
LGA    P   152_A      P     115          2.642
LGA    N   153_A      K     116          2.579
LGA    F   154_A      L     117          1.131
LGA    C   155_A      A     118          1.409
LGA    L   156_A      L     119          1.484
LGA    L   157_A      L     120          1.286
LGA    L   158_A      R     121          1.441
LGA    L   159_A      L     122          1.138
LGA    D   160_A      D     123          1.664
LGA    P   161_A      A     124          1.284
LGA    V   162_A      D     125          0.913
LGA    Q   163_A      H     126          1.513
LGA    V   164_A      A     127          0.608
LGA    D   165_A      Q     128          0.301
LGA    H   166_A      I     129          0.302
LGA    L   167_A      W     130          0.347
LGA    E   168_A      L     131          0.980
LGA    L   169_A      N     132          1.950
LGA    R   170_A      G     133          0.821
LGA    G   171_A      S     134          5.311
LGA    E   172_A      -       -           -
LGA    P   173_A      S     135          5.287
LGA    Q   174_A      L     136           -
LGA    N   175_A      L     137           -
LGA    R   176_A      A     138           -
LGA    W   177_A      G     139           -
LGA    L   178_A      I     140           -
LGA    Y   179_A      K     141           -
LGA    H   180_A      V     142           -
LGA    R   181_A      L     143           -
LGA    N   182_A      L     144           -
LGA    D   183_A      G     145           -
LGA    Q   184_A      -       -           -
LGA    Q   185_A      -       -           -
LGA    E   186_A      -       -           -
LGA    W   187_A      -       -           -
LGA    S   188_A      -       -           -
LGA    S   189_A      -       -           -
LGA    E   190_A      -       -           -
LGA    A   191_A      -       -           -
LGA    I   192_A      -       -           -
LGA    N   193_A      -       -           -
LGA    P   194_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  194  145    5.0    116    2.26    13.79     54.139     4.911

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.097681 * X  +   0.297873 * Y  +   0.949595 * Z  + -22.433258
  Y_new =   0.984518 * X  +  -0.168463 * Y  +  -0.048429 * Z  + -16.698914
  Z_new =   0.145546 * X  +   0.939623 * Y  +  -0.309716 * Z  + -48.026691 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.889199   -1.252394  [ DEG:   108.2431    -71.7569 ]
  Theta =  -0.146064   -2.995528  [ DEG:    -8.3689   -171.6311 ]
  Phi   =   1.471903   -1.669689  [ DEG:    84.3338    -95.6662 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i51_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i51_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  194  145   5.0  116   2.26   13.79  54.139
REMARK  ---------------------------------------------------------- 
MOLECULE 2i51_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   23-AUG-06   2I51              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED PROTEIN OF             
TITLE    2 COG5135 (ZP_00109616.1) FROM NOSTOC PUNCTIFORME PCC 73102            
TITLE    3 AT 1.40 A RESOLUTION                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED CONSERVED PROTEIN OF COG5135;              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00109616.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00109616.1, UNCHARACTERIZED CONSERVED PROTEIN OF COG5135,          
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI2                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   05-SEP-06 2I51    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED               
JRNL        TITL 2 PROTEIN OF COG5135 (ZP_00109616.1) FROM NOSTOC               
JRNL        TITL 3 PUNCTIFORME PCC 73102 AT 1.40 A RESOLUTION                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.40 ANGSTROMS.                                          
DBREF  2I51 A    1   181  UNP    Q8YQ04   Q8YQ04_ANASP     1    181             
DBREF  2I51 B    1   181  UNP    Q8YQ04   Q8YQ04_ANASP     1    181             
SEQRES   1 A  195  GLY MSE SER LEU ALA PRO TRP ARG GLY ALA ILE ALA HIS          
SEQRES   2 A  195  ALA LEU HIS ARG ASN ARG SER LEU VAL TYR ALA ARG TYR          
SEQRES   3 A  195  LEU GLN LEU ALA THR VAL GLN PRO ASN GLY ARG PRO ALA          
SEQRES   4 A  195  ASN ARG THR LEU VAL PHE ARG GLY PHE LEU GLU ASP THR          
SEQRES   5 A  195  ASN GLN LEU ARG PHE ILE THR ASP THR ARG SER ALA LYS          
SEQRES   6 A  195  ALA ASP GLN ILE GLN GLN GLN PRO TRP ALA GLU ILE CYS          
SEQRES   7 A  195  TRP TYR PHE PRO ASN THR ARG GLU GLN PHE ARG MSE ALA          
SEQRES   8 A  195  GLY ASP LEU THR LEU ILE SER SER ASP ASP SER HIS GLN          
SEQRES   9 A  195  ASP LEU GLN PRO ALA ARG ILE ALA MSE TRP GLN GLU LEU          
SEQRES  10 A  195  SER ASP ALA ALA ARG LEU GLN PHE GLY TRP PRO TYR PRO          
SEQRES  11 A  195  GLY LYS PRO ARG ILE LYS GLU SER GLY ALA PHE GLU PRO          
SEQRES  12 A  195  SER PRO PRO ASP PRO ILE GLU PRO VAL PRO ASN PHE CYS          
SEQRES  13 A  195  LEU LEU LEU LEU ASP PRO VAL GLN VAL ASP HIS LEU GLU          
SEQRES  14 A  195  LEU ARG GLY GLU PRO GLN ASN ARG TRP LEU TYR HIS ARG          
SEQRES  15 A  195  ASN ASP GLN GLN GLU TRP SER SER GLU ALA ILE ASN PRO          
SEQRES   1 B  195  GLY MSE SER LEU ALA PRO TRP ARG GLY ALA ILE ALA HIS          
SEQRES   2 B  195  ALA LEU HIS ARG ASN ARG SER LEU VAL TYR ALA ARG TYR          
SEQRES   3 B  195  LEU GLN LEU ALA THR VAL GLN PRO ASN GLY ARG PRO ALA          
SEQRES   4 B  195  ASN ARG THR LEU VAL PHE ARG GLY PHE LEU GLU ASP THR          
SEQRES   5 B  195  ASN GLN LEU ARG PHE ILE THR ASP THR ARG SER ALA LYS          
SEQRES   6 B  195  ALA ASP GLN ILE GLN GLN GLN PRO TRP ALA GLU ILE CYS          
SEQRES   7 B  195  TRP TYR PHE PRO ASN THR ARG GLU GLN PHE ARG MSE ALA          
SEQRES   8 B  195  GLY ASP LEU THR LEU ILE SER SER ASP ASP SER HIS GLN          
SEQRES   9 B  195  ASP LEU GLN PRO ALA ARG ILE ALA MSE TRP GLN GLU LEU          
SEQRES  10 B  195  SER ASP ALA ALA ARG LEU GLN PHE GLY TRP PRO TYR PRO          
SEQRES  11 B  195  GLY LYS PRO ARG ILE LYS GLU SER GLY ALA PHE GLU PRO          
SEQRES  12 B  195  SER PRO PRO ASP PRO ILE GLU PRO VAL PRO ASN PHE CYS          
SEQRES  13 B  195  LEU LEU LEU LEU ASP PRO VAL GLN VAL ASP HIS LEU GLU          
SEQRES  14 B  195  LEU ARG GLY GLU PRO GLN ASN ARG TRP LEU TYR HIS ARG          
SEQRES  15 B  195  ASN ASP GLN GLN GLU TRP SER SER GLU ALA ILE ASN PRO          
HET    MSE  A   1       5                                                       
HET    MSE  A  89      13                                                       
HET    MSE  A 112       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  89      13                                                       
HET    MSE  B 112       8                                                       
HET    FMN  A 300      31                                                       
HET    FMN  B 300      31                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       6                                                       
HET    EDO      7       8                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HET    EDO     12       4                                                       
HET    EDO     13       4                                                       
HET    EDO     14       4                                                       
HET    EDO     15       4                                                       
HET    EDO     16       4                                                       
HET    EDO     17       4                                                       
HET    EDO     18       4                                                       
HET    EDO     19       4                                                       
HET    EDO     20       4                                                       
HET    EDO     21       4                                                       
HET    GOL      1       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     GOL GLYCEROL                                                         
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  FMN    2(C17 H21 N4 O9 P)                                           
FORMUL   5  EDO    20(C2 H6 O2)                                                 
FORMUL  25  GOL    C3 H8 O3                                                     
FORMUL  26  HOH   *359(H2 O)                                                    
CRYST1   65.647   65.928  112.380  90.00  90.00  90.00 P 21 21 21    8          
HETATM    1  N   MSE A   1      -6.227  33.259  22.379  1.00 49.89           N  
HETATM    2  CA  MSE A   1      -7.235  34.008  21.560  1.00 48.25           C  
HETATM    3  C   MSE A   1      -6.611  35.276  20.984  1.00 45.22           C  
HETATM    4  O   MSE A   1      -6.812  35.590  19.805  1.00 50.28           O  
HETATM    5  CB  MSE A   1      -8.489  34.350  22.374  1.00 49.10           C  
ATOM      6  N   SER A   2      -5.869  36.020  21.795  1.00 35.95           N  
ATOM      7  CA  SER A   2      -5.046  37.085  21.225  1.00 31.21           C  
ATOM      8  C   SER A   2      -3.751  36.423  20.710  1.00 23.45           C  
ATOM      9  O   SER A   2      -3.323  35.379  21.228  1.00 20.56           O  
ATOM     10  CB  SER A   2      -4.758  38.191  22.225  1.00 34.13           C  
ATOM     11  OG  SER A   2      -3.762  37.829  23.144  1.00 40.99           O  
ATOM     12  N   LEU A   3      -3.198  36.996  19.652  1.00 20.63           N  
ATOM     13  CA  LEU A   3      -1.957  36.464  19.079  0.50 19.77           C  
ATOM     15  C   LEU A   3      -0.815  36.620  20.072  1.00 18.44           C  
ATOM     16  O   LEU A   3      -0.582  37.677  20.646  1.00 18.85           O  
ATOM     17  CB  LEU A   3      -1.611  37.150  17.737  0.50 22.46           C  
ATOM     19  CG  LEU A   3      -2.386  36.679  16.492  0.50 18.32           C  
ATOM     21  CD1 LEU A   3      -2.314  37.685  15.324  0.50 18.91           C  
ATOM     23  CD2 LEU A   3      -1.900  35.315  16.027  0.50 19.69           C  
ATOM     25  N   ALA A   4      -0.075  35.543  20.270  1.00 15.15           N  
ATOM     26  CA  ALA A   4       1.068  35.596  21.153  1.00 16.31           C  
ATOM     27  C   ALA A   4       2.125  36.497  20.539  1.00 15.65           C  
ATOM     28  O   ALA A   4       2.243  36.619  19.312  1.00 15.30           O  
ATOM     29  CB  ALA A   4       1.619  34.173  21.351  1.00 18.14           C  
ATOM     30  N   PRO A   5       2.941  37.146  21.378  1.00 16.77           N  
ATOM     31  CA  PRO A   5       3.854  38.180  20.910  1.00 17.79           C  
ATOM     32  C   PRO A   5       5.020  37.701  20.068  1.00 16.35           C  
ATOM     33  O   PRO A   5       5.712  38.511  19.474  1.00 18.15           O  
ATOM     34  CB  PRO A   5       4.365  38.791  22.230  1.00 18.98           C  
ATOM     35  CG  PRO A   5       4.216  37.735  23.221  1.00 20.71           C  
ATOM     36  CD  PRO A   5       2.918  37.080  22.853  1.00 19.33           C  
ATOM     37  N   TRP A   6       5.232  36.396  20.021  1.00 15.29           N  
ATOM     38  CA  TRP A   6       6.262  35.771  19.209  1.00 14.25           C  
ATOM     39  C   TRP A   6       5.720  35.284  17.874  1.00 14.16           C  
ATOM     40  O   TRP A   6       6.489  34.777  17.041  1.00 14.66           O  
ATOM     41  CB  TRP A   6       6.954  34.585  19.939  1.00 14.79           C  
ATOM     42  CG  TRP A   6       5.992  33.691  20.685  1.00 14.87           C  
ATOM     43  CD1 TRP A   6       5.713  33.750  22.002  1.00 15.85           C  
ATOM     44  CD2 TRP A   6       5.152  32.651  20.142  1.00 15.27           C  
ATOM     45  NE1 TRP A   6       4.771  32.831  22.325  1.00 15.33           N  
ATOM     46  CE2 TRP A   6       4.392  32.134  21.218  1.00 14.61           C  
ATOM     47  CE3 TRP A   6       4.988  32.085  18.875  1.00 15.97           C  
ATOM     48  CZ2 TRP A   6       3.477  31.083  21.048  1.00 16.43           C  
ATOM     49  CZ3 TRP A   6       4.071  31.073  18.695  1.00 16.80           C  
ATOM     50  CH2 TRP A   6       3.309  30.583  19.790  1.00 15.69           C  
ATOM     51  N   ARG A   7       4.424  35.488  17.626  1.00 13.42           N  
ATOM     52  CA  ARG A   7       3.849  35.008  16.379  1.00 12.19           C  
ATOM     53  C   ARG A   7       4.400  35.748  15.159  1.00 13.31           C  
ATOM     54  O   ARG A   7       4.627  35.122  14.112  1.00 14.64           O  
ATOM     55  CB  ARG A   7       2.325  35.059  16.388  1.00 13.74           C  
ATOM     56  CG  ARG A   7       1.700  33.998  17.254  1.00 14.12           C  
ATOM     57  CD  ARG A   7       1.686  32.667  16.628  1.00 15.16           C  
ATOM     58  NE  ARG A   7       0.908  32.508  15.387  1.00 13.37           N  
ATOM     59  CZ  ARG A   7      -0.380  32.169  15.351  1.00 14.22           C  
ATOM     60  NH1 ARG A   7      -1.080  32.028  16.464  1.00 15.51           N  
ATOM     61  NH2 ARG A   7      -0.987  31.951  14.192  1.00 17.69           N  
ATOM     62  N   GLY A   8       4.625  37.042  15.278  1.00 12.49           N  
ATOM     63  CA  GLY A   8       5.226  37.771  14.187  1.00 13.55           C  
ATOM     64  C   GLY A   8       6.618  37.299  13.843  1.00 14.01           C  
ATOM     65  O   GLY A   8       6.977  37.186  12.656  1.00 14.86           O  
ATOM     66  N   ALA A   9       7.397  36.966  14.873  1.00 14.88           N  
ATOM     67  CA  ALA A   9       8.761  36.464  14.680  1.00 14.54           C  
ATOM     68  C   ALA A   9       8.717  35.157  13.907  1.00 12.66           C  
ATOM     69  O   ALA A   9       9.526  34.907  12.964  1.00 13.24           O  
ATOM     70  CB  ALA A   9       9.495  36.296  16.039  1.00 17.42           C  
ATOM     71  N   ILE A  10       7.818  34.259  14.305  1.00 12.84           N  
ATOM     72  CA  ILE A  10       7.656  32.995  13.604  0.50 11.83           C  
ATOM     74  C   ILE A  10       7.245  33.217  12.145  1.00 13.99           C  
ATOM     75  O   ILE A  10       7.748  32.575  11.236  1.00 14.54           O  
ATOM     76  CB  ILE A  10       6.598  32.059  14.303  0.50 11.81           C  
ATOM     78  CG1 ILE A  10       7.285  31.445  15.543  0.50 13.37           C  
ATOM     80  CG2 ILE A  10       6.076  30.937  13.346  0.50  9.96           C  
ATOM     82  CD1 ILE A  10       8.280  30.362  15.231  0.50 11.74           C  
ATOM     84  N   ALA A  11       6.288  34.145  11.930  1.00 13.80           N  
ATOM     85  CA  ALA A  11       5.846  34.405  10.574  1.00 14.19           C  
ATOM     86  C   ALA A  11       6.987  34.905   9.713  1.00 14.17           C  
ATOM     87  O   ALA A  11       7.118  34.542   8.552  1.00 14.32           O  
ATOM     88  CB  ALA A  11       4.701  35.426  10.585  1.00 14.56           C  
ATOM     89  N   HIS A  12       7.811  35.771  10.282  1.00 12.77           N  
ATOM     90  CA  HIS A  12       8.968  36.348   9.531  1.00 12.23           C  
ATOM     91  C   HIS A  12      10.004  35.273   9.268  1.00 13.91           C  
ATOM     92  O   HIS A  12      10.648  35.301   8.209  1.00 14.57           O  
ATOM     93  CB  HIS A  12       9.532  37.528  10.319  1.00 13.79           C  
ATOM     94  CG  HIS A  12      10.529  38.343   9.557  1.00 13.27           C  
ATOM     95  ND1 HIS A  12      11.635  38.957  10.124  1.00 21.18           N  
ATOM     96  CD2 HIS A  12      10.452  38.808   8.293  1.00 11.19           C  
ATOM     97  CE1 HIS A  12      12.235  39.698   9.193  1.00 13.26           C  
ATOM     98  NE2 HIS A  12      11.535  39.607   8.078  1.00 17.64           N  
ATOM     99  N   ALA A  13      10.219  34.346  10.186  1.00 13.98           N  
ATOM    100  CA  ALA A  13      11.154  33.247   9.950  1.00 13.08           C  
ATOM    101  C   ALA A  13      10.630  32.318   8.864  1.00 13.66           C  
ATOM    102  O   ALA A  13      11.353  31.976   7.912  1.00 13.95           O  
ATOM    103  CB  ALA A  13      11.410  32.483  11.265  1.00 13.08           C  
ATOM    104  N   LEU A  14       9.349  31.961   8.955  1.00 12.54           N  
ATOM    105  CA  LEU A  14       8.776  31.065   7.941  1.00 14.17           C  
ATOM    106  C   LEU A  14       8.866  31.707   6.560  1.00 14.56           C  
ATOM    107  O   LEU A  14       9.273  31.072   5.580  1.00 15.45           O  
ATOM    108  CB  LEU A  14       7.307  30.762   8.269  1.00 14.45           C  
ATOM    109  CG  LEU A  14       7.115  29.780   9.415  1.00 15.71           C  
ATOM    110  CD1 LEU A  14       5.687  29.881   9.947  1.00 17.56           C  
ATOM    111  CD2 LEU A  14       7.464  28.345   8.968  1.00 16.11           C  
ATOM    112  N   HIS A  15       8.515  32.978   6.441  1.00 14.60           N  
ATOM    113  CA  HIS A  15       8.552  33.633   5.165  1.00 13.04           C  
ATOM    114  C   HIS A  15       9.957  33.681   4.563  1.00 13.03           C  
ATOM    115  O   HIS A  15      10.155  33.423   3.370  1.00 14.86           O  
ATOM    116  CB  HIS A  15       7.909  35.011   5.266  1.00 13.76           C  
ATOM    117  CG  HIS A  15       7.856  35.736   3.979  1.00 15.34           C  
ATOM    118  ND1 HIS A  15       7.115  35.271   2.911  1.00 16.55           N  
ATOM    119  CD2 HIS A  15       8.453  36.880   3.579  1.00 15.52           C  
ATOM    120  CE1 HIS A  15       7.280  36.115   1.892  1.00 18.15           C  
ATOM    121  NE2 HIS A  15       8.093  37.094   2.269  1.00 18.17           N  
ATOM    122  N   ARG A  16      10.944  34.038   5.375  1.00 14.13           N  
ATOM    123  CA  ARG A  16      12.300  34.211   4.881  1.00 13.52           C  
ATOM    124  C   ARG A  16      12.997  32.893   4.652  1.00 16.73           C  
ATOM    125  O   ARG A  16      14.065  32.873   4.038  1.00 19.78           O  
ATOM    126  CB  ARG A  16      13.110  35.072   5.829  1.00 14.37           C  
ATOM    127  CG  ARG A  16      12.725  36.509   5.836  1.00 13.67           C  
ATOM    128  CD  ARG A  16      13.629  37.311   6.712  1.00 15.08           C  
ATOM    129  NE  ARG A  16      13.483  36.833   8.073  1.00 19.17           N  
ATOM    130  CZ  ARG A  16      14.222  37.189   9.108  1.00 23.12           C  
ATOM    131  NH1 ARG A  16      15.161  38.097   8.993  1.00 20.81           N  
ATOM    132  NH2 ARG A  16      13.959  36.635  10.292  1.00 24.38           N  
ATOM    133  N   ASN A  17      12.389  31.800   5.064  1.00 14.39           N  
ATOM    134  CA  ASN A  17      12.910  30.449   4.826  1.00 15.94           C  
ATOM    135  C   ASN A  17      12.065  29.621   3.862  1.00 18.56           C  
ATOM    136  O   ASN A  17      12.273  28.414   3.738  1.00 17.77           O  
ATOM    137  CB  ASN A  17      13.130  29.695   6.148  1.00 15.87           C  
ATOM    138  CG  ASN A  17      14.276  30.238   6.936  1.00 16.62           C  
ATOM    139  OD1 ASN A  17      15.369  29.661   6.906  1.00 21.72           O  
ATOM    140  ND2 ASN A  17      14.082  31.333   7.640  1.00 15.32           N  
ATOM    141  N   ARG A  18      11.124  30.252   3.163  1.00 16.71           N  
ATOM    142  CA  ARG A  18      10.146  29.549   2.347  1.00 19.09           C  
ATOM    143  C   ARG A  18      10.793  28.798   1.164  1.00 18.23           C  
ATOM    144  O   ARG A  18      10.120  27.887   0.648  1.00 21.86           O  
ATOM    145  CB  ARG A  18       9.077  30.518   1.868  1.00 19.26           C  
ATOM    146  CG  ARG A  18       9.505  31.512   0.886  1.00 19.50           C  
ATOM    147  CD  ARG A  18       8.377  32.540   0.633  1.00 20.81           C  
ATOM    148  NE  ARG A  18       8.731  33.497  -0.386  1.00 22.90           N  
ATOM    149  CZ  ARG A  18       9.578  34.501  -0.262  1.00 24.30           C  
ATOM    150  NH1 ARG A  18      10.203  34.786   0.873  1.00 19.05           N  
ATOM    151  NH2 ARG A  18       9.791  35.294  -1.311  1.00 34.63           N  
ATOM    152  N   SER A  19      12.018  29.147   0.780  1.00 17.98           N  
ATOM    153  CA  SER A  19      12.712  28.466  -0.354  1.00 20.51           C  
ATOM    154  C   SER A  19      13.185  27.078   0.095  1.00 21.23           C  
ATOM    155  O   SER A  19      13.585  26.268  -0.756  1.00 22.89           O  
ATOM    156  CB  SER A  19      13.898  29.266  -0.846  1.00 19.44           C  
ATOM    157  OG  SER A  19      14.892  29.455   0.121  1.00 25.42           O  
ATOM    158  N   LEU A  20      13.215  26.829   1.407  1.00 19.62           N  
ATOM    159  CA  LEU A  20      13.693  25.540   1.950  1.00 18.99           C  
ATOM    160  C   LEU A  20      12.535  24.734   2.471  1.00 18.15           C  
ATOM    161  O   LEU A  20      11.928  25.094   3.501  1.00 19.39           O  
ATOM    162  CB  LEU A  20      14.694  25.774   3.040  1.00 19.07           C  
ATOM    163  CG  LEU A  20      15.858  26.717   2.763  1.00 20.77           C  
ATOM    164  CD1 LEU A  20      16.671  26.901   4.055  1.00 24.39           C  
ATOM    165  CD2 LEU A  20      16.749  26.223   1.611  1.00 22.63           C  
ATOM    166  N   VAL A  21      12.206  23.625   1.806  1.00 19.31           N  
ATOM    167  CA  VAL A  21      11.084  22.793   2.253  1.00 19.75           C  
ATOM    168  C   VAL A  21      11.246  22.381   3.724  1.00 17.74           C  
ATOM    169  O   VAL A  21      10.289  22.324   4.523  1.00 20.05           O  
ATOM    170  CB  VAL A  21      10.920  21.515   1.391  1.00 26.27           C  
ATOM    171  CG1 VAL A  21       9.841  20.563   1.991  1.00 30.90           C  
ATOM    172  CG2 VAL A  21      10.571  21.895  -0.043  1.00 29.93           C  
ATOM    173  N   TYR A  22      12.497  22.097   4.071  1.00 17.56           N  
ATOM    174  CA  TYR A  22      12.845  21.596   5.369  1.00 17.54           C  
ATOM    175  C   TYR A  22      12.886  22.619   6.514  1.00 16.64           C  
ATOM    176  O   TYR A  22      13.145  22.301   7.673  1.00 19.29           O  
ATOM    177  CB  TYR A  22      14.182  20.844   5.296  1.00 19.69           C  
ATOM    178  CG  TYR A  22      15.302  21.548   4.561  1.00 18.06           C  
ATOM    179  CD1 TYR A  22      16.149  22.389   5.239  1.00 16.88           C  
ATOM    180  CD2 TYR A  22      15.540  21.314   3.214  1.00 18.26           C  
ATOM    181  CE1 TYR A  22      17.178  22.990   4.604  1.00 16.95           C  
ATOM    182  CE2 TYR A  22      16.618  21.854   2.581  1.00 16.89           C  
ATOM    183  CZ  TYR A  22      17.430  22.709   3.257  1.00 17.47           C  
ATOM    184  OH  TYR A  22      18.516  23.280   2.588  1.00 19.37           O  
ATOM    185  N   ALA A  23      12.639  23.873   6.198  1.00 16.10           N  
ATOM    186  CA  ALA A  23      12.516  24.882   7.247  1.00 17.38           C  
ATOM    187  C   ALA A  23      11.218  24.677   8.031  1.00 16.78           C  
ATOM    188  O   ALA A  23      11.057  25.292   9.064  1.00 19.10           O  
ATOM    189  CB  ALA A  23      12.544  26.264   6.663  1.00 20.70           C  
ATOM    190  N   ARG A  24      10.308  23.831   7.541  1.00 16.12           N  
ATOM    191  CA  ARG A  24       9.107  23.460   8.286  1.00 16.50           C  
ATOM    192  C   ARG A  24       9.312  22.171   9.085  1.00 15.58           C  
ATOM    193  O   ARG A  24       8.357  21.668   9.686  1.00 18.28           O  
ATOM    194  CB  ARG A  24       7.910  23.405   7.396  1.00 21.85           C  
ATOM    195  CG  ARG A  24       7.580  24.866   6.902  1.00 26.06           C  
ATOM    196  CD  ARG A  24       6.525  24.900   5.866  1.00 33.43           C  
ATOM    197  NE  ARG A  24       5.274  24.470   6.455  1.00 31.94           N  
ATOM    198  CZ  ARG A  24       4.310  25.270   6.922  1.00 34.90           C  
ATOM    199  NH1 ARG A  24       4.409  26.595   6.856  1.00 30.55           N  
ATOM    200  NH2 ARG A  24       3.214  24.720   7.451  1.00 35.97           N  
ATOM    201  N   TYR A  25      10.541  21.695   9.196  1.00 14.72           N  
ATOM    202  CA  TYR A  25      10.831  20.519   9.992  1.00 14.80           C  
ATOM    203  C   TYR A  25      11.430  20.971  11.317  1.00 16.03           C  
ATOM    204  O   TYR A  25      12.291  21.875  11.368  1.00 17.77           O  
ATOM    205  CB  TYR A  25      11.830  19.608   9.299  1.00 15.18           C  
ATOM    206  CG  TYR A  25      11.450  19.095   7.955  1.00 14.89           C  
ATOM    207  CD1 TYR A  25      10.165  19.144   7.490  1.00 17.04           C  
ATOM    208  CD2 TYR A  25      12.425  18.573   7.130  1.00 16.60           C  
ATOM    209  CE1 TYR A  25       9.861  18.684   6.190  1.00 20.36           C  
ATOM    210  CE2 TYR A  25      12.144  18.119   5.887  1.00 16.60           C  
ATOM    211  CZ  TYR A  25      10.877  18.168   5.425  1.00 18.93           C  
ATOM    212  OH  TYR A  25      10.583  17.705   4.127  1.00 21.86           O  
ATOM    213  N   LEU A  26      10.977  20.394  12.420  1.00 14.58           N  
ATOM    214  CA  LEU A  26      11.445  20.802  13.731  1.00 13.59           C  
ATOM    215  C   LEU A  26      11.589  19.565  14.607  1.00 14.70           C  
ATOM    216  O   LEU A  26      11.074  18.476  14.283  1.00 14.33           O  
ATOM    217  CB  LEU A  26      10.528  21.859  14.340  1.00 15.24           C  
ATOM    218  CG  LEU A  26       9.048  21.519  14.509  1.00 14.81           C  
ATOM    219  CD1 LEU A  26       8.865  20.524  15.678  1.00 16.29           C  
ATOM    220  CD2 LEU A  26       8.192  22.833  14.745  1.00 16.23           C  
ATOM    221  N   GLN A  27      12.266  19.689  15.731  1.00 14.53           N  
ATOM    222  CA  GLN A  27      12.548  18.558  16.606  1.00 13.88           C  
ATOM    223  C   GLN A  27      11.754  18.626  17.887  1.00 14.70           C  
ATOM    224  O   GLN A  27      11.848  19.646  18.622  1.00 16.13           O  
ATOM    225  CB  GLN A  27      14.055  18.444  16.872  1.00 15.01           C  
ATOM    226  CG  GLN A  27      14.857  18.032  15.647  1.00 14.02           C  
ATOM    227  CD  GLN A  27      14.943  19.049  14.562  1.00 16.50           C  
ATOM    228  OE1 GLN A  27      15.115  20.253  14.837  1.00 16.84           O  
ATOM    229  NE2 GLN A  27      14.779  18.608  13.295  1.00 17.08           N  
ATOM    230  N   LEU A  28      11.016  17.560  18.180  1.00 13.59           N  
ATOM    231  CA  LEU A  28      10.179  17.540  19.379  1.00 14.39           C  
ATOM    232  C   LEU A  28      10.800  16.602  20.392  1.00 13.58           C  
ATOM    233  O   LEU A  28      10.950  15.376  20.167  1.00 14.94           O  
ATOM    234  CB  LEU A  28       8.799  16.988  19.038  1.00 16.96           C  
ATOM    235  CG  LEU A  28       7.880  16.705  20.254  1.00 17.48           C  
ATOM    236  CD1 LEU A  28       7.277  18.005  20.629  1.00 26.65           C  
ATOM    237  CD2 LEU A  28       6.832  15.610  19.932  1.00 22.13           C  
ATOM    238  N   ALA A  29      11.125  17.159  21.571  1.00 12.61           N  
ATOM    239  CA  ALA A  29      11.658  16.378  22.667  1.00 12.98           C  
ATOM    240  C   ALA A  29      10.564  16.089  23.677  1.00 15.20           C  
ATOM    241  O   ALA A  29       9.840  16.976  24.103  1.00 15.38           O  
ATOM    242  CB  ALA A  29      12.815  17.163  23.381  1.00 16.09           C  
ATOM    243  N   THR A  30      10.511  14.838  24.107  1.00 13.90           N  
ATOM    244  CA  THR A  30       9.630  14.381  25.149  1.00 16.10           C  
ATOM    245  C   THR A  30      10.456  13.621  26.187  1.00 16.67           C  
ATOM    246  O   THR A  30      11.684  13.474  26.031  1.00 14.74           O  
ATOM    247  CB  THR A  30       8.568  13.390  24.559  1.00 14.92           C  
ATOM    248  OG1 THR A  30       9.251  12.335  23.825  1.00 16.29           O  
ATOM    249  CG2 THR A  30       7.551  14.082  23.688  1.00 16.82           C  
ATOM    250  N   VAL A  31       9.811  13.188  27.280  1.00 16.55           N  
ATOM    251  CA  VAL A  31      10.475  12.373  28.292  1.00 16.89           C  
ATOM    252  C   VAL A  31       9.784  11.016  28.322  1.00 16.11           C  
ATOM    253  O   VAL A  31       8.522  10.908  28.262  1.00 19.16           O  
ATOM    254  CB  VAL A  31      10.497  13.050  29.699  1.00 20.08           C  
ATOM    255  CG1 VAL A  31      11.346  12.247  30.718  1.00 20.53           C  
ATOM    256  CG2 VAL A  31      11.101  14.405  29.630  1.00 26.32           C  
ATOM    257  N   GLN A  32      10.594   9.956  28.375  1.00 16.16           N  
ATOM    258  CA  GLN A  32      10.077   8.600  28.467  1.00 19.54           C  
ATOM    259  C   GLN A  32       9.656   8.285  29.912  1.00 18.73           C  
ATOM    260  O   GLN A  32      10.097   8.940  30.849  1.00 19.26           O  
ATOM    261  CB  GLN A  32      11.129   7.612  27.983  1.00 19.56           C  
ATOM    262  CG  GLN A  32      11.575   7.886  26.555  1.00 21.46           C  
ATOM    263  CD  GLN A  32      12.746   7.027  26.129  1.00 26.37           C  
ATOM    264  OE1 GLN A  32      12.642   5.783  26.053  1.00 32.11           O  
ATOM    265  NE2 GLN A  32      13.882   7.661  25.898  1.00 22.18           N  
ATOM    266  N   PRO A  33       8.788   7.280  30.091  1.00 19.66           N  
ATOM    267  CA  PRO A  33       8.458   6.807  31.436  1.00 23.31           C  
ATOM    268  C   PRO A  33       9.687   6.497  32.296  1.00 23.68           C  
ATOM    269  O   PRO A  33       9.646   6.667  33.527  1.00 25.27           O  
ATOM    270  CB  PRO A  33       7.632   5.542  31.177  1.00 23.67           C  
ATOM    271  CG  PRO A  33       7.019   5.768  29.823  1.00 24.37           C  
ATOM    272  CD  PRO A  33       7.987   6.614  29.045  1.00 21.34           C  
ATOM    273  N   ASN A  34      10.767   6.026  31.680  1.00 22.45           N  
ATOM    274  CA  ASN A  34      11.985   5.729  32.434  1.00 22.63           C  
ATOM    275  C   ASN A  34      12.836   6.975  32.782  1.00 23.67           C  
ATOM    276  O   ASN A  34      13.895   6.849  33.400  1.00 23.04           O  
ATOM    277  CB  ASN A  34      12.854   4.680  31.711  1.00 24.32           C  
ATOM    278  CG  ASN A  34      13.435   5.190  30.398  1.00 28.59           C  
ATOM    279  OD1 ASN A  34      13.353   6.383  30.072  1.00 21.32           O  
ATOM    280  ND2 ASN A  34      14.035   4.278  29.635  1.00 32.33           N  
ATOM    281  N   GLY A  35      12.370   8.164  32.400  1.00 20.19           N  
ATOM    282  CA  GLY A  35      13.019   9.414  32.782  1.00 20.35           C  
ATOM    283  C   GLY A  35      14.001   9.943  31.725  1.00 18.93           C  
ATOM    284  O   GLY A  35      14.567  11.013  31.866  1.00 21.91           O  
ATOM    285  N   ARG A  36      14.265   9.152  30.706  1.00 17.21           N  
ATOM    286  CA  ARG A  36      15.239   9.569  29.682  1.00 16.31           C  
ATOM    287  C   ARG A  36      14.523  10.395  28.594  1.00 15.67           C  
ATOM    288  O   ARG A  36      13.364  10.171  28.279  1.00 15.75           O  
ATOM    289  CB  ARG A  36      15.874   8.350  29.028  1.00 15.94           C  
ATOM    290  CG  ARG A  36      16.751   7.530  30.005  1.00 17.26           C  
ATOM    291  CD  ARG A  36      17.257   6.278  29.315  1.00 24.85           C  
ATOM    292  NE  ARG A  36      18.240   5.616  30.195  1.00 30.70           N  
ATOM    293  CZ  ARG A  36      18.837   4.447  29.961  1.00 37.26           C  
ATOM    294  NH1 ARG A  36      18.574   3.734  28.870  1.00 36.55           N  
ATOM    295  NH2 ARG A  36      19.712   3.991  30.844  1.00 40.33           N  
ATOM    296  N   PRO A  37      15.234  11.324  27.949  1.00 14.94           N  
ATOM    297  CA  PRO A  37      14.652  12.140  26.879  1.00 14.78           C  
ATOM    298  C   PRO A  37      14.523  11.328  25.601  1.00 17.32           C  
ATOM    299  O   PRO A  37      15.174  10.293  25.407  1.00 17.62           O  
ATOM    300  CB  PRO A  37      15.689  13.238  26.704  1.00 15.70           C  
ATOM    301  CG  PRO A  37      16.955  12.570  27.072  1.00 18.20           C  
ATOM    302  CD  PRO A  37      16.654  11.648  28.177  1.00 17.81           C  
ATOM    303  N   ALA A  38      13.678  11.837  24.716  1.00 14.69           N  
ATOM    304  CA  ALA A  38      13.499  11.325  23.344  1.00 16.00           C  
ATOM    305  C   ALA A  38      13.350  12.536  22.457  1.00 15.89           C  
ATOM    306  O   ALA A  38      12.852  13.566  22.881  1.00 17.27           O  
ATOM    307  CB  ALA A  38      12.265  10.394  23.216  1.00 17.46           C  
ATOM    308  N   ASN A  39      13.814  12.422  21.239  1.00 12.94           N  
ATOM    309  CA  ASN A  39      13.888  13.572  20.345  1.00 13.35           C  
ATOM    310  C   ASN A  39      13.754  13.101  18.906  1.00 14.81           C  
ATOM    311  O   ASN A  39      14.503  12.241  18.487  1.00 16.07           O  
ATOM    312  CB  ASN A  39      15.243  14.232  20.567  1.00 14.40           C  
ATOM    313  CG  ASN A  39      15.311  15.687  20.104  1.00 16.91           C  
ATOM    314  OD1 ASN A  39      14.300  16.296  19.742  1.00 16.64           O  
ATOM    315  ND2 ASN A  39      16.561  16.265  20.158  1.00 17.16           N  
ATOM    316  N   ARG A  40      12.825  13.693  18.156  1.00 13.29           N  
ATOM    317  CA  ARG A  40      12.649  13.322  16.734  1.00 13.53           C  
ATOM    318  C   ARG A  40      12.089  14.456  15.944  1.00 13.01           C  
ATOM    319  O   ARG A  40      11.426  15.341  16.482  1.00 14.64           O  
ATOM    320  CB  ARG A  40      11.765  12.093  16.582  1.00 14.98           C  
ATOM    321  CG  ARG A  40      10.304  12.331  16.680  1.00 14.45           C  
ATOM    322  CD  ARG A  40       9.809  12.652  18.079  1.00 14.32           C  
ATOM    323  NE  ARG A  40       9.877  11.541  19.009  1.00 14.18           N  
ATOM    324  CZ  ARG A  40       9.753  11.588  20.333  1.00 13.73           C  
ATOM    325  NH1 ARG A  40       9.784  12.748  21.013  1.00 16.14           N  
ATOM    326  NH2 ARG A  40       9.669  10.466  20.992  1.00 17.41           N  
ATOM    327  N   THR A  41      12.302  14.397  14.632  1.00 13.52           N  
ATOM    328  CA  THR A  41      11.819  15.407  13.733  1.00 13.52           C  
ATOM    329  C   THR A  41      10.345  15.184  13.396  1.00 15.19           C  
ATOM    330  O   THR A  41       9.933  14.019  13.178  1.00 14.27           O  
ATOM    331  CB  THR A  41      12.653  15.429  12.436  1.00 15.18           C  
ATOM    332  OG1 THR A  41      14.037  15.647  12.777  1.00 16.01           O  
ATOM    333  CG2 THR A  41      12.202  16.545  11.475  1.00 15.59           C  
ATOM    334  N   LEU A  42       9.588  16.280  13.342  1.00 15.31           N  
ATOM    335  CA  LEU A  42       8.237  16.278  12.838  1.00 14.88           C  
ATOM    336  C   LEU A  42       8.088  17.396  11.837  1.00 15.71           C  
ATOM    337  O   LEU A  42       8.863  18.340  11.831  1.00 16.09           O  
ATOM    338  CB  LEU A  42       7.213  16.572  13.931  1.00 15.35           C  
ATOM    339  CG  LEU A  42       7.329  15.770  15.216  1.00 21.87           C  
ATOM    340  CD1 LEU A  42       6.332  16.330  16.283  1.00 22.20           C  
ATOM    341  CD2 LEU A  42       7.087  14.378  14.860  1.00 21.42           C  
ATOM    342  N   VAL A  43       7.068  17.337  10.981  1.00 15.60           N  
ATOM    343  CA  VAL A  43       6.679  18.457  10.114  1.00 15.54           C  
ATOM    344  C   VAL A  43       5.701  19.383  10.798  1.00 15.44           C  
ATOM    345  O   VAL A  43       4.660  18.925  11.296  1.00 15.79           O  
ATOM    346  CB  VAL A  43       5.991  17.903   8.842  1.00 15.63           C  
ATOM    347  CG1 VAL A  43       5.538  19.068   7.899  1.00 19.86           C  
ATOM    348  CG2 VAL A  43       6.929  16.927   8.094  1.00 19.44           C  
ATOM    349  N   PHE A  44       6.011  20.677  10.864  1.00 14.99           N  
ATOM    350  CA  PHE A  44       5.073  21.676  11.329  1.00 13.80           C  
ATOM    351  C   PHE A  44       3.954  21.819  10.297  1.00 14.07           C  
ATOM    352  O   PHE A  44       4.197  22.049   9.127  1.00 15.64           O  
ATOM    353  CB  PHE A  44       5.821  23.001  11.435  1.00 16.55           C  
ATOM    354  CG  PHE A  44       4.948  24.195  11.666  1.00 13.58           C  
ATOM    355  CD1 PHE A  44       4.286  24.359  12.881  1.00 15.85           C  
ATOM    356  CD2 PHE A  44       4.813  25.157  10.696  1.00 17.47           C  
ATOM    357  CE1 PHE A  44       3.503  25.485  13.077  1.00 16.76           C  
ATOM    358  CE2 PHE A  44       4.053  26.281  10.905  1.00 17.14           C  
ATOM    359  CZ  PHE A  44       3.423  26.448  12.092  1.00 14.95           C  
ATOM    360  N   ARG A  45       2.727  21.731  10.796  1.00 14.89           N  
ATOM    361  CA  ARG A  45       1.535  21.778   9.950  0.50 16.15           C  
ATOM    363  C   ARG A  45       0.650  22.984  10.239  1.00 18.59           C  
ATOM    364  O   ARG A  45      -0.588  22.894  10.159  1.00 17.82           O  
ATOM    365  CB  ARG A  45       0.755  20.477  10.101  0.50 15.91           C  
ATOM    367  CG  ARG A  45       1.656  19.258   9.902  0.50 21.59           C  
ATOM    369  CD  ARG A  45       1.005  18.111   9.256  0.50 22.23           C  
ATOM    371  NE  ARG A  45       1.936  17.095   8.750  0.50 13.34           N  
ATOM    373  CZ  ARG A  45       2.082  16.791   7.450  0.50 13.00           C  
ATOM    375  NH1 ARG A  45       1.438  17.464   6.519  0.50 16.65           N  
ATOM    377  NH2 ARG A  45       2.928  15.851   7.067  0.50 20.19           N  
ATOM    379  N   GLY A  46       1.253  24.118  10.599  1.00 16.15           N  
ATOM    380  CA  GLY A  46       0.524  25.337  10.839  1.00 15.71           C  
ATOM    381  C   GLY A  46       0.011  25.483  12.257  1.00 15.83           C  
ATOM    382  O   GLY A  46       0.083  24.576  13.061  1.00 18.95           O  
ATOM    383  N   PHE A  47      -0.491  26.661  12.578  1.00 15.48           N  
ATOM    384  CA  PHE A  47      -1.233  26.896  13.798  1.00 14.10           C  
ATOM    385  C   PHE A  47      -2.701  26.514  13.659  1.00 16.79           C  
ATOM    386  O   PHE A  47      -3.297  26.682  12.601  1.00 18.39           O  
ATOM    387  CB  PHE A  47      -1.118  28.363  14.167  1.00 15.69           C  
ATOM    388  CG  PHE A  47       0.305  28.756  14.587  1.00 15.01           C  
ATOM    389  CD1 PHE A  47       0.732  28.594  15.898  1.00 16.88           C  
ATOM    390  CD2 PHE A  47       1.200  29.227  13.639  1.00 15.59           C  
ATOM    391  CE1 PHE A  47       2.049  28.928  16.271  1.00 17.41           C  
ATOM    392  CE2 PHE A  47       2.511  29.525  14.001  1.00 16.24           C  
ATOM    393  CZ  PHE A  47       2.924  29.348  15.293  1.00 15.51           C  
ATOM    394  N   LEU A  48      -3.269  26.081  14.772  1.00 17.06           N  
ATOM    395  CA  LEU A  48      -4.683  25.776  14.836  1.00 16.49           C  
ATOM    396  C   LEU A  48      -5.389  27.107  14.824  1.00 17.25           C  
ATOM    397  O   LEU A  48      -5.046  28.015  15.564  1.00 16.66           O  
ATOM    398  CB  LEU A  48      -4.986  25.007  16.104  1.00 16.02           C  
ATOM    399  CG  LEU A  48      -6.432  24.679  16.352  1.00 18.34           C  
ATOM    400  CD1 LEU A  48      -6.976  23.770  15.218  1.00 21.93           C  
ATOM    401  CD2 LEU A  48      -6.520  24.036  17.724  1.00 19.75           C  
ATOM    402  N   GLU A  49      -6.425  27.211  14.013  1.00 18.79           N  
ATOM    403  CA  GLU A  49      -7.095  28.482  13.797  0.50 20.70           C  
ATOM    405  C   GLU A  49      -7.619  29.059  15.107  1.00 20.20           C  
ATOM    406  O   GLU A  49      -8.118  28.325  15.995  1.00 19.58           O  
ATOM    407  CB  GLU A  49      -8.222  28.332  12.782  0.50 22.96           C  
ATOM    409  CG  GLU A  49      -9.234  27.303  13.174  0.50 21.42           C  
ATOM    411  N   ASP A  50      -7.475  30.375  15.242  1.00 21.46           N  
ATOM    412  CA  ASP A  50      -7.879  31.088  16.412  1.00 24.58           C  
ATOM    413  C   ASP A  50      -7.191  30.699  17.704  1.00 20.32           C  
ATOM    414  O   ASP A  50      -7.684  30.992  18.804  1.00 22.68           O  
ATOM    415  CB  ASP A  50      -9.397  31.038  16.582  1.00 26.61           C  
ATOM    416  CG  ASP A  50     -10.021  32.379  16.290  1.00 43.68           C  
ATOM    417  OD1 ASP A  50      -9.758  32.933  15.183  1.00 47.70           O  
ATOM    418  OD2 ASP A  50     -10.713  32.894  17.193  1.00 59.24           O  
ATOM    419  N   THR A  51      -6.005  30.090  17.585  1.00 17.29           N  
ATOM    420  CA  THR A  51      -5.214  29.765  18.748  1.00 16.13           C  
ATOM    421  C   THR A  51      -3.740  30.016  18.422  1.00 16.31           C  
ATOM    422  O   THR A  51      -3.386  30.298  17.260  1.00 17.43           O  
ATOM    423  CB  THR A  51      -5.308  28.292  19.141  1.00 19.51           C  
ATOM    424  OG1 THR A  51      -4.501  27.507  18.287  1.00 18.95           O  
ATOM    425  CG2 THR A  51      -6.801  27.753  19.104  1.00 18.29           C  
ATOM    426  N   ASN A  52      -2.908  29.874  19.450  1.00 16.96           N  
ATOM    427  CA  ASN A  52      -1.442  29.882  19.332  1.00 15.36           C  
ATOM    428  C   ASN A  52      -0.839  28.461  19.417  1.00 15.20           C  
ATOM    429  O   ASN A  52       0.386  28.282  19.583  1.00 16.44           O  
ATOM    430  CB  ASN A  52      -0.826  30.783  20.397  1.00 17.06           C  
ATOM    431  CG  ASN A  52      -1.210  32.216  20.224  1.00 18.02           C  
ATOM    432  OD1 ASN A  52      -0.892  32.836  19.215  1.00 15.64           O  
ATOM    433  ND2 ASN A  52      -1.985  32.753  21.187  1.00 18.99           N  
ATOM    434  N   GLN A  53      -1.666  27.445  19.217  1.00 14.10           N  
ATOM    435  CA  GLN A  53      -1.203  26.057  19.212  1.00 15.85           C  
ATOM    436  C   GLN A  53      -0.648  25.650  17.878  1.00 14.38           C  
ATOM    437  O   GLN A  53      -1.204  25.924  16.828  1.00 15.56           O  
ATOM    438  CB  GLN A  53      -2.305  25.117  19.614  1.00 17.41           C  
ATOM    439  CG  GLN A  53      -2.822  25.461  20.993  1.00 18.01           C  
ATOM    440  CD  GLN A  53      -3.326  24.249  21.768  1.00 24.87           C  
ATOM    441  OE1 GLN A  53      -2.598  23.306  21.953  1.00 25.88           O  
ATOM    442  NE2 GLN A  53      -4.516  24.342  22.319  1.00 31.93           N  
ATOM    443  N   LEU A  54       0.463  24.936  17.922  1.00 14.79           N  
ATOM    444  CA  LEU A  54       1.064  24.345  16.700  1.00 14.63           C  
ATOM    445  C   LEU A  54       0.519  22.946  16.450  1.00 14.74           C  
ATOM    446  O   LEU A  54       0.368  22.170  17.420  1.00 15.15           O  
ATOM    447  CB  LEU A  54       2.590  24.222  16.877  1.00 14.97           C  
ATOM    448  CG  LEU A  54       3.383  25.515  17.021  1.00 16.33           C  
ATOM    449  CD1 LEU A  54       3.241  26.210  18.421  1.00 15.80           C  
ATOM    450  CD2 LEU A  54       4.859  25.148  16.797  1.00 19.08           C  
ATOM    451  N   ARG A  55       0.265  22.636  15.178  1.00 14.65           N  
ATOM    452  CA  ARG A  55      -0.276  21.346  14.722  1.00 14.71           C  
ATOM    453  C   ARG A  55       0.785  20.450  14.152  1.00 14.68           C  
ATOM    454  O   ARG A  55       1.623  20.866  13.338  1.00 14.20           O  
ATOM    455  CB  ARG A  55      -1.333  21.556  13.615  1.00 15.18           C  
ATOM    456  CG  ARG A  55      -2.467  22.384  13.976  1.00 16.56           C  
ATOM    457  CD  ARG A  55      -3.581  22.265  12.925  1.00 14.37           C  
ATOM    458  NE  ARG A  55      -3.137  22.633  11.593  1.00 16.47           N  
ATOM    459  CZ  ARG A  55      -3.852  22.494  10.481  1.00 17.65           C  
ATOM    460  NH1 ARG A  55      -5.117  22.028  10.500  1.00 17.43           N  
ATOM    461  NH2 ARG A  55      -3.300  22.805   9.315  1.00 20.80           N  
ATOM    462  N   PHE A  56       0.704  19.160  14.543  1.00 14.68           N  
ATOM    463  CA  PHE A  56       1.492  18.091  13.970  1.00 14.44           C  
ATOM    464  C   PHE A  56       0.558  16.873  13.850  1.00 15.55           C  
ATOM    465  O   PHE A  56      -0.527  16.856  14.467  1.00 15.71           O  
ATOM    466  CB  PHE A  56       2.627  17.721  14.911  1.00 15.92           C  
ATOM    467  CG  PHE A  56       3.442  18.898  15.342  1.00 14.15           C  
ATOM    468  CD1 PHE A  56       4.475  19.323  14.563  1.00 17.02           C  
ATOM    469  CD2 PHE A  56       3.151  19.564  16.492  1.00 18.74           C  
ATOM    470  CE1 PHE A  56       5.210  20.433  14.932  1.00 16.62           C  
ATOM    471  CE2 PHE A  56       3.894  20.649  16.907  1.00 19.28           C  
ATOM    472  CZ  PHE A  56       4.935  21.083  16.087  1.00 15.61           C  
ATOM    473  N   ILE A  57       1.015  15.869  13.121  1.00 15.25           N  
ATOM    474  CA  ILE A  57       0.343  14.576  13.066  1.00 14.32           C  
ATOM    475  C   ILE A  57       1.302  13.498  13.503  1.00 16.00           C  
ATOM    476  O   ILE A  57       2.538  13.648  13.363  1.00 16.01           O  
ATOM    477  CB  ILE A  57      -0.219  14.285  11.657  1.00 14.08           C  
ATOM    478  CG1 ILE A  57       0.869  13.984  10.637  1.00 16.48           C  
ATOM    479  CG2 ILE A  57      -1.165  15.397  11.247  1.00 15.99           C  
ATOM    480  CD1 ILE A  57       0.381  13.683   9.184  1.00 18.22           C  
ATOM    481  N   THR A  58       0.742  12.417  14.017  1.00 14.57           N  
ATOM    482  CA  THR A  58       1.539  11.254  14.399  1.00 14.84           C  
ATOM    483  C   THR A  58       0.654  10.035  14.442  1.00 15.34           C  
ATOM    484  O   THR A  58      -0.577  10.142  14.435  1.00 15.49           O  
ATOM    485  CB  THR A  58       2.329  11.474  15.694  1.00 18.09           C  
ATOM    486  OG1 THR A  58       3.449  10.580  15.747  1.00 22.08           O  
ATOM    487  CG2 THR A  58       1.436  11.328  16.922  1.00 19.35           C  
ATOM    488  N   ASP A  59       1.280   8.873  14.461  1.00 15.89           N  
ATOM    489  CA  ASP A  59       0.586   7.592  14.506  1.00 15.84           C  
ATOM    490  C   ASP A  59       0.412   7.135  15.957  1.00 16.30           C  
ATOM    491  O   ASP A  59       1.359   7.207  16.753  1.00 17.12           O  
ATOM    492  CB  ASP A  59       1.425   6.584  13.709  1.00 16.30           C  
ATOM    493  CG  ASP A  59       0.690   5.329  13.336  1.00 19.39           C  
ATOM    494  OD1 ASP A  59       0.113   4.651  14.201  1.00 15.98           O  
ATOM    495  OD2 ASP A  59       0.701   5.029  12.125  1.00 22.71           O  
ATOM    496  N   THR A  60      -0.782   6.644  16.323  1.00 16.43           N  
ATOM    497  CA  THR A  60      -1.027   6.146  17.687  1.00 16.11           C  
ATOM    498  C   THR A  60      -0.103   4.981  18.028  1.00 17.95           C  
ATOM    499  O   THR A  60       0.099   4.683  19.216  1.00 18.08           O  
ATOM    500  CB  THR A  60      -2.472   5.625  17.925  1.00 20.46           C  
ATOM    501  OG1 THR A  60      -2.722   4.558  17.011  1.00 20.81           O  
ATOM    502  CG2 THR A  60      -3.511   6.706  17.705  1.00 26.22           C  
ATOM    503  N   ARG A  61       0.404   4.278  17.018  1.00 16.04           N  
ATOM    504  CA  ARG A  61       1.269   3.109  17.225  1.00 16.91           C  
ATOM    505  C   ARG A  61       2.700   3.503  17.515  1.00 17.23           C  
ATOM    506  O   ARG A  61       3.501   2.643  17.896  1.00 18.45           O  
ATOM    507  CB  ARG A  61       1.260   2.224  15.967  1.00 16.32           C  
ATOM    508  CG  ARG A  61      -0.116   1.650  15.679  1.00 16.65           C  
ATOM    509  CD  ARG A  61      -0.170   0.928  14.339  1.00 17.09           C  
ATOM    510  NE  ARG A  61       0.167   1.794  13.234  1.00 17.79           N  
ATOM    511  CZ  ARG A  61       0.462   1.392  12.003  1.00 18.29           C  
ATOM    512  NH1 ARG A  61       0.400   0.099  11.683  1.00 20.36           N  
ATOM    513  NH2 ARG A  61       0.804   2.279  11.075  1.00 19.45           N  
ATOM    514  N   SER A  62       3.043   4.773  17.322  1.00 14.48           N  
ATOM    515  CA  SER A  62       4.428   5.197  17.570  1.00 16.72           C  
ATOM    516  C   SER A  62       4.744   5.320  19.076  1.00 16.72           C  
ATOM    517  O   SER A  62       3.883   5.494  19.946  1.00 17.91           O  
ATOM    518  CB  SER A  62       4.726   6.485  16.856  1.00 19.26           C  
ATOM    519  OG  SER A  62       4.021   7.540  17.445  1.00 19.00           O  
ATOM    520  N   ALA A  63       6.038   5.191  19.403  1.00 17.52           N  
ATOM    521  CA  ALA A  63       6.452   5.292  20.775  1.00 15.71           C  
ATOM    522  C   ALA A  63       6.081   6.605  21.443  1.00 15.26           C  
ATOM    523  O   ALA A  63       5.766   6.625  22.652  1.00 18.44           O  
ATOM    524  CB  ALA A  63       7.971   5.110  20.870  1.00 18.73           C  
ATOM    525  N   LYS A  64       6.132   7.698  20.687  1.00 16.22           N  
ATOM    526  CA  LYS A  64       5.919   9.002  21.281  1.00 16.78           C  
ATOM    527  C   LYS A  64       4.483   9.084  21.796  1.00 19.59           C  
ATOM    528  O   LYS A  64       4.210   9.824  22.708  1.00 18.22           O  
ATOM    529  CB  LYS A  64       6.180  10.140  20.314  1.00 17.15           C  
ATOM    530  CG  LYS A  64       5.064  10.423  19.276  1.00 15.13           C  
ATOM    531  CD  LYS A  64       5.456  11.472  18.268  1.00 17.29           C  
ATOM    532  CE  LYS A  64       6.392  10.972  17.207  1.00 17.18           C  
ATOM    533  NZ  LYS A  64       6.007   9.651  16.550  1.00 17.49           N  
ATOM    534  N   ALA A  65       3.558   8.342  21.176  1.00 19.83           N  
ATOM    535  CA  ALA A  65       2.145   8.418  21.629  1.00 21.01           C  
ATOM    536  C   ALA A  65       2.020   8.062  23.094  1.00 21.96           C  
ATOM    537  O   ALA A  65       1.405   8.806  23.861  1.00 21.14           O  
ATOM    538  CB  ALA A  65       1.215   7.557  20.741  1.00 23.26           C  
ATOM    539  N   ASP A  66       2.632   6.961  23.511  1.00 21.63           N  
ATOM    540  CA  ASP A  66       2.532   6.582  24.908  1.00 21.26           C  
ATOM    541  C   ASP A  66       3.336   7.514  25.796  1.00 21.95           C  
ATOM    542  O   ASP A  66       2.958   7.828  26.921  1.00 21.06           O  
ATOM    543  CB  ASP A  66       3.014   5.159  25.151  1.00 23.71           C  
ATOM    544  CG  ASP A  66       2.770   4.726  26.566  1.00 33.65           C  
ATOM    545  OD1 ASP A  66       1.579   4.615  26.944  1.00 44.48           O  
ATOM    546  OD2 ASP A  66       3.756   4.555  27.317  1.00 45.05           O  
ATOM    547  N   GLN A  67       4.466   7.998  25.284  1.00 19.08           N  
ATOM    548  CA  GLN A  67       5.274   8.921  26.089  1.00 18.35           C  
ATOM    549  C   GLN A  67       4.443  10.170  26.395  1.00 18.97           C  
ATOM    550  O   GLN A  67       4.460  10.669  27.516  1.00 19.62           O  
ATOM    551  CB  GLN A  67       6.553   9.351  25.362  1.00 18.19           C  
ATOM    552  CG  GLN A  67       7.547   8.186  25.052  1.00 15.55           C  
ATOM    553  CD  GLN A  67       8.606   8.545  24.051  1.00 16.12           C  
ATOM    554  OE1 GLN A  67       8.782   9.711  23.685  1.00 17.49           O  
ATOM    555  NE2 GLN A  67       9.337   7.533  23.588  1.00 17.90           N  
ATOM    556  N   ILE A  68       3.743  10.680  25.394  1.00 18.64           N  
ATOM    557  CA  ILE A  68       2.960  11.909  25.536  1.00 18.47           C  
ATOM    558  C   ILE A  68       1.783  11.699  26.485  1.00 20.21           C  
ATOM    559  O   ILE A  68       1.463  12.562  27.311  1.00 19.64           O  
ATOM    560  CB  ILE A  68       2.527  12.405  24.145  1.00 17.55           C  
ATOM    561  CG1 ILE A  68       3.769  12.867  23.388  1.00 18.01           C  
ATOM    562  CG2 ILE A  68       1.490  13.518  24.223  1.00 19.15           C  
ATOM    563  CD1 ILE A  68       3.593  13.070  21.906  1.00 20.02           C  
ATOM    564  N   GLN A  69       1.122  10.555  26.376  1.00 19.19           N  
ATOM    565  CA  GLN A  69       0.030  10.270  27.282  1.00 20.70           C  
ATOM    566  C   GLN A  69       0.464  10.271  28.735  1.00 22.44           C  
ATOM    567  O   GLN A  69      -0.287  10.718  29.604  1.00 26.01           O  
ATOM    568  CB  GLN A  69      -0.611   8.925  26.906  1.00 23.14           C  
ATOM    569  CG  GLN A  69      -1.240   8.973  25.514  1.00 31.58           C  
ATOM    570  N   GLN A  70       1.671   9.775  29.013  1.00 20.68           N  
ATOM    571  CA  GLN A  70       2.178   9.759  30.385  1.00 21.29           C  
ATOM    572  C   GLN A  70       2.772  11.093  30.847  1.00 21.72           C  
ATOM    573  O   GLN A  70       2.691  11.417  32.025  1.00 24.11           O  
ATOM    574  CB  GLN A  70       3.180   8.621  30.598  1.00 22.28           C  
ATOM    575  CG  GLN A  70       2.581   7.254  30.320  1.00 23.14           C  
ATOM    576  CD  GLN A  70       3.418   6.097  30.866  1.00 28.40           C  
ATOM    577  OE1 GLN A  70       3.922   6.152  31.988  1.00 44.05           O  
ATOM    578  NE2 GLN A  70       3.555   5.041  30.065  1.00 39.76           N  
ATOM    579  N   GLN A  71       3.356  11.874  29.932  1.00 20.09           N  
ATOM    580  CA  GLN A  71       3.923  13.176  30.280  1.00 19.14           C  
ATOM    581  C   GLN A  71       3.726  14.091  29.079  1.00 18.34           C  
ATOM    582  O   GLN A  71       4.509  14.064  28.138  1.00 16.99           O  
ATOM    583  CB  GLN A  71       5.384  13.035  30.665  1.00 21.95           C  
ATOM    584  CG  GLN A  71       6.255  14.314  30.734  1.00 28.61           C  
ATOM    585  CD  GLN A  71       5.797  15.344  31.700  1.00 35.45           C  
ATOM    586  OE1 GLN A  71       4.789  16.006  31.494  1.00 29.38           O  
ATOM    587  NE2 GLN A  71       6.554  15.507  32.785  1.00 43.95           N  
ATOM    588  N   PRO A  72       2.646  14.860  29.100  1.00 18.07           N  
ATOM    589  CA  PRO A  72       2.343  15.684  27.942  0.50 18.79           C  
ATOM    591  C   PRO A  72       3.323  16.915  27.754  0.50 15.06           C  
ATOM    593  O   PRO A  72       3.252  17.628  26.795  0.50 15.17           O  
ATOM    595  CB  PRO A  72       0.830  15.982  28.135  1.00 22.73           C  
ATOM    596  CG  PRO A  72       0.576  15.877  29.589  1.00 25.05           C  
ATOM    597  CD  PRO A  72       1.604  14.912  30.146  1.00 21.93           C  
ATOM    598  N   TRP A  73       4.228  17.198  28.671  0.50 22.73           N  
ATOM    600  CA  TRP A  73       5.031  18.402  28.457  1.00 24.42           C  
ATOM    601  C   TRP A  73       6.181  18.126  27.470  1.00 26.70           C  
ATOM    602  O   TRP A  73       6.901  17.140  27.659  1.00 28.77           O  
ATOM    603  CB  TRP A  73       5.565  18.830  29.756  1.00 27.21           C  
ATOM    604  CG  TRP A  73       6.260  20.117  29.625  1.00 30.00           C  
ATOM    605  CD1 TRP A  73       7.526  20.315  29.169  1.00 24.82           C  
ATOM    606  CD2 TRP A  73       5.740  21.396  29.954  1.00 27.92           C  
ATOM    607  NE1 TRP A  73       7.827  21.631  29.185  1.00 23.55           N  
ATOM    608  CE2 TRP A  73       6.759  22.327  29.709  1.00 24.81           C  
ATOM    609  CE3 TRP A  73       4.508  21.850  30.449  1.00 24.77           C  
ATOM    610  CZ2 TRP A  73       6.597  23.693  29.935  1.00 26.17           C  
ATOM    611  CZ3 TRP A  73       4.358  23.216  30.679  1.00 23.88           C  
ATOM    612  CH2 TRP A  73       5.386  24.106  30.442  1.00 26.04           C  
ATOM    613  N   ALA A  74       6.328  18.970  26.437  1.00 19.97           N  
ATOM    614  CA  ALA A  74       7.375  18.763  25.411  1.00 18.65           C  
ATOM    615  C   ALA A  74       8.129  20.072  25.179  1.00 17.33           C  
ATOM    616  O   ALA A  74       7.642  21.145  25.544  1.00 16.94           O  
ATOM    617  CB  ALA A  74       6.796  18.252  24.131  1.00 23.03           C  
ATOM    618  N   GLU A  75       9.298  19.968  24.546  1.00 14.58           N  
ATOM    619  CA  GLU A  75       9.990  21.149  24.113  1.00 13.83           C  
ATOM    620  C   GLU A  75      10.439  20.945  22.673  1.00 15.80           C  
ATOM    621  O   GLU A  75      11.109  19.937  22.348  1.00 17.29           O  
ATOM    622  CB  GLU A  75      11.228  21.427  24.960  1.00 15.86           C  
ATOM    623  CG  GLU A  75      11.871  22.778  24.600  1.00 16.13           C  
ATOM    624  CD  GLU A  75      12.818  23.273  25.686  1.00 17.56           C  
ATOM    625  OE1 GLU A  75      12.351  23.528  26.848  1.00 21.07           O  
ATOM    626  OE2 GLU A  75      14.026  23.428  25.439  1.00 18.39           O  
ATOM    627  N   ILE A  76       9.996  21.846  21.803  1.00 14.80           N  
ATOM    628  CA  ILE A  76      10.479  21.787  20.443  0.50 14.42           C  
ATOM    630  C   ILE A  76      11.697  22.699  20.286  1.00 15.17           C  
ATOM    631  O   ILE A  76      11.871  23.698  20.994  1.00 15.50           O  
ATOM    632  CB  ILE A  76       9.395  22.090  19.421  0.50 15.15           C  
ATOM    634  CG1 ILE A  76       8.836  23.500  19.668  0.50 12.61           C  
ATOM    636  CG2 ILE A  76       8.331  20.959  19.408  0.50 13.64           C  
ATOM    638  CD1 ILE A  76       7.962  24.015  18.514  0.50 18.91           C  
ATOM    640  N   CYS A  77      12.588  22.301  19.382  1.00 14.89           N  
ATOM    641  CA  CYS A  77      13.669  23.143  18.934  1.00 14.31           C  
ATOM    642  C   CYS A  77      13.512  23.223  17.450  1.00 14.77           C  
ATOM    643  O   CYS A  77      13.403  22.218  16.757  1.00 15.38           O  
ATOM    644  CB  CYS A  77      15.003  22.562  19.318  1.00 17.44           C  
ATOM    645  SG  CYS A  77      16.373  23.637  18.870  1.00 17.79           S  
ATOM    646  N   TRP A  78      13.495  24.456  16.952  1.00 13.89           N  
ATOM    647  CA  TRP A  78      13.198  24.752  15.536  1.00 14.36           C  
ATOM    648  C   TRP A  78      14.265  25.699  15.008  1.00 15.48           C  
ATOM    649  O   TRP A  78      14.360  26.848  15.464  1.00 15.41           O  
ATOM    650  CB  TRP A  78      11.851  25.365  15.460  1.00 14.64           C  
ATOM    651  CG  TRP A  78      11.220  25.471  14.081  1.00 13.80           C  
ATOM    652  CD1 TRP A  78      11.729  25.090  12.864  1.00 16.26           C  
ATOM    653  CD2 TRP A  78       9.870  25.902  13.846  1.00 12.86           C  
ATOM    654  NE1 TRP A  78      10.747  25.251  11.886  1.00 16.42           N  
ATOM    655  CE2 TRP A  78       9.612  25.719  12.468  1.00 14.02           C  
ATOM    656  CE3 TRP A  78       8.839  26.334  14.673  1.00 15.18           C  
ATOM    657  CZ2 TRP A  78       8.355  26.020  11.905  1.00 15.56           C  
ATOM    658  CZ3 TRP A  78       7.643  26.700  14.119  1.00 16.17           C  
ATOM    659  CH2 TRP A  78       7.416  26.516  12.764  1.00 17.60           C  
ATOM    660  N   TYR A  79      15.083  25.212  14.092  1.00 14.57           N  
ATOM    661  CA  TYR A  79      16.158  25.974  13.515  1.00 16.01           C  
ATOM    662  C   TYR A  79      15.841  26.335  12.074  1.00 14.87           C  
ATOM    663  O   TYR A  79      15.421  25.472  11.255  1.00 16.66           O  
ATOM    664  CB  TYR A  79      17.525  25.216  13.594  1.00 17.15           C  
ATOM    665  CG  TYR A  79      18.647  25.992  13.013  1.00 15.00           C  
ATOM    666  CD1 TYR A  79      19.057  27.176  13.619  1.00 15.28           C  
ATOM    667  CD2 TYR A  79      19.260  25.642  11.816  1.00 15.61           C  
ATOM    668  CE1 TYR A  79      20.033  27.980  13.074  1.00 15.59           C  
ATOM    669  CE2 TYR A  79      20.263  26.448  11.256  1.00 16.26           C  
ATOM    670  CZ  TYR A  79      20.672  27.615  11.903  1.00 15.41           C  
ATOM    671  OH  TYR A  79      21.619  28.424  11.372  1.00 17.77           O  
ATOM    672  N   PHE A  80      16.037  27.608  11.739  1.00 13.05           N  
ATOM    673  CA  PHE A  80      15.747  28.179  10.424  1.00 15.14           C  
ATOM    674  C   PHE A  80      17.057  28.495   9.738  1.00 15.38           C  
ATOM    675  O   PHE A  80      17.739  29.428  10.090  1.00 15.73           O  
ATOM    676  CB  PHE A  80      14.919  29.449  10.602  1.00 15.35           C  
ATOM    677  CG  PHE A  80      13.491  29.183  10.959  1.00 12.83           C  
ATOM    678  CD1 PHE A  80      12.549  28.981   9.993  1.00 15.11           C  
ATOM    679  CD2 PHE A  80      13.098  29.102  12.288  1.00 14.25           C  
ATOM    680  CE1 PHE A  80      11.189  28.745  10.331  1.00 16.99           C  
ATOM    681  CE2 PHE A  80      11.793  28.836  12.643  1.00 16.21           C  
ATOM    682  CZ  PHE A  80      10.822  28.691  11.677  1.00 15.71           C  
ATOM    683  N   PRO A  81      17.443  27.662   8.750  1.00 16.54           N  
ATOM    684  CA  PRO A  81      18.791  27.769   8.239  1.00 18.70           C  
ATOM    685  C   PRO A  81      19.155  28.973   7.414  1.00 18.40           C  
ATOM    686  O   PRO A  81      20.315  29.381   7.423  1.00 19.14           O  
ATOM    687  CB  PRO A  81      18.974  26.466   7.438  1.00 20.30           C  
ATOM    688  CG  PRO A  81      17.983  25.591   7.849  1.00 23.16           C  
ATOM    689  CD  PRO A  81      16.760  26.462   8.248  1.00 18.58           C  
ATOM    690  N   ASN A  82      18.186  29.596   6.747  1.00 17.55           N  
ATOM    691  CA  ASN A  82      18.499  30.739   5.894  1.00 18.88           C  
ATOM    692  C   ASN A  82      18.710  32.011   6.717  1.00 20.34           C  
ATOM    693  O   ASN A  82      19.420  32.907   6.341  1.00 24.37           O  
ATOM    694  CB  ASN A  82      17.339  31.037   4.954  1.00 22.73           C  
ATOM    695  CG  ASN A  82      17.524  30.503   3.587  1.00 34.66           C  
ATOM    696  OD1 ASN A  82      18.535  29.886   3.272  1.00 33.61           O  
ATOM    697  ND2 ASN A  82      16.515  30.742   2.739  1.00 40.02           N  
ATOM    698  N   THR A  83      18.013  32.111   7.837  1.00 15.49           N  
ATOM    699  CA  THR A  83      18.113  33.264   8.697  1.00 14.81           C  
ATOM    700  C   THR A  83      18.908  33.029   9.973  1.00 15.63           C  
ATOM    701  O   THR A  83      19.125  33.976  10.719  1.00 16.19           O  
ATOM    702  CB  THR A  83      16.714  33.766   9.061  1.00 14.71           C  
ATOM    703  OG1 THR A  83      15.951  32.689   9.583  1.00 15.82           O  
ATOM    704  CG2 THR A  83      15.993  34.334   7.790  1.00 16.20           C  
ATOM    705  N   ARG A  84      19.382  31.797  10.190  1.00 15.26           N  
ATOM    706  CA  ARG A  84      20.265  31.488  11.341  1.00 16.34           C  
ATOM    707  C   ARG A  84      19.597  31.884  12.672  1.00 15.26           C  
ATOM    708  O   ARG A  84      20.179  32.563  13.518  1.00 15.99           O  
ATOM    709  CB  ARG A  84      21.642  32.129  11.169  1.00 15.44           C  
ATOM    710  CG  ARG A  84      22.353  31.695   9.900  1.00 19.29           C  
ATOM    711  CD  ARG A  84      23.788  32.299   9.812  1.00 23.33           C  
ATOM    712  NE  ARG A  84      24.654  31.820  10.884  1.00 30.92           N  
ATOM    713  CZ  ARG A  84      25.429  32.559  11.681  1.00 36.91           C  
ATOM    714  NH1 ARG A  84      25.558  33.899  11.573  1.00 38.43           N  
ATOM    715  NH2 ARG A  84      26.120  31.933  12.611  1.00 39.72           N  
ATOM    716  N   GLU A  85      18.346  31.437  12.847  1.00 13.77           N  
ATOM    717  CA  GLU A  85      17.608  31.680  14.081  1.00 13.56           C  
ATOM    718  C   GLU A  85      16.989  30.417  14.629  1.00 13.59           C  
ATOM    719  O   GLU A  85      16.675  29.504  13.853  1.00 14.83           O  
ATOM    720  CB  GLU A  85      16.570  32.774  13.879  1.00 16.89           C  
ATOM    721  CG  GLU A  85      15.494  32.436  12.969  1.00 17.60           C  
ATOM    722  CD  GLU A  85      14.640  33.672  12.594  1.00 20.02           C  
ATOM    723  OE1 GLU A  85      14.117  34.352  13.500  1.00 18.92           O  
ATOM    724  OE2 GLU A  85      14.452  33.895  11.380  1.00 17.97           O  
ATOM    725  N   GLN A  86      16.833  30.345  15.943  1.00 12.96           N  
ATOM    726  CA  GLN A  86      16.312  29.199  16.597  1.00 13.88           C  
ATOM    727  C   GLN A  86      15.162  29.616  17.500  1.00 13.86           C  
ATOM    728  O   GLN A  86      15.254  30.649  18.166  1.00 14.12           O  
ATOM    729  CB  GLN A  86      17.402  28.571  17.451  1.00 15.16           C  
ATOM    730  CG  GLN A  86      16.980  27.438  18.395  1.00 16.56           C  
ATOM    731  CD  GLN A  86      18.142  26.881  19.162  1.00 16.35           C  
ATOM    732  OE1 GLN A  86      18.650  25.814  18.801  1.00 17.86           O  
ATOM    733  NE2 GLN A  86      18.564  27.571  20.190  1.00 17.37           N  
ATOM    734  N   PHE A  87      14.078  28.836  17.488  1.00 12.94           N  
ATOM    735  CA  PHE A  87      13.008  28.956  18.462  1.00 12.47           C  
ATOM    736  C   PHE A  87      12.940  27.672  19.281  1.00 14.39           C  
ATOM    737  O   PHE A  87      12.840  26.565  18.734  1.00 15.57           O  
ATOM    738  CB  PHE A  87      11.654  29.197  17.819  1.00 13.57           C  
ATOM    739  CG  PHE A  87      11.541  30.449  17.041  1.00 13.74           C  
ATOM    740  CD1 PHE A  87      12.097  30.576  15.789  1.00 17.15           C  
ATOM    741  CD2 PHE A  87      10.859  31.540  17.597  1.00 15.08           C  
ATOM    742  CE1 PHE A  87      11.963  31.774  15.044  1.00 15.78           C  
ATOM    743  CE2 PHE A  87      10.713  32.724  16.848  1.00 13.49           C  
ATOM    744  CZ  PHE A  87      11.251  32.819  15.566  1.00 14.14           C  
ATOM    745  N   ARG A  88      12.974  27.823  20.579  1.00 12.45           N  
ATOM    746  CA  ARG A  88      12.714  26.720  21.502  1.00 13.14           C  
ATOM    747  C   ARG A  88      11.378  27.014  22.135  1.00 14.33           C  
ATOM    748  O   ARG A  88      11.157  28.146  22.562  1.00 14.11           O  
ATOM    749  CB  ARG A  88      13.809  26.611  22.565  1.00 14.33           C  
ATOM    750  CG  ARG A  88      15.124  26.214  21.984  1.00 15.38           C  
ATOM    751  CD  ARG A  88      16.260  26.398  22.994  1.00 16.99           C  
ATOM    752  NE  ARG A  88      16.055  25.534  24.166  1.00 17.17           N  
ATOM    753  CZ  ARG A  88      16.867  25.473  25.223  1.00 18.73           C  
ATOM    754  NH1 ARG A  88      17.836  26.313  25.283  1.00 20.09           N  
ATOM    755  NH2 ARG A  88      16.622  24.616  26.225  1.00 20.21           N  
HETATM  756  N   MSE A  89      10.461  26.080  22.124  1.00 14.06           N  
HETATM  757  CA  MSE A  89       9.111  26.329  22.587  0.50 14.79           C  
HETATM  759  C   MSE A  89       8.695  25.155  23.488  1.00 15.48           C  
HETATM  760  O   MSE A  89       8.692  24.011  23.046  1.00 15.83           O  
HETATM  761  CB  MSE A  89       8.156  26.556  21.385  0.50 16.34           C  
HETATM  763  CG  MSE A  89       8.788  27.369  20.218  0.50 12.10           C  
HETATM  765 SE   MSE A  89       7.729  27.443  18.575  0.37 22.49          SE  
HETATM  767  CE  MSE A  89       6.698  29.036  18.965  0.50 24.58           C  
ATOM    769  N   ALA A  90       8.333  25.465  24.721  1.00 15.19           N  
ATOM    770  CA  ALA A  90       7.992  24.446  25.698  1.00 15.22           C  
ATOM    771  C   ALA A  90       6.561  24.624  26.133  1.00 17.30           C  
ATOM    772  O   ALA A  90       6.118  25.739  26.321  1.00 15.73           O  
ATOM    773  CB  ALA A  90       8.863  24.567  26.884  1.00 15.31           C  
ATOM    774  N   GLY A  91       5.837  23.523  26.286  1.00 16.08           N  
ATOM    775  CA  GLY A  91       4.475  23.595  26.776  1.00 16.35           C  
ATOM    776  C   GLY A  91       3.789  22.256  26.691  1.00 16.44           C  
ATOM    777  O   GLY A  91       4.423  21.223  26.493  1.00 17.00           O  
ATOM    778  N   ASP A  92       2.488  22.288  26.944  1.00 19.78           N  
ATOM    779  CA  ASP A  92       1.745  21.043  27.032  0.50 18.47           C  
ATOM    781  C   ASP A  92       1.236  20.596  25.679  1.00 17.35           C  
ATOM    782  O   ASP A  92       0.851  21.382  24.823  1.00 18.00           O  
ATOM    783  CB  ASP A  92       0.583  21.141  27.995  0.50 21.83           C  
ATOM    785  CG  ASP A  92       1.013  20.996  29.431  0.50 28.64           C  
ATOM    787  OD1 ASP A  92       1.679  19.990  29.806  0.50 29.86           O  
ATOM    789  OD2 ASP A  92       0.673  21.907  30.172  0.50 22.73           O  
ATOM    791  N   LEU A  93       1.329  19.292  25.490  1.00 20.15           N  
ATOM    792  CA  LEU A  93       0.802  18.619  24.342  1.00 17.10           C  
ATOM    793  C   LEU A  93      -0.613  18.139  24.564  1.00 18.98           C  
ATOM    794  O   LEU A  93      -0.967  17.703  25.621  1.00 18.52           O  
ATOM    795  CB  LEU A  93       1.658  17.409  23.973  1.00 17.98           C  
ATOM    796  CG  LEU A  93       3.091  17.749  23.507  1.00 20.63           C  
ATOM    797  CD1 LEU A  93       3.983  16.475  23.429  1.00 23.48           C  
ATOM    798  CD2 LEU A  93       3.097  18.511  22.194  1.00 24.18           C  
ATOM    799  N   THR A  94      -1.399  18.145  23.505  1.00 16.07           N  
ATOM    800  CA  THR A  94      -2.697  17.475  23.460  1.00 15.92           C  
ATOM    801  C   THR A  94      -2.668  16.470  22.298  1.00 15.71           C  
ATOM    802  O   THR A  94      -2.372  16.860  21.183  1.00 16.39           O  
ATOM    803  CB  THR A  94      -3.826  18.485  23.217  1.00 16.42           C  
ATOM    804  OG1 THR A  94      -3.810  19.538  24.195  1.00 20.36           O  
ATOM    805  CG2 THR A  94      -5.207  17.813  23.292  1.00 20.42           C  
ATOM    806  N   LEU A  95      -2.960  15.216  22.558  1.00 15.54           N  
ATOM    807  CA  LEU A  95      -2.958  14.177  21.555  1.00 16.65           C  
ATOM    808  C   LEU A  95      -4.413  13.791  21.313  1.00 16.67           C  
ATOM    809  O   LEU A  95      -5.099  13.325  22.225  1.00 17.54           O  
ATOM    810  CB  LEU A  95      -2.165  12.969  22.054  1.00 17.29           C  
ATOM    811  CG  LEU A  95      -1.849  11.854  21.062  1.00 23.27           C  
ATOM    812  CD1 LEU A  95      -0.936  12.275  19.902  1.00 23.84           C  
ATOM    813  CD2 LEU A  95      -1.225  10.659  21.806  1.00 26.05           C  
ATOM    814  N   ILE A  96      -4.877  14.088  20.114  1.00 16.03           N  
ATOM    815  CA  ILE A  96      -6.263  13.834  19.720  1.00 15.36           C  
ATOM    816  C   ILE A  96      -6.253  12.650  18.756  1.00 14.59           C  
ATOM    817  O   ILE A  96      -5.821  12.754  17.597  1.00 15.41           O  
ATOM    818  CB  ILE A  96      -6.913  15.088  19.071  1.00 15.82           C  
ATOM    819  CG1 ILE A  96      -6.746  16.319  19.950  1.00 20.07           C  
ATOM    820  CG2 ILE A  96      -8.427  14.895  18.810  1.00 15.53           C  
ATOM    821  CD1 ILE A  96      -5.611  17.136  19.579  1.00 27.68           C  
ATOM    822  N   SER A  97      -6.751  11.523  19.243  1.00 16.36           N  
ATOM    823  CA  SER A  97      -6.775  10.253  18.508  1.00 15.96           C  
ATOM    824  C   SER A  97      -8.229   9.916  18.222  1.00 18.02           C  
ATOM    825  O   SER A  97      -9.080  10.796  18.256  1.00 17.03           O  
ATOM    826  CB  SER A  97      -6.117   9.156  19.335  1.00 18.69           C  
ATOM    827  OG  SER A  97      -6.867   8.917  20.509  1.00 19.13           O  
ATOM    828  N   SER A  98      -8.542   8.647  18.009  1.00 17.19           N  
ATOM    829  CA  SER A  98      -9.933   8.254  17.877  1.00 20.06           C  
ATOM    830  C   SER A  98     -10.562   7.917  19.224  1.00 21.09           C  
ATOM    831  O   SER A  98     -11.757   7.589  19.279  1.00 24.32           O  
ATOM    832  CB  SER A  98     -10.062   7.045  16.943  1.00 22.80           C  
ATOM    833  OG  SER A  98      -9.248   5.989  17.424  1.00 28.37           O  
ATOM    834  N   ASP A  99      -9.801   7.964  20.310  1.00 20.95           N  
ATOM    835  CA  ASP A  99     -10.426   7.746  21.623  1.00 22.51           C  
ATOM    836  C   ASP A  99     -11.290   8.954  22.042  1.00 24.52           C  
ATOM    837  O   ASP A  99     -11.333   9.957  21.332  1.00 24.10           O  
ATOM    838  CB  ASP A  99      -9.404   7.333  22.662  1.00 28.13           C  
ATOM    839  CG  ASP A  99      -8.620   8.460  23.211  1.00 28.02           C  
ATOM    840  OD1 ASP A  99      -8.984   9.652  23.043  1.00 30.51           O  
ATOM    841  OD2 ASP A  99      -7.594   8.131  23.855  1.00 43.29           O  
ATOM    842  N   ASP A 100     -12.012   8.853  23.159  1.00 23.12           N  
ATOM    843  CA  ASP A 100     -13.004   9.890  23.498  1.00 23.46           C  
ATOM    844  C   ASP A 100     -12.508  10.987  24.451  1.00 24.78           C  
ATOM    845  O   ASP A 100     -13.311  11.716  25.023  1.00 26.17           O  
ATOM    846  CB  ASP A 100     -14.292   9.237  24.030  1.00 25.36           C  
ATOM    847  CG  ASP A 100     -14.100   8.538  25.341  1.00 33.27           C  
ATOM    848  OD1 ASP A 100     -13.049   8.728  25.992  1.00 31.81           O  
ATOM    849  OD2 ASP A 100     -15.032   7.791  25.732  1.00 41.23           O  
ATOM    850  N   SER A 101     -11.196  11.121  24.578  1.00 22.69           N  
ATOM    851  CA  SER A 101     -10.569  12.073  25.501  1.00 22.87           C  
ATOM    852  C   SER A 101     -10.726  13.540  25.127  1.00 23.17           C  
ATOM    853  O   SER A 101     -10.639  14.406  25.976  1.00 23.60           O  
ATOM    854  CB  SER A 101      -9.063  11.744  25.604  1.00 27.11           C  
ATOM    855  OG  SER A 101      -8.886  10.457  26.178  1.00 35.94           O  
ATOM    856  N   HIS A 102     -10.898  13.842  23.844  1.00 20.65           N  
ATOM    857  CA  HIS A 102     -10.898  15.229  23.383  1.00 17.73           C  
ATOM    858  C   HIS A 102     -11.951  15.434  22.311  1.00 19.86           C  
ATOM    859  O   HIS A 102     -11.648  15.886  21.209  1.00 17.13           O  
ATOM    860  CB  HIS A 102      -9.537  15.571  22.847  1.00 18.92           C  
ATOM    861  CG  HIS A 102      -8.460  15.502  23.886  1.00 20.87           C  
ATOM    862  ND1 HIS A 102      -8.398  16.387  24.940  1.00 22.84           N  
ATOM    863  CD2 HIS A 102      -7.432  14.638  24.044  1.00 22.07           C  
ATOM    864  CE1 HIS A 102      -7.335  16.099  25.676  1.00 20.56           C  
ATOM    865  NE2 HIS A 102      -6.741  15.033  25.161  1.00 22.51           N  
ATOM    866  N   GLN A 103     -13.197  15.170  22.667  1.00 18.67           N  
ATOM    867  CA  GLN A 103     -14.296  15.196  21.684  1.00 19.09           C  
ATOM    868  C   GLN A 103     -14.469  16.550  21.073  1.00 19.03           C  
ATOM    869  O   GLN A 103     -14.776  16.658  19.866  1.00 17.75           O  
ATOM    870  CB  GLN A 103     -15.608  14.728  22.311  1.00 21.26           C  
ATOM    871  CG  GLN A 103     -15.719  13.241  22.366  1.00 24.44           C  
ATOM    872  CD  GLN A 103     -15.413  12.574  21.015  1.00 32.08           C  
ATOM    873  OE1 GLN A 103     -14.349  11.979  20.870  1.00 35.33           O  
ATOM    874  NE2 GLN A 103     -16.303  12.747  19.995  1.00 26.18           N  
ATOM    875  N   ASP A 104     -14.256  17.594  21.861  1.00 17.90           N  
ATOM    876  CA  ASP A 104     -14.328  18.955  21.362  1.00 20.87           C  
ATOM    877  C   ASP A 104     -13.330  19.293  20.265  1.00 21.71           C  
ATOM    878  O   ASP A 104     -13.532  20.248  19.539  1.00 22.48           O  
ATOM    879  CB  ASP A 104     -14.186  19.987  22.492  1.00 24.75           C  
ATOM    880  CG  ASP A 104     -12.884  19.829  23.302  1.00 36.98           C  
ATOM    881  OD1 ASP A 104     -12.435  18.685  23.555  1.00 45.63           O  
ATOM    882  OD2 ASP A 104     -12.332  20.869  23.730  1.00 54.72           O  
ATOM    883  N   LEU A 105     -12.241  18.522  20.151  1.00 17.10           N  
ATOM    884  CA  LEU A 105     -11.249  18.771  19.136  1.00 16.63           C  
ATOM    885  C   LEU A 105     -11.340  17.772  17.971  1.00 12.58           C  
ATOM    886  O   LEU A 105     -10.451  17.746  17.119  1.00 14.48           O  
ATOM    887  CB  LEU A 105      -9.836  18.704  19.748  1.00 17.44           C  
ATOM    888  CG  LEU A 105      -9.520  19.930  20.640  1.00 22.22           C  
ATOM    889  CD1 LEU A 105      -8.348  19.667  21.535  1.00 21.92           C  
ATOM    890  CD2 LEU A 105      -9.225  21.113  19.705  1.00 25.48           C  
ATOM    891  N   GLN A 106     -12.374  16.952  17.945  1.00 12.87           N  
ATOM    892  CA  GLN A 106     -12.509  16.054  16.762  1.00 11.12           C  
ATOM    893  C   GLN A 106     -12.611  16.839  15.460  1.00 11.96           C  
ATOM    894  O   GLN A 106     -12.014  16.441  14.471  1.00 13.09           O  
ATOM    895  CB  GLN A 106     -13.608  15.026  16.929  1.00 12.59           C  
ATOM    896  CG  GLN A 106     -13.227  13.961  17.951  1.00 14.66           C  
ATOM    897  CD  GLN A 106     -12.059  13.111  17.548  1.00 14.59           C  
ATOM    898  OE1 GLN A 106     -11.904  12.790  16.361  1.00 14.83           O  
ATOM    899  NE2 GLN A 106     -11.215  12.717  18.547  1.00 14.37           N  
ATOM    900  N   PRO A 107     -13.396  17.949  15.387  1.00 12.23           N  
ATOM    901  CA  PRO A 107     -13.414  18.688  14.146  1.00 13.44           C  
ATOM    902  C   PRO A 107     -12.013  19.126  13.688  1.00 12.36           C  
ATOM    903  O   PRO A 107     -11.728  19.076  12.475  1.00 12.87           O  
ATOM    904  CB  PRO A 107     -14.338  19.871  14.451  1.00 13.69           C  
ATOM    905  CG  PRO A 107     -15.247  19.345  15.524  1.00 12.85           C  
ATOM    906  CD  PRO A 107     -14.391  18.487  16.362  1.00 13.08           C  
ATOM    907  N   ALA A 108     -11.134  19.519  14.625  1.00 13.27           N  
ATOM    908  CA  ALA A 108      -9.784  19.881  14.265  1.00 12.85           C  
ATOM    909  C   ALA A 108      -9.027  18.702  13.718  1.00 12.98           C  
ATOM    910  O   ALA A 108      -8.269  18.818  12.789  1.00 13.85           O  
ATOM    911  CB  ALA A 108      -9.039  20.474  15.466  1.00 14.54           C  
ATOM    912  N   ARG A 109      -9.185  17.548  14.339  1.00 12.39           N  
ATOM    913  CA  ARG A 109      -8.530  16.328  13.854  1.00 12.21           C  
ATOM    914  C   ARG A 109      -8.985  15.928  12.450  1.00 11.82           C  
ATOM    915  O   ARG A 109      -8.167  15.565  11.589  1.00 13.27           O  
ATOM    916  CB  ARG A 109      -8.761  15.197  14.867  1.00 13.19           C  
ATOM    917  CG  ARG A 109      -8.226  13.800  14.473  1.00 12.82           C  
ATOM    918  CD  ARG A 109      -8.427  12.792  15.567  1.00 13.30           C  
ATOM    919  NE  ARG A 109      -8.100  11.442  15.124  1.00 14.88           N  
ATOM    920  CZ  ARG A 109      -8.982  10.511  14.769  1.00 15.86           C  
ATOM    921  NH1 ARG A 109     -10.298  10.736  14.820  1.00 14.17           N  
ATOM    922  NH2 ARG A 109      -8.527   9.345  14.321  1.00 15.03           N  
ATOM    923  N   ILE A 110     -10.282  15.999  12.248  1.00 11.64           N  
ATOM    924  CA  ILE A 110     -10.896  15.653  10.950  1.00 12.19           C  
ATOM    925  C   ILE A 110     -10.418  16.628   9.865  1.00 12.54           C  
ATOM    926  O   ILE A 110     -10.052  16.236   8.758  1.00 13.65           O  
ATOM    927  CB  ILE A 110     -12.436  15.660  11.050  1.00 12.12           C  
ATOM    928  CG1 ILE A 110     -12.874  14.543  11.992  1.00 11.87           C  
ATOM    929  CG2 ILE A 110     -13.052  15.462   9.647  1.00 14.30           C  
ATOM    930  CD1 ILE A 110     -14.272  14.719  12.662  1.00 12.81           C  
ATOM    931  N   ALA A 111     -10.394  17.939  10.164  1.00 12.27           N  
ATOM    932  CA  ALA A 111      -9.900  18.926   9.241  1.00 13.82           C  
ATOM    933  C   ALA A 111      -8.460  18.651   8.866  1.00 13.18           C  
ATOM    934  O   ALA A 111      -8.091  18.758   7.705  1.00 14.81           O  
ATOM    935  CB  ALA A 111     -10.043  20.358   9.850  1.00 14.95           C  
HETATM  936  N   MSE A 112      -7.619  18.357   9.860  1.00 12.87           N  
HETATM  937  CA  MSE A 112      -6.225  18.073   9.555  1.00 13.41           C  
HETATM  938  C   MSE A 112      -6.096  16.892   8.593  1.00 12.92           C  
HETATM  939  O   MSE A 112      -5.339  16.923   7.613  1.00 14.11           O  
HETATM  940  CB  MSE A 112      -5.460  17.832  10.830  1.00 15.15           C  
HETATM  941  CG  MSE A 112      -3.994  17.448  10.718  1.00 15.70           C  
HETATM  942 SE   MSE A 112      -2.814  18.982  10.499  0.75 20.94          SE  
HETATM  943  CE  MSE A 112      -2.879  18.979   8.684  1.00 19.25           C  
ATOM    944  N   TRP A 113      -6.790  15.803   8.910  1.00 12.82           N  
ATOM    945  CA  TRP A 113      -6.792  14.616   8.047  1.00 13.42           C  
ATOM    946  C   TRP A 113      -7.123  14.977   6.615  1.00 13.14           C  
ATOM    947  O   TRP A 113      -6.486  14.526   5.662  1.00 13.47           O  
ATOM    948  CB  TRP A 113      -7.852  13.608   8.575  1.00 12.74           C  
ATOM    949  CG  TRP A 113      -7.968  12.383   7.742  1.00 11.05           C  
ATOM    950  CD1 TRP A 113      -9.001  12.073   6.890  1.00 12.69           C  
ATOM    951  CD2 TRP A 113      -7.066  11.286   7.692  1.00 12.10           C  
ATOM    952  NE1 TRP A 113      -8.800  10.838   6.343  1.00 11.91           N  
ATOM    953  CE2 TRP A 113      -7.617  10.327   6.809  1.00 11.65           C  
ATOM    954  CE3 TRP A 113      -5.845  11.017   8.290  1.00 11.48           C  
ATOM    955  CZ2 TRP A 113      -7.004   9.134   6.545  1.00 12.17           C  
ATOM    956  CZ3 TRP A 113      -5.236   9.797   8.017  1.00 13.58           C  
ATOM    957  CH2 TRP A 113      -5.817   8.889   7.144  1.00 12.62           C  
ATOM    958  N   GLN A 114      -8.187  15.755   6.448  1.00 13.34           N  
ATOM    959  CA  GLN A 114      -8.673  16.125   5.134  1.00 13.76           C  
ATOM    960  C   GLN A 114      -7.697  17.031   4.357  1.00 15.19           C  
ATOM    961  O   GLN A 114      -7.683  16.984   3.112  1.00 16.41           O  
ATOM    962  CB  GLN A 114     -10.025  16.790   5.265  1.00 15.86           C  
ATOM    963  CG  GLN A 114     -11.088  15.780   5.700  1.00 14.61           C  
ATOM    964  CD  GLN A 114     -12.452  16.399   5.786  1.00 16.70           C  
ATOM    965  OE1 GLN A 114     -12.600  17.597   5.503  1.00 20.63           O  
ATOM    966  NE2 GLN A 114     -13.450  15.642   6.237  1.00 14.23           N  
ATOM    967  N   GLU A 115      -6.919  17.825   5.080  1.00 14.84           N  
ATOM    968  CA  GLU A 115      -5.972  18.745   4.487  1.00 15.18           C  
ATOM    969  C   GLU A 115      -4.698  18.080   4.022  1.00 17.17           C  
ATOM    970  O   GLU A 115      -3.897  18.673   3.252  1.00 18.31           O  
ATOM    971  CB  GLU A 115      -5.658  19.852   5.531  1.00 16.03           C  
ATOM    972  CG  GLU A 115      -6.823  20.770   5.734  1.00 20.74           C  
ATOM    973  CD  GLU A 115      -6.843  21.628   7.009  1.00 25.22           C  
ATOM    974  OE1 GLU A 115      -5.847  21.623   7.754  1.00 26.96           O  
ATOM    975  OE2 GLU A 115      -7.880  22.327   7.238  1.00 27.23           O  
ATOM    976  N   LEU A 116      -4.427  16.886   4.504  1.00 14.89           N  
ATOM    977  CA  LEU A 116      -3.255  16.161   4.092  1.00 15.15           C  
ATOM    978  C   LEU A 116      -3.244  15.789   2.615  1.00 17.10           C  
ATOM    979  O   LEU A 116      -4.280  15.695   1.965  1.00 16.82           O  
ATOM    980  CB  LEU A 116      -3.107  14.882   4.897  1.00 15.44           C  
ATOM    981  CG  LEU A 116      -2.950  15.047   6.413  1.00 14.11           C  
ATOM    982  CD1 LEU A 116      -2.842  13.655   7.021  1.00 15.94           C  
ATOM    983  CD2 LEU A 116      -1.729  15.881   6.789  1.00 17.93           C  
ATOM    984  N   SER A 117      -2.044  15.512   2.075  1.00 18.84           N  
ATOM    985  CA  SER A 117      -2.009  14.832   0.809  1.00 18.42           C  
ATOM    986  C   SER A 117      -2.391  13.340   0.887  1.00 19.14           C  
ATOM    987  O   SER A 117      -2.360  12.723   1.949  1.00 17.24           O  
ATOM    988  CB  SER A 117      -0.585  14.902   0.205  1.00 20.15           C  
ATOM    989  OG  SER A 117       0.297  14.220   1.070  1.00 20.87           O  
ATOM    990  N   ASP A 118      -2.692  12.738  -0.263  1.00 18.89           N  
ATOM    991  CA  ASP A 118      -2.872  11.291  -0.306  1.00 20.06           C  
ATOM    992  C   ASP A 118      -1.666  10.570   0.235  1.00 20.35           C  
ATOM    993  O   ASP A 118      -1.797   9.603   0.946  1.00 20.21           O  
ATOM    994  CB  ASP A 118      -3.191  10.789  -1.724  1.00 21.28           C  
ATOM    995  CG  ASP A 118      -4.595  11.110  -2.176  1.00 26.27           C  
ATOM    996  OD1 ASP A 118      -5.529  11.198  -1.327  1.00 29.53           O  
ATOM    997  OD2 ASP A 118      -4.800  11.183  -3.415  1.00 31.28           O  
ATOM    998  N   ALA A 119      -0.472  11.029  -0.145  1.00 20.39           N  
ATOM    999  CA  ALA A 119       0.746  10.359   0.326  1.00 20.55           C  
ATOM   1000  C   ALA A 119       0.850  10.318   1.846  1.00 19.62           C  
ATOM   1001  O   ALA A 119       1.248   9.293   2.453  1.00 19.95           O  
ATOM   1002  CB  ALA A 119       2.010  11.061  -0.290  1.00 22.26           C  
ATOM   1003  N   ALA A 120       0.498  11.437   2.470  1.00 19.20           N  
ATOM   1004  CA  ALA A 120       0.596  11.574   3.880  1.00 18.42           C  
ATOM   1005  C   ALA A 120      -0.458  10.670   4.541  1.00 19.73           C  
ATOM   1006  O   ALA A 120      -0.153   9.985   5.510  1.00 18.64           O  
ATOM   1007  CB  ALA A 120       0.450  13.038   4.337  1.00 19.18           C  
ATOM   1008  N   ARG A 121      -1.693  10.648   4.012  1.00 17.19           N  
ATOM   1009  CA  ARG A 121      -2.686   9.718   4.598  1.00 14.56           C  
ATOM   1010  C   ARG A 121      -2.309   8.247   4.451  1.00 15.92           C  
ATOM   1011  O   ARG A 121      -2.543   7.443   5.337  1.00 16.85           O  
ATOM   1012  CB  ARG A 121      -4.068   9.944   4.002  1.00 15.25           C  
ATOM   1013  CG  ARG A 121      -4.769  11.227   4.458  1.00 14.61           C  
ATOM   1014  CD  ARG A 121      -6.204  11.313   3.960  1.00 13.89           C  
ATOM   1015  NE  ARG A 121      -6.281  11.649   2.531  1.00 14.66           N  
ATOM   1016  CZ  ARG A 121      -6.245  12.887   2.062  1.00 15.85           C  
ATOM   1017  NH1 ARG A 121      -6.285  13.940   2.871  1.00 15.01           N  
ATOM   1018  NH2 ARG A 121      -6.155  13.065   0.760  1.00 18.17           N  
ATOM   1019  N   LEU A 122      -1.697   7.907   3.289  1.00 18.30           N  
ATOM   1020  CA  LEU A 122      -1.340   6.514   2.965  0.50 17.84           C  
ATOM   1022  C   LEU A 122      -0.393   5.932   4.029  1.00 17.29           C  
ATOM   1023  O   LEU A 122      -0.479   4.756   4.366  1.00 17.53           O  
ATOM   1024  CB  LEU A 122      -0.679   6.419   1.567  0.50 19.92           C  
ATOM   1026  CG  LEU A 122      -1.550   6.372   0.296  0.50 23.06           C  
ATOM   1028  CD1 LEU A 122      -0.741   6.696  -0.953  0.50 25.31           C  
ATOM   1030  CD2 LEU A 122      -2.205   5.008   0.114  0.50 20.78           C  
ATOM   1032  N   GLN A 123       0.497   6.739   4.568  1.00 19.06           N  
ATOM   1033  CA  GLN A 123       1.471   6.241   5.549  1.00 19.17           C  
ATOM   1034  C   GLN A 123       0.840   5.672   6.797  1.00 20.08           C  
ATOM   1035  O   GLN A 123       1.418   4.825   7.451  1.00 18.80           O  
ATOM   1036  CB  GLN A 123       2.473   7.320   5.961  1.00 21.80           C  
ATOM   1037  CG  GLN A 123       3.342   7.826   4.885  1.00 27.46           C  
ATOM   1038  CD  GLN A 123       4.586   8.583   5.413  1.00 23.98           C  
ATOM   1039  OE1 GLN A 123       4.843   8.643   6.620  1.00 34.51           O  
ATOM   1040  NE2 GLN A 123       5.355   9.140   4.493  1.00 37.32           N  
ATOM   1041  N   PHE A 124      -0.378   6.111   7.132  1.00 17.48           N  
ATOM   1042  CA  PHE A 124      -1.053   5.559   8.296  1.00 17.26           C  
ATOM   1043  C   PHE A 124      -1.510   4.110   8.051  1.00 17.77           C  
ATOM   1044  O   PHE A 124      -1.843   3.414   9.009  1.00 19.22           O  
ATOM   1045  CB  PHE A 124      -2.197   6.491   8.722  1.00 15.98           C  
ATOM   1046  CG  PHE A 124      -1.674   7.786   9.297  1.00 14.54           C  
ATOM   1047  CD1 PHE A 124      -1.338   7.879  10.638  1.00 17.30           C  
ATOM   1048  CD2 PHE A 124      -1.363   8.851   8.460  1.00 14.94           C  
ATOM   1049  CE1 PHE A 124      -0.779   8.996  11.144  1.00 17.00           C  
ATOM   1050  CE2 PHE A 124      -0.774   9.986   8.962  1.00 16.36           C  
ATOM   1051  CZ  PHE A 124      -0.473  10.063  10.333  1.00 15.65           C  
ATOM   1052  N   GLY A 125      -1.437   3.642   6.793  1.00 18.68           N  
ATOM   1053  CA  GLY A 125      -1.716   2.255   6.472  1.00 18.79           C  
ATOM   1054  C   GLY A 125      -0.503   1.359   6.394  1.00 17.96           C  
ATOM   1055  O   GLY A 125      -0.618   0.164   6.081  1.00 21.47           O  
ATOM   1056  N   TRP A 126       0.658   1.903   6.700  1.00 17.61           N  
ATOM   1057  CA  TRP A 126       1.909   1.128   6.701  1.00 17.26           C  
ATOM   1058  C   TRP A 126       1.988   0.169   7.893  1.00 18.35           C  
ATOM   1059  O   TRP A 126       1.247   0.291   8.861  1.00 17.01           O  
ATOM   1060  CB  TRP A 126       3.109   2.077   6.728  1.00 18.45           C  
ATOM   1061  CG  TRP A 126       3.382   2.792   5.442  1.00 18.25           C  
ATOM   1062  CD1 TRP A 126       2.682   2.713   4.275  1.00 16.36           C  
ATOM   1063  CD2 TRP A 126       4.450   3.702   5.209  1.00 15.33           C  
ATOM   1064  NE1 TRP A 126       3.245   3.542   3.336  1.00 19.86           N  
ATOM   1065  CE2 TRP A 126       4.340   4.159   3.887  1.00 19.65           C  
ATOM   1066  CE3 TRP A 126       5.490   4.186   6.012  1.00 19.77           C  
ATOM   1067  CZ2 TRP A 126       5.230   5.046   3.331  1.00 19.36           C  
ATOM   1068  CZ3 TRP A 126       6.353   5.097   5.470  1.00 21.27           C  
ATOM   1069  CH2 TRP A 126       6.239   5.499   4.132  1.00 20.16           C  
ATOM   1070  N   PRO A 127       2.838  -0.863   7.790  1.00 17.62           N  
ATOM   1071  CA  PRO A 127       2.936  -1.785   8.906  1.00 18.04           C  
ATOM   1072  C   PRO A 127       3.456  -1.165  10.182  1.00 18.79           C  
ATOM   1073  O   PRO A 127       3.985  -0.065  10.152  1.00 20.93           O  
ATOM   1074  CB  PRO A 127       3.879  -2.886   8.392  1.00 20.67           C  
ATOM   1075  CG  PRO A 127       4.495  -2.375   7.189  1.00 23.92           C  
ATOM   1076  CD  PRO A 127       3.654  -1.251   6.638  1.00 19.62           C  
ATOM   1077  N   TYR A 128       3.254  -1.886  11.281  1.00 20.25           N  
ATOM   1078  CA  TYR A 128       3.454  -1.395  12.637  1.00 19.31           C  
ATOM   1079  C   TYR A 128       4.866  -0.816  12.840  1.00 20.30           C  
ATOM   1080  O   TYR A 128       5.850  -1.519  12.720  1.00 19.43           O  
ATOM   1081  CB  TYR A 128       3.219  -2.513  13.641  1.00 18.68           C  
ATOM   1082  CG  TYR A 128       2.782  -2.032  14.994  1.00 17.09           C  
ATOM   1083  CD1 TYR A 128       3.664  -1.388  15.842  1.00 21.07           C  
ATOM   1084  CD2 TYR A 128       1.490  -2.227  15.434  1.00 22.44           C  
ATOM   1085  CE1 TYR A 128       3.265  -0.944  17.095  1.00 18.94           C  
ATOM   1086  CE2 TYR A 128       1.083  -1.780  16.693  1.00 21.22           C  
ATOM   1087  CZ  TYR A 128       1.979  -1.138  17.499  1.00 25.57           C  
ATOM   1088  OH  TYR A 128       1.611  -0.682  18.745  1.00 26.47           O  
ATOM   1089  N   PRO A 129       4.954   0.484  13.128  1.00 19.00           N  
ATOM   1090  CA  PRO A 129       6.257   1.113  13.234  1.00 20.50           C  
ATOM   1091  C   PRO A 129       7.123   0.476  14.298  1.00 21.63           C  
ATOM   1092  O   PRO A 129       6.637   0.133  15.388  1.00 22.84           O  
ATOM   1093  CB  PRO A 129       5.928   2.555  13.620  1.00 22.23           C  
ATOM   1094  CG  PRO A 129       4.608   2.510  14.205  1.00 23.29           C  
ATOM   1095  CD  PRO A 129       3.874   1.434  13.420  1.00 20.63           C  
ATOM   1096  N   GLY A 130       8.404   0.307  13.975  1.00 20.82           N  
ATOM   1097  CA  GLY A 130       9.376  -0.267  14.910  1.00 21.21           C  
ATOM   1098  C   GLY A 130       9.503  -1.781  14.965  1.00 22.51           C  
ATOM   1099  O   GLY A 130      10.404  -2.304  15.599  1.00 24.68           O  
ATOM   1100  N   LYS A 131       8.609  -2.507  14.321  1.00 20.10           N  
ATOM   1101  CA  LYS A 131       8.706  -3.940  14.311  1.00 20.50           C  
ATOM   1102  C   LYS A 131       9.671  -4.341  13.211  1.00 22.39           C  
ATOM   1103  O   LYS A 131       9.998  -3.533  12.386  1.00 18.81           O  
ATOM   1104  CB  LYS A 131       7.317  -4.554  14.071  1.00 21.81           C  
ATOM   1105  CG  LYS A 131       6.298  -4.190  15.140  1.00 24.68           C  
ATOM   1106  CD  LYS A 131       6.740  -4.560  16.528  1.00 34.13           C  
ATOM   1107  CE  LYS A 131       5.602  -4.382  17.535  1.00 41.24           C  
ATOM   1108  NZ  LYS A 131       5.902  -5.069  18.815  1.00 36.23           N  
ATOM   1109  N   PRO A 132      10.115  -5.611  13.188  1.00 20.31           N  
ATOM   1110  CA  PRO A 132      10.987  -6.083  12.110  1.00 20.91           C  
ATOM   1111  C   PRO A 132      10.483  -5.754  10.719  1.00 17.95           C  
ATOM   1112  O   PRO A 132       9.306  -5.952  10.429  1.00 22.36           O  
ATOM   1113  CB  PRO A 132      10.989  -7.600  12.334  1.00 23.22           C  
ATOM   1114  CG  PRO A 132      10.941  -7.691  13.867  1.00 24.10           C  
ATOM   1115  CD  PRO A 132       9.878  -6.682  14.190  1.00 22.49           C  
ATOM   1116  N   ARG A 133      11.368  -5.258   9.863  1.00 17.74           N  
ATOM   1117  CA  ARG A 133      10.985  -4.683   8.574  1.00 15.74           C  
ATOM   1118  C   ARG A 133      10.304  -5.737   7.704  1.00 19.26           C  
ATOM   1119  O   ARG A 133      10.863  -6.814   7.470  1.00 20.99           O  
ATOM   1120  CB  ARG A 133      12.208  -4.142   7.845  1.00 18.97           C  
ATOM   1121  CG  ARG A 133      11.937  -3.668   6.394  1.00 19.90           C  
ATOM   1122  CD  ARG A 133      10.801  -2.701   6.315  1.00 17.48           C  
ATOM   1123  NE  ARG A 133      10.524  -2.327   4.950  1.00 16.15           N  
ATOM   1124  CZ  ARG A 133      10.969  -1.256   4.317  1.00 22.81           C  
ATOM   1125  NH1 ARG A 133      11.795  -0.407   4.917  1.00 22.43           N  
ATOM   1126  NH2 ARG A 133      10.573  -1.048   3.058  1.00 25.84           N  
ATOM   1127  N   ILE A 134       9.079  -5.439   7.277  1.00 19.36           N  
ATOM   1128  CA  ILE A 134       8.375  -6.240   6.279  1.00 18.11           C  
ATOM   1129  C   ILE A 134       9.116  -6.066   4.954  1.00 19.87           C  
ATOM   1130  O   ILE A 134       9.267  -4.948   4.478  1.00 19.25           O  
ATOM   1131  CB  ILE A 134       6.927  -5.771   6.160  1.00 19.39           C  
ATOM   1132  CG1 ILE A 134       6.154  -6.106   7.449  1.00 22.92           C  
ATOM   1133  CG2 ILE A 134       6.222  -6.414   4.939  1.00 23.26           C  
ATOM   1134  CD1 ILE A 134       6.036  -7.607   7.706  1.00 28.47           C  
ATOM   1135  N   LYS A 135       9.508  -7.177   4.328  1.00 22.78           N  
ATOM   1136  CA  LYS A 135      10.389  -7.116   3.144  1.00 27.22           C  
ATOM   1137  C   LYS A 135       9.634  -6.954   1.816  1.00 29.80           C  
ATOM   1138  O   LYS A 135      10.239  -6.554   0.810  1.00 29.88           O  
ATOM   1139  CB  LYS A 135      11.269  -8.350   3.058  1.00 26.96           C  
ATOM   1140  CG  LYS A 135      12.379  -8.402   4.105  1.00 25.39           C  
ATOM   1141  CD  LYS A 135      13.110  -9.759   4.004  1.00 31.68           C  
ATOM   1142  CE  LYS A 135      14.131  -9.947   5.112  1.00 40.66           C  
ATOM   1143  NZ  LYS A 135      13.479 -10.120   6.450  1.00 48.50           N  
ATOM   1144  N   GLU A 136       8.331  -7.214   1.814  1.00 29.27           N  
ATOM   1145  CA  GLU A 136       7.539  -7.082   0.594  1.00 32.36           C  
ATOM   1146  C   GLU A 136       7.073  -5.630   0.412  1.00 33.16           C  
ATOM   1147  O   GLU A 136       6.452  -5.042   1.306  1.00 33.14           O  
ATOM   1148  CB  GLU A 136       6.340  -8.032   0.615  1.00 33.81           C  
ATOM   1149  CG  GLU A 136       6.753  -9.507   0.552  1.00 36.72           C  
ATOM   1150  CD  GLU A 136       7.412 -10.018   1.842  1.00 45.25           C  
ATOM   1151  OE1 GLU A 136       7.102  -9.456   2.923  1.00 41.95           O  
ATOM   1152  OE2 GLU A 136       8.230 -10.982   1.769  1.00 39.02           O  
ATOM   1153  N   SER A 137       7.352  -5.066  -0.765  1.00 33.90           N  
ATOM   1154  CA  SER A 137       7.018  -3.670  -1.059  1.00 33.01           C  
ATOM   1155  C   SER A 137       5.510  -3.418  -0.985  1.00 31.78           C  
ATOM   1156  O   SER A 137       5.083  -2.290  -0.712  1.00 33.24           O  
ATOM   1157  N   GLY A 138       4.721  -4.466  -1.230  1.00 29.70           N  
ATOM   1158  CA  GLY A 138       3.263  -4.373  -1.219  1.00 28.29           C  
ATOM   1159  C   GLY A 138       2.666  -3.798   0.060  1.00 25.88           C  
ATOM   1160  O   GLY A 138       1.696  -3.041   0.006  1.00 26.12           O  
ATOM   1161  N   ALA A 139       3.264  -4.153   1.204  1.00 24.83           N  
ATOM   1162  CA  ALA A 139       2.799  -3.709   2.523  1.00 24.47           C  
ATOM   1163  C   ALA A 139       2.888  -2.199   2.669  1.00 21.89           C  
ATOM   1164  O   ALA A 139       2.211  -1.621   3.494  1.00 22.31           O  
ATOM   1165  CB  ALA A 139       3.617  -4.378   3.625  1.00 26.17           C  
ATOM   1166  N   PHE A 140       3.724  -1.564   1.847  1.00 21.83           N  
ATOM   1167  CA  PHE A 140       3.916  -0.118   1.881  1.00 19.71           C  
ATOM   1168  C   PHE A 140       3.170   0.624   0.784  1.00 20.47           C  
ATOM   1169  O   PHE A 140       3.283   1.851   0.683  1.00 23.61           O  
ATOM   1170  CB  PHE A 140       5.420   0.190   1.854  1.00 22.83           C  
ATOM   1171  CG  PHE A 140       6.098  -0.246   3.104  1.00 19.32           C  
ATOM   1172  CD1 PHE A 140       6.142   0.603   4.198  1.00 22.60           C  
ATOM   1173  CD2 PHE A 140       6.647  -1.520   3.227  1.00 19.89           C  
ATOM   1174  CE1 PHE A 140       6.707   0.211   5.386  1.00 20.74           C  
ATOM   1175  CE2 PHE A 140       7.200  -1.919   4.409  1.00 22.17           C  
ATOM   1176  CZ  PHE A 140       7.256  -1.029   5.496  1.00 22.73           C  
ATOM   1177  N   GLU A 141       2.351  -0.122   0.037  1.00 20.12           N  
ATOM   1178  CA  GLU A 141       1.552   0.394  -1.077  1.00 20.86           C  
ATOM   1179  C   GLU A 141       0.085   0.062  -0.890  1.00 17.75           C  
ATOM   1180  O   GLU A 141      -0.546  -0.448  -1.786  1.00 19.04           O  
ATOM   1181  CB  GLU A 141       2.038  -0.246  -2.395  1.00 20.16           C  
ATOM   1182  CG  GLU A 141       3.507   0.044  -2.689  1.00 25.36           C  
ATOM   1183  CD  GLU A 141       4.059  -0.686  -3.904  1.00 30.33           C  
ATOM   1184  OE1 GLU A 141       3.427  -1.647  -4.397  1.00 41.84           O  
ATOM   1185  OE2 GLU A 141       5.175  -0.312  -4.337  1.00 46.76           O  
ATOM   1186  N   PRO A 142      -0.471   0.381   0.306  1.00 18.67           N  
ATOM   1187  CA  PRO A 142      -1.899   0.103   0.482  1.00 20.82           C  
ATOM   1188  C   PRO A 142      -2.766   1.027  -0.365  1.00 17.27           C  
ATOM   1189  O   PRO A 142      -2.300   2.071  -0.795  1.00 19.32           O  
ATOM   1190  CB  PRO A 142      -2.110   0.394   1.971  1.00 23.14           C  
ATOM   1191  CG  PRO A 142      -1.149   1.410   2.282  1.00 24.38           C  
ATOM   1192  CD  PRO A 142       0.112   1.023   1.495  1.00 21.35           C  
ATOM   1193  N   SER A 143      -4.021   0.672  -0.592  1.00 16.33           N  
ATOM   1194  CA  SER A 143      -4.970   1.584  -1.249  1.00 17.25           C  
ATOM   1195  C   SER A 143      -5.164   2.777  -0.337  1.00 17.93           C  
ATOM   1196  O   SER A 143      -5.100   2.656   0.880  1.00 16.98           O  
ATOM   1197  CB  SER A 143      -6.299   0.885  -1.393  1.00 19.38           C  
ATOM   1198  OG  SER A 143      -7.127   1.501  -2.354  1.00 21.75           O  
ATOM   1199  N   PRO A 144      -5.414   3.961  -0.919  1.00 20.87           N  
ATOM   1200  CA  PRO A 144      -5.555   5.143  -0.073  1.00 19.90           C  
ATOM   1201  C   PRO A 144      -6.695   4.974   0.881  1.00 14.71           C  
ATOM   1202  O   PRO A 144      -7.719   4.431   0.518  1.00 18.35           O  
ATOM   1203  CB  PRO A 144      -6.003   6.228  -1.080  1.00 23.06           C  
ATOM   1204  CG  PRO A 144      -6.587   5.471  -2.225  1.00 29.04           C  
ATOM   1205  CD  PRO A 144      -5.666   4.293  -2.334  1.00 23.71           C  
ATOM   1206  N   PRO A 145      -6.539   5.470   2.113  1.00 13.93           N  
ATOM   1207  CA  PRO A 145      -7.683   5.453   2.993  1.00 14.17           C  
ATOM   1208  C   PRO A 145      -8.758   6.474   2.593  1.00 13.30           C  
ATOM   1209  O   PRO A 145      -8.537   7.354   1.741  1.00 15.27           O  
ATOM   1210  CB  PRO A 145      -7.076   5.776   4.348  1.00 15.93           C  
ATOM   1211  CG  PRO A 145      -5.986   6.615   4.040  1.00 16.71           C  
ATOM   1212  CD  PRO A 145      -5.378   6.055   2.765  1.00 16.38           C  
ATOM   1213  N   ASP A 146      -9.894   6.397   3.258  1.00 12.71           N  
ATOM   1214  CA  ASP A 146     -10.972   7.390   3.088  1.00 12.43           C  
ATOM   1215  C   ASP A 146     -10.384   8.785   3.326  1.00 12.81           C  
ATOM   1216  O   ASP A 146      -9.824   9.032   4.371  1.00 13.02           O  
ATOM   1217  CB  ASP A 146     -12.036   7.102   4.155  1.00 11.07           C  
ATOM   1218  CG  ASP A 146     -13.266   7.892   4.011  1.00 12.14           C  
ATOM   1219  OD1 ASP A 146     -13.151   9.081   3.674  1.00 15.27           O  
ATOM   1220  OD2 ASP A 146     -14.351   7.401   4.278  1.00 11.80           O  
ATOM   1221  N   PRO A 147     -10.481   9.682   2.337  1.00 12.74           N  
ATOM   1222  CA  PRO A 147      -9.850  10.989   2.495  1.00 13.85           C  
ATOM   1223  C   PRO A 147     -10.684  11.976   3.298  1.00 12.45           C  
ATOM   1224  O   PRO A 147     -10.219  13.080   3.604  1.00 13.94           O  
ATOM   1225  CB  PRO A 147      -9.710  11.460   1.044  1.00 15.15           C  
ATOM   1226  CG  PRO A 147     -10.887  10.837   0.342  1.00 14.57           C  
ATOM   1227  CD  PRO A 147     -10.973   9.458   0.957  1.00 13.55           C  
ATOM   1228  N   ILE A 148     -11.869  11.548   3.705  1.00 11.68           N  
ATOM   1229  CA  ILE A 148     -12.800  12.368   4.482  1.00 12.32           C  
ATOM   1230  C   ILE A 148     -12.736  12.016   5.982  1.00 12.42           C  
ATOM   1231  O   ILE A 148     -12.861  12.870   6.869  1.00 13.41           O  
ATOM   1232  CB  ILE A 148     -14.254  12.187   3.964  1.00 12.72           C  
ATOM   1233  CG1 ILE A 148     -14.324  12.546   2.490  1.00 17.96           C  
ATOM   1234  CG2 ILE A 148     -15.284  12.960   4.789  1.00 12.12           C  
ATOM   1235  CD1 ILE A 148     -13.870  13.912   2.174  1.00 22.06           C  
ATOM   1236  N   GLU A 149     -12.590  10.716   6.285  1.00 12.37           N  
ATOM   1237  CA  GLU A 149     -12.779  10.175   7.627  1.00 11.96           C  
ATOM   1238  C   GLU A 149     -11.488   9.587   8.147  1.00 12.21           C  
ATOM   1239  O   GLU A 149     -10.985   8.632   7.568  1.00 12.30           O  
ATOM   1240  CB  GLU A 149     -13.854   9.082   7.559  1.00 12.84           C  
ATOM   1241  CG  GLU A 149     -15.155   9.586   6.938  1.00 11.33           C  
ATOM   1242  CD  GLU A 149     -16.412   8.853   7.283  1.00 11.80           C  
ATOM   1243  OE1 GLU A 149     -16.412   7.907   8.104  1.00 13.21           O  
ATOM   1244  OE2 GLU A 149     -17.491   9.227   6.758  1.00 13.06           O  
ATOM   1245  N   PRO A 150     -10.906  10.120   9.214  1.00 12.73           N  
ATOM   1246  CA  PRO A 150      -9.605   9.664   9.681  1.00 12.71           C  
ATOM   1247  C   PRO A 150      -9.585   8.235  10.152  1.00 11.14           C  
ATOM   1248  O   PRO A 150     -10.544   7.762  10.739  1.00 13.40           O  
ATOM   1249  CB  PRO A 150      -9.254  10.634  10.819  1.00 14.43           C  
ATOM   1250  CG  PRO A 150     -10.523  11.262  11.214  1.00 16.47           C  
ATOM   1251  CD  PRO A 150     -11.421  11.267  10.006  1.00 14.38           C  
ATOM   1252  N   VAL A 151      -8.441   7.565   9.940  1.00 13.49           N  
ATOM   1253  CA  VAL A 151      -8.265   6.198  10.415  1.00 13.03           C  
ATOM   1254  C   VAL A 151      -7.949   6.212  11.913  1.00 13.49           C  
ATOM   1255  O   VAL A 151      -7.493   7.219  12.439  1.00 13.40           O  
ATOM   1256  CB  VAL A 151      -7.163   5.486   9.590  1.00 13.67           C  
ATOM   1257  CG1 VAL A 151      -7.565   5.375   8.111  1.00 16.20           C  
ATOM   1258  CG2 VAL A 151      -5.836   6.193   9.763  1.00 12.85           C  
ATOM   1259  N   PRO A 152      -8.213   5.102  12.600  1.00 14.78           N  
ATOM   1260  CA  PRO A 152      -8.123   5.117  14.053  1.00 15.19           C  
ATOM   1261  C   PRO A 152      -6.758   5.383  14.605  1.00 15.86           C  
ATOM   1262  O   PRO A 152      -6.658   5.920  15.696  1.00 20.84           O  
ATOM   1263  CB  PRO A 152      -8.561   3.720  14.456  1.00 15.77           C  
ATOM   1264  CG  PRO A 152      -9.318   3.194  13.319  1.00 18.43           C  
ATOM   1265  CD  PRO A 152      -8.793   3.850  12.097  1.00 15.19           C  
ATOM   1266  N   ASN A 153      -5.700   5.109  13.844  1.00 13.95           N  
ATOM   1267  CA  ASN A 153      -4.356   5.358  14.314  1.00 16.05           C  
ATOM   1268  C   ASN A 153      -3.827   6.748  13.937  1.00 17.07           C  
ATOM   1269  O   ASN A 153      -2.684   7.063  14.225  1.00 17.29           O  
ATOM   1270  CB  ASN A 153      -3.390   4.301  13.833  1.00 16.08           C  
ATOM   1271  CG  ASN A 153      -3.367   4.131  12.328  1.00 18.46           C  
ATOM   1272  OD1 ASN A 153      -4.417   3.912  11.705  1.00 20.08           O  
ATOM   1273  ND2 ASN A 153      -2.186   4.145  11.741  1.00 21.23           N  
ATOM   1274  N   PHE A 154      -4.650   7.561  13.299  1.00 14.69           N  
ATOM   1275  CA  PHE A 154      -4.287   8.953  13.038  1.00 14.10           C  
ATOM   1276  C   PHE A 154      -4.529   9.842  14.231  1.00 14.30           C  
ATOM   1277  O   PHE A 154      -5.659   9.900  14.736  1.00 14.77           O  
ATOM   1278  CB  PHE A 154      -5.157   9.491  11.900  1.00 12.61           C  
ATOM   1279  CG  PHE A 154      -4.900  10.951  11.607  1.00 14.95           C  
ATOM   1280  CD1 PHE A 154      -3.711  11.360  10.980  1.00 13.20           C  
ATOM   1281  CD2 PHE A 154      -5.852  11.927  11.896  1.00 13.33           C  
ATOM   1282  CE1 PHE A 154      -3.474  12.694  10.717  1.00 14.23           C  
ATOM   1283  CE2 PHE A 154      -5.587  13.261  11.665  1.00 13.13           C  
ATOM   1284  CZ  PHE A 154      -4.426  13.643  11.051  1.00 13.56           C  
ATOM   1285  N   CYS A 155      -3.483  10.590  14.650  1.00 14.22           N  
ATOM   1286  CA  CYS A 155      -3.599  11.579  15.684  1.00 13.54           C  
ATOM   1287  C   CYS A 155      -3.215  12.945  15.193  1.00 16.40           C  
ATOM   1288  O   CYS A 155      -2.264  13.117  14.416  1.00 15.84           O  
ATOM   1289  CB  CYS A 155      -2.597  11.307  16.766  1.00 16.50           C  
ATOM   1290  SG  CYS A 155      -2.800   9.774  17.560  1.00 21.76           S  
ATOM   1291  N   LEU A 156      -3.961  13.928  15.674  1.00 13.91           N  
ATOM   1292  CA  LEU A 156      -3.572  15.348  15.636  1.00 16.23           C  
ATOM   1293  C   LEU A 156      -2.876  15.624  16.988  1.00 15.15           C  
ATOM   1294  O   LEU A 156      -3.352  15.300  18.051  1.00 17.84           O  
ATOM   1295  CB  LEU A 156      -4.791  16.267  15.495  1.00 14.66           C  
ATOM   1296  CG  LEU A 156      -4.518  17.776  15.654  1.00 15.39           C  
ATOM   1297  CD1 LEU A 156      -3.549  18.331  14.617  1.00 16.45           C  
ATOM   1298  CD2 LEU A 156      -5.871  18.538  15.579  1.00 17.48           C  
ATOM   1299  N   LEU A 157      -1.698  16.185  16.904  1.00 14.78           N  
ATOM   1300  CA  LEU A 157      -0.900  16.559  18.090  1.00 15.97           C  
ATOM   1301  C   LEU A 157      -0.800  18.076  18.120  1.00 15.59           C  
ATOM   1302  O   LEU A 157      -0.370  18.695  17.121  1.00 16.73           O  
ATOM   1303  CB  LEU A 157       0.443  15.864  18.009  1.00 16.46           C  
ATOM   1304  CG  LEU A 157       1.443  16.155  19.088  1.00 19.40           C  
ATOM   1305  CD1 LEU A 157       0.872  15.735  20.454  1.00 19.90           C  
ATOM   1306  CD2 LEU A 157       2.761  15.381  18.746  1.00 21.38           C  
ATOM   1307  N   LEU A 158      -1.229  18.685  19.217  1.00 14.79           N  
ATOM   1308  CA  LEU A 158      -1.118  20.141  19.420  1.00 15.96           C  
ATOM   1309  C   LEU A 158      -0.093  20.437  20.492  1.00 16.26           C  
ATOM   1310  O   LEU A 158      -0.109  19.775  21.539  1.00 16.87           O  
ATOM   1311  CB  LEU A 158      -2.436  20.690  19.866  1.00 16.32           C  
ATOM   1312  CG  LEU A 158      -3.587  20.488  18.901  1.00 14.97           C  
ATOM   1313  CD1 LEU A 158      -4.913  20.976  19.599  1.00 18.88           C  
ATOM   1314  CD2 LEU A 158      -3.406  21.151  17.524  1.00 16.51           C  
ATOM   1315  N   LEU A 159       0.713  21.469  20.280  1.00 15.27           N  
ATOM   1316  CA  LEU A 159       1.562  22.055  21.299  1.00 15.45           C  
ATOM   1317  C   LEU A 159       1.092  23.467  21.608  1.00 14.93           C  
ATOM   1318  O   LEU A 159       0.933  24.295  20.701  1.00 16.61           O  
ATOM   1319  CB  LEU A 159       3.014  22.083  20.817  1.00 14.98           C  
ATOM   1320  CG  LEU A 159       3.943  22.803  21.808  1.00 19.52           C  
ATOM   1321  CD1 LEU A 159       4.147  21.971  23.002  1.00 20.26           C  
ATOM   1322  CD2 LEU A 159       5.300  23.067  21.072  1.00 24.12           C  
ATOM   1323  N   ASP A 160       0.870  23.728  22.894  1.00 16.21           N  
ATOM   1324  CA  ASP A 160       0.496  25.064  23.394  1.00 16.54           C  
ATOM   1325  C   ASP A 160       1.673  25.671  24.145  1.00 16.70           C  
ATOM   1326  O   ASP A 160       1.871  25.334  25.321  1.00 17.12           O  
ATOM   1327  CB  ASP A 160      -0.698  24.993  24.336  1.00 18.32           C  
ATOM   1328  CG  ASP A 160      -1.261  26.400  24.670  1.00 20.93           C  
ATOM   1329  OD1 ASP A 160      -1.137  27.347  23.838  1.00 30.29           O  
ATOM   1330  OD2 ASP A 160      -1.936  26.489  25.709  1.00 35.80           O  
ATOM   1331  N   PRO A 161       2.472  26.517  23.465  1.00 17.31           N  
ATOM   1332  CA  PRO A 161       3.645  27.033  24.166  1.00 14.70           C  
ATOM   1333  C   PRO A 161       3.333  27.913  25.371  1.00 16.11           C  
ATOM   1334  O   PRO A 161       2.457  28.764  25.303  1.00 16.75           O  
ATOM   1335  CB  PRO A 161       4.352  27.865  23.099  1.00 16.27           C  
ATOM   1336  CG  PRO A 161       3.886  27.319  21.794  1.00 17.84           C  
ATOM   1337  CD  PRO A 161       2.437  27.005  22.069  1.00 18.23           C  
ATOM   1338  N   VAL A 162       4.054  27.657  26.451  1.00 14.35           N  
ATOM   1339  CA  VAL A 162       4.027  28.617  27.541  0.50 13.51           C  
ATOM   1341  C   VAL A 162       5.360  29.304  27.772  1.00 15.71           C  
ATOM   1342  O   VAL A 162       5.412  30.293  28.485  1.00 15.45           O  
ATOM   1343  CB  VAL A 162       3.482  28.011  28.845  0.50 12.94           C  
ATOM   1345  CG1 VAL A 162       2.107  27.446  28.626  0.50 17.08           C  
ATOM   1347  CG2 VAL A 162       4.432  26.964  29.396  0.50 20.10           C  
ATOM   1349  N   GLN A 163       6.420  28.848  27.113  1.00 14.36           N  
ATOM   1350  CA  GLN A 163       7.690  29.522  27.171  1.00 13.93           C  
ATOM   1351  C   GLN A 163       8.336  29.402  25.809  1.00 13.91           C  
ATOM   1352  O   GLN A 163       8.337  28.308  25.222  1.00 15.23           O  
ATOM   1353  CB  GLN A 163       8.632  28.943  28.235  1.00 17.34           C  
ATOM   1354  CG  GLN A 163       9.892  29.784  28.458  1.00 19.55           C  
ATOM   1355  CD  GLN A 163      10.586  29.574  29.786  1.00 26.51           C  
ATOM   1356  OE1 GLN A 163      11.768  29.243  29.828  1.00 31.74           O  
ATOM   1357  NE2 GLN A 163       9.871  29.807  30.871  1.00 26.41           N  
ATOM   1358  N   VAL A 164       8.875  30.513  25.296  1.00 13.60           N  
ATOM   1359  CA  VAL A 164       9.535  30.541  24.003  1.00 13.57           C  
ATOM   1360  C   VAL A 164      10.871  31.276  24.156  1.00 14.74           C  
ATOM   1361  O   VAL A 164      10.907  32.373  24.723  1.00 16.10           O  
ATOM   1362  CB  VAL A 164       8.655  31.216  22.950  1.00 13.83           C  
ATOM   1363  CG1 VAL A 164       9.404  31.374  21.597  1.00 14.89           C  
ATOM   1364  CG2 VAL A 164       7.359  30.423  22.779  1.00 15.28           C  
ATOM   1365  N   ASP A 165      11.954  30.699  23.660  1.00 14.37           N  
ATOM   1366  CA  ASP A 165      13.326  31.296  23.659  1.00 14.19           C  
ATOM   1367  C   ASP A 165      13.689  31.451  22.195  1.00 15.63           C  
ATOM   1368  O   ASP A 165      13.767  30.446  21.460  1.00 17.22           O  
ATOM   1369  CB  ASP A 165      14.224  30.291  24.385  1.00 15.31           C  
ATOM   1370  CG  ASP A 165      15.664  30.705  24.583  1.00 25.14           C  
ATOM   1371  OD1 ASP A 165      16.134  31.666  24.007  1.00 29.15           O  
ATOM   1372  OD2 ASP A 165      16.351  29.928  25.304  1.00 31.78           O  
ATOM   1373  N   HIS A 166      13.851  32.676  21.735  1.00 12.87           N  
ATOM   1374  CA  HIS A 166      14.214  32.988  20.356  1.00 12.64           C  
ATOM   1375  C   HIS A 166      15.626  33.532  20.280  1.00 12.80           C  
ATOM   1376  O   HIS A 166      15.905  34.584  20.854  1.00 13.49           O  
ATOM   1377  CB  HIS A 166      13.241  34.017  19.818  1.00 14.06           C  
ATOM   1378  CG  HIS A 166      13.478  34.406  18.397  1.00 15.32           C  
ATOM   1379  ND1 HIS A 166      13.123  35.653  17.912  1.00 16.71           N  
ATOM   1380  CD2 HIS A 166      13.991  33.714  17.348  1.00 14.81           C  
ATOM   1381  CE1 HIS A 166      13.427  35.715  16.626  1.00 18.85           C  
ATOM   1382  NE2 HIS A 166      13.953  34.550  16.256  1.00 16.39           N  
ATOM   1383  N   LEU A 167      16.500  32.837  19.571  1.00 13.52           N  
ATOM   1384  CA  LEU A 167      17.900  33.178  19.428  1.00 12.68           C  
ATOM   1385  C   LEU A 167      18.141  33.520  17.960  1.00 13.50           C  
ATOM   1386  O   LEU A 167      17.849  32.715  17.074  1.00 14.22           O  
ATOM   1387  CB  LEU A 167      18.765  31.992  19.828  1.00 13.78           C  
ATOM   1388  CG  LEU A 167      20.271  32.153  19.635  1.00 15.55           C  
ATOM   1389  CD1 LEU A 167      20.828  33.235  20.557  1.00 15.91           C  
ATOM   1390  CD2 LEU A 167      20.965  30.822  19.898  1.00 16.23           C  
ATOM   1391  N   GLU A 168      18.648  34.728  17.727  1.00 14.54           N  
ATOM   1392  CA  GLU A 168      19.052  35.217  16.407  1.00 13.99           C  
ATOM   1393  C   GLU A 168      20.571  35.247  16.362  1.00 15.94           C  
ATOM   1394  O   GLU A 168      21.193  36.036  17.073  1.00 15.92           O  
ATOM   1395  CB  GLU A 168      18.495  36.621  16.182  1.00 16.35           C  
ATOM   1396  CG  GLU A 168      17.017  36.623  15.977  1.00 18.69           C  
ATOM   1397  CD  GLU A 168      16.437  37.996  15.755  1.00 28.39           C  
ATOM   1398  OE1 GLU A 168      17.054  38.988  16.186  1.00 32.52           O  
ATOM   1399  OE2 GLU A 168      15.349  38.060  15.145  1.00 29.97           O  
ATOM   1400  N   LEU A 169      21.181  34.413  15.524  1.00 15.43           N  
ATOM   1401  CA  LEU A 169      22.626  34.430  15.426  1.00 15.89           C  
ATOM   1402  C   LEU A 169      23.116  35.619  14.629  1.00 18.49           C  
ATOM   1403  O   LEU A 169      24.304  35.959  14.747  1.00 18.52           O  
ATOM   1404  CB  LEU A 169      23.142  33.139  14.823  1.00 15.73           C  
ATOM   1405  CG  LEU A 169      22.811  31.882  15.621  1.00 16.49           C  
ATOM   1406  CD1 LEU A 169      23.362  30.642  14.883  1.00 20.87           C  
ATOM   1407  CD2 LEU A 169      23.341  31.943  17.047  1.00 18.62           C  
ATOM   1408  N   ARG A 170      22.275  36.222  13.801  1.00 18.37           N  
ATOM   1409  CA  ARG A 170      22.643  37.425  13.041  0.50 22.54           C  
ATOM   1411  C   ARG A 170      22.223  38.653  13.829  1.00 23.25           C  
ATOM   1412  O   ARG A 170      21.264  39.323  13.454  1.00 27.36           O  
ATOM   1413  CB  ARG A 170      21.937  37.471  11.679  0.50 23.72           C  
ATOM   1415  CG  ARG A 170      22.389  36.430  10.680  0.50 29.68           C  
ATOM   1417  CD  ARG A 170      21.215  35.702  10.020  0.50 34.16           C  
ATOM   1419  NE  ARG A 170      20.579  36.359   8.872  0.50 30.32           N  
ATOM   1421  CZ  ARG A 170      19.292  36.695   8.769  0.50 28.03           C  
ATOM   1423  NH1 ARG A 170      18.437  36.481   9.759  0.50 37.00           N  
ATOM   1425  NH2 ARG A 170      18.845  37.263   7.653  0.50 32.21           N  
ATOM   1427  N   GLY A 171      22.923  38.944  14.914  1.00 23.68           N  
ATOM   1428  CA  GLY A 171      22.602  40.088  15.784  1.00 23.75           C  
ATOM   1429  C   GLY A 171      23.794  40.991  15.998  1.00 23.48           C  
ATOM   1430  O   GLY A 171      24.655  41.136  15.134  1.00 24.63           O  
ATOM   1431  N   GLU A 172      23.875  41.583  17.188  1.00 25.82           N  
ATOM   1432  CA  GLU A 172      24.953  42.503  17.512  1.00 28.91           C  
ATOM   1433  C   GLU A 172      25.565  42.175  18.882  1.00 28.79           C  
ATOM   1434  O   GLU A 172      25.509  42.989  19.814  1.00 31.27           O  
ATOM   1435  CB  GLU A 172      24.448  43.960  17.439  1.00 33.05           C  
ATOM   1436  CG  GLU A 172      24.213  44.442  15.988  1.00 34.19           C  
ATOM   1437  N   PRO A 173      26.196  40.999  19.000  1.00 22.40           N  
ATOM   1438  CA  PRO A 173      26.474  40.017  17.951  1.00 21.24           C  
ATOM   1439  C   PRO A 173      25.372  38.960  17.721  1.00 20.28           C  
ATOM   1440  O   PRO A 173      25.281  38.376  16.617  1.00 19.27           O  
ATOM   1441  CB  PRO A 173      27.755  39.341  18.461  1.00 23.76           C  
ATOM   1442  CG  PRO A 173      27.695  39.451  19.938  1.00 25.16           C  
ATOM   1443  CD  PRO A 173      26.816  40.635  20.291  1.00 23.50           C  
ATOM   1444  N   GLN A 174      24.593  38.699  18.761  1.00 19.09           N  
ATOM   1445  CA  GLN A 174      23.442  37.799  18.714  1.00 16.74           C  
ATOM   1446  C   GLN A 174      22.374  38.393  19.567  1.00 17.73           C  
ATOM   1447  O   GLN A 174      22.680  39.182  20.472  1.00 19.70           O  
ATOM   1448  CB  GLN A 174      23.779  36.430  19.287  1.00 17.35           C  
ATOM   1449  CG  GLN A 174      24.940  35.749  18.597  1.00 17.73           C  
ATOM   1450  CD  GLN A 174      25.208  34.321  19.113  1.00 18.71           C  
ATOM   1451  OE1 GLN A 174      26.098  33.608  18.620  1.00 20.59           O  
ATOM   1452  NE2 GLN A 174      24.444  33.911  20.137  1.00 20.62           N  
ATOM   1453  N   ASN A 175      21.122  38.073  19.287  1.00 18.17           N  
ATOM   1454  CA  ASN A 175      19.993  38.556  20.083  1.00 18.24           C  
ATOM   1455  C   ASN A 175      19.256  37.338  20.632  1.00 16.38           C  
ATOM   1456  O   ASN A 175      19.105  36.340  19.929  1.00 17.04           O  
ATOM   1457  CB  ASN A 175      19.012  39.367  19.219  1.00 18.12           C  
ATOM   1458  CG  ASN A 175      19.679  40.515  18.470  1.00 28.90           C  
ATOM   1459  OD1 ASN A 175      20.491  41.200  19.029  1.00 32.27           O  
ATOM   1460  ND2 ASN A 175      19.323  40.712  17.198  1.00 28.91           N  
ATOM   1461  N   ARG A 176      18.829  37.396  21.880  1.00 16.02           N  
ATOM   1462  CA  ARG A 176      18.061  36.330  22.491  1.00 15.12           C  
ATOM   1463  C   ARG A 176      16.943  36.935  23.316  1.00 16.20           C  
ATOM   1464  O   ARG A 176      17.177  37.867  24.098  1.00 16.46           O  
ATOM   1465  CB  ARG A 176      18.988  35.508  23.363  1.00 15.81           C  
ATOM   1466  CG  ARG A 176      18.372  34.200  23.831  1.00 16.60           C  
ATOM   1467  CD  ARG A 176      19.348  33.397  24.581  1.00 18.00           C  
ATOM   1468  NE  ARG A 176      18.786  32.181  25.152  1.00 19.60           N  
ATOM   1469  CZ  ARG A 176      19.342  31.522  26.168  1.00 22.52           C  
ATOM   1470  NH1 ARG A 176      20.467  31.969  26.689  1.00 22.52           N  
ATOM   1471  NH2 ARG A 176      18.785  30.435  26.662  1.00 21.92           N  
ATOM   1472  N   TRP A 177      15.728  36.442  23.102  1.00 16.70           N  
ATOM   1473  CA  TRP A 177      14.535  36.901  23.779  1.00 16.22           C  
ATOM   1474  C   TRP A 177      13.813  35.727  24.378  1.00 16.80           C  
ATOM   1475  O   TRP A 177      13.674  34.692  23.727  1.00 16.09           O  
ATOM   1476  CB  TRP A 177      13.602  37.615  22.806  1.00 18.84           C  
ATOM   1477  CG  TRP A 177      14.005  38.969  22.503  1.00 24.48           C  
ATOM   1478  CD1 TRP A 177      14.874  39.377  21.535  1.00 28.21           C  
ATOM   1479  CD2 TRP A 177      13.554  40.158  23.162  1.00 24.71           C  
ATOM   1480  NE1 TRP A 177      15.013  40.749  21.577  1.00 31.48           N  
ATOM   1481  CE2 TRP A 177      14.207  41.245  22.559  1.00 27.00           C  
ATOM   1482  CE3 TRP A 177      12.657  40.405  24.205  1.00 29.59           C  
ATOM   1483  CZ2 TRP A 177      13.981  42.575  22.965  1.00 30.80           C  
ATOM   1484  CZ3 TRP A 177      12.438  41.719  24.613  1.00 32.90           C  
ATOM   1485  CH2 TRP A 177      13.102  42.782  23.995  1.00 28.96           C  
ATOM   1486  N   LEU A 178      13.337  35.891  25.607  1.00 15.00           N  
ATOM   1487  CA  LEU A 178      12.556  34.913  26.306  1.00 14.47           C  
ATOM   1488  C   LEU A 178      11.154  35.447  26.479  1.00 16.28           C  
ATOM   1489  O   LEU A 178      10.957  36.579  26.906  1.00 16.48           O  
ATOM   1490  CB  LEU A 178      13.169  34.642  27.675  1.00 16.25           C  
ATOM   1491  CG  LEU A 178      12.654  33.529  28.542  1.00 22.41           C  
ATOM   1492  CD1 LEU A 178      12.782  32.133  27.872  1.00 26.96           C  
ATOM   1493  CD2 LEU A 178      13.444  33.622  29.890  1.00 25.46           C  
ATOM   1494  N   TYR A 179      10.181  34.608  26.188  1.00 14.95           N  
ATOM   1495  CA  TYR A 179       8.768  34.932  26.340  1.00 14.83           C  
ATOM   1496  C   TYR A 179       8.180  33.917  27.304  1.00 14.59           C  
ATOM   1497  O   TYR A 179       8.432  32.718  27.188  1.00 15.06           O  
ATOM   1498  CB  TYR A 179       8.063  34.805  24.988  1.00 13.91           C  
ATOM   1499  CG  TYR A 179       8.553  35.668  23.864  1.00 13.75           C  
ATOM   1500  CD1 TYR A 179       9.630  35.287  23.093  1.00 16.32           C  
ATOM   1501  CD2 TYR A 179       7.902  36.882  23.584  1.00 16.53           C  
ATOM   1502  CE1 TYR A 179      10.069  36.060  22.073  1.00 17.22           C  
ATOM   1503  CE2 TYR A 179       8.325  37.667  22.542  1.00 22.68           C  
ATOM   1504  CZ  TYR A 179       9.409  37.248  21.782  1.00 21.57           C  
ATOM   1505  OH  TYR A 179       9.872  38.054  20.748  1.00 23.22           O  
ATOM   1506  N   HIS A 180       7.350  34.366  28.241  1.00 14.19           N  
ATOM   1507  CA  HIS A 180       6.703  33.466  29.197  1.00 14.74           C  
ATOM   1508  C   HIS A 180       5.223  33.825  29.379  1.00 16.40           C  
ATOM   1509  O   HIS A 180       4.885  34.984  29.439  1.00 17.93           O  
ATOM   1510  CB  HIS A 180       7.455  33.504  30.524  1.00 20.64           C  
ATOM   1511  CG  HIS A 180       6.879  32.600  31.563  1.00 25.98           C  
ATOM   1512  ND1 HIS A 180       7.095  31.239  31.581  1.00 38.14           N  
ATOM   1513  CD2 HIS A 180       6.044  32.865  32.596  1.00 29.78           C  
ATOM   1514  CE1 HIS A 180       6.417  30.706  32.585  1.00 36.68           C  
ATOM   1515  NE2 HIS A 180       5.783  31.674  33.224  1.00 32.90           N  
ATOM   1516  N   ARG A 181       4.377  32.810  29.464  1.00 15.63           N  
ATOM   1517  CA  ARG A 181       2.945  32.977  29.677  1.00 17.43           C  
ATOM   1518  C   ARG A 181       2.628  32.638  31.132  1.00 20.05           C  
ATOM   1519  O   ARG A 181       3.036  31.577  31.615  1.00 20.18           O  
ATOM   1520  CB  ARG A 181       2.154  32.051  28.757  1.00 17.47           C  
ATOM   1521  CG  ARG A 181       0.714  32.464  28.674  1.00 20.70           C  
ATOM   1522  CD  ARG A 181      -0.062  31.624  27.795  1.00 19.06           C  
ATOM   1523  NE  ARG A 181      -0.266  30.292  28.358  1.00 21.23           N  
ATOM   1524  CZ  ARG A 181      -0.761  29.283  27.651  1.00 30.41           C  
ATOM   1525  NH1 ARG A 181      -1.045  29.470  26.372  1.00 29.17           N  
ATOM   1526  NH2 ARG A 181      -0.946  28.101  28.213  1.00 33.80           N  
ATOM   1527  N   ASN A 182       1.947  33.550  31.826  1.00 23.13           N  
ATOM   1528  CA  ASN A 182       1.641  33.312  33.238  1.00 24.77           C  
ATOM   1529  C   ASN A 182       0.316  32.574  33.388  1.00 28.59           C  
ATOM   1530  O   ASN A 182      -0.300  32.145  32.395  1.00 24.60           O  
ATOM   1531  CB  ASN A 182       1.713  34.635  34.034  1.00 27.50           C  
ATOM   1532  CG  ASN A 182       0.615  35.635  33.684  1.00 28.66           C  
ATOM   1533  OD1 ASN A 182      -0.376  35.315  33.057  1.00 22.70           O  
ATOM   1534  ND2 ASN A 182       0.822  36.884  34.105  1.00 31.00           N  
ATOM   1535  N   ASP A 183      -0.108  32.404  34.641  1.00 30.90           N  
ATOM   1536  CA  ASP A 183      -1.360  31.710  34.952  1.00 35.13           C  
ATOM   1537  C   ASP A 183      -2.624  32.409  34.442  1.00 34.36           C  
ATOM   1538  O   ASP A 183      -3.664  31.756  34.269  1.00 36.50           O  
ATOM   1539  CB  ASP A 183      -1.485  31.529  36.467  1.00 38.87           C  
ATOM   1540  CG  ASP A 183      -1.611  32.848  37.199  1.00 45.78           C  
ATOM   1541  OD1 ASP A 183      -0.696  33.693  37.063  1.00 51.82           O  
ATOM   1542  OD2 ASP A 183      -2.622  33.041  37.918  1.00 60.39           O  
ATOM   1543  N   GLN A 184      -2.538  33.722  34.215  1.00 32.92           N  
ATOM   1544  CA  GLN A 184      -3.636  34.509  33.603  1.00 33.05           C  
ATOM   1545  C   GLN A 184      -3.610  34.560  32.082  1.00 32.33           C  
ATOM   1546  O   GLN A 184      -4.370  35.321  31.468  1.00 29.79           O  
ATOM   1547  CB  GLN A 184      -3.611  35.958  34.120  1.00 35.10           C  
ATOM   1548  CG  GLN A 184      -4.079  36.130  35.559  1.00 41.82           C  
ATOM   1549  CD  GLN A 184      -3.006  35.851  36.583  1.00 50.13           C  
ATOM   1550  OE1 GLN A 184      -1.809  36.005  36.318  1.00 56.20           O  
ATOM   1551  NE2 GLN A 184      -3.429  35.451  37.780  1.00 58.70           N  
ATOM   1552  N   GLN A 185      -2.721  33.768  31.469  1.00 29.20           N  
ATOM   1553  CA  GLN A 185      -2.597  33.681  30.010  1.00 26.97           C  
ATOM   1554  C   GLN A 185      -1.978  34.938  29.373  1.00 24.25           C  
ATOM   1555  O   GLN A 185      -2.063  35.144  28.167  1.00 27.23           O  
ATOM   1556  CB  GLN A 185      -3.901  33.284  29.348  1.00 29.97           C  
ATOM   1557  CG  GLN A 185      -4.399  31.897  29.784  1.00 33.22           C  
ATOM   1558  CD  GLN A 185      -3.513  30.758  29.283  1.00 38.74           C  
ATOM   1559  N   GLU A 186      -1.312  35.733  30.198  1.00 24.41           N  
ATOM   1560  CA  GLU A 186      -0.673  36.948  29.747  1.00 22.21           C  
ATOM   1561  C   GLU A 186       0.804  36.642  29.442  1.00 21.41           C  
ATOM   1562  O   GLU A 186       1.482  35.987  30.241  1.00 20.13           O  
ATOM   1563  CB  GLU A 186      -0.760  38.025  30.800  1.00 24.70           C  
ATOM   1564  CG  GLU A 186      -2.205  38.346  31.173  1.00 31.85           C  
ATOM   1565  CD  GLU A 186      -2.324  39.169  32.436  1.00 41.75           C  
ATOM   1566  OE1 GLU A 186      -1.408  39.126  33.290  1.00 44.54           O  
ATOM   1567  OE2 GLU A 186      -3.361  39.846  32.588  1.00 57.91           O  
ATOM   1568  N   TRP A 187       1.276  37.146  28.300  1.00 19.54           N  
ATOM   1569  CA  TRP A 187       2.682  36.979  27.909  1.00 19.21           C  
ATOM   1570  C   TRP A 187       3.551  38.140  28.369  1.00 21.09           C  
ATOM   1571  O   TRP A 187       3.130  39.306  28.357  1.00 25.52           O  
ATOM   1572  CB  TRP A 187       2.795  36.830  26.391  1.00 17.27           C  
ATOM   1573  CG  TRP A 187       2.333  35.539  25.885  1.00 17.18           C  
ATOM   1574  CD1 TRP A 187       1.064  35.222  25.433  1.00 17.10           C  
ATOM   1575  CD2 TRP A 187       3.103  34.331  25.770  1.00 15.46           C  
ATOM   1576  NE1 TRP A 187       1.027  33.901  25.061  1.00 18.19           N  
ATOM   1577  CE2 TRP A 187       2.265  33.337  25.256  1.00 15.76           C  
ATOM   1578  CE3 TRP A 187       4.440  34.007  26.057  1.00 16.74           C  
ATOM   1579  CZ2 TRP A 187       2.712  32.040  25.026  1.00 15.54           C  
ATOM   1580  CZ3 TRP A 187       4.886  32.719  25.834  1.00 14.35           C  
ATOM   1581  CH2 TRP A 187       4.029  31.755  25.328  1.00 13.78           C  
ATOM   1582  N   SER A 188       4.766  37.805  28.803  1.00 17.96           N  
ATOM   1583  CA  SER A 188       5.816  38.788  29.082  1.00 20.30           C  
ATOM   1584  C   SER A 188       7.020  38.423  28.237  1.00 18.30           C  
ATOM   1585  O   SER A 188       7.129  37.290  27.754  1.00 17.61           O  
ATOM   1586  CB  SER A 188       6.175  38.769  30.564  1.00 24.35           C  
ATOM   1587  OG  SER A 188       6.693  37.523  30.957  1.00 34.36           O  
ATOM   1588  N   SER A 189       7.858  39.407  27.948  1.00 17.36           N  
ATOM   1589  CA  SER A 189       9.103  39.142  27.239  1.00 17.56           C  
ATOM   1590  C   SER A 189      10.276  39.899  27.794  1.00 18.47           C  
ATOM   1591  O   SER A 189      10.106  40.933  28.439  1.00 19.02           O  
ATOM   1592  CB  SER A 189       8.955  39.438  25.779  1.00 21.43           C  
ATOM   1593  OG  SER A 189       8.791  40.791  25.541  1.00 26.83           O  
ATOM   1594  N   GLU A 190      11.472  39.377  27.561  1.00 17.48           N  
ATOM   1595  CA  GLU A 190      12.680  40.020  28.038  1.00 20.27           C  
ATOM   1596  C   GLU A 190      13.875  39.631  27.197  1.00 18.94           C  
ATOM   1597  O   GLU A 190      14.019  38.472  26.799  1.00 17.41           O  
ATOM   1598  CB  GLU A 190      12.980  39.713  29.499  1.00 23.48           C  
ATOM   1599  CG  GLU A 190      13.256  38.291  29.886  1.00 33.17           C  
ATOM   1600  CD  GLU A 190      13.964  38.177  31.247  1.00 33.15           C  
ATOM   1601  OE1 GLU A 190      14.537  39.181  31.722  1.00 45.13           O  
ATOM   1602  OE2 GLU A 190      13.944  37.064  31.830  1.00 48.08           O  
ATOM   1603  N   ALA A 191      14.701  40.604  26.895  1.00 18.25           N  
ATOM   1604  CA  ALA A 191      15.955  40.351  26.216  1.00 16.75           C  
ATOM   1605  C   ALA A 191      16.938  39.784  27.251  1.00 17.31           C  
ATOM   1606  O   ALA A 191      17.131  40.344  28.362  1.00 17.98           O  
ATOM   1607  CB  ALA A 191      16.490  41.647  25.589  1.00 18.33           C  
ATOM   1608  N   ILE A 192      17.618  38.697  26.854  1.00 15.04           N  
ATOM   1609  CA  ILE A 192      18.555  37.999  27.739  1.00 16.32           C  
ATOM   1610  C   ILE A 192      19.877  37.779  27.031  1.00 17.05           C  
ATOM   1611  O   ILE A 192      19.995  37.906  25.806  1.00 16.09           O  
ATOM   1612  CB  ILE A 192      18.000  36.662  28.259  1.00 16.34           C  
ATOM   1613  CG1 ILE A 192      17.540  35.738  27.112  1.00 17.68           C  
ATOM   1614  CG2 ILE A 192      16.779  36.913  29.197  1.00 17.33           C  
ATOM   1615  CD1 ILE A 192      17.304  34.260  27.472  1.00 18.37           C  
ATOM   1616  N   ASN A 193      20.919  37.500  27.807  1.00 16.06           N  
ATOM   1617  CA  ASN A 193      22.215  37.266  27.198  1.00 16.47           C  
ATOM   1618  C   ASN A 193      22.230  35.955  26.409  1.00 17.13           C  
ATOM   1619  O   ASN A 193      21.826  34.925  26.955  1.00 18.93           O  
ATOM   1620  CB  ASN A 193      23.321  37.217  28.256  1.00 16.04           C  
ATOM   1621  CG  ASN A 193      23.552  38.561  28.919  1.00 20.14           C  
ATOM   1622  OD1 ASN A 193      23.406  39.635  28.280  1.00 18.68           O  
ATOM   1623  ND2 ASN A 193      23.991  38.520  30.187  1.00 18.17           N  
ATOM   1624  N   PRO A 194      22.770  35.984  25.176  1.00 18.30           N  
ATOM   1625  CA  PRO A 194      22.892  34.746  24.406  1.00 22.93           C  
ATOM   1626  C   PRO A 194      23.545  33.592  25.169  1.00 31.79           C  
ATOM   1627  O   PRO A 194      24.517  33.802  25.889  1.00 32.36           O  
ATOM   1628  CB  PRO A 194      23.730  35.146  23.217  1.00 24.68           C  
ATOM   1629  CG  PRO A 194      23.718  36.614  23.151  1.00 28.18           C  
ATOM   1630  CD  PRO A 194      23.226  37.170  24.438  1.00 20.20           C  
ATOM   1631  OXT PRO A 194      23.074  32.424  25.123  1.00 34.86           O  
TER    1632      PRO A 194                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
