
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  153 ( 1166),  selected  153 , name 2iab_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2iab_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    P     5_A      -       -           -
LGA    A     6_A      M       1          5.648
LGA    R     7_A      A       2          2.847
LGA    T     8_A      D       3          2.659
LGA    A     9_A      P       4          2.414
LGA    K    10_A      K       5          2.435
LGA    Q    11_A      E       6          1.694
LGA    R    12_A      L       7          1.301
LGA    I    13_A      Q       8          1.938
LGA    Q    14_A      D       9          1.756
LGA    D    15_A      K      10          1.240
LGA    T    16_A      F      11          1.465
LGA    L    17_A      W      12          2.075
LGA    N    18_A      K      13          1.208
LGA    R    19_A      A      14          1.104
LGA    L    20_A      L      15          2.061
LGA    E    21_A      K      16          1.979
LGA    L    22_A      S      17          1.375
LGA    D    23_A      D      18          1.325
LGA    V    24_A      R      19          2.420
LGA    D    25_A      T      20          1.473
LGA    A    26_A      V      21          1.225
LGA    W    27_A      M      22          1.049
LGA    V    28_A      L      23          1.268
LGA    S    29_A      G      24          1.420
LGA    T    30_A      L      25          1.811
LGA    A    31_A      D      26          5.086
LGA    G    32_A      G      27           -
LGA    A    33_A      -       -           -
LGA    D    34_A      -       -           -
LGA    G    35_A      V      28          3.987
LGA    G    36_A      E      29          1.896
LGA    A    37_A      D      30          2.278
LGA    P    38_A      G      31          1.638
LGA    Y    39_A      H      32          1.545
LGA    L    40_A      A      33          0.690
LGA    V    41_A      R      34          0.590
LGA    P    42_A      P      35          0.396
LGA    L    43_A      M      36          0.825
LGA    S    44_A      T      37          0.949
LGA    Y    45_A      A      38          1.579
LGA    L    46_A      Q      39          0.320
LGA    W    47_A      I      40          1.694
LGA    D    48_A      E      41          2.434
LGA    -       -      G      42           -
LGA    -       -      D      43           -
LGA    G    49_A      S      44          2.587
LGA    E    50_A      G      45          2.632
LGA    T    51_A      G      46          1.958
LGA    -       -      P      47           -
LGA    F    52_A      I      48          0.592
LGA    L    53_A      W      49          0.523
LGA    V    54_A      F      50          0.378
LGA    A    55_A      F      51          1.796
LGA    T    56_A      T      52          1.662
LGA    P    57_A      S      53          1.703
LGA    A    58_A      K      54          2.148
LGA    A    59_A      D      55          2.091
LGA    S    60_A      N      56          1.463
LGA    P    61_A      A      57          0.971
LGA    T    62_A      L      58          2.346
LGA    G    63_A      I      59          2.132
LGA    R    64_A      A      60          2.384
LGA    N    65_A      M      61          3.111
LGA    L    66_A      L      62          3.257
LGA    S    67_A      G      63          3.928
LGA    E    68_A      Q      64           #
LGA    T    69_A      G      65          4.869
LGA    G    70_A      R      66          2.545
LGA    R    71_A      R      67          2.336
LGA    V    72_A      V      68          2.052
LGA    R    73_A      I      69          1.753
LGA    L    74_A      G      70          1.422
LGA    G    75_A      A      71          1.601
LGA    I    76_A      F      72          1.603
LGA    G    77_A      S      73          1.648
LGA    P    78_A      S      74          3.444
LGA    -       -      K      75           -
LGA    -       -      G      76           -
LGA    T    79_A      H      77          3.079
LGA    R    80_A      D      78          5.127
LGA    D    81_A      L      79          1.333
LGA    L    82_A      F      80          0.686
LGA    V    83_A      A      81          1.558
LGA    L    84_A      S      82          1.534
LGA    V    85_A      I      83          0.916
LGA    E    86_A      S      84          0.748
LGA    G    87_A      G      85          1.096
LGA    T    88_A      S      86          0.990
LGA    A    89_A      L      87          2.119
LGA    L    90_A      R      88          2.781
LGA    P    91_A      E      89          1.598
LGA    L    92_A      D      90          2.120
LGA    E    93_A      T      91          2.541
LGA    P    94_A      -       -           -
LGA    A    95_A      D      92           #
LGA    G    96_A      P      93          2.726
LGA    L    97_A      A      94          3.016
LGA    P    98_A      V      95          3.441
LGA    D    99_A      V      96           #
LGA    G   100_A      D      97          4.037
LGA    V   101_A      R      98          1.722
LGA    G   102_A      L      99          3.632
LGA    D   103_A      W     100          2.265
LGA    T   104_A      -       -           -
LGA    F   105_A      -       -           -
LGA    A   106_A      N     101          2.567
LGA    E   107_A      P     102          4.629
LGA    K   108_A      -       -           -
LGA    T   109_A      -       -           -
LGA    G   110_A      Y     103          1.032
LGA    F   111_A      V     104          1.711
LGA    D   112_A      A     105          3.175
LGA    P   113_A      A     106           -
LGA    -       -      W     107           -
LGA    -       -      Y     108           -
LGA    -       -      E     109           -
LGA    R   114_A      G     110           #
LGA    R   115_A      G     111          0.926
LGA    -       -      K     112           -
LGA    L   116_A      D     113           #
LGA    T   117_A      D     114          4.034
LGA    T   118_A      P     115          5.091
LGA    S   119_A      K     116          1.659
LGA    Y   120_A      L     117          1.894
LGA    L   121_A      A     118          1.320
LGA    Y   122_A      L     119          0.418
LGA    F   123_A      L     120          1.180
LGA    R   124_A      R     121          1.569
LGA    I   125_A      L     122          1.391
LGA    S   126_A      D     123          0.990
LGA    P   127_A      A     124          0.644
LGA    R   128_A      D     125          0.495
LGA    R   129_A      H     126          1.151
LGA    V   130_A      A     127          1.155
LGA    Q   131_A      Q     128          1.351
LGA    A   132_A      I     129          0.868
LGA    W   133_A      W     130          1.092
LGA    R   134_A      L     131          1.586
LGA    E   135_A      N     132          3.751
LGA    A   136_A      G     133           #
LGA    N   137_A      S     134           -
LGA    E   138_A      S     135           -
LGA    L   139_A      L     136           -
LGA    S   140_A      L     137           -
LGA    G   141_A      A     138           -
LGA    R   142_A      G     139           -
LGA    E   143_A      I     140           -
LGA    L   144_A      K     141           -
LGA    X   145_A      V     142           -
LGA    R   146_A      L     143           -
LGA    D   147_A      L     144           -
LGA    G   148_A      G     145           -
LGA    E   149_A      -       -           -
LGA    W   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    V   152_A      -       -           -
LGA    T   153_A      -       -           -
LGA    D   154_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  153  145    5.0    116    2.27    10.34     55.269     4.898

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.381314 * X  +   0.403018 * Y  +   0.831971 * Z  + -57.742062
  Y_new =  -0.332842 * X  +   0.779759 * Y  +  -0.530276 * Z  +  55.604786
  Z_new =  -0.862447 * X  +  -0.479117 * Y  +  -0.163192 * Z  +  61.185566 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.899081    1.242511  [ DEG:  -108.8093     71.1907 ]
  Theta =   1.040085    2.101507  [ DEG:    59.5925    120.4075 ]
  Phi   =  -2.423964    0.717628  [ DEG:  -138.8829     41.1171 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2iab_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2iab_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  153  145   5.0  116   2.27   10.34  55.269
REMARK  ---------------------------------------------------------- 
MOLECULE 2iab_A
HEADER    UNKNOWN FUNCTION                        07-SEP-06   2IAB              
TITLE     CRYSTAL STRUCTURE OF A PROTEIN WITH FMN-BINDING SPLIT                 
TITLE    2 BARREL FOLD (NP_828636.1) FROM STREPTOMYCES AVERMITILIS AT           
TITLE    3 2.00 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES AVERMITILIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_828636.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_828636.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   19-SEP-06 2IAB    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_828636.1) FROM STREPTOMYCES AVERMITILIS AT               
JRNL        TITL 3 2.00 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2IAB A    1   154  UNP    Q825J7   Q825J7_STRAW     1    154             
DBREF  2IAB B    1   154  UNP    Q825J7   Q825J7_STRAW     1    154             
SEQRES   1 A  155  GLY MSE THR THR PRO PRO ALA ARG THR ALA LYS GLN ARG          
SEQRES   2 A  155  ILE GLN ASP THR LEU ASN ARG LEU GLU LEU ASP VAL ASP          
SEQRES   3 A  155  ALA TRP VAL SER THR ALA GLY ALA ASP GLY GLY ALA PRO          
SEQRES   4 A  155  TYR LEU VAL PRO LEU SER TYR LEU TRP ASP GLY GLU THR          
SEQRES   5 A  155  PHE LEU VAL ALA THR PRO ALA ALA SER PRO THR GLY ARG          
SEQRES   6 A  155  ASN LEU SER GLU THR GLY ARG VAL ARG LEU GLY ILE GLY          
SEQRES   7 A  155  PRO THR ARG ASP LEU VAL LEU VAL GLU GLY THR ALA LEU          
SEQRES   8 A  155  PRO LEU GLU PRO ALA GLY LEU PRO ASP GLY VAL GLY ASP          
SEQRES   9 A  155  THR PHE ALA GLU LYS THR GLY PHE ASP PRO ARG ARG LEU          
SEQRES  10 A  155  THR THR SER TYR LEU TYR PHE ARG ILE SER PRO ARG ARG          
SEQRES  11 A  155  VAL GLN ALA TRP ARG GLU ALA ASN GLU LEU SER GLY ARG          
SEQRES  12 A  155  GLU LEU MSE ARG ASP GLY GLU TRP LEU VAL THR ASP              
SEQRES   1 B  155  GLY MSE THR THR PRO PRO ALA ARG THR ALA LYS GLN ARG          
SEQRES   2 B  155  ILE GLN ASP THR LEU ASN ARG LEU GLU LEU ASP VAL ASP          
SEQRES   3 B  155  ALA TRP VAL SER THR ALA GLY ALA ASP GLY GLY ALA PRO          
SEQRES   4 B  155  TYR LEU VAL PRO LEU SER TYR LEU TRP ASP GLY GLU THR          
SEQRES   5 B  155  PHE LEU VAL ALA THR PRO ALA ALA SER PRO THR GLY ARG          
SEQRES   6 B  155  ASN LEU SER GLU THR GLY ARG VAL ARG LEU GLY ILE GLY          
SEQRES   7 B  155  PRO THR ARG ASP LEU VAL LEU VAL GLU GLY THR ALA LEU          
SEQRES   8 B  155  PRO LEU GLU PRO ALA GLY LEU PRO ASP GLY VAL GLY ASP          
SEQRES   9 B  155  THR PHE ALA GLU LYS THR GLY PHE ASP PRO ARG ARG LEU          
SEQRES  10 B  155  THR THR SER TYR LEU TYR PHE ARG ILE SER PRO ARG ARG          
SEQRES  11 B  155  VAL GLN ALA TRP ARG GLU ALA ASN GLU LEU SER GLY ARG          
SEQRES  12 B  155  GLU LEU MSE ARG ASP GLY GLU TRP LEU VAL THR ASP              
HET    MSE  A 145       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B 145       8                                                       
HET    IPA      1       4                                                       
HET    IPA      2       4                                                       
HET    IPA      3       4                                                       
HET    IPA      4       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     IPA ISOPROPYL ALCOHOL                                                
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   3  IPA    4(C3 H8 O)                                                   
FORMUL   7  HOH   *234(H2 O)                                                    
CRYST1   87.890   87.890  151.580  90.00  90.00 120.00 P 65 2 2     24          
ATOM      1  N   THR A   2      26.291  41.727   7.881  1.00 58.67           N  
ATOM      2  CA  THR A   2      26.785  41.913   9.277  1.00 57.31           C  
ATOM      3  C   THR A   2      25.726  41.427  10.289  1.00 57.06           C  
ATOM      4  O   THR A   2      24.566  41.165   9.925  1.00 57.07           O  
ATOM      5  CB  THR A   2      27.227  43.406   9.538  1.00 56.04           C  
ATOM      6  N   THR A   3      26.144  41.271  11.549  1.00 57.17           N  
ATOM      7  CA  THR A   3      25.227  40.975  12.661  1.00 55.96           C  
ATOM      8  C   THR A   3      24.320  42.203  12.918  1.00 55.08           C  
ATOM      9  O   THR A   3      24.790  43.227  13.430  1.00 55.50           O  
ATOM     10  N   PRO A   4      23.031  42.114  12.547  1.00 53.30           N  
ATOM     11  CA  PRO A   4      22.127  43.229  12.822  1.00 53.45           C  
ATOM     12  C   PRO A   4      21.864  43.388  14.322  1.00 52.13           C  
ATOM     13  O   PRO A   4      21.880  42.370  15.055  1.00 52.02           O  
ATOM     14  CB  PRO A   4      20.808  42.806  12.139  1.00 53.00           C  
ATOM     15  CG  PRO A   4      21.168  41.649  11.241  1.00 57.64           C  
ATOM     16  CD  PRO A   4      22.326  40.989  11.909  1.00 54.54           C  
ATOM     17  N   PRO A   5      21.563  44.632  14.774  1.00 49.60           N  
ATOM     18  CA  PRO A   5      21.235  44.846  16.193  1.00 48.60           C  
ATOM     19  C   PRO A   5      20.098  43.914  16.666  1.00 46.62           C  
ATOM     20  O   PRO A   5      19.259  43.493  15.849  1.00 45.60           O  
ATOM     21  CB  PRO A   5      20.808  46.323  16.241  1.00 48.40           C  
ATOM     22  CG  PRO A   5      20.416  46.630  14.821  1.00 49.62           C  
ATOM     23  CD  PRO A   5      21.448  45.889  14.018  1.00 49.23           C  
ATOM     24  N   ALA A   6      20.122  43.576  17.959  1.00 45.74           N  
ATOM     25  CA  ALA A   6      19.123  42.720  18.584  1.00 45.34           C  
ATOM     26  C   ALA A   6      17.729  43.268  18.304  1.00 47.44           C  
ATOM     27  O   ALA A   6      17.483  44.485  18.465  1.00 46.02           O  
ATOM     28  CB  ALA A   6      19.344  42.629  20.105  1.00 45.41           C  
ATOM     29  N   ARG A   7      16.823  42.371  17.902  1.00 44.98           N  
ATOM     30  CA  ARG A   7      15.431  42.754  17.688  1.00 45.41           C  
ATOM     31  C   ARG A   7      14.730  42.999  19.033  1.00 45.49           C  
ATOM     32  O   ARG A   7      14.992  42.269  20.039  1.00 41.41           O  
ATOM     33  CB  ARG A   7      14.659  41.648  16.930  1.00 46.05           C  
ATOM     34  CG  ARG A   7      15.147  41.334  15.516  1.00 43.73           C  
ATOM     35  CD  ARG A   7      14.529  40.033  15.016  1.00 43.27           C  
ATOM     36  NE  ARG A   7      14.984  38.858  15.784  1.00 44.41           N  
ATOM     37  CZ  ARG A   7      14.456  37.636  15.719  1.00 41.91           C  
ATOM     38  NH1 ARG A   7      13.453  37.368  14.889  1.00 38.46           N  
ATOM     39  NH2 ARG A   7      14.971  36.654  16.465  1.00 39.52           N  
ATOM     40  N   THR A   8      13.837  44.009  19.028  1.00 44.30           N  
ATOM     41  CA  THR A   8      12.840  44.200  20.112  1.00 44.91           C  
ATOM     42  C   THR A   8      11.850  43.024  20.260  1.00 43.28           C  
ATOM     43  O   THR A   8      11.645  42.219  19.336  1.00 42.10           O  
ATOM     44  CB  THR A   8      11.962  45.478  19.923  1.00 45.23           C  
ATOM     45  OG1 THR A   8      10.864  45.196  19.036  1.00 48.81           O  
ATOM     46  CG2 THR A   8      12.784  46.632  19.418  1.00 48.18           C  
ATOM     47  N   ALA A   9      11.212  42.968  21.423  1.00 41.79           N  
ATOM     48  CA  ALA A   9      10.220  41.922  21.749  1.00 39.08           C  
ATOM     49  C   ALA A   9       9.004  41.895  20.798  1.00 35.44           C  
ATOM     50  O   ALA A   9       8.621  40.833  20.322  1.00 36.75           O  
ATOM     51  CB  ALA A   9       9.746  42.085  23.212  1.00 41.49           C  
ATOM     52  N   LYS A  10       8.409  43.050  20.530  1.00 38.21           N  
ATOM     53  CA  LYS A  10       7.334  43.161  19.531  1.00 40.86           C  
ATOM     54  C   LYS A  10       7.773  42.650  18.135  1.00 39.79           C  
ATOM     55  O   LYS A  10       7.063  41.886  17.508  1.00 36.97           O  
ATOM     56  CB  LYS A  10       6.808  44.590  19.458  1.00 40.57           C  
ATOM     57  CG  LYS A  10       5.436  44.745  18.783  1.00 44.91           C  
ATOM     58  CD  LYS A  10       5.002  46.219  18.791  1.00 49.10           C  
ATOM     59  CE  LYS A  10       3.875  46.495  17.803  1.00 53.22           C  
ATOM     60  N   GLN A  11       8.952  43.035  17.669  0.50 41.45           N  
ATOM     62  CA  GLN A  11       9.405  42.595  16.336  0.50 40.26           C  
ATOM     64  C   GLN A  11       9.819  41.119  16.345  0.50 38.26           C  
ATOM     66  O   GLN A  11       9.600  40.407  15.348  0.50 33.33           O  
ATOM     68  CB  GLN A  11      10.554  43.471  15.798  0.50 40.86           C  
ATOM     70  CG  GLN A  11      10.396  43.958  14.329  0.50 43.07           C  
ATOM     72  CD  GLN A  11      10.672  42.897  13.267  0.50 44.21           C  
ATOM     74  OE1 GLN A  11      11.832  42.584  12.943  0.50 49.24           O  
ATOM     76  NE2 GLN A  11       9.600  42.365  12.690  0.50 33.14           N  
ATOM     78  N   ARG A  12      10.416  40.652  17.449  1.00 35.94           N  
ATOM     79  CA  ARG A  12      10.701  39.236  17.590  1.00 37.77           C  
ATOM     80  C   ARG A  12       9.438  38.415  17.562  1.00 31.06           C  
ATOM     81  O   ARG A  12       9.421  37.294  17.032  1.00 34.55           O  
ATOM     82  CB  ARG A  12      11.496  38.895  18.882  1.00 38.22           C  
ATOM     83  CG  ARG A  12      12.973  39.232  18.797  1.00 49.86           C  
ATOM     84  CD  ARG A  12      13.819  38.476  19.835  1.00 43.96           C  
ATOM     85  NE  ARG A  12      14.840  39.376  20.407  1.00 42.28           N  
ATOM     86  CZ  ARG A  12      15.871  38.954  21.113  1.00 41.34           C  
ATOM     87  NH1 ARG A  12      16.017  37.647  21.357  1.00 41.19           N  
ATOM     88  NH2 ARG A  12      16.748  39.819  21.590  1.00 41.02           N  
ATOM     89  N   ILE A  13       8.383  38.914  18.179  1.00 31.74           N  
ATOM     90  CA  ILE A  13       7.176  38.137  18.239  1.00 30.19           C  
ATOM     91  C   ILE A  13       6.581  38.016  16.829  1.00 31.97           C  
ATOM     92  O   ILE A  13       6.193  36.914  16.405  1.00 29.25           O  
ATOM     93  CB  ILE A  13       6.177  38.670  19.258  1.00 31.49           C  
ATOM     94  CG1 ILE A  13       6.639  38.295  20.684  1.00 33.95           C  
ATOM     95  CG2 ILE A  13       4.803  37.996  19.047  1.00 32.18           C  
ATOM     96  CD1 ILE A  13       5.962  39.094  21.772  1.00 36.05           C  
ATOM     97  N   GLN A  14       6.481  39.153  16.130  1.00 31.71           N  
ATOM     98  CA  GLN A  14       5.991  39.142  14.752  1.00 33.78           C  
ATOM     99  C   GLN A  14       6.836  38.245  13.853  1.00 31.12           C  
ATOM    100  O   GLN A  14       6.277  37.491  13.083  1.00 29.80           O  
ATOM    101  CB  GLN A  14       5.936  40.544  14.147  1.00 32.29           C  
ATOM    102  CG  GLN A  14       5.129  40.536  12.821  1.00 45.52           C  
ATOM    103  CD  GLN A  14       3.771  39.784  12.923  1.00 55.15           C  
ATOM    104  OE1 GLN A  14       2.881  40.195  13.705  1.00 50.61           O  
ATOM    105  NE2 GLN A  14       3.620  38.660  12.144  1.00 40.71           N  
ATOM    106  N   ASP A  15       8.157  38.324  13.964  1.00 29.73           N  
ATOM    107  CA  ASP A  15       9.074  37.455  13.206  1.00 30.84           C  
ATOM    108  C   ASP A  15       8.871  35.979  13.579  1.00 29.90           C  
ATOM    109  O   ASP A  15       8.888  35.080  12.716  1.00 31.19           O  
ATOM    110  CB  ASP A  15      10.542  37.746  13.490  1.00 31.37           C  
ATOM    111  CG  ASP A  15      11.031  39.044  12.908  1.00 40.83           C  
ATOM    112  OD1 ASP A  15      10.320  39.695  12.134  1.00 37.26           O  
ATOM    113  OD2 ASP A  15      12.160  39.414  13.276  1.00 40.05           O  
ATOM    114  N   THR A  16       8.691  35.723  14.859  1.00 28.71           N  
ATOM    115  CA  THR A  16       8.450  34.353  15.328  1.00 28.07           C  
ATOM    116  C   THR A  16       7.140  33.788  14.771  1.00 29.22           C  
ATOM    117  O   THR A  16       7.095  32.668  14.279  1.00 29.40           O  
ATOM    118  CB  THR A  16       8.490  34.285  16.870  1.00 28.83           C  
ATOM    119  OG1 THR A  16       9.806  34.695  17.324  1.00 33.59           O  
ATOM    120  CG2 THR A  16       8.134  32.920  17.381  1.00 34.67           C  
ATOM    121  N   LEU A  17       6.077  34.573  14.842  1.00 29.59           N  
ATOM    122  CA  LEU A  17       4.812  34.191  14.250  1.00 29.68           C  
ATOM    123  C   LEU A  17       4.965  33.916  12.753  1.00 32.45           C  
ATOM    124  O   LEU A  17       4.389  32.974  12.238  1.00 33.37           O  
ATOM    125  CB  LEU A  17       3.761  35.295  14.470  1.00 30.22           C  
ATOM    126  CG  LEU A  17       3.288  35.497  15.915  1.00 32.62           C  
ATOM    127  CD1 LEU A  17       2.315  36.648  15.941  1.00 36.68           C  
ATOM    128  CD2 LEU A  17       2.690  34.211  16.450  1.00 35.70           C  
ATOM    129  N   ASN A  18       5.697  34.751  12.035  1.00 31.61           N  
ATOM    130  CA  ASN A  18       5.915  34.480  10.587  1.00 31.64           C  
ATOM    131  C   ASN A  18       6.651  33.127  10.365  1.00 29.22           C  
ATOM    132  O   ASN A  18       6.368  32.401   9.435  1.00 30.87           O  
ATOM    133  CB  ASN A  18       6.727  35.600   9.918  1.00 29.88           C  
ATOM    134  CG  ASN A  18       5.995  36.982   9.888  1.00 38.56           C  
ATOM    135  OD1 ASN A  18       4.773  37.080  10.074  1.00 38.84           O  
ATOM    136  ND2 ASN A  18       6.765  38.036   9.651  1.00 29.90           N  
ATOM    137  N   ARG A  19       7.635  32.838  11.205  1.00 30.63           N  
ATOM    138  CA  ARG A  19       8.417  31.611  11.112  1.00 31.11           C  
ATOM    139  C   ARG A  19       7.496  30.419  11.382  1.00 29.11           C  
ATOM    140  O   ARG A  19       7.517  29.442  10.633  1.00 29.72           O  
ATOM    141  CB  ARG A  19       9.600  31.660  12.087  1.00 27.79           C  
ATOM    142  CG  ARG A  19      10.394  30.321  12.316  1.00 30.19           C  
ATOM    143  CD  ARG A  19      11.095  29.877  11.086  1.00 29.33           C  
ATOM    144  NE  ARG A  19      12.176  30.774  10.748  1.00 27.89           N  
ATOM    145  CZ  ARG A  19      12.786  30.817   9.579  1.00 30.92           C  
ATOM    146  NH1 ARG A  19      12.417  30.047   8.588  1.00 31.66           N  
ATOM    147  NH2 ARG A  19      13.791  31.655   9.398  1.00 32.33           N  
ATOM    148  N   LEU A  20       6.634  30.537  12.402  1.00 32.22           N  
ATOM    149  CA  LEU A  20       5.709  29.453  12.747  1.00 28.50           C  
ATOM    150  C   LEU A  20       4.738  29.187  11.605  1.00 30.94           C  
ATOM    151  O   LEU A  20       4.402  28.026  11.366  1.00 32.79           O  
ATOM    152  CB  LEU A  20       4.981  29.716  14.070  1.00 30.56           C  
ATOM    153  CG  LEU A  20       5.875  29.842  15.349  1.00 26.68           C  
ATOM    154  CD1 LEU A  20       5.043  30.022  16.565  1.00 32.45           C  
ATOM    155  CD2 LEU A  20       6.782  28.606  15.502  1.00 29.31           C  
ATOM    156  N   GLU A  21       4.296  30.234  10.905  1.00 29.05           N  
ATOM    157  CA  GLU A  21       3.373  30.114   9.799  1.00 30.89           C  
ATOM    158  C   GLU A  21       4.089  29.544   8.582  1.00 33.20           C  
ATOM    159  O   GLU A  21       3.490  28.851   7.767  1.00 36.24           O  
ATOM    160  CB  GLU A  21       2.757  31.468   9.417  1.00 31.21           C  
ATOM    161  CG  GLU A  21       1.778  32.047  10.496  1.00 36.52           C  
ATOM    162  CD  GLU A  21       0.379  31.326  10.608  1.00 45.24           C  
ATOM    163  OE1 GLU A  21       0.119  30.392   9.829  1.00 38.72           O  
ATOM    164  OE2 GLU A  21      -0.468  31.698  11.506  1.00 39.97           O  
ATOM    165  N   LEU A  22       5.388  29.816   8.464  1.00 32.37           N  
ATOM    166  CA  LEU A  22       6.132  29.382   7.288  1.00 31.91           C  
ATOM    167  C   LEU A  22       6.687  27.943   7.323  1.00 32.55           C  
ATOM    168  O   LEU A  22       6.529  27.202   6.389  1.00 34.60           O  
ATOM    169  CB  LEU A  22       7.275  30.353   7.052  1.00 35.10           C  
ATOM    170  CG  LEU A  22       8.098  30.171   5.773  1.00 33.86           C  
ATOM    171  CD1 LEU A  22       7.291  30.495   4.542  1.00 34.40           C  
ATOM    172  CD2 LEU A  22       9.321  31.053   5.808  1.00 35.80           C  
ATOM    173  N   ASP A  23       7.379  27.573   8.385  1.00 27.44           N  
ATOM    174  CA  ASP A  23       8.071  26.300   8.431  1.00 28.79           C  
ATOM    175  C   ASP A  23       7.067  25.128   8.479  1.00 32.25           C  
ATOM    176  O   ASP A  23       5.936  25.263   8.934  1.00 33.08           O  
ATOM    177  CB  ASP A  23       9.058  26.264   9.595  1.00 27.27           C  
ATOM    178  CG  ASP A  23      10.380  26.948   9.256  1.00 31.84           C  
ATOM    179  OD1 ASP A  23      10.382  27.860   8.394  1.00 34.78           O  
ATOM    180  OD2 ASP A  23      11.412  26.571   9.843  1.00 39.52           O  
ATOM    181  N   VAL A  24       7.482  24.022   7.930  1.00 31.24           N  
ATOM    182  CA  VAL A  24       6.663  22.831   7.864  1.00 34.14           C  
ATOM    183  C   VAL A  24       6.982  21.848   8.975  1.00 31.61           C  
ATOM    184  O   VAL A  24       6.077  21.115   9.444  1.00 30.73           O  
ATOM    185  CB  VAL A  24       6.866  22.122   6.494  1.00 35.15           C  
ATOM    186  CG1 VAL A  24       5.943  20.901   6.378  1.00 43.12           C  
ATOM    187  CG2 VAL A  24       6.554  23.072   5.383  1.00 44.03           C  
ATOM    188  N   ASP A  25       8.264  21.774   9.324  1.00 28.16           N  
ATOM    189  CA  ASP A  25       8.769  20.785  10.269  1.00 30.37           C  
ATOM    190  C   ASP A  25       9.273  21.420  11.581  1.00 30.60           C  
ATOM    191  O   ASP A  25       9.769  22.563  11.609  1.00 32.50           O  
ATOM    192  CB  ASP A  25       9.933  19.980   9.688  1.00 29.57           C  
ATOM    193  CG  ASP A  25       9.614  19.326   8.376  1.00 39.33           C  
ATOM    194  OD1 ASP A  25       8.497  18.806   8.190  1.00 33.94           O  
ATOM    195  OD2 ASP A  25      10.493  19.374   7.494  1.00 34.52           O  
ATOM    196  N   ALA A  26       9.172  20.618  12.635  1.00 30.82           N  
ATOM    197  CA  ALA A  26       9.748  20.862  13.952  1.00 31.13           C  
ATOM    198  C   ALA A  26      10.485  19.657  14.467  1.00 32.41           C  
ATOM    199  O   ALA A  26      10.072  18.494  14.278  1.00 32.07           O  
ATOM    200  CB  ALA A  26       8.692  21.178  14.950  1.00 28.82           C  
ATOM    201  N   TRP A  27      11.544  19.946  15.204  1.00 31.86           N  
ATOM    202  CA  TRP A  27      12.209  18.925  15.998  1.00 30.80           C  
ATOM    203  C   TRP A  27      11.347  18.719  17.254  1.00 31.29           C  
ATOM    204  O   TRP A  27      11.098  19.637  18.016  1.00 31.84           O  
ATOM    205  CB  TRP A  27      13.639  19.340  16.377  1.00 29.78           C  
ATOM    206  CG  TRP A  27      14.634  19.341  15.245  1.00 27.91           C  
ATOM    207  CD1 TRP A  27      14.933  20.389  14.429  1.00 33.43           C  
ATOM    208  CD2 TRP A  27      15.433  18.238  14.780  1.00 31.82           C  
ATOM    209  NE1 TRP A  27      15.870  20.017  13.505  1.00 36.32           N  
ATOM    210  CE2 TRP A  27      16.180  18.698  13.688  1.00 32.55           C  
ATOM    211  CE3 TRP A  27      15.552  16.888  15.160  1.00 30.57           C  
ATOM    212  CZ2 TRP A  27      17.075  17.887  12.997  1.00 31.53           C  
ATOM    213  CZ3 TRP A  27      16.444  16.070  14.478  1.00 28.61           C  
ATOM    214  CH2 TRP A  27      17.207  16.583  13.402  1.00 28.81           C  
ATOM    215  N   VAL A  28      10.899  17.497  17.474  1.00 29.44           N  
ATOM    216  CA  VAL A  28       9.930  17.204  18.528  1.00 30.19           C  
ATOM    217  C   VAL A  28      10.661  16.398  19.590  1.00 31.07           C  
ATOM    218  O   VAL A  28      11.071  15.240  19.370  1.00 29.72           O  
ATOM    219  CB  VAL A  28       8.742  16.455  17.991  1.00 30.45           C  
ATOM    220  CG1 VAL A  28       7.782  16.104  19.085  1.00 34.38           C  
ATOM    221  CG2 VAL A  28       8.047  17.323  16.911  1.00 33.67           C  
ATOM    222  N   SER A  29      10.807  17.031  20.759  1.00 29.77           N  
ATOM    223  CA  SER A  29      11.524  16.459  21.848  1.00 29.64           C  
ATOM    224  C   SER A  29      10.568  16.020  22.964  1.00 29.75           C  
ATOM    225  O   SER A  29       9.762  16.817  23.524  1.00 29.99           O  
ATOM    226  CB  SER A  29      12.500  17.508  22.376  1.00 33.17           C  
ATOM    227  OG  SER A  29      13.360  16.970  23.334  1.00 37.84           O  
ATOM    228  N   THR A  30      10.699  14.761  23.327  1.00 29.28           N  
ATOM    229  CA  THR A  30       9.840  14.099  24.326  1.00 28.65           C  
ATOM    230  C   THR A  30      10.693  13.251  25.250  1.00 30.51           C  
ATOM    231  O   THR A  30      11.919  13.096  25.055  1.00 26.52           O  
ATOM    232  CB  THR A  30       8.675  13.223  23.690  1.00 28.77           C  
ATOM    233  OG1 THR A  30       9.204  12.130  22.902  1.00 30.23           O  
ATOM    234  CG2 THR A  30       7.735  14.071  22.839  1.00 30.31           C  
ATOM    235  N   ALA A  31      10.039  12.709  26.291  1.00 30.54           N  
ATOM    236  CA  ALA A  31      10.695  11.885  27.282  1.00 29.91           C  
ATOM    237  C   ALA A  31       9.737  10.785  27.737  1.00 30.53           C  
ATOM    238  O   ALA A  31       8.538  11.018  27.836  1.00 30.16           O  
ATOM    239  CB  ALA A  31      11.123  12.725  28.459  1.00 34.22           C  
ATOM    240  N   GLY A  32      10.268   9.590  27.957  1.00 29.19           N  
ATOM    241  CA  GLY A  32       9.481   8.500  28.580  1.00 31.54           C  
ATOM    242  C   GLY A  32       9.084   8.817  30.013  1.00 35.20           C  
ATOM    243  O   GLY A  32       9.719   9.639  30.713  1.00 34.42           O  
ATOM    244  N   ALA A  33       8.040   8.116  30.451  1.00 40.99           N  
ATOM    245  CA  ALA A  33       7.421   8.301  31.747  1.00 42.05           C  
ATOM    246  C   ALA A  33       8.339   7.846  32.854  1.00 41.40           C  
ATOM    247  O   ALA A  33       8.258   8.391  33.944  1.00 41.99           O  
ATOM    248  CB  ALA A  33       6.086   7.556  31.820  1.00 45.62           C  
ATOM    249  N   ASP A  34       9.244   6.921  32.543  1.00 41.41           N  
ATOM    250  CA  ASP A  34      10.119   6.336  33.538  1.00 46.81           C  
ATOM    251  C   ASP A  34      11.530   6.959  33.726  1.00 48.22           C  
ATOM    252  O   ASP A  34      12.318   6.458  34.505  1.00 51.82           O  
ATOM    253  CB  ASP A  34      10.201   4.814  33.306  1.00 49.28           C  
ATOM    254  CG  ASP A  34       8.810   4.118  33.399  1.00 58.75           C  
ATOM    255  OD1 ASP A  34       8.024   4.411  34.343  1.00 55.78           O  
ATOM    256  OD2 ASP A  34       8.500   3.275  32.519  1.00 66.10           O  
ATOM    257  N   GLY A  35      11.868   8.051  33.062  1.00 47.06           N  
ATOM    258  CA  GLY A  35      13.031   8.837  33.503  1.00 46.28           C  
ATOM    259  C   GLY A  35      14.328   8.518  32.794  1.00 44.80           C  
ATOM    260  O   GLY A  35      14.593   7.371  32.444  1.00 46.94           O  
ATOM    261  N   GLY A  36      15.141   9.549  32.598  1.00 43.21           N  
ATOM    262  CA  GLY A  36      16.298   9.486  31.694  1.00 39.85           C  
ATOM    263  C   GLY A  36      16.081   8.767  30.367  1.00 36.70           C  
ATOM    264  O   GLY A  36      16.934   8.004  29.950  1.00 39.02           O  
ATOM    265  N   ALA A  37      14.956   9.010  29.698  1.00 32.08           N  
ATOM    266  CA  ALA A  37      14.694   8.412  28.389  1.00 30.02           C  
ATOM    267  C   ALA A  37      14.279   9.474  27.340  1.00 28.36           C  
ATOM    268  O   ALA A  37      13.096   9.542  26.898  1.00 28.34           O  
ATOM    269  CB  ALA A  37      13.607   7.333  28.522  1.00 31.32           C  
ATOM    270  N   PRO A  38      15.260  10.251  26.846  1.00 28.87           N  
ATOM    271  CA  PRO A  38      14.943  11.261  25.830  1.00 28.93           C  
ATOM    272  C   PRO A  38      14.604  10.660  24.462  1.00 26.44           C  
ATOM    273  O   PRO A  38      15.083   9.589  24.107  1.00 27.82           O  
ATOM    274  CB  PRO A  38      16.248  12.083  25.753  1.00 30.81           C  
ATOM    275  CG  PRO A  38      17.307  11.085  26.104  1.00 26.49           C  
ATOM    276  CD  PRO A  38      16.697  10.247  27.186  1.00 29.70           C  
ATOM    277  N   TYR A  39      13.820  11.381  23.683  1.00 28.26           N  
ATOM    278  CA  TYR A  39      13.531  10.990  22.315  1.00 29.19           C  
ATOM    279  C   TYR A  39      13.412  12.265  21.489  1.00 31.01           C  
ATOM    280  O   TYR A  39      12.820  13.244  21.957  1.00 31.10           O  
ATOM    281  CB  TYR A  39      12.235  10.147  22.263  1.00 30.64           C  
ATOM    282  CG  TYR A  39      12.104   9.390  20.976  1.00 31.95           C  
ATOM    283  CD1 TYR A  39      12.742   8.146  20.778  1.00 26.89           C  
ATOM    284  CD2 TYR A  39      11.416   9.927  19.941  1.00 31.23           C  
ATOM    285  CE1 TYR A  39      12.653   7.482  19.537  1.00 30.26           C  
ATOM    286  CE2 TYR A  39      11.311   9.275  18.720  1.00 35.51           C  
ATOM    287  CZ  TYR A  39      11.931   8.082  18.516  1.00 34.05           C  
ATOM    288  OH  TYR A  39      11.787   7.471  17.295  1.00 34.47           O  
ATOM    289  N   LEU A  40      13.987  12.237  20.282  1.00 29.98           N  
ATOM    290  CA  LEU A  40      13.983  13.348  19.381  1.00 30.94           C  
ATOM    291  C   LEU A  40      13.773  12.884  17.960  1.00 30.37           C  
ATOM    292  O   LEU A  40      14.459  11.960  17.476  1.00 28.14           O  
ATOM    293  CB  LEU A  40      15.313  14.092  19.516  1.00 29.95           C  
ATOM    294  CG  LEU A  40      15.492  15.339  18.656  1.00 26.98           C  
ATOM    295  CD1 LEU A  40      14.591  16.413  19.128  1.00 27.32           C  
ATOM    296  CD2 LEU A  40      16.946  15.781  18.749  1.00 30.88           C  
ATOM    297  N   VAL A  41      12.831  13.536  17.275  1.00 30.56           N  
ATOM    298  CA  VAL A  41      12.576  13.275  15.854  1.00 30.86           C  
ATOM    299  C   VAL A  41      11.892  14.508  15.242  1.00 30.59           C  
ATOM    300  O   VAL A  41      11.149  15.196  15.936  1.00 29.41           O  
ATOM    301  CB  VAL A  41      11.731  11.937  15.654  1.00 32.33           C  
ATOM    302  CG1 VAL A  41      10.305  12.105  16.209  1.00 34.05           C  
ATOM    303  CG2 VAL A  41      11.620  11.578  14.234  1.00 37.00           C  
ATOM    304  N   PRO A  42      12.170  14.833  13.970  1.00 29.92           N  
ATOM    305  CA  PRO A  42      11.312  15.859  13.318  1.00 30.12           C  
ATOM    306  C   PRO A  42       9.959  15.364  12.870  1.00 28.95           C  
ATOM    307  O   PRO A  42       9.843  14.282  12.325  1.00 34.73           O  
ATOM    308  CB  PRO A  42      12.132  16.323  12.114  1.00 31.87           C  
ATOM    309  CG  PRO A  42      13.367  15.610  12.156  1.00 32.85           C  
ATOM    310  CD  PRO A  42      13.223  14.393  13.051  1.00 32.27           C  
ATOM    311  N   LEU A  43       8.932  16.152  13.112  1.00 30.32           N  
ATOM    312  CA  LEU A  43       7.633  15.879  12.541  1.00 31.51           C  
ATOM    313  C   LEU A  43       7.151  17.177  11.890  1.00 28.59           C  
ATOM    314  O   LEU A  43       7.565  18.296  12.251  1.00 32.11           O  
ATOM    315  CB  LEU A  43       6.641  15.473  13.649  1.00 35.47           C  
ATOM    316  CG  LEU A  43       6.972  14.198  14.483  1.00 34.95           C  
ATOM    317  CD1 LEU A  43       5.957  14.148  15.601  1.00 42.54           C  
ATOM    318  CD2 LEU A  43       6.949  12.951  13.698  1.00 43.22           C  
ATOM    319  N   SER A  44       6.199  17.022  11.011  1.00 28.80           N  
ATOM    320  CA  SER A  44       5.465  18.127  10.419  1.00 29.87           C  
ATOM    321  C   SER A  44       4.442  18.697  11.397  1.00 32.70           C  
ATOM    322  O   SER A  44       3.948  17.986  12.240  1.00 32.62           O  
ATOM    323  CB  SER A  44       4.838  17.649   9.135  1.00 33.62           C  
ATOM    324  OG  SER A  44       5.867  17.382   8.192  1.00 34.39           O  
ATOM    325  N   TYR A  45       4.121  19.989  11.264  1.00 28.72           N  
ATOM    326  CA  TYR A  45       3.177  20.613  12.137  1.00 30.32           C  
ATOM    327  C   TYR A  45       2.319  21.608  11.393  1.00 31.27           C  
ATOM    328  O   TYR A  45       2.655  22.074  10.318  1.00 30.14           O  
ATOM    329  CB  TYR A  45       3.874  21.281  13.322  1.00 29.07           C  
ATOM    330  CG  TYR A  45       4.582  22.566  12.954  1.00 31.62           C  
ATOM    331  CD1 TYR A  45       3.905  23.795  12.947  1.00 32.00           C  
ATOM    332  CD2 TYR A  45       5.948  22.560  12.634  1.00 31.96           C  
ATOM    333  CE1 TYR A  45       4.558  24.990  12.569  1.00 32.88           C  
ATOM    334  CE2 TYR A  45       6.603  23.764  12.262  1.00 29.91           C  
ATOM    335  CZ  TYR A  45       5.889  24.958  12.228  1.00 33.19           C  
ATOM    336  OH  TYR A  45       6.540  26.121  11.864  1.00 30.59           O  
ATOM    337  N   LEU A  46       1.186  21.886  11.996  1.00 31.72           N  
ATOM    338  CA  LEU A  46       0.342  23.016  11.621  1.00 32.31           C  
ATOM    339  C   LEU A  46       0.221  23.942  12.802  1.00 33.03           C  
ATOM    340  O   LEU A  46      -0.177  23.516  13.895  1.00 30.88           O  
ATOM    341  CB  LEU A  46      -1.010  22.562  11.218  1.00 28.75           C  
ATOM    342  CG  LEU A  46      -2.057  23.654  10.979  1.00 36.37           C  
ATOM    343  CD1 LEU A  46      -1.766  24.466   9.691  1.00 31.94           C  
ATOM    344  CD2 LEU A  46      -3.460  23.011  10.928  1.00 35.79           C  
ATOM    345  N   TRP A  47       0.541  25.212  12.571  1.00 31.05           N  
ATOM    346  CA  TRP A  47       0.303  26.275  13.541  1.00 32.37           C  
ATOM    347  C   TRP A  47      -0.861  27.167  13.085  1.00 32.81           C  
ATOM    348  O   TRP A  47      -0.876  27.639  11.947  1.00 30.45           O  
ATOM    349  CB  TRP A  47       1.569  27.124  13.692  1.00 31.80           C  
ATOM    350  CG  TRP A  47       1.442  28.472  14.411  1.00 28.07           C  
ATOM    351  CD1 TRP A  47       1.454  29.723  13.806  1.00 28.06           C  
ATOM    352  CD2 TRP A  47       1.379  28.711  15.803  1.00 28.03           C  
ATOM    353  NE1 TRP A  47       1.354  30.698  14.759  1.00 29.36           N  
ATOM    354  CE2 TRP A  47       1.355  30.118  15.993  1.00 26.56           C  
ATOM    355  CE3 TRP A  47       1.328  27.889  16.927  1.00 27.76           C  
ATOM    356  CZ2 TRP A  47       1.240  30.689  17.243  1.00 27.67           C  
ATOM    357  CZ3 TRP A  47       1.251  28.478  18.166  1.00 31.14           C  
ATOM    358  CH2 TRP A  47       1.196  29.862  18.319  1.00 32.27           C  
ATOM    359  N   ASP A  48      -1.800  27.420  13.989  1.00 32.72           N  
ATOM    360  CA  ASP A  48      -2.965  28.249  13.658  1.00 33.76           C  
ATOM    361  C   ASP A  48      -3.008  29.644  14.305  1.00 32.77           C  
ATOM    362  O   ASP A  48      -4.072  30.305  14.312  1.00 29.02           O  
ATOM    363  CB  ASP A  48      -4.270  27.478  13.980  1.00 34.90           C  
ATOM    364  CG  ASP A  48      -4.530  27.372  15.463  1.00 38.42           C  
ATOM    365  OD1 ASP A  48      -3.662  27.789  16.283  1.00 31.23           O  
ATOM    366  OD2 ASP A  48      -5.639  26.936  15.812  1.00 33.63           O  
ATOM    367  N   GLY A  49      -1.891  30.078  14.897  1.00 27.84           N  
ATOM    368  CA  GLY A  49      -1.887  31.325  15.658  1.00 31.25           C  
ATOM    369  C   GLY A  49      -2.038  31.142  17.150  1.00 31.40           C  
ATOM    370  O   GLY A  49      -1.880  32.105  17.930  1.00 30.12           O  
ATOM    371  N   GLU A  50      -2.395  29.928  17.579  1.00 28.71           N  
ATOM    372  CA  GLU A  50      -2.694  29.664  18.975  1.00 29.48           C  
ATOM    373  C   GLU A  50      -2.096  28.353  19.491  1.00 29.36           C  
ATOM    374  O   GLU A  50      -1.496  28.308  20.556  1.00 31.42           O  
ATOM    375  CB  GLU A  50      -4.233  29.680  19.123  1.00 32.31           C  
ATOM    376  CG  GLU A  50      -4.666  29.519  20.494  1.00 36.52           C  
ATOM    377  CD  GLU A  50      -6.190  29.543  20.677  1.00 40.16           C  
ATOM    378  OE1 GLU A  50      -6.911  28.829  19.980  1.00 36.31           O  
ATOM    379  OE2 GLU A  50      -6.631  30.271  21.562  1.00 43.74           O  
ATOM    380  N   THR A  51      -2.288  27.285  18.740  1.00 30.35           N  
ATOM    381  CA  THR A  51      -1.759  25.957  19.045  1.00 29.24           C  
ATOM    382  C   THR A  51      -1.069  25.341  17.817  1.00 30.57           C  
ATOM    383  O   THR A  51      -1.245  25.768  16.662  1.00 34.08           O  
ATOM    384  CB  THR A  51      -2.888  24.969  19.495  1.00 29.80           C  
ATOM    385  OG1 THR A  51      -3.808  24.811  18.432  1.00 29.20           O  
ATOM    386  CG2 THR A  51      -3.619  25.439  20.692  1.00 30.92           C  
ATOM    387  N   PHE A  52      -0.248  24.339  18.094  1.00 31.17           N  
ATOM    388  CA  PHE A  52       0.363  23.479  17.124  1.00 29.17           C  
ATOM    389  C   PHE A  52      -0.431  22.170  17.101  1.00 32.79           C  
ATOM    390  O   PHE A  52      -0.978  21.709  18.105  1.00 29.92           O  
ATOM    391  CB  PHE A  52       1.793  23.084  17.489  1.00 31.22           C  
ATOM    392  CG  PHE A  52       2.749  24.221  17.573  1.00 28.84           C  
ATOM    393  CD1 PHE A  52       2.861  24.967  18.712  1.00 28.76           C  
ATOM    394  CD2 PHE A  52       3.552  24.527  16.491  1.00 33.08           C  
ATOM    395  CE1 PHE A  52       3.818  26.046  18.786  1.00 26.94           C  
ATOM    396  CE2 PHE A  52       4.471  25.575  16.536  1.00 33.70           C  
ATOM    397  CZ  PHE A  52       4.598  26.339  17.691  1.00 28.86           C  
ATOM    398  N   LEU A  53      -0.465  21.584  15.919  1.00 29.66           N  
ATOM    399  CA  LEU A  53      -1.017  20.297  15.691  1.00 29.90           C  
ATOM    400  C   LEU A  53       0.000  19.441  14.957  1.00 30.99           C  
ATOM    401  O   LEU A  53       0.550  19.832  13.920  1.00 27.80           O  
ATOM    402  CB  LEU A  53      -2.287  20.418  14.872  1.00 29.68           C  
ATOM    403  CG  LEU A  53      -3.140  19.147  14.789  1.00 30.80           C  
ATOM    404  CD1 LEU A  53      -3.747  18.846  16.119  1.00 30.40           C  
ATOM    405  CD2 LEU A  53      -4.239  19.323  13.775  1.00 32.98           C  
ATOM    406  N   VAL A  54       0.268  18.276  15.528  1.00 29.19           N  
ATOM    407  CA  VAL A  54       1.190  17.279  14.928  1.00 31.35           C  
ATOM    408  C   VAL A  54       0.400  15.969  14.837  1.00 33.73           C  
ATOM    409  O   VAL A  54      -0.637  15.833  15.458  1.00 31.85           O  
ATOM    410  CB  VAL A  54       2.486  17.075  15.770  1.00 29.96           C  
ATOM    411  CG1 VAL A  54       3.275  18.393  15.835  1.00 30.20           C  
ATOM    412  CG2 VAL A  54       2.195  16.513  17.180  1.00 35.93           C  
ATOM    413  N   ALA A  55       0.856  15.028  14.036  1.00 30.90           N  
ATOM    414  CA  ALA A  55       0.203  13.744  14.003  1.00 31.37           C  
ATOM    415  C   ALA A  55       1.295  12.658  13.960  1.00 31.54           C  
ATOM    416  O   ALA A  55       2.270  12.790  13.221  1.00 32.46           O  
ATOM    417  CB  ALA A  55      -0.696  13.669  12.790  1.00 31.29           C  
ATOM    418  N   THR A  56       1.084  11.572  14.705  1.00 31.52           N  
ATOM    419  CA  THR A  56       1.988  10.434  14.696  1.00 33.13           C  
ATOM    420  C   THR A  56       1.207   9.148  15.028  1.00 32.14           C  
ATOM    421  O   THR A  56       0.143   9.229  15.645  1.00 30.72           O  
ATOM    422  CB  THR A  56       3.175  10.719  15.703  1.00 35.09           C  
ATOM    423  OG1 THR A  56       4.184   9.716  15.572  1.00 34.35           O  
ATOM    424  CG2 THR A  56       2.690  10.702  17.136  1.00 36.62           C  
ATOM    425  N   PRO A  57       1.702   7.952  14.584  1.00 32.37           N  
ATOM    426  CA  PRO A  57       1.054   6.767  15.042  1.00 32.99           C  
ATOM    427  C   PRO A  57       0.945   6.761  16.557  1.00 31.38           C  
ATOM    428  O   PRO A  57       1.870   7.161  17.268  1.00 28.78           O  
ATOM    429  CB  PRO A  57       1.944   5.638  14.495  1.00 36.88           C  
ATOM    430  CG  PRO A  57       2.497   6.210  13.217  1.00 36.57           C  
ATOM    431  CD  PRO A  57       2.758   7.652  13.585  1.00 32.75           C  
ATOM    432  N   ALA A  58      -0.209   6.372  17.067  1.00 31.43           N  
ATOM    433  CA  ALA A  58      -0.393   6.286  18.524  1.00 32.61           C  
ATOM    434  C   ALA A  58       0.724   5.483  19.172  1.00 35.64           C  
ATOM    435  O   ALA A  58       1.149   5.769  20.315  1.00 35.45           O  
ATOM    436  CB  ALA A  58      -1.755   5.627  18.849  1.00 31.84           C  
ATOM    437  N   ALA A  59       1.186   4.451  18.454  1.00 34.71           N  
ATOM    438  CA  ALA A  59       2.171   3.507  18.988  1.00 34.07           C  
ATOM    439  C   ALA A  59       3.639   3.916  18.827  1.00 32.52           C  
ATOM    440  O   ALA A  59       4.510   3.201  19.295  1.00 33.21           O  
ATOM    441  CB  ALA A  59       1.940   2.140  18.371  1.00 34.60           C  
ATOM    442  N   SER A  60       3.911   5.038  18.154  1.00 30.93           N  
ATOM    443  CA  SER A  60       5.300   5.499  17.924  1.00 31.83           C  
ATOM    444  C   SER A  60       5.871   5.978  19.268  1.00 30.96           C  
ATOM    445  O   SER A  60       5.112   6.304  20.165  1.00 30.20           O  
ATOM    446  CB  SER A  60       5.349   6.638  16.932  1.00 31.11           C  
ATOM    447  OG  SER A  60       4.756   7.794  17.522  1.00 29.60           O  
ATOM    448  N   PRO A  61       7.187   6.001  19.419  1.00 30.27           N  
ATOM    449  CA  PRO A  61       7.751   6.530  20.675  1.00 29.80           C  
ATOM    450  C   PRO A  61       7.258   7.927  21.018  1.00 31.00           C  
ATOM    451  O   PRO A  61       6.997   8.225  22.190  1.00 27.32           O  
ATOM    452  CB  PRO A  61       9.236   6.541  20.409  1.00 29.31           C  
ATOM    453  CG  PRO A  61       9.426   5.391  19.412  1.00 33.59           C  
ATOM    454  CD  PRO A  61       8.247   5.516  18.500  1.00 29.97           C  
ATOM    455  N   THR A  62       7.126   8.777  20.002  1.00 30.77           N  
ATOM    456  CA  THR A  62       6.601  10.123  20.193  1.00 30.06           C  
ATOM    457  C   THR A  62       5.186  10.083  20.640  1.00 29.51           C  
ATOM    458  O   THR A  62       4.834  10.728  21.642  1.00 31.46           O  
ATOM    459  CB  THR A  62       6.770  10.995  18.918  1.00 31.43           C  
ATOM    460  OG1 THR A  62       8.171  11.167  18.650  1.00 29.76           O  
ATOM    461  CG2 THR A  62       6.122  12.366  19.121  1.00 32.76           C  
ATOM    462  N   GLY A  63       4.349   9.307  19.938  1.00 31.19           N  
ATOM    463  CA  GLY A  63       2.942   9.176  20.320  1.00 29.44           C  
ATOM    464  C   GLY A  63       2.729   8.674  21.747  1.00 29.86           C  
ATOM    465  O   GLY A  63       1.889   9.172  22.469  1.00 30.60           O  
ATOM    466  N   ARG A  64       3.494   7.669  22.134  1.00 30.78           N  
ATOM    467  CA  ARG A  64       3.435   7.115  23.481  1.00 33.00           C  
ATOM    468  C   ARG A  64       3.911   8.106  24.523  1.00 30.48           C  
ATOM    469  O   ARG A  64       3.299   8.231  25.571  1.00 30.96           O  
ATOM    470  CB  ARG A  64       4.220   5.798  23.568  1.00 33.88           C  
ATOM    471  CG  ARG A  64       3.583   4.720  22.668  1.00 34.60           C  
ATOM    472  CD  ARG A  64       4.204   3.315  22.804  1.00 35.03           C  
ATOM    473  NE  ARG A  64       5.420   3.164  22.035  1.00 38.75           N  
ATOM    474  CZ  ARG A  64       6.646   3.268  22.532  1.00 45.56           C  
ATOM    475  NH1 ARG A  64       6.842   3.480  23.840  1.00 43.27           N  
ATOM    476  NH2 ARG A  64       7.685   3.096  21.720  1.00 33.75           N  
ATOM    477  N   ASN A  65       4.999   8.810  24.257  1.00 30.21           N  
ATOM    478  CA  ASN A  65       5.483   9.811  25.225  1.00 31.46           C  
ATOM    479  C   ASN A  65       4.486  10.946  25.363  1.00 29.59           C  
ATOM    480  O   ASN A  65       4.198  11.371  26.485  1.00 31.25           O  
ATOM    481  CB  ASN A  65       6.886  10.353  24.904  1.00 28.22           C  
ATOM    482  CG  ASN A  65       7.956   9.294  25.002  1.00 32.45           C  
ATOM    483  OD1 ASN A  65       7.709   8.242  25.522  1.00 29.60           O  
ATOM    484  ND2 ASN A  65       9.143   9.570  24.478  1.00 29.04           N  
ATOM    485  N   LEU A  66       3.915  11.398  24.248  1.00 27.90           N  
ATOM    486  CA  LEU A  66       2.930  12.443  24.300  1.00 28.71           C  
ATOM    487  C   LEU A  66       1.657  12.048  25.100  1.00 32.02           C  
ATOM    488  O   LEU A  66       1.176  12.808  25.934  1.00 31.55           O  
ATOM    489  CB  LEU A  66       2.578  12.972  22.905  1.00 28.68           C  
ATOM    490  CG  LEU A  66       3.719  13.768  22.237  1.00 28.23           C  
ATOM    491  CD1 LEU A  66       3.356  14.168  20.811  1.00 30.56           C  
ATOM    492  CD2 LEU A  66       4.107  14.974  23.078  1.00 28.08           C  
ATOM    493  N   SER A  67       1.158  10.853  24.836  1.00 30.60           N  
ATOM    494  CA  SER A  67      -0.010  10.314  25.509  1.00 31.32           C  
ATOM    495  C   SER A  67       0.216  10.149  26.973  1.00 31.99           C  
ATOM    496  O   SER A  67      -0.682  10.449  27.779  1.00 32.65           O  
ATOM    497  CB  SER A  67      -0.381   8.936  24.949  1.00 32.45           C  
ATOM    498  OG  SER A  67      -0.901   9.092  23.654  1.00 30.87           O  
ATOM    499  N   GLU A  68       1.391   9.651  27.338  1.00 32.22           N  
ATOM    500  CA  GLU A  68       1.647   9.258  28.724  1.00 33.03           C  
ATOM    501  C   GLU A  68       2.067  10.432  29.543  1.00 32.61           C  
ATOM    502  O   GLU A  68       1.743  10.488  30.708  1.00 32.79           O  
ATOM    503  CB  GLU A  68       2.719   8.166  28.804  1.00 32.71           C  
ATOM    504  CG  GLU A  68       2.318   6.847  28.125  1.00 45.59           C  
ATOM    505  N   THR A  69       2.772  11.400  28.952  1.00 32.10           N  
ATOM    506  CA  THR A  69       3.367  12.488  29.756  1.00 35.87           C  
ATOM    507  C   THR A  69       2.732  13.850  29.474  1.00 34.09           C  
ATOM    508  O   THR A  69       2.811  14.736  30.276  1.00 35.85           O  
ATOM    509  CB  THR A  69       4.936  12.570  29.547  1.00 34.75           C  
ATOM    510  OG1 THR A  69       5.245  13.191  28.283  1.00 34.02           O  
ATOM    511  CG2 THR A  69       5.581  11.195  29.584  1.00 42.62           C  
ATOM    512  N   GLY A  70       2.165  14.040  28.288  1.00 29.87           N  
ATOM    513  CA  GLY A  70       1.651  15.305  27.901  1.00 31.52           C  
ATOM    514  C   GLY A  70       2.644  16.465  27.786  1.00 31.92           C  
ATOM    515  O   GLY A  70       2.228  17.597  27.717  1.00 33.24           O  
ATOM    516  N   ARG A  71       3.941  16.213  27.759  1.00 29.89           N  
ATOM    517  CA  ARG A  71       4.905  17.325  27.713  1.00 30.99           C  
ATOM    518  C   ARG A  71       5.743  17.204  26.464  1.00 30.35           C  
ATOM    519  O   ARG A  71       6.041  16.088  26.039  1.00 29.74           O  
ATOM    520  CB  ARG A  71       5.799  17.303  28.947  1.00 31.24           C  
ATOM    521  CG  ARG A  71       5.043  17.660  30.230  1.00 38.64           C  
ATOM    522  CD  ARG A  71       5.957  17.490  31.406  1.00 43.41           C  
ATOM    523  NE  ARG A  71       5.312  17.829  32.691  1.00 51.96           N  
ATOM    524  N   VAL A  72       6.129  18.347  25.899  1.00 30.99           N  
ATOM    525  CA  VAL A  72       6.823  18.387  24.599  1.00 29.63           C  
ATOM    526  C   VAL A  72       7.647  19.658  24.516  1.00 29.51           C  
ATOM    527  O   VAL A  72       7.257  20.702  25.036  1.00 29.36           O  
ATOM    528  CB  VAL A  72       5.852  18.229  23.404  1.00 29.09           C  
ATOM    529  CG1 VAL A  72       4.891  19.382  23.277  1.00 32.47           C  
ATOM    530  CG2 VAL A  72       6.567  17.977  22.123  1.00 31.97           C  
ATOM    531  N   ARG A  73       8.780  19.549  23.825  1.00 28.47           N  
ATOM    532  CA  ARG A  73       9.534  20.704  23.387  1.00 30.61           C  
ATOM    533  C   ARG A  73       9.677  20.663  21.844  1.00 29.07           C  
ATOM    534  O   ARG A  73       9.846  19.591  21.234  1.00 32.53           O  
ATOM    535  CB  ARG A  73      10.920  20.760  24.041  1.00 30.49           C  
ATOM    536  CG  ARG A  73      10.968  20.545  25.520  1.00 36.04           C  
ATOM    537  CD  ARG A  73      10.386  21.723  26.192  1.00 40.80           C  
ATOM    538  NE  ARG A  73      10.338  21.550  27.649  1.00 45.57           N  
ATOM    539  CZ  ARG A  73      11.145  22.151  28.522  1.00 38.56           C  
ATOM    540  NH1 ARG A  73      12.067  22.992  28.143  1.00 47.44           N  
ATOM    541  NH2 ARG A  73      10.983  21.945  29.811  1.00 45.62           N  
ATOM    542  N   LEU A  74       9.552  21.819  21.241  1.00 29.45           N  
ATOM    543  CA  LEU A  74       9.688  22.007  19.772  1.00 29.56           C  
ATOM    544  C   LEU A  74      10.849  22.935  19.460  1.00 29.18           C  
ATOM    545  O   LEU A  74      10.949  24.017  20.035  1.00 33.39           O  
ATOM    546  CB  LEU A  74       8.400  22.571  19.158  1.00 30.47           C  
ATOM    547  CG  LEU A  74       7.057  21.883  19.480  1.00 33.24           C  
ATOM    548  CD1 LEU A  74       5.910  22.706  18.858  1.00 34.83           C  
ATOM    549  CD2 LEU A  74       7.075  20.487  18.949  1.00 34.57           C  
ATOM    550  N   GLY A  75      11.733  22.480  18.567  1.00 27.50           N  
ATOM    551  CA  GLY A  75      12.841  23.262  17.991  1.00 30.07           C  
ATOM    552  C   GLY A  75      12.506  23.558  16.537  1.00 27.80           C  
ATOM    553  O   GLY A  75      12.351  22.638  15.724  1.00 29.18           O  
ATOM    554  N   ILE A  76      12.319  24.834  16.233  1.00 29.48           N  
ATOM    555  CA  ILE A  76      11.866  25.272  14.915  1.00 27.66           C  
ATOM    556  C   ILE A  76      12.816  26.327  14.394  1.00 32.69           C  
ATOM    557  O   ILE A  76      13.307  27.209  15.120  1.00 32.05           O  
ATOM    558  CB  ILE A  76      10.436  25.847  14.938  1.00 26.71           C  
ATOM    559  CG1 ILE A  76       9.458  24.706  15.281  1.00 29.78           C  
ATOM    560  CG2 ILE A  76      10.084  26.483  13.582  1.00 29.65           C  
ATOM    561  CD1 ILE A  76       8.084  25.174  15.671  1.00 34.22           C  
ATOM    562  N   GLY A  77      13.112  26.176  13.119  1.00 30.67           N  
ATOM    563  CA  GLY A  77      13.836  27.163  12.376  1.00 29.39           C  
ATOM    564  C   GLY A  77      15.230  26.760  12.006  1.00 33.14           C  
ATOM    565  O   GLY A  77      15.768  25.777  12.550  1.00 32.45           O  
ATOM    566  N   PRO A  78      15.828  27.520  11.070  1.00 34.64           N  
ATOM    567  CA  PRO A  78      17.102  27.208  10.526  1.00 37.48           C  
ATOM    568  C   PRO A  78      18.153  27.691  11.463  1.00 37.00           C  
ATOM    569  O   PRO A  78      17.855  28.255  12.564  1.00 37.71           O  
ATOM    570  CB  PRO A  78      17.133  28.036   9.221  1.00 39.27           C  
ATOM    571  CG  PRO A  78      16.485  29.277   9.607  1.00 39.67           C  
ATOM    572  CD  PRO A  78      15.311  28.783  10.489  1.00 35.86           C  
ATOM    573  N   THR A  79      19.382  27.454  11.032  1.00 39.79           N  
ATOM    574  CA  THR A  79      20.569  27.712  11.835  1.00 40.62           C  
ATOM    575  C   THR A  79      20.597  29.177  12.315  1.00 42.30           C  
ATOM    576  O   THR A  79      20.479  30.121  11.489  1.00 42.09           O  
ATOM    577  CB  THR A  79      21.853  27.458  11.013  1.00 39.59           C  
ATOM    578  OG1 THR A  79      21.862  26.099  10.522  1.00 45.18           O  
ATOM    579  CG2 THR A  79      23.079  27.745  11.869  1.00 44.04           C  
ATOM    580  N   ARG A  80      20.739  29.366  13.631  1.00 38.35           N  
ATOM    581  CA  ARG A  80      20.909  30.712  14.177  1.00 43.82           C  
ATOM    582  C   ARG A  80      19.737  31.652  13.841  1.00 42.05           C  
ATOM    583  O   ARG A  80      19.925  32.860  13.798  1.00 39.11           O  
ATOM    584  CB  ARG A  80      22.242  31.364  13.709  1.00 47.96           C  
ATOM    585  CG  ARG A  80      23.560  30.675  14.173  1.00 49.16           C  
ATOM    586  CD  ARG A  80      23.891  30.913  15.645  1.00 50.74           C  
ATOM    587  NE  ARG A  80      24.870  29.931  16.146  1.00 51.31           N  
ATOM    588  CZ  ARG A  80      26.195  30.109  16.217  1.00 51.63           C  
ATOM    589  NH1 ARG A  80      26.764  31.255  15.836  1.00 56.27           N  
ATOM    590  NH2 ARG A  80      26.970  29.126  16.692  1.00 43.07           N  
ATOM    591  N   ASP A  81      18.552  31.076  13.605  1.00 33.65           N  
ATOM    592  CA  ASP A  81      17.286  31.788  13.640  1.00 36.00           C  
ATOM    593  C   ASP A  81      16.213  30.842  14.220  1.00 33.17           C  
ATOM    594  O   ASP A  81      15.315  30.323  13.549  1.00 37.67           O  
ATOM    595  CB  ASP A  81      16.924  32.310  12.260  1.00 39.64           C  
ATOM    596  CG  ASP A  81      15.757  33.267  12.299  1.00 45.53           C  
ATOM    597  OD1 ASP A  81      15.292  33.652  13.427  1.00 36.94           O  
ATOM    598  OD2 ASP A  81      15.281  33.609  11.194  1.00 54.41           O  
ATOM    599  N   LEU A  82      16.365  30.570  15.501  1.00 33.39           N  
ATOM    600  CA  LEU A  82      15.643  29.481  16.143  1.00 32.33           C  
ATOM    601  C   LEU A  82      14.499  29.983  16.949  1.00 30.71           C  
ATOM    602  O   LEU A  82      14.515  31.146  17.468  1.00 31.78           O  
ATOM    603  CB  LEU A  82      16.594  28.665  17.048  1.00 35.38           C  
ATOM    604  CG  LEU A  82      17.821  28.012  16.384  1.00 37.01           C  
ATOM    605  CD1 LEU A  82      18.733  27.465  17.459  1.00 41.91           C  
ATOM    606  CD2 LEU A  82      17.543  26.946  15.358  1.00 42.71           C  
ATOM    607  N   VAL A  83      13.494  29.110  17.036  1.00 31.65           N  
ATOM    608  CA  VAL A  83      12.383  29.228  17.942  1.00 30.47           C  
ATOM    609  C   VAL A  83      12.274  27.922  18.782  1.00 32.04           C  
ATOM    610  O   VAL A  83      12.302  26.801  18.259  1.00 30.59           O  
ATOM    611  CB  VAL A  83      11.077  29.466  17.174  1.00 32.53           C  
ATOM    612  CG1 VAL A  83       9.948  29.683  18.152  1.00 31.51           C  
ATOM    613  CG2 VAL A  83      11.201  30.660  16.225  1.00 32.44           C  
ATOM    614  N   LEU A  84      12.230  28.098  20.093  1.00 28.93           N  
ATOM    615  CA  LEU A  84      12.148  27.010  21.030  1.00 28.73           C  
ATOM    616  C   LEU A  84      10.860  27.121  21.844  1.00 28.56           C  
ATOM    617  O   LEU A  84      10.624  28.128  22.517  1.00 30.18           O  
ATOM    618  CB  LEU A  84      13.393  27.046  21.926  1.00 28.02           C  
ATOM    619  CG  LEU A  84      13.548  25.942  22.970  1.00 34.78           C  
ATOM    620  CD1 LEU A  84      13.565  24.532  22.397  1.00 42.06           C  
ATOM    621  CD2 LEU A  84      14.851  26.245  23.691  1.00 39.92           C  
ATOM    622  N   VAL A  85      10.024  26.090  21.754  1.00 30.86           N  
ATOM    623  CA  VAL A  85       8.714  26.101  22.373  1.00 30.93           C  
ATOM    624  C   VAL A  85       8.639  25.026  23.460  1.00 32.65           C  
ATOM    625  O   VAL A  85       9.033  23.878  23.229  1.00 31.36           O  
ATOM    626  CB  VAL A  85       7.594  25.884  21.326  1.00 33.25           C  
ATOM    627  CG1 VAL A  85       6.221  25.974  21.978  1.00 30.06           C  
ATOM    628  CG2 VAL A  85       7.703  26.865  20.168  1.00 29.10           C  
ATOM    629  N   GLU A  86       8.133  25.394  24.645  1.00 31.06           N  
ATOM    630  CA  GLU A  86       7.750  24.407  25.656  0.50 32.38           C  
ATOM    632  C   GLU A  86       6.241  24.380  25.701  1.00 32.26           C  
ATOM    633  O   GLU A  86       5.574  25.437  25.829  1.00 28.66           O  
ATOM    634  CB  GLU A  86       8.248  24.741  27.067  0.50 31.58           C  
ATOM    636  CG  GLU A  86       9.690  25.197  27.176  0.50 33.54           C  
ATOM    638  CD  GLU A  86      10.129  25.309  28.635  0.50 36.14           C  
ATOM    640  OE1 GLU A  86       9.619  24.532  29.467  0.50 51.58           O  
ATOM    642  OE2 GLU A  86      10.990  26.143  28.947  0.50 45.31           O  
ATOM    644  N   GLY A  87       5.691  23.174  25.656  1.00 32.79           N  
ATOM    645  CA  GLY A  87       4.234  23.018  25.574  1.00 32.48           C  
ATOM    646  C   GLY A  87       3.680  21.766  26.229  1.00 28.54           C  
ATOM    647  O   GLY A  87       4.401  20.837  26.612  1.00 30.62           O  
ATOM    648  N   THR A  88       2.362  21.740  26.338  1.00 29.32           N  
ATOM    649  CA  THR A  88       1.640  20.605  26.864  1.00 31.05           C  
ATOM    650  C   THR A  88       0.803  20.081  25.692  1.00 31.54           C  
ATOM    651  O   THR A  88       0.352  20.873  24.851  1.00 35.97           O  
ATOM    652  CB  THR A  88       0.716  21.012  28.054  1.00 33.82           C  
ATOM    653  OG1 THR A  88      -0.138  22.067  27.651  1.00 36.96           O  
ATOM    654  CG2 THR A  88       1.530  21.428  29.271  1.00 36.73           C  
ATOM    655  N   ALA A  89       0.636  18.766  25.623  1.00 28.68           N  
ATOM    656  CA  ALA A  89       0.015  18.105  24.500  1.00 28.76           C  
ATOM    657  C   ALA A  89      -1.177  17.239  24.898  1.00 29.79           C  
ATOM    658  O   ALA A  89      -1.102  16.491  25.883  1.00 33.34           O  
ATOM    659  CB  ALA A  89       1.086  17.258  23.798  1.00 30.90           C  
ATOM    660  N   LEU A  90      -2.257  17.318  24.121  1.00 30.15           N  
ATOM    661  CA  LEU A  90      -3.441  16.490  24.308  1.00 30.14           C  
ATOM    662  C   LEU A  90      -3.818  15.793  23.012  1.00 31.56           C  
ATOM    663  O   LEU A  90      -3.667  16.363  21.916  1.00 30.99           O  
ATOM    664  CB  LEU A  90      -4.623  17.304  24.861  1.00 32.69           C  
ATOM    665  CG  LEU A  90      -4.405  17.814  26.285  1.00 31.13           C  
ATOM    666  CD1 LEU A  90      -5.540  18.826  26.655  1.00 38.00           C  
ATOM    667  CD2 LEU A  90      -4.333  16.690  27.284  1.00 39.30           C  
ATOM    668  N   PRO A  91      -4.293  14.544  23.112  1.00 31.48           N  
ATOM    669  CA  PRO A  91      -4.575  13.773  21.892  1.00 30.54           C  
ATOM    670  C   PRO A  91      -5.943  14.094  21.273  1.00 31.90           C  
ATOM    671  O   PRO A  91      -6.887  14.382  21.978  1.00 31.62           O  
ATOM    672  CB  PRO A  91      -4.572  12.324  22.410  1.00 32.01           C  
ATOM    673  CG  PRO A  91      -5.124  12.461  23.861  1.00 36.49           C  
ATOM    674  CD  PRO A  91      -4.549  13.776  24.352  1.00 34.37           C  
ATOM    675  N   LEU A  92      -6.046  14.009  19.958  1.00 34.77           N  
ATOM    676  CA  LEU A  92      -7.337  14.095  19.251  1.00 34.31           C  
ATOM    677  C   LEU A  92      -7.336  12.910  18.302  1.00 33.43           C  
ATOM    678  O   LEU A  92      -6.373  12.694  17.536  1.00 30.25           O  
ATOM    679  CB  LEU A  92      -7.464  15.423  18.480  1.00 33.80           C  
ATOM    680  CG  LEU A  92      -7.493  16.697  19.313  1.00 38.22           C  
ATOM    681  CD1 LEU A  92      -7.252  17.911  18.464  1.00 36.14           C  
ATOM    682  CD2 LEU A  92      -8.825  16.801  20.080  1.00 40.10           C  
ATOM    683  N   GLU A  93      -8.386  12.108  18.365  1.00 30.58           N  
ATOM    684  CA  GLU A  93      -8.607  11.085  17.378  1.00 32.70           C  
ATOM    685  C   GLU A  93      -8.925  11.724  16.016  1.00 34.61           C  
ATOM    686  O   GLU A  93      -9.587  12.753  15.959  1.00 34.41           O  
ATOM    687  CB  GLU A  93      -9.804  10.222  17.761  1.00 36.89           C  
ATOM    688  CG  GLU A  93      -9.730   9.578  19.148  1.00 44.85           C  
ATOM    689  CD  GLU A  93      -8.890   8.332  19.165  1.00 52.55           C  
ATOM    690  OE1 GLU A  93      -8.591   7.790  18.071  1.00 62.89           O  
ATOM    691  OE2 GLU A  93      -8.519   7.898  20.271  1.00 60.43           O  
ATOM    692  N   PRO A  94      -8.477  11.096  14.918  1.00 35.72           N  
ATOM    693  CA  PRO A  94      -8.770  11.543  13.554  1.00 38.90           C  
ATOM    694  C   PRO A  94     -10.249  11.817  13.291  1.00 45.12           C  
ATOM    695  O   PRO A  94     -10.553  12.807  12.653  1.00 46.04           O  
ATOM    696  CB  PRO A  94      -8.249  10.399  12.709  1.00 39.16           C  
ATOM    697  CG  PRO A  94      -7.046   9.935  13.479  1.00 39.04           C  
ATOM    698  CD  PRO A  94      -7.563   9.941  14.899  1.00 38.17           C  
ATOM    699  N   ALA A  95     -11.150  11.006  13.845  1.00 48.12           N  
ATOM    700  CA  ALA A  95     -12.583  11.289  13.757  1.00 49.14           C  
ATOM    701  C   ALA A  95     -13.097  12.388  14.700  1.00 50.09           C  
ATOM    702  O   ALA A  95     -14.263  12.752  14.616  1.00 55.91           O  
ATOM    703  CB  ALA A  95     -13.386  10.005  13.955  1.00 51.03           C  
ATOM    704  N   GLY A  96     -12.268  12.924  15.587  1.00 47.43           N  
ATOM    705  CA  GLY A  96     -12.711  13.933  16.548  1.00 43.93           C  
ATOM    706  C   GLY A  96     -12.038  15.277  16.377  1.00 44.08           C  
ATOM    707  O   GLY A  96     -11.891  16.045  17.338  1.00 45.58           O  
ATOM    708  N   LEU A  97     -11.568  15.567  15.162  1.00 43.15           N  
ATOM    709  CA  LEU A  97     -10.939  16.881  14.889  1.00 39.83           C  
ATOM    710  C   LEU A  97     -12.029  17.919  14.763  1.00 37.35           C  
ATOM    711  O   LEU A  97     -13.095  17.596  14.330  1.00 29.89           O  
ATOM    712  CB  LEU A  97     -10.177  16.879  13.565  1.00 39.96           C  
ATOM    713  CG  LEU A  97      -8.906  16.045  13.544  1.00 39.23           C  
ATOM    714  CD1 LEU A  97      -8.354  16.043  12.127  1.00 43.77           C  
ATOM    715  CD2 LEU A  97      -7.915  16.661  14.506  1.00 37.84           C  
ATOM    716  N   PRO A  98     -11.759  19.160  15.152  1.00 35.64           N  
ATOM    717  CA  PRO A  98     -12.757  20.205  14.820  1.00 35.17           C  
ATOM    718  C   PRO A  98     -12.982  20.310  13.303  1.00 33.26           C  
ATOM    719  O   PRO A  98     -12.090  19.958  12.515  1.00 36.21           O  
ATOM    720  CB  PRO A  98     -12.092  21.511  15.295  1.00 33.79           C  
ATOM    721  CG  PRO A  98     -10.967  21.111  16.216  1.00 41.99           C  
ATOM    722  CD  PRO A  98     -10.605  19.662  15.914  1.00 36.73           C  
ATOM    723  N   ASP A  99     -14.127  20.828  12.909  1.00 32.96           N  
ATOM    724  CA  ASP A  99     -14.437  21.052  11.504  1.00 31.32           C  
ATOM    725  C   ASP A  99     -13.316  21.785  10.789  1.00 29.96           C  
ATOM    726  O   ASP A  99     -12.794  22.798  11.267  1.00 31.44           O  
ATOM    727  CB  ASP A  99     -15.759  21.825  11.361  1.00 31.00           C  
ATOM    728  CG  ASP A  99     -16.959  21.064  11.933  1.00 35.49           C  
ATOM    729  OD1 ASP A  99     -16.852  19.846  12.121  1.00 31.81           O  
ATOM    730  OD2 ASP A  99     -18.032  21.665  12.193  1.00 34.20           O  
ATOM    731  N   GLY A 100     -12.879  21.234   9.669  1.00 31.38           N  
ATOM    732  CA  GLY A 100     -11.952  21.949   8.791  1.00 33.41           C  
ATOM    733  C   GLY A 100     -10.475  21.716   9.122  1.00 32.21           C  
ATOM    734  O   GLY A 100      -9.599  21.891   8.274  1.00 33.42           O  
ATOM    735  N   VAL A 101     -10.180  21.271  10.330  1.00 31.70           N  
ATOM    736  CA  VAL A 101      -8.805  21.143  10.742  1.00 30.67           C  
ATOM    737  C   VAL A 101      -8.001  20.038  10.024  1.00 31.75           C  
ATOM    738  O   VAL A 101      -6.813  20.244   9.694  1.00 31.92           O  
ATOM    739  CB  VAL A 101      -8.716  20.962  12.283  1.00 32.95           C  
ATOM    740  CG1 VAL A 101      -7.325  20.584  12.663  1.00 32.88           C  
ATOM    741  CG2 VAL A 101      -9.192  22.272  13.003  1.00 35.27           C  
ATOM    742  N   GLY A 102      -8.624  18.890   9.792  1.00 30.71           N  
ATOM    743  CA  GLY A 102      -7.968  17.784   9.107  1.00 33.28           C  
ATOM    744  C   GLY A 102      -7.526  18.197   7.699  1.00 32.91           C  
ATOM    745  O   GLY A 102      -6.384  17.919   7.291  1.00 32.36           O  
ATOM    746  N   ASP A 103      -8.423  18.876   6.979  1.00 30.24           N  
ATOM    747  CA  ASP A 103      -8.113  19.413   5.662  1.00 31.56           C  
ATOM    748  C   ASP A 103      -6.954  20.410   5.688  1.00 32.70           C  
ATOM    749  O   ASP A 103      -6.034  20.319   4.865  1.00 34.62           O  
ATOM    750  CB  ASP A 103      -9.313  20.110   5.017  1.00 35.37           C  
ATOM    751  CG  ASP A 103     -10.382  19.142   4.530  1.00 44.56           C  
ATOM    752  OD1 ASP A 103     -10.161  17.912   4.516  1.00 37.45           O  
ATOM    753  OD2 ASP A 103     -11.463  19.639   4.118  1.00 46.33           O  
ATOM    754  N   THR A 104      -6.975  21.332   6.635  1.00 33.38           N  
ATOM    755  CA  THR A 104      -5.921  22.309   6.761  1.00 33.98           C  
ATOM    756  C   THR A 104      -4.589  21.612   7.047  1.00 33.80           C  
ATOM    757  O   THR A 104      -3.558  21.972   6.451  1.00 34.10           O  
ATOM    758  CB  THR A 104      -6.243  23.378   7.811  1.00 34.36           C  
ATOM    759  OG1 THR A 104      -7.526  23.957   7.502  1.00 34.03           O  
ATOM    760  CG2 THR A 104      -5.180  24.515   7.797  1.00 34.77           C  
ATOM    761  N   PHE A 105      -4.603  20.647   7.970  1.00 32.99           N  
ATOM    762  CA  PHE A 105      -3.420  19.924   8.328  1.00 31.56           C  
ATOM    763  C   PHE A 105      -2.826  19.220   7.079  1.00 34.52           C  
ATOM    764  O   PHE A 105      -1.585  19.300   6.852  1.00 34.51           O  
ATOM    765  CB  PHE A 105      -3.695  18.866   9.406  1.00 32.23           C  
ATOM    766  CG  PHE A 105      -2.475  18.095   9.820  1.00 32.33           C  
ATOM    767  CD1 PHE A 105      -1.665  18.563  10.818  1.00 30.99           C  
ATOM    768  CD2 PHE A 105      -2.181  16.862   9.239  1.00 35.88           C  
ATOM    769  CE1 PHE A 105      -0.539  17.825  11.236  1.00 37.72           C  
ATOM    770  CE2 PHE A 105      -1.082  16.122   9.641  1.00 33.90           C  
ATOM    771  CZ  PHE A 105      -0.256  16.612  10.626  1.00 30.47           C  
ATOM    772  N   ALA A 106      -3.679  18.501   6.350  1.00 35.99           N  
ATOM    773  CA  ALA A 106      -3.271  17.763   5.140  1.00 36.94           C  
ATOM    774  C   ALA A 106      -2.674  18.670   4.083  1.00 40.16           C  
ATOM    775  O   ALA A 106      -1.695  18.275   3.439  1.00 38.97           O  
ATOM    776  CB  ALA A 106      -4.407  16.971   4.556  1.00 36.99           C  
ATOM    777  N   GLU A 107      -3.240  19.875   3.915  1.00 38.12           N  
ATOM    778  CA  GLU A 107      -2.733  20.850   2.950  1.00 43.40           C  
ATOM    779  C   GLU A 107      -1.397  21.401   3.374  1.00 44.28           C  
ATOM    780  O   GLU A 107      -0.559  21.649   2.528  1.00 43.37           O  
ATOM    781  CB  GLU A 107      -3.673  22.060   2.765  1.00 43.56           C  
ATOM    782  CG  GLU A 107      -4.971  21.780   2.033  1.00 51.91           C  
ATOM    783  CD  GLU A 107      -6.122  22.811   2.329  1.00 53.28           C  
ATOM    784  OE1 GLU A 107      -5.934  23.866   3.045  1.00 55.85           O  
ATOM    785  OE2 GLU A 107      -7.248  22.506   1.863  1.00 65.49           O  
ATOM    786  N   LYS A 108      -1.196  21.655   4.668  1.00 37.47           N  
ATOM    787  CA  LYS A 108       0.067  22.147   5.133  1.00 39.00           C  
ATOM    788  C   LYS A 108       1.211  21.104   5.050  1.00 40.43           C  
ATOM    789  O   LYS A 108       2.361  21.473   4.740  1.00 39.76           O  
ATOM    790  CB  LYS A 108      -0.053  22.684   6.565  1.00 37.88           C  
ATOM    791  CG  LYS A 108       1.223  23.104   7.262  1.00 40.76           C  
ATOM    792  CD  LYS A 108       1.777  24.449   6.815  1.00 44.76           C  
ATOM    793  CE  LYS A 108       3.185  24.721   7.450  1.00 47.77           C  
ATOM    794  NZ  LYS A 108       3.353  24.436   9.007  1.00 32.65           N  
ATOM    795  N   THR A 109       0.915  19.843   5.366  1.00 39.45           N  
ATOM    796  CA  THR A 109       1.957  18.866   5.617  1.00 37.93           C  
ATOM    797  C   THR A 109       2.133  17.862   4.506  1.00 40.39           C  
ATOM    798  O   THR A 109       3.127  17.187   4.475  1.00 42.17           O  
ATOM    799  CB  THR A 109       1.703  18.021   6.900  1.00 37.69           C  
ATOM    800  OG1 THR A 109       0.551  17.185   6.719  1.00 37.77           O  
ATOM    801  CG2 THR A 109       1.564  18.930   8.180  1.00 36.16           C  
ATOM    802  N   GLY A 110       1.125  17.673   3.667  1.00 42.84           N  
ATOM    803  CA  GLY A 110       1.192  16.651   2.652  1.00 41.24           C  
ATOM    804  C   GLY A 110       0.732  15.288   3.021  1.00 43.44           C  
ATOM    805  O   GLY A 110       0.831  14.391   2.217  1.00 45.96           O  
ATOM    806  N   PHE A 111       0.226  15.080   4.219  1.00 43.03           N  
ATOM    807  CA  PHE A 111      -0.330  13.764   4.517  1.00 41.79           C  
ATOM    808  C   PHE A 111      -1.577  13.888   5.363  1.00 39.60           C  
ATOM    809  O   PHE A 111      -1.778  14.903   6.013  1.00 42.59           O  
ATOM    810  CB  PHE A 111       0.715  12.794   5.116  1.00 45.76           C  
ATOM    811  CG  PHE A 111       1.101  13.090   6.535  1.00 42.61           C  
ATOM    812  CD1 PHE A 111       1.965  14.125   6.831  1.00 49.68           C  
ATOM    813  CD2 PHE A 111       0.619  12.310   7.555  1.00 43.58           C  
ATOM    814  CE1 PHE A 111       2.334  14.381   8.163  1.00 46.65           C  
ATOM    815  CE2 PHE A 111       0.967  12.557   8.865  1.00 46.05           C  
ATOM    816  CZ  PHE A 111       1.824  13.595   9.168  1.00 43.26           C  
ATOM    817  N   ASP A 112      -2.429  12.877   5.284  1.00 37.79           N  
ATOM    818  CA  ASP A 112      -3.724  12.902   5.900  1.00 40.72           C  
ATOM    819  C   ASP A 112      -3.972  11.604   6.685  1.00 43.68           C  
ATOM    820  O   ASP A 112      -4.415  10.595   6.121  1.00 45.51           O  
ATOM    821  CB  ASP A 112      -4.783  13.144   4.837  1.00 40.92           C  
ATOM    822  CG  ASP A 112      -6.148  13.349   5.406  1.00 44.92           C  
ATOM    823  OD1 ASP A 112      -6.329  13.245   6.639  1.00 42.92           O  
ATOM    824  OD2 ASP A 112      -7.058  13.619   4.592  1.00 36.89           O  
ATOM    825  N   PRO A 113      -3.676  11.632   8.002  1.00 43.74           N  
ATOM    826  CA  PRO A 113      -3.931  10.523   8.951  1.00 46.27           C  
ATOM    827  C   PRO A 113      -5.309   9.898   8.898  1.00 46.67           C  
ATOM    828  O   PRO A 113      -5.434   8.688   9.121  1.00 48.82           O  
ATOM    829  CB  PRO A 113      -3.704  11.193  10.324  1.00 45.32           C  
ATOM    830  CG  PRO A 113      -2.641  12.185  10.026  1.00 41.46           C  
ATOM    831  CD  PRO A 113      -2.997  12.760   8.684  1.00 41.64           C  
ATOM    832  N   ARG A 114      -6.325  10.703   8.595  1.00 46.20           N  
ATOM    833  CA  ARG A 114      -7.683  10.214   8.449  1.00 43.98           C  
ATOM    834  C   ARG A 114      -7.800   9.120   7.366  1.00 45.83           C  
ATOM    835  O   ARG A 114      -8.631   8.237   7.483  1.00 49.76           O  
ATOM    836  CB  ARG A 114      -8.659  11.370   8.132  1.00 42.74           C  
ATOM    837  CG  ARG A 114      -8.585  12.571   9.050  1.00 45.75           C  
ATOM    838  CD  ARG A 114      -9.415  13.734   8.552  1.00 43.00           C  
ATOM    839  NE  ARG A 114      -8.816  14.338   7.378  1.00 45.81           N  
ATOM    840  CZ  ARG A 114      -9.364  15.319   6.683  1.00 37.33           C  
ATOM    841  NH1 ARG A 114     -10.516  15.882   7.056  1.00 39.33           N  
ATOM    842  NH2 ARG A 114      -8.745  15.757   5.616  1.00 44.01           N  
ATOM    843  N   ARG A 115      -6.949   9.176   6.349  1.00 47.35           N  
ATOM    844  CA  ARG A 115      -6.966   8.238   5.225  1.00 49.99           C  
ATOM    845  C   ARG A 115      -5.936   7.090   5.329  1.00 51.70           C  
ATOM    846  O   ARG A 115      -5.701   6.408   4.345  1.00 52.99           O  
ATOM    847  CB  ARG A 115      -6.679   9.016   3.922  1.00 49.73           C  
ATOM    848  CG  ARG A 115      -7.686  10.144   3.601  1.00 54.22           C  
ATOM    849  N   LEU A 116      -5.293   6.892   6.481  1.00 49.93           N  
ATOM    850  CA  LEU A 116      -4.247   5.879   6.587  1.00 48.37           C  
ATOM    851  C   LEU A 116      -4.729   4.745   7.458  1.00 47.86           C  
ATOM    852  O   LEU A 116      -5.507   4.953   8.380  1.00 49.52           O  
ATOM    853  CB  LEU A 116      -2.948   6.477   7.154  1.00 47.11           C  
ATOM    854  CG  LEU A 116      -2.320   7.581   6.327  1.00 45.79           C  
ATOM    855  CD1 LEU A 116      -1.145   8.265   7.067  1.00 49.31           C  
ATOM    856  CD2 LEU A 116      -1.882   7.093   4.976  1.00 48.38           C  
ATOM    857  N   THR A 117      -4.235   3.547   7.192  1.00 46.56           N  
ATOM    858  CA  THR A 117      -4.687   2.351   7.907  1.00 48.00           C  
ATOM    859  C   THR A 117      -4.084   2.276   9.296  1.00 44.85           C  
ATOM    860  O   THR A 117      -4.763   1.906  10.257  1.00 45.34           O  
ATOM    861  CB  THR A 117      -4.360   1.054   7.108  1.00 49.00           C  
ATOM    862  OG1 THR A 117      -3.060   1.167   6.532  1.00 55.39           O  
ATOM    863  CG2 THR A 117      -5.334   0.890   5.994  1.00 48.38           C  
ATOM    864  N   THR A 118      -2.817   2.639   9.401  1.00 44.73           N  
ATOM    865  CA  THR A 118      -2.150   2.723  10.696  1.00 42.68           C  
ATOM    866  C   THR A 118      -2.946   3.667  11.603  1.00 40.88           C  
ATOM    867  O   THR A 118      -3.404   4.730  11.165  1.00 37.28           O  
ATOM    868  CB  THR A 118      -0.735   3.248  10.557  1.00 45.23           C  
ATOM    869  OG1 THR A 118       0.044   2.308   9.807  1.00 44.90           O  
ATOM    870  CG2 THR A 118      -0.080   3.502  11.956  1.00 45.77           C  
ATOM    871  N   SER A 119      -3.099   3.281  12.856  1.00 36.79           N  
ATOM    872  CA  SER A 119      -3.820   4.105  13.822  1.00 38.41           C  
ATOM    873  C   SER A 119      -2.965   5.342  14.309  1.00 37.35           C  
ATOM    874  O   SER A 119      -1.953   5.193  15.009  1.00 31.83           O  
ATOM    875  CB  SER A 119      -4.300   3.204  14.951  1.00 39.67           C  
ATOM    876  OG  SER A 119      -4.810   3.983  15.999  1.00 49.72           O  
ATOM    877  N   TYR A 120      -3.346   6.534  13.834  1.00 34.93           N  
ATOM    878  CA  TYR A 120      -2.715   7.802  14.190  1.00 34.33           C  
ATOM    879  C   TYR A 120      -3.471   8.514  15.294  1.00 35.22           C  
ATOM    880  O   TYR A 120      -4.698   8.406  15.407  1.00 32.91           O  
ATOM    881  CB  TYR A 120      -2.654   8.772  12.985  1.00 36.42           C  
ATOM    882  CG  TYR A 120      -1.476   8.587  12.067  1.00 33.29           C  
ATOM    883  CD1 TYR A 120      -1.379   7.443  11.266  1.00 39.48           C  
ATOM    884  CD2 TYR A 120      -0.438   9.504  12.029  1.00 37.13           C  
ATOM    885  CE1 TYR A 120      -0.281   7.231  10.444  1.00 41.56           C  
ATOM    886  CE2 TYR A 120       0.652   9.315  11.223  1.00 41.00           C  
ATOM    887  CZ  TYR A 120       0.721   8.165  10.422  1.00 42.27           C  
ATOM    888  OH  TYR A 120       1.790   7.998   9.609  1.00 44.84           O  
ATOM    889  N   LEU A 121      -2.727   9.253  16.106  1.00 31.97           N  
ATOM    890  CA  LEU A 121      -3.290  10.326  16.904  1.00 29.91           C  
ATOM    891  C   LEU A 121      -2.751  11.696  16.407  1.00 29.78           C  
ATOM    892  O   LEU A 121      -1.596  11.808  16.014  1.00 29.72           O  
ATOM    893  CB  LEU A 121      -2.930  10.136  18.368  1.00 29.93           C  
ATOM    894  CG  LEU A 121      -3.673   9.042  19.131  1.00 27.39           C  
ATOM    895  CD1 LEU A 121      -2.941   8.792  20.540  1.00 27.25           C  
ATOM    896  CD2 LEU A 121      -5.154   9.392  19.232  1.00 34.28           C  
ATOM    897  N   TYR A 122      -3.604  12.709  16.462  1.00 29.21           N  
ATOM    898  CA  TYR A 122      -3.146  14.085  16.398  1.00 31.88           C  
ATOM    899  C   TYR A 122      -2.903  14.540  17.837  1.00 32.21           C  
ATOM    900  O   TYR A 122      -3.537  14.043  18.760  1.00 34.46           O  
ATOM    901  CB  TYR A 122      -4.202  14.971  15.759  1.00 31.32           C  
ATOM    902  CG  TYR A 122      -4.518  14.702  14.287  1.00 33.27           C  
ATOM    903  CD1 TYR A 122      -5.332  13.653  13.916  1.00 30.90           C  
ATOM    904  CD2 TYR A 122      -4.011  15.528  13.273  1.00 30.47           C  
ATOM    905  CE1 TYR A 122      -5.701  13.459  12.577  1.00 36.76           C  
ATOM    906  CE2 TYR A 122      -4.361  15.317  11.933  1.00 30.73           C  
ATOM    907  CZ  TYR A 122      -5.208  14.277  11.600  1.00 33.16           C  
ATOM    908  OH  TYR A 122      -5.563  14.058  10.279  1.00 34.99           O  
ATOM    909  N   PHE A 123      -1.917  15.384  18.046  1.00 30.88           N  
ATOM    910  CA  PHE A 123      -1.739  16.033  19.300  1.00 27.52           C  
ATOM    911  C   PHE A 123      -1.784  17.528  19.103  1.00 29.40           C  
ATOM    912  O   PHE A 123      -1.066  18.060  18.258  1.00 28.27           O  
ATOM    913  CB  PHE A 123      -0.424  15.634  19.947  1.00 29.80           C  
ATOM    914  CG  PHE A 123      -0.382  14.198  20.371  1.00 30.29           C  
ATOM    915  CD1 PHE A 123       0.042  13.226  19.488  1.00 30.75           C  
ATOM    916  CD2 PHE A 123      -0.807  13.827  21.623  1.00 33.31           C  
ATOM    917  CE1 PHE A 123       0.058  11.897  19.884  1.00 34.98           C  
ATOM    918  CE2 PHE A 123      -0.818  12.505  22.001  1.00 34.16           C  
ATOM    919  CZ  PHE A 123      -0.349  11.559  21.132  1.00 30.14           C  
ATOM    920  N   ARG A 124      -2.605  18.186  19.908  1.00 27.60           N  
ATOM    921  CA  ARG A 124      -2.724  19.629  19.920  1.00 30.24           C  
ATOM    922  C   ARG A 124      -1.859  20.132  21.045  1.00 28.24           C  
ATOM    923  O   ARG A 124      -1.992  19.683  22.202  1.00 28.16           O  
ATOM    924  CB  ARG A 124      -4.170  20.042  20.129  1.00 32.03           C  
ATOM    925  CG  ARG A 124      -4.386  21.579  20.165  1.00 27.80           C  
ATOM    926  CD  ARG A 124      -5.825  22.003  19.826  1.00 36.12           C  
ATOM    927  NE  ARG A 124      -6.733  21.404  20.775  1.00 37.40           N  
ATOM    928  CZ  ARG A 124      -8.049  21.205  20.606  1.00 40.91           C  
ATOM    929  NH1 ARG A 124      -8.688  21.579  19.525  1.00 39.02           N  
ATOM    930  NH2 ARG A 124      -8.729  20.637  21.568  1.00 35.98           N  
ATOM    931  N   ILE A 125      -0.900  20.982  20.694  1.00 28.73           N  
ATOM    932  CA  ILE A 125       0.131  21.437  21.643  1.00 27.28           C  
ATOM    933  C   ILE A 125      -0.120  22.890  21.926  1.00 27.78           C  
ATOM    934  O   ILE A 125      -0.140  23.759  21.003  1.00 31.57           O  
ATOM    935  CB  ILE A 125       1.547  21.214  21.074  1.00 29.69           C  
ATOM    936  CG1 ILE A 125       1.802  19.711  20.917  1.00 33.59           C  
ATOM    937  CG2 ILE A 125       2.595  21.884  21.961  1.00 30.18           C  
ATOM    938  CD1 ILE A 125       2.840  19.354  19.872  1.00 33.81           C  
ATOM    939  N   SER A 126      -0.324  23.141  23.206  1.00 31.13           N  
ATOM    940  CA  SER A 126      -0.560  24.462  23.740  1.00 29.01           C  
ATOM    941  C   SER A 126       0.753  25.023  24.247  1.00 28.92           C  
ATOM    942  O   SER A 126       1.326  24.478  25.155  1.00 30.54           O  
ATOM    943  CB  SER A 126      -1.585  24.374  24.862  1.00 33.72           C  
ATOM    944  OG  SER A 126      -2.808  23.891  24.327  1.00 34.67           O  
ATOM    945  N   PRO A 127       1.255  26.086  23.616  1.00 30.58           N  
ATOM    946  CA  PRO A 127       2.539  26.629  24.065  1.00 33.00           C  
ATOM    947  C   PRO A 127       2.470  27.306  25.412  1.00 30.95           C  
ATOM    948  O   PRO A 127       1.492  27.953  25.730  1.00 29.50           O  
ATOM    949  CB  PRO A 127       2.894  27.669  22.992  1.00 33.17           C  
ATOM    950  CG  PRO A 127       1.766  27.790  22.117  1.00 37.37           C  
ATOM    951  CD  PRO A 127       0.704  26.811  22.467  1.00 33.06           C  
ATOM    952  N   ARG A 128       3.482  27.118  26.236  1.00 29.88           N  
ATOM    953  CA  ARG A 128       3.524  27.750  27.531  1.00 30.75           C  
ATOM    954  C   ARG A 128       4.698  28.751  27.583  1.00 33.29           C  
ATOM    955  O   ARG A 128       4.617  29.789  28.212  1.00 32.57           O  
ATOM    956  CB  ARG A 128       3.711  26.695  28.632  1.00 30.81           C  
ATOM    957  CG  ARG A 128       2.563  25.701  28.714  1.00 40.91           C  
ATOM    958  CD  ARG A 128       1.286  26.392  29.076  1.00 46.23           C  
ATOM    959  NE  ARG A 128       1.400  27.041  30.381  1.00 49.40           N  
ATOM    960  CZ  ARG A 128       0.525  27.914  30.887  1.00 49.24           C  
ATOM    961  NH1 ARG A 128      -0.545  28.273  30.210  1.00 41.11           N  
ATOM    962  NH2 ARG A 128       0.734  28.413  32.095  1.00 42.35           N  
ATOM    963  N   ARG A 129       5.804  28.373  26.964  1.00 29.67           N  
ATOM    964  CA  ARG A 129       7.000  29.203  26.907  1.00 30.51           C  
ATOM    965  C   ARG A 129       7.564  29.153  25.498  1.00 30.22           C  
ATOM    966  O   ARG A 129       7.584  28.094  24.854  1.00 31.58           O  
ATOM    967  CB  ARG A 129       8.029  28.672  27.894  1.00 30.93           C  
ATOM    968  CG  ARG A 129       9.141  29.575  28.145  1.00 39.52           C  
ATOM    969  CD  ARG A 129      10.105  28.952  29.154  1.00 51.47           C  
ATOM    970  NE  ARG A 129      11.229  29.854  29.380  1.00 58.04           N  
ATOM    971  CZ  ARG A 129      12.420  29.488  29.843  1.00 59.79           C  
ATOM    972  NH1 ARG A 129      12.713  28.211  30.088  1.00 54.42           N  
ATOM    973  NH2 ARG A 129      13.340  30.411  30.037  1.00 60.59           N  
ATOM    974  N   VAL A 130       8.013  30.299  25.032  1.00 29.89           N  
ATOM    975  CA  VAL A 130       8.684  30.448  23.742  1.00 29.31           C  
ATOM    976  C   VAL A 130       9.928  31.313  23.886  1.00 31.69           C  
ATOM    977  O   VAL A 130       9.915  32.416  24.501  1.00 30.53           O  
ATOM    978  CB  VAL A 130       7.782  31.114  22.703  1.00 29.13           C  
ATOM    979  CG1 VAL A 130       8.520  31.280  21.338  1.00 31.71           C  
ATOM    980  CG2 VAL A 130       6.445  30.345  22.552  1.00 28.46           C  
ATOM    981  N   GLN A 131      11.014  30.808  23.328  1.00 31.53           N  
ATOM    982  CA  GLN A 131      12.229  31.573  23.230  1.00 32.61           C  
ATOM    983  C   GLN A 131      12.629  31.651  21.762  1.00 35.31           C  
ATOM    984  O   GLN A 131      12.394  30.703  20.993  1.00 35.34           O  
ATOM    985  CB  GLN A 131      13.301  30.947  24.082  1.00 34.22           C  
ATOM    986  CG  GLN A 131      12.934  30.928  25.581  1.00 38.75           C  
ATOM    987  CD  GLN A 131      13.915  30.093  26.312  1.00 56.39           C  
ATOM    988  OE1 GLN A 131      14.939  30.599  26.741  1.00 51.19           O  
ATOM    989  NE2 GLN A 131      13.661  28.774  26.385  1.00 57.28           N  
ATOM    990  N   ALA A 132      13.182  32.795  21.366  1.00 31.81           N  
ATOM    991  CA  ALA A 132      13.583  33.019  19.952  1.00 30.85           C  
ATOM    992  C   ALA A 132      14.807  33.821  19.904  1.00 36.36           C  
ATOM    993  O   ALA A 132      14.863  34.891  20.528  1.00 38.35           O  
ATOM    994  CB  ALA A 132      12.494  33.725  19.189  1.00 34.05           C  
ATOM    995  N   TRP A 133      15.819  33.329  19.231  1.00 37.21           N  
ATOM    996  CA  TRP A 133      16.982  34.178  19.022  1.00 42.98           C  
ATOM    997  C   TRP A 133      17.831  33.805  17.816  1.00 41.45           C  
ATOM    998  O   TRP A 133      17.765  32.692  17.303  1.00 39.00           O  
ATOM    999  CB  TRP A 133      17.858  34.181  20.286  1.00 43.42           C  
ATOM   1000  CG  TRP A 133      18.567  32.861  20.658  1.00 45.59           C  
ATOM   1001  CD1 TRP A 133      19.904  32.589  20.519  1.00 49.38           C  
ATOM   1002  CD2 TRP A 133      17.990  31.689  21.270  1.00 51.93           C  
ATOM   1003  NE1 TRP A 133      20.183  31.326  21.000  1.00 45.99           N  
ATOM   1004  CE2 TRP A 133      19.037  30.756  21.467  1.00 45.91           C  
ATOM   1005  CE3 TRP A 133      16.698  31.344  21.691  1.00 51.72           C  
ATOM   1006  CZ2 TRP A 133      18.833  29.511  22.070  1.00 44.31           C  
ATOM   1007  CZ3 TRP A 133      16.492  30.077  22.263  1.00 52.62           C  
ATOM   1008  CH2 TRP A 133      17.565  29.189  22.463  1.00 48.41           C  
ATOM   1009  N   ARG A 134      18.640  34.770  17.408  1.00 45.42           N  
ATOM   1010  CA  ARG A 134      19.539  34.654  16.262  1.00 46.29           C  
ATOM   1011  C   ARG A 134      20.976  34.543  16.772  1.00 46.45           C  
ATOM   1012  O   ARG A 134      21.401  33.478  17.174  1.00 44.26           O  
ATOM   1013  CB  ARG A 134      19.328  35.832  15.297  1.00 45.15           C  
ATOM   1014  CG  ARG A 134      17.931  35.850  14.804  1.00 47.67           C  
ATOM   1015  CD  ARG A 134      17.611  36.871  13.710  1.00 42.44           C  
ATOM   1016  NE  ARG A 134      16.330  36.469  13.101  1.00 41.77           N  
ATOM   1017  CZ  ARG A 134      15.618  37.176  12.221  1.00 53.20           C  
ATOM   1018  NH1 ARG A 134      16.038  38.369  11.825  1.00 57.11           N  
ATOM   1019  NH2 ARG A 134      14.484  36.656  11.721  1.00 42.43           N  
ATOM   1020  N   GLU A 135      21.739  35.614  16.783  1.00 48.20           N  
ATOM   1021  CA  GLU A 135      23.139  35.443  17.176  1.00 52.06           C  
ATOM   1022  C   GLU A 135      23.221  35.634  18.672  1.00 51.16           C  
ATOM   1023  O   GLU A 135      22.189  35.804  19.329  1.00 48.67           O  
ATOM   1024  CB  GLU A 135      24.054  36.392  16.389  1.00 54.16           C  
ATOM   1025  CG  GLU A 135      24.143  36.046  14.876  1.00 60.60           C  
ATOM   1026  CD  GLU A 135      24.825  34.692  14.576  1.00 69.43           C  
ATOM   1027  OE1 GLU A 135      25.667  34.248  15.392  1.00 68.38           O  
ATOM   1028  OE2 GLU A 135      24.518  34.080  13.515  1.00 66.54           O  
ATOM   1029  N   ALA A 136      24.445  35.587  19.202  1.00 48.07           N  
ATOM   1030  CA  ALA A 136      24.689  35.716  20.637  1.00 46.95           C  
ATOM   1031  C   ALA A 136      24.104  37.003  21.215  1.00 45.27           C  
ATOM   1032  O   ALA A 136      23.635  36.995  22.361  1.00 44.57           O  
ATOM   1033  CB  ALA A 136      26.198  35.636  20.938  1.00 49.64           C  
ATOM   1034  N   ASN A 137      24.119  38.092  20.424  1.00 43.97           N  
ATOM   1035  CA  ASN A 137      23.562  39.391  20.855  1.00 43.69           C  
ATOM   1036  C   ASN A 137      22.077  39.367  21.208  1.00 40.82           C  
ATOM   1037  O   ASN A 137      21.574  40.331  21.777  1.00 40.57           O  
ATOM   1038  CB  ASN A 137      23.840  40.528  19.819  1.00 46.40           C  
ATOM   1039  CG  ASN A 137      23.012  40.395  18.535  1.00 50.72           C  
ATOM   1040  OD1 ASN A 137      22.635  39.285  18.129  1.00 46.39           O  
ATOM   1041  ND2 ASN A 137      22.750  41.528  17.882  1.00 46.53           N  
ATOM   1042  N   GLU A 138      21.375  38.300  20.818  1.00 41.40           N  
ATOM   1043  CA  GLU A 138      19.948  38.152  21.105  1.00 42.79           C  
ATOM   1044  C   GLU A 138      19.662  37.140  22.208  1.00 41.91           C  
ATOM   1045  O   GLU A 138      18.501  36.873  22.504  1.00 39.88           O  
ATOM   1046  CB  GLU A 138      19.189  37.734  19.842  1.00 42.38           C  
ATOM   1047  CG  GLU A 138      19.045  38.852  18.852  1.00 42.84           C  
ATOM   1048  CD  GLU A 138      17.973  38.571  17.839  1.00 46.87           C  
ATOM   1049  OE1 GLU A 138      17.569  37.369  17.683  1.00 39.03           O  
ATOM   1050  OE2 GLU A 138      17.539  39.564  17.204  1.00 40.50           O  
ATOM   1051  N   LEU A 139      20.700  36.585  22.834  1.00 42.41           N  
ATOM   1052  CA  LEU A 139      20.494  35.782  24.038  1.00 42.30           C  
ATOM   1053  C   LEU A 139      19.707  36.612  25.051  1.00 40.62           C  
ATOM   1054  O   LEU A 139      18.700  36.148  25.574  1.00 43.09           O  
ATOM   1055  CB  LEU A 139      21.826  35.278  24.617  1.00 43.98           C  
ATOM   1056  CG  LEU A 139      22.396  34.120  23.775  1.00 46.92           C  
ATOM   1057  CD1 LEU A 139      23.883  33.882  24.034  1.00 49.42           C  
ATOM   1058  CD2 LEU A 139      21.581  32.839  24.006  1.00 47.51           C  
ATOM   1059  N   SER A 140      20.145  37.848  25.265  1.00 35.33           N  
ATOM   1060  CA  SER A 140      19.375  38.854  25.987  1.00 37.16           C  
ATOM   1061  C   SER A 140      18.084  39.140  25.254  1.00 37.55           C  
ATOM   1062  O   SER A 140      18.115  39.497  24.060  1.00 40.57           O  
ATOM   1063  CB  SER A 140      20.176  40.167  26.083  1.00 36.35           C  
ATOM   1064  OG  SER A 140      19.410  41.238  26.614  1.00 35.49           O  
ATOM   1065  N   GLY A 141      16.962  38.971  25.944  1.00 34.96           N  
ATOM   1066  CA  GLY A 141      15.648  39.270  25.371  1.00 36.64           C  
ATOM   1067  C   GLY A 141      15.038  38.123  24.575  1.00 37.86           C  
ATOM   1068  O   GLY A 141      14.059  38.305  23.831  1.00 36.76           O  
ATOM   1069  N   ARG A 142      15.606  36.927  24.743  1.00 37.79           N  
ATOM   1070  CA  ARG A 142      15.180  35.773  23.963  1.00 31.87           C  
ATOM   1071  C   ARG A 142      13.830  35.208  24.404  1.00 33.28           C  
ATOM   1072  O   ARG A 142      13.163  34.619  23.592  1.00 30.15           O  
ATOM   1073  CB  ARG A 142      16.240  34.680  23.957  1.00 33.89           C  
ATOM   1074  CG  ARG A 142      16.401  33.948  25.269  1.00 39.30           C  
ATOM   1075  CD  ARG A 142      17.394  32.817  25.069  1.00 49.01           C  
ATOM   1076  NE  ARG A 142      17.688  32.059  26.287  1.00 50.80           N  
ATOM   1077  CZ  ARG A 142      18.566  32.414  27.234  1.00 59.08           C  
ATOM   1078  NH1 ARG A 142      19.259  33.548  27.173  1.00 59.55           N  
ATOM   1079  NH2 ARG A 142      18.750  31.615  28.275  1.00 58.67           N  
ATOM   1080  N   GLU A 143      13.378  35.447  25.643  1.00 33.99           N  
ATOM   1081  CA  GLU A 143      12.069  34.905  26.080  1.00 33.31           C  
ATOM   1082  C   GLU A 143      10.882  35.752  25.643  1.00 28.33           C  
ATOM   1083  O   GLU A 143      10.775  36.933  26.001  1.00 27.45           O  
ATOM   1084  CB  GLU A 143      11.999  34.711  27.596  1.00 35.16           C  
ATOM   1085  CG  GLU A 143      10.781  33.839  28.018  1.00 36.89           C  
ATOM   1086  CD  GLU A 143      10.732  33.576  29.538  1.00 39.49           C  
ATOM   1087  OE1 GLU A 143      10.247  34.421  30.311  1.00 41.96           O  
ATOM   1088  OE2 GLU A 143      11.193  32.504  29.958  1.00 44.79           O  
ATOM   1089  N   LEU A 144       9.953  35.146  24.898  1.00 28.76           N  
ATOM   1090  CA  LEU A 144       8.891  35.882  24.234  1.00 28.66           C  
ATOM   1091  C   LEU A 144       7.513  35.548  24.755  1.00 28.81           C  
ATOM   1092  O   LEU A 144       6.583  36.319  24.537  1.00 29.01           O  
ATOM   1093  CB  LEU A 144       8.911  35.615  22.730  1.00 32.28           C  
ATOM   1094  CG  LEU A 144      10.180  36.012  21.966  1.00 37.68           C  
ATOM   1095  CD1 LEU A 144      10.018  35.682  20.495  1.00 40.39           C  
ATOM   1096  CD2 LEU A 144      10.543  37.464  22.163  1.00 35.12           C  
HETATM 1097  N   MSE A 145       7.384  34.361  25.358  1.00 28.63           N  
HETATM 1098  CA  MSE A 145       6.187  33.904  26.032  1.00 27.52           C  
HETATM 1099  C   MSE A 145       6.572  33.196  27.303  1.00 29.45           C  
HETATM 1100  O   MSE A 145       7.544  32.399  27.364  1.00 28.81           O  
HETATM 1101  CB  MSE A 145       5.394  32.897  25.143  1.00 28.53           C  
HETATM 1102  CG  MSE A 145       4.203  32.334  25.859  1.00 28.24           C  
HETATM 1103 SE   MSE A 145       3.290  30.917  24.847  0.75 31.92          SE  
HETATM 1104  CE  MSE A 145       2.755  31.938  23.458  1.00 35.76           C  
ATOM   1105  N   ARG A 146       5.791  33.473  28.324  1.00 29.18           N  
ATOM   1106  CA  ARG A 146       5.912  32.820  29.586  1.00 33.00           C  
ATOM   1107  C   ARG A 146       4.525  32.604  30.102  1.00 33.29           C  
ATOM   1108  O   ARG A 146       3.666  33.499  29.963  1.00 32.82           O  
ATOM   1109  CB  ARG A 146       6.697  33.739  30.523  1.00 35.35           C  
ATOM   1110  CG  ARG A 146       7.123  33.122  31.794  1.00 39.22           C  
ATOM   1111  CD  ARG A 146       7.956  34.140  32.550  1.00 45.07           C  
ATOM   1112  NE  ARG A 146       8.537  33.509  33.697  1.00 49.77           N  
ATOM   1113  CZ  ARG A 146       9.386  34.093  34.529  1.00 52.91           C  
ATOM   1114  NH1 ARG A 146       9.754  35.346  34.343  1.00 34.76           N  
ATOM   1115  NH2 ARG A 146       9.867  33.397  35.545  1.00 54.83           N  
ATOM   1116  N   ASP A 147       4.318  31.452  30.743  1.00 33.70           N  
ATOM   1117  CA  ASP A 147       3.011  31.035  31.290  1.00 36.53           C  
ATOM   1118  C   ASP A 147       1.875  31.184  30.303  1.00 38.60           C  
ATOM   1119  O   ASP A 147       0.763  31.562  30.675  1.00 35.97           O  
ATOM   1120  CB  ASP A 147       2.657  31.789  32.581  1.00 42.99           C  
ATOM   1121  CG  ASP A 147       3.768  31.723  33.633  1.00 39.92           C  
ATOM   1122  OD1 ASP A 147       4.448  30.677  33.757  1.00 49.96           O  
ATOM   1123  OD2 ASP A 147       3.976  32.733  34.329  1.00 54.01           O  
ATOM   1124  N   GLY A 148       2.164  30.901  29.033  1.00 31.15           N  
ATOM   1125  CA  GLY A 148       1.138  30.827  28.038  1.00 35.38           C  
ATOM   1126  C   GLY A 148       0.742  32.144  27.439  1.00 33.14           C  
ATOM   1127  O   GLY A 148      -0.119  32.184  26.592  1.00 31.37           O  
ATOM   1128  N   GLU A 149       1.432  33.206  27.793  1.00 34.94           N  
ATOM   1129  CA  GLU A 149       1.086  34.579  27.315  1.00 34.29           C  
ATOM   1130  C   GLU A 149       2.275  35.192  26.623  1.00 32.20           C  
ATOM   1131  O   GLU A 149       3.372  35.195  27.186  1.00 27.95           O  
ATOM   1132  CB  GLU A 149       0.713  35.482  28.499  1.00 38.31           C  
ATOM   1133  CG  GLU A 149      -0.455  35.014  29.334  1.00 42.09           C  
ATOM   1134  CD  GLU A 149      -1.745  34.951  28.552  1.00 46.72           C  
ATOM   1135  OE1 GLU A 149      -1.854  35.612  27.484  1.00 44.43           O  
ATOM   1136  OE2 GLU A 149      -2.631  34.207  29.019  1.00 58.54           O  
ATOM   1137  N   TRP A 150       2.083  35.725  25.420  1.00 30.02           N  
ATOM   1138  CA  TRP A 150       3.128  36.487  24.762  1.00 31.89           C  
ATOM   1139  C   TRP A 150       3.486  37.711  25.640  1.00 29.94           C  
ATOM   1140  O   TRP A 150       2.594  38.317  26.259  1.00 28.88           O  
ATOM   1141  CB  TRP A 150       2.667  36.968  23.379  1.00 31.25           C  
ATOM   1142  CG  TRP A 150       2.465  35.847  22.398  1.00 31.75           C  
ATOM   1143  CD1 TRP A 150       1.255  35.327  21.974  1.00 30.34           C  
ATOM   1144  CD2 TRP A 150       3.479  35.100  21.714  1.00 28.75           C  
ATOM   1145  NE1 TRP A 150       1.463  34.341  21.090  1.00 37.53           N  
ATOM   1146  CE2 TRP A 150       2.809  34.165  20.889  1.00 31.51           C  
ATOM   1147  CE3 TRP A 150       4.875  35.140  21.689  1.00 31.74           C  
ATOM   1148  CZ2 TRP A 150       3.478  33.262  20.085  1.00 32.96           C  
ATOM   1149  CZ3 TRP A 150       5.554  34.224  20.885  1.00 31.33           C  
ATOM   1150  CH2 TRP A 150       4.844  33.288  20.088  1.00 33.14           C  
ATOM   1151  N   LEU A 151       4.773  38.046  25.711  1.00 30.48           N  
ATOM   1152  CA  LEU A 151       5.243  39.121  26.596  1.00 29.41           C  
ATOM   1153  C   LEU A 151       5.199  40.443  25.887  1.00 33.02           C  
ATOM   1154  O   LEU A 151       5.796  40.635  24.808  1.00 35.04           O  
ATOM   1155  CB  LEU A 151       6.637  38.784  27.120  1.00 33.31           C  
ATOM   1156  CG  LEU A 151       6.702  37.430  27.894  1.00 29.69           C  
ATOM   1157  CD1 LEU A 151       8.115  37.064  28.329  1.00 38.70           C  
ATOM   1158  CD2 LEU A 151       5.784  37.531  29.127  1.00 38.74           C  
ATOM   1159  N   VAL A 152       4.435  41.349  26.481  1.00 29.37           N  
ATOM   1160  CA  VAL A 152       4.237  42.697  25.961  1.00 28.11           C  
ATOM   1161  C   VAL A 152       4.789  43.616  27.027  1.00 29.14           C  
ATOM   1162  O   VAL A 152       4.510  43.451  28.232  1.00 29.60           O  
ATOM   1163  CB  VAL A 152       2.742  42.920  25.678  1.00 25.79           C  
ATOM   1164  CG1 VAL A 152       2.477  44.400  25.338  1.00 32.37           C  
ATOM   1165  CG2 VAL A 152       2.260  41.983  24.565  1.00 36.11           C  
ATOM   1166  N   THR A 153       5.642  44.551  26.613  1.00 27.80           N  
ATOM   1167  CA  THR A 153       6.222  45.501  27.507  1.00 28.19           C  
ATOM   1168  C   THR A 153       5.195  46.321  28.314  1.00 24.25           C  
ATOM   1169  O   THR A 153       4.235  46.809  27.756  1.00 23.97           O  
ATOM   1170  CB  THR A 153       7.144  46.428  26.725  1.00 29.26           C  
ATOM   1171  OG1 THR A 153       8.161  45.628  26.109  1.00 44.07           O  
ATOM   1172  CG2 THR A 153       7.757  47.380  27.619  1.00 28.83           C  
ATOM   1173  N   ASP A 154       5.449  46.479  29.618  1.00 21.47           N  
ATOM   1174  CA  ASP A 154       4.553  47.193  30.531  1.00 21.48           C  
ATOM   1175  C   ASP A 154       4.539  48.677  30.280  1.00 24.82           C  
ATOM   1176  O   ASP A 154       5.584  49.206  29.856  1.00 30.21           O  
ATOM   1177  CB  ASP A 154       4.925  46.962  31.983  1.00 21.00           C  
ATOM   1178  CG  ASP A 154       5.014  45.483  32.349  1.00 27.13           C  
ATOM   1179  OD1 ASP A 154       6.083  44.890  32.113  1.00 29.90           O  
ATOM   1180  OD2 ASP A 154       4.014  44.926  32.845  1.00 23.25           O  
ATOM   1181  OXT ASP A 154       3.537  49.382  30.576  1.00 23.69           O  
TER    1182      ASP A 154                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
