
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   77 (  586),  selected   77 , name 2ahm_A
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 2ahm_A.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    K     7_A      N       8          2.297
LGA    M     8_A      L       9          1.067
LGA    S     9_A      K      10          0.913
LGA    D    10_A      Q      11          0.740
LGA    V    11_A      A      12          0.931
LGA    K    12_A      K      13          0.505
LGA    C    13_A      E      14          0.574
LGA    T    14_A      E      15          0.731
LGA    S    15_A      A      16          0.969
LGA    V    16_A      I      17          0.663
LGA    V    17_A      K      18          0.646
LGA    L    18_A      E      19          0.836
LGA    L    19_A      L      20          0.819
LGA    S    20_A      V      21          1.032
LGA    V    21_A      D      22          1.452
LGA    L    22_A      A      23          2.147
LGA    Q    23_A      G      24          3.110
LGA    Q    24_A      -       -           -
LGA    L    25_A      -       -           -
LGA    R    26_A      -       -           -
LGA    V    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    S    29_A      -       -           -
LGA    S    30_A      -       -           -
LGA    S    31_A      -       -           -
LGA    K    32_A      -       -           -
LGA    L    33_A      -       -           -
LGA    W    34_A      T      25          4.389
LGA    A    35_A      A      26          3.700
LGA    Q    36_A      -       -           -
LGA    C    37_A      -       -           -
LGA    V    38_A      E      27          1.217
LGA    Q    39_A      K      28          1.934
LGA    L    40_A      Y      29          1.584
LGA    H    41_A      I      30          0.764
LGA    N    42_A      K      31          0.827
LGA    D    43_A      L      32          1.116
LGA    I    44_A      I      33          1.156
LGA    L    45_A      A      34          1.602
LGA    L    46_A      N      35          1.719
LGA    A    47_A      A      36          1.136
LGA    K    48_A      K      37          1.691
LGA    D    49_A      T      38          2.121
LGA    T    50_A      V      39          2.006
LGA    T    51_A      E      40          2.838
LGA    E    52_A      G      41          1.743
LGA    A    53_A      V      42          1.121
LGA    F    54_A      W      43          2.376
LGA    E    55_A      T      44          2.112
LGA    K    56_A      L      45          0.981
LGA    M    57_A      K      46          2.458
LGA    V    58_A      D      47          2.467
LGA    S    59_A      E      48          0.449
LGA    L    60_A      I      49          2.354
LGA    L    61_A      K      50          3.019
LGA    S    62_A      T      51          2.537
LGA    V    63_A      F      52          5.188
LGA    L    64_A      -       -           -
LGA    L    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    M    67_A      -       -           -
LGA    Q    68_A      -       -           -
LGA    G    69_A      -       -           -
LGA    A    70_A      -       -           -
LGA    V    71_A      -       -           -
LGA    D    72_A      -       -           -
LGA    I    73_A      -       -           -
LGA    N    74_A      -       -           -
LGA    R    75_A      -       -           -
LGA    L    76_A      -       -           -
LGA    C    77_A      -       -           -
LGA    E    78_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   77   45    5.0     45    1.98    13.33     89.942     2.161

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.414901 * X  +  -0.650813 * Y  +  -0.635846 * Z  +  99.719360
  Y_new =   0.909815 * X  +   0.289321 * Y  +   0.297539 * Z  + -122.223724
  Z_new =  -0.009678 * X  +  -0.701952 * Y  +   0.712159 * Z  + -48.335934 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.778180    2.363412  [ DEG:   -44.5864    135.4136 ]
  Theta =   0.009678    3.131914  [ DEG:     0.5545    179.4455 ]
  Phi   =   1.142941   -1.998652  [ DEG:    65.4857   -114.5143 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ahm_A                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ahm_A.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   77   45   5.0   45   1.98   13.33  89.942
REMARK  ---------------------------------------------------------- 
MOLECULE 2ahm_A
HEADER    VIRAL PROTEIN, REPLICATION              28-JUL-05   2AHM              
TITLE     CRYSTAL STRUCTURE OF SARS-COV SUPER COMPLEX OF NON-                   
TITLE    2 STRUCTURAL PROTEINS: THE HEXADECAMER                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: REPLICASE POLYPROTEIN 1AB, LIGHT CHAIN;                    
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: REPLICASE NSP7;                                             
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: REPLICASE POLYPROTEIN 1AB, HEAVY CHAIN;                    
COMPND   8 CHAIN: E, F, G, H;                                                   
COMPND   9 SYNONYM: REPLICASE NSP8;                                             
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HUMAN SARS CORONAVIRUS;                         
SOURCE   3 ORGANISM_COMMON: VIRUSES;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PGEX6P-1;                                 
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: HUMAN SARS CORONAVIRUS;                         
SOURCE  11 ORGANISM_COMMON: VIRUSES;                                            
SOURCE  12 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  13 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  15 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PGEX6P-1                                  
KEYWDS    SARS-COV, CORONAVIRUS, NON-STRUCTURAL PROTEIN, NSP7, NSP8,            
KEYWDS   2 SUPER-COMPLEX, HEXADECAMER                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.J.ZHAI,F.SUN,M.BARTLAM,Z.RAO                                        
REVDAT   1   15-NOV-05 2AHM    0                                                
JRNL        AUTH   Y.J.ZHAI,F.SUN,X.LI,H.PANG,X.XU,M.BARTLAM,Z.RAO              
JRNL        TITL   INSIGHTS INTO SARS-COV TRANSCRIPTION AND                     
JRNL        TITL 2 REPLICATION FROM THE STRUCTURE OF THE NSP7-NSP8              
JRNL        TITL 3 HEXADECAMER                                                  
JRNL        REF    NAT.STRUCT.MOL.BIOL.          V.  12   980 2005              
JRNL        REFN                US ISSN 1545-9993                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2AHM A    6    88  UNP    P59641   R1AB_CVHSA    3837   3919             
DBREF  2AHM B    6    88  UNP    P59641   R1AB_CVHSA    3837   3919             
DBREF  2AHM C    6    88  UNP    P59641   R1AB_CVHSA    3837   3919             
DBREF  2AHM D    6    88  UNP    P59641   R1AB_CVHSA    3837   3919             
DBREF  2AHM E    6   203  UNP    P59641   R1AB_CVHSA    3920   4117             
DBREF  2AHM F    6   203  UNP    P59641   R1AB_CVHSA    3920   4117             
DBREF  2AHM G    6   203  UNP    P59641   R1AB_CVHSA    3920   4117             
DBREF  2AHM H    6   203  UNP    P59641   R1AB_CVHSA    3920   4117             
SEQRES   1 A   88  GLY PRO LEU GLY SER SER LYS MET SER ASP VAL LYS CYS          
SEQRES   2 A   88  THR SER VAL VAL LEU LEU SER VAL LEU GLN GLN LEU ARG          
SEQRES   3 A   88  VAL GLU SER SER SER LYS LEU TRP ALA GLN CYS VAL GLN          
SEQRES   4 A   88  LEU HIS ASN ASP ILE LEU LEU ALA LYS ASP THR THR GLU          
SEQRES   5 A   88  ALA PHE GLU LYS MET VAL SER LEU LEU SER VAL LEU LEU          
SEQRES   6 A   88  SER MET GLN GLY ALA VAL ASP ILE ASN ARG LEU CYS GLU          
SEQRES   7 A   88  GLU MET LEU ASP ASN ARG ALA THR LEU GLN                      
SEQRES   1 B   88  GLY PRO LEU GLY SER SER LYS MET SER ASP VAL LYS CYS          
SEQRES   2 B   88  THR SER VAL VAL LEU LEU SER VAL LEU GLN GLN LEU ARG          
SEQRES   3 B   88  VAL GLU SER SER SER LYS LEU TRP ALA GLN CYS VAL GLN          
SEQRES   4 B   88  LEU HIS ASN ASP ILE LEU LEU ALA LYS ASP THR THR GLU          
SEQRES   5 B   88  ALA PHE GLU LYS MET VAL SER LEU LEU SER VAL LEU LEU          
SEQRES   6 B   88  SER MET GLN GLY ALA VAL ASP ILE ASN ARG LEU CYS GLU          
SEQRES   7 B   88  GLU MET LEU ASP ASN ARG ALA THR LEU GLN                      
SEQRES   1 C   88  GLY PRO LEU GLY SER SER LYS MET SER ASP VAL LYS CYS          
SEQRES   2 C   88  THR SER VAL VAL LEU LEU SER VAL LEU GLN GLN LEU ARG          
SEQRES   3 C   88  VAL GLU SER SER SER LYS LEU TRP ALA GLN CYS VAL GLN          
SEQRES   4 C   88  LEU HIS ASN ASP ILE LEU LEU ALA LYS ASP THR THR GLU          
SEQRES   5 C   88  ALA PHE GLU LYS MET VAL SER LEU LEU SER VAL LEU LEU          
SEQRES   6 C   88  SER MET GLN GLY ALA VAL ASP ILE ASN ARG LEU CYS GLU          
SEQRES   7 C   88  GLU MET LEU ASP ASN ARG ALA THR LEU GLN                      
SEQRES   1 D   88  GLY PRO LEU GLY SER SER LYS MET SER ASP VAL LYS CYS          
SEQRES   2 D   88  THR SER VAL VAL LEU LEU SER VAL LEU GLN GLN LEU ARG          
SEQRES   3 D   88  VAL GLU SER SER SER LYS LEU TRP ALA GLN CYS VAL GLN          
SEQRES   4 D   88  LEU HIS ASN ASP ILE LEU LEU ALA LYS ASP THR THR GLU          
SEQRES   5 D   88  ALA PHE GLU LYS MET VAL SER LEU LEU SER VAL LEU LEU          
SEQRES   6 D   88  SER MET GLN GLY ALA VAL ASP ILE ASN ARG LEU CYS GLU          
SEQRES   7 D   88  GLU MET LEU ASP ASN ARG ALA THR LEU GLN                      
SEQRES   1 E  203  GLY PRO LEU GLY SER ALA ILE ALA SER GLU PHE SER SER          
SEQRES   2 E  203  LEU PRO SER TYR ALA ALA TYR ALA THR ALA GLN GLU ALA          
SEQRES   3 E  203  TYR GLU GLN ALA VAL ALA ASN GLY ASP SER GLU VAL VAL          
SEQRES   4 E  203  LEU LYS LYS LEU LYS LYS SER LEU ASN VAL ALA LYS SER          
SEQRES   5 E  203  GLU PHE ASP ARG ASP ALA ALA MET GLN ARG LYS LEU GLU          
SEQRES   6 E  203  LYS MET ALA ASP GLN ALA MET THR GLN MET TYR LYS GLN          
SEQRES   7 E  203  ALA ARG SER GLU ASP LYS ARG ALA LYS VAL THR SER ALA          
SEQRES   8 E  203  MET GLN THR MET LEU PHE THR MET LEU ARG LYS LEU ASP          
SEQRES   9 E  203  ASN ASP ALA LEU ASN ASN ILE ILE ASN ASN ALA ARG ASP          
SEQRES  10 E  203  GLY CYS VAL PRO LEU ASN ILE ILE PRO LEU THR THR ALA          
SEQRES  11 E  203  ALA LYS LEU MET VAL VAL VAL PRO ASP TYR GLY THR TYR          
SEQRES  12 E  203  LYS ASN THR CYS ASP GLY ASN THR PHE THR TYR ALA SER          
SEQRES  13 E  203  ALA LEU TRP GLU ILE GLN GLN VAL VAL ASP ALA ASP SER          
SEQRES  14 E  203  LYS ILE VAL GLN LEU SER GLU ILE ASN MET ASP ASN SER          
SEQRES  15 E  203  PRO ASN LEU ALA TRP PRO LEU ILE VAL THR ALA LEU ARG          
SEQRES  16 E  203  ALA ASN SER ALA VAL LYS LEU GLN                              
SEQRES   1 F  203  GLY PRO LEU GLY SER ALA ILE ALA SER GLU PHE SER SER          
SEQRES   2 F  203  LEU PRO SER TYR ALA ALA TYR ALA THR ALA GLN GLU ALA          
SEQRES   3 F  203  TYR GLU GLN ALA VAL ALA ASN GLY ASP SER GLU VAL VAL          
SEQRES   4 F  203  LEU LYS LYS LEU LYS LYS SER LEU ASN VAL ALA LYS SER          
SEQRES   5 F  203  GLU PHE ASP ARG ASP ALA ALA MET GLN ARG LYS LEU GLU          
SEQRES   6 F  203  LYS MET ALA ASP GLN ALA MET THR GLN MET TYR LYS GLN          
SEQRES   7 F  203  ALA ARG SER GLU ASP LYS ARG ALA LYS VAL THR SER ALA          
SEQRES   8 F  203  MET GLN THR MET LEU PHE THR MET LEU ARG LYS LEU ASP          
SEQRES   9 F  203  ASN ASP ALA LEU ASN ASN ILE ILE ASN ASN ALA ARG ASP          
SEQRES  10 F  203  GLY CYS VAL PRO LEU ASN ILE ILE PRO LEU THR THR ALA          
SEQRES  11 F  203  ALA LYS LEU MET VAL VAL VAL PRO ASP TYR GLY THR TYR          
SEQRES  12 F  203  LYS ASN THR CYS ASP GLY ASN THR PHE THR TYR ALA SER          
SEQRES  13 F  203  ALA LEU TRP GLU ILE GLN GLN VAL VAL ASP ALA ASP SER          
SEQRES  14 F  203  LYS ILE VAL GLN LEU SER GLU ILE ASN MET ASP ASN SER          
SEQRES  15 F  203  PRO ASN LEU ALA TRP PRO LEU ILE VAL THR ALA LEU ARG          
SEQRES  16 F  203  ALA ASN SER ALA VAL LYS LEU GLN                              
SEQRES   1 G  203  GLY PRO LEU GLY SER ALA ILE ALA SER GLU PHE SER SER          
SEQRES   2 G  203  LEU PRO SER TYR ALA ALA TYR ALA THR ALA GLN GLU ALA          
SEQRES   3 G  203  TYR GLU GLN ALA VAL ALA ASN GLY ASP SER GLU VAL VAL          
SEQRES   4 G  203  LEU LYS LYS LEU LYS LYS SER LEU ASN VAL ALA LYS SER          
SEQRES   5 G  203  GLU PHE ASP ARG ASP ALA ALA MET GLN ARG LYS LEU GLU          
SEQRES   6 G  203  LYS MET ALA ASP GLN ALA MET THR GLN MET TYR LYS GLN          
SEQRES   7 G  203  ALA ARG SER GLU ASP LYS ARG ALA LYS VAL THR SER ALA          
SEQRES   8 G  203  MET GLN THR MET LEU PHE THR MET LEU ARG LYS LEU ASP          
SEQRES   9 G  203  ASN ASP ALA LEU ASN ASN ILE ILE ASN ASN ALA ARG ASP          
SEQRES  10 G  203  GLY CYS VAL PRO LEU ASN ILE ILE PRO LEU THR THR ALA          
SEQRES  11 G  203  ALA LYS LEU MET VAL VAL VAL PRO ASP TYR GLY THR TYR          
SEQRES  12 G  203  LYS ASN THR CYS ASP GLY ASN THR PHE THR TYR ALA SER          
SEQRES  13 G  203  ALA LEU TRP GLU ILE GLN GLN VAL VAL ASP ALA ASP SER          
SEQRES  14 G  203  LYS ILE VAL GLN LEU SER GLU ILE ASN MET ASP ASN SER          
SEQRES  15 G  203  PRO ASN LEU ALA TRP PRO LEU ILE VAL THR ALA LEU ARG          
SEQRES  16 G  203  ALA ASN SER ALA VAL LYS LEU GLN                              
SEQRES   1 H  203  GLY PRO LEU GLY SER ALA ILE ALA SER GLU PHE SER SER          
SEQRES   2 H  203  LEU PRO SER TYR ALA ALA TYR ALA THR ALA GLN GLU ALA          
SEQRES   3 H  203  TYR GLU GLN ALA VAL ALA ASN GLY ASP SER GLU VAL VAL          
SEQRES   4 H  203  LEU LYS LYS LEU LYS LYS SER LEU ASN VAL ALA LYS SER          
SEQRES   5 H  203  GLU PHE ASP ARG ASP ALA ALA MET GLN ARG LYS LEU GLU          
SEQRES   6 H  203  LYS MET ALA ASP GLN ALA MET THR GLN MET TYR LYS GLN          
SEQRES   7 H  203  ALA ARG SER GLU ASP LYS ARG ALA LYS VAL THR SER ALA          
SEQRES   8 H  203  MET GLN THR MET LEU PHE THR MET LEU ARG LYS LEU ASP          
SEQRES   9 H  203  ASN ASP ALA LEU ASN ASN ILE ILE ASN ASN ALA ARG ASP          
SEQRES  10 H  203  GLY CYS VAL PRO LEU ASN ILE ILE PRO LEU THR THR ALA          
SEQRES  11 H  203  ALA LYS LEU MET VAL VAL VAL PRO ASP TYR GLY THR TYR          
SEQRES  12 H  203  LYS ASN THR CYS ASP GLY ASN THR PHE THR TYR ALA SER          
SEQRES  13 H  203  ALA LEU TRP GLU ILE GLN GLN VAL VAL ASP ALA ASP SER          
SEQRES  14 H  203  LYS ILE VAL GLN LEU SER GLU ILE ASN MET ASP ASN SER          
SEQRES  15 H  203  PRO ASN LEU ALA TRP PRO LEU ILE VAL THR ALA LEU ARG          
SEQRES  16 H  203  ALA ASN SER ALA VAL LYS LEU GLN                              
HET    SO4   1001       5                                                       
HET    GOL   2001       6                                                       
HET    GOL   2002       6                                                       
HET    GOL   2003       6                                                       
HET    GOL   2004       6                                                       
HET    GOL   2005       6                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   9  SO4    O4 S 2-                                                      
FORMUL  10  GOL    5(C3 H8 O3)                                                  
FORMUL  15  HOH   *149(H2 O)                                                    
CRYST1   93.600   94.000  150.800  90.00  90.00  90.00 P 21 21 2    16          
ATOM      1  N   PRO A   2      12.234   9.882   4.105  1.00 94.36           N  
ATOM      2  CA  PRO A   2      12.640   9.551   2.718  1.00 91.45           C  
ATOM      3  C   PRO A   2      11.682   8.562   2.053  1.00 88.48           C  
ATOM      4  O   PRO A   2      11.904   8.140   0.918  1.00 86.46           O  
ATOM      5  CB  PRO A   2      14.049   8.977   2.798  1.00 85.11           C  
ATOM      6  CG  PRO A   2      14.583   9.692   4.043  1.00 91.14           C  
ATOM      7  CD  PRO A   2      13.381   9.719   5.016  1.00 89.46           C  
ATOM      8  N   LEU A   3      10.621   8.201   2.773  1.00 96.30           N  
ATOM      9  CA  LEU A   3       9.609   7.272   2.269  1.00 91.02           C  
ATOM     10  C   LEU A   3       8.504   8.078   1.583  1.00 89.29           C  
ATOM     11  O   LEU A   3       7.788   7.571   0.712  1.00 87.37           O  
ATOM     12  CB  LEU A   3       9.001   6.467   3.423  1.00 75.87           C  
ATOM     13  CG  LEU A   3       9.917   5.622   4.316  1.00 74.34           C  
ATOM     14  CD1 LEU A   3       9.118   5.094   5.503  1.00 70.67           C  
ATOM     15  CD2 LEU A   3      10.516   4.478   3.508  1.00 65.34           C  
ATOM     16  N   GLY A   4       8.380   9.338   1.997  1.00 67.65           N  
ATOM     17  CA  GLY A   4       7.373  10.226   1.446  1.00 59.36           C  
ATOM     18  C   GLY A   4       6.670  10.998   2.549  1.00 54.21           C  
ATOM     19  O   GLY A   4       7.189  11.123   3.656  1.00 56.26           O  
ATOM     20  N   SER A   5       5.483  11.509   2.243  1.00 45.65           N  
ATOM     21  CA  SER A   5       4.680  12.274   3.192  1.00 37.85           C  
ATOM     22  C   SER A   5       4.364  11.481   4.456  1.00 39.36           C  
ATOM     23  O   SER A   5       4.694  10.301   4.565  1.00 39.11           O  
ATOM     24  CB  SER A   5       3.366  12.660   2.537  1.00 37.59           C  
ATOM     25  OG  SER A   5       2.604  11.491   2.258  1.00 34.57           O  
ATOM     26  N   SER A   6       3.698  12.138   5.401  1.00 44.23           N  
ATOM     27  CA  SER A   6       3.313  11.508   6.662  1.00 43.68           C  
ATOM     28  C   SER A   6       2.287  10.394   6.405  1.00 44.28           C  
ATOM     29  O   SER A   6       2.359   9.313   7.001  1.00 41.90           O  
ATOM     30  CB  SER A   6       2.722  12.560   7.604  1.00 49.41           C  
ATOM     31  OG  SER A   6       2.238  11.972   8.792  1.00 58.17           O  
ATOM     32  N   LYS A   7       1.341  10.668   5.512  1.00 35.67           N  
ATOM     33  CA  LYS A   7       0.310   9.705   5.153  1.00 31.17           C  
ATOM     34  C   LYS A   7       0.953   8.507   4.439  1.00 35.35           C  
ATOM     35  O   LYS A   7       0.609   7.350   4.703  1.00 35.21           O  
ATOM     36  CB  LYS A   7      -0.727  10.374   4.243  1.00 36.01           C  
ATOM     37  CG  LYS A   7      -1.856   9.467   3.813  1.00 49.15           C  
ATOM     38  CD  LYS A   7      -2.540   8.829   5.023  1.00 65.17           C  
ATOM     39  CE  LYS A   7      -3.172   9.874   5.934  1.00 74.78           C  
ATOM     40  NZ  LYS A   7      -3.757   9.261   7.159  1.00 79.06           N  
ATOM     41  N   MET A   8       1.897   8.780   3.545  1.00 29.39           N  
ATOM     42  CA  MET A   8       2.564   7.699   2.835  1.00 30.19           C  
ATOM     43  C   MET A   8       3.379   6.828   3.799  1.00 35.26           C  
ATOM     44  O   MET A   8       3.386   5.607   3.673  1.00 33.75           O  
ATOM     45  CB  MET A   8       3.478   8.249   1.742  1.00 27.68           C  
ATOM     46  CG  MET A   8       4.091   7.150   0.877  1.00 31.54           C  
ATOM     47  SD  MET A   8       2.826   6.188  -0.002  1.00 37.11           S  
ATOM     48  CE  MET A   8       3.074   6.778  -1.692  1.00 31.71           C  
ATOM     49  N   SER A   9       4.068   7.450   4.757  1.00 29.24           N  
ATOM     50  CA  SER A   9       4.853   6.684   5.720  1.00 31.43           C  
ATOM     51  C   SER A   9       3.935   5.752   6.491  1.00 31.81           C  
ATOM     52  O   SER A   9       4.259   4.584   6.686  1.00 24.76           O  
ATOM     53  CB  SER A   9       5.570   7.600   6.721  1.00 27.28           C  
ATOM     54  OG  SER A   9       6.617   8.307   6.090  1.00 52.35           O  
ATOM     55  N   ASP A  10       2.789   6.281   6.922  1.00 31.99           N  
ATOM     56  CA  ASP A  10       1.823   5.497   7.680  1.00 31.34           C  
ATOM     57  C   ASP A  10       1.321   4.303   6.885  1.00 30.86           C  
ATOM     58  O   ASP A  10       1.226   3.195   7.426  1.00 28.79           O  
ATOM     59  CB  ASP A  10       0.623   6.357   8.093  1.00 31.49           C  
ATOM     60  CG  ASP A  10       0.965   7.369   9.172  1.00 43.13           C  
ATOM     61  OD1 ASP A  10       2.055   7.261   9.777  1.00 42.81           O  
ATOM     62  OD2 ASP A  10       0.132   8.272   9.424  1.00 52.27           O  
ATOM     63  N   VAL A  11       1.009   4.521   5.605  1.00 28.78           N  
ATOM     64  CA  VAL A  11       0.502   3.437   4.769  1.00 34.10           C  
ATOM     65  C   VAL A  11       1.540   2.332   4.605  1.00 33.71           C  
ATOM     66  O   VAL A  11       1.243   1.144   4.775  1.00 26.71           O  
ATOM     67  CB  VAL A  11       0.095   3.939   3.367  1.00 43.79           C  
ATOM     68  CG1 VAL A  11      -0.427   2.774   2.528  1.00 39.62           C  
ATOM     69  CG2 VAL A  11      -0.964   5.010   3.495  1.00 59.83           C  
ATOM     70  N   LYS A  12       2.760   2.731   4.278  1.00 27.90           N  
ATOM     71  CA  LYS A  12       3.829   1.769   4.086  1.00 33.93           C  
ATOM     72  C   LYS A  12       4.103   0.966   5.345  1.00 33.91           C  
ATOM     73  O   LYS A  12       4.305  -0.246   5.291  1.00 35.84           O  
ATOM     74  CB  LYS A  12       5.088   2.491   3.613  1.00 30.81           C  
ATOM     75  CG  LYS A  12       4.885   3.085   2.231  1.00 33.22           C  
ATOM     76  CD  LYS A  12       6.136   3.686   1.647  1.00 34.96           C  
ATOM     77  CE  LYS A  12       5.888   3.986   0.175  1.00 30.29           C  
ATOM     78  NZ  LYS A  12       7.032   4.651  -0.455  1.00 39.81           N  
ATOM     79  N   CYS A  13       4.093   1.641   6.483  1.00 29.55           N  
ATOM     80  CA  CYS A  13       4.347   0.980   7.749  1.00 30.36           C  
ATOM     81  C   CYS A  13       3.193   0.036   8.083  1.00 32.38           C  
ATOM     82  O   CYS A  13       3.401  -1.066   8.587  1.00 31.91           O  
ATOM     83  CB  CYS A  13       4.503   2.029   8.848  1.00 34.73           C  
ATOM     84  SG  CYS A  13       4.931   1.336  10.439  1.00 37.56           S  
ATOM     85  N   THR A  14       1.972   0.472   7.790  1.00 31.06           N  
ATOM     86  CA  THR A  14       0.801  -0.345   8.058  1.00 24.13           C  
ATOM     87  C   THR A  14       0.846  -1.634   7.231  1.00 32.60           C  
ATOM     88  O   THR A  14       0.476  -2.707   7.724  1.00 32.87           O  
ATOM     89  CB  THR A  14      -0.498   0.433   7.735  1.00 30.85           C  
ATOM     90  OG1 THR A  14      -0.554   1.616   8.541  1.00 28.81           O  
ATOM     91  CG2 THR A  14      -1.731  -0.415   8.017  1.00 19.87           C  
ATOM     92  N   SER A  15       1.314  -1.538   5.987  1.00 24.53           N  
ATOM     93  CA  SER A  15       1.384  -2.702   5.114  1.00 21.99           C  
ATOM     94  C   SER A  15       2.391  -3.718   5.658  1.00 26.72           C  
ATOM     95  O   SER A  15       2.233  -4.918   5.462  1.00 27.88           O  
ATOM     96  CB  SER A  15       1.790  -2.284   3.696  1.00 24.21           C  
ATOM     97  OG  SER A  15       3.205  -2.267   3.561  1.00 47.17           O  
ATOM     98  N   VAL A  16       3.427  -3.228   6.335  1.00 28.38           N  
ATOM     99  CA  VAL A  16       4.444  -4.094   6.908  1.00 32.08           C  
ATOM    100  C   VAL A  16       3.827  -4.887   8.061  1.00 33.04           C  
ATOM    101  O   VAL A  16       4.016  -6.103   8.164  1.00 37.28           O  
ATOM    102  CB  VAL A  16       5.660  -3.269   7.426  1.00 28.44           C  
ATOM    103  CG1 VAL A  16       6.657  -4.171   8.128  1.00 19.67           C  
ATOM    104  CG2 VAL A  16       6.345  -2.566   6.253  1.00 24.50           C  
ATOM    105  N   VAL A  17       3.079  -4.198   8.916  1.00 21.88           N  
ATOM    106  CA  VAL A  17       2.423  -4.846  10.045  1.00 19.61           C  
ATOM    107  C   VAL A  17       1.392  -5.830   9.498  1.00 23.16           C  
ATOM    108  O   VAL A  17       1.253  -6.948  10.005  1.00 21.13           O  
ATOM    109  CB  VAL A  17       1.726  -3.796  10.970  1.00 30.72           C  
ATOM    110  CG1 VAL A  17       0.909  -4.485  12.046  1.00 30.35           C  
ATOM    111  CG2 VAL A  17       2.771  -2.919  11.645  1.00 31.93           C  
ATOM    112  N   LEU A  18       0.697  -5.411   8.442  1.00 29.90           N  
ATOM    113  CA  LEU A  18      -0.325  -6.229   7.802  1.00 30.46           C  
ATOM    114  C   LEU A  18       0.250  -7.556   7.320  1.00 34.74           C  
ATOM    115  O   LEU A  18      -0.297  -8.622   7.610  1.00 37.77           O  
ATOM    116  CB  LEU A  18      -0.950  -5.476   6.617  1.00 25.93           C  
ATOM    117  CG  LEU A  18      -1.983  -6.209   5.741  1.00 33.88           C  
ATOM    118  CD1 LEU A  18      -3.064  -6.886   6.614  1.00 26.53           C  
ATOM    119  CD2 LEU A  18      -2.623  -5.210   4.777  1.00 26.01           C  
ATOM    120  N   LEU A  19       1.356  -7.489   6.587  1.00 31.62           N  
ATOM    121  CA  LEU A  19       1.995  -8.689   6.073  1.00 30.56           C  
ATOM    122  C   LEU A  19       2.414  -9.603   7.237  1.00 32.50           C  
ATOM    123  O   LEU A  19       2.319 -10.825   7.137  1.00 34.31           O  
ATOM    124  CB  LEU A  19       3.214  -8.302   5.230  1.00 18.24           C  
ATOM    125  CG  LEU A  19       3.610  -9.137   3.999  1.00 34.69           C  
ATOM    126  CD1 LEU A  19       5.050  -9.573   4.121  1.00 24.78           C  
ATOM    127  CD2 LEU A  19       2.719 -10.336   3.836  1.00 28.80           C  
ATOM    128  N   SER A  20       2.866  -9.005   8.337  1.00 26.39           N  
ATOM    129  CA  SER A  20       3.288  -9.761   9.518  1.00 29.62           C  
ATOM    130  C   SER A  20       2.107 -10.488  10.155  1.00 31.18           C  
ATOM    131  O   SER A  20       2.258 -11.599  10.666  1.00 31.64           O  
ATOM    132  CB  SER A  20       3.917  -8.830  10.561  1.00 34.31           C  
ATOM    133  OG  SER A  20       5.085  -8.208  10.068  1.00 37.61           O  
ATOM    134  N   VAL A  21       0.937  -9.854  10.141  1.00 34.39           N  
ATOM    135  CA  VAL A  21      -0.260 -10.474  10.703  1.00 34.86           C  
ATOM    136  C   VAL A  21      -0.645 -11.676   9.842  1.00 36.48           C  
ATOM    137  O   VAL A  21      -0.966 -12.744  10.367  1.00 35.52           O  
ATOM    138  CB  VAL A  21      -1.439  -9.474  10.771  1.00 34.45           C  
ATOM    139  CG1 VAL A  21      -2.729 -10.197  11.152  1.00 25.36           C  
ATOM    140  CG2 VAL A  21      -1.134  -8.387  11.799  1.00 23.18           C  
ATOM    141  N   LEU A  22      -0.599 -11.501   8.523  1.00 30.39           N  
ATOM    142  CA  LEU A  22      -0.925 -12.581   7.602  1.00 27.49           C  
ATOM    143  C   LEU A  22       0.013 -13.764   7.876  1.00 34.35           C  
ATOM    144  O   LEU A  22      -0.406 -14.916   7.952  1.00 29.77           O  
ATOM    145  CB  LEU A  22      -0.754 -12.112   6.153  1.00 32.22           C  
ATOM    146  CG  LEU A  22      -1.966 -11.702   5.294  1.00 42.08           C  
ATOM    147  CD1 LEU A  22      -3.281 -11.821   6.057  1.00 23.26           C  
ATOM    148  CD2 LEU A  22      -1.758 -10.297   4.794  1.00 23.97           C  
ATOM    149  N   GLN A  23       1.294 -13.476   8.031  1.00 30.69           N  
ATOM    150  CA  GLN A  23       2.248 -14.530   8.302  1.00 33.25           C  
ATOM    151  C   GLN A  23       1.926 -15.175   9.650  1.00 34.34           C  
ATOM    152  O   GLN A  23       1.971 -16.392   9.792  1.00 30.47           O  
ATOM    153  CB  GLN A  23       3.663 -13.949   8.286  1.00 38.46           C  
ATOM    154  CG  GLN A  23       4.724 -14.841   8.887  1.00 53.15           C  
ATOM    155  CD  GLN A  23       6.107 -14.265   8.696  1.00 65.11           C  
ATOM    156  OE1 GLN A  23       6.632 -14.262   7.587  1.00 64.00           O  
ATOM    157  NE2 GLN A  23       6.700 -13.756   9.777  1.00 65.16           N  
ATOM    158  N   GLN A  24       1.581 -14.340  10.625  1.00 36.53           N  
ATOM    159  CA  GLN A  24       1.235 -14.787  11.966  1.00 32.30           C  
ATOM    160  C   GLN A  24       0.017 -15.713  11.917  1.00 39.44           C  
ATOM    161  O   GLN A  24      -0.218 -16.481  12.847  1.00 41.02           O  
ATOM    162  CB  GLN A  24       0.937 -13.559  12.831  1.00 42.45           C  
ATOM    163  CG  GLN A  24       0.578 -13.835  14.280  1.00 43.28           C  
ATOM    164  CD  GLN A  24       1.701 -14.484  15.060  1.00 52.65           C  
ATOM    165  OE1 GLN A  24       2.854 -14.503  14.618  1.00 47.83           O  
ATOM    166  NE2 GLN A  24       1.375 -15.009  16.237  1.00 43.60           N  
ATOM    167  N   LEU A  25      -0.753 -15.631  10.830  1.00 41.71           N  
ATOM    168  CA  LEU A  25      -1.947 -16.455  10.634  1.00 39.03           C  
ATOM    169  C   LEU A  25      -1.637 -17.656   9.758  1.00 43.06           C  
ATOM    170  O   LEU A  25      -2.538 -18.302   9.208  1.00 40.90           O  
ATOM    171  CB  LEU A  25      -3.057 -15.633   9.981  1.00 35.57           C  
ATOM    172  CG  LEU A  25      -4.078 -15.052  10.950  1.00 45.44           C  
ATOM    173  CD1 LEU A  25      -3.375 -14.432  12.142  1.00 60.56           C  
ATOM    174  CD2 LEU A  25      -4.925 -14.037  10.223  1.00 43.59           C  
ATOM    175  N   ARG A  26      -0.346 -17.932   9.623  1.00 39.55           N  
ATOM    176  CA  ARG A  26       0.143 -19.055   8.848  1.00 42.04           C  
ATOM    177  C   ARG A  26      -0.439 -19.114   7.450  1.00 46.56           C  
ATOM    178  O   ARG A  26      -0.923 -20.160   7.023  1.00 50.63           O  
ATOM    179  CB  ARG A  26      -0.145 -20.357   9.597  1.00 60.69           C  
ATOM    180  CG  ARG A  26       0.480 -20.400  10.987  1.00 69.28           C  
ATOM    181  CD  ARG A  26      -0.016 -21.583  11.798  1.00 90.55           C  
ATOM    182  NE  ARG A  26       0.470 -21.537  13.176  1.00 98.59           N  
ATOM    183  CZ  ARG A  26       0.035 -22.330  14.151  1.00 99.20           C  
ATOM    184  NH1 ARG A  26      -0.900 -23.240  13.908  1.00104.04           N  
ATOM    185  NH2 ARG A  26       0.529 -22.208  15.374  1.00 94.81           N  
ATOM    186  N   VAL A  27      -0.385 -17.995   6.736  1.00 48.33           N  
ATOM    187  CA  VAL A  27      -0.898 -17.953   5.374  1.00 54.54           C  
ATOM    188  C   VAL A  27       0.194 -18.392   4.420  1.00 58.47           C  
ATOM    189  O   VAL A  27      -0.076 -18.651   3.247  1.00 55.93           O  
ATOM    190  CB  VAL A  27      -1.341 -16.529   4.944  1.00 64.28           C  
ATOM    191  CG1 VAL A  27      -2.262 -15.930   5.978  1.00 70.49           C  
ATOM    192  CG2 VAL A  27      -0.133 -15.646   4.742  1.00 75.99           C  
ATOM    193  N   GLU A  28       1.427 -18.463   4.920  1.00 58.62           N  
ATOM    194  CA  GLU A  28       2.562 -18.855   4.090  1.00 65.98           C  
ATOM    195  C   GLU A  28       2.331 -20.205   3.441  1.00 67.37           C  
ATOM    196  O   GLU A  28       2.868 -20.493   2.366  1.00 63.99           O  
ATOM    197  CB  GLU A  28       3.845 -18.911   4.914  1.00 78.30           C  
ATOM    198  CG  GLU A  28       4.335 -17.569   5.408  1.00 81.42           C  
ATOM    199  CD  GLU A  28       5.680 -17.679   6.098  1.00 90.94           C  
ATOM    200  OE1 GLU A  28       6.665 -18.055   5.421  1.00 81.19           O  
ATOM    201  OE2 GLU A  28       5.748 -17.397   7.315  1.00 94.85           O  
ATOM    202  N   SER A  29       1.530 -21.031   4.105  1.00 93.59           N  
ATOM    203  CA  SER A  29       1.220 -22.358   3.601  1.00102.08           C  
ATOM    204  C   SER A  29       0.884 -22.256   2.115  1.00103.35           C  
ATOM    205  O   SER A  29       1.591 -22.821   1.275  1.00109.96           O  
ATOM    206  CB  SER A  29       0.043 -22.953   4.381  1.00106.21           C  
ATOM    207  OG  SER A  29      -0.187 -24.301   4.010  1.00114.81           O  
ATOM    208  N   SER A  30      -0.181 -21.523   1.791  1.00 90.92           N  
ATOM    209  CA  SER A  30      -0.593 -21.339   0.402  1.00 86.16           C  
ATOM    210  C   SER A  30       0.473 -20.510  -0.308  1.00 79.45           C  
ATOM    211  O   SER A  30       0.457 -19.282  -0.241  1.00 80.20           O  
ATOM    212  CB  SER A  30      -1.948 -20.621   0.338  1.00 95.97           C  
ATOM    213  OG  SER A  30      -2.432 -20.536  -0.996  1.00106.04           O  
ATOM    214  N   SER A  31       1.397 -21.183  -0.986  1.00 67.13           N  
ATOM    215  CA  SER A  31       2.479 -20.503  -1.682  1.00 60.29           C  
ATOM    216  C   SER A  31       2.006 -19.591  -2.808  1.00 51.13           C  
ATOM    217  O   SER A  31       2.620 -18.563  -3.081  1.00 57.01           O  
ATOM    218  CB  SER A  31       3.490 -21.526  -2.205  1.00 66.12           C  
ATOM    219  OG  SER A  31       4.186 -22.128  -1.122  1.00 68.13           O  
ATOM    220  N   LYS A  32       0.914 -19.958  -3.462  1.00 40.24           N  
ATOM    221  CA  LYS A  32       0.377 -19.134  -4.538  1.00 42.00           C  
ATOM    222  C   LYS A  32      -0.089 -17.802  -3.920  1.00 42.94           C  
ATOM    223  O   LYS A  32       0.378 -16.724  -4.301  1.00 40.96           O  
ATOM    224  CB  LYS A  32      -0.815 -19.837  -5.210  1.00 80.42           C  
ATOM    225  CG  LYS A  32      -0.731 -21.375  -5.250  1.00 91.70           C  
ATOM    226  CD  LYS A  32      -0.950 -21.995  -3.867  1.00 90.04           C  
ATOM    227  CE  LYS A  32      -0.662 -23.490  -3.861  1.00 87.33           C  
ATOM    228  NZ  LYS A  32      -0.682 -24.034  -2.473  1.00 79.72           N  
ATOM    229  N   LEU A  33      -1.003 -17.893  -2.955  1.00 39.76           N  
ATOM    230  CA  LEU A  33      -1.545 -16.724  -2.268  1.00 39.19           C  
ATOM    231  C   LEU A  33      -0.468 -15.893  -1.558  1.00 40.81           C  
ATOM    232  O   LEU A  33      -0.496 -14.659  -1.608  1.00 40.57           O  
ATOM    233  CB  LEU A  33      -2.607 -17.157  -1.240  1.00 34.61           C  
ATOM    234  CG  LEU A  33      -3.236 -16.081  -0.346  1.00 33.11           C  
ATOM    235  CD1 LEU A  33      -4.098 -15.138  -1.182  1.00 26.57           C  
ATOM    236  CD2 LEU A  33      -4.075 -16.737   0.728  1.00 32.49           C  
ATOM    237  N   TRP A  34       0.469 -16.560  -0.886  1.00 34.38           N  
ATOM    238  CA  TRP A  34       1.529 -15.847  -0.178  1.00 33.70           C  
ATOM    239  C   TRP A  34       2.363 -14.980  -1.130  1.00 35.37           C  
ATOM    240  O   TRP A  34       2.758 -13.867  -0.785  1.00 35.46           O  
ATOM    241  CB  TRP A  34       2.437 -16.830   0.566  1.00 29.21           C  
ATOM    242  CG  TRP A  34       3.565 -16.154   1.302  1.00 41.27           C  
ATOM    243  CD1 TRP A  34       4.906 -16.280   1.052  1.00 34.71           C  
ATOM    244  CD2 TRP A  34       3.448 -15.219   2.378  1.00 34.98           C  
ATOM    245  NE1 TRP A  34       5.626 -15.482   1.905  1.00 42.38           N  
ATOM    246  CE2 TRP A  34       4.754 -14.818   2.731  1.00 42.97           C  
ATOM    247  CE3 TRP A  34       2.364 -14.680   3.082  1.00 45.10           C  
ATOM    248  CZ2 TRP A  34       5.006 -13.902   3.752  1.00 45.22           C  
ATOM    249  CZ3 TRP A  34       2.615 -13.770   4.099  1.00 48.80           C  
ATOM    250  CH2 TRP A  34       3.926 -13.391   4.425  1.00 44.06           C  
ATOM    251  N   ALA A  35       2.617 -15.493  -2.326  1.00 36.48           N  
ATOM    252  CA  ALA A  35       3.390 -14.770  -3.327  1.00 36.81           C  
ATOM    253  C   ALA A  35       2.654 -13.496  -3.721  1.00 37.65           C  
ATOM    254  O   ALA A  35       3.269 -12.441  -3.863  1.00 46.00           O  
ATOM    255  CB  ALA A  35       3.628 -15.656  -4.561  1.00 28.01           C  
ATOM    256  N   GLN A  36       1.338 -13.590  -3.893  1.00 33.69           N  
ATOM    257  CA  GLN A  36       0.547 -12.417  -4.255  1.00 34.32           C  
ATOM    258  C   GLN A  36       0.555 -11.373  -3.136  1.00 34.57           C  
ATOM    259  O   GLN A  36       0.561 -10.174  -3.407  1.00 37.47           O  
ATOM    260  CB  GLN A  36      -0.881 -12.833  -4.596  1.00 37.52           C  
ATOM    261  CG  GLN A  36      -0.928 -13.827  -5.742  1.00 41.26           C  
ATOM    262  CD  GLN A  36      -2.293 -14.445  -5.940  1.00 44.99           C  
ATOM    263  OE1 GLN A  36      -3.129 -13.915  -6.666  1.00 50.30           O  
ATOM    264  NE2 GLN A  36      -2.529 -15.574  -5.282  1.00 48.96           N  
ATOM    265  N   CYS A  37       0.583 -11.828  -1.887  1.00 38.16           N  
ATOM    266  CA  CYS A  37       0.621 -10.917  -0.745  1.00 40.13           C  
ATOM    267  C   CYS A  37       1.945 -10.149  -0.726  1.00 33.33           C  
ATOM    268  O   CYS A  37       1.958  -8.922  -0.573  1.00 31.02           O  
ATOM    269  CB  CYS A  37       0.462 -11.686   0.575  1.00 33.64           C  
ATOM    270  SG  CYS A  37      -1.180 -12.404   0.861  1.00 38.30           S  
ATOM    271  N   VAL A  38       3.048 -10.882  -0.875  1.00 28.12           N  
ATOM    272  CA  VAL A  38       4.381 -10.288  -0.884  1.00 27.57           C  
ATOM    273  C   VAL A  38       4.462  -9.238  -1.989  1.00 28.26           C  
ATOM    274  O   VAL A  38       4.965  -8.139  -1.785  1.00 30.51           O  
ATOM    275  CB  VAL A  38       5.476 -11.368  -1.118  1.00 31.30           C  
ATOM    276  CG1 VAL A  38       6.821 -10.711  -1.371  1.00 29.43           C  
ATOM    277  CG2 VAL A  38       5.586 -12.262   0.101  1.00 32.18           C  
ATOM    278  N   GLN A  39       3.942  -9.581  -3.159  1.00 23.84           N  
ATOM    279  CA  GLN A  39       3.961  -8.666  -4.279  1.00 31.31           C  
ATOM    280  C   GLN A  39       3.156  -7.391  -3.965  1.00 34.16           C  
ATOM    281  O   GLN A  39       3.604  -6.276  -4.258  1.00 33.47           O  
ATOM    282  CB  GLN A  39       3.418  -9.362  -5.533  1.00 28.23           C  
ATOM    283  CG  GLN A  39       3.625  -8.558  -6.793  1.00 47.64           C  
ATOM    284  CD  GLN A  39       5.098  -8.279  -7.064  1.00 67.42           C  
ATOM    285  OE1 GLN A  39       5.856  -9.177  -7.450  1.00 66.20           O  
ATOM    286  NE2 GLN A  39       5.515  -7.030  -6.851  1.00 61.58           N  
ATOM    287  N   LEU A  40       1.976  -7.546  -3.368  1.00 36.21           N  
ATOM    288  CA  LEU A  40       1.157  -6.384  -3.027  1.00 35.65           C  
ATOM    289  C   LEU A  40       1.938  -5.519  -2.040  1.00 40.11           C  
ATOM    290  O   LEU A  40       2.067  -4.304  -2.213  1.00 34.57           O  
ATOM    291  CB  LEU A  40      -0.149  -6.816  -2.372  1.00 30.02           C  
ATOM    292  CG  LEU A  40      -1.481  -6.933  -3.119  1.00 39.28           C  
ATOM    293  CD1 LEU A  40      -1.418  -6.218  -4.461  1.00 25.72           C  
ATOM    294  CD2 LEU A  40      -1.836  -8.385  -3.273  1.00 30.44           C  
ATOM    295  N   HIS A  41       2.450  -6.178  -1.003  1.00 36.02           N  
ATOM    296  CA  HIS A  41       3.235  -5.540   0.042  1.00 28.39           C  
ATOM    297  C   HIS A  41       4.443  -4.812  -0.534  1.00 34.60           C  
ATOM    298  O   HIS A  41       4.783  -3.704  -0.103  1.00 31.63           O  
ATOM    299  CB  HIS A  41       3.679  -6.606   1.048  1.00 20.21           C  
ATOM    300  CG  HIS A  41       4.798  -6.186   1.944  1.00 25.38           C  
ATOM    301  ND1 HIS A  41       6.126  -6.226   1.553  1.00 36.09           N  
ATOM    302  CD2 HIS A  41       4.805  -5.773   3.230  1.00 28.01           C  
ATOM    303  CE1 HIS A  41       6.890  -5.861   2.560  1.00 30.72           C  
ATOM    304  NE2 HIS A  41       6.116  -5.580   3.596  1.00 26.77           N  
ATOM    305  N   ASN A  42       5.089  -5.435  -1.516  1.00 32.85           N  
ATOM    306  CA  ASN A  42       6.260  -4.838  -2.137  1.00 35.81           C  
ATOM    307  C   ASN A  42       5.892  -3.630  -2.983  1.00 37.73           C  
ATOM    308  O   ASN A  42       6.627  -2.646  -3.007  1.00 39.19           O  
ATOM    309  CB  ASN A  42       6.992  -5.877  -2.978  1.00 30.38           C  
ATOM    310  CG  ASN A  42       7.809  -6.830  -2.135  1.00 24.76           C  
ATOM    311  OD1 ASN A  42       7.768  -6.789  -0.897  1.00 39.35           O  
ATOM    312  ND2 ASN A  42       8.562  -7.696  -2.793  1.00 35.62           N  
ATOM    313  N   ASP A  43       4.754  -3.695  -3.671  1.00 33.30           N  
ATOM    314  CA  ASP A  43       4.326  -2.566  -4.488  1.00 33.59           C  
ATOM    315  C   ASP A  43       3.929  -1.370  -3.632  1.00 29.83           C  
ATOM    316  O   ASP A  43       4.058  -0.229  -4.058  1.00 33.94           O  
ATOM    317  CB  ASP A  43       3.159  -2.956  -5.401  1.00 39.91           C  
ATOM    318  CG  ASP A  43       3.568  -3.950  -6.476  1.00 57.63           C  
ATOM    319  OD1 ASP A  43       4.764  -3.956  -6.854  1.00 49.51           O  
ATOM    320  OD2 ASP A  43       2.694  -4.714  -6.951  1.00 59.83           O  
ATOM    321  N   ILE A  44       3.427  -1.622  -2.431  1.00 28.77           N  
ATOM    322  CA  ILE A  44       3.053  -0.523  -1.556  1.00 30.41           C  
ATOM    323  C   ILE A  44       4.326   0.211  -1.078  1.00 32.55           C  
ATOM    324  O   ILE A  44       4.388   1.436  -1.102  1.00 38.29           O  
ATOM    325  CB  ILE A  44       2.264  -1.037  -0.349  1.00 29.04           C  
ATOM    326  CG1 ILE A  44       0.964  -1.684  -0.822  1.00 28.81           C  
ATOM    327  CG2 ILE A  44       1.949   0.106   0.585  1.00 24.59           C  
ATOM    328  CD1 ILE A  44       0.270  -2.569   0.214  1.00 56.58           C  
ATOM    329  N   LEU A  45       5.338  -0.548  -0.669  1.00 31.64           N  
ATOM    330  CA  LEU A  45       6.597   0.009  -0.200  1.00 35.48           C  
ATOM    331  C   LEU A  45       7.378   0.791  -1.256  1.00 40.23           C  
ATOM    332  O   LEU A  45       8.144   1.694  -0.913  1.00 40.99           O  
ATOM    333  CB  LEU A  45       7.485  -1.111   0.360  1.00 32.60           C  
ATOM    334  CG  LEU A  45       7.351  -1.351   1.869  1.00 42.53           C  
ATOM    335  CD1 LEU A  45       5.903  -1.652   2.232  1.00 45.00           C  
ATOM    336  CD2 LEU A  45       8.257  -2.496   2.274  1.00 49.96           C  
ATOM    337  N   LEU A  46       7.198   0.451  -2.531  1.00 37.15           N  
ATOM    338  CA  LEU A  46       7.907   1.151  -3.604  1.00 36.17           C  
ATOM    339  C   LEU A  46       7.038   2.222  -4.237  1.00 32.26           C  
ATOM    340  O   LEU A  46       7.480   2.941  -5.127  1.00 36.81           O  
ATOM    341  CB  LEU A  46       8.342   0.173  -4.692  1.00 38.40           C  
ATOM    342  CG  LEU A  46       9.328  -0.902  -4.243  1.00 50.30           C  
ATOM    343  CD1 LEU A  46       9.581  -1.855  -5.385  1.00 36.34           C  
ATOM    344  CD2 LEU A  46      10.615  -0.255  -3.778  1.00 42.05           C  
ATOM    345  N   ALA A  47       5.802   2.326  -3.771  1.00 31.82           N  
ATOM    346  CA  ALA A  47       4.877   3.311  -4.311  1.00 36.72           C  
ATOM    347  C   ALA A  47       5.362   4.751  -4.134  1.00 38.06           C  
ATOM    348  O   ALA A  47       6.011   5.099  -3.146  1.00 38.45           O  
ATOM    349  CB  ALA A  47       3.515   3.137  -3.670  1.00 29.06           C  
ATOM    350  N   LYS A  48       5.041   5.591  -5.106  1.00 58.80           N  
ATOM    351  CA  LYS A  48       5.432   6.988  -5.042  1.00 64.60           C  
ATOM    352  C   LYS A  48       4.176   7.811  -4.758  1.00 65.66           C  
ATOM    353  O   LYS A  48       4.211   8.789  -4.006  1.00 71.23           O  
ATOM    354  CB  LYS A  48       6.064   7.409  -6.371  1.00 69.45           C  
ATOM    355  CG  LYS A  48       6.996   8.608  -6.270  1.00 80.57           C  
ATOM    356  CD  LYS A  48       8.132   8.357  -5.273  1.00 88.96           C  
ATOM    357  CE  LYS A  48       9.044   7.213  -5.702  1.00 93.50           C  
ATOM    358  NZ  LYS A  48       9.819   7.529  -6.937  1.00 90.68           N  
ATOM    359  N   ASP A  49       3.065   7.380  -5.346  1.00 43.35           N  
ATOM    360  CA  ASP A  49       1.782   8.043  -5.195  1.00 37.24           C  
ATOM    361  C   ASP A  49       0.952   7.375  -4.101  1.00 39.81           C  
ATOM    362  O   ASP A  49       0.848   6.153  -4.033  1.00 37.23           O  
ATOM    363  CB  ASP A  49       1.030   8.001  -6.528  1.00 64.60           C  
ATOM    364  CG  ASP A  49      -0.368   8.577  -6.432  1.00 76.69           C  
ATOM    365  OD1 ASP A  49      -0.507   9.760  -6.050  1.00 86.40           O  
ATOM    366  OD2 ASP A  49      -1.329   7.842  -6.740  1.00 90.00           O  
ATOM    367  N   THR A  50       0.337   8.189  -3.257  1.00 37.68           N  
ATOM    368  CA  THR A  50      -0.453   7.667  -2.159  1.00 38.53           C  
ATOM    369  C   THR A  50      -1.711   6.894  -2.591  1.00 40.87           C  
ATOM    370  O   THR A  50      -2.223   6.063  -1.843  1.00 38.35           O  
ATOM    371  CB  THR A  50      -0.825   8.812  -1.176  1.00 41.12           C  
ATOM    372  OG1 THR A  50      -1.241   8.242   0.063  1.00 48.61           O  
ATOM    373  CG2 THR A  50      -1.954   9.693  -1.741  1.00 34.72           C  
ATOM    374  N   THR A  51      -2.196   7.160  -3.801  1.00 43.38           N  
ATOM    375  CA  THR A  51      -3.382   6.490  -4.329  1.00 36.47           C  
ATOM    376  C   THR A  51      -3.070   5.065  -4.790  1.00 37.19           C  
ATOM    377  O   THR A  51      -3.898   4.167  -4.686  1.00 39.15           O  
ATOM    378  CB  THR A  51      -3.985   7.299  -5.503  1.00 50.47           C  
ATOM    379  OG1 THR A  51      -4.462   8.558  -5.012  1.00 56.34           O  
ATOM    380  CG2 THR A  51      -5.138   6.553  -6.138  1.00 44.38           C  
ATOM    381  N   GLU A  52      -1.879   4.845  -5.313  1.00 43.07           N  
ATOM    382  CA  GLU A  52      -1.525   3.499  -5.730  1.00 44.19           C  
ATOM    383  C   GLU A  52      -1.339   2.639  -4.459  1.00 44.90           C  
ATOM    384  O   GLU A  52      -1.698   1.457  -4.432  1.00 46.14           O  
ATOM    385  CB  GLU A  52      -0.241   3.536  -6.554  1.00 33.44           C  
ATOM    386  CG  GLU A  52       0.325   2.166  -6.891  1.00 62.74           C  
ATOM    387  CD  GLU A  52       1.656   2.258  -7.600  1.00 72.23           C  
ATOM    388  OE1 GLU A  52       2.594   2.867  -7.037  1.00 75.16           O  
ATOM    389  OE2 GLU A  52       1.763   1.725  -8.722  1.00 89.20           O  
ATOM    390  N   ALA A  53      -0.788   3.244  -3.407  1.00 30.64           N  
ATOM    391  CA  ALA A  53      -0.566   2.542  -2.150  1.00 36.78           C  
ATOM    392  C   ALA A  53      -1.898   2.072  -1.554  1.00 37.79           C  
ATOM    393  O   ALA A  53      -2.072   0.886  -1.246  1.00 29.58           O  
ATOM    394  CB  ALA A  53       0.168   3.452  -1.150  1.00 24.12           C  
ATOM    395  N   PHE A  54      -2.840   2.997  -1.393  1.00 37.81           N  
ATOM    396  CA  PHE A  54      -4.127   2.629  -0.830  1.00 38.93           C  
ATOM    397  C   PHE A  54      -4.860   1.556  -1.624  1.00 38.84           C  
ATOM    398  O   PHE A  54      -5.475   0.668  -1.037  1.00 39.86           O  
ATOM    399  CB  PHE A  54      -5.011   3.863  -0.643  1.00 30.31           C  
ATOM    400  CG  PHE A  54      -4.752   4.580   0.645  1.00 45.96           C  
ATOM    401  CD1 PHE A  54      -4.168   5.840   0.656  1.00 52.59           C  
ATOM    402  CD2 PHE A  54      -5.038   3.964   1.860  1.00 50.04           C  
ATOM    403  CE1 PHE A  54      -3.866   6.476   1.863  1.00 55.64           C  
ATOM    404  CE2 PHE A  54      -4.742   4.589   3.070  1.00 50.03           C  
ATOM    405  CZ  PHE A  54      -4.153   5.847   3.071  1.00 47.21           C  
ATOM    406  N   GLU A  55      -4.797   1.618  -2.949  1.00 32.55           N  
ATOM    407  CA  GLU A  55      -5.471   0.601  -3.752  1.00 34.17           C  
ATOM    408  C   GLU A  55      -4.863  -0.770  -3.474  1.00 30.59           C  
ATOM    409  O   GLU A  55      -5.572  -1.761  -3.307  1.00 37.70           O  
ATOM    410  CB  GLU A  55      -5.340   0.899  -5.245  1.00 29.69           C  
ATOM    411  CG  GLU A  55      -6.160   2.061  -5.735  1.00 48.59           C  
ATOM    412  CD  GLU A  55      -6.018   2.249  -7.236  1.00 66.02           C  
ATOM    413  OE1 GLU A  55      -6.255   1.272  -7.984  1.00 74.56           O  
ATOM    414  OE2 GLU A  55      -5.671   3.370  -7.667  1.00 74.09           O  
ATOM    415  N   LYS A  56      -3.538  -0.827  -3.436  1.00 29.75           N  
ATOM    416  CA  LYS A  56      -2.862  -2.082  -3.181  1.00 26.08           C  
ATOM    417  C   LYS A  56      -3.158  -2.586  -1.771  1.00 31.76           C  
ATOM    418  O   LYS A  56      -3.246  -3.789  -1.545  1.00 32.14           O  
ATOM    419  CB  LYS A  56      -1.359  -1.901  -3.383  1.00 31.67           C  
ATOM    420  CG  LYS A  56      -0.963  -1.672  -4.831  1.00 37.06           C  
ATOM    421  CD  LYS A  56      -0.991  -2.959  -5.611  1.00 45.68           C  
ATOM    422  CE  LYS A  56      -0.718  -2.730  -7.102  1.00 47.56           C  
ATOM    423  NZ  LYS A  56       0.553  -1.986  -7.336  1.00 44.07           N  
ATOM    424  N   MET A  57      -3.303  -1.656  -0.830  1.00 31.37           N  
ATOM    425  CA  MET A  57      -3.586  -1.988   0.562  1.00 32.94           C  
ATOM    426  C   MET A  57      -4.989  -2.595   0.654  1.00 33.96           C  
ATOM    427  O   MET A  57      -5.255  -3.434   1.514  1.00 30.82           O  
ATOM    428  CB  MET A  57      -3.489  -0.727   1.424  1.00 37.38           C  
ATOM    429  CG  MET A  57      -3.697  -0.951   2.911  1.00 60.54           C  
ATOM    430  SD  MET A  57      -2.227  -1.556   3.754  1.00 67.03           S  
ATOM    431  CE  MET A  57      -1.764  -0.091   4.642  1.00 71.13           C  
ATOM    432  N   VAL A  58      -5.883  -2.162  -0.232  1.00 29.87           N  
ATOM    433  CA  VAL A  58      -7.237  -2.700  -0.276  1.00 25.47           C  
ATOM    434  C   VAL A  58      -7.161  -4.170  -0.697  1.00 32.65           C  
ATOM    435  O   VAL A  58      -7.823  -5.036  -0.117  1.00 31.21           O  
ATOM    436  CB  VAL A  58      -8.115  -1.930  -1.282  1.00 39.09           C  
ATOM    437  CG1 VAL A  58      -9.377  -2.746  -1.623  1.00 34.14           C  
ATOM    438  CG2 VAL A  58      -8.503  -0.570  -0.692  1.00 31.26           C  
ATOM    439  N   SER A  59      -6.344  -4.457  -1.708  1.00 31.67           N  
ATOM    440  CA  SER A  59      -6.197  -5.832  -2.164  1.00 31.68           C  
ATOM    441  C   SER A  59      -5.556  -6.713  -1.086  1.00 32.96           C  
ATOM    442  O   SER A  59      -5.976  -7.856  -0.859  1.00 30.21           O  
ATOM    443  CB  SER A  59      -5.344  -5.890  -3.438  1.00 24.74           C  
ATOM    444  OG  SER A  59      -5.995  -5.261  -4.525  1.00 37.78           O  
ATOM    445  N   LEU A  60      -4.538  -6.176  -0.423  1.00 28.24           N  
ATOM    446  CA  LEU A  60      -3.831  -6.927   0.598  1.00 25.87           C  
ATOM    447  C   LEU A  60      -4.677  -7.136   1.832  1.00 27.03           C  
ATOM    448  O   LEU A  60      -4.701  -8.223   2.384  1.00 36.75           O  
ATOM    449  CB  LEU A  60      -2.531  -6.215   0.992  1.00 24.15           C  
ATOM    450  CG  LEU A  60      -1.661  -6.995   1.986  1.00 30.15           C  
ATOM    451  CD1 LEU A  60      -1.290  -8.341   1.374  1.00 26.98           C  
ATOM    452  CD2 LEU A  60      -0.399  -6.196   2.338  1.00 25.57           C  
ATOM    453  N   LEU A  61      -5.379  -6.098   2.272  1.00 32.21           N  
ATOM    454  CA  LEU A  61      -6.199  -6.223   3.465  1.00 30.05           C  
ATOM    455  C   LEU A  61      -7.331  -7.199   3.241  1.00 30.83           C  
ATOM    456  O   LEU A  61      -7.769  -7.862   4.181  1.00 34.14           O  
ATOM    457  CB  LEU A  61      -6.773  -4.871   3.889  1.00 24.69           C  
ATOM    458  CG  LEU A  61      -7.733  -4.924   5.078  1.00 27.04           C  
ATOM    459  CD1 LEU A  61      -7.032  -5.552   6.263  1.00 25.64           C  
ATOM    460  CD2 LEU A  61      -8.221  -3.512   5.428  1.00 31.61           C  
ATOM    461  N   SER A  62      -7.811  -7.289   2.002  1.00 29.51           N  
ATOM    462  CA  SER A  62      -8.911  -8.204   1.694  1.00 35.80           C  
ATOM    463  C   SER A  62      -8.556  -9.665   1.998  1.00 36.61           C  
ATOM    464  O   SER A  62      -9.437 -10.464   2.310  1.00 33.50           O  
ATOM    465  CB  SER A  62      -9.342  -8.068   0.230  1.00 39.68           C  
ATOM    466  OG  SER A  62      -8.445  -8.725  -0.643  1.00 36.43           O  
ATOM    467  N   VAL A  63      -7.274 -10.013   1.910  1.00 35.15           N  
ATOM    468  CA  VAL A  63      -6.854 -11.379   2.205  1.00 31.14           C  
ATOM    469  C   VAL A  63      -7.072 -11.664   3.691  1.00 30.94           C  
ATOM    470  O   VAL A  63      -7.605 -12.709   4.062  1.00 33.33           O  
ATOM    471  CB  VAL A  63      -5.367 -11.598   1.845  1.00 28.10           C  
ATOM    472  CG1 VAL A  63      -4.913 -12.988   2.265  1.00 25.16           C  
ATOM    473  CG2 VAL A  63      -5.174 -11.427   0.361  1.00 22.76           C  
ATOM    474  N   LEU A  64      -6.674 -10.723   4.539  1.00 31.11           N  
ATOM    475  CA  LEU A  64      -6.834 -10.878   5.978  1.00 28.78           C  
ATOM    476  C   LEU A  64      -8.310 -10.994   6.385  1.00 32.69           C  
ATOM    477  O   LEU A  64      -8.672 -11.856   7.192  1.00 28.85           O  
ATOM    478  CB  LEU A  64      -6.198  -9.696   6.731  1.00 20.22           C  
ATOM    479  CG  LEU A  64      -6.371  -9.799   8.257  1.00 35.44           C  
ATOM    480  CD1 LEU A  64      -5.743 -11.099   8.730  1.00 32.19           C  
ATOM    481  CD2 LEU A  64      -5.729  -8.629   8.971  1.00 20.68           C  
ATOM    482  N   LEU A  65      -9.155 -10.130   5.824  1.00 32.01           N  
ATOM    483  CA  LEU A  65     -10.578 -10.124   6.150  1.00 32.46           C  
ATOM    484  C   LEU A  65     -11.267 -11.426   5.750  1.00 34.39           C  
ATOM    485  O   LEU A  65     -12.180 -11.897   6.434  1.00 35.64           O  
ATOM    486  CB  LEU A  65     -11.268  -8.938   5.474  1.00 28.72           C  
ATOM    487  CG  LEU A  65     -10.705  -7.563   5.843  1.00 38.16           C  
ATOM    488  CD1 LEU A  65     -11.480  -6.469   5.103  1.00 26.04           C  
ATOM    489  CD2 LEU A  65     -10.789  -7.365   7.369  1.00 24.40           C  
ATOM    490  N   SER A  66     -10.826 -12.009   4.644  1.00 30.81           N  
ATOM    491  CA  SER A  66     -11.404 -13.259   4.187  1.00 37.15           C  
ATOM    492  C   SER A  66     -11.096 -14.382   5.183  1.00 38.28           C  
ATOM    493  O   SER A  66     -11.962 -15.182   5.527  1.00 34.94           O  
ATOM    494  CB  SER A  66     -10.850 -13.615   2.808  1.00 30.42           C  
ATOM    495  OG  SER A  66     -11.545 -14.721   2.264  1.00 37.28           O  
ATOM    496  N   MET A  67      -9.855 -14.422   5.654  1.00 48.59           N  
ATOM    497  CA  MET A  67      -9.414 -15.437   6.608  1.00 49.93           C  
ATOM    498  C   MET A  67      -9.903 -15.247   8.042  1.00 51.22           C  
ATOM    499  O   MET A  67     -10.192 -16.218   8.720  1.00 57.66           O  
ATOM    500  CB  MET A  67      -7.898 -15.498   6.623  1.00 38.98           C  
ATOM    501  CG  MET A  67      -7.288 -15.930   5.311  1.00 50.92           C  
ATOM    502  SD  MET A  67      -5.509 -15.741   5.392  1.00 59.52           S  
ATOM    503  CE  MET A  67      -5.123 -16.972   6.643  1.00 71.78           C  
ATOM    504  N   GLN A  68      -9.995 -14.005   8.508  1.00 50.91           N  
ATOM    505  CA  GLN A  68     -10.436 -13.750   9.877  1.00 47.84           C  
ATOM    506  C   GLN A  68     -11.918 -13.994  10.122  1.00 48.85           C  
ATOM    507  O   GLN A  68     -12.280 -14.685  11.065  1.00 51.32           O  
ATOM    508  CB  GLN A  68     -10.079 -12.319  10.303  1.00 50.19           C  
ATOM    509  CG  GLN A  68      -8.647 -12.142  10.791  1.00 48.04           C  
ATOM    510  CD  GLN A  68      -8.352 -12.994  12.018  1.00 67.71           C  
ATOM    511  OE1 GLN A  68      -8.169 -14.208  11.920  1.00 56.22           O  
ATOM    512  NE2 GLN A  68      -8.325 -12.360  13.185  1.00 69.66           N  
ATOM    513  N   GLY A  69     -12.778 -13.415   9.292  1.00 54.46           N  
ATOM    514  CA  GLY A  69     -14.203 -13.608   9.477  1.00 51.73           C  
ATOM    515  C   GLY A  69     -14.847 -12.680  10.498  1.00 60.67           C  
ATOM    516  O   GLY A  69     -14.269 -12.376  11.548  1.00 59.30           O  
ATOM    517  N   ALA A  70     -16.070 -12.254  10.182  1.00 60.25           N  
ATOM    518  CA  ALA A  70     -16.866 -11.344  11.009  1.00 55.19           C  
ATOM    519  C   ALA A  70     -16.684 -11.464  12.506  1.00 50.56           C  
ATOM    520  O   ALA A  70     -16.443 -10.473  13.200  1.00 43.49           O  
ATOM    521  CB  ALA A  70     -18.345 -11.513  10.677  1.00 57.90           C  
ATOM    522  N   VAL A  71     -16.819 -12.679  13.012  1.00 61.16           N  
ATOM    523  CA  VAL A  71     -16.706 -12.895  14.445  1.00 65.34           C  
ATOM    524  C   VAL A  71     -15.419 -12.327  15.050  1.00 66.35           C  
ATOM    525  O   VAL A  71     -15.463 -11.553  16.016  1.00 63.07           O  
ATOM    526  CB  VAL A  71     -16.813 -14.392  14.766  1.00 66.36           C  
ATOM    527  CG1 VAL A  71     -16.953 -14.587  16.269  1.00 75.19           C  
ATOM    528  CG2 VAL A  71     -18.008 -14.994  14.025  1.00 48.88           C  
ATOM    529  N   ASP A  72     -14.278 -12.692  14.468  1.00 59.18           N  
ATOM    530  CA  ASP A  72     -12.985 -12.228  14.962  1.00 59.96           C  
ATOM    531  C   ASP A  72     -12.703 -10.739  14.805  1.00 57.36           C  
ATOM    532  O   ASP A  72     -12.365 -10.070  15.783  1.00 53.72           O  
ATOM    533  CB  ASP A  72     -11.856 -13.019  14.302  1.00 78.85           C  
ATOM    534  CG  ASP A  72     -11.771 -14.443  14.809  1.00 91.12           C  
ATOM    535  OD1 ASP A  72     -11.610 -14.625  16.036  1.00 99.71           O  
ATOM    536  OD2 ASP A  72     -11.868 -15.378  13.985  1.00 93.54           O  
ATOM    537  N   ILE A  73     -12.831 -10.213  13.588  1.00 57.38           N  
ATOM    538  CA  ILE A  73     -12.541  -8.804  13.386  1.00 60.21           C  
ATOM    539  C   ILE A  73     -13.579  -7.963  14.114  1.00 63.16           C  
ATOM    540  O   ILE A  73     -13.367  -6.782  14.389  1.00 67.22           O  
ATOM    541  CB  ILE A  73     -12.459  -8.404  11.853  1.00 65.67           C  
ATOM    542  CG1 ILE A  73     -13.682  -7.581  11.437  1.00 65.69           C  
ATOM    543  CG2 ILE A  73     -12.290  -9.648  10.968  1.00 42.85           C  
ATOM    544  CD1 ILE A  73     -13.545  -6.852  10.102  1.00 56.58           C  
ATOM    545  N   ASN A  74     -14.700  -8.581  14.454  1.00 57.20           N  
ATOM    546  CA  ASN A  74     -15.738  -7.856  15.160  1.00 62.46           C  
ATOM    547  C   ASN A  74     -15.352  -7.617  16.606  1.00 65.40           C  
ATOM    548  O   ASN A  74     -15.240  -6.471  17.040  1.00 63.85           O  
ATOM    549  CB  ASN A  74     -17.047  -8.617  15.095  1.00 69.78           C  
ATOM    550  CG  ASN A  74     -18.143  -7.788  14.510  1.00 57.73           C  
ATOM    551  OD1 ASN A  74     -18.843  -8.226  13.602  1.00 63.96           O  
ATOM    552  ND2 ASN A  74     -18.302  -6.569  15.025  1.00 35.86           N  
ATOM    553  N   ARG A  75     -15.149  -8.697  17.356  1.00 73.96           N  
ATOM    554  CA  ARG A  75     -14.761  -8.563  18.755  1.00 81.71           C  
ATOM    555  C   ARG A  75     -13.340  -8.013  18.830  1.00 82.02           C  
ATOM    556  O   ARG A  75     -12.783  -7.849  19.910  1.00 79.33           O  
ATOM    557  CB  ARG A  75     -14.835  -9.914  19.480  1.00100.35           C  
ATOM    558  CG  ARG A  75     -13.784 -10.927  19.062  1.00108.77           C  
ATOM    559  CD  ARG A  75     -13.753 -12.107  20.027  1.00121.37           C  
ATOM    560  NE  ARG A  75     -12.657 -13.030  19.736  1.00139.24           N  
ATOM    561  CZ  ARG A  75     -12.308 -14.051  20.514  1.00147.91           C  
ATOM    562  NH1 ARG A  75     -12.969 -14.287  21.641  1.00149.07           N  
ATOM    563  NH2 ARG A  75     -11.294 -14.836  20.168  1.00148.90           N  
ATOM    564  N   LEU A  76     -12.762  -7.736  17.664  1.00105.46           N  
ATOM    565  CA  LEU A  76     -11.411  -7.205  17.571  1.00104.43           C  
ATOM    566  C   LEU A  76     -11.468  -5.683  17.497  1.00105.00           C  
ATOM    567  O   LEU A  76     -10.551  -5.003  17.946  1.00111.01           O  
ATOM    568  CB  LEU A  76     -10.705  -7.786  16.335  1.00 82.80           C  
ATOM    569  CG  LEU A  76      -9.251  -7.429  15.995  1.00 63.41           C  
ATOM    570  CD1 LEU A  76      -9.183  -6.029  15.445  1.00 69.13           C  
ATOM    571  CD2 LEU A  76      -8.375  -7.572  17.224  1.00 65.73           C  
ATOM    572  N   CYS A  77     -12.542  -5.149  16.927  1.00 84.07           N  
ATOM    573  CA  CYS A  77     -12.701  -3.703  16.827  1.00 83.66           C  
ATOM    574  C   CYS A  77     -13.075  -3.148  18.199  1.00 85.82           C  
ATOM    575  O   CYS A  77     -14.077  -2.451  18.350  1.00 84.66           O  
ATOM    576  CB  CYS A  77     -13.791  -3.345  15.814  1.00 90.53           C  
ATOM    577  SG  CYS A  77     -13.346  -3.579  14.069  1.00 89.88           S  
ATOM    578  N   GLU A  78     -12.261  -3.467  19.200  1.00102.81           N  
ATOM    579  CA  GLU A  78     -12.495  -3.014  20.565  1.00101.50           C  
ATOM    580  C   GLU A  78     -11.182  -2.813  21.320  1.00 99.80           C  
ATOM    581  O   GLU A  78     -10.978  -1.700  21.849  1.00 56.58           O  
ATOM    582  CB  GLU A  78     -13.357  -4.032  21.306  1.00 92.83           C  
ATOM    583  CG  GLU A  78     -12.791  -5.435  21.261  1.00 99.03           C  
ATOM    584  CD  GLU A  78     -13.587  -6.417  22.091  1.00 97.16           C  
ATOM    585  OE1 GLU A  78     -14.821  -6.487  21.912  1.00 92.11           O  
ATOM    586  OE2 GLU A  78     -12.975  -7.126  22.918  1.00 92.90           O  
TER     587      GLU A  78                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
