
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  877),  selected   56 , name 2fs1_A
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 2fs1_A.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    A     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    D     5_A      -       -           -
LGA    A     6_A      -       -           -
LGA    N     7_A      -       -           -
LGA    S     8_A      N       8          1.354
LGA    L     9_A      L       9          1.083
LGA    A    10_A      K      10          1.422
LGA    Q    11_A      Q      11          0.892
LGA    A    12_A      A      12          0.881
LGA    K    13_A      K      13          1.395
LGA    E    14_A      E      14          0.868
LGA    A    15_A      E      15          1.057
LGA    A    16_A      A      16          2.145
LGA    I    17_A      I      17          1.768
LGA    K    18_A      K      18          0.608
LGA    E    19_A      E      19          0.731
LGA    L    20_A      L      20          0.897
LGA    K    21_A      V      21          1.773
LGA    Q    22_A      D      22          1.598
LGA    Y    23_A      A      23          0.810
LGA    G    24_A      G      24          1.035
LGA    I    25_A      T      25          0.690
LGA    G    26_A      A      26          2.186
LGA    D    27_A      E      27          1.821
LGA    Y    28_A      K      28          0.813
LGA    Y    29_A      Y      29          1.464
LGA    I    30_A      I      30          1.530
LGA    K    31_A      K      31          1.027
LGA    L    32_A      L      32          0.798
LGA    I    33_A      I      33          0.650
LGA    N    34_A      A      34          0.756
LGA    N    35_A      N      35          1.137
LGA    A    36_A      A      36          1.025
LGA    K    37_A      K      37          1.365
LGA    T    38_A      T      38          1.358
LGA    V    39_A      V      39          1.216
LGA    E    40_A      E      40          0.866
LGA    G    41_A      G      41          1.099
LGA    V    42_A      V      42          0.402
LGA    E    43_A      W      43          0.554
LGA    S    44_A      T      44          1.256
LGA    L    45_A      L      45          1.173
LGA    K    46_A      K      46          1.017
LGA    N    47_A      D      47          0.317
LGA    E    48_A      E      48          1.349
LGA    I    49_A      I      49          1.581
LGA    L    50_A      K      50          1.104
LGA    K    51_A      T      51          1.095
LGA    A    52_A      F      52          1.725
LGA    L    53_A      -       -           -
LGA    P    54_A      -       -           -
LGA    T    55_A      -       -           -
LGA    E    56_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   45    5.0     45    1.22    62.22     94.639     3.399

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.970268 * X  +   0.182313 * Y  +   0.159192 * Z  +   0.065983
  Y_new =  -0.201356 * X  +   0.972984 * Y  +   0.112949 * Z  +   1.842953
  Z_new =  -0.134299 * X  +  -0.141645 * Y  +   0.980765 * Z  +   1.004157 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.143432    2.998161  [ DEG:    -8.2180    171.7820 ]
  Theta =   0.134706    3.006887  [ DEG:     7.7181    172.2819 ]
  Phi   =  -0.204621    2.936971  [ DEG:   -11.7239    168.2761 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fs1_A                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fs1_A.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   45   5.0   45   1.22   62.22  94.639
REMARK  ---------------------------------------------------------- 
MOLECULE 2fs1_A
HEADER    PROTEIN BINDING                         20-JAN-06   2FS1              
TITLE     SOLUTION STRUCTURE OF PSD-1                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PSD-1;                                                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PEPTOSTREPTOCOCCUS MAGNUS,                      
SOURCE   3 STREPTOCOCCUS DYSGALACTIAE, STREPTOCOCCUS EQUI,                      
SOURCE   4 STREPTOCOCCUS CANIS, STREPTOCOCCUS SP.;                              
SOURCE   5 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: XL-10;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PG58                                      
KEYWDS    SOLUTION STRUCTURE, PSD-1                                             
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    Y.HE,D.A.ROZAK,N.SARI,Y.CHEN,P.BRYAN,J.ORBAN                          
REVDAT   2   19-DEC-06 2FS1    2       SOURCE EXPDTA REMARK ATOM                
REVDAT   2 2                   2       MASTER                                   
REVDAT   1   05-DEC-06 2FS1    0                                                
JRNL        AUTH   Y.HE,D.A.ROZAK,N.SARI,Y.CHEN,P.BRYAN,J.ORBAN                 
JRNL        TITL   STRUCTURE, DYNAMICS, AND STABILITY VARIATION IN              
JRNL        TITL 2 BACTERIAL ALBUMIN BINDING MODULES: IMPLICATIONS              
JRNL        TITL 3 FOR SPECIES SPECIFICITY.                                     
JRNL        REF    BIOCHEMISTRY                  V.  45 10102 2006              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
SEQRES   1 A   56  MET GLU ALA VAL ASP ALA ASN SER LEU ALA GLN ALA LYS          
SEQRES   2 A   56  GLU ALA ALA ILE LYS GLU LEU LYS GLN TYR GLY ILE GLY          
SEQRES   3 A   56  ASP TYR TYR ILE LYS LEU ILE ASN ASN ALA LYS THR VAL          
SEQRES   4 A   56  GLU GLY VAL GLU SER LEU LYS ASN GLU ILE LEU LYS ALA          
SEQRES   5 A   56  LEU PRO THR GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       8.890  17.784   0.497  1.00  0.00           N  
ATOM      2  CA  MET A   1       9.173  18.960   1.355  1.00  0.00           C  
ATOM      3  C   MET A   1       8.048  19.987   1.274  1.00  0.00           C  
ATOM      4  O   MET A   1       8.281  21.189   1.384  1.00  0.00           O  
ATOM      5  CB  MET A   1      10.497  19.594   0.897  1.00  0.00           C  
ATOM      6  CG  MET A   1      10.493  19.999  -0.566  1.00  0.00           C  
ATOM      7  SD  MET A   1      12.160  20.223  -1.222  1.00  0.00           S  
ATOM      8  CE  MET A   1      12.075  21.917  -1.799  1.00  0.00           C  
ATOM      9  H2  MET A   1       9.784  17.267   0.361  1.00  0.00           H  
ATOM     10  HA  MET A   1       9.280  18.632   2.376  1.00  0.00           H  
ATOM     11  HB2 MET A   1      10.687  20.464   1.497  1.00  0.00           H  
ATOM     12  HB3 MET A   1      11.292  18.878   1.048  1.00  0.00           H  
ATOM     13  HG2 MET A   1       9.999  19.241  -1.143  1.00  0.00           H  
ATOM     14  HG3 MET A   1       9.961  20.937  -0.665  1.00  0.00           H  
ATOM     15  HE1 MET A   1      11.513  21.958  -2.720  1.00  0.00           H  
ATOM     16  HE2 MET A   1      13.074  22.290  -1.972  1.00  0.00           H  
ATOM     17  HE3 MET A   1      11.592  22.532  -1.053  1.00  0.00           H  
ATOM     18  H1  MET A   1       8.186  17.192   0.993  1.00  0.00           H  
ATOM     19  H3  MET A   1       8.516  18.132  -0.407  1.00  0.00           H  
ATOM     20  N   GLU A   2       6.828  19.504   1.084  1.00  0.00           N  
ATOM     21  CA  GLU A   2       5.665  20.377   0.990  1.00  0.00           C  
ATOM     22  C   GLU A   2       5.068  20.640   2.370  1.00  0.00           C  
ATOM     23  O   GLU A   2       4.661  21.763   2.675  1.00  0.00           O  
ATOM     24  CB  GLU A   2       4.601  19.750   0.079  1.00  0.00           C  
ATOM     25  CG  GLU A   2       5.132  19.371  -1.294  1.00  0.00           C  
ATOM     26  CD  GLU A   2       4.185  19.743  -2.407  1.00  0.00           C  
ATOM     27  OE1 GLU A   2       3.055  19.209  -2.433  1.00  0.00           O  
ATOM     28  OE2 GLU A   2       4.563  20.573  -3.259  1.00  0.00           O  
ATOM     29  H   GLU A   2       6.704  18.532   1.005  1.00  0.00           H  
ATOM     30  HA  GLU A   2       5.985  21.312   0.563  1.00  0.00           H  
ATOM     31  HB2 GLU A   2       4.215  18.863   0.552  1.00  0.00           H  
ATOM     32  HB3 GLU A   2       3.798  20.462  -0.053  1.00  0.00           H  
ATOM     33  HG2 GLU A   2       6.070  19.876  -1.459  1.00  0.00           H  
ATOM     34  HG3 GLU A   2       5.292  18.304  -1.320  1.00  0.00           H  
ATOM     35  N   ALA A   3       5.027  19.605   3.202  1.00  0.00           N  
ATOM     36  CA  ALA A   3       4.487  19.722   4.544  1.00  0.00           C  
ATOM     37  C   ALA A   3       4.670  18.424   5.309  1.00  0.00           C  
ATOM     38  O   ALA A   3       5.492  18.335   6.221  1.00  0.00           O  
ATOM     39  CB  ALA A   3       3.018  20.110   4.487  1.00  0.00           C  
ATOM     40  H   ALA A   3       5.368  18.735   2.903  1.00  0.00           H  
ATOM     41  HA  ALA A   3       5.029  20.508   5.051  1.00  0.00           H  
ATOM     42  HB1 ALA A   3       2.922  21.082   4.013  1.00  0.00           H  
ATOM     43  HB2 ALA A   3       2.626  20.168   5.493  1.00  0.00           H  
ATOM     44  HB3 ALA A   3       2.466  19.375   3.929  1.00  0.00           H  
ATOM     45  N   VAL A   4       3.888  17.414   4.941  1.00  0.00           N  
ATOM     46  CA  VAL A   4       3.958  16.112   5.589  1.00  0.00           C  
ATOM     47  C   VAL A   4       3.346  15.035   4.706  1.00  0.00           C  
ATOM     48  O   VAL A   4       2.793  14.055   5.203  1.00  0.00           O  
ATOM     49  CB  VAL A   4       3.239  16.120   6.944  1.00  0.00           C  
ATOM     50  CG1 VAL A   4       4.075  16.827   7.996  1.00  0.00           C  
ATOM     51  CG2 VAL A   4       1.868  16.765   6.813  1.00  0.00           C  
ATOM     52  H   VAL A   4       3.252  17.548   4.206  1.00  0.00           H  
ATOM     53  HA  VAL A   4       4.998  15.877   5.758  1.00  0.00           H  
ATOM     54  HB  VAL A   4       3.097  15.096   7.260  1.00  0.00           H  
ATOM     55 HG11 VAL A   4       3.707  16.574   8.983  1.00  0.00           H  
ATOM     56 HG12 VAL A   4       4.009  17.895   7.849  1.00  0.00           H  
ATOM     57 HG13 VAL A   4       5.108  16.516   7.899  1.00  0.00           H  
ATOM     58 HG21 VAL A   4       1.923  17.798   7.151  1.00  0.00           H  
ATOM     59 HG22 VAL A   4       1.157  16.226   7.423  1.00  0.00           H  
ATOM     60 HG23 VAL A   4       1.553  16.742   5.783  1.00  0.00           H  
ATOM     61  N   ASP A   5       3.444  15.223   3.395  1.00  0.00           N  
ATOM     62  CA  ASP A   5       2.894  14.267   2.442  1.00  0.00           C  
ATOM     63  C   ASP A   5       3.744  13.000   2.383  1.00  0.00           C  
ATOM     64  O   ASP A   5       3.223  11.892   2.339  1.00  0.00           O  
ATOM     65  CB  ASP A   5       2.797  14.895   1.052  1.00  0.00           C  
ATOM     66  CG  ASP A   5       4.148  15.363   0.533  1.00  0.00           C  
ATOM     67  OD1 ASP A   5       4.865  14.536  -0.073  1.00  0.00           O  
ATOM     68  OD2 ASP A   5       4.484  16.545   0.733  1.00  0.00           O  
ATOM     69  H   ASP A   5       3.894  16.027   3.060  1.00  0.00           H  
ATOM     70  HA  ASP A   5       1.903  14.005   2.775  1.00  0.00           H  
ATOM     71  HB2 ASP A   5       2.397  14.170   0.360  1.00  0.00           H  
ATOM     72  HB3 ASP A   5       2.138  15.751   1.095  1.00  0.00           H  
ATOM     73  N   ALA A   6       5.059  13.177   2.379  1.00  0.00           N  
ATOM     74  CA  ALA A   6       5.987  12.054   2.322  1.00  0.00           C  
ATOM     75  C   ALA A   6       5.951  11.247   3.616  1.00  0.00           C  
ATOM     76  O   ALA A   6       6.112  10.023   3.602  1.00  0.00           O  
ATOM     77  CB  ALA A   6       7.396  12.540   2.041  1.00  0.00           C  
ATOM     78  H   ALA A   6       5.419  14.088   2.413  1.00  0.00           H  
ATOM     79  HA  ALA A   6       5.681  11.415   1.504  1.00  0.00           H  
ATOM     80  HB1 ALA A   6       7.561  12.582   0.974  1.00  0.00           H  
ATOM     81  HB2 ALA A   6       8.110  11.862   2.488  1.00  0.00           H  
ATOM     82  HB3 ALA A   6       7.531  13.532   2.460  1.00  0.00           H  
ATOM     83  N   ASN A   7       5.740  11.934   4.735  1.00  0.00           N  
ATOM     84  CA  ASN A   7       5.684  11.275   6.035  1.00  0.00           C  
ATOM     85  C   ASN A   7       4.442  10.398   6.144  1.00  0.00           C  
ATOM     86  O   ASN A   7       4.519   9.241   6.554  1.00  0.00           O  
ATOM     87  CB  ASN A   7       5.693  12.316   7.158  1.00  0.00           C  
ATOM     88  CG  ASN A   7       7.062  12.474   7.788  1.00  0.00           C  
ATOM     89  OD1 ASN A   7       7.616  11.527   8.346  1.00  0.00           O  
ATOM     90  ND2 ASN A   7       7.615  13.678   7.700  1.00  0.00           N  
ATOM     91  H   ASN A   7       5.618  12.905   4.685  1.00  0.00           H  
ATOM     92  HA  ASN A   7       6.562  10.651   6.128  1.00  0.00           H  
ATOM     93  HB2 ASN A   7       5.385  13.267   6.760  1.00  0.00           H  
ATOM     94  HB3 ASN A   7       4.998  12.011   7.928  1.00  0.00           H  
ATOM     95 HD21 ASN A   7       7.115  14.385   7.241  1.00  0.00           H  
ATOM     96 HD22 ASN A   7       8.498  13.808   8.098  1.00  0.00           H  
ATOM     97  N   SER A   8       3.293  10.953   5.768  1.00  0.00           N  
ATOM     98  CA  SER A   8       2.038  10.226   5.816  1.00  0.00           C  
ATOM     99  C   SER A   8       2.025   9.111   4.777  1.00  0.00           C  
ATOM    100  O   SER A   8       1.412   8.064   4.980  1.00  0.00           O  
ATOM    101  CB  SER A   8       0.860  11.174   5.582  1.00  0.00           C  
ATOM    102  OG  SER A   8      -0.363  10.461   5.513  1.00  0.00           O  
ATOM    103  H   SER A   8       3.296  11.879   5.445  1.00  0.00           H  
ATOM    104  HA  SER A   8       1.946   9.786   6.798  1.00  0.00           H  
ATOM    105  HB2 SER A   8       0.803  11.880   6.395  1.00  0.00           H  
ATOM    106  HB3 SER A   8       1.006  11.703   4.652  1.00  0.00           H  
ATOM    107  HG  SER A   8      -0.392   9.803   6.213  1.00  0.00           H  
ATOM    108  N   LEU A   9       2.708   9.350   3.662  1.00  0.00           N  
ATOM    109  CA  LEU A   9       2.780   8.371   2.584  1.00  0.00           C  
ATOM    110  C   LEU A   9       3.527   7.118   3.035  1.00  0.00           C  
ATOM    111  O   LEU A   9       3.101   5.995   2.767  1.00  0.00           O  
ATOM    112  CB  LEU A   9       3.490   8.976   1.371  1.00  0.00           C  
ATOM    113  CG  LEU A   9       3.362   8.185   0.064  1.00  0.00           C  
ATOM    114  CD1 LEU A   9       4.024   8.937  -1.072  1.00  0.00           C  
ATOM    115  CD2 LEU A   9       3.969   6.798   0.202  1.00  0.00           C  
ATOM    116  H   LEU A   9       3.175  10.205   3.560  1.00  0.00           H  
ATOM    117  HA  LEU A   9       1.772   8.107   2.306  1.00  0.00           H  
ATOM    118  HB2 LEU A   9       3.092   9.965   1.207  1.00  0.00           H  
ATOM    119  HB3 LEU A   9       4.539   9.065   1.607  1.00  0.00           H  
ATOM    120  HG  LEU A   9       2.318   8.071  -0.179  1.00  0.00           H  
ATOM    121 HD11 LEU A   9       4.067   9.990  -0.830  1.00  0.00           H  
ATOM    122 HD12 LEU A   9       3.455   8.797  -1.979  1.00  0.00           H  
ATOM    123 HD13 LEU A   9       5.022   8.556  -1.213  1.00  0.00           H  
ATOM    124 HD21 LEU A   9       3.211   6.104   0.536  1.00  0.00           H  
ATOM    125 HD22 LEU A   9       4.774   6.825   0.920  1.00  0.00           H  
ATOM    126 HD23 LEU A   9       4.352   6.476  -0.755  1.00  0.00           H  
ATOM    127  N   ALA A  10       4.656   7.326   3.707  1.00  0.00           N  
ATOM    128  CA  ALA A  10       5.485   6.225   4.183  1.00  0.00           C  
ATOM    129  C   ALA A  10       4.773   5.381   5.235  1.00  0.00           C  
ATOM    130  O   ALA A  10       5.139   4.230   5.459  1.00  0.00           O  
ATOM    131  CB  ALA A  10       6.796   6.761   4.738  1.00  0.00           C  
ATOM    132  H   ALA A  10       4.945   8.247   3.876  1.00  0.00           H  
ATOM    133  HA  ALA A  10       5.716   5.598   3.335  1.00  0.00           H  
ATOM    134  HB1 ALA A  10       6.982   7.741   4.332  1.00  0.00           H  
ATOM    135  HB2 ALA A  10       7.601   6.095   4.465  1.00  0.00           H  
ATOM    136  HB3 ALA A  10       6.731   6.823   5.815  1.00  0.00           H  
ATOM    137  N   GLN A  11       3.763   5.954   5.881  1.00  0.00           N  
ATOM    138  CA  GLN A  11       3.014   5.251   6.909  1.00  0.00           C  
ATOM    139  C   GLN A  11       1.952   4.351   6.293  1.00  0.00           C  
ATOM    140  O   GLN A  11       1.802   3.200   6.693  1.00  0.00           O  
ATOM    141  CB  GLN A  11       2.376   6.251   7.872  1.00  0.00           C  
ATOM    142  CG  GLN A  11       1.381   5.610   8.812  1.00  0.00           C  
ATOM    143  CD  GLN A  11       0.648   6.618   9.668  1.00  0.00           C  
ATOM    144  OE1 GLN A  11       1.131   7.013  10.724  1.00  0.00           O  
ATOM    145  NE2 GLN A  11      -0.528   7.040   9.215  1.00  0.00           N  
ATOM    146  H   GLN A  11       3.514   6.871   5.661  1.00  0.00           H  
ATOM    147  HA  GLN A  11       3.702   4.630   7.460  1.00  0.00           H  
ATOM    148  HB2 GLN A  11       3.153   6.714   8.461  1.00  0.00           H  
ATOM    149  HB3 GLN A  11       1.864   7.009   7.299  1.00  0.00           H  
ATOM    150  HG2 GLN A  11       0.665   5.072   8.218  1.00  0.00           H  
ATOM    151  HG3 GLN A  11       1.906   4.917   9.456  1.00  0.00           H  
ATOM    152 HE21 GLN A  11      -0.849   6.679   8.363  1.00  0.00           H  
ATOM    153 HE22 GLN A  11      -1.024   7.691   9.748  1.00  0.00           H  
ATOM    154  N   ALA A  12       1.221   4.870   5.317  1.00  0.00           N  
ATOM    155  CA  ALA A  12       0.187   4.084   4.655  1.00  0.00           C  
ATOM    156  C   ALA A  12       0.754   2.739   4.225  1.00  0.00           C  
ATOM    157  O   ALA A  12       0.079   1.714   4.285  1.00  0.00           O  
ATOM    158  CB  ALA A  12      -0.350   4.830   3.454  1.00  0.00           C  
ATOM    159  H   ALA A  12       1.383   5.792   5.030  1.00  0.00           H  
ATOM    160  HA  ALA A  12      -0.621   3.924   5.353  1.00  0.00           H  
ATOM    161  HB1 ALA A  12      -0.201   5.891   3.595  1.00  0.00           H  
ATOM    162  HB2 ALA A  12      -1.403   4.625   3.339  1.00  0.00           H  
ATOM    163  HB3 ALA A  12       0.182   4.507   2.568  1.00  0.00           H  
ATOM    164  N   LYS A  13       2.013   2.767   3.808  1.00  0.00           N  
ATOM    165  CA  LYS A  13       2.716   1.564   3.374  1.00  0.00           C  
ATOM    166  C   LYS A  13       3.365   0.881   4.567  1.00  0.00           C  
ATOM    167  O   LYS A  13       3.101  -0.289   4.842  1.00  0.00           O  
ATOM    168  CB  LYS A  13       3.776   1.902   2.324  1.00  0.00           C  
ATOM    169  CG  LYS A  13       4.293   3.324   2.409  1.00  0.00           C  
ATOM    170  CD  LYS A  13       5.643   3.470   1.725  1.00  0.00           C  
ATOM    171  CE  LYS A  13       6.720   2.657   2.425  1.00  0.00           C  
ATOM    172  NZ  LYS A  13       7.752   3.526   3.055  1.00  0.00           N  
ATOM    173  H   LYS A  13       2.487   3.623   3.802  1.00  0.00           H  
ATOM    174  HA  LYS A  13       1.991   0.894   2.939  1.00  0.00           H  
ATOM    175  HB2 LYS A  13       4.613   1.230   2.441  1.00  0.00           H  
ATOM    176  HB3 LYS A  13       3.348   1.761   1.350  1.00  0.00           H  
ATOM    177  HG2 LYS A  13       3.581   3.977   1.924  1.00  0.00           H  
ATOM    178  HG3 LYS A  13       4.387   3.597   3.452  1.00  0.00           H  
ATOM    179  HD2 LYS A  13       5.557   3.130   0.705  1.00  0.00           H  
ATOM    180  HD3 LYS A  13       5.930   4.512   1.734  1.00  0.00           H  
ATOM    181  HE2 LYS A  13       6.256   2.052   3.191  1.00  0.00           H  
ATOM    182  HE3 LYS A  13       7.196   2.013   1.699  1.00  0.00           H  
ATOM    183  HZ1 LYS A  13       7.318   4.126   3.785  1.00  0.00           H  
ATOM    184  HZ2 LYS A  13       8.191   4.135   2.336  1.00  0.00           H  
ATOM    185  HZ3 LYS A  13       8.491   2.941   3.496  1.00  0.00           H  
ATOM    186  N   GLU A  14       4.201   1.628   5.291  1.00  0.00           N  
ATOM    187  CA  GLU A  14       4.868   1.099   6.475  1.00  0.00           C  
ATOM    188  C   GLU A  14       3.849   0.402   7.359  1.00  0.00           C  
ATOM    189  O   GLU A  14       4.125  -0.632   7.970  1.00  0.00           O  
ATOM    190  CB  GLU A  14       5.548   2.230   7.253  1.00  0.00           C  
ATOM    191  CG  GLU A  14       6.928   2.586   6.727  1.00  0.00           C  
ATOM    192  CD  GLU A  14       8.039   1.869   7.469  1.00  0.00           C  
ATOM    193  OE1 GLU A  14       7.830   0.705   7.868  1.00  0.00           O  
ATOM    194  OE2 GLU A  14       9.116   2.474   7.653  1.00  0.00           O  
ATOM    195  H   GLU A  14       4.357   2.559   5.032  1.00  0.00           H  
ATOM    196  HA  GLU A  14       5.611   0.384   6.155  1.00  0.00           H  
ATOM    197  HB2 GLU A  14       4.926   3.115   7.201  1.00  0.00           H  
ATOM    198  HB3 GLU A  14       5.646   1.932   8.286  1.00  0.00           H  
ATOM    199  HG2 GLU A  14       6.982   2.316   5.683  1.00  0.00           H  
ATOM    200  HG3 GLU A  14       7.075   3.652   6.830  1.00  0.00           H  
ATOM    201  N   ALA A  15       2.655   0.977   7.399  1.00  0.00           N  
ATOM    202  CA  ALA A  15       1.562   0.423   8.186  1.00  0.00           C  
ATOM    203  C   ALA A  15       0.832  -0.669   7.409  1.00  0.00           C  
ATOM    204  O   ALA A  15       0.358  -1.647   7.990  1.00  0.00           O  
ATOM    205  CB  ALA A  15       0.594   1.522   8.596  1.00  0.00           C  
ATOM    206  H   ALA A  15       2.507   1.801   6.874  1.00  0.00           H  
ATOM    207  HA  ALA A  15       1.983  -0.008   9.082  1.00  0.00           H  
ATOM    208  HB1 ALA A  15      -0.170   1.629   7.841  1.00  0.00           H  
ATOM    209  HB2 ALA A  15       1.131   2.453   8.699  1.00  0.00           H  
ATOM    210  HB3 ALA A  15       0.136   1.265   9.540  1.00  0.00           H  
ATOM    211  N   ALA A  16       0.745  -0.500   6.091  1.00  0.00           N  
ATOM    212  CA  ALA A  16       0.072  -1.475   5.238  1.00  0.00           C  
ATOM    213  C   ALA A  16       0.869  -2.772   5.149  1.00  0.00           C  
ATOM    214  O   ALA A  16       0.304  -3.841   4.923  1.00  0.00           O  
ATOM    215  CB  ALA A  16      -0.161  -0.902   3.847  1.00  0.00           C  
ATOM    216  H   ALA A  16       1.142   0.298   5.684  1.00  0.00           H  
ATOM    217  HA  ALA A  16      -0.892  -1.689   5.677  1.00  0.00           H  
ATOM    218  HB1 ALA A  16       0.728  -0.387   3.515  1.00  0.00           H  
ATOM    219  HB2 ALA A  16      -0.988  -0.211   3.876  1.00  0.00           H  
ATOM    220  HB3 ALA A  16      -0.387  -1.706   3.161  1.00  0.00           H  
ATOM    221  N   ILE A  17       2.183  -2.675   5.334  1.00  0.00           N  
ATOM    222  CA  ILE A  17       3.041  -3.851   5.277  1.00  0.00           C  
ATOM    223  C   ILE A  17       2.943  -4.640   6.574  1.00  0.00           C  
ATOM    224  O   ILE A  17       3.038  -5.867   6.576  1.00  0.00           O  
ATOM    225  CB  ILE A  17       4.514  -3.483   5.008  1.00  0.00           C  
ATOM    226  CG1 ILE A  17       5.029  -2.498   6.058  1.00  0.00           C  
ATOM    227  CG2 ILE A  17       4.666  -2.901   3.610  1.00  0.00           C  
ATOM    228  CD1 ILE A  17       6.479  -2.111   5.860  1.00  0.00           C  
ATOM    229  H   ILE A  17       2.579  -1.798   5.518  1.00  0.00           H  
ATOM    230  HA  ILE A  17       2.692  -4.474   4.466  1.00  0.00           H  
ATOM    231  HB  ILE A  17       5.100  -4.388   5.056  1.00  0.00           H  
ATOM    232 HG12 ILE A  17       4.439  -1.597   6.017  1.00  0.00           H  
ATOM    233 HG13 ILE A  17       4.933  -2.944   7.037  1.00  0.00           H  
ATOM    234 HG21 ILE A  17       5.713  -2.750   3.394  1.00  0.00           H  
ATOM    235 HG22 ILE A  17       4.148  -1.954   3.557  1.00  0.00           H  
ATOM    236 HG23 ILE A  17       4.244  -3.582   2.888  1.00  0.00           H  
ATOM    237 HD11 ILE A  17       6.709  -1.253   6.474  1.00  0.00           H  
ATOM    238 HD12 ILE A  17       6.646  -1.866   4.821  1.00  0.00           H  
ATOM    239 HD13 ILE A  17       7.113  -2.937   6.143  1.00  0.00           H  
ATOM    240  N   LYS A  18       2.736  -3.927   7.677  1.00  0.00           N  
ATOM    241  CA  LYS A  18       2.604  -4.565   8.981  1.00  0.00           C  
ATOM    242  C   LYS A  18       1.457  -5.568   8.960  1.00  0.00           C  
ATOM    243  O   LYS A  18       1.534  -6.631   9.574  1.00  0.00           O  
ATOM    244  CB  LYS A  18       2.367  -3.510  10.065  1.00  0.00           C  
ATOM    245  CG  LYS A  18       3.511  -3.396  11.062  1.00  0.00           C  
ATOM    246  CD  LYS A  18       3.024  -3.553  12.494  1.00  0.00           C  
ATOM    247  CE  LYS A  18       3.691  -2.550  13.424  1.00  0.00           C  
ATOM    248  NZ  LYS A  18       2.800  -1.402  13.731  1.00  0.00           N  
ATOM    249  H   LYS A  18       2.657  -2.951   7.611  1.00  0.00           H  
ATOM    250  HA  LYS A  18       3.521  -5.093   9.192  1.00  0.00           H  
ATOM    251  HB2 LYS A  18       2.237  -2.548   9.590  1.00  0.00           H  
ATOM    252  HB3 LYS A  18       1.466  -3.758  10.608  1.00  0.00           H  
ATOM    253  HG2 LYS A  18       4.236  -4.170  10.853  1.00  0.00           H  
ATOM    254  HG3 LYS A  18       3.976  -2.426  10.952  1.00  0.00           H  
ATOM    255  HD2 LYS A  18       1.956  -3.395  12.520  1.00  0.00           H  
ATOM    256  HD3 LYS A  18       3.251  -4.552  12.834  1.00  0.00           H  
ATOM    257  HE2 LYS A  18       3.952  -3.052  14.344  1.00  0.00           H  
ATOM    258  HE3 LYS A  18       4.588  -2.181  12.950  1.00  0.00           H  
ATOM    259  HZ1 LYS A  18       2.083  -1.291  12.988  1.00  0.00           H  
ATOM    260  HZ2 LYS A  18       3.356  -0.527  13.793  1.00  0.00           H  
ATOM    261  HZ3 LYS A  18       2.316  -1.561  14.642  1.00  0.00           H  
ATOM    262  N   GLU A  19       0.398  -5.226   8.231  1.00  0.00           N  
ATOM    263  CA  GLU A  19      -0.756  -6.105   8.110  1.00  0.00           C  
ATOM    264  C   GLU A  19      -0.400  -7.312   7.258  1.00  0.00           C  
ATOM    265  O   GLU A  19      -0.810  -8.433   7.549  1.00  0.00           O  
ATOM    266  CB  GLU A  19      -1.943  -5.357   7.499  1.00  0.00           C  
ATOM    267  CG  GLU A  19      -3.068  -5.094   8.488  1.00  0.00           C  
ATOM    268  CD  GLU A  19      -2.718  -4.016   9.494  1.00  0.00           C  
ATOM    269  OE1 GLU A  19      -1.974  -4.317  10.451  1.00  0.00           O  
ATOM    270  OE2 GLU A  19      -3.189  -2.871   9.327  1.00  0.00           O  
ATOM    271  H   GLU A  19       0.402  -4.369   7.753  1.00  0.00           H  
ATOM    272  HA  GLU A  19      -1.019  -6.448   9.099  1.00  0.00           H  
ATOM    273  HB2 GLU A  19      -1.598  -4.408   7.118  1.00  0.00           H  
ATOM    274  HB3 GLU A  19      -2.343  -5.941   6.680  1.00  0.00           H  
ATOM    275  HG2 GLU A  19      -3.946  -4.782   7.941  1.00  0.00           H  
ATOM    276  HG3 GLU A  19      -3.283  -6.008   9.020  1.00  0.00           H  
ATOM    277  N   LEU A  20       0.381  -7.075   6.209  1.00  0.00           N  
ATOM    278  CA  LEU A  20       0.806  -8.147   5.328  1.00  0.00           C  
ATOM    279  C   LEU A  20       1.638  -9.162   6.104  1.00  0.00           C  
ATOM    280  O   LEU A  20       1.605 -10.359   5.819  1.00  0.00           O  
ATOM    281  CB  LEU A  20       1.612  -7.592   4.155  1.00  0.00           C  
ATOM    282  CG  LEU A  20       1.069  -7.966   2.777  1.00  0.00           C  
ATOM    283  CD1 LEU A  20       0.431  -6.762   2.100  1.00  0.00           C  
ATOM    284  CD2 LEU A  20       2.166  -8.556   1.906  1.00  0.00           C  
ATOM    285  H   LEU A  20       0.687  -6.161   6.036  1.00  0.00           H  
ATOM    286  HA  LEU A  20      -0.080  -8.635   4.948  1.00  0.00           H  
ATOM    287  HB2 LEU A  20       1.631  -6.513   4.235  1.00  0.00           H  
ATOM    288  HB3 LEU A  20       2.622  -7.959   4.235  1.00  0.00           H  
ATOM    289  HG  LEU A  20       0.309  -8.716   2.901  1.00  0.00           H  
ATOM    290 HD11 LEU A  20       0.834  -5.856   2.524  1.00  0.00           H  
ATOM    291 HD12 LEU A  20      -0.638  -6.789   2.254  1.00  0.00           H  
ATOM    292 HD13 LEU A  20       0.641  -6.789   1.041  1.00  0.00           H  
ATOM    293 HD21 LEU A  20       2.868  -9.094   2.527  1.00  0.00           H  
ATOM    294 HD22 LEU A  20       2.679  -7.761   1.386  1.00  0.00           H  
ATOM    295 HD23 LEU A  20       1.730  -9.234   1.187  1.00  0.00           H  
ATOM    296  N   LYS A  21       2.370  -8.668   7.098  1.00  0.00           N  
ATOM    297  CA  LYS A  21       3.201  -9.523   7.933  1.00  0.00           C  
ATOM    298  C   LYS A  21       2.352 -10.186   9.010  1.00  0.00           C  
ATOM    299  O   LYS A  21       2.557 -11.352   9.347  1.00  0.00           O  
ATOM    300  CB  LYS A  21       4.327  -8.711   8.578  1.00  0.00           C  
ATOM    301  CG  LYS A  21       5.383  -9.570   9.256  1.00  0.00           C  
ATOM    302  CD  LYS A  21       5.753  -9.026  10.626  1.00  0.00           C  
ATOM    303  CE  LYS A  21       5.056  -9.790  11.739  1.00  0.00           C  
ATOM    304  NZ  LYS A  21       6.016 -10.579  12.558  1.00  0.00           N  
ATOM    305  H   LYS A  21       2.343  -7.706   7.280  1.00  0.00           H  
ATOM    306  HA  LYS A  21       3.631 -10.289   7.304  1.00  0.00           H  
ATOM    307  HB2 LYS A  21       4.809  -8.120   7.814  1.00  0.00           H  
ATOM    308  HB3 LYS A  21       3.900  -8.051   9.317  1.00  0.00           H  
ATOM    309  HG2 LYS A  21       4.999 -10.573   9.369  1.00  0.00           H  
ATOM    310  HG3 LYS A  21       6.268  -9.591   8.635  1.00  0.00           H  
ATOM    311  HD2 LYS A  21       6.821  -9.109  10.761  1.00  0.00           H  
ATOM    312  HD3 LYS A  21       5.463  -7.986  10.679  1.00  0.00           H  
ATOM    313  HE2 LYS A  21       4.546  -9.086  12.379  1.00  0.00           H  
ATOM    314  HE3 LYS A  21       4.333 -10.464  11.300  1.00  0.00           H  
ATOM    315  HZ1 LYS A  21       5.538 -11.400  12.981  1.00  0.00           H  
ATOM    316  HZ2 LYS A  21       6.405  -9.989  13.321  1.00  0.00           H  
ATOM    317  HZ3 LYS A  21       6.800 -10.918  11.963  1.00  0.00           H  
ATOM    318  N   GLN A  22       1.388  -9.435   9.536  1.00  0.00           N  
ATOM    319  CA  GLN A  22       0.496  -9.953  10.565  1.00  0.00           C  
ATOM    320  C   GLN A  22      -0.508 -10.926   9.955  1.00  0.00           C  
ATOM    321  O   GLN A  22      -0.981 -11.848  10.621  1.00  0.00           O  
ATOM    322  CB  GLN A  22      -0.242  -8.804  11.258  1.00  0.00           C  
ATOM    323  CG  GLN A  22      -0.459  -9.030  12.746  1.00  0.00           C  
ATOM    324  CD  GLN A  22       0.740  -8.622  13.580  1.00  0.00           C  
ATOM    325  OE1 GLN A  22       1.629  -9.432  13.846  1.00  0.00           O  
ATOM    326  NE2 GLN A  22       0.769  -7.363  13.996  1.00  0.00           N  
ATOM    327  H   GLN A  22       1.269  -8.513   9.216  1.00  0.00           H  
ATOM    328  HA  GLN A  22       1.096 -10.478  11.294  1.00  0.00           H  
ATOM    329  HB2 GLN A  22       0.330  -7.897  11.134  1.00  0.00           H  
ATOM    330  HB3 GLN A  22      -1.207  -8.678  10.790  1.00  0.00           H  
ATOM    331  HG2 GLN A  22      -1.313  -8.451  13.063  1.00  0.00           H  
ATOM    332  HG3 GLN A  22      -0.656 -10.080  12.912  1.00  0.00           H  
ATOM    333 HE21 GLN A  22       0.027  -6.775  13.746  1.00  0.00           H  
ATOM    334 HE22 GLN A  22       1.533  -7.072  14.537  1.00  0.00           H  
ATOM    335  N   TYR A  23      -0.822 -10.716   8.681  1.00  0.00           N  
ATOM    336  CA  TYR A  23      -1.763 -11.572   7.967  1.00  0.00           C  
ATOM    337  C   TYR A  23      -1.072 -12.836   7.478  1.00  0.00           C  
ATOM    338  O   TYR A  23      -1.630 -13.932   7.551  1.00  0.00           O  
ATOM    339  CB  TYR A  23      -2.360 -10.827   6.774  1.00  0.00           C  
ATOM    340  CG  TYR A  23      -3.596 -10.030   7.111  1.00  0.00           C  
ATOM    341  CD1 TYR A  23      -4.726 -10.649   7.622  1.00  0.00           C  
ATOM    342  CD2 TYR A  23      -3.631  -8.658   6.911  1.00  0.00           C  
ATOM    343  CE1 TYR A  23      -5.860  -9.924   7.928  1.00  0.00           C  
ATOM    344  CE2 TYR A  23      -4.758  -7.924   7.214  1.00  0.00           C  
ATOM    345  CZ  TYR A  23      -5.872  -8.560   7.722  1.00  0.00           C  
ATOM    346  OH  TYR A  23      -6.999  -7.831   8.025  1.00  0.00           O  
ATOM    347  H   TYR A  23      -0.407  -9.967   8.204  1.00  0.00           H  
ATOM    348  HA  TYR A  23      -2.555 -11.843   8.649  1.00  0.00           H  
ATOM    349  HB2 TYR A  23      -1.624 -10.140   6.379  1.00  0.00           H  
ATOM    350  HB3 TYR A  23      -2.627 -11.544   6.008  1.00  0.00           H  
ATOM    351  HD1 TYR A  23      -4.713 -11.719   7.783  1.00  0.00           H  
ATOM    352  HD2 TYR A  23      -2.758  -8.163   6.513  1.00  0.00           H  
ATOM    353  HE1 TYR A  23      -6.729 -10.425   8.325  1.00  0.00           H  
ATOM    354  HE2 TYR A  23      -4.765  -6.859   7.050  1.00  0.00           H  
ATOM    355  HH  TYR A  23      -7.732  -8.139   7.487  1.00  0.00           H  
ATOM    356  N   GLY A  24       0.143 -12.672   6.969  1.00  0.00           N  
ATOM    357  CA  GLY A  24       0.891 -13.803   6.464  1.00  0.00           C  
ATOM    358  C   GLY A  24       1.092 -13.748   4.961  1.00  0.00           C  
ATOM    359  O   GLY A  24       1.815 -14.570   4.400  1.00  0.00           O  
ATOM    360  H   GLY A  24       0.533 -11.772   6.934  1.00  0.00           H  
ATOM    361  HA2 GLY A  24       1.859 -13.822   6.943  1.00  0.00           H  
ATOM    362  HA3 GLY A  24       0.362 -14.711   6.712  1.00  0.00           H  
ATOM    363  N   ILE A  25       0.451 -12.782   4.296  1.00  0.00           N  
ATOM    364  CA  ILE A  25       0.584 -12.651   2.842  1.00  0.00           C  
ATOM    365  C   ILE A  25       2.056 -12.678   2.426  1.00  0.00           C  
ATOM    366  O   ILE A  25       2.947 -12.660   3.276  1.00  0.00           O  
ATOM    367  CB  ILE A  25      -0.067 -11.356   2.282  1.00  0.00           C  
ATOM    368  CG1 ILE A  25      -1.056 -10.731   3.269  1.00  0.00           C  
ATOM    369  CG2 ILE A  25      -0.772 -11.654   0.968  1.00  0.00           C  
ATOM    370  CD1 ILE A  25      -1.847  -9.584   2.669  1.00  0.00           C  
ATOM    371  H   ILE A  25      -0.119 -12.151   4.792  1.00  0.00           H  
ATOM    372  HA  ILE A  25       0.085 -13.498   2.393  1.00  0.00           H  
ATOM    373  HB  ILE A  25       0.722 -10.647   2.080  1.00  0.00           H  
ATOM    374 HG12 ILE A  25      -1.759 -11.484   3.595  1.00  0.00           H  
ATOM    375 HG13 ILE A  25      -0.516 -10.353   4.123  1.00  0.00           H  
ATOM    376 HG21 ILE A  25      -0.427 -10.964   0.218  1.00  0.00           H  
ATOM    377 HG22 ILE A  25      -1.840 -11.538   1.101  1.00  0.00           H  
ATOM    378 HG23 ILE A  25      -0.552 -12.665   0.660  1.00  0.00           H  
ATOM    379 HD11 ILE A  25      -2.731  -9.970   2.187  1.00  0.00           H  
ATOM    380 HD12 ILE A  25      -1.237  -9.070   1.937  1.00  0.00           H  
ATOM    381 HD13 ILE A  25      -2.132  -8.894   3.449  1.00  0.00           H  
ATOM    382  N   GLY A  26       2.311 -12.726   1.117  1.00  0.00           N  
ATOM    383  CA  GLY A  26       3.679 -12.760   0.633  1.00  0.00           C  
ATOM    384  C   GLY A  26       4.340 -11.397   0.654  1.00  0.00           C  
ATOM    385  O   GLY A  26       3.671 -10.373   0.521  1.00  0.00           O  
ATOM    386  H   GLY A  26       1.569 -12.740   0.479  1.00  0.00           H  
ATOM    387  HA2 GLY A  26       4.252 -13.435   1.254  1.00  0.00           H  
ATOM    388  HA3 GLY A  26       3.679 -13.132  -0.382  1.00  0.00           H  
ATOM    389  N   ASP A  27       5.660 -11.384   0.823  1.00  0.00           N  
ATOM    390  CA  ASP A  27       6.412 -10.136   0.860  1.00  0.00           C  
ATOM    391  C   ASP A  27       6.284  -9.378  -0.454  1.00  0.00           C  
ATOM    392  O   ASP A  27       6.453  -8.161  -0.495  1.00  0.00           O  
ATOM    393  CB  ASP A  27       7.887 -10.412   1.165  1.00  0.00           C  
ATOM    394  CG  ASP A  27       8.200 -10.316   2.646  1.00  0.00           C  
ATOM    395  OD1 ASP A  27       7.543 -11.025   3.438  1.00  0.00           O  
ATOM    396  OD2 ASP A  27       9.101  -9.533   3.013  1.00  0.00           O  
ATOM    397  H   ASP A  27       6.136 -12.234   0.922  1.00  0.00           H  
ATOM    398  HA  ASP A  27       5.998  -9.523   1.647  1.00  0.00           H  
ATOM    399  HB2 ASP A  27       8.138 -11.405   0.828  1.00  0.00           H  
ATOM    400  HB3 ASP A  27       8.497  -9.691   0.640  1.00  0.00           H  
ATOM    401  N   TYR A  28       5.967 -10.098  -1.528  1.00  0.00           N  
ATOM    402  CA  TYR A  28       5.799  -9.473  -2.838  1.00  0.00           C  
ATOM    403  C   TYR A  28       4.943  -8.224  -2.721  1.00  0.00           C  
ATOM    404  O   TYR A  28       5.270  -7.164  -3.255  1.00  0.00           O  
ATOM    405  CB  TYR A  28       5.114 -10.435  -3.809  1.00  0.00           C  
ATOM    406  CG  TYR A  28       5.591 -10.257  -5.227  1.00  0.00           C  
ATOM    407  CD1 TYR A  28       6.936 -10.372  -5.541  1.00  0.00           C  
ATOM    408  CD2 TYR A  28       4.700  -9.952  -6.245  1.00  0.00           C  
ATOM    409  CE1 TYR A  28       7.383 -10.191  -6.831  1.00  0.00           C  
ATOM    410  CE2 TYR A  28       5.138  -9.769  -7.541  1.00  0.00           C  
ATOM    411  CZ  TYR A  28       6.480  -9.890  -7.830  1.00  0.00           C  
ATOM    412  OH  TYR A  28       6.923  -9.707  -9.121  1.00  0.00           O  
ATOM    413  H   TYR A  28       5.832 -11.066  -1.437  1.00  0.00           H  
ATOM    414  HA  TYR A  28       6.775  -9.208  -3.227  1.00  0.00           H  
ATOM    415  HB2 TYR A  28       5.306 -11.454  -3.509  1.00  0.00           H  
ATOM    416  HB3 TYR A  28       4.048 -10.253  -3.793  1.00  0.00           H  
ATOM    417  HD1 TYR A  28       7.640 -10.608  -4.756  1.00  0.00           H  
ATOM    418  HD2 TYR A  28       3.650  -9.859  -6.015  1.00  0.00           H  
ATOM    419  HE1 TYR A  28       8.433 -10.284  -7.051  1.00  0.00           H  
ATOM    420  HE2 TYR A  28       4.429  -9.529  -8.318  1.00  0.00           H  
ATOM    421  HH  TYR A  28       6.449  -8.974  -9.521  1.00  0.00           H  
ATOM    422  N   TYR A  29       3.826  -8.390  -2.036  1.00  0.00           N  
ATOM    423  CA  TYR A  29       2.857  -7.319  -1.842  1.00  0.00           C  
ATOM    424  C   TYR A  29       3.323  -6.275  -0.826  1.00  0.00           C  
ATOM    425  O   TYR A  29       2.892  -5.127  -0.870  1.00  0.00           O  
ATOM    426  CB  TYR A  29       1.505  -7.932  -1.484  1.00  0.00           C  
ATOM    427  CG  TYR A  29       1.161  -9.069  -2.426  1.00  0.00           C  
ATOM    428  CD1 TYR A  29       1.661  -9.084  -3.728  1.00  0.00           C  
ATOM    429  CD2 TYR A  29       0.373 -10.133  -2.017  1.00  0.00           C  
ATOM    430  CE1 TYR A  29       1.377 -10.127  -4.588  1.00  0.00           C  
ATOM    431  CE2 TYR A  29       0.088 -11.182  -2.871  1.00  0.00           C  
ATOM    432  CZ  TYR A  29       0.593 -11.174  -4.154  1.00  0.00           C  
ATOM    433  OH  TYR A  29       0.309 -12.217  -5.007  1.00  0.00           O  
ATOM    434  H   TYR A  29       3.632  -9.280  -1.668  1.00  0.00           H  
ATOM    435  HA  TYR A  29       2.755  -6.825  -2.798  1.00  0.00           H  
ATOM    436  HB2 TYR A  29       1.534  -8.315  -0.475  1.00  0.00           H  
ATOM    437  HB3 TYR A  29       0.733  -7.186  -1.559  1.00  0.00           H  
ATOM    438  HD1 TYR A  29       2.277  -8.254  -4.071  1.00  0.00           H  
ATOM    439  HD2 TYR A  29      -0.019 -10.136  -1.016  1.00  0.00           H  
ATOM    440  HE1 TYR A  29       1.778 -10.126  -5.589  1.00  0.00           H  
ATOM    441  HE2 TYR A  29      -0.527 -12.002  -2.532  1.00  0.00           H  
ATOM    442  HH  TYR A  29      -0.514 -12.039  -5.468  1.00  0.00           H  
ATOM    443  N   ILE A  30       4.231  -6.641   0.064  1.00  0.00           N  
ATOM    444  CA  ILE A  30       4.750  -5.664   1.011  1.00  0.00           C  
ATOM    445  C   ILE A  30       5.705  -4.741   0.257  1.00  0.00           C  
ATOM    446  O   ILE A  30       5.809  -3.546   0.543  1.00  0.00           O  
ATOM    447  CB  ILE A  30       5.473  -6.308   2.226  1.00  0.00           C  
ATOM    448  CG1 ILE A  30       6.978  -6.436   1.986  1.00  0.00           C  
ATOM    449  CG2 ILE A  30       4.876  -7.658   2.582  1.00  0.00           C  
ATOM    450  CD1 ILE A  30       7.729  -5.161   2.293  1.00  0.00           C  
ATOM    451  H   ILE A  30       4.585  -7.552   0.059  1.00  0.00           H  
ATOM    452  HA  ILE A  30       3.914  -5.076   1.376  1.00  0.00           H  
ATOM    453  HB  ILE A  30       5.317  -5.661   3.065  1.00  0.00           H  
ATOM    454 HG12 ILE A  30       7.375  -7.216   2.616  1.00  0.00           H  
ATOM    455 HG13 ILE A  30       7.155  -6.686   0.952  1.00  0.00           H  
ATOM    456 HG21 ILE A  30       3.998  -7.509   3.190  1.00  0.00           H  
ATOM    457 HG22 ILE A  30       5.602  -8.235   3.137  1.00  0.00           H  
ATOM    458 HG23 ILE A  30       4.607  -8.190   1.684  1.00  0.00           H  
ATOM    459 HD11 ILE A  30       8.226  -5.255   3.246  1.00  0.00           H  
ATOM    460 HD12 ILE A  30       7.026  -4.339   2.332  1.00  0.00           H  
ATOM    461 HD13 ILE A  30       8.459  -4.975   1.520  1.00  0.00           H  
ATOM    462  N   LYS A  31       6.388  -5.327  -0.725  1.00  0.00           N  
ATOM    463  CA  LYS A  31       7.337  -4.609  -1.563  1.00  0.00           C  
ATOM    464  C   LYS A  31       6.619  -3.835  -2.659  1.00  0.00           C  
ATOM    465  O   LYS A  31       6.864  -2.644  -2.855  1.00  0.00           O  
ATOM    466  CB  LYS A  31       8.313  -5.590  -2.206  1.00  0.00           C  
ATOM    467  CG  LYS A  31       9.053  -6.469  -1.211  1.00  0.00           C  
ATOM    468  CD  LYS A  31      10.026  -5.661  -0.367  1.00  0.00           C  
ATOM    469  CE  LYS A  31      10.400  -6.398   0.909  1.00  0.00           C  
ATOM    470  NZ  LYS A  31      11.179  -5.537   1.840  1.00  0.00           N  
ATOM    471  H   LYS A  31       6.241  -6.280  -0.892  1.00  0.00           H  
ATOM    472  HA  LYS A  31       7.882  -3.917  -0.943  1.00  0.00           H  
ATOM    473  HB2 LYS A  31       7.758  -6.230  -2.877  1.00  0.00           H  
ATOM    474  HB3 LYS A  31       9.042  -5.033  -2.777  1.00  0.00           H  
ATOM    475  HG2 LYS A  31       8.335  -6.941  -0.560  1.00  0.00           H  
ATOM    476  HG3 LYS A  31       9.602  -7.225  -1.753  1.00  0.00           H  
ATOM    477  HD2 LYS A  31      10.922  -5.481  -0.942  1.00  0.00           H  
ATOM    478  HD3 LYS A  31       9.567  -4.720  -0.107  1.00  0.00           H  
ATOM    479  HE2 LYS A  31       9.495  -6.721   1.402  1.00  0.00           H  
ATOM    480  HE3 LYS A  31      10.996  -7.263   0.649  1.00  0.00           H  
ATOM    481  HZ1 LYS A  31      10.926  -4.537   1.697  1.00  0.00           H  
ATOM    482  HZ2 LYS A  31      12.197  -5.653   1.668  1.00  0.00           H  
ATOM    483  HZ3 LYS A  31      10.972  -5.798   2.826  1.00  0.00           H  
ATOM    484  N   LEU A  32       5.726  -4.520  -3.375  1.00  0.00           N  
ATOM    485  CA  LEU A  32       4.970  -3.893  -4.453  1.00  0.00           C  
ATOM    486  C   LEU A  32       4.319  -2.588  -3.965  1.00  0.00           C  
ATOM    487  O   LEU A  32       3.979  -1.713  -4.764  1.00  0.00           O  
ATOM    488  CB  LEU A  32       3.947  -4.898  -5.034  1.00  0.00           C  
ATOM    489  CG  LEU A  32       2.490  -4.670  -4.660  1.00  0.00           C  
ATOM    490  CD1 LEU A  32       2.400  -4.437  -3.178  1.00  0.00           C  
ATOM    491  CD2 LEU A  32       1.906  -3.503  -5.439  1.00  0.00           C  
ATOM    492  H   LEU A  32       5.573  -5.466  -3.172  1.00  0.00           H  
ATOM    493  HA  LEU A  32       5.669  -3.642  -5.219  1.00  0.00           H  
ATOM    494  HB2 LEU A  32       4.018  -4.883  -6.106  1.00  0.00           H  
ATOM    495  HB3 LEU A  32       4.224  -5.884  -4.690  1.00  0.00           H  
ATOM    496  HG  LEU A  32       1.919  -5.557  -4.895  1.00  0.00           H  
ATOM    497 HD11 LEU A  32       2.059  -3.430  -2.989  1.00  0.00           H  
ATOM    498 HD12 LEU A  32       3.392  -4.567  -2.754  1.00  0.00           H  
ATOM    499 HD13 LEU A  32       1.718  -5.144  -2.737  1.00  0.00           H  
ATOM    500 HD21 LEU A  32       1.949  -2.611  -4.833  1.00  0.00           H  
ATOM    501 HD22 LEU A  32       0.878  -3.717  -5.693  1.00  0.00           H  
ATOM    502 HD23 LEU A  32       2.477  -3.352  -6.342  1.00  0.00           H  
ATOM    503  N   ILE A  33       4.177  -2.461  -2.641  1.00  0.00           N  
ATOM    504  CA  ILE A  33       3.601  -1.273  -2.025  1.00  0.00           C  
ATOM    505  C   ILE A  33       4.619  -0.137  -2.026  1.00  0.00           C  
ATOM    506  O   ILE A  33       4.363   0.943  -2.558  1.00  0.00           O  
ATOM    507  CB  ILE A  33       3.149  -1.584  -0.573  1.00  0.00           C  
ATOM    508  CG1 ILE A  33       1.779  -2.269  -0.596  1.00  0.00           C  
ATOM    509  CG2 ILE A  33       3.115  -0.327   0.295  1.00  0.00           C  
ATOM    510  CD1 ILE A  33       1.132  -2.414   0.766  1.00  0.00           C  
ATOM    511  H   ILE A  33       4.479  -3.187  -2.058  1.00  0.00           H  
ATOM    512  HA  ILE A  33       2.736  -0.974  -2.597  1.00  0.00           H  
ATOM    513  HB  ILE A  33       3.867  -2.262  -0.139  1.00  0.00           H  
ATOM    514 HG12 ILE A  33       1.110  -1.695  -1.218  1.00  0.00           H  
ATOM    515 HG13 ILE A  33       1.891  -3.257  -1.015  1.00  0.00           H  
ATOM    516 HG21 ILE A  33       3.381   0.534  -0.297  1.00  0.00           H  
ATOM    517 HG22 ILE A  33       3.817  -0.433   1.108  1.00  0.00           H  
ATOM    518 HG23 ILE A  33       2.121  -0.191   0.696  1.00  0.00           H  
ATOM    519 HD11 ILE A  33       1.718  -1.889   1.505  1.00  0.00           H  
ATOM    520 HD12 ILE A  33       1.077  -3.460   1.026  1.00  0.00           H  
ATOM    521 HD13 ILE A  33       0.137  -1.997   0.733  1.00  0.00           H  
ATOM    522  N   ASN A  34       5.776  -0.391  -1.425  1.00  0.00           N  
ATOM    523  CA  ASN A  34       6.840   0.602  -1.350  1.00  0.00           C  
ATOM    524  C   ASN A  34       7.182   1.166  -2.730  1.00  0.00           C  
ATOM    525  O   ASN A  34       7.725   2.265  -2.841  1.00  0.00           O  
ATOM    526  CB  ASN A  34       8.088  -0.018  -0.720  1.00  0.00           C  
ATOM    527  CG  ASN A  34       8.849   0.968   0.146  1.00  0.00           C  
ATOM    528  OD1 ASN A  34       9.023   0.752   1.345  1.00  0.00           O  
ATOM    529  ND2 ASN A  34       9.305   2.058  -0.459  1.00  0.00           N  
ATOM    530  H   ASN A  34       5.916  -1.275  -1.018  1.00  0.00           H  
ATOM    531  HA  ASN A  34       6.496   1.408  -0.721  1.00  0.00           H  
ATOM    532  HB2 ASN A  34       7.794  -0.856  -0.106  1.00  0.00           H  
ATOM    533  HB3 ASN A  34       8.746  -0.364  -1.504  1.00  0.00           H  
ATOM    534 HD21 ASN A  34       9.128   2.165  -1.417  1.00  0.00           H  
ATOM    535 HD22 ASN A  34       9.801   2.711   0.078  1.00  0.00           H  
ATOM    536  N   ASN A  35       6.872   0.407  -3.778  1.00  0.00           N  
ATOM    537  CA  ASN A  35       7.159   0.835  -5.144  1.00  0.00           C  
ATOM    538  C   ASN A  35       6.243   1.976  -5.588  1.00  0.00           C  
ATOM    539  O   ASN A  35       6.565   2.708  -6.523  1.00  0.00           O  
ATOM    540  CB  ASN A  35       7.017  -0.346  -6.108  1.00  0.00           C  
ATOM    541  CG  ASN A  35       7.704  -0.094  -7.435  1.00  0.00           C  
ATOM    542  OD1 ASN A  35       7.115   0.473  -8.355  1.00  0.00           O  
ATOM    543  ND2 ASN A  35       8.957  -0.518  -7.542  1.00  0.00           N  
ATOM    544  H   ASN A  35       6.446  -0.463  -3.631  1.00  0.00           H  
ATOM    545  HA  ASN A  35       8.181   1.183  -5.172  1.00  0.00           H  
ATOM    546  HB2 ASN A  35       7.455  -1.224  -5.658  1.00  0.00           H  
ATOM    547  HB3 ASN A  35       5.969  -0.525  -6.293  1.00  0.00           H  
ATOM    548 HD21 ASN A  35       9.364  -0.963  -6.769  1.00  0.00           H  
ATOM    549 HD22 ASN A  35       9.426  -0.368  -8.390  1.00  0.00           H  
ATOM    550  N   ALA A  36       5.101   2.120  -4.923  1.00  0.00           N  
ATOM    551  CA  ALA A  36       4.148   3.170  -5.268  1.00  0.00           C  
ATOM    552  C   ALA A  36       4.739   4.558  -5.055  1.00  0.00           C  
ATOM    553  O   ALA A  36       5.638   4.747  -4.236  1.00  0.00           O  
ATOM    554  CB  ALA A  36       2.867   3.010  -4.468  1.00  0.00           C  
ATOM    555  H   ALA A  36       4.891   1.505  -4.189  1.00  0.00           H  
ATOM    556  HA  ALA A  36       3.900   3.063  -6.312  1.00  0.00           H  
ATOM    557  HB1 ALA A  36       3.045   2.351  -3.632  1.00  0.00           H  
ATOM    558  HB2 ALA A  36       2.098   2.591  -5.100  1.00  0.00           H  
ATOM    559  HB3 ALA A  36       2.545   3.977  -4.104  1.00  0.00           H  
ATOM    560  N   LYS A  37       4.223   5.524  -5.806  1.00  0.00           N  
ATOM    561  CA  LYS A  37       4.685   6.902  -5.716  1.00  0.00           C  
ATOM    562  C   LYS A  37       3.764   7.726  -4.820  1.00  0.00           C  
ATOM    563  O   LYS A  37       4.219   8.575  -4.056  1.00  0.00           O  
ATOM    564  CB  LYS A  37       4.749   7.517  -7.109  1.00  0.00           C  
ATOM    565  CG  LYS A  37       6.047   7.222  -7.844  1.00  0.00           C  
ATOM    566  CD  LYS A  37       5.794   6.692  -9.246  1.00  0.00           C  
ATOM    567  CE  LYS A  37       4.966   5.418  -9.217  1.00  0.00           C  
ATOM    568  NZ  LYS A  37       5.780   4.219  -9.556  1.00  0.00           N  
ATOM    569  H   LYS A  37       3.509   5.304  -6.441  1.00  0.00           H  
ATOM    570  HA  LYS A  37       5.673   6.889  -5.285  1.00  0.00           H  
ATOM    571  HB2 LYS A  37       3.933   7.136  -7.702  1.00  0.00           H  
ATOM    572  HB3 LYS A  37       4.646   8.588  -7.018  1.00  0.00           H  
ATOM    573  HG2 LYS A  37       6.621   8.134  -7.919  1.00  0.00           H  
ATOM    574  HG3 LYS A  37       6.610   6.490  -7.286  1.00  0.00           H  
ATOM    575  HD2 LYS A  37       5.259   7.437  -9.813  1.00  0.00           H  
ATOM    576  HD3 LYS A  37       6.740   6.482  -9.721  1.00  0.00           H  
ATOM    577  HE2 LYS A  37       4.555   5.293  -8.227  1.00  0.00           H  
ATOM    578  HE3 LYS A  37       4.163   5.511  -9.933  1.00  0.00           H  
ATOM    579  HZ1 LYS A  37       5.197   3.522 -10.063  1.00  0.00           H  
ATOM    580  HZ2 LYS A  37       6.149   3.778  -8.688  1.00  0.00           H  
ATOM    581  HZ3 LYS A  37       6.582   4.490 -10.161  1.00  0.00           H  
ATOM    582  N   THR A  38       2.466   7.456  -4.917  1.00  0.00           N  
ATOM    583  CA  THR A  38       1.472   8.157  -4.111  1.00  0.00           C  
ATOM    584  C   THR A  38       1.206   7.376  -2.827  1.00  0.00           C  
ATOM    585  O   THR A  38       2.077   6.644  -2.360  1.00  0.00           O  
ATOM    586  CB  THR A  38       0.178   8.338  -4.911  1.00  0.00           C  
ATOM    587  OG1 THR A  38      -0.534   7.118  -4.998  1.00  0.00           O  
ATOM    588  CG2 THR A  38       0.412   8.833  -6.322  1.00  0.00           C  
ATOM    589  H   THR A  38       2.170   6.761  -5.537  1.00  0.00           H  
ATOM    590  HA  THR A  38       1.873   9.127  -3.856  1.00  0.00           H  
ATOM    591  HB  THR A  38      -0.446   9.061  -4.406  1.00  0.00           H  
ATOM    592  HG1 THR A  38      -1.198   7.085  -4.306  1.00  0.00           H  
ATOM    593 HG21 THR A  38      -0.515   8.793  -6.875  1.00  0.00           H  
ATOM    594 HG22 THR A  38       1.148   8.209  -6.806  1.00  0.00           H  
ATOM    595 HG23 THR A  38       0.769   9.853  -6.293  1.00  0.00           H  
ATOM    596  N   VAL A  39       0.010   7.517  -2.256  1.00  0.00           N  
ATOM    597  CA  VAL A  39      -0.315   6.793  -1.035  1.00  0.00           C  
ATOM    598  C   VAL A  39      -1.723   6.201  -1.063  1.00  0.00           C  
ATOM    599  O   VAL A  39      -1.930   5.068  -0.628  1.00  0.00           O  
ATOM    600  CB  VAL A  39      -0.141   7.665   0.220  1.00  0.00           C  
ATOM    601  CG1 VAL A  39      -1.411   8.409   0.572  1.00  0.00           C  
ATOM    602  CG2 VAL A  39       0.292   6.790   1.373  1.00  0.00           C  
ATOM    603  H   VAL A  39      -0.658   8.107  -2.664  1.00  0.00           H  
ATOM    604  HA  VAL A  39       0.383   5.983  -0.950  1.00  0.00           H  
ATOM    605  HB  VAL A  39       0.635   8.389   0.034  1.00  0.00           H  
ATOM    606 HG11 VAL A  39      -1.209   9.084   1.391  1.00  0.00           H  
ATOM    607 HG12 VAL A  39      -2.167   7.699   0.867  1.00  0.00           H  
ATOM    608 HG13 VAL A  39      -1.750   8.967  -0.285  1.00  0.00           H  
ATOM    609 HG21 VAL A  39       0.074   7.286   2.305  1.00  0.00           H  
ATOM    610 HG22 VAL A  39       1.353   6.597   1.301  1.00  0.00           H  
ATOM    611 HG23 VAL A  39      -0.246   5.857   1.327  1.00  0.00           H  
ATOM    612  N   GLU A  40      -2.688   6.964  -1.567  1.00  0.00           N  
ATOM    613  CA  GLU A  40      -4.070   6.497  -1.636  1.00  0.00           C  
ATOM    614  C   GLU A  40      -4.146   5.082  -2.203  1.00  0.00           C  
ATOM    615  O   GLU A  40      -4.943   4.263  -1.749  1.00  0.00           O  
ATOM    616  CB  GLU A  40      -4.911   7.447  -2.482  1.00  0.00           C  
ATOM    617  CG  GLU A  40      -6.310   7.669  -1.933  1.00  0.00           C  
ATOM    618  CD  GLU A  40      -6.943   8.953  -2.449  1.00  0.00           C  
ATOM    619  OE1 GLU A  40      -6.967   9.144  -3.677  1.00  0.00           O  
ATOM    620  OE2 GLU A  40      -7.403   9.758  -1.614  1.00  0.00           O  
ATOM    621  H   GLU A  40      -2.468   7.861  -1.895  1.00  0.00           H  
ATOM    622  HA  GLU A  40      -4.461   6.482  -0.630  1.00  0.00           H  
ATOM    623  HB2 GLU A  40      -4.415   8.405  -2.535  1.00  0.00           H  
ATOM    624  HB3 GLU A  40      -4.999   7.044  -3.480  1.00  0.00           H  
ATOM    625  HG2 GLU A  40      -6.935   6.839  -2.228  1.00  0.00           H  
ATOM    626  HG3 GLU A  40      -6.260   7.717  -0.857  1.00  0.00           H  
ATOM    627  N   GLY A  41      -3.299   4.800  -3.185  1.00  0.00           N  
ATOM    628  CA  GLY A  41      -3.278   3.479  -3.781  1.00  0.00           C  
ATOM    629  C   GLY A  41      -2.413   2.516  -2.992  1.00  0.00           C  
ATOM    630  O   GLY A  41      -2.628   1.308  -3.021  1.00  0.00           O  
ATOM    631  H   GLY A  41      -2.677   5.489  -3.500  1.00  0.00           H  
ATOM    632  HA2 GLY A  41      -4.287   3.095  -3.820  1.00  0.00           H  
ATOM    633  HA3 GLY A  41      -2.891   3.554  -4.786  1.00  0.00           H  
ATOM    634  N   VAL A  42      -1.432   3.063  -2.281  1.00  0.00           N  
ATOM    635  CA  VAL A  42      -0.525   2.257  -1.475  1.00  0.00           C  
ATOM    636  C   VAL A  42      -1.271   1.467  -0.403  1.00  0.00           C  
ATOM    637  O   VAL A  42      -1.068   0.263  -0.250  1.00  0.00           O  
ATOM    638  CB  VAL A  42       0.537   3.130  -0.793  1.00  0.00           C  
ATOM    639  CG1 VAL A  42       1.487   2.259  -0.007  1.00  0.00           C  
ATOM    640  CG2 VAL A  42       1.299   3.952  -1.815  1.00  0.00           C  
ATOM    641  H   VAL A  42      -1.315   4.033  -2.300  1.00  0.00           H  
ATOM    642  HA  VAL A  42      -0.015   1.566  -2.128  1.00  0.00           H  
ATOM    643  HB  VAL A  42       0.043   3.804  -0.108  1.00  0.00           H  
ATOM    644 HG11 VAL A  42       1.023   1.969   0.927  1.00  0.00           H  
ATOM    645 HG12 VAL A  42       2.395   2.809   0.192  1.00  0.00           H  
ATOM    646 HG13 VAL A  42       1.718   1.376  -0.587  1.00  0.00           H  
ATOM    647 HG21 VAL A  42       1.808   4.762  -1.315  1.00  0.00           H  
ATOM    648 HG22 VAL A  42       0.611   4.352  -2.545  1.00  0.00           H  
ATOM    649 HG23 VAL A  42       2.022   3.325  -2.305  1.00  0.00           H  
ATOM    650  N   GLU A  43      -2.122   2.154   0.345  1.00  0.00           N  
ATOM    651  CA  GLU A  43      -2.889   1.512   1.410  1.00  0.00           C  
ATOM    652  C   GLU A  43      -3.935   0.572   0.828  1.00  0.00           C  
ATOM    653  O   GLU A  43      -4.053  -0.579   1.247  1.00  0.00           O  
ATOM    654  CB  GLU A  43      -3.565   2.561   2.297  1.00  0.00           C  
ATOM    655  CG  GLU A  43      -3.989   3.811   1.542  1.00  0.00           C  
ATOM    656  CD  GLU A  43      -4.950   4.675   2.333  1.00  0.00           C  
ATOM    657  OE1 GLU A  43      -4.551   5.183   3.402  1.00  0.00           O  
ATOM    658  OE2 GLU A  43      -6.104   4.844   1.885  1.00  0.00           O  
ATOM    659  H   GLU A  43      -2.234   3.115   0.180  1.00  0.00           H  
ATOM    660  HA  GLU A  43      -2.201   0.933   2.011  1.00  0.00           H  
ATOM    661  HB2 GLU A  43      -4.442   2.124   2.748  1.00  0.00           H  
ATOM    662  HB3 GLU A  43      -2.878   2.854   3.075  1.00  0.00           H  
ATOM    663  HG2 GLU A  43      -3.105   4.391   1.315  1.00  0.00           H  
ATOM    664  HG3 GLU A  43      -4.467   3.511   0.620  1.00  0.00           H  
ATOM    665  N   SER A  44      -4.685   1.067  -0.147  1.00  0.00           N  
ATOM    666  CA  SER A  44      -5.711   0.270  -0.797  1.00  0.00           C  
ATOM    667  C   SER A  44      -5.074  -0.876  -1.580  1.00  0.00           C  
ATOM    668  O   SER A  44      -5.713  -1.892  -1.846  1.00  0.00           O  
ATOM    669  CB  SER A  44      -6.551   1.150  -1.725  1.00  0.00           C  
ATOM    670  OG  SER A  44      -6.038   1.147  -3.047  1.00  0.00           O  
ATOM    671  H   SER A  44      -4.537   1.988  -0.444  1.00  0.00           H  
ATOM    672  HA  SER A  44      -6.349  -0.144  -0.029  1.00  0.00           H  
ATOM    673  HB2 SER A  44      -7.567   0.783  -1.746  1.00  0.00           H  
ATOM    674  HB3 SER A  44      -6.543   2.166  -1.353  1.00  0.00           H  
ATOM    675  HG  SER A  44      -6.745   0.946  -3.665  1.00  0.00           H  
ATOM    676  N   LEU A  45      -3.805  -0.699  -1.938  1.00  0.00           N  
ATOM    677  CA  LEU A  45      -3.064  -1.709  -2.686  1.00  0.00           C  
ATOM    678  C   LEU A  45      -3.061  -3.045  -1.946  1.00  0.00           C  
ATOM    679  O   LEU A  45      -3.536  -4.054  -2.469  1.00  0.00           O  
ATOM    680  CB  LEU A  45      -1.624  -1.235  -2.921  1.00  0.00           C  
ATOM    681  CG  LEU A  45      -1.300  -0.688  -4.324  1.00  0.00           C  
ATOM    682  CD1 LEU A  45      -0.353  -1.620  -5.058  1.00  0.00           C  
ATOM    683  CD2 LEU A  45      -2.551  -0.417  -5.152  1.00  0.00           C  
ATOM    684  H   LEU A  45      -3.353   0.137  -1.691  1.00  0.00           H  
ATOM    685  HA  LEU A  45      -3.550  -1.845  -3.639  1.00  0.00           H  
ATOM    686  HB2 LEU A  45      -1.413  -0.455  -2.205  1.00  0.00           H  
ATOM    687  HB3 LEU A  45      -0.960  -2.063  -2.721  1.00  0.00           H  
ATOM    688 HD11 LEU A  45      -0.357  -2.587  -4.577  1.00  0.00           H  
ATOM    689 HD12 LEU A  45       0.647  -1.208  -5.031  1.00  0.00           H  
ATOM    690 HD13 LEU A  45      -0.672  -1.725  -6.084  1.00  0.00           H  
ATOM    691 HD21 LEU A  45      -2.851  -1.324  -5.657  1.00  0.00           H  
ATOM    692 HD22 LEU A  45      -2.339   0.347  -5.886  1.00  0.00           H  
ATOM    693 HD23 LEU A  45      -3.350  -0.084  -4.508  1.00  0.00           H  
ATOM    694  N   LYS A  46      -2.527  -3.047  -0.729  1.00  0.00           N  
ATOM    695  CA  LYS A  46      -2.467  -4.263   0.073  1.00  0.00           C  
ATOM    696  C   LYS A  46      -3.866  -4.671   0.542  1.00  0.00           C  
ATOM    697  O   LYS A  46      -4.260  -5.828   0.425  1.00  0.00           O  
ATOM    698  CB  LYS A  46      -1.508  -4.070   1.265  1.00  0.00           C  
ATOM    699  CG  LYS A  46      -1.963  -4.714   2.570  1.00  0.00           C  
ATOM    700  CD  LYS A  46      -2.895  -3.798   3.348  1.00  0.00           C  
ATOM    701  CE  LYS A  46      -3.099  -4.285   4.772  1.00  0.00           C  
ATOM    702  NZ  LYS A  46      -3.304  -3.157   5.721  1.00  0.00           N  
ATOM    703  H   LYS A  46      -2.164  -2.213  -0.364  1.00  0.00           H  
ATOM    704  HA  LYS A  46      -2.076  -5.051  -0.560  1.00  0.00           H  
ATOM    705  HB2 LYS A  46      -0.554  -4.501   1.002  1.00  0.00           H  
ATOM    706  HB3 LYS A  46      -1.375  -3.010   1.439  1.00  0.00           H  
ATOM    707  HG2 LYS A  46      -2.479  -5.639   2.347  1.00  0.00           H  
ATOM    708  HG3 LYS A  46      -1.091  -4.924   3.176  1.00  0.00           H  
ATOM    709  HD2 LYS A  46      -2.469  -2.807   3.378  1.00  0.00           H  
ATOM    710  HD3 LYS A  46      -3.851  -3.764   2.854  1.00  0.00           H  
ATOM    711  HE2 LYS A  46      -3.968  -4.928   4.795  1.00  0.00           H  
ATOM    712  HE3 LYS A  46      -2.228  -4.848   5.073  1.00  0.00           H  
ATOM    713  HZ1 LYS A  46      -2.399  -2.886   6.156  1.00  0.00           H  
ATOM    714  HZ2 LYS A  46      -3.966  -3.437   6.473  1.00  0.00           H  
ATOM    715  HZ3 LYS A  46      -3.695  -2.334   5.218  1.00  0.00           H  
ATOM    716  N   ASN A  47      -4.621  -3.722   1.072  1.00  0.00           N  
ATOM    717  CA  ASN A  47      -5.968  -4.023   1.547  1.00  0.00           C  
ATOM    718  C   ASN A  47      -6.808  -4.618   0.422  1.00  0.00           C  
ATOM    719  O   ASN A  47      -7.737  -5.387   0.669  1.00  0.00           O  
ATOM    720  CB  ASN A  47      -6.637  -2.765   2.102  1.00  0.00           C  
ATOM    721  CG  ASN A  47      -7.843  -3.084   2.964  1.00  0.00           C  
ATOM    722  OD1 ASN A  47      -7.786  -2.988   4.191  1.00  0.00           O  
ATOM    723  ND2 ASN A  47      -8.942  -3.465   2.327  1.00  0.00           N  
ATOM    724  H   ASN A  47      -4.269  -2.811   1.148  1.00  0.00           H  
ATOM    725  HA  ASN A  47      -5.880  -4.762   2.336  1.00  0.00           H  
ATOM    726  HB2 ASN A  47      -5.923  -2.219   2.702  1.00  0.00           H  
ATOM    727  HB3 ASN A  47      -6.958  -2.143   1.280  1.00  0.00           H  
ATOM    728 HD21 ASN A  47      -8.914  -3.518   1.348  1.00  0.00           H  
ATOM    729 HD22 ASN A  47      -9.737  -3.677   2.859  1.00  0.00           H  
ATOM    730  N   GLU A  48      -6.462  -4.273  -0.814  1.00  0.00           N  
ATOM    731  CA  GLU A  48      -7.173  -4.794  -1.974  1.00  0.00           C  
ATOM    732  C   GLU A  48      -6.699  -6.208  -2.272  1.00  0.00           C  
ATOM    733  O   GLU A  48      -7.490  -7.080  -2.634  1.00  0.00           O  
ATOM    734  CB  GLU A  48      -6.953  -3.896  -3.194  1.00  0.00           C  
ATOM    735  CG  GLU A  48      -7.633  -4.405  -4.456  1.00  0.00           C  
ATOM    736  CD  GLU A  48      -7.533  -3.426  -5.608  1.00  0.00           C  
ATOM    737  OE1 GLU A  48      -7.197  -2.248  -5.361  1.00  0.00           O  
ATOM    738  OE2 GLU A  48      -7.793  -3.835  -6.759  1.00  0.00           O  
ATOM    739  H   GLU A  48      -5.702  -3.669  -0.946  1.00  0.00           H  
ATOM    740  HA  GLU A  48      -8.226  -4.822  -1.737  1.00  0.00           H  
ATOM    741  HB2 GLU A  48      -7.339  -2.911  -2.976  1.00  0.00           H  
ATOM    742  HB3 GLU A  48      -5.893  -3.824  -3.388  1.00  0.00           H  
ATOM    743  HG2 GLU A  48      -7.167  -5.333  -4.751  1.00  0.00           H  
ATOM    744  HG3 GLU A  48      -8.677  -4.579  -4.239  1.00  0.00           H  
ATOM    745  N   ILE A  49      -5.403  -6.435  -2.087  1.00  0.00           N  
ATOM    746  CA  ILE A  49      -4.821  -7.753  -2.306  1.00  0.00           C  
ATOM    747  C   ILE A  49      -5.418  -8.746  -1.317  1.00  0.00           C  
ATOM    748  O   ILE A  49      -5.522  -9.941  -1.593  1.00  0.00           O  
ATOM    749  CB  ILE A  49      -3.276  -7.735  -2.163  1.00  0.00           C  
ATOM    750  CG1 ILE A  49      -2.840  -7.636  -0.689  1.00  0.00           C  
ATOM    751  CG2 ILE A  49      -2.683  -6.590  -2.970  1.00  0.00           C  
ATOM    752  CD1 ILE A  49      -1.543  -8.339  -0.395  1.00  0.00           C  
ATOM    753  H   ILE A  49      -4.831  -5.702  -1.776  1.00  0.00           H  
ATOM    754  HA  ILE A  49      -5.070  -8.066  -3.310  1.00  0.00           H  
ATOM    755  HB  ILE A  49      -2.894  -8.652  -2.573  1.00  0.00           H  
ATOM    756 HG12 ILE A  49      -2.703  -6.606  -0.430  1.00  0.00           H  
ATOM    757 HG13 ILE A  49      -3.598  -8.066  -0.055  1.00  0.00           H  
ATOM    758 HG21 ILE A  49      -2.152  -5.918  -2.311  1.00  0.00           H  
ATOM    759 HG22 ILE A  49      -3.476  -6.051  -3.469  1.00  0.00           H  
ATOM    760 HG23 ILE A  49      -2.000  -6.985  -3.707  1.00  0.00           H  
ATOM    761 HD11 ILE A  49      -0.900  -8.272  -1.256  1.00  0.00           H  
ATOM    762 HD12 ILE A  49      -1.738  -9.375  -0.164  1.00  0.00           H  
ATOM    763 HD13 ILE A  49      -1.066  -7.862   0.450  1.00  0.00           H  
ATOM    764  N   LEU A  50      -5.809  -8.221  -0.163  1.00  0.00           N  
ATOM    765  CA  LEU A  50      -6.403  -9.019   0.892  1.00  0.00           C  
ATOM    766  C   LEU A  50      -7.866  -9.300   0.584  1.00  0.00           C  
ATOM    767  O   LEU A  50      -8.386 -10.367   0.912  1.00  0.00           O  
ATOM    768  CB  LEU A  50      -6.254  -8.285   2.224  1.00  0.00           C  
ATOM    769  CG  LEU A  50      -4.820  -8.215   2.748  1.00  0.00           C  
ATOM    770  CD1 LEU A  50      -4.533  -6.843   3.337  1.00  0.00           C  
ATOM    771  CD2 LEU A  50      -4.568  -9.310   3.775  1.00  0.00           C  
ATOM    772  H   LEU A  50      -5.694  -7.259  -0.017  1.00  0.00           H  
ATOM    773  HA  LEU A  50      -5.869  -9.957   0.941  1.00  0.00           H  
ATOM    774  HB2 LEU A  50      -6.619  -7.273   2.093  1.00  0.00           H  
ATOM    775  HB3 LEU A  50      -6.864  -8.779   2.963  1.00  0.00           H  
ATOM    776  HG  LEU A  50      -4.138  -8.367   1.924  1.00  0.00           H  
ATOM    777 HD11 LEU A  50      -4.456  -6.120   2.538  1.00  0.00           H  
ATOM    778 HD12 LEU A  50      -3.604  -6.874   3.887  1.00  0.00           H  
ATOM    779 HD13 LEU A  50      -5.336  -6.562   4.002  1.00  0.00           H  
ATOM    780 HD21 LEU A  50      -3.822  -8.978   4.479  1.00  0.00           H  
ATOM    781 HD22 LEU A  50      -4.217 -10.202   3.272  1.00  0.00           H  
ATOM    782 HD23 LEU A  50      -5.487  -9.530   4.299  1.00  0.00           H  
ATOM    783  N   LYS A  51      -8.520  -8.347  -0.071  1.00  0.00           N  
ATOM    784  CA  LYS A  51      -9.915  -8.511  -0.446  1.00  0.00           C  
ATOM    785  C   LYS A  51     -10.063  -9.688  -1.409  1.00  0.00           C  
ATOM    786  O   LYS A  51     -11.151 -10.239  -1.574  1.00  0.00           O  
ATOM    787  CB  LYS A  51     -10.450  -7.232  -1.095  1.00  0.00           C  
ATOM    788  CG  LYS A  51     -10.832  -6.156  -0.095  1.00  0.00           C  
ATOM    789  CD  LYS A  51     -11.852  -5.190  -0.677  1.00  0.00           C  
ATOM    790  CE  LYS A  51     -11.191  -4.147  -1.563  1.00  0.00           C  
ATOM    791  NZ  LYS A  51     -12.163  -3.504  -2.487  1.00  0.00           N  
ATOM    792  H   LYS A  51      -8.049  -7.525  -0.323  1.00  0.00           H  
ATOM    793  HA  LYS A  51     -10.482  -8.718   0.449  1.00  0.00           H  
ATOM    794  HB2 LYS A  51      -9.690  -6.831  -1.750  1.00  0.00           H  
ATOM    795  HB3 LYS A  51     -11.324  -7.478  -1.681  1.00  0.00           H  
ATOM    796  HG2 LYS A  51     -11.257  -6.626   0.781  1.00  0.00           H  
ATOM    797  HG3 LYS A  51      -9.946  -5.605   0.185  1.00  0.00           H  
ATOM    798  HD2 LYS A  51     -12.566  -5.747  -1.266  1.00  0.00           H  
ATOM    799  HD3 LYS A  51     -12.364  -4.690   0.133  1.00  0.00           H  
ATOM    800  HE2 LYS A  51     -10.748  -3.388  -0.935  1.00  0.00           H  
ATOM    801  HE3 LYS A  51     -10.416  -4.627  -2.143  1.00  0.00           H  
ATOM    802  HZ1 LYS A  51     -12.931  -4.167  -2.703  1.00  0.00           H  
ATOM    803  HZ2 LYS A  51     -11.689  -3.237  -3.373  1.00  0.00           H  
ATOM    804  HZ3 LYS A  51     -12.559  -2.653  -2.047  1.00  0.00           H  
ATOM    805  N   ALA A  52      -8.952 -10.068  -2.040  1.00  0.00           N  
ATOM    806  CA  ALA A  52      -8.944 -11.177  -2.983  1.00  0.00           C  
ATOM    807  C   ALA A  52      -7.584 -11.869  -3.001  1.00  0.00           C  
ATOM    808  O   ALA A  52      -6.924 -11.938  -4.039  1.00  0.00           O  
ATOM    809  CB  ALA A  52      -9.309 -10.685  -4.375  1.00  0.00           C  
ATOM    810  H   ALA A  52      -8.116  -9.590  -1.865  1.00  0.00           H  
ATOM    811  HA  ALA A  52      -9.692 -11.886  -2.665  1.00  0.00           H  
ATOM    812  HB1 ALA A  52      -9.308 -11.518  -5.062  1.00  0.00           H  
ATOM    813  HB2 ALA A  52      -8.584  -9.951  -4.697  1.00  0.00           H  
ATOM    814  HB3 ALA A  52     -10.291 -10.236  -4.354  1.00  0.00           H  
ATOM    815  N   LEU A  53      -7.169 -12.378  -1.846  1.00  0.00           N  
ATOM    816  CA  LEU A  53      -5.889 -13.062  -1.730  1.00  0.00           C  
ATOM    817  C   LEU A  53      -5.884 -14.362  -2.535  1.00  0.00           C  
ATOM    818  O   LEU A  53      -5.063 -14.539  -3.434  1.00  0.00           O  
ATOM    819  CB  LEU A  53      -5.572 -13.352  -0.260  1.00  0.00           C  
ATOM    820  CG  LEU A  53      -4.225 -12.811   0.230  1.00  0.00           C  
ATOM    821  CD1 LEU A  53      -4.371 -12.162   1.599  1.00  0.00           C  
ATOM    822  CD2 LEU A  53      -3.188 -13.924   0.271  1.00  0.00           C  
ATOM    823  H   LEU A  53      -7.738 -12.291  -1.054  1.00  0.00           H  
ATOM    824  HA  LEU A  53      -5.128 -12.408  -2.128  1.00  0.00           H  
ATOM    825  HB2 LEU A  53      -6.354 -12.916   0.347  1.00  0.00           H  
ATOM    826  HB3 LEU A  53      -5.579 -14.422  -0.113  1.00  0.00           H  
ATOM    827  HG  LEU A  53      -3.877 -12.055  -0.460  1.00  0.00           H  
ATOM    828 HD11 LEU A  53      -5.322 -12.440   2.031  1.00  0.00           H  
ATOM    829 HD12 LEU A  53      -4.325 -11.087   1.494  1.00  0.00           H  
ATOM    830 HD13 LEU A  53      -3.572 -12.496   2.245  1.00  0.00           H  
ATOM    831 HD21 LEU A  53      -2.227 -13.532  -0.033  1.00  0.00           H  
ATOM    832 HD22 LEU A  53      -3.483 -14.716  -0.400  1.00  0.00           H  
ATOM    833 HD23 LEU A  53      -3.117 -14.311   1.277  1.00  0.00           H  
ATOM    834  N   PRO A  54      -6.806 -15.292  -2.223  1.00  0.00           N  
ATOM    835  CA  PRO A  54      -6.897 -16.575  -2.927  1.00  0.00           C  
ATOM    836  C   PRO A  54      -7.430 -16.419  -4.347  1.00  0.00           C  
ATOM    837  O   PRO A  54      -8.534 -16.865  -4.662  1.00  0.00           O  
ATOM    838  CB  PRO A  54      -7.877 -17.380  -2.070  1.00  0.00           C  
ATOM    839  CG  PRO A  54      -8.721 -16.354  -1.398  1.00  0.00           C  
ATOM    840  CD  PRO A  54      -7.826 -15.168  -1.164  1.00  0.00           C  
ATOM    841  HA  PRO A  54      -5.942 -17.078  -2.955  1.00  0.00           H  
ATOM    842  HB2 PRO A  54      -8.468 -18.024  -2.706  1.00  0.00           H  
ATOM    843  HB3 PRO A  54      -7.331 -17.973  -1.354  1.00  0.00           H  
ATOM    844  HG2 PRO A  54      -9.546 -16.080  -2.039  1.00  0.00           H  
ATOM    845  HG3 PRO A  54      -9.087 -16.738  -0.458  1.00  0.00           H  
ATOM    846  HD2 PRO A  54      -8.384 -14.249  -1.271  1.00  0.00           H  
ATOM    847  HD3 PRO A  54      -7.375 -15.225  -0.184  1.00  0.00           H  
ATOM    848  N   THR A  55      -6.637 -15.780  -5.203  1.00  0.00           N  
ATOM    849  CA  THR A  55      -7.027 -15.564  -6.591  1.00  0.00           C  
ATOM    850  C   THR A  55      -6.249 -16.486  -7.523  1.00  0.00           C  
ATOM    851  O   THR A  55      -5.317 -17.171  -7.101  1.00  0.00           O  
ATOM    852  CB  THR A  55      -6.796 -14.105  -6.986  1.00  0.00           C  
ATOM    853  OG1 THR A  55      -5.735 -13.543  -6.234  1.00  0.00           O  
ATOM    854  CG2 THR A  55      -8.013 -13.230  -6.785  1.00  0.00           C  
ATOM    855  H   THR A  55      -5.769 -15.448  -4.892  1.00  0.00           H  
ATOM    856  HA  THR A  55      -8.080 -15.788  -6.677  1.00  0.00           H  
ATOM    857  HB  THR A  55      -6.529 -14.063  -8.032  1.00  0.00           H  
ATOM    858  HG1 THR A  55      -5.231 -12.945  -6.788  1.00  0.00           H  
ATOM    859 HG21 THR A  55      -8.455 -13.000  -7.744  1.00  0.00           H  
ATOM    860 HG22 THR A  55      -7.722 -12.312  -6.295  1.00  0.00           H  
ATOM    861 HG23 THR A  55      -8.736 -13.751  -6.173  1.00  0.00           H  
ATOM    862  N   GLU A  56      -6.639 -16.499  -8.794  1.00  0.00           N  
ATOM    863  CA  GLU A  56      -5.977 -17.337  -9.787  1.00  0.00           C  
ATOM    864  C   GLU A  56      -4.689 -16.685 -10.279  1.00  0.00           C  
ATOM    865  O   GLU A  56      -4.512 -15.472 -10.039  1.00  0.00           O  
ATOM    866  CB  GLU A  56      -6.913 -17.598 -10.969  1.00  0.00           C  
ATOM    867  CG  GLU A  56      -8.033 -18.576 -10.653  1.00  0.00           C  
ATOM    868  CD  GLU A  56      -8.990 -18.762 -11.814  1.00  0.00           C  
ATOM    869  OE1 GLU A  56      -9.645 -17.774 -12.207  1.00  0.00           O  
ATOM    870  OE2 GLU A  56      -9.083 -19.895 -12.332  1.00  0.00           O  
ATOM    871  OXT GLU A  56      -3.868 -17.393 -10.900  1.00  0.00           O  
ATOM    872  H   GLU A  56      -7.389 -15.931  -9.070  1.00  0.00           H  
ATOM    873  HA  GLU A  56      -5.734 -18.277  -9.318  1.00  0.00           H  
ATOM    874  HB2 GLU A  56      -7.357 -16.664 -11.275  1.00  0.00           H  
ATOM    875  HB3 GLU A  56      -6.336 -17.998 -11.790  1.00  0.00           H  
ATOM    876  HG2 GLU A  56      -7.598 -19.534 -10.409  1.00  0.00           H  
ATOM    877  HG3 GLU A  56      -8.588 -18.207  -9.803  1.00  0.00           H  
TER     878      GLU A  56                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
