
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   65 ( 1010),  selected   65 , name 1gjs_A
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 1gjs_A.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    A     3_A      -       -           -
LGA    I     4_A      -       -           -
LGA    F     5_A      -       -           -
LGA    V     6_A      -       -           -
LGA    L     7_A      -       -           -
LGA    N     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    H    11_A      -       -           -
LGA    D    12_A      -       -           -
LGA    E    13_A      -       -           -
LGA    A    14_A      -       -           -
LGA    V    15_A      -       -           -
LGA    D    16_A      -       -           -
LGA    A    17_A      -       -           -
LGA    N    18_A      -       -           -
LGA    S    19_A      N       8          0.941
LGA    L    20_A      L       9          0.508
LGA    A    21_A      K      10          0.851
LGA    E    22_A      Q      11          1.410
LGA    A    23_A      A      12          1.157
LGA    K    24_A      K      13          0.414
LGA    V    25_A      E      14          0.135
LGA    L    26_A      E      15          1.517
LGA    A    27_A      A      16          2.296
LGA    N    28_A      I      17          1.693
LGA    R    29_A      K      18          0.766
LGA    E    30_A      E      19          0.752
LGA    L    31_A      L      20          0.535
LGA    D    32_A      V      21          1.823
LGA    K    33_A      D      22          1.851
LGA    Y    34_A      A      23          1.560
LGA    G    35_A      G      24          1.788
LGA    V    36_A      T      25          1.504
LGA    S    37_A      A      26          2.596
LGA    D    38_A      E      27          2.333
LGA    Y    39_A      K      28          0.958
LGA    Y    40_A      Y      29          1.538
LGA    K    41_A      I      30          1.588
LGA    N    42_A      K      31          1.031
LGA    L    43_A      L      32          0.929
LGA    I    44_A      I      33          1.062
LGA    N    45_A      A      34          0.434
LGA    N    46_A      N      35          0.807
LGA    A    47_A      A      36          0.628
LGA    K    48_A      K      37          1.140
LGA    T    49_A      T      38          0.638
LGA    V    50_A      V      39          0.470
LGA    E    51_A      E      40          0.728
LGA    G    52_A      G      41          0.195
LGA    V    53_A      V      42          0.824
LGA    K    54_A      W      43          1.369
LGA    A    55_A      T      44          1.736
LGA    L    56_A      L      45          1.748
LGA    I    57_A      K      46          2.454
LGA    D    58_A      D      47          2.934
LGA    E    59_A      E      48          2.133
LGA    I    60_A      I      49          1.548
LGA    L    61_A      K      50          1.539
LGA    A    62_A      T      51          1.812
LGA    A    63_A      F      52          2.002
LGA    L    64_A      -       -           -
LGA    P    65_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   65   45    5.0     45    1.46    48.89     93.060     2.876

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.193863 * X  +   0.841301 * Y  +   0.504608 * Z  +   2.033810
  Y_new =   0.973214 * X  +  -0.100134 * Y  +  -0.206948 * Z  +   5.002628
  Z_new =  -0.123578 * X  +   0.531211 * Y  +  -0.838178 * Z  +   1.603035 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.576713   -0.564880  [ DEG:   147.6348    -32.3652 ]
  Theta =   0.123894    3.017698  [ DEG:     7.0986    172.9014 ]
  Phi   =   1.374171   -1.767422  [ DEG:    78.7342   -101.2658 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gjs_A                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gjs_A.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   65   45   5.0   45   1.46   48.89  93.060
REMARK  ---------------------------------------------------------- 
MOLECULE 1gjs_A
HEADER    IMMUNOGLOBULIN-BINDING PROTEIN          02-AUG-01   1GJS              
TITLE     SOLUTION STRUCTURE OF THE ALBUMIN BINDING DOMAIN OF                   
TITLE    2 STREPTOCOCCAL PROTEIN G                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IMMUNOGLOBULIN G BINDING PROTEIN G;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: ALBUMIN-BINDING DOMAIN RESIDUES 254-299;                   
COMPND   5 SYNONYM: ABD, ALBUMIN-BINDING DOMAIN OF PROTEIN G, IGG               
COMPND   6 BINDING PROTEIN G;                                                   
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP. GROUP G;                      
SOURCE   3 ORGANISM_COMMON: GROUP G STREPTOCOCCI;                               
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    BACTERIAL SURFACE PROTEIN, ALBUMIN BINDING, PROTEIN G                 
EXPDTA    NMR, 30 STRUCTURES                                                    
AUTHOR    M.U.JOHANSSON,I.M.FRICK,H.NILSSON,P.J.KRAULIS,S.HOBER,                
AUTHOR   2 P.JONASSON,P.A.NYGREN,M.UHLEN,L.BJORCK,S.DRAKENBERGFORSEN,           
AUTHOR   3 M.WIKSTROM                                                           
REVDAT   4   05-APR-05 1GJS    1       REMARK                                   
REVDAT   3   21-MAR-02 1GJS    1       SOURCE                                   
REVDAT   2   15-MAR-02 1GJS    1       JRNL                                     
REVDAT   1   09-AUG-01 1GJS    0                                                
JRNL        AUTH   M.U.JOHANSSON,I.M.FRICK,H.NILSSON,P.J.KRAULIS,               
JRNL        AUTH 2 S.HOBER,P.JONASSON,M.LINHULT,P.A.NYGREN,M.UHLEN,             
JRNL        AUTH 3 L.BJORCK,T.DRAKENBERG,S.FORSEN,M.WIKSTROM                    
JRNL        TITL   STRUCTURE, SPECIFICITY, AND MODE OF INTERACTION              
JRNL        TITL 2 FOR BACTERIAL ALBUMIN-BINDING MODULES.                       
JRNL        REF    J.BIOL.CHEM.                  V. 277  8114 2002              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1GJS A    1    19  UNP    P19909   SPG2_STRSG       1     19             
DBREF  1GJS A   20    65  UNP    P19909   SPG2_STRSP     254    299             
SEQRES   1 A   65  MET LYS ALA ILE PHE VAL LEU ASN ALA GLN HIS ASP GLU          
SEQRES   2 A   65  ALA VAL ASP ALA ASN SER LEU ALA GLU ALA LYS VAL LEU          
SEQRES   3 A   65  ALA ASN ARG GLU LEU ASP LYS TYR GLY VAL SER ASP TYR          
SEQRES   4 A   65  TYR LYS ASN LEU ILE ASN ASN ALA LYS THR VAL GLU GLY          
SEQRES   5 A   65  VAL LYS ALA LEU ILE ASP GLU ILE LEU ALA ALA LEU PRO          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       5.373  39.514  -8.662  1.00 21.30           N  
ATOM      2  CA  MET A   1       5.308  38.053  -8.939  1.00 21.02           C  
ATOM      3  C   MET A   1       4.227  37.412  -8.065  1.00 20.37           C  
ATOM      4  O   MET A   1       3.934  36.239  -8.189  1.00 20.39           O  
ATOM      5  CB  MET A   1       6.663  37.414  -8.622  1.00 21.44           C  
ATOM      6  CG  MET A   1       6.994  37.623  -7.143  1.00 21.88           C  
ATOM      7  SD  MET A   1       8.698  37.100  -6.821  1.00 22.37           S  
ATOM      8  CE  MET A   1       9.495  38.692  -7.146  1.00 22.77           C  
ATOM      9  H2  MET A   1       6.338  39.858  -8.844  1.00 21.47           H  
ATOM     10  HA  MET A   1       5.071  37.894  -9.981  1.00 21.10           H  
ATOM     11  HB2 MET A   1       6.620  36.354  -8.837  1.00 21.17           H  
ATOM     12  HB3 MET A   1       7.429  37.874  -9.229  1.00 21.80           H  
ATOM     13  HG2 MET A   1       6.887  38.669  -6.897  1.00 22.18           H  
ATOM     14  HG3 MET A   1       6.317  37.039  -6.538  1.00 21.71           H  
ATOM     15  HE1 MET A   1       8.982  39.192  -7.955  1.00 22.98           H  
ATOM     16  HE2 MET A   1       9.453  39.301  -6.252  1.00 22.87           H  
ATOM     17  HE3 MET A   1      10.523  38.533  -7.423  1.00 22.81           H  
ATOM     18  H1  MET A   1       5.122  39.691  -7.669  1.00 21.26           H  
ATOM     19  H3  MET A   1       4.705  40.014  -9.281  1.00 21.49           H  
ATOM     20  N   LYS A   2       3.632  38.168  -7.183  1.00 19.90           N  
ATOM     21  CA  LYS A   2       2.573  37.592  -6.305  1.00 19.38           C  
ATOM     22  C   LYS A   2       1.359  37.212  -7.154  1.00 18.83           C  
ATOM     23  O   LYS A   2       0.980  37.920  -8.066  1.00 18.89           O  
ATOM     24  CB  LYS A   2       2.156  38.626  -5.254  1.00 19.49           C  
ATOM     25  CG  LYS A   2       3.302  38.830  -4.262  1.00 19.58           C  
ATOM     26  CD  LYS A   2       2.892  39.859  -3.200  1.00 19.81           C  
ATOM     27  CE  LYS A   2       2.665  41.237  -3.844  1.00 19.99           C  
ATOM     28  NZ  LYS A   2       1.244  41.350  -4.284  1.00 20.19           N  
ATOM     29  H   LYS A   2       3.881  39.112  -7.095  1.00 19.99           H  
ATOM     30  HA  LYS A   2       2.955  36.711  -5.811  1.00 19.46           H  
ATOM     31  HB2 LYS A   2       1.929  39.562  -5.743  1.00 19.47           H  
ATOM     32  HB3 LYS A   2       1.284  38.272  -4.727  1.00 19.66           H  
ATOM     33  HG2 LYS A   2       3.532  37.890  -3.781  1.00 19.58           H  
ATOM     34  HG3 LYS A   2       4.175  39.187  -4.788  1.00 19.61           H  
ATOM     35  HD2 LYS A   2       1.980  39.534  -2.722  1.00 19.96           H  
ATOM     36  HD3 LYS A   2       3.676  39.936  -2.459  1.00 19.85           H  
ATOM     37  HE2 LYS A   2       2.874  42.012  -3.120  1.00 19.95           H  
ATOM     38  HE3 LYS A   2       3.316  41.359  -4.698  1.00 20.15           H  
ATOM     39  HZ1 LYS A   2       0.730  40.487  -4.017  1.00 20.30           H  
ATOM     40  HZ2 LYS A   2       0.805  42.175  -3.825  1.00 20.26           H  
ATOM     41  HZ3 LYS A   2       1.210  41.468  -5.316  1.00 20.27           H  
ATOM     42  N   ALA A   3       0.748  36.096  -6.862  1.00 18.43           N  
ATOM     43  CA  ALA A   3      -0.441  35.664  -7.651  1.00 18.03           C  
ATOM     44  C   ALA A   3      -1.232  34.632  -6.847  1.00 17.59           C  
ATOM     45  O   ALA A   3      -2.446  34.609  -6.867  1.00 17.73           O  
ATOM     46  CB  ALA A   3       0.023  35.042  -8.969  1.00 18.23           C  
ATOM     47  H   ALA A   3       1.072  35.539  -6.124  1.00 18.48           H  
ATOM     48  HA  ALA A   3      -1.067  36.520  -7.857  1.00 18.06           H  
ATOM     49  HB1 ALA A   3       0.701  34.227  -8.763  1.00 18.30           H  
ATOM     50  HB2 ALA A   3       0.526  35.790  -9.563  1.00 18.38           H  
ATOM     51  HB3 ALA A   3      -0.834  34.669  -9.511  1.00 18.28           H  
ATOM     52  N   ILE A   4      -0.545  33.772  -6.144  1.00 17.22           N  
ATOM     53  CA  ILE A   4      -1.240  32.728  -5.337  1.00 16.95           C  
ATOM     54  C   ILE A   4      -1.550  33.277  -3.941  1.00 16.44           C  
ATOM     55  O   ILE A   4      -0.737  33.941  -3.329  1.00 16.48           O  
ATOM     56  CB  ILE A   4      -0.330  31.506  -5.212  1.00 17.23           C  
ATOM     57  CG1 ILE A   4      -0.033  30.952  -6.609  1.00 17.55           C  
ATOM     58  CG2 ILE A   4      -1.024  30.431  -4.374  1.00 17.35           C  
ATOM     59  CD1 ILE A   4       1.064  29.892  -6.518  1.00 17.72           C  
ATOM     60  H   ILE A   4       0.433  33.811  -6.150  1.00 17.21           H  
ATOM     61  HA  ILE A   4      -2.161  32.442  -5.824  1.00 17.08           H  
ATOM     62  HB  ILE A   4       0.595  31.794  -4.734  1.00 17.28           H  
ATOM     63 HG12 ILE A   4      -0.929  30.508  -7.017  1.00 17.63           H  
ATOM     64 HG13 ILE A   4       0.296  31.755  -7.253  1.00 17.75           H  
ATOM     65 HG21 ILE A   4      -2.016  30.256  -4.760  1.00 17.33           H  
ATOM     66 HG22 ILE A   4      -0.454  29.516  -4.418  1.00 17.59           H  
ATOM     67 HG23 ILE A   4      -1.091  30.765  -3.347  1.00 17.38           H  
ATOM     68 HD11 ILE A   4       1.935  30.314  -6.041  1.00 17.93           H  
ATOM     69 HD12 ILE A   4       0.707  29.052  -5.940  1.00 17.64           H  
ATOM     70 HD13 ILE A   4       1.326  29.558  -7.512  1.00 17.86           H  
ATOM     71  N   PHE A   5      -2.720  32.999  -3.433  1.00 16.11           N  
ATOM     72  CA  PHE A   5      -3.085  33.499  -2.077  1.00 15.78           C  
ATOM     73  C   PHE A   5      -2.152  32.858  -1.042  1.00 15.39           C  
ATOM     74  O   PHE A   5      -1.661  31.763  -1.232  1.00 15.53           O  
ATOM     75  CB  PHE A   5      -4.541  33.131  -1.776  1.00 15.91           C  
ATOM     76  CG  PHE A   5      -4.977  33.792  -0.488  1.00 16.27           C  
ATOM     77  CD1 PHE A   5      -5.401  35.126  -0.496  1.00 16.49           C  
ATOM     78  CD2 PHE A   5      -4.952  33.073   0.711  1.00 16.55           C  
ATOM     79  CE1 PHE A   5      -5.801  35.740   0.698  1.00 16.98           C  
ATOM     80  CE2 PHE A   5      -5.351  33.687   1.904  1.00 17.03           C  
ATOM     81  CZ  PHE A   5      -5.775  35.020   1.897  1.00 17.24           C  
ATOM     82  H   PHE A   5      -3.359  32.459  -3.945  1.00 16.19           H  
ATOM     83  HA  PHE A   5      -2.970  34.572  -2.047  1.00 15.90           H  
ATOM     84  HB2 PHE A   5      -5.172  33.469  -2.585  1.00 15.85           H  
ATOM     85  HB3 PHE A   5      -4.628  32.059  -1.676  1.00 15.96           H  
ATOM     86  HD1 PHE A   5      -5.420  35.682  -1.422  1.00 16.41           H  
ATOM     87  HD2 PHE A   5      -4.628  32.044   0.716  1.00 16.50           H  
ATOM     88  HE1 PHE A   5      -6.129  36.769   0.692  1.00 17.25           H  
ATOM     89  HE2 PHE A   5      -5.331  33.131   2.831  1.00 17.35           H  
ATOM     90  HZ  PHE A   5      -6.084  35.493   2.818  1.00 17.70           H  
ATOM     91  N   VAL A   6      -1.887  33.542   0.039  1.00 15.04           N  
ATOM     92  CA  VAL A   6      -0.964  32.980   1.068  1.00 14.79           C  
ATOM     93  C   VAL A   6      -1.404  31.567   1.450  1.00 14.55           C  
ATOM     94  O   VAL A   6      -0.638  30.626   1.371  1.00 14.58           O  
ATOM     95  CB  VAL A   6      -0.996  33.868   2.313  1.00 14.86           C  
ATOM     96  CG1 VAL A   6      -0.066  33.288   3.379  1.00 15.09           C  
ATOM     97  CG2 VAL A   6      -0.530  35.277   1.942  1.00 15.03           C  
ATOM     98  H   VAL A   6      -2.280  34.430   0.166  1.00 15.04           H  
ATOM     99  HA  VAL A   6       0.041  32.950   0.673  1.00 14.93           H  
ATOM    100  HB  VAL A   6      -2.003  33.910   2.699  1.00 14.83           H  
ATOM    101 HG11 VAL A   6       0.891  33.056   2.937  1.00 15.30           H  
ATOM    102 HG12 VAL A   6       0.068  34.010   4.172  1.00 15.13           H  
ATOM    103 HG13 VAL A   6      -0.503  32.385   3.784  1.00 15.14           H  
ATOM    104 HG21 VAL A   6       0.466  35.231   1.526  1.00 14.99           H  
ATOM    105 HG22 VAL A   6      -1.206  35.701   1.215  1.00 15.14           H  
ATOM    106 HG23 VAL A   6      -0.519  35.897   2.827  1.00 15.26           H  
ATOM    107  N   LEU A   7      -2.632  31.403   1.856  1.00 14.47           N  
ATOM    108  CA  LEU A   7      -3.112  30.044   2.234  1.00 14.40           C  
ATOM    109  C   LEU A   7      -3.483  29.277   0.967  1.00 13.90           C  
ATOM    110  O   LEU A   7      -4.269  29.732   0.158  1.00 13.91           O  
ATOM    111  CB  LEU A   7      -4.340  30.176   3.151  1.00 14.97           C  
ATOM    112  CG  LEU A   7      -4.790  28.781   3.673  1.00 15.35           C  
ATOM    113  CD1 LEU A   7      -5.329  28.907   5.103  1.00 15.68           C  
ATOM    114  CD2 LEU A   7      -5.902  28.197   2.785  1.00 15.83           C  
ATOM    115  H   LEU A   7      -3.237  32.171   1.910  1.00 14.57           H  
ATOM    116  HA  LEU A   7      -2.327  29.517   2.757  1.00 14.48           H  
ATOM    117  HB2 LEU A   7      -4.077  30.811   3.987  1.00 15.10           H  
ATOM    118  HB3 LEU A   7      -5.145  30.638   2.600  1.00 15.14           H  
ATOM    119  HG  LEU A   7      -3.944  28.105   3.678  1.00 15.24           H  
ATOM    120 HD11 LEU A   7      -6.119  29.642   5.125  1.00 15.85           H  
ATOM    121 HD12 LEU A   7      -5.716  27.953   5.427  1.00 15.76           H  
ATOM    122 HD13 LEU A   7      -4.532  29.216   5.763  1.00 15.81           H  
ATOM    123 HD21 LEU A   7      -6.686  28.928   2.653  1.00 16.05           H  
ATOM    124 HD22 LEU A   7      -5.498  27.925   1.822  1.00 16.15           H  
ATOM    125 HD23 LEU A   7      -6.313  27.318   3.259  1.00 15.77           H  
ATOM    126  N   ASN A   8      -2.924  28.111   0.786  1.00 13.63           N  
ATOM    127  CA  ASN A   8      -3.240  27.310  -0.428  1.00 13.29           C  
ATOM    128  C   ASN A   8      -2.929  25.837  -0.158  1.00 12.82           C  
ATOM    129  O   ASN A   8      -2.216  25.503   0.767  1.00 12.84           O  
ATOM    130  CB  ASN A   8      -2.391  27.805  -1.600  1.00 13.45           C  
ATOM    131  CG  ASN A   8      -0.909  27.593  -1.279  1.00 13.72           C  
ATOM    132  OD1 ASN A   8      -0.567  27.149  -0.201  1.00 13.79           O  
ATOM    133  ND2 ASN A   8      -0.011  27.895  -2.175  1.00 14.06           N  
ATOM    134  H   ASN A   8      -2.294  27.763   1.450  1.00 13.76           H  
ATOM    135  HA  ASN A   8      -4.288  27.417  -0.672  1.00 13.46           H  
ATOM    136  HB2 ASN A   8      -2.649  27.254  -2.491  1.00 13.41           H  
ATOM    137  HB3 ASN A   8      -2.576  28.857  -1.760  1.00 13.62           H  
ATOM    138 HD21 ASN A   8      -0.286  28.254  -3.045  1.00 14.12           H  
ATOM    139 HD22 ASN A   8       0.940  27.764  -1.979  1.00 14.36           H  
ATOM    140  N   ALA A   9      -3.461  24.952  -0.959  1.00 12.57           N  
ATOM    141  CA  ALA A   9      -3.206  23.493  -0.755  1.00 12.28           C  
ATOM    142  C   ALA A   9      -2.057  23.035  -1.660  1.00 11.84           C  
ATOM    143  O   ALA A   9      -1.696  21.875  -1.676  1.00 12.04           O  
ATOM    144  CB  ALA A   9      -4.474  22.709  -1.104  1.00 12.50           C  
ATOM    145  H   ALA A   9      -4.034  25.247  -1.696  1.00 12.70           H  
ATOM    146  HA  ALA A   9      -2.944  23.307   0.278  1.00 12.43           H  
ATOM    147  HB1 ALA A   9      -5.336  23.224  -0.703  1.00 12.61           H  
ATOM    148  HB2 ALA A   9      -4.415  21.719  -0.678  1.00 12.61           H  
ATOM    149  HB3 ALA A   9      -4.569  22.633  -2.180  1.00 12.65           H  
ATOM    150  N   GLN A  10      -1.489  23.928  -2.425  1.00 11.42           N  
ATOM    151  CA  GLN A  10      -0.378  23.524  -3.336  1.00 11.16           C  
ATOM    152  C   GLN A  10       0.781  22.949  -2.516  1.00 10.55           C  
ATOM    153  O   GLN A  10       1.280  21.879  -2.804  1.00 10.61           O  
ATOM    154  CB  GLN A  10       0.101  24.753  -4.117  1.00 11.48           C  
ATOM    155  CG  GLN A  10       1.235  24.365  -5.075  1.00 11.97           C  
ATOM    156  CD  GLN A  10       1.696  25.606  -5.842  1.00 12.47           C  
ATOM    157  OE1 GLN A  10       1.831  26.671  -5.272  1.00 12.70           O  
ATOM    158  NE2 GLN A  10       1.950  25.514  -7.118  1.00 12.83           N  
ATOM    159  H   GLN A  10      -1.798  24.857  -2.410  1.00 11.41           H  
ATOM    160  HA  GLN A  10      -0.735  22.776  -4.027  1.00 11.39           H  
ATOM    161  HB2 GLN A  10      -0.722  25.161  -4.684  1.00 11.39           H  
ATOM    162  HB3 GLN A  10       0.462  25.499  -3.423  1.00 11.69           H  
ATOM    163  HG2 GLN A  10       2.066  23.964  -4.512  1.00 12.14           H  
ATOM    164  HG3 GLN A  10       0.880  23.624  -5.774  1.00 12.00           H  
ATOM    165 HE21 GLN A  10       1.844  24.656  -7.579  1.00 12.78           H  
ATOM    166 HE22 GLN A  10       2.247  26.305  -7.616  1.00 13.28           H  
ATOM    167  N   HIS A  11       1.212  23.640  -1.494  1.00 10.17           N  
ATOM    168  CA  HIS A  11       2.338  23.119  -0.662  1.00  9.77           C  
ATOM    169  C   HIS A  11       2.381  23.858   0.679  1.00  9.16           C  
ATOM    170  O   HIS A  11       1.866  24.950   0.821  1.00  9.25           O  
ATOM    171  CB  HIS A  11       3.668  23.323  -1.403  1.00 10.00           C  
ATOM    172  CG  HIS A  11       3.830  22.262  -2.461  1.00 10.27           C  
ATOM    173  ND1 HIS A  11       3.681  20.913  -2.180  1.00 10.64           N  
ATOM    174  CD2 HIS A  11       4.126  22.337  -3.799  1.00 10.49           C  
ATOM    175  CE1 HIS A  11       3.887  20.235  -3.325  1.00 11.05           C  
ATOM    176  NE2 HIS A  11       4.162  21.056  -4.341  1.00 10.99           N  
ATOM    177  H   HIS A  11       0.795  24.500  -1.272  1.00 10.30           H  
ATOM    178  HA  HIS A  11       2.185  22.065  -0.479  1.00 10.01           H  
ATOM    179  HB2 HIS A  11       3.675  24.297  -1.868  1.00  9.95           H  
ATOM    180  HB3 HIS A  11       4.487  23.253  -0.701  1.00 10.29           H  
ATOM    181  HD1 HIS A  11       3.465  20.523  -1.307  1.00 10.75           H  
ATOM    182  HD2 HIS A  11       4.305  23.249  -4.347  1.00 10.47           H  
ATOM    183  HE1 HIS A  11       3.836  19.160  -3.409  1.00 11.54           H  
ATOM    184  N   ASP A  12       3.002  23.264   1.662  1.00  8.78           N  
ATOM    185  CA  ASP A  12       3.099  23.912   3.000  1.00  8.41           C  
ATOM    186  C   ASP A  12       4.280  23.301   3.757  1.00  7.70           C  
ATOM    187  O   ASP A  12       4.997  22.473   3.234  1.00  7.84           O  
ATOM    188  CB  ASP A  12       1.806  23.676   3.784  1.00  8.97           C  
ATOM    189  CG  ASP A  12       1.584  22.174   3.966  1.00  9.57           C  
ATOM    190  OD1 ASP A  12       1.480  21.485   2.964  1.00 10.08           O  
ATOM    191  OD2 ASP A  12       1.525  21.738   5.104  1.00  9.72           O  
ATOM    192  H   ASP A  12       3.411  22.385   1.516  1.00  8.91           H  
ATOM    193  HA  ASP A  12       3.260  24.974   2.877  1.00  8.55           H  
ATOM    194  HB2 ASP A  12       1.881  24.150   4.752  1.00  8.94           H  
ATOM    195  HB3 ASP A  12       0.974  24.098   3.240  1.00  9.22           H  
ATOM    196  N   GLU A  13       4.494  23.695   4.983  1.00  7.20           N  
ATOM    197  CA  GLU A  13       5.633  23.120   5.751  1.00  6.75           C  
ATOM    198  C   GLU A  13       5.437  21.607   5.855  1.00  5.96           C  
ATOM    199  O   GLU A  13       6.369  20.839   5.727  1.00  6.13           O  
ATOM    200  CB  GLU A  13       5.672  23.734   7.152  1.00  7.22           C  
ATOM    201  CG  GLU A  13       6.096  25.201   7.055  1.00  7.84           C  
ATOM    202  CD  GLU A  13       6.135  25.815   8.455  1.00  8.59           C  
ATOM    203  OE1 GLU A  13       5.099  26.274   8.908  1.00  9.12           O  
ATOM    204  OE2 GLU A  13       7.199  25.817   9.051  1.00  8.85           O  
ATOM    205  H   GLU A  13       3.907  24.364   5.395  1.00  7.33           H  
ATOM    206  HA  GLU A  13       6.560  23.330   5.236  1.00  6.99           H  
ATOM    207  HB2 GLU A  13       4.690  23.671   7.600  1.00  7.19           H  
ATOM    208  HB3 GLU A  13       6.382  23.195   7.762  1.00  7.45           H  
ATOM    209  HG2 GLU A  13       7.077  25.262   6.606  1.00  7.97           H  
ATOM    210  HG3 GLU A  13       5.387  25.741   6.446  1.00  7.94           H  
ATOM    211  N   ALA A  14       4.222  21.173   6.068  1.00  5.44           N  
ATOM    212  CA  ALA A  14       3.949  19.708   6.158  1.00  4.96           C  
ATOM    213  C   ALA A  14       3.518  19.215   4.775  1.00  4.30           C  
ATOM    214  O   ALA A  14       2.621  19.763   4.170  1.00  4.43           O  
ATOM    215  CB  ALA A  14       2.820  19.458   7.162  1.00  5.39           C  
ATOM    216  H   ALA A  14       3.486  21.812   6.154  1.00  5.62           H  
ATOM    217  HA  ALA A  14       4.839  19.180   6.472  1.00  5.21           H  
ATOM    218  HB1 ALA A  14       1.912  19.918   6.805  1.00  5.65           H  
ATOM    219  HB2 ALA A  14       3.089  19.887   8.117  1.00  5.62           H  
ATOM    220  HB3 ALA A  14       2.667  18.395   7.275  1.00  5.65           H  
ATOM    221  N   VAL A  15       4.164  18.195   4.263  1.00  4.01           N  
ATOM    222  CA  VAL A  15       3.808  17.672   2.904  1.00  3.71           C  
ATOM    223  C   VAL A  15       3.716  16.145   2.935  1.00  3.13           C  
ATOM    224  O   VAL A  15       3.873  15.519   3.964  1.00  3.40           O  
ATOM    225  CB  VAL A  15       4.878  18.103   1.899  1.00  4.37           C  
ATOM    226  CG1 VAL A  15       4.733  19.599   1.613  1.00  5.04           C  
ATOM    227  CG2 VAL A  15       6.265  17.831   2.484  1.00  4.89           C  
ATOM    228  H   VAL A  15       4.894  17.779   4.768  1.00  4.29           H  
ATOM    229  HA  VAL A  15       2.851  18.071   2.593  1.00  3.88           H  
ATOM    230  HB  VAL A  15       4.754  17.546   0.981  1.00  4.55           H  
ATOM    231 HG11 VAL A  15       4.796  20.151   2.539  1.00  5.29           H  
ATOM    232 HG12 VAL A  15       5.525  19.917   0.951  1.00  5.46           H  
ATOM    233 HG13 VAL A  15       3.776  19.785   1.146  1.00  5.29           H  
ATOM    234 HG21 VAL A  15       6.301  16.824   2.871  1.00  5.21           H  
ATOM    235 HG22 VAL A  15       7.010  17.946   1.711  1.00  5.11           H  
ATOM    236 HG23 VAL A  15       6.463  18.530   3.282  1.00  5.16           H  
ATOM    237  N   ASP A  16       3.449  15.551   1.805  1.00  2.67           N  
ATOM    238  CA  ASP A  16       3.325  14.068   1.738  1.00  2.25           C  
ATOM    239  C   ASP A  16       4.635  13.407   2.174  1.00  2.00           C  
ATOM    240  O   ASP A  16       4.696  12.207   2.362  1.00  2.47           O  
ATOM    241  CB  ASP A  16       2.996  13.652   0.303  1.00  2.31           C  
ATOM    242  CG  ASP A  16       1.569  14.086  -0.039  1.00  2.96           C  
ATOM    243  OD1 ASP A  16       0.805  14.318   0.883  1.00  3.45           O  
ATOM    244  OD2 ASP A  16       1.266  14.182  -1.217  1.00  3.42           O  
ATOM    245  H   ASP A  16       3.317  16.085   0.995  1.00  2.88           H  
ATOM    246  HA  ASP A  16       2.526  13.747   2.394  1.00  2.44           H  
ATOM    247  HB2 ASP A  16       3.691  14.124  -0.377  1.00  2.32           H  
ATOM    248  HB3 ASP A  16       3.074  12.579   0.212  1.00  2.42           H  
ATOM    249  N   ALA A  17       5.685  14.168   2.332  1.00  1.74           N  
ATOM    250  CA  ALA A  17       6.983  13.562   2.750  1.00  1.64           C  
ATOM    251  C   ALA A  17       6.747  12.630   3.941  1.00  1.34           C  
ATOM    252  O   ALA A  17       7.008  11.446   3.874  1.00  1.86           O  
ATOM    253  CB  ALA A  17       7.962  14.668   3.154  1.00  2.03           C  
ATOM    254  H   ALA A  17       5.622  15.134   2.173  1.00  2.00           H  
ATOM    255  HA  ALA A  17       7.398  12.996   1.928  1.00  1.77           H  
ATOM    256  HB1 ALA A  17       8.064  15.371   2.342  1.00  2.24           H  
ATOM    257  HB2 ALA A  17       7.587  15.178   4.028  1.00  2.40           H  
ATOM    258  HB3 ALA A  17       8.925  14.232   3.376  1.00  2.41           H  
ATOM    259  N   ASN A  18       6.238  13.148   5.029  1.00  0.95           N  
ATOM    260  CA  ASN A  18       5.968  12.279   6.213  1.00  0.77           C  
ATOM    261  C   ASN A  18       4.549  11.723   6.109  1.00  0.65           C  
ATOM    262  O   ASN A  18       3.668  12.087   6.863  1.00  1.18           O  
ATOM    263  CB  ASN A  18       6.094  13.094   7.501  1.00  0.93           C  
ATOM    264  CG  ASN A  18       6.063  12.144   8.700  1.00  1.47           C  
ATOM    265  OD1 ASN A  18       6.986  11.381   8.908  1.00  2.24           O  
ATOM    266  ND2 ASN A  18       5.030  12.152   9.496  1.00  1.85           N  
ATOM    267  H   ASN A  18       6.020  14.104   5.062  1.00  1.25           H  
ATOM    268  HA  ASN A  18       6.676  11.456   6.236  1.00  0.92           H  
ATOM    269  HB2 ASN A  18       7.026  13.640   7.493  1.00  1.22           H  
ATOM    270  HB3 ASN A  18       5.269  13.786   7.572  1.00  1.25           H  
ATOM    271 HD21 ASN A  18       4.284  12.762   9.327  1.00  2.04           H  
ATOM    272 HD22 ASN A  18       4.999  11.542  10.265  1.00  2.38           H  
ATOM    273  N   SER A  19       4.328  10.840   5.181  1.00  0.49           N  
ATOM    274  CA  SER A  19       2.976  10.244   5.013  1.00  0.33           C  
ATOM    275  C   SER A  19       3.134   8.917   4.285  1.00  0.29           C  
ATOM    276  O   SER A  19       2.625   7.898   4.709  1.00  0.28           O  
ATOM    277  CB  SER A  19       2.095  11.181   4.188  1.00  0.41           C  
ATOM    278  OG  SER A  19       0.890  10.510   3.843  1.00  0.80           O  
ATOM    279  H   SER A  19       5.059  10.563   4.589  1.00  0.93           H  
ATOM    280  HA  SER A  19       2.527  10.076   5.982  1.00  0.41           H  
ATOM    281  HB2 SER A  19       1.859  12.057   4.767  1.00  0.66           H  
ATOM    282  HB3 SER A  19       2.625  11.474   3.293  1.00  0.81           H  
ATOM    283  HG  SER A  19       1.121   9.710   3.364  1.00  1.24           H  
ATOM    284  N   LEU A  20       3.859   8.913   3.200  1.00  0.31           N  
ATOM    285  CA  LEU A  20       4.069   7.641   2.468  1.00  0.32           C  
ATOM    286  C   LEU A  20       4.769   6.669   3.417  1.00  0.25           C  
ATOM    287  O   LEU A  20       4.466   5.499   3.462  1.00  0.23           O  
ATOM    288  CB  LEU A  20       4.962   7.890   1.246  1.00  0.41           C  
ATOM    289  CG  LEU A  20       4.279   8.867   0.278  1.00  0.45           C  
ATOM    290  CD1 LEU A  20       5.279   9.288  -0.805  1.00  0.99           C  
ATOM    291  CD2 LEU A  20       3.057   8.203  -0.381  1.00  1.09           C  
ATOM    292  H   LEU A  20       4.277   9.741   2.882  1.00  0.35           H  
ATOM    293  HA  LEU A  20       3.122   7.231   2.158  1.00  0.36           H  
ATOM    294  HB2 LEU A  20       5.902   8.311   1.573  1.00  0.49           H  
ATOM    295  HB3 LEU A  20       5.148   6.955   0.741  1.00  0.50           H  
ATOM    296  HG  LEU A  20       3.961   9.743   0.824  1.00  1.21           H  
ATOM    297 HD11 LEU A  20       5.780   8.413  -1.192  1.00  1.55           H  
ATOM    298 HD12 LEU A  20       4.753   9.787  -1.606  1.00  1.57           H  
ATOM    299 HD13 LEU A  20       6.008   9.962  -0.380  1.00  1.64           H  
ATOM    300 HD21 LEU A  20       3.275   7.169  -0.600  1.00  1.68           H  
ATOM    301 HD22 LEU A  20       2.213   8.260   0.290  1.00  1.72           H  
ATOM    302 HD23 LEU A  20       2.815   8.719  -1.301  1.00  1.60           H  
ATOM    303  N   ALA A  21       5.703   7.159   4.184  1.00  0.24           N  
ATOM    304  CA  ALA A  21       6.425   6.276   5.135  1.00  0.22           C  
ATOM    305  C   ALA A  21       5.437   5.656   6.125  1.00  0.18           C  
ATOM    306  O   ALA A  21       5.373   4.452   6.278  1.00  0.19           O  
ATOM    307  CB  ALA A  21       7.464   7.099   5.900  1.00  0.27           C  
ATOM    308  H   ALA A  21       5.929   8.108   4.136  1.00  0.28           H  
ATOM    309  HA  ALA A  21       6.919   5.493   4.585  1.00  0.25           H  
ATOM    310  HB1 ALA A  21       6.966   7.708   6.644  1.00  1.05           H  
ATOM    311  HB2 ALA A  21       7.994   7.740   5.213  1.00  1.05           H  
ATOM    312  HB3 ALA A  21       8.162   6.435   6.387  1.00  1.01           H  
ATOM    313  N   GLU A  22       4.666   6.462   6.802  1.00  0.18           N  
ATOM    314  CA  GLU A  22       3.693   5.896   7.775  1.00  0.19           C  
ATOM    315  C   GLU A  22       2.677   5.040   7.023  1.00  0.18           C  
ATOM    316  O   GLU A  22       2.302   3.972   7.461  1.00  0.21           O  
ATOM    317  CB  GLU A  22       2.974   7.035   8.502  1.00  0.24           C  
ATOM    318  CG  GLU A  22       2.026   6.461   9.554  1.00  0.50           C  
ATOM    319  CD  GLU A  22       1.334   7.603  10.298  1.00  0.68           C  
ATOM    320  OE1 GLU A  22       1.704   8.744  10.067  1.00  1.27           O  
ATOM    321  OE2 GLU A  22       0.447   7.320  11.085  1.00  1.15           O  
ATOM    322  H   GLU A  22       4.726   7.434   6.672  1.00  0.19           H  
ATOM    323  HA  GLU A  22       4.218   5.279   8.493  1.00  0.22           H  
ATOM    324  HB2 GLU A  22       3.701   7.674   8.980  1.00  0.41           H  
ATOM    325  HB3 GLU A  22       2.404   7.610   7.786  1.00  0.42           H  
ATOM    326  HG2 GLU A  22       1.281   5.846   9.070  1.00  0.61           H  
ATOM    327  HG3 GLU A  22       2.586   5.862  10.256  1.00  0.68           H  
ATOM    328  N   ALA A  23       2.233   5.502   5.886  1.00  0.18           N  
ATOM    329  CA  ALA A  23       1.248   4.713   5.101  1.00  0.19           C  
ATOM    330  C   ALA A  23       1.867   3.370   4.712  1.00  0.15           C  
ATOM    331  O   ALA A  23       1.259   2.329   4.854  1.00  0.16           O  
ATOM    332  CB  ALA A  23       0.864   5.488   3.838  1.00  0.23           C  
ATOM    333  H   ALA A  23       2.554   6.365   5.549  1.00  0.20           H  
ATOM    334  HA  ALA A  23       0.364   4.542   5.700  1.00  0.22           H  
ATOM    335  HB1 ALA A  23       1.666   5.420   3.116  1.00  1.04           H  
ATOM    336  HB2 ALA A  23       0.694   6.523   4.089  1.00  1.02           H  
ATOM    337  HB3 ALA A  23      -0.035   5.067   3.416  1.00  1.06           H  
ATOM    338  N   LYS A  24       3.078   3.388   4.224  1.00  0.15           N  
ATOM    339  CA  LYS A  24       3.738   2.115   3.830  1.00  0.18           C  
ATOM    340  C   LYS A  24       4.050   1.299   5.087  1.00  0.19           C  
ATOM    341  O   LYS A  24       3.900   0.093   5.109  1.00  0.26           O  
ATOM    342  CB  LYS A  24       5.031   2.434   3.078  1.00  0.22           C  
ATOM    343  CG  LYS A  24       4.691   3.031   1.709  1.00  0.21           C  
ATOM    344  CD  LYS A  24       5.986   3.360   0.966  1.00  0.27           C  
ATOM    345  CE  LYS A  24       5.657   3.956  -0.402  1.00  0.53           C  
ATOM    346  NZ  LYS A  24       6.900   4.501  -1.017  1.00  1.23           N  
ATOM    347  H   LYS A  24       3.556   4.241   4.122  1.00  0.17           H  
ATOM    348  HA  LYS A  24       3.077   1.551   3.191  1.00  0.19           H  
ATOM    349  HB2 LYS A  24       5.617   3.142   3.646  1.00  0.25           H  
ATOM    350  HB3 LYS A  24       5.600   1.525   2.936  1.00  0.27           H  
ATOM    351  HG2 LYS A  24       4.121   2.312   1.138  1.00  0.23           H  
ATOM    352  HG3 LYS A  24       4.110   3.929   1.833  1.00  0.20           H  
ATOM    353  HD2 LYS A  24       6.559   4.072   1.542  1.00  0.58           H  
ATOM    354  HD3 LYS A  24       6.561   2.459   0.834  1.00  0.64           H  
ATOM    355  HE2 LYS A  24       5.246   3.190  -1.040  1.00  0.57           H  
ATOM    356  HE3 LYS A  24       4.935   4.754  -0.285  1.00  0.82           H  
ATOM    357  HZ1 LYS A  24       7.558   4.793  -0.267  1.00  1.81           H  
ATOM    358  HZ2 LYS A  24       7.347   3.768  -1.601  1.00  1.57           H  
ATOM    359  HZ3 LYS A  24       6.661   5.322  -1.610  1.00  1.73           H  
ATOM    360  N   VAL A  25       4.486   1.946   6.136  1.00  0.19           N  
ATOM    361  CA  VAL A  25       4.805   1.203   7.389  1.00  0.23           C  
ATOM    362  C   VAL A  25       3.528   0.585   7.975  1.00  0.24           C  
ATOM    363  O   VAL A  25       3.521  -0.556   8.384  1.00  0.27           O  
ATOM    364  CB  VAL A  25       5.445   2.155   8.409  1.00  0.27           C  
ATOM    365  CG1 VAL A  25       5.546   1.464   9.777  1.00  0.34           C  
ATOM    366  CG2 VAL A  25       6.852   2.546   7.928  1.00  0.29           C  
ATOM    367  H   VAL A  25       4.601   2.918   6.101  1.00  0.20           H  
ATOM    368  HA  VAL A  25       5.502   0.418   7.160  1.00  0.26           H  
ATOM    369  HB  VAL A  25       4.834   3.040   8.499  1.00  0.27           H  
ATOM    370 HG11 VAL A  25       5.875   0.443   9.643  1.00  1.03           H  
ATOM    371 HG12 VAL A  25       6.254   1.992  10.399  1.00  1.08           H  
ATOM    372 HG13 VAL A  25       4.577   1.469  10.254  1.00  1.07           H  
ATOM    373 HG21 VAL A  25       6.843   2.703   6.859  1.00  1.06           H  
ATOM    374 HG22 VAL A  25       7.161   3.457   8.421  1.00  1.02           H  
ATOM    375 HG23 VAL A  25       7.550   1.754   8.167  1.00  1.01           H  
ATOM    376  N   LEU A  26       2.454   1.329   8.031  1.00  0.22           N  
ATOM    377  CA  LEU A  26       1.191   0.772   8.603  1.00  0.25           C  
ATOM    378  C   LEU A  26       0.642  -0.328   7.690  1.00  0.23           C  
ATOM    379  O   LEU A  26       0.140  -1.334   8.147  1.00  0.28           O  
ATOM    380  CB  LEU A  26       0.142   1.883   8.751  1.00  0.26           C  
ATOM    381  CG  LEU A  26       0.549   2.870   9.857  1.00  0.31           C  
ATOM    382  CD1 LEU A  26      -0.486   3.999   9.913  1.00  0.73           C  
ATOM    383  CD2 LEU A  26       0.612   2.159  11.225  1.00  0.78           C  
ATOM    384  H   LEU A  26       2.478   2.252   7.701  1.00  0.20           H  
ATOM    385  HA  LEU A  26       1.400   0.343   9.567  1.00  0.29           H  
ATOM    386  HB2 LEU A  26       0.056   2.418   7.816  1.00  0.29           H  
ATOM    387  HB3 LEU A  26      -0.810   1.443   9.001  1.00  0.23           H  
ATOM    388  HG  LEU A  26       1.518   3.288   9.621  1.00  0.68           H  
ATOM    389 HD11 LEU A  26      -0.587   4.445   8.935  1.00  1.42           H  
ATOM    390 HD12 LEU A  26      -1.438   3.598  10.225  1.00  1.25           H  
ATOM    391 HD13 LEU A  26      -0.164   4.749  10.621  1.00  1.36           H  
ATOM    392 HD21 LEU A  26      -0.119   1.363  11.260  1.00  1.38           H  
ATOM    393 HD22 LEU A  26       1.601   1.746  11.370  1.00  1.40           H  
ATOM    394 HD23 LEU A  26       0.407   2.867  12.017  1.00  1.38           H  
ATOM    395  N   ALA A  27       0.712  -0.146   6.404  1.00  0.18           N  
ATOM    396  CA  ALA A  27       0.183  -1.191   5.484  1.00  0.18           C  
ATOM    397  C   ALA A  27       1.126  -2.403   5.472  1.00  0.16           C  
ATOM    398  O   ALA A  27       0.695  -3.537   5.425  1.00  0.19           O  
ATOM    399  CB  ALA A  27       0.076  -0.613   4.072  1.00  0.20           C  
ATOM    400  H   ALA A  27       1.107   0.675   6.043  1.00  0.16           H  
ATOM    401  HA  ALA A  27      -0.796  -1.501   5.818  1.00  0.22           H  
ATOM    402  HB1 ALA A  27      -0.507   0.295   4.098  1.00  1.03           H  
ATOM    403  HB2 ALA A  27       1.065  -0.395   3.697  1.00  1.02           H  
ATOM    404  HB3 ALA A  27      -0.405  -1.332   3.424  1.00  1.02           H  
ATOM    405  N   ASN A  28       2.409  -2.161   5.485  1.00  0.15           N  
ATOM    406  CA  ASN A  28       3.396  -3.283   5.441  1.00  0.14           C  
ATOM    407  C   ASN A  28       3.272  -4.199   6.670  1.00  0.15           C  
ATOM    408  O   ASN A  28       3.372  -5.404   6.556  1.00  0.18           O  
ATOM    409  CB  ASN A  28       4.811  -2.696   5.387  1.00  0.15           C  
ATOM    410  CG  ASN A  28       5.840  -3.826   5.306  1.00  0.17           C  
ATOM    411  OD1 ASN A  28       5.701  -4.843   5.959  1.00  0.22           O  
ATOM    412  ND2 ASN A  28       6.871  -3.694   4.518  1.00  0.22           N  
ATOM    413  H   ASN A  28       2.727  -1.235   5.502  1.00  0.16           H  
ATOM    414  HA  ASN A  28       3.228  -3.867   4.550  1.00  0.16           H  
ATOM    415  HB2 ASN A  28       4.902  -2.063   4.516  1.00  0.16           H  
ATOM    416  HB3 ASN A  28       4.990  -2.112   6.278  1.00  0.17           H  
ATOM    417 HD21 ASN A  28       6.980  -2.877   3.986  1.00  0.28           H  
ATOM    418 HD22 ASN A  28       7.539  -4.410   4.458  1.00  0.24           H  
ATOM    419  N   ARG A  29       3.086  -3.654   7.844  1.00  0.18           N  
ATOM    420  CA  ARG A  29       2.992  -4.531   9.053  1.00  0.22           C  
ATOM    421  C   ARG A  29       1.802  -5.487   8.933  1.00  0.19           C  
ATOM    422  O   ARG A  29       1.867  -6.620   9.366  1.00  0.21           O  
ATOM    423  CB  ARG A  29       2.850  -3.683  10.321  1.00  0.31           C  
ATOM    424  CG  ARG A  29       1.724  -2.669  10.147  1.00  1.18           C  
ATOM    425  CD  ARG A  29       1.563  -1.858  11.434  1.00  1.46           C  
ATOM    426  NE  ARG A  29       1.231  -2.777  12.559  1.00  2.22           N  
ATOM    427  CZ  ARG A  29       1.327  -2.362  13.792  1.00  2.79           C  
ATOM    428  NH1 ARG A  29       1.724  -1.146  14.044  1.00  2.95           N  
ATOM    429  NH2 ARG A  29       1.028  -3.168  14.775  1.00  3.73           N  
ATOM    430  H   ARG A  29       3.026  -2.680   7.933  1.00  0.22           H  
ATOM    431  HA  ARG A  29       3.898  -5.115   9.125  1.00  0.26           H  
ATOM    432  HB2 ARG A  29       2.628  -4.327  11.159  1.00  0.93           H  
ATOM    433  HB3 ARG A  29       3.776  -3.158  10.507  1.00  0.98           H  
ATOM    434  HG2 ARG A  29       1.969  -2.008   9.335  1.00  1.75           H  
ATOM    435  HG3 ARG A  29       0.802  -3.186   9.930  1.00  1.72           H  
ATOM    436  HD2 ARG A  29       2.486  -1.340  11.652  1.00  1.82           H  
ATOM    437  HD3 ARG A  29       0.767  -1.137  11.309  1.00  1.68           H  
ATOM    438  HE  ARG A  29       0.937  -3.692  12.371  1.00  2.75           H  
ATOM    439 HH11 ARG A  29       1.955  -0.529  13.291  1.00  4.08           H  
ATOM    440 HH12 ARG A  29       1.797  -0.829  14.990  1.00  4.29           H  
ATOM    441 HH21 ARG A  29       0.725  -4.102  14.582  1.00  2.68           H  
ATOM    442 HH22 ARG A  29       1.100  -2.852  15.721  1.00  3.70           H  
ATOM    443  N   GLU A  30       0.714  -5.051   8.358  1.00  0.21           N  
ATOM    444  CA  GLU A  30      -0.461  -5.960   8.232  1.00  0.28           C  
ATOM    445  C   GLU A  30      -0.064  -7.190   7.414  1.00  0.27           C  
ATOM    446  O   GLU A  30      -0.435  -8.303   7.727  1.00  0.33           O  
ATOM    447  CB  GLU A  30      -1.602  -5.225   7.524  1.00  0.37           C  
ATOM    448  CG  GLU A  30      -2.165  -4.141   8.446  1.00  0.60           C  
ATOM    449  CD  GLU A  30      -2.869  -4.797   9.636  1.00  0.64           C  
ATOM    450  OE1 GLU A  30      -3.246  -5.951   9.512  1.00  1.33           O  
ATOM    451  OE2 GLU A  30      -3.011  -4.137  10.651  1.00  1.39           O  
ATOM    452  H   GLU A  30       0.670  -4.133   8.014  1.00  0.23           H  
ATOM    453  HA  GLU A  30      -0.785  -6.272   9.215  1.00  0.33           H  
ATOM    454  HB2 GLU A  30      -1.226  -4.768   6.619  1.00  0.86           H  
ATOM    455  HB3 GLU A  30      -2.384  -5.926   7.275  1.00  0.74           H  
ATOM    456  HG2 GLU A  30      -1.357  -3.517   8.802  1.00  1.19           H  
ATOM    457  HG3 GLU A  30      -2.873  -3.539   7.900  1.00  1.37           H  
ATOM    458  N   LEU A  31       0.704  -6.995   6.382  1.00  0.23           N  
ATOM    459  CA  LEU A  31       1.145  -8.149   5.547  1.00  0.28           C  
ATOM    460  C   LEU A  31       1.926  -9.103   6.436  1.00  0.32           C  
ATOM    461  O   LEU A  31       1.677 -10.291   6.482  1.00  0.43           O  
ATOM    462  CB  LEU A  31       2.061  -7.634   4.434  1.00  0.26           C  
ATOM    463  CG  LEU A  31       1.474  -6.355   3.841  1.00  0.25           C  
ATOM    464  CD1 LEU A  31       2.283  -5.956   2.611  1.00  0.27           C  
ATOM    465  CD2 LEU A  31       0.012  -6.583   3.437  1.00  0.33           C  
ATOM    466  H   LEU A  31       1.000  -6.092   6.163  1.00  0.21           H  
ATOM    467  HA  LEU A  31       0.289  -8.654   5.121  1.00  0.33           H  
ATOM    468  HB2 LEU A  31       3.041  -7.421   4.840  1.00  0.31           H  
ATOM    469  HB3 LEU A  31       2.147  -8.380   3.662  1.00  0.25           H  
ATOM    470  HG  LEU A  31       1.536  -5.567   4.579  1.00  0.24           H  
ATOM    471 HD11 LEU A  31       2.303  -6.779   1.912  1.00  1.04           H  
ATOM    472 HD12 LEU A  31       1.828  -5.097   2.143  1.00  1.05           H  
ATOM    473 HD13 LEU A  31       3.289  -5.712   2.913  1.00  1.05           H  
ATOM    474 HD21 LEU A  31      -0.067  -7.496   2.864  1.00  1.10           H  
ATOM    475 HD22 LEU A  31      -0.602  -6.662   4.323  1.00  1.03           H  
ATOM    476 HD23 LEU A  31      -0.330  -5.749   2.838  1.00  1.07           H  
ATOM    477  N   ASP A  32       2.864  -8.566   7.152  1.00  0.28           N  
ATOM    478  CA  ASP A  32       3.680  -9.389   8.068  1.00  0.35           C  
ATOM    479  C   ASP A  32       2.751 -10.039   9.095  1.00  0.42           C  
ATOM    480  O   ASP A  32       2.902 -11.192   9.448  1.00  0.54           O  
ATOM    481  CB  ASP A  32       4.675  -8.460   8.765  1.00  0.38           C  
ATOM    482  CG  ASP A  32       5.859  -8.165   7.836  1.00  0.54           C  
ATOM    483  OD1 ASP A  32       6.049  -8.907   6.887  1.00  1.14           O  
ATOM    484  OD2 ASP A  32       6.558  -7.198   8.093  1.00  1.12           O  
ATOM    485  H   ASP A  32       3.025  -7.601   7.094  1.00  0.24           H  
ATOM    486  HA  ASP A  32       4.204 -10.151   7.516  1.00  0.36           H  
ATOM    487  HB2 ASP A  32       4.172  -7.529   8.999  1.00  0.40           H  
ATOM    488  HB3 ASP A  32       5.031  -8.919   9.674  1.00  0.34           H  
ATOM    489  N   LYS A  33       1.779  -9.307   9.561  1.00  0.38           N  
ATOM    490  CA  LYS A  33       0.822  -9.874  10.545  1.00  0.46           C  
ATOM    491  C   LYS A  33       0.095 -11.066   9.911  1.00  0.42           C  
ATOM    492  O   LYS A  33       0.019 -12.135  10.483  1.00  0.46           O  
ATOM    493  CB  LYS A  33      -0.182  -8.787  10.936  1.00  0.58           C  
ATOM    494  CG  LYS A  33      -1.168  -9.329  11.970  1.00  0.74           C  
ATOM    495  CD  LYS A  33      -2.157  -8.226  12.342  1.00  1.34           C  
ATOM    496  CE  LYS A  33      -3.146  -8.759  13.374  1.00  1.16           C  
ATOM    497  NZ  LYS A  33      -2.400  -9.277  14.556  1.00  1.78           N  
ATOM    498  H   LYS A  33       1.671  -8.384   9.251  1.00  0.32           H  
ATOM    499  HA  LYS A  33       1.358 -10.202  11.424  1.00  0.51           H  
ATOM    500  HB2 LYS A  33       0.349  -7.945  11.357  1.00  0.84           H  
ATOM    501  HB3 LYS A  33      -0.724  -8.468  10.060  1.00  0.83           H  
ATOM    502  HG2 LYS A  33      -1.705 -10.170  11.554  1.00  1.03           H  
ATOM    503  HG3 LYS A  33      -0.633  -9.642  12.853  1.00  1.27           H  
ATOM    504  HD2 LYS A  33      -1.618  -7.386  12.757  1.00  2.10           H  
ATOM    505  HD3 LYS A  33      -2.694  -7.911  11.459  1.00  1.88           H  
ATOM    506  HE2 LYS A  33      -3.805  -7.963  13.684  1.00  1.11           H  
ATOM    507  HE3 LYS A  33      -3.726  -9.557  12.935  1.00  1.43           H  
ATOM    508  HZ1 LYS A  33      -1.526  -8.725  14.682  1.00  2.20           H  
ATOM    509  HZ2 LYS A  33      -2.991  -9.191  15.405  1.00  2.19           H  
ATOM    510  HZ3 LYS A  33      -2.159 -10.276  14.403  1.00  2.13           H  
ATOM    511  N   TYR A  34      -0.432 -10.892   8.724  1.00  0.36           N  
ATOM    512  CA  TYR A  34      -1.145 -12.015   8.046  1.00  0.37           C  
ATOM    513  C   TYR A  34      -0.139 -13.087   7.622  1.00  0.33           C  
ATOM    514  O   TYR A  34      -0.432 -14.265   7.640  1.00  0.55           O  
ATOM    515  CB  TYR A  34      -1.885 -11.497   6.807  1.00  0.40           C  
ATOM    516  CG  TYR A  34      -3.057 -10.638   7.229  1.00  0.59           C  
ATOM    517  CD1 TYR A  34      -4.124 -11.213   7.932  1.00  1.10           C  
ATOM    518  CD2 TYR A  34      -3.080  -9.270   6.920  1.00  1.03           C  
ATOM    519  CE1 TYR A  34      -5.211 -10.423   8.326  1.00  1.25           C  
ATOM    520  CE2 TYR A  34      -4.168  -8.481   7.314  1.00  1.16           C  
ATOM    521  CZ  TYR A  34      -5.234  -9.059   8.017  1.00  0.99           C  
ATOM    522  OH  TYR A  34      -6.304  -8.281   8.405  1.00  1.20           O  
ATOM    523  H   TYR A  34      -0.353 -10.022   8.280  1.00  0.34           H  
ATOM    524  HA  TYR A  34      -1.857 -12.450   8.731  1.00  0.44           H  
ATOM    525  HB2 TYR A  34      -1.206 -10.914   6.203  1.00  0.43           H  
ATOM    526  HB3 TYR A  34      -2.245 -12.336   6.231  1.00  0.35           H  
ATOM    527  HD1 TYR A  34      -4.110 -12.265   8.169  1.00  1.60           H  
ATOM    528  HD2 TYR A  34      -2.262  -8.825   6.375  1.00  1.53           H  
ATOM    529  HE1 TYR A  34      -6.032 -10.867   8.868  1.00  1.79           H  
ATOM    530  HE2 TYR A  34      -4.187  -7.429   7.077  1.00  1.68           H  
ATOM    531  HH  TYR A  34      -6.113  -7.929   9.278  1.00  1.50           H  
ATOM    532  N   GLY A  35       1.043 -12.689   7.231  1.00  0.24           N  
ATOM    533  CA  GLY A  35       2.065 -13.687   6.797  1.00  0.31           C  
ATOM    534  C   GLY A  35       1.934 -13.935   5.293  1.00  0.31           C  
ATOM    535  O   GLY A  35       2.241 -15.003   4.802  1.00  0.36           O  
ATOM    536  H   GLY A  35       1.256 -11.732   7.217  1.00  0.35           H  
ATOM    537  HA2 GLY A  35       3.052 -13.305   7.013  1.00  0.36           H  
ATOM    538  HA3 GLY A  35       1.916 -14.617   7.327  1.00  0.38           H  
ATOM    539  N   VAL A  36       1.482 -12.958   4.556  1.00  0.33           N  
ATOM    540  CA  VAL A  36       1.336 -13.141   3.088  1.00  0.38           C  
ATOM    541  C   VAL A  36       2.728 -13.194   2.449  1.00  0.42           C  
ATOM    542  O   VAL A  36       3.731 -13.189   3.136  1.00  0.45           O  
ATOM    543  CB  VAL A  36       0.526 -11.981   2.508  1.00  0.41           C  
ATOM    544  CG1 VAL A  36      -0.897 -12.033   3.067  1.00  0.71           C  
ATOM    545  CG2 VAL A  36       1.172 -10.651   2.895  1.00  0.66           C  
ATOM    546  H   VAL A  36       1.240 -12.103   4.968  1.00  0.37           H  
ATOM    547  HA  VAL A  36       0.821 -14.065   2.894  1.00  0.43           H  
ATOM    548  HB  VAL A  36       0.492 -12.068   1.436  1.00  0.68           H  
ATOM    549 HG11 VAL A  36      -0.860 -12.060   4.146  1.00  1.33           H  
ATOM    550 HG12 VAL A  36      -1.442 -11.159   2.746  1.00  1.26           H  
ATOM    551 HG13 VAL A  36      -1.393 -12.920   2.702  1.00  1.31           H  
ATOM    552 HG21 VAL A  36       1.201 -10.562   3.971  1.00  1.22           H  
ATOM    553 HG22 VAL A  36       2.177 -10.611   2.502  1.00  1.33           H  
ATOM    554 HG23 VAL A  36       0.595  -9.837   2.483  1.00  1.26           H  
ATOM    555  N   SER A  37       2.806 -13.264   1.147  1.00  0.55           N  
ATOM    556  CA  SER A  37       4.145 -13.337   0.490  1.00  0.64           C  
ATOM    557  C   SER A  37       4.868 -11.997   0.632  1.00  0.50           C  
ATOM    558  O   SER A  37       4.259 -10.976   0.877  1.00  0.93           O  
ATOM    559  CB  SER A  37       3.968 -13.664  -0.995  1.00  0.96           C  
ATOM    560  OG  SER A  37       3.379 -12.551  -1.653  1.00  1.56           O  
ATOM    561  H   SER A  37       1.991 -13.280   0.606  1.00  0.65           H  
ATOM    562  HA  SER A  37       4.731 -14.114   0.958  1.00  0.73           H  
ATOM    563  HB2 SER A  37       4.930 -13.870  -1.437  1.00  1.48           H  
ATOM    564  HB3 SER A  37       3.334 -14.534  -1.098  1.00  1.26           H  
ATOM    565  HG  SER A  37       3.606 -11.760  -1.157  1.00  1.81           H  
ATOM    566  N   ASP A  38       6.167 -11.997   0.481  1.00  0.43           N  
ATOM    567  CA  ASP A  38       6.936 -10.726   0.608  1.00  0.37           C  
ATOM    568  C   ASP A  38       6.884  -9.966  -0.718  1.00  0.54           C  
ATOM    569  O   ASP A  38       7.395  -8.873  -0.845  1.00  1.41           O  
ATOM    570  CB  ASP A  38       8.392 -11.045   0.953  1.00  0.53           C  
ATOM    571  CG  ASP A  38       9.014 -11.865  -0.180  1.00  1.52           C  
ATOM    572  OD1 ASP A  38       8.262 -12.416  -0.966  1.00  2.35           O  
ATOM    573  OD2 ASP A  38      10.230 -11.928  -0.239  1.00  2.16           O  
ATOM    574  H   ASP A  38       6.636 -12.834   0.285  1.00  0.81           H  
ATOM    575  HA  ASP A  38       6.503 -10.116   1.391  1.00  0.36           H  
ATOM    576  HB2 ASP A  38       8.942 -10.123   1.076  1.00  1.18           H  
ATOM    577  HB3 ASP A  38       8.429 -11.613   1.870  1.00  1.10           H  
ATOM    578  N   TYR A  39       6.268 -10.534  -1.710  1.00  0.42           N  
ATOM    579  CA  TYR A  39       6.180  -9.831  -3.016  1.00  0.33           C  
ATOM    580  C   TYR A  39       5.249  -8.620  -2.869  1.00  0.25           C  
ATOM    581  O   TYR A  39       5.490  -7.563  -3.418  1.00  0.26           O  
ATOM    582  CB  TYR A  39       5.619 -10.794  -4.066  1.00  0.44           C  
ATOM    583  CG  TYR A  39       5.294 -10.034  -5.328  1.00  0.57           C  
ATOM    584  CD1 TYR A  39       4.052  -9.405  -5.449  1.00  1.35           C  
ATOM    585  CD2 TYR A  39       6.228  -9.953  -6.366  1.00  1.19           C  
ATOM    586  CE1 TYR A  39       3.739  -8.692  -6.607  1.00  1.51           C  
ATOM    587  CE2 TYR A  39       5.915  -9.240  -7.529  1.00  1.30           C  
ATOM    588  CZ  TYR A  39       4.670  -8.608  -7.650  1.00  1.02           C  
ATOM    589  OH  TYR A  39       4.361  -7.903  -8.797  1.00  1.27           O  
ATOM    590  H   TYR A  39       5.857 -11.416  -1.597  1.00  1.08           H  
ATOM    591  HA  TYR A  39       7.162  -9.499  -3.316  1.00  0.44           H  
ATOM    592  HB2 TYR A  39       6.353 -11.556  -4.285  1.00  0.48           H  
ATOM    593  HB3 TYR A  39       4.720 -11.257  -3.687  1.00  0.53           H  
ATOM    594  HD1 TYR A  39       3.334  -9.469  -4.645  1.00  2.08           H  
ATOM    595  HD2 TYR A  39       7.187 -10.440  -6.271  1.00  1.93           H  
ATOM    596  HE1 TYR A  39       2.781  -8.208  -6.695  1.00  2.29           H  
ATOM    597  HE2 TYR A  39       6.634  -9.176  -8.332  1.00  2.02           H  
ATOM    598  HH  TYR A  39       4.315  -8.527  -9.524  1.00  1.47           H  
ATOM    599  N   TYR A  40       4.177  -8.783  -2.145  1.00  0.25           N  
ATOM    600  CA  TYR A  40       3.202  -7.670  -1.963  1.00  0.23           C  
ATOM    601  C   TYR A  40       3.816  -6.528  -1.139  1.00  0.19           C  
ATOM    602  O   TYR A  40       3.581  -5.370  -1.420  1.00  0.19           O  
ATOM    603  CB  TYR A  40       1.965  -8.201  -1.234  1.00  0.29           C  
ATOM    604  CG  TYR A  40       1.245  -9.196  -2.118  1.00  0.29           C  
ATOM    605  CD1 TYR A  40       0.631  -8.765  -3.301  1.00  0.66           C  
ATOM    606  CD2 TYR A  40       1.190 -10.549  -1.756  1.00  0.80           C  
ATOM    607  CE1 TYR A  40      -0.035  -9.686  -4.120  1.00  0.76           C  
ATOM    608  CE2 TYR A  40       0.524 -11.468  -2.576  1.00  0.94           C  
ATOM    609  CZ  TYR A  40      -0.087 -11.037  -3.757  1.00  0.70           C  
ATOM    610  OH  TYR A  40      -0.744 -11.944  -4.564  1.00  0.93           O  
ATOM    611  H   TYR A  40       4.002  -9.652  -1.733  1.00  0.31           H  
ATOM    612  HA  TYR A  40       2.908  -7.293  -2.931  1.00  0.23           H  
ATOM    613  HB2 TYR A  40       2.269  -8.684  -0.316  1.00  0.42           H  
ATOM    614  HB3 TYR A  40       1.304  -7.380  -1.006  1.00  0.41           H  
ATOM    615  HD1 TYR A  40       0.672  -7.723  -3.583  1.00  1.09           H  
ATOM    616  HD2 TYR A  40       1.661 -10.884  -0.843  1.00  1.22           H  
ATOM    617  HE1 TYR A  40      -0.507  -9.355  -5.034  1.00  1.17           H  
ATOM    618  HE2 TYR A  40       0.482 -12.510  -2.294  1.00  1.42           H  
ATOM    619  HH  TYR A  40      -0.082 -12.453  -5.038  1.00  1.35           H  
ATOM    620  N   LYS A  41       4.585  -6.825  -0.122  1.00  0.18           N  
ATOM    621  CA  LYS A  41       5.170  -5.723   0.691  1.00  0.17           C  
ATOM    622  C   LYS A  41       6.174  -4.959  -0.162  1.00  0.16           C  
ATOM    623  O   LYS A  41       6.299  -3.755  -0.065  1.00  0.17           O  
ATOM    624  CB  LYS A  41       5.820  -6.285   1.978  1.00  0.22           C  
ATOM    625  CG  LYS A  41       7.181  -6.949   1.705  1.00  0.79           C  
ATOM    626  CD  LYS A  41       7.874  -7.260   3.039  1.00  1.17           C  
ATOM    627  CE  LYS A  41       6.951  -8.094   3.934  1.00  1.68           C  
ATOM    628  NZ  LYS A  41       7.765  -8.804   4.961  1.00  2.14           N  
ATOM    629  H   LYS A  41       4.770  -7.757   0.105  1.00  0.20           H  
ATOM    630  HA  LYS A  41       4.376  -5.045   0.968  1.00  0.17           H  
ATOM    631  HB2 LYS A  41       5.957  -5.483   2.686  1.00  0.70           H  
ATOM    632  HB3 LYS A  41       5.154  -7.022   2.405  1.00  0.66           H  
ATOM    633  HG2 LYS A  41       7.026  -7.864   1.166  1.00  1.12           H  
ATOM    634  HG3 LYS A  41       7.814  -6.294   1.131  1.00  1.19           H  
ATOM    635  HD2 LYS A  41       8.783  -7.811   2.848  1.00  1.83           H  
ATOM    636  HD3 LYS A  41       8.116  -6.335   3.540  1.00  1.60           H  
ATOM    637  HE2 LYS A  41       6.244  -7.443   4.427  1.00  2.05           H  
ATOM    638  HE3 LYS A  41       6.417  -8.817   3.335  1.00  2.27           H  
ATOM    639  HZ1 LYS A  41       8.451  -9.426   4.489  1.00  2.47           H  
ATOM    640  HZ2 LYS A  41       8.273  -8.109   5.541  1.00  2.55           H  
ATOM    641  HZ3 LYS A  41       7.138  -9.373   5.567  1.00  2.42           H  
ATOM    642  N   ASN A  42       6.884  -5.648  -1.009  1.00  0.19           N  
ATOM    643  CA  ASN A  42       7.863  -4.951  -1.877  1.00  0.21           C  
ATOM    644  C   ASN A  42       7.097  -4.041  -2.837  1.00  0.18           C  
ATOM    645  O   ASN A  42       7.498  -2.926  -3.111  1.00  0.19           O  
ATOM    646  CB  ASN A  42       8.672  -5.977  -2.673  1.00  0.25           C  
ATOM    647  CG  ASN A  42       9.607  -6.738  -1.731  1.00  0.32           C  
ATOM    648  OD1 ASN A  42       9.614  -7.953  -1.713  1.00  1.12           O  
ATOM    649  ND2 ASN A  42      10.406  -6.071  -0.943  1.00  1.16           N  
ATOM    650  H   ASN A  42       6.761  -6.617  -1.082  1.00  0.22           H  
ATOM    651  HA  ASN A  42       8.522  -4.361  -1.262  1.00  0.22           H  
ATOM    652  HB2 ASN A  42       7.998  -6.674  -3.149  1.00  0.26           H  
ATOM    653  HB3 ASN A  42       9.256  -5.469  -3.424  1.00  0.25           H  
ATOM    654 HD21 ASN A  42      10.402  -5.090  -0.958  1.00  1.97           H  
ATOM    655 HD22 ASN A  42      11.009  -6.550  -0.337  1.00  1.18           H  
ATOM    656  N   LEU A  43       5.988  -4.511  -3.341  1.00  0.16           N  
ATOM    657  CA  LEU A  43       5.177  -3.683  -4.277  1.00  0.16           C  
ATOM    658  C   LEU A  43       4.738  -2.397  -3.569  1.00  0.14           C  
ATOM    659  O   LEU A  43       4.753  -1.328  -4.146  1.00  0.17           O  
ATOM    660  CB  LEU A  43       3.956  -4.492  -4.736  1.00  0.17           C  
ATOM    661  CG  LEU A  43       3.091  -3.670  -5.705  1.00  0.20           C  
ATOM    662  CD1 LEU A  43       3.928  -3.209  -6.913  1.00  0.63           C  
ATOM    663  CD2 LEU A  43       1.921  -4.540  -6.195  1.00  0.63           C  
ATOM    664  H   LEU A  43       5.685  -5.410  -3.098  1.00  0.16           H  
ATOM    665  HA  LEU A  43       5.785  -3.431  -5.132  1.00  0.19           H  
ATOM    666  HB2 LEU A  43       4.292  -5.389  -5.232  1.00  0.16           H  
ATOM    667  HB3 LEU A  43       3.364  -4.762  -3.873  1.00  0.18           H  
ATOM    668  HG  LEU A  43       2.704  -2.805  -5.189  1.00  0.41           H  
ATOM    669 HD11 LEU A  43       4.639  -3.976  -7.178  1.00  1.28           H  
ATOM    670 HD12 LEU A  43       3.277  -3.017  -7.757  1.00  1.21           H  
ATOM    671 HD13 LEU A  43       4.456  -2.302  -6.659  1.00  1.32           H  
ATOM    672 HD21 LEU A  43       1.534  -5.127  -5.375  1.00  1.26           H  
ATOM    673 HD22 LEU A  43       1.138  -3.904  -6.581  1.00  1.26           H  
ATOM    674 HD23 LEU A  43       2.266  -5.201  -6.978  1.00  1.26           H  
ATOM    675  N   ILE A  44       4.367  -2.486  -2.318  1.00  0.13           N  
ATOM    676  CA  ILE A  44       3.951  -1.258  -1.578  1.00  0.13           C  
ATOM    677  C   ILE A  44       5.127  -0.280  -1.567  1.00  0.14           C  
ATOM    678  O   ILE A  44       4.968   0.905  -1.781  1.00  0.15           O  
ATOM    679  CB  ILE A  44       3.571  -1.633  -0.134  1.00  0.16           C  
ATOM    680  CG1 ILE A  44       2.247  -2.433  -0.124  1.00  0.33           C  
ATOM    681  CG2 ILE A  44       3.438  -0.364   0.725  1.00  0.14           C  
ATOM    682  CD1 ILE A  44       1.032  -1.491  -0.126  1.00  0.38           C  
ATOM    683  H   ILE A  44       4.375  -3.353  -1.863  1.00  0.12           H  
ATOM    684  HA  ILE A  44       3.109  -0.804  -2.076  1.00  0.17           H  
ATOM    685  HB  ILE A  44       4.358  -2.249   0.281  1.00  0.20           H  
ATOM    686 HG12 ILE A  44       2.203  -3.070  -0.997  1.00  0.78           H  
ATOM    687 HG13 ILE A  44       2.213  -3.050   0.763  1.00  0.78           H  
ATOM    688 HG21 ILE A  44       2.944   0.408   0.155  1.00  1.01           H  
ATOM    689 HG22 ILE A  44       2.860  -0.585   1.609  1.00  1.00           H  
ATOM    690 HG23 ILE A  44       4.421  -0.023   1.016  1.00  1.02           H  
ATOM    691 HD11 ILE A  44       1.223  -0.647  -0.769  1.00  1.13           H  
ATOM    692 HD12 ILE A  44       0.161  -2.023  -0.478  1.00  1.15           H  
ATOM    693 HD13 ILE A  44       0.852  -1.139   0.879  1.00  1.16           H  
ATOM    694  N   ASN A  45       6.308  -0.774  -1.328  1.00  0.15           N  
ATOM    695  CA  ASN A  45       7.502   0.111  -1.311  1.00  0.19           C  
ATOM    696  C   ASN A  45       7.538   0.947  -2.596  1.00  0.20           C  
ATOM    697  O   ASN A  45       8.036   2.055  -2.615  1.00  0.28           O  
ATOM    698  CB  ASN A  45       8.763  -0.752  -1.230  1.00  0.22           C  
ATOM    699  CG  ASN A  45       9.978   0.138  -0.962  1.00  0.65           C  
ATOM    700  OD1 ASN A  45       9.835   1.272  -0.547  1.00  1.46           O  
ATOM    701  ND2 ASN A  45      11.175  -0.331  -1.181  1.00  0.94           N  
ATOM    702  H   ASN A  45       6.411  -1.733  -1.159  1.00  0.15           H  
ATOM    703  HA  ASN A  45       7.457   0.764  -0.455  1.00  0.21           H  
ATOM    704  HB2 ASN A  45       8.658  -1.471  -0.430  1.00  0.49           H  
ATOM    705  HB3 ASN A  45       8.902  -1.274  -2.165  1.00  0.43           H  
ATOM    706 HD21 ASN A  45      11.289  -1.245  -1.514  1.00  1.42           H  
ATOM    707 HD22 ASN A  45      11.960   0.231  -1.012  1.00  1.16           H  
ATOM    708  N   ASN A  46       7.018   0.417  -3.674  1.00  0.17           N  
ATOM    709  CA  ASN A  46       7.027   1.171  -4.965  1.00  0.22           C  
ATOM    710  C   ASN A  46       5.752   2.013  -5.105  1.00  0.24           C  
ATOM    711  O   ASN A  46       5.544   2.666  -6.108  1.00  0.27           O  
ATOM    712  CB  ASN A  46       7.105   0.180  -6.130  1.00  0.24           C  
ATOM    713  CG  ASN A  46       8.408  -0.616  -6.039  1.00  0.41           C  
ATOM    714  OD1 ASN A  46       8.389  -1.829  -5.991  1.00  1.10           O  
ATOM    715  ND2 ASN A  46       9.548   0.020  -6.014  1.00  1.22           N  
ATOM    716  H   ASN A  46       6.626  -0.480  -3.636  1.00  0.17           H  
ATOM    717  HA  ASN A  46       7.889   1.824  -4.999  1.00  0.27           H  
ATOM    718  HB2 ASN A  46       6.263  -0.496  -6.084  1.00  0.30           H  
ATOM    719  HB3 ASN A  46       7.080   0.722  -7.064  1.00  0.26           H  
ATOM    720 HD21 ASN A  46       9.563   1.000  -6.052  1.00  1.95           H  
ATOM    721 HD22 ASN A  46      10.387  -0.481  -5.955  1.00  1.31           H  
ATOM    722  N   ALA A  47       4.893   2.005  -4.121  1.00  0.24           N  
ATOM    723  CA  ALA A  47       3.640   2.811  -4.234  1.00  0.30           C  
ATOM    724  C   ALA A  47       4.005   4.288  -4.411  1.00  0.51           C  
ATOM    725  O   ALA A  47       4.892   4.801  -3.758  1.00  1.49           O  
ATOM    726  CB  ALA A  47       2.796   2.634  -2.969  1.00  0.21           C  
ATOM    727  H   ALA A  47       5.066   1.472  -3.317  1.00  0.23           H  
ATOM    728  HA  ALA A  47       3.076   2.476  -5.091  1.00  0.38           H  
ATOM    729  HB1 ALA A  47       2.796   1.594  -2.679  1.00  1.03           H  
ATOM    730  HB2 ALA A  47       1.783   2.952  -3.167  1.00  1.03           H  
ATOM    731  HB3 ALA A  47       3.209   3.230  -2.170  1.00  1.03           H  
ATOM    732  N   LYS A  48       3.336   4.972  -5.308  1.00  0.60           N  
ATOM    733  CA  LYS A  48       3.649   6.418  -5.552  1.00  0.53           C  
ATOM    734  C   LYS A  48       2.638   7.322  -4.842  1.00  0.42           C  
ATOM    735  O   LYS A  48       2.760   8.530  -4.871  1.00  0.51           O  
ATOM    736  CB  LYS A  48       3.593   6.690  -7.057  1.00  0.68           C  
ATOM    737  CG  LYS A  48       4.777   6.007  -7.744  1.00  1.13           C  
ATOM    738  CD  LYS A  48       4.599   6.060  -9.266  1.00  1.72           C  
ATOM    739  CE  LYS A  48       4.700   7.507  -9.756  1.00  2.29           C  
ATOM    740  NZ  LYS A  48       4.940   7.515 -11.227  1.00  2.97           N  
ATOM    741  H   LYS A  48       2.634   4.533  -5.831  1.00  1.36           H  
ATOM    742  HA  LYS A  48       4.639   6.646  -5.190  1.00  0.56           H  
ATOM    743  HB2 LYS A  48       2.668   6.303  -7.460  1.00  0.92           H  
ATOM    744  HB3 LYS A  48       3.643   7.755  -7.230  1.00  0.92           H  
ATOM    745  HG2 LYS A  48       5.692   6.511  -7.469  1.00  1.60           H  
ATOM    746  HG3 LYS A  48       4.827   4.975  -7.427  1.00  1.61           H  
ATOM    747  HD2 LYS A  48       5.369   5.466  -9.737  1.00  2.20           H  
ATOM    748  HD3 LYS A  48       3.630   5.661  -9.527  1.00  2.18           H  
ATOM    749  HE2 LYS A  48       3.778   8.026  -9.542  1.00  2.66           H  
ATOM    750  HE3 LYS A  48       5.517   8.004  -9.255  1.00  2.60           H  
ATOM    751  HZ1 LYS A  48       4.786   6.560 -11.609  1.00  3.38           H  
ATOM    752  HZ2 LYS A  48       4.283   8.182 -11.682  1.00  3.35           H  
ATOM    753  HZ3 LYS A  48       5.919   7.808 -11.418  1.00  3.23           H  
ATOM    754  N   THR A  49       1.638   6.769  -4.210  1.00  0.35           N  
ATOM    755  CA  THR A  49       0.642   7.641  -3.517  1.00  0.42           C  
ATOM    756  C   THR A  49      -0.076   6.858  -2.414  1.00  0.62           C  
ATOM    757  O   THR A  49      -0.198   5.650  -2.470  1.00  1.59           O  
ATOM    758  CB  THR A  49      -0.377   8.153  -4.544  1.00  0.45           C  
ATOM    759  OG1 THR A  49       0.298   8.476  -5.752  1.00  0.57           O  
ATOM    760  CG2 THR A  49      -1.074   9.401  -4.004  1.00  0.48           C  
ATOM    761  H   THR A  49       1.540   5.794  -4.192  1.00  0.38           H  
ATOM    762  HA  THR A  49       1.155   8.484  -3.073  1.00  0.49           H  
ATOM    763  HB  THR A  49      -1.113   7.388  -4.738  1.00  0.49           H  
ATOM    764  HG1 THR A  49       0.044   7.831  -6.416  1.00  0.76           H  
ATOM    765 HG21 THR A  49      -1.441   9.206  -3.009  1.00  1.12           H  
ATOM    766 HG22 THR A  49      -0.368  10.219  -3.974  1.00  1.16           H  
ATOM    767 HG23 THR A  49      -1.899   9.661  -4.649  1.00  1.07           H  
ATOM    768  N   VAL A  50      -0.552   7.546  -1.409  1.00  0.44           N  
ATOM    769  CA  VAL A  50      -1.262   6.861  -0.290  1.00  0.33           C  
ATOM    770  C   VAL A  50      -2.512   6.158  -0.825  1.00  0.37           C  
ATOM    771  O   VAL A  50      -2.823   5.050  -0.436  1.00  0.40           O  
ATOM    772  CB  VAL A  50      -1.678   7.903   0.747  1.00  0.42           C  
ATOM    773  CG1 VAL A  50      -2.587   7.263   1.802  1.00  0.47           C  
ATOM    774  CG2 VAL A  50      -0.434   8.483   1.425  1.00  0.44           C  
ATOM    775  H   VAL A  50      -0.438   8.519  -1.389  1.00  1.18           H  
ATOM    776  HA  VAL A  50      -0.606   6.136   0.168  1.00  0.28           H  
ATOM    777  HB  VAL A  50      -2.217   8.691   0.249  1.00  0.52           H  
ATOM    778 HG11 VAL A  50      -2.164   6.321   2.118  1.00  1.17           H  
ATOM    779 HG12 VAL A  50      -2.671   7.923   2.653  1.00  1.10           H  
ATOM    780 HG13 VAL A  50      -3.566   7.095   1.378  1.00  1.12           H  
ATOM    781 HG21 VAL A  50       0.227   7.679   1.716  1.00  1.12           H  
ATOM    782 HG22 VAL A  50       0.078   9.139   0.737  1.00  1.10           H  
ATOM    783 HG23 VAL A  50      -0.728   9.041   2.302  1.00  1.08           H  
ATOM    784  N   GLU A  51      -3.233   6.789  -1.711  1.00  0.43           N  
ATOM    785  CA  GLU A  51      -4.456   6.142  -2.255  1.00  0.53           C  
ATOM    786  C   GLU A  51      -4.040   4.842  -2.932  1.00  0.49           C  
ATOM    787  O   GLU A  51      -4.741   3.849  -2.889  1.00  0.62           O  
ATOM    788  CB  GLU A  51      -5.138   7.075  -3.261  1.00  0.66           C  
ATOM    789  CG  GLU A  51      -4.183   7.394  -4.417  1.00  1.57           C  
ATOM    790  CD  GLU A  51      -4.877   8.334  -5.404  1.00  1.95           C  
ATOM    791  OE1 GLU A  51      -6.074   8.525  -5.270  1.00  2.64           O  
ATOM    792  OE2 GLU A  51      -4.198   8.846  -6.281  1.00  2.14           O  
ATOM    793  H   GLU A  51      -2.971   7.685  -2.015  1.00  0.43           H  
ATOM    794  HA  GLU A  51      -5.137   5.922  -1.445  1.00  0.57           H  
ATOM    795  HB2 GLU A  51      -6.024   6.595  -3.651  1.00  1.04           H  
ATOM    796  HB3 GLU A  51      -5.417   7.994  -2.766  1.00  1.20           H  
ATOM    797  HG2 GLU A  51      -3.295   7.867  -4.030  1.00  2.18           H  
ATOM    798  HG3 GLU A  51      -3.914   6.482  -4.927  1.00  2.03           H  
ATOM    799  N   GLY A  52      -2.886   4.834  -3.530  1.00  0.40           N  
ATOM    800  CA  GLY A  52      -2.399   3.596  -4.181  1.00  0.41           C  
ATOM    801  C   GLY A  52      -2.056   2.586  -3.087  1.00  0.31           C  
ATOM    802  O   GLY A  52      -2.267   1.400  -3.230  1.00  0.35           O  
ATOM    803  H   GLY A  52      -2.329   5.641  -3.532  1.00  0.41           H  
ATOM    804  HA2 GLY A  52      -3.168   3.194  -4.825  1.00  0.48           H  
ATOM    805  HA3 GLY A  52      -1.514   3.811  -4.758  1.00  0.45           H  
ATOM    806  N   VAL A  53      -1.524   3.056  -1.989  1.00  0.22           N  
ATOM    807  CA  VAL A  53      -1.159   2.132  -0.879  1.00  0.15           C  
ATOM    808  C   VAL A  53      -2.429   1.538  -0.256  1.00  0.14           C  
ATOM    809  O   VAL A  53      -2.539   0.346  -0.068  1.00  0.17           O  
ATOM    810  CB  VAL A  53      -0.376   2.914   0.182  1.00  0.14           C  
ATOM    811  CG1 VAL A  53      -0.200   2.060   1.444  1.00  0.19           C  
ATOM    812  CG2 VAL A  53       1.000   3.287  -0.376  1.00  0.14           C  
ATOM    813  H   VAL A  53      -1.363   4.025  -1.893  1.00  0.26           H  
ATOM    814  HA  VAL A  53      -0.540   1.333  -1.262  1.00  0.19           H  
ATOM    815  HB  VAL A  53      -0.917   3.814   0.434  1.00  0.17           H  
ATOM    816 HG11 VAL A  53       0.098   1.062   1.162  1.00  1.07           H  
ATOM    817 HG12 VAL A  53       0.559   2.500   2.073  1.00  1.00           H  
ATOM    818 HG13 VAL A  53      -1.135   2.019   1.984  1.00  1.00           H  
ATOM    819 HG21 VAL A  53       1.524   2.389  -0.670  1.00  1.03           H  
ATOM    820 HG22 VAL A  53       0.877   3.927  -1.234  1.00  1.01           H  
ATOM    821 HG23 VAL A  53       1.569   3.804   0.382  1.00  1.01           H  
ATOM    822  N   LYS A  54      -3.381   2.367   0.082  1.00  0.18           N  
ATOM    823  CA  LYS A  54      -4.635   1.852   0.712  1.00  0.21           C  
ATOM    824  C   LYS A  54      -5.467   1.060  -0.301  1.00  0.20           C  
ATOM    825  O   LYS A  54      -6.057   0.049   0.027  1.00  0.21           O  
ATOM    826  CB  LYS A  54      -5.462   3.032   1.225  1.00  0.26           C  
ATOM    827  CG  LYS A  54      -6.636   2.507   2.055  1.00  0.30           C  
ATOM    828  CD  LYS A  54      -7.466   3.684   2.569  1.00  0.78           C  
ATOM    829  CE  LYS A  54      -8.633   3.155   3.402  1.00  1.14           C  
ATOM    830  NZ  LYS A  54      -8.105   2.352   4.541  1.00  1.73           N  
ATOM    831  H   LYS A  54      -3.267   3.328  -0.067  1.00  0.23           H  
ATOM    832  HA  LYS A  54      -4.379   1.212   1.543  1.00  0.21           H  
ATOM    833  HB2 LYS A  54      -4.842   3.669   1.838  1.00  0.32           H  
ATOM    834  HB3 LYS A  54      -5.841   3.597   0.386  1.00  0.26           H  
ATOM    835  HG2 LYS A  54      -7.254   1.871   1.439  1.00  0.55           H  
ATOM    836  HG3 LYS A  54      -6.259   1.942   2.894  1.00  0.59           H  
ATOM    837  HD2 LYS A  54      -6.845   4.323   3.181  1.00  1.32           H  
ATOM    838  HD3 LYS A  54      -7.850   4.248   1.732  1.00  1.46           H  
ATOM    839  HE2 LYS A  54      -9.209   3.985   3.783  1.00  1.78           H  
ATOM    840  HE3 LYS A  54      -9.264   2.533   2.784  1.00  1.68           H  
ATOM    841  HZ1 LYS A  54      -7.281   2.837   4.953  1.00  2.15           H  
ATOM    842  HZ2 LYS A  54      -8.843   2.247   5.264  1.00  2.26           H  
ATOM    843  HZ3 LYS A  54      -7.819   1.413   4.200  1.00  2.14           H  
ATOM    844  N   ALA A  55      -5.539   1.518  -1.518  1.00  0.22           N  
ATOM    845  CA  ALA A  55      -6.356   0.801  -2.541  1.00  0.23           C  
ATOM    846  C   ALA A  55      -5.704  -0.532  -2.918  1.00  0.20           C  
ATOM    847  O   ALA A  55      -6.374  -1.470  -3.304  1.00  0.19           O  
ATOM    848  CB  ALA A  55      -6.479   1.673  -3.791  1.00  0.30           C  
ATOM    849  H   ALA A  55      -5.070   2.343  -1.759  1.00  0.25           H  
ATOM    850  HA  ALA A  55      -7.342   0.614  -2.141  1.00  0.24           H  
ATOM    851  HB1 ALA A  55      -6.998   1.125  -4.563  1.00  0.97           H  
ATOM    852  HB2 ALA A  55      -5.494   1.943  -4.141  1.00  1.01           H  
ATOM    853  HB3 ALA A  55      -7.034   2.570  -3.550  1.00  1.15           H  
ATOM    854  N   LEU A  56      -4.408  -0.629  -2.822  1.00  0.20           N  
ATOM    855  CA  LEU A  56      -3.731  -1.905  -3.193  1.00  0.21           C  
ATOM    856  C   LEU A  56      -4.070  -2.969  -2.147  1.00  0.18           C  
ATOM    857  O   LEU A  56      -4.335  -4.110  -2.470  1.00  0.19           O  
ATOM    858  CB  LEU A  56      -2.211  -1.690  -3.228  1.00  0.26           C  
ATOM    859  CG  LEU A  56      -1.493  -2.935  -3.791  1.00  0.30           C  
ATOM    860  CD1 LEU A  56      -1.536  -2.926  -5.329  1.00  0.34           C  
ATOM    861  CD2 LEU A  56      -0.028  -2.948  -3.317  1.00  0.46           C  
ATOM    862  H   LEU A  56      -3.882   0.133  -2.511  1.00  0.22           H  
ATOM    863  HA  LEU A  56      -4.081  -2.225  -4.158  1.00  0.23           H  
ATOM    864  HB2 LEU A  56      -1.989  -0.837  -3.853  1.00  0.25           H  
ATOM    865  HB3 LEU A  56      -1.859  -1.496  -2.224  1.00  0.28           H  
ATOM    866  HG  LEU A  56      -1.988  -3.825  -3.431  1.00  0.27           H  
ATOM    867 HD11 LEU A  56      -2.558  -2.928  -5.671  1.00  1.09           H  
ATOM    868 HD12 LEU A  56      -1.035  -2.042  -5.697  1.00  0.97           H  
ATOM    869 HD13 LEU A  56      -1.035  -3.804  -5.706  1.00  1.09           H  
ATOM    870 HD21 LEU A  56       0.352  -1.936  -3.269  1.00  1.08           H  
ATOM    871 HD22 LEU A  56       0.027  -3.399  -2.339  1.00  1.10           H  
ATOM    872 HD23 LEU A  56       0.575  -3.521  -4.006  1.00  1.18           H  
ATOM    873  N   ILE A  57      -4.076  -2.599  -0.899  1.00  0.16           N  
ATOM    874  CA  ILE A  57      -4.410  -3.580   0.168  1.00  0.17           C  
ATOM    875  C   ILE A  57      -5.875  -3.977   0.022  1.00  0.17           C  
ATOM    876  O   ILE A  57      -6.246  -5.113   0.238  1.00  0.20           O  
ATOM    877  CB  ILE A  57      -4.204  -2.948   1.546  1.00  0.18           C  
ATOM    878  CG1 ILE A  57      -2.741  -2.507   1.727  1.00  0.19           C  
ATOM    879  CG2 ILE A  57      -4.573  -3.959   2.630  1.00  0.23           C  
ATOM    880  CD1 ILE A  57      -1.777  -3.673   1.463  1.00  0.21           C  
ATOM    881  H   ILE A  57      -3.868  -1.670  -0.663  1.00  0.17           H  
ATOM    882  HA  ILE A  57      -3.791  -4.456   0.067  1.00  0.19           H  
ATOM    883  HB  ILE A  57      -4.855  -2.092   1.635  1.00  0.20           H  
ATOM    884 HG12 ILE A  57      -2.524  -1.707   1.037  1.00  0.21           H  
ATOM    885 HG13 ILE A  57      -2.598  -2.153   2.737  1.00  0.19           H  
ATOM    886 HG21 ILE A  57      -4.121  -4.913   2.403  1.00  1.02           H  
ATOM    887 HG22 ILE A  57      -4.214  -3.609   3.587  1.00  0.99           H  
ATOM    888 HG23 ILE A  57      -5.644  -4.067   2.663  1.00  0.98           H  
ATOM    889 HD11 ILE A  57      -2.208  -4.595   1.823  1.00  1.04           H  
ATOM    890 HD12 ILE A  57      -1.592  -3.753   0.402  1.00  1.01           H  
ATOM    891 HD13 ILE A  57      -0.844  -3.489   1.974  1.00  1.05           H  
ATOM    892  N   ASP A  58      -6.713  -3.045  -0.335  1.00  0.16           N  
ATOM    893  CA  ASP A  58      -8.157  -3.374  -0.480  1.00  0.19           C  
ATOM    894  C   ASP A  58      -8.321  -4.459  -1.543  1.00  0.19           C  
ATOM    895  O   ASP A  58      -9.107  -5.375  -1.393  1.00  0.22           O  
ATOM    896  CB  ASP A  58      -8.927  -2.123  -0.907  1.00  0.21           C  
ATOM    897  CG  ASP A  58      -8.969  -1.126   0.251  1.00  0.50           C  
ATOM    898  OD1 ASP A  58      -8.769  -1.547   1.378  1.00  1.11           O  
ATOM    899  OD2 ASP A  58      -9.202   0.044  -0.007  1.00  1.17           O  
ATOM    900  H   ASP A  58      -6.391  -2.127  -0.501  1.00  0.16           H  
ATOM    901  HA  ASP A  58      -8.543  -3.731   0.464  1.00  0.21           H  
ATOM    902  HB2 ASP A  58      -8.433  -1.670  -1.756  1.00  0.35           H  
ATOM    903  HB3 ASP A  58      -9.935  -2.395  -1.181  1.00  0.33           H  
ATOM    904  N   GLU A  59      -7.577  -4.375  -2.609  1.00  0.18           N  
ATOM    905  CA  GLU A  59      -7.682  -5.413  -3.668  1.00  0.21           C  
ATOM    906  C   GLU A  59      -7.095  -6.716  -3.135  1.00  0.24           C  
ATOM    907  O   GLU A  59      -7.605  -7.791  -3.380  1.00  0.30           O  
ATOM    908  CB  GLU A  59      -6.902  -4.966  -4.906  1.00  0.23           C  
ATOM    909  CG  GLU A  59      -7.626  -3.793  -5.573  1.00  0.25           C  
ATOM    910  CD  GLU A  59      -8.946  -4.278  -6.178  1.00  0.38           C  
ATOM    911  OE1 GLU A  59      -8.898  -5.144  -7.035  1.00  1.04           O  
ATOM    912  OE2 GLU A  59      -9.980  -3.773  -5.774  1.00  0.98           O  
ATOM    913  H   GLU A  59      -6.938  -3.643  -2.706  1.00  0.17           H  
ATOM    914  HA  GLU A  59      -8.719  -5.564  -3.926  1.00  0.23           H  
ATOM    915  HB2 GLU A  59      -5.907  -4.658  -4.614  1.00  0.28           H  
ATOM    916  HB3 GLU A  59      -6.833  -5.787  -5.605  1.00  0.23           H  
ATOM    917  HG2 GLU A  59      -7.827  -3.031  -4.835  1.00  0.27           H  
ATOM    918  HG3 GLU A  59      -7.003  -3.383  -6.354  1.00  0.22           H  
ATOM    919  N   ILE A  60      -6.011  -6.622  -2.412  1.00  0.23           N  
ATOM    920  CA  ILE A  60      -5.372  -7.847  -1.866  1.00  0.27           C  
ATOM    921  C   ILE A  60      -6.254  -8.457  -0.777  1.00  0.28           C  
ATOM    922  O   ILE A  60      -6.451  -9.656  -0.727  1.00  0.33           O  
ATOM    923  CB  ILE A  60      -4.006  -7.484  -1.284  1.00  0.28           C  
ATOM    924  CG1 ILE A  60      -3.086  -7.014  -2.414  1.00  0.29           C  
ATOM    925  CG2 ILE A  60      -3.394  -8.711  -0.606  1.00  0.33           C  
ATOM    926  CD1 ILE A  60      -1.817  -6.397  -1.820  1.00  0.27           C  
ATOM    927  H   ILE A  60      -5.615  -5.744  -2.236  1.00  0.20           H  
ATOM    928  HA  ILE A  60      -5.243  -8.557  -2.664  1.00  0.31           H  
ATOM    929  HB  ILE A  60      -4.122  -6.692  -0.558  1.00  0.26           H  
ATOM    930 HG12 ILE A  60      -2.821  -7.857  -3.034  1.00  0.31           H  
ATOM    931 HG13 ILE A  60      -3.598  -6.274  -3.011  1.00  0.33           H  
ATOM    932 HG21 ILE A  60      -3.495  -9.568  -1.255  1.00  1.11           H  
ATOM    933 HG22 ILE A  60      -2.349  -8.531  -0.409  1.00  1.01           H  
ATOM    934 HG23 ILE A  60      -3.908  -8.903   0.324  1.00  1.10           H  
ATOM    935 HD11 ILE A  60      -1.432  -7.042  -1.045  1.00  1.00           H  
ATOM    936 HD12 ILE A  60      -1.075  -6.285  -2.597  1.00  1.02           H  
ATOM    937 HD13 ILE A  60      -2.049  -5.429  -1.402  1.00  1.03           H  
ATOM    938  N   LEU A  61      -6.798  -7.650   0.094  1.00  0.25           N  
ATOM    939  CA  LEU A  61      -7.672  -8.200   1.166  1.00  0.30           C  
ATOM    940  C   LEU A  61      -8.978  -8.700   0.544  1.00  0.33           C  
ATOM    941  O   LEU A  61      -9.540  -9.691   0.967  1.00  0.46           O  
ATOM    942  CB  LEU A  61      -7.980  -7.117   2.214  1.00  0.29           C  
ATOM    943  CG  LEU A  61      -6.729  -6.772   3.042  1.00  0.32           C  
ATOM    944  CD1 LEU A  61      -7.106  -5.699   4.071  1.00  1.15           C  
ATOM    945  CD2 LEU A  61      -6.192  -8.020   3.775  1.00  1.27           C  
ATOM    946  H   LEU A  61      -6.636  -6.684   0.038  1.00  0.22           H  
ATOM    947  HA  LEU A  61      -7.176  -9.032   1.637  1.00  0.33           H  
ATOM    948  HB2 LEU A  61      -8.321  -6.222   1.711  1.00  0.32           H  
ATOM    949  HB3 LEU A  61      -8.756  -7.470   2.875  1.00  0.24           H  
ATOM    950  HG  LEU A  61      -5.964  -6.381   2.384  1.00  1.07           H  
ATOM    951 HD11 LEU A  61      -7.624  -4.890   3.577  1.00  1.75           H  
ATOM    952 HD12 LEU A  61      -7.751  -6.133   4.821  1.00  1.74           H  
ATOM    953 HD13 LEU A  61      -6.210  -5.321   4.543  1.00  1.76           H  
ATOM    954 HD21 LEU A  61      -7.010  -8.682   4.021  1.00  1.75           H  
ATOM    955 HD22 LEU A  61      -5.491  -8.536   3.136  1.00  1.91           H  
ATOM    956 HD23 LEU A  61      -5.686  -7.723   4.686  1.00  1.87           H  
ATOM    957  N   ALA A  62      -9.468  -8.021  -0.457  1.00  0.28           N  
ATOM    958  CA  ALA A  62     -10.737  -8.458  -1.105  1.00  0.32           C  
ATOM    959  C   ALA A  62     -10.572  -9.871  -1.669  1.00  0.37           C  
ATOM    960  O   ALA A  62     -11.466 -10.691  -1.586  1.00  0.48           O  
ATOM    961  CB  ALA A  62     -11.084  -7.495  -2.243  1.00  0.31           C  
ATOM    962  H   ALA A  62      -9.001  -7.225  -0.784  1.00  0.30           H  
ATOM    963  HA  ALA A  62     -11.535  -8.453  -0.374  1.00  0.36           H  
ATOM    964  HB1 ALA A  62     -10.295  -7.510  -2.979  1.00  1.02           H  
ATOM    965  HB2 ALA A  62     -12.011  -7.803  -2.704  1.00  1.07           H  
ATOM    966  HB3 ALA A  62     -11.191  -6.496  -1.850  1.00  1.06           H  
ATOM    967  N   ALA A  63      -9.439 -10.163  -2.246  1.00  0.41           N  
ATOM    968  CA  ALA A  63      -9.220 -11.523  -2.821  1.00  0.50           C  
ATOM    969  C   ALA A  63      -9.119 -12.556  -1.696  1.00  0.70           C  
ATOM    970  O   ALA A  63      -8.728 -13.685  -1.917  1.00  1.15           O  
ATOM    971  CB  ALA A  63      -7.924 -11.529  -3.634  1.00  0.72           C  
ATOM    972  H   ALA A  63      -8.731  -9.488  -2.306  1.00  0.46           H  
ATOM    973  HA  ALA A  63     -10.049 -11.775  -3.466  1.00  0.54           H  
ATOM    974  HB1 ALA A  63      -7.814 -12.484  -4.128  1.00  1.21           H  
ATOM    975  HB2 ALA A  63      -7.960 -10.743  -4.374  1.00  1.28           H  
ATOM    976  HB3 ALA A  63      -7.084 -11.365  -2.975  1.00  1.36           H  
ATOM    977  N   LEU A  64      -9.474 -12.180  -0.491  1.00  0.59           N  
ATOM    978  CA  LEU A  64      -9.406 -13.136   0.664  1.00  0.85           C  
ATOM    979  C   LEU A  64     -10.743 -13.120   1.423  1.00  1.41           C  
ATOM    980  O   LEU A  64     -10.841 -12.532   2.482  1.00  1.62           O  
ATOM    981  CB  LEU A  64      -8.288 -12.701   1.616  1.00  0.65           C  
ATOM    982  CG  LEU A  64      -6.942 -12.693   0.879  1.00  0.53           C  
ATOM    983  CD1 LEU A  64      -5.870 -12.095   1.796  1.00  0.68           C  
ATOM    984  CD2 LEU A  64      -6.539 -14.126   0.486  1.00  0.84           C  
ATOM    985  H   LEU A  64      -9.789 -11.264  -0.342  1.00  0.58           H  
ATOM    986  HA  LEU A  64      -9.209 -14.138   0.313  1.00  1.03           H  
ATOM    987  HB2 LEU A  64      -8.499 -11.708   1.985  1.00  0.92           H  
ATOM    988  HB3 LEU A  64      -8.237 -13.388   2.447  1.00  0.70           H  
ATOM    989  HG  LEU A  64      -7.026 -12.085  -0.012  1.00  0.71           H  
ATOM    990 HD11 LEU A  64      -6.152 -11.090   2.071  1.00  1.28           H  
ATOM    991 HD12 LEU A  64      -5.780 -12.701   2.686  1.00  1.24           H  
ATOM    992 HD13 LEU A  64      -4.924 -12.072   1.278  1.00  1.31           H  
ATOM    993 HD21 LEU A  64      -6.823 -14.815   1.269  1.00  1.34           H  
ATOM    994 HD22 LEU A  64      -7.037 -14.401  -0.432  1.00  1.46           H  
ATOM    995 HD23 LEU A  64      -5.470 -14.177   0.338  1.00  1.30           H  
ATOM    996  N   PRO A  65     -11.768 -13.754   0.897  1.00  1.85           N  
ATOM    997  CA  PRO A  65     -13.089 -13.776   1.583  1.00  2.43           C  
ATOM    998  C   PRO A  65     -13.083 -14.699   2.810  1.00  2.62           C  
ATOM    999  O   PRO A  65     -12.977 -15.900   2.623  1.00  2.81           O  
ATOM   1000  CB  PRO A  65     -14.025 -14.304   0.477  1.00  2.89           C  
ATOM   1001  CG  PRO A  65     -13.155 -14.870  -0.666  1.00  2.69           C  
ATOM   1002  CD  PRO A  65     -11.686 -14.483  -0.401  1.00  2.01           C  
ATOM   1003  OXT PRO A  65     -13.185 -14.188   3.913  1.00  3.05           O  
ATOM   1004  HA  PRO A  65     -13.382 -12.778   1.866  1.00  2.53           H  
ATOM   1005  HB2 PRO A  65     -14.670 -15.081   0.874  1.00  3.20           H  
ATOM   1006  HB3 PRO A  65     -14.637 -13.494   0.098  1.00  3.15           H  
ATOM   1007  HG2 PRO A  65     -13.251 -15.949  -0.699  1.00  2.97           H  
ATOM   1008  HG3 PRO A  65     -13.475 -14.454  -1.614  1.00  2.85           H  
ATOM   1009  HD2 PRO A  65     -11.068 -15.368  -0.310  1.00  2.00           H  
ATOM   1010  HD3 PRO A  65     -11.313 -13.830  -1.172  1.00  1.85           H  
TER    1011      PRO A  65                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
