
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   55 (  432),  selected   55 , name 1lp1_A
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 1lp1_A.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     4_A      N       8          1.546
LGA    F     5_A      L       9          0.709
LGA    N     6_A      K      10          1.062
LGA    K     7_A      Q      11          1.345
LGA    E     8_A      A      12          1.361
LGA    L     9_A      K      13          0.783
LGA    S    10_A      E      14          0.576
LGA    V    11_A      E      15          1.543
LGA    A    12_A      A      16          2.337
LGA    G    13_A      I      17          1.942
LGA    R    14_A      K      18          0.852
LGA    E    15_A      E      19          0.563
LGA    I    16_A      L      20          1.884
LGA    V    17_A      V      21          2.977
LGA    T    18_A      D      22          2.476
LGA    L    19_A      A      23          1.009
LGA    P    20_A      G      24          3.854
LGA    N    21_A      -       -           -
LGA    L    22_A      T      25          2.372
LGA    N    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    P    25_A      -       -           -
LGA    Q    26_A      A      26          1.666
LGA    K    27_A      E      27          1.222
LGA    K    28_A      -       -           -
LGA    A    29_A      K      28          0.801
LGA    F    30_A      Y      29          1.285
LGA    I    31_A      I      30          1.750
LGA    F    32_A      K      31          1.199
LGA    S    33_A      L      32          0.439
LGA    L    34_A      I      33          0.596
LGA    W    35_A      A      34          0.774
LGA    D    36_A      N      35          1.284
LGA    D    37_A      A      36          1.447
LGA    P    38_A      K      37          3.800
LGA    S    39_A      T      38          1.747
LGA    -       -      V      39           -
LGA    -       -      E      40           -
LGA    Q    40_A      G      41          0.594
LGA    S    41_A      V      42          0.686
LGA    A    42_A      W      43          1.578
LGA    N    43_A      T      44          1.173
LGA    L    44_A      L      45          0.472
LGA    L    45_A      K      46          1.668
LGA    A    46_A      D      47          1.711
LGA    E    47_A      E      48          0.825
LGA    A    48_A      I      49          1.087
LGA    K    49_A      K      50          0.597
LGA    K    50_A      T      51          0.406
LGA    L    51_A      F      52          2.082
LGA    N    52_A      -       -           -
LGA    D    53_A      -       -           -
LGA    A    54_A      -       -           -
LGA    Q    55_A      -       -           -
LGA    A    56_A      -       -           -
LGA    P    57_A      -       -           -
LGA    K    58_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   55   45    5.0     43    1.61    16.28     87.700     2.508

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.089087 * X  +   0.963537 * Y  +  -0.252310 * Z  + -11.930011
  Y_new =  -0.690761 * X  +  -0.242267 * Y  +  -0.681289 * Z  +  24.777880
  Z_new =  -0.717574 * X  +   0.113592 * Y  +   0.687157 * Z  +  23.882629 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.163826   -2.977767  [ DEG:     9.3865   -170.6135 ]
  Theta =   0.800313    2.341280  [ DEG:    45.8545    134.1455 ]
  Phi   =  -1.699057    1.442536  [ DEG:   -97.3488     82.6512 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lp1_A                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lp1_A.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   55   45   5.0   43   1.61   16.28  87.700
REMARK  ---------------------------------------------------------- 
MOLECULE 1lp1_A
HEADER    IMMUNE SYSTEM                           07-MAY-02   1LP1              
TITLE     PROTEIN Z IN COMPLEX WITH AN IN VITRO SELECTED AFFIBODY               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AFFIBODY BINDING PROTEIN Z;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: IN VITRO SELECTED BINDING PROTEIN;                         
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: IMMUNOGLOBULIN G BINDING PROTEIN A;                        
COMPND   8 CHAIN: B;                                                            
COMPND   9 FRAGMENT: RESIDUES 2-58;                                             
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   8 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    IN VITRO EVOLVED, PROTEIN-PROTEIN COMPLEX, THREE-HELIX                
KEYWDS   2 BUNDLE, AFFIBODY                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.HOGBOM,M.EKLUND,P.A.NYGREN,P.NORDLUND                               
REVDAT   2   25-MAR-03 1LP1    1       JRNL                                     
REVDAT   1   18-MAR-03 1LP1    0                                                
JRNL        AUTH   M.HOGBOM,M.EKLUND,P.A.NYGREN,P.NORDLUND                      
JRNL        TITL   STRUCTURAL BASIS FOR RECOGNITION BY AN IN VITRO              
JRNL        TITL 2 EVOLVED AFFIBODY.                                            
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 100  3191 2003              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1LP1 B    1    58  UNP    P38507   SPA2_STAAU     212    269             
SEQRES   1 A   58  VAL ASP ASN LYS PHE ASN LYS GLU LEU SER VAL ALA GLY          
SEQRES   2 A   58  ARG GLU ILE VAL THR LEU PRO ASN LEU ASN ASP PRO GLN          
SEQRES   3 A   58  LYS LYS ALA PHE ILE PHE SER LEU TRP ASP ASP PRO SER          
SEQRES   4 A   58  GLN SER ALA ASN LEU LEU ALA GLU ALA LYS LYS LEU ASN          
SEQRES   5 A   58  ASP ALA GLN ALA PRO LYS                                      
SEQRES   1 B   58  VAL ASP ASN LYS PHE ASN LYS GLU GLN GLN ASN ALA PHE          
SEQRES   2 B   58  TYR GLU ILE LEU HIS LEU PRO ASN LEU ASN GLU GLU GLN          
SEQRES   3 B   58  ARG ASN ALA PHE ILE GLN SER LEU LYS ASP ASP PRO SER          
SEQRES   4 B   58  GLN SER ALA ASN LEU LEU ALA GLU ALA LYS LYS LEU ASN          
SEQRES   5 B   58  ASP ALA GLN ALA PRO LYS                                      
HET    SO4    301       5                                                       
HET    SO4    302       5                                                       
HET    SO4    303       5                                                       
HET    SO4    304       5                                                       
HET     MG    401       1                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   3  SO4    4(O4 S 2-)                                                   
FORMUL   7   MG    MG 2+                                                        
FORMUL   8  HOH   *182(H2 O)                                                    
CRYST1   55.546   55.546  155.749  90.00  90.00 120.00 P 61 2 2     12          
ATOM      1  N   LYS A   4       3.167  12.216   5.874  1.00113.02           N  
ATOM      2  CA  LYS A   4       3.444  11.745   4.488  1.00107.97           C  
ATOM      3  C   LYS A   4       3.256  10.229   4.419  1.00106.21           C  
ATOM      4  O   LYS A   4       2.945   9.590   5.427  1.00102.15           O  
ATOM      5  CB  LYS A   4       4.874  12.134   4.091  1.00106.65           C  
ATOM      6  CG  LYS A   4       5.175  12.016   2.606  1.00103.30           C  
ATOM      7  CD  LYS A   4       6.415  12.820   2.221  1.00105.79           C  
ATOM      8  CE  LYS A   4       7.656  12.371   2.982  1.00105.18           C  
ATOM      9  NZ  LYS A   4       8.844  13.217   2.659  1.00104.02           N  
ATOM     10  N   PHE A   5       3.430   9.657   3.232  1.00103.79           N  
ATOM     11  CA  PHE A   5       3.276   8.216   3.046  1.00102.75           C  
ATOM     12  C   PHE A   5       4.222   7.412   3.930  1.00 98.33           C  
ATOM     13  O   PHE A   5       4.350   6.197   3.774  1.00 96.64           O  
ATOM     14  CB  PHE A   5       3.515   7.840   1.583  1.00107.52           C  
ATOM     15  CG  PHE A   5       2.359   8.157   0.677  1.00114.03           C  
ATOM     16  CD1 PHE A   5       1.121   7.550   0.873  1.00117.20           C  
ATOM     17  CD2 PHE A   5       2.510   9.050  -0.380  1.00116.00           C  
ATOM     18  CE1 PHE A   5       0.048   7.826   0.027  1.00121.88           C  
ATOM     19  CE2 PHE A   5       1.443   9.336  -1.233  1.00119.79           C  
ATOM     20  CZ  PHE A   5       0.208   8.721  -1.029  1.00121.00           C  
ATOM     21  N   ASN A   6       4.888   8.096   4.855  1.00 92.08           N  
ATOM     22  CA  ASN A   6       5.814   7.443   5.764  1.00 86.24           C  
ATOM     23  C   ASN A   6       5.064   6.489   6.682  1.00 86.21           C  
ATOM     24  O   ASN A   6       5.421   5.314   6.800  1.00 81.85           O  
ATOM     25  CB  ASN A   6       6.550   8.482   6.601  1.00 87.17           C  
ATOM     26  CG  ASN A   6       8.045   8.371   6.464  1.00 88.56           C  
ATOM     27  OD1 ASN A   6       8.603   8.653   5.407  1.00 87.87           O  
ATOM     28  ND2 ASN A   6       8.706   7.943   7.532  1.00 91.57           N  
ATOM     29  N   LYS A   7       4.027   7.002   7.338  1.00 82.28           N  
ATOM     30  CA  LYS A   7       3.221   6.188   8.236  1.00 78.70           C  
ATOM     31  C   LYS A   7       2.448   5.185   7.390  1.00 75.13           C  
ATOM     32  O   LYS A   7       2.237   4.039   7.791  1.00 72.68           O  
ATOM     33  CB  LYS A   7       2.249   7.069   9.029  1.00 80.07           C  
ATOM     34  CG  LYS A   7       1.418   6.309  10.061  1.00 85.79           C  
ATOM     35  CD  LYS A   7       0.533   7.243  10.870  1.00 90.40           C  
ATOM     36  CE  LYS A   7      -0.372   6.472  11.819  1.00 91.77           C  
ATOM     37  NZ  LYS A   7       0.396   5.612  12.762  1.00 92.40           N  
ATOM     38  N   GLU A   8       2.034   5.626   6.209  1.00 70.46           N  
ATOM     39  CA  GLU A   8       1.290   4.773   5.303  1.00 71.99           C  
ATOM     40  C   GLU A   8       2.029   3.475   5.007  1.00 63.51           C  
ATOM     41  O   GLU A   8       1.477   2.389   5.179  1.00 64.73           O  
ATOM     42  CB  GLU A   8       1.007   5.516   3.998  1.00 84.53           C  
ATOM     43  CG  GLU A   8      -0.353   6.194   3.956  1.00101.50           C  
ATOM     44  CD  GLU A   8      -1.494   5.192   3.916  1.00111.71           C  
ATOM     45  OE1 GLU A   8      -1.576   4.426   2.932  1.00117.55           O  
ATOM     46  OE2 GLU A   8      -2.307   5.165   4.865  1.00120.90           O  
ATOM     47  N   LEU A   9       3.279   3.590   4.573  1.00 52.72           N  
ATOM     48  CA  LEU A   9       4.073   2.417   4.237  1.00 49.66           C  
ATOM     49  C   LEU A   9       4.323   1.526   5.441  1.00 56.34           C  
ATOM     50  O   LEU A   9       4.332   0.296   5.326  1.00 53.27           O  
ATOM     51  CB  LEU A   9       5.416   2.828   3.632  1.00 48.92           C  
ATOM     52  CG  LEU A   9       5.419   3.490   2.256  1.00 54.51           C  
ATOM     53  CD1 LEU A   9       6.848   3.605   1.762  1.00 60.36           C  
ATOM     54  CD2 LEU A   9       4.606   2.661   1.277  1.00 58.37           C  
ATOM     55  N   SER A  10       4.531   2.153   6.594  1.00 52.75           N  
ATOM     56  CA  SER A  10       4.798   1.421   7.820  1.00 49.00           C  
ATOM     57  C   SER A  10       3.582   0.622   8.264  1.00 51.18           C  
ATOM     58  O   SER A  10       3.679  -0.571   8.546  1.00 44.22           O  
ATOM     59  CB  SER A  10       5.211   2.394   8.924  1.00 56.18           C  
ATOM     60  OG  SER A  10       5.541   1.707  10.118  1.00 71.97           O  
ATOM     61  N   VAL A  11       2.431   1.279   8.318  1.00 40.37           N  
ATOM     62  CA  VAL A  11       1.210   0.613   8.748  1.00 49.94           C  
ATOM     63  C   VAL A  11       0.710  -0.379   7.692  1.00 43.91           C  
ATOM     64  O   VAL A  11       0.295  -1.491   8.019  1.00 45.86           O  
ATOM     65  CB  VAL A  11       0.105   1.651   9.063  1.00 49.87           C  
ATOM     66  CG1 VAL A  11      -1.182   0.958   9.456  1.00 52.96           C  
ATOM     67  CG2 VAL A  11       0.563   2.552  10.203  1.00 61.74           C  
ATOM     68  N   ALA A  12       0.769   0.026   6.429  1.00 34.28           N  
ATOM     69  CA  ALA A  12       0.325  -0.827   5.340  1.00 39.56           C  
ATOM     70  C   ALA A  12       1.241  -2.047   5.313  1.00 33.89           C  
ATOM     71  O   ALA A  12       0.772  -3.183   5.241  1.00 38.42           O  
ATOM     72  CB  ALA A  12       0.392  -0.063   4.022  1.00 41.30           C  
ATOM     73  N   GLY A  13       2.541  -1.791   5.402  1.00 31.20           N  
ATOM     74  CA  GLY A  13       3.528  -2.853   5.413  1.00 39.86           C  
ATOM     75  C   GLY A  13       3.286  -3.868   6.516  1.00 45.71           C  
ATOM     76  O   GLY A  13       3.208  -5.074   6.248  1.00 48.50           O  
ATOM     77  N   ARG A  14       3.164  -3.394   7.757  1.00 40.31           N  
ATOM     78  CA  ARG A  14       2.933  -4.292   8.886  1.00 42.42           C  
ATOM     79  C   ARG A  14       1.642  -5.075   8.725  1.00 39.02           C  
ATOM     80  O   ARG A  14       1.593  -6.269   9.012  1.00 46.73           O  
ATOM     81  CB  ARG A  14       2.888  -3.521  10.214  1.00 37.19           C  
ATOM     82  CG  ARG A  14       4.252  -3.096  10.722  1.00 41.18           C  
ATOM     83  CD  ARG A  14       5.137  -4.308  11.064  1.00 51.02           C  
ATOM     84  NE  ARG A  14       4.662  -5.033  12.245  1.00 56.28           N  
ATOM     85  CZ  ARG A  14       5.240  -6.124  12.744  1.00 57.79           C  
ATOM     86  NH1 ARG A  14       6.323  -6.631  12.168  1.00 62.84           N  
ATOM     87  NH2 ARG A  14       4.741  -6.706  13.827  1.00 61.18           N  
ATOM     88  N   GLU A  15       0.590  -4.413   8.274  1.00 34.09           N  
ATOM     89  CA  GLU A  15      -0.668  -5.123   8.109  1.00 43.74           C  
ATOM     90  C   GLU A  15      -0.496  -6.261   7.088  1.00 40.35           C  
ATOM     91  O   GLU A  15      -0.935  -7.390   7.322  1.00 40.82           O  
ATOM     92  CB  GLU A  15      -1.768  -4.153   7.674  1.00 48.19           C  
ATOM     93  CG  GLU A  15      -3.129  -4.507   8.274  1.00 78.40           C  
ATOM     94  CD  GLU A  15      -4.099  -3.328   8.325  1.00 90.38           C  
ATOM     95  OE1 GLU A  15      -3.703  -2.234   8.790  1.00 91.21           O  
ATOM     96  OE2 GLU A  15      -5.267  -3.502   7.915  1.00 99.97           O  
ATOM     97  N   ILE A  16       0.170  -5.969   5.975  1.00 30.99           N  
ATOM     98  CA  ILE A  16       0.390  -6.983   4.954  1.00 36.44           C  
ATOM     99  C   ILE A  16       1.213  -8.157   5.447  1.00 33.35           C  
ATOM    100  O   ILE A  16       0.811  -9.309   5.260  1.00 34.86           O  
ATOM    101  CB  ILE A  16       1.057  -6.396   3.697  1.00 39.62           C  
ATOM    102  CG1 ILE A  16       0.023  -5.594   2.912  1.00 33.85           C  
ATOM    103  CG2 ILE A  16       1.591  -7.519   2.819  1.00 38.51           C  
ATOM    104  CD1 ILE A  16       0.601  -4.674   1.833  1.00 35.63           C  
ATOM    105  N   VAL A  17       2.341  -7.890   6.106  1.00 29.66           N  
ATOM    106  CA  VAL A  17       3.169  -8.989   6.583  1.00 34.12           C  
ATOM    107  C   VAL A  17       2.511  -9.827   7.647  1.00 40.19           C  
ATOM    108  O   VAL A  17       2.887 -10.991   7.838  1.00 35.98           O  
ATOM    109  CB  VAL A  17       4.532  -8.526   7.145  1.00 44.98           C  
ATOM    110  CG1 VAL A  17       5.297  -7.796   6.075  1.00 27.79           C  
ATOM    111  CG2 VAL A  17       4.331  -7.669   8.390  1.00 46.49           C  
ATOM    112  N   THR A  18       1.547  -9.255   8.361  1.00 30.83           N  
ATOM    113  CA  THR A  18       0.867 -10.031   9.397  1.00 32.03           C  
ATOM    114  C   THR A  18      -0.372 -10.795   8.922  1.00 34.01           C  
ATOM    115  O   THR A  18      -1.006 -11.486   9.720  1.00 35.45           O  
ATOM    116  CB  THR A  18       0.470  -9.144  10.598  1.00 36.78           C  
ATOM    117  OG1 THR A  18      -0.309  -8.031  10.142  1.00 40.45           O  
ATOM    118  CG2 THR A  18       1.714  -8.643  11.306  1.00 38.83           C  
ATOM    119  N   LEU A  19      -0.737 -10.664   7.644  1.00 32.97           N  
ATOM    120  CA  LEU A  19      -1.892 -11.397   7.119  1.00 34.35           C  
ATOM    121  C   LEU A  19      -1.515 -12.883   7.190  1.00 40.35           C  
ATOM    122  O   LEU A  19      -0.512 -13.307   6.618  1.00 49.74           O  
ATOM    123  CB  LEU A  19      -2.176 -10.964   5.675  1.00 27.91           C  
ATOM    124  CG  LEU A  19      -2.801  -9.568   5.555  1.00 37.26           C  
ATOM    125  CD1 LEU A  19      -2.841  -9.143   4.094  1.00 29.73           C  
ATOM    126  CD2 LEU A  19      -4.208  -9.571   6.172  1.00 26.28           C  
ATOM    127  N   PRO A  20      -2.318 -13.697   7.888  1.00 43.48           N  
ATOM    128  CA  PRO A  20      -2.009 -15.124   8.015  1.00 36.93           C  
ATOM    129  C   PRO A  20      -2.204 -16.083   6.831  1.00 38.06           C  
ATOM    130  O   PRO A  20      -1.544 -17.113   6.785  1.00 45.40           O  
ATOM    131  CB  PRO A  20      -2.836 -15.534   9.223  1.00 43.17           C  
ATOM    132  CG  PRO A  20      -4.075 -14.701   9.051  1.00 38.02           C  
ATOM    133  CD  PRO A  20      -3.541 -13.349   8.641  1.00 32.48           C  
ATOM    134  N   ASN A  21      -3.078 -15.774   5.876  1.00 38.76           N  
ATOM    135  CA  ASN A  21      -3.279 -16.708   4.757  1.00 41.37           C  
ATOM    136  C   ASN A  21      -2.450 -16.435   3.502  1.00 41.63           C  
ATOM    137  O   ASN A  21      -2.563 -17.162   2.519  1.00 47.16           O  
ATOM    138  CB  ASN A  21      -4.753 -16.762   4.359  1.00 38.93           C  
ATOM    139  CG  ASN A  21      -5.652 -16.994   5.532  1.00 41.75           C  
ATOM    140  OD1 ASN A  21      -5.408 -17.885   6.346  1.00 45.01           O  
ATOM    141  ND2 ASN A  21      -6.705 -16.192   5.635  1.00 40.52           N  
ATOM    142  N   LEU A  22      -1.641 -15.381   3.527  1.00 38.04           N  
ATOM    143  CA  LEU A  22      -0.793 -15.037   2.397  1.00 39.66           C  
ATOM    144  C   LEU A  22       0.536 -15.768   2.569  1.00 45.38           C  
ATOM    145  O   LEU A  22       1.035 -15.888   3.692  1.00 42.95           O  
ATOM    146  CB  LEU A  22      -0.553 -13.528   2.377  1.00 36.19           C  
ATOM    147  CG  LEU A  22      -1.231 -12.640   1.331  1.00 43.74           C  
ATOM    148  CD1 LEU A  22      -2.708 -13.007   1.145  1.00 40.72           C  
ATOM    149  CD2 LEU A  22      -1.078 -11.193   1.773  1.00 48.94           C  
ATOM    150  N   ASN A  23       1.119 -16.276   1.487  1.00 40.78           N  
ATOM    151  CA  ASN A  23       2.409 -16.955   1.641  1.00 34.81           C  
ATOM    152  C   ASN A  23       3.492 -15.876   1.549  1.00 31.66           C  
ATOM    153  O   ASN A  23       3.206 -14.731   1.170  1.00 37.88           O  
ATOM    154  CB  ASN A  23       2.602 -18.029   0.557  1.00 39.43           C  
ATOM    155  CG  ASN A  23       2.583 -17.455  -0.835  1.00 44.29           C  
ATOM    156  OD1 ASN A  23       3.423 -16.622  -1.187  1.00 48.77           O  
ATOM    157  ND2 ASN A  23       1.618 -17.886  -1.639  1.00 54.78           N  
ATOM    158  N   ASP A  24       4.727 -16.225   1.896  1.00 38.43           N  
ATOM    159  CA  ASP A  24       5.825 -15.262   1.867  1.00 39.32           C  
ATOM    160  C   ASP A  24       5.979 -14.544   0.534  1.00 47.43           C  
ATOM    161  O   ASP A  24       5.955 -13.310   0.480  1.00 46.46           O  
ATOM    162  CB  ASP A  24       7.149 -15.936   2.232  1.00 48.41           C  
ATOM    163  CG  ASP A  24       7.168 -16.473   3.657  1.00 66.13           C  
ATOM    164  OD1 ASP A  24       6.563 -15.840   4.547  1.00 73.64           O  
ATOM    165  OD2 ASP A  24       7.807 -17.522   3.897  1.00 84.50           O  
ATOM    166  N   PRO A  25       6.150 -15.301  -0.563  1.00 40.89           N  
ATOM    167  CA  PRO A  25       6.304 -14.664  -1.874  1.00 41.90           C  
ATOM    168  C   PRO A  25       5.206 -13.645  -2.169  1.00 33.48           C  
ATOM    169  O   PRO A  25       5.451 -12.612  -2.798  1.00 39.62           O  
ATOM    170  CB  PRO A  25       6.279 -15.855  -2.839  1.00 38.76           C  
ATOM    171  CG  PRO A  25       6.934 -16.932  -2.027  1.00 37.58           C  
ATOM    172  CD  PRO A  25       6.294 -16.766  -0.668  1.00 45.70           C  
ATOM    173  N   GLN A  26       3.984 -13.931  -1.735  1.00 34.90           N  
ATOM    174  CA  GLN A  26       2.900 -12.982  -1.985  1.00 39.16           C  
ATOM    175  C   GLN A  26       3.137 -11.707  -1.169  1.00 40.27           C  
ATOM    176  O   GLN A  26       2.976 -10.595  -1.671  1.00 43.66           O  
ATOM    177  CB  GLN A  26       1.546 -13.597  -1.621  1.00 38.33           C  
ATOM    178  CG  GLN A  26       1.074 -14.673  -2.603  1.00 48.05           C  
ATOM    179  CD  GLN A  26      -0.245 -15.321  -2.194  1.00 44.14           C  
ATOM    180  OE1 GLN A  26      -0.379 -15.849  -1.086  1.00 40.18           O  
ATOM    181  NE2 GLN A  26      -1.218 -15.293  -3.095  1.00 40.88           N  
ATOM    182  N   LYS A  27       3.531 -11.874   0.089  1.00 41.89           N  
ATOM    183  CA  LYS A  27       3.786 -10.723   0.941  1.00 41.08           C  
ATOM    184  C   LYS A  27       4.900  -9.874   0.348  1.00 44.65           C  
ATOM    185  O   LYS A  27       4.753  -8.654   0.190  1.00 39.37           O  
ATOM    186  CB  LYS A  27       4.164 -11.188   2.347  1.00 30.86           C  
ATOM    187  CG  LYS A  27       2.981 -11.727   3.130  1.00 35.60           C  
ATOM    188  CD  LYS A  27       3.442 -12.305   4.458  1.00 43.15           C  
ATOM    189  CE  LYS A  27       2.277 -12.843   5.276  1.00 40.04           C  
ATOM    190  NZ  LYS A  27       2.737 -13.293   6.633  1.00 48.42           N  
ATOM    191  N   LYS A  28       6.008 -10.526   0.006  1.00 42.62           N  
ATOM    192  CA  LYS A  28       7.143  -9.830  -0.577  1.00 39.38           C  
ATOM    193  C   LYS A  28       6.733  -9.096  -1.839  1.00 35.11           C  
ATOM    194  O   LYS A  28       7.183  -7.986  -2.099  1.00 43.32           O  
ATOM    195  CB  LYS A  28       8.258 -10.816  -0.897  1.00 49.06           C  
ATOM    196  CG  LYS A  28       9.459 -10.185  -1.572  1.00 46.90           C  
ATOM    197  CD  LYS A  28      10.609 -11.160  -1.555  1.00 52.63           C  
ATOM    198  CE  LYS A  28      11.870 -10.547  -2.116  1.00 61.13           C  
ATOM    199  NZ  LYS A  28      13.012 -11.494  -1.967  1.00 74.50           N  
ATOM    200  N   ALA A  29       5.874  -9.716  -2.630  1.00 36.49           N  
ATOM    201  CA  ALA A  29       5.429  -9.081  -3.862  1.00 45.41           C  
ATOM    202  C   ALA A  29       4.665  -7.793  -3.533  1.00 48.44           C  
ATOM    203  O   ALA A  29       4.927  -6.730  -4.104  1.00 46.07           O  
ATOM    204  CB  ALA A  29       4.541 -10.041  -4.651  1.00 40.04           C  
ATOM    205  N   PHE A  30       3.715  -7.891  -2.610  1.00 40.47           N  
ATOM    206  CA  PHE A  30       2.944  -6.731  -2.214  1.00 41.04           C  
ATOM    207  C   PHE A  30       3.828  -5.625  -1.645  1.00 40.96           C  
ATOM    208  O   PHE A  30       3.697  -4.445  -2.009  1.00 38.30           O  
ATOM    209  CB  PHE A  30       1.898  -7.128  -1.182  1.00 38.92           C  
ATOM    210  CG  PHE A  30       0.629  -7.606  -1.787  1.00 35.77           C  
ATOM    211  CD1 PHE A  30       0.372  -8.961  -1.925  1.00 37.51           C  
ATOM    212  CD2 PHE A  30      -0.309  -6.694  -2.248  1.00 37.42           C  
ATOM    213  CE1 PHE A  30      -0.817  -9.399  -2.518  1.00 46.26           C  
ATOM    214  CE2 PHE A  30      -1.496  -7.125  -2.843  1.00 37.47           C  
ATOM    215  CZ  PHE A  30      -1.747  -8.474  -2.974  1.00 37.52           C  
ATOM    216  N   ILE A  31       4.731  -6.011  -0.753  1.00 39.93           N  
ATOM    217  CA  ILE A  31       5.625  -5.055  -0.117  1.00 46.98           C  
ATOM    218  C   ILE A  31       6.463  -4.325  -1.142  1.00 51.61           C  
ATOM    219  O   ILE A  31       6.633  -3.109  -1.050  1.00 47.05           O  
ATOM    220  CB  ILE A  31       6.554  -5.745   0.890  1.00 40.40           C  
ATOM    221  CG1 ILE A  31       5.720  -6.369   2.009  1.00 53.54           C  
ATOM    222  CG2 ILE A  31       7.517  -4.742   1.478  1.00 45.80           C  
ATOM    223  CD1 ILE A  31       4.800  -5.389   2.700  1.00 39.86           C  
ATOM    224  N   PHE A  32       6.999  -5.071  -2.104  1.00 48.77           N  
ATOM    225  CA  PHE A  32       7.811  -4.466  -3.147  1.00 51.02           C  
ATOM    226  C   PHE A  32       6.980  -3.499  -3.954  1.00 49.42           C  
ATOM    227  O   PHE A  32       7.428  -2.389  -4.254  1.00 53.90           O  
ATOM    228  CB  PHE A  32       8.419  -5.542  -4.052  1.00 38.76           C  
ATOM    229  CG  PHE A  32       9.722  -6.079  -3.535  1.00 46.89           C  
ATOM    230  CD1 PHE A  32       9.898  -6.312  -2.168  1.00 36.73           C  
ATOM    231  CD2 PHE A  32      10.780  -6.348  -4.406  1.00 44.41           C  
ATOM    232  CE1 PHE A  32      11.110  -6.812  -1.676  1.00 32.03           C  
ATOM    233  CE2 PHE A  32      12.002  -6.849  -3.924  1.00 37.27           C  
ATOM    234  CZ  PHE A  32      12.168  -7.081  -2.559  1.00 46.34           C  
ATOM    235  N   SER A  33       5.761  -3.901  -4.299  1.00 42.81           N  
ATOM    236  CA  SER A  33       4.900  -3.010  -5.063  1.00 46.86           C  
ATOM    237  C   SER A  33       4.611  -1.770  -4.224  1.00 50.63           C  
ATOM    238  O   SER A  33       4.658  -0.650  -4.726  1.00 54.17           O  
ATOM    239  CB  SER A  33       3.583  -3.705  -5.438  1.00 43.99           C  
ATOM    240  OG  SER A  33       3.820  -4.823  -6.287  1.00 51.86           O  
ATOM    241  N   LEU A  34       4.327  -1.974  -2.940  1.00 52.67           N  
ATOM    242  CA  LEU A  34       4.019  -0.861  -2.039  1.00 54.99           C  
ATOM    243  C   LEU A  34       5.140   0.174  -2.115  1.00 50.33           C  
ATOM    244  O   LEU A  34       4.900   1.381  -2.232  1.00 46.79           O  
ATOM    245  CB  LEU A  34       3.852  -1.375  -0.598  1.00 50.86           C  
ATOM    246  CG  LEU A  34       3.130  -0.487   0.432  1.00 51.84           C  
ATOM    247  CD1 LEU A  34       1.718  -0.219  -0.038  1.00 47.00           C  
ATOM    248  CD2 LEU A  34       3.092  -1.169   1.798  1.00 38.55           C  
ATOM    249  N   TRP A  35       6.372  -0.303  -2.070  1.00 47.02           N  
ATOM    250  CA  TRP A  35       7.501   0.597  -2.149  1.00 53.77           C  
ATOM    251  C   TRP A  35       7.578   1.303  -3.499  1.00 63.28           C  
ATOM    252  O   TRP A  35       7.785   2.519  -3.561  1.00 66.18           O  
ATOM    253  CB  TRP A  35       8.802  -0.153  -1.896  1.00 40.22           C  
ATOM    254  CG  TRP A  35       9.981   0.768  -1.860  1.00 54.18           C  
ATOM    255  CD1 TRP A  35      10.841   1.047  -2.887  1.00 55.89           C  
ATOM    256  CD2 TRP A  35      10.399   1.582  -0.755  1.00 54.02           C  
ATOM    257  NE1 TRP A  35      11.765   1.983  -2.491  1.00 53.93           N  
ATOM    258  CE2 TRP A  35      11.517   2.330  -1.188  1.00 60.96           C  
ATOM    259  CE3 TRP A  35       9.936   1.753   0.555  1.00 55.95           C  
ATOM    260  CZ2 TRP A  35      12.181   3.238  -0.351  1.00 61.36           C  
ATOM    261  CZ3 TRP A  35      10.594   2.657   1.386  1.00 62.28           C  
ATOM    262  CH2 TRP A  35      11.705   3.388   0.928  1.00 59.33           C  
ATOM    263  N   ASP A  36       7.409   0.547  -4.578  1.00 64.00           N  
ATOM    264  CA  ASP A  36       7.484   1.136  -5.911  1.00 66.32           C  
ATOM    265  C   ASP A  36       6.468   2.241  -6.157  1.00 64.90           C  
ATOM    266  O   ASP A  36       6.733   3.171  -6.925  1.00 61.38           O  
ATOM    267  CB  ASP A  36       7.350   0.057  -6.986  1.00 70.96           C  
ATOM    268  CG  ASP A  36       8.604  -0.780  -7.119  1.00 71.66           C  
ATOM    269  OD1 ASP A  36       9.704  -0.187  -7.151  1.00 73.11           O  
ATOM    270  OD2 ASP A  36       8.493  -2.022  -7.194  1.00 77.94           O  
ATOM    271  N   ASP A  37       5.315   2.151  -5.504  1.00 59.18           N  
ATOM    272  CA  ASP A  37       4.287   3.164  -5.676  1.00 64.67           C  
ATOM    273  C   ASP A  37       3.505   3.397  -4.397  1.00 63.14           C  
ATOM    274  O   ASP A  37       2.378   2.925  -4.257  1.00 63.28           O  
ATOM    275  CB  ASP A  37       3.320   2.771  -6.800  1.00 73.47           C  
ATOM    276  CG  ASP A  37       2.206   3.800  -7.005  1.00 86.85           C  
ATOM    277  OD1 ASP A  37       2.519   4.998  -7.173  1.00 93.60           O  
ATOM    278  OD2 ASP A  37       1.015   3.410  -7.005  1.00 92.29           O  
ATOM    279  N   PRO A  38       4.097   4.133  -3.442  1.00 63.48           N  
ATOM    280  CA  PRO A  38       3.442   4.430  -2.163  1.00 61.13           C  
ATOM    281  C   PRO A  38       2.070   5.059  -2.386  1.00 60.88           C  
ATOM    282  O   PRO A  38       1.210   5.046  -1.508  1.00 63.83           O  
ATOM    283  CB  PRO A  38       4.425   5.386  -1.493  1.00 59.17           C  
ATOM    284  CG  PRO A  38       5.755   4.907  -2.004  1.00 61.67           C  
ATOM    285  CD  PRO A  38       5.462   4.690  -3.476  1.00 64.48           C  
ATOM    286  N   SER A  39       1.879   5.603  -3.581  1.00 67.02           N  
ATOM    287  CA  SER A  39       0.629   6.249  -3.966  1.00 71.32           C  
ATOM    288  C   SER A  39      -0.610   5.364  -3.777  1.00 68.81           C  
ATOM    289  O   SER A  39      -1.594   5.791  -3.170  1.00 70.93           O  
ATOM    290  CB  SER A  39       0.728   6.701  -5.432  1.00 70.93           C  
ATOM    291  OG  SER A  39      -0.452   7.346  -5.866  1.00 69.70           O  
ATOM    292  N   GLN A  40      -0.561   4.133  -4.285  1.00 66.09           N  
ATOM    293  CA  GLN A  40      -1.706   3.233  -4.178  1.00 68.56           C  
ATOM    294  C   GLN A  40      -1.625   2.217  -3.049  1.00 66.01           C  
ATOM    295  O   GLN A  40      -2.115   1.097  -3.174  1.00 62.29           O  
ATOM    296  CB  GLN A  40      -1.927   2.510  -5.508  1.00 75.93           C  
ATOM    297  CG  GLN A  40      -3.219   2.911  -6.218  1.00 83.20           C  
ATOM    298  CD  GLN A  40      -3.299   2.387  -7.641  1.00 87.58           C  
ATOM    299  OE1 GLN A  40      -3.157   1.188  -7.885  1.00 92.86           O  
ATOM    300  NE2 GLN A  40      -3.532   3.287  -8.591  1.00 90.92           N  
ATOM    301  N   SER A  41      -1.014   2.625  -1.940  1.00 62.10           N  
ATOM    302  CA  SER A  41      -0.871   1.772  -0.768  1.00 62.48           C  
ATOM    303  C   SER A  41      -2.231   1.281  -0.311  1.00 59.42           C  
ATOM    304  O   SER A  41      -2.400   0.106   0.010  1.00 60.74           O  
ATOM    305  CB  SER A  41      -0.219   2.551   0.370  1.00 65.14           C  
ATOM    306  OG  SER A  41      -0.972   3.718   0.653  1.00 81.64           O  
ATOM    307  N   ALA A  42      -3.198   2.191  -0.279  1.00 58.21           N  
ATOM    308  CA  ALA A  42      -4.551   1.847   0.139  1.00 57.92           C  
ATOM    309  C   ALA A  42      -5.107   0.746  -0.743  1.00 59.49           C  
ATOM    310  O   ALA A  42      -5.814  -0.139  -0.268  1.00 64.75           O  
ATOM    311  CB  ALA A  42      -5.450   3.066   0.061  1.00 61.99           C  
ATOM    312  N   ASN A  43      -4.787   0.803  -2.031  1.00 61.35           N  
ATOM    313  CA  ASN A  43      -5.269  -0.202  -2.967  1.00 64.31           C  
ATOM    314  C   ASN A  43      -4.600  -1.553  -2.757  1.00 57.78           C  
ATOM    315  O   ASN A  43      -5.265  -2.583  -2.774  1.00 54.56           O  
ATOM    316  CB  ASN A  43      -5.047   0.255  -4.412  1.00 76.81           C  
ATOM    317  CG  ASN A  43      -6.163   1.149  -4.921  1.00 87.59           C  
ATOM    318  OD1 ASN A  43      -6.285   2.310  -4.520  1.00 95.17           O  
ATOM    319  ND2 ASN A  43      -6.991   0.607  -5.810  1.00 93.27           N  
ATOM    320  N   LEU A  44      -3.283  -1.541  -2.572  1.00 52.89           N  
ATOM    321  CA  LEU A  44      -2.520  -2.763  -2.353  1.00 47.65           C  
ATOM    322  C   LEU A  44      -3.018  -3.490  -1.108  1.00 47.25           C  
ATOM    323  O   LEU A  44      -3.272  -4.687  -1.135  1.00 47.33           O  
ATOM    324  CB  LEU A  44      -1.040  -2.417  -2.211  1.00 48.60           C  
ATOM    325  CG  LEU A  44      -0.436  -1.834  -3.493  1.00 53.82           C  
ATOM    326  CD1 LEU A  44       0.981  -1.342  -3.239  1.00 55.54           C  
ATOM    327  CD2 LEU A  44      -0.435  -2.909  -4.576  1.00 55.62           C  
ATOM    328  N   LEU A  45      -3.181  -2.751  -0.017  1.00 52.74           N  
ATOM    329  CA  LEU A  45      -3.649  -3.328   1.236  1.00 53.07           C  
ATOM    330  C   LEU A  45      -5.008  -4.007   1.063  1.00 55.87           C  
ATOM    331  O   LEU A  45      -5.208  -5.162   1.460  1.00 55.33           O  
ATOM    332  CB  LEU A  45      -3.731  -2.226   2.304  1.00 55.24           C  
ATOM    333  CG  LEU A  45      -3.946  -2.600   3.783  1.00 53.87           C  
ATOM    334  CD1 LEU A  45      -5.420  -2.825   4.060  1.00 58.97           C  
ATOM    335  CD2 LEU A  45      -3.137  -3.849   4.127  1.00 35.00           C  
ATOM    336  N   ALA A  46      -5.945  -3.295   0.458  1.00 50.79           N  
ATOM    337  CA  ALA A  46      -7.272  -3.856   0.254  1.00 51.13           C  
ATOM    338  C   ALA A  46      -7.169  -5.146  -0.561  1.00 52.88           C  
ATOM    339  O   ALA A  46      -7.735  -6.182  -0.207  1.00 58.87           O  
ATOM    340  CB  ALA A  46      -8.148  -2.839  -0.461  1.00 44.63           C  
ATOM    341  N   GLU A  47      -6.426  -5.071  -1.653  1.00 49.47           N  
ATOM    342  CA  GLU A  47      -6.231  -6.210  -2.529  1.00 49.04           C  
ATOM    343  C   GLU A  47      -5.602  -7.372  -1.756  1.00 49.59           C  
ATOM    344  O   GLU A  47      -5.992  -8.527  -1.923  1.00 50.01           O  
ATOM    345  CB  GLU A  47      -5.324  -5.804  -3.692  1.00 51.23           C  
ATOM    346  CG  GLU A  47      -5.470  -6.666  -4.924  1.00 71.24           C  
ATOM    347  CD  GLU A  47      -6.852  -6.556  -5.535  1.00 76.71           C  
ATOM    348  OE1 GLU A  47      -7.268  -5.420  -5.853  1.00 78.82           O  
ATOM    349  OE2 GLU A  47      -7.524  -7.599  -5.696  1.00 83.28           O  
ATOM    350  N   ALA A  48      -4.630  -7.059  -0.904  1.00 40.50           N  
ATOM    351  CA  ALA A  48      -3.947  -8.080  -0.125  1.00 43.60           C  
ATOM    352  C   ALA A  48      -4.902  -8.722   0.860  1.00 42.08           C  
ATOM    353  O   ALA A  48      -4.825  -9.925   1.129  1.00 43.26           O  
ATOM    354  CB  ALA A  48      -2.769  -7.468   0.613  1.00 37.84           C  
ATOM    355  N   LYS A  49      -5.798  -7.916   1.413  1.00 45.69           N  
ATOM    356  CA  LYS A  49      -6.760  -8.443   2.362  1.00 49.43           C  
ATOM    357  C   LYS A  49      -7.716  -9.361   1.625  1.00 49.22           C  
ATOM    358  O   LYS A  49      -8.023 -10.453   2.094  1.00 48.48           O  
ATOM    359  CB  LYS A  49      -7.535  -7.315   3.041  1.00 52.67           C  
ATOM    360  CG  LYS A  49      -6.754  -6.578   4.108  1.00 47.35           C  
ATOM    361  CD  LYS A  49      -7.652  -5.574   4.818  1.00 65.66           C  
ATOM    362  CE  LYS A  49      -6.955  -4.915   5.991  1.00 65.82           C  
ATOM    363  NZ  LYS A  49      -7.828  -3.909   6.654  1.00 81.22           N  
ATOM    364  N   LYS A  50      -8.176  -8.918   0.462  1.00 47.79           N  
ATOM    365  CA  LYS A  50      -9.085  -9.723  -0.345  1.00 48.70           C  
ATOM    366  C   LYS A  50      -8.459 -11.091  -0.599  1.00 48.47           C  
ATOM    367  O   LYS A  50      -9.101 -12.122  -0.412  1.00 52.26           O  
ATOM    368  CB  LYS A  50      -9.366  -9.017  -1.678  1.00 59.68           C  
ATOM    369  CG  LYS A  50     -10.315  -9.765  -2.608  1.00 74.22           C  
ATOM    370  CD  LYS A  50     -10.609  -8.961  -3.871  1.00 89.09           C  
ATOM    371  CE  LYS A  50     -11.502  -9.734  -4.840  1.00 97.60           C  
ATOM    372  NZ  LYS A  50     -11.833  -8.947  -6.068  1.00101.38           N  
ATOM    373  N   LEU A  51      -7.195 -11.099  -1.013  1.00 49.54           N  
ATOM    374  CA  LEU A  51      -6.498 -12.349  -1.286  1.00 44.80           C  
ATOM    375  C   LEU A  51      -6.328 -13.143   0.009  1.00 46.21           C  
ATOM    376  O   LEU A  51      -6.312 -14.372  -0.001  1.00 47.71           O  
ATOM    377  CB  LEU A  51      -5.129 -12.061  -1.909  1.00 47.34           C  
ATOM    378  CG  LEU A  51      -4.414 -13.233  -2.585  1.00 62.55           C  
ATOM    379  CD1 LEU A  51      -5.258 -13.756  -3.743  1.00 51.53           C  
ATOM    380  CD2 LEU A  51      -3.053 -12.778  -3.081  1.00 62.76           C  
ATOM    381  N   ASN A  52      -6.187 -12.444   1.133  1.00 45.11           N  
ATOM    382  CA  ASN A  52      -6.047 -13.139   2.410  1.00 42.24           C  
ATOM    383  C   ASN A  52      -7.345 -13.888   2.700  1.00 39.33           C  
ATOM    384  O   ASN A  52      -7.346 -14.947   3.327  1.00 39.59           O  
ATOM    385  CB  ASN A  52      -5.793 -12.164   3.555  1.00 38.88           C  
ATOM    386  CG  ASN A  52      -5.671 -12.868   4.896  1.00 35.18           C  
ATOM    387  OD1 ASN A  52      -4.676 -13.544   5.168  1.00 42.31           O  
ATOM    388  ND2 ASN A  52      -6.697 -12.732   5.734  1.00 37.33           N  
ATOM    389  N   ASP A  53      -8.447 -13.320   2.233  1.00 42.37           N  
ATOM    390  CA  ASP A  53      -9.758 -13.906   2.442  1.00 50.71           C  
ATOM    391  C   ASP A  53      -9.969 -15.073   1.484  1.00 55.16           C  
ATOM    392  O   ASP A  53     -10.515 -16.106   1.874  1.00 61.52           O  
ATOM    393  CB  ASP A  53     -10.839 -12.846   2.226  1.00 46.05           C  
ATOM    394  CG  ASP A  53     -12.188 -13.251   2.815  1.00 63.61           C  
ATOM    395  OD1 ASP A  53     -12.343 -14.429   3.210  1.00 54.23           O  
ATOM    396  OD2 ASP A  53     -13.098 -12.389   2.877  1.00 58.92           O  
ATOM    397  N   ALA A  54      -9.527 -14.916   0.238  1.00 48.96           N  
ATOM    398  CA  ALA A  54      -9.692 -15.981  -0.749  1.00 49.97           C  
ATOM    399  C   ALA A  54      -8.935 -17.226  -0.332  1.00 49.52           C  
ATOM    400  O   ALA A  54      -9.396 -18.343  -0.560  1.00 54.60           O  
ATOM    401  CB  ALA A  54      -9.212 -15.522  -2.136  1.00 39.04           C  
ATOM    402  N   GLN A  55      -7.784 -17.038   0.304  1.00 52.15           N  
ATOM    403  CA  GLN A  55      -6.974 -18.171   0.714  1.00 41.10           C  
ATOM    404  C   GLN A  55      -7.242 -18.632   2.135  1.00 48.50           C  
ATOM    405  O   GLN A  55      -6.506 -19.464   2.682  1.00 46.57           O  
ATOM    406  CB  GLN A  55      -5.499 -17.832   0.502  1.00 54.96           C  
ATOM    407  CG  GLN A  55      -5.198 -17.603  -0.980  1.00 52.58           C  
ATOM    408  CD  GLN A  55      -3.834 -16.996  -1.257  1.00 56.37           C  
ATOM    409  OE1 GLN A  55      -3.543 -16.632  -2.393  1.00 67.08           O  
ATOM    410  NE2 GLN A  55      -2.993 -16.883  -0.226  1.00 48.09           N  
ATOM    411  N   ALA A  56      -8.302 -18.106   2.737  1.00 51.09           N  
ATOM    412  CA  ALA A  56      -8.650 -18.525   4.089  1.00 56.72           C  
ATOM    413  C   ALA A  56      -9.094 -19.981   3.977  1.00 59.84           C  
ATOM    414  O   ALA A  56      -9.500 -20.428   2.901  1.00 57.44           O  
ATOM    415  CB  ALA A  56      -9.775 -17.672   4.634  1.00 53.21           C  
ATOM    416  N   PRO A  57      -9.018 -20.741   5.081  1.00 59.37           N  
ATOM    417  CA  PRO A  57      -9.411 -22.152   5.104  1.00 64.80           C  
ATOM    418  C   PRO A  57     -10.710 -22.453   4.356  1.00 66.94           C  
ATOM    419  O   PRO A  57     -11.716 -21.762   4.527  1.00 62.07           O  
ATOM    420  CB  PRO A  57      -9.503 -22.447   6.594  1.00 65.28           C  
ATOM    421  CG  PRO A  57      -8.391 -21.619   7.143  1.00 59.41           C  
ATOM    422  CD  PRO A  57      -8.567 -20.306   6.415  1.00 59.06           C  
ATOM    423  N   LYS A  58     -10.670 -23.487   3.521  1.00 76.33           N  
ATOM    424  CA  LYS A  58     -11.823 -23.897   2.726  1.00 87.26           C  
ATOM    425  C   LYS A  58     -12.484 -25.144   3.307  1.00 88.80           C  
ATOM    426  O   LYS A  58     -13.673 -25.050   3.678  1.00 93.47           O  
ATOM    427  CB  LYS A  58     -11.398 -24.170   1.277  1.00 89.74           C  
ATOM    428  CG  LYS A  58      -9.887 -24.181   1.047  1.00 98.24           C  
ATOM    429  CD  LYS A  58      -9.175 -25.206   1.925  1.00102.04           C  
ATOM    430  CE  LYS A  58      -7.664 -25.051   1.847  1.00103.96           C  
ATOM    431  NZ  LYS A  58      -6.965 -25.970   2.786  1.00109.95           N  
ATOM    432  OXT LYS A  58     -11.809 -26.193   3.386  1.00 93.86           O  
TER     433      LYS A  58                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
