
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   55 (  437),  selected   55 , name 2vdb_B
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 2vdb_B.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -1_B      -       -           -
LGA    M     0_B      -       -           -
LGA    T     1_B      -       -           -
LGA    I     2_B      -       -           -
LGA    D     3_B      -       -           -
LGA    Q     4_B      -       -           -
LGA    W     5_B      -       -           -
LGA    L     6_B      N       8          1.098
LGA    L     7_B      L       9          0.537
LGA    K     8_B      K      10          1.779
LGA    N     9_B      Q      11          2.039
LGA    A    10_B      A      12          1.027
LGA    K    11_B      K      13          0.343
LGA    E    12_B      E      14          1.060
LGA    D    13_B      E      15          1.101
LGA    A    14_B      A      16          1.980
LGA    I    15_B      I      17          1.779
LGA    A    16_B      K      18          0.825
LGA    E    17_B      E      19          0.892
LGA    L    18_B      L      20          2.125
LGA    K    19_B      V      21          2.178
LGA    K    20_B      D      22          0.920
LGA    A    21_B      A      23          0.857
LGA    G    22_B      G      24          1.569
LGA    I    23_B      T      25          1.469
LGA    T    24_B      A      26          5.141
LGA    S    25_B      -       -           -
LGA    D    26_B      E      27          3.891
LGA    F    27_B      K      28          1.423
LGA    Y    28_B      Y      29          1.578
LGA    F    29_B      I      30          1.715
LGA    N    30_B      K      31          0.955
LGA    A    31_B      L      32          0.426
LGA    I    32_B      I      33          1.209
LGA    N    33_B      A      34          0.544
LGA    K    34_B      N      35          1.102
LGA    A    35_B      A      36          0.589
LGA    K    36_B      K      37          0.501
LGA    T    37_B      T      38          0.953
LGA    V    38_B      V      39          0.831
LGA    E    39_B      E      40          0.653
LGA    E    40_B      G      41          0.591
LGA    V    41_B      V      42          0.788
LGA    N    42_B      W      43          1.049
LGA    A    43_B      T      44          1.379
LGA    L    44_B      L      45          1.395
LGA    K    45_B      K      46          1.485
LGA    N    46_B      D      47          1.590
LGA    E    47_B      E      48          0.894
LGA    I    48_B      I      49          0.795
LGA    L    49_B      K      50          0.468
LGA    K    50_B      T      51          0.145
LGA    A    51_B      F      52          0.548
LGA    H    52_B      -       -           -
LGA    A    53_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   55   45    5.0     45    1.53    51.11     94.133     2.769

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.897275 * X  +  -0.346532 * Y  +   0.273520 * Z  + -49.706516
  Y_new =  -0.337425 * X  +  -0.937838 * Y  +  -0.081265 * Z  +  12.422848
  Z_new =   0.284679 * X  +  -0.019376 * Y  +  -0.958427 * Z  +  -8.690699 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.121379    0.020213  [ DEG:  -178.8419      1.1581 ]
  Theta =  -0.288671   -2.852921  [ DEG:   -16.5396   -163.4604 ]
  Phi   =  -0.359696    2.781897  [ DEG:   -20.6091    159.3909 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vdb_B                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vdb_B.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   55   45   5.0   45   1.53   51.11  94.133
REMARK  ---------------------------------------------------------- 
MOLECULE 2vdb_B
HEADER    PROTEIN BINDING                         04-OCT-07   2VDB              
TITLE     STRUCTURE OF HUMAN SERUM ALBUMIN WITH S-NAPROXEN AND THE GA           
TITLE    2 MODULE                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SERUM ALBUMIN;                                             
COMPND   3 SYNONYM: HUMAN SERUM ALBUMIN;                                        
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: RESIDUES 30-608;                                           
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: PEPTOSTREPTOCOCCAL ALBUMIN-BINDING PROTEIN;                
COMPND   8 SYNONYM: GA MODULE;                                                  
COMPND   9 CHAIN: B;                                                            
COMPND  10 FRAGMENT: RESIDUES 213-265;                                          
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 TISSUE: SERUM;                                                       
SOURCE   5 MOL_ID: 2;                                                           
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28;                                    
SOURCE   9 ORGANISM_SCIENTIFIC: PEPTOSTREPTOCOCCUS MAGNUS                       
KEYWDS    LIPID-BINDING, METAL-BINDING, PROTEIN BINDING,                        
KEYWDS   2 PEPTIDOGLYCAN-ANCHOR, BACTERIAL ALBUMIN-BINDING,                     
KEYWDS   3 DISEASE MUTATION, THREE-HELIX BUNDLE,                                
KEYWDS   4 GA MODULE, POLYMORPHISM, DRUG BINDING, GLYCOPROTEIN,                 
KEYWDS   5 CLEAVAGE ON PAIR OF BASIC RESIDUES,                                  
KEYWDS   6 HUMAN SERUM ALBUMIN, ALTERNATIVE SPLICING,                           
KEYWDS   7 COPPER, SECRETED, NAPROXEN, CELL WALL, GLYCATION                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.LEJON,J.F.CRAMER,P.A.NORDBERG                                       
REVDAT   1   26-FEB-08 2VDB    0                                                
JRNL        AUTH   S.LEJON,J.F.CRAMER,P.A.NORDBERG                              
JRNL        TITL   STRUCTURAL BASIS FOR THE BINDING OF NAPROXEN TO              
JRNL        TITL 2 HUMAN SERUM ALBUMIN IN THE PRESENCE OF FATTY ACIDS           
JRNL        TITL 3 AND THE GA MODULE.                                           
JRNL        REF    ACTA CRYSTALLOGR.,SECT.F      V.  64    64 2008              
JRNL        REFN   ASTM ACSFCL  DK ISSN 1744-3091                               
REMARK   2 RESOLUTION. 2.52 ANGSTROMS.                                          
DBREF  2VDB A    6   584  UNP    P02768   ALBU_HUMAN      30    608             
DBREF  2VDB B   -1     0  PDB    2VDB     2VDB            -1      0             
DBREF  2VDB B    1    53  UNP    Q51911   PAB_PEPMA      213    265             
SEQRES   1 A  579  GLU VAL ALA HIS ARG PHE LYS ASP LEU GLY GLU GLU ASN          
SEQRES   2 A  579  PHE LYS ALA LEU VAL LEU ILE ALA PHE ALA GLN TYR LEU          
SEQRES   3 A  579  GLN GLN CYS PRO PHE GLU ASP HIS VAL LYS LEU VAL ASN          
SEQRES   4 A  579  GLU VAL THR GLU PHE ALA LYS THR CYS VAL ALA ASP GLU          
SEQRES   5 A  579  SER ALA GLU ASN CYS ASP LYS SER LEU HIS THR LEU PHE          
SEQRES   6 A  579  GLY ASP LYS LEU CYS THR VAL ALA THR LEU ARG GLU THR          
SEQRES   7 A  579  TYR GLY GLU MET ALA ASP CYS CYS ALA LYS GLN GLU PRO          
SEQRES   8 A  579  GLU ARG ASN GLU CYS PHE LEU GLN HIS LYS ASP ASP ASN          
SEQRES   9 A  579  PRO ASN LEU PRO ARG LEU VAL ARG PRO GLU VAL ASP VAL          
SEQRES  10 A  579  MET CYS THR ALA PHE HIS ASP ASN GLU GLU THR PHE LEU          
SEQRES  11 A  579  LYS LYS TYR LEU TYR GLU ILE ALA ARG ARG HIS PRO TYR          
SEQRES  12 A  579  PHE TYR ALA PRO GLU LEU LEU PHE PHE ALA LYS ARG TYR          
SEQRES  13 A  579  LYS ALA ALA PHE THR GLU CYS CYS GLN ALA ALA ASP LYS          
SEQRES  14 A  579  ALA ALA CYS LEU LEU PRO LYS LEU ASP GLU LEU ARG ASP          
SEQRES  15 A  579  GLU GLY LYS ALA SER SER ALA LYS GLN ARG LEU LYS CYS          
SEQRES  16 A  579  ALA SER LEU GLN LYS PHE GLY GLU ARG ALA PHE LYS ALA          
SEQRES  17 A  579  TRP ALA VAL ALA ARG LEU SER GLN ARG PHE PRO LYS ALA          
SEQRES  18 A  579  GLU PHE ALA GLU VAL SER LYS LEU VAL THR ASP LEU THR          
SEQRES  19 A  579  LYS VAL HIS THR GLU CYS CYS HIS GLY ASP LEU LEU GLU          
SEQRES  20 A  579  CYS ALA ASP ASP ARG ALA ASP LEU ALA LYS TYR ILE CYS          
SEQRES  21 A  579  GLU ASN GLN ASP SER ILE SER SER LYS LEU LYS GLU CYS          
SEQRES  22 A  579  CYS GLU LYS PRO LEU LEU GLU LYS SER HIS CYS ILE ALA          
SEQRES  23 A  579  GLU VAL GLU ASN ASP GLU MET PRO ALA ASP LEU PRO SER          
SEQRES  24 A  579  LEU ALA ALA ASP PHE VAL GLU SER LYS ASP VAL CYS LYS          
SEQRES  25 A  579  ASN TYR ALA GLU ALA LYS ASP VAL PHE LEU GLY MET PHE          
SEQRES  26 A  579  LEU TYR GLU TYR ALA ARG ARG HIS PRO ASP TYR SER VAL          
SEQRES  27 A  579  VAL LEU LEU LEU ARG LEU ALA LYS THR TYR GLU THR THR          
SEQRES  28 A  579  LEU GLU LYS CYS CYS ALA ALA ALA ASP PRO HIS GLU CYS          
SEQRES  29 A  579  TYR ALA LYS VAL PHE ASP GLU PHE LYS PRO LEU VAL GLU          
SEQRES  30 A  579  GLU PRO GLN ASN LEU ILE LYS GLN ASN CYS GLU LEU PHE          
SEQRES  31 A  579  GLU GLN LEU GLY GLU TYR LYS PHE GLN ASN ALA LEU LEU          
SEQRES  32 A  579  VAL ARG TYR THR LYS LYS VAL PRO GLN VAL SER THR PRO          
SEQRES  33 A  579  THR LEU VAL GLU VAL SER ARG ASN LEU GLY LYS VAL GLY          
SEQRES  34 A  579  SER LYS CYS CYS LYS HIS PRO GLU ALA LYS ARG MET PRO          
SEQRES  35 A  579  CYS ALA GLU ASP TYR LEU SER VAL VAL LEU ASN GLN LEU          
SEQRES  36 A  579  CYS VAL LEU HIS GLU LYS THR PRO VAL SER ASP ARG VAL          
SEQRES  37 A  579  THR LYS CYS CYS THR GLU SER LEU VAL ASN ARG ARG PRO          
SEQRES  38 A  579  CYS PHE SER ALA LEU GLU VAL ASP GLU THR TYR VAL PRO          
SEQRES  39 A  579  LYS GLU PHE ASN ALA GLU THR PHE THR PHE HIS ALA ASP          
SEQRES  40 A  579  ILE CYS THR LEU SER GLU LYS GLU ARG GLN ILE LYS LYS          
SEQRES  41 A  579  GLN THR ALA LEU VAL GLU LEU VAL LYS HIS LYS PRO LYS          
SEQRES  42 A  579  ALA THR LYS GLU GLN LEU LYS ALA VAL MET ASP ASP PHE          
SEQRES  43 A  579  ALA ALA PHE VAL GLU LYS CYS CYS LYS ALA ASP ASP LYS          
SEQRES  44 A  579  GLU THR CYS PHE ALA GLU GLU GLY LYS LYS LEU VAL ALA          
SEQRES  45 A  579  ALA SER GLN ALA ALA LEU GLY                                  
SEQRES   1 B   55  HIS MET THR ILE ASP GLN TRP LEU LEU LYS ASN ALA LYS          
SEQRES   2 B   55  GLU ASP ALA ILE ALA GLU LEU LYS LYS ALA GLY ILE THR          
SEQRES   3 B   55  SER ASP PHE TYR PHE ASN ALA ILE ASN LYS ALA LYS THR          
SEQRES   4 B   55  VAL GLU GLU VAL ASN ALA LEU LYS ASN GLU ILE LEU LYS          
SEQRES   5 B   55  ALA HIS ALA                                                  
HET    DKA  A1585      12                                                       
HET    DKA  A1586      12                                                       
HET    DKA  A1587      12                                                       
HET    DKA  A1588      12                                                       
HET    DKA  A1589      12                                                       
HET    DKA  A1590      12                                                       
HET    NPS  A1591      17                                                       
HETNAM     NPS (2S)-2-(6-METHOXYNAPHTHALEN-2-YL)PROPANOIC                       
HETNAM   2 NPS  ACID                                                            
HETNAM     DKA DECANOIC ACID                                                    
FORMUL   3  NPS    C14 H14 O3                                                   
FORMUL   4  DKA    6(C10 H20 O2)                                                
CRYST1  190.507   49.462   79.933  90.00  93.00  90.00 C 1 2 1       4          
ATOM   4348  N   HIS B  -1      15.744  16.268   4.747  1.00 68.77           N  
ATOM   4349  CA  HIS B  -1      14.521  16.368   5.600  1.00 68.73           C  
ATOM   4350  C   HIS B  -1      13.245  16.196   4.776  1.00 67.18           C  
ATOM   4351  O   HIS B  -1      12.966  16.975   3.849  1.00 65.94           O  
ATOM   4352  CB  HIS B  -1      14.489  17.694   6.379  1.00 70.35           C  
ATOM   4353  CG  HIS B  -1      15.249  17.658   7.671  1.00 71.65           C  
ATOM   4354  ND1 HIS B  -1      16.610  17.871   7.744  1.00 72.17           N  
ATOM   4355  CD2 HIS B  -1      14.834  17.445   8.943  1.00 72.20           C  
ATOM   4356  CE1 HIS B  -1      17.001  17.789   9.003  1.00 72.80           C  
ATOM   4357  NE2 HIS B  -1      15.943  17.531   9.752  1.00 73.05           N  
ATOM   4358  N   MET B   0      12.476  15.170   5.148  1.00 65.37           N  
ATOM   4359  CA  MET B   0      11.265  14.768   4.431  1.00 63.25           C  
ATOM   4360  C   MET B   0      10.186  15.841   4.413  1.00 61.10           C  
ATOM   4361  O   MET B   0      10.061  16.622   5.349  1.00 60.87           O  
ATOM   4362  CB  MET B   0      10.683  13.504   5.053  1.00 63.44           C  
ATOM   4363  CG  MET B   0      11.563  12.293   4.945  1.00 64.40           C  
ATOM   4364  SD  MET B   0      10.585  10.782   5.094  1.00 65.54           S  
ATOM   4365  CE  MET B   0      11.805   9.651   5.778  1.00 64.65           C  
ATOM   4366  N   THR B   1       9.402  15.881   3.341  1.00 58.78           N  
ATOM   4367  CA  THR B   1       8.201  16.693   3.358  1.00 56.10           C  
ATOM   4368  C   THR B   1       7.174  15.943   4.175  1.00 54.62           C  
ATOM   4369  O   THR B   1       7.315  14.736   4.421  1.00 53.91           O  
ATOM   4370  CB  THR B   1       7.634  16.984   1.945  1.00 55.57           C  
ATOM   4371  OG1 THR B   1       7.291  15.757   1.277  1.00 55.40           O  
ATOM   4372  CG2 THR B   1       8.640  17.776   1.121  1.00 55.09           C  
ATOM   4373  N   ILE B   2       6.142  16.652   4.610  1.00 53.27           N  
ATOM   4374  CA  ILE B   2       5.051  15.984   5.286  1.00 51.56           C  
ATOM   4375  C   ILE B   2       4.510  14.897   4.359  1.00 49.84           C  
ATOM   4376  O   ILE B   2       4.338  13.751   4.774  1.00 49.96           O  
ATOM   4377  CB  ILE B   2       3.965  16.968   5.804  1.00 51.60           C  
ATOM   4378  CG1 ILE B   2       3.114  16.277   6.857  1.00 51.75           C  
ATOM   4379  CG2 ILE B   2       3.088  17.512   4.690  1.00 52.23           C  
ATOM   4380  CD1 ILE B   2       3.825  16.156   8.185  1.00 51.73           C  
ATOM   4381  N   ASP B   3       4.299  15.240   3.092  1.00 48.26           N  
ATOM   4382  CA  ASP B   3       3.875  14.241   2.091  1.00 46.45           C  
ATOM   4383  C   ASP B   3       4.758  13.006   2.037  1.00 44.29           C  
ATOM   4384  O   ASP B   3       4.257  11.889   2.065  1.00 43.87           O  
ATOM   4385  CB  ASP B   3       3.723  14.875   0.716  1.00 47.01           C  
ATOM   4386  CG  ASP B   3       2.463  15.705   0.618  1.00 48.80           C  
ATOM   4387  OD1 ASP B   3       1.365  15.109   0.707  1.00 50.01           O  
ATOM   4388  OD2 ASP B   3       2.558  16.945   0.483  1.00 49.14           O  
ATOM   4389  N   GLN B   4       6.070  13.194   1.982  1.00 42.66           N  
ATOM   4390  CA  GLN B   4       6.968  12.049   1.942  1.00 41.54           C  
ATOM   4391  C   GLN B   4       6.890  11.217   3.224  1.00 40.74           C  
ATOM   4392  O   GLN B   4       6.971   9.984   3.162  1.00 41.02           O  
ATOM   4393  CB  GLN B   4       8.404  12.490   1.682  1.00 42.01           C  
ATOM   4394  CG  GLN B   4       8.654  13.090   0.317  1.00 42.08           C  
ATOM   4395  CD  GLN B   4      10.126  13.393   0.090  1.00 43.22           C  
ATOM   4396  OE1 GLN B   4      10.800  14.004   0.942  1.00 44.11           O  
ATOM   4397  NE2 GLN B   4      10.640  12.966  -1.055  1.00 43.47           N  
ATOM   4398  N   TRP B   5       6.727  11.890   4.369  1.00 38.85           N  
ATOM   4399  CA  TRP B   5       6.575  11.219   5.665  1.00 37.11           C  
ATOM   4400  C   TRP B   5       5.325  10.364   5.693  1.00 36.38           C  
ATOM   4401  O   TRP B   5       5.386   9.204   6.069  1.00 36.42           O  
ATOM   4402  CB  TRP B   5       6.509  12.241   6.808  1.00 37.04           C  
ATOM   4403  CG  TRP B   5       6.639  11.660   8.218  1.00 36.70           C  
ATOM   4404  CD1 TRP B   5       7.797  11.493   8.926  1.00 36.97           C  
ATOM   4405  CD2 TRP B   5       5.579  11.203   9.081  1.00 36.49           C  
ATOM   4406  NE1 TRP B   5       7.531  10.949  10.161  1.00 36.47           N  
ATOM   4407  CE2 TRP B   5       6.180  10.761  10.284  1.00 36.43           C  
ATOM   4408  CE3 TRP B   5       4.185  11.114   8.953  1.00 36.33           C  
ATOM   4409  CZ2 TRP B   5       5.433  10.247  11.358  1.00 36.22           C  
ATOM   4410  CZ3 TRP B   5       3.445  10.602  10.032  1.00 36.54           C  
ATOM   4411  CH2 TRP B   5       4.075  10.180  11.214  1.00 35.92           C  
ATOM   4412  N   LEU B   6       4.191  10.941   5.310  1.00 35.97           N  
ATOM   4413  CA  LEU B   6       2.934  10.203   5.304  1.00 36.90           C  
ATOM   4414  C   LEU B   6       3.057   8.972   4.423  1.00 38.59           C  
ATOM   4415  O   LEU B   6       2.742   7.874   4.858  1.00 40.33           O  
ATOM   4416  CB  LEU B   6       1.765  11.087   4.848  1.00 36.09           C  
ATOM   4417  CG  LEU B   6       1.220  12.192   5.765  1.00 36.48           C  
ATOM   4418  CD1 LEU B   6       0.435  13.284   5.024  1.00 35.60           C  
ATOM   4419  CD2 LEU B   6       0.385  11.607   6.904  1.00 36.58           C  
ATOM   4420  N   LEU B   7       3.541   9.143   3.191  1.00 39.99           N  
ATOM   4421  CA  LEU B   7       3.717   8.011   2.274  1.00 41.00           C  
ATOM   4422  C   LEU B   7       4.587   6.894   2.874  1.00 43.10           C  
ATOM   4423  O   LEU B   7       4.236   5.704   2.748  1.00 44.79           O  
ATOM   4424  CB  LEU B   7       4.261   8.449   0.904  1.00 39.22           C  
ATOM   4425  CG  LEU B   7       4.432   7.357  -0.181  1.00 39.28           C  
ATOM   4426  CD1 LEU B   7       3.099   6.856  -0.684  1.00 38.47           C  
ATOM   4427  CD2 LEU B   7       5.292   7.799  -1.380  1.00 37.86           C  
ATOM   4428  N   LYS B   8       5.705   7.253   3.514  1.00 43.05           N  
ATOM   4429  CA  LYS B   8       6.606   6.229   4.049  1.00 43.28           C  
ATOM   4430  C   LYS B   8       5.849   5.465   5.127  1.00 43.48           C  
ATOM   4431  O   LYS B   8       5.803   4.242   5.123  1.00 44.90           O  
ATOM   4432  CB  LYS B   8       7.883   6.847   4.619  1.00 43.76           C  
ATOM   4433  CG  LYS B   8       9.083   5.910   4.629  1.00 44.51           C  
ATOM   4434  CD  LYS B   8      10.136   6.358   5.642  1.00 45.11           C  
ATOM   4435  CE  LYS B   8      11.575   6.008   5.224  1.00 45.87           C  
ATOM   4436  NZ  LYS B   8      11.811   4.580   4.800  1.00 45.90           N  
ATOM   4437  N   ASN B   9       5.225   6.202   6.031  1.00 42.51           N  
ATOM   4438  CA  ASN B   9       4.404   5.608   7.063  1.00 42.16           C  
ATOM   4439  C   ASN B   9       3.358   4.639   6.551  1.00 42.33           C  
ATOM   4440  O   ASN B   9       3.271   3.503   7.022  1.00 43.11           O  
ATOM   4441  CB  ASN B   9       3.728   6.700   7.873  1.00 42.39           C  
ATOM   4442  CG  ASN B   9       4.396   6.930   9.199  1.00 42.34           C  
ATOM   4443  OD1 ASN B   9       3.721   7.168  10.185  1.00 43.99           O  
ATOM   4444  ND2 ASN B   9       5.721   6.844   9.240  1.00 41.57           N  
ATOM   4445  N   ALA B  10       2.569   5.086   5.577  1.00 42.17           N  
ATOM   4446  CA  ALA B  10       1.472   4.283   5.059  1.00 41.39           C  
ATOM   4447  C   ALA B  10       1.971   2.936   4.574  1.00 41.89           C  
ATOM   4448  O   ALA B  10       1.322   1.915   4.780  1.00 43.15           O  
ATOM   4449  CB  ALA B  10       0.743   5.025   3.975  1.00 40.05           C  
ATOM   4450  N   LYS B  11       3.150   2.943   3.966  1.00 42.50           N  
ATOM   4451  CA  LYS B  11       3.807   1.730   3.466  1.00 42.50           C  
ATOM   4452  C   LYS B  11       4.205   0.752   4.566  1.00 42.30           C  
ATOM   4453  O   LYS B  11       3.900  -0.439   4.474  1.00 42.39           O  
ATOM   4454  CB  LYS B  11       5.038   2.105   2.641  1.00 42.68           C  
ATOM   4455  CG  LYS B  11       4.707   2.670   1.280  1.00 42.77           C  
ATOM   4456  CD  LYS B  11       5.929   3.237   0.633  1.00 43.20           C  
ATOM   4457  CE  LYS B  11       5.625   3.679  -0.779  1.00 43.33           C  
ATOM   4458  NZ  LYS B  11       6.863   4.236  -1.349  1.00 44.20           N  
ATOM   4459  N   GLU B  12       4.876   1.248   5.600  1.00 42.42           N  
ATOM   4460  CA  GLU B  12       5.212   0.407   6.752  1.00 43.39           C  
ATOM   4461  C   GLU B  12       3.933  -0.105   7.375  1.00 43.06           C  
ATOM   4462  O   GLU B  12       3.786  -1.293   7.619  1.00 42.58           O  
ATOM   4463  CB  GLU B  12       6.039   1.183   7.782  1.00 44.39           C  
ATOM   4464  CG  GLU B  12       6.987   2.186   7.135  1.00 46.03           C  
ATOM   4465  CD  GLU B  12       8.344   2.292   7.824  1.00 47.20           C  
ATOM   4466  OE1 GLU B  12       8.385   2.623   9.038  1.00 46.78           O  
ATOM   4467  OE2 GLU B  12       9.374   2.070   7.125  1.00 47.90           O  
ATOM   4468  N   ASP B  13       2.995   0.803   7.602  1.00 43.82           N  
ATOM   4469  CA  ASP B  13       1.701   0.441   8.144  1.00 45.45           C  
ATOM   4470  C   ASP B  13       1.066  -0.692   7.367  1.00 45.54           C  
ATOM   4471  O   ASP B  13       0.648  -1.700   7.934  1.00 45.61           O  
ATOM   4472  CB  ASP B  13       0.771   1.638   8.083  1.00 47.01           C  
ATOM   4473  CG  ASP B  13       0.844   2.486   9.311  1.00 48.63           C  
ATOM   4474  OD1 ASP B  13       1.744   2.260  10.161  1.00 49.54           O  
ATOM   4475  OD2 ASP B  13      -0.021   3.378   9.435  1.00 49.93           O  
ATOM   4476  N   ALA B  14       0.998  -0.511   6.056  1.00 45.44           N  
ATOM   4477  CA  ALA B  14       0.279  -1.433   5.203  1.00 45.58           C  
ATOM   4478  C   ALA B  14       0.975  -2.772   5.146  1.00 45.48           C  
ATOM   4479  O   ALA B  14       0.328  -3.807   5.022  1.00 46.01           O  
ATOM   4480  CB  ALA B  14       0.099  -0.852   3.810  1.00 44.78           C  
ATOM   4481  N   ILE B  15       2.294  -2.758   5.262  1.00 45.47           N  
ATOM   4482  CA  ILE B  15       3.071  -3.990   5.166  1.00 45.85           C  
ATOM   4483  C   ILE B  15       2.939  -4.837   6.434  1.00 45.77           C  
ATOM   4484  O   ILE B  15       2.761  -6.059   6.364  1.00 45.65           O  
ATOM   4485  CB  ILE B  15       4.540  -3.668   4.809  1.00 46.44           C  
ATOM   4486  CG1 ILE B  15       4.615  -3.241   3.334  1.00 46.27           C  
ATOM   4487  CG2 ILE B  15       5.459  -4.844   5.101  1.00 45.85           C  
ATOM   4488  CD1 ILE B  15       5.877  -2.472   2.980  1.00 46.08           C  
ATOM   4489  N   ALA B  16       3.000  -4.179   7.586  1.00 45.87           N  
ATOM   4490  CA  ALA B  16       2.655  -4.814   8.852  1.00 45.72           C  
ATOM   4491  C   ALA B  16       1.240  -5.370   8.786  1.00 45.93           C  
ATOM   4492  O   ALA B  16       0.993  -6.522   9.158  1.00 45.85           O  
ATOM   4493  CB  ALA B  16       2.761  -3.824   9.988  1.00 45.22           C  
ATOM   4494  N   GLU B  17       0.307  -4.551   8.305  1.00 45.74           N  
ATOM   4495  CA  GLU B  17      -1.089  -4.959   8.305  1.00 46.32           C  
ATOM   4496  C   GLU B  17      -1.298  -6.178   7.411  1.00 45.51           C  
ATOM   4497  O   GLU B  17      -2.067  -7.069   7.769  1.00 46.57           O  
ATOM   4498  CB  GLU B  17      -2.025  -3.803   7.939  1.00 47.28           C  
ATOM   4499  CG  GLU B  17      -3.463  -4.247   7.664  1.00 49.08           C  
ATOM   4500  CD  GLU B  17      -4.470  -3.105   7.712  1.00 50.00           C  
ATOM   4501  OE1 GLU B  17      -4.060  -1.939   7.524  1.00 50.87           O  
ATOM   4502  OE2 GLU B  17      -5.677  -3.373   7.946  1.00 51.08           O  
ATOM   4503  N   LEU B  18      -0.592  -6.234   6.280  1.00 43.23           N  
ATOM   4504  CA  LEU B  18      -0.555  -7.444   5.458  1.00 41.59           C  
ATOM   4505  C   LEU B  18       0.150  -8.619   6.146  1.00 41.96           C  
ATOM   4506  O   LEU B  18      -0.252  -9.778   6.009  1.00 41.50           O  
ATOM   4507  CB  LEU B  18       0.135  -7.153   4.136  1.00 40.48           C  
ATOM   4508  CG  LEU B  18      -0.521  -6.038   3.312  1.00 39.80           C  
ATOM   4509  CD1 LEU B  18       0.317  -5.712   2.106  1.00 38.12           C  
ATOM   4510  CD2 LEU B  18      -1.978  -6.376   2.926  1.00 39.44           C  
ATOM   4511  N   LYS B  19       1.218  -8.330   6.878  1.00 42.40           N  
ATOM   4512  CA  LYS B  19       1.955  -9.398   7.518  1.00 42.40           C  
ATOM   4513  C   LYS B  19       1.053 -10.051   8.547  1.00 42.52           C  
ATOM   4514  O   LYS B  19       1.051 -11.277   8.687  1.00 42.94           O  
ATOM   4515  CB  LYS B  19       3.241  -8.878   8.149  1.00 42.80           C  
ATOM   4516  CG  LYS B  19       4.376  -8.679   7.159  1.00 43.61           C  
ATOM   4517  CD  LYS B  19       5.635  -8.152   7.864  1.00 44.30           C  
ATOM   4518  CE  LYS B  19       6.812  -8.013   6.882  1.00 44.38           C  
ATOM   4519  NZ  LYS B  19       7.931  -7.228   7.484  1.00 44.38           N  
ATOM   4520  N   LYS B  20       0.263  -9.230   9.242  1.00 41.98           N  
ATOM   4521  CA  LYS B  20      -0.652  -9.734  10.274  1.00 41.37           C  
ATOM   4522  C   LYS B  20      -1.822 -10.516   9.686  1.00 40.77           C  
ATOM   4523  O   LYS B  20      -2.567 -11.156  10.421  1.00 39.87           O  
ATOM   4524  CB  LYS B  20      -1.179  -8.607  11.171  1.00 41.10           C  
ATOM   4525  CG  LYS B  20      -0.360  -8.363  12.413  1.00 41.09           C  
ATOM   4526  CD  LYS B  20      -1.236  -7.794  13.520  1.00 41.53           C  
ATOM   4527  CE  LYS B  20      -0.537  -7.861  14.862  1.00 41.23           C  
ATOM   4528  NZ  LYS B  20      -1.127  -6.858  15.777  1.00 41.58           N  
ATOM   4529  N   ALA B  21      -1.985 -10.467   8.368  1.00 40.16           N  
ATOM   4530  CA  ALA B  21      -3.063 -11.213   7.743  1.00 40.68           C  
ATOM   4531  C   ALA B  21      -2.546 -12.490   7.127  1.00 40.83           C  
ATOM   4532  O   ALA B  21      -3.325 -13.387   6.808  1.00 41.63           O  
ATOM   4533  CB  ALA B  21      -3.787 -10.380   6.713  1.00 40.29           C  
ATOM   4534  N   GLY B  22      -1.234 -12.577   6.956  1.00 41.03           N  
ATOM   4535  CA  GLY B  22      -0.632 -13.818   6.472  1.00 41.68           C  
ATOM   4536  C   GLY B  22       0.109 -13.723   5.154  1.00 41.57           C  
ATOM   4537  O   GLY B  22       0.595 -14.734   4.638  1.00 42.00           O  
ATOM   4538  N   ILE B  23       0.196 -12.523   4.600  1.00 41.08           N  
ATOM   4539  CA  ILE B  23       1.048 -12.324   3.443  1.00 41.38           C  
ATOM   4540  C   ILE B  23       2.477 -12.394   3.937  1.00 42.31           C  
ATOM   4541  O   ILE B  23       2.836 -11.733   4.919  1.00 42.26           O  
ATOM   4542  CB  ILE B  23       0.856 -10.945   2.785  1.00 40.88           C  
ATOM   4543  CG1 ILE B  23      -0.636 -10.603   2.600  1.00 40.69           C  
ATOM   4544  CG2 ILE B  23       1.660 -10.861   1.488  1.00 40.61           C  
ATOM   4545  CD1 ILE B  23      -1.469 -11.670   1.921  1.00 40.88           C  
ATOM   4546  N   THR B  24       3.294 -13.185   3.255  1.00 43.18           N  
ATOM   4547  CA  THR B  24       4.696 -13.308   3.610  1.00 44.06           C  
ATOM   4548  C   THR B  24       5.626 -12.783   2.524  1.00 44.47           C  
ATOM   4549  O   THR B  24       6.798 -12.520   2.791  1.00 44.60           O  
ATOM   4550  CB  THR B  24       5.070 -14.769   3.889  1.00 44.67           C  
ATOM   4551  OG1 THR B  24       4.696 -15.571   2.765  1.00 45.30           O  
ATOM   4552  CG2 THR B  24       4.355 -15.282   5.136  1.00 44.62           C  
ATOM   4553  N   SER B  25       5.113 -12.614   1.307  1.00 44.75           N  
ATOM   4554  CA  SER B  25       5.994 -12.411   0.148  1.00 44.50           C  
ATOM   4555  C   SER B  25       6.448 -10.992  -0.134  1.00 44.66           C  
ATOM   4556  O   SER B  25       5.629 -10.086  -0.319  1.00 44.41           O  
ATOM   4557  CB  SER B  25       5.363 -12.984  -1.114  1.00 44.15           C  
ATOM   4558  OG  SER B  25       6.300 -12.985  -2.171  1.00 43.35           O  
ATOM   4559  N   ASP B  26       7.770 -10.823  -0.198  1.00 45.36           N  
ATOM   4560  CA  ASP B  26       8.399  -9.597  -0.692  1.00 45.80           C  
ATOM   4561  C   ASP B  26       7.706  -9.088  -1.957  1.00 45.94           C  
ATOM   4562  O   ASP B  26       7.529  -7.889  -2.150  1.00 45.98           O  
ATOM   4563  CB  ASP B  26       9.880  -9.848  -1.002  1.00 46.85           C  
ATOM   4564  CG  ASP B  26      10.787  -9.563   0.186  1.00 47.84           C  
ATOM   4565  OD1 ASP B  26      10.411  -8.712   1.019  1.00 48.71           O  
ATOM   4566  OD2 ASP B  26      11.877 -10.178   0.286  1.00 48.18           O  
ATOM   4567  N   PHE B  27       7.316 -10.018  -2.817  1.00 45.05           N  
ATOM   4568  CA  PHE B  27       6.612  -9.686  -4.034  1.00 44.66           C  
ATOM   4569  C   PHE B  27       5.467  -8.700  -3.795  1.00 44.42           C  
ATOM   4570  O   PHE B  27       5.297  -7.750  -4.547  1.00 45.92           O  
ATOM   4571  CB  PHE B  27       6.099 -10.964  -4.682  1.00 44.09           C  
ATOM   4572  CG  PHE B  27       5.809 -10.826  -6.125  1.00 43.48           C  
ATOM   4573  CD1 PHE B  27       6.835 -10.887  -7.055  1.00 43.55           C  
ATOM   4574  CD2 PHE B  27       4.511 -10.646  -6.566  1.00 43.31           C  
ATOM   4575  CE1 PHE B  27       6.576 -10.753  -8.406  1.00 42.81           C  
ATOM   4576  CE2 PHE B  27       4.240 -10.516  -7.917  1.00 42.63           C  
ATOM   4577  CZ  PHE B  27       5.276 -10.576  -8.838  1.00 42.60           C  
ATOM   4578  N   TYR B  28       4.687  -8.904  -2.742  1.00 43.86           N  
ATOM   4579  CA  TYR B  28       3.627  -7.944  -2.439  1.00 43.15           C  
ATOM   4580  C   TYR B  28       4.152  -6.723  -1.712  1.00 42.86           C  
ATOM   4581  O   TYR B  28       3.775  -5.605  -2.032  1.00 43.69           O  
ATOM   4582  CB  TYR B  28       2.459  -8.611  -1.704  1.00 41.80           C  
ATOM   4583  CG  TYR B  28       1.914  -9.725  -2.536  1.00 40.92           C  
ATOM   4584  CD1 TYR B  28       1.246  -9.460  -3.711  1.00 40.70           C  
ATOM   4585  CD2 TYR B  28       2.136 -11.042  -2.195  1.00 41.28           C  
ATOM   4586  CE1 TYR B  28       0.777 -10.462  -4.503  1.00 40.93           C  
ATOM   4587  CE2 TYR B  28       1.667 -12.063  -2.981  1.00 41.49           C  
ATOM   4588  CZ  TYR B  28       0.984 -11.762  -4.130  1.00 41.73           C  
ATOM   4589  OH  TYR B  28       0.525 -12.770  -4.928  1.00 42.41           O  
ATOM   4590  N   PHE B  29       5.042  -6.933  -0.756  1.00 42.79           N  
ATOM   4591  CA  PHE B  29       5.593  -5.807  -0.024  1.00 42.92           C  
ATOM   4592  C   PHE B  29       6.354  -4.879  -0.967  1.00 42.43           C  
ATOM   4593  O   PHE B  29       6.255  -3.663  -0.863  1.00 43.80           O  
ATOM   4594  CB  PHE B  29       6.487  -6.269   1.129  1.00 42.68           C  
ATOM   4595  CG  PHE B  29       5.833  -7.265   2.056  1.00 42.36           C  
ATOM   4596  CD1 PHE B  29       4.458  -7.258   2.257  1.00 42.17           C  
ATOM   4597  CD2 PHE B  29       6.607  -8.201   2.742  1.00 41.64           C  
ATOM   4598  CE1 PHE B  29       3.865  -8.186   3.111  1.00 42.25           C  
ATOM   4599  CE2 PHE B  29       6.029  -9.124   3.589  1.00 41.53           C  
ATOM   4600  CZ  PHE B  29       4.658  -9.118   3.780  1.00 42.29           C  
ATOM   4601  N   ASN B  30       7.104  -5.450  -1.895  1.00 42.08           N  
ATOM   4602  CA  ASN B  30       7.741  -4.650  -2.937  1.00 41.29           C  
ATOM   4603  C   ASN B  30       6.734  -3.753  -3.614  1.00 40.37           C  
ATOM   4604  O   ASN B  30       7.013  -2.603  -3.904  1.00 39.61           O  
ATOM   4605  CB  ASN B  30       8.399  -5.539  -3.989  1.00 41.54           C  
ATOM   4606  CG  ASN B  30       9.727  -6.143  -3.517  1.00 42.84           C  
ATOM   4607  OD1 ASN B  30      10.497  -5.512  -2.774  1.00 42.06           O  
ATOM   4608  ND2 ASN B  30      10.001  -7.378  -3.961  1.00 42.64           N  
ATOM   4609  N   ALA B  31       5.550  -4.298  -3.865  1.00 40.32           N  
ATOM   4610  CA  ALA B  31       4.606  -3.636  -4.722  1.00 39.73           C  
ATOM   4611  C   ALA B  31       4.041  -2.494  -3.935  1.00 40.84           C  
ATOM   4612  O   ALA B  31       3.970  -1.372  -4.445  1.00 43.20           O  
ATOM   4613  CB  ALA B  31       3.527  -4.597  -5.169  1.00 39.85           C  
ATOM   4614  N   ILE B  32       3.669  -2.765  -2.678  1.00 41.01           N  
ATOM   4615  CA  ILE B  32       3.312  -1.713  -1.742  1.00 39.23           C  
ATOM   4616  C   ILE B  32       4.412  -0.665  -1.762  1.00 39.37           C  
ATOM   4617  O   ILE B  32       4.148   0.536  -1.842  1.00 39.86           O  
ATOM   4618  CB  ILE B  32       3.184  -2.238  -0.328  1.00 39.41           C  
ATOM   4619  CG1 ILE B  32       1.982  -3.193  -0.189  1.00 39.01           C  
ATOM   4620  CG2 ILE B  32       3.124  -1.056   0.677  1.00 38.91           C  
ATOM   4621  CD1 ILE B  32       0.587  -2.527  -0.244  1.00 38.20           C  
ATOM   4622  N   ASN B  33       5.655  -1.109  -1.713  1.00 39.09           N  
ATOM   4623  CA  ASN B  33       6.747  -0.150  -1.675  1.00 40.34           C  
ATOM   4624  C   ASN B  33       6.923   0.767  -2.889  1.00 40.89           C  
ATOM   4625  O   ASN B  33       7.417   1.871  -2.749  1.00 38.88           O  
ATOM   4626  CB  ASN B  33       8.042  -0.806  -1.228  1.00 39.82           C  
ATOM   4627  CG  ASN B  33       8.117  -0.904   0.291  1.00 39.92           C  
ATOM   4628  OD1 ASN B  33       7.362  -0.226   0.999  1.00 39.27           O  
ATOM   4629  ND2 ASN B  33       9.019  -1.726   0.795  1.00 39.36           N  
ATOM   4630  N   LYS B  34       6.449   0.332  -4.058  1.00 42.86           N  
ATOM   4631  CA  LYS B  34       6.522   1.156  -5.258  1.00 44.79           C  
ATOM   4632  C   LYS B  34       5.379   2.190  -5.387  1.00 44.48           C  
ATOM   4633  O   LYS B  34       5.417   3.049  -6.260  1.00 44.74           O  
ATOM   4634  CB  LYS B  34       6.603   0.264  -6.494  1.00 45.71           C  
ATOM   4635  CG  LYS B  34       7.977  -0.263  -6.739  1.00 48.14           C  
ATOM   4636  CD  LYS B  34       7.931  -1.273  -7.853  1.00 50.52           C  
ATOM   4637  CE  LYS B  34       9.118  -2.242  -7.790  1.00 51.80           C  
ATOM   4638  NZ  LYS B  34       8.699  -3.609  -8.273  1.00 52.58           N  
ATOM   4639  N   ALA B  35       4.376   2.100  -4.522  1.00 44.22           N  
ATOM   4640  CA  ALA B  35       3.270   3.088  -4.459  1.00 44.56           C  
ATOM   4641  C   ALA B  35       3.758   4.520  -4.279  1.00 43.87           C  
ATOM   4642  O   ALA B  35       4.773   4.751  -3.622  1.00 44.22           O  
ATOM   4643  CB  ALA B  35       2.305   2.733  -3.310  1.00 43.21           C  
ATOM   4644  N   LYS B  36       3.007   5.476  -4.819  1.00 43.63           N  
ATOM   4645  CA  LYS B  36       3.400   6.886  -4.790  1.00 43.39           C  
ATOM   4646  C   LYS B  36       2.475   7.739  -3.957  1.00 43.09           C  
ATOM   4647  O   LYS B  36       2.749   8.896  -3.686  1.00 43.07           O  
ATOM   4648  CB  LYS B  36       3.465   7.447  -6.211  1.00 44.93           C  
ATOM   4649  CG  LYS B  36       4.829   7.254  -6.853  1.00 45.74           C  
ATOM   4650  CD  LYS B  36       4.671   6.823  -8.263  1.00 47.47           C  
ATOM   4651  CE  LYS B  36       5.916   6.073  -8.774  1.00 48.74           C  
ATOM   4652  NZ  LYS B  36       7.144   6.885  -8.822  1.00 47.22           N  
ATOM   4653  N   THR B  37       1.380   7.158  -3.517  1.00 42.69           N  
ATOM   4654  CA  THR B  37       0.334   7.924  -2.891  1.00 41.53           C  
ATOM   4655  C   THR B  37      -0.142   7.081  -1.744  1.00 41.71           C  
ATOM   4656  O   THR B  37      -0.010   5.861  -1.807  1.00 43.42           O  
ATOM   4657  CB  THR B  37      -0.736   8.146  -3.934  1.00 42.16           C  
ATOM   4658  OG1 THR B  37      -0.697   9.512  -4.353  1.00 42.41           O  
ATOM   4659  CG2 THR B  37      -2.085   7.775  -3.456  1.00 42.34           C  
ATOM   4660  N   VAL B  38      -0.628   7.705  -0.671  1.00 40.60           N  
ATOM   4661  CA  VAL B  38      -1.178   6.953   0.440  1.00 38.64           C  
ATOM   4662  C   VAL B  38      -2.387   6.172  -0.040  1.00 39.02           C  
ATOM   4663  O   VAL B  38      -2.513   4.985   0.262  1.00 39.50           O  
ATOM   4664  CB  VAL B  38      -1.584   7.869   1.626  1.00 38.74           C  
ATOM   4665  CG1 VAL B  38      -2.497   7.120   2.595  1.00 37.41           C  
ATOM   4666  CG2 VAL B  38      -0.360   8.376   2.353  1.00 37.76           C  
ATOM   4667  N   GLU B  39      -3.262   6.831  -0.796  1.00 38.58           N  
ATOM   4668  CA  GLU B  39      -4.413   6.174  -1.397  1.00 40.63           C  
ATOM   4669  C   GLU B  39      -4.017   4.932  -2.208  1.00 42.55           C  
ATOM   4670  O   GLU B  39      -4.722   3.897  -2.164  1.00 42.81           O  
ATOM   4671  CB  GLU B  39      -5.181   7.137  -2.311  1.00 41.81           C  
ATOM   4672  CG  GLU B  39      -5.644   8.453  -1.661  1.00 42.47           C  
ATOM   4673  CD  GLU B  39      -4.647   9.604  -1.881  1.00 43.78           C  
ATOM   4674  OE1 GLU B  39      -3.445   9.473  -1.490  1.00 42.78           O  
ATOM   4675  OE2 GLU B  39      -5.078  10.650  -2.441  1.00 44.51           O  
ATOM   4676  N   GLU B  40      -2.912   5.026  -2.962  1.00 42.72           N  
ATOM   4677  CA  GLU B  40      -2.419   3.870  -3.722  1.00 42.84           C  
ATOM   4678  C   GLU B  40      -2.002   2.791  -2.736  1.00 43.27           C  
ATOM   4679  O   GLU B  40      -2.356   1.612  -2.891  1.00 45.26           O  
ATOM   4680  CB  GLU B  40      -1.270   4.253  -4.661  1.00 42.68           C  
ATOM   4681  CG  GLU B  40      -1.702   5.098  -5.877  1.00 43.24           C  
ATOM   4682  CD  GLU B  40      -0.562   5.891  -6.501  1.00 43.88           C  
ATOM   4683  OE1 GLU B  40       0.603   5.653  -6.121  1.00 45.81           O  
ATOM   4684  OE2 GLU B  40      -0.807   6.761  -7.368  1.00 44.03           O  
ATOM   4685  N   VAL B  41      -1.296   3.198  -1.693  1.00 42.18           N  
ATOM   4686  CA  VAL B  41      -0.928   2.284  -0.626  1.00 42.98           C  
ATOM   4687  C   VAL B  41      -2.129   1.518  -0.092  1.00 42.87           C  
ATOM   4688  O   VAL B  41      -2.077   0.298  -0.000  1.00 43.91           O  
ATOM   4689  CB  VAL B  41      -0.194   3.022   0.521  1.00 43.69           C  
ATOM   4690  CG1 VAL B  41      -0.200   2.205   1.789  1.00 43.33           C  
ATOM   4691  CG2 VAL B  41       1.229   3.372   0.093  1.00 43.44           C  
ATOM   4692  N   ASN B  42      -3.217   2.213   0.236  1.00 43.17           N  
ATOM   4693  CA  ASN B  42      -4.379   1.539   0.843  1.00 42.98           C  
ATOM   4694  C   ASN B  42      -5.282   0.778  -0.139  1.00 42.08           C  
ATOM   4695  O   ASN B  42      -5.772  -0.300   0.179  1.00 42.83           O  
ATOM   4696  CB  ASN B  42      -5.186   2.479   1.766  1.00 44.54           C  
ATOM   4697  CG  ASN B  42      -4.495   2.732   3.121  1.00 46.13           C  
ATOM   4698  OD1 ASN B  42      -4.619   3.822   3.674  1.00 47.92           O  
ATOM   4699  ND2 ASN B  42      -3.773   1.731   3.658  1.00 45.27           N  
ATOM   4700  N   ALA B  43      -5.510   1.314  -1.327  1.00 40.80           N  
ATOM   4701  CA  ALA B  43      -6.170   0.514  -2.369  1.00 39.31           C  
ATOM   4702  C   ALA B  43      -5.449  -0.826  -2.581  1.00 38.75           C  
ATOM   4703  O   ALA B  43      -6.072  -1.873  -2.646  1.00 38.14           O  
ATOM   4704  CB  ALA B  43      -6.260   1.290  -3.680  1.00 37.48           C  
ATOM   4705  N   LEU B  44      -4.128  -0.818  -2.656  1.00 39.16           N  
ATOM   4706  CA  LEU B  44      -3.467  -2.073  -2.996  1.00 39.63           C  
ATOM   4707  C   LEU B  44      -3.429  -2.977  -1.772  1.00 39.83           C  
ATOM   4708  O   LEU B  44      -3.570  -4.203  -1.886  1.00 40.55           O  
ATOM   4709  CB  LEU B  44      -2.074  -1.851  -3.621  1.00 39.50           C  
ATOM   4710  CG  LEU B  44      -1.208  -3.103  -3.796  1.00 39.99           C  
ATOM   4711  CD1 LEU B  44      -1.815  -4.027  -4.829  1.00 39.51           C  
ATOM   4712  CD2 LEU B  44       0.265  -2.772  -4.143  1.00 40.64           C  
ATOM   4713  N   LYS B  45      -3.270  -2.389  -0.590  1.00 40.12           N  
ATOM   4714  CA  LYS B  45      -3.372  -3.203   0.625  1.00 40.27           C  
ATOM   4715  C   LYS B  45      -4.738  -3.878   0.625  1.00 40.92           C  
ATOM   4716  O   LYS B  45      -4.832  -5.094   0.726  1.00 41.96           O  
ATOM   4717  CB  LYS B  45      -3.169  -2.366   1.874  1.00 40.19           C  
ATOM   4718  CG  LYS B  45      -3.398  -3.132   3.162  1.00 40.57           C  
ATOM   4719  CD  LYS B  45      -3.637  -2.177   4.324  1.00 41.48           C  
ATOM   4720  CE  LYS B  45      -4.841  -1.287   4.060  1.00 42.46           C  
ATOM   4721  NZ  LYS B  45      -5.255  -0.508   5.268  1.00 42.50           N  
ATOM   4722  N   ASN B  46      -5.796  -3.088   0.459  1.00 42.08           N  
ATOM   4723  CA  ASN B  46      -7.150  -3.615   0.395  1.00 42.78           C  
ATOM   4724  C   ASN B  46      -7.247  -4.726  -0.599  1.00 43.77           C  
ATOM   4725  O   ASN B  46      -7.762  -5.803  -0.297  1.00 44.59           O  
ATOM   4726  CB  ASN B  46      -8.136  -2.525   0.038  1.00 43.22           C  
ATOM   4727  CG  ASN B  46      -8.385  -1.596   1.191  1.00 44.60           C  
ATOM   4728  OD1 ASN B  46      -8.244  -1.981   2.354  1.00 44.61           O  
ATOM   4729  ND2 ASN B  46      -8.754  -0.363   0.884  1.00 45.80           N  
ATOM   4730  N   GLU B  47      -6.711  -4.488  -1.785  1.00 44.41           N  
ATOM   4731  CA  GLU B  47      -6.773  -5.505  -2.812  1.00 45.04           C  
ATOM   4732  C   GLU B  47      -6.049  -6.774  -2.405  1.00 43.63           C  
ATOM   4733  O   GLU B  47      -6.535  -7.863  -2.649  1.00 44.10           O  
ATOM   4734  CB  GLU B  47      -6.227  -4.977  -4.129  1.00 46.47           C  
ATOM   4735  CG  GLU B  47      -7.209  -4.067  -4.805  1.00 48.74           C  
ATOM   4736  CD  GLU B  47      -8.512  -4.770  -5.125  1.00 50.11           C  
ATOM   4737  OE1 GLU B  47      -8.457  -5.826  -5.809  1.00 51.04           O  
ATOM   4738  OE2 GLU B  47      -9.581  -4.262  -4.705  1.00 50.88           O  
ATOM   4739  N   ILE B  48      -4.881  -6.642  -1.800  1.00 42.06           N  
ATOM   4740  CA  ILE B  48      -4.155  -7.833  -1.409  1.00 40.82           C  
ATOM   4741  C   ILE B  48      -4.944  -8.609  -0.346  1.00 40.38           C  
ATOM   4742  O   ILE B  48      -5.003  -9.829  -0.389  1.00 40.49           O  
ATOM   4743  CB  ILE B  48      -2.741  -7.506  -0.912  1.00 40.52           C  
ATOM   4744  CG1 ILE B  48      -1.883  -6.938  -2.048  1.00 39.57           C  
ATOM   4745  CG2 ILE B  48      -2.073  -8.757  -0.343  1.00 40.41           C  
ATOM   4746  CD1 ILE B  48      -0.747  -6.035  -1.544  1.00 38.33           C  
ATOM   4747  N   LEU B  49      -5.572  -7.906   0.590  1.00 40.14           N  
ATOM   4748  CA  LEU B  49      -6.400  -8.593   1.585  1.00 40.28           C  
ATOM   4749  C   LEU B  49      -7.579  -9.340   0.969  1.00 40.43           C  
ATOM   4750  O   LEU B  49      -7.810 -10.487   1.323  1.00 40.95           O  
ATOM   4751  CB  LEU B  49      -6.852  -7.659   2.723  1.00 39.07           C  
ATOM   4752  CG  LEU B  49      -5.670  -7.186   3.594  1.00 38.91           C  
ATOM   4753  CD1 LEU B  49      -6.030  -6.062   4.546  1.00 38.32           C  
ATOM   4754  CD2 LEU B  49      -5.029  -8.347   4.339  1.00 37.09           C  
ATOM   4755  N   LYS B  50      -8.315  -8.721   0.047  1.00 40.62           N  
ATOM   4756  CA  LYS B  50      -9.494  -9.394  -0.504  1.00 41.14           C  
ATOM   4757  C   LYS B  50      -9.091 -10.687  -1.210  1.00 41.21           C  
ATOM   4758  O   LYS B  50      -9.754 -11.722  -1.081  1.00 40.56           O  
ATOM   4759  CB  LYS B  50     -10.289  -8.478  -1.433  1.00 41.63           C  
ATOM   4760  CG  LYS B  50     -10.930  -7.292  -0.734  1.00 42.61           C  
ATOM   4761  CD  LYS B  50     -11.058  -6.073  -1.665  1.00 44.23           C  
ATOM   4762  CE  LYS B  50     -12.415  -5.997  -2.350  1.00 45.34           C  
ATOM   4763  NZ  LYS B  50     -12.367  -5.044  -3.506  1.00 46.52           N  
ATOM   4764  N   ALA B  51      -7.964 -10.626  -1.909  1.00 41.94           N  
ATOM   4765  CA  ALA B  51      -7.439 -11.769  -2.661  1.00 42.84           C  
ATOM   4766  C   ALA B  51      -6.843 -12.868  -1.779  1.00 43.24           C  
ATOM   4767  O   ALA B  51      -6.786 -14.024  -2.189  1.00 43.79           O  
ATOM   4768  CB  ALA B  51      -6.416 -11.290  -3.653  1.00 43.30           C  
ATOM   4769  N   HIS B  52      -6.394 -12.512  -0.578  1.00 43.49           N  
ATOM   4770  CA  HIS B  52      -5.888 -13.515   0.357  1.00 45.02           C  
ATOM   4771  C   HIS B  52      -6.960 -14.535   0.762  1.00 46.81           C  
ATOM   4772  O   HIS B  52      -6.639 -15.668   1.139  1.00 48.01           O  
ATOM   4773  CB  HIS B  52      -5.260 -12.859   1.584  1.00 43.96           C  
ATOM   4774  CG  HIS B  52      -4.455 -13.800   2.423  1.00 42.89           C  
ATOM   4775  ND1 HIS B  52      -3.736 -14.844   1.888  1.00 42.43           N  
ATOM   4776  CD2 HIS B  52      -4.230 -13.833   3.758  1.00 42.67           C  
ATOM   4777  CE1 HIS B  52      -3.108 -15.487   2.855  1.00 42.61           C  
ATOM   4778  NE2 HIS B  52      -3.390 -14.892   4.000  1.00 42.57           N  
ATOM   4779  N   ALA B  53      -8.225 -14.121   0.707  1.00 48.14           N  
ATOM   4780  CA  ALA B  53      -9.341 -15.064   0.619  1.00 48.85           C  
ATOM   4781  C   ALA B  53      -9.622 -15.346  -0.873  1.00 49.76           C  
ATOM   4782  O   ALA B  53      -9.700 -14.430  -1.712  1.00 49.11           O  
ATOM   4783  CB  ALA B  53     -10.576 -14.498   1.293  1.00 48.61           C  
ATOM   4784  OXT ALA B  53      -9.772 -16.500  -1.290  1.00 50.28           O  
TER    4785      ALA B  53                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
