
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   54 (  436),  selected   54 , name 1lp1_B
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 1lp1_B.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     4_B      N       8          3.583
LGA    F     5_B      L       9          1.634
LGA    N     6_B      K      10          1.013
LGA    K     7_B      Q      11          0.956
LGA    E     8_B      A      12          1.451
LGA    Q     9_B      K      13          1.220
LGA    Q    10_B      E      14          0.470
LGA    N    11_B      E      15          1.080
LGA    A    12_B      A      16          1.859
LGA    F    13_B      I      17          1.698
LGA    Y    14_B      K      18          0.923
LGA    E    15_B      E      19          0.595
LGA    I    16_B      L      20          1.403
LGA    L    17_B      V      21          2.219
LGA    H    18_B      D      22          2.359
LGA    L    19_B      A      23          1.986
LGA    P    20_B      G      24          3.543
LGA    N    21_B      T      25          5.024
LGA    L    22_B      A      26          3.730
LGA    N    23_B      -       -           -
LGA    E    24_B      -       -           -
LGA    E    25_B      -       -           -
LGA    Q    26_B      -       -           -
LGA    R    27_B      E      27          0.710
LGA    N    28_B      K      28          2.535
LGA    A    29_B      Y      29          3.236
LGA    F    30_B      -       -           -
LGA    I    31_B      I      30          2.388
LGA    Q    32_B      K      31          1.995
LGA    S    33_B      L      32          1.199
LGA    L    34_B      I      33          1.192
LGA    K    35_B      A      34          1.452
LGA    D    36_B      N      35          0.850
LGA    D    37_B      A      36          1.486
LGA    P    38_B      K      37          3.476
LGA    S    39_B      T      38          1.528
LGA    -       -      V      39           -
LGA    -       -      E      40           -
LGA    Q    40_B      G      41          0.719
LGA    S    41_B      V      42          0.729
LGA    A    42_B      W      43          0.814
LGA    N    43_B      T      44          0.721
LGA    L    44_B      L      45          0.620
LGA    L    45_B      K      46          1.680
LGA    A    46_B      D      47          1.543
LGA    E    47_B      E      48          0.548
LGA    A    48_B      I      49          1.279
LGA    K    49_B      K      50          0.526
LGA    K    50_B      T      51          0.455
LGA    L    51_B      F      52          1.648
LGA    N    52_B      -       -           -
LGA    D    53_B      -       -           -
LGA    A    54_B      -       -           -
LGA    Q    55_B      -       -           -
LGA    A    56_B      -       -           -
LGA    P    57_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   54   45    5.0     43    1.93    13.95     86.559     2.117

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.003974 * X  +  -0.922667 * Y  +  -0.385578 * Z  +  28.351204
  Y_new =   0.502050 * X  +   0.331623 * Y  +  -0.798731 * Z  + -29.056871
  Z_new =   0.864829 * X  +  -0.196753 * Y  +   0.461908 * Z  + -15.405717 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.402682    2.738911  [ DEG:   -23.0720    156.9280 ]
  Theta =  -1.044810   -2.096782  [ DEG:   -59.8632   -120.1368 ]
  Phi   =   1.578711   -1.562882  [ DEG:    90.4535    -89.5465 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lp1_B                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lp1_B.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   54   45   5.0   43   1.93   13.95  86.559
REMARK  ---------------------------------------------------------- 
MOLECULE 1lp1_B
HEADER    IMMUNE SYSTEM                           07-MAY-02   1LP1              
TITLE     PROTEIN Z IN COMPLEX WITH AN IN VITRO SELECTED AFFIBODY               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AFFIBODY BINDING PROTEIN Z;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: IN VITRO SELECTED BINDING PROTEIN;                         
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: IMMUNOGLOBULIN G BINDING PROTEIN A;                        
COMPND   8 CHAIN: B;                                                            
COMPND   9 FRAGMENT: RESIDUES 2-58;                                             
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   8 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    IN VITRO EVOLVED, PROTEIN-PROTEIN COMPLEX, THREE-HELIX                
KEYWDS   2 BUNDLE, AFFIBODY                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.HOGBOM,M.EKLUND,P.A.NYGREN,P.NORDLUND                               
REVDAT   2   25-MAR-03 1LP1    1       JRNL                                     
REVDAT   1   18-MAR-03 1LP1    0                                                
JRNL        AUTH   M.HOGBOM,M.EKLUND,P.A.NYGREN,P.NORDLUND                      
JRNL        TITL   STRUCTURAL BASIS FOR RECOGNITION BY AN IN VITRO              
JRNL        TITL 2 EVOLVED AFFIBODY.                                            
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 100  3191 2003              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1LP1 B    1    58  UNP    P38507   SPA2_STAAU     212    269             
SEQRES   1 A   58  VAL ASP ASN LYS PHE ASN LYS GLU LEU SER VAL ALA GLY          
SEQRES   2 A   58  ARG GLU ILE VAL THR LEU PRO ASN LEU ASN ASP PRO GLN          
SEQRES   3 A   58  LYS LYS ALA PHE ILE PHE SER LEU TRP ASP ASP PRO SER          
SEQRES   4 A   58  GLN SER ALA ASN LEU LEU ALA GLU ALA LYS LYS LEU ASN          
SEQRES   5 A   58  ASP ALA GLN ALA PRO LYS                                      
SEQRES   1 B   58  VAL ASP ASN LYS PHE ASN LYS GLU GLN GLN ASN ALA PHE          
SEQRES   2 B   58  TYR GLU ILE LEU HIS LEU PRO ASN LEU ASN GLU GLU GLN          
SEQRES   3 B   58  ARG ASN ALA PHE ILE GLN SER LEU LYS ASP ASP PRO SER          
SEQRES   4 B   58  GLN SER ALA ASN LEU LEU ALA GLU ALA LYS LYS LEU ASN          
SEQRES   5 B   58  ASP ALA GLN ALA PRO LYS                                      
HET    SO4    301       5                                                       
HET    SO4    302       5                                                       
HET    SO4    303       5                                                       
HET    SO4    304       5                                                       
HET     MG    401       1                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   3  SO4    4(O4 S 2-)                                                   
FORMUL   7   MG    MG 2+                                                        
FORMUL   8  HOH   *182(H2 O)                                                    
CRYST1   55.546   55.546  155.749  90.00  90.00 120.00 P 61 2 2     12          
ATOM    434  N   LYS B   4       5.487  13.000   3.661  1.00107.21           N  
ATOM    435  CA  LYS B   4       4.939  12.102   2.604  1.00106.02           C  
ATOM    436  C   LYS B   4       3.889  11.161   3.200  1.00105.97           C  
ATOM    437  O   LYS B   4       3.273  11.476   4.220  1.00109.31           O  
ATOM    438  CB  LYS B   4       6.067  11.285   1.972  1.00101.91           C  
ATOM    439  CG  LYS B   4       6.002  11.229   0.456  1.00104.80           C  
ATOM    440  CD  LYS B   4       6.842  10.093  -0.107  1.00103.15           C  
ATOM    441  CE  LYS B   4       6.149   8.751   0.073  1.00100.50           C  
ATOM    442  NZ  LYS B   4       5.866   8.427   1.497  1.00102.42           N  
ATOM    443  N   PHE B   5       3.690  10.010   2.561  1.00102.88           N  
ATOM    444  CA  PHE B   5       2.714   9.021   3.024  1.00 97.53           C  
ATOM    445  C   PHE B   5       3.456   7.836   3.625  1.00 90.15           C  
ATOM    446  O   PHE B   5       3.051   6.686   3.467  1.00 83.72           O  
ATOM    447  CB  PHE B   5       1.847   8.540   1.859  1.00102.93           C  
ATOM    448  CG  PHE B   5       1.915   9.426   0.655  1.00110.55           C  
ATOM    449  CD1 PHE B   5       1.558  10.768   0.740  1.00115.54           C  
ATOM    450  CD2 PHE B   5       2.381   8.933  -0.556  1.00114.62           C  
ATOM    451  CE1 PHE B   5       1.671  11.609  -0.365  1.00118.94           C  
ATOM    452  CE2 PHE B   5       2.498   9.764  -1.669  1.00118.35           C  
ATOM    453  CZ  PHE B   5       2.144  11.105  -1.571  1.00119.13           C  
ATOM    454  N   ASN B   6       4.553   8.133   4.308  1.00 84.50           N  
ATOM    455  CA  ASN B   6       5.367   7.107   4.934  1.00 83.95           C  
ATOM    456  C   ASN B   6       4.522   6.268   5.894  1.00 83.53           C  
ATOM    457  O   ASN B   6       4.471   5.044   5.783  1.00 78.50           O  
ATOM    458  CB  ASN B   6       6.526   7.760   5.687  1.00 80.52           C  
ATOM    459  CG  ASN B   6       7.684   6.814   5.899  1.00 84.67           C  
ATOM    460  OD1 ASN B   6       8.290   6.337   4.942  1.00 92.43           O  
ATOM    461  ND2 ASN B   6       7.999   6.536   7.155  1.00 90.64           N  
ATOM    462  N   LYS B   7       3.850   6.935   6.826  1.00 83.45           N  
ATOM    463  CA  LYS B   7       3.012   6.251   7.803  1.00 83.14           C  
ATOM    464  C   LYS B   7       2.000   5.307   7.156  1.00 77.01           C  
ATOM    465  O   LYS B   7       1.713   4.243   7.701  1.00 74.08           O  
ATOM    466  CB  LYS B   7       2.281   7.278   8.680  1.00 90.77           C  
ATOM    467  CG  LYS B   7       1.192   6.696   9.588  1.00101.02           C  
ATOM    468  CD  LYS B   7       1.763   5.816  10.693  1.00108.04           C  
ATOM    469  CE  LYS B   7       0.655   5.152  11.517  1.00111.11           C  
ATOM    470  NZ  LYS B   7      -0.244   6.130  12.196  1.00112.63           N  
ATOM    471  N   GLU B   8       1.465   5.686   5.999  1.00 72.38           N  
ATOM    472  CA  GLU B   8       0.479   4.849   5.320  1.00 71.40           C  
ATOM    473  C   GLU B   8       1.082   3.601   4.680  1.00 69.78           C  
ATOM    474  O   GLU B   8       0.398   2.590   4.525  1.00 67.94           O  
ATOM    475  CB  GLU B   8      -0.280   5.659   4.267  1.00 78.97           C  
ATOM    476  CG  GLU B   8      -1.095   6.802   4.855  1.00 97.93           C  
ATOM    477  CD  GLU B   8      -1.904   7.551   3.813  1.00106.38           C  
ATOM    478  OE1 GLU B   8      -2.793   6.931   3.188  1.00112.38           O  
ATOM    479  OE2 GLU B   8      -1.651   8.761   3.620  1.00111.63           O  
ATOM    480  N   GLN B   9       2.356   3.661   4.305  1.00 61.52           N  
ATOM    481  CA  GLN B   9       2.977   2.493   3.711  1.00 62.37           C  
ATOM    482  C   GLN B   9       3.578   1.606   4.805  1.00 58.90           C  
ATOM    483  O   GLN B   9       3.599   0.378   4.682  1.00 57.83           O  
ATOM    484  CB  GLN B   9       4.017   2.905   2.657  1.00 57.65           C  
ATOM    485  CG  GLN B   9       5.201   3.712   3.131  1.00 69.29           C  
ATOM    486  CD  GLN B   9       5.872   4.481   1.985  1.00 72.82           C  
ATOM    487  OE1 GLN B   9       6.109   3.937   0.904  1.00 71.01           O  
ATOM    488  NE2 GLN B   9       6.179   5.748   2.228  1.00 71.97           N  
ATOM    489  N   GLN B  10       4.037   2.222   5.887  1.00 59.99           N  
ATOM    490  CA  GLN B  10       4.593   1.461   7.003  1.00 58.60           C  
ATOM    491  C   GLN B  10       3.471   0.599   7.571  1.00 56.52           C  
ATOM    492  O   GLN B  10       3.654  -0.579   7.872  1.00 57.53           O  
ATOM    493  CB  GLN B  10       5.095   2.392   8.105  1.00 53.03           C  
ATOM    494  CG  GLN B  10       6.368   3.149   7.793  1.00 55.00           C  
ATOM    495  CD  GLN B  10       6.646   4.210   8.845  1.00 55.51           C  
ATOM    496  OE1 GLN B  10       5.800   5.061   9.114  1.00 61.13           O  
ATOM    497  NE2 GLN B  10       7.830   4.166   9.442  1.00 47.68           N  
ATOM    498  N   ASN B  11       2.305   1.212   7.714  1.00 51.67           N  
ATOM    499  CA  ASN B  11       1.145   0.525   8.240  1.00 54.31           C  
ATOM    500  C   ASN B  11       0.730  -0.616   7.314  1.00 50.09           C  
ATOM    501  O   ASN B  11       0.386  -1.705   7.771  1.00 50.91           O  
ATOM    502  CB  ASN B  11      -0.007   1.512   8.399  1.00 55.01           C  
ATOM    503  CG  ASN B  11      -1.262   0.850   8.896  1.00 60.07           C  
ATOM    504  OD1 ASN B  11      -1.356   0.476  10.063  1.00 62.19           O  
ATOM    505  ND2 ASN B  11      -2.234   0.679   8.003  1.00 66.24           N  
ATOM    506  N   ALA B  12       0.750  -0.355   6.011  1.00 54.21           N  
ATOM    507  CA  ALA B  12       0.379  -1.370   5.022  1.00 52.23           C  
ATOM    508  C   ALA B  12       1.359  -2.540   5.103  1.00 45.96           C  
ATOM    509  O   ALA B  12       0.958  -3.709   5.104  1.00 46.10           O  
ATOM    510  CB  ALA B  12       0.402  -0.768   3.624  1.00 48.95           C  
ATOM    511  N   PHE B  13       2.644  -2.203   5.168  1.00 34.55           N  
ATOM    512  CA  PHE B  13       3.711  -3.185   5.268  1.00 42.89           C  
ATOM    513  C   PHE B  13       3.452  -4.060   6.502  1.00 46.38           C  
ATOM    514  O   PHE B  13       3.413  -5.293   6.416  1.00 41.60           O  
ATOM    515  CB  PHE B  13       5.053  -2.441   5.381  1.00 37.61           C  
ATOM    516  CG  PHE B  13       6.250  -3.337   5.574  1.00 34.94           C  
ATOM    517  CD1 PHE B  13       6.413  -4.487   4.809  1.00 39.67           C  
ATOM    518  CD2 PHE B  13       7.224  -3.015   6.516  1.00 35.34           C  
ATOM    519  CE1 PHE B  13       7.535  -5.314   4.981  1.00 33.98           C  
ATOM    520  CE2 PHE B  13       8.347  -3.830   6.697  1.00 39.92           C  
ATOM    521  CZ  PHE B  13       8.501  -4.983   5.925  1.00 44.11           C  
ATOM    522  N   TYR B  14       3.233  -3.399   7.638  1.00 44.40           N  
ATOM    523  CA  TYR B  14       2.979  -4.062   8.920  1.00 41.69           C  
ATOM    524  C   TYR B  14       1.801  -5.027   8.831  1.00 40.77           C  
ATOM    525  O   TYR B  14       1.911  -6.199   9.193  1.00 33.95           O  
ATOM    526  CB  TYR B  14       2.702  -2.990   9.995  1.00 45.87           C  
ATOM    527  CG  TYR B  14       2.455  -3.508  11.392  1.00 41.04           C  
ATOM    528  CD1 TYR B  14       3.480  -4.098  12.127  1.00 40.58           C  
ATOM    529  CD2 TYR B  14       1.184  -3.438  11.967  1.00 46.30           C  
ATOM    530  CE1 TYR B  14       3.246  -4.616  13.403  1.00 37.16           C  
ATOM    531  CE2 TYR B  14       0.938  -3.947  13.248  1.00 47.18           C  
ATOM    532  CZ  TYR B  14       1.976  -4.540  13.954  1.00 46.03           C  
ATOM    533  OH  TYR B  14       1.745  -5.075  15.198  1.00 41.32           O  
ATOM    534  N   GLU B  15       0.673  -4.539   8.339  1.00 37.39           N  
ATOM    535  CA  GLU B  15      -0.515  -5.377   8.239  1.00 42.85           C  
ATOM    536  C   GLU B  15      -0.353  -6.530   7.256  1.00 43.26           C  
ATOM    537  O   GLU B  15      -0.895  -7.614   7.468  1.00 40.25           O  
ATOM    538  CB  GLU B  15      -1.738  -4.526   7.863  1.00 49.55           C  
ATOM    539  CG  GLU B  15      -2.286  -3.688   9.027  1.00 60.86           C  
ATOM    540  CD  GLU B  15      -3.550  -2.909   8.675  1.00 67.34           C  
ATOM    541  OE1 GLU B  15      -4.410  -3.446   7.942  1.00 61.04           O  
ATOM    542  OE2 GLU B  15      -3.692  -1.759   9.147  1.00 80.79           O  
ATOM    543  N   ILE B  16       0.391  -6.302   6.183  1.00 40.19           N  
ATOM    544  CA  ILE B  16       0.591  -7.356   5.201  1.00 48.50           C  
ATOM    545  C   ILE B  16       1.384  -8.512   5.815  1.00 41.07           C  
ATOM    546  O   ILE B  16       1.128  -9.673   5.520  1.00 38.90           O  
ATOM    547  CB  ILE B  16       1.291  -6.800   3.932  1.00 49.92           C  
ATOM    548  CG1 ILE B  16       0.287  -5.938   3.142  1.00 43.88           C  
ATOM    549  CG2 ILE B  16       1.811  -7.941   3.067  1.00 44.89           C  
ATOM    550  CD1 ILE B  16       0.894  -5.209   1.956  1.00 47.53           C  
ATOM    551  N   LEU B  17       2.330  -8.191   6.690  1.00 44.23           N  
ATOM    552  CA  LEU B  17       3.122  -9.218   7.365  1.00 40.59           C  
ATOM    553  C   LEU B  17       2.254 -10.153   8.216  1.00 39.24           C  
ATOM    554  O   LEU B  17       2.717 -11.219   8.630  1.00 35.41           O  
ATOM    555  CB  LEU B  17       4.162  -8.573   8.281  1.00 39.34           C  
ATOM    556  CG  LEU B  17       5.621  -8.352   7.867  1.00 43.91           C  
ATOM    557  CD1 LEU B  17       5.934  -8.930   6.490  1.00 33.63           C  
ATOM    558  CD2 LEU B  17       5.896  -6.879   7.919  1.00 32.49           C  
ATOM    559  N   HIS B  18       1.012  -9.751   8.482  1.00 35.09           N  
ATOM    560  CA  HIS B  18       0.087 -10.547   9.298  1.00 37.29           C  
ATOM    561  C   HIS B  18      -0.977 -11.283   8.503  1.00 46.15           C  
ATOM    562  O   HIS B  18      -1.932 -11.788   9.087  1.00 46.37           O  
ATOM    563  CB  HIS B  18      -0.639  -9.667  10.327  1.00 36.44           C  
ATOM    564  CG  HIS B  18       0.256  -9.094  11.377  1.00 36.45           C  
ATOM    565  ND1 HIS B  18       1.172  -8.100  11.109  1.00 37.25           N  
ATOM    566  CD2 HIS B  18       0.398  -9.396  12.688  1.00 34.59           C  
ATOM    567  CE1 HIS B  18       1.842  -7.815  12.211  1.00 42.09           C  
ATOM    568  NE2 HIS B  18       1.392  -8.587  13.185  1.00 45.40           N  
ATOM    569  N   LEU B  19      -0.837 -11.321   7.182  1.00 43.67           N  
ATOM    570  CA  LEU B  19      -1.798 -12.031   6.343  1.00 41.95           C  
ATOM    571  C   LEU B  19      -1.208 -13.410   6.061  1.00 41.01           C  
ATOM    572  O   LEU B  19      -0.380 -13.567   5.166  1.00 44.08           O  
ATOM    573  CB  LEU B  19      -2.023 -11.270   5.032  1.00 44.16           C  
ATOM    574  CG  LEU B  19      -3.016 -10.105   5.051  1.00 51.18           C  
ATOM    575  CD1 LEU B  19      -2.910  -9.336   6.329  1.00 57.85           C  
ATOM    576  CD2 LEU B  19      -2.742  -9.199   3.852  1.00 56.14           C  
ATOM    577  N   PRO B  20      -1.653 -14.431   6.810  1.00 44.16           N  
ATOM    578  CA  PRO B  20      -1.243 -15.839   6.749  1.00 40.32           C  
ATOM    579  C   PRO B  20      -1.410 -16.588   5.424  1.00 45.95           C  
ATOM    580  O   PRO B  20      -0.605 -17.467   5.105  1.00 42.19           O  
ATOM    581  CB  PRO B  20      -2.096 -16.480   7.838  1.00 38.02           C  
ATOM    582  CG  PRO B  20      -3.381 -15.740   7.682  1.00 37.37           C  
ATOM    583  CD  PRO B  20      -2.882 -14.305   7.618  1.00 43.82           C  
ATOM    584  N   ASN B  21      -2.453 -16.265   4.668  1.00 48.64           N  
ATOM    585  CA  ASN B  21      -2.705 -16.966   3.409  1.00 52.93           C  
ATOM    586  C   ASN B  21      -1.986 -16.420   2.180  1.00 50.59           C  
ATOM    587  O   ASN B  21      -2.290 -16.834   1.066  1.00 55.53           O  
ATOM    588  CB  ASN B  21      -4.210 -17.034   3.130  1.00 55.25           C  
ATOM    589  CG  ASN B  21      -4.996 -17.558   4.316  1.00 50.21           C  
ATOM    590  OD1 ASN B  21      -4.569 -18.492   4.987  1.00 56.82           O  
ATOM    591  ND2 ASN B  21      -6.158 -16.964   4.570  1.00 51.68           N  
ATOM    592  N   LEU B  22      -1.046 -15.496   2.366  1.00 48.24           N  
ATOM    593  CA  LEU B  22      -0.289 -14.963   1.229  1.00 51.94           C  
ATOM    594  C   LEU B  22       1.018 -15.744   1.149  1.00 52.49           C  
ATOM    595  O   LEU B  22       1.552 -16.142   2.177  1.00 52.68           O  
ATOM    596  CB  LEU B  22       0.027 -13.469   1.418  1.00 45.06           C  
ATOM    597  CG  LEU B  22      -1.108 -12.436   1.467  1.00 55.34           C  
ATOM    598  CD1 LEU B  22      -0.485 -11.050   1.659  1.00 46.59           C  
ATOM    599  CD2 LEU B  22      -1.945 -12.488   0.186  1.00 49.04           C  
ATOM    600  N   ASN B  23       1.538 -15.965  -0.058  1.00 47.83           N  
ATOM    601  CA  ASN B  23       2.799 -16.687  -0.169  1.00 38.43           C  
ATOM    602  C   ASN B  23       3.961 -15.716  -0.310  1.00 37.39           C  
ATOM    603  O   ASN B  23       3.779 -14.543  -0.639  1.00 45.88           O  
ATOM    604  CB  ASN B  23       2.778 -17.679  -1.337  1.00 48.83           C  
ATOM    605  CG  ASN B  23       2.586 -17.008  -2.676  1.00 44.22           C  
ATOM    606  OD1 ASN B  23       1.673 -17.359  -3.430  1.00 54.69           O  
ATOM    607  ND2 ASN B  23       3.444 -16.038  -2.986  1.00 41.22           N  
ATOM    608  N   GLU B  24       5.160 -16.205  -0.044  1.00 37.50           N  
ATOM    609  CA  GLU B  24       6.348 -15.381  -0.125  1.00 46.79           C  
ATOM    610  C   GLU B  24       6.353 -14.442  -1.330  1.00 51.57           C  
ATOM    611  O   GLU B  24       6.502 -13.231  -1.160  1.00 54.72           O  
ATOM    612  CB  GLU B  24       7.585 -16.282  -0.136  1.00 48.93           C  
ATOM    613  CG  GLU B  24       8.886 -15.568  -0.469  1.00 70.96           C  
ATOM    614  CD  GLU B  24       9.835 -15.482   0.713  1.00 80.66           C  
ATOM    615  OE1 GLU B  24      10.278 -16.543   1.207  1.00 82.93           O  
ATOM    616  OE2 GLU B  24      10.137 -14.349   1.146  1.00 86.59           O  
ATOM    617  N   GLU B  25       6.189 -14.992  -2.538  1.00 58.60           N  
ATOM    618  CA  GLU B  25       6.199 -14.186  -3.766  1.00 49.38           C  
ATOM    619  C   GLU B  25       5.195 -13.053  -3.675  1.00 44.95           C  
ATOM    620  O   GLU B  25       5.493 -11.918  -4.038  1.00 44.12           O  
ATOM    621  CB  GLU B  25       5.834 -15.013  -5.013  1.00 54.63           C  
ATOM    622  CG  GLU B  25       6.358 -16.437  -5.090  1.00 63.27           C  
ATOM    623  CD  GLU B  25       5.409 -17.432  -4.444  1.00 70.89           C  
ATOM    624  OE1 GLU B  25       5.600 -17.735  -3.247  1.00 79.26           O  
ATOM    625  OE2 GLU B  25       4.461 -17.897  -5.124  1.00 59.91           O  
ATOM    626  N   GLN B  26       3.991 -13.365  -3.205  1.00 42.48           N  
ATOM    627  CA  GLN B  26       2.950 -12.351  -3.097  1.00 48.44           C  
ATOM    628  C   GLN B  26       3.348 -11.261  -2.092  1.00 49.24           C  
ATOM    629  O   GLN B  26       3.280 -10.070  -2.395  1.00 50.22           O  
ATOM    630  CB  GLN B  26       1.620 -13.000  -2.697  1.00 47.12           C  
ATOM    631  CG  GLN B  26       1.171 -14.112  -3.623  1.00 41.05           C  
ATOM    632  CD  GLN B  26      -0.192 -14.685  -3.264  1.00 52.75           C  
ATOM    633  OE1 GLN B  26      -0.443 -15.064  -2.119  1.00 59.55           O  
ATOM    634  NE2 GLN B  26      -1.083 -14.750  -4.247  1.00 52.93           N  
ATOM    635  N   ARG B  27       3.772 -11.659  -0.900  1.00 48.89           N  
ATOM    636  CA  ARG B  27       4.181 -10.664   0.081  1.00 51.10           C  
ATOM    637  C   ARG B  27       5.250  -9.779  -0.536  1.00 47.62           C  
ATOM    638  O   ARG B  27       5.183  -8.554  -0.448  1.00 46.87           O  
ATOM    639  CB  ARG B  27       4.685 -11.341   1.372  1.00 54.23           C  
ATOM    640  CG  ARG B  27       3.534 -11.737   2.307  1.00 59.03           C  
ATOM    641  CD  ARG B  27       3.962 -12.268   3.686  1.00 62.57           C  
ATOM    642  NE  ARG B  27       4.201 -13.710   3.691  1.00 60.16           N  
ATOM    643  CZ  ARG B  27       5.387 -14.270   3.484  1.00 59.29           C  
ATOM    644  NH1 ARG B  27       6.453 -13.511   3.268  1.00 70.19           N  
ATOM    645  NH2 ARG B  27       5.505 -15.589   3.466  1.00 66.37           N  
ATOM    646  N   ASN B  28       6.221 -10.398  -1.197  1.00 51.02           N  
ATOM    647  CA  ASN B  28       7.293  -9.648  -1.845  1.00 52.64           C  
ATOM    648  C   ASN B  28       6.744  -8.725  -2.926  1.00 57.46           C  
ATOM    649  O   ASN B  28       7.251  -7.620  -3.136  1.00 47.30           O  
ATOM    650  CB  ASN B  28       8.295 -10.607  -2.470  1.00 61.07           C  
ATOM    651  CG  ASN B  28       9.427 -10.937  -1.539  1.00 75.21           C  
ATOM    652  OD1 ASN B  28       9.990 -12.034  -1.583  1.00 82.97           O  
ATOM    653  ND2 ASN B  28       9.788  -9.977  -0.692  1.00 85.47           N  
ATOM    654  N   ALA B  29       5.711  -9.180  -3.623  1.00 49.79           N  
ATOM    655  CA  ALA B  29       5.136  -8.351  -4.671  1.00 58.10           C  
ATOM    656  C   ALA B  29       4.580  -7.099  -4.010  1.00 48.95           C  
ATOM    657  O   ALA B  29       4.925  -5.978  -4.377  1.00 49.61           O  
ATOM    658  CB  ALA B  29       4.029  -9.110  -5.413  1.00 50.50           C  
ATOM    659  N   PHE B  30       3.735  -7.298  -3.008  1.00 55.64           N  
ATOM    660  CA  PHE B  30       3.138  -6.173  -2.308  1.00 52.58           C  
ATOM    661  C   PHE B  30       4.168  -5.224  -1.718  1.00 48.91           C  
ATOM    662  O   PHE B  30       4.026  -4.006  -1.835  1.00 46.34           O  
ATOM    663  CB  PHE B  30       2.188  -6.685  -1.234  1.00 47.54           C  
ATOM    664  CG  PHE B  30       0.854  -7.117  -1.776  1.00 52.28           C  
ATOM    665  CD1 PHE B  30      -0.043  -6.172  -2.266  1.00 53.34           C  
ATOM    666  CD2 PHE B  30       0.501  -8.459  -1.821  1.00 53.05           C  
ATOM    667  CE1 PHE B  30      -1.267  -6.557  -2.793  1.00 52.93           C  
ATOM    668  CE2 PHE B  30      -0.722  -8.856  -2.348  1.00 54.48           C  
ATOM    669  CZ  PHE B  30      -1.610  -7.904  -2.834  1.00 57.35           C  
ATOM    670  N   ILE B  31       5.214  -5.772  -1.104  1.00 49.23           N  
ATOM    671  CA  ILE B  31       6.246  -4.931  -0.506  1.00 51.12           C  
ATOM    672  C   ILE B  31       6.855  -4.003  -1.553  1.00 56.30           C  
ATOM    673  O   ILE B  31       6.878  -2.783  -1.375  1.00 52.02           O  
ATOM    674  CB  ILE B  31       7.359  -5.783   0.156  1.00 50.91           C  
ATOM    675  CG1 ILE B  31       6.997  -6.090   1.616  1.00 49.13           C  
ATOM    676  CG2 ILE B  31       8.679  -5.026   0.150  1.00 57.73           C  
ATOM    677  CD1 ILE B  31       5.645  -6.711   1.823  1.00 50.04           C  
ATOM    678  N   GLN B  32       7.340  -4.582  -2.646  1.00 59.24           N  
ATOM    679  CA  GLN B  32       7.939  -3.804  -3.730  1.00 59.18           C  
ATOM    680  C   GLN B  32       6.961  -2.760  -4.286  1.00 57.04           C  
ATOM    681  O   GLN B  32       7.337  -1.612  -4.516  1.00 59.72           O  
ATOM    682  CB  GLN B  32       8.390  -4.746  -4.852  1.00 66.82           C  
ATOM    683  CG  GLN B  32       9.092  -4.088  -6.039  1.00 74.01           C  
ATOM    684  CD  GLN B  32      10.400  -3.416  -5.667  1.00 80.94           C  
ATOM    685  OE1 GLN B  32      10.407  -2.343  -5.064  1.00 88.53           O  
ATOM    686  NE2 GLN B  32      11.514  -4.049  -6.020  1.00 83.81           N  
ATOM    687  N   SER B  33       5.709  -3.154  -4.503  1.00 51.96           N  
ATOM    688  CA  SER B  33       4.706  -2.226  -5.028  1.00 51.40           C  
ATOM    689  C   SER B  33       4.468  -1.089  -4.041  1.00 56.84           C  
ATOM    690  O   SER B  33       4.127   0.036  -4.413  1.00 52.32           O  
ATOM    691  CB  SER B  33       3.379  -2.959  -5.268  1.00 54.47           C  
ATOM    692  OG  SER B  33       3.562  -4.122  -6.059  1.00 72.83           O  
ATOM    693  N   LEU B  34       4.641  -1.400  -2.764  1.00 56.73           N  
ATOM    694  CA  LEU B  34       4.439  -0.423  -1.714  1.00 59.69           C  
ATOM    695  C   LEU B  34       5.451   0.698  -1.848  1.00 60.39           C  
ATOM    696  O   LEU B  34       5.093   1.875  -1.839  1.00 54.22           O  
ATOM    697  CB  LEU B  34       4.586  -1.101  -0.354  1.00 57.69           C  
ATOM    698  CG  LEU B  34       3.442  -0.925   0.640  1.00 54.43           C  
ATOM    699  CD1 LEU B  34       2.105  -0.940  -0.059  1.00 42.31           C  
ATOM    700  CD2 LEU B  34       3.545  -2.035   1.677  1.00 46.41           C  
ATOM    701  N   LYS B  35       6.719   0.332  -1.982  1.00 60.85           N  
ATOM    702  CA  LYS B  35       7.757   1.337  -2.104  1.00 74.26           C  
ATOM    703  C   LYS B  35       7.761   2.038  -3.461  1.00 79.16           C  
ATOM    704  O   LYS B  35       8.318   3.126  -3.593  1.00 81.24           O  
ATOM    705  CB  LYS B  35       9.129   0.721  -1.818  1.00 73.09           C  
ATOM    706  CG  LYS B  35       9.375  -0.605  -2.499  1.00 87.31           C  
ATOM    707  CD  LYS B  35      10.784  -1.119  -2.215  1.00 97.98           C  
ATOM    708  CE  LYS B  35      11.006  -1.418  -0.736  1.00 98.53           C  
ATOM    709  NZ  LYS B  35      12.387  -1.931  -0.478  1.00 98.33           N  
ATOM    710  N   ASP B  36       7.136   1.427  -4.465  1.00 79.75           N  
ATOM    711  CA  ASP B  36       7.091   2.035  -5.795  1.00 84.38           C  
ATOM    712  C   ASP B  36       6.157   3.246  -5.839  1.00 87.04           C  
ATOM    713  O   ASP B  36       6.608   4.376  -6.040  1.00 91.06           O  
ATOM    714  CB  ASP B  36       6.670   0.996  -6.843  1.00 82.12           C  
ATOM    715  CG  ASP B  36       7.852   0.190  -7.375  1.00 82.23           C  
ATOM    716  OD1 ASP B  36       8.813  -0.037  -6.612  1.00 88.08           O  
ATOM    717  OD2 ASP B  36       7.818  -0.228  -8.553  1.00 81.47           O  
ATOM    718  N   ASP B  37       4.861   3.019  -5.650  1.00 85.59           N  
ATOM    719  CA  ASP B  37       3.899   4.115  -5.662  1.00 85.45           C  
ATOM    720  C   ASP B  37       3.244   4.290  -4.294  1.00 83.30           C  
ATOM    721  O   ASP B  37       2.091   3.912  -4.093  1.00 86.50           O  
ATOM    722  CB  ASP B  37       2.825   3.871  -6.721  1.00 86.63           C  
ATOM    723  CG  ASP B  37       2.265   2.472  -6.664  1.00 93.29           C  
ATOM    724  OD1 ASP B  37       2.966   1.538  -7.106  1.00 99.68           O  
ATOM    725  OD2 ASP B  37       1.131   2.301  -6.170  1.00 90.13           O  
ATOM    726  N   PRO B  38       3.976   4.880  -3.336  1.00 81.29           N  
ATOM    727  CA  PRO B  38       3.484   5.115  -1.975  1.00 81.30           C  
ATOM    728  C   PRO B  38       2.042   5.606  -1.905  1.00 85.14           C  
ATOM    729  O   PRO B  38       1.410   5.550  -0.851  1.00 90.35           O  
ATOM    730  CB  PRO B  38       4.469   6.139  -1.433  1.00 72.66           C  
ATOM    731  CG  PRO B  38       5.755   5.705  -2.068  1.00 80.68           C  
ATOM    732  CD  PRO B  38       5.344   5.409  -3.497  1.00 79.58           C  
ATOM    733  N   SER B  39       1.529   6.089  -3.028  1.00 87.21           N  
ATOM    734  CA  SER B  39       0.168   6.592  -3.085  1.00 86.87           C  
ATOM    735  C   SER B  39      -0.876   5.471  -3.054  1.00 87.50           C  
ATOM    736  O   SER B  39      -1.872   5.565  -2.331  1.00 83.38           O  
ATOM    737  CB  SER B  39      -0.016   7.445  -4.345  1.00 91.80           C  
ATOM    738  OG  SER B  39       0.327   6.720  -5.517  1.00101.08           O  
ATOM    739  N   GLN B  40      -0.647   4.409  -3.824  1.00 87.13           N  
ATOM    740  CA  GLN B  40      -1.597   3.297  -3.880  1.00 88.43           C  
ATOM    741  C   GLN B  40      -1.525   2.380  -2.650  1.00 83.29           C  
ATOM    742  O   GLN B  40      -2.206   1.353  -2.594  1.00 78.68           O  
ATOM    743  CB  GLN B  40      -1.365   2.481  -5.159  1.00 92.02           C  
ATOM    744  CG  GLN B  40      -2.553   1.617  -5.608  1.00106.06           C  
ATOM    745  CD  GLN B  40      -2.225   0.708  -6.796  1.00110.38           C  
ATOM    746  OE1 GLN B  40      -3.114   0.098  -7.403  1.00107.36           O  
ATOM    747  NE2 GLN B  40      -0.941   0.608  -7.121  1.00108.03           N  
ATOM    748  N   SER B  41      -0.705   2.757  -1.669  1.00 74.88           N  
ATOM    749  CA  SER B  41      -0.551   1.966  -0.450  1.00 77.16           C  
ATOM    750  C   SER B  41      -1.886   1.463   0.084  1.00 76.75           C  
ATOM    751  O   SER B  41      -2.150   0.256   0.088  1.00 72.85           O  
ATOM    752  CB  SER B  41       0.143   2.784   0.640  1.00 73.67           C  
ATOM    753  OG  SER B  41       1.510   2.968   0.335  1.00 83.60           O  
ATOM    754  N   ALA B  42      -2.724   2.388   0.538  1.00 71.30           N  
ATOM    755  CA  ALA B  42      -4.026   2.018   1.074  1.00 74.68           C  
ATOM    756  C   ALA B  42      -4.771   1.100   0.111  1.00 75.14           C  
ATOM    757  O   ALA B  42      -5.511   0.214   0.535  1.00 79.94           O  
ATOM    758  CB  ALA B  42      -4.847   3.261   1.357  1.00 77.34           C  
ATOM    759  N   ASN B  43      -4.571   1.304  -1.187  1.00 73.51           N  
ATOM    760  CA  ASN B  43      -5.238   0.468  -2.176  1.00 73.82           C  
ATOM    761  C   ASN B  43      -4.678  -0.950  -2.148  1.00 71.24           C  
ATOM    762  O   ASN B  43      -5.422  -1.920  -2.036  1.00 70.77           O  
ATOM    763  CB  ASN B  43      -5.072   1.052  -3.577  1.00 80.53           C  
ATOM    764  CG  ASN B  43      -5.700   0.175  -4.646  1.00 86.83           C  
ATOM    765  OD1 ASN B  43      -6.915  -0.034  -4.658  1.00 93.26           O  
ATOM    766  ND2 ASN B  43      -4.873  -0.353  -5.541  1.00 87.22           N  
ATOM    767  N   LEU B  44      -3.360  -1.061  -2.260  1.00 70.89           N  
ATOM    768  CA  LEU B  44      -2.699  -2.359  -2.239  1.00 66.55           C  
ATOM    769  C   LEU B  44      -3.127  -3.156  -1.013  1.00 61.78           C  
ATOM    770  O   LEU B  44      -3.445  -4.344  -1.105  1.00 56.67           O  
ATOM    771  CB  LEU B  44      -1.179  -2.161  -2.247  1.00 59.77           C  
ATOM    772  CG  LEU B  44      -0.640  -1.741  -3.619  1.00 68.23           C  
ATOM    773  CD1 LEU B  44       0.744  -1.120  -3.501  1.00 63.70           C  
ATOM    774  CD2 LEU B  44      -0.622  -2.962  -4.527  1.00 64.94           C  
ATOM    775  N   LEU B  45      -3.149  -2.487   0.134  1.00 62.08           N  
ATOM    776  CA  LEU B  45      -3.535  -3.128   1.383  1.00 65.25           C  
ATOM    777  C   LEU B  45      -4.852  -3.853   1.176  1.00 65.07           C  
ATOM    778  O   LEU B  45      -4.950  -5.065   1.383  1.00 66.45           O  
ATOM    779  CB  LEU B  45      -3.708  -2.081   2.481  1.00 62.35           C  
ATOM    780  CG  LEU B  45      -3.241  -2.440   3.892  1.00 66.11           C  
ATOM    781  CD1 LEU B  45      -3.950  -1.526   4.871  1.00 61.34           C  
ATOM    782  CD2 LEU B  45      -3.540  -3.895   4.218  1.00 58.31           C  
ATOM    783  N   ALA B  46      -5.861  -3.099   0.755  1.00 64.78           N  
ATOM    784  CA  ALA B  46      -7.185  -3.658   0.518  1.00 60.79           C  
ATOM    785  C   ALA B  46      -7.119  -4.887  -0.373  1.00 61.61           C  
ATOM    786  O   ALA B  46      -7.858  -5.849  -0.167  1.00 67.79           O  
ATOM    787  CB  ALA B  46      -8.083  -2.615  -0.110  1.00 62.09           C  
ATOM    788  N   GLU B  47      -6.234  -4.858  -1.363  1.00 59.40           N  
ATOM    789  CA  GLU B  47      -6.104  -5.982  -2.281  1.00 59.05           C  
ATOM    790  C   GLU B  47      -5.455  -7.151  -1.569  1.00 52.89           C  
ATOM    791  O   GLU B  47      -5.892  -8.293  -1.701  1.00 53.16           O  
ATOM    792  CB  GLU B  47      -5.264  -5.592  -3.501  1.00 68.19           C  
ATOM    793  CG  GLU B  47      -5.880  -6.007  -4.826  1.00 78.29           C  
ATOM    794  CD  GLU B  47      -7.259  -5.401  -5.024  1.00 85.99           C  
ATOM    795  OE1 GLU B  47      -7.376  -4.157  -4.977  1.00 85.21           O  
ATOM    796  OE2 GLU B  47      -8.227  -6.166  -5.223  1.00 89.61           O  
ATOM    797  N   ALA B  48      -4.406  -6.862  -0.810  1.00 46.74           N  
ATOM    798  CA  ALA B  48      -3.717  -7.915  -0.082  1.00 47.57           C  
ATOM    799  C   ALA B  48      -4.735  -8.645   0.776  1.00 43.66           C  
ATOM    800  O   ALA B  48      -4.817  -9.869   0.758  1.00 51.07           O  
ATOM    801  CB  ALA B  48      -2.620  -7.324   0.793  1.00 40.80           C  
ATOM    802  N   LYS B  49      -5.530  -7.888   1.516  1.00 46.27           N  
ATOM    803  CA  LYS B  49      -6.526  -8.502   2.385  1.00 55.17           C  
ATOM    804  C   LYS B  49      -7.509  -9.376   1.618  1.00 52.84           C  
ATOM    805  O   LYS B  49      -7.789 -10.502   2.023  1.00 55.06           O  
ATOM    806  CB  LYS B  49      -7.290  -7.426   3.165  1.00 53.46           C  
ATOM    807  CG  LYS B  49      -6.414  -6.565   4.066  1.00 61.72           C  
ATOM    808  CD  LYS B  49      -7.217  -5.446   4.733  1.00 56.09           C  
ATOM    809  CE  LYS B  49      -6.350  -4.655   5.700  1.00 66.54           C  
ATOM    810  NZ  LYS B  49      -7.068  -3.501   6.323  1.00 80.94           N  
ATOM    811  N   LYS B  50      -8.040  -8.861   0.514  1.00 61.12           N  
ATOM    812  CA  LYS B  50      -9.002  -9.635  -0.262  1.00 63.68           C  
ATOM    813  C   LYS B  50      -8.325 -10.873  -0.826  1.00 57.75           C  
ATOM    814  O   LYS B  50      -8.937 -11.932  -0.939  1.00 59.79           O  
ATOM    815  CB  LYS B  50      -9.601  -8.782  -1.386  1.00 74.13           C  
ATOM    816  CG  LYS B  50      -8.684  -8.506  -2.566  1.00 92.80           C  
ATOM    817  CD  LYS B  50      -8.983  -9.436  -3.748  1.00100.77           C  
ATOM    818  CE  LYS B  50     -10.419  -9.274  -4.260  1.00105.57           C  
ATOM    819  NZ  LYS B  50     -10.729  -7.893  -4.741  1.00105.93           N  
ATOM    820  N   LEU B  51      -7.050 -10.748  -1.160  1.00 53.88           N  
ATOM    821  CA  LEU B  51      -6.330 -11.890  -1.692  1.00 55.34           C  
ATOM    822  C   LEU B  51      -6.136 -12.938  -0.609  1.00 56.80           C  
ATOM    823  O   LEU B  51      -6.261 -14.135  -0.861  1.00 62.74           O  
ATOM    824  CB  LEU B  51      -4.975 -11.459  -2.243  1.00 52.90           C  
ATOM    825  CG  LEU B  51      -4.155 -12.602  -2.833  1.00 59.11           C  
ATOM    826  CD1 LEU B  51      -5.007 -13.379  -3.830  1.00 62.54           C  
ATOM    827  CD2 LEU B  51      -2.910 -12.047  -3.495  1.00 55.97           C  
ATOM    828  N   ASN B  52      -5.839 -12.481   0.604  1.00 59.52           N  
ATOM    829  CA  ASN B  52      -5.619 -13.386   1.729  1.00 52.66           C  
ATOM    830  C   ASN B  52      -6.841 -14.243   1.995  1.00 53.26           C  
ATOM    831  O   ASN B  52      -6.725 -15.439   2.270  1.00 46.06           O  
ATOM    832  CB  ASN B  52      -5.273 -12.603   2.999  1.00 51.83           C  
ATOM    833  CG  ASN B  52      -5.150 -13.504   4.217  1.00 48.35           C  
ATOM    834  OD1 ASN B  52      -4.288 -14.374   4.274  1.00 52.46           O  
ATOM    835  ND2 ASN B  52      -6.023 -13.309   5.190  1.00 50.41           N  
ATOM    836  N   ASP B  53      -8.015 -13.628   1.932  1.00 60.07           N  
ATOM    837  CA  ASP B  53      -9.243 -14.368   2.170  1.00 68.59           C  
ATOM    838  C   ASP B  53      -9.487 -15.336   1.031  1.00 68.33           C  
ATOM    839  O   ASP B  53      -9.796 -16.508   1.258  1.00 74.73           O  
ATOM    840  CB  ASP B  53     -10.439 -13.421   2.312  1.00 72.23           C  
ATOM    841  CG  ASP B  53     -10.460 -12.703   3.648  1.00 80.12           C  
ATOM    842  OD1 ASP B  53     -10.076 -13.324   4.663  1.00 85.26           O  
ATOM    843  OD2 ASP B  53     -10.885 -11.527   3.690  1.00 88.71           O  
ATOM    844  N   ALA B  54      -9.327 -14.843  -0.192  1.00 69.48           N  
ATOM    845  CA  ALA B  54      -9.530 -15.659  -1.375  1.00 64.93           C  
ATOM    846  C   ALA B  54      -8.681 -16.917  -1.321  1.00 67.08           C  
ATOM    847  O   ALA B  54      -8.973 -17.900  -1.999  1.00 72.21           O  
ATOM    848  CB  ALA B  54      -9.180 -14.860  -2.604  1.00 66.12           C  
ATOM    849  N   GLN B  55      -7.628 -16.885  -0.515  1.00 63.67           N  
ATOM    850  CA  GLN B  55      -6.740 -18.029  -0.411  1.00 60.46           C  
ATOM    851  C   GLN B  55      -6.815 -18.742   0.935  1.00 59.73           C  
ATOM    852  O   GLN B  55      -5.931 -19.517   1.288  1.00 62.19           O  
ATOM    853  CB  GLN B  55      -5.303 -17.588  -0.724  1.00 63.59           C  
ATOM    854  CG  GLN B  55      -5.129 -17.032  -2.153  1.00 67.76           C  
ATOM    855  CD  GLN B  55      -3.703 -16.631  -2.510  1.00 67.46           C  
ATOM    856  OE1 GLN B  55      -3.403 -16.313  -3.670  1.00 67.12           O  
ATOM    857  NE2 GLN B  55      -2.822 -16.631  -1.520  1.00 65.12           N  
ATOM    858  N   ALA B  56      -7.887 -18.496   1.676  1.00 62.92           N  
ATOM    859  CA  ALA B  56      -8.074 -19.145   2.969  1.00 65.30           C  
ATOM    860  C   ALA B  56      -8.212 -20.647   2.759  1.00 68.01           C  
ATOM    861  O   ALA B  56      -8.761 -21.093   1.761  1.00 66.00           O  
ATOM    862  CB  ALA B  56      -9.321 -18.599   3.664  1.00 58.20           C  
ATOM    863  N   PRO B  57      -7.706 -21.449   3.701  1.00 75.06           N  
ATOM    864  CA  PRO B  57      -7.791 -22.907   3.588  1.00 75.44           C  
ATOM    865  C   PRO B  57      -9.228 -23.410   3.455  1.00 77.39           C  
ATOM    866  O   PRO B  57     -10.163 -22.597   3.613  1.00 79.26           O  
ATOM    867  CB  PRO B  57      -7.130 -23.388   4.875  1.00 78.20           C  
ATOM    868  CG  PRO B  57      -6.109 -22.321   5.134  1.00 75.29           C  
ATOM    869  CD  PRO B  57      -6.893 -21.062   4.866  1.00 73.28           C  
TER     870      PRO B  57                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
