
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   57 (  871),  selected   57 , name 1fd6_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1fd6_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    T     2_A      T       1          1.390
LGA    T     3_A      T       2          0.662
LGA    F     4_A      Y       3          0.117
LGA    K     5_A      K       4          0.202
LGA    L     6_A      L       5          0.324
LGA    I     7_A      I       6          0.377
LGA    I     8_A      L       7          1.330
LGA    N     9_A      N       8          1.257
LGA    G    10_A      L       9          1.536
LGA    K    11_A      K      10          1.777
LGA    T    12_A      Q      11          5.026
LGA    L    13_A      A      12          3.192
LGA    K    14_A      K      13          0.496
LGA    G    15_A      E      14          3.310
LGA    E    16_A      E      15          1.927
LGA    T    17_A      A      16          2.519
LGA    T    18_A      I      17          1.496
LGA    T    19_A      K      18          1.042
LGA    E    20_A      E      19          1.592
LGA    A    21_A      A      20          2.005
LGA    V    22_A      V      21          1.784
LGA    D    23_A      D      22          1.760
LGA    A    24_A      A      23          1.726
LGA    A    25_A      G      24          1.304
LGA    T    26_A      T      25          1.270
LGA    A    27_A      A      26          0.378
LGA    E    28_A      E      27          0.999
LGA    K    29_A      K      28          0.580
LGA    V    30_A      Y      29          0.771
LGA    F    31_A      F      30          0.880
LGA    K    32_A      K      31          0.777
LGA    Q    33_A      L      32          0.757
LGA    Y    34_A      I      33          0.669
LGA    A    35_A      A      34          1.140
LGA    N    36_A      N      35          0.490
LGA    D    37_A      A      36          0.981
LGA    N    38_A      K      37          1.759
LGA    G    39_A      T      38          1.547
LGA    I    40_A      V      39          3.943
LGA    D    41_A      E      40          2.683
LGA    G    42_A      G      41          0.771
LGA    E    43_A      V      42          1.158
LGA    W    44_A      W      43          0.934
LGA    T    45_A      T      44          1.115
LGA    Y    46_A      Y      45          1.492
LGA    D    47_A      K      46          1.144
LGA    D    48_A      D      47          1.535
LGA    A    49_A      E      48          1.734
LGA    T    50_A      I      49          1.901
LGA    K    51_A      K      50          0.930
LGA    T    52_A      T      51          0.838
LGA    F    53_A      F      52          0.725
LGA    T    54_A      T      53          1.085
LGA    V    55_A      V      54          0.869
LGA    T    56_A      T      55          0.618
LGA    E    57_A      E      56          1.325

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   57   56    5.0     56    1.63    60.71     92.450     3.239

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.312985 * X  +  -0.070902 * Y  +   0.947108 * Z  +  -0.154327
  Y_new =  -0.878641 * X  +  -0.400228 * Y  +   0.260398 * Z  +  -0.536256
  Z_new =   0.360596 * X  +  -0.913669 * Y  +  -0.187563 * Z  +   0.192718 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.773269    1.368324  [ DEG:  -101.6008     78.3992 ]
  Theta =  -0.368907   -2.772685  [ DEG:   -21.1368   -158.8632 ]
  Phi   =  -1.228596    1.912997  [ DEG:   -70.3933    109.6067 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fd6_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fd6_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   57   56   5.0   56   1.63   60.71  92.450
REMARK  ---------------------------------------------------------- 
MOLECULE 1fd6_A
HEADER    PROTEIN BINDING                         19-JUL-00   1FD6              
TITLE     DELTA0: A COMPUTATIONALLY DESIGNED CORE VARIANT OF THE B1             
TITLE    2 DOMAIN OF STREPTOCOCCAL PROTEIN G                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IMMUNOGLOBULIN G BINDING PROTEIN G;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: GB1_DELT0;                                                 
COMPND   5 SYNONYM: IGG BINDING PROTEIN G;                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP.;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    STREPTOCOCCAL PROTEIN G, PROTEIN DESIGN, BACKBONE DESIGN,             
KEYWDS   2 CORE SIDECHAIN PACKING                                               
EXPDTA    NMR, 40 STRUCTURES                                                    
AUTHOR    S.A.ROSS,C.A.SARISKY,A.SU,S.L.MAYO                                    
REVDAT   1   19-SEP-01 1FD6    0                                                
JRNL        AUTH   S.A.ROSS,C.A.SARISKY,A.SU,S.L.MAYO                           
JRNL        TITL   DESIGNED PROTEIN G CORE VARIANTS FOLD TO                     
JRNL        TITL 2 NATIVE-LIKE STRUCTURES: SEQUENCE SELECTION BY                
JRNL        TITL 3 ORBIT TOLERATES VARIATION IN BACKBONE                        
JRNL        TITL 4 SPECIFICATION.                                               
JRNL        REF    PROTEIN SCI.                  V.  10   450 2001              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1FD6 A    2    57  UNP    P19909   SPG2_STRSG     302    357             
SEQRES   1 A   57  MET THR THR PHE LYS LEU ILE ILE ASN GLY LYS THR LEU          
SEQRES   2 A   57  LYS GLY GLU THR THR THR GLU ALA VAL ASP ALA ALA THR          
SEQRES   3 A   57  ALA GLU LYS VAL PHE LYS GLN TYR ALA ASN ASP ASN GLY          
SEQRES   4 A   57  ILE ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR          
SEQRES   5 A   57  PHE THR VAL THR GLU                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       8.058 -14.194   6.806  1.00  0.00           N  
ATOM      2  CA  MET A   1       6.994 -13.150   6.843  1.00  0.00           C  
ATOM      3  C   MET A   1       6.329 -13.020   5.470  1.00  0.00           C  
ATOM      4  O   MET A   1       6.770 -13.609   4.501  1.00  0.00           O  
ATOM      5  CB  MET A   1       7.720 -11.856   7.213  1.00  0.00           C  
ATOM      6  CG  MET A   1       7.860 -11.766   8.734  1.00  0.00           C  
ATOM      7  SD  MET A   1       9.338 -10.806   9.148  1.00  0.00           S  
ATOM      8  CE  MET A   1      10.540 -12.144   8.952  1.00  0.00           C  
ATOM      9  HA  MET A   1       6.259 -13.388   7.597  1.00  0.00           H  
ATOM     10  HB2 MET A   1       8.700 -11.852   6.760  1.00  0.00           H  
ATOM     11  HB3 MET A   1       7.153 -11.010   6.855  1.00  0.00           H  
ATOM     12  HG2 MET A   1       6.988 -11.280   9.147  1.00  0.00           H  
ATOM     13  HG3 MET A   1       7.948 -12.760   9.148  1.00  0.00           H  
ATOM     14  HE1 MET A   1      10.303 -12.944   9.642  1.00  0.00           H  
ATOM     15  HE2 MET A   1      11.530 -11.774   9.161  1.00  0.00           H  
ATOM     16  HE3 MET A   1      10.502 -12.515   7.937  1.00  0.00           H  
ATOM     17  H1  MET A   1       7.622 -15.129   6.680  1.00  0.00           H  
ATOM     18  H2  MET A   1       8.591 -14.176   7.700  1.00  0.00           H  
ATOM     19  H3  MET A   1       8.703 -14.005   6.014  1.00  0.00           H  
ATOM     20  N   THR A   2       5.273 -12.253   5.383  1.00  0.00           N  
ATOM     21  CA  THR A   2       4.571 -12.077   4.078  1.00  0.00           C  
ATOM     22  C   THR A   2       4.945 -10.729   3.453  1.00  0.00           C  
ATOM     23  O   THR A   2       4.593  -9.682   3.962  1.00  0.00           O  
ATOM     24  CB  THR A   2       3.082 -12.114   4.423  1.00  0.00           C  
ATOM     25  OG1 THR A   2       2.784 -13.330   5.093  1.00  0.00           O  
ATOM     26  CG2 THR A   2       2.256 -12.021   3.140  1.00  0.00           C  
ATOM     27  H   THR A   2       4.940 -11.791   6.181  1.00  0.00           H  
ATOM     28  HA  THR A   2       4.814 -12.885   3.406  1.00  0.00           H  
ATOM     29  HB  THR A   2       2.839 -11.280   5.063  1.00  0.00           H  
ATOM     30  HG1 THR A   2       3.110 -14.055   4.553  1.00  0.00           H  
ATOM     31 HG21 THR A   2       2.287 -11.007   2.765  1.00  0.00           H  
ATOM     32 HG22 THR A   2       1.234 -12.297   3.350  1.00  0.00           H  
ATOM     33 HG23 THR A   2       2.667 -12.691   2.399  1.00  0.00           H  
ATOM     34  N   THR A   3       5.663 -10.754   2.360  1.00  0.00           N  
ATOM     35  CA  THR A   3       6.075  -9.487   1.698  1.00  0.00           C  
ATOM     36  C   THR A   3       4.918  -8.896   0.886  1.00  0.00           C  
ATOM     37  O   THR A   3       4.656  -9.311  -0.228  1.00  0.00           O  
ATOM     38  CB  THR A   3       7.235  -9.875   0.776  1.00  0.00           C  
ATOM     39  OG1 THR A   3       8.185 -10.637   1.508  1.00  0.00           O  
ATOM     40  CG2 THR A   3       7.904  -8.613   0.227  1.00  0.00           C  
ATOM     41  H   THR A   3       5.936 -11.607   1.980  1.00  0.00           H  
ATOM     42  HA  THR A   3       6.415  -8.788   2.434  1.00  0.00           H  
ATOM     43  HB  THR A   3       6.859 -10.464  -0.047  1.00  0.00           H  
ATOM     44  HG1 THR A   3       8.245 -11.505   1.104  1.00  0.00           H  
ATOM     45 HG21 THR A   3       8.975  -8.752   0.210  1.00  0.00           H  
ATOM     46 HG22 THR A   3       7.661  -7.769   0.857  1.00  0.00           H  
ATOM     47 HG23 THR A   3       7.551  -8.425  -0.776  1.00  0.00           H  
ATOM     48  N   PHE A   4       4.232  -7.924   1.434  1.00  0.00           N  
ATOM     49  CA  PHE A   4       3.097  -7.293   0.697  1.00  0.00           C  
ATOM     50  C   PHE A   4       3.616  -6.151  -0.182  1.00  0.00           C  
ATOM     51  O   PHE A   4       4.746  -5.720  -0.045  1.00  0.00           O  
ATOM     52  CB  PHE A   4       2.167  -6.748   1.783  1.00  0.00           C  
ATOM     53  CG  PHE A   4       1.469  -7.889   2.480  1.00  0.00           C  
ATOM     54  CD1 PHE A   4       0.371  -8.514   1.877  1.00  0.00           C  
ATOM     55  CD2 PHE A   4       1.915  -8.315   3.735  1.00  0.00           C  
ATOM     56  CE1 PHE A   4      -0.281  -9.565   2.531  1.00  0.00           C  
ATOM     57  CE2 PHE A   4       1.264  -9.367   4.390  1.00  0.00           C  
ATOM     58  CZ  PHE A   4       0.166  -9.991   3.787  1.00  0.00           C  
ATOM     59  H   PHE A   4       4.469  -7.606   2.330  1.00  0.00           H  
ATOM     60  HA  PHE A   4       2.579  -8.026   0.098  1.00  0.00           H  
ATOM     61  HB2 PHE A   4       2.747  -6.193   2.504  1.00  0.00           H  
ATOM     62  HB3 PHE A   4       1.432  -6.098   1.335  1.00  0.00           H  
ATOM     63  HD1 PHE A   4       0.027  -8.185   0.908  1.00  0.00           H  
ATOM     64  HD2 PHE A   4       2.763  -7.833   4.199  1.00  0.00           H  
ATOM     65  HE1 PHE A   4      -1.127 -10.049   2.068  1.00  0.00           H  
ATOM     66  HE2 PHE A   4       1.609  -9.695   5.358  1.00  0.00           H  
ATOM     67  HZ  PHE A   4      -0.337 -10.802   4.293  1.00  0.00           H  
ATOM     68  N   LYS A   5       2.801  -5.657  -1.080  1.00  0.00           N  
ATOM     69  CA  LYS A   5       3.248  -4.541  -1.969  1.00  0.00           C  
ATOM     70  C   LYS A   5       2.127  -3.510  -2.138  1.00  0.00           C  
ATOM     71  O   LYS A   5       1.002  -3.851  -2.451  1.00  0.00           O  
ATOM     72  CB  LYS A   5       3.570  -5.208  -3.309  1.00  0.00           C  
ATOM     73  CG  LYS A   5       5.048  -5.623  -3.338  1.00  0.00           C  
ATOM     74  CD  LYS A   5       5.177  -7.039  -3.908  1.00  0.00           C  
ATOM     75  CE  LYS A   5       5.016  -6.996  -5.429  1.00  0.00           C  
ATOM     76  NZ  LYS A   5       6.026  -7.958  -5.949  1.00  0.00           N  
ATOM     77  H   LYS A   5       1.896  -6.021  -1.171  1.00  0.00           H  
ATOM     78  HA  LYS A   5       4.134  -4.072  -1.570  1.00  0.00           H  
ATOM     79  HB2 LYS A   5       2.945  -6.081  -3.432  1.00  0.00           H  
ATOM     80  HB3 LYS A   5       3.379  -4.512  -4.111  1.00  0.00           H  
ATOM     81  HG2 LYS A   5       5.600  -4.934  -3.960  1.00  0.00           H  
ATOM     82  HG3 LYS A   5       5.450  -5.604  -2.336  1.00  0.00           H  
ATOM     83  HD2 LYS A   5       6.150  -7.439  -3.659  1.00  0.00           H  
ATOM     84  HD3 LYS A   5       4.410  -7.669  -3.484  1.00  0.00           H  
ATOM     85  HE2 LYS A   5       4.017  -7.306  -5.708  1.00  0.00           H  
ATOM     86  HE3 LYS A   5       5.222  -6.005  -5.802  1.00  0.00           H  
ATOM     87  HZ1 LYS A   5       5.818  -8.910  -5.587  1.00  0.00           H  
ATOM     88  HZ2 LYS A   5       6.975  -7.667  -5.636  1.00  0.00           H  
ATOM     89  HZ3 LYS A   5       5.992  -7.970  -6.988  1.00  0.00           H  
ATOM     90  N   LEU A   6       2.430  -2.251  -1.936  1.00  0.00           N  
ATOM     91  CA  LEU A   6       1.387  -1.192  -2.085  1.00  0.00           C  
ATOM     92  C   LEU A   6       1.621  -0.395  -3.373  1.00  0.00           C  
ATOM     93  O   LEU A   6       2.672   0.188  -3.566  1.00  0.00           O  
ATOM     94  CB  LEU A   6       1.550  -0.289  -0.853  1.00  0.00           C  
ATOM     95  CG  LEU A   6       0.588   0.908  -0.940  1.00  0.00           C  
ATOM     96  CD1 LEU A   6      -0.853   0.425  -0.765  1.00  0.00           C  
ATOM     97  CD2 LEU A   6       0.926   1.919   0.160  1.00  0.00           C  
ATOM     98  H   LEU A   6       3.344  -2.004  -1.686  1.00  0.00           H  
ATOM     99  HA  LEU A   6       0.405  -1.633  -2.088  1.00  0.00           H  
ATOM    100  HB2 LEU A   6       1.332  -0.858   0.039  1.00  0.00           H  
ATOM    101  HB3 LEU A   6       2.567   0.073  -0.806  1.00  0.00           H  
ATOM    102  HG  LEU A   6       0.691   1.381  -1.907  1.00  0.00           H  
ATOM    103 HD11 LEU A   6      -1.146  -0.153  -1.627  1.00  0.00           H  
ATOM    104 HD12 LEU A   6      -1.511   1.279  -0.666  1.00  0.00           H  
ATOM    105 HD13 LEU A   6      -0.921  -0.188   0.120  1.00  0.00           H  
ATOM    106 HD21 LEU A   6       0.019   2.393   0.503  1.00  0.00           H  
ATOM    107 HD22 LEU A   6       1.597   2.670  -0.234  1.00  0.00           H  
ATOM    108 HD23 LEU A   6       1.400   1.409   0.984  1.00  0.00           H  
ATOM    109  N   ILE A   7       0.641  -0.348  -4.243  1.00  0.00           N  
ATOM    110  CA  ILE A   7       0.801   0.434  -5.503  1.00  0.00           C  
ATOM    111  C   ILE A   7       0.677   1.929  -5.169  1.00  0.00           C  
ATOM    112  O   ILE A   7       0.238   2.286  -4.090  1.00  0.00           O  
ATOM    113  CB  ILE A   7      -0.319  -0.075  -6.445  1.00  0.00           C  
ATOM    114  CG1 ILE A   7       0.136   0.088  -7.896  1.00  0.00           C  
ATOM    115  CG2 ILE A   7      -1.639   0.689  -6.243  1.00  0.00           C  
ATOM    116  CD1 ILE A   7       1.164  -0.995  -8.231  1.00  0.00           C  
ATOM    117  H   ILE A   7      -0.202  -0.811  -4.058  1.00  0.00           H  
ATOM    118  HA  ILE A   7       1.768   0.233  -5.940  1.00  0.00           H  
ATOM    119  HB  ILE A   7      -0.493  -1.122  -6.249  1.00  0.00           H  
ATOM    120 HG12 ILE A   7      -0.716  -0.008  -8.552  1.00  0.00           H  
ATOM    121 HG13 ILE A   7       0.585   1.061  -8.028  1.00  0.00           H  
ATOM    122 HG21 ILE A   7      -1.846   0.773  -5.187  1.00  0.00           H  
ATOM    123 HG22 ILE A   7      -2.443   0.155  -6.726  1.00  0.00           H  
ATOM    124 HG23 ILE A   7      -1.553   1.676  -6.673  1.00  0.00           H  
ATOM    125 HD11 ILE A   7       2.136  -0.689  -7.876  1.00  0.00           H  
ATOM    126 HD12 ILE A   7       1.199  -1.139  -9.300  1.00  0.00           H  
ATOM    127 HD13 ILE A   7       0.880  -1.920  -7.752  1.00  0.00           H  
ATOM    128  N   ILE A   8       1.059   2.799  -6.067  1.00  0.00           N  
ATOM    129  CA  ILE A   8       0.957   4.259  -5.767  1.00  0.00           C  
ATOM    130  C   ILE A   8       0.204   4.989  -6.883  1.00  0.00           C  
ATOM    131  O   ILE A   8       0.788   5.729  -7.652  1.00  0.00           O  
ATOM    132  CB  ILE A   8       2.405   4.757  -5.667  1.00  0.00           C  
ATOM    133  CG1 ILE A   8       3.156   3.958  -4.596  1.00  0.00           C  
ATOM    134  CG2 ILE A   8       2.409   6.237  -5.281  1.00  0.00           C  
ATOM    135  CD1 ILE A   8       4.646   4.299  -4.655  1.00  0.00           C  
ATOM    136  H   ILE A   8       1.416   2.497  -6.928  1.00  0.00           H  
ATOM    137  HA  ILE A   8       0.457   4.408  -4.824  1.00  0.00           H  
ATOM    138  HB  ILE A   8       2.894   4.633  -6.622  1.00  0.00           H  
ATOM    139 HG12 ILE A   8       2.766   4.211  -3.620  1.00  0.00           H  
ATOM    140 HG13 ILE A   8       3.023   2.902  -4.775  1.00  0.00           H  
ATOM    141 HG21 ILE A   8       2.025   6.348  -4.278  1.00  0.00           H  
ATOM    142 HG22 ILE A   8       1.788   6.793  -5.967  1.00  0.00           H  
ATOM    143 HG23 ILE A   8       3.419   6.616  -5.322  1.00  0.00           H  
ATOM    144 HD11 ILE A   8       4.773   5.288  -5.069  1.00  0.00           H  
ATOM    145 HD12 ILE A   8       5.155   3.580  -5.280  1.00  0.00           H  
ATOM    146 HD13 ILE A   8       5.062   4.269  -3.659  1.00  0.00           H  
ATOM    147  N   ASN A   9      -1.092   4.805  -6.967  1.00  0.00           N  
ATOM    148  CA  ASN A   9      -1.874   5.516  -8.022  1.00  0.00           C  
ATOM    149  C   ASN A   9      -2.463   6.795  -7.429  1.00  0.00           C  
ATOM    150  O   ASN A   9      -3.639   7.075  -7.561  1.00  0.00           O  
ATOM    151  CB  ASN A   9      -2.979   4.546  -8.442  1.00  0.00           C  
ATOM    152  CG  ASN A   9      -2.393   3.480  -9.371  1.00  0.00           C  
ATOM    153  OD1 ASN A   9      -1.623   3.787 -10.259  1.00  0.00           O  
ATOM    154  ND2 ASN A   9      -2.728   2.229  -9.202  1.00  0.00           N  
ATOM    155  H   ASN A   9      -1.548   4.217  -6.329  1.00  0.00           H  
ATOM    156  HA  ASN A   9      -1.242   5.749  -8.864  1.00  0.00           H  
ATOM    157  HB2 ASN A   9      -3.395   4.074  -7.568  1.00  0.00           H  
ATOM    158  HB3 ASN A   9      -3.753   5.087  -8.963  1.00  0.00           H  
ATOM    159 HD21 ASN A   9      -3.348   1.980  -8.485  1.00  0.00           H  
ATOM    160 HD22 ASN A   9      -2.358   1.540  -9.792  1.00  0.00           H  
ATOM    161  N   GLY A  10      -1.639   7.565  -6.767  1.00  0.00           N  
ATOM    162  CA  GLY A  10      -2.116   8.831  -6.142  1.00  0.00           C  
ATOM    163  C   GLY A  10      -1.648  10.021  -6.974  1.00  0.00           C  
ATOM    164  O   GLY A  10      -0.787   9.895  -7.826  1.00  0.00           O  
ATOM    165  H   GLY A  10      -0.699   7.304  -6.678  1.00  0.00           H  
ATOM    166  HA2 GLY A  10      -3.194   8.827  -6.091  1.00  0.00           H  
ATOM    167  HA3 GLY A  10      -1.704   8.915  -5.145  1.00  0.00           H  
ATOM    168  N   LYS A  11      -2.201  11.179  -6.722  1.00  0.00           N  
ATOM    169  CA  LYS A  11      -1.786  12.392  -7.482  1.00  0.00           C  
ATOM    170  C   LYS A  11      -0.541  13.031  -6.844  1.00  0.00           C  
ATOM    171  O   LYS A  11      -0.117  14.097  -7.248  1.00  0.00           O  
ATOM    172  CB  LYS A  11      -2.980  13.339  -7.391  1.00  0.00           C  
ATOM    173  CG  LYS A  11      -2.823  14.462  -8.419  1.00  0.00           C  
ATOM    174  CD  LYS A  11      -4.200  15.037  -8.762  1.00  0.00           C  
ATOM    175  CE  LYS A  11      -4.039  16.393  -9.462  1.00  0.00           C  
ATOM    176  NZ  LYS A  11      -4.648  17.387  -8.532  1.00  0.00           N  
ATOM    177  H   LYS A  11      -2.884  11.251  -6.023  1.00  0.00           H  
ATOM    178  HA  LYS A  11      -1.595  12.142  -8.513  1.00  0.00           H  
ATOM    179  HB2 LYS A  11      -3.889  12.792  -7.592  1.00  0.00           H  
ATOM    180  HB3 LYS A  11      -3.027  13.766  -6.400  1.00  0.00           H  
ATOM    181  HG2 LYS A  11      -2.198  15.242  -8.008  1.00  0.00           H  
ATOM    182  HG3 LYS A  11      -2.367  14.069  -9.314  1.00  0.00           H  
ATOM    183  HD2 LYS A  11      -4.720  14.354  -9.419  1.00  0.00           H  
ATOM    184  HD3 LYS A  11      -4.772  15.165  -7.855  1.00  0.00           H  
ATOM    185  HE2 LYS A  11      -2.992  16.616  -9.619  1.00  0.00           H  
ATOM    186  HE3 LYS A  11      -4.569  16.396 -10.402  1.00  0.00           H  
ATOM    187  HZ1 LYS A  11      -5.679  17.253  -8.508  1.00  0.00           H  
ATOM    188  HZ2 LYS A  11      -4.430  18.349  -8.865  1.00  0.00           H  
ATOM    189  HZ3 LYS A  11      -4.260  17.253  -7.578  1.00  0.00           H  
ATOM    190  N   THR A  12       0.045  12.395  -5.852  1.00  0.00           N  
ATOM    191  CA  THR A  12       1.254  12.977  -5.200  1.00  0.00           C  
ATOM    192  C   THR A  12       2.464  12.062  -5.402  1.00  0.00           C  
ATOM    193  O   THR A  12       3.589  12.521  -5.470  1.00  0.00           O  
ATOM    194  CB  THR A  12       0.895  13.072  -3.716  1.00  0.00           C  
ATOM    195  OG1 THR A  12      -0.421  13.588  -3.580  1.00  0.00           O  
ATOM    196  CG2 THR A  12       1.886  14.000  -3.009  1.00  0.00           C  
ATOM    197  H   THR A  12      -0.307  11.539  -5.534  1.00  0.00           H  
ATOM    198  HA  THR A  12       1.457  13.961  -5.593  1.00  0.00           H  
ATOM    199  HB  THR A  12       0.947  12.092  -3.269  1.00  0.00           H  
ATOM    200  HG1 THR A  12      -0.440  14.464  -3.972  1.00  0.00           H  
ATOM    201 HG21 THR A  12       2.834  13.974  -3.526  1.00  0.00           H  
ATOM    202 HG22 THR A  12       2.022  13.671  -1.990  1.00  0.00           H  
ATOM    203 HG23 THR A  12       1.500  15.009  -3.014  1.00  0.00           H  
ATOM    204  N   LEU A  13       2.246  10.770  -5.495  1.00  0.00           N  
ATOM    205  CA  LEU A  13       3.394   9.831  -5.687  1.00  0.00           C  
ATOM    206  C   LEU A  13       3.067   8.784  -6.756  1.00  0.00           C  
ATOM    207  O   LEU A  13       1.953   8.705  -7.239  1.00  0.00           O  
ATOM    208  CB  LEU A  13       3.590   9.165  -4.325  1.00  0.00           C  
ATOM    209  CG  LEU A  13       4.309  10.133  -3.384  1.00  0.00           C  
ATOM    210  CD1 LEU A  13       4.183   9.635  -1.943  1.00  0.00           C  
ATOM    211  CD2 LEU A  13       5.788  10.212  -3.767  1.00  0.00           C  
ATOM    212  H   LEU A  13       1.328  10.419  -5.433  1.00  0.00           H  
ATOM    213  HA  LEU A  13       4.283  10.378  -5.957  1.00  0.00           H  
ATOM    214  HB2 LEU A  13       2.627   8.906  -3.910  1.00  0.00           H  
ATOM    215  HB3 LEU A  13       4.184   8.272  -4.442  1.00  0.00           H  
ATOM    216  HG  LEU A  13       3.861  11.113  -3.465  1.00  0.00           H  
ATOM    217 HD11 LEU A  13       5.037   9.968  -1.372  1.00  0.00           H  
ATOM    218 HD12 LEU A  13       4.145   8.555  -1.938  1.00  0.00           H  
ATOM    219 HD13 LEU A  13       3.279  10.030  -1.504  1.00  0.00           H  
ATOM    220 HD21 LEU A  13       6.309  10.845  -3.065  1.00  0.00           H  
ATOM    221 HD22 LEU A  13       5.882  10.624  -4.762  1.00  0.00           H  
ATOM    222 HD23 LEU A  13       6.219   9.221  -3.746  1.00  0.00           H  
ATOM    223  N   LYS A  14       4.034   7.983  -7.125  1.00  0.00           N  
ATOM    224  CA  LYS A  14       3.796   6.935  -8.163  1.00  0.00           C  
ATOM    225  C   LYS A  14       4.950   5.928  -8.176  1.00  0.00           C  
ATOM    226  O   LYS A  14       6.104   6.295  -8.057  1.00  0.00           O  
ATOM    227  CB  LYS A  14       3.733   7.698  -9.487  1.00  0.00           C  
ATOM    228  CG  LYS A  14       2.730   7.019 -10.427  1.00  0.00           C  
ATOM    229  CD  LYS A  14       3.479   6.133 -11.426  1.00  0.00           C  
ATOM    230  CE  LYS A  14       2.504   5.632 -12.496  1.00  0.00           C  
ATOM    231  NZ  LYS A  14       2.529   6.677 -13.557  1.00  0.00           N  
ATOM    232  H   LYS A  14       4.922   8.071  -6.718  1.00  0.00           H  
ATOM    233  HA  LYS A  14       2.862   6.434  -7.982  1.00  0.00           H  
ATOM    234  HB2 LYS A  14       3.419   8.715  -9.300  1.00  0.00           H  
ATOM    235  HB3 LYS A  14       4.710   7.702  -9.947  1.00  0.00           H  
ATOM    236  HG2 LYS A  14       2.047   6.412  -9.849  1.00  0.00           H  
ATOM    237  HG3 LYS A  14       2.175   7.773 -10.964  1.00  0.00           H  
ATOM    238  HD2 LYS A  14       4.265   6.706 -11.896  1.00  0.00           H  
ATOM    239  HD3 LYS A  14       3.907   5.289 -10.909  1.00  0.00           H  
ATOM    240  HE2 LYS A  14       2.838   4.683 -12.891  1.00  0.00           H  
ATOM    241  HE3 LYS A  14       1.510   5.544 -12.088  1.00  0.00           H  
ATOM    242  HZ1 LYS A  14       1.822   6.451 -14.285  1.00  0.00           H  
ATOM    243  HZ2 LYS A  14       3.476   6.709 -13.990  1.00  0.00           H  
ATOM    244  HZ3 LYS A  14       2.308   7.603 -13.138  1.00  0.00           H  
ATOM    245  N   GLY A  15       4.643   4.662  -8.321  1.00  0.00           N  
ATOM    246  CA  GLY A  15       5.715   3.626  -8.345  1.00  0.00           C  
ATOM    247  C   GLY A  15       5.263   2.399  -7.553  1.00  0.00           C  
ATOM    248  O   GLY A  15       4.141   1.948  -7.679  1.00  0.00           O  
ATOM    249  H   GLY A  15       3.707   4.393  -8.417  1.00  0.00           H  
ATOM    250  HA2 GLY A  15       5.913   3.343  -9.368  1.00  0.00           H  
ATOM    251  HA3 GLY A  15       6.612   4.027  -7.901  1.00  0.00           H  
ATOM    252  N   GLU A  16       6.134   1.854  -6.741  1.00  0.00           N  
ATOM    253  CA  GLU A  16       5.766   0.650  -5.937  1.00  0.00           C  
ATOM    254  C   GLU A  16       6.616   0.582  -4.665  1.00  0.00           C  
ATOM    255  O   GLU A  16       7.714   1.102  -4.614  1.00  0.00           O  
ATOM    256  CB  GLU A  16       6.069  -0.539  -6.849  1.00  0.00           C  
ATOM    257  CG  GLU A  16       5.347  -1.782  -6.326  1.00  0.00           C  
ATOM    258  CD  GLU A  16       5.719  -2.990  -7.189  1.00  0.00           C  
ATOM    259  OE1 GLU A  16       5.758  -2.838  -8.399  1.00  0.00           O  
ATOM    260  OE2 GLU A  16       5.958  -4.045  -6.626  1.00  0.00           O  
ATOM    261  H   GLU A  16       7.032   2.237  -6.661  1.00  0.00           H  
ATOM    262  HA  GLU A  16       4.717   0.667  -5.690  1.00  0.00           H  
ATOM    263  HB2 GLU A  16       5.729  -0.319  -7.852  1.00  0.00           H  
ATOM    264  HB3 GLU A  16       7.133  -0.721  -6.862  1.00  0.00           H  
ATOM    265  HG2 GLU A  16       5.644  -1.966  -5.303  1.00  0.00           H  
ATOM    266  HG3 GLU A  16       4.281  -1.626  -6.370  1.00  0.00           H  
ATOM    267  N   THR A  17       6.112  -0.058  -3.641  1.00  0.00           N  
ATOM    268  CA  THR A  17       6.880  -0.169  -2.365  1.00  0.00           C  
ATOM    269  C   THR A  17       6.638  -1.536  -1.718  1.00  0.00           C  
ATOM    270  O   THR A  17       5.625  -2.169  -1.949  1.00  0.00           O  
ATOM    271  CB  THR A  17       6.334   0.951  -1.478  1.00  0.00           C  
ATOM    272  OG1 THR A  17       6.477   2.196  -2.148  1.00  0.00           O  
ATOM    273  CG2 THR A  17       7.109   0.987  -0.159  1.00  0.00           C  
ATOM    274  H   THR A  17       5.224  -0.469  -3.712  1.00  0.00           H  
ATOM    275  HA  THR A  17       7.933  -0.017  -2.545  1.00  0.00           H  
ATOM    276  HB  THR A  17       5.291   0.771  -1.271  1.00  0.00           H  
ATOM    277  HG1 THR A  17       5.687   2.344  -2.670  1.00  0.00           H  
ATOM    278 HG21 THR A  17       6.832   0.136   0.445  1.00  0.00           H  
ATOM    279 HG22 THR A  17       6.874   1.898   0.372  1.00  0.00           H  
ATOM    280 HG23 THR A  17       8.170   0.953  -0.364  1.00  0.00           H  
ATOM    281  N   THR A  18       7.563  -1.993  -0.911  1.00  0.00           N  
ATOM    282  CA  THR A  18       7.394  -3.319  -0.243  1.00  0.00           C  
ATOM    283  C   THR A  18       7.730  -3.211   1.246  1.00  0.00           C  
ATOM    284  O   THR A  18       8.186  -2.186   1.716  1.00  0.00           O  
ATOM    285  CB  THR A  18       8.383  -4.248  -0.950  1.00  0.00           C  
ATOM    286  OG1 THR A  18       9.696  -3.719  -0.826  1.00  0.00           O  
ATOM    287  CG2 THR A  18       8.014  -4.361  -2.429  1.00  0.00           C  
ATOM    288  H   THR A  18       8.369  -1.462  -0.743  1.00  0.00           H  
ATOM    289  HA  THR A  18       6.388  -3.682  -0.378  1.00  0.00           H  
ATOM    290  HB  THR A  18       8.345  -5.226  -0.497  1.00  0.00           H  
ATOM    291  HG1 THR A  18      10.015  -3.920   0.057  1.00  0.00           H  
ATOM    292 HG21 THR A  18       8.261  -5.350  -2.787  1.00  0.00           H  
ATOM    293 HG22 THR A  18       8.566  -3.624  -2.996  1.00  0.00           H  
ATOM    294 HG23 THR A  18       6.955  -4.188  -2.550  1.00  0.00           H  
ATOM    295  N   THR A  19       7.509  -4.267   1.988  1.00  0.00           N  
ATOM    296  CA  THR A  19       7.814  -4.241   3.451  1.00  0.00           C  
ATOM    297  C   THR A  19       7.851  -5.668   4.008  1.00  0.00           C  
ATOM    298  O   THR A  19       7.822  -6.632   3.267  1.00  0.00           O  
ATOM    299  CB  THR A  19       6.672  -3.438   4.088  1.00  0.00           C  
ATOM    300  OG1 THR A  19       6.866  -3.381   5.494  1.00  0.00           O  
ATOM    301  CG2 THR A  19       5.326  -4.104   3.786  1.00  0.00           C  
ATOM    302  H   THR A  19       7.143  -5.079   1.580  1.00  0.00           H  
ATOM    303  HA  THR A  19       8.755  -3.745   3.628  1.00  0.00           H  
ATOM    304  HB  THR A  19       6.670  -2.436   3.686  1.00  0.00           H  
ATOM    305  HG1 THR A  19       7.635  -2.833   5.665  1.00  0.00           H  
ATOM    306 HG21 THR A  19       5.260  -5.042   4.318  1.00  0.00           H  
ATOM    307 HG22 THR A  19       5.244  -4.287   2.725  1.00  0.00           H  
ATOM    308 HG23 THR A  19       4.523  -3.454   4.103  1.00  0.00           H  
ATOM    309  N   GLU A  20       7.913  -5.802   5.307  1.00  0.00           N  
ATOM    310  CA  GLU A  20       7.949  -7.163   5.923  1.00  0.00           C  
ATOM    311  C   GLU A  20       6.843  -7.302   6.977  1.00  0.00           C  
ATOM    312  O   GLU A  20       6.974  -6.845   8.098  1.00  0.00           O  
ATOM    313  CB  GLU A  20       9.339  -7.285   6.563  1.00  0.00           C  
ATOM    314  CG  GLU A  20       9.566  -6.157   7.584  1.00  0.00           C  
ATOM    315  CD  GLU A  20       9.815  -6.754   8.972  1.00  0.00           C  
ATOM    316  OE1 GLU A  20      10.954  -7.085   9.258  1.00  0.00           O  
ATOM    317  OE2 GLU A  20       8.862  -6.870   9.726  1.00  0.00           O  
ATOM    318  H   GLU A  20       7.933  -5.007   5.877  1.00  0.00           H  
ATOM    319  HA  GLU A  20       7.831  -7.918   5.162  1.00  0.00           H  
ATOM    320  HB2 GLU A  20       9.421  -8.243   7.055  1.00  0.00           H  
ATOM    321  HB3 GLU A  20      10.090  -7.218   5.790  1.00  0.00           H  
ATOM    322  HG2 GLU A  20      10.424  -5.573   7.287  1.00  0.00           H  
ATOM    323  HG3 GLU A  20       8.697  -5.519   7.622  1.00  0.00           H  
ATOM    324  N   ALA A  21       5.753  -7.931   6.619  1.00  0.00           N  
ATOM    325  CA  ALA A  21       4.631  -8.109   7.588  1.00  0.00           C  
ATOM    326  C   ALA A  21       4.195  -9.574   7.621  1.00  0.00           C  
ATOM    327  O   ALA A  21       4.178 -10.245   6.606  1.00  0.00           O  
ATOM    328  CB  ALA A  21       3.501  -7.226   7.054  1.00  0.00           C  
ATOM    329  H   ALA A  21       5.673  -8.290   5.712  1.00  0.00           H  
ATOM    330  HA  ALA A  21       4.924  -7.779   8.572  1.00  0.00           H  
ATOM    331  HB1 ALA A  21       2.983  -6.765   7.882  1.00  0.00           H  
ATOM    332  HB2 ALA A  21       2.808  -7.831   6.488  1.00  0.00           H  
ATOM    333  HB3 ALA A  21       3.915  -6.459   6.416  1.00  0.00           H  
ATOM    334  N   VAL A  22       3.844 -10.073   8.778  1.00  0.00           N  
ATOM    335  CA  VAL A  22       3.409 -11.501   8.881  1.00  0.00           C  
ATOM    336  C   VAL A  22       2.165 -11.735   8.015  1.00  0.00           C  
ATOM    337  O   VAL A  22       1.953 -12.816   7.498  1.00  0.00           O  
ATOM    338  CB  VAL A  22       3.101 -11.725  10.368  1.00  0.00           C  
ATOM    339  CG1 VAL A  22       1.989 -10.774  10.824  1.00  0.00           C  
ATOM    340  CG2 VAL A  22       2.653 -13.172  10.587  1.00  0.00           C  
ATOM    341  H   VAL A  22       3.868  -9.508   9.580  1.00  0.00           H  
ATOM    342  HA  VAL A  22       4.208 -12.154   8.569  1.00  0.00           H  
ATOM    343  HB  VAL A  22       3.992 -11.534  10.949  1.00  0.00           H  
ATOM    344 HG11 VAL A  22       2.016  -9.874  10.229  1.00  0.00           H  
ATOM    345 HG12 VAL A  22       2.135 -10.522  11.864  1.00  0.00           H  
ATOM    346 HG13 VAL A  22       1.030 -11.257  10.703  1.00  0.00           H  
ATOM    347 HG21 VAL A  22       3.485 -13.837  10.410  1.00  0.00           H  
ATOM    348 HG22 VAL A  22       1.852 -13.408   9.902  1.00  0.00           H  
ATOM    349 HG23 VAL A  22       2.305 -13.292  11.603  1.00  0.00           H  
ATOM    350  N   ASP A  23       1.348 -10.725   7.852  1.00  0.00           N  
ATOM    351  CA  ASP A  23       0.117 -10.873   7.017  1.00  0.00           C  
ATOM    352  C   ASP A  23      -0.533  -9.507   6.781  1.00  0.00           C  
ATOM    353  O   ASP A  23      -0.086  -8.500   7.298  1.00  0.00           O  
ATOM    354  CB  ASP A  23      -0.822 -11.793   7.813  1.00  0.00           C  
ATOM    355  CG  ASP A  23      -1.042 -11.247   9.233  1.00  0.00           C  
ATOM    356  OD1 ASP A  23      -0.870 -10.055   9.429  1.00  0.00           O  
ATOM    357  OD2 ASP A  23      -1.377 -12.037  10.101  1.00  0.00           O  
ATOM    358  H   ASP A  23       1.546  -9.866   8.278  1.00  0.00           H  
ATOM    359  HA  ASP A  23       0.363 -11.335   6.074  1.00  0.00           H  
ATOM    360  HB2 ASP A  23      -1.773 -11.855   7.305  1.00  0.00           H  
ATOM    361  HB3 ASP A  23      -0.386 -12.778   7.874  1.00  0.00           H  
ATOM    362  N   ALA A  24      -1.582  -9.466   5.996  1.00  0.00           N  
ATOM    363  CA  ALA A  24      -2.268  -8.168   5.708  1.00  0.00           C  
ATOM    364  C   ALA A  24      -2.674  -7.462   7.008  1.00  0.00           C  
ATOM    365  O   ALA A  24      -2.816  -6.254   7.046  1.00  0.00           O  
ATOM    366  CB  ALA A  24      -3.511  -8.542   4.897  1.00  0.00           C  
ATOM    367  H   ALA A  24      -1.913 -10.290   5.589  1.00  0.00           H  
ATOM    368  HA  ALA A  24      -1.628  -7.537   5.121  1.00  0.00           H  
ATOM    369  HB1 ALA A  24      -3.214  -8.856   3.907  1.00  0.00           H  
ATOM    370  HB2 ALA A  24      -4.163  -7.684   4.821  1.00  0.00           H  
ATOM    371  HB3 ALA A  24      -4.034  -9.349   5.390  1.00  0.00           H  
ATOM    372  N   ALA A  25      -2.860  -8.206   8.070  1.00  0.00           N  
ATOM    373  CA  ALA A  25      -3.256  -7.580   9.370  1.00  0.00           C  
ATOM    374  C   ALA A  25      -2.190  -6.578   9.828  1.00  0.00           C  
ATOM    375  O   ALA A  25      -2.482  -5.634  10.538  1.00  0.00           O  
ATOM    376  CB  ALA A  25      -3.359  -8.741  10.363  1.00  0.00           C  
ATOM    377  H   ALA A  25      -2.738  -9.178   8.010  1.00  0.00           H  
ATOM    378  HA  ALA A  25      -4.214  -7.093   9.276  1.00  0.00           H  
ATOM    379  HB1 ALA A  25      -2.433  -8.827  10.913  1.00  0.00           H  
ATOM    380  HB2 ALA A  25      -3.544  -9.659   9.826  1.00  0.00           H  
ATOM    381  HB3 ALA A  25      -4.170  -8.555  11.050  1.00  0.00           H  
ATOM    382  N   THR A  26      -0.960  -6.778   9.425  1.00  0.00           N  
ATOM    383  CA  THR A  26       0.129  -5.840   9.834  1.00  0.00           C  
ATOM    384  C   THR A  26       0.642  -5.057   8.620  1.00  0.00           C  
ATOM    385  O   THR A  26       1.120  -3.946   8.746  1.00  0.00           O  
ATOM    386  CB  THR A  26       1.234  -6.735  10.398  1.00  0.00           C  
ATOM    387  OG1 THR A  26       0.653  -7.747  11.209  1.00  0.00           O  
ATOM    388  CG2 THR A  26       2.196  -5.893  11.239  1.00  0.00           C  
ATOM    389  H   THR A  26      -0.752  -7.547   8.854  1.00  0.00           H  
ATOM    390  HA  THR A  26      -0.223  -5.164  10.596  1.00  0.00           H  
ATOM    391  HB  THR A  26       1.778  -7.192   9.586  1.00  0.00           H  
ATOM    392  HG1 THR A  26       0.497  -8.517  10.657  1.00  0.00           H  
ATOM    393 HG21 THR A  26       3.171  -6.356  11.241  1.00  0.00           H  
ATOM    394 HG22 THR A  26       1.826  -5.827  12.251  1.00  0.00           H  
ATOM    395 HG23 THR A  26       2.268  -4.901  10.816  1.00  0.00           H  
ATOM    396  N   ALA A  27       0.544  -5.630   7.446  1.00  0.00           N  
ATOM    397  CA  ALA A  27       1.024  -4.924   6.216  1.00  0.00           C  
ATOM    398  C   ALA A  27       0.271  -3.603   6.031  1.00  0.00           C  
ATOM    399  O   ALA A  27       0.867  -2.562   5.826  1.00  0.00           O  
ATOM    400  CB  ALA A  27       0.719  -5.877   5.059  1.00  0.00           C  
ATOM    401  H   ALA A  27       0.153  -6.527   7.375  1.00  0.00           H  
ATOM    402  HA  ALA A  27       2.086  -4.745   6.276  1.00  0.00           H  
ATOM    403  HB1 ALA A  27      -0.262  -5.661   4.665  1.00  0.00           H  
ATOM    404  HB2 ALA A  27       0.747  -6.896   5.417  1.00  0.00           H  
ATOM    405  HB3 ALA A  27       1.458  -5.748   4.282  1.00  0.00           H  
ATOM    406  N   GLU A  28      -1.036  -3.641   6.104  1.00  0.00           N  
ATOM    407  CA  GLU A  28      -1.842  -2.390   5.936  1.00  0.00           C  
ATOM    408  C   GLU A  28      -1.446  -1.358   6.993  1.00  0.00           C  
ATOM    409  O   GLU A  28      -1.345  -0.184   6.708  1.00  0.00           O  
ATOM    410  CB  GLU A  28      -3.298  -2.822   6.125  1.00  0.00           C  
ATOM    411  CG  GLU A  28      -4.229  -1.685   5.702  1.00  0.00           C  
ATOM    412  CD  GLU A  28      -5.520  -1.751   6.522  1.00  0.00           C  
ATOM    413  OE1 GLU A  28      -5.426  -1.916   7.726  1.00  0.00           O  
ATOM    414  OE2 GLU A  28      -6.580  -1.635   5.929  1.00  0.00           O  
ATOM    415  H   GLU A  28      -1.487  -4.496   6.272  1.00  0.00           H  
ATOM    416  HA  GLU A  28      -1.705  -1.979   4.946  1.00  0.00           H  
ATOM    417  HB2 GLU A  28      -3.494  -3.695   5.519  1.00  0.00           H  
ATOM    418  HB3 GLU A  28      -3.471  -3.060   7.164  1.00  0.00           H  
ATOM    419  HG2 GLU A  28      -3.741  -0.737   5.875  1.00  0.00           H  
ATOM    420  HG3 GLU A  28      -4.465  -1.783   4.654  1.00  0.00           H  
ATOM    421  N   LYS A  29      -1.216  -1.787   8.210  1.00  0.00           N  
ATOM    422  CA  LYS A  29      -0.822  -0.821   9.287  1.00  0.00           C  
ATOM    423  C   LYS A  29       0.440  -0.052   8.879  1.00  0.00           C  
ATOM    424  O   LYS A  29       0.593   1.116   9.186  1.00  0.00           O  
ATOM    425  CB  LYS A  29      -0.546  -1.683  10.520  1.00  0.00           C  
ATOM    426  CG  LYS A  29      -1.838  -2.374  10.959  1.00  0.00           C  
ATOM    427  CD  LYS A  29      -1.828  -2.565  12.477  1.00  0.00           C  
ATOM    428  CE  LYS A  29      -3.226  -2.961  12.952  1.00  0.00           C  
ATOM    429  NZ  LYS A  29      -3.036  -3.442  14.349  1.00  0.00           N  
ATOM    430  H   LYS A  29      -1.302  -2.742   8.413  1.00  0.00           H  
ATOM    431  HA  LYS A  29      -1.629  -0.135   9.490  1.00  0.00           H  
ATOM    432  HB2 LYS A  29       0.198  -2.429  10.279  1.00  0.00           H  
ATOM    433  HB3 LYS A  29      -0.184  -1.059  11.323  1.00  0.00           H  
ATOM    434  HG2 LYS A  29      -2.686  -1.765  10.678  1.00  0.00           H  
ATOM    435  HG3 LYS A  29      -1.913  -3.338  10.478  1.00  0.00           H  
ATOM    436  HD2 LYS A  29      -1.123  -3.343  12.737  1.00  0.00           H  
ATOM    437  HD3 LYS A  29      -1.535  -1.641  12.953  1.00  0.00           H  
ATOM    438  HE2 LYS A  29      -3.885  -2.104  12.934  1.00  0.00           H  
ATOM    439  HE3 LYS A  29      -3.622  -3.756  12.339  1.00  0.00           H  
ATOM    440  HZ1 LYS A  29      -3.921  -3.862  14.695  1.00  0.00           H  
ATOM    441  HZ2 LYS A  29      -2.770  -2.641  14.957  1.00  0.00           H  
ATOM    442  HZ3 LYS A  29      -2.283  -4.159  14.369  1.00  0.00           H  
ATOM    443  N   VAL A  30       1.340  -0.702   8.186  1.00  0.00           N  
ATOM    444  CA  VAL A  30       2.595  -0.021   7.749  1.00  0.00           C  
ATOM    445  C   VAL A  30       2.352   0.742   6.442  1.00  0.00           C  
ATOM    446  O   VAL A  30       2.716   1.896   6.312  1.00  0.00           O  
ATOM    447  CB  VAL A  30       3.606  -1.156   7.536  1.00  0.00           C  
ATOM    448  CG1 VAL A  30       4.936  -0.583   7.035  1.00  0.00           C  
ATOM    449  CG2 VAL A  30       3.838  -1.887   8.861  1.00  0.00           C  
ATOM    450  H   VAL A  30       1.189  -1.642   7.951  1.00  0.00           H  
ATOM    451  HA  VAL A  30       2.948   0.649   8.517  1.00  0.00           H  
ATOM    452  HB  VAL A  30       3.216  -1.849   6.804  1.00  0.00           H  
ATOM    453 HG11 VAL A  30       5.734  -1.274   7.263  1.00  0.00           H  
ATOM    454 HG12 VAL A  30       5.127   0.361   7.522  1.00  0.00           H  
ATOM    455 HG13 VAL A  30       4.883  -0.433   5.966  1.00  0.00           H  
ATOM    456 HG21 VAL A  30       2.928  -1.880   9.442  1.00  0.00           H  
ATOM    457 HG22 VAL A  30       4.622  -1.389   9.412  1.00  0.00           H  
ATOM    458 HG23 VAL A  30       4.131  -2.907   8.661  1.00  0.00           H  
ATOM    459  N   PHE A  31       1.742   0.102   5.477  1.00  0.00           N  
ATOM    460  CA  PHE A  31       1.477   0.785   4.174  1.00  0.00           C  
ATOM    461  C   PHE A  31       0.483   1.931   4.371  1.00  0.00           C  
ATOM    462  O   PHE A  31       0.596   2.971   3.749  1.00  0.00           O  
ATOM    463  CB  PHE A  31       0.887  -0.291   3.259  1.00  0.00           C  
ATOM    464  CG  PHE A  31       2.004  -1.074   2.605  1.00  0.00           C  
ATOM    465  CD1 PHE A  31       3.030  -0.404   1.924  1.00  0.00           C  
ATOM    466  CD2 PHE A  31       2.012  -2.471   2.678  1.00  0.00           C  
ATOM    467  CE1 PHE A  31       4.061  -1.132   1.319  1.00  0.00           C  
ATOM    468  CE2 PHE A  31       3.043  -3.198   2.071  1.00  0.00           C  
ATOM    469  CZ  PHE A  31       4.068  -2.529   1.392  1.00  0.00           C  
ATOM    470  H   PHE A  31       1.462  -0.828   5.608  1.00  0.00           H  
ATOM    471  HA  PHE A  31       2.397   1.160   3.755  1.00  0.00           H  
ATOM    472  HB2 PHE A  31       0.273  -0.961   3.844  1.00  0.00           H  
ATOM    473  HB3 PHE A  31       0.283   0.177   2.496  1.00  0.00           H  
ATOM    474  HD1 PHE A  31       3.027   0.674   1.869  1.00  0.00           H  
ATOM    475  HD2 PHE A  31       1.223  -2.989   3.202  1.00  0.00           H  
ATOM    476  HE1 PHE A  31       4.852  -0.615   0.794  1.00  0.00           H  
ATOM    477  HE2 PHE A  31       3.049  -4.276   2.128  1.00  0.00           H  
ATOM    478  HZ  PHE A  31       4.863  -3.091   0.926  1.00  0.00           H  
ATOM    479  N   LYS A  32      -0.486   1.752   5.235  1.00  0.00           N  
ATOM    480  CA  LYS A  32      -1.482   2.839   5.475  1.00  0.00           C  
ATOM    481  C   LYS A  32      -0.771   4.059   6.063  1.00  0.00           C  
ATOM    482  O   LYS A  32      -0.993   5.180   5.644  1.00  0.00           O  
ATOM    483  CB  LYS A  32      -2.485   2.270   6.480  1.00  0.00           C  
ATOM    484  CG  LYS A  32      -3.595   3.293   6.727  1.00  0.00           C  
ATOM    485  CD  LYS A  32      -4.658   3.167   5.634  1.00  0.00           C  
ATOM    486  CE  LYS A  32      -5.416   4.490   5.500  1.00  0.00           C  
ATOM    487  NZ  LYS A  32      -6.678   4.140   4.792  1.00  0.00           N  
ATOM    488  H   LYS A  32      -0.552   0.906   5.727  1.00  0.00           H  
ATOM    489  HA  LYS A  32      -1.982   3.094   4.555  1.00  0.00           H  
ATOM    490  HB2 LYS A  32      -2.914   1.360   6.083  1.00  0.00           H  
ATOM    491  HB3 LYS A  32      -1.982   2.055   7.410  1.00  0.00           H  
ATOM    492  HG2 LYS A  32      -4.046   3.109   7.692  1.00  0.00           H  
ATOM    493  HG3 LYS A  32      -3.179   4.289   6.707  1.00  0.00           H  
ATOM    494  HD2 LYS A  32      -4.181   2.927   4.695  1.00  0.00           H  
ATOM    495  HD3 LYS A  32      -5.352   2.381   5.896  1.00  0.00           H  
ATOM    496  HE2 LYS A  32      -5.630   4.899   6.478  1.00  0.00           H  
ATOM    497  HE3 LYS A  32      -4.845   5.192   4.914  1.00  0.00           H  
ATOM    498  HZ1 LYS A  32      -7.154   3.364   5.295  1.00  0.00           H  
ATOM    499  HZ2 LYS A  32      -6.458   3.842   3.819  1.00  0.00           H  
ATOM    500  HZ3 LYS A  32      -7.304   4.969   4.768  1.00  0.00           H  
ATOM    501  N   GLN A  33       0.096   3.843   7.024  1.00  0.00           N  
ATOM    502  CA  GLN A  33       0.843   4.986   7.638  1.00  0.00           C  
ATOM    503  C   GLN A  33       1.678   5.689   6.569  1.00  0.00           C  
ATOM    504  O   GLN A  33       1.888   6.887   6.610  1.00  0.00           O  
ATOM    505  CB  GLN A  33       1.744   4.358   8.704  1.00  0.00           C  
ATOM    506  CG  GLN A  33       2.507   5.461   9.442  1.00  0.00           C  
ATOM    507  CD  GLN A  33       1.567   6.165  10.423  1.00  0.00           C  
ATOM    508  OE1 GLN A  33       1.008   5.539  11.302  1.00  0.00           O  
ATOM    509  NE2 GLN A  33       1.367   7.449  10.309  1.00  0.00           N  
ATOM    510  H   GLN A  33       0.261   2.928   7.332  1.00  0.00           H  
ATOM    511  HA  GLN A  33       0.161   5.676   8.089  1.00  0.00           H  
ATOM    512  HB2 GLN A  33       1.138   3.806   9.407  1.00  0.00           H  
ATOM    513  HB3 GLN A  33       2.449   3.689   8.232  1.00  0.00           H  
ATOM    514  HG2 GLN A  33       3.333   5.025   9.984  1.00  0.00           H  
ATOM    515  HG3 GLN A  33       2.882   6.179   8.728  1.00  0.00           H  
ATOM    516 HE21 GLN A  33       1.817   7.954   9.600  1.00  0.00           H  
ATOM    517 HE22 GLN A  33       0.767   7.909  10.933  1.00  0.00           H  
ATOM    518  N   TYR A  34       2.131   4.943   5.604  1.00  0.00           N  
ATOM    519  CA  TYR A  34       2.939   5.534   4.494  1.00  0.00           C  
ATOM    520  C   TYR A  34       2.014   6.391   3.615  1.00  0.00           C  
ATOM    521  O   TYR A  34       2.244   7.569   3.419  1.00  0.00           O  
ATOM    522  CB  TYR A  34       3.507   4.309   3.738  1.00  0.00           C  
ATOM    523  CG  TYR A  34       3.861   4.654   2.306  1.00  0.00           C  
ATOM    524  CD1 TYR A  34       5.100   5.227   2.011  1.00  0.00           C  
ATOM    525  CD2 TYR A  34       2.942   4.400   1.280  1.00  0.00           C  
ATOM    526  CE1 TYR A  34       5.425   5.549   0.687  1.00  0.00           C  
ATOM    527  CE2 TYR A  34       3.264   4.719  -0.043  1.00  0.00           C  
ATOM    528  CZ  TYR A  34       4.507   5.294  -0.340  1.00  0.00           C  
ATOM    529  OH  TYR A  34       4.827   5.610  -1.646  1.00  0.00           O  
ATOM    530  H   TYR A  34       1.922   3.989   5.604  1.00  0.00           H  
ATOM    531  HA  TYR A  34       3.745   6.132   4.891  1.00  0.00           H  
ATOM    532  HB2 TYR A  34       4.397   3.966   4.243  1.00  0.00           H  
ATOM    533  HB3 TYR A  34       2.770   3.518   3.742  1.00  0.00           H  
ATOM    534  HD1 TYR A  34       5.804   5.422   2.807  1.00  0.00           H  
ATOM    535  HD2 TYR A  34       1.985   3.957   1.511  1.00  0.00           H  
ATOM    536  HE1 TYR A  34       6.382   5.992   0.459  1.00  0.00           H  
ATOM    537  HE2 TYR A  34       2.553   4.522  -0.833  1.00  0.00           H  
ATOM    538  HH  TYR A  34       5.649   5.165  -1.864  1.00  0.00           H  
ATOM    539  N   ALA A  35       0.974   5.797   3.091  1.00  0.00           N  
ATOM    540  CA  ALA A  35       0.025   6.560   2.225  1.00  0.00           C  
ATOM    541  C   ALA A  35      -0.632   7.685   3.031  1.00  0.00           C  
ATOM    542  O   ALA A  35      -0.706   8.815   2.589  1.00  0.00           O  
ATOM    543  CB  ALA A  35      -1.022   5.539   1.780  1.00  0.00           C  
ATOM    544  H   ALA A  35       0.817   4.846   3.271  1.00  0.00           H  
ATOM    545  HA  ALA A  35       0.538   6.961   1.366  1.00  0.00           H  
ATOM    546  HB1 ALA A  35      -0.708   5.077   0.854  1.00  0.00           H  
ATOM    547  HB2 ALA A  35      -1.969   6.036   1.629  1.00  0.00           H  
ATOM    548  HB3 ALA A  35      -1.133   4.778   2.542  1.00  0.00           H  
ATOM    549  N   ASN A  36      -1.111   7.379   4.214  1.00  0.00           N  
ATOM    550  CA  ASN A  36      -1.769   8.420   5.062  1.00  0.00           C  
ATOM    551  C   ASN A  36      -0.833   9.618   5.268  1.00  0.00           C  
ATOM    552  O   ASN A  36      -1.273  10.748   5.371  1.00  0.00           O  
ATOM    553  CB  ASN A  36      -2.056   7.733   6.399  1.00  0.00           C  
ATOM    554  CG  ASN A  36      -3.028   8.587   7.214  1.00  0.00           C  
ATOM    555  OD1 ASN A  36      -4.030   9.045   6.702  1.00  0.00           O  
ATOM    556  ND2 ASN A  36      -2.773   8.823   8.472  1.00  0.00           N  
ATOM    557  H   ASN A  36      -1.041   6.462   4.541  1.00  0.00           H  
ATOM    558  HA  ASN A  36      -2.690   8.736   4.608  1.00  0.00           H  
ATOM    559  HB2 ASN A  36      -2.493   6.762   6.217  1.00  0.00           H  
ATOM    560  HB3 ASN A  36      -1.134   7.614   6.948  1.00  0.00           H  
ATOM    561 HD21 ASN A  36      -1.965   8.455   8.885  1.00  0.00           H  
ATOM    562 HD22 ASN A  36      -3.389   9.369   9.003  1.00  0.00           H  
ATOM    563  N   ASP A  37       0.451   9.373   5.326  1.00  0.00           N  
ATOM    564  CA  ASP A  37       1.424  10.492   5.520  1.00  0.00           C  
ATOM    565  C   ASP A  37       1.489  11.352   4.257  1.00  0.00           C  
ATOM    566  O   ASP A  37       1.377  12.562   4.313  1.00  0.00           O  
ATOM    567  CB  ASP A  37       2.772   9.815   5.780  1.00  0.00           C  
ATOM    568  CG  ASP A  37       2.959   9.610   7.283  1.00  0.00           C  
ATOM    569  OD1 ASP A  37       2.575  10.492   8.034  1.00  0.00           O  
ATOM    570  OD2 ASP A  37       3.485   8.575   7.660  1.00  0.00           O  
ATOM    571  H   ASP A  37       0.776   8.452   5.237  1.00  0.00           H  
ATOM    572  HA  ASP A  37       1.142  11.092   6.371  1.00  0.00           H  
ATOM    573  HB2 ASP A  37       2.794   8.858   5.279  1.00  0.00           H  
ATOM    574  HB3 ASP A  37       3.566  10.439   5.401  1.00  0.00           H  
ATOM    575  N   ASN A  38       1.664  10.733   3.117  1.00  0.00           N  
ATOM    576  CA  ASN A  38       1.732  11.507   1.840  1.00  0.00           C  
ATOM    577  C   ASN A  38       0.346  12.051   1.486  1.00  0.00           C  
ATOM    578  O   ASN A  38       0.195  13.209   1.142  1.00  0.00           O  
ATOM    579  CB  ASN A  38       2.200  10.504   0.784  1.00  0.00           C  
ATOM    580  CG  ASN A  38       3.699  10.249   0.950  1.00  0.00           C  
ATOM    581  OD1 ASN A  38       4.496  11.161   0.862  1.00  0.00           O  
ATOM    582  ND2 ASN A  38       4.120   9.036   1.188  1.00  0.00           N  
ATOM    583  H   ASN A  38       1.748   9.756   3.103  1.00  0.00           H  
ATOM    584  HA  ASN A  38       2.444  12.313   1.925  1.00  0.00           H  
ATOM    585  HB2 ASN A  38       1.660   9.575   0.905  1.00  0.00           H  
ATOM    586  HB3 ASN A  38       2.012  10.904  -0.201  1.00  0.00           H  
ATOM    587 HD21 ASN A  38       3.477   8.300   1.259  1.00  0.00           H  
ATOM    588 HD22 ASN A  38       5.078   8.863   1.295  1.00  0.00           H  
ATOM    589  N   GLY A  39      -0.665  11.225   1.575  1.00  0.00           N  
ATOM    590  CA  GLY A  39      -2.046  11.686   1.252  1.00  0.00           C  
ATOM    591  C   GLY A  39      -2.667  10.773   0.193  1.00  0.00           C  
ATOM    592  O   GLY A  39      -3.300  11.236  -0.738  1.00  0.00           O  
ATOM    593  H   GLY A  39      -0.514  10.299   1.859  1.00  0.00           H  
ATOM    594  HA2 GLY A  39      -2.650  11.660   2.148  1.00  0.00           H  
ATOM    595  HA3 GLY A  39      -2.008  12.696   0.874  1.00  0.00           H  
ATOM    596  N   ILE A  40      -2.496   9.481   0.327  1.00  0.00           N  
ATOM    597  CA  ILE A  40      -3.083   8.538  -0.672  1.00  0.00           C  
ATOM    598  C   ILE A  40      -4.305   7.830  -0.079  1.00  0.00           C  
ATOM    599  O   ILE A  40      -4.274   6.647   0.201  1.00  0.00           O  
ATOM    600  CB  ILE A  40      -1.966   7.537  -0.995  1.00  0.00           C  
ATOM    601  CG1 ILE A  40      -0.790   8.295  -1.624  1.00  0.00           C  
ATOM    602  CG2 ILE A  40      -2.483   6.477  -1.983  1.00  0.00           C  
ATOM    603  CD1 ILE A  40       0.377   7.339  -1.883  1.00  0.00           C  
ATOM    604  H   ILE A  40      -1.986   9.132   1.088  1.00  0.00           H  
ATOM    605  HA  ILE A  40      -3.363   9.074  -1.566  1.00  0.00           H  
ATOM    606  HB  ILE A  40      -1.641   7.055  -0.086  1.00  0.00           H  
ATOM    607 HG12 ILE A  40      -1.107   8.735  -2.559  1.00  0.00           H  
ATOM    608 HG13 ILE A  40      -0.468   9.078  -0.952  1.00  0.00           H  
ATOM    609 HG21 ILE A  40      -1.645   5.992  -2.460  1.00  0.00           H  
ATOM    610 HG22 ILE A  40      -3.096   6.955  -2.734  1.00  0.00           H  
ATOM    611 HG23 ILE A  40      -3.073   5.738  -1.453  1.00  0.00           H  
ATOM    612 HD11 ILE A  40       0.871   7.620  -2.802  1.00  0.00           H  
ATOM    613 HD12 ILE A  40       0.005   6.329  -1.968  1.00  0.00           H  
ATOM    614 HD13 ILE A  40       1.080   7.396  -1.064  1.00  0.00           H  
ATOM    615  N   ASP A  41      -5.386   8.547   0.094  1.00  0.00           N  
ATOM    616  CA  ASP A  41      -6.626   7.924   0.643  1.00  0.00           C  
ATOM    617  C   ASP A  41      -7.532   7.512  -0.518  1.00  0.00           C  
ATOM    618  O   ASP A  41      -8.720   7.775  -0.522  1.00  0.00           O  
ATOM    619  CB  ASP A  41      -7.284   9.018   1.484  1.00  0.00           C  
ATOM    620  CG  ASP A  41      -8.381   8.403   2.354  1.00  0.00           C  
ATOM    621  OD1 ASP A  41      -9.472   8.204   1.846  1.00  0.00           O  
ATOM    622  OD2 ASP A  41      -8.112   8.141   3.515  1.00  0.00           O  
ATOM    623  H   ASP A  41      -5.386   9.494  -0.155  1.00  0.00           H  
ATOM    624  HA  ASP A  41      -6.384   7.072   1.260  1.00  0.00           H  
ATOM    625  HB2 ASP A  41      -6.541   9.484   2.114  1.00  0.00           H  
ATOM    626  HB3 ASP A  41      -7.719   9.761   0.831  1.00  0.00           H  
ATOM    627  N   GLY A  42      -6.963   6.882  -1.511  1.00  0.00           N  
ATOM    628  CA  GLY A  42      -7.752   6.455  -2.699  1.00  0.00           C  
ATOM    629  C   GLY A  42      -8.696   5.316  -2.330  1.00  0.00           C  
ATOM    630  O   GLY A  42      -9.347   5.337  -1.302  1.00  0.00           O  
ATOM    631  H   GLY A  42      -6.002   6.697  -1.481  1.00  0.00           H  
ATOM    632  HA2 GLY A  42      -8.324   7.292  -3.074  1.00  0.00           H  
ATOM    633  HA3 GLY A  42      -7.073   6.111  -3.463  1.00  0.00           H  
ATOM    634  N   GLU A  43      -8.760   4.316  -3.168  1.00  0.00           N  
ATOM    635  CA  GLU A  43      -9.639   3.154  -2.899  1.00  0.00           C  
ATOM    636  C   GLU A  43      -8.772   1.917  -2.711  1.00  0.00           C  
ATOM    637  O   GLU A  43      -8.257   1.357  -3.661  1.00  0.00           O  
ATOM    638  CB  GLU A  43     -10.531   3.019  -4.133  1.00  0.00           C  
ATOM    639  CG  GLU A  43     -11.552   4.159  -4.156  1.00  0.00           C  
ATOM    640  CD  GLU A  43     -12.862   3.660  -4.769  1.00  0.00           C  
ATOM    641  OE1 GLU A  43     -13.576   2.943  -4.090  1.00  0.00           O  
ATOM    642  OE2 GLU A  43     -13.128   4.006  -5.909  1.00  0.00           O  
ATOM    643  H   GLU A  43      -8.219   4.326  -3.971  1.00  0.00           H  
ATOM    644  HA  GLU A  43     -10.227   3.340  -2.027  1.00  0.00           H  
ATOM    645  HB2 GLU A  43      -9.922   3.062  -5.024  1.00  0.00           H  
ATOM    646  HB3 GLU A  43     -11.052   2.074  -4.098  1.00  0.00           H  
ATOM    647  HG2 GLU A  43     -11.732   4.500  -3.146  1.00  0.00           H  
ATOM    648  HG3 GLU A  43     -11.167   4.975  -4.748  1.00  0.00           H  
ATOM    649  N   TRP A  44      -8.576   1.516  -1.488  1.00  0.00           N  
ATOM    650  CA  TRP A  44      -7.707   0.347  -1.214  1.00  0.00           C  
ATOM    651  C   TRP A  44      -8.358  -0.970  -1.617  1.00  0.00           C  
ATOM    652  O   TRP A  44      -9.541  -1.186  -1.447  1.00  0.00           O  
ATOM    653  CB  TRP A  44      -7.443   0.383   0.284  1.00  0.00           C  
ATOM    654  CG  TRP A  44      -6.469   1.476   0.549  1.00  0.00           C  
ATOM    655  CD1 TRP A  44      -6.745   2.796   0.454  1.00  0.00           C  
ATOM    656  CD2 TRP A  44      -5.069   1.371   0.919  1.00  0.00           C  
ATOM    657  NE1 TRP A  44      -5.599   3.510   0.748  1.00  0.00           N  
ATOM    658  CE2 TRP A  44      -4.538   2.675   1.041  1.00  0.00           C  
ATOM    659  CE3 TRP A  44      -4.215   0.281   1.162  1.00  0.00           C  
ATOM    660  CZ2 TRP A  44      -3.208   2.891   1.387  1.00  0.00           C  
ATOM    661  CZ3 TRP A  44      -2.873   0.495   1.513  1.00  0.00           C  
ATOM    662  CH2 TRP A  44      -2.370   1.798   1.624  1.00  0.00           C  
ATOM    663  H   TRP A  44      -8.976   2.006  -0.747  1.00  0.00           H  
ATOM    664  HA  TRP A  44      -6.778   0.468  -1.735  1.00  0.00           H  
ATOM    665  HB2 TRP A  44      -8.365   0.575   0.814  1.00  0.00           H  
ATOM    666  HB3 TRP A  44      -7.025  -0.561   0.602  1.00  0.00           H  
ATOM    667  HD1 TRP A  44      -7.705   3.222   0.192  1.00  0.00           H  
ATOM    668  HE1 TRP A  44      -5.527   4.487   0.754  1.00  0.00           H  
ATOM    669  HE3 TRP A  44      -4.594  -0.727   1.080  1.00  0.00           H  
ATOM    670  HZ2 TRP A  44      -2.827   3.895   1.463  1.00  0.00           H  
ATOM    671  HZ3 TRP A  44      -2.224  -0.349   1.696  1.00  0.00           H  
ATOM    672  HH2 TRP A  44      -1.337   1.957   1.896  1.00  0.00           H  
ATOM    673  N   THR A  45      -7.556  -1.855  -2.131  1.00  0.00           N  
ATOM    674  CA  THR A  45      -8.044  -3.194  -2.547  1.00  0.00           C  
ATOM    675  C   THR A  45      -6.889  -4.179  -2.403  1.00  0.00           C  
ATOM    676  O   THR A  45      -5.774  -3.900  -2.804  1.00  0.00           O  
ATOM    677  CB  THR A  45      -8.468  -3.056  -4.008  1.00  0.00           C  
ATOM    678  OG1 THR A  45      -7.562  -2.200  -4.690  1.00  0.00           O  
ATOM    679  CG2 THR A  45      -9.878  -2.469  -4.079  1.00  0.00           C  
ATOM    680  H   THR A  45      -6.606  -1.640  -2.229  1.00  0.00           H  
ATOM    681  HA  THR A  45      -8.882  -3.499  -1.938  1.00  0.00           H  
ATOM    682  HB  THR A  45      -8.465  -4.030  -4.473  1.00  0.00           H  
ATOM    683  HG1 THR A  45      -7.762  -2.241  -5.628  1.00  0.00           H  
ATOM    684 HG21 THR A  45      -9.863  -1.451  -3.716  1.00  0.00           H  
ATOM    685 HG22 THR A  45     -10.545  -3.059  -3.468  1.00  0.00           H  
ATOM    686 HG23 THR A  45     -10.222  -2.480  -5.103  1.00  0.00           H  
ATOM    687  N   TYR A  46      -7.137  -5.308  -1.808  1.00  0.00           N  
ATOM    688  CA  TYR A  46      -6.047  -6.303  -1.600  1.00  0.00           C  
ATOM    689  C   TYR A  46      -6.165  -7.441  -2.623  1.00  0.00           C  
ATOM    690  O   TYR A  46      -7.063  -8.259  -2.555  1.00  0.00           O  
ATOM    691  CB  TYR A  46      -6.277  -6.791  -0.160  1.00  0.00           C  
ATOM    692  CG  TYR A  46      -5.425  -8.002   0.166  1.00  0.00           C  
ATOM    693  CD1 TYR A  46      -4.052  -7.861   0.397  1.00  0.00           C  
ATOM    694  CD2 TYR A  46      -6.025  -9.263   0.261  1.00  0.00           C  
ATOM    695  CE1 TYR A  46      -3.280  -8.981   0.724  1.00  0.00           C  
ATOM    696  CE2 TYR A  46      -5.253 -10.383   0.583  1.00  0.00           C  
ATOM    697  CZ  TYR A  46      -3.882 -10.244   0.816  1.00  0.00           C  
ATOM    698  OH  TYR A  46      -3.125 -11.351   1.144  1.00  0.00           O  
ATOM    699  H   TYR A  46      -8.039  -5.495  -1.477  1.00  0.00           H  
ATOM    700  HA  TYR A  46      -5.083  -5.815  -1.681  1.00  0.00           H  
ATOM    701  HB2 TYR A  46      -6.030  -5.995   0.525  1.00  0.00           H  
ATOM    702  HB3 TYR A  46      -7.319  -7.049  -0.040  1.00  0.00           H  
ATOM    703  HD1 TYR A  46      -3.585  -6.891   0.324  1.00  0.00           H  
ATOM    704  HD2 TYR A  46      -7.084  -9.372   0.081  1.00  0.00           H  
ATOM    705  HE1 TYR A  46      -2.220  -8.871   0.902  1.00  0.00           H  
ATOM    706  HE2 TYR A  46      -5.717 -11.356   0.653  1.00  0.00           H  
ATOM    707  HH  TYR A  46      -2.819 -11.243   2.047  1.00  0.00           H  
ATOM    708  N   ASP A  47      -5.259  -7.492  -3.566  1.00  0.00           N  
ATOM    709  CA  ASP A  47      -5.303  -8.570  -4.598  1.00  0.00           C  
ATOM    710  C   ASP A  47      -4.662  -9.849  -4.052  1.00  0.00           C  
ATOM    711  O   ASP A  47      -3.461  -9.921  -3.867  1.00  0.00           O  
ATOM    712  CB  ASP A  47      -4.495  -8.026  -5.777  1.00  0.00           C  
ATOM    713  CG  ASP A  47      -5.438  -7.348  -6.773  1.00  0.00           C  
ATOM    714  OD1 ASP A  47      -6.344  -8.015  -7.247  1.00  0.00           O  
ATOM    715  OD2 ASP A  47      -5.240  -6.176  -7.043  1.00  0.00           O  
ATOM    716  H   ASP A  47      -4.547  -6.820  -3.594  1.00  0.00           H  
ATOM    717  HA  ASP A  47      -6.320  -8.759  -4.903  1.00  0.00           H  
ATOM    718  HB2 ASP A  47      -3.774  -7.307  -5.417  1.00  0.00           H  
ATOM    719  HB3 ASP A  47      -3.981  -8.838  -6.267  1.00  0.00           H  
ATOM    720  N   ASP A  48      -5.460 -10.853  -3.790  1.00  0.00           N  
ATOM    721  CA  ASP A  48      -4.910 -12.135  -3.250  1.00  0.00           C  
ATOM    722  C   ASP A  48      -4.044 -12.842  -4.302  1.00  0.00           C  
ATOM    723  O   ASP A  48      -3.225 -13.680  -3.975  1.00  0.00           O  
ATOM    724  CB  ASP A  48      -6.139 -12.982  -2.901  1.00  0.00           C  
ATOM    725  CG  ASP A  48      -6.992 -13.212  -4.153  1.00  0.00           C  
ATOM    726  OD1 ASP A  48      -7.856 -12.392  -4.416  1.00  0.00           O  
ATOM    727  OD2 ASP A  48      -6.768 -14.205  -4.825  1.00  0.00           O  
ATOM    728  H   ASP A  48      -6.423 -10.762  -3.946  1.00  0.00           H  
ATOM    729  HA  ASP A  48      -4.333 -11.946  -2.360  1.00  0.00           H  
ATOM    730  HB2 ASP A  48      -5.818 -13.934  -2.504  1.00  0.00           H  
ATOM    731  HB3 ASP A  48      -6.729 -12.464  -2.159  1.00  0.00           H  
ATOM    732  N   ALA A  49      -4.220 -12.518  -5.564  1.00  0.00           N  
ATOM    733  CA  ALA A  49      -3.412 -13.175  -6.639  1.00  0.00           C  
ATOM    734  C   ALA A  49      -1.912 -13.060  -6.341  1.00  0.00           C  
ATOM    735  O   ALA A  49      -1.164 -14.005  -6.512  1.00  0.00           O  
ATOM    736  CB  ALA A  49      -3.758 -12.420  -7.924  1.00  0.00           C  
ATOM    737  H   ALA A  49      -4.887 -11.847  -5.805  1.00  0.00           H  
ATOM    738  HA  ALA A  49      -3.698 -14.206  -6.734  1.00  0.00           H  
ATOM    739  HB1 ALA A  49      -3.523 -11.373  -7.801  1.00  0.00           H  
ATOM    740  HB2 ALA A  49      -4.811 -12.530  -8.134  1.00  0.00           H  
ATOM    741  HB3 ALA A  49      -3.184 -12.825  -8.745  1.00  0.00           H  
ATOM    742  N   THR A  50      -1.472 -11.910  -5.899  1.00  0.00           N  
ATOM    743  CA  THR A  50      -0.021 -11.724  -5.589  1.00  0.00           C  
ATOM    744  C   THR A  50       0.159 -10.866  -4.330  1.00  0.00           C  
ATOM    745  O   THR A  50       1.220 -10.322  -4.091  1.00  0.00           O  
ATOM    746  CB  THR A  50       0.556 -11.007  -6.812  1.00  0.00           C  
ATOM    747  OG1 THR A  50      -0.113  -9.767  -6.990  1.00  0.00           O  
ATOM    748  CG2 THR A  50       0.367 -11.876  -8.057  1.00  0.00           C  
ATOM    749  H   THR A  50      -2.097 -11.165  -5.772  1.00  0.00           H  
ATOM    750  HA  THR A  50       0.460 -12.681  -5.463  1.00  0.00           H  
ATOM    751  HB  THR A  50       1.610 -10.830  -6.659  1.00  0.00           H  
ATOM    752  HG1 THR A  50       0.545  -9.069  -6.968  1.00  0.00           H  
ATOM    753 HG21 THR A  50       0.824 -11.392  -8.907  1.00  0.00           H  
ATOM    754 HG22 THR A  50      -0.689 -12.009  -8.245  1.00  0.00           H  
ATOM    755 HG23 THR A  50       0.829 -12.839  -7.898  1.00  0.00           H  
ATOM    756  N   LYS A  51      -0.867 -10.741  -3.517  1.00  0.00           N  
ATOM    757  CA  LYS A  51      -0.761  -9.921  -2.263  1.00  0.00           C  
ATOM    758  C   LYS A  51      -0.186  -8.530  -2.559  1.00  0.00           C  
ATOM    759  O   LYS A  51       1.015  -8.328  -2.523  1.00  0.00           O  
ATOM    760  CB  LYS A  51       0.183 -10.709  -1.345  1.00  0.00           C  
ATOM    761  CG  LYS A  51      -0.583 -11.185  -0.110  1.00  0.00           C  
ATOM    762  CD  LYS A  51      -1.206 -12.554  -0.393  1.00  0.00           C  
ATOM    763  CE  LYS A  51      -1.169 -13.406   0.878  1.00  0.00           C  
ATOM    764  NZ  LYS A  51       0.190 -14.017   0.889  1.00  0.00           N  
ATOM    765  H   LYS A  51      -1.712 -11.192  -3.725  1.00  0.00           H  
ATOM    766  HA  LYS A  51      -1.731  -9.827  -1.800  1.00  0.00           H  
ATOM    767  HB2 LYS A  51       0.575 -11.564  -1.877  1.00  0.00           H  
ATOM    768  HB3 LYS A  51       1.001 -10.075  -1.035  1.00  0.00           H  
ATOM    769  HG2 LYS A  51       0.096 -11.259   0.728  1.00  0.00           H  
ATOM    770  HG3 LYS A  51      -1.364 -10.474   0.120  1.00  0.00           H  
ATOM    771  HD2 LYS A  51      -2.231 -12.424  -0.710  1.00  0.00           H  
ATOM    772  HD3 LYS A  51      -0.648 -13.050  -1.173  1.00  0.00           H  
ATOM    773  HE2 LYS A  51      -1.312 -12.783   1.751  1.00  0.00           H  
ATOM    774  HE3 LYS A  51      -1.921 -14.179   0.837  1.00  0.00           H  
ATOM    775  HZ1 LYS A  51       0.328 -14.538   1.777  1.00  0.00           H  
ATOM    776  HZ2 LYS A  51       0.907 -13.266   0.811  1.00  0.00           H  
ATOM    777  HZ3 LYS A  51       0.283 -14.671   0.087  1.00  0.00           H  
ATOM    778  N   THR A  52      -1.032  -7.573  -2.845  1.00  0.00           N  
ATOM    779  CA  THR A  52      -0.529  -6.199  -3.138  1.00  0.00           C  
ATOM    780  C   THR A  52      -1.617  -5.155  -2.875  1.00  0.00           C  
ATOM    781  O   THR A  52      -2.570  -5.039  -3.622  1.00  0.00           O  
ATOM    782  CB  THR A  52      -0.160  -6.220  -4.622  1.00  0.00           C  
ATOM    783  OG1 THR A  52       0.767  -7.268  -4.862  1.00  0.00           O  
ATOM    784  CG2 THR A  52       0.468  -4.881  -5.013  1.00  0.00           C  
ATOM    785  H   THR A  52      -1.994  -7.759  -2.864  1.00  0.00           H  
ATOM    786  HA  THR A  52       0.346  -5.987  -2.546  1.00  0.00           H  
ATOM    787  HB  THR A  52      -1.048  -6.382  -5.212  1.00  0.00           H  
ATOM    788  HG1 THR A  52       0.804  -7.421  -5.809  1.00  0.00           H  
ATOM    789 HG21 THR A  52       0.664  -4.872  -6.075  1.00  0.00           H  
ATOM    790 HG22 THR A  52       1.392  -4.745  -4.473  1.00  0.00           H  
ATOM    791 HG23 THR A  52      -0.213  -4.079  -4.766  1.00  0.00           H  
ATOM    792  N   PHE A  53      -1.469  -4.379  -1.828  1.00  0.00           N  
ATOM    793  CA  PHE A  53      -2.484  -3.318  -1.525  1.00  0.00           C  
ATOM    794  C   PHE A  53      -2.549  -2.341  -2.701  1.00  0.00           C  
ATOM    795  O   PHE A  53      -1.543  -1.787  -3.104  1.00  0.00           O  
ATOM    796  CB  PHE A  53      -1.973  -2.611  -0.268  1.00  0.00           C  
ATOM    797  CG  PHE A  53      -2.051  -3.547   0.915  1.00  0.00           C  
ATOM    798  CD1 PHE A  53      -3.211  -3.588   1.698  1.00  0.00           C  
ATOM    799  CD2 PHE A  53      -0.963  -4.370   1.232  1.00  0.00           C  
ATOM    800  CE1 PHE A  53      -3.283  -4.450   2.798  1.00  0.00           C  
ATOM    801  CE2 PHE A  53      -1.036  -5.233   2.332  1.00  0.00           C  
ATOM    802  CZ  PHE A  53      -2.196  -5.273   3.115  1.00  0.00           C  
ATOM    803  H   PHE A  53      -0.683  -4.484  -1.252  1.00  0.00           H  
ATOM    804  HA  PHE A  53      -3.452  -3.759  -1.340  1.00  0.00           H  
ATOM    805  HB2 PHE A  53      -0.946  -2.309  -0.419  1.00  0.00           H  
ATOM    806  HB3 PHE A  53      -2.580  -1.739  -0.075  1.00  0.00           H  
ATOM    807  HD1 PHE A  53      -4.050  -2.953   1.453  1.00  0.00           H  
ATOM    808  HD2 PHE A  53      -0.069  -4.340   0.629  1.00  0.00           H  
ATOM    809  HE1 PHE A  53      -4.178  -4.481   3.402  1.00  0.00           H  
ATOM    810  HE2 PHE A  53      -0.195  -5.868   2.575  1.00  0.00           H  
ATOM    811  HZ  PHE A  53      -2.252  -5.937   3.965  1.00  0.00           H  
ATOM    812  N   THR A  54      -3.705  -2.153  -3.281  1.00  0.00           N  
ATOM    813  CA  THR A  54      -3.790  -1.236  -4.464  1.00  0.00           C  
ATOM    814  C   THR A  54      -4.655   0.007  -4.195  1.00  0.00           C  
ATOM    815  O   THR A  54      -5.856  -0.016  -4.390  1.00  0.00           O  
ATOM    816  CB  THR A  54      -4.419  -2.095  -5.563  1.00  0.00           C  
ATOM    817  OG1 THR A  54      -3.648  -3.276  -5.736  1.00  0.00           O  
ATOM    818  CG2 THR A  54      -4.456  -1.312  -6.878  1.00  0.00           C  
ATOM    819  H   THR A  54      -4.502  -2.639  -2.964  1.00  0.00           H  
ATOM    820  HA  THR A  54      -2.799  -0.939  -4.770  1.00  0.00           H  
ATOM    821  HB  THR A  54      -5.423  -2.362  -5.281  1.00  0.00           H  
ATOM    822  HG1 THR A  54      -2.743  -3.014  -5.925  1.00  0.00           H  
ATOM    823 HG21 THR A  54      -5.247  -1.698  -7.504  1.00  0.00           H  
ATOM    824 HG22 THR A  54      -3.509  -1.420  -7.387  1.00  0.00           H  
ATOM    825 HG23 THR A  54      -4.637  -0.268  -6.671  1.00  0.00           H  
ATOM    826  N   VAL A  55      -4.047   1.108  -3.797  1.00  0.00           N  
ATOM    827  CA  VAL A  55      -4.830   2.357  -3.577  1.00  0.00           C  
ATOM    828  C   VAL A  55      -4.760   3.224  -4.842  1.00  0.00           C  
ATOM    829  O   VAL A  55      -3.954   2.986  -5.724  1.00  0.00           O  
ATOM    830  CB  VAL A  55      -4.208   3.091  -2.370  1.00  0.00           C  
ATOM    831  CG1 VAL A  55      -2.804   3.593  -2.700  1.00  0.00           C  
ATOM    832  CG2 VAL A  55      -5.082   4.293  -2.006  1.00  0.00           C  
ATOM    833  H   VAL A  55      -3.087   1.117  -3.678  1.00  0.00           H  
ATOM    834  HA  VAL A  55      -5.846   2.101  -3.362  1.00  0.00           H  
ATOM    835  HB  VAL A  55      -4.157   2.430  -1.529  1.00  0.00           H  
ATOM    836 HG11 VAL A  55      -2.885   4.410  -3.405  1.00  0.00           H  
ATOM    837 HG12 VAL A  55      -2.224   2.795  -3.135  1.00  0.00           H  
ATOM    838 HG13 VAL A  55      -2.324   3.942  -1.794  1.00  0.00           H  
ATOM    839 HG21 VAL A  55      -5.005   5.042  -2.779  1.00  0.00           H  
ATOM    840 HG22 VAL A  55      -4.747   4.710  -1.068  1.00  0.00           H  
ATOM    841 HG23 VAL A  55      -6.110   3.975  -1.912  1.00  0.00           H  
ATOM    842  N   THR A  56      -5.594   4.220  -4.928  1.00  0.00           N  
ATOM    843  CA  THR A  56      -5.597   5.105  -6.126  1.00  0.00           C  
ATOM    844  C   THR A  56      -6.280   6.435  -5.788  1.00  0.00           C  
ATOM    845  O   THR A  56      -7.485   6.496  -5.622  1.00  0.00           O  
ATOM    846  CB  THR A  56      -6.410   4.327  -7.160  1.00  0.00           C  
ATOM    847  OG1 THR A  56      -5.752   3.101  -7.445  1.00  0.00           O  
ATOM    848  CG2 THR A  56      -6.555   5.142  -8.451  1.00  0.00           C  
ATOM    849  H   THR A  56      -6.223   4.385  -4.205  1.00  0.00           H  
ATOM    850  HA  THR A  56      -4.594   5.269  -6.484  1.00  0.00           H  
ATOM    851  HB  THR A  56      -7.388   4.122  -6.754  1.00  0.00           H  
ATOM    852  HG1 THR A  56      -6.180   2.409  -6.934  1.00  0.00           H  
ATOM    853 HG21 THR A  56      -6.219   6.155  -8.282  1.00  0.00           H  
ATOM    854 HG22 THR A  56      -7.590   5.152  -8.755  1.00  0.00           H  
ATOM    855 HG23 THR A  56      -5.956   4.691  -9.229  1.00  0.00           H  
ATOM    856  N   GLU A  57      -5.519   7.492  -5.684  1.00  0.00           N  
ATOM    857  CA  GLU A  57      -6.113   8.822  -5.356  1.00  0.00           C  
ATOM    858  C   GLU A  57      -5.838   9.817  -6.486  1.00  0.00           C  
ATOM    859  O   GLU A  57      -6.708   9.987  -7.323  1.00  0.00           O  
ATOM    860  CB  GLU A  57      -5.411   9.259  -4.070  1.00  0.00           C  
ATOM    861  CG  GLU A  57      -6.184  10.417  -3.435  1.00  0.00           C  
ATOM    862  CD  GLU A  57      -5.627  11.746  -3.949  1.00  0.00           C  
ATOM    863  OE1 GLU A  57      -4.507  12.073  -3.594  1.00  0.00           O  
ATOM    864  OE2 GLU A  57      -6.330  12.412  -4.691  1.00  0.00           O  
ATOM    865  OXT GLU A  57      -4.762  10.392  -6.494  1.00  0.00           O  
ATOM    866  H   GLU A  57      -4.552   7.410  -5.822  1.00  0.00           H  
ATOM    867  HA  GLU A  57      -7.174   8.728  -5.185  1.00  0.00           H  
ATOM    868  HB2 GLU A  57      -5.374   8.429  -3.380  1.00  0.00           H  
ATOM    869  HB3 GLU A  57      -4.407   9.582  -4.299  1.00  0.00           H  
ATOM    870  HG2 GLU A  57      -7.230  10.338  -3.696  1.00  0.00           H  
ATOM    871  HG3 GLU A  57      -6.076  10.377  -2.362  1.00  0.00           H  
TER     872      GLU A  57                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
