
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   60 (  466),  selected   60 , name 1uwx_B
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1uwx_B.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     5_B      -       -           -
LGA    T     6_B      T       1          1.320
LGA    T     7_B      T       2          1.165
LGA    Y     8_B      Y       3          0.652
LGA    K     9_B      K       4          0.485
LGA    L    10_B      L       5          0.562
LGA    V    11_B      I       6          0.868
LGA    I    12_B      L       7          0.957
LGA    N    13_B      N       8          1.194
LGA    G    14_B      L       9          1.073
LGA    K    15_B      K      10          0.912
LGA    T    16_B      Q      11          2.569
LGA    L    17_B      A      12          2.807
LGA    K    18_B      K      13          0.695
LGA    G    19_B      E      14          2.747
LGA    E    20_B      E      15          1.301
LGA    T    21_B      A      16          2.394
LGA    T    22_B      I      17          1.024
LGA    T    23_B      K      18          0.516
LGA    K    24_B      E      19          0.894
LGA    A    25_B      A      20          1.326
LGA    V    26_B      V      21          1.900
LGA    D    27_B      D      22          1.112
LGA    A    28_B      A      23          1.792
LGA    A    29_B      G      24          2.686
LGA    T    30_B      T      25          2.061
LGA    A    31_B      A      26          0.358
LGA    E    32_B      E      27          0.942
LGA    K    33_B      K      28          1.079
LGA    V    34_B      Y      29          0.766
LGA    F    35_B      F      30          0.749
LGA    K    36_B      K      31          1.108
LGA    Q    37_B      L      32          1.110
LGA    Y    38_B      I      33          0.576
LGA    A    39_B      A      34          1.167
LGA    N    40_B      N      35          1.012
LGA    D    41_B      A      36          0.916
LGA    N    42_B      K      37          1.208
LGA    G    43_B      T      38          2.511
LGA    V    44_B      V      39          3.357
LGA    D    45_B      E      40          1.706
LGA    G    46_B      G      41          1.537
LGA    E    47_B      V      42          1.631
LGA    W    48_B      W      43          0.668
LGA    T    49_B      T      44          0.769
LGA    Y    50_B      Y      45          0.997
LGA    D    51_B      K      46          1.712
LGA    D    52_B      D      47          2.708
LGA    A    53_B      E      48          0.988
LGA    T    54_B      I      49          2.099
LGA    K    55_B      K      50          1.086
LGA    T    56_B      T      51          1.065
LGA    F    57_B      F      52          0.622
LGA    T    58_B      T      53          0.593
LGA    V    59_B      V      54          0.751
LGA    T    60_B      T      55          0.825
LGA    E    61_B      E      56          0.743
LGA    K    62_B      -       -           -
LGA    P    63_B      -       -           -
LGA    E    64_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   60   56    5.0     56    1.47    60.71     92.998     3.563

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.393168 * X  +  -0.398807 * Y  +  -0.828476 * Z  +  67.258171
  Y_new =  -0.189739 * X  +  -0.846456 * Y  +   0.497506 * Z  +   9.235137
  Z_new =  -0.899677 * X  +   0.352797 * Y  +   0.257130 * Z  +  70.693779 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.940980   -2.200613  [ DEG:    53.9142   -126.0858 ]
  Theta =   1.119028    2.022564  [ DEG:    64.1156    115.8844 ]
  Phi   =  -2.691971    0.449622  [ DEG:  -154.2386     25.7614 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1uwx_B                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1uwx_B.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   60   56   5.0   56   1.47   60.71  92.998
REMARK  ---------------------------------------------------------- 
MOLECULE 1uwx_B
HEADER    ANTIBODY/COMPLEX                        12-FEB-04   1UWX              
TITLE     P1.2 SEROSUBTYPE ANTIGEN DERIVED FROM N. MENINGITIDIS PORA            
TITLE    2 IN COMPLEX WITH FAB FRAGMENT                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN G-PRIME;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 56-118 (DOMAIN II);                               
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: ANTIBODY;                                                  
COMPND   8 CHAIN: H, M;                                                         
COMPND   9 FRAGMENT: RESIDUES 1-215 (FAB FRAGMENT, HEAVY CHAIN);                
COMPND  10 MOL_ID: 3;                                                           
COMPND  11 MOLECULE: ANTIBODY;                                                  
COMPND  12 CHAIN: K, L;                                                         
COMPND  13 FRAGMENT: RESIDUES 3-214 (FAB FRAGMENT, LIGHT CHAIN);                
COMPND  14 MOL_ID: 4;                                                           
COMPND  15 MOLECULE: CLASS 1 OUTER MEMBRANE PROTEIN VARIABLE REGION 2;          
COMPND  16 CHAIN: P, Q;                                                         
COMPND  17 FRAGMENT: RESIDUES 16-28;                                            
COMPND  18 OTHER_DETAILS: RAISED AGAINST THE P1.2 SEROSUBTYPE ANTIGEN           
COMPND  19 SEQUENCE FROM THE PORA PROTEIN FROM NEISSERI MENINGITIDIS            
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP.;                              
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 OTHER_DETAILS: HYBRIDOMA;                                            
SOURCE   5 MOL_ID: 2;                                                           
SOURCE   6 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   7 ORGANISM_COMMON: MOUSE;                                              
SOURCE   8 MOL_ID: 3;                                                           
SOURCE   9 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE  10 ORGANISM_COMMON: MOUSE;                                              
SOURCE  11 OTHER_DETAILS: HYBRIDOMA;                                            
SOURCE  12 MOL_ID: 4;                                                           
SOURCE  13 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS                          
KEYWDS    FAB, IMMUNOGLOBULIN, PROTEIN G, PORA, ANTIBODY, IGB,                  
KEYWDS   2 ANTIBODY/COMPLEX                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.TZITZILONIS,S.M.PRINCE,R.F.COLLINS,M.C.J.MAIDEN,                    
AUTHOR   2 I.M.FEAVERS,J.P.DERRICK                                              
REVDAT   2   15-FEB-06 1UWX    1       JRNL                                     
REVDAT   1   15-JUN-05 1UWX    0                                                
JRNL        AUTH   C.TZITZILONIS,S.M.PRINCE,R.F.COLLINS,M.ACHTMAN,              
JRNL        AUTH 2 I.M.FEAVERS,M.C.MAIDEN,J.P.DERRICK                           
JRNL        TITL   STRUCTURAL VARIATION AND IMMUNE RECOGNITION OF THE           
JRNL        TITL 2 P1.2 SUBTYPE MENINGOCOCCAL ANTIGEN.                          
JRNL        REF    PROTEINS                      V.  62   947 2006              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  1UWX A    2    64  UNP    Q54181   Q54181          56    118             
DBREF  1UWX B    2    64  UNP    Q54181   Q54181          56    118             
DBREF  1UWX H    1   215  PDB    1UWX     1UWX             1    215             
DBREF  1UWX K    3   214  PDB    1UWX     1UWX             3    214             
DBREF  1UWX L    3   214  PDB    1UWX     1UWX             3    214             
DBREF  1UWX M    1   215  PDB    1UWX     1UWX             1    215             
DBREF  1UWX P    1    13  UNP    Q51220   Q51220_NEIME    16     28             
DBREF  1UWX Q    1    13  UNP    Q51220   Q51220_NEIME    16     28             
SEQRES   1 A   63  THR PRO ALA VAL THR THR TYR LYS LEU VAL ILE ASN GLY          
SEQRES   2 A   63  LYS THR LEU LYS GLY GLU THR THR THR LYS ALA VAL ASP          
SEQRES   3 A   63  ALA ALA THR ALA GLU LYS VAL PHE LYS GLN TYR ALA ASN          
SEQRES   4 A   63  ASP ASN GLY VAL ASP GLY GLU TRP THR TYR ASP ASP ALA          
SEQRES   5 A   63  THR LYS THR PHE THR VAL THR GLU LYS PRO GLU                  
SEQRES   1 B   63  THR PRO ALA VAL THR THR TYR LYS LEU VAL ILE ASN GLY          
SEQRES   2 B   63  LYS THR LEU LYS GLY GLU THR THR THR LYS ALA VAL ASP          
SEQRES   3 B   63  ALA ALA THR ALA GLU LYS VAL PHE LYS GLN TYR ALA ASN          
SEQRES   4 B   63  ASP ASN GLY VAL ASP GLY GLU TRP THR TYR ASP ASP ALA          
SEQRES   5 B   63  THR LYS THR PHE THR VAL THR GLU LYS PRO GLU                  
SEQRES   1 H  225  ASP VAL GLN LEU GLN GLN SER GLY PRO GLU LEU LYS LYS          
SEQRES   2 H  225  PRO GLY GLU THR VAL LYS LEU SER CYS LYS ALA SER GLY          
SEQRES   3 H  225  TYR THR PHE THR ASN PHE GLY LEU ASN TRP MET LYS GLN          
SEQRES   4 H  225  ALA PRO GLY LYS GLY LEU LYS TRP MET GLY TRP ILE ASN          
SEQRES   5 H  225  THR TYR THR GLY GLU SER THR TYR ALA ASP ASP PHE LYS          
SEQRES   6 H  225  GLY ARG PHE ALA PHE SER LEU GLU THR SER ALA SER THR          
SEQRES   7 H  225  ALA TYR LEU GLN ILE ASN ASN VAL LYS ASN GLU ASP THR          
SEQRES   8 H  225  ALA THR TYR PHE CYS ALA ARG GLY PHE TYR TYR TYR GLY          
SEQRES   9 H  225  SER ARG TYR PHE TYR PHE ASP TYR TRP GLY GLN GLY THR          
SEQRES  10 H  225  THR LEU THR VAL SER SER ALA LYS THR THR ALA PRO SER          
SEQRES  11 H  225  VAL TYR PRO LEU ALA PRO VAL CYS GLY ASP THR THR GLY          
SEQRES  12 H  225  SER SER VAL THR LEU GLY CYS LEU VAL LYS GLY TYR PHE          
SEQRES  13 H  225  PRO GLU PRO VAL THR LEU THR TRP ASN SER GLY SER LEU          
SEQRES  14 H  225  SER SER GLY VAL HIS THR PHE PRO ALA VAL LEU GLN SER          
SEQRES  15 H  225  ASP LEU TYR THR LEU SER SER SER VAL THR VAL THR SER          
SEQRES  16 H  225  SER THR TRP PRO SER GLN SER ILE THR CYS ASN VAL ALA          
SEQRES  17 H  225  HIS PRO ALA SER SER THR LYS VAL ASP LYS LYS ILE GLU          
SEQRES  18 H  225  PRO ARG GLY PRO                                              
SEQRES   1 K  213  GLY ILE VAL MET THR GLN THR PRO ALA SER GLN SER ALA          
SEQRES   2 K  213  SER LEU GLY GLU SER VAL THR ILE THR CYS LEU ALA SER          
SEQRES   3 K  213  GLN THR ILE GLY THR TRP LEU ALA TRP TYR GLN GLN LYS          
SEQRES   4 K  213  PRO GLY LYS SER PRO GLN LEU LEU ILE TYR ALA ALA THR          
SEQRES   5 K  213  SER LEU ALA ASP GLY VAL PRO SER ARG PHE SER GLY SER          
SEQRES   6 K  213  GLY SER GLY THR LYS PHE SER PHE LYS ILE SER SER LEU          
SEQRES   7 K  213  GLN ALA GLU ASP PHE VAL SER TYR TYR CYS GLN GLN LEU          
SEQRES   8 K  213  SER SER THR PRO TYR THR PHE GLY GLY GLY THR LYS LEU          
SEQRES   9 K  213  GLU ILE LYS ARG ALA ASP ALA ALA PRO THR VAL SER ILE          
SEQRES  10 K  213  PHE PRO PRO SER SER GLU GLN LEU THR SER GLY GLY ALA          
SEQRES  11 K  213  SER VAL VAL CYS PHE LEU ASN ASN PHE TYR PRO LYS ASP          
SEQRES  12 K  213  ILE ASN VAL LYS TRP LYS ILE ASP GLY LYS GLU ARG GLN          
SEQRES  13 K  213  ASN GLY VAL LEU ASN SER TRP THR ASP GLN ASP SER LYS          
SEQRES  14 K  213  ASP SER THR TYR SER MET SER SER THR LEU THR LEU THR          
SEQRES  15 K  213  LYS ASP GLU TYR GLU ARG HIS ASN SER TYR THR CYS GLU          
SEQRES  16 K  213  ALA THR HIS LYS THR SER THR SER PRO ILE VAL LYS SER          
SEQRES  17 K  213  PHE ASN ARG ASN GLU                                          
SEQRES   1 L  213  GLY ILE VAL MET THR GLN THR PRO ALA SER GLN SER ALA          
SEQRES   2 L  213  SER LEU GLY GLU SER VAL THR ILE THR CYS LEU ALA SER          
SEQRES   3 L  213  GLN THR ILE GLY THR TRP LEU ALA TRP TYR GLN GLN LYS          
SEQRES   4 L  213  PRO GLY LYS SER PRO GLN LEU LEU ILE TYR ALA ALA THR          
SEQRES   5 L  213  SER LEU ALA ASP GLY VAL PRO SER ARG PHE SER GLY SER          
SEQRES   6 L  213  GLY SER GLY THR LYS PHE SER PHE LYS ILE SER SER LEU          
SEQRES   7 L  213  GLN ALA GLU ASP PHE VAL SER TYR TYR CYS GLN GLN LEU          
SEQRES   8 L  213  SER SER THR PRO TYR THR PHE GLY GLY GLY THR LYS LEU          
SEQRES   9 L  213  GLU ILE LYS ARG ALA ASP ALA ALA PRO THR VAL SER ILE          
SEQRES  10 L  213  PHE PRO PRO SER SER GLU GLN LEU THR SER GLY GLY ALA          
SEQRES  11 L  213  SER VAL VAL CYS PHE LEU ASN ASN PHE TYR PRO LYS ASP          
SEQRES  12 L  213  ILE ASN VAL LYS TRP LYS ILE ASP GLY LYS GLU ARG GLN          
SEQRES  13 L  213  ASN GLY VAL LEU ASN SER TRP THR ASP GLN ASP SER LYS          
SEQRES  14 L  213  ASP SER THR TYR SER MET SER SER THR LEU THR LEU THR          
SEQRES  15 L  213  LYS ASP GLU TYR GLU ARG HIS ASN SER TYR THR CYS GLU          
SEQRES  16 L  213  ALA THR HIS LYS THR SER THR SER PRO ILE VAL LYS SER          
SEQRES  17 L  213  PHE ASN ARG ASN GLU                                          
SEQRES   1 M  225  ASP VAL GLN LEU GLN GLN SER GLY PRO GLU LEU LYS LYS          
SEQRES   2 M  225  PRO GLY GLU THR VAL LYS LEU SER CYS LYS ALA SER GLY          
SEQRES   3 M  225  TYR THR PHE THR ASN PHE GLY LEU ASN TRP MET LYS GLN          
SEQRES   4 M  225  ALA PRO GLY LYS GLY LEU LYS TRP MET GLY TRP ILE ASN          
SEQRES   5 M  225  THR TYR THR GLY GLU SER THR TYR ALA ASP ASP PHE LYS          
SEQRES   6 M  225  GLY ARG PHE ALA PHE SER LEU GLU THR SER ALA SER THR          
SEQRES   7 M  225  ALA TYR LEU GLN ILE ASN ASN VAL LYS ASN GLU ASP THR          
SEQRES   8 M  225  ALA THR TYR PHE CYS ALA ARG GLY PHE TYR TYR TYR GLY          
SEQRES   9 M  225  SER ARG TYR PHE TYR PHE ASP TYR TRP GLY GLN GLY THR          
SEQRES  10 M  225  THR LEU THR VAL SER SER ALA LYS THR THR ALA PRO SER          
SEQRES  11 M  225  VAL TYR PRO LEU ALA PRO VAL CYS GLY ASP THR THR GLY          
SEQRES  12 M  225  SER SER VAL THR LEU GLY CYS LEU VAL LYS GLY TYR PHE          
SEQRES  13 M  225  PRO GLU PRO VAL THR LEU THR TRP ASN SER GLY SER LEU          
SEQRES  14 M  225  SER SER GLY VAL HIS THR PHE PRO ALA VAL LEU GLN SER          
SEQRES  15 M  225  ASP LEU TYR THR LEU SER SER SER VAL THR VAL THR SER          
SEQRES  16 M  225  SER THR TRP PRO SER GLN SER ILE THR CYS ASN VAL ALA          
SEQRES  17 M  225  HIS PRO ALA SER SER THR LYS VAL ASP LYS LYS ILE GLU          
SEQRES  18 M  225  PRO ARG GLY PRO                                              
SEQRES   1 P   13  HIS PHE VAL GLN GLN THR PRO LYS SER GLN PRO THR LEU          
SEQRES   1 Q   13  HIS PHE VAL GLN GLN THR PRO LYS SER GLN PRO THR LEU          
FORMUL   9  HOH   *395(H2 O)                                                    
CRYST1   81.426  110.568  138.734  90.00  90.00  90.00 P 21 21 21    8          
ATOM    443  N   VAL B   5       7.128 -14.557   8.322  1.00 24.87           N  
ATOM    444  CA  VAL B   5       6.966 -13.287   7.521  1.00 25.82           C  
ATOM    445  C   VAL B   5       6.928 -13.520   6.001  1.00 25.42           C  
ATOM    446  O   VAL B   5       7.377 -14.577   5.500  1.00 26.42           O  
ATOM    447  CB  VAL B   5       7.989 -12.163   7.889  1.00 25.71           C  
ATOM    448  CG1 VAL B   5       8.177 -12.080   9.412  1.00 26.89           C  
ATOM    449  CG2 VAL B   5       9.326 -12.335   7.141  1.00 26.13           C  
ATOM    450  N   THR B   6       6.328 -12.556   5.298  1.00 23.99           N  
ATOM    451  CA  THR B   6       6.202 -12.581   3.844  1.00 22.60           C  
ATOM    452  C   THR B   6       6.232 -11.137   3.301  1.00 21.25           C  
ATOM    453  O   THR B   6       5.926 -10.180   4.036  1.00 20.63           O  
ATOM    454  CB  THR B   6       4.965 -13.478   3.369  1.00 22.99           C  
ATOM    455  OG1 THR B   6       3.935 -12.695   2.770  1.00 23.59           O  
ATOM    456  CG2 THR B   6       4.228 -14.163   4.548  1.00 23.95           C  
ATOM    457  N   THR B   7       6.667 -10.978   2.049  1.00 20.04           N  
ATOM    458  CA  THR B   7       6.767  -9.664   1.417  1.00 18.80           C  
ATOM    459  C   THR B   7       5.408  -9.248   0.900  1.00 18.37           C  
ATOM    460  O   THR B   7       4.833  -9.950   0.069  1.00 18.40           O  
ATOM    461  CB  THR B   7       7.789  -9.693   0.254  1.00 18.96           C  
ATOM    462  OG1 THR B   7       9.082 -10.032   0.762  1.00 19.14           O  
ATOM    463  CG2 THR B   7       8.019  -8.275  -0.297  1.00 17.46           C  
ATOM    464  N   TYR B   8       4.881  -8.125   1.393  1.00 17.56           N  
ATOM    465  CA  TYR B   8       3.689  -7.534   0.780  1.00 17.23           C  
ATOM    466  C   TYR B   8       4.055  -6.312  -0.075  1.00 17.56           C  
ATOM    467  O   TYR B   8       5.062  -5.641   0.176  1.00 17.02           O  
ATOM    468  CB  TYR B   8       2.598  -7.245   1.830  1.00 17.11           C  
ATOM    469  CG  TYR B   8       2.094  -8.506   2.513  1.00 16.33           C  
ATOM    470  CD1 TYR B   8       0.979  -9.186   2.038  1.00 15.14           C  
ATOM    471  CD2 TYR B   8       2.751  -9.030   3.639  1.00 16.96           C  
ATOM    472  CE1 TYR B   8       0.514 -10.380   2.676  1.00 13.81           C  
ATOM    473  CE2 TYR B   8       2.311 -10.201   4.263  1.00 15.79           C  
ATOM    474  CZ  TYR B   8       1.191 -10.869   3.779  1.00 16.54           C  
ATOM    475  OH  TYR B   8       0.773 -12.041   4.409  1.00 18.62           O  
ATOM    476  N   LYS B   9       3.261  -6.038  -1.109  1.00 18.26           N  
ATOM    477  CA  LYS B   9       3.496  -4.879  -1.985  1.00 18.61           C  
ATOM    478  C   LYS B   9       2.346  -3.885  -1.939  1.00 18.12           C  
ATOM    479  O   LYS B   9       1.185  -4.270  -1.819  1.00 18.06           O  
ATOM    480  CB  LYS B   9       3.710  -5.317  -3.444  1.00 19.25           C  
ATOM    481  CG  LYS B   9       4.898  -6.289  -3.651  1.00 23.68           C  
ATOM    482  CD  LYS B   9       4.724  -7.183  -4.943  1.00 28.68           C  
ATOM    483  CE  LYS B   9       6.047  -7.761  -5.475  1.00 29.14           C  
ATOM    484  NZ  LYS B   9       6.942  -6.726  -6.153  1.00 30.73           N  
ATOM    485  N   LEU B  10       2.693  -2.605  -2.033  1.00 18.03           N  
ATOM    486  CA  LEU B  10       1.724  -1.522  -2.176  1.00 17.47           C  
ATOM    487  C   LEU B  10       1.961  -0.856  -3.507  1.00 17.31           C  
ATOM    488  O   LEU B  10       3.083  -0.430  -3.792  1.00 17.79           O  
ATOM    489  CB  LEU B  10       1.885  -0.496  -1.051  1.00 17.06           C  
ATOM    490  CG  LEU B  10       1.043   0.770  -1.188  1.00 16.65           C  
ATOM    491  CD1 LEU B  10      -0.438   0.443  -1.101  1.00 16.03           C  
ATOM    492  CD2 LEU B  10       1.441   1.823  -0.160  1.00 15.04           C  
ATOM    493  N   VAL B  11       0.925  -0.784  -4.335  1.00 16.73           N  
ATOM    494  CA  VAL B  11       1.007  -0.030  -5.585  1.00 16.39           C  
ATOM    495  C   VAL B  11       0.279   1.304  -5.318  1.00 16.83           C  
ATOM    496  O   VAL B  11      -0.885   1.314  -4.844  1.00 15.13           O  
ATOM    497  CB  VAL B  11       0.327  -0.791  -6.771  1.00 16.89           C  
ATOM    498  CG1 VAL B  11       0.088   0.153  -8.002  1.00 15.82           C  
ATOM    499  CG2 VAL B  11       1.116  -2.045  -7.155  1.00 15.43           C  
ATOM    500  N   ILE B  12       0.940   2.428  -5.585  1.00 16.83           N  
ATOM    501  CA  ILE B  12       0.261   3.680  -5.337  1.00 17.36           C  
ATOM    502  C   ILE B  12      -0.100   4.459  -6.614  1.00 17.44           C  
ATOM    503  O   ILE B  12       0.773   4.777  -7.432  1.00 17.09           O  
ATOM    504  CB  ILE B  12       0.940   4.491  -4.207  1.00 17.16           C  
ATOM    505  CG1 ILE B  12       1.190   5.926  -4.614  1.00 19.38           C  
ATOM    506  CG2 ILE B  12       2.203   3.840  -3.721  1.00 19.60           C  
ATOM    507  CD1 ILE B  12       0.273   6.849  -3.923  1.00 20.66           C  
ATOM    508  N   ASN B  13      -1.400   4.729  -6.789  1.00 17.21           N  
ATOM    509  CA  ASN B  13      -1.887   5.548  -7.925  1.00 17.32           C  
ATOM    510  C   ASN B  13      -2.403   6.919  -7.472  1.00 16.56           C  
ATOM    511  O   ASN B  13      -3.624   7.120  -7.413  1.00 15.26           O  
ATOM    512  CB  ASN B  13      -3.042   4.845  -8.695  1.00 17.95           C  
ATOM    513  CG  ASN B  13      -2.624   3.540  -9.384  1.00 21.73           C  
ATOM    514  OD1 ASN B  13      -1.655   3.500 -10.138  1.00 27.80           O  
ATOM    515  ND2 ASN B  13      -3.385   2.470  -9.139  1.00 23.11           N  
ATOM    516  N   GLY B  14      -1.502   7.845  -7.126  1.00 15.93           N  
ATOM    517  CA  GLY B  14      -1.928   9.166  -6.662  1.00 15.88           C  
ATOM    518  C   GLY B  14      -1.985  10.265  -7.731  1.00 15.66           C  
ATOM    519  O   GLY B  14      -1.543  10.071  -8.854  1.00 15.31           O  
ATOM    520  N   LYS B  15      -2.542  11.419  -7.375  1.00 15.96           N  
ATOM    521  CA  LYS B  15      -2.472  12.620  -8.214  1.00 16.90           C  
ATOM    522  C   LYS B  15      -1.026  13.127  -8.510  1.00 16.68           C  
ATOM    523  O   LYS B  15      -0.723  13.593  -9.617  1.00 17.63           O  
ATOM    524  CB  LYS B  15      -3.243  13.722  -7.522  1.00 17.22           C  
ATOM    525  CG  LYS B  15      -4.734  13.467  -7.414  1.00 19.45           C  
ATOM    526  CD  LYS B  15      -5.410  14.713  -6.888  1.00 22.59           C  
ATOM    527  CE  LYS B  15      -6.118  14.451  -5.581  1.00 27.31           C  
ATOM    528  NZ  LYS B  15      -7.603  14.553  -5.760  1.00 27.86           N  
ATOM    529  N   THR B  16      -0.151  13.053  -7.518  1.00 15.56           N  
ATOM    530  CA  THR B  16       1.228  13.495  -7.649  1.00 16.06           C  
ATOM    531  C   THR B  16       2.281  12.490  -7.193  1.00 16.46           C  
ATOM    532  O   THR B  16       3.426  12.602  -7.602  1.00 17.57           O  
ATOM    533  CB  THR B  16       1.483  14.863  -6.900  1.00 16.09           C  
ATOM    534  OG1 THR B  16       1.164  14.731  -5.508  1.00 15.04           O  
ATOM    535  CG2 THR B  16       0.529  15.962  -7.413  1.00 15.03           C  
ATOM    536  N   LEU B  17       1.920  11.530  -6.337  1.00 16.03           N  
ATOM    537  CA  LEU B  17       2.803  10.421  -6.016  1.00 15.58           C  
ATOM    538  C   LEU B  17       2.362   9.105  -6.698  1.00 15.89           C  
ATOM    539  O   LEU B  17       1.227   8.646  -6.513  1.00 15.91           O  
ATOM    540  CB  LEU B  17       2.883  10.238  -4.517  1.00 14.94           C  
ATOM    541  CG  LEU B  17       3.888   9.185  -4.011  1.00 16.08           C  
ATOM    542  CD1 LEU B  17       5.352   9.696  -4.093  1.00 14.73           C  
ATOM    543  CD2 LEU B  17       3.545   8.720  -2.576  1.00 14.04           C  
ATOM    544  N   LYS B  18       3.270   8.486  -7.445  1.00 15.73           N  
ATOM    545  CA  LYS B  18       2.983   7.241  -8.168  1.00 16.94           C  
ATOM    546  C   LYS B  18       4.135   6.241  -8.028  1.00 16.41           C  
ATOM    547  O   LYS B  18       5.289   6.642  -8.011  1.00 16.10           O  
ATOM    548  CB  LYS B  18       2.795   7.522  -9.646  1.00 16.97           C  
ATOM    549  CG  LYS B  18       1.468   8.157 -10.004  1.00 20.04           C  
ATOM    550  CD  LYS B  18       1.517   8.738 -11.473  1.00 22.18           C  
ATOM    551  CE  LYS B  18       0.133   9.334 -11.871  1.00 24.58           C  
ATOM    552  NZ  LYS B  18      -1.009   8.436 -11.395  1.00 26.37           N  
ATOM    553  N   GLY B  19       3.815   4.951  -7.947  1.00 15.86           N  
ATOM    554  CA  GLY B  19       4.838   3.924  -7.893  1.00 15.77           C  
ATOM    555  C   GLY B  19       4.510   2.743  -6.990  1.00 15.19           C  
ATOM    556  O   GLY B  19       3.367   2.311  -6.908  1.00 14.35           O  
ATOM    557  N   GLU B  20       5.525   2.216  -6.317  1.00 14.83           N  
ATOM    558  CA  GLU B  20       5.337   1.024  -5.494  1.00 15.25           C  
ATOM    559  C   GLU B  20       6.303   1.004  -4.352  1.00 14.49           C  
ATOM    560  O   GLU B  20       7.326   1.678  -4.381  1.00 14.15           O  
ATOM    561  CB  GLU B  20       5.536  -0.231  -6.348  1.00 15.78           C  
ATOM    562  CG  GLU B  20       6.972  -0.473  -6.811  1.00 19.66           C  
ATOM    563  CD  GLU B  20       7.120  -1.618  -7.829  1.00 26.61           C  
ATOM    564  OE1 GLU B  20       7.685  -1.389  -8.901  1.00 28.20           O  
ATOM    565  OE2 GLU B  20       6.709  -2.773  -7.574  1.00 27.51           O  
ATOM    566  N   THR B  21       5.994   0.201  -3.350  1.00 14.73           N  
ATOM    567  CA  THR B  21       6.891  -0.008  -2.229  1.00 14.69           C  
ATOM    568  C   THR B  21       6.511  -1.354  -1.637  1.00 15.21           C  
ATOM    569  O   THR B  21       5.515  -1.943  -2.062  1.00 13.94           O  
ATOM    570  CB  THR B  21       6.754   1.159  -1.205  1.00 15.47           C  
ATOM    571  OG1 THR B  21       7.715   0.997  -0.156  1.00 15.40           O  
ATOM    572  CG2 THR B  21       5.353   1.143  -0.510  1.00 13.77           C  
ATOM    573  N   THR B  22       7.314  -1.845  -0.686  1.00 15.63           N  
ATOM    574  CA  THR B  22       7.044  -3.112   0.014  1.00 16.30           C  
ATOM    575  C   THR B  22       7.311  -3.057   1.533  1.00 17.06           C  
ATOM    576  O   THR B  22       7.874  -2.096   2.056  1.00 17.66           O  
ATOM    577  CB  THR B  22       7.892  -4.277  -0.569  1.00 15.96           C  
ATOM    578  OG1 THR B  22       9.266  -4.086  -0.208  1.00 15.73           O  
ATOM    579  CG2 THR B  22       7.872  -4.304  -2.124  1.00 14.43           C  
ATOM    580  N   THR B  23       6.893  -4.117   2.214  1.00 17.77           N  
ATOM    581  CA  THR B  23       7.080  -4.306   3.642  1.00 17.86           C  
ATOM    582  C   THR B  23       7.081  -5.808   3.918  1.00 18.57           C  
ATOM    583  O   THR B  23       6.445  -6.588   3.194  1.00 18.83           O  
ATOM    584  CB  THR B  23       5.982  -3.540   4.444  1.00 18.19           C  
ATOM    585  OG1 THR B  23       6.387  -3.439   5.810  1.00 18.00           O  
ATOM    586  CG2 THR B  23       4.645  -4.298   4.501  1.00 16.88           C  
ATOM    587  N   LYS B  24       7.823  -6.222   4.937  1.00 19.20           N  
ATOM    588  CA  LYS B  24       7.806  -7.614   5.371  1.00 19.53           C  
ATOM    589  C   LYS B  24       6.989  -7.732   6.650  1.00 19.00           C  
ATOM    590  O   LYS B  24       7.208  -6.973   7.590  1.00 18.82           O  
ATOM    591  CB  LYS B  24       9.231  -8.164   5.517  1.00 20.20           C  
ATOM    592  CG  LYS B  24       9.796  -8.678   4.179  1.00 21.88           C  
ATOM    593  CD  LYS B  24      11.233  -9.094   4.297  1.00 26.04           C  
ATOM    594  CE  LYS B  24      12.153  -7.952   3.804  1.00 27.51           C  
ATOM    595  NZ  LYS B  24      13.624  -8.318   3.714  1.00 29.45           N  
ATOM    596  N   ALA B  25       6.010  -8.642   6.645  1.00 18.39           N  
ATOM    597  CA  ALA B  25       4.985  -8.687   7.684  1.00 17.82           C  
ATOM    598  C   ALA B  25       4.482 -10.093   7.950  1.00 17.64           C  
ATOM    599  O   ALA B  25       4.599 -10.974   7.104  1.00 17.18           O  
ATOM    600  CB  ALA B  25       3.797  -7.754   7.349  1.00 17.42           C  
ATOM    601  N   VAL B  26       3.939 -10.268   9.152  1.00 17.37           N  
ATOM    602  CA  VAL B  26       3.355 -11.508   9.613  1.00 17.67           C  
ATOM    603  C   VAL B  26       2.143 -11.948   8.771  1.00 17.36           C  
ATOM    604  O   VAL B  26       1.972 -13.145   8.486  1.00 17.30           O  
ATOM    605  CB  VAL B  26       2.988 -11.376  11.122  1.00 17.70           C  
ATOM    606  CG1 VAL B  26       2.026 -12.470  11.560  1.00 19.31           C  
ATOM    607  CG2 VAL B  26       4.260 -11.409  11.980  1.00 19.50           C  
ATOM    608  N   ASP B  27       1.300 -10.990   8.384  1.00 16.85           N  
ATOM    609  CA  ASP B  27       0.079 -11.319   7.649  1.00 16.63           C  
ATOM    610  C   ASP B  27      -0.430 -10.086   6.926  1.00 16.44           C  
ATOM    611  O   ASP B  27       0.033  -8.976   7.181  1.00 17.22           O  
ATOM    612  CB  ASP B  27      -1.000 -11.887   8.597  1.00 16.57           C  
ATOM    613  CG  ASP B  27      -1.246 -10.987   9.814  1.00 17.16           C  
ATOM    614  OD1 ASP B  27      -1.428 -11.505  10.944  1.00 17.47           O  
ATOM    615  OD2 ASP B  27      -1.286  -9.736   9.729  1.00 16.91           O  
ATOM    616  N   ALA B  28      -1.387 -10.292   6.030  1.00 15.91           N  
ATOM    617  CA  ALA B  28      -1.903  -9.236   5.198  1.00 15.66           C  
ATOM    618  C   ALA B  28      -2.461  -8.046   6.004  1.00 15.52           C  
ATOM    619  O   ALA B  28      -2.169  -6.907   5.681  1.00 14.65           O  
ATOM    620  CB  ALA B  28      -2.934  -9.806   4.201  1.00 15.11           C  
ATOM    621  N   ALA B  29      -3.232  -8.323   7.059  1.00 15.90           N  
ATOM    622  CA  ALA B  29      -3.862  -7.272   7.882  1.00 16.22           C  
ATOM    623  C   ALA B  29      -2.873  -6.332   8.591  1.00 16.79           C  
ATOM    624  O   ALA B  29      -3.153  -5.131   8.730  1.00 16.88           O  
ATOM    625  CB  ALA B  29      -4.840  -7.877   8.900  1.00 15.69           C  
ATOM    626  N   THR B  30      -1.728  -6.880   9.025  1.00 16.94           N  
ATOM    627  CA  THR B  30      -0.639  -6.111   9.635  1.00 16.87           C  
ATOM    628  C   THR B  30       0.076  -5.243   8.597  1.00 17.68           C  
ATOM    629  O   THR B  30       0.397  -4.058   8.843  1.00 18.24           O  
ATOM    630  CB  THR B  30       0.391  -7.074  10.317  1.00 17.21           C  
ATOM    631  OG1 THR B  30      -0.261  -7.838  11.331  1.00 15.45           O  
ATOM    632  CG2 THR B  30       1.439  -6.297  11.124  1.00 16.45           C  
ATOM    633  N   ALA B  31       0.332  -5.839   7.433  1.00 17.05           N  
ATOM    634  CA  ALA B  31       0.937  -5.128   6.323  1.00 16.43           C  
ATOM    635  C   ALA B  31       0.086  -3.920   5.902  1.00 16.37           C  
ATOM    636  O   ALA B  31       0.632  -2.881   5.526  1.00 16.29           O  
ATOM    637  CB  ALA B  31       1.139  -6.075   5.143  1.00 15.76           C  
ATOM    638  N   GLU B  32      -1.238  -4.096   5.943  1.00 15.64           N  
ATOM    639  CA  GLU B  32      -2.200  -3.076   5.554  1.00 15.80           C  
ATOM    640  C   GLU B  32      -2.033  -1.848   6.444  1.00 16.29           C  
ATOM    641  O   GLU B  32      -2.052  -0.740   5.960  1.00 15.43           O  
ATOM    642  CB  GLU B  32      -3.627  -3.617   5.667  1.00 15.31           C  
ATOM    643  CG  GLU B  32      -4.720  -2.615   5.300  1.00 15.88           C  
ATOM    644  CD  GLU B  32      -6.106  -3.240   5.195  1.00 16.58           C  
ATOM    645  OE1 GLU B  32      -6.296  -4.328   4.746  1.00 14.81           O  
ATOM    646  OE2 GLU B  32      -7.079  -2.652   5.531  1.00 17.33           O  
ATOM    647  N   LYS B  33      -1.852  -2.061   7.753  1.00 17.04           N  
ATOM    648  CA  LYS B  33      -1.719  -0.935   8.675  1.00 17.67           C  
ATOM    649  C   LYS B  33      -0.443  -0.122   8.415  1.00 17.47           C  
ATOM    650  O   LYS B  33      -0.465   1.128   8.471  1.00 17.44           O  
ATOM    651  CB  LYS B  33      -1.819  -1.385  10.127  1.00 17.68           C  
ATOM    652  CG  LYS B  33      -3.268  -1.764  10.528  1.00 19.59           C  
ATOM    653  CD  LYS B  33      -3.291  -2.554  11.864  1.00 21.50           C  
ATOM    654  CE  LYS B  33      -4.699  -3.076  12.193  1.00 22.30           C  
ATOM    655  NZ  LYS B  33      -4.836  -3.514  13.620  1.00 26.37           N  
ATOM    656  N   VAL B  34       0.649  -0.826   8.104  1.00 16.97           N  
ATOM    657  CA  VAL B  34       1.904  -0.184   7.709  1.00 16.46           C  
ATOM    658  C   VAL B  34       1.704   0.610   6.440  1.00 16.01           C  
ATOM    659  O   VAL B  34       2.205   1.741   6.323  1.00 15.65           O  
ATOM    660  CB  VAL B  34       3.043  -1.203   7.474  1.00 16.55           C  
ATOM    661  CG1 VAL B  34       4.259  -0.505   6.892  1.00 17.21           C  
ATOM    662  CG2 VAL B  34       3.441  -1.876   8.780  1.00 16.83           C  
ATOM    663  N   PHE B  35       0.949   0.031   5.503  1.00 15.42           N  
ATOM    664  CA  PHE B  35       0.737   0.686   4.202  1.00 15.02           C  
ATOM    665  C   PHE B  35      -0.183   1.890   4.319  1.00 15.12           C  
ATOM    666  O   PHE B  35       0.089   2.928   3.709  1.00 14.75           O  
ATOM    667  CB  PHE B  35       0.283  -0.291   3.105  1.00 14.56           C  
ATOM    668  CG  PHE B  35       1.389  -1.211   2.583  1.00 15.03           C  
ATOM    669  CD1 PHE B  35       2.721  -0.803   2.559  1.00 13.60           C  
ATOM    670  CD2 PHE B  35       1.079  -2.487   2.098  1.00 14.81           C  
ATOM    671  CE1 PHE B  35       3.713  -1.640   2.058  1.00 13.92           C  
ATOM    672  CE2 PHE B  35       2.074  -3.338   1.611  1.00 14.98           C  
ATOM    673  CZ  PHE B  35       3.390  -2.907   1.581  1.00 14.97           C  
ATOM    674  N   LYS B  36      -1.221   1.784   5.141  1.00 14.82           N  
ATOM    675  CA  LYS B  36      -2.137   2.907   5.313  1.00 16.44           C  
ATOM    676  C   LYS B  36      -1.486   4.062   6.076  1.00 16.53           C  
ATOM    677  O   LYS B  36      -1.842   5.240   5.892  1.00 16.61           O  
ATOM    678  CB  LYS B  36      -3.461   2.459   5.982  1.00 16.45           C  
ATOM    679  CG  LYS B  36      -4.387   1.666   5.060  1.00 16.35           C  
ATOM    680  CD  LYS B  36      -5.653   1.237   5.794  1.00 17.47           C  
ATOM    681  CE  LYS B  36      -6.692   0.632   4.857  1.00 18.61           C  
ATOM    682  NZ  LYS B  36      -7.870   0.039   5.635  1.00 21.60           N  
ATOM    683  N   GLN B  37      -0.522   3.722   6.922  1.00 17.41           N  
ATOM    684  CA  GLN B  37       0.231   4.750   7.644  1.00 18.58           C  
ATOM    685  C   GLN B  37       1.155   5.431   6.639  1.00 18.37           C  
ATOM    686  O   GLN B  37       1.299   6.660   6.646  1.00 18.57           O  
ATOM    687  CB  GLN B  37       0.986   4.153   8.851  1.00 19.08           C  
ATOM    688  CG  GLN B  37       1.722   5.164   9.743  1.00 20.99           C  
ATOM    689  CD  GLN B  37       0.763   6.117  10.495  1.00 25.99           C  
ATOM    690  OE1 GLN B  37       0.862   7.354  10.366  1.00 28.58           O  
ATOM    691  NE2 GLN B  37      -0.161   5.543  11.260  1.00 24.80           N  
ATOM    692  N   TYR B  38       1.740   4.645   5.739  1.00 18.11           N  
ATOM    693  CA  TYR B  38       2.665   5.193   4.765  1.00 17.95           C  
ATOM    694  C   TYR B  38       1.946   6.176   3.825  1.00 18.35           C  
ATOM    695  O   TYR B  38       2.460   7.250   3.521  1.00 18.20           O  
ATOM    696  CB  TYR B  38       3.364   4.069   3.984  1.00 18.58           C  
ATOM    697  CG  TYR B  38       4.210   4.578   2.850  1.00 19.12           C  
ATOM    698  CD1 TYR B  38       5.593   4.792   3.020  1.00 19.41           C  
ATOM    699  CD2 TYR B  38       3.637   4.890   1.621  1.00 18.95           C  
ATOM    700  CE1 TYR B  38       6.376   5.294   1.962  1.00 19.44           C  
ATOM    701  CE2 TYR B  38       4.402   5.397   0.571  1.00 19.02           C  
ATOM    702  CZ  TYR B  38       5.770   5.585   0.743  1.00 21.29           C  
ATOM    703  OH  TYR B  38       6.599   6.067  -0.262  1.00 24.24           O  
ATOM    704  N   ALA B  39       0.748   5.812   3.385  1.00 18.32           N  
ATOM    705  CA  ALA B  39      -0.031   6.631   2.469  1.00 18.44           C  
ATOM    706  C   ALA B  39      -0.498   7.907   3.166  1.00 19.31           C  
ATOM    707  O   ALA B  39      -0.487   9.009   2.567  1.00 19.65           O  
ATOM    708  CB  ALA B  39      -1.230   5.838   1.920  1.00 18.30           C  
ATOM    709  N   ASN B  40      -0.918   7.771   4.422  1.00 19.84           N  
ATOM    710  CA  ASN B  40      -1.212   8.945   5.259  1.00 20.99           C  
ATOM    711  C   ASN B  40      -0.018   9.901   5.393  1.00 20.98           C  
ATOM    712  O   ASN B  40      -0.220  11.092   5.231  1.00 21.29           O  
ATOM    713  CB  ASN B  40      -1.721   8.539   6.652  1.00 21.88           C  
ATOM    714  CG  ASN B  40      -2.144   9.751   7.521  1.00 25.88           C  
ATOM    715  OD1 ASN B  40      -3.305  10.178   7.465  1.00 29.65           O  
ATOM    716  ND2 ASN B  40      -1.195  10.312   8.313  1.00 27.59           N  
ATOM    717  N   ASP B  41       1.183   9.394   5.708  1.00 20.84           N  
ATOM    718  CA  ASP B  41       2.379  10.232   5.903  1.00 21.01           C  
ATOM    719  C   ASP B  41       2.806  10.904   4.572  1.00 21.14           C  
ATOM    720  O   ASP B  41       3.672  11.769   4.564  1.00 21.92           O  
ATOM    721  CB  ASP B  41       3.581   9.415   6.446  1.00 20.70           C  
ATOM    722  CG  ASP B  41       3.344   8.790   7.856  1.00 22.91           C  
ATOM    723  OD1 ASP B  41       2.354   9.142   8.538  1.00 23.65           O  
ATOM    724  OD2 ASP B  41       4.112   7.913   8.368  1.00 23.72           O  
ATOM    725  N   ASN B  42       2.240  10.476   3.453  1.00 20.67           N  
ATOM    726  CA  ASN B  42       2.658  10.999   2.140  1.00 20.40           C  
ATOM    727  C   ASN B  42       1.525  11.706   1.422  1.00 20.13           C  
ATOM    728  O   ASN B  42       1.545  11.814   0.189  1.00 20.45           O  
ATOM    729  CB  ASN B  42       3.201   9.866   1.248  1.00 19.99           C  
ATOM    730  CG  ASN B  42       4.648   9.490   1.586  1.00 21.11           C  
ATOM    731  OD1 ASN B  42       5.586  10.045   1.024  1.00 21.58           O  
ATOM    732  ND2 ASN B  42       4.823   8.532   2.476  1.00 18.60           N  
ATOM    733  N   GLY B  43       0.511  12.148   2.180  1.00 20.09           N  
ATOM    734  CA  GLY B  43      -0.614  12.900   1.628  1.00 19.72           C  
ATOM    735  C   GLY B  43      -1.490  12.173   0.619  1.00 20.02           C  
ATOM    736  O   GLY B  43      -2.167  12.803  -0.205  1.00 19.30           O  
ATOM    737  N   VAL B  44      -1.474  10.843   0.649  1.00 20.29           N  
ATOM    738  CA  VAL B  44      -2.287  10.059  -0.291  1.00 20.71           C  
ATOM    739  C   VAL B  44      -3.548   9.608   0.407  1.00 20.97           C  
ATOM    740  O   VAL B  44      -3.502   9.057   1.499  1.00 22.16           O  
ATOM    741  CB  VAL B  44      -1.535   8.844  -0.858  1.00 20.58           C  
ATOM    742  CG1 VAL B  44      -2.445   8.018  -1.777  1.00 21.10           C  
ATOM    743  CG2 VAL B  44      -0.300   9.306  -1.605  1.00 20.68           C  
ATOM    744  N   ASP B  45      -4.677   9.872  -0.231  1.00 21.27           N  
ATOM    745  CA  ASP B  45      -5.977   9.566   0.331  1.00 21.05           C  
ATOM    746  C   ASP B  45      -6.892   9.007  -0.774  1.00 20.27           C  
ATOM    747  O   ASP B  45      -7.340   9.734  -1.665  1.00 19.01           O  
ATOM    748  CB  ASP B  45      -6.571  10.834   0.960  1.00 21.68           C  
ATOM    749  CG  ASP B  45      -7.848  10.558   1.715  1.00 25.15           C  
ATOM    750  OD1 ASP B  45      -7.994   9.428   2.231  1.00 27.74           O  
ATOM    751  OD2 ASP B  45      -8.760  11.405   1.842  1.00 28.53           O  
ATOM    752  N   GLY B  46      -7.187   7.713  -0.727  1.00 20.00           N  
ATOM    753  CA  GLY B  46      -8.029   7.142  -1.765  1.00 19.25           C  
ATOM    754  C   GLY B  46      -8.631   5.818  -1.376  1.00 19.17           C  
ATOM    755  O   GLY B  46      -8.722   5.511  -0.185  1.00 19.23           O  
ATOM    756  N   GLU B  47      -9.028   5.052  -2.394  1.00 18.27           N  
ATOM    757  CA  GLU B  47      -9.697   3.766  -2.249  1.00 17.80           C  
ATOM    758  C   GLU B  47      -8.709   2.596  -2.316  1.00 16.20           C  
ATOM    759  O   GLU B  47      -7.758   2.614  -3.117  1.00 14.43           O  
ATOM    760  CB  GLU B  47     -10.731   3.600  -3.371  1.00 18.52           C  
ATOM    761  CG  GLU B  47     -11.896   4.573  -3.292  1.00 22.84           C  
ATOM    762  CD  GLU B  47     -13.129   4.081  -4.042  1.00 29.80           C  
ATOM    763  OE1 GLU B  47     -14.037   4.916  -4.302  1.00 33.14           O  
ATOM    764  OE2 GLU B  47     -13.215   2.858  -4.370  1.00 32.61           O  
ATOM    765  N   TRP B  48      -9.001   1.562  -1.525  1.00 14.76           N  
ATOM    766  CA  TRP B  48      -8.099   0.427  -1.279  1.00 14.43           C  
ATOM    767  C   TRP B  48      -8.592  -0.906  -1.842  1.00 14.14           C  
ATOM    768  O   TRP B  48      -9.745  -1.291  -1.636  1.00 13.16           O  
ATOM    769  CB  TRP B  48      -7.813   0.305   0.244  1.00 13.96           C  
ATOM    770  CG  TRP B  48      -6.979   1.471   0.755  1.00 14.45           C  
ATOM    771  CD1 TRP B  48      -7.435   2.745   1.056  1.00 14.63           C  
ATOM    772  CD2 TRP B  48      -5.560   1.491   1.009  1.00 12.10           C  
ATOM    773  NE1 TRP B  48      -6.387   3.539   1.478  1.00 11.77           N  
ATOM    774  CE2 TRP B  48      -5.231   2.797   1.478  1.00 12.28           C  
ATOM    775  CE3 TRP B  48      -4.537   0.537   0.928  1.00 13.27           C  
ATOM    776  CZ2 TRP B  48      -3.918   3.176   1.817  1.00 11.45           C  
ATOM    777  CZ3 TRP B  48      -3.204   0.929   1.283  1.00 14.14           C  
ATOM    778  CH2 TRP B  48      -2.924   2.229   1.723  1.00 10.86           C  
ATOM    779  N   THR B  49      -7.722  -1.611  -2.561  1.00 14.35           N  
ATOM    780  CA  THR B  49      -7.990  -3.008  -2.911  1.00 14.54           C  
ATOM    781  C   THR B  49      -6.818  -3.858  -2.475  1.00 14.95           C  
ATOM    782  O   THR B  49      -5.730  -3.333  -2.157  1.00 14.24           O  
ATOM    783  CB  THR B  49      -8.190  -3.232  -4.437  1.00 15.15           C  
ATOM    784  OG1 THR B  49      -6.969  -2.933  -5.121  1.00 15.94           O  
ATOM    785  CG2 THR B  49      -9.233  -2.265  -5.053  1.00 15.71           C  
ATOM    786  N   TYR B  50      -7.055  -5.169  -2.493  1.00 14.75           N  
ATOM    787  CA  TYR B  50      -6.068  -6.161  -2.095  1.00 15.37           C  
ATOM    788  C   TYR B  50      -6.308  -7.422  -2.917  1.00 15.73           C  
ATOM    789  O   TYR B  50      -7.451  -7.921  -3.009  1.00 14.93           O  
ATOM    790  CB  TYR B  50      -6.156  -6.496  -0.583  1.00 14.88           C  
ATOM    791  CG  TYR B  50      -5.180  -7.591  -0.206  1.00 15.40           C  
ATOM    792  CD1 TYR B  50      -3.800  -7.364  -0.287  1.00 15.49           C  
ATOM    793  CD2 TYR B  50      -5.621  -8.866   0.171  1.00 15.16           C  
ATOM    794  CE1 TYR B  50      -2.885  -8.350   0.019  1.00 14.92           C  
ATOM    795  CE2 TYR B  50      -4.687  -9.876   0.498  1.00 14.89           C  
ATOM    796  CZ  TYR B  50      -3.324  -9.597   0.398  1.00 14.22           C  
ATOM    797  OH  TYR B  50      -2.384 -10.544   0.691  1.00 13.80           O  
ATOM    798  N   ASP B  51      -5.229  -7.909  -3.519  1.00 16.63           N  
ATOM    799  CA  ASP B  51      -5.229  -9.165  -4.273  1.00 17.88           C  
ATOM    800  C   ASP B  51      -4.367 -10.164  -3.502  1.00 18.04           C  
ATOM    801  O   ASP B  51      -3.152  -9.933  -3.353  1.00 17.54           O  
ATOM    802  CB  ASP B  51      -4.630  -8.889  -5.670  1.00 18.61           C  
ATOM    803  CG  ASP B  51      -4.658 -10.116  -6.602  1.00 20.24           C  
ATOM    804  OD1 ASP B  51      -4.746 -11.258  -6.139  1.00 21.83           O  
ATOM    805  OD2 ASP B  51      -4.574 -10.020  -7.835  1.00 25.08           O  
ATOM    806  N   ASP B  52      -4.969 -11.252  -3.010  1.00 18.44           N  
ATOM    807  CA  ASP B  52      -4.208 -12.248  -2.235  1.00 19.69           C  
ATOM    808  C   ASP B  52      -3.188 -13.023  -3.084  1.00 19.62           C  
ATOM    809  O   ASP B  52      -2.065 -13.239  -2.647  1.00 20.16           O  
ATOM    810  CB  ASP B  52      -5.119 -13.209  -1.437  1.00 20.02           C  
ATOM    811  CG  ASP B  52      -4.364 -13.945  -0.286  1.00 22.74           C  
ATOM    812  OD1 ASP B  52      -3.678 -13.284   0.545  1.00 23.81           O  
ATOM    813  OD2 ASP B  52      -4.418 -15.190  -0.137  1.00 25.68           O  
ATOM    814  N   ALA B  53      -3.575 -13.417  -4.291  1.00 19.60           N  
ATOM    815  CA  ALA B  53      -2.699 -14.194  -5.173  1.00 19.37           C  
ATOM    816  C   ALA B  53      -1.325 -13.543  -5.402  1.00 19.10           C  
ATOM    817  O   ALA B  53      -0.294 -14.229  -5.422  1.00 18.93           O  
ATOM    818  CB  ALA B  53      -3.403 -14.456  -6.509  1.00 19.36           C  
ATOM    819  N   THR B  54      -1.317 -12.213  -5.532  1.00 19.10           N  
ATOM    820  CA  THR B  54      -0.081 -11.458  -5.702  1.00 18.54           C  
ATOM    821  C   THR B  54       0.393 -10.676  -4.457  1.00 17.95           C  
ATOM    822  O   THR B  54       1.317  -9.851  -4.573  1.00 18.03           O  
ATOM    823  CB  THR B  54      -0.204 -10.517  -6.910  1.00 19.24           C  
ATOM    824  OG1 THR B  54      -1.246  -9.553  -6.669  1.00 20.24           O  
ATOM    825  CG2 THR B  54      -0.686 -11.280  -8.159  1.00 18.98           C  
ATOM    826  N   LYS B  55      -0.208 -10.934  -3.284  1.00 16.77           N  
ATOM    827  CA  LYS B  55       0.092 -10.172  -2.049  1.00 16.02           C  
ATOM    828  C   LYS B  55       0.205  -8.633  -2.269  1.00 15.73           C  
ATOM    829  O   LYS B  55       1.078  -7.971  -1.687  1.00 15.03           O  
ATOM    830  CB  LYS B  55       1.376 -10.674  -1.363  1.00 16.39           C  
ATOM    831  CG  LYS B  55       1.601 -12.214  -1.340  1.00 17.58           C  
ATOM    832  CD  LYS B  55       0.504 -12.909  -0.574  1.00 19.50           C  
ATOM    833  CE  LYS B  55       0.755 -14.423  -0.442  1.00 23.59           C  
ATOM    834  NZ  LYS B  55      -0.269 -15.223  -1.195  1.00 23.40           N  
ATOM    835  N   THR B  56      -0.687  -8.082  -3.096  1.00 15.30           N  
ATOM    836  CA  THR B  56      -0.614  -6.687  -3.538  1.00 14.47           C  
ATOM    837  C   THR B  56      -1.823  -5.832  -3.148  1.00 14.54           C  
ATOM    838  O   THR B  56      -2.967  -6.115  -3.507  1.00 14.99           O  
ATOM    839  CB  THR B  56      -0.385  -6.619  -5.067  1.00 14.16           C  
ATOM    840  OG1 THR B  56       0.899  -7.170  -5.371  1.00 13.92           O  
ATOM    841  CG2 THR B  56      -0.275  -5.177  -5.543  1.00 13.16           C  
ATOM    842  N   PHE B  57      -1.536  -4.768  -2.419  1.00 14.22           N  
ATOM    843  CA  PHE B  57      -2.501  -3.738  -2.085  1.00 13.95           C  
ATOM    844  C   PHE B  57      -2.391  -2.634  -3.114  1.00 14.54           C  
ATOM    845  O   PHE B  57      -1.306  -2.389  -3.640  1.00 15.32           O  
ATOM    846  CB  PHE B  57      -2.122  -3.102  -0.753  1.00 13.53           C  
ATOM    847  CG  PHE B  57      -2.396  -3.955   0.433  1.00 13.82           C  
ATOM    848  CD1 PHE B  57      -1.418  -4.817   0.918  1.00 12.51           C  
ATOM    849  CD2 PHE B  57      -3.619  -3.875   1.097  1.00 12.37           C  
ATOM    850  CE1 PHE B  57      -1.652  -5.589   2.029  1.00 12.55           C  
ATOM    851  CE2 PHE B  57      -3.880  -4.672   2.221  1.00 13.88           C  
ATOM    852  CZ  PHE B  57      -2.900  -5.535   2.683  1.00 13.30           C  
ATOM    853  N   THR B  58      -3.502  -1.948  -3.373  1.00 14.15           N  
ATOM    854  CA  THR B  58      -3.506  -0.813  -4.260  1.00 13.59           C  
ATOM    855  C   THR B  58      -4.244   0.321  -3.562  1.00 13.75           C  
ATOM    856  O   THR B  58      -5.328   0.092  -2.994  1.00 13.13           O  
ATOM    857  CB  THR B  58      -4.209  -1.199  -5.566  1.00 14.11           C  
ATOM    858  OG1 THR B  58      -3.398  -2.123  -6.301  1.00 15.28           O  
ATOM    859  CG2 THR B  58      -4.294  -0.002  -6.543  1.00 12.83           C  
ATOM    860  N   VAL B  59      -3.675   1.533  -3.606  1.00 13.47           N  
ATOM    861  CA  VAL B  59      -4.400   2.737  -3.205  1.00 13.44           C  
ATOM    862  C   VAL B  59      -4.494   3.658  -4.414  1.00 14.94           C  
ATOM    863  O   VAL B  59      -3.470   3.959  -5.092  1.00 14.68           O  
ATOM    864  CB  VAL B  59      -3.780   3.453  -1.982  1.00 13.75           C  
ATOM    865  CG1 VAL B  59      -2.360   3.938  -2.275  1.00 11.81           C  
ATOM    866  CG2 VAL B  59      -4.657   4.625  -1.542  1.00 13.12           C  
ATOM    867  N   THR B  60      -5.721   4.092  -4.739  1.00 15.91           N  
ATOM    868  CA  THR B  60      -5.866   5.054  -5.841  1.00 16.52           C  
ATOM    869  C   THR B  60      -6.709   6.287  -5.557  1.00 17.59           C  
ATOM    870  O   THR B  60      -7.794   6.200  -5.002  1.00 16.90           O  
ATOM    871  CB  THR B  60      -6.214   4.390  -7.193  1.00 17.31           C  
ATOM    872  OG1 THR B  60      -7.389   5.007  -7.796  1.00 19.55           O  
ATOM    873  CG2 THR B  60      -6.557   2.977  -7.065  1.00 12.59           C  
ATOM    874  N   GLU B  61      -6.151   7.436  -5.909  1.00 18.96           N  
ATOM    875  CA  GLU B  61      -6.789   8.713  -5.670  1.00 20.50           C  
ATOM    876  C   GLU B  61      -7.688   9.026  -6.870  1.00 21.66           C  
ATOM    877  O   GLU B  61      -7.431   8.562  -7.976  1.00 20.68           O  
ATOM    878  CB  GLU B  61      -5.720   9.791  -5.511  1.00 19.91           C  
ATOM    879  CG  GLU B  61      -4.976   9.739  -4.182  1.00 21.78           C  
ATOM    880  CD  GLU B  61      -4.176  11.003  -3.885  1.00 23.57           C  
ATOM    881  OE1 GLU B  61      -3.238  11.349  -4.663  1.00 18.43           O  
ATOM    882  OE2 GLU B  61      -4.510  11.638  -2.858  1.00 25.30           O  
ATOM    883  N   LYS B  62      -8.737   9.812  -6.669  1.00 25.32           N  
ATOM    884  CA  LYS B  62      -9.462  10.396  -7.799  1.00 29.08           C  
ATOM    885  C   LYS B  62      -8.480  11.265  -8.615  1.00 31.87           C  
ATOM    886  O   LYS B  62      -7.495  11.788  -8.063  1.00 31.74           O  
ATOM    887  CB  LYS B  62     -10.643  11.231  -7.306  1.00 29.09           C  
ATOM    888  CG  LYS B  62     -11.747  10.427  -6.582  1.00 30.82           C  
ATOM    889  CD  LYS B  62     -13.143  10.972  -6.891  1.00 33.37           C  
ATOM    890  CE  LYS B  62     -14.104   9.822  -7.151  1.00 36.20           C  
ATOM    891  NZ  LYS B  62     -15.492  10.084  -6.660  1.00 37.61           N  
ATOM    892  N   PRO B  63      -8.720  11.410  -9.918  1.00 35.05           N  
ATOM    893  CA  PRO B  63      -7.874  12.276 -10.754  1.00 37.69           C  
ATOM    894  C   PRO B  63      -8.089  13.734 -10.295  1.00 39.92           C  
ATOM    895  O   PRO B  63      -9.156  14.053  -9.741  1.00 39.61           O  
ATOM    896  CB  PRO B  63      -8.479  12.095 -12.148  1.00 37.62           C  
ATOM    897  CG  PRO B  63      -9.942  11.822 -11.842  1.00 37.10           C  
ATOM    898  CD  PRO B  63      -9.845  10.835 -10.690  1.00 35.16           C  
ATOM    899  N   GLU B  64      -7.122  14.608 -10.525  1.00 42.57           N  
ATOM    900  CA  GLU B  64      -7.331  15.986 -10.083  1.00 46.11           C  
ATOM    901  C   GLU B  64      -8.270  16.781 -11.010  1.00 47.42           C  
ATOM    902  O   GLU B  64      -8.222  16.532 -12.239  1.00 48.25           O  
ATOM    903  CB  GLU B  64      -6.014  16.721  -9.809  1.00 46.31           C  
ATOM    904  CG  GLU B  64      -5.076  16.893 -10.983  1.00 48.62           C  
ATOM    905  CD  GLU B  64      -3.658  17.127 -10.502  1.00 51.59           C  
ATOM    906  OE1 GLU B  64      -3.512  17.732  -9.436  1.00 48.64           O  
ATOM    907  OE2 GLU B  64      -2.693  16.677 -11.163  1.00 55.72           O  
ATOM    908  OXT GLU B  64      -9.055  17.592 -10.456  1.00 48.52           O  
TER     909      GLU B  64                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
