
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  855),  selected   56 , name 1gb1_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1gb1_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      T       1          1.079
LGA    T     2_A      T       2          1.008
LGA    Y     3_A      Y       3          1.028
LGA    K     4_A      K       4          1.481
LGA    L     5_A      L       5          1.151
LGA    I     6_A      I       6          0.876
LGA    L     7_A      L       7          0.708
LGA    N     8_A      N       8          1.355
LGA    G     9_A      L       9          1.541
LGA    K    10_A      K      10          2.105
LGA    T    11_A      Q      11          3.156
LGA    L    12_A      A      12          2.319
LGA    K    13_A      K      13          1.170
LGA    G    14_A      E      14          1.026
LGA    E    15_A      E      15          0.722
LGA    T    16_A      A      16          2.445
LGA    T    17_A      I      17          1.477
LGA    T    18_A      K      18          1.008
LGA    E    19_A      E      19          1.804
LGA    A    20_A      A      20          2.542
LGA    V    21_A      V      21          2.462
LGA    D    22_A      D      22          2.004
LGA    A    23_A      A      23          2.105
LGA    A    24_A      G      24          2.904
LGA    T    25_A      T      25          2.862
LGA    A    26_A      A      26          1.756
LGA    E    27_A      E      27          1.797
LGA    K    28_A      K      28          1.764
LGA    V    29_A      Y      29          0.968
LGA    F    30_A      F      30          0.607
LGA    K    31_A      K      31          1.183
LGA    Q    32_A      L      32          0.528
LGA    Y    33_A      I      33          0.150
LGA    A    34_A      A      34          1.361
LGA    N    35_A      N      35          1.903
LGA    D    36_A      A      36          2.083
LGA    N    37_A      K      37          1.553
LGA    G    38_A      T      38          1.759
LGA    V    39_A      V      39          3.576
LGA    D    40_A      E      40          3.050
LGA    G    41_A      G      41          3.046
LGA    E    42_A      V      42          2.289
LGA    W    43_A      W      43          1.144
LGA    T    44_A      T      44          1.097
LGA    Y    45_A      Y      45          1.232
LGA    D    46_A      K      46          1.302
LGA    D    47_A      D      47          2.446
LGA    A    48_A      E      48          1.419
LGA    T    49_A      I      49          2.323
LGA    K    50_A      K      50          2.258
LGA    T    51_A      T      51          2.362
LGA    F    52_A      F      52          2.168
LGA    T    53_A      T      53          1.422
LGA    V    54_A      V      54          1.452
LGA    T    55_A      T      55          1.410
LGA    E    56_A      E      56          2.418

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   56    5.0     56    1.87    64.29     88.503     2.843

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.151255 * X  +   0.093128 * Y  +   0.984098 * Z  +  -0.120095
  Y_new =   0.934767 * X  +   0.337226 * Y  +   0.111760 * Z  +  -0.506724
  Z_new =  -0.321455 * X  +   0.936806 * Y  +  -0.138060 * Z  +   0.086627 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.717116   -1.424477  [ DEG:    98.3835    -81.6165 ]
  Theta =   0.327266    2.814327  [ DEG:    18.7509    161.2491 ]
  Phi   =   1.731216   -1.410377  [ DEG:    99.1914    -80.8086 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gb1_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gb1_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   56   5.0   56   1.87   64.29  88.503
REMARK  ---------------------------------------------------------- 
MOLECULE 1gb1_A
HEADER    IMMUNOGLOBULIN BINDING PROTEIN          15-MAY-91   1GB1              
TITLE     A NOVEL, HIGHLY STABLE FOLD OF THE IMMUNOGLOBULIN BINDING             
TITLE    2 DOMAIN OF STREPTOCOCCAL PROTEIN G                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN G;                                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES GRISEUS                            
KEYWDS    IMMUNOGLOBULIN BINDING PROTEIN                                        
EXPDTA    NMR, 60 STRUCTURES                                                    
AUTHOR    A.M.GRONENBORN,G.M.CLORE                                              
REVDAT   1   15-APR-93 1GB1    0                                                
JRNL        AUTH   A.M.GRONENBORN,D.R.FILPULA,N.Z.ESSIG,A.ACHARI,               
JRNL        AUTH 2 M.WHITLOW,P.T.WINGFIELD,G.M.CLORE                            
JRNL        TITL   A NOVEL, HIGHLY STABLE FOLD OF THE IMMUNOGLOBULIN            
JRNL        TITL 2 BINDING DOMAIN OF STREPTOCOCCAL PROTEIN G.                   
JRNL        REF    SCIENCE                       V. 253   657 1991              
JRNL        REFN   ASTM SCIEAS  US ISSN 0036-8075                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1GB1 A    2    56  UNP    P06654   SPG1_STRSG     228    282             
SEQRES   1 A   56  MET THR TYR LYS LEU ILE LEU ASN GLY LYS THR LEU LYS          
SEQRES   2 A   56  GLY GLU THR THR THR GLU ALA VAL ASP ALA ALA THR ALA          
SEQRES   3 A   56  GLU LYS VAL PHE LYS GLN TYR ALA ASN ASP ASN GLY VAL          
SEQRES   4 A   56  ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   5 A   56  THR VAL THR GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       5.700 -12.871   5.369  1.00  0.93           N  
ATOM      2  CA  MET A   1       5.888 -12.608   3.913  1.00  0.36           C  
ATOM      3  C   MET A   1       5.993 -11.100   3.677  1.00  0.36           C  
ATOM      4  O   MET A   1       6.014 -10.322   4.610  1.00  0.64           O  
ATOM      5  CB  MET A   1       4.712 -13.162   3.108  1.00  1.26           C  
ATOM      6  CG  MET A   1       4.325 -14.534   3.662  1.00  1.15           C  
ATOM      7  SD  MET A   1       3.091 -14.579   4.985  1.00  1.64           S  
ATOM      8  CE  MET A   1       3.389 -16.285   5.513  1.00  1.41           C  
ATOM      9  HA  MET A   1       6.798 -13.082   3.584  1.00  1.20           H  
ATOM     10  HB2 MET A   1       3.871 -12.488   3.186  1.00  1.76           H  
ATOM     11  HB3 MET A   1       4.995 -13.256   2.071  1.00  2.04           H  
ATOM     12  HG2 MET A   1       3.951 -15.132   2.845  1.00  2.09           H  
ATOM     13  HG3 MET A   1       5.220 -15.010   4.034  1.00  1.00           H  
ATOM     14  HE1 MET A   1       4.432 -16.404   5.770  1.00  0.99           H  
ATOM     15  HE2 MET A   1       2.778 -16.506   6.376  1.00  2.25           H  
ATOM     16  HE3 MET A   1       3.137 -16.960   4.710  1.00  1.91           H  
ATOM     17  H1  MET A   1       5.871 -11.996   5.904  1.00  1.67           H  
ATOM     18  H2  MET A   1       4.726 -13.195   5.540  1.00  1.74           H  
ATOM     19  H3  MET A   1       6.368 -13.604   5.680  1.00  1.13           H  
ATOM     20  N   THR A   2       6.058 -10.721   2.430  1.00  0.12           N  
ATOM     21  CA  THR A   2       6.158  -9.269   2.104  1.00  0.06           C  
ATOM     22  C   THR A   2       5.323  -8.959   0.858  1.00  0.06           C  
ATOM     23  O   THR A   2       5.510  -9.563  -0.179  1.00  0.09           O  
ATOM     24  CB  THR A   2       7.623  -8.916   1.841  1.00  0.06           C  
ATOM     25  OG1 THR A   2       8.331  -9.450   2.957  1.00  0.06           O  
ATOM     26  CG2 THR A   2       7.857  -7.410   1.899  1.00  0.05           C  
ATOM     27  H   THR A   2       6.046 -11.387   1.711  1.00  0.25           H  
ATOM     28  HA  THR A   2       5.792  -8.689   2.934  1.00  0.05           H  
ATOM     29  HB  THR A   2       7.980  -9.333   0.917  1.00  0.07           H  
ATOM     30  HG1 THR A   2       7.841  -9.228   3.753  1.00  1.18           H  
ATOM     31 HG21 THR A   2       6.983  -6.890   1.535  1.00  1.15           H  
ATOM     32 HG22 THR A   2       8.051  -7.110   2.919  1.00  1.10           H  
ATOM     33 HG23 THR A   2       8.707  -7.150   1.285  1.00  1.14           H  
ATOM     34  N   TYR A   3       4.420  -8.020   0.986  1.00  0.04           N  
ATOM     35  CA  TYR A   3       3.556  -7.663  -0.187  1.00  0.04           C  
ATOM     36  C   TYR A   3       4.076  -6.382  -0.849  1.00  0.06           C  
ATOM     37  O   TYR A   3       4.754  -5.593  -0.223  1.00  0.20           O  
ATOM     38  CB  TYR A   3       2.119  -7.450   0.292  1.00  0.02           C  
ATOM     39  CG  TYR A   3       1.778  -8.497   1.356  1.00  0.06           C  
ATOM     40  CD1 TYR A   3       2.250  -8.365   2.648  1.00  0.10           C  
ATOM     41  CD2 TYR A   3       0.996  -9.587   1.040  1.00  0.07           C  
ATOM     42  CE1 TYR A   3       1.942  -9.310   3.606  1.00  0.14           C  
ATOM     43  CE2 TYR A   3       0.689 -10.532   1.999  1.00  0.11           C  
ATOM     44  CZ  TYR A   3       1.160 -10.399   3.288  1.00  0.14           C  
ATOM     45  OH  TYR A   3       0.853 -11.344   4.247  1.00  0.19           O  
ATOM     46  H   TYR A   3       4.316  -7.546   1.841  1.00  0.03           H  
ATOM     47  HA  TYR A   3       3.575  -8.468  -0.902  1.00  0.06           H  
ATOM     48  HB2 TYR A   3       2.013  -6.466   0.710  1.00  0.01           H  
ATOM     49  HB3 TYR A   3       1.440  -7.556  -0.541  1.00  0.04           H  
ATOM     50  HD1 TYR A   3       2.861  -7.514   2.911  1.00  0.10           H  
ATOM     51  HD2 TYR A   3       0.619  -9.701   0.037  1.00  0.06           H  
ATOM     52  HE1 TYR A   3       2.318  -9.195   4.610  1.00  0.17           H  
ATOM     53  HE2 TYR A   3       0.075 -11.380   1.737  1.00  0.13           H  
ATOM     54  HH  TYR A   3       0.333 -12.034   3.827  1.00  0.62           H  
ATOM     55  N   LYS A   4       3.743  -6.203  -2.104  1.00  0.10           N  
ATOM     56  CA  LYS A   4       4.220  -4.981  -2.829  1.00  0.08           C  
ATOM     57  C   LYS A   4       3.080  -3.970  -2.973  1.00  0.07           C  
ATOM     58  O   LYS A   4       2.043  -4.284  -3.501  1.00  0.09           O  
ATOM     59  CB  LYS A   4       4.693  -5.392  -4.227  1.00  0.12           C  
ATOM     60  CG  LYS A   4       5.830  -4.464  -4.687  1.00  0.20           C  
ATOM     61  CD  LYS A   4       5.780  -4.304  -6.211  1.00  0.29           C  
ATOM     62  CE  LYS A   4       5.989  -5.666  -6.878  1.00  1.08           C  
ATOM     63  NZ  LYS A   4       4.712  -6.164  -7.460  1.00  2.41           N  
ATOM     64  H   LYS A   4       3.185  -6.865  -2.565  1.00  0.22           H  
ATOM     65  HA  LYS A   4       5.034  -4.537  -2.285  1.00  0.07           H  
ATOM     66  HB2 LYS A   4       5.037  -6.413  -4.204  1.00  0.09           H  
ATOM     67  HB3 LYS A   4       3.868  -5.317  -4.916  1.00  0.22           H  
ATOM     68  HG2 LYS A   4       5.724  -3.496  -4.222  1.00  0.46           H  
ATOM     69  HG3 LYS A   4       6.779  -4.891  -4.402  1.00  0.35           H  
ATOM     70  HD2 LYS A   4       4.821  -3.900  -6.504  1.00  1.27           H  
ATOM     71  HD3 LYS A   4       6.558  -3.624  -6.528  1.00  1.11           H  
ATOM     72  HE2 LYS A   4       6.722  -5.574  -7.667  1.00  1.17           H  
ATOM     73  HE3 LYS A   4       6.345  -6.377  -6.149  1.00  1.86           H  
ATOM     74  HZ1 LYS A   4       4.037  -5.375  -7.537  1.00  2.78           H  
ATOM     75  HZ2 LYS A   4       4.892  -6.561  -8.403  1.00  2.73           H  
ATOM     76  HZ3 LYS A   4       4.314  -6.901  -6.843  1.00  3.28           H  
ATOM     77  N   LEU A   5       3.303  -2.773  -2.518  1.00  0.10           N  
ATOM     78  CA  LEU A   5       2.221  -1.749  -2.627  1.00  0.07           C  
ATOM     79  C   LEU A   5       2.343  -0.995  -3.955  1.00  0.04           C  
ATOM     80  O   LEU A   5       3.425  -0.841  -4.487  1.00  0.06           O  
ATOM     81  CB  LEU A   5       2.350  -0.757  -1.437  1.00  0.06           C  
ATOM     82  CG  LEU A   5       1.690   0.626  -1.737  1.00  0.31           C  
ATOM     83  CD1 LEU A   5       0.185   0.472  -2.017  1.00  0.62           C  
ATOM     84  CD2 LEU A   5       1.862   1.518  -0.504  1.00  0.11           C  
ATOM     85  H   LEU A   5       4.163  -2.547  -2.111  1.00  0.16           H  
ATOM     86  HA  LEU A   5       1.267  -2.255  -2.580  1.00  0.07           H  
ATOM     87  HB2 LEU A   5       1.886  -1.189  -0.563  1.00  0.14           H  
ATOM     88  HB3 LEU A   5       3.401  -0.597  -1.230  1.00  0.15           H  
ATOM     89  HG  LEU A   5       2.172   1.097  -2.577  1.00  0.55           H  
ATOM     90 HD11 LEU A   5      -0.101  -0.556  -1.958  1.00  0.68           H  
ATOM     91 HD12 LEU A   5      -0.378   1.035  -1.287  1.00  0.78           H  
ATOM     92 HD13 LEU A   5      -0.044   0.851  -3.001  1.00  1.47           H  
ATOM     93 HD21 LEU A   5       2.907   1.574  -0.236  1.00  1.19           H  
ATOM     94 HD22 LEU A   5       1.496   2.510  -0.717  1.00  1.07           H  
ATOM     95 HD23 LEU A   5       1.306   1.107   0.323  1.00  1.11           H  
ATOM     96  N   ILE A   6       1.220  -0.547  -4.453  1.00  0.03           N  
ATOM     97  CA  ILE A   6       1.216   0.228  -5.718  1.00  0.05           C  
ATOM     98  C   ILE A   6       0.458   1.539  -5.497  1.00  0.03           C  
ATOM     99  O   ILE A   6      -0.758   1.564  -5.476  1.00  0.02           O  
ATOM    100  CB  ILE A   6       0.535  -0.588  -6.816  1.00  0.07           C  
ATOM    101  CG1 ILE A   6       1.416  -1.794  -7.156  1.00  0.07           C  
ATOM    102  CG2 ILE A   6       0.365   0.288  -8.060  1.00  0.17           C  
ATOM    103  CD1 ILE A   6       0.552  -2.890  -7.779  1.00  0.54           C  
ATOM    104  H   ILE A   6       0.386  -0.720  -3.997  1.00  0.06           H  
ATOM    105  HA  ILE A   6       2.218   0.444  -6.002  1.00  0.08           H  
ATOM    106  HB  ILE A   6      -0.431  -0.925  -6.476  1.00  0.12           H  
ATOM    107 HG12 ILE A   6       2.184  -1.496  -7.853  1.00  0.51           H  
ATOM    108 HG13 ILE A   6       1.882  -2.167  -6.256  1.00  0.40           H  
ATOM    109 HG21 ILE A   6       1.109   1.071  -8.058  1.00  0.87           H  
ATOM    110 HG22 ILE A   6       0.484  -0.313  -8.950  1.00  1.02           H  
ATOM    111 HG23 ILE A   6      -0.618   0.733  -8.061  1.00  1.21           H  
ATOM    112 HD11 ILE A   6      -0.252  -2.445  -8.346  1.00  1.12           H  
ATOM    113 HD12 ILE A   6       1.156  -3.499  -8.437  1.00  0.79           H  
ATOM    114 HD13 ILE A   6       0.136  -3.512  -7.002  1.00  1.71           H  
ATOM    115  N   LEU A   7       1.194   2.603  -5.333  1.00  0.03           N  
ATOM    116  CA  LEU A   7       0.540   3.922  -5.085  1.00  0.04           C  
ATOM    117  C   LEU A   7       0.032   4.541  -6.387  1.00  0.03           C  
ATOM    118  O   LEU A   7       0.806   4.885  -7.256  1.00  0.07           O  
ATOM    119  CB  LEU A   7       1.556   4.861  -4.437  1.00  0.07           C  
ATOM    120  CG  LEU A   7       1.830   4.390  -3.009  1.00  0.11           C  
ATOM    121  CD1 LEU A   7       3.336   4.426  -2.746  1.00  0.24           C  
ATOM    122  CD2 LEU A   7       1.126   5.325  -2.026  1.00  0.18           C  
ATOM    123  H   LEU A   7       2.169   2.536  -5.374  1.00  0.04           H  
ATOM    124  HA  LEU A   7      -0.283   3.786  -4.416  1.00  0.04           H  
ATOM    125  HB2 LEU A   7       2.474   4.849  -5.003  1.00  0.05           H  
ATOM    126  HB3 LEU A   7       1.162   5.866  -4.420  1.00  0.08           H  
ATOM    127  HG  LEU A   7       1.461   3.383  -2.883  1.00  0.08           H  
ATOM    128 HD11 LEU A   7       3.712   5.425  -2.912  1.00  0.71           H  
ATOM    129 HD12 LEU A   7       3.535   4.137  -1.724  1.00  1.00           H  
ATOM    130 HD13 LEU A   7       3.840   3.742  -3.413  1.00  1.17           H  
ATOM    131 HD21 LEU A   7       0.064   5.322  -2.216  1.00  0.92           H  
ATOM    132 HD22 LEU A   7       1.308   4.993  -1.015  1.00  1.26           H  
ATOM    133 HD23 LEU A   7       1.505   6.329  -2.143  1.00  1.16           H  
ATOM    134  N   ASN A   8      -1.270   4.663  -6.491  1.00  0.03           N  
ATOM    135  CA  ASN A   8      -1.858   5.275  -7.711  1.00  0.04           C  
ATOM    136  C   ASN A   8      -2.326   6.704  -7.387  1.00  0.07           C  
ATOM    137  O   ASN A   8      -3.348   7.162  -7.858  1.00  0.07           O  
ATOM    138  CB  ASN A   8      -3.041   4.410  -8.158  1.00  0.03           C  
ATOM    139  CG  ASN A   8      -2.661   3.640  -9.413  1.00  0.03           C  
ATOM    140  OD1 ASN A   8      -2.151   4.191 -10.369  1.00  0.04           O  
ATOM    141  ND2 ASN A   8      -2.897   2.362  -9.450  1.00  0.04           N  
ATOM    142  H   ASN A   8      -1.861   4.340  -5.772  1.00  0.05           H  
ATOM    143  HA  ASN A   8      -1.120   5.309  -8.491  1.00  0.04           H  
ATOM    144  HB2 ASN A   8      -3.289   3.704  -7.383  1.00  0.04           H  
ATOM    145  HB3 ASN A   8      -3.896   5.023  -8.362  1.00  0.05           H  
ATOM    146 HD21 ASN A   8      -3.311   1.917  -8.679  1.00  0.04           H  
ATOM    147 HD22 ASN A   8      -2.661   1.847 -10.240  1.00  0.04           H  
ATOM    148  N   GLY A   9      -1.547   7.384  -6.596  1.00  0.09           N  
ATOM    149  CA  GLY A   9      -1.933   8.768  -6.213  1.00  0.12           C  
ATOM    150  C   GLY A   9      -2.096   9.639  -7.454  1.00  0.19           C  
ATOM    151  O   GLY A   9      -1.329   9.542  -8.392  1.00  0.31           O  
ATOM    152  H   GLY A   9      -0.709   6.994  -6.271  1.00  0.09           H  
ATOM    153  HA2 GLY A   9      -2.867   8.737  -5.680  1.00  0.06           H  
ATOM    154  HA3 GLY A   9      -1.175   9.191  -5.574  1.00  0.20           H  
ATOM    155  N   LYS A  10      -3.091  10.477  -7.430  1.00  0.15           N  
ATOM    156  CA  LYS A  10      -3.328  11.367  -8.602  1.00  0.25           C  
ATOM    157  C   LYS A  10      -2.218  12.411  -8.682  1.00  0.46           C  
ATOM    158  O   LYS A  10      -1.892  12.897  -9.748  1.00  0.70           O  
ATOM    159  CB  LYS A  10      -4.677  12.065  -8.440  1.00  0.13           C  
ATOM    160  CG  LYS A  10      -4.912  12.982  -9.642  1.00  1.21           C  
ATOM    161  CD  LYS A  10      -6.411  13.253  -9.781  1.00  1.06           C  
ATOM    162  CE  LYS A  10      -6.617  14.679 -10.298  1.00  2.12           C  
ATOM    163  NZ  LYS A  10      -6.531  15.656  -9.177  1.00  2.83           N  
ATOM    164  H   LYS A  10      -3.670  10.530  -6.643  1.00  0.07           H  
ATOM    165  HA  LYS A  10      -3.334  10.779  -9.504  1.00  0.45           H  
ATOM    166  HB2 LYS A  10      -5.464  11.327  -8.388  1.00  0.99           H  
ATOM    167  HB3 LYS A  10      -4.678  12.649  -7.532  1.00  0.80           H  
ATOM    168  HG2 LYS A  10      -4.386  13.915  -9.495  1.00  1.93           H  
ATOM    169  HG3 LYS A  10      -4.544  12.507 -10.538  1.00  1.86           H  
ATOM    170  HD2 LYS A  10      -6.844  12.549 -10.477  1.00  1.55           H  
ATOM    171  HD3 LYS A  10      -6.891  13.142  -8.820  1.00  0.45           H  
ATOM    172  HE2 LYS A  10      -5.857  14.912 -11.028  1.00  2.96           H  
ATOM    173  HE3 LYS A  10      -7.589  14.758 -10.762  1.00  2.35           H  
ATOM    174  HZ1 LYS A  10      -6.028  15.223  -8.378  1.00  2.83           H  
ATOM    175  HZ2 LYS A  10      -6.017  16.502  -9.493  1.00  3.86           H  
ATOM    176  HZ3 LYS A  10      -7.490  15.925  -8.878  1.00  2.91           H  
ATOM    177  N   THR A  11      -1.661  12.729  -7.546  1.00  0.54           N  
ATOM    178  CA  THR A  11      -0.566  13.734  -7.512  1.00  0.81           C  
ATOM    179  C   THR A  11       0.782  13.037  -7.310  1.00  0.61           C  
ATOM    180  O   THR A  11       1.820  13.664  -7.380  1.00  0.61           O  
ATOM    181  CB  THR A  11      -0.815  14.702  -6.354  1.00  1.17           C  
ATOM    182  OG1 THR A  11      -1.509  13.930  -5.380  1.00  1.13           O  
ATOM    183  CG2 THR A  11      -1.781  15.816  -6.751  1.00  1.36           C  
ATOM    184  H   THR A  11      -1.964  12.308  -6.715  1.00  0.55           H  
ATOM    185  HA  THR A  11      -0.550  14.283  -8.437  1.00  0.99           H  
ATOM    186  HB  THR A  11       0.100  15.099  -5.959  1.00  1.39           H  
ATOM    187  HG1 THR A  11      -0.876  13.344  -4.959  1.00  1.42           H  
ATOM    188 HG21 THR A  11      -1.394  16.345  -7.610  1.00  1.01           H  
ATOM    189 HG22 THR A  11      -2.744  15.394  -6.997  1.00  1.51           H  
ATOM    190 HG23 THR A  11      -1.895  16.508  -5.930  1.00  2.33           H  
ATOM    191  N   LEU A  12       0.744  11.751  -7.062  1.00  0.46           N  
ATOM    192  CA  LEU A  12       2.032  11.021  -6.849  1.00  0.31           C  
ATOM    193  C   LEU A  12       1.839   9.505  -6.991  1.00  0.31           C  
ATOM    194  O   LEU A  12       0.998   8.921  -6.340  1.00  0.58           O  
ATOM    195  CB  LEU A  12       2.550  11.337  -5.444  1.00  0.48           C  
ATOM    196  CG  LEU A  12       3.999  10.842  -5.304  1.00  0.48           C  
ATOM    197  CD1 LEU A  12       4.929  11.666  -6.208  1.00  0.93           C  
ATOM    198  CD2 LEU A  12       4.445  11.004  -3.850  1.00  0.91           C  
ATOM    199  H   LEU A  12      -0.120  11.273  -7.017  1.00  0.47           H  
ATOM    200  HA  LEU A  12       2.751  11.357  -7.575  1.00  0.15           H  
ATOM    201  HB2 LEU A  12       2.507  12.402  -5.269  1.00  0.57           H  
ATOM    202  HB3 LEU A  12       1.930  10.838  -4.713  1.00  0.58           H  
ATOM    203  HG  LEU A  12       4.053   9.800  -5.584  1.00  0.50           H  
ATOM    204 HD11 LEU A  12       4.486  12.628  -6.417  1.00  0.84           H  
ATOM    205 HD12 LEU A  12       5.879  11.813  -5.717  1.00  1.31           H  
ATOM    206 HD13 LEU A  12       5.088  11.142  -7.139  1.00  1.93           H  
ATOM    207 HD21 LEU A  12       3.785  10.445  -3.202  1.00  0.36           H  
ATOM    208 HD22 LEU A  12       5.453  10.636  -3.733  1.00  1.82           H  
ATOM    209 HD23 LEU A  12       4.413  12.048  -3.572  1.00  1.61           H  
ATOM    210  N   LYS A  13       2.636   8.905  -7.841  1.00  0.07           N  
ATOM    211  CA  LYS A  13       2.532   7.424  -8.044  1.00  0.04           C  
ATOM    212  C   LYS A  13       3.836   6.745  -7.604  1.00  0.06           C  
ATOM    213  O   LYS A  13       4.915   7.222  -7.900  1.00  0.15           O  
ATOM    214  CB  LYS A  13       2.278   7.135  -9.523  1.00  0.05           C  
ATOM    215  CG  LYS A  13       1.006   7.859  -9.968  1.00  0.18           C  
ATOM    216  CD  LYS A  13       1.302   8.653 -11.242  1.00  0.89           C  
ATOM    217  CE  LYS A  13       0.029   9.376 -11.689  1.00  1.32           C  
ATOM    218  NZ  LYS A  13      -0.210  10.581 -10.846  1.00  2.80           N  
ATOM    219  H   LYS A  13       3.300   9.423  -8.344  1.00  0.21           H  
ATOM    220  HA  LYS A  13       1.717   7.036  -7.461  1.00  0.06           H  
ATOM    221  HB2 LYS A  13       3.116   7.481 -10.109  1.00  0.05           H  
ATOM    222  HB3 LYS A  13       2.160   6.071  -9.669  1.00  0.14           H  
ATOM    223  HG2 LYS A  13       0.227   7.138 -10.162  1.00  0.40           H  
ATOM    224  HG3 LYS A  13       0.678   8.532  -9.189  1.00  0.45           H  
ATOM    225  HD2 LYS A  13       2.080   9.376 -11.047  1.00  1.69           H  
ATOM    226  HD3 LYS A  13       1.630   7.981 -12.020  1.00  1.06           H  
ATOM    227  HE2 LYS A  13       0.131   9.682 -12.720  1.00  1.59           H  
ATOM    228  HE3 LYS A  13      -0.816   8.709 -11.601  1.00  1.42           H  
ATOM    229  HZ1 LYS A  13       0.632  10.769 -10.264  1.00  3.40           H  
ATOM    230  HZ2 LYS A  13      -0.400  11.400 -11.457  1.00  3.28           H  
ATOM    231  HZ3 LYS A  13      -1.029  10.413 -10.227  1.00  3.32           H  
ATOM    232  N   GLY A  14       3.710   5.647  -6.910  1.00  0.04           N  
ATOM    233  CA  GLY A  14       4.935   4.936  -6.443  1.00  0.03           C  
ATOM    234  C   GLY A  14       4.626   3.470  -6.124  1.00  0.02           C  
ATOM    235  O   GLY A  14       3.622   2.935  -6.548  1.00  0.03           O  
ATOM    236  H   GLY A  14       2.821   5.292  -6.704  1.00  0.11           H  
ATOM    237  HA2 GLY A  14       5.688   4.981  -7.215  1.00  0.04           H  
ATOM    238  HA3 GLY A  14       5.309   5.421  -5.553  1.00  0.06           H  
ATOM    239  N   GLU A  15       5.505   2.854  -5.380  1.00  0.02           N  
ATOM    240  CA  GLU A  15       5.302   1.426  -5.020  1.00  0.04           C  
ATOM    241  C   GLU A  15       6.420   0.978  -4.069  1.00  0.03           C  
ATOM    242  O   GLU A  15       7.584   1.210  -4.328  1.00  0.08           O  
ATOM    243  CB  GLU A  15       5.332   0.574  -6.291  1.00  0.08           C  
ATOM    244  CG  GLU A  15       6.468   1.057  -7.194  1.00  0.31           C  
ATOM    245  CD  GLU A  15       7.150  -0.152  -7.837  1.00  0.61           C  
ATOM    246  OE1 GLU A  15       6.461  -0.832  -8.578  1.00  1.23           O  
ATOM    247  OE2 GLU A  15       8.322  -0.327  -7.549  1.00  1.66           O  
ATOM    248  H   GLU A  15       6.287   3.332  -5.046  1.00  0.01           H  
ATOM    249  HA  GLU A  15       4.349   1.313  -4.534  1.00  0.05           H  
ATOM    250  HB2 GLU A  15       5.492  -0.462  -6.030  1.00  0.10           H  
ATOM    251  HB3 GLU A  15       4.393   0.667  -6.812  1.00  0.27           H  
ATOM    252  HG2 GLU A  15       6.072   1.697  -7.970  1.00  1.02           H  
ATOM    253  HG3 GLU A  15       7.191   1.608  -6.613  1.00  0.91           H  
ATOM    254  N   THR A  16       6.049   0.349  -2.991  1.00  0.05           N  
ATOM    255  CA  THR A  16       7.093  -0.108  -2.021  1.00  0.05           C  
ATOM    256  C   THR A  16       6.657  -1.413  -1.351  1.00  0.06           C  
ATOM    257  O   THR A  16       5.483  -1.691  -1.243  1.00  0.14           O  
ATOM    258  CB  THR A  16       7.301   0.976  -0.958  1.00  0.07           C  
ATOM    259  OG1 THR A  16       8.443   0.548  -0.223  1.00  0.41           O  
ATOM    260  CG2 THR A  16       6.156   1.000   0.050  1.00  0.33           C  
ATOM    261  H   THR A  16       5.098   0.171  -2.821  1.00  0.10           H  
ATOM    262  HA  THR A  16       8.018  -0.271  -2.546  1.00  0.05           H  
ATOM    263  HB  THR A  16       7.458   1.945  -1.396  1.00  0.25           H  
ATOM    264  HG1 THR A  16       9.227   0.844  -0.694  1.00  1.30           H  
ATOM    265 HG21 THR A  16       5.244   0.674  -0.428  1.00  0.87           H  
ATOM    266 HG22 THR A  16       6.382   0.340   0.874  1.00  1.43           H  
ATOM    267 HG23 THR A  16       6.023   2.004   0.424  1.00  0.91           H  
ATOM    268  N   THR A  17       7.620  -2.182  -0.910  1.00  0.07           N  
ATOM    269  CA  THR A  17       7.282  -3.484  -0.257  1.00  0.08           C  
ATOM    270  C   THR A  17       7.455  -3.383   1.259  1.00  0.07           C  
ATOM    271  O   THR A  17       8.407  -2.799   1.740  1.00  0.07           O  
ATOM    272  CB  THR A  17       8.211  -4.574  -0.800  1.00  0.11           C  
ATOM    273  OG1 THR A  17       9.421  -4.417  -0.065  1.00  0.11           O  
ATOM    274  CG2 THR A  17       8.595  -4.318  -2.256  1.00  0.16           C  
ATOM    275  H   THR A  17       8.554  -1.907  -1.008  1.00  0.12           H  
ATOM    276  HA  THR A  17       6.264  -3.745  -0.479  1.00  0.09           H  
ATOM    277  HB  THR A  17       7.797  -5.558  -0.672  1.00  0.11           H  
ATOM    278  HG1 THR A  17       9.732  -5.291   0.181  1.00  0.65           H  
ATOM    279 HG21 THR A  17       7.847  -3.701  -2.729  1.00  0.99           H  
ATOM    280 HG22 THR A  17       9.549  -3.813  -2.297  1.00  1.26           H  
ATOM    281 HG23 THR A  17       8.667  -5.256  -2.784  1.00  1.09           H  
ATOM    282  N   THR A  18       6.522  -3.957   1.977  1.00  0.09           N  
ATOM    283  CA  THR A  18       6.601  -3.924   3.470  1.00  0.12           C  
ATOM    284  C   THR A  18       6.481  -5.344   4.034  1.00  0.10           C  
ATOM    285  O   THR A  18       5.771  -6.176   3.495  1.00  0.07           O  
ATOM    286  CB  THR A  18       5.455  -3.063   4.013  1.00  0.16           C  
ATOM    287  OG1 THR A  18       5.871  -2.693   5.324  1.00  0.21           O  
ATOM    288  CG2 THR A  18       4.183  -3.884   4.213  1.00  0.15           C  
ATOM    289  H   THR A  18       5.770  -4.406   1.536  1.00  0.09           H  
ATOM    290  HA  THR A  18       7.540  -3.498   3.774  1.00  0.17           H  
ATOM    291  HB  THR A  18       5.271  -2.198   3.400  1.00  0.19           H  
ATOM    292  HG1 THR A  18       5.812  -3.470   5.884  1.00  0.82           H  
ATOM    293 HG21 THR A  18       4.060  -4.572   3.392  1.00  1.32           H  
ATOM    294 HG22 THR A  18       4.250  -4.440   5.137  1.00  1.09           H  
ATOM    295 HG23 THR A  18       3.328  -3.225   4.257  1.00  1.23           H  
ATOM    296  N   GLU A  19       7.186  -5.593   5.103  1.00  0.14           N  
ATOM    297  CA  GLU A  19       7.122  -6.947   5.724  1.00  0.17           C  
ATOM    298  C   GLU A  19       5.975  -7.001   6.735  1.00  0.15           C  
ATOM    299  O   GLU A  19       5.926  -6.217   7.663  1.00  0.15           O  
ATOM    300  CB  GLU A  19       8.445  -7.237   6.435  1.00  0.22           C  
ATOM    301  CG  GLU A  19       9.188  -8.339   5.678  1.00  0.76           C  
ATOM    302  CD  GLU A  19      10.503  -8.646   6.398  1.00  1.03           C  
ATOM    303  OE1 GLU A  19      11.179  -7.684   6.724  1.00  1.46           O  
ATOM    304  OE2 GLU A  19      10.758  -9.825   6.580  1.00  1.62           O  
ATOM    305  H   GLU A  19       7.753  -4.896   5.496  1.00  0.16           H  
ATOM    306  HA  GLU A  19       6.960  -7.685   4.957  1.00  0.17           H  
ATOM    307  HB2 GLU A  19       9.048  -6.341   6.458  1.00  0.70           H  
ATOM    308  HB3 GLU A  19       8.249  -7.559   7.447  1.00  0.31           H  
ATOM    309  HG2 GLU A  19       8.583  -9.233   5.645  1.00  0.93           H  
ATOM    310  HG3 GLU A  19       9.400  -8.014   4.671  1.00  1.27           H  
ATOM    311  N   ALA A  20       5.072  -7.923   6.532  1.00  0.15           N  
ATOM    312  CA  ALA A  20       3.917  -8.043   7.471  1.00  0.15           C  
ATOM    313  C   ALA A  20       3.600  -9.519   7.736  1.00  0.16           C  
ATOM    314  O   ALA A  20       3.871 -10.372   6.914  1.00  0.24           O  
ATOM    315  CB  ALA A  20       2.698  -7.361   6.850  1.00  0.14           C  
ATOM    316  H   ALA A  20       5.153  -8.534   5.770  1.00  0.15           H  
ATOM    317  HA  ALA A  20       4.158  -7.559   8.402  1.00  0.15           H  
ATOM    318  HB1 ALA A  20       2.848  -7.242   5.788  1.00  1.02           H  
ATOM    319  HB2 ALA A  20       1.817  -7.963   7.020  1.00  0.88           H  
ATOM    320  HB3 ALA A  20       2.557  -6.389   7.299  1.00  1.07           H  
ATOM    321  N   VAL A  21       3.033  -9.786   8.880  1.00  0.09           N  
ATOM    322  CA  VAL A  21       2.696 -11.200   9.219  1.00  0.10           C  
ATOM    323  C   VAL A  21       1.298 -11.555   8.700  1.00  0.15           C  
ATOM    324  O   VAL A  21       1.016 -12.700   8.406  1.00  0.25           O  
ATOM    325  CB  VAL A  21       2.732 -11.371  10.737  1.00  0.08           C  
ATOM    326  CG1 VAL A  21       2.114 -10.136  11.397  1.00  0.55           C  
ATOM    327  CG2 VAL A  21       1.920 -12.609  11.124  1.00  0.59           C  
ATOM    328  H   VAL A  21       2.831  -9.065   9.512  1.00  0.09           H  
ATOM    329  HA  VAL A  21       3.421 -11.857   8.770  1.00  0.10           H  
ATOM    330  HB  VAL A  21       3.754 -11.488  11.066  1.00  0.32           H  
ATOM    331 HG11 VAL A  21       1.184  -9.888  10.908  1.00  1.02           H  
ATOM    332 HG12 VAL A  21       1.924 -10.337  12.441  1.00  0.72           H  
ATOM    333 HG13 VAL A  21       2.793  -9.301  11.314  1.00  1.61           H  
ATOM    334 HG21 VAL A  21       2.083 -13.394  10.401  1.00  0.87           H  
ATOM    335 HG22 VAL A  21       2.226 -12.955  12.100  1.00  0.77           H  
ATOM    336 HG23 VAL A  21       0.869 -12.362  11.148  1.00  1.61           H  
ATOM    337  N   ASP A  22       0.452 -10.563   8.598  1.00  0.10           N  
ATOM    338  CA  ASP A  22      -0.932 -10.828   8.101  1.00  0.15           C  
ATOM    339  C   ASP A  22      -1.413  -9.670   7.219  1.00  0.13           C  
ATOM    340  O   ASP A  22      -0.719  -8.689   7.043  1.00  0.20           O  
ATOM    341  CB  ASP A  22      -1.869 -10.980   9.297  1.00  0.18           C  
ATOM    342  CG  ASP A  22      -1.495  -9.952  10.365  1.00  0.52           C  
ATOM    343  OD1 ASP A  22      -0.809  -9.014   9.995  1.00  1.18           O  
ATOM    344  OD2 ASP A  22      -1.917 -10.162  11.491  1.00  0.99           O  
ATOM    345  H   ASP A  22       0.723  -9.656   8.845  1.00  0.04           H  
ATOM    346  HA  ASP A  22      -0.938 -11.739   7.528  1.00  0.20           H  
ATOM    347  HB2 ASP A  22      -2.889 -10.817   8.986  1.00  0.37           H  
ATOM    348  HB3 ASP A  22      -1.776 -11.973   9.711  1.00  0.54           H  
ATOM    349  N   ALA A  23      -2.595  -9.813   6.685  1.00  0.10           N  
ATOM    350  CA  ALA A  23      -3.141  -8.736   5.809  1.00  0.12           C  
ATOM    351  C   ALA A  23      -3.631  -7.554   6.654  1.00  0.12           C  
ATOM    352  O   ALA A  23      -3.426  -6.411   6.302  1.00  0.25           O  
ATOM    353  CB  ALA A  23      -4.309  -9.298   4.999  1.00  0.16           C  
ATOM    354  H   ALA A  23      -3.120 -10.622   6.859  1.00  0.13           H  
ATOM    355  HA  ALA A  23      -2.372  -8.399   5.136  1.00  0.13           H  
ATOM    356  HB1 ALA A  23      -4.858 -10.010   5.596  1.00  1.01           H  
ATOM    357  HB2 ALA A  23      -4.971  -8.495   4.707  1.00  1.21           H  
ATOM    358  HB3 ALA A  23      -3.934  -9.790   4.113  1.00  0.94           H  
ATOM    359  N   ALA A  24      -4.265  -7.857   7.753  1.00  0.16           N  
ATOM    360  CA  ALA A  24      -4.775  -6.760   8.626  1.00  0.13           C  
ATOM    361  C   ALA A  24      -3.646  -5.787   8.973  1.00  0.12           C  
ATOM    362  O   ALA A  24      -3.767  -4.594   8.772  1.00  0.20           O  
ATOM    363  CB  ALA A  24      -5.340  -7.365   9.910  1.00  0.15           C  
ATOM    364  H   ALA A  24      -4.404  -8.794   8.001  1.00  0.28           H  
ATOM    365  HA  ALA A  24      -5.555  -6.228   8.110  1.00  0.14           H  
ATOM    366  HB1 ALA A  24      -5.555  -8.412   9.756  1.00  1.08           H  
ATOM    367  HB2 ALA A  24      -4.621  -7.263  10.708  1.00  0.92           H  
ATOM    368  HB3 ALA A  24      -6.251  -6.852  10.185  1.00  1.17           H  
ATOM    369  N   THR A  25      -2.570  -6.314   9.488  1.00  0.10           N  
ATOM    370  CA  THR A  25      -1.429  -5.426   9.851  1.00  0.10           C  
ATOM    371  C   THR A  25      -0.835  -4.789   8.591  1.00  0.07           C  
ATOM    372  O   THR A  25      -0.263  -3.718   8.644  1.00  0.09           O  
ATOM    373  CB  THR A  25      -0.356  -6.249  10.570  1.00  0.16           C  
ATOM    374  OG1 THR A  25       0.392  -5.295  11.318  1.00  0.36           O  
ATOM    375  CG2 THR A  25       0.639  -6.859   9.588  1.00  0.17           C  
ATOM    376  H   THR A  25      -2.512  -7.282   9.633  1.00  0.15           H  
ATOM    377  HA  THR A  25      -1.779  -4.649  10.510  1.00  0.11           H  
ATOM    378  HB  THR A  25      -0.783  -6.999  11.211  1.00  0.39           H  
ATOM    379  HG1 THR A  25       0.770  -5.744  12.078  1.00  1.25           H  
ATOM    380 HG21 THR A  25       0.116  -7.218   8.714  1.00  1.12           H  
ATOM    381 HG22 THR A  25       1.359  -6.112   9.290  1.00  1.33           H  
ATOM    382 HG23 THR A  25       1.155  -7.684  10.056  1.00  0.97           H  
ATOM    383  N   ALA A  26      -0.985  -5.462   7.481  1.00  0.05           N  
ATOM    384  CA  ALA A  26      -0.439  -4.901   6.210  1.00  0.03           C  
ATOM    385  C   ALA A  26      -1.260  -3.680   5.783  1.00  0.03           C  
ATOM    386  O   ALA A  26      -0.722  -2.705   5.296  1.00  0.07           O  
ATOM    387  CB  ALA A  26      -0.504  -5.968   5.118  1.00  0.01           C  
ATOM    388  H   ALA A  26      -1.450  -6.325   7.482  1.00  0.05           H  
ATOM    389  HA  ALA A  26       0.585  -4.609   6.361  1.00  0.05           H  
ATOM    390  HB1 ALA A  26       0.025  -6.853   5.440  1.00  0.91           H  
ATOM    391  HB2 ALA A  26      -1.533  -6.221   4.918  1.00  0.88           H  
ATOM    392  HB3 ALA A  26      -0.048  -5.591   4.213  1.00  0.89           H  
ATOM    393  N   GLU A  27      -2.551  -3.758   5.979  1.00  0.07           N  
ATOM    394  CA  GLU A  27      -3.423  -2.613   5.594  1.00  0.08           C  
ATOM    395  C   GLU A  27      -3.030  -1.360   6.383  1.00  0.09           C  
ATOM    396  O   GLU A  27      -3.055  -0.263   5.864  1.00  0.19           O  
ATOM    397  CB  GLU A  27      -4.875  -2.971   5.904  1.00  0.12           C  
ATOM    398  CG  GLU A  27      -5.359  -4.035   4.916  1.00  0.21           C  
ATOM    399  CD  GLU A  27      -6.864  -4.243   5.096  1.00  0.20           C  
ATOM    400  OE1 GLU A  27      -7.366  -3.740   6.088  1.00  1.09           O  
ATOM    401  OE2 GLU A  27      -7.428  -4.894   4.232  1.00  1.51           O  
ATOM    402  H   GLU A  27      -2.944  -4.563   6.376  1.00  0.10           H  
ATOM    403  HA  GLU A  27      -3.319  -2.421   4.540  1.00  0.07           H  
ATOM    404  HB2 GLU A  27      -4.946  -3.354   6.911  1.00  0.08           H  
ATOM    405  HB3 GLU A  27      -5.488  -2.091   5.817  1.00  0.24           H  
ATOM    406  HG2 GLU A  27      -5.163  -3.712   3.905  1.00  0.37           H  
ATOM    407  HG3 GLU A  27      -4.846  -4.966   5.100  1.00  0.27           H  
ATOM    408  N   LYS A  28      -2.676  -1.554   7.624  1.00  0.11           N  
ATOM    409  CA  LYS A  28      -2.284  -0.384   8.466  1.00  0.10           C  
ATOM    410  C   LYS A  28      -0.830   0.013   8.191  1.00  0.10           C  
ATOM    411  O   LYS A  28      -0.510   1.182   8.106  1.00  0.13           O  
ATOM    412  CB  LYS A  28      -2.441  -0.760   9.939  1.00  0.14           C  
ATOM    413  CG  LYS A  28      -3.920  -1.040  10.228  1.00  1.25           C  
ATOM    414  CD  LYS A  28      -4.039  -2.265  11.142  1.00  1.53           C  
ATOM    415  CE  LYS A  28      -3.333  -1.981  12.471  1.00  0.62           C  
ATOM    416  NZ  LYS A  28      -3.922  -2.810  13.561  1.00  1.47           N  
ATOM    417  H   LYS A  28      -2.669  -2.460   8.001  1.00  0.19           H  
ATOM    418  HA  LYS A  28      -2.929   0.446   8.242  1.00  0.09           H  
ATOM    419  HB2 LYS A  28      -1.853  -1.640  10.153  1.00  1.07           H  
ATOM    420  HB3 LYS A  28      -2.097   0.054  10.559  1.00  0.91           H  
ATOM    421  HG2 LYS A  28      -4.363  -0.182  10.712  1.00  1.80           H  
ATOM    422  HG3 LYS A  28      -4.439  -1.229   9.301  1.00  2.07           H  
ATOM    423  HD2 LYS A  28      -5.081  -2.479  11.326  1.00  2.62           H  
ATOM    424  HD3 LYS A  28      -3.583  -3.122  10.665  1.00  2.06           H  
ATOM    425  HE2 LYS A  28      -2.282  -2.212  12.382  1.00  0.58           H  
ATOM    426  HE3 LYS A  28      -3.443  -0.936  12.726  1.00  1.64           H  
ATOM    427  HZ1 LYS A  28      -4.765  -3.304  13.202  1.00  2.38           H  
ATOM    428  HZ2 LYS A  28      -3.221  -3.508  13.882  1.00  1.62           H  
ATOM    429  HZ3 LYS A  28      -4.192  -2.197  14.356  1.00  1.96           H  
ATOM    430  N   VAL A  29       0.020  -0.967   8.055  1.00  0.08           N  
ATOM    431  CA  VAL A  29       1.454  -0.658   7.790  1.00  0.09           C  
ATOM    432  C   VAL A  29       1.586   0.215   6.541  1.00  0.07           C  
ATOM    433  O   VAL A  29       2.161   1.286   6.587  1.00  0.09           O  
ATOM    434  CB  VAL A  29       2.214  -1.964   7.579  1.00  0.12           C  
ATOM    435  CG1 VAL A  29       3.578  -1.659   6.958  1.00  0.19           C  
ATOM    436  CG2 VAL A  29       2.418  -2.653   8.930  1.00  0.18           C  
ATOM    437  H   VAL A  29      -0.283  -1.896   8.124  1.00  0.09           H  
ATOM    438  HA  VAL A  29       1.871  -0.137   8.636  1.00  0.10           H  
ATOM    439  HB  VAL A  29       1.653  -2.608   6.922  1.00  0.07           H  
ATOM    440 HG11 VAL A  29       3.995  -0.772   7.412  1.00  0.84           H  
ATOM    441 HG12 VAL A  29       4.247  -2.490   7.121  1.00  0.90           H  
ATOM    442 HG13 VAL A  29       3.467  -1.496   5.896  1.00  1.15           H  
ATOM    443 HG21 VAL A  29       1.551  -2.494   9.555  1.00  0.88           H  
ATOM    444 HG22 VAL A  29       2.559  -3.713   8.781  1.00  1.08           H  
ATOM    445 HG23 VAL A  29       3.289  -2.244   9.420  1.00  1.19           H  
ATOM    446  N   PHE A  30       1.050  -0.256   5.449  1.00  0.08           N  
ATOM    447  CA  PHE A  30       1.141   0.545   4.194  1.00  0.09           C  
ATOM    448  C   PHE A  30       0.382   1.867   4.361  1.00  0.10           C  
ATOM    449  O   PHE A  30       0.865   2.914   3.979  1.00  0.10           O  
ATOM    450  CB  PHE A  30       0.530  -0.246   3.033  1.00  0.10           C  
ATOM    451  CG  PHE A  30       1.575  -1.192   2.420  1.00  0.09           C  
ATOM    452  CD1 PHE A  30       2.739  -0.693   1.855  1.00  0.09           C  
ATOM    453  CD2 PHE A  30       1.366  -2.561   2.419  1.00  0.10           C  
ATOM    454  CE1 PHE A  30       3.672  -1.552   1.302  1.00  0.09           C  
ATOM    455  CE2 PHE A  30       2.301  -3.411   1.864  1.00  0.09           C  
ATOM    456  CZ  PHE A  30       3.450  -2.906   1.305  1.00  0.09           C  
ATOM    457  H   PHE A  30       0.590  -1.122   5.454  1.00  0.09           H  
ATOM    458  HA  PHE A  30       2.174   0.754   3.983  1.00  0.11           H  
ATOM    459  HB2 PHE A  30      -0.308  -0.827   3.392  1.00  0.10           H  
ATOM    460  HB3 PHE A  30       0.186   0.437   2.272  1.00  0.09           H  
ATOM    461  HD1 PHE A  30       2.916   0.370   1.837  1.00  0.09           H  
ATOM    462  HD2 PHE A  30       0.466  -2.967   2.857  1.00  0.10           H  
ATOM    463  HE1 PHE A  30       4.577  -1.157   0.869  1.00  0.09           H  
ATOM    464  HE2 PHE A  30       2.131  -4.472   1.871  1.00  0.10           H  
ATOM    465  HZ  PHE A  30       4.174  -3.577   0.856  1.00  0.09           H  
ATOM    466  N   LYS A  31      -0.795   1.793   4.925  1.00  0.16           N  
ATOM    467  CA  LYS A  31      -1.587   3.044   5.117  1.00  0.18           C  
ATOM    468  C   LYS A  31      -0.747   4.076   5.867  1.00  0.19           C  
ATOM    469  O   LYS A  31      -0.817   5.257   5.592  1.00  0.21           O  
ATOM    470  CB  LYS A  31      -2.848   2.726   5.919  1.00  0.17           C  
ATOM    471  CG  LYS A  31      -3.645   4.016   6.130  1.00  0.14           C  
ATOM    472  CD  LYS A  31      -5.115   3.761   5.786  1.00  1.15           C  
ATOM    473  CE  LYS A  31      -5.949   4.968   6.222  1.00  1.23           C  
ATOM    474  NZ  LYS A  31      -6.192   4.932   7.691  1.00  0.64           N  
ATOM    475  H   LYS A  31      -1.151   0.929   5.222  1.00  0.21           H  
ATOM    476  HA  LYS A  31      -1.865   3.441   4.158  1.00  0.19           H  
ATOM    477  HB2 LYS A  31      -3.450   2.011   5.378  1.00  0.19           H  
ATOM    478  HB3 LYS A  31      -2.573   2.309   6.874  1.00  0.20           H  
ATOM    479  HG2 LYS A  31      -3.564   4.329   7.161  1.00  0.90           H  
ATOM    480  HG3 LYS A  31      -3.253   4.794   5.492  1.00  0.66           H  
ATOM    481  HD2 LYS A  31      -5.217   3.615   4.720  1.00  2.00           H  
ATOM    482  HD3 LYS A  31      -5.459   2.877   6.300  1.00  1.51           H  
ATOM    483  HE2 LYS A  31      -5.423   5.879   5.974  1.00  1.79           H  
ATOM    484  HE3 LYS A  31      -6.898   4.957   5.707  1.00  2.08           H  
ATOM    485  HZ1 LYS A  31      -6.550   3.993   7.960  1.00  1.01           H  
ATOM    486  HZ2 LYS A  31      -5.302   5.121   8.196  1.00  0.93           H  
ATOM    487  HZ3 LYS A  31      -6.894   5.657   7.945  1.00  1.49           H  
ATOM    488  N   GLN A  32       0.032   3.607   6.802  1.00  0.19           N  
ATOM    489  CA  GLN A  32       0.893   4.545   7.573  1.00  0.20           C  
ATOM    490  C   GLN A  32       1.953   5.149   6.649  1.00  0.15           C  
ATOM    491  O   GLN A  32       2.423   6.247   6.871  1.00  0.12           O  
ATOM    492  CB  GLN A  32       1.572   3.777   8.708  1.00  0.24           C  
ATOM    493  CG  GLN A  32       2.204   4.772   9.684  1.00  0.44           C  
ATOM    494  CD  GLN A  32       1.168   5.171  10.737  1.00  2.29           C  
ATOM    495  OE1 GLN A  32       0.520   4.335  11.334  1.00  3.07           O  
ATOM    496  NE2 GLN A  32       0.984   6.437  10.996  1.00  3.37           N  
ATOM    497  H   GLN A  32       0.050   2.647   6.994  1.00  0.18           H  
ATOM    498  HA  GLN A  32       0.286   5.332   7.986  1.00  0.22           H  
ATOM    499  HB2 GLN A  32       0.841   3.175   9.227  1.00  0.31           H  
ATOM    500  HB3 GLN A  32       2.338   3.130   8.302  1.00  0.15           H  
ATOM    501  HG2 GLN A  32       3.052   4.318  10.172  1.00  1.24           H  
ATOM    502  HG3 GLN A  32       2.528   5.653   9.150  1.00  0.97           H  
ATOM    503 HE21 GLN A  32       1.504   7.116  10.517  1.00  3.23           H  
ATOM    504 HE22 GLN A  32       0.323   6.709  11.668  1.00  4.53           H  
ATOM    505  N   TYR A  33       2.304   4.415   5.627  1.00  0.16           N  
ATOM    506  CA  TYR A  33       3.327   4.930   4.671  1.00  0.12           C  
ATOM    507  C   TYR A  33       2.683   5.926   3.699  1.00  0.16           C  
ATOM    508  O   TYR A  33       3.134   7.047   3.566  1.00  0.22           O  
ATOM    509  CB  TYR A  33       3.914   3.756   3.887  1.00  0.13           C  
ATOM    510  CG  TYR A  33       4.859   4.292   2.809  1.00  0.14           C  
ATOM    511  CD1 TYR A  33       4.357   4.767   1.615  1.00  0.22           C  
ATOM    512  CD2 TYR A  33       6.223   4.309   3.016  1.00  0.10           C  
ATOM    513  CE1 TYR A  33       5.206   5.250   0.641  1.00  0.24           C  
ATOM    514  CE2 TYR A  33       7.072   4.793   2.042  1.00  0.13           C  
ATOM    515  CZ  TYR A  33       6.570   5.267   0.847  1.00  0.20           C  
ATOM    516  OH  TYR A  33       7.419   5.752  -0.127  1.00  0.23           O  
ATOM    517  H   TYR A  33       1.902   3.533   5.491  1.00  0.20           H  
ATOM    518  HA  TYR A  33       4.110   5.420   5.216  1.00  0.14           H  
ATOM    519  HB2 TYR A  33       4.463   3.107   4.552  1.00  0.11           H  
ATOM    520  HB3 TYR A  33       3.121   3.196   3.417  1.00  0.19           H  
ATOM    521  HD1 TYR A  33       3.292   4.759   1.440  1.00  0.25           H  
ATOM    522  HD2 TYR A  33       6.628   3.941   3.947  1.00  0.07           H  
ATOM    523  HE1 TYR A  33       4.799   5.619  -0.288  1.00  0.30           H  
ATOM    524  HE2 TYR A  33       8.138   4.801   2.216  1.00  0.09           H  
ATOM    525  HH  TYR A  33       8.021   5.047  -0.374  1.00  1.05           H  
ATOM    526  N   ALA A  34       1.644   5.494   3.044  1.00  0.15           N  
ATOM    527  CA  ALA A  34       0.953   6.402   2.079  1.00  0.20           C  
ATOM    528  C   ALA A  34       0.657   7.751   2.744  1.00  0.24           C  
ATOM    529  O   ALA A  34       0.612   8.773   2.088  1.00  0.31           O  
ATOM    530  CB  ALA A  34      -0.359   5.755   1.638  1.00  0.20           C  
ATOM    531  H   ALA A  34       1.319   4.580   3.181  1.00  0.15           H  
ATOM    532  HA  ALA A  34       1.580   6.557   1.218  1.00  0.25           H  
ATOM    533  HB1 ALA A  34      -0.517   4.840   2.189  1.00  1.13           H  
ATOM    534  HB2 ALA A  34      -1.180   6.430   1.827  1.00  0.95           H  
ATOM    535  HB3 ALA A  34      -0.319   5.532   0.583  1.00  1.20           H  
ATOM    536  N   ASN A  35       0.462   7.722   4.033  1.00  0.20           N  
ATOM    537  CA  ASN A  35       0.167   8.991   4.759  1.00  0.27           C  
ATOM    538  C   ASN A  35       1.380   9.926   4.708  1.00  0.24           C  
ATOM    539  O   ASN A  35       1.237  11.132   4.665  1.00  0.22           O  
ATOM    540  CB  ASN A  35      -0.164   8.667   6.214  1.00  0.31           C  
ATOM    541  CG  ASN A  35      -0.709   9.921   6.902  1.00  0.44           C  
ATOM    542  OD1 ASN A  35      -1.766  10.417   6.564  1.00  1.29           O  
ATOM    543  ND2 ASN A  35      -0.019  10.464   7.867  1.00  0.71           N  
ATOM    544  H   ASN A  35       0.509   6.874   4.521  1.00  0.14           H  
ATOM    545  HA  ASN A  35      -0.679   9.477   4.301  1.00  0.36           H  
ATOM    546  HB2 ASN A  35      -0.908   7.886   6.256  1.00  0.34           H  
ATOM    547  HB3 ASN A  35       0.728   8.338   6.728  1.00  0.25           H  
ATOM    548 HD21 ASN A  35       0.833  10.068   8.143  1.00  1.41           H  
ATOM    549 HD22 ASN A  35      -0.355  11.269   8.317  1.00  0.71           H  
ATOM    550  N   ASP A  36       2.550   9.348   4.712  1.00  0.28           N  
ATOM    551  CA  ASP A  36       3.783  10.189   4.667  1.00  0.28           C  
ATOM    552  C   ASP A  36       3.931  10.850   3.290  1.00  0.25           C  
ATOM    553  O   ASP A  36       4.925  11.495   3.017  1.00  0.24           O  
ATOM    554  CB  ASP A  36       5.000   9.308   4.943  1.00  0.36           C  
ATOM    555  CG  ASP A  36       5.120   9.070   6.450  1.00  0.39           C  
ATOM    556  OD1 ASP A  36       5.364  10.050   7.134  1.00  0.76           O  
ATOM    557  OD2 ASP A  36       4.962   7.922   6.831  1.00  1.45           O  
ATOM    558  H   ASP A  36       2.618   8.370   4.747  1.00  0.32           H  
ATOM    559  HA  ASP A  36       3.721  10.953   5.423  1.00  0.29           H  
ATOM    560  HB2 ASP A  36       4.886   8.359   4.440  1.00  0.39           H  
ATOM    561  HB3 ASP A  36       5.894   9.796   4.585  1.00  0.38           H  
ATOM    562  N   ASN A  37       2.938  10.669   2.455  1.00  0.26           N  
ATOM    563  CA  ASN A  37       2.994  11.281   1.088  1.00  0.26           C  
ATOM    564  C   ASN A  37       1.689  12.026   0.786  1.00  0.26           C  
ATOM    565  O   ASN A  37       1.669  12.953   0.000  1.00  0.29           O  
ATOM    566  CB  ASN A  37       3.199  10.177   0.051  1.00  0.34           C  
ATOM    567  CG  ASN A  37       4.568   9.529   0.265  1.00  0.23           C  
ATOM    568  OD1 ASN A  37       5.472   9.685  -0.532  1.00  0.36           O  
ATOM    569  ND2 ASN A  37       4.764   8.797   1.327  1.00  0.13           N  
ATOM    570  H   ASN A  37       2.164  10.134   2.722  1.00  0.29           H  
ATOM    571  HA  ASN A  37       3.816  11.973   1.033  1.00  0.22           H  
ATOM    572  HB2 ASN A  37       2.429   9.428   0.158  1.00  0.42           H  
ATOM    573  HB3 ASN A  37       3.153  10.596  -0.943  1.00  0.45           H  
ATOM    574 HD21 ASN A  37       4.038   8.667   1.974  1.00  0.25           H  
ATOM    575 HD22 ASN A  37       5.636   8.376   1.479  1.00  0.14           H  
ATOM    576  N   GLY A  38       0.625  11.602   1.419  1.00  0.23           N  
ATOM    577  CA  GLY A  38      -0.687  12.271   1.186  1.00  0.23           C  
ATOM    578  C   GLY A  38      -1.547  11.445   0.227  1.00  0.22           C  
ATOM    579  O   GLY A  38      -2.058  11.960  -0.750  1.00  0.50           O  
ATOM    580  H   GLY A  38       0.691  10.849   2.041  1.00  0.21           H  
ATOM    581  HA2 GLY A  38      -1.205  12.375   2.129  1.00  0.22           H  
ATOM    582  HA3 GLY A  38      -0.522  13.251   0.763  1.00  0.24           H  
ATOM    583  N   VAL A  39      -1.686  10.178   0.529  1.00  0.10           N  
ATOM    584  CA  VAL A  39      -2.512   9.285  -0.346  1.00  0.14           C  
ATOM    585  C   VAL A  39      -3.556   8.544   0.497  1.00  0.23           C  
ATOM    586  O   VAL A  39      -3.275   7.503   1.059  1.00  0.35           O  
ATOM    587  CB  VAL A  39      -1.594   8.269  -1.028  1.00  0.27           C  
ATOM    588  CG1 VAL A  39      -2.384   7.521  -2.105  1.00  0.13           C  
ATOM    589  CG2 VAL A  39      -0.426   9.009  -1.683  1.00  0.44           C  
ATOM    590  H   VAL A  39      -1.248   9.814   1.327  1.00  0.31           H  
ATOM    591  HA  VAL A  39      -3.012   9.873  -1.095  1.00  0.07           H  
ATOM    592  HB  VAL A  39      -1.218   7.568  -0.297  1.00  0.45           H  
ATOM    593 HG11 VAL A  39      -3.236   7.031  -1.658  1.00  1.17           H  
ATOM    594 HG12 VAL A  39      -2.729   8.217  -2.854  1.00  1.06           H  
ATOM    595 HG13 VAL A  39      -1.752   6.780  -2.572  1.00  0.99           H  
ATOM    596 HG21 VAL A  39      -0.799   9.835  -2.269  1.00  0.64           H  
ATOM    597 HG22 VAL A  39       0.240   9.388  -0.920  1.00  1.41           H  
ATOM    598 HG23 VAL A  39       0.119   8.333  -2.326  1.00  1.22           H  
ATOM    599  N   ASP A  40      -4.740   9.103   0.564  1.00  0.26           N  
ATOM    600  CA  ASP A  40      -5.824   8.454   1.367  1.00  0.41           C  
ATOM    601  C   ASP A  40      -7.124   8.402   0.557  1.00  0.31           C  
ATOM    602  O   ASP A  40      -7.668   9.423   0.185  1.00  0.37           O  
ATOM    603  CB  ASP A  40      -6.054   9.264   2.645  1.00  0.68           C  
ATOM    604  CG  ASP A  40      -4.760   9.302   3.459  1.00  0.90           C  
ATOM    605  OD1 ASP A  40      -3.758   9.669   2.866  1.00  1.60           O  
ATOM    606  OD2 ASP A  40      -4.846   8.963   4.628  1.00  1.48           O  
ATOM    607  H   ASP A  40      -4.915   9.943   0.090  1.00  0.24           H  
ATOM    608  HA  ASP A  40      -5.531   7.453   1.630  1.00  0.48           H  
ATOM    609  HB2 ASP A  40      -6.347  10.271   2.392  1.00  0.83           H  
ATOM    610  HB3 ASP A  40      -6.833   8.802   3.236  1.00  0.63           H  
ATOM    611  N   GLY A  41      -7.591   7.211   0.301  1.00  0.22           N  
ATOM    612  CA  GLY A  41      -8.853   7.068  -0.477  1.00  0.27           C  
ATOM    613  C   GLY A  41      -9.340   5.619  -0.431  1.00  0.10           C  
ATOM    614  O   GLY A  41      -9.765   5.139   0.601  1.00  0.15           O  
ATOM    615  H   GLY A  41      -7.113   6.416   0.617  1.00  0.20           H  
ATOM    616  HA2 GLY A  41      -9.610   7.712  -0.055  1.00  0.46           H  
ATOM    617  HA3 GLY A  41      -8.674   7.353  -1.505  1.00  0.35           H  
ATOM    618  N   GLU A  42      -9.264   4.954  -1.552  1.00  0.18           N  
ATOM    619  CA  GLU A  42      -9.709   3.531  -1.593  1.00  0.19           C  
ATOM    620  C   GLU A  42      -8.494   2.613  -1.499  1.00  0.15           C  
ATOM    621  O   GLU A  42      -7.429   2.953  -1.972  1.00  0.17           O  
ATOM    622  CB  GLU A  42     -10.431   3.272  -2.906  1.00  0.38           C  
ATOM    623  CG  GLU A  42     -11.548   4.303  -3.078  1.00  0.46           C  
ATOM    624  CD  GLU A  42     -12.883   3.576  -3.246  1.00  1.51           C  
ATOM    625  OE1 GLU A  42     -13.447   3.234  -2.219  1.00  2.54           O  
ATOM    626  OE2 GLU A  42     -13.264   3.401  -4.392  1.00  1.65           O  
ATOM    627  H   GLU A  42      -8.912   5.384  -2.360  1.00  0.33           H  
ATOM    628  HA  GLU A  42     -10.375   3.334  -0.771  1.00  0.19           H  
ATOM    629  HB2 GLU A  42      -9.730   3.355  -3.718  1.00  0.41           H  
ATOM    630  HB3 GLU A  42     -10.851   2.277  -2.898  1.00  0.46           H  
ATOM    631  HG2 GLU A  42     -11.596   4.940  -2.208  1.00  0.70           H  
ATOM    632  HG3 GLU A  42     -11.357   4.906  -3.953  1.00  0.59           H  
ATOM    633  N   TRP A  43      -8.683   1.467  -0.900  1.00  0.15           N  
ATOM    634  CA  TRP A  43      -7.542   0.512  -0.748  1.00  0.12           C  
ATOM    635  C   TRP A  43      -7.907  -0.857  -1.319  1.00  0.11           C  
ATOM    636  O   TRP A  43      -8.997  -1.349  -1.110  1.00  0.12           O  
ATOM    637  CB  TRP A  43      -7.218   0.382   0.733  1.00  0.12           C  
ATOM    638  CG  TRP A  43      -6.394   1.598   1.156  1.00  0.12           C  
ATOM    639  CD1 TRP A  43      -6.911   2.813   1.299  1.00  0.15           C  
ATOM    640  CD2 TRP A  43      -5.085   1.607   1.395  1.00  0.11           C  
ATOM    641  NE1 TRP A  43      -5.858   3.570   1.641  1.00  0.14           N  
ATOM    642  CE2 TRP A  43      -4.668   2.889   1.723  1.00  0.12           C  
ATOM    643  CE3 TRP A  43      -4.142   0.582   1.351  1.00  0.11           C  
ATOM    644  CZ2 TRP A  43      -3.341   3.143   2.001  1.00  0.13           C  
ATOM    645  CZ3 TRP A  43      -2.816   0.846   1.629  1.00  0.12           C  
ATOM    646  CH2 TRP A  43      -2.417   2.122   1.953  1.00  0.13           C  
ATOM    647  H   TRP A  43      -9.569   1.234  -0.550  1.00  0.19           H  
ATOM    648  HA  TRP A  43      -6.679   0.892  -1.266  1.00  0.12           H  
ATOM    649  HB2 TRP A  43      -8.135   0.365   1.303  1.00  0.13           H  
ATOM    650  HB3 TRP A  43      -6.670  -0.522   0.914  1.00  0.10           H  
ATOM    651  HD1 TRP A  43      -7.928   3.128   1.105  1.00  0.17           H  
ATOM    652  HE1 TRP A  43      -5.933   4.531   1.817  1.00  0.16           H  
ATOM    653  HE3 TRP A  43      -4.438  -0.419   1.095  1.00  0.11           H  
ATOM    654  HZ2 TRP A  43      -3.026   4.144   2.253  1.00  0.14           H  
ATOM    655  HZ3 TRP A  43      -2.090   0.046   1.594  1.00  0.14           H  
ATOM    656  HH2 TRP A  43      -1.377   2.325   2.164  1.00  0.15           H  
ATOM    657  N   THR A  44      -6.973  -1.439  -2.031  1.00  0.08           N  
ATOM    658  CA  THR A  44      -7.227  -2.783  -2.638  1.00  0.08           C  
ATOM    659  C   THR A  44      -6.178  -3.797  -2.162  1.00  0.07           C  
ATOM    660  O   THR A  44      -5.164  -3.437  -1.599  1.00  0.13           O  
ATOM    661  CB  THR A  44      -7.164  -2.662  -4.163  1.00  0.08           C  
ATOM    662  OG1 THR A  44      -6.081  -1.772  -4.414  1.00  0.06           O  
ATOM    663  CG2 THR A  44      -8.399  -1.961  -4.721  1.00  0.18           C  
ATOM    664  H   THR A  44      -6.112  -0.991  -2.169  1.00  0.07           H  
ATOM    665  HA  THR A  44      -8.205  -3.128  -2.354  1.00  0.10           H  
ATOM    666  HB  THR A  44      -7.007  -3.613  -4.638  1.00  0.16           H  
ATOM    667  HG1 THR A  44      -5.314  -2.095  -3.935  1.00  0.98           H  
ATOM    668 HG21 THR A  44      -8.519  -0.999  -4.245  1.00  0.92           H  
ATOM    669 HG22 THR A  44      -8.288  -1.819  -5.785  1.00  1.22           H  
ATOM    670 HG23 THR A  44      -9.277  -2.563  -4.532  1.00  1.29           H  
ATOM    671  N   TYR A  45      -6.459  -5.048  -2.402  1.00  0.10           N  
ATOM    672  CA  TYR A  45      -5.513  -6.125  -1.983  1.00  0.08           C  
ATOM    673  C   TYR A  45      -5.469  -7.199  -3.076  1.00  0.09           C  
ATOM    674  O   TYR A  45      -6.494  -7.703  -3.491  1.00  0.09           O  
ATOM    675  CB  TYR A  45      -6.031  -6.732  -0.665  1.00  0.05           C  
ATOM    676  CG  TYR A  45      -4.926  -7.526   0.085  1.00  0.04           C  
ATOM    677  CD1 TYR A  45      -4.212  -8.556  -0.521  1.00  0.04           C  
ATOM    678  CD2 TYR A  45      -4.638  -7.216   1.397  1.00  0.05           C  
ATOM    679  CE1 TYR A  45      -3.238  -9.239   0.179  1.00  0.05           C  
ATOM    680  CE2 TYR A  45      -3.667  -7.906   2.091  1.00  0.05           C  
ATOM    681  CZ  TYR A  45      -2.960  -8.919   1.487  1.00  0.05           C  
ATOM    682  OH  TYR A  45      -1.991  -9.608   2.187  1.00  0.07           O  
ATOM    683  H   TYR A  45      -7.295  -5.281  -2.856  1.00  0.17           H  
ATOM    684  HA  TYR A  45      -4.528  -5.713  -1.832  1.00  0.08           H  
ATOM    685  HB2 TYR A  45      -6.374  -5.924  -0.021  1.00  0.06           H  
ATOM    686  HB3 TYR A  45      -6.862  -7.390  -0.874  1.00  0.05           H  
ATOM    687  HD1 TYR A  45      -4.434  -8.850  -1.525  1.00  0.05           H  
ATOM    688  HD2 TYR A  45      -5.179  -6.429   1.886  1.00  0.06           H  
ATOM    689  HE1 TYR A  45      -2.681 -10.027  -0.307  1.00  0.06           H  
ATOM    690  HE2 TYR A  45      -3.467  -7.656   3.121  1.00  0.06           H  
ATOM    691  HH  TYR A  45      -2.428 -10.273   2.726  1.00  0.91           H  
ATOM    692  N   ASP A  46      -4.281  -7.521  -3.518  1.00  0.09           N  
ATOM    693  CA  ASP A  46      -4.140  -8.568  -4.578  1.00  0.11           C  
ATOM    694  C   ASP A  46      -3.585  -9.862  -3.967  1.00  0.12           C  
ATOM    695  O   ASP A  46      -2.436 -10.204  -4.164  1.00  0.19           O  
ATOM    696  CB  ASP A  46      -3.179  -8.065  -5.651  1.00  0.15           C  
ATOM    697  CG  ASP A  46      -3.376  -8.880  -6.931  1.00  0.22           C  
ATOM    698  OD1 ASP A  46      -4.019  -9.912  -6.822  1.00  0.18           O  
ATOM    699  OD2 ASP A  46      -2.873  -8.425  -7.944  1.00  0.43           O  
ATOM    700  H   ASP A  46      -3.485  -7.078  -3.156  1.00  0.08           H  
ATOM    701  HA  ASP A  46      -5.101  -8.766  -5.024  1.00  0.10           H  
ATOM    702  HB2 ASP A  46      -3.373  -7.024  -5.857  1.00  0.16           H  
ATOM    703  HB3 ASP A  46      -2.164  -8.179  -5.310  1.00  0.14           H  
ATOM    704  N   ASP A  47      -4.414 -10.555  -3.237  1.00  0.14           N  
ATOM    705  CA  ASP A  47      -3.946 -11.823  -2.604  1.00  0.19           C  
ATOM    706  C   ASP A  47      -3.623 -12.870  -3.678  1.00  0.25           C  
ATOM    707  O   ASP A  47      -3.309 -14.003  -3.371  1.00  0.38           O  
ATOM    708  CB  ASP A  47      -5.042 -12.358  -1.683  1.00  0.23           C  
ATOM    709  CG  ASP A  47      -4.449 -13.419  -0.754  1.00  0.60           C  
ATOM    710  OD1 ASP A  47      -3.420 -13.116  -0.173  1.00  1.50           O  
ATOM    711  OD2 ASP A  47      -5.057 -14.474  -0.679  1.00  0.79           O  
ATOM    712  H   ASP A  47      -5.336 -10.247  -3.106  1.00  0.17           H  
ATOM    713  HA  ASP A  47      -3.061 -11.625  -2.022  1.00  0.17           H  
ATOM    714  HB2 ASP A  47      -5.447 -11.551  -1.090  1.00  0.30           H  
ATOM    715  HB3 ASP A  47      -5.833 -12.800  -2.272  1.00  0.28           H  
ATOM    716  N   ALA A  48      -3.705 -12.467  -4.917  1.00  0.19           N  
ATOM    717  CA  ALA A  48      -3.405 -13.427  -6.021  1.00  0.25           C  
ATOM    718  C   ALA A  48      -1.906 -13.419  -6.342  1.00  0.19           C  
ATOM    719  O   ALA A  48      -1.385 -14.362  -6.903  1.00  0.19           O  
ATOM    720  CB  ALA A  48      -4.192 -13.019  -7.265  1.00  0.31           C  
ATOM    721  H   ALA A  48      -3.963 -11.544  -5.122  1.00  0.18           H  
ATOM    722  HA  ALA A  48      -3.702 -14.418  -5.724  1.00  0.30           H  
ATOM    723  HB1 ALA A  48      -4.981 -12.334  -6.988  1.00  1.13           H  
ATOM    724  HB2 ALA A  48      -3.533 -12.536  -7.971  1.00  0.79           H  
ATOM    725  HB3 ALA A  48      -4.627 -13.894  -7.725  1.00  1.25           H  
ATOM    726  N   THR A  49      -1.245 -12.353  -5.980  1.00  0.15           N  
ATOM    727  CA  THR A  49       0.221 -12.270  -6.259  1.00  0.11           C  
ATOM    728  C   THR A  49       0.931 -11.509  -5.134  1.00  0.04           C  
ATOM    729  O   THR A  49       2.049 -11.060  -5.295  1.00  0.05           O  
ATOM    730  CB  THR A  49       0.440 -11.540  -7.588  1.00  0.15           C  
ATOM    731  OG1 THR A  49      -0.184 -10.272  -7.412  1.00  0.10           O  
ATOM    732  CG2 THR A  49      -0.318 -12.208  -8.733  1.00  0.33           C  
ATOM    733  H   THR A  49      -1.705 -11.615  -5.529  1.00  0.16           H  
ATOM    734  HA  THR A  49       0.627 -13.265  -6.329  1.00  0.11           H  
ATOM    735  HB  THR A  49       1.485 -11.432  -7.821  1.00  0.24           H  
ATOM    736  HG1 THR A  49       0.206  -9.854  -6.642  1.00  1.12           H  
ATOM    737 HG21 THR A  49      -0.204 -13.281  -8.670  1.00  0.95           H  
ATOM    738 HG22 THR A  49      -1.367 -11.959  -8.670  1.00  1.29           H  
ATOM    739 HG23 THR A  49       0.073 -11.864  -9.680  1.00  0.73           H  
ATOM    740  N   LYS A  50       0.264 -11.378  -4.020  1.00  0.03           N  
ATOM    741  CA  LYS A  50       0.882 -10.649  -2.871  1.00  0.05           C  
ATOM    742  C   LYS A  50       1.309  -9.244  -3.309  1.00  0.06           C  
ATOM    743  O   LYS A  50       2.471  -8.894  -3.242  1.00  0.09           O  
ATOM    744  CB  LYS A  50       2.100 -11.428  -2.372  1.00  0.09           C  
ATOM    745  CG  LYS A  50       1.691 -12.876  -2.088  1.00  0.10           C  
ATOM    746  CD  LYS A  50       2.932 -13.682  -1.696  1.00  0.51           C  
ATOM    747  CE  LYS A  50       3.336 -14.574  -2.870  1.00  1.72           C  
ATOM    748  NZ  LYS A  50       3.488 -13.762  -4.109  1.00  3.08           N  
ATOM    749  H   LYS A  50      -0.637 -11.750  -3.938  1.00  0.06           H  
ATOM    750  HA  LYS A  50       0.161 -10.569  -2.077  1.00  0.07           H  
ATOM    751  HB2 LYS A  50       2.876 -11.410  -3.121  1.00  0.11           H  
ATOM    752  HB3 LYS A  50       2.474 -10.973  -1.465  1.00  0.09           H  
ATOM    753  HG2 LYS A  50       0.974 -12.899  -1.281  1.00  0.25           H  
ATOM    754  HG3 LYS A  50       1.244 -13.307  -2.971  1.00  0.26           H  
ATOM    755  HD2 LYS A  50       3.741 -13.008  -1.457  1.00  1.30           H  
ATOM    756  HD3 LYS A  50       2.711 -14.293  -0.834  1.00  1.00           H  
ATOM    757  HE2 LYS A  50       4.275 -15.061  -2.649  1.00  2.25           H  
ATOM    758  HE3 LYS A  50       2.578 -15.327  -3.031  1.00  1.96           H  
ATOM    759  HZ1 LYS A  50       4.094 -12.941  -3.913  1.00  3.58           H  
ATOM    760  HZ2 LYS A  50       3.924 -14.345  -4.854  1.00  3.77           H  
ATOM    761  HZ3 LYS A  50       2.553 -13.436  -4.426  1.00  3.38           H  
ATOM    762  N   THR A  51       0.352  -8.476  -3.747  1.00  0.07           N  
ATOM    763  CA  THR A  51       0.657  -7.086  -4.202  1.00  0.11           C  
ATOM    764  C   THR A  51      -0.423  -6.121  -3.680  1.00  0.07           C  
ATOM    765  O   THR A  51      -1.563  -6.194  -4.091  1.00  0.06           O  
ATOM    766  CB  THR A  51       0.647  -7.072  -5.735  1.00  0.17           C  
ATOM    767  OG1 THR A  51       1.266  -8.298  -6.112  1.00  0.92           O  
ATOM    768  CG2 THR A  51       1.541  -5.981  -6.307  1.00  0.64           C  
ATOM    769  H   THR A  51      -0.567  -8.812  -3.790  1.00  0.06           H  
ATOM    770  HA  THR A  51       1.632  -6.783  -3.842  1.00  0.16           H  
ATOM    771  HB  THR A  51      -0.349  -7.004  -6.129  1.00  0.64           H  
ATOM    772  HG1 THR A  51       2.007  -8.449  -5.522  1.00  0.86           H  
ATOM    773 HG21 THR A  51       1.609  -5.162  -5.613  1.00  1.12           H  
ATOM    774 HG22 THR A  51       2.526  -6.379  -6.488  1.00  1.84           H  
ATOM    775 HG23 THR A  51       1.127  -5.623  -7.238  1.00  0.82           H  
ATOM    776  N   PHE A  52      -0.050  -5.236  -2.786  1.00  0.04           N  
ATOM    777  CA  PHE A  52      -1.059  -4.279  -2.261  1.00  0.02           C  
ATOM    778  C   PHE A  52      -1.259  -3.152  -3.276  1.00  0.02           C  
ATOM    779  O   PHE A  52      -0.436  -2.953  -4.147  1.00  0.03           O  
ATOM    780  CB  PHE A  52      -0.561  -3.684  -0.958  1.00  0.04           C  
ATOM    781  CG  PHE A  52      -1.454  -4.153   0.188  1.00  0.03           C  
ATOM    782  CD1 PHE A  52      -2.646  -3.508   0.472  1.00  0.04           C  
ATOM    783  CD2 PHE A  52      -1.076  -5.226   0.952  1.00  0.03           C  
ATOM    784  CE1 PHE A  52      -3.437  -3.943   1.517  1.00  0.05           C  
ATOM    785  CE2 PHE A  52      -1.856  -5.653   1.996  1.00  0.04           C  
ATOM    786  CZ  PHE A  52      -3.034  -5.010   2.284  1.00  0.05           C  
ATOM    787  H   PHE A  52       0.878  -5.194  -2.472  1.00  0.05           H  
ATOM    788  HA  PHE A  52      -1.984  -4.795  -2.087  1.00  0.02           H  
ATOM    789  HB2 PHE A  52       0.453  -4.005  -0.772  1.00  0.07           H  
ATOM    790  HB3 PHE A  52      -0.591  -2.611  -1.011  1.00  0.06           H  
ATOM    791  HD1 PHE A  52      -2.954  -2.659  -0.121  1.00  0.06           H  
ATOM    792  HD2 PHE A  52      -0.191  -5.764   0.697  1.00  0.04           H  
ATOM    793  HE1 PHE A  52      -4.396  -3.479   1.700  1.00  0.07           H  
ATOM    794  HE2 PHE A  52      -1.536  -6.490   2.596  1.00  0.05           H  
ATOM    795  HZ  PHE A  52      -3.623  -5.320   3.132  1.00  0.06           H  
ATOM    796  N   THR A  53      -2.337  -2.438  -3.151  1.00  0.03           N  
ATOM    797  CA  THR A  53      -2.571  -1.326  -4.108  1.00  0.04           C  
ATOM    798  C   THR A  53      -3.569  -0.328  -3.530  1.00  0.05           C  
ATOM    799  O   THR A  53      -4.558  -0.709  -2.946  1.00  0.06           O  
ATOM    800  CB  THR A  53      -3.123  -1.902  -5.410  1.00  0.03           C  
ATOM    801  OG1 THR A  53      -2.058  -2.684  -5.940  1.00  0.04           O  
ATOM    802  CG2 THR A  53      -3.375  -0.809  -6.444  1.00  0.06           C  
ATOM    803  H   THR A  53      -2.989  -2.633  -2.446  1.00  0.04           H  
ATOM    804  HA  THR A  53      -1.640  -0.825  -4.309  1.00  0.05           H  
ATOM    805  HB  THR A  53      -4.000  -2.497  -5.245  1.00  0.02           H  
ATOM    806  HG1 THR A  53      -2.436  -3.335  -6.538  1.00  0.57           H  
ATOM    807 HG21 THR A  53      -2.630  -0.033  -6.343  1.00  1.08           H  
ATOM    808 HG22 THR A  53      -3.319  -1.227  -7.438  1.00  1.04           H  
ATOM    809 HG23 THR A  53      -4.355  -0.382  -6.292  1.00  1.15           H  
ATOM    810  N   VAL A  54      -3.279   0.931  -3.703  1.00  0.06           N  
ATOM    811  CA  VAL A  54      -4.200   1.983  -3.186  1.00  0.07           C  
ATOM    812  C   VAL A  54      -4.375   3.053  -4.265  1.00  0.10           C  
ATOM    813  O   VAL A  54      -3.486   3.276  -5.064  1.00  0.11           O  
ATOM    814  CB  VAL A  54      -3.597   2.603  -1.917  1.00  0.06           C  
ATOM    815  CG1 VAL A  54      -2.351   3.393  -2.286  1.00  0.08           C  
ATOM    816  CG2 VAL A  54      -4.607   3.548  -1.265  1.00  0.07           C  
ATOM    817  H   VAL A  54      -2.458   1.189  -4.177  1.00  0.07           H  
ATOM    818  HA  VAL A  54      -5.159   1.543  -2.953  1.00  0.08           H  
ATOM    819  HB  VAL A  54      -3.334   1.820  -1.221  1.00  0.05           H  
ATOM    820 HG11 VAL A  54      -1.725   2.794  -2.923  1.00  1.04           H  
ATOM    821 HG12 VAL A  54      -2.631   4.298  -2.805  1.00  1.17           H  
ATOM    822 HG13 VAL A  54      -1.806   3.650  -1.392  1.00  1.07           H  
ATOM    823 HG21 VAL A  54      -5.022   4.210  -2.005  1.00  1.03           H  
ATOM    824 HG22 VAL A  54      -5.400   2.975  -0.817  1.00  1.08           H  
ATOM    825 HG23 VAL A  54      -4.116   4.132  -0.502  1.00  1.00           H  
ATOM    826  N   THR A  55      -5.509   3.687  -4.273  1.00  0.11           N  
ATOM    827  CA  THR A  55      -5.757   4.733  -5.308  1.00  0.14           C  
ATOM    828  C   THR A  55      -6.540   5.904  -4.703  1.00  0.14           C  
ATOM    829  O   THR A  55      -7.682   5.754  -4.317  1.00  0.17           O  
ATOM    830  CB  THR A  55      -6.572   4.108  -6.442  1.00  0.19           C  
ATOM    831  OG1 THR A  55      -5.877   2.907  -6.767  1.00  0.33           O  
ATOM    832  CG2 THR A  55      -6.530   4.953  -7.715  1.00  0.24           C  
ATOM    833  H   THR A  55      -6.191   3.484  -3.602  1.00  0.10           H  
ATOM    834  HA  THR A  55      -4.814   5.087  -5.696  1.00  0.16           H  
ATOM    835  HB  THR A  55      -7.584   3.903  -6.143  1.00  0.17           H  
ATOM    836  HG1 THR A  55      -4.961   3.132  -6.944  1.00  0.86           H  
ATOM    837 HG21 THR A  55      -5.925   5.833  -7.555  1.00  0.88           H  
ATOM    838 HG22 THR A  55      -6.110   4.371  -8.522  1.00  1.32           H  
ATOM    839 HG23 THR A  55      -7.529   5.256  -7.979  1.00  1.15           H  
ATOM    840  N   GLU A  56      -5.912   7.046  -4.634  1.00  0.12           N  
ATOM    841  CA  GLU A  56      -6.614   8.232  -4.057  1.00  0.11           C  
ATOM    842  C   GLU A  56      -7.866   8.557  -4.879  1.00  0.12           C  
ATOM    843  O   GLU A  56      -8.544   9.491  -4.484  1.00  1.03           O  
ATOM    844  CB  GLU A  56      -5.670   9.433  -4.073  1.00  0.11           C  
ATOM    845  CG  GLU A  56      -5.747  10.147  -2.724  1.00  0.10           C  
ATOM    846  CD  GLU A  56      -4.957  11.455  -2.797  1.00  1.20           C  
ATOM    847  OE1 GLU A  56      -3.886  11.407  -3.378  1.00  2.46           O  
ATOM    848  OE2 GLU A  56      -5.469  12.427  -2.268  1.00  1.30           O  
ATOM    849  OXT GLU A  56      -8.072   7.852  -5.853  1.00  1.12           O  
ATOM    850  H   GLU A  56      -4.990   7.125  -4.956  1.00  0.13           H  
ATOM    851  HA  GLU A  56      -6.900   8.018  -3.042  1.00  0.10           H  
ATOM    852  HB2 GLU A  56      -4.660   9.099  -4.249  1.00  0.11           H  
ATOM    853  HB3 GLU A  56      -5.959  10.113  -4.862  1.00  0.11           H  
ATOM    854  HG2 GLU A  56      -6.777  10.366  -2.483  1.00  0.95           H  
ATOM    855  HG3 GLU A  56      -5.327   9.518  -1.952  1.00  0.97           H  
TER     856      GLU A  56                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
