
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   61 (  468),  selected   61 , name 1hez_E
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1hez_E.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E   820_E      -       -           -
LGA    V   821_E      T       1          0.827
LGA    T   822_E      T       2          0.557
LGA    I   823_E      Y       3          0.381
LGA    K   824_E      K       4          1.299
LGA    V   825_E      L       5          1.133
LGA    N   826_E      I       6          1.018
LGA    L   827_E      L       7          1.284
LGA    I   828_E      N       8          1.208
LGA    F   829_E      L       9          1.461
LGA    A   830_E      K      10          1.960
LGA    D   831_E      Q      11          1.785
LGA    G   832_E      -       -           -
LGA    K   833_E      A      12          2.271
LGA    I   834_E      K      13          1.504
LGA    Q   835_E      E      14          1.261
LGA    T   836_E      E      15          1.735
LGA    A   837_E      A      16          2.198
LGA    E   838_E      I      17          1.334
LGA    F   839_E      K      18          1.163
LGA    K   840_E      E      19          1.247
LGA    G   841_E      A      20          0.839
LGA    T   842_E      V      21          2.392
LGA    F   843_E      D      22          2.217
LGA    E   844_E      A      23          2.080
LGA    -       -      G      24           -
LGA    E   845_E      T      25          0.640
LGA    A   846_E      A      26          1.440
LGA    T   847_E      E      27          2.059
LGA    A   848_E      K      28          1.714
LGA    E   849_E      Y      29          0.505
LGA    A   850_E      F      30          0.590
LGA    Y   851_E      K      31          1.277
LGA    R   852_E      L      32          1.786
LGA    Y   853_E      I      33          1.362
LGA    A   854_E      A      34          0.759
LGA    D   855_E      N      35          1.381
LGA    L   856_E      A      36          1.086
LGA    L   857_E      K      37          1.501
LGA    A   858_E      T      38          2.287
LGA    K   859_E      -       -           -
LGA    V   860_E      -       -           -
LGA    N   861_E      -       -           -
LGA    G   862_E      V      39          3.223
LGA    E   863_E      E      40          2.224
LGA    Y   864_E      G      41          2.448
LGA    T   865_E      V      42          2.197
LGA    A   866_E      W      43          0.945
LGA    D   867_E      T      44          0.990
LGA    L   868_E      Y      45          1.257
LGA    E   869_E      K      46          0.868
LGA    D   870_E      D      47          2.499
LGA    G   871_E      -       -           -
LGA    G   872_E      E      48          6.529
LGA    -       -      I      49           -
LGA    N   873_E      K      50          0.517
LGA    H   874_E      T      51          1.128
LGA    M   875_E      F      52          1.036
LGA    N   876_E      T      53          1.059
LGA    I   877_E      V      54          1.431
LGA    K   878_E      T      55          1.738
LGA    F   879_E      E      56          3.260
LGA    A   880_E      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   61   56    5.0     54    1.83    14.81     87.563     2.794

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.688719 * X  +  -0.136837 * Y  +   0.711998 * Z  +   4.344955
  Y_new =  -0.589014 * X  +   0.678218 * Y  +  -0.439412 * Z  +   3.718006
  Z_new =  -0.422762 * X  +  -0.722009 * Y  +  -0.547700 * Z  +  60.461647 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.219765    0.921827  [ DEG:  -127.1832     52.8168 ]
  Theta =   0.436491    2.705101  [ DEG:    25.0091    154.9909 ]
  Phi   =  -2.434069    0.707523  [ DEG:  -139.4619     40.5381 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1hez_E                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1hez_E.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   61   56   5.0   54   1.83   14.81  87.563
REMARK  ---------------------------------------------------------- 
MOLECULE 1hez_E
HEADER    ANTIBODY                                24-NOV-00   1HEZ              
TITLE     ANTIBODY-ANTIGEN COMPLEX                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: KAPPA LIGHT CHAIN OF IG;                                   
COMPND   3 CHAIN: A, C;                                                         
COMPND   4 FRAGMENT: 1-214;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: HEAVY CHAIN OF IG;                                         
COMPND   7 CHAIN: B, D;                                                         
COMPND   8 FRAGMENT: 501-724;                                                   
COMPND   9 MOL_ID: 3;                                                           
COMPND  10 MOLECULE: PROTEIN L;                                                 
COMPND  11 CHAIN: E;                                                            
COMPND  12 FRAGMENT: 820-880                                                    
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 CELL: B-LYMPHOCYTE;                                                  
SOURCE   5 MOL_ID: 2;                                                           
SOURCE   6 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   7 ORGANISM_COMMON: HUMAN;                                              
SOURCE   8 CELL: B-LYMPHOCYTE;                                                  
SOURCE   9 MOL_ID: 3;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: PEPTOSTREPTOCOCCUS MAGNUS;                      
SOURCE  11 STRAIN: 3316;                                                        
SOURCE  12 PLASMID: PKK223-3                                                    
KEYWDS    ANTIBODY, SUPERANTIGEN                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.GRAILLE,E.A.STURA,N.G.HOUSDEN,S.P.BOTTOMLEY,M.J.TAUSSIG,            
AUTHOR   2 B.J.SUTTON,M.G.GORE,J.B.CHARBONNIER                                  
REVDAT   2   18-JUL-03 1HEZ    1       REMARK                                   
REVDAT   1   10-AUG-01 1HEZ    0                                                
JRNL        AUTH   M.GRAILLE,E.A.STURA,N.G.HOUSDEN,J.A.BECKINGHAM,              
JRNL        AUTH 2 S.P.BOTTOMLEY,D.BEALE,M.J.TAUSSIG,B.J.SUTTON,                
JRNL        AUTH 3 M.G.GORE,J.B.CHARBONNIER                                     
JRNL        TITL   COMPLEX BETWEEN PEPTOSTREPTOCOCCUS MAGNUS PROTEIN            
JRNL        TITL 2 L AND A HUMAN ANTIBODY REVEALS STRUCTURAL                    
JRNL        TITL 3 CONVERGENCE IN THE INTERACTION MODES OF FAB                  
JRNL        TITL 4 BINDING PROTEINS.                                            
JRNL        REF    STRUCTURE                     V.   9   679 2001              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1HEZ A  109   214  UNP    P01834   KAC_HUMAN        1    106             
DBREF  1HEZ B    1   224  UNP    Q8WUK1   Q8WUK1_HUMAN    20    243             
DBREF  1HEZ C  109   214  UNP    P01834   KAC_HUMAN        1    106             
DBREF  1HEZ D    1   224  UNP    Q8WUK1   Q8WUK1_HUMAN    20    243             
DBREF  1HEZ E  820   880  UNP    Q51918   Q51918_PEPMA   476    536             
SEQRES   1 A  214  ASP ILE GLN MET THR GLN SER PRO SER SER LEU SER ALA          
SEQRES   2 A  214  SER VAL GLY ASP ARG VAL THR ILE THR CYS ARG THR SER          
SEQRES   3 A  214  GLN SER ILE SER SER TYR LEU ASN TRP TYR GLN GLN LYS          
SEQRES   4 A  214  PRO GLY LYS ALA PRO LYS LEU LEU ILE TYR ALA ALA SER          
SEQRES   5 A  214  SER LEU GLN SER GLY VAL PRO SER ARG PHE SER GLY SER          
SEQRES   6 A  214  GLY SER GLY THR ASP PHE THR LEU THR ILE SER SER LEU          
SEQRES   7 A  214  GLN PRO GLU ASP PHE ALA THR TYR TYR CYS GLN GLN SER          
SEQRES   8 A  214  TYR SER THR PRO ARG THR PHE GLY GLN GLY THR LYS VAL          
SEQRES   9 A  214  GLU ILE LYS ARG THR VAL ALA ALA PRO SER VAL PHE ILE          
SEQRES  10 A  214  PHE PRO PRO SER ASP GLU GLN LEU LYS SER GLY THR ALA          
SEQRES  11 A  214  SER VAL VAL CYS LEU LEU ASN ASN PHE TYR PRO ARG GLU          
SEQRES  12 A  214  ALA LYS VAL GLN TRP LYS VAL ASP ASN ALA LEU GLN SER          
SEQRES  13 A  214  GLY ASN SER GLN GLU SER VAL THR GLU GLN ASP SER LYS          
SEQRES  14 A  214  ASP SER THR TYR SER LEU SER SER THR LEU THR LEU SER          
SEQRES  15 A  214  LYS ALA ASP TYR GLU LYS HIS LYS VAL TYR ALA CYS GLU          
SEQRES  16 A  214  VAL THR HIS GLN GLY LEU SER SER PRO VAL THR LYS SER          
SEQRES  17 A  214  PHE ASN ARG GLY GLU CYS                                      
SEQRES   1 B  224  GLN VAL GLN LEU VAL GLU SER GLY GLY GLY VAL VAL GLN          
SEQRES   2 B  224  PRO GLY ARG SER LEU ARG LEU SER CYS ALA ALA SER GLY          
SEQRES   3 B  224  PHE THR PHE SER GLY TYR GLY MET HIS TRP VAL ARG GLN          
SEQRES   4 B  224  ALA PRO GLY LYS GLY LEU GLU TRP VAL ALA LEU ILE SER          
SEQRES   5 B  224  TYR ASP GLU SER ASN LYS TYR TYR ALA ASP SER VAL LYS          
SEQRES   6 B  224  GLY ARG PHE THR ILE SER ARG ASP ASN SER LYS ASN THR          
SEQRES   7 B  224  LEU TYR LEU GLN MET ASN SER LEU ARG ALA GLU ASP THR          
SEQRES   8 B  224  ALA VAL TYR TYR CYS ALA LYS VAL LYS PHE TYR ASP PRO          
SEQRES   9 B  224  THR ALA PRO ASN ASP TYR TRP GLY GLN GLY THR LEU VAL          
SEQRES  10 B  224  THR VAL SER SER GLY SER ALA SER ALA PRO THR LEU PHE          
SEQRES  11 B  224  PRO LEU VAL SER CYS GLU ASN SER ASN PRO SER SER THR          
SEQRES  12 B  224  VAL ALA VAL GLY CYS LEU ALA GLN ASP PHE LEU PRO ASP          
SEQRES  13 B  224  SER ILE THR PHE SER TRP LYS TYR LYS ASN ASN SER ASP          
SEQRES  14 B  224  ILE SER SER THR ARG GLY PHE PRO SER VAL LEU ARG GLY          
SEQRES  15 B  224  GLY LYS TYR ALA ALA THR SER GLN VAL LEU LEU PRO SER          
SEQRES  16 B  224  LYS ASP VAL ALA GLN GLY THR ASN GLU HIS VAL VAL CYS          
SEQRES  17 B  224  LYS VAL GLN HIS PRO ASN GLY ASN LYS GLU LYS ASP VAL          
SEQRES  18 B  224  PRO LEU PRO                                                  
SEQRES   1 C  214  ASP ILE GLN MET THR GLN SER PRO SER SER LEU SER ALA          
SEQRES   2 C  214  SER VAL GLY ASP ARG VAL THR ILE THR CYS ARG THR SER          
SEQRES   3 C  214  GLN SER ILE SER SER TYR LEU ASN TRP TYR GLN GLN LYS          
SEQRES   4 C  214  PRO GLY LYS ALA PRO LYS LEU LEU ILE TYR ALA ALA SER          
SEQRES   5 C  214  SER LEU GLN SER GLY VAL PRO SER ARG PHE SER GLY SER          
SEQRES   6 C  214  GLY SER GLY THR ASP PHE THR LEU THR ILE SER SER LEU          
SEQRES   7 C  214  GLN PRO GLU ASP PHE ALA THR TYR TYR CYS GLN GLN SER          
SEQRES   8 C  214  TYR SER THR PRO ARG THR PHE GLY GLN GLY THR LYS VAL          
SEQRES   9 C  214  GLU ILE LYS ARG THR VAL ALA ALA PRO SER VAL PHE ILE          
SEQRES  10 C  214  PHE PRO PRO SER ASP GLU GLN LEU LYS SER GLY THR ALA          
SEQRES  11 C  214  SER VAL VAL CYS LEU LEU ASN ASN PHE TYR PRO ARG GLU          
SEQRES  12 C  214  ALA LYS VAL GLN TRP LYS VAL ASP ASN ALA LEU GLN SER          
SEQRES  13 C  214  GLY ASN SER GLN GLU SER VAL THR GLU GLN ASP SER LYS          
SEQRES  14 C  214  ASP SER THR TYR SER LEU SER SER THR LEU THR LEU SER          
SEQRES  15 C  214  LYS ALA ASP TYR GLU LYS HIS LYS VAL TYR ALA CYS GLU          
SEQRES  16 C  214  VAL THR HIS GLN GLY LEU SER SER PRO VAL THR LYS SER          
SEQRES  17 C  214  PHE ASN ARG GLY GLU CYS                                      
SEQRES   1 D  224  GLN VAL GLN LEU VAL GLU SER GLY GLY GLY VAL VAL GLN          
SEQRES   2 D  224  PRO GLY ARG SER LEU ARG LEU SER CYS ALA ALA SER GLY          
SEQRES   3 D  224  PHE THR PHE SER GLY TYR GLY MET HIS TRP VAL ARG GLN          
SEQRES   4 D  224  ALA PRO GLY LYS GLY LEU GLU TRP VAL ALA LEU ILE SER          
SEQRES   5 D  224  TYR ASP GLU SER ASN LYS TYR TYR ALA ASP SER VAL LYS          
SEQRES   6 D  224  GLY ARG PHE THR ILE SER ARG ASP ASN SER LYS ASN THR          
SEQRES   7 D  224  LEU TYR LEU GLN MET ASN SER LEU ARG ALA GLU ASP THR          
SEQRES   8 D  224  ALA VAL TYR TYR CYS ALA LYS VAL LYS PHE TYR ASP PRO          
SEQRES   9 D  224  THR ALA PRO ASN ASP TYR TRP GLY GLN GLY THR LEU VAL          
SEQRES  10 D  224  THR VAL SER SER GLY SER ALA SER ALA PRO THR LEU PHE          
SEQRES  11 D  224  PRO LEU VAL SER CYS GLU ASN SER ASN PRO SER SER THR          
SEQRES  12 D  224  VAL ALA VAL GLY CYS LEU ALA GLN ASP PHE LEU PRO ASP          
SEQRES  13 D  224  SER ILE THR PHE SER TRP LYS TYR LYS ASN ASN SER ASP          
SEQRES  14 D  224  ILE SER SER THR ARG GLY PHE PRO SER VAL LEU ARG GLY          
SEQRES  15 D  224  GLY LYS TYR ALA ALA THR SER GLN VAL LEU LEU PRO SER          
SEQRES  16 D  224  LYS ASP VAL ALA GLN GLY THR ASN GLU HIS VAL VAL CYS          
SEQRES  17 D  224  LYS VAL GLN HIS PRO ASN GLY ASN LYS GLU LYS ASP VAL          
SEQRES  18 D  224  PRO LEU PRO                                                  
SEQRES   1 E   61  GLU VAL THR ILE LYS VAL ASN LEU ILE PHE ALA ASP GLY          
SEQRES   2 E   61  LYS ILE GLN THR ALA GLU PHE LYS GLY THR PHE GLU GLU          
SEQRES   3 E   61  ALA THR ALA GLU ALA TYR ARG TYR ALA ASP LEU LEU ALA          
SEQRES   4 E   61  LYS VAL ASN GLY GLU TYR THR ALA ASP LEU GLU ASP GLY          
SEQRES   5 E   61  GLY ASN HIS MET ASN ILE LYS PHE ALA                          
HET    IMD  A 401       5                                                       
HET    IMD  C 401       5                                                       
HETNAM     IMD IMIDAZOLE                                                        
FORMUL   6  IMD    2(C3 H5 N2 1+)                                               
FORMUL   8  HOH   *112(H2 O)                                                    
CRYST1   55.185   87.335  210.538  90.00  90.00  90.00 P 21 21 21    8          
ATOM   6473  N   GLU E 820       6.373 -15.458   7.387  1.00 53.22           N  
ATOM   6474  CA  GLU E 820       6.525 -14.050   6.916  1.00 52.32           C  
ATOM   6475  C   GLU E 820       6.138 -13.885   5.447  1.00 50.90           C  
ATOM   6476  O   GLU E 820       6.378 -14.771   4.629  1.00 49.54           O  
ATOM   6477  CB  GLU E 820       7.969 -13.568   7.117  1.00 53.13           C  
ATOM   6478  CG  GLU E 820       8.393 -12.456   6.143  1.00 57.10           C  
ATOM   6479  CD  GLU E 820       9.275 -11.367   6.769  1.00 58.39           C  
ATOM   6480  OE1 GLU E 820      10.096 -10.779   6.028  1.00 58.30           O  
ATOM   6481  OE2 GLU E 820       9.142 -11.088   7.984  1.00 57.32           O  
ATOM   6482  N   VAL E 821       5.537 -12.740   5.124  1.00 49.63           N  
ATOM   6483  CA  VAL E 821       5.113 -12.445   3.759  1.00 47.46           C  
ATOM   6484  C   VAL E 821       5.454 -11.022   3.345  1.00 46.13           C  
ATOM   6485  O   VAL E 821       5.710 -10.160   4.190  1.00 47.68           O  
ATOM   6486  CB  VAL E 821       3.594 -12.617   3.591  1.00 47.72           C  
ATOM   6487  CG1 VAL E 821       2.862 -11.593   4.437  1.00 46.41           C  
ATOM   6488  CG2 VAL E 821       3.214 -12.473   2.113  1.00 49.08           C  
ATOM   6489  N   THR E 822       5.454 -10.789   2.034  1.00 43.78           N  
ATOM   6490  CA  THR E 822       5.731  -9.469   1.469  1.00 40.21           C  
ATOM   6491  C   THR E 822       4.509  -8.921   0.725  1.00 39.71           C  
ATOM   6492  O   THR E 822       3.952  -9.559  -0.177  1.00 38.24           O  
ATOM   6493  CB  THR E 822       6.926  -9.517   0.506  1.00 38.24           C  
ATOM   6494  OG1 THR E 822       8.128  -9.723   1.256  1.00 39.76           O  
ATOM   6495  CG2 THR E 822       7.039  -8.230  -0.275  1.00 36.44           C  
ATOM   6496  N   ILE E 823       4.095  -7.727   1.127  1.00 38.32           N  
ATOM   6497  CA  ILE E 823       2.956  -7.067   0.522  1.00 37.90           C  
ATOM   6498  C   ILE E 823       3.429  -6.077  -0.525  1.00 38.00           C  
ATOM   6499  O   ILE E 823       4.154  -5.127  -0.209  1.00 38.26           O  
ATOM   6500  CB  ILE E 823       2.124  -6.309   1.582  1.00 37.81           C  
ATOM   6501  CG1 ILE E 823       1.575  -7.297   2.613  1.00 37.00           C  
ATOM   6502  CG2 ILE E 823       0.998  -5.534   0.914  1.00 36.55           C  
ATOM   6503  CD1 ILE E 823       0.742  -8.439   2.009  1.00 36.44           C  
ATOM   6504  N   LYS E 824       3.008  -6.320  -1.767  1.00 38.10           N  
ATOM   6505  CA  LYS E 824       3.335  -5.475  -2.917  1.00 36.42           C  
ATOM   6506  C   LYS E 824       2.309  -4.332  -2.982  1.00 35.94           C  
ATOM   6507  O   LYS E 824       1.102  -4.557  -3.087  1.00 36.17           O  
ATOM   6508  CB  LYS E 824       3.278  -6.307  -4.201  1.00 36.65           C  
ATOM   6509  CG  LYS E 824       4.376  -7.359  -4.356  1.00 40.02           C  
ATOM   6510  CD  LYS E 824       5.656  -6.761  -4.970  1.00 43.73           C  
ATOM   6511  CE  LYS E 824       6.672  -7.837  -5.399  1.00 45.87           C  
ATOM   6512  NZ  LYS E 824       6.194  -8.760  -6.492  1.00 47.39           N  
ATOM   6513  N   VAL E 825       2.787  -3.099  -2.918  1.00 35.33           N  
ATOM   6514  CA  VAL E 825       1.883  -1.962  -2.952  1.00 34.91           C  
ATOM   6515  C   VAL E 825       2.208  -0.903  -4.001  1.00 34.68           C  
ATOM   6516  O   VAL E 825       3.312  -0.352  -4.048  1.00 33.80           O  
ATOM   6517  CB  VAL E 825       1.839  -1.277  -1.579  1.00 36.18           C  
ATOM   6518  CG1 VAL E 825       0.973  -0.016  -1.649  1.00 35.74           C  
ATOM   6519  CG2 VAL E 825       1.310  -2.262  -0.530  1.00 35.53           C  
ATOM   6520  N   ASN E 826       1.227  -0.621  -4.850  1.00 34.54           N  
ATOM   6521  CA  ASN E 826       1.392   0.396  -5.868  1.00 33.63           C  
ATOM   6522  C   ASN E 826       0.850   1.697  -5.303  1.00 33.76           C  
ATOM   6523  O   ASN E 826      -0.352   1.820  -5.055  1.00 31.50           O  
ATOM   6524  CB  ASN E 826       0.638   0.026  -7.145  1.00 32.82           C  
ATOM   6525  CG  ASN E 826       1.292  -1.126  -7.892  1.00 33.84           C  
ATOM   6526  OD1 ASN E 826       2.512  -1.310  -7.827  1.00 33.62           O  
ATOM   6527  ND2 ASN E 826       0.488  -1.898  -8.618  1.00 31.90           N  
ATOM   6528  N   LEU E 827       1.752   2.641  -5.055  1.00 34.04           N  
ATOM   6529  CA  LEU E 827       1.369   3.945  -4.544  1.00 37.20           C  
ATOM   6530  C   LEU E 827       1.020   4.767  -5.772  1.00 39.09           C  
ATOM   6531  O   LEU E 827       1.896   5.360  -6.400  1.00 39.22           O  
ATOM   6532  CB  LEU E 827       2.529   4.592  -3.791  1.00 37.70           C  
ATOM   6533  CG  LEU E 827       2.896   3.972  -2.440  1.00 37.89           C  
ATOM   6534  CD1 LEU E 827       4.108   4.708  -1.852  1.00 36.18           C  
ATOM   6535  CD2 LEU E 827       1.694   4.059  -1.498  1.00 33.99           C  
ATOM   6536  N   ILE E 828      -0.272   4.780  -6.104  1.00 41.48           N  
ATOM   6537  CA  ILE E 828      -0.819   5.468  -7.276  1.00 42.27           C  
ATOM   6538  C   ILE E 828      -1.304   6.894  -7.025  1.00 44.13           C  
ATOM   6539  O   ILE E 828      -2.473   7.117  -6.701  1.00 43.15           O  
ATOM   6540  CB  ILE E 828      -1.985   4.655  -7.850  1.00 41.13           C  
ATOM   6541  CG1 ILE E 828      -1.476   3.268  -8.261  1.00 39.94           C  
ATOM   6542  CG2 ILE E 828      -2.634   5.405  -9.006  1.00 41.24           C  
ATOM   6543  CD1 ILE E 828      -2.576   2.291  -8.656  1.00 39.98           C  
ATOM   6544  N   PHE E 829      -0.400   7.850  -7.202  1.00 47.22           N  
ATOM   6545  CA  PHE E 829      -0.713   9.258  -6.999  1.00 51.39           C  
ATOM   6546  C   PHE E 829      -1.592   9.811  -8.116  1.00 53.08           C  
ATOM   6547  O   PHE E 829      -1.552   9.324  -9.252  1.00 53.06           O  
ATOM   6548  CB  PHE E 829       0.572  10.087  -6.944  1.00 53.72           C  
ATOM   6549  CG  PHE E 829       1.615   9.536  -6.021  1.00 55.44           C  
ATOM   6550  CD1 PHE E 829       2.406   8.463  -6.407  1.00 54.97           C  
ATOM   6551  CD2 PHE E 829       1.810  10.097  -4.763  1.00 56.69           C  
ATOM   6552  CE1 PHE E 829       3.382   7.959  -5.554  1.00 56.94           C  
ATOM   6553  CE2 PHE E 829       2.783   9.604  -3.896  1.00 56.55           C  
ATOM   6554  CZ  PHE E 829       3.571   8.532  -4.294  1.00 57.12           C  
ATOM   6555  N   ALA E 830      -2.368  10.841  -7.787  1.00 54.67           N  
ATOM   6556  CA  ALA E 830      -3.253  11.481  -8.755  1.00 56.36           C  
ATOM   6557  C   ALA E 830      -2.465  12.138  -9.890  1.00 57.01           C  
ATOM   6558  O   ALA E 830      -2.732  11.877 -11.064  1.00 56.18           O  
ATOM   6559  CB  ALA E 830      -4.130  12.526  -8.059  1.00 55.42           C  
ATOM   6560  N   ASP E 831      -1.490  12.976  -9.539  1.00 57.52           N  
ATOM   6561  CA  ASP E 831      -0.691  13.662 -10.548  1.00 58.40           C  
ATOM   6562  C   ASP E 831       0.195  12.746 -11.406  1.00 58.29           C  
ATOM   6563  O   ASP E 831       1.359  13.055 -11.671  1.00 58.18           O  
ATOM   6564  CB  ASP E 831       0.148  14.781  -9.901  1.00 59.90           C  
ATOM   6565  CG  ASP E 831       1.363  14.262  -9.148  1.00 62.53           C  
ATOM   6566  OD1 ASP E 831       1.990  15.065  -8.424  1.00 63.61           O  
ATOM   6567  OD2 ASP E 831       1.706  13.066  -9.280  1.00 63.99           O  
ATOM   6568  N   GLY E 832      -0.370  11.617 -11.826  1.00 58.85           N  
ATOM   6569  CA  GLY E 832       0.334  10.689 -12.699  1.00 61.17           C  
ATOM   6570  C   GLY E 832       1.372   9.712 -12.170  1.00 62.79           C  
ATOM   6571  O   GLY E 832       1.417   8.563 -12.630  1.00 62.72           O  
ATOM   6572  N   LYS E 833       2.209  10.148 -11.226  1.00 63.40           N  
ATOM   6573  CA  LYS E 833       3.257   9.285 -10.665  1.00 63.13           C  
ATOM   6574  C   LYS E 833       2.775   8.019  -9.930  1.00 62.89           C  
ATOM   6575  O   LYS E 833       1.742   8.022  -9.243  1.00 62.43           O  
ATOM   6576  CB  LYS E 833       4.167  10.100  -9.725  1.00 62.15           C  
ATOM   6577  N   ILE E 834       3.542   6.937 -10.091  1.00 62.18           N  
ATOM   6578  CA  ILE E 834       3.263   5.659  -9.436  1.00 61.12           C  
ATOM   6579  C   ILE E 834       4.535   5.210  -8.702  1.00 60.52           C  
ATOM   6580  O   ILE E 834       5.561   4.929  -9.325  1.00 61.30           O  
ATOM   6581  CB  ILE E 834       2.838   4.548 -10.453  1.00 60.47           C  
ATOM   6582  CG1 ILE E 834       4.046   4.039 -11.247  1.00 60.65           C  
ATOM   6583  CG2 ILE E 834       1.807   5.098 -11.418  1.00 59.95           C  
ATOM   6584  CD1 ILE E 834       3.811   2.721 -11.978  1.00 60.12           C  
ATOM   6585  N   GLN E 835       4.477   5.174  -7.375  1.00 59.12           N  
ATOM   6586  CA  GLN E 835       5.629   4.760  -6.573  1.00 56.74           C  
ATOM   6587  C   GLN E 835       5.397   3.338  -6.072  1.00 54.30           C  
ATOM   6588  O   GLN E 835       4.283   2.973  -5.695  1.00 55.58           O  
ATOM   6589  CB  GLN E 835       5.828   5.712  -5.383  1.00 56.52           C  
ATOM   6590  CG  GLN E 835       7.181   6.419  -5.362  1.00 56.57           C  
ATOM   6591  CD  GLN E 835       7.352   7.357  -4.174  1.00 56.74           C  
ATOM   6592  OE1 GLN E 835       6.536   7.362  -3.256  1.00 58.02           O  
ATOM   6593  NE2 GLN E 835       8.412   8.154  -4.190  1.00 57.49           N  
ATOM   6594  N   THR E 836       6.448   2.527  -6.083  1.00 50.99           N  
ATOM   6595  CA  THR E 836       6.333   1.147  -5.627  1.00 47.88           C  
ATOM   6596  C   THR E 836       6.942   0.938  -4.241  1.00 45.36           C  
ATOM   6597  O   THR E 836       8.005   1.469  -3.925  1.00 44.88           O  
ATOM   6598  CB  THR E 836       6.991   0.189  -6.636  1.00 47.47           C  
ATOM   6599  OG1 THR E 836       6.007  -0.230  -7.589  1.00 46.51           O  
ATOM   6600  CG2 THR E 836       7.584  -1.018  -5.938  1.00 49.01           C  
ATOM   6601  N   ALA E 837       6.252   0.167  -3.411  1.00 43.53           N  
ATOM   6602  CA  ALA E 837       6.731  -0.117  -2.059  1.00 41.19           C  
ATOM   6603  C   ALA E 837       6.458  -1.563  -1.656  1.00 38.31           C  
ATOM   6604  O   ALA E 837       5.543  -2.217  -2.167  1.00 37.17           O  
ATOM   6605  CB  ALA E 837       6.079   0.848  -1.042  1.00 39.62           C  
ATOM   6606  N   GLU E 838       7.276  -2.059  -0.743  1.00 36.13           N  
ATOM   6607  CA  GLU E 838       7.120  -3.409  -0.253  1.00 34.14           C  
ATOM   6608  C   GLU E 838       7.152  -3.380   1.267  1.00 33.93           C  
ATOM   6609  O   GLU E 838       7.993  -2.710   1.868  1.00 32.31           O  
ATOM   6610  CB  GLU E 838       8.232  -4.307  -0.800  1.00 32.04           C  
ATOM   6611  CG  GLU E 838       8.095  -4.613  -2.279  1.00 29.15           C  
ATOM   6612  CD  GLU E 838       9.051  -5.698  -2.749  1.00 30.28           C  
ATOM   6613  OE1 GLU E 838      10.240  -5.663  -2.376  1.00 30.93           O  
ATOM   6614  OE2 GLU E 838       8.620  -6.588  -3.504  1.00 31.21           O  
ATOM   6615  N   PHE E 839       6.209  -4.087   1.880  1.00 34.28           N  
ATOM   6616  CA  PHE E 839       6.134  -4.162   3.331  1.00 35.61           C  
ATOM   6617  C   PHE E 839       6.269  -5.618   3.761  1.00 36.71           C  
ATOM   6618  O   PHE E 839       5.574  -6.500   3.242  1.00 37.17           O  
ATOM   6619  CB  PHE E 839       4.811  -3.576   3.834  1.00 35.51           C  
ATOM   6620  CG  PHE E 839       4.659  -2.100   3.570  1.00 36.35           C  
ATOM   6621  CD1 PHE E 839       4.496  -1.622   2.271  1.00 36.76           C  
ATOM   6622  CD2 PHE E 839       4.689  -1.188   4.617  1.00 36.22           C  
ATOM   6623  CE1 PHE E 839       4.367  -0.265   2.020  1.00 34.92           C  
ATOM   6624  CE2 PHE E 839       4.560   0.181   4.373  1.00 36.54           C  
ATOM   6625  CZ  PHE E 839       4.400   0.640   3.075  1.00 36.18           C  
ATOM   6626  N   LYS E 840       7.169  -5.873   4.709  1.00 37.22           N  
ATOM   6627  CA  LYS E 840       7.401  -7.234   5.185  1.00 35.97           C  
ATOM   6628  C   LYS E 840       6.991  -7.493   6.633  1.00 34.63           C  
ATOM   6629  O   LYS E 840       7.153  -6.642   7.514  1.00 33.44           O  
ATOM   6630  CB  LYS E 840       8.875  -7.602   4.988  1.00 34.90           C  
ATOM   6631  CG  LYS E 840       9.266  -7.746   3.525  1.00 37.17           C  
ATOM   6632  CD  LYS E 840      10.733  -8.141   3.337  1.00 38.71           C  
ATOM   6633  CE  LYS E 840      11.025  -8.501   1.876  1.00 40.14           C  
ATOM   6634  NZ  LYS E 840      12.471  -8.789   1.618  1.00 43.07           N  
ATOM   6635  N   GLY E 841       6.455  -8.688   6.862  1.00 33.63           N  
ATOM   6636  CA  GLY E 841       6.036  -9.082   8.197  1.00 33.87           C  
ATOM   6637  C   GLY E 841       4.899 -10.086   8.157  1.00 33.49           C  
ATOM   6638  O   GLY E 841       4.719 -10.817   7.176  1.00 31.64           O  
ATOM   6639  N   THR E 842       4.127 -10.151   9.235  1.00 33.86           N  
ATOM   6640  CA  THR E 842       2.990 -11.054   9.226  1.00 33.46           C  
ATOM   6641  C   THR E 842       2.085 -10.382   8.221  1.00 32.59           C  
ATOM   6642  O   THR E 842       2.133  -9.161   8.065  1.00 31.92           O  
ATOM   6643  CB  THR E 842       2.250 -11.099  10.578  1.00 34.52           C  
ATOM   6644  OG1 THR E 842       1.622  -9.829  10.818  1.00 29.88           O  
ATOM   6645  CG2 THR E 842       3.226 -11.461  11.722  1.00 33.00           C  
ATOM   6646  N   PHE E 843       1.268 -11.158   7.531  1.00 31.53           N  
ATOM   6647  CA  PHE E 843       0.383 -10.562   6.559  1.00 32.04           C  
ATOM   6648  C   PHE E 843      -0.309  -9.340   7.136  1.00 33.89           C  
ATOM   6649  O   PHE E 843      -0.249  -8.256   6.571  1.00 37.44           O  
ATOM   6650  CB  PHE E 843      -0.687 -11.546   6.117  1.00 28.56           C  
ATOM   6651  CG  PHE E 843      -1.654 -10.977   5.119  1.00 24.96           C  
ATOM   6652  CD1 PHE E 843      -1.515 -11.250   3.762  1.00 23.67           C  
ATOM   6653  CD2 PHE E 843      -2.736 -10.202   5.543  1.00 23.47           C  
ATOM   6654  CE1 PHE E 843      -2.447 -10.767   2.840  1.00 21.11           C  
ATOM   6655  CE2 PHE E 843      -3.669  -9.714   4.633  1.00 19.37           C  
ATOM   6656  CZ  PHE E 843      -3.525 -10.000   3.282  1.00 20.09           C  
ATOM   6657  N   GLU E 844      -0.957  -9.506   8.275  1.00 34.36           N  
ATOM   6658  CA  GLU E 844      -1.687  -8.392   8.847  1.00 36.85           C  
ATOM   6659  C   GLU E 844      -0.822  -7.301   9.457  1.00 36.18           C  
ATOM   6660  O   GLU E 844      -1.313  -6.201   9.686  1.00 37.20           O  
ATOM   6661  CB  GLU E 844      -2.682  -8.879   9.892  1.00 39.29           C  
ATOM   6662  CG  GLU E 844      -2.141  -8.738  11.276  1.00 48.95           C  
ATOM   6663  CD  GLU E 844      -2.808  -9.634  12.293  1.00 52.41           C  
ATOM   6664  OE1 GLU E 844      -2.278  -9.683  13.428  1.00 53.10           O  
ATOM   6665  OE2 GLU E 844      -3.847 -10.271  11.972  1.00 54.42           O  
ATOM   6666  N   GLU E 845       0.439  -7.578   9.753  1.00 36.70           N  
ATOM   6667  CA  GLU E 845       1.284  -6.519  10.326  1.00 37.08           C  
ATOM   6668  C   GLU E 845       1.794  -5.629   9.195  1.00 34.98           C  
ATOM   6669  O   GLU E 845       1.901  -4.412   9.334  1.00 32.22           O  
ATOM   6670  CB  GLU E 845       2.462  -7.107  11.110  1.00 38.19           C  
ATOM   6671  CG  GLU E 845       2.061  -7.666  12.466  1.00 42.67           C  
ATOM   6672  CD  GLU E 845       3.242  -8.202  13.250  1.00 45.78           C  
ATOM   6673  OE1 GLU E 845       4.200  -8.715  12.612  1.00 48.16           O  
ATOM   6674  OE2 GLU E 845       3.199  -8.126  14.499  1.00 44.93           O  
ATOM   6675  N   ALA E 846       2.094  -6.257   8.063  1.00 33.47           N  
ATOM   6676  CA  ALA E 846       2.561  -5.537   6.895  1.00 32.51           C  
ATOM   6677  C   ALA E 846       1.399  -4.735   6.294  1.00 32.04           C  
ATOM   6678  O   ALA E 846       1.520  -3.542   6.023  1.00 32.39           O  
ATOM   6679  CB  ALA E 846       3.113  -6.521   5.873  1.00 32.54           C  
ATOM   6680  N   THR E 847       0.263  -5.389   6.097  1.00 30.01           N  
ATOM   6681  CA  THR E 847      -0.871  -4.702   5.522  1.00 30.50           C  
ATOM   6682  C   THR E 847      -1.219  -3.483   6.348  1.00 30.83           C  
ATOM   6683  O   THR E 847      -1.507  -2.417   5.806  1.00 30.85           O  
ATOM   6684  CB  THR E 847      -2.094  -5.617   5.426  1.00 30.06           C  
ATOM   6685  OG1 THR E 847      -1.748  -6.772   4.652  1.00 30.48           O  
ATOM   6686  CG2 THR E 847      -3.261  -4.888   4.745  1.00 27.46           C  
ATOM   6687  N   ALA E 848      -1.187  -3.639   7.662  1.00 31.47           N  
ATOM   6688  CA  ALA E 848      -1.498  -2.530   8.545  1.00 32.72           C  
ATOM   6689  C   ALA E 848      -0.421  -1.455   8.416  1.00 33.88           C  
ATOM   6690  O   ALA E 848      -0.723  -0.265   8.407  1.00 32.99           O  
ATOM   6691  CB  ALA E 848      -1.602  -3.017   9.988  1.00 31.04           C  
ATOM   6692  N   GLU E 849       0.839  -1.868   8.319  1.00 35.77           N  
ATOM   6693  CA  GLU E 849       1.926  -0.894   8.177  1.00 38.65           C  
ATOM   6694  C   GLU E 849       1.797  -0.174   6.831  1.00 38.60           C  
ATOM   6695  O   GLU E 849       2.177   0.999   6.692  1.00 39.24           O  
ATOM   6696  CB  GLU E 849       3.296  -1.580   8.248  1.00 40.62           C  
ATOM   6697  CG  GLU E 849       3.819  -1.845   9.660  1.00 46.54           C  
ATOM   6698  CD  GLU E 849       3.570  -0.697  10.627  1.00 50.43           C  
ATOM   6699  OE1 GLU E 849       2.423  -0.559  11.132  1.00 52.94           O  
ATOM   6700  OE2 GLU E 849       4.529   0.076  10.881  1.00 52.22           O  
ATOM   6701  N   ALA E 850       1.262  -0.890   5.848  1.00 36.55           N  
ATOM   6702  CA  ALA E 850       1.074  -0.335   4.524  1.00 35.26           C  
ATOM   6703  C   ALA E 850       0.093   0.837   4.615  1.00 34.29           C  
ATOM   6704  O   ALA E 850       0.370   1.932   4.117  1.00 33.33           O  
ATOM   6705  CB  ALA E 850       0.544  -1.409   3.581  1.00 34.09           C  
ATOM   6706  N   TYR E 851      -1.041   0.607   5.270  1.00 32.65           N  
ATOM   6707  CA  TYR E 851      -2.048   1.644   5.420  1.00 31.86           C  
ATOM   6708  C   TYR E 851      -1.562   2.812   6.266  1.00 32.93           C  
ATOM   6709  O   TYR E 851      -1.860   3.968   5.954  1.00 32.98           O  
ATOM   6710  CB  TYR E 851      -3.325   1.073   6.027  1.00 30.06           C  
ATOM   6711  CG  TYR E 851      -4.156   0.263   5.061  1.00 30.80           C  
ATOM   6712  CD1 TYR E 851      -4.692   0.850   3.908  1.00 30.38           C  
ATOM   6713  CD2 TYR E 851      -4.437  -1.085   5.305  1.00 30.64           C  
ATOM   6714  CE1 TYR E 851      -5.499   0.115   3.021  1.00 29.36           C  
ATOM   6715  CE2 TYR E 851      -5.240  -1.831   4.427  1.00 30.31           C  
ATOM   6716  CZ  TYR E 851      -5.765  -1.219   3.290  1.00 29.39           C  
ATOM   6717  OH  TYR E 851      -6.556  -1.924   2.428  1.00 29.53           O  
ATOM   6718  N   ARG E 852      -0.812   2.530   7.329  1.00 33.39           N  
ATOM   6719  CA  ARG E 852      -0.332   3.622   8.165  1.00 33.68           C  
ATOM   6720  C   ARG E 852       0.567   4.498   7.326  1.00 34.67           C  
ATOM   6721  O   ARG E 852       0.671   5.700   7.561  1.00 35.95           O  
ATOM   6722  CB  ARG E 852       0.434   3.118   9.396  1.00 32.87           C  
ATOM   6723  CG  ARG E 852       0.489   4.189  10.487  1.00 32.86           C  
ATOM   6724  CD  ARG E 852       0.964   3.692  11.828  1.00 31.07           C  
ATOM   6725  NE  ARG E 852       2.416   3.727  11.997  1.00 32.51           N  
ATOM   6726  CZ  ARG E 852       3.283   3.032  11.264  1.00 33.68           C  
ATOM   6727  NH1 ARG E 852       2.847   2.241  10.293  1.00 35.76           N  
ATOM   6728  NH2 ARG E 852       4.587   3.110  11.515  1.00 31.57           N  
ATOM   6729  N   TYR E 853       1.213   3.883   6.340  1.00 34.87           N  
ATOM   6730  CA  TYR E 853       2.093   4.607   5.448  1.00 34.20           C  
ATOM   6731  C   TYR E 853       1.200   5.494   4.576  1.00 36.06           C  
ATOM   6732  O   TYR E 853       1.278   6.719   4.632  1.00 36.56           O  
ATOM   6733  CB  TYR E 853       2.898   3.624   4.586  1.00 31.88           C  
ATOM   6734  CG  TYR E 853       4.075   4.249   3.856  1.00 30.19           C  
ATOM   6735  CD1 TYR E 853       5.056   4.968   4.548  1.00 29.34           C  
ATOM   6736  CD2 TYR E 853       4.203   4.129   2.475  1.00 28.73           C  
ATOM   6737  CE1 TYR E 853       6.141   5.557   3.877  1.00 29.76           C  
ATOM   6738  CE2 TYR E 853       5.279   4.708   1.792  1.00 31.05           C  
ATOM   6739  CZ  TYR E 853       6.247   5.423   2.495  1.00 30.96           C  
ATOM   6740  OH  TYR E 853       7.311   5.992   1.816  1.00 28.87           O  
ATOM   6741  N   ALA E 854       0.331   4.881   3.787  1.00 37.23           N  
ATOM   6742  CA  ALA E 854      -0.557   5.658   2.927  1.00 39.37           C  
ATOM   6743  C   ALA E 854      -1.289   6.745   3.724  1.00 40.18           C  
ATOM   6744  O   ALA E 854      -1.761   7.727   3.157  1.00 41.16           O  
ATOM   6745  CB  ALA E 854      -1.571   4.739   2.233  1.00 37.27           C  
ATOM   6746  N   ASP E 855      -1.382   6.573   5.035  1.00 40.14           N  
ATOM   6747  CA  ASP E 855      -2.071   7.557   5.850  1.00 40.49           C  
ATOM   6748  C   ASP E 855      -1.171   8.774   6.064  1.00 42.27           C  
ATOM   6749  O   ASP E 855      -1.642   9.885   6.348  1.00 42.93           O  
ATOM   6750  CB  ASP E 855      -2.486   6.937   7.194  1.00 39.57           C  
ATOM   6751  CG  ASP E 855      -3.727   6.023   7.081  1.00 39.08           C  
ATOM   6752  OD1 ASP E 855      -4.120   5.444   8.112  1.00 37.32           O  
ATOM   6753  OD2 ASP E 855      -4.311   5.880   5.984  1.00 36.97           O  
ATOM   6754  N   LEU E 856       0.131   8.566   5.917  1.00 42.46           N  
ATOM   6755  CA  LEU E 856       1.078   9.654   6.090  1.00 43.06           C  
ATOM   6756  C   LEU E 856       1.167  10.444   4.788  1.00 42.98           C  
ATOM   6757  O   LEU E 856       1.232  11.671   4.791  1.00 42.89           O  
ATOM   6758  CB  LEU E 856       2.455   9.106   6.465  1.00 42.79           C  
ATOM   6759  CG  LEU E 856       3.502  10.154   6.841  1.00 42.85           C  
ATOM   6760  CD1 LEU E 856       3.024  10.925   8.054  1.00 42.98           C  
ATOM   6761  CD2 LEU E 856       4.832   9.486   7.133  1.00 45.28           C  
ATOM   6762  N   LEU E 857       1.164   9.723   3.677  1.00 43.23           N  
ATOM   6763  CA  LEU E 857       1.228  10.339   2.365  1.00 43.07           C  
ATOM   6764  C   LEU E 857      -0.018  11.163   2.105  1.00 43.96           C  
ATOM   6765  O   LEU E 857       0.061  12.263   1.563  1.00 45.09           O  
ATOM   6766  CB  LEU E 857       1.368   9.260   1.294  1.00 42.08           C  
ATOM   6767  CG  LEU E 857       2.802   8.813   1.005  1.00 41.07           C  
ATOM   6768  CD1 LEU E 857       3.601   8.736   2.296  1.00 39.94           C  
ATOM   6769  CD2 LEU E 857       2.771   7.477   0.272  1.00 41.93           C  
ATOM   6770  N   ALA E 858      -1.172  10.639   2.499  1.00 44.09           N  
ATOM   6771  CA  ALA E 858      -2.418  11.357   2.288  1.00 43.80           C  
ATOM   6772  C   ALA E 858      -2.388  12.709   2.983  1.00 43.65           C  
ATOM   6773  O   ALA E 858      -3.100  13.623   2.592  1.00 45.62           O  
ATOM   6774  CB  ALA E 858      -3.591  10.532   2.794  1.00 43.66           C  
ATOM   6775  N   LYS E 859      -1.567  12.838   4.017  1.00 43.71           N  
ATOM   6776  CA  LYS E 859      -1.472  14.105   4.725  1.00 44.07           C  
ATOM   6777  C   LYS E 859      -1.013  15.224   3.793  1.00 45.46           C  
ATOM   6778  O   LYS E 859      -1.024  16.393   4.179  1.00 47.13           O  
ATOM   6779  CB  LYS E 859      -0.513  13.998   5.913  1.00 43.50           C  
ATOM   6780  CG  LYS E 859      -1.225  13.889   7.241  1.00 44.90           C  
ATOM   6781  CD  LYS E 859      -0.255  13.861   8.404  1.00 47.25           C  
ATOM   6782  CE  LYS E 859      -0.992  13.969   9.747  1.00 49.18           C  
ATOM   6783  NZ  LYS E 859      -1.592  15.328   9.995  1.00 50.03           N  
ATOM   6784  N   VAL E 860      -0.604  14.861   2.574  1.00 44.78           N  
ATOM   6785  CA  VAL E 860      -0.152  15.831   1.572  1.00 42.18           C  
ATOM   6786  C   VAL E 860      -0.495  15.331   0.171  1.00 42.31           C  
ATOM   6787  O   VAL E 860      -0.272  16.025  -0.817  1.00 42.47           O  
ATOM   6788  CB  VAL E 860       1.384  16.075   1.659  1.00 41.79           C  
ATOM   6789  CG1 VAL E 860       1.912  15.635   3.017  1.00 40.11           C  
ATOM   6790  CG2 VAL E 860       2.110  15.362   0.526  1.00 39.75           C  
ATOM   6791  N   ASN E 861      -1.041  14.121   0.100  1.00 42.67           N  
ATOM   6792  CA  ASN E 861      -1.425  13.490  -1.159  1.00 41.48           C  
ATOM   6793  C   ASN E 861      -2.925  13.369  -1.321  1.00 40.73           C  
ATOM   6794  O   ASN E 861      -3.400  13.006  -2.399  1.00 40.45           O  
ATOM   6795  CB  ASN E 861      -0.831  12.097  -1.241  1.00 43.92           C  
ATOM   6796  CG  ASN E 861       0.425  12.051  -2.054  1.00 45.57           C  
ATOM   6797  OD1 ASN E 861       0.370  11.838  -3.267  1.00 47.50           O  
ATOM   6798  ND2 ASN E 861       1.571  12.257  -1.403  1.00 41.94           N  
ATOM   6799  N   GLY E 862      -3.662  13.639  -0.242  1.00 39.48           N  
ATOM   6800  CA  GLY E 862      -5.117  13.565  -0.271  1.00 40.60           C  
ATOM   6801  C   GLY E 862      -5.711  12.221   0.128  1.00 41.55           C  
ATOM   6802  O   GLY E 862      -5.032  11.198   0.061  1.00 42.25           O  
ATOM   6803  N   GLU E 863      -6.980  12.210   0.533  1.00 42.00           N  
ATOM   6804  CA  GLU E 863      -7.628  10.960   0.924  1.00 42.54           C  
ATOM   6805  C   GLU E 863      -7.374   9.934  -0.170  1.00 41.65           C  
ATOM   6806  O   GLU E 863      -7.074  10.306  -1.306  1.00 42.08           O  
ATOM   6807  CB  GLU E 863      -9.134  11.152   1.115  1.00 43.33           C  
ATOM   6808  CG  GLU E 863      -9.542  12.187   2.178  1.00 47.60           C  
ATOM   6809  CD  GLU E 863      -8.907  11.970   3.568  1.00 50.73           C  
ATOM   6810  OE1 GLU E 863      -9.522  12.396   4.579  1.00 51.50           O  
ATOM   6811  OE2 GLU E 863      -7.797  11.397   3.655  1.00 50.60           O  
ATOM   6812  N   TYR E 864      -7.472   8.649   0.166  1.00 39.91           N  
ATOM   6813  CA  TYR E 864      -7.233   7.602  -0.822  1.00 38.88           C  
ATOM   6814  C   TYR E 864      -8.235   6.463  -0.776  1.00 38.34           C  
ATOM   6815  O   TYR E 864      -9.147   6.435   0.053  1.00 40.12           O  
ATOM   6816  CB  TYR E 864      -5.819   7.033  -0.659  1.00 39.77           C  
ATOM   6817  CG  TYR E 864      -5.596   6.275   0.639  1.00 41.05           C  
ATOM   6818  CD1 TYR E 864      -6.021   4.948   0.790  1.00 38.68           C  
ATOM   6819  CD2 TYR E 864      -4.970   6.892   1.726  1.00 41.33           C  
ATOM   6820  CE1 TYR E 864      -5.825   4.261   1.987  1.00 36.71           C  
ATOM   6821  CE2 TYR E 864      -4.775   6.214   2.925  1.00 40.74           C  
ATOM   6822  CZ  TYR E 864      -5.202   4.899   3.046  1.00 38.40           C  
ATOM   6823  OH  TYR E 864      -4.976   4.243   4.226  1.00 37.64           O  
ATOM   6824  N   THR E 865      -8.039   5.512  -1.674  1.00 37.22           N  
ATOM   6825  CA  THR E 865      -8.899   4.348  -1.773  1.00 37.39           C  
ATOM   6826  C   THR E 865      -8.012   3.154  -2.123  1.00 38.17           C  
ATOM   6827  O   THR E 865      -6.908   3.338  -2.662  1.00 38.73           O  
ATOM   6828  CB  THR E 865      -9.990   4.587  -2.853  1.00 37.66           C  
ATOM   6829  OG1 THR E 865     -11.186   5.023  -2.200  1.00 37.75           O  
ATOM   6830  CG2 THR E 865     -10.268   3.332  -3.682  1.00 35.20           C  
ATOM   6831  N   ALA E 866      -8.476   1.940  -1.819  1.00 36.34           N  
ATOM   6832  CA  ALA E 866      -7.682   0.758  -2.112  1.00 33.88           C  
ATOM   6833  C   ALA E 866      -8.481  -0.382  -2.706  1.00 33.42           C  
ATOM   6834  O   ALA E 866      -9.679  -0.504  -2.462  1.00 30.92           O  
ATOM   6835  CB  ALA E 866      -6.983   0.295  -0.850  1.00 33.54           C  
ATOM   6836  N   ASP E 867      -7.795  -1.202  -3.499  1.00 34.88           N  
ATOM   6837  CA  ASP E 867      -8.378  -2.382  -4.139  1.00 37.23           C  
ATOM   6838  C   ASP E 867      -7.341  -3.507  -4.036  1.00 38.37           C  
ATOM   6839  O   ASP E 867      -6.131  -3.248  -4.006  1.00 37.75           O  
ATOM   6840  CB  ASP E 867      -8.725  -2.091  -5.608  1.00 38.96           C  
ATOM   6841  CG  ASP E 867      -7.493  -1.755  -6.457  1.00 42.37           C  
ATOM   6842  OD1 ASP E 867      -6.830  -2.694  -6.965  1.00 41.96           O  
ATOM   6843  OD2 ASP E 867      -7.173  -0.546  -6.606  1.00 42.97           O  
ATOM   6844  N   LEU E 868      -7.810  -4.750  -3.978  1.00 38.44           N  
ATOM   6845  CA  LEU E 868      -6.918  -5.895  -3.832  1.00 39.28           C  
ATOM   6846  C   LEU E 868      -6.672  -6.746  -5.076  1.00 40.52           C  
ATOM   6847  O   LEU E 868      -7.594  -7.072  -5.825  1.00 40.56           O  
ATOM   6848  CB  LEU E 868      -7.428  -6.812  -2.698  1.00 38.33           C  
ATOM   6849  CG  LEU E 868      -6.810  -6.699  -1.293  1.00 36.37           C  
ATOM   6850  CD1 LEU E 868      -6.390  -5.258  -0.989  1.00 37.10           C  
ATOM   6851  CD2 LEU E 868      -7.819  -7.185  -0.280  1.00 32.76           C  
ATOM   6852  N   GLU E 869      -5.407  -7.109  -5.273  1.00 41.73           N  
ATOM   6853  CA  GLU E 869      -4.983  -7.968  -6.376  1.00 42.34           C  
ATOM   6854  C   GLU E 869      -4.204  -9.096  -5.730  1.00 41.73           C  
ATOM   6855  O   GLU E 869      -3.878  -9.026  -4.545  1.00 40.98           O  
ATOM   6856  CB  GLU E 869      -4.036  -7.237  -7.333  1.00 43.65           C  
ATOM   6857  CG  GLU E 869      -4.688  -6.342  -8.360  1.00 47.13           C  
ATOM   6858  CD  GLU E 869      -3.664  -5.693  -9.272  1.00 49.81           C  
ATOM   6859  OE1 GLU E 869      -4.057  -4.846 -10.098  1.00 51.21           O  
ATOM   6860  OE2 GLU E 869      -2.463  -6.033  -9.169  1.00 51.78           O  
ATOM   6861  N   ASP E 870      -3.910 -10.130  -6.508  1.00 41.38           N  
ATOM   6862  CA  ASP E 870      -3.117 -11.255  -6.019  1.00 43.20           C  
ATOM   6863  C   ASP E 870      -3.594 -11.827  -4.669  1.00 42.88           C  
ATOM   6864  O   ASP E 870      -2.807 -11.962  -3.732  1.00 42.06           O  
ATOM   6865  CB  ASP E 870      -1.648 -10.803  -5.919  1.00 45.40           C  
ATOM   6866  CG  ASP E 870      -0.683 -11.958  -5.746  1.00 47.21           C  
ATOM   6867  OD1 ASP E 870       0.526 -11.687  -5.566  1.00 47.76           O  
ATOM   6868  OD2 ASP E 870      -1.125 -13.128  -5.798  1.00 48.63           O  
ATOM   6869  N   GLY E 871      -4.883 -12.149  -4.572  1.00 42.54           N  
ATOM   6870  CA  GLY E 871      -5.423 -12.711  -3.342  1.00 42.67           C  
ATOM   6871  C   GLY E 871      -5.320 -11.856  -2.089  1.00 43.02           C  
ATOM   6872  O   GLY E 871      -5.790 -12.258  -1.017  1.00 42.54           O  
ATOM   6873  N   GLY E 872      -4.705 -10.683  -2.213  1.00 43.17           N  
ATOM   6874  CA  GLY E 872      -4.569  -9.796  -1.072  1.00 42.50           C  
ATOM   6875  C   GLY E 872      -3.140  -9.388  -0.766  1.00 41.84           C  
ATOM   6876  O   GLY E 872      -2.916  -8.470   0.028  1.00 39.95           O  
ATOM   6877  N   ASN E 873      -2.175 -10.055  -1.398  1.00 41.98           N  
ATOM   6878  CA  ASN E 873      -0.761  -9.757  -1.173  1.00 43.70           C  
ATOM   6879  C   ASN E 873      -0.311  -8.526  -1.952  1.00 44.41           C  
ATOM   6880  O   ASN E 873       0.806  -8.023  -1.784  1.00 42.95           O  
ATOM   6881  CB  ASN E 873       0.106 -10.954  -1.563  1.00 45.78           C  
ATOM   6882  CG  ASN E 873      -0.264 -12.219  -0.807  1.00 47.04           C  
ATOM   6883  OD1 ASN E 873      -0.826 -13.146  -1.381  1.00 50.09           O  
ATOM   6884  ND2 ASN E 873       0.047 -12.262   0.485  1.00 47.01           N  
ATOM   6885  N   HIS E 874      -1.191  -8.057  -2.825  1.00 44.50           N  
ATOM   6886  CA  HIS E 874      -0.912  -6.885  -3.619  1.00 43.34           C  
ATOM   6887  C   HIS E 874      -2.045  -5.915  -3.379  1.00 42.40           C  
ATOM   6888  O   HIS E 874      -3.210  -6.291  -3.418  1.00 42.40           O  
ATOM   6889  CB  HIS E 874      -0.864  -7.231  -5.103  1.00 44.74           C  
ATOM   6890  CG  HIS E 874      -0.561  -6.054  -5.977  1.00 46.97           C  
ATOM   6891  ND1 HIS E 874       0.694  -5.816  -6.495  1.00 47.31           N  
ATOM   6892  CD2 HIS E 874      -1.337  -5.012  -6.364  1.00 47.54           C  
ATOM   6893  CE1 HIS E 874       0.680  -4.674  -7.165  1.00 47.33           C  
ATOM   6894  NE2 HIS E 874      -0.538  -4.170  -7.099  1.00 48.99           N  
ATOM   6895  N   MET E 875      -1.719  -4.670  -3.099  1.00 41.61           N  
ATOM   6896  CA  MET E 875      -2.785  -3.717  -2.906  1.00 42.53           C  
ATOM   6897  C   MET E 875      -2.440  -2.434  -3.622  1.00 41.81           C  
ATOM   6898  O   MET E 875      -1.284  -2.028  -3.672  1.00 43.89           O  
ATOM   6899  CB  MET E 875      -3.078  -3.481  -1.409  1.00 43.35           C  
ATOM   6900  CG  MET E 875      -1.960  -2.870  -0.558  1.00 44.92           C  
ATOM   6901  SD  MET E 875      -2.418  -2.724   1.228  1.00 45.24           S  
ATOM   6902  CE  MET E 875      -2.951  -1.064   1.314  1.00 41.57           C  
ATOM   6903  N   ASN E 876      -3.450  -1.824  -4.219  1.00 39.97           N  
ATOM   6904  CA  ASN E 876      -3.269  -0.580  -4.927  1.00 37.15           C  
ATOM   6905  C   ASN E 876      -3.898   0.507  -4.093  1.00 36.38           C  
ATOM   6906  O   ASN E 876      -5.052   0.392  -3.674  1.00 35.04           O  
ATOM   6907  CB  ASN E 876      -3.955  -0.645  -6.282  1.00 37.22           C  
ATOM   6908  CG  ASN E 876      -3.407  -1.740  -7.147  1.00 38.13           C  
ATOM   6909  OD1 ASN E 876      -2.206  -1.788  -7.402  1.00 39.77           O  
ATOM   6910  ND2 ASN E 876      -4.282  -2.632  -7.611  1.00 38.71           N  
ATOM   6911  N   ILE E 877      -3.131   1.552  -3.830  1.00 36.83           N  
ATOM   6912  CA  ILE E 877      -3.644   2.670  -3.062  1.00 39.65           C  
ATOM   6913  C   ILE E 877      -3.637   3.916  -3.935  1.00 42.35           C  
ATOM   6914  O   ILE E 877      -2.586   4.509  -4.190  1.00 43.71           O  
ATOM   6915  CB  ILE E 877      -2.814   2.920  -1.787  1.00 38.52           C  
ATOM   6916  CG1 ILE E 877      -3.185   1.866  -0.736  1.00 36.43           C  
ATOM   6917  CG2 ILE E 877      -3.062   4.344  -1.262  1.00 37.38           C  
ATOM   6918  CD1 ILE E 877      -2.612   2.117   0.626  1.00 36.95           C  
ATOM   6919  N   LYS E 878      -4.818   4.302  -4.402  1.00 43.79           N  
ATOM   6920  CA  LYS E 878      -4.946   5.462  -5.260  1.00 45.27           C  
ATOM   6921  C   LYS E 878      -5.290   6.694  -4.437  1.00 47.14           C  
ATOM   6922  O   LYS E 878      -6.205   6.650  -3.610  1.00 46.82           O  
ATOM   6923  CB  LYS E 878      -6.019   5.207  -6.297  1.00 45.34           C  
ATOM   6924  N   PHE E 879      -4.546   7.780  -4.656  1.00 49.18           N  
ATOM   6925  CA  PHE E 879      -4.790   9.042  -3.954  1.00 51.44           C  
ATOM   6926  C   PHE E 879      -5.555   9.989  -4.873  1.00 53.51           C  
ATOM   6927  O   PHE E 879      -5.445   9.879  -6.101  1.00 54.01           O  
ATOM   6928  CB  PHE E 879      -3.485   9.734  -3.569  1.00 51.19           C  
ATOM   6929  CG  PHE E 879      -2.592   8.922  -2.688  1.00 50.75           C  
ATOM   6930  CD1 PHE E 879      -1.703   8.003  -3.233  1.00 51.22           C  
ATOM   6931  CD2 PHE E 879      -2.599   9.114  -1.313  1.00 50.25           C  
ATOM   6932  CE1 PHE E 879      -0.823   7.287  -2.423  1.00 50.58           C  
ATOM   6933  CE2 PHE E 879      -1.723   8.403  -0.491  1.00 51.44           C  
ATOM   6934  CZ  PHE E 879      -0.830   7.487  -1.049  1.00 50.48           C  
ATOM   6935  N   ALA E 880      -6.313  10.917  -4.281  1.00 55.37           N  
ATOM   6936  CA  ALA E 880      -7.089  11.902  -5.051  1.00 56.77           C  
ATOM   6937  C   ALA E 880      -6.814  13.343  -4.593  1.00 58.06           C  
ATOM   6938  O   ALA E 880      -6.263  13.530  -3.483  1.00 59.81           O  
ATOM   6939  CB  ALA E 880      -8.584  11.600  -4.940  1.00 55.05           C  
ATOM   6940  OXT ALA E 880      -7.161  14.279  -5.345  1.00 57.58           O  
TER    6941      ALA E 880                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
