
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  197 ( 1917),  selected  197 , name 1cgp_A
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 1cgp_A.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     9_A      M       1           -
LGA    T    10_A      H       2           -
LGA    L    11_A      T       3           #
LGA    -       -      A       4           -
LGA    -       -      L       5           -
LGA    E    12_A      I       6          4.190
LGA    -       -      N       7           -
LGA    -       -      H       8           -
LGA    -       -      I       9           -
LGA    -       -      R      10           -
LGA    -       -      K      11           -
LGA    -       -      F      12           -
LGA    -       -      I      13           -
LGA    -       -      F      14           -
LGA    -       -      L      15           -
LGA    -       -      T      16           -
LGA    -       -      D      17           -
LGA    -       -      E      18           -
LGA    -       -      D      19           -
LGA    W    13_A      A      20          2.780
LGA    -       -      G      21           -
LGA    -       -      T      22           -
LGA    F    14_A      L      23          2.190
LGA    L    15_A      S      24          2.480
LGA    S    16_A      A      25          2.503
LGA    H    17_A      F      26          2.402
LGA    C    18_A      F      27          1.713
LGA    H    19_A      Q      28          1.794
LGA    I    20_A      L      29          0.759
LGA    H    21_A      K      30          1.350
LGA    K    22_A      K      31          0.503
LGA    Y    23_A      V      32          0.435
LGA    P    24_A      R      33          0.125
LGA    S    25_A      K      34          0.696
LGA    K    26_A      K      35          0.727
LGA    S    27_A      E      36          0.718
LGA    T    28_A      T      37          1.052
LGA    L    29_A      L      38          1.114
LGA    I    30_A      L      39          1.661
LGA    H    31_A      K      40          1.509
LGA    Q    32_A      T      41          2.551
LGA    G    33_A      G      42          2.344
LGA    E    34_A      E      43          1.436
LGA    K    35_A      I      44          0.755
LGA    A    36_A      C      45          1.564
LGA    E    37_A      R      46          1.691
LGA    T    38_A      I      47          2.254
LGA    L    39_A      N      48          2.237
LGA    Y    40_A      Y      49          2.154
LGA    Y    41_A      F      50          1.813
LGA    I    42_A      V      51          1.588
LGA    V    43_A      V      52          1.894
LGA    K    44_A      K      53          1.704
LGA    G    45_A      G      54          1.371
LGA    S    46_A      C      55          1.064
LGA    V    47_A      L      56          1.244
LGA    A    48_A      R      57          1.582
LGA    V    49_A      L      58          1.730
LGA    L    50_A      F      59          1.729
LGA    I    51_A      F      60          2.139
LGA    K    52_A      I      61          2.185
LGA    D    53_A      D      62          0.427
LGA    E    54_A      E      63          1.983
LGA    E    55_A      K      64          1.053
LGA    G    56_A      G      65          1.518
LGA    K    57_A      I      66          1.995
LGA    E    58_A      E      67          2.386
LGA    M    59_A      Q      68          2.245
LGA    I    60_A      T      69          1.973
LGA    L    61_A      T      70          1.497
LGA    S    62_A      Q      71          2.072
LGA    Y    63_A      F      72          1.708
LGA    L    64_A      A      73          0.493
LGA    N    65_A      I      74          0.847
LGA    Q    66_A      E      75          1.638
LGA    G    67_A      N      76          1.607
LGA    D    68_A      W      77          1.614
LGA    F    69_A      W      78          2.021
LGA    I    70_A      L      79          2.005
LGA    G    71_A      S      80          1.926
LGA    E    72_A      D      81           #
LGA    L    73_A      Y      82          1.493
LGA    -       -      M      83           -
LGA    G    74_A      A      84          4.090
LGA    L    75_A      F      85          4.591
LGA    F    76_A      Q      86          3.182
LGA    E    77_A      K      87          2.850
LGA    E    78_A      -       -           -
LGA    G    79_A      Q      88          2.768
LGA    Q    80_A      Q      89          2.284
LGA    E    81_A      P      90          2.513
LGA    R    82_A      A      91          2.517
LGA    S    83_A      D      92          3.488
LGA    A    84_A      F      93          2.001
LGA    W    85_A      Y      94          1.680
LGA    V    86_A      I      95          1.695
LGA    R    87_A      Q      96          1.175
LGA    A    88_A      S      97          0.631
LGA    K    89_A      V      98          1.108
LGA    T    90_A      E      99          0.984
LGA    A    91_A      N     100          1.106
LGA    C    92_A      C     101          0.862
LGA    E    93_A      E     102          1.113
LGA    V    94_A      L     103          1.202
LGA    A    95_A      L     104          1.464
LGA    E    96_A      S     105          2.023
LGA    I    97_A      I     106          2.048
LGA    S    98_A      T     107          2.690
LGA    Y    99_A      Y     108          1.869
LGA    K   100_A      T     109          1.365
LGA    K   101_A      E     110          1.826
LGA    F   102_A      Q     111          1.562
LGA    R   103_A      E     112          1.011
LGA    Q   104_A      N     113          0.954
LGA    L   105_A      L     114          0.903
LGA    I   106_A      F     115          0.250
LGA    Q   107_A      E     116          0.749
LGA    V   108_A      R     117          1.286
LGA    N   109_A      I     118          1.532
LGA    P   110_A      P     119          2.446
LGA    D   111_A      A     120          3.139
LGA    I   112_A      L     121          2.665
LGA    L   113_A      E     122          3.277
LGA    M   114_A      R     123          2.770
LGA    R   115_A      Y     124          2.228
LGA    L   116_A      F     125          2.546
LGA    S   117_A      R     126          3.340
LGA    A   118_A      L     127          2.220
LGA    Q   119_A      V     128          2.308
LGA    M   120_A      Y     129          2.387
LGA    A   121_A      Q     130          2.101
LGA    R   122_A      K     131          1.997
LGA    R   123_A      S     132          2.189
LGA    L   124_A      F     133          1.873
LGA    Q   125_A      A     134          1.725
LGA    V   126_A      A     135          2.149
LGA    T   127_A      A     136          2.122
LGA    S   128_A      Q     137          2.046
LGA    E   129_A      L     138          2.153
LGA    K   130_A      R     139          2.559
LGA    V   131_A      S     140          2.215
LGA    G   132_A      K     141          1.983
LGA    N   133_A      F     142          3.264
LGA    L   134_A      Q     143          4.106
LGA    A   135_A      H     144          3.907
LGA    F   136_A      -       -           -
LGA    L   137_A      M     145          2.405
LGA    D   138_A      -       -           -
LGA    V   139_A      -       -           -
LGA    T   140_A      -       -           -
LGA    G   141_A      -       -           -
LGA    R   142_A      Y     146          1.083
LGA    I   143_A      -       -           -
LGA    A   144_A      -       -           -
LGA    Q   145_A      -       -           -
LGA    T   146_A      -       -           -
LGA    L   147_A      -       -           -
LGA    L   148_A      -       -           -
LGA    N   149_A      -       -           -
LGA    L   150_A      -       -           -
LGA    A   151_A      -       -           -
LGA    K   152_A      -       -           -
LGA    Q   153_A      -       -           -
LGA    P   154_A      -       -           -
LGA    D   155_A      -       -           -
LGA    A   156_A      -       -           -
LGA    M   157_A      -       -           -
LGA    T   158_A      -       -           -
LGA    H   159_A      -       -           -
LGA    P   160_A      -       -           -
LGA    D   161_A      -       -           -
LGA    G   162_A      -       -           -
LGA    M   163_A      -       -           -
LGA    Q   164_A      -       -           -
LGA    I   165_A      -       -           -
LGA    K   166_A      -       -           -
LGA    I   167_A      -       -           -
LGA    T   168_A      -       -           -
LGA    R   169_A      -       -           -
LGA    Q   170_A      -       -           -
LGA    E   171_A      -       -           -
LGA    I   172_A      -       -           -
LGA    G   173_A      -       -           -
LGA    Q   174_A      -       -           -
LGA    I   175_A      -       -           -
LGA    V   176_A      -       -           -
LGA    G   177_A      -       -           -
LGA    C   178_A      -       -           -
LGA    S   179_A      -       -           -
LGA    R   180_A      -       -           -
LGA    E   181_A      -       -           -
LGA    T   182_A      -       -           -
LGA    V   183_A      -       -           -
LGA    G   184_A      -       -           -
LGA    R   185_A      -       -           -
LGA    I   186_A      -       -           -
LGA    L   187_A      -       -           -
LGA    K   188_A      -       -           -
LGA    M   189_A      -       -           -
LGA    L   190_A      -       -           -
LGA    E   191_A      -       -           -
LGA    D   192_A      -       -           -
LGA    Q   193_A      -       -           -
LGA    N   194_A      -       -           -
LGA    L   195_A      -       -           -
LGA    I   196_A      -       -           -
LGA    S   197_A      -       -           -
LGA    A   198_A      -       -           -
LGA    H   199_A      -       -           -
LGA    G   200_A      -       -           -
LGA    K   201_A      -       -           -
LGA    T   202_A      -       -           -
LGA    I   203_A      -       -           -
LGA    V   204_A      -       -           -
LGA    V   205_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  197  146    5.0    124    2.06    16.94     71.587     5.748

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.180663 * X  +  -0.105468 * Y  +  -0.977874 * Z  +  44.029198
  Y_new =  -0.031108 * X  +  -0.993124 * Y  +   0.112860 * Z  + 130.092163
  Z_new =  -0.983053 * X  +   0.050809 * Y  +   0.176139 * Z  +  35.110710 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.280838   -2.860755  [ DEG:    16.0908   -163.9092 ]
  Theta =   1.386433    1.755160  [ DEG:    79.4367    100.5633 ]
  Phi   =  -2.971075    0.170517  [ DEG:  -170.2301      9.7699 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1cgp_A                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1cgp_A.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  197  146   5.0  124   2.06   16.94  71.587
REMARK  ---------------------------------------------------------- 
MOLECULE 1cgp_A
HEADER    TRANSCRIPTION/DNA                       12-AUG-91   1CGP              
TITLE     CATABOLITE GENE ACTIVATOR PROTEIN (CAP)/DNA COMPLEX +                 
TITLE    2 ADENOSINE-3',5'-CYCLIC-MONOPHOSPHATE                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (CATABOLITE GENE ACTIVATOR PROTEIN (CAP)           
COMPND   3 );                                                                   
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: DNA (5'-                                                   
COMPND   7 D(*GP*CP*GP*AP*AP*AP*AP*GP*TP*GP*TP*GP*AP*CP*AP*TP*AP*T)-            
COMPND   8 3');                                                                 
COMPND   9 CHAIN: C, E;                                                         
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MOL_ID: 3;                                                           
COMPND  12 MOLECULE: DNA (5'-                                                   
COMPND  13 D(*GP*TP*CP*AP*CP*AP*CP*TP*TP*TP*TP*CP*G)-3');                       
COMPND  14 CHAIN: D, F;                                                         
COMPND  15 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 SYNTHETIC: YES;                                                      
SOURCE   6 MOL_ID: 3;                                                           
SOURCE   7 SYNTHETIC: YES                                                       
KEYWDS    PROTEIN-DNA COMPLEX, DOUBLE HELIX                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.C.SCHULTZ,G.C SHIELDS,T.A.STEITZ                                    
REVDAT   2   15-OCT-94 1CGP    1                                                
REVDAT   1   31-JAN-94 1CGP    0                                                
JRNL        AUTH   S.C.SCHULTZ,G.C.SHIELDS,T.A.STEITZ                           
JRNL        TITL   CRYSTAL STRUCTURE OF A CAP-DNA COMPLEX: THE DNA IS           
JRNL        TITL 2 BENT BY 90 DEGREES.                                          
JRNL        REF    SCIENCE                       V. 253  1001 1991              
JRNL        REFN   ASTM SCIEAS  US ISSN 0036-8075                               
REMARK   2 RESOLUTION. 3.00 ANGSTROMS.                                          
DBREF  1CGP A    1   205  UNP    P0ACJ8   CRP_ECOLI        2    206             
DBREF  1CGP B    1   205  UNP    P0ACJ8   CRP_ECOLI        2    206             
SEQRES   1 A  205  VAL LEU GLY LYS PRO GLN THR ASP PRO THR LEU GLU TRP          
SEQRES   2 A  205  PHE LEU SER HIS CYS HIS ILE HIS LYS TYR PRO SER LYS          
SEQRES   3 A  205  SER THR LEU ILE HIS GLN GLY GLU LYS ALA GLU THR LEU          
SEQRES   4 A  205  TYR TYR ILE VAL LYS GLY SER VAL ALA VAL LEU ILE LYS          
SEQRES   5 A  205  ASP GLU GLU GLY LYS GLU MET ILE LEU SER TYR LEU ASN          
SEQRES   6 A  205  GLN GLY ASP PHE ILE GLY GLU LEU GLY LEU PHE GLU GLU          
SEQRES   7 A  205  GLY GLN GLU ARG SER ALA TRP VAL ARG ALA LYS THR ALA          
SEQRES   8 A  205  CYS GLU VAL ALA GLU ILE SER TYR LYS LYS PHE ARG GLN          
SEQRES   9 A  205  LEU ILE GLN VAL ASN PRO ASP ILE LEU MET ARG LEU SER          
SEQRES  10 A  205  ALA GLN MET ALA ARG ARG LEU GLN VAL THR SER GLU LYS          
SEQRES  11 A  205  VAL GLY ASN LEU ALA PHE LEU ASP VAL THR GLY ARG ILE          
SEQRES  12 A  205  ALA GLN THR LEU LEU ASN LEU ALA LYS GLN PRO ASP ALA          
SEQRES  13 A  205  MET THR HIS PRO ASP GLY MET GLN ILE LYS ILE THR ARG          
SEQRES  14 A  205  GLN GLU ILE GLY GLN ILE VAL GLY CYS SER ARG GLU THR          
SEQRES  15 A  205  VAL GLY ARG ILE LEU LYS MET LEU GLU ASP GLN ASN LEU          
SEQRES  16 A  205  ILE SER ALA HIS GLY LYS THR ILE VAL VAL                      
SEQRES   1 B  205  VAL LEU GLY LYS PRO GLN THR ASP PRO THR LEU GLU TRP          
SEQRES   2 B  205  PHE LEU SER HIS CYS HIS ILE HIS LYS TYR PRO SER LYS          
SEQRES   3 B  205  SER THR LEU ILE HIS GLN GLY GLU LYS ALA GLU THR LEU          
SEQRES   4 B  205  TYR TYR ILE VAL LYS GLY SER VAL ALA VAL LEU ILE LYS          
SEQRES   5 B  205  ASP GLU GLU GLY LYS GLU MET ILE LEU SER TYR LEU ASN          
SEQRES   6 B  205  GLN GLY ASP PHE ILE GLY GLU LEU GLY LEU PHE GLU GLU          
SEQRES   7 B  205  GLY GLN GLU ARG SER ALA TRP VAL ARG ALA LYS THR ALA          
SEQRES   8 B  205  CYS GLU VAL ALA GLU ILE SER TYR LYS LYS PHE ARG GLN          
SEQRES   9 B  205  LEU ILE GLN VAL ASN PRO ASP ILE LEU MET ARG LEU SER          
SEQRES  10 B  205  ALA GLN MET ALA ARG ARG LEU GLN VAL THR SER GLU LYS          
SEQRES  11 B  205  VAL GLY ASN LEU ALA PHE LEU ASP VAL THR GLY ARG ILE          
SEQRES  12 B  205  ALA GLN THR LEU LEU ASN LEU ALA LYS GLN PRO ASP ALA          
SEQRES  13 B  205  MET THR HIS PRO ASP GLY MET GLN ILE LYS ILE THR ARG          
SEQRES  14 B  205  GLN GLU ILE GLY GLN ILE VAL GLY CYS SER ARG GLU THR          
SEQRES  15 B  205  VAL GLY ARG ILE LEU LYS MET LEU GLU ASP GLN ASN LEU          
SEQRES  16 B  205  ILE SER ALA HIS GLY LYS THR ILE VAL VAL                      
SEQRES   1 C   18   DG  DC  DG  DA  DA  DA  DA  DG  DT  DG  DT  DG  DA          
SEQRES   2 C   18   DC  DA  DT  DA  DT                                          
SEQRES   1 D   13   DG  DT  DC  DA  DC  DA  DC  DT  DT  DT  DT  DC  DG          
SEQRES   1 E   18   DG  DC  DG  DA  DA  DA  DA  DG  DT  DG  DT  DG  DA          
SEQRES   2 E   18   DC  DA  DT  DA  DT                                          
SEQRES   1 F   13   DG  DT  DC  DA  DC  DA  DC  DT  DT  DT  DT  DC  DG          
HET    CMP      1      25                                                       
HET    CMP      2      25                                                       
HETNAM     CMP ADENOSINE-3',5'-CYCLIC-MONOPHOSPHATE                             
HETSYN     CMP CYCLIC AMP; CAMP                                                 
FORMUL   7  CMP    2(C10 H12 N5 O6 P)                                           
CRYST1  138.000  152.600   76.000  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   PRO A   9      -0.217  77.283  11.797  1.00 82.62           N  
ATOM      2  CA  PRO A   9       0.702  77.064  12.912  1.00 82.25           C  
ATOM      3  C   PRO A   9       1.188  78.327  13.656  1.00 81.70           C  
ATOM      4  O   PRO A   9       0.778  79.479  13.414  1.00 80.50           O  
ATOM      5  CB  PRO A   9       1.853  76.275  12.279  1.00 81.60           C  
ATOM      6  CG  PRO A   9       1.245  75.576  11.104  1.00 81.77           C  
ATOM      7  CD  PRO A   9       0.334  76.682  10.584  1.00 82.49           C  
ATOM      8  N   THR A  10       2.178  78.058  14.539  1.00 80.95           N  
ATOM      9  CA  THR A  10       3.003  79.042  15.246  1.00 78.09           C  
ATOM     10  C   THR A  10       3.415  80.120  14.228  1.00 77.84           C  
ATOM     11  O   THR A  10       3.326  81.332  14.397  1.00 77.16           O  
ATOM     12  CB  THR A  10       4.202  78.221  15.831  1.00 76.00           C  
ATOM     13  OG1 THR A  10       3.661  77.240  16.715  1.00 73.16           O  
ATOM     14  CG2 THR A  10       5.203  79.083  16.560  1.00 76.54           C  
ATOM     15  H   THR A  10       2.324  77.131  14.827  1.00  0.00           H  
ATOM     16  HG1 THR A  10       3.900  77.533  17.613  1.00  0.00           H  
ATOM     17  N   LEU A  11       3.807  79.570  13.082  1.00 78.01           N  
ATOM     18  CA  LEU A  11       4.144  80.250  11.848  1.00 78.45           C  
ATOM     19  C   LEU A  11       3.360  81.526  11.541  1.00 77.79           C  
ATOM     20  O   LEU A  11       3.963  82.591  11.385  1.00 78.36           O  
ATOM     21  CB  LEU A  11       3.948  79.203  10.748  1.00 79.81           C  
ATOM     22  CG  LEU A  11       4.861  79.094   9.543  1.00 80.69           C  
ATOM     23  CD1 LEU A  11       4.622  80.238   8.561  1.00 79.74           C  
ATOM     24  CD2 LEU A  11       6.291  79.011  10.076  1.00 80.99           C  
ATOM     25  H   LEU A  11       3.925  78.600  13.089  1.00  0.00           H  
ATOM     26  N   GLU A  12       2.021  81.469  11.528  1.00 75.90           N  
ATOM     27  CA  GLU A  12       1.195  82.599  11.106  1.00 73.47           C  
ATOM     28  C   GLU A  12       1.204  83.719  12.133  1.00 70.22           C  
ATOM     29  O   GLU A  12       1.226  84.917  11.826  1.00 67.77           O  
ATOM     30  CB  GLU A  12      -0.221  82.113  10.876  1.00 76.42           C  
ATOM     31  CG  GLU A  12      -0.332  80.951   9.877  1.00 81.10           C  
ATOM     32  CD  GLU A  12       0.185  81.206   8.449  1.00 84.42           C  
ATOM     33  OE1 GLU A  12      -0.275  82.156   7.791  1.00 85.75           O  
ATOM     34  OE2 GLU A  12       1.029  80.421   7.988  1.00 85.97           O  
ATOM     35  H   GLU A  12       1.574  80.688  11.923  1.00  0.00           H  
ATOM     36  N   TRP A  13       1.230  83.282  13.390  1.00 68.38           N  
ATOM     37  CA  TRP A  13       1.324  84.158  14.543  1.00 66.37           C  
ATOM     38  C   TRP A  13       2.626  84.931  14.430  1.00 66.16           C  
ATOM     39  O   TRP A  13       2.662  86.121  14.727  1.00 65.63           O  
ATOM     40  CB  TRP A  13       1.284  83.312  15.832  1.00 65.28           C  
ATOM     41  CG  TRP A  13       1.997  83.959  17.007  1.00 64.32           C  
ATOM     42  CD1 TRP A  13       1.399  84.937  17.748  1.00 64.89           C  
ATOM     43  CD2 TRP A  13       3.272  83.690  17.419  1.00 64.47           C  
ATOM     44  NE1 TRP A  13       2.300  85.296  18.630  1.00 64.56           N  
ATOM     45  CE2 TRP A  13       3.419  84.581  18.463  1.00 64.51           C  
ATOM     46  CE3 TRP A  13       4.300  82.853  17.061  1.00 65.01           C  
ATOM     47  CZ2 TRP A  13       4.588  84.656  19.178  1.00 64.95           C  
ATOM     48  CZ3 TRP A  13       5.471  82.922  17.777  1.00 65.40           C  
ATOM     49  CH2 TRP A  13       5.614  83.812  18.821  1.00 65.24           C  
ATOM     50  H   TRP A  13       1.195  82.315  13.536  1.00  0.00           H  
ATOM     51  HE1 TRP A  13       2.119  85.883  19.393  1.00  0.00           H  
ATOM     52  N   PHE A  14       3.703  84.227  14.088  1.00 66.97           N  
ATOM     53  CA  PHE A  14       4.988  84.853  13.862  1.00 66.91           C  
ATOM     54  C   PHE A  14       4.833  85.897  12.749  1.00 68.84           C  
ATOM     55  O   PHE A  14       4.833  87.113  13.012  1.00 68.24           O  
ATOM     56  CB  PHE A  14       5.989  83.710  13.527  1.00 63.74           C  
ATOM     57  CG  PHE A  14       7.205  84.110  12.701  1.00 61.04           C  
ATOM     58  CD1 PHE A  14       8.226  84.851  13.267  1.00 58.64           C  
ATOM     59  CD2 PHE A  14       7.239  83.779  11.355  1.00 60.12           C  
ATOM     60  CE1 PHE A  14       9.272  85.255  12.473  1.00 57.10           C  
ATOM     61  CE2 PHE A  14       8.291  84.198  10.574  1.00 58.90           C  
ATOM     62  CZ  PHE A  14       9.307  84.939  11.131  1.00 58.12           C  
ATOM     63  H   PHE A  14       3.613  83.250  14.077  1.00  0.00           H  
ATOM     64  N   LEU A  15       4.549  85.404  11.532  1.00 71.07           N  
ATOM     65  CA  LEU A  15       4.486  86.209  10.315  1.00 74.00           C  
ATOM     66  C   LEU A  15       3.654  87.471  10.335  1.00 75.64           C  
ATOM     67  O   LEU A  15       3.987  88.442   9.644  1.00 76.82           O  
ATOM     68  CB  LEU A  15       4.008  85.351   9.146  1.00 73.58           C  
ATOM     69  CG  LEU A  15       5.063  84.477   8.496  1.00 73.87           C  
ATOM     70  CD1 LEU A  15       4.410  83.593   7.452  1.00 74.11           C  
ATOM     71  CD2 LEU A  15       6.137  85.354   7.861  1.00 73.61           C  
ATOM     72  H   LEU A  15       4.390  84.440  11.458  1.00  0.00           H  
ATOM     73  N   SER A  16       2.577  87.477  11.126  1.00 76.48           N  
ATOM     74  CA  SER A  16       1.784  88.682  11.319  1.00 75.72           C  
ATOM     75  C   SER A  16       2.598  89.876  11.808  1.00 74.45           C  
ATOM     76  O   SER A  16       2.120  91.010  11.728  1.00 75.22           O  
ATOM     77  CB  SER A  16       0.656  88.413  12.315  1.00 76.42           C  
ATOM     78  OG  SER A  16       1.123  87.817  13.508  1.00 76.49           O  
ATOM     79  H   SER A  16       2.228  86.631  11.480  1.00  0.00           H  
ATOM     80  HG  SER A  16       1.301  86.892  13.316  1.00  0.00           H  
ATOM     81  N   HIS A  17       3.803  89.702  12.353  1.00 71.48           N  
ATOM     82  CA  HIS A  17       4.555  90.862  12.751  1.00 69.94           C  
ATOM     83  C   HIS A  17       5.930  90.788  12.166  1.00 69.47           C  
ATOM     84  O   HIS A  17       6.970  90.717  12.822  1.00 70.35           O  
ATOM     85  CB  HIS A  17       4.673  91.013  14.258  1.00 68.45           C  
ATOM     86  CG  HIS A  17       4.155  89.985  15.235  1.00 67.01           C  
ATOM     87  ND1 HIS A  17       4.580  89.803  16.476  1.00 65.83           N  
ATOM     88  CD2 HIS A  17       3.160  89.092  14.996  1.00 66.40           C  
ATOM     89  CE1 HIS A  17       3.869  88.828  16.974  1.00 66.71           C  
ATOM     90  NE2 HIS A  17       3.027  88.401  16.069  1.00 66.75           N  
ATOM     91  H   HIS A  17       4.173  88.808  12.494  1.00  0.00           H  
ATOM     92  HD1 HIS A  17       5.359  90.221  16.898  1.00  0.00           H  
ATOM     93  HE2 HIS A  17       2.540  87.546  16.056  1.00  0.00           H  
ATOM     94  N   CYS A  18       5.805  90.899  10.859  1.00 68.54           N  
ATOM     95  CA  CYS A  18       6.898  90.888   9.926  1.00 68.19           C  
ATOM     96  C   CYS A  18       6.428  91.773   8.800  1.00 68.99           C  
ATOM     97  O   CYS A  18       5.263  91.714   8.407  1.00 69.50           O  
ATOM     98  CB  CYS A  18       7.148  89.554   9.280  1.00 67.08           C  
ATOM     99  SG  CYS A  18       7.890  88.273  10.298  1.00 66.60           S  
ATOM    100  H   CYS A  18       4.903  90.951  10.464  1.00  0.00           H  
ATOM    101  N   HIS A  19       7.339  92.557   8.222  1.00 69.89           N  
ATOM    102  CA  HIS A  19       7.011  93.411   7.080  1.00 69.55           C  
ATOM    103  C   HIS A  19       7.489  92.584   5.910  1.00 66.70           C  
ATOM    104  O   HIS A  19       8.681  92.279   5.785  1.00 65.31           O  
ATOM    105  CB  HIS A  19       7.782  94.720   7.028  1.00 73.16           C  
ATOM    106  CG  HIS A  19       8.201  95.211   8.394  1.00 76.98           C  
ATOM    107  ND1 HIS A  19       8.974  94.559   9.265  1.00 79.38           N  
ATOM    108  CD2 HIS A  19       7.831  96.411   8.940  1.00 77.77           C  
ATOM    109  CE1 HIS A  19       9.078  95.314  10.323  1.00 80.49           C  
ATOM    110  NE2 HIS A  19       8.394  96.425  10.120  1.00 80.72           N  
ATOM    111  H   HIS A  19       8.262  92.413   8.508  1.00  0.00           H  
ATOM    112  HD1 HIS A  19       9.430  93.693   9.168  1.00  0.00           H  
ATOM    113  HE2 HIS A  19       8.416  97.195  10.732  1.00  0.00           H  
ATOM    114  N   ILE A  20       6.497  92.164   5.150  1.00 63.89           N  
ATOM    115  CA  ILE A  20       6.687  91.293   4.004  1.00 62.38           C  
ATOM    116  C   ILE A  20       7.138  92.167   2.820  1.00 61.22           C  
ATOM    117  O   ILE A  20       6.488  93.161   2.485  1.00 60.75           O  
ATOM    118  CB  ILE A  20       5.330  90.560   3.745  1.00 62.00           C  
ATOM    119  CG1 ILE A  20       4.694  90.031   5.056  1.00 61.90           C  
ATOM    120  CG2 ILE A  20       5.586  89.424   2.766  1.00 61.23           C  
ATOM    121  CD1 ILE A  20       5.469  89.050   5.951  1.00 60.60           C  
ATOM    122  H   ILE A  20       5.589  92.462   5.360  1.00  0.00           H  
ATOM    123  N   HIS A  21       8.289  91.908   2.201  1.00 59.48           N  
ATOM    124  CA  HIS A  21       8.800  92.701   1.096  1.00 56.22           C  
ATOM    125  C   HIS A  21       9.052  91.816  -0.106  1.00 52.15           C  
ATOM    126  O   HIS A  21       9.203  90.610   0.039  1.00 49.85           O  
ATOM    127  CB  HIS A  21      10.083  93.394   1.559  1.00 59.23           C  
ATOM    128  CG  HIS A  21       9.878  94.637   2.436  1.00 62.31           C  
ATOM    129  ND1 HIS A  21      10.725  95.200   3.299  1.00 63.45           N  
ATOM    130  CD2 HIS A  21       8.742  95.430   2.439  1.00 64.29           C  
ATOM    131  CE1 HIS A  21      10.154  96.277   3.808  1.00 64.18           C  
ATOM    132  NE2 HIS A  21       8.957  96.405   3.284  1.00 64.77           N  
ATOM    133  H   HIS A  21       8.809  91.128   2.487  1.00  0.00           H  
ATOM    134  HD1 HIS A  21      11.650  94.904   3.464  1.00  0.00           H  
ATOM    135  HE2 HIS A  21       8.315  97.137   3.452  1.00  0.00           H  
ATOM    136  N   LYS A  22       9.116  92.327  -1.319  1.00 50.71           N  
ATOM    137  CA  LYS A  22       9.282  91.478  -2.489  1.00 52.57           C  
ATOM    138  C   LYS A  22      10.589  91.849  -3.174  1.00 51.78           C  
ATOM    139  O   LYS A  22      10.816  93.016  -3.497  1.00 53.47           O  
ATOM    140  CB  LYS A  22       8.092  91.683  -3.433  1.00 54.63           C  
ATOM    141  CG  LYS A  22       6.824  91.251  -2.697  1.00 59.90           C  
ATOM    142  CD  LYS A  22       5.538  92.049  -2.942  1.00 64.67           C  
ATOM    143  CE  LYS A  22       4.675  91.555  -4.117  1.00 69.13           C  
ATOM    144  NZ  LYS A  22       5.292  91.843  -5.406  1.00 73.56           N  
ATOM    145  H   LYS A  22       9.124  93.290  -1.468  1.00  0.00           H  
ATOM    146  HZ1 LYS A  22       6.207  91.349  -5.452  1.00  0.00           H  
ATOM    147  HZ2 LYS A  22       5.459  92.865  -5.494  1.00  0.00           H  
ATOM    148  HZ3 LYS A  22       4.694  91.520  -6.194  1.00  0.00           H  
ATOM    149  N   TYR A  23      11.486  90.903  -3.375  1.00 47.83           N  
ATOM    150  CA  TYR A  23      12.765  91.125  -4.005  1.00 44.35           C  
ATOM    151  C   TYR A  23      12.787  90.638  -5.435  1.00 45.13           C  
ATOM    152  O   TYR A  23      12.370  89.503  -5.652  1.00 47.02           O  
ATOM    153  CB  TYR A  23      13.778  90.402  -3.226  1.00 42.12           C  
ATOM    154  CG  TYR A  23      14.095  91.143  -1.971  1.00 42.02           C  
ATOM    155  CD1 TYR A  23      15.041  92.143  -2.051  1.00 41.81           C  
ATOM    156  CD2 TYR A  23      13.467  90.791  -0.797  1.00 41.14           C  
ATOM    157  CE1 TYR A  23      15.384  92.812  -0.910  1.00 43.01           C  
ATOM    158  CE2 TYR A  23      13.804  91.456   0.347  1.00 41.84           C  
ATOM    159  CZ  TYR A  23      14.759  92.454   0.270  1.00 43.59           C  
ATOM    160  OH  TYR A  23      15.121  93.137   1.416  1.00 46.66           O  
ATOM    161  H   TYR A  23      11.242  90.000  -3.121  1.00  0.00           H  
ATOM    162  HH  TYR A  23      15.978  93.557   1.286  1.00  0.00           H  
ATOM    163  N   PRO A  24      13.231  91.363  -6.452  1.00 44.53           N  
ATOM    164  CA  PRO A  24      13.388  90.852  -7.807  1.00 44.71           C  
ATOM    165  C   PRO A  24      14.579  89.927  -7.976  1.00 45.32           C  
ATOM    166  O   PRO A  24      15.532  89.985  -7.196  1.00 44.68           O  
ATOM    167  CB  PRO A  24      13.502  92.094  -8.624  1.00 44.98           C  
ATOM    168  CG  PRO A  24      14.275  93.009  -7.700  1.00 44.09           C  
ATOM    169  CD  PRO A  24      13.560  92.778  -6.384  1.00 44.62           C  
ATOM    170  N   SER A  25      14.588  89.112  -9.019  1.00 45.83           N  
ATOM    171  CA  SER A  25      15.748  88.293  -9.300  1.00 48.20           C  
ATOM    172  C   SER A  25      16.986  89.164  -9.418  1.00 47.59           C  
ATOM    173  O   SER A  25      16.942  90.238 -10.013  1.00 48.63           O  
ATOM    174  CB  SER A  25      15.529  87.567 -10.589  1.00 50.58           C  
ATOM    175  OG  SER A  25      14.255  86.942 -10.525  1.00 57.14           O  
ATOM    176  H   SER A  25      13.817  89.029  -9.614  1.00  0.00           H  
ATOM    177  HG  SER A  25      14.258  86.266 -11.209  1.00  0.00           H  
ATOM    178  N   LYS A  26      18.035  88.686  -8.753  1.00 47.73           N  
ATOM    179  CA  LYS A  26      19.372  89.239  -8.620  1.00 46.02           C  
ATOM    180  C   LYS A  26      19.486  90.316  -7.580  1.00 45.65           C  
ATOM    181  O   LYS A  26      20.603  90.779  -7.313  1.00 45.56           O  
ATOM    182  CB  LYS A  26      19.906  89.815  -9.914  1.00 45.43           C  
ATOM    183  CG  LYS A  26      20.243  88.632 -10.757  1.00 47.66           C  
ATOM    184  CD  LYS A  26      20.884  89.047 -12.055  1.00 51.73           C  
ATOM    185  CE  LYS A  26      20.976  87.802 -12.932  1.00 53.35           C  
ATOM    186  NZ  LYS A  26      19.646  87.260 -13.155  1.00 55.00           N  
ATOM    187  H   LYS A  26      17.906  87.870  -8.230  1.00  0.00           H  
ATOM    188  HZ1 LYS A  26      19.058  88.015 -13.564  1.00  0.00           H  
ATOM    189  HZ2 LYS A  26      19.224  86.954 -12.254  1.00  0.00           H  
ATOM    190  HZ3 LYS A  26      19.691  86.455 -13.809  1.00  0.00           H  
ATOM    191  N   SER A  27      18.383  90.703  -6.939  1.00 46.33           N  
ATOM    192  CA  SER A  27      18.532  91.705  -5.926  1.00 46.55           C  
ATOM    193  C   SER A  27      19.312  91.078  -4.787  1.00 47.14           C  
ATOM    194  O   SER A  27      19.249  89.879  -4.495  1.00 47.91           O  
ATOM    195  CB  SER A  27      17.185  92.182  -5.443  1.00 46.03           C  
ATOM    196  OG  SER A  27      16.360  91.165  -4.902  1.00 47.08           O  
ATOM    197  H   SER A  27      17.503  90.324  -7.116  1.00  0.00           H  
ATOM    198  HG  SER A  27      16.115  90.578  -5.616  1.00  0.00           H  
ATOM    199  N   THR A  28      20.185  91.916  -4.281  1.00 47.47           N  
ATOM    200  CA  THR A  28      21.011  91.575  -3.160  1.00 45.48           C  
ATOM    201  C   THR A  28      20.228  92.094  -1.948  1.00 45.61           C  
ATOM    202  O   THR A  28      19.757  93.244  -1.826  1.00 44.93           O  
ATOM    203  CB  THR A  28      22.347  92.271  -3.439  1.00 44.50           C  
ATOM    204  OG1 THR A  28      22.848  91.687  -4.654  1.00 43.37           O  
ATOM    205  CG2 THR A  28      23.267  92.229  -2.223  1.00 44.16           C  
ATOM    206  H   THR A  28      20.222  92.824  -4.640  1.00  0.00           H  
ATOM    207  HG1 THR A  28      23.601  92.215  -4.919  1.00  0.00           H  
ATOM    208  N   LEU A  29      20.025  91.136  -1.057  1.00 46.26           N  
ATOM    209  CA  LEU A  29      19.335  91.424   0.173  1.00 46.14           C  
ATOM    210  C   LEU A  29      20.555  91.683   1.058  1.00 49.22           C  
ATOM    211  O   LEU A  29      21.139  92.791   1.048  1.00 54.85           O  
ATOM    212  CB  LEU A  29      18.519  90.209   0.660  1.00 42.49           C  
ATOM    213  CG  LEU A  29      17.965  89.105  -0.242  1.00 40.15           C  
ATOM    214  CD1 LEU A  29      16.845  88.416   0.505  1.00 40.42           C  
ATOM    215  CD2 LEU A  29      17.364  89.632  -1.508  1.00 38.93           C  
ATOM    216  H   LEU A  29      20.446  90.260  -1.183  1.00  0.00           H  
ATOM    217  N   ILE A  30      21.097  90.628   1.676  1.00 46.56           N  
ATOM    218  CA  ILE A  30      22.175  90.778   2.624  1.00 42.70           C  
ATOM    219  C   ILE A  30      23.458  91.019   1.887  1.00 43.38           C  
ATOM    220  O   ILE A  30      23.652  90.436   0.830  1.00 40.61           O  
ATOM    221  CB  ILE A  30      22.238  89.523   3.432  1.00 40.04           C  
ATOM    222  CG1 ILE A  30      21.015  89.423   4.264  1.00 39.25           C  
ATOM    223  CG2 ILE A  30      23.417  89.548   4.335  1.00 38.61           C  
ATOM    224  CD1 ILE A  30      20.833  88.049   4.876  1.00 40.07           C  
ATOM    225  H   ILE A  30      20.906  89.734   1.332  1.00  0.00           H  
ATOM    226  N   HIS A  31      24.292  91.904   2.392  1.00 47.51           N  
ATOM    227  CA  HIS A  31      25.634  92.067   1.857  1.00 55.06           C  
ATOM    228  C   HIS A  31      26.424  91.522   3.019  1.00 55.31           C  
ATOM    229  O   HIS A  31      26.115  91.913   4.152  1.00 56.51           O  
ATOM    230  CB  HIS A  31      26.196  93.469   1.732  1.00 60.87           C  
ATOM    231  CG  HIS A  31      25.387  94.447   0.917  1.00 68.17           C  
ATOM    232  ND1 HIS A  31      24.057  94.611   0.808  1.00 71.79           N  
ATOM    233  CD2 HIS A  31      26.001  95.399   0.128  1.00 70.44           C  
ATOM    234  CE1 HIS A  31      23.854  95.629  -0.003  1.00 73.37           C  
ATOM    235  NE2 HIS A  31      25.023  96.094  -0.409  1.00 73.50           N  
ATOM    236  H   HIS A  31      24.106  92.286   3.274  1.00  0.00           H  
ATOM    237  HD1 HIS A  31      23.323  94.078   1.199  1.00  0.00           H  
ATOM    238  HE2 HIS A  31      25.134  96.852  -1.027  1.00  0.00           H  
ATOM    239  N   GLN A  32      27.442  90.687   2.843  1.00 55.14           N  
ATOM    240  CA  GLN A  32      28.192  90.231   3.992  1.00 55.80           C  
ATOM    241  C   GLN A  32      28.901  91.443   4.540  1.00 54.64           C  
ATOM    242  O   GLN A  32      29.179  92.365   3.776  1.00 56.22           O  
ATOM    243  CB  GLN A  32      29.153  89.225   3.545  1.00 56.86           C  
ATOM    244  CG  GLN A  32      29.976  88.652   4.628  1.00 60.17           C  
ATOM    245  CD  GLN A  32      31.405  88.858   4.262  1.00 62.99           C  
ATOM    246  OE1 GLN A  32      31.998  89.873   4.615  1.00 65.65           O  
ATOM    247  NE2 GLN A  32      31.960  87.886   3.546  1.00 64.17           N  
ATOM    248  H   GLN A  32      27.760  90.478   1.948  1.00  0.00           H  
ATOM    249 HE21 GLN A  32      31.456  87.057   3.411  1.00  0.00           H  
ATOM    250 HE22 GLN A  32      32.857  88.060   3.199  1.00  0.00           H  
ATOM    251  N   GLY A  33      29.136  91.488   5.831  1.00 54.38           N  
ATOM    252  CA  GLY A  33      29.741  92.650   6.417  1.00 54.57           C  
ATOM    253  C   GLY A  33      28.674  93.598   6.941  1.00 55.94           C  
ATOM    254  O   GLY A  33      29.017  94.355   7.848  1.00 56.98           O  
ATOM    255  H   GLY A  33      28.924  90.711   6.377  1.00  0.00           H  
ATOM    256  N   GLU A  34      27.405  93.647   6.475  1.00 56.93           N  
ATOM    257  CA  GLU A  34      26.385  94.542   7.040  1.00 58.76           C  
ATOM    258  C   GLU A  34      26.218  94.192   8.517  1.00 59.45           C  
ATOM    259  O   GLU A  34      26.517  93.069   8.922  1.00 59.15           O  
ATOM    260  CB  GLU A  34      24.957  94.368   6.507  1.00 61.21           C  
ATOM    261  CG  GLU A  34      24.413  94.615   5.083  1.00 64.42           C  
ATOM    262  CD  GLU A  34      23.000  94.020   4.791  1.00 65.73           C  
ATOM    263  OE1 GLU A  34      22.287  93.600   5.729  1.00 66.54           O  
ATOM    264  OE2 GLU A  34      22.613  93.971   3.612  1.00 63.82           O  
ATOM    265  H   GLU A  34      27.139  93.044   5.751  1.00  0.00           H  
ATOM    266  N   LYS A  35      25.723  95.087   9.361  1.00 59.79           N  
ATOM    267  CA  LYS A  35      25.410  94.708  10.729  1.00 60.41           C  
ATOM    268  C   LYS A  35      24.080  93.966  10.704  1.00 59.70           C  
ATOM    269  O   LYS A  35      23.106  94.298  10.004  1.00 58.35           O  
ATOM    270  CB  LYS A  35      25.296  95.933  11.673  1.00 62.10           C  
ATOM    271  CG  LYS A  35      24.633  97.203  11.139  1.00 63.14           C  
ATOM    272  CD  LYS A  35      25.676  98.160  10.553  1.00 64.10           C  
ATOM    273  CE  LYS A  35      25.086  98.990   9.415  1.00 63.91           C  
ATOM    274  NZ  LYS A  35      25.014  98.212   8.192  1.00 63.80           N  
ATOM    275  H   LYS A  35      25.500  95.976   9.030  1.00  0.00           H  
ATOM    276  HZ1 LYS A  35      24.498  97.325   8.369  1.00  0.00           H  
ATOM    277  HZ2 LYS A  35      25.981  97.985   7.886  1.00  0.00           H  
ATOM    278  HZ3 LYS A  35      24.529  98.760   7.453  1.00  0.00           H  
ATOM    279  N   ALA A  36      24.093  92.869  11.428  1.00 59.43           N  
ATOM    280  CA  ALA A  36      22.911  92.065  11.554  1.00 60.84           C  
ATOM    281  C   ALA A  36      21.941  92.739  12.516  1.00 62.59           C  
ATOM    282  O   ALA A  36      22.307  93.074  13.650  1.00 62.61           O  
ATOM    283  CB  ALA A  36      23.298  90.713  12.081  1.00 60.78           C  
ATOM    284  H   ALA A  36      24.899  92.594  11.908  1.00  0.00           H  
ATOM    285  N   GLU A  37      20.705  92.951  12.065  1.00 64.42           N  
ATOM    286  CA  GLU A  37      19.679  93.512  12.936  1.00 65.01           C  
ATOM    287  C   GLU A  37      18.290  92.991  12.601  1.00 61.90           C  
ATOM    288  O   GLU A  37      17.339  93.174  13.370  1.00 60.51           O  
ATOM    289  CB  GLU A  37      19.674  95.036  12.820  1.00 70.08           C  
ATOM    290  CG  GLU A  37      19.513  95.823  14.137  1.00 74.39           C  
ATOM    291  CD  GLU A  37      20.803  96.500  14.627  1.00 75.96           C  
ATOM    292  OE1 GLU A  37      21.063  97.637  14.201  1.00 74.87           O  
ATOM    293  OE2 GLU A  37      21.530  95.894  15.435  1.00 77.60           O  
ATOM    294  H   GLU A  37      20.520  92.811  11.116  1.00  0.00           H  
ATOM    295  N   THR A  38      18.170  92.226  11.521  1.00 59.97           N  
ATOM    296  CA  THR A  38      16.869  91.830  11.024  1.00 59.31           C  
ATOM    297  C   THR A  38      16.964  90.375  10.595  1.00 56.47           C  
ATOM    298  O   THR A  38      17.926  90.009   9.918  1.00 57.25           O  
ATOM    299  CB  THR A  38      16.526  92.757   9.834  1.00 61.19           C  
ATOM    300  OG1 THR A  38      16.807  94.087  10.282  1.00 63.06           O  
ATOM    301  CG2 THR A  38      15.084  92.630   9.346  1.00 61.34           C  
ATOM    302  H   THR A  38      18.937  91.849  11.054  1.00  0.00           H  
ATOM    303  HG1 THR A  38      17.022  94.628   9.515  1.00  0.00           H  
ATOM    304  N   LEU A  39      15.997  89.581  11.033  1.00 51.59           N  
ATOM    305  CA  LEU A  39      15.877  88.173  10.668  1.00 46.75           C  
ATOM    306  C   LEU A  39      14.948  88.198   9.449  1.00 44.84           C  
ATOM    307  O   LEU A  39      14.120  89.121   9.373  1.00 44.99           O  
ATOM    308  CB  LEU A  39      15.209  87.371  11.796  1.00 44.25           C  
ATOM    309  CG  LEU A  39      15.184  85.858  11.680  1.00 42.06           C  
ATOM    310  CD1 LEU A  39      16.471  85.338  12.261  1.00 41.77           C  
ATOM    311  CD2 LEU A  39      14.056  85.242  12.462  1.00 40.22           C  
ATOM    312  H   LEU A  39      15.238  90.027  11.465  1.00  0.00           H  
ATOM    313  N   TYR A  40      15.021  87.273   8.492  1.00 41.92           N  
ATOM    314  CA  TYR A  40      14.116  87.242   7.360  1.00 40.23           C  
ATOM    315  C   TYR A  40      13.471  85.894   7.291  1.00 38.53           C  
ATOM    316  O   TYR A  40      14.035  84.979   7.875  1.00 38.88           O  
ATOM    317  CB  TYR A  40      14.823  87.431   6.050  1.00 40.91           C  
ATOM    318  CG  TYR A  40      15.594  88.732   5.968  1.00 43.09           C  
ATOM    319  CD1 TYR A  40      16.865  88.749   6.515  1.00 43.72           C  
ATOM    320  CD2 TYR A  40      15.042  89.861   5.380  1.00 42.64           C  
ATOM    321  CE1 TYR A  40      17.610  89.899   6.494  1.00 42.92           C  
ATOM    322  CE2 TYR A  40      15.789  91.019   5.351  1.00 43.06           C  
ATOM    323  CZ  TYR A  40      17.058  91.012   5.910  1.00 43.73           C  
ATOM    324  OH  TYR A  40      17.833  92.146   5.884  1.00 45.17           O  
ATOM    325  H   TYR A  40      15.721  86.591   8.504  1.00  0.00           H  
ATOM    326  HH  TYR A  40      18.713  91.939   6.216  1.00  0.00           H  
ATOM    327  N   TYR A  41      12.345  85.690   6.621  1.00 38.29           N  
ATOM    328  CA  TYR A  41      11.804  84.350   6.429  1.00 40.77           C  
ATOM    329  C   TYR A  41      11.326  84.279   4.986  1.00 40.70           C  
ATOM    330  O   TYR A  41      10.539  85.119   4.551  1.00 41.40           O  
ATOM    331  CB  TYR A  41      10.628  84.058   7.393  1.00 42.74           C  
ATOM    332  CG  TYR A  41       9.915  82.718   7.147  1.00 44.63           C  
ATOM    333  CD1 TYR A  41       8.952  82.606   6.151  1.00 44.59           C  
ATOM    334  CD2 TYR A  41      10.242  81.595   7.892  1.00 45.89           C  
ATOM    335  CE1 TYR A  41       8.338  81.399   5.892  1.00 45.74           C  
ATOM    336  CE2 TYR A  41       9.624  80.375   7.639  1.00 45.82           C  
ATOM    337  CZ  TYR A  41       8.680  80.294   6.634  1.00 46.22           C  
ATOM    338  OH  TYR A  41       8.071  79.096   6.340  1.00 48.29           O  
ATOM    339  H   TYR A  41      11.888  86.471   6.243  1.00  0.00           H  
ATOM    340  HH  TYR A  41       8.488  78.402   6.854  1.00  0.00           H  
ATOM    341  N   ILE A  42      11.764  83.300   4.204  1.00 40.44           N  
ATOM    342  CA  ILE A  42      11.422  83.245   2.791  1.00 40.78           C  
ATOM    343  C   ILE A  42      10.014  82.747   2.642  1.00 42.28           C  
ATOM    344  O   ILE A  42       9.780  81.565   2.872  1.00 44.34           O  
ATOM    345  CB  ILE A  42      12.396  82.307   2.007  1.00 40.34           C  
ATOM    346  CG1 ILE A  42      13.846  82.766   2.213  1.00 39.64           C  
ATOM    347  CG2 ILE A  42      12.030  82.321   0.519  1.00 39.08           C  
ATOM    348  CD1 ILE A  42      14.951  82.017   1.454  1.00 39.45           C  
ATOM    349  H   ILE A  42      12.356  82.607   4.573  1.00  0.00           H  
ATOM    350  N   VAL A  43       9.097  83.612   2.248  1.00 44.52           N  
ATOM    351  CA  VAL A  43       7.718  83.223   2.046  1.00 46.08           C  
ATOM    352  C   VAL A  43       7.596  82.663   0.648  1.00 46.27           C  
ATOM    353  O   VAL A  43       6.896  81.670   0.477  1.00 47.33           O  
ATOM    354  CB  VAL A  43       6.828  84.434   2.243  1.00 47.40           C  
ATOM    355  CG1 VAL A  43       5.418  84.156   1.763  1.00 48.50           C  
ATOM    356  CG2 VAL A  43       6.801  84.770   3.738  1.00 47.91           C  
ATOM    357  H   VAL A  43       9.369  84.503   1.959  1.00  0.00           H  
ATOM    358  N   LYS A  44       8.220  83.226  -0.372  1.00 47.27           N  
ATOM    359  CA  LYS A  44       8.192  82.568  -1.666  1.00 48.13           C  
ATOM    360  C   LYS A  44       9.538  82.794  -2.301  1.00 44.92           C  
ATOM    361  O   LYS A  44      10.202  83.763  -1.923  1.00 43.12           O  
ATOM    362  CB  LYS A  44       7.075  83.160  -2.519  1.00 53.58           C  
ATOM    363  CG  LYS A  44       6.443  82.159  -3.512  1.00 59.59           C  
ATOM    364  CD  LYS A  44       7.139  81.970  -4.882  1.00 63.46           C  
ATOM    365  CE  LYS A  44       6.665  82.928  -6.009  1.00 65.74           C  
ATOM    366  NZ  LYS A  44       6.985  84.339  -5.792  1.00 67.37           N  
ATOM    367  H   LYS A  44       8.749  84.034  -0.220  1.00  0.00           H  
ATOM    368  HZ1 LYS A  44       8.015  84.440  -5.681  1.00  0.00           H  
ATOM    369  HZ2 LYS A  44       6.508  84.698  -4.941  1.00  0.00           H  
ATOM    370  HZ3 LYS A  44       6.673  84.895  -6.614  1.00  0.00           H  
ATOM    371  N   GLY A  45       9.967  81.927  -3.204  1.00 42.61           N  
ATOM    372  CA  GLY A  45      11.209  82.178  -3.904  1.00 43.87           C  
ATOM    373  C   GLY A  45      12.452  81.480  -3.351  1.00 44.76           C  
ATOM    374  O   GLY A  45      12.427  80.814  -2.305  1.00 45.82           O  
ATOM    375  H   GLY A  45       9.471  81.092  -3.339  1.00  0.00           H  
ATOM    376  N   SER A  46      13.524  81.616  -4.149  1.00 43.21           N  
ATOM    377  CA  SER A  46      14.806  80.995  -3.928  1.00 43.28           C  
ATOM    378  C   SER A  46      15.954  81.973  -3.950  1.00 41.12           C  
ATOM    379  O   SER A  46      16.089  82.810  -4.837  1.00 41.33           O  
ATOM    380  CB  SER A  46      15.062  79.959  -4.995  1.00 47.50           C  
ATOM    381  OG  SER A  46      14.059  78.939  -5.017  1.00 54.46           O  
ATOM    382  H   SER A  46      13.467  82.155  -4.965  1.00  0.00           H  
ATOM    383  HG  SER A  46      13.291  79.264  -5.503  1.00  0.00           H  
ATOM    384  N   VAL A  47      16.875  81.725  -3.046  1.00 39.20           N  
ATOM    385  CA  VAL A  47      18.015  82.551  -2.742  1.00 35.07           C  
ATOM    386  C   VAL A  47      19.337  81.750  -2.753  1.00 35.40           C  
ATOM    387  O   VAL A  47      19.344  80.542  -2.503  1.00 34.54           O  
ATOM    388  CB  VAL A  47      17.508  83.120  -1.419  1.00 34.08           C  
ATOM    389  CG1 VAL A  47      18.442  82.900  -0.248  1.00 33.67           C  
ATOM    390  CG2 VAL A  47      17.212  84.556  -1.698  1.00 34.04           C  
ATOM    391  H   VAL A  47      16.803  80.901  -2.515  1.00  0.00           H  
ATOM    392  N   ALA A  48      20.474  82.367  -3.057  1.00 35.39           N  
ATOM    393  CA  ALA A  48      21.766  81.711  -2.990  1.00 35.07           C  
ATOM    394  C   ALA A  48      22.616  82.462  -2.000  1.00 36.21           C  
ATOM    395  O   ALA A  48      22.729  83.693  -2.036  1.00 35.53           O  
ATOM    396  CB  ALA A  48      22.515  81.762  -4.277  1.00 35.24           C  
ATOM    397  H   ALA A  48      20.436  83.313  -3.314  1.00  0.00           H  
ATOM    398  N   VAL A  49      23.141  81.680  -1.080  1.00 38.35           N  
ATOM    399  CA  VAL A  49      24.013  82.146  -0.019  1.00 38.66           C  
ATOM    400  C   VAL A  49      25.430  82.002  -0.569  1.00 38.06           C  
ATOM    401  O   VAL A  49      25.847  80.885  -0.893  1.00 38.79           O  
ATOM    402  CB  VAL A  49      23.786  81.256   1.240  1.00 38.24           C  
ATOM    403  CG1 VAL A  49      24.735  81.651   2.347  1.00 37.09           C  
ATOM    404  CG2 VAL A  49      22.365  81.426   1.742  1.00 38.92           C  
ATOM    405  H   VAL A  49      22.974  80.718  -1.129  1.00  0.00           H  
ATOM    406  N   LEU A  50      26.200  83.069  -0.705  1.00 36.63           N  
ATOM    407  CA  LEU A  50      27.549  82.961  -1.191  1.00 37.21           C  
ATOM    408  C   LEU A  50      28.584  83.857  -0.533  1.00 38.12           C  
ATOM    409  O   LEU A  50      28.265  84.834   0.135  1.00 38.68           O  
ATOM    410  CB  LEU A  50      27.521  83.178  -2.687  1.00 37.57           C  
ATOM    411  CG  LEU A  50      26.636  84.152  -3.400  1.00 38.59           C  
ATOM    412  CD1 LEU A  50      26.912  85.572  -3.020  1.00 39.50           C  
ATOM    413  CD2 LEU A  50      26.939  83.988  -4.874  1.00 40.22           C  
ATOM    414  H   LEU A  50      25.849  83.927  -0.399  1.00  0.00           H  
ATOM    415  N   ILE A  51      29.862  83.496  -0.614  1.00 40.53           N  
ATOM    416  CA  ILE A  51      30.972  84.231  -0.020  1.00 40.73           C  
ATOM    417  C   ILE A  51      31.974  84.426  -1.129  1.00 43.61           C  
ATOM    418  O   ILE A  51      32.099  83.580  -2.012  1.00 40.47           O  
ATOM    419  CB  ILE A  51      31.592  83.428   1.116  1.00 38.95           C  
ATOM    420  CG1 ILE A  51      32.058  82.075   0.635  1.00 38.25           C  
ATOM    421  CG2 ILE A  51      30.553  83.311   2.210  1.00 38.67           C  
ATOM    422  CD1 ILE A  51      32.344  81.057   1.738  1.00 39.80           C  
ATOM    423  H   ILE A  51      30.058  82.683  -1.135  1.00  0.00           H  
ATOM    424  N   LYS A  52      32.664  85.555  -1.124  1.00 51.10           N  
ATOM    425  CA  LYS A  52      33.605  85.888  -2.180  1.00 57.63           C  
ATOM    426  C   LYS A  52      34.950  86.224  -1.538  1.00 61.79           C  
ATOM    427  O   LYS A  52      35.004  86.669  -0.377  1.00 63.54           O  
ATOM    428  CB  LYS A  52      33.187  87.113  -2.961  1.00 59.00           C  
ATOM    429  CG  LYS A  52      31.722  87.429  -3.140  1.00 62.48           C  
ATOM    430  CD  LYS A  52      31.598  88.666  -4.007  1.00 66.83           C  
ATOM    431  CE  LYS A  52      31.990  89.991  -3.320  1.00 71.21           C  
ATOM    432  NZ  LYS A  52      33.400  90.145  -2.950  1.00 73.78           N  
ATOM    433  H   LYS A  52      32.666  86.138  -0.340  1.00  0.00           H  
ATOM    434  HZ1 LYS A  52      34.011  90.010  -3.782  1.00  0.00           H  
ATOM    435  HZ2 LYS A  52      33.649  89.446  -2.223  1.00  0.00           H  
ATOM    436  HZ3 LYS A  52      33.553  91.100  -2.567  1.00  0.00           H  
ATOM    437  N   ASP A  53      36.045  85.984  -2.264  1.00 65.42           N  
ATOM    438  CA  ASP A  53      37.377  86.337  -1.816  1.00 69.34           C  
ATOM    439  C   ASP A  53      37.648  87.775  -2.245  1.00 70.06           C  
ATOM    440  O   ASP A  53      37.141  88.223  -3.269  1.00 69.19           O  
ATOM    441  CB  ASP A  53      38.441  85.429  -2.445  1.00 70.96           C  
ATOM    442  CG  ASP A  53      39.819  85.589  -1.790  1.00 73.24           C  
ATOM    443  OD1 ASP A  53      40.027  85.093  -0.675  1.00 72.69           O  
ATOM    444  OD2 ASP A  53      40.677  86.238  -2.399  1.00 74.54           O  
ATOM    445  H   ASP A  53      35.913  85.562  -3.125  1.00  0.00           H  
ATOM    446  N   GLU A  54      38.519  88.490  -1.513  1.00 71.75           N  
ATOM    447  CA  GLU A  54      38.898  89.878  -1.789  1.00 71.79           C  
ATOM    448  C   GLU A  54      39.427  90.024  -3.200  1.00 70.43           C  
ATOM    449  O   GLU A  54      39.339  91.101  -3.769  1.00 70.55           O  
ATOM    450  CB  GLU A  54      40.001  90.406  -0.866  1.00 73.34           C  
ATOM    451  CG  GLU A  54      40.024  89.862   0.573  1.00 77.69           C  
ATOM    452  CD  GLU A  54      40.742  88.513   0.725  1.00 80.92           C  
ATOM    453  OE1 GLU A  54      41.230  87.966  -0.274  1.00 80.66           O  
ATOM    454  OE2 GLU A  54      40.818  88.018   1.855  1.00 82.84           O  
ATOM    455  H   GLU A  54      38.834  88.065  -0.695  1.00  0.00           H  
ATOM    456  N   GLU A  55      39.998  88.996  -3.831  1.00 69.49           N  
ATOM    457  CA  GLU A  55      40.394  89.139  -5.224  1.00 68.69           C  
ATOM    458  C   GLU A  55      39.299  88.644  -6.196  1.00 66.15           C  
ATOM    459  O   GLU A  55      39.581  88.196  -7.314  1.00 65.58           O  
ATOM    460  CB  GLU A  55      41.715  88.375  -5.444  1.00 71.50           C  
ATOM    461  CG  GLU A  55      42.854  88.632  -4.447  1.00 75.01           C  
ATOM    462  CD  GLU A  55      43.229  90.096  -4.169  1.00 77.98           C  
ATOM    463  OE1 GLU A  55      42.652  90.708  -3.262  1.00 80.63           O  
ATOM    464  OE2 GLU A  55      44.135  90.609  -4.824  1.00 77.99           O  
ATOM    465  H   GLU A  55      40.142  88.157  -3.368  1.00  0.00           H  
ATOM    466  N   GLY A  56      38.031  88.644  -5.763  1.00 62.72           N  
ATOM    467  CA  GLY A  56      36.884  88.366  -6.606  1.00 57.99           C  
ATOM    468  C   GLY A  56      36.248  86.985  -6.675  1.00 55.02           C  
ATOM    469  O   GLY A  56      35.041  86.928  -6.939  1.00 52.93           O  
ATOM    470  H   GLY A  56      37.834  88.890  -4.843  1.00  0.00           H  
ATOM    471  N   LYS A  57      36.939  85.858  -6.484  1.00 53.16           N  
ATOM    472  CA  LYS A  57      36.299  84.563  -6.710  1.00 52.05           C  
ATOM    473  C   LYS A  57      35.200  84.281  -5.689  1.00 48.32           C  
ATOM    474  O   LYS A  57      35.356  84.604  -4.517  1.00 46.58           O  
ATOM    475  CB  LYS A  57      37.435  83.487  -6.726  1.00 56.57           C  
ATOM    476  CG  LYS A  57      37.114  81.960  -6.850  1.00 62.96           C  
ATOM    477  CD  LYS A  57      36.047  81.524  -7.920  1.00 66.33           C  
ATOM    478  CE  LYS A  57      35.643  80.027  -8.008  1.00 65.08           C  
ATOM    479  NZ  LYS A  57      34.627  79.890  -9.044  1.00 64.75           N  
ATOM    480  H   LYS A  57      37.874  85.913  -6.208  1.00  0.00           H  
ATOM    481  HZ1 LYS A  57      34.986  80.300  -9.932  1.00  0.00           H  
ATOM    482  HZ2 LYS A  57      33.764  80.398  -8.759  1.00  0.00           H  
ATOM    483  HZ3 LYS A  57      34.404  78.888  -9.209  1.00  0.00           H  
ATOM    484  N   GLU A  58      34.064  83.742  -6.085  1.00 45.20           N  
ATOM    485  CA  GLU A  58      33.008  83.494  -5.142  1.00 44.30           C  
ATOM    486  C   GLU A  58      32.499  82.084  -5.237  1.00 42.10           C  
ATOM    487  O   GLU A  58      32.463  81.492  -6.316  1.00 42.50           O  
ATOM    488  CB  GLU A  58      31.879  84.489  -5.367  1.00 45.28           C  
ATOM    489  CG  GLU A  58      31.330  84.769  -6.756  1.00 47.29           C  
ATOM    490  CD  GLU A  58      30.333  85.930  -6.775  1.00 48.90           C  
ATOM    491  OE1 GLU A  58      30.758  87.085  -6.856  1.00 49.19           O  
ATOM    492  OE2 GLU A  58      29.128  85.690  -6.712  1.00 49.06           O  
ATOM    493  H   GLU A  58      33.938  83.464  -7.012  1.00  0.00           H  
ATOM    494  N   MET A  59      32.120  81.583  -4.079  1.00 40.67           N  
ATOM    495  CA  MET A  59      31.628  80.234  -3.879  1.00 41.48           C  
ATOM    496  C   MET A  59      30.266  80.227  -3.224  1.00 40.76           C  
ATOM    497  O   MET A  59      30.054  80.953  -2.247  1.00 42.43           O  
ATOM    498  CB  MET A  59      32.596  79.450  -2.998  1.00 42.67           C  
ATOM    499  CG  MET A  59      32.019  78.243  -2.272  1.00 42.59           C  
ATOM    500  SD  MET A  59      33.309  77.010  -2.143  1.00 46.09           S  
ATOM    501  CE  MET A  59      32.908  75.970  -3.517  1.00 46.70           C  
ATOM    502  H   MET A  59      32.129  82.194  -3.317  1.00  0.00           H  
ATOM    503  N   ILE A  60      29.374  79.371  -3.726  1.00 38.50           N  
ATOM    504  CA  ILE A  60      28.026  79.236  -3.198  1.00 35.20           C  
ATOM    505  C   ILE A  60      28.129  78.273  -2.035  1.00 35.08           C  
ATOM    506  O   ILE A  60      28.717  77.195  -2.101  1.00 34.77           O  
ATOM    507  CB  ILE A  60      27.093  78.697  -4.299  1.00 34.83           C  
ATOM    508  CG1 ILE A  60      26.874  79.798  -5.304  1.00 34.52           C  
ATOM    509  CG2 ILE A  60      25.762  78.234  -3.742  1.00 33.52           C  
ATOM    510  CD1 ILE A  60      26.198  79.215  -6.526  1.00 33.83           C  
ATOM    511  H   ILE A  60      29.703  78.709  -4.379  1.00  0.00           H  
ATOM    512  N   LEU A  61      27.618  78.753  -0.923  1.00 33.90           N  
ATOM    513  CA  LEU A  61      27.562  77.950   0.265  1.00 31.69           C  
ATOM    514  C   LEU A  61      26.263  77.158   0.205  1.00 31.82           C  
ATOM    515  O   LEU A  61      26.279  76.024   0.680  1.00 33.24           O  
ATOM    516  CB  LEU A  61      27.615  78.845   1.512  1.00 29.04           C  
ATOM    517  CG  LEU A  61      28.971  79.338   1.987  1.00 25.71           C  
ATOM    518  CD1 LEU A  61      28.862  80.272   3.151  1.00 23.29           C  
ATOM    519  CD2 LEU A  61      29.740  78.155   2.483  1.00 26.01           C  
ATOM    520  H   LEU A  61      27.155  79.604  -0.934  1.00  0.00           H  
ATOM    521  N   SER A  62      25.141  77.676  -0.332  1.00 32.24           N  
ATOM    522  CA  SER A  62      23.889  76.914  -0.467  1.00 32.71           C  
ATOM    523  C   SER A  62      22.784  77.678  -1.127  1.00 32.05           C  
ATOM    524  O   SER A  62      22.815  78.901  -1.229  1.00 30.26           O  
ATOM    525  CB  SER A  62      23.283  76.461   0.855  1.00 33.59           C  
ATOM    526  OG  SER A  62      23.182  77.595   1.697  1.00 36.78           O  
ATOM    527  H   SER A  62      25.156  78.618  -0.602  1.00  0.00           H  
ATOM    528  HG  SER A  62      23.705  77.443   2.485  1.00  0.00           H  
ATOM    529  N   TYR A  63      21.821  76.936  -1.615  1.00 33.27           N  
ATOM    530  CA  TYR A  63      20.645  77.590  -2.111  1.00 36.62           C  
ATOM    531  C   TYR A  63      19.721  77.372  -0.938  1.00 39.78           C  
ATOM    532  O   TYR A  63      19.744  76.318  -0.296  1.00 42.23           O  
ATOM    533  CB  TYR A  63      20.101  76.903  -3.331  1.00 35.51           C  
ATOM    534  CG  TYR A  63      21.027  76.950  -4.523  1.00 35.07           C  
ATOM    535  CD1 TYR A  63      21.470  78.168  -4.982  1.00 37.17           C  
ATOM    536  CD2 TYR A  63      21.408  75.790  -5.153  1.00 34.84           C  
ATOM    537  CE1 TYR A  63      22.305  78.248  -6.076  1.00 37.13           C  
ATOM    538  CE2 TYR A  63      22.246  75.856  -6.248  1.00 35.96           C  
ATOM    539  CZ  TYR A  63      22.687  77.090  -6.689  1.00 36.42           C  
ATOM    540  OH  TYR A  63      23.570  77.195  -7.728  1.00 35.71           O  
ATOM    541  H   TYR A  63      21.779  75.973  -1.450  1.00  0.00           H  
ATOM    542  HH  TYR A  63      23.903  76.318  -7.933  1.00  0.00           H  
ATOM    543  N   LEU A  64      18.973  78.392  -0.592  1.00 42.98           N  
ATOM    544  CA  LEU A  64      17.991  78.338   0.478  1.00 45.47           C  
ATOM    545  C   LEU A  64      16.691  78.499  -0.303  1.00 49.44           C  
ATOM    546  O   LEU A  64      16.685  79.284  -1.266  1.00 52.24           O  
ATOM    547  CB  LEU A  64      18.163  79.510   1.414  1.00 44.25           C  
ATOM    548  CG  LEU A  64      18.386  79.283   2.884  1.00 44.02           C  
ATOM    549  CD1 LEU A  64      19.817  78.940   3.180  1.00 43.59           C  
ATOM    550  CD2 LEU A  64      18.128  80.578   3.604  1.00 44.34           C  
ATOM    551  H   LEU A  64      19.008  79.178  -1.178  1.00  0.00           H  
ATOM    552  N   ASN A  65      15.568  77.840  -0.005  1.00 51.64           N  
ATOM    553  CA  ASN A  65      14.358  78.023  -0.810  1.00 52.81           C  
ATOM    554  C   ASN A  65      13.255  78.448   0.147  1.00 52.29           C  
ATOM    555  O   ASN A  65      13.537  78.685   1.333  1.00 50.83           O  
ATOM    556  CB  ASN A  65      13.979  76.714  -1.534  1.00 55.42           C  
ATOM    557  CG  ASN A  65      15.101  76.065  -2.362  1.00 57.62           C  
ATOM    558  OD1 ASN A  65      15.776  75.159  -1.856  1.00 59.11           O  
ATOM    559  ND2 ASN A  65      15.433  76.435  -3.600  1.00 56.37           N  
ATOM    560  H   ASN A  65      15.498  77.348   0.832  1.00  0.00           H  
ATOM    561 HD21 ASN A  65      14.992  77.201  -4.028  1.00  0.00           H  
ATOM    562 HD22 ASN A  65      16.098  75.856  -4.042  1.00  0.00           H  
ATOM    563  N   GLN A  66      12.013  78.637  -0.293  1.00 52.30           N  
ATOM    564  CA  GLN A  66      10.984  79.050   0.635  1.00 53.16           C  
ATOM    565  C   GLN A  66      10.765  78.153   1.821  1.00 49.80           C  
ATOM    566  O   GLN A  66      10.942  76.942   1.766  1.00 47.88           O  
ATOM    567  CB  GLN A  66       9.660  79.227  -0.067  1.00 58.60           C  
ATOM    568  CG  GLN A  66       9.062  78.139  -0.944  1.00 65.11           C  
ATOM    569  CD  GLN A  66       7.820  78.668  -1.681  1.00 69.06           C  
ATOM    570  OE1 GLN A  66       7.914  79.190  -2.813  1.00 70.25           O  
ATOM    571  NE2 GLN A  66       6.650  78.590  -1.028  1.00 68.95           N  
ATOM    572  H   GLN A  66      11.860  78.669  -1.254  1.00  0.00           H  
ATOM    573 HE21 GLN A  66       6.653  78.257  -0.106  1.00  0.00           H  
ATOM    574 HE22 GLN A  66       5.847  78.884  -1.503  1.00  0.00           H  
ATOM    575  N   GLY A  67      10.399  78.811   2.902  1.00 47.37           N  
ATOM    576  CA  GLY A  67      10.231  78.164   4.161  1.00 46.53           C  
ATOM    577  C   GLY A  67      11.461  78.330   5.025  1.00 47.05           C  
ATOM    578  O   GLY A  67      11.398  78.030   6.227  1.00 48.49           O  
ATOM    579  H   GLY A  67      10.182  79.757   2.855  1.00  0.00           H  
ATOM    580  N   ASP A  68      12.602  78.763   4.471  1.00 46.41           N  
ATOM    581  CA  ASP A  68      13.814  78.921   5.258  1.00 45.08           C  
ATOM    582  C   ASP A  68      13.996  80.288   5.852  1.00 42.72           C  
ATOM    583  O   ASP A  68      13.530  81.288   5.316  1.00 43.16           O  
ATOM    584  CB  ASP A  68      15.030  78.616   4.420  1.00 47.08           C  
ATOM    585  CG  ASP A  68      15.146  77.136   4.058  1.00 49.82           C  
ATOM    586  OD1 ASP A  68      15.120  76.278   4.951  1.00 50.75           O  
ATOM    587  OD2 ASP A  68      15.269  76.847   2.866  1.00 50.72           O  
ATOM    588  H   ASP A  68      12.673  78.909   3.505  1.00  0.00           H  
ATOM    589  N   PHE A  69      14.564  80.322   7.024  1.00 38.75           N  
ATOM    590  CA  PHE A  69      14.902  81.558   7.628  1.00 38.94           C  
ATOM    591  C   PHE A  69      16.197  82.021   6.983  1.00 38.69           C  
ATOM    592  O   PHE A  69      17.027  81.187   6.637  1.00 38.64           O  
ATOM    593  CB  PHE A  69      15.091  81.315   9.078  1.00 43.46           C  
ATOM    594  CG  PHE A  69      13.805  81.326   9.881  1.00 48.47           C  
ATOM    595  CD1 PHE A  69      13.290  82.540  10.322  1.00 49.62           C  
ATOM    596  CD2 PHE A  69      13.157  80.140  10.179  1.00 49.44           C  
ATOM    597  CE1 PHE A  69      12.121  82.571  11.049  1.00 50.47           C  
ATOM    598  CE2 PHE A  69      11.986  80.183  10.910  1.00 50.12           C  
ATOM    599  CZ  PHE A  69      11.475  81.392  11.346  1.00 50.69           C  
ATOM    600  H   PHE A  69      14.749  79.491   7.491  1.00  0.00           H  
ATOM    601  N   ILE A  70      16.411  83.320   6.797  1.00 38.71           N  
ATOM    602  CA  ILE A  70      17.647  83.878   6.265  1.00 38.87           C  
ATOM    603  C   ILE A  70      18.074  84.840   7.365  1.00 40.50           C  
ATOM    604  O   ILE A  70      17.203  85.528   7.902  1.00 39.80           O  
ATOM    605  CB  ILE A  70      17.544  84.800   5.005  1.00 38.77           C  
ATOM    606  CG1 ILE A  70      16.682  84.323   3.831  1.00 38.58           C  
ATOM    607  CG2 ILE A  70      18.986  84.890   4.533  1.00 38.40           C  
ATOM    608  CD1 ILE A  70      16.570  85.347   2.657  1.00 35.91           C  
ATOM    609  H   ILE A  70      15.733  83.947   7.140  1.00  0.00           H  
ATOM    610  N   GLY A  71      19.355  84.933   7.738  1.00 43.50           N  
ATOM    611  CA  GLY A  71      19.824  85.938   8.693  1.00 45.82           C  
ATOM    612  C   GLY A  71      19.750  85.507  10.161  1.00 47.76           C  
ATOM    613  O   GLY A  71      19.860  86.307  11.085  1.00 48.20           O  
ATOM    614  H   GLY A  71      20.006  84.267   7.425  1.00  0.00           H  
ATOM    615  N   GLU A  72      19.627  84.202  10.434  1.00 46.57           N  
ATOM    616  CA  GLU A  72      19.533  83.711  11.805  1.00 44.86           C  
ATOM    617  C   GLU A  72      20.758  83.978  12.641  1.00 45.05           C  
ATOM    618  O   GLU A  72      20.652  84.434  13.773  1.00 45.10           O  
ATOM    619  CB  GLU A  72      19.303  82.208  11.872  1.00 44.31           C  
ATOM    620  CG  GLU A  72      20.340  81.302  11.214  1.00 43.11           C  
ATOM    621  CD  GLU A  72      20.346  81.135   9.700  1.00 43.62           C  
ATOM    622  OE1 GLU A  72      19.561  81.738   8.965  1.00 41.22           O  
ATOM    623  OE2 GLU A  72      21.165  80.348   9.253  1.00 45.98           O  
ATOM    624  H   GLU A  72      19.596  83.603   9.672  1.00  0.00           H  
ATOM    625  N   LEU A  73      21.940  83.790  12.062  1.00 46.35           N  
ATOM    626  CA  LEU A  73      23.183  83.810  12.812  1.00 48.56           C  
ATOM    627  C   LEU A  73      23.572  85.047  13.612  1.00 50.64           C  
ATOM    628  O   LEU A  73      24.561  84.997  14.354  1.00 51.70           O  
ATOM    629  CB  LEU A  73      24.290  83.418  11.825  1.00 48.48           C  
ATOM    630  CG  LEU A  73      24.764  81.943  11.734  1.00 49.68           C  
ATOM    631  CD1 LEU A  73      23.710  80.892  12.058  1.00 48.16           C  
ATOM    632  CD2 LEU A  73      25.189  81.754  10.304  1.00 49.76           C  
ATOM    633  H   LEU A  73      21.960  83.648  11.097  1.00  0.00           H  
ATOM    634  N   GLY A  74      22.823  86.153  13.537  1.00 52.78           N  
ATOM    635  CA  GLY A  74      23.119  87.321  14.353  1.00 54.09           C  
ATOM    636  C   GLY A  74      22.223  87.346  15.593  1.00 55.81           C  
ATOM    637  O   GLY A  74      22.601  87.876  16.640  1.00 56.38           O  
ATOM    638  H   GLY A  74      22.015  86.202  12.975  1.00  0.00           H  
ATOM    639  N   LEU A  75      21.061  86.684  15.530  1.00 56.90           N  
ATOM    640  CA  LEU A  75      20.059  86.661  16.580  1.00 56.30           C  
ATOM    641  C   LEU A  75      20.581  86.321  17.931  1.00 57.21           C  
ATOM    642  O   LEU A  75      19.998  86.736  18.914  1.00 58.52           O  
ATOM    643  CB  LEU A  75      19.008  85.661  16.229  1.00 55.42           C  
ATOM    644  CG  LEU A  75      17.918  85.335  17.188  1.00 55.42           C  
ATOM    645  CD1 LEU A  75      17.068  86.531  17.553  1.00 55.95           C  
ATOM    646  CD2 LEU A  75      17.101  84.292  16.497  1.00 57.64           C  
ATOM    647  H   LEU A  75      20.878  86.138  14.737  1.00  0.00           H  
ATOM    648  N   PHE A  76      21.648  85.559  17.985  1.00 58.29           N  
ATOM    649  CA  PHE A  76      22.144  85.187  19.272  1.00 61.45           C  
ATOM    650  C   PHE A  76      23.186  86.088  19.874  1.00 66.49           C  
ATOM    651  O   PHE A  76      23.205  86.195  21.099  1.00 67.45           O  
ATOM    652  CB  PHE A  76      22.645  83.792  19.157  1.00 59.68           C  
ATOM    653  CG  PHE A  76      21.446  82.968  18.780  1.00 60.17           C  
ATOM    654  CD1 PHE A  76      20.375  82.883  19.631  1.00 61.41           C  
ATOM    655  CD2 PHE A  76      21.406  82.357  17.555  1.00 60.65           C  
ATOM    656  CE1 PHE A  76      19.255  82.186  19.244  1.00 62.84           C  
ATOM    657  CE2 PHE A  76      20.281  81.653  17.185  1.00 61.33           C  
ATOM    658  CZ  PHE A  76      19.199  81.566  18.022  1.00 62.02           C  
ATOM    659  H   PHE A  76      22.079  85.265  17.157  1.00  0.00           H  
ATOM    660  N   GLU A  77      24.059  86.775  19.127  1.00 72.65           N  
ATOM    661  CA  GLU A  77      25.059  87.597  19.811  1.00 77.19           C  
ATOM    662  C   GLU A  77      25.074  89.017  19.241  1.00 77.82           C  
ATOM    663  O   GLU A  77      25.203  89.285  18.037  1.00 78.66           O  
ATOM    664  CB  GLU A  77      26.472  86.979  19.697  1.00 79.49           C  
ATOM    665  CG  GLU A  77      27.429  87.401  20.844  1.00 83.80           C  
ATOM    666  CD  GLU A  77      27.759  88.899  20.991  1.00 86.16           C  
ATOM    667  OE1 GLU A  77      28.468  89.432  20.131  1.00 87.78           O  
ATOM    668  OE2 GLU A  77      27.299  89.537  21.951  1.00 86.44           O  
ATOM    669  H   GLU A  77      23.845  86.968  18.190  1.00  0.00           H  
ATOM    670  N   GLU A  78      24.962  89.907  20.222  1.00 77.21           N  
ATOM    671  CA  GLU A  78      24.893  91.331  20.018  1.00 77.11           C  
ATOM    672  C   GLU A  78      26.059  91.895  19.222  1.00 75.80           C  
ATOM    673  O   GLU A  78      27.221  91.729  19.581  1.00 73.61           O  
ATOM    674  CB  GLU A  78      24.813  92.005  21.396  1.00 79.31           C  
ATOM    675  CG  GLU A  78      23.818  93.178  21.518  1.00 81.55           C  
ATOM    676  CD  GLU A  78      22.325  92.822  21.405  1.00 82.43           C  
ATOM    677  OE1 GLU A  78      21.811  92.757  20.274  1.00 82.48           O  
ATOM    678  OE2 GLU A  78      21.683  92.633  22.453  1.00 82.21           O  
ATOM    679  H   GLU A  78      24.939  89.566  21.138  1.00  0.00           H  
ATOM    680  N   GLY A  79      25.711  92.480  18.080  1.00 75.66           N  
ATOM    681  CA  GLY A  79      26.658  93.251  17.292  1.00 74.59           C  
ATOM    682  C   GLY A  79      27.476  92.501  16.257  1.00 73.59           C  
ATOM    683  O   GLY A  79      28.647  92.816  16.030  1.00 73.03           O  
ATOM    684  H   GLY A  79      24.813  92.329  17.723  1.00  0.00           H  
ATOM    685  N   GLN A  80      26.891  91.540  15.551  1.00 72.38           N  
ATOM    686  CA  GLN A  80      27.673  90.793  14.587  1.00 69.45           C  
ATOM    687  C   GLN A  80      27.383  91.215  13.159  1.00 69.04           C  
ATOM    688  O   GLN A  80      26.326  91.755  12.816  1.00 69.27           O  
ATOM    689  CB  GLN A  80      27.387  89.320  14.775  1.00 67.34           C  
ATOM    690  CG  GLN A  80      27.699  88.880  16.184  1.00 64.96           C  
ATOM    691  CD  GLN A  80      27.686  87.386  16.279  1.00 64.72           C  
ATOM    692  OE1 GLN A  80      28.730  86.781  16.089  1.00 65.49           O  
ATOM    693  NE2 GLN A  80      26.571  86.725  16.546  1.00 63.83           N  
ATOM    694  H   GLN A  80      25.946  91.336  15.669  1.00  0.00           H  
ATOM    695 HE21 GLN A  80      25.764  87.250  16.730  1.00  0.00           H  
ATOM    696 HE22 GLN A  80      26.610  85.748  16.504  1.00  0.00           H  
ATOM    697  N   GLU A  81      28.371  90.990  12.313  1.00 67.84           N  
ATOM    698  CA  GLU A  81      28.235  91.280  10.910  1.00 66.25           C  
ATOM    699  C   GLU A  81      27.548  90.087  10.263  1.00 62.78           C  
ATOM    700  O   GLU A  81      27.563  88.956  10.766  1.00 63.03           O  
ATOM    701  CB  GLU A  81      29.620  91.497  10.310  1.00 70.77           C  
ATOM    702  CG  GLU A  81      30.323  92.752  10.878  1.00 75.18           C  
ATOM    703  CD  GLU A  81      31.757  93.051  10.398  1.00 76.88           C  
ATOM    704  OE1 GLU A  81      32.434  92.149   9.883  1.00 76.67           O  
ATOM    705  OE2 GLU A  81      32.195  94.205  10.561  1.00 77.86           O  
ATOM    706  H   GLU A  81      29.166  90.514  12.612  1.00  0.00           H  
ATOM    707  N   ARG A  82      26.901  90.336   9.138  1.00 58.59           N  
ATOM    708  CA  ARG A  82      26.274  89.300   8.335  1.00 54.07           C  
ATOM    709  C   ARG A  82      27.413  88.484   7.717  1.00 51.78           C  
ATOM    710  O   ARG A  82      28.363  89.064   7.179  1.00 50.29           O  
ATOM    711  CB  ARG A  82      25.420  89.941   7.248  1.00 52.07           C  
ATOM    712  CG  ARG A  82      24.441  90.997   7.754  1.00 50.38           C  
ATOM    713  CD  ARG A  82      22.976  90.766   7.462  1.00 48.93           C  
ATOM    714  NE  ARG A  82      22.429  89.771   8.352  1.00 48.18           N  
ATOM    715  CZ  ARG A  82      21.253  89.939   8.949  1.00 48.25           C  
ATOM    716  NH1 ARG A  82      20.472  91.003   8.744  1.00 48.74           N  
ATOM    717  NH2 ARG A  82      20.860  88.986   9.776  1.00 48.44           N  
ATOM    718  H   ARG A  82      26.810  91.274   8.906  1.00  0.00           H  
ATOM    719  HE  ARG A  82      22.930  88.946   8.521  1.00  0.00           H  
ATOM    720 HH11 ARG A  82      20.748  91.711   8.094  1.00  0.00           H  
ATOM    721 HH12 ARG A  82      19.580  91.044   9.189  1.00  0.00           H  
ATOM    722 HH21 ARG A  82      21.456  88.194   9.900  1.00  0.00           H  
ATOM    723 HH22 ARG A  82      19.967  89.049  10.218  1.00  0.00           H  
ATOM    724  N   SER A  83      27.317  87.157   7.859  1.00 48.78           N  
ATOM    725  CA  SER A  83      28.308  86.181   7.439  1.00 44.46           C  
ATOM    726  C   SER A  83      28.496  85.865   5.971  1.00 42.61           C  
ATOM    727  O   SER A  83      29.571  85.405   5.572  1.00 42.62           O  
ATOM    728  CB  SER A  83      28.023  84.890   8.136  1.00 44.46           C  
ATOM    729  OG  SER A  83      26.675  84.507   7.879  1.00 44.80           O  
ATOM    730  H   SER A  83      26.544  86.816   8.348  1.00  0.00           H  
ATOM    731  HG  SER A  83      26.119  84.925   8.563  1.00  0.00           H  
ATOM    732  N   ALA A  84      27.513  86.115   5.130  1.00 38.57           N  
ATOM    733  CA  ALA A  84      27.638  85.778   3.732  1.00 36.31           C  
ATOM    734  C   ALA A  84      26.738  86.698   2.939  1.00 35.52           C  
ATOM    735  O   ALA A  84      26.076  87.535   3.539  1.00 33.91           O  
ATOM    736  CB  ALA A  84      27.205  84.360   3.565  1.00 36.71           C  
ATOM    737  H   ALA A  84      26.698  86.588   5.408  1.00  0.00           H  
ATOM    738  N   TRP A  85      26.753  86.680   1.620  1.00 37.20           N  
ATOM    739  CA  TRP A  85      25.832  87.454   0.800  1.00 40.10           C  
ATOM    740  C   TRP A  85      24.679  86.529   0.499  1.00 38.84           C  
ATOM    741  O   TRP A  85      24.861  85.335   0.300  1.00 40.62           O  
ATOM    742  CB  TRP A  85      26.370  87.883  -0.578  1.00 42.89           C  
ATOM    743  CG  TRP A  85      27.273  89.096  -0.600  1.00 46.69           C  
ATOM    744  CD1 TRP A  85      26.873  90.329  -1.059  1.00 48.56           C  
ATOM    745  CD2 TRP A  85      28.541  89.094  -0.147  1.00 50.67           C  
ATOM    746  NE1 TRP A  85      27.906  91.118  -0.884  1.00 49.09           N  
ATOM    747  CE2 TRP A  85      28.909  90.408  -0.336  1.00 52.20           C  
ATOM    748  CE3 TRP A  85      29.388  88.156   0.392  1.00 55.80           C  
ATOM    749  CZ2 TRP A  85      30.174  90.797   0.033  1.00 56.59           C  
ATOM    750  CZ3 TRP A  85      30.661  88.550   0.754  1.00 57.59           C  
ATOM    751  CH2 TRP A  85      31.047  89.864   0.577  1.00 57.79           C  
ATOM    752  H   TRP A  85      27.338  86.050   1.161  1.00  0.00           H  
ATOM    753  HE1 TRP A  85      28.023  91.987  -1.317  1.00  0.00           H  
ATOM    754  N   VAL A  86      23.489  87.058   0.409  1.00 37.34           N  
ATOM    755  CA  VAL A  86      22.326  86.266   0.134  1.00 34.98           C  
ATOM    756  C   VAL A  86      21.813  87.033  -1.069  1.00 35.95           C  
ATOM    757  O   VAL A  86      21.468  88.209  -0.921  1.00 36.05           O  
ATOM    758  CB  VAL A  86      21.473  86.360   1.409  1.00 33.45           C  
ATOM    759  CG1 VAL A  86      20.158  85.704   1.192  1.00 34.36           C  
ATOM    760  CG2 VAL A  86      22.137  85.633   2.546  1.00 32.21           C  
ATOM    761  H   VAL A  86      23.405  88.034   0.436  1.00  0.00           H  
ATOM    762  N   ARG A  87      21.845  86.500  -2.274  1.00 38.34           N  
ATOM    763  CA  ARG A  87      21.275  87.221  -3.404  1.00 41.47           C  
ATOM    764  C   ARG A  87      20.071  86.423  -3.895  1.00 42.07           C  
ATOM    765  O   ARG A  87      20.073  85.187  -3.864  1.00 42.94           O  
ATOM    766  CB  ARG A  87      22.368  87.410  -4.491  1.00 45.29           C  
ATOM    767  CG  ARG A  87      22.274  86.808  -5.914  1.00 52.06           C  
ATOM    768  CD  ARG A  87      23.257  87.316  -6.998  1.00 56.26           C  
ATOM    769  NE  ARG A  87      24.681  87.123  -6.726  1.00 61.97           N  
ATOM    770  CZ  ARG A  87      25.422  88.004  -5.997  1.00 65.29           C  
ATOM    771  NH1 ARG A  87      24.886  89.098  -5.411  1.00 65.20           N  
ATOM    772  NH2 ARG A  87      26.741  87.796  -5.816  1.00 65.69           N  
ATOM    773  H   ARG A  87      22.185  85.583  -2.370  1.00  0.00           H  
ATOM    774  HE  ARG A  87      25.119  86.317  -7.075  1.00  0.00           H  
ATOM    775 HH11 ARG A  87      23.913  89.306  -5.509  1.00  0.00           H  
ATOM    776 HH12 ARG A  87      25.469  89.705  -4.874  1.00  0.00           H  
ATOM    777 HH21 ARG A  87      27.197  86.996  -6.205  1.00  0.00           H  
ATOM    778 HH22 ARG A  87      27.273  88.447  -5.276  1.00  0.00           H  
ATOM    779  N   ALA A  88      18.982  87.082  -4.281  1.00 42.63           N  
ATOM    780  CA  ALA A  88      17.748  86.444  -4.712  1.00 41.73           C  
ATOM    781  C   ALA A  88      17.912  85.764  -6.052  1.00 41.85           C  
ATOM    782  O   ALA A  88      18.152  86.419  -7.059  1.00 40.26           O  
ATOM    783  CB  ALA A  88      16.652  87.490  -4.833  1.00 40.98           C  
ATOM    784  H   ALA A  88      19.038  88.052  -4.340  1.00  0.00           H  
ATOM    785  N   LYS A  89      17.810  84.448  -6.117  1.00 44.40           N  
ATOM    786  CA  LYS A  89      17.921  83.745  -7.384  1.00 47.33           C  
ATOM    787  C   LYS A  89      16.681  83.973  -8.208  1.00 48.26           C  
ATOM    788  O   LYS A  89      16.673  83.766  -9.420  1.00 49.07           O  
ATOM    789  CB  LYS A  89      18.008  82.248  -7.244  1.00 49.80           C  
ATOM    790  CG  LYS A  89      19.377  81.609  -7.125  1.00 53.56           C  
ATOM    791  CD  LYS A  89      19.283  80.128  -7.488  1.00 55.79           C  
ATOM    792  CE  LYS A  89      18.346  79.423  -6.501  1.00 59.06           C  
ATOM    793  NZ  LYS A  89      18.111  78.047  -6.900  1.00 61.96           N  
ATOM    794  H   LYS A  89      17.563  83.957  -5.314  1.00  0.00           H  
ATOM    795  HZ1 LYS A  89      19.022  77.547  -6.938  1.00  0.00           H  
ATOM    796  HZ2 LYS A  89      17.680  78.049  -7.847  1.00  0.00           H  
ATOM    797  HZ3 LYS A  89      17.474  77.582  -6.225  1.00  0.00           H  
ATOM    798  N   THR A  90      15.598  84.337  -7.539  1.00 48.67           N  
ATOM    799  CA  THR A  90      14.303  84.488  -8.168  1.00 49.10           C  
ATOM    800  C   THR A  90      13.566  85.584  -7.442  1.00 48.93           C  
ATOM    801  O   THR A  90      14.131  86.260  -6.584  1.00 49.12           O  
ATOM    802  CB  THR A  90      13.496  83.166  -8.086  1.00 49.32           C  
ATOM    803  OG1 THR A  90      13.866  82.512  -6.870  1.00 51.18           O  
ATOM    804  CG2 THR A  90      13.702  82.298  -9.317  1.00 49.21           C  
ATOM    805  H   THR A  90      15.656  84.617  -6.602  1.00  0.00           H  
ATOM    806  HG1 THR A  90      14.822  82.611  -6.773  1.00  0.00           H  
ATOM    807  N   ALA A  91      12.308  85.757  -7.797  1.00 49.09           N  
ATOM    808  CA  ALA A  91      11.479  86.732  -7.152  1.00 49.79           C  
ATOM    809  C   ALA A  91      11.165  86.196  -5.770  1.00 50.03           C  
ATOM    810  O   ALA A  91      10.540  85.145  -5.650  1.00 51.16           O  
ATOM    811  CB  ALA A  91      10.221  86.871  -7.954  1.00 51.70           C  
ATOM    812  H   ALA A  91      11.890  85.156  -8.440  1.00  0.00           H  
ATOM    813  N   CYS A  92      11.560  86.879  -4.726  1.00 50.85           N  
ATOM    814  CA  CYS A  92      11.319  86.385  -3.393  1.00 53.21           C  
ATOM    815  C   CYS A  92      10.358  87.241  -2.595  1.00 54.51           C  
ATOM    816  O   CYS A  92      10.457  88.471  -2.570  1.00 54.95           O  
ATOM    817  CB  CYS A  92      12.618  86.300  -2.624  1.00 53.03           C  
ATOM    818  SG  CYS A  92      13.771  85.055  -3.228  1.00 54.83           S  
ATOM    819  H   CYS A  92      11.975  87.752  -4.885  1.00  0.00           H  
ATOM    820  N   GLU A  93       9.423  86.609  -1.914  1.00 55.32           N  
ATOM    821  CA  GLU A  93       8.533  87.337  -1.047  1.00 55.08           C  
ATOM    822  C   GLU A  93       9.225  87.005   0.249  1.00 52.34           C  
ATOM    823  O   GLU A  93       9.230  85.830   0.613  1.00 51.16           O  
ATOM    824  CB  GLU A  93       7.154  86.727  -1.170  1.00 60.50           C  
ATOM    825  CG  GLU A  93       6.147  87.796  -1.592  1.00 66.87           C  
ATOM    826  CD  GLU A  93       4.938  87.313  -2.405  1.00 70.69           C  
ATOM    827  OE1 GLU A  93       5.114  86.975  -3.589  1.00 72.35           O  
ATOM    828  OE2 GLU A  93       3.829  87.298  -1.851  1.00 71.89           O  
ATOM    829  H   GLU A  93       9.463  85.632  -1.879  1.00  0.00           H  
ATOM    830  N   VAL A  94       9.869  87.958   0.902  1.00 50.32           N  
ATOM    831  CA  VAL A  94      10.650  87.716   2.105  1.00 50.17           C  
ATOM    832  C   VAL A  94      10.073  88.489   3.281  1.00 48.98           C  
ATOM    833  O   VAL A  94       9.813  89.686   3.174  1.00 48.26           O  
ATOM    834  CB  VAL A  94      12.124  88.155   1.898  1.00 51.42           C  
ATOM    835  CG1 VAL A  94      12.948  87.792   3.125  1.00 51.45           C  
ATOM    836  CG2 VAL A  94      12.731  87.475   0.691  1.00 51.73           C  
ATOM    837  H   VAL A  94       9.728  88.884   0.615  1.00  0.00           H  
ATOM    838  N   ALA A  95       9.815  87.824   4.395  1.00 49.27           N  
ATOM    839  CA  ALA A  95       9.294  88.446   5.602  1.00 50.84           C  
ATOM    840  C   ALA A  95      10.457  89.050   6.373  1.00 53.56           C  
ATOM    841  O   ALA A  95      11.540  88.457   6.277  1.00 54.83           O  
ATOM    842  CB  ALA A  95       8.626  87.391   6.450  1.00 48.14           C  
ATOM    843  H   ALA A  95      10.017  86.874   4.410  1.00  0.00           H  
ATOM    844  N   GLU A  96      10.278  90.174   7.099  1.00 55.97           N  
ATOM    845  CA  GLU A  96      11.334  90.793   7.907  1.00 58.45           C  
ATOM    846  C   GLU A  96      10.938  91.124   9.342  1.00 59.11           C  
ATOM    847  O   GLU A  96       9.953  91.878   9.458  1.00 60.53           O  
ATOM    848  CB  GLU A  96      11.771  92.114   7.403  1.00 61.07           C  
ATOM    849  CG  GLU A  96      12.210  92.328   5.995  1.00 67.12           C  
ATOM    850  CD  GLU A  96      12.805  93.724   5.987  1.00 70.38           C  
ATOM    851  OE1 GLU A  96      12.045  94.678   5.781  1.00 71.33           O  
ATOM    852  OE2 GLU A  96      14.015  93.853   6.238  1.00 72.14           O  
ATOM    853  H   GLU A  96       9.451  90.674   6.960  1.00  0.00           H  
ATOM    854  N   ILE A  97      11.677  90.727  10.399  1.00 59.19           N  
ATOM    855  CA  ILE A  97      11.361  91.017  11.818  1.00 59.08           C  
ATOM    856  C   ILE A  97      12.594  91.670  12.397  1.00 59.61           C  
ATOM    857  O   ILE A  97      13.716  91.305  12.033  1.00 60.17           O  
ATOM    858  CB  ILE A  97      11.192  89.845  12.832  1.00 58.73           C  
ATOM    859  CG1 ILE A  97      10.463  88.718  12.221  1.00 61.17           C  
ATOM    860  CG2 ILE A  97      10.380  90.250  14.017  1.00 56.46           C  
ATOM    861  CD1 ILE A  97      11.513  87.735  11.665  1.00 64.60           C  
ATOM    862  H   ILE A  97      12.517  90.257  10.194  1.00  0.00           H  
ATOM    863  N   SER A  98      12.391  92.584  13.342  1.00 60.56           N  
ATOM    864  CA  SER A  98      13.478  93.204  14.089  1.00 60.56           C  
ATOM    865  C   SER A  98      14.041  92.112  14.989  1.00 59.45           C  
ATOM    866  O   SER A  98      13.262  91.348  15.580  1.00 59.91           O  
ATOM    867  CB  SER A  98      12.952  94.357  14.971  1.00 61.59           C  
ATOM    868  OG  SER A  98      11.542  94.617  14.837  1.00 62.97           O  
ATOM    869  H   SER A  98      11.480  92.828  13.604  1.00  0.00           H  
ATOM    870  HG  SER A  98      11.291  95.386  15.363  1.00  0.00           H  
ATOM    871  N   TYR A  99      15.354  92.009  15.157  1.00 57.95           N  
ATOM    872  CA  TYR A  99      15.911  91.000  16.054  1.00 57.58           C  
ATOM    873  C   TYR A  99      15.302  91.098  17.455  1.00 59.60           C  
ATOM    874  O   TYR A  99      14.653  90.182  17.967  1.00 58.14           O  
ATOM    875  CB  TYR A  99      17.438  91.163  16.123  1.00 53.56           C  
ATOM    876  CG  TYR A  99      18.270  90.362  15.109  1.00 49.36           C  
ATOM    877  CD1 TYR A  99      17.724  89.462  14.192  1.00 47.44           C  
ATOM    878  CD2 TYR A  99      19.630  90.549  15.146  1.00 46.71           C  
ATOM    879  CE1 TYR A  99      18.540  88.752  13.332  1.00 44.98           C  
ATOM    880  CE2 TYR A  99      20.438  89.851  14.287  1.00 44.21           C  
ATOM    881  CZ  TYR A  99      19.899  88.959  13.397  1.00 43.64           C  
ATOM    882  OH  TYR A  99      20.772  88.243  12.612  1.00 41.19           O  
ATOM    883  H   TYR A  99      15.944  92.546  14.580  1.00  0.00           H  
ATOM    884  HH  TYR A  99      21.464  88.802  12.256  1.00  0.00           H  
ATOM    885  N   LYS A 100      15.346  92.320  17.981  1.00 63.60           N  
ATOM    886  CA  LYS A 100      14.824  92.665  19.299  1.00 66.77           C  
ATOM    887  C   LYS A 100      13.383  92.235  19.483  1.00 67.31           C  
ATOM    888  O   LYS A 100      12.909  91.894  20.568  1.00 68.14           O  
ATOM    889  CB  LYS A 100      14.902  94.171  19.525  1.00 68.37           C  
ATOM    890  CG  LYS A 100      16.310  94.794  19.691  1.00 72.67           C  
ATOM    891  CD  LYS A 100      17.295  94.815  18.479  1.00 74.59           C  
ATOM    892  CE  LYS A 100      16.857  95.657  17.256  1.00 75.93           C  
ATOM    893  NZ  LYS A 100      16.754  97.081  17.559  1.00 76.32           N  
ATOM    894  H   LYS A 100      15.766  93.007  17.435  1.00  0.00           H  
ATOM    895  HZ1 LYS A 100      17.684  97.454  17.832  1.00  0.00           H  
ATOM    896  HZ2 LYS A 100      16.091  97.215  18.350  1.00  0.00           H  
ATOM    897  HZ3 LYS A 100      16.401  97.598  16.728  1.00  0.00           H  
ATOM    898  N   LYS A 101      12.656  92.211  18.387  1.00 67.82           N  
ATOM    899  CA  LYS A 101      11.277  91.867  18.494  1.00 68.92           C  
ATOM    900  C   LYS A 101      11.184  90.363  18.418  1.00 67.51           C  
ATOM    901  O   LYS A 101      10.411  89.784  19.186  1.00 66.26           O  
ATOM    902  CB  LYS A 101      10.591  92.606  17.377  1.00 72.64           C  
ATOM    903  CG  LYS A 101       9.187  93.155  17.707  1.00 76.47           C  
ATOM    904  CD  LYS A 101       8.060  92.125  17.602  1.00 79.00           C  
ATOM    905  CE  LYS A 101       8.230  91.465  16.239  1.00 81.52           C  
ATOM    906  NZ  LYS A 101       7.100  90.706  15.789  1.00 82.94           N  
ATOM    907  H   LYS A 101      13.057  92.294  17.503  1.00  0.00           H  
ATOM    908  HZ1 LYS A 101       6.309  91.378  15.762  1.00  0.00           H  
ATOM    909  HZ2 LYS A 101       6.858  89.940  16.447  1.00  0.00           H  
ATOM    910  HZ3 LYS A 101       7.269  90.331  14.834  1.00  0.00           H  
ATOM    911  N   PHE A 102      11.960  89.688  17.563  1.00 67.30           N  
ATOM    912  CA  PHE A 102      11.913  88.228  17.490  1.00 67.71           C  
ATOM    913  C   PHE A 102      12.253  87.631  18.858  1.00 69.05           C  
ATOM    914  O   PHE A 102      11.605  86.678  19.321  1.00 69.08           O  
ATOM    915  CB  PHE A 102      12.893  87.706  16.423  1.00 64.28           C  
ATOM    916  CG  PHE A 102      12.691  86.235  16.054  1.00 61.35           C  
ATOM    917  CD1 PHE A 102      11.529  85.821  15.424  1.00 61.09           C  
ATOM    918  CD2 PHE A 102      13.671  85.312  16.354  1.00 59.19           C  
ATOM    919  CE1 PHE A 102      11.355  84.492  15.099  1.00 60.60           C  
ATOM    920  CE2 PHE A 102      13.482  83.988  16.024  1.00 58.57           C  
ATOM    921  CZ  PHE A 102      12.329  83.570  15.396  1.00 59.69           C  
ATOM    922  H   PHE A 102      12.491  90.188  16.913  1.00  0.00           H  
ATOM    923  N   ARG A 103      13.214  88.260  19.549  1.00 69.44           N  
ATOM    924  CA  ARG A 103      13.558  87.884  20.905  1.00 71.28           C  
ATOM    925  C   ARG A 103      12.283  87.748  21.724  1.00 72.70           C  
ATOM    926  O   ARG A 103      12.028  86.719  22.359  1.00 73.54           O  
ATOM    927  CB  ARG A 103      14.441  88.938  21.542  1.00 72.57           C  
ATOM    928  CG  ARG A 103      15.893  88.505  21.646  1.00 75.50           C  
ATOM    929  CD  ARG A 103      16.697  88.762  20.379  1.00 77.72           C  
ATOM    930  NE  ARG A 103      17.172  90.139  20.289  1.00 80.15           N  
ATOM    931  CZ  ARG A 103      18.304  90.475  19.640  1.00 81.97           C  
ATOM    932  NH1 ARG A 103      19.076  89.590  18.987  1.00 82.54           N  
ATOM    933  NH2 ARG A 103      18.674  91.754  19.619  1.00 83.85           N  
ATOM    934  H   ARG A 103      13.729  88.942  19.075  1.00  0.00           H  
ATOM    935  HE  ARG A 103      16.643  90.850  20.708  1.00  0.00           H  
ATOM    936 HH11 ARG A 103      18.843  88.618  18.984  1.00  0.00           H  
ATOM    937 HH12 ARG A 103      19.910  89.900  18.531  1.00  0.00           H  
ATOM    938 HH21 ARG A 103      18.107  92.442  20.072  1.00  0.00           H  
ATOM    939 HH22 ARG A 103      19.527  92.022  19.174  1.00  0.00           H  
ATOM    940  N   GLN A 104      11.404  88.743  21.574  1.00 74.61           N  
ATOM    941  CA  GLN A 104      10.137  88.764  22.276  1.00 76.07           C  
ATOM    942  C   GLN A 104       9.259  87.610  21.873  1.00 74.72           C  
ATOM    943  O   GLN A 104       8.722  86.908  22.730  1.00 75.53           O  
ATOM    944  CB  GLN A 104       9.402  90.075  22.011  1.00 79.34           C  
ATOM    945  CG  GLN A 104      10.050  91.242  22.769  1.00 83.07           C  
ATOM    946  CD  GLN A 104       9.562  92.633  22.375  1.00 84.06           C  
ATOM    947  OE1 GLN A 104       8.455  93.074  22.701  1.00 85.01           O  
ATOM    948  NE2 GLN A 104      10.403  93.360  21.649  1.00 84.55           N  
ATOM    949  H   GLN A 104      11.624  89.476  20.965  1.00  0.00           H  
ATOM    950 HE21 GLN A 104      11.271  92.966  21.416  1.00  0.00           H  
ATOM    951 HE22 GLN A 104      10.106  94.255  21.397  1.00  0.00           H  
ATOM    952  N   LEU A 105       9.137  87.341  20.590  1.00 73.07           N  
ATOM    953  CA  LEU A 105       8.292  86.242  20.197  1.00 73.37           C  
ATOM    954  C   LEU A 105       8.750  84.923  20.767  1.00 73.46           C  
ATOM    955  O   LEU A 105       7.881  84.119  21.086  1.00 72.60           O  
ATOM    956  CB  LEU A 105       8.230  86.139  18.690  1.00 74.60           C  
ATOM    957  CG  LEU A 105       7.095  86.901  18.030  1.00 75.47           C  
ATOM    958  CD1 LEU A 105       7.394  88.379  18.114  1.00 75.39           C  
ATOM    959  CD2 LEU A 105       6.929  86.452  16.584  1.00 75.75           C  
ATOM    960  H   LEU A 105       9.602  87.925  19.954  1.00  0.00           H  
ATOM    961  N   ILE A 106      10.056  84.689  20.975  1.00 75.04           N  
ATOM    962  CA  ILE A 106      10.549  83.431  21.568  1.00 77.10           C  
ATOM    963  C   ILE A 106       9.995  83.197  22.983  1.00 78.41           C  
ATOM    964  O   ILE A 106       9.474  82.110  23.281  1.00 77.77           O  
ATOM    965  CB  ILE A 106      12.119  83.433  21.571  1.00 76.37           C  
ATOM    966  CG1 ILE A 106      12.630  83.339  20.130  1.00 75.86           C  
ATOM    967  CG2 ILE A 106      12.664  82.266  22.403  1.00 76.25           C  
ATOM    968  CD1 ILE A 106      14.147  83.539  19.976  1.00 75.24           C  
ATOM    969  H   ILE A 106      10.679  85.346  20.592  1.00  0.00           H  
ATOM    970  N   GLN A 107      10.082  84.241  23.825  1.00 78.80           N  
ATOM    971  CA  GLN A 107       9.549  84.227  25.190  1.00 78.60           C  
ATOM    972  C   GLN A 107       8.056  83.926  25.164  1.00 77.36           C  
ATOM    973  O   GLN A 107       7.514  83.267  26.042  1.00 77.35           O  
ATOM    974  CB  GLN A 107       9.720  85.578  25.874  1.00 80.12           C  
ATOM    975  CG  GLN A 107      11.138  86.152  25.893  1.00 83.27           C  
ATOM    976  CD  GLN A 107      12.090  85.554  26.921  1.00 85.09           C  
ATOM    977  OE1 GLN A 107      12.325  84.347  26.990  1.00 87.20           O  
ATOM    978  NE2 GLN A 107      12.700  86.376  27.764  1.00 85.08           N  
ATOM    979  H   GLN A 107      10.550  85.035  23.483  1.00  0.00           H  
ATOM    980 HE21 GLN A 107      12.555  87.339  27.691  1.00  0.00           H  
ATOM    981 HE22 GLN A 107      13.272  85.945  28.432  1.00  0.00           H  
ATOM    982  N   VAL A 108       7.381  84.472  24.165  1.00 76.29           N  
ATOM    983  CA  VAL A 108       5.968  84.246  23.961  1.00 75.75           C  
ATOM    984  C   VAL A 108       5.687  82.833  23.415  1.00 74.97           C  
ATOM    985  O   VAL A 108       4.637  82.262  23.731  1.00 74.73           O  
ATOM    986  CB  VAL A 108       5.511  85.403  23.034  1.00 77.23           C  
ATOM    987  CG1 VAL A 108       4.024  85.320  22.729  1.00 78.35           C  
ATOM    988  CG2 VAL A 108       5.755  86.734  23.746  1.00 77.58           C  
ATOM    989  H   VAL A 108       7.851  85.101  23.583  1.00  0.00           H  
ATOM    990  N   ASN A 109       6.503  82.219  22.551  1.00 73.39           N  
ATOM    991  CA  ASN A 109       6.358  80.816  22.169  1.00 72.16           C  
ATOM    992  C   ASN A 109       7.661  80.260  21.614  1.00 74.11           C  
ATOM    993  O   ASN A 109       8.015  80.471  20.448  1.00 76.07           O  
ATOM    994  CB  ASN A 109       5.316  80.505  21.065  1.00 68.22           C  
ATOM    995  CG  ASN A 109       5.302  79.006  20.722  1.00 65.40           C  
ATOM    996  OD1 ASN A 109       5.011  78.585  19.607  1.00 63.78           O  
ATOM    997  ND2 ASN A 109       5.638  78.067  21.602  1.00 64.16           N  
ATOM    998  H   ASN A 109       7.177  82.762  22.107  1.00  0.00           H  
ATOM    999 HD21 ASN A 109       5.901  78.317  22.513  1.00  0.00           H  
ATOM   1000 HD22 ASN A 109       5.520  77.138  21.306  1.00  0.00           H  
ATOM   1001  N   PRO A 110       8.329  79.388  22.379  1.00 75.00           N  
ATOM   1002  CA  PRO A 110       9.501  78.638  21.934  1.00 74.60           C  
ATOM   1003  C   PRO A 110       9.417  77.843  20.636  1.00 73.47           C  
ATOM   1004  O   PRO A 110      10.465  77.662  20.019  1.00 72.94           O  
ATOM   1005  CB  PRO A 110       9.833  77.764  23.123  1.00 75.09           C  
ATOM   1006  CG  PRO A 110       9.494  78.694  24.260  1.00 75.18           C  
ATOM   1007  CD  PRO A 110       8.134  79.215  23.812  1.00 74.81           C  
ATOM   1008  N   ASP A 111       8.267  77.403  20.103  1.00 73.52           N  
ATOM   1009  CA  ASP A 111       8.275  76.595  18.888  1.00 74.25           C  
ATOM   1010  C   ASP A 111       8.870  77.325  17.675  1.00 73.10           C  
ATOM   1011  O   ASP A 111       9.466  76.639  16.827  1.00 72.69           O  
ATOM   1012  CB  ASP A 111       6.841  76.091  18.559  1.00 76.30           C  
ATOM   1013  CG  ASP A 111       6.729  75.021  17.444  1.00 77.88           C  
ATOM   1014  OD1 ASP A 111       7.582  74.124  17.334  1.00 76.97           O  
ATOM   1015  OD2 ASP A 111       5.766  75.095  16.672  1.00 79.41           O  
ATOM   1016  H   ASP A 111       7.417  77.667  20.497  1.00  0.00           H  
ATOM   1017  N   ILE A 112       8.844  78.667  17.537  1.00 70.06           N  
ATOM   1018  CA  ILE A 112       9.568  79.218  16.397  1.00 66.85           C  
ATOM   1019  C   ILE A 112      11.039  79.064  16.727  1.00 65.97           C  
ATOM   1020  O   ILE A 112      11.702  78.520  15.847  1.00 67.31           O  
ATOM   1021  CB  ILE A 112       9.359  80.723  16.050  1.00 64.46           C  
ATOM   1022  CG1 ILE A 112       8.835  81.536  17.195  1.00 63.67           C  
ATOM   1023  CG2 ILE A 112       8.483  80.743  14.810  1.00 63.04           C  
ATOM   1024  CD1 ILE A 112       9.907  81.894  18.237  1.00 62.93           C  
ATOM   1025  H   ILE A 112       8.436  79.232  18.227  1.00  0.00           H  
ATOM   1026  N   LEU A 113      11.584  79.358  17.933  1.00 63.53           N  
ATOM   1027  CA  LEU A 113      13.023  79.192  18.143  1.00 63.36           C  
ATOM   1028  C   LEU A 113      13.442  77.733  17.917  1.00 64.13           C  
ATOM   1029  O   LEU A 113      14.542  77.439  17.450  1.00 64.18           O  
ATOM   1030  CB  LEU A 113      13.447  79.616  19.547  1.00 61.44           C  
ATOM   1031  CG  LEU A 113      14.963  79.511  19.831  1.00 61.17           C  
ATOM   1032  CD1 LEU A 113      15.818  80.356  18.892  1.00 59.55           C  
ATOM   1033  CD2 LEU A 113      15.176  79.973  21.238  1.00 61.07           C  
ATOM   1034  H   LEU A 113      10.992  79.557  18.682  1.00  0.00           H  
ATOM   1035  N   MET A 114      12.528  76.797  18.157  1.00 65.05           N  
ATOM   1036  CA  MET A 114      12.763  75.419  17.771  1.00 65.57           C  
ATOM   1037  C   MET A 114      12.806  75.265  16.254  1.00 65.25           C  
ATOM   1038  O   MET A 114      13.856  74.834  15.766  1.00 65.82           O  
ATOM   1039  CB  MET A 114      11.680  74.501  18.327  1.00 66.53           C  
ATOM   1040  CG  MET A 114      11.823  74.318  19.821  1.00 66.70           C  
ATOM   1041  SD  MET A 114      13.509  73.801  20.198  1.00 67.97           S  
ATOM   1042  CE  MET A 114      13.334  72.088  19.799  1.00 66.67           C  
ATOM   1043  H   MET A 114      11.754  77.047  18.698  1.00  0.00           H  
ATOM   1044  N   ARG A 115      11.778  75.616  15.454  1.00 64.41           N  
ATOM   1045  CA  ARG A 115      11.805  75.462  13.991  1.00 64.75           C  
ATOM   1046  C   ARG A 115      13.059  76.055  13.350  1.00 61.51           C  
ATOM   1047  O   ARG A 115      13.652  75.478  12.436  1.00 60.51           O  
ATOM   1048  CB  ARG A 115      10.579  76.126  13.371  1.00 68.76           C  
ATOM   1049  CG  ARG A 115       9.245  75.512  13.800  1.00 74.14           C  
ATOM   1050  CD  ARG A 115       8.137  76.508  13.430  1.00 78.53           C  
ATOM   1051  NE  ARG A 115       6.777  76.178  13.882  1.00 80.68           N  
ATOM   1052  CZ  ARG A 115       5.816  75.736  13.054  1.00 81.19           C  
ATOM   1053  NH1 ARG A 115       6.029  75.559  11.748  1.00 81.49           N  
ATOM   1054  NH2 ARG A 115       4.604  75.502  13.544  1.00 80.93           N  
ATOM   1055  H   ARG A 115      10.980  75.997  15.873  1.00  0.00           H  
ATOM   1056  HE  ARG A 115       6.530  76.331  14.818  1.00  0.00           H  
ATOM   1057 HH11 ARG A 115       6.920  75.788  11.354  1.00  0.00           H  
ATOM   1058 HH12 ARG A 115       5.284  75.256  11.154  1.00  0.00           H  
ATOM   1059 HH21 ARG A 115       4.418  75.723  14.501  1.00  0.00           H  
ATOM   1060 HH22 ARG A 115       3.877  75.173  12.942  1.00  0.00           H  
ATOM   1061  N   LEU A 116      13.514  77.183  13.896  1.00 58.11           N  
ATOM   1062  CA  LEU A 116      14.719  77.880  13.473  1.00 54.84           C  
ATOM   1063  C   LEU A 116      15.995  77.100  13.765  1.00 54.48           C  
ATOM   1064  O   LEU A 116      16.825  76.850  12.879  1.00 53.09           O  
ATOM   1065  CB  LEU A 116      14.765  79.231  14.178  1.00 51.15           C  
ATOM   1066  CG  LEU A 116      15.772  80.250  13.713  1.00 49.41           C  
ATOM   1067  CD1 LEU A 116      15.100  81.600  13.685  1.00 49.61           C  
ATOM   1068  CD2 LEU A 116      16.981  80.254  14.615  1.00 48.99           C  
ATOM   1069  H   LEU A 116      12.962  77.581  14.606  1.00  0.00           H  
ATOM   1070  N   SER A 117      16.206  76.728  15.027  1.00 54.94           N  
ATOM   1071  CA  SER A 117      17.388  75.995  15.421  1.00 54.22           C  
ATOM   1072  C   SER A 117      17.432  74.677  14.692  1.00 53.87           C  
ATOM   1073  O   SER A 117      18.508  74.225  14.325  1.00 56.21           O  
ATOM   1074  CB  SER A 117      17.357  75.822  16.931  1.00 54.09           C  
ATOM   1075  OG  SER A 117      17.311  77.144  17.464  1.00 55.07           O  
ATOM   1076  H   SER A 117      15.617  77.001  15.768  1.00  0.00           H  
ATOM   1077  HG  SER A 117      17.869  77.230  18.246  1.00  0.00           H  
ATOM   1078  N   ALA A 118      16.308  74.061  14.378  1.00 53.29           N  
ATOM   1079  CA  ALA A 118      16.329  72.873  13.548  1.00 53.23           C  
ATOM   1080  C   ALA A 118      17.023  73.170  12.221  1.00 52.96           C  
ATOM   1081  O   ALA A 118      17.980  72.488  11.828  1.00 51.88           O  
ATOM   1082  CB  ALA A 118      14.917  72.426  13.268  1.00 53.81           C  
ATOM   1083  H   ALA A 118      15.476  74.370  14.793  1.00  0.00           H  
ATOM   1084  N   GLN A 119      16.585  74.275  11.593  1.00 53.25           N  
ATOM   1085  CA  GLN A 119      17.134  74.697  10.315  1.00 53.90           C  
ATOM   1086  C   GLN A 119      18.631  74.925  10.443  1.00 52.53           C  
ATOM   1087  O   GLN A 119      19.398  74.345   9.676  1.00 53.79           O  
ATOM   1088  CB  GLN A 119      16.411  75.983   9.815  1.00 55.69           C  
ATOM   1089  CG  GLN A 119      14.929  75.725   9.422  1.00 57.96           C  
ATOM   1090  CD  GLN A 119      14.143  76.755   8.593  1.00 58.35           C  
ATOM   1091  OE1 GLN A 119      14.509  77.909   8.372  1.00 58.29           O  
ATOM   1092  NE2 GLN A 119      13.002  76.340   8.068  1.00 58.12           N  
ATOM   1093  H   GLN A 119      15.830  74.771  11.981  1.00  0.00           H  
ATOM   1094 HE21 GLN A 119      12.736  75.416   8.242  1.00  0.00           H  
ATOM   1095 HE22 GLN A 119      12.459  76.971   7.541  1.00  0.00           H  
ATOM   1096  N   MET A 120      19.108  75.651  11.438  1.00 49.98           N  
ATOM   1097  CA  MET A 120      20.538  75.792  11.619  1.00 47.27           C  
ATOM   1098  C   MET A 120      21.233  74.436  11.837  1.00 46.79           C  
ATOM   1099  O   MET A 120      22.362  74.221  11.389  1.00 47.38           O  
ATOM   1100  CB  MET A 120      20.818  76.662  12.799  1.00 47.52           C  
ATOM   1101  CG  MET A 120      20.141  78.010  12.869  1.00 48.15           C  
ATOM   1102  SD  MET A 120      21.179  79.005  13.976  1.00 49.48           S  
ATOM   1103  CE  MET A 120      20.809  78.355  15.577  1.00 50.58           C  
ATOM   1104  H   MET A 120      18.449  76.088  12.019  1.00  0.00           H  
ATOM   1105  N   ALA A 121      20.619  73.456  12.497  1.00 45.00           N  
ATOM   1106  CA  ALA A 121      21.242  72.169  12.724  1.00 42.20           C  
ATOM   1107  C   ALA A 121      21.453  71.442  11.422  1.00 41.25           C  
ATOM   1108  O   ALA A 121      22.565  70.989  11.144  1.00 39.11           O  
ATOM   1109  CB  ALA A 121      20.360  71.349  13.624  1.00 42.63           C  
ATOM   1110  H   ALA A 121      19.778  73.649  12.950  1.00  0.00           H  
ATOM   1111  N   ARG A 122      20.433  71.390  10.571  1.00 42.57           N  
ATOM   1112  CA  ARG A 122      20.612  70.736   9.288  1.00 46.31           C  
ATOM   1113  C   ARG A 122      21.660  71.463   8.491  1.00 46.02           C  
ATOM   1114  O   ARG A 122      22.447  70.827   7.785  1.00 47.43           O  
ATOM   1115  CB  ARG A 122      19.327  70.670   8.454  1.00 50.63           C  
ATOM   1116  CG  ARG A 122      18.412  69.491   8.875  1.00 58.74           C  
ATOM   1117  CD  ARG A 122      18.802  68.011   8.527  1.00 64.31           C  
ATOM   1118  NE  ARG A 122      20.072  67.411   9.007  1.00 69.38           N  
ATOM   1119  CZ  ARG A 122      20.387  67.127  10.304  1.00 71.57           C  
ATOM   1120  NH1 ARG A 122      19.546  67.418  11.320  1.00 73.02           N  
ATOM   1121  NH2 ARG A 122      21.559  66.534  10.612  1.00 69.82           N  
ATOM   1122  H   ARG A 122      19.576  71.771  10.866  1.00  0.00           H  
ATOM   1123  HE  ARG A 122      20.746  67.208   8.325  1.00  0.00           H  
ATOM   1124 HH11 ARG A 122      18.659  67.837  11.128  1.00  0.00           H  
ATOM   1125 HH12 ARG A 122      19.814  67.209  12.259  1.00  0.00           H  
ATOM   1126 HH21 ARG A 122      22.165  66.243   9.877  1.00  0.00           H  
ATOM   1127 HH22 ARG A 122      21.772  66.325  11.565  1.00  0.00           H  
ATOM   1128  N   ARG A 123      21.732  72.785   8.657  1.00 44.05           N  
ATOM   1129  CA  ARG A 123      22.786  73.531   7.997  1.00 42.05           C  
ATOM   1130  C   ARG A 123      24.153  73.166   8.533  1.00 40.49           C  
ATOM   1131  O   ARG A 123      25.057  72.926   7.721  1.00 40.06           O  
ATOM   1132  CB  ARG A 123      22.537  75.034   8.152  1.00 42.15           C  
ATOM   1133  CG  ARG A 123      21.441  75.487   7.191  1.00 41.64           C  
ATOM   1134  CD  ARG A 123      20.778  76.777   7.622  1.00 38.75           C  
ATOM   1135  NE  ARG A 123      19.541  76.896   6.895  1.00 37.37           N  
ATOM   1136  CZ  ARG A 123      18.932  78.066   6.790  1.00 37.17           C  
ATOM   1137  NH1 ARG A 123      19.379  79.182   7.361  1.00 34.68           N  
ATOM   1138  NH2 ARG A 123      17.817  78.137   6.094  1.00 38.50           N  
ATOM   1139  H   ARG A 123      20.992  73.256   9.099  1.00  0.00           H  
ATOM   1140  HE  ARG A 123      19.140  76.105   6.490  1.00  0.00           H  
ATOM   1141 HH11 ARG A 123      20.213  79.198   7.912  1.00  0.00           H  
ATOM   1142 HH12 ARG A 123      18.840  80.011   7.229  1.00  0.00           H  
ATOM   1143 HH21 ARG A 123      17.430  77.330   5.651  1.00  0.00           H  
ATOM   1144 HH22 ARG A 123      17.373  79.028   6.022  1.00  0.00           H  
ATOM   1145  N   LEU A 124      24.342  73.009   9.845  1.00 37.24           N  
ATOM   1146  CA  LEU A 124      25.646  72.612  10.307  1.00 36.67           C  
ATOM   1147  C   LEU A 124      25.991  71.282   9.668  1.00 38.15           C  
ATOM   1148  O   LEU A 124      27.104  71.111   9.154  1.00 40.48           O  
ATOM   1149  CB  LEU A 124      25.681  72.462  11.795  1.00 34.74           C  
ATOM   1150  CG  LEU A 124      26.563  73.437  12.541  1.00 35.00           C  
ATOM   1151  CD1 LEU A 124      26.812  72.873  13.920  1.00 35.02           C  
ATOM   1152  CD2 LEU A 124      27.926  73.582  11.896  1.00 34.54           C  
ATOM   1153  H   LEU A 124      23.631  73.252  10.470  1.00  0.00           H  
ATOM   1154  N   GLN A 125      24.992  70.406   9.569  1.00 38.64           N  
ATOM   1155  CA  GLN A 125      25.172  69.108   8.965  1.00 38.19           C  
ATOM   1156  C   GLN A 125      25.592  69.200   7.508  1.00 34.62           C  
ATOM   1157  O   GLN A 125      26.622  68.625   7.161  1.00 33.65           O  
ATOM   1158  CB  GLN A 125      23.870  68.360   9.142  1.00 43.74           C  
ATOM   1159  CG  GLN A 125      24.053  66.896   8.869  1.00 51.75           C  
ATOM   1160  CD  GLN A 125      23.511  66.433   7.528  1.00 57.01           C  
ATOM   1161  OE1 GLN A 125      24.192  66.494   6.503  1.00 59.13           O  
ATOM   1162  NE2 GLN A 125      22.279  65.923   7.502  1.00 59.70           N  
ATOM   1163  H   GLN A 125      24.137  70.621  10.004  1.00  0.00           H  
ATOM   1164 HE21 GLN A 125      21.775  65.823   8.337  1.00  0.00           H  
ATOM   1165 HE22 GLN A 125      21.935  65.670   6.622  1.00  0.00           H  
ATOM   1166  N   VAL A 126      24.929  69.941   6.636  1.00 32.13           N  
ATOM   1167  CA  VAL A 126      25.407  69.983   5.269  1.00 32.53           C  
ATOM   1168  C   VAL A 126      26.695  70.779   5.131  1.00 31.96           C  
ATOM   1169  O   VAL A 126      27.521  70.413   4.288  1.00 34.17           O  
ATOM   1170  CB  VAL A 126      24.368  70.582   4.262  1.00 32.40           C  
ATOM   1171  CG1 VAL A 126      23.040  69.900   4.502  1.00 33.38           C  
ATOM   1172  CG2 VAL A 126      24.183  72.087   4.410  1.00 35.36           C  
ATOM   1173  H   VAL A 126      24.096  70.361   6.920  1.00  0.00           H  
ATOM   1174  N   THR A 127      26.984  71.846   5.886  1.00 30.54           N  
ATOM   1175  CA  THR A 127      28.210  72.580   5.638  1.00 28.93           C  
ATOM   1176  C   THR A 127      29.449  71.806   6.077  1.00 27.87           C  
ATOM   1177  O   THR A 127      30.498  71.968   5.454  1.00 26.16           O  
ATOM   1178  CB  THR A 127      28.112  73.936   6.336  1.00 29.06           C  
ATOM   1179  OG1 THR A 127      26.831  74.496   6.063  1.00 29.19           O  
ATOM   1180  CG2 THR A 127      29.200  74.869   5.819  1.00 29.62           C  
ATOM   1181  H   THR A 127      26.347  72.187   6.549  1.00  0.00           H  
ATOM   1182  HG1 THR A 127      26.716  74.506   5.110  1.00  0.00           H  
ATOM   1183  N   SER A 128      29.355  70.932   7.089  1.00 28.20           N  
ATOM   1184  CA  SER A 128      30.456  70.061   7.462  1.00 29.90           C  
ATOM   1185  C   SER A 128      30.732  69.112   6.310  1.00 31.78           C  
ATOM   1186  O   SER A 128      31.897  68.857   5.957  1.00 32.95           O  
ATOM   1187  CB  SER A 128      30.121  69.235   8.696  1.00 29.81           C  
ATOM   1188  OG  SER A 128      29.848  70.119   9.766  1.00 30.53           O  
ATOM   1189  H   SER A 128      28.562  70.942   7.664  1.00  0.00           H  
ATOM   1190  HG  SER A 128      28.986  70.520   9.577  1.00  0.00           H  
ATOM   1191  N   GLU A 129      29.665  68.619   5.665  1.00 32.37           N  
ATOM   1192  CA  GLU A 129      29.854  67.772   4.502  1.00 34.12           C  
ATOM   1193  C   GLU A 129      30.571  68.496   3.366  1.00 33.17           C  
ATOM   1194  O   GLU A 129      31.507  67.948   2.796  1.00 32.03           O  
ATOM   1195  CB  GLU A 129      28.510  67.289   4.059  1.00 36.98           C  
ATOM   1196  CG  GLU A 129      28.596  66.389   2.848  1.00 43.36           C  
ATOM   1197  CD  GLU A 129      27.216  65.896   2.459  1.00 48.25           C  
ATOM   1198  OE1 GLU A 129      26.666  65.116   3.241  1.00 50.32           O  
ATOM   1199  OE2 GLU A 129      26.693  66.285   1.401  1.00 50.85           O  
ATOM   1200  H   GLU A 129      28.756  68.725   6.028  1.00  0.00           H  
ATOM   1201  N   LYS A 130      30.196  69.726   3.008  1.00 33.26           N  
ATOM   1202  CA  LYS A 130      30.903  70.486   1.991  1.00 32.32           C  
ATOM   1203  C   LYS A 130      32.355  70.671   2.395  1.00 30.81           C  
ATOM   1204  O   LYS A 130      33.220  70.561   1.526  1.00 30.93           O  
ATOM   1205  CB  LYS A 130      30.225  71.840   1.792  1.00 35.29           C  
ATOM   1206  CG  LYS A 130      30.733  72.697   0.613  1.00 38.56           C  
ATOM   1207  CD  LYS A 130      29.757  73.833   0.246  1.00 41.57           C  
ATOM   1208  CE  LYS A 130      29.307  73.748  -1.228  1.00 42.01           C  
ATOM   1209  NZ  LYS A 130      30.212  74.509  -2.058  1.00 42.22           N  
ATOM   1210  H   LYS A 130      29.358  70.063   3.384  1.00  0.00           H  
ATOM   1211  HZ1 LYS A 130      31.169  74.443  -1.657  1.00  0.00           H  
ATOM   1212  HZ2 LYS A 130      29.873  75.492  -2.067  1.00  0.00           H  
ATOM   1213  HZ3 LYS A 130      30.216  74.137  -3.025  1.00  0.00           H  
ATOM   1214  N   VAL A 131      32.699  70.918   3.649  1.00 29.45           N  
ATOM   1215  CA  VAL A 131      34.097  70.933   4.023  1.00 29.60           C  
ATOM   1216  C   VAL A 131      34.710  69.597   3.649  1.00 30.68           C  
ATOM   1217  O   VAL A 131      35.724  69.574   2.961  1.00 31.46           O  
ATOM   1218  CB  VAL A 131      34.233  71.183   5.526  1.00 29.88           C  
ATOM   1219  CG1 VAL A 131      35.657  70.888   6.012  1.00 29.94           C  
ATOM   1220  CG2 VAL A 131      33.866  72.633   5.796  1.00 27.45           C  
ATOM   1221  H   VAL A 131      32.010  71.196   4.293  1.00  0.00           H  
ATOM   1222  N   GLY A 132      34.079  68.488   4.015  1.00 31.62           N  
ATOM   1223  CA  GLY A 132      34.563  67.157   3.690  1.00 34.57           C  
ATOM   1224  C   GLY A 132      34.860  66.916   2.218  1.00 36.08           C  
ATOM   1225  O   GLY A 132      35.949  66.435   1.914  1.00 35.73           O  
ATOM   1226  H   GLY A 132      33.294  68.568   4.594  1.00  0.00           H  
ATOM   1227  N   ASN A 133      33.955  67.241   1.294  1.00 38.18           N  
ATOM   1228  CA  ASN A 133      34.181  67.094  -0.147  1.00 41.09           C  
ATOM   1229  C   ASN A 133      35.365  67.901  -0.633  1.00 42.48           C  
ATOM   1230  O   ASN A 133      36.226  67.353  -1.322  1.00 43.18           O  
ATOM   1231  CB  ASN A 133      33.043  67.559  -1.053  1.00 43.23           C  
ATOM   1232  CG  ASN A 133      31.702  66.894  -0.801  1.00 46.31           C  
ATOM   1233  OD1 ASN A 133      31.583  65.892  -0.090  1.00 47.04           O  
ATOM   1234  ND2 ASN A 133      30.635  67.477  -1.346  1.00 47.55           N  
ATOM   1235  H   ASN A 133      33.083  67.496   1.654  1.00  0.00           H  
ATOM   1236 HD21 ASN A 133      30.771  68.285  -1.880  1.00  0.00           H  
ATOM   1237 HD22 ASN A 133      29.774  67.050  -1.160  1.00  0.00           H  
ATOM   1238  N   LEU A 134      35.466  69.177  -0.259  1.00 43.20           N  
ATOM   1239  CA  LEU A 134      36.604  69.992  -0.658  1.00 44.34           C  
ATOM   1240  C   LEU A 134      37.932  69.354  -0.225  1.00 44.50           C  
ATOM   1241  O   LEU A 134      38.902  69.252  -0.975  1.00 46.77           O  
ATOM   1242  CB  LEU A 134      36.501  71.384  -0.032  1.00 44.83           C  
ATOM   1243  CG  LEU A 134      35.308  72.288  -0.312  1.00 45.23           C  
ATOM   1244  CD1 LEU A 134      35.519  73.644   0.345  1.00 44.85           C  
ATOM   1245  CD2 LEU A 134      35.153  72.468  -1.802  1.00 45.47           C  
ATOM   1246  H   LEU A 134      34.786  69.558   0.337  1.00  0.00           H  
ATOM   1247  N   ALA A 135      37.999  68.910   1.018  1.00 43.20           N  
ATOM   1248  CA  ALA A 135      39.201  68.311   1.542  1.00 40.94           C  
ATOM   1249  C   ALA A 135      39.512  66.957   0.958  1.00 39.89           C  
ATOM   1250  O   ALA A 135      40.664  66.632   0.709  1.00 39.67           O  
ATOM   1251  CB  ALA A 135      39.084  68.142   3.041  1.00 41.48           C  
ATOM   1252  H   ALA A 135      37.228  69.050   1.607  1.00  0.00           H  
ATOM   1253  N   PHE A 136      38.500  66.145   0.771  1.00 40.17           N  
ATOM   1254  CA  PHE A 136      38.720  64.777   0.387  1.00 41.64           C  
ATOM   1255  C   PHE A 136      38.576  64.360  -1.059  1.00 43.66           C  
ATOM   1256  O   PHE A 136      39.223  63.399  -1.501  1.00 45.03           O  
ATOM   1257  CB  PHE A 136      37.797  63.885   1.174  1.00 39.62           C  
ATOM   1258  CG  PHE A 136      37.918  63.884   2.675  1.00 38.10           C  
ATOM   1259  CD1 PHE A 136      39.132  64.078   3.287  1.00 37.73           C  
ATOM   1260  CD2 PHE A 136      36.783  63.642   3.418  1.00 38.63           C  
ATOM   1261  CE1 PHE A 136      39.210  64.022   4.661  1.00 38.17           C  
ATOM   1262  CE2 PHE A 136      36.868  63.588   4.795  1.00 39.09           C  
ATOM   1263  CZ  PHE A 136      38.085  63.777   5.414  1.00 38.76           C  
ATOM   1264  H   PHE A 136      37.596  66.426   0.992  1.00  0.00           H  
ATOM   1265  N   LEU A 137      37.672  65.005  -1.783  1.00 45.50           N  
ATOM   1266  CA  LEU A 137      37.277  64.538  -3.095  1.00 47.64           C  
ATOM   1267  C   LEU A 137      37.782  65.395  -4.233  1.00 49.46           C  
ATOM   1268  O   LEU A 137      37.609  66.613  -4.197  1.00 51.71           O  
ATOM   1269  CB  LEU A 137      35.762  64.477  -3.187  1.00 46.99           C  
ATOM   1270  CG  LEU A 137      34.961  63.414  -2.462  1.00 46.83           C  
ATOM   1271  CD1 LEU A 137      34.795  63.700  -0.990  1.00 47.84           C  
ATOM   1272  CD2 LEU A 137      33.571  63.436  -3.044  1.00 48.37           C  
ATOM   1273  H   LEU A 137      37.346  65.882  -1.507  1.00  0.00           H  
ATOM   1274  N   ASP A 138      38.370  64.808  -5.282  1.00 49.25           N  
ATOM   1275  CA  ASP A 138      38.805  65.651  -6.371  1.00 48.96           C  
ATOM   1276  C   ASP A 138      37.591  66.144  -7.178  1.00 47.67           C  
ATOM   1277  O   ASP A 138      36.495  65.574  -7.100  1.00 45.41           O  
ATOM   1278  CB  ASP A 138      39.830  64.855  -7.213  1.00 52.44           C  
ATOM   1279  CG  ASP A 138      39.415  63.743  -8.173  1.00 55.53           C  
ATOM   1280  OD1 ASP A 138      38.240  63.381  -8.235  1.00 56.33           O  
ATOM   1281  OD2 ASP A 138      40.302  63.248  -8.881  1.00 56.77           O  
ATOM   1282  H   ASP A 138      38.502  63.842  -5.292  1.00  0.00           H  
ATOM   1283  N   VAL A 139      37.778  67.200  -7.974  1.00 45.66           N  
ATOM   1284  CA  VAL A 139      36.738  67.869  -8.738  1.00 42.32           C  
ATOM   1285  C   VAL A 139      35.803  66.922  -9.415  1.00 41.14           C  
ATOM   1286  O   VAL A 139      34.610  67.125  -9.291  1.00 39.10           O  
ATOM   1287  CB  VAL A 139      37.340  68.807  -9.809  1.00 42.26           C  
ATOM   1288  CG1 VAL A 139      36.285  69.492 -10.669  1.00 41.40           C  
ATOM   1289  CG2 VAL A 139      38.068  69.925  -9.096  1.00 43.50           C  
ATOM   1290  H   VAL A 139      38.688  67.561  -8.004  1.00  0.00           H  
ATOM   1291  N   THR A 140      36.274  65.885 -10.077  1.00 42.94           N  
ATOM   1292  CA  THR A 140      35.346  64.968 -10.700  1.00 45.69           C  
ATOM   1293  C   THR A 140      34.348  64.450  -9.675  1.00 46.04           C  
ATOM   1294  O   THR A 140      33.143  64.548  -9.888  1.00 48.30           O  
ATOM   1295  CB  THR A 140      36.101  63.808 -11.316  1.00 45.92           C  
ATOM   1296  OG1 THR A 140      37.170  64.371 -12.086  1.00 46.33           O  
ATOM   1297  CG2 THR A 140      35.151  62.896 -12.104  1.00 44.04           C  
ATOM   1298  H   THR A 140      37.233  65.773 -10.228  1.00  0.00           H  
ATOM   1299  HG1 THR A 140      36.868  64.618 -12.966  1.00  0.00           H  
ATOM   1300  N   GLY A 141      34.835  64.066  -8.510  1.00 44.80           N  
ATOM   1301  CA  GLY A 141      33.957  63.553  -7.481  1.00 45.72           C  
ATOM   1302  C   GLY A 141      33.041  64.642  -6.964  1.00 45.76           C  
ATOM   1303  O   GLY A 141      31.835  64.423  -6.822  1.00 45.24           O  
ATOM   1304  H   GLY A 141      35.785  64.178  -8.320  1.00  0.00           H  
ATOM   1305  N   ARG A 142      33.616  65.824  -6.731  1.00 46.46           N  
ATOM   1306  CA  ARG A 142      32.836  66.943  -6.242  1.00 46.35           C  
ATOM   1307  C   ARG A 142      31.734  67.279  -7.238  1.00 46.91           C  
ATOM   1308  O   ARG A 142      30.580  67.241  -6.814  1.00 48.12           O  
ATOM   1309  CB  ARG A 142      33.722  68.153  -6.012  1.00 45.17           C  
ATOM   1310  CG  ARG A 142      34.290  68.220  -4.606  1.00 45.40           C  
ATOM   1311  CD  ARG A 142      35.073  69.520  -4.441  1.00 45.77           C  
ATOM   1312  NE  ARG A 142      36.473  69.352  -4.794  1.00 45.50           N  
ATOM   1313  CZ  ARG A 142      37.288  70.317  -5.263  1.00 45.93           C  
ATOM   1314  NH1 ARG A 142      36.943  71.588  -5.488  1.00 44.16           N  
ATOM   1315  NH2 ARG A 142      38.546  69.969  -5.508  1.00 46.95           N  
ATOM   1316  H   ARG A 142      34.582  65.891  -6.868  1.00  0.00           H  
ATOM   1317  HE  ARG A 142      36.866  68.470  -4.645  1.00  0.00           H  
ATOM   1318 HH11 ARG A 142      36.012  71.896  -5.319  1.00  0.00           H  
ATOM   1319 HH12 ARG A 142      37.609  72.231  -5.869  1.00  0.00           H  
ATOM   1320 HH21 ARG A 142      38.812  69.025  -5.325  1.00  0.00           H  
ATOM   1321 HH22 ARG A 142      39.208  70.627  -5.863  1.00  0.00           H  
ATOM   1322  N   ILE A 143      31.997  67.485  -8.543  1.00 46.73           N  
ATOM   1323  CA  ILE A 143      30.982  67.783  -9.550  1.00 46.25           C  
ATOM   1324  C   ILE A 143      29.995  66.615  -9.607  1.00 48.85           C  
ATOM   1325  O   ILE A 143      28.786  66.836  -9.775  1.00 49.96           O  
ATOM   1326  CB  ILE A 143      31.610  68.016 -10.965  1.00 42.76           C  
ATOM   1327  CG1 ILE A 143      32.501  69.220 -10.949  1.00 41.51           C  
ATOM   1328  CG2 ILE A 143      30.533  68.325 -11.992  1.00 41.17           C  
ATOM   1329  CD1 ILE A 143      33.034  69.649 -12.323  1.00 41.78           C  
ATOM   1330  H   ILE A 143      32.910  67.364  -8.832  1.00  0.00           H  
ATOM   1331  N   ALA A 144      30.463  65.374  -9.424  1.00 49.92           N  
ATOM   1332  CA  ALA A 144      29.592  64.210  -9.401  1.00 52.09           C  
ATOM   1333  C   ALA A 144      28.503  64.341  -8.329  1.00 54.48           C  
ATOM   1334  O   ALA A 144      27.295  64.422  -8.634  1.00 55.73           O  
ATOM   1335  CB  ALA A 144      30.428  62.970  -9.134  1.00 50.77           C  
ATOM   1336  H   ALA A 144      31.428  65.228  -9.383  1.00  0.00           H  
ATOM   1337  N   GLN A 145      28.955  64.461  -7.070  1.00 55.65           N  
ATOM   1338  CA  GLN A 145      28.080  64.654  -5.928  1.00 56.66           C  
ATOM   1339  C   GLN A 145      27.167  65.844  -6.178  1.00 56.87           C  
ATOM   1340  O   GLN A 145      25.988  65.754  -5.838  1.00 58.02           O  
ATOM   1341  CB  GLN A 145      28.910  64.892  -4.675  1.00 58.27           C  
ATOM   1342  CG  GLN A 145      29.185  63.604  -3.907  1.00 61.59           C  
ATOM   1343  CD  GLN A 145      28.231  63.326  -2.736  1.00 63.20           C  
ATOM   1344  OE1 GLN A 145      28.647  62.798  -1.711  1.00 63.75           O  
ATOM   1345  NE2 GLN A 145      26.939  63.617  -2.715  1.00 64.40           N  
ATOM   1346  H   GLN A 145      29.926  64.482  -6.943  1.00  0.00           H  
ATOM   1347 HE21 GLN A 145      26.494  64.031  -3.483  1.00  0.00           H  
ATOM   1348 HE22 GLN A 145      26.474  63.393  -1.888  1.00  0.00           H  
ATOM   1349  N   THR A 146      27.648  66.936  -6.782  1.00 56.45           N  
ATOM   1350  CA  THR A 146      26.822  68.067  -7.164  1.00 55.24           C  
ATOM   1351  C   THR A 146      25.739  67.676  -8.137  1.00 55.82           C  
ATOM   1352  O   THR A 146      24.570  67.886  -7.800  1.00 56.09           O  
ATOM   1353  CB  THR A 146      27.723  69.161  -7.754  1.00 55.02           C  
ATOM   1354  OG1 THR A 146      28.377  69.655  -6.597  1.00 55.62           O  
ATOM   1355  CG2 THR A 146      27.055  70.289  -8.534  1.00 54.08           C  
ATOM   1356  H   THR A 146      28.621  67.028  -6.875  1.00  0.00           H  
ATOM   1357  HG1 THR A 146      27.879  70.380  -6.211  1.00  0.00           H  
ATOM   1358  N   LEU A 147      26.031  67.062  -9.278  1.00 55.92           N  
ATOM   1359  CA  LEU A 147      24.967  66.793 -10.222  1.00 59.41           C  
ATOM   1360  C   LEU A 147      23.855  65.950  -9.632  1.00 61.51           C  
ATOM   1361  O   LEU A 147      22.661  66.255  -9.733  1.00 60.99           O  
ATOM   1362  CB  LEU A 147      25.586  66.158 -11.453  1.00 59.21           C  
ATOM   1363  CG  LEU A 147      26.474  67.105 -12.275  1.00 59.68           C  
ATOM   1364  CD1 LEU A 147      26.274  66.781 -13.722  1.00 58.86           C  
ATOM   1365  CD2 LEU A 147      26.057  68.563 -12.175  1.00 59.85           C  
ATOM   1366  H   LEU A 147      26.960  66.824  -9.472  1.00  0.00           H  
ATOM   1367  N   LEU A 148      24.338  65.035  -8.812  1.00 65.28           N  
ATOM   1368  CA  LEU A 148      23.491  64.200  -8.001  1.00 69.09           C  
ATOM   1369  C   LEU A 148      22.548  64.991  -7.086  1.00 70.86           C  
ATOM   1370  O   LEU A 148      21.328  64.870  -7.148  1.00 71.35           O  
ATOM   1371  CB  LEU A 148      24.366  63.320  -7.164  1.00 70.61           C  
ATOM   1372  CG  LEU A 148      23.723  62.051  -6.709  1.00 72.26           C  
ATOM   1373  CD1 LEU A 148      23.965  61.039  -7.827  1.00 72.36           C  
ATOM   1374  CD2 LEU A 148      24.256  61.609  -5.342  1.00 73.54           C  
ATOM   1375  H   LEU A 148      25.308  64.901  -8.777  1.00  0.00           H  
ATOM   1376  N   ASN A 149      23.081  65.830  -6.220  1.00 74.02           N  
ATOM   1377  CA  ASN A 149      22.265  66.586  -5.289  1.00 78.53           C  
ATOM   1378  C   ASN A 149      21.334  67.579  -5.947  1.00 79.55           C  
ATOM   1379  O   ASN A 149      20.205  67.796  -5.486  1.00 81.28           O  
ATOM   1380  CB  ASN A 149      23.122  67.367  -4.329  1.00 82.10           C  
ATOM   1381  CG  ASN A 149      24.014  66.501  -3.464  1.00 85.44           C  
ATOM   1382  OD1 ASN A 149      23.869  65.279  -3.334  1.00 86.72           O  
ATOM   1383  ND2 ASN A 149      25.019  67.139  -2.870  1.00 87.58           N  
ATOM   1384  H   ASN A 149      24.054  65.860  -6.139  1.00  0.00           H  
ATOM   1385 HD21 ASN A 149      25.128  68.091  -3.067  1.00  0.00           H  
ATOM   1386 HD22 ASN A 149      25.582  66.628  -2.257  1.00  0.00           H  
ATOM   1387  N   LEU A 150      21.779  68.233  -7.018  1.00 78.75           N  
ATOM   1388  CA  LEU A 150      20.933  69.176  -7.714  1.00 77.72           C  
ATOM   1389  C   LEU A 150      19.734  68.413  -8.218  1.00 79.07           C  
ATOM   1390  O   LEU A 150      18.624  68.891  -8.032  1.00 78.98           O  
ATOM   1391  CB  LEU A 150      21.649  69.786  -8.874  1.00 76.80           C  
ATOM   1392  CG  LEU A 150      22.870  70.596  -8.565  1.00 75.84           C  
ATOM   1393  CD1 LEU A 150      23.501  70.993  -9.884  1.00 75.29           C  
ATOM   1394  CD2 LEU A 150      22.511  71.772  -7.673  1.00 75.47           C  
ATOM   1395  H   LEU A 150      22.694  68.065  -7.318  1.00  0.00           H  
ATOM   1396  N   ALA A 151      19.910  67.190  -8.734  1.00 80.92           N  
ATOM   1397  CA  ALA A 151      18.810  66.327  -9.168  1.00 82.48           C  
ATOM   1398  C   ALA A 151      17.851  65.801  -8.088  1.00 84.12           C  
ATOM   1399  O   ALA A 151      17.047  64.888  -8.307  1.00 83.75           O  
ATOM   1400  CB  ALA A 151      19.409  65.143  -9.904  1.00 82.00           C  
ATOM   1401  H   ALA A 151      20.824  66.870  -8.901  1.00  0.00           H  
ATOM   1402  N   LYS A 152      17.924  66.381  -6.897  1.00 86.83           N  
ATOM   1403  CA  LYS A 152      17.053  66.082  -5.786  1.00 89.56           C  
ATOM   1404  C   LYS A 152      16.532  67.433  -5.264  1.00 89.98           C  
ATOM   1405  O   LYS A 152      15.576  67.488  -4.489  1.00 90.74           O  
ATOM   1406  CB  LYS A 152      17.885  65.318  -4.738  1.00 91.68           C  
ATOM   1407  CG  LYS A 152      17.080  64.546  -3.688  1.00 94.47           C  
ATOM   1408  CD  LYS A 152      16.233  63.416  -4.324  1.00 96.04           C  
ATOM   1409  CE  LYS A 152      15.211  62.736  -3.377  1.00 95.79           C  
ATOM   1410  NZ  LYS A 152      15.831  62.052  -2.254  1.00 95.11           N  
ATOM   1411  H   LYS A 152      18.640  67.017  -6.716  1.00  0.00           H  
ATOM   1412  HZ1 LYS A 152      16.415  62.728  -1.722  1.00  0.00           H  
ATOM   1413  HZ2 LYS A 152      16.435  61.287  -2.614  1.00  0.00           H  
ATOM   1414  HZ3 LYS A 152      15.104  61.655  -1.625  1.00  0.00           H  
ATOM   1415  N   GLN A 153      17.102  68.580  -5.649  1.00 90.35           N  
ATOM   1416  CA  GLN A 153      16.644  69.882  -5.205  1.00 90.90           C  
ATOM   1417  C   GLN A 153      15.309  70.218  -5.863  1.00 91.14           C  
ATOM   1418  O   GLN A 153      15.113  69.996  -7.062  1.00 90.83           O  
ATOM   1419  CB  GLN A 153      17.692  70.933  -5.561  1.00 91.79           C  
ATOM   1420  CG  GLN A 153      18.488  71.462  -4.352  1.00 93.68           C  
ATOM   1421  CD  GLN A 153      17.917  72.709  -3.661  1.00 94.33           C  
ATOM   1422  OE1 GLN A 153      17.440  73.652  -4.304  1.00 94.78           O  
ATOM   1423  NE2 GLN A 153      17.966  72.807  -2.333  1.00 93.53           N  
ATOM   1424  H   GLN A 153      17.781  68.562  -6.346  1.00  0.00           H  
ATOM   1425 HE21 GLN A 153      18.428  72.138  -1.792  1.00  0.00           H  
ATOM   1426 HE22 GLN A 153      17.470  73.574  -1.959  1.00  0.00           H  
ATOM   1427  N   PRO A 154      14.326  70.734  -5.130  1.00 92.06           N  
ATOM   1428  CA  PRO A 154      13.013  71.075  -5.639  1.00 93.66           C  
ATOM   1429  C   PRO A 154      13.006  72.095  -6.767  1.00 95.85           C  
ATOM   1430  O   PRO A 154      12.900  73.297  -6.532  1.00 96.55           O  
ATOM   1431  CB  PRO A 154      12.263  71.535  -4.405  1.00 93.13           C  
ATOM   1432  CG  PRO A 154      13.351  72.081  -3.517  1.00 92.28           C  
ATOM   1433  CD  PRO A 154      14.389  70.990  -3.698  1.00 92.50           C  
ATOM   1434  N   ASP A 155      13.160  71.582  -7.982  1.00 97.82           N  
ATOM   1435  CA  ASP A 155      13.079  72.317  -9.243  1.00100.33           C  
ATOM   1436  C   ASP A 155      13.532  71.371 -10.322  1.00100.40           C  
ATOM   1437  O   ASP A 155      13.348  71.668 -11.500  1.00 99.69           O  
ATOM   1438  CB  ASP A 155      13.980  73.590  -9.363  1.00102.74           C  
ATOM   1439  CG  ASP A 155      15.487  73.453  -9.582  1.00104.93           C  
ATOM   1440  OD1 ASP A 155      15.921  73.337 -10.739  1.00105.67           O  
ATOM   1441  OD2 ASP A 155      16.222  73.494  -8.590  1.00106.40           O  
ATOM   1442  H   ASP A 155      13.333  70.617  -8.024  1.00  0.00           H  
ATOM   1443  N   ALA A 156      14.200  70.289  -9.910  1.00101.22           N  
ATOM   1444  CA  ALA A 156      14.578  69.240 -10.825  1.00102.73           C  
ATOM   1445  C   ALA A 156      13.281  68.759 -11.440  1.00103.63           C  
ATOM   1446  O   ALA A 156      12.293  68.452 -10.762  1.00103.00           O  
ATOM   1447  CB  ALA A 156      15.224  68.079 -10.099  1.00103.30           C  
ATOM   1448  H   ALA A 156      14.511  70.202  -8.987  1.00  0.00           H  
ATOM   1449  N   MET A 157      13.320  68.895 -12.753  1.00105.99           N  
ATOM   1450  CA  MET A 157      12.237  68.494 -13.621  1.00108.19           C  
ATOM   1451  C   MET A 157      12.613  67.057 -13.942  1.00109.11           C  
ATOM   1452  O   MET A 157      13.777  66.649 -13.855  1.00108.84           O  
ATOM   1453  CB  MET A 157      12.210  69.312 -14.920  1.00108.84           C  
ATOM   1454  CG  MET A 157      12.215  70.842 -14.762  1.00109.65           C  
ATOM   1455  SD  MET A 157      13.777  71.584 -14.192  1.00110.37           S  
ATOM   1456  CE  MET A 157      14.576  71.877 -15.745  1.00110.25           C  
ATOM   1457  H   MET A 157      14.183  69.121 -13.154  1.00  0.00           H  
ATOM   1458  N   THR A 158      11.654  66.218 -14.268  1.00110.62           N  
ATOM   1459  CA  THR A 158      11.989  64.853 -14.616  1.00112.29           C  
ATOM   1460  C   THR A 158      12.165  64.853 -16.132  1.00113.09           C  
ATOM   1461  O   THR A 158      11.579  65.694 -16.831  1.00113.56           O  
ATOM   1462  CB  THR A 158      10.838  63.955 -14.151  1.00112.78           C  
ATOM   1463  OG1 THR A 158      10.342  64.469 -12.906  1.00112.57           O  
ATOM   1464  CG2 THR A 158      11.314  62.510 -14.018  1.00113.27           C  
ATOM   1465  H   THR A 158      10.715  66.486 -14.292  1.00  0.00           H  
ATOM   1466  HG1 THR A 158      11.078  64.501 -12.287  1.00  0.00           H  
ATOM   1467  N   HIS A 159      13.001  63.983 -16.682  1.00113.45           N  
ATOM   1468  CA  HIS A 159      13.160  63.931 -18.123  1.00114.49           C  
ATOM   1469  C   HIS A 159      12.997  62.476 -18.483  1.00114.38           C  
ATOM   1470  O   HIS A 159      13.980  61.739 -18.488  1.00114.70           O  
ATOM   1471  CB  HIS A 159      14.562  64.444 -18.543  1.00115.35           C  
ATOM   1472  CG  HIS A 159      15.097  63.990 -19.911  1.00116.05           C  
ATOM   1473  ND1 HIS A 159      15.667  62.813 -20.191  1.00116.03           N  
ATOM   1474  CD2 HIS A 159      15.094  64.730 -21.072  1.00116.35           C  
ATOM   1475  CE1 HIS A 159      16.004  62.806 -21.457  1.00115.90           C  
ATOM   1476  NE2 HIS A 159      15.658  63.965 -21.975  1.00116.47           N  
ATOM   1477  H   HIS A 159      13.504  63.348 -16.122  1.00  0.00           H  
ATOM   1478  HD1 HIS A 159      15.724  62.042 -19.566  1.00  0.00           H  
ATOM   1479  HE2 HIS A 159      15.824  64.250 -22.901  1.00  0.00           H  
ATOM   1480  N   PRO A 160      11.845  62.038 -18.971  1.00114.59           N  
ATOM   1481  CA  PRO A 160      11.265  60.722 -18.698  1.00115.04           C  
ATOM   1482  C   PRO A 160      12.047  59.879 -17.699  1.00115.48           C  
ATOM   1483  O   PRO A 160      11.730  59.857 -16.503  1.00115.40           O  
ATOM   1484  CB  PRO A 160      11.148  60.080 -20.086  1.00114.94           C  
ATOM   1485  CG  PRO A 160      11.736  61.090 -21.046  1.00114.79           C  
ATOM   1486  CD  PRO A 160      11.434  62.394 -20.318  1.00114.90           C  
ATOM   1487  N   ASP A 161      13.136  59.286 -18.198  1.00115.75           N  
ATOM   1488  CA  ASP A 161      14.011  58.504 -17.360  1.00115.75           C  
ATOM   1489  C   ASP A 161      15.313  59.283 -17.257  1.00114.17           C  
ATOM   1490  O   ASP A 161      16.032  59.573 -18.226  1.00113.04           O  
ATOM   1491  CB  ASP A 161      14.203  57.122 -17.984  1.00117.39           C  
ATOM   1492  CG  ASP A 161      12.939  56.261 -17.848  1.00118.51           C  
ATOM   1493  OD1 ASP A 161      12.538  55.926 -16.720  1.00118.33           O  
ATOM   1494  OD2 ASP A 161      12.356  55.934 -18.887  1.00119.06           O  
ATOM   1495  H   ASP A 161      13.477  59.531 -19.081  1.00  0.00           H  
ATOM   1496  N   GLY A 162      15.395  59.758 -16.015  1.00112.51           N  
ATOM   1497  CA  GLY A 162      16.478  60.574 -15.512  1.00110.03           C  
ATOM   1498  C   GLY A 162      15.917  61.889 -14.959  1.00107.83           C  
ATOM   1499  O   GLY A 162      14.734  62.247 -15.122  1.00108.18           O  
ATOM   1500  H   GLY A 162      14.614  59.669 -15.430  1.00  0.00           H  
ATOM   1501  N   MET A 163      16.778  62.637 -14.286  1.00104.18           N  
ATOM   1502  CA  MET A 163      16.363  63.917 -13.775  1.00100.54           C  
ATOM   1503  C   MET A 163      16.890  64.928 -14.742  1.00 98.43           C  
ATOM   1504  O   MET A 163      17.824  64.669 -15.502  1.00 96.90           O  
ATOM   1505  CB  MET A 163      16.942  64.172 -12.411  1.00101.11           C  
ATOM   1506  CG  MET A 163      16.253  63.240 -11.434  1.00102.28           C  
ATOM   1507  SD  MET A 163      14.454  63.296 -11.665  1.00103.45           S  
ATOM   1508  CE  MET A 163      13.930  64.007 -10.127  1.00102.62           C  
ATOM   1509  H   MET A 163      17.732  62.410 -14.300  1.00  0.00           H  
ATOM   1510  N   GLN A 164      16.273  66.082 -14.706  1.00 96.65           N  
ATOM   1511  CA  GLN A 164      16.633  67.173 -15.574  1.00 95.91           C  
ATOM   1512  C   GLN A 164      16.808  68.368 -14.652  1.00 92.36           C  
ATOM   1513  O   GLN A 164      15.929  68.696 -13.852  1.00 91.58           O  
ATOM   1514  CB  GLN A 164      15.500  67.385 -16.586  1.00 98.99           C  
ATOM   1515  CG  GLN A 164      15.696  68.446 -17.675  1.00101.55           C  
ATOM   1516  CD  GLN A 164      14.665  68.382 -18.801  1.00102.71           C  
ATOM   1517  OE1 GLN A 164      14.731  67.526 -19.694  1.00103.29           O  
ATOM   1518  NE2 GLN A 164      13.687  69.280 -18.828  1.00103.14           N  
ATOM   1519  H   GLN A 164      15.544  66.249 -14.082  1.00  0.00           H  
ATOM   1520 HE21 GLN A 164      13.637  69.950 -18.122  1.00  0.00           H  
ATOM   1521 HE22 GLN A 164      13.055  69.205 -19.572  1.00  0.00           H  
ATOM   1522  N   ILE A 165      17.964  68.997 -14.711  1.00 88.17           N  
ATOM   1523  CA  ILE A 165      18.248  70.201 -13.966  1.00 84.45           C  
ATOM   1524  C   ILE A 165      18.808  71.152 -15.004  1.00 83.28           C  
ATOM   1525  O   ILE A 165      19.382  70.743 -16.011  1.00 82.10           O  
ATOM   1526  CB  ILE A 165      19.296  69.989 -12.866  1.00 83.35           C  
ATOM   1527  CG1 ILE A 165      20.374  69.017 -13.324  1.00 82.56           C  
ATOM   1528  CG2 ILE A 165      18.549  69.595 -11.608  1.00 81.67           C  
ATOM   1529  CD1 ILE A 165      21.633  69.017 -12.461  1.00 83.07           C  
ATOM   1530  H   ILE A 165      18.651  68.673 -15.327  1.00  0.00           H  
ATOM   1531  N   LYS A 166      18.586  72.443 -14.809  1.00 81.51           N  
ATOM   1532  CA  LYS A 166      19.089  73.463 -15.706  1.00 79.03           C  
ATOM   1533  C   LYS A 166      20.060  74.162 -14.773  1.00 76.83           C  
ATOM   1534  O   LYS A 166      19.657  74.585 -13.683  1.00 75.13           O  
ATOM   1535  CB  LYS A 166      17.947  74.379 -16.108  1.00 80.67           C  
ATOM   1536  CG  LYS A 166      18.246  75.475 -17.117  1.00 82.50           C  
ATOM   1537  CD  LYS A 166      17.258  76.652 -16.943  1.00 84.67           C  
ATOM   1538  CE  LYS A 166      15.741  76.363 -17.073  1.00 85.98           C  
ATOM   1539  NZ  LYS A 166      15.304  76.111 -18.441  1.00 87.67           N  
ATOM   1540  H   LYS A 166      18.138  72.739 -13.989  1.00  0.00           H  
ATOM   1541  HZ1 LYS A 166      15.810  75.284 -18.822  1.00  0.00           H  
ATOM   1542  HZ2 LYS A 166      15.509  76.942 -19.030  1.00  0.00           H  
ATOM   1543  HZ3 LYS A 166      14.282  75.916 -18.457  1.00  0.00           H  
ATOM   1544  N   ILE A 167      21.341  74.185 -15.132  1.00 75.15           N  
ATOM   1545  CA  ILE A 167      22.373  74.871 -14.365  1.00 73.54           C  
ATOM   1546  C   ILE A 167      23.594  75.032 -15.264  1.00 72.37           C  
ATOM   1547  O   ILE A 167      24.077  74.109 -15.912  1.00 72.75           O  
ATOM   1548  CB  ILE A 167      22.729  74.081 -13.047  1.00 72.71           C  
ATOM   1549  CG1 ILE A 167      23.807  74.848 -12.326  1.00 72.37           C  
ATOM   1550  CG2 ILE A 167      23.187  72.667 -13.314  1.00 72.78           C  
ATOM   1551  CD1 ILE A 167      24.015  74.481 -10.860  1.00 72.27           C  
ATOM   1552  H   ILE A 167      21.625  73.749 -15.967  1.00  0.00           H  
ATOM   1553  N   THR A 168      24.035  76.268 -15.392  1.00 70.85           N  
ATOM   1554  CA  THR A 168      25.171  76.582 -16.236  1.00 71.10           C  
ATOM   1555  C   THR A 168      26.472  76.010 -15.724  1.00 70.36           C  
ATOM   1556  O   THR A 168      26.595  75.861 -14.500  1.00 70.66           O  
ATOM   1557  CB  THR A 168      25.282  78.079 -16.319  1.00 72.17           C  
ATOM   1558  OG1 THR A 168      25.375  78.565 -14.971  1.00 73.33           O  
ATOM   1559  CG2 THR A 168      24.124  78.668 -17.094  1.00 72.96           C  
ATOM   1560  H   THR A 168      23.512  76.993 -15.002  1.00  0.00           H  
ATOM   1561  HG1 THR A 168      25.097  77.880 -14.356  1.00  0.00           H  
ATOM   1562  N   ARG A 169      27.459  75.807 -16.608  1.00 68.81           N  
ATOM   1563  CA  ARG A 169      28.779  75.376 -16.184  1.00 67.30           C  
ATOM   1564  C   ARG A 169      29.299  76.374 -15.151  1.00 67.01           C  
ATOM   1565  O   ARG A 169      29.881  75.959 -14.151  1.00 68.91           O  
ATOM   1566  CB  ARG A 169      29.755  75.314 -17.351  1.00 67.37           C  
ATOM   1567  CG  ARG A 169      29.720  74.067 -18.228  1.00 69.28           C  
ATOM   1568  CD  ARG A 169      28.501  73.950 -19.125  1.00 71.73           C  
ATOM   1569  NE  ARG A 169      28.695  72.993 -20.204  1.00 74.69           N  
ATOM   1570  CZ  ARG A 169      27.667  72.578 -20.959  1.00 77.73           C  
ATOM   1571  NH1 ARG A 169      26.414  73.025 -20.774  1.00 78.77           N  
ATOM   1572  NH2 ARG A 169      27.887  71.704 -21.938  1.00 79.39           N  
ATOM   1573  H   ARG A 169      27.255  75.923 -17.566  1.00  0.00           H  
ATOM   1574  HE  ARG A 169      29.590  72.645 -20.395  1.00  0.00           H  
ATOM   1575 HH11 ARG A 169      26.224  73.719 -20.082  1.00  0.00           H  
ATOM   1576 HH12 ARG A 169      25.676  72.698 -21.361  1.00  0.00           H  
ATOM   1577 HH21 ARG A 169      28.808  71.360 -22.113  1.00  0.00           H  
ATOM   1578 HH22 ARG A 169      27.121  71.383 -22.497  1.00  0.00           H  
ATOM   1579  N   GLN A 170      29.054  77.678 -15.322  1.00 65.69           N  
ATOM   1580  CA  GLN A 170      29.341  78.720 -14.319  1.00 64.75           C  
ATOM   1581  C   GLN A 170      29.002  78.315 -12.872  1.00 62.35           C  
ATOM   1582  O   GLN A 170      29.850  78.151 -11.987  1.00 61.02           O  
ATOM   1583  CB  GLN A 170      28.536  79.997 -14.599  1.00 67.61           C  
ATOM   1584  CG  GLN A 170      28.503  80.547 -16.012  1.00 70.46           C  
ATOM   1585  CD  GLN A 170      29.665  81.459 -16.365  1.00 71.56           C  
ATOM   1586  OE1 GLN A 170      30.840  81.100 -16.420  1.00 70.32           O  
ATOM   1587  NE2 GLN A 170      29.312  82.709 -16.604  1.00 74.27           N  
ATOM   1588  H   GLN A 170      28.847  77.966 -16.235  1.00  0.00           H  
ATOM   1589 HE21 GLN A 170      28.359  82.943 -16.563  1.00  0.00           H  
ATOM   1590 HE22 GLN A 170      30.021  83.357 -16.773  1.00  0.00           H  
ATOM   1591  N   GLU A 171      27.705  78.123 -12.648  1.00 59.89           N  
ATOM   1592  CA  GLU A 171      27.154  77.760 -11.362  1.00 57.12           C  
ATOM   1593  C   GLU A 171      27.818  76.593 -10.677  1.00 54.40           C  
ATOM   1594  O   GLU A 171      28.287  76.694  -9.545  1.00 51.38           O  
ATOM   1595  CB  GLU A 171      25.722  77.462 -11.579  1.00 58.52           C  
ATOM   1596  CG  GLU A 171      24.849  78.661 -11.549  1.00 61.47           C  
ATOM   1597  CD  GLU A 171      24.237  78.786 -10.174  1.00 63.05           C  
ATOM   1598  OE1 GLU A 171      24.871  79.303  -9.262  1.00 62.59           O  
ATOM   1599  OE2 GLU A 171      23.107  78.346 -10.014  1.00 66.08           O  
ATOM   1600  H   GLU A 171      27.085  78.254 -13.387  1.00  0.00           H  
ATOM   1601  N   ILE A 172      27.891  75.484 -11.409  1.00 52.20           N  
ATOM   1602  CA  ILE A 172      28.523  74.281 -10.901  1.00 51.29           C  
ATOM   1603  C   ILE A 172      29.939  74.659 -10.522  1.00 49.88           C  
ATOM   1604  O   ILE A 172      30.353  74.309  -9.418  1.00 49.13           O  
ATOM   1605  CB  ILE A 172      28.536  73.153 -11.956  1.00 51.81           C  
ATOM   1606  CG1 ILE A 172      27.090  72.734 -12.241  1.00 52.05           C  
ATOM   1607  CG2 ILE A 172      29.351  71.951 -11.447  1.00 51.95           C  
ATOM   1608  CD1 ILE A 172      26.899  71.663 -13.320  1.00 52.18           C  
ATOM   1609  H   ILE A 172      27.552  75.520 -12.325  1.00  0.00           H  
ATOM   1610  N   GLY A 173      30.636  75.419 -11.361  1.00 48.64           N  
ATOM   1611  CA  GLY A 173      31.940  75.954 -11.031  1.00 47.93           C  
ATOM   1612  C   GLY A 173      31.975  76.574  -9.642  1.00 46.80           C  
ATOM   1613  O   GLY A 173      32.785  76.183  -8.800  1.00 44.43           O  
ATOM   1614  H   GLY A 173      30.296  75.579 -12.261  1.00  0.00           H  
ATOM   1615  N   GLN A 174      31.019  77.458  -9.375  1.00 47.77           N  
ATOM   1616  CA  GLN A 174      30.876  78.094  -8.074  1.00 48.64           C  
ATOM   1617  C   GLN A 174      30.488  77.160  -6.940  1.00 48.53           C  
ATOM   1618  O   GLN A 174      30.587  77.546  -5.767  1.00 49.02           O  
ATOM   1619  CB  GLN A 174      29.821  79.161  -8.089  1.00 49.80           C  
ATOM   1620  CG  GLN A 174      30.210  80.267  -8.997  1.00 54.71           C  
ATOM   1621  CD  GLN A 174      29.167  81.362  -9.078  1.00 57.86           C  
ATOM   1622  OE1 GLN A 174      28.033  81.204  -9.536  1.00 59.57           O  
ATOM   1623  NE2 GLN A 174      29.581  82.534  -8.622  1.00 60.04           N  
ATOM   1624  H   GLN A 174      30.465  77.730 -10.135  1.00  0.00           H  
ATOM   1625 HE21 GLN A 174      30.488  82.550  -8.265  1.00  0.00           H  
ATOM   1626 HE22 GLN A 174      28.972  83.295  -8.670  1.00  0.00           H  
ATOM   1627  N   ILE A 175      29.924  75.996  -7.252  1.00 46.96           N  
ATOM   1628  CA  ILE A 175      29.510  75.049  -6.234  1.00 44.38           C  
ATOM   1629  C   ILE A 175      30.654  74.140  -5.840  1.00 43.98           C  
ATOM   1630  O   ILE A 175      30.905  73.820  -4.681  1.00 45.09           O  
ATOM   1631  CB  ILE A 175      28.314  74.234  -6.765  1.00 43.89           C  
ATOM   1632  CG1 ILE A 175      27.115  75.168  -7.024  1.00 44.00           C  
ATOM   1633  CG2 ILE A 175      27.955  73.153  -5.758  1.00 43.43           C  
ATOM   1634  CD1 ILE A 175      25.772  74.558  -7.503  1.00 41.84           C  
ATOM   1635  H   ILE A 175      29.689  75.845  -8.188  1.00  0.00           H  
ATOM   1636  N   VAL A 176      31.332  73.682  -6.855  1.00 42.01           N  
ATOM   1637  CA  VAL A 176      32.395  72.773  -6.643  1.00 41.39           C  
ATOM   1638  C   VAL A 176      33.716  73.411  -6.316  1.00 42.54           C  
ATOM   1639  O   VAL A 176      34.448  72.879  -5.503  1.00 43.86           O  
ATOM   1640  CB  VAL A 176      32.351  71.959  -7.879  1.00 41.27           C  
ATOM   1641  CG1 VAL A 176      33.667  71.378  -8.328  1.00 43.71           C  
ATOM   1642  CG2 VAL A 176      31.380  70.873  -7.514  1.00 40.81           C  
ATOM   1643  H   VAL A 176      31.081  73.945  -7.758  1.00  0.00           H  
ATOM   1644  N   GLY A 177      34.083  74.525  -6.919  1.00 43.52           N  
ATOM   1645  CA  GLY A 177      35.352  75.146  -6.632  1.00 43.84           C  
ATOM   1646  C   GLY A 177      36.374  74.744  -7.674  1.00 44.59           C  
ATOM   1647  O   GLY A 177      37.324  74.022  -7.380  1.00 47.50           O  
ATOM   1648  H   GLY A 177      33.511  74.950  -7.581  1.00  0.00           H  
ATOM   1649  N   CYS A 178      36.149  75.177  -8.910  1.00 43.46           N  
ATOM   1650  CA  CYS A 178      37.053  74.946 -10.025  1.00 43.34           C  
ATOM   1651  C   CYS A 178      36.580  75.848 -11.164  1.00 45.23           C  
ATOM   1652  O   CYS A 178      35.494  76.413 -11.034  1.00 44.27           O  
ATOM   1653  CB  CYS A 178      36.984  73.503 -10.434  1.00 42.62           C  
ATOM   1654  SG  CYS A 178      35.299  73.137 -10.940  1.00 40.33           S  
ATOM   1655  H   CYS A 178      35.292  75.607  -9.118  1.00  0.00           H  
ATOM   1656  N   SER A 179      37.303  76.038 -12.282  1.00 47.74           N  
ATOM   1657  CA  SER A 179      36.915  76.994 -13.324  1.00 48.49           C  
ATOM   1658  C   SER A 179      35.816  76.503 -14.266  1.00 50.13           C  
ATOM   1659  O   SER A 179      35.763  75.283 -14.497  1.00 51.04           O  
ATOM   1660  CB  SER A 179      38.147  77.354 -14.151  1.00 48.56           C  
ATOM   1661  OG  SER A 179      38.526  76.385 -15.126  1.00 48.15           O  
ATOM   1662  H   SER A 179      38.086  75.475 -12.454  1.00  0.00           H  
ATOM   1663  HG  SER A 179      38.825  75.558 -14.726  1.00  0.00           H  
ATOM   1664  N   ARG A 180      35.022  77.365 -14.944  1.00 49.58           N  
ATOM   1665  CA  ARG A 180      33.919  76.855 -15.769  1.00 49.65           C  
ATOM   1666  C   ARG A 180      34.453  75.963 -16.860  1.00 50.19           C  
ATOM   1667  O   ARG A 180      33.827  74.999 -17.284  1.00 50.39           O  
ATOM   1668  CB  ARG A 180      33.081  77.928 -16.481  1.00 50.98           C  
ATOM   1669  CG  ARG A 180      33.783  78.714 -17.583  1.00 53.19           C  
ATOM   1670  CD  ARG A 180      32.972  79.280 -18.761  1.00 52.49           C  
ATOM   1671  NE  ARG A 180      33.957  79.877 -19.656  1.00 52.23           N  
ATOM   1672  CZ  ARG A 180      34.727  79.126 -20.456  1.00 52.46           C  
ATOM   1673  NH1 ARG A 180      34.549  77.813 -20.582  1.00 52.35           N  
ATOM   1674  NH2 ARG A 180      35.680  79.692 -21.184  1.00 52.66           N  
ATOM   1675  H   ARG A 180      35.181  78.324 -14.859  1.00  0.00           H  
ATOM   1676  HE  ARG A 180      34.091  80.845 -19.648  1.00  0.00           H  
ATOM   1677 HH11 ARG A 180      33.831  77.352 -20.061  1.00  0.00           H  
ATOM   1678 HH12 ARG A 180      35.136  77.282 -21.191  1.00  0.00           H  
ATOM   1679 HH21 ARG A 180      35.817  80.681 -21.156  1.00  0.00           H  
ATOM   1680 HH22 ARG A 180      36.241  79.134 -21.795  1.00  0.00           H  
ATOM   1681  N   GLU A 181      35.697  76.270 -17.208  1.00 50.43           N  
ATOM   1682  CA  GLU A 181      36.431  75.552 -18.201  1.00 53.22           C  
ATOM   1683  C   GLU A 181      36.563  74.138 -17.683  1.00 53.87           C  
ATOM   1684  O   GLU A 181      36.074  73.213 -18.334  1.00 54.21           O  
ATOM   1685  CB  GLU A 181      37.802  76.162 -18.383  1.00 55.59           C  
ATOM   1686  CG  GLU A 181      37.794  77.531 -19.025  1.00 59.55           C  
ATOM   1687  CD  GLU A 181      37.776  78.731 -18.098  1.00 61.99           C  
ATOM   1688  OE1 GLU A 181      37.019  78.761 -17.125  1.00 63.82           O  
ATOM   1689  OE2 GLU A 181      38.540  79.650 -18.382  1.00 64.14           O  
ATOM   1690  H   GLU A 181      36.178  76.932 -16.692  1.00  0.00           H  
ATOM   1691  N   THR A 182      37.131  73.959 -16.483  1.00 54.25           N  
ATOM   1692  CA  THR A 182      37.338  72.621 -15.962  1.00 53.85           C  
ATOM   1693  C   THR A 182      36.036  71.855 -15.750  1.00 53.96           C  
ATOM   1694  O   THR A 182      35.934  70.643 -15.984  1.00 53.09           O  
ATOM   1695  CB  THR A 182      38.131  72.707 -14.662  1.00 52.38           C  
ATOM   1696  OG1 THR A 182      39.091  73.771 -14.649  1.00 50.70           O  
ATOM   1697  CG2 THR A 182      38.926  71.431 -14.582  1.00 53.12           C  
ATOM   1698  H   THR A 182      37.455  74.725 -15.966  1.00  0.00           H  
ATOM   1699  HG1 THR A 182      39.832  73.510 -15.219  1.00  0.00           H  
ATOM   1700  N   VAL A 183      35.018  72.619 -15.384  1.00 54.79           N  
ATOM   1701  CA  VAL A 183      33.696  72.065 -15.219  1.00 55.89           C  
ATOM   1702  C   VAL A 183      33.280  71.496 -16.575  1.00 56.88           C  
ATOM   1703  O   VAL A 183      32.884  70.339 -16.671  1.00 56.33           O  
ATOM   1704  CB  VAL A 183      32.764  73.187 -14.713  1.00 55.03           C  
ATOM   1705  CG1 VAL A 183      31.388  72.614 -14.431  1.00 54.50           C  
ATOM   1706  CG2 VAL A 183      33.310  73.792 -13.428  1.00 52.36           C  
ATOM   1707  H   VAL A 183      35.196  73.557 -15.167  1.00  0.00           H  
ATOM   1708  N   GLY A 184      33.459  72.226 -17.664  1.00 59.65           N  
ATOM   1709  CA  GLY A 184      33.145  71.714 -18.985  1.00 64.97           C  
ATOM   1710  C   GLY A 184      33.921  70.437 -19.269  1.00 68.20           C  
ATOM   1711  O   GLY A 184      33.338  69.365 -19.480  1.00 70.18           O  
ATOM   1712  H   GLY A 184      33.738  73.155 -17.566  1.00  0.00           H  
ATOM   1713  N   ARG A 185      35.236  70.576 -19.152  1.00 70.07           N  
ATOM   1714  CA  ARG A 185      36.204  69.524 -19.375  1.00 71.26           C  
ATOM   1715  C   ARG A 185      35.789  68.191 -18.771  1.00 72.00           C  
ATOM   1716  O   ARG A 185      35.851  67.150 -19.436  1.00 72.30           O  
ATOM   1717  CB  ARG A 185      37.511  69.958 -18.776  1.00 72.91           C  
ATOM   1718  CG  ARG A 185      38.680  69.507 -19.604  1.00 76.58           C  
ATOM   1719  CD  ARG A 185      39.247  70.693 -20.349  1.00 78.97           C  
ATOM   1720  NE  ARG A 185      39.952  71.544 -19.412  1.00 80.46           N  
ATOM   1721  CZ  ARG A 185      40.637  72.623 -19.793  1.00 81.60           C  
ATOM   1722  NH1 ARG A 185      40.726  73.046 -21.059  1.00 81.85           N  
ATOM   1723  NH2 ARG A 185      41.251  73.308 -18.842  1.00 82.83           N  
ATOM   1724  H   ARG A 185      35.545  71.466 -18.889  1.00  0.00           H  
ATOM   1725  HE  ARG A 185      39.927  71.324 -18.458  1.00  0.00           H  
ATOM   1726 HH11 ARG A 185      40.266  72.558 -21.799  1.00  0.00           H  
ATOM   1727 HH12 ARG A 185      41.288  73.850 -21.255  1.00  0.00           H  
ATOM   1728 HH21 ARG A 185      41.181  72.997 -17.895  1.00  0.00           H  
ATOM   1729 HH22 ARG A 185      41.813  74.105 -19.062  1.00  0.00           H  
ATOM   1730  N   ILE A 186      35.331  68.224 -17.511  1.00 73.28           N  
ATOM   1731  CA  ILE A 186      34.877  67.028 -16.816  1.00 74.00           C  
ATOM   1732  C   ILE A 186      33.440  66.629 -17.134  1.00 73.75           C  
ATOM   1733  O   ILE A 186      33.147  65.432 -17.143  1.00 73.13           O  
ATOM   1734  CB  ILE A 186      35.115  67.256 -15.283  1.00 73.77           C  
ATOM   1735  CG1 ILE A 186      36.627  67.112 -15.080  1.00 73.79           C  
ATOM   1736  CG2 ILE A 186      34.347  66.279 -14.383  1.00 73.64           C  
ATOM   1737  CD1 ILE A 186      37.194  67.194 -13.652  1.00 73.85           C  
ATOM   1738  H   ILE A 186      35.378  69.071 -17.020  1.00  0.00           H  
ATOM   1739  N   LEU A 187      32.510  67.531 -17.435  1.00 74.85           N  
ATOM   1740  CA  LEU A 187      31.138  67.166 -17.763  1.00 76.64           C  
ATOM   1741  C   LEU A 187      31.184  66.258 -18.998  1.00 79.10           C  
ATOM   1742  O   LEU A 187      30.576  65.187 -19.007  1.00 78.40           O  
ATOM   1743  CB  LEU A 187      30.365  68.484 -17.983  1.00 75.27           C  
ATOM   1744  CG  LEU A 187      28.929  68.702 -17.479  1.00 74.08           C  
ATOM   1745  CD1 LEU A 187      28.799  68.343 -16.024  1.00 74.58           C  
ATOM   1746  CD2 LEU A 187      28.571  70.171 -17.587  1.00 73.39           C  
ATOM   1747  H   LEU A 187      32.738  68.483 -17.354  1.00  0.00           H  
ATOM   1748  N   LYS A 188      31.992  66.602 -20.011  1.00 83.30           N  
ATOM   1749  CA  LYS A 188      32.189  65.778 -21.208  1.00 87.07           C  
ATOM   1750  C   LYS A 188      32.768  64.435 -20.799  1.00 87.79           C  
ATOM   1751  O   LYS A 188      32.340  63.421 -21.334  1.00 88.33           O  
ATOM   1752  CB  LYS A 188      33.183  66.356 -22.221  1.00 89.51           C  
ATOM   1753  CG  LYS A 188      32.826  67.606 -23.018  1.00 92.42           C  
ATOM   1754  CD  LYS A 188      34.072  68.019 -23.823  1.00 94.15           C  
ATOM   1755  CE  LYS A 188      34.018  69.471 -24.328  1.00 95.12           C  
ATOM   1756  NZ  LYS A 188      35.279  69.875 -24.933  1.00 94.78           N  
ATOM   1757  H   LYS A 188      32.456  67.462 -19.917  1.00  0.00           H  
ATOM   1758  HZ1 LYS A 188      35.440  69.350 -25.816  1.00  0.00           H  
ATOM   1759  HZ2 LYS A 188      36.069  69.692 -24.280  1.00  0.00           H  
ATOM   1760  HZ3 LYS A 188      35.253  70.891 -25.142  1.00  0.00           H  
ATOM   1761  N   MET A 189      33.742  64.368 -19.887  1.00 88.76           N  
ATOM   1762  CA  MET A 189      34.279  63.108 -19.386  1.00 89.64           C  
ATOM   1763  C   MET A 189      33.144  62.258 -18.824  1.00 89.74           C  
ATOM   1764  O   MET A 189      33.002  61.081 -19.150  1.00 89.37           O  
ATOM   1765  CB  MET A 189      35.302  63.435 -18.322  1.00 91.34           C  
ATOM   1766  CG  MET A 189      36.601  62.679 -18.471  1.00 92.91           C  
ATOM   1767  SD  MET A 189      38.000  63.601 -17.773  1.00 95.61           S  
ATOM   1768  CE  MET A 189      38.854  64.143 -19.234  1.00 94.00           C  
ATOM   1769  H   MET A 189      34.172  65.205 -19.613  1.00  0.00           H  
ATOM   1770  N   LEU A 190      32.248  62.869 -18.065  1.00 91.16           N  
ATOM   1771  CA  LEU A 190      31.064  62.198 -17.569  1.00 93.35           C  
ATOM   1772  C   LEU A 190      30.051  61.881 -18.679  1.00 95.13           C  
ATOM   1773  O   LEU A 190      29.162  61.046 -18.462  1.00 95.03           O  
ATOM   1774  CB  LEU A 190      30.435  63.078 -16.502  1.00 93.70           C  
ATOM   1775  CG  LEU A 190      31.201  63.350 -15.216  1.00 94.50           C  
ATOM   1776  CD1 LEU A 190      30.646  64.592 -14.542  1.00 94.38           C  
ATOM   1777  CD2 LEU A 190      31.101  62.141 -14.303  1.00 94.92           C  
ATOM   1778  H   LEU A 190      32.446  63.784 -17.777  1.00  0.00           H  
ATOM   1779  N   GLU A 191      30.075  62.556 -19.843  1.00 97.54           N  
ATOM   1780  CA  GLU A 191      29.252  62.193 -21.009  1.00 98.97           C  
ATOM   1781  C   GLU A 191      29.819  60.957 -21.710  1.00 99.54           C  
ATOM   1782  O   GLU A 191      29.060  60.016 -21.980  1.00100.10           O  
ATOM   1783  CB  GLU A 191      29.174  63.283 -22.102  1.00 99.32           C  
ATOM   1784  CG  GLU A 191      28.258  64.469 -21.837  1.00100.87           C  
ATOM   1785  CD  GLU A 191      27.762  65.207 -23.083  1.00101.44           C  
ATOM   1786  OE1 GLU A 191      26.758  64.769 -23.661  1.00101.05           O  
ATOM   1787  OE2 GLU A 191      28.362  66.227 -23.449  1.00101.67           O  
ATOM   1788  H   GLU A 191      30.564  63.400 -19.848  1.00  0.00           H  
ATOM   1789  N   ASP A 192      31.138  60.912 -22.013  1.00 98.69           N  
ATOM   1790  CA  ASP A 192      31.824  59.748 -22.593  1.00 96.75           C  
ATOM   1791  C   ASP A 192      31.500  58.579 -21.678  1.00 95.68           C  
ATOM   1792  O   ASP A 192      30.912  57.595 -22.102  1.00 95.48           O  
ATOM   1793  CB  ASP A 192      33.362  59.937 -22.643  1.00 97.01           C  
ATOM   1794  CG  ASP A 192      33.927  61.004 -23.600  1.00 96.92           C  
ATOM   1795  OD1 ASP A 192      33.183  61.534 -24.431  1.00 96.67           O  
ATOM   1796  OD2 ASP A 192      35.129  61.302 -23.513  1.00 96.00           O  
ATOM   1797  H   ASP A 192      31.638  61.735 -21.838  1.00  0.00           H  
ATOM   1798  N   GLN A 193      31.721  58.704 -20.377  1.00 94.94           N  
ATOM   1799  CA  GLN A 193      31.284  57.702 -19.421  1.00 95.11           C  
ATOM   1800  C   GLN A 193      29.768  57.444 -19.321  1.00 95.42           C  
ATOM   1801  O   GLN A 193      29.353  56.739 -18.402  1.00 95.68           O  
ATOM   1802  CB  GLN A 193      31.757  58.084 -18.047  1.00 94.84           C  
ATOM   1803  CG  GLN A 193      33.157  57.756 -17.637  1.00 94.19           C  
ATOM   1804  CD  GLN A 193      33.265  58.176 -16.190  1.00 94.31           C  
ATOM   1805  OE1 GLN A 193      33.919  59.158 -15.874  1.00 95.19           O  
ATOM   1806  NE2 GLN A 193      32.590  57.531 -15.250  1.00 94.28           N  
ATOM   1807  H   GLN A 193      32.192  59.498 -20.038  1.00  0.00           H  
ATOM   1808 HE21 GLN A 193      31.994  56.805 -15.525  1.00  0.00           H  
ATOM   1809 HE22 GLN A 193      32.713  57.836 -14.329  1.00  0.00           H  
ATOM   1810  N   ASN A 194      28.875  57.986 -20.155  1.00 95.46           N  
ATOM   1811  CA  ASN A 194      27.436  57.726 -20.127  1.00 97.55           C  
ATOM   1812  C   ASN A 194      26.652  58.121 -18.877  1.00 97.61           C  
ATOM   1813  O   ASN A 194      25.497  57.703 -18.713  1.00 96.84           O  
ATOM   1814  CB  ASN A 194      27.171  56.236 -20.379  1.00100.92           C  
ATOM   1815  CG  ASN A 194      27.481  55.710 -21.771  1.00104.08           C  
ATOM   1816  OD1 ASN A 194      26.844  54.759 -22.225  1.00105.76           O  
ATOM   1817  ND2 ASN A 194      28.458  56.177 -22.538  1.00105.65           N  
ATOM   1818  H   ASN A 194      29.194  58.569 -20.866  1.00  0.00           H  
ATOM   1819 HD21 ASN A 194      29.105  56.845 -22.226  1.00  0.00           H  
ATOM   1820 HD22 ASN A 194      28.494  55.806 -23.442  1.00  0.00           H  
ATOM   1821  N   LEU A 195      27.182  58.970 -17.984  1.00 97.58           N  
ATOM   1822  CA  LEU A 195      26.462  59.316 -16.762  1.00 96.42           C  
ATOM   1823  C   LEU A 195      25.757  60.651 -16.880  1.00 95.40           C  
ATOM   1824  O   LEU A 195      24.711  60.872 -16.261  1.00 94.30           O  
ATOM   1825  CB  LEU A 195      27.404  59.382 -15.560  1.00 97.04           C  
ATOM   1826  CG  LEU A 195      28.125  58.118 -15.072  1.00 97.41           C  
ATOM   1827  CD1 LEU A 195      28.891  58.482 -13.806  1.00 97.84           C  
ATOM   1828  CD2 LEU A 195      27.141  56.981 -14.776  1.00 97.14           C  
ATOM   1829  H   LEU A 195      27.974  59.496 -18.206  1.00  0.00           H  
ATOM   1830  N   ILE A 196      26.322  61.593 -17.629  1.00 94.71           N  
ATOM   1831  CA  ILE A 196      25.629  62.842 -17.812  1.00 94.24           C  
ATOM   1832  C   ILE A 196      25.343  63.085 -19.293  1.00 95.30           C  
ATOM   1833  O   ILE A 196      26.162  62.767 -20.159  1.00 95.01           O  
ATOM   1834  CB  ILE A 196      26.496  63.978 -17.157  1.00 92.83           C  
ATOM   1835  CG1 ILE A 196      25.598  65.179 -16.995  1.00 93.06           C  
ATOM   1836  CG2 ILE A 196      27.668  64.441 -17.991  1.00 91.46           C  
ATOM   1837  CD1 ILE A 196      24.439  64.909 -16.033  1.00 93.15           C  
ATOM   1838  H   ILE A 196      27.166  61.427 -18.098  1.00  0.00           H  
ATOM   1839  N   SER A 197      24.144  63.577 -19.595  1.00 96.35           N  
ATOM   1840  CA  SER A 197      23.784  63.987 -20.943  1.00 97.18           C  
ATOM   1841  C   SER A 197      23.654  65.508 -20.852  1.00 97.63           C  
ATOM   1842  O   SER A 197      22.920  65.980 -19.969  1.00 98.28           O  
ATOM   1843  CB  SER A 197      22.470  63.323 -21.305  1.00 97.81           C  
ATOM   1844  OG  SER A 197      22.586  61.911 -21.158  1.00 99.40           O  
ATOM   1845  H   SER A 197      23.459  63.634 -18.894  1.00  0.00           H  
ATOM   1846  HG  SER A 197      21.896  61.586 -20.577  1.00  0.00           H  
ATOM   1847  N   ALA A 198      24.322  66.307 -21.696  1.00 97.58           N  
ATOM   1848  CA  ALA A 198      24.319  67.757 -21.525  1.00 97.26           C  
ATOM   1849  C   ALA A 198      24.178  68.565 -22.798  1.00 97.19           C  
ATOM   1850  O   ALA A 198      24.555  68.114 -23.883  1.00 97.66           O  
ATOM   1851  CB  ALA A 198      25.610  68.237 -20.861  1.00 96.38           C  
ATOM   1852  H   ALA A 198      24.770  65.948 -22.494  1.00  0.00           H  
ATOM   1853  N   HIS A 199      23.591  69.758 -22.627  1.00 97.20           N  
ATOM   1854  CA  HIS A 199      23.442  70.763 -23.677  1.00 96.52           C  
ATOM   1855  C   HIS A 199      22.854  72.057 -23.050  1.00 95.58           C  
ATOM   1856  O   HIS A 199      21.779  72.484 -23.478  1.00 96.47           O  
ATOM   1857  CB  HIS A 199      22.521  70.124 -24.749  1.00 97.40           C  
ATOM   1858  CG  HIS A 199      22.383  70.860 -26.073  1.00 97.90           C  
ATOM   1859  ND1 HIS A 199      21.394  71.678 -26.432  1.00 98.06           N  
ATOM   1860  CD2 HIS A 199      23.264  70.759 -27.122  1.00 97.60           C  
ATOM   1861  CE1 HIS A 199      21.638  72.083 -27.653  1.00 97.93           C  
ATOM   1862  NE2 HIS A 199      22.762  71.528 -28.055  1.00 98.26           N  
ATOM   1863  H   HIS A 199      23.097  69.883 -21.786  1.00  0.00           H  
ATOM   1864  HD1 HIS A 199      20.705  72.044 -25.825  1.00  0.00           H  
ATOM   1865  HE2 HIS A 199      23.180  71.692 -28.931  1.00  0.00           H  
ATOM   1866  N   GLY A 200      23.446  72.752 -22.057  1.00 93.24           N  
ATOM   1867  CA  GLY A 200      22.819  73.924 -21.424  1.00 90.85           C  
ATOM   1868  C   GLY A 200      22.051  73.562 -20.146  1.00 90.35           C  
ATOM   1869  O   GLY A 200      22.119  74.234 -19.118  1.00 89.36           O  
ATOM   1870  H   GLY A 200      24.322  72.470 -21.721  1.00  0.00           H  
ATOM   1871  N   LYS A 201      21.242  72.509 -20.231  1.00 91.57           N  
ATOM   1872  CA  LYS A 201      20.556  71.886 -19.096  1.00 92.47           C  
ATOM   1873  C   LYS A 201      21.114  70.455 -19.011  1.00 92.01           C  
ATOM   1874  O   LYS A 201      21.547  69.912 -20.044  1.00 93.51           O  
ATOM   1875  CB  LYS A 201      19.047  71.808 -19.330  1.00 94.06           C  
ATOM   1876  CG  LYS A 201      18.614  70.790 -20.392  1.00 96.04           C  
ATOM   1877  CD  LYS A 201      17.110  70.665 -20.443  1.00 98.38           C  
ATOM   1878  CE  LYS A 201      16.670  69.622 -21.469  1.00 99.28           C  
ATOM   1879  NZ  LYS A 201      15.241  69.778 -21.668  1.00 99.64           N  
ATOM   1880  H   LYS A 201      21.065  72.134 -21.117  1.00  0.00           H  
ATOM   1881  HZ1 LYS A 201      15.067  70.736 -22.039  1.00  0.00           H  
ATOM   1882  HZ2 LYS A 201      14.760  69.681 -20.753  1.00  0.00           H  
ATOM   1883  HZ3 LYS A 201      14.886  69.072 -22.342  1.00  0.00           H  
ATOM   1884  N   THR A 202      21.146  69.789 -17.873  1.00 89.76           N  
ATOM   1885  CA  THR A 202      21.721  68.474 -17.780  1.00 88.47           C  
ATOM   1886  C   THR A 202      20.676  67.505 -17.312  1.00 88.57           C  
ATOM   1887  O   THR A 202      19.785  67.834 -16.525  1.00 87.26           O  
ATOM   1888  CB  THR A 202      22.894  68.434 -16.786  1.00 88.44           C  
ATOM   1889  OG1 THR A 202      22.470  69.176 -15.648  1.00 87.18           O  
ATOM   1890  CG2 THR A 202      24.201  68.963 -17.373  1.00 88.48           C  
ATOM   1891  H   THR A 202      20.706  70.128 -17.078  1.00  0.00           H  
ATOM   1892  HG1 THR A 202      23.236  69.364 -15.103  1.00  0.00           H  
ATOM   1893  N   ILE A 203      20.798  66.305 -17.856  1.00 89.49           N  
ATOM   1894  CA  ILE A 203      19.974  65.194 -17.445  1.00 89.15           C  
ATOM   1895  C   ILE A 203      20.967  64.255 -16.799  1.00 87.77           C  
ATOM   1896  O   ILE A 203      21.905  63.718 -17.407  1.00 86.46           O  
ATOM   1897  CB  ILE A 203      19.270  64.523 -18.651  1.00 90.74           C  
ATOM   1898  CG1 ILE A 203      18.117  65.417 -19.122  1.00 92.08           C  
ATOM   1899  CG2 ILE A 203      18.703  63.160 -18.260  1.00 91.02           C  
ATOM   1900  CD1 ILE A 203      18.403  66.600 -20.091  1.00 93.16           C  
ATOM   1901  H   ILE A 203      21.489  66.160 -18.536  1.00  0.00           H  
ATOM   1902  N   VAL A 204      20.737  64.171 -15.506  1.00 87.05           N  
ATOM   1903  CA  VAL A 204      21.572  63.368 -14.645  1.00 87.85           C  
ATOM   1904  C   VAL A 204      20.830  62.059 -14.703  1.00 87.58           C  
ATOM   1905  O   VAL A 204      19.617  62.036 -14.436  1.00 87.68           O  
ATOM   1906  CB  VAL A 204      21.594  63.931 -13.196  1.00 88.83           C  
ATOM   1907  CG1 VAL A 204      22.389  63.036 -12.251  1.00 89.20           C  
ATOM   1908  CG2 VAL A 204      22.288  65.279 -13.203  1.00 89.93           C  
ATOM   1909  H   VAL A 204      19.860  64.481 -15.193  1.00  0.00           H  
ATOM   1910  N   VAL A 205      21.526  61.006 -15.143  1.00 87.29           N  
ATOM   1911  CA  VAL A 205      20.907  59.686 -15.188  1.00 86.60           C  
ATOM   1912  C   VAL A 205      20.728  59.133 -13.765  1.00 87.65           C  
ATOM   1913  O   VAL A 205      20.926  59.787 -12.731  1.00 87.86           O  
ATOM   1914  CB  VAL A 205      21.753  58.644 -16.043  1.00 85.62           C  
ATOM   1915  CG1 VAL A 205      21.844  59.085 -17.499  1.00 84.81           C  
ATOM   1916  CG2 VAL A 205      23.142  58.478 -15.454  1.00 84.56           C  
ATOM   1917  H   VAL A 205      22.466  61.105 -15.414  1.00  0.00           H  
TER    1918      VAL A 205                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
