
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  144 ( 1096),  selected  144 , name 2pqq_B
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2pqq_B.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      M       1           -
LGA    -       -      H       2           -
LGA    -       -      T       3           -
LGA    -       -      A       4           -
LGA    -       -      L       5           -
LGA    -       -      I       6           -
LGA    D     2_B      N       7           #
LGA    D     3_B      H       8          1.917
LGA    V     4_B      -       -           -
LGA    L     5_B      -       -           -
LGA    R     6_B      I       9          3.316
LGA    R     7_B      R      10           -
LGA    N     8_B      -       -           -
LGA    P     9_B      -       -           -
LGA    L    10_B      -       -           -
LGA    F    11_B      -       -           -
LGA    A    12_B      K      11           #
LGA    A    13_B      F      12          3.949
LGA    L    14_B      I      13          2.719
LGA    D    15_B      F      14          1.804
LGA    D    16_B      L      15          3.257
LGA    E    17_B      T      16          2.735
LGA    Q    18_B      D      17           #
LGA    S    19_B      E      18           -
LGA    -       -      D      19           -
LGA    A    20_B      A      20          2.591
LGA    E    21_B      G      21          3.693
LGA    L    22_B      T      22           #
LGA    R    23_B      L      23           #
LGA    A    24_B      S      24          1.333
LGA    S    25_B      A      25          2.303
LGA    -       -      F      26           -
LGA    X    26_B      F      27          0.912
LGA    S    27_B      Q      28          0.945
LGA    E    28_B      L      29          0.910
LGA    V    29_B      K      30          1.137
LGA    T    30_B      K      31          1.381
LGA    L    31_B      V      32          0.915
LGA    A    32_B      R      33          1.010
LGA    R    33_B      K      34          1.633
LGA    G    34_B      K      35          1.969
LGA    D    35_B      E      36          1.067
LGA    T    36_B      T      37          0.687
LGA    L    37_B      L      38          1.248
LGA    F    38_B      L      39          0.982
LGA    H    39_B      K      40          0.897
LGA    E    40_B      T      41          1.904
LGA    G    41_B      G      42          2.299
LGA    D    42_B      E      43          1.402
LGA    P    43_B      I      44          0.778
LGA    G    44_B      C      45          0.668
LGA    D    45_B      R      46          1.883
LGA    R    46_B      I      47          2.056
LGA    L    47_B      N      48          0.932
LGA    Y    48_B      Y      49          0.540
LGA    V    49_B      F      50          0.792
LGA    V    50_B      V      51          0.758
LGA    T    51_B      V      52          0.751
LGA    E    52_B      K      53          0.724
LGA    G    53_B      G      54          1.240
LGA    K    54_B      C      55          1.654
LGA    V    55_B      L      56          1.715
LGA    K    56_B      R      57          2.478
LGA    L    57_B      L      58          2.077
LGA    H    58_B      F      59          1.709
LGA    R    59_B      F      60          0.875
LGA    T    60_B      I      61          1.082
LGA    S    61_B      D      62          0.968
LGA    P    62_B      E      63          1.711
LGA    D    63_B      K      64          1.507
LGA    G    64_B      G      65          1.670
LGA    R    65_B      I      66          1.631
LGA    E    66_B      E      67          1.471
LGA    N    67_B      Q      68          1.426
LGA    X    68_B      T      69          2.083
LGA    L    69_B      T      70          1.859
LGA    A    70_B      Q      71          2.356
LGA    V    71_B      F      72          2.572
LGA    V    72_B      A      73          1.995
LGA    G    73_B      I      74          1.247
LGA    P    74_B      E      75          0.659
LGA    S    75_B      N      76          0.970
LGA    E    76_B      W      77          1.560
LGA    L    77_B      W      78          0.972
LGA    I    78_B      L      79          0.546
LGA    G    79_B      S      80          1.148
LGA    -       -      D      81           -
LGA    E    80_B      Y      82          4.628
LGA    L    81_B      M      83          5.311
LGA    S    82_B      A      84          5.089
LGA    L    83_B      F      85          4.945
LGA    F    84_B      -       -           -
LGA    D    85_B      Q      86          1.201
LGA    P    86_B      K      87          3.593
LGA    G    87_B      Q      88          3.650
LGA    -       -      Q      89           -
LGA    P    88_B      P      90          2.808
LGA    R    89_B      A      91          2.448
LGA    T    90_B      D      92          2.855
LGA    A    91_B      F      93          1.690
LGA    T    92_B      Y      94          1.177
LGA    G    93_B      I      95          1.649
LGA    T    94_B      Q      96          1.761
LGA    A    95_B      S      97          1.549
LGA    L    96_B      V      98          1.908
LGA    T    97_B      E      99          1.835
LGA    E    98_B      N     100          1.183
LGA    V    99_B      C     101          0.872
LGA    K   100_B      E     102          1.225
LGA    L   101_B      L     103          0.768
LGA    L   102_B      L     104          0.631
LGA    A   103_B      S     105          0.880
LGA    L   104_B      I     106          1.553
LGA    G   105_B      T     107          1.060
LGA    H   106_B      Y     108          1.505
LGA    G   107_B      T     109          1.718
LGA    D   108_B      E     110          1.085
LGA    L   109_B      Q     111          2.958
LGA    Q   110_B      E     112          4.179
LGA    P   111_B      N     113          3.248
LGA    W   112_B      L     114          2.056
LGA    L   113_B      F     115          3.604
LGA    N   114_B      E     116          4.067
LGA    V   115_B      R     117          2.683
LGA    R   116_B      I     118          2.280
LGA    P   117_B      P     119          4.009
LGA    E   118_B      A     120          4.977
LGA    V   119_B      L     121          4.070
LGA    A   120_B      -       -           -
LGA    T   121_B      E     122          5.103
LGA    A   122_B      R     123          2.928
LGA    L   123_B      Y     124           #
LGA    L   124_B      F     125           -
LGA    R   125_B      -       -           -
LGA    A   126_B      R     126          1.906
LGA    V   127_B      L     127           -
LGA    A   128_B      V     128           -
LGA    R   129_B      Y     129           -
LGA    R   130_B      Q     130          4.640
LGA    L   131_B      K     131           -
LGA    R   132_B      S     132           -
LGA    K   133_B      F     133           #
LGA    -       -      A     134           -
LGA    -       -      A     135           -
LGA    -       -      A     136           -
LGA    T   134_B      Q     137           #
LGA    N   135_B      L     138           -
LGA    D   136_B      R     139           -
LGA    A   137_B      S     140           -
LGA    X   138_B      K     141           -
LGA    S   139_B      F     142           -
LGA    D   140_B      Q     143           -
LGA    S   144_B      H     144           -
LGA    D   145_B      M     145           -
LGA    G   146_B      Y     146           -
LGA    S   147_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  144  146    5.0    108    2.32    12.96     60.584     4.455

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.136854 * X  +   0.873642 * Y  +   0.466927 * Z  +   9.385766
  Y_new =   0.947546 * X  +   0.252893 * Y  +  -0.195451 * Z  +  26.636042
  Z_new =  -0.288837 * X  +   0.415687 * Y  +  -0.862425 * Z  + -17.378298 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.692450   -0.449142  [ DEG:   154.2660    -25.7340 ]
  Theta =   0.293012    2.848581  [ DEG:    16.7883    163.2117 ]
  Phi   =   1.714235   -1.427358  [ DEG:    98.2184    -81.7816 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pqq_B                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pqq_B.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  144  146   5.0  108   2.32   12.96  60.584
REMARK  ---------------------------------------------------------- 
MOLECULE 2pqq_B
HEADER    TRANSCRIPTION                           02-MAY-07   2PQQ              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF THE N-                  
TITLE    2 TERMINAL DOMAIN OF A TRANSCRIPTIONAL REGULATOR FROM                  
TITLE    3 STREPTOMYCES COELICOLOR A3(2)                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TRANSCRIPTIONAL REGULATOR;                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES COELICOLOR;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: A3(2), M145;                                                 
SOURCE   5 ATCC: BAA-471;                                                       
SOURCE   6 GENE: SCO3571, SCH17.05;                                             
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: P15TV LIC                                 
KEYWDS    APC7345, TRANSCRIPTIONAL REGULATOR, STREPTOMYCES COELICOLOR           
KEYWDS   2 A3(2), STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE                 
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,                
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   05-JUN-07 2PQQ    0                                                
JRNL        AUTH   K.TAN,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                    
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE N-TERMINAL DOMAIN OF            
JRNL        TITL 2 A TRANSCRIPTIONAL REGULATOR FROM STREPTOMYCES                
JRNL        TITL 3 COELICOLOR A3(2)                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2PQQ A    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
DBREF  2PQQ B    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
DBREF  2PQQ C    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
DBREF  2PQQ D    1   145  UNP    Q9XA42   Q9XA42_STRCO     1    145             
SEQRES   1 A  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 A  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 A  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 A  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 A  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 A  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 A  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 A  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 A  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 A  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 A  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 A  149  VAL PHE SER ASP GLY SER                                      
SEQRES   1 B  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 B  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 B  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 B  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 B  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 B  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 B  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 B  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 B  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 B  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 B  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 B  149  VAL PHE SER ASP GLY SER                                      
SEQRES   1 C  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 C  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 C  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 C  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 C  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 C  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 C  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 C  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 C  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 C  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 C  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 C  149  VAL PHE SER ASP GLY SER                                      
SEQRES   1 D  149  GLY HIS MSE ASP ASP VAL LEU ARG ARG ASN PRO LEU PHE          
SEQRES   2 D  149  ALA ALA LEU ASP ASP GLU GLN SER ALA GLU LEU ARG ALA          
SEQRES   3 D  149  SER MSE SER GLU VAL THR LEU ALA ARG GLY ASP THR LEU          
SEQRES   4 D  149  PHE HIS GLU GLY ASP PRO GLY ASP ARG LEU TYR VAL VAL          
SEQRES   5 D  149  THR GLU GLY LYS VAL LYS LEU HIS ARG THR SER PRO ASP          
SEQRES   6 D  149  GLY ARG GLU ASN MSE LEU ALA VAL VAL GLY PRO SER GLU          
SEQRES   7 D  149  LEU ILE GLY GLU LEU SER LEU PHE ASP PRO GLY PRO ARG          
SEQRES   8 D  149  THR ALA THR GLY THR ALA LEU THR GLU VAL LYS LEU LEU          
SEQRES   9 D  149  ALA LEU GLY HIS GLY ASP LEU GLN PRO TRP LEU ASN VAL          
SEQRES  10 D  149  ARG PRO GLU VAL ALA THR ALA LEU LEU ARG ALA VAL ALA          
SEQRES  11 D  149  ARG ARG LEU ARG LYS THR ASN ASP ALA MSE SER ASP LEU          
SEQRES  12 D  149  VAL PHE SER ASP GLY SER                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  26       8                                                       
HET    MSE  A  68       8                                                       
HET    MSE  A 138       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  26       8                                                       
HET    MSE  B  68       8                                                       
HET    MSE  B 138       8                                                       
HET    MSE  C  26       8                                                       
HET    MSE  C  68       8                                                       
HET    MSE  C 138       8                                                       
HET    MSE  D  26       8                                                       
HET    MSE  D  68       8                                                       
HET    MSE  D 138       8                                                       
HET    FMT    301       3                                                       
HET    FMT    302       3                                                       
HET    FMT    303       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     FMT FORMIC ACID                                                      
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   5  FMT    3(C H2 O2)                                                   
FORMUL   8  HOH   *251(H2 O)                                                    
CRYST1   39.852  100.946  144.119  90.00  90.00  90.00 P 21 21 21   16          
HETATM 1132  N   MSE B   1       5.564  68.196   5.499  1.00 55.44           N  
HETATM 1133  CA  MSE B   1       5.242  69.535   6.083  1.00 55.35           C  
HETATM 1134  C   MSE B   1       4.931  70.549   4.975  1.00 54.81           C  
HETATM 1135  O   MSE B   1       5.729  70.751   4.049  1.00 55.03           O  
HETATM 1136  CB  MSE B   1       6.381  70.034   6.989  1.00 55.79           C  
HETATM 1137  CG  MSE B   1       5.991  71.174   7.944  1.00 56.73           C  
HETATM 1138 SE   MSE B   1       5.349  70.629   9.740  0.60 61.91          SE  
HETATM 1139  CE  MSE B   1       7.054  70.090  10.575  1.00 58.75           C  
ATOM   1140  N   ASP B   2       3.750  71.162   5.077  1.00 53.88           N  
ATOM   1141  CA  ASP B   2       3.278  72.172   4.125  1.00 52.71           C  
ATOM   1142  C   ASP B   2       3.696  73.556   4.609  1.00 51.62           C  
ATOM   1143  O   ASP B   2       3.700  74.527   3.851  1.00 51.58           O  
ATOM   1144  CB  ASP B   2       1.747  72.124   3.999  1.00 53.05           C  
ATOM   1145  CG  ASP B   2       1.112  70.988   4.811  1.00 53.30           C  
ATOM   1146  OD1 ASP B   2       1.219  71.012   6.059  1.00 52.91           O  
ATOM   1147  OD2 ASP B   2       0.487  70.091   4.203  1.00 52.93           O  
ATOM   1148  N   ASP B   3       4.041  73.629   5.889  1.00 50.16           N  
ATOM   1149  CA  ASP B   3       4.363  74.878   6.542  1.00 48.81           C  
ATOM   1150  C   ASP B   3       5.735  75.389   6.091  1.00 47.91           C  
ATOM   1151  O   ASP B   3       6.758  74.733   6.313  1.00 47.88           O  
ATOM   1152  CB  ASP B   3       4.318  74.674   8.059  1.00 48.55           C  
ATOM   1153  CG  ASP B   3       4.184  75.974   8.826  1.00 48.00           C  
ATOM   1154  OD1 ASP B   3       3.634  75.920   9.943  1.00 46.44           O  
ATOM   1155  OD2 ASP B   3       4.619  77.037   8.322  1.00 44.25           O  
ATOM   1156  N   VAL B   4       5.749  76.560   5.458  1.00 46.84           N  
ATOM   1157  CA  VAL B   4       6.994  77.171   4.983  1.00 45.90           C  
ATOM   1158  C   VAL B   4       7.958  77.497   6.145  1.00 45.02           C  
ATOM   1159  O   VAL B   4       9.151  77.724   5.935  1.00 44.80           O  
ATOM   1160  CB  VAL B   4       6.721  78.422   4.092  1.00 46.06           C  
ATOM   1161  CG1 VAL B   4       6.508  79.690   4.940  1.00 46.16           C  
ATOM   1162  CG2 VAL B   4       7.859  78.624   3.107  1.00 46.14           C  
ATOM   1163  N   LEU B   5       7.427  77.501   7.366  1.00 43.93           N  
ATOM   1164  CA  LEU B   5       8.217  77.778   8.554  1.00 42.71           C  
ATOM   1165  C   LEU B   5       8.775  76.529   9.261  1.00 41.57           C  
ATOM   1166  O   LEU B   5       9.809  76.596   9.916  1.00 41.42           O  
ATOM   1167  CB  LEU B   5       7.412  78.648   9.539  1.00 43.26           C  
ATOM   1168  CG  LEU B   5       7.504  80.177   9.391  1.00 43.89           C  
ATOM   1169  CD1 LEU B   5       6.651  80.853  10.444  1.00 44.67           C  
ATOM   1170  CD2 LEU B   5       8.924  80.686   9.533  1.00 42.81           C  
ATOM   1171  N   ARG B   6       8.102  75.392   9.129  1.00 40.31           N  
ATOM   1172  CA  ARG B   6       8.469  74.246   9.948  1.00 39.23           C  
ATOM   1173  C   ARG B   6       9.261  73.182   9.192  1.00 39.41           C  
ATOM   1174  O   ARG B   6       9.465  72.069   9.688  1.00 39.68           O  
ATOM   1175  CB  ARG B   6       7.242  73.689  10.658  1.00 38.51           C  
ATOM   1176  CG  ARG B   6       6.773  74.599  11.791  1.00 37.92           C  
ATOM   1177  CD  ARG B   6       5.628  74.000  12.556  1.00 36.00           C  
ATOM   1178  NE  ARG B   6       4.457  73.852  11.698  1.00 34.65           N  
ATOM   1179  CZ  ARG B   6       3.321  73.258  12.052  1.00 33.33           C  
ATOM   1180  NH1 ARG B   6       3.188  72.759  13.262  1.00 33.14           N  
ATOM   1181  NH2 ARG B   6       2.313  73.172  11.190  1.00 31.77           N  
ATOM   1182  N   ARG B   7       9.744  73.546   8.009  1.00 38.98           N  
ATOM   1183  CA  ARG B   7      10.583  72.646   7.233  1.00 38.90           C  
ATOM   1184  C   ARG B   7      12.069  72.776   7.576  1.00 38.49           C  
ATOM   1185  O   ARG B   7      12.901  72.070   7.024  1.00 39.24           O  
ATOM   1186  CB  ARG B   7      10.320  72.835   5.735  1.00 39.45           C  
ATOM   1187  CG  ARG B   7       9.008  72.201   5.281  1.00 41.10           C  
ATOM   1188  CD  ARG B   7       8.408  72.922   4.069  1.00 44.77           C  
ATOM   1189  NE  ARG B   7       9.090  72.622   2.809  1.00 45.67           N  
ATOM   1190  CZ  ARG B   7       8.591  72.902   1.603  1.00 48.00           C  
ATOM   1191  NH1 ARG B   7       9.274  72.590   0.501  1.00 47.53           N  
ATOM   1192  NH2 ARG B   7       7.398  73.487   1.497  1.00 48.08           N  
ATOM   1193  N   ASN B   8      12.400  73.665   8.507  1.00 37.75           N  
ATOM   1194  CA  ASN B   8      13.785  73.853   8.927  1.00 37.00           C  
ATOM   1195  C   ASN B   8      13.963  73.416  10.385  1.00 36.38           C  
ATOM   1196  O   ASN B   8      13.023  73.519  11.148  1.00 34.59           O  
ATOM   1197  CB  ASN B   8      14.185  75.316   8.756  1.00 37.78           C  
ATOM   1198  CG  ASN B   8      13.302  76.253   9.553  1.00 38.41           C  
ATOM   1199  OD1 ASN B   8      13.473  76.405  10.760  1.00 40.50           O  
ATOM   1200  ND2 ASN B   8      12.340  76.880   8.882  1.00 39.82           N  
ATOM   1201  N   PRO B   9      15.175  72.959  10.771  1.00 36.65           N  
ATOM   1202  CA  PRO B   9      15.405  72.466  12.127  1.00 37.12           C  
ATOM   1203  C   PRO B   9      15.102  73.490  13.221  1.00 36.29           C  
ATOM   1204  O   PRO B   9      14.687  73.097  14.300  1.00 37.25           O  
ATOM   1205  CB  PRO B   9      16.903  72.105  12.128  1.00 37.21           C  
ATOM   1206  CG  PRO B   9      17.224  71.836  10.723  1.00 38.21           C  
ATOM   1207  CD  PRO B   9      16.418  72.870   9.968  1.00 37.54           C  
ATOM   1208  N   LEU B  10      15.267  74.785  12.943  1.00 35.82           N  
ATOM   1209  CA  LEU B  10      14.981  75.822  13.931  1.00 34.62           C  
ATOM   1210  C   LEU B  10      13.538  75.891  14.423  1.00 34.40           C  
ATOM   1211  O   LEU B  10      13.292  76.055  15.627  1.00 34.13           O  
ATOM   1212  CB  LEU B  10      15.388  77.217  13.415  1.00 34.49           C  
ATOM   1213  CG  LEU B  10      15.184  78.346  14.416  1.00 34.99           C  
ATOM   1214  CD1 LEU B  10      16.018  78.096  15.699  1.00 32.86           C  
ATOM   1215  CD2 LEU B  10      15.613  79.685  13.792  1.00 34.79           C  
ATOM   1216  N   PHE B  11      12.589  75.817  13.499  1.00 33.09           N  
ATOM   1217  CA  PHE B  11      11.202  75.986  13.871  1.00 33.16           C  
ATOM   1218  C   PHE B  11      10.405  74.676  13.794  1.00 32.88           C  
ATOM   1219  O   PHE B  11       9.216  74.676  14.070  1.00 32.74           O  
ATOM   1220  CB  PHE B  11      10.549  77.067  13.011  1.00 32.51           C  
ATOM   1221  CG  PHE B  11      11.168  78.438  13.157  1.00 33.60           C  
ATOM   1222  CD1 PHE B  11      11.291  79.045  14.409  1.00 32.31           C  
ATOM   1223  CD2 PHE B  11      11.570  79.151  12.022  1.00 33.60           C  
ATOM   1224  CE1 PHE B  11      11.830  80.333  14.537  1.00 35.79           C  
ATOM   1225  CE2 PHE B  11      12.130  80.419  12.137  1.00 34.16           C  
ATOM   1226  CZ  PHE B  11      12.250  81.019  13.382  1.00 34.01           C  
ATOM   1227  N   ALA B  12      11.067  73.581  13.424  1.00 32.91           N  
ATOM   1228  CA  ALA B  12      10.391  72.301  13.134  1.00 34.41           C  
ATOM   1229  C   ALA B  12       9.594  71.704  14.304  1.00 35.01           C  
ATOM   1230  O   ALA B  12       8.717  70.863  14.088  1.00 34.77           O  
ATOM   1231  CB  ALA B  12      11.378  71.279  12.605  1.00 34.11           C  
ATOM   1232  N   ALA B  13       9.922  72.131  15.524  1.00 35.78           N  
ATOM   1233  CA  ALA B  13       9.287  71.650  16.759  1.00 37.53           C  
ATOM   1234  C   ALA B  13       7.915  72.244  17.026  1.00 37.95           C  
ATOM   1235  O   ALA B  13       7.078  71.579  17.650  1.00 38.90           O  
ATOM   1236  CB  ALA B  13      10.183  71.926  17.970  1.00 37.47           C  
ATOM   1237  N   LEU B  14       7.712  73.489  16.592  1.00 37.75           N  
ATOM   1238  CA  LEU B  14       6.523  74.268  16.899  1.00 38.26           C  
ATOM   1239  C   LEU B  14       5.204  73.616  16.461  1.00 38.46           C  
ATOM   1240  O   LEU B  14       5.177  72.820  15.509  1.00 37.62           O  
ATOM   1241  CB  LEU B  14       6.609  75.654  16.252  1.00 38.20           C  
ATOM   1242  CG  LEU B  14       7.729  76.677  16.520  1.00 39.82           C  
ATOM   1243  CD1 LEU B  14       7.353  77.972  15.832  1.00 40.56           C  
ATOM   1244  CD2 LEU B  14       7.937  76.930  18.001  1.00 42.42           C  
ATOM   1245  N   ASP B  15       4.112  73.981  17.139  1.00 39.22           N  
ATOM   1246  CA  ASP B  15       2.777  73.515  16.735  1.00 40.34           C  
ATOM   1247  C   ASP B  15       2.103  74.495  15.773  1.00 40.64           C  
ATOM   1248  O   ASP B  15       2.626  75.583  15.521  1.00 40.83           O  
ATOM   1249  CB  ASP B  15       1.892  73.168  17.945  1.00 40.75           C  
ATOM   1250  CG  ASP B  15       1.599  74.369  18.847  1.00 42.37           C  
ATOM   1251  OD1 ASP B  15       0.944  75.339  18.385  1.00 43.67           O  
ATOM   1252  OD2 ASP B  15       1.996  74.304  20.031  1.00 42.65           O  
ATOM   1253  N   ASP B  16       0.949  74.095  15.240  1.00 41.22           N  
ATOM   1254  CA  ASP B  16       0.230  74.842  14.205  1.00 41.48           C  
ATOM   1255  C   ASP B  16      -0.100  76.298  14.562  1.00 41.93           C  
ATOM   1256  O   ASP B  16       0.063  77.194  13.730  1.00 41.60           O  
ATOM   1257  CB  ASP B  16      -1.051  74.083  13.805  1.00 41.79           C  
ATOM   1258  CG  ASP B  16      -0.763  72.689  13.239  1.00 42.35           C  
ATOM   1259  OD1 ASP B  16       0.411  72.388  12.936  1.00 43.52           O  
ATOM   1260  OD2 ASP B  16      -1.710  71.882  13.102  1.00 43.15           O  
ATOM   1261  N   GLU B  17      -0.562  76.534  15.790  1.00 42.49           N  
ATOM   1262  CA  GLU B  17      -0.990  77.876  16.195  1.00 43.17           C  
ATOM   1263  C   GLU B  17       0.202  78.805  16.404  1.00 42.19           C  
ATOM   1264  O   GLU B  17       0.167  79.961  15.991  1.00 41.99           O  
ATOM   1265  CB  GLU B  17      -1.883  77.842  17.444  1.00 43.35           C  
ATOM   1266  CG  GLU B  17      -2.614  79.171  17.723  1.00 44.92           C  
ATOM   1267  CD  GLU B  17      -3.603  79.096  18.890  1.00 44.78           C  
ATOM   1268  OE1 GLU B  17      -4.479  78.205  18.885  1.00 46.37           O  
ATOM   1269  OE2 GLU B  17      -3.512  79.944  19.808  1.00 48.12           O  
ATOM   1270  N   GLN B  18       1.259  78.292  17.024  1.00 42.02           N  
ATOM   1271  CA  GLN B  18       2.463  79.092  17.228  1.00 42.04           C  
ATOM   1272  C   GLN B  18       3.262  79.416  15.958  1.00 41.61           C  
ATOM   1273  O   GLN B  18       3.985  80.422  15.923  1.00 41.50           O  
ATOM   1274  CB  GLN B  18       3.345  78.543  18.366  1.00 42.12           C  
ATOM   1275  CG  GLN B  18       3.924  77.160  18.191  1.00 42.67           C  
ATOM   1276  CD  GLN B  18       4.383  76.557  19.518  1.00 42.50           C  
ATOM   1277  OE1 GLN B  18       4.914  75.430  19.572  1.00 43.47           O  
ATOM   1278  NE2 GLN B  18       4.162  77.296  20.599  1.00 40.17           N  
ATOM   1279  N   SER B  19       3.118  78.602  14.909  1.00 41.05           N  
ATOM   1280  CA  SER B  19       3.711  78.942  13.617  1.00 40.76           C  
ATOM   1281  C   SER B  19       2.911  80.040  12.908  1.00 40.07           C  
ATOM   1282  O   SER B  19       3.499  80.963  12.337  1.00 40.05           O  
ATOM   1283  CB  SER B  19       3.847  77.710  12.706  1.00 41.51           C  
ATOM   1284  OG  SER B  19       3.984  76.534  13.487  1.00 43.94           O  
ATOM   1285  N   ALA B  20       1.577  79.945  12.953  1.00 39.27           N  
ATOM   1286  CA  ALA B  20       0.699  80.938  12.328  1.00 38.18           C  
ATOM   1287  C   ALA B  20       0.908  82.339  12.916  1.00 37.73           C  
ATOM   1288  O   ALA B  20       0.918  83.345  12.193  1.00 36.83           O  
ATOM   1289  CB  ALA B  20      -0.775  80.512  12.462  1.00 38.80           C  
ATOM   1290  N   GLU B  21       1.041  82.388  14.233  1.00 37.06           N  
ATOM   1291  CA  GLU B  21       1.369  83.624  14.938  1.00 37.93           C  
ATOM   1292  C   GLU B  21       2.738  84.133  14.489  1.00 37.97           C  
ATOM   1293  O   GLU B  21       2.856  85.278  14.056  1.00 39.05           O  
ATOM   1294  CB  GLU B  21       1.410  83.383  16.440  1.00 37.30           C  
ATOM   1295  CG  GLU B  21       0.050  83.347  17.118  1.00 37.86           C  
ATOM   1296  CD  GLU B  21       0.170  83.082  18.605  1.00 37.55           C  
ATOM   1297  OE1 GLU B  21       1.311  82.911  19.113  1.00 38.71           O  
ATOM   1298  OE2 GLU B  21      -0.879  83.017  19.261  1.00 39.27           O  
ATOM   1299  N   LEU B  22       3.758  83.272  14.590  1.00 38.53           N  
ATOM   1300  CA  LEU B  22       5.124  83.604  14.151  1.00 38.12           C  
ATOM   1301  C   LEU B  22       5.080  84.184  12.741  1.00 38.49           C  
ATOM   1302  O   LEU B  22       5.570  85.279  12.525  1.00 38.59           O  
ATOM   1303  CB  LEU B  22       6.052  82.384  14.240  1.00 37.98           C  
ATOM   1304  CG  LEU B  22       7.464  82.436  13.608  1.00 39.19           C  
ATOM   1305  CD1 LEU B  22       8.300  83.581  14.167  1.00 37.84           C  
ATOM   1306  CD2 LEU B  22       8.199  81.129  13.779  1.00 38.20           C  
ATOM   1307  N   ARG B  23       4.453  83.476  11.800  1.00 38.17           N  
ATOM   1308  CA  ARG B  23       4.287  83.993  10.427  1.00 39.05           C  
ATOM   1309  C   ARG B  23       3.732  85.421  10.356  1.00 39.33           C  
ATOM   1310  O   ARG B  23       4.282  86.266   9.653  1.00 40.39           O  
ATOM   1311  CB  ARG B  23       3.354  83.087   9.638  1.00 38.89           C  
ATOM   1312  CG  ARG B  23       3.999  82.279   8.570  1.00 39.36           C  
ATOM   1313  CD  ARG B  23       2.948  81.405   7.901  1.00 39.77           C  
ATOM   1314  NE  ARG B  23       2.797  80.149   8.620  1.00 40.76           N  
ATOM   1315  CZ  ARG B  23       1.655  79.628   9.044  1.00 40.81           C  
ATOM   1316  NH1 ARG B  23       0.486  80.222   8.813  1.00 41.37           N  
ATOM   1317  NH2 ARG B  23       1.692  78.471   9.680  1.00 41.69           N  
ATOM   1318  N   ALA B  24       2.637  85.680  11.065  1.00 39.77           N  
ATOM   1319  CA  ALA B  24       1.908  86.970  10.965  1.00 40.13           C  
ATOM   1320  C   ALA B  24       2.620  88.133  11.665  1.00 40.53           C  
ATOM   1321  O   ALA B  24       2.284  89.300  11.459  1.00 40.89           O  
ATOM   1322  CB  ALA B  24       0.492  86.822  11.500  1.00 39.45           C  
ATOM   1323  N   SER B  25       3.578  87.779  12.505  1.00 41.07           N  
ATOM   1324  CA  SER B  25       4.476  88.705  13.189  1.00 42.29           C  
ATOM   1325  C   SER B  25       5.767  89.018  12.413  1.00 42.91           C  
ATOM   1326  O   SER B  25       6.432  90.026  12.697  1.00 43.60           O  
ATOM   1327  CB  SER B  25       4.856  88.115  14.548  1.00 41.69           C  
ATOM   1328  OG  SER B  25       3.857  88.424  15.520  1.00 44.52           O  
HETATM 1329  N   MSE B  26       6.148  88.147  11.476  1.00 42.08           N  
HETATM 1330  CA  MSE B  26       7.325  88.412  10.637  1.00 42.55           C  
HETATM 1331  C   MSE B  26       7.003  89.495   9.606  1.00 41.97           C  
HETATM 1332  O   MSE B  26       5.833  89.755   9.328  1.00 41.24           O  
HETATM 1333  CB  MSE B  26       7.820  87.115   9.987  1.00 41.81           C  
HETATM 1334  CG  MSE B  26       8.282  86.090  11.023  1.00 42.45           C  
HETATM 1335 SE   MSE B  26       8.596  84.310  10.301  1.00 46.37          SE  
HETATM 1336  CE  MSE B  26      10.305  84.712   9.443  1.00 44.44           C  
ATOM   1337  N   SER B  27       8.021  90.160   9.061  1.00 41.90           N  
ATOM   1338  CA  SER B  27       7.784  91.151   8.003  1.00 42.19           C  
ATOM   1339  C   SER B  27       8.009  90.513   6.644  1.00 41.70           C  
ATOM   1340  O   SER B  27       8.945  89.727   6.461  1.00 40.94           O  
ATOM   1341  CB  SER B  27       8.709  92.360   8.128  1.00 42.57           C  
ATOM   1342  OG  SER B  27       9.013  92.664   9.471  1.00 46.04           O  
ATOM   1343  N   GLU B  28       7.138  90.848   5.701  1.00 41.47           N  
ATOM   1344  CA  GLU B  28       7.273  90.465   4.299  1.00 41.55           C  
ATOM   1345  C   GLU B  28       8.353  91.331   3.638  1.00 40.83           C  
ATOM   1346  O   GLU B  28       8.383  92.549   3.842  1.00 40.35           O  
ATOM   1347  CB  GLU B  28       5.934  90.661   3.577  1.00 41.52           C  
ATOM   1348  CG  GLU B  28       5.931  90.278   2.097  1.00 43.22           C  
ATOM   1349  CD  GLU B  28       4.824  90.976   1.301  1.00 43.30           C  
ATOM   1350  OE1 GLU B  28       3.640  90.902   1.703  1.00 46.14           O  
ATOM   1351  OE2 GLU B  28       5.139  91.603   0.264  1.00 45.92           O  
ATOM   1352  N   VAL B  29       9.237  90.692   2.869  1.00 40.04           N  
ATOM   1353  CA  VAL B  29      10.244  91.382   2.051  1.00 39.71           C  
ATOM   1354  C   VAL B  29      10.147  90.925   0.594  1.00 39.44           C  
ATOM   1355  O   VAL B  29      10.004  89.735   0.325  1.00 39.25           O  
ATOM   1356  CB  VAL B  29      11.695  91.112   2.566  1.00 39.89           C  
ATOM   1357  CG1 VAL B  29      12.739  91.760   1.656  1.00 39.06           C  
ATOM   1358  CG2 VAL B  29      11.846  91.602   3.999  1.00 40.84           C  
ATOM   1359  N   THR B  30      10.241  91.884  -0.329  1.00 38.92           N  
ATOM   1360  CA  THR B  30      10.220  91.631  -1.765  1.00 38.96           C  
ATOM   1361  C   THR B  30      11.504  92.144  -2.427  1.00 38.33           C  
ATOM   1362  O   THR B  30      11.927  93.287  -2.195  1.00 38.09           O  
ATOM   1363  CB  THR B  30       9.002  92.322  -2.433  1.00 38.90           C  
ATOM   1364  OG1 THR B  30       7.810  91.969  -1.724  1.00 39.61           O  
ATOM   1365  CG2 THR B  30       8.852  91.888  -3.885  1.00 40.04           C  
ATOM   1366  N   LEU B  31      12.107  91.281  -3.249  1.00 37.50           N  
ATOM   1367  CA  LEU B  31      13.291  91.596  -4.037  1.00 36.46           C  
ATOM   1368  C   LEU B  31      12.992  91.316  -5.506  1.00 36.07           C  
ATOM   1369  O   LEU B  31      12.323  90.338  -5.829  1.00 35.74           O  
ATOM   1370  CB  LEU B  31      14.496  90.729  -3.609  1.00 36.19           C  
ATOM   1371  CG  LEU B  31      15.083  90.756  -2.198  1.00 36.27           C  
ATOM   1372  CD1 LEU B  31      16.187  89.688  -2.093  1.00 36.58           C  
ATOM   1373  CD2 LEU B  31      15.615  92.132  -1.802  1.00 35.86           C  
ATOM   1374  N   ALA B  32      13.483  92.182  -6.388  1.00 36.08           N  
ATOM   1375  CA  ALA B  32      13.477  91.893  -7.819  1.00 35.85           C  
ATOM   1376  C   ALA B  32      14.804  91.246  -8.181  1.00 35.88           C  
ATOM   1377  O   ALA B  32      15.819  91.472  -7.510  1.00 35.72           O  
ATOM   1378  CB  ALA B  32      13.253  93.162  -8.642  1.00 36.37           C  
ATOM   1379  N   ARG B  33      14.786  90.429  -9.232  1.00 35.75           N  
ATOM   1380  CA  ARG B  33      15.998  89.833  -9.761  1.00 35.58           C  
ATOM   1381  C   ARG B  33      17.125  90.865  -9.825  1.00 35.95           C  
ATOM   1382  O   ARG B  33      16.967  91.930 -10.437  1.00 36.11           O  
ATOM   1383  CB  ARG B  33      15.745  89.238 -11.144  1.00 35.26           C  
ATOM   1384  CG  ARG B  33      16.953  88.517 -11.663  1.00 34.83           C  
ATOM   1385  CD  ARG B  33      16.715  87.838 -12.981  1.00 34.73           C  
ATOM   1386  NE  ARG B  33      17.982  87.450 -13.597  1.00 33.27           N  
ATOM   1387  CZ  ARG B  33      18.102  86.990 -14.840  1.00 34.09           C  
ATOM   1388  NH1 ARG B  33      17.028  86.868 -15.610  1.00 33.59           N  
ATOM   1389  NH2 ARG B  33      19.296  86.668 -15.318  1.00 32.66           N  
ATOM   1390  N   GLY B  34      18.248  90.548  -9.181  1.00 35.81           N  
ATOM   1391  CA  GLY B  34      19.391  91.454  -9.117  1.00 36.41           C  
ATOM   1392  C   GLY B  34      19.478  92.311  -7.861  1.00 36.93           C  
ATOM   1393  O   GLY B  34      20.511  92.947  -7.615  1.00 37.26           O  
ATOM   1394  N   ASP B  35      18.401  92.350  -7.075  1.00 36.90           N  
ATOM   1395  CA  ASP B  35      18.415  93.063  -5.796  1.00 37.23           C  
ATOM   1396  C   ASP B  35      19.377  92.374  -4.814  1.00 36.80           C  
ATOM   1397  O   ASP B  35      19.645  91.171  -4.898  1.00 36.41           O  
ATOM   1398  CB  ASP B  35      17.010  93.179  -5.164  1.00 36.96           C  
ATOM   1399  CG  ASP B  35      16.067  94.132  -5.921  1.00 38.39           C  
ATOM   1400  OD1 ASP B  35      16.410  94.619  -7.019  1.00 36.62           O  
ATOM   1401  OD2 ASP B  35      14.949  94.382  -5.403  1.00 38.44           O  
ATOM   1402  N   THR B  36      19.923  93.173  -3.912  1.00 36.44           N  
ATOM   1403  CA  THR B  36      20.797  92.679  -2.874  1.00 36.46           C  
ATOM   1404  C   THR B  36      19.936  92.569  -1.633  1.00 35.74           C  
ATOM   1405  O   THR B  36      19.235  93.525  -1.263  1.00 35.57           O  
ATOM   1406  CB  THR B  36      21.979  93.647  -2.670  1.00 36.72           C  
ATOM   1407  OG1 THR B  36      22.776  93.660  -3.859  1.00 37.63           O  
ATOM   1408  CG2 THR B  36      22.857  93.194  -1.535  1.00 36.48           C  
ATOM   1409  N   LEU B  37      19.932  91.389  -1.023  1.00 35.09           N  
ATOM   1410  CA  LEU B  37      19.255  91.230   0.254  1.00 33.86           C  
ATOM   1411  C   LEU B  37      20.127  91.894   1.302  1.00 33.96           C  
ATOM   1412  O   LEU B  37      19.631  92.620   2.157  1.00 33.53           O  
ATOM   1413  CB  LEU B  37      19.011  89.758   0.582  1.00 33.79           C  
ATOM   1414  CG  LEU B  37      18.238  89.401   1.854  1.00 31.76           C  
ATOM   1415  CD1 LEU B  37      16.830  89.966   1.818  1.00 32.00           C  
ATOM   1416  CD2 LEU B  37      18.212  87.878   1.951  1.00 33.59           C  
ATOM   1417  N   PHE B  38      21.428  91.646   1.198  1.00 33.81           N  
ATOM   1418  CA  PHE B  38      22.443  92.219   2.082  1.00 33.90           C  
ATOM   1419  C   PHE B  38      23.842  91.997   1.507  1.00 33.94           C  
ATOM   1420  O   PHE B  38      24.050  91.136   0.651  1.00 33.91           O  
ATOM   1421  CB  PHE B  38      22.337  91.693   3.527  1.00 32.23           C  
ATOM   1422  CG  PHE B  38      22.290  90.189   3.638  1.00 32.87           C  
ATOM   1423  CD1 PHE B  38      21.169  89.548   4.161  1.00 31.50           C  
ATOM   1424  CD2 PHE B  38      23.370  89.414   3.235  1.00 32.53           C  
ATOM   1425  CE1 PHE B  38      21.134  88.147   4.265  1.00 31.30           C  
ATOM   1426  CE2 PHE B  38      23.334  88.033   3.326  1.00 33.00           C  
ATOM   1427  CZ  PHE B  38      22.221  87.406   3.845  1.00 32.11           C  
ATOM   1428  N   HIS B  39      24.787  92.802   1.965  1.00 34.81           N  
ATOM   1429  CA  HIS B  39      26.166  92.735   1.515  1.00 35.73           C  
ATOM   1430  C   HIS B  39      27.030  92.074   2.585  1.00 35.91           C  
ATOM   1431  O   HIS B  39      26.801  92.257   3.773  1.00 35.88           O  
ATOM   1432  CB  HIS B  39      26.688  94.144   1.244  1.00 36.16           C  
ATOM   1433  CG  HIS B  39      26.147  94.761  -0.006  1.00 37.81           C  
ATOM   1434  ND1 HIS B  39      25.126  95.690  -0.001  1.00 39.87           N  
ATOM   1435  CD2 HIS B  39      26.491  94.588  -1.304  1.00 38.95           C  
ATOM   1436  CE1 HIS B  39      24.858  96.051  -1.243  1.00 38.66           C  
ATOM   1437  NE2 HIS B  39      25.672  95.400  -2.051  1.00 37.42           N  
ATOM   1438  N   GLU B  40      28.020  91.293   2.173  1.00 36.56           N  
ATOM   1439  CA  GLU B  40      28.937  90.667   3.134  1.00 37.13           C  
ATOM   1440  C   GLU B  40      29.524  91.767   4.008  1.00 37.47           C  
ATOM   1441  O   GLU B  40      29.992  92.770   3.492  1.00 37.16           O  
ATOM   1442  CB  GLU B  40      30.067  89.936   2.390  1.00 36.97           C  
ATOM   1443  CG  GLU B  40      30.967  89.068   3.282  1.00 37.14           C  
ATOM   1444  CD  GLU B  40      32.067  88.325   2.507  1.00 38.68           C  
ATOM   1445  OE1 GLU B  40      32.143  88.437   1.263  1.00 39.79           O  
ATOM   1446  OE2 GLU B  40      32.865  87.620   3.153  1.00 40.92           O  
ATOM   1447  N   GLY B  41      29.511  91.590   5.327  1.00 38.23           N  
ATOM   1448  CA  GLY B  41      30.052  92.628   6.216  1.00 38.72           C  
ATOM   1449  C   GLY B  41      29.005  93.552   6.828  1.00 39.07           C  
ATOM   1450  O   GLY B  41      29.192  94.062   7.938  1.00 39.80           O  
ATOM   1451  N   ASP B  42      27.898  93.759   6.115  1.00 39.11           N  
ATOM   1452  CA  ASP B  42      26.746  94.513   6.631  1.00 38.77           C  
ATOM   1453  C   ASP B  42      26.375  94.068   8.042  1.00 37.51           C  
ATOM   1454  O   ASP B  42      26.430  92.894   8.337  1.00 37.62           O  
ATOM   1455  CB  ASP B  42      25.507  94.265   5.771  1.00 39.09           C  
ATOM   1456  CG  ASP B  42      25.479  95.085   4.518  1.00 40.72           C  
ATOM   1457  OD1 ASP B  42      26.488  95.750   4.209  1.00 41.22           O  
ATOM   1458  OD2 ASP B  42      24.423  95.064   3.836  1.00 42.64           O  
ATOM   1459  N   PRO B  43      25.968  95.015   8.910  1.00 36.94           N  
ATOM   1460  CA  PRO B  43      25.431  94.559  10.179  1.00 36.06           C  
ATOM   1461  C   PRO B  43      24.194  93.699   9.891  1.00 35.97           C  
ATOM   1462  O   PRO B  43      23.402  94.042   9.020  1.00 36.28           O  
ATOM   1463  CB  PRO B  43      25.040  95.850  10.902  1.00 36.30           C  
ATOM   1464  CG  PRO B  43      25.754  96.982  10.170  1.00 36.35           C  
ATOM   1465  CD  PRO B  43      25.986  96.497   8.773  1.00 36.50           C  
ATOM   1466  N   GLY B  44      24.047  92.568  10.575  1.00 35.04           N  
ATOM   1467  CA  GLY B  44      22.839  91.750  10.389  1.00 33.97           C  
ATOM   1468  C   GLY B  44      22.165  91.494  11.707  1.00 33.40           C  
ATOM   1469  O   GLY B  44      22.848  91.192  12.690  1.00 33.32           O  
ATOM   1470  N   ASP B  45      20.837  91.600  11.746  1.00 33.16           N  
ATOM   1471  CA  ASP B  45      20.092  91.278  12.968  1.00 33.67           C  
ATOM   1472  C   ASP B  45      18.823  90.467  12.725  1.00 33.16           C  
ATOM   1473  O   ASP B  45      17.949  90.445  13.590  1.00 33.62           O  
ATOM   1474  CB  ASP B  45      19.639  92.559  13.696  1.00 34.29           C  
ATOM   1475  CG  ASP B  45      18.461  93.250  12.977  1.00 36.58           C  
ATOM   1476  OD1 ASP B  45      18.524  93.318  11.743  1.00 38.67           O  
ATOM   1477  OD2 ASP B  45      17.480  93.694  13.625  1.00 41.06           O  
ATOM   1478  N   ARG B  46      18.688  89.838  11.568  1.00 32.64           N  
ATOM   1479  CA  ARG B  46      17.462  89.119  11.253  0.50 32.66           C  
ATOM   1481  C   ARG B  46      17.697  87.905  10.400  1.00 32.65           C  
ATOM   1482  O   ARG B  46      18.628  87.884   9.601  1.00 32.91           O  
ATOM   1483  CB  ARG B  46      16.452  90.024  10.545  0.50 32.70           C  
ATOM   1485  CG  ARG B  46      16.903  90.686   9.250  0.50 31.94           C  
ATOM   1487  CD  ARG B  46      15.922  91.852   8.978  0.50 33.85           C  
ATOM   1489  NE  ARG B  46      15.838  92.651  10.192  0.50 34.55           N  
ATOM   1491  CZ  ARG B  46      14.733  93.189  10.700  0.50 36.39           C  
ATOM   1493  NH1 ARG B  46      14.825  93.876  11.834  0.50 33.48           N  
ATOM   1495  NH2 ARG B  46      13.552  93.037  10.096  0.50 35.41           N  
ATOM   1497  N   LEU B  47      16.864  86.906  10.582  1.00 33.15           N  
ATOM   1498  CA  LEU B  47      16.801  85.767   9.748  1.00 33.67           C  
ATOM   1499  C   LEU B  47      15.677  85.949   8.763  1.00 33.41           C  
ATOM   1500  O   LEU B  47      14.780  86.683   9.031  1.00 32.69           O  
ATOM   1501  CB  LEU B  47      16.652  84.484  10.563  1.00 34.08           C  
ATOM   1502  CG  LEU B  47      15.400  83.911  11.216  1.00 35.68           C  
ATOM   1503  CD1 LEU B  47      14.264  83.727  10.314  1.00 34.81           C  
ATOM   1504  CD2 LEU B  47      15.676  82.630  11.951  1.00 35.63           C  
ATOM   1505  N   TYR B  48      15.772  85.277   7.630  1.00 32.53           N  
ATOM   1506  CA  TYR B  48      14.729  85.265   6.619  1.00 33.50           C  
ATOM   1507  C   TYR B  48      14.374  83.834   6.325  1.00 32.81           C  
ATOM   1508  O   TYR B  48      15.236  82.971   6.412  1.00 33.65           O  
ATOM   1509  CB  TYR B  48      15.226  85.873   5.314  1.00 33.52           C  
ATOM   1510  CG  TYR B  48      15.734  87.279   5.423  1.00 34.29           C  
ATOM   1511  CD1 TYR B  48      14.887  88.363   5.230  1.00 33.16           C  
ATOM   1512  CD2 TYR B  48      17.071  87.531   5.706  1.00 34.99           C  
ATOM   1513  CE1 TYR B  48      15.365  89.667   5.326  1.00 34.64           C  
ATOM   1514  CE2 TYR B  48      17.555  88.820   5.792  1.00 33.87           C  
ATOM   1515  CZ  TYR B  48      16.707  89.876   5.603  1.00 35.24           C  
ATOM   1516  OH  TYR B  48      17.214  91.144   5.698  1.00 35.69           O  
ATOM   1517  N   VAL B  49      13.117  83.588   5.981  1.00 32.63           N  
ATOM   1518  CA  VAL B  49      12.726  82.338   5.333  1.00 32.86           C  
ATOM   1519  C   VAL B  49      12.247  82.719   3.930  1.00 32.35           C  
ATOM   1520  O   VAL B  49      11.305  83.496   3.779  1.00 33.02           O  
ATOM   1521  CB  VAL B  49      11.611  81.565   6.102  1.00 33.06           C  
ATOM   1522  CG1 VAL B  49      11.281  80.248   5.394  1.00 32.36           C  
ATOM   1523  CG2 VAL B  49      12.037  81.311   7.579  1.00 35.04           C  
ATOM   1524  N   VAL B  50      12.919  82.204   2.908  1.00 32.00           N  
ATOM   1525  CA  VAL B  50      12.432  82.346   1.528  1.00 31.98           C  
ATOM   1526  C   VAL B  50      11.053  81.668   1.359  1.00 31.88           C  
ATOM   1527  O   VAL B  50      10.850  80.517   1.771  1.00 32.49           O  
ATOM   1528  CB  VAL B  50      13.459  81.817   0.492  1.00 31.74           C  
ATOM   1529  CG1 VAL B  50      12.923  81.940  -0.930  1.00 30.57           C  
ATOM   1530  CG2 VAL B  50      14.760  82.590   0.610  1.00 31.92           C  
ATOM   1531  N   THR B  51      10.108  82.402   0.786  1.00 32.19           N  
ATOM   1532  CA  THR B  51       8.759  81.881   0.514  1.00 32.34           C  
ATOM   1533  C   THR B  51       8.548  81.619  -0.978  1.00 33.04           C  
ATOM   1534  O   THR B  51       7.769  80.738  -1.363  1.00 33.17           O  
ATOM   1535  CB  THR B  51       7.651  82.812   1.076  1.00 32.42           C  
ATOM   1536  OG1 THR B  51       7.703  84.078   0.415  1.00 31.87           O  
ATOM   1537  CG2 THR B  51       7.846  83.029   2.576  1.00 31.52           C  
ATOM   1538  N   GLU B  52       9.223  82.402  -1.816  1.00 33.52           N  
ATOM   1539  CA  GLU B  52       9.342  82.092  -3.246  1.00 34.01           C  
ATOM   1540  C   GLU B  52      10.563  82.747  -3.888  1.00 33.75           C  
ATOM   1541  O   GLU B  52      11.002  83.823  -3.471  1.00 33.69           O  
ATOM   1542  CB  GLU B  52       8.075  82.460  -4.017  1.00 34.83           C  
ATOM   1543  CG  GLU B  52       7.556  83.858  -3.765  1.00 36.77           C  
ATOM   1544  CD  GLU B  52       6.364  84.183  -4.634  1.00 39.49           C  
ATOM   1545  OE1 GLU B  52       5.223  84.124  -4.122  1.00 40.79           O  
ATOM   1546  OE2 GLU B  52       6.568  84.477  -5.833  1.00 41.00           O  
ATOM   1547  N   GLY B  53      11.098  82.093  -4.908  1.00 33.38           N  
ATOM   1548  CA  GLY B  53      12.241  82.620  -5.638  1.00 33.05           C  
ATOM   1549  C   GLY B  53      13.542  82.075  -5.078  1.00 32.82           C  
ATOM   1550  O   GLY B  53      13.526  81.251  -4.158  1.00 32.33           O  
ATOM   1551  N   LYS B  54      14.661  82.532  -5.638  1.00 32.85           N  
ATOM   1552  CA  LYS B  54      15.989  82.038  -5.255  1.00 33.07           C  
ATOM   1553  C   LYS B  54      16.984  83.158  -4.936  1.00 32.83           C  
ATOM   1554  O   LYS B  54      17.033  84.184  -5.637  1.00 32.38           O  
ATOM   1555  CB  LYS B  54      16.555  81.117  -6.337  1.00 33.30           C  
ATOM   1556  CG  LYS B  54      15.867  79.748  -6.401  1.00 34.24           C  
ATOM   1557  CD  LYS B  54      16.414  78.874  -7.514  1.00 34.61           C  
ATOM   1558  CE  LYS B  54      15.682  77.533  -7.536  1.00 36.88           C  
ATOM   1559  NZ  LYS B  54      16.226  76.635  -8.588  1.00 39.35           N  
ATOM   1560  N   VAL B  55      17.755  82.951  -3.860  1.00 32.29           N  
ATOM   1561  CA  VAL B  55      18.813  83.868  -3.446  1.00 31.34           C  
ATOM   1562  C   VAL B  55      20.168  83.153  -3.519  1.00 32.54           C  
ATOM   1563  O   VAL B  55      20.360  82.056  -2.951  1.00 32.14           O  
ATOM   1564  CB  VAL B  55      18.587  84.431  -2.013  1.00 31.63           C  
ATOM   1565  CG1 VAL B  55      19.687  85.415  -1.623  1.00 28.95           C  
ATOM   1566  CG2 VAL B  55      17.220  85.107  -1.896  1.00 29.43           C  
ATOM   1567  N   LYS B  56      21.095  83.784  -4.232  1.00 32.06           N  
ATOM   1568  CA  LYS B  56      22.477  83.339  -4.274  1.00 33.38           C  
ATOM   1569  C   LYS B  56      23.296  83.966  -3.139  1.00 33.26           C  
ATOM   1570  O   LYS B  56      23.304  85.190  -2.971  1.00 33.56           O  
ATOM   1571  CB  LYS B  56      23.084  83.660  -5.646  1.00 32.86           C  
ATOM   1572  CG  LYS B  56      24.577  83.384  -5.782  1.00 34.10           C  
ATOM   1573  CD  LYS B  56      25.031  83.509  -7.241  1.00 34.86           C  
ATOM   1574  CE  LYS B  56      24.736  84.889  -7.873  1.00 36.05           C  
ATOM   1575  NZ  LYS B  56      25.166  84.924  -9.331  1.00 36.16           N  
ATOM   1576  N   LEU B  57      23.966  83.119  -2.360  1.00 33.61           N  
ATOM   1577  CA  LEU B  57      24.919  83.585  -1.358  1.00 34.61           C  
ATOM   1578  C   LEU B  57      26.334  83.312  -1.822  1.00 36.05           C  
ATOM   1579  O   LEU B  57      26.685  82.183  -2.182  1.00 35.57           O  
ATOM   1580  CB  LEU B  57      24.670  82.942   0.004  1.00 34.95           C  
ATOM   1581  CG  LEU B  57      23.298  83.155   0.622  1.00 35.92           C  
ATOM   1582  CD1 LEU B  57      23.244  82.284   1.835  1.00 37.75           C  
ATOM   1583  CD2 LEU B  57      23.062  84.617   1.000  1.00 36.06           C  
ATOM   1584  N   HIS B  58      27.131  84.369  -1.835  1.00 37.73           N  
ATOM   1585  CA  HIS B  58      28.498  84.309  -2.312  1.00 39.73           C  
ATOM   1586  C   HIS B  58      29.353  85.209  -1.436  1.00 41.43           C  
ATOM   1587  O   HIS B  58      28.878  86.249  -0.965  1.00 41.30           O  
ATOM   1588  CB  HIS B  58      28.575  84.755  -3.773  1.00 39.52           C  
ATOM   1589  CG  HIS B  58      27.857  86.037  -4.044  1.00 39.48           C  
ATOM   1590  ND1 HIS B  58      28.492  87.258  -4.042  1.00 40.07           N  
ATOM   1591  CD2 HIS B  58      26.554  86.289  -4.310  1.00 38.64           C  
ATOM   1592  CE1 HIS B  58      27.614  88.207  -4.303  1.00 39.54           C  
ATOM   1593  NE2 HIS B  58      26.427  87.646  -4.451  1.00 39.89           N  
ATOM   1594  N   ARG B  59      30.596  84.798  -1.192  1.00 43.13           N  
ATOM   1595  CA  ARG B  59      31.524  85.636  -0.441  1.00 45.13           C  
ATOM   1596  C   ARG B  59      32.797  85.913  -1.233  1.00 45.92           C  
ATOM   1597  O   ARG B  59      33.043  85.282  -2.255  1.00 45.54           O  
ATOM   1598  CB  ARG B  59      31.777  85.090   0.977  1.00 45.38           C  
ATOM   1599  CG  ARG B  59      32.653  83.864   1.121  1.00 47.93           C  
ATOM   1600  CD  ARG B  59      33.152  83.808   2.576  1.00 51.05           C  
ATOM   1601  NE  ARG B  59      34.233  82.849   2.807  1.00 53.12           N  
ATOM   1602  CZ  ARG B  59      35.496  82.984   2.395  1.00 54.00           C  
ATOM   1603  NH1 ARG B  59      35.889  84.043   1.690  1.00 54.38           N  
ATOM   1604  NH2 ARG B  59      36.378  82.035   2.686  1.00 54.32           N  
ATOM   1605  N   THR B  60      33.587  86.877  -0.780  1.00 47.34           N  
ATOM   1606  CA  THR B  60      34.624  87.450  -1.635  1.00 48.64           C  
ATOM   1607  C   THR B  60      36.023  87.073  -1.167  1.00 49.76           C  
ATOM   1608  O   THR B  60      36.337  87.158   0.016  1.00 50.36           O  
ATOM   1609  CB  THR B  60      34.432  88.973  -1.766  1.00 48.70           C  
ATOM   1610  OG1 THR B  60      33.063  89.233  -2.094  1.00 48.33           O  
ATOM   1611  CG2 THR B  60      35.323  89.561  -2.860  1.00 48.74           C  
ATOM   1612  N   SER B  61      36.853  86.654  -2.116  1.00 51.12           N  
ATOM   1613  CA  SER B  61      38.162  86.071  -1.827  1.00 52.02           C  
ATOM   1614  C   SER B  61      39.287  87.091  -2.090  1.00 52.52           C  
ATOM   1615  O   SER B  61      39.019  88.144  -2.682  1.00 52.64           O  
ATOM   1616  CB  SER B  61      38.328  84.816  -2.688  1.00 52.10           C  
ATOM   1617  OG  SER B  61      39.222  83.880  -2.102  1.00 53.02           O  
ATOM   1618  N   PRO B  62      40.539  86.800  -1.630  1.00 53.00           N  
ATOM   1619  CA  PRO B  62      41.706  87.665  -1.795  1.00 53.21           C  
ATOM   1620  C   PRO B  62      41.701  88.596  -3.012  1.00 53.58           C  
ATOM   1621  O   PRO B  62      41.556  89.811  -2.845  1.00 53.62           O  
ATOM   1622  CB  PRO B  62      42.856  86.658  -1.901  1.00 53.35           C  
ATOM   1623  CG  PRO B  62      42.451  85.550  -1.002  1.00 52.79           C  
ATOM   1624  CD  PRO B  62      40.918  85.598  -0.849  1.00 53.06           C  
ATOM   1625  N   ASP B  63      41.842  88.035  -4.213  1.00 53.70           N  
ATOM   1626  CA  ASP B  63      41.991  88.847  -5.426  1.00 53.98           C  
ATOM   1627  C   ASP B  63      40.791  89.751  -5.743  1.00 54.09           C  
ATOM   1628  O   ASP B  63      40.871  90.601  -6.640  1.00 54.22           O  
ATOM   1629  CB  ASP B  63      42.358  87.966  -6.637  1.00 54.10           C  
ATOM   1630  CG  ASP B  63      41.174  87.167  -7.188  1.00 54.11           C  
ATOM   1631  OD1 ASP B  63      40.007  87.593  -7.042  1.00 52.89           O  
ATOM   1632  OD2 ASP B  63      41.425  86.107  -7.803  1.00 54.47           O  
ATOM   1633  N   GLY B  64      39.699  89.565  -4.994  1.00 54.15           N  
ATOM   1634  CA  GLY B  64      38.418  90.232  -5.248  1.00 54.00           C  
ATOM   1635  C   GLY B  64      37.485  89.258  -5.971  1.00 54.09           C  
ATOM   1636  O   GLY B  64      36.659  89.652  -6.853  1.00 53.92           O  
ATOM   1637  N   ARG B  65      37.629  87.981  -5.572  1.00 54.23           N  
ATOM   1638  CA  ARG B  65      36.969  86.849  -6.228  1.00 54.38           C  
ATOM   1639  C   ARG B  65      35.596  86.569  -5.641  1.00 54.23           C  
ATOM   1640  O   ARG B  65      35.486  86.053  -4.528  1.00 54.02           O  
ATOM   1641  CB  ARG B  65      37.828  85.598  -6.059  1.00 54.59           C  
ATOM   1642  CG  ARG B  65      37.850  84.638  -7.242  1.00 55.34           C  
ATOM   1643  CD  ARG B  65      38.941  83.592  -7.042  1.00 57.08           C  
ATOM   1644  NE  ARG B  65      40.132  84.171  -6.412  1.00 58.88           N  
ATOM   1645  CZ  ARG B  65      40.598  83.842  -5.206  1.00 59.64           C  
ATOM   1646  NH1 ARG B  65      39.996  82.905  -4.480  1.00 60.06           N  
ATOM   1647  NH2 ARG B  65      41.681  84.445  -4.728  1.00 59.72           N  
ATOM   1648  N   GLU B  66      34.559  86.899  -6.405  1.00 54.03           N  
ATOM   1649  CA  GLU B  66      33.204  86.547  -6.032  1.00 54.10           C  
ATOM   1650  C   GLU B  66      33.051  85.026  -6.026  1.00 53.56           C  
ATOM   1651  O   GLU B  66      33.062  84.376  -7.072  1.00 53.58           O  
ATOM   1652  CB  GLU B  66      32.195  87.215  -6.960  1.00 54.32           C  
ATOM   1653  CG  GLU B  66      30.977  87.709  -6.225  1.00 55.80           C  
ATOM   1654  CD  GLU B  66      31.319  88.764  -5.181  1.00 58.01           C  
ATOM   1655  OE1 GLU B  66      31.586  89.919  -5.579  1.00 59.32           O  
ATOM   1656  OE2 GLU B  66      31.313  88.443  -3.968  1.00 59.14           O  
ATOM   1657  N   ASN B  67      32.918  84.478  -4.826  1.00 52.95           N  
ATOM   1658  CA  ASN B  67      32.968  83.043  -4.608  1.00 52.13           C  
ATOM   1659  C   ASN B  67      31.620  82.482  -4.157  1.00 51.49           C  
ATOM   1660  O   ASN B  67      31.128  82.802  -3.075  1.00 51.22           O  
ATOM   1661  CB  ASN B  67      34.054  82.734  -3.577  1.00 52.34           C  
ATOM   1662  CG  ASN B  67      34.560  81.318  -3.667  1.00 53.01           C  
ATOM   1663  OD1 ASN B  67      35.604  81.062  -4.275  1.00 54.00           O  
ATOM   1664  ND2 ASN B  67      33.825  80.382  -3.065  1.00 52.53           N  
HETATM 1665  N   MSE B  68      31.046  81.625  -4.996  1.00 50.71           N  
HETATM 1666  CA  MSE B  68      29.721  81.052  -4.769  1.00 49.89           C  
HETATM 1667  C   MSE B  68      29.675  80.108  -3.574  1.00 48.23           C  
HETATM 1668  O   MSE B  68      30.580  79.306  -3.361  1.00 48.17           O  
HETATM 1669  CB  MSE B  68      29.250  80.338  -6.030  1.00 51.17           C  
HETATM 1670  CG  MSE B  68      27.800  80.612  -6.373  1.00 53.22           C  
HETATM 1671 SE   MSE B  68      26.575  79.368  -5.496  0.75 59.70          SE  
HETATM 1672  CE  MSE B  68      25.458  79.094  -7.093  1.00 54.89           C  
ATOM   1673  N   LEU B  69      28.605  80.204  -2.807  1.00 45.92           N  
ATOM   1674  CA  LEU B  69      28.485  79.574  -1.510  1.00 44.12           C  
ATOM   1675  C   LEU B  69      27.213  78.733  -1.305  1.00 42.57           C  
ATOM   1676  O   LEU B  69      27.259  77.643  -0.810  1.00 42.05           O  
ATOM   1677  CB  LEU B  69      28.658  80.619  -0.424  1.00 44.35           C  
ATOM   1678  CG  LEU B  69      28.628  80.172   0.997  1.00 44.27           C  
ATOM   1679  CD1 LEU B  69      28.536  81.357   1.825  1.00 45.45           C  
ATOM   1680  CD2 LEU B  69      27.389  79.463   1.080  1.00 45.33           C  
ATOM   1681  N   ALA B  70      26.080  79.252  -1.720  1.00 40.50           N  
ATOM   1682  CA  ALA B  70      24.811  78.529  -1.663  1.00 38.73           C  
ATOM   1683  C   ALA B  70      23.730  79.186  -2.517  1.00 37.76           C  
ATOM   1684  O   ALA B  70      23.787  80.388  -2.810  1.00 37.40           O  
ATOM   1685  CB  ALA B  70      24.319  78.413  -0.225  1.00 38.94           C  
ATOM   1686  N   VAL B  71      22.751  78.381  -2.919  1.00 36.15           N  
ATOM   1687  CA  VAL B  71      21.532  78.888  -3.526  1.00 35.48           C  
ATOM   1688  C   VAL B  71      20.385  78.480  -2.630  1.00 35.02           C  
ATOM   1689  O   VAL B  71      20.179  77.294  -2.373  1.00 35.09           O  
ATOM   1690  CB  VAL B  71      21.319  78.392  -4.982  1.00 35.44           C  
ATOM   1691  CG1 VAL B  71      19.911  78.740  -5.466  1.00 35.43           C  
ATOM   1692  CG2 VAL B  71      22.336  79.019  -5.887  1.00 34.84           C  
ATOM   1693  N   VAL B  72      19.668  79.481  -2.135  1.00 34.35           N  
ATOM   1694  CA  VAL B  72      18.649  79.295  -1.100  1.00 33.96           C  
ATOM   1695  C   VAL B  72      17.273  79.488  -1.735  1.00 33.78           C  
ATOM   1696  O   VAL B  72      17.006  80.544  -2.335  1.00 33.90           O  
ATOM   1697  CB  VAL B  72      18.884  80.255   0.107  1.00 33.44           C  
ATOM   1698  CG1 VAL B  72      17.808  80.086   1.141  1.00 33.65           C  
ATOM   1699  CG2 VAL B  72      20.266  80.000   0.760  1.00 34.17           C  
ATOM   1700  N   GLY B  73      16.428  78.454  -1.631  1.00 33.11           N  
ATOM   1701  CA  GLY B  73      15.098  78.446  -2.250  1.00 33.21           C  
ATOM   1702  C   GLY B  73      13.971  78.426  -1.223  1.00 33.32           C  
ATOM   1703  O   GLY B  73      14.234  78.511  -0.027  1.00 32.51           O  
ATOM   1704  N   PRO B  74      12.710  78.310  -1.682  1.00 33.71           N  
ATOM   1705  CA  PRO B  74      11.563  78.318  -0.769  1.00 34.16           C  
ATOM   1706  C   PRO B  74      11.681  77.343   0.415  1.00 34.70           C  
ATOM   1707  O   PRO B  74      12.161  76.214   0.257  1.00 34.84           O  
ATOM   1708  CB  PRO B  74      10.398  77.952  -1.682  1.00 33.82           C  
ATOM   1709  CG  PRO B  74      10.822  78.533  -3.014  1.00 34.04           C  
ATOM   1710  CD  PRO B  74      12.275  78.194  -3.092  1.00 33.85           C  
ATOM   1711  N   SER B  75      11.246  77.826   1.579  1.00 35.43           N  
ATOM   1712  CA  SER B  75      11.271  77.122   2.874  1.00 36.03           C  
ATOM   1713  C   SER B  75      12.659  76.983   3.500  1.00 35.79           C  
ATOM   1714  O   SER B  75      12.829  76.251   4.486  1.00 35.83           O  
ATOM   1715  CB  SER B  75      10.555  75.758   2.793  1.00 36.67           C  
ATOM   1716  OG  SER B  75      11.451  74.712   2.446  1.00 39.65           O  
ATOM   1717  N   GLU B  76      13.640  77.689   2.943  1.00 34.76           N  
ATOM   1718  CA  GLU B  76      14.994  77.644   3.461  1.00 35.28           C  
ATOM   1719  C   GLU B  76      15.340  78.945   4.151  1.00 35.06           C  
ATOM   1720  O   GLU B  76      14.803  80.001   3.798  1.00 35.56           O  
ATOM   1721  CB  GLU B  76      16.016  77.359   2.363  1.00 35.55           C  
ATOM   1722  CG  GLU B  76      16.023  75.937   1.855  1.00 36.68           C  
ATOM   1723  CD  GLU B  76      16.990  75.777   0.684  1.00 40.32           C  
ATOM   1724  OE1 GLU B  76      16.559  75.942  -0.464  1.00 39.31           O  
ATOM   1725  OE2 GLU B  76      18.193  75.532   0.920  1.00 43.71           O  
ATOM   1726  N   LEU B  77      16.242  78.857   5.129  1.00 35.48           N  
ATOM   1727  CA  LEU B  77      16.605  80.003   5.985  1.00 35.49           C  
ATOM   1728  C   LEU B  77      17.861  80.679   5.516  1.00 35.27           C  
ATOM   1729  O   LEU B  77      18.792  80.040   5.025  1.00 34.53           O  
ATOM   1730  CB  LEU B  77      16.882  79.570   7.432  1.00 36.41           C  
ATOM   1731  CG  LEU B  77      15.898  78.745   8.247  1.00 36.94           C  
ATOM   1732  CD1 LEU B  77      16.060  79.115   9.715  1.00 40.40           C  
ATOM   1733  CD2 LEU B  77      14.497  78.967   7.814  1.00 39.34           C  
ATOM   1734  N   ILE B  78      17.879  81.985   5.717  1.00 34.58           N  
ATOM   1735  CA  ILE B  78      19.039  82.816   5.486  1.00 34.43           C  
ATOM   1736  C   ILE B  78      19.324  83.535   6.805  1.00 34.85           C  
ATOM   1737  O   ILE B  78      18.396  84.049   7.425  1.00 35.20           O  
ATOM   1738  CB  ILE B  78      18.753  83.878   4.373  1.00 34.37           C  
ATOM   1739  CG1 ILE B  78      18.406  83.196   3.047  1.00 34.52           C  
ATOM   1740  CG2 ILE B  78      19.932  84.803   4.209  1.00 34.27           C  
ATOM   1741  CD1 ILE B  78      17.929  84.161   1.933  1.00 34.04           C  
ATOM   1742  N   GLY B  79      20.586  83.551   7.229  1.00 34.59           N  
ATOM   1743  CA  GLY B  79      21.010  84.371   8.368  1.00 34.70           C  
ATOM   1744  C   GLY B  79      20.471  83.901   9.699  1.00 34.43           C  
ATOM   1745  O   GLY B  79      20.168  84.700  10.578  1.00 34.53           O  
ATOM   1746  N   GLU B  80      20.352  82.587   9.857  1.00 34.96           N  
ATOM   1747  CA  GLU B  80      19.702  82.023  11.023  1.00 34.82           C  
ATOM   1748  C   GLU B  80      20.255  82.602  12.323  1.00 34.86           C  
ATOM   1749  O   GLU B  80      19.497  83.011  13.200  1.00 37.34           O  
ATOM   1750  CB  GLU B  80      19.819  80.477  11.029  1.00 35.09           C  
ATOM   1751  CG  GLU B  80      19.432  79.872  12.366  1.00 34.52           C  
ATOM   1752  CD  GLU B  80      19.479  78.342  12.396  1.00 36.37           C  
ATOM   1753  OE1 GLU B  80      19.915  77.721  11.421  1.00 40.20           O  
ATOM   1754  OE2 GLU B  80      19.078  77.777  13.415  1.00 39.62           O  
ATOM   1755  N   LEU B  81      21.567  82.644  12.462  1.00 34.64           N  
ATOM   1756  CA  LEU B  81      22.143  82.933  13.765  1.00 35.99           C  
ATOM   1757  C   LEU B  81      22.195  84.436  14.010  1.00 36.13           C  
ATOM   1758  O   LEU B  81      22.408  84.867  15.136  1.00 35.64           O  
ATOM   1759  CB  LEU B  81      23.523  82.298  13.923  1.00 36.65           C  
ATOM   1760  CG  LEU B  81      23.539  80.771  13.849  1.00 38.42           C  
ATOM   1761  CD1 LEU B  81      24.961  80.310  13.822  1.00 41.37           C  
ATOM   1762  CD2 LEU B  81      22.788  80.120  15.010  1.00 42.44           C  
ATOM   1763  N   SER B  82      21.978  85.200  12.936  1.00 35.17           N  
ATOM   1764  CA  SER B  82      21.830  86.657  12.983  1.00 35.07           C  
ATOM   1765  C   SER B  82      20.649  87.063  13.886  1.00 34.48           C  
ATOM   1766  O   SER B  82      20.680  88.109  14.525  1.00 33.85           O  
ATOM   1767  CB  SER B  82      21.629  87.151  11.552  1.00 34.77           C  
ATOM   1768  OG  SER B  82      21.289  88.503  11.534  1.00 40.76           O  
ATOM   1769  N   LEU B  83      19.627  86.208  13.970  1.00 34.01           N  
ATOM   1770  CA  LEU B  83      18.491  86.433  14.859  1.00 33.79           C  
ATOM   1771  C   LEU B  83      18.908  86.469  16.328  1.00 32.67           C  
ATOM   1772  O   LEU B  83      18.484  87.325  17.080  1.00 33.02           O  
ATOM   1773  CB  LEU B  83      17.407  85.359  14.647  1.00 33.93           C  
ATOM   1774  CG  LEU B  83      16.219  85.409  15.609  1.00 35.71           C  
ATOM   1775  CD1 LEU B  83      15.474  86.767  15.510  1.00 35.29           C  
ATOM   1776  CD2 LEU B  83      15.287  84.257  15.314  1.00 37.42           C  
ATOM   1777  N   PHE B  84      19.779  85.547  16.722  1.00 31.36           N  
ATOM   1778  CA  PHE B  84      20.162  85.375  18.108  1.00 30.28           C  
ATOM   1779  C   PHE B  84      21.393  86.129  18.505  1.00 30.20           C  
ATOM   1780  O   PHE B  84      21.525  86.536  19.663  1.00 30.33           O  
ATOM   1781  CB  PHE B  84      20.353  83.852  18.394  1.00 29.60           C  
ATOM   1782  CG  PHE B  84      19.127  83.070  18.094  1.00 31.26           C  
ATOM   1783  CD1 PHE B  84      17.925  83.385  18.743  1.00 29.66           C  
ATOM   1784  CD2 PHE B  84      19.145  82.065  17.130  1.00 33.25           C  
ATOM   1785  CE1 PHE B  84      16.749  82.700  18.447  1.00 30.79           C  
ATOM   1786  CE2 PHE B  84      17.973  81.364  16.819  1.00 33.38           C  
ATOM   1787  CZ  PHE B  84      16.772  81.672  17.474  1.00 31.94           C  
ATOM   1788  N   ASP B  85      22.331  86.254  17.574  1.00 29.27           N  
ATOM   1789  CA  ASP B  85      23.569  86.948  17.851  1.00 30.62           C  
ATOM   1790  C   ASP B  85      23.876  87.879  16.683  1.00 30.71           C  
ATOM   1791  O   ASP B  85      24.652  87.551  15.791  1.00 29.06           O  
ATOM   1792  CB  ASP B  85      24.704  85.955  18.076  1.00 31.35           C  
ATOM   1793  CG  ASP B  85      26.020  86.632  18.267  1.00 33.55           C  
ATOM   1794  OD1 ASP B  85      26.067  87.625  19.048  1.00 31.60           O  
ATOM   1795  OD2 ASP B  85      26.985  86.182  17.609  1.00 32.98           O  
ATOM   1796  N   PRO B  86      23.219  89.046  16.659  1.00 30.79           N  
ATOM   1797  CA  PRO B  86      23.476  89.993  15.567  1.00 30.57           C  
ATOM   1798  C   PRO B  86      24.963  90.262  15.337  1.00 31.06           C  
ATOM   1799  O   PRO B  86      25.723  90.361  16.305  1.00 31.50           O  
ATOM   1800  CB  PRO B  86      22.733  91.253  16.044  1.00 29.95           C  
ATOM   1801  CG  PRO B  86      21.522  90.685  16.757  1.00 30.14           C  
ATOM   1802  CD  PRO B  86      22.162  89.533  17.571  1.00 31.20           C  
ATOM   1803  N   GLY B  87      25.373  90.343  14.070  1.00 30.60           N  
ATOM   1804  CA  GLY B  87      26.780  90.545  13.707  1.00 30.19           C  
ATOM   1805  C   GLY B  87      26.907  90.686  12.209  1.00 30.72           C  
ATOM   1806  O   GLY B  87      25.888  90.707  11.518  1.00 30.09           O  
ATOM   1807  N   PRO B  88      28.152  90.800  11.693  1.00 31.37           N  
ATOM   1808  CA  PRO B  88      28.351  90.974  10.251  1.00 32.53           C  
ATOM   1809  C   PRO B  88      27.943  89.785   9.397  1.00 33.40           C  
ATOM   1810  O   PRO B  88      28.304  88.650   9.683  1.00 33.89           O  
ATOM   1811  CB  PRO B  88      29.863  91.273  10.117  1.00 32.19           C  
ATOM   1812  CG  PRO B  88      30.464  90.839  11.379  1.00 31.92           C  
ATOM   1813  CD  PRO B  88      29.432  90.838  12.441  1.00 31.53           C  
ATOM   1814  N   ARG B  89      27.168  90.070   8.355  1.00 34.53           N  
ATOM   1815  CA  ARG B  89      26.778  89.077   7.358  1.00 35.60           C  
ATOM   1816  C   ARG B  89      28.000  88.349   6.790  1.00 36.02           C  
ATOM   1817  O   ARG B  89      28.926  88.983   6.316  1.00 36.90           O  
ATOM   1818  CB  ARG B  89      26.000  89.779   6.239  1.00 34.62           C  
ATOM   1819  CG  ARG B  89      24.661  90.396   6.691  1.00 34.30           C  
ATOM   1820  CD  ARG B  89      23.647  89.300   7.054  1.00 32.61           C  
ATOM   1821  NE  ARG B  89      22.344  89.853   7.397  1.00 31.88           N  
ATOM   1822  CZ  ARG B  89      21.375  89.194   8.034  1.00 32.72           C  
ATOM   1823  NH1 ARG B  89      21.541  87.943   8.428  1.00 30.74           N  
ATOM   1824  NH2 ARG B  89      20.229  89.796   8.293  1.00 32.86           N  
ATOM   1825  N   THR B  90      28.009  87.015   6.852  1.00 37.57           N  
ATOM   1826  CA  THR B  90      29.145  86.236   6.353  1.00 37.13           C  
ATOM   1827  C   THR B  90      29.163  86.083   4.834  1.00 37.25           C  
ATOM   1828  O   THR B  90      30.024  85.370   4.284  1.00 36.58           O  
ATOM   1829  CB  THR B  90      29.197  84.830   6.973  1.00 38.07           C  
ATOM   1830  OG1 THR B  90      27.921  84.200   6.822  1.00 38.25           O  
ATOM   1831  CG2 THR B  90      29.542  84.905   8.465  1.00 38.66           C  
ATOM   1832  N   ALA B  91      28.216  86.728   4.148  1.00 35.87           N  
ATOM   1833  CA  ALA B  91      28.062  86.525   2.708  1.00 35.36           C  
ATOM   1834  C   ALA B  91      27.177  87.597   2.119  1.00 34.91           C  
ATOM   1835  O   ALA B  91      26.469  88.269   2.853  1.00 35.13           O  
ATOM   1836  CB  ALA B  91      27.481  85.127   2.410  1.00 34.97           C  
ATOM   1837  N   THR B  92      27.232  87.760   0.803  1.00 34.94           N  
ATOM   1838  CA  THR B  92      26.313  88.642   0.088  1.00 35.23           C  
ATOM   1839  C   THR B  92      25.157  87.797  -0.451  1.00 35.25           C  
ATOM   1840  O   THR B  92      25.379  86.714  -1.004  1.00 35.42           O  
ATOM   1841  CB  THR B  92      27.034  89.416  -1.056  1.00 35.26           C  
ATOM   1842  OG1 THR B  92      28.045  90.265  -0.499  1.00 36.34           O  
ATOM   1843  CG2 THR B  92      26.073  90.308  -1.865  1.00 35.03           C  
ATOM   1844  N   GLY B  93      23.928  88.282  -0.267  1.00 34.74           N  
ATOM   1845  CA  GLY B  93      22.747  87.655  -0.854  1.00 34.01           C  
ATOM   1846  C   GLY B  93      22.184  88.413  -2.041  1.00 34.35           C  
ATOM   1847  O   GLY B  93      21.778  89.567  -1.922  1.00 33.57           O  
ATOM   1848  N   THR B  94      22.150  87.756  -3.188  1.00 34.26           N  
ATOM   1849  CA  THR B  94      21.645  88.374  -4.406  1.00 34.90           C  
ATOM   1850  C   THR B  94      20.466  87.571  -4.931  1.00 34.61           C  
ATOM   1851  O   THR B  94      20.546  86.347  -5.052  1.00 34.48           O  
ATOM   1852  CB  THR B  94      22.750  88.486  -5.465  1.00 34.61           C  
ATOM   1853  OG1 THR B  94      23.860  89.189  -4.894  1.00 36.64           O  
ATOM   1854  CG2 THR B  94      22.270  89.240  -6.725  1.00 36.20           C  
ATOM   1855  N   ALA B  95      19.370  88.265  -5.226  1.00 34.24           N  
ATOM   1856  CA  ALA B  95      18.203  87.628  -5.801  1.00 33.93           C  
ATOM   1857  C   ALA B  95      18.521  87.150  -7.204  1.00 34.42           C  
ATOM   1858  O   ALA B  95      18.947  87.943  -8.056  1.00 34.41           O  
ATOM   1859  CB  ALA B  95      17.024  88.604  -5.815  1.00 34.07           C  
ATOM   1860  N   LEU B  96      18.319  85.856  -7.445  1.00 34.47           N  
ATOM   1861  CA  LEU B  96      18.491  85.278  -8.780  1.00 34.93           C  
ATOM   1862  C   LEU B  96      17.223  85.390  -9.598  1.00 34.80           C  
ATOM   1863  O   LEU B  96      17.259  85.288 -10.811  1.00 34.58           O  
ATOM   1864  CB  LEU B  96      18.902  83.803  -8.694  1.00 34.62           C  
ATOM   1865  CG  LEU B  96      20.350  83.531  -8.316  1.00 35.45           C  
ATOM   1866  CD1 LEU B  96      20.574  82.029  -8.252  1.00 36.81           C  
ATOM   1867  CD2 LEU B  96      21.302  84.184  -9.315  1.00 34.93           C  
ATOM   1868  N   THR B  97      16.107  85.584  -8.902  1.00 35.15           N  
ATOM   1869  CA  THR B  97      14.794  85.746  -9.501  1.00 35.74           C  
ATOM   1870  C   THR B  97      14.086  86.818  -8.689  1.00 36.37           C  
ATOM   1871  O   THR B  97      14.671  87.385  -7.742  1.00 37.06           O  
ATOM   1872  CB  THR B  97      13.970  84.442  -9.386  1.00 35.52           C  
ATOM   1873  OG1 THR B  97      13.860  84.076  -8.006  1.00 35.51           O  
ATOM   1874  CG2 THR B  97      14.623  83.286 -10.160  1.00 35.35           C  
ATOM   1875  N   GLU B  98      12.824  87.086  -9.012  1.00 36.24           N  
ATOM   1876  CA  GLU B  98      11.980  87.786  -8.056  1.00 36.70           C  
ATOM   1877  C   GLU B  98      11.837  86.853  -6.845  1.00 36.16           C  
ATOM   1878  O   GLU B  98      11.609  85.646  -6.992  1.00 36.41           O  
ATOM   1879  CB  GLU B  98      10.629  88.154  -8.659  1.00 37.24           C  
ATOM   1880  CG  GLU B  98      10.242  89.625  -8.455  1.00 39.17           C  
ATOM   1881  CD  GLU B  98      10.726  90.567  -9.582  1.00 41.41           C  
ATOM   1882  OE1 GLU B  98      11.552  90.165 -10.448  1.00 42.16           O  
ATOM   1883  OE2 GLU B  98      10.260  91.733  -9.599  1.00 42.51           O  
ATOM   1884  N   VAL B  99      12.029  87.416  -5.662  1.00 35.20           N  
ATOM   1885  CA  VAL B  99      12.071  86.650  -4.424  1.00 34.70           C  
ATOM   1886  C   VAL B  99      11.143  87.280  -3.400  1.00 34.29           C  
ATOM   1887  O   VAL B  99      11.044  88.510  -3.317  1.00 34.18           O  
ATOM   1888  CB  VAL B  99      13.506  86.628  -3.838  1.00 34.03           C  
ATOM   1889  CG1 VAL B  99      13.539  85.984  -2.454  1.00 34.64           C  
ATOM   1890  CG2 VAL B  99      14.464  85.906  -4.772  1.00 33.73           C  
ATOM   1891  N   LYS B 100      10.476  86.437  -2.616  1.00 34.12           N  
ATOM   1892  CA  LYS B 100       9.737  86.906  -1.442  1.00 33.91           C  
ATOM   1893  C   LYS B 100      10.219  86.190  -0.192  1.00 34.18           C  
ATOM   1894  O   LYS B 100      10.474  84.977  -0.220  1.00 33.38           O  
ATOM   1895  CB  LYS B 100       8.232  86.719  -1.625  1.00 34.22           C  
ATOM   1896  CG  LYS B 100       7.613  87.546  -2.775  1.00 34.54           C  
ATOM   1897  CD  LYS B 100       6.120  87.679  -2.571  1.00 35.57           C  
ATOM   1898  CE  LYS B 100       5.471  88.624  -3.601  1.00 38.45           C  
ATOM   1899  NZ  LYS B 100       4.160  89.129  -3.078  1.00 39.26           N  
ATOM   1900  N   LEU B 101      10.356  86.959   0.892  1.00 34.52           N  
ATOM   1901  CA  LEU B 101      10.847  86.456   2.171  1.00 35.32           C  
ATOM   1902  C   LEU B 101       9.989  86.958   3.320  1.00 35.39           C  
ATOM   1903  O   LEU B 101       9.295  87.965   3.194  1.00 35.86           O  
ATOM   1904  CB  LEU B 101      12.324  86.858   2.408  1.00 35.10           C  
ATOM   1905  CG  LEU B 101      13.265  86.796   1.191  1.00 34.69           C  
ATOM   1906  CD1 LEU B 101      13.435  88.179   0.510  1.00 35.59           C  
ATOM   1907  CD2 LEU B 101      14.614  86.227   1.583  1.00 35.09           C  
ATOM   1908  N   LEU B 102      10.035  86.217   4.424  1.00 35.68           N  
ATOM   1909  CA  LEU B 102       9.532  86.638   5.738  1.00 35.37           C  
ATOM   1910  C   LEU B 102      10.749  86.836   6.645  1.00 35.43           C  
ATOM   1911  O   LEU B 102      11.632  85.987   6.694  1.00 35.06           O  
ATOM   1912  CB  LEU B 102       8.607  85.577   6.343  1.00 35.20           C  
ATOM   1913  CG  LEU B 102       7.284  85.288   5.629  1.00 34.87           C  
ATOM   1914  CD1 LEU B 102       6.524  84.168   6.340  1.00 34.73           C  
ATOM   1915  CD2 LEU B 102       6.458  86.561   5.588  1.00 36.23           C  
ATOM   1916  N   ALA B 103      10.772  87.955   7.361  1.00 35.59           N  
ATOM   1917  CA  ALA B 103      11.930  88.366   8.152  1.00 36.25           C  
ATOM   1918  C   ALA B 103      11.570  88.369   9.628  1.00 36.23           C  
ATOM   1919  O   ALA B 103      10.501  88.849  10.002  1.00 35.67           O  
ATOM   1920  CB  ALA B 103      12.371  89.778   7.709  1.00 36.40           C  
ATOM   1921  N   LEU B 104      12.458  87.836  10.463  1.00 36.23           N  
ATOM   1922  CA  LEU B 104      12.283  87.944  11.915  1.00 35.43           C  
ATOM   1923  C   LEU B 104      13.549  88.558  12.520  1.00 34.88           C  
ATOM   1924  O   LEU B 104      14.633  87.975  12.407  1.00 32.27           O  
ATOM   1925  CB  LEU B 104      12.003  86.568  12.522  1.00 35.77           C  
ATOM   1926  CG  LEU B 104      11.605  86.538  13.997  1.00 36.86           C  
ATOM   1927  CD1 LEU B 104      10.240  87.129  14.197  1.00 38.52           C  
ATOM   1928  CD2 LEU B 104      11.679  85.078  14.514  1.00 36.71           C  
ATOM   1929  N   GLY B 105      13.403  89.740  13.120  1.00 33.60           N  
ATOM   1930  CA  GLY B 105      14.548  90.482  13.671  1.00 34.81           C  
ATOM   1931  C   GLY B 105      14.834  90.199  15.132  1.00 34.72           C  
ATOM   1932  O   GLY B 105      13.953  89.765  15.874  1.00 34.40           O  
ATOM   1933  N   HIS B 106      16.062  90.464  15.561  1.00 35.49           N  
ATOM   1934  CA  HIS B 106      16.444  90.203  16.953  1.00 36.56           C  
ATOM   1935  C   HIS B 106      15.504  90.912  17.958  1.00 36.83           C  
ATOM   1936  O   HIS B 106      15.130  90.352  19.012  1.00 36.13           O  
ATOM   1937  CB  HIS B 106      17.898  90.619  17.218  1.00 36.24           C  
ATOM   1938  CG  HIS B 106      18.307  90.426  18.639  1.00 35.37           C  
ATOM   1939  ND1 HIS B 106      18.553  89.182  19.174  1.00 32.61           N  
ATOM   1940  CD2 HIS B 106      18.453  91.315  19.656  1.00 35.91           C  
ATOM   1941  CE1 HIS B 106      18.864  89.313  20.455  1.00 34.93           C  
ATOM   1942  NE2 HIS B 106      18.795  90.597  20.772  1.00 34.70           N  
ATOM   1943  N   GLY B 107      15.108  92.132  17.599  1.00 37.03           N  
ATOM   1944  CA  GLY B 107      14.178  92.937  18.397  1.00 38.16           C  
ATOM   1945  C   GLY B 107      12.770  92.377  18.537  1.00 38.60           C  
ATOM   1946  O   GLY B 107      12.065  92.739  19.467  1.00 38.81           O  
ATOM   1947  N   ASP B 108      12.380  91.477  17.636  1.00 39.22           N  
ATOM   1948  CA  ASP B 108      11.052  90.829  17.651  1.00 40.32           C  
ATOM   1949  C   ASP B 108      11.035  89.623  18.568  1.00 40.98           C  
ATOM   1950  O   ASP B 108       9.966  89.087  18.898  1.00 40.54           O  
ATOM   1951  CB  ASP B 108      10.691  90.332  16.251  1.00 39.87           C  
ATOM   1952  CG  ASP B 108      10.660  91.438  15.224  1.00 42.97           C  
ATOM   1953  OD1 ASP B 108      10.239  92.567  15.584  1.00 44.01           O  
ATOM   1954  OD2 ASP B 108      11.051  91.178  14.052  1.00 44.69           O  
ATOM   1955  N   LEU B 109      12.231  89.194  18.959  1.00 40.92           N  
ATOM   1956  CA  LEU B 109      12.414  87.991  19.755  1.00 42.75           C  
ATOM   1957  C   LEU B 109      11.844  88.117  21.161  1.00 42.68           C  
ATOM   1958  O   LEU B 109      10.998  87.324  21.553  1.00 42.73           O  
ATOM   1959  CB  LEU B 109      13.907  87.597  19.779  1.00 42.78           C  
ATOM   1960  CG  LEU B 109      14.356  86.182  20.145  1.00 46.14           C  
ATOM   1961  CD1 LEU B 109      13.656  85.098  19.269  1.00 43.71           C  
ATOM   1962  CD2 LEU B 109      15.901  86.084  20.044  1.00 41.47           C  
ATOM   1963  N   GLN B 110      12.276  89.117  21.923  1.00 44.15           N  
ATOM   1964  CA  GLN B 110      11.757  89.265  23.294  1.00 45.24           C  
ATOM   1965  C   GLN B 110      10.212  89.423  23.388  1.00 44.37           C  
ATOM   1966  O   GLN B 110       9.589  88.771  24.228  1.00 45.56           O  
ATOM   1967  CB  GLN B 110      12.524  90.337  24.103  1.00 45.85           C  
ATOM   1968  CG  GLN B 110      12.828  89.917  25.542  1.00 45.91           C  
ATOM   1969  CD  GLN B 110      13.512  91.000  26.368  1.00 47.27           C  
ATOM   1970  OE1 GLN B 110      12.893  91.613  27.237  1.00 52.06           O  
ATOM   1971  NE2 GLN B 110      14.789  91.227  26.113  1.00 48.30           N  
ATOM   1972  N   PRO B 111       9.581  90.273  22.542  1.00 43.95           N  
ATOM   1973  CA  PRO B 111       8.110  90.288  22.541  1.00 42.86           C  
ATOM   1974  C   PRO B 111       7.446  88.933  22.216  1.00 42.64           C  
ATOM   1975  O   PRO B 111       6.369  88.623  22.749  1.00 42.41           O  
ATOM   1976  CB  PRO B 111       7.761  91.310  21.441  1.00 43.47           C  
ATOM   1977  CG  PRO B 111       8.947  92.158  21.291  1.00 42.80           C  
ATOM   1978  CD  PRO B 111      10.136  91.284  21.621  1.00 44.03           C  
ATOM   1979  N   TRP B 112       8.068  88.146  21.341  1.00 41.62           N  
ATOM   1980  CA  TRP B 112       7.522  86.846  20.949  1.00 41.31           C  
ATOM   1981  C   TRP B 112       7.571  85.905  22.150  1.00 41.44           C  
ATOM   1982  O   TRP B 112       6.588  85.250  22.470  1.00 40.68           O  
ATOM   1983  CB  TRP B 112       8.292  86.238  19.753  1.00 40.36           C  
ATOM   1984  CG  TRP B 112       7.794  84.837  19.310  1.00 39.31           C  
ATOM   1985  CD1 TRP B 112       6.527  84.335  19.437  1.00 40.58           C  
ATOM   1986  CD2 TRP B 112       8.552  83.824  18.637  1.00 40.19           C  
ATOM   1987  NE1 TRP B 112       6.450  83.065  18.903  1.00 38.94           N  
ATOM   1988  CE2 TRP B 112       7.682  82.721  18.415  1.00 39.51           C  
ATOM   1989  CE3 TRP B 112       9.890  83.729  18.210  1.00 40.41           C  
ATOM   1990  CZ2 TRP B 112       8.103  81.543  17.788  1.00 38.80           C  
ATOM   1991  CZ3 TRP B 112      10.309  82.546  17.574  1.00 39.69           C  
ATOM   1992  CH2 TRP B 112       9.415  81.470  17.377  1.00 39.37           C  
ATOM   1993  N   LEU B 113       8.719  85.865  22.812  1.00 42.58           N  
ATOM   1994  CA  LEU B 113       8.899  85.058  24.023  1.00 44.18           C  
ATOM   1995  C   LEU B 113       8.026  85.499  25.202  1.00 44.81           C  
ATOM   1996  O   LEU B 113       7.650  84.673  26.027  1.00 45.40           O  
ATOM   1997  CB  LEU B 113      10.368  85.014  24.435  1.00 44.25           C  
ATOM   1998  CG  LEU B 113      11.336  84.431  23.421  1.00 45.45           C  
ATOM   1999  CD1 LEU B 113      12.772  84.595  23.920  1.00 47.73           C  
ATOM   2000  CD2 LEU B 113      11.009  82.956  23.124  1.00 46.41           C  
ATOM   2001  N   ASN B 114       7.690  86.783  25.276  1.00 45.29           N  
ATOM   2002  CA  ASN B 114       6.693  87.248  26.245  1.00 45.59           C  
ATOM   2003  C   ASN B 114       5.283  86.728  26.010  1.00 45.11           C  
ATOM   2004  O   ASN B 114       4.525  86.498  26.955  1.00 45.56           O  
ATOM   2005  CB  ASN B 114       6.664  88.770  26.309  1.00 46.70           C  
ATOM   2006  CG  ASN B 114       7.738  89.314  27.197  1.00 48.40           C  
ATOM   2007  OD1 ASN B 114       7.538  89.461  28.409  1.00 50.30           O  
ATOM   2008  ND2 ASN B 114       8.913  89.566  26.622  1.00 50.19           N  
ATOM   2009  N   VAL B 115       4.917  86.520  24.755  1.00 44.00           N  
ATOM   2010  CA  VAL B 115       3.580  86.026  24.473  1.00 43.58           C  
ATOM   2011  C   VAL B 115       3.580  84.501  24.501  1.00 43.19           C  
ATOM   2012  O   VAL B 115       2.610  83.871  24.979  1.00 42.05           O  
ATOM   2013  CB  VAL B 115       3.017  86.616  23.153  1.00 43.99           C  
ATOM   2014  CG1 VAL B 115       1.648  86.032  22.829  1.00 45.13           C  
ATOM   2015  CG2 VAL B 115       2.901  88.132  23.279  1.00 44.47           C  
ATOM   2016  N   ARG B 116       4.681  83.921  24.015  1.00 41.90           N  
ATOM   2017  CA  ARG B 116       4.860  82.467  23.953  1.00 41.96           C  
ATOM   2018  C   ARG B 116       6.101  82.015  24.724  1.00 41.60           C  
ATOM   2019  O   ARG B 116       7.114  81.666  24.136  1.00 41.14           O  
ATOM   2020  CB  ARG B 116       4.949  81.997  22.502  1.00 41.32           C  
ATOM   2021  CG  ARG B 116       3.656  82.139  21.734  1.00 42.47           C  
ATOM   2022  CD  ARG B 116       2.736  80.974  22.040  1.00 42.14           C  
ATOM   2023  NE  ARG B 116       1.487  81.084  21.315  1.00 42.74           N  
ATOM   2024  CZ  ARG B 116       0.538  80.158  21.323  1.00 43.60           C  
ATOM   2025  NH1 ARG B 116      -0.586  80.353  20.640  1.00 43.77           N  
ATOM   2026  NH2 ARG B 116       0.725  79.035  22.004  1.00 42.89           N  
ATOM   2027  N   PRO B 117       6.006  81.991  26.053  1.00 41.93           N  
ATOM   2028  CA  PRO B 117       7.198  81.774  26.849  1.00 42.13           C  
ATOM   2029  C   PRO B 117       7.885  80.418  26.638  1.00 41.76           C  
ATOM   2030  O   PRO B 117       9.101  80.387  26.648  1.00 42.09           O  
ATOM   2031  CB  PRO B 117       6.704  81.978  28.279  1.00 42.48           C  
ATOM   2032  CG  PRO B 117       5.229  81.659  28.220  1.00 43.19           C  
ATOM   2033  CD  PRO B 117       4.797  82.167  26.884  1.00 42.09           C  
ATOM   2034  N   GLU B 118       7.130  79.348  26.379  1.00 41.86           N  
ATOM   2035  CA  GLU B 118       7.689  77.983  26.195  1.00 41.79           C  
ATOM   2036  C   GLU B 118       8.497  77.759  24.903  1.00 41.14           C  
ATOM   2037  O   GLU B 118       9.186  76.727  24.743  1.00 41.39           O  
ATOM   2038  CB  GLU B 118       6.599  76.905  26.285  1.00 42.47           C  
ATOM   2039  CG  GLU B 118       5.144  77.406  26.227  1.00 45.19           C  
ATOM   2040  CD  GLU B 118       4.746  78.076  24.909  1.00 47.21           C  
ATOM   2041  OE1 GLU B 118       4.183  79.179  24.979  1.00 47.61           O  
ATOM   2042  OE2 GLU B 118       4.964  77.507  23.818  1.00 49.72           O  
ATOM   2043  N   VAL B 119       8.393  78.711  23.977  1.00 38.70           N  
ATOM   2044  CA  VAL B 119       9.116  78.627  22.722  1.00 37.19           C  
ATOM   2045  C   VAL B 119      10.632  78.751  23.001  1.00 35.85           C  
ATOM   2046  O   VAL B 119      11.450  78.252  22.235  1.00 35.74           O  
ATOM   2047  CB  VAL B 119       8.578  79.693  21.702  1.00 37.39           C  
ATOM   2048  CG1 VAL B 119       9.595  79.995  20.614  1.00 38.69           C  
ATOM   2049  CG2 VAL B 119       7.275  79.229  21.090  1.00 35.31           C  
ATOM   2050  N   ALA B 120      10.997  79.378  24.113  1.00 34.51           N  
ATOM   2051  CA  ALA B 120      12.408  79.635  24.404  1.00 33.70           C  
ATOM   2052  C   ALA B 120      13.197  78.325  24.453  1.00 32.71           C  
ATOM   2053  O   ALA B 120      14.277  78.245  23.882  1.00 31.59           O  
ATOM   2054  CB  ALA B 120      12.564  80.393  25.711  1.00 34.17           C  
ATOM   2055  N   THR B 121      12.636  77.294  25.091  1.00 31.59           N  
ATOM   2056  CA  THR B 121      13.363  76.032  25.250  1.00 30.94           C  
ATOM   2057  C   THR B 121      13.462  75.268  23.922  1.00 30.43           C  
ATOM   2058  O   THR B 121      14.455  74.583  23.664  1.00 28.39           O  
ATOM   2059  CB  THR B 121      12.767  75.171  26.359  1.00 32.36           C  
ATOM   2060  OG1 THR B 121      11.375  74.999  26.117  1.00 32.84           O  
ATOM   2061  CG2 THR B 121      12.931  75.869  27.713  1.00 31.03           C  
ATOM   2062  N   ALA B 122      12.434  75.381  23.079  1.00 28.84           N  
ATOM   2063  CA  ALA B 122      12.502  74.780  21.744  1.00 28.48           C  
ATOM   2064  C   ALA B 122      13.559  75.436  20.825  1.00 28.12           C  
ATOM   2065  O   ALA B 122      14.255  74.755  20.091  1.00 28.31           O  
ATOM   2066  CB  ALA B 122      11.122  74.790  21.073  1.00 29.60           C  
ATOM   2067  N   LEU B 123      13.704  76.753  20.885  1.00 28.40           N  
ATOM   2068  CA  LEU B 123      14.762  77.391  20.123  1.00 28.13           C  
ATOM   2069  C   LEU B 123      16.120  77.054  20.685  1.00 28.07           C  
ATOM   2070  O   LEU B 123      17.041  76.791  19.914  1.00 28.83           O  
ATOM   2071  CB  LEU B 123      14.551  78.893  20.080  1.00 28.44           C  
ATOM   2072  CG  LEU B 123      13.224  79.379  19.454  1.00 30.10           C  
ATOM   2073  CD1 LEU B 123      13.146  80.848  19.665  1.00 29.79           C  
ATOM   2074  CD2 LEU B 123      13.194  79.092  18.003  1.00 28.84           C  
ATOM   2075  N   LEU B 124      16.256  77.083  22.019  1.00 27.09           N  
ATOM   2076  CA  LEU B 124      17.505  76.679  22.675  1.00 26.33           C  
ATOM   2077  C   LEU B 124      17.923  75.278  22.281  1.00 26.44           C  
ATOM   2078  O   LEU B 124      19.102  75.052  22.022  1.00 25.97           O  
ATOM   2079  CB  LEU B 124      17.470  76.842  24.212  1.00 25.66           C  
ATOM   2080  CG  LEU B 124      17.582  78.319  24.690  1.00 24.89           C  
ATOM   2081  CD1 LEU B 124      17.120  78.469  26.095  1.00 22.79           C  
ATOM   2082  CD2 LEU B 124      19.033  78.833  24.601  1.00 23.32           C  
ATOM   2083  N   ARG B 125      16.975  74.343  22.214  1.00 25.07           N  
ATOM   2084  CA  ARG B 125      17.329  72.964  21.832  1.00 25.38           C  
ATOM   2085  C   ARG B 125      17.904  72.966  20.418  1.00 26.03           C  
ATOM   2086  O   ARG B 125      18.921  72.301  20.141  1.00 25.48           O  
ATOM   2087  CB  ARG B 125      16.117  72.027  21.890  1.00 25.27           C  
ATOM   2088  CG  ARG B 125      16.443  70.622  21.408  1.00 28.35           C  
ATOM   2089  CD  ARG B 125      15.609  69.566  22.037  1.00 32.70           C  
ATOM   2090  NE  ARG B 125      16.354  68.285  22.040  1.00 38.98           N  
ATOM   2091  CZ  ARG B 125      16.099  67.239  22.824  1.00 39.84           C  
ATOM   2092  NH1 ARG B 125      16.864  66.140  22.743  1.00 40.26           N  
ATOM   2093  NH2 ARG B 125      15.103  67.284  23.705  1.00 39.74           N  
ATOM   2094  N   ALA B 126      17.247  73.721  19.538  1.00 26.80           N  
ATOM   2095  CA  ALA B 126      17.596  73.711  18.132  1.00 29.40           C  
ATOM   2096  C   ALA B 126      19.003  74.322  17.938  1.00 30.58           C  
ATOM   2097  O   ALA B 126      19.795  73.791  17.175  1.00 31.74           O  
ATOM   2098  CB  ALA B 126      16.565  74.477  17.328  1.00 29.26           C  
ATOM   2099  N   VAL B 127      19.309  75.411  18.632  1.00 30.76           N  
ATOM   2100  CA  VAL B 127      20.621  76.043  18.466  1.00 32.96           C  
ATOM   2101  C   VAL B 127      21.694  75.179  19.146  1.00 33.23           C  
ATOM   2102  O   VAL B 127      22.764  74.943  18.577  1.00 34.00           O  
ATOM   2103  CB  VAL B 127      20.632  77.499  18.951  1.00 32.18           C  
ATOM   2104  CG1 VAL B 127      22.037  78.137  18.749  1.00 35.29           C  
ATOM   2105  CG2 VAL B 127      19.632  78.308  18.116  1.00 35.77           C  
ATOM   2106  N   ALA B 128      21.375  74.656  20.329  1.00 32.85           N  
ATOM   2107  CA  ALA B 128      22.274  73.752  21.038  1.00 32.43           C  
ATOM   2108  C   ALA B 128      22.579  72.461  20.282  1.00 33.57           C  
ATOM   2109  O   ALA B 128      23.688  71.924  20.409  1.00 32.72           O  
ATOM   2110  CB  ALA B 128      21.742  73.451  22.410  1.00 32.88           C  
ATOM   2111  N   ARG B 129      21.611  71.932  19.531  1.00 34.37           N  
ATOM   2112  CA  ARG B 129      21.888  70.764  18.689  1.00 37.24           C  
ATOM   2113  C   ARG B 129      22.885  71.143  17.581  1.00 37.64           C  
ATOM   2114  O   ARG B 129      23.854  70.453  17.392  1.00 39.19           O  
ATOM   2115  CB  ARG B 129      20.616  70.130  18.115  1.00 36.89           C  
ATOM   2116  CG  ARG B 129      20.799  68.693  17.621  1.00 41.04           C  
ATOM   2117  CD  ARG B 129      20.767  67.735  18.805  1.00 46.59           C  
ATOM   2118  NE  ARG B 129      20.829  66.313  18.486  1.00 50.94           N  
ATOM   2119  CZ  ARG B 129      19.782  65.555  18.158  1.00 53.13           C  
ATOM   2120  NH1 ARG B 129      18.557  66.071  18.082  1.00 52.89           N  
ATOM   2121  NH2 ARG B 129      19.960  64.268  17.905  1.00 53.63           N  
ATOM   2122  N   ARG B 130      22.687  72.262  16.901  1.00 39.85           N  
ATOM   2123  CA  ARG B 130      23.696  72.730  15.926  1.00 41.58           C  
ATOM   2124  C   ARG B 130      25.093  72.693  16.542  1.00 42.75           C  
ATOM   2125  O   ARG B 130      26.027  72.150  15.946  1.00 43.01           O  
ATOM   2126  CB  ARG B 130      23.388  74.129  15.446  1.00 41.36           C  
ATOM   2127  CG  ARG B 130      22.122  74.250  14.639  1.00 43.76           C  
ATOM   2128  CD  ARG B 130      22.482  74.546  13.219  1.00 42.62           C  
ATOM   2129  NE  ARG B 130      23.806  73.996  12.966  1.00 42.78           N  
ATOM   2130  CZ  ARG B 130      24.335  73.806  11.756  1.00 47.41           C  
ATOM   2131  NH1 ARG B 130      25.552  73.268  11.652  1.00 45.89           N  
ATOM   2132  NH2 ARG B 130      23.647  74.156  10.657  1.00 46.85           N  
ATOM   2133  N   LEU B 131      25.208  73.235  17.755  1.00 43.85           N  
ATOM   2134  CA  LEU B 131      26.468  73.308  18.488  1.00 44.55           C  
ATOM   2135  C   LEU B 131      26.989  71.951  18.958  1.00 46.05           C  
ATOM   2136  O   LEU B 131      28.195  71.686  18.870  1.00 46.41           O  
ATOM   2137  CB  LEU B 131      26.355  74.321  19.650  1.00 44.07           C  
ATOM   2138  CG  LEU B 131      27.600  74.771  20.427  1.00 44.12           C  
ATOM   2139  CD1 LEU B 131      28.728  75.286  19.525  1.00 43.03           C  
ATOM   2140  CD2 LEU B 131      27.224  75.820  21.453  1.00 43.90           C  
ATOM   2141  N   ARG B 132      26.082  71.082  19.399  1.00 47.39           N  
ATOM   2142  CA  ARG B 132      26.432  69.761  19.912  1.00 49.13           C  
ATOM   2143  C   ARG B 132      26.985  68.784  18.882  1.00 50.05           C  
ATOM   2144  O   ARG B 132      27.953  68.075  19.170  1.00 50.19           O  
ATOM   2145  CB  ARG B 132      25.225  69.114  20.596  1.00 49.33           C  
ATOM   2146  CG  ARG B 132      25.349  67.605  20.776  1.00 50.09           C  
ATOM   2147  CD  ARG B 132      24.068  66.992  21.289  1.00 51.09           C  
ATOM   2148  NE  ARG B 132      23.793  67.392  22.666  1.00 52.12           N  
ATOM   2149  CZ  ARG B 132      24.211  66.731  23.742  1.00 53.06           C  
ATOM   2150  NH1 ARG B 132      24.929  65.623  23.623  1.00 53.36           N  
ATOM   2151  NH2 ARG B 132      23.902  67.180  24.945  1.00 54.43           N  
ATOM   2152  N   LYS B 133      26.336  68.706  17.719  1.00 51.08           N  
ATOM   2153  CA  LYS B 133      26.725  67.761  16.661  1.00 52.00           C  
ATOM   2154  C   LYS B 133      28.066  68.142  16.039  1.00 52.56           C  
ATOM   2155  O   LYS B 133      28.848  67.268  15.659  1.00 52.08           O  
ATOM   2156  CB  LYS B 133      25.632  67.658  15.589  1.00 52.08           C  
ATOM   2157  CG  LYS B 133      24.682  66.478  15.806  1.00 53.13           C  
ATOM   2158  CD  LYS B 133      23.208  66.860  15.638  1.00 54.02           C  
ATOM   2159  CE  LYS B 133      22.762  66.966  14.181  1.00 54.77           C  
ATOM   2160  NZ  LYS B 133      22.921  68.340  13.651  1.00 55.33           N  
ATOM   2161  N   THR B 134      28.298  69.456  15.936  1.00 53.13           N  
ATOM   2162  CA  THR B 134      29.615  70.043  15.701  1.00 53.97           C  
ATOM   2163  C   THR B 134      30.642  69.473  16.681  1.00 54.14           C  
ATOM   2164  O   THR B 134      31.602  68.820  16.274  1.00 54.39           O  
ATOM   2165  CB  THR B 134      29.538  71.573  15.869  1.00 53.80           C  
ATOM   2166  OG1 THR B 134      28.772  72.135  14.797  1.00 56.48           O  
ATOM   2167  CG2 THR B 134      30.906  72.210  15.878  1.00 54.86           C  
ATOM   2168  N   ASN B 135      30.417  69.714  17.971  1.00 54.53           N  
ATOM   2169  CA  ASN B 135      31.247  69.186  19.054  1.00 54.80           C  
ATOM   2170  C   ASN B 135      31.359  67.653  19.012  1.00 55.08           C  
ATOM   2171  O   ASN B 135      32.422  67.094  19.297  1.00 55.31           O  
ATOM   2172  CB  ASN B 135      30.680  69.674  20.398  1.00 54.90           C  
ATOM   2173  CG  ASN B 135      31.415  69.112  21.595  1.00 54.77           C  
ATOM   2174  OD1 ASN B 135      31.075  68.038  22.100  1.00 55.02           O  
ATOM   2175  ND2 ASN B 135      32.416  69.851  22.075  1.00 54.40           N  
ATOM   2176  N   ASP B 136      30.262  66.989  18.653  1.00 55.36           N  
ATOM   2177  CA  ASP B 136      30.230  65.536  18.480  1.00 55.77           C  
ATOM   2178  C   ASP B 136      31.065  65.093  17.284  1.00 55.99           C  
ATOM   2179  O   ASP B 136      31.777  64.083  17.361  1.00 56.07           O  
ATOM   2180  CB  ASP B 136      28.792  65.040  18.314  1.00 55.89           C  
ATOM   2181  CG  ASP B 136      28.140  64.660  19.649  1.00 56.23           C  
ATOM   2182  OD1 ASP B 136      28.525  65.213  20.719  1.00 55.20           O  
ATOM   2183  OD2 ASP B 136      27.230  63.801  19.617  1.00 56.94           O  
ATOM   2184  N   ALA B 137      30.960  65.840  16.183  1.00 55.99           N  
ATOM   2185  CA  ALA B 137      31.805  65.616  15.015  1.00 56.17           C  
ATOM   2186  C   ALA B 137      33.259  65.897  15.390  1.00 56.16           C  
ATOM   2187  O   ALA B 137      34.138  65.051  15.185  1.00 56.19           O  
ATOM   2188  CB  ALA B 137      31.366  66.495  13.850  1.00 56.24           C  
HETATM 2189  N   MSE B 138      33.487  67.078  15.965  1.00 56.02           N  
HETATM 2190  CA  MSE B 138      34.798  67.475  16.464  1.00 55.79           C  
HETATM 2191  C   MSE B 138      35.235  66.702  17.706  1.00 56.49           C  
HETATM 2192  O   MSE B 138      34.730  65.607  17.987  1.00 56.39           O  
HETATM 2193  CB  MSE B 138      34.826  68.967  16.750  1.00 55.63           C  
HETATM 2194  CG  MSE B 138      35.448  69.777  15.665  1.00 54.87           C  
HETATM 2195 SE   MSE B 138      34.286  71.261  15.257  0.70 54.63          SE  
HETATM 2196  CE  MSE B 138      33.294  70.380  13.830  1.00 54.05           C  
ATOM   2197  N   SER B 139      36.175  67.293  18.446  1.00 56.95           N  
ATOM   2198  CA  SER B 139      36.891  66.601  19.503  1.00 57.19           C  
ATOM   2199  C   SER B 139      37.626  65.416  18.843  1.00 57.42           C  
ATOM   2200  O   SER B 139      37.866  64.376  19.463  1.00 57.10           O  
ATOM   2201  CB  SER B 139      35.932  66.183  20.634  1.00 57.29           C  
ATOM   2202  OG  SER B 139      35.293  67.349  21.195  1.00 57.75           O  
ATOM   2203  N   ASP B 140      37.979  65.592  17.574  1.00 57.71           N  
ATOM   2204  CA  ASP B 140      39.161  64.949  17.011  1.00 57.70           C  
ATOM   2205  C   ASP B 140      40.440  65.530  17.604  1.00 57.79           C  
ATOM   2206  O   ASP B 140      40.393  66.383  18.490  1.00 57.72           O  
ATOM   2207  CB  ASP B 140      39.174  65.094  15.488  1.00 57.90           C  
ATOM   2208  CG  ASP B 140      37.920  64.543  14.838  1.00 58.32           C  
ATOM   2209  OD1 ASP B 140      37.108  65.346  14.334  1.00 58.29           O  
ATOM   2210  OD2 ASP B 140      37.745  63.306  14.834  1.00 60.39           O  
ATOM   2211  N   SER B 144      45.752  68.014  20.744  1.00 48.95           N  
ATOM   2212  CA  SER B 144      46.240  68.382  22.075  1.00 48.96           C  
ATOM   2213  C   SER B 144      47.569  67.719  22.459  1.00 48.41           C  
ATOM   2214  O   SER B 144      47.615  66.926  23.392  1.00 48.08           O  
ATOM   2215  CB  SER B 144      45.189  68.015  23.105  1.00 49.34           C  
ATOM   2216  OG  SER B 144      44.657  66.734  22.807  1.00 50.75           O  
ATOM   2217  N   ASP B 145      48.643  68.031  21.740  1.00 48.07           N  
ATOM   2218  CA  ASP B 145      49.954  67.460  22.062  1.00 47.97           C  
ATOM   2219  C   ASP B 145      51.098  68.483  22.129  1.00 48.32           C  
ATOM   2220  O   ASP B 145      52.259  68.124  21.976  1.00 47.94           O  
ATOM   2221  CB  ASP B 145      50.293  66.305  21.105  1.00 47.20           C  
ATOM   2222  CG  ASP B 145      50.526  66.770  19.665  1.00 46.77           C  
ATOM   2223  OD1 ASP B 145      50.507  68.000  19.416  1.00 43.92           O  
ATOM   2224  OD2 ASP B 145      50.718  65.896  18.782  1.00 44.69           O  
ATOM   2225  N   GLY B 146      50.776  69.749  22.371  1.00 49.55           N  
ATOM   2226  CA  GLY B 146      51.798  70.803  22.406  1.00 51.20           C  
ATOM   2227  C   GLY B 146      52.125  71.244  20.991  1.00 53.04           C  
ATOM   2228  O   GLY B 146      52.993  72.090  20.777  1.00 53.50           O  
ATOM   2229  N   SER B 147      51.442  70.599  20.038  1.00 53.94           N  
ATOM   2230  CA  SER B 147      51.293  70.987  18.621  1.00 54.79           C  
ATOM   2231  C   SER B 147      52.050  70.124  17.604  1.00 54.84           C  
ATOM   2232  O   SER B 147      51.586  69.044  17.220  1.00 54.72           O  
ATOM   2233  CB  SER B 147      51.448  72.501  18.375  1.00 54.90           C  
ATOM   2234  OG  SER B 147      50.162  73.095  18.233  1.00 54.77           O  
ATOM   2235  OXT SER B 147      53.132  70.484  17.141  1.00 55.52           O  
TER    2236      SER B 147                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
