
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 1160),  selected  150 , name 2z69_B
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2z69_B.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_B      -       -           -
LGA    E     2_B      -       -           -
LGA    F     3_B      -       -           -
LGA    Q     4_B      M       1          2.482
LGA    R     5_B      -       -           -
LGA    V     6_B      -       -           -
LGA    H     7_B      -       -           -
LGA    Q     8_B      H       2          3.438
LGA    Q     9_B      T       3          2.726
LGA    L    10_B      A       4          1.560
LGA    L    11_B      L       5          0.982
LGA    Q    12_B      I       6          1.848
LGA    S    13_B      N       7          2.783
LGA    H    14_B      H       8          2.314
LGA    H    15_B      I       9          4.351
LGA    L    16_B      -       -           -
LGA    F    17_B      -       -           -
LGA    E    18_B      -       -           -
LGA    P    19_B      R      10           #
LGA    L    20_B      K      11           -
LGA    -       -      F      12           -
LGA    -       -      I      13           -
LGA    -       -      F      14           -
LGA    S    21_B      L      15          3.362
LGA    P    22_B      T      16          4.089
LGA    -       -      D      17           -
LGA    V    23_B      E      18          3.245
LGA    Q    24_B      D      19          3.646
LGA    L    25_B      A      20          3.344
LGA    Q    26_B      G      21          2.348
LGA    E    27_B      T      22          2.983
LGA    L    28_B      L      23          3.521
LGA    L    29_B      S      24          2.604
LGA    A    30_B      A      25          2.051
LGA    S    31_B      F      26          3.521
LGA    S    32_B      F      27          2.614
LGA    D    33_B      Q      28          2.418
LGA    L    34_B      L      29          2.246
LGA    V    35_B      K      30          1.736
LGA    N    36_B      K      31          2.144
LGA    L    37_B      V      32          1.650
LGA    D    38_B      R      33          1.857
LGA    K    39_B      K      34          1.904
LGA    G    40_B      K      35          1.390
LGA    A    41_B      E      36          1.005
LGA    Y    42_B      T      37          0.914
LGA    V    43_B      L      38          1.946
LGA    F    44_B      L      39          1.669
LGA    R    45_B      K      40          1.549
LGA    Q    46_B      T      41          1.987
LGA    G    47_B      G      42          1.834
LGA    E    48_B      E      43          1.355
LGA    P    49_B      I      44          1.401
LGA    A    50_B      C      45          1.356
LGA    H    51_B      R      46          1.288
LGA    A    52_B      I      47          1.344
LGA    F    53_B      N      48          0.801
LGA    Y    54_B      Y      49          0.907
LGA    Y    55_B      F      50          1.493
LGA    L    56_B      V      51          1.571
LGA    I    57_B      V      52          1.964
LGA    S    58_B      K      53          1.865
LGA    G    59_B      G      54          1.885
LGA    C    60_B      C      55          1.712
LGA    V    61_B      L      56          1.515
LGA    K    62_B      R      57          1.516
LGA    I    63_B      L      58          1.155
LGA    Y    64_B      F      59          0.426
LGA    R    65_B      F      60          0.732
LGA    L    66_B      I      61          0.718
LGA    T    67_B      D      62          1.057
LGA    P    68_B      E      63          1.674
LGA    E    69_B      K      64          1.235
LGA    G    70_B      G      65          0.254
LGA    Q    71_B      I      66          0.906
LGA    E    72_B      E      67          1.513
LGA    K    73_B      Q      68          1.793
LGA    I    74_B      T      69          1.338
LGA    L    75_B      T      70          1.426
LGA    E    76_B      Q      71          1.065
LGA    V    77_B      F      72          1.691
LGA    T    78_B      A      73          1.749
LGA    N    79_B      I      74          1.468
LGA    E    80_B      E      75          2.149
LGA    R    81_B      N      76          2.710
LGA    N    82_B      W      77          2.043
LGA    T    83_B      W      78          1.719
LGA    F    84_B      L      79          1.164
LGA    A    85_B      S      80          1.404
LGA    E    86_B      D      81           -
LGA    A    87_B      Y      82          3.307
LGA    M    88_B      M      83          4.674
LGA    -       -      A      84           -
LGA    M    89_B      F      85          4.335
LGA    F    90_B      Q      86          3.706
LGA    M    91_B      -       -           -
LGA    D    92_B      K      87          2.823
LGA    T    93_B      Q      88           #
LGA    P    94_B      Q      89          1.127
LGA    N    95_B      P      90          2.521
LGA    Y    96_B      A      91          2.598
LGA    V    97_B      D      92          2.232
LGA    A    98_B      F      93          0.900
LGA    T    99_B      Y      94          0.744
LGA    A   100_B      I      95          1.191
LGA    Q   101_B      Q      96          1.121
LGA    A   102_B      S      97          1.320
LGA    V   103_B      V      98          1.778
LGA    V   104_B      E      99          2.108
LGA    P   105_B      N     100          1.953
LGA    S   106_B      C     101          1.836
LGA    Q   107_B      E     102          2.041
LGA    L   108_B      L     103          1.324
LGA    F   109_B      L     104          1.554
LGA    R   110_B      S     105          1.502
LGA    F   111_B      I     106          1.461
LGA    S   112_B      T     107          2.055
LGA    N   113_B      Y     108          1.977
LGA    K   114_B      T     109          1.644
LGA    A   115_B      E     110          1.743
LGA    Y   116_B      Q     111          1.868
LGA    L   117_B      E     112          1.385
LGA    R   118_B      N     113          1.063
LGA    Q   119_B      L     114          2.035
LGA    L   120_B      F     115          0.881
LGA    Q   121_B      E     116          1.675
LGA    D   122_B      R     117          4.071
LGA    N   123_B      I     118          4.052
LGA    T   124_B      P     119          4.076
LGA    P   125_B      A     120          4.005
LGA    L   126_B      L     121          3.061
LGA    A   127_B      E     122          2.680
LGA    L   128_B      R     123          4.793
LGA    A   129_B      Y     124          5.208
LGA    L   130_B      F     125          3.982
LGA    L   131_B      R     126          4.832
LGA    -       -      L     127           -
LGA    -       -      V     128           -
LGA    A   132_B      Y     129           #
LGA    K   133_B      Q     130          2.626
LGA    L   134_B      K     131           -
LGA    S   135_B      S     132           -
LGA    T   136_B      F     133          5.603
LGA    -       -      A     134           -
LGA    -       -      A     135           -
LGA    R   137_B      A     136           #
LGA    L   138_B      -       -           -
LGA    H   139_B      -       -           -
LGA    Q   140_B      Q     137          5.715
LGA    R   141_B      L     138           -
LGA    I   142_B      R     139           -
LGA    D   143_B      S     140           -
LGA    E   144_B      K     141           -
LGA    I   145_B      F     142           -
LGA    E   146_B      Q     143           -
LGA    T   147_B      H     144           -
LGA    L   148_B      M     145           -
LGA    S   149_B      Y     146           -
LGA    L   150_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150  146    5.0    120    2.44    16.67     66.666     4.730

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.060373 * X  +   0.022113 * Y  +  -0.997931 * Z  +  46.196529
  Y_new =   0.991162 * X  +   0.116985 * Y  +   0.062556 * Z  +  73.860413
  Z_new =   0.118126 * X  +  -0.992887 * Y  +  -0.014855 * Z  +   4.501463 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.585757    1.555836  [ DEG:   -90.8572     89.1428 ]
  Theta =  -0.118402   -3.023190  [ DEG:    -6.7840   -173.2160 ]
  Phi   =   1.509960   -1.631633  [ DEG:    86.5143    -93.4857 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2z69_B                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2z69_B.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150  146   5.0  120   2.44   16.67  66.666
REMARK  ---------------------------------------------------------- 
MOLECULE 2z69_B
HEADER    TRANSCRIPTION REGULATOR                 24-JUL-07   2Z69              
TITLE     CRYSTAL STRUCTURE OF THE SENSOR DOMAIN OF THE                         
TITLE    2 TRANSCRIPTIONAL REGULATOR DNR FROM PSEUDOMONAS AERUGINOSA            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DNR PROTEIN;                                               
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: SENSOR DOMAIN;                                             
COMPND   5 SYNONYM: TRANSCRIPTIONAL REGULATOR DNR, DNR DISSIMILATIVE            
COMPND   6 NITRATE RESPIRATION REGULATOR;                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 STRAIN: PAO1;                                                        
SOURCE   4 GENE: DNR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    BETA BARREL, DIMERIZATION HELIX, TRANSCRIPTION REGULATOR              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    G.GIARDINA,K.A.JOHNSON,A.DI MATTEO                                    
REVDAT   2   03-JUN-08 2Z69    1       JRNL                                     
REVDAT   1   18-MAR-08 2Z69    0                                                
JRNL        AUTH   G.GIARDINA,S.RINALDO,K.A.JOHNSON,A.DI MATTEO,                
JRNL        AUTH 2 M.BRUNORI,F.CUTRUZZOLA                                       
JRNL        TITL   NO SENSING IN PSEUDOMONAS AERUGINOSA: STRUCTURE OF           
JRNL        TITL 2 THE TRANSCRIPTIONAL REGULATOR DNR.                           
JRNL        REF    J.MOL.BIOL.                   V. 378  1002 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2Z69 A    1   151  UNP    Q51441   Q51441_PSEAE     1    151             
DBREF  2Z69 B    1   151  UNP    Q51441   Q51441_PSEAE     1    151             
DBREF  2Z69 C    1   151  UNP    Q51441   Q51441_PSEAE     1    151             
SEQRES   1 A  154  GLY SER HIS MET GLU PHE GLN ARG VAL HIS GLN GLN LEU          
SEQRES   2 A  154  LEU GLN SER HIS HIS LEU PHE GLU PRO LEU SER PRO VAL          
SEQRES   3 A  154  GLN LEU GLN GLU LEU LEU ALA SER SER ASP LEU VAL ASN          
SEQRES   4 A  154  LEU ASP LYS GLY ALA TYR VAL PHE ARG GLN GLY GLU PRO          
SEQRES   5 A  154  ALA HIS ALA PHE TYR TYR LEU ILE SER GLY CYS VAL LYS          
SEQRES   6 A  154  ILE TYR ARG LEU THR PRO GLU GLY GLN GLU LYS ILE LEU          
SEQRES   7 A  154  GLU VAL THR ASN GLU ARG ASN THR PHE ALA GLU ALA MET          
SEQRES   8 A  154  MET PHE MET ASP THR PRO ASN TYR VAL ALA THR ALA GLN          
SEQRES   9 A  154  ALA VAL VAL PRO SER GLN LEU PHE ARG PHE SER ASN LYS          
SEQRES  10 A  154  ALA TYR LEU ARG GLN LEU GLN ASP ASN THR PRO LEU ALA          
SEQRES  11 A  154  LEU ALA LEU LEU ALA LYS LEU SER THR ARG LEU HIS GLN          
SEQRES  12 A  154  ARG ILE ASP GLU ILE GLU THR LEU SER LEU LYS                  
SEQRES   1 B  154  GLY SER HIS MET GLU PHE GLN ARG VAL HIS GLN GLN LEU          
SEQRES   2 B  154  LEU GLN SER HIS HIS LEU PHE GLU PRO LEU SER PRO VAL          
SEQRES   3 B  154  GLN LEU GLN GLU LEU LEU ALA SER SER ASP LEU VAL ASN          
SEQRES   4 B  154  LEU ASP LYS GLY ALA TYR VAL PHE ARG GLN GLY GLU PRO          
SEQRES   5 B  154  ALA HIS ALA PHE TYR TYR LEU ILE SER GLY CYS VAL LYS          
SEQRES   6 B  154  ILE TYR ARG LEU THR PRO GLU GLY GLN GLU LYS ILE LEU          
SEQRES   7 B  154  GLU VAL THR ASN GLU ARG ASN THR PHE ALA GLU ALA MET          
SEQRES   8 B  154  MET PHE MET ASP THR PRO ASN TYR VAL ALA THR ALA GLN          
SEQRES   9 B  154  ALA VAL VAL PRO SER GLN LEU PHE ARG PHE SER ASN LYS          
SEQRES  10 B  154  ALA TYR LEU ARG GLN LEU GLN ASP ASN THR PRO LEU ALA          
SEQRES  11 B  154  LEU ALA LEU LEU ALA LYS LEU SER THR ARG LEU HIS GLN          
SEQRES  12 B  154  ARG ILE ASP GLU ILE GLU THR LEU SER LEU LYS                  
SEQRES   1 C  154  GLY SER HIS MET GLU PHE GLN ARG VAL HIS GLN GLN LEU          
SEQRES   2 C  154  LEU GLN SER HIS HIS LEU PHE GLU PRO LEU SER PRO VAL          
SEQRES   3 C  154  GLN LEU GLN GLU LEU LEU ALA SER SER ASP LEU VAL ASN          
SEQRES   4 C  154  LEU ASP LYS GLY ALA TYR VAL PHE ARG GLN GLY GLU PRO          
SEQRES   5 C  154  ALA HIS ALA PHE TYR TYR LEU ILE SER GLY CYS VAL LYS          
SEQRES   6 C  154  ILE TYR ARG LEU THR PRO GLU GLY GLN GLU LYS ILE LEU          
SEQRES   7 C  154  GLU VAL THR ASN GLU ARG ASN THR PHE ALA GLU ALA MET          
SEQRES   8 C  154  MET PHE MET ASP THR PRO ASN TYR VAL ALA THR ALA GLN          
SEQRES   9 C  154  ALA VAL VAL PRO SER GLN LEU PHE ARG PHE SER ASN LYS          
SEQRES  10 C  154  ALA TYR LEU ARG GLN LEU GLN ASP ASN THR PRO LEU ALA          
SEQRES  11 C  154  LEU ALA LEU LEU ALA LYS LEU SER THR ARG LEU HIS GLN          
SEQRES  12 C  154  ARG ILE ASP GLU ILE GLU THR LEU SER LEU LYS                  
FORMUL   4  HOH   *103(H2 O)                                                    
CRYST1   56.145  105.534   74.838  90.00  97.97  90.00 C 1 2 1      12          
ATOM   1149  N   MET B   1      -8.760  91.445   5.095  1.00 31.25           N  
ATOM   1150  CA  MET B   1      -7.813  90.951   6.143  1.00 31.17           C  
ATOM   1151  C   MET B   1      -7.511  89.458   5.974  1.00 31.33           C  
ATOM   1152  O   MET B   1      -6.806  88.862   6.799  1.00 31.51           O  
ATOM   1153  CB  MET B   1      -8.369  91.243   7.543  1.00 31.02           C  
ATOM   1154  N   GLU B   2      -8.036  88.879   4.888  1.00 31.22           N  
ATOM   1155  CA  GLU B   2      -7.913  87.443   4.559  1.00 30.84           C  
ATOM   1156  C   GLU B   2      -6.470  86.952   4.428  1.00 30.15           C  
ATOM   1157  O   GLU B   2      -6.178  85.788   4.721  1.00 30.30           O  
ATOM   1158  CB  GLU B   2      -8.641  87.118   3.247  1.00 30.90           C  
ATOM   1159  CG  GLU B   2      -9.986  87.799   3.044  1.00 30.96           C  
ATOM   1160  CD  GLU B   2     -10.431  87.800   1.582  1.00 31.70           C  
ATOM   1161  OE1 GLU B   2     -11.568  88.237   1.301  1.00 30.34           O  
ATOM   1162  OE2 GLU B   2      -9.643  87.369   0.710  1.00 35.28           O  
ATOM   1163  N   PHE B   3      -5.583  87.839   3.974  1.00 29.10           N  
ATOM   1164  CA  PHE B   3      -4.179  87.516   3.725  1.00 27.60           C  
ATOM   1165  C   PHE B   3      -3.448  86.912   4.934  1.00 27.09           C  
ATOM   1166  O   PHE B   3      -2.462  86.190   4.763  1.00 26.48           O  
ATOM   1167  CB  PHE B   3      -3.422  88.761   3.243  1.00 27.69           C  
ATOM   1168  CG  PHE B   3      -3.194  89.791   4.322  1.00 27.04           C  
ATOM   1169  CD1 PHE B   3      -4.179  90.740   4.619  1.00 26.90           C  
ATOM   1170  CD2 PHE B   3      -1.994  89.810   5.044  1.00 28.07           C  
ATOM   1171  CE1 PHE B   3      -3.979  91.693   5.621  1.00 28.05           C  
ATOM   1172  CE2 PHE B   3      -1.783  90.757   6.054  1.00 28.39           C  
ATOM   1173  CZ  PHE B   3      -2.772  91.705   6.339  1.00 27.55           C  
ATOM   1174  N   GLN B   4      -3.913  87.231   6.142  1.00 26.03           N  
ATOM   1175  CA  GLN B   4      -3.277  86.731   7.357  0.50 24.73           C  
ATOM   1176  C   GLN B   4      -3.487  85.221   7.495  1.00 24.14           C  
ATOM   1177  O   GLN B   4      -2.570  84.508   7.907  1.00 24.11           O  
ATOM   1178  CB  GLN B   4      -3.744  87.496   8.602  0.50 24.46           C  
ATOM   1179  CG  GLN B   4      -5.216  87.364   8.933  0.50 23.83           C  
ATOM   1180  CD  GLN B   4      -5.476  87.433  10.420  0.50 23.65           C  
ATOM   1181  OE1 GLN B   4      -6.127  86.554  10.983  0.50 22.35           O  
ATOM   1182  NE2 GLN B   4      -4.958  88.470  11.069  0.50 24.63           N  
ATOM   1183  N   ARG B   5      -4.677  84.745   7.116  1.00 22.90           N  
ATOM   1184  CA  ARG B   5      -4.982  83.311   7.074  1.00 22.04           C  
ATOM   1185  C   ARG B   5      -4.016  82.550   6.162  1.00 21.57           C  
ATOM   1186  O   ARG B   5      -3.309  81.648   6.620  1.00 20.89           O  
ATOM   1187  CB  ARG B   5      -6.437  83.076   6.647  1.00 22.09           C  
ATOM   1188  N   VAL B   6      -3.968  82.931   4.885  1.00 21.28           N  
ATOM   1189  CA  VAL B   6      -3.058  82.293   3.912  1.00 21.10           C  
ATOM   1190  C   VAL B   6      -1.565  82.342   4.314  1.00 20.64           C  
ATOM   1191  O   VAL B   6      -0.846  81.360   4.121  1.00 21.13           O  
ATOM   1192  CB  VAL B   6      -3.332  82.749   2.420  1.00 21.28           C  
ATOM   1193  CG1 VAL B   6      -3.871  84.182   2.348  1.00 22.04           C  
ATOM   1194  CG2 VAL B   6      -2.092  82.573   1.519  1.00 21.02           C  
ATOM   1195  N   HIS B   7      -1.105  83.452   4.887  1.00 20.06           N  
ATOM   1196  CA  HIS B   7       0.308  83.537   5.303  1.00 20.01           C  
ATOM   1197  C   HIS B   7       0.589  82.695   6.551  1.00 20.85           C  
ATOM   1198  O   HIS B   7       1.597  81.996   6.610  1.00 19.96           O  
ATOM   1199  CB  HIS B   7       0.775  84.974   5.521  1.00 20.08           C  
ATOM   1200  CG  HIS B   7       0.631  85.860   4.323  1.00 17.77           C  
ATOM   1201  ND1 HIS B   7       0.623  87.234   4.423  1.00 16.08           N  
ATOM   1202  CD2 HIS B   7       0.467  85.577   3.007  1.00 17.56           C  
ATOM   1203  CE1 HIS B   7       0.465  87.759   3.221  1.00 18.60           C  
ATOM   1204  NE2 HIS B   7       0.369  86.775   2.345  1.00 18.23           N  
ATOM   1205  N   GLN B   8      -0.301  82.754   7.546  1.00 21.55           N  
ATOM   1206  CA  GLN B   8      -0.197  81.833   8.683  1.00 22.74           C  
ATOM   1207  C   GLN B   8      -0.091  80.397   8.156  1.00 22.24           C  
ATOM   1208  O   GLN B   8       0.791  79.656   8.568  1.00 21.96           O  
ATOM   1209  CB  GLN B   8      -1.363  81.992   9.678  1.00 22.60           C  
ATOM   1210  CG  GLN B   8      -1.080  82.980  10.842  1.00 28.02           C  
ATOM   1211  CD  GLN B   8      -2.013  84.213  10.890  1.00 32.96           C  
ATOM   1212  OE1 GLN B   8      -1.600  85.341  10.587  1.00 33.37           O  
ATOM   1213  NE2 GLN B   8      -3.265  83.994  11.288  1.00 33.64           N  
ATOM   1214  N   GLN B   9      -0.947  80.049   7.194  1.00 22.70           N  
ATOM   1215  CA  GLN B   9      -1.006  78.708   6.601  1.00 23.47           C  
ATOM   1216  C   GLN B   9       0.308  78.165   6.015  1.00 24.11           C  
ATOM   1217  O   GLN B   9       0.687  77.028   6.316  1.00 25.07           O  
ATOM   1218  CB  GLN B   9      -2.112  78.657   5.548  1.00 23.32           C  
ATOM   1219  CG  GLN B   9      -2.454  77.256   5.058  1.00 24.49           C  
ATOM   1220  CD  GLN B   9      -3.868  77.164   4.521  1.00 25.81           C  
ATOM   1221  OE1 GLN B   9      -4.810  77.680   5.129  1.00 26.61           O  
ATOM   1222  NE2 GLN B   9      -4.028  76.494   3.383  1.00 25.77           N  
ATOM   1223  N   LEU B  10       1.000  78.955   5.188  1.00 24.50           N  
ATOM   1224  CA  LEU B  10       2.262  78.491   4.572  1.00 24.17           C  
ATOM   1225  C   LEU B  10       3.445  78.534   5.554  1.00 23.64           C  
ATOM   1226  O   LEU B  10       4.308  77.662   5.544  1.00 24.15           O  
ATOM   1227  CB  LEU B  10       2.554  79.196   3.226  1.00 24.09           C  
ATOM   1228  CG  LEU B  10       3.389  80.472   3.040  1.00 26.15           C  
ATOM   1229  CD1 LEU B  10       3.729  80.684   1.570  1.00 22.57           C  
ATOM   1230  CD2 LEU B  10       2.701  81.701   3.596  1.00 26.75           C  
ATOM   1231  N   LEU B  11       3.445  79.523   6.438  1.00 22.89           N  
ATOM   1232  CA  LEU B  11       4.477  79.645   7.461  1.00 21.89           C  
ATOM   1233  C   LEU B  11       4.431  78.585   8.536  1.00 22.13           C  
ATOM   1234  O   LEU B  11       5.480  78.234   9.097  1.00 21.45           O  
ATOM   1235  CB  LEU B  11       4.407  81.012   8.125  1.00 21.15           C  
ATOM   1236  CG  LEU B  11       4.850  82.120   7.190  1.00 21.97           C  
ATOM   1237  CD1 LEU B  11       4.765  83.448   7.916  1.00 26.82           C  
ATOM   1238  CD2 LEU B  11       6.279  81.842   6.779  1.00 19.86           C  
ATOM   1239  N   GLN B  12       3.224  78.101   8.856  1.00 21.12           N  
ATOM   1240  CA  GLN B  12       3.056  77.185   9.972  1.00 21.91           C  
ATOM   1241  C   GLN B  12       3.689  75.822   9.664  1.00 21.88           C  
ATOM   1242  O   GLN B  12       4.025  75.066  10.573  1.00 22.82           O  
ATOM   1243  CB  GLN B  12       1.568  77.063  10.367  1.00 22.36           C  
ATOM   1244  CG  GLN B  12       1.334  76.463  11.742  1.00 27.64           C  
ATOM   1245  CD  GLN B  12       1.640  77.418  12.904  1.00 38.89           C  
ATOM   1246  OE1 GLN B  12       0.793  78.228  13.302  1.00 45.20           O  
ATOM   1247  NE2 GLN B  12       2.836  77.292  13.482  1.00 38.85           N  
ATOM   1248  N   SER B  13       3.878  75.522   8.382  1.00 22.29           N  
ATOM   1249  CA  SER B  13       4.486  74.241   7.976  1.00 22.62           C  
ATOM   1250  C   SER B  13       5.980  74.192   8.292  1.00 21.86           C  
ATOM   1251  O   SER B  13       6.534  73.133   8.593  1.00 23.39           O  
ATOM   1252  CB  SER B  13       4.257  73.968   6.484  1.00 22.00           C  
ATOM   1253  OG  SER B  13       4.577  75.103   5.701  1.00 24.32           O  
ATOM   1254  N   HIS B  14       6.613  75.347   8.229  1.00 19.19           N  
ATOM   1255  CA  HIS B  14       8.045  75.470   8.386  1.00 18.76           C  
ATOM   1256  C   HIS B  14       8.505  75.349   9.845  1.00 19.18           C  
ATOM   1257  O   HIS B  14       7.955  76.013  10.724  1.00 20.26           O  
ATOM   1258  CB  HIS B  14       8.484  76.822   7.815  1.00 17.31           C  
ATOM   1259  CG  HIS B  14       9.963  76.958   7.692  1.00 15.72           C  
ATOM   1260  ND1 HIS B  14      10.777  77.180   8.778  1.00 14.85           N  
ATOM   1261  CD2 HIS B  14      10.778  76.874   6.619  1.00  9.12           C  
ATOM   1262  CE1 HIS B  14      12.036  77.229   8.381  1.00 15.09           C  
ATOM   1263  NE2 HIS B  14      12.064  77.057   7.071  1.00 16.42           N  
ATOM   1264  N   HIS B  15       9.539  74.541  10.089  1.00 18.70           N  
ATOM   1265  CA  HIS B  15      10.025  74.252  11.458  1.00 19.86           C  
ATOM   1266  C   HIS B  15      10.353  75.463  12.352  1.00 19.54           C  
ATOM   1267  O   HIS B  15      10.362  75.322  13.578  1.00 19.30           O  
ATOM   1268  CB  HIS B  15      11.240  73.309  11.436  1.00 20.24           C  
ATOM   1269  CG  HIS B  15      12.461  73.913  10.814  1.00 23.61           C  
ATOM   1270  ND1 HIS B  15      13.325  74.735  11.509  1.00 32.08           N  
ATOM   1271  CD2 HIS B  15      12.947  73.843   9.548  1.00 26.10           C  
ATOM   1272  CE1 HIS B  15      14.291  75.141  10.699  1.00 26.12           C  
ATOM   1273  NE2 HIS B  15      14.092  74.601   9.509  1.00 24.11           N  
ATOM   1274  N   LEU B  16      10.631  76.636  11.766  1.00 18.70           N  
ATOM   1275  CA  LEU B  16      10.970  77.826  12.584  1.00 19.33           C  
ATOM   1276  C   LEU B  16       9.758  78.507  13.215  1.00 18.76           C  
ATOM   1277  O   LEU B  16       9.892  79.268  14.195  1.00 18.21           O  
ATOM   1278  CB  LEU B  16      11.784  78.853  11.777  1.00 19.45           C  
ATOM   1279  CG  LEU B  16      13.278  78.553  11.673  1.00 20.91           C  
ATOM   1280  CD1 LEU B  16      14.025  79.690  11.019  1.00 21.47           C  
ATOM   1281  CD2 LEU B  16      13.889  78.217  13.035  1.00 22.05           C  
ATOM   1282  N   PHE B  17       8.587  78.230  12.641  1.00 18.37           N  
ATOM   1283  CA  PHE B  17       7.344  78.893  13.004  1.00 19.30           C  
ATOM   1284  C   PHE B  17       6.320  77.882  13.486  1.00 19.98           C  
ATOM   1285  O   PHE B  17       5.319  78.260  14.078  1.00 20.77           O  
ATOM   1286  CB  PHE B  17       6.772  79.695  11.814  1.00 18.84           C  
ATOM   1287  CG  PHE B  17       7.780  80.568  11.133  1.00 19.01           C  
ATOM   1288  CD1 PHE B  17       8.471  80.112  10.013  1.00 20.66           C  
ATOM   1289  CD2 PHE B  17       8.065  81.825  11.625  1.00 15.22           C  
ATOM   1290  CE1 PHE B  17       9.426  80.926   9.374  1.00 24.72           C  
ATOM   1291  CE2 PHE B  17       9.024  82.624  11.014  1.00 20.83           C  
ATOM   1292  CZ  PHE B  17       9.694  82.176   9.878  1.00 21.70           C  
ATOM   1293  N   GLU B  18       6.580  76.601  13.222  1.00 21.23           N  
ATOM   1294  CA  GLU B  18       5.677  75.501  13.615  1.00 22.25           C  
ATOM   1295  C   GLU B  18       5.303  75.478  15.108  1.00 21.97           C  
ATOM   1296  O   GLU B  18       4.103  75.436  15.442  1.00 22.02           O  
ATOM   1297  CB  GLU B  18       6.255  74.142  13.161  1.00 21.96           C  
ATOM   1298  CG  GLU B  18       5.810  72.925  13.978  1.00 27.63           C  
ATOM   1299  CD  GLU B  18       4.342  72.604  13.804  1.00 34.85           C  
ATOM   1300  OE1 GLU B  18       3.772  73.004  12.764  1.00 37.06           O  
ATOM   1301  OE2 GLU B  18       3.757  71.957  14.707  1.00 40.93           O  
ATOM   1302  N   PRO B  19       6.309  75.498  16.017  1.00 21.94           N  
ATOM   1303  CA  PRO B  19       5.962  75.381  17.451  1.00 21.65           C  
ATOM   1304  C   PRO B  19       5.244  76.617  18.021  1.00 21.60           C  
ATOM   1305  O   PRO B  19       4.748  76.579  19.159  1.00 21.33           O  
ATOM   1306  CB  PRO B  19       7.324  75.178  18.134  1.00 21.78           C  
ATOM   1307  CG  PRO B  19       8.321  74.907  17.009  1.00 21.28           C  
ATOM   1308  CD  PRO B  19       7.768  75.604  15.817  1.00 21.87           C  
ATOM   1309  N   LEU B  20       5.187  77.690  17.225  1.00 21.36           N  
ATOM   1310  CA  LEU B  20       4.457  78.895  17.589  1.00 21.51           C  
ATOM   1311  C   LEU B  20       2.961  78.651  17.547  1.00 21.71           C  
ATOM   1312  O   LEU B  20       2.474  77.917  16.679  1.00 22.18           O  
ATOM   1313  CB  LEU B  20       4.810  80.044  16.648  1.00 21.44           C  
ATOM   1314  CG  LEU B  20       6.234  80.600  16.734  1.00 22.88           C  
ATOM   1315  CD1 LEU B  20       6.417  81.734  15.734  1.00 27.63           C  
ATOM   1316  CD2 LEU B  20       6.538  81.085  18.137  1.00 23.41           C  
ATOM   1317  N   SER B  21       2.243  79.255  18.499  1.00 21.76           N  
ATOM   1318  CA  SER B  21       0.788  79.255  18.507  1.00 22.13           C  
ATOM   1319  C   SER B  21       0.337  80.182  17.395  1.00 22.32           C  
ATOM   1320  O   SER B  21       1.109  81.044  16.983  1.00 22.52           O  
ATOM   1321  CB  SER B  21       0.257  79.779  19.842  1.00 22.03           C  
ATOM   1322  OG  SER B  21       0.653  81.127  20.047  1.00 24.86           O  
ATOM   1323  N   PRO B  22      -0.903  79.996  16.889  1.00 22.31           N  
ATOM   1324  CA  PRO B  22      -1.560  80.954  15.984  1.00 22.27           C  
ATOM   1325  C   PRO B  22      -1.409  82.423  16.410  1.00 22.19           C  
ATOM   1326  O   PRO B  22      -1.144  83.285  15.571  1.00 22.41           O  
ATOM   1327  CB  PRO B  22      -3.028  80.527  16.048  1.00 22.53           C  
ATOM   1328  CG  PRO B  22      -2.950  79.056  16.256  1.00 22.82           C  
ATOM   1329  CD  PRO B  22      -1.730  78.792  17.101  1.00 22.00           C  
ATOM   1330  N   VAL B  23      -1.564  82.691  17.706  1.00 21.83           N  
ATOM   1331  CA  VAL B  23      -1.435  84.043  18.257  1.00 21.17           C  
ATOM   1332  C   VAL B  23      -0.030  84.607  18.028  1.00 20.62           C  
ATOM   1333  O   VAL B  23       0.121  85.712  17.509  1.00 21.42           O  
ATOM   1334  CB  VAL B  23      -1.779  84.084  19.775  1.00 21.03           C  
ATOM   1335  CG1 VAL B  23      -1.844  85.531  20.279  1.00 21.87           C  
ATOM   1336  CG2 VAL B  23      -3.087  83.370  20.043  1.00 20.81           C  
ATOM   1337  N   GLN B  24       0.983  83.832  18.408  1.00 19.65           N  
ATOM   1338  CA  GLN B  24       2.394  84.228  18.274  1.00 19.28           C  
ATOM   1339  C   GLN B  24       2.807  84.444  16.831  1.00 19.09           C  
ATOM   1340  O   GLN B  24       3.562  85.367  16.533  1.00 19.17           O  
ATOM   1341  CB  GLN B  24       3.311  83.197  18.949  1.00 18.57           C  
ATOM   1342  CG  GLN B  24       3.257  83.262  20.491  1.00 18.16           C  
ATOM   1343  CD  GLN B  24       3.885  82.056  21.168  1.00 20.26           C  
ATOM   1344  OE1 GLN B  24       4.129  81.025  20.541  1.00 24.03           O  
ATOM   1345  NE2 GLN B  24       4.131  82.174  22.467  1.00 21.59           N  
ATOM   1346  N   LEU B  25       2.292  83.597  15.942  1.00 19.03           N  
ATOM   1347  CA  LEU B  25       2.577  83.674  14.510  1.00 19.46           C  
ATOM   1348  C   LEU B  25       2.026  84.968  13.904  1.00 20.07           C  
ATOM   1349  O   LEU B  25       2.724  85.654  13.151  1.00 19.33           O  
ATOM   1350  CB  LEU B  25       2.009  82.444  13.788  1.00 18.75           C  
ATOM   1351  CG  LEU B  25       2.506  82.151  12.376  1.00 21.79           C  
ATOM   1352  CD1 LEU B  25       4.014  82.412  12.218  1.00 22.04           C  
ATOM   1353  CD2 LEU B  25       2.170  80.730  12.004  1.00 24.53           C  
ATOM   1354  N   GLN B  26       0.780  85.286  14.254  1.00 20.00           N  
ATOM   1355  CA  GLN B  26       0.111  86.520  13.867  1.00 21.11           C  
ATOM   1356  C   GLN B  26       0.952  87.730  14.271  1.00 21.31           C  
ATOM   1357  O   GLN B  26       1.155  88.638  13.479  1.00 22.18           O  
ATOM   1358  CB  GLN B  26      -1.288  86.566  14.529  1.00 20.84           C  
ATOM   1359  CG  GLN B  26      -2.228  87.698  14.089  1.00 22.22           C  
ATOM   1360  CD  GLN B  26      -3.421  87.918  15.052  1.00 22.75           C  
ATOM   1361  OE1 GLN B  26      -3.252  88.351  16.199  1.00 22.73           O  
ATOM   1362  NE2 GLN B  26      -4.628  87.637  14.569  1.00 25.40           N  
ATOM   1363  N   GLU B  27       1.455  87.728  15.504  1.00 22.61           N  
ATOM   1364  CA  GLU B  27       2.232  88.851  16.037  1.00 23.18           C  
ATOM   1365  C   GLU B  27       3.558  89.031  15.285  1.00 22.30           C  
ATOM   1366  O   GLU B  27       4.008  90.156  15.052  1.00 21.59           O  
ATOM   1367  CB  GLU B  27       2.464  88.675  17.543  1.00 22.90           C  
ATOM   1368  CG  GLU B  27       3.081  89.898  18.240  1.00 25.32           C  
ATOM   1369  CD  GLU B  27       3.168  89.775  19.761  1.00 26.18           C  
ATOM   1370  OE1 GLU B  27       2.517  88.882  20.353  1.00 34.62           O  
ATOM   1371  OE2 GLU B  27       3.886  90.593  20.378  1.00 32.83           O  
ATOM   1372  N   LEU B  28       4.154  87.906  14.893  1.00 21.65           N  
ATOM   1373  CA  LEU B  28       5.401  87.876  14.123  1.00 21.05           C  
ATOM   1374  C   LEU B  28       5.213  88.440  12.715  1.00 19.64           C  
ATOM   1375  O   LEU B  28       5.997  89.297  12.280  1.00 17.25           O  
ATOM   1376  CB  LEU B  28       5.958  86.437  14.075  1.00 21.20           C  
ATOM   1377  CG  LEU B  28       7.349  86.170  13.489  1.00 23.51           C  
ATOM   1378  CD1 LEU B  28       8.423  87.064  14.119  1.00 25.19           C  
ATOM   1379  CD2 LEU B  28       7.710  84.708  13.643  1.00 21.76           C  
ATOM   1380  N   LEU B  29       4.181  87.946  12.022  1.00 19.76           N  
ATOM   1381  CA  LEU B  29       3.724  88.530  10.749  1.00 20.78           C  
ATOM   1382  C   LEU B  29       3.413  90.025  10.820  1.00 20.70           C  
ATOM   1383  O   LEU B  29       3.751  90.771   9.911  1.00 20.62           O  
ATOM   1384  CB  LEU B  29       2.506  87.779  10.191  1.00 20.41           C  
ATOM   1385  CG  LEU B  29       2.838  86.460   9.492  1.00 20.39           C  
ATOM   1386  CD1 LEU B  29       1.619  85.576   9.442  1.00 18.39           C  
ATOM   1387  CD2 LEU B  29       3.391  86.716   8.087  1.00 18.64           C  
ATOM   1388  N   ALA B  30       2.774  90.448  11.903  1.00 21.56           N  
ATOM   1389  CA  ALA B  30       2.400  91.854  12.083  1.00 22.12           C  
ATOM   1390  C   ALA B  30       3.609  92.811  12.060  1.00 21.95           C  
ATOM   1391  O   ALA B  30       3.507  93.941  11.568  1.00 22.10           O  
ATOM   1392  CB  ALA B  30       1.575  92.026  13.380  1.00 22.06           C  
ATOM   1393  N   SER B  31       4.744  92.352  12.580  1.00 21.73           N  
ATOM   1394  CA  SER B  31       5.978  93.147  12.584  1.00 22.09           C  
ATOM   1395  C   SER B  31       6.910  92.866  11.383  1.00 21.05           C  
ATOM   1396  O   SER B  31       7.980  93.481  11.256  1.00 21.74           O  
ATOM   1397  CB  SER B  31       6.745  92.921  13.887  1.00 22.54           C  
ATOM   1398  OG  SER B  31       7.824  93.835  14.002  1.00 25.67           O  
ATOM   1399  N   SER B  32       6.521  91.951  10.505  1.00 19.15           N  
ATOM   1400  CA  SER B  32       7.346  91.675   9.327  1.00 19.77           C  
ATOM   1401  C   SER B  32       7.178  92.730   8.215  1.00 18.98           C  
ATOM   1402  O   SER B  32       6.227  93.484   8.217  1.00 19.33           O  
ATOM   1403  CB  SER B  32       7.081  90.259   8.788  1.00 19.60           C  
ATOM   1404  OG  SER B  32       5.862  90.191   8.080  1.00 21.92           O  
ATOM   1405  N   ASP B  33       8.129  92.772   7.287  1.00 19.24           N  
ATOM   1406  CA  ASP B  33       8.058  93.581   6.074  1.00 19.27           C  
ATOM   1407  C   ASP B  33       7.963  92.657   4.867  1.00 18.96           C  
ATOM   1408  O   ASP B  33       8.625  91.640   4.808  1.00 18.90           O  
ATOM   1409  CB  ASP B  33       9.340  94.402   5.904  1.00 18.11           C  
ATOM   1410  CG  ASP B  33       9.580  95.367   7.052  1.00 25.78           C  
ATOM   1411  OD1 ASP B  33       8.605  96.024   7.486  1.00 24.86           O  
ATOM   1412  OD2 ASP B  33      10.752  95.483   7.491  1.00 32.48           O  
ATOM   1413  N   LEU B  34       7.165  93.036   3.886  1.00 19.10           N  
ATOM   1414  CA  LEU B  34       7.187  92.376   2.598  1.00 20.30           C  
ATOM   1415  C   LEU B  34       8.297  92.972   1.719  1.00 21.82           C  
ATOM   1416  O   LEU B  34       8.448  94.218   1.628  1.00 21.36           O  
ATOM   1417  CB  LEU B  34       5.843  92.580   1.920  1.00 20.79           C  
ATOM   1418  CG  LEU B  34       5.688  91.819   0.620  1.00 18.68           C  
ATOM   1419  CD1 LEU B  34       5.654  90.344   0.902  1.00 19.24           C  
ATOM   1420  CD2 LEU B  34       4.393  92.322  -0.055  1.00 19.47           C  
ATOM   1421  N   VAL B  35       9.075  92.092   1.086  1.00 20.77           N  
ATOM   1422  CA  VAL B  35      10.271  92.533   0.376  1.00 20.70           C  
ATOM   1423  C   VAL B  35      10.174  92.015  -1.033  1.00 19.54           C  
ATOM   1424  O   VAL B  35       9.963  90.815  -1.251  1.00 19.84           O  
ATOM   1425  CB  VAL B  35      11.597  92.009   1.041  1.00 21.02           C  
ATOM   1426  CG1 VAL B  35      12.832  92.431   0.213  1.00 23.77           C  
ATOM   1427  CG2 VAL B  35      11.709  92.486   2.483  1.00 20.53           C  
ATOM   1428  N   ASN B  36      10.340  92.924  -1.984  1.00 19.16           N  
ATOM   1429  CA  ASN B  36      10.215  92.582  -3.393  1.00 19.87           C  
ATOM   1430  C   ASN B  36      11.537  92.789  -4.121  1.00 19.44           C  
ATOM   1431  O   ASN B  36      12.102  93.894  -4.044  1.00 18.44           O  
ATOM   1432  CB  ASN B  36       9.172  93.481  -4.026  1.00 17.83           C  
ATOM   1433  CG  ASN B  36       7.805  93.297  -3.424  1.00 19.09           C  
ATOM   1434  OD1 ASN B  36       7.246  92.213  -3.467  1.00 16.10           O  
ATOM   1435  ND2 ASN B  36       7.214  94.393  -2.944  1.00 14.30           N  
ATOM   1436  N   LEU B  37      11.993  91.792  -4.897  1.00 17.30           N  
ATOM   1437  CA  LEU B  37      13.340  91.935  -5.504  1.00 18.41           C  
ATOM   1438  C   LEU B  37      13.429  91.511  -6.936  1.00 18.28           C  
ATOM   1439  O   LEU B  37      12.876  90.499  -7.292  1.00 18.97           O  
ATOM   1440  CB  LEU B  37      14.380  91.120  -4.713  1.00 19.44           C  
ATOM   1441  CG  LEU B  37      14.747  91.499  -3.268  1.00 19.20           C  
ATOM   1442  CD1 LEU B  37      15.630  90.398  -2.706  1.00 26.21           C  
ATOM   1443  CD2 LEU B  37      15.408  92.897  -3.113  1.00 22.77           C  
ATOM   1444  N   ASP B  38      14.154  92.281  -7.737  1.00 18.93           N  
ATOM   1445  CA  ASP B  38      14.454  91.899  -9.100  1.00 20.34           C  
ATOM   1446  C   ASP B  38      15.636  90.940  -9.085  1.00 19.47           C  
ATOM   1447  O   ASP B  38      16.347  90.866  -8.098  1.00 19.82           O  
ATOM   1448  CB  ASP B  38      14.805  93.140  -9.901  1.00 22.25           C  
ATOM   1449  CG  ASP B  38      13.580  93.865 -10.396  1.00 27.74           C  
ATOM   1450  OD1 ASP B  38      12.489  93.230 -10.492  1.00 37.48           O  
ATOM   1451  OD2 ASP B  38      13.722  95.062 -10.720  1.00 38.23           O  
ATOM   1452  N   LYS B  39      15.820  90.209 -10.176  1.00 18.30           N  
ATOM   1453  CA  LYS B  39      16.986  89.362 -10.384  1.00 17.98           C  
ATOM   1454  C   LYS B  39      18.189  90.233 -10.253  1.00 16.94           C  
ATOM   1455  O   LYS B  39      18.254  91.304 -10.887  1.00 15.16           O  
ATOM   1456  CB  LYS B  39      16.962  88.793 -11.825  1.00 20.73           C  
ATOM   1457  CG  LYS B  39      18.249  88.032 -12.229  1.00 20.56           C  
ATOM   1458  CD  LYS B  39      18.400  87.860 -13.748  1.00 21.15           C  
ATOM   1459  CE  LYS B  39      17.230  87.151 -14.398  1.00 36.63           C  
ATOM   1460  NZ  LYS B  39      16.991  85.813 -13.781  1.00 44.91           N  
ATOM   1461  N   GLY B  40      19.132  89.800  -9.425  1.00 16.40           N  
ATOM   1462  CA  GLY B  40      20.397  90.521  -9.279  1.00 17.28           C  
ATOM   1463  C   GLY B  40      20.359  91.461  -8.079  1.00 19.51           C  
ATOM   1464  O   GLY B  40      21.375  92.031  -7.723  1.00 17.41           O  
ATOM   1465  N   ALA B  41      19.184  91.639  -7.457  1.00 18.84           N  
ATOM   1466  CA  ALA B  41      19.069  92.625  -6.373  1.00 19.44           C  
ATOM   1467  C   ALA B  41      19.493  91.975  -5.056  1.00 18.81           C  
ATOM   1468  O   ALA B  41      19.325  90.771  -4.899  1.00 17.81           O  
ATOM   1469  CB  ALA B  41      17.614  93.151  -6.269  1.00 19.56           C  
ATOM   1470  N   TYR B  42      20.039  92.769  -4.120  1.00 18.26           N  
ATOM   1471  CA  TYR B  42      20.518  92.238  -2.863  1.00 17.48           C  
ATOM   1472  C   TYR B  42      19.444  92.136  -1.806  1.00 19.64           C  
ATOM   1473  O   TYR B  42      18.666  93.084  -1.634  1.00 21.47           O  
ATOM   1474  CB  TYR B  42      21.700  93.071  -2.351  1.00 19.21           C  
ATOM   1475  CG  TYR B  42      22.868  92.923  -3.292  1.00 18.77           C  
ATOM   1476  CD1 TYR B  42      23.115  93.890  -4.260  1.00 18.54           C  
ATOM   1477  CD2 TYR B  42      23.631  91.757  -3.293  1.00 18.42           C  
ATOM   1478  CE1 TYR B  42      24.183  93.746  -5.184  1.00 24.94           C  
ATOM   1479  CE2 TYR B  42      24.697  91.589  -4.191  1.00 18.19           C  
ATOM   1480  CZ  TYR B  42      24.964  92.584  -5.132  1.00 22.14           C  
ATOM   1481  OH  TYR B  42      25.972  92.420  -6.029  1.00 22.35           O  
ATOM   1482  N   VAL B  43      19.389  91.003  -1.097  1.00 19.90           N  
ATOM   1483  CA  VAL B  43      18.521  90.920   0.096  1.00 21.03           C  
ATOM   1484  C   VAL B  43      19.267  91.626   1.266  1.00 22.31           C  
ATOM   1485  O   VAL B  43      18.697  92.409   1.984  1.00 20.63           O  
ATOM   1486  CB  VAL B  43      18.229  89.522   0.536  1.00 21.45           C  
ATOM   1487  CG1 VAL B  43      17.120  89.547   1.593  1.00 21.56           C  
ATOM   1488  CG2 VAL B  43      17.796  88.627  -0.659  1.00 21.41           C  
ATOM   1489  N   PHE B  44      20.553  91.310   1.435  1.00 20.42           N  
ATOM   1490  CA  PHE B  44      21.415  92.049   2.333  1.00 20.60           C  
ATOM   1491  C   PHE B  44      22.843  91.851   1.827  1.00 20.56           C  
ATOM   1492  O   PHE B  44      23.087  90.956   0.989  1.00 19.05           O  
ATOM   1493  CB  PHE B  44      21.257  91.576   3.775  1.00 18.60           C  
ATOM   1494  CG  PHE B  44      21.399  90.065   3.968  1.00 20.52           C  
ATOM   1495  CD1 PHE B  44      20.291  89.283   4.174  1.00 17.12           C  
ATOM   1496  CD2 PHE B  44      22.662  89.455   4.018  1.00 17.11           C  
ATOM   1497  CE1 PHE B  44      20.436  87.860   4.422  1.00 18.97           C  
ATOM   1498  CE2 PHE B  44      22.803  88.092   4.240  1.00 21.33           C  
ATOM   1499  CZ  PHE B  44      21.670  87.298   4.445  1.00 17.50           C  
ATOM   1500  N   ARG B  45      23.731  92.740   2.263  1.00 18.03           N  
ATOM   1501  CA  ARG B  45      25.153  92.719   1.895  1.00 18.69           C  
ATOM   1502  C   ARG B  45      26.033  92.385   3.112  1.00 19.61           C  
ATOM   1503  O   ARG B  45      25.713  92.762   4.231  1.00 18.12           O  
ATOM   1504  CB  ARG B  45      25.587  94.065   1.282  1.00 17.63           C  
ATOM   1505  CG  ARG B  45      24.705  94.511   0.085  1.00 18.00           C  
ATOM   1506  CD  ARG B  45      24.979  96.003  -0.295  1.00 19.97           C  
ATOM   1507  NE  ARG B  45      24.121  96.395  -1.431  1.00 16.84           N  
ATOM   1508  CZ  ARG B  45      22.837  96.679  -1.283  1.00 21.24           C  
ATOM   1509  NH1 ARG B  45      22.306  96.640  -0.063  1.00 16.70           N  
ATOM   1510  NH2 ARG B  45      22.103  97.045  -2.328  1.00 17.81           N  
ATOM   1511  N   GLN B  46      27.134  91.671   2.872  1.00 18.98           N  
ATOM   1512  CA  GLN B  46      28.039  91.314   3.917  1.00 19.63           C  
ATOM   1513  C   GLN B  46      28.493  92.624   4.576  1.00 19.85           C  
ATOM   1514  O   GLN B  46      28.773  93.586   3.882  1.00 19.65           O  
ATOM   1515  CB  GLN B  46      29.225  90.525   3.359  1.00 19.24           C  
ATOM   1516  CG  GLN B  46      30.402  90.322   4.407  1.00 20.38           C  
ATOM   1517  CD  GLN B  46      31.456  89.358   3.916  1.00 21.97           C  
ATOM   1518  OE1 GLN B  46      31.256  88.662   2.909  1.00 24.07           O  
ATOM   1519  NE2 GLN B  46      32.593  89.295   4.631  1.00 21.61           N  
ATOM   1520  N   GLY B  47      28.498  92.651   5.912  1.00 19.35           N  
ATOM   1521  CA  GLY B  47      29.024  93.790   6.680  1.00 19.25           C  
ATOM   1522  C   GLY B  47      27.947  94.784   7.077  1.00 18.09           C  
ATOM   1523  O   GLY B  47      28.206  95.717   7.803  1.00 17.36           O  
ATOM   1524  N   GLU B  48      26.739  94.579   6.589  1.00 18.02           N  
ATOM   1525  CA  GLU B  48      25.601  95.352   7.018  1.00 19.30           C  
ATOM   1526  C   GLU B  48      25.082  94.820   8.325  1.00 19.19           C  
ATOM   1527  O   GLU B  48      25.155  93.613   8.554  1.00 18.45           O  
ATOM   1528  CB  GLU B  48      24.478  95.236   5.980  1.00 19.31           C  
ATOM   1529  CG  GLU B  48      24.702  96.147   4.814  1.00 24.05           C  
ATOM   1530  CD  GLU B  48      23.610  95.999   3.740  1.00 31.77           C  
ATOM   1531  OE1 GLU B  48      22.810  95.020   3.739  1.00 23.90           O  
ATOM   1532  OE2 GLU B  48      23.573  96.897   2.890  1.00 29.72           O  
ATOM   1533  N   PRO B  49      24.487  95.703   9.157  1.00 20.07           N  
ATOM   1534  CA  PRO B  49      23.932  95.288  10.449  1.00 21.35           C  
ATOM   1535  C   PRO B  49      22.908  94.166  10.314  1.00 21.35           C  
ATOM   1536  O   PRO B  49      21.972  94.279   9.531  1.00 22.38           O  
ATOM   1537  CB  PRO B  49      23.307  96.590  10.994  1.00 22.24           C  
ATOM   1538  CG  PRO B  49      24.103  97.658  10.338  1.00 21.37           C  
ATOM   1539  CD  PRO B  49      24.307  97.154   8.946  1.00 19.55           C  
ATOM   1540  N   ALA B  50      23.099  93.067  11.038  1.00 20.80           N  
ATOM   1541  CA  ALA B  50      22.193  91.928  10.838  1.00 20.87           C  
ATOM   1542  C   ALA B  50      21.090  91.996  11.863  1.00 20.82           C  
ATOM   1543  O   ALA B  50      21.299  91.598  13.007  1.00 23.15           O  
ATOM   1544  CB  ALA B  50      22.937  90.611  10.963  1.00 19.90           C  
ATOM   1545  N   HIS B  51      19.935  92.516  11.473  1.00 20.31           N  
ATOM   1546  CA  HIS B  51      18.777  92.622  12.383  1.00 21.27           C  
ATOM   1547  C   HIS B  51      17.587  91.733  11.993  1.00 19.50           C  
ATOM   1548  O   HIS B  51      16.609  91.686  12.711  1.00 19.96           O  
ATOM   1549  CB  HIS B  51      18.271  94.079  12.460  1.00 21.65           C  
ATOM   1550  CG  HIS B  51      19.266  95.042  13.016  1.00 25.71           C  
ATOM   1551  ND1 HIS B  51      19.987  94.785  14.157  1.00 28.70           N  
ATOM   1552  CD2 HIS B  51      19.637  96.278  12.605  1.00 31.54           C  
ATOM   1553  CE1 HIS B  51      20.772  95.815  14.422  1.00 31.88           C  
ATOM   1554  NE2 HIS B  51      20.575  96.735  13.498  1.00 33.14           N  
ATOM   1555  N   ALA B  52      17.654  91.035  10.867  1.00 17.73           N  
ATOM   1556  CA  ALA B  52      16.481  90.313  10.384  1.00 18.05           C  
ATOM   1557  C   ALA B  52      16.855  89.011   9.703  1.00 18.27           C  
ATOM   1558  O   ALA B  52      17.963  88.886   9.198  1.00 19.61           O  
ATOM   1559  CB  ALA B  52      15.707  91.182   9.428  1.00 17.33           C  
ATOM   1560  N   PHE B  53      15.956  88.031   9.725  1.00 17.89           N  
ATOM   1561  CA  PHE B  53      16.074  86.881   8.830  1.00 17.98           C  
ATOM   1562  C   PHE B  53      14.866  86.867   7.882  1.00 19.45           C  
ATOM   1563  O   PHE B  53      13.947  87.669   8.058  1.00 19.39           O  
ATOM   1564  CB  PHE B  53      16.184  85.572   9.608  1.00 15.07           C  
ATOM   1565  CG  PHE B  53      14.955  85.209  10.362  1.00 15.63           C  
ATOM   1566  CD1 PHE B  53      14.633  85.861  11.565  1.00 15.38           C  
ATOM   1567  CD2 PHE B  53      14.131  84.174   9.916  1.00 18.49           C  
ATOM   1568  CE1 PHE B  53      13.497  85.516  12.283  1.00 16.72           C  
ATOM   1569  CE2 PHE B  53      12.978  83.822  10.625  1.00 16.73           C  
ATOM   1570  CZ  PHE B  53      12.669  84.478  11.816  1.00 18.32           C  
ATOM   1571  N   TYR B  54      14.892  85.954   6.907  1.00 18.53           N  
ATOM   1572  CA  TYR B  54      14.009  85.995   5.754  1.00 18.51           C  
ATOM   1573  C   TYR B  54      13.297  84.657   5.514  1.00 21.05           C  
ATOM   1574  O   TYR B  54      13.861  83.592   5.711  1.00 19.36           O  
ATOM   1575  CB  TYR B  54      14.795  86.390   4.511  1.00 19.42           C  
ATOM   1576  CG  TYR B  54      15.295  87.802   4.625  1.00 21.50           C  
ATOM   1577  CD1 TYR B  54      16.442  88.108   5.366  1.00 18.27           C  
ATOM   1578  CD2 TYR B  54      14.565  88.846   4.061  1.00 20.60           C  
ATOM   1579  CE1 TYR B  54      16.860  89.454   5.514  1.00 17.49           C  
ATOM   1580  CE2 TYR B  54      14.954  90.156   4.222  1.00 20.25           C  
ATOM   1581  CZ  TYR B  54      16.109  90.450   4.917  1.00 20.35           C  
ATOM   1582  OH  TYR B  54      16.466  91.795   5.028  1.00 25.94           O  
ATOM   1583  N   TYR B  55      12.026  84.744   5.136  1.00 20.61           N  
ATOM   1584  CA  TYR B  55      11.349  83.612   4.529  1.00 21.22           C  
ATOM   1585  C   TYR B  55      11.168  83.919   3.042  1.00 22.38           C  
ATOM   1586  O   TYR B  55      10.671  84.997   2.675  1.00 24.45           O  
ATOM   1587  CB  TYR B  55      10.012  83.407   5.201  1.00 21.74           C  
ATOM   1588  CG  TYR B  55       9.183  82.302   4.615  1.00 19.21           C  
ATOM   1589  CD1 TYR B  55       8.219  82.596   3.658  1.00 20.27           C  
ATOM   1590  CD2 TYR B  55       9.366  80.982   5.005  1.00 20.00           C  
ATOM   1591  CE1 TYR B  55       7.435  81.626   3.099  1.00 24.90           C  
ATOM   1592  CE2 TYR B  55       8.555  79.961   4.452  1.00 25.40           C  
ATOM   1593  CZ  TYR B  55       7.599  80.318   3.496  1.00 22.31           C  
ATOM   1594  OH  TYR B  55       6.808  79.408   2.902  1.00 21.35           O  
ATOM   1595  N   LEU B  56      11.572  82.983   2.191  1.00 21.27           N  
ATOM   1596  CA  LEU B  56      11.476  83.177   0.737  1.00 21.52           C  
ATOM   1597  C   LEU B  56      10.117  82.671   0.234  1.00 20.30           C  
ATOM   1598  O   LEU B  56       9.871  81.462   0.124  1.00 18.93           O  
ATOM   1599  CB  LEU B  56      12.662  82.456   0.028  1.00 21.77           C  
ATOM   1600  CG  LEU B  56      12.919  82.642  -1.464  1.00 19.57           C  
ATOM   1601  CD1 LEU B  56      12.955  84.097  -1.862  1.00 23.41           C  
ATOM   1602  CD2 LEU B  56      14.213  81.920  -1.863  1.00 19.60           C  
ATOM   1603  N   ILE B  57       9.221  83.607  -0.069  1.00 19.70           N  
ATOM   1604  CA  ILE B  57       7.883  83.228  -0.527  1.00 18.49           C  
ATOM   1605  C   ILE B  57       8.025  82.627  -1.928  1.00 19.02           C  
ATOM   1606  O   ILE B  57       7.605  81.510  -2.164  1.00 18.82           O  
ATOM   1607  CB  ILE B  57       6.891  84.418  -0.528  1.00 17.86           C  
ATOM   1608  CG1 ILE B  57       6.771  85.040   0.878  1.00 17.49           C  
ATOM   1609  CG2 ILE B  57       5.524  83.996  -1.094  1.00 18.19           C  
ATOM   1610  CD1 ILE B  57       6.553  86.561   0.809  1.00 16.89           C  
ATOM   1611  N   SER B  58       8.686  83.357  -2.832  1.00 21.20           N  
ATOM   1612  CA  SER B  58       8.780  82.913  -4.227  1.00 21.03           C  
ATOM   1613  C   SER B  58      10.134  83.346  -4.711  1.00 21.38           C  
ATOM   1614  O   SER B  58      10.659  84.384  -4.271  1.00 20.55           O  
ATOM   1615  CB  SER B  58       7.676  83.560  -5.082  1.00 23.06           C  
ATOM   1616  OG  SER B  58       7.856  84.978  -5.166  1.00 20.09           O  
ATOM   1617  N   GLY B  59      10.715  82.564  -5.612  1.00 20.87           N  
ATOM   1618  CA  GLY B  59      11.995  82.947  -6.191  1.00 21.56           C  
ATOM   1619  C   GLY B  59      13.124  82.085  -5.670  1.00 21.19           C  
ATOM   1620  O   GLY B  59      12.888  80.932  -5.293  1.00 18.93           O  
ATOM   1621  N   CYS B  60      14.335  82.666  -5.619  1.00 21.65           N  
ATOM   1622  CA  CYS B  60      15.575  81.910  -5.365  1.00 20.24           C  
ATOM   1623  C   CYS B  60      16.726  82.864  -5.019  1.00 21.00           C  
ATOM   1624  O   CYS B  60      16.964  83.839  -5.714  1.00 19.02           O  
ATOM   1625  CB  CYS B  60      15.917  81.041  -6.577  1.00 20.09           C  
ATOM   1626  SG  CYS B  60      17.431  80.018  -6.448  1.00 21.57           S  
ATOM   1627  N   VAL B  61      17.429  82.586  -3.921  1.00 20.54           N  
ATOM   1628  CA  VAL B  61      18.442  83.541  -3.368  1.00 19.70           C  
ATOM   1629  C   VAL B  61      19.766  82.782  -3.205  1.00 19.54           C  
ATOM   1630  O   VAL B  61      19.759  81.639  -2.751  1.00 18.96           O  
ATOM   1631  CB  VAL B  61      17.958  84.087  -2.018  1.00 20.24           C  
ATOM   1632  CG1 VAL B  61      19.108  84.586  -1.145  1.00 22.41           C  
ATOM   1633  CG2 VAL B  61      16.886  85.199  -2.246  1.00 20.38           C  
ATOM   1634  N   LYS B  62      20.883  83.361  -3.652  1.00 16.80           N  
ATOM   1635  CA  LYS B  62      22.178  82.748  -3.398  1.00 17.30           C  
ATOM   1636  C   LYS B  62      22.929  83.507  -2.297  1.00 18.47           C  
ATOM   1637  O   LYS B  62      22.816  84.754  -2.168  1.00 17.98           O  
ATOM   1638  CB  LYS B  62      23.029  82.640  -4.672  1.00 18.22           C  
ATOM   1639  CG  LYS B  62      23.543  83.974  -5.234  1.00 17.18           C  
ATOM   1640  CD  LYS B  62      24.684  83.739  -6.219  1.00 20.18           C  
ATOM   1641  CE  LYS B  62      25.077  85.073  -6.870  1.00 26.45           C  
ATOM   1642  NZ  LYS B  62      26.212  85.004  -7.882  1.00 22.89           N  
ATOM   1643  N   ILE B  63      23.699  82.773  -1.497  1.00 18.01           N  
ATOM   1644  CA  ILE B  63      24.398  83.388  -0.358  1.00 18.11           C  
ATOM   1645  C   ILE B  63      25.903  83.094  -0.450  1.00 16.46           C  
ATOM   1646  O   ILE B  63      26.294  81.952  -0.549  1.00 17.32           O  
ATOM   1647  CB  ILE B  63      23.773  82.890   1.018  1.00 20.09           C  
ATOM   1648  CG1 ILE B  63      22.255  83.190   1.031  1.00 21.85           C  
ATOM   1649  CG2 ILE B  63      24.523  83.490   2.226  1.00 17.71           C  
ATOM   1650  CD1 ILE B  63      21.604  82.992   2.319  1.00 28.93           C  
ATOM   1651  N   TYR B  64      26.734  84.133  -0.417  1.00 16.65           N  
ATOM   1652  CA  TYR B  64      28.173  84.025  -0.703  1.00 16.07           C  
ATOM   1653  C   TYR B  64      29.000  85.086   0.027  1.00 17.63           C  
ATOM   1654  O   TYR B  64      28.469  86.141   0.370  1.00 18.87           O  
ATOM   1655  CB  TYR B  64      28.444  84.179  -2.218  1.00 15.52           C  
ATOM   1656  CG  TYR B  64      28.051  85.543  -2.809  1.00 17.44           C  
ATOM   1657  CD1 TYR B  64      26.761  85.778  -3.221  1.00 20.62           C  
ATOM   1658  CD2 TYR B  64      28.993  86.583  -2.960  1.00 17.76           C  
ATOM   1659  CE1 TYR B  64      26.374  87.000  -3.758  1.00 22.98           C  
ATOM   1660  CE2 TYR B  64      28.612  87.822  -3.516  1.00 20.11           C  
ATOM   1661  CZ  TYR B  64      27.287  88.002  -3.913  1.00 23.52           C  
ATOM   1662  OH  TYR B  64      26.838  89.177  -4.468  1.00 23.79           O  
ATOM   1663  N   ARG B  65      30.291  84.827   0.248  1.00 18.90           N  
ATOM   1664  CA  ARG B  65      31.211  85.890   0.654  1.00 21.07           C  
ATOM   1665  C   ARG B  65      32.180  86.195  -0.495  1.00 22.84           C  
ATOM   1666  O   ARG B  65      32.765  85.273  -1.108  1.00 21.91           O  
ATOM   1667  CB  ARG B  65      32.054  85.497   1.872  1.00 22.96           C  
ATOM   1668  CG  ARG B  65      31.306  84.884   3.063  1.00 25.31           C  
ATOM   1669  CD  ARG B  65      32.201  83.840   3.745  1.00 34.21           C  
ATOM   1670  NE  ARG B  65      31.849  83.565   5.142  1.00 40.01           N  
ATOM   1671  CZ  ARG B  65      32.637  83.837   6.185  1.00 43.76           C  
ATOM   1672  NH1 ARG B  65      33.827  84.398   6.011  1.00 46.44           N  
ATOM   1673  NH2 ARG B  65      32.240  83.551   7.414  1.00 47.41           N  
ATOM   1674  N   LEU B  66      32.373  87.487  -0.763  1.00 23.93           N  
ATOM   1675  CA  LEU B  66      33.312  87.941  -1.767  1.00 24.68           C  
ATOM   1676  C   LEU B  66      34.679  88.050  -1.134  1.00 25.91           C  
ATOM   1677  O   LEU B  66      34.833  88.575  -0.026  1.00 26.49           O  
ATOM   1678  CB  LEU B  66      32.868  89.272  -2.347  1.00 25.71           C  
ATOM   1679  N   THR B  67      35.673  87.520  -1.832  1.00 26.32           N  
ATOM   1680  CA  THR B  67      37.023  87.464  -1.322  1.00 26.59           C  
ATOM   1681  C   THR B  67      37.795  88.738  -1.735  1.00 26.88           C  
ATOM   1682  O   THR B  67      37.376  89.444  -2.655  1.00 25.83           O  
ATOM   1683  CB  THR B  67      37.757  86.167  -1.798  1.00 27.79           C  
ATOM   1684  OG1 THR B  67      38.242  86.327  -3.142  1.00 24.49           O  
ATOM   1685  CG2 THR B  67      36.818  84.934  -1.690  1.00 28.34           C  
ATOM   1686  N   PRO B  68      38.902  89.046  -1.030  1.00 27.18           N  
ATOM   1687  CA  PRO B  68      39.814  90.154  -1.335  1.00 27.73           C  
ATOM   1688  C   PRO B  68      40.301  90.220  -2.800  1.00 28.40           C  
ATOM   1689  O   PRO B  68      40.856  91.252  -3.237  1.00 28.25           O  
ATOM   1690  CB  PRO B  68      41.017  89.873  -0.419  1.00 28.74           C  
ATOM   1691  CG  PRO B  68      40.467  89.100   0.717  1.00 28.25           C  
ATOM   1692  CD  PRO B  68      39.302  88.317   0.189  1.00 27.27           C  
ATOM   1693  N   GLU B  69      40.145  89.126  -3.539  1.00 28.94           N  
ATOM   1694  CA  GLU B  69      40.598  89.099  -4.928  1.00 30.42           C  
ATOM   1695  C   GLU B  69      39.408  89.140  -5.893  1.00 30.94           C  
ATOM   1696  O   GLU B  69      39.571  88.994  -7.107  1.00 31.54           O  
ATOM   1697  CB  GLU B  69      41.508  87.895  -5.199  1.00 30.18           C  
ATOM   1698  CG  GLU B  69      42.861  88.303  -5.757  1.00 32.46           C  
ATOM   1699  CD  GLU B  69      43.262  87.548  -7.017  1.00 35.96           C  
ATOM   1700  OE1 GLU B  69      44.121  88.082  -7.768  1.00 39.60           O  
ATOM   1701  OE2 GLU B  69      42.725  86.439  -7.270  1.00 39.20           O  
ATOM   1702  N   GLY B  70      38.217  89.353  -5.342  1.00 30.73           N  
ATOM   1703  CA  GLY B  70      37.022  89.555  -6.150  1.00 31.77           C  
ATOM   1704  C   GLY B  70      36.059  88.383  -6.289  1.00 31.73           C  
ATOM   1705  O   GLY B  70      34.910  88.592  -6.669  1.00 33.64           O  
ATOM   1706  N   GLN B  71      36.501  87.164  -5.970  1.00 31.99           N  
ATOM   1707  CA  GLN B  71      35.709  85.929  -6.217  1.00 31.72           C  
ATOM   1708  C   GLN B  71      34.707  85.536  -5.123  1.00 31.61           C  
ATOM   1709  O   GLN B  71      34.957  85.740  -3.935  1.00 31.29           O  
ATOM   1710  CB  GLN B  71      36.653  84.754  -6.518  1.00 32.94           C  
ATOM   1711  N   GLU B  72      33.573  84.964  -5.530  1.00 30.98           N  
ATOM   1712  CA  GLU B  72      32.540  84.521  -4.592  1.00 31.09           C  
ATOM   1713  C   GLU B  72      32.877  83.166  -3.959  1.00 28.66           C  
ATOM   1714  O   GLU B  72      33.122  82.200  -4.671  1.00 28.41           O  
ATOM   1715  CB  GLU B  72      31.194  84.377  -5.314  1.00 31.14           C  
ATOM   1716  CG  GLU B  72      30.728  85.563  -6.145  1.00 34.06           C  
ATOM   1717  CD  GLU B  72      29.685  85.150  -7.189  1.00 34.83           C  
ATOM   1718  OE1 GLU B  72      28.592  84.663  -6.809  1.00 39.46           O  
ATOM   1719  OE2 GLU B  72      29.969  85.297  -8.402  1.00 42.78           O  
ATOM   1720  N   LYS B  73      32.889  83.080  -2.632  1.00 27.31           N  
ATOM   1721  CA  LYS B  73      32.748  81.768  -1.988  1.00 25.48           C  
ATOM   1722  C   LYS B  73      31.285  81.533  -1.629  1.00 23.36           C  
ATOM   1723  O   LYS B  73      30.717  82.292  -0.854  1.00 21.23           O  
ATOM   1724  CB  LYS B  73      33.632  81.598  -0.746  1.00 27.03           C  
ATOM   1725  CG  LYS B  73      33.082  80.498   0.182  1.00 29.15           C  
ATOM   1726  CD  LYS B  73      34.110  79.780   1.040  1.00 36.52           C  
ATOM   1727  CE  LYS B  73      33.486  78.545   1.729  1.00 34.29           C  
ATOM   1728  NZ  LYS B  73      32.040  78.734   2.094  1.00 36.00           N  
ATOM   1729  N   ILE B  74      30.684  80.467  -2.165  1.00 22.30           N  
ATOM   1730  CA  ILE B  74      29.234  80.249  -2.021  1.00 21.73           C  
ATOM   1731  C   ILE B  74      28.883  79.456  -0.752  1.00 21.53           C  
ATOM   1732  O   ILE B  74      29.477  78.424  -0.477  1.00 22.27           O  
ATOM   1733  CB  ILE B  74      28.612  79.581  -3.305  1.00 22.54           C  
ATOM   1734  CG1 ILE B  74      29.055  80.301  -4.607  1.00 17.99           C  
ATOM   1735  CG2 ILE B  74      27.074  79.449  -3.187  1.00 20.52           C  
ATOM   1736  CD1 ILE B  74      28.365  81.543  -4.897  0.50 14.68           C  
ATOM   1737  N   LEU B  75      27.926  79.955   0.024  1.00 21.36           N  
ATOM   1738  CA  LEU B  75      27.466  79.275   1.256  1.00 21.55           C  
ATOM   1739  C   LEU B  75      26.270  78.358   0.963  1.00 21.20           C  
ATOM   1740  O   LEU B  75      26.273  77.175   1.340  1.00 18.56           O  
ATOM   1741  CB  LEU B  75      27.090  80.295   2.355  1.00 21.90           C  
ATOM   1742  CG  LEU B  75      28.237  81.007   3.097  1.00 25.36           C  
ATOM   1743  CD1 LEU B  75      28.893  82.049   2.222  1.00 28.91           C  
ATOM   1744  CD2 LEU B  75      27.748  81.665   4.343  1.00 20.65           C  
ATOM   1745  N   GLU B  76      25.259  78.908   0.275  1.00 19.24           N  
ATOM   1746  CA  GLU B  76      24.056  78.148  -0.029  1.00 20.28           C  
ATOM   1747  C   GLU B  76      23.243  78.807  -1.135  1.00 19.29           C  
ATOM   1748  O   GLU B  76      23.392  79.994  -1.416  1.00 18.91           O  
ATOM   1749  CB  GLU B  76      23.206  77.991   1.235  1.00 21.52           C  
ATOM   1750  CG  GLU B  76      23.079  79.302   2.014  1.00 18.92           C  
ATOM   1751  CD  GLU B  76      22.553  79.131   3.457  1.00 27.60           C  
ATOM   1752  OE1 GLU B  76      21.588  78.340   3.670  1.00 43.68           O  
ATOM   1753  OE2 GLU B  76      23.093  79.806   4.374  1.00 29.13           O  
ATOM   1754  N   VAL B  77      22.392  78.012  -1.768  1.00 18.54           N  
ATOM   1755  CA  VAL B  77      21.369  78.512  -2.660  1.00 20.28           C  
ATOM   1756  C   VAL B  77      20.035  78.147  -2.001  1.00 22.07           C  
ATOM   1757  O   VAL B  77      19.790  76.969  -1.713  1.00 20.36           O  
ATOM   1758  CB  VAL B  77      21.486  77.896  -4.063  1.00 20.00           C  
ATOM   1759  CG1 VAL B  77      20.321  78.367  -4.953  1.00 21.86           C  
ATOM   1760  CG2 VAL B  77      22.873  78.256  -4.688  1.00 16.54           C  
ATOM   1761  N   THR B  78      19.209  79.155  -1.706  1.00 21.87           N  
ATOM   1762  CA  THR B  78      17.930  78.922  -1.022  1.00 23.16           C  
ATOM   1763  C   THR B  78      16.754  78.864  -2.006  1.00 22.65           C  
ATOM   1764  O   THR B  78      16.582  79.754  -2.833  1.00 22.27           O  
ATOM   1765  CB  THR B  78      17.664  80.011   0.024  1.00 24.32           C  
ATOM   1766  OG1 THR B  78      18.811  80.141   0.896  1.00 29.73           O  
ATOM   1767  CG2 THR B  78      16.416  79.683   0.847  1.00 23.83           C  
ATOM   1768  N   ASN B  79      15.945  77.820  -1.891  1.00 23.20           N  
ATOM   1769  CA  ASN B  79      14.741  77.633  -2.719  1.00 23.61           C  
ATOM   1770  C   ASN B  79      13.509  78.219  -2.039  1.00 23.46           C  
ATOM   1771  O   ASN B  79      13.513  78.418  -0.806  1.00 23.36           O  
ATOM   1772  CB  ASN B  79      14.532  76.132  -2.996  1.00 24.14           C  
ATOM   1773  CG  ASN B  79      15.725  75.510  -3.734  1.00 27.94           C  
ATOM   1774  OD1 ASN B  79      16.159  76.009  -4.771  1.00 27.40           O  
ATOM   1775  ND2 ASN B  79      16.272  74.443  -3.175  1.00 30.45           N  
ATOM   1776  N   GLU B  80      12.456  78.487  -2.816  1.00 22.38           N  
ATOM   1777  CA  GLU B  80      11.237  79.050  -2.223  1.00 22.88           C  
ATOM   1778  C   GLU B  80      10.698  78.212  -1.062  1.00 21.80           C  
ATOM   1779  O   GLU B  80      11.010  77.015  -0.946  1.00 20.38           O  
ATOM   1780  CB  GLU B  80      10.141  79.378  -3.279  1.00 23.26           C  
ATOM   1781  CG  GLU B  80       9.571  78.258  -4.102  1.00 22.41           C  
ATOM   1782  CD  GLU B  80       8.758  78.809  -5.303  1.00 25.43           C  
ATOM   1783  OE1 GLU B  80       9.091  79.920  -5.824  1.00 32.90           O  
ATOM   1784  OE2 GLU B  80       7.806  78.135  -5.736  1.00 26.05           O  
ATOM   1785  N   ARG B  81       9.922  78.864  -0.195  1.00 21.17           N  
ATOM   1786  CA  ARG B  81       9.340  78.249   1.016  1.00 20.84           C  
ATOM   1787  C   ARG B  81      10.420  77.754   2.017  1.00 20.55           C  
ATOM   1788  O   ARG B  81      10.217  76.779   2.746  1.00 19.63           O  
ATOM   1789  CB  ARG B  81       8.332  77.159   0.653  1.00 20.29           C  
ATOM   1790  CG  ARG B  81       7.170  77.645  -0.232  1.00 21.17           C  
ATOM   1791  CD  ARG B  81       6.051  76.560  -0.392  1.00 25.19           C  
ATOM   1792  NE  ARG B  81       6.492  75.394  -1.170  1.00 36.06           N  
ATOM   1793  CZ  ARG B  81       6.664  75.377  -2.496  1.00 41.54           C  
ATOM   1794  NH1 ARG B  81       6.433  76.459  -3.240  1.00 45.45           N  
ATOM   1795  NH2 ARG B  81       7.083  74.270  -3.088  1.00 40.46           N  
ATOM   1796  N   ASN B  82      11.567  78.441   2.023  1.00 19.52           N  
ATOM   1797  CA  ASN B  82      12.643  78.172   2.968  1.00 19.34           C  
ATOM   1798  C   ASN B  82      13.116  79.454   3.564  1.00 18.52           C  
ATOM   1799  O   ASN B  82      12.836  80.495   3.010  1.00 18.33           O  
ATOM   1800  CB  ASN B  82      13.817  77.536   2.267  1.00 19.75           C  
ATOM   1801  CG  ASN B  82      13.592  76.101   2.021  1.00 20.66           C  
ATOM   1802  OD1 ASN B  82      13.718  75.296   2.924  1.00 19.70           O  
ATOM   1803  ND2 ASN B  82      13.238  75.758   0.797  1.00 29.19           N  
ATOM   1804  N   THR B  83      13.789  79.363   4.712  1.00 18.19           N  
ATOM   1805  CA  THR B  83      14.266  80.543   5.449  1.00 16.92           C  
ATOM   1806  C   THR B  83      15.749  80.618   5.262  1.00 16.46           C  
ATOM   1807  O   THR B  83      16.359  79.649   4.880  1.00 15.19           O  
ATOM   1808  CB  THR B  83      13.973  80.492   6.982  1.00 16.60           C  
ATOM   1809  OG1 THR B  83      14.427  79.234   7.529  1.00 17.18           O  
ATOM   1810  CG2 THR B  83      12.464  80.666   7.249  1.00 16.25           C  
ATOM   1811  N   PHE B  84      16.314  81.792   5.519  1.00 17.35           N  
ATOM   1812  CA  PHE B  84      17.740  81.960   5.542  1.00 17.07           C  
ATOM   1813  C   PHE B  84      18.128  83.095   6.478  1.00 16.60           C  
ATOM   1814  O   PHE B  84      17.310  83.958   6.793  1.00 15.95           O  
ATOM   1815  CB  PHE B  84      18.318  82.137   4.107  1.00 18.93           C  
ATOM   1816  CG  PHE B  84      17.791  83.349   3.347  1.00 17.46           C  
ATOM   1817  CD1 PHE B  84      16.666  83.240   2.515  1.00 20.99           C  
ATOM   1818  CD2 PHE B  84      18.485  84.545   3.383  1.00 15.92           C  
ATOM   1819  CE1 PHE B  84      16.233  84.326   1.770  1.00 18.20           C  
ATOM   1820  CE2 PHE B  84      18.071  85.635   2.655  1.00 15.57           C  
ATOM   1821  CZ  PHE B  84      16.950  85.542   1.852  1.00 15.94           C  
ATOM   1822  N   ALA B  85      19.374  83.065   6.944  1.00 17.46           N  
ATOM   1823  CA  ALA B  85      19.905  84.076   7.865  1.00 18.17           C  
ATOM   1824  C   ALA B  85      19.432  83.974   9.331  1.00 18.87           C  
ATOM   1825  O   ALA B  85      19.785  84.828  10.148  1.00 19.54           O  
ATOM   1826  CB  ALA B  85      19.681  85.524   7.287  1.00 19.39           C  
ATOM   1827  N   GLU B  86      18.682  82.930   9.682  1.00 18.90           N  
ATOM   1828  CA  GLU B  86      18.174  82.797  11.059  1.00 20.01           C  
ATOM   1829  C   GLU B  86      19.308  82.495  12.050  1.00 20.05           C  
ATOM   1830  O   GLU B  86      19.219  82.833  13.227  1.00 19.84           O  
ATOM   1831  CB  GLU B  86      17.105  81.711  11.155  1.00 20.08           C  
ATOM   1832  CG  GLU B  86      17.592  80.310  10.798  1.00 21.05           C  
ATOM   1833  CD  GLU B  86      17.296  79.920   9.349  1.00 27.83           C  
ATOM   1834  OE1 GLU B  86      17.245  80.809   8.485  1.00 31.54           O  
ATOM   1835  OE2 GLU B  86      17.118  78.722   9.073  1.00 27.45           O  
ATOM   1836  N   ALA B  87      20.385  81.899  11.546  1.00 19.48           N  
ATOM   1837  CA  ALA B  87      21.567  81.641  12.348  1.00 20.24           C  
ATOM   1838  C   ALA B  87      22.185  82.911  12.921  1.00 19.09           C  
ATOM   1839  O   ALA B  87      22.971  82.834  13.855  1.00 17.67           O  
ATOM   1840  CB  ALA B  87      22.612  80.856  11.546  1.00 20.23           C  
ATOM   1841  N   MET B  88      21.824  84.068  12.366  1.00 19.31           N  
ATOM   1842  CA  MET B  88      22.524  85.319  12.699  1.00 20.15           C  
ATOM   1843  C   MET B  88      22.178  85.759  14.114  1.00 21.08           C  
ATOM   1844  O   MET B  88      22.987  86.401  14.790  1.00 20.35           O  
ATOM   1845  CB  MET B  88      22.224  86.439  11.677  1.00 19.99           C  
ATOM   1846  CG  MET B  88      22.959  86.321  10.294  1.00 19.89           C  
ATOM   1847  SD  MET B  88      24.778  86.286  10.305  1.00 24.07           S  
ATOM   1848  CE  MET B  88      25.181  87.733  11.270  1.00 24.69           C  
ATOM   1849  N   MET B  89      20.977  85.392  14.551  1.00 22.43           N  
ATOM   1850  CA  MET B  89      20.478  85.669  15.902  1.00 25.07           C  
ATOM   1851  C   MET B  89      21.287  85.021  17.022  1.00 22.73           C  
ATOM   1852  O   MET B  89      21.239  85.461  18.171  1.00 22.03           O  
ATOM   1853  CB  MET B  89      19.078  85.100  16.027  1.00 24.99           C  
ATOM   1854  CG  MET B  89      17.976  86.045  15.773  1.00 28.66           C  
ATOM   1855  SD  MET B  89      16.410  85.160  15.689  1.00 32.73           S  
ATOM   1856  CE  MET B  89      16.475  84.538  14.011  1.00 25.53           C  
ATOM   1857  N   PHE B  90      21.984  83.947  16.681  1.00 22.28           N  
ATOM   1858  CA  PHE B  90      22.692  83.101  17.649  1.00 21.65           C  
ATOM   1859  C   PHE B  90      24.170  83.047  17.294  1.00 23.55           C  
ATOM   1860  O   PHE B  90      24.838  82.021  17.455  1.00 23.71           O  
ATOM   1861  CB  PHE B  90      22.084  81.691  17.681  1.00 20.75           C  
ATOM   1862  CG  PHE B  90      20.601  81.672  17.928  1.00 18.31           C  
ATOM   1863  CD1 PHE B  90      19.709  81.548  16.861  1.00 22.52           C  
ATOM   1864  CD2 PHE B  90      20.093  81.799  19.221  1.00 17.50           C  
ATOM   1865  CE1 PHE B  90      18.323  81.532  17.072  1.00 21.13           C  
ATOM   1866  CE2 PHE B  90      18.703  81.793  19.449  1.00 18.44           C  
ATOM   1867  CZ  PHE B  90      17.816  81.663  18.369  1.00 20.68           C  
ATOM   1868  N   MET B  91      24.653  84.170  16.777  1.00 25.98           N  
ATOM   1869  CA  MET B  91      26.069  84.431  16.573  1.00 30.58           C  
ATOM   1870  C   MET B  91      26.393  85.683  17.390  1.00 29.98           C  
ATOM   1871  O   MET B  91      25.576  86.596  17.499  1.00 32.29           O  
ATOM   1872  CB  MET B  91      26.333  84.679  15.083  1.00 30.49           C  
ATOM   1873  CG  MET B  91      26.465  83.407  14.266  1.00 34.33           C  
ATOM   1874  SD  MET B  91      26.643  83.676  12.488  1.00 35.72           S  
ATOM   1875  CE  MET B  91      27.871  84.976  12.424  1.00 37.41           C  
ATOM   1876  N   ASP B  92      27.562  85.751  17.982  1.00 30.40           N  
ATOM   1877  CA  ASP B  92      27.882  86.963  18.731  1.00 30.11           C  
ATOM   1878  C   ASP B  92      28.536  87.958  17.779  1.00 29.36           C  
ATOM   1879  O   ASP B  92      29.635  88.443  18.024  1.00 30.07           O  
ATOM   1880  CB  ASP B  92      28.736  86.654  19.959  1.00 29.59           C  
ATOM   1881  CG  ASP B  92      27.919  86.046  21.111  1.00 31.90           C  
ATOM   1882  OD1 ASP B  92      26.669  85.980  21.012  1.00 29.92           O  
ATOM   1883  OD2 ASP B  92      28.533  85.636  22.130  1.00 34.44           O  
ATOM   1884  N   THR B  93      27.845  88.237  16.676  1.00 27.86           N  
ATOM   1885  CA  THR B  93      28.374  89.108  15.630  1.00 27.23           C  
ATOM   1886  C   THR B  93      27.304  90.108  15.177  1.00 24.91           C  
ATOM   1887  O   THR B  93      26.171  89.720  14.923  1.00 25.62           O  
ATOM   1888  CB  THR B  93      28.967  88.302  14.433  1.00 26.56           C  
ATOM   1889  OG1 THR B  93      30.230  88.855  14.075  1.00 28.75           O  
ATOM   1890  CG2 THR B  93      28.098  88.368  13.227  1.00 30.21           C  
ATOM   1891  N   PRO B  94      27.668  91.400  15.116  1.00 22.56           N  
ATOM   1892  CA  PRO B  94      26.736  92.466  14.762  1.00 20.62           C  
ATOM   1893  C   PRO B  94      26.236  92.448  13.298  1.00 18.07           C  
ATOM   1894  O   PRO B  94      25.096  92.801  13.072  1.00 17.76           O  
ATOM   1895  CB  PRO B  94      27.554  93.738  15.019  1.00 19.60           C  
ATOM   1896  CG  PRO B  94      28.965  93.312  14.856  1.00 21.51           C  
ATOM   1897  CD  PRO B  94      29.012  91.930  15.422  1.00 22.38           C  
ATOM   1898  N   ASN B  95      27.097  92.059  12.354  1.00 15.84           N  
ATOM   1899  CA  ASN B  95      26.875  92.247  10.929  1.00 15.09           C  
ATOM   1900  C   ASN B  95      26.743  90.943  10.151  1.00 15.12           C  
ATOM   1901  O   ASN B  95      27.433  89.969  10.473  1.00 13.85           O  
ATOM   1902  CB  ASN B  95      28.044  93.029  10.308  1.00 14.71           C  
ATOM   1903  CG  ASN B  95      28.220  94.412  10.909  1.00 17.03           C  
ATOM   1904  OD1 ASN B  95      29.341  94.924  11.007  1.00 17.89           O  
ATOM   1905  ND2 ASN B  95      27.121  95.027  11.304  1.00 19.44           N  
ATOM   1906  N   TYR B  96      25.904  90.951   9.098  1.00 14.63           N  
ATOM   1907  CA  TYR B  96      25.864  89.850   8.138  1.00 14.73           C  
ATOM   1908  C   TYR B  96      27.279  89.463   7.731  1.00 15.16           C  
ATOM   1909  O   TYR B  96      28.071  90.315   7.343  1.00 15.55           O  
ATOM   1910  CB  TYR B  96      25.036  90.211   6.887  1.00 14.27           C  
ATOM   1911  CG  TYR B  96      23.556  90.317   7.191  1.00 13.53           C  
ATOM   1912  CD1 TYR B  96      22.810  89.194   7.507  1.00 12.87           C  
ATOM   1913  CD2 TYR B  96      22.916  91.554   7.160  1.00 18.99           C  
ATOM   1914  CE1 TYR B  96      21.436  89.301   7.820  1.00 14.94           C  
ATOM   1915  CE2 TYR B  96      21.581  91.682   7.457  1.00 14.28           C  
ATOM   1916  CZ  TYR B  96      20.839  90.554   7.781  1.00 18.27           C  
ATOM   1917  OH  TYR B  96      19.478  90.708   8.065  1.00 17.74           O  
ATOM   1918  N   VAL B  97      27.588  88.177   7.834  1.00 15.17           N  
ATOM   1919  CA  VAL B  97      28.900  87.635   7.457  1.00 16.40           C  
ATOM   1920  C   VAL B  97      28.943  87.152   5.990  1.00 17.83           C  
ATOM   1921  O   VAL B  97      29.919  86.530   5.583  1.00 19.59           O  
ATOM   1922  CB  VAL B  97      29.239  86.429   8.365  1.00 16.28           C  
ATOM   1923  CG1 VAL B  97      29.437  86.869   9.800  1.00 19.05           C  
ATOM   1924  CG2 VAL B  97      28.105  85.418   8.302  1.00 16.15           C  
ATOM   1925  N   ALA B  98      27.878  87.395   5.227  1.00 16.90           N  
ATOM   1926  CA  ALA B  98      27.792  87.046   3.800  1.00 18.82           C  
ATOM   1927  C   ALA B  98      26.756  87.950   3.130  1.00 19.49           C  
ATOM   1928  O   ALA B  98      26.027  88.655   3.824  1.00 19.07           O  
ATOM   1929  CB  ALA B  98      27.377  85.568   3.626  1.00 18.65           C  
ATOM   1930  N   THR B  99      26.666  87.877   1.798  1.00 20.14           N  
ATOM   1931  CA  THR B  99      25.719  88.655   0.980  1.00 19.10           C  
ATOM   1932  C   THR B  99      24.699  87.676   0.453  1.00 20.30           C  
ATOM   1933  O   THR B  99      25.041  86.544   0.158  1.00 21.02           O  
ATOM   1934  CB  THR B  99      26.489  89.255  -0.238  1.00 19.89           C  
ATOM   1935  OG1 THR B  99      27.501  90.155   0.237  1.00 19.36           O  
ATOM   1936  CG2 THR B  99      25.609  89.952  -1.219  1.00 19.19           C  
ATOM   1937  N   ALA B 100      23.456  88.118   0.319  1.00 20.22           N  
ATOM   1938  CA  ALA B 100      22.362  87.283  -0.214  1.00 18.68           C  
ATOM   1939  C   ALA B 100      21.814  88.060  -1.394  1.00 17.73           C  
ATOM   1940  O   ALA B 100      21.489  89.248  -1.251  1.00 16.33           O  
ATOM   1941  CB  ALA B 100      21.288  87.093   0.823  1.00 17.32           C  
ATOM   1942  N   GLN B 101      21.732  87.402  -2.553  1.00 17.11           N  
ATOM   1943  CA  GLN B 101      21.347  88.051  -3.809  1.00 17.67           C  
ATOM   1944  C   GLN B 101      20.294  87.217  -4.499  1.00 17.49           C  
ATOM   1945  O   GLN B 101      20.439  86.005  -4.603  1.00 19.09           O  
ATOM   1946  CB  GLN B 101      22.565  88.190  -4.751  1.00 17.92           C  
ATOM   1947  CG  GLN B 101      22.306  89.045  -6.028  1.00 21.31           C  
ATOM   1948  CD  GLN B 101      23.571  89.243  -6.885  1.00 21.78           C  
ATOM   1949  OE1 GLN B 101      23.739  90.252  -7.572  1.00 26.11           O  
ATOM   1950  NE2 GLN B 101      24.450  88.309  -6.816  1.00 21.85           N  
ATOM   1951  N   ALA B 102      19.253  87.853  -5.009  1.00 16.98           N  
ATOM   1952  CA  ALA B 102      18.219  87.138  -5.741  1.00 18.91           C  
ATOM   1953  C   ALA B 102      18.792  86.732  -7.092  1.00 19.02           C  
ATOM   1954  O   ALA B 102      19.424  87.542  -7.773  1.00 19.77           O  
ATOM   1955  CB  ALA B 102      16.999  88.024  -5.924  1.00 17.47           C  
ATOM   1956  N   VAL B 103      18.622  85.473  -7.464  1.00 19.96           N  
ATOM   1957  CA  VAL B 103      19.041  85.029  -8.787  1.00 22.47           C  
ATOM   1958  C   VAL B 103      17.870  85.020  -9.807  1.00 22.78           C  
ATOM   1959  O   VAL B 103      18.115  84.846 -10.984  1.00 23.74           O  
ATOM   1960  CB  VAL B 103      19.732  83.670  -8.767  1.00 24.36           C  
ATOM   1961  CG1 VAL B 103      20.744  83.582  -7.610  1.00 27.64           C  
ATOM   1962  CG2 VAL B 103      18.734  82.609  -8.649  1.00 21.82           C  
ATOM   1963  N   VAL B 104      16.631  85.213  -9.339  1.00 21.15           N  
ATOM   1964  CA  VAL B 104      15.428  85.475 -10.181  1.00 20.56           C  
ATOM   1965  C   VAL B 104      14.541  86.482  -9.410  1.00 21.15           C  
ATOM   1966  O   VAL B 104      14.792  86.711  -8.232  1.00 21.43           O  
ATOM   1967  CB  VAL B 104      14.598  84.195 -10.457  1.00 20.29           C  
ATOM   1968  CG1 VAL B 104      15.398  83.177 -11.277  1.00 21.28           C  
ATOM   1969  CG2 VAL B 104      14.133  83.577  -9.170  1.00 20.93           C  
ATOM   1970  N   PRO B 105      13.519  87.089 -10.069  1.00 21.64           N  
ATOM   1971  CA  PRO B 105      12.585  87.938  -9.322  1.00 21.75           C  
ATOM   1972  C   PRO B 105      12.040  87.167  -8.128  1.00 21.28           C  
ATOM   1973  O   PRO B 105      11.574  86.034  -8.301  1.00 18.73           O  
ATOM   1974  CB  PRO B 105      11.461  88.198 -10.319  1.00 22.12           C  
ATOM   1975  CG  PRO B 105      12.168  88.164 -11.684  1.00 24.35           C  
ATOM   1976  CD  PRO B 105      13.159  87.006 -11.506  1.00 22.88           C  
ATOM   1977  N   SER B 106      12.111  87.767  -6.938  1.00 18.86           N  
ATOM   1978  CA  SER B 106      11.795  87.040  -5.708  1.00 17.71           C  
ATOM   1979  C   SER B 106      10.932  87.898  -4.787  1.00 19.19           C  
ATOM   1980  O   SER B 106      10.924  89.138  -4.886  1.00 21.06           O  
ATOM   1981  CB  SER B 106      13.124  86.637  -4.987  1.00 18.64           C  
ATOM   1982  OG  SER B 106      13.941  85.817  -5.838  1.00 17.49           O  
ATOM   1983  N   GLN B 107      10.221  87.241  -3.876  1.00 16.76           N  
ATOM   1984  CA  GLN B 107       9.453  87.945  -2.881  1.00 16.74           C  
ATOM   1985  C   GLN B 107       9.711  87.296  -1.529  1.00 16.58           C  
ATOM   1986  O   GLN B 107       9.741  86.073  -1.419  1.00 15.29           O  
ATOM   1987  CB  GLN B 107       7.941  87.939  -3.220  1.00 13.96           C  
ATOM   1988  CG  GLN B 107       7.163  88.877  -2.327  1.00 17.87           C  
ATOM   1989  CD  GLN B 107       5.715  89.060  -2.741  1.00 22.64           C  
ATOM   1990  OE1 GLN B 107       4.960  88.105  -2.778  1.00 24.25           O  
ATOM   1991  NE2 GLN B 107       5.323  90.297  -3.039  1.00 23.82           N  
ATOM   1992  N   LEU B 108       9.873  88.123  -0.500  1.00 17.84           N  
ATOM   1993  CA  LEU B 108      10.216  87.619   0.834  1.00 19.48           C  
ATOM   1994  C   LEU B 108       9.421  88.273   1.931  1.00 20.82           C  
ATOM   1995  O   LEU B 108       8.846  89.341   1.714  1.00 22.91           O  
ATOM   1996  CB  LEU B 108      11.713  87.809   1.144  1.00 18.26           C  
ATOM   1997  CG  LEU B 108      12.655  87.404   0.010  1.00 22.35           C  
ATOM   1998  CD1 LEU B 108      13.262  88.698  -0.555  1.00 24.22           C  
ATOM   1999  CD2 LEU B 108      13.756  86.530   0.505  1.00 22.65           C  
ATOM   2000  N   PHE B 109       9.397  87.609   3.097  1.00 19.71           N  
ATOM   2001  CA  PHE B 109       9.034  88.202   4.370  1.00 19.76           C  
ATOM   2002  C   PHE B 109      10.324  88.458   5.106  1.00 19.50           C  
ATOM   2003  O   PHE B 109      11.148  87.558   5.195  1.00 20.84           O  
ATOM   2004  CB  PHE B 109       8.219  87.210   5.192  1.00 20.22           C  
ATOM   2005  CG  PHE B 109       6.791  87.085   4.762  1.00 21.01           C  
ATOM   2006  CD1 PHE B 109       6.206  85.829   4.648  1.00 17.67           C  
ATOM   2007  CD2 PHE B 109       6.023  88.220   4.497  1.00 17.49           C  
ATOM   2008  CE1 PHE B 109       4.868  85.681   4.273  1.00 16.41           C  
ATOM   2009  CE2 PHE B 109       4.672  88.096   4.124  1.00 23.29           C  
ATOM   2010  CZ  PHE B 109       4.089  86.817   4.018  1.00 20.17           C  
ATOM   2011  N   ARG B 110      10.525  89.668   5.613  1.00 20.16           N  
ATOM   2012  CA  ARG B 110      11.683  89.987   6.455  1.00 21.41           C  
ATOM   2013  C   ARG B 110      11.207  90.012   7.888  1.00 22.07           C  
ATOM   2014  O   ARG B 110      10.401  90.878   8.250  1.00 23.71           O  
ATOM   2015  CB  ARG B 110      12.223  91.374   6.134  1.00 21.04           C  
ATOM   2016  CG  ARG B 110      13.112  91.970   7.220  1.00 21.60           C  
ATOM   2017  CD  ARG B 110      13.982  93.168   6.722  1.00 24.48           C  
ATOM   2018  NE  ARG B 110      13.137  94.191   6.144  1.00 43.38           N  
ATOM   2019  CZ  ARG B 110      13.237  94.694   4.920  1.00 44.48           C  
ATOM   2020  NH1 ARG B 110      14.201  94.323   4.078  1.00 44.22           N  
ATOM   2021  NH2 ARG B 110      12.365  95.611   4.553  1.00 45.12           N  
ATOM   2022  N   PHE B 111      11.685  89.085   8.710  1.00 21.44           N  
ATOM   2023  CA  PHE B 111      11.300  89.059  10.117  1.00 20.37           C  
ATOM   2024  C   PHE B 111      12.397  89.658  10.978  1.00 21.72           C  
ATOM   2025  O   PHE B 111      13.562  89.352  10.791  1.00 24.12           O  
ATOM   2026  CB  PHE B 111      11.070  87.632  10.550  1.00 20.54           C  
ATOM   2027  CG  PHE B 111       9.959  86.950   9.831  1.00 20.77           C  
ATOM   2028  CD1 PHE B 111      10.220  86.055   8.812  1.00 19.34           C  
ATOM   2029  CD2 PHE B 111       8.653  87.177  10.182  1.00 22.18           C  
ATOM   2030  CE1 PHE B 111       9.199  85.398   8.171  1.00 16.15           C  
ATOM   2031  CE2 PHE B 111       7.631  86.523   9.528  1.00 22.99           C  
ATOM   2032  CZ  PHE B 111       7.914  85.635   8.521  1.00 20.28           C  
ATOM   2033  N   SER B 112      12.029  90.514  11.921  1.00 21.00           N  
ATOM   2034  CA  SER B 112      12.959  91.057  12.898  1.00 20.00           C  
ATOM   2035  C   SER B 112      13.496  89.968  13.831  1.00 18.79           C  
ATOM   2036  O   SER B 112      12.719  89.150  14.368  1.00 17.32           O  
ATOM   2037  CB  SER B 112      12.216  92.108  13.735  1.00 21.19           C  
ATOM   2038  OG  SER B 112      12.980  92.526  14.833  1.00 22.36           O  
ATOM   2039  N   ASN B 113      14.818  89.960  14.018  1.00 17.03           N  
ATOM   2040  CA  ASN B 113      15.459  89.113  15.016  1.00 16.36           C  
ATOM   2041  C   ASN B 113      14.808  89.375  16.355  1.00 16.39           C  
ATOM   2042  O   ASN B 113      14.344  88.444  17.015  1.00 16.96           O  
ATOM   2043  CB  ASN B 113      16.987  89.340  15.061  1.00 17.00           C  
ATOM   2044  CG  ASN B 113      17.702  88.776  13.829  1.00 17.94           C  
ATOM   2045  OD1 ASN B 113      17.087  88.152  12.988  1.00 20.97           O  
ATOM   2046  ND2 ASN B 113      18.998  88.997  13.729  1.00 21.08           N  
ATOM   2047  N   LYS B 114      14.696  90.654  16.712  1.00 15.80           N  
ATOM   2048  CA  LYS B 114      14.126  91.060  18.000  1.00 16.60           C  
ATOM   2049  C   LYS B 114      12.676  90.569  18.260  1.00 15.56           C  
ATOM   2050  O   LYS B 114      12.348  90.162  19.362  1.00 14.25           O  
ATOM   2051  CB  LYS B 114      14.246  92.595  18.182  1.00 16.22           C  
ATOM   2052  N   ALA B 115      11.826  90.613  17.234  1.00 14.89           N  
ATOM   2053  CA  ALA B 115      10.450  90.132  17.366  1.00 13.70           C  
ATOM   2054  C   ALA B 115      10.392  88.628  17.466  1.00 12.83           C  
ATOM   2055  O   ALA B 115       9.597  88.111  18.197  1.00 14.95           O  
ATOM   2056  CB  ALA B 115       9.584  90.601  16.196  1.00 12.18           C  
ATOM   2057  N   TYR B 116      11.211  87.915  16.712  1.00 13.33           N  
ATOM   2058  CA  TYR B 116      11.201  86.453  16.803  1.00 14.25           C  
ATOM   2059  C   TYR B 116      11.632  86.016  18.219  1.00 14.59           C  
ATOM   2060  O   TYR B 116      10.960  85.191  18.868  1.00 13.29           O  
ATOM   2061  CB  TYR B 116      12.071  85.833  15.700  1.00 14.16           C  
ATOM   2062  CG  TYR B 116      12.052  84.318  15.647  1.00 13.39           C  
ATOM   2063  CD1 TYR B 116      10.980  83.625  15.091  1.00 12.84           C  
ATOM   2064  CD2 TYR B 116      13.105  83.579  16.171  1.00 12.25           C  
ATOM   2065  CE1 TYR B 116      10.981  82.222  15.041  1.00 10.70           C  
ATOM   2066  CE2 TYR B 116      13.100  82.193  16.137  1.00 19.89           C  
ATOM   2067  CZ  TYR B 116      12.045  81.525  15.560  1.00 15.98           C  
ATOM   2068  OH  TYR B 116      12.080  80.151  15.535  1.00 16.21           O  
ATOM   2069  N   LEU B 117      12.710  86.627  18.711  1.00 14.37           N  
ATOM   2070  CA  LEU B 117      13.263  86.290  20.007  1.00 15.96           C  
ATOM   2071  C   LEU B 117      12.305  86.650  21.145  1.00 16.08           C  
ATOM   2072  O   LEU B 117      12.336  86.037  22.208  1.00 16.05           O  
ATOM   2073  CB  LEU B 117      14.635  86.960  20.202  1.00 16.68           C  
ATOM   2074  CG  LEU B 117      15.811  86.425  19.363  1.00 16.00           C  
ATOM   2075  CD1 LEU B 117      17.002  87.392  19.383  1.00 17.50           C  
ATOM   2076  CD2 LEU B 117      16.230  85.047  19.897  1.00 18.46           C  
ATOM   2077  N   ARG B 118      11.431  87.616  20.903  1.00 16.15           N  
ATOM   2078  CA  ARG B 118      10.381  87.943  21.847  1.00 17.27           C  
ATOM   2079  C   ARG B 118       9.384  86.795  22.009  1.00 16.20           C  
ATOM   2080  O   ARG B 118       8.933  86.525  23.131  1.00 15.16           O  
ATOM   2081  CB  ARG B 118       9.664  89.210  21.402  1.00 18.03           C  
ATOM   2082  CG  ARG B 118       9.264  90.171  22.541  1.00 22.47           C  
ATOM   2083  CD  ARG B 118       8.738  91.489  21.938  1.00 20.18           C  
ATOM   2084  NE  ARG B 118       9.754  92.130  21.119  1.00 28.52           N  
ATOM   2085  CZ  ARG B 118       9.523  92.789  19.985  1.00 34.98           C  
ATOM   2086  NH1 ARG B 118       8.287  92.903  19.497  1.00 37.22           N  
ATOM   2087  NH2 ARG B 118      10.544  93.322  19.326  1.00 32.41           N  
ATOM   2088  N   GLN B 119       9.033  86.135  20.903  1.00 15.40           N  
ATOM   2089  CA  GLN B 119       8.117  84.968  20.929  1.00 15.81           C  
ATOM   2090  C   GLN B 119       8.780  83.811  21.633  1.00 16.64           C  
ATOM   2091  O   GLN B 119       8.156  83.070  22.398  1.00 15.74           O  
ATOM   2092  CB  GLN B 119       7.737  84.495  19.516  1.00 14.99           C  
ATOM   2093  CG  GLN B 119       7.211  85.566  18.620  1.00 16.13           C  
ATOM   2094  CD  GLN B 119       6.193  86.421  19.320  1.00 21.50           C  
ATOM   2095  OE1 GLN B 119       5.114  85.948  19.691  1.00 18.69           O  
ATOM   2096  NE2 GLN B 119       6.538  87.691  19.530  1.00 22.91           N  
ATOM   2097  N   LEU B 120      10.066  83.662  21.340  1.00 18.13           N  
ATOM   2098  CA  LEU B 120      10.881  82.608  21.899  1.00 20.03           C  
ATOM   2099  C   LEU B 120      10.861  82.656  23.415  1.00 20.27           C  
ATOM   2100  O   LEU B 120      10.758  81.624  24.060  1.00 20.57           O  
ATOM   2101  CB  LEU B 120      12.311  82.732  21.358  1.00 20.49           C  
ATOM   2102  CG  LEU B 120      13.308  81.620  21.606  1.00 21.38           C  
ATOM   2103  CD1 LEU B 120      12.726  80.337  21.139  1.00 30.73           C  
ATOM   2104  CD2 LEU B 120      14.568  81.935  20.829  1.00 21.92           C  
ATOM   2105  N   GLN B 121      10.946  83.858  23.975  1.00 21.57           N  
ATOM   2106  CA  GLN B 121      10.933  84.049  25.418  1.00 22.44           C  
ATOM   2107  C   GLN B 121       9.683  83.511  26.123  1.00 22.39           C  
ATOM   2108  O   GLN B 121       9.704  83.352  27.338  1.00 22.21           O  
ATOM   2109  CB  GLN B 121      11.136  85.514  25.767  1.00 23.41           C  
ATOM   2110  CG  GLN B 121      12.498  86.058  25.342  1.00 27.65           C  
ATOM   2111  CD  GLN B 121      12.567  87.566  25.469  1.00 32.51           C  
ATOM   2112  OE1 GLN B 121      11.893  88.157  26.317  1.00 30.87           O  
ATOM   2113  NE2 GLN B 121      13.382  88.203  24.622  1.00 35.46           N  
ATOM   2114  N   ASP B 122       8.610  83.249  25.378  1.00 22.00           N  
ATOM   2115  CA  ASP B 122       7.487  82.483  25.925  1.00 22.93           C  
ATOM   2116  C   ASP B 122       7.034  81.294  25.063  1.00 21.93           C  
ATOM   2117  O   ASP B 122       5.840  81.011  24.919  1.00 22.11           O  
ATOM   2118  CB  ASP B 122       6.313  83.384  26.327  1.00 24.08           C  
ATOM   2119  CG  ASP B 122       5.695  84.110  25.153  1.00 29.38           C  
ATOM   2120  OD1 ASP B 122       4.463  83.980  24.956  1.00 33.77           O  
ATOM   2121  OD2 ASP B 122       6.436  84.825  24.440  1.00 37.50           O  
ATOM   2122  N   ASN B 123       8.003  80.596  24.494  1.00 20.57           N  
ATOM   2123  CA  ASN B 123       7.748  79.320  23.845  1.00 20.03           C  
ATOM   2124  C   ASN B 123       8.901  78.373  24.169  1.00 19.39           C  
ATOM   2125  O   ASN B 123       9.881  78.316  23.432  1.00 17.58           O  
ATOM   2126  CB  ASN B 123       7.582  79.488  22.326  1.00 19.46           C  
ATOM   2127  CG  ASN B 123       6.921  78.277  21.662  1.00 22.04           C  
ATOM   2128  OD1 ASN B 123       5.976  78.419  20.890  1.00 25.15           O  
ATOM   2129  ND2 ASN B 123       7.399  77.093  21.975  1.00 23.02           N  
ATOM   2130  N   THR B 124       8.784  77.640  25.278  1.00 18.64           N  
ATOM   2131  CA  THR B 124       9.826  76.655  25.659  1.00 19.37           C  
ATOM   2132  C   THR B 124      10.085  75.612  24.566  1.00 18.44           C  
ATOM   2133  O   THR B 124      11.228  75.416  24.227  1.00 18.28           O  
ATOM   2134  CB  THR B 124       9.550  75.947  26.980  1.00 18.27           C  
ATOM   2135  OG1 THR B 124       8.732  76.778  27.794  1.00 22.27           O  
ATOM   2136  CG2 THR B 124      10.845  75.644  27.716  1.00 21.77           C  
ATOM   2137  N   PRO B 125       9.030  74.988  23.981  1.00 19.16           N  
ATOM   2138  CA  PRO B 125       9.238  74.038  22.896  1.00 18.48           C  
ATOM   2139  C   PRO B 125      10.123  74.612  21.784  1.00 19.75           C  
ATOM   2140  O   PRO B 125      11.062  73.945  21.354  1.00 20.60           O  
ATOM   2141  CB  PRO B 125       7.816  73.794  22.374  1.00 19.15           C  
ATOM   2142  CG  PRO B 125       6.960  73.946  23.573  1.00 20.92           C  
ATOM   2143  CD  PRO B 125       7.591  75.115  24.300  1.00 21.19           C  
ATOM   2144  N   LEU B 126       9.849  75.843  21.345  1.00 19.45           N  
ATOM   2145  CA  LEU B 126      10.663  76.483  20.313  1.00 21.10           C  
ATOM   2146  C   LEU B 126      12.099  76.701  20.776  1.00 20.66           C  
ATOM   2147  O   LEU B 126      13.032  76.423  20.024  1.00 21.97           O  
ATOM   2148  CB  LEU B 126      10.031  77.798  19.826  1.00 20.25           C  
ATOM   2149  CG  LEU B 126      10.692  78.521  18.648  1.00 23.56           C  
ATOM   2150  CD1 LEU B 126      10.715  77.666  17.405  1.00 26.51           C  
ATOM   2151  CD2 LEU B 126      10.033  79.875  18.371  1.00 22.00           C  
ATOM   2152  N   ALA B 127      12.279  77.194  21.998  1.00 19.97           N  
ATOM   2153  CA  ALA B 127      13.623  77.361  22.556  1.00 20.77           C  
ATOM   2154  C   ALA B 127      14.403  76.052  22.516  1.00 21.54           C  
ATOM   2155  O   ALA B 127      15.536  76.025  22.047  1.00 22.06           O  
ATOM   2156  CB  ALA B 127      13.561  77.916  23.963  1.00 20.55           C  
ATOM   2157  N   LEU B 128      13.771  74.969  22.973  1.00 20.92           N  
ATOM   2158  CA  LEU B 128      14.380  73.633  22.980  1.00 20.95           C  
ATOM   2159  C   LEU B 128      14.718  73.105  21.592  1.00 20.03           C  
ATOM   2160  O   LEU B 128      15.747  72.446  21.413  1.00 19.42           O  
ATOM   2161  CB  LEU B 128      13.480  72.622  23.721  1.00 20.17           C  
ATOM   2162  CG  LEU B 128      13.221  72.924  25.205  1.00 24.73           C  
ATOM   2163  CD1 LEU B 128      12.628  71.700  25.884  1.00 34.74           C  
ATOM   2164  CD2 LEU B 128      14.491  73.417  25.952  1.00 22.51           C  
ATOM   2165  N   ALA B 129      13.834  73.355  20.629  1.00 19.11           N  
ATOM   2166  CA  ALA B 129      14.086  72.995  19.234  1.00 19.94           C  
ATOM   2167  C   ALA B 129      15.348  73.688  18.677  1.00 19.25           C  
ATOM   2168  O   ALA B 129      16.188  73.049  18.031  1.00 19.07           O  
ATOM   2169  CB  ALA B 129      12.862  73.317  18.363  1.00 19.54           C  
ATOM   2170  N   LEU B 130      15.463  74.993  18.912  1.00 20.04           N  
ATOM   2171  CA  LEU B 130      16.621  75.780  18.440  1.00 20.91           C  
ATOM   2172  C   LEU B 130      17.876  75.338  19.155  1.00 20.33           C  
ATOM   2173  O   LEU B 130      18.942  75.330  18.579  1.00 20.21           O  
ATOM   2174  CB  LEU B 130      16.413  77.277  18.670  1.00 21.28           C  
ATOM   2175  CG  LEU B 130      15.273  77.875  17.837  1.00 23.81           C  
ATOM   2176  CD1 LEU B 130      14.860  79.215  18.420  1.00 23.59           C  
ATOM   2177  CD2 LEU B 130      15.661  78.004  16.368  1.00 23.90           C  
ATOM   2178  N   LEU B 131      17.717  74.947  20.413  1.00 20.01           N  
ATOM   2179  CA  LEU B 131      18.801  74.417  21.215  1.00 19.90           C  
ATOM   2180  C   LEU B 131      19.320  73.111  20.587  1.00 18.95           C  
ATOM   2181  O   LEU B 131      20.531  72.900  20.502  1.00 17.96           O  
ATOM   2182  CB  LEU B 131      18.308  74.200  22.670  1.00 18.77           C  
ATOM   2183  CG  LEU B 131      19.286  74.221  23.841  1.00 21.19           C  
ATOM   2184  CD1 LEU B 131      20.399  75.248  23.679  1.00 21.64           C  
ATOM   2185  CD2 LEU B 131      18.518  74.496  25.120  1.00 19.51           C  
ATOM   2186  N   ALA B 132      18.402  72.249  20.148  1.00 18.18           N  
ATOM   2187  CA  ALA B 132      18.763  71.035  19.391  1.00 17.85           C  
ATOM   2188  C   ALA B 132      19.467  71.324  18.057  1.00 17.62           C  
ATOM   2189  O   ALA B 132      20.422  70.632  17.704  1.00 18.10           O  
ATOM   2190  CB  ALA B 132      17.544  70.138  19.172  1.00 17.55           C  
ATOM   2191  N   LYS B 133      19.009  72.350  17.336  1.00 16.65           N  
ATOM   2192  CA  LYS B 133      19.602  72.751  16.066  1.00 17.22           C  
ATOM   2193  C   LYS B 133      21.007  73.301  16.252  1.00 18.16           C  
ATOM   2194  O   LYS B 133      21.942  72.883  15.559  1.00 18.02           O  
ATOM   2195  CB  LYS B 133      18.724  73.804  15.387  1.00 18.19           C  
ATOM   2196  CG  LYS B 133      17.467  73.272  14.705  1.00 18.59           C  
ATOM   2197  CD  LYS B 133      17.805  72.812  13.321  1.00 26.70           C  
ATOM   2198  CE  LYS B 133      16.654  72.117  12.673  1.00 26.48           C  
ATOM   2199  NZ  LYS B 133      17.145  71.498  11.423  1.00 24.78           N  
ATOM   2200  N   LEU B 134      21.139  74.245  17.187  1.00 19.54           N  
ATOM   2201  CA  LEU B 134      22.419  74.871  17.505  1.00 21.82           C  
ATOM   2202  C   LEU B 134      23.413  73.826  17.951  1.00 22.05           C  
ATOM   2203  O   LEU B 134      24.596  73.921  17.641  1.00 22.47           O  
ATOM   2204  CB  LEU B 134      22.268  75.876  18.645  1.00 22.14           C  
ATOM   2205  CG  LEU B 134      22.008  77.362  18.430  1.00 26.33           C  
ATOM   2206  CD1 LEU B 134      22.394  78.084  19.739  1.00 26.03           C  
ATOM   2207  CD2 LEU B 134      22.815  77.924  17.262  1.00 25.75           C  
ATOM   2208  N   SER B 135      22.913  72.836  18.684  1.00 22.02           N  
ATOM   2209  CA  SER B 135      23.715  71.734  19.197  1.00 22.84           C  
ATOM   2210  C   SER B 135      24.265  70.799  18.104  1.00 23.86           C  
ATOM   2211  O   SER B 135      25.424  70.380  18.186  1.00 24.77           O  
ATOM   2212  CB  SER B 135      22.914  70.965  20.248  1.00 23.49           C  
ATOM   2213  OG  SER B 135      23.542  69.757  20.607  1.00 26.00           O  
ATOM   2214  N   THR B 136      23.455  70.481  17.092  1.00 23.80           N  
ATOM   2215  CA  THR B 136      23.920  69.676  15.948  1.00 24.78           C  
ATOM   2216  C   THR B 136      24.961  70.450  15.123  1.00 25.23           C  
ATOM   2217  O   THR B 136      25.924  69.868  14.621  1.00 24.75           O  
ATOM   2218  CB  THR B 136      22.741  69.195  15.045  1.00 24.29           C  
ATOM   2219  OG1 THR B 136      21.741  68.575  15.856  1.00 26.61           O  
ATOM   2220  CG2 THR B 136      23.196  68.167  14.040  1.00 24.37           C  
ATOM   2221  N   ARG B 137      24.761  71.763  15.009  1.00 26.30           N  
ATOM   2222  CA  ARG B 137      25.682  72.649  14.294  1.00 27.46           C  
ATOM   2223  C   ARG B 137      27.023  72.776  15.037  1.00 28.04           C  
ATOM   2224  O   ARG B 137      28.061  73.046  14.431  1.00 29.09           O  
ATOM   2225  CB  ARG B 137      25.029  74.020  14.043  1.00 27.04           C  
ATOM   2226  CG  ARG B 137      25.849  74.963  13.164  1.00 28.58           C  
ATOM   2227  CD  ARG B 137      24.988  75.693  12.140  1.00 34.49           C  
ATOM   2228  NE  ARG B 137      24.774  74.896  10.930  1.00 37.04           N  
ATOM   2229  CZ  ARG B 137      23.668  74.204  10.650  1.00 39.76           C  
ATOM   2230  NH1 ARG B 137      22.637  74.200  11.485  1.00 41.20           N  
ATOM   2231  NH2 ARG B 137      23.590  73.513   9.521  1.00 41.04           N  
ATOM   2232  N   LEU B 138      26.988  72.555  16.345  1.00 28.65           N  
ATOM   2233  CA  LEU B 138      28.177  72.627  17.185  1.00 29.31           C  
ATOM   2234  C   LEU B 138      28.526  71.245  17.735  1.00 29.42           C  
ATOM   2235  O   LEU B 138      28.848  71.093  18.919  1.00 29.73           O  
ATOM   2236  CB  LEU B 138      27.953  73.629  18.327  1.00 29.52           C  
ATOM   2237  CG  LEU B 138      28.221  75.134  18.160  1.00 30.55           C  
ATOM   2238  CD1 LEU B 138      28.118  75.652  16.721  1.00 29.26           C  
ATOM   2239  CD2 LEU B 138      27.279  75.895  19.087  1.00 32.71           C  
ATOM   2240  N   HIS B 139      28.428  70.244  16.861  1.00 29.09           N  
ATOM   2241  CA  HIS B 139      28.836  68.872  17.160  1.00 28.69           C  
ATOM   2242  C   HIS B 139      29.509  68.312  15.917  1.00 28.36           C  
ATOM   2243  O   HIS B 139      30.206  67.297  15.978  1.00 28.05           O  
ATOM   2244  CB  HIS B 139      27.647  68.012  17.568  1.00 28.70           C  
ATOM   2245  N   GLN B 140      29.290  68.987  14.786  1.00 27.79           N  
ATOM   2246  CA  GLN B 140      30.165  68.843  13.625  1.00 27.10           C  
ATOM   2247  C   GLN B 140      31.495  69.488  13.996  1.00 26.49           C  
ATOM   2248  O   GLN B 140      32.448  69.476  13.216  1.00 26.61           O  
ATOM   2249  CB  GLN B 140      29.563  69.512  12.396  1.00 27.29           C  
ATOM   2250  N   ARG B 141      31.528  70.056  15.201  1.00 25.72           N  
ATOM   2251  CA  ARG B 141      32.750  70.545  15.828  1.00 25.18           C  
ATOM   2252  C   ARG B 141      33.264  69.562  16.905  1.00 24.77           C  
ATOM   2253  O   ARG B 141      33.746  69.974  17.964  1.00 24.08           O  
ATOM   2254  CB  ARG B 141      32.525  71.948  16.401  1.00 25.01           C  
ATOM   2255  N   ILE B 142      33.170  68.262  16.607  1.00 24.75           N  
ATOM   2256  CA  ILE B 142      33.613  67.203  17.524  1.00 24.76           C  
ATOM   2257  C   ILE B 142      34.870  66.451  17.046  1.00 24.74           C  
ATOM   2258  O   ILE B 142      35.027  65.248  17.291  1.00 24.51           O  
ATOM   2259  CB  ILE B 142      32.471  66.228  17.808  1.00 24.73           C  
ATOM   2260  N   ASP B 143      35.753  67.168  16.357  1.00 24.77           N  
ATOM   2261  CA  ASP B 143      37.090  66.671  16.044  1.00 24.94           C  
ATOM   2262  C   ASP B 143      38.076  67.429  16.921  1.00 24.81           C  
ATOM   2263  O   ASP B 143      38.957  66.834  17.548  1.00 24.73           O  
ATOM   2264  CB  ASP B 143      37.418  66.872  14.558  1.00 25.06           C  
ATOM   2265  N   GLU B 144      37.899  68.749  16.957  1.00 24.82           N  
ATOM   2266  CA  GLU B 144      38.639  69.626  17.847  1.00 24.78           C  
ATOM   2267  C   GLU B 144      37.718  70.097  18.968  1.00 24.72           C  
ATOM   2268  O   GLU B 144      37.494  71.302  19.141  1.00 24.69           O  
ATOM   2269  CB  GLU B 144      39.215  70.813  17.072  1.00 24.99           C  
ATOM   2270  N   ILE B 145      37.169  69.131  19.709  1.00 24.70           N  
ATOM   2271  CA  ILE B 145      36.362  69.401  20.903  1.00 24.31           C  
ATOM   2272  C   ILE B 145      37.278  69.872  22.037  1.00 23.87           C  
ATOM   2273  O   ILE B 145      38.111  69.108  22.526  1.00 24.19           O  
ATOM   2274  CB  ILE B 145      35.567  68.153  21.309  1.00 24.07           C  
ATOM   2275  N   GLU B 146      37.133  71.138  22.431  1.00 23.54           N  
ATOM   2276  CA  GLU B 146      38.069  71.787  23.364  1.00 22.95           C  
ATOM   2277  C   GLU B 146      37.630  71.736  24.836  1.00 22.51           C  
ATOM   2278  O   GLU B 146      38.465  71.891  25.748  1.00 21.42           O  
ATOM   2279  CB  GLU B 146      38.313  73.235  22.936  1.00 23.15           C  
ATOM   2280  N   THR B 147      36.323  71.537  25.055  1.00 21.38           N  
ATOM   2281  CA  THR B 147      35.725  71.555  26.395  1.00 21.00           C  
ATOM   2282  C   THR B 147      34.464  70.704  26.469  1.00 20.26           C  
ATOM   2283  O   THR B 147      33.763  70.534  25.473  1.00 20.49           O  
ATOM   2284  CB  THR B 147      35.311  72.980  26.832  1.00 20.99           C  
ATOM   2285  OG1 THR B 147      36.260  73.944  26.360  1.00 21.54           O  
ATOM   2286  CG2 THR B 147      35.238  73.058  28.335  1.00 21.67           C  
ATOM   2287  N   LEU B 148      34.168  70.180  27.654  1.00 19.51           N  
ATOM   2288  CA  LEU B 148      32.858  69.565  27.889  1.00 19.74           C  
ATOM   2289  C   LEU B 148      31.985  70.346  28.894  1.00 20.00           C  
ATOM   2290  O   LEU B 148      31.048  69.808  29.479  1.00 19.71           O  
ATOM   2291  CB  LEU B 148      32.989  68.088  28.259  1.00 18.88           C  
ATOM   2292  CG  LEU B 148      34.041  67.678  29.275  1.00 17.66           C  
ATOM   2293  CD1 LEU B 148      34.118  68.644  30.467  1.00 14.26           C  
ATOM   2294  CD2 LEU B 148      33.718  66.265  29.706  1.00 15.70           C  
ATOM   2295  N   SER B 149      32.301  71.624  29.059  1.00 20.98           N  
ATOM   2296  CA  SER B 149      31.521  72.529  29.871  1.00 22.51           C  
ATOM   2297  C   SER B 149      30.828  73.537  28.949  1.00 24.46           C  
ATOM   2298  O   SER B 149      31.084  73.562  27.735  1.00 24.56           O  
ATOM   2299  CB  SER B 149      32.424  73.236  30.872  1.00 22.57           C  
ATOM   2300  OG  SER B 149      31.697  73.695  31.995  1.00 23.33           O  
ATOM   2301  N   LEU B 150      29.939  74.347  29.524  1.00 25.95           N  
ATOM   2302  CA  LEU B 150      29.246  75.405  28.788  1.00 26.99           C  
ATOM   2303  C   LEU B 150      29.820  76.770  29.187  1.00 27.75           C  
ATOM   2304  O   LEU B 150      31.044  76.958  29.251  1.00 28.81           O  
ATOM   2305  CB  LEU B 150      27.725  75.349  29.035  1.00 26.58           C  
ATOM   2306  CG  LEU B 150      26.742  74.556  28.162  1.00 28.02           C  
ATOM   2307  CD1 LEU B 150      26.162  75.422  27.073  1.00 31.23           C  
ATOM   2308  CD2 LEU B 150      27.327  73.311  27.547  1.00 28.61           C  
TER    2309      LEU B 150                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
