
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  218 ( 1742),  selected  218 , name 2gau_A
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2gau_A.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    10_A      M       1          4.134
LGA    G    11_A      H       2          2.184
LGA    H    12_A      T       3          2.308
LGA    L    13_A      A       4          2.164
LGA    L    14_A      L       5          0.265
LGA    R    15_A      I       6          3.258
LGA    D    16_A      N       7          4.094
LGA    V    17_A      H       8          5.149
LGA    W    18_A      I       9          4.853
LGA    S    19_A      R      10          3.168
LGA    L    20_A      K      11           #
LGA    -       -      F      12           -
LGA    -       -      I      13           -
LGA    -       -      F      14           -
LGA    L    21_A      L      15          3.502
LGA    N    22_A      T      16          3.434
LGA    E    23_A      D      17          4.766
LGA    E    24_A      E      18          4.797
LGA    E    25_A      D      19          3.286
LGA    R    26_A      A      20          2.735
LGA    E    27_A      G      21          3.204
LGA    L    28_A      T      22          2.945
LGA    L    29_A      L      23          2.819
LGA    D    30_A      S      24          3.075
LGA    K    31_A      A      25          2.611
LGA    E    32_A      F      26          3.121
LGA    I    33_A      F      27          2.109
LGA    Q    34_A      Q      28          1.642
LGA    P    35_A      L      29          1.651
LGA    F    36_A      K      30          1.086
LGA    P    37_A      K      31          2.451
LGA    C    38_A      V      32          0.905
LGA    K    39_A      R      33          0.460
LGA    K    40_A      K      34          0.662
LGA    A    41_A      K      35          0.495
LGA    S    42_A      E      36          0.324
LGA    T    43_A      T      37          1.196
LGA    V    44_A      L      38          1.816
LGA    F    45_A      L      39          1.691
LGA    S    46_A      K      40          1.930
LGA    E    47_A      T      41          2.385
LGA    G    48_A      G      42          2.793
LGA    D    49_A      E      43          2.773
LGA    I    50_A      I      44          2.381
LGA    P    51_A      C      45          3.087
LGA    N    52_A      R      46          2.693
LGA    N    53_A      I      47          2.636
LGA    L    54_A      N      48          1.955
LGA    F    55_A      Y      49          1.100
LGA    Y    56_A      F      50          0.945
LGA    L    57_A      V      51          0.447
LGA    Y    58_A      V      52          0.442
LGA    E    59_A      K      53          0.450
LGA    G    60_A      G      54          0.724
LGA    K    61_A      C      55          1.074
LGA    I    62_A      L      56          1.003
LGA    K    63_A      R      57          1.213
LGA    I    64_A      L      58          0.954
LGA    L    65_A      F      59          0.551
LGA    R    66_A      F      60          1.139
LGA    -       -      I      61           -
LGA    -       -      D      62           -
LGA    -       -      E      63           -
LGA    -       -      K      64           -
LGA    -       -      G      65           -
LGA    R    72_A      I      66          3.146
LGA    F    73_A      E      67          2.628
LGA    H    74_A      Q      68          1.899
LGA    I    75_A      T      69          1.012
LGA    S    76_A      T      70          1.125
LGA    R    77_A      Q      71          1.162
LGA    I    78_A      F      72          1.395
LGA    V    79_A      A      73          0.883
LGA    K    80_A      I      74          0.804
LGA    P    81_A      E      75          0.182
LGA    G    82_A      N      76          0.426
LGA    Q    83_A      W      77          0.538
LGA    F    84_A      W      78          1.316
LGA    F    85_A      L      79          1.163
LGA    G    86_A      S      80          1.450
LGA    M    87_A      D      81           #
LGA    R    88_A      Y      82          2.163
LGA    P    89_A      M      83          3.517
LGA    Y    90_A      A      84           #
LGA    F    91_A      F      85           #
LGA    A    92_A      Q      86          3.325
LGA    E    93_A      K      87          2.125
LGA    E    94_A      Q      88          4.600
LGA    -       -      Q      89           -
LGA    T    95_A      P      90          3.926
LGA    C    96_A      A      91          3.074
LGA    S    97_A      D      92          2.736
LGA    S    98_A      F      93          1.399
LGA    T    99_A      Y      94          0.933
LGA    A   100_A      I      95          1.065
LGA    I   101_A      Q      96          0.921
LGA    A   102_A      S      97          0.974
LGA    V   103_A      V      98          1.036
LGA    E   104_A      E      99          1.113
LGA    N   105_A      N     100          0.823
LGA    S   106_A      C     101          0.955
LGA    K   107_A      E     102          0.818
LGA    V   108_A      L     103          1.021
LGA    L   109_A      L     104          1.365
LGA    A   110_A      S     105          1.470
LGA    I   111_A      I     106          2.155
LGA    P   112_A      T     107          3.291
LGA    V   113_A      Y     108          3.059
LGA    E   114_A      T     109          3.288
LGA    A   115_A      E     110          2.998
LGA    I   116_A      Q     111          1.688
LGA    E   117_A      E     112          1.538
LGA    A   118_A      N     113          1.994
LGA    L   119_A      L     114          2.010
LGA    L   120_A      F     115          0.947
LGA    K   121_A      E     116          1.652
LGA    G   122_A      R     117          3.745
LGA    N   123_A      I     118          3.611
LGA    T   124_A      P     119          3.870
LGA    S   125_A      A     120          3.028
LGA    F   126_A      L     121          0.886
LGA    C   127_A      E     122          1.191
LGA    R   128_A      R     123          1.800
LGA    Y   129_A      Y     124          1.493
LGA    F   130_A      F     125          1.315
LGA    L   131_A      R     126          1.636
LGA    K   132_A      L     127          1.729
LGA    A   133_A      V     128          1.559
LGA    L   134_A      Y     129          1.524
LGA    A   135_A      Q     130          1.806
LGA    K   136_A      K     131          1.613
LGA    E   137_A      S     132          1.734
LGA    L   138_A      F     133          1.667
LGA    G   139_A      A     134          1.666
LGA    Y   140_A      A     135          1.784
LGA    A   141_A      A     136          1.689
LGA    E   142_A      Q     137          1.886
LGA    R   143_A      L     138          1.777
LGA    R   144_A      R     139          1.882
LGA    T   145_A      S     140          1.838
LGA    V   146_A      K     141          2.038
LGA    T   147_A      F     142          2.348
LGA    L   148_A      Q     143          2.371
LGA    T   149_A      H     144          2.509
LGA    Q   150_A      M     145          3.935
LGA    K   151_A      -       -           -
LGA    H   152_A      -       -           -
LGA    V   153_A      -       -           -
LGA    R   154_A      -       -           -
LGA    G   155_A      -       -           -
LGA    R   156_A      Y     146          1.620
LGA    L   157_A      -       -           -
LGA    A   158_A      -       -           -
LGA    E   159_A      -       -           -
LGA    T   160_A      -       -           -
LGA    L   161_A      -       -           -
LGA    L   162_A      -       -           -
LGA    I   163_A      -       -           -
LGA    L   164_A      -       -           -
LGA    K   165_A      -       -           -
LGA    E   166_A      -       -           -
LGA    N   167_A      -       -           -
LGA    F   168_A      -       -           -
LGA    G   169_A      -       -           -
LGA    F   170_A      -       -           -
LGA    E   171_A      -       -           -
LGA    N   172_A      -       -           -
LGA    D   173_A      -       -           -
LGA    G   174_A      -       -           -
LGA    A   175_A      -       -           -
LGA    T   176_A      -       -           -
LGA    L   177_A      -       -           -
LGA    S   178_A      -       -           -
LGA    I   179_A      -       -           -
LGA    Y   180_A      -       -           -
LGA    L   181_A      -       -           -
LGA    S   182_A      -       -           -
LGA    R   183_A      -       -           -
LGA    E   184_A      -       -           -
LGA    E   185_A      -       -           -
LGA    L   186_A      -       -           -
LGA    A   187_A      -       -           -
LGA    T   188_A      -       -           -
LGA    L   189_A      -       -           -
LGA    S   190_A      -       -           -
LGA    N   191_A      -       -           -
LGA    M   192_A      -       -           -
LGA    T   193_A      -       -           -
LGA    V   194_A      -       -           -
LGA    S   195_A      -       -           -
LGA    N   196_A      -       -           -
LGA    A   197_A      -       -           -
LGA    I   198_A      -       -           -
LGA    R   199_A      -       -           -
LGA    T   200_A      -       -           -
LGA    L   201_A      -       -           -
LGA    S   202_A      -       -           -
LGA    T   203_A      -       -           -
LGA    F   204_A      -       -           -
LGA    V   205_A      -       -           -
LGA    S   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    R   208_A      -       -           -
LGA    M   209_A      -       -           -
LGA    L   210_A      -       -           -
LGA    A   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    D   213_A      -       -           -
LGA    G   214_A      -       -           -
LGA    K   215_A      -       -           -
LGA    R   216_A      -       -           -
LGA    I   217_A      -       -           -
LGA    K   218_A      -       -           -
LGA    I   219_A      -       -           -
LGA    I   220_A      -       -           -
LGA    D   221_A      -       -           -
LGA    C   222_A      -       -           -
LGA    D   223_A      -       -           -
LGA    R   224_A      -       -           -
LGA    L   225_A      -       -           -
LGA    Q   226_A      -       -           -
LGA    K   227_A      -       -           -
LGA    T   228_A      -       -           -
LGA    A   229_A      -       -           -
LGA    R   230_A      -       -           -
LGA    S   231_A      -       -           -
LGA    G   232_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  218  146    5.0    133    2.29    17.29     71.882     5.573

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.993815 * X  +  -0.043845 * Y  +   0.102027 * Z  +  48.891354
  Y_new =   0.097802 * X  +   0.089586 * Y  +   0.991166 * Z  +  70.684723
  Z_new =  -0.052598 * X  +   0.995014 * Y  +  -0.084743 * Z  +  -9.139893 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.655759   -1.485833  [ DEG:    94.8680    -85.1320 ]
  Theta =   0.052622    3.088971  [ DEG:     3.0150    176.9850 ]
  Phi   =   3.043497   -0.098095  [ DEG:   174.3795     -5.6204 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gau_A                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gau_A.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  218  146   5.0  133   2.29   17.29  71.882
REMARK  ---------------------------------------------------------- 
MOLECULE 2gau_A
HEADER    TRANSCRIPTION                           09-MAR-06   2GAU              
TITLE     CRYSTAL STRUCTURE OF TRANSCRIPTIONAL REGULATOR, CRP/FNR               
TITLE    2 FAMILY FROM PORPHYROMONAS GINGIVALIS (APC80792),                     
TITLE    3 STRUCTURAL GENOMICS, MCSG                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR, CRP/FNR FAMILY;                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PORPHYROMONAS GINGIVALIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: W83;                                                         
SOURCE   5 GENE: PG0396;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    STRUCTURAL GENOMICS, TRANSCRIPTIONAL REGULATOR,                       
KEYWDS   2 PORPHYROMONAS GINGIVALIS, PSI, PROTEIN STRUCTURE INITIATIVE,         
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.J.ROTELLA,R.G.ZHANG,R.MULLIGAN,S.MOY,A.JOACHIMIAK,MIDWEST           
AUTHOR   2 CENTER FOR STRUCTURAL GENOMICS (MCSG)                                
REVDAT   1   11-APR-06 2GAU    0                                                
JRNL        AUTH   F.J.ROTELLA,R.G.ZHANG,R.MULLIGAN,S.MOY,A.JOACHIMIAK          
JRNL        TITL   THE 1.9-A CRYSTAL STRUCTURE OF TRANSCRIPTIONAL               
JRNL        TITL 2 REGULATOR, CRP/FNR FAMILY FROM PORPHYROMONAS                 
JRNL        TITL 3 GINGIVALIS                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2GAU A    1   232  UNP    Q7MAW7   Q7MAW7_PORGI     1    232             
SEQRES   1 A  232  MET TRP LYS THR ALA SER ASP LYS GLY LEU GLY HIS LEU          
SEQRES   2 A  232  LEU ARG ASP VAL TRP SER LEU LEU ASN GLU GLU GLU ARG          
SEQRES   3 A  232  GLU LEU LEU ASP LYS GLU ILE GLN PRO PHE PRO CYS LYS          
SEQRES   4 A  232  LYS ALA SER THR VAL PHE SER GLU GLY ASP ILE PRO ASN          
SEQRES   5 A  232  ASN LEU PHE TYR LEU TYR GLU GLY LYS ILE LYS ILE LEU          
SEQRES   6 A  232  ARG GLU GLY VAL TYR GLY ARG PHE HIS ILE SER ARG ILE          
SEQRES   7 A  232  VAL LYS PRO GLY GLN PHE PHE GLY MET ARG PRO TYR PHE          
SEQRES   8 A  232  ALA GLU GLU THR CYS SER SER THR ALA ILE ALA VAL GLU          
SEQRES   9 A  232  ASN SER LYS VAL LEU ALA ILE PRO VAL GLU ALA ILE GLU          
SEQRES  10 A  232  ALA LEU LEU LYS GLY ASN THR SER PHE CYS ARG TYR PHE          
SEQRES  11 A  232  LEU LYS ALA LEU ALA LYS GLU LEU GLY TYR ALA GLU ARG          
SEQRES  12 A  232  ARG THR VAL THR LEU THR GLN LYS HIS VAL ARG GLY ARG          
SEQRES  13 A  232  LEU ALA GLU THR LEU LEU ILE LEU LYS GLU ASN PHE GLY          
SEQRES  14 A  232  PHE GLU ASN ASP GLY ALA THR LEU SER ILE TYR LEU SER          
SEQRES  15 A  232  ARG GLU GLU LEU ALA THR LEU SER ASN MET THR VAL SER          
SEQRES  16 A  232  ASN ALA ILE ARG THR LEU SER THR PHE VAL SER GLU ARG          
SEQRES  17 A  232  MET LEU ALA LEU ASP GLY LYS ARG ILE LYS ILE ILE ASP          
SEQRES  18 A  232  CYS ASP ARG LEU GLN LYS THR ALA ARG SER GLY                  
FORMUL   2  HOH   *213(H2 O)                                                    
CRYST1   76.723   76.723   86.320  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   LEU A  10      -0.273  87.521   6.616  1.00 33.77           N  
ATOM      2  CA  LEU A  10       0.800  86.813   5.851  1.00 33.67           C  
ATOM      3  C   LEU A  10       1.546  85.753   6.676  1.00 33.36           C  
ATOM      4  O   LEU A  10       2.281  84.933   6.124  1.00 33.56           O  
ATOM      5  CB  LEU A  10       1.783  87.823   5.268  1.00 33.88           C  
ATOM      6  CG  LEU A  10       1.278  88.778   4.182  1.00 34.06           C  
ATOM      7  CD1 LEU A  10       2.406  89.711   3.809  1.00 33.51           C  
ATOM      8  CD2 LEU A  10       0.776  88.048   2.947  1.00 34.46           C  
ATOM      9  N   GLY A  11       1.337  85.762   7.990  1.00 32.66           N  
ATOM     10  CA  GLY A  11       2.003  84.833   8.894  1.00 31.62           C  
ATOM     11  C   GLY A  11       1.720  83.378   8.586  1.00 31.45           C  
ATOM     12  O   GLY A  11       2.590  82.522   8.769  1.00 31.01           O  
ATOM     13  N   HIS A  12       0.497  83.092   8.124  1.00 30.56           N  
ATOM     14  CA  HIS A  12       0.088  81.727   7.802  1.00 30.10           C  
ATOM     15  C   HIS A  12       0.898  81.109   6.654  1.00 29.78           C  
ATOM     16  O   HIS A  12       0.947  79.883   6.516  1.00 29.72           O  
ATOM     17  CB  HIS A  12      -1.411  81.668   7.482  1.00 30.25           C  
ATOM     18  CG  HIS A  12      -1.750  82.174   6.119  1.00 30.08           C  
ATOM     19  ND1 HIS A  12      -1.827  83.517   5.822  1.00 31.37           N  
ATOM     20  CD2 HIS A  12      -2.002  81.518   4.963  1.00 31.62           C  
ATOM     21  CE1 HIS A  12      -2.127  83.666   4.544  1.00 32.00           C  
ATOM     22  NE2 HIS A  12      -2.231  82.469   3.997  1.00 30.37           N  
ATOM     23  N   LEU A  13       1.530  81.946   5.835  1.00 29.55           N  
ATOM     24  CA  LEU A  13       2.361  81.444   4.729  1.00 29.41           C  
ATOM     25  C   LEU A  13       3.587  80.674   5.238  1.00 29.59           C  
ATOM     26  O   LEU A  13       4.132  79.815   4.531  1.00 28.91           O  
ATOM     27  CB  LEU A  13       2.772  82.574   3.777  1.00 29.26           C  
ATOM     28  CG  LEU A  13       1.644  83.316   3.034  1.00 29.28           C  
ATOM     29  CD1 LEU A  13       2.191  84.497   2.266  1.00 29.46           C  
ATOM     30  CD2 LEU A  13       0.865  82.392   2.099  1.00 27.78           C  
ATOM     31  N   LEU A  14       3.999  80.978   6.466  1.00 29.38           N  
ATOM     32  CA  LEU A  14       5.058  80.232   7.141  1.00 30.18           C  
ATOM     33  C   LEU A  14       4.445  78.970   7.743  1.00 30.63           C  
ATOM     34  O   LEU A  14       4.268  78.885   8.953  1.00 30.71           O  
ATOM     35  CB  LEU A  14       5.710  81.098   8.230  1.00 29.68           C  
ATOM     36  CG  LEU A  14       6.685  82.229   7.860  1.00 30.98           C  
ATOM     37  CD1 LEU A  14       6.077  83.306   6.960  1.00 31.79           C  
ATOM     38  CD2 LEU A  14       7.278  82.858   9.110  1.00 30.44           C  
ATOM     39  N   ARG A  15       4.142  77.991   6.886  1.00 31.11           N  
ATOM     40  CA  ARG A  15       3.309  76.824   7.240  1.00 32.17           C  
ATOM     41  C   ARG A  15       3.749  76.056   8.506  1.00 31.92           C  
ATOM     42  O   ARG A  15       2.936  75.823   9.405  1.00 31.69           O  
ATOM     43  CB  ARG A  15       3.197  75.869   6.042  1.00 32.75           C  
ATOM     44  CG  ARG A  15       2.139  74.757   6.188  1.00 35.95           C  
ATOM     45  CD  ARG A  15       2.519  73.503   5.395  1.00 40.27           C  
ATOM     46  NE  ARG A  15       3.886  73.062   5.711  1.00 44.08           N  
ATOM     47  CZ  ARG A  15       4.404  71.876   5.392  1.00 46.73           C  
ATOM     48  NH1 ARG A  15       3.686  70.970   4.739  1.00 47.84           N  
ATOM     49  NH2 ARG A  15       5.653  71.590   5.730  1.00 47.69           N  
ATOM     50  N   ASP A  16       5.024  75.666   8.568  1.00 31.82           N  
ATOM     51  CA  ASP A  16       5.527  74.859   9.690  1.00 32.30           C  
ATOM     52  C   ASP A  16       5.444  75.610  11.008  1.00 31.48           C  
ATOM     53  O   ASP A  16       4.919  75.090  11.996  1.00 32.19           O  
ATOM     54  CB  ASP A  16       6.972  74.405   9.446  1.00 32.62           C  
ATOM     55  CG  ASP A  16       7.099  73.468   8.271  1.00 35.18           C  
ATOM     56  OD1 ASP A  16       6.181  72.643   8.058  1.00 37.84           O  
ATOM     57  OD2 ASP A  16       8.134  73.548   7.567  1.00 38.74           O  
ATOM     58  N   VAL A  17       5.929  76.848  10.997  1.00 30.55           N  
ATOM     59  CA  VAL A  17       5.988  77.709  12.169  1.00 29.85           C  
ATOM     60  C   VAL A  17       4.595  78.140  12.684  1.00 29.80           C  
ATOM     61  O   VAL A  17       4.334  78.138  13.899  1.00 29.29           O  
ATOM     62  CB  VAL A  17       6.893  78.940  11.870  1.00 29.79           C  
ATOM     63  CG1 VAL A  17       6.626  80.064  12.822  1.00 30.60           C  
ATOM     64  CG2 VAL A  17       8.357  78.537  11.933  1.00 29.21           C  
ATOM     65  N   TRP A  18       3.719  78.518  11.756  1.00 29.49           N  
ATOM     66  CA  TRP A  18       2.370  78.972  12.078  1.00 29.84           C  
ATOM     67  C   TRP A  18       1.604  77.954  12.923  1.00 30.03           C  
ATOM     68  O   TRP A  18       0.863  78.335  13.830  1.00 29.99           O  
ATOM     69  CB  TRP A  18       1.616  79.256  10.783  1.00 30.48           C  
ATOM     70  CG  TRP A  18       0.309  79.976  10.929  1.00 31.28           C  
ATOM     71  CD1 TRP A  18      -0.935  79.456  10.727  1.00 32.26           C  
ATOM     72  CD2 TRP A  18       0.118  81.357  11.264  1.00 31.85           C  
ATOM     73  NE1 TRP A  18      -1.887  80.420  10.930  1.00 31.40           N  
ATOM     74  CE2 TRP A  18      -1.269  81.598  11.257  1.00 32.46           C  
ATOM     75  CE3 TRP A  18       0.984  82.409  11.579  1.00 32.94           C  
ATOM     76  CZ2 TRP A  18      -1.816  82.851  11.550  1.00 31.91           C  
ATOM     77  CZ3 TRP A  18       0.442  83.660  11.864  1.00 32.67           C  
ATOM     78  CH2 TRP A  18      -0.950  83.869  11.843  1.00 32.85           C  
ATOM     79  N   SER A  19       1.789  76.668  12.628  1.00 30.16           N  
ATOM     80  CA  SER A  19       1.133  75.592  13.375  1.00 30.66           C  
ATOM     81  C   SER A  19       1.590  75.469  14.840  1.00 31.00           C  
ATOM     82  O   SER A  19       0.905  74.849  15.657  1.00 30.59           O  
ATOM     83  CB  SER A  19       1.328  74.259  12.653  1.00 30.63           C  
ATOM     84  OG  SER A  19       2.656  73.779  12.807  1.00 31.99           O  
ATOM     85  N   LEU A  20       2.750  76.051  15.150  1.00 30.85           N  
ATOM     86  CA  LEU A  20       3.350  76.022  16.489  1.00 31.45           C  
ATOM     87  C   LEU A  20       2.880  77.173  17.381  1.00 31.51           C  
ATOM     88  O   LEU A  20       3.177  77.206  18.585  1.00 31.32           O  
ATOM     89  CB  LEU A  20       4.877  76.116  16.384  1.00 30.96           C  
ATOM     90  CG  LEU A  20       5.661  75.105  15.562  1.00 31.48           C  
ATOM     91  CD1 LEU A  20       7.133  75.494  15.554  1.00 30.82           C  
ATOM     92  CD2 LEU A  20       5.472  73.697  16.120  1.00 31.40           C  
ATOM     93  N   LEU A  21       2.181  78.121  16.777  1.00 31.84           N  
ATOM     94  CA  LEU A  21       1.834  79.361  17.454  1.00 32.68           C  
ATOM     95  C   LEU A  21       0.389  79.334  17.935  1.00 33.70           C  
ATOM     96  O   LEU A  21      -0.487  78.785  17.255  1.00 34.11           O  
ATOM     97  CB  LEU A  21       2.081  80.560  16.528  1.00 32.02           C  
ATOM     98  CG  LEU A  21       3.510  80.777  16.007  1.00 30.73           C  
ATOM     99  CD1 LEU A  21       3.574  82.019  15.129  1.00 28.66           C  
ATOM    100  CD2 LEU A  21       4.530  80.862  17.141  1.00 28.26           C  
ATOM    101  N   ASN A  22       0.152  79.900  19.116  1.00 34.85           N  
ATOM    102  CA  ASN A  22      -1.209  80.059  19.631  1.00 35.80           C  
ATOM    103  C   ASN A  22      -1.795  81.346  19.075  1.00 36.55           C  
ATOM    104  O   ASN A  22      -1.164  81.999  18.234  1.00 36.39           O  
ATOM    105  CB  ASN A  22      -1.256  80.019  21.173  1.00 36.11           C  
ATOM    106  CG  ASN A  22      -0.510  81.179  21.834  1.00 36.00           C  
ATOM    107  OD1 ASN A  22      -0.337  82.254  21.252  1.00 36.50           O  
ATOM    108  ND2 ASN A  22      -0.068  80.957  23.071  1.00 35.92           N  
ATOM    109  N   GLU A  23      -2.983  81.726  19.548  1.00 37.06           N  
ATOM    110  CA  GLU A  23      -3.707  82.845  18.947  1.00 37.74           C  
ATOM    111  C   GLU A  23      -3.014  84.184  19.136  1.00 37.15           C  
ATOM    112  O   GLU A  23      -2.939  84.978  18.208  1.00 37.52           O  
ATOM    113  CB  GLU A  23      -5.160  82.900  19.444  1.00 38.37           C  
ATOM    114  CG  GLU A  23      -6.147  83.307  18.355  1.00 41.46           C  
ATOM    115  CD  GLU A  23      -5.993  82.473  17.070  1.00 45.60           C  
ATOM    116  OE1 GLU A  23      -5.814  81.227  17.152  1.00 46.96           O  
ATOM    117  OE2 GLU A  23      -6.051  83.073  15.975  1.00 47.41           O  
ATOM    118  N   GLU A  24      -2.490  84.420  20.335  1.00 36.86           N  
ATOM    119  CA  GLU A  24      -1.787  85.656  20.647  1.00 36.85           C  
ATOM    120  C   GLU A  24      -0.481  85.784  19.847  1.00 35.82           C  
ATOM    121  O   GLU A  24      -0.122  86.874  19.387  1.00 35.56           O  
ATOM    122  CB  GLU A  24      -1.498  85.689  22.143  1.00 36.82           C  
ATOM    123  CG  GLU A  24      -0.978  87.010  22.686  1.00 39.01           C  
ATOM    124  CD  GLU A  24      -0.653  86.933  24.173  1.00 39.19           C  
ATOM    125  OE1 GLU A  24      -1.091  85.959  24.840  1.00 42.52           O  
ATOM    126  OE2 GLU A  24       0.048  87.841  24.673  1.00 42.54           O  
ATOM    127  N   GLU A  25       0.224  84.660  19.698  1.00 34.88           N  
ATOM    128  CA  GLU A  25       1.501  84.625  18.975  1.00 33.83           C  
ATOM    129  C   GLU A  25       1.293  84.833  17.475  1.00 33.76           C  
ATOM    130  O   GLU A  25       2.074  85.535  16.822  1.00 33.35           O  
ATOM    131  CB  GLU A  25       2.220  83.303  19.243  1.00 33.45           C  
ATOM    132  CG  GLU A  25       2.836  83.215  20.632  1.00 32.54           C  
ATOM    133  CD  GLU A  25       3.125  81.790  21.072  1.00 31.75           C  
ATOM    134  OE1 GLU A  25       2.598  80.840  20.461  1.00 30.83           O  
ATOM    135  OE2 GLU A  25       3.869  81.627  22.055  1.00 32.13           O  
ATOM    136  N   ARG A  26       0.232  84.223  16.949  1.00 33.75           N  
ATOM    137  CA  ARG A  26      -0.188  84.402  15.557  1.00 34.11           C  
ATOM    138  C   ARG A  26      -0.549  85.851  15.234  1.00 34.50           C  
ATOM    139  O   ARG A  26      -0.193  86.350  14.163  1.00 34.74           O  
ATOM    140  CB  ARG A  26      -1.356  83.470  15.216  1.00 34.01           C  
ATOM    141  CG  ARG A  26      -0.937  82.033  14.995  1.00 33.34           C  
ATOM    142  CD  ARG A  26      -2.122  81.119  14.741  1.00 34.62           C  
ATOM    143  NE  ARG A  26      -1.699  79.733  14.543  1.00 34.53           N  
ATOM    144  CZ  ARG A  26      -2.465  78.777  14.029  1.00 34.98           C  
ATOM    145  NH1 ARG A  26      -3.712  79.049  13.654  1.00 37.26           N  
ATOM    146  NH2 ARG A  26      -1.989  77.548  13.888  1.00 34.31           N  
ATOM    147  N   GLU A  27      -1.252  86.518  16.159  1.00 35.00           N  
ATOM    148  CA  GLU A  27      -1.572  87.951  16.044  1.00 35.18           C  
ATOM    149  C   GLU A  27      -0.317  88.805  15.955  1.00 34.22           C  
ATOM    150  O   GLU A  27      -0.239  89.735  15.142  1.00 33.76           O  
ATOM    151  CB  GLU A  27      -2.380  88.441  17.254  1.00 35.56           C  
ATOM    152  CG  GLU A  27      -3.767  87.846  17.407  1.00 37.23           C  
ATOM    153  CD  GLU A  27      -4.538  88.438  18.599  1.00 37.52           C  
ATOM    154  OE1 GLU A  27      -4.178  89.540  19.081  1.00 40.43           O  
ATOM    155  OE2 GLU A  27      -5.511  87.793  19.053  1.00 41.69           O  
ATOM    156  N   LEU A  28       0.647  88.507  16.827  1.00 33.29           N  
ATOM    157  CA  LEU A  28       1.909  89.234  16.863  1.00 32.39           C  
ATOM    158  C   LEU A  28       2.659  89.048  15.547  1.00 31.67           C  
ATOM    159  O   LEU A  28       3.116  90.025  14.949  1.00 31.26           O  
ATOM    160  CB  LEU A  28       2.770  88.776  18.047  1.00 32.26           C  
ATOM    161  CG  LEU A  28       4.222  89.266  18.150  1.00 33.22           C  
ATOM    162  CD1 LEU A  28       4.323  90.782  18.285  1.00 33.69           C  
ATOM    163  CD2 LEU A  28       4.921  88.579  19.318  1.00 32.48           C  
ATOM    164  N   LEU A  29       2.766  87.797  15.101  1.00 31.43           N  
ATOM    165  CA  LEU A  29       3.419  87.499  13.822  1.00 31.09           C  
ATOM    166  C   LEU A  29       2.733  88.237  12.676  1.00 31.50           C  
ATOM    167  O   LEU A  29       3.391  88.951  11.914  1.00 31.16           O  
ATOM    168  CB  LEU A  29       3.483  85.992  13.541  1.00 30.87           C  
ATOM    169  CG  LEU A  29       4.319  85.601  12.304  1.00 29.58           C  
ATOM    170  CD1 LEU A  29       5.779  86.094  12.417  1.00 27.85           C  
ATOM    171  CD2 LEU A  29       4.266  84.106  12.024  1.00 31.04           C  
ATOM    172  N   ASP A  30       1.413  88.087  12.565  1.00 31.77           N  
ATOM    173  CA  ASP A  30       0.660  88.789  11.518  1.00 32.28           C  
ATOM    174  C   ASP A  30       0.912  90.300  11.546  1.00 32.42           C  
ATOM    175  O   ASP A  30       1.042  90.930  10.495  1.00 32.33           O  
ATOM    176  CB  ASP A  30      -0.840  88.495  11.633  1.00 32.67           C  
ATOM    177  CG  ASP A  30      -1.265  87.250  10.868  1.00 33.15           C  
ATOM    178  OD1 ASP A  30      -0.512  86.749  10.007  1.00 35.03           O  
ATOM    179  OD2 ASP A  30      -2.390  86.771  11.113  1.00 34.79           O  
ATOM    180  N   LYS A  31       1.008  90.865  12.752  1.00 32.50           N  
ATOM    181  CA  LYS A  31       1.233  92.300  12.939  1.00 33.23           C  
ATOM    182  C   LYS A  31       2.629  92.761  12.510  1.00 32.51           C  
ATOM    183  O   LYS A  31       2.780  93.858  11.969  1.00 32.55           O  
ATOM    184  CB  LYS A  31       0.994  92.702  14.402  1.00 33.28           C  
ATOM    185  CG  LYS A  31       0.860  94.205  14.614  1.00 34.71           C  
ATOM    186  CD  LYS A  31       0.986  94.602  16.088  1.00 35.50           C  
ATOM    187  CE  LYS A  31       0.921  96.129  16.243  1.00 38.46           C  
ATOM    188  NZ  LYS A  31       1.428  96.629  17.582  1.00 40.65           N  
ATOM    189  N   GLU A  32       3.643  91.930  12.752  1.00 31.61           N  
ATOM    190  CA  GLU A  32       5.033  92.351  12.544  1.00 31.43           C  
ATOM    191  C   GLU A  32       5.654  91.937  11.208  1.00 30.41           C  
ATOM    192  O   GLU A  32       6.566  92.597  10.729  1.00 29.95           O  
ATOM    193  CB  GLU A  32       5.921  91.895  13.711  1.00 31.54           C  
ATOM    194  CG  GLU A  32       5.507  92.437  15.099  1.00 33.68           C  
ATOM    195  CD  GLU A  32       5.553  93.960  15.212  1.00 37.74           C  
ATOM    196  OE1 GLU A  32       6.373  94.610  14.522  1.00 39.04           O  
ATOM    197  OE2 GLU A  32       4.765  94.514  16.017  1.00 40.74           O  
ATOM    198  N   ILE A  33       5.153  90.858  10.610  1.00 30.15           N  
ATOM    199  CA  ILE A  33       5.690  90.352   9.341  1.00 29.93           C  
ATOM    200  C   ILE A  33       5.477  91.364   8.201  1.00 30.62           C  
ATOM    201  O   ILE A  33       4.418  92.004   8.132  1.00 30.05           O  
ATOM    202  CB  ILE A  33       5.093  88.963   8.994  1.00 29.85           C  
ATOM    203  CG1 ILE A  33       5.954  88.236   7.944  1.00 29.90           C  
ATOM    204  CG2 ILE A  33       3.622  89.075   8.552  1.00 29.39           C  
ATOM    205  CD1 ILE A  33       5.689  86.758   7.873  1.00 29.10           C  
ATOM    206  N   GLN A  34       6.487  91.509   7.336  1.00 30.93           N  
ATOM    207  CA  GLN A  34       6.461  92.430   6.189  1.00 31.97           C  
ATOM    208  C   GLN A  34       6.885  91.739   4.895  1.00 32.42           C  
ATOM    209  O   GLN A  34       7.896  91.021   4.885  1.00 31.93           O  
ATOM    210  CB  GLN A  34       7.437  93.602   6.391  1.00 32.02           C  
ATOM    211  CG  GLN A  34       7.180  94.510   7.580  1.00 34.13           C  
ATOM    212  CD  GLN A  34       5.946  95.389   7.402  1.00 37.84           C  
ATOM    213  OE1 GLN A  34       5.600  95.783   6.281  1.00 38.96           O  
ATOM    214  NE2 GLN A  34       5.279  95.705   8.513  1.00 37.84           N  
ATOM    215  N   PRO A  35       6.152  91.986   3.785  1.00 33.25           N  
ATOM    216  CA  PRO A  35       6.632  91.564   2.459  1.00 33.53           C  
ATOM    217  C   PRO A  35       7.958  92.259   2.145  1.00 34.05           C  
ATOM    218  O   PRO A  35       8.169  93.409   2.547  1.00 33.76           O  
ATOM    219  CB  PRO A  35       5.541  92.062   1.493  1.00 33.79           C  
ATOM    220  CG  PRO A  35       4.382  92.397   2.319  1.00 33.67           C  
ATOM    221  CD  PRO A  35       4.863  92.699   3.708  1.00 33.27           C  
ATOM    222  N   PHE A  36       8.857  91.564   1.455  1.00 34.62           N  
ATOM    223  CA  PHE A  36      10.185  92.116   1.178  1.00 35.15           C  
ATOM    224  C   PHE A  36      10.519  91.973  -0.307  1.00 35.79           C  
ATOM    225  O   PHE A  36      10.863  90.872  -0.755  1.00 35.68           O  
ATOM    226  CB  PHE A  36      11.244  91.429   2.050  1.00 34.76           C  
ATOM    227  CG  PHE A  36      12.589  92.119   2.044  1.00 35.37           C  
ATOM    228  CD1 PHE A  36      12.922  93.030   3.047  1.00 36.14           C  
ATOM    229  CD2 PHE A  36      13.529  91.851   1.047  1.00 35.92           C  
ATOM    230  CE1 PHE A  36      14.170  93.674   3.056  1.00 36.35           C  
ATOM    231  CE2 PHE A  36      14.778  92.492   1.045  1.00 35.84           C  
ATOM    232  CZ  PHE A  36      15.099  93.400   2.053  1.00 35.79           C  
ATOM    233  N   PRO A  37      10.437  93.087  -1.077  1.00 36.27           N  
ATOM    234  CA  PRO A  37      10.569  93.003  -2.544  1.00 36.06           C  
ATOM    235  C   PRO A  37      11.885  92.360  -2.922  1.00 35.27           C  
ATOM    236  O   PRO A  37      12.932  92.736  -2.372  1.00 35.72           O  
ATOM    237  CB  PRO A  37      10.543  94.477  -3.002  1.00 36.37           C  
ATOM    238  CG  PRO A  37      10.781  95.287  -1.787  1.00 36.36           C  
ATOM    239  CD  PRO A  37      10.264  94.483  -0.623  1.00 36.67           C  
ATOM    240  N   CYS A  38      11.854  91.386  -3.826  1.00 34.82           N  
ATOM    241  CA  CYS A  38      13.081  90.651  -4.120  1.00 33.10           C  
ATOM    242  C   CYS A  38      13.303  90.231  -5.590  1.00 31.57           C  
ATOM    243  O   CYS A  38      13.203  89.048  -5.928  1.00 30.65           O  
ATOM    244  CB  CYS A  38      13.168  89.456  -3.177  1.00 33.46           C  
ATOM    245  SG  CYS A  38      14.827  88.955  -2.850  1.00 37.70           S  
ATOM    246  N   LYS A  39      13.639  91.206  -6.437  1.00 29.65           N  
ATOM    247  CA  LYS A  39      13.901  90.969  -7.862  1.00 29.14           C  
ATOM    248  C   LYS A  39      15.198  90.172  -8.045  1.00 27.75           C  
ATOM    249  O   LYS A  39      16.129  90.327  -7.253  1.00 26.80           O  
ATOM    250  CB  LYS A  39      14.019  92.311  -8.600  1.00 29.36           C  
ATOM    251  CG  LYS A  39      14.089  92.207 -10.122  1.00 30.16           C  
ATOM    252  CD  LYS A  39      14.362  93.581 -10.765  1.00 30.76           C  
ATOM    253  CE  LYS A  39      13.877  93.657 -12.230  1.00 32.79           C  
ATOM    254  NZ  LYS A  39      14.008  92.391 -13.037  1.00 30.98           N  
ATOM    255  N   LYS A  40      15.252  89.331  -9.076  1.00 26.74           N  
ATOM    256  CA  LYS A  40      16.491  88.651  -9.454  1.00 26.25           C  
ATOM    257  C   LYS A  40      17.656  89.637  -9.418  1.00 25.36           C  
ATOM    258  O   LYS A  40      17.537  90.773  -9.902  1.00 24.34           O  
ATOM    259  CB  LYS A  40      16.376  88.038 -10.854  1.00 26.33           C  
ATOM    260  CG  LYS A  40      17.611  87.260 -11.281  1.00 26.96           C  
ATOM    261  CD  LYS A  40      17.474  86.653 -12.669  1.00 28.62           C  
ATOM    262  CE  LYS A  40      18.766  85.926 -13.038  1.00 31.83           C  
ATOM    263  NZ  LYS A  40      18.747  85.370 -14.407  1.00 35.05           N  
ATOM    264  N   ALA A  41      18.760  89.200  -8.814  1.00 24.63           N  
ATOM    265  CA  ALA A  41      19.993  89.970  -8.691  1.00 24.17           C  
ATOM    266  C   ALA A  41      19.999  91.040  -7.597  1.00 23.98           C  
ATOM    267  O   ALA A  41      21.040  91.646  -7.363  1.00 23.57           O  
ATOM    268  CB  ALA A  41      20.432  90.579 -10.066  1.00 24.17           C  
ATOM    269  N   SER A  42      18.868  91.276  -6.928  1.00 23.81           N  
ATOM    270  CA  SER A  42      18.839  92.235  -5.810  1.00 24.07           C  
ATOM    271  C   SER A  42      19.422  91.596  -4.546  1.00 24.24           C  
ATOM    272  O   SER A  42      19.504  90.371  -4.467  1.00 23.74           O  
ATOM    273  CB  SER A  42      17.420  92.746  -5.538  1.00 24.47           C  
ATOM    274  OG  SER A  42      16.584  91.704  -5.041  1.00 25.29           O  
ATOM    275  N   THR A  43      19.815  92.410  -3.569  1.00 24.07           N  
ATOM    276  CA  THR A  43      20.387  91.843  -2.330  1.00 24.69           C  
ATOM    277  C   THR A  43      19.499  92.069  -1.135  1.00 23.90           C  
ATOM    278  O   THR A  43      18.997  93.171  -0.895  1.00 24.23           O  
ATOM    279  CB  THR A  43      21.908  92.199  -2.045  1.00 25.55           C  
ATOM    280  OG1 THR A  43      22.077  92.858  -0.778  1.00 29.21           O  
ATOM    281  CG2 THR A  43      22.540  92.975  -3.146  1.00 23.93           C  
ATOM    282  N   VAL A  44      19.288  90.988  -0.402  1.00 22.51           N  
ATOM    283  CA  VAL A  44      18.435  90.992   0.767  1.00 21.66           C  
ATOM    284  C   VAL A  44      19.178  91.618   1.948  1.00 21.41           C  
ATOM    285  O   VAL A  44      18.617  92.448   2.680  1.00 22.02           O  
ATOM    286  CB  VAL A  44      17.962  89.560   1.073  1.00 21.06           C  
ATOM    287  CG1 VAL A  44      16.932  89.538   2.208  1.00 20.80           C  
ATOM    288  CG2 VAL A  44      17.361  88.936  -0.200  1.00 21.98           C  
ATOM    289  N   PHE A  45      20.435  91.217   2.109  1.00 20.64           N  
ATOM    290  CA  PHE A  45      21.345  91.794   3.096  1.00 20.48           C  
ATOM    291  C   PHE A  45      22.762  91.559   2.626  1.00 20.38           C  
ATOM    292  O   PHE A  45      22.982  90.765   1.710  1.00 20.49           O  
ATOM    293  CB  PHE A  45      21.109  91.217   4.503  1.00 19.30           C  
ATOM    294  CG  PHE A  45      21.254  89.710   4.608  1.00 20.03           C  
ATOM    295  CD1 PHE A  45      22.510  89.103   4.595  1.00 17.96           C  
ATOM    296  CD2 PHE A  45      20.132  88.905   4.780  1.00 18.92           C  
ATOM    297  CE1 PHE A  45      22.633  87.710   4.717  1.00 20.18           C  
ATOM    298  CE2 PHE A  45      20.251  87.515   4.913  1.00 17.54           C  
ATOM    299  CZ  PHE A  45      21.506  86.920   4.896  1.00 17.74           C  
ATOM    300  N   SER A  46      23.715  92.250   3.247  1.00 21.10           N  
ATOM    301  CA  SER A  46      25.105  92.184   2.841  1.00 21.82           C  
ATOM    302  C   SER A  46      25.983  91.743   3.986  1.00 22.41           C  
ATOM    303  O   SER A  46      25.717  92.074   5.144  1.00 21.55           O  
ATOM    304  CB  SER A  46      25.592  93.550   2.347  1.00 22.24           C  
ATOM    305  OG  SER A  46      24.878  93.952   1.198  1.00 23.77           O  
ATOM    306  N   GLU A  47      27.035  91.012   3.634  1.00 22.62           N  
ATOM    307  CA  GLU A  47      28.119  90.671   4.555  1.00 24.44           C  
ATOM    308  C   GLU A  47      28.522  91.906   5.384  1.00 24.28           C  
ATOM    309  O   GLU A  47      28.756  92.984   4.825  1.00 24.60           O  
ATOM    310  CB  GLU A  47      29.303  90.122   3.740  1.00 23.72           C  
ATOM    311  CG  GLU A  47      30.460  89.573   4.555  1.00 25.97           C  
ATOM    312  CD  GLU A  47      31.550  88.940   3.703  1.00 26.52           C  
ATOM    313  OE1 GLU A  47      31.351  88.719   2.473  1.00 28.29           O  
ATOM    314  OE2 GLU A  47      32.620  88.658   4.276  1.00 29.62           O  
ATOM    315  N   GLY A  48      28.568  91.756   6.709  1.00 23.97           N  
ATOM    316  CA  GLY A  48      28.889  92.872   7.600  1.00 23.75           C  
ATOM    317  C   GLY A  48      27.673  93.580   8.183  1.00 23.58           C  
ATOM    318  O   GLY A  48      27.796  94.331   9.151  1.00 23.65           O  
ATOM    319  N   ASP A  49      26.498  93.339   7.601  1.00 22.94           N  
ATOM    320  CA  ASP A  49      25.263  93.956   8.070  1.00 22.98           C  
ATOM    321  C   ASP A  49      24.893  93.469   9.459  1.00 23.32           C  
ATOM    322  O   ASP A  49      25.088  92.304   9.806  1.00 22.93           O  
ATOM    323  CB  ASP A  49      24.085  93.639   7.137  1.00 23.03           C  
ATOM    324  CG  ASP A  49      24.061  94.504   5.878  1.00 23.14           C  
ATOM    325  OD1 ASP A  49      25.004  95.290   5.648  1.00 23.40           O  
ATOM    326  OD2 ASP A  49      23.092  94.364   5.105  1.00 22.02           O  
ATOM    327  N   ILE A  50      24.306  94.368  10.230  1.00 23.79           N  
ATOM    328  CA  ILE A  50      23.750  94.034  11.538  1.00 24.09           C  
ATOM    329  C   ILE A  50      22.319  93.531  11.338  1.00 24.12           C  
ATOM    330  O   ILE A  50      21.501  94.231  10.721  1.00 24.50           O  
ATOM    331  CB  ILE A  50      23.743  95.292  12.426  1.00 24.53           C  
ATOM    332  CG1 ILE A  50      25.164  95.869  12.556  1.00 26.11           C  
ATOM    333  CG2 ILE A  50      23.125  95.000  13.780  1.00 24.98           C  
ATOM    334  CD1 ILE A  50      26.067  95.099  13.506  1.00 28.77           C  
ATOM    335  N   PRO A  51      22.009  92.300  11.817  1.00 23.24           N  
ATOM    336  CA  PRO A  51      20.659  91.744  11.641  1.00 22.77           C  
ATOM    337  C   PRO A  51      19.528  92.596  12.238  1.00 22.59           C  
ATOM    338  O   PRO A  51      19.557  92.915  13.431  1.00 21.69           O  
ATOM    339  CB  PRO A  51      20.735  90.390  12.363  1.00 22.77           C  
ATOM    340  CG  PRO A  51      22.201  90.009  12.273  1.00 23.27           C  
ATOM    341  CD  PRO A  51      22.920  91.337  12.471  1.00 23.20           C  
ATOM    342  N   ASN A  52      18.561  92.950  11.394  1.00 21.96           N  
ATOM    343  CA  ASN A  52      17.347  93.646  11.810  1.00 22.71           C  
ATOM    344  C   ASN A  52      16.111  92.777  11.630  1.00 21.94           C  
ATOM    345  O   ASN A  52      15.081  93.002  12.278  1.00 22.07           O  
ATOM    346  CB  ASN A  52      17.149  94.931  10.996  1.00 23.14           C  
ATOM    347  CG  ASN A  52      18.085  96.052  11.416  1.00 25.42           C  
ATOM    348  OD1 ASN A  52      18.582  96.810  10.574  1.00 29.26           O  
ATOM    349  ND2 ASN A  52      18.316  96.179  12.713  1.00 25.32           N  
ATOM    350  N   ASN A  53      16.219  91.797  10.736  1.00 21.10           N  
ATOM    351  CA  ASN A  53      15.125  90.874  10.436  1.00 20.96           C  
ATOM    352  C   ASN A  53      15.617  89.451  10.234  1.00 20.30           C  
ATOM    353  O   ASN A  53      16.754  89.250   9.822  1.00 20.46           O  
ATOM    354  CB  ASN A  53      14.439  91.278   9.122  1.00 20.63           C  
ATOM    355  CG  ASN A  53      13.818  92.659   9.180  1.00 20.74           C  
ATOM    356  OD1 ASN A  53      12.797  92.859   9.830  1.00 19.94           O  
ATOM    357  ND2 ASN A  53      14.422  93.607   8.489  1.00 21.64           N  
ATOM    358  N   LEU A  54      14.740  88.478  10.499  1.00 19.92           N  
ATOM    359  CA  LEU A  54      14.867  87.137   9.905  1.00 20.58           C  
ATOM    360  C   LEU A  54      14.086  87.136   8.600  1.00 20.27           C  
ATOM    361  O   LEU A  54      13.091  87.870   8.449  1.00 20.30           O  
ATOM    362  CB  LEU A  54      14.356  86.031  10.854  1.00 20.51           C  
ATOM    363  CG  LEU A  54      15.387  85.304  11.745  1.00 22.31           C  
ATOM    364  CD1 LEU A  54      16.153  86.284  12.615  1.00 22.42           C  
ATOM    365  CD2 LEU A  54      14.736  84.264  12.621  1.00 20.82           C  
ATOM    366  N   PHE A  55      14.530  86.321   7.649  1.00 20.00           N  
ATOM    367  CA  PHE A  55      13.869  86.254   6.364  1.00 19.52           C  
ATOM    368  C   PHE A  55      13.394  84.844   6.065  1.00 19.61           C  
ATOM    369  O   PHE A  55      14.090  83.863   6.332  1.00 18.84           O  
ATOM    370  CB  PHE A  55      14.795  86.744   5.250  1.00 19.43           C  
ATOM    371  CG  PHE A  55      15.307  88.141   5.452  1.00 20.33           C  
ATOM    372  CD1 PHE A  55      14.593  89.237   4.950  1.00 19.67           C  
ATOM    373  CD2 PHE A  55      16.506  88.367   6.134  1.00 20.08           C  
ATOM    374  CE1 PHE A  55      15.063  90.545   5.128  1.00 20.93           C  
ATOM    375  CE2 PHE A  55      16.994  89.667   6.312  1.00 20.40           C  
ATOM    376  CZ  PHE A  55      16.271  90.759   5.802  1.00 20.74           C  
ATOM    377  N   TYR A  56      12.190  84.759   5.514  1.00 19.30           N  
ATOM    378  CA  TYR A  56      11.601  83.495   5.133  1.00 19.22           C  
ATOM    379  C   TYR A  56      11.411  83.508   3.614  1.00 18.79           C  
ATOM    380  O   TYR A  56      10.780  84.419   3.065  1.00 18.18           O  
ATOM    381  CB  TYR A  56      10.254  83.306   5.851  1.00 19.06           C  
ATOM    382  CG  TYR A  56       9.551  81.996   5.523  1.00 19.98           C  
ATOM    383  CD1 TYR A  56       9.943  80.800   6.139  1.00 19.44           C  
ATOM    384  CD2 TYR A  56       8.507  81.951   4.580  1.00 20.66           C  
ATOM    385  CE1 TYR A  56       9.306  79.585   5.829  1.00 19.65           C  
ATOM    386  CE2 TYR A  56       7.856  80.738   4.266  1.00 19.61           C  
ATOM    387  CZ  TYR A  56       8.256  79.572   4.906  1.00 18.68           C  
ATOM    388  OH  TYR A  56       7.635  78.378   4.627  1.00 20.21           O  
ATOM    389  N   LEU A  57      11.950  82.495   2.944  1.00 18.62           N  
ATOM    390  CA  LEU A  57      11.811  82.389   1.497  1.00 18.73           C  
ATOM    391  C   LEU A  57      10.494  81.700   1.132  1.00 18.93           C  
ATOM    392  O   LEU A  57      10.370  80.469   1.200  1.00 18.39           O  
ATOM    393  CB  LEU A  57      13.010  81.654   0.877  1.00 18.71           C  
ATOM    394  CG  LEU A  57      12.994  81.585  -0.652  1.00 18.37           C  
ATOM    395  CD1 LEU A  57      12.956  83.004  -1.266  1.00 18.18           C  
ATOM    396  CD2 LEU A  57      14.208  80.811  -1.141  1.00 18.38           C  
ATOM    397  N   TYR A  58       9.503  82.502   0.767  1.00 20.30           N  
ATOM    398  CA  TYR A  58       8.196  81.943   0.419  1.00 21.75           C  
ATOM    399  C   TYR A  58       8.242  81.292  -0.975  1.00 22.10           C  
ATOM    400  O   TYR A  58       7.840  80.133  -1.154  1.00 21.88           O  
ATOM    401  CB  TYR A  58       7.098  83.018   0.515  1.00 23.18           C  
ATOM    402  CG  TYR A  58       5.742  82.509   0.081  1.00 24.22           C  
ATOM    403  CD1 TYR A  58       5.109  81.472   0.771  1.00 26.68           C  
ATOM    404  CD2 TYR A  58       5.103  83.051  -1.024  1.00 26.92           C  
ATOM    405  CE1 TYR A  58       3.844  80.979   0.355  1.00 27.42           C  
ATOM    406  CE2 TYR A  58       3.845  82.574  -1.446  1.00 26.95           C  
ATOM    407  CZ  TYR A  58       3.227  81.545  -0.751  1.00 27.20           C  
ATOM    408  OH  TYR A  58       1.984  81.087  -1.176  1.00 28.54           O  
ATOM    409  N   GLU A  59       8.740  82.042  -1.953  1.00 22.20           N  
ATOM    410  CA  GLU A  59       8.877  81.554  -3.326  1.00 23.17           C  
ATOM    411  C   GLU A  59      10.186  82.053  -3.890  1.00 21.66           C  
ATOM    412  O   GLU A  59      10.608  83.153  -3.565  1.00 21.37           O  
ATOM    413  CB  GLU A  59       7.752  82.097  -4.219  1.00 23.50           C  
ATOM    414  CG  GLU A  59       6.523  81.235  -4.249  1.00 26.32           C  
ATOM    415  CD  GLU A  59       5.493  81.694  -5.281  1.00 26.45           C  
ATOM    416  OE1 GLU A  59       5.844  82.469  -6.215  1.00 31.35           O  
ATOM    417  OE2 GLU A  59       4.332  81.257  -5.138  1.00 32.22           O  
ATOM    418  N   GLY A  60      10.830  81.249  -4.728  1.00 20.69           N  
ATOM    419  CA  GLY A  60      12.025  81.736  -5.431  1.00 20.30           C  
ATOM    420  C   GLY A  60      13.278  81.056  -4.938  1.00 19.47           C  
ATOM    421  O   GLY A  60      13.214  79.938  -4.446  1.00 19.43           O  
ATOM    422  N   LYS A  61      14.425  81.719  -5.104  1.00 19.21           N  
ATOM    423  CA  LYS A  61      15.738  81.125  -4.813  1.00 19.04           C  
ATOM    424  C   LYS A  61      16.717  82.228  -4.423  1.00 18.92           C  
ATOM    425  O   LYS A  61      16.792  83.261  -5.100  1.00 17.78           O  
ATOM    426  CB  LYS A  61      16.295  80.359  -6.029  1.00 19.59           C  
ATOM    427  CG  LYS A  61      15.302  79.437  -6.778  1.00 19.61           C  
ATOM    428  CD  LYS A  61      16.029  78.503  -7.755  1.00 20.75           C  
ATOM    429  CE  LYS A  61      15.132  77.854  -8.788  1.00 22.37           C  
ATOM    430  NZ  LYS A  61      13.692  77.736  -8.464  1.00 23.57           N  
ATOM    431  N   ILE A  62      17.472  82.012  -3.335  1.00 18.25           N  
ATOM    432  CA  ILE A  62      18.418  83.026  -2.817  1.00 18.46           C  
ATOM    433  C   ILE A  62      19.793  82.373  -2.685  1.00 18.64           C  
ATOM    434  O   ILE A  62      19.914  81.317  -2.064  1.00 18.57           O  
ATOM    435  CB  ILE A  62      18.000  83.555  -1.420  1.00 17.65           C  
ATOM    436  CG1 ILE A  62      16.546  84.094  -1.409  1.00 17.23           C  
ATOM    437  CG2 ILE A  62      19.007  84.582  -0.876  1.00 16.94           C  
ATOM    438  CD1 ILE A  62      16.336  85.413  -2.162  1.00 18.30           C  
ATOM    439  N   LYS A  63      20.822  82.981  -3.266  1.00 18.86           N  
ATOM    440  CA  LYS A  63      22.179  82.462  -3.056  1.00 20.28           C  
ATOM    441  C   LYS A  63      22.823  83.193  -1.887  1.00 19.19           C  
ATOM    442  O   LYS A  63      22.691  84.421  -1.763  1.00 18.95           O  
ATOM    443  CB  LYS A  63      23.048  82.571  -4.320  1.00 20.35           C  
ATOM    444  CG  LYS A  63      23.101  83.953  -4.935  1.00 22.24           C  
ATOM    445  CD  LYS A  63      23.645  83.914  -6.371  1.00 23.21           C  
ATOM    446  CE  LYS A  63      24.950  84.668  -6.518  1.00 26.47           C  
ATOM    447  NZ  LYS A  63      25.355  84.802  -7.971  1.00 24.89           N  
ATOM    448  N   ILE A  64      23.513  82.449  -1.034  1.00 18.59           N  
ATOM    449  CA  ILE A  64      24.243  83.045   0.096  1.00 18.61           C  
ATOM    450  C   ILE A  64      25.725  82.975  -0.235  1.00 19.77           C  
ATOM    451  O   ILE A  64      26.259  81.884  -0.474  1.00 19.19           O  
ATOM    452  CB  ILE A  64      23.930  82.303   1.444  1.00 18.77           C  
ATOM    453  CG1 ILE A  64      22.415  82.222   1.692  1.00 18.04           C  
ATOM    454  CG2 ILE A  64      24.683  82.927   2.614  1.00 17.95           C  
ATOM    455  CD1 ILE A  64      21.733  83.542   1.916  1.00 19.19           C  
ATOM    456  N   LEU A  65      26.384  84.133  -0.257  1.00 20.85           N  
ATOM    457  CA  LEU A  65      27.760  84.196  -0.712  1.00 22.89           C  
ATOM    458  C   LEU A  65      28.636  85.102   0.139  1.00 22.51           C  
ATOM    459  O   LEU A  65      28.147  86.030   0.790  1.00 21.93           O  
ATOM    460  CB  LEU A  65      27.821  84.624  -2.185  1.00 23.07           C  
ATOM    461  CG  LEU A  65      27.381  86.012  -2.644  1.00 25.23           C  
ATOM    462  CD1 LEU A  65      28.373  87.072  -2.250  1.00 29.78           C  
ATOM    463  CD2 LEU A  65      27.299  85.967  -4.161  1.00 26.15           C  
ATOM    464  N   ARG A  66      29.941  84.865   0.086  1.00 22.54           N  
ATOM    465  CA  ARG A  66      30.868  85.678   0.861  1.00 24.11           C  
ATOM    466  C   ARG A  66      32.201  85.858   0.133  1.00 23.71           C  
ATOM    467  O   ARG A  66      32.542  85.047  -0.733  1.00 24.22           O  
ATOM    468  CB  ARG A  66      31.095  85.050   2.236  1.00 24.52           C  
ATOM    469  CG  ARG A  66      32.095  83.888   2.231  1.00 27.29           C  
ATOM    470  CD  ARG A  66      32.386  83.424   3.640  1.00 32.11           C  
ATOM    471  NE  ARG A  66      31.215  82.822   4.261  1.00 33.72           N  
ATOM    472  CZ  ARG A  66      31.065  82.654   5.575  1.00 35.69           C  
ATOM    473  NH1 ARG A  66      32.005  83.048   6.424  1.00 35.23           N  
ATOM    474  NH2 ARG A  66      29.947  82.110   6.041  1.00 36.84           N  
ATOM    475  N   ARG A  72      38.208  85.483  -4.957  1.00 39.54           N  
ATOM    476  CA  ARG A  72      37.242  84.413  -5.192  1.00 39.34           C  
ATOM    477  C   ARG A  72      36.059  84.641  -4.270  1.00 38.17           C  
ATOM    478  O   ARG A  72      36.228  85.117  -3.146  1.00 38.75           O  
ATOM    479  CB  ARG A  72      37.862  83.047  -4.884  1.00 39.59           C  
ATOM    480  CG  ARG A  72      38.958  82.583  -5.851  1.00 40.84           C  
ATOM    481  CD  ARG A  72      39.487  81.190  -5.457  1.00 40.33           C  
ATOM    482  NE  ARG A  72      38.423  80.182  -5.460  1.00 42.50           N  
ATOM    483  CZ  ARG A  72      38.581  78.894  -5.158  1.00 43.71           C  
ATOM    484  NH1 ARG A  72      39.771  78.420  -4.810  1.00 44.21           N  
ATOM    485  NH2 ARG A  72      37.536  78.073  -5.197  1.00 43.60           N  
ATOM    486  N   PHE A  73      34.860  84.332  -4.743  1.00 36.73           N  
ATOM    487  CA  PHE A  73      33.696  84.306  -3.853  1.00 35.37           C  
ATOM    488  C   PHE A  73      33.403  82.848  -3.499  1.00 33.90           C  
ATOM    489  O   PHE A  73      33.892  81.930  -4.161  1.00 34.05           O  
ATOM    490  CB  PHE A  73      32.474  85.008  -4.471  1.00 35.76           C  
ATOM    491  CG  PHE A  73      32.475  86.517  -4.293  1.00 36.04           C  
ATOM    492  CD1 PHE A  73      31.891  87.103  -3.173  1.00 37.67           C  
ATOM    493  CD2 PHE A  73      33.055  87.345  -5.247  1.00 37.99           C  
ATOM    494  CE1 PHE A  73      31.880  88.493  -3.003  1.00 37.55           C  
ATOM    495  CE2 PHE A  73      33.059  88.732  -5.088  1.00 37.42           C  
ATOM    496  CZ  PHE A  73      32.470  89.307  -3.967  1.00 37.16           C  
ATOM    497  N   HIS A  74      32.663  82.644  -2.417  1.00 31.52           N  
ATOM    498  CA  HIS A  74      32.229  81.319  -2.015  1.00 29.18           C  
ATOM    499  C   HIS A  74      30.722  81.376  -1.858  1.00 27.46           C  
ATOM    500  O   HIS A  74      30.206  82.266  -1.202  1.00 25.58           O  
ATOM    501  CB  HIS A  74      32.870  80.931  -0.675  1.00 29.33           C  
ATOM    502  CG  HIS A  74      32.391  79.625  -0.127  1.00 28.76           C  
ATOM    503  ND1 HIS A  74      32.760  78.412  -0.667  1.00 29.76           N  
ATOM    504  CD2 HIS A  74      31.561  79.344   0.904  1.00 29.02           C  
ATOM    505  CE1 HIS A  74      32.187  77.437   0.016  1.00 30.23           C  
ATOM    506  NE2 HIS A  74      31.458  77.975   0.978  1.00 29.90           N  
ATOM    507  N   ILE A  75      30.026  80.444  -2.498  1.00 26.55           N  
ATOM    508  CA  ILE A  75      28.587  80.301  -2.295  1.00 25.55           C  
ATOM    509  C   ILE A  75      28.404  79.235  -1.242  1.00 24.98           C  
ATOM    510  O   ILE A  75      28.737  78.071  -1.465  1.00 25.66           O  
ATOM    511  CB  ILE A  75      27.840  79.892  -3.590  1.00 25.32           C  
ATOM    512  CG1 ILE A  75      28.049  80.937  -4.697  1.00 25.61           C  
ATOM    513  CG2 ILE A  75      26.361  79.679  -3.295  1.00 25.02           C  
ATOM    514  CD1 ILE A  75      27.624  80.463  -6.090  1.00 25.63           C  
ATOM    515  N   SER A  76      27.885  79.623  -0.089  1.00 24.35           N  
ATOM    516  CA  SER A  76      27.753  78.672   1.003  1.00 24.24           C  
ATOM    517  C   SER A  76      26.489  77.811   0.867  1.00 23.76           C  
ATOM    518  O   SER A  76      26.456  76.654   1.344  1.00 23.72           O  
ATOM    519  CB  SER A  76      27.833  79.380   2.356  1.00 24.16           C  
ATOM    520  OG  SER A  76      26.763  80.283   2.538  1.00 27.09           O  
ATOM    521  N   ARG A  77      25.453  78.371   0.234  1.00 22.58           N  
ATOM    522  CA  ARG A  77      24.182  77.654   0.018  1.00 21.94           C  
ATOM    523  C   ARG A  77      23.302  78.368  -1.019  1.00 20.45           C  
ATOM    524  O   ARG A  77      23.482  79.571  -1.274  1.00 18.60           O  
ATOM    525  CB  ARG A  77      23.406  77.441   1.345  1.00 22.32           C  
ATOM    526  CG  ARG A  77      22.614  78.622   1.860  1.00 24.10           C  
ATOM    527  CD  ARG A  77      22.078  78.485   3.339  1.00 23.81           C  
ATOM    528  NE  ARG A  77      20.794  77.809   3.481  1.00 28.00           N  
ATOM    529  CZ  ARG A  77      19.821  78.144   4.343  1.00 30.79           C  
ATOM    530  NH1 ARG A  77      19.924  79.199   5.158  1.00 28.39           N  
ATOM    531  NH2 ARG A  77      18.704  77.424   4.375  1.00 32.69           N  
ATOM    532  N   ILE A  78      22.371  77.621  -1.616  1.00 19.35           N  
ATOM    533  CA  ILE A  78      21.240  78.257  -2.313  1.00 19.25           C  
ATOM    534  C   ILE A  78      19.998  77.884  -1.530  1.00 18.49           C  
ATOM    535  O   ILE A  78      19.662  76.706  -1.421  1.00 18.50           O  
ATOM    536  CB  ILE A  78      21.120  77.866  -3.788  1.00 19.48           C  
ATOM    537  CG1 ILE A  78      22.426  78.215  -4.508  1.00 21.51           C  
ATOM    538  CG2 ILE A  78      19.920  78.611  -4.452  1.00 19.59           C  
ATOM    539  CD1 ILE A  78      22.515  77.657  -5.902  1.00 26.43           C  
ATOM    540  N   VAL A  79      19.358  78.893  -0.949  1.00 18.09           N  
ATOM    541  CA  VAL A  79      18.139  78.702  -0.154  1.00 18.29           C  
ATOM    542  C   VAL A  79      16.933  78.323  -1.039  1.00 19.13           C  
ATOM    543  O   VAL A  79      16.749  78.897  -2.107  1.00 18.45           O  
ATOM    544  CB  VAL A  79      17.804  79.992   0.663  1.00 18.31           C  
ATOM    545  CG1 VAL A  79      16.626  79.758   1.605  1.00 17.87           C  
ATOM    546  CG2 VAL A  79      19.039  80.525   1.408  1.00 15.50           C  
ATOM    547  N   LYS A  80      16.132  77.356  -0.576  1.00 19.44           N  
ATOM    548  CA  LYS A  80      14.928  76.879  -1.277  1.00 20.51           C  
ATOM    549  C   LYS A  80      13.654  77.324  -0.540  1.00 20.64           C  
ATOM    550  O   LYS A  80      13.704  77.659   0.667  1.00 20.44           O  
ATOM    551  CB  LYS A  80      14.956  75.344  -1.433  1.00 20.07           C  
ATOM    552  CG  LYS A  80      14.756  74.565  -0.121  1.00 20.02           C  
ATOM    553  CD  LYS A  80      15.125  73.079  -0.299  1.00 22.45           C  
ATOM    554  CE  LYS A  80      14.388  72.193   0.700  1.00 26.22           C  
ATOM    555  NZ  LYS A  80      15.062  70.855   0.812  1.00 30.77           N  
ATOM    556  N   PRO A  81      12.511  77.362  -1.259  1.00 21.56           N  
ATOM    557  CA  PRO A  81      11.289  77.811  -0.616  1.00 21.79           C  
ATOM    558  C   PRO A  81      10.955  77.018   0.640  1.00 22.09           C  
ATOM    559  O   PRO A  81      11.272  75.811   0.749  1.00 21.70           O  
ATOM    560  CB  PRO A  81      10.228  77.610  -1.707  1.00 21.85           C  
ATOM    561  CG  PRO A  81      10.979  77.734  -2.973  1.00 22.34           C  
ATOM    562  CD  PRO A  81      12.284  77.058  -2.687  1.00 21.32           C  
ATOM    563  N   GLY A  82      10.367  77.714   1.608  1.00 22.46           N  
ATOM    564  CA  GLY A  82      10.068  77.123   2.912  1.00 22.46           C  
ATOM    565  C   GLY A  82      11.186  77.162   3.951  1.00 22.80           C  
ATOM    566  O   GLY A  82      11.013  76.631   5.039  1.00 22.64           O  
ATOM    567  N   GLN A  83      12.339  77.753   3.615  1.00 22.51           N  
ATOM    568  CA  GLN A  83      13.459  77.887   4.554  1.00 22.20           C  
ATOM    569  C   GLN A  83      13.604  79.331   5.041  1.00 21.97           C  
ATOM    570  O   GLN A  83      13.240  80.280   4.331  1.00 21.25           O  
ATOM    571  CB  GLN A  83      14.805  77.437   3.929  1.00 22.13           C  
ATOM    572  CG  GLN A  83      14.924  75.949   3.567  1.00 22.87           C  
ATOM    573  CD  GLN A  83      16.323  75.571   3.053  1.00 24.08           C  
ATOM    574  OE1 GLN A  83      16.938  76.293   2.258  1.00 23.11           O  
ATOM    575  NE2 GLN A  83      16.823  74.429   3.508  1.00 24.10           N  
ATOM    576  N   PHE A  84      14.148  79.474   6.251  1.00 21.32           N  
ATOM    577  CA  PHE A  84      14.606  80.760   6.789  1.00 21.05           C  
ATOM    578  C   PHE A  84      16.067  81.043   6.408  1.00 20.58           C  
ATOM    579  O   PHE A  84      16.877  80.118   6.286  1.00 20.14           O  
ATOM    580  CB  PHE A  84      14.500  80.757   8.322  1.00 20.94           C  
ATOM    581  CG  PHE A  84      13.109  80.930   8.819  1.00 22.17           C  
ATOM    582  CD1 PHE A  84      12.609  82.203   9.104  1.00 23.71           C  
ATOM    583  CD2 PHE A  84      12.279  79.828   8.981  1.00 22.81           C  
ATOM    584  CE1 PHE A  84      11.301  82.360   9.550  1.00 24.01           C  
ATOM    585  CE2 PHE A  84      10.967  79.984   9.420  1.00 24.42           C  
ATOM    586  CZ  PHE A  84      10.485  81.249   9.710  1.00 23.00           C  
ATOM    587  N   PHE A  85      16.402  82.317   6.247  1.00 19.60           N  
ATOM    588  CA  PHE A  85      17.796  82.734   6.087  1.00 19.20           C  
ATOM    589  C   PHE A  85      18.039  84.072   6.796  1.00 19.09           C  
ATOM    590  O   PHE A  85      17.090  84.760   7.187  1.00 18.30           O  
ATOM    591  CB  PHE A  85      18.231  82.745   4.603  1.00 19.16           C  
ATOM    592  CG  PHE A  85      17.467  83.721   3.741  1.00 18.47           C  
ATOM    593  CD1 PHE A  85      18.076  84.903   3.307  1.00 19.05           C  
ATOM    594  CD2 PHE A  85      16.152  83.455   3.342  1.00 17.09           C  
ATOM    595  CE1 PHE A  85      17.385  85.801   2.516  1.00 18.75           C  
ATOM    596  CE2 PHE A  85      15.446  84.355   2.562  1.00 17.14           C  
ATOM    597  CZ  PHE A  85      16.061  85.528   2.128  1.00 17.99           C  
ATOM    598  N   GLY A  86      19.305  84.419   7.004  1.00 18.80           N  
ATOM    599  CA  GLY A  86      19.634  85.484   7.946  1.00 19.49           C  
ATOM    600  C   GLY A  86      19.324  85.145   9.397  1.00 19.74           C  
ATOM    601  O   GLY A  86      19.323  86.034  10.249  1.00 19.60           O  
ATOM    602  N   MET A  87      19.072  83.860   9.685  1.00 19.36           N  
ATOM    603  CA  MET A  87      18.765  83.405  11.051  1.00 19.54           C  
ATOM    604  C   MET A  87      20.039  83.162  11.870  1.00 19.35           C  
ATOM    605  O   MET A  87      20.086  83.485  13.052  1.00 18.72           O  
ATOM    606  CB  MET A  87      17.791  82.181  11.103  1.00 19.83           C  
ATOM    607  CG  MET A  87      18.212  80.888  10.366  1.00 20.55           C  
ATOM    608  SD  MET A  87      17.301  79.301  10.675  1.00 19.39           S  
ATOM    609  CE  MET A  87      17.868  79.007  12.322  1.00 27.29           C  
ATOM    610  N   ARG A  88      21.073  82.642  11.211  1.00 19.20           N  
ATOM    611  CA  ARG A  88      22.372  82.338  11.844  1.00 20.03           C  
ATOM    612  C   ARG A  88      22.949  83.532  12.651  1.00 18.60           C  
ATOM    613  O   ARG A  88      23.235  83.395  13.853  1.00 18.74           O  
ATOM    614  CB  ARG A  88      23.381  81.866  10.764  1.00 20.21           C  
ATOM    615  CG  ARG A  88      23.999  83.072   9.955  1.00 23.92           C  
ATOM    616  CD  ARG A  88      24.844  82.823   8.637  1.00 20.90           C  
ATOM    617  NE  ARG A  88      25.223  84.106   8.075  1.00 24.20           N  
ATOM    618  CZ  ARG A  88      24.614  84.683   7.030  1.00 28.46           C  
ATOM    619  NH1 ARG A  88      23.586  84.101   6.399  1.00 30.71           N  
ATOM    620  NH2 ARG A  88      25.030  85.857   6.613  1.00 31.21           N  
ATOM    621  N   PRO A  89      23.111  84.708  12.008  1.00 18.53           N  
ATOM    622  CA  PRO A  89      23.804  85.760  12.740  1.00 17.75           C  
ATOM    623  C   PRO A  89      22.955  86.307  13.879  1.00 17.37           C  
ATOM    624  O   PRO A  89      23.508  86.769  14.862  1.00 17.10           O  
ATOM    625  CB  PRO A  89      24.111  86.820  11.680  1.00 17.92           C  
ATOM    626  CG  PRO A  89      23.243  86.524  10.512  1.00 19.57           C  
ATOM    627  CD  PRO A  89      22.719  85.120  10.643  1.00 18.18           C  
ATOM    628  N   TYR A  90      21.631  86.220  13.753  1.00 17.01           N  
ATOM    629  CA  TYR A  90      20.745  86.614  14.837  1.00 17.62           C  
ATOM    630  C   TYR A  90      20.994  85.737  16.083  1.00 17.41           C  
ATOM    631  O   TYR A  90      21.232  86.256  17.176  1.00 17.16           O  
ATOM    632  CB  TYR A  90      19.274  86.523  14.419  1.00 18.11           C  
ATOM    633  CG  TYR A  90      18.375  86.603  15.631  1.00 20.02           C  
ATOM    634  CD1 TYR A  90      18.234  87.802  16.341  1.00 20.31           C  
ATOM    635  CD2 TYR A  90      17.717  85.476  16.099  1.00 20.13           C  
ATOM    636  CE1 TYR A  90      17.428  87.874  17.477  1.00 20.81           C  
ATOM    637  CE2 TYR A  90      16.923  85.531  17.234  1.00 20.68           C  
ATOM    638  CZ  TYR A  90      16.794  86.722  17.918  1.00 21.32           C  
ATOM    639  OH  TYR A  90      16.001  86.744  19.046  1.00 24.52           O  
ATOM    640  N   PHE A  91      20.934  84.416  15.904  1.00 16.51           N  
ATOM    641  CA  PHE A  91      21.152  83.480  17.009  1.00 16.91           C  
ATOM    642  C   PHE A  91      22.586  83.508  17.558  1.00 16.48           C  
ATOM    643  O   PHE A  91      22.795  83.387  18.770  1.00 16.41           O  
ATOM    644  CB  PHE A  91      20.719  82.056  16.611  1.00 17.04           C  
ATOM    645  CG  PHE A  91      19.212  81.904  16.439  1.00 16.20           C  
ATOM    646  CD1 PHE A  91      18.347  82.108  17.515  1.00 18.83           C  
ATOM    647  CD2 PHE A  91      18.667  81.557  15.209  1.00 18.22           C  
ATOM    648  CE1 PHE A  91      16.963  81.951  17.367  1.00 19.92           C  
ATOM    649  CE2 PHE A  91      17.285  81.395  15.053  1.00 20.25           C  
ATOM    650  CZ  PHE A  91      16.430  81.606  16.142  1.00 19.59           C  
ATOM    651  N   ALA A  92      23.564  83.712  16.679  1.00 16.20           N  
ATOM    652  CA  ALA A  92      24.977  83.732  17.084  1.00 16.05           C  
ATOM    653  C   ALA A  92      25.371  85.048  17.747  1.00 17.23           C  
ATOM    654  O   ALA A  92      26.410  85.123  18.397  1.00 17.25           O  
ATOM    655  CB  ALA A  92      25.885  83.448  15.898  1.00 15.31           C  
ATOM    656  N   GLU A  93      24.528  86.064  17.577  1.00 16.90           N  
ATOM    657  CA  GLU A  93      24.820  87.447  17.997  1.00 18.32           C  
ATOM    658  C   GLU A  93      26.092  87.948  17.306  1.00 18.35           C  
ATOM    659  O   GLU A  93      27.107  88.297  17.944  1.00 17.74           O  
ATOM    660  CB  GLU A  93      24.891  87.562  19.524  1.00 17.76           C  
ATOM    661  CG  GLU A  93      23.614  87.091  20.222  1.00 19.17           C  
ATOM    662  CD  GLU A  93      23.623  87.425  21.691  1.00 22.59           C  
ATOM    663  OE1 GLU A  93      24.378  86.790  22.456  1.00 22.87           O  
ATOM    664  OE2 GLU A  93      22.884  88.351  22.069  1.00 25.10           O  
ATOM    665  N   GLU A  94      26.015  87.961  15.980  1.00 18.31           N  
ATOM    666  CA  GLU A  94      27.111  88.394  15.138  1.00 18.32           C  
ATOM    667  C   GLU A  94      26.540  89.253  14.005  1.00 18.18           C  
ATOM    668  O   GLU A  94      25.316  89.362  13.837  1.00 17.99           O  
ATOM    669  CB  GLU A  94      27.819  87.167  14.534  1.00 17.75           C  
ATOM    670  CG  GLU A  94      28.564  86.303  15.545  1.00 19.32           C  
ATOM    671  CD  GLU A  94      29.065  84.970  14.968  1.00 19.13           C  
ATOM    672  OE1 GLU A  94      28.877  84.699  13.765  1.00 20.95           O  
ATOM    673  OE2 GLU A  94      29.661  84.201  15.738  1.00 20.59           O  
ATOM    674  N   THR A  95      27.434  89.822  13.209  1.00 18.22           N  
ATOM    675  CA  THR A  95      27.060  90.474  11.959  1.00 18.38           C  
ATOM    676  C   THR A  95      26.872  89.385  10.895  1.00 18.68           C  
ATOM    677  O   THR A  95      27.331  88.251  11.088  1.00 18.32           O  
ATOM    678  CB  THR A  95      28.151  91.460  11.526  1.00 18.89           C  
ATOM    679  OG1 THR A  95      29.392  90.762  11.421  1.00 19.87           O  
ATOM    680  CG2 THR A  95      28.303  92.595  12.555  1.00 19.90           C  
ATOM    681  N   CYS A  96      26.205  89.716   9.783  1.00 18.43           N  
ATOM    682  CA  CYS A  96      26.039  88.769   8.676  1.00 18.82           C  
ATOM    683  C   CYS A  96      27.405  88.400   8.107  1.00 18.56           C  
ATOM    684  O   CYS A  96      28.203  89.283   7.799  1.00 17.78           O  
ATOM    685  CB  CYS A  96      25.161  89.371   7.567  1.00 18.63           C  
ATOM    686  SG  CYS A  96      23.485  89.636   8.107  1.00 21.64           S  
ATOM    687  N   SER A  97      27.681  87.103   8.008  1.00 17.98           N  
ATOM    688  CA  SER A  97      28.953  86.621   7.461  1.00 18.81           C  
ATOM    689  C   SER A  97      28.942  86.611   5.947  1.00 18.68           C  
ATOM    690  O   SER A  97      29.979  86.382   5.332  1.00 19.27           O  
ATOM    691  CB  SER A  97      29.206  85.181   7.926  1.00 18.76           C  
ATOM    692  OG  SER A  97      28.249  84.345   7.275  1.00 21.93           O  
ATOM    693  N   SER A  98      27.766  86.839   5.356  1.00 18.80           N  
ATOM    694  CA  SER A  98      27.506  86.589   3.938  1.00 19.58           C  
ATOM    695  C   SER A  98      26.523  87.606   3.362  1.00 19.47           C  
ATOM    696  O   SER A  98      25.802  88.256   4.116  1.00 19.53           O  
ATOM    697  CB  SER A  98      26.894  85.197   3.782  1.00 19.57           C  
ATOM    698  OG  SER A  98      27.810  84.210   4.210  1.00 22.07           O  
ATOM    699  N   THR A  99      26.519  87.733   2.035  1.00 19.45           N  
ATOM    700  CA  THR A  99      25.537  88.526   1.279  1.00 19.04           C  
ATOM    701  C   THR A  99      24.495  87.567   0.706  1.00 19.08           C  
ATOM    702  O   THR A  99      24.846  86.482   0.235  1.00 18.65           O  
ATOM    703  CB  THR A  99      26.230  89.274   0.115  1.00 19.66           C  
ATOM    704  OG1 THR A  99      27.246  90.139   0.638  1.00 19.60           O  
ATOM    705  CG2 THR A  99      25.230  90.084  -0.734  1.00 19.05           C  
ATOM    706  N   ALA A 100      23.222  87.958   0.744  1.00 18.31           N  
ATOM    707  CA  ALA A 100      22.148  87.146   0.200  1.00 18.44           C  
ATOM    708  C   ALA A 100      21.599  87.842  -1.038  1.00 19.08           C  
ATOM    709  O   ALA A 100      21.149  88.998  -0.939  1.00 19.04           O  
ATOM    710  CB  ALA A 100      21.044  86.991   1.234  1.00 18.63           C  
ATOM    711  N   ILE A 101      21.657  87.147  -2.177  1.00 18.36           N  
ATOM    712  CA  ILE A 101      21.271  87.701  -3.494  1.00 19.16           C  
ATOM    713  C   ILE A 101      20.243  86.770  -4.143  1.00 18.83           C  
ATOM    714  O   ILE A 101      20.427  85.554  -4.161  1.00 18.23           O  
ATOM    715  CB  ILE A 101      22.496  87.864  -4.447  1.00 18.81           C  
ATOM    716  CG1 ILE A 101      23.516  88.852  -3.861  1.00 19.43           C  
ATOM    717  CG2 ILE A 101      22.053  88.370  -5.840  1.00 20.22           C  
ATOM    718  CD1 ILE A 101      24.859  88.824  -4.544  1.00 19.65           C  
ATOM    719  N   ALA A 102      19.164  87.340  -4.673  1.00 19.40           N  
ATOM    720  CA  ALA A 102      18.143  86.549  -5.369  1.00 19.58           C  
ATOM    721  C   ALA A 102      18.638  85.996  -6.729  1.00 20.34           C  
ATOM    722  O   ALA A 102      19.180  86.727  -7.565  1.00 19.70           O  
ATOM    723  CB  ALA A 102      16.844  87.376  -5.532  1.00 21.10           C  
ATOM    724  N   VAL A 103      18.450  84.694  -6.920  1.00 21.01           N  
ATOM    725  CA  VAL A 103      18.839  83.968  -8.144  1.00 22.55           C  
ATOM    726  C   VAL A 103      17.724  84.122  -9.180  1.00 23.23           C  
ATOM    727  O   VAL A 103      17.966  84.036 -10.397  1.00 23.36           O  
ATOM    728  CB  VAL A 103      19.090  82.459  -7.817  1.00 22.08           C  
ATOM    729  CG1 VAL A 103      19.110  81.554  -9.084  1.00 23.48           C  
ATOM    730  CG2 VAL A 103      20.371  82.301  -7.014  1.00 23.19           C  
ATOM    731  N   GLU A 104      16.508  84.338  -8.675  1.00 23.76           N  
ATOM    732  CA  GLU A 104      15.319  84.636  -9.485  1.00 24.40           C  
ATOM    733  C   GLU A 104      14.420  85.572  -8.678  1.00 23.59           C  
ATOM    734  O   GLU A 104      14.620  85.717  -7.460  1.00 23.57           O  
ATOM    735  CB  GLU A 104      14.576  83.345  -9.859  1.00 24.68           C  
ATOM    736  CG  GLU A 104      13.713  82.736  -8.756  1.00 25.50           C  
ATOM    737  CD  GLU A 104      13.216  81.318  -9.077  1.00 27.61           C  
ATOM    738  OE1 GLU A 104      13.761  80.670  -9.992  1.00 31.64           O  
ATOM    739  OE2 GLU A 104      12.265  80.845  -8.416  1.00 31.10           O  
ATOM    740  N   ASN A 105      13.446  86.213  -9.337  1.00 22.64           N  
ATOM    741  CA  ASN A 105      12.406  86.960  -8.624  1.00 22.04           C  
ATOM    742  C   ASN A 105      11.851  86.076  -7.514  1.00 21.91           C  
ATOM    743  O   ASN A 105      11.423  84.945  -7.775  1.00 21.28           O  
ATOM    744  CB  ASN A 105      11.250  87.372  -9.550  1.00 21.97           C  
ATOM    745  CG  ASN A 105      11.614  88.496 -10.502  1.00 22.58           C  
ATOM    746  OD1 ASN A 105      12.749  88.988 -10.516  1.00 21.99           O  
ATOM    747  ND2 ASN A 105      10.636  88.907 -11.323  1.00 22.02           N  
ATOM    748  N   SER A 106      11.881  86.593  -6.287  1.00 21.50           N  
ATOM    749  CA  SER A 106      11.520  85.826  -5.104  1.00 21.13           C  
ATOM    750  C   SER A 106      10.528  86.597  -4.243  1.00 21.03           C  
ATOM    751  O   SER A 106      10.513  87.830  -4.243  1.00 21.09           O  
ATOM    752  CB  SER A 106      12.767  85.512  -4.265  1.00 20.93           C  
ATOM    753  OG  SER A 106      13.723  84.784  -5.012  1.00 21.71           O  
ATOM    754  N   LYS A 107       9.725  85.852  -3.495  1.00 21.03           N  
ATOM    755  CA  LYS A 107       8.786  86.413  -2.538  1.00 21.41           C  
ATOM    756  C   LYS A 107       9.353  86.115  -1.159  1.00 21.17           C  
ATOM    757  O   LYS A 107       9.392  84.961  -0.740  1.00 20.79           O  
ATOM    758  CB  LYS A 107       7.410  85.761  -2.700  1.00 22.28           C  
ATOM    759  CG  LYS A 107       6.712  86.085  -4.017  1.00 24.57           C  
ATOM    760  CD  LYS A 107       5.289  85.544  -4.000  1.00 28.57           C  
ATOM    761  CE  LYS A 107       4.542  85.927  -5.265  1.00 32.10           C  
ATOM    762  NZ  LYS A 107       5.024  85.146  -6.425  1.00 34.40           N  
ATOM    763  N   VAL A 108       9.847  87.151  -0.489  1.00 20.87           N  
ATOM    764  CA  VAL A 108      10.510  86.985   0.807  1.00 21.37           C  
ATOM    765  C   VAL A 108       9.668  87.668   1.866  1.00 22.05           C  
ATOM    766  O   VAL A 108       9.141  88.761   1.629  1.00 22.59           O  
ATOM    767  CB  VAL A 108      11.945  87.584   0.779  1.00 21.27           C  
ATOM    768  CG1 VAL A 108      12.615  87.536   2.153  1.00 21.16           C  
ATOM    769  CG2 VAL A 108      12.802  86.855  -0.273  1.00 21.50           C  
ATOM    770  N   LEU A 109       9.525  87.016   3.018  1.00 21.76           N  
ATOM    771  CA  LEU A 109       8.862  87.623   4.179  1.00 22.44           C  
ATOM    772  C   LEU A 109       9.890  87.993   5.252  1.00 22.88           C  
ATOM    773  O   LEU A 109      10.702  87.149   5.636  1.00 22.71           O  
ATOM    774  CB  LEU A 109       7.789  86.670   4.729  1.00 22.25           C  
ATOM    775  CG  LEU A 109       6.651  86.489   3.701  1.00 24.15           C  
ATOM    776  CD1 LEU A 109       5.852  85.214   3.919  1.00 24.06           C  
ATOM    777  CD2 LEU A 109       5.729  87.740   3.672  1.00 24.37           C  
ATOM    778  N   ALA A 110       9.852  89.245   5.724  1.00 22.63           N  
ATOM    779  CA  ALA A 110      10.749  89.716   6.783  1.00 23.29           C  
ATOM    780  C   ALA A 110      10.068  89.786   8.153  1.00 23.94           C  
ATOM    781  O   ALA A 110       8.962  90.357   8.301  1.00 23.92           O  
ATOM    782  CB  ALA A 110      11.356  91.071   6.417  1.00 23.48           C  
ATOM    783  N   ILE A 111      10.712  89.162   9.141  1.00 23.91           N  
ATOM    784  CA  ILE A 111      10.231  89.192  10.518  1.00 23.43           C  
ATOM    785  C   ILE A 111      11.267  89.915  11.392  1.00 23.56           C  
ATOM    786  O   ILE A 111      12.382  89.414  11.580  1.00 23.43           O  
ATOM    787  CB  ILE A 111       9.927  87.793  11.104  1.00 23.26           C  
ATOM    788  CG1 ILE A 111       9.132  86.891  10.137  1.00 24.56           C  
ATOM    789  CG2 ILE A 111       9.141  87.939  12.428  1.00 22.54           C  
ATOM    790  CD1 ILE A 111       9.970  86.230   9.029  1.00 26.77           C  
ATOM    791  N   PRO A 112      10.896  91.089  11.948  1.00 23.74           N  
ATOM    792  CA  PRO A 112      11.781  91.868  12.816  1.00 23.21           C  
ATOM    793  C   PRO A 112      12.322  91.018  13.977  1.00 23.24           C  
ATOM    794  O   PRO A 112      11.574  90.223  14.565  1.00 22.43           O  
ATOM    795  CB  PRO A 112      10.852  92.970  13.356  1.00 23.93           C  
ATOM    796  CG  PRO A 112       9.809  93.128  12.280  1.00 23.97           C  
ATOM    797  CD  PRO A 112       9.567  91.721  11.812  1.00 24.26           C  
ATOM    798  N   VAL A 113      13.612  91.166  14.281  1.00 22.97           N  
ATOM    799  CA  VAL A 113      14.251  90.366  15.337  1.00 23.68           C  
ATOM    800  C   VAL A 113      13.551  90.547  16.693  1.00 23.84           C  
ATOM    801  O   VAL A 113      13.475  89.617  17.475  1.00 23.32           O  
ATOM    802  CB  VAL A 113      15.789  90.631  15.461  1.00 23.54           C  
ATOM    803  CG1 VAL A 113      16.529  90.100  14.242  1.00 24.04           C  
ATOM    804  CG2 VAL A 113      16.091  92.121  15.691  1.00 23.84           C  
ATOM    805  N   GLU A 114      13.016  91.743  16.945  1.00 25.26           N  
ATOM    806  CA  GLU A 114      12.230  92.006  18.164  1.00 26.16           C  
ATOM    807  C   GLU A 114      11.013  91.089  18.258  1.00 26.18           C  
ATOM    808  O   GLU A 114      10.742  90.518  19.321  1.00 26.65           O  
ATOM    809  CB  GLU A 114      11.802  93.479  18.240  1.00 26.89           C  
ATOM    810  CG  GLU A 114      12.974  94.461  18.357  1.00 29.62           C  
ATOM    811  CD  GLU A 114      13.629  94.797  17.010  1.00 33.42           C  
ATOM    812  OE1 GLU A 114      13.129  94.363  15.939  1.00 32.23           O  
ATOM    813  OE2 GLU A 114      14.663  95.501  17.030  1.00 35.54           O  
ATOM    814  N   ALA A 115      10.289  90.934  17.148  1.00 26.05           N  
ATOM    815  CA  ALA A 115       9.157  90.005  17.097  1.00 26.04           C  
ATOM    816  C   ALA A 115       9.624  88.550  17.265  1.00 25.93           C  
ATOM    817  O   ALA A 115       9.006  87.776  17.999  1.00 26.01           O  
ATOM    818  CB  ALA A 115       8.393  90.158  15.791  1.00 26.38           C  
ATOM    819  N   ILE A 116      10.706  88.187  16.569  1.00 25.23           N  
ATOM    820  CA  ILE A 116      11.287  86.836  16.699  1.00 24.49           C  
ATOM    821  C   ILE A 116      11.614  86.534  18.154  1.00 24.96           C  
ATOM    822  O   ILE A 116      11.256  85.473  18.668  1.00 24.77           O  
ATOM    823  CB  ILE A 116      12.553  86.645  15.815  1.00 24.00           C  
ATOM    824  CG1 ILE A 116      12.186  86.619  14.322  1.00 22.79           C  
ATOM    825  CG2 ILE A 116      13.299  85.363  16.202  1.00 23.83           C  
ATOM    826  CD1 ILE A 116      11.262  85.450  13.902  1.00 20.69           C  
ATOM    827  N   GLU A 117      12.287  87.476  18.813  1.00 25.39           N  
ATOM    828  CA  GLU A 117      12.702  87.282  20.206  1.00 27.07           C  
ATOM    829  C   GLU A 117      11.532  87.090  21.175  1.00 26.95           C  
ATOM    830  O   GLU A 117      11.592  86.224  22.057  1.00 26.87           O  
ATOM    831  CB  GLU A 117      13.596  88.427  20.679  1.00 27.18           C  
ATOM    832  CG  GLU A 117      14.517  88.011  21.821  1.00 32.03           C  
ATOM    833  CD  GLU A 117      15.185  89.185  22.508  1.00 36.67           C  
ATOM    834  OE1 GLU A 117      14.630  90.309  22.473  1.00 40.02           O  
ATOM    835  OE2 GLU A 117      16.265  88.978  23.104  1.00 40.46           O  
ATOM    836  N   ALA A 118      10.477  87.890  21.014  1.00 27.43           N  
ATOM    837  CA  ALA A 118       9.262  87.739  21.835  1.00 27.11           C  
ATOM    838  C   ALA A 118       8.660  86.350  21.668  1.00 27.27           C  
ATOM    839  O   ALA A 118       8.259  85.709  22.642  1.00 27.16           O  
ATOM    840  CB  ALA A 118       8.233  88.794  21.474  1.00 27.37           C  
ATOM    841  N   LEU A 119       8.600  85.887  20.425  1.00 26.88           N  
ATOM    842  CA  LEU A 119       8.031  84.585  20.121  1.00 27.06           C  
ATOM    843  C   LEU A 119       8.860  83.453  20.728  1.00 26.96           C  
ATOM    844  O   LEU A 119       8.301  82.543  21.345  1.00 27.29           O  
ATOM    845  CB  LEU A 119       7.880  84.404  18.604  1.00 26.96           C  
ATOM    846  CG  LEU A 119       6.800  85.250  17.924  1.00 28.01           C  
ATOM    847  CD1 LEU A 119       6.963  85.208  16.408  1.00 27.06           C  
ATOM    848  CD2 LEU A 119       5.399  84.776  18.340  1.00 28.04           C  
ATOM    849  N   LEU A 120      10.182  83.511  20.556  1.00 27.08           N  
ATOM    850  CA  LEU A 120      11.092  82.520  21.151  1.00 26.79           C  
ATOM    851  C   LEU A 120      10.988  82.446  22.687  1.00 27.56           C  
ATOM    852  O   LEU A 120      11.009  81.358  23.273  1.00 26.92           O  
ATOM    853  CB  LEU A 120      12.542  82.815  20.751  1.00 26.91           C  
ATOM    854  CG  LEU A 120      12.986  82.610  19.291  1.00 26.18           C  
ATOM    855  CD1 LEU A 120      14.281  83.357  19.038  1.00 24.61           C  
ATOM    856  CD2 LEU A 120      13.145  81.137  18.970  1.00 25.79           C  
ATOM    857  N   LYS A 121      10.886  83.605  23.334  1.00 28.13           N  
ATOM    858  CA  LYS A 121      10.783  83.673  24.800  1.00 28.70           C  
ATOM    859  C   LYS A 121       9.580  82.925  25.382  1.00 28.78           C  
ATOM    860  O   LYS A 121       9.650  82.391  26.494  1.00 28.90           O  
ATOM    861  CB  LYS A 121      10.757  85.118  25.267  1.00 28.91           C  
ATOM    862  CG  LYS A 121      12.105  85.798  25.221  1.00 31.85           C  
ATOM    863  CD  LYS A 121      12.047  87.104  25.999  1.00 36.07           C  
ATOM    864  CE  LYS A 121      13.087  88.093  25.490  1.00 39.25           C  
ATOM    865  NZ  LYS A 121      14.493  87.557  25.558  1.00 40.96           N  
ATOM    866  N   GLY A 122       8.482  82.887  24.636  1.00 28.70           N  
ATOM    867  CA  GLY A 122       7.257  82.297  25.143  1.00 28.11           C  
ATOM    868  C   GLY A 122       6.945  80.901  24.663  1.00 28.04           C  
ATOM    869  O   GLY A 122       5.981  80.298  25.131  1.00 28.44           O  
ATOM    870  N   ASN A 123       7.758  80.366  23.749  1.00 27.22           N  
ATOM    871  CA  ASN A 123       7.366  79.179  23.001  1.00 26.63           C  
ATOM    872  C   ASN A 123       8.545  78.233  22.725  1.00 26.29           C  
ATOM    873  O   ASN A 123       9.322  78.467  21.798  1.00 25.65           O  
ATOM    874  CB  ASN A 123       6.692  79.624  21.687  1.00 26.61           C  
ATOM    875  CG  ASN A 123       5.942  78.504  20.988  1.00 26.75           C  
ATOM    876  OD1 ASN A 123       6.411  77.372  20.909  1.00 27.73           O  
ATOM    877  ND2 ASN A 123       4.773  78.824  20.470  1.00 27.57           N  
ATOM    878  N   THR A 124       8.673  77.164  23.519  1.00 25.73           N  
ATOM    879  CA  THR A 124       9.774  76.202  23.308  1.00 25.57           C  
ATOM    880  C   THR A 124       9.683  75.448  21.966  1.00 25.33           C  
ATOM    881  O   THR A 124      10.716  75.107  21.386  1.00 24.97           O  
ATOM    882  CB  THR A 124       9.927  75.183  24.457  1.00 25.44           C  
ATOM    883  OG1 THR A 124       8.725  74.420  24.596  1.00 25.52           O  
ATOM    884  CG2 THR A 124      10.261  75.892  25.772  1.00 24.70           C  
ATOM    885  N   SER A 125       8.462  75.189  21.487  1.00 24.49           N  
ATOM    886  CA  SER A 125       8.250  74.572  20.160  1.00 24.42           C  
ATOM    887  C   SER A 125       8.846  75.399  19.023  1.00 22.95           C  
ATOM    888  O   SER A 125       9.439  74.857  18.086  1.00 21.95           O  
ATOM    889  CB  SER A 125       6.764  74.382  19.878  1.00 24.31           C  
ATOM    890  OG  SER A 125       6.292  73.244  20.538  1.00 28.01           O  
ATOM    891  N   PHE A 126       8.634  76.705  19.103  1.00 22.71           N  
ATOM    892  CA  PHE A 126       9.209  77.687  18.173  1.00 22.25           C  
ATOM    893  C   PHE A 126      10.740  77.640  18.263  1.00 21.92           C  
ATOM    894  O   PHE A 126      11.425  77.623  17.251  1.00 21.76           O  
ATOM    895  CB  PHE A 126       8.681  79.079  18.529  1.00 22.42           C  
ATOM    896  CG  PHE A 126       8.957  80.156  17.483  1.00 22.88           C  
ATOM    897  CD1 PHE A 126       8.314  80.142  16.253  1.00 24.81           C  
ATOM    898  CD2 PHE A 126       9.814  81.210  17.766  1.00 23.19           C  
ATOM    899  CE1 PHE A 126       8.555  81.148  15.295  1.00 25.03           C  
ATOM    900  CE2 PHE A 126      10.059  82.211  16.827  1.00 23.53           C  
ATOM    901  CZ  PHE A 126       9.420  82.180  15.585  1.00 24.14           C  
ATOM    902  N   CYS A 127      11.274  77.623  19.482  1.00 21.84           N  
ATOM    903  CA  CYS A 127      12.726  77.476  19.682  1.00 21.85           C  
ATOM    904  C   CYS A 127      13.248  76.195  19.038  1.00 21.42           C  
ATOM    905  O   CYS A 127      14.263  76.203  18.334  1.00 20.07           O  
ATOM    906  CB  CYS A 127      13.052  77.445  21.169  1.00 21.61           C  
ATOM    907  SG  CYS A 127      12.763  78.982  22.008  1.00 25.38           S  
ATOM    908  N   ARG A 128      12.536  75.096  19.273  1.00 21.19           N  
ATOM    909  CA  ARG A 128      13.006  73.783  18.834  1.00 21.80           C  
ATOM    910  C   ARG A 128      12.940  73.596  17.314  1.00 21.46           C  
ATOM    911  O   ARG A 128      13.726  72.821  16.733  1.00 21.18           O  
ATOM    912  CB  ARG A 128      12.291  72.680  19.602  1.00 22.76           C  
ATOM    913  CG  ARG A 128      12.716  72.655  21.076  1.00 23.52           C  
ATOM    914  CD  ARG A 128      11.802  71.823  21.927  1.00 27.28           C  
ATOM    915  NE  ARG A 128      11.911  70.420  21.557  1.00 32.25           N  
ATOM    916  CZ  ARG A 128      10.953  69.521  21.729  1.00 34.57           C  
ATOM    917  NH1 ARG A 128       9.799  69.881  22.287  1.00 36.94           N  
ATOM    918  NH2 ARG A 128      11.148  68.262  21.343  1.00 35.24           N  
ATOM    919  N   TYR A 129      12.021  74.316  16.676  1.00 20.94           N  
ATOM    920  CA  TYR A 129      11.978  74.386  15.218  1.00 20.71           C  
ATOM    921  C   TYR A 129      13.315  74.934  14.683  1.00 19.54           C  
ATOM    922  O   TYR A 129      13.888  74.370  13.758  1.00 18.14           O  
ATOM    923  CB  TYR A 129      10.803  75.251  14.728  1.00 21.92           C  
ATOM    924  CG  TYR A 129      10.889  75.604  13.245  1.00 23.82           C  
ATOM    925  CD1 TYR A 129      10.281  74.811  12.271  1.00 25.31           C  
ATOM    926  CD2 TYR A 129      11.596  76.727  12.822  1.00 24.96           C  
ATOM    927  CE1 TYR A 129      10.369  75.149  10.892  1.00 25.36           C  
ATOM    928  CE2 TYR A 129      11.694  77.062  11.472  1.00 26.57           C  
ATOM    929  CZ  TYR A 129      11.076  76.277  10.517  1.00 26.73           C  
ATOM    930  OH  TYR A 129      11.191  76.646   9.179  1.00 28.23           O  
ATOM    931  N   PHE A 130      13.799  76.028  15.271  1.00 19.07           N  
ATOM    932  CA  PHE A 130      15.047  76.643  14.794  1.00 18.58           C  
ATOM    933  C   PHE A 130      16.273  75.835  15.186  1.00 18.33           C  
ATOM    934  O   PHE A 130      17.265  75.830  14.461  1.00 17.85           O  
ATOM    935  CB  PHE A 130      15.172  78.089  15.257  1.00 19.75           C  
ATOM    936  CG  PHE A 130      14.249  79.011  14.537  1.00 20.75           C  
ATOM    937  CD1 PHE A 130      14.458  79.301  13.186  1.00 21.25           C  
ATOM    938  CD2 PHE A 130      13.151  79.562  15.183  1.00 22.22           C  
ATOM    939  CE1 PHE A 130      13.596  80.149  12.495  1.00 22.21           C  
ATOM    940  CE2 PHE A 130      12.278  80.418  14.489  1.00 23.81           C  
ATOM    941  CZ  PHE A 130      12.508  80.706  13.143  1.00 22.14           C  
ATOM    942  N   LEU A 131      16.201  75.164  16.338  1.00 17.30           N  
ATOM    943  CA  LEU A 131      17.256  74.252  16.774  1.00 16.79           C  
ATOM    944  C   LEU A 131      17.481  73.170  15.715  1.00 17.29           C  
ATOM    945  O   LEU A 131      18.613  72.917  15.321  1.00 16.37           O  
ATOM    946  CB  LEU A 131      16.882  73.618  18.116  1.00 17.24           C  
ATOM    947  CG  LEU A 131      17.150  74.471  19.360  1.00 16.41           C  
ATOM    948  CD1 LEU A 131      16.482  73.862  20.589  1.00 17.33           C  
ATOM    949  CD2 LEU A 131      18.660  74.630  19.573  1.00 17.47           C  
ATOM    950  N   LYS A 132      16.390  72.555  15.248  1.00 16.87           N  
ATOM    951  CA  LYS A 132      16.490  71.549  14.203  1.00 17.95           C  
ATOM    952  C   LYS A 132      17.026  72.156  12.908  1.00 17.53           C  
ATOM    953  O   LYS A 132      17.897  71.569  12.259  1.00 17.26           O  
ATOM    954  CB  LYS A 132      15.136  70.869  13.947  1.00 17.64           C  
ATOM    955  CG  LYS A 132      15.239  69.797  12.861  1.00 19.77           C  
ATOM    956  CD  LYS A 132      13.962  69.024  12.625  1.00 20.33           C  
ATOM    957  CE  LYS A 132      14.291  67.845  11.689  1.00 23.35           C  
ATOM    958  NZ  LYS A 132      13.271  66.753  11.674  1.00 24.85           N  
ATOM    959  N   ALA A 133      16.511  73.329  12.537  1.00 17.05           N  
ATOM    960  CA  ALA A 133      16.926  73.976  11.287  1.00 17.06           C  
ATOM    961  C   ALA A 133      18.428  74.258  11.299  1.00 16.94           C  
ATOM    962  O   ALA A 133      19.141  73.949  10.327  1.00 15.97           O  
ATOM    963  CB  ALA A 133      16.128  75.269  11.061  1.00 16.88           C  
ATOM    964  N   LEU A 134      18.923  74.817  12.408  1.00 16.94           N  
ATOM    965  CA  LEU A 134      20.360  75.087  12.524  1.00 17.05           C  
ATOM    966  C   LEU A 134      21.203  73.816  12.547  1.00 16.56           C  
ATOM    967  O   LEU A 134      22.288  73.772  11.961  1.00 16.49           O  
ATOM    968  CB  LEU A 134      20.665  75.924  13.765  1.00 17.52           C  
ATOM    969  CG  LEU A 134      20.260  77.397  13.754  1.00 18.08           C  
ATOM    970  CD1 LEU A 134      20.320  77.935  15.192  1.00 19.05           C  
ATOM    971  CD2 LEU A 134      21.117  78.221  12.795  1.00 20.01           C  
ATOM    972  N   ALA A 135      20.714  72.780  13.221  1.00 16.48           N  
ATOM    973  CA  ALA A 135      21.458  71.533  13.310  1.00 15.80           C  
ATOM    974  C   ALA A 135      21.557  70.880  11.936  1.00 16.33           C  
ATOM    975  O   ALA A 135      22.625  70.373  11.578  1.00 15.69           O  
ATOM    976  CB  ALA A 135      20.816  70.584  14.326  1.00 16.32           C  
ATOM    977  N   LYS A 136      20.459  70.906  11.175  1.00 16.24           N  
ATOM    978  CA  LYS A 136      20.460  70.430   9.785  1.00 17.48           C  
ATOM    979  C   LYS A 136      21.492  71.166   8.926  1.00 17.11           C  
ATOM    980  O   LYS A 136      22.262  70.527   8.201  1.00 16.50           O  
ATOM    981  CB  LYS A 136      19.061  70.550   9.141  1.00 18.17           C  
ATOM    982  CG  LYS A 136      18.049  69.480   9.604  1.00 20.63           C  
ATOM    983  CD  LYS A 136      18.322  68.164   8.914  1.00 23.87           C  
ATOM    984  CE  LYS A 136      17.284  67.099   9.209  1.00 24.25           C  
ATOM    985  NZ  LYS A 136      17.852  65.806   8.704  1.00 24.87           N  
ATOM    986  N   GLU A 137      21.481  72.503   9.006  1.00 16.57           N  
ATOM    987  CA  GLU A 137      22.399  73.358   8.245  1.00 17.22           C  
ATOM    988  C   GLU A 137      23.840  73.047   8.614  1.00 17.02           C  
ATOM    989  O   GLU A 137      24.706  72.959   7.737  1.00 16.44           O  
ATOM    990  CB  GLU A 137      22.107  74.842   8.499  1.00 18.01           C  
ATOM    991  CG  GLU A 137      20.854  75.353   7.744  1.00 18.98           C  
ATOM    992  CD  GLU A 137      20.940  75.107   6.240  1.00 21.50           C  
ATOM    993  OE1 GLU A 137      21.927  75.543   5.594  1.00 22.80           O  
ATOM    994  OE2 GLU A 137      20.007  74.494   5.685  1.00 22.52           O  
ATOM    995  N   LEU A 138      24.094  72.859   9.910  1.00 16.43           N  
ATOM    996  CA  LEU A 138      25.449  72.513  10.353  1.00 16.83           C  
ATOM    997  C   LEU A 138      25.867  71.151   9.787  1.00 16.20           C  
ATOM    998  O   LEU A 138      27.011  70.988   9.356  1.00 16.25           O  
ATOM    999  CB  LEU A 138      25.577  72.561  11.887  1.00 16.83           C  
ATOM   1000  CG  LEU A 138      26.939  72.247  12.513  1.00 16.88           C  
ATOM   1001  CD1 LEU A 138      27.996  73.250  12.042  1.00 16.20           C  
ATOM   1002  CD2 LEU A 138      26.822  72.249  14.058  1.00 18.26           C  
ATOM   1003  N   GLY A 139      24.941  70.192   9.763  1.00 15.40           N  
ATOM   1004  CA  GLY A 139      25.245  68.866   9.184  1.00 16.07           C  
ATOM   1005  C   GLY A 139      25.622  69.007   7.716  1.00 16.01           C  
ATOM   1006  O   GLY A 139      26.623  68.441   7.268  1.00 16.42           O  
ATOM   1007  N   TYR A 140      24.840  69.788   6.965  1.00 16.22           N  
ATOM   1008  CA  TYR A 140      25.131  70.029   5.536  1.00 17.22           C  
ATOM   1009  C   TYR A 140      26.476  70.715   5.337  1.00 16.63           C  
ATOM   1010  O   TYR A 140      27.242  70.353   4.431  1.00 16.41           O  
ATOM   1011  CB  TYR A 140      24.051  70.901   4.880  1.00 18.54           C  
ATOM   1012  CG  TYR A 140      22.638  70.395   4.999  1.00 21.65           C  
ATOM   1013  CD1 TYR A 140      22.346  69.021   5.001  1.00 23.65           C  
ATOM   1014  CD2 TYR A 140      21.574  71.297   5.071  1.00 23.45           C  
ATOM   1015  CE1 TYR A 140      21.028  68.566   5.106  1.00 23.62           C  
ATOM   1016  CE2 TYR A 140      20.268  70.861   5.181  1.00 24.05           C  
ATOM   1017  CZ  TYR A 140      20.000  69.497   5.195  1.00 25.16           C  
ATOM   1018  OH  TYR A 140      18.699  69.081   5.294  1.00 25.38           O  
ATOM   1019  N   ALA A 141      26.737  71.733   6.155  1.00 16.27           N  
ATOM   1020  CA  ALA A 141      27.975  72.504   6.081  1.00 16.95           C  
ATOM   1021  C   ALA A 141      29.217  71.635   6.305  1.00 17.41           C  
ATOM   1022  O   ALA A 141      30.162  71.680   5.505  1.00 16.98           O  
ATOM   1023  CB  ALA A 141      27.932  73.679   7.063  1.00 17.32           C  
ATOM   1024  N   GLU A 142      29.209  70.821   7.362  1.00 17.98           N  
ATOM   1025  CA  GLU A 142      30.374  70.001   7.695  1.00 19.30           C  
ATOM   1026  C   GLU A 142      30.601  68.929   6.627  1.00 19.74           C  
ATOM   1027  O   GLU A 142      31.743  68.647   6.271  1.00 19.44           O  
ATOM   1028  CB  GLU A 142      30.249  69.416   9.128  1.00 18.67           C  
ATOM   1029  CG  GLU A 142      30.135  70.520  10.192  1.00 19.95           C  
ATOM   1030  CD  GLU A 142      30.010  70.013  11.630  1.00 21.65           C  
ATOM   1031  OE1 GLU A 142      29.204  69.092  11.912  1.00 25.62           O  
ATOM   1032  OE2 GLU A 142      30.715  70.580  12.485  1.00 26.09           O  
ATOM   1033  N   ARG A 143      29.515  68.359   6.102  1.00 20.42           N  
ATOM   1034  CA  ARG A 143      29.575  67.404   4.982  1.00 22.73           C  
ATOM   1035  C   ARG A 143      30.208  68.068   3.753  1.00 22.66           C  
ATOM   1036  O   ARG A 143      31.084  67.494   3.091  1.00 22.51           O  
ATOM   1037  CB  ARG A 143      28.164  66.919   4.635  1.00 22.53           C  
ATOM   1038  CG  ARG A 143      28.039  65.650   3.782  1.00 24.91           C  
ATOM   1039  CD  ARG A 143      26.565  65.147   3.780  1.00 26.57           C  
ATOM   1040  NE  ARG A 143      25.900  65.282   5.092  1.00 30.76           N  
ATOM   1041  CZ  ARG A 143      24.619  65.625   5.270  1.00 35.03           C  
ATOM   1042  NH1 ARG A 143      23.828  65.876   4.219  1.00 37.83           N  
ATOM   1043  NH2 ARG A 143      24.119  65.736   6.503  1.00 33.85           N  
ATOM   1044  N   ARG A 144      29.771  69.290   3.466  1.00 22.31           N  
ATOM   1045  CA  ARG A 144      30.243  70.013   2.281  1.00 22.77           C  
ATOM   1046  C   ARG A 144      31.745  70.300   2.355  1.00 21.55           C  
ATOM   1047  O   ARG A 144      32.438  70.248   1.341  1.00 20.82           O  
ATOM   1048  CB  ARG A 144      29.446  71.302   2.066  1.00 22.81           C  
ATOM   1049  CG  ARG A 144      29.721  71.944   0.719  1.00 25.80           C  
ATOM   1050  CD  ARG A 144      28.554  72.797   0.234  1.00 28.12           C  
ATOM   1051  NE  ARG A 144      28.951  73.552  -0.954  1.00 29.01           N  
ATOM   1052  CZ  ARG A 144      29.297  74.838  -0.932  1.00 28.61           C  
ATOM   1053  NH1 ARG A 144      29.284  75.506   0.221  1.00 29.42           N  
ATOM   1054  NH2 ARG A 144      29.673  75.451  -2.048  1.00 25.73           N  
ATOM   1055  N   THR A 145      32.248  70.571   3.554  1.00 20.76           N  
ATOM   1056  CA  THR A 145      33.686  70.790   3.734  1.00 20.78           C  
ATOM   1057  C   THR A 145      34.491  69.567   3.289  1.00 21.08           C  
ATOM   1058  O   THR A 145      35.519  69.713   2.610  1.00 21.31           O  
ATOM   1059  CB  THR A 145      34.038  71.145   5.183  1.00 20.40           C  
ATOM   1060  OG1 THR A 145      33.255  72.269   5.586  1.00 20.11           O  
ATOM   1061  CG2 THR A 145      35.528  71.495   5.320  1.00 19.66           C  
ATOM   1062  N   VAL A 146      34.025  68.377   3.668  1.00 21.65           N  
ATOM   1063  CA  VAL A 146      34.683  67.113   3.278  1.00 21.91           C  
ATOM   1064  C   VAL A 146      34.620  66.925   1.768  1.00 22.20           C  
ATOM   1065  O   VAL A 146      35.641  66.687   1.142  1.00 22.40           O  
ATOM   1066  CB  VAL A 146      34.062  65.886   3.979  1.00 22.01           C  
ATOM   1067  CG1 VAL A 146      34.724  64.569   3.498  1.00 22.61           C  
ATOM   1068  CG2 VAL A 146      34.183  66.038   5.497  1.00 22.23           C  
ATOM   1069  N   THR A 147      33.427  67.049   1.189  1.00 22.12           N  
ATOM   1070  CA  THR A 147      33.260  67.028  -0.268  1.00 22.71           C  
ATOM   1071  C   THR A 147      34.202  67.966  -1.010  1.00 21.82           C  
ATOM   1072  O   THR A 147      34.928  67.548  -1.918  1.00 22.00           O  
ATOM   1073  CB  THR A 147      31.808  67.344  -0.674  1.00 22.76           C  
ATOM   1074  OG1 THR A 147      30.994  66.243  -0.283  1.00 26.28           O  
ATOM   1075  CG2 THR A 147      31.686  67.554  -2.215  1.00 24.78           C  
ATOM   1076  N   LEU A 148      34.193  69.238  -0.628  1.00 21.03           N  
ATOM   1077  CA  LEU A 148      34.922  70.246  -1.389  1.00 20.76           C  
ATOM   1078  C   LEU A 148      36.441  70.118  -1.255  1.00 20.74           C  
ATOM   1079  O   LEU A 148      37.162  70.503  -2.160  1.00 21.19           O  
ATOM   1080  CB  LEU A 148      34.489  71.660  -0.980  1.00 20.15           C  
ATOM   1081  CG  LEU A 148      33.040  72.065  -1.237  1.00 20.88           C  
ATOM   1082  CD1 LEU A 148      32.860  73.591  -1.003  1.00 21.47           C  
ATOM   1083  CD2 LEU A 148      32.594  71.654  -2.649  1.00 20.48           C  
ATOM   1084  N   THR A 149      36.921  69.613  -0.119  1.00 20.47           N  
ATOM   1085  CA  THR A 149      38.367  69.517   0.120  1.00 19.95           C  
ATOM   1086  C   THR A 149      38.974  68.178  -0.310  1.00 21.47           C  
ATOM   1087  O   THR A 149      40.191  68.087  -0.499  1.00 22.67           O  
ATOM   1088  CB  THR A 149      38.739  69.762   1.599  1.00 20.28           C  
ATOM   1089  OG1 THR A 149      38.045  68.819   2.436  1.00 17.29           O  
ATOM   1090  CG2 THR A 149      38.412  71.188   2.030  1.00 18.93           C  
ATOM   1091  N   GLN A 150      38.148  67.147  -0.453  1.00 21.41           N  
ATOM   1092  CA  GLN A 150      38.664  65.791  -0.619  1.00 23.14           C  
ATOM   1093  C   GLN A 150      38.263  65.108  -1.920  1.00 23.66           C  
ATOM   1094  O   GLN A 150      39.015  64.278  -2.442  1.00 24.17           O  
ATOM   1095  CB  GLN A 150      38.269  64.919   0.576  1.00 22.85           C  
ATOM   1096  CG  GLN A 150      38.917  65.371   1.881  1.00 22.41           C  
ATOM   1097  CD  GLN A 150      38.851  64.325   2.968  1.00 25.45           C  
ATOM   1098  OE1 GLN A 150      38.333  63.231   2.762  1.00 23.63           O  
ATOM   1099  NE2 GLN A 150      39.350  64.670   4.151  1.00 25.71           N  
ATOM   1100  N   LYS A 151      37.093  65.445  -2.451  1.00 24.22           N  
ATOM   1101  CA  LYS A 151      36.652  64.795  -3.681  1.00 24.98           C  
ATOM   1102  C   LYS A 151      37.353  65.404  -4.883  1.00 25.61           C  
ATOM   1103  O   LYS A 151      37.744  66.565  -4.860  1.00 25.78           O  
ATOM   1104  CB  LYS A 151      35.144  64.879  -3.855  1.00 25.03           C  
ATOM   1105  CG  LYS A 151      34.377  64.053  -2.879  1.00 24.91           C  
ATOM   1106  CD  LYS A 151      33.007  63.741  -3.427  1.00 26.51           C  
ATOM   1107  CE  LYS A 151      32.280  62.788  -2.518  1.00 25.89           C  
ATOM   1108  NZ  LYS A 151      30.850  62.845  -2.837  1.00 27.46           N  
ATOM   1109  N   HIS A 152      37.525  64.606  -5.929  1.00 26.35           N  
ATOM   1110  CA  HIS A 152      38.126  65.105  -7.146  1.00 27.30           C  
ATOM   1111  C   HIS A 152      37.072  65.832  -7.983  1.00 27.18           C  
ATOM   1112  O   HIS A 152      35.893  65.838  -7.624  1.00 26.19           O  
ATOM   1113  CB  HIS A 152      38.825  63.966  -7.887  1.00 28.33           C  
ATOM   1114  CG  HIS A 152      39.984  63.396  -7.123  1.00 31.19           C  
ATOM   1115  ND1 HIS A 152      40.980  64.189  -6.584  1.00 34.59           N  
ATOM   1116  CD2 HIS A 152      40.294  62.122  -6.780  1.00 34.51           C  
ATOM   1117  CE1 HIS A 152      41.858  63.428  -5.952  1.00 34.40           C  
ATOM   1118  NE2 HIS A 152      41.462  62.171  -6.051  1.00 36.28           N  
ATOM   1119  N   VAL A 153      37.505  66.460  -9.073  1.00 27.24           N  
ATOM   1120  CA  VAL A 153      36.646  67.352  -9.870  1.00 27.75           C  
ATOM   1121  C   VAL A 153      35.331  66.709 -10.286  1.00 27.30           C  
ATOM   1122  O   VAL A 153      34.270  67.323 -10.149  1.00 27.12           O  
ATOM   1123  CB  VAL A 153      37.414  67.954 -11.070  1.00 27.88           C  
ATOM   1124  CG1 VAL A 153      36.474  68.511 -12.097  1.00 29.52           C  
ATOM   1125  CG2 VAL A 153      38.303  69.059 -10.590  1.00 28.97           C  
ATOM   1126  N   ARG A 154      35.395  65.459 -10.746  1.00 27.51           N  
ATOM   1127  CA  ARG A 154      34.203  64.718 -11.150  1.00 27.35           C  
ATOM   1128  C   ARG A 154      33.222  64.482 -10.006  1.00 27.46           C  
ATOM   1129  O   ARG A 154      32.007  64.630 -10.188  1.00 26.85           O  
ATOM   1130  CB  ARG A 154      34.583  63.379 -11.793  1.00 28.29           C  
ATOM   1131  CG  ARG A 154      35.218  63.513 -13.179  1.00 28.70           C  
ATOM   1132  CD  ARG A 154      35.792  62.179 -13.648  1.00 31.07           C  
ATOM   1133  NE  ARG A 154      34.779  61.121 -13.706  1.00 31.28           N  
ATOM   1134  CZ  ARG A 154      34.061  60.813 -14.785  1.00 32.19           C  
ATOM   1135  NH1 ARG A 154      34.225  61.470 -15.923  1.00 32.91           N  
ATOM   1136  NH2 ARG A 154      33.175  59.836 -14.728  1.00 33.50           N  
ATOM   1137  N   GLY A 155      33.745  64.103  -8.839  1.00 26.33           N  
ATOM   1138  CA  GLY A 155      32.905  63.842  -7.671  1.00 25.69           C  
ATOM   1139  C   GLY A 155      32.240  65.106  -7.151  1.00 24.88           C  
ATOM   1140  O   GLY A 155      31.034  65.112  -6.868  1.00 24.58           O  
ATOM   1141  N   ARG A 156      33.028  66.171  -7.036  1.00 24.03           N  
ATOM   1142  CA  ARG A 156      32.526  67.473  -6.574  1.00 23.76           C  
ATOM   1143  C   ARG A 156      31.378  68.004  -7.441  1.00 23.36           C  
ATOM   1144  O   ARG A 156      30.352  68.445  -6.920  1.00 22.00           O  
ATOM   1145  CB  ARG A 156      33.641  68.517  -6.531  1.00 23.60           C  
ATOM   1146  CG  ARG A 156      34.722  68.267  -5.491  1.00 24.16           C  
ATOM   1147  CD  ARG A 156      35.507  69.520  -5.230  1.00 25.31           C  
ATOM   1148  NE  ARG A 156      36.213  69.931  -6.437  1.00 29.10           N  
ATOM   1149  CZ  ARG A 156      37.286  70.711  -6.462  1.00 32.92           C  
ATOM   1150  NH1 ARG A 156      37.772  71.195  -5.328  1.00 38.51           N  
ATOM   1151  NH2 ARG A 156      37.885  71.008  -7.613  1.00 29.93           N  
ATOM   1152  N   LEU A 157      31.561  67.983  -8.761  1.00 23.41           N  
ATOM   1153  CA  LEU A 157      30.523  68.519  -9.645  1.00 23.40           C  
ATOM   1154  C   LEU A 157      29.271  67.638  -9.645  1.00 23.30           C  
ATOM   1155  O   LEU A 157      28.144  68.153  -9.593  1.00 23.41           O  
ATOM   1156  CB  LEU A 157      31.049  68.760 -11.073  1.00 23.76           C  
ATOM   1157  CG  LEU A 157      29.999  69.314 -12.048  1.00 23.32           C  
ATOM   1158  CD1 LEU A 157      29.517  70.689 -11.623  1.00 23.77           C  
ATOM   1159  CD2 LEU A 157      30.510  69.326 -13.479  1.00 24.10           C  
ATOM   1160  N   ALA A 158      29.454  66.319  -9.708  1.00 23.02           N  
ATOM   1161  CA  ALA A 158      28.323  65.391  -9.618  1.00 22.90           C  
ATOM   1162  C   ALA A 158      27.571  65.599  -8.302  1.00 23.08           C  
ATOM   1163  O   ALA A 158      26.344  65.630  -8.276  1.00 23.00           O  
ATOM   1164  CB  ALA A 158      28.796  63.945  -9.749  1.00 22.92           C  
ATOM   1165  N   GLU A 159      28.307  65.772  -7.209  1.00 23.16           N  
ATOM   1166  CA  GLU A 159      27.654  65.998  -5.919  1.00 23.41           C  
ATOM   1167  C   GLU A 159      26.808  67.279  -5.958  1.00 21.97           C  
ATOM   1168  O   GLU A 159      25.641  67.263  -5.578  1.00 21.53           O  
ATOM   1169  CB  GLU A 159      28.677  66.076  -4.795  1.00 23.96           C  
ATOM   1170  CG  GLU A 159      28.066  66.598  -3.513  1.00 28.43           C  
ATOM   1171  CD  GLU A 159      28.457  65.804  -2.288  1.00 32.96           C  
ATOM   1172  OE1 GLU A 159      29.182  64.789  -2.419  1.00 35.48           O  
ATOM   1173  OE2 GLU A 159      28.020  66.201  -1.188  1.00 34.75           O  
ATOM   1174  N   THR A 160      27.408  68.369  -6.428  1.00 21.02           N  
ATOM   1175  CA  THR A 160      26.702  69.653  -6.612  1.00 20.49           C  
ATOM   1176  C   THR A 160      25.399  69.474  -7.393  1.00 19.84           C  
ATOM   1177  O   THR A 160      24.344  69.916  -6.936  1.00 19.07           O  
ATOM   1178  CB  THR A 160      27.602  70.699  -7.307  1.00 20.20           C  
ATOM   1179  OG1 THR A 160      28.626  71.108  -6.392  1.00 21.93           O  
ATOM   1180  CG2 THR A 160      26.793  71.928  -7.743  1.00 20.15           C  
ATOM   1181  N   LEU A 161      25.478  68.831  -8.561  1.00 19.43           N  
ATOM   1182  CA  LEU A 161      24.298  68.605  -9.404  1.00 19.38           C  
ATOM   1183  C   LEU A 161      23.213  67.777  -8.678  1.00 19.56           C  
ATOM   1184  O   LEU A 161      22.017  68.076  -8.770  1.00 18.61           O  
ATOM   1185  CB  LEU A 161      24.704  67.961 -10.745  1.00 19.92           C  
ATOM   1186  CG  LEU A 161      25.601  68.838 -11.648  1.00 19.77           C  
ATOM   1187  CD1 LEU A 161      26.098  68.048 -12.851  1.00 20.59           C  
ATOM   1188  CD2 LEU A 161      24.886  70.109 -12.101  1.00 17.79           C  
ATOM   1189  N   LEU A 162      23.621  66.753  -7.939  1.00 19.92           N  
ATOM   1190  CA  LEU A 162      22.633  65.938  -7.195  1.00 20.26           C  
ATOM   1191  C   LEU A 162      21.999  66.717  -6.035  1.00 20.07           C  
ATOM   1192  O   LEU A 162      20.822  66.515  -5.715  1.00 20.21           O  
ATOM   1193  CB  LEU A 162      23.253  64.626  -6.710  1.00 20.93           C  
ATOM   1194  CG  LEU A 162      23.640  63.648  -7.840  1.00 22.88           C  
ATOM   1195  CD1 LEU A 162      24.520  62.546  -7.300  1.00 22.47           C  
ATOM   1196  CD2 LEU A 162      22.413  63.086  -8.583  1.00 24.13           C  
ATOM   1197  N   ILE A 163      22.765  67.628  -5.433  1.00 19.76           N  
ATOM   1198  CA  ILE A 163      22.216  68.524  -4.397  1.00 19.60           C  
ATOM   1199  C   ILE A 163      21.158  69.490  -4.956  1.00 19.50           C  
ATOM   1200  O   ILE A 163      20.144  69.759  -4.298  1.00 19.28           O  
ATOM   1201  CB  ILE A 163      23.316  69.292  -3.625  1.00 19.77           C  
ATOM   1202  CG1 ILE A 163      24.088  68.322  -2.709  1.00 19.77           C  
ATOM   1203  CG2 ILE A 163      22.700  70.423  -2.756  1.00 19.57           C  
ATOM   1204  CD1 ILE A 163      25.441  68.852  -2.231  1.00 19.61           C  
ATOM   1205  N   LEU A 164      21.409  70.005  -6.156  1.00 19.16           N  
ATOM   1206  CA  LEU A 164      20.445  70.883  -6.841  1.00 19.43           C  
ATOM   1207  C   LEU A 164      19.204  70.078  -7.197  1.00 20.06           C  
ATOM   1208  O   LEU A 164      18.083  70.550  -6.983  1.00 19.93           O  
ATOM   1209  CB  LEU A 164      21.075  71.522  -8.082  1.00 19.27           C  
ATOM   1210  CG  LEU A 164      22.258  72.461  -7.792  1.00 19.58           C  
ATOM   1211  CD1 LEU A 164      22.932  72.887  -9.113  1.00 20.11           C  
ATOM   1212  CD2 LEU A 164      21.815  73.678  -6.963  1.00 18.34           C  
ATOM   1213  N   LYS A 165      19.408  68.854  -7.693  1.00 19.91           N  
ATOM   1214  CA  LYS A 165      18.301  67.927  -7.978  1.00 21.69           C  
ATOM   1215  C   LYS A 165      17.439  67.752  -6.728  1.00 21.62           C  
ATOM   1216  O   LYS A 165      16.210  67.907  -6.776  1.00 21.52           O  
ATOM   1217  CB  LYS A 165      18.824  66.565  -8.452  1.00 21.77           C  
ATOM   1218  CG  LYS A 165      17.721  65.503  -8.685  1.00 24.12           C  
ATOM   1219  CD  LYS A 165      18.334  64.127  -8.996  1.00 25.41           C  
ATOM   1220  CE  LYS A 165      18.361  63.228  -7.778  1.00 31.95           C  
ATOM   1221  NZ  LYS A 165      17.030  62.527  -7.632  1.00 34.99           N  
ATOM   1222  N   GLU A 166      18.093  67.466  -5.605  1.00 21.88           N  
ATOM   1223  CA  GLU A 166      17.372  67.247  -4.357  1.00 22.29           C  
ATOM   1224  C   GLU A 166      16.600  68.492  -3.905  1.00 21.38           C  
ATOM   1225  O   GLU A 166      15.431  68.382  -3.547  1.00 21.58           O  
ATOM   1226  CB  GLU A 166      18.331  66.740  -3.268  1.00 23.14           C  
ATOM   1227  CG  GLU A 166      17.694  66.531  -1.893  1.00 27.68           C  
ATOM   1228  CD  GLU A 166      16.614  65.438  -1.865  1.00 32.59           C  
ATOM   1229  OE1 GLU A 166      16.694  64.466  -2.650  1.00 35.63           O  
ATOM   1230  OE2 GLU A 166      15.698  65.543  -1.020  1.00 35.16           O  
ATOM   1231  N   ASN A 167      17.236  69.663  -3.945  1.00 20.29           N  
ATOM   1232  CA  ASN A 167      16.659  70.885  -3.389  1.00 20.64           C  
ATOM   1233  C   ASN A 167      15.662  71.588  -4.297  1.00 20.86           C  
ATOM   1234  O   ASN A 167      14.740  72.254  -3.808  1.00 20.89           O  
ATOM   1235  CB  ASN A 167      17.769  71.867  -2.995  1.00 20.36           C  
ATOM   1236  CG  ASN A 167      18.644  71.343  -1.860  1.00 22.35           C  
ATOM   1237  OD1 ASN A 167      18.268  70.396  -1.157  1.00 23.68           O  
ATOM   1238  ND2 ASN A 167      19.820  71.955  -1.676  1.00 22.34           N  
ATOM   1239  N   PHE A 168      15.844  71.448  -5.616  1.00 20.42           N  
ATOM   1240  CA  PHE A 168      15.024  72.176  -6.594  1.00 20.78           C  
ATOM   1241  C   PHE A 168      14.243  71.305  -7.582  1.00 21.07           C  
ATOM   1242  O   PHE A 168      13.276  71.775  -8.179  1.00 21.47           O  
ATOM   1243  CB  PHE A 168      15.854  73.264  -7.297  1.00 20.77           C  
ATOM   1244  CG  PHE A 168      16.526  74.191  -6.335  1.00 20.77           C  
ATOM   1245  CD1 PHE A 168      15.805  75.223  -5.728  1.00 21.75           C  
ATOM   1246  CD2 PHE A 168      17.859  73.992  -5.976  1.00 21.03           C  
ATOM   1247  CE1 PHE A 168      16.416  76.060  -4.785  1.00 23.40           C  
ATOM   1248  CE2 PHE A 168      18.483  74.834  -5.036  1.00 21.08           C  
ATOM   1249  CZ  PHE A 168      17.750  75.861  -4.448  1.00 21.61           C  
ATOM   1250  N   GLY A 169      14.646  70.048  -7.728  1.00 21.32           N  
ATOM   1251  CA  GLY A 169      13.856  69.071  -8.464  1.00 22.54           C  
ATOM   1252  C   GLY A 169      13.960  69.218  -9.970  1.00 23.76           C  
ATOM   1253  O   GLY A 169      14.909  69.825 -10.486  1.00 22.77           O  
ATOM   1254  N   PHE A 170      12.987  68.640 -10.670  1.00 24.69           N  
ATOM   1255  CA  PHE A 170      12.996  68.582 -12.136  1.00 26.08           C  
ATOM   1256  C   PHE A 170      11.850  69.389 -12.736  1.00 26.83           C  
ATOM   1257  O   PHE A 170      10.830  69.637 -12.070  1.00 26.12           O  
ATOM   1258  CB  PHE A 170      12.860  67.136 -12.624  1.00 26.42           C  
ATOM   1259  CG  PHE A 170      14.043  66.270 -12.343  1.00 27.23           C  
ATOM   1260  CD1 PHE A 170      15.295  66.576 -12.861  1.00 27.94           C  
ATOM   1261  CD2 PHE A 170      13.894  65.111 -11.597  1.00 28.14           C  
ATOM   1262  CE1 PHE A 170      16.398  65.749 -12.611  1.00 28.58           C  
ATOM   1263  CE2 PHE A 170      14.991  64.275 -11.341  1.00 28.53           C  
ATOM   1264  CZ  PHE A 170      16.241  64.599 -11.857  1.00 27.88           C  
ATOM   1265  N   GLU A 171      12.027  69.777 -14.000  1.00 28.15           N  
ATOM   1266  CA  GLU A 171      10.955  70.344 -14.823  1.00 29.78           C  
ATOM   1267  C   GLU A 171       9.977  69.230 -15.211  1.00 29.86           C  
ATOM   1268  O   GLU A 171      10.151  68.083 -14.808  1.00 29.60           O  
ATOM   1269  CB  GLU A 171      11.530  71.009 -16.101  1.00 30.00           C  
ATOM   1270  CG  GLU A 171      12.437  72.232 -15.872  1.00 32.81           C  
ATOM   1271  CD  GLU A 171      11.737  73.439 -15.216  1.00 37.24           C  
ATOM   1272  OE1 GLU A 171      10.500  73.423 -15.033  1.00 37.38           O  
ATOM   1273  OE2 GLU A 171      12.439  74.429 -14.880  1.00 39.15           O  
ATOM   1274  N   ASN A 172       8.965  69.565 -16.013  1.00 31.35           N  
ATOM   1275  CA  ASN A 172       7.946  68.584 -16.428  1.00 32.41           C  
ATOM   1276  C   ASN A 172       8.515  67.331 -17.091  1.00 32.28           C  
ATOM   1277  O   ASN A 172       7.931  66.260 -16.983  1.00 32.49           O  
ATOM   1278  CB  ASN A 172       6.875  69.221 -17.326  1.00 33.12           C  
ATOM   1279  CG  ASN A 172       6.071  70.301 -16.611  1.00 35.98           C  
ATOM   1280  OD1 ASN A 172       5.880  70.255 -15.388  1.00 39.17           O  
ATOM   1281  ND2 ASN A 172       5.597  71.288 -17.375  1.00 37.93           N  
ATOM   1282  N   ASP A 173       9.660  67.459 -17.765  1.00 31.91           N  
ATOM   1283  CA  ASP A 173      10.292  66.313 -18.412  1.00 31.23           C  
ATOM   1284  C   ASP A 173      10.902  65.329 -17.421  1.00 30.57           C  
ATOM   1285  O   ASP A 173      11.320  64.236 -17.797  1.00 30.70           O  
ATOM   1286  CB  ASP A 173      11.330  66.759 -19.453  1.00 31.61           C  
ATOM   1287  CG  ASP A 173      12.583  67.385 -18.830  1.00 32.88           C  
ATOM   1288  OD1 ASP A 173      12.691  67.506 -17.584  1.00 32.71           O  
ATOM   1289  OD2 ASP A 173      13.473  67.770 -19.616  1.00 34.33           O  
ATOM   1290  N   GLY A 174      10.966  65.713 -16.151  1.00 29.60           N  
ATOM   1291  CA  GLY A 174      11.458  64.804 -15.123  1.00 28.70           C  
ATOM   1292  C   GLY A 174      12.946  64.514 -15.196  1.00 28.06           C  
ATOM   1293  O   GLY A 174      13.410  63.526 -14.628  1.00 27.62           O  
ATOM   1294  N   ALA A 175      13.694  65.374 -15.893  1.00 27.48           N  
ATOM   1295  CA  ALA A 175      15.134  65.169 -16.082  1.00 26.79           C  
ATOM   1296  C   ALA A 175      15.946  66.469 -16.087  1.00 26.41           C  
ATOM   1297  O   ALA A 175      17.131  66.470 -15.723  1.00 26.23           O  
ATOM   1298  CB  ALA A 175      15.403  64.351 -17.367  1.00 27.25           C  
ATOM   1299  N   THR A 176      15.308  67.563 -16.488  1.00 25.44           N  
ATOM   1300  CA  THR A 176      15.966  68.869 -16.554  1.00 25.53           C  
ATOM   1301  C   THR A 176      15.853  69.545 -15.201  1.00 24.92           C  
ATOM   1302  O   THR A 176      14.744  69.726 -14.701  1.00 24.12           O  
ATOM   1303  CB  THR A 176      15.314  69.759 -17.635  1.00 25.85           C  
ATOM   1304  OG1 THR A 176      15.498  69.149 -18.920  1.00 26.93           O  
ATOM   1305  CG2 THR A 176      15.908  71.172 -17.645  1.00 25.65           C  
ATOM   1306  N   LEU A 177      17.000  69.913 -14.620  1.00 24.31           N  
ATOM   1307  CA  LEU A 177      17.027  70.610 -13.331  1.00 24.47           C  
ATOM   1308  C   LEU A 177      16.248  71.929 -13.396  1.00 24.14           C  
ATOM   1309  O   LEU A 177      16.393  72.692 -14.364  1.00 23.87           O  
ATOM   1310  CB  LEU A 177      18.475  70.865 -12.885  1.00 24.22           C  
ATOM   1311  CG  LEU A 177      19.351  69.655 -12.528  1.00 24.17           C  
ATOM   1312  CD1 LEU A 177      20.748  70.088 -12.103  1.00 23.71           C  
ATOM   1313  CD2 LEU A 177      18.707  68.800 -11.429  1.00 24.14           C  
ATOM   1314  N   SER A 178      15.424  72.179 -12.372  1.00 23.81           N  
ATOM   1315  CA  SER A 178      14.589  73.388 -12.276  1.00 24.18           C  
ATOM   1316  C   SER A 178      15.331  74.605 -11.732  1.00 23.93           C  
ATOM   1317  O   SER A 178      14.714  75.556 -11.258  1.00 24.92           O  
ATOM   1318  CB  SER A 178      13.365  73.141 -11.384  1.00 24.29           C  
ATOM   1319  OG  SER A 178      12.479  72.215 -11.989  1.00 27.86           O  
ATOM   1320  N   ILE A 179      16.650  74.580 -11.785  1.00 22.78           N  
ATOM   1321  CA  ILE A 179      17.430  75.752 -11.420  1.00 22.19           C  
ATOM   1322  C   ILE A 179      18.428  75.987 -12.541  1.00 22.83           C  
ATOM   1323  O   ILE A 179      18.924  75.026 -13.126  1.00 22.50           O  
ATOM   1324  CB  ILE A 179      18.123  75.540 -10.059  1.00 21.63           C  
ATOM   1325  CG1 ILE A 179      18.854  76.805  -9.601  1.00 20.98           C  
ATOM   1326  CG2 ILE A 179      19.001  74.281 -10.085  1.00 20.92           C  
ATOM   1327  CD1 ILE A 179      19.184  76.782  -8.091  1.00 20.64           C  
ATOM   1328  N   TYR A 180      18.715  77.256 -12.824  1.00 23.59           N  
ATOM   1329  CA  TYR A 180      19.467  77.635 -14.015  1.00 24.11           C  
ATOM   1330  C   TYR A 180      20.640  78.540 -13.648  1.00 24.40           C  
ATOM   1331  O   TYR A 180      20.666  79.721 -13.973  1.00 25.05           O  
ATOM   1332  CB  TYR A 180      18.517  78.270 -15.063  1.00 25.12           C  
ATOM   1333  CG  TYR A 180      17.323  77.376 -15.374  1.00 24.70           C  
ATOM   1334  CD1 TYR A 180      17.468  76.273 -16.199  1.00 26.09           C  
ATOM   1335  CD2 TYR A 180      16.063  77.626 -14.816  1.00 25.94           C  
ATOM   1336  CE1 TYR A 180      16.408  75.439 -16.476  1.00 26.87           C  
ATOM   1337  CE2 TYR A 180      14.975  76.790 -15.096  1.00 26.34           C  
ATOM   1338  CZ  TYR A 180      15.167  75.698 -15.930  1.00 27.91           C  
ATOM   1339  OH  TYR A 180      14.129  74.838 -16.238  1.00 29.40           O  
ATOM   1340  N   LEU A 181      21.605  77.965 -12.943  1.00 24.16           N  
ATOM   1341  CA  LEU A 181      22.799  78.690 -12.531  1.00 24.45           C  
ATOM   1342  C   LEU A 181      23.750  78.936 -13.703  1.00 24.58           C  
ATOM   1343  O   LEU A 181      23.792  78.158 -14.670  1.00 24.01           O  
ATOM   1344  CB  LEU A 181      23.524  77.914 -11.415  1.00 24.58           C  
ATOM   1345  CG  LEU A 181      22.719  77.632 -10.141  1.00 24.15           C  
ATOM   1346  CD1 LEU A 181      23.595  76.957  -9.115  1.00 24.06           C  
ATOM   1347  CD2 LEU A 181      22.078  78.907  -9.555  1.00 24.38           C  
ATOM   1348  N   SER A 182      24.508  80.025 -13.609  1.00 25.05           N  
ATOM   1349  CA  SER A 182      25.577  80.301 -14.549  1.00 25.60           C  
ATOM   1350  C   SER A 182      26.681  79.283 -14.319  1.00 26.03           C  
ATOM   1351  O   SER A 182      26.713  78.616 -13.270  1.00 25.58           O  
ATOM   1352  CB  SER A 182      26.121  81.719 -14.350  1.00 26.12           C  
ATOM   1353  OG  SER A 182      26.764  81.859 -13.094  1.00 26.15           O  
ATOM   1354  N   ARG A 183      27.590  79.168 -15.286  1.00 25.65           N  
ATOM   1355  CA  ARG A 183      28.757  78.297 -15.146  1.00 25.98           C  
ATOM   1356  C   ARG A 183      29.608  78.713 -13.948  1.00 25.76           C  
ATOM   1357  O   ARG A 183      30.188  77.860 -13.253  1.00 25.60           O  
ATOM   1358  CB  ARG A 183      29.607  78.309 -16.426  1.00 26.37           C  
ATOM   1359  CG  ARG A 183      28.944  77.653 -17.640  1.00 27.24           C  
ATOM   1360  CD  ARG A 183      28.389  76.277 -17.308  1.00 27.59           C  
ATOM   1361  NE  ARG A 183      28.011  75.522 -18.498  1.00 29.53           N  
ATOM   1362  CZ  ARG A 183      26.790  75.059 -18.743  1.00 29.30           C  
ATOM   1363  NH1 ARG A 183      25.812  75.258 -17.870  1.00 30.22           N  
ATOM   1364  NH2 ARG A 183      26.551  74.376 -19.856  1.00 29.10           N  
ATOM   1365  N   GLU A 184      29.652  80.021 -13.712  1.00 25.58           N  
ATOM   1366  CA  GLU A 184      30.410  80.627 -12.621  1.00 25.48           C  
ATOM   1367  C   GLU A 184      29.850  80.227 -11.251  1.00 25.13           C  
ATOM   1368  O   GLU A 184      30.600  79.886 -10.336  1.00 24.82           O  
ATOM   1369  CB  GLU A 184      30.419  82.150 -12.787  1.00 26.25           C  
ATOM   1370  CG  GLU A 184      31.415  82.657 -13.877  1.00 28.17           C  
ATOM   1371  CD  GLU A 184      30.907  82.550 -15.329  1.00 31.58           C  
ATOM   1372  OE1 GLU A 184      29.691  82.284 -15.557  1.00 30.70           O  
ATOM   1373  OE2 GLU A 184      31.742  82.767 -16.252  1.00 30.20           O  
ATOM   1374  N   GLU A 185      28.531  80.273 -11.125  1.00 24.08           N  
ATOM   1375  CA  GLU A 185      27.856  79.818  -9.924  1.00 23.93           C  
ATOM   1376  C   GLU A 185      28.063  78.323  -9.684  1.00 23.76           C  
ATOM   1377  O   GLU A 185      28.334  77.906  -8.552  1.00 22.81           O  
ATOM   1378  CB  GLU A 185      26.374  80.162  -9.993  1.00 23.99           C  
ATOM   1379  CG  GLU A 185      26.105  81.640  -9.789  1.00 24.86           C  
ATOM   1380  CD  GLU A 185      24.702  82.043 -10.193  1.00 25.37           C  
ATOM   1381  OE1 GLU A 185      24.141  81.420 -11.123  1.00 27.03           O  
ATOM   1382  OE2 GLU A 185      24.168  82.989  -9.586  1.00 24.29           O  
ATOM   1383  N   LEU A 186      27.940  77.523 -10.744  1.00 22.89           N  
ATOM   1384  CA  LEU A 186      28.131  76.082 -10.629  1.00 23.28           C  
ATOM   1385  C   LEU A 186      29.568  75.747 -10.250  1.00 23.22           C  
ATOM   1386  O   LEU A 186      29.804  74.862  -9.425  1.00 22.67           O  
ATOM   1387  CB  LEU A 186      27.758  75.359 -11.924  1.00 23.76           C  
ATOM   1388  CG  LEU A 186      26.274  75.245 -12.235  1.00 26.16           C  
ATOM   1389  CD1 LEU A 186      26.060  75.021 -13.752  1.00 29.78           C  
ATOM   1390  CD2 LEU A 186      25.649  74.114 -11.401  1.00 28.82           C  
ATOM   1391  N   ALA A 187      30.524  76.452 -10.854  1.00 22.62           N  
ATOM   1392  CA  ALA A 187      31.942  76.280 -10.529  1.00 22.90           C  
ATOM   1393  C   ALA A 187      32.240  76.646  -9.076  1.00 23.09           C  
ATOM   1394  O   ALA A 187      32.860  75.862  -8.354  1.00 23.19           O  
ATOM   1395  CB  ALA A 187      32.817  77.093 -11.495  1.00 22.98           C  
ATOM   1396  N   THR A 188      31.781  77.820  -8.646  1.00 23.35           N  
ATOM   1397  CA  THR A 188      32.038  78.310  -7.286  1.00 24.69           C  
ATOM   1398  C   THR A 188      31.434  77.344  -6.250  1.00 24.59           C  
ATOM   1399  O   THR A 188      32.093  76.945  -5.275  1.00 25.21           O  
ATOM   1400  CB  THR A 188      31.471  79.738  -7.085  1.00 24.69           C  
ATOM   1401  OG1 THR A 188      32.127  80.646  -7.992  1.00 26.23           O  
ATOM   1402  CG2 THR A 188      31.683  80.224  -5.643  1.00 26.06           C  
ATOM   1403  N   LEU A 189      30.182  76.966  -6.481  1.00 24.02           N  
ATOM   1404  CA  LEU A 189      29.466  76.030  -5.609  1.00 24.36           C  
ATOM   1405  C   LEU A 189      30.246  74.726  -5.407  1.00 24.35           C  
ATOM   1406  O   LEU A 189      30.223  74.131  -4.315  1.00 24.50           O  
ATOM   1407  CB  LEU A 189      28.105  75.728  -6.235  1.00 23.43           C  
ATOM   1408  CG  LEU A 189      26.846  75.384  -5.449  1.00 26.24           C  
ATOM   1409  CD1 LEU A 189      26.667  76.171  -4.142  1.00 23.14           C  
ATOM   1410  CD2 LEU A 189      25.635  75.582  -6.394  1.00 25.02           C  
ATOM   1411  N   SER A 190      30.960  74.307  -6.447  1.00 23.57           N  
ATOM   1412  CA  SER A 190      31.628  73.019  -6.459  1.00 24.24           C  
ATOM   1413  C   SER A 190      33.158  73.097  -6.281  1.00 23.13           C  
ATOM   1414  O   SER A 190      33.863  72.112  -6.490  1.00 23.18           O  
ATOM   1415  CB  SER A 190      31.241  72.273  -7.741  1.00 24.67           C  
ATOM   1416  OG  SER A 190      31.947  72.824  -8.830  1.00 28.62           O  
ATOM   1417  N   ASN A 191      33.650  74.264  -5.872  1.00 22.95           N  
ATOM   1418  CA  ASN A 191      35.068  74.502  -5.584  1.00 22.60           C  
ATOM   1419  C   ASN A 191      35.970  74.161  -6.772  1.00 22.54           C  
ATOM   1420  O   ASN A 191      36.924  73.393  -6.634  1.00 21.43           O  
ATOM   1421  CB  ASN A 191      35.540  73.739  -4.323  1.00 22.18           C  
ATOM   1422  CG  ASN A 191      36.985  74.067  -3.941  1.00 22.91           C  
ATOM   1423  OD1 ASN A 191      37.476  75.169  -4.196  1.00 22.33           O  
ATOM   1424  ND2 ASN A 191      37.671  73.107  -3.325  1.00 24.39           N  
ATOM   1425  N   MET A 192      35.647  74.709  -7.941  1.00 22.79           N  
ATOM   1426  CA  MET A 192      36.517  74.556  -9.110  1.00 23.05           C  
ATOM   1427  C   MET A 192      36.516  75.798  -9.980  1.00 24.56           C  
ATOM   1428  O   MET A 192      35.708  76.706  -9.776  1.00 24.36           O  
ATOM   1429  CB  MET A 192      36.182  73.286  -9.920  1.00 23.10           C  
ATOM   1430  CG  MET A 192      34.794  73.224 -10.587  1.00 22.72           C  
ATOM   1431  SD  MET A 192      34.454  71.652 -11.390  1.00 19.57           S  
ATOM   1432  CE  MET A 192      34.322  70.582  -9.939  1.00 25.71           C  
ATOM   1433  N   THR A 193      37.459  75.846 -10.921  1.00 25.84           N  
ATOM   1434  CA  THR A 193      37.501  76.913 -11.908  1.00 26.86           C  
ATOM   1435  C   THR A 193      36.377  76.668 -12.910  1.00 26.99           C  
ATOM   1436  O   THR A 193      35.952  75.527 -13.122  1.00 26.27           O  
ATOM   1437  CB  THR A 193      38.853  76.953 -12.676  1.00 26.72           C  
ATOM   1438  OG1 THR A 193      39.151  75.650 -13.188  1.00 27.18           O  
ATOM   1439  CG2 THR A 193      40.003  77.413 -11.769  1.00 28.17           C  
ATOM   1440  N   VAL A 194      35.886  77.748 -13.510  1.00 27.89           N  
ATOM   1441  CA  VAL A 194      34.911  77.636 -14.594  1.00 28.70           C  
ATOM   1442  C   VAL A 194      35.450  76.727 -15.706  1.00 29.22           C  
ATOM   1443  O   VAL A 194      34.704  75.883 -16.230  1.00 29.25           O  
ATOM   1444  CB  VAL A 194      34.462  79.022 -15.108  1.00 28.93           C  
ATOM   1445  CG1 VAL A 194      33.524  78.890 -16.311  1.00 29.26           C  
ATOM   1446  CG2 VAL A 194      33.780  79.782 -13.990  1.00 29.31           C  
ATOM   1447  N   SER A 195      36.747  76.846 -16.030  1.00 29.66           N  
ATOM   1448  CA  SER A 195      37.380  75.951 -17.016  1.00 29.97           C  
ATOM   1449  C   SER A 195      37.190  74.497 -16.640  1.00 29.75           C  
ATOM   1450  O   SER A 195      36.787  73.674 -17.468  1.00 29.66           O  
ATOM   1451  CB  SER A 195      38.889  76.220 -17.174  1.00 30.64           C  
ATOM   1452  OG  SER A 195      39.523  75.107 -17.815  1.00 32.63           O  
ATOM   1453  N   ASN A 196      37.481  74.172 -15.382  1.00 29.45           N  
ATOM   1454  CA  ASN A 196      37.295  72.803 -14.928  1.00 28.75           C  
ATOM   1455  C   ASN A 196      35.845  72.364 -14.938  1.00 27.62           C  
ATOM   1456  O   ASN A 196      35.564  71.220 -15.234  1.00 27.69           O  
ATOM   1457  CB  ASN A 196      37.947  72.576 -13.568  1.00 29.58           C  
ATOM   1458  CG  ASN A 196      39.373  72.082 -13.693  1.00 31.45           C  
ATOM   1459  OD1 ASN A 196      39.657  71.137 -14.444  1.00 35.05           O  
ATOM   1460  ND2 ASN A 196      40.275  72.716 -12.965  1.00 33.99           N  
ATOM   1461  N   ALA A 197      34.934  73.280 -14.617  1.00 27.25           N  
ATOM   1462  CA  ALA A 197      33.495  72.972 -14.606  1.00 26.75           C  
ATOM   1463  C   ALA A 197      33.019  72.641 -16.016  1.00 26.43           C  
ATOM   1464  O   ALA A 197      32.378  71.605 -16.244  1.00 25.77           O  
ATOM   1465  CB  ALA A 197      32.715  74.136 -14.046  1.00 26.38           C  
ATOM   1466  N   ILE A 198      33.351  73.518 -16.963  1.00 26.29           N  
ATOM   1467  CA  ILE A 198      32.915  73.327 -18.347  1.00 27.31           C  
ATOM   1468  C   ILE A 198      33.590  72.110 -18.971  1.00 27.12           C  
ATOM   1469  O   ILE A 198      32.959  71.348 -19.687  1.00 27.48           O  
ATOM   1470  CB  ILE A 198      32.985  74.636 -19.225  1.00 26.87           C  
ATOM   1471  CG1 ILE A 198      34.421  75.139 -19.407  1.00 27.23           C  
ATOM   1472  CG2 ILE A 198      32.090  75.717 -18.621  1.00 27.59           C  
ATOM   1473  CD1 ILE A 198      34.525  76.381 -20.262  1.00 27.57           C  
ATOM   1474  N   ARG A 199      34.851  71.900 -18.620  1.00 28.11           N  
ATOM   1475  CA  ARG A 199      35.592  70.698 -18.996  1.00 28.31           C  
ATOM   1476  C   ARG A 199      34.885  69.442 -18.470  1.00 28.40           C  
ATOM   1477  O   ARG A 199      34.659  68.492 -19.227  1.00 28.25           O  
ATOM   1478  CB  ARG A 199      37.023  70.800 -18.443  1.00 28.74           C  
ATOM   1479  CG  ARG A 199      38.068  69.976 -19.134  1.00 28.25           C  
ATOM   1480  CD  ARG A 199      39.426  70.175 -18.475  1.00 28.68           C  
ATOM   1481  NE  ARG A 199      40.122  71.405 -18.874  1.00 29.86           N  
ATOM   1482  CZ  ARG A 199      40.825  71.544 -20.000  1.00 29.80           C  
ATOM   1483  NH1 ARG A 199      40.902  70.543 -20.874  1.00 31.04           N  
ATOM   1484  NH2 ARG A 199      41.435  72.693 -20.268  1.00 29.72           N  
ATOM   1485  N   THR A 200      34.505  69.448 -17.187  1.00 27.76           N  
ATOM   1486  CA  THR A 200      33.844  68.286 -16.567  1.00 28.09           C  
ATOM   1487  C   THR A 200      32.428  68.053 -17.094  1.00 27.99           C  
ATOM   1488  O   THR A 200      32.052  66.913 -17.320  1.00 28.02           O  
ATOM   1489  CB  THR A 200      33.818  68.389 -15.018  1.00 27.63           C  
ATOM   1490  OG1 THR A 200      35.140  68.642 -14.551  1.00 28.52           O  
ATOM   1491  CG2 THR A 200      33.304  67.094 -14.381  1.00 28.10           C  
ATOM   1492  N   LEU A 201      31.650  69.129 -17.275  1.00 28.44           N  
ATOM   1493  CA  LEU A 201      30.328  69.024 -17.904  1.00 29.32           C  
ATOM   1494  C   LEU A 201      30.428  68.394 -19.306  1.00 30.20           C  
ATOM   1495  O   LEU A 201      29.674  67.489 -19.642  1.00 29.80           O  
ATOM   1496  CB  LEU A 201      29.650  70.403 -18.010  1.00 28.98           C  
ATOM   1497  CG  LEU A 201      29.070  71.043 -16.742  1.00 28.24           C  
ATOM   1498  CD1 LEU A 201      28.692  72.500 -16.989  1.00 25.56           C  
ATOM   1499  CD2 LEU A 201      27.875  70.251 -16.239  1.00 26.99           C  
ATOM   1500  N   SER A 202      31.361  68.902 -20.109  1.00 31.94           N  
ATOM   1501  CA  SER A 202      31.656  68.351 -21.434  1.00 33.59           C  
ATOM   1502  C   SER A 202      31.847  66.830 -21.379  1.00 33.88           C  
ATOM   1503  O   SER A 202      31.207  66.101 -22.128  1.00 34.43           O  
ATOM   1504  CB  SER A 202      32.886  69.040 -22.025  1.00 33.88           C  
ATOM   1505  OG  SER A 202      33.087  68.644 -23.370  1.00 36.73           O  
ATOM   1506  N   THR A 203      32.692  66.359 -20.460  1.00 34.53           N  
ATOM   1507  CA  THR A 203      32.910  64.926 -20.243  1.00 34.67           C  
ATOM   1508  C   THR A 203      31.649  64.184 -19.790  1.00 35.14           C  
ATOM   1509  O   THR A 203      31.383  63.056 -20.229  1.00 35.00           O  
ATOM   1510  CB  THR A 203      34.065  64.682 -19.240  1.00 35.05           C  
ATOM   1511  OG1 THR A 203      35.283  65.203 -19.785  1.00 34.57           O  
ATOM   1512  CG2 THR A 203      34.247  63.190 -18.943  1.00 35.36           C  
ATOM   1513  N   PHE A 204      30.866  64.804 -18.909  1.00 35.04           N  
ATOM   1514  CA  PHE A 204      29.623  64.174 -18.463  1.00 35.65           C  
ATOM   1515  C   PHE A 204      28.632  63.980 -19.633  1.00 35.90           C  
ATOM   1516  O   PHE A 204      27.923  62.985 -19.676  1.00 35.79           O  
ATOM   1517  CB  PHE A 204      28.971  64.958 -17.308  1.00 35.22           C  
ATOM   1518  CG  PHE A 204      29.678  64.816 -15.971  1.00 35.10           C  
ATOM   1519  CD1 PHE A 204      30.734  63.912 -15.790  1.00 34.51           C  
ATOM   1520  CD2 PHE A 204      29.250  65.572 -14.873  1.00 35.05           C  
ATOM   1521  CE1 PHE A 204      31.380  63.788 -14.548  1.00 35.35           C  
ATOM   1522  CE2 PHE A 204      29.877  65.454 -13.615  1.00 34.72           C  
ATOM   1523  CZ  PHE A 204      30.945  64.558 -13.449  1.00 35.16           C  
ATOM   1524  N   VAL A 205      28.592  64.935 -20.565  1.00 36.72           N  
ATOM   1525  CA  VAL A 205      27.808  64.793 -21.805  1.00 37.72           C  
ATOM   1526  C   VAL A 205      28.370  63.683 -22.708  1.00 38.59           C  
ATOM   1527  O   VAL A 205      27.612  62.829 -23.175  1.00 39.20           O  
ATOM   1528  CB  VAL A 205      27.710  66.121 -22.608  1.00 37.68           C  
ATOM   1529  CG1 VAL A 205      26.919  65.920 -23.900  1.00 37.37           C  
ATOM   1530  CG2 VAL A 205      27.063  67.210 -21.773  1.00 37.45           C  
ATOM   1531  N   SER A 206      29.688  63.694 -22.936  1.00 39.50           N  
ATOM   1532  CA  SER A 206      30.371  62.627 -23.692  1.00 40.36           C  
ATOM   1533  C   SER A 206      30.028  61.252 -23.143  1.00 40.75           C  
ATOM   1534  O   SER A 206      29.834  60.309 -23.905  1.00 41.37           O  
ATOM   1535  CB  SER A 206      31.893  62.797 -23.655  1.00 40.31           C  
ATOM   1536  OG  SER A 206      32.299  64.030 -24.213  1.00 40.78           O  
ATOM   1537  N   GLU A 207      29.957  61.139 -21.817  1.00 41.35           N  
ATOM   1538  CA  GLU A 207      29.622  59.872 -21.159  1.00 41.33           C  
ATOM   1539  C   GLU A 207      28.121  59.602 -21.086  1.00 41.30           C  
ATOM   1540  O   GLU A 207      27.700  58.591 -20.525  1.00 41.33           O  
ATOM   1541  CB  GLU A 207      30.218  59.820 -19.754  1.00 41.71           C  
ATOM   1542  CG  GLU A 207      31.735  59.710 -19.723  1.00 42.55           C  
ATOM   1543  CD  GLU A 207      32.307  59.957 -18.343  1.00 43.63           C  
ATOM   1544  OE1 GLU A 207      31.518  60.070 -17.378  1.00 44.20           O  
ATOM   1545  OE2 GLU A 207      33.546  60.047 -18.225  1.00 44.21           O  
ATOM   1546  N   ARG A 208      27.319  60.504 -21.649  1.00 41.09           N  
ATOM   1547  CA  ARG A 208      25.859  60.365 -21.644  1.00 41.12           C  
ATOM   1548  C   ARG A 208      25.264  60.252 -20.223  1.00 39.91           C  
ATOM   1549  O   ARG A 208      24.338  59.467 -19.976  1.00 39.44           O  
ATOM   1550  CB  ARG A 208      25.416  59.219 -22.570  1.00 41.16           C  
ATOM   1551  CG  ARG A 208      25.822  59.458 -24.022  1.00 42.68           C  
ATOM   1552  CD  ARG A 208      25.537  58.276 -24.960  1.00 43.58           C  
ATOM   1553  NE  ARG A 208      26.110  58.544 -26.286  1.00 48.74           N  
ATOM   1554  CZ  ARG A 208      27.231  57.994 -26.754  1.00 50.83           C  
ATOM   1555  NH1 ARG A 208      27.901  57.111 -26.021  1.00 51.87           N  
ATOM   1556  NH2 ARG A 208      27.677  58.316 -27.967  1.00 51.55           N  
ATOM   1557  N   MET A 209      25.809  61.044 -19.298  1.00 38.90           N  
ATOM   1558  CA  MET A 209      25.199  61.221 -17.972  1.00 37.82           C  
ATOM   1559  C   MET A 209      24.318  62.469 -17.968  1.00 36.98           C  
ATOM   1560  O   MET A 209      23.294  62.515 -17.279  1.00 36.91           O  
ATOM   1561  CB  MET A 209      26.252  61.345 -16.872  1.00 37.89           C  
ATOM   1562  CG  MET A 209      27.304  60.256 -16.849  1.00 38.33           C  
ATOM   1563  SD  MET A 209      28.218  60.274 -15.293  1.00 37.91           S  
ATOM   1564  CE  MET A 209      27.460  58.916 -14.568  1.00 34.55           C  
ATOM   1565  N   LEU A 210      24.729  63.468 -18.749  1.00 35.89           N  
ATOM   1566  CA  LEU A 210      24.003  64.723 -18.883  1.00 35.17           C  
ATOM   1567  C   LEU A 210      23.705  65.062 -20.340  1.00 35.24           C  
ATOM   1568  O   LEU A 210      24.222  64.416 -21.252  1.00 35.13           O  
ATOM   1569  CB  LEU A 210      24.797  65.882 -18.263  1.00 34.64           C  
ATOM   1570  CG  LEU A 210      25.203  65.859 -16.784  1.00 33.90           C  
ATOM   1571  CD1 LEU A 210      25.979  67.123 -16.473  1.00 31.40           C  
ATOM   1572  CD2 LEU A 210      24.003  65.721 -15.843  1.00 32.34           C  
ATOM   1573  N   ALA A 211      22.868  66.079 -20.528  1.00 35.05           N  
ATOM   1574  CA  ALA A 211      22.684  66.768 -21.794  1.00 35.09           C  
ATOM   1575  C   ALA A 211      22.553  68.241 -21.439  1.00 35.50           C  
ATOM   1576  O   ALA A 211      21.923  68.582 -20.430  1.00 35.50           O  
ATOM   1577  CB  ALA A 211      21.434  66.267 -22.506  1.00 35.02           C  
ATOM   1578  N   LEU A 212      23.166  69.109 -22.244  1.00 35.52           N  
ATOM   1579  CA  LEU A 212      23.224  70.549 -21.958  1.00 36.22           C  
ATOM   1580  C   LEU A 212      22.554  71.405 -23.034  1.00 36.51           C  
ATOM   1581  O   LEU A 212      22.651  71.113 -24.222  1.00 36.26           O  
ATOM   1582  CB  LEU A 212      24.678  71.009 -21.786  1.00 36.19           C  
ATOM   1583  CG  LEU A 212      25.570  70.364 -20.720  1.00 37.00           C  
ATOM   1584  CD1 LEU A 212      26.987  70.932 -20.786  1.00 38.36           C  
ATOM   1585  CD2 LEU A 212      24.987  70.520 -19.322  1.00 37.87           C  
ATOM   1586  N   ASP A 213      21.892  72.475 -22.609  1.00 36.75           N  
ATOM   1587  CA  ASP A 213      21.185  73.369 -23.524  1.00 37.05           C  
ATOM   1588  C   ASP A 213      21.124  74.740 -22.869  1.00 36.85           C  
ATOM   1589  O   ASP A 213      20.158  75.073 -22.184  1.00 36.45           O  
ATOM   1590  CB  ASP A 213      19.777  72.833 -23.817  1.00 37.61           C  
ATOM   1591  CG  ASP A 213      19.010  73.683 -24.831  1.00 39.75           C  
ATOM   1592  OD1 ASP A 213      19.596  74.619 -25.424  1.00 42.77           O  
ATOM   1593  OD2 ASP A 213      17.806  73.417 -25.028  1.00 42.61           O  
ATOM   1594  N   GLY A 214      22.176  75.528 -23.082  1.00 36.91           N  
ATOM   1595  CA  GLY A 214      22.340  76.816 -22.404  1.00 36.53           C  
ATOM   1596  C   GLY A 214      22.620  76.602 -20.928  1.00 36.46           C  
ATOM   1597  O   GLY A 214      23.552  75.886 -20.561  1.00 36.83           O  
ATOM   1598  N   LYS A 215      21.805  77.227 -20.080  1.00 35.91           N  
ATOM   1599  CA  LYS A 215      21.878  77.042 -18.632  1.00 35.26           C  
ATOM   1600  C   LYS A 215      21.089  75.818 -18.187  1.00 34.36           C  
ATOM   1601  O   LYS A 215      21.068  75.502 -17.002  1.00 34.42           O  
ATOM   1602  CB  LYS A 215      21.341  78.280 -17.904  1.00 35.70           C  
ATOM   1603  CG  LYS A 215      22.311  79.442 -17.832  1.00 36.76           C  
ATOM   1604  CD  LYS A 215      21.583  80.709 -17.421  1.00 40.17           C  
ATOM   1605  CE  LYS A 215      22.558  81.829 -17.148  1.00 42.21           C  
ATOM   1606  NZ  LYS A 215      21.861  82.983 -16.527  1.00 44.63           N  
ATOM   1607  N   ARG A 216      20.432  75.144 -19.130  1.00 33.15           N  
ATOM   1608  CA  ARG A 216      19.632  73.957 -18.826  1.00 32.43           C  
ATOM   1609  C   ARG A 216      20.507  72.714 -18.750  1.00 31.64           C  
ATOM   1610  O   ARG A 216      21.218  72.387 -19.704  1.00 31.15           O  
ATOM   1611  CB  ARG A 216      18.502  73.760 -19.849  1.00 32.52           C  
ATOM   1612  CG  ARG A 216      17.550  74.950 -19.939  1.00 35.28           C  
ATOM   1613  CD  ARG A 216      16.219  74.567 -20.575  1.00 42.33           C  
ATOM   1614  NE  ARG A 216      16.250  74.623 -22.034  1.00 47.02           N  
ATOM   1615  CZ  ARG A 216      15.421  75.347 -22.792  1.00 49.98           C  
ATOM   1616  NH1 ARG A 216      14.458  76.092 -22.241  1.00 50.44           N  
ATOM   1617  NH2 ARG A 216      15.552  75.313 -24.116  1.00 49.80           N  
ATOM   1618  N   ILE A 217      20.461  72.038 -17.601  1.00 30.29           N  
ATOM   1619  CA  ILE A 217      21.196  70.795 -17.395  1.00 29.69           C  
ATOM   1620  C   ILE A 217      20.199  69.654 -17.192  1.00 29.82           C  
ATOM   1621  O   ILE A 217      19.401  69.657 -16.248  1.00 28.50           O  
ATOM   1622  CB  ILE A 217      22.186  70.863 -16.187  1.00 29.65           C  
ATOM   1623  CG1 ILE A 217      23.161  72.038 -16.341  1.00 29.05           C  
ATOM   1624  CG2 ILE A 217      22.927  69.535 -16.023  1.00 27.89           C  
ATOM   1625  CD1 ILE A 217      24.093  72.239 -15.151  1.00 29.41           C  
ATOM   1626  N   LYS A 218      20.255  68.686 -18.097  1.00 30.37           N  
ATOM   1627  CA  LYS A 218      19.367  67.537 -18.063  1.00 31.30           C  
ATOM   1628  C   LYS A 218      20.135  66.326 -17.568  1.00 32.17           C  
ATOM   1629  O   LYS A 218      21.169  65.973 -18.136  1.00 31.96           O  
ATOM   1630  CB  LYS A 218      18.808  67.270 -19.457  1.00 31.29           C  
ATOM   1631  CG  LYS A 218      17.811  66.138 -19.506  1.00 32.86           C  
ATOM   1632  CD  LYS A 218      17.386  65.805 -20.936  1.00 36.39           C  
ATOM   1633  CE  LYS A 218      16.313  66.760 -21.445  1.00 37.39           C  
ATOM   1634  NZ  LYS A 218      15.740  66.277 -22.738  1.00 38.71           N  
ATOM   1635  N   ILE A 219      19.633  65.700 -16.506  1.00 32.85           N  
ATOM   1636  CA  ILE A 219      20.227  64.476 -15.992  1.00 34.48           C  
ATOM   1637  C   ILE A 219      19.594  63.286 -16.707  1.00 36.04           C  
ATOM   1638  O   ILE A 219      18.402  63.025 -16.550  1.00 36.13           O  
ATOM   1639  CB  ILE A 219      20.072  64.334 -14.458  1.00 34.31           C  
ATOM   1640  CG1 ILE A 219      20.782  65.485 -13.736  1.00 33.88           C  
ATOM   1641  CG2 ILE A 219      20.631  62.977 -13.992  1.00 34.12           C  
ATOM   1642  CD1 ILE A 219      20.469  65.576 -12.232  1.00 34.26           C  
ATOM   1643  N   ILE A 220      20.394  62.583 -17.505  1.00 37.82           N  
ATOM   1644  CA  ILE A 220      19.878  61.461 -18.296  1.00 39.96           C  
ATOM   1645  C   ILE A 220      20.267  60.102 -17.701  1.00 40.81           C  
ATOM   1646  O   ILE A 220      19.662  59.078 -18.020  1.00 41.34           O  
ATOM   1647  CB  ILE A 220      20.254  61.574 -19.805  1.00 39.93           C  
ATOM   1648  CG1 ILE A 220      21.775  61.670 -19.996  1.00 40.15           C  
ATOM   1649  CG2 ILE A 220      19.542  62.779 -20.441  1.00 40.12           C  
ATOM   1650  CD1 ILE A 220      22.224  61.779 -21.442  1.00 40.62           C  
ATOM   1651  N   ASP A 221      21.272  60.098 -16.836  1.00 42.07           N  
ATOM   1652  CA  ASP A 221      21.622  58.893 -16.102  1.00 43.17           C  
ATOM   1653  C   ASP A 221      21.919  59.216 -14.643  1.00 44.01           C  
ATOM   1654  O   ASP A 221      23.081  59.355 -14.239  1.00 44.00           O  
ATOM   1655  CB  ASP A 221      22.801  58.178 -16.754  1.00 43.23           C  
ATOM   1656  CG  ASP A 221      22.947  56.740 -16.280  1.00 43.68           C  
ATOM   1657  OD1 ASP A 221      22.239  56.322 -15.331  1.00 42.69           O  
ATOM   1658  OD2 ASP A 221      23.781  56.029 -16.867  1.00 44.25           O  
ATOM   1659  N   CYS A 222      20.854  59.326 -13.858  1.00 45.21           N  
ATOM   1660  CA  CYS A 222      20.973  59.689 -12.458  1.00 45.50           C  
ATOM   1661  C   CYS A 222      21.742  58.651 -11.632  1.00 45.59           C  
ATOM   1662  O   CYS A 222      22.609  59.019 -10.833  1.00 45.13           O  
ATOM   1663  CB  CYS A 222      19.597  59.943 -11.861  1.00 45.68           C  
ATOM   1664  SG  CYS A 222      19.698  60.757 -10.276  1.00 47.14           S  
ATOM   1665  N   ASP A 223      21.430  57.367 -11.836  1.00 45.68           N  
ATOM   1666  CA  ASP A 223      22.099  56.274 -11.118  1.00 45.79           C  
ATOM   1667  C   ASP A 223      23.612  56.353 -11.251  1.00 45.14           C  
ATOM   1668  O   ASP A 223      24.334  56.228 -10.260  1.00 45.14           O  
ATOM   1669  CB  ASP A 223      21.603  54.900 -11.596  1.00 46.27           C  
ATOM   1670  CG  ASP A 223      20.262  54.509 -10.984  1.00 47.81           C  
ATOM   1671  OD1 ASP A 223      19.980  54.904  -9.829  1.00 49.56           O  
ATOM   1672  OD2 ASP A 223      19.491  53.790 -11.660  1.00 50.00           O  
ATOM   1673  N   ARG A 224      24.083  56.573 -12.476  1.00 44.65           N  
ATOM   1674  CA  ARG A 224      25.511  56.666 -12.740  1.00 44.11           C  
ATOM   1675  C   ARG A 224      26.094  57.980 -12.218  1.00 43.28           C  
ATOM   1676  O   ARG A 224      27.219  58.000 -11.705  1.00 43.05           O  
ATOM   1677  CB  ARG A 224      25.805  56.479 -14.234  1.00 44.12           C  
ATOM   1678  CG  ARG A 224      26.261  55.064 -14.607  1.00 45.23           C  
ATOM   1679  CD  ARG A 224      26.140  54.767 -16.101  1.00 45.19           C  
ATOM   1680  NE  ARG A 224      27.172  55.407 -16.918  1.00 47.81           N  
ATOM   1681  CZ  ARG A 224      26.941  56.256 -17.923  1.00 48.40           C  
ATOM   1682  NH1 ARG A 224      25.701  56.600 -18.262  1.00 47.87           N  
ATOM   1683  NH2 ARG A 224      27.966  56.769 -18.595  1.00 48.02           N  
ATOM   1684  N   LEU A 225      25.336  59.073 -12.345  1.00 42.38           N  
ATOM   1685  CA  LEU A 225      25.766  60.351 -11.779  1.00 41.72           C  
ATOM   1686  C   LEU A 225      26.014  60.202 -10.275  1.00 41.84           C  
ATOM   1687  O   LEU A 225      27.017  60.690  -9.763  1.00 41.56           O  
ATOM   1688  CB  LEU A 225      24.768  61.481 -12.087  1.00 41.51           C  
ATOM   1689  CG  LEU A 225      25.202  62.924 -11.755  1.00 40.98           C  
ATOM   1690  CD1 LEU A 225      26.380  63.401 -12.613  1.00 39.69           C  
ATOM   1691  CD2 LEU A 225      24.041  63.899 -11.879  1.00 40.94           C  
ATOM   1692  N   GLN A 226      25.113  59.498  -9.591  1.00 42.13           N  
ATOM   1693  CA  GLN A 226      25.248  59.211  -8.157  1.00 42.77           C  
ATOM   1694  C   GLN A 226      26.501  58.376  -7.855  1.00 42.49           C  
ATOM   1695  O   GLN A 226      27.217  58.640  -6.885  1.00 42.24           O  
ATOM   1696  CB  GLN A 226      23.986  58.534  -7.611  1.00 42.61           C  
ATOM   1697  CG  GLN A 226      22.712  59.376  -7.759  1.00 44.37           C  
ATOM   1698  CD  GLN A 226      21.446  58.660  -7.309  1.00 44.72           C  
ATOM   1699  OE1 GLN A 226      21.363  58.165  -6.178  1.00 49.12           O  
ATOM   1700  NE2 GLN A 226      20.443  58.614  -8.187  1.00 46.21           N  
ATOM   1701  N   LYS A 227      26.773  57.382  -8.697  1.00 42.47           N  
ATOM   1702  CA  LYS A 227      27.999  56.603  -8.574  1.00 42.66           C  
ATOM   1703  C   LYS A 227      29.234  57.500  -8.726  1.00 42.31           C  
ATOM   1704  O   LYS A 227      30.201  57.358  -7.976  1.00 42.53           O  
ATOM   1705  CB  LYS A 227      28.013  55.462  -9.594  1.00 42.97           C  
ATOM   1706  CG  LYS A 227      29.000  54.345  -9.275  1.00 44.26           C  
ATOM   1707  CD  LYS A 227      28.770  53.137 -10.177  1.00 46.82           C  
ATOM   1708  CE  LYS A 227      27.724  52.178  -9.602  1.00 47.29           C  
ATOM   1709  NZ  LYS A 227      28.309  51.256  -8.581  1.00 47.65           N  
ATOM   1710  N   THR A 228      29.183  58.431  -9.678  1.00 41.94           N  
ATOM   1711  CA  THR A 228      30.267  59.391  -9.902  1.00 41.60           C  
ATOM   1712  C   THR A 228      30.458  60.324  -8.705  1.00 41.72           C  
ATOM   1713  O   THR A 228      31.590  60.598  -8.309  1.00 41.36           O  
ATOM   1714  CB  THR A 228      30.030  60.218 -11.183  1.00 41.54           C  
ATOM   1715  OG1 THR A 228      29.742  59.333 -12.271  1.00 41.31           O  
ATOM   1716  CG2 THR A 228      31.248  61.067 -11.524  1.00 40.85           C  
ATOM   1717  N   ALA A 229      29.356  60.804  -8.129  1.00 41.92           N  
ATOM   1718  CA  ALA A 229      29.422  61.626  -6.917  1.00 42.59           C  
ATOM   1719  C   ALA A 229      30.114  60.876  -5.787  1.00 43.32           C  
ATOM   1720  O   ALA A 229      30.942  61.443  -5.081  1.00 42.88           O  
ATOM   1721  CB  ALA A 229      28.039  62.067  -6.486  1.00 42.30           C  
ATOM   1722  N   ARG A 230      29.786  59.594  -5.644  1.00 44.52           N  
ATOM   1723  CA  ARG A 230      30.302  58.784  -4.541  1.00 46.19           C  
ATOM   1724  C   ARG A 230      31.691  58.222  -4.796  1.00 46.89           C  
ATOM   1725  O   ARG A 230      32.559  58.317  -3.929  1.00 47.37           O  
ATOM   1726  CB  ARG A 230      29.340  57.651  -4.196  1.00 46.23           C  
ATOM   1727  CG  ARG A 230      28.156  58.100  -3.372  1.00 48.15           C  
ATOM   1728  CD  ARG A 230      27.273  56.923  -2.999  1.00 50.89           C  
ATOM   1729  NE  ARG A 230      26.012  57.363  -2.407  1.00 52.61           N  
ATOM   1730  CZ  ARG A 230      25.008  56.551  -2.086  1.00 53.80           C  
ATOM   1731  NH1 ARG A 230      25.108  55.240  -2.298  1.00 54.25           N  
ATOM   1732  NH2 ARG A 230      23.903  57.054  -1.554  1.00 53.14           N  
ATOM   1733  N   SER A 231      31.891  57.652  -5.984  1.00 47.64           N  
ATOM   1734  CA  SER A 231      33.100  56.891  -6.307  1.00 48.26           C  
ATOM   1735  C   SER A 231      34.169  57.727  -7.007  1.00 48.51           C  
ATOM   1736  O   SER A 231      35.358  57.453  -6.863  1.00 48.72           O  
ATOM   1737  CB  SER A 231      32.751  55.670  -7.170  1.00 48.35           C  
ATOM   1738  OG  SER A 231      31.618  54.982  -6.662  1.00 48.09           O  
ATOM   1739  N   GLY A 232      33.747  58.729  -7.774  1.00 48.92           N  
ATOM   1740  CA  GLY A 232      34.681  59.603  -8.485  1.00 49.20           C  
ATOM   1741  C   GLY A 232      34.309  59.841  -9.939  1.00 49.57           C  
ATOM   1742  O   GLY A 232      34.293  58.909 -10.754  1.00 49.82           O  
TER    1743      GLY A 232                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
