
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  148 ( 1206),  selected  148 , name 2hkx_B
# Molecule2: number of CA atoms  146 ( 1234),  selected  146 , name T0503.pdb
# PARAMETERS: 2hkx_B.T0503.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_B      M       1           -
LGA    T     3_B      H       2           -
LGA    Q     4_B      T       3           -
LGA    M     5_B      A       4           -
LGA    R     6_B      L       5           -
LGA    -       -      I       6           -
LGA    -       -      N       7           -
LGA    -       -      H       8           -
LGA    -       -      I       9           -
LGA    L     7_B      R      10          3.147
LGA    T     8_B      K      11          5.450
LGA    D     9_B      F      12          2.201
LGA    T    10_B      I      13           #
LGA    N    11_B      F      14           -
LGA    L    12_B      -       -           -
LGA    L    13_B      -       -           -
LGA    E    14_B      -       -           -
LGA    V    15_B      L      15           #
LGA    L    16_B      -       -           -
LGA    N    17_B      -       -           -
LGA    S    18_B      T      16           #
LGA    E    19_B      D      17          1.842
LGA    E    20_B      E      18          2.458
LGA    Y    21_B      D      19          3.025
LGA    -       -      A      20           -
LGA    S    22_B      G      21          0.675
LGA    G    23_B      T      22          1.527
LGA    V    24_B      L      23          1.518
LGA    L    25_B      S      24          0.842
LGA    K    26_B      A      25          0.934
LGA    E    27_B      F      26          1.180
LGA    F    28_B      F      27          1.152
LGA    R    29_B      Q      28          1.326
LGA    E    30_B      L      29          1.538
LGA    Q    31_B      K      30          1.392
LGA    R    32_B      K      31          1.411
LGA    Y    33_B      V      32          0.996
LGA    S    34_B      R      33          0.400
LGA    K    35_B      K      34          0.934
LGA    K    36_B      K      35          1.146
LGA    A    37_B      E      36          1.091
LGA    I    38_B      T      37          1.242
LGA    L    39_B      L      38          1.408
LGA    Y    40_B      L      39          1.252
LGA    T    41_B      K      40          1.937
LGA    P    42_B      T      41          2.749
LGA    N    43_B      G      42          2.151
LGA    T    44_B      E      43          2.400
LGA    E    45_B      I      44          1.533
LGA    R    46_B      C      45          4.270
LGA    N    47_B      R      46          1.822
LGA    L    48_B      I      47          2.041
LGA    V    49_B      N      48          2.004
LGA    F    50_B      Y      49          2.075
LGA    L    51_B      F      50          1.201
LGA    V    52_B      V      51          1.242
LGA    K    53_B      V      52          1.821
LGA    S    54_B      K      53          1.486
LGA    G    55_B      G      54          1.081
LGA    R    56_B      C      55          0.867
LGA    V    57_B      L      56          0.703
LGA    R    58_B      R      57          1.332
LGA    V    59_B      L      58          1.675
LGA    Y    60_B      F      59          2.008
LGA    L    61_B      F      60          2.795
LGA    A    62_B      I      61          2.229
LGA    Y    63_B      D      62          0.971
LGA    E    64_B      E      63          2.950
LGA    D    65_B      K      64          3.870
LGA    -       -      G      65           -
LGA    K    66_B      I      66          1.822
LGA    E    67_B      E      67          2.459
LGA    F    68_B      Q      68          2.333
LGA    T    69_B      T      69          1.925
LGA    L    70_B      T      70          2.098
LGA    A    71_B      Q      71          2.234
LGA    I    72_B      F      72          1.708
LGA    L    73_B      A      73          0.703
LGA    E    74_B      I      74          1.542
LGA    A    75_B      E      75          1.932
LGA    G    76_B      N      76          1.870
LGA    D    77_B      W      77          1.208
LGA    I    78_B      W      78          1.643
LGA    F    79_B      L      79          2.319
LGA    C    80_B      S      80          2.427
LGA    T    81_B      D      81          4.027
LGA    H    82_B      Y      82          5.766
LGA    T    83_B      M      83          4.536
LGA    -       -      A      84           -
LGA    -       -      F      85           -
LGA    -       -      Q      86           -
LGA    -       -      K      87           -
LGA    -       -      Q      88           -
LGA    -       -      Q      89           -
LGA    -       -      P      90           -
LGA    -       -      A      91           -
LGA    R    84_B      D      92          2.648
LGA    A    85_B      F      93          2.340
LGA    F    86_B      Y      94          1.673
LGA    I    87_B      I      95          1.318
LGA    Q    88_B      Q      96          1.296
LGA    A    89_B      S      97          0.715
LGA    M    90_B      V      98          1.102
LGA    E    91_B      E      99          0.997
LGA    D    92_B      N     100          0.800
LGA    T    93_B      C     101          0.466
LGA    T    94_B      E     102          1.694
LGA    I    95_B      L     103          1.381
LGA    L    96_B      L     104          1.339
LGA    Y    97_B      S     105          1.333
LGA    T    98_B      I     106          1.799
LGA    D    99_B      T     107          1.644
LGA    I   100_B      Y     108          0.735
LGA    R   101_B      T     109          1.274
LGA    N   102_B      E     110          1.210
LGA    F   103_B      Q     111          0.311
LGA    Q   104_B      E     112          0.660
LGA    N   105_B      N     113          1.152
LGA    I   106_B      L     114          0.711
LGA    V   107_B      F     115          1.061
LGA    V   108_B      E     116          1.754
LGA    E   109_B      R     117          1.666
LGA    F   110_B      I     118          1.281
LGA    P   111_B      P     119          1.652
LGA    A   112_B      A     120          1.719
LGA    F   113_B      L     121          1.274
LGA    S   114_B      E     122          2.395
LGA    L   115_B      R     123          1.812
LGA    N   116_B      Y     124          1.878
LGA    M   117_B      F     125          2.117
LGA    V   118_B      R     126          2.810
LGA    K   119_B      L     127          2.463
LGA    V   120_B      V     128          2.807
LGA    L   121_B      Y     129          2.878
LGA    G   122_B      Q     130          3.026
LGA    D   123_B      K     131          3.184
LGA    L   124_B      S     132          2.516
LGA    L   125_B      F     133          1.933
LGA    K   126_B      A     134          2.258
LGA    L   127_B      A     135          2.324
LGA    L   128_B      A     136          1.587
LGA    L   129_B      Q     137          0.971
LGA    T   130_B      L     138          1.583
LGA    I   131_B      R     139          2.470
LGA    I   132_B      S     140          1.971
LGA    N   133_B      K     141          2.216
LGA    G   134_B      F     142          3.793
LGA    L   135_B      Q     143          5.379
LGA    V   136_B      H     144          6.095
LGA    F   137_B      -       -           -
LGA    K   138_B      M     145          5.621
LGA    D   139_B      Y     146           -
LGA    A   140_B      -       -           -
LGA    R   141_B      -       -           -
LGA    L   142_B      -       -           -
LGA    R   143_B      -       -           -
LGA    L   144_B      -       -           -
LGA    A   145_B      -       -           -
LGA    E   146_B      -       -           -
LGA    F   147_B      -       -           -
LGA    L   148_B      -       -           -
LGA    V   149_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  148  146    5.0    122    2.24    15.57     71.250     5.223

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.288937 * X  +  -0.338703 * Y  +   0.895431 * Z  +  29.211746
  Y_new =  -0.656488 * X  +  -0.610677 * Y  +  -0.442828 * Z  + 104.967628
  Z_new =   0.696806 * X  +  -0.715789 * Y  +  -0.045907 * Z  +  -1.575318 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.634843    1.506749  [ DEG:   -93.6696     86.3304 ]
  Theta =  -0.770935   -2.370657  [ DEG:   -44.1713   -135.8287 ]
  Phi   =  -1.985408    1.156185  [ DEG:  -113.7555     66.2445 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hkx_B                                        
REMARK     2: T0503.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hkx_B.T0503.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  148  146   5.0  122   2.24   15.57  71.250
REMARK  ---------------------------------------------------------- 
MOLECULE 2hkx_B
HEADER    TRANSCRIPTION REGULATOR                 05-JUL-06   2HKX              
TITLE     STRUCTURE OF COOA MUTANT (N127L/S128L) FROM                           
TITLE    2 CARBOXYDOTHERMUS HYDROGENOFORMANS                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CARBON MONOXIDE OXIDATION SYSTEM TRANSCRIPTION             
COMPND   3 REGULATOR COOA-1;                                                    
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CARBOXYDOTHERMUS HYDROGENOFORMANS;              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: COOA-1;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    COOA, TRANSCRIPTION FACTOR, HEME PROTEIN                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.D.LANZ,M.BORJIGIN,H.LI,R.L.KERBY,T.L.POULOS,G.P.ROBERTS             
REVDAT   1   06-MAR-07 2HKX    0                                                
JRNL        AUTH   M.BORJIGIN,H.LI,N.D.LANZ,R.L.KERBY,G.P.ROBERTS,              
JRNL        AUTH 2 T.L.POULOS                                                   
JRNL        TITL   STRUCTURE-BASED HYPOTHESIS ON THE ACTIVATION OF              
JRNL        TITL 2 THE CO-SENSING TRANSCRIPTION FACTOR COOA                     
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  63   282 2007              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2HKX A    5   221  UNP    Q3AB29   Q3AB29_CARHZ     1    217             
DBREF  2HKX B    5   221  UNP    Q3AB29   Q3AB29_CARHZ     1    217             
SEQRES   1 A  221  MET ALA THR GLN MET ARG LEU THR ASP THR ASN LEU LEU          
SEQRES   2 A  221  GLU VAL LEU ASN SER GLU GLU TYR SER GLY VAL LEU LYS          
SEQRES   3 A  221  GLU PHE ARG GLU GLN ARG TYR SER LYS LYS ALA ILE LEU          
SEQRES   4 A  221  TYR THR PRO ASN THR GLU ARG ASN LEU VAL PHE LEU VAL          
SEQRES   5 A  221  LYS SER GLY ARG VAL ARG VAL TYR LEU ALA TYR GLU ASP          
SEQRES   6 A  221  LYS GLU PHE THR LEU ALA ILE LEU GLU ALA GLY ASP ILE          
SEQRES   7 A  221  PHE CYS THR HIS THR ARG ALA PHE ILE GLN ALA MET GLU          
SEQRES   8 A  221  ASP THR THR ILE LEU TYR THR ASP ILE ARG ASN PHE GLN          
SEQRES   9 A  221  ASN ILE VAL VAL GLU PHE PRO ALA PHE SER LEU ASN MET          
SEQRES  10 A  221  VAL LYS VAL LEU GLY ASP LEU LEU LYS LEU LEU LEU THR          
SEQRES  11 A  221  ILE ILE ASN GLY LEU VAL PHE LYS ASP ALA ARG LEU ARG          
SEQRES  12 A  221  LEU ALA GLU PHE LEU VAL GLN ALA ALA MET ASP THR GLY          
SEQRES  13 A  221  LEU LYS VAL PRO GLN GLY ILE LYS LEU GLU LEU GLY LEU          
SEQRES  14 A  221  ASN THR GLU GLU ILE ALA LEU MET LEU GLY THR THR ARG          
SEQRES  15 A  221  GLN THR VAL SER VAL LEU LEU ASN ASP PHE LYS LYS MET          
SEQRES  16 A  221  GLY ILE LEU GLU ARG VAL ASN GLN ARG THR LEU LEU LEU          
SEQRES  17 A  221  LYS ASP LEU GLN LYS LEU LYS GLU PHE SER SER GLY VAL          
SEQRES   1 B  221  MET ALA THR GLN MET ARG LEU THR ASP THR ASN LEU LEU          
SEQRES   2 B  221  GLU VAL LEU ASN SER GLU GLU TYR SER GLY VAL LEU LYS          
SEQRES   3 B  221  GLU PHE ARG GLU GLN ARG TYR SER LYS LYS ALA ILE LEU          
SEQRES   4 B  221  TYR THR PRO ASN THR GLU ARG ASN LEU VAL PHE LEU VAL          
SEQRES   5 B  221  LYS SER GLY ARG VAL ARG VAL TYR LEU ALA TYR GLU ASP          
SEQRES   6 B  221  LYS GLU PHE THR LEU ALA ILE LEU GLU ALA GLY ASP ILE          
SEQRES   7 B  221  PHE CYS THR HIS THR ARG ALA PHE ILE GLN ALA MET GLU          
SEQRES   8 B  221  ASP THR THR ILE LEU TYR THR ASP ILE ARG ASN PHE GLN          
SEQRES   9 B  221  ASN ILE VAL VAL GLU PHE PRO ALA PHE SER LEU ASN MET          
SEQRES  10 B  221  VAL LYS VAL LEU GLY ASP LEU LEU LYS LEU LEU LEU THR          
SEQRES  11 B  221  ILE ILE ASN GLY LEU VAL PHE LYS ASP ALA ARG LEU ARG          
SEQRES  12 B  221  LEU ALA GLU PHE LEU VAL GLN ALA ALA MET ASP THR GLY          
SEQRES  13 B  221  LEU LYS VAL PRO GLN GLY ILE LYS LEU GLU LEU GLY LEU          
SEQRES  14 B  221  ASN THR GLU GLU ILE ALA LEU MET LEU GLY THR THR ARG          
SEQRES  15 B  221  GLN THR VAL SER VAL LEU LEU ASN ASP PHE LYS LYS MET          
SEQRES  16 B  221  GLY ILE LEU GLU ARG VAL ASN GLN ARG THR LEU LEU LEU          
SEQRES  17 B  221  LYS ASP LEU GLN LYS LEU LYS GLU PHE SER SER GLY VAL          
HET    HEM  A 300      43                                                       
HET    CMO  A 400       2                                                       
HETNAM     HEM PROTOPORPHYRIN IX CONTAINING FE                                  
HETNAM     CMO CARBON MONOXIDE                                                  
HETSYN     HEM HEME                                                             
FORMUL   3  HEM    C34 H32 FE N4 O4                                             
FORMUL   4  CMO    C O                                                          
FORMUL   5  HOH   *58(H2 O)                                                     
CRYST1   52.115   92.873   95.500  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1754  N   ALA B   2       3.535  55.620  16.337  1.00 60.68           N  
ATOM   1755  CA  ALA B   2       2.494  56.437  15.651  1.00 59.92           C  
ATOM   1756  C   ALA B   2       1.978  57.512  16.580  1.00 59.76           C  
ATOM   1757  O   ALA B   2       1.429  57.210  17.620  1.00 62.04           O  
ATOM   1758  CB  ALA B   2       1.330  55.560  15.180  1.00 58.78           C  
ATOM   1759  N   THR B   3       2.141  58.762  16.191  1.00 59.53           N  
ATOM   1760  CA  THR B   3       1.582  59.888  16.923  1.00 59.75           C  
ATOM   1761  C   THR B   3       0.748  60.731  15.936  1.00 59.12           C  
ATOM   1762  O   THR B   3       0.856  60.558  14.709  1.00 57.18           O  
ATOM   1763  CB  THR B   3       2.709  60.762  17.621  1.00 60.57           C  
ATOM   1764  OG1 THR B   3       3.580  61.320  16.634  1.00 60.48           O  
ATOM   1765  CG2 THR B   3       3.538  59.944  18.542  1.00 61.62           C  
ATOM   1766  N   GLN B   4      -0.088  61.623  16.463  1.00 60.55           N  
ATOM   1767  CA  GLN B   4      -0.802  62.567  15.605  1.00 62.17           C  
ATOM   1768  C   GLN B   4       0.154  63.655  15.104  1.00 61.67           C  
ATOM   1769  O   GLN B   4       1.204  63.912  15.699  1.00 61.76           O  
ATOM   1770  CB  GLN B   4      -2.030  63.177  16.306  1.00 63.96           C  
ATOM   1771  CG  GLN B   4      -3.185  62.173  16.641  1.00 67.02           C  
ATOM   1772  CD  GLN B   4      -4.045  61.681  15.412  1.00 66.73           C  
ATOM   1773  OE1 GLN B   4      -3.555  61.590  14.251  1.00 62.15           O  
ATOM   1774  NE2 GLN B   4      -5.326  61.333  15.693  1.00 61.28           N  
ATOM   1775  N   MET B   5      -0.194  64.258  13.982  1.00 62.98           N  
ATOM   1776  CA  MET B   5       0.565  65.382  13.421  1.00 63.61           C  
ATOM   1777  C   MET B   5       0.343  66.618  14.288  1.00 64.55           C  
ATOM   1778  O   MET B   5      -0.806  67.008  14.535  1.00 65.54           O  
ATOM   1779  CB  MET B   5       0.057  65.675  12.015  1.00 64.92           C  
ATOM   1780  CG  MET B   5       0.549  66.973  11.413  1.00 66.30           C  
ATOM   1781  SD  MET B   5       2.029  66.633  10.497  1.00 71.74           S  
ATOM   1782  CE  MET B   5       2.144  68.080   9.446  1.00 69.15           C  
ATOM   1783  N   ARG B   6       1.433  67.224  14.754  1.00 64.29           N  
ATOM   1784  CA  ARG B   6       1.340  68.457  15.530  1.00 65.82           C  
ATOM   1785  C   ARG B   6       1.907  69.666  14.777  1.00 64.95           C  
ATOM   1786  O   ARG B   6       2.641  69.513  13.792  1.00 63.48           O  
ATOM   1787  CB  ARG B   6       2.051  68.282  16.868  1.00 67.29           C  
ATOM   1788  CG  ARG B   6       1.243  67.508  17.883  1.00 72.18           C  
ATOM   1789  CD  ARG B   6       2.038  67.305  19.162  1.00 80.23           C  
ATOM   1790  NE  ARG B   6       3.164  66.389  18.963  1.00 82.96           N  
ATOM   1791  CZ  ARG B   6       4.281  66.391  19.691  1.00 87.42           C  
ATOM   1792  NH1 ARG B   6       4.453  67.273  20.678  1.00 89.99           N  
ATOM   1793  NH2 ARG B   6       5.240  65.512  19.418  1.00 88.70           N  
ATOM   1794  N   LEU B   7       1.577  70.863  15.266  1.00 66.02           N  
ATOM   1795  CA  LEU B   7       2.109  72.117  14.727  1.00 65.29           C  
ATOM   1796  C   LEU B   7       3.634  72.142  14.720  1.00 64.56           C  
ATOM   1797  O   LEU B   7       4.256  72.723  13.835  1.00 63.38           O  
ATOM   1798  CB  LEU B   7       1.558  73.302  15.515  1.00 67.56           C  
ATOM   1799  CG  LEU B   7       0.525  74.202  14.827  1.00 70.12           C  
ATOM   1800  CD1 LEU B   7       1.226  75.399  14.226  1.00 70.31           C  
ATOM   1801  CD2 LEU B   7      -0.319  73.475  13.762  1.00 71.17           C  
ATOM   1802  N   THR B   8       4.220  71.489  15.710  1.00 65.44           N  
ATOM   1803  CA  THR B   8       5.657  71.332  15.791  1.00 66.14           C  
ATOM   1804  C   THR B   8       6.281  70.580  14.579  1.00 65.17           C  
ATOM   1805  O   THR B   8       7.484  70.697  14.330  1.00 66.64           O  
ATOM   1806  CB  THR B   8       6.058  70.752  17.176  1.00 68.62           C  
ATOM   1807  OG1 THR B   8       7.459  70.941  17.390  1.00 72.09           O  
ATOM   1808  CG2 THR B   8       5.694  69.264  17.310  1.00 68.00           C  
ATOM   1809  N   ASP B   9       5.451  69.874  13.802  1.00 63.66           N  
ATOM   1810  CA  ASP B   9       5.901  69.108  12.614  1.00 63.56           C  
ATOM   1811  C   ASP B   9       5.575  69.790  11.296  1.00 63.80           C  
ATOM   1812  O   ASP B   9       5.742  69.188  10.236  1.00 65.46           O  
ATOM   1813  CB  ASP B   9       5.245  67.723  12.527  1.00 62.83           C  
ATOM   1814  CG  ASP B   9       5.258  66.978  13.822  1.00 62.28           C  
ATOM   1815  OD1 ASP B   9       6.354  66.543  14.255  1.00 63.77           O  
ATOM   1816  OD2 ASP B   9       4.160  66.815  14.390  1.00 59.32           O  
ATOM   1817  N   THR B  10       5.074  71.013  11.346  1.00 63.39           N  
ATOM   1818  CA  THR B  10       4.671  71.692  10.122  1.00 63.98           C  
ATOM   1819  C   THR B  10       5.764  72.678   9.713  1.00 64.89           C  
ATOM   1820  O   THR B  10       6.667  72.968  10.498  1.00 65.03           O  
ATOM   1821  CB  THR B  10       3.296  72.367  10.300  1.00 63.75           C  
ATOM   1822  OG1 THR B  10       3.436  73.517  11.126  1.00 62.50           O  
ATOM   1823  CG2 THR B  10       2.315  71.399  10.984  1.00 63.79           C  
ATOM   1824  N   ASN B  11       5.708  73.174   8.484  1.00 66.46           N  
ATOM   1825  CA  ASN B  11       6.731  74.105   8.026  1.00 68.37           C  
ATOM   1826  C   ASN B  11       6.515  75.501   8.631  1.00 66.87           C  
ATOM   1827  O   ASN B  11       5.419  75.814   9.083  1.00 66.63           O  
ATOM   1828  CB  ASN B  11       6.878  74.064   6.486  1.00 71.26           C  
ATOM   1829  CG  ASN B  11       6.101  75.165   5.766  1.00 73.47           C  
ATOM   1830  OD1 ASN B  11       4.876  75.242   5.860  1.00 73.78           O  
ATOM   1831  ND2 ASN B  11       6.827  76.005   5.006  1.00 76.80           N  
ATOM   1832  N   LEU B  12       7.559  76.315   8.685  1.00 67.44           N  
ATOM   1833  CA  LEU B  12       7.491  77.581   9.431  1.00 66.41           C  
ATOM   1834  C   LEU B  12       6.396  78.507   8.929  1.00 66.03           C  
ATOM   1835  O   LEU B  12       5.851  79.292   9.701  1.00 65.48           O  
ATOM   1836  CB  LEU B  12       8.829  78.332   9.405  1.00 67.28           C  
ATOM   1837  CG  LEU B  12      10.044  77.799  10.172  1.00 68.70           C  
ATOM   1838  CD1 LEU B  12      11.281  78.589   9.800  1.00 66.96           C  
ATOM   1839  CD2 LEU B  12       9.834  77.824  11.685  1.00 66.86           C  
ATOM   1840  N   LEU B  13       6.094  78.442   7.635  1.00 67.65           N  
ATOM   1841  CA  LEU B  13       5.061  79.312   7.070  1.00 68.53           C  
ATOM   1842  C   LEU B  13       3.655  78.888   7.510  1.00 69.18           C  
ATOM   1843  O   LEU B  13       2.833  79.738   7.867  1.00 69.98           O  
ATOM   1844  CB  LEU B  13       5.181  79.387   5.551  1.00 70.95           C  
ATOM   1845  CG  LEU B  13       6.453  80.058   5.020  1.00 72.03           C  
ATOM   1846  CD1 LEU B  13       6.664  79.755   3.543  1.00 74.58           C  
ATOM   1847  CD2 LEU B  13       6.424  81.559   5.267  1.00 70.71           C  
ATOM   1848  N   GLU B  14       3.386  77.583   7.489  1.00 69.66           N  
ATOM   1849  CA  GLU B  14       2.100  77.035   7.930  1.00 71.07           C  
ATOM   1850  C   GLU B  14       1.807  77.494   9.362  1.00 69.69           C  
ATOM   1851  O   GLU B  14       0.769  78.112   9.623  1.00 70.97           O  
ATOM   1852  CB  GLU B  14       2.106  75.499   7.841  1.00 71.10           C  
ATOM   1853  CG  GLU B  14       0.818  74.883   7.327  1.00 75.88           C  
ATOM   1854  CD  GLU B  14       1.042  73.495   6.712  1.00 80.72           C  
ATOM   1855  OE1 GLU B  14       0.306  72.541   7.079  1.00 80.96           O  
ATOM   1856  OE2 GLU B  14       1.963  73.360   5.866  1.00 83.30           O  
ATOM   1857  N   VAL B  15       2.746  77.211  10.262  1.00 67.75           N  
ATOM   1858  CA  VAL B  15       2.711  77.668  11.664  1.00 68.03           C  
ATOM   1859  C   VAL B  15       2.437  79.165  11.787  1.00 69.12           C  
ATOM   1860  O   VAL B  15       1.468  79.584  12.438  1.00 70.69           O  
ATOM   1861  CB  VAL B  15       4.054  77.369  12.395  1.00 67.41           C  
ATOM   1862  CG1 VAL B  15       3.978  77.791  13.871  1.00 68.39           C  
ATOM   1863  CG2 VAL B  15       4.407  75.911  12.279  1.00 66.46           C  
ATOM   1864  N   LEU B  16       3.309  79.963  11.168  1.00 68.73           N  
ATOM   1865  CA  LEU B  16       3.167  81.416  11.142  1.00 69.75           C  
ATOM   1866  C   LEU B  16       1.813  81.889  10.623  1.00 71.58           C  
ATOM   1867  O   LEU B  16       1.308  82.894  11.095  1.00 73.36           O  
ATOM   1868  CB  LEU B  16       4.282  82.065  10.319  1.00 69.14           C  
ATOM   1869  CG  LEU B  16       5.558  82.476  11.048  1.00 69.82           C  
ATOM   1870  CD1 LEU B  16       6.550  83.101  10.069  1.00 69.50           C  
ATOM   1871  CD2 LEU B  16       5.247  83.429  12.184  1.00 71.15           C  
ATOM   1872  N   ASN B  17       1.246  81.176   9.649  1.00 72.26           N  
ATOM   1873  CA  ASN B  17      -0.080  81.504   9.122  1.00 75.80           C  
ATOM   1874  C   ASN B  17      -1.162  80.603   9.721  1.00 77.50           C  
ATOM   1875  O   ASN B  17      -2.101  80.187   9.032  1.00 80.36           O  
ATOM   1876  CB  ASN B  17      -0.105  81.424   7.591  1.00 77.22           C  
ATOM   1877  CG  ASN B  17       0.805  82.438   6.936  1.00 77.67           C  
ATOM   1878  OD1 ASN B  17       2.038  82.267   6.893  1.00 76.41           O  
ATOM   1879  ND2 ASN B  17       0.207  83.503   6.404  1.00 80.57           N  
ATOM   1880  N   SER B  18      -0.997  80.278  11.001  1.00 76.53           N  
ATOM   1881  CA  SER B  18      -2.014  79.589  11.774  1.00 78.75           C  
ATOM   1882  C   SER B  18      -2.561  80.582  12.801  1.00 82.08           C  
ATOM   1883  O   SER B  18      -1.900  81.575  13.122  1.00 81.38           O  
ATOM   1884  CB  SER B  18      -1.447  78.327  12.437  1.00 76.18           C  
ATOM   1885  OG  SER B  18      -0.672  78.621  13.583  1.00 75.05           O  
ATOM   1886  N   GLU B  19      -3.761  80.318  13.313  1.00 86.14           N  
ATOM   1887  CA  GLU B  19      -4.461  81.310  14.133  1.00 91.19           C  
ATOM   1888  C   GLU B  19      -3.752  81.802  15.401  1.00 91.31           C  
ATOM   1889  O   GLU B  19      -3.821  82.992  15.718  1.00 94.00           O  
ATOM   1890  CB  GLU B  19      -5.893  80.866  14.448  1.00 96.81           C  
ATOM   1891  CG  GLU B  19      -6.961  81.667  13.690  1.00102.29           C  
ATOM   1892  CD  GLU B  19      -7.092  83.109  14.173  1.00105.40           C  
ATOM   1893  OE1 GLU B  19      -8.126  83.419  14.802  1.00113.11           O  
ATOM   1894  OE2 GLU B  19      -6.178  83.933  13.929  1.00100.66           O  
ATOM   1895  N   GLU B  20      -3.079  80.907  16.125  1.00 89.32           N  
ATOM   1896  CA  GLU B  20      -2.454  81.306  17.393  1.00 90.96           C  
ATOM   1897  C   GLU B  20      -1.160  82.104  17.193  1.00 87.74           C  
ATOM   1898  O   GLU B  20      -0.724  82.830  18.092  1.00 90.27           O  
ATOM   1899  CB  GLU B  20      -2.262  80.113  18.349  1.00 91.50           C  
ATOM   1900  CG  GLU B  20      -1.042  79.238  18.098  1.00 87.09           C  
ATOM   1901  CD  GLU B  20      -1.358  77.923  17.394  1.00 85.29           C  
ATOM   1902  OE1 GLU B  20      -0.396  77.194  17.078  1.00 83.19           O  
ATOM   1903  OE2 GLU B  20      -2.544  77.608  17.156  1.00 86.42           O  
ATOM   1904  N   TYR B  21      -0.573  81.978  16.007  1.00 82.85           N  
ATOM   1905  CA  TYR B  21       0.619  82.738  15.652  1.00 80.12           C  
ATOM   1906  C   TYR B  21       0.309  83.999  14.832  1.00 80.62           C  
ATOM   1907  O   TYR B  21       1.196  84.540  14.165  1.00 78.63           O  
ATOM   1908  CB  TYR B  21       1.627  81.849  14.908  1.00 75.60           C  
ATOM   1909  CG  TYR B  21       2.377  80.880  15.798  1.00 74.76           C  
ATOM   1910  CD1 TYR B  21       1.794  79.679  16.188  1.00 74.40           C  
ATOM   1911  CD2 TYR B  21       3.674  81.155  16.239  1.00 73.89           C  
ATOM   1912  CE1 TYR B  21       2.461  78.776  17.004  1.00 73.99           C  
ATOM   1913  CE2 TYR B  21       4.362  80.251  17.061  1.00 74.66           C  
ATOM   1914  CZ  TYR B  21       3.736  79.056  17.438  1.00 75.60           C  
ATOM   1915  OH  TYR B  21       4.374  78.131  18.246  1.00 76.21           O  
ATOM   1916  N   SER B  22      -0.934  84.474  14.882  1.00 83.74           N  
ATOM   1917  CA  SER B  22      -1.312  85.671  14.117  1.00 84.65           C  
ATOM   1918  C   SER B  22      -0.666  86.955  14.661  1.00 85.05           C  
ATOM   1919  O   SER B  22      -0.209  87.802  13.883  1.00 83.48           O  
ATOM   1920  CB  SER B  22      -2.831  85.816  13.994  1.00 89.43           C  
ATOM   1921  OG  SER B  22      -3.476  85.463  15.201  1.00 94.03           O  
ATOM   1922  N   GLY B  23      -0.618  87.085  15.987  1.00 87.09           N  
ATOM   1923  CA  GLY B  23       0.115  88.175  16.636  1.00 87.18           C  
ATOM   1924  C   GLY B  23       1.629  88.043  16.526  1.00 82.53           C  
ATOM   1925  O   GLY B  23       2.366  88.933  16.946  1.00 83.83           O  
ATOM   1926  N   VAL B  24       2.091  86.927  15.967  1.00 77.67           N  
ATOM   1927  CA  VAL B  24       3.513  86.702  15.724  1.00 73.92           C  
ATOM   1928  C   VAL B  24       3.854  87.169  14.309  1.00 70.50           C  
ATOM   1929  O   VAL B  24       4.883  87.832  14.088  1.00 69.59           O  
ATOM   1930  CB  VAL B  24       3.911  85.198  15.883  1.00 72.01           C  
ATOM   1931  CG1 VAL B  24       5.359  84.970  15.488  1.00 71.48           C  
ATOM   1932  CG2 VAL B  24       3.686  84.715  17.302  1.00 75.28           C  
ATOM   1933  N   LEU B  25       2.990  86.808  13.360  1.00 79.61           N  
ATOM   1934  CA  LEU B  25       3.166  87.158  11.960  1.00 76.45           C  
ATOM   1935  C   LEU B  25       3.317  88.672  11.797  1.00 77.17           C  
ATOM   1936  O   LEU B  25       4.091  89.132  10.952  1.00 75.61           O  
ATOM   1937  CB  LEU B  25       1.987  86.616  11.138  1.00 77.05           C  
ATOM   1938  CG  LEU B  25       1.922  86.701   9.607  1.00 76.23           C  
ATOM   1939  CD1 LEU B  25       3.213  86.225   8.886  1.00 67.09           C  
ATOM   1940  CD2 LEU B  25       0.687  85.928   9.102  1.00 77.02           C  
ATOM   1941  N   LYS B  26       2.589  89.429  12.621  1.00 80.09           N  
ATOM   1942  CA  LYS B  26       2.638  90.898  12.631  1.00 81.80           C  
ATOM   1943  C   LYS B  26       4.044  91.435  12.907  1.00 80.04           C  
ATOM   1944  O   LYS B  26       4.425  92.479  12.370  1.00 81.06           O  
ATOM   1945  CB  LYS B  26       1.640  91.490  13.649  1.00 86.72           C  
ATOM   1946  CG  LYS B  26       0.165  91.044  13.500  1.00 89.49           C  
ATOM   1947  CD  LYS B  26      -0.490  91.427  12.145  1.00 91.33           C  
ATOM   1948  CE  LYS B  26      -0.172  90.421  11.003  1.00 87.12           C  
ATOM   1949  NZ  LYS B  26      -0.897  89.118  11.138  1.00 86.45           N  
ATOM   1950  N   GLU B  27       4.803  90.717  13.738  1.00 77.77           N  
ATOM   1951  CA  GLU B  27       6.177  91.090  14.094  1.00 76.13           C  
ATOM   1952  C   GLU B  27       7.071  91.165  12.870  1.00 71.78           C  
ATOM   1953  O   GLU B  27       8.065  91.888  12.862  1.00 71.37           O  
ATOM   1954  CB  GLU B  27       6.793  90.072  15.055  1.00 75.49           C  
ATOM   1955  CG  GLU B  27       5.992  89.783  16.298  1.00 79.41           C  
ATOM   1956  CD  GLU B  27       6.200  90.805  17.380  1.00 84.36           C  
ATOM   1957  OE1 GLU B  27       6.753  91.885  17.091  1.00 86.24           O  
ATOM   1958  OE2 GLU B  27       5.804  90.525  18.527  1.00 88.37           O  
ATOM   1959  N   PHE B  28       6.716  90.388  11.853  1.00 68.48           N  
ATOM   1960  CA  PHE B  28       7.496  90.302  10.631  1.00 64.93           C  
ATOM   1961  C   PHE B  28       7.030  91.330   9.617  1.00 66.48           C  
ATOM   1962  O   PHE B  28       5.837  91.599   9.479  1.00 68.51           O  
ATOM   1963  CB  PHE B  28       7.412  88.897  10.029  1.00 61.36           C  
ATOM   1964  CG  PHE B  28       8.107  87.845  10.848  1.00 58.61           C  
ATOM   1965  CD1 PHE B  28       7.443  87.203  11.885  1.00 58.93           C  
ATOM   1966  CD2 PHE B  28       9.413  87.491  10.572  1.00 54.25           C  
ATOM   1967  CE1 PHE B  28       8.081  86.231  12.640  1.00 59.57           C  
ATOM   1968  CE2 PHE B  28      10.067  86.528  11.332  1.00 56.70           C  
ATOM   1969  CZ  PHE B  28       9.401  85.893  12.364  1.00 57.43           C  
ATOM   1970  N   ARG B  29       7.997  91.898   8.915  1.00 65.83           N  
ATOM   1971  CA  ARG B  29       7.717  92.833   7.853  1.00 67.80           C  
ATOM   1972  C   ARG B  29       8.087  92.121   6.568  1.00 64.46           C  
ATOM   1973  O   ARG B  29       9.060  91.357   6.522  1.00 61.37           O  
ATOM   1974  CB  ARG B  29       8.522  94.132   8.022  1.00 70.80           C  
ATOM   1975  CG  ARG B  29       9.168  94.370   9.433  1.00 74.10           C  
ATOM   1976  CD  ARG B  29       8.163  94.481  10.595  1.00 77.93           C  
ATOM   1977  NE  ARG B  29       7.312  95.666  10.494  1.00 83.34           N  
ATOM   1978  CZ  ARG B  29       6.138  95.814  11.109  1.00 86.11           C  
ATOM   1979  NH1 ARG B  29       5.645  94.844  11.879  1.00 84.56           N  
ATOM   1980  NH2 ARG B  29       5.447  96.937  10.944  1.00 89.60           N  
ATOM   1981  N   GLU B  30       7.286  92.332   5.535  1.00 64.92           N  
ATOM   1982  CA  GLU B  30       7.523  91.654   4.272  1.00 62.63           C  
ATOM   1983  C   GLU B  30       8.318  92.550   3.334  1.00 62.63           C  
ATOM   1984  O   GLU B  30       8.088  93.759   3.272  1.00 65.45           O  
ATOM   1985  CB  GLU B  30       6.195  91.231   3.646  1.00 64.19           C  
ATOM   1986  CG  GLU B  30       6.314  90.520   2.316  1.00 64.50           C  
ATOM   1987  CD  GLU B  30       4.962  90.202   1.717  1.00 68.89           C  
ATOM   1988  OE1 GLU B  30       4.226  89.384   2.299  1.00 70.64           O  
ATOM   1989  OE2 GLU B  30       4.621  90.779   0.668  1.00 73.22           O  
ATOM   1990  N   GLN B  31       9.270  91.943   2.625  1.00 59.46           N  
ATOM   1991  CA  GLN B  31      10.092  92.629   1.632  1.00 59.53           C  
ATOM   1992  C   GLN B  31      10.230  91.792   0.373  1.00 58.48           C  
ATOM   1993  O   GLN B  31      10.375  90.563   0.441  1.00 56.07           O  
ATOM   1994  CB  GLN B  31      11.482  92.887   2.181  1.00 58.08           C  
ATOM   1995  CG  GLN B  31      11.565  93.992   3.196  1.00 59.92           C  
ATOM   1996  CD  GLN B  31      12.998  94.351   3.523  1.00 59.09           C  
ATOM   1997  OE1 GLN B  31      13.906  93.488   3.505  1.00 56.12           O  
ATOM   1998  NE2 GLN B  31      13.220  95.623   3.836  1.00 58.54           N  
ATOM   1999  N   ARG B  32      10.229  92.462  -0.770  1.00 60.16           N  
ATOM   2000  CA  ARG B  32      10.291  91.779  -2.051  1.00 60.03           C  
ATOM   2001  C   ARG B  32      11.522  92.193  -2.866  1.00 60.17           C  
ATOM   2002  O   ARG B  32      11.806  93.385  -2.989  1.00 62.64           O  
ATOM   2003  CB  ARG B  32       9.011  92.038  -2.833  1.00 63.41           C  
ATOM   2004  CG  ARG B  32       7.785  91.450  -2.156  1.00 64.64           C  
ATOM   2005  CD  ARG B  32       6.533  92.084  -2.686  1.00 73.47           C  
ATOM   2006  NE  ARG B  32       5.398  91.891  -1.789  1.00 75.20           N  
ATOM   2007  CZ  ARG B  32       4.227  92.493  -1.953  1.00 81.40           C  
ATOM   2008  NH1 ARG B  32       4.058  93.322  -2.970  1.00 84.45           N  
ATOM   2009  NH2 ARG B  32       3.228  92.268  -1.106  1.00 83.68           N  
ATOM   2010  N   TYR B  33      12.217  91.192  -3.420  1.00 56.87           N  
ATOM   2011  CA  TYR B  33      13.451  91.363  -4.206  1.00 57.21           C  
ATOM   2012  C   TYR B  33      13.273  90.765  -5.604  1.00 58.54           C  
ATOM   2013  O   TYR B  33      12.667  89.706  -5.749  1.00 58.44           O  
ATOM   2014  CB  TYR B  33      14.663  90.688  -3.491  1.00 53.04           C  
ATOM   2015  CG  TYR B  33      14.993  91.397  -2.197  1.00 52.69           C  
ATOM   2016  CD1 TYR B  33      14.364  91.042  -1.002  1.00 48.47           C  
ATOM   2017  CD2 TYR B  33      15.850  92.515  -2.189  1.00 55.13           C  
ATOM   2018  CE1 TYR B  33      14.608  91.734   0.178  1.00 49.06           C  
ATOM   2019  CE2 TYR B  33      16.105  93.215  -1.012  1.00 55.27           C  
ATOM   2020  CZ  TYR B  33      15.476  92.809   0.172  1.00 54.27           C  
ATOM   2021  OH  TYR B  33      15.731  93.491   1.343  1.00 57.43           O  
ATOM   2022  N   SER B  34      13.832  91.416  -6.615  1.00 60.33           N  
ATOM   2023  CA  SER B  34      13.844  90.867  -7.979  1.00 62.24           C  
ATOM   2024  C   SER B  34      15.054  89.970  -8.252  1.00 60.08           C  
ATOM   2025  O   SER B  34      16.091  90.102  -7.603  1.00 56.99           O  
ATOM   2026  CB  SER B  34      13.821  92.003  -9.003  1.00 66.26           C  
ATOM   2027  OG  SER B  34      12.613  92.758  -8.882  1.00 70.82           O  
ATOM   2028  N   LYS B  35      14.901  89.077  -9.231  1.00 61.29           N  
ATOM   2029  CA  LYS B  35      15.980  88.229  -9.712  1.00 61.20           C  
ATOM   2030  C   LYS B  35      17.331  88.933  -9.748  1.00 61.41           C  
ATOM   2031  O   LYS B  35      17.500  89.930 -10.447  1.00 65.11           O  
ATOM   2032  CB  LYS B  35      15.659  87.683 -11.106  1.00 65.22           C  
ATOM   2033  CG  LYS B  35      16.623  86.607 -11.593  1.00 66.06           C  
ATOM   2034  CD  LYS B  35      16.136  86.008 -12.903  1.00 71.32           C  
ATOM   2035  CE  LYS B  35      16.676  84.601 -13.113  1.00 73.23           C  
ATOM   2036  NZ  LYS B  35      15.990  83.616 -12.207  1.00 74.49           N  
ATOM   2037  N   LYS B  36      18.268  88.388  -8.971  1.00 58.09           N  
ATOM   2038  CA  LYS B  36      19.690  88.772  -8.945  1.00 57.92           C  
ATOM   2039  C   LYS B  36      20.028  89.897  -7.955  1.00 56.43           C  
ATOM   2040  O   LYS B  36      21.183  90.168  -7.701  1.00 55.48           O  
ATOM   2041  CB  LYS B  36      20.279  88.935 -10.370  1.00 61.49           C  
ATOM   2042  CG  LYS B  36      20.581  90.348 -10.889  1.00 65.63           C  
ATOM   2043  CD  LYS B  36      21.453  90.251 -12.145  1.00 69.83           C  
ATOM   2044  CE  LYS B  36      22.719  91.155 -12.081  1.00 74.78           C  
ATOM   2045  NZ  LYS B  36      23.796  90.608 -11.166  1.00 73.89           N  
ATOM   2046  N   ALA B  37      19.010  90.511  -7.352  1.00 56.01           N  
ATOM   2047  CA  ALA B  37      19.247  91.509  -6.305  1.00 56.08           C  
ATOM   2048  C   ALA B  37      20.025  90.925  -5.121  1.00 53.22           C  
ATOM   2049  O   ALA B  37      19.804  89.785  -4.717  1.00 50.83           O  
ATOM   2050  CB  ALA B  37      17.933  92.121  -5.826  1.00 56.43           C  
ATOM   2051  N   ILE B  38      20.925  91.725  -4.560  1.00 54.87           N  
ATOM   2052  CA  ILE B  38      21.611  91.395  -3.325  1.00 53.80           C  
ATOM   2053  C   ILE B  38      20.806  91.883  -2.128  1.00 53.77           C  
ATOM   2054  O   ILE B  38      20.688  93.067  -1.869  1.00 56.07           O  
ATOM   2055  CB  ILE B  38      23.087  91.897  -3.319  1.00 56.27           C  
ATOM   2056  CG1 ILE B  38      23.952  90.989  -4.206  1.00 56.91           C  
ATOM   2057  CG2 ILE B  38      23.701  91.906  -1.911  1.00 56.77           C  
ATOM   2058  CD1 ILE B  38      24.015  91.461  -5.643  1.00 61.61           C  
ATOM   2059  N   LEU B  39      20.247  90.936  -1.395  1.00 51.97           N  
ATOM   2060  CA  LEU B  39      19.528  91.227  -0.154  1.00 52.07           C  
ATOM   2061  C   LEU B  39      20.461  91.767   0.914  1.00 53.40           C  
ATOM   2062  O   LEU B  39      20.257  92.863   1.423  1.00 55.85           O  
ATOM   2063  CB  LEU B  39      18.844  89.963   0.385  1.00 48.59           C  
ATOM   2064  CG  LEU B  39      17.532  89.560  -0.262  1.00 48.58           C  
ATOM   2065  CD1 LEU B  39      17.714  89.005  -1.713  1.00 47.23           C  
ATOM   2066  CD2 LEU B  39      16.835  88.559   0.633  1.00 46.42           C  
ATOM   2067  N   TYR B  40      21.494  90.989   1.241  1.00 53.15           N  
ATOM   2068  CA  TYR B  40      22.332  91.252   2.413  1.00 54.37           C  
ATOM   2069  C   TYR B  40      23.786  90.920   2.165  1.00 54.91           C  
ATOM   2070  O   TYR B  40      24.098  90.025   1.385  1.00 52.11           O  
ATOM   2071  CB  TYR B  40      21.836  90.432   3.621  1.00 53.83           C  
ATOM   2072  CG  TYR B  40      20.357  90.591   3.990  1.00 54.88           C  
ATOM   2073  CD1 TYR B  40      19.480  89.524   3.873  1.00 52.46           C  
ATOM   2074  CD2 TYR B  40      19.850  91.804   4.469  1.00 56.94           C  
ATOM   2075  CE1 TYR B  40      18.115  89.664   4.230  1.00 54.15           C  
ATOM   2076  CE2 TYR B  40      18.500  91.953   4.826  1.00 57.62           C  
ATOM   2077  CZ  TYR B  40      17.642  90.876   4.702  1.00 55.80           C  
ATOM   2078  OH  TYR B  40      16.300  90.999   5.045  1.00 57.75           O  
ATOM   2079  N   THR B  41      24.669  91.646   2.859  1.00 58.03           N  
ATOM   2080  CA  THR B  41      26.116  91.425   2.812  1.00 59.69           C  
ATOM   2081  C   THR B  41      26.659  91.193   4.237  1.00 61.44           C  
ATOM   2082  O   THR B  41      25.951  91.449   5.208  1.00 62.70           O  
ATOM   2083  CB  THR B  41      26.851  92.629   2.165  1.00 62.57           C  
ATOM   2084  OG1 THR B  41      26.738  93.777   3.014  1.00 66.92           O  
ATOM   2085  CG2 THR B  41      26.274  92.966   0.815  1.00 62.73           C  
ATOM   2086  N   PRO B  42      27.905  90.698   4.376  1.00 62.91           N  
ATOM   2087  CA  PRO B  42      28.552  90.583   5.693  1.00 65.69           C  
ATOM   2088  C   PRO B  42      28.674  91.934   6.405  1.00 70.12           C  
ATOM   2089  O   PRO B  42      29.091  91.999   7.572  1.00 72.50           O  
ATOM   2090  CB  PRO B  42      29.959  90.073   5.352  1.00 66.85           C  
ATOM   2091  CG  PRO B  42      29.850  89.482   4.032  1.00 63.78           C  
ATOM   2092  CD  PRO B  42      28.775  90.197   3.299  1.00 62.54           C  
ATOM   2093  N   ASN B  43      28.315  92.997   5.684  1.00 71.85           N  
ATOM   2094  CA  ASN B  43      28.430  94.376   6.154  1.00 76.34           C  
ATOM   2095  C   ASN B  43      27.128  94.971   6.703  1.00 76.61           C  
ATOM   2096  O   ASN B  43      27.169  95.910   7.497  1.00 80.65           O  
ATOM   2097  CB  ASN B  43      28.992  95.274   5.041  1.00 78.67           C  
ATOM   2098  CG  ASN B  43      30.493  95.418   5.116  1.00 82.17           C  
ATOM   2099  OD1 ASN B  43      31.245  94.576   4.621  1.00 81.02           O  
ATOM   2100  ND2 ASN B  43      30.943  96.500   5.734  1.00 88.54           N  
ATOM   2101  N   THR B  44      25.984  94.434   6.272  1.00 73.37           N  
ATOM   2102  CA  THR B  44      24.666  94.864   6.780  1.00 73.06           C  
ATOM   2103  C   THR B  44      24.712  95.051   8.303  1.00 75.03           C  
ATOM   2104  O   THR B  44      25.015  94.111   9.050  1.00 73.66           O  
ATOM   2105  CB  THR B  44      23.538  93.863   6.406  1.00 69.27           C  
ATOM   2106  OG1 THR B  44      23.604  93.539   5.007  1.00 67.30           O  
ATOM   2107  CG2 THR B  44      22.153  94.445   6.739  1.00 70.23           C  
ATOM   2108  N   GLU B  45      24.438  96.279   8.747  1.00 78.42           N  
ATOM   2109  CA  GLU B  45      24.568  96.647  10.156  1.00 81.16           C  
ATOM   2110  C   GLU B  45      23.403  96.116  10.986  1.00 79.20           C  
ATOM   2111  O   GLU B  45      23.588  95.710  12.141  1.00 80.70           O  
ATOM   2112  CB  GLU B  45      24.677  98.163  10.317  1.00 86.55           C  
ATOM   2113  CG  GLU B  45      25.271  98.595  11.656  1.00 91.46           C  
ATOM   2114  CD  GLU B  45      24.907 100.017  12.033  1.00 97.34           C  
ATOM   2115  OE1 GLU B  45      24.507 100.794  11.138  1.00 97.51           O  
ATOM   2116  OE2 GLU B  45      25.016 100.359  13.233  1.00101.32           O  
ATOM   2117  N   ARG B  46      22.207  96.141  10.404  1.00 76.04           N  
ATOM   2118  CA  ARG B  46      21.028  95.603  11.070  1.00 74.19           C  
ATOM   2119  C   ARG B  46      21.198  94.106  11.325  1.00 69.70           C  
ATOM   2120  O   ARG B  46      21.569  93.361  10.409  1.00 66.33           O  
ATOM   2121  CB  ARG B  46      19.768  95.836  10.224  1.00 73.17           C  
ATOM   2122  CG  ARG B  46      18.997  97.125  10.524  1.00 78.93           C  
ATOM   2123  CD  ARG B  46      17.558  97.007  10.003  1.00 81.89           C  
ATOM   2124  NE  ARG B  46      16.608  97.838  10.752  1.00 87.94           N  
ATOM   2125  CZ  ARG B  46      15.799  97.397  11.718  1.00 89.67           C  
ATOM   2126  NH1 ARG B  46      15.805  96.119  12.085  1.00 85.88           N  
ATOM   2127  NH2 ARG B  46      14.979  98.244  12.335  1.00 94.13           N  
ATOM   2128  N   ASN B  47      20.936  93.689  12.566  1.00 69.36           N  
ATOM   2129  CA  ASN B  47      20.938  92.284  12.964  1.00 65.38           C  
ATOM   2130  C   ASN B  47      19.516  91.733  12.946  1.00 62.40           C  
ATOM   2131  O   ASN B  47      18.720  91.980  13.858  1.00 63.73           O  
ATOM   2132  CB  ASN B  47      21.578  92.102  14.348  1.00 68.69           C  
ATOM   2133  CG  ASN B  47      21.871  90.642  14.676  1.00 67.05           C  
ATOM   2134  OD1 ASN B  47      21.289  89.721  14.094  1.00 65.86           O  
ATOM   2135  ND2 ASN B  47      22.792  90.424  15.601  1.00 71.13           N  
ATOM   2136  N   LEU B  48      19.230  90.970  11.895  1.00 57.86           N  
ATOM   2137  CA  LEU B  48      17.877  90.562  11.533  1.00 55.42           C  
ATOM   2138  C   LEU B  48      17.798  89.063  11.279  1.00 51.14           C  
ATOM   2139  O   LEU B  48      18.746  88.464  10.756  1.00 50.04           O  
ATOM   2140  CB  LEU B  48      17.452  91.241  10.221  1.00 54.85           C  
ATOM   2141  CG  LEU B  48      17.557  92.746  10.006  1.00 59.05           C  
ATOM   2142  CD1 LEU B  48      17.283  93.028   8.549  1.00 58.50           C  
ATOM   2143  CD2 LEU B  48      16.590  93.507  10.907  1.00 61.94           C  
ATOM   2144  N   VAL B  49      16.651  88.481  11.607  1.00 55.88           N  
ATOM   2145  CA  VAL B  49      16.328  87.115  11.208  1.00 52.04           C  
ATOM   2146  C   VAL B  49      15.248  87.228  10.147  1.00 50.78           C  
ATOM   2147  O   VAL B  49      14.359  88.082  10.255  1.00 50.44           O  
ATOM   2148  CB  VAL B  49      15.786  86.280  12.398  1.00 53.71           C  
ATOM   2149  CG1 VAL B  49      15.511  84.858  11.966  1.00 49.53           C  
ATOM   2150  CG2 VAL B  49      16.765  86.289  13.557  1.00 53.10           C  
ATOM   2151  N   PHE B  50      15.333  86.378   9.124  1.00 48.00           N  
ATOM   2152  CA  PHE B  50      14.412  86.430   8.017  1.00 47.14           C  
ATOM   2153  C   PHE B  50      14.070  85.013   7.520  1.00 46.89           C  
ATOM   2154  O   PHE B  50      14.839  84.058   7.693  1.00 46.11           O  
ATOM   2155  CB  PHE B  50      14.975  87.307   6.884  1.00 45.82           C  
ATOM   2156  CG  PHE B  50      16.070  86.643   6.076  1.00 45.65           C  
ATOM   2157  CD1 PHE B  50      15.745  85.800   4.983  1.00 42.33           C  
ATOM   2158  CD2 PHE B  50      17.425  86.896   6.374  1.00 42.64           C  
ATOM   2159  CE1 PHE B  50      16.750  85.183   4.231  1.00 42.08           C  
ATOM   2160  CE2 PHE B  50      18.437  86.304   5.632  1.00 41.75           C  
ATOM   2161  CZ  PHE B  50      18.103  85.421   4.561  1.00 42.94           C  
ATOM   2162  N   LEU B  51      12.891  84.873   6.936  1.00 47.26           N  
ATOM   2163  CA  LEU B  51      12.570  83.640   6.269  1.00 47.24           C  
ATOM   2164  C   LEU B  51      12.084  83.893   4.871  1.00 46.32           C  
ATOM   2165  O   LEU B  51      11.449  84.911   4.595  1.00 48.89           O  
ATOM   2166  CB  LEU B  51      11.575  82.778   7.069  1.00 49.35           C  
ATOM   2167  CG  LEU B  51      10.315  83.243   7.774  1.00 50.78           C  
ATOM   2168  CD1 LEU B  51       9.432  82.019   7.944  1.00 54.89           C  
ATOM   2169  CD2 LEU B  51      10.680  83.804   9.119  1.00 53.63           C  
ATOM   2170  N   VAL B  52      12.392  82.961   3.995  1.00 45.20           N  
ATOM   2171  CA  VAL B  52      11.899  82.976   2.630  1.00 45.69           C  
ATOM   2172  C   VAL B  52      10.421  82.616   2.609  1.00 46.40           C  
ATOM   2173  O   VAL B  52       9.995  81.567   3.137  1.00 46.91           O  
ATOM   2174  CB  VAL B  52      12.773  82.094   1.696  1.00 45.34           C  
ATOM   2175  CG1 VAL B  52      12.293  82.148   0.251  1.00 45.43           C  
ATOM   2176  CG2 VAL B  52      14.223  82.585   1.775  1.00 45.30           C  
ATOM   2177  N   LYS B  53       9.639  83.536   2.050  1.00 47.45           N  
ATOM   2178  CA  LYS B  53       8.217  83.319   1.849  1.00 48.96           C  
ATOM   2179  C   LYS B  53       8.018  82.658   0.503  1.00 49.76           C  
ATOM   2180  O   LYS B  53       7.310  81.660   0.387  1.00 51.77           O  
ATOM   2181  CB  LYS B  53       7.452  84.633   1.954  1.00 50.36           C  
ATOM   2182  CG  LYS B  53       5.926  84.490   1.762  1.00 52.24           C  
ATOM   2183  CD  LYS B  53       5.205  85.754   2.193  1.00 54.28           C  
ATOM   2184  CE  LYS B  53       3.699  85.632   1.963  1.00 58.45           C  
ATOM   2185  NZ  LYS B  53       3.095  87.001   1.755  1.00 60.30           N  
ATOM   2186  N   SER B  54       8.688  83.187  -0.509  1.00 49.28           N  
ATOM   2187  CA  SER B  54       8.593  82.650  -1.858  1.00 50.86           C  
ATOM   2188  C   SER B  54       9.835  83.013  -2.657  1.00 49.67           C  
ATOM   2189  O   SER B  54      10.489  84.015  -2.353  1.00 49.44           O  
ATOM   2190  CB  SER B  54       7.340  83.192  -2.556  1.00 52.76           C  
ATOM   2191  OG  SER B  54       7.534  84.549  -2.849  1.00 54.43           O  
ATOM   2192  N   GLY B  55      10.148  82.208  -3.670  1.00 50.09           N  
ATOM   2193  CA  GLY B  55      11.363  82.367  -4.459  1.00 49.92           C  
ATOM   2194  C   GLY B  55      12.552  81.622  -3.857  1.00 49.33           C  
ATOM   2195  O   GLY B  55      12.395  80.705  -3.055  1.00 49.07           O  
ATOM   2196  N   ARG B  56      13.755  82.016  -4.242  1.00 48.49           N  
ATOM   2197  CA  ARG B  56      14.944  81.447  -3.647  1.00 47.34           C  
ATOM   2198  C   ARG B  56      16.128  82.355  -3.665  1.00 46.34           C  
ATOM   2199  O   ARG B  56      16.258  83.273  -4.489  1.00 47.14           O  
ATOM   2200  CB  ARG B  56      15.323  80.075  -4.222  1.00 48.42           C  
ATOM   2201  CG  ARG B  56      15.106  79.946  -5.650  1.00 52.69           C  
ATOM   2202  CD  ARG B  56      14.496  78.586  -5.979  1.00 56.32           C  
ATOM   2203  NE  ARG B  56      15.539  77.592  -6.181  1.00 58.86           N  
ATOM   2204  CZ  ARG B  56      16.413  77.596  -7.184  1.00 60.01           C  
ATOM   2205  NH1 ARG B  56      16.375  78.551  -8.114  1.00 60.53           N  
ATOM   2206  NH2 ARG B  56      17.324  76.627  -7.255  1.00 58.77           N  
ATOM   2207  N   VAL B  57      17.000  82.045  -2.732  1.00 44.70           N  
ATOM   2208  CA  VAL B  57      18.028  82.919  -2.283  1.00 45.75           C  
ATOM   2209  C   VAL B  57      19.345  82.092  -2.205  1.00 44.87           C  
ATOM   2210  O   VAL B  57      19.372  81.025  -1.613  1.00 44.31           O  
ATOM   2211  CB  VAL B  57      17.559  83.498  -0.903  1.00 45.36           C  
ATOM   2212  CG1 VAL B  57      18.668  83.766   0.006  1.00 45.08           C  
ATOM   2213  CG2 VAL B  57      16.677  84.736  -1.116  1.00 46.66           C  
ATOM   2214  N   ARG B  58      20.402  82.590  -2.845  1.00 44.94           N  
ATOM   2215  CA  ARG B  58      21.743  81.971  -2.861  1.00 44.77           C  
ATOM   2216  C   ARG B  58      22.548  82.558  -1.696  1.00 43.08           C  
ATOM   2217  O   ARG B  58      22.619  83.769  -1.562  1.00 42.99           O  
ATOM   2218  CB  ARG B  58      22.426  82.344  -4.192  1.00 46.91           C  
ATOM   2219  CG  ARG B  58      23.786  81.709  -4.465  1.00 45.19           C  
ATOM   2220  CD  ARG B  58      24.314  82.250  -5.814  1.00 50.06           C  
ATOM   2221  NE  ARG B  58      25.775  82.203  -5.784  1.00 53.26           N  
ATOM   2222  CZ  ARG B  58      26.592  83.226  -5.990  1.00 53.26           C  
ATOM   2223  NH1 ARG B  58      26.138  84.433  -6.356  1.00 50.56           N  
ATOM   2224  NH2 ARG B  58      27.895  83.003  -5.889  1.00 54.74           N  
ATOM   2225  N   VAL B  59      23.086  81.704  -0.834  1.00 42.01           N  
ATOM   2226  CA  VAL B  59      23.962  82.120   0.272  1.00 41.15           C  
ATOM   2227  C   VAL B  59      25.391  81.757  -0.184  1.00 40.81           C  
ATOM   2228  O   VAL B  59      25.632  80.638  -0.570  1.00 39.41           O  
ATOM   2229  CB  VAL B  59      23.616  81.349   1.609  1.00 41.14           C  
ATOM   2230  CG1 VAL B  59      24.531  81.791   2.734  1.00 42.08           C  
ATOM   2231  CG2 VAL B  59      22.164  81.560   2.025  1.00 40.04           C  
ATOM   2232  N   TYR B  60      26.310  82.718  -0.169  1.00 41.44           N  
ATOM   2233  CA  TYR B  60      27.652  82.523  -0.716  1.00 41.69           C  
ATOM   2234  C   TYR B  60      28.700  83.318   0.059  1.00 42.87           C  
ATOM   2235  O   TYR B  60      28.388  84.338   0.664  1.00 43.19           O  
ATOM   2236  CB  TYR B  60      27.694  82.819  -2.235  1.00 42.78           C  
ATOM   2237  CG  TYR B  60      27.447  84.262  -2.648  1.00 42.94           C  
ATOM   2238  CD1 TYR B  60      26.143  84.772  -2.745  1.00 42.55           C  
ATOM   2239  CD2 TYR B  60      28.517  85.118  -2.919  1.00 45.89           C  
ATOM   2240  CE1 TYR B  60      25.903  86.083  -3.099  1.00 43.39           C  
ATOM   2241  CE2 TYR B  60      28.298  86.463  -3.291  1.00 45.76           C  
ATOM   2242  CZ  TYR B  60      26.983  86.919  -3.387  1.00 47.50           C  
ATOM   2243  OH  TYR B  60      26.735  88.224  -3.709  1.00 48.77           O  
ATOM   2244  N   LEU B  61      29.934  82.816   0.076  1.00 43.44           N  
ATOM   2245  CA  LEU B  61      31.074  83.586   0.579  1.00 44.61           C  
ATOM   2246  C   LEU B  61      31.746  84.273  -0.586  1.00 46.45           C  
ATOM   2247  O   LEU B  61      31.735  83.765  -1.686  1.00 46.79           O  
ATOM   2248  CB  LEU B  61      32.097  82.668   1.241  1.00 45.47           C  
ATOM   2249  CG  LEU B  61      31.607  81.760   2.348  1.00 41.31           C  
ATOM   2250  CD1 LEU B  61      32.705  80.832   2.695  1.00 40.61           C  
ATOM   2251  CD2 LEU B  61      31.133  82.582   3.530  1.00 38.79           C  
ATOM   2252  N   ALA B  62      32.298  85.460  -0.356  1.00 49.16           N  
ATOM   2253  CA  ALA B  62      33.016  86.150  -1.412  1.00 50.84           C  
ATOM   2254  C   ALA B  62      34.362  86.622  -0.917  1.00 53.28           C  
ATOM   2255  O   ALA B  62      34.522  87.037   0.241  1.00 53.59           O  
ATOM   2256  CB  ALA B  62      32.192  87.311  -1.978  1.00 51.79           C  
ATOM   2257  N   TYR B  63      35.342  86.549  -1.804  1.00 55.52           N  
ATOM   2258  CA  TYR B  63      36.669  87.038  -1.482  1.00 58.27           C  
ATOM   2259  C   TYR B  63      37.358  87.490  -2.768  1.00 60.97           C  
ATOM   2260  O   TYR B  63      37.555  86.705  -3.707  1.00 59.93           O  
ATOM   2261  CB  TYR B  63      37.453  85.955  -0.725  1.00 58.68           C  
ATOM   2262  CG  TYR B  63      38.861  86.331  -0.336  1.00 62.29           C  
ATOM   2263  CD1 TYR B  63      39.939  85.556  -0.749  1.00 62.79           C  
ATOM   2264  CD2 TYR B  63      39.117  87.484   0.418  1.00 65.49           C  
ATOM   2265  CE1 TYR B  63      41.246  85.906  -0.415  1.00 66.96           C  
ATOM   2266  CE2 TYR B  63      40.427  87.853   0.755  1.00 69.39           C  
ATOM   2267  CZ  TYR B  63      41.484  87.054   0.334  1.00 69.92           C  
ATOM   2268  OH  TYR B  63      42.782  87.415   0.651  1.00 74.31           O  
ATOM   2269  N   GLU B  64      37.707  88.776  -2.805  1.00 64.27           N  
ATOM   2270  CA  GLU B  64      38.327  89.380  -3.977  1.00 67.63           C  
ATOM   2271  C   GLU B  64      37.417  89.159  -5.194  1.00 66.60           C  
ATOM   2272  O   GLU B  64      36.262  89.550  -5.143  1.00 64.96           O  
ATOM   2273  CB  GLU B  64      39.759  88.862  -4.164  1.00 69.03           C  
ATOM   2274  CG  GLU B  64      40.720  89.438  -3.121  1.00 72.51           C  
ATOM   2275  CD  GLU B  64      42.177  89.049  -3.348  1.00 74.46           C  
ATOM   2276  OE1 GLU B  64      43.071  89.891  -3.091  1.00 78.86           O  
ATOM   2277  OE2 GLU B  64      42.425  87.900  -3.772  1.00 74.67           O  
ATOM   2278  N   ASP B  65      37.908  88.516  -6.254  1.00 67.56           N  
ATOM   2279  CA  ASP B  65      37.070  88.265  -7.442  1.00 67.58           C  
ATOM   2280  C   ASP B  65      36.422  86.868  -7.439  1.00 64.37           C  
ATOM   2281  O   ASP B  65      35.935  86.388  -8.479  1.00 64.51           O  
ATOM   2282  CB  ASP B  65      37.855  88.527  -8.753  1.00 70.59           C  
ATOM   2283  CG  ASP B  65      39.085  87.621  -8.905  1.00 72.72           C  
ATOM   2284  OD1 ASP B  65      39.689  87.615 -10.009  1.00 77.83           O  
ATOM   2285  OD2 ASP B  65      39.476  86.940  -7.927  1.00 67.85           O  
ATOM   2286  N   LYS B  66      36.423  86.228  -6.268  1.00 61.74           N  
ATOM   2287  CA  LYS B  66      35.964  84.842  -6.125  1.00 59.06           C  
ATOM   2288  C   LYS B  66      34.696  84.727  -5.272  1.00 55.10           C  
ATOM   2289  O   LYS B  66      34.462  85.530  -4.359  1.00 54.23           O  
ATOM   2290  CB  LYS B  66      37.075  83.971  -5.532  1.00 59.18           C  
ATOM   2291  CG  LYS B  66      38.432  84.073  -6.279  1.00 64.12           C  
ATOM   2292  CD  LYS B  66      39.468  83.074  -5.708  1.00 64.77           C  
ATOM   2293  CE  LYS B  66      40.280  83.655  -4.530  1.00 70.65           C  
ATOM   2294  NZ  LYS B  66      41.447  84.522  -4.940  1.00 77.09           N  
ATOM   2295  N   GLU B  67      33.879  83.725  -5.592  1.00 52.71           N  
ATOM   2296  CA  GLU B  67      32.691  83.388  -4.811  1.00 49.57           C  
ATOM   2297  C   GLU B  67      32.665  81.884  -4.511  1.00 47.98           C  
ATOM   2298  O   GLU B  67      33.151  81.062  -5.306  1.00 47.84           O  
ATOM   2299  CB  GLU B  67      31.411  83.809  -5.558  1.00 49.41           C  
ATOM   2300  CG  GLU B  67      31.239  85.307  -5.665  1.00 50.61           C  
ATOM   2301  CD  GLU B  67      29.933  85.737  -6.337  1.00 51.66           C  
ATOM   2302  OE1 GLU B  67      29.796  86.950  -6.627  1.00 52.09           O  
ATOM   2303  OE2 GLU B  67      29.053  84.880  -6.576  1.00 49.93           O  
ATOM   2304  N   PHE B  68      32.134  81.537  -3.341  1.00 45.79           N  
ATOM   2305  CA  PHE B  68      31.912  80.149  -2.983  1.00 44.99           C  
ATOM   2306  C   PHE B  68      30.476  80.046  -2.473  1.00 43.65           C  
ATOM   2307  O   PHE B  68      30.133  80.621  -1.459  1.00 42.96           O  
ATOM   2308  CB  PHE B  68      32.926  79.681  -1.931  1.00 45.55           C  
ATOM   2309  CG  PHE B  68      32.888  78.187  -1.656  1.00 42.90           C  
ATOM   2310  CD1 PHE B  68      33.637  77.301  -2.428  1.00 44.67           C  
ATOM   2311  CD2 PHE B  68      32.081  77.680  -0.657  1.00 40.58           C  
ATOM   2312  CE1 PHE B  68      33.593  75.917  -2.182  1.00 47.15           C  
ATOM   2313  CE2 PHE B  68      31.993  76.313  -0.416  1.00 42.23           C  
ATOM   2314  CZ  PHE B  68      32.753  75.420  -1.155  1.00 44.82           C  
ATOM   2315  N   THR B  69      29.637  79.347  -3.220  1.00 44.14           N  
ATOM   2316  CA  THR B  69      28.224  79.207  -2.880  1.00 44.11           C  
ATOM   2317  C   THR B  69      27.998  78.129  -1.800  1.00 42.62           C  
ATOM   2318  O   THR B  69      28.414  76.984  -1.962  1.00 43.03           O  
ATOM   2319  CB  THR B  69      27.392  78.883  -4.155  1.00 45.06           C  
ATOM   2320  OG1 THR B  69      27.344  80.043  -4.995  1.00 47.17           O  
ATOM   2321  CG2 THR B  69      25.965  78.505  -3.799  1.00 44.87           C  
ATOM   2322  N   LEU B  70      27.339  78.511  -0.715  1.00 41.58           N  
ATOM   2323  CA  LEU B  70      27.064  77.592   0.403  1.00 42.32           C  
ATOM   2324  C   LEU B  70      25.758  76.816   0.290  1.00 42.66           C  
ATOM   2325  O   LEU B  70      25.684  75.634   0.693  1.00 44.78           O  
ATOM   2326  CB  LEU B  70      27.054  78.352   1.741  1.00 41.10           C  
ATOM   2327  CG  LEU B  70      28.359  79.072   2.095  1.00 43.22           C  
ATOM   2328  CD1 LEU B  70      28.148  80.101   3.209  1.00 45.26           C  
ATOM   2329  CD2 LEU B  70      29.418  78.122   2.502  1.00 41.80           C  
ATOM   2330  N   ALA B  71      24.718  77.464  -0.216  1.00 41.83           N  
ATOM   2331  CA  ALA B  71      23.376  76.881  -0.160  1.00 42.32           C  
ATOM   2332  C   ALA B  71      22.403  77.747  -0.918  1.00 41.79           C  
ATOM   2333  O   ALA B  71      22.638  78.919  -1.100  1.00 41.10           O  
ATOM   2334  CB  ALA B  71      22.877  76.772   1.317  1.00 41.16           C  
ATOM   2335  N   ILE B  72      21.315  77.126  -1.351  1.00 42.09           N  
ATOM   2336  CA  ILE B  72      20.163  77.825  -1.832  1.00 42.62           C  
ATOM   2337  C   ILE B  72      19.003  77.648  -0.851  1.00 43.10           C  
ATOM   2338  O   ILE B  72      18.592  76.508  -0.559  1.00 44.35           O  
ATOM   2339  CB  ILE B  72      19.763  77.308  -3.218  1.00 44.23           C  
ATOM   2340  CG1 ILE B  72      20.898  77.617  -4.210  1.00 43.59           C  
ATOM   2341  CG2 ILE B  72      18.444  77.949  -3.661  1.00 44.46           C  
ATOM   2342  CD1 ILE B  72      20.854  76.761  -5.412  1.00 49.59           C  
ATOM   2343  N   LEU B  73      18.489  78.775  -0.357  1.00 41.67           N  
ATOM   2344  CA  LEU B  73      17.339  78.808   0.538  1.00 42.72           C  
ATOM   2345  C   LEU B  73      16.009  78.974  -0.204  1.00 44.62           C  
ATOM   2346  O   LEU B  73      15.863  79.827  -1.084  1.00 44.12           O  
ATOM   2347  CB  LEU B  73      17.499  79.927   1.571  1.00 41.66           C  
ATOM   2348  CG  LEU B  73      18.773  79.893   2.442  1.00 42.67           C  
ATOM   2349  CD1 LEU B  73      18.744  81.027   3.481  1.00 44.17           C  
ATOM   2350  CD2 LEU B  73      19.062  78.494   3.108  1.00 38.79           C  
ATOM   2351  N   GLU B  74      15.043  78.148   0.173  1.00 46.20           N  
ATOM   2352  CA  GLU B  74      13.737  78.109  -0.467  1.00 48.53           C  
ATOM   2353  C   GLU B  74      12.706  78.462   0.558  1.00 47.46           C  
ATOM   2354  O   GLU B  74      13.043  78.689   1.710  1.00 47.00           O  
ATOM   2355  CB  GLU B  74      13.448  76.707  -1.023  1.00 50.13           C  
ATOM   2356  CG  GLU B  74      14.399  76.359  -2.162  1.00 57.26           C  
ATOM   2357  CD  GLU B  74      14.286  74.910  -2.625  1.00 64.34           C  
ATOM   2358  OE1 GLU B  74      14.939  74.023  -2.005  1.00 68.38           O  
ATOM   2359  OE2 GLU B  74      13.571  74.673  -3.617  1.00 67.22           O  
ATOM   2360  N   ALA B  75      11.458  78.495   0.120  1.00 48.35           N  
ATOM   2361  CA  ALA B  75      10.308  78.788   0.961  1.00 48.53           C  
ATOM   2362  C   ALA B  75      10.332  77.983   2.262  1.00 48.16           C  
ATOM   2363  O   ALA B  75      10.393  76.760   2.238  1.00 49.35           O  
ATOM   2364  CB  ALA B  75       9.018  78.517   0.167  1.00 49.38           C  
ATOM   2365  N   GLY B  76      10.257  78.671   3.394  1.00 47.13           N  
ATOM   2366  CA  GLY B  76      10.310  77.999   4.676  1.00 46.85           C  
ATOM   2367  C   GLY B  76      11.663  78.092   5.358  1.00 46.98           C  
ATOM   2368  O   GLY B  76      11.758  77.847   6.569  1.00 47.71           O  
ATOM   2369  N   ASP B  77      12.716  78.433   4.610  1.00 45.15           N  
ATOM   2370  CA  ASP B  77      14.057  78.452   5.199  1.00 45.67           C  
ATOM   2371  C   ASP B  77      14.260  79.721   5.982  1.00 45.72           C  
ATOM   2372  O   ASP B  77      13.572  80.718   5.747  1.00 45.85           O  
ATOM   2373  CB  ASP B  77      15.163  78.264   4.164  1.00 44.55           C  
ATOM   2374  CG  ASP B  77      15.187  76.845   3.592  1.00 46.04           C  
ATOM   2375  OD1 ASP B  77      15.550  76.689   2.408  1.00 42.78           O  
ATOM   2376  OD2 ASP B  77      14.832  75.887   4.329  1.00 46.59           O  
ATOM   2377  N   ILE B  78      15.180  79.661   6.941  1.00 46.20           N  
ATOM   2378  CA  ILE B  78      15.425  80.767   7.846  1.00 47.58           C  
ATOM   2379  C   ILE B  78      16.928  81.050   7.838  1.00 47.44           C  
ATOM   2380  O   ILE B  78      17.757  80.128   7.716  1.00 47.88           O  
ATOM   2381  CB  ILE B  78      14.831  80.487   9.271  1.00 48.53           C  
ATOM   2382  CG1 ILE B  78      14.912  81.713  10.180  1.00 51.53           C  
ATOM   2383  CG2 ILE B  78      15.539  79.369   9.947  1.00 52.27           C  
ATOM   2384  CD1 ILE B  78      13.903  81.678  11.384  1.00 52.62           C  
ATOM   2385  N   PHE B  79      17.268  82.332   7.910  1.00 47.49           N  
ATOM   2386  CA  PHE B  79      18.647  82.771   7.969  1.00 46.77           C  
ATOM   2387  C   PHE B  79      18.698  84.056   8.769  1.00 48.28           C  
ATOM   2388  O   PHE B  79      17.767  84.365   9.491  1.00 48.03           O  
ATOM   2389  CB  PHE B  79      19.222  82.947   6.562  1.00 45.60           C  
ATOM   2390  CG  PHE B  79      20.731  82.803   6.486  1.00 45.53           C  
ATOM   2391  CD1 PHE B  79      21.358  81.598   6.829  1.00 44.39           C  
ATOM   2392  CD2 PHE B  79      21.520  83.853   6.032  1.00 44.55           C  
ATOM   2393  CE1 PHE B  79      22.770  81.472   6.744  1.00 45.25           C  
ATOM   2394  CE2 PHE B  79      22.924  83.722   5.941  1.00 46.95           C  
ATOM   2395  CZ  PHE B  79      23.540  82.520   6.300  1.00 44.00           C  
ATOM   2396  N   CYS B  80      19.802  84.780   8.650  1.00 48.92           N  
ATOM   2397  CA  CYS B  80      20.082  85.926   9.487  1.00 51.73           C  
ATOM   2398  C   CYS B  80      21.207  86.768   8.876  1.00 51.54           C  
ATOM   2399  O   CYS B  80      21.950  86.324   7.993  1.00 49.64           O  
ATOM   2400  CB  CYS B  80      20.402  85.497  10.938  1.00 53.37           C  
ATOM   2401  SG  CYS B  80      21.931  84.487  11.211  1.00 58.74           S  
ATOM   2402  N   THR B  81      21.302  88.009   9.321  1.00 53.07           N  
ATOM   2403  CA  THR B  81      22.388  88.863   8.888  1.00 53.76           C  
ATOM   2404  C   THR B  81      23.541  88.704   9.904  1.00 55.72           C  
ATOM   2405  O   THR B  81      23.423  87.939  10.846  1.00 55.89           O  
ATOM   2406  CB  THR B  81      21.874  90.322   8.651  1.00 55.07           C  
ATOM   2407  OG1 THR B  81      21.358  90.873   9.867  1.00 56.00           O  
ATOM   2408  CG2 THR B  81      20.752  90.307   7.624  1.00 52.36           C  
ATOM   2409  N   HIS B  82      24.669  89.370   9.714  1.00 58.19           N  
ATOM   2410  CA  HIS B  82      25.793  89.174  10.659  1.00 61.25           C  
ATOM   2411  C   HIS B  82      26.464  87.799  10.526  1.00 60.39           C  
ATOM   2412  O   HIS B  82      26.955  87.247  11.514  1.00 61.52           O  
ATOM   2413  CB  HIS B  82      25.336  89.347  12.116  1.00 63.65           C  
ATOM   2414  CG  HIS B  82      25.173  90.767  12.549  1.00 66.44           C  
ATOM   2415  ND1 HIS B  82      24.470  91.693  11.812  1.00 67.50           N  
ATOM   2416  CD2 HIS B  82      25.606  91.414  13.654  1.00 71.46           C  
ATOM   2417  CE1 HIS B  82      24.493  92.859  12.432  1.00 70.94           C  
ATOM   2418  NE2 HIS B  82      25.171  92.715  13.556  1.00 74.98           N  
ATOM   2419  N   THR B  83      26.464  87.244   9.321  1.00 54.75           N  
ATOM   2420  CA  THR B  83      27.308  86.097   9.034  1.00 55.92           C  
ATOM   2421  C   THR B  83      28.402  86.567   8.073  1.00 57.71           C  
ATOM   2422  O   THR B  83      28.428  87.737   7.674  1.00 59.21           O  
ATOM   2423  CB  THR B  83      26.522  84.888   8.408  1.00 53.24           C  
ATOM   2424  OG1 THR B  83      26.048  85.237   7.108  1.00 53.22           O  
ATOM   2425  CG2 THR B  83      25.339  84.418   9.266  1.00 51.84           C  
ATOM   2426  N   ARG B  84      29.311  85.663   7.714  1.00 58.72           N  
ATOM   2427  CA  ARG B  84      30.256  85.895   6.620  1.00 60.00           C  
ATOM   2428  C   ARG B  84      29.588  86.094   5.261  1.00 57.96           C  
ATOM   2429  O   ARG B  84      30.207  86.654   4.357  1.00 59.85           O  
ATOM   2430  CB  ARG B  84      31.199  84.710   6.484  1.00 60.62           C  
ATOM   2431  CG  ARG B  84      32.086  84.514   7.644  1.00 65.95           C  
ATOM   2432  CD  ARG B  84      32.721  85.806   8.058  1.00 71.65           C  
ATOM   2433  NE  ARG B  84      34.160  85.693   7.924  1.00 77.77           N  
ATOM   2434  CZ  ARG B  84      34.933  85.161   8.856  1.00 80.40           C  
ATOM   2435  NH1 ARG B  84      34.398  84.715   9.991  1.00 80.16           N  
ATOM   2436  NH2 ARG B  84      36.233  85.081   8.650  1.00 84.22           N  
ATOM   2437  N   ALA B  85      28.341  85.641   5.127  1.00 55.25           N  
ATOM   2438  CA  ALA B  85      27.720  85.366   3.831  1.00 52.83           C  
ATOM   2439  C   ALA B  85      26.989  86.529   3.204  1.00 52.33           C  
ATOM   2440  O   ALA B  85      26.343  87.323   3.902  1.00 52.35           O  
ATOM   2441  CB  ALA B  85      26.727  84.207   3.962  1.00 50.81           C  
ATOM   2442  N   PHE B  86      27.071  86.576   1.872  1.00 51.34           N  
ATOM   2443  CA  PHE B  86      26.167  87.347   1.054  1.00 50.60           C  
ATOM   2444  C   PHE B  86      24.929  86.506   0.700  1.00 48.83           C  
ATOM   2445  O   PHE B  86      24.958  85.263   0.662  1.00 47.02           O  
ATOM   2446  CB  PHE B  86      26.842  87.789  -0.240  1.00 51.89           C  
ATOM   2447  CG  PHE B  86      28.064  88.646  -0.045  1.00 55.15           C  
ATOM   2448  CD1 PHE B  86      29.268  88.093   0.355  1.00 54.83           C  
ATOM   2449  CD2 PHE B  86      28.011  90.010  -0.322  1.00 59.39           C  
ATOM   2450  CE1 PHE B  86      30.408  88.895   0.510  1.00 60.76           C  
ATOM   2451  CE2 PHE B  86      29.141  90.820  -0.190  1.00 60.62           C  
ATOM   2452  CZ  PHE B  86      30.344  90.259   0.230  1.00 61.98           C  
ATOM   2453  N   ILE B  87      23.857  87.219   0.397  1.00 48.55           N  
ATOM   2454  CA  ILE B  87      22.558  86.630   0.151  1.00 47.67           C  
ATOM   2455  C   ILE B  87      21.995  87.342  -1.066  1.00 47.51           C  
ATOM   2456  O   ILE B  87      21.846  88.558  -1.056  1.00 48.11           O  
ATOM   2457  CB  ILE B  87      21.624  86.831   1.374  1.00 47.80           C  
ATOM   2458  CG1 ILE B  87      22.144  86.027   2.584  1.00 48.74           C  
ATOM   2459  CG2 ILE B  87      20.206  86.430   1.033  1.00 46.58           C  
ATOM   2460  CD1 ILE B  87      21.800  86.688   3.943  1.00 52.31           C  
ATOM   2461  N   GLN B  88      21.703  86.558  -2.101  1.00 46.62           N  
ATOM   2462  CA  GLN B  88      21.229  87.053  -3.369  1.00 47.58           C  
ATOM   2463  C   GLN B  88      20.023  86.289  -3.900  1.00 46.70           C  
ATOM   2464  O   GLN B  88      20.074  85.094  -4.056  1.00 45.87           O  
ATOM   2465  CB  GLN B  88      22.344  86.962  -4.402  1.00 47.68           C  
ATOM   2466  CG  GLN B  88      21.915  87.414  -5.789  1.00 48.33           C  
ATOM   2467  CD  GLN B  88      23.040  87.244  -6.794  1.00 51.56           C  
ATOM   2468  OE1 GLN B  88      23.709  86.201  -6.810  1.00 52.10           O  
ATOM   2469  NE2 GLN B  88      23.271  88.263  -7.614  1.00 45.23           N  
ATOM   2470  N   ALA B  89      18.955  87.006  -4.216  1.00 48.43           N  
ATOM   2471  CA  ALA B  89      17.815  86.446  -4.930  1.00 49.35           C  
ATOM   2472  C   ALA B  89      18.227  85.856  -6.277  1.00 50.67           C  
ATOM   2473  O   ALA B  89      18.909  86.505  -7.106  1.00 51.66           O  
ATOM   2474  CB  ALA B  89      16.731  87.505  -5.123  1.00 50.75           C  
ATOM   2475  N   MET B  90      17.805  84.621  -6.488  1.00 50.59           N  
ATOM   2476  CA  MET B  90      17.984  83.940  -7.743  1.00 52.50           C  
ATOM   2477  C   MET B  90      16.730  84.019  -8.605  1.00 51.60           C  
ATOM   2478  O   MET B  90      16.714  83.605  -9.765  1.00 52.59           O  
ATOM   2479  CB  MET B  90      18.318  82.492  -7.441  1.00 51.07           C  
ATOM   2480  CG  MET B  90      19.757  82.310  -6.998  1.00 53.68           C  
ATOM   2481  SD  MET B  90      19.667  80.701  -6.276  1.00 59.88           S  
ATOM   2482  CE  MET B  90      20.284  79.722  -7.669  1.00 60.12           C  
ATOM   2483  N   GLU B  91      15.661  84.547  -8.039  1.00 51.22           N  
ATOM   2484  CA  GLU B  91      14.449  84.787  -8.818  1.00 52.02           C  
ATOM   2485  C   GLU B  91      13.677  85.801  -8.012  1.00 52.16           C  
ATOM   2486  O   GLU B  91      14.111  86.137  -6.923  1.00 51.97           O  
ATOM   2487  CB  GLU B  91      13.672  83.475  -9.045  1.00 51.77           C  
ATOM   2488  CG  GLU B  91      13.246  82.738  -7.767  1.00 52.59           C  
ATOM   2489  CD  GLU B  91      13.034  81.270  -7.997  1.00 55.10           C  
ATOM   2490  OE1 GLU B  91      13.993  80.576  -8.421  1.00 58.09           O  
ATOM   2491  OE2 GLU B  91      11.913  80.806  -7.753  1.00 56.60           O  
ATOM   2492  N   ASP B  92      12.562  86.319  -8.513  1.00 53.34           N  
ATOM   2493  CA  ASP B  92      11.824  87.277  -7.710  1.00 53.82           C  
ATOM   2494  C   ASP B  92      11.482  86.566  -6.421  1.00 52.09           C  
ATOM   2495  O   ASP B  92      10.977  85.438  -6.428  1.00 52.13           O  
ATOM   2496  CB  ASP B  92      10.535  87.743  -8.399  1.00 56.15           C  
ATOM   2497  CG  ASP B  92      10.791  88.628  -9.621  1.00 58.82           C  
ATOM   2498  OD1 ASP B  92       9.778  89.016 -10.245  1.00 61.66           O  
ATOM   2499  OD2 ASP B  92      11.960  88.939  -9.954  1.00 57.73           O  
ATOM   2500  N   THR B  93      11.781  87.196  -5.302  1.00 51.31           N  
ATOM   2501  CA  THR B  93      11.567  86.505  -4.040  1.00 50.11           C  
ATOM   2502  C   THR B  93      10.965  87.422  -3.036  1.00 50.54           C  
ATOM   2503  O   THR B  93      11.011  88.650  -3.181  1.00 52.46           O  
ATOM   2504  CB  THR B  93      12.843  85.723  -3.464  1.00 48.06           C  
ATOM   2505  OG1 THR B  93      13.348  86.326  -2.267  1.00 50.35           O  
ATOM   2506  CG2 THR B  93      13.908  85.497  -4.476  1.00 45.23           C  
ATOM   2507  N   THR B  94      10.337  86.804  -2.054  1.00 49.62           N  
ATOM   2508  CA  THR B  94       9.710  87.513  -0.952  1.00 50.85           C  
ATOM   2509  C   THR B  94      10.239  86.923   0.351  1.00 48.63           C  
ATOM   2510  O   THR B  94      10.353  85.691   0.497  1.00 46.36           O  
ATOM   2511  CB  THR B  94       8.171  87.376  -1.033  1.00 52.41           C  
ATOM   2512  OG1 THR B  94       7.682  88.247  -2.060  1.00 55.66           O  
ATOM   2513  CG2 THR B  94       7.515  87.757   0.268  1.00 55.40           C  
ATOM   2514  N   ILE B  95      10.589  87.807   1.279  1.00 48.65           N  
ATOM   2515  CA  ILE B  95      11.049  87.381   2.583  1.00 47.96           C  
ATOM   2516  C   ILE B  95      10.222  88.027   3.672  1.00 49.83           C  
ATOM   2517  O   ILE B  95       9.643  89.069   3.458  1.00 52.30           O  
ATOM   2518  CB  ILE B  95      12.544  87.737   2.807  1.00 47.37           C  
ATOM   2519  CG1 ILE B  95      12.712  89.264   2.929  1.00 48.00           C  
ATOM   2520  CG2 ILE B  95      13.449  87.080   1.733  1.00 44.77           C  
ATOM   2521  CD1 ILE B  95      13.965  89.710   3.669  1.00 46.62           C  
ATOM   2522  N   LEU B  96      10.177  87.397   4.840  1.00 49.88           N  
ATOM   2523  CA  LEU B  96       9.681  88.036   6.056  1.00 51.05           C  
ATOM   2524  C   LEU B  96      10.847  88.209   7.015  1.00 50.28           C  
ATOM   2525  O   LEU B  96      11.611  87.285   7.235  1.00 49.08           O  
ATOM   2526  CB  LEU B  96       8.607  87.168   6.698  1.00 51.70           C  
ATOM   2527  CG  LEU B  96       7.390  86.826   5.822  1.00 54.58           C  
ATOM   2528  CD1 LEU B  96       6.713  85.559   6.313  1.00 52.73           C  
ATOM   2529  CD2 LEU B  96       6.409  88.001   5.794  1.00 55.81           C  
ATOM   2530  N   TYR B  97      11.016  89.400   7.561  1.00 52.23           N  
ATOM   2531  CA  TYR B  97      12.134  89.643   8.461  1.00 52.48           C  
ATOM   2532  C   TYR B  97      11.638  90.308   9.746  1.00 53.92           C  
ATOM   2533  O   TYR B  97      10.604  90.983   9.752  1.00 55.18           O  
ATOM   2534  CB  TYR B  97      13.225  90.507   7.793  1.00 53.20           C  
ATOM   2535  CG  TYR B  97      12.906  92.005   7.782  1.00 55.55           C  
ATOM   2536  CD1 TYR B  97      13.378  92.858   8.791  1.00 56.93           C  
ATOM   2537  CD2 TYR B  97      12.125  92.559   6.771  1.00 56.67           C  
ATOM   2538  CE1 TYR B  97      13.064  94.226   8.796  1.00 60.28           C  
ATOM   2539  CE2 TYR B  97      11.810  93.935   6.762  1.00 60.52           C  
ATOM   2540  CZ  TYR B  97      12.282  94.759   7.772  1.00 62.07           C  
ATOM   2541  OH  TYR B  97      11.948  96.110   7.748  1.00 66.75           O  
ATOM   2542  N   THR B  98      12.367  90.079  10.830  1.00 53.46           N  
ATOM   2543  CA  THR B  98      12.230  90.889  12.025  1.00 55.26           C  
ATOM   2544  C   THR B  98      13.607  91.056  12.669  1.00 56.14           C  
ATOM   2545  O   THR B  98      14.540  90.325  12.343  1.00 53.64           O  
ATOM   2546  CB  THR B  98      11.188  90.311  13.045  1.00 55.25           C  
ATOM   2547  OG1 THR B  98      10.949  91.293  14.056  1.00 57.64           O  
ATOM   2548  CG2 THR B  98      11.668  89.022  13.715  1.00 52.38           C  
ATOM   2549  N   ASP B  99      13.700  91.995  13.601  1.00 58.60           N  
ATOM   2550  CA  ASP B  99      14.939  92.314  14.307  1.00 61.19           C  
ATOM   2551  C   ASP B  99      15.290  91.209  15.309  1.00 60.19           C  
ATOM   2552  O   ASP B  99      14.399  90.574  15.877  1.00 59.23           O  
ATOM   2553  CB  ASP B  99      14.782  93.696  14.986  1.00 64.67           C  
ATOM   2554  CG  ASP B  99      16.027  94.137  15.743  1.00 69.80           C  
ATOM   2555  OD1 ASP B  99      16.225  93.683  16.907  1.00 71.30           O  
ATOM   2556  OD2 ASP B  99      16.795  94.966  15.182  1.00 73.37           O  
ATOM   2557  N   ILE B 100      16.587  90.978  15.518  1.00 61.10           N  
ATOM   2558  CA  ILE B 100      17.059  89.934  16.437  1.00 61.80           C  
ATOM   2559  C   ILE B 100      16.439  90.004  17.856  1.00 64.07           C  
ATOM   2560  O   ILE B 100      16.206  88.965  18.484  1.00 63.92           O  
ATOM   2561  CB  ILE B 100      18.642  89.826  16.485  1.00 62.58           C  
ATOM   2562  CG1 ILE B 100      19.109  88.603  17.296  1.00 62.30           C  
ATOM   2563  CG2 ILE B 100      19.292  91.087  17.036  1.00 66.22           C  
ATOM   2564  CD1 ILE B 100      18.523  87.236  16.796  1.00 59.45           C  
ATOM   2565  N   ARG B 101      16.157  91.208  18.346  1.00 67.03           N  
ATOM   2566  CA  ARG B 101      15.477  91.377  19.634  1.00 69.44           C  
ATOM   2567  C   ARG B 101      14.020  90.885  19.612  1.00 67.79           C  
ATOM   2568  O   ARG B 101      13.585  90.211  20.536  1.00 68.02           O  
ATOM   2569  CB  ARG B 101      15.535  92.834  20.114  1.00 72.79           C  
ATOM   2570  CG  ARG B 101      15.127  93.019  21.580  1.00 78.20           C  
ATOM   2571  CD  ARG B 101      16.266  93.592  22.436  1.00 84.30           C  
ATOM   2572  NE  ARG B 101      15.888  93.680  23.848  1.00 88.60           N  
ATOM   2573  CZ  ARG B 101      15.749  94.805  24.555  1.00 93.22           C  
ATOM   2574  NH1 ARG B 101      15.963  96.001  24.011  1.00 95.97           N  
ATOM   2575  NH2 ARG B 101      15.400  94.728  25.833  1.00 95.02           N  
ATOM   2576  N   ASN B 102      13.274  91.234  18.570  1.00 67.22           N  
ATOM   2577  CA  ASN B 102      11.910  90.748  18.397  1.00 66.64           C  
ATOM   2578  C   ASN B 102      11.846  89.233  18.271  1.00 64.18           C  
ATOM   2579  O   ASN B 102      11.012  88.599  18.912  1.00 64.12           O  
ATOM   2580  CB  ASN B 102      11.288  91.317  17.131  1.00 66.65           C  
ATOM   2581  CG  ASN B 102      10.927  92.772  17.243  1.00 70.96           C  
ATOM   2582  OD1 ASN B 102      10.621  93.399  16.232  1.00 73.50           O  
ATOM   2583  ND2 ASN B 102      10.950  93.328  18.458  1.00 75.47           N  
ATOM   2584  N   PHE B 103      12.721  88.670  17.434  1.00 62.09           N  
ATOM   2585  CA  PHE B 103      12.807  87.213  17.247  1.00 60.06           C  
ATOM   2586  C   PHE B 103      13.044  86.485  18.564  1.00 60.43           C  
ATOM   2587  O   PHE B 103      12.417  85.460  18.818  1.00 59.47           O  
ATOM   2588  CB  PHE B 103      13.878  86.834  16.206  1.00 58.35           C  
ATOM   2589  CG  PHE B 103      13.943  85.361  15.904  1.00 57.56           C  
ATOM   2590  CD1 PHE B 103      12.941  84.738  15.137  1.00 58.41           C  
ATOM   2591  CD2 PHE B 103      15.009  84.593  16.368  1.00 56.43           C  
ATOM   2592  CE1 PHE B 103      13.007  83.371  14.852  1.00 57.50           C  
ATOM   2593  CE2 PHE B 103      15.077  83.246  16.097  1.00 55.53           C  
ATOM   2594  CZ  PHE B 103      14.079  82.629  15.331  1.00 55.44           C  
ATOM   2595  N   GLN B 104      13.913  87.030  19.411  1.00 62.24           N  
ATOM   2596  CA  GLN B 104      14.101  86.480  20.765  1.00 64.03           C  
ATOM   2597  C   GLN B 104      12.866  86.597  21.681  1.00 65.21           C  
ATOM   2598  O   GLN B 104      12.567  85.670  22.439  1.00 65.15           O  
ATOM   2599  CB  GLN B 104      15.375  87.038  21.413  1.00 66.05           C  
ATOM   2600  CG  GLN B 104      16.650  86.496  20.725  1.00 65.53           C  
ATOM   2601  CD  GLN B 104      17.960  87.142  21.188  1.00 68.39           C  
ATOM   2602  OE1 GLN B 104      17.967  88.112  21.968  1.00 72.70           O  
ATOM   2603  NE2 GLN B 104      19.084  86.603  20.697  1.00 67.08           N  
ATOM   2604  N   ASN B 105      12.149  87.720  21.608  1.00 67.01           N  
ATOM   2605  CA  ASN B 105      10.872  87.875  22.322  1.00 68.72           C  
ATOM   2606  C   ASN B 105       9.815  86.862  21.833  1.00 66.94           C  
ATOM   2607  O   ASN B 105       9.063  86.303  22.625  1.00 67.91           O  
ATOM   2608  CB  ASN B 105      10.318  89.299  22.165  1.00 70.92           C  
ATOM   2609  CG  ASN B 105      11.076  90.354  22.989  1.00 74.98           C  
ATOM   2610  OD1 ASN B 105      11.737  90.056  23.992  1.00 77.06           O  
ATOM   2611  ND2 ASN B 105      10.958  91.611  22.559  1.00 76.06           N  
ATOM   2612  N   ILE B 106       9.760  86.646  20.522  1.00 65.06           N  
ATOM   2613  CA  ILE B 106       8.908  85.625  19.917  1.00 63.50           C  
ATOM   2614  C   ILE B 106       9.252  84.228  20.462  1.00 62.94           C  
ATOM   2615  O   ILE B 106       8.375  83.502  20.955  1.00 63.44           O  
ATOM   2616  CB  ILE B 106       9.050  85.635  18.363  1.00 62.32           C  
ATOM   2617  CG1 ILE B 106       8.447  86.933  17.777  1.00 63.06           C  
ATOM   2618  CG2 ILE B 106       8.443  84.348  17.734  1.00 60.87           C  
ATOM   2619  CD1 ILE B 106       8.873  87.234  16.357  1.00 61.29           C  
ATOM   2620  N   VAL B 107      10.532  83.867  20.359  1.00 61.58           N  
ATOM   2621  CA  VAL B 107      11.026  82.562  20.795  1.00 60.70           C  
ATOM   2622  C   VAL B 107      10.714  82.310  22.275  1.00 62.29           C  
ATOM   2623  O   VAL B 107      10.487  81.183  22.667  1.00 63.15           O  
ATOM   2624  CB  VAL B 107      12.553  82.406  20.474  1.00 60.08           C  
ATOM   2625  CG1 VAL B 107      13.161  81.273  21.228  1.00 59.38           C  
ATOM   2626  CG2 VAL B 107      12.765  82.214  18.964  1.00 57.25           C  
ATOM   2627  N   VAL B 108      10.687  83.371  23.076  1.00 63.72           N  
ATOM   2628  CA  VAL B 108      10.382  83.281  24.505  1.00 65.34           C  
ATOM   2629  C   VAL B 108       8.870  83.268  24.771  1.00 65.92           C  
ATOM   2630  O   VAL B 108       8.413  82.556  25.657  1.00 66.99           O  
ATOM   2631  CB  VAL B 108      11.082  84.420  25.308  1.00 67.36           C  
ATOM   2632  CG1 VAL B 108      10.329  84.761  26.616  1.00 68.54           C  
ATOM   2633  CG2 VAL B 108      12.531  84.054  25.577  1.00 66.63           C  
ATOM   2634  N   GLU B 109       8.102  84.035  24.004  1.00 65.55           N  
ATOM   2635  CA  GLU B 109       6.641  84.028  24.150  1.00 66.87           C  
ATOM   2636  C   GLU B 109       6.010  82.735  23.654  1.00 64.97           C  
ATOM   2637  O   GLU B 109       4.988  82.305  24.194  1.00 66.14           O  
ATOM   2638  CB  GLU B 109       5.981  85.223  23.436  1.00 67.83           C  
ATOM   2639  CG  GLU B 109       4.998  85.954  24.349  1.00 74.14           C  
ATOM   2640  CD  GLU B 109       3.681  86.351  23.685  1.00 78.68           C  
ATOM   2641  OE1 GLU B 109       3.713  86.868  22.545  1.00 81.12           O  
ATOM   2642  OE2 GLU B 109       2.615  86.167  24.325  1.00 79.54           O  
ATOM   2643  N   PHE B 110       6.638  82.137  22.633  1.00 62.30           N  
ATOM   2644  CA  PHE B 110       6.166  80.957  21.911  1.00 61.00           C  
ATOM   2645  C   PHE B 110       7.319  79.941  21.775  1.00 60.44           C  
ATOM   2646  O   PHE B 110       7.867  79.773  20.694  1.00 57.54           O  
ATOM   2647  CB  PHE B 110       5.672  81.364  20.508  1.00 60.09           C  
ATOM   2648  CG  PHE B 110       4.389  82.188  20.519  1.00 61.76           C  
ATOM   2649  CD1 PHE B 110       3.139  81.562  20.504  1.00 61.69           C  
ATOM   2650  CD2 PHE B 110       4.437  83.578  20.552  1.00 62.75           C  
ATOM   2651  CE1 PHE B 110       1.949  82.309  20.533  1.00 63.83           C  
ATOM   2652  CE2 PHE B 110       3.243  84.346  20.592  1.00 65.86           C  
ATOM   2653  CZ  PHE B 110       2.003  83.704  20.573  1.00 64.49           C  
ATOM   2654  N   PRO B 111       7.674  79.238  22.870  1.00 61.89           N  
ATOM   2655  CA  PRO B 111       8.919  78.473  22.846  1.00 61.91           C  
ATOM   2656  C   PRO B 111       8.908  77.334  21.835  1.00 62.08           C  
ATOM   2657  O   PRO B 111       9.972  76.901  21.418  1.00 60.72           O  
ATOM   2658  CB  PRO B 111       9.016  77.911  24.268  1.00 63.78           C  
ATOM   2659  CG  PRO B 111       8.047  78.725  25.090  1.00 64.15           C  
ATOM   2660  CD  PRO B 111       6.957  79.068  24.143  1.00 63.22           C  
ATOM   2661  N   ALA B 112       7.715  76.875  21.437  1.00 63.67           N  
ATOM   2662  CA  ALA B 112       7.584  75.734  20.516  1.00 64.37           C  
ATOM   2663  C   ALA B 112       7.910  76.130  19.098  1.00 63.63           C  
ATOM   2664  O   ALA B 112       8.225  75.280  18.275  1.00 63.29           O  
ATOM   2665  CB  ALA B 112       6.188  75.121  20.587  1.00 65.57           C  
ATOM   2666  N   PHE B 113       7.803  77.424  18.808  1.00 64.07           N  
ATOM   2667  CA  PHE B 113       8.255  77.961  17.526  1.00 63.38           C  
ATOM   2668  C   PHE B 113       9.722  77.616  17.203  1.00 62.57           C  
ATOM   2669  O   PHE B 113      10.071  77.411  16.053  1.00 62.35           O  
ATOM   2670  CB  PHE B 113       8.041  79.476  17.458  1.00 62.91           C  
ATOM   2671  CG  PHE B 113       8.284  80.048  16.092  1.00 62.51           C  
ATOM   2672  CD1 PHE B 113       7.342  79.875  15.073  1.00 62.01           C  
ATOM   2673  CD2 PHE B 113       9.453  80.738  15.815  1.00 62.27           C  
ATOM   2674  CE1 PHE B 113       7.554  80.381  13.813  1.00 60.80           C  
ATOM   2675  CE2 PHE B 113       9.672  81.268  14.535  1.00 63.47           C  
ATOM   2676  CZ  PHE B 113       8.713  81.085  13.536  1.00 61.13           C  
ATOM   2677  N   SER B 114      10.563  77.576  18.225  1.00 63.54           N  
ATOM   2678  CA  SER B 114      11.944  77.136  18.111  1.00 64.04           C  
ATOM   2679  C   SER B 114      12.115  75.719  17.616  1.00 64.24           C  
ATOM   2680  O   SER B 114      13.132  75.405  17.000  1.00 63.75           O  
ATOM   2681  CB  SER B 114      12.616  77.212  19.478  1.00 65.51           C  
ATOM   2682  OG  SER B 114      12.907  78.553  19.788  1.00 68.06           O  
ATOM   2683  N   LEU B 115      11.159  74.842  17.931  1.00 64.89           N  
ATOM   2684  CA  LEU B 115      11.283  73.445  17.529  1.00 65.41           C  
ATOM   2685  C   LEU B 115      11.148  73.323  16.027  1.00 64.34           C  
ATOM   2686  O   LEU B 115      11.899  72.574  15.399  1.00 63.88           O  
ATOM   2687  CB  LEU B 115      10.277  72.560  18.249  1.00 67.22           C  
ATOM   2688  CG  LEU B 115      10.787  71.839  19.496  1.00 69.71           C  
ATOM   2689  CD1 LEU B 115      11.833  72.643  20.287  1.00 70.18           C  
ATOM   2690  CD2 LEU B 115       9.602  71.473  20.365  1.00 70.86           C  
ATOM   2691  N   ASN B 116      10.192  74.076  15.477  1.00 63.55           N  
ATOM   2692  CA  ASN B 116      10.043  74.267  14.045  1.00 62.75           C  
ATOM   2693  C   ASN B 116      11.281  74.962  13.454  1.00 61.64           C  
ATOM   2694  O   ASN B 116      11.712  74.618  12.355  1.00 59.96           O  
ATOM   2695  CB  ASN B 116       8.800  75.119  13.731  1.00 62.82           C  
ATOM   2696  CG  ASN B 116       7.498  74.525  14.276  1.00 64.61           C  
ATOM   2697  OD1 ASN B 116       7.181  74.646  15.460  1.00 64.23           O  
ATOM   2698  ND2 ASN B 116       6.725  73.913  13.392  1.00 65.28           N  
ATOM   2699  N   MET B 117      11.820  75.957  14.169  1.00 62.07           N  
ATOM   2700  CA  MET B 117      13.014  76.694  13.702  1.00 62.73           C  
ATOM   2701  C   MET B 117      14.184  75.720  13.566  1.00 61.69           C  
ATOM   2702  O   MET B 117      14.774  75.593  12.493  1.00 61.13           O  
ATOM   2703  CB  MET B 117      13.370  77.838  14.658  1.00 62.69           C  
ATOM   2704  CG  MET B 117      14.388  78.863  14.099  1.00 65.49           C  
ATOM   2705  SD  MET B 117      15.343  79.805  15.355  1.00 68.95           S  
ATOM   2706  CE  MET B 117      16.696  78.653  15.670  1.00 69.62           C  
ATOM   2707  N   VAL B 118      14.488  75.005  14.645  1.00 61.95           N  
ATOM   2708  CA  VAL B 118      15.592  74.036  14.658  1.00 62.16           C  
ATOM   2709  C   VAL B 118      15.536  72.997  13.534  1.00 61.95           C  
ATOM   2710  O   VAL B 118      16.556  72.708  12.899  1.00 62.21           O  
ATOM   2711  CB  VAL B 118      15.688  73.350  16.023  1.00 63.74           C  
ATOM   2712  CG1 VAL B 118      16.948  72.538  16.135  1.00 63.22           C  
ATOM   2713  CG2 VAL B 118      15.676  74.419  17.100  1.00 65.25           C  
ATOM   2714  N   LYS B 119      14.351  72.440  13.290  1.00 61.37           N  
ATOM   2715  CA  LYS B 119      14.152  71.469  12.216  1.00 61.56           C  
ATOM   2716  C   LYS B 119      14.615  71.973  10.870  1.00 59.85           C  
ATOM   2717  O   LYS B 119      15.195  71.201  10.119  1.00 60.91           O  
ATOM   2718  CB  LYS B 119      12.685  71.074  12.077  1.00 62.91           C  
ATOM   2719  CG  LYS B 119      12.094  70.214  13.199  1.00 65.07           C  
ATOM   2720  CD  LYS B 119      10.586  70.476  13.301  1.00 67.66           C  
ATOM   2721  CE  LYS B 119       9.914  70.596  11.912  1.00 69.66           C  
ATOM   2722  NZ  LYS B 119       8.746  71.559  11.867  1.00 69.77           N  
ATOM   2723  N   VAL B 120      14.337  73.245  10.548  1.00 57.04           N  
ATOM   2724  CA  VAL B 120      14.761  73.805   9.261  1.00 54.91           C  
ATOM   2725  C   VAL B 120      16.248  74.173   9.258  1.00 52.73           C  
ATOM   2726  O   VAL B 120      16.953  73.904   8.293  1.00 53.75           O  
ATOM   2727  CB  VAL B 120      13.848  75.003   8.745  1.00 54.13           C  
ATOM   2728  CG1 VAL B 120      14.125  76.291   9.467  1.00 54.10           C  
ATOM   2729  CG2 VAL B 120      14.091  75.246   7.313  1.00 52.71           C  
ATOM   2730  N   LEU B 121      16.695  74.803  10.336  1.00 50.26           N  
ATOM   2731  CA  LEU B 121      18.075  75.148  10.554  1.00 48.81           C  
ATOM   2732  C   LEU B 121      19.000  73.913  10.449  1.00 48.55           C  
ATOM   2733  O   LEU B 121      20.083  74.002   9.843  1.00 48.79           O  
ATOM   2734  CB  LEU B 121      18.211  75.815  11.915  1.00 50.04           C  
ATOM   2735  CG  LEU B 121      19.383  76.781  12.061  1.00 55.11           C  
ATOM   2736  CD1 LEU B 121      19.013  77.981  12.927  1.00 57.37           C  
ATOM   2737  CD2 LEU B 121      20.609  76.076  12.637  1.00 59.34           C  
ATOM   2738  N   GLY B 122      18.548  72.792  11.011  1.00 63.92           N  
ATOM   2739  CA  GLY B 122      19.223  71.506  10.960  1.00 61.17           C  
ATOM   2740  C   GLY B 122      19.587  71.063   9.563  1.00 57.95           C  
ATOM   2741  O   GLY B 122      20.698  70.575   9.344  1.00 55.73           O  
ATOM   2742  N   ASP B 123      18.664  71.238   8.618  1.00 57.79           N  
ATOM   2743  CA  ASP B 123      18.924  70.951   7.198  1.00 56.16           C  
ATOM   2744  C   ASP B 123      20.068  71.818   6.684  1.00 51.77           C  
ATOM   2745  O   ASP B 123      20.914  71.353   5.901  1.00 51.03           O  
ATOM   2746  CB  ASP B 123      17.681  71.213   6.330  1.00 59.27           C  
ATOM   2747  CG  ASP B 123      16.439  70.446   6.800  1.00 65.08           C  
ATOM   2748  OD1 ASP B 123      15.311  70.743   6.291  1.00 70.16           O  
ATOM   2749  OD2 ASP B 123      16.577  69.564   7.683  1.00 68.98           O  
ATOM   2750  N   LEU B 124      20.112  73.084   7.109  1.00 48.33           N  
ATOM   2751  CA  LEU B 124      21.166  73.951   6.601  1.00 45.68           C  
ATOM   2752  C   LEU B 124      22.523  73.547   7.178  1.00 42.75           C  
ATOM   2753  O   LEU B 124      23.496  73.545   6.447  1.00 41.62           O  
ATOM   2754  CB  LEU B 124      20.859  75.455   6.783  1.00 45.42           C  
ATOM   2755  CG  LEU B 124      21.936  76.498   6.469  1.00 45.32           C  
ATOM   2756  CD1 LEU B 124      22.587  76.265   5.141  1.00 43.32           C  
ATOM   2757  CD2 LEU B 124      21.332  77.928   6.523  1.00 46.51           C  
ATOM   2758  N   LEU B 125      22.561  73.211   8.465  1.00 42.72           N  
ATOM   2759  CA  LEU B 125      23.766  72.760   9.169  1.00 42.91           C  
ATOM   2760  C   LEU B 125      24.292  71.492   8.579  1.00 42.43           C  
ATOM   2761  O   LEU B 125      25.482  71.347   8.441  1.00 42.48           O  
ATOM   2762  CB  LEU B 125      23.504  72.498  10.660  1.00 44.99           C  
ATOM   2763  CG  LEU B 125      22.948  73.688  11.423  1.00 46.65           C  
ATOM   2764  CD1 LEU B 125      22.716  73.390  12.934  1.00 47.34           C  
ATOM   2765  CD2 LEU B 125      23.876  74.896  11.229  1.00 47.28           C  
ATOM   2766  N   LYS B 126      23.396  70.583   8.217  1.00 44.10           N  
ATOM   2767  CA  LYS B 126      23.759  69.312   7.630  1.00 44.89           C  
ATOM   2768  C   LYS B 126      24.532  69.635   6.375  1.00 43.36           C  
ATOM   2769  O   LYS B 126      25.626  69.159   6.123  1.00 43.23           O  
ATOM   2770  CB  LYS B 126      22.490  68.541   7.269  1.00 49.21           C  
ATOM   2771  CG  LYS B 126      22.759  67.302   6.406  1.00 53.40           C  
ATOM   2772  CD  LYS B 126      21.551  66.404   6.282  1.00 55.79           C  
ATOM   2773  CE  LYS B 126      22.073  64.994   6.087  1.00 62.30           C  
ATOM   2774  NZ  LYS B 126      21.043  64.066   5.628  1.00 67.42           N  
ATOM   2775  N   LEU B 127      23.936  70.491   5.589  1.00 43.80           N  
ATOM   2776  CA  LEU B 127      24.486  70.942   4.349  1.00 43.96           C  
ATOM   2777  C   LEU B 127      25.881  71.535   4.496  1.00 40.47           C  
ATOM   2778  O   LEU B 127      26.799  71.164   3.761  1.00 41.25           O  
ATOM   2779  CB  LEU B 127      23.490  71.950   3.826  1.00 46.31           C  
ATOM   2780  CG  LEU B 127      23.385  72.292   2.378  1.00 51.54           C  
ATOM   2781  CD1 LEU B 127      21.937  72.723   2.043  1.00 51.20           C  
ATOM   2782  CD2 LEU B 127      24.359  73.437   2.202  1.00 51.14           C  
ATOM   2783  N   LEU B 128      26.055  72.420   5.471  1.00 37.55           N  
ATOM   2784  CA  LEU B 128      27.340  73.065   5.695  1.00 35.72           C  
ATOM   2785  C   LEU B 128      28.397  72.072   6.185  1.00 35.57           C  
ATOM   2786  O   LEU B 128      29.554  72.228   5.844  1.00 34.91           O  
ATOM   2787  CB  LEU B 128      27.197  74.204   6.702  1.00 34.92           C  
ATOM   2788  CG  LEU B 128      26.232  75.359   6.379  1.00 35.72           C  
ATOM   2789  CD1 LEU B 128      26.112  76.222   7.636  1.00 34.23           C  
ATOM   2790  CD2 LEU B 128      26.692  76.183   5.131  1.00 32.38           C  
ATOM   2791  N   LEU B 129      28.007  71.051   6.979  1.00 36.43           N  
ATOM   2792  CA  LEU B 129      28.948  70.028   7.423  1.00 37.13           C  
ATOM   2793  C   LEU B 129      29.413  69.123   6.277  1.00 38.37           C  
ATOM   2794  O   LEU B 129      30.556  68.626   6.267  1.00 39.80           O  
ATOM   2795  CB  LEU B 129      28.297  69.190   8.521  1.00 39.19           C  
ATOM   2796  CG  LEU B 129      28.769  69.284   9.968  1.00 41.71           C  
ATOM   2797  CD1 LEU B 129      29.131  70.690  10.405  1.00 39.79           C  
ATOM   2798  CD2 LEU B 129      27.800  68.604  10.968  1.00 43.65           C  
ATOM   2799  N   THR B 130      28.505  68.847   5.342  1.00 39.39           N  
ATOM   2800  CA  THR B 130      28.847  68.162   4.111  1.00 42.00           C  
ATOM   2801  C   THR B 130      29.923  68.941   3.311  1.00 42.39           C  
ATOM   2802  O   THR B 130      30.867  68.341   2.777  1.00 43.89           O  
ATOM   2803  CB  THR B 130      27.589  67.963   3.259  1.00 44.83           C  
ATOM   2804  OG1 THR B 130      26.720  67.070   3.941  1.00 44.46           O  
ATOM   2805  CG2 THR B 130      27.913  67.388   1.860  1.00 48.23           C  
ATOM   2806  N   ILE B 131      29.767  70.265   3.223  1.00 41.05           N  
ATOM   2807  CA  ILE B 131      30.798  71.120   2.619  1.00 40.57           C  
ATOM   2808  C   ILE B 131      32.144  70.972   3.352  1.00 39.31           C  
ATOM   2809  O   ILE B 131      33.193  70.801   2.697  1.00 41.33           O  
ATOM   2810  CB  ILE B 131      30.381  72.614   2.600  1.00 40.76           C  
ATOM   2811  CG1 ILE B 131      29.263  72.854   1.562  1.00 43.58           C  
ATOM   2812  CG2 ILE B 131      31.612  73.504   2.338  1.00 41.66           C  
ATOM   2813  CD1 ILE B 131      28.535  74.214   1.654  1.00 42.85           C  
ATOM   2814  N   ILE B 132      32.127  71.085   4.684  1.00 36.77           N  
ATOM   2815  CA  ILE B 132      33.341  70.981   5.476  1.00 36.50           C  
ATOM   2816  C   ILE B 132      34.055  69.640   5.229  1.00 37.64           C  
ATOM   2817  O   ILE B 132      35.214  69.622   4.872  1.00 38.98           O  
ATOM   2818  CB  ILE B 132      33.109  71.214   7.004  1.00 36.79           C  
ATOM   2819  CG1 ILE B 132      32.645  72.652   7.252  1.00 35.52           C  
ATOM   2820  CG2 ILE B 132      34.409  70.928   7.842  1.00 34.49           C  
ATOM   2821  CD1 ILE B 132      32.190  72.888   8.701  1.00 35.25           C  
ATOM   2822  N   ASN B 133      33.335  68.542   5.396  1.00 38.05           N  
ATOM   2823  CA  ASN B 133      33.805  67.213   5.071  1.00 39.54           C  
ATOM   2824  C   ASN B 133      34.495  67.167   3.686  1.00 41.04           C  
ATOM   2825  O   ASN B 133      35.620  66.644   3.540  1.00 40.63           O  
ATOM   2826  CB  ASN B 133      32.585  66.298   5.136  1.00 41.56           C  
ATOM   2827  CG  ASN B 133      32.929  64.840   5.206  1.00 46.48           C  
ATOM   2828  OD1 ASN B 133      33.445  64.356   6.210  1.00 51.23           O  
ATOM   2829  ND2 ASN B 133      32.596  64.104   4.143  1.00 51.02           N  
ATOM   2830  N   GLY B 134      33.820  67.717   2.672  1.00 41.81           N  
ATOM   2831  CA  GLY B 134      34.352  67.704   1.304  1.00 43.24           C  
ATOM   2832  C   GLY B 134      35.630  68.498   1.155  1.00 43.34           C  
ATOM   2833  O   GLY B 134      36.505  68.105   0.386  1.00 46.81           O  
ATOM   2834  N   LEU B 135      35.738  69.618   1.878  1.00 41.36           N  
ATOM   2835  CA  LEU B 135      36.954  70.458   1.883  1.00 42.41           C  
ATOM   2836  C   LEU B 135      38.127  69.921   2.709  1.00 42.16           C  
ATOM   2837  O   LEU B 135      39.263  70.180   2.369  1.00 44.01           O  
ATOM   2838  CB  LEU B 135      36.657  71.894   2.345  1.00 40.79           C  
ATOM   2839  CG  LEU B 135      35.722  72.756   1.491  1.00 41.68           C  
ATOM   2840  CD1 LEU B 135      35.228  73.974   2.277  1.00 36.27           C  
ATOM   2841  CD2 LEU B 135      36.398  73.164   0.200  1.00 45.24           C  
ATOM   2842  N   VAL B 136      37.878  69.203   3.799  1.00 41.33           N  
ATOM   2843  CA  VAL B 136      39.005  68.851   4.686  1.00 42.60           C  
ATOM   2844  C   VAL B 136      39.643  67.491   4.370  1.00 44.87           C  
ATOM   2845  O   VAL B 136      40.786  67.230   4.743  1.00 46.42           O  
ATOM   2846  CB  VAL B 136      38.645  68.966   6.209  1.00 42.07           C  
ATOM   2847  CG1 VAL B 136      38.140  70.386   6.557  1.00 39.23           C  
ATOM   2848  CG2 VAL B 136      37.618  67.933   6.620  1.00 40.76           C  
ATOM   2849  N   PHE B 137      38.902  66.638   3.678  1.00 45.52           N  
ATOM   2850  CA  PHE B 137      39.313  65.282   3.455  1.00 49.35           C  
ATOM   2851  C   PHE B 137      39.591  64.998   1.989  1.00 54.03           C  
ATOM   2852  O   PHE B 137      39.498  63.852   1.580  1.00 57.39           O  
ATOM   2853  CB  PHE B 137      38.229  64.293   3.940  1.00 48.70           C  
ATOM   2854  CG  PHE B 137      38.014  64.290   5.429  1.00 45.84           C  
ATOM   2855  CD1 PHE B 137      36.732  64.394   5.945  1.00 42.57           C  
ATOM   2856  CD2 PHE B 137      39.089  64.168   6.314  1.00 41.60           C  
ATOM   2857  CE1 PHE B 137      36.525  64.398   7.326  1.00 43.21           C  
ATOM   2858  CE2 PHE B 137      38.879  64.164   7.699  1.00 43.82           C  
ATOM   2859  CZ  PHE B 137      37.611  64.277   8.197  1.00 43.26           C  
ATOM   2860  N   LYS B 138      39.909  66.004   1.190  1.00 57.61           N  
ATOM   2861  CA  LYS B 138      40.336  65.716  -0.157  1.00 65.89           C  
ATOM   2862  C   LYS B 138      41.751  65.152  -0.167  1.00 70.24           C  
ATOM   2863  O   LYS B 138      42.560  65.454   0.719  1.00 69.25           O  
ATOM   2864  CB  LYS B 138      40.120  66.859  -1.155  1.00 67.93           C  
ATOM   2865  CG  LYS B 138      40.352  68.267  -0.687  1.00 67.49           C  
ATOM   2866  CD  LYS B 138      40.069  69.186  -1.872  1.00 72.47           C  
ATOM   2867  CE  LYS B 138      39.422  70.490  -1.433  1.00 72.72           C  
ATOM   2868  NZ  LYS B 138      38.376  70.878  -2.423  1.00 73.46           N  
ATOM   2869  N   ASP B 139      42.013  64.291  -1.139  1.00 77.43           N  
ATOM   2870  CA  ASP B 139      43.282  63.546  -1.232  1.00 83.56           C  
ATOM   2871  C   ASP B 139      44.461  64.353  -1.804  1.00 88.04           C  
ATOM   2872  O   ASP B 139      44.765  65.444  -1.340  1.00 86.18           O  
ATOM   2873  CB  ASP B 139      43.058  62.275  -2.064  1.00 87.61           C  
ATOM   2874  CG  ASP B 139      43.999  61.168  -1.687  1.00 91.00           C  
ATOM   2875  OD1 ASP B 139      43.904  60.065  -2.283  1.00 96.12           O  
ATOM   2876  OD2 ASP B 139      44.845  61.404  -0.792  1.00 91.42           O  
ATOM   2877  N   ALA B 140      45.124  63.790  -2.815  1.00 96.58           N  
ATOM   2878  CA  ALA B 140      46.215  64.461  -3.536  1.00103.36           C  
ATOM   2879  C   ALA B 140      45.717  65.526  -4.528  1.00108.35           C  
ATOM   2880  O   ALA B 140      46.529  66.243  -5.123  1.00112.44           O  
ATOM   2881  CB  ALA B 140      47.087  63.430  -4.253  1.00108.43           C  
ATOM   2882  N   ARG B 141      44.392  65.634  -4.698  1.00 73.91           N  
ATOM   2883  CA  ARG B 141      43.820  66.632  -5.601  1.00 74.42           C  
ATOM   2884  C   ARG B 141      43.978  68.049  -5.070  1.00 76.38           C  
ATOM   2885  O   ARG B 141      43.712  69.005  -5.796  1.00 76.36           O  
ATOM   2886  CB  ARG B 141      42.360  66.332  -5.948  1.00 75.59           C  
ATOM   2887  CG  ARG B 141      42.144  65.111  -6.860  1.00 77.70           C  
ATOM   2888  CD  ARG B 141      42.882  65.208  -8.213  1.00 77.33           C  
ATOM   2889  NE  ARG B 141      42.057  64.782  -9.356  1.00 78.69           N  
ATOM   2890  CZ  ARG B 141      41.111  65.541  -9.915  1.00 78.81           C  
ATOM   2891  NH1 ARG B 141      40.852  66.752  -9.421  1.00 78.54           N  
ATOM   2892  NH2 ARG B 141      40.411  65.095 -10.957  1.00 79.64           N  
ATOM   2893  N   LEU B 142      44.442  68.179  -3.824  1.00 80.75           N  
ATOM   2894  CA  LEU B 142      44.722  69.490  -3.216  1.00 84.86           C  
ATOM   2895  C   LEU B 142      45.817  70.242  -4.009  1.00 85.49           C  
ATOM   2896  O   LEU B 142      45.704  71.449  -4.246  1.00 87.65           O  
ATOM   2897  CB  LEU B 142      45.085  69.357  -1.715  1.00 88.38           C  
ATOM   2898  CG  LEU B 142      43.985  69.131  -0.638  1.00 94.30           C  
ATOM   2899  CD1 LEU B 142      44.479  68.291   0.552  1.00 98.10           C  
ATOM   2900  CD2 LEU B 142      43.325  70.434  -0.120  1.00 96.78           C  
ATOM   2901  N   ARG B 143      46.849  69.520  -4.443  1.00 86.36           N  
ATOM   2902  CA  ARG B 143      47.956  70.127  -5.176  1.00 90.10           C  
ATOM   2903  C   ARG B 143      47.965  69.740  -6.668  1.00 90.78           C  
ATOM   2904  O   ARG B 143      49.002  69.784  -7.331  1.00 94.33           O  
ATOM   2905  CB  ARG B 143      49.296  69.797  -4.492  1.00 93.21           C  
ATOM   2906  CG  ARG B 143      49.307  70.022  -2.962  1.00 95.52           C  
ATOM   2907  CD  ARG B 143      49.624  71.467  -2.572  1.00 99.42           C  
ATOM   2908  NE  ARG B 143      51.037  71.654  -2.235  1.00105.09           N  
ATOM   2909  CZ  ARG B 143      51.911  72.367  -2.947  1.00109.17           C  
ATOM   2910  NH1 ARG B 143      51.532  72.989  -4.057  1.00109.57           N  
ATOM   2911  NH2 ARG B 143      53.173  72.469  -2.539  1.00114.87           N  
ATOM   2912  N   LEU B 144      46.791  69.367  -7.171  1.00 89.59           N  
ATOM   2913  CA  LEU B 144      46.588  68.993  -8.568  1.00 91.10           C  
ATOM   2914  C   LEU B 144      45.508  69.888  -9.151  1.00 92.16           C  
ATOM   2915  O   LEU B 144      45.597  70.318 -10.299  1.00 95.68           O  
ATOM   2916  CB  LEU B 144      46.161  67.528  -8.670  1.00 89.56           C  
ATOM   2917  CG  LEU B 144      47.233  66.449  -8.469  1.00 92.16           C  
ATOM   2918  CD1 LEU B 144      46.581  65.142  -8.024  1.00 91.92           C  
ATOM   2919  CD2 LEU B 144      48.095  66.240  -9.727  1.00 96.89           C  
ATOM   2920  N   ALA B 145      44.483  70.146  -8.340  1.00 91.38           N  
ATOM   2921  CA  ALA B 145      43.526  71.224  -8.568  1.00 94.43           C  
ATOM   2922  C   ALA B 145      44.154  72.571  -8.189  1.00 98.25           C  
ATOM   2923  O   ALA B 145      43.502  73.621  -8.271  1.00102.25           O  
ATOM   2924  CB  ALA B 145      42.243  70.985  -7.763  1.00 94.17           C  
ATOM   2925  N   GLU B 146      45.417  72.521  -7.759  1.00 98.57           N  
ATOM   2926  CA  GLU B 146      46.225  73.715  -7.516  1.00103.53           C  
ATOM   2927  C   GLU B 146      46.732  74.241  -8.862  1.00108.95           C  
ATOM   2928  O   GLU B 146      47.002  75.433  -9.012  1.00115.01           O  
ATOM   2929  CB  GLU B 146      47.389  73.379  -6.569  1.00103.23           C  
ATOM   2930  CG  GLU B 146      48.025  74.565  -5.831  1.00108.26           C  
ATOM   2931  CD  GLU B 146      49.394  74.963  -6.386  1.00114.26           C  
ATOM   2932  OE1 GLU B 146      49.609  74.873  -7.615  1.00117.33           O  
ATOM   2933  OE2 GLU B 146      50.264  75.378  -5.589  1.00117.41           O  
ATOM   2934  N   PHE B 147      46.834  73.337  -9.837  1.00108.47           N  
ATOM   2935  CA  PHE B 147      47.205  73.693 -11.213  1.00115.95           C  
ATOM   2936  C   PHE B 147      45.989  73.934 -12.117  1.00117.91           C  
ATOM   2937  O   PHE B 147      46.129  74.509 -13.200  1.00126.21           O  
ATOM   2938  CB  PHE B 147      48.138  72.639 -11.832  1.00117.39           C  
ATOM   2939  CG  PHE B 147      49.216  72.150 -10.900  1.00115.67           C  
ATOM   2940  CD1 PHE B 147      49.418  70.789 -10.715  1.00111.86           C  
ATOM   2941  CD2 PHE B 147      50.020  73.047 -10.203  1.00119.37           C  
ATOM   2942  CE1 PHE B 147      50.405  70.326  -9.859  1.00112.45           C  
ATOM   2943  CE2 PHE B 147      51.008  72.594  -9.342  1.00119.67           C  
ATOM   2944  CZ  PHE B 147      51.200  71.229  -9.167  1.00116.17           C  
ATOM   2945  N   LEU B 148      44.809  73.487 -11.680  1.00112.27           N  
ATOM   2946  CA  LEU B 148      43.548  73.871 -12.320  1.00115.27           C  
ATOM   2947  C   LEU B 148      43.325  75.380 -12.167  1.00122.00           C  
ATOM   2948  O   LEU B 148      42.973  76.068 -13.130  1.00129.87           O  
ATOM   2949  CB  LEU B 148      42.362  73.105 -11.718  1.00109.78           C  
ATOM   2950  CG  LEU B 148      42.040  71.652 -12.109  1.00106.42           C  
ATOM   2951  CD1 LEU B 148      40.843  71.126 -11.296  1.00103.16           C  
ATOM   2952  CD2 LEU B 148      41.780  71.489 -13.617  1.00111.24           C  
ATOM   2953  N   VAL B 149      43.543  75.877 -10.951  1.00120.33           N  
ATOM   2954  CA  VAL B 149      43.431  77.298 -10.637  1.00127.53           C  
ATOM   2955  C   VAL B 149      44.806  77.856 -10.284  1.00130.60           C  
ATOM   2956  O   VAL B 149      45.785  77.615 -10.990  1.00132.94           O  
ATOM   2957  CB  VAL B 149      42.455  77.549  -9.457  1.00126.23           C  
ATOM   2958  CG1 VAL B 149      42.448  79.029  -9.058  1.00135.15           C  
ATOM   2959  CG2 VAL B 149      41.044  77.073  -9.807  1.00125.56           C  
TER    2960      VAL B 149                                                      
END
MOLECULE T0503.pdb
ATOM      1  N   MET     1      -2.195  86.925   8.915  1.00 26.81           N  
ATOM      2  CA  MET     1      -1.724  85.497   8.850  1.00 28.06           C  
ATOM      3  C   MET     1      -0.819  85.120   7.657  1.00 27.13           C  
ATOM      4  O   MET     1      -1.254  85.203   6.502  1.00 26.80           O  
ATOM      5  CB  MET     1      -2.937  84.598   8.795  1.00 29.37           C  
ATOM      6  CG  MET     1      -2.575  83.177   9.064  1.00 31.78           C  
ATOM      7  SD  MET     1      -2.816  82.757  10.936  0.50 39.69          SE  
ATOM      8  CE  MET     1      -2.928  80.825  10.551  1.00 34.48           C  
ATOM      9  N   HIS     2       0.412  84.664   7.935  1.00 26.20           N  
ATOM     10  CA  HIS     2       1.359  84.308   6.874  1.00 24.85           C  
ATOM     11  C   HIS     2       1.303  82.830   6.633  1.00 24.86           C  
ATOM     12  O   HIS     2       2.056  82.054   7.224  1.00 24.48           O  
ATOM     13  CB  HIS     2       2.773  84.739   7.246  1.00 23.93           C  
ATOM     14  CG  HIS     2       2.918  86.212   7.388  1.00 23.39           C  
ATOM     15  ND1 HIS     2       2.576  87.090   6.387  1.00 23.22           N  
ATOM     16  CD2 HIS     2       3.397  86.964   8.404  1.00 22.51           C  
ATOM     17  CE1 HIS     2       2.824  88.326   6.785  1.00 22.60           C  
ATOM     18  NE2 HIS     2       3.322  88.268   8.010  1.00 21.56           N  
ATOM     19  N   THR     3       0.387  82.432   5.767  1.00 24.90           N  
ATOM     20  CA  THR     3       0.038  81.021   5.605  1.00 26.55           C  
ATOM     21  C   THR     3       1.245  80.076   5.373  1.00 26.15           C  
ATOM     22  O   THR     3       1.341  79.046   5.996  1.00 25.92           O  
ATOM     23  CB  THR     3      -1.005  80.913   4.483  1.00 27.48           C  
ATOM     24  OG1 THR     3      -2.239  81.427   4.999  1.00 28.85           O  
ATOM     25  CG2 THR     3      -1.216  79.461   4.072  1.00 30.71           C  
ATOM     26  N   ALA     4       2.136  80.435   4.448  1.00 25.60           N  
ATOM     27  CA  ALA     4       3.286  79.582   4.129  1.00 26.69           C  
ATOM     28  C   ALA     4       4.132  79.301   5.365  1.00 26.06           C  
ATOM     29  O   ALA     4       4.576  78.172   5.584  1.00 26.91           O  
ATOM     30  CB  ALA     4       4.151  80.253   3.077  1.00 26.36           C  
ATOM     31  N   LEU     5       4.380  80.348   6.149  1.00 24.96           N  
ATOM     32  CA  LEU     5       5.234  80.258   7.337  1.00 25.26           C  
ATOM     33  C   LEU     5       4.545  79.419   8.414  1.00 25.90           C  
ATOM     34  O   LEU     5       5.154  78.550   9.035  1.00 24.96           O  
ATOM     35  CB  LEU     5       5.534  81.654   7.847  1.00 25.05           C  
ATOM     36  CG  LEU     5       6.210  81.709   9.201  1.00 24.36           C  
ATOM     37  CD1 LEU     5       7.579  80.963   9.120  1.00 28.55           C  
ATOM     38  CD2 LEU     5       6.368  83.179   9.643  1.00 26.74           C  
ATOM     39  N   ILE     6       3.247  79.668   8.614  1.00 25.59           N  
ATOM     40  CA  ILE     6       2.498  78.909   9.608  1.00 26.16           C  
ATOM     41  C   ILE     6       2.447  77.422   9.240  1.00 26.84           C  
ATOM     42  O   ILE     6       2.573  76.593  10.112  1.00 26.39           O  
ATOM     43  CB  ILE     6       1.069  79.475   9.854  1.00 25.80           C  
ATOM     44  CG1 ILE     6       1.133  80.940  10.338  1.00 26.02           C  
ATOM     45  CG2 ILE     6       0.243  78.527  10.790  1.00 26.08           C  
ATOM     46  CD1 ILE     6       2.056  81.188  11.541  1.00 26.95           C  
ATOM     47  N   ASN     7       2.264  77.102   7.953  1.00 28.26           N  
ATOM     48  CA  ASN     7       2.166  75.705   7.511  1.00 29.46           C  
ATOM     49  C   ASN     7       3.481  75.025   7.789  1.00 29.08           C  
ATOM     50  O   ASN     7       3.533  73.866   8.212  1.00 29.36           O  
ATOM     51  CB  ASN     7       1.882  75.621   6.005  1.00 29.84           C  
ATOM     52  CG  ASN     7       0.439  75.851   5.680  1.00 32.71           C  
ATOM     53  OD1 ASN     7      -0.425  75.903   6.569  1.00 34.18           O  
ATOM     54  ND2 ASN     7       0.140  75.955   4.386  1.00 37.28           N  
ATOM     55  N   HIS     8       4.561  75.746   7.533  1.00 28.11           N  
ATOM     56  CA  HIS     8       5.856  75.121   7.720  1.00 27.69           C  
ATOM     57  C   HIS     8       6.062  74.856   9.209  1.00 27.56           C  
ATOM     58  O   HIS     8       6.560  73.786   9.610  1.00 28.36           O  
ATOM     59  CB  HIS     8       6.998  75.976   7.163  1.00 27.04           C  
ATOM     60  CG  HIS     8       8.291  75.238   7.143  1.00 27.62           C  
ATOM     61  ND1 HIS     8       9.366  75.568   7.953  1.00 27.68           N  
ATOM     62  CD2 HIS     8       8.639  74.093   6.501  1.00 28.22           C  
ATOM     63  CE1 HIS     8      10.340  74.695   7.755  1.00 28.06           C  
ATOM     64  NE2 HIS     8       9.933  73.800   6.869  1.00 28.36           N  
ATOM     65  N   ILE     9       5.751  75.860  10.031  1.00 28.00           N  
ATOM     66  CA  ILE     9       5.933  75.731  11.483  1.00 27.55           C  
ATOM     67  C   ILE     9       5.105  74.598  12.027  1.00 28.10           C  
ATOM     68  O   ILE     9       5.584  73.810  12.843  1.00 28.32           O  
ATOM     69  CB  ILE     9       5.581  77.029  12.224  1.00 27.25           C  
ATOM     70  CG1 ILE     9       6.647  78.107  11.931  1.00 25.75           C  
ATOM     71  CG2 ILE     9       5.479  76.793  13.766  1.00 26.77           C  
ATOM     72  CD1 ILE     9       6.222  79.515  12.321  1.00 26.95           C  
ATOM     73  N   ARG    10       3.872  74.488  11.544  1.00 26.86           N  
ATOM     74  CA  ARG    10       2.992  73.424  12.004  1.00 28.61           C  
ATOM     75  C   ARG    10       3.450  72.025  11.625  1.00 29.36           C  
ATOM     76  O   ARG    10       2.921  71.035  12.163  1.00 30.77           O  
ATOM     77  CB  ARG    10       1.549  73.681  11.537  1.00 27.95           C  
ATOM     78  CG  ARG    10       0.869  74.691  12.429  1.00 29.08           C  
ATOM     79  CD  ARG    10      -0.581  74.904  12.029  1.00 27.20           C  
ATOM     80  NE  ARG    10      -1.263  75.793  12.977  1.00 30.50           N  
ATOM     81  CZ  ARG    10      -2.212  76.673  12.666  1.00 30.04           C  
ATOM     82  NH1 ARG    10      -2.634  76.796  11.402  1.00 30.44           N  
ATOM     83  NH2 ARG    10      -2.745  77.433  13.624  1.00 28.71           N  
ATOM     84  N   LYS    11       4.392  71.907  10.693  1.00 30.38           N  
ATOM     85  CA  LYS    11       4.973  70.588  10.435  1.00 31.45           C  
ATOM     86  C   LYS    11       5.817  70.104  11.621  1.00 31.90           C  
ATOM     87  O   LYS    11       6.084  68.921  11.733  1.00 31.68           O  
ATOM     88  CB  LYS    11       5.850  70.566   9.181  1.00 31.66           C  
ATOM     89  CG  LYS    11       5.176  70.782   7.869  1.00 34.53           C  
ATOM     90  CD  LYS    11       6.151  70.370   6.754  1.00 39.40           C  
ATOM     91  CE  LYS    11       5.568  70.546   5.340  1.00 44.68           C  
ATOM     92  NZ  LYS    11       4.380  69.679   5.050  1.00 44.32           N  
ATOM     93  N   PHE    12       6.230  71.009  12.510  1.00 31.48           N  
ATOM     94  CA  PHE    12       7.142  70.632  13.604  1.00 32.44           C  
ATOM     95  C   PHE    12       6.573  70.806  15.001  1.00 32.09           C  
ATOM     96  O   PHE    12       7.008  70.133  15.972  1.00 33.11           O  
ATOM     97  CB  PHE    12       8.450  71.426  13.481  1.00 32.02           C  
ATOM     98  CG  PHE    12       9.129  71.253  12.153  1.00 34.98           C  
ATOM     99  CD1 PHE    12       9.998  70.182  11.927  1.00 36.94           C  
ATOM    100  CD2 PHE    12       8.880  72.155  11.116  1.00 32.45           C  
ATOM    101  CE1 PHE    12      10.619  70.017  10.680  1.00 37.43           C  
ATOM    102  CE2 PHE    12       9.470  71.989   9.865  1.00 35.98           C  
ATOM    103  CZ  PHE    12      10.376  70.918   9.661  1.00 36.28           C  
ATOM    104  N   ILE    13       5.634  71.723  15.126  1.00 31.63           N  
ATOM    105  CA  ILE    13       5.052  72.028  16.436  1.00 31.23           C  
ATOM    106  C   ILE    13       3.535  72.188  16.323  1.00 32.70           C  
ATOM    107  O   ILE    13       2.986  72.357  15.217  1.00 33.13           O  
ATOM    108  CB  ILE    13       5.669  73.307  17.089  1.00 31.18           C  
ATOM    109  CG1 ILE    13       5.292  74.579  16.318  1.00 29.33           C  
ATOM    110  CG2 ILE    13       7.232  73.164  17.335  1.00 30.68           C  
ATOM    111  CD1 ILE    13       5.648  75.866  17.084  1.00 31.40           C  
ATOM    112  N   PHE    14       2.859  72.147  17.472  1.00 32.47           N  
ATOM    113  CA  PHE    14       1.479  72.565  17.553  1.00 32.28           C  
ATOM    114  C   PHE    14       1.432  74.097  17.752  1.00 32.47           C  
ATOM    115  O   PHE    14       2.228  74.664  18.506  1.00 32.83           O  
ATOM    116  CB  PHE    14       0.729  71.824  18.693  1.00 32.39           C  
ATOM    117  CG  PHE    14      -0.612  72.392  18.953  1.00 30.84           C  
ATOM    118  CD1 PHE    14      -1.675  72.098  18.103  1.00 30.41           C  
ATOM    119  CD2 PHE    14      -0.807  73.307  20.007  1.00 33.32           C  
ATOM    120  CE1 PHE    14      -2.907  72.673  18.304  1.00 28.39           C  
ATOM    121  CE2 PHE    14      -2.051  73.889  20.222  1.00 30.91           C  
ATOM    122  CZ  PHE    14      -3.106  73.569  19.372  1.00 30.89           C  
ATOM    123  N   LEU    15       0.515  74.761  17.056  1.00 32.72           N  
ATOM    124  CA  LEU    15       0.341  76.207  17.160  1.00 32.94           C  
ATOM    125  C   LEU    15      -1.138  76.558  17.041  1.00 33.73           C  
ATOM    126  O   LEU    15      -1.767  76.253  16.027  1.00 33.84           O  
ATOM    127  CB  LEU    15       1.159  76.891  16.038  1.00 33.08           C  
ATOM    128  CG  LEU    15       1.494  78.372  16.133  1.00 33.50           C  
ATOM    129  CD1 LEU    15       2.577  78.651  17.186  1.00 30.85           C  
ATOM    130  CD2 LEU    15       1.955  78.790  14.757  1.00 31.96           C  
ATOM    131  N   THR    16      -1.709  77.193  18.068  1.00 34.99           N  
ATOM    132  CA  THR    16      -3.073  77.709  17.959  1.00 35.76           C  
ATOM    133  C   THR    16      -3.181  78.750  16.842  1.00 36.81           C  
ATOM    134  O   THR    16      -2.198  79.410  16.481  1.00 34.37           O  
ATOM    135  CB  THR    16      -3.587  78.337  19.282  1.00 36.03           C  
ATOM    136  OG1 THR    16      -2.780  79.465  19.645  1.00 35.69           O  
ATOM    137  CG2 THR    16      -3.554  77.318  20.416  1.00 36.83           C  
ATOM    138  N   ASP    17      -4.394  78.896  16.309  1.00 38.67           N  
ATOM    139  CA  ASP    17      -4.677  79.914  15.315  1.00 40.16           C  
ATOM    140  C   ASP    17      -4.367  81.295  15.886  1.00 40.69           C  
ATOM    141  O   ASP    17      -3.881  82.167  15.168  1.00 40.31           O  
ATOM    142  CB  ASP    17      -6.155  79.830  14.905  1.00 41.50           C  
ATOM    143  CG  ASP    17      -6.485  78.530  14.185  1.00 43.81           C  
ATOM    144  OD1 ASP    17      -5.614  77.979  13.461  1.00 42.91           O  
ATOM    145  OD2 ASP    17      -7.646  78.079  14.309  1.00 49.00           O  
ATOM    146  N   GLU    18      -4.655  81.483  17.179  1.00 41.29           N  
ATOM    147  CA  GLU    18      -4.386  82.756  17.846  0.50 41.60           C  
ATOM    149  C   GLU    18      -2.886  83.049  17.849  1.00 41.13           C  
ATOM    150  O   GLU    18      -2.464  84.123  17.427  1.00 40.93           O  
ATOM    151  CB  GLU    18      -4.972  82.795  19.267  0.50 42.19           C  
ATOM    153  CG  GLU    18      -5.342  81.439  19.882  0.50 43.46           C  
ATOM    155  CD  GLU    18      -6.645  80.866  19.329  0.50 44.88           C  
ATOM    157  OE1 GLU    18      -7.673  81.566  19.358  0.50 46.76           O  
ATOM    159  OE2 GLU    18      -6.642  79.706  18.867  0.50 46.68           O  
ATOM    161  N   ASP    19      -2.099  82.085  18.312  1.00 40.46           N  
ATOM    162  CA  ASP    19      -0.648  82.219  18.349  1.00 40.11           C  
ATOM    163  C   ASP    19      -0.034  82.371  16.956  1.00 39.01           C  
ATOM    164  O   ASP    19       0.968  83.076  16.785  1.00 38.04           O  
ATOM    165  CB  ASP    19      -0.021  81.028  19.055  1.00 40.52           C  
ATOM    166  CG  ASP    19      -0.117  81.133  20.568  1.00 44.05           C  
ATOM    167  OD1 ASP    19      -0.557  82.199  21.076  1.00 47.21           O  
ATOM    168  OD2 ASP    19       0.245  80.144  21.233  1.00 45.00           O  
ATOM    169  N   ALA    20      -0.623  81.687  15.972  1.00 38.09           N  
ATOM    170  CA  ALA    20      -0.226  81.851  14.570  1.00 36.43           C  
ATOM    171  C   ALA    20      -0.443  83.305  14.148  1.00 36.26           C  
ATOM    172  O   ALA    20       0.398  83.885  13.471  1.00 35.49           O  
ATOM    173  CB  ALA    20      -1.004  80.905  13.687  1.00 36.51           C  
ATOM    174  N   GLY    21      -1.586  83.885  14.545  1.00 35.48           N  
ATOM    175  CA  GLY    21      -1.854  85.299  14.268  1.00 35.55           C  
ATOM    176  C   GLY    21      -0.846  86.203  14.965  1.00 35.48           C  
ATOM    177  O   GLY    21      -0.289  87.131  14.349  1.00 35.50           O  
ATOM    178  N   THR    22      -0.578  85.921  16.237  1.00 34.69           N  
ATOM    179  CA  THR    22       0.384  86.718  17.004  1.00 34.50           C  
ATOM    180  C   THR    22       1.796  86.646  16.396  1.00 34.27           C  
ATOM    181  O   THR    22       2.453  87.684  16.199  1.00 32.99           O  
ATOM    182  CB  THR    22       0.429  86.298  18.473  1.00 35.02           C  
ATOM    183  OG1 THR    22      -0.864  86.494  19.036  1.00 35.98           O  
ATOM    184  CG2 THR    22       1.427  87.147  19.259  1.00 35.18           C  
ATOM    185  N   LEU    23       2.218  85.424  16.055  1.00 33.73           N  
ATOM    186  CA  LEU    23       3.532  85.207  15.459  1.00 35.26           C  
ATOM    187  C   LEU    23       3.660  85.957  14.124  1.00 33.84           C  
ATOM    188  O   LEU    23       4.692  86.604  13.848  1.00 33.66           O  
ATOM    189  CB  LEU    23       3.749  83.694  15.265  1.00 34.64           C  
ATOM    190  CG  LEU    23       4.932  83.070  14.559  1.00 40.16           C  
ATOM    191  CD1 LEU    23       5.060  81.633  15.062  1.00 42.49           C  
ATOM    192  CD2 LEU    23       4.752  83.111  13.045  1.00 38.60           C  
ATOM    193  N   SER    24       2.614  85.876  13.300  1.00 33.78           N  
ATOM    194  CA  SER    24       2.653  86.490  11.961  1.00 34.16           C  
ATOM    195  C   SER    24       3.001  87.972  12.024  1.00 34.13           C  
ATOM    196  O   SER    24       3.724  88.473  11.153  1.00 34.50           O  
ATOM    197  CB  SER    24       1.325  86.281  11.208  1.00 34.08           C  
ATOM    198  OG  SER    24       1.177  84.901  10.850  1.00 36.01           O  
ATOM    199  N   ALA    25       2.507  88.668  13.050  1.00 33.95           N  
ATOM    200  CA  ALA    25       2.667  90.129  13.160  1.00 33.23           C  
ATOM    201  C   ALA    25       4.115  90.570  13.378  1.00 33.44           C  
ATOM    202  O   ALA    25       4.449  91.754  13.201  1.00 32.90           O  
ATOM    203  CB  ALA    25       1.767  90.701  14.270  1.00 34.30           C  
ATOM    204  N   PHE    26       4.982  89.636  13.782  1.00 32.76           N  
ATOM    205  CA  PHE    26       6.408  89.939  13.969  1.00 31.82           C  
ATOM    206  C   PHE    26       7.165  89.924  12.633  1.00 31.94           C  
ATOM    207  O   PHE    26       8.335  90.315  12.602  1.00 31.88           O  
ATOM    208  CB  PHE    26       7.077  88.894  14.846  1.00 32.24           C  
ATOM    209  CG  PHE    26       6.827  89.057  16.304  1.00 32.40           C  
ATOM    210  CD1 PHE    26       7.777  89.653  17.121  1.00 32.42           C  
ATOM    211  CD2 PHE    26       5.667  88.565  16.868  1.00 33.20           C  
ATOM    212  CE1 PHE    26       7.563  89.787  18.501  1.00 33.96           C  
ATOM    213  CE2 PHE    26       5.450  88.714  18.249  1.00 36.84           C  
ATOM    214  CZ  PHE    26       6.416  89.311  19.058  1.00 34.15           C  
ATOM    215  N   PHE    27       6.538  89.406  11.558  1.00 30.41           N  
ATOM    216  CA  PHE    27       7.221  89.242  10.274  1.00 31.06           C  
ATOM    217  C   PHE    27       6.746  90.237   9.248  1.00 32.40           C  
ATOM    218  O   PHE    27       5.545  90.491   9.175  1.00 33.41           O  
ATOM    219  CB  PHE    27       7.023  87.819   9.723  1.00 31.02           C  
ATOM    220  CG  PHE    27       7.748  86.775  10.510  1.00 28.94           C  
ATOM    221  CD1 PHE    27       8.983  86.322  10.096  1.00 30.07           C  
ATOM    222  CD2 PHE    27       7.181  86.247  11.675  1.00 33.57           C  
ATOM    223  CE1 PHE    27       9.677  85.367  10.851  1.00 30.61           C  
ATOM    224  CE2 PHE    27       7.841  85.287  12.425  1.00 32.30           C  
ATOM    225  CZ  PHE    27       9.080  84.850  12.024  1.00 29.77           C  
ATOM    226  N   GLN    28       7.675  90.803   8.486  1.00 32.57           N  
ATOM    227  CA  GLN    28       7.327  91.667   7.357  1.00 34.07           C  
ATOM    228  C   GLN    28       7.422  90.928   6.015  1.00 33.96           C  
ATOM    229  O   GLN    28       8.369  90.170   5.771  1.00 33.07           O  
ATOM    230  CB  GLN    28       8.232  92.898   7.355  1.00 34.59           C  
ATOM    231  CG  GLN    28       8.099  93.683   8.633  1.00 39.34           C  
ATOM    232  CD  GLN    28       8.867  94.983   8.592  1.00 45.08           C  
ATOM    233  OE1 GLN    28       8.896  95.680   7.564  1.00 48.68           O  
ATOM    234  NE2 GLN    28       9.501  95.323   9.712  1.00 45.29           N  
ATOM    235  N   LEU    29       6.443  91.144   5.139  1.00 33.99           N  
ATOM    236  CA  LEU    29       6.532  90.584   3.784  1.00 34.88           C  
ATOM    237  C   LEU    29       7.429  91.451   2.908  1.00 35.45           C  
ATOM    238  O   LEU    29       7.299  92.692   2.859  1.00 36.34           O  
ATOM    239  CB  LEU    29       5.146  90.364   3.138  1.00 35.56           C  
ATOM    240  CG  LEU    29       5.111  89.638   1.766  1.00 34.98           C  
ATOM    241  CD1 LEU    29       5.615  88.094   1.678  1.00 34.32           C  
ATOM    242  CD2 LEU    29       3.696  89.825   1.203  1.00 37.47           C  
ATOM    243  N   LYS    30       8.358  90.806   2.230  1.00 33.98           N  
ATOM    244  CA  LYS    30       9.323  91.493   1.393  1.00 34.53           C  
ATOM    245  C   LYS    30       9.283  90.813   0.028  1.00 33.84           C  
ATOM    246  O   LYS    30       9.477  89.597  -0.033  1.00 32.14           O  
ATOM    247  CB  LYS    30      10.689  91.220   1.991  1.00 36.16           C  
ATOM    248  CG  LYS    30      11.358  92.312   2.686  1.00 39.93           C  
ATOM    249  CD  LYS    30      12.502  92.793   1.797  1.00 43.68           C  
ATOM    250  CE  LYS    30      12.127  94.019   0.999  1.00 43.70           C  
ATOM    251  NZ  LYS    30      13.370  94.679   0.483  1.00 43.96           N  
ATOM    252  N   LYS    31       9.035  91.562  -1.060  1.00 32.00           N  
ATOM    253  CA  LYS    31       9.170  90.996  -2.399  1.00 32.82           C  
ATOM    254  C   LYS    31      10.407  91.617  -3.041  1.00 33.08           C  
ATOM    255  O   LYS    31      10.586  92.839  -2.982  1.00 33.15           O  
ATOM    256  CB  LYS    31       7.961  91.286  -3.274  1.00 32.92           C  
ATOM    257  CG  LYS    31       6.680  90.685  -2.758  1.00 36.23           C  
ATOM    258  CD  LYS    31       5.492  91.424  -3.360  1.00 40.44           C  
ATOM    259  CE  LYS    31       4.250  91.358  -2.468  1.00 40.43           C  
ATOM    260  NZ  LYS    31       3.093  92.070  -3.128  1.00 40.51           N  
ATOM    261  N   VAL    32      11.240  90.791  -3.660  1.00 31.91           N  
ATOM    262  CA  VAL    32      12.459  91.293  -4.265  1.00 32.69           C  
ATOM    263  C   VAL    32      12.662  90.615  -5.629  1.00 31.95           C  
ATOM    264  O   VAL    32      12.444  89.381  -5.775  1.00 30.82           O  
ATOM    265  CB  VAL    32      13.716  91.131  -3.336  1.00 33.25           C  
ATOM    266  CG1 VAL    32      13.418  91.667  -1.898  1.00 36.70           C  
ATOM    267  CG2 VAL    32      14.119  89.712  -3.229  1.00 35.82           C  
ATOM    268  N   ARG    33      13.057  91.420  -6.611  1.00 31.23           N  
ATOM    269  CA  ARG    33      13.451  90.887  -7.910  1.00 32.22           C  
ATOM    270  C   ARG    33      14.749  90.091  -7.801  1.00 31.11           C  
ATOM    271  O   ARG    33      15.515  90.260  -6.850  1.00 30.95           O  
ATOM    272  CB  ARG    33      13.601  91.998  -8.959  1.00 31.85           C  
ATOM    273  CG  ARG    33      12.393  92.919  -9.102  1.00 34.14           C  
ATOM    274  CD  ARG    33      12.740  94.119 -10.023  1.00 36.81           C  
ATOM    275  NE  ARG    33      13.714  95.013  -9.392  1.00 45.67           N  
ATOM    276  CZ  ARG    33      13.398  96.052  -8.619  1.00 49.36           C  
ATOM    277  NH1 ARG    33      12.120  96.376  -8.402  1.00 50.45           N  
ATOM    278  NH2 ARG    33      14.371  96.785  -8.081  1.00 51.64           N  
ATOM    279  N   LYS    34      14.994  89.228  -8.777  1.00 31.67           N  
ATOM    280  CA  LYS    34      16.247  88.495  -8.858  1.00 33.20           C  
ATOM    281  C   LYS    34      17.435  89.446  -8.892  1.00 32.86           C  
ATOM    282  O   LYS    34      17.325  90.581  -9.367  1.00 31.71           O  
ATOM    283  CB  LYS    34      16.268  87.556 -10.073  1.00 33.21           C  
ATOM    284  CG  LYS    34      16.163  88.243 -11.419  1.00 35.08           C  
ATOM    285  CD  LYS    34      16.022  87.241 -12.584  1.00 36.99           C  
ATOM    286  CE  LYS    34      14.688  86.473 -12.480  1.00 43.50           C  
ATOM    287  NZ  LYS    34      13.881  86.483 -13.739  1.00 48.16           N  
ATOM    288  N   LYS    35      18.560  88.967  -8.377  1.00 33.06           N  
ATOM    289  CA  LYS    35      19.822  89.714  -8.304  1.00 34.74           C  
ATOM    290  C   LYS    35      19.815  91.003  -7.473  1.00 34.57           C  
ATOM    291  O   LYS    35      20.554  91.943  -7.781  1.00 36.10           O  
ATOM    292  CB  LYS    35      20.379  89.944  -9.709  1.00 36.50           C  
ATOM    293  CG  LYS    35      21.005  88.683 -10.294  1.00 40.20           C  
ATOM    294  CD  LYS    35      21.595  88.949 -11.656  1.00 46.87           C  
ATOM    295  CE  LYS    35      21.402  87.726 -12.568  1.00 50.76           C  
ATOM    296  NZ  LYS    35      19.958  87.400 -12.813  1.00 51.53           N  
ATOM    297  N   GLU    36      18.978  91.041  -6.438  1.00 32.75           N  
ATOM    298  CA  GLU    36      18.895  92.156  -5.501  1.00 33.16           C  
ATOM    299  C   GLU    36      19.693  91.777  -4.275  1.00 31.78           C  
ATOM    300  O   GLU    36      19.516  90.685  -3.741  1.00 30.58           O  
ATOM    301  CB  GLU    36      17.447  92.436  -5.079  1.00 32.88           C  
ATOM    302  CG  GLU    36      16.684  93.293  -6.104  1.00 41.56           C  
ATOM    303  CD  GLU    36      17.278  94.695  -6.204  1.00 47.95           C  
ATOM    304  OE1 GLU    36      17.753  95.199  -5.154  1.00 51.30           O  
ATOM    305  OE2 GLU    36      17.278  95.280  -7.318  1.00 51.51           O  
ATOM    306  N   THR    37      20.578  92.678  -3.849  1.00 30.58           N  
ATOM    307  CA  THR    37      21.389  92.413  -2.648  1.00 30.36           C  
ATOM    308  C   THR    37      20.641  92.864  -1.390  1.00 30.20           C  
ATOM    309  O   THR    37      20.179  94.009  -1.304  1.00 29.55           O  
ATOM    310  CB  THR    37      22.786  93.090  -2.780  1.00 31.92           C  
ATOM    311  OG1 THR    37      23.499  92.498  -3.893  1.00 31.83           O  
ATOM    312  CG2 THR    37      23.593  92.906  -1.498  1.00 30.49           C  
ATOM    313  N   LEU    38      20.513  91.956  -0.430  1.00 28.87           N  
ATOM    314  CA  LEU    38      19.791  92.198   0.831  1.00 29.26           C  
ATOM    315  C   LEU    38      20.736  92.470   1.989  1.00 28.90           C  
ATOM    316  O   LEU    38      20.348  93.092   2.978  1.00 28.95           O  
ATOM    317  CB  LEU    38      18.899  90.991   1.185  1.00 29.21           C  
ATOM    318  CG  LEU    38      17.831  90.701   0.112  1.00 31.12           C  
ATOM    319  CD1 LEU    38      17.082  89.424   0.484  1.00 34.54           C  
ATOM    320  CD2 LEU    38      16.852  91.842  -0.035  1.00 33.11           C  
ATOM    321  N   LEU    39      21.966  91.977   1.878  1.00 27.62           N  
ATOM    322  CA  LEU    39      22.974  92.206   2.908  1.00 27.59           C  
ATOM    323  C   LEU    39      24.313  92.237   2.187  1.00 28.12           C  
ATOM    324  O   LEU    39      24.488  91.511   1.199  1.00 27.03           O  
ATOM    325  CB  LEU    39      22.991  91.061   3.946  1.00 27.40           C  
ATOM    326  CG  LEU    39      23.959  91.142   5.147  1.00 25.84           C  
ATOM    327  CD1 LEU    39      23.580  92.343   6.090  1.00 24.88           C  
ATOM    328  CD2 LEU    39      24.067  89.811   5.954  1.00 25.72           C  
ATOM    329  N   LYS    40      25.220  93.093   2.662  1.00 29.03           N  
ATOM    330  CA  LYS    40      26.610  93.179   2.156  1.00 28.54           C  
ATOM    331  C   LYS    40      27.613  92.901   3.253  1.00 27.90           C  
ATOM    332  O   LYS    40      27.402  93.253   4.386  1.00 27.71           O  
ATOM    333  CB  LYS    40      26.938  94.550   1.525  1.00 28.99           C  
ATOM    334  CG  LYS    40      25.914  94.983   0.505  1.00 34.64           C  
ATOM    335  CD  LYS    40      26.262  96.348  -0.052  1.00 40.99           C  
ATOM    336  CE  LYS    40      25.507  96.569  -1.343  1.00 45.67           C  
ATOM    337  NZ  LYS    40      26.235  95.907  -2.482  1.00 48.74           N  
ATOM    338  N   THR    41      28.724  92.270   2.910  1.00 28.43           N  
ATOM    339  CA  THR    41      29.823  92.188   3.859  1.00 28.59           C  
ATOM    340  C   THR    41      30.061  93.573   4.465  1.00 30.51           C  
ATOM    341  O   THR    41      30.131  94.582   3.734  1.00 30.38           O  
ATOM    342  CB  THR    41      31.108  91.673   3.185  1.00 29.04           C  
ATOM    343  OG1 THR    41      30.842  90.376   2.634  1.00 28.61           O  
ATOM    344  CG2 THR    41      32.273  91.625   4.165  1.00 28.77           C  
ATOM    345  N   GLY    42      30.176  93.611   5.794  1.00 30.56           N  
ATOM    346  CA  GLY    42      30.497  94.867   6.489  1.00 31.04           C  
ATOM    347  C   GLY    42      29.276  95.629   6.974  1.00 30.86           C  
ATOM    348  O   GLY    42      29.409  96.512   7.819  1.00 31.79           O  
ATOM    349  N   GLU    43      28.097  95.325   6.414  1.00 29.61           N  
ATOM    350  CA  GLU    43      26.833  95.894   6.857  0.50 29.80           C  
ATOM    352  C   GLU    43      26.349  95.199   8.122  1.00 29.88           C  
ATOM    353  O   GLU    43      26.463  93.985   8.227  1.00 27.82           O  
ATOM    354  CB  GLU    43      25.774  95.732   5.752  0.50 29.71           C  
ATOM    356  CG  GLU    43      24.433  96.389   6.016  0.50 30.21           C  
ATOM    358  CD  GLU    43      23.401  96.120   4.900  0.50 30.50           C  
ATOM    360  OE1 GLU    43      23.721  95.413   3.939  0.50 30.91           O  
ATOM    362  OE2 GLU    43      22.258  96.615   4.990  0.50 34.01           O  
ATOM    364  N   ILE    44      25.777  95.966   9.065  1.00 28.87           N  
ATOM    365  CA  ILE    44      25.324  95.321  10.298  1.00 30.12           C  
ATOM    366  C   ILE    44      24.153  94.367   9.988  1.00 29.26           C  
ATOM    367  O   ILE    44      23.139  94.785   9.412  1.00 29.13           O  
ATOM    368  CB  ILE    44      24.958  96.340  11.406  1.00 30.13           C  
ATOM    369  CG1 ILE    44      26.209  97.156  11.815  1.00 31.22           C  
ATOM    370  CG2 ILE    44      24.330  95.599  12.614  1.00 30.46           C  
ATOM    371  CD1 ILE    44      25.915  98.284  12.807  1.00 32.85           C  
ATOM    372  N   CYS    45      24.291  93.095  10.352  1.00 27.90           N  
ATOM    373  CA  CYS    45      23.266  92.118  10.031  1.00 27.82           C  
ATOM    374  C   CYS    45      22.160  92.113  11.093  1.00 28.84           C  
ATOM    375  O   CYS    45      22.436  91.831  12.279  1.00 29.35           O  
ATOM    376  CB  CYS    45      23.890  90.716   9.890  1.00 26.35           C  
ATOM    377  SG  CYS    45      22.739  89.399   9.638  1.00 28.31           S  
ATOM    378  N   ARG    46      20.940  92.446  10.668  1.00 27.49           N  
ATOM    379  CA  ARG    46      19.777  92.509  11.578  1.00 27.47           C  
ATOM    380  C   ARG    46      18.732  91.472  11.262  1.00 27.37           C  
ATOM    381  O   ARG    46      17.843  91.258  12.081  1.00 28.28           O  
ATOM    382  CB  ARG    46      19.049  93.874  11.456  1.00 26.68           C  
ATOM    383  CG  ARG    46      19.951  95.078  11.667  1.00 30.29           C  
ATOM    384  CD  ARG    46      20.389  95.216  13.107  1.00 28.40           C  
ATOM    385  NE  ARG    46      20.992  96.554  13.356  1.00 28.66           N  
ATOM    386  CZ  ARG    46      21.661  96.871  14.472  1.00 27.27           C  
ATOM    387  NH1 ARG    46      21.790  95.973  15.439  1.00 25.77           N  
ATOM    388  NH2 ARG    46      22.238  98.091  14.608  1.00 24.30           N  
ATOM    389  N   ILE    47      18.738  90.900  10.044  1.00 26.41           N  
ATOM    390  CA  ILE    47      17.529  90.261   9.545  1.00 25.92           C  
ATOM    391  C   ILE    47      17.730  88.764   9.244  1.00 26.77           C  
ATOM    392  O   ILE    47      18.730  88.385   8.676  1.00 26.26           O  
ATOM    393  CB  ILE    47      16.967  90.966   8.293  1.00 26.83           C  
ATOM    394  CG1 ILE    47      16.517  92.403   8.639  1.00 29.01           C  
ATOM    395  CG2 ILE    47      15.773  90.192   7.687  1.00 24.05           C  
ATOM    396  CD1 ILE    47      16.067  93.208   7.424  1.00 28.16           C  
ATOM    397  N   ASN    48      16.729  87.984   9.623  1.00 24.63           N  
ATOM    398  CA  ASN    48      16.640  86.571   9.305  1.00 25.12           C  
ATOM    399  C   ASN    48      15.469  86.451   8.330  1.00 25.44           C  
ATOM    400  O   ASN    48      14.387  87.026   8.600  1.00 26.23           O  
ATOM    401  CB  ASN    48      16.355  85.782  10.594  1.00 24.06           C  
ATOM    402  CG  ASN    48      16.539  84.288  10.417  1.00 25.45           C  
ATOM    403  OD1 ASN    48      17.084  83.826   9.420  1.00 27.53           O  
ATOM    404  ND2 ASN    48      16.068  83.532  11.394  1.00 26.52           N  
ATOM    405  N   TYR    49      15.686  85.719   7.221  1.00 24.41           N  
ATOM    406  CA  TYR    49      14.685  85.546   6.160  1.00 24.21           C  
ATOM    407  C   TYR    49      14.111  84.133   6.042  1.00 24.89           C  
ATOM    408  O   TYR    49      14.861  83.126   6.064  1.00 24.78           O  
ATOM    409  CB  TYR    49      15.273  85.884   4.775  1.00 24.01           C  
ATOM    410  CG  TYR    49      15.759  87.320   4.657  1.00 25.14           C  
ATOM    411  CD1 TYR    49      14.863  88.349   4.348  1.00 24.49           C  
ATOM    412  CD2 TYR    49      17.099  87.627   4.856  1.00 25.95           C  
ATOM    413  CE1 TYR    49      15.268  89.660   4.244  1.00 25.61           C  
ATOM    414  CE2 TYR    49      17.542  88.972   4.746  1.00 27.66           C  
ATOM    415  CZ  TYR    49      16.625  89.960   4.435  1.00 26.96           C  
ATOM    416  OH  TYR    49      17.034  91.271   4.360  1.00 27.32           O  
ATOM    417  N   PHE    50      12.790  84.064   5.860  1.00 25.11           N  
ATOM    418  CA  PHE    50      12.121  82.811   5.525  1.00 24.45           C  
ATOM    419  C   PHE    50      11.728  82.983   4.069  1.00 26.02           C  
ATOM    420  O   PHE    50      11.103  84.017   3.710  1.00 25.13           O  
ATOM    421  CB  PHE    50      10.844  82.641   6.380  1.00 25.93           C  
ATOM    422  CG  PHE    50      10.022  81.422   6.018  1.00 28.12           C  
ATOM    423  CD1 PHE    50      10.435  80.155   6.421  1.00 28.78           C  
ATOM    424  CD2 PHE    50       8.834  81.534   5.283  1.00 29.85           C  
ATOM    425  CE1 PHE    50       9.687  79.016   6.120  1.00 29.62           C  
ATOM    426  CE2 PHE    50       8.087  80.387   4.946  1.00 29.58           C  
ATOM    427  CZ  PHE    50       8.516  79.126   5.377  1.00 29.75           C  
ATOM    428  N   VAL    51      12.095  82.002   3.233  1.00 25.56           N  
ATOM    429  CA  VAL    51      11.784  82.060   1.798  1.00 25.59           C  
ATOM    430  C   VAL    51      10.378  81.448   1.542  1.00 26.29           C  
ATOM    431  O   VAL    51      10.180  80.245   1.643  1.00 27.75           O  
ATOM    432  CB  VAL    51      12.859  81.328   0.992  1.00 26.79           C  
ATOM    433  CG1 VAL    51      12.535  81.357  -0.532  1.00 27.36           C  
ATOM    434  CG2 VAL    51      14.288  81.929   1.328  1.00 24.10           C  
ATOM    435  N   VAL    52       9.420  82.297   1.213  1.00 26.33           N  
ATOM    436  CA  VAL    52       8.079  81.819   0.827  1.00 27.64           C  
ATOM    437  C   VAL    52       8.133  81.254  -0.593  1.00 29.22           C  
ATOM    438  O   VAL    52       7.628  80.134  -0.876  1.00 29.39           O  
ATOM    439  CB  VAL    52       7.039  82.943   0.950  1.00 27.44           C  
ATOM    440  CG1 VAL    52       5.650  82.473   0.375  1.00 27.88           C  
ATOM    441  CG2 VAL    52       6.900  83.402   2.486  1.00 27.52           C  
ATOM    442  N   LYS    53       8.756  82.033  -1.484  1.00 28.91           N  
ATOM    443  CA  LYS    53       8.921  81.627  -2.884  1.00 29.80           C  
ATOM    444  C   LYS    53      10.270  82.137  -3.338  1.00 28.20           C  
ATOM    445  O   LYS    53      10.644  83.254  -3.009  1.00 28.04           O  
ATOM    446  CB  LYS    53       7.796  82.256  -3.751  1.00 31.51           C  
ATOM    447  CG  LYS    53       7.724  81.694  -5.184  1.00 37.96           C  
ATOM    448  CD  LYS    53       7.084  82.721  -6.139  1.00 46.92           C  
ATOM    449  CE  LYS    53       7.327  82.351  -7.618  1.00 50.31           C  
ATOM    450  NZ  LYS    53       7.578  83.564  -8.497  1.00 53.90           N  
ATOM    451  N   GLY    54      10.996  81.323  -4.096  1.00 29.09           N  
ATOM    452  CA  GLY    54      12.221  81.771  -4.735  1.00 28.59           C  
ATOM    453  C   GLY    54      13.456  81.096  -4.169  1.00 29.23           C  
ATOM    454  O   GLY    54      13.447  79.913  -3.748  1.00 27.39           O  
ATOM    455  N   CYS    55      14.530  81.877  -4.150  1.00 29.77           N  
ATOM    456  CA  CYS    55      15.797  81.347  -3.764  1.00 28.45           C  
ATOM    457  C   CYS    55      16.719  82.490  -3.437  1.00 27.32           C  
ATOM    458  O   CYS    55      16.817  83.476  -4.172  1.00 26.25           O  
ATOM    459  CB  CYS    55      16.354  80.453  -4.879  1.00 28.57           C  
ATOM    460  SG  CYS    55      18.009  79.839  -4.546  1.00 33.92           S  
ATOM    461  N   LEU    56      17.367  82.366  -2.279  1.00 27.20           N  
ATOM    462  CA  LEU    56      18.400  83.345  -1.866  1.00 26.68           C  
ATOM    463  C   LEU    56      19.751  82.637  -1.909  1.00 27.29           C  
ATOM    464  O   LEU    56      19.808  81.428  -1.701  1.00 28.62           O  
ATOM    465  CB  LEU    56      18.119  83.787  -0.427  1.00 25.98           C  
ATOM    466  CG  LEU    56      16.848  84.641  -0.168  1.00 25.89           C  
ATOM    467  CD1 LEU    56      16.697  84.964   1.318  1.00 26.18           C  
ATOM    468  CD2 LEU    56      16.914  85.949  -1.037  1.00 27.79           C  
ATOM    469  N   ARG    57      20.846  83.372  -2.088  1.00 27.26           N  
ATOM    470  CA  ARG    57      22.165  82.768  -1.882  1.00 27.09           C  
ATOM    471  C   ARG    57      22.987  83.582  -0.900  1.00 27.27           C  
ATOM    472  O   ARG    57      22.825  84.799  -0.788  1.00 27.32           O  
ATOM    473  CB  ARG    57      22.945  82.612  -3.184  1.00 28.66           C  
ATOM    474  CG  ARG    57      23.358  83.902  -3.802  1.00 29.00           C  
ATOM    475  CD  ARG    57      24.448  83.678  -4.876  1.00 33.51           C  
ATOM    476  NE  ARG    57      24.690  84.912  -5.613  1.00 38.28           N  
ATOM    477  CZ  ARG    57      25.880  85.294  -6.098  1.00 37.41           C  
ATOM    478  NH1 ARG    57      26.956  84.543  -5.916  1.00 36.50           N  
ATOM    479  NH2 ARG    57      25.980  86.438  -6.768  1.00 36.09           N  
ATOM    480  N   LEU    58      23.856  82.875  -0.184  1.00 26.17           N  
ATOM    481  CA  LEU    58      24.817  83.491   0.714  1.00 25.91           C  
ATOM    482  C   LEU    58      26.191  83.399   0.040  1.00 25.10           C  
ATOM    483  O   LEU    58      26.592  82.313  -0.415  1.00 25.25           O  
ATOM    484  CB  LEU    58      24.867  82.678   2.010  1.00 25.05           C  
ATOM    485  CG  LEU    58      25.616  83.289   3.183  1.00 26.67           C  
ATOM    486  CD1 LEU    58      24.817  84.447   3.795  1.00 24.00           C  
ATOM    487  CD2 LEU    58      25.853  82.158   4.215  1.00 29.33           C  
ATOM    488  N   PHE    59      26.912  84.510  -0.035  1.00 24.53           N  
ATOM    489  CA  PHE    59      28.247  84.438  -0.626  1.00 25.47           C  
ATOM    490  C   PHE    59      29.203  85.442  -0.017  1.00 26.18           C  
ATOM    491  O   PHE    59      28.812  86.341   0.720  1.00 25.60           O  
ATOM    492  CB  PHE    59      28.171  84.593  -2.173  1.00 25.79           C  
ATOM    493  CG  PHE    59      27.814  85.987  -2.639  1.00 27.16           C  
ATOM    494  CD1 PHE    59      28.830  86.924  -2.911  1.00 27.67           C  
ATOM    495  CD2 PHE    59      26.479  86.349  -2.872  1.00 29.93           C  
ATOM    496  CE1 PHE    59      28.519  88.177  -3.362  1.00 30.45           C  
ATOM    497  CE2 PHE    59      26.150  87.635  -3.345  1.00 31.65           C  
ATOM    498  CZ  PHE    59      27.197  88.554  -3.590  1.00 29.24           C  
ATOM    499  N   PHE    60      30.495  85.286  -0.310  1.00 24.93           N  
ATOM    500  CA  PHE    60      31.427  86.317   0.100  1.00 26.69           C  
ATOM    501  C   PHE    60      32.322  86.608  -1.100  1.00 26.43           C  
ATOM    502  O   PHE    60      32.364  85.835  -2.032  1.00 27.63           O  
ATOM    503  CB  PHE    60      32.293  85.897   1.324  1.00 28.02           C  
ATOM    504  CG  PHE    60      33.226  84.738   1.048  1.00 29.58           C  
ATOM    505  CD1 PHE    60      34.584  84.964   0.755  1.00 31.06           C  
ATOM    506  CD2 PHE    60      32.751  83.434   1.082  1.00 30.17           C  
ATOM    507  CE1 PHE    60      35.440  83.884   0.501  1.00 30.51           C  
ATOM    508  CE2 PHE    60      33.584  82.364   0.845  1.00 31.77           C  
ATOM    509  CZ  PHE    60      34.954  82.593   0.549  1.00 31.61           C  
ATOM    510  N   ILE    61      33.045  87.701  -1.050  1.00 24.64           N  
ATOM    511  CA  ILE    61      33.899  88.053  -2.165  1.00 24.55           C  
ATOM    512  C   ILE    61      35.318  87.865  -1.681  1.00 23.88           C  
ATOM    513  O   ILE    61      35.711  88.443  -0.650  1.00 23.08           O  
ATOM    514  CB  ILE    61      33.666  89.512  -2.617  1.00 24.37           C  
ATOM    515  CG1 ILE    61      32.208  89.703  -3.125  1.00 25.41           C  
ATOM    516  CG2 ILE    61      34.742  89.900  -3.631  1.00 25.01           C  
ATOM    517  CD1 ILE    61      31.808  91.184  -3.435  1.00 26.06           C  
ATOM    518  N   ASP    62      36.083  87.016  -2.371  1.00 24.52           N  
ATOM    519  CA  ASP    62      37.467  86.734  -1.944  1.00 25.39           C  
ATOM    520  C   ASP    62      38.421  87.869  -2.319  1.00 26.19           C  
ATOM    521  O   ASP    62      37.989  88.866  -2.888  1.00 25.90           O  
ATOM    522  CB  ASP    62      37.930  85.329  -2.395  1.00 26.19           C  
ATOM    523  CG  ASP    62      38.161  85.221  -3.895  1.00 27.32           C  
ATOM    524  OD1 ASP    62      38.360  86.256  -4.532  1.00 23.92           O  
ATOM    525  OD2 ASP    62      38.176  84.083  -4.429  1.00 28.48           O  
ATOM    526  N   GLU    63      39.698  87.769  -1.965  1.00 26.98           N  
ATOM    527  CA  GLU    63      40.595  88.917  -2.148  1.00 28.72           C  
ATOM    528  C   GLU    63      40.989  89.145  -3.627  1.00 28.11           C  
ATOM    529  O   GLU    63      41.682  90.104  -3.940  1.00 27.38           O  
ATOM    530  CB  GLU    63      41.816  88.843  -1.214  1.00 29.81           C  
ATOM    531  CG  GLU    63      42.125  87.449  -0.654  1.00 34.42           C  
ATOM    532  CD  GLU    63      42.552  86.462  -1.738  1.00 38.64           C  
ATOM    533  OE1 GLU    63      43.670  86.628  -2.284  1.00 41.59           O  
ATOM    534  OE2 GLU    63      41.764  85.522  -2.031  1.00 41.42           O  
ATOM    535  N   LYS    64      40.491  88.281  -4.516  1.00 28.45           N  
ATOM    536  CA  LYS    64      40.646  88.442  -5.973  1.00 29.17           C  
ATOM    537  C   LYS    64      39.355  88.980  -6.599  1.00 29.11           C  
ATOM    538  O   LYS    64      39.277  89.182  -7.816  1.00 29.70           O  
ATOM    539  CB  LYS    64      41.022  87.101  -6.613  1.00 29.76           C  
ATOM    540  CG  LYS    64      42.421  86.575  -6.245  1.00 30.87           C  
ATOM    541  CD  LYS    64      43.526  87.514  -6.692  1.00 32.16           C  
ATOM    542  CE  LYS    64      44.911  86.834  -6.647  1.00 33.65           C  
ATOM    543  NZ  LYS    64      45.133  85.959  -7.825  1.00 32.95           N  
ATOM    544  N   GLY    65      38.347  89.202  -5.750  1.00 28.22           N  
ATOM    545  CA  GLY    65      37.083  89.802  -6.155  1.00 27.28           C  
ATOM    546  C   GLY    65      36.104  88.786  -6.697  1.00 27.39           C  
ATOM    547  O   GLY    65      35.061  89.168  -7.268  1.00 26.97           O  
ATOM    548  N   ILE    66      36.431  87.496  -6.513  1.00 25.59           N  
ATOM    549  CA  ILE    66      35.589  86.408  -6.977  1.00 27.24           C  
ATOM    550  C   ILE    66      34.523  86.098  -5.926  1.00 28.02           C  
ATOM    551  O   ILE    66      34.852  85.907  -4.750  1.00 27.80           O  
ATOM    552  CB  ILE    66      36.424  85.113  -7.312  1.00 27.59           C  
ATOM    553  CG1 ILE    66      37.593  85.411  -8.264  1.00 26.99           C  
ATOM    554  CG2 ILE    66      35.500  84.025  -7.908  1.00 28.59           C  
ATOM    555  CD1 ILE    66      37.185  86.004  -9.570  1.00 29.37           C  
ATOM    556  N   GLU    67      33.260  86.053  -6.346  1.00 28.73           N  
ATOM    557  CA  GLU    67      32.149  85.697  -5.460  1.00 29.44           C  
ATOM    558  C   GLU    67      32.185  84.205  -5.223  1.00 30.00           C  
ATOM    559  O   GLU    67      32.293  83.429  -6.179  1.00 30.29           O  
ATOM    560  CB  GLU    67      30.805  86.084  -6.086  1.00 29.64           C  
ATOM    561  CG  GLU    67      30.616  87.602  -6.284  1.00 31.04           C  
ATOM    562  CD  GLU    67      29.242  87.999  -6.860  1.00 32.64           C  
ATOM    563  OE1 GLU    67      28.449  87.098  -7.207  1.00 36.80           O  
ATOM    564  OE2 GLU    67      28.970  89.220  -6.947  1.00 35.82           O  
ATOM    565  N   GLN    68      32.172  83.797  -3.952  1.00 28.00           N  
ATOM    566  CA  GLN    68      32.223  82.380  -3.589  1.00 28.23           C  
ATOM    567  C   GLN    68      30.913  82.110  -2.887  1.00 28.70           C  
ATOM    568  O   GLN    68      30.653  82.670  -1.805  1.00 27.71           O  
ATOM    569  CB  GLN    68      33.416  82.110  -2.672  1.00 28.54           C  
ATOM    570  CG  GLN    68      34.799  82.496  -3.292  1.00 30.45           C  
ATOM    571  CD  GLN    68      35.174  81.632  -4.486  1.00 31.42           C  
ATOM    572  OE1 GLN    68      34.559  80.595  -4.709  1.00 35.17           O  
ATOM    573  NE2 GLN    68      36.185  82.042  -5.245  1.00 28.94           N  
ATOM    574  N   THR    69      30.061  81.299  -3.514  1.00 29.28           N  
ATOM    575  CA  THR    69      28.716  81.067  -2.945  1.00 30.78           C  
ATOM    576  C   THR    69      28.836  79.915  -1.959  1.00 30.43           C  
ATOM    577  O   THR    69      29.430  78.889  -2.271  1.00 31.31           O  
ATOM    578  CB  THR    69      27.650  80.831  -4.057  1.00 31.92           C  
ATOM    579  OG1 THR    69      27.552  82.020  -4.853  1.00 35.39           O  
ATOM    580  CG2 THR    69      26.241  80.519  -3.437  1.00 34.07           C  
ATOM    581  N   THR    70      28.321  80.114  -0.753  1.00 29.63           N  
ATOM    582  CA  THR    70      28.503  79.114   0.291  1.00 30.82           C  
ATOM    583  C   THR    70      27.220  78.385   0.643  1.00 30.79           C  
ATOM    584  O   THR    70      27.272  77.273   1.157  1.00 32.58           O  
ATOM    585  CB  THR    70      29.177  79.712   1.546  1.00 30.99           C  
ATOM    586  OG1 THR    70      28.347  80.751   2.066  1.00 33.44           O  
ATOM    587  CG2 THR    70      30.572  80.304   1.162  1.00 28.80           C  
ATOM    588  N   GLN    71      26.082  78.963   0.301  1.00 30.87           N  
ATOM    589  CA  GLN    71      24.814  78.365   0.687  1.00 31.36           C  
ATOM    590  C   GLN    71      23.707  78.934  -0.168  1.00 30.45           C  
ATOM    591  O   GLN    71      23.799  80.064  -0.629  1.00 29.68           O  
ATOM    592  CB  GLN    71      24.530  78.774   2.146  1.00 30.20           C  
ATOM    593  CG  GLN    71      23.729  77.831   2.842  1.00 33.77           C  
ATOM    594  CD  GLN    71      23.382  78.339   4.206  1.00 32.33           C  
ATOM    595  OE1 GLN    71      24.233  78.841   4.952  1.00 27.31           O  
ATOM    596  NE2 GLN    71      22.147  78.250   4.525  1.00 33.10           N  
ATOM    597  N   PHE    72      22.676  78.120  -0.409  1.00 30.53           N  
ATOM    598  CA  PHE    72      21.418  78.601  -0.972  1.00 30.52           C  
ATOM    599  C   PHE    72      20.315  78.332   0.063  1.00 30.83           C  
ATOM    600  O   PHE    72      20.438  77.440   0.946  1.00 31.94           O  
ATOM    601  CB  PHE    72      21.080  77.883  -2.283  1.00 30.48           C  
ATOM    602  CG  PHE    72      22.036  78.176  -3.412  1.00 33.13           C  
ATOM    603  CD1 PHE    72      21.861  79.310  -4.226  1.00 35.20           C  
ATOM    604  CD2 PHE    72      23.102  77.323  -3.675  1.00 36.49           C  
ATOM    605  CE1 PHE    72      22.718  79.596  -5.301  1.00 34.01           C  
ATOM    606  CE2 PHE    72      23.981  77.597  -4.750  1.00 38.20           C  
ATOM    607  CZ  PHE    72      23.778  78.734  -5.556  1.00 34.14           C  
ATOM    608  N   ALA    73      19.240  79.079  -0.039  1.00 29.89           N  
ATOM    609  CA  ALA    73      18.017  78.768   0.718  1.00 29.05           C  
ATOM    610  C   ALA    73      16.854  78.791  -0.254  1.00 29.58           C  
ATOM    611  O   ALA    73      16.606  79.815  -0.908  1.00 28.30           O  
ATOM    612  CB  ALA    73      17.806  79.797   1.820  1.00 28.98           C  
ATOM    613  N   ILE    74      16.166  77.663  -0.409  1.00 28.24           N  
ATOM    614  CA  ILE    74      14.980  77.681  -1.272  1.00 29.33           C  
ATOM    615  C   ILE    74      13.688  77.825  -0.473  1.00 27.85           C  
ATOM    616  O   ILE    74      13.740  78.064   0.743  1.00 27.43           O  
ATOM    617  CB  ILE    74      14.950  76.454  -2.244  1.00 28.42           C  
ATOM    618  CG1 ILE    74      14.962  75.146  -1.474  1.00 31.63           C  
ATOM    619  CG2 ILE    74      16.131  76.571  -3.243  1.00 33.01           C  
ATOM    620  CD1 ILE    74      14.620  73.922  -2.322  1.00 30.05           C  
ATOM    621  N   GLU    75      12.539  77.699  -1.140  1.00 26.93           N  
ATOM    622  CA  GLU    75      11.241  77.845  -0.444  1.00 27.39           C  
ATOM    623  C   GLU    75      11.158  77.000   0.827  1.00 26.81           C  
ATOM    624  O   GLU    75      11.629  75.866   0.853  1.00 25.55           O  
ATOM    625  CB  GLU    75      10.008  77.561  -1.323  1.00 27.75           C  
ATOM    626  CG  GLU    75      10.158  76.635  -2.474  1.00 33.39           C  
ATOM    627  CD  GLU    75      10.834  77.308  -3.694  1.00 38.52           C  
ATOM    628  OE1 GLU    75      11.984  76.891  -3.878  1.00 40.07           O  
ATOM    629  OE2 GLU    75      10.246  78.210  -4.450  1.00 39.40           O  
ATOM    630  N   ASN    76      10.582  77.590   1.873  1.00 27.32           N  
ATOM    631  CA  ASN    76      10.362  76.924   3.147  1.00 28.29           C  
ATOM    632  C   ASN    76      11.637  76.755   3.971  1.00 29.01           C  
ATOM    633  O   ASN    76      11.656  75.985   4.924  1.00 29.87           O  
ATOM    634  CB  ASN    76       9.620  75.585   2.967  1.00 27.43           C  
ATOM    635  CG  ASN    76       8.237  75.790   2.400  1.00 29.59           C  
ATOM    636  OD1 ASN    76       7.561  76.770   2.733  1.00 28.47           O  
ATOM    637  ND2 ASN    76       7.817  74.895   1.517  1.00 29.70           N  
ATOM    638  N   TRP    77      12.675  77.504   3.629  1.00 28.80           N  
ATOM    639  CA  TRP    77      13.830  77.502   4.489  1.00 29.21           C  
ATOM    640  C   TRP    77      14.308  78.918   4.796  1.00 28.24           C  
ATOM    641  O   TRP    77      13.666  79.895   4.360  1.00 27.91           O  
ATOM    642  CB  TRP    77      14.907  76.574   3.984  1.00 31.46           C  
ATOM    643  CG  TRP    77      15.722  75.969   5.116  1.00 33.53           C  
ATOM    644  CD1 TRP    77      17.036  76.227   5.374  1.00 36.02           C  
ATOM    645  CD2 TRP    77      15.288  75.034   6.141  1.00 37.27           C  
ATOM    646  NE1 TRP    77      17.454  75.521   6.467  1.00 36.47           N  
ATOM    647  CE2 TRP    77      16.417  74.778   6.963  1.00 38.09           C  
ATOM    648  CE3 TRP    77      14.058  74.397   6.452  1.00 34.94           C  
ATOM    649  CZ2 TRP    77      16.374  73.891   8.052  1.00 33.78           C  
ATOM    650  CZ3 TRP    77      14.019  73.508   7.543  1.00 35.05           C  
ATOM    651  CH2 TRP    77      15.169  73.268   8.326  1.00 34.22           C  
ATOM    652  N   TRP    78      15.330  79.000   5.639  1.00 25.99           N  
ATOM    653  CA  TRP    78      15.728  80.267   6.310  1.00 25.11           C  
ATOM    654  C   TRP    78      17.143  80.657   5.856  1.00 25.83           C  
ATOM    655  O   TRP    78      17.964  79.758   5.552  1.00 26.64           O  
ATOM    656  CB  TRP    78      15.727  80.044   7.835  1.00 24.52           C  
ATOM    657  CG  TRP    78      14.326  79.842   8.393  1.00 24.77           C  
ATOM    658  CD1 TRP    78      13.641  78.661   8.503  1.00 22.96           C  
ATOM    659  CD2 TRP    78      13.488  80.859   8.963  1.00 23.74           C  
ATOM    660  NE1 TRP    78      12.375  78.901   9.057  1.00 23.31           N  
ATOM    661  CE2 TRP    78      12.271  80.238   9.350  1.00 23.46           C  
ATOM    662  CE3 TRP    78      13.612  82.258   9.093  1.00 23.75           C  
ATOM    663  CZ2 TRP    78      11.206  80.958   9.926  1.00 22.78           C  
ATOM    664  CZ3 TRP    78      12.558  82.973   9.668  1.00 23.21           C  
ATOM    665  CH2 TRP    78      11.374  82.325  10.076  1.00 24.33           C  
ATOM    666  N   LEU    79      17.461  81.954   5.900  1.00 24.49           N  
ATOM    667  CA  LEU    79      18.823  82.359   5.693  1.00 24.90           C  
ATOM    668  C   LEU    79      19.112  83.674   6.394  1.00 25.04           C  
ATOM    669  O   LEU    79      18.276  84.594   6.408  1.00 23.51           O  
ATOM    670  CB  LEU    79      19.122  82.468   4.202  1.00 25.40           C  
ATOM    671  CG  LEU    79      20.601  82.648   3.787  1.00 25.37           C  
ATOM    672  CD1 LEU    79      21.417  81.402   4.189  1.00 28.96           C  
ATOM    673  CD2 LEU    79      20.647  82.828   2.259  1.00 27.28           C  
ATOM    674  N   SER    80      20.312  83.744   6.952  1.00 23.91           N  
ATOM    675  CA  SER    80      20.878  84.975   7.401  1.00 24.65           C  
ATOM    676  C   SER    80      22.387  84.707   7.415  1.00 25.25           C  
ATOM    677  O   SER    80      22.845  83.580   7.112  1.00 25.24           O  
ATOM    678  CB  SER    80      20.412  85.249   8.844  1.00 24.16           C  
ATOM    679  OG  SER    80      20.821  86.577   9.197  1.00 26.45           O  
ATOM    680  N   ASP    81      23.134  85.724   7.799  1.00 24.66           N  
ATOM    681  CA  ASP    81      24.540  85.523   8.232  1.00 25.25           C  
ATOM    682  C   ASP    81      24.439  85.303   9.737  1.00 24.06           C  
ATOM    683  O   ASP    81      24.395  86.281  10.492  1.00 24.96           O  
ATOM    684  CB  ASP    81      25.331  86.817   7.914  1.00 25.03           C  
ATOM    685  CG  ASP    81      26.788  86.776   8.386  1.00 27.06           C  
ATOM    686  OD1 ASP    81      27.137  86.013   9.347  1.00 25.21           O  
ATOM    687  OD2 ASP    81      27.597  87.563   7.808  1.00 28.27           O  
ATOM    688  N   TYR    82      24.396  84.043  10.177  1.00 22.29           N  
ATOM    689  CA  TYR    82      23.954  83.780  11.534  1.00 23.35           C  
ATOM    690  C   TYR    82      24.930  84.259  12.620  1.00 23.30           C  
ATOM    691  O   TYR    82      24.521  84.630  13.698  1.00 25.96           O  
ATOM    692  CB  TYR    82      23.523  82.303  11.743  1.00 23.07           C  
ATOM    693  CG  TYR    82      22.158  82.075  11.056  1.00 24.49           C  
ATOM    694  CD1 TYR    82      20.989  82.611  11.597  1.00 24.67           C  
ATOM    695  CD2 TYR    82      22.075  81.404   9.834  1.00 23.21           C  
ATOM    696  CE1 TYR    82      19.731  82.451  10.950  1.00 26.41           C  
ATOM    697  CE2 TYR    82      20.834  81.226   9.183  1.00 27.02           C  
ATOM    698  CZ  TYR    82      19.672  81.783   9.737  1.00 24.85           C  
ATOM    699  OH  TYR    82      18.466  81.626   9.090  1.00 25.74           O  
ATOM    700  N   MET    83      26.219  84.238  12.348  1.00 22.17           N  
ATOM    701  CA  MET    83      27.116  84.753  13.362  1.00 23.05           C  
ATOM    702  C   MET    83      26.864  86.280  13.522  1.00 23.66           C  
ATOM    703  O   MET    83      26.759  86.789  14.648  1.00 23.70           O  
ATOM    704  CB  MET    83      28.545  84.523  12.919  1.00 23.63           C  
ATOM    705  CG  MET    83      29.526  84.995  13.958  1.00 27.35           C  
ATOM    706  SD  MET    83      29.497  83.973  15.604  0.50 25.15          SE  
ATOM    707  CE  MET    83      30.198  82.301  14.922  1.00 31.50           C  
ATOM    708  N   ALA    84      26.774  86.991  12.394  1.00 24.41           N  
ATOM    709  CA  ALA    84      26.555  88.475  12.459  1.00 25.61           C  
ATOM    710  C   ALA    84      25.200  88.846  13.062  1.00 27.19           C  
ATOM    711  O   ALA    84      25.092  89.810  13.839  1.00 27.55           O  
ATOM    712  CB  ALA    84      26.732  89.086  11.076  1.00 26.28           C  
ATOM    713  N   PHE    85      24.188  88.062  12.706  1.00 26.21           N  
ATOM    714  CA  PHE    85      22.839  88.148  13.243  1.00 26.87           C  
ATOM    715  C   PHE    85      22.827  87.969  14.773  1.00 27.10           C  
ATOM    716  O   PHE    85      22.328  88.829  15.499  1.00 27.17           O  
ATOM    717  CB  PHE    85      21.979  87.038  12.554  1.00 26.52           C  
ATOM    718  CG  PHE    85      20.537  87.027  12.947  1.00 27.00           C  
ATOM    719  CD1 PHE    85      19.674  88.057  12.538  1.00 24.10           C  
ATOM    720  CD2 PHE    85      20.011  85.905  13.603  1.00 25.88           C  
ATOM    721  CE1 PHE    85      18.313  87.995  12.884  1.00 24.43           C  
ATOM    722  CE2 PHE    85      18.652  85.836  13.983  1.00 26.09           C  
ATOM    723  CZ  PHE    85      17.802  86.892  13.600  1.00 24.90           C  
ATOM    724  N   GLN    86      23.424  86.896  15.267  1.00 26.06           N  
ATOM    725  CA  GLN    86      23.374  86.621  16.712  0.60 27.05           C  
ATOM    727  C   GLN    86      24.243  87.566  17.510  1.00 27.36           C  
ATOM    728  O   GLN    86      23.949  87.828  18.690  1.00 29.30           O  
ATOM    729  CB  GLN    86      23.708  85.156  17.030  0.60 26.51           C  
ATOM    731  CG  GLN    86      25.184  84.781  16.881  0.60 26.01           C  
ATOM    733  CD  GLN    86      25.449  83.301  17.190  0.60 27.84           C  
ATOM    735  OE1 GLN    86      24.509  82.526  17.432  0.60 29.34           O  
ATOM    737  NE2 GLN    86      26.730  82.908  17.200  0.60 26.12           N  
ATOM    739  N   LYS    87      25.320  88.062  16.903  1.00 26.90           N  
ATOM    740  CA  LYS    87      26.246  88.976  17.617  1.00 27.98           C  
ATOM    741  C   LYS    87      25.907  90.431  17.364  1.00 29.00           C  
ATOM    742  O   LYS    87      26.506  91.308  18.006  1.00 28.89           O  
ATOM    743  CB  LYS    87      27.708  88.694  17.276  1.00 28.93           C  
ATOM    744  CG  LYS    87      28.183  87.375  17.904  1.00 30.17           C  
ATOM    745  CD  LYS    87      29.670  87.170  17.849  1.00 38.80           C  
ATOM    746  CE  LYS    87      29.992  85.937  18.703  1.00 43.13           C  
ATOM    747  NZ  LYS    87      31.323  85.323  18.408  1.00 46.84           N  
ATOM    748  N   GLN    88      24.961  90.671  16.441  1.00 28.12           N  
ATOM    749  CA  GLN    88      24.471  92.033  16.110  1.00 28.81           C  
ATOM    750  C   GLN    88      25.631  92.880  15.633  1.00 29.38           C  
ATOM    751  O   GLN    88      25.899  93.986  16.134  1.00 29.66           O  
ATOM    752  CB  GLN    88      23.745  92.693  17.291  1.00 29.05           C  
ATOM    753  CG  GLN    88      22.689  91.775  17.871  1.00 30.09           C  
ATOM    754  CD  GLN    88      21.847  92.412  18.947  1.00 35.67           C  
ATOM    755  OE1 GLN    88      20.905  93.137  18.648  1.00 35.26           O  
ATOM    756  NE2 GLN    88      22.134  92.085  20.208  1.00 35.54           N  
ATOM    757  N   GLN    89      26.332  92.370  14.648  1.00 29.11           N  
ATOM    758  CA  GLN    89      27.538  93.044  14.222  1.00 29.79           C  
ATOM    759  C   GLN    89      27.679  93.030  12.695  1.00 28.73           C  
ATOM    760  O   GLN    89      26.835  92.410  12.005  1.00 28.94           O  
ATOM    761  CB  GLN    89      28.749  92.407  14.928  1.00 30.93           C  
ATOM    762  CG  GLN    89      29.030  91.030  14.422  1.00 34.61           C  
ATOM    763  CD  GLN    89      30.109  90.295  15.201  1.00 37.37           C  
ATOM    764  OE1 GLN    89      30.430  90.647  16.339  1.00 37.89           O  
ATOM    765  NE2 GLN    89      30.662  89.246  14.591  1.00 36.82           N  
ATOM    766  N   PRO    90      28.712  93.719  12.150  1.00 28.42           N  
ATOM    767  CA  PRO    90      28.933  93.685  10.696  1.00 28.31           C  
ATOM    768  C   PRO    90      29.005  92.254  10.088  1.00 27.58           C  
ATOM    769  O   PRO    90      29.627  91.345  10.667  1.00 27.08           O  
ATOM    770  CB  PRO    90      30.259  94.451  10.528  1.00 28.55           C  
ATOM    771  CG  PRO    90      30.266  95.409  11.668  1.00 27.96           C  
ATOM    772  CD  PRO    90      29.677  94.641  12.819  1.00 29.27           C  
ATOM    773  N   ALA    91      28.329  92.096   8.960  1.00 26.86           N  
ATOM    774  CA  ALA    91      28.270  90.828   8.197  1.00 26.41           C  
ATOM    775  C   ALA    91      29.607  90.366   7.585  1.00 25.79           C  
ATOM    776  O   ALA    91      30.445  91.179   7.126  1.00 25.57           O  
ATOM    777  CB  ALA    91      27.212  90.939   7.105  1.00 25.91           C  
ATOM    778  N   ASP    92      29.825  89.061   7.610  1.00 24.82           N  
ATOM    779  CA  ASP    92      30.871  88.463   6.818  1.00 26.01           C  
ATOM    780  C   ASP    92      30.358  88.244   5.393  1.00 25.99           C  
ATOM    781  O   ASP    92      31.137  88.281   4.454  1.00 28.27           O  
ATOM    782  CB  ASP    92      31.310  87.148   7.391  1.00 25.89           C  
ATOM    783  CG  ASP    92      32.346  87.322   8.456  1.00 30.90           C  
ATOM    784  OD1 ASP    92      33.449  87.813   8.126  1.00 33.45           O  
ATOM    785  OD2 ASP    92      32.046  86.968   9.597  1.00 32.70           O  
ATOM    786  N   PHE    93      29.063  88.009   5.247  1.00 25.38           N  
ATOM    787  CA  PHE    93      28.509  87.564   3.965  1.00 26.74           C  
ATOM    788  C   PHE    93      27.563  88.556   3.291  1.00 27.28           C  
ATOM    789  O   PHE    93      26.943  89.411   3.945  1.00 29.28           O  
ATOM    790  CB  PHE    93      27.706  86.263   4.145  1.00 25.79           C  
ATOM    791  CG  PHE    93      28.527  85.101   4.621  1.00 27.39           C  
ATOM    792  CD1 PHE    93      29.264  84.339   3.717  1.00 29.18           C  
ATOM    793  CD2 PHE    93      28.550  84.759   5.980  1.00 27.84           C  
ATOM    794  CE1 PHE    93      30.003  83.230   4.138  1.00 26.90           C  
ATOM    795  CE2 PHE    93      29.285  83.672   6.421  1.00 23.85           C  
ATOM    796  CZ  PHE    93      30.029  82.909   5.509  1.00 27.70           C  
ATOM    797  N   TYR    94      27.438  88.391   1.971  1.00 26.98           N  
ATOM    798  CA  TYR    94      26.335  89.004   1.208  1.00 25.97           C  
ATOM    799  C   TYR    94      25.173  88.036   1.151  1.00 25.30           C  
ATOM    800  O   TYR    94      25.384  86.818   1.145  1.00 26.59           O  
ATOM    801  CB  TYR    94      26.768  89.229  -0.253  1.00 27.23           C  
ATOM    802  CG  TYR    94      27.716  90.401  -0.502  1.00 27.22           C  
ATOM    803  CD1 TYR    94      27.251  91.570  -1.155  1.00 29.76           C  
ATOM    804  CD2 TYR    94      29.070  90.328  -0.138  1.00 28.45           C  
ATOM    805  CE1 TYR    94      28.097  92.623  -1.426  1.00 29.69           C  
ATOM    806  CE2 TYR    94      29.933  91.408  -0.395  1.00 30.94           C  
ATOM    807  CZ  TYR    94      29.432  92.534  -1.057  1.00 31.21           C  
ATOM    808  OH  TYR    94      30.249  93.612  -1.305  1.00 31.02           O  
ATOM    809  N   ILE    95      23.956  88.570   1.107  1.00 24.74           N  
ATOM    810  CA  ILE    95      22.788  87.758   0.792  1.00 25.48           C  
ATOM    811  C   ILE    95      22.170  88.420  -0.436  1.00 26.46           C  
ATOM    812  O   ILE    95      22.007  89.656  -0.455  1.00 27.11           O  
ATOM    813  CB  ILE    95      21.749  87.750   1.923  1.00 25.11           C  
ATOM    814  CG1 ILE    95      22.378  87.138   3.217  1.00 26.06           C  
ATOM    815  CG2 ILE    95      20.491  86.928   1.499  1.00 27.49           C  
ATOM    816  CD1 ILE    95      21.506  87.396   4.437  1.00 27.10           C  
ATOM    817  N   GLN    96      21.850  87.624  -1.452  1.00 26.45           N  
ATOM    818  CA  GLN    96      21.290  88.158  -2.695  1.00 27.54           C  
ATOM    819  C   GLN    96      20.244  87.171  -3.255  1.00 27.92           C  
ATOM    820  O   GLN    96      20.436  85.949  -3.165  1.00 28.19           O  
ATOM    821  CB  GLN    96      22.432  88.421  -3.662  1.00 27.92           C  
ATOM    822  CG  GLN    96      22.039  88.996  -5.007  1.00 30.39           C  
ATOM    823  CD  GLN    96      23.242  89.101  -5.934  1.00 36.84           C  
ATOM    824  OE1 GLN    96      23.485  88.214  -6.726  1.00 37.97           O  
ATOM    825  NE2 GLN    96      24.025  90.163  -5.784  1.00 41.58           N  
ATOM    826  N   SER    97      19.155  87.708  -3.812  1.00 28.34           N  
ATOM    827  CA  SER    97      18.131  86.872  -4.451  1.00 29.81           C  
ATOM    828  C   SER    97      18.675  86.275  -5.745  1.00 30.30           C  
ATOM    829  O   SER    97      19.360  86.958  -6.532  1.00 31.77           O  
ATOM    830  CB  SER    97      16.862  87.661  -4.739  1.00 28.99           C  
ATOM    831  OG  SER    97      17.171  88.810  -5.522  1.00 29.82           O  
ATOM    832  N   VAL    98      18.393  85.005  -5.960  1.00 30.55           N  
ATOM    833  CA  VAL    98      18.845  84.318  -7.169  1.00 32.02           C  
ATOM    834  C   VAL    98      17.693  84.357  -8.178  1.00 32.10           C  
ATOM    835  O   VAL    98      17.894  84.468  -9.405  1.00 32.17           O  
ATOM    836  CB  VAL    98      19.281  82.862  -6.859  1.00 32.41           C  
ATOM    837  CG1 VAL    98      19.431  82.052  -8.163  1.00 32.76           C  
ATOM    838  CG2 VAL    98      20.624  82.839  -6.056  1.00 33.54           C  
ATOM    839  N   GLU    99      16.483  84.243  -7.645  1.00 32.34           N  
ATOM    840  CA  GLU    99      15.242  84.336  -8.416  1.00 32.68           C  
ATOM    841  C   GLU    99      14.422  85.481  -7.845  1.00 31.73           C  
ATOM    842  O   GLU    99      14.799  86.094  -6.828  1.00 31.07           O  
ATOM    843  CB  GLU    99      14.437  83.021  -8.285  1.00 34.67           C  
ATOM    844  CG  GLU    99      15.243  81.782  -8.609  1.00 36.89           C  
ATOM    845  CD  GLU    99      14.582  80.504  -8.155  1.00 43.87           C  
ATOM    846  OE1 GLU    99      13.416  80.547  -7.688  1.00 45.32           O  
ATOM    847  OE2 GLU    99      15.244  79.443  -8.274  1.00 45.36           O  
ATOM    848  N   ASN   100      13.310  85.790  -8.493  1.00 29.42           N  
ATOM    849  CA  ASN   100      12.331  86.675  -7.855  1.00 29.62           C  
ATOM    850  C   ASN   100      11.877  85.972  -6.588  1.00 29.64           C  
ATOM    851  O   ASN   100      11.627  84.765  -6.612  1.00 30.45           O  
ATOM    852  CB  ASN   100      11.126  86.914  -8.757  1.00 29.08           C  
ATOM    853  CG  ASN   100      11.495  87.647 -10.032  1.00 27.21           C  
ATOM    854  OD1 ASN   100      12.422  88.490 -10.039  1.00 26.34           O  
ATOM    855  ND2 ASN   100      10.765  87.332 -11.147  1.00 26.70           N  
ATOM    856  N   CYS   101      11.798  86.702  -5.478  1.00 29.22           N  
ATOM    857  CA  CYS   101      11.463  86.074  -4.183  1.00 29.09           C  
ATOM    858  C   CYS   101      10.290  86.745  -3.500  1.00 28.84           C  
ATOM    859  O   CYS   101      10.149  87.974  -3.566  1.00 28.79           O  
ATOM    860  CB  CYS   101      12.636  86.226  -3.212  1.00 29.71           C  
ATOM    861  SG  CYS   101      14.076  85.270  -3.619  1.00 30.98           S  
ATOM    862  N   GLU   102       9.500  85.950  -2.773  1.00 28.82           N  
ATOM    863  CA  GLU   102       8.631  86.469  -1.737  1.00 27.61           C  
ATOM    864  C   GLU   102       9.252  86.018  -0.412  1.00 26.76           C  
ATOM    865  O   GLU   102       9.508  84.815  -0.210  1.00 25.17           O  
ATOM    866  CB  GLU   102       7.232  85.896  -1.875  1.00 29.61           C  
ATOM    867  CG  GLU   102       6.598  86.263  -3.203  1.00 33.14           C  
ATOM    868  CD  GLU   102       5.160  85.808  -3.317  1.00 40.92           C  
ATOM    869  OE1 GLU   102       4.782  84.816  -2.654  1.00 44.22           O  
ATOM    870  OE2 GLU   102       4.408  86.441  -4.097  1.00 47.10           O  
ATOM    871  N   LEU   103       9.593  86.975   0.447  1.00 26.29           N  
ATOM    872  CA  LEU   103      10.246  86.647   1.733  1.00 27.19           C  
ATOM    873  C   LEU   103       9.437  87.120   2.918  1.00 28.63           C  
ATOM    874  O   LEU   103       8.609  88.052   2.817  1.00 29.15           O  
ATOM    875  CB  LEU   103      11.617  87.349   1.808  1.00 26.22           C  
ATOM    876  CG  LEU   103      12.535  87.118   0.596  1.00 26.79           C  
ATOM    877  CD1 LEU   103      13.795  87.943   0.712  1.00 28.37           C  
ATOM    878  CD2 LEU   103      12.873  85.642   0.474  1.00 25.09           C  
ATOM    879  N   LEU   104       9.700  86.507   4.067  1.00 27.80           N  
ATOM    880  CA  LEU   104       9.199  87.007   5.349  1.00 29.14           C  
ATOM    881  C   LEU   104      10.421  87.268   6.203  1.00 28.59           C  
ATOM    882  O   LEU   104      11.286  86.400   6.312  1.00 29.54           O  
ATOM    883  CB  LEU   104       8.281  85.978   6.004  1.00 28.42           C  
ATOM    884  CG  LEU   104       6.867  85.802   5.389  1.00 30.50           C  
ATOM    885  CD1 LEU   104       6.124  84.634   6.036  1.00 27.77           C  
ATOM    886  CD2 LEU   104       6.022  87.102   5.457  1.00 31.68           C  
ATOM    887  N   SER   105      10.540  88.472   6.733  1.00 27.50           N  
ATOM    888  CA  SER   105      11.745  88.865   7.451  1.00 27.64           C  
ATOM    889  C   SER   105      11.413  89.168   8.896  1.00 27.13           C  
ATOM    890  O   SER   105      10.286  89.598   9.255  1.00 25.67           O  
ATOM    891  CB  SER   105      12.409  90.127   6.803  1.00 27.68           C  
ATOM    892  OG  SER   105      11.514  91.246   6.892  1.00 30.65           O  
ATOM    893  N   ILE   106      12.388  88.937   9.744  1.00 26.60           N  
ATOM    894  CA  ILE   106      12.282  89.307  11.170  1.00 26.21           C  
ATOM    895  C   ILE   106      13.655  89.779  11.649  1.00 26.50           C  
ATOM    896  O   ILE   106      14.669  89.265  11.173  1.00 25.97           O  
ATOM    897  CB  ILE   106      11.749  88.119  12.029  1.00 26.11           C  
ATOM    898  CG1 ILE   106      11.433  88.574  13.467  1.00 27.78           C  
ATOM    899  CG2 ILE   106      12.741  86.886  12.041  1.00 25.53           C  
ATOM    900  CD1 ILE   106      10.524  87.579  14.211  1.00 26.98           C  
ATOM    901  N   THR   107      13.697  90.770  12.536  1.00 26.46           N  
ATOM    902  CA  THR   107      14.999  91.231  13.072  1.00 27.56           C  
ATOM    903  C   THR   107      15.432  90.363  14.251  1.00 27.61           C  
ATOM    904  O   THR   107      14.617  89.600  14.825  1.00 28.35           O  
ATOM    905  CB  THR   107      14.958  92.708  13.521  1.00 27.75           C  
ATOM    906  OG1 THR   107      14.126  92.825  14.698  1.00 26.61           O  
ATOM    907  CG2 THR   107      14.453  93.617  12.370  1.00 29.63           C  
ATOM    908  N   TYR   108      16.716  90.425  14.601  1.00 26.57           N  
ATOM    909  CA  TYR   108      17.200  89.677  15.763  1.00 27.79           C  
ATOM    910  C   TYR   108      16.418  90.044  17.050  1.00 28.30           C  
ATOM    911  O   TYR   108      15.997  89.138  17.811  1.00 27.35           O  
ATOM    912  CB  TYR   108      18.715  89.881  15.972  1.00 28.81           C  
ATOM    913  CG  TYR   108      19.252  89.181  17.203  1.00 29.46           C  
ATOM    914  CD1 TYR   108      19.522  87.804  17.165  1.00 29.54           C  
ATOM    915  CD2 TYR   108      19.439  89.874  18.422  1.00 31.79           C  
ATOM    916  CE1 TYR   108      20.001  87.139  18.268  1.00 30.49           C  
ATOM    917  CE2 TYR   108      19.916  89.183  19.591  1.00 31.73           C  
ATOM    918  CZ  TYR   108      20.188  87.810  19.467  1.00 32.49           C  
ATOM    919  OH  TYR   108      20.629  87.076  20.530  1.00 34.22           O  
ATOM    920  N   THR   109      16.241  91.349  17.268  1.00 28.11           N  
ATOM    921  CA  THR   109      15.501  91.841  18.447  1.00 30.16           C  
ATOM    922  C   THR   109      14.083  91.265  18.476  1.00 29.25           C  
ATOM    923  O   THR   109      13.616  90.762  19.508  1.00 30.49           O  
ATOM    924  CB  THR   109      15.493  93.398  18.437  1.00 30.28           C  
ATOM    925  OG1 THR   109      16.847  93.841  18.453  1.00 35.83           O  
ATOM    926  CG2 THR   109      14.807  93.954  19.689  1.00 32.74           C  
ATOM    927  N   GLU   110      13.410  91.323  17.333  1.00 28.92           N  
ATOM    928  CA  GLU   110      12.037  90.832  17.197  1.00 29.84           C  
ATOM    929  C   GLU   110      11.943  89.338  17.408  1.00 29.38           C  
ATOM    930  O   GLU   110      11.032  88.861  18.080  1.00 28.78           O  
ATOM    931  CB  GLU   110      11.465  91.180  15.818  1.00 29.42           C  
ATOM    932  CG  GLU   110      11.205  92.692  15.615  1.00 31.89           C  
ATOM    933  CD  GLU   110      11.075  93.114  14.113  1.00 34.21           C  
ATOM    934  OE1 GLU   110      11.210  92.255  13.192  1.00 33.55           O  
ATOM    935  OE2 GLU   110      10.843  94.344  13.850  1.00 38.54           O  
ATOM    936  N   GLN   111      12.883  88.609  16.813  1.00 27.94           N  
ATOM    937  CA  GLN   111      12.923  87.159  16.963  1.00 29.32           C  
ATOM    938  C   GLN   111      13.122  86.725  18.448  1.00 29.46           C  
ATOM    939  O   GLN   111      12.483  85.783  18.883  1.00 28.15           O  
ATOM    940  CB  GLN   111      13.983  86.540  16.053  1.00 28.82           C  
ATOM    941  CG  GLN   111      13.801  85.005  16.024  1.00 30.24           C  
ATOM    942  CD  GLN   111      14.537  84.294  14.919  1.00 30.90           C  
ATOM    943  OE1 GLN   111      15.019  84.883  13.959  1.00 31.79           O  
ATOM    944  NE2 GLN   111      14.583  82.976  15.038  1.00 34.95           N  
ATOM    945  N   GLU   112      13.984  87.417  19.200  1.00 29.90           N  
ATOM    946  CA  GLU   112      14.170  87.124  20.638  1.00 31.06           C  
ATOM    947  C   GLU   112      12.886  87.416  21.433  1.00 31.40           C  
ATOM    948  O   GLU   112      12.463  86.584  22.249  1.00 32.23           O  
ATOM    949  CB  GLU   112      15.402  87.848  21.209  1.00 32.73           C  
ATOM    950  CG  GLU   112      16.737  87.298  20.642  1.00 35.25           C  
ATOM    951  CD  GLU   112      16.939  85.797  20.876  1.00 38.14           C  
ATOM    952  OE1 GLU   112      16.672  85.294  21.985  1.00 45.23           O  
ATOM    953  OE2 GLU   112      17.360  85.078  19.949  1.00 42.93           O  
ATOM    954  N   ASN   113      12.233  88.540  21.137  1.00 30.93           N  
ATOM    955  CA  ASN   113      10.908  88.858  21.722  1.00 31.75           C  
ATOM    956  C   ASN   113       9.895  87.753  21.379  1.00 30.80           C  
ATOM    957  O   ASN   113       9.123  87.299  22.249  1.00 30.73           O  
ATOM    958  CB  ASN   113      10.386  90.202  21.205  1.00 32.66           C  
ATOM    959  CG  ASN   113      11.212  91.403  21.697  1.00 38.15           C  
ATOM    960  OD1 ASN   113      12.059  91.281  22.594  1.00 43.80           O  
ATOM    961  ND2 ASN   113      10.987  92.564  21.081  1.00 40.35           N  
ATOM    962  N   LEU   114       9.924  87.307  20.128  1.00 30.29           N  
ATOM    963  CA  LEU   114       9.011  86.276  19.651  1.00 29.96           C  
ATOM    964  C   LEU   114       9.199  84.960  20.405  1.00 29.67           C  
ATOM    965  O   LEU   114       8.201  84.306  20.772  1.00 28.74           O  
ATOM    966  CB  LEU   114       9.172  86.043  18.134  1.00 30.19           C  
ATOM    967  CG  LEU   114       8.325  84.912  17.510  1.00 30.52           C  
ATOM    968  CD1 LEU   114       6.788  85.035  17.752  1.00 32.13           C  
ATOM    969  CD2 LEU   114       8.634  84.817  16.031  1.00 31.41           C  
ATOM    970  N   PHE   115      10.466  84.567  20.640  1.00 28.59           N  
ATOM    971  CA  PHE   115      10.753  83.353  21.446  1.00 29.30           C  
ATOM    972  C   PHE   115      10.185  83.434  22.858  1.00 30.66           C  
ATOM    973  O   PHE   115       9.772  82.412  23.399  1.00 29.77           O  
ATOM    974  CB  PHE   115      12.248  83.083  21.545  1.00 28.49           C  
ATOM    975  CG  PHE   115      12.841  82.420  20.318  1.00 28.99           C  
ATOM    976  CD1 PHE   115      12.365  81.162  19.857  1.00 26.84           C  
ATOM    977  CD2 PHE   115      13.930  83.017  19.651  1.00 30.02           C  
ATOM    978  CE1 PHE   115      12.945  80.527  18.740  1.00 28.11           C  
ATOM    979  CE2 PHE   115      14.525  82.385  18.539  1.00 28.74           C  
ATOM    980  CZ  PHE   115      14.043  81.150  18.080  1.00 27.86           C  
ATOM    981  N   GLU   116      10.167  84.643  23.421  1.00 30.65           N  
ATOM    982  CA  GLU   116       9.611  84.836  24.758  0.50 32.29           C  
ATOM    984  C   GLU   116       8.081  84.813  24.737  1.00 32.43           C  
ATOM    985  O   GLU   116       7.461  84.288  25.663  1.00 32.54           O  
ATOM    986  CB  GLU   116      10.124  86.131  25.400  0.50 31.91           C  
ATOM    988  CG  GLU   116       9.747  86.263  26.896  0.50 32.62           C  
ATOM    990  CD  GLU   116      10.074  87.616  27.515  0.50 33.98           C  
ATOM    992  OE1 GLU   116      10.272  88.602  26.771  0.50 37.77           O  
ATOM    994  OE2 GLU   116      10.122  87.699  28.770  0.50 34.80           O  
ATOM    996  N   ARG   117       7.481  85.359  23.688  1.00 32.12           N  
ATOM    997  CA  ARG   117       6.041  85.466  23.561  1.00 32.92           C  
ATOM    998  C   ARG   117       5.430  84.119  23.181  1.00 33.13           C  
ATOM    999  O   ARG   117       4.338  83.760  23.648  1.00 31.91           O  
ATOM   1000  CB  ARG   117       5.714  86.547  22.505  1.00 32.54           C  
ATOM   1001  CG  ARG   117       4.227  86.778  22.182  1.00 34.87           C  
ATOM   1002  CD  ARG   117       3.438  87.326  23.396  1.00 36.50           C  
ATOM   1003  NE  ARG   117       2.007  87.497  23.081  1.00 39.39           N  
ATOM   1004  CZ  ARG   117       1.123  86.498  23.023  1.00 39.26           C  
ATOM   1005  NH1 ARG   117       1.493  85.240  23.275  1.00 39.59           N  
ATOM   1006  NH2 ARG   117      -0.139  86.757  22.717  1.00 41.70           N  
ATOM   1007  N   ILE   118       6.140  83.362  22.334  1.00 33.00           N  
ATOM   1008  CA  ILE   118       5.607  82.107  21.830  1.00 32.53           C  
ATOM   1009  C   ILE   118       6.703  81.053  21.985  1.00 33.02           C  
ATOM   1010  O   ILE   118       7.413  80.743  21.031  1.00 32.17           O  
ATOM   1011  CB  ILE   118       5.108  82.189  20.343  1.00 32.76           C  
ATOM   1012  CG1 ILE   118       4.303  83.489  20.054  1.00 34.16           C  
ATOM   1013  CG2 ILE   118       4.371  80.897  19.967  1.00 32.37           C  
ATOM   1014  CD1 ILE   118       2.917  83.331  19.523  1.00 37.85           C  
ATOM   1015  N   PRO   119       6.870  80.545  23.215  1.00 32.74           N  
ATOM   1016  CA  PRO   119       7.955  79.608  23.562  1.00 31.98           C  
ATOM   1017  C   PRO   119       7.889  78.289  22.812  1.00 30.16           C  
ATOM   1018  O   PRO   119       8.897  77.597  22.715  1.00 29.16           O  
ATOM   1019  CB  PRO   119       7.743  79.365  25.074  1.00 32.45           C  
ATOM   1020  CG  PRO   119       6.890  80.535  25.536  1.00 34.09           C  
ATOM   1021  CD  PRO   119       6.040  80.907  24.382  1.00 33.31           C  
ATOM   1022  N   ALA   120       6.702  77.923  22.312  1.00 29.31           N  
ATOM   1023  CA  ALA   120       6.569  76.690  21.522  1.00 28.55           C  
ATOM   1024  C   ALA   120       7.501  76.762  20.276  1.00 28.42           C  
ATOM   1025  O   ALA   120       7.914  75.729  19.715  1.00 28.68           O  
ATOM   1026  CB  ALA   120       5.134  76.512  21.080  1.00 29.85           C  
ATOM   1027  N   LEU   121       7.847  77.985  19.868  1.00 26.18           N  
ATOM   1028  CA  LEU   121       8.701  78.189  18.697  1.00 28.68           C  
ATOM   1029  C   LEU   121      10.153  77.792  18.959  1.00 27.35           C  
ATOM   1030  O   LEU   121      10.897  77.562  18.010  1.00 27.18           O  
ATOM   1031  CB  LEU   121       8.654  79.652  18.320  1.00 28.92           C  
ATOM   1032  CG  LEU   121       8.434  80.171  16.935  1.00 37.48           C  
ATOM   1033  CD1 LEU   121       7.988  79.167  15.817  1.00 35.13           C  
ATOM   1034  CD2 LEU   121       7.312  81.093  17.331  1.00 37.39           C  
ATOM   1035  N   GLU   122      10.537  77.649  20.226  1.00 26.01           N  
ATOM   1036  CA  GLU   122      11.905  77.214  20.504  1.00 26.67           C  
ATOM   1037  C   GLU   122      12.133  75.864  19.856  1.00 26.16           C  
ATOM   1038  O   GLU   122      13.203  75.605  19.319  1.00 25.52           O  
ATOM   1039  CB  GLU   122      12.140  77.090  22.015  1.00 26.51           C  
ATOM   1040  CG  GLU   122      12.151  78.435  22.725  1.00 26.66           C  
ATOM   1041  CD  GLU   122      13.426  79.214  22.564  1.00 29.48           C  
ATOM   1042  OE1 GLU   122      14.355  78.766  21.847  1.00 28.38           O  
ATOM   1043  OE2 GLU   122      13.533  80.300  23.209  1.00 28.65           O  
ATOM   1044  N   ARG   123      11.113  75.000  19.916  1.00 25.62           N  
ATOM   1045  CA  ARG   123      11.278  73.672  19.326  1.00 26.27           C  
ATOM   1046  C   ARG   123      11.379  73.752  17.802  1.00 25.70           C  
ATOM   1047  O   ARG   123      12.168  73.025  17.173  1.00 25.10           O  
ATOM   1048  CB  ARG   123      10.135  72.735  19.768  1.00 26.48           C  
ATOM   1049  CG  ARG   123      10.120  71.367  19.039  1.00 27.96           C  
ATOM   1050  CD  ARG   123       9.030  70.451  19.590  1.00 28.56           C  
ATOM   1051  NE  ARG   123       8.853  69.293  18.705  1.00 32.99           N  
ATOM   1052  CZ  ARG   123       9.548  68.159  18.807  1.00 34.73           C  
ATOM   1053  NH1 ARG   123      10.464  68.010  19.747  1.00 35.07           N  
ATOM   1054  NH2 ARG   123       9.312  67.146  17.972  1.00 34.90           N  
ATOM   1055  N   TYR   124      10.545  74.591  17.201  1.00 24.70           N  
ATOM   1056  CA  TYR   124      10.637  74.764  15.755  1.00 25.06           C  
ATOM   1057  C   TYR   124      12.077  75.170  15.318  1.00 24.76           C  
ATOM   1058  O   TYR   124      12.651  74.573  14.412  1.00 23.76           O  
ATOM   1059  CB  TYR   124       9.618  75.800  15.303  1.00 25.33           C  
ATOM   1060  CG  TYR   124       9.758  76.205  13.843  1.00 25.20           C  
ATOM   1061  CD1 TYR   124       9.395  75.319  12.816  1.00 23.94           C  
ATOM   1062  CD2 TYR   124      10.246  77.454  13.502  1.00 26.22           C  
ATOM   1063  CE1 TYR   124       9.510  75.678  11.446  1.00 24.99           C  
ATOM   1064  CE2 TYR   124      10.357  77.838  12.117  1.00 24.93           C  
ATOM   1065  CZ  TYR   124       9.988  76.951  11.129  1.00 25.18           C  
ATOM   1066  OH  TYR   124      10.109  77.339   9.816  1.00 26.26           O  
ATOM   1067  N   PHE   125      12.633  76.211  15.939  1.00 24.42           N  
ATOM   1068  CA  PHE   125      13.992  76.648  15.579  1.00 25.50           C  
ATOM   1069  C   PHE   125      15.099  75.689  16.013  1.00 26.08           C  
ATOM   1070  O   PHE   125      16.135  75.585  15.345  1.00 25.69           O  
ATOM   1071  CB  PHE   125      14.228  78.083  16.024  1.00 25.75           C  
ATOM   1072  CG  PHE   125      13.709  79.082  15.040  1.00 30.13           C  
ATOM   1073  CD1 PHE   125      14.347  79.243  13.793  1.00 30.80           C  
ATOM   1074  CD2 PHE   125      12.578  79.812  15.309  1.00 32.41           C  
ATOM   1075  CE1 PHE   125      13.863  80.159  12.849  1.00 31.99           C  
ATOM   1076  CE2 PHE   125      12.087  80.748  14.333  1.00 33.89           C  
ATOM   1077  CZ  PHE   125      12.744  80.893  13.134  1.00 27.76           C  
ATOM   1078  N   ARG   126      14.870  74.936  17.083  1.00 25.26           N  
ATOM   1079  CA  ARG   126      15.821  73.856  17.453  1.00 25.06           C  
ATOM   1080  C   ARG   126      15.934  72.940  16.246  1.00 24.57           C  
ATOM   1081  O   ARG   126      17.043  72.585  15.804  1.00 23.95           O  
ATOM   1082  CB  ARG   126      15.310  73.041  18.675  1.00 24.02           C  
ATOM   1083  CG  ARG   126      16.372  72.098  19.265  1.00 25.54           C  
ATOM   1084  CD  ARG   126      16.238  70.758  18.692  1.00 26.23           C  
ATOM   1085  NE  ARG   126      14.993  70.101  19.133  1.00 28.07           N  
ATOM   1086  CZ  ARG   126      14.662  68.856  18.822  1.00 31.19           C  
ATOM   1087  NH1 ARG   126      15.492  68.120  18.066  1.00 31.12           N  
ATOM   1088  NH2 ARG   126      13.517  68.337  19.297  1.00 31.53           N  
ATOM   1089  N   LEU   127      14.785  72.588  15.684  1.00 24.38           N  
ATOM   1090  CA  LEU   127      14.806  71.635  14.585  1.00 25.34           C  
ATOM   1091  C   LEU   127      15.382  72.282  13.325  1.00 25.72           C  
ATOM   1092  O   LEU   127      16.157  71.652  12.600  1.00 24.19           O  
ATOM   1093  CB  LEU   127      13.423  71.041  14.339  1.00 24.88           C  
ATOM   1094  CG  LEU   127      13.078  69.964  15.378  1.00 26.03           C  
ATOM   1095  CD1 LEU   127      11.554  69.907  15.430  1.00 28.34           C  
ATOM   1096  CD2 LEU   127      13.700  68.607  15.036  1.00 29.91           C  
ATOM   1097  N   VAL   128      14.980  73.527  13.060  1.00 25.25           N  
ATOM   1098  CA  VAL   128      15.532  74.269  11.920  1.00 25.63           C  
ATOM   1099  C   VAL   128      17.059  74.367  12.007  1.00 25.11           C  
ATOM   1100  O   VAL   128      17.803  74.047  11.028  1.00 24.25           O  
ATOM   1101  CB  VAL   128      14.870  75.667  11.774  1.00 24.09           C  
ATOM   1102  CG1 VAL   128      15.657  76.530  10.784  1.00 26.61           C  
ATOM   1103  CG2 VAL   128      13.433  75.513  11.330  1.00 26.53           C  
ATOM   1104  N   TYR   129      17.570  74.777  13.164  1.00 25.29           N  
ATOM   1105  CA  TYR   129      19.035  74.925  13.258  1.00 25.16           C  
ATOM   1106  C   TYR   129      19.790  73.589  13.298  1.00 26.00           C  
ATOM   1107  O   TYR   129      20.926  73.496  12.804  1.00 24.79           O  
ATOM   1108  CB  TYR   129      19.414  75.828  14.415  1.00 26.17           C  
ATOM   1109  CG  TYR   129      18.984  77.275  14.211  1.00 27.09           C  
ATOM   1110  CD1 TYR   129      19.258  77.939  13.017  1.00 32.09           C  
ATOM   1111  CD2 TYR   129      18.301  77.976  15.209  1.00 26.69           C  
ATOM   1112  CE1 TYR   129      18.864  79.269  12.833  1.00 32.50           C  
ATOM   1113  CE2 TYR   129      17.908  79.308  15.040  1.00 27.83           C  
ATOM   1114  CZ  TYR   129      18.184  79.947  13.851  1.00 31.34           C  
ATOM   1115  OH  TYR   129      17.813  81.282  13.697  1.00 31.61           O  
ATOM   1116  N   GLN   130      19.189  72.575  13.905  1.00 25.96           N  
ATOM   1117  CA  GLN   130      19.783  71.246  13.922  1.00 26.59           C  
ATOM   1118  C   GLN   130      19.969  70.740  12.503  1.00 26.60           C  
ATOM   1119  O   GLN   130      21.053  70.242  12.127  1.00 25.76           O  
ATOM   1120  CB  GLN   130      18.861  70.310  14.687  1.00 27.53           C  
ATOM   1121  CG  GLN   130      19.392  68.914  14.886  1.00 32.53           C  
ATOM   1122  CD  GLN   130      18.293  68.042  15.451  1.00 38.22           C  
ATOM   1123  OE1 GLN   130      17.809  68.307  16.557  1.00 32.40           O  
ATOM   1124  NE2 GLN   130      17.836  67.023  14.663  1.00 36.38           N  
ATOM   1125  N   LYS   131      18.908  70.875  11.707  1.00 25.74           N  
ATOM   1126  CA  LYS   131      18.944  70.401  10.334  1.00 26.80           C  
ATOM   1127  C   LYS   131      19.927  71.263   9.508  1.00 25.76           C  
ATOM   1128  O   LYS   131      20.629  70.757   8.622  1.00 24.66           O  
ATOM   1129  CB  LYS   131      17.516  70.442   9.753  1.00 27.43           C  
ATOM   1130  CG  LYS   131      16.574  69.388  10.355  1.00 28.41           C  
ATOM   1131  CD  LYS   131      15.091  69.680   9.945  1.00 30.95           C  
ATOM   1132  CE  LYS   131      14.051  68.893  10.754  1.00 37.40           C  
ATOM   1133  NZ  LYS   131      14.239  67.412  10.685  1.00 45.28           N  
ATOM   1134  N   SER   132      19.939  72.571   9.768  1.00 24.39           N  
ATOM   1135  CA  SER   132      20.870  73.479   9.054  1.00 24.99           C  
ATOM   1136  C   SER   132      22.338  73.120   9.366  1.00 24.81           C  
ATOM   1137  O   SER   132      23.192  73.109   8.463  1.00 25.48           O  
ATOM   1138  CB  SER   132      20.576  74.961   9.414  1.00 24.46           C  
ATOM   1139  OG  SER   132      19.247  75.343   9.015  1.00 27.12           O  
ATOM   1140  N   PHE   133      22.621  72.811  10.633  1.00 24.58           N  
ATOM   1141  CA  PHE   133      23.944  72.423  11.064  1.00 24.65           C  
ATOM   1142  C   PHE   133      24.344  71.087  10.426  1.00 25.55           C  
ATOM   1143  O   PHE   133      25.483  70.970   9.923  1.00 25.90           O  
ATOM   1144  CB  PHE   133      23.946  72.305  12.574  1.00 24.28           C  
ATOM   1145  CG  PHE   133      25.270  71.955  13.184  1.00 25.32           C  
ATOM   1146  CD1 PHE   133      26.475  72.338  12.602  1.00 28.48           C  
ATOM   1147  CD2 PHE   133      25.291  71.311  14.407  1.00 28.33           C  
ATOM   1148  CE1 PHE   133      27.710  71.950  13.219  1.00 28.76           C  
ATOM   1149  CE2 PHE   133      26.534  71.006  15.048  1.00 31.22           C  
ATOM   1150  CZ  PHE   133      27.722  71.315  14.393  1.00 26.39           C  
ATOM   1151  N   ALA   134      23.424  70.118  10.420  1.00 25.11           N  
ATOM   1152  CA  ALA   134      23.711  68.804   9.829  1.00 25.25           C  
ATOM   1153  C   ALA   134      24.078  68.985   8.375  1.00 25.62           C  
ATOM   1154  O   ALA   134      25.074  68.415   7.898  1.00 25.37           O  
ATOM   1155  CB  ALA   134      22.510  67.857   9.938  1.00 25.68           C  
ATOM   1156  N   ALA   135      23.250  69.762   7.666  1.00 24.82           N  
ATOM   1157  CA  ALA   135      23.498  70.050   6.254  1.00 25.69           C  
ATOM   1158  C   ALA   135      24.856  70.755   6.036  1.00 25.75           C  
ATOM   1159  O   ALA   135      25.598  70.429   5.073  1.00 23.54           O  
ATOM   1160  CB  ALA   135      22.311  70.877   5.634  1.00 25.86           C  
ATOM   1161  N   ALA   136      25.200  71.688   6.937  1.00 25.47           N  
ATOM   1162  CA  ALA   136      26.470  72.392   6.839  1.00 26.32           C  
ATOM   1163  C   ALA   136      27.674  71.422   7.042  1.00 27.06           C  
ATOM   1164  O   ALA   136      28.680  71.511   6.333  1.00 27.16           O  
ATOM   1165  CB  ALA   136      26.521  73.581   7.820  1.00 26.96           C  
ATOM   1166  N   GLN   137      27.575  70.499   7.989  1.00 26.98           N  
ATOM   1167  CA  GLN   137      28.620  69.487   8.160  1.00 27.97           C  
ATOM   1168  C   GLN   137      28.837  68.712   6.876  1.00 28.91           C  
ATOM   1169  O   GLN   137      29.958  68.550   6.381  1.00 29.69           O  
ATOM   1170  CB  GLN   137      28.267  68.495   9.272  1.00 27.24           C  
ATOM   1171  CG  GLN   137      28.255  69.111  10.654  1.00 27.95           C  
ATOM   1172  CD  GLN   137      28.010  68.034  11.711  1.00 24.63           C  
ATOM   1173  OE1 GLN   137      27.205  67.144  11.486  1.00 26.04           O  
ATOM   1174  NE2 GLN   137      28.725  68.108  12.843  1.00 22.45           N  
ATOM   1175  N   LEU   138      27.736  68.248   6.313  1.00 29.43           N  
ATOM   1176  CA  LEU   138      27.801  67.460   5.070  1.00 31.06           C  
ATOM   1177  C   LEU   138      28.355  68.244   3.887  1.00 31.24           C  
ATOM   1178  O   LEU   138      29.173  67.711   3.117  1.00 32.56           O  
ATOM   1179  CB  LEU   138      26.421  66.907   4.743  1.00 30.90           C  
ATOM   1180  CG  LEU   138      25.932  65.718   5.561  1.00 35.33           C  
ATOM   1181  CD1 LEU   138      24.541  65.394   5.036  1.00 40.31           C  
ATOM   1182  CD2 LEU   138      26.861  64.495   5.442  1.00 39.55           C  
ATOM   1183  N   ARG   139      27.919  69.497   3.730  1.00 31.61           N  
ATOM   1184  CA  ARG   139      28.442  70.382   2.684  1.00 33.10           C  
ATOM   1185  C   ARG   139      29.947  70.449   2.784  1.00 33.18           C  
ATOM   1186  O   ARG   139      30.641  70.478   1.759  1.00 34.58           O  
ATOM   1187  CB  ARG   139      27.872  71.803   2.785  1.00 32.60           C  
ATOM   1188  CG  ARG   139      26.580  71.976   2.006  1.00 35.09           C  
ATOM   1189  CD  ARG   139      26.142  73.463   1.827  1.00 35.86           C  
ATOM   1190  NE  ARG   139      26.024  74.185   3.084  1.00 37.22           N  
ATOM   1191  CZ  ARG   139      24.944  74.250   3.859  1.00 33.46           C  
ATOM   1192  NH1 ARG   139      23.819  73.628   3.530  1.00 35.74           N  
ATOM   1193  NH2 ARG   139      25.005  74.975   4.961  1.00 36.64           N  
ATOM   1194  N   SER   140      30.469  70.489   4.000  1.00 31.37           N  
ATOM   1195  CA  SER   140      31.907  70.637   4.168  1.00 32.91           C  
ATOM   1196  C   SER   140      32.626  69.437   3.547  1.00 32.70           C  
ATOM   1197  O   SER   140      33.651  69.573   2.865  1.00 34.76           O  
ATOM   1198  CB  SER   140      32.269  70.783   5.651  1.00 32.80           C  
ATOM   1199  OG  SER   140      33.591  71.219   5.750  1.00 38.09           O  
ATOM   1200  N   LYS   141      32.091  68.263   3.775  1.00 30.79           N  
ATOM   1201  CA  LYS   141      32.647  67.075   3.186  1.00 30.68           C  
ATOM   1202  C   LYS   141      32.447  67.068   1.657  1.00 30.61           C  
ATOM   1203  O   LYS   141      33.425  66.851   0.902  1.00 31.68           O  
ATOM   1204  CB  LYS   141      32.024  65.839   3.821  1.00 31.24           C  
ATOM   1205  CG  LYS   141      32.481  64.558   3.186  1.00 32.10           C  
ATOM   1206  CD  LYS   141      31.800  63.353   3.819  1.00 35.88           C  
ATOM   1207  CE  LYS   141      32.491  62.073   3.376  1.00 38.69           C  
ATOM   1208  NZ  LYS   141      31.808  60.853   3.901  1.00 40.55           N  
ATOM   1209  N   PHE   142      31.221  67.308   1.196  1.00 27.43           N  
ATOM   1210  CA  PHE   142      30.920  67.211  -0.234  1.00 25.94           C  
ATOM   1211  C   PHE   142      31.634  68.257  -1.079  1.00 24.98           C  
ATOM   1212  O   PHE   142      32.003  67.970  -2.224  1.00 26.08           O  
ATOM   1213  CB  PHE   142      29.405  67.249  -0.494  1.00 25.32           C  
ATOM   1214  CG  PHE   142      28.628  66.136   0.182  1.00 24.00           C  
ATOM   1215  CD1 PHE   142      29.252  64.839   0.363  1.00 23.89           C  
ATOM   1216  CD2 PHE   142      27.244  66.399   0.619  1.00 24.56           C  
ATOM   1217  CE1 PHE   142      28.534  63.822   0.981  1.00 23.90           C  
ATOM   1218  CE2 PHE   142      26.510  65.387   1.200  1.00 25.01           C  
ATOM   1219  CZ  PHE   142      27.162  64.094   1.421  1.00 24.11           C  
ATOM   1220  N   GLN   143      31.829  69.459  -0.536  1.00 23.87           N  
ATOM   1221  CA  GLN   143      32.573  70.523  -1.237  1.00 23.60           C  
ATOM   1222  C   GLN   143      34.016  70.106  -1.482  1.00 22.91           C  
ATOM   1223  O   GLN   143      34.563  70.390  -2.530  1.00 22.81           O  
ATOM   1224  CB  GLN   143      32.587  71.864  -0.479  1.00 23.42           C  
ATOM   1225  CG  GLN   143      31.240  72.425   0.011  1.00 25.39           C  
ATOM   1226  CD  GLN   143      30.349  72.990  -1.084  1.00 27.41           C  
ATOM   1227  OE1 GLN   143      30.101  72.338  -2.103  1.00 29.63           O  
ATOM   1228  NE2 GLN   143      29.842  74.205  -0.865  1.00 26.98           N  
ATOM   1229  N   HIS   144      34.640  69.466  -0.491  1.00 22.60           N  
ATOM   1230  CA  HIS   144      36.029  69.004  -0.631  1.00 22.54           C  
ATOM   1231  C   HIS   144      36.189  67.983  -1.763  1.00 22.70           C  
ATOM   1232  O   HIS   144      37.161  68.026  -2.514  1.00 22.96           O  
ATOM   1233  CB  HIS   144      36.568  68.433   0.693  1.00 21.78           C  
ATOM   1234  CG  HIS   144      37.961  67.898   0.591  1.00 21.11           C  
ATOM   1235  ND1 HIS   144      39.075  68.704   0.665  1.00 22.12           N  
ATOM   1236  CD2 HIS   144      38.421  66.641   0.381  1.00 21.22           C  
ATOM   1237  CE1 HIS   144      40.164  67.967   0.526  1.00 21.22           C  
ATOM   1238  NE2 HIS   144      39.795  66.710   0.352  1.00 21.18           N  
ATOM   1239  N   MET   145      35.213  67.088  -1.882  1.00 23.21           N  
ATOM   1240  CA  MET   145      35.332  65.900  -2.710  1.00 23.70           C  
ATOM   1241  C   MET   145      34.657  66.000  -4.084  1.00 24.31           C  
ATOM   1242  O   MET   145      35.222  65.556  -5.087  1.00 24.31           O  
ATOM   1243  CB  MET   145      34.786  64.691  -1.939  1.00 23.67           C  
ATOM   1244  CG  MET   145      35.498  64.421  -0.619  1.00 23.86           C  
ATOM   1245  SD  MET   145      35.214  62.629   0.083  0.50 23.32          SE  
ATOM   1246  CE  MET   145      36.229  61.589  -1.201  1.00 22.78           C  
ATOM   1247  N   TYR   146      33.459  66.580  -4.123  1.00 24.99           N  
ATOM   1248  CA  TYR   146      32.585  66.478  -5.297  1.00 25.77           C  
ATOM   1249  C   TYR   146      32.118  67.834  -5.826  1.00 25.98           C  
ATOM   1250  O   TYR   146      32.904  68.792  -5.894  1.00 26.27           O  
ATOM   1251  CB  TYR   146      31.380  65.573  -4.975  1.00 26.17           C  
ATOM   1252  CG  TYR   146      31.770  64.269  -4.291  1.00 26.55           C  
ATOM   1253  CD1 TYR   146      32.542  63.309  -4.965  1.00 26.83           C  
ATOM   1254  CD2 TYR   146      31.382  63.997  -2.970  1.00 26.13           C  
ATOM   1255  CE1 TYR   146      32.920  62.117  -4.349  1.00 26.66           C  
ATOM   1256  CE2 TYR   146      31.756  62.803  -2.342  1.00 26.16           C  
ATOM   1257  CZ  TYR   146      32.526  61.868  -3.043  1.00 26.57           C  
ATOM   1258  OH  TYR   146      32.898  60.680  -2.451  1.00 26.59           O  
END
