
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 2097),  selected  133 , name 1wgs_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 1wgs_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    V    11_A      Q       6           #
LGA    T    12_A      G       7          3.299
LGA    -       -      D       8           -
LGA    V    13_A      L       9          1.423
LGA    E    14_A      I      10          1.514
LGA    I    15_A      V      11          0.812
LGA    G    16_A      S      12          0.781
LGA    E    17_A      M      13          1.413
LGA    T    18_A      R      14          1.571
LGA    Y    19_A      I      15          0.889
LGA    L    20_A      L      16          0.562
LGA    C    21_A      G      17          0.289
LGA    R    22_A      K      18          0.952
LGA    R    23_A      K      19          1.954
LGA    P    24_A      R      20          2.942
LGA    D    25_A      T      21          2.719
LGA    S    26_A      K      22          3.773
LGA    T    27_A      T      23          1.558
LGA    W    28_A      W      24          0.715
LGA    H    29_A      X      25          1.299
LGA    S    30_A      K      26          1.439
LGA    A    31_A      G      27          1.638
LGA    E    32_A      T      28          1.020
LGA    V    33_A      L      29          1.091
LGA    I    34_A      I      30          1.044
LGA    Q    35_A      A      31          1.635
LGA    S    36_A      I      32          1.145
LGA    R    37_A      Q      33          1.300
LGA    V    38_A      T      34          1.025
LGA    N    39_A      V      35          1.297
LGA    D    40_A      G      36          0.893
LGA    Q    41_A      -       -           -
LGA    E    42_A      -       -           -
LGA    G    43_A      P      37          2.046
LGA    R    44_A      G      38          1.299
LGA    E    45_A      K      39          0.800
LGA    E    46_A      K      40          0.822
LGA    F    47_A      Y      41          1.410
LGA    Y    48_A      K      42          1.467
LGA    V    49_A      V      43          1.139
LGA    H    50_A      K      44          0.901
LGA    Y    51_A      F      45          1.593
LGA    V    52_A      D      46          2.192
LGA    G    53_A      N      47          0.679
LGA    F    54_A      K      48          1.722
LGA    N    55_A      G      49          3.668
LGA    R    56_A      -       -           -
LGA    R    57_A      -       -           -
LGA    L    58_A      -       -           -
LGA    D    59_A      K      50          2.186
LGA    E    60_A      S      51          2.803
LGA    W    61_A      L      52          1.713
LGA    V    62_A      L      53          1.200
LGA    D    63_A      S      54          1.615
LGA    K    64_A      G      55          1.496
LGA    N    65_A      N      56          1.089
LGA    R    66_A      X      57          0.401
LGA    L    67_A      I      58          0.364
LGA    A    68_A      A      59          0.354
LGA    L    69_A      Y      60          3.409
LGA    T    70_A      D      61          6.772
LGA    K    71_A      Y      62          5.831
LGA    T    72_A      -       -           -
LGA    V    73_A      -       -           -
LGA    K    74_A      -       -           -
LGA    D    75_A      -       -           -
LGA    A    76_A      -       -           -
LGA    V    77_A      -       -           -
LGA    Q    78_A      -       -           -
LGA    K    79_A      -       -           -
LGA    N    80_A      -       -           -
LGA    S    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    Y    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    S    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    L    88_A      -       -           -
LGA    A    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    Q    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    R    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    I    96_A      -       -           -
LGA    T    97_A      -       -           -
LGA    R    98_A      -       -           -
LGA    N    99_A      -       -           -
LGA    Q   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    R   102_A      -       -           -
LGA    K   103_A      -       -           -
LGA    H   104_A      -       -           -
LGA    D   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    I   107_A      -       -           -
LGA    N   108_A      -       -           -
LGA    H   109_A      -       -           -
LGA    V   110_A      -       -           -
LGA    Q   111_A      -       -           -
LGA    K   112_A      -       -           -
LGA    T   113_A      -       -           -
LGA    Y   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    M   117_A      -       -           -
LGA    D   118_A      -       -           -
LGA    P   119_A      -       -           -
LGA    T   120_A      -       -           -
LGA    T   121_A      -       -           -
LGA    A   122_A      -       -           -
LGA    A   123_A      -       -           -
LGA    L   124_A      -       -           -
LGA    E   125_A      -       -           -
LGA    K   126_A      -       -           -
LGA    E   127_A      -       -           -
LGA    S   128_A      -       -           -
LGA    G   129_A      -       -           -
LGA    P   130_A      -       -           -
LGA    S   131_A      -       -           -
LGA    S   132_A      -       -           -
LGA    G   133_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133   62    5.0     55    2.05    12.73     80.498     2.555

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.251382 * X  +   0.559006 * Y  +   0.790139 * Z  +  20.100597
  Y_new =  -0.248925 * X  +  -0.826233 * Y  +   0.505346 * Z  +  57.093185
  Z_new =   0.935331 * X  +  -0.069651 * Y  +   0.346851 * Z  +  52.739933 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.198174    2.943419  [ DEG:   -11.3545    168.6455 ]
  Theta =  -1.209193   -1.932400  [ DEG:   -69.2816   -110.7184 ]
  Phi   =  -2.361104    0.780489  [ DEG:  -135.2813     44.7187 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wgs_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wgs_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133   62   5.0   55   2.05   12.73  80.498
REMARK  ---------------------------------------------------------- 
MOLECULE 1wgs_A
HEADER    TRANSFERASE                             28-MAY-04   1WGS              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN FROM MOUSE                     
TITLE    2 HYPOTHETICAL PROTEIN HOMOLOGOUS TO HISTONE                           
TITLE    3 ACETYLTRANSFERASE                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MYST HISTONE ACETYLTRANSFERASE 1;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN 5830450F21RIK;                         
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 5830450F21;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P031110-09;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, MYST FAMILY, HISTONE ACETYLTRANFERASE,                  
KEYWDS   2 STRUCTURAL GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   3 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN              
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   28-NOV-04 1WGS    0                                                
JRNL        AUTH   H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA           
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN FROM MOUSE            
JRNL        TITL 2 HYPOTHETICAL PROTEIN HOMOLOGOUS TO HISTONE                   
JRNL        TITL 3 ACETYLTRANSFERASE                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WGS A    8   127  UNP    Q9D1P2   MYST1_MOUSE     50    169             
SEQRES   1 A  133  GLY SER SER GLY SER SER GLY GLU PRO GLU VAL THR VAL          
SEQRES   2 A  133  GLU ILE GLY GLU THR TYR LEU CYS ARG ARG PRO ASP SER          
SEQRES   3 A  133  THR TRP HIS SER ALA GLU VAL ILE GLN SER ARG VAL ASN          
SEQRES   4 A  133  ASP GLN GLU GLY ARG GLU GLU PHE TYR VAL HIS TYR VAL          
SEQRES   5 A  133  GLY PHE ASN ARG ARG LEU ASP GLU TRP VAL ASP LYS ASN          
SEQRES   6 A  133  ARG LEU ALA LEU THR LYS THR VAL LYS ASP ALA VAL GLN          
SEQRES   7 A  133  LYS ASN SER GLU LYS TYR LEU SER GLU LEU ALA GLU GLN          
SEQRES   8 A  133  PRO GLU ARG LYS ILE THR ARG ASN GLN LYS ARG LYS HIS          
SEQRES   9 A  133  ASP GLU ILE ASN HIS VAL GLN LYS THR TYR ALA GLU MET          
SEQRES  10 A  133  ASP PRO THR THR ALA ALA LEU GLU LYS GLU SER GLY PRO          
SEQRES  11 A  133  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      11.233  83.906  14.137  1.00  0.00           N  
ATOM      2  CA  GLY A   1      10.874  84.217  12.764  1.00  0.00           C  
ATOM      3  C   GLY A   1      11.904  83.651  11.785  1.00  0.00           C  
ATOM      4  O   GLY A   1      12.117  82.441  11.734  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       9.889  83.806  12.540  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      10.802  85.297  12.639  1.00  0.00           H  
ATOM      7  H1  GLY A   1      12.119  83.455  14.250  1.00  0.00           H  
ATOM      8  N   SER A   2      12.516  84.553  11.033  1.00  0.00           N  
ATOM      9  CA  SER A   2      13.520  84.159  10.059  1.00  0.00           C  
ATOM     10  C   SER A   2      12.903  83.212   9.026  1.00  0.00           C  
ATOM     11  O   SER A   2      12.676  82.038   9.314  1.00  0.00           O  
ATOM     12  CB  SER A   2      14.718  83.494  10.740  1.00  0.00           C  
ATOM     13  OG  SER A   2      15.700  84.446  11.139  1.00  0.00           O  
ATOM     14  H   SER A   2      12.338  85.535  11.081  1.00  0.00           H  
ATOM     15  HA  SER A   2      13.841  85.086   9.584  1.00  0.00           H  
ATOM     16  HB2 SER A   2      14.376  82.938  11.612  1.00  0.00           H  
ATOM     17  HB3 SER A   2      15.169  82.773  10.057  1.00  0.00           H  
ATOM     18  HG  SER A   2      16.448  83.985  11.617  1.00  0.00           H  
ATOM     19  N   SER A   3      12.650  83.759   7.846  1.00  0.00           N  
ATOM     20  CA  SER A   3      12.064  82.977   6.770  1.00  0.00           C  
ATOM     21  C   SER A   3      12.800  83.259   5.458  1.00  0.00           C  
ATOM     22  O   SER A   3      13.350  82.347   4.844  1.00  0.00           O  
ATOM     23  CB  SER A   3      10.573  83.281   6.618  1.00  0.00           C  
ATOM     24  OG  SER A   3       9.792  82.093   6.529  1.00  0.00           O  
ATOM     25  H   SER A   3      12.838  84.714   7.621  1.00  0.00           H  
ATOM     26  HA  SER A   3      12.194  81.937   7.066  1.00  0.00           H  
ATOM     27  HB2 SER A   3      10.235  83.875   7.468  1.00  0.00           H  
ATOM     28  HB3 SER A   3      10.415  83.887   5.724  1.00  0.00           H  
ATOM     29  HG  SER A   3      10.239  81.352   7.029  1.00  0.00           H  
ATOM     30  N   GLY A   4      12.786  84.525   5.070  1.00  0.00           N  
ATOM     31  CA  GLY A   4      13.446  84.938   3.842  1.00  0.00           C  
ATOM     32  C   GLY A   4      14.836  85.507   4.132  1.00  0.00           C  
ATOM     33  O   GLY A   4      14.972  86.477   4.878  1.00  0.00           O  
ATOM     34  H   GLY A   4      12.338  85.261   5.576  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      13.531  84.087   3.167  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      12.840  85.689   3.335  1.00  0.00           H  
ATOM     37  N   SER A   5      15.835  84.881   3.526  1.00  0.00           N  
ATOM     38  CA  SER A   5      17.210  85.313   3.710  1.00  0.00           C  
ATOM     39  C   SER A   5      17.539  86.442   2.731  1.00  0.00           C  
ATOM     40  O   SER A   5      17.193  86.367   1.553  1.00  0.00           O  
ATOM     41  CB  SER A   5      18.183  84.148   3.523  1.00  0.00           C  
ATOM     42  OG  SER A   5      18.258  83.322   4.681  1.00  0.00           O  
ATOM     43  H   SER A   5      15.716  84.094   2.921  1.00  0.00           H  
ATOM     44  HA  SER A   5      17.265  85.670   4.739  1.00  0.00           H  
ATOM     45  HB2 SER A   5      17.869  83.547   2.669  1.00  0.00           H  
ATOM     46  HB3 SER A   5      19.174  84.537   3.290  1.00  0.00           H  
ATOM     47  HG  SER A   5      17.524  83.560   5.318  1.00  0.00           H  
ATOM     48  N   SER A   6      18.202  87.462   3.255  1.00  0.00           N  
ATOM     49  CA  SER A   6      18.581  88.605   2.441  1.00  0.00           C  
ATOM     50  C   SER A   6      20.106  88.720   2.379  1.00  0.00           C  
ATOM     51  O   SER A   6      20.704  89.504   3.116  1.00  0.00           O  
ATOM     52  CB  SER A   6      17.974  89.898   2.991  1.00  0.00           C  
ATOM     53  OG  SER A   6      16.631  90.085   2.552  1.00  0.00           O  
ATOM     54  H   SER A   6      18.480  87.515   4.214  1.00  0.00           H  
ATOM     55  HA  SER A   6      18.172  88.404   1.453  1.00  0.00           H  
ATOM     56  HB2 SER A   6      17.999  89.876   4.080  1.00  0.00           H  
ATOM     57  HB3 SER A   6      18.580  90.746   2.675  1.00  0.00           H  
ATOM     58  HG  SER A   6      16.466  91.053   2.360  1.00  0.00           H  
ATOM     59  N   GLY A   7      20.691  87.929   1.493  1.00  0.00           N  
ATOM     60  CA  GLY A   7      22.135  87.932   1.325  1.00  0.00           C  
ATOM     61  C   GLY A   7      22.781  86.789   2.109  1.00  0.00           C  
ATOM     62  O   GLY A   7      22.259  86.366   3.139  1.00  0.00           O  
ATOM     63  H   GLY A   7      20.198  87.296   0.897  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      22.381  87.837   0.267  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      22.541  88.885   1.662  1.00  0.00           H  
ATOM     66  N   GLU A   8      23.907  86.322   1.593  1.00  0.00           N  
ATOM     67  CA  GLU A   8      24.631  85.236   2.233  1.00  0.00           C  
ATOM     68  C   GLU A   8      26.116  85.300   1.870  1.00  0.00           C  
ATOM     69  O   GLU A   8      26.476  85.785   0.799  1.00  0.00           O  
ATOM     70  CB  GLU A   8      24.032  83.880   1.853  1.00  0.00           C  
ATOM     71  CG  GLU A   8      24.133  83.638   0.346  1.00  0.00           C  
ATOM     72  CD  GLU A   8      22.912  82.874  -0.169  1.00  0.00           C  
ATOM     73  OE1 GLU A   8      22.859  81.651   0.086  1.00  0.00           O  
ATOM     74  OE2 GLU A   8      22.060  83.528  -0.807  1.00  0.00           O  
ATOM     75  H   GLU A   8      24.326  86.672   0.755  1.00  0.00           H  
ATOM     76  HA  GLU A   8      24.504  85.395   3.304  1.00  0.00           H  
ATOM     77  HB2 GLU A   8      24.553  83.086   2.388  1.00  0.00           H  
ATOM     78  HB3 GLU A   8      22.987  83.840   2.163  1.00  0.00           H  
ATOM     79  HG2 GLU A   8      24.214  84.593  -0.174  1.00  0.00           H  
ATOM     80  HG3 GLU A   8      25.040  83.076   0.125  1.00  0.00           H  
ATOM     81  N   PRO A   9      26.959  84.790   2.806  1.00  0.00           N  
ATOM     82  CA  PRO A   9      28.397  84.785   2.596  1.00  0.00           C  
ATOM     83  C   PRO A   9      28.800  83.702   1.593  1.00  0.00           C  
ATOM     84  O   PRO A   9      28.057  82.746   1.374  1.00  0.00           O  
ATOM     85  CB  PRO A   9      28.996  84.570   3.976  1.00  0.00           C  
ATOM     86  CG  PRO A   9      27.876  83.999   4.832  1.00  0.00           C  
ATOM     87  CD  PRO A   9      26.568  84.206   4.086  1.00  0.00           C  
ATOM     88  HA  PRO A   9      28.692  85.652   2.195  1.00  0.00           H  
ATOM     89  HB2 PRO A   9      29.842  83.883   3.932  1.00  0.00           H  
ATOM     90  HB3 PRO A   9      29.367  85.506   4.391  1.00  0.00           H  
ATOM     91  HG2 PRO A   9      28.043  82.939   5.022  1.00  0.00           H  
ATOM     92  HG3 PRO A   9      27.846  84.497   5.801  1.00  0.00           H  
ATOM     93  HD2 PRO A   9      26.038  83.264   3.947  1.00  0.00           H  
ATOM     94  HD3 PRO A   9      25.899  84.870   4.636  1.00  0.00           H  
ATOM     95  N   GLU A  10      29.975  83.888   1.011  1.00  0.00           N  
ATOM     96  CA  GLU A  10      30.486  82.939   0.036  1.00  0.00           C  
ATOM     97  C   GLU A  10      31.699  82.197   0.603  1.00  0.00           C  
ATOM     98  O   GLU A  10      32.674  82.822   1.018  1.00  0.00           O  
ATOM     99  CB  GLU A  10      30.836  83.639  -1.279  1.00  0.00           C  
ATOM    100  CG  GLU A  10      32.133  84.439  -1.146  1.00  0.00           C  
ATOM    101  CD  GLU A  10      32.397  85.269  -2.405  1.00  0.00           C  
ATOM    102  OE1 GLU A  10      31.413  85.835  -2.927  1.00  0.00           O  
ATOM    103  OE2 GLU A  10      33.576  85.317  -2.816  1.00  0.00           O  
ATOM    104  H   GLU A  10      30.573  84.668   1.194  1.00  0.00           H  
ATOM    105  HA  GLU A  10      29.672  82.237  -0.139  1.00  0.00           H  
ATOM    106  HB2 GLU A  10      30.942  82.897  -2.072  1.00  0.00           H  
ATOM    107  HB3 GLU A  10      30.023  84.303  -1.570  1.00  0.00           H  
ATOM    108  HG2 GLU A  10      32.070  85.097  -0.279  1.00  0.00           H  
ATOM    109  HG3 GLU A  10      32.968  83.761  -0.971  1.00  0.00           H  
ATOM    110  N   VAL A  11      31.599  80.876   0.601  1.00  0.00           N  
ATOM    111  CA  VAL A  11      32.676  80.044   1.109  1.00  0.00           C  
ATOM    112  C   VAL A  11      33.933  80.275   0.269  1.00  0.00           C  
ATOM    113  O   VAL A  11      33.896  80.999  -0.725  1.00  0.00           O  
ATOM    114  CB  VAL A  11      32.236  78.579   1.136  1.00  0.00           C  
ATOM    115  CG1 VAL A  11      32.278  77.968  -0.267  1.00  0.00           C  
ATOM    116  CG2 VAL A  11      33.089  77.767   2.113  1.00  0.00           C  
ATOM    117  H   VAL A  11      30.803  80.377   0.260  1.00  0.00           H  
ATOM    118  HA  VAL A  11      32.876  80.355   2.134  1.00  0.00           H  
ATOM    119  HB  VAL A  11      31.203  78.545   1.485  1.00  0.00           H  
ATOM    120 HG11 VAL A  11      33.112  77.269  -0.333  1.00  0.00           H  
ATOM    121 HG12 VAL A  11      31.344  77.439  -0.460  1.00  0.00           H  
ATOM    122 HG13 VAL A  11      32.407  78.760  -1.004  1.00  0.00           H  
ATOM    123 HG21 VAL A  11      32.459  77.045   2.632  1.00  0.00           H  
ATOM    124 HG22 VAL A  11      33.870  77.242   1.564  1.00  0.00           H  
ATOM    125 HG23 VAL A  11      33.545  78.438   2.840  1.00  0.00           H  
ATOM    126  N   THR A  12      35.017  79.646   0.700  1.00  0.00           N  
ATOM    127  CA  THR A  12      36.285  79.775   0.001  1.00  0.00           C  
ATOM    128  C   THR A  12      37.226  78.632   0.389  1.00  0.00           C  
ATOM    129  O   THR A  12      37.151  78.113   1.501  1.00  0.00           O  
ATOM    130  CB  THR A  12      36.854  81.162   0.305  1.00  0.00           C  
ATOM    131  OG1 THR A  12      36.370  81.976  -0.760  1.00  0.00           O  
ATOM    132  CG2 THR A  12      38.375  81.215   0.154  1.00  0.00           C  
ATOM    133  H   THR A  12      35.039  79.059   1.510  1.00  0.00           H  
ATOM    134  HA  THR A  12      36.097  79.685  -1.069  1.00  0.00           H  
ATOM    135  HB  THR A  12      36.548  81.500   1.294  1.00  0.00           H  
ATOM    136  HG1 THR A  12      36.633  82.929  -0.608  1.00  0.00           H  
ATOM    137 HG21 THR A  12      38.748  82.158   0.555  1.00  0.00           H  
ATOM    138 HG22 THR A  12      38.824  80.386   0.699  1.00  0.00           H  
ATOM    139 HG23 THR A  12      38.639  81.141  -0.902  1.00  0.00           H  
ATOM    140  N   VAL A  13      38.090  78.276  -0.550  1.00  0.00           N  
ATOM    141  CA  VAL A  13      39.046  77.205  -0.320  1.00  0.00           C  
ATOM    142  C   VAL A  13      40.462  77.781  -0.327  1.00  0.00           C  
ATOM    143  O   VAL A  13      40.747  78.729  -1.057  1.00  0.00           O  
ATOM    144  CB  VAL A  13      38.846  76.096  -1.354  1.00  0.00           C  
ATOM    145  CG1 VAL A  13      40.104  75.234  -1.482  1.00  0.00           C  
ATOM    146  CG2 VAL A  13      37.626  75.238  -1.010  1.00  0.00           C  
ATOM    147  H   VAL A  13      38.145  78.704  -1.452  1.00  0.00           H  
ATOM    148  HA  VAL A  13      38.841  76.789   0.667  1.00  0.00           H  
ATOM    149  HB  VAL A  13      38.662  76.566  -2.320  1.00  0.00           H  
ATOM    150 HG11 VAL A  13      40.608  75.181  -0.518  1.00  0.00           H  
ATOM    151 HG12 VAL A  13      39.825  74.230  -1.803  1.00  0.00           H  
ATOM    152 HG13 VAL A  13      40.774  75.677  -2.219  1.00  0.00           H  
ATOM    153 HG21 VAL A  13      37.917  74.461  -0.302  1.00  0.00           H  
ATOM    154 HG22 VAL A  13      36.855  75.866  -0.563  1.00  0.00           H  
ATOM    155 HG23 VAL A  13      37.240  74.776  -1.918  1.00  0.00           H  
ATOM    156  N   GLU A  14      41.314  77.185   0.494  1.00  0.00           N  
ATOM    157  CA  GLU A  14      42.694  77.626   0.591  1.00  0.00           C  
ATOM    158  C   GLU A  14      43.641  76.518   0.128  1.00  0.00           C  
ATOM    159  O   GLU A  14      43.510  75.369   0.547  1.00  0.00           O  
ATOM    160  CB  GLU A  14      43.028  78.072   2.017  1.00  0.00           C  
ATOM    161  CG  GLU A  14      42.241  79.327   2.399  1.00  0.00           C  
ATOM    162  CD  GLU A  14      43.003  80.159   3.431  1.00  0.00           C  
ATOM    163  OE1 GLU A  14      44.250  80.159   3.353  1.00  0.00           O  
ATOM    164  OE2 GLU A  14      42.320  80.778   4.277  1.00  0.00           O  
ATOM    165  H   GLU A  14      41.074  76.414   1.085  1.00  0.00           H  
ATOM    166  HA  GLU A  14      42.772  78.484  -0.077  1.00  0.00           H  
ATOM    167  HB2 GLU A  14      42.799  77.268   2.716  1.00  0.00           H  
ATOM    168  HB3 GLU A  14      44.097  78.270   2.099  1.00  0.00           H  
ATOM    169  HG2 GLU A  14      42.054  79.928   1.509  1.00  0.00           H  
ATOM    170  HG3 GLU A  14      41.268  79.043   2.800  1.00  0.00           H  
ATOM    171  N   ILE A  15      44.574  76.901  -0.731  1.00  0.00           N  
ATOM    172  CA  ILE A  15      45.543  75.954  -1.257  1.00  0.00           C  
ATOM    173  C   ILE A  15      46.662  75.755  -0.233  1.00  0.00           C  
ATOM    174  O   ILE A  15      46.944  76.648   0.564  1.00  0.00           O  
ATOM    175  CB  ILE A  15      46.039  76.403  -2.633  1.00  0.00           C  
ATOM    176  CG1 ILE A  15      44.871  76.831  -3.525  1.00  0.00           C  
ATOM    177  CG2 ILE A  15      46.892  75.315  -3.289  1.00  0.00           C  
ATOM    178  CD1 ILE A  15      43.933  75.654  -3.802  1.00  0.00           C  
ATOM    179  H   ILE A  15      44.675  77.838  -1.067  1.00  0.00           H  
ATOM    180  HA  ILE A  15      45.027  75.003  -1.395  1.00  0.00           H  
ATOM    181  HB  ILE A  15      46.677  77.275  -2.498  1.00  0.00           H  
ATOM    182 HG12 ILE A  15      44.317  77.636  -3.042  1.00  0.00           H  
ATOM    183 HG13 ILE A  15      45.254  77.226  -4.465  1.00  0.00           H  
ATOM    184 HG21 ILE A  15      47.034  75.551  -4.344  1.00  0.00           H  
ATOM    185 HG22 ILE A  15      47.863  75.267  -2.795  1.00  0.00           H  
ATOM    186 HG23 ILE A  15      46.390  74.353  -3.195  1.00  0.00           H  
ATOM    187 HD11 ILE A  15      43.680  75.634  -4.863  1.00  0.00           H  
ATOM    188 HD12 ILE A  15      44.428  74.722  -3.529  1.00  0.00           H  
ATOM    189 HD13 ILE A  15      43.023  75.768  -3.213  1.00  0.00           H  
ATOM    190  N   GLY A  16      47.270  74.579  -0.290  1.00  0.00           N  
ATOM    191  CA  GLY A  16      48.353  74.252   0.622  1.00  0.00           C  
ATOM    192  C   GLY A  16      47.817  73.605   1.901  1.00  0.00           C  
ATOM    193  O   GLY A  16      48.519  72.833   2.551  1.00  0.00           O  
ATOM    194  H   GLY A  16      47.034  73.859  -0.943  1.00  0.00           H  
ATOM    195  HA2 GLY A  16      49.053  73.574   0.133  1.00  0.00           H  
ATOM    196  HA3 GLY A  16      48.907  75.156   0.872  1.00  0.00           H  
ATOM    197  N   GLU A  17      46.577  73.944   2.221  1.00  0.00           N  
ATOM    198  CA  GLU A  17      45.938  73.406   3.411  1.00  0.00           C  
ATOM    199  C   GLU A  17      45.281  72.061   3.097  1.00  0.00           C  
ATOM    200  O   GLU A  17      45.084  71.718   1.932  1.00  0.00           O  
ATOM    201  CB  GLU A  17      44.918  74.394   3.980  1.00  0.00           C  
ATOM    202  CG  GLU A  17      45.587  75.376   4.945  1.00  0.00           C  
ATOM    203  CD  GLU A  17      45.497  76.810   4.417  1.00  0.00           C  
ATOM    204  OE1 GLU A  17      46.416  77.196   3.664  1.00  0.00           O  
ATOM    205  OE2 GLU A  17      44.511  77.487   4.780  1.00  0.00           O  
ATOM    206  H   GLU A  17      46.013  74.572   1.686  1.00  0.00           H  
ATOM    207  HA  GLU A  17      46.742  73.266   4.134  1.00  0.00           H  
ATOM    208  HB2 GLU A  17      44.446  74.944   3.166  1.00  0.00           H  
ATOM    209  HB3 GLU A  17      44.129  73.850   4.499  1.00  0.00           H  
ATOM    210  HG2 GLU A  17      45.109  75.314   5.922  1.00  0.00           H  
ATOM    211  HG3 GLU A  17      46.632  75.101   5.083  1.00  0.00           H  
ATOM    212  N   THR A  18      44.960  71.334   4.157  1.00  0.00           N  
ATOM    213  CA  THR A  18      44.329  70.033   4.010  1.00  0.00           C  
ATOM    214  C   THR A  18      42.852  70.110   4.401  1.00  0.00           C  
ATOM    215  O   THR A  18      42.495  70.782   5.367  1.00  0.00           O  
ATOM    216  CB  THR A  18      45.125  69.024   4.840  1.00  0.00           C  
ATOM    217  OG1 THR A  18      46.478  69.244   4.451  1.00  0.00           O  
ATOM    218  CG2 THR A  18      44.849  67.578   4.427  1.00  0.00           C  
ATOM    219  H   THR A  18      45.124  71.619   5.101  1.00  0.00           H  
ATOM    220  HA  THR A  18      44.367  69.750   2.958  1.00  0.00           H  
ATOM    221  HB  THR A  18      44.943  69.166   5.905  1.00  0.00           H  
ATOM    222  HG1 THR A  18      47.080  68.602   4.924  1.00  0.00           H  
ATOM    223 HG21 THR A  18      45.729  66.967   4.632  1.00  0.00           H  
ATOM    224 HG22 THR A  18      44.000  67.194   4.992  1.00  0.00           H  
ATOM    225 HG23 THR A  18      44.623  67.541   3.361  1.00  0.00           H  
ATOM    226  N   TYR A  19      42.032  69.411   3.629  1.00  0.00           N  
ATOM    227  CA  TYR A  19      40.601  69.391   3.883  1.00  0.00           C  
ATOM    228  C   TYR A  19      40.056  67.962   3.837  1.00  0.00           C  
ATOM    229  O   TYR A  19      40.699  67.064   3.296  1.00  0.00           O  
ATOM    230  CB  TYR A  19      39.962  70.203   2.755  1.00  0.00           C  
ATOM    231  CG  TYR A  19      40.306  71.694   2.789  1.00  0.00           C  
ATOM    232  CD1 TYR A  19      41.608  72.106   2.593  1.00  0.00           C  
ATOM    233  CD2 TYR A  19      39.314  72.626   3.019  1.00  0.00           C  
ATOM    234  CE1 TYR A  19      41.932  73.509   2.625  1.00  0.00           C  
ATOM    235  CE2 TYR A  19      39.638  74.028   3.052  1.00  0.00           C  
ATOM    236  CZ  TYR A  19      40.930  74.401   2.854  1.00  0.00           C  
ATOM    237  OH  TYR A  19      41.236  75.727   2.884  1.00  0.00           O  
ATOM    238  H   TYR A  19      42.329  68.866   2.846  1.00  0.00           H  
ATOM    239  HA  TYR A  19      40.429  69.806   4.875  1.00  0.00           H  
ATOM    240  HB2 TYR A  19      40.280  69.790   1.798  1.00  0.00           H  
ATOM    241  HB3 TYR A  19      38.879  70.090   2.807  1.00  0.00           H  
ATOM    242  HD1 TYR A  19      42.391  71.370   2.412  1.00  0.00           H  
ATOM    243  HD2 TYR A  19      38.285  72.300   3.174  1.00  0.00           H  
ATOM    244  HE1 TYR A  19      42.956  73.848   2.470  1.00  0.00           H  
ATOM    245  HE2 TYR A  19      38.864  74.775   3.231  1.00  0.00           H  
ATOM    246  HH  TYR A  19      40.559  76.221   3.428  1.00  0.00           H  
ATOM    247  N   LEU A  20      38.875  67.795   4.415  1.00  0.00           N  
ATOM    248  CA  LEU A  20      38.236  66.491   4.447  1.00  0.00           C  
ATOM    249  C   LEU A  20      37.437  66.286   3.159  1.00  0.00           C  
ATOM    250  O   LEU A  20      36.468  67.000   2.905  1.00  0.00           O  
ATOM    251  CB  LEU A  20      37.401  66.334   5.720  1.00  0.00           C  
ATOM    252  CG  LEU A  20      38.134  66.588   7.038  1.00  0.00           C  
ATOM    253  CD1 LEU A  20      39.302  65.615   7.213  1.00  0.00           C  
ATOM    254  CD2 LEU A  20      38.584  68.046   7.145  1.00  0.00           C  
ATOM    255  H   LEU A  20      38.358  68.530   4.854  1.00  0.00           H  
ATOM    256  HA  LEU A  20      39.026  65.740   4.486  1.00  0.00           H  
ATOM    257  HB2 LEU A  20      36.554  67.019   5.661  1.00  0.00           H  
ATOM    258  HB3 LEU A  20      36.994  65.323   5.742  1.00  0.00           H  
ATOM    259  HG  LEU A  20      37.438  66.404   7.858  1.00  0.00           H  
ATOM    260 HD11 LEU A  20      39.225  65.123   8.183  1.00  0.00           H  
ATOM    261 HD12 LEU A  20      39.271  64.865   6.422  1.00  0.00           H  
ATOM    262 HD13 LEU A  20      40.243  66.163   7.156  1.00  0.00           H  
ATOM    263 HD21 LEU A  20      38.734  68.305   8.193  1.00  0.00           H  
ATOM    264 HD22 LEU A  20      39.518  68.180   6.600  1.00  0.00           H  
ATOM    265 HD23 LEU A  20      37.818  68.695   6.717  1.00  0.00           H  
ATOM    266  N   CYS A  21      37.872  65.307   2.379  1.00  0.00           N  
ATOM    267  CA  CYS A  21      37.210  65.000   1.123  1.00  0.00           C  
ATOM    268  C   CYS A  21      36.312  63.780   1.339  1.00  0.00           C  
ATOM    269  O   CYS A  21      36.762  62.759   1.857  1.00  0.00           O  
ATOM    270  CB  CYS A  21      38.216  64.777  -0.008  1.00  0.00           C  
ATOM    271  SG  CYS A  21      37.364  64.847  -1.626  1.00  0.00           S  
ATOM    272  H   CYS A  21      38.660  64.731   2.593  1.00  0.00           H  
ATOM    273  HA  CYS A  21      36.616  65.876   0.861  1.00  0.00           H  
ATOM    274  HB2 CYS A  21      38.997  65.535   0.034  1.00  0.00           H  
ATOM    275  HB3 CYS A  21      38.704  63.810   0.114  1.00  0.00           H  
ATOM    276  HG  CYS A  21      37.704  66.102  -1.907  1.00  0.00           H  
ATOM    277  N   ARG A  22      35.060  63.926   0.931  1.00  0.00           N  
ATOM    278  CA  ARG A  22      34.097  62.848   1.072  1.00  0.00           C  
ATOM    279  C   ARG A  22      34.620  61.576   0.402  1.00  0.00           C  
ATOM    280  O   ARG A  22      35.475  61.642  -0.480  1.00  0.00           O  
ATOM    281  CB  ARG A  22      32.751  63.227   0.451  1.00  0.00           C  
ATOM    282  CG  ARG A  22      31.591  62.772   1.339  1.00  0.00           C  
ATOM    283  CD  ARG A  22      30.540  63.876   1.477  1.00  0.00           C  
ATOM    284  NE  ARG A  22      29.234  63.398   0.972  1.00  0.00           N  
ATOM    285  CZ  ARG A  22      28.057  63.958   1.284  1.00  0.00           C  
ATOM    286  NH1 ARG A  22      28.016  65.018   2.102  1.00  0.00           N  
ATOM    287  NH2 ARG A  22      26.921  63.456   0.779  1.00  0.00           N  
ATOM    288  H   ARG A  22      34.703  64.759   0.510  1.00  0.00           H  
ATOM    289  HA  ARG A  22      33.991  62.708   2.149  1.00  0.00           H  
ATOM    290  HB2 ARG A  22      32.703  64.306   0.309  1.00  0.00           H  
ATOM    291  HB3 ARG A  22      32.660  62.771  -0.534  1.00  0.00           H  
ATOM    292  HG2 ARG A  22      31.131  61.880   0.915  1.00  0.00           H  
ATOM    293  HG3 ARG A  22      31.967  62.498   2.324  1.00  0.00           H  
ATOM    294  HD2 ARG A  22      30.449  64.174   2.520  1.00  0.00           H  
ATOM    295  HD3 ARG A  22      30.854  64.759   0.919  1.00  0.00           H  
ATOM    296  HE  ARG A  22      29.229  62.608   0.359  1.00  0.00           H  
ATOM    297 HH11 ARG A  22      28.863  65.392   2.479  1.00  0.00           H  
ATOM    298 HH12 ARG A  22      27.138  65.435   2.335  1.00  0.00           H  
ATOM    299 HH21 ARG A  22      26.952  62.665   0.169  1.00  0.00           H  
ATOM    300 HH22 ARG A  22      26.043  63.873   1.012  1.00  0.00           H  
ATOM    301  N   ARG A  23      34.085  60.448   0.845  1.00  0.00           N  
ATOM    302  CA  ARG A  23      34.487  59.162   0.299  1.00  0.00           C  
ATOM    303  C   ARG A  23      33.263  58.273   0.081  1.00  0.00           C  
ATOM    304  O   ARG A  23      32.268  58.394   0.793  1.00  0.00           O  
ATOM    305  CB  ARG A  23      35.467  58.450   1.233  1.00  0.00           C  
ATOM    306  CG  ARG A  23      36.731  59.288   1.444  1.00  0.00           C  
ATOM    307  CD  ARG A  23      37.828  58.882   0.458  1.00  0.00           C  
ATOM    308  NE  ARG A  23      37.526  59.425  -0.885  1.00  0.00           N  
ATOM    309  CZ  ARG A  23      38.071  58.968  -2.020  1.00  0.00           C  
ATOM    310  NH1 ARG A  23      38.951  57.957  -1.981  1.00  0.00           N  
ATOM    311  NH2 ARG A  23      37.739  59.521  -3.194  1.00  0.00           N  
ATOM    312  H   ARG A  23      33.389  60.403   1.563  1.00  0.00           H  
ATOM    313  HA  ARG A  23      34.973  59.403  -0.647  1.00  0.00           H  
ATOM    314  HB2 ARG A  23      34.987  58.260   2.193  1.00  0.00           H  
ATOM    315  HB3 ARG A  23      35.736  57.480   0.814  1.00  0.00           H  
ATOM    316  HG2 ARG A  23      36.495  60.344   1.319  1.00  0.00           H  
ATOM    317  HG3 ARG A  23      37.090  59.159   2.466  1.00  0.00           H  
ATOM    318  HD2 ARG A  23      38.793  59.255   0.801  1.00  0.00           H  
ATOM    319  HD3 ARG A  23      37.905  57.797   0.412  1.00  0.00           H  
ATOM    320  HE  ARG A  23      36.874  60.181  -0.950  1.00  0.00           H  
ATOM    321 HH11 ARG A  23      39.199  57.544  -1.105  1.00  0.00           H  
ATOM    322 HH12 ARG A  23      39.358  57.615  -2.829  1.00  0.00           H  
ATOM    323 HH21 ARG A  23      37.083  60.276  -3.224  1.00  0.00           H  
ATOM    324 HH22 ARG A  23      38.146  59.180  -4.041  1.00  0.00           H  
ATOM    325  N   PRO A  24      33.379  57.375  -0.935  1.00  0.00           N  
ATOM    326  CA  PRO A  24      32.293  56.464  -1.257  1.00  0.00           C  
ATOM    327  C   PRO A  24      32.199  55.338  -0.226  1.00  0.00           C  
ATOM    328  O   PRO A  24      32.240  54.161  -0.580  1.00  0.00           O  
ATOM    329  CB  PRO A  24      32.602  55.963  -2.658  1.00  0.00           C  
ATOM    330  CG  PRO A  24      34.079  56.246  -2.885  1.00  0.00           C  
ATOM    331  CD  PRO A  24      34.542  57.204  -1.800  1.00  0.00           C  
ATOM    332  HA  PRO A  24      31.416  56.943  -1.219  1.00  0.00           H  
ATOM    333  HB2 PRO A  24      32.391  54.898  -2.746  1.00  0.00           H  
ATOM    334  HB3 PRO A  24      31.988  56.473  -3.400  1.00  0.00           H  
ATOM    335  HG2 PRO A  24      34.655  55.321  -2.850  1.00  0.00           H  
ATOM    336  HG3 PRO A  24      34.236  56.682  -3.872  1.00  0.00           H  
ATOM    337  HD2 PRO A  24      35.389  56.797  -1.248  1.00  0.00           H  
ATOM    338  HD3 PRO A  24      34.864  58.155  -2.223  1.00  0.00           H  
ATOM    339  N   ASP A  25      32.073  55.739   1.031  1.00  0.00           N  
ATOM    340  CA  ASP A  25      31.972  54.778   2.116  1.00  0.00           C  
ATOM    341  C   ASP A  25      31.397  55.470   3.354  1.00  0.00           C  
ATOM    342  O   ASP A  25      31.688  55.075   4.481  1.00  0.00           O  
ATOM    343  CB  ASP A  25      33.346  54.216   2.484  1.00  0.00           C  
ATOM    344  CG  ASP A  25      33.350  53.230   3.655  1.00  0.00           C  
ATOM    345  OD1 ASP A  25      32.516  52.300   3.616  1.00  0.00           O  
ATOM    346  OD2 ASP A  25      34.187  53.430   4.561  1.00  0.00           O  
ATOM    347  H   ASP A  25      32.040  56.698   1.312  1.00  0.00           H  
ATOM    348  HA  ASP A  25      31.320  53.989   1.740  1.00  0.00           H  
ATOM    349  HB2 ASP A  25      33.764  53.718   1.609  1.00  0.00           H  
ATOM    350  HB3 ASP A  25      34.009  55.046   2.726  1.00  0.00           H  
ATOM    351  N   SER A  26      30.594  56.493   3.100  1.00  0.00           N  
ATOM    352  CA  SER A  26      29.977  57.245   4.180  1.00  0.00           C  
ATOM    353  C   SER A  26      31.044  57.701   5.176  1.00  0.00           C  
ATOM    354  O   SER A  26      30.843  57.619   6.388  1.00  0.00           O  
ATOM    355  CB  SER A  26      28.908  56.411   4.891  1.00  0.00           C  
ATOM    356  OG  SER A  26      27.797  56.134   4.044  1.00  0.00           O  
ATOM    357  H   SER A  26      30.363  56.808   2.180  1.00  0.00           H  
ATOM    358  HA  SER A  26      29.507  58.104   3.702  1.00  0.00           H  
ATOM    359  HB2 SER A  26      29.347  55.473   5.232  1.00  0.00           H  
ATOM    360  HB3 SER A  26      28.564  56.943   5.778  1.00  0.00           H  
ATOM    361  HG  SER A  26      27.627  56.911   3.437  1.00  0.00           H  
ATOM    362  N   THR A  27      32.156  58.171   4.630  1.00  0.00           N  
ATOM    363  CA  THR A  27      33.255  58.641   5.457  1.00  0.00           C  
ATOM    364  C   THR A  27      33.966  59.815   4.782  1.00  0.00           C  
ATOM    365  O   THR A  27      33.615  60.200   3.667  1.00  0.00           O  
ATOM    366  CB  THR A  27      34.177  57.452   5.737  1.00  0.00           C  
ATOM    367  OG1 THR A  27      34.284  56.792   4.479  1.00  0.00           O  
ATOM    368  CG2 THR A  27      33.527  56.410   6.651  1.00  0.00           C  
ATOM    369  H   THR A  27      32.311  58.234   3.645  1.00  0.00           H  
ATOM    370  HA  THR A  27      32.845  59.013   6.395  1.00  0.00           H  
ATOM    371  HB  THR A  27      35.131  57.787   6.145  1.00  0.00           H  
ATOM    372  HG1 THR A  27      33.373  56.588   4.121  1.00  0.00           H  
ATOM    373 HG21 THR A  27      33.348  56.850   7.633  1.00  0.00           H  
ATOM    374 HG22 THR A  27      32.581  56.087   6.218  1.00  0.00           H  
ATOM    375 HG23 THR A  27      34.192  55.553   6.753  1.00  0.00           H  
ATOM    376  N   TRP A  28      34.951  60.352   5.486  1.00  0.00           N  
ATOM    377  CA  TRP A  28      35.715  61.475   4.967  1.00  0.00           C  
ATOM    378  C   TRP A  28      37.201  61.151   5.129  1.00  0.00           C  
ATOM    379  O   TRP A  28      37.597  60.498   6.093  1.00  0.00           O  
ATOM    380  CB  TRP A  28      35.309  62.779   5.659  1.00  0.00           C  
ATOM    381  CG  TRP A  28      33.919  63.284   5.267  1.00  0.00           C  
ATOM    382  CD1 TRP A  28      32.743  62.658   5.410  1.00  0.00           C  
ATOM    383  CD2 TRP A  28      33.607  64.555   4.658  1.00  0.00           C  
ATOM    384  NE1 TRP A  28      31.699  63.429   4.941  1.00  0.00           N  
ATOM    385  CE2 TRP A  28      32.241  64.619   4.469  1.00  0.00           C  
ATOM    386  CE3 TRP A  28      34.449  65.615   4.280  1.00  0.00           C  
ATOM    387  CZ2 TRP A  28      31.597  65.722   3.895  1.00  0.00           C  
ATOM    388  CZ3 TRP A  28      33.791  66.711   3.709  1.00  0.00           C  
ATOM    389  CH2 TRP A  28      32.417  66.790   3.511  1.00  0.00           C  
ATOM    390  H   TRP A  28      35.230  60.034   6.391  1.00  0.00           H  
ATOM    391  HA  TRP A  28      35.470  61.586   3.911  1.00  0.00           H  
ATOM    392  HB2 TRP A  28      35.340  62.630   6.738  1.00  0.00           H  
ATOM    393  HB3 TRP A  28      36.044  63.548   5.422  1.00  0.00           H  
ATOM    394  HD1 TRP A  28      32.625  61.665   5.844  1.00  0.00           H  
ATOM    395  HE1 TRP A  28      30.644  63.155   4.940  1.00  0.00           H  
ATOM    396  HE3 TRP A  28      35.530  65.588   4.419  1.00  0.00           H  
ATOM    397  HZ2 TRP A  28      30.517  65.749   3.756  1.00  0.00           H  
ATOM    398  HZ3 TRP A  28      34.398  67.560   3.398  1.00  0.00           H  
ATOM    399  HH2 TRP A  28      31.980  67.681   3.059  1.00  0.00           H  
ATOM    400  N   HIS A  29      37.984  61.621   4.169  1.00  0.00           N  
ATOM    401  CA  HIS A  29      39.419  61.389   4.192  1.00  0.00           C  
ATOM    402  C   HIS A  29      40.153  62.685   3.845  1.00  0.00           C  
ATOM    403  O   HIS A  29      39.849  63.325   2.839  1.00  0.00           O  
ATOM    404  CB  HIS A  29      39.796  60.227   3.270  1.00  0.00           C  
ATOM    405  CG  HIS A  29      40.349  59.024   3.994  1.00  0.00           C  
ATOM    406  ND1 HIS A  29      41.677  58.918   4.368  1.00  0.00           N  
ATOM    407  CD2 HIS A  29      39.740  57.876   4.410  1.00  0.00           C  
ATOM    408  CE1 HIS A  29      41.848  57.755   4.979  1.00  0.00           C  
ATOM    409  NE2 HIS A  29      40.647  57.111   5.004  1.00  0.00           N  
ATOM    410  H   HIS A  29      37.655  62.150   3.387  1.00  0.00           H  
ATOM    411  HA  HIS A  29      39.673  61.100   5.212  1.00  0.00           H  
ATOM    412  HB2 HIS A  29      38.915  59.926   2.704  1.00  0.00           H  
ATOM    413  HB3 HIS A  29      40.535  60.576   2.549  1.00  0.00           H  
ATOM    414  HD1 HIS A  29      42.387  59.603   4.204  1.00  0.00           H  
ATOM    415  HD2 HIS A  29      38.686  57.630   4.277  1.00  0.00           H  
ATOM    416  HE1 HIS A  29      42.786  57.379   5.391  1.00  0.00           H  
ATOM    417  N   SER A  30      41.108  63.033   4.696  1.00  0.00           N  
ATOM    418  CA  SER A  30      41.888  64.241   4.491  1.00  0.00           C  
ATOM    419  C   SER A  30      42.468  64.256   3.076  1.00  0.00           C  
ATOM    420  O   SER A  30      42.626  63.206   2.454  1.00  0.00           O  
ATOM    421  CB  SER A  30      43.010  64.353   5.526  1.00  0.00           C  
ATOM    422  OG  SER A  30      43.669  63.107   5.735  1.00  0.00           O  
ATOM    423  H   SER A  30      41.348  62.507   5.512  1.00  0.00           H  
ATOM    424  HA  SER A  30      41.187  65.065   4.626  1.00  0.00           H  
ATOM    425  HB2 SER A  30      43.736  65.096   5.194  1.00  0.00           H  
ATOM    426  HB3 SER A  30      42.598  64.709   6.470  1.00  0.00           H  
ATOM    427  HG  SER A  30      43.234  62.611   6.487  1.00  0.00           H  
ATOM    428  N   ALA A  31      42.768  65.458   2.606  1.00  0.00           N  
ATOM    429  CA  ALA A  31      43.328  65.624   1.275  1.00  0.00           C  
ATOM    430  C   ALA A  31      43.891  67.040   1.136  1.00  0.00           C  
ATOM    431  O   ALA A  31      43.165  68.019   1.298  1.00  0.00           O  
ATOM    432  CB  ALA A  31      42.254  65.318   0.229  1.00  0.00           C  
ATOM    433  H   ALA A  31      42.637  66.308   3.118  1.00  0.00           H  
ATOM    434  HA  ALA A  31      44.140  64.906   1.165  1.00  0.00           H  
ATOM    435  HB1 ALA A  31      42.639  65.548  -0.764  1.00  0.00           H  
ATOM    436  HB2 ALA A  31      41.987  64.263   0.280  1.00  0.00           H  
ATOM    437  HB3 ALA A  31      41.371  65.926   0.426  1.00  0.00           H  
ATOM    438  N   GLU A  32      45.180  67.102   0.836  1.00  0.00           N  
ATOM    439  CA  GLU A  32      45.849  68.382   0.673  1.00  0.00           C  
ATOM    440  C   GLU A  32      45.420  69.041  -0.639  1.00  0.00           C  
ATOM    441  O   GLU A  32      45.380  68.390  -1.682  1.00  0.00           O  
ATOM    442  CB  GLU A  32      47.369  68.218   0.734  1.00  0.00           C  
ATOM    443  CG  GLU A  32      47.886  67.449  -0.484  1.00  0.00           C  
ATOM    444  CD  GLU A  32      49.408  67.561  -0.597  1.00  0.00           C  
ATOM    445  OE1 GLU A  32      49.924  68.643  -0.244  1.00  0.00           O  
ATOM    446  OE2 GLU A  32      50.019  66.563  -1.036  1.00  0.00           O  
ATOM    447  H   GLU A  32      45.763  66.301   0.706  1.00  0.00           H  
ATOM    448  HA  GLU A  32      45.521  68.989   1.517  1.00  0.00           H  
ATOM    449  HB2 GLU A  32      47.843  69.198   0.778  1.00  0.00           H  
ATOM    450  HB3 GLU A  32      47.645  67.689   1.645  1.00  0.00           H  
ATOM    451  HG2 GLU A  32      47.600  66.400  -0.405  1.00  0.00           H  
ATOM    452  HG3 GLU A  32      47.420  67.840  -1.390  1.00  0.00           H  
ATOM    453  N   VAL A  33      45.110  70.326  -0.545  1.00  0.00           N  
ATOM    454  CA  VAL A  33      44.686  71.081  -1.711  1.00  0.00           C  
ATOM    455  C   VAL A  33      45.917  71.507  -2.513  1.00  0.00           C  
ATOM    456  O   VAL A  33      46.662  72.391  -2.093  1.00  0.00           O  
ATOM    457  CB  VAL A  33      43.814  72.263  -1.281  1.00  0.00           C  
ATOM    458  CG1 VAL A  33      43.182  72.948  -2.495  1.00  0.00           C  
ATOM    459  CG2 VAL A  33      42.745  71.821  -0.282  1.00  0.00           C  
ATOM    460  H   VAL A  33      45.146  70.849   0.307  1.00  0.00           H  
ATOM    461  HA  VAL A  33      44.077  70.419  -2.328  1.00  0.00           H  
ATOM    462  HB  VAL A  33      44.457  72.990  -0.785  1.00  0.00           H  
ATOM    463 HG11 VAL A  33      43.836  72.831  -3.360  1.00  0.00           H  
ATOM    464 HG12 VAL A  33      42.215  72.491  -2.707  1.00  0.00           H  
ATOM    465 HG13 VAL A  33      43.044  74.007  -2.284  1.00  0.00           H  
ATOM    466 HG21 VAL A  33      42.977  72.227   0.703  1.00  0.00           H  
ATOM    467 HG22 VAL A  33      41.770  72.186  -0.607  1.00  0.00           H  
ATOM    468 HG23 VAL A  33      42.725  70.732  -0.229  1.00  0.00           H  
ATOM    469  N   ILE A  34      46.094  70.857  -3.655  1.00  0.00           N  
ATOM    470  CA  ILE A  34      47.222  71.157  -4.519  1.00  0.00           C  
ATOM    471  C   ILE A  34      47.032  72.544  -5.137  1.00  0.00           C  
ATOM    472  O   ILE A  34      47.859  73.432  -4.943  1.00  0.00           O  
ATOM    473  CB  ILE A  34      47.416  70.045  -5.553  1.00  0.00           C  
ATOM    474  CG1 ILE A  34      47.451  68.672  -4.881  1.00  0.00           C  
ATOM    475  CG2 ILE A  34      48.661  70.299  -6.405  1.00  0.00           C  
ATOM    476  CD1 ILE A  34      48.887  68.263  -4.545  1.00  0.00           C  
ATOM    477  H   ILE A  34      45.484  70.139  -3.990  1.00  0.00           H  
ATOM    478  HA  ILE A  34      48.117  71.176  -3.896  1.00  0.00           H  
ATOM    479  HB  ILE A  34      46.559  70.052  -6.226  1.00  0.00           H  
ATOM    480 HG12 ILE A  34      46.853  68.694  -3.970  1.00  0.00           H  
ATOM    481 HG13 ILE A  34      47.002  67.928  -5.539  1.00  0.00           H  
ATOM    482 HG21 ILE A  34      49.545  70.293  -5.766  1.00  0.00           H  
ATOM    483 HG22 ILE A  34      48.752  69.516  -7.158  1.00  0.00           H  
ATOM    484 HG23 ILE A  34      48.575  71.268  -6.896  1.00  0.00           H  
ATOM    485 HD11 ILE A  34      49.403  67.964  -5.458  1.00  0.00           H  
ATOM    486 HD12 ILE A  34      49.409  69.106  -4.093  1.00  0.00           H  
ATOM    487 HD13 ILE A  34      48.872  67.427  -3.845  1.00  0.00           H  
ATOM    488  N   GLN A  35      45.936  72.686  -5.868  1.00  0.00           N  
ATOM    489  CA  GLN A  35      45.626  73.949  -6.515  1.00  0.00           C  
ATOM    490  C   GLN A  35      44.112  74.111  -6.664  1.00  0.00           C  
ATOM    491  O   GLN A  35      43.343  73.315  -6.130  1.00  0.00           O  
ATOM    492  CB  GLN A  35      46.326  74.058  -7.871  1.00  0.00           C  
ATOM    493  CG  GLN A  35      47.622  74.862  -7.757  1.00  0.00           C  
ATOM    494  CD  GLN A  35      47.335  76.365  -7.750  1.00  0.00           C  
ATOM    495  OE1 GLN A  35      46.473  76.862  -8.456  1.00  0.00           O  
ATOM    496  NE2 GLN A  35      48.104  77.060  -6.915  1.00  0.00           N  
ATOM    497  H   GLN A  35      45.268  71.957  -6.020  1.00  0.00           H  
ATOM    498  HA  GLN A  35      46.017  74.719  -5.849  1.00  0.00           H  
ATOM    499  HB2 GLN A  35      46.546  73.060  -8.251  1.00  0.00           H  
ATOM    500  HB3 GLN A  35      45.660  74.533  -8.591  1.00  0.00           H  
ATOM    501  HG2 GLN A  35      48.147  74.585  -6.843  1.00  0.00           H  
ATOM    502  HG3 GLN A  35      48.281  74.618  -8.590  1.00  0.00           H  
ATOM    503 HE21 GLN A  35      48.794  76.590  -6.364  1.00  0.00           H  
ATOM    504 HE22 GLN A  35      47.992  78.050  -6.840  1.00  0.00           H  
ATOM    505  N   SER A  36      43.730  75.149  -7.395  1.00  0.00           N  
ATOM    506  CA  SER A  36      42.321  75.426  -7.622  1.00  0.00           C  
ATOM    507  C   SER A  36      42.091  75.794  -9.090  1.00  0.00           C  
ATOM    508  O   SER A  36      42.934  76.436  -9.712  1.00  0.00           O  
ATOM    509  CB  SER A  36      41.827  76.550  -6.709  1.00  0.00           C  
ATOM    510  OG  SER A  36      42.695  77.679  -6.735  1.00  0.00           O  
ATOM    511  H   SER A  36      44.362  75.793  -7.827  1.00  0.00           H  
ATOM    512  HA  SER A  36      41.801  74.501  -7.373  1.00  0.00           H  
ATOM    513  HB2 SER A  36      40.826  76.854  -7.018  1.00  0.00           H  
ATOM    514  HB3 SER A  36      41.745  76.178  -5.688  1.00  0.00           H  
ATOM    515  HG  SER A  36      43.637  77.392  -6.564  1.00  0.00           H  
ATOM    516  N   ARG A  37      40.943  75.370  -9.599  1.00  0.00           N  
ATOM    517  CA  ARG A  37      40.590  75.646 -10.981  1.00  0.00           C  
ATOM    518  C   ARG A  37      39.073  75.777 -11.126  1.00  0.00           C  
ATOM    519  O   ARG A  37      38.320  75.209 -10.337  1.00  0.00           O  
ATOM    520  CB  ARG A  37      41.092  74.539 -11.910  1.00  0.00           C  
ATOM    521  CG  ARG A  37      40.313  73.241 -11.686  1.00  0.00           C  
ATOM    522  CD  ARG A  37      40.644  72.209 -12.766  1.00  0.00           C  
ATOM    523  NE  ARG A  37      39.398  71.595 -13.277  1.00  0.00           N  
ATOM    524  CZ  ARG A  37      39.351  70.738 -14.307  1.00  0.00           C  
ATOM    525  NH1 ARG A  37      40.480  70.391 -14.941  1.00  0.00           N  
ATOM    526  NH2 ARG A  37      38.177  70.230 -14.702  1.00  0.00           N  
ATOM    527  H   ARG A  37      40.262  74.848  -9.086  1.00  0.00           H  
ATOM    528  HA  ARG A  37      41.088  76.588 -11.213  1.00  0.00           H  
ATOM    529  HB2 ARG A  37      40.988  74.855 -12.948  1.00  0.00           H  
ATOM    530  HB3 ARG A  37      42.153  74.365 -11.735  1.00  0.00           H  
ATOM    531  HG2 ARG A  37      40.552  72.835 -10.703  1.00  0.00           H  
ATOM    532  HG3 ARG A  37      39.242  73.450 -11.692  1.00  0.00           H  
ATOM    533  HD2 ARG A  37      41.185  72.687 -13.582  1.00  0.00           H  
ATOM    534  HD3 ARG A  37      41.298  71.440 -12.357  1.00  0.00           H  
ATOM    535  HE  ARG A  37      38.539  71.833 -12.826  1.00  0.00           H  
ATOM    536 HH11 ARG A  37      41.357  70.770 -14.646  1.00  0.00           H  
ATOM    537 HH12 ARG A  37      40.444  69.751 -15.710  1.00  0.00           H  
ATOM    538 HH21 ARG A  37      37.335  70.489 -14.229  1.00  0.00           H  
ATOM    539 HH22 ARG A  37      38.141  69.591 -15.471  1.00  0.00           H  
ATOM    540  N   VAL A  38      38.669  76.527 -12.140  1.00  0.00           N  
ATOM    541  CA  VAL A  38      37.255  76.739 -12.399  1.00  0.00           C  
ATOM    542  C   VAL A  38      36.928  76.289 -13.824  1.00  0.00           C  
ATOM    543  O   VAL A  38      37.738  76.463 -14.734  1.00  0.00           O  
ATOM    544  CB  VAL A  38      36.888  78.201 -12.134  1.00  0.00           C  
ATOM    545  CG1 VAL A  38      35.655  78.611 -12.942  1.00  0.00           C  
ATOM    546  CG2 VAL A  38      36.672  78.449 -10.640  1.00  0.00           C  
ATOM    547  H   VAL A  38      39.289  76.986 -12.778  1.00  0.00           H  
ATOM    548  HA  VAL A  38      36.697  76.119 -11.698  1.00  0.00           H  
ATOM    549  HB  VAL A  38      37.723  78.820 -12.460  1.00  0.00           H  
ATOM    550 HG11 VAL A  38      35.189  79.479 -12.476  1.00  0.00           H  
ATOM    551 HG12 VAL A  38      35.954  78.861 -13.960  1.00  0.00           H  
ATOM    552 HG13 VAL A  38      34.944  77.784 -12.964  1.00  0.00           H  
ATOM    553 HG21 VAL A  38      36.169  79.406 -10.500  1.00  0.00           H  
ATOM    554 HG22 VAL A  38      36.058  77.651 -10.223  1.00  0.00           H  
ATOM    555 HG23 VAL A  38      37.636  78.469 -10.132  1.00  0.00           H  
ATOM    556  N   ASN A  39      35.742  75.719 -13.974  1.00  0.00           N  
ATOM    557  CA  ASN A  39      35.299  75.242 -15.273  1.00  0.00           C  
ATOM    558  C   ASN A  39      34.377  76.286 -15.906  1.00  0.00           C  
ATOM    559  O   ASN A  39      33.411  76.726 -15.283  1.00  0.00           O  
ATOM    560  CB  ASN A  39      34.515  73.936 -15.142  1.00  0.00           C  
ATOM    561  CG  ASN A  39      35.458  72.731 -15.114  1.00  0.00           C  
ATOM    562  OD1 ASN A  39      36.667  72.858 -15.009  1.00  0.00           O  
ATOM    563  ND2 ASN A  39      34.841  71.557 -15.212  1.00  0.00           N  
ATOM    564  H   ASN A  39      35.091  75.581 -13.228  1.00  0.00           H  
ATOM    565  HA  ASN A  39      36.212  75.089 -15.848  1.00  0.00           H  
ATOM    566  HB2 ASN A  39      33.917  73.955 -14.231  1.00  0.00           H  
ATOM    567  HB3 ASN A  39      33.822  73.838 -15.977  1.00  0.00           H  
ATOM    568 HD21 ASN A  39      33.844  71.522 -15.294  1.00  0.00           H  
ATOM    569 HD22 ASN A  39      35.372  70.710 -15.201  1.00  0.00           H  
ATOM    570  N   ASP A  40      34.705  76.652 -17.136  1.00  0.00           N  
ATOM    571  CA  ASP A  40      33.918  77.635 -17.861  1.00  0.00           C  
ATOM    572  C   ASP A  40      32.824  76.920 -18.656  1.00  0.00           C  
ATOM    573  O   ASP A  40      31.666  77.336 -18.640  1.00  0.00           O  
ATOM    574  CB  ASP A  40      34.787  78.417 -18.848  1.00  0.00           C  
ATOM    575  CG  ASP A  40      34.668  79.940 -18.748  1.00  0.00           C  
ATOM    576  OD1 ASP A  40      33.548  80.403 -18.445  1.00  0.00           O  
ATOM    577  OD2 ASP A  40      35.700  80.605 -18.978  1.00  0.00           O  
ATOM    578  H   ASP A  40      35.492  76.288 -17.636  1.00  0.00           H  
ATOM    579  HA  ASP A  40      33.512  78.297 -17.096  1.00  0.00           H  
ATOM    580  HB2 ASP A  40      35.829  78.138 -18.692  1.00  0.00           H  
ATOM    581  HB3 ASP A  40      34.524  78.113 -19.860  1.00  0.00           H  
ATOM    582  N   GLN A  41      33.230  75.857 -19.335  1.00  0.00           N  
ATOM    583  CA  GLN A  41      32.299  75.081 -20.136  1.00  0.00           C  
ATOM    584  C   GLN A  41      31.181  74.518 -19.255  1.00  0.00           C  
ATOM    585  O   GLN A  41      30.007  74.589 -19.614  1.00  0.00           O  
ATOM    586  CB  GLN A  41      33.022  73.960 -20.887  1.00  0.00           C  
ATOM    587  CG  GLN A  41      33.928  74.529 -21.981  1.00  0.00           C  
ATOM    588  CD  GLN A  41      33.102  75.176 -23.095  1.00  0.00           C  
ATOM    589  OE1 GLN A  41      31.883  75.207 -23.061  1.00  0.00           O  
ATOM    590  NE2 GLN A  41      33.832  75.690 -24.080  1.00  0.00           N  
ATOM    591  H   GLN A  41      34.173  75.526 -19.344  1.00  0.00           H  
ATOM    592  HA  GLN A  41      31.882  75.783 -20.859  1.00  0.00           H  
ATOM    593  HB2 GLN A  41      33.617  73.373 -20.186  1.00  0.00           H  
ATOM    594  HB3 GLN A  41      32.292  73.284 -21.329  1.00  0.00           H  
ATOM    595  HG2 GLN A  41      34.605  75.267 -21.550  1.00  0.00           H  
ATOM    596  HG3 GLN A  41      34.546  73.734 -22.396  1.00  0.00           H  
ATOM    597 HE21 GLN A  41      34.830  75.633 -24.046  1.00  0.00           H  
ATOM    598 HE22 GLN A  41      33.384  76.136 -24.855  1.00  0.00           H  
ATOM    599  N   GLU A  42      31.587  73.970 -18.119  1.00  0.00           N  
ATOM    600  CA  GLU A  42      30.635  73.395 -17.184  1.00  0.00           C  
ATOM    601  C   GLU A  42      30.066  74.483 -16.270  1.00  0.00           C  
ATOM    602  O   GLU A  42      28.866  74.506 -16.000  1.00  0.00           O  
ATOM    603  CB  GLU A  42      31.279  72.274 -16.365  1.00  0.00           C  
ATOM    604  CG  GLU A  42      31.192  70.938 -17.105  1.00  0.00           C  
ATOM    605  CD  GLU A  42      29.782  70.350 -17.011  1.00  0.00           C  
ATOM    606  OE1 GLU A  42      29.388  69.996 -15.879  1.00  0.00           O  
ATOM    607  OE2 GLU A  42      29.130  70.268 -18.074  1.00  0.00           O  
ATOM    608  H   GLU A  42      32.544  73.916 -17.834  1.00  0.00           H  
ATOM    609  HA  GLU A  42      29.840  72.977 -17.800  1.00  0.00           H  
ATOM    610  HB2 GLU A  42      32.323  72.517 -16.167  1.00  0.00           H  
ATOM    611  HB3 GLU A  42      30.782  72.193 -15.399  1.00  0.00           H  
ATOM    612  HG2 GLU A  42      31.463  71.077 -18.150  1.00  0.00           H  
ATOM    613  HG3 GLU A  42      31.910  70.236 -16.680  1.00  0.00           H  
ATOM    614  N   GLY A  43      30.953  75.358 -15.820  1.00  0.00           N  
ATOM    615  CA  GLY A  43      30.554  76.445 -14.943  1.00  0.00           C  
ATOM    616  C   GLY A  43      30.536  75.992 -13.482  1.00  0.00           C  
ATOM    617  O   GLY A  43      29.547  76.189 -12.778  1.00  0.00           O  
ATOM    618  H   GLY A  43      31.928  75.332 -16.045  1.00  0.00           H  
ATOM    619  HA2 GLY A  43      31.243  77.282 -15.059  1.00  0.00           H  
ATOM    620  HA3 GLY A  43      29.565  76.803 -15.228  1.00  0.00           H  
ATOM    621  N   ARG A  44      31.643  75.392 -13.068  1.00  0.00           N  
ATOM    622  CA  ARG A  44      31.768  74.909 -11.703  1.00  0.00           C  
ATOM    623  C   ARG A  44      33.208  75.067 -11.213  1.00  0.00           C  
ATOM    624  O   ARG A  44      34.089  75.459 -11.978  1.00  0.00           O  
ATOM    625  CB  ARG A  44      31.359  73.439 -11.599  1.00  0.00           C  
ATOM    626  CG  ARG A  44      29.970  73.212 -12.200  1.00  0.00           C  
ATOM    627  CD  ARG A  44      29.353  71.911 -11.680  1.00  0.00           C  
ATOM    628  NE  ARG A  44      29.836  70.766 -12.483  1.00  0.00           N  
ATOM    629  CZ  ARG A  44      29.854  69.499 -12.049  1.00  0.00           C  
ATOM    630  NH1 ARG A  44      29.417  69.207 -10.817  1.00  0.00           N  
ATOM    631  NH2 ARG A  44      30.310  68.523 -12.847  1.00  0.00           N  
ATOM    632  H   ARG A  44      32.444  75.235 -13.645  1.00  0.00           H  
ATOM    633  HA  ARG A  44      31.085  75.533 -11.124  1.00  0.00           H  
ATOM    634  HB2 ARG A  44      32.089  72.818 -12.117  1.00  0.00           H  
ATOM    635  HB3 ARG A  44      31.362  73.129 -10.554  1.00  0.00           H  
ATOM    636  HG2 ARG A  44      29.321  74.052 -11.951  1.00  0.00           H  
ATOM    637  HG3 ARG A  44      30.043  73.175 -13.288  1.00  0.00           H  
ATOM    638  HD2 ARG A  44      29.616  71.768 -10.632  1.00  0.00           H  
ATOM    639  HD3 ARG A  44      28.267  71.970 -11.732  1.00  0.00           H  
ATOM    640  HE  ARG A  44      30.170  70.949 -13.408  1.00  0.00           H  
ATOM    641 HH11 ARG A  44      29.077  69.935 -10.222  1.00  0.00           H  
ATOM    642 HH12 ARG A  44      29.431  68.260 -10.493  1.00  0.00           H  
ATOM    643 HH21 ARG A  44      30.636  68.741 -13.767  1.00  0.00           H  
ATOM    644 HH22 ARG A  44      30.323  67.577 -12.523  1.00  0.00           H  
ATOM    645  N   GLU A  45      33.405  74.754  -9.941  1.00  0.00           N  
ATOM    646  CA  GLU A  45      34.724  74.856  -9.340  1.00  0.00           C  
ATOM    647  C   GLU A  45      35.293  73.461  -9.070  1.00  0.00           C  
ATOM    648  O   GLU A  45      34.542  72.514  -8.843  1.00  0.00           O  
ATOM    649  CB  GLU A  45      34.679  75.689  -8.057  1.00  0.00           C  
ATOM    650  CG  GLU A  45      34.091  77.075  -8.323  1.00  0.00           C  
ATOM    651  CD  GLU A  45      33.120  77.482  -7.213  1.00  0.00           C  
ATOM    652  OE1 GLU A  45      32.326  76.607  -6.805  1.00  0.00           O  
ATOM    653  OE2 GLU A  45      33.194  78.659  -6.798  1.00  0.00           O  
ATOM    654  H   GLU A  45      32.683  74.437  -9.326  1.00  0.00           H  
ATOM    655  HA  GLU A  45      35.340  75.370 -10.078  1.00  0.00           H  
ATOM    656  HB2 GLU A  45      34.079  75.173  -7.306  1.00  0.00           H  
ATOM    657  HB3 GLU A  45      35.685  75.787  -7.648  1.00  0.00           H  
ATOM    658  HG2 GLU A  45      34.896  77.807  -8.394  1.00  0.00           H  
ATOM    659  HG3 GLU A  45      33.574  77.077  -9.283  1.00  0.00           H  
ATOM    660  N   GLU A  46      36.616  73.381  -9.102  1.00  0.00           N  
ATOM    661  CA  GLU A  46      37.294  72.118  -8.864  1.00  0.00           C  
ATOM    662  C   GLU A  46      38.650  72.362  -8.199  1.00  0.00           C  
ATOM    663  O   GLU A  46      39.415  73.220  -8.638  1.00  0.00           O  
ATOM    664  CB  GLU A  46      37.454  71.328 -10.164  1.00  0.00           C  
ATOM    665  CG  GLU A  46      36.435  70.190 -10.244  1.00  0.00           C  
ATOM    666  CD  GLU A  46      35.331  70.513 -11.251  1.00  0.00           C  
ATOM    667  OE1 GLU A  46      34.640  71.532 -11.031  1.00  0.00           O  
ATOM    668  OE2 GLU A  46      35.201  69.734 -12.220  1.00  0.00           O  
ATOM    669  H   GLU A  46      37.218  74.156  -9.288  1.00  0.00           H  
ATOM    670  HA  GLU A  46      36.645  71.564  -8.187  1.00  0.00           H  
ATOM    671  HB2 GLU A  46      37.328  71.994 -11.017  1.00  0.00           H  
ATOM    672  HB3 GLU A  46      38.465  70.921 -10.224  1.00  0.00           H  
ATOM    673  HG2 GLU A  46      36.938  69.267 -10.533  1.00  0.00           H  
ATOM    674  HG3 GLU A  46      35.997  70.020  -9.261  1.00  0.00           H  
ATOM    675  N   PHE A  47      38.906  71.593  -7.152  1.00  0.00           N  
ATOM    676  CA  PHE A  47      40.157  71.714  -6.422  1.00  0.00           C  
ATOM    677  C   PHE A  47      40.922  70.390  -6.421  1.00  0.00           C  
ATOM    678  O   PHE A  47      40.397  69.365  -5.987  1.00  0.00           O  
ATOM    679  CB  PHE A  47      39.799  72.084  -4.980  1.00  0.00           C  
ATOM    680  CG  PHE A  47      39.210  73.487  -4.826  1.00  0.00           C  
ATOM    681  CD1 PHE A  47      40.036  74.557  -4.667  1.00  0.00           C  
ATOM    682  CD2 PHE A  47      37.863  73.665  -4.847  1.00  0.00           C  
ATOM    683  CE1 PHE A  47      39.489  75.860  -4.524  1.00  0.00           C  
ATOM    684  CE2 PHE A  47      37.316  74.968  -4.704  1.00  0.00           C  
ATOM    685  CZ  PHE A  47      38.140  76.037  -4.545  1.00  0.00           C  
ATOM    686  H   PHE A  47      38.278  70.897  -6.801  1.00  0.00           H  
ATOM    687  HA  PHE A  47      40.752  72.475  -6.925  1.00  0.00           H  
ATOM    688  HB2 PHE A  47      39.085  71.356  -4.596  1.00  0.00           H  
ATOM    689  HB3 PHE A  47      40.695  72.007  -4.363  1.00  0.00           H  
ATOM    690  HD1 PHE A  47      41.115  74.415  -4.651  1.00  0.00           H  
ATOM    691  HD2 PHE A  47      37.201  72.808  -4.974  1.00  0.00           H  
ATOM    692  HE1 PHE A  47      40.149  76.717  -4.397  1.00  0.00           H  
ATOM    693  HE2 PHE A  47      36.235  75.110  -4.720  1.00  0.00           H  
ATOM    694  HZ  PHE A  47      37.720  77.038  -4.435  1.00  0.00           H  
ATOM    695  N   TYR A  48      42.151  70.453  -6.911  1.00  0.00           N  
ATOM    696  CA  TYR A  48      42.994  69.271  -6.973  1.00  0.00           C  
ATOM    697  C   TYR A  48      43.520  68.900  -5.585  1.00  0.00           C  
ATOM    698  O   TYR A  48      44.547  69.416  -5.148  1.00  0.00           O  
ATOM    699  CB  TYR A  48      44.177  69.642  -7.871  1.00  0.00           C  
ATOM    700  CG  TYR A  48      44.899  68.438  -8.477  1.00  0.00           C  
ATOM    701  CD1 TYR A  48      44.172  67.413  -9.050  1.00  0.00           C  
ATOM    702  CD2 TYR A  48      46.277  68.376  -8.453  1.00  0.00           C  
ATOM    703  CE1 TYR A  48      44.853  66.280  -9.622  1.00  0.00           C  
ATOM    704  CE2 TYR A  48      46.958  67.242  -9.024  1.00  0.00           C  
ATOM    705  CZ  TYR A  48      46.212  66.250  -9.580  1.00  0.00           C  
ATOM    706  OH  TYR A  48      46.854  65.180 -10.120  1.00  0.00           O  
ATOM    707  H   TYR A  48      42.571  71.289  -7.262  1.00  0.00           H  
ATOM    708  HA  TYR A  48      42.392  68.447  -7.358  1.00  0.00           H  
ATOM    709  HB2 TYR A  48      43.819  70.283  -8.677  1.00  0.00           H  
ATOM    710  HB3 TYR A  48      44.890  70.226  -7.291  1.00  0.00           H  
ATOM    711  HD1 TYR A  48      43.084  67.463  -9.071  1.00  0.00           H  
ATOM    712  HD2 TYR A  48      46.851  69.184  -8.000  1.00  0.00           H  
ATOM    713  HE1 TYR A  48      44.291  65.464 -10.077  1.00  0.00           H  
ATOM    714  HE2 TYR A  48      48.046  67.181  -9.011  1.00  0.00           H  
ATOM    715  HH  TYR A  48      47.825  65.206  -9.880  1.00  0.00           H  
ATOM    716  N   VAL A  49      42.792  68.007  -4.931  1.00  0.00           N  
ATOM    717  CA  VAL A  49      43.172  67.560  -3.601  1.00  0.00           C  
ATOM    718  C   VAL A  49      43.950  66.248  -3.712  1.00  0.00           C  
ATOM    719  O   VAL A  49      43.683  65.436  -4.597  1.00  0.00           O  
ATOM    720  CB  VAL A  49      41.931  67.447  -2.713  1.00  0.00           C  
ATOM    721  CG1 VAL A  49      41.093  68.725  -2.775  1.00  0.00           C  
ATOM    722  CG2 VAL A  49      41.095  66.223  -3.092  1.00  0.00           C  
ATOM    723  H   VAL A  49      41.958  67.591  -5.294  1.00  0.00           H  
ATOM    724  HA  VAL A  49      43.825  68.321  -3.173  1.00  0.00           H  
ATOM    725  HB  VAL A  49      42.267  67.316  -1.684  1.00  0.00           H  
ATOM    726 HG11 VAL A  49      40.863  69.059  -1.764  1.00  0.00           H  
ATOM    727 HG12 VAL A  49      41.654  69.502  -3.296  1.00  0.00           H  
ATOM    728 HG13 VAL A  49      40.166  68.525  -3.312  1.00  0.00           H  
ATOM    729 HG21 VAL A  49      41.238  66.000  -4.150  1.00  0.00           H  
ATOM    730 HG22 VAL A  49      41.411  65.368  -2.494  1.00  0.00           H  
ATOM    731 HG23 VAL A  49      40.042  66.430  -2.902  1.00  0.00           H  
ATOM    732  N   HIS A  50      44.896  66.079  -2.800  1.00  0.00           N  
ATOM    733  CA  HIS A  50      45.715  64.879  -2.784  1.00  0.00           C  
ATOM    734  C   HIS A  50      45.457  64.098  -1.494  1.00  0.00           C  
ATOM    735  O   HIS A  50      45.642  64.626  -0.398  1.00  0.00           O  
ATOM    736  CB  HIS A  50      47.192  65.226  -2.982  1.00  0.00           C  
ATOM    737  CG  HIS A  50      48.128  64.055  -2.796  1.00  0.00           C  
ATOM    738  ND1 HIS A  50      48.661  63.346  -3.858  1.00  0.00           N  
ATOM    739  CD2 HIS A  50      48.621  63.479  -1.662  1.00  0.00           C  
ATOM    740  CE1 HIS A  50      49.437  62.387  -3.373  1.00  0.00           C  
ATOM    741  NE2 HIS A  50      49.411  62.472  -2.013  1.00  0.00           N  
ATOM    742  H   HIS A  50      45.107  66.744  -2.084  1.00  0.00           H  
ATOM    743  HA  HIS A  50      45.399  64.274  -3.634  1.00  0.00           H  
ATOM    744  HB2 HIS A  50      47.329  65.631  -3.984  1.00  0.00           H  
ATOM    745  HB3 HIS A  50      47.467  66.012  -2.280  1.00  0.00           H  
ATOM    746  HD1 HIS A  50      48.490  63.526  -4.827  1.00  0.00           H  
ATOM    747  HD2 HIS A  50      48.403  63.794  -0.642  1.00  0.00           H  
ATOM    748  HE1 HIS A  50      49.999  61.660  -3.960  1.00  0.00           H  
ATOM    749  N   TYR A  51      45.034  62.855  -1.666  1.00  0.00           N  
ATOM    750  CA  TYR A  51      44.749  61.997  -0.529  1.00  0.00           C  
ATOM    751  C   TYR A  51      46.041  61.484   0.108  1.00  0.00           C  
ATOM    752  O   TYR A  51      46.658  60.548  -0.398  1.00  0.00           O  
ATOM    753  CB  TYR A  51      43.961  60.809  -1.085  1.00  0.00           C  
ATOM    754  CG  TYR A  51      42.520  61.144  -1.472  1.00  0.00           C  
ATOM    755  CD1 TYR A  51      41.570  61.346  -0.491  1.00  0.00           C  
ATOM    756  CD2 TYR A  51      42.169  61.245  -2.803  1.00  0.00           C  
ATOM    757  CE1 TYR A  51      40.213  61.661  -0.856  1.00  0.00           C  
ATOM    758  CE2 TYR A  51      40.812  61.560  -3.168  1.00  0.00           C  
ATOM    759  CZ  TYR A  51      39.901  61.753  -2.177  1.00  0.00           C  
ATOM    760  OH  TYR A  51      38.620  62.051  -2.521  1.00  0.00           O  
ATOM    761  H   TYR A  51      44.886  62.434  -2.561  1.00  0.00           H  
ATOM    762  HA  TYR A  51      44.198  62.585   0.206  1.00  0.00           H  
ATOM    763  HB2 TYR A  51      44.481  60.419  -1.960  1.00  0.00           H  
ATOM    764  HB3 TYR A  51      43.950  60.013  -0.340  1.00  0.00           H  
ATOM    765  HD1 TYR A  51      41.847  61.266   0.560  1.00  0.00           H  
ATOM    766  HD2 TYR A  51      42.918  61.086  -3.578  1.00  0.00           H  
ATOM    767  HE1 TYR A  51      39.453  61.823  -0.091  1.00  0.00           H  
ATOM    768  HE2 TYR A  51      40.522  61.643  -4.215  1.00  0.00           H  
ATOM    769  HH  TYR A  51      38.509  61.986  -3.513  1.00  0.00           H  
ATOM    770  N   VAL A  52      46.412  62.119   1.211  1.00  0.00           N  
ATOM    771  CA  VAL A  52      47.620  61.739   1.923  1.00  0.00           C  
ATOM    772  C   VAL A  52      47.342  60.485   2.756  1.00  0.00           C  
ATOM    773  O   VAL A  52      47.415  60.523   3.983  1.00  0.00           O  
ATOM    774  CB  VAL A  52      48.126  62.914   2.762  1.00  0.00           C  
ATOM    775  CG1 VAL A  52      48.353  64.151   1.891  1.00  0.00           C  
ATOM    776  CG2 VAL A  52      47.164  63.221   3.911  1.00  0.00           C  
ATOM    777  H   VAL A  52      45.904  62.879   1.617  1.00  0.00           H  
ATOM    778  HA  VAL A  52      48.381  61.502   1.178  1.00  0.00           H  
ATOM    779  HB  VAL A  52      49.085  62.628   3.195  1.00  0.00           H  
ATOM    780 HG11 VAL A  52      48.603  65.001   2.525  1.00  0.00           H  
ATOM    781 HG12 VAL A  52      49.173  63.961   1.197  1.00  0.00           H  
ATOM    782 HG13 VAL A  52      47.446  64.371   1.328  1.00  0.00           H  
ATOM    783 HG21 VAL A  52      47.678  63.082   4.862  1.00  0.00           H  
ATOM    784 HG22 VAL A  52      46.819  64.253   3.830  1.00  0.00           H  
ATOM    785 HG23 VAL A  52      46.308  62.548   3.859  1.00  0.00           H  
ATOM    786  N   GLY A  53      47.030  59.405   2.056  1.00  0.00           N  
ATOM    787  CA  GLY A  53      46.741  58.143   2.715  1.00  0.00           C  
ATOM    788  C   GLY A  53      45.776  57.297   1.882  1.00  0.00           C  
ATOM    789  O   GLY A  53      44.664  57.006   2.317  1.00  0.00           O  
ATOM    790  H   GLY A  53      46.973  59.383   1.058  1.00  0.00           H  
ATOM    791  HA2 GLY A  53      47.668  57.592   2.877  1.00  0.00           H  
ATOM    792  HA3 GLY A  53      46.307  58.333   3.698  1.00  0.00           H  
ATOM    793  N   PHE A  54      46.239  56.924   0.697  1.00  0.00           N  
ATOM    794  CA  PHE A  54      45.432  56.116  -0.202  1.00  0.00           C  
ATOM    795  C   PHE A  54      46.286  55.530  -1.327  1.00  0.00           C  
ATOM    796  O   PHE A  54      46.584  54.336  -1.327  1.00  0.00           O  
ATOM    797  CB  PHE A  54      44.376  57.042  -0.808  1.00  0.00           C  
ATOM    798  CG  PHE A  54      42.947  56.733  -0.360  1.00  0.00           C  
ATOM    799  CD1 PHE A  54      42.197  55.834  -1.052  1.00  0.00           C  
ATOM    800  CD2 PHE A  54      42.425  57.358   0.729  1.00  0.00           C  
ATOM    801  CE1 PHE A  54      40.870  55.546  -0.636  1.00  0.00           C  
ATOM    802  CE2 PHE A  54      41.098  57.072   1.145  1.00  0.00           C  
ATOM    803  CZ  PHE A  54      40.348  56.171   0.453  1.00  0.00           C  
ATOM    804  H   PHE A  54      47.146  57.164   0.350  1.00  0.00           H  
ATOM    805  HA  PHE A  54      45.005  55.306   0.388  1.00  0.00           H  
ATOM    806  HB2 PHE A  54      44.614  58.073  -0.542  1.00  0.00           H  
ATOM    807  HB3 PHE A  54      44.428  56.974  -1.894  1.00  0.00           H  
ATOM    808  HD1 PHE A  54      42.614  55.333  -1.925  1.00  0.00           H  
ATOM    809  HD2 PHE A  54      43.025  58.079   1.283  1.00  0.00           H  
ATOM    810  HE1 PHE A  54      40.269  54.826  -1.190  1.00  0.00           H  
ATOM    811  HE2 PHE A  54      40.679  57.572   2.018  1.00  0.00           H  
ATOM    812  HZ  PHE A  54      39.329  55.951   0.773  1.00  0.00           H  
ATOM    813  N   ASN A  55      46.655  56.396  -2.260  1.00  0.00           N  
ATOM    814  CA  ASN A  55      47.468  55.978  -3.389  1.00  0.00           C  
ATOM    815  C   ASN A  55      48.092  57.211  -4.047  1.00  0.00           C  
ATOM    816  O   ASN A  55      47.619  58.329  -3.849  1.00  0.00           O  
ATOM    817  CB  ASN A  55      46.622  55.258  -4.441  1.00  0.00           C  
ATOM    818  CG  ASN A  55      47.211  53.885  -4.772  1.00  0.00           C  
ATOM    819  OD1 ASN A  55      48.047  53.351  -4.062  1.00  0.00           O  
ATOM    820  ND2 ASN A  55      46.729  53.345  -5.889  1.00  0.00           N  
ATOM    821  H   ASN A  55      46.408  57.365  -2.252  1.00  0.00           H  
ATOM    822  HA  ASN A  55      48.216  55.306  -2.970  1.00  0.00           H  
ATOM    823  HB2 ASN A  55      45.602  55.142  -4.075  1.00  0.00           H  
ATOM    824  HB3 ASN A  55      46.569  55.863  -5.346  1.00  0.00           H  
ATOM    825 HD21 ASN A  55      46.045  53.836  -6.426  1.00  0.00           H  
ATOM    826 HD22 ASN A  55      47.053  52.448  -6.190  1.00  0.00           H  
ATOM    827  N   ARG A  56      49.143  56.965  -4.814  1.00  0.00           N  
ATOM    828  CA  ARG A  56      49.835  58.041  -5.503  1.00  0.00           C  
ATOM    829  C   ARG A  56      49.272  58.218  -6.914  1.00  0.00           C  
ATOM    830  O   ARG A  56      49.479  59.255  -7.543  1.00  0.00           O  
ATOM    831  CB  ARG A  56      51.337  57.761  -5.592  1.00  0.00           C  
ATOM    832  CG  ARG A  56      52.071  58.311  -4.366  1.00  0.00           C  
ATOM    833  CD  ARG A  56      52.526  59.752  -4.601  1.00  0.00           C  
ATOM    834  NE  ARG A  56      53.991  59.857  -4.414  1.00  0.00           N  
ATOM    835  CZ  ARG A  56      54.696  60.977  -4.620  1.00  0.00           C  
ATOM    836  NH1 ARG A  56      54.076  62.095  -5.023  1.00  0.00           N  
ATOM    837  NH2 ARG A  56      56.022  60.979  -4.425  1.00  0.00           N  
ATOM    838  H   ARG A  56      49.521  56.052  -4.970  1.00  0.00           H  
ATOM    839  HA  ARG A  56      49.651  58.926  -4.893  1.00  0.00           H  
ATOM    840  HB2 ARG A  56      51.506  56.687  -5.671  1.00  0.00           H  
ATOM    841  HB3 ARG A  56      51.742  58.215  -6.496  1.00  0.00           H  
ATOM    842  HG2 ARG A  56      51.416  58.270  -3.497  1.00  0.00           H  
ATOM    843  HG3 ARG A  56      52.935  57.685  -4.145  1.00  0.00           H  
ATOM    844  HD2 ARG A  56      52.257  60.068  -5.609  1.00  0.00           H  
ATOM    845  HD3 ARG A  56      52.014  60.421  -3.911  1.00  0.00           H  
ATOM    846  HE  ARG A  56      54.485  59.040  -4.115  1.00  0.00           H  
ATOM    847 HH11 ARG A  56      53.087  62.093  -5.168  1.00  0.00           H  
ATOM    848 HH12 ARG A  56      54.604  62.931  -5.176  1.00  0.00           H  
ATOM    849 HH21 ARG A  56      56.485  60.146  -4.125  1.00  0.00           H  
ATOM    850 HH22 ARG A  56      56.549  61.816  -4.579  1.00  0.00           H  
ATOM    851  N   ARG A  57      48.572  57.191  -7.371  1.00  0.00           N  
ATOM    852  CA  ARG A  57      47.977  57.219  -8.696  1.00  0.00           C  
ATOM    853  C   ARG A  57      46.553  57.775  -8.627  1.00  0.00           C  
ATOM    854  O   ARG A  57      45.694  57.391  -9.419  1.00  0.00           O  
ATOM    855  CB  ARG A  57      47.942  55.821  -9.315  1.00  0.00           C  
ATOM    856  CG  ARG A  57      47.044  54.885  -8.503  1.00  0.00           C  
ATOM    857  CD  ARG A  57      45.807  54.479  -9.305  1.00  0.00           C  
ATOM    858  NE  ARG A  57      45.761  53.008  -9.457  1.00  0.00           N  
ATOM    859  CZ  ARG A  57      46.548  52.314 -10.292  1.00  0.00           C  
ATOM    860  NH1 ARG A  57      47.444  52.953 -11.054  1.00  0.00           N  
ATOM    861  NH2 ARG A  57      46.437  50.980 -10.363  1.00  0.00           N  
ATOM    862  H   ARG A  57      48.408  56.351  -6.853  1.00  0.00           H  
ATOM    863  HA  ARG A  57      48.626  57.874  -9.277  1.00  0.00           H  
ATOM    864  HB2 ARG A  57      47.576  55.881 -10.340  1.00  0.00           H  
ATOM    865  HB3 ARG A  57      48.952  55.414  -9.361  1.00  0.00           H  
ATOM    866  HG2 ARG A  57      47.605  53.994  -8.217  1.00  0.00           H  
ATOM    867  HG3 ARG A  57      46.739  55.378  -7.580  1.00  0.00           H  
ATOM    868  HD2 ARG A  57      44.906  54.828  -8.802  1.00  0.00           H  
ATOM    869  HD3 ARG A  57      45.828  54.953 -10.286  1.00  0.00           H  
ATOM    870  HE  ARG A  57      45.103  52.499  -8.902  1.00  0.00           H  
ATOM    871 HH11 ARG A  57      47.527  53.949 -11.001  1.00  0.00           H  
ATOM    872 HH12 ARG A  57      48.031  52.436 -11.677  1.00  0.00           H  
ATOM    873 HH21 ARG A  57      45.767  50.502  -9.794  1.00  0.00           H  
ATOM    874 HH22 ARG A  57      47.024  50.463 -10.986  1.00  0.00           H  
ATOM    875  N   LEU A  58      46.347  58.671  -7.672  1.00  0.00           N  
ATOM    876  CA  LEU A  58      45.043  59.284  -7.490  1.00  0.00           C  
ATOM    877  C   LEU A  58      45.133  60.774  -7.820  1.00  0.00           C  
ATOM    878  O   LEU A  58      45.215  61.151  -8.989  1.00  0.00           O  
ATOM    879  CB  LEU A  58      44.508  58.996  -6.085  1.00  0.00           C  
ATOM    880  CG  LEU A  58      44.206  57.530  -5.770  1.00  0.00           C  
ATOM    881  CD1 LEU A  58      44.088  57.307  -4.260  1.00  0.00           C  
ATOM    882  CD2 LEU A  58      42.958  57.054  -6.517  1.00  0.00           C  
ATOM    883  H   LEU A  58      47.052  58.978  -7.032  1.00  0.00           H  
ATOM    884  HA  LEU A  58      44.359  58.813  -8.196  1.00  0.00           H  
ATOM    885  HB2 LEU A  58      45.235  59.361  -5.359  1.00  0.00           H  
ATOM    886  HB3 LEU A  58      43.596  59.574  -5.940  1.00  0.00           H  
ATOM    887  HG  LEU A  58      45.042  56.926  -6.119  1.00  0.00           H  
ATOM    888 HD11 LEU A  58      45.080  57.341  -3.810  1.00  0.00           H  
ATOM    889 HD12 LEU A  58      43.464  58.088  -3.825  1.00  0.00           H  
ATOM    890 HD13 LEU A  58      43.636  56.334  -4.071  1.00  0.00           H  
ATOM    891 HD21 LEU A  58      43.184  56.964  -7.580  1.00  0.00           H  
ATOM    892 HD22 LEU A  58      42.649  56.084  -6.128  1.00  0.00           H  
ATOM    893 HD23 LEU A  58      42.153  57.776  -6.377  1.00  0.00           H  
ATOM    894  N   ASP A  59      45.114  61.583  -6.771  1.00  0.00           N  
ATOM    895  CA  ASP A  59      45.194  63.024  -6.935  1.00  0.00           C  
ATOM    896  C   ASP A  59      44.236  63.460  -8.045  1.00  0.00           C  
ATOM    897  O   ASP A  59      44.601  63.463  -9.219  1.00  0.00           O  
ATOM    898  CB  ASP A  59      46.606  63.457  -7.334  1.00  0.00           C  
ATOM    899  CG  ASP A  59      47.601  62.312  -7.533  1.00  0.00           C  
ATOM    900  OD1 ASP A  59      48.073  61.785  -6.502  1.00  0.00           O  
ATOM    901  OD2 ASP A  59      47.867  61.990  -8.710  1.00  0.00           O  
ATOM    902  H   ASP A  59      45.048  61.268  -5.824  1.00  0.00           H  
ATOM    903  HA  ASP A  59      44.923  63.438  -5.964  1.00  0.00           H  
ATOM    904  HB2 ASP A  59      46.546  64.032  -8.258  1.00  0.00           H  
ATOM    905  HB3 ASP A  59      46.995  64.127  -6.567  1.00  0.00           H  
ATOM    906  N   GLU A  60      43.027  63.817  -7.634  1.00  0.00           N  
ATOM    907  CA  GLU A  60      42.013  64.254  -8.580  1.00  0.00           C  
ATOM    908  C   GLU A  60      41.299  65.501  -8.055  1.00  0.00           C  
ATOM    909  O   GLU A  60      41.372  65.807  -6.865  1.00  0.00           O  
ATOM    910  CB  GLU A  60      41.015  63.131  -8.869  1.00  0.00           C  
ATOM    911  CG  GLU A  60      40.211  62.775  -7.616  1.00  0.00           C  
ATOM    912  CD  GLU A  60      39.756  61.315  -7.654  1.00  0.00           C  
ATOM    913  OE1 GLU A  60      40.515  60.498  -8.219  1.00  0.00           O  
ATOM    914  OE2 GLU A  60      38.660  61.048  -7.116  1.00  0.00           O  
ATOM    915  H   GLU A  60      42.738  63.811  -6.677  1.00  0.00           H  
ATOM    916  HA  GLU A  60      42.555  64.494  -9.495  1.00  0.00           H  
ATOM    917  HB2 GLU A  60      40.336  63.439  -9.665  1.00  0.00           H  
ATOM    918  HB3 GLU A  60      41.546  62.249  -9.227  1.00  0.00           H  
ATOM    919  HG2 GLU A  60      40.820  62.948  -6.729  1.00  0.00           H  
ATOM    920  HG3 GLU A  60      39.342  63.429  -7.540  1.00  0.00           H  
ATOM    921  N   TRP A  61      40.626  66.186  -8.966  1.00  0.00           N  
ATOM    922  CA  TRP A  61      39.900  67.393  -8.610  1.00  0.00           C  
ATOM    923  C   TRP A  61      38.640  66.979  -7.847  1.00  0.00           C  
ATOM    924  O   TRP A  61      38.108  65.892  -8.064  1.00  0.00           O  
ATOM    925  CB  TRP A  61      39.598  68.237  -9.849  1.00  0.00           C  
ATOM    926  CG  TRP A  61      40.806  68.460 -10.761  1.00  0.00           C  
ATOM    927  CD1 TRP A  61      41.302  67.631 -11.690  1.00  0.00           C  
ATOM    928  CD2 TRP A  61      41.657  69.625 -10.793  1.00  0.00           C  
ATOM    929  NE1 TRP A  61      42.406  68.175 -12.317  1.00  0.00           N  
ATOM    930  CE2 TRP A  61      42.627  69.426 -11.753  1.00  0.00           C  
ATOM    931  CE3 TRP A  61      41.607  70.809 -10.036  1.00  0.00           C  
ATOM    932  CZ2 TRP A  61      43.622  70.368 -12.046  1.00  0.00           C  
ATOM    933  CZ3 TRP A  61      42.607  71.740 -10.340  1.00  0.00           C  
ATOM    934  CH2 TRP A  61      43.592  71.555 -11.304  1.00  0.00           C  
ATOM    935  H   TRP A  61      40.572  65.929  -9.931  1.00  0.00           H  
ATOM    936  HA  TRP A  61      40.544  67.993  -7.968  1.00  0.00           H  
ATOM    937  HB2 TRP A  61      38.807  67.753 -10.423  1.00  0.00           H  
ATOM    938  HB3 TRP A  61      39.212  69.206  -9.532  1.00  0.00           H  
ATOM    939  HD1 TRP A  61      40.886  66.650 -11.923  1.00  0.00           H  
ATOM    940  HE1 TRP A  61      42.994  67.708 -13.107  1.00  0.00           H  
ATOM    941  HE3 TRP A  61      40.851  70.989  -9.272  1.00  0.00           H  
ATOM    942  HZ2 TRP A  61      44.378  70.187 -12.809  1.00  0.00           H  
ATOM    943  HZ3 TRP A  61      42.614  72.676  -9.781  1.00  0.00           H  
ATOM    944  HH2 TRP A  61      44.337  72.330 -11.481  1.00  0.00           H  
ATOM    945  N   VAL A  62      38.199  67.868  -6.970  1.00  0.00           N  
ATOM    946  CA  VAL A  62      37.012  67.608  -6.173  1.00  0.00           C  
ATOM    947  C   VAL A  62      36.103  68.839  -6.204  1.00  0.00           C  
ATOM    948  O   VAL A  62      36.425  69.836  -6.847  1.00  0.00           O  
ATOM    949  CB  VAL A  62      37.413  67.197  -4.755  1.00  0.00           C  
ATOM    950  CG1 VAL A  62      38.512  66.134  -4.782  1.00  0.00           C  
ATOM    951  CG2 VAL A  62      37.845  68.413  -3.933  1.00  0.00           C  
ATOM    952  H   VAL A  62      38.638  68.750  -6.799  1.00  0.00           H  
ATOM    953  HA  VAL A  62      36.485  66.771  -6.632  1.00  0.00           H  
ATOM    954  HB  VAL A  62      36.538  66.760  -4.273  1.00  0.00           H  
ATOM    955 HG11 VAL A  62      39.482  66.618  -4.907  1.00  0.00           H  
ATOM    956 HG12 VAL A  62      38.502  65.576  -3.846  1.00  0.00           H  
ATOM    957 HG13 VAL A  62      38.338  65.452  -5.614  1.00  0.00           H  
ATOM    958 HG21 VAL A  62      36.984  69.057  -3.756  1.00  0.00           H  
ATOM    959 HG22 VAL A  62      38.251  68.079  -2.978  1.00  0.00           H  
ATOM    960 HG23 VAL A  62      38.609  68.967  -4.478  1.00  0.00           H  
ATOM    961  N   ASP A  63      34.985  68.727  -5.502  1.00  0.00           N  
ATOM    962  CA  ASP A  63      34.028  69.818  -5.441  1.00  0.00           C  
ATOM    963  C   ASP A  63      33.995  70.384  -4.020  1.00  0.00           C  
ATOM    964  O   ASP A  63      34.239  69.662  -3.055  1.00  0.00           O  
ATOM    965  CB  ASP A  63      32.619  69.335  -5.790  1.00  0.00           C  
ATOM    966  CG  ASP A  63      32.375  69.070  -7.277  1.00  0.00           C  
ATOM    967  OD1 ASP A  63      32.562  70.025  -8.061  1.00  0.00           O  
ATOM    968  OD2 ASP A  63      32.007  67.920  -7.597  1.00  0.00           O  
ATOM    969  H   ASP A  63      34.731  67.912  -4.982  1.00  0.00           H  
ATOM    970  HA  ASP A  63      34.377  70.547  -6.172  1.00  0.00           H  
ATOM    971  HB2 ASP A  63      32.418  68.417  -5.236  1.00  0.00           H  
ATOM    972  HB3 ASP A  63      31.900  70.078  -5.446  1.00  0.00           H  
ATOM    973  N   LYS A  64      33.693  71.671  -3.937  1.00  0.00           N  
ATOM    974  CA  LYS A  64      33.625  72.342  -2.650  1.00  0.00           C  
ATOM    975  C   LYS A  64      32.753  71.522  -1.696  1.00  0.00           C  
ATOM    976  O   LYS A  64      33.156  71.236  -0.570  1.00  0.00           O  
ATOM    977  CB  LYS A  64      33.154  73.787  -2.823  1.00  0.00           C  
ATOM    978  CG  LYS A  64      34.218  74.629  -3.530  1.00  0.00           C  
ATOM    979  CD  LYS A  64      34.036  76.117  -3.219  1.00  0.00           C  
ATOM    980  CE  LYS A  64      35.249  76.672  -2.470  1.00  0.00           C  
ATOM    981  NZ  LYS A  64      35.358  78.134  -2.672  1.00  0.00           N  
ATOM    982  H   LYS A  64      33.496  72.252  -4.727  1.00  0.00           H  
ATOM    983  HA  LYS A  64      34.636  72.379  -2.246  1.00  0.00           H  
ATOM    984  HB2 LYS A  64      32.229  73.806  -3.398  1.00  0.00           H  
ATOM    985  HB3 LYS A  64      32.931  74.220  -1.848  1.00  0.00           H  
ATOM    986  HG2 LYS A  64      35.211  74.307  -3.215  1.00  0.00           H  
ATOM    987  HG3 LYS A  64      34.158  74.469  -4.607  1.00  0.00           H  
ATOM    988  HD2 LYS A  64      33.893  76.670  -4.147  1.00  0.00           H  
ATOM    989  HD3 LYS A  64      33.137  76.259  -2.621  1.00  0.00           H  
ATOM    990  HE2 LYS A  64      35.158  76.452  -1.406  1.00  0.00           H  
ATOM    991  HE3 LYS A  64      36.157  76.182  -2.820  1.00  0.00           H  
ATOM    992  HZ1 LYS A  64      35.055  78.366  -3.597  1.00  0.00           H  
ATOM    993  HZ2 LYS A  64      34.783  78.607  -2.004  1.00  0.00           H  
ATOM    994  HZ3 LYS A  64      36.310  78.417  -2.552  1.00  0.00           H  
ATOM    995  N   ASN A  65      31.573  71.166  -2.184  1.00  0.00           N  
ATOM    996  CA  ASN A  65      30.640  70.383  -1.390  1.00  0.00           C  
ATOM    997  C   ASN A  65      31.331  69.103  -0.915  1.00  0.00           C  
ATOM    998  O   ASN A  65      31.250  68.749   0.260  1.00  0.00           O  
ATOM    999  CB  ASN A  65      29.416  69.983  -2.215  1.00  0.00           C  
ATOM   1000  CG  ASN A  65      28.156  70.681  -1.698  1.00  0.00           C  
ATOM   1001  OD1 ASN A  65      27.993  70.932  -0.516  1.00  0.00           O  
ATOM   1002  ND2 ASN A  65      27.275  70.979  -2.649  1.00  0.00           N  
ATOM   1003  H   ASN A  65      31.253  71.402  -3.101  1.00  0.00           H  
ATOM   1004  HA  ASN A  65      30.353  71.033  -0.563  1.00  0.00           H  
ATOM   1005  HB2 ASN A  65      29.576  70.242  -3.260  1.00  0.00           H  
ATOM   1006  HB3 ASN A  65      29.280  68.902  -2.171  1.00  0.00           H  
ATOM   1007 HD21 ASN A  65      27.469  70.744  -3.602  1.00  0.00           H  
ATOM   1008 HD22 ASN A  65      26.418  71.438  -2.412  1.00  0.00           H  
ATOM   1009  N   ARG A  66      31.992  68.444  -1.854  1.00  0.00           N  
ATOM   1010  CA  ARG A  66      32.696  67.209  -1.546  1.00  0.00           C  
ATOM   1011  C   ARG A  66      33.701  67.439  -0.416  1.00  0.00           C  
ATOM   1012  O   ARG A  66      34.066  66.503   0.293  1.00  0.00           O  
ATOM   1013  CB  ARG A  66      33.436  66.677  -2.775  1.00  0.00           C  
ATOM   1014  CG  ARG A  66      32.458  66.066  -3.781  1.00  0.00           C  
ATOM   1015  CD  ARG A  66      33.205  65.411  -4.945  1.00  0.00           C  
ATOM   1016  NE  ARG A  66      32.286  65.204  -6.086  1.00  0.00           N  
ATOM   1017  CZ  ARG A  66      31.376  64.222  -6.148  1.00  0.00           C  
ATOM   1018  NH1 ARG A  66      31.258  63.352  -5.137  1.00  0.00           N  
ATOM   1019  NH2 ARG A  66      30.583  64.112  -7.224  1.00  0.00           N  
ATOM   1020  H   ARG A  66      32.053  68.738  -2.808  1.00  0.00           H  
ATOM   1021  HA  ARG A  66      31.915  66.512  -1.243  1.00  0.00           H  
ATOM   1022  HB2 ARG A  66      33.992  67.485  -3.249  1.00  0.00           H  
ATOM   1023  HB3 ARG A  66      34.163  65.925  -2.469  1.00  0.00           H  
ATOM   1024  HG2 ARG A  66      31.833  65.325  -3.284  1.00  0.00           H  
ATOM   1025  HG3 ARG A  66      31.792  66.841  -4.163  1.00  0.00           H  
ATOM   1026  HD2 ARG A  66      34.041  66.040  -5.251  1.00  0.00           H  
ATOM   1027  HD3 ARG A  66      33.625  64.456  -4.627  1.00  0.00           H  
ATOM   1028  HE  ARG A  66      32.346  65.837  -6.858  1.00  0.00           H  
ATOM   1029 HH11 ARG A  66      31.850  63.435  -4.335  1.00  0.00           H  
ATOM   1030 HH12 ARG A  66      30.579  62.619  -5.184  1.00  0.00           H  
ATOM   1031 HH21 ARG A  66      30.671  64.762  -7.979  1.00  0.00           H  
ATOM   1032 HH22 ARG A  66      29.904  63.379  -7.271  1.00  0.00           H  
ATOM   1033  N   LEU A  67      34.118  68.689  -0.282  1.00  0.00           N  
ATOM   1034  CA  LEU A  67      35.073  69.054   0.751  1.00  0.00           C  
ATOM   1035  C   LEU A  67      34.316  69.484   2.009  1.00  0.00           C  
ATOM   1036  O   LEU A  67      33.090  69.578   2.000  1.00  0.00           O  
ATOM   1037  CB  LEU A  67      36.050  70.109   0.229  1.00  0.00           C  
ATOM   1038  CG  LEU A  67      36.933  69.682  -0.945  1.00  0.00           C  
ATOM   1039  CD1 LEU A  67      37.302  70.883  -1.819  1.00  0.00           C  
ATOM   1040  CD2 LEU A  67      38.171  68.929  -0.454  1.00  0.00           C  
ATOM   1041  H   LEU A  67      33.815  69.445  -0.863  1.00  0.00           H  
ATOM   1042  HA  LEU A  67      35.655  68.162   0.986  1.00  0.00           H  
ATOM   1043  HB2 LEU A  67      35.478  70.987  -0.072  1.00  0.00           H  
ATOM   1044  HB3 LEU A  67      36.696  70.415   1.052  1.00  0.00           H  
ATOM   1045  HG  LEU A  67      36.364  68.994  -1.569  1.00  0.00           H  
ATOM   1046 HD11 LEU A  67      37.028  71.804  -1.304  1.00  0.00           H  
ATOM   1047 HD12 LEU A  67      38.375  70.878  -2.008  1.00  0.00           H  
ATOM   1048 HD13 LEU A  67      36.765  70.822  -2.765  1.00  0.00           H  
ATOM   1049 HD21 LEU A  67      38.087  67.876  -0.723  1.00  0.00           H  
ATOM   1050 HD22 LEU A  67      39.062  69.351  -0.919  1.00  0.00           H  
ATOM   1051 HD23 LEU A  67      38.248  69.022   0.629  1.00  0.00           H  
ATOM   1052  N   ALA A  68      35.080  69.736   3.063  1.00  0.00           N  
ATOM   1053  CA  ALA A  68      34.497  70.154   4.326  1.00  0.00           C  
ATOM   1054  C   ALA A  68      34.781  71.641   4.546  1.00  0.00           C  
ATOM   1055  O   ALA A  68      35.906  72.022   4.864  1.00  0.00           O  
ATOM   1056  CB  ALA A  68      35.049  69.283   5.457  1.00  0.00           C  
ATOM   1057  H   ALA A  68      36.076  69.657   3.063  1.00  0.00           H  
ATOM   1058  HA  ALA A  68      33.419  70.003   4.262  1.00  0.00           H  
ATOM   1059  HB1 ALA A  68      34.920  68.231   5.200  1.00  0.00           H  
ATOM   1060  HB2 ALA A  68      36.109  69.496   5.596  1.00  0.00           H  
ATOM   1061  HB3 ALA A  68      34.510  69.500   6.379  1.00  0.00           H  
ATOM   1062  N   LEU A  69      33.740  72.442   4.367  1.00  0.00           N  
ATOM   1063  CA  LEU A  69      33.863  73.879   4.541  1.00  0.00           C  
ATOM   1064  C   LEU A  69      33.024  74.316   5.744  1.00  0.00           C  
ATOM   1065  O   LEU A  69      31.805  74.445   5.640  1.00  0.00           O  
ATOM   1066  CB  LEU A  69      33.506  74.609   3.244  1.00  0.00           C  
ATOM   1067  CG  LEU A  69      34.251  74.149   1.990  1.00  0.00           C  
ATOM   1068  CD1 LEU A  69      33.454  74.480   0.726  1.00  0.00           C  
ATOM   1069  CD2 LEU A  69      35.663  74.735   1.945  1.00  0.00           C  
ATOM   1070  H   LEU A  69      32.828  72.124   4.108  1.00  0.00           H  
ATOM   1071  HA  LEU A  69      34.910  74.094   4.754  1.00  0.00           H  
ATOM   1072  HB2 LEU A  69      32.436  74.495   3.070  1.00  0.00           H  
ATOM   1073  HB3 LEU A  69      33.695  75.673   3.386  1.00  0.00           H  
ATOM   1074  HG  LEU A  69      34.354  73.065   2.030  1.00  0.00           H  
ATOM   1075 HD11 LEU A  69      32.500  73.953   0.752  1.00  0.00           H  
ATOM   1076 HD12 LEU A  69      33.276  75.554   0.680  1.00  0.00           H  
ATOM   1077 HD13 LEU A  69      34.018  74.166  -0.152  1.00  0.00           H  
ATOM   1078 HD21 LEU A  69      36.215  74.422   2.831  1.00  0.00           H  
ATOM   1079 HD22 LEU A  69      36.177  74.379   1.052  1.00  0.00           H  
ATOM   1080 HD23 LEU A  69      35.605  75.825   1.920  1.00  0.00           H  
ATOM   1081  N   THR A  70      33.709  74.533   6.856  1.00  0.00           N  
ATOM   1082  CA  THR A  70      33.043  74.953   8.077  1.00  0.00           C  
ATOM   1083  C   THR A  70      32.200  73.810   8.644  1.00  0.00           C  
ATOM   1084  O   THR A  70      31.845  72.878   7.924  1.00  0.00           O  
ATOM   1085  CB  THR A  70      32.229  76.210   7.762  1.00  0.00           C  
ATOM   1086  OG1 THR A  70      33.152  77.063   7.092  1.00  0.00           O  
ATOM   1087  CG2 THR A  70      31.847  76.991   9.022  1.00  0.00           C  
ATOM   1088  H   THR A  70      34.701  74.426   6.932  1.00  0.00           H  
ATOM   1089  HA  THR A  70      33.804  75.189   8.820  1.00  0.00           H  
ATOM   1090  HB  THR A  70      31.345  75.964   7.173  1.00  0.00           H  
ATOM   1091  HG1 THR A  70      33.417  76.659   6.215  1.00  0.00           H  
ATOM   1092 HG21 THR A  70      32.751  77.325   9.530  1.00  0.00           H  
ATOM   1093 HG22 THR A  70      31.245  77.856   8.744  1.00  0.00           H  
ATOM   1094 HG23 THR A  70      31.272  76.347   9.688  1.00  0.00           H  
ATOM   1095  N   LYS A  71      31.904  73.918   9.932  1.00  0.00           N  
ATOM   1096  CA  LYS A  71      31.110  72.904  10.604  1.00  0.00           C  
ATOM   1097  C   LYS A  71      29.823  72.661   9.812  1.00  0.00           C  
ATOM   1098  O   LYS A  71      29.225  71.591   9.906  1.00  0.00           O  
ATOM   1099  CB  LYS A  71      30.868  73.295  12.064  1.00  0.00           C  
ATOM   1100  CG  LYS A  71      31.950  72.710  12.974  1.00  0.00           C  
ATOM   1101  CD  LYS A  71      32.816  73.817  13.578  1.00  0.00           C  
ATOM   1102  CE  LYS A  71      34.293  73.414  13.586  1.00  0.00           C  
ATOM   1103  NZ  LYS A  71      35.049  74.194  12.581  1.00  0.00           N  
ATOM   1104  H   LYS A  71      32.197  74.679  10.510  1.00  0.00           H  
ATOM   1105  HA  LYS A  71      31.692  71.982  10.610  1.00  0.00           H  
ATOM   1106  HB2 LYS A  71      30.858  74.381  12.157  1.00  0.00           H  
ATOM   1107  HB3 LYS A  71      29.888  72.939  12.382  1.00  0.00           H  
ATOM   1108  HG2 LYS A  71      31.485  72.132  13.772  1.00  0.00           H  
ATOM   1109  HG3 LYS A  71      32.575  72.022  12.406  1.00  0.00           H  
ATOM   1110  HD2 LYS A  71      32.690  74.736  13.005  1.00  0.00           H  
ATOM   1111  HD3 LYS A  71      32.487  74.028  14.595  1.00  0.00           H  
ATOM   1112  HE2 LYS A  71      34.715  73.579  14.578  1.00  0.00           H  
ATOM   1113  HE3 LYS A  71      34.386  72.349  13.374  1.00  0.00           H  
ATOM   1114  HZ1 LYS A  71      35.957  74.409  12.941  1.00  0.00           H  
ATOM   1115  HZ2 LYS A  71      35.140  73.657  11.743  1.00  0.00           H  
ATOM   1116  HZ3 LYS A  71      34.560  75.044  12.382  1.00  0.00           H  
ATOM   1117  N   THR A  72      29.437  73.672   9.048  1.00  0.00           N  
ATOM   1118  CA  THR A  72      28.233  73.582   8.240  1.00  0.00           C  
ATOM   1119  C   THR A  72      28.099  72.181   7.639  1.00  0.00           C  
ATOM   1120  O   THR A  72      27.047  71.554   7.749  1.00  0.00           O  
ATOM   1121  CB  THR A  72      28.285  74.692   7.188  1.00  0.00           C  
ATOM   1122  OG1 THR A  72      27.761  75.833   7.862  1.00  0.00           O  
ATOM   1123  CG2 THR A  72      27.304  74.456   6.038  1.00  0.00           C  
ATOM   1124  H   THR A  72      29.930  74.540   8.977  1.00  0.00           H  
ATOM   1125  HA  THR A  72      27.371  73.736   8.888  1.00  0.00           H  
ATOM   1126  HB  THR A  72      29.300  74.826   6.813  1.00  0.00           H  
ATOM   1127  HG1 THR A  72      26.880  75.610   8.279  1.00  0.00           H  
ATOM   1128 HG21 THR A  72      27.452  73.455   5.634  1.00  0.00           H  
ATOM   1129 HG22 THR A  72      26.283  74.552   6.406  1.00  0.00           H  
ATOM   1130 HG23 THR A  72      27.479  75.192   5.254  1.00  0.00           H  
ATOM   1131  N   VAL A  73      29.179  71.734   7.015  1.00  0.00           N  
ATOM   1132  CA  VAL A  73      29.194  70.419   6.396  1.00  0.00           C  
ATOM   1133  C   VAL A  73      30.294  69.571   7.039  1.00  0.00           C  
ATOM   1134  O   VAL A  73      31.390  70.064   7.300  1.00  0.00           O  
ATOM   1135  CB  VAL A  73      29.353  70.556   4.880  1.00  0.00           C  
ATOM   1136  CG1 VAL A  73      28.269  71.464   4.296  1.00  0.00           C  
ATOM   1137  CG2 VAL A  73      30.749  71.068   4.520  1.00  0.00           C  
ATOM   1138  H   VAL A  73      30.030  72.251   6.930  1.00  0.00           H  
ATOM   1139  HA  VAL A  73      28.230  69.951   6.593  1.00  0.00           H  
ATOM   1140  HB  VAL A  73      29.235  69.566   4.441  1.00  0.00           H  
ATOM   1141 HG11 VAL A  73      27.409  71.480   4.965  1.00  0.00           H  
ATOM   1142 HG12 VAL A  73      28.662  72.474   4.183  1.00  0.00           H  
ATOM   1143 HG13 VAL A  73      27.963  71.082   3.321  1.00  0.00           H  
ATOM   1144 HG21 VAL A  73      30.912  70.955   3.447  1.00  0.00           H  
ATOM   1145 HG22 VAL A  73      30.832  72.120   4.790  1.00  0.00           H  
ATOM   1146 HG23 VAL A  73      31.499  70.493   5.064  1.00  0.00           H  
ATOM   1147  N   LYS A  74      29.963  68.310   7.274  1.00  0.00           N  
ATOM   1148  CA  LYS A  74      30.908  67.389   7.881  1.00  0.00           C  
ATOM   1149  C   LYS A  74      30.216  66.048   8.134  1.00  0.00           C  
ATOM   1150  O   LYS A  74      29.022  65.902   7.873  1.00  0.00           O  
ATOM   1151  CB  LYS A  74      31.528  68.007   9.135  1.00  0.00           C  
ATOM   1152  CG  LYS A  74      33.019  68.284   8.930  1.00  0.00           C  
ATOM   1153  CD  LYS A  74      33.591  69.096  10.093  1.00  0.00           C  
ATOM   1154  CE  LYS A  74      34.090  68.177  11.211  1.00  0.00           C  
ATOM   1155  NZ  LYS A  74      32.987  67.846  12.140  1.00  0.00           N  
ATOM   1156  H   LYS A  74      29.069  67.917   7.058  1.00  0.00           H  
ATOM   1157  HA  LYS A  74      31.715  67.231   7.166  1.00  0.00           H  
ATOM   1158  HB2 LYS A  74      31.013  68.935   9.381  1.00  0.00           H  
ATOM   1159  HB3 LYS A  74      31.393  67.333   9.982  1.00  0.00           H  
ATOM   1160  HG2 LYS A  74      33.559  67.341   8.839  1.00  0.00           H  
ATOM   1161  HG3 LYS A  74      33.167  68.827   7.996  1.00  0.00           H  
ATOM   1162  HD2 LYS A  74      34.412  69.719   9.738  1.00  0.00           H  
ATOM   1163  HD3 LYS A  74      32.827  69.767  10.483  1.00  0.00           H  
ATOM   1164  HE2 LYS A  74      34.498  67.262  10.782  1.00  0.00           H  
ATOM   1165  HE3 LYS A  74      34.899  68.663  11.756  1.00  0.00           H  
ATOM   1166  HZ1 LYS A  74      32.625  66.941  11.920  1.00  0.00           H  
ATOM   1167  HZ2 LYS A  74      33.330  67.849  13.079  1.00  0.00           H  
ATOM   1168  HZ3 LYS A  74      32.259  68.527  12.050  1.00  0.00           H  
ATOM   1169  N   ASP A  75      30.996  65.102   8.638  1.00  0.00           N  
ATOM   1170  CA  ASP A  75      30.472  63.778   8.930  1.00  0.00           C  
ATOM   1171  C   ASP A  75      29.375  63.889   9.991  1.00  0.00           C  
ATOM   1172  O   ASP A  75      28.284  63.347   9.820  1.00  0.00           O  
ATOM   1173  CB  ASP A  75      31.568  62.861   9.477  1.00  0.00           C  
ATOM   1174  CG  ASP A  75      31.070  61.545  10.077  1.00  0.00           C  
ATOM   1175  OD1 ASP A  75      29.872  61.248   9.877  1.00  0.00           O  
ATOM   1176  OD2 ASP A  75      31.898  60.866  10.721  1.00  0.00           O  
ATOM   1177  H   ASP A  75      31.964  65.229   8.847  1.00  0.00           H  
ATOM   1178  HA  ASP A  75      30.095  63.403   7.977  1.00  0.00           H  
ATOM   1179  HB2 ASP A  75      32.267  62.634   8.672  1.00  0.00           H  
ATOM   1180  HB3 ASP A  75      32.126  63.403  10.240  1.00  0.00           H  
ATOM   1181  N   ALA A  76      29.703  64.597  11.062  1.00  0.00           N  
ATOM   1182  CA  ALA A  76      28.760  64.786  12.151  1.00  0.00           C  
ATOM   1183  C   ALA A  76      29.374  65.719  13.196  1.00  0.00           C  
ATOM   1184  O   ALA A  76      30.484  65.482  13.670  1.00  0.00           O  
ATOM   1185  CB  ALA A  76      28.376  63.426  12.738  1.00  0.00           C  
ATOM   1186  H   ALA A  76      30.592  65.034  11.193  1.00  0.00           H  
ATOM   1187  HA  ALA A  76      27.866  65.254  11.738  1.00  0.00           H  
ATOM   1188  HB1 ALA A  76      27.601  63.561  13.492  1.00  0.00           H  
ATOM   1189  HB2 ALA A  76      28.002  62.780  11.944  1.00  0.00           H  
ATOM   1190  HB3 ALA A  76      29.253  62.968  13.195  1.00  0.00           H  
ATOM   1191  N   VAL A  77      28.624  66.761  13.525  1.00  0.00           N  
ATOM   1192  CA  VAL A  77      29.082  67.732  14.505  1.00  0.00           C  
ATOM   1193  C   VAL A  77      28.581  67.324  15.892  1.00  0.00           C  
ATOM   1194  O   VAL A  77      28.160  68.171  16.678  1.00  0.00           O  
ATOM   1195  CB  VAL A  77      28.635  69.137  14.098  1.00  0.00           C  
ATOM   1196  CG1 VAL A  77      29.219  69.526  12.738  1.00  0.00           C  
ATOM   1197  CG2 VAL A  77      27.109  69.247  14.092  1.00  0.00           C  
ATOM   1198  H   VAL A  77      27.723  66.947  13.135  1.00  0.00           H  
ATOM   1199  HA  VAL A  77      30.171  67.711  14.505  1.00  0.00           H  
ATOM   1200  HB  VAL A  77      29.018  69.839  14.839  1.00  0.00           H  
ATOM   1201 HG11 VAL A  77      30.295  69.672  12.833  1.00  0.00           H  
ATOM   1202 HG12 VAL A  77      29.022  68.731  12.018  1.00  0.00           H  
ATOM   1203 HG13 VAL A  77      28.755  70.450  12.394  1.00  0.00           H  
ATOM   1204 HG21 VAL A  77      26.783  69.836  14.949  1.00  0.00           H  
ATOM   1205 HG22 VAL A  77      26.784  69.734  13.172  1.00  0.00           H  
ATOM   1206 HG23 VAL A  77      26.673  68.250  14.150  1.00  0.00           H  
ATOM   1207  N   GLN A  78      28.644  66.025  16.151  1.00  0.00           N  
ATOM   1208  CA  GLN A  78      28.201  65.495  17.429  1.00  0.00           C  
ATOM   1209  C   GLN A  78      29.224  65.818  18.520  1.00  0.00           C  
ATOM   1210  O   GLN A  78      28.888  66.440  19.526  1.00  0.00           O  
ATOM   1211  CB  GLN A  78      27.952  63.988  17.341  1.00  0.00           C  
ATOM   1212  CG  GLN A  78      26.531  63.640  17.790  1.00  0.00           C  
ATOM   1213  CD  GLN A  78      26.348  62.125  17.904  1.00  0.00           C  
ATOM   1214  OE1 GLN A  78      26.897  61.472  18.775  1.00  0.00           O  
ATOM   1215  NE2 GLN A  78      25.547  61.607  16.978  1.00  0.00           N  
ATOM   1216  H   GLN A  78      28.987  65.343  15.506  1.00  0.00           H  
ATOM   1217  HA  GLN A  78      27.260  66.001  17.642  1.00  0.00           H  
ATOM   1218  HB2 GLN A  78      28.106  63.650  16.316  1.00  0.00           H  
ATOM   1219  HB3 GLN A  78      28.673  63.459  17.963  1.00  0.00           H  
ATOM   1220  HG2 GLN A  78      26.326  64.108  18.752  1.00  0.00           H  
ATOM   1221  HG3 GLN A  78      25.811  64.044  17.079  1.00  0.00           H  
ATOM   1222 HE21 GLN A  78      25.127  62.199  16.290  1.00  0.00           H  
ATOM   1223 HE22 GLN A  78      25.364  60.624  16.969  1.00  0.00           H  
ATOM   1224  N   LYS A  79      30.453  65.381  18.283  1.00  0.00           N  
ATOM   1225  CA  LYS A  79      31.526  65.616  19.233  1.00  0.00           C  
ATOM   1226  C   LYS A  79      32.236  66.925  18.879  1.00  0.00           C  
ATOM   1227  O   LYS A  79      32.068  67.932  19.565  1.00  0.00           O  
ATOM   1228  CB  LYS A  79      32.461  64.407  19.295  1.00  0.00           C  
ATOM   1229  CG  LYS A  79      33.272  64.407  20.593  1.00  0.00           C  
ATOM   1230  CD  LYS A  79      33.834  63.015  20.888  1.00  0.00           C  
ATOM   1231  CE  LYS A  79      33.029  62.321  21.989  1.00  0.00           C  
ATOM   1232  NZ  LYS A  79      32.143  61.287  21.410  1.00  0.00           N  
ATOM   1233  H   LYS A  79      30.717  64.877  17.462  1.00  0.00           H  
ATOM   1234  HA  LYS A  79      31.073  65.725  20.218  1.00  0.00           H  
ATOM   1235  HB2 LYS A  79      31.879  63.489  19.226  1.00  0.00           H  
ATOM   1236  HB3 LYS A  79      33.137  64.420  18.440  1.00  0.00           H  
ATOM   1237  HG2 LYS A  79      34.090  65.123  20.514  1.00  0.00           H  
ATOM   1238  HG3 LYS A  79      32.642  64.732  21.420  1.00  0.00           H  
ATOM   1239  HD2 LYS A  79      33.813  62.410  19.981  1.00  0.00           H  
ATOM   1240  HD3 LYS A  79      34.877  63.097  21.192  1.00  0.00           H  
ATOM   1241  HE2 LYS A  79      33.707  61.866  22.711  1.00  0.00           H  
ATOM   1242  HE3 LYS A  79      32.433  63.057  22.530  1.00  0.00           H  
ATOM   1243  HZ1 LYS A  79      32.005  60.555  22.077  1.00  0.00           H  
ATOM   1244  HZ2 LYS A  79      31.261  61.695  21.175  1.00  0.00           H  
ATOM   1245  HZ3 LYS A  79      32.566  60.910  20.585  1.00  0.00           H  
ATOM   1246  N   ASN A  80      33.018  66.867  17.810  1.00  0.00           N  
ATOM   1247  CA  ASN A  80      33.754  68.034  17.358  1.00  0.00           C  
ATOM   1248  C   ASN A  80      34.775  68.434  18.426  1.00  0.00           C  
ATOM   1249  O   ASN A  80      34.408  68.967  19.472  1.00  0.00           O  
ATOM   1250  CB  ASN A  80      32.818  69.223  17.132  1.00  0.00           C  
ATOM   1251  CG  ASN A  80      33.387  70.177  16.079  1.00  0.00           C  
ATOM   1252  OD1 ASN A  80      33.045  70.127  14.909  1.00  0.00           O  
ATOM   1253  ND2 ASN A  80      34.272  71.047  16.559  1.00  0.00           N  
ATOM   1254  H   ASN A  80      33.151  66.044  17.259  1.00  0.00           H  
ATOM   1255  HA  ASN A  80      34.226  67.731  16.423  1.00  0.00           H  
ATOM   1256  HB2 ASN A  80      31.840  68.864  16.812  1.00  0.00           H  
ATOM   1257  HB3 ASN A  80      32.670  69.758  18.070  1.00  0.00           H  
ATOM   1258 HD21 ASN A  80      34.509  71.034  17.530  1.00  0.00           H  
ATOM   1259 HD22 ASN A  80      34.701  71.712  15.948  1.00  0.00           H  
ATOM   1260  N   SER A  81      36.036  68.160  18.125  1.00  0.00           N  
ATOM   1261  CA  SER A  81      37.112  68.484  19.046  1.00  0.00           C  
ATOM   1262  C   SER A  81      38.275  69.125  18.287  1.00  0.00           C  
ATOM   1263  O   SER A  81      38.977  68.452  17.534  1.00  0.00           O  
ATOM   1264  CB  SER A  81      37.591  67.238  19.794  1.00  0.00           C  
ATOM   1265  OG  SER A  81      38.695  67.519  20.649  1.00  0.00           O  
ATOM   1266  H   SER A  81      36.325  67.726  17.272  1.00  0.00           H  
ATOM   1267  HA  SER A  81      36.682  69.190  19.755  1.00  0.00           H  
ATOM   1268  HB2 SER A  81      36.769  66.832  20.385  1.00  0.00           H  
ATOM   1269  HB3 SER A  81      37.876  66.470  19.075  1.00  0.00           H  
ATOM   1270  HG  SER A  81      39.531  67.613  20.110  1.00  0.00           H  
ATOM   1271  N   GLU A  82      38.443  70.421  18.511  1.00  0.00           N  
ATOM   1272  CA  GLU A  82      39.509  71.161  17.857  1.00  0.00           C  
ATOM   1273  C   GLU A  82      39.860  72.412  18.666  1.00  0.00           C  
ATOM   1274  O   GLU A  82      39.013  72.958  19.370  1.00  0.00           O  
ATOM   1275  CB  GLU A  82      39.123  71.526  16.422  1.00  0.00           C  
ATOM   1276  CG  GLU A  82      40.038  70.830  15.414  1.00  0.00           C  
ATOM   1277  CD  GLU A  82      39.307  70.572  14.095  1.00  0.00           C  
ATOM   1278  OE1 GLU A  82      38.457  71.419  13.743  1.00  0.00           O  
ATOM   1279  OE2 GLU A  82      39.612  69.534  13.470  1.00  0.00           O  
ATOM   1280  H   GLU A  82      37.868  70.961  19.124  1.00  0.00           H  
ATOM   1281  HA  GLU A  82      40.362  70.483  17.835  1.00  0.00           H  
ATOM   1282  HB2 GLU A  82      38.088  71.241  16.237  1.00  0.00           H  
ATOM   1283  HB3 GLU A  82      39.185  72.607  16.290  1.00  0.00           H  
ATOM   1284  HG2 GLU A  82      40.919  71.445  15.230  1.00  0.00           H  
ATOM   1285  HG3 GLU A  82      40.391  69.885  15.829  1.00  0.00           H  
ATOM   1286  N   LYS A  83      41.111  72.829  18.538  1.00  0.00           N  
ATOM   1287  CA  LYS A  83      41.584  74.004  19.247  1.00  0.00           C  
ATOM   1288  C   LYS A  83      41.045  75.261  18.561  1.00  0.00           C  
ATOM   1289  O   LYS A  83      40.218  75.171  17.654  1.00  0.00           O  
ATOM   1290  CB  LYS A  83      43.110  73.977  19.372  1.00  0.00           C  
ATOM   1291  CG  LYS A  83      43.547  73.132  20.570  1.00  0.00           C  
ATOM   1292  CD  LYS A  83      44.965  72.593  20.371  1.00  0.00           C  
ATOM   1293  CE  LYS A  83      45.775  72.690  21.665  1.00  0.00           C  
ATOM   1294  NZ  LYS A  83      47.162  72.225  21.444  1.00  0.00           N  
ATOM   1295  H   LYS A  83      41.795  72.379  17.962  1.00  0.00           H  
ATOM   1296  HA  LYS A  83      41.178  73.961  20.258  1.00  0.00           H  
ATOM   1297  HB2 LYS A  83      43.545  73.573  18.458  1.00  0.00           H  
ATOM   1298  HB3 LYS A  83      43.487  74.994  19.482  1.00  0.00           H  
ATOM   1299  HG2 LYS A  83      43.507  73.735  21.478  1.00  0.00           H  
ATOM   1300  HG3 LYS A  83      42.854  72.303  20.707  1.00  0.00           H  
ATOM   1301  HD2 LYS A  83      44.920  71.555  20.043  1.00  0.00           H  
ATOM   1302  HD3 LYS A  83      45.465  73.154  19.582  1.00  0.00           H  
ATOM   1303  HE2 LYS A  83      45.784  73.721  22.020  1.00  0.00           H  
ATOM   1304  HE3 LYS A  83      45.303  72.091  22.443  1.00  0.00           H  
ATOM   1305  HZ1 LYS A  83      47.485  71.739  22.257  1.00  0.00           H  
ATOM   1306  HZ2 LYS A  83      47.186  71.608  20.657  1.00  0.00           H  
ATOM   1307  HZ3 LYS A  83      47.754  73.012  21.269  1.00  0.00           H  
ATOM   1308  N   TYR A  84      41.535  76.403  19.020  1.00  0.00           N  
ATOM   1309  CA  TYR A  84      41.113  77.677  18.461  1.00  0.00           C  
ATOM   1310  C   TYR A  84      42.294  78.418  17.832  1.00  0.00           C  
ATOM   1311  O   TYR A  84      43.447  78.046  18.041  1.00  0.00           O  
ATOM   1312  CB  TYR A  84      40.580  78.498  19.638  1.00  0.00           C  
ATOM   1313  CG  TYR A  84      39.619  79.615  19.232  1.00  0.00           C  
ATOM   1314  CD1 TYR A  84      40.111  80.799  18.721  1.00  0.00           C  
ATOM   1315  CD2 TYR A  84      38.256  79.440  19.376  1.00  0.00           C  
ATOM   1316  CE1 TYR A  84      39.206  81.851  18.339  1.00  0.00           C  
ATOM   1317  CE2 TYR A  84      37.351  80.493  18.994  1.00  0.00           C  
ATOM   1318  CZ  TYR A  84      37.870  81.646  18.494  1.00  0.00           C  
ATOM   1319  OH  TYR A  84      37.015  82.640  18.133  1.00  0.00           O  
ATOM   1320  H   TYR A  84      42.207  76.468  19.758  1.00  0.00           H  
ATOM   1321  HA  TYR A  84      40.366  77.476  17.693  1.00  0.00           H  
ATOM   1322  HB2 TYR A  84      40.072  77.830  20.333  1.00  0.00           H  
ATOM   1323  HB3 TYR A  84      41.423  78.934  20.174  1.00  0.00           H  
ATOM   1324  HD1 TYR A  84      41.186  80.937  18.607  1.00  0.00           H  
ATOM   1325  HD2 TYR A  84      37.867  78.505  19.780  1.00  0.00           H  
ATOM   1326  HE1 TYR A  84      39.582  82.791  17.934  1.00  0.00           H  
ATOM   1327  HE2 TYR A  84      36.273  80.367  19.103  1.00  0.00           H  
ATOM   1328  HH  TYR A  84      36.814  82.579  17.155  1.00  0.00           H  
ATOM   1329  N   LEU A  85      41.964  79.453  17.072  1.00  0.00           N  
ATOM   1330  CA  LEU A  85      42.983  80.249  16.410  1.00  0.00           C  
ATOM   1331  C   LEU A  85      44.192  80.396  17.336  1.00  0.00           C  
ATOM   1332  O   LEU A  85      44.061  80.868  18.465  1.00  0.00           O  
ATOM   1333  CB  LEU A  85      42.401  81.585  15.944  1.00  0.00           C  
ATOM   1334  CG  LEU A  85      42.585  82.766  16.899  1.00  0.00           C  
ATOM   1335  CD1 LEU A  85      44.058  83.171  16.993  1.00  0.00           C  
ATOM   1336  CD2 LEU A  85      41.693  83.942  16.494  1.00  0.00           C  
ATOM   1337  H   LEU A  85      41.023  79.748  16.908  1.00  0.00           H  
ATOM   1338  HA  LEU A  85      43.295  79.705  15.518  1.00  0.00           H  
ATOM   1339  HB2 LEU A  85      42.853  81.842  14.987  1.00  0.00           H  
ATOM   1340  HB3 LEU A  85      41.334  81.451  15.766  1.00  0.00           H  
ATOM   1341  HG  LEU A  85      42.273  82.453  17.895  1.00  0.00           H  
ATOM   1342 HD11 LEU A  85      44.160  84.229  16.757  1.00  0.00           H  
ATOM   1343 HD12 LEU A  85      44.421  82.986  18.004  1.00  0.00           H  
ATOM   1344 HD13 LEU A  85      44.642  82.582  16.284  1.00  0.00           H  
ATOM   1345 HD21 LEU A  85      41.218  83.726  15.537  1.00  0.00           H  
ATOM   1346 HD22 LEU A  85      40.927  84.095  17.254  1.00  0.00           H  
ATOM   1347 HD23 LEU A  85      42.299  84.843  16.404  1.00  0.00           H  
ATOM   1348  N   SER A  86      45.343  79.981  16.825  1.00  0.00           N  
ATOM   1349  CA  SER A  86      46.574  80.060  17.593  1.00  0.00           C  
ATOM   1350  C   SER A  86      47.496  81.125  16.995  1.00  0.00           C  
ATOM   1351  O   SER A  86      48.368  80.813  16.185  1.00  0.00           O  
ATOM   1352  CB  SER A  86      47.284  78.706  17.634  1.00  0.00           C  
ATOM   1353  OG  SER A  86      47.737  78.381  18.946  1.00  0.00           O  
ATOM   1354  H   SER A  86      45.440  79.598  15.907  1.00  0.00           H  
ATOM   1355  HA  SER A  86      46.269  80.341  18.600  1.00  0.00           H  
ATOM   1356  HB2 SER A  86      46.605  77.929  17.282  1.00  0.00           H  
ATOM   1357  HB3 SER A  86      48.134  78.721  16.951  1.00  0.00           H  
ATOM   1358  HG  SER A  86      48.720  78.199  18.934  1.00  0.00           H  
ATOM   1359  N   GLU A  87      47.272  82.361  17.417  1.00  0.00           N  
ATOM   1360  CA  GLU A  87      48.071  83.474  16.933  1.00  0.00           C  
ATOM   1361  C   GLU A  87      47.951  84.666  17.885  1.00  0.00           C  
ATOM   1362  O   GLU A  87      46.849  85.147  18.146  1.00  0.00           O  
ATOM   1363  CB  GLU A  87      47.664  83.863  15.511  1.00  0.00           C  
ATOM   1364  CG  GLU A  87      48.573  84.966  14.964  1.00  0.00           C  
ATOM   1365  CD  GLU A  87      47.875  86.327  15.015  1.00  0.00           C  
ATOM   1366  OE1 GLU A  87      46.699  86.377  14.596  1.00  0.00           O  
ATOM   1367  OE2 GLU A  87      48.535  87.285  15.472  1.00  0.00           O  
ATOM   1368  H   GLU A  87      46.560  82.606  18.075  1.00  0.00           H  
ATOM   1369  HA  GLU A  87      49.098  83.109  16.924  1.00  0.00           H  
ATOM   1370  HB2 GLU A  87      47.716  82.989  14.861  1.00  0.00           H  
ATOM   1371  HB3 GLU A  87      46.629  84.204  15.505  1.00  0.00           H  
ATOM   1372  HG2 GLU A  87      49.495  85.004  15.544  1.00  0.00           H  
ATOM   1373  HG3 GLU A  87      48.853  84.735  13.936  1.00  0.00           H  
ATOM   1374  N   LEU A  88      49.099  85.108  18.376  1.00  0.00           N  
ATOM   1375  CA  LEU A  88      49.137  86.235  19.292  1.00  0.00           C  
ATOM   1376  C   LEU A  88      50.257  87.190  18.875  1.00  0.00           C  
ATOM   1377  O   LEU A  88      51.354  86.751  18.531  1.00  0.00           O  
ATOM   1378  CB  LEU A  88      49.251  85.748  20.737  1.00  0.00           C  
ATOM   1379  CG  LEU A  88      48.012  85.058  21.312  1.00  0.00           C  
ATOM   1380  CD1 LEU A  88      46.816  86.012  21.338  1.00  0.00           C  
ATOM   1381  CD2 LEU A  88      47.699  83.767  20.552  1.00  0.00           C  
ATOM   1382  H   LEU A  88      49.991  84.711  18.158  1.00  0.00           H  
ATOM   1383  HA  LEU A  88      48.186  86.760  19.203  1.00  0.00           H  
ATOM   1384  HB2 LEU A  88      50.091  85.054  20.801  1.00  0.00           H  
ATOM   1385  HB3 LEU A  88      49.494  86.601  21.370  1.00  0.00           H  
ATOM   1386  HG  LEU A  88      48.224  84.780  22.345  1.00  0.00           H  
ATOM   1387 HD11 LEU A  88      46.395  86.040  22.343  1.00  0.00           H  
ATOM   1388 HD12 LEU A  88      47.142  87.011  21.053  1.00  0.00           H  
ATOM   1389 HD13 LEU A  88      46.058  85.663  20.636  1.00  0.00           H  
ATOM   1390 HD21 LEU A  88      48.545  83.508  19.914  1.00  0.00           H  
ATOM   1391 HD22 LEU A  88      47.522  82.961  21.264  1.00  0.00           H  
ATOM   1392 HD23 LEU A  88      46.811  83.913  19.938  1.00  0.00           H  
ATOM   1393  N   ALA A  89      49.943  88.475  18.917  1.00  0.00           N  
ATOM   1394  CA  ALA A  89      50.911  89.495  18.548  1.00  0.00           C  
ATOM   1395  C   ALA A  89      50.341  90.876  18.881  1.00  0.00           C  
ATOM   1396  O   ALA A  89      49.248  90.984  19.434  1.00  0.00           O  
ATOM   1397  CB  ALA A  89      51.264  89.351  17.066  1.00  0.00           C  
ATOM   1398  H   ALA A  89      49.049  88.823  19.198  1.00  0.00           H  
ATOM   1399  HA  ALA A  89      51.810  89.330  19.142  1.00  0.00           H  
ATOM   1400  HB1 ALA A  89      51.695  88.366  16.890  1.00  0.00           H  
ATOM   1401  HB2 ALA A  89      50.362  89.465  16.465  1.00  0.00           H  
ATOM   1402  HB3 ALA A  89      51.985  90.119  16.789  1.00  0.00           H  
ATOM   1403  N   GLU A  90      51.108  91.897  18.528  1.00  0.00           N  
ATOM   1404  CA  GLU A  90      50.693  93.267  18.781  1.00  0.00           C  
ATOM   1405  C   GLU A  90      49.528  93.647  17.866  1.00  0.00           C  
ATOM   1406  O   GLU A  90      49.734  93.995  16.705  1.00  0.00           O  
ATOM   1407  CB  GLU A  90      51.865  94.235  18.607  1.00  0.00           C  
ATOM   1408  CG  GLU A  90      51.614  95.541  19.364  1.00  0.00           C  
ATOM   1409  CD  GLU A  90      52.823  96.474  19.264  1.00  0.00           C  
ATOM   1410  OE1 GLU A  90      53.900  96.060  19.743  1.00  0.00           O  
ATOM   1411  OE2 GLU A  90      52.643  97.580  18.710  1.00  0.00           O  
ATOM   1412  H   GLU A  90      51.995  91.801  18.078  1.00  0.00           H  
ATOM   1413  HA  GLU A  90      50.368  93.283  19.821  1.00  0.00           H  
ATOM   1414  HB2 GLU A  90      52.782  93.771  18.971  1.00  0.00           H  
ATOM   1415  HB3 GLU A  90      52.014  94.447  17.549  1.00  0.00           H  
ATOM   1416  HG2 GLU A  90      50.733  96.037  18.957  1.00  0.00           H  
ATOM   1417  HG3 GLU A  90      51.403  95.325  20.411  1.00  0.00           H  
ATOM   1418  N   GLN A  91      48.328  93.567  18.424  1.00  0.00           N  
ATOM   1419  CA  GLN A  91      47.130  93.898  17.672  1.00  0.00           C  
ATOM   1420  C   GLN A  91      47.161  95.366  17.243  1.00  0.00           C  
ATOM   1421  O   GLN A  91      47.755  96.202  17.921  1.00  0.00           O  
ATOM   1422  CB  GLN A  91      45.871  93.591  18.485  1.00  0.00           C  
ATOM   1423  CG  GLN A  91      45.698  94.595  19.626  1.00  0.00           C  
ATOM   1424  CD  GLN A  91      45.753  93.896  20.986  1.00  0.00           C  
ATOM   1425  OE1 GLN A  91      46.076  92.724  21.097  1.00  0.00           O  
ATOM   1426  NE2 GLN A  91      45.419  94.675  22.011  1.00  0.00           N  
ATOM   1427  H   GLN A  91      48.170  93.283  19.369  1.00  0.00           H  
ATOM   1428  HA  GLN A  91      47.153  93.255  16.792  1.00  0.00           H  
ATOM   1429  HB2 GLN A  91      44.997  93.620  17.834  1.00  0.00           H  
ATOM   1430  HB3 GLN A  91      45.933  92.581  18.890  1.00  0.00           H  
ATOM   1431  HG2 GLN A  91      46.478  95.353  19.572  1.00  0.00           H  
ATOM   1432  HG3 GLN A  91      44.743  95.112  19.518  1.00  0.00           H  
ATOM   1433 HE21 GLN A  91      45.163  95.628  21.850  1.00  0.00           H  
ATOM   1434 HE22 GLN A  91      45.426  94.308  22.941  1.00  0.00           H  
ATOM   1435  N   PRO A  92      46.497  95.642  16.089  1.00  0.00           N  
ATOM   1436  CA  PRO A  92      46.443  96.995  15.561  1.00  0.00           C  
ATOM   1437  C   PRO A  92      45.472  97.859  16.367  1.00  0.00           C  
ATOM   1438  O   PRO A  92      44.261  97.654  16.313  1.00  0.00           O  
ATOM   1439  CB  PRO A  92      46.029  96.834  14.108  1.00  0.00           C  
ATOM   1440  CG  PRO A  92      45.417  95.446  14.000  1.00  0.00           C  
ATOM   1441  CD  PRO A  92      45.782  94.677  15.258  1.00  0.00           C  
ATOM   1442  HA  PRO A  92      47.337  97.436  15.645  1.00  0.00           H  
ATOM   1443  HB2 PRO A  92      45.310  97.601  13.820  1.00  0.00           H  
ATOM   1444  HB3 PRO A  92      46.887  96.935  13.444  1.00  0.00           H  
ATOM   1445  HG2 PRO A  92      44.334  95.514  13.894  1.00  0.00           H  
ATOM   1446  HG3 PRO A  92      45.793  94.931  13.116  1.00  0.00           H  
ATOM   1447  HD2 PRO A  92      44.893  94.301  15.765  1.00  0.00           H  
ATOM   1448  HD3 PRO A  92      46.406  93.813  15.028  1.00  0.00           H  
ATOM   1449  N   GLU A  93      46.041  98.808  17.097  1.00  0.00           N  
ATOM   1450  CA  GLU A  93      45.240  99.705  17.914  1.00  0.00           C  
ATOM   1451  C   GLU A  93      46.057 100.939  18.303  1.00  0.00           C  
ATOM   1452  O   GLU A  93      46.976 100.848  19.115  1.00  0.00           O  
ATOM   1453  CB  GLU A  93      44.706  98.987  19.154  1.00  0.00           C  
ATOM   1454  CG  GLU A  93      43.596  99.800  19.822  1.00  0.00           C  
ATOM   1455  CD  GLU A  93      44.139 100.595  21.012  1.00  0.00           C  
ATOM   1456  OE1 GLU A  93      44.255  99.985  22.096  1.00  0.00           O  
ATOM   1457  OE2 GLU A  93      44.426 101.795  20.809  1.00  0.00           O  
ATOM   1458  H   GLU A  93      47.027  98.969  17.135  1.00  0.00           H  
ATOM   1459  HA  GLU A  93      44.402 100.000  17.283  1.00  0.00           H  
ATOM   1460  HB2 GLU A  93      44.324  98.005  18.874  1.00  0.00           H  
ATOM   1461  HB3 GLU A  93      45.518  98.823  19.862  1.00  0.00           H  
ATOM   1462  HG2 GLU A  93      43.153 100.482  19.097  1.00  0.00           H  
ATOM   1463  HG3 GLU A  93      42.803  99.132  20.158  1.00  0.00           H  
ATOM   1464  N   ARG A  94      45.692 102.064  17.706  1.00  0.00           N  
ATOM   1465  CA  ARG A  94      46.380 103.314  17.981  1.00  0.00           C  
ATOM   1466  C   ARG A  94      45.445 104.500  17.733  1.00  0.00           C  
ATOM   1467  O   ARG A  94      44.484 104.388  16.972  1.00  0.00           O  
ATOM   1468  CB  ARG A  94      47.624 103.463  17.104  1.00  0.00           C  
ATOM   1469  CG  ARG A  94      47.248 103.513  15.622  1.00  0.00           C  
ATOM   1470  CD  ARG A  94      48.451 103.907  14.763  1.00  0.00           C  
ATOM   1471  NE  ARG A  94      48.521 103.044  13.563  1.00  0.00           N  
ATOM   1472  CZ  ARG A  94      49.537 103.055  12.690  1.00  0.00           C  
ATOM   1473  NH1 ARG A  94      50.574 103.883  12.875  1.00  0.00           N  
ATOM   1474  NH2 ARG A  94      49.517 102.236  11.628  1.00  0.00           N  
ATOM   1475  H   ARG A  94      44.944 102.129  17.046  1.00  0.00           H  
ATOM   1476  HA  ARG A  94      46.663 103.251  19.031  1.00  0.00           H  
ATOM   1477  HB2 ARG A  94      48.161 104.371  17.378  1.00  0.00           H  
ATOM   1478  HB3 ARG A  94      48.302 102.628  17.282  1.00  0.00           H  
ATOM   1479  HG2 ARG A  94      46.873 102.540  15.304  1.00  0.00           H  
ATOM   1480  HG3 ARG A  94      46.439 104.229  15.472  1.00  0.00           H  
ATOM   1481  HD2 ARG A  94      48.369 104.953  14.465  1.00  0.00           H  
ATOM   1482  HD3 ARG A  94      49.369 103.813  15.344  1.00  0.00           H  
ATOM   1483  HE  ARG A  94      47.764 102.414  13.394  1.00  0.00           H  
ATOM   1484 HH11 ARG A  94      50.590 104.494  13.668  1.00  0.00           H  
ATOM   1485 HH12 ARG A  94      51.332 103.891  12.224  1.00  0.00           H  
ATOM   1486 HH21 ARG A  94      48.743 101.618  11.489  1.00  0.00           H  
ATOM   1487 HH22 ARG A  94      50.274 102.243  10.976  1.00  0.00           H  
ATOM   1488  N   LYS A  95      45.759 105.607  18.389  1.00  0.00           N  
ATOM   1489  CA  LYS A  95      44.959 106.812  18.248  1.00  0.00           C  
ATOM   1490  C   LYS A  95      45.653 107.967  18.973  1.00  0.00           C  
ATOM   1491  O   LYS A  95      45.239 108.359  20.063  1.00  0.00           O  
ATOM   1492  CB  LYS A  95      43.526 106.561  18.724  1.00  0.00           C  
ATOM   1493  CG  LYS A  95      42.532 107.428  17.948  1.00  0.00           C  
ATOM   1494  CD  LYS A  95      41.971 106.672  16.741  1.00  0.00           C  
ATOM   1495  CE  LYS A  95      42.410 107.329  15.430  1.00  0.00           C  
ATOM   1496  NZ  LYS A  95      41.357 107.183  14.401  1.00  0.00           N  
ATOM   1497  H   LYS A  95      46.542 105.689  19.006  1.00  0.00           H  
ATOM   1498  HA  LYS A  95      44.909 107.050  17.187  1.00  0.00           H  
ATOM   1499  HB2 LYS A  95      43.275 105.509  18.594  1.00  0.00           H  
ATOM   1500  HB3 LYS A  95      43.448 106.778  19.789  1.00  0.00           H  
ATOM   1501  HG2 LYS A  95      41.716 107.729  18.605  1.00  0.00           H  
ATOM   1502  HG3 LYS A  95      43.025 108.341  17.612  1.00  0.00           H  
ATOM   1503  HD2 LYS A  95      42.311 105.637  16.766  1.00  0.00           H  
ATOM   1504  HD3 LYS A  95      40.882 106.651  16.795  1.00  0.00           H  
ATOM   1505  HE2 LYS A  95      42.619 108.385  15.598  1.00  0.00           H  
ATOM   1506  HE3 LYS A  95      43.334 106.872  15.080  1.00  0.00           H  
ATOM   1507  HZ1 LYS A  95      40.876 108.053  14.289  1.00  0.00           H  
ATOM   1508  HZ2 LYS A  95      41.775 106.920  13.531  1.00  0.00           H  
ATOM   1509  HZ3 LYS A  95      40.708 106.478  14.684  1.00  0.00           H  
ATOM   1510  N   ILE A  96      46.697 108.479  18.338  1.00  0.00           N  
ATOM   1511  CA  ILE A  96      47.453 109.581  18.907  1.00  0.00           C  
ATOM   1512  C   ILE A  96      46.552 110.813  19.010  1.00  0.00           C  
ATOM   1513  O   ILE A  96      45.446 110.824  18.472  1.00  0.00           O  
ATOM   1514  CB  ILE A  96      48.736 109.822  18.108  1.00  0.00           C  
ATOM   1515  CG1 ILE A  96      49.683 110.759  18.860  1.00  0.00           C  
ATOM   1516  CG2 ILE A  96      48.417 110.335  16.703  1.00  0.00           C  
ATOM   1517  CD1 ILE A  96      51.110 110.642  18.323  1.00  0.00           C  
ATOM   1518  H   ILE A  96      47.028 108.153  17.452  1.00  0.00           H  
ATOM   1519  HA  ILE A  96      47.752 109.287  19.915  1.00  0.00           H  
ATOM   1520  HB  ILE A  96      49.251 108.868  17.994  1.00  0.00           H  
ATOM   1521 HG12 ILE A  96      49.336 111.788  18.761  1.00  0.00           H  
ATOM   1522 HG13 ILE A  96      49.670 110.520  19.923  1.00  0.00           H  
ATOM   1523 HG21 ILE A  96      47.341 110.483  16.605  1.00  0.00           H  
ATOM   1524 HG22 ILE A  96      48.930 111.282  16.536  1.00  0.00           H  
ATOM   1525 HG23 ILE A  96      48.751 109.605  15.965  1.00  0.00           H  
ATOM   1526 HD11 ILE A  96      51.775 111.269  18.918  1.00  0.00           H  
ATOM   1527 HD12 ILE A  96      51.437 109.604  18.386  1.00  0.00           H  
ATOM   1528 HD13 ILE A  96      51.136 110.968  17.284  1.00  0.00           H  
ATOM   1529  N   THR A  97      47.058 111.821  19.706  1.00  0.00           N  
ATOM   1530  CA  THR A  97      46.312 113.055  19.885  1.00  0.00           C  
ATOM   1531  C   THR A  97      47.223 114.152  20.442  1.00  0.00           C  
ATOM   1532  O   THR A  97      48.263 113.861  21.030  1.00  0.00           O  
ATOM   1533  CB  THR A  97      45.108 112.753  20.779  1.00  0.00           C  
ATOM   1534  OG1 THR A  97      44.438 114.007  20.893  1.00  0.00           O  
ATOM   1535  CG2 THR A  97      45.514 112.416  22.214  1.00  0.00           C  
ATOM   1536  H   THR A  97      47.958 111.804  20.140  1.00  0.00           H  
ATOM   1537  HA  THR A  97      45.966 113.392  18.907  1.00  0.00           H  
ATOM   1538  HB  THR A  97      44.494 111.962  20.349  1.00  0.00           H  
ATOM   1539  HG1 THR A  97      43.702 113.941  21.566  1.00  0.00           H  
ATOM   1540 HG21 THR A  97      44.868 112.950  22.910  1.00  0.00           H  
ATOM   1541 HG22 THR A  97      45.413 111.341  22.376  1.00  0.00           H  
ATOM   1542 HG23 THR A  97      46.550 112.712  22.378  1.00  0.00           H  
ATOM   1543  N   ARG A  98      46.797 115.390  20.236  1.00  0.00           N  
ATOM   1544  CA  ARG A  98      47.561 116.532  20.710  1.00  0.00           C  
ATOM   1545  C   ARG A  98      46.868 117.836  20.311  1.00  0.00           C  
ATOM   1546  O   ARG A  98      46.050 117.853  19.392  1.00  0.00           O  
ATOM   1547  CB  ARG A  98      48.981 116.520  20.140  1.00  0.00           C  
ATOM   1548  CG  ARG A  98      50.000 116.140  21.214  1.00  0.00           C  
ATOM   1549  CD  ARG A  98      50.964 117.296  21.489  1.00  0.00           C  
ATOM   1550  NE  ARG A  98      51.579 117.134  22.825  1.00  0.00           N  
ATOM   1551  CZ  ARG A  98      50.944 117.378  23.980  1.00  0.00           C  
ATOM   1552  NH1 ARG A  98      49.671 117.796  23.968  1.00  0.00           N  
ATOM   1553  NH2 ARG A  98      51.582 117.204  25.145  1.00  0.00           N  
ATOM   1554  H   ARG A  98      45.950 115.618  19.757  1.00  0.00           H  
ATOM   1555  HA  ARG A  98      47.588 116.418  21.794  1.00  0.00           H  
ATOM   1556  HB2 ARG A  98      49.038 115.814  19.312  1.00  0.00           H  
ATOM   1557  HB3 ARG A  98      49.221 117.504  19.736  1.00  0.00           H  
ATOM   1558  HG2 ARG A  98      49.481 115.867  22.133  1.00  0.00           H  
ATOM   1559  HG3 ARG A  98      50.562 115.263  20.892  1.00  0.00           H  
ATOM   1560  HD2 ARG A  98      51.739 117.325  20.724  1.00  0.00           H  
ATOM   1561  HD3 ARG A  98      50.430 118.245  21.438  1.00  0.00           H  
ATOM   1562  HE  ARG A  98      52.529 116.824  22.870  1.00  0.00           H  
ATOM   1563 HH11 ARG A  98      49.195 117.927  23.099  1.00  0.00           H  
ATOM   1564 HH12 ARG A  98      49.197 117.978  24.830  1.00  0.00           H  
ATOM   1565 HH21 ARG A  98      52.532 116.892  25.154  1.00  0.00           H  
ATOM   1566 HH22 ARG A  98      51.107 117.386  26.007  1.00  0.00           H  
ATOM   1567  N   ASN A  99      47.221 118.898  21.021  1.00  0.00           N  
ATOM   1568  CA  ASN A  99      46.643 120.203  20.752  1.00  0.00           C  
ATOM   1569  C   ASN A  99      47.130 121.199  21.808  1.00  0.00           C  
ATOM   1570  O   ASN A  99      47.418 120.816  22.940  1.00  0.00           O  
ATOM   1571  CB  ASN A  99      45.116 120.154  20.818  1.00  0.00           C  
ATOM   1572  CG  ASN A  99      44.644 119.533  22.135  1.00  0.00           C  
ATOM   1573  OD1 ASN A  99      44.763 120.112  23.202  1.00  0.00           O  
ATOM   1574  ND2 ASN A  99      44.102 118.326  22.000  1.00  0.00           N  
ATOM   1575  H   ASN A  99      47.886 118.876  21.767  1.00  0.00           H  
ATOM   1576  HA  ASN A  99      46.978 120.463  19.748  1.00  0.00           H  
ATOM   1577  HB2 ASN A  99      44.712 121.162  20.723  1.00  0.00           H  
ATOM   1578  HB3 ASN A  99      44.730 119.575  19.980  1.00  0.00           H  
ATOM   1579 HD21 ASN A  99      44.035 117.906  21.094  1.00  0.00           H  
ATOM   1580 HD22 ASN A  99      43.764 117.836  22.804  1.00  0.00           H  
ATOM   1581  N   GLN A 100      47.209 122.457  21.397  1.00  0.00           N  
ATOM   1582  CA  GLN A 100      47.656 123.509  22.293  1.00  0.00           C  
ATOM   1583  C   GLN A 100      47.520 124.875  21.616  1.00  0.00           C  
ATOM   1584  O   GLN A 100      47.398 124.957  20.395  1.00  0.00           O  
ATOM   1585  CB  GLN A 100      49.095 123.264  22.751  1.00  0.00           C  
ATOM   1586  CG  GLN A 100      49.250 123.544  24.247  1.00  0.00           C  
ATOM   1587  CD  GLN A 100      48.916 122.302  25.074  1.00  0.00           C  
ATOM   1588  OE1 GLN A 100      49.730 121.415  25.267  1.00  0.00           O  
ATOM   1589  NE2 GLN A 100      47.674 122.288  25.553  1.00  0.00           N  
ATOM   1590  H   GLN A 100      46.973 122.759  20.474  1.00  0.00           H  
ATOM   1591  HA  GLN A 100      46.993 123.456  23.156  1.00  0.00           H  
ATOM   1592  HB2 GLN A 100      49.377 122.234  22.540  1.00  0.00           H  
ATOM   1593  HB3 GLN A 100      49.774 123.903  22.186  1.00  0.00           H  
ATOM   1594  HG2 GLN A 100      50.270 123.862  24.458  1.00  0.00           H  
ATOM   1595  HG3 GLN A 100      48.594 124.367  24.537  1.00  0.00           H  
ATOM   1596 HE21 GLN A 100      47.054 123.049  25.358  1.00  0.00           H  
ATOM   1597 HE22 GLN A 100      47.360 121.517  26.107  1.00  0.00           H  
ATOM   1598  N   LYS A 101      47.546 125.913  22.440  1.00  0.00           N  
ATOM   1599  CA  LYS A 101      47.428 127.270  21.936  1.00  0.00           C  
ATOM   1600  C   LYS A 101      47.640 128.257  23.087  1.00  0.00           C  
ATOM   1601  O   LYS A 101      47.714 127.855  24.246  1.00  0.00           O  
ATOM   1602  CB  LYS A 101      46.097 127.456  21.204  1.00  0.00           C  
ATOM   1603  CG  LYS A 101      44.919 127.366  22.176  1.00  0.00           C  
ATOM   1604  CD  LYS A 101      44.518 128.752  22.684  1.00  0.00           C  
ATOM   1605  CE  LYS A 101      43.168 129.179  22.106  1.00  0.00           C  
ATOM   1606  NZ  LYS A 101      42.324 129.791  23.158  1.00  0.00           N  
ATOM   1607  H   LYS A 101      47.645 125.837  23.432  1.00  0.00           H  
ATOM   1608  HA  LYS A 101      48.221 127.417  21.204  1.00  0.00           H  
ATOM   1609  HB2 LYS A 101      46.085 128.424  20.702  1.00  0.00           H  
ATOM   1610  HB3 LYS A 101      45.994 126.696  20.430  1.00  0.00           H  
ATOM   1611  HG2 LYS A 101      44.069 126.896  21.680  1.00  0.00           H  
ATOM   1612  HG3 LYS A 101      45.187 126.729  23.019  1.00  0.00           H  
ATOM   1613  HD2 LYS A 101      44.467 128.744  23.773  1.00  0.00           H  
ATOM   1614  HD3 LYS A 101      45.282 129.479  22.407  1.00  0.00           H  
ATOM   1615  HE2 LYS A 101      43.320 129.889  21.294  1.00  0.00           H  
ATOM   1616  HE3 LYS A 101      42.658 128.314  21.682  1.00  0.00           H  
ATOM   1617  HZ1 LYS A 101      41.454 129.302  23.214  1.00  0.00           H  
ATOM   1618  HZ2 LYS A 101      42.797 129.735  24.038  1.00  0.00           H  
ATOM   1619  HZ3 LYS A 101      42.154 130.750  22.931  1.00  0.00           H  
ATOM   1620  N   ARG A 102      47.730 129.528  22.724  1.00  0.00           N  
ATOM   1621  CA  ARG A 102      47.932 130.575  23.712  1.00  0.00           C  
ATOM   1622  C   ARG A 102      47.949 131.947  23.035  1.00  0.00           C  
ATOM   1623  O   ARG A 102      48.416 132.079  21.905  1.00  0.00           O  
ATOM   1624  CB  ARG A 102      49.245 130.370  24.471  1.00  0.00           C  
ATOM   1625  CG  ARG A 102      49.066 130.655  25.963  1.00  0.00           C  
ATOM   1626  CD  ARG A 102      50.157 129.968  26.787  1.00  0.00           C  
ATOM   1627  NE  ARG A 102      50.367 130.697  28.057  1.00  0.00           N  
ATOM   1628  CZ  ARG A 102      51.370 130.447  28.910  1.00  0.00           C  
ATOM   1629  NH1 ARG A 102      52.259 129.484  28.635  1.00  0.00           N  
ATOM   1630  NH2 ARG A 102      51.482 131.160  30.040  1.00  0.00           N  
ATOM   1631  H   ARG A 102      47.668 129.846  21.778  1.00  0.00           H  
ATOM   1632  HA  ARG A 102      47.084 130.484  24.392  1.00  0.00           H  
ATOM   1633  HB2 ARG A 102      49.594 129.348  24.331  1.00  0.00           H  
ATOM   1634  HB3 ARG A 102      50.011 131.028  24.061  1.00  0.00           H  
ATOM   1635  HG2 ARG A 102      49.096 131.730  26.139  1.00  0.00           H  
ATOM   1636  HG3 ARG A 102      48.086 130.305  26.289  1.00  0.00           H  
ATOM   1637  HD2 ARG A 102      49.874 128.936  26.993  1.00  0.00           H  
ATOM   1638  HD3 ARG A 102      51.087 129.935  26.218  1.00  0.00           H  
ATOM   1639  HE  ARG A 102      49.721 131.423  28.293  1.00  0.00           H  
ATOM   1640 HH11 ARG A 102      52.175 128.952  27.792  1.00  0.00           H  
ATOM   1641 HH12 ARG A 102      53.007 129.297  29.272  1.00  0.00           H  
ATOM   1642 HH21 ARG A 102      50.818 131.878  30.246  1.00  0.00           H  
ATOM   1643 HH22 ARG A 102      52.229 130.973  30.677  1.00  0.00           H  
ATOM   1644  N   LYS A 103      47.436 132.933  23.756  1.00  0.00           N  
ATOM   1645  CA  LYS A 103      47.386 134.290  23.238  1.00  0.00           C  
ATOM   1646  C   LYS A 103      47.354 135.276  24.408  1.00  0.00           C  
ATOM   1647  O   LYS A 103      46.715 135.015  25.427  1.00  0.00           O  
ATOM   1648  CB  LYS A 103      46.218 134.451  22.265  1.00  0.00           C  
ATOM   1649  CG  LYS A 103      46.714 134.532  20.820  1.00  0.00           C  
ATOM   1650  CD  LYS A 103      46.757 135.981  20.334  1.00  0.00           C  
ATOM   1651  CE  LYS A 103      48.057 136.270  19.581  1.00  0.00           C  
ATOM   1652  NZ  LYS A 103      49.084 136.801  20.504  1.00  0.00           N  
ATOM   1653  H   LYS A 103      47.058 132.817  24.674  1.00  0.00           H  
ATOM   1654  HA  LYS A 103      48.303 134.457  22.672  1.00  0.00           H  
ATOM   1655  HB2 LYS A 103      45.532 133.610  22.372  1.00  0.00           H  
ATOM   1656  HB3 LYS A 103      45.656 135.352  22.511  1.00  0.00           H  
ATOM   1657  HG2 LYS A 103      47.708 134.091  20.749  1.00  0.00           H  
ATOM   1658  HG3 LYS A 103      46.059 133.947  20.173  1.00  0.00           H  
ATOM   1659  HD2 LYS A 103      45.904 136.177  19.684  1.00  0.00           H  
ATOM   1660  HD3 LYS A 103      46.668 136.657  21.186  1.00  0.00           H  
ATOM   1661  HE2 LYS A 103      48.420 135.357  19.110  1.00  0.00           H  
ATOM   1662  HE3 LYS A 103      47.870 136.987  18.783  1.00  0.00           H  
ATOM   1663  HZ1 LYS A 103      49.991 136.515  20.194  1.00  0.00           H  
ATOM   1664  HZ2 LYS A 103      49.036 137.799  20.518  1.00  0.00           H  
ATOM   1665  HZ3 LYS A 103      48.920 136.447  21.426  1.00  0.00           H  
ATOM   1666  N   HIS A 104      48.048 136.389  24.223  1.00  0.00           N  
ATOM   1667  CA  HIS A 104      48.105 137.415  25.249  1.00  0.00           C  
ATOM   1668  C   HIS A 104      48.325 138.782  24.597  1.00  0.00           C  
ATOM   1669  O   HIS A 104      48.705 138.864  23.431  1.00  0.00           O  
ATOM   1670  CB  HIS A 104      49.171 137.079  26.295  1.00  0.00           C  
ATOM   1671  CG  HIS A 104      50.547 136.852  25.717  1.00  0.00           C  
ATOM   1672  ND1 HIS A 104      51.408 135.875  26.189  1.00  0.00           N  
ATOM   1673  CD2 HIS A 104      51.204 137.484  24.702  1.00  0.00           C  
ATOM   1674  CE1 HIS A 104      52.528 135.928  25.483  1.00  0.00           C  
ATOM   1675  NE2 HIS A 104      52.399 136.925  24.562  1.00  0.00           N  
ATOM   1676  H   HIS A 104      48.564 136.594  23.391  1.00  0.00           H  
ATOM   1677  HA  HIS A 104      47.138 137.412  25.749  1.00  0.00           H  
ATOM   1678  HB2 HIS A 104      49.223 137.890  27.021  1.00  0.00           H  
ATOM   1679  HB3 HIS A 104      48.865 136.184  26.836  1.00  0.00           H  
ATOM   1680  HD1 HIS A 104      51.216 135.238  26.935  1.00  0.00           H  
ATOM   1681  HD2 HIS A 104      50.811 138.309  24.106  1.00  0.00           H  
ATOM   1682  HE1 HIS A 104      53.399 135.285  25.615  1.00  0.00           H  
ATOM   1683  N   ASP A 105      48.076 139.822  25.380  1.00  0.00           N  
ATOM   1684  CA  ASP A 105      48.242 141.180  24.894  1.00  0.00           C  
ATOM   1685  C   ASP A 105      47.982 142.162  26.039  1.00  0.00           C  
ATOM   1686  O   ASP A 105      47.473 141.776  27.090  1.00  0.00           O  
ATOM   1687  CB  ASP A 105      47.248 141.489  23.772  1.00  0.00           C  
ATOM   1688  CG  ASP A 105      45.776 141.459  24.185  1.00  0.00           C  
ATOM   1689  OD1 ASP A 105      45.327 142.474  24.759  1.00  0.00           O  
ATOM   1690  OD2 ASP A 105      45.133 140.420  23.918  1.00  0.00           O  
ATOM   1691  H   ASP A 105      47.767 139.746  26.328  1.00  0.00           H  
ATOM   1692  HA  ASP A 105      49.267 141.231  24.526  1.00  0.00           H  
ATOM   1693  HB2 ASP A 105      47.476 142.475  23.367  1.00  0.00           H  
ATOM   1694  HB3 ASP A 105      47.400 140.771  22.966  1.00  0.00           H  
ATOM   1695  N   GLU A 106      48.345 143.413  25.796  1.00  0.00           N  
ATOM   1696  CA  GLU A 106      48.157 144.453  26.793  1.00  0.00           C  
ATOM   1697  C   GLU A 106      48.083 145.826  26.122  1.00  0.00           C  
ATOM   1698  O   GLU A 106      48.849 146.113  25.203  1.00  0.00           O  
ATOM   1699  CB  GLU A 106      49.271 144.416  27.842  1.00  0.00           C  
ATOM   1700  CG  GLU A 106      48.871 145.194  29.097  1.00  0.00           C  
ATOM   1701  CD  GLU A 106      50.102 145.756  29.809  1.00  0.00           C  
ATOM   1702  OE1 GLU A 106      50.965 146.313  29.098  1.00  0.00           O  
ATOM   1703  OE2 GLU A 106      50.152 145.615  31.051  1.00  0.00           O  
ATOM   1704  H   GLU A 106      48.759 143.719  24.939  1.00  0.00           H  
ATOM   1705  HA  GLU A 106      47.206 144.226  27.274  1.00  0.00           H  
ATOM   1706  HB2 GLU A 106      49.492 143.381  28.106  1.00  0.00           H  
ATOM   1707  HB3 GLU A 106      50.184 144.839  27.422  1.00  0.00           H  
ATOM   1708  HG2 GLU A 106      48.199 146.009  28.824  1.00  0.00           H  
ATOM   1709  HG3 GLU A 106      48.320 144.540  29.773  1.00  0.00           H  
ATOM   1710  N   ILE A 107      47.153 146.637  26.605  1.00  0.00           N  
ATOM   1711  CA  ILE A 107      46.970 147.972  26.063  1.00  0.00           C  
ATOM   1712  C   ILE A 107      48.040 148.903  26.636  1.00  0.00           C  
ATOM   1713  O   ILE A 107      48.845 148.489  27.469  1.00  0.00           O  
ATOM   1714  CB  ILE A 107      45.539 148.456  26.306  1.00  0.00           C  
ATOM   1715  CG1 ILE A 107      45.237 148.545  27.803  1.00  0.00           C  
ATOM   1716  CG2 ILE A 107      44.528 147.576  25.569  1.00  0.00           C  
ATOM   1717  CD1 ILE A 107      45.256 149.999  28.281  1.00  0.00           C  
ATOM   1718  H   ILE A 107      46.534 146.395  27.353  1.00  0.00           H  
ATOM   1719  HA  ILE A 107      47.110 147.908  24.984  1.00  0.00           H  
ATOM   1720  HB  ILE A 107      45.445 149.463  25.899  1.00  0.00           H  
ATOM   1721 HG12 ILE A 107      44.262 148.104  28.008  1.00  0.00           H  
ATOM   1722 HG13 ILE A 107      45.973 147.966  28.361  1.00  0.00           H  
ATOM   1723 HG21 ILE A 107      43.565 148.083  25.528  1.00  0.00           H  
ATOM   1724 HG22 ILE A 107      44.883 147.387  24.555  1.00  0.00           H  
ATOM   1725 HG23 ILE A 107      44.419 146.628  26.097  1.00  0.00           H  
ATOM   1726 HD11 ILE A 107      46.261 150.260  28.608  1.00  0.00           H  
ATOM   1727 HD12 ILE A 107      44.956 150.654  27.463  1.00  0.00           H  
ATOM   1728 HD13 ILE A 107      44.560 150.116  29.113  1.00  0.00           H  
ATOM   1729  N   ASN A 108      48.014 150.142  26.168  1.00  0.00           N  
ATOM   1730  CA  ASN A 108      48.972 151.135  26.623  1.00  0.00           C  
ATOM   1731  C   ASN A 108      48.591 152.503  26.055  1.00  0.00           C  
ATOM   1732  O   ASN A 108      47.912 152.589  25.034  1.00  0.00           O  
ATOM   1733  CB  ASN A 108      50.385 150.799  26.141  1.00  0.00           C  
ATOM   1734  CG  ASN A 108      51.135 149.961  27.179  1.00  0.00           C  
ATOM   1735  OD1 ASN A 108      50.745 149.859  28.331  1.00  0.00           O  
ATOM   1736  ND2 ASN A 108      52.229 149.370  26.708  1.00  0.00           N  
ATOM   1737  H   ASN A 108      47.356 150.470  25.490  1.00  0.00           H  
ATOM   1738  HA  ASN A 108      48.919 151.105  27.712  1.00  0.00           H  
ATOM   1739  HB2 ASN A 108      50.331 150.254  25.198  1.00  0.00           H  
ATOM   1740  HB3 ASN A 108      50.935 151.720  25.945  1.00  0.00           H  
ATOM   1741 HD21 ASN A 108      52.493 149.495  25.751  1.00  0.00           H  
ATOM   1742 HD22 ASN A 108      52.787 148.800  27.311  1.00  0.00           H  
ATOM   1743  N   HIS A 109      49.046 153.541  26.743  1.00  0.00           N  
ATOM   1744  CA  HIS A 109      48.761 154.902  26.320  1.00  0.00           C  
ATOM   1745  C   HIS A 109      49.534 155.885  27.201  1.00  0.00           C  
ATOM   1746  O   HIS A 109      50.028 155.515  28.264  1.00  0.00           O  
ATOM   1747  CB  HIS A 109      47.253 155.166  26.319  1.00  0.00           C  
ATOM   1748  CG  HIS A 109      46.818 156.233  25.343  1.00  0.00           C  
ATOM   1749  ND1 HIS A 109      46.249 155.939  24.115  1.00  0.00           N  
ATOM   1750  CD2 HIS A 109      46.874 157.594  25.426  1.00  0.00           C  
ATOM   1751  CE1 HIS A 109      45.979 157.079  23.496  1.00  0.00           C  
ATOM   1752  NE2 HIS A 109      46.367 158.103  24.310  1.00  0.00           N  
ATOM   1753  H   HIS A 109      49.597 153.464  27.574  1.00  0.00           H  
ATOM   1754  HA  HIS A 109      49.114 154.990  25.294  1.00  0.00           H  
ATOM   1755  HB2 HIS A 109      46.732 154.238  26.082  1.00  0.00           H  
ATOM   1756  HB3 HIS A 109      46.945 155.458  27.322  1.00  0.00           H  
ATOM   1757  HD1 HIS A 109      46.072 155.023  23.757  1.00  0.00           H  
ATOM   1758  HD2 HIS A 109      47.267 158.164  26.267  1.00  0.00           H  
ATOM   1759  HE1 HIS A 109      45.527 157.181  22.510  1.00  0.00           H  
ATOM   1760  N   VAL A 110      49.614 157.119  26.726  1.00  0.00           N  
ATOM   1761  CA  VAL A 110      50.318 158.159  27.456  1.00  0.00           C  
ATOM   1762  C   VAL A 110      49.588 159.491  27.271  1.00  0.00           C  
ATOM   1763  O   VAL A 110      49.009 159.744  26.215  1.00  0.00           O  
ATOM   1764  CB  VAL A 110      51.780 158.213  27.010  1.00  0.00           C  
ATOM   1765  CG1 VAL A 110      52.036 159.426  26.113  1.00  0.00           C  
ATOM   1766  CG2 VAL A 110      52.722 158.214  28.216  1.00  0.00           C  
ATOM   1767  H   VAL A 110      49.208 157.412  25.859  1.00  0.00           H  
ATOM   1768  HA  VAL A 110      50.296 157.891  28.512  1.00  0.00           H  
ATOM   1769  HB  VAL A 110      51.985 157.315  26.425  1.00  0.00           H  
ATOM   1770 HG11 VAL A 110      52.190 160.309  26.733  1.00  0.00           H  
ATOM   1771 HG12 VAL A 110      52.924 159.249  25.507  1.00  0.00           H  
ATOM   1772 HG13 VAL A 110      51.177 159.583  25.461  1.00  0.00           H  
ATOM   1773 HG21 VAL A 110      53.698 158.594  27.914  1.00  0.00           H  
ATOM   1774 HG22 VAL A 110      52.309 158.852  28.998  1.00  0.00           H  
ATOM   1775 HG23 VAL A 110      52.828 157.198  28.595  1.00  0.00           H  
ATOM   1776  N   GLN A 111      49.637 160.306  28.315  1.00  0.00           N  
ATOM   1777  CA  GLN A 111      48.987 161.605  28.280  1.00  0.00           C  
ATOM   1778  C   GLN A 111      49.746 162.601  29.159  1.00  0.00           C  
ATOM   1779  O   GLN A 111      50.452 162.205  30.085  1.00  0.00           O  
ATOM   1780  CB  GLN A 111      47.523 161.497  28.712  1.00  0.00           C  
ATOM   1781  CG  GLN A 111      46.691 160.770  27.655  1.00  0.00           C  
ATOM   1782  CD  GLN A 111      46.950 161.346  26.261  1.00  0.00           C  
ATOM   1783  OE1 GLN A 111      47.007 160.638  25.269  1.00  0.00           O  
ATOM   1784  NE2 GLN A 111      47.104 162.667  26.242  1.00  0.00           N  
ATOM   1785  H   GLN A 111      50.109 160.091  29.169  1.00  0.00           H  
ATOM   1786  HA  GLN A 111      49.029 161.922  27.238  1.00  0.00           H  
ATOM   1787  HB2 GLN A 111      47.459 160.965  29.661  1.00  0.00           H  
ATOM   1788  HB3 GLN A 111      47.115 162.495  28.879  1.00  0.00           H  
ATOM   1789  HG2 GLN A 111      46.933 159.707  27.664  1.00  0.00           H  
ATOM   1790  HG3 GLN A 111      45.632 160.857  27.897  1.00  0.00           H  
ATOM   1791 HE21 GLN A 111      47.046 163.189  27.093  1.00  0.00           H  
ATOM   1792 HE22 GLN A 111      47.278 163.137  25.377  1.00  0.00           H  
ATOM   1793  N   LYS A 112      49.575 163.875  28.837  1.00  0.00           N  
ATOM   1794  CA  LYS A 112      50.235 164.931  29.585  1.00  0.00           C  
ATOM   1795  C   LYS A 112      49.665 166.285  29.159  1.00  0.00           C  
ATOM   1796  O   LYS A 112      49.274 166.463  28.006  1.00  0.00           O  
ATOM   1797  CB  LYS A 112      51.754 164.828  29.431  1.00  0.00           C  
ATOM   1798  CG  LYS A 112      52.470 165.673  30.486  1.00  0.00           C  
ATOM   1799  CD  LYS A 112      52.893 167.025  29.910  1.00  0.00           C  
ATOM   1800  CE  LYS A 112      53.555 167.896  30.981  1.00  0.00           C  
ATOM   1801  NZ  LYS A 112      54.266 169.034  30.358  1.00  0.00           N  
ATOM   1802  H   LYS A 112      48.998 164.188  28.082  1.00  0.00           H  
ATOM   1803  HA  LYS A 112      50.006 164.776  30.639  1.00  0.00           H  
ATOM   1804  HB2 LYS A 112      52.063 163.786  29.525  1.00  0.00           H  
ATOM   1805  HB3 LYS A 112      52.045 165.159  28.435  1.00  0.00           H  
ATOM   1806  HG2 LYS A 112      51.813 165.828  31.342  1.00  0.00           H  
ATOM   1807  HG3 LYS A 112      53.347 165.139  30.851  1.00  0.00           H  
ATOM   1808  HD2 LYS A 112      53.586 166.872  29.082  1.00  0.00           H  
ATOM   1809  HD3 LYS A 112      52.023 167.541  29.504  1.00  0.00           H  
ATOM   1810  HE2 LYS A 112      52.800 168.266  31.674  1.00  0.00           H  
ATOM   1811  HE3 LYS A 112      54.255 167.296  31.563  1.00  0.00           H  
ATOM   1812  HZ1 LYS A 112      54.434 168.834  29.393  1.00  0.00           H  
ATOM   1813  HZ2 LYS A 112      53.706 169.859  30.435  1.00  0.00           H  
ATOM   1814  HZ3 LYS A 112      55.138 169.178  30.825  1.00  0.00           H  
ATOM   1815  N   THR A 113      49.636 167.206  30.111  1.00  0.00           N  
ATOM   1816  CA  THR A 113      49.120 168.538  29.848  1.00  0.00           C  
ATOM   1817  C   THR A 113      49.845 169.572  30.713  1.00  0.00           C  
ATOM   1818  O   THR A 113      50.540 169.213  31.663  1.00  0.00           O  
ATOM   1819  CB  THR A 113      47.607 168.513  30.072  1.00  0.00           C  
ATOM   1820  OG1 THR A 113      47.130 167.569  29.116  1.00  0.00           O  
ATOM   1821  CG2 THR A 113      46.933 169.826  29.668  1.00  0.00           C  
ATOM   1822  H   THR A 113      49.955 167.054  31.046  1.00  0.00           H  
ATOM   1823  HA  THR A 113      49.330 168.790  28.808  1.00  0.00           H  
ATOM   1824  HB  THR A 113      47.370 168.255  31.104  1.00  0.00           H  
ATOM   1825  HG1 THR A 113      47.266 167.922  28.191  1.00  0.00           H  
ATOM   1826 HG21 THR A 113      47.385 170.199  28.749  1.00  0.00           H  
ATOM   1827 HG22 THR A 113      45.869 169.652  29.505  1.00  0.00           H  
ATOM   1828 HG23 THR A 113      47.064 170.561  30.461  1.00  0.00           H  
ATOM   1829  N   TYR A 114      49.658 170.833  30.355  1.00  0.00           N  
ATOM   1830  CA  TYR A 114      50.285 171.920  31.088  1.00  0.00           C  
ATOM   1831  C   TYR A 114      49.407 173.173  31.068  1.00  0.00           C  
ATOM   1832  O   TYR A 114      48.343 173.181  30.450  1.00  0.00           O  
ATOM   1833  CB  TYR A 114      51.596 172.218  30.359  1.00  0.00           C  
ATOM   1834  CG  TYR A 114      51.437 173.122  29.134  1.00  0.00           C  
ATOM   1835  CD1 TYR A 114      51.432 174.494  29.285  1.00  0.00           C  
ATOM   1836  CD2 TYR A 114      51.294 172.565  27.880  1.00  0.00           C  
ATOM   1837  CE1 TYR A 114      51.281 175.344  28.134  1.00  0.00           C  
ATOM   1838  CE2 TYR A 114      51.143 173.416  26.727  1.00  0.00           C  
ATOM   1839  CZ  TYR A 114      51.144 174.764  26.912  1.00  0.00           C  
ATOM   1840  OH  TYR A 114      51.002 175.568  25.824  1.00  0.00           O  
ATOM   1841  H   TYR A 114      49.091 171.116  29.582  1.00  0.00           H  
ATOM   1842  HA  TYR A 114      50.419 171.597  32.120  1.00  0.00           H  
ATOM   1843  HB2 TYR A 114      52.289 172.689  31.056  1.00  0.00           H  
ATOM   1844  HB3 TYR A 114      52.048 171.277  30.046  1.00  0.00           H  
ATOM   1845  HD1 TYR A 114      51.544 174.933  30.277  1.00  0.00           H  
ATOM   1846  HD2 TYR A 114      51.297 171.482  27.760  1.00  0.00           H  
ATOM   1847  HE1 TYR A 114      51.278 176.430  28.239  1.00  0.00           H  
ATOM   1848  HE2 TYR A 114      51.031 172.990  25.730  1.00  0.00           H  
ATOM   1849  HH  TYR A 114      50.267 176.227  25.979  1.00  0.00           H  
ATOM   1850  N   ALA A 115      49.886 174.203  31.750  1.00  0.00           N  
ATOM   1851  CA  ALA A 115      49.158 175.459  31.818  1.00  0.00           C  
ATOM   1852  C   ALA A 115      50.151 176.622  31.762  1.00  0.00           C  
ATOM   1853  O   ALA A 115      51.274 176.508  32.250  1.00  0.00           O  
ATOM   1854  CB  ALA A 115      48.301 175.485  33.084  1.00  0.00           C  
ATOM   1855  H   ALA A 115      50.752 174.189  32.249  1.00  0.00           H  
ATOM   1856  HA  ALA A 115      48.503 175.510  30.948  1.00  0.00           H  
ATOM   1857  HB1 ALA A 115      47.884 176.483  33.222  1.00  0.00           H  
ATOM   1858  HB2 ALA A 115      47.489 174.762  32.989  1.00  0.00           H  
ATOM   1859  HB3 ALA A 115      48.917 175.226  33.946  1.00  0.00           H  
ATOM   1860  N   GLU A 116      49.700 177.715  31.165  1.00  0.00           N  
ATOM   1861  CA  GLU A 116      50.534 178.898  31.039  1.00  0.00           C  
ATOM   1862  C   GLU A 116      50.188 179.910  32.133  1.00  0.00           C  
ATOM   1863  O   GLU A 116      49.051 180.373  32.219  1.00  0.00           O  
ATOM   1864  CB  GLU A 116      50.394 179.523  29.650  1.00  0.00           C  
ATOM   1865  CG  GLU A 116      51.650 179.283  28.812  1.00  0.00           C  
ATOM   1866  CD  GLU A 116      51.420 179.682  27.352  1.00  0.00           C  
ATOM   1867  OE1 GLU A 116      51.420 180.904  27.092  1.00  0.00           O  
ATOM   1868  OE2 GLU A 116      51.250 178.755  26.530  1.00  0.00           O  
ATOM   1869  H   GLU A 116      48.784 177.800  30.772  1.00  0.00           H  
ATOM   1870  HA  GLU A 116      51.557 178.546  31.172  1.00  0.00           H  
ATOM   1871  HB2 GLU A 116      49.527 179.100  29.143  1.00  0.00           H  
ATOM   1872  HB3 GLU A 116      50.215 180.594  29.746  1.00  0.00           H  
ATOM   1873  HG2 GLU A 116      52.481 179.855  29.221  1.00  0.00           H  
ATOM   1874  HG3 GLU A 116      51.931 178.230  28.864  1.00  0.00           H  
ATOM   1875  N   MET A 117      51.188 180.224  32.943  1.00  0.00           N  
ATOM   1876  CA  MET A 117      51.004 181.173  34.028  1.00  0.00           C  
ATOM   1877  C   MET A 117      51.516 182.560  33.636  1.00  0.00           C  
ATOM   1878  O   MET A 117      52.244 182.702  32.654  1.00  0.00           O  
ATOM   1879  CB  MET A 117      51.754 180.682  35.268  1.00  0.00           C  
ATOM   1880  CG  MET A 117      53.268 180.737  35.051  1.00  0.00           C  
ATOM   1881  SD  MET A 117      54.023 179.227  35.631  1.00  0.00           S  
ATOM   1882  CE  MET A 117      53.597 178.132  34.288  1.00  0.00           C  
ATOM   1883  H   MET A 117      52.110 179.844  32.866  1.00  0.00           H  
ATOM   1884  HA  MET A 117      49.929 181.211  34.203  1.00  0.00           H  
ATOM   1885  HB2 MET A 117      51.484 181.296  36.127  1.00  0.00           H  
ATOM   1886  HB3 MET A 117      51.453 179.661  35.500  1.00  0.00           H  
ATOM   1887  HG2 MET A 117      53.486 180.878  33.992  1.00  0.00           H  
ATOM   1888  HG3 MET A 117      53.689 181.591  35.580  1.00  0.00           H  
ATOM   1889  HE1 MET A 117      52.513 178.079  34.190  1.00  0.00           H  
ATOM   1890  HE2 MET A 117      54.028 178.510  33.360  1.00  0.00           H  
ATOM   1891  HE3 MET A 117      53.992 177.136  34.492  1.00  0.00           H  
ATOM   1892  N   ASP A 118      51.117 183.548  34.424  1.00  0.00           N  
ATOM   1893  CA  ASP A 118      51.528 184.919  34.172  1.00  0.00           C  
ATOM   1894  C   ASP A 118      53.014 185.070  34.499  1.00  0.00           C  
ATOM   1895  O   ASP A 118      53.508 184.470  35.452  1.00  0.00           O  
ATOM   1896  CB  ASP A 118      50.749 185.898  35.052  1.00  0.00           C  
ATOM   1897  CG  ASP A 118      50.927 187.374  34.693  1.00  0.00           C  
ATOM   1898  OD1 ASP A 118      50.420 187.763  33.619  1.00  0.00           O  
ATOM   1899  OD2 ASP A 118      51.569 188.081  35.501  1.00  0.00           O  
ATOM   1900  H   ASP A 118      50.526 183.423  35.220  1.00  0.00           H  
ATOM   1901  HA  ASP A 118      51.313 185.093  33.117  1.00  0.00           H  
ATOM   1902  HB2 ASP A 118      49.688 185.651  34.992  1.00  0.00           H  
ATOM   1903  HB3 ASP A 118      51.052 185.751  36.089  1.00  0.00           H  
ATOM   1904  N   PRO A 119      53.705 185.896  33.667  1.00  0.00           N  
ATOM   1905  CA  PRO A 119      55.125 186.134  33.859  1.00  0.00           C  
ATOM   1906  C   PRO A 119      55.370 187.068  35.047  1.00  0.00           C  
ATOM   1907  O   PRO A 119      55.848 186.633  36.093  1.00  0.00           O  
ATOM   1908  CB  PRO A 119      55.609 186.713  32.539  1.00  0.00           C  
ATOM   1909  CG  PRO A 119      54.364 187.211  31.822  1.00  0.00           C  
ATOM   1910  CD  PRO A 119      53.153 186.623  32.528  1.00  0.00           C  
ATOM   1911  HA  PRO A 119      55.593 185.279  34.082  1.00  0.00           H  
ATOM   1912  HB2 PRO A 119      56.315 187.526  32.705  1.00  0.00           H  
ATOM   1913  HB3 PRO A 119      56.125 185.958  31.947  1.00  0.00           H  
ATOM   1914  HG2 PRO A 119      54.324 188.300  31.837  1.00  0.00           H  
ATOM   1915  HG3 PRO A 119      54.380 186.907  30.776  1.00  0.00           H  
ATOM   1916  HD2 PRO A 119      52.466 187.406  32.853  1.00  0.00           H  
ATOM   1917  HD3 PRO A 119      52.592 185.961  31.870  1.00  0.00           H  
ATOM   1918  N   THR A 120      55.032 188.333  34.845  1.00  0.00           N  
ATOM   1919  CA  THR A 120      55.209 189.330  35.885  1.00  0.00           C  
ATOM   1920  C   THR A 120      54.404 190.590  35.560  1.00  0.00           C  
ATOM   1921  O   THR A 120      54.256 190.952  34.393  1.00  0.00           O  
ATOM   1922  CB  THR A 120      56.708 189.591  36.040  1.00  0.00           C  
ATOM   1923  OG1 THR A 120      56.792 190.494  37.139  1.00  0.00           O  
ATOM   1924  CG2 THR A 120      57.289 190.380  34.864  1.00  0.00           C  
ATOM   1925  H   THR A 120      54.644 188.677  33.990  1.00  0.00           H  
ATOM   1926  HA  THR A 120      54.811 188.928  36.817  1.00  0.00           H  
ATOM   1927  HB  THR A 120      57.253 188.659  36.190  1.00  0.00           H  
ATOM   1928  HG1 THR A 120      56.334 191.353  36.910  1.00  0.00           H  
ATOM   1929 HG21 THR A 120      57.815 191.258  35.240  1.00  0.00           H  
ATOM   1930 HG22 THR A 120      57.986 189.748  34.312  1.00  0.00           H  
ATOM   1931 HG23 THR A 120      56.482 190.694  34.203  1.00  0.00           H  
ATOM   1932  N   THR A 121      53.903 191.221  36.611  1.00  0.00           N  
ATOM   1933  CA  THR A 121      53.115 192.433  36.451  1.00  0.00           C  
ATOM   1934  C   THR A 121      53.317 193.361  37.651  1.00  0.00           C  
ATOM   1935  O   THR A 121      53.702 192.913  38.730  1.00  0.00           O  
ATOM   1936  CB  THR A 121      51.658 192.024  36.237  1.00  0.00           C  
ATOM   1937  OG1 THR A 121      50.991 193.250  35.948  1.00  0.00           O  
ATOM   1938  CG2 THR A 121      50.992 191.532  37.525  1.00  0.00           C  
ATOM   1939  H   THR A 121      54.027 190.920  37.556  1.00  0.00           H  
ATOM   1940  HA  THR A 121      53.478 192.964  35.571  1.00  0.00           H  
ATOM   1941  HB  THR A 121      51.574 191.277  35.447  1.00  0.00           H  
ATOM   1942  HG1 THR A 121      51.291 193.600  35.061  1.00  0.00           H  
ATOM   1943 HG21 THR A 121      50.045 192.055  37.667  1.00  0.00           H  
ATOM   1944 HG22 THR A 121      50.807 190.461  37.453  1.00  0.00           H  
ATOM   1945 HG23 THR A 121      51.648 191.733  38.372  1.00  0.00           H  
ATOM   1946  N   ALA A 122      53.049 194.638  37.421  1.00  0.00           N  
ATOM   1947  CA  ALA A 122      53.195 195.634  38.469  1.00  0.00           C  
ATOM   1948  C   ALA A 122      52.727 196.993  37.944  1.00  0.00           C  
ATOM   1949  O   ALA A 122      52.321 197.110  36.790  1.00  0.00           O  
ATOM   1950  CB  ALA A 122      54.649 195.662  38.946  1.00  0.00           C  
ATOM   1951  H   ALA A 122      52.737 194.994  36.540  1.00  0.00           H  
ATOM   1952  HA  ALA A 122      52.558 195.335  39.301  1.00  0.00           H  
ATOM   1953  HB1 ALA A 122      54.963 194.654  39.215  1.00  0.00           H  
ATOM   1954  HB2 ALA A 122      55.286 196.040  38.147  1.00  0.00           H  
ATOM   1955  HB3 ALA A 122      54.733 196.314  39.816  1.00  0.00           H  
ATOM   1956  N   ALA A 123      52.799 197.986  38.819  1.00  0.00           N  
ATOM   1957  CA  ALA A 123      52.386 199.331  38.459  1.00  0.00           C  
ATOM   1958  C   ALA A 123      53.595 200.267  38.533  1.00  0.00           C  
ATOM   1959  O   ALA A 123      54.722 199.816  38.731  1.00  0.00           O  
ATOM   1960  CB  ALA A 123      51.246 199.778  39.375  1.00  0.00           C  
ATOM   1961  H   ALA A 123      53.130 197.881  39.757  1.00  0.00           H  
ATOM   1962  HA  ALA A 123      52.022 199.303  37.432  1.00  0.00           H  
ATOM   1963  HB1 ALA A 123      51.407 200.814  39.677  1.00  0.00           H  
ATOM   1964  HB2 ALA A 123      50.299 199.698  38.842  1.00  0.00           H  
ATOM   1965  HB3 ALA A 123      51.220 199.143  40.260  1.00  0.00           H  
ATOM   1966  N   LEU A 124      53.318 201.552  38.369  1.00  0.00           N  
ATOM   1967  CA  LEU A 124      54.369 202.555  38.415  1.00  0.00           C  
ATOM   1968  C   LEU A 124      54.234 203.371  39.702  1.00  0.00           C  
ATOM   1969  O   LEU A 124      54.469 202.858  40.795  1.00  0.00           O  
ATOM   1970  CB  LEU A 124      54.355 203.405  37.143  1.00  0.00           C  
ATOM   1971  CG  LEU A 124      52.984 203.913  36.692  1.00  0.00           C  
ATOM   1972  CD1 LEU A 124      53.076 205.348  36.171  1.00  0.00           C  
ATOM   1973  CD2 LEU A 124      52.361 202.968  35.662  1.00  0.00           C  
ATOM   1974  H   LEU A 124      52.399 201.911  38.208  1.00  0.00           H  
ATOM   1975  HA  LEU A 124      55.323 202.028  38.439  1.00  0.00           H  
ATOM   1976  HB2 LEU A 124      55.006 204.265  37.296  1.00  0.00           H  
ATOM   1977  HB3 LEU A 124      54.787 202.818  36.333  1.00  0.00           H  
ATOM   1978  HG  LEU A 124      52.322 203.926  37.557  1.00  0.00           H  
ATOM   1979 HD11 LEU A 124      52.681 205.392  35.155  1.00  0.00           H  
ATOM   1980 HD12 LEU A 124      52.493 206.007  36.815  1.00  0.00           H  
ATOM   1981 HD13 LEU A 124      54.117 205.669  36.171  1.00  0.00           H  
ATOM   1982 HD21 LEU A 124      51.705 203.534  35.000  1.00  0.00           H  
ATOM   1983 HD22 LEU A 124      53.150 202.498  35.076  1.00  0.00           H  
ATOM   1984 HD23 LEU A 124      51.783 202.201  36.176  1.00  0.00           H  
ATOM   1985  N   GLU A 125      53.854 204.630  39.529  1.00  0.00           N  
ATOM   1986  CA  GLU A 125      53.684 205.522  40.664  1.00  0.00           C  
ATOM   1987  C   GLU A 125      53.349 206.935  40.181  1.00  0.00           C  
ATOM   1988  O   GLU A 125      54.146 207.562  39.485  1.00  0.00           O  
ATOM   1989  CB  GLU A 125      54.931 205.526  41.549  1.00  0.00           C  
ATOM   1990  CG  GLU A 125      54.554 205.384  43.026  1.00  0.00           C  
ATOM   1991  CD  GLU A 125      55.797 205.157  43.889  1.00  0.00           C  
ATOM   1992  OE1 GLU A 125      56.349 204.039  43.808  1.00  0.00           O  
ATOM   1993  OE2 GLU A 125      56.168 206.108  44.612  1.00  0.00           O  
ATOM   1994  H   GLU A 125      53.664 205.039  38.637  1.00  0.00           H  
ATOM   1995  HA  GLU A 125      52.845 205.116  41.229  1.00  0.00           H  
ATOM   1996  HB2 GLU A 125      55.591 204.708  41.259  1.00  0.00           H  
ATOM   1997  HB3 GLU A 125      55.486 206.452  41.400  1.00  0.00           H  
ATOM   1998  HG2 GLU A 125      54.034 206.281  43.360  1.00  0.00           H  
ATOM   1999  HG3 GLU A 125      53.864 204.549  43.150  1.00  0.00           H  
ATOM   2000  N   LYS A 126      52.170 207.395  40.572  1.00  0.00           N  
ATOM   2001  CA  LYS A 126      51.721 208.723  40.187  1.00  0.00           C  
ATOM   2002  C   LYS A 126      52.186 209.736  41.234  1.00  0.00           C  
ATOM   2003  O   LYS A 126      52.473 209.371  42.373  1.00  0.00           O  
ATOM   2004  CB  LYS A 126      50.209 208.730  39.955  1.00  0.00           C  
ATOM   2005  CG  LYS A 126      49.512 209.704  40.908  1.00  0.00           C  
ATOM   2006  CD  LYS A 126      48.007 209.755  40.636  1.00  0.00           C  
ATOM   2007  CE  LYS A 126      47.452 211.157  40.891  1.00  0.00           C  
ATOM   2008  NZ  LYS A 126      46.058 211.260  40.402  1.00  0.00           N  
ATOM   2009  H   LYS A 126      51.527 206.879  41.138  1.00  0.00           H  
ATOM   2010  HA  LYS A 126      52.194 208.966  39.236  1.00  0.00           H  
ATOM   2011  HB2 LYS A 126      49.996 209.009  38.924  1.00  0.00           H  
ATOM   2012  HB3 LYS A 126      49.810 207.725  40.100  1.00  0.00           H  
ATOM   2013  HG2 LYS A 126      49.688 209.397  41.939  1.00  0.00           H  
ATOM   2014  HG3 LYS A 126      49.940 210.699  40.793  1.00  0.00           H  
ATOM   2015  HD2 LYS A 126      47.810 209.464  39.603  1.00  0.00           H  
ATOM   2016  HD3 LYS A 126      47.493 209.035  41.273  1.00  0.00           H  
ATOM   2017  HE2 LYS A 126      47.487 211.381  41.957  1.00  0.00           H  
ATOM   2018  HE3 LYS A 126      48.074 211.899  40.389  1.00  0.00           H  
ATOM   2019  HZ1 LYS A 126      45.687 212.158  40.638  1.00  0.00           H  
ATOM   2020  HZ2 LYS A 126      46.043 211.143  39.409  1.00  0.00           H  
ATOM   2021  HZ3 LYS A 126      45.502 210.547  40.830  1.00  0.00           H  
ATOM   2022  N   GLU A 127      52.249 210.990  40.811  1.00  0.00           N  
ATOM   2023  CA  GLU A 127      52.674 212.059  41.697  1.00  0.00           C  
ATOM   2024  C   GLU A 127      52.316 213.421  41.098  1.00  0.00           C  
ATOM   2025  O   GLU A 127      51.886 213.503  39.948  1.00  0.00           O  
ATOM   2026  CB  GLU A 127      54.174 211.966  41.987  1.00  0.00           C  
ATOM   2027  CG  GLU A 127      54.994 212.235  40.723  1.00  0.00           C  
ATOM   2028  CD  GLU A 127      56.174 211.267  40.619  1.00  0.00           C  
ATOM   2029  OE1 GLU A 127      57.094 211.402  41.454  1.00  0.00           O  
ATOM   2030  OE2 GLU A 127      56.128 210.413  39.707  1.00  0.00           O  
ATOM   2031  H   GLU A 127      52.013 211.279  39.882  1.00  0.00           H  
ATOM   2032  HA  GLU A 127      52.122 211.905  42.624  1.00  0.00           H  
ATOM   2033  HB2 GLU A 127      54.444 212.686  42.760  1.00  0.00           H  
ATOM   2034  HB3 GLU A 127      54.412 210.976  42.375  1.00  0.00           H  
ATOM   2035  HG2 GLU A 127      54.358 212.135  39.845  1.00  0.00           H  
ATOM   2036  HG3 GLU A 127      55.362 213.262  40.736  1.00  0.00           H  
ATOM   2037  N   SER A 128      52.504 214.455  41.905  1.00  0.00           N  
ATOM   2038  CA  SER A 128      52.205 215.808  41.469  1.00  0.00           C  
ATOM   2039  C   SER A 128      52.765 216.818  42.473  1.00  0.00           C  
ATOM   2040  O   SER A 128      53.260 216.436  43.532  1.00  0.00           O  
ATOM   2041  CB  SER A 128      50.698 216.011  41.296  1.00  0.00           C  
ATOM   2042  OG  SER A 128      50.037 216.189  42.546  1.00  0.00           O  
ATOM   2043  H   SER A 128      52.854 214.379  42.839  1.00  0.00           H  
ATOM   2044  HA  SER A 128      52.698 215.916  40.503  1.00  0.00           H  
ATOM   2045  HB2 SER A 128      50.519 216.881  40.665  1.00  0.00           H  
ATOM   2046  HB3 SER A 128      50.273 215.151  40.781  1.00  0.00           H  
ATOM   2047  HG  SER A 128      49.282 215.540  42.629  1.00  0.00           H  
ATOM   2048  N   GLY A 129      52.668 218.086  42.105  1.00  0.00           N  
ATOM   2049  CA  GLY A 129      53.158 219.154  42.961  1.00  0.00           C  
ATOM   2050  C   GLY A 129      52.500 220.488  42.606  1.00  0.00           C  
ATOM   2051  O   GLY A 129      52.132 220.716  41.455  1.00  0.00           O  
ATOM   2052  H   GLY A 129      52.264 218.389  41.242  1.00  0.00           H  
ATOM   2053  HA2 GLY A 129      52.958 218.909  44.004  1.00  0.00           H  
ATOM   2054  HA3 GLY A 129      54.240 219.240  42.856  1.00  0.00           H  
ATOM   2055  N   PRO A 130      52.366 221.356  43.645  1.00  0.00           N  
ATOM   2056  CA  PRO A 130      51.757 222.662  43.455  1.00  0.00           C  
ATOM   2057  C   PRO A 130      52.714 223.614  42.736  1.00  0.00           C  
ATOM   2058  O   PRO A 130      53.784 223.203  42.286  1.00  0.00           O  
ATOM   2059  CB  PRO A 130      51.389 223.132  44.853  1.00  0.00           C  
ATOM   2060  CG  PRO A 130      52.219 222.289  45.807  1.00  0.00           C  
ATOM   2061  CD  PRO A 130      52.789 221.119  45.021  1.00  0.00           C  
ATOM   2062  HA  PRO A 130      50.953 222.587  42.865  1.00  0.00           H  
ATOM   2063  HB2 PRO A 130      51.607 224.192  44.977  1.00  0.00           H  
ATOM   2064  HB3 PRO A 130      50.324 223.001  45.041  1.00  0.00           H  
ATOM   2065  HG2 PRO A 130      53.023 222.884  46.241  1.00  0.00           H  
ATOM   2066  HG3 PRO A 130      51.606 221.932  46.633  1.00  0.00           H  
ATOM   2067  HD2 PRO A 130      53.876 221.080  45.101  1.00  0.00           H  
ATOM   2068  HD3 PRO A 130      52.408 220.169  45.395  1.00  0.00           H  
ATOM   2069  N   SER A 131      52.297 224.869  42.650  1.00  0.00           N  
ATOM   2070  CA  SER A 131      53.104 225.882  41.993  1.00  0.00           C  
ATOM   2071  C   SER A 131      53.215 227.121  42.884  1.00  0.00           C  
ATOM   2072  O   SER A 131      54.316 227.538  43.241  1.00  0.00           O  
ATOM   2073  CB  SER A 131      52.517 226.259  40.632  1.00  0.00           C  
ATOM   2074  OG  SER A 131      52.640 225.199  39.687  1.00  0.00           O  
ATOM   2075  H   SER A 131      51.426 225.195  43.018  1.00  0.00           H  
ATOM   2076  HA  SER A 131      54.084 225.425  41.852  1.00  0.00           H  
ATOM   2077  HB2 SER A 131      51.465 226.519  40.750  1.00  0.00           H  
ATOM   2078  HB3 SER A 131      53.023 227.146  40.251  1.00  0.00           H  
ATOM   2079  HG  SER A 131      52.898 224.353  40.152  1.00  0.00           H  
ATOM   2080  N   SER A 132      52.059 227.676  43.218  1.00  0.00           N  
ATOM   2081  CA  SER A 132      52.012 228.858  44.061  1.00  0.00           C  
ATOM   2082  C   SER A 132      52.986 228.707  45.230  1.00  0.00           C  
ATOM   2083  O   SER A 132      53.426 227.601  45.537  1.00  0.00           O  
ATOM   2084  CB  SER A 132      50.594 229.108  44.582  1.00  0.00           C  
ATOM   2085  OG  SER A 132      49.771 229.739  43.605  1.00  0.00           O  
ATOM   2086  H   SER A 132      51.167 227.330  42.924  1.00  0.00           H  
ATOM   2087  HA  SER A 132      52.312 229.684  43.417  1.00  0.00           H  
ATOM   2088  HB2 SER A 132      50.144 228.160  44.877  1.00  0.00           H  
ATOM   2089  HB3 SER A 132      50.640 229.730  45.475  1.00  0.00           H  
ATOM   2090  HG  SER A 132      48.808 229.546  43.793  1.00  0.00           H  
ATOM   2091  N   GLY A 133      53.297 229.836  45.850  1.00  0.00           N  
ATOM   2092  CA  GLY A 133      54.212 229.843  46.979  1.00  0.00           C  
ATOM   2093  C   GLY A 133      55.574 229.271  46.584  1.00  0.00           C  
ATOM   2094  O   GLY A 133      56.612 229.846  46.908  1.00  0.00           O  
ATOM   2095  H   GLY A 133      52.934 230.733  45.594  1.00  0.00           H  
ATOM   2096  HA2 GLY A 133      54.335 230.862  47.345  1.00  0.00           H  
ATOM   2097  HA3 GLY A 133      53.791 229.258  47.797  1.00  0.00           H  
TER    2098      GLY A 133                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
