
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 ( 1167),  selected   78 , name 2d9t_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2d9t_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      Q       6           -
LGA    G     7_A      -       -           -
LGA    K     8_A      G       7          5.185
LGA    V     9_A      D       8          2.709
LGA    W    10_A      L       9          1.842
LGA    K    11_A      I      10          1.943
LGA    P    12_A      V      11          1.133
LGA    G    13_A      S      12          0.486
LGA    D    14_A      M      13          0.402
LGA    E    15_A      R      14          0.476
LGA    C    16_A      I      15          0.418
LGA    F    17_A      L      16          0.421
LGA    A    18_A      G      17          0.535
LGA    L    19_A      K      18          0.291
LGA    Y    20_A      K      19          0.471
LGA    W    21_A      R      20          2.033
LGA    E    22_A      -       -           -
LGA    D    23_A      T      21          0.675
LGA    N    24_A      K      22          1.090
LGA    K    25_A      T      23          0.965
LGA    F    26_A      W      24          1.117
LGA    Y    27_A      X      25          0.665
LGA    R    28_A      K      26          0.514
LGA    A    29_A      G      27          0.775
LGA    E    30_A      T      28          0.902
LGA    V    31_A      L      29          0.562
LGA    E    32_A      I      30          0.725
LGA    A    33_A      A      31          0.107
LGA    L    34_A      I      32          0.492
LGA    H    35_A      Q      33          0.837
LGA    S    36_A      T      34          2.067
LGA    S    37_A      V      35          2.479
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    G    38_A      G      38          3.932
LGA    M    39_A      K      39          2.064
LGA    T    40_A      K      40          1.474
LGA    A    41_A      Y      41          1.410
LGA    V    42_A      K      42          0.792
LGA    V    43_A      V      43          0.464
LGA    K    44_A      K      44          0.521
LGA    F    45_A      F      45          0.484
LGA    T    46_A      D      46          0.561
LGA    D    47_A      N      47          2.084
LGA    Y    48_A      K      48          3.029
LGA    G    49_A      -       -           -
LGA    N    50_A      G      49          1.977
LGA    Y    51_A      K      50          1.107
LGA    E    52_A      S      51          0.693
LGA    E    53_A      L      52          1.183
LGA    V    54_A      L      53          1.053
LGA    L    55_A      S      54          0.891
LGA    L    56_A      G      55          1.063
LGA    S    57_A      N      56          1.375
LGA    N    58_A      X      57          1.330
LGA    I    59_A      I      58          0.917
LGA    K    60_A      A      59          0.767
LGA    P    61_A      Y      60          0.679
LGA    V    62_A      D      61          1.202
LGA    Q    63_A      Y      62          2.326
LGA    T    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    W    67_A      -       -           -
LGA    V    68_A      -       -           -
LGA    R    69_A      -       -           -
LGA    D    70_A      -       -           -
LGA    P    71_A      -       -           -
LGA    N    72_A      -       -           -
LGA    S    73_A      -       -           -
LGA    G    74_A      -       -           -
LGA    P    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    S    77_A      -       -           -
LGA    G    78_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78   62    5.0     54    1.54    11.11     81.834     3.293

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.151487 * X  +  -0.562600 * Y  +  -0.812732 * Z  +  44.362560
  Y_new =   0.948533 * X  +   0.314064 * Y  +  -0.040607 * Z  +  79.136406
  Z_new =   0.278096 * X  +  -0.764751 * Y  +   0.581221 * Z  +  14.098708 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.920918    2.220675  [ DEG:   -52.7647    127.2353 ]
  Theta =  -0.281811   -2.859782  [ DEG:   -16.1466   -163.8534 ]
  Phi   =   1.412427   -1.729165  [ DEG:    80.9261    -99.0739 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d9t_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d9t_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78   62   5.0   54   1.54   11.11  81.834
REMARK  ---------------------------------------------------------- 
MOLECULE 2d9t_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   13-DEC-05   2D9T              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF TUDOR DOMAIN                
TITLE    2 CONTAINING PROTEIN 3 FROM MOUSE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TUDOR DOMAIN-CONTAINING PROTEIN 3;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: TDRD3;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050214-04;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT           
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN           
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   13-JUN-06 2D9T    0                                                
JRNL        AUTH   H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,                  
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF TUDOR              
JRNL        TITL 2 DOMAIN CONTAINING PROTEIN 3 FROM MOUSE                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D9T A    8    67  UNP    Q91W18   TDRD3_MOUSE    553    612             
SEQRES   1 A   78  GLY SER SER GLY SER SER GLY LYS VAL TRP LYS PRO GLY          
SEQRES   2 A   78  ASP GLU CYS PHE ALA LEU TYR TRP GLU ASP ASN LYS PHE          
SEQRES   3 A   78  TYR ARG ALA GLU VAL GLU ALA LEU HIS SER SER GLY MET          
SEQRES   4 A   78  THR ALA VAL VAL LYS PHE THR ASP TYR GLY ASN TYR GLU          
SEQRES   5 A   78  GLU VAL LEU LEU SER ASN ILE LYS PRO VAL GLN THR GLU          
SEQRES   6 A   78  ALA TRP VAL ARG ASP PRO ASN SER GLY PRO SER SER GLY          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      38.679  95.561   2.049  1.00  0.00           N  
ATOM      2  CA  GLY A   1      37.392  95.672   1.388  1.00  0.00           C  
ATOM      3  C   GLY A   1      36.256  95.903   2.364  1.00  0.00           C  
ATOM      4  O   GLY A   1      36.065  97.015   2.855  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      37.427  96.498   0.691  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      37.201  94.761   0.839  1.00  0.00           H  
ATOM      7  H1  GLY A   1      38.721  95.296   2.992  1.00  0.00           H  
ATOM      8  N   SER A   2      35.496  94.848   2.645  1.00  0.00           N  
ATOM      9  CA  SER A   2      34.369  94.941   3.565  1.00  0.00           C  
ATOM     10  C   SER A   2      34.285  93.701   4.448  1.00  0.00           C  
ATOM     11  O   SER A   2      34.263  92.574   3.955  1.00  0.00           O  
ATOM     12  CB  SER A   2      33.062  95.117   2.787  1.00  0.00           C  
ATOM     13  OG  SER A   2      32.917  96.451   2.330  1.00  0.00           O  
ATOM     14  H   SER A   2      35.698  93.987   2.221  1.00  0.00           H  
ATOM     15  HA  SER A   2      34.524  95.807   4.192  1.00  0.00           H  
ATOM     16  HB2 SER A   2      33.062  94.455   1.935  1.00  0.00           H  
ATOM     17  HB3 SER A   2      32.229  94.877   3.431  1.00  0.00           H  
ATOM     18  HG  SER A   2      32.970  97.053   3.076  1.00  0.00           H  
ATOM     19  N   SER A   3      34.238  93.918   5.759  1.00  0.00           N  
ATOM     20  CA  SER A   3      34.160  92.819   6.714  1.00  0.00           C  
ATOM     21  C   SER A   3      32.711  92.521   7.082  1.00  0.00           C  
ATOM     22  O   SER A   3      31.922  93.431   7.333  1.00  0.00           O  
ATOM     23  CB  SER A   3      34.961  93.153   7.974  1.00  0.00           C  
ATOM     24  OG  SER A   3      35.341  91.974   8.664  1.00  0.00           O  
ATOM     25  H   SER A   3      34.260  94.840   6.092  1.00  0.00           H  
ATOM     26  HA  SER A   3      34.589  91.943   6.248  1.00  0.00           H  
ATOM     27  HB2 SER A   3      35.851  93.697   7.700  1.00  0.00           H  
ATOM     28  HB3 SER A   3      34.356  93.760   8.631  1.00  0.00           H  
ATOM     29  HG  SER A   3      35.756  92.211   9.498  1.00  0.00           H  
ATOM     30  N   GLY A   4      32.366  91.236   7.113  1.00  0.00           N  
ATOM     31  CA  GLY A   4      31.013  90.840   7.451  1.00  0.00           C  
ATOM     32  C   GLY A   4      30.276  90.229   6.275  1.00  0.00           C  
ATOM     33  O   GLY A   4      29.225  90.723   5.866  1.00  0.00           O  
ATOM     34  H   GLY A   4      33.037  90.554   6.904  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      31.050  90.118   8.253  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      30.468  91.709   7.788  1.00  0.00           H  
ATOM     37  N   SER A   5      30.830  89.151   5.728  1.00  0.00           N  
ATOM     38  CA  SER A   5      30.221  88.475   4.588  1.00  0.00           C  
ATOM     39  C   SER A   5      30.316  86.960   4.741  1.00  0.00           C  
ATOM     40  O   SER A   5      31.399  86.411   4.946  1.00  0.00           O  
ATOM     41  CB  SER A   5      30.902  88.910   3.288  1.00  0.00           C  
ATOM     42  OG  SER A   5      30.163  88.479   2.158  1.00  0.00           O  
ATOM     43  H   SER A   5      31.668  88.804   6.099  1.00  0.00           H  
ATOM     44  HA  SER A   5      29.180  88.757   4.552  1.00  0.00           H  
ATOM     45  HB2 SER A   5      30.975  89.986   3.266  1.00  0.00           H  
ATOM     46  HB3 SER A   5      31.892  88.481   3.242  1.00  0.00           H  
ATOM     47  HG  SER A   5      30.602  88.774   1.357  1.00  0.00           H  
ATOM     48  N   SER A   6      29.172  86.289   4.643  1.00  0.00           N  
ATOM     49  CA  SER A   6      29.123  84.837   4.775  1.00  0.00           C  
ATOM     50  C   SER A   6      29.668  84.160   3.521  1.00  0.00           C  
ATOM     51  O   SER A   6      29.513  84.666   2.410  1.00  0.00           O  
ATOM     52  CB  SER A   6      27.688  84.377   5.035  1.00  0.00           C  
ATOM     53  OG  SER A   6      26.880  84.549   3.884  1.00  0.00           O  
ATOM     54  H   SER A   6      28.341  86.783   4.480  1.00  0.00           H  
ATOM     55  HA  SER A   6      29.740  84.561   5.617  1.00  0.00           H  
ATOM     56  HB2 SER A   6      27.692  83.330   5.304  1.00  0.00           H  
ATOM     57  HB3 SER A   6      27.268  84.955   5.846  1.00  0.00           H  
ATOM     58  HG  SER A   6      27.335  84.194   3.118  1.00  0.00           H  
ATOM     59  N   GLY A   7      30.307  83.009   3.708  1.00  0.00           N  
ATOM     60  CA  GLY A   7      30.865  82.280   2.585  1.00  0.00           C  
ATOM     61  C   GLY A   7      32.170  81.590   2.932  1.00  0.00           C  
ATOM     62  O   GLY A   7      32.687  81.743   4.040  1.00  0.00           O  
ATOM     63  H   GLY A   7      30.401  82.652   4.616  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      30.153  81.536   2.262  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      31.042  82.970   1.774  1.00  0.00           H  
ATOM     66  N   LYS A   8      32.706  80.827   1.984  1.00  0.00           N  
ATOM     67  CA  LYS A   8      33.957  80.111   2.194  1.00  0.00           C  
ATOM     68  C   LYS A   8      34.613  79.759   0.862  1.00  0.00           C  
ATOM     69  O   LYS A   8      33.997  79.128   0.004  1.00  0.00           O  
ATOM     70  CB  LYS A   8      33.711  78.837   3.006  1.00  0.00           C  
ATOM     71  CG  LYS A   8      34.983  78.090   3.366  1.00  0.00           C  
ATOM     72  CD  LYS A   8      35.777  78.825   4.434  1.00  0.00           C  
ATOM     73  CE  LYS A   8      37.260  78.498   4.347  1.00  0.00           C  
ATOM     74  NZ  LYS A   8      38.105  79.618   4.848  1.00  0.00           N  
ATOM     75  H   LYS A   8      32.247  80.745   1.122  1.00  0.00           H  
ATOM     76  HA  LYS A   8      34.621  80.758   2.748  1.00  0.00           H  
ATOM     77  HB2 LYS A   8      33.201  79.101   3.921  1.00  0.00           H  
ATOM     78  HB3 LYS A   8      33.080  78.175   2.430  1.00  0.00           H  
ATOM     79  HG2 LYS A   8      34.721  77.111   3.739  1.00  0.00           H  
ATOM     80  HG3 LYS A   8      35.593  77.990   2.481  1.00  0.00           H  
ATOM     81  HD2 LYS A   8      35.647  79.887   4.300  1.00  0.00           H  
ATOM     82  HD3 LYS A   8      35.410  78.534   5.407  1.00  0.00           H  
ATOM     83  HE2 LYS A   8      37.457  77.618   4.939  1.00  0.00           H  
ATOM     84  HE3 LYS A   8      37.512  78.302   3.316  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8      37.503  80.400   5.175  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8      38.724  79.965   4.089  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8      38.694  79.294   5.642  1.00  0.00           H  
ATOM     88  N   VAL A   9      35.867  80.170   0.698  1.00  0.00           N  
ATOM     89  CA  VAL A   9      36.606  79.896  -0.528  1.00  0.00           C  
ATOM     90  C   VAL A   9      37.796  78.981  -0.259  1.00  0.00           C  
ATOM     91  O   VAL A   9      38.458  79.095   0.773  1.00  0.00           O  
ATOM     92  CB  VAL A   9      37.110  81.196  -1.182  1.00  0.00           C  
ATOM     93  CG1 VAL A   9      38.038  81.944  -0.238  1.00  0.00           C  
ATOM     94  CG2 VAL A   9      37.807  80.893  -2.500  1.00  0.00           C  
ATOM     95  H   VAL A   9      36.304  80.669   1.419  1.00  0.00           H  
ATOM     96  HA  VAL A   9      35.936  79.406  -1.220  1.00  0.00           H  
ATOM     97  HB  VAL A   9      36.257  81.826  -1.387  1.00  0.00           H  
ATOM     98 HG11 VAL A   9      37.948  81.533   0.756  1.00  0.00           H  
ATOM     99 HG12 VAL A   9      39.058  81.842  -0.579  1.00  0.00           H  
ATOM    100 HG13 VAL A   9      37.768  82.990  -0.220  1.00  0.00           H  
ATOM    101 HG21 VAL A   9      38.874  81.011  -2.378  1.00  0.00           H  
ATOM    102 HG22 VAL A   9      37.589  79.877  -2.798  1.00  0.00           H  
ATOM    103 HG23 VAL A   9      37.453  81.575  -3.260  1.00  0.00           H  
ATOM    104  N   TRP A  10      38.060  78.075  -1.193  1.00  0.00           N  
ATOM    105  CA  TRP A  10      39.172  77.140  -1.057  1.00  0.00           C  
ATOM    106  C   TRP A  10      40.428  77.687  -1.726  1.00  0.00           C  
ATOM    107  O   TRP A  10      40.360  78.606  -2.542  1.00  0.00           O  
ATOM    108  CB  TRP A  10      38.803  75.786  -1.667  1.00  0.00           C  
ATOM    109  CG  TRP A  10      37.673  75.104  -0.957  1.00  0.00           C  
ATOM    110  CD1 TRP A  10      36.434  74.831  -1.463  1.00  0.00           C  
ATOM    111  CD2 TRP A  10      37.678  74.610   0.386  1.00  0.00           C  
ATOM    112  NE1 TRP A  10      35.668  74.197  -0.514  1.00  0.00           N  
ATOM    113  CE2 TRP A  10      36.409  74.049   0.629  1.00  0.00           C  
ATOM    114  CE3 TRP A  10      38.632  74.585   1.408  1.00  0.00           C  
ATOM    115  CZ2 TRP A  10      36.071  73.472   1.850  1.00  0.00           C  
ATOM    116  CZ3 TRP A  10      38.295  74.013   2.620  1.00  0.00           C  
ATOM    117  CH2 TRP A  10      37.024  73.462   2.833  1.00  0.00           C  
ATOM    118  H   TRP A  10      37.496  78.034  -1.994  1.00  0.00           H  
ATOM    119  HA  TRP A  10      39.367  77.009  -0.003  1.00  0.00           H  
ATOM    120  HB2 TRP A  10      38.513  75.929  -2.696  1.00  0.00           H  
ATOM    121  HB3 TRP A  10      39.665  75.135  -1.626  1.00  0.00           H  
ATOM    122  HD1 TRP A  10      36.116  75.084  -2.463  1.00  0.00           H  
ATOM    123  HE1 TRP A  10      34.742  73.899  -0.636  1.00  0.00           H  
ATOM    124  HE3 TRP A  10      39.616  75.004   1.263  1.00  0.00           H  
ATOM    125  HZ2 TRP A  10      35.096  73.044   2.030  1.00  0.00           H  
ATOM    126  HZ3 TRP A  10      39.019  73.984   3.421  1.00  0.00           H  
ATOM    127  HH2 TRP A  10      36.804  73.025   3.795  1.00  0.00           H  
ATOM    128  N   LYS A  11      41.576  77.117  -1.375  1.00  0.00           N  
ATOM    129  CA  LYS A  11      42.849  77.546  -1.942  1.00  0.00           C  
ATOM    130  C   LYS A  11      43.868  76.411  -1.910  1.00  0.00           C  
ATOM    131  O   LYS A  11      43.790  75.497  -1.088  1.00  0.00           O  
ATOM    132  CB  LYS A  11      43.391  78.753  -1.175  1.00  0.00           C  
ATOM    133  CG  LYS A  11      42.305  79.635  -0.583  1.00  0.00           C  
ATOM    134  CD  LYS A  11      42.893  80.823   0.160  1.00  0.00           C  
ATOM    135  CE  LYS A  11      43.730  81.697  -0.762  1.00  0.00           C  
ATOM    136  NZ  LYS A  11      44.227  82.917  -0.069  1.00  0.00           N  
ATOM    137  H   LYS A  11      41.566  76.387  -0.719  1.00  0.00           H  
ATOM    138  HA  LYS A  11      42.676  77.829  -2.969  1.00  0.00           H  
ATOM    139  HB2 LYS A  11      44.018  78.402  -0.370  1.00  0.00           H  
ATOM    140  HB3 LYS A  11      43.985  79.354  -1.848  1.00  0.00           H  
ATOM    141  HG2 LYS A  11      41.674  80.000  -1.380  1.00  0.00           H  
ATOM    142  HG3 LYS A  11      41.714  79.048   0.107  1.00  0.00           H  
ATOM    143  HD2 LYS A  11      42.088  81.417   0.567  1.00  0.00           H  
ATOM    144  HD3 LYS A  11      43.519  80.460   0.963  1.00  0.00           H  
ATOM    145  HE2 LYS A  11      44.574  81.123  -1.113  1.00  0.00           H  
ATOM    146  HE3 LYS A  11      43.122  81.994  -1.604  1.00  0.00           H  
ATOM    147  HZ1 LYS A  11      45.241  82.818   0.146  1.00  0.00           H  
ATOM    148  HZ2 LYS A  11      43.709  83.059   0.822  1.00  0.00           H  
ATOM    149  HZ3 LYS A  11      44.093  83.753  -0.674  1.00  0.00           H  
ATOM    150  N   PRO A  12      44.849  76.469  -2.823  1.00  0.00           N  
ATOM    151  CA  PRO A  12      45.904  75.456  -2.919  1.00  0.00           C  
ATOM    152  C   PRO A  12      46.867  75.509  -1.738  1.00  0.00           C  
ATOM    153  O   PRO A  12      47.772  76.342  -1.700  1.00  0.00           O  
ATOM    154  CB  PRO A  12      46.628  75.819  -4.217  1.00  0.00           C  
ATOM    155  CG  PRO A  12      46.374  77.276  -4.399  1.00  0.00           C  
ATOM    156  CD  PRO A  12      45.004  77.530  -3.833  1.00  0.00           C  
ATOM    157  HA  PRO A  12      45.491  74.461  -3.000  1.00  0.00           H  
ATOM    158  HB2 PRO A  12      47.684  75.612  -4.112  1.00  0.00           H  
ATOM    159  HB3 PRO A  12      46.222  75.243  -5.034  1.00  0.00           H  
ATOM    160  HG2 PRO A  12      47.113  77.847  -3.859  1.00  0.00           H  
ATOM    161  HG3 PRO A  12      46.398  77.524  -5.449  1.00  0.00           H  
ATOM    162  HD2 PRO A  12      44.959  78.507  -3.376  1.00  0.00           H  
ATOM    163  HD3 PRO A  12      44.254  77.438  -4.606  1.00  0.00           H  
ATOM    164  N   GLY A  13      46.666  74.615  -0.774  1.00  0.00           N  
ATOM    165  CA  GLY A  13      47.525  74.578   0.395  1.00  0.00           C  
ATOM    166  C   GLY A  13      46.744  74.657   1.691  1.00  0.00           C  
ATOM    167  O   GLY A  13      47.231  75.196   2.685  1.00  0.00           O  
ATOM    168  H   GLY A  13      45.928  73.976  -0.858  1.00  0.00           H  
ATOM    169  HA2 GLY A  13      48.091  73.658   0.383  1.00  0.00           H  
ATOM    170  HA3 GLY A  13      48.210  75.411   0.350  1.00  0.00           H  
ATOM    171  N   ASP A  14      45.529  74.119   1.682  1.00  0.00           N  
ATOM    172  CA  ASP A  14      44.678  74.131   2.866  1.00  0.00           C  
ATOM    173  C   ASP A  14      44.091  72.748   3.127  1.00  0.00           C  
ATOM    174  O   ASP A  14      43.515  72.129   2.233  1.00  0.00           O  
ATOM    175  CB  ASP A  14      43.553  75.154   2.701  1.00  0.00           C  
ATOM    176  CG  ASP A  14      44.033  76.579   2.892  1.00  0.00           C  
ATOM    177  OD1 ASP A  14      45.011  76.969   2.222  1.00  0.00           O  
ATOM    178  OD2 ASP A  14      43.431  77.304   3.712  1.00  0.00           O  
ATOM    179  H   ASP A  14      45.197  73.704   0.858  1.00  0.00           H  
ATOM    180  HA  ASP A  14      45.288  74.414   3.710  1.00  0.00           H  
ATOM    181  HB2 ASP A  14      43.136  75.064   1.708  1.00  0.00           H  
ATOM    182  HB3 ASP A  14      42.782  74.951   3.430  1.00  0.00           H  
ATOM    183  N   GLU A  15      44.242  72.269   4.358  1.00  0.00           N  
ATOM    184  CA  GLU A  15      43.728  70.957   4.736  1.00  0.00           C  
ATOM    185  C   GLU A  15      42.206  70.979   4.840  1.00  0.00           C  
ATOM    186  O   GLU A  15      41.633  71.819   5.535  1.00  0.00           O  
ATOM    187  CB  GLU A  15      44.335  70.512   6.068  1.00  0.00           C  
ATOM    188  CG  GLU A  15      44.043  71.461   7.218  1.00  0.00           C  
ATOM    189  CD  GLU A  15      45.135  71.456   8.270  1.00  0.00           C  
ATOM    190  OE1 GLU A  15      46.275  71.066   7.939  1.00  0.00           O  
ATOM    191  OE2 GLU A  15      44.852  71.842   9.423  1.00  0.00           O  
ATOM    192  H   GLU A  15      44.711  72.810   5.028  1.00  0.00           H  
ATOM    193  HA  GLU A  15      44.015  70.255   3.968  1.00  0.00           H  
ATOM    194  HB2 GLU A  15      43.941  69.539   6.321  1.00  0.00           H  
ATOM    195  HB3 GLU A  15      45.406  70.437   5.954  1.00  0.00           H  
ATOM    196  HG2 GLU A  15      43.946  72.463   6.826  1.00  0.00           H  
ATOM    197  HG3 GLU A  15      43.114  71.166   7.684  1.00  0.00           H  
ATOM    198  N   CYS A  16      41.559  70.051   4.144  1.00  0.00           N  
ATOM    199  CA  CYS A  16      40.102  69.964   4.156  1.00  0.00           C  
ATOM    200  C   CYS A  16      39.644  68.511   4.077  1.00  0.00           C  
ATOM    201  O   CYS A  16      40.451  67.606   3.863  1.00  0.00           O  
ATOM    202  CB  CYS A  16      39.514  70.761   2.991  1.00  0.00           C  
ATOM    203  SG  CYS A  16      40.018  70.168   1.359  1.00  0.00           S  
ATOM    204  H   CYS A  16      42.071  69.410   3.608  1.00  0.00           H  
ATOM    205  HA  CYS A  16      39.754  70.388   5.085  1.00  0.00           H  
ATOM    206  HB2 CYS A  16      38.436  70.711   3.039  1.00  0.00           H  
ATOM    207  HB3 CYS A  16      39.823  71.792   3.078  1.00  0.00           H  
ATOM    208  HG  CYS A  16      41.338  70.243   1.287  1.00  0.00           H  
ATOM    209  N   PHE A  17      38.346  68.295   4.252  1.00  0.00           N  
ATOM    210  CA  PHE A  17      37.780  66.953   4.203  1.00  0.00           C  
ATOM    211  C   PHE A  17      37.035  66.723   2.891  1.00  0.00           C  
ATOM    212  O   PHE A  17      36.074  67.426   2.579  1.00  0.00           O  
ATOM    213  CB  PHE A  17      36.833  66.731   5.384  1.00  0.00           C  
ATOM    214  CG  PHE A  17      37.528  66.249   6.627  1.00  0.00           C  
ATOM    215  CD1 PHE A  17      38.290  67.118   7.390  1.00  0.00           C  
ATOM    216  CD2 PHE A  17      37.419  64.929   7.030  1.00  0.00           C  
ATOM    217  CE1 PHE A  17      38.932  66.679   8.533  1.00  0.00           C  
ATOM    218  CE2 PHE A  17      38.057  64.483   8.172  1.00  0.00           C  
ATOM    219  CZ  PHE A  17      38.813  65.359   8.924  1.00  0.00           C  
ATOM    220  H   PHE A  17      37.752  69.058   4.418  1.00  0.00           H  
ATOM    221  HA  PHE A  17      38.595  66.248   4.268  1.00  0.00           H  
ATOM    222  HB2 PHE A  17      36.341  67.662   5.621  1.00  0.00           H  
ATOM    223  HB3 PHE A  17      36.093  65.994   5.110  1.00  0.00           H  
ATOM    224  HD1 PHE A  17      38.383  68.151   7.086  1.00  0.00           H  
ATOM    225  HD2 PHE A  17      36.826  64.242   6.441  1.00  0.00           H  
ATOM    226  HE1 PHE A  17      39.521  67.365   9.120  1.00  0.00           H  
ATOM    227  HE2 PHE A  17      37.962  63.451   8.475  1.00  0.00           H  
ATOM    228  HZ  PHE A  17      39.313  65.013   9.818  1.00  0.00           H  
ATOM    229  N   ALA A  18      37.488  65.736   2.125  1.00  0.00           N  
ATOM    230  CA  ALA A  18      36.864  65.412   0.848  1.00  0.00           C  
ATOM    231  C   ALA A  18      36.203  64.038   0.891  1.00  0.00           C  
ATOM    232  O   ALA A  18      36.727  63.106   1.502  1.00  0.00           O  
ATOM    233  CB  ALA A  18      37.893  65.470  -0.271  1.00  0.00           C  
ATOM    234  H   ALA A  18      38.258  65.211   2.427  1.00  0.00           H  
ATOM    235  HA  ALA A  18      36.108  66.158   0.647  1.00  0.00           H  
ATOM    236  HB1 ALA A  18      37.388  65.440  -1.226  1.00  0.00           H  
ATOM    237  HB2 ALA A  18      38.459  66.386  -0.193  1.00  0.00           H  
ATOM    238  HB3 ALA A  18      38.560  64.625  -0.190  1.00  0.00           H  
ATOM    239  N   LEU A  19      35.051  63.921   0.241  1.00  0.00           N  
ATOM    240  CA  LEU A  19      34.319  62.660   0.205  1.00  0.00           C  
ATOM    241  C   LEU A  19      34.927  61.704  -0.816  1.00  0.00           C  
ATOM    242  O   LEU A  19      34.915  61.974  -2.018  1.00  0.00           O  
ATOM    243  CB  LEU A  19      32.847  62.911  -0.128  1.00  0.00           C  
ATOM    244  CG  LEU A  19      31.845  61.920   0.465  1.00  0.00           C  
ATOM    245  CD1 LEU A  19      31.730  62.111   1.968  1.00  0.00           C  
ATOM    246  CD2 LEU A  19      30.485  62.075  -0.200  1.00  0.00           C  
ATOM    247  H   LEU A  19      34.684  64.699  -0.228  1.00  0.00           H  
ATOM    248  HA  LEU A  19      34.385  62.210   1.185  1.00  0.00           H  
ATOM    249  HB2 LEU A  19      32.589  63.896   0.233  1.00  0.00           H  
ATOM    250  HB3 LEU A  19      32.743  62.886  -1.204  1.00  0.00           H  
ATOM    251  HG  LEU A  19      32.195  60.913   0.283  1.00  0.00           H  
ATOM    252 HD11 LEU A  19      30.719  62.392   2.219  1.00  0.00           H  
ATOM    253 HD12 LEU A  19      32.409  62.889   2.285  1.00  0.00           H  
ATOM    254 HD13 LEU A  19      31.983  61.188   2.469  1.00  0.00           H  
ATOM    255 HD21 LEU A  19      30.601  62.592  -1.142  1.00  0.00           H  
ATOM    256 HD22 LEU A  19      29.831  62.644   0.445  1.00  0.00           H  
ATOM    257 HD23 LEU A  19      30.057  61.099  -0.376  1.00  0.00           H  
ATOM    258  N   TYR A  20      35.456  60.587  -0.331  1.00  0.00           N  
ATOM    259  CA  TYR A  20      36.069  59.591  -1.202  1.00  0.00           C  
ATOM    260  C   TYR A  20      35.127  59.208  -2.339  1.00  0.00           C  
ATOM    261  O   TYR A  20      33.907  59.313  -2.212  1.00  0.00           O  
ATOM    262  CB  TYR A  20      36.450  58.346  -0.399  1.00  0.00           C  
ATOM    263  CG  TYR A  20      37.598  57.566  -0.998  1.00  0.00           C  
ATOM    264  CD1 TYR A  20      38.744  58.212  -1.445  1.00  0.00           C  
ATOM    265  CD2 TYR A  20      37.537  56.182  -1.117  1.00  0.00           C  
ATOM    266  CE1 TYR A  20      39.795  57.503  -1.995  1.00  0.00           C  
ATOM    267  CE2 TYR A  20      38.584  55.466  -1.664  1.00  0.00           C  
ATOM    268  CZ  TYR A  20      39.711  56.131  -2.101  1.00  0.00           C  
ATOM    269  OH  TYR A  20      40.756  55.422  -2.645  1.00  0.00           O  
ATOM    270  H   TYR A  20      35.435  60.428   0.635  1.00  0.00           H  
ATOM    271  HA  TYR A  20      36.966  60.024  -1.621  1.00  0.00           H  
ATOM    272  HB2 TYR A  20      36.736  58.642   0.598  1.00  0.00           H  
ATOM    273  HB3 TYR A  20      35.595  57.688  -0.342  1.00  0.00           H  
ATOM    274  HD1 TYR A  20      38.806  59.287  -1.360  1.00  0.00           H  
ATOM    275  HD2 TYR A  20      36.653  55.665  -0.773  1.00  0.00           H  
ATOM    276  HE1 TYR A  20      40.677  58.023  -2.336  1.00  0.00           H  
ATOM    277  HE2 TYR A  20      38.519  54.391  -1.748  1.00  0.00           H  
ATOM    278  HH  TYR A  20      41.480  56.020  -2.843  1.00  0.00           H  
ATOM    279  N   TRP A  21      35.703  58.764  -3.450  1.00  0.00           N  
ATOM    280  CA  TRP A  21      34.917  58.365  -4.613  1.00  0.00           C  
ATOM    281  C   TRP A  21      34.600  56.874  -4.568  1.00  0.00           C  
ATOM    282  O   TRP A  21      33.871  56.361  -5.417  1.00  0.00           O  
ATOM    283  CB  TRP A  21      35.666  58.701  -5.902  1.00  0.00           C  
ATOM    284  CG  TRP A  21      36.909  57.886  -6.097  1.00  0.00           C  
ATOM    285  CD1 TRP A  21      38.176  58.218  -5.709  1.00  0.00           C  
ATOM    286  CD2 TRP A  21      37.004  56.606  -6.729  1.00  0.00           C  
ATOM    287  NE1 TRP A  21      39.052  57.221  -6.062  1.00  0.00           N  
ATOM    288  CE2 TRP A  21      38.358  56.219  -6.688  1.00  0.00           C  
ATOM    289  CE3 TRP A  21      36.076  55.745  -7.324  1.00  0.00           C  
ATOM    290  CZ2 TRP A  21      38.804  55.013  -7.221  1.00  0.00           C  
ATOM    291  CZ3 TRP A  21      36.521  54.549  -7.853  1.00  0.00           C  
ATOM    292  CH2 TRP A  21      37.874  54.191  -7.797  1.00  0.00           C  
ATOM    293  H   TRP A  21      36.681  58.703  -3.491  1.00  0.00           H  
ATOM    294  HA  TRP A  21      33.990  58.918  -4.590  1.00  0.00           H  
ATOM    295  HB2 TRP A  21      35.016  58.524  -6.745  1.00  0.00           H  
ATOM    296  HB3 TRP A  21      35.950  59.743  -5.883  1.00  0.00           H  
ATOM    297  HD1 TRP A  21      38.436  59.134  -5.202  1.00  0.00           H  
ATOM    298  HE1 TRP A  21      40.017  57.225  -5.891  1.00  0.00           H  
ATOM    299  HE3 TRP A  21      35.028  56.004  -7.376  1.00  0.00           H  
ATOM    300  HZ2 TRP A  21      39.844  54.723  -7.186  1.00  0.00           H  
ATOM    301  HZ3 TRP A  21      35.818  53.872  -8.317  1.00  0.00           H  
ATOM    302  HH2 TRP A  21      38.176  53.247  -8.223  1.00  0.00           H  
ATOM    303  N   GLU A  22      35.152  56.184  -3.574  1.00  0.00           N  
ATOM    304  CA  GLU A  22      34.927  54.752  -3.422  1.00  0.00           C  
ATOM    305  C   GLU A  22      34.340  54.436  -2.049  1.00  0.00           C  
ATOM    306  O   GLU A  22      33.853  53.331  -1.810  1.00  0.00           O  
ATOM    307  CB  GLU A  22      36.236  53.984  -3.619  1.00  0.00           C  
ATOM    308  CG  GLU A  22      36.512  53.613  -5.066  1.00  0.00           C  
ATOM    309  CD  GLU A  22      37.405  52.395  -5.196  1.00  0.00           C  
ATOM    310  OE1 GLU A  22      38.501  52.395  -4.597  1.00  0.00           O  
ATOM    311  OE2 GLU A  22      37.008  51.441  -5.897  1.00  0.00           O  
ATOM    312  H   GLU A  22      35.724  56.650  -2.929  1.00  0.00           H  
ATOM    313  HA  GLU A  22      34.223  54.444  -4.180  1.00  0.00           H  
ATOM    314  HB2 GLU A  22      37.053  54.592  -3.262  1.00  0.00           H  
ATOM    315  HB3 GLU A  22      36.195  53.074  -3.038  1.00  0.00           H  
ATOM    316  HG2 GLU A  22      35.573  53.406  -5.557  1.00  0.00           H  
ATOM    317  HG3 GLU A  22      36.994  54.448  -5.553  1.00  0.00           H  
ATOM    318  N   ASP A  23      34.394  55.413  -1.151  1.00  0.00           N  
ATOM    319  CA  ASP A  23      33.868  55.241   0.198  1.00  0.00           C  
ATOM    320  C   ASP A  23      32.768  56.258   0.487  1.00  0.00           C  
ATOM    321  O   ASP A  23      31.958  56.070   1.394  1.00  0.00           O  
ATOM    322  CB  ASP A  23      34.992  55.380   1.228  1.00  0.00           C  
ATOM    323  CG  ASP A  23      34.599  54.839   2.588  1.00  0.00           C  
ATOM    324  OD1 ASP A  23      33.459  55.102   3.026  1.00  0.00           O  
ATOM    325  OD2 ASP A  23      35.431  54.152   3.216  1.00  0.00           O  
ATOM    326  H   ASP A  23      34.795  56.272  -1.402  1.00  0.00           H  
ATOM    327  HA  ASP A  23      33.449  54.248   0.267  1.00  0.00           H  
ATOM    328  HB2 ASP A  23      35.857  54.835   0.881  1.00  0.00           H  
ATOM    329  HB3 ASP A  23      35.246  56.423   1.335  1.00  0.00           H  
ATOM    330  N   ASN A  24      32.747  57.336  -0.291  1.00  0.00           N  
ATOM    331  CA  ASN A  24      31.747  58.384  -0.117  1.00  0.00           C  
ATOM    332  C   ASN A  24      31.711  58.866   1.329  1.00  0.00           C  
ATOM    333  O   ASN A  24      30.682  59.341   1.812  1.00  0.00           O  
ATOM    334  CB  ASN A  24      30.366  57.873  -0.532  1.00  0.00           C  
ATOM    335  CG  ASN A  24      29.742  56.976   0.519  1.00  0.00           C  
ATOM    336  OD1 ASN A  24      29.224  57.452   1.530  1.00  0.00           O  
ATOM    337  ND2 ASN A  24      29.789  55.670   0.285  1.00  0.00           N  
ATOM    338  H   ASN A  24      33.419  57.429  -0.998  1.00  0.00           H  
ATOM    339  HA  ASN A  24      32.022  59.212  -0.753  1.00  0.00           H  
ATOM    340  HB2 ASN A  24      29.711  58.717  -0.693  1.00  0.00           H  
ATOM    341  HB3 ASN A  24      30.456  57.313  -1.450  1.00  0.00           H  
ATOM    342 HD21 ASN A  24      30.217  55.362  -0.541  1.00  0.00           H  
ATOM    343 HD22 ASN A  24      29.391  55.067   0.949  1.00  0.00           H  
ATOM    344  N   LYS A  25      32.840  58.741   2.019  1.00  0.00           N  
ATOM    345  CA  LYS A  25      32.939  59.165   3.410  1.00  0.00           C  
ATOM    346  C   LYS A  25      33.891  60.348   3.552  1.00  0.00           C  
ATOM    347  O   LYS A  25      34.873  60.459   2.818  1.00  0.00           O  
ATOM    348  CB  LYS A  25      33.417  58.004   4.285  1.00  0.00           C  
ATOM    349  CG  LYS A  25      32.317  57.021   4.646  1.00  0.00           C  
ATOM    350  CD  LYS A  25      31.447  57.546   5.775  1.00  0.00           C  
ATOM    351  CE  LYS A  25      30.353  56.556   6.143  1.00  0.00           C  
ATOM    352  NZ  LYS A  25      29.444  57.097   7.191  1.00  0.00           N  
ATOM    353  H   LYS A  25      33.627  58.354   1.580  1.00  0.00           H  
ATOM    354  HA  LYS A  25      31.955  59.469   3.735  1.00  0.00           H  
ATOM    355  HB2 LYS A  25      34.193  57.468   3.760  1.00  0.00           H  
ATOM    356  HB3 LYS A  25      33.826  58.406   5.202  1.00  0.00           H  
ATOM    357  HG2 LYS A  25      31.698  56.853   3.778  1.00  0.00           H  
ATOM    358  HG3 LYS A  25      32.767  56.088   4.954  1.00  0.00           H  
ATOM    359  HD2 LYS A  25      32.065  57.720   6.643  1.00  0.00           H  
ATOM    360  HD3 LYS A  25      30.990  58.475   5.463  1.00  0.00           H  
ATOM    361  HE2 LYS A  25      29.776  56.332   5.258  1.00  0.00           H  
ATOM    362  HE3 LYS A  25      30.813  55.651   6.510  1.00  0.00           H  
ATOM    363  HZ1 LYS A  25      29.668  58.096   7.376  1.00  0.00           H  
ATOM    364  HZ2 LYS A  25      29.556  56.559   8.074  1.00  0.00           H  
ATOM    365  HZ3 LYS A  25      28.455  57.026   6.877  1.00  0.00           H  
ATOM    366  N   PHE A  26      33.596  61.230   4.501  1.00  0.00           N  
ATOM    367  CA  PHE A  26      34.426  62.404   4.739  1.00  0.00           C  
ATOM    368  C   PHE A  26      35.775  62.006   5.331  1.00  0.00           C  
ATOM    369  O   PHE A  26      35.846  61.476   6.440  1.00  0.00           O  
ATOM    370  CB  PHE A  26      33.712  63.378   5.679  1.00  0.00           C  
ATOM    371  CG  PHE A  26      32.587  64.127   5.024  1.00  0.00           C  
ATOM    372  CD1 PHE A  26      32.806  64.860   3.868  1.00  0.00           C  
ATOM    373  CD2 PHE A  26      31.312  64.098   5.562  1.00  0.00           C  
ATOM    374  CE1 PHE A  26      31.773  65.551   3.264  1.00  0.00           C  
ATOM    375  CE2 PHE A  26      30.274  64.787   4.962  1.00  0.00           C  
ATOM    376  CZ  PHE A  26      30.505  65.514   3.810  1.00  0.00           C  
ATOM    377  H   PHE A  26      32.799  61.086   5.055  1.00  0.00           H  
ATOM    378  HA  PHE A  26      34.592  62.889   3.790  1.00  0.00           H  
ATOM    379  HB2 PHE A  26      33.302  62.827   6.512  1.00  0.00           H  
ATOM    380  HB3 PHE A  26      34.425  64.100   6.046  1.00  0.00           H  
ATOM    381  HD1 PHE A  26      33.797  64.889   3.439  1.00  0.00           H  
ATOM    382  HD2 PHE A  26      31.129  63.530   6.463  1.00  0.00           H  
ATOM    383  HE1 PHE A  26      31.957  66.118   2.363  1.00  0.00           H  
ATOM    384  HE2 PHE A  26      29.284  64.756   5.392  1.00  0.00           H  
ATOM    385  HZ  PHE A  26      29.697  66.053   3.339  1.00  0.00           H  
ATOM    386  N   TYR A  27      36.842  62.265   4.584  1.00  0.00           N  
ATOM    387  CA  TYR A  27      38.189  61.932   5.031  1.00  0.00           C  
ATOM    388  C   TYR A  27      39.119  63.134   4.902  1.00  0.00           C  
ATOM    389  O   TYR A  27      38.932  63.988   4.035  1.00  0.00           O  
ATOM    390  CB  TYR A  27      38.741  60.756   4.224  1.00  0.00           C  
ATOM    391  CG  TYR A  27      37.961  59.474   4.410  1.00  0.00           C  
ATOM    392  CD1 TYR A  27      37.520  59.082   5.668  1.00  0.00           C  
ATOM    393  CD2 TYR A  27      37.664  58.656   3.327  1.00  0.00           C  
ATOM    394  CE1 TYR A  27      36.808  57.912   5.842  1.00  0.00           C  
ATOM    395  CE2 TYR A  27      36.951  57.483   3.492  1.00  0.00           C  
ATOM    396  CZ  TYR A  27      36.525  57.116   4.751  1.00  0.00           C  
ATOM    397  OH  TYR A  27      35.815  55.949   4.920  1.00  0.00           O  
ATOM    398  H   TYR A  27      36.721  62.690   3.708  1.00  0.00           H  
ATOM    399  HA  TYR A  27      38.131  61.645   6.072  1.00  0.00           H  
ATOM    400  HB2 TYR A  27      38.720  61.007   3.175  1.00  0.00           H  
ATOM    401  HB3 TYR A  27      39.762  60.570   4.524  1.00  0.00           H  
ATOM    402  HD1 TYR A  27      37.742  59.708   6.520  1.00  0.00           H  
ATOM    403  HD2 TYR A  27      37.998  58.946   2.341  1.00  0.00           H  
ATOM    404  HE1 TYR A  27      36.474  57.623   6.828  1.00  0.00           H  
ATOM    405  HE2 TYR A  27      36.729  56.860   2.638  1.00  0.00           H  
ATOM    406  HH  TYR A  27      34.948  56.153   5.281  1.00  0.00           H  
ATOM    407  N   ARG A  28      40.124  63.192   5.771  1.00  0.00           N  
ATOM    408  CA  ARG A  28      41.084  64.289   5.755  1.00  0.00           C  
ATOM    409  C   ARG A  28      41.728  64.429   4.378  1.00  0.00           C  
ATOM    410  O   ARG A  28      41.860  63.452   3.642  1.00  0.00           O  
ATOM    411  CB  ARG A  28      42.165  64.064   6.814  1.00  0.00           C  
ATOM    412  CG  ARG A  28      42.926  65.326   7.186  1.00  0.00           C  
ATOM    413  CD  ARG A  28      42.246  66.070   8.325  1.00  0.00           C  
ATOM    414  NE  ARG A  28      43.103  67.109   8.889  1.00  0.00           N  
ATOM    415  CZ  ARG A  28      44.215  66.853   9.568  1.00  0.00           C  
ATOM    416  NH1 ARG A  28      44.604  65.601   9.766  1.00  0.00           N  
ATOM    417  NH2 ARG A  28      44.943  67.852  10.051  1.00  0.00           N  
ATOM    418  H   ARG A  28      40.221  62.481   6.438  1.00  0.00           H  
ATOM    419  HA  ARG A  28      40.552  65.200   5.985  1.00  0.00           H  
ATOM    420  HB2 ARG A  28      41.701  63.672   7.707  1.00  0.00           H  
ATOM    421  HB3 ARG A  28      42.873  63.340   6.440  1.00  0.00           H  
ATOM    422  HG2 ARG A  28      43.925  65.056   7.494  1.00  0.00           H  
ATOM    423  HG3 ARG A  28      42.975  65.973   6.323  1.00  0.00           H  
ATOM    424  HD2 ARG A  28      41.342  66.527   7.948  1.00  0.00           H  
ATOM    425  HD3 ARG A  28      41.994  65.362   9.100  1.00  0.00           H  
ATOM    426  HE  ARG A  28      42.835  68.041   8.755  1.00  0.00           H  
ATOM    427 HH11 ARG A  28      44.058  64.846   9.402  1.00  0.00           H  
ATOM    428 HH12 ARG A  28      45.443  65.412  10.277  1.00  0.00           H  
ATOM    429 HH21 ARG A  28      44.654  68.799   9.904  1.00  0.00           H  
ATOM    430 HH22 ARG A  28      45.780  67.660  10.562  1.00  0.00           H  
ATOM    431  N   ALA A  29      42.124  65.650   4.038  1.00  0.00           N  
ATOM    432  CA  ALA A  29      42.754  65.919   2.751  1.00  0.00           C  
ATOM    433  C   ALA A  29      43.316  67.335   2.698  1.00  0.00           C  
ATOM    434  O   ALA A  29      43.268  68.068   3.687  1.00  0.00           O  
ATOM    435  CB  ALA A  29      41.758  65.701   1.621  1.00  0.00           C  
ATOM    436  H   ALA A  29      41.990  66.390   4.667  1.00  0.00           H  
ATOM    437  HA  ALA A  29      43.565  65.216   2.623  1.00  0.00           H  
ATOM    438  HB1 ALA A  29      41.253  64.757   1.763  1.00  0.00           H  
ATOM    439  HB2 ALA A  29      41.033  66.501   1.621  1.00  0.00           H  
ATOM    440  HB3 ALA A  29      42.283  65.691   0.677  1.00  0.00           H  
ATOM    441  N   GLU A  30      43.849  67.714   1.541  1.00  0.00           N  
ATOM    442  CA  GLU A  30      44.421  69.043   1.363  1.00  0.00           C  
ATOM    443  C   GLU A  30      44.211  69.538  -0.066  1.00  0.00           C  
ATOM    444  O   GLU A  30      44.593  68.872  -1.028  1.00  0.00           O  
ATOM    445  CB  GLU A  30      45.914  69.028   1.695  1.00  0.00           C  
ATOM    446  CG  GLU A  30      46.635  70.309   1.311  1.00  0.00           C  
ATOM    447  CD  GLU A  30      47.029  70.342  -0.152  1.00  0.00           C  
ATOM    448  OE1 GLU A  30      47.194  69.255  -0.747  1.00  0.00           O  
ATOM    449  OE2 GLU A  30      47.172  71.453  -0.704  1.00  0.00           O  
ATOM    450  H   GLU A  30      43.857  67.085   0.789  1.00  0.00           H  
ATOM    451  HA  GLU A  30      43.917  69.715   2.041  1.00  0.00           H  
ATOM    452  HB2 GLU A  30      46.033  68.876   2.757  1.00  0.00           H  
ATOM    453  HB3 GLU A  30      46.379  68.207   1.169  1.00  0.00           H  
ATOM    454  HG2 GLU A  30      45.986  71.147   1.513  1.00  0.00           H  
ATOM    455  HG3 GLU A  30      47.530  70.397   1.911  1.00  0.00           H  
ATOM    456  N   VAL A  31      43.601  70.712  -0.195  1.00  0.00           N  
ATOM    457  CA  VAL A  31      43.340  71.298  -1.505  1.00  0.00           C  
ATOM    458  C   VAL A  31      44.622  71.402  -2.325  1.00  0.00           C  
ATOM    459  O   VAL A  31      45.420  72.319  -2.132  1.00  0.00           O  
ATOM    460  CB  VAL A  31      42.709  72.697  -1.377  1.00  0.00           C  
ATOM    461  CG1 VAL A  31      42.585  73.353  -2.745  1.00  0.00           C  
ATOM    462  CG2 VAL A  31      41.354  72.611  -0.693  1.00  0.00           C  
ATOM    463  H   VAL A  31      43.320  71.196   0.609  1.00  0.00           H  
ATOM    464  HA  VAL A  31      42.643  70.657  -2.025  1.00  0.00           H  
ATOM    465  HB  VAL A  31      43.358  73.309  -0.768  1.00  0.00           H  
ATOM    466 HG11 VAL A  31      41.802  74.096  -2.717  1.00  0.00           H  
ATOM    467 HG12 VAL A  31      43.522  73.824  -3.005  1.00  0.00           H  
ATOM    468 HG13 VAL A  31      42.341  72.602  -3.482  1.00  0.00           H  
ATOM    469 HG21 VAL A  31      41.402  73.110   0.263  1.00  0.00           H  
ATOM    470 HG22 VAL A  31      40.606  73.086  -1.311  1.00  0.00           H  
ATOM    471 HG23 VAL A  31      41.091  71.574  -0.545  1.00  0.00           H  
ATOM    472  N   GLU A  32      44.810  70.458  -3.241  1.00  0.00           N  
ATOM    473  CA  GLU A  32      45.995  70.444  -4.089  1.00  0.00           C  
ATOM    474  C   GLU A  32      45.939  71.569  -5.119  1.00  0.00           C  
ATOM    475  O   GLU A  32      46.888  72.341  -5.262  1.00  0.00           O  
ATOM    476  CB  GLU A  32      46.125  69.094  -4.801  1.00  0.00           C  
ATOM    477  CG  GLU A  32      47.540  68.779  -5.254  1.00  0.00           C  
ATOM    478  CD  GLU A  32      48.013  69.693  -6.368  1.00  0.00           C  
ATOM    479  OE1 GLU A  32      47.163  70.160  -7.155  1.00  0.00           O  
ATOM    480  OE2 GLU A  32      49.233  69.943  -6.453  1.00  0.00           O  
ATOM    481  H   GLU A  32      44.136  69.753  -3.347  1.00  0.00           H  
ATOM    482  HA  GLU A  32      46.858  70.591  -3.458  1.00  0.00           H  
ATOM    483  HB2 GLU A  32      45.803  68.314  -4.127  1.00  0.00           H  
ATOM    484  HB3 GLU A  32      45.483  69.096  -5.669  1.00  0.00           H  
ATOM    485  HG2 GLU A  32      48.207  68.888  -4.413  1.00  0.00           H  
ATOM    486  HG3 GLU A  32      47.573  67.759  -5.608  1.00  0.00           H  
ATOM    487  N   ALA A  33      44.823  71.656  -5.834  1.00  0.00           N  
ATOM    488  CA  ALA A  33      44.643  72.686  -6.849  1.00  0.00           C  
ATOM    489  C   ALA A  33      43.188  72.768  -7.297  1.00  0.00           C  
ATOM    490  O   ALA A  33      42.547  71.746  -7.550  1.00  0.00           O  
ATOM    491  CB  ALA A  33      45.550  72.419  -8.040  1.00  0.00           C  
ATOM    492  H   ALA A  33      44.102  71.011  -5.674  1.00  0.00           H  
ATOM    493  HA  ALA A  33      44.929  73.634  -6.415  1.00  0.00           H  
ATOM    494  HB1 ALA A  33      45.443  73.217  -8.759  1.00  0.00           H  
ATOM    495  HB2 ALA A  33      46.576  72.368  -7.707  1.00  0.00           H  
ATOM    496  HB3 ALA A  33      45.274  71.481  -8.499  1.00  0.00           H  
ATOM    497  N   LEU A  34      42.670  73.987  -7.392  1.00  0.00           N  
ATOM    498  CA  LEU A  34      41.289  74.202  -7.809  1.00  0.00           C  
ATOM    499  C   LEU A  34      41.155  74.098  -9.325  1.00  0.00           C  
ATOM    500  O   LEU A  34      42.154  74.043 -10.044  1.00  0.00           O  
ATOM    501  CB  LEU A  34      40.799  75.571  -7.335  1.00  0.00           C  
ATOM    502  CG  LEU A  34      41.006  75.883  -5.852  1.00  0.00           C  
ATOM    503  CD1 LEU A  34      41.112  77.384  -5.632  1.00  0.00           C  
ATOM    504  CD2 LEU A  34      39.872  75.299  -5.022  1.00  0.00           C  
ATOM    505  H   LEU A  34      43.229  74.762  -7.176  1.00  0.00           H  
ATOM    506  HA  LEU A  34      40.682  73.434  -7.352  1.00  0.00           H  
ATOM    507  HB2 LEU A  34      41.320  76.324  -7.907  1.00  0.00           H  
ATOM    508  HB3 LEU A  34      39.741  75.634  -7.543  1.00  0.00           H  
ATOM    509  HG  LEU A  34      41.931  75.431  -5.522  1.00  0.00           H  
ATOM    510 HD11 LEU A  34      40.729  77.632  -4.654  1.00  0.00           H  
ATOM    511 HD12 LEU A  34      40.537  77.900  -6.386  1.00  0.00           H  
ATOM    512 HD13 LEU A  34      42.147  77.685  -5.700  1.00  0.00           H  
ATOM    513 HD21 LEU A  34      40.279  74.629  -4.279  1.00  0.00           H  
ATOM    514 HD22 LEU A  34      39.198  74.754  -5.667  1.00  0.00           H  
ATOM    515 HD23 LEU A  34      39.336  76.098  -4.532  1.00  0.00           H  
ATOM    516  N   HIS A  35      39.916  74.073  -9.804  1.00  0.00           N  
ATOM    517  CA  HIS A  35      39.651  73.978 -11.235  1.00  0.00           C  
ATOM    518  C   HIS A  35      39.212  75.326 -11.797  1.00  0.00           C  
ATOM    519  O   HIS A  35      38.302  75.963 -11.266  1.00  0.00           O  
ATOM    520  CB  HIS A  35      38.578  72.923 -11.508  1.00  0.00           C  
ATOM    521  CG  HIS A  35      38.358  72.656 -12.965  1.00  0.00           C  
ATOM    522  ND1 HIS A  35      37.126  72.334 -13.494  1.00  0.00           N  
ATOM    523  CD2 HIS A  35      39.222  72.667 -14.008  1.00  0.00           C  
ATOM    524  CE1 HIS A  35      37.242  72.156 -14.798  1.00  0.00           C  
ATOM    525  NE2 HIS A  35      38.504  72.353 -15.135  1.00  0.00           N  
ATOM    526  H   HIS A  35      39.162  74.120  -9.181  1.00  0.00           H  
ATOM    527  HA  HIS A  35      40.567  73.681 -11.723  1.00  0.00           H  
ATOM    528  HB2 HIS A  35      38.869  71.994 -11.041  1.00  0.00           H  
ATOM    529  HB3 HIS A  35      37.641  73.256 -11.086  1.00  0.00           H  
ATOM    530  HD1 HIS A  35      36.292  72.246 -12.989  1.00  0.00           H  
ATOM    531  HD2 HIS A  35      40.280  72.882 -13.962  1.00  0.00           H  
ATOM    532  HE1 HIS A  35      36.442  71.894 -15.474  1.00  0.00           H  
ATOM    533  HE2 HIS A  35      38.880  72.200 -16.027  1.00  0.00           H  
ATOM    534  N   SER A  36      39.863  75.755 -12.873  1.00  0.00           N  
ATOM    535  CA  SER A  36      39.542  77.031 -13.504  1.00  0.00           C  
ATOM    536  C   SER A  36      38.032  77.247 -13.553  1.00  0.00           C  
ATOM    537  O   SER A  36      37.527  78.276 -13.104  1.00  0.00           O  
ATOM    538  CB  SER A  36      40.122  77.084 -14.919  1.00  0.00           C  
ATOM    539  OG  SER A  36      39.412  76.227 -15.794  1.00  0.00           O  
ATOM    540  H   SER A  36      40.579  75.202 -13.250  1.00  0.00           H  
ATOM    541  HA  SER A  36      39.987  77.814 -12.911  1.00  0.00           H  
ATOM    542  HB2 SER A  36      40.058  78.094 -15.292  1.00  0.00           H  
ATOM    543  HB3 SER A  36      41.157  76.775 -14.892  1.00  0.00           H  
ATOM    544  HG  SER A  36      39.811  75.354 -15.782  1.00  0.00           H  
ATOM    545  N   SER A  37      37.318  76.269 -14.102  1.00  0.00           N  
ATOM    546  CA  SER A  37      35.867  76.354 -14.214  1.00  0.00           C  
ATOM    547  C   SER A  37      35.248  76.842 -12.907  1.00  0.00           C  
ATOM    548  O   SER A  37      34.544  77.850 -12.880  1.00  0.00           O  
ATOM    549  CB  SER A  37      35.283  74.990 -14.589  1.00  0.00           C  
ATOM    550  OG  SER A  37      35.634  74.632 -15.914  1.00  0.00           O  
ATOM    551  H   SER A  37      37.779  75.474 -14.442  1.00  0.00           H  
ATOM    552  HA  SER A  37      35.635  77.062 -14.995  1.00  0.00           H  
ATOM    553  HB2 SER A  37      35.665  74.240 -13.914  1.00  0.00           H  
ATOM    554  HB3 SER A  37      34.206  75.029 -14.512  1.00  0.00           H  
ATOM    555  HG  SER A  37      35.809  75.427 -16.425  1.00  0.00           H  
ATOM    556  N   GLY A  38      35.517  76.118 -11.825  1.00  0.00           N  
ATOM    557  CA  GLY A  38      34.980  76.493 -10.530  1.00  0.00           C  
ATOM    558  C   GLY A  38      33.925  75.523 -10.037  1.00  0.00           C  
ATOM    559  O   GLY A  38      32.889  75.933  -9.517  1.00  0.00           O  
ATOM    560  H   GLY A  38      36.085  75.324 -11.907  1.00  0.00           H  
ATOM    561  HA2 GLY A  38      35.788  76.525  -9.813  1.00  0.00           H  
ATOM    562  HA3 GLY A  38      34.540  77.476 -10.607  1.00  0.00           H  
ATOM    563  N   MET A  39      34.189  74.230 -10.203  1.00  0.00           N  
ATOM    564  CA  MET A  39      33.253  73.198  -9.772  1.00  0.00           C  
ATOM    565  C   MET A  39      33.970  72.111  -8.979  1.00  0.00           C  
ATOM    566  O   MET A  39      33.618  71.826  -7.834  1.00  0.00           O  
ATOM    567  CB  MET A  39      32.546  72.583 -10.981  1.00  0.00           C  
ATOM    568  CG  MET A  39      31.361  73.398 -11.473  1.00  0.00           C  
ATOM    569  SD  MET A  39      29.815  72.930 -10.671  1.00  0.00           S  
ATOM    570  CE  MET A  39      29.135  71.801 -11.883  1.00  0.00           C  
ATOM    571  H   MET A  39      35.032  73.963 -10.625  1.00  0.00           H  
ATOM    572  HA  MET A  39      32.517  73.665  -9.135  1.00  0.00           H  
ATOM    573  HB2 MET A  39      33.255  72.494 -11.791  1.00  0.00           H  
ATOM    574  HB3 MET A  39      32.191  71.598 -10.713  1.00  0.00           H  
ATOM    575  HG2 MET A  39      31.551  74.442 -11.272  1.00  0.00           H  
ATOM    576  HG3 MET A  39      31.258  73.251 -12.537  1.00  0.00           H  
ATOM    577  HE1 MET A  39      28.066  71.726 -11.745  1.00  0.00           H  
ATOM    578  HE2 MET A  39      29.344  72.171 -12.876  1.00  0.00           H  
ATOM    579  HE3 MET A  39      29.583  70.827 -11.759  1.00  0.00           H  
ATOM    580  N   THR A  40      34.980  71.503  -9.596  1.00  0.00           N  
ATOM    581  CA  THR A  40      35.746  70.446  -8.949  1.00  0.00           C  
ATOM    582  C   THR A  40      37.164  70.907  -8.637  1.00  0.00           C  
ATOM    583  O   THR A  40      37.639  71.902  -9.184  1.00  0.00           O  
ATOM    584  CB  THR A  40      35.811  69.182  -9.826  1.00  0.00           C  
ATOM    585  OG1 THR A  40      36.211  69.528 -11.156  1.00  0.00           O  
ATOM    586  CG2 THR A  40      34.461  68.480  -9.864  1.00  0.00           C  
ATOM    587  H   THR A  40      35.213  71.773 -10.508  1.00  0.00           H  
ATOM    588  HA  THR A  40      35.249  70.192  -8.024  1.00  0.00           H  
ATOM    589  HB  THR A  40      36.541  68.505  -9.403  1.00  0.00           H  
ATOM    590  HG1 THR A  40      36.197  68.744 -11.710  1.00  0.00           H  
ATOM    591 HG21 THR A  40      34.281  67.996  -8.917  1.00  0.00           H  
ATOM    592 HG22 THR A  40      34.463  67.741 -10.652  1.00  0.00           H  
ATOM    593 HG23 THR A  40      33.685  69.205 -10.051  1.00  0.00           H  
ATOM    594  N   ALA A  41      37.839  70.177  -7.754  1.00  0.00           N  
ATOM    595  CA  ALA A  41      39.205  70.510  -7.372  1.00  0.00           C  
ATOM    596  C   ALA A  41      39.986  69.260  -6.977  1.00  0.00           C  
ATOM    597  O   ALA A  41      39.412  68.291  -6.480  1.00  0.00           O  
ATOM    598  CB  ALA A  41      39.203  71.516  -6.230  1.00  0.00           C  
ATOM    599  H   ALA A  41      37.407  69.394  -7.352  1.00  0.00           H  
ATOM    600  HA  ALA A  41      39.688  70.969  -8.223  1.00  0.00           H  
ATOM    601  HB1 ALA A  41      38.708  71.084  -5.373  1.00  0.00           H  
ATOM    602  HB2 ALA A  41      40.220  71.768  -5.970  1.00  0.00           H  
ATOM    603  HB3 ALA A  41      38.679  72.408  -6.538  1.00  0.00           H  
ATOM    604  N   VAL A  42      41.295  69.290  -7.202  1.00  0.00           N  
ATOM    605  CA  VAL A  42      42.153  68.159  -6.870  1.00  0.00           C  
ATOM    606  C   VAL A  42      42.605  68.222  -5.415  1.00  0.00           C  
ATOM    607  O   VAL A  42      43.366  69.109  -5.027  1.00  0.00           O  
ATOM    608  CB  VAL A  42      43.395  68.111  -7.780  1.00  0.00           C  
ATOM    609  CG1 VAL A  42      44.242  66.887  -7.463  1.00  0.00           C  
ATOM    610  CG2 VAL A  42      42.983  68.119  -9.243  1.00  0.00           C  
ATOM    611  H   VAL A  42      41.693  70.091  -7.601  1.00  0.00           H  
ATOM    612  HA  VAL A  42      41.585  67.253  -7.022  1.00  0.00           H  
ATOM    613  HB  VAL A  42      43.990  68.992  -7.590  1.00  0.00           H  
ATOM    614 HG11 VAL A  42      43.964  66.499  -6.494  1.00  0.00           H  
ATOM    615 HG12 VAL A  42      44.079  66.131  -8.216  1.00  0.00           H  
ATOM    616 HG13 VAL A  42      45.286  67.166  -7.452  1.00  0.00           H  
ATOM    617 HG21 VAL A  42      41.919  67.950  -9.318  1.00  0.00           H  
ATOM    618 HG22 VAL A  42      43.226  69.076  -9.682  1.00  0.00           H  
ATOM    619 HG23 VAL A  42      43.509  67.338  -9.771  1.00  0.00           H  
ATOM    620  N   VAL A  43      42.132  67.273  -4.612  1.00  0.00           N  
ATOM    621  CA  VAL A  43      42.489  67.218  -3.200  1.00  0.00           C  
ATOM    622  C   VAL A  43      43.277  65.953  -2.880  1.00  0.00           C  
ATOM    623  O   VAL A  43      42.945  64.865  -3.351  1.00  0.00           O  
ATOM    624  CB  VAL A  43      41.238  67.271  -2.303  1.00  0.00           C  
ATOM    625  CG1 VAL A  43      40.414  68.513  -2.608  1.00  0.00           C  
ATOM    626  CG2 VAL A  43      40.404  66.011  -2.478  1.00  0.00           C  
ATOM    627  H   VAL A  43      41.531  66.592  -4.980  1.00  0.00           H  
ATOM    628  HA  VAL A  43      43.103  68.079  -2.977  1.00  0.00           H  
ATOM    629  HB  VAL A  43      41.560  67.324  -1.274  1.00  0.00           H  
ATOM    630 HG11 VAL A  43      39.703  68.289  -3.389  1.00  0.00           H  
ATOM    631 HG12 VAL A  43      39.888  68.823  -1.718  1.00  0.00           H  
ATOM    632 HG13 VAL A  43      41.068  69.308  -2.935  1.00  0.00           H  
ATOM    633 HG21 VAL A  43      39.372  66.284  -2.648  1.00  0.00           H  
ATOM    634 HG22 VAL A  43      40.772  65.451  -3.325  1.00  0.00           H  
ATOM    635 HG23 VAL A  43      40.475  65.405  -1.588  1.00  0.00           H  
ATOM    636  N   LYS A  44      44.325  66.103  -2.077  1.00  0.00           N  
ATOM    637  CA  LYS A  44      45.162  64.973  -1.692  1.00  0.00           C  
ATOM    638  C   LYS A  44      44.668  64.349  -0.390  1.00  0.00           C  
ATOM    639  O   LYS A  44      44.506  65.037   0.617  1.00  0.00           O  
ATOM    640  CB  LYS A  44      46.617  65.418  -1.535  1.00  0.00           C  
ATOM    641  CG  LYS A  44      47.587  64.268  -1.328  1.00  0.00           C  
ATOM    642  CD  LYS A  44      49.017  64.682  -1.635  1.00  0.00           C  
ATOM    643  CE  LYS A  44      50.020  63.768  -0.949  1.00  0.00           C  
ATOM    644  NZ  LYS A  44      50.120  64.049   0.510  1.00  0.00           N  
ATOM    645  H   LYS A  44      44.541  66.996  -1.734  1.00  0.00           H  
ATOM    646  HA  LYS A  44      45.103  64.234  -2.476  1.00  0.00           H  
ATOM    647  HB2 LYS A  44      46.913  65.956  -2.424  1.00  0.00           H  
ATOM    648  HB3 LYS A  44      46.689  66.080  -0.684  1.00  0.00           H  
ATOM    649  HG2 LYS A  44      47.531  63.942  -0.300  1.00  0.00           H  
ATOM    650  HG3 LYS A  44      47.310  63.454  -1.982  1.00  0.00           H  
ATOM    651  HD2 LYS A  44      49.175  64.636  -2.701  1.00  0.00           H  
ATOM    652  HD3 LYS A  44      49.171  65.694  -1.289  1.00  0.00           H  
ATOM    653  HE2 LYS A  44      49.710  62.745  -1.090  1.00  0.00           H  
ATOM    654  HE3 LYS A  44      50.990  63.915  -1.403  1.00  0.00           H  
ATOM    655  HZ1 LYS A  44      50.575  64.971   0.665  1.00  0.00           H  
ATOM    656  HZ2 LYS A  44      50.687  63.313   0.977  1.00  0.00           H  
ATOM    657  HZ3 LYS A  44      49.172  64.065   0.937  1.00  0.00           H  
ATOM    658  N   PHE A  45      44.432  63.042  -0.418  1.00  0.00           N  
ATOM    659  CA  PHE A  45      43.956  62.325   0.760  1.00  0.00           C  
ATOM    660  C   PHE A  45      45.125  61.885   1.637  1.00  0.00           C  
ATOM    661  O   PHE A  45      46.066  61.248   1.163  1.00  0.00           O  
ATOM    662  CB  PHE A  45      43.129  61.107   0.343  1.00  0.00           C  
ATOM    663  CG  PHE A  45      41.686  61.426   0.071  1.00  0.00           C  
ATOM    664  CD1 PHE A  45      40.843  61.809   1.102  1.00  0.00           C  
ATOM    665  CD2 PHE A  45      41.175  61.344  -1.213  1.00  0.00           C  
ATOM    666  CE1 PHE A  45      39.514  62.104   0.854  1.00  0.00           C  
ATOM    667  CE2 PHE A  45      39.848  61.638  -1.466  1.00  0.00           C  
ATOM    668  CZ  PHE A  45      39.017  62.018  -0.430  1.00  0.00           C  
ATOM    669  H   PHE A  45      44.579  62.547  -1.251  1.00  0.00           H  
ATOM    670  HA  PHE A  45      43.331  62.998   1.326  1.00  0.00           H  
ATOM    671  HB2 PHE A  45      43.551  60.685  -0.557  1.00  0.00           H  
ATOM    672  HB3 PHE A  45      43.164  60.370   1.131  1.00  0.00           H  
ATOM    673  HD1 PHE A  45      41.231  61.877   2.108  1.00  0.00           H  
ATOM    674  HD2 PHE A  45      41.824  61.046  -2.024  1.00  0.00           H  
ATOM    675  HE1 PHE A  45      38.867  62.401   1.667  1.00  0.00           H  
ATOM    676  HE2 PHE A  45      39.462  61.569  -2.472  1.00  0.00           H  
ATOM    677  HZ  PHE A  45      37.980  62.248  -0.625  1.00  0.00           H  
ATOM    678  N   THR A  46      45.059  62.229   2.919  1.00  0.00           N  
ATOM    679  CA  THR A  46      46.110  61.872   3.862  1.00  0.00           C  
ATOM    680  C   THR A  46      46.157  60.364   4.089  1.00  0.00           C  
ATOM    681  O   THR A  46      47.229  59.787   4.268  1.00  0.00           O  
ATOM    682  CB  THR A  46      45.912  62.576   5.218  1.00  0.00           C  
ATOM    683  OG1 THR A  46      47.152  62.616   5.933  1.00  0.00           O  
ATOM    684  CG2 THR A  46      44.862  61.860   6.052  1.00  0.00           C  
ATOM    685  H   THR A  46      44.282  62.736   3.237  1.00  0.00           H  
ATOM    686  HA  THR A  46      47.054  62.193   3.446  1.00  0.00           H  
ATOM    687  HB  THR A  46      45.578  63.588   5.034  1.00  0.00           H  
ATOM    688  HG1 THR A  46      47.144  63.356   6.546  1.00  0.00           H  
ATOM    689 HG21 THR A  46      43.912  61.889   5.537  1.00  0.00           H  
ATOM    690 HG22 THR A  46      44.768  62.351   7.009  1.00  0.00           H  
ATOM    691 HG23 THR A  46      45.160  60.834   6.201  1.00  0.00           H  
ATOM    692  N   ASP A  47      44.988  59.733   4.077  1.00  0.00           N  
ATOM    693  CA  ASP A  47      44.896  58.291   4.280  1.00  0.00           C  
ATOM    694  C   ASP A  47      46.101  57.579   3.671  1.00  0.00           C  
ATOM    695  O   ASP A  47      46.711  56.718   4.306  1.00  0.00           O  
ATOM    696  CB  ASP A  47      43.605  57.750   3.665  1.00  0.00           C  
ATOM    697  CG  ASP A  47      42.368  58.246   4.389  1.00  0.00           C  
ATOM    698  OD1 ASP A  47      42.406  58.340   5.634  1.00  0.00           O  
ATOM    699  OD2 ASP A  47      41.361  58.539   3.709  1.00  0.00           O  
ATOM    700  H   ASP A  47      44.167  60.248   3.929  1.00  0.00           H  
ATOM    701  HA  ASP A  47      44.883  58.106   5.343  1.00  0.00           H  
ATOM    702  HB2 ASP A  47      43.545  58.064   2.633  1.00  0.00           H  
ATOM    703  HB3 ASP A  47      43.618  56.671   3.709  1.00  0.00           H  
ATOM    704  N   TYR A  48      46.437  57.944   2.440  1.00  0.00           N  
ATOM    705  CA  TYR A  48      47.566  57.338   1.745  1.00  0.00           C  
ATOM    706  C   TYR A  48      48.450  58.405   1.107  1.00  0.00           C  
ATOM    707  O   TYR A  48      49.676  58.306   1.127  1.00  0.00           O  
ATOM    708  CB  TYR A  48      47.070  56.364   0.675  1.00  0.00           C  
ATOM    709  CG  TYR A  48      45.913  55.504   1.128  1.00  0.00           C  
ATOM    710  CD1 TYR A  48      46.132  54.299   1.784  1.00  0.00           C  
ATOM    711  CD2 TYR A  48      44.599  55.896   0.900  1.00  0.00           C  
ATOM    712  CE1 TYR A  48      45.077  53.509   2.200  1.00  0.00           C  
ATOM    713  CE2 TYR A  48      43.538  55.114   1.313  1.00  0.00           C  
ATOM    714  CZ  TYR A  48      43.782  53.922   1.962  1.00  0.00           C  
ATOM    715  OH  TYR A  48      42.728  53.138   2.375  1.00  0.00           O  
ATOM    716  H   TYR A  48      45.913  58.636   1.985  1.00  0.00           H  
ATOM    717  HA  TYR A  48      48.149  56.791   2.471  1.00  0.00           H  
ATOM    718  HB2 TYR A  48      46.748  56.923  -0.190  1.00  0.00           H  
ATOM    719  HB3 TYR A  48      47.880  55.708   0.391  1.00  0.00           H  
ATOM    720  HD1 TYR A  48      47.147  53.979   1.968  1.00  0.00           H  
ATOM    721  HD2 TYR A  48      44.411  56.830   0.391  1.00  0.00           H  
ATOM    722  HE1 TYR A  48      45.267  52.576   2.708  1.00  0.00           H  
ATOM    723  HE2 TYR A  48      42.524  55.436   1.127  1.00  0.00           H  
ATOM    724  HH  TYR A  48      42.549  52.469   1.711  1.00  0.00           H  
ATOM    725  N   GLY A  49      47.817  59.428   0.541  1.00  0.00           N  
ATOM    726  CA  GLY A  49      48.559  60.501  -0.095  1.00  0.00           C  
ATOM    727  C   GLY A  49      48.362  60.531  -1.598  1.00  0.00           C  
ATOM    728  O   GLY A  49      49.281  60.860  -2.345  1.00  0.00           O  
ATOM    729  H   GLY A  49      46.837  59.455   0.555  1.00  0.00           H  
ATOM    730  HA2 GLY A  49      48.236  61.443   0.320  1.00  0.00           H  
ATOM    731  HA3 GLY A  49      49.611  60.368   0.115  1.00  0.00           H  
ATOM    732  N   ASN A  50      47.156  60.187  -2.041  1.00  0.00           N  
ATOM    733  CA  ASN A  50      46.841  60.174  -3.465  1.00  0.00           C  
ATOM    734  C   ASN A  50      45.845  61.276  -3.811  1.00  0.00           C  
ATOM    735  O   ASN A  50      45.001  61.645  -2.993  1.00  0.00           O  
ATOM    736  CB  ASN A  50      46.274  58.813  -3.871  1.00  0.00           C  
ATOM    737  CG  ASN A  50      45.266  58.284  -2.870  1.00  0.00           C  
ATOM    738  OD1 ASN A  50      45.564  57.378  -2.091  1.00  0.00           O  
ATOM    739  ND2 ASN A  50      44.065  58.851  -2.885  1.00  0.00           N  
ATOM    740  H   ASN A  50      46.464  59.935  -1.396  1.00  0.00           H  
ATOM    741  HA  ASN A  50      47.757  60.350  -4.009  1.00  0.00           H  
ATOM    742  HB2 ASN A  50      45.787  58.905  -4.831  1.00  0.00           H  
ATOM    743  HB3 ASN A  50      47.084  58.102  -3.950  1.00  0.00           H  
ATOM    744 HD21 ASN A  50      43.898  59.567  -3.533  1.00  0.00           H  
ATOM    745 HD22 ASN A  50      43.394  58.528  -2.248  1.00  0.00           H  
ATOM    746  N   TYR A  51      45.949  61.799  -5.028  1.00  0.00           N  
ATOM    747  CA  TYR A  51      45.058  62.861  -5.482  1.00  0.00           C  
ATOM    748  C   TYR A  51      43.739  62.285  -5.990  1.00  0.00           C  
ATOM    749  O   TYR A  51      43.702  61.188  -6.545  1.00  0.00           O  
ATOM    750  CB  TYR A  51      45.728  63.680  -6.585  1.00  0.00           C  
ATOM    751  CG  TYR A  51      47.076  64.239  -6.191  1.00  0.00           C  
ATOM    752  CD1 TYR A  51      47.198  65.128  -5.130  1.00  0.00           C  
ATOM    753  CD2 TYR A  51      48.228  63.877  -6.878  1.00  0.00           C  
ATOM    754  CE1 TYR A  51      48.428  65.641  -4.767  1.00  0.00           C  
ATOM    755  CE2 TYR A  51      49.463  64.385  -6.520  1.00  0.00           C  
ATOM    756  CZ  TYR A  51      49.557  65.267  -5.464  1.00  0.00           C  
ATOM    757  OH  TYR A  51      50.785  65.775  -5.104  1.00  0.00           O  
ATOM    758  H   TYR A  51      46.641  61.464  -5.635  1.00  0.00           H  
ATOM    759  HA  TYR A  51      44.855  63.507  -4.640  1.00  0.00           H  
ATOM    760  HB2 TYR A  51      45.870  63.055  -7.453  1.00  0.00           H  
ATOM    761  HB3 TYR A  51      45.088  64.511  -6.847  1.00  0.00           H  
ATOM    762  HD1 TYR A  51      46.312  65.419  -4.586  1.00  0.00           H  
ATOM    763  HD2 TYR A  51      48.151  63.186  -7.704  1.00  0.00           H  
ATOM    764  HE1 TYR A  51      48.503  66.333  -3.939  1.00  0.00           H  
ATOM    765  HE2 TYR A  51      50.348  64.091  -7.067  1.00  0.00           H  
ATOM    766  HH  TYR A  51      51.108  66.353  -5.799  1.00  0.00           H  
ATOM    767  N   GLU A  52      42.659  63.035  -5.796  1.00  0.00           N  
ATOM    768  CA  GLU A  52      41.338  62.600  -6.233  1.00  0.00           C  
ATOM    769  C   GLU A  52      40.479  63.794  -6.641  1.00  0.00           C  
ATOM    770  O   GLU A  52      40.447  64.812  -5.951  1.00  0.00           O  
ATOM    771  CB  GLU A  52      40.641  61.812  -5.123  1.00  0.00           C  
ATOM    772  CG  GLU A  52      41.006  60.337  -5.102  1.00  0.00           C  
ATOM    773  CD  GLU A  52      40.696  59.642  -6.413  1.00  0.00           C  
ATOM    774  OE1 GLU A  52      39.646  59.953  -7.016  1.00  0.00           O  
ATOM    775  OE2 GLU A  52      41.499  58.786  -6.837  1.00  0.00           O  
ATOM    776  H   GLU A  52      42.753  63.902  -5.347  1.00  0.00           H  
ATOM    777  HA  GLU A  52      41.468  61.957  -7.091  1.00  0.00           H  
ATOM    778  HB2 GLU A  52      40.912  62.242  -4.169  1.00  0.00           H  
ATOM    779  HB3 GLU A  52      39.573  61.896  -5.254  1.00  0.00           H  
ATOM    780  HG2 GLU A  52      42.063  60.243  -4.905  1.00  0.00           H  
ATOM    781  HG3 GLU A  52      40.449  59.853  -4.314  1.00  0.00           H  
ATOM    782  N   GLU A  53      39.786  63.660  -7.767  1.00  0.00           N  
ATOM    783  CA  GLU A  53      38.928  64.728  -8.268  1.00  0.00           C  
ATOM    784  C   GLU A  53      37.589  64.737  -7.536  1.00  0.00           C  
ATOM    785  O   GLU A  53      36.743  63.870  -7.757  1.00  0.00           O  
ATOM    786  CB  GLU A  53      38.700  64.568  -9.771  1.00  0.00           C  
ATOM    787  CG  GLU A  53      38.016  65.763 -10.415  1.00  0.00           C  
ATOM    788  CD  GLU A  53      37.894  65.624 -11.919  1.00  0.00           C  
ATOM    789  OE1 GLU A  53      38.804  65.033 -12.537  1.00  0.00           O  
ATOM    790  OE2 GLU A  53      36.888  66.108 -12.481  1.00  0.00           O  
ATOM    791  H   GLU A  53      39.854  62.824  -8.274  1.00  0.00           H  
ATOM    792  HA  GLU A  53      39.429  65.667  -8.087  1.00  0.00           H  
ATOM    793  HB2 GLU A  53      39.654  64.421 -10.255  1.00  0.00           H  
ATOM    794  HB3 GLU A  53      38.085  63.695  -9.938  1.00  0.00           H  
ATOM    795  HG2 GLU A  53      37.026  65.862  -9.996  1.00  0.00           H  
ATOM    796  HG3 GLU A  53      38.590  66.650 -10.195  1.00  0.00           H  
ATOM    797  N   VAL A  54      37.403  65.723  -6.664  1.00  0.00           N  
ATOM    798  CA  VAL A  54      36.168  65.847  -5.900  1.00  0.00           C  
ATOM    799  C   VAL A  54      35.569  67.241  -6.045  1.00  0.00           C  
ATOM    800  O   VAL A  54      36.293  68.226  -6.196  1.00  0.00           O  
ATOM    801  CB  VAL A  54      36.399  65.551  -4.407  1.00  0.00           C  
ATOM    802  CG1 VAL A  54      35.098  65.135  -3.737  1.00  0.00           C  
ATOM    803  CG2 VAL A  54      37.462  64.477  -4.235  1.00  0.00           C  
ATOM    804  H   VAL A  54      38.114  66.384  -6.532  1.00  0.00           H  
ATOM    805  HA  VAL A  54      35.464  65.122  -6.285  1.00  0.00           H  
ATOM    806  HB  VAL A  54      36.750  66.455  -3.932  1.00  0.00           H  
ATOM    807 HG11 VAL A  54      34.676  65.982  -3.216  1.00  0.00           H  
ATOM    808 HG12 VAL A  54      34.402  64.788  -4.487  1.00  0.00           H  
ATOM    809 HG13 VAL A  54      35.294  64.342  -3.031  1.00  0.00           H  
ATOM    810 HG21 VAL A  54      38.431  64.944  -4.139  1.00  0.00           H  
ATOM    811 HG22 VAL A  54      37.252  63.899  -3.347  1.00  0.00           H  
ATOM    812 HG23 VAL A  54      37.460  63.826  -5.097  1.00  0.00           H  
ATOM    813  N   LEU A  55      34.244  67.318  -5.998  1.00  0.00           N  
ATOM    814  CA  LEU A  55      33.546  68.593  -6.122  1.00  0.00           C  
ATOM    815  C   LEU A  55      33.799  69.474  -4.903  1.00  0.00           C  
ATOM    816  O   LEU A  55      34.023  68.975  -3.799  1.00  0.00           O  
ATOM    817  CB  LEU A  55      32.044  68.360  -6.295  1.00  0.00           C  
ATOM    818  CG  LEU A  55      31.549  68.215  -7.734  1.00  0.00           C  
ATOM    819  CD1 LEU A  55      30.287  67.368  -7.781  1.00  0.00           C  
ATOM    820  CD2 LEU A  55      31.298  69.582  -8.354  1.00  0.00           C  
ATOM    821  H   LEU A  55      33.721  66.499  -5.876  1.00  0.00           H  
ATOM    822  HA  LEU A  55      33.928  69.094  -6.999  1.00  0.00           H  
ATOM    823  HB2 LEU A  55      31.786  67.458  -5.763  1.00  0.00           H  
ATOM    824  HB3 LEU A  55      31.527  69.199  -5.849  1.00  0.00           H  
ATOM    825  HG  LEU A  55      32.307  67.714  -8.320  1.00  0.00           H  
ATOM    826 HD11 LEU A  55      29.855  67.418  -8.769  1.00  0.00           H  
ATOM    827 HD12 LEU A  55      29.577  67.739  -7.058  1.00  0.00           H  
ATOM    828 HD13 LEU A  55      30.534  66.342  -7.548  1.00  0.00           H  
ATOM    829 HD21 LEU A  55      30.936  70.259  -7.595  1.00  0.00           H  
ATOM    830 HD22 LEU A  55      30.560  69.493  -9.137  1.00  0.00           H  
ATOM    831 HD23 LEU A  55      32.220  69.964  -8.768  1.00  0.00           H  
ATOM    832  N   LEU A  56      33.760  70.785  -5.108  1.00  0.00           N  
ATOM    833  CA  LEU A  56      33.982  71.736  -4.025  1.00  0.00           C  
ATOM    834  C   LEU A  56      32.812  71.731  -3.046  1.00  0.00           C  
ATOM    835  O   LEU A  56      32.973  72.054  -1.870  1.00  0.00           O  
ATOM    836  CB  LEU A  56      34.183  73.144  -4.589  1.00  0.00           C  
ATOM    837  CG  LEU A  56      35.449  73.361  -5.418  1.00  0.00           C  
ATOM    838  CD1 LEU A  56      35.410  74.716  -6.107  1.00  0.00           C  
ATOM    839  CD2 LEU A  56      36.687  73.241  -4.541  1.00  0.00           C  
ATOM    840  H   LEU A  56      33.575  71.123  -6.010  1.00  0.00           H  
ATOM    841  HA  LEU A  56      34.876  71.437  -3.499  1.00  0.00           H  
ATOM    842  HB2 LEU A  56      33.335  73.374  -5.215  1.00  0.00           H  
ATOM    843  HB3 LEU A  56      34.209  73.833  -3.756  1.00  0.00           H  
ATOM    844  HG  LEU A  56      35.506  72.599  -6.183  1.00  0.00           H  
ATOM    845 HD11 LEU A  56      34.399  75.093  -6.103  1.00  0.00           H  
ATOM    846 HD12 LEU A  56      35.752  74.611  -7.126  1.00  0.00           H  
ATOM    847 HD13 LEU A  56      36.055  75.406  -5.582  1.00  0.00           H  
ATOM    848 HD21 LEU A  56      36.388  73.132  -3.510  1.00  0.00           H  
ATOM    849 HD22 LEU A  56      37.291  74.131  -4.648  1.00  0.00           H  
ATOM    850 HD23 LEU A  56      37.261  72.378  -4.843  1.00  0.00           H  
ATOM    851  N   SER A  57      31.636  71.359  -3.540  1.00  0.00           N  
ATOM    852  CA  SER A  57      30.438  71.312  -2.710  1.00  0.00           C  
ATOM    853  C   SER A  57      30.456  70.089  -1.798  1.00  0.00           C  
ATOM    854  O   SER A  57      29.572  69.912  -0.962  1.00  0.00           O  
ATOM    855  CB  SER A  57      29.184  71.290  -3.586  1.00  0.00           C  
ATOM    856  OG  SER A  57      29.055  72.494  -4.324  1.00  0.00           O  
ATOM    857  H   SER A  57      31.571  71.113  -4.487  1.00  0.00           H  
ATOM    858  HA  SER A  57      30.424  72.202  -2.098  1.00  0.00           H  
ATOM    859  HB2 SER A  57      29.247  70.463  -4.278  1.00  0.00           H  
ATOM    860  HB3 SER A  57      28.313  71.170  -2.960  1.00  0.00           H  
ATOM    861  HG  SER A  57      28.983  72.290  -5.258  1.00  0.00           H  
ATOM    862  N   ASN A  58      31.473  69.249  -1.966  1.00  0.00           N  
ATOM    863  CA  ASN A  58      31.608  68.042  -1.160  1.00  0.00           C  
ATOM    864  C   ASN A  58      32.841  68.120  -0.265  1.00  0.00           C  
ATOM    865  O   ASN A  58      33.411  67.097   0.115  1.00  0.00           O  
ATOM    866  CB  ASN A  58      31.695  66.808  -2.060  1.00  0.00           C  
ATOM    867  CG  ASN A  58      30.459  66.632  -2.920  1.00  0.00           C  
ATOM    868  OD1 ASN A  58      29.459  67.327  -2.740  1.00  0.00           O  
ATOM    869  ND2 ASN A  58      30.522  65.697  -3.863  1.00  0.00           N  
ATOM    870  H   ASN A  58      32.148  69.445  -2.649  1.00  0.00           H  
ATOM    871  HA  ASN A  58      30.731  67.960  -0.536  1.00  0.00           H  
ATOM    872  HB2 ASN A  58      32.552  66.906  -2.711  1.00  0.00           H  
ATOM    873  HB3 ASN A  58      31.813  65.929  -1.446  1.00  0.00           H  
ATOM    874 HD21 ASN A  58      31.351  65.182  -3.948  1.00  0.00           H  
ATOM    875 HD22 ASN A  58      29.737  65.563  -4.433  1.00  0.00           H  
ATOM    876  N   ILE A  59      33.247  69.341   0.067  1.00  0.00           N  
ATOM    877  CA  ILE A  59      34.413  69.553   0.918  1.00  0.00           C  
ATOM    878  C   ILE A  59      34.053  70.384   2.144  1.00  0.00           C  
ATOM    879  O   ILE A  59      33.231  71.298   2.070  1.00  0.00           O  
ATOM    880  CB  ILE A  59      35.549  70.254   0.151  1.00  0.00           C  
ATOM    881  CG1 ILE A  59      35.585  69.775  -1.302  1.00  0.00           C  
ATOM    882  CG2 ILE A  59      36.885  69.996   0.833  1.00  0.00           C  
ATOM    883  CD1 ILE A  59      36.859  70.144  -2.028  1.00  0.00           C  
ATOM    884  H   ILE A  59      32.753  70.117  -0.268  1.00  0.00           H  
ATOM    885  HA  ILE A  59      34.767  68.586   1.243  1.00  0.00           H  
ATOM    886  HB  ILE A  59      35.363  71.317   0.169  1.00  0.00           H  
ATOM    887 HG12 ILE A  59      35.491  68.701  -1.322  1.00  0.00           H  
ATOM    888 HG13 ILE A  59      34.757  70.216  -1.838  1.00  0.00           H  
ATOM    889 HG21 ILE A  59      36.789  70.176   1.893  1.00  0.00           H  
ATOM    890 HG22 ILE A  59      37.180  68.970   0.668  1.00  0.00           H  
ATOM    891 HG23 ILE A  59      37.633  70.657   0.421  1.00  0.00           H  
ATOM    892 HD11 ILE A  59      37.037  71.205  -1.927  1.00  0.00           H  
ATOM    893 HD12 ILE A  59      37.687  69.597  -1.604  1.00  0.00           H  
ATOM    894 HD13 ILE A  59      36.762  69.895  -3.075  1.00  0.00           H  
ATOM    895  N   LYS A  60      34.676  70.063   3.273  1.00  0.00           N  
ATOM    896  CA  LYS A  60      34.425  70.783   4.517  1.00  0.00           C  
ATOM    897  C   LYS A  60      35.725  71.325   5.103  1.00  0.00           C  
ATOM    898  O   LYS A  60      36.773  70.682   5.050  1.00  0.00           O  
ATOM    899  CB  LYS A  60      33.739  69.864   5.531  1.00  0.00           C  
ATOM    900  CG  LYS A  60      32.722  68.924   4.910  1.00  0.00           C  
ATOM    901  CD  LYS A  60      31.503  69.677   4.401  1.00  0.00           C  
ATOM    902  CE  LYS A  60      30.872  68.977   3.209  1.00  0.00           C  
ATOM    903  NZ  LYS A  60      29.406  69.226   3.130  1.00  0.00           N  
ATOM    904  H   LYS A  60      35.321  69.326   3.270  1.00  0.00           H  
ATOM    905  HA  LYS A  60      33.771  71.612   4.295  1.00  0.00           H  
ATOM    906  HB2 LYS A  60      34.492  69.270   6.027  1.00  0.00           H  
ATOM    907  HB3 LYS A  60      33.233  70.474   6.266  1.00  0.00           H  
ATOM    908  HG2 LYS A  60      33.182  68.406   4.081  1.00  0.00           H  
ATOM    909  HG3 LYS A  60      32.405  68.208   5.654  1.00  0.00           H  
ATOM    910  HD2 LYS A  60      30.774  69.742   5.194  1.00  0.00           H  
ATOM    911  HD3 LYS A  60      31.804  70.672   4.106  1.00  0.00           H  
ATOM    912  HE2 LYS A  60      31.339  69.340   2.306  1.00  0.00           H  
ATOM    913  HE3 LYS A  60      31.044  67.914   3.300  1.00  0.00           H  
ATOM    914  HZ1 LYS A  60      28.926  68.793   3.945  1.00  0.00           H  
ATOM    915  HZ2 LYS A  60      29.020  68.816   2.256  1.00  0.00           H  
ATOM    916  HZ3 LYS A  60      29.217  70.249   3.132  1.00  0.00           H  
ATOM    917  N   PRO A  61      35.656  72.534   5.678  1.00  0.00           N  
ATOM    918  CA  PRO A  61      36.818  73.188   6.288  1.00  0.00           C  
ATOM    919  C   PRO A  61      37.266  72.496   7.571  1.00  0.00           C  
ATOM    920  O   PRO A  61      36.457  72.230   8.460  1.00  0.00           O  
ATOM    921  CB  PRO A  61      36.312  74.600   6.591  1.00  0.00           C  
ATOM    922  CG  PRO A  61      34.836  74.452   6.730  1.00  0.00           C  
ATOM    923  CD  PRO A  61      34.439  73.357   5.778  1.00  0.00           C  
ATOM    924  HA  PRO A  61      37.649  73.242   5.600  1.00  0.00           H  
ATOM    925  HB2 PRO A  61      36.761  74.958   7.508  1.00  0.00           H  
ATOM    926  HB3 PRO A  61      36.567  75.261   5.777  1.00  0.00           H  
ATOM    927  HG2 PRO A  61      34.587  74.176   7.743  1.00  0.00           H  
ATOM    928  HG3 PRO A  61      34.347  75.377   6.460  1.00  0.00           H  
ATOM    929  HD2 PRO A  61      33.619  72.784   6.184  1.00  0.00           H  
ATOM    930  HD3 PRO A  61      34.173  73.770   4.816  1.00  0.00           H  
ATOM    931  N   VAL A  62      38.561  72.207   7.660  1.00  0.00           N  
ATOM    932  CA  VAL A  62      39.117  71.547   8.835  1.00  0.00           C  
ATOM    933  C   VAL A  62      39.346  72.542   9.968  1.00  0.00           C  
ATOM    934  O   VAL A  62      39.898  73.621   9.755  1.00  0.00           O  
ATOM    935  CB  VAL A  62      40.447  70.844   8.507  1.00  0.00           C  
ATOM    936  CG1 VAL A  62      41.017  70.171   9.747  1.00  0.00           C  
ATOM    937  CG2 VAL A  62      40.254  69.835   7.385  1.00  0.00           C  
ATOM    938  H   VAL A  62      39.156  72.444   6.919  1.00  0.00           H  
ATOM    939  HA  VAL A  62      38.410  70.798   9.164  1.00  0.00           H  
ATOM    940  HB  VAL A  62      41.153  71.590   8.173  1.00  0.00           H  
ATOM    941 HG11 VAL A  62      40.854  70.805  10.607  1.00  0.00           H  
ATOM    942 HG12 VAL A  62      40.525  69.222   9.899  1.00  0.00           H  
ATOM    943 HG13 VAL A  62      42.077  70.011   9.615  1.00  0.00           H  
ATOM    944 HG21 VAL A  62      39.262  69.944   6.971  1.00  0.00           H  
ATOM    945 HG22 VAL A  62      40.987  70.011   6.611  1.00  0.00           H  
ATOM    946 HG23 VAL A  62      40.374  68.835   7.775  1.00  0.00           H  
ATOM    947  N   GLN A  63      38.920  72.170  11.170  1.00  0.00           N  
ATOM    948  CA  GLN A  63      39.078  73.030  12.336  1.00  0.00           C  
ATOM    949  C   GLN A  63      40.554  73.259  12.647  1.00  0.00           C  
ATOM    950  O   GLN A  63      41.412  72.462  12.264  1.00  0.00           O  
ATOM    951  CB  GLN A  63      38.379  72.415  13.550  1.00  0.00           C  
ATOM    952  CG  GLN A  63      37.939  73.440  14.582  1.00  0.00           C  
ATOM    953  CD  GLN A  63      37.558  72.807  15.906  1.00  0.00           C  
ATOM    954  OE1 GLN A  63      36.801  71.837  15.948  1.00  0.00           O  
ATOM    955  NE2 GLN A  63      38.080  73.354  16.997  1.00  0.00           N  
ATOM    956  H   GLN A  63      38.487  71.297  11.275  1.00  0.00           H  
ATOM    957  HA  GLN A  63      38.619  73.981  12.111  1.00  0.00           H  
ATOM    958  HB2 GLN A  63      37.505  71.877  13.212  1.00  0.00           H  
ATOM    959  HB3 GLN A  63      39.056  71.723  14.027  1.00  0.00           H  
ATOM    960  HG2 GLN A  63      38.750  74.132  14.753  1.00  0.00           H  
ATOM    961  HG3 GLN A  63      37.084  73.976  14.197  1.00  0.00           H  
ATOM    962 HE21 GLN A  63      38.674  74.128  16.887  1.00  0.00           H  
ATOM    963 HE22 GLN A  63      37.850  72.967  17.866  1.00  0.00           H  
ATOM    964  N   THR A  64      40.844  74.353  13.344  1.00  0.00           N  
ATOM    965  CA  THR A  64      42.216  74.688  13.705  1.00  0.00           C  
ATOM    966  C   THR A  64      42.495  74.362  15.168  1.00  0.00           C  
ATOM    967  O   THR A  64      41.575  74.288  15.982  1.00  0.00           O  
ATOM    968  CB  THR A  64      42.515  76.178  13.456  1.00  0.00           C  
ATOM    969  OG1 THR A  64      43.897  76.451  13.713  1.00  0.00           O  
ATOM    970  CG2 THR A  64      41.646  77.059  14.342  1.00  0.00           C  
ATOM    971  H   THR A  64      40.118  74.949  13.620  1.00  0.00           H  
ATOM    972  HA  THR A  64      42.877  74.101  13.083  1.00  0.00           H  
ATOM    973  HB  THR A  64      42.297  76.406  12.422  1.00  0.00           H  
ATOM    974  HG1 THR A  64      44.009  76.699  14.634  1.00  0.00           H  
ATOM    975 HG21 THR A  64      40.687  76.585  14.491  1.00  0.00           H  
ATOM    976 HG22 THR A  64      41.504  78.018  13.865  1.00  0.00           H  
ATOM    977 HG23 THR A  64      42.131  77.199  15.295  1.00  0.00           H  
ATOM    978  N   GLU A  65      43.769  74.170  15.494  1.00  0.00           N  
ATOM    979  CA  GLU A  65      44.167  73.853  16.861  1.00  0.00           C  
ATOM    980  C   GLU A  65      44.035  75.076  17.764  1.00  0.00           C  
ATOM    981  O   GLU A  65      45.001  75.807  17.981  1.00  0.00           O  
ATOM    982  CB  GLU A  65      45.607  73.336  16.889  1.00  0.00           C  
ATOM    983  CG  GLU A  65      45.783  71.985  16.217  1.00  0.00           C  
ATOM    984  CD  GLU A  65      45.983  72.102  14.719  1.00  0.00           C  
ATOM    985  OE1 GLU A  65      46.607  73.089  14.278  1.00  0.00           O  
ATOM    986  OE2 GLU A  65      45.516  71.204  13.985  1.00  0.00           O  
ATOM    987  H   GLU A  65      44.456  74.242  14.800  1.00  0.00           H  
ATOM    988  HA  GLU A  65      43.510  73.078  17.227  1.00  0.00           H  
ATOM    989  HB2 GLU A  65      46.242  74.051  16.388  1.00  0.00           H  
ATOM    990  HB3 GLU A  65      45.924  73.247  17.918  1.00  0.00           H  
ATOM    991  HG2 GLU A  65      46.645  71.495  16.642  1.00  0.00           H  
ATOM    992  HG3 GLU A  65      44.902  71.388  16.403  1.00  0.00           H  
ATOM    993  N   ALA A  66      42.832  75.291  18.287  1.00  0.00           N  
ATOM    994  CA  ALA A  66      42.575  76.423  19.167  1.00  0.00           C  
ATOM    995  C   ALA A  66      42.794  76.045  20.628  1.00  0.00           C  
ATOM    996  O   ALA A  66      42.016  76.427  21.502  1.00  0.00           O  
ATOM    997  CB  ALA A  66      41.158  76.939  18.962  1.00  0.00           C  
ATOM    998  H   ALA A  66      42.102  74.673  18.076  1.00  0.00           H  
ATOM    999  HA  ALA A  66      43.261  77.215  18.903  1.00  0.00           H  
ATOM   1000  HB1 ALA A  66      40.461  76.289  19.470  1.00  0.00           H  
ATOM   1001  HB2 ALA A  66      41.077  77.939  19.362  1.00  0.00           H  
ATOM   1002  HB3 ALA A  66      40.930  76.954  17.906  1.00  0.00           H  
ATOM   1003  N   TRP A  67      43.858  75.292  20.884  1.00  0.00           N  
ATOM   1004  CA  TRP A  67      44.179  74.862  22.241  1.00  0.00           C  
ATOM   1005  C   TRP A  67      44.285  76.057  23.181  1.00  0.00           C  
ATOM   1006  O   TRP A  67      44.626  77.162  22.760  1.00  0.00           O  
ATOM   1007  CB  TRP A  67      45.490  74.072  22.250  1.00  0.00           C  
ATOM   1008  CG  TRP A  67      45.353  72.689  21.689  1.00  0.00           C  
ATOM   1009  CD1 TRP A  67      44.954  72.352  20.427  1.00  0.00           C  
ATOM   1010  CD2 TRP A  67      45.616  71.458  22.371  1.00  0.00           C  
ATOM   1011  NE1 TRP A  67      44.952  70.985  20.284  1.00  0.00           N  
ATOM   1012  CE2 TRP A  67      45.355  70.413  21.462  1.00  0.00           C  
ATOM   1013  CE3 TRP A  67      46.048  71.135  23.660  1.00  0.00           C  
ATOM   1014  CZ2 TRP A  67      45.511  69.073  21.804  1.00  0.00           C  
ATOM   1015  CZ3 TRP A  67      46.202  69.805  23.997  1.00  0.00           C  
ATOM   1016  CH2 TRP A  67      45.935  68.787  23.073  1.00  0.00           C  
ATOM   1017  H   TRP A  67      44.441  75.019  20.145  1.00  0.00           H  
ATOM   1018  HA  TRP A  67      43.381  74.220  22.582  1.00  0.00           H  
ATOM   1019  HB2 TRP A  67      46.225  74.600  21.661  1.00  0.00           H  
ATOM   1020  HB3 TRP A  67      45.843  73.986  23.267  1.00  0.00           H  
ATOM   1021  HD1 TRP A  67      44.680  73.066  19.665  1.00  0.00           H  
ATOM   1022  HE1 TRP A  67      44.703  70.500  19.470  1.00  0.00           H  
ATOM   1023  HE3 TRP A  67      46.259  71.906  24.387  1.00  0.00           H  
ATOM   1024  HZ2 TRP A  67      45.310  68.278  21.102  1.00  0.00           H  
ATOM   1025  HZ3 TRP A  67      46.535  69.537  24.989  1.00  0.00           H  
ATOM   1026  HH2 TRP A  67      46.068  67.761  23.380  1.00  0.00           H  
ATOM   1027  N   VAL A  68      43.992  75.829  24.457  1.00  0.00           N  
ATOM   1028  CA  VAL A  68      44.055  76.887  25.457  1.00  0.00           C  
ATOM   1029  C   VAL A  68      44.723  76.395  26.737  1.00  0.00           C  
ATOM   1030  O   VAL A  68      44.314  75.389  27.316  1.00  0.00           O  
ATOM   1031  CB  VAL A  68      42.651  77.423  25.798  1.00  0.00           C  
ATOM   1032  CG1 VAL A  68      42.736  78.498  26.870  1.00  0.00           C  
ATOM   1033  CG2 VAL A  68      41.969  77.957  24.548  1.00  0.00           C  
ATOM   1034  H   VAL A  68      43.726  74.926  24.732  1.00  0.00           H  
ATOM   1035  HA  VAL A  68      44.639  77.700  25.048  1.00  0.00           H  
ATOM   1036  HB  VAL A  68      42.061  76.606  26.184  1.00  0.00           H  
ATOM   1037 HG11 VAL A  68      43.573  78.292  27.522  1.00  0.00           H  
ATOM   1038 HG12 VAL A  68      42.871  79.463  26.403  1.00  0.00           H  
ATOM   1039 HG13 VAL A  68      41.824  78.502  27.448  1.00  0.00           H  
ATOM   1040 HG21 VAL A  68      42.653  78.596  24.010  1.00  0.00           H  
ATOM   1041 HG22 VAL A  68      41.675  77.131  23.917  1.00  0.00           H  
ATOM   1042 HG23 VAL A  68      41.093  78.523  24.830  1.00  0.00           H  
ATOM   1043  N   ARG A  69      45.754  77.112  27.172  1.00  0.00           N  
ATOM   1044  CA  ARG A  69      46.481  76.748  28.383  1.00  0.00           C  
ATOM   1045  C   ARG A  69      45.898  77.459  29.601  1.00  0.00           C  
ATOM   1046  O   ARG A  69      45.354  78.559  29.489  1.00  0.00           O  
ATOM   1047  CB  ARG A  69      47.964  77.094  28.237  1.00  0.00           C  
ATOM   1048  CG  ARG A  69      48.837  76.501  29.331  1.00  0.00           C  
ATOM   1049  CD  ARG A  69      50.300  76.867  29.135  1.00  0.00           C  
ATOM   1050  NE  ARG A  69      51.003  75.887  28.310  1.00  0.00           N  
ATOM   1051  CZ  ARG A  69      51.392  74.697  28.755  1.00  0.00           C  
ATOM   1052  NH1 ARG A  69      51.146  74.342  30.008  1.00  0.00           N  
ATOM   1053  NH2 ARG A  69      52.027  73.860  27.945  1.00  0.00           N  
ATOM   1054  H   ARG A  69      46.034  77.904  26.667  1.00  0.00           H  
ATOM   1055  HA  ARG A  69      46.381  75.682  28.522  1.00  0.00           H  
ATOM   1056  HB2 ARG A  69      48.315  76.724  27.286  1.00  0.00           H  
ATOM   1057  HB3 ARG A  69      48.074  78.168  28.261  1.00  0.00           H  
ATOM   1058  HG2 ARG A  69      48.508  76.880  30.287  1.00  0.00           H  
ATOM   1059  HG3 ARG A  69      48.738  75.426  29.314  1.00  0.00           H  
ATOM   1060  HD2 ARG A  69      50.354  77.832  28.653  1.00  0.00           H  
ATOM   1061  HD3 ARG A  69      50.777  76.919  30.101  1.00  0.00           H  
ATOM   1062  HE  ARG A  69      51.195  76.130  27.381  1.00  0.00           H  
ATOM   1063 HH11 ARG A  69      50.667  74.970  30.621  1.00  0.00           H  
ATOM   1064 HH12 ARG A  69      51.438  73.444  30.340  1.00  0.00           H  
ATOM   1065 HH21 ARG A  69      52.214  74.124  27.000  1.00  0.00           H  
ATOM   1066 HH22 ARG A  69      52.319  72.965  28.280  1.00  0.00           H  
ATOM   1067  N   ASP A  70      46.015  76.826  30.762  1.00  0.00           N  
ATOM   1068  CA  ASP A  70      45.502  77.398  32.001  1.00  0.00           C  
ATOM   1069  C   ASP A  70      45.915  76.554  33.203  1.00  0.00           C  
ATOM   1070  O   ASP A  70      45.935  75.324  33.150  1.00  0.00           O  
ATOM   1071  CB  ASP A  70      43.977  77.511  31.942  1.00  0.00           C  
ATOM   1072  CG  ASP A  70      43.451  78.674  32.759  1.00  0.00           C  
ATOM   1073  OD1 ASP A  70      43.478  79.815  32.252  1.00  0.00           O  
ATOM   1074  OD2 ASP A  70      43.014  78.444  33.907  1.00  0.00           O  
ATOM   1075  H   ASP A  70      46.459  75.952  30.787  1.00  0.00           H  
ATOM   1076  HA  ASP A  70      45.922  78.386  32.109  1.00  0.00           H  
ATOM   1077  HB2 ASP A  70      43.673  77.650  30.915  1.00  0.00           H  
ATOM   1078  HB3 ASP A  70      43.541  76.599  32.322  1.00  0.00           H  
ATOM   1079  N   PRO A  71      46.255  77.227  34.312  1.00  0.00           N  
ATOM   1080  CA  PRO A  71      46.675  76.559  35.547  1.00  0.00           C  
ATOM   1081  C   PRO A  71      45.526  75.824  36.228  1.00  0.00           C  
ATOM   1082  O   PRO A  71      45.733  75.077  37.183  1.00  0.00           O  
ATOM   1083  CB  PRO A  71      47.166  77.713  36.424  1.00  0.00           C  
ATOM   1084  CG  PRO A  71      46.436  78.910  35.922  1.00  0.00           C  
ATOM   1085  CD  PRO A  71      46.254  78.694  34.445  1.00  0.00           C  
ATOM   1086  HA  PRO A  71      47.486  75.869  35.368  1.00  0.00           H  
ATOM   1087  HB2 PRO A  71      46.927  77.508  37.459  1.00  0.00           H  
ATOM   1088  HB3 PRO A  71      48.234  77.826  36.311  1.00  0.00           H  
ATOM   1089  HG2 PRO A  71      45.476  78.985  36.410  1.00  0.00           H  
ATOM   1090  HG3 PRO A  71      47.021  79.799  36.101  1.00  0.00           H  
ATOM   1091  HD2 PRO A  71      45.315  79.110  34.115  1.00  0.00           H  
ATOM   1092  HD3 PRO A  71      47.077  79.130  33.896  1.00  0.00           H  
ATOM   1093  N   ASN A  72      44.313  76.039  35.729  1.00  0.00           N  
ATOM   1094  CA  ASN A  72      43.129  75.398  36.290  1.00  0.00           C  
ATOM   1095  C   ASN A  72      42.794  74.117  35.530  1.00  0.00           C  
ATOM   1096  O   ASN A  72      42.299  74.162  34.404  1.00  0.00           O  
ATOM   1097  CB  ASN A  72      41.937  76.354  36.249  1.00  0.00           C  
ATOM   1098  CG  ASN A  72      40.612  75.634  36.413  1.00  0.00           C  
ATOM   1099  OD1 ASN A  72      40.462  74.776  37.284  1.00  0.00           O  
ATOM   1100  ND2 ASN A  72      39.643  75.980  35.573  1.00  0.00           N  
ATOM   1101  H   ASN A  72      44.210  76.645  34.965  1.00  0.00           H  
ATOM   1102  HA  ASN A  72      43.345  75.147  37.317  1.00  0.00           H  
ATOM   1103  HB2 ASN A  72      42.034  77.074  37.049  1.00  0.00           H  
ATOM   1104  HB3 ASN A  72      41.929  76.873  35.303  1.00  0.00           H  
ATOM   1105 HD21 ASN A  72      39.834  76.670  34.905  1.00  0.00           H  
ATOM   1106 HD22 ASN A  72      38.776  75.531  35.658  1.00  0.00           H  
ATOM   1107  N   SER A  73      43.067  72.976  36.156  1.00  0.00           N  
ATOM   1108  CA  SER A  73      42.798  71.682  35.538  1.00  0.00           C  
ATOM   1109  C   SER A  73      41.355  71.604  35.051  1.00  0.00           C  
ATOM   1110  O   SER A  73      40.417  71.833  35.813  1.00  0.00           O  
ATOM   1111  CB  SER A  73      43.075  70.552  36.531  1.00  0.00           C  
ATOM   1112  OG  SER A  73      44.465  70.290  36.632  1.00  0.00           O  
ATOM   1113  H   SER A  73      43.462  73.005  37.052  1.00  0.00           H  
ATOM   1114  HA  SER A  73      43.459  71.576  34.691  1.00  0.00           H  
ATOM   1115  HB2 SER A  73      42.704  70.832  37.505  1.00  0.00           H  
ATOM   1116  HB3 SER A  73      42.575  69.654  36.199  1.00  0.00           H  
ATOM   1117  HG  SER A  73      44.755  69.800  35.859  1.00  0.00           H  
ATOM   1118  N   GLY A  74      41.186  71.277  33.773  1.00  0.00           N  
ATOM   1119  CA  GLY A  74      39.855  71.174  33.203  1.00  0.00           C  
ATOM   1120  C   GLY A  74      39.212  69.827  33.472  1.00  0.00           C  
ATOM   1121  O   GLY A  74      38.585  69.609  34.508  1.00  0.00           O  
ATOM   1122  H   GLY A  74      41.971  71.106  33.212  1.00  0.00           H  
ATOM   1123  HA2 GLY A  74      39.233  71.948  33.627  1.00  0.00           H  
ATOM   1124  HA3 GLY A  74      39.920  71.322  32.136  1.00  0.00           H  
ATOM   1125  N   PRO A  75      39.365  68.894  32.520  1.00  0.00           N  
ATOM   1126  CA  PRO A  75      38.802  67.546  32.636  1.00  0.00           C  
ATOM   1127  C   PRO A  75      39.505  66.713  33.703  1.00  0.00           C  
ATOM   1128  O   PRO A  75      40.725  66.777  33.848  1.00  0.00           O  
ATOM   1129  CB  PRO A  75      39.035  66.944  31.248  1.00  0.00           C  
ATOM   1130  CG  PRO A  75      40.204  67.691  30.703  1.00  0.00           C  
ATOM   1131  CD  PRO A  75      40.101  69.083  31.259  1.00  0.00           C  
ATOM   1132  HA  PRO A  75      37.742  67.575  32.844  1.00  0.00           H  
ATOM   1133  HB2 PRO A  75      39.249  65.888  31.341  1.00  0.00           H  
ATOM   1134  HB3 PRO A  75      38.157  67.086  30.637  1.00  0.00           H  
ATOM   1135  HG2 PRO A  75      41.121  67.224  31.027  1.00  0.00           H  
ATOM   1136  HG3 PRO A  75      40.154  67.713  29.624  1.00  0.00           H  
ATOM   1137  HD2 PRO A  75      41.084  69.490  31.443  1.00  0.00           H  
ATOM   1138  HD3 PRO A  75      39.548  69.720  30.583  1.00  0.00           H  
ATOM   1139  N   SER A  76      38.726  65.932  34.445  1.00  0.00           N  
ATOM   1140  CA  SER A  76      39.274  65.090  35.501  1.00  0.00           C  
ATOM   1141  C   SER A  76      38.696  63.679  35.425  1.00  0.00           C  
ATOM   1142  O   SER A  76      37.721  63.434  34.716  1.00  0.00           O  
ATOM   1143  CB  SER A  76      38.982  65.699  36.874  1.00  0.00           C  
ATOM   1144  OG  SER A  76      39.904  66.730  37.181  1.00  0.00           O  
ATOM   1145  H   SER A  76      37.760  65.925  34.280  1.00  0.00           H  
ATOM   1146  HA  SER A  76      40.344  65.036  35.361  1.00  0.00           H  
ATOM   1147  HB2 SER A  76      37.984  66.112  36.875  1.00  0.00           H  
ATOM   1148  HB3 SER A  76      39.054  64.930  37.629  1.00  0.00           H  
ATOM   1149  HG  SER A  76      39.859  66.932  38.118  1.00  0.00           H  
ATOM   1150  N   SER A  77      39.306  62.756  36.161  1.00  0.00           N  
ATOM   1151  CA  SER A  77      38.855  61.369  36.176  1.00  0.00           C  
ATOM   1152  C   SER A  77      37.375  61.283  36.531  1.00  0.00           C  
ATOM   1153  O   SER A  77      36.910  61.933  37.466  1.00  0.00           O  
ATOM   1154  CB  SER A  77      39.680  60.553  37.174  1.00  0.00           C  
ATOM   1155  OG  SER A  77      39.276  60.819  38.506  1.00  0.00           O  
ATOM   1156  H   SER A  77      40.079  63.013  36.706  1.00  0.00           H  
ATOM   1157  HA  SER A  77      39.000  60.963  35.186  1.00  0.00           H  
ATOM   1158  HB2 SER A  77      39.546  59.501  36.973  1.00  0.00           H  
ATOM   1159  HB3 SER A  77      40.724  60.810  37.069  1.00  0.00           H  
ATOM   1160  HG  SER A  77      40.048  61.016  39.042  1.00  0.00           H  
ATOM   1161  N   GLY A  78      36.638  60.473  35.775  1.00  0.00           N  
ATOM   1162  CA  GLY A  78      35.216  60.315  36.026  1.00  0.00           C  
ATOM   1163  C   GLY A  78      34.933  59.414  37.211  1.00  0.00           C  
ATOM   1164  O   GLY A  78      35.632  58.425  37.429  1.00  0.00           O  
ATOM   1165  H   GLY A  78      37.062  59.979  35.044  1.00  0.00           H  
ATOM   1166  HA2 GLY A  78      34.785  61.287  36.213  1.00  0.00           H  
ATOM   1167  HA3 GLY A  78      34.754  59.891  35.147  1.00  0.00           H  
TER    1168      GLY A  78                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
