
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 ( 1011),  selected   68 , name 2dig_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2dig_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    S    10_A      L       3           #
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    R    11_A      Q       6          1.758
LGA    -       -      G       7           -
LGA    K    12_A      D       8          3.598
LGA    F    13_A      L       9          1.646
LGA    A    14_A      I      10          1.033
LGA    D    15_A      V      11          1.175
LGA    G    16_A      S      12          0.927
LGA    E    17_A      M      13          0.573
LGA    V    18_A      R      14          0.497
LGA    V    19_A      I      15          0.459
LGA    R    20_A      L      16          0.493
LGA    G    21_A      G      17          0.480
LGA    R    22_A      K      18          0.633
LGA    W    23_A      K      19          1.015
LGA    P    24_A      R      20          2.443
LGA    G    25_A      -       -           -
LGA    S    26_A      T      21          1.125
LGA    S    27_A      K      22          1.042
LGA    L    28_A      T      23          1.180
LGA    Y    29_A      W      24          1.235
LGA    Y    30_A      X      25          0.443
LGA    E    31_A      K      26          0.198
LGA    V    32_A      G      27          0.811
LGA    E    33_A      T      28          0.415
LGA    I    34_A      L      29          0.451
LGA    L    35_A      I      30          0.339
LGA    S    36_A      A      31          0.235
LGA    H    37_A      I      32          0.750
LGA    D    38_A      Q      33          1.146
LGA    S    39_A      T      34          1.220
LGA    T    40_A      V      35          1.183
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    S    41_A      G      38          3.641
LGA    Q    42_A      K      39          1.242
LGA    L    43_A      K      40          1.326
LGA    Y    44_A      Y      41          0.630
LGA    T    45_A      K      42          0.492
LGA    V    46_A      V      43          0.567
LGA    K    47_A      K      44          0.088
LGA    Y    48_A      F      45          0.944
LGA    K    49_A      D      46          1.743
LGA    D    50_A      N      47          2.713
LGA    G    51_A      K      48          4.687
LGA    T    52_A      G      49          1.068
LGA    E    53_A      K      50          1.015
LGA    L    54_A      S      51          0.480
LGA    E    55_A      L      52          0.659
LGA    L    56_A      L      53          0.821
LGA    K    57_A      S      54          0.637
LGA    E    58_A      G      55          0.932
LGA    N    59_A      N      56          1.196
LGA    D    60_A      X      57          0.758
LGA    I    61_A      I      58          0.603
LGA    K    62_A      A      59          0.572
LGA    S    63_A      Y      60          0.517
LGA    G    64_A      D      61          3.170
LGA    P    65_A      Y      62          2.150
LGA    S    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    G    68_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68   62    5.0     54    1.46    12.96     83.185     3.458

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.645111 * X  +   0.037497 * Y  +  -0.763168 * Z  +  39.502148
  Y_new =  -0.484066 * X  +   0.752737 * Y  +   0.446169 * Z  +  64.810928
  Z_new =   0.591195 * X  +   0.657253 * Y  +  -0.467448 * Z  +   2.951396 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.189009   -0.952583  [ DEG:   125.4210    -54.5790 ]
  Theta =  -0.632539   -2.509053  [ DEG:   -36.2418   -143.7582 ]
  Phi   =  -2.497861    0.643732  [ DEG:  -143.1169     36.8831 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dig_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dig_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68   62   5.0   54   1.46   12.96  83.185
REMARK  ---------------------------------------------------------- 
MOLECULE 2dig_A
HEADER    DNA BINDING PROTEIN                     30-MAR-06   2DIG              
TITLE     SOLUSION STRUCTURE OF THE TODOR DOMAIN OF HUMAN LAMIN-B               
TITLE    2 RECEPTOR                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LAMIN-B RECEPTOR;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: INTEGRAL NUCLEAR ENVELOPE INNER MEMBRANE PROTEIN,           
COMPND   6 LMN2R;                                                               
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: LBR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050905-15;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, INTEGRAL NUCLEAR ENVELOPE INNER MEMBRANE                
KEYWDS   2 PROTEIN, NUCLEAR PROTEIN, RECEPTOR, STRUCTURAL GENOMICS,             
KEYWDS   3 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   4 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   5 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.YONEYAMA,N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,            
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   30-SEP-06 2DIG    0                                                
JRNL        AUTH   M.YONEYAMA,N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,              
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUSION STRUCTURE OF THE TODOR DOMAIN OF HUMAN              
JRNL        TITL 2 LAMIN-B RECEPTOR                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DIG A    8    62  UNP    Q14739   LBR_HUMAN        1     55             
SEQRES   1 A   68  GLY SER SER GLY SER SER GLY MET PRO SER ARG LYS PHE          
SEQRES   2 A   68  ALA ASP GLY GLU VAL VAL ARG GLY ARG TRP PRO GLY SER          
SEQRES   3 A   68  SER LEU TYR TYR GLU VAL GLU ILE LEU SER HIS ASP SER          
SEQRES   4 A   68  THR SER GLN LEU TYR THR VAL LYS TYR LYS ASP GLY THR          
SEQRES   5 A   68  GLU LEU GLU LEU LYS GLU ASN ASP ILE LYS SER GLY PRO          
SEQRES   6 A   68  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      24.481  95.682  -1.523  1.00  0.00           N  
ATOM      2  CA  GLY A   1      24.420  96.899  -2.309  1.00  0.00           C  
ATOM      3  C   GLY A   1      25.755  97.252  -2.935  1.00  0.00           C  
ATOM      4  O   GLY A   1      26.479  98.110  -2.430  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      23.689  96.773  -3.093  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      24.111  97.713  -1.669  1.00  0.00           H  
ATOM      7  H1  GLY A   1      25.329  95.402  -1.120  1.00  0.00           H  
ATOM      8  N   SER A   2      26.084  96.586  -4.038  1.00  0.00           N  
ATOM      9  CA  SER A   2      27.343  96.829  -4.731  1.00  0.00           C  
ATOM     10  C   SER A   2      28.520  96.742  -3.765  1.00  0.00           C  
ATOM     11  O   SER A   2      29.354  97.645  -3.701  1.00  0.00           O  
ATOM     12  CB  SER A   2      27.322  98.203  -5.404  1.00  0.00           C  
ATOM     13  OG  SER A   2      26.583  98.168  -6.612  1.00  0.00           O  
ATOM     14  H   SER A   2      25.464  95.913  -4.392  1.00  0.00           H  
ATOM     15  HA  SER A   2      27.456  96.069  -5.489  1.00  0.00           H  
ATOM     16  HB2 SER A   2      26.867  98.921  -4.738  1.00  0.00           H  
ATOM     17  HB3 SER A   2      28.335  98.508  -5.623  1.00  0.00           H  
ATOM     18  HG  SER A   2      26.726  98.983  -7.099  1.00  0.00           H  
ATOM     19  N   SER A   3      28.583  95.645  -3.015  1.00  0.00           N  
ATOM     20  CA  SER A   3      29.655  95.439  -2.049  1.00  0.00           C  
ATOM     21  C   SER A   3      29.915  93.952  -1.836  1.00  0.00           C  
ATOM     22  O   SER A   3      28.995  93.136  -1.873  1.00  0.00           O  
ATOM     23  CB  SER A   3      29.303  96.102  -0.716  1.00  0.00           C  
ATOM     24  OG  SER A   3      30.395  96.045   0.186  1.00  0.00           O  
ATOM     25  H   SER A   3      27.887  94.960  -3.112  1.00  0.00           H  
ATOM     26  HA  SER A   3      30.549  95.897  -2.445  1.00  0.00           H  
ATOM     27  HB2 SER A   3      29.047  97.137  -0.887  1.00  0.00           H  
ATOM     28  HB3 SER A   3      28.459  95.592  -0.274  1.00  0.00           H  
ATOM     29  HG  SER A   3      30.088  95.740   1.042  1.00  0.00           H  
ATOM     30  N   GLY A   4      31.180  93.604  -1.615  1.00  0.00           N  
ATOM     31  CA  GLY A   4      31.542  92.216  -1.400  1.00  0.00           C  
ATOM     32  C   GLY A   4      32.801  91.821  -2.146  1.00  0.00           C  
ATOM     33  O   GLY A   4      33.830  91.538  -1.534  1.00  0.00           O  
ATOM     34  H   GLY A   4      31.873  94.298  -1.597  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      31.696  92.055  -0.344  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      30.729  91.588  -1.734  1.00  0.00           H  
ATOM     37  N   SER A   5      32.720  91.802  -3.473  1.00  0.00           N  
ATOM     38  CA  SER A   5      33.860  91.435  -4.303  1.00  0.00           C  
ATOM     39  C   SER A   5      34.817  92.612  -4.464  1.00  0.00           C  
ATOM     40  O   SER A   5      34.586  93.507  -5.276  1.00  0.00           O  
ATOM     41  CB  SER A   5      33.385  90.959  -5.677  1.00  0.00           C  
ATOM     42  OG  SER A   5      32.936  89.616  -5.624  1.00  0.00           O  
ATOM     43  H   SER A   5      31.871  92.038  -3.903  1.00  0.00           H  
ATOM     44  HA  SER A   5      34.381  90.627  -3.813  1.00  0.00           H  
ATOM     45  HB2 SER A   5      32.572  91.585  -6.011  1.00  0.00           H  
ATOM     46  HB3 SER A   5      34.202  91.025  -6.381  1.00  0.00           H  
ATOM     47  HG  SER A   5      33.616  89.037  -5.974  1.00  0.00           H  
ATOM     48  N   SER A   6      35.892  92.604  -3.681  1.00  0.00           N  
ATOM     49  CA  SER A   6      36.883  93.672  -3.734  1.00  0.00           C  
ATOM     50  C   SER A   6      38.267  93.148  -3.363  1.00  0.00           C  
ATOM     51  O   SER A   6      38.448  92.527  -2.317  1.00  0.00           O  
ATOM     52  CB  SER A   6      36.487  94.810  -2.789  1.00  0.00           C  
ATOM     53  OG  SER A   6      35.165  95.251  -3.049  1.00  0.00           O  
ATOM     54  H   SER A   6      36.020  91.862  -3.053  1.00  0.00           H  
ATOM     55  HA  SER A   6      36.912  94.049  -4.745  1.00  0.00           H  
ATOM     56  HB2 SER A   6      36.545  94.464  -1.769  1.00  0.00           H  
ATOM     57  HB3 SER A   6      37.165  95.640  -2.927  1.00  0.00           H  
ATOM     58  HG  SER A   6      35.188  96.149  -3.386  1.00  0.00           H  
ATOM     59  N   GLY A   7      39.241  93.403  -4.231  1.00  0.00           N  
ATOM     60  CA  GLY A   7      40.596  92.950  -3.978  1.00  0.00           C  
ATOM     61  C   GLY A   7      40.929  91.672  -4.723  1.00  0.00           C  
ATOM     62  O   GLY A   7      41.088  91.681  -5.944  1.00  0.00           O  
ATOM     63  H   GLY A   7      39.038  93.903  -5.049  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      41.286  93.723  -4.285  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      40.715  92.777  -2.919  1.00  0.00           H  
ATOM     66  N   MET A   8      41.036  90.571  -3.987  1.00  0.00           N  
ATOM     67  CA  MET A   8      41.352  89.280  -4.586  1.00  0.00           C  
ATOM     68  C   MET A   8      40.188  88.307  -4.428  1.00  0.00           C  
ATOM     69  O   MET A   8      39.423  88.367  -3.465  1.00  0.00           O  
ATOM     70  CB  MET A   8      42.612  88.691  -3.947  1.00  0.00           C  
ATOM     71  CG  MET A   8      43.875  89.477  -4.261  1.00  0.00           C  
ATOM     72  SD  MET A   8      44.137  89.692  -6.031  1.00  0.00           S  
ATOM     73  CE  MET A   8      45.471  90.888  -6.033  1.00  0.00           C  
ATOM     74  H   MET A   8      40.897  90.627  -3.019  1.00  0.00           H  
ATOM     75  HA  MET A   8      41.534  89.438  -5.639  1.00  0.00           H  
ATOM     76  HB2 MET A   8      42.482  88.673  -2.875  1.00  0.00           H  
ATOM     77  HB3 MET A   8      42.745  87.681  -4.304  1.00  0.00           H  
ATOM     78  HG2 MET A   8      43.801  90.451  -3.802  1.00  0.00           H  
ATOM     79  HG3 MET A   8      44.721  88.949  -3.846  1.00  0.00           H  
ATOM     80  HE1 MET A   8      45.415  91.488  -6.929  1.00  0.00           H  
ATOM     81  HE2 MET A   8      45.383  91.526  -5.167  1.00  0.00           H  
ATOM     82  HE3 MET A   8      46.418  90.370  -6.005  1.00  0.00           H  
ATOM     83  N   PRO A   9      40.046  87.389  -5.397  1.00  0.00           N  
ATOM     84  CA  PRO A   9      38.976  86.387  -5.387  1.00  0.00           C  
ATOM     85  C   PRO A   9      39.169  85.344  -4.292  1.00  0.00           C  
ATOM     86  O   PRO A   9      39.971  84.421  -4.434  1.00  0.00           O  
ATOM     87  CB  PRO A   9      39.088  85.738  -6.769  1.00  0.00           C  
ATOM     88  CG  PRO A   9      40.507  85.942  -7.171  1.00  0.00           C  
ATOM     89  CD  PRO A   9      40.921  87.259  -6.574  1.00  0.00           C  
ATOM     90  HA  PRO A   9      38.005  86.846  -5.280  1.00  0.00           H  
ATOM     91  HB2 PRO A   9      38.845  84.687  -6.696  1.00  0.00           H  
ATOM     92  HB3 PRO A   9      38.409  86.223  -7.455  1.00  0.00           H  
ATOM     93  HG2 PRO A   9      41.119  85.145  -6.780  1.00  0.00           H  
ATOM     94  HG3 PRO A   9      40.582  85.980  -8.248  1.00  0.00           H  
ATOM     95  HD2 PRO A   9      41.960  87.231  -6.282  1.00  0.00           H  
ATOM     96  HD3 PRO A   9      40.745  88.063  -7.275  1.00  0.00           H  
ATOM     97  N   SER A  10      38.428  85.498  -3.199  1.00  0.00           N  
ATOM     98  CA  SER A  10      38.519  84.571  -2.077  1.00  0.00           C  
ATOM     99  C   SER A  10      37.975  83.198  -2.461  1.00  0.00           C  
ATOM    100  O   SER A  10      36.827  83.070  -2.886  1.00  0.00           O  
ATOM    101  CB  SER A  10      37.751  85.117  -0.873  1.00  0.00           C  
ATOM    102  OG  SER A  10      36.384  85.312  -1.186  1.00  0.00           O  
ATOM    103  H   SER A  10      37.806  86.254  -3.145  1.00  0.00           H  
ATOM    104  HA  SER A  10      39.561  84.471  -1.814  1.00  0.00           H  
ATOM    105  HB2 SER A  10      37.824  84.417  -0.054  1.00  0.00           H  
ATOM    106  HB3 SER A  10      38.179  86.064  -0.576  1.00  0.00           H  
ATOM    107  HG  SER A  10      35.846  85.103  -0.418  1.00  0.00           H  
ATOM    108  N   ARG A  11      38.809  82.173  -2.307  1.00  0.00           N  
ATOM    109  CA  ARG A  11      38.413  80.810  -2.639  1.00  0.00           C  
ATOM    110  C   ARG A  11      37.986  80.049  -1.387  1.00  0.00           C  
ATOM    111  O   ARG A  11      38.692  80.045  -0.378  1.00  0.00           O  
ATOM    112  CB  ARG A  11      39.564  80.076  -3.328  1.00  0.00           C  
ATOM    113  CG  ARG A  11      39.229  78.644  -3.712  1.00  0.00           C  
ATOM    114  CD  ARG A  11      40.137  78.138  -4.823  1.00  0.00           C  
ATOM    115  NE  ARG A  11      41.460  77.774  -4.326  1.00  0.00           N  
ATOM    116  CZ  ARG A  11      42.544  77.715  -5.092  1.00  0.00           C  
ATOM    117  NH1 ARG A  11      42.460  77.997  -6.385  1.00  0.00           N  
ATOM    118  NH2 ARG A  11      43.713  77.374  -4.566  1.00  0.00           N  
ATOM    119  H   ARG A  11      39.711  82.340  -1.964  1.00  0.00           H  
ATOM    120  HA  ARG A  11      37.574  80.863  -3.316  1.00  0.00           H  
ATOM    121  HB2 ARG A  11      39.832  80.613  -4.225  1.00  0.00           H  
ATOM    122  HB3 ARG A  11      40.414  80.058  -2.662  1.00  0.00           H  
ATOM    123  HG2 ARG A  11      39.353  78.010  -2.846  1.00  0.00           H  
ATOM    124  HG3 ARG A  11      38.204  78.601  -4.048  1.00  0.00           H  
ATOM    125  HD2 ARG A  11      39.680  77.271  -5.275  1.00  0.00           H  
ATOM    126  HD3 ARG A  11      40.243  78.917  -5.564  1.00  0.00           H  
ATOM    127  HE  ARG A  11      41.545  77.560  -3.373  1.00  0.00           H  
ATOM    128 HH11 ARG A  11      41.580  78.255  -6.784  1.00  0.00           H  
ATOM    129 HH12 ARG A  11      43.277  77.954  -6.960  1.00  0.00           H  
ATOM    130 HH21 ARG A  11      43.779  77.161  -3.592  1.00  0.00           H  
ATOM    131 HH22 ARG A  11      44.527  77.331  -5.144  1.00  0.00           H  
ATOM    132  N   LYS A  12      36.826  79.405  -1.460  1.00  0.00           N  
ATOM    133  CA  LYS A  12      36.304  78.639  -0.334  1.00  0.00           C  
ATOM    134  C   LYS A  12      37.436  77.981   0.448  1.00  0.00           C  
ATOM    135  O   LYS A  12      37.398  77.914   1.677  1.00  0.00           O  
ATOM    136  CB  LYS A  12      35.324  77.572  -0.828  1.00  0.00           C  
ATOM    137  CG  LYS A  12      34.308  77.149   0.219  1.00  0.00           C  
ATOM    138  CD  LYS A  12      33.344  76.109  -0.327  1.00  0.00           C  
ATOM    139  CE  LYS A  12      32.114  75.970   0.557  1.00  0.00           C  
ATOM    140  NZ  LYS A  12      32.439  75.326   1.860  1.00  0.00           N  
ATOM    141  H   LYS A  12      36.309  79.445  -2.291  1.00  0.00           H  
ATOM    142  HA  LYS A  12      35.781  79.322   0.317  1.00  0.00           H  
ATOM    143  HB2 LYS A  12      34.790  77.959  -1.682  1.00  0.00           H  
ATOM    144  HB3 LYS A  12      35.883  76.698  -1.129  1.00  0.00           H  
ATOM    145  HG2 LYS A  12      34.830  76.730   1.066  1.00  0.00           H  
ATOM    146  HG3 LYS A  12      33.746  78.017   0.534  1.00  0.00           H  
ATOM    147  HD2 LYS A  12      33.029  76.407  -1.317  1.00  0.00           H  
ATOM    148  HD3 LYS A  12      33.849  75.155  -0.380  1.00  0.00           H  
ATOM    149  HE2 LYS A  12      31.706  76.951   0.742  1.00  0.00           H  
ATOM    150  HE3 LYS A  12      31.383  75.367   0.040  1.00  0.00           H  
ATOM    151  HZ1 LYS A  12      31.636  75.422   2.515  1.00  0.00           H  
ATOM    152  HZ2 LYS A  12      33.273  75.779   2.285  1.00  0.00           H  
ATOM    153  HZ3 LYS A  12      32.639  74.316   1.720  1.00  0.00           H  
ATOM    154  N   PHE A  13      38.443  77.497  -0.272  1.00  0.00           N  
ATOM    155  CA  PHE A  13      39.586  76.844   0.356  1.00  0.00           C  
ATOM    156  C   PHE A  13      40.898  77.409  -0.183  1.00  0.00           C  
ATOM    157  O   PHE A  13      40.954  77.916  -1.303  1.00  0.00           O  
ATOM    158  CB  PHE A  13      39.533  75.334   0.118  1.00  0.00           C  
ATOM    159  CG  PHE A  13      38.166  74.743   0.320  1.00  0.00           C  
ATOM    160  CD1 PHE A  13      37.692  74.484   1.596  1.00  0.00           C  
ATOM    161  CD2 PHE A  13      37.358  74.448  -0.765  1.00  0.00           C  
ATOM    162  CE1 PHE A  13      36.435  73.939   1.784  1.00  0.00           C  
ATOM    163  CE2 PHE A  13      36.099  73.905  -0.582  1.00  0.00           C  
ATOM    164  CZ  PHE A  13      35.638  73.650   0.694  1.00  0.00           C  
ATOM    165  H   PHE A  13      38.415  77.579  -1.248  1.00  0.00           H  
ATOM    166  HA  PHE A  13      39.535  77.035   1.417  1.00  0.00           H  
ATOM    167  HB2 PHE A  13      39.837  75.125  -0.897  1.00  0.00           H  
ATOM    168  HB3 PHE A  13      40.212  74.845   0.800  1.00  0.00           H  
ATOM    169  HD1 PHE A  13      38.314  74.709   2.449  1.00  0.00           H  
ATOM    170  HD2 PHE A  13      37.717  74.647  -1.765  1.00  0.00           H  
ATOM    171  HE1 PHE A  13      36.076  73.742   2.783  1.00  0.00           H  
ATOM    172  HE2 PHE A  13      35.479  73.681  -1.438  1.00  0.00           H  
ATOM    173  HZ  PHE A  13      34.656  73.226   0.839  1.00  0.00           H  
ATOM    174  N   ALA A  14      41.950  77.317   0.624  1.00  0.00           N  
ATOM    175  CA  ALA A  14      43.261  77.818   0.229  1.00  0.00           C  
ATOM    176  C   ALA A  14      44.181  76.676  -0.189  1.00  0.00           C  
ATOM    177  O   ALA A  14      43.856  75.504   0.001  1.00  0.00           O  
ATOM    178  CB  ALA A  14      43.886  78.615   1.365  1.00  0.00           C  
ATOM    179  H   ALA A  14      41.842  76.904   1.505  1.00  0.00           H  
ATOM    180  HA  ALA A  14      43.125  78.483  -0.612  1.00  0.00           H  
ATOM    181  HB1 ALA A  14      43.765  78.073   2.291  1.00  0.00           H  
ATOM    182  HB2 ALA A  14      44.938  78.759   1.167  1.00  0.00           H  
ATOM    183  HB3 ALA A  14      43.399  79.575   1.442  1.00  0.00           H  
ATOM    184  N   ASP A  15      45.330  77.025  -0.758  1.00  0.00           N  
ATOM    185  CA  ASP A  15      46.297  76.029  -1.201  1.00  0.00           C  
ATOM    186  C   ASP A  15      47.064  75.450  -0.016  1.00  0.00           C  
ATOM    187  O   ASP A  15      47.667  76.185   0.765  1.00  0.00           O  
ATOM    188  CB  ASP A  15      47.274  76.647  -2.205  1.00  0.00           C  
ATOM    189  CG  ASP A  15      47.732  78.031  -1.789  1.00  0.00           C  
ATOM    190  OD1 ASP A  15      46.903  78.963  -1.815  1.00  0.00           O  
ATOM    191  OD2 ASP A  15      48.922  78.181  -1.437  1.00  0.00           O  
ATOM    192  H   ASP A  15      45.531  77.978  -0.881  1.00  0.00           H  
ATOM    193  HA  ASP A  15      45.755  75.232  -1.686  1.00  0.00           H  
ATOM    194  HB2 ASP A  15      48.142  76.011  -2.290  1.00  0.00           H  
ATOM    195  HB3 ASP A  15      46.791  76.721  -3.168  1.00  0.00           H  
ATOM    196  N   GLY A  16      47.036  74.128   0.111  1.00  0.00           N  
ATOM    197  CA  GLY A  16      47.730  73.473   1.205  1.00  0.00           C  
ATOM    198  C   GLY A  16      46.828  73.218   2.395  1.00  0.00           C  
ATOM    199  O   GLY A  16      47.034  72.265   3.145  1.00  0.00           O  
ATOM    200  H   GLY A  16      46.539  73.592  -0.541  1.00  0.00           H  
ATOM    201  HA2 GLY A  16      48.122  72.530   0.854  1.00  0.00           H  
ATOM    202  HA3 GLY A  16      48.553  74.099   1.519  1.00  0.00           H  
ATOM    203  N   GLU A  17      45.827  74.074   2.571  1.00  0.00           N  
ATOM    204  CA  GLU A  17      44.891  73.938   3.681  1.00  0.00           C  
ATOM    205  C   GLU A  17      44.403  72.497   3.807  1.00  0.00           C  
ATOM    206  O   GLU A  17      44.158  71.823   2.807  1.00  0.00           O  
ATOM    207  CB  GLU A  17      43.699  74.878   3.492  1.00  0.00           C  
ATOM    208  CG  GLU A  17      42.991  75.231   4.788  1.00  0.00           C  
ATOM    209  CD  GLU A  17      43.935  75.797   5.832  1.00  0.00           C  
ATOM    210  OE1 GLU A  17      44.877  76.521   5.451  1.00  0.00           O  
ATOM    211  OE2 GLU A  17      43.730  75.514   7.032  1.00  0.00           O  
ATOM    212  H   GLU A  17      45.714  74.815   1.939  1.00  0.00           H  
ATOM    213  HA  GLU A  17      45.411  74.209   4.587  1.00  0.00           H  
ATOM    214  HB2 GLU A  17      44.045  75.791   3.033  1.00  0.00           H  
ATOM    215  HB3 GLU A  17      42.984  74.403   2.834  1.00  0.00           H  
ATOM    216  HG2 GLU A  17      42.230  75.967   4.579  1.00  0.00           H  
ATOM    217  HG3 GLU A  17      42.529  74.341   5.187  1.00  0.00           H  
ATOM    218  N   VAL A  18      44.264  72.031   5.044  1.00  0.00           N  
ATOM    219  CA  VAL A  18      43.805  70.672   5.302  1.00  0.00           C  
ATOM    220  C   VAL A  18      42.312  70.645   5.610  1.00  0.00           C  
ATOM    221  O   VAL A  18      41.884  71.031   6.697  1.00  0.00           O  
ATOM    222  CB  VAL A  18      44.571  70.033   6.476  1.00  0.00           C  
ATOM    223  CG1 VAL A  18      44.115  68.600   6.696  1.00  0.00           C  
ATOM    224  CG2 VAL A  18      46.071  70.092   6.228  1.00  0.00           C  
ATOM    225  H   VAL A  18      44.476  72.616   5.802  1.00  0.00           H  
ATOM    226  HA  VAL A  18      43.992  70.082   4.416  1.00  0.00           H  
ATOM    227  HB  VAL A  18      44.353  70.598   7.371  1.00  0.00           H  
ATOM    228 HG11 VAL A  18      44.725  68.140   7.460  1.00  0.00           H  
ATOM    229 HG12 VAL A  18      43.081  68.594   7.009  1.00  0.00           H  
ATOM    230 HG13 VAL A  18      44.214  68.045   5.775  1.00  0.00           H  
ATOM    231 HG21 VAL A  18      46.452  71.048   6.557  1.00  0.00           H  
ATOM    232 HG22 VAL A  18      46.559  69.301   6.779  1.00  0.00           H  
ATOM    233 HG23 VAL A  18      46.267  69.969   5.174  1.00  0.00           H  
ATOM    234  N   VAL A  19      41.523  70.185   4.643  1.00  0.00           N  
ATOM    235  CA  VAL A  19      40.077  70.106   4.810  1.00  0.00           C  
ATOM    236  C   VAL A  19      39.588  68.668   4.689  1.00  0.00           C  
ATOM    237  O   VAL A  19      40.364  67.761   4.388  1.00  0.00           O  
ATOM    238  CB  VAL A  19      39.344  70.976   3.772  1.00  0.00           C  
ATOM    239  CG1 VAL A  19      39.847  72.410   3.825  1.00  0.00           C  
ATOM    240  CG2 VAL A  19      39.512  70.394   2.376  1.00  0.00           C  
ATOM    241  H   VAL A  19      41.923  69.892   3.798  1.00  0.00           H  
ATOM    242  HA  VAL A  19      39.834  70.478   5.795  1.00  0.00           H  
ATOM    243  HB  VAL A  19      38.290  70.978   4.013  1.00  0.00           H  
ATOM    244 HG11 VAL A  19      39.221  72.986   4.490  1.00  0.00           H  
ATOM    245 HG12 VAL A  19      40.865  72.422   4.185  1.00  0.00           H  
ATOM    246 HG13 VAL A  19      39.811  72.841   2.835  1.00  0.00           H  
ATOM    247 HG21 VAL A  19      39.345  71.168   1.642  1.00  0.00           H  
ATOM    248 HG22 VAL A  19      40.514  70.005   2.267  1.00  0.00           H  
ATOM    249 HG23 VAL A  19      38.799  69.597   2.229  1.00  0.00           H  
ATOM    250  N   ARG A  20      38.296  68.466   4.925  1.00  0.00           N  
ATOM    251  CA  ARG A  20      37.702  67.137   4.844  1.00  0.00           C  
ATOM    252  C   ARG A  20      37.038  66.920   3.486  1.00  0.00           C  
ATOM    253  O   ARG A  20      36.114  67.642   3.114  1.00  0.00           O  
ATOM    254  CB  ARG A  20      36.676  66.944   5.962  1.00  0.00           C  
ATOM    255  CG  ARG A  20      37.197  67.322   7.338  1.00  0.00           C  
ATOM    256  CD  ARG A  20      38.088  66.233   7.916  1.00  0.00           C  
ATOM    257  NE  ARG A  20      38.406  66.475   9.320  1.00  0.00           N  
ATOM    258  CZ  ARG A  20      37.560  66.238  10.317  1.00  0.00           C  
ATOM    259  NH1 ARG A  20      36.351  65.755  10.064  1.00  0.00           N  
ATOM    260  NH2 ARG A  20      37.922  66.482  11.569  1.00  0.00           N  
ATOM    261  H   ARG A  20      37.728  69.229   5.160  1.00  0.00           H  
ATOM    262  HA  ARG A  20      38.493  66.412   4.963  1.00  0.00           H  
ATOM    263  HB2 ARG A  20      35.810  67.552   5.749  1.00  0.00           H  
ATOM    264  HB3 ARG A  20      36.380  65.906   5.985  1.00  0.00           H  
ATOM    265  HG2 ARG A  20      37.770  68.234   7.257  1.00  0.00           H  
ATOM    266  HG3 ARG A  20      36.359  67.478   8.000  1.00  0.00           H  
ATOM    267  HD2 ARG A  20      37.578  65.286   7.830  1.00  0.00           H  
ATOM    268  HD3 ARG A  20      39.006  66.200   7.348  1.00  0.00           H  
ATOM    269  HE  ARG A  20      39.294  66.831   9.530  1.00  0.00           H  
ATOM    270 HH11 ARG A  20      36.076  65.569   9.121  1.00  0.00           H  
ATOM    271 HH12 ARG A  20      35.717  65.576  10.816  1.00  0.00           H  
ATOM    272 HH21 ARG A  20      38.833  66.846  11.764  1.00  0.00           H  
ATOM    273 HH22 ARG A  20      37.286  66.304  12.318  1.00  0.00           H  
ATOM    274  N   GLY A  21      37.516  65.921   2.752  1.00  0.00           N  
ATOM    275  CA  GLY A  21      36.958  65.628   1.444  1.00  0.00           C  
ATOM    276  C   GLY A  21      36.188  64.323   1.422  1.00  0.00           C  
ATOM    277  O   GLY A  21      36.589  63.347   2.058  1.00  0.00           O  
ATOM    278  H   GLY A  21      38.254  65.378   3.100  1.00  0.00           H  
ATOM    279  HA2 GLY A  21      36.294  66.431   1.161  1.00  0.00           H  
ATOM    280  HA3 GLY A  21      37.763  65.570   0.726  1.00  0.00           H  
ATOM    281  N   ARG A  22      35.079  64.304   0.690  1.00  0.00           N  
ATOM    282  CA  ARG A  22      34.250  63.108   0.589  1.00  0.00           C  
ATOM    283  C   ARG A  22      34.696  62.234  -0.578  1.00  0.00           C  
ATOM    284  O   ARG A  22      34.407  62.533  -1.737  1.00  0.00           O  
ATOM    285  CB  ARG A  22      32.779  63.495   0.419  1.00  0.00           C  
ATOM    286  CG  ARG A  22      31.819  62.332   0.605  1.00  0.00           C  
ATOM    287  CD  ARG A  22      30.374  62.771   0.429  1.00  0.00           C  
ATOM    288  NE  ARG A  22      29.440  61.855   1.079  1.00  0.00           N  
ATOM    289  CZ  ARG A  22      28.137  61.831   0.828  1.00  0.00           C  
ATOM    290  NH1 ARG A  22      27.615  62.669  -0.057  1.00  0.00           N  
ATOM    291  NH2 ARG A  22      27.352  60.968   1.461  1.00  0.00           N  
ATOM    292  H   ARG A  22      34.812  65.113   0.205  1.00  0.00           H  
ATOM    293  HA  ARG A  22      34.362  62.549   1.506  1.00  0.00           H  
ATOM    294  HB2 ARG A  22      32.533  64.257   1.145  1.00  0.00           H  
ATOM    295  HB3 ARG A  22      32.639  63.895  -0.573  1.00  0.00           H  
ATOM    296  HG2 ARG A  22      32.045  61.570  -0.126  1.00  0.00           H  
ATOM    297  HG3 ARG A  22      31.945  61.929   1.600  1.00  0.00           H  
ATOM    298  HD2 ARG A  22      30.255  63.755   0.857  1.00  0.00           H  
ATOM    299  HD3 ARG A  22      30.149  62.808  -0.627  1.00  0.00           H  
ATOM    300  HE  ARG A  22      29.805  61.226   1.737  1.00  0.00           H  
ATOM    301 HH11 ARG A  22      28.203  63.320  -0.536  1.00  0.00           H  
ATOM    302 HH12 ARG A  22      26.633  62.650  -0.246  1.00  0.00           H  
ATOM    303 HH21 ARG A  22      27.742  60.336   2.128  1.00  0.00           H  
ATOM    304 HH22 ARG A  22      26.371  60.952   1.270  1.00  0.00           H  
ATOM    305  N   TRP A  23      35.401  61.152  -0.265  1.00  0.00           N  
ATOM    306  CA  TRP A  23      35.888  60.235  -1.289  1.00  0.00           C  
ATOM    307  C   TRP A  23      34.735  59.699  -2.131  1.00  0.00           C  
ATOM    308  O   TRP A  23      33.650  59.405  -1.628  1.00  0.00           O  
ATOM    309  CB  TRP A  23      36.646  59.075  -0.644  1.00  0.00           C  
ATOM    310  CG  TRP A  23      37.163  58.077  -1.637  1.00  0.00           C  
ATOM    311  CD1 TRP A  23      36.432  57.156  -2.329  1.00  0.00           C  
ATOM    312  CD2 TRP A  23      38.524  57.902  -2.044  1.00  0.00           C  
ATOM    313  NE1 TRP A  23      37.257  56.417  -3.144  1.00  0.00           N  
ATOM    314  CE2 TRP A  23      38.545  56.856  -2.988  1.00  0.00           C  
ATOM    315  CE3 TRP A  23      39.728  58.527  -1.706  1.00  0.00           C  
ATOM    316  CZ2 TRP A  23      39.721  56.423  -3.595  1.00  0.00           C  
ATOM    317  CZ3 TRP A  23      40.894  58.096  -2.308  1.00  0.00           C  
ATOM    318  CH2 TRP A  23      40.885  57.053  -3.245  1.00  0.00           C  
ATOM    319  H   TRP A  23      35.600  60.967   0.677  1.00  0.00           H  
ATOM    320  HA  TRP A  23      36.562  60.782  -1.930  1.00  0.00           H  
ATOM    321  HB2 TRP A  23      37.490  59.465  -0.094  1.00  0.00           H  
ATOM    322  HB3 TRP A  23      35.986  58.556   0.037  1.00  0.00           H  
ATOM    323  HD1 TRP A  23      35.363  57.035  -2.239  1.00  0.00           H  
ATOM    324  HE1 TRP A  23      36.967  55.696  -3.741  1.00  0.00           H  
ATOM    325  HE3 TRP A  23      39.756  59.332  -0.987  1.00  0.00           H  
ATOM    326  HZ2 TRP A  23      39.729  55.621  -4.319  1.00  0.00           H  
ATOM    327  HZ3 TRP A  23      41.834  58.567  -2.059  1.00  0.00           H  
ATOM    328  HH2 TRP A  23      41.819  56.750  -3.690  1.00  0.00           H  
ATOM    329  N   PRO A  24      34.971  59.567  -3.445  1.00  0.00           N  
ATOM    330  CA  PRO A  24      33.965  59.064  -4.385  1.00  0.00           C  
ATOM    331  C   PRO A  24      33.678  57.580  -4.187  1.00  0.00           C  
ATOM    332  O   PRO A  24      34.537  56.734  -4.430  1.00  0.00           O  
ATOM    333  CB  PRO A  24      34.604  59.308  -5.754  1.00  0.00           C  
ATOM    334  CG  PRO A  24      36.071  59.317  -5.491  1.00  0.00           C  
ATOM    335  CD  PRO A  24      36.241  59.897  -4.114  1.00  0.00           C  
ATOM    336  HA  PRO A  24      33.042  59.622  -4.311  1.00  0.00           H  
ATOM    337  HB2 PRO A  24      34.328  58.512  -6.430  1.00  0.00           H  
ATOM    338  HB3 PRO A  24      34.269  60.255  -6.148  1.00  0.00           H  
ATOM    339  HG2 PRO A  24      36.455  58.309  -5.523  1.00  0.00           H  
ATOM    340  HG3 PRO A  24      36.571  59.935  -6.223  1.00  0.00           H  
ATOM    341  HD2 PRO A  24      37.076  59.433  -3.609  1.00  0.00           H  
ATOM    342  HD3 PRO A  24      36.379  60.967  -4.170  1.00  0.00           H  
ATOM    343  N   GLY A  25      32.462  57.271  -3.747  1.00  0.00           N  
ATOM    344  CA  GLY A  25      32.083  55.887  -3.525  1.00  0.00           C  
ATOM    345  C   GLY A  25      32.004  55.536  -2.052  1.00  0.00           C  
ATOM    346  O   GLY A  25      31.131  54.776  -1.635  1.00  0.00           O  
ATOM    347  H   GLY A  25      31.817  57.987  -3.570  1.00  0.00           H  
ATOM    348  HA2 GLY A  25      31.119  55.712  -3.978  1.00  0.00           H  
ATOM    349  HA3 GLY A  25      32.814  55.246  -3.997  1.00  0.00           H  
ATOM    350  N   SER A  26      32.919  56.091  -1.264  1.00  0.00           N  
ATOM    351  CA  SER A  26      32.952  55.828   0.171  1.00  0.00           C  
ATOM    352  C   SER A  26      31.936  56.698   0.906  1.00  0.00           C  
ATOM    353  O   SER A  26      31.505  56.368   2.010  1.00  0.00           O  
ATOM    354  CB  SER A  26      34.354  56.084   0.725  1.00  0.00           C  
ATOM    355  OG  SER A  26      34.623  55.250   1.839  1.00  0.00           O  
ATOM    356  H   SER A  26      33.588  56.689  -1.655  1.00  0.00           H  
ATOM    357  HA  SER A  26      32.697  54.791   0.324  1.00  0.00           H  
ATOM    358  HB2 SER A  26      35.085  55.884  -0.044  1.00  0.00           H  
ATOM    359  HB3 SER A  26      34.433  57.117   1.036  1.00  0.00           H  
ATOM    360  HG  SER A  26      34.945  54.400   1.532  1.00  0.00           H  
ATOM    361  N   SER A  27      31.558  57.810   0.284  1.00  0.00           N  
ATOM    362  CA  SER A  27      30.596  58.730   0.880  1.00  0.00           C  
ATOM    363  C   SER A  27      31.008  59.101   2.301  1.00  0.00           C  
ATOM    364  O   SER A  27      30.162  59.320   3.168  1.00  0.00           O  
ATOM    365  CB  SER A  27      29.200  58.104   0.890  1.00  0.00           C  
ATOM    366  OG  SER A  27      29.147  56.985   1.758  1.00  0.00           O  
ATOM    367  H   SER A  27      31.937  58.018  -0.595  1.00  0.00           H  
ATOM    368  HA  SER A  27      30.576  59.625   0.278  1.00  0.00           H  
ATOM    369  HB2 SER A  27      28.481  58.838   1.222  1.00  0.00           H  
ATOM    370  HB3 SER A  27      28.946  57.781  -0.110  1.00  0.00           H  
ATOM    371  HG  SER A  27      29.819  57.076   2.438  1.00  0.00           H  
ATOM    372  N   LEU A  28      32.314  59.172   2.532  1.00  0.00           N  
ATOM    373  CA  LEU A  28      32.840  59.517   3.847  1.00  0.00           C  
ATOM    374  C   LEU A  28      33.883  60.626   3.742  1.00  0.00           C  
ATOM    375  O   LEU A  28      34.741  60.604   2.860  1.00  0.00           O  
ATOM    376  CB  LEU A  28      33.457  58.285   4.512  1.00  0.00           C  
ATOM    377  CG  LEU A  28      32.472  57.216   4.989  1.00  0.00           C  
ATOM    378  CD1 LEU A  28      33.218  55.995   5.503  1.00  0.00           C  
ATOM    379  CD2 LEU A  28      31.556  57.778   6.066  1.00  0.00           C  
ATOM    380  H   LEU A  28      32.940  58.987   1.802  1.00  0.00           H  
ATOM    381  HA  LEU A  28      32.018  59.868   4.452  1.00  0.00           H  
ATOM    382  HB2 LEU A  28      34.125  57.824   3.800  1.00  0.00           H  
ATOM    383  HB3 LEU A  28      34.023  58.620   5.370  1.00  0.00           H  
ATOM    384  HG  LEU A  28      31.858  56.905   4.155  1.00  0.00           H  
ATOM    385 HD11 LEU A  28      33.862  55.612   4.725  1.00  0.00           H  
ATOM    386 HD12 LEU A  28      32.507  55.233   5.788  1.00  0.00           H  
ATOM    387 HD13 LEU A  28      33.813  56.272   6.361  1.00  0.00           H  
ATOM    388 HD21 LEU A  28      31.424  57.041   6.845  1.00  0.00           H  
ATOM    389 HD22 LEU A  28      30.597  58.019   5.633  1.00  0.00           H  
ATOM    390 HD23 LEU A  28      31.998  58.669   6.485  1.00  0.00           H  
ATOM    391  N   TYR A  29      33.802  61.594   4.649  1.00  0.00           N  
ATOM    392  CA  TYR A  29      34.737  62.713   4.659  1.00  0.00           C  
ATOM    393  C   TYR A  29      36.042  62.326   5.350  1.00  0.00           C  
ATOM    394  O   TYR A  29      36.040  61.878   6.497  1.00  0.00           O  
ATOM    395  CB  TYR A  29      34.114  63.920   5.359  1.00  0.00           C  
ATOM    396  CG  TYR A  29      32.865  64.435   4.682  1.00  0.00           C  
ATOM    397  CD1 TYR A  29      32.945  65.246   3.556  1.00  0.00           C  
ATOM    398  CD2 TYR A  29      31.603  64.112   5.167  1.00  0.00           C  
ATOM    399  CE1 TYR A  29      31.806  65.719   2.933  1.00  0.00           C  
ATOM    400  CE2 TYR A  29      30.459  64.580   4.550  1.00  0.00           C  
ATOM    401  CZ  TYR A  29      30.566  65.384   3.434  1.00  0.00           C  
ATOM    402  OH  TYR A  29      29.429  65.852   2.817  1.00  0.00           O  
ATOM    403  H   TYR A  29      33.096  61.556   5.328  1.00  0.00           H  
ATOM    404  HA  TYR A  29      34.952  62.975   3.633  1.00  0.00           H  
ATOM    405  HB2 TYR A  29      33.854  63.647   6.371  1.00  0.00           H  
ATOM    406  HB3 TYR A  29      34.834  64.725   5.384  1.00  0.00           H  
ATOM    407  HD1 TYR A  29      33.918  65.507   3.166  1.00  0.00           H  
ATOM    408  HD2 TYR A  29      31.523  63.483   6.042  1.00  0.00           H  
ATOM    409  HE1 TYR A  29      31.889  66.348   2.059  1.00  0.00           H  
ATOM    410  HE2 TYR A  29      29.488  64.318   4.942  1.00  0.00           H  
ATOM    411  HH  TYR A  29      29.661  66.244   1.972  1.00  0.00           H  
ATOM    412  N   TYR A  30      37.152  62.503   4.645  1.00  0.00           N  
ATOM    413  CA  TYR A  30      38.465  62.172   5.188  1.00  0.00           C  
ATOM    414  C   TYR A  30      39.386  63.389   5.168  1.00  0.00           C  
ATOM    415  O   TYR A  30      39.127  64.364   4.464  1.00  0.00           O  
ATOM    416  CB  TYR A  30      39.095  61.028   4.393  1.00  0.00           C  
ATOM    417  CG  TYR A  30      38.322  59.731   4.482  1.00  0.00           C  
ATOM    418  CD1 TYR A  30      38.485  58.876   5.565  1.00  0.00           C  
ATOM    419  CD2 TYR A  30      37.431  59.361   3.482  1.00  0.00           C  
ATOM    420  CE1 TYR A  30      37.781  57.690   5.650  1.00  0.00           C  
ATOM    421  CE2 TYR A  30      36.723  58.177   3.560  1.00  0.00           C  
ATOM    422  CZ  TYR A  30      36.901  57.345   4.645  1.00  0.00           C  
ATOM    423  OH  TYR A  30      36.198  56.165   4.725  1.00  0.00           O  
ATOM    424  H   TYR A  30      37.090  62.864   3.735  1.00  0.00           H  
ATOM    425  HA  TYR A  30      38.329  61.854   6.211  1.00  0.00           H  
ATOM    426  HB2 TYR A  30      39.151  61.309   3.353  1.00  0.00           H  
ATOM    427  HB3 TYR A  30      40.093  60.847   4.766  1.00  0.00           H  
ATOM    428  HD1 TYR A  30      39.174  59.148   6.350  1.00  0.00           H  
ATOM    429  HD2 TYR A  30      37.294  60.015   2.633  1.00  0.00           H  
ATOM    430  HE1 TYR A  30      37.920  57.038   6.500  1.00  0.00           H  
ATOM    431  HE2 TYR A  30      36.034  57.908   2.773  1.00  0.00           H  
ATOM    432  HH  TYR A  30      36.672  55.478   4.251  1.00  0.00           H  
ATOM    433  N   GLU A  31      40.462  63.320   5.945  1.00  0.00           N  
ATOM    434  CA  GLU A  31      41.422  64.416   6.016  1.00  0.00           C  
ATOM    435  C   GLU A  31      42.262  64.487   4.744  1.00  0.00           C  
ATOM    436  O   GLU A  31      43.134  63.648   4.514  1.00  0.00           O  
ATOM    437  CB  GLU A  31      42.333  64.246   7.233  1.00  0.00           C  
ATOM    438  CG  GLU A  31      43.442  65.282   7.313  1.00  0.00           C  
ATOM    439  CD  GLU A  31      44.259  65.165   8.584  1.00  0.00           C  
ATOM    440  OE1 GLU A  31      43.682  64.807   9.632  1.00  0.00           O  
ATOM    441  OE2 GLU A  31      45.480  65.430   8.532  1.00  0.00           O  
ATOM    442  H   GLU A  31      40.614  62.515   6.482  1.00  0.00           H  
ATOM    443  HA  GLU A  31      40.868  65.336   6.118  1.00  0.00           H  
ATOM    444  HB2 GLU A  31      41.734  64.320   8.129  1.00  0.00           H  
ATOM    445  HB3 GLU A  31      42.787  63.266   7.194  1.00  0.00           H  
ATOM    446  HG2 GLU A  31      44.101  65.151   6.467  1.00  0.00           H  
ATOM    447  HG3 GLU A  31      43.001  66.266   7.276  1.00  0.00           H  
ATOM    448  N   VAL A  32      41.994  65.494   3.919  1.00  0.00           N  
ATOM    449  CA  VAL A  32      42.724  65.676   2.671  1.00  0.00           C  
ATOM    450  C   VAL A  32      43.311  67.080   2.577  1.00  0.00           C  
ATOM    451  O   VAL A  32      42.877  67.992   3.282  1.00  0.00           O  
ATOM    452  CB  VAL A  32      41.820  65.427   1.450  1.00  0.00           C  
ATOM    453  CG1 VAL A  32      41.292  64.001   1.460  1.00  0.00           C  
ATOM    454  CG2 VAL A  32      40.675  66.429   1.421  1.00  0.00           C  
ATOM    455  H   VAL A  32      41.287  66.131   4.157  1.00  0.00           H  
ATOM    456  HA  VAL A  32      43.530  64.958   2.649  1.00  0.00           H  
ATOM    457  HB  VAL A  32      42.411  65.562   0.556  1.00  0.00           H  
ATOM    458 HG11 VAL A  32      40.328  63.970   0.972  1.00  0.00           H  
ATOM    459 HG12 VAL A  32      41.982  63.357   0.935  1.00  0.00           H  
ATOM    460 HG13 VAL A  32      41.187  63.663   2.480  1.00  0.00           H  
ATOM    461 HG21 VAL A  32      40.006  66.232   2.246  1.00  0.00           H  
ATOM    462 HG22 VAL A  32      41.070  67.430   1.510  1.00  0.00           H  
ATOM    463 HG23 VAL A  32      40.137  66.335   0.490  1.00  0.00           H  
ATOM    464  N   GLU A  33      44.297  67.247   1.702  1.00  0.00           N  
ATOM    465  CA  GLU A  33      44.943  68.541   1.516  1.00  0.00           C  
ATOM    466  C   GLU A  33      44.569  69.148   0.167  1.00  0.00           C  
ATOM    467  O   GLU A  33      44.329  68.428  -0.803  1.00  0.00           O  
ATOM    468  CB  GLU A  33      46.463  68.397   1.619  1.00  0.00           C  
ATOM    469  CG  GLU A  33      47.227  69.544   0.979  1.00  0.00           C  
ATOM    470  CD  GLU A  33      48.709  69.504   1.294  1.00  0.00           C  
ATOM    471  OE1 GLU A  33      49.298  68.404   1.239  1.00  0.00           O  
ATOM    472  OE2 GLU A  33      49.281  70.572   1.597  1.00  0.00           O  
ATOM    473  H   GLU A  33      44.598  66.482   1.169  1.00  0.00           H  
ATOM    474  HA  GLU A  33      44.598  69.199   2.300  1.00  0.00           H  
ATOM    475  HB2 GLU A  33      46.737  68.347   2.662  1.00  0.00           H  
ATOM    476  HB3 GLU A  33      46.758  67.479   1.134  1.00  0.00           H  
ATOM    477  HG2 GLU A  33      47.101  69.490  -0.092  1.00  0.00           H  
ATOM    478  HG3 GLU A  33      46.822  70.477   1.341  1.00  0.00           H  
ATOM    479  N   ILE A  34      44.520  70.474   0.114  1.00  0.00           N  
ATOM    480  CA  ILE A  34      44.176  71.177  -1.116  1.00  0.00           C  
ATOM    481  C   ILE A  34      45.395  71.336  -2.018  1.00  0.00           C  
ATOM    482  O   ILE A  34      46.412  71.901  -1.611  1.00  0.00           O  
ATOM    483  CB  ILE A  34      43.582  72.567  -0.823  1.00  0.00           C  
ATOM    484  CG1 ILE A  34      42.351  72.441   0.077  1.00  0.00           C  
ATOM    485  CG2 ILE A  34      43.226  73.276  -2.121  1.00  0.00           C  
ATOM    486  CD1 ILE A  34      41.164  71.803  -0.610  1.00  0.00           C  
ATOM    487  H   ILE A  34      44.721  70.993   0.920  1.00  0.00           H  
ATOM    488  HA  ILE A  34      43.430  70.592  -1.636  1.00  0.00           H  
ATOM    489  HB  ILE A  34      44.333  73.155  -0.315  1.00  0.00           H  
ATOM    490 HG12 ILE A  34      42.601  71.839   0.935  1.00  0.00           H  
ATOM    491 HG13 ILE A  34      42.055  73.426   0.408  1.00  0.00           H  
ATOM    492 HG21 ILE A  34      43.846  72.895  -2.921  1.00  0.00           H  
ATOM    493 HG22 ILE A  34      42.188  73.098  -2.355  1.00  0.00           H  
ATOM    494 HG23 ILE A  34      43.394  74.336  -2.010  1.00  0.00           H  
ATOM    495 HD11 ILE A  34      40.709  71.082   0.053  1.00  0.00           H  
ATOM    496 HD12 ILE A  34      40.443  72.565  -0.866  1.00  0.00           H  
ATOM    497 HD13 ILE A  34      41.495  71.304  -1.510  1.00  0.00           H  
ATOM    498  N   LEU A  35      45.286  70.838  -3.245  1.00  0.00           N  
ATOM    499  CA  LEU A  35      46.380  70.926  -4.205  1.00  0.00           C  
ATOM    500  C   LEU A  35      46.072  71.957  -5.287  1.00  0.00           C  
ATOM    501  O   LEU A  35      46.875  72.852  -5.552  1.00  0.00           O  
ATOM    502  CB  LEU A  35      46.634  69.561  -4.846  1.00  0.00           C  
ATOM    503  CG  LEU A  35      46.709  68.373  -3.885  1.00  0.00           C  
ATOM    504  CD1 LEU A  35      46.780  67.065  -4.658  1.00  0.00           C  
ATOM    505  CD2 LEU A  35      47.908  68.512  -2.958  1.00  0.00           C  
ATOM    506  H   LEU A  35      44.452  70.399  -3.510  1.00  0.00           H  
ATOM    507  HA  LEU A  35      47.266  71.235  -3.672  1.00  0.00           H  
ATOM    508  HB2 LEU A  35      45.835  69.369  -5.545  1.00  0.00           H  
ATOM    509  HB3 LEU A  35      47.572  69.616  -5.379  1.00  0.00           H  
ATOM    510  HG  LEU A  35      45.815  68.352  -3.278  1.00  0.00           H  
ATOM    511 HD11 LEU A  35      46.012  66.395  -4.303  1.00  0.00           H  
ATOM    512 HD12 LEU A  35      47.749  66.612  -4.511  1.00  0.00           H  
ATOM    513 HD13 LEU A  35      46.631  67.260  -5.710  1.00  0.00           H  
ATOM    514 HD21 LEU A  35      48.656  69.133  -3.428  1.00  0.00           H  
ATOM    515 HD22 LEU A  35      48.325  67.535  -2.760  1.00  0.00           H  
ATOM    516 HD23 LEU A  35      47.593  68.965  -2.030  1.00  0.00           H  
ATOM    517  N   SER A  36      44.903  71.827  -5.906  1.00  0.00           N  
ATOM    518  CA  SER A  36      44.490  72.746  -6.960  1.00  0.00           C  
ATOM    519  C   SER A  36      42.971  72.891  -6.990  1.00  0.00           C  
ATOM    520  O   SER A  36      42.254  72.170  -6.296  1.00  0.00           O  
ATOM    521  CB  SER A  36      44.994  72.259  -8.319  1.00  0.00           C  
ATOM    522  OG  SER A  36      45.188  73.343  -9.210  1.00  0.00           O  
ATOM    523  H   SER A  36      44.306  71.093  -5.649  1.00  0.00           H  
ATOM    524  HA  SER A  36      44.927  73.711  -6.748  1.00  0.00           H  
ATOM    525  HB2 SER A  36      45.933  71.744  -8.187  1.00  0.00           H  
ATOM    526  HB3 SER A  36      44.270  71.582  -8.747  1.00  0.00           H  
ATOM    527  HG  SER A  36      44.346  73.597  -9.595  1.00  0.00           H  
ATOM    528  N   HIS A  37      42.487  73.827  -7.800  1.00  0.00           N  
ATOM    529  CA  HIS A  37      41.054  74.065  -7.923  1.00  0.00           C  
ATOM    530  C   HIS A  37      40.676  74.377  -9.368  1.00  0.00           C  
ATOM    531  O   HIS A  37      41.046  75.423  -9.905  1.00  0.00           O  
ATOM    532  CB  HIS A  37      40.627  75.218  -7.012  1.00  0.00           C  
ATOM    533  CG  HIS A  37      39.388  75.919  -7.474  1.00  0.00           C  
ATOM    534  ND1 HIS A  37      38.231  75.253  -7.819  1.00  0.00           N  
ATOM    535  CD2 HIS A  37      39.128  77.237  -7.646  1.00  0.00           C  
ATOM    536  CE1 HIS A  37      37.313  76.131  -8.185  1.00  0.00           C  
ATOM    537  NE2 HIS A  37      37.832  77.342  -8.088  1.00  0.00           N  
ATOM    538  H   HIS A  37      43.109  74.368  -8.328  1.00  0.00           H  
ATOM    539  HA  HIS A  37      40.540  73.168  -7.616  1.00  0.00           H  
ATOM    540  HB2 HIS A  37      40.441  74.833  -6.020  1.00  0.00           H  
ATOM    541  HB3 HIS A  37      41.425  75.946  -6.967  1.00  0.00           H  
ATOM    542  HD1 HIS A  37      38.102  74.283  -7.800  1.00  0.00           H  
ATOM    543  HD2 HIS A  37      39.813  78.054  -7.470  1.00  0.00           H  
ATOM    544  HE1 HIS A  37      36.309  75.899  -8.506  1.00  0.00           H  
ATOM    545  HE2 HIS A  37      37.394  78.168  -8.380  1.00  0.00           H  
ATOM    546  N   ASP A  38      39.940  73.464  -9.992  1.00  0.00           N  
ATOM    547  CA  ASP A  38      39.512  73.642 -11.375  1.00  0.00           C  
ATOM    548  C   ASP A  38      38.165  74.356 -11.440  1.00  0.00           C  
ATOM    549  O   ASP A  38      37.175  73.883 -10.883  1.00  0.00           O  
ATOM    550  CB  ASP A  38      39.421  72.289 -12.080  1.00  0.00           C  
ATOM    551  CG  ASP A  38      40.785  71.697 -12.378  1.00  0.00           C  
ATOM    552  OD1 ASP A  38      41.640  71.692 -11.469  1.00  0.00           O  
ATOM    553  OD2 ASP A  38      40.997  71.241 -13.522  1.00  0.00           O  
ATOM    554  H   ASP A  38      39.677  72.652  -9.511  1.00  0.00           H  
ATOM    555  HA  ASP A  38      40.252  74.250 -11.875  1.00  0.00           H  
ATOM    556  HB2 ASP A  38      38.880  71.597 -11.451  1.00  0.00           H  
ATOM    557  HB3 ASP A  38      38.890  72.411 -13.013  1.00  0.00           H  
ATOM    558  N   SER A  39      38.139  75.496 -12.122  1.00  0.00           N  
ATOM    559  CA  SER A  39      36.915  76.278 -12.255  1.00  0.00           C  
ATOM    560  C   SER A  39      36.013  75.694 -13.340  1.00  0.00           C  
ATOM    561  O   SER A  39      34.787  75.730 -13.230  1.00  0.00           O  
ATOM    562  CB  SER A  39      37.248  77.735 -12.582  1.00  0.00           C  
ATOM    563  OG  SER A  39      36.194  78.599 -12.194  1.00  0.00           O  
ATOM    564  H   SER A  39      38.961  75.821 -12.544  1.00  0.00           H  
ATOM    565  HA  SER A  39      36.392  76.241 -11.311  1.00  0.00           H  
ATOM    566  HB2 SER A  39      38.145  78.023 -12.057  1.00  0.00           H  
ATOM    567  HB3 SER A  39      37.405  77.834 -13.647  1.00  0.00           H  
ATOM    568  HG  SER A  39      35.461  78.506 -12.807  1.00  0.00           H  
ATOM    569  N   THR A  40      36.629  75.158 -14.387  1.00  0.00           N  
ATOM    570  CA  THR A  40      35.886  74.568 -15.493  1.00  0.00           C  
ATOM    571  C   THR A  40      34.717  73.731 -14.984  1.00  0.00           C  
ATOM    572  O   THR A  40      33.571  73.940 -15.383  1.00  0.00           O  
ATOM    573  CB  THR A  40      36.790  73.684 -16.372  1.00  0.00           C  
ATOM    574  OG1 THR A  40      37.906  74.446 -16.847  1.00  0.00           O  
ATOM    575  CG2 THR A  40      36.015  73.120 -17.552  1.00  0.00           C  
ATOM    576  H   THR A  40      37.609  75.160 -14.417  1.00  0.00           H  
ATOM    577  HA  THR A  40      35.501  75.372 -16.103  1.00  0.00           H  
ATOM    578  HB  THR A  40      37.155  72.862 -15.773  1.00  0.00           H  
ATOM    579  HG1 THR A  40      38.723  74.028 -16.565  1.00  0.00           H  
ATOM    580 HG21 THR A  40      36.109  73.786 -18.397  1.00  0.00           H  
ATOM    581 HG22 THR A  40      34.972  73.024 -17.285  1.00  0.00           H  
ATOM    582 HG23 THR A  40      36.411  72.150 -17.813  1.00  0.00           H  
ATOM    583  N   SER A  41      35.014  72.783 -14.101  1.00  0.00           N  
ATOM    584  CA  SER A  41      33.988  71.913 -13.540  1.00  0.00           C  
ATOM    585  C   SER A  41      33.954  72.023 -12.018  1.00  0.00           C  
ATOM    586  O   SER A  41      33.498  71.110 -11.330  1.00  0.00           O  
ATOM    587  CB  SER A  41      34.239  70.461 -13.952  1.00  0.00           C  
ATOM    588  OG  SER A  41      33.982  70.272 -15.333  1.00  0.00           O  
ATOM    589  H   SER A  41      35.946  72.666 -13.822  1.00  0.00           H  
ATOM    590  HA  SER A  41      33.033  72.230 -13.933  1.00  0.00           H  
ATOM    591  HB2 SER A  41      35.268  70.206 -13.752  1.00  0.00           H  
ATOM    592  HB3 SER A  41      33.589  69.811 -13.384  1.00  0.00           H  
ATOM    593  HG  SER A  41      33.351  70.929 -15.635  1.00  0.00           H  
ATOM    594  N   GLN A  42      34.441  73.147 -11.502  1.00  0.00           N  
ATOM    595  CA  GLN A  42      34.468  73.376 -10.063  1.00  0.00           C  
ATOM    596  C   GLN A  42      34.994  72.149  -9.325  1.00  0.00           C  
ATOM    597  O   GLN A  42      34.541  71.831  -8.224  1.00  0.00           O  
ATOM    598  CB  GLN A  42      33.068  73.730  -9.554  1.00  0.00           C  
ATOM    599  CG  GLN A  42      32.565  75.076 -10.048  1.00  0.00           C  
ATOM    600  CD  GLN A  42      33.190  76.241  -9.306  1.00  0.00           C  
ATOM    601  OE1 GLN A  42      33.384  76.186  -8.092  1.00  0.00           O  
ATOM    602  NE2 GLN A  42      33.509  77.304 -10.035  1.00  0.00           N  
ATOM    603  H   GLN A  42      34.790  73.837 -12.103  1.00  0.00           H  
ATOM    604  HA  GLN A  42      35.131  74.207  -9.871  1.00  0.00           H  
ATOM    605  HB2 GLN A  42      32.377  72.968  -9.882  1.00  0.00           H  
ATOM    606  HB3 GLN A  42      33.085  73.749  -8.474  1.00  0.00           H  
ATOM    607  HG2 GLN A  42      32.799  75.171 -11.098  1.00  0.00           H  
ATOM    608  HG3 GLN A  42      31.494  75.115  -9.914  1.00  0.00           H  
ATOM    609 HE21 GLN A  42      33.325  77.277 -10.998  1.00  0.00           H  
ATOM    610 HE22 GLN A  42      33.913  78.072  -9.581  1.00  0.00           H  
ATOM    611  N   LEU A  43      35.952  71.462  -9.938  1.00  0.00           N  
ATOM    612  CA  LEU A  43      36.540  70.269  -9.340  1.00  0.00           C  
ATOM    613  C   LEU A  43      37.854  70.602  -8.640  1.00  0.00           C  
ATOM    614  O   LEU A  43      38.799  71.080  -9.267  1.00  0.00           O  
ATOM    615  CB  LEU A  43      36.776  69.202 -10.410  1.00  0.00           C  
ATOM    616  CG  LEU A  43      35.532  68.470 -10.914  1.00  0.00           C  
ATOM    617  CD1 LEU A  43      35.860  67.645 -12.149  1.00  0.00           C  
ATOM    618  CD2 LEU A  43      34.954  67.585  -9.818  1.00  0.00           C  
ATOM    619  H   LEU A  43      36.272  71.764 -10.814  1.00  0.00           H  
ATOM    620  HA  LEU A  43      35.844  69.887  -8.610  1.00  0.00           H  
ATOM    621  HB2 LEU A  43      37.243  69.681 -11.258  1.00  0.00           H  
ATOM    622  HB3 LEU A  43      37.451  68.464  -9.998  1.00  0.00           H  
ATOM    623  HG  LEU A  43      34.781  69.197 -11.189  1.00  0.00           H  
ATOM    624 HD11 LEU A  43      35.320  66.712 -12.113  1.00  0.00           H  
ATOM    625 HD12 LEU A  43      36.921  67.447 -12.177  1.00  0.00           H  
ATOM    626 HD13 LEU A  43      35.573  68.195 -13.035  1.00  0.00           H  
ATOM    627 HD21 LEU A  43      34.144  68.104  -9.328  1.00  0.00           H  
ATOM    628 HD22 LEU A  43      35.724  67.357  -9.097  1.00  0.00           H  
ATOM    629 HD23 LEU A  43      34.584  66.669 -10.253  1.00  0.00           H  
ATOM    630  N   TYR A  44      37.907  70.344  -7.338  1.00  0.00           N  
ATOM    631  CA  TYR A  44      39.104  70.616  -6.553  1.00  0.00           C  
ATOM    632  C   TYR A  44      39.988  69.375  -6.459  1.00  0.00           C  
ATOM    633  O   TYR A  44      39.505  68.272  -6.207  1.00  0.00           O  
ATOM    634  CB  TYR A  44      38.722  71.091  -5.150  1.00  0.00           C  
ATOM    635  CG  TYR A  44      38.268  72.532  -5.101  1.00  0.00           C  
ATOM    636  CD1 TYR A  44      37.058  72.919  -5.665  1.00  0.00           C  
ATOM    637  CD2 TYR A  44      39.049  73.507  -4.493  1.00  0.00           C  
ATOM    638  CE1 TYR A  44      36.640  74.235  -5.624  1.00  0.00           C  
ATOM    639  CE2 TYR A  44      38.637  74.825  -4.445  1.00  0.00           C  
ATOM    640  CZ  TYR A  44      37.432  75.184  -5.013  1.00  0.00           C  
ATOM    641  OH  TYR A  44      37.018  76.496  -4.970  1.00  0.00           O  
ATOM    642  H   TYR A  44      37.121  69.962  -6.894  1.00  0.00           H  
ATOM    643  HA  TYR A  44      39.655  71.400  -7.050  1.00  0.00           H  
ATOM    644  HB2 TYR A  44      37.917  70.477  -4.776  1.00  0.00           H  
ATOM    645  HB3 TYR A  44      39.577  70.990  -4.498  1.00  0.00           H  
ATOM    646  HD1 TYR A  44      36.440  72.173  -6.144  1.00  0.00           H  
ATOM    647  HD2 TYR A  44      39.992  73.223  -4.050  1.00  0.00           H  
ATOM    648  HE1 TYR A  44      35.695  74.517  -6.068  1.00  0.00           H  
ATOM    649  HE2 TYR A  44      39.257  75.568  -3.967  1.00  0.00           H  
ATOM    650  HH  TYR A  44      36.107  76.554  -5.264  1.00  0.00           H  
ATOM    651  N   THR A  45      41.287  69.566  -6.663  1.00  0.00           N  
ATOM    652  CA  THR A  45      42.240  68.465  -6.602  1.00  0.00           C  
ATOM    653  C   THR A  45      42.888  68.374  -5.225  1.00  0.00           C  
ATOM    654  O   THR A  45      43.741  69.190  -4.874  1.00  0.00           O  
ATOM    655  CB  THR A  45      43.343  68.616  -7.667  1.00  0.00           C  
ATOM    656  OG1 THR A  45      42.753  68.776  -8.962  1.00  0.00           O  
ATOM    657  CG2 THR A  45      44.264  67.405  -7.669  1.00  0.00           C  
ATOM    658  H   THR A  45      41.611  70.469  -6.860  1.00  0.00           H  
ATOM    659  HA  THR A  45      41.703  67.548  -6.798  1.00  0.00           H  
ATOM    660  HB  THR A  45      43.928  69.495  -7.436  1.00  0.00           H  
ATOM    661  HG1 THR A  45      42.329  67.955  -9.225  1.00  0.00           H  
ATOM    662 HG21 THR A  45      44.608  67.217  -8.675  1.00  0.00           H  
ATOM    663 HG22 THR A  45      43.725  66.543  -7.305  1.00  0.00           H  
ATOM    664 HG23 THR A  45      45.111  67.598  -7.028  1.00  0.00           H  
ATOM    665  N   VAL A  46      42.480  67.376  -4.448  1.00  0.00           N  
ATOM    666  CA  VAL A  46      43.023  67.177  -3.110  1.00  0.00           C  
ATOM    667  C   VAL A  46      43.857  65.903  -3.039  1.00  0.00           C  
ATOM    668  O   VAL A  46      43.719  65.009  -3.875  1.00  0.00           O  
ATOM    669  CB  VAL A  46      41.902  67.104  -2.055  1.00  0.00           C  
ATOM    670  CG1 VAL A  46      41.125  68.411  -2.011  1.00  0.00           C  
ATOM    671  CG2 VAL A  46      40.976  65.932  -2.342  1.00  0.00           C  
ATOM    672  H   VAL A  46      41.797  66.757  -4.784  1.00  0.00           H  
ATOM    673  HA  VAL A  46      43.653  68.023  -2.876  1.00  0.00           H  
ATOM    674  HB  VAL A  46      42.357  66.948  -1.088  1.00  0.00           H  
ATOM    675 HG11 VAL A  46      40.139  68.229  -1.608  1.00  0.00           H  
ATOM    676 HG12 VAL A  46      41.646  69.119  -1.383  1.00  0.00           H  
ATOM    677 HG13 VAL A  46      41.037  68.812  -3.010  1.00  0.00           H  
ATOM    678 HG21 VAL A  46      41.562  65.035  -2.478  1.00  0.00           H  
ATOM    679 HG22 VAL A  46      40.298  65.797  -1.513  1.00  0.00           H  
ATOM    680 HG23 VAL A  46      40.410  66.132  -3.241  1.00  0.00           H  
ATOM    681  N   LYS A  47      44.722  65.825  -2.034  1.00  0.00           N  
ATOM    682  CA  LYS A  47      45.579  64.659  -1.850  1.00  0.00           C  
ATOM    683  C   LYS A  47      45.262  63.953  -0.536  1.00  0.00           C  
ATOM    684  O   LYS A  47      45.043  64.599   0.489  1.00  0.00           O  
ATOM    685  CB  LYS A  47      47.051  65.074  -1.877  1.00  0.00           C  
ATOM    686  CG  LYS A  47      48.002  63.922  -2.156  1.00  0.00           C  
ATOM    687  CD  LYS A  47      49.435  64.407  -2.310  1.00  0.00           C  
ATOM    688  CE  LYS A  47      50.294  63.384  -3.036  1.00  0.00           C  
ATOM    689  NZ  LYS A  47      51.585  63.968  -3.493  1.00  0.00           N  
ATOM    690  H   LYS A  47      44.786  66.570  -1.399  1.00  0.00           H  
ATOM    691  HA  LYS A  47      45.391  63.978  -2.665  1.00  0.00           H  
ATOM    692  HB2 LYS A  47      47.189  65.820  -2.645  1.00  0.00           H  
ATOM    693  HB3 LYS A  47      47.310  65.502  -0.919  1.00  0.00           H  
ATOM    694  HG2 LYS A  47      47.958  63.223  -1.334  1.00  0.00           H  
ATOM    695  HG3 LYS A  47      47.698  63.430  -3.069  1.00  0.00           H  
ATOM    696  HD2 LYS A  47      49.436  65.327  -2.876  1.00  0.00           H  
ATOM    697  HD3 LYS A  47      49.853  64.585  -1.330  1.00  0.00           H  
ATOM    698  HE2 LYS A  47      50.497  62.563  -2.367  1.00  0.00           H  
ATOM    699  HE3 LYS A  47      49.749  63.021  -3.896  1.00  0.00           H  
ATOM    700  HZ1 LYS A  47      52.261  64.003  -2.702  1.00  0.00           H  
ATOM    701  HZ2 LYS A  47      51.436  64.934  -3.848  1.00  0.00           H  
ATOM    702  HZ3 LYS A  47      51.991  63.389  -4.255  1.00  0.00           H  
ATOM    703  N   TYR A  48      45.243  62.625  -0.573  1.00  0.00           N  
ATOM    704  CA  TYR A  48      44.953  61.832   0.616  1.00  0.00           C  
ATOM    705  C   TYR A  48      46.241  61.351   1.277  1.00  0.00           C  
ATOM    706  O   TYR A  48      47.323  61.447   0.700  1.00  0.00           O  
ATOM    707  CB  TYR A  48      44.075  60.633   0.253  1.00  0.00           C  
ATOM    708  CG  TYR A  48      42.660  61.012  -0.122  1.00  0.00           C  
ATOM    709  CD1 TYR A  48      42.339  61.377  -1.423  1.00  0.00           C  
ATOM    710  CD2 TYR A  48      41.643  61.006   0.826  1.00  0.00           C  
ATOM    711  CE1 TYR A  48      41.047  61.723  -1.771  1.00  0.00           C  
ATOM    712  CE2 TYR A  48      40.349  61.349   0.488  1.00  0.00           C  
ATOM    713  CZ  TYR A  48      40.056  61.708  -0.812  1.00  0.00           C  
ATOM    714  OH  TYR A  48      38.768  62.053  -1.152  1.00  0.00           O  
ATOM    715  H   TYR A  48      45.427  62.167  -1.419  1.00  0.00           H  
ATOM    716  HA  TYR A  48      44.417  62.461   1.312  1.00  0.00           H  
ATOM    717  HB2 TYR A  48      44.512  60.117  -0.586  1.00  0.00           H  
ATOM    718  HB3 TYR A  48      44.026  59.962   1.097  1.00  0.00           H  
ATOM    719  HD1 TYR A  48      43.117  61.388  -2.172  1.00  0.00           H  
ATOM    720  HD2 TYR A  48      41.876  60.724   1.843  1.00  0.00           H  
ATOM    721  HE1 TYR A  48      40.817  62.004  -2.788  1.00  0.00           H  
ATOM    722  HE2 TYR A  48      39.573  61.338   1.239  1.00  0.00           H  
ATOM    723  HH  TYR A  48      38.151  61.457  -0.719  1.00  0.00           H  
ATOM    724  N   LYS A  49      46.115  60.832   2.494  1.00  0.00           N  
ATOM    725  CA  LYS A  49      47.266  60.333   3.237  1.00  0.00           C  
ATOM    726  C   LYS A  49      47.970  59.220   2.466  1.00  0.00           C  
ATOM    727  O   LYS A  49      49.194  59.094   2.519  1.00  0.00           O  
ATOM    728  CB  LYS A  49      46.829  59.818   4.611  1.00  0.00           C  
ATOM    729  CG  LYS A  49      45.754  58.747   4.545  1.00  0.00           C  
ATOM    730  CD  LYS A  49      46.359  57.355   4.464  1.00  0.00           C  
ATOM    731  CE  LYS A  49      45.338  56.329   3.998  1.00  0.00           C  
ATOM    732  NZ  LYS A  49      44.399  55.947   5.089  1.00  0.00           N  
ATOM    733  H   LYS A  49      45.225  60.782   2.903  1.00  0.00           H  
ATOM    734  HA  LYS A  49      47.955  61.153   3.371  1.00  0.00           H  
ATOM    735  HB2 LYS A  49      47.689  59.405   5.116  1.00  0.00           H  
ATOM    736  HB3 LYS A  49      46.446  60.648   5.187  1.00  0.00           H  
ATOM    737  HG2 LYS A  49      45.141  58.810   5.431  1.00  0.00           H  
ATOM    738  HG3 LYS A  49      45.145  58.915   3.669  1.00  0.00           H  
ATOM    739  HD2 LYS A  49      47.182  57.369   3.765  1.00  0.00           H  
ATOM    740  HD3 LYS A  49      46.720  57.071   5.442  1.00  0.00           H  
ATOM    741  HE2 LYS A  49      44.773  56.749   3.179  1.00  0.00           H  
ATOM    742  HE3 LYS A  49      45.860  55.448   3.660  1.00  0.00           H  
ATOM    743  HZ1 LYS A  49      44.749  55.100   5.582  1.00  0.00           H  
ATOM    744  HZ2 LYS A  49      43.458  55.741   4.696  1.00  0.00           H  
ATOM    745  HZ3 LYS A  49      44.313  56.724   5.776  1.00  0.00           H  
ATOM    746  N   ASP A  50      47.191  58.419   1.748  1.00  0.00           N  
ATOM    747  CA  ASP A  50      47.740  57.319   0.965  1.00  0.00           C  
ATOM    748  C   ASP A  50      48.212  57.808  -0.401  1.00  0.00           C  
ATOM    749  O   ASP A  50      48.140  57.081  -1.391  1.00  0.00           O  
ATOM    750  CB  ASP A  50      46.694  56.216   0.791  1.00  0.00           C  
ATOM    751  CG  ASP A  50      47.320  54.866   0.498  1.00  0.00           C  
ATOM    752  OD1 ASP A  50      48.245  54.467   1.237  1.00  0.00           O  
ATOM    753  OD2 ASP A  50      46.885  54.210  -0.470  1.00  0.00           O  
ATOM    754  H   ASP A  50      46.222  58.571   1.746  1.00  0.00           H  
ATOM    755  HA  ASP A  50      48.586  56.919   1.501  1.00  0.00           H  
ATOM    756  HB2 ASP A  50      46.114  56.133   1.700  1.00  0.00           H  
ATOM    757  HB3 ASP A  50      46.039  56.475  -0.027  1.00  0.00           H  
ATOM    758  N   GLY A  51      48.695  59.046  -0.447  1.00  0.00           N  
ATOM    759  CA  GLY A  51      49.171  59.612  -1.696  1.00  0.00           C  
ATOM    760  C   GLY A  51      48.210  59.373  -2.843  1.00  0.00           C  
ATOM    761  O   GLY A  51      48.552  58.711  -3.824  1.00  0.00           O  
ATOM    762  H   GLY A  51      48.729  59.580   0.375  1.00  0.00           H  
ATOM    763  HA2 GLY A  51      49.306  60.675  -1.568  1.00  0.00           H  
ATOM    764  HA3 GLY A  51      50.123  59.164  -1.940  1.00  0.00           H  
ATOM    765  N   THR A  52      47.000  59.912  -2.722  1.00  0.00           N  
ATOM    766  CA  THR A  52      45.986  59.752  -3.756  1.00  0.00           C  
ATOM    767  C   THR A  52      45.374  61.094  -4.138  1.00  0.00           C  
ATOM    768  O   THR A  52      44.978  61.875  -3.273  1.00  0.00           O  
ATOM    769  CB  THR A  52      44.863  58.801  -3.299  1.00  0.00           C  
ATOM    770  OG1 THR A  52      45.427  57.607  -2.746  1.00  0.00           O  
ATOM    771  CG2 THR A  52      43.949  58.445  -4.461  1.00  0.00           C  
ATOM    772  H   THR A  52      46.787  60.428  -1.917  1.00  0.00           H  
ATOM    773  HA  THR A  52      46.460  59.322  -4.626  1.00  0.00           H  
ATOM    774  HB  THR A  52      44.277  59.299  -2.538  1.00  0.00           H  
ATOM    775  HG1 THR A  52      44.823  57.238  -2.097  1.00  0.00           H  
ATOM    776 HG21 THR A  52      44.354  58.851  -5.375  1.00  0.00           H  
ATOM    777 HG22 THR A  52      42.967  58.860  -4.287  1.00  0.00           H  
ATOM    778 HG23 THR A  52      43.876  57.372  -4.545  1.00  0.00           H  
ATOM    779  N   GLU A  53      45.300  61.358  -5.439  1.00  0.00           N  
ATOM    780  CA  GLU A  53      44.736  62.607  -5.935  1.00  0.00           C  
ATOM    781  C   GLU A  53      43.380  62.370  -6.593  1.00  0.00           C  
ATOM    782  O   GLU A  53      43.222  61.455  -7.403  1.00  0.00           O  
ATOM    783  CB  GLU A  53      45.691  63.263  -6.935  1.00  0.00           C  
ATOM    784  CG  GLU A  53      47.008  63.706  -6.318  1.00  0.00           C  
ATOM    785  CD  GLU A  53      47.948  64.325  -7.334  1.00  0.00           C  
ATOM    786  OE1 GLU A  53      47.914  63.903  -8.508  1.00  0.00           O  
ATOM    787  OE2 GLU A  53      48.719  65.231  -6.954  1.00  0.00           O  
ATOM    788  H   GLU A  53      45.633  60.695  -6.081  1.00  0.00           H  
ATOM    789  HA  GLU A  53      44.603  63.268  -5.092  1.00  0.00           H  
ATOM    790  HB2 GLU A  53      45.907  62.557  -7.724  1.00  0.00           H  
ATOM    791  HB3 GLU A  53      45.208  64.129  -7.361  1.00  0.00           H  
ATOM    792  HG2 GLU A  53      46.803  64.435  -5.549  1.00  0.00           H  
ATOM    793  HG3 GLU A  53      47.492  62.846  -5.878  1.00  0.00           H  
ATOM    794  N   LEU A  54      42.404  63.197  -6.237  1.00  0.00           N  
ATOM    795  CA  LEU A  54      41.059  63.079  -6.791  1.00  0.00           C  
ATOM    796  C   LEU A  54      40.446  64.454  -7.032  1.00  0.00           C  
ATOM    797  O   LEU A  54      40.994  65.471  -6.609  1.00  0.00           O  
ATOM    798  CB  LEU A  54      40.169  62.267  -5.849  1.00  0.00           C  
ATOM    799  CG  LEU A  54      40.675  60.872  -5.481  1.00  0.00           C  
ATOM    800  CD1 LEU A  54      39.785  60.244  -4.421  1.00  0.00           C  
ATOM    801  CD2 LEU A  54      40.745  59.987  -6.716  1.00  0.00           C  
ATOM    802  H   LEU A  54      42.591  63.907  -5.588  1.00  0.00           H  
ATOM    803  HA  LEU A  54      41.135  62.561  -7.737  1.00  0.00           H  
ATOM    804  HB2 LEU A  54      40.055  62.830  -4.935  1.00  0.00           H  
ATOM    805  HB3 LEU A  54      39.204  62.155  -6.323  1.00  0.00           H  
ATOM    806  HG  LEU A  54      41.673  60.955  -5.071  1.00  0.00           H  
ATOM    807 HD11 LEU A  54      40.336  60.145  -3.499  1.00  0.00           H  
ATOM    808 HD12 LEU A  54      39.463  59.267  -4.754  1.00  0.00           H  
ATOM    809 HD13 LEU A  54      38.920  60.871  -4.259  1.00  0.00           H  
ATOM    810 HD21 LEU A  54      39.889  59.328  -6.735  1.00  0.00           H  
ATOM    811 HD22 LEU A  54      41.650  59.398  -6.687  1.00  0.00           H  
ATOM    812 HD23 LEU A  54      40.744  60.604  -7.603  1.00  0.00           H  
ATOM    813  N   GLU A  55      39.303  64.476  -7.712  1.00  0.00           N  
ATOM    814  CA  GLU A  55      38.614  65.727  -8.005  1.00  0.00           C  
ATOM    815  C   GLU A  55      37.265  65.786  -7.296  1.00  0.00           C  
ATOM    816  O   GLU A  55      36.318  65.099  -7.680  1.00  0.00           O  
ATOM    817  CB  GLU A  55      38.415  65.882  -9.515  1.00  0.00           C  
ATOM    818  CG  GLU A  55      39.567  66.589 -10.212  1.00  0.00           C  
ATOM    819  CD  GLU A  55      39.468  66.515 -11.723  1.00  0.00           C  
ATOM    820  OE1 GLU A  55      39.725  65.429 -12.282  1.00  0.00           O  
ATOM    821  OE2 GLU A  55      39.132  67.543 -12.345  1.00  0.00           O  
ATOM    822  H   GLU A  55      38.915  63.631  -8.021  1.00  0.00           H  
ATOM    823  HA  GLU A  55      39.231  66.537  -7.648  1.00  0.00           H  
ATOM    824  HB2 GLU A  55      38.303  64.901  -9.954  1.00  0.00           H  
ATOM    825  HB3 GLU A  55      37.514  66.450  -9.690  1.00  0.00           H  
ATOM    826  HG2 GLU A  55      39.566  67.627  -9.917  1.00  0.00           H  
ATOM    827  HG3 GLU A  55      40.494  66.129  -9.903  1.00  0.00           H  
ATOM    828  N   LEU A  56      37.186  66.611  -6.257  1.00  0.00           N  
ATOM    829  CA  LEU A  56      35.953  66.760  -5.491  1.00  0.00           C  
ATOM    830  C   LEU A  56      35.360  68.153  -5.679  1.00  0.00           C  
ATOM    831  O   LEU A  56      36.071  69.157  -5.606  1.00  0.00           O  
ATOM    832  CB  LEU A  56      36.218  66.501  -4.007  1.00  0.00           C  
ATOM    833  CG  LEU A  56      36.999  65.230  -3.676  1.00  0.00           C  
ATOM    834  CD1 LEU A  56      37.363  65.196  -2.199  1.00  0.00           C  
ATOM    835  CD2 LEU A  56      36.195  63.995  -4.057  1.00  0.00           C  
ATOM    836  H   LEU A  56      37.974  67.133  -5.999  1.00  0.00           H  
ATOM    837  HA  LEU A  56      35.247  66.030  -5.855  1.00  0.00           H  
ATOM    838  HB2 LEU A  56      36.773  67.341  -3.619  1.00  0.00           H  
ATOM    839  HB3 LEU A  56      35.262  66.443  -3.506  1.00  0.00           H  
ATOM    840  HG  LEU A  56      37.918  65.221  -4.245  1.00  0.00           H  
ATOM    841 HD11 LEU A  56      38.411  65.425  -2.081  1.00  0.00           H  
ATOM    842 HD12 LEU A  56      37.163  64.212  -1.802  1.00  0.00           H  
ATOM    843 HD13 LEU A  56      36.771  65.926  -1.666  1.00  0.00           H  
ATOM    844 HD21 LEU A  56      35.316  64.295  -4.607  1.00  0.00           H  
ATOM    845 HD22 LEU A  56      35.898  63.468  -3.162  1.00  0.00           H  
ATOM    846 HD23 LEU A  56      36.802  63.348  -4.673  1.00  0.00           H  
ATOM    847  N   LYS A  57      34.055  68.208  -5.918  1.00  0.00           N  
ATOM    848  CA  LYS A  57      33.365  69.477  -6.113  1.00  0.00           C  
ATOM    849  C   LYS A  57      33.510  70.369  -4.885  1.00  0.00           C  
ATOM    850  O   LYS A  57      33.761  69.885  -3.782  1.00  0.00           O  
ATOM    851  CB  LYS A  57      31.883  69.235  -6.408  1.00  0.00           C  
ATOM    852  CG  LYS A  57      31.595  68.932  -7.869  1.00  0.00           C  
ATOM    853  CD  LYS A  57      31.385  70.205  -8.672  1.00  0.00           C  
ATOM    854  CE  LYS A  57      29.930  70.646  -8.643  1.00  0.00           C  
ATOM    855  NZ  LYS A  57      29.659  71.725  -9.634  1.00  0.00           N  
ATOM    856  H   LYS A  57      33.543  67.373  -5.965  1.00  0.00           H  
ATOM    857  HA  LYS A  57      33.816  69.974  -6.960  1.00  0.00           H  
ATOM    858  HB2 LYS A  57      31.542  68.400  -5.814  1.00  0.00           H  
ATOM    859  HB3 LYS A  57      31.324  70.117  -6.129  1.00  0.00           H  
ATOM    860  HG2 LYS A  57      32.432  68.391  -8.286  1.00  0.00           H  
ATOM    861  HG3 LYS A  57      30.703  68.325  -7.932  1.00  0.00           H  
ATOM    862  HD2 LYS A  57      31.995  70.991  -8.252  1.00  0.00           H  
ATOM    863  HD3 LYS A  57      31.678  70.026  -9.696  1.00  0.00           H  
ATOM    864  HE2 LYS A  57      29.304  69.797  -8.869  1.00  0.00           H  
ATOM    865  HE3 LYS A  57      29.697  71.012  -7.654  1.00  0.00           H  
ATOM    866  HZ1 LYS A  57      29.022  72.437  -9.221  1.00  0.00           H  
ATOM    867  HZ2 LYS A  57      29.210  71.327 -10.483  1.00  0.00           H  
ATOM    868  HZ3 LYS A  57      30.547  72.190  -9.909  1.00  0.00           H  
ATOM    869  N   GLU A  58      33.350  71.674  -5.084  1.00  0.00           N  
ATOM    870  CA  GLU A  58      33.463  72.633  -3.991  1.00  0.00           C  
ATOM    871  C   GLU A  58      32.546  72.249  -2.833  1.00  0.00           C  
ATOM    872  O   GLU A  58      32.855  72.507  -1.671  1.00  0.00           O  
ATOM    873  CB  GLU A  58      33.121  74.041  -4.480  1.00  0.00           C  
ATOM    874  CG  GLU A  58      33.425  75.130  -3.465  1.00  0.00           C  
ATOM    875  CD  GLU A  58      32.707  76.429  -3.770  1.00  0.00           C  
ATOM    876  OE1 GLU A  58      31.487  76.386  -4.033  1.00  0.00           O  
ATOM    877  OE2 GLU A  58      33.365  77.490  -3.745  1.00  0.00           O  
ATOM    878  H   GLU A  58      33.151  71.999  -5.987  1.00  0.00           H  
ATOM    879  HA  GLU A  58      34.485  72.621  -3.644  1.00  0.00           H  
ATOM    880  HB2 GLU A  58      33.688  74.245  -5.378  1.00  0.00           H  
ATOM    881  HB3 GLU A  58      32.067  74.081  -4.715  1.00  0.00           H  
ATOM    882  HG2 GLU A  58      33.121  74.788  -2.487  1.00  0.00           H  
ATOM    883  HG3 GLU A  58      34.490  75.316  -3.464  1.00  0.00           H  
ATOM    884  N   ASN A  59      31.417  71.629  -3.160  1.00  0.00           N  
ATOM    885  CA  ASN A  59      30.454  71.210  -2.149  1.00  0.00           C  
ATOM    886  C   ASN A  59      30.922  69.938  -1.447  1.00  0.00           C  
ATOM    887  O   ASN A  59      30.809  69.814  -0.227  1.00  0.00           O  
ATOM    888  CB  ASN A  59      29.082  70.978  -2.786  1.00  0.00           C  
ATOM    889  CG  ASN A  59      28.023  70.618  -1.762  1.00  0.00           C  
ATOM    890  OD1 ASN A  59      27.406  69.556  -1.838  1.00  0.00           O  
ATOM    891  ND2 ASN A  59      27.808  71.505  -0.796  1.00  0.00           N  
ATOM    892  H   ASN A  59      31.227  71.450  -4.105  1.00  0.00           H  
ATOM    893  HA  ASN A  59      30.374  72.001  -1.420  1.00  0.00           H  
ATOM    894  HB2 ASN A  59      28.772  71.879  -3.295  1.00  0.00           H  
ATOM    895  HB3 ASN A  59      29.155  70.173  -3.501  1.00  0.00           H  
ATOM    896 HD21 ASN A  59      28.337  72.330  -0.799  1.00  0.00           H  
ATOM    897 HD22 ASN A  59      27.129  71.297  -0.121  1.00  0.00           H  
ATOM    898  N   ASP A  60      31.447  68.998  -2.224  1.00  0.00           N  
ATOM    899  CA  ASP A  60      31.934  67.737  -1.677  1.00  0.00           C  
ATOM    900  C   ASP A  60      32.981  67.983  -0.595  1.00  0.00           C  
ATOM    901  O   ASP A  60      33.116  67.193   0.341  1.00  0.00           O  
ATOM    902  CB  ASP A  60      32.525  66.869  -2.789  1.00  0.00           C  
ATOM    903  CG  ASP A  60      31.462  66.306  -3.712  1.00  0.00           C  
ATOM    904  OD1 ASP A  60      30.586  67.082  -4.149  1.00  0.00           O  
ATOM    905  OD2 ASP A  60      31.505  65.091  -3.995  1.00  0.00           O  
ATOM    906  H   ASP A  60      31.510  69.156  -3.190  1.00  0.00           H  
ATOM    907  HA  ASP A  60      31.094  67.220  -1.238  1.00  0.00           H  
ATOM    908  HB2 ASP A  60      33.207  67.464  -3.378  1.00  0.00           H  
ATOM    909  HB3 ASP A  60      33.064  66.045  -2.345  1.00  0.00           H  
ATOM    910  N   ILE A  61      33.718  69.079  -0.730  1.00  0.00           N  
ATOM    911  CA  ILE A  61      34.752  69.427   0.236  1.00  0.00           C  
ATOM    912  C   ILE A  61      34.183  70.273   1.371  1.00  0.00           C  
ATOM    913  O   ILE A  61      33.421  71.211   1.138  1.00  0.00           O  
ATOM    914  CB  ILE A  61      35.909  70.196  -0.430  1.00  0.00           C  
ATOM    915  CG1 ILE A  61      36.511  69.368  -1.567  1.00  0.00           C  
ATOM    916  CG2 ILE A  61      36.974  70.545   0.598  1.00  0.00           C  
ATOM    917  CD1 ILE A  61      37.545  70.117  -2.378  1.00  0.00           C  
ATOM    918  H   ILE A  61      33.563  69.669  -1.497  1.00  0.00           H  
ATOM    919  HA  ILE A  61      35.146  68.510   0.648  1.00  0.00           H  
ATOM    920  HB  ILE A  61      35.516  71.116  -0.833  1.00  0.00           H  
ATOM    921 HG12 ILE A  61      36.985  68.492  -1.156  1.00  0.00           H  
ATOM    922 HG13 ILE A  61      35.721  69.063  -2.238  1.00  0.00           H  
ATOM    923 HG21 ILE A  61      37.144  71.612   0.593  1.00  0.00           H  
ATOM    924 HG22 ILE A  61      36.641  70.240   1.579  1.00  0.00           H  
ATOM    925 HG23 ILE A  61      37.893  70.034   0.354  1.00  0.00           H  
ATOM    926 HD11 ILE A  61      37.061  70.889  -2.957  1.00  0.00           H  
ATOM    927 HD12 ILE A  61      38.269  70.565  -1.714  1.00  0.00           H  
ATOM    928 HD13 ILE A  61      38.047  69.430  -3.044  1.00  0.00           H  
ATOM    929  N   LYS A  62      34.559  69.934   2.599  1.00  0.00           N  
ATOM    930  CA  LYS A  62      34.089  70.663   3.771  1.00  0.00           C  
ATOM    931  C   LYS A  62      35.220  70.867   4.774  1.00  0.00           C  
ATOM    932  O   LYS A  62      36.158  70.072   4.837  1.00  0.00           O  
ATOM    933  CB  LYS A  62      32.934  69.911   4.436  1.00  0.00           C  
ATOM    934  CG  LYS A  62      31.687  69.825   3.573  1.00  0.00           C  
ATOM    935  CD  LYS A  62      30.425  69.773   4.419  1.00  0.00           C  
ATOM    936  CE  LYS A  62      30.260  68.417   5.089  1.00  0.00           C  
ATOM    937  NZ  LYS A  62      29.153  68.422   6.085  1.00  0.00           N  
ATOM    938  H   LYS A  62      35.168  69.176   2.720  1.00  0.00           H  
ATOM    939  HA  LYS A  62      33.737  71.628   3.443  1.00  0.00           H  
ATOM    940  HB2 LYS A  62      33.258  68.905   4.663  1.00  0.00           H  
ATOM    941  HB3 LYS A  62      32.676  70.413   5.357  1.00  0.00           H  
ATOM    942  HG2 LYS A  62      31.642  70.694   2.933  1.00  0.00           H  
ATOM    943  HG3 LYS A  62      31.740  68.933   2.966  1.00  0.00           H  
ATOM    944  HD2 LYS A  62      30.482  70.534   5.182  1.00  0.00           H  
ATOM    945  HD3 LYS A  62      29.570  69.958   3.785  1.00  0.00           H  
ATOM    946  HE2 LYS A  62      30.049  67.679   4.331  1.00  0.00           H  
ATOM    947  HE3 LYS A  62      31.183  68.164   5.591  1.00  0.00           H  
ATOM    948  HZ1 LYS A  62      28.236  68.349   5.599  1.00  0.00           H  
ATOM    949  HZ2 LYS A  62      29.171  69.304   6.635  1.00  0.00           H  
ATOM    950  HZ3 LYS A  62      29.253  67.618   6.736  1.00  0.00           H  
ATOM    951  N   SER A  63      35.125  71.937   5.558  1.00  0.00           N  
ATOM    952  CA  SER A  63      36.141  72.247   6.555  1.00  0.00           C  
ATOM    953  C   SER A  63      35.520  72.369   7.944  1.00  0.00           C  
ATOM    954  O   SER A  63      34.305  72.508   8.082  1.00  0.00           O  
ATOM    955  CB  SER A  63      36.865  73.545   6.191  1.00  0.00           C  
ATOM    956  OG  SER A  63      35.981  74.653   6.242  1.00  0.00           O  
ATOM    957  H   SER A  63      34.353  72.533   5.459  1.00  0.00           H  
ATOM    958  HA  SER A  63      36.855  71.437   6.564  1.00  0.00           H  
ATOM    959  HB2 SER A  63      37.671  73.712   6.888  1.00  0.00           H  
ATOM    960  HB3 SER A  63      37.263  73.463   5.191  1.00  0.00           H  
ATOM    961  HG  SER A  63      35.263  74.461   6.849  1.00  0.00           H  
ATOM    962  N   GLY A  64      36.364  72.317   8.970  1.00  0.00           N  
ATOM    963  CA  GLY A  64      35.881  72.423  10.334  1.00  0.00           C  
ATOM    964  C   GLY A  64      36.551  73.545  11.101  1.00  0.00           C  
ATOM    965  O   GLY A  64      37.091  74.487  10.521  1.00  0.00           O  
ATOM    966  H   GLY A  64      37.322  72.205   8.799  1.00  0.00           H  
ATOM    967  HA2 GLY A  64      34.815  72.601  10.314  1.00  0.00           H  
ATOM    968  HA3 GLY A  64      36.069  71.489  10.844  1.00  0.00           H  
ATOM    969  N   PRO A  65      36.522  73.451  12.439  1.00  0.00           N  
ATOM    970  CA  PRO A  65      37.127  74.458  13.316  1.00  0.00           C  
ATOM    971  C   PRO A  65      38.651  74.444  13.251  1.00  0.00           C  
ATOM    972  O   PRO A  65      39.271  73.381  13.238  1.00  0.00           O  
ATOM    973  CB  PRO A  65      36.648  74.048  14.711  1.00  0.00           C  
ATOM    974  CG  PRO A  65      36.379  72.587  14.604  1.00  0.00           C  
ATOM    975  CD  PRO A  65      35.896  72.356  13.199  1.00  0.00           C  
ATOM    976  HA  PRO A  65      36.768  75.451  13.088  1.00  0.00           H  
ATOM    977  HB2 PRO A  65      37.422  74.257  15.436  1.00  0.00           H  
ATOM    978  HB3 PRO A  65      35.753  74.597  14.963  1.00  0.00           H  
ATOM    979  HG2 PRO A  65      37.287  72.032  14.786  1.00  0.00           H  
ATOM    980  HG3 PRO A  65      35.616  72.302  15.313  1.00  0.00           H  
ATOM    981  HD2 PRO A  65      36.232  71.396  12.838  1.00  0.00           H  
ATOM    982  HD3 PRO A  65      34.819  72.423  13.154  1.00  0.00           H  
ATOM    983  N   SER A  66      39.248  75.631  13.211  1.00  0.00           N  
ATOM    984  CA  SER A  66      40.699  75.754  13.143  1.00  0.00           C  
ATOM    985  C   SER A  66      41.333  75.456  14.499  1.00  0.00           C  
ATOM    986  O   SER A  66      40.790  75.815  15.543  1.00  0.00           O  
ATOM    987  CB  SER A  66      41.092  77.159  12.682  1.00  0.00           C  
ATOM    988  OG  SER A  66      40.611  78.144  13.580  1.00  0.00           O  
ATOM    989  H   SER A  66      38.699  76.442  13.224  1.00  0.00           H  
ATOM    990  HA  SER A  66      41.061  75.034  12.424  1.00  0.00           H  
ATOM    991  HB2 SER A  66      42.168  77.231  12.631  1.00  0.00           H  
ATOM    992  HB3 SER A  66      40.672  77.344  11.704  1.00  0.00           H  
ATOM    993  HG  SER A  66      41.332  78.454  14.132  1.00  0.00           H  
ATOM    994  N   SER A  67      42.487  74.795  14.473  1.00  0.00           N  
ATOM    995  CA  SER A  67      43.194  74.444  15.698  1.00  0.00           C  
ATOM    996  C   SER A  67      44.694  74.683  15.548  1.00  0.00           C  
ATOM    997  O   SER A  67      45.282  74.369  14.514  1.00  0.00           O  
ATOM    998  CB  SER A  67      42.932  72.982  16.062  1.00  0.00           C  
ATOM    999  OG  SER A  67      43.362  72.114  15.027  1.00  0.00           O  
ATOM   1000  H   SER A  67      42.870  74.537  13.609  1.00  0.00           H  
ATOM   1001  HA  SER A  67      42.819  75.076  16.490  1.00  0.00           H  
ATOM   1002  HB2 SER A  67      43.469  72.737  16.966  1.00  0.00           H  
ATOM   1003  HB3 SER A  67      41.874  72.837  16.221  1.00  0.00           H  
ATOM   1004  HG  SER A  67      44.195  72.430  14.670  1.00  0.00           H  
ATOM   1005  N   GLY A  68      45.306  75.240  16.589  1.00  0.00           N  
ATOM   1006  CA  GLY A  68      46.731  75.511  16.553  1.00  0.00           C  
ATOM   1007  C   GLY A  68      47.110  76.730  17.370  1.00  0.00           C  
ATOM   1008  O   GLY A  68      48.290  77.056  17.502  1.00  0.00           O  
ATOM   1009  H   GLY A  68      44.786  75.468  17.387  1.00  0.00           H  
ATOM   1010  HA2 GLY A  68      47.260  74.653  16.940  1.00  0.00           H  
ATOM   1011  HA3 GLY A  68      47.029  75.674  15.528  1.00  0.00           H  
TER    1012      GLY A  68                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
