
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   59 (  465),  selected   59 , name 1mhn_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 1mhn_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    89_A      X      63           #
LGA    Q    90_A      P      64          2.619
LGA    -       -      P      65           -
LGA    -       -      A      66           -
LGA    Q    91_A      D      67          2.691
LGA    -       -      K      68           -
LGA    W    92_A      L      69          0.927
LGA    K    93_A      Y      70          0.876
LGA    V    94_A      V      71          0.737
LGA    G    95_A      G      72          0.736
LGA    D    96_A      S      73          0.487
LGA    K    97_A      R      74          0.485
LGA    C    98_A      V      75          0.542
LGA    S    99_A      V      76          0.608
LGA    A   100_A      A      77          0.325
LGA    I   101_A      K      78          0.989
LGA    W   102_A      Y      79          0.488
LGA    S   103_A      K      80          1.055
LGA    E   104_A      D      81          2.702
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    D   105_A      Q      84          1.743
LGA    G   106_A      V      85          1.650
LGA    C   107_A      W      86          0.564
LGA    I   108_A      L      87          0.705
LGA    Y   109_A      Y      88          0.621
LGA    P   110_A      A      89          0.615
LGA    A   111_A      G      90          0.516
LGA    T   112_A      I      91          0.219
LGA    I   113_A      V      92          0.543
LGA    A   114_A      A      93          0.788
LGA    S   115_A      E      94          1.203
LGA    I   116_A      T      95          1.519
LGA    D   117_A      P      96          2.474
LGA    F   118_A      N      97          3.171
LGA    K   119_A      -       -           -
LGA    R   120_A      V      98          5.329
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    -       -      K     101           -
LGA    E   121_A      L     102          2.696
LGA    T   122_A      R     103          0.664
LGA    C   123_A      F     104          1.208
LGA    V   124_A      L     105          0.579
LGA    V   125_A      I     106          0.494
LGA    V   126_A      F     107          0.454
LGA    Y   127_A      F     108          0.446
LGA    T   128_A      D     109          1.532
LGA    G   129_A      -       -           -
LGA    Y   130_A      D     110          0.153
LGA    G   131_A      G     111          1.034
LGA    N   132_A      Y     112          1.046
LGA    R   133_A      A     113          0.541
LGA    E   134_A      S     114          0.390
LGA    E   135_A      Y     115          0.558
LGA    Q   136_A      V     116          0.858
LGA    N   137_A      T     117          1.118
LGA    L   138_A      Q     118          2.389
LGA    S   139_A      S     119          2.874
LGA    D   140_A      E     120          1.779
LGA    L   141_A      L     121          0.847
LGA    L   142_A      Y     122          1.090
LGA    S   143_A      P     123          2.172
LGA    P   144_A      I     124          1.925
LGA    I   145_A      C     125          4.836
LGA    C   146_A      R     126           -
LGA    E   147_A      P     127           -
LGA    -       -      L     128           -
LGA    -       -      K     129           -
LGA    -       -      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    -       -      E     133           -
LGA    -       -      D     134           -
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   59   93    5.0     54    1.68    14.81     54.825     3.030

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.441698 * X  +   0.167425 * Y  +   0.881403 * Z  +  24.868423
  Y_new =  -0.800610 * X  +  -0.516916 * Y  +  -0.303020 * Z  +  61.605404
  Z_new =   0.404878 * X  +  -0.839504 * Y  +   0.362363 * Z  +   3.449391 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.163316    1.978277  [ DEG:   -66.6531    113.3469 ]
  Theta =  -0.416846   -2.724747  [ DEG:   -23.8835   -156.1165 ]
  Phi   =  -2.074945    1.066648  [ DEG:  -118.8856     61.1144 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1mhn_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1mhn_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   59   93   5.0   54   1.68   14.81  54.825
REMARK  ---------------------------------------------------------- 
MOLECULE 1mhn_A
HEADER    RNA BINDING PROTEIN                     20-AUG-02   1MHN              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF THE SMN TUDOR DOMAIN             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: SMN, COMPONENT OF GEMS 1, GEMIN1;                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET24D (MODIFIED)                     
KEYWDS    SMN, SMA, SPINAL MUSCULAR ATROPHY                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                            
REVDAT   1   25-MAR-03 1MHN    0                                                
JRNL        AUTH   R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                   
JRNL        TITL   HIGH RESOLUTION X-RAY AND NMR STRUCTURES OF THE              
JRNL        TITL 2 SMN TUDOR DOMAIN: CONFORMATIONAL VARIATION IN THE            
JRNL        TITL 3 BINDING SITE FOR SYMMETRICALLY DIMETHYLATED                  
JRNL        TITL 4 ARGININE RESIDUES                                            
JRNL        REF    J.MOL.BIOL.                   V. 327   507 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1MHN A   89   147  UNP    Q16637   SMN_HUMAN       89    147             
SEQRES   1 A   59  LEU GLN GLN TRP LYS VAL GLY ASP LYS CYS SER ALA ILE          
SEQRES   2 A   59  TRP SER GLU ASP GLY CYS ILE TYR PRO ALA THR ILE ALA          
SEQRES   3 A   59  SER ILE ASP PHE LYS ARG GLU THR CYS VAL VAL VAL TYR          
SEQRES   4 A   59  THR GLY TYR GLY ASN ARG GLU GLU GLN ASN LEU SER ASP          
SEQRES   5 A   59  LEU LEU SER PRO ILE CYS GLU                                  
FORMUL   2  HOH   *65(H2 O)                                                     
CRYST1   27.652   27.652  110.299  90.00  90.00 120.00 P 65          6          
ATOM      1  N   LEU A  89      31.642  76.106  19.070  1.00 24.98           N  
ATOM      2  CA  LEU A  89      30.416  75.933  18.269  1.00 24.12           C  
ATOM      3  C   LEU A  89      30.589  76.779  17.036  1.00 23.96           C  
ATOM      4  O   LEU A  89      31.187  77.866  17.091  1.00 24.32           O  
ATOM      5  CB  LEU A  89      29.159  76.407  19.040  1.00 23.63           C  
ATOM      6  CG  LEU A  89      28.667  75.650  20.262  1.00 26.77           C  
ATOM      7  CD1 LEU A  89      27.768  76.485  21.129  1.00 25.38           C  
ATOM      8  CD2 LEU A  89      27.935  74.380  19.837  1.00 25.60           C  
ATOM      9  N   GLN A  90      30.060  76.292  15.913  1.00 22.23           N  
ATOM     10  CA  GLN A  90      29.874  77.130  14.743  1.00 22.13           C  
ATOM     11  C   GLN A  90      28.386  77.472  14.612  1.00 20.54           C  
ATOM     12  O   GLN A  90      27.520  76.883  15.276  1.00 18.15           O  
ATOM     13  CB  GLN A  90      30.407  76.427  13.483  1.00 22.97           C  
ATOM     14  CG  GLN A  90      31.768  75.776  13.718  1.00 28.57           C  
ATOM     15  CD  GLN A  90      32.511  75.446  12.460  1.00 36.43           C  
ATOM     16  OE1 GLN A  90      32.301  74.372  11.871  1.00 38.45           O  
ATOM     17  NE2 GLN A  90      33.405  76.352  12.039  1.00 39.04           N  
ATOM     18  N   GLN A  91      28.083  78.425  13.744  1.00 19.57           N  
ATOM     19  CA  GLN A  91      26.713  78.836  13.517  1.00 18.47           C  
ATOM     20  C   GLN A  91      26.117  77.840  12.523  1.00 18.52           C  
ATOM     21  O   GLN A  91      26.616  77.622  11.367  1.00 20.83           O  
ATOM     22  CB  GLN A  91      26.626  80.283  12.972  1.00 19.16           C  
ATOM     23  CG  GLN A  91      27.054  81.338  13.979  1.00 22.55           C  
ATOM     24  CD  GLN A  91      27.411  82.709  13.366  1.00 28.43           C  
ATOM     25  OE1 GLN A  91      27.787  82.818  12.180  1.00 33.66           O  
ATOM     26  NE2 GLN A  91      27.317  83.746  14.179  1.00 27.12           N  
ATOM     27  N   TRP A  92      25.067  77.206  12.971  1.00 16.19           N  
ATOM     28  CA  TRP A  92      24.387  76.258  12.141  1.00 14.81           C  
ATOM     29  C   TRP A  92      22.928  76.667  12.092  1.00 15.35           C  
ATOM     30  O   TRP A  92      22.404  77.286  13.043  1.00 15.05           O  
ATOM     31  CB  TRP A  92      24.531  74.877  12.769  1.00 14.17           C  
ATOM     32  CG  TRP A  92      25.930  74.368  12.702  1.00 12.91           C  
ATOM     33  CD1 TRP A  92      26.824  74.260  13.752  1.00 13.33           C  
ATOM     34  CD2 TRP A  92      26.630  73.898  11.537  1.00 13.52           C  
ATOM     35  NE1 TRP A  92      28.013  73.722  13.318  1.00 15.53           N  
ATOM     36  CE2 TRP A  92      27.931  73.503  11.958  1.00 15.15           C  
ATOM     37  CE3 TRP A  92      26.284  73.745  10.177  1.00 11.66           C  
ATOM     38  CZ2 TRP A  92      28.892  72.978  11.066  1.00 15.45           C  
ATOM     39  CZ3 TRP A  92      27.230  73.224   9.295  1.00 12.34           C  
ATOM     40  CH2 TRP A  92      28.528  72.845   9.748  1.00 13.15           C  
ATOM     41  N   LYS A  93      22.260  76.237  11.025  1.00 15.43           N  
ATOM     42  CA  LYS A  93      20.826  76.450  10.914  1.00 14.65           C  
ATOM     43  C   LYS A  93      20.166  75.207  10.352  1.00 14.04           C  
ATOM     44  O   LYS A  93      20.815  74.376   9.697  1.00 12.98           O  
ATOM     45  CB  LYS A  93      20.511  77.686  10.071  1.00 15.47           C  
ATOM     46  CG  LYS A  93      20.898  77.647   8.649  1.00 19.62           C  
ATOM     47  CD  LYS A  93      21.186  79.106   8.171  1.00 27.90           C  
ATOM     48  CE  LYS A  93      21.754  79.106   6.741  1.00 27.15           C  
ATOM     49  NZ  LYS A  93      20.599  78.771   5.898  1.00 32.85           N  
ATOM     50  N   VAL A  94      18.888  75.068  10.614  1.00 12.55           N  
ATOM     51  CA  VAL A  94      18.137  73.926  10.105  1.00 13.46           C  
ATOM     52  C   VAL A  94      18.274  73.956   8.584  1.00 13.78           C  
ATOM     53  O   VAL A  94      18.190  75.049   7.930  1.00 14.88           O  
ATOM     54  CB  VAL A  94      16.651  73.985  10.534  1.00 13.04           C  
ATOM     55  CG1 VAL A  94      15.829  72.866   9.875  1.00 12.39           C  
ATOM     56  CG2 VAL A  94      16.521  73.814  12.057  1.00 14.56           C  
ATOM     57  N   GLY A  95      18.495  72.779   8.008  1.00 13.03           N  
ATOM     58  CA  GLY A  95      18.603  72.662   6.565  1.00 13.55           C  
ATOM     59  C   GLY A  95      20.045  72.794   6.081  1.00 12.52           C  
ATOM     60  O   GLY A  95      20.323  72.516   4.913  1.00 14.03           O  
ATOM     61  N   ASP A  96      20.961  73.245   6.936  1.00 13.27           N  
ATOM     62  CA  ASP A  96      22.387  73.408   6.521  1.00 11.63           C  
ATOM     63  C   ASP A  96      22.989  72.084   6.132  1.00 12.60           C  
ATOM     64  O   ASP A  96      22.626  71.053   6.704  1.00 10.59           O  
ATOM     65  CB  ASP A  96      23.267  73.954   7.639  1.00 12.58           C  
ATOM     66  CG  ASP A  96      23.336  75.432   7.662  1.00 15.59           C  
ATOM     67  OD1 ASP A  96      22.959  76.083   6.627  1.00 17.45           O  
ATOM     68  OD2 ASP A  96      23.803  76.036   8.681  1.00 15.07           O  
ATOM     69  N   LYS A  97      23.869  72.096   5.126  1.00 10.27           N  
ATOM     70  CA  LYS A  97      24.638  70.909   4.815  1.00 11.34           C  
ATOM     71  C   LYS A  97      25.833  70.852   5.767  1.00 10.56           C  
ATOM     72  O   LYS A  97      26.514  71.860   6.005  1.00 10.62           O  
ATOM     73  CB  LYS A  97      25.201  70.996   3.401  1.00 10.78           C  
ATOM     74  CG  LYS A  97      24.153  70.957   2.294  1.00 16.39           C  
ATOM     75  CD  LYS A  97      25.005  71.198   0.983  1.00 23.84           C  
ATOM     76  CE  LYS A  97      24.227  71.134  -0.315  1.00 31.15           C  
ATOM     77  NZ  LYS A  97      24.906  70.169  -1.232  1.00 33.93           N  
ATOM     78  N   CYS A  98      26.151  69.664   6.255  1.00 11.64           N  
ATOM     79  CA  CYS A  98      27.304  69.535   7.123  1.00 10.84           C  
ATOM     80  C   CYS A  98      27.842  68.100   6.894  1.00 11.41           C  
ATOM     81  O   CYS A  98      27.341  67.365   6.029  1.00 12.26           O  
ATOM     82  CB  CYS A  98      26.907  69.736   8.603  1.00 12.56           C  
ATOM     83  SG  CYS A  98      25.786  68.457   9.215  1.00 13.22           S  
ATOM     84  N   SER A  99      28.854  67.707   7.663  1.00 10.29           N  
ATOM     85  CA  SER A  99      29.218  66.304   7.726  1.00  9.74           C  
ATOM     86  C   SER A  99      29.328  65.939   9.199  1.00  9.45           C  
ATOM     87  O   SER A  99      29.433  66.804  10.042  1.00  9.89           O  
ATOM     88  CB  SER A  99      30.537  66.099   6.999  1.00 11.97           C  
ATOM     89  OG  SER A  99      30.268  66.346   5.592  1.00 10.62           O  
ATOM     90  N   ALA A 100      29.186  64.659   9.505  1.00 10.80           N  
ATOM     91  CA  ALA A 100      29.289  64.273  10.903  1.00 10.51           C  
ATOM     92  C   ALA A 100      29.768  62.855  11.014  1.00 11.16           C  
ATOM     93  O   ALA A 100      29.667  62.077  10.067  1.00 10.85           O  
ATOM     94  CB  ALA A 100      27.876  64.456  11.587  1.00 11.66           C  
ATOM     95  N   ILE A 101      30.327  62.512  12.181  1.00 12.15           N  
ATOM     96  CA  ILE A 101      30.731  61.140  12.431  1.00 12.14           C  
ATOM     97  C   ILE A 101      29.530  60.321  12.842  1.00 13.09           C  
ATOM     98  O   ILE A 101      28.906  60.592  13.884  1.00 12.15           O  
ATOM     99  CB  ILE A 101      31.847  61.132  13.571  1.00 11.75           C  
ATOM    100  CG1 ILE A 101      33.010  62.069  13.167  1.00 12.63           C  
ATOM    101  CG2 ILE A 101      32.264  59.722  13.910  1.00 11.99           C  
ATOM    102  CD1 ILE A 101      34.048  62.412  14.348  1.00 13.30           C  
ATOM    103  N   TRP A 102      29.220  59.277  12.093  1.00 13.23           N  
ATOM    104  CA  TRP A 102      28.107  58.423  12.456  1.00 15.00           C  
ATOM    105  C   TRP A 102      28.517  57.484  13.594  1.00 16.94           C  
ATOM    106  O   TRP A 102      29.582  56.859  13.532  1.00 15.64           O  
ATOM    107  CB  TRP A 102      27.726  57.598  11.253  1.00 17.63           C  
ATOM    108  CG  TRP A 102      26.360  57.010  11.284  1.00 19.22           C  
ATOM    109  CD1 TRP A 102      25.547  56.776  12.375  1.00 20.09           C  
ATOM    110  CD2 TRP A 102      25.632  56.583  10.134  1.00 21.77           C  
ATOM    111  NE1 TRP A 102      24.354  56.223  11.951  1.00 22.51           N  
ATOM    112  CE2 TRP A 102      24.383  56.110  10.578  1.00 23.67           C  
ATOM    113  CE3 TRP A 102      25.907  56.589   8.746  1.00 23.79           C  
ATOM    114  CZ2 TRP A 102      23.414  55.610   9.683  1.00 26.89           C  
ATOM    115  CZ3 TRP A 102      24.958  56.113   7.857  1.00 25.93           C  
ATOM    116  CH2 TRP A 102      23.717  55.625   8.329  1.00 27.49           C  
ATOM    117  N   SER A 103      27.685  57.389  14.622  1.00 17.32           N  
ATOM    118  CA  SER A 103      28.104  56.663  15.827  1.00 20.48           C  
ATOM    119  C   SER A 103      28.128  55.164  15.595  1.00 20.42           C  
ATOM    120  O   SER A 103      28.715  54.413  16.394  1.00 20.80           O  
ATOM    121  CB  SER A 103      27.264  57.019  17.069  1.00 20.20           C  
ATOM    122  OG  SER A 103      25.915  56.610  16.892  1.00 26.42           O  
ATOM    123  N   GLU A 104      27.503  54.730  14.512  1.00 20.34           N  
ATOM    124  CA  GLU A 104      27.416  53.310  14.198  1.00 22.28           C  
ATOM    125  C   GLU A 104      28.746  52.742  13.704  1.00 20.57           C  
ATOM    126  O   GLU A 104      29.069  51.562  13.951  1.00 20.50           O  
ATOM    127  CB  GLU A 104      26.274  53.082  13.181  1.00 24.78           C  
ATOM    128  CG  GLU A 104      26.630  52.369  11.894  1.00 30.32           C  
ATOM    129  CD  GLU A 104      25.897  52.944  10.693  1.00 38.29           C  
ATOM    130  OE1 GLU A 104      24.633  52.883  10.692  1.00 39.09           O  
ATOM    131  OE2 GLU A 104      26.602  53.468   9.780  1.00 38.17           O  
ATOM    132  N   ASP A 105      29.528  53.548  13.005  1.00 18.29           N  
ATOM    133  CA  ASP A 105      30.772  53.002  12.441  1.00 17.58           C  
ATOM    134  C   ASP A 105      31.982  53.884  12.612  1.00 14.68           C  
ATOM    135  O   ASP A 105      33.070  53.470  12.238  1.00 16.83           O  
ATOM    136  CB  ASP A 105      30.613  52.544  10.974  1.00 17.63           C  
ATOM    137  CG  ASP A 105      30.499  53.717  10.008  1.00 20.47           C  
ATOM    138  OD1 ASP A 105      30.381  54.878  10.472  1.00 16.43           O  
ATOM    139  OD2 ASP A 105      30.553  53.568   8.782  1.00 20.50           O  
ATOM    140  N   GLY A 106      31.810  55.077  13.207  1.00 13.48           N  
ATOM    141  CA  GLY A 106      32.899  56.016  13.434  1.00 11.88           C  
ATOM    142  C   GLY A 106      33.461  56.659  12.176  1.00 13.55           C  
ATOM    143  O   GLY A 106      34.598  57.110  12.181  1.00 13.22           O  
ATOM    144  N   CYS A 107      32.663  56.677  11.102  1.00 13.06           N  
ATOM    145  CA  CYS A 107      33.101  57.271   9.826  1.00 14.57           C  
ATOM    146  C   CYS A 107      32.353  58.566   9.580  1.00 13.39           C  
ATOM    147  O   CYS A 107      31.263  58.741  10.103  1.00 13.06           O  
ATOM    148  CB  CYS A 107      32.772  56.334   8.684  1.00 14.21           C  
ATOM    149  SG  CYS A 107      33.791  54.807   8.725  1.00 20.69           S  
ATOM    150  N   ILE A 108      32.921  59.410   8.726  1.00 12.60           N  
ATOM    151  CA  ILE A 108      32.324  60.704   8.422  1.00 12.49           C  
ATOM    152  C   ILE A 108      31.312  60.515   7.292  1.00 11.02           C  
ATOM    153  O   ILE A 108      31.638  59.827   6.313  1.00 11.27           O  
ATOM    154  CB  ILE A 108      33.381  61.658   7.939  1.00 12.05           C  
ATOM    155  CG1 ILE A 108      34.374  62.006   9.064  1.00 14.13           C  
ATOM    156  CG2 ILE A 108      32.713  63.015   7.425  1.00 12.86           C  
ATOM    157  CD1 ILE A 108      35.620  62.799   8.541  1.00 18.26           C  
ATOM    158  N   TYR A 109      30.133  61.155   7.385  1.00 10.20           N  
ATOM    159  CA  TYR A 109      29.149  61.066   6.312  1.00 10.90           C  
ATOM    160  C   TYR A 109      28.597  62.425   6.046  1.00 11.43           C  
ATOM    161  O   TYR A 109      28.510  63.212   6.972  1.00 10.59           O  
ATOM    162  CB  TYR A 109      28.009  60.152   6.694  1.00 12.34           C  
ATOM    163  CG  TYR A 109      28.411  58.694   6.679  1.00 14.56           C  
ATOM    164  CD1 TYR A 109      28.915  58.065   7.860  1.00 15.29           C  
ATOM    165  CD2 TYR A 109      28.301  57.949   5.543  1.00 17.04           C  
ATOM    166  CE1 TYR A 109      29.290  56.761   7.881  1.00 14.67           C  
ATOM    167  CE2 TYR A 109      28.680  56.571   5.555  1.00 17.35           C  
ATOM    168  CZ  TYR A 109      29.177  55.999   6.734  1.00 18.16           C  
ATOM    169  OH  TYR A 109      29.523  54.664   6.762  1.00 20.05           O  
ATOM    170  N   PRO A 110      28.191  62.733   4.794  1.00 11.19           N  
ATOM    171  CA  PRO A 110      27.478  63.993   4.544  1.00 11.58           C  
ATOM    172  C   PRO A 110      26.118  63.947   5.234  1.00 10.75           C  
ATOM    173  O   PRO A 110      25.461  62.898   5.288  1.00 11.36           O  
ATOM    174  CB  PRO A 110      27.230  63.959   3.013  1.00 10.04           C  
ATOM    175  CG  PRO A 110      27.250  62.445   2.629  1.00 11.06           C  
ATOM    176  CD  PRO A 110      28.332  61.917   3.569  1.00 13.79           C  
ATOM    177  N   ALA A 111      25.656  65.110   5.695  1.00 10.42           N  
ATOM    178  CA  ALA A 111      24.382  65.189   6.396  1.00 10.95           C  
ATOM    179  C   ALA A 111      23.733  66.553   6.185  1.00 11.55           C  
ATOM    180  O   ALA A 111      24.390  67.481   5.686  1.00 10.55           O  
ATOM    181  CB  ALA A 111      24.611  64.940   7.872  1.00  9.80           C  
ATOM    182  N   THR A 112      22.426  66.614   6.481  1.00 11.13           N  
ATOM    183  CA  THR A 112      21.618  67.851   6.552  1.00 12.64           C  
ATOM    184  C   THR A 112      21.069  67.973   7.991  1.00 12.50           C  
ATOM    185  O   THR A 112      20.671  66.972   8.588  1.00 13.72           O  
ATOM    186  CB  THR A 112      20.416  67.720   5.608  1.00 11.23           C  
ATOM    187  OG1 THR A 112      20.903  67.435   4.279  1.00 17.52           O  
ATOM    188  CG2 THR A 112      19.765  69.033   5.483  1.00 15.61           C  
ATOM    189  N   ILE A 113      21.067  69.190   8.546  1.00 12.93           N  
ATOM    190  CA  ILE A 113      20.496  69.426   9.856  1.00 11.97           C  
ATOM    191  C   ILE A 113      18.981  69.489   9.769  1.00 12.75           C  
ATOM    192  O   ILE A 113      18.441  70.305   9.030  1.00 12.84           O  
ATOM    193  CB  ILE A 113      21.037  70.697  10.502  1.00 12.62           C  
ATOM    194  CG1 ILE A 113      22.573  70.624  10.649  1.00  9.88           C  
ATOM    195  CG2 ILE A 113      20.345  70.899  11.884  1.00 10.79           C  
ATOM    196  CD1 ILE A 113      23.213  71.990  11.042  1.00 10.89           C  
ATOM    197  N   ALA A 114      18.330  68.618  10.524  1.00 13.06           N  
ATOM    198  CA  ALA A 114      16.862  68.449  10.532  1.00 14.44           C  
ATOM    199  C   ALA A 114      16.205  69.283  11.639  1.00 14.15           C  
ATOM    200  O   ALA A 114      15.063  69.685  11.503  1.00 13.53           O  
ATOM    201  CB  ALA A 114      16.507  66.964  10.759  1.00 13.48           C  
ATOM    202  N   SER A 115      16.913  69.472  12.742  1.00 13.78           N  
ATOM    203  CA  SER A 115      16.366  70.186  13.898  1.00 13.59           C  
ATOM    204  C   SER A 115      17.522  70.582  14.778  1.00 12.87           C  
ATOM    205  O   SER A 115      18.554  69.898  14.790  1.00 12.31           O  
ATOM    206  CB  SER A 115      15.355  69.335  14.677  1.00 14.19           C  
ATOM    207  OG  SER A 115      15.952  68.183  15.259  1.00 16.14           O  
ATOM    208  N   ILE A 116      17.381  71.682  15.499  1.00 12.82           N  
ATOM    209  CA  ILE A 116      18.402  72.038  16.485  1.00 13.35           C  
ATOM    210  C   ILE A 116      17.706  72.291  17.855  1.00 13.79           C  
ATOM    211  O   ILE A 116      16.647  72.900  17.918  1.00 15.12           O  
ATOM    212  CB  ILE A 116      19.174  73.293  16.041  1.00 13.26           C  
ATOM    213  CG1 ILE A 116      19.893  73.096  14.675  1.00 12.72           C  
ATOM    214  CG2 ILE A 116      20.209  73.765  17.105  1.00 12.87           C  
ATOM    215  CD1 ILE A 116      20.352  74.376  14.064  1.00 13.05           C  
ATOM    216  N   ASP A 117      18.317  71.820  18.914  1.00 13.13           N  
ATOM    217  CA  ASP A 117      17.865  72.122  20.268  1.00 14.69           C  
ATOM    218  C   ASP A 117      18.920  72.962  20.914  1.00 15.18           C  
ATOM    219  O   ASP A 117      19.952  72.468  21.429  1.00 15.48           O  
ATOM    220  CB  ASP A 117      17.617  70.795  21.009  1.00 14.24           C  
ATOM    221  CG  ASP A 117      17.141  70.986  22.441  1.00 18.13           C  
ATOM    222  OD1 ASP A 117      17.310  72.085  23.022  1.00 19.47           O  
ATOM    223  OD2 ASP A 117      16.612  70.042  23.037  1.00 20.06           O  
ATOM    224  N   PHE A 118      18.680  74.272  20.867  1.00 15.31           N  
ATOM    225  CA  PHE A 118      19.699  75.224  21.259  1.00 16.43           C  
ATOM    226  C   PHE A 118      19.962  75.123  22.757  1.00 17.80           C  
ATOM    227  O   PHE A 118      21.104  75.225  23.178  1.00 19.78           O  
ATOM    228  CB  PHE A 118      19.288  76.643  20.834  1.00 15.86           C  
ATOM    229  CG  PHE A 118      19.548  76.925  19.383  1.00 15.90           C  
ATOM    230  CD1 PHE A 118      18.483  77.147  18.489  1.00 18.31           C  
ATOM    231  CD2 PHE A 118      20.846  76.932  18.887  1.00 17.37           C  
ATOM    232  CE1 PHE A 118      18.740  77.332  17.139  1.00 15.60           C  
ATOM    233  CE2 PHE A 118      21.101  77.143  17.519  1.00 17.36           C  
ATOM    234  CZ  PHE A 118      20.048  77.355  16.665  1.00 14.32           C  
ATOM    235  N   LYS A 119      18.931  74.867  23.554  1.00 18.51           N  
ATOM    236  CA  LYS A 119      19.121  74.806  25.013  1.00 20.39           C  
ATOM    237  C   LYS A 119      20.044  73.658  25.429  1.00 18.80           C  
ATOM    238  O   LYS A 119      20.849  73.801  26.364  1.00 20.18           O  
ATOM    239  CB  LYS A 119      17.783  74.724  25.765  1.00 21.63           C  
ATOM    240  CG  LYS A 119      17.445  76.026  26.575  1.00 28.48           C  
ATOM    241  CD  LYS A 119      15.922  76.329  26.590  1.00 36.13           C  
ATOM    242  CE  LYS A 119      15.583  77.836  26.771  1.00 38.94           C  
ATOM    243  NZ  LYS A 119      14.445  78.283  25.857  1.00 41.55           N  
ATOM    244  N   ARG A 120      19.950  72.533  24.718  1.00 17.23           N  
ATOM    245  CA  ARG A 120      20.821  71.395  25.012  1.00 15.97           C  
ATOM    246  C   ARG A 120      22.076  71.353  24.145  1.00 16.15           C  
ATOM    247  O   ARG A 120      22.967  70.538  24.376  1.00 15.94           O  
ATOM    248  CB  ARG A 120      20.039  70.095  24.905  1.00 16.59           C  
ATOM    249  CG  ARG A 120      18.826  70.072  25.829  1.00 15.54           C  
ATOM    250  CD  ARG A 120      18.355  68.696  26.192  1.00 16.50           C  
ATOM    251  NE  ARG A 120      17.102  68.773  26.969  1.00 15.46           N  
ATOM    252  CZ  ARG A 120      17.066  68.798  28.322  1.00 15.79           C  
ATOM    253  NH1 ARG A 120      18.185  68.706  29.039  1.00 13.86           N  
ATOM    254  NH2 ARG A 120      15.908  68.843  28.946  1.00 13.79           N  
ATOM    255  N   GLU A 121      22.146  72.269  23.176  1.00 15.83           N  
ATOM    256  CA  GLU A 121      23.251  72.366  22.214  1.00 16.50           C  
ATOM    257  C   GLU A 121      23.393  71.086  21.389  1.00 15.79           C  
ATOM    258  O   GLU A 121      24.493  70.632  21.072  1.00 17.02           O  
ATOM    259  CB  GLU A 121      24.562  72.739  22.922  1.00 16.84           C  
ATOM    260  CG  GLU A 121      24.486  74.072  23.638  1.00 21.26           C  
ATOM    261  CD  GLU A 121      24.468  75.317  22.736  1.00 27.84           C  
ATOM    262  OE1 GLU A 121      24.125  75.279  21.553  1.00 30.26           O  
ATOM    263  OE2 GLU A 121      24.800  76.394  23.250  1.00 34.42           O  
ATOM    264  N   THR A 122      22.273  70.519  21.034  1.00 14.63           N  
ATOM    265  CA  THR A 122      22.298  69.342  20.198  1.00 14.44           C  
ATOM    266  C   THR A 122      21.508  69.632  18.940  1.00 12.73           C  
ATOM    267  O   THR A 122      20.778  70.650  18.832  1.00 12.77           O  
ATOM    268  CB  THR A 122      21.713  68.076  20.910  1.00 15.00           C  
ATOM    269  OG1 THR A 122      20.334  68.278  21.248  1.00 14.90           O  
ATOM    270  CG2 THR A 122      22.387  67.823  22.271  1.00 17.82           C  
ATOM    271  N   CYS A 123      21.649  68.721  17.996  1.00 12.36           N  
ATOM    272  CA  CYS A 123      20.798  68.746  16.809  1.00 12.67           C  
ATOM    273  C   CYS A 123      20.528  67.322  16.362  1.00 12.83           C  
ATOM    274  O   CYS A 123      21.123  66.377  16.900  1.00 13.81           O  
ATOM    275  CB  CYS A 123      21.465  69.554  15.706  1.00 11.40           C  
ATOM    276  SG  CYS A 123      23.064  68.816  15.213  1.00 13.78           S  
ATOM    277  N   VAL A 124      19.601  67.156  15.421  1.00 11.72           N  
ATOM    278  CA  VAL A 124      19.424  65.903  14.732  1.00 12.15           C  
ATOM    279  C   VAL A 124      19.903  66.154  13.275  1.00 12.46           C  
ATOM    280  O   VAL A 124      19.478  67.103  12.620  1.00 11.23           O  
ATOM    281  CB  VAL A 124      17.988  65.457  14.691  1.00 13.52           C  
ATOM    282  CG1 VAL A 124      17.793  64.183  13.769  1.00 14.49           C  
ATOM    283  CG2 VAL A 124      17.489  65.176  16.092  1.00 13.54           C  
ATOM    284  N   VAL A 125      20.771  65.267  12.805  1.00 11.94           N  
ATOM    285  CA  VAL A 125      21.167  65.251  11.382  1.00 12.01           C  
ATOM    286  C   VAL A 125      20.626  64.030  10.665  1.00 11.98           C  
ATOM    287  O   VAL A 125      20.383  62.956  11.274  1.00 14.06           O  
ATOM    288  CB  VAL A 125      22.704  65.346  11.207  1.00 11.85           C  
ATOM    289  CG1 VAL A 125      23.216  66.513  11.971  1.00 10.80           C  
ATOM    290  CG2 VAL A 125      23.424  64.069  11.732  1.00 13.39           C  
ATOM    291  N   VAL A 126      20.432  64.193   9.354  1.00 11.36           N  
ATOM    292  CA  VAL A 126      20.015  63.107   8.516  1.00 12.68           C  
ATOM    293  C   VAL A 126      21.162  62.840   7.553  1.00 12.94           C  
ATOM    294  O   VAL A 126      21.579  63.725   6.816  1.00 12.27           O  
ATOM    295  CB  VAL A 126      18.751  63.474   7.725  1.00 13.33           C  
ATOM    296  CG1 VAL A 126      18.368  62.373   6.725  1.00 14.79           C  
ATOM    297  CG2 VAL A 126      17.557  63.784   8.700  1.00 14.04           C  
ATOM    298  N   TYR A 127      21.653  61.618   7.558  1.00 13.53           N  
ATOM    299  CA  TYR A 127      22.774  61.279   6.700  1.00 13.83           C  
ATOM    300  C   TYR A 127      22.259  61.131   5.286  1.00 15.12           C  
ATOM    301  O   TYR A 127      21.444  60.268   5.001  1.00 14.70           O  
ATOM    302  CB  TYR A 127      23.460  60.015   7.179  1.00 12.96           C  
ATOM    303  CG  TYR A 127      24.074  60.225   8.520  1.00 12.64           C  
ATOM    304  CD1 TYR A 127      23.512  59.613   9.647  1.00 12.69           C  
ATOM    305  CD2 TYR A 127      25.177  61.120   8.688  1.00 12.95           C  
ATOM    306  CE1 TYR A 127      24.071  59.827  10.961  1.00 14.20           C  
ATOM    307  CE2 TYR A 127      25.704  61.341   9.983  1.00 14.11           C  
ATOM    308  CZ  TYR A 127      25.158  60.670  11.094  1.00 13.71           C  
ATOM    309  OH  TYR A 127      25.679  60.888  12.368  1.00 14.52           O  
ATOM    310  N   THR A 128      22.764  62.020   4.443  1.00 16.87           N  
ATOM    311  CA  THR A 128      22.296  62.251   3.057  1.00 17.00           C  
ATOM    312  C   THR A 128      22.445  61.054   2.180  1.00 16.18           C  
ATOM    313  O   THR A 128      23.572  60.694   1.796  1.00 19.10           O  
ATOM    314  CB  THR A 128      23.203  63.335   2.439  1.00 17.63           C  
ATOM    315  OG1 THR A 128      23.046  64.547   3.143  1.00 18.88           O  
ATOM    316  CG2 THR A 128      22.772  63.707   1.030  1.00 21.38           C  
ATOM    317  N   GLY A 129      21.330  60.452   1.798  1.00 16.38           N  
ATOM    318  CA  GLY A 129      21.371  59.309   0.939  1.00 16.60           C  
ATOM    319  C   GLY A 129      21.622  58.018   1.691  1.00 18.07           C  
ATOM    320  O   GLY A 129      21.785  56.949   1.065  1.00 18.86           O  
ATOM    321  N   TYR A 130      21.637  58.098   3.023  1.00 17.89           N  
ATOM    322  CA  TYR A 130      21.839  56.928   3.854  1.00 18.37           C  
ATOM    323  C   TYR A 130      20.613  56.569   4.712  1.00 19.33           C  
ATOM    324  O   TYR A 130      20.662  55.603   5.494  1.00 19.21           O  
ATOM    325  CB  TYR A 130      23.058  57.128   4.738  1.00 18.52           C  
ATOM    326  CG  TYR A 130      24.330  57.296   3.955  1.00 18.99           C  
ATOM    327  CD1 TYR A 130      24.798  58.554   3.610  1.00 20.70           C  
ATOM    328  CD2 TYR A 130      25.059  56.183   3.523  1.00 18.98           C  
ATOM    329  CE1 TYR A 130      25.976  58.709   2.878  1.00 21.80           C  
ATOM    330  CE2 TYR A 130      26.226  56.336   2.814  1.00 20.61           C  
ATOM    331  CZ  TYR A 130      26.679  57.598   2.484  1.00 23.14           C  
ATOM    332  OH  TYR A 130      27.846  57.774   1.748  1.00 27.79           O  
ATOM    333  N   GLY A 131      19.557  57.389   4.617  1.00 18.30           N  
ATOM    334  CA  GLY A 131      18.244  57.089   5.162  1.00 18.95           C  
ATOM    335  C   GLY A 131      18.116  57.023   6.652  1.00 20.71           C  
ATOM    336  O   GLY A 131      17.153  56.451   7.162  1.00 21.00           O  
ATOM    337  N   ASN A 132      19.090  57.583   7.365  1.00 20.36           N  
ATOM    338  CA  ASN A 132      19.175  57.394   8.798  1.00 21.54           C  
ATOM    339  C   ASN A 132      19.462  58.735   9.453  1.00 20.96           C  
ATOM    340  O   ASN A 132      20.004  59.631   8.814  1.00 20.70           O  
ATOM    341  CB  ASN A 132      20.327  56.426   9.136  1.00 22.58           C  
ATOM    342  CG  ASN A 132      19.864  54.982   9.293  1.00 27.86           C  
ATOM    343  OD1 ASN A 132      20.289  54.097   8.534  1.00 31.24           O  
ATOM    344  ND2 ASN A 132      18.982  54.731  10.283  1.00 32.44           N  
ATOM    345  N   ARG A 133      19.111  58.869  10.729  1.00 20.25           N  
ATOM    346  CA  ARG A 133      19.310  60.117  11.429  1.00 19.80           C  
ATOM    347  C   ARG A 133      19.932  59.866  12.797  1.00 20.40           C  
ATOM    348  O   ARG A 133      19.895  58.749  13.331  1.00 19.90           O  
ATOM    349  CB  ARG A 133      17.966  60.850  11.572  1.00 20.38           C  
ATOM    350  CG  ARG A 133      17.108  60.228  12.660  1.00 22.71           C  
ATOM    351  CD  ARG A 133      15.791  60.904  12.834  1.00 25.76           C  
ATOM    352  NE  ARG A 133      14.991  60.689  11.648  1.00 26.60           N  
ATOM    353  CZ  ARG A 133      13.896  61.360  11.388  1.00 26.60           C  
ATOM    354  NH1 ARG A 133      13.488  62.273  12.258  1.00 28.78           N  
ATOM    355  NH2 ARG A 133      13.213  61.105  10.280  1.00 22.60           N  
ATOM    356  N   GLU A 134      20.460  60.916  13.395  1.00 18.63           N  
ATOM    357  CA  GLU A 134      21.152  60.747  14.644  1.00 20.06           C  
ATOM    358  C   GLU A 134      21.229  62.097  15.338  1.00 19.00           C  
ATOM    359  O   GLU A 134      21.374  63.115  14.669  1.00 18.38           O  
ATOM    360  CB  GLU A 134      22.547  60.193  14.310  1.00 19.72           C  
ATOM    361  CG  GLU A 134      23.630  60.422  15.295  1.00 24.74           C  
ATOM    362  CD  GLU A 134      24.645  59.324  15.166  1.00 28.00           C  
ATOM    363  OE1 GLU A 134      25.572  59.465  14.380  1.00 25.35           O  
ATOM    364  OE2 GLU A 134      24.464  58.303  15.844  1.00 34.34           O  
ATOM    365  N   GLU A 135      21.117  62.103  16.679  1.00 18.23           N  
ATOM    366  CA  GLU A 135      21.446  63.282  17.461  1.00 17.78           C  
ATOM    367  C   GLU A 135      22.928  63.462  17.496  1.00 16.52           C  
ATOM    368  O   GLU A 135      23.688  62.488  17.664  1.00 16.85           O  
ATOM    369  CB  GLU A 135      20.897  63.136  18.900  1.00 20.25           C  
ATOM    370  CG  GLU A 135      21.025  64.373  19.781  1.00 25.46           C  
ATOM    371  CD  GLU A 135      19.895  64.398  20.801  1.00 35.03           C  
ATOM    372  OE1 GLU A 135      20.090  63.842  21.905  1.00 35.95           O  
ATOM    373  OE2 GLU A 135      18.793  64.910  20.467  1.00 39.30           O  
ATOM    374  N   GLN A 136      23.347  64.711  17.361  1.00 14.27           N  
ATOM    375  CA  GLN A 136      24.730  65.131  17.414  1.00 14.69           C  
ATOM    376  C   GLN A 136      24.814  66.352  18.320  1.00 15.36           C  
ATOM    377  O   GLN A 136      23.893  67.189  18.346  1.00 15.68           O  
ATOM    378  CB  GLN A 136      25.249  65.576  16.018  1.00 14.28           C  
ATOM    379  CG  GLN A 136      25.410  64.482  14.995  1.00 13.40           C  
ATOM    380  CD  GLN A 136      26.692  63.647  15.120  1.00 15.88           C  
ATOM    381  OE1 GLN A 136      27.688  64.074  15.717  1.00 16.89           O  
ATOM    382  NE2 GLN A 136      26.669  62.458  14.512  1.00 14.22           N  
ATOM    383  N   ASN A 137      25.905  66.480  19.063  1.00 15.31           N  
ATOM    384  CA  ASN A 137      26.214  67.768  19.666  1.00 16.53           C  
ATOM    385  C   ASN A 137      26.528  68.731  18.547  1.00 15.03           C  
ATOM    386  O   ASN A 137      27.219  68.359  17.588  1.00 13.44           O  
ATOM    387  CB  ASN A 137      27.425  67.675  20.576  1.00 18.97           C  
ATOM    388  CG  ASN A 137      27.190  66.730  21.729  1.00 22.69           C  
ATOM    389  OD1 ASN A 137      26.117  66.738  22.336  1.00 21.51           O  
ATOM    390  ND2 ASN A 137      28.172  65.865  21.997  1.00 23.88           N  
ATOM    391  N   LEU A 138      25.996  69.951  18.631  1.00 13.95           N  
ATOM    392  CA  LEU A 138      26.381  70.976  17.647  1.00 13.03           C  
ATOM    393  C   LEU A 138      27.917  71.120  17.558  1.00 13.55           C  
ATOM    394  O   LEU A 138      28.444  71.307  16.449  1.00 12.76           O  
ATOM    395  CB  LEU A 138      25.761  72.336  17.980  1.00 12.70           C  
ATOM    396  CG  LEU A 138      24.258  72.448  17.758  1.00 14.13           C  
ATOM    397  CD1 LEU A 138      23.735  73.624  18.456  1.00 15.22           C  
ATOM    398  CD2 LEU A 138      24.004  72.571  16.242  1.00 12.31           C  
ATOM    399  N   SER A 139      28.636  71.001  18.683  1.00 12.04           N  
ATOM    400  CA  SER A 139      30.099  71.185  18.661  1.00 14.70           C  
ATOM    401  C   SER A 139      30.824  70.137  17.808  1.00 14.00           C  
ATOM    402  O   SER A 139      31.981  70.341  17.464  1.00 16.53           O  
ATOM    403  CB  SER A 139      30.711  71.184  20.075  1.00 13.76           C  
ATOM    404  OG  SER A 139      30.295  70.016  20.726  1.00 17.61           O  
ATOM    405  N   ASP A 140      30.165  69.025  17.527  1.00 14.52           N  
ATOM    406  CA  ASP A 140      30.773  67.893  16.841  1.00 13.21           C  
ATOM    407  C   ASP A 140      30.516  67.917  15.337  1.00 13.57           C  
ATOM    408  O   ASP A 140      31.030  67.040  14.628  1.00 13.77           O  
ATOM    409  CB  ASP A 140      30.256  66.562  17.390  1.00 13.35           C  
ATOM    410  CG  ASP A 140      30.751  66.264  18.798  1.00 14.72           C  
ATOM    411  OD1 ASP A 140      31.800  66.812  19.193  1.00 18.24           O  
ATOM    412  OD2 ASP A 140      30.133  65.476  19.539  1.00 17.84           O  
ATOM    413  N   LEU A 141      29.741  68.898  14.843  1.00 11.97           N  
ATOM    414  CA  LEU A 141      29.445  68.929  13.380  1.00 11.52           C  
ATOM    415  C   LEU A 141      30.700  69.391  12.657  1.00 11.40           C  
ATOM    416  O   LEU A 141      31.525  70.165  13.201  1.00 11.40           O  
ATOM    417  CB  LEU A 141      28.264  69.880  13.080  1.00 10.24           C  
ATOM    418  CG  LEU A 141      26.934  69.388  13.660  1.00 10.59           C  
ATOM    419  CD1 LEU A 141      25.882  70.470  13.229  1.00 10.72           C  
ATOM    420  CD2 LEU A 141      26.458  67.987  13.230  1.00  8.38           C  
ATOM    421  N   LEU A 142      30.840  68.912  11.418  1.00 12.13           N  
ATOM    422  CA  LEU A 142      31.976  69.233  10.602  1.00 10.57           C  
ATOM    423  C   LEU A 142      31.542  69.951   9.329  1.00 11.42           C  
ATOM    424  O   LEU A 142      30.392  69.838   8.865  1.00 10.91           O  
ATOM    425  CB  LEU A 142      32.700  67.960  10.181  1.00 10.93           C  
ATOM    426  CG  LEU A 142      33.022  66.885  11.249  1.00 13.72           C  
ATOM    427  CD1 LEU A 142      33.409  65.556  10.644  1.00 13.71           C  
ATOM    428  CD2 LEU A 142      34.112  67.459  12.136  1.00 15.19           C  
ATOM    429  N   SER A 143      32.506  70.641   8.760  1.00 11.77           N  
ATOM    430  CA  SER A 143      32.368  71.226   7.418  1.00 12.35           C  
ATOM    431  C   SER A 143      31.790  70.258   6.420  1.00 11.34           C  
ATOM    432  O   SER A 143      32.224  69.104   6.380  1.00 12.53           O  
ATOM    433  CB  SER A 143      33.756  71.586   6.887  1.00 12.83           C  
ATOM    434  OG  SER A 143      33.620  72.060   5.551  1.00 17.49           O  
ATOM    435  N   PRO A 144      30.862  70.703   5.546  1.00 11.95           N  
ATOM    436  CA  PRO A 144      30.320  69.779   4.567  1.00 12.92           C  
ATOM    437  C   PRO A 144      31.383  69.337   3.551  1.00 13.91           C  
ATOM    438  O   PRO A 144      31.099  68.419   2.840  1.00 12.67           O  
ATOM    439  CB  PRO A 144      29.177  70.561   3.899  1.00 13.67           C  
ATOM    440  CG  PRO A 144      29.497  71.983   4.106  1.00 13.27           C  
ATOM    441  CD  PRO A 144      30.161  72.013   5.513  1.00 11.28           C  
ATOM    442  N   ILE A 145      32.549  69.992   3.499  1.00 15.28           N  
ATOM    443  CA  ILE A 145      33.658  69.511   2.658  1.00 18.46           C  
ATOM    444  C   ILE A 145      34.251  68.162   3.129  1.00 19.93           C  
ATOM    445  O   ILE A 145      34.737  67.363   2.302  1.00 19.05           O  
ATOM    446  CB  ILE A 145      34.727  70.579   2.567  1.00 18.94           C  
ATOM    447  CG1 ILE A 145      34.151  71.834   1.889  1.00 21.76           C  
ATOM    448  CG2 ILE A 145      36.003  70.068   1.817  1.00 21.94           C  
ATOM    449  CD1 ILE A 145      35.078  73.039   1.989  1.00 27.58           C  
ATOM    450  N   CYS A 146      34.231  67.884   4.438  1.00 21.33           N  
ATOM    451  CA  CYS A 146      34.740  66.587   4.923  1.00 23.96           C  
ATOM    452  C   CYS A 146      33.874  65.461   4.502  1.00 24.98           C  
ATOM    453  O   CYS A 146      32.713  65.406   4.898  1.00 25.48           O  
ATOM    454  CB  CYS A 146      34.796  66.501   6.434  1.00 25.09           C  
ATOM    455  SG  CYS A 146      35.472  67.969   7.027  1.00 27.50           S  
ATOM    456  N   GLU A 147      34.443  64.523   3.768  1.00 26.02           N  
ATOM    457  CA  GLU A 147      33.683  63.323   3.417  1.00 28.66           C  
ATOM    458  C   GLU A 147      34.498  62.031   3.552  1.00 28.95           C  
ATOM    459  O   GLU A 147      34.037  60.903   3.399  1.00 29.73           O  
ATOM    460  CB  GLU A 147      33.025  63.504   2.041  1.00 29.32           C  
ATOM    461  CG  GLU A 147      31.791  64.401   2.125  1.00 31.74           C  
ATOM    462  CD  GLU A 147      31.085  64.640   0.811  1.00 33.34           C  
ATOM    463  OE1 GLU A 147      29.921  64.201   0.691  1.00 36.57           O  
ATOM    464  OE2 GLU A 147      31.651  65.315  -0.073  1.00 33.03           O  
ATOM    465  OXT GLU A 147      35.686  62.062   3.871  1.00 30.39           O  
TER     466      GLU A 147                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
