
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 ( 1015),  selected   68 , name 2e5p_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2e5p_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      X      63           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      P      64          5.248
LGA    P     8_A      P      65          1.702
LGA    R     9_A      A      66          3.200
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    L    10_A      L      69          1.889
LGA    W    11_A      Y      70          1.141
LGA    E    12_A      V      71          0.491
LGA    G    13_A      G      72          0.794
LGA    Q    14_A      S      73          0.365
LGA    D    15_A      R      74          0.306
LGA    V    16_A      V      75          0.516
LGA    L    17_A      V      76          0.515
LGA    A    18_A      A      77          1.035
LGA    R    19_A      K      78          1.653
LGA    W    20_A      Y      79          2.685
LGA    -       -      K      80           -
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    T    21_A      Q      84          4.730
LGA    D    22_A      V      85          3.025
LGA    G    23_A      W      86          4.180
LGA    L    24_A      -       -           -
LGA    L    25_A      L      87          1.770
LGA    Y    26_A      Y      88          0.565
LGA    L    27_A      A      89          0.588
LGA    G    28_A      G      90          0.723
LGA    T    29_A      I      91          0.186
LGA    I    30_A      V      92          0.437
LGA    K    31_A      A      93          0.811
LGA    K    32_A      E      94          0.979
LGA    V    33_A      T      95          1.129
LGA    D    34_A      P      96          2.007
LGA    S    35_A      N      97          3.172
LGA    A    36_A      V      98          3.720
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    R    37_A      K     101          2.640
LGA    E    38_A      L     102          2.708
LGA    V    39_A      R     103          1.314
LGA    C    40_A      F     104          0.838
LGA    L    41_A      L     105          0.695
LGA    V    42_A      I     106          0.761
LGA    Q    43_A      F     107          0.535
LGA    F    44_A      F     108          1.517
LGA    E    45_A      D     109          2.106
LGA    D    46_A      D     110          2.452
LGA    D    47_A      G     111          2.045
LGA    S    48_A      Y     112          1.711
LGA    Q    49_A      A     113          1.942
LGA    F    50_A      S     114          2.171
LGA    L    51_A      Y     115          1.492
LGA    V    52_A      V     116          1.912
LGA    L    53_A      T     117          1.829
LGA    W    54_A      Q     118          1.707
LGA    K    55_A      S     119          1.338
LGA    D    56_A      E     120          1.351
LGA    I    57_A      L     121          1.545
LGA    S    58_A      Y     122          1.808
LGA    P    59_A      P     123          2.142
LGA    A    60_A      I     124          1.815
LGA    A    61_A      C     125          1.517
LGA    L    62_A      R     126          1.489
LGA    S    63_A      P     127           #
LGA    G    64_A      L     128           -
LGA    P    65_A      K     129           -
LGA    S    66_A      K     130           -
LGA    S    67_A      T     131           -
LGA    G    68_A      W     132           -
LGA    -       -      E     133           -
LGA    -       -      D     134           -
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68   93    5.0     55    2.01    23.64     53.931     2.603

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.916120 * X  +   0.062110 * Y  +   0.396064 * Z  +  26.191320
  Y_new =  -0.307287 * X  +  -0.743294 * Y  +  -0.594212 * Z  +  68.715317
  Z_new =   0.257486 * X  +  -0.666075 * Y  +   0.700032 * Z  +  11.838382 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.760546    2.381046  [ DEG:   -43.5761    136.4239 ]
  Theta =  -0.260420   -2.881173  [ DEG:   -14.9210   -165.0790 ]
  Phi   =  -2.817963    0.323630  [ DEG:  -161.4574     18.5426 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e5p_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e5p_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68   93   5.0   55   2.01   23.64  53.931
REMARK  ---------------------------------------------------------- 
MOLECULE 2e5p_A
HEADER    TRANSCRIPTION                           22-DEC-06   2E5P              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 1 (PHF1 PROTEIN)                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 1;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN, RESIDUES 8-62;                               
COMPND   5 SYNONYM: PROTEIN PHF1;                                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF1;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050822-22;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, TUDOR DOMAIN, PHD FINGER PROTEIN 1, PHF1 PROTEIN,                
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   26-JUN-07 2E5P    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 1 (PHF1 PROTEIN)                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E5P A    8    62  UNP    O43189   PHF1_HUMAN      29     83             
SEQRES   1 A   68  GLY SER SER GLY SER SER GLY PRO ARG LEU TRP GLU GLY          
SEQRES   2 A   68  GLN ASP VAL LEU ALA ARG TRP THR ASP GLY LEU LEU TYR          
SEQRES   3 A   68  LEU GLY THR ILE LYS LYS VAL ASP SER ALA ARG GLU VAL          
SEQRES   4 A   68  CYS LEU VAL GLN PHE GLU ASP ASP SER GLN PHE LEU VAL          
SEQRES   5 A   68  LEU TRP LYS ASP ILE SER PRO ALA ALA LEU SER GLY PRO          
SEQRES   6 A   68  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      41.722  90.647  22.395  1.00  0.00           N  
ATOM      2  CA  GLY A   1      40.548  91.160  21.713  1.00  0.00           C  
ATOM      3  C   GLY A   1      39.587  90.059  21.309  1.00  0.00           C  
ATOM      4  O   GLY A   1      39.534  89.669  20.143  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      40.036  91.849  22.367  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      40.865  91.689  20.826  1.00  0.00           H  
ATOM      7  H1  GLY A   1      41.619  89.992  23.117  1.00  0.00           H  
ATOM      8  N   SER A   2      38.823  89.558  22.275  1.00  0.00           N  
ATOM      9  CA  SER A   2      37.862  88.492  22.015  1.00  0.00           C  
ATOM     10  C   SER A   2      36.675  88.588  22.968  1.00  0.00           C  
ATOM     11  O   SER A   2      36.839  88.865  24.157  1.00  0.00           O  
ATOM     12  CB  SER A   2      38.534  87.125  22.153  1.00  0.00           C  
ATOM     13  OG  SER A   2      39.263  86.794  20.984  1.00  0.00           O  
ATOM     14  H   SER A   2      38.912  89.912  23.185  1.00  0.00           H  
ATOM     15  HA  SER A   2      37.506  88.608  21.002  1.00  0.00           H  
ATOM     16  HB2 SER A   2      39.214  87.145  22.992  1.00  0.00           H  
ATOM     17  HB3 SER A   2      37.780  86.371  22.318  1.00  0.00           H  
ATOM     18  HG  SER A   2      40.069  86.333  21.228  1.00  0.00           H  
ATOM     19  N   SER A   3      35.479  88.354  22.438  1.00  0.00           N  
ATOM     20  CA  SER A   3      34.262  88.417  23.240  1.00  0.00           C  
ATOM     21  C   SER A   3      33.381  87.199  22.984  1.00  0.00           C  
ATOM     22  O   SER A   3      33.651  86.398  22.091  1.00  0.00           O  
ATOM     23  CB  SER A   3      33.486  89.697  22.927  1.00  0.00           C  
ATOM     24  OG  SER A   3      33.172  89.781  21.549  1.00  0.00           O  
ATOM     25  H   SER A   3      35.413  88.138  21.485  1.00  0.00           H  
ATOM     26  HA  SER A   3      34.552  88.426  24.281  1.00  0.00           H  
ATOM     27  HB2 SER A   3      32.567  89.706  23.494  1.00  0.00           H  
ATOM     28  HB3 SER A   3      34.085  90.555  23.201  1.00  0.00           H  
ATOM     29  HG  SER A   3      33.137  88.897  21.174  1.00  0.00           H  
ATOM     30  N   GLY A   4      32.321  87.066  23.778  1.00  0.00           N  
ATOM     31  CA  GLY A   4      31.415  85.943  23.622  1.00  0.00           C  
ATOM     32  C   GLY A   4      30.622  86.013  22.332  1.00  0.00           C  
ATOM     33  O   GLY A   4      29.777  86.891  22.161  1.00  0.00           O  
ATOM     34  H   GLY A   4      32.154  87.735  24.474  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      31.986  85.028  23.632  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      30.726  85.934  24.454  1.00  0.00           H  
ATOM     37  N   SER A   5      30.895  85.084  21.422  1.00  0.00           N  
ATOM     38  CA  SER A   5      30.205  85.046  20.137  1.00  0.00           C  
ATOM     39  C   SER A   5      30.100  83.616  19.618  1.00  0.00           C  
ATOM     40  O   SER A   5      31.018  82.814  19.786  1.00  0.00           O  
ATOM     41  CB  SER A   5      30.936  85.920  19.115  1.00  0.00           C  
ATOM     42  OG  SER A   5      30.179  86.055  17.925  1.00  0.00           O  
ATOM     43  H   SER A   5      31.579  84.410  21.616  1.00  0.00           H  
ATOM     44  HA  SER A   5      29.209  85.438  20.285  1.00  0.00           H  
ATOM     45  HB2 SER A   5      31.101  86.899  19.536  1.00  0.00           H  
ATOM     46  HB3 SER A   5      31.886  85.466  18.874  1.00  0.00           H  
ATOM     47  HG  SER A   5      29.673  85.253  17.775  1.00  0.00           H  
ATOM     48  N   SER A   6      28.973  83.303  18.987  1.00  0.00           N  
ATOM     49  CA  SER A   6      28.744  81.968  18.447  1.00  0.00           C  
ATOM     50  C   SER A   6      29.417  81.811  17.086  1.00  0.00           C  
ATOM     51  O   SER A   6      29.184  82.599  16.171  1.00  0.00           O  
ATOM     52  CB  SER A   6      27.245  81.695  18.322  1.00  0.00           C  
ATOM     53  OG  SER A   6      26.639  82.583  17.398  1.00  0.00           O  
ATOM     54  H   SER A   6      28.277  83.986  18.885  1.00  0.00           H  
ATOM     55  HA  SER A   6      29.176  81.254  19.132  1.00  0.00           H  
ATOM     56  HB2 SER A   6      27.092  80.682  17.981  1.00  0.00           H  
ATOM     57  HB3 SER A   6      26.776  81.824  19.288  1.00  0.00           H  
ATOM     58  HG  SER A   6      25.952  82.121  16.912  1.00  0.00           H  
ATOM     59  N   GLY A   7      30.253  80.785  16.961  1.00  0.00           N  
ATOM     60  CA  GLY A   7      30.947  80.541  15.710  1.00  0.00           C  
ATOM     61  C   GLY A   7      30.101  79.767  14.719  1.00  0.00           C  
ATOM     62  O   GLY A   7      29.679  80.290  13.687  1.00  0.00           O  
ATOM     63  H   GLY A   7      30.400  80.188  17.724  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      31.218  81.490  15.271  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      31.847  79.979  15.914  1.00  0.00           H  
ATOM     66  N   PRO A   8      29.843  78.488  15.029  1.00  0.00           N  
ATOM     67  CA  PRO A   8      29.041  77.612  14.169  1.00  0.00           C  
ATOM     68  C   PRO A   8      27.568  78.007  14.152  1.00  0.00           C  
ATOM     69  O   PRO A   8      27.063  78.597  15.106  1.00  0.00           O  
ATOM     70  CB  PRO A   8      29.216  76.231  14.808  1.00  0.00           C  
ATOM     71  CG  PRO A   8      29.534  76.511  16.236  1.00  0.00           C  
ATOM     72  CD  PRO A   8      30.314  77.798  16.242  1.00  0.00           C  
ATOM     73  HA  PRO A   8      29.419  77.593  13.158  1.00  0.00           H  
ATOM     74  HB2 PRO A   8      28.299  75.667  14.709  1.00  0.00           H  
ATOM     75  HB3 PRO A   8      30.023  75.704  14.320  1.00  0.00           H  
ATOM     76  HG2 PRO A   8      28.621  76.624  16.800  1.00  0.00           H  
ATOM     77  HG3 PRO A   8      30.133  75.710  16.643  1.00  0.00           H  
ATOM     78  HD2 PRO A   8      30.085  78.373  17.126  1.00  0.00           H  
ATOM     79  HD3 PRO A   8      31.374  77.597  16.184  1.00  0.00           H  
ATOM     80  N   ARG A   9      26.885  77.676  13.061  1.00  0.00           N  
ATOM     81  CA  ARG A   9      25.470  77.998  12.920  1.00  0.00           C  
ATOM     82  C   ARG A   9      24.615  76.735  12.987  1.00  0.00           C  
ATOM     83  O   ARG A   9      23.634  76.676  13.729  1.00  0.00           O  
ATOM     84  CB  ARG A   9      25.220  78.726  11.598  1.00  0.00           C  
ATOM     85  CG  ARG A   9      25.608  80.195  11.628  1.00  0.00           C  
ATOM     86  CD  ARG A   9      24.532  81.041  12.294  1.00  0.00           C  
ATOM     87  NE  ARG A   9      24.496  82.399  11.759  1.00  0.00           N  
ATOM     88  CZ  ARG A   9      23.423  83.180  11.809  1.00  0.00           C  
ATOM     89  NH1 ARG A   9      22.304  82.740  12.366  1.00  0.00           N  
ATOM     90  NH2 ARG A   9      23.468  84.406  11.301  1.00  0.00           N  
ATOM     91  H   ARG A   9      27.343  77.207  12.334  1.00  0.00           H  
ATOM     92  HA  ARG A   9      25.194  78.648  13.736  1.00  0.00           H  
ATOM     93  HB2 ARG A   9      25.792  78.242  10.819  1.00  0.00           H  
ATOM     94  HB3 ARG A   9      24.170  78.657  11.356  1.00  0.00           H  
ATOM     95  HG2 ARG A   9      26.528  80.303  12.182  1.00  0.00           H  
ATOM     96  HG3 ARG A   9      25.750  80.541  10.615  1.00  0.00           H  
ATOM     97  HD2 ARG A   9      23.573  80.574  12.129  1.00  0.00           H  
ATOM     98  HD3 ARG A   9      24.734  81.085  13.353  1.00  0.00           H  
ATOM     99  HE  ARG A   9      25.313  82.745  11.343  1.00  0.00           H  
ATOM    100 HH11 ARG A   9      22.267  81.817  12.751  1.00  0.00           H  
ATOM    101 HH12 ARG A   9      21.497  83.330  12.403  1.00  0.00           H  
ATOM    102 HH21 ARG A   9      24.310  84.741  10.881  1.00  0.00           H  
ATOM    103 HH22 ARG A   9      22.660  84.992  11.339  1.00  0.00           H  
ATOM    104  N   LEU A  10      24.995  75.729  12.207  1.00  0.00           N  
ATOM    105  CA  LEU A  10      24.265  74.467  12.178  1.00  0.00           C  
ATOM    106  C   LEU A  10      22.759  74.710  12.151  1.00  0.00           C  
ATOM    107  O   LEU A  10      22.001  74.051  12.862  1.00  0.00           O  
ATOM    108  CB  LEU A  10      24.633  73.612  13.393  1.00  0.00           C  
ATOM    109  CG  LEU A  10      25.874  72.733  13.242  1.00  0.00           C  
ATOM    110  CD1 LEU A  10      27.089  73.577  12.891  1.00  0.00           C  
ATOM    111  CD2 LEU A  10      26.124  71.940  14.518  1.00  0.00           C  
ATOM    112  H   LEU A  10      25.786  75.836  11.639  1.00  0.00           H  
ATOM    113  HA  LEU A  10      24.549  73.940  11.279  1.00  0.00           H  
ATOM    114  HB2 LEU A  10      24.798  74.277  14.226  1.00  0.00           H  
ATOM    115  HB3 LEU A  10      23.792  72.968  13.610  1.00  0.00           H  
ATOM    116  HG  LEU A  10      25.713  72.028  12.437  1.00  0.00           H  
ATOM    117 HD11 LEU A  10      27.412  74.123  13.764  1.00  0.00           H  
ATOM    118 HD12 LEU A  10      26.828  74.273  12.107  1.00  0.00           H  
ATOM    119 HD13 LEU A  10      27.888  72.934  12.551  1.00  0.00           H  
ATOM    120 HD21 LEU A  10      26.188  72.620  15.356  1.00  0.00           H  
ATOM    121 HD22 LEU A  10      27.051  71.393  14.427  1.00  0.00           H  
ATOM    122 HD23 LEU A  10      25.310  71.248  14.677  1.00  0.00           H  
ATOM    123  N   TRP A  11      22.333  75.658  11.323  1.00  0.00           N  
ATOM    124  CA  TRP A  11      20.917  75.985  11.201  1.00  0.00           C  
ATOM    125  C   TRP A  11      20.185  74.938  10.370  1.00  0.00           C  
ATOM    126  O   TRP A  11      20.806  74.174   9.633  1.00  0.00           O  
ATOM    127  CB  TRP A  11      20.746  77.368  10.569  1.00  0.00           C  
ATOM    128  CG  TRP A  11      21.323  77.466   9.189  1.00  0.00           C  
ATOM    129  CD1 TRP A  11      21.075  76.632   8.136  1.00  0.00           C  
ATOM    130  CD2 TRP A  11      22.247  78.451   8.715  1.00  0.00           C  
ATOM    131  NE1 TRP A  11      21.789  77.040   7.035  1.00  0.00           N  
ATOM    132  CE2 TRP A  11      22.514  78.154   7.364  1.00  0.00           C  
ATOM    133  CE3 TRP A  11      22.871  79.557   9.299  1.00  0.00           C  
ATOM    134  CZ2 TRP A  11      23.381  78.923   6.591  1.00  0.00           C  
ATOM    135  CZ3 TRP A  11      23.731  80.318   8.530  1.00  0.00           C  
ATOM    136  CH2 TRP A  11      23.979  80.000   7.188  1.00  0.00           C  
ATOM    137  H   TRP A  11      22.986  76.148  10.782  1.00  0.00           H  
ATOM    138  HA  TRP A  11      20.494  76.000  12.195  1.00  0.00           H  
ATOM    139  HB2 TRP A  11      19.693  77.600  10.507  1.00  0.00           H  
ATOM    140  HB3 TRP A  11      21.237  78.102  11.190  1.00  0.00           H  
ATOM    141  HD1 TRP A  11      20.414  75.780   8.178  1.00  0.00           H  
ATOM    142  HE1 TRP A  11      21.778  76.605   6.157  1.00  0.00           H  
ATOM    143  HE3 TRP A  11      22.693  79.818  10.331  1.00  0.00           H  
ATOM    144  HZ2 TRP A  11      23.582  78.691   5.556  1.00  0.00           H  
ATOM    145  HZ3 TRP A  11      24.223  81.176   8.964  1.00  0.00           H  
ATOM    146  HH2 TRP A  11      24.658  80.622   6.626  1.00  0.00           H  
ATOM    147  N   GLU A  12      18.862  74.909  10.495  1.00  0.00           N  
ATOM    148  CA  GLU A  12      18.047  73.954   9.754  1.00  0.00           C  
ATOM    149  C   GLU A  12      18.218  74.143   8.249  1.00  0.00           C  
ATOM    150  O   GLU A  12      17.905  75.201   7.706  1.00  0.00           O  
ATOM    151  CB  GLU A  12      16.572  74.106  10.133  1.00  0.00           C  
ATOM    152  CG  GLU A  12      16.252  73.627  11.539  1.00  0.00           C  
ATOM    153  CD  GLU A  12      14.839  73.973  11.966  1.00  0.00           C  
ATOM    154  OE1 GLU A  12      13.892  73.588  11.248  1.00  0.00           O  
ATOM    155  OE2 GLU A  12      14.680  74.628  13.017  1.00  0.00           O  
ATOM    156  H   GLU A  12      18.424  75.544  11.098  1.00  0.00           H  
ATOM    157  HA  GLU A  12      18.376  72.961  10.019  1.00  0.00           H  
ATOM    158  HB2 GLU A  12      16.299  75.148  10.058  1.00  0.00           H  
ATOM    159  HB3 GLU A  12      15.973  73.536   9.436  1.00  0.00           H  
ATOM    160  HG2 GLU A  12      16.370  72.555  11.576  1.00  0.00           H  
ATOM    161  HG3 GLU A  12      16.945  74.088  12.228  1.00  0.00           H  
ATOM    162  N   GLY A  13      18.721  73.108   7.582  1.00  0.00           N  
ATOM    163  CA  GLY A  13      18.926  73.180   6.147  1.00  0.00           C  
ATOM    164  C   GLY A  13      20.359  73.515   5.783  1.00  0.00           C  
ATOM    165  O   GLY A  13      20.623  74.058   4.710  1.00  0.00           O  
ATOM    166  H   GLY A  13      18.953  72.289   8.067  1.00  0.00           H  
ATOM    167  HA2 GLY A  13      18.668  72.228   5.709  1.00  0.00           H  
ATOM    168  HA3 GLY A  13      18.277  73.941   5.739  1.00  0.00           H  
ATOM    169  N   GLN A  14      21.286  73.193   6.679  1.00  0.00           N  
ATOM    170  CA  GLN A  14      22.700  73.466   6.447  1.00  0.00           C  
ATOM    171  C   GLN A  14      23.467  72.175   6.181  1.00  0.00           C  
ATOM    172  O   GLN A  14      23.538  71.296   7.040  1.00  0.00           O  
ATOM    173  CB  GLN A  14      23.304  74.195   7.648  1.00  0.00           C  
ATOM    174  CG  GLN A  14      24.821  74.107   7.714  1.00  0.00           C  
ATOM    175  CD  GLN A  14      25.393  74.795   8.937  1.00  0.00           C  
ATOM    176  OE1 GLN A  14      26.111  74.184   9.729  1.00  0.00           O  
ATOM    177  NE2 GLN A  14      25.079  76.075   9.097  1.00  0.00           N  
ATOM    178  H   GLN A  14      21.014  72.763   7.516  1.00  0.00           H  
ATOM    179  HA  GLN A  14      22.777  74.101   5.577  1.00  0.00           H  
ATOM    180  HB2 GLN A  14      23.027  75.237   7.599  1.00  0.00           H  
ATOM    181  HB3 GLN A  14      22.902  73.766   8.554  1.00  0.00           H  
ATOM    182  HG2 GLN A  14      25.107  73.066   7.739  1.00  0.00           H  
ATOM    183  HG3 GLN A  14      25.233  74.572   6.831  1.00  0.00           H  
ATOM    184 HE21 GLN A  14      24.501  76.497   8.427  1.00  0.00           H  
ATOM    185 HE22 GLN A  14      25.434  76.545   9.879  1.00  0.00           H  
ATOM    186  N   ASP A  15      24.040  72.068   4.988  1.00  0.00           N  
ATOM    187  CA  ASP A  15      24.803  70.884   4.609  1.00  0.00           C  
ATOM    188  C   ASP A  15      26.044  70.734   5.485  1.00  0.00           C  
ATOM    189  O   ASP A  15      26.964  71.549   5.418  1.00  0.00           O  
ATOM    190  CB  ASP A  15      25.209  70.962   3.136  1.00  0.00           C  
ATOM    191  CG  ASP A  15      24.035  71.274   2.229  1.00  0.00           C  
ATOM    192  OD1 ASP A  15      23.507  72.402   2.309  1.00  0.00           O  
ATOM    193  OD2 ASP A  15      23.646  70.390   1.438  1.00  0.00           O  
ATOM    194  H   ASP A  15      23.948  72.803   4.345  1.00  0.00           H  
ATOM    195  HA  ASP A  15      24.170  70.022   4.754  1.00  0.00           H  
ATOM    196  HB2 ASP A  15      25.950  71.739   3.015  1.00  0.00           H  
ATOM    197  HB3 ASP A  15      25.632  70.015   2.836  1.00  0.00           H  
ATOM    198  N   VAL A  16      26.060  69.690   6.306  1.00  0.00           N  
ATOM    199  CA  VAL A  16      27.188  69.433   7.194  1.00  0.00           C  
ATOM    200  C   VAL A  16      27.684  67.999   7.051  1.00  0.00           C  
ATOM    201  O   VAL A  16      27.113  67.203   6.303  1.00  0.00           O  
ATOM    202  CB  VAL A  16      26.813  69.691   8.665  1.00  0.00           C  
ATOM    203  CG1 VAL A  16      26.253  71.095   8.835  1.00  0.00           C  
ATOM    204  CG2 VAL A  16      25.818  68.648   9.152  1.00  0.00           C  
ATOM    205  H   VAL A  16      25.297  69.075   6.313  1.00  0.00           H  
ATOM    206  HA  VAL A  16      27.986  70.109   6.924  1.00  0.00           H  
ATOM    207  HB  VAL A  16      27.709  69.609   9.263  1.00  0.00           H  
ATOM    208 HG11 VAL A  16      26.179  71.328   9.887  1.00  0.00           H  
ATOM    209 HG12 VAL A  16      26.908  71.806   8.353  1.00  0.00           H  
ATOM    210 HG13 VAL A  16      25.272  71.148   8.387  1.00  0.00           H  
ATOM    211 HG21 VAL A  16      25.706  68.731  10.222  1.00  0.00           H  
ATOM    212 HG22 VAL A  16      24.861  68.814   8.676  1.00  0.00           H  
ATOM    213 HG23 VAL A  16      26.177  67.662   8.901  1.00  0.00           H  
ATOM    214  N   LEU A  17      28.750  67.673   7.773  1.00  0.00           N  
ATOM    215  CA  LEU A  17      29.326  66.333   7.728  1.00  0.00           C  
ATOM    216  C   LEU A  17      29.356  65.708   9.119  1.00  0.00           C  
ATOM    217  O   LEU A  17      30.086  66.163  10.000  1.00  0.00           O  
ATOM    218  CB  LEU A  17      30.740  66.382   7.148  1.00  0.00           C  
ATOM    219  CG  LEU A  17      30.896  67.127   5.821  1.00  0.00           C  
ATOM    220  CD1 LEU A  17      32.359  67.195   5.416  1.00  0.00           C  
ATOM    221  CD2 LEU A  17      30.068  66.457   4.734  1.00  0.00           C  
ATOM    222  H   LEU A  17      29.163  68.350   8.350  1.00  0.00           H  
ATOM    223  HA  LEU A  17      28.703  65.727   7.088  1.00  0.00           H  
ATOM    224  HB2 LEU A  17      31.378  66.863   7.873  1.00  0.00           H  
ATOM    225  HB3 LEU A  17      31.071  65.365   6.998  1.00  0.00           H  
ATOM    226  HG  LEU A  17      30.535  68.140   5.940  1.00  0.00           H  
ATOM    227 HD11 LEU A  17      32.827  66.239   5.594  1.00  0.00           H  
ATOM    228 HD12 LEU A  17      32.860  67.954   5.998  1.00  0.00           H  
ATOM    229 HD13 LEU A  17      32.430  67.440   4.366  1.00  0.00           H  
ATOM    230 HD21 LEU A  17      29.077  66.251   5.111  1.00  0.00           H  
ATOM    231 HD22 LEU A  17      30.542  65.530   4.442  1.00  0.00           H  
ATOM    232 HD23 LEU A  17      30.000  67.111   3.878  1.00  0.00           H  
ATOM    233  N   ALA A  18      28.561  64.660   9.308  1.00  0.00           N  
ATOM    234  CA  ALA A  18      28.500  63.969  10.590  1.00  0.00           C  
ATOM    235  C   ALA A  18      29.462  62.786  10.623  1.00  0.00           C  
ATOM    236  O   ALA A  18      29.411  61.908   9.760  1.00  0.00           O  
ATOM    237  CB  ALA A  18      27.079  63.503  10.872  1.00  0.00           C  
ATOM    238  H   ALA A  18      28.003  64.344   8.568  1.00  0.00           H  
ATOM    239  HA  ALA A  18      28.782  64.670  11.362  1.00  0.00           H  
ATOM    240  HB1 ALA A  18      26.389  64.063  10.257  1.00  0.00           H  
ATOM    241  HB2 ALA A  18      26.993  62.451  10.646  1.00  0.00           H  
ATOM    242  HB3 ALA A  18      26.847  63.668  11.914  1.00  0.00           H  
ATOM    243  N   ARG A  19      30.339  62.769  11.621  1.00  0.00           N  
ATOM    244  CA  ARG A  19      31.313  61.694  11.765  1.00  0.00           C  
ATOM    245  C   ARG A  19      30.630  60.389  12.159  1.00  0.00           C  
ATOM    246  O   ARG A  19      29.528  60.395  12.707  1.00  0.00           O  
ATOM    247  CB  ARG A  19      32.366  62.067  12.810  1.00  0.00           C  
ATOM    248  CG  ARG A  19      33.516  61.077  12.896  1.00  0.00           C  
ATOM    249  CD  ARG A  19      34.744  61.705  13.537  1.00  0.00           C  
ATOM    250  NE  ARG A  19      34.497  62.103  14.920  1.00  0.00           N  
ATOM    251  CZ  ARG A  19      35.292  62.919  15.603  1.00  0.00           C  
ATOM    252  NH1 ARG A  19      36.378  63.422  15.033  1.00  0.00           N  
ATOM    253  NH2 ARG A  19      35.000  63.235  16.858  1.00  0.00           N  
ATOM    254  H   ARG A  19      30.329  63.496  12.278  1.00  0.00           H  
ATOM    255  HA  ARG A  19      31.799  61.558  10.809  1.00  0.00           H  
ATOM    256  HB2 ARG A  19      32.774  63.037  12.563  1.00  0.00           H  
ATOM    257  HB3 ARG A  19      31.891  62.121  13.777  1.00  0.00           H  
ATOM    258  HG2 ARG A  19      33.206  60.231  13.492  1.00  0.00           H  
ATOM    259  HG3 ARG A  19      33.769  60.746  11.900  1.00  0.00           H  
ATOM    260  HD2 ARG A  19      35.550  60.986  13.518  1.00  0.00           H  
ATOM    261  HD3 ARG A  19      35.025  62.576  12.966  1.00  0.00           H  
ATOM    262  HE  ARG A  19      33.700  61.742  15.361  1.00  0.00           H  
ATOM    263 HH11 ARG A  19      36.600  63.187  14.086  1.00  0.00           H  
ATOM    264 HH12 ARG A  19      36.974  64.038  15.548  1.00  0.00           H  
ATOM    265 HH21 ARG A  19      34.182  62.858  17.292  1.00  0.00           H  
ATOM    266 HH22 ARG A  19      35.598  63.849  17.371  1.00  0.00           H  
ATOM    267  N   TRP A  20      31.291  59.271  11.876  1.00  0.00           N  
ATOM    268  CA  TRP A  20      30.746  57.958  12.201  1.00  0.00           C  
ATOM    269  C   TRP A  20      31.652  57.221  13.181  1.00  0.00           C  
ATOM    270  O   TRP A  20      32.805  57.604  13.386  1.00  0.00           O  
ATOM    271  CB  TRP A  20      30.567  57.129  10.929  1.00  0.00           C  
ATOM    272  CG  TRP A  20      29.453  56.130  11.024  1.00  0.00           C  
ATOM    273  CD1 TRP A  20      29.566  54.803  11.323  1.00  0.00           C  
ATOM    274  CD2 TRP A  20      28.058  56.379  10.816  1.00  0.00           C  
ATOM    275  NE1 TRP A  20      28.325  54.211  11.314  1.00  0.00           N  
ATOM    276  CE2 TRP A  20      27.384  55.157  11.006  1.00  0.00           C  
ATOM    277  CE3 TRP A  20      27.314  57.515  10.489  1.00  0.00           C  
ATOM    278  CZ2 TRP A  20      26.002  55.042  10.879  1.00  0.00           C  
ATOM    279  CZ3 TRP A  20      25.942  57.398  10.363  1.00  0.00           C  
ATOM    280  CH2 TRP A  20      25.298  56.170  10.558  1.00  0.00           C  
ATOM    281  H   TRP A  20      32.166  59.331  11.438  1.00  0.00           H  
ATOM    282  HA  TRP A  20      29.781  58.106  12.664  1.00  0.00           H  
ATOM    283  HB2 TRP A  20      30.352  57.790  10.103  1.00  0.00           H  
ATOM    284  HB3 TRP A  20      31.482  56.591  10.727  1.00  0.00           H  
ATOM    285  HD1 TRP A  20      30.500  54.304  11.533  1.00  0.00           H  
ATOM    286  HE1 TRP A  20      28.145  53.266  11.499  1.00  0.00           H  
ATOM    287  HE3 TRP A  20      27.792  58.471  10.334  1.00  0.00           H  
ATOM    288  HZ2 TRP A  20      25.491  54.102  11.027  1.00  0.00           H  
ATOM    289  HZ3 TRP A  20      25.350  58.267  10.111  1.00  0.00           H  
ATOM    290  HH2 TRP A  20      24.225  56.126  10.449  1.00  0.00           H  
ATOM    291  N   THR A  21      31.125  56.160  13.784  1.00  0.00           N  
ATOM    292  CA  THR A  21      31.887  55.368  14.743  1.00  0.00           C  
ATOM    293  C   THR A  21      33.277  55.045  14.206  1.00  0.00           C  
ATOM    294  O   THR A  21      34.223  54.869  14.974  1.00  0.00           O  
ATOM    295  CB  THR A  21      31.163  54.054  15.087  1.00  0.00           C  
ATOM    296  OG1 THR A  21      30.790  53.370  13.886  1.00  0.00           O  
ATOM    297  CG2 THR A  21      29.925  54.322  15.930  1.00  0.00           C  
ATOM    298  H   THR A  21      30.202  55.904  13.580  1.00  0.00           H  
ATOM    299  HA  THR A  21      31.988  55.948  15.648  1.00  0.00           H  
ATOM    300  HB  THR A  21      31.836  53.427  15.654  1.00  0.00           H  
ATOM    301  HG1 THR A  21      31.517  53.403  13.259  1.00  0.00           H  
ATOM    302 HG21 THR A  21      29.758  53.493  16.600  1.00  0.00           H  
ATOM    303 HG22 THR A  21      29.069  54.441  15.282  1.00  0.00           H  
ATOM    304 HG23 THR A  21      30.069  55.225  16.504  1.00  0.00           H  
ATOM    305  N   ASP A  22      33.393  54.967  12.886  1.00  0.00           N  
ATOM    306  CA  ASP A  22      34.669  54.665  12.246  1.00  0.00           C  
ATOM    307  C   ASP A  22      35.648  55.822  12.417  1.00  0.00           C  
ATOM    308  O   ASP A  22      36.832  55.613  12.684  1.00  0.00           O  
ATOM    309  CB  ASP A  22      34.462  54.371  10.760  1.00  0.00           C  
ATOM    310  CG  ASP A  22      35.499  53.412  10.210  1.00  0.00           C  
ATOM    311  OD1 ASP A  22      36.695  53.586  10.527  1.00  0.00           O  
ATOM    312  OD2 ASP A  22      35.116  52.488   9.463  1.00  0.00           O  
ATOM    313  H   ASP A  22      32.602  55.117  12.326  1.00  0.00           H  
ATOM    314  HA  ASP A  22      35.080  53.789  12.724  1.00  0.00           H  
ATOM    315  HB2 ASP A  22      33.484  53.934  10.619  1.00  0.00           H  
ATOM    316  HB3 ASP A  22      34.522  55.296  10.205  1.00  0.00           H  
ATOM    317  N   GLY A  23      35.148  57.044  12.260  1.00  0.00           N  
ATOM    318  CA  GLY A  23      35.993  58.215  12.399  1.00  0.00           C  
ATOM    319  C   GLY A  23      35.841  59.181  11.241  1.00  0.00           C  
ATOM    320  O   GLY A  23      35.894  60.398  11.427  1.00  0.00           O  
ATOM    321  H   GLY A  23      34.197  57.150  12.048  1.00  0.00           H  
ATOM    322  HA2 GLY A  23      35.735  58.725  13.316  1.00  0.00           H  
ATOM    323  HA3 GLY A  23      37.024  57.897  12.454  1.00  0.00           H  
ATOM    324  N   LEU A  24      35.651  58.640  10.044  1.00  0.00           N  
ATOM    325  CA  LEU A  24      35.492  59.463   8.849  1.00  0.00           C  
ATOM    326  C   LEU A  24      34.240  60.329   8.947  1.00  0.00           C  
ATOM    327  O   LEU A  24      33.386  60.110   9.808  1.00  0.00           O  
ATOM    328  CB  LEU A  24      35.417  58.578   7.603  1.00  0.00           C  
ATOM    329  CG  LEU A  24      36.738  57.967   7.133  1.00  0.00           C  
ATOM    330  CD1 LEU A  24      37.695  59.057   6.673  1.00  0.00           C  
ATOM    331  CD2 LEU A  24      37.366  57.136   8.242  1.00  0.00           C  
ATOM    332  H   LEU A  24      35.617  57.665   9.958  1.00  0.00           H  
ATOM    333  HA  LEU A  24      36.355  60.106   8.772  1.00  0.00           H  
ATOM    334  HB2 LEU A  24      34.735  57.769   7.812  1.00  0.00           H  
ATOM    335  HB3 LEU A  24      35.023  59.179   6.795  1.00  0.00           H  
ATOM    336  HG  LEU A  24      36.547  57.315   6.292  1.00  0.00           H  
ATOM    337 HD11 LEU A  24      37.894  59.730   7.493  1.00  0.00           H  
ATOM    338 HD12 LEU A  24      37.251  59.604   5.856  1.00  0.00           H  
ATOM    339 HD13 LEU A  24      38.621  58.606   6.344  1.00  0.00           H  
ATOM    340 HD21 LEU A  24      37.543  57.763   9.104  1.00  0.00           H  
ATOM    341 HD22 LEU A  24      38.303  56.725   7.897  1.00  0.00           H  
ATOM    342 HD23 LEU A  24      36.697  56.333   8.512  1.00  0.00           H  
ATOM    343  N   LEU A  25      34.136  61.312   8.060  1.00  0.00           N  
ATOM    344  CA  LEU A  25      32.987  62.211   8.045  1.00  0.00           C  
ATOM    345  C   LEU A  25      31.945  61.745   7.032  1.00  0.00           C  
ATOM    346  O   LEU A  25      32.284  61.325   5.926  1.00  0.00           O  
ATOM    347  CB  LEU A  25      33.434  63.636   7.715  1.00  0.00           C  
ATOM    348  CG  LEU A  25      34.497  64.235   8.636  1.00  0.00           C  
ATOM    349  CD1 LEU A  25      34.913  65.613   8.145  1.00  0.00           C  
ATOM    350  CD2 LEU A  25      33.985  64.310  10.066  1.00  0.00           C  
ATOM    351  H   LEU A  25      34.848  61.437   7.398  1.00  0.00           H  
ATOM    352  HA  LEU A  25      32.544  62.199   9.030  1.00  0.00           H  
ATOM    353  HB2 LEU A  25      33.828  63.635   6.711  1.00  0.00           H  
ATOM    354  HB3 LEU A  25      32.562  64.274   7.757  1.00  0.00           H  
ATOM    355  HG  LEU A  25      35.372  63.600   8.626  1.00  0.00           H  
ATOM    356 HD11 LEU A  25      34.214  66.351   8.507  1.00  0.00           H  
ATOM    357 HD12 LEU A  25      34.919  65.623   7.064  1.00  0.00           H  
ATOM    358 HD13 LEU A  25      35.903  65.842   8.511  1.00  0.00           H  
ATOM    359 HD21 LEU A  25      34.642  64.935  10.652  1.00  0.00           H  
ATOM    360 HD22 LEU A  25      33.958  63.317  10.492  1.00  0.00           H  
ATOM    361 HD23 LEU A  25      32.990  64.731  10.070  1.00  0.00           H  
ATOM    362  N   TYR A  26      30.676  61.826   7.417  1.00  0.00           N  
ATOM    363  CA  TYR A  26      29.585  61.412   6.543  1.00  0.00           C  
ATOM    364  C   TYR A  26      28.694  62.598   6.187  1.00  0.00           C  
ATOM    365  O   TYR A  26      28.547  63.538   6.971  1.00  0.00           O  
ATOM    366  CB  TYR A  26      28.753  60.318   7.214  1.00  0.00           C  
ATOM    367  CG  TYR A  26      29.460  58.985   7.295  1.00  0.00           C  
ATOM    368  CD1 TYR A  26      30.750  58.888   7.800  1.00  0.00           C  
ATOM    369  CD2 TYR A  26      28.836  57.819   6.865  1.00  0.00           C  
ATOM    370  CE1 TYR A  26      31.399  57.671   7.875  1.00  0.00           C  
ATOM    371  CE2 TYR A  26      29.478  56.598   6.938  1.00  0.00           C  
ATOM    372  CZ  TYR A  26      30.760  56.529   7.444  1.00  0.00           C  
ATOM    373  OH  TYR A  26      31.403  55.315   7.518  1.00  0.00           O  
ATOM    374  H   TYR A  26      30.469  62.170   8.310  1.00  0.00           H  
ATOM    375  HA  TYR A  26      30.018  61.017   5.636  1.00  0.00           H  
ATOM    376  HB2 TYR A  26      28.510  60.626   8.220  1.00  0.00           H  
ATOM    377  HB3 TYR A  26      27.839  60.177   6.656  1.00  0.00           H  
ATOM    378  HD1 TYR A  26      31.248  59.786   8.139  1.00  0.00           H  
ATOM    379  HD2 TYR A  26      27.833  57.876   6.470  1.00  0.00           H  
ATOM    380  HE1 TYR A  26      32.403  57.618   8.272  1.00  0.00           H  
ATOM    381  HE2 TYR A  26      28.977  55.702   6.599  1.00  0.00           H  
ATOM    382  HH  TYR A  26      31.212  54.804   6.727  1.00  0.00           H  
ATOM    383  N   LEU A  27      28.100  62.549   5.000  1.00  0.00           N  
ATOM    384  CA  LEU A  27      27.221  63.618   4.539  1.00  0.00           C  
ATOM    385  C   LEU A  27      25.925  63.643   5.343  1.00  0.00           C  
ATOM    386  O   LEU A  27      25.178  62.666   5.367  1.00  0.00           O  
ATOM    387  CB  LEU A  27      26.908  63.440   3.051  1.00  0.00           C  
ATOM    388  CG  LEU A  27      26.646  64.725   2.264  1.00  0.00           C  
ATOM    389  CD1 LEU A  27      26.705  64.455   0.768  1.00  0.00           C  
ATOM    390  CD2 LEU A  27      25.299  65.320   2.647  1.00  0.00           C  
ATOM    391  H   LEU A  27      28.254  61.775   4.420  1.00  0.00           H  
ATOM    392  HA  LEU A  27      27.737  64.555   4.681  1.00  0.00           H  
ATOM    393  HB2 LEU A  27      27.747  62.939   2.595  1.00  0.00           H  
ATOM    394  HB3 LEU A  27      26.029  62.817   2.971  1.00  0.00           H  
ATOM    395  HG  LEU A  27      27.413  65.449   2.502  1.00  0.00           H  
ATOM    396 HD11 LEU A  27      27.435  63.685   0.570  1.00  0.00           H  
ATOM    397 HD12 LEU A  27      26.986  65.360   0.250  1.00  0.00           H  
ATOM    398 HD13 LEU A  27      25.734  64.130   0.424  1.00  0.00           H  
ATOM    399 HD21 LEU A  27      25.059  65.042   3.663  1.00  0.00           H  
ATOM    400 HD22 LEU A  27      24.536  64.944   1.981  1.00  0.00           H  
ATOM    401 HD23 LEU A  27      25.346  66.397   2.570  1.00  0.00           H  
ATOM    402  N   GLY A  28      25.663  64.769   5.999  1.00  0.00           N  
ATOM    403  CA  GLY A  28      24.456  64.902   6.794  1.00  0.00           C  
ATOM    404  C   GLY A  28      23.796  66.256   6.623  1.00  0.00           C  
ATOM    405  O   GLY A  28      24.467  67.255   6.366  1.00  0.00           O  
ATOM    406  H   GLY A  28      26.295  65.516   5.943  1.00  0.00           H  
ATOM    407  HA2 GLY A  28      23.757  64.133   6.498  1.00  0.00           H  
ATOM    408  HA3 GLY A  28      24.708  64.766   7.835  1.00  0.00           H  
ATOM    409  N   THR A  29      22.475  66.291   6.767  1.00  0.00           N  
ATOM    410  CA  THR A  29      21.723  67.531   6.625  1.00  0.00           C  
ATOM    411  C   THR A  29      21.079  67.938   7.946  1.00  0.00           C  
ATOM    412  O   THR A  29      20.343  67.160   8.553  1.00  0.00           O  
ATOM    413  CB  THR A  29      20.627  67.404   5.549  1.00  0.00           C  
ATOM    414  OG1 THR A  29      21.221  67.144   4.273  1.00  0.00           O  
ATOM    415  CG2 THR A  29      19.790  68.672   5.478  1.00  0.00           C  
ATOM    416  H   THR A  29      21.995  65.461   6.972  1.00  0.00           H  
ATOM    417  HA  THR A  29      22.411  68.304   6.317  1.00  0.00           H  
ATOM    418  HB  THR A  29      19.981  66.578   5.812  1.00  0.00           H  
ATOM    419  HG1 THR A  29      22.068  66.709   4.396  1.00  0.00           H  
ATOM    420 HG21 THR A  29      19.753  69.021   4.457  1.00  0.00           H  
ATOM    421 HG22 THR A  29      20.235  69.433   6.102  1.00  0.00           H  
ATOM    422 HG23 THR A  29      18.789  68.462   5.823  1.00  0.00           H  
ATOM    423  N   ILE A  30      21.360  69.160   8.384  1.00  0.00           N  
ATOM    424  CA  ILE A  30      20.806  69.670   9.631  1.00  0.00           C  
ATOM    425  C   ILE A  30      19.281  69.670   9.597  1.00  0.00           C  
ATOM    426  O   ILE A  30      18.663  70.562   9.016  1.00  0.00           O  
ATOM    427  CB  ILE A  30      21.301  71.099   9.925  1.00  0.00           C  
ATOM    428  CG1 ILE A  30      22.829  71.123  10.019  1.00  0.00           C  
ATOM    429  CG2 ILE A  30      20.679  71.621  11.212  1.00  0.00           C  
ATOM    430  CD1 ILE A  30      23.371  70.409  11.238  1.00  0.00           C  
ATOM    431  H   ILE A  30      21.953  69.733   7.854  1.00  0.00           H  
ATOM    432  HA  ILE A  30      21.137  69.024  10.431  1.00  0.00           H  
ATOM    433  HB  ILE A  30      20.988  71.739   9.115  1.00  0.00           H  
ATOM    434 HG12 ILE A  30      23.244  70.647   9.145  1.00  0.00           H  
ATOM    435 HG13 ILE A  30      23.163  72.149  10.058  1.00  0.00           H  
ATOM    436 HG21 ILE A  30      20.198  72.569  11.019  1.00  0.00           H  
ATOM    437 HG22 ILE A  30      19.945  70.914  11.569  1.00  0.00           H  
ATOM    438 HG23 ILE A  30      21.448  71.752  11.957  1.00  0.00           H  
ATOM    439 HD11 ILE A  30      23.945  69.549  10.926  1.00  0.00           H  
ATOM    440 HD12 ILE A  30      24.003  71.081  11.797  1.00  0.00           H  
ATOM    441 HD13 ILE A  30      22.550  70.085  11.860  1.00  0.00           H  
ATOM    442  N   LYS A  31      18.681  68.665  10.225  1.00  0.00           N  
ATOM    443  CA  LYS A  31      17.228  68.549  10.270  1.00  0.00           C  
ATOM    444  C   LYS A  31      16.656  69.329  11.449  1.00  0.00           C  
ATOM    445  O   LYS A  31      15.646  70.020  11.318  1.00  0.00           O  
ATOM    446  CB  LYS A  31      16.817  67.079  10.369  1.00  0.00           C  
ATOM    447  CG  LYS A  31      17.649  66.153   9.499  1.00  0.00           C  
ATOM    448  CD  LYS A  31      17.650  66.602   8.048  1.00  0.00           C  
ATOM    449  CE  LYS A  31      16.480  66.008   7.279  1.00  0.00           C  
ATOM    450  NZ  LYS A  31      16.787  65.856   5.830  1.00  0.00           N  
ATOM    451  H   LYS A  31      19.229  67.984  10.670  1.00  0.00           H  
ATOM    452  HA  LYS A  31      16.834  68.962   9.354  1.00  0.00           H  
ATOM    453  HB2 LYS A  31      16.915  66.758  11.396  1.00  0.00           H  
ATOM    454  HB3 LYS A  31      15.782  66.986  10.070  1.00  0.00           H  
ATOM    455  HG2 LYS A  31      18.666  66.149   9.863  1.00  0.00           H  
ATOM    456  HG3 LYS A  31      17.240  65.154   9.557  1.00  0.00           H  
ATOM    457  HD2 LYS A  31      17.577  67.680   8.014  1.00  0.00           H  
ATOM    458  HD3 LYS A  31      18.573  66.287   7.582  1.00  0.00           H  
ATOM    459  HE2 LYS A  31      16.250  65.038   7.693  1.00  0.00           H  
ATOM    460  HE3 LYS A  31      15.624  66.658   7.391  1.00  0.00           H  
ATOM    461  HZ1 LYS A  31      16.807  66.789   5.371  1.00  0.00           H  
ATOM    462  HZ2 LYS A  31      16.061  65.272   5.370  1.00  0.00           H  
ATOM    463  HZ3 LYS A  31      17.714  65.401   5.707  1.00  0.00           H  
ATOM    464  N   LYS A  32      17.309  69.214  12.600  1.00  0.00           N  
ATOM    465  CA  LYS A  32      16.868  69.911  13.803  1.00  0.00           C  
ATOM    466  C   LYS A  32      18.060  70.442  14.592  1.00  0.00           C  
ATOM    467  O   LYS A  32      19.177  69.942  14.460  1.00  0.00           O  
ATOM    468  CB  LYS A  32      16.036  68.975  14.683  1.00  0.00           C  
ATOM    469  CG  LYS A  32      15.074  69.703  15.606  1.00  0.00           C  
ATOM    470  CD  LYS A  32      14.612  68.811  16.746  1.00  0.00           C  
ATOM    471  CE  LYS A  32      13.353  68.042  16.378  1.00  0.00           C  
ATOM    472  NZ  LYS A  32      12.137  68.897  16.461  1.00  0.00           N  
ATOM    473  H   LYS A  32      18.109  68.649  12.642  1.00  0.00           H  
ATOM    474  HA  LYS A  32      16.254  70.744  13.497  1.00  0.00           H  
ATOM    475  HB2 LYS A  32      15.464  68.317  14.047  1.00  0.00           H  
ATOM    476  HB3 LYS A  32      16.706  68.383  15.290  1.00  0.00           H  
ATOM    477  HG2 LYS A  32      15.570  70.568  16.018  1.00  0.00           H  
ATOM    478  HG3 LYS A  32      14.211  70.018  15.035  1.00  0.00           H  
ATOM    479  HD2 LYS A  32      15.396  68.106  16.980  1.00  0.00           H  
ATOM    480  HD3 LYS A  32      14.408  69.425  17.612  1.00  0.00           H  
ATOM    481  HE2 LYS A  32      13.454  67.673  15.369  1.00  0.00           H  
ATOM    482  HE3 LYS A  32      13.245  67.209  17.056  1.00  0.00           H  
ATOM    483  HZ1 LYS A  32      11.301  68.360  16.152  1.00  0.00           H  
ATOM    484  HZ2 LYS A  32      12.245  69.732  15.853  1.00  0.00           H  
ATOM    485  HZ3 LYS A  32      11.989  69.213  17.442  1.00  0.00           H  
ATOM    486  N   VAL A  33      17.815  71.458  15.415  1.00  0.00           N  
ATOM    487  CA  VAL A  33      18.868  72.056  16.227  1.00  0.00           C  
ATOM    488  C   VAL A  33      18.376  72.334  17.643  1.00  0.00           C  
ATOM    489  O   VAL A  33      17.530  73.202  17.859  1.00  0.00           O  
ATOM    490  CB  VAL A  33      19.380  73.367  15.605  1.00  0.00           C  
ATOM    491  CG1 VAL A  33      18.215  74.265  15.215  1.00  0.00           C  
ATOM    492  CG2 VAL A  33      20.315  74.084  16.569  1.00  0.00           C  
ATOM    493  H   VAL A  33      16.903  71.814  15.476  1.00  0.00           H  
ATOM    494  HA  VAL A  33      19.691  71.357  16.273  1.00  0.00           H  
ATOM    495  HB  VAL A  33      19.935  73.126  14.711  1.00  0.00           H  
ATOM    496 HG11 VAL A  33      18.576  75.071  14.593  1.00  0.00           H  
ATOM    497 HG12 VAL A  33      17.483  73.687  14.669  1.00  0.00           H  
ATOM    498 HG13 VAL A  33      17.761  74.673  16.105  1.00  0.00           H  
ATOM    499 HG21 VAL A  33      20.860  74.850  16.036  1.00  0.00           H  
ATOM    500 HG22 VAL A  33      19.738  74.537  17.361  1.00  0.00           H  
ATOM    501 HG23 VAL A  33      21.011  73.374  16.990  1.00  0.00           H  
ATOM    502  N   ASP A  34      18.914  71.594  18.607  1.00  0.00           N  
ATOM    503  CA  ASP A  34      18.533  71.762  20.003  1.00  0.00           C  
ATOM    504  C   ASP A  34      19.632  72.475  20.785  1.00  0.00           C  
ATOM    505  O   ASP A  34      20.773  72.016  20.828  1.00  0.00           O  
ATOM    506  CB  ASP A  34      18.235  70.404  20.640  1.00  0.00           C  
ATOM    507  CG  ASP A  34      16.779  70.007  20.503  1.00  0.00           C  
ATOM    508  OD1 ASP A  34      15.906  70.790  20.937  1.00  0.00           O  
ATOM    509  OD2 ASP A  34      16.511  68.915  19.962  1.00  0.00           O  
ATOM    510  H   ASP A  34      19.585  70.918  18.372  1.00  0.00           H  
ATOM    511  HA  ASP A  34      17.639  72.367  20.032  1.00  0.00           H  
ATOM    512  HB2 ASP A  34      18.841  69.648  20.162  1.00  0.00           H  
ATOM    513  HB3 ASP A  34      18.481  70.445  21.691  1.00  0.00           H  
ATOM    514  N   SER A  35      19.280  73.599  21.401  1.00  0.00           N  
ATOM    515  CA  SER A  35      20.238  74.378  22.177  1.00  0.00           C  
ATOM    516  C   SER A  35      20.419  73.784  23.571  1.00  0.00           C  
ATOM    517  O   SER A  35      21.528  73.749  24.104  1.00  0.00           O  
ATOM    518  CB  SER A  35      19.777  75.832  22.286  1.00  0.00           C  
ATOM    519  OG  SER A  35      18.792  75.981  23.294  1.00  0.00           O  
ATOM    520  H   SER A  35      18.354  73.913  21.329  1.00  0.00           H  
ATOM    521  HA  SER A  35      21.186  74.347  21.660  1.00  0.00           H  
ATOM    522  HB2 SER A  35      20.622  76.458  22.529  1.00  0.00           H  
ATOM    523  HB3 SER A  35      19.358  76.146  21.340  1.00  0.00           H  
ATOM    524  HG  SER A  35      19.170  76.439  24.047  1.00  0.00           H  
ATOM    525  N   ALA A  36      19.320  73.319  24.155  1.00  0.00           N  
ATOM    526  CA  ALA A  36      19.355  72.724  25.486  1.00  0.00           C  
ATOM    527  C   ALA A  36      20.466  71.686  25.594  1.00  0.00           C  
ATOM    528  O   ALA A  36      21.341  71.787  26.454  1.00  0.00           O  
ATOM    529  CB  ALA A  36      18.010  72.099  25.820  1.00  0.00           C  
ATOM    530  H   ALA A  36      18.464  73.375  23.680  1.00  0.00           H  
ATOM    531  HA  ALA A  36      19.544  73.515  26.199  1.00  0.00           H  
ATOM    532  HB1 ALA A  36      17.851  72.137  26.889  1.00  0.00           H  
ATOM    533  HB2 ALA A  36      17.224  72.644  25.320  1.00  0.00           H  
ATOM    534  HB3 ALA A  36      18.000  71.071  25.492  1.00  0.00           H  
ATOM    535  N   ARG A  37      20.423  70.688  24.717  1.00  0.00           N  
ATOM    536  CA  ARG A  37      21.425  69.629  24.716  1.00  0.00           C  
ATOM    537  C   ARG A  37      22.576  69.971  23.774  1.00  0.00           C  
ATOM    538  O   ARG A  37      23.490  69.171  23.580  1.00  0.00           O  
ATOM    539  CB  ARG A  37      20.792  68.299  24.304  1.00  0.00           C  
ATOM    540  CG  ARG A  37      20.082  67.584  25.441  1.00  0.00           C  
ATOM    541  CD  ARG A  37      19.924  66.099  25.154  1.00  0.00           C  
ATOM    542  NE  ARG A  37      21.198  65.388  25.233  1.00  0.00           N  
ATOM    543  CZ  ARG A  37      21.302  64.064  25.224  1.00  0.00           C  
ATOM    544  NH1 ARG A  37      20.214  63.310  25.139  1.00  0.00           N  
ATOM    545  NH2 ARG A  37      22.496  63.490  25.300  1.00  0.00           N  
ATOM    546  H   ARG A  37      19.700  70.662  24.056  1.00  0.00           H  
ATOM    547  HA  ARG A  37      21.813  69.537  25.720  1.00  0.00           H  
ATOM    548  HB2 ARG A  37      20.073  68.484  23.519  1.00  0.00           H  
ATOM    549  HB3 ARG A  37      21.567  67.648  23.926  1.00  0.00           H  
ATOM    550  HG2 ARG A  37      20.660  67.705  26.347  1.00  0.00           H  
ATOM    551  HG3 ARG A  37      19.105  68.022  25.574  1.00  0.00           H  
ATOM    552  HD2 ARG A  37      19.242  65.676  25.876  1.00  0.00           H  
ATOM    553  HD3 ARG A  37      19.517  65.980  24.161  1.00  0.00           H  
ATOM    554  HE  ARG A  37      22.015  65.925  25.297  1.00  0.00           H  
ATOM    555 HH11 ARG A  37      19.313  63.740  25.081  1.00  0.00           H  
ATOM    556 HH12 ARG A  37      20.295  62.314  25.131  1.00  0.00           H  
ATOM    557 HH21 ARG A  37      23.318  64.054  25.364  1.00  0.00           H  
ATOM    558 HH22 ARG A  37      22.573  62.493  25.293  1.00  0.00           H  
ATOM    559  N   GLU A  38      22.522  71.165  23.191  1.00  0.00           N  
ATOM    560  CA  GLU A  38      23.559  71.610  22.268  1.00  0.00           C  
ATOM    561  C   GLU A  38      23.844  70.545  21.213  1.00  0.00           C  
ATOM    562  O   GLU A  38      24.989  70.132  21.025  1.00  0.00           O  
ATOM    563  CB  GLU A  38      24.843  71.945  23.031  1.00  0.00           C  
ATOM    564  CG  GLU A  38      24.782  73.270  23.773  1.00  0.00           C  
ATOM    565  CD  GLU A  38      26.158  73.835  24.069  1.00  0.00           C  
ATOM    566  OE1 GLU A  38      26.903  73.206  24.848  1.00  0.00           O  
ATOM    567  OE2 GLU A  38      26.489  74.907  23.522  1.00  0.00           O  
ATOM    568  H   GLU A  38      21.767  71.758  23.386  1.00  0.00           H  
ATOM    569  HA  GLU A  38      23.203  72.502  21.774  1.00  0.00           H  
ATOM    570  HB2 GLU A  38      25.034  71.161  23.749  1.00  0.00           H  
ATOM    571  HB3 GLU A  38      25.663  71.986  22.329  1.00  0.00           H  
ATOM    572  HG2 GLU A  38      24.240  73.981  23.169  1.00  0.00           H  
ATOM    573  HG3 GLU A  38      24.261  73.120  24.708  1.00  0.00           H  
ATOM    574  N   VAL A  39      22.794  70.103  20.528  1.00  0.00           N  
ATOM    575  CA  VAL A  39      22.931  69.086  19.492  1.00  0.00           C  
ATOM    576  C   VAL A  39      22.179  69.485  18.227  1.00  0.00           C  
ATOM    577  O   VAL A  39      21.542  70.538  18.179  1.00  0.00           O  
ATOM    578  CB  VAL A  39      22.409  67.720  19.976  1.00  0.00           C  
ATOM    579  CG1 VAL A  39      22.774  67.494  21.435  1.00  0.00           C  
ATOM    580  CG2 VAL A  39      20.905  67.622  19.772  1.00  0.00           C  
ATOM    581  H   VAL A  39      21.907  70.471  20.723  1.00  0.00           H  
ATOM    582  HA  VAL A  39      23.981  68.985  19.259  1.00  0.00           H  
ATOM    583  HB  VAL A  39      22.881  66.948  19.386  1.00  0.00           H  
ATOM    584 HG11 VAL A  39      22.638  66.451  21.683  1.00  0.00           H  
ATOM    585 HG12 VAL A  39      23.806  67.771  21.595  1.00  0.00           H  
ATOM    586 HG13 VAL A  39      22.136  68.099  22.063  1.00  0.00           H  
ATOM    587 HG21 VAL A  39      20.679  67.693  18.719  1.00  0.00           H  
ATOM    588 HG22 VAL A  39      20.550  66.675  20.153  1.00  0.00           H  
ATOM    589 HG23 VAL A  39      20.417  68.426  20.301  1.00  0.00           H  
ATOM    590  N   CYS A  40      22.260  68.640  17.206  1.00  0.00           N  
ATOM    591  CA  CYS A  40      21.587  68.906  15.939  1.00  0.00           C  
ATOM    592  C   CYS A  40      21.177  67.603  15.259  1.00  0.00           C  
ATOM    593  O   CYS A  40      22.022  66.772  14.922  1.00  0.00           O  
ATOM    594  CB  CYS A  40      22.497  69.714  15.014  1.00  0.00           C  
ATOM    595  SG  CYS A  40      22.894  71.368  15.629  1.00  0.00           S  
ATOM    596  H   CYS A  40      22.783  67.817  17.306  1.00  0.00           H  
ATOM    597  HA  CYS A  40      20.699  69.482  16.150  1.00  0.00           H  
ATOM    598  HB2 CYS A  40      23.429  69.182  14.883  1.00  0.00           H  
ATOM    599  HB3 CYS A  40      22.016  69.824  14.054  1.00  0.00           H  
ATOM    600  HG  CYS A  40      22.292  72.249  14.844  1.00  0.00           H  
ATOM    601  N   LEU A  41      19.874  67.431  15.059  1.00  0.00           N  
ATOM    602  CA  LEU A  41      19.352  66.228  14.420  1.00  0.00           C  
ATOM    603  C   LEU A  41      19.672  66.222  12.929  1.00  0.00           C  
ATOM    604  O   LEU A  41      19.067  66.959  12.150  1.00  0.00           O  
ATOM    605  CB  LEU A  41      17.838  66.134  14.629  1.00  0.00           C  
ATOM    606  CG  LEU A  41      17.181  64.828  14.183  1.00  0.00           C  
ATOM    607  CD1 LEU A  41      17.166  63.821  15.322  1.00  0.00           C  
ATOM    608  CD2 LEU A  41      15.768  65.088  13.681  1.00  0.00           C  
ATOM    609  H   LEU A  41      19.250  68.128  15.349  1.00  0.00           H  
ATOM    610  HA  LEU A  41      19.824  65.375  14.882  1.00  0.00           H  
ATOM    611  HB2 LEU A  41      17.643  66.260  15.682  1.00  0.00           H  
ATOM    612  HB3 LEU A  41      17.379  66.943  14.079  1.00  0.00           H  
ATOM    613  HG  LEU A  41      17.753  64.403  13.370  1.00  0.00           H  
ATOM    614 HD11 LEU A  41      16.164  63.736  15.714  1.00  0.00           H  
ATOM    615 HD12 LEU A  41      17.833  64.153  16.105  1.00  0.00           H  
ATOM    616 HD13 LEU A  41      17.494  62.858  14.956  1.00  0.00           H  
ATOM    617 HD21 LEU A  41      15.248  64.148  13.567  1.00  0.00           H  
ATOM    618 HD22 LEU A  41      15.812  65.592  12.726  1.00  0.00           H  
ATOM    619 HD23 LEU A  41      15.242  65.707  14.391  1.00  0.00           H  
ATOM    620  N   VAL A  42      20.625  65.383  12.537  1.00  0.00           N  
ATOM    621  CA  VAL A  42      21.024  65.277  11.139  1.00  0.00           C  
ATOM    622  C   VAL A  42      20.503  63.988  10.515  1.00  0.00           C  
ATOM    623  O   VAL A  42      20.347  62.975  11.198  1.00  0.00           O  
ATOM    624  CB  VAL A  42      22.556  65.325  10.987  1.00  0.00           C  
ATOM    625  CG1 VAL A  42      22.951  65.252   9.520  1.00  0.00           C  
ATOM    626  CG2 VAL A  42      23.117  66.580  11.637  1.00  0.00           C  
ATOM    627  H   VAL A  42      21.071  64.821  13.205  1.00  0.00           H  
ATOM    628  HA  VAL A  42      20.605  66.118  10.608  1.00  0.00           H  
ATOM    629  HB  VAL A  42      22.975  64.466  11.491  1.00  0.00           H  
ATOM    630 HG11 VAL A  42      22.175  65.703   8.917  1.00  0.00           H  
ATOM    631 HG12 VAL A  42      23.878  65.784   9.369  1.00  0.00           H  
ATOM    632 HG13 VAL A  42      23.075  64.219   9.231  1.00  0.00           H  
ATOM    633 HG21 VAL A  42      22.519  66.836  12.500  1.00  0.00           H  
ATOM    634 HG22 VAL A  42      24.137  66.402  11.947  1.00  0.00           H  
ATOM    635 HG23 VAL A  42      23.094  67.395  10.929  1.00  0.00           H  
ATOM    636  N   GLN A  43      20.235  64.032   9.214  1.00  0.00           N  
ATOM    637  CA  GLN A  43      19.731  62.866   8.499  1.00  0.00           C  
ATOM    638  C   GLN A  43      20.784  62.319   7.540  1.00  0.00           C  
ATOM    639  O   GLN A  43      21.622  63.063   7.031  1.00  0.00           O  
ATOM    640  CB  GLN A  43      18.460  63.225   7.727  1.00  0.00           C  
ATOM    641  CG  GLN A  43      18.036  62.164   6.725  1.00  0.00           C  
ATOM    642  CD  GLN A  43      17.031  62.683   5.715  1.00  0.00           C  
ATOM    643  OE1 GLN A  43      17.399  63.313   4.723  1.00  0.00           O  
ATOM    644  NE2 GLN A  43      15.753  62.421   5.963  1.00  0.00           N  
ATOM    645  H   GLN A  43      20.380  64.868   8.725  1.00  0.00           H  
ATOM    646  HA  GLN A  43      19.496  62.106   9.228  1.00  0.00           H  
ATOM    647  HB2 GLN A  43      17.654  63.368   8.431  1.00  0.00           H  
ATOM    648  HB3 GLN A  43      18.628  64.148   7.191  1.00  0.00           H  
ATOM    649  HG2 GLN A  43      18.910  61.818   6.194  1.00  0.00           H  
ATOM    650  HG3 GLN A  43      17.592  61.339   7.261  1.00  0.00           H  
ATOM    651 HE21 GLN A  43      15.533  61.914   6.774  1.00  0.00           H  
ATOM    652 HE22 GLN A  43      15.082  62.745   5.328  1.00  0.00           H  
ATOM    653  N   PHE A  44      20.735  61.012   7.298  1.00  0.00           N  
ATOM    654  CA  PHE A  44      21.685  60.364   6.402  1.00  0.00           C  
ATOM    655  C   PHE A  44      20.993  59.888   5.128  1.00  0.00           C  
ATOM    656  O   PHE A  44      19.769  59.760   5.085  1.00  0.00           O  
ATOM    657  CB  PHE A  44      22.355  59.182   7.103  1.00  0.00           C  
ATOM    658  CG  PHE A  44      22.918  59.526   8.453  1.00  0.00           C  
ATOM    659  CD1 PHE A  44      23.658  60.683   8.635  1.00  0.00           C  
ATOM    660  CD2 PHE A  44      22.705  58.693   9.541  1.00  0.00           C  
ATOM    661  CE1 PHE A  44      24.177  61.001   9.876  1.00  0.00           C  
ATOM    662  CE2 PHE A  44      23.221  59.007  10.784  1.00  0.00           C  
ATOM    663  CZ  PHE A  44      23.957  60.163  10.951  1.00  0.00           C  
ATOM    664  H   PHE A  44      20.042  60.471   7.734  1.00  0.00           H  
ATOM    665  HA  PHE A  44      22.438  61.090   6.138  1.00  0.00           H  
ATOM    666  HB2 PHE A  44      21.630  58.394   7.239  1.00  0.00           H  
ATOM    667  HB3 PHE A  44      23.165  58.820   6.488  1.00  0.00           H  
ATOM    668  HD1 PHE A  44      23.830  61.340   7.796  1.00  0.00           H  
ATOM    669  HD2 PHE A  44      22.128  57.788   9.410  1.00  0.00           H  
ATOM    670  HE1 PHE A  44      24.753  61.906  10.005  1.00  0.00           H  
ATOM    671  HE2 PHE A  44      23.047  58.349  11.622  1.00  0.00           H  
ATOM    672  HZ  PHE A  44      24.362  60.410  11.922  1.00  0.00           H  
ATOM    673  N   GLU A  45      21.786  59.629   4.092  1.00  0.00           N  
ATOM    674  CA  GLU A  45      21.250  59.168   2.818  1.00  0.00           C  
ATOM    675  C   GLU A  45      20.323  57.972   3.017  1.00  0.00           C  
ATOM    676  O   GLU A  45      19.504  57.657   2.153  1.00  0.00           O  
ATOM    677  CB  GLU A  45      22.387  58.793   1.866  1.00  0.00           C  
ATOM    678  CG  GLU A  45      23.375  59.921   1.624  1.00  0.00           C  
ATOM    679  CD  GLU A  45      24.362  59.606   0.517  1.00  0.00           C  
ATOM    680  OE1 GLU A  45      24.796  58.438   0.423  1.00  0.00           O  
ATOM    681  OE2 GLU A  45      24.700  60.527  -0.255  1.00  0.00           O  
ATOM    682  H   GLU A  45      22.753  59.749   4.189  1.00  0.00           H  
ATOM    683  HA  GLU A  45      20.683  59.978   2.385  1.00  0.00           H  
ATOM    684  HB2 GLU A  45      22.926  57.953   2.281  1.00  0.00           H  
ATOM    685  HB3 GLU A  45      21.964  58.504   0.915  1.00  0.00           H  
ATOM    686  HG2 GLU A  45      22.827  60.812   1.354  1.00  0.00           H  
ATOM    687  HG3 GLU A  45      23.926  60.102   2.536  1.00  0.00           H  
ATOM    688  N   ASP A  46      20.460  57.309   4.159  1.00  0.00           N  
ATOM    689  CA  ASP A  46      19.636  56.147   4.474  1.00  0.00           C  
ATOM    690  C   ASP A  46      18.448  56.544   5.345  1.00  0.00           C  
ATOM    691  O   ASP A  46      18.132  55.870   6.326  1.00  0.00           O  
ATOM    692  CB  ASP A  46      20.471  55.080   5.182  1.00  0.00           C  
ATOM    693  CG  ASP A  46      19.690  53.803   5.427  1.00  0.00           C  
ATOM    694  OD1 ASP A  46      18.967  53.366   4.508  1.00  0.00           O  
ATOM    695  OD2 ASP A  46      19.803  53.243   6.537  1.00  0.00           O  
ATOM    696  H   ASP A  46      21.131  57.609   4.808  1.00  0.00           H  
ATOM    697  HA  ASP A  46      19.265  55.743   3.544  1.00  0.00           H  
ATOM    698  HB2 ASP A  46      21.331  54.843   4.574  1.00  0.00           H  
ATOM    699  HB3 ASP A  46      20.803  55.466   6.135  1.00  0.00           H  
ATOM    700  N   ASP A  47      17.794  57.642   4.981  1.00  0.00           N  
ATOM    701  CA  ASP A  47      16.641  58.127   5.729  1.00  0.00           C  
ATOM    702  C   ASP A  47      16.852  57.951   7.229  1.00  0.00           C  
ATOM    703  O   ASP A  47      15.894  57.832   7.992  1.00  0.00           O  
ATOM    704  CB  ASP A  47      15.373  57.392   5.290  1.00  0.00           C  
ATOM    705  CG  ASP A  47      15.044  57.628   3.830  1.00  0.00           C  
ATOM    706  OD1 ASP A  47      15.094  58.797   3.391  1.00  0.00           O  
ATOM    707  OD2 ASP A  47      14.736  56.644   3.125  1.00  0.00           O  
ATOM    708  H   ASP A  47      18.094  58.135   4.189  1.00  0.00           H  
ATOM    709  HA  ASP A  47      16.527  59.181   5.516  1.00  0.00           H  
ATOM    710  HB2 ASP A  47      15.510  56.331   5.442  1.00  0.00           H  
ATOM    711  HB3 ASP A  47      14.542  57.733   5.888  1.00  0.00           H  
ATOM    712  N   SER A  48      18.115  57.933   7.646  1.00  0.00           N  
ATOM    713  CA  SER A  48      18.453  57.766   9.054  1.00  0.00           C  
ATOM    714  C   SER A  48      18.577  59.120   9.747  1.00  0.00           C  
ATOM    715  O   SER A  48      19.564  59.832   9.569  1.00  0.00           O  
ATOM    716  CB  SER A  48      19.760  56.986   9.198  1.00  0.00           C  
ATOM    717  OG  SER A  48      19.540  55.593   9.064  1.00  0.00           O  
ATOM    718  H   SER A  48      18.836  58.034   6.989  1.00  0.00           H  
ATOM    719  HA  SER A  48      17.656  57.207   9.523  1.00  0.00           H  
ATOM    720  HB2 SER A  48      20.453  57.304   8.433  1.00  0.00           H  
ATOM    721  HB3 SER A  48      20.186  57.179  10.172  1.00  0.00           H  
ATOM    722  HG  SER A  48      19.886  55.294   8.219  1.00  0.00           H  
ATOM    723  N   GLN A  49      17.567  59.466  10.540  1.00  0.00           N  
ATOM    724  CA  GLN A  49      17.562  60.735  11.260  1.00  0.00           C  
ATOM    725  C   GLN A  49      17.784  60.514  12.752  1.00  0.00           C  
ATOM    726  O   GLN A  49      16.982  59.862  13.421  1.00  0.00           O  
ATOM    727  CB  GLN A  49      16.240  61.469  11.032  1.00  0.00           C  
ATOM    728  CG  GLN A  49      15.683  61.300   9.628  1.00  0.00           C  
ATOM    729  CD  GLN A  49      14.278  61.852   9.486  1.00  0.00           C  
ATOM    730  OE1 GLN A  49      13.772  62.530  10.381  1.00  0.00           O  
ATOM    731  NE2 GLN A  49      13.640  61.565   8.358  1.00  0.00           N  
ATOM    732  H   GLN A  49      16.808  58.856  10.641  1.00  0.00           H  
ATOM    733  HA  GLN A  49      18.369  61.338  10.874  1.00  0.00           H  
ATOM    734  HB2 GLN A  49      15.509  61.096  11.733  1.00  0.00           H  
ATOM    735  HB3 GLN A  49      16.392  62.523  11.211  1.00  0.00           H  
ATOM    736  HG2 GLN A  49      16.328  61.817   8.933  1.00  0.00           H  
ATOM    737  HG3 GLN A  49      15.666  60.247   9.386  1.00  0.00           H  
ATOM    738 HE21 GLN A  49      14.106  61.018   7.690  1.00  0.00           H  
ATOM    739 HE22 GLN A  49      12.731  61.907   8.240  1.00  0.00           H  
ATOM    740  N   PHE A  50      18.879  61.061  13.269  1.00  0.00           N  
ATOM    741  CA  PHE A  50      19.209  60.923  14.683  1.00  0.00           C  
ATOM    742  C   PHE A  50      19.748  62.234  15.247  1.00  0.00           C  
ATOM    743  O   PHE A  50      19.932  63.209  14.516  1.00  0.00           O  
ATOM    744  CB  PHE A  50      20.236  59.808  14.883  1.00  0.00           C  
ATOM    745  CG  PHE A  50      20.176  59.173  16.243  1.00  0.00           C  
ATOM    746  CD1 PHE A  50      19.079  58.415  16.620  1.00  0.00           C  
ATOM    747  CD2 PHE A  50      21.216  59.333  17.143  1.00  0.00           C  
ATOM    748  CE1 PHE A  50      19.021  57.831  17.872  1.00  0.00           C  
ATOM    749  CE2 PHE A  50      21.164  58.751  18.396  1.00  0.00           C  
ATOM    750  CZ  PHE A  50      20.065  57.998  18.760  1.00  0.00           C  
ATOM    751  H   PHE A  50      19.480  61.570  12.686  1.00  0.00           H  
ATOM    752  HA  PHE A  50      18.303  60.665  15.210  1.00  0.00           H  
ATOM    753  HB2 PHE A  50      20.065  59.034  14.149  1.00  0.00           H  
ATOM    754  HB3 PHE A  50      21.228  60.213  14.748  1.00  0.00           H  
ATOM    755  HD1 PHE A  50      18.262  58.283  15.926  1.00  0.00           H  
ATOM    756  HD2 PHE A  50      22.077  59.923  16.860  1.00  0.00           H  
ATOM    757  HE1 PHE A  50      18.160  57.242  18.153  1.00  0.00           H  
ATOM    758  HE2 PHE A  50      21.982  58.884  19.088  1.00  0.00           H  
ATOM    759  HZ  PHE A  50      20.022  57.543  19.738  1.00  0.00           H  
ATOM    760  N   LEU A  51      20.000  62.251  16.551  1.00  0.00           N  
ATOM    761  CA  LEU A  51      20.519  63.443  17.215  1.00  0.00           C  
ATOM    762  C   LEU A  51      22.043  63.429  17.244  1.00  0.00           C  
ATOM    763  O   LEU A  51      22.655  62.618  17.938  1.00  0.00           O  
ATOM    764  CB  LEU A  51      19.971  63.536  18.640  1.00  0.00           C  
ATOM    765  CG  LEU A  51      18.515  63.984  18.772  1.00  0.00           C  
ATOM    766  CD1 LEU A  51      18.009  63.744  20.186  1.00  0.00           C  
ATOM    767  CD2 LEU A  51      18.371  65.451  18.393  1.00  0.00           C  
ATOM    768  H   LEU A  51      19.834  61.445  17.082  1.00  0.00           H  
ATOM    769  HA  LEU A  51      20.188  64.305  16.654  1.00  0.00           H  
ATOM    770  HB2 LEU A  51      20.059  62.560  19.092  1.00  0.00           H  
ATOM    771  HB3 LEU A  51      20.585  64.240  19.184  1.00  0.00           H  
ATOM    772  HG  LEU A  51      17.903  63.401  18.096  1.00  0.00           H  
ATOM    773 HD11 LEU A  51      17.679  64.679  20.613  1.00  0.00           H  
ATOM    774 HD12 LEU A  51      18.806  63.334  20.788  1.00  0.00           H  
ATOM    775 HD13 LEU A  51      17.183  63.047  20.159  1.00  0.00           H  
ATOM    776 HD21 LEU A  51      19.098  66.034  18.937  1.00  0.00           H  
ATOM    777 HD22 LEU A  51      17.377  65.790  18.642  1.00  0.00           H  
ATOM    778 HD23 LEU A  51      18.537  65.566  17.333  1.00  0.00           H  
ATOM    779  N   VAL A  52      22.652  64.337  16.486  1.00  0.00           N  
ATOM    780  CA  VAL A  52      24.106  64.432  16.427  1.00  0.00           C  
ATOM    781  C   VAL A  52      24.609  65.648  17.197  1.00  0.00           C  
ATOM    782  O   VAL A  52      24.245  66.785  16.892  1.00  0.00           O  
ATOM    783  CB  VAL A  52      24.604  64.519  14.971  1.00  0.00           C  
ATOM    784  CG1 VAL A  52      26.120  64.407  14.918  1.00  0.00           C  
ATOM    785  CG2 VAL A  52      23.951  63.440  14.120  1.00  0.00           C  
ATOM    786  H   VAL A  52      22.111  64.958  15.954  1.00  0.00           H  
ATOM    787  HA  VAL A  52      24.518  63.539  16.873  1.00  0.00           H  
ATOM    788  HB  VAL A  52      24.322  65.482  14.573  1.00  0.00           H  
ATOM    789 HG11 VAL A  52      26.503  65.064  14.151  1.00  0.00           H  
ATOM    790 HG12 VAL A  52      26.536  64.687  15.875  1.00  0.00           H  
ATOM    791 HG13 VAL A  52      26.398  63.388  14.690  1.00  0.00           H  
ATOM    792 HG21 VAL A  52      24.714  62.894  13.586  1.00  0.00           H  
ATOM    793 HG22 VAL A  52      23.403  62.761  14.758  1.00  0.00           H  
ATOM    794 HG23 VAL A  52      23.274  63.898  13.415  1.00  0.00           H  
ATOM    795  N   LEU A  53      25.447  65.402  18.198  1.00  0.00           N  
ATOM    796  CA  LEU A  53      26.001  66.476  19.014  1.00  0.00           C  
ATOM    797  C   LEU A  53      26.551  67.597  18.138  1.00  0.00           C  
ATOM    798  O   LEU A  53      26.693  67.437  16.925  1.00  0.00           O  
ATOM    799  CB  LEU A  53      27.106  65.935  19.923  1.00  0.00           C  
ATOM    800  CG  LEU A  53      26.667  64.929  20.987  1.00  0.00           C  
ATOM    801  CD1 LEU A  53      27.877  64.252  21.612  1.00  0.00           C  
ATOM    802  CD2 LEU A  53      25.827  65.615  22.054  1.00  0.00           C  
ATOM    803  H   LEU A  53      25.700  64.476  18.394  1.00  0.00           H  
ATOM    804  HA  LEU A  53      25.205  66.873  19.626  1.00  0.00           H  
ATOM    805  HB2 LEU A  53      27.842  65.455  19.297  1.00  0.00           H  
ATOM    806  HB3 LEU A  53      27.560  66.776  20.428  1.00  0.00           H  
ATOM    807  HG  LEU A  53      26.061  64.165  20.522  1.00  0.00           H  
ATOM    808 HD11 LEU A  53      28.752  64.866  21.461  1.00  0.00           H  
ATOM    809 HD12 LEU A  53      28.028  63.288  21.150  1.00  0.00           H  
ATOM    810 HD13 LEU A  53      27.708  64.120  22.672  1.00  0.00           H  
ATOM    811 HD21 LEU A  53      26.467  65.946  22.859  1.00  0.00           H  
ATOM    812 HD22 LEU A  53      25.096  64.919  22.439  1.00  0.00           H  
ATOM    813 HD23 LEU A  53      25.321  66.467  21.623  1.00  0.00           H  
ATOM    814  N   TRP A  54      26.861  68.729  18.759  1.00  0.00           N  
ATOM    815  CA  TRP A  54      27.399  69.875  18.035  1.00  0.00           C  
ATOM    816  C   TRP A  54      28.862  69.651  17.669  1.00  0.00           C  
ATOM    817  O   TRP A  54      29.300  70.007  16.575  1.00  0.00           O  
ATOM    818  CB  TRP A  54      27.259  71.146  18.876  1.00  0.00           C  
ATOM    819  CG  TRP A  54      25.882  71.735  18.838  1.00  0.00           C  
ATOM    820  CD1 TRP A  54      24.768  71.181  18.274  1.00  0.00           C  
ATOM    821  CD2 TRP A  54      25.473  72.994  19.385  1.00  0.00           C  
ATOM    822  NE1 TRP A  54      23.691  72.019  18.437  1.00  0.00           N  
ATOM    823  CE2 TRP A  54      24.098  73.138  19.117  1.00  0.00           C  
ATOM    824  CE3 TRP A  54      26.134  74.012  20.077  1.00  0.00           C  
ATOM    825  CZ2 TRP A  54      23.375  74.259  19.514  1.00  0.00           C  
ATOM    826  CZ3 TRP A  54      25.415  75.125  20.471  1.00  0.00           C  
ATOM    827  CH2 TRP A  54      24.047  75.240  20.190  1.00  0.00           C  
ATOM    828  H   TRP A  54      26.726  68.795  19.728  1.00  0.00           H  
ATOM    829  HA  TRP A  54      26.825  69.992  17.127  1.00  0.00           H  
ATOM    830  HB2 TRP A  54      27.496  70.918  19.904  1.00  0.00           H  
ATOM    831  HB3 TRP A  54      27.952  71.889  18.508  1.00  0.00           H  
ATOM    832  HD1 TRP A  54      24.752  70.224  17.775  1.00  0.00           H  
ATOM    833  HE1 TRP A  54      22.781  71.844  18.120  1.00  0.00           H  
ATOM    834  HE3 TRP A  54      27.188  73.942  20.302  1.00  0.00           H  
ATOM    835  HZ2 TRP A  54      22.320  74.362  19.306  1.00  0.00           H  
ATOM    836  HZ3 TRP A  54      25.910  75.922  21.006  1.00  0.00           H  
ATOM    837  HH2 TRP A  54      23.526  76.127  20.517  1.00  0.00           H  
ATOM    838  N   LYS A  55      29.614  69.060  18.590  1.00  0.00           N  
ATOM    839  CA  LYS A  55      31.028  68.787  18.364  1.00  0.00           C  
ATOM    840  C   LYS A  55      31.209  67.660  17.351  1.00  0.00           C  
ATOM    841  O   LYS A  55      32.089  67.720  16.492  1.00  0.00           O  
ATOM    842  CB  LYS A  55      31.714  68.418  19.680  1.00  0.00           C  
ATOM    843  CG  LYS A  55      31.017  67.302  20.439  1.00  0.00           C  
ATOM    844  CD  LYS A  55      31.916  66.707  21.510  1.00  0.00           C  
ATOM    845  CE  LYS A  55      31.315  65.443  22.104  1.00  0.00           C  
ATOM    846  NZ  LYS A  55      30.412  65.743  23.249  1.00  0.00           N  
ATOM    847  H   LYS A  55      29.208  68.799  19.444  1.00  0.00           H  
ATOM    848  HA  LYS A  55      31.481  69.684  17.970  1.00  0.00           H  
ATOM    849  HB2 LYS A  55      32.726  68.104  19.470  1.00  0.00           H  
ATOM    850  HB3 LYS A  55      31.743  69.292  20.315  1.00  0.00           H  
ATOM    851  HG2 LYS A  55      30.129  67.698  20.908  1.00  0.00           H  
ATOM    852  HG3 LYS A  55      30.741  66.523  19.742  1.00  0.00           H  
ATOM    853  HD2 LYS A  55      32.873  66.467  21.072  1.00  0.00           H  
ATOM    854  HD3 LYS A  55      32.052  67.436  22.297  1.00  0.00           H  
ATOM    855  HE2 LYS A  55      30.753  64.933  21.337  1.00  0.00           H  
ATOM    856  HE3 LYS A  55      32.117  64.805  22.446  1.00  0.00           H  
ATOM    857  HZ1 LYS A  55      29.541  66.195  22.908  1.00  0.00           H  
ATOM    858  HZ2 LYS A  55      30.885  66.385  23.918  1.00  0.00           H  
ATOM    859  HZ3 LYS A  55      30.162  64.865  23.747  1.00  0.00           H  
ATOM    860  N   ASP A  56      30.371  66.636  17.457  1.00  0.00           N  
ATOM    861  CA  ASP A  56      30.437  65.497  16.548  1.00  0.00           C  
ATOM    862  C   ASP A  56      30.278  65.948  15.099  1.00  0.00           C  
ATOM    863  O   ASP A  56      30.865  65.362  14.189  1.00  0.00           O  
ATOM    864  CB  ASP A  56      29.355  64.474  16.898  1.00  0.00           C  
ATOM    865  CG  ASP A  56      29.595  63.815  18.243  1.00  0.00           C  
ATOM    866  OD1 ASP A  56      29.919  64.538  19.208  1.00  0.00           O  
ATOM    867  OD2 ASP A  56      29.457  62.577  18.329  1.00  0.00           O  
ATOM    868  H   ASP A  56      29.690  66.646  18.162  1.00  0.00           H  
ATOM    869  HA  ASP A  56      31.406  65.035  16.664  1.00  0.00           H  
ATOM    870  HB2 ASP A  56      28.395  64.970  16.927  1.00  0.00           H  
ATOM    871  HB3 ASP A  56      29.335  63.706  16.139  1.00  0.00           H  
ATOM    872  N   ILE A  57      29.480  66.990  14.893  1.00  0.00           N  
ATOM    873  CA  ILE A  57      29.245  67.519  13.556  1.00  0.00           C  
ATOM    874  C   ILE A  57      30.465  68.274  13.040  1.00  0.00           C  
ATOM    875  O   ILE A  57      31.115  69.007  13.786  1.00  0.00           O  
ATOM    876  CB  ILE A  57      28.024  68.458  13.528  1.00  0.00           C  
ATOM    877  CG1 ILE A  57      26.766  67.708  13.969  1.00  0.00           C  
ATOM    878  CG2 ILE A  57      27.838  69.043  12.136  1.00  0.00           C  
ATOM    879  CD1 ILE A  57      25.742  68.591  14.648  1.00  0.00           C  
ATOM    880  H   ILE A  57      29.041  67.415  15.659  1.00  0.00           H  
ATOM    881  HA  ILE A  57      29.047  66.684  12.898  1.00  0.00           H  
ATOM    882  HB  ILE A  57      28.209  69.272  14.213  1.00  0.00           H  
ATOM    883 HG12 ILE A  57      26.298  67.262  13.105  1.00  0.00           H  
ATOM    884 HG13 ILE A  57      27.046  66.929  14.664  1.00  0.00           H  
ATOM    885 HG21 ILE A  57      28.540  69.851  11.989  1.00  0.00           H  
ATOM    886 HG22 ILE A  57      28.014  68.276  11.398  1.00  0.00           H  
ATOM    887 HG23 ILE A  57      26.830  69.419  12.035  1.00  0.00           H  
ATOM    888 HD11 ILE A  57      25.003  67.975  15.138  1.00  0.00           H  
ATOM    889 HD12 ILE A  57      26.233  69.217  15.379  1.00  0.00           H  
ATOM    890 HD13 ILE A  57      25.259  69.213  13.909  1.00  0.00           H  
ATOM    891  N   SER A  58      30.770  68.091  11.759  1.00  0.00           N  
ATOM    892  CA  SER A  58      31.914  68.753  11.144  1.00  0.00           C  
ATOM    893  C   SER A  58      31.460  69.724  10.058  1.00  0.00           C  
ATOM    894  O   SER A  58      30.502  69.472   9.327  1.00  0.00           O  
ATOM    895  CB  SER A  58      32.872  67.718  10.551  1.00  0.00           C  
ATOM    896  OG  SER A  58      34.207  68.194  10.560  1.00  0.00           O  
ATOM    897  H   SER A  58      30.214  67.494  11.217  1.00  0.00           H  
ATOM    898  HA  SER A  58      32.429  69.309  11.913  1.00  0.00           H  
ATOM    899  HB2 SER A  58      32.822  66.811  11.133  1.00  0.00           H  
ATOM    900  HB3 SER A  58      32.583  67.508   9.531  1.00  0.00           H  
ATOM    901  HG  SER A  58      34.762  67.601  10.049  1.00  0.00           H  
ATOM    902  N   PRO A  59      32.165  70.859   9.947  1.00  0.00           N  
ATOM    903  CA  PRO A  59      31.854  71.890   8.953  1.00  0.00           C  
ATOM    904  C   PRO A  59      32.172  71.440   7.532  1.00  0.00           C  
ATOM    905  O   PRO A  59      33.251  70.911   7.264  1.00  0.00           O  
ATOM    906  CB  PRO A  59      32.757  73.058   9.358  1.00  0.00           C  
ATOM    907  CG  PRO A  59      33.894  72.424  10.083  1.00  0.00           C  
ATOM    908  CD  PRO A  59      33.320  71.224  10.785  1.00  0.00           C  
ATOM    909  HA  PRO A  59      30.819  72.197   9.008  1.00  0.00           H  
ATOM    910  HB2 PRO A  59      33.093  73.580   8.473  1.00  0.00           H  
ATOM    911  HB3 PRO A  59      32.210  73.735   9.997  1.00  0.00           H  
ATOM    912  HG2 PRO A  59      34.653  72.119   9.379  1.00  0.00           H  
ATOM    913  HG3 PRO A  59      34.303  73.118  10.802  1.00  0.00           H  
ATOM    914  HD2 PRO A  59      34.042  70.423  10.814  1.00  0.00           H  
ATOM    915  HD3 PRO A  59      33.003  71.486  11.784  1.00  0.00           H  
ATOM    916  N   ALA A  60      31.226  71.653   6.622  1.00  0.00           N  
ATOM    917  CA  ALA A  60      31.408  71.270   5.227  1.00  0.00           C  
ATOM    918  C   ALA A  60      31.629  72.495   4.347  1.00  0.00           C  
ATOM    919  O   ALA A  60      30.709  73.280   4.116  1.00  0.00           O  
ATOM    920  CB  ALA A  60      30.206  70.475   4.737  1.00  0.00           C  
ATOM    921  H   ALA A  60      30.387  72.078   6.896  1.00  0.00           H  
ATOM    922  HA  ALA A  60      32.278  70.633   5.166  1.00  0.00           H  
ATOM    923  HB1 ALA A  60      29.495  71.147   4.278  1.00  0.00           H  
ATOM    924  HB2 ALA A  60      30.530  69.744   4.012  1.00  0.00           H  
ATOM    925  HB3 ALA A  60      29.741  69.974   5.573  1.00  0.00           H  
ATOM    926  N   ALA A  61      32.855  72.653   3.858  1.00  0.00           N  
ATOM    927  CA  ALA A  61      33.197  73.783   3.002  1.00  0.00           C  
ATOM    928  C   ALA A  61      32.587  73.623   1.613  1.00  0.00           C  
ATOM    929  O   ALA A  61      32.673  72.555   1.005  1.00  0.00           O  
ATOM    930  CB  ALA A  61      34.707  73.932   2.903  1.00  0.00           C  
ATOM    931  H   ALA A  61      33.545  71.995   4.079  1.00  0.00           H  
ATOM    932  HA  ALA A  61      32.799  74.679   3.458  1.00  0.00           H  
ATOM    933  HB1 ALA A  61      34.998  74.898   3.291  1.00  0.00           H  
ATOM    934  HB2 ALA A  61      35.184  73.154   3.480  1.00  0.00           H  
ATOM    935  HB3 ALA A  61      35.010  73.852   1.870  1.00  0.00           H  
ATOM    936  N   LEU A  62      31.970  74.689   1.116  1.00  0.00           N  
ATOM    937  CA  LEU A  62      31.344  74.668  -0.201  1.00  0.00           C  
ATOM    938  C   LEU A  62      32.341  75.070  -1.283  1.00  0.00           C  
ATOM    939  O   LEU A  62      32.557  74.337  -2.247  1.00  0.00           O  
ATOM    940  CB  LEU A  62      30.136  75.604  -0.230  1.00  0.00           C  
ATOM    941  CG  LEU A  62      28.816  75.012   0.266  1.00  0.00           C  
ATOM    942  CD1 LEU A  62      27.780  76.107   0.463  1.00  0.00           C  
ATOM    943  CD2 LEU A  62      28.304  73.961  -0.708  1.00  0.00           C  
ATOM    944  H   LEU A  62      31.934  75.511   1.647  1.00  0.00           H  
ATOM    945  HA  LEU A  62      31.012  73.658  -0.393  1.00  0.00           H  
ATOM    946  HB2 LEU A  62      30.366  76.459   0.386  1.00  0.00           H  
ATOM    947  HB3 LEU A  62      29.992  75.926  -1.251  1.00  0.00           H  
ATOM    948  HG  LEU A  62      28.980  74.532   1.222  1.00  0.00           H  
ATOM    949 HD11 LEU A  62      27.559  76.570  -0.486  1.00  0.00           H  
ATOM    950 HD12 LEU A  62      28.167  76.851   1.144  1.00  0.00           H  
ATOM    951 HD13 LEU A  62      26.877  75.679   0.875  1.00  0.00           H  
ATOM    952 HD21 LEU A  62      29.007  73.143  -0.756  1.00  0.00           H  
ATOM    953 HD22 LEU A  62      28.195  74.401  -1.688  1.00  0.00           H  
ATOM    954 HD23 LEU A  62      27.347  73.593  -0.370  1.00  0.00           H  
ATOM    955  N   SER A  63      32.946  76.243  -1.116  1.00  0.00           N  
ATOM    956  CA  SER A  63      33.919  76.744  -2.079  1.00  0.00           C  
ATOM    957  C   SER A  63      35.225  75.960  -1.992  1.00  0.00           C  
ATOM    958  O   SER A  63      35.632  75.303  -2.949  1.00  0.00           O  
ATOM    959  CB  SER A  63      34.186  78.231  -1.838  1.00  0.00           C  
ATOM    960  OG  SER A  63      35.152  78.730  -2.747  1.00  0.00           O  
ATOM    961  H   SER A  63      32.732  76.782  -0.327  1.00  0.00           H  
ATOM    962  HA  SER A  63      33.502  76.618  -3.067  1.00  0.00           H  
ATOM    963  HB2 SER A  63      33.269  78.785  -1.966  1.00  0.00           H  
ATOM    964  HB3 SER A  63      34.552  78.369  -0.831  1.00  0.00           H  
ATOM    965  HG  SER A  63      35.725  78.013  -3.031  1.00  0.00           H  
ATOM    966  N   GLY A  64      35.876  76.035  -0.836  1.00  0.00           N  
ATOM    967  CA  GLY A  64      37.129  75.328  -0.643  1.00  0.00           C  
ATOM    968  C   GLY A  64      38.192  76.196   0.002  1.00  0.00           C  
ATOM    969  O   GLY A  64      37.893  77.198   0.653  1.00  0.00           O  
ATOM    970  H   GLY A  64      35.503  76.574  -0.107  1.00  0.00           H  
ATOM    971  HA2 GLY A  64      36.952  74.468  -0.015  1.00  0.00           H  
ATOM    972  HA3 GLY A  64      37.490  74.992  -1.604  1.00  0.00           H  
ATOM    973  N   PRO A  65      39.464  75.810  -0.174  1.00  0.00           N  
ATOM    974  CA  PRO A  65      40.600  76.546   0.390  1.00  0.00           C  
ATOM    975  C   PRO A  65      40.811  77.895  -0.291  1.00  0.00           C  
ATOM    976  O   PRO A  65      41.582  78.005  -1.243  1.00  0.00           O  
ATOM    977  CB  PRO A  65      41.789  75.621   0.124  1.00  0.00           C  
ATOM    978  CG  PRO A  65      41.380  74.807  -1.055  1.00  0.00           C  
ATOM    979  CD  PRO A  65      39.891  74.626  -0.938  1.00  0.00           C  
ATOM    980  HA  PRO A  65      40.488  76.695   1.453  1.00  0.00           H  
ATOM    981  HB2 PRO A  65      42.668  76.212  -0.090  1.00  0.00           H  
ATOM    982  HB3 PRO A  65      41.967  74.999   0.988  1.00  0.00           H  
ATOM    983  HG2 PRO A  65      41.623  75.332  -1.966  1.00  0.00           H  
ATOM    984  HG3 PRO A  65      41.876  73.848  -1.030  1.00  0.00           H  
ATOM    985  HD2 PRO A  65      39.435  74.612  -1.916  1.00  0.00           H  
ATOM    986  HD3 PRO A  65      39.663  73.718  -0.400  1.00  0.00           H  
ATOM    987  N   SER A  66      40.122  78.917   0.205  1.00  0.00           N  
ATOM    988  CA  SER A  66      40.232  80.258  -0.357  1.00  0.00           C  
ATOM    989  C   SER A  66      41.687  80.715  -0.390  1.00  0.00           C  
ATOM    990  O   SER A  66      42.258  81.084   0.636  1.00  0.00           O  
ATOM    991  CB  SER A  66      39.394  81.246   0.457  1.00  0.00           C  
ATOM    992  OG  SER A  66      39.013  82.360  -0.330  1.00  0.00           O  
ATOM    993  H   SER A  66      39.523  78.765   0.966  1.00  0.00           H  
ATOM    994  HA  SER A  66      39.854  80.226  -1.368  1.00  0.00           H  
ATOM    995  HB2 SER A  66      38.504  80.750   0.814  1.00  0.00           H  
ATOM    996  HB3 SER A  66      39.974  81.597   1.300  1.00  0.00           H  
ATOM    997  HG  SER A  66      39.659  82.498  -1.026  1.00  0.00           H  
ATOM    998  N   SER A  67      42.283  80.688  -1.578  1.00  0.00           N  
ATOM    999  CA  SER A  67      43.673  81.094  -1.747  1.00  0.00           C  
ATOM   1000  C   SER A  67      43.760  82.485  -2.367  1.00  0.00           C  
ATOM   1001  O   SER A  67      42.904  82.878  -3.159  1.00  0.00           O  
ATOM   1002  CB  SER A  67      44.419  80.085  -2.621  1.00  0.00           C  
ATOM   1003  OG  SER A  67      44.778  78.933  -1.878  1.00  0.00           O  
ATOM   1004  H   SER A  67      41.775  80.383  -2.360  1.00  0.00           H  
ATOM   1005  HA  SER A  67      44.131  81.119  -0.769  1.00  0.00           H  
ATOM   1006  HB2 SER A  67      43.786  79.786  -3.442  1.00  0.00           H  
ATOM   1007  HB3 SER A  67      45.318  80.544  -3.008  1.00  0.00           H  
ATOM   1008  HG  SER A  67      45.727  78.799  -1.933  1.00  0.00           H  
ATOM   1009  N   GLY A  68      44.801  83.226  -2.000  1.00  0.00           N  
ATOM   1010  CA  GLY A  68      44.982  84.565  -2.530  1.00  0.00           C  
ATOM   1011  C   GLY A  68      45.244  85.588  -1.442  1.00  0.00           C  
ATOM   1012  O   GLY A  68      45.748  86.678  -1.714  1.00  0.00           O  
ATOM   1013  H   GLY A  68      45.452  82.861  -1.366  1.00  0.00           H  
ATOM   1014  HA2 GLY A  68      45.818  84.560  -3.214  1.00  0.00           H  
ATOM   1015  HA3 GLY A  68      44.090  84.850  -3.069  1.00  0.00           H  
TER    1016      GLY A  68                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
