
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1598),  selected  104 , name 2e6n_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2e6n_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    T     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    E    12_A      -       -           -
LGA    K    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    M    15_A      -       -           -
LGA    E    16_A      -       -           -
LGA    N    17_A      -       -           -
LGA    M    18_A      -       -           -
LGA    R    19_A      -       -           -
LGA    N    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    I    22_A      -       -           -
LGA    A    23_A      -       -           -
LGA    S    24_A      -       -           -
LGA    H    25_A      -       -           -
LGA    P    26_A      -       -           -
LGA    P    27_A      -       -           -
LGA    V    28_A      -       -           -
LGA    E    29_A      -       -           -
LGA    G    30_A      X      63          4.525
LGA    S    31_A      P      64          3.681
LGA    Y    32_A      P      65          4.552
LGA    A    33_A      A      66          2.794
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    P    34_A      L      69          2.930
LGA    R    35_A      Y      70          2.005
LGA    R    36_A      V      71          1.813
LGA    G    37_A      G      72          2.262
LGA    E    38_A      S      73          1.286
LGA    F    39_A      R      74          1.261
LGA    C    40_A      V      75          1.070
LGA    I    41_A      V      76          0.941
LGA    A    42_A      A      77          1.050
LGA    K    43_A      K      78          1.261
LGA    F    44_A      Y      79          1.179
LGA    V    45_A      K      80          2.252
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    D    46_A      Q      84          4.030
LGA    G    47_A      V      85          4.055
LGA    E    48_A      W      86          1.662
LGA    W    49_A      L      87          1.600
LGA    Y    50_A      Y      88          1.609
LGA    R    51_A      A      89          1.570
LGA    A    52_A      G      90          0.971
LGA    R    53_A      I      91          0.990
LGA    V    54_A      V      92          0.812
LGA    E    55_A      A      93          1.049
LGA    K    56_A      E      94          1.145
LGA    V    57_A      T      95          1.062
LGA    E    58_A      P      96          2.541
LGA    -       -      N      97           -
LGA    -       -      V      98           -
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    -       -      K     101           -
LGA    S    59_A      L     102          1.716
LGA    P    60_A      R     103          4.639
LGA    A    61_A      -       -           -
LGA    K    62_A      -       -           -
LGA    I    63_A      F     104          0.705
LGA    H    64_A      L     105          1.102
LGA    V    65_A      I     106          1.611
LGA    F    66_A      F     107          0.707
LGA    Y    67_A      F     108          1.148
LGA    I    68_A      D     109          2.568
LGA    D    69_A      -       -           -
LGA    Y    70_A      D     110          1.050
LGA    G    71_A      G     111          1.953
LGA    N    72_A      Y     112          2.212
LGA    R    73_A      A     113          1.507
LGA    E    74_A      S     114          1.337
LGA    V    75_A      Y     115          1.474
LGA    L    76_A      V     116          1.367
LGA    P    77_A      T     117          1.382
LGA    S    78_A      Q     118          1.340
LGA    T    79_A      S     119          1.506
LGA    R    80_A      E     120          1.173
LGA    L    81_A      L     121          0.745
LGA    G    82_A      Y     122          0.789
LGA    T    83_A      P     123          1.383
LGA    L    84_A      I     124          1.044
LGA    S    85_A      C     125          2.433
LGA    P    86_A      R     126          2.367
LGA    A    87_A      -       -           -
LGA    F    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    T    90_A      P     127           #
LGA    R    91_A      L     128          4.041
LGA    V    92_A      K     129           -
LGA    L    93_A      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    P    94_A      E     133          5.137
LGA    -       -      D     134           -
LGA    A    95_A      I     135          0.767
LGA    Q    96_A      E     136          1.892
LGA    A    97_A      D     137          3.555
LGA    -       -      I     138           -
LGA    T    98_A      S     139          3.395
LGA    E    99_A      C     140          2.422
LGA    Y   100_A      R     141          2.447
LGA    A   101_A      D     142          0.606
LGA    F   102_A      F     143          1.187
LGA    A   103_A      I     144          1.804
LGA    F   104_A      E     145          2.832
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104   93    5.0     66    2.23    15.15     58.364     2.835

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.971950 * X  +  -0.136055 * Y  +   0.191839 * Z  +  23.066608
  Y_new =   0.027008 * X  +   0.745721 * Y  +   0.665711 * Z  +  62.241810
  Z_new =  -0.233632 * X  +   0.652219 * Y  +  -0.721129 * Z  +   7.685365 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.406329   -0.735264  [ DEG:   137.8725    -42.1275 ]
  Theta =   0.235811    2.905782  [ DEG:    13.5110    166.4890 ]
  Phi   =   3.113812   -0.027780  [ DEG:   178.4083     -1.5917 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e6n_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e6n_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104   93   5.0   66   2.23   15.15  58.364
REMARK  ---------------------------------------------------------- 
MOLECULE 2e6n_A
HEADER    TRANSCRIPTION                           27-DEC-06   2E6N              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF STAPHYLOCOCCAL              
TITLE    2 NUCLEASE DOMAIN-CONTAINING PROTEIN 1                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STAPHYLOCOCCAL NUCLEASE DOMAIN-CONTAINING                  
COMPND   3 PROTEIN 1;                                                           
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   6 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   7 COACTIVATOR P100;                                                    
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060731-01;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, YUDOR DOMAIN, STAPHYLOCOCCAL NUCLEASE DOMAIN-                    
KEYWDS   2 CONTAINING PROTEIN 1, P100 CO-ACTIVATOR, 100 KDA                     
KEYWDS   3 COACTIVATOR, EBNA2 COACTIVATOR P100, STRUCTURAL GENOMICS,            
KEYWDS   4 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   5 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   6 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   03-JUL-07 2E6N    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF                    
JRNL        TITL 2 STAPHYLOCOCCAL NUCLEASE DOMAIN-CONTAINING PROTEIN 1          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E6N A    8   104  UNP    Q7KZF4   SND1_HUMAN     704    800             
SEQRES   1 A  104  GLY SER SER GLY SER SER GLY GLY THR GLN LEU GLU LYS          
SEQRES   2 A  104  LEU MET GLU ASN MET ARG ASN ASP ILE ALA SER HIS PRO          
SEQRES   3 A  104  PRO VAL GLU GLY SER TYR ALA PRO ARG ARG GLY GLU PHE          
SEQRES   4 A  104  CYS ILE ALA LYS PHE VAL ASP GLY GLU TRP TYR ARG ALA          
SEQRES   5 A  104  ARG VAL GLU LYS VAL GLU SER PRO ALA LYS ILE HIS VAL          
SEQRES   6 A  104  PHE TYR ILE ASP TYR GLY ASN ARG GLU VAL LEU PRO SER          
SEQRES   7 A  104  THR ARG LEU GLY THR LEU SER PRO ALA PHE SER THR ARG          
SEQRES   8 A  104  VAL LEU PRO ALA GLN ALA THR GLU TYR ALA PHE ALA PHE          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      44.613  54.748  -3.701  1.00  0.00           N  
ATOM      2  CA  GLY A   1      44.204  54.799  -5.092  1.00  0.00           C  
ATOM      3  C   GLY A   1      44.064  53.419  -5.706  1.00  0.00           C  
ATOM      4  O   GLY A   1      44.565  52.437  -5.160  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      43.253  55.308  -5.159  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      44.939  55.356  -5.653  1.00  0.00           H  
ATOM      7  H1  GLY A   1      45.530  54.487  -3.472  1.00  0.00           H  
ATOM      8  N   SER A   2      43.381  53.346  -6.844  1.00  0.00           N  
ATOM      9  CA  SER A   2      43.173  52.076  -7.530  1.00  0.00           C  
ATOM     10  C   SER A   2      43.489  52.204  -9.017  1.00  0.00           C  
ATOM     11  O   SER A   2      43.032  53.133  -9.683  1.00  0.00           O  
ATOM     12  CB  SER A   2      41.730  51.602  -7.343  1.00  0.00           C  
ATOM     13  OG  SER A   2      40.809  52.565  -7.829  1.00  0.00           O  
ATOM     14  H   SER A   2      43.005  54.166  -7.229  1.00  0.00           H  
ATOM     15  HA  SER A   2      43.841  51.350  -7.092  1.00  0.00           H  
ATOM     16  HB2 SER A   2      41.585  50.679  -7.882  1.00  0.00           H  
ATOM     17  HB3 SER A   2      41.541  51.439  -6.291  1.00  0.00           H  
ATOM     18  HG  SER A   2      40.846  53.350  -7.277  1.00  0.00           H  
ATOM     19  N   SER A   3      44.274  51.263  -9.531  1.00  0.00           N  
ATOM     20  CA  SER A   3      44.656  51.270 -10.939  1.00  0.00           C  
ATOM     21  C   SER A   3      44.439  49.898 -11.568  1.00  0.00           C  
ATOM     22  O   SER A   3      44.951  48.891 -11.080  1.00  0.00           O  
ATOM     23  CB  SER A   3      46.121  51.688 -11.089  1.00  0.00           C  
ATOM     24  OG  SER A   3      46.412  52.052 -12.427  1.00  0.00           O  
ATOM     25  H   SER A   3      44.607  50.547  -8.949  1.00  0.00           H  
ATOM     26  HA  SER A   3      44.032  51.990 -11.447  1.00  0.00           H  
ATOM     27  HB2 SER A   3      46.319  52.533 -10.448  1.00  0.00           H  
ATOM     28  HB3 SER A   3      46.758  50.863 -10.805  1.00  0.00           H  
ATOM     29  HG  SER A   3      47.318  51.810 -12.635  1.00  0.00           H  
ATOM     30  N   GLY A   4      43.676  49.867 -12.656  1.00  0.00           N  
ATOM     31  CA  GLY A   4      43.403  48.613 -13.335  1.00  0.00           C  
ATOM     32  C   GLY A   4      42.098  47.985 -12.891  1.00  0.00           C  
ATOM     33  O   GLY A   4      41.927  47.657 -11.717  1.00  0.00           O  
ATOM     34  H   GLY A   4      43.294  50.702 -13.000  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      43.359  48.795 -14.399  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      44.209  47.924 -13.130  1.00  0.00           H  
ATOM     37  N   SER A   5      41.173  47.818 -13.830  1.00  0.00           N  
ATOM     38  CA  SER A   5      39.873  47.230 -13.528  1.00  0.00           C  
ATOM     39  C   SER A   5      39.245  47.897 -12.307  1.00  0.00           C  
ATOM     40  O   SER A   5      38.668  47.228 -11.450  1.00  0.00           O  
ATOM     41  CB  SER A   5      40.014  45.726 -13.286  1.00  0.00           C  
ATOM     42  OG  SER A   5      40.007  45.010 -14.508  1.00  0.00           O  
ATOM     43  H   SER A   5      41.367  48.101 -14.749  1.00  0.00           H  
ATOM     44  HA  SER A   5      39.230  47.389 -14.381  1.00  0.00           H  
ATOM     45  HB2 SER A   5      40.945  45.532 -12.775  1.00  0.00           H  
ATOM     46  HB3 SER A   5      39.191  45.384 -12.676  1.00  0.00           H  
ATOM     47  HG  SER A   5      40.862  44.596 -14.643  1.00  0.00           H  
ATOM     48  N   SER A   6      39.363  49.218 -12.237  1.00  0.00           N  
ATOM     49  CA  SER A   6      38.812  49.977 -11.120  1.00  0.00           C  
ATOM     50  C   SER A   6      37.362  50.367 -11.392  1.00  0.00           C  
ATOM     51  O   SER A   6      36.807  50.043 -12.440  1.00  0.00           O  
ATOM     52  CB  SER A   6      39.649  51.231 -10.865  1.00  0.00           C  
ATOM     53  OG  SER A   6      40.919  50.896 -10.331  1.00  0.00           O  
ATOM     54  H   SER A   6      39.835  49.695 -12.952  1.00  0.00           H  
ATOM     55  HA  SER A   6      38.845  49.347 -10.244  1.00  0.00           H  
ATOM     56  HB2 SER A   6      39.791  51.762 -11.793  1.00  0.00           H  
ATOM     57  HB3 SER A   6      39.133  51.869 -10.161  1.00  0.00           H  
ATOM     58  HG  SER A   6      41.398  51.700 -10.116  1.00  0.00           H  
ATOM     59  N   GLY A   7      36.754  51.064 -10.436  1.00  0.00           N  
ATOM     60  CA  GLY A   7      35.375  51.487 -10.590  1.00  0.00           C  
ATOM     61  C   GLY A   7      34.601  51.424  -9.289  1.00  0.00           C  
ATOM     62  O   GLY A   7      34.655  50.424  -8.574  1.00  0.00           O  
ATOM     63  H   GLY A   7      37.247  51.294  -9.622  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      35.360  52.504 -10.957  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      34.892  50.847 -11.314  1.00  0.00           H  
ATOM     66  N   GLY A   8      33.877  52.496  -8.979  1.00  0.00           N  
ATOM     67  CA  GLY A   8      33.100  52.537  -7.754  1.00  0.00           C  
ATOM     68  C   GLY A   8      31.720  53.128  -7.963  1.00  0.00           C  
ATOM     69  O   GLY A   8      31.239  53.221  -9.093  1.00  0.00           O  
ATOM     70  H   GLY A   8      33.872  53.264  -9.587  1.00  0.00           H  
ATOM     71  HA2 GLY A   8      32.997  51.533  -7.371  1.00  0.00           H  
ATOM     72  HA3 GLY A   8      33.628  53.135  -7.026  1.00  0.00           H  
ATOM     73  N   THR A   9      31.077  53.528  -6.870  1.00  0.00           N  
ATOM     74  CA  THR A   9      29.743  54.110  -6.938  1.00  0.00           C  
ATOM     75  C   THR A   9      29.800  55.631  -6.848  1.00  0.00           C  
ATOM     76  O   THR A   9      30.651  56.188  -6.154  1.00  0.00           O  
ATOM     77  CB  THR A   9      28.839  53.574  -5.811  1.00  0.00           C  
ATOM     78  OG1 THR A   9      29.029  52.164  -5.659  1.00  0.00           O  
ATOM     79  CG2 THR A   9      27.375  53.864  -6.109  1.00  0.00           C  
ATOM     80  H   THR A   9      31.512  53.428  -5.998  1.00  0.00           H  
ATOM     81  HA  THR A   9      29.305  53.831  -7.885  1.00  0.00           H  
ATOM     82  HB  THR A   9      29.108  54.068  -4.888  1.00  0.00           H  
ATOM     83  HG1 THR A   9      29.632  51.999  -4.930  1.00  0.00           H  
ATOM     84 HG21 THR A   9      26.937  54.398  -5.278  1.00  0.00           H  
ATOM     85 HG22 THR A   9      26.847  52.934  -6.257  1.00  0.00           H  
ATOM     86 HG23 THR A   9      27.302  54.466  -7.002  1.00  0.00           H  
ATOM     87  N   GLN A  10      28.891  56.295  -7.552  1.00  0.00           N  
ATOM     88  CA  GLN A  10      28.840  57.753  -7.550  1.00  0.00           C  
ATOM     89  C   GLN A  10      29.217  58.309  -6.182  1.00  0.00           C  
ATOM     90  O   GLN A  10      30.209  59.026  -6.043  1.00  0.00           O  
ATOM     91  CB  GLN A  10      27.443  58.236  -7.943  1.00  0.00           C  
ATOM     92  CG  GLN A  10      27.218  58.293  -9.446  1.00  0.00           C  
ATOM     93  CD  GLN A  10      26.787  56.958 -10.023  1.00  0.00           C  
ATOM     94  OE1 GLN A  10      27.506  55.963  -9.921  1.00  0.00           O  
ATOM     95  NE2 GLN A  10      25.608  56.929 -10.632  1.00  0.00           N  
ATOM     96  H   GLN A  10      28.239  55.795  -8.085  1.00  0.00           H  
ATOM     97  HA  GLN A  10      29.552  58.110  -8.279  1.00  0.00           H  
ATOM     98  HB2 GLN A  10      26.710  57.567  -7.516  1.00  0.00           H  
ATOM     99  HB3 GLN A  10      27.291  59.227  -7.541  1.00  0.00           H  
ATOM    100  HG2 GLN A  10      26.450  59.022  -9.655  1.00  0.00           H  
ATOM    101  HG3 GLN A  10      28.139  58.594  -9.923  1.00  0.00           H  
ATOM    102 HE21 GLN A  10      25.090  57.760 -10.676  1.00  0.00           H  
ATOM    103 HE22 GLN A  10      25.305  56.080 -11.015  1.00  0.00           H  
ATOM    104  N   LEU A  11      28.419  57.977  -5.173  1.00  0.00           N  
ATOM    105  CA  LEU A  11      28.669  58.443  -3.814  1.00  0.00           C  
ATOM    106  C   LEU A  11      30.073  58.063  -3.356  1.00  0.00           C  
ATOM    107  O   LEU A  11      30.793  58.882  -2.787  1.00  0.00           O  
ATOM    108  CB  LEU A  11      27.631  57.858  -2.853  1.00  0.00           C  
ATOM    109  CG  LEU A  11      27.581  58.481  -1.458  1.00  0.00           C  
ATOM    110  CD1 LEU A  11      27.008  59.889  -1.523  1.00  0.00           C  
ATOM    111  CD2 LEU A  11      26.761  57.613  -0.515  1.00  0.00           C  
ATOM    112  H   LEU A  11      27.644  57.403  -5.346  1.00  0.00           H  
ATOM    113  HA  LEU A  11      28.581  59.520  -3.812  1.00  0.00           H  
ATOM    114  HB2 LEU A  11      26.659  57.978  -3.305  1.00  0.00           H  
ATOM    115  HB3 LEU A  11      27.845  56.805  -2.740  1.00  0.00           H  
ATOM    116  HG  LEU A  11      28.586  58.548  -1.064  1.00  0.00           H  
ATOM    117 HD11 LEU A  11      27.739  60.556  -1.955  1.00  0.00           H  
ATOM    118 HD12 LEU A  11      26.761  60.223  -0.526  1.00  0.00           H  
ATOM    119 HD13 LEU A  11      26.117  59.887  -2.133  1.00  0.00           H  
ATOM    120 HD21 LEU A  11      26.973  56.572  -0.710  1.00  0.00           H  
ATOM    121 HD22 LEU A  11      25.709  57.801  -0.675  1.00  0.00           H  
ATOM    122 HD23 LEU A  11      27.018  57.849   0.506  1.00  0.00           H  
ATOM    123  N   GLU A  12      30.456  56.816  -3.612  1.00  0.00           N  
ATOM    124  CA  GLU A  12      31.775  56.329  -3.228  1.00  0.00           C  
ATOM    125  C   GLU A  12      32.872  57.228  -3.789  1.00  0.00           C  
ATOM    126  O   GLU A  12      33.919  57.412  -3.168  1.00  0.00           O  
ATOM    127  CB  GLU A  12      31.977  54.894  -3.719  1.00  0.00           C  
ATOM    128  CG  GLU A  12      31.540  53.839  -2.715  1.00  0.00           C  
ATOM    129  CD  GLU A  12      32.152  54.052  -1.344  1.00  0.00           C  
ATOM    130  OE1 GLU A  12      33.386  53.913  -1.218  1.00  0.00           O  
ATOM    131  OE2 GLU A  12      31.397  54.354  -0.397  1.00  0.00           O  
ATOM    132  H   GLU A  12      29.836  56.209  -4.069  1.00  0.00           H  
ATOM    133  HA  GLU A  12      31.832  56.341  -2.150  1.00  0.00           H  
ATOM    134  HB2 GLU A  12      31.408  54.753  -4.627  1.00  0.00           H  
ATOM    135  HB3 GLU A  12      33.024  54.744  -3.934  1.00  0.00           H  
ATOM    136  HG2 GLU A  12      30.465  53.873  -2.622  1.00  0.00           H  
ATOM    137  HG3 GLU A  12      31.839  52.867  -3.081  1.00  0.00           H  
ATOM    138  N   LYS A  13      32.626  57.787  -4.968  1.00  0.00           N  
ATOM    139  CA  LYS A  13      33.590  58.668  -5.616  1.00  0.00           C  
ATOM    140  C   LYS A  13      33.783  59.949  -4.809  1.00  0.00           C  
ATOM    141  O   LYS A  13      34.873  60.214  -4.298  1.00  0.00           O  
ATOM    142  CB  LYS A  13      33.127  59.011  -7.034  1.00  0.00           C  
ATOM    143  CG  LYS A  13      32.465  57.851  -7.754  1.00  0.00           C  
ATOM    144  CD  LYS A  13      32.518  58.028  -9.263  1.00  0.00           C  
ATOM    145  CE  LYS A  13      32.170  59.453  -9.668  1.00  0.00           C  
ATOM    146  NZ  LYS A  13      32.122  59.611 -11.149  1.00  0.00           N  
ATOM    147  H   LYS A  13      31.772  57.602  -5.416  1.00  0.00           H  
ATOM    148  HA  LYS A  13      34.533  58.145  -5.671  1.00  0.00           H  
ATOM    149  HB2 LYS A  13      32.422  59.827  -6.982  1.00  0.00           H  
ATOM    150  HB3 LYS A  13      33.984  59.325  -7.613  1.00  0.00           H  
ATOM    151  HG2 LYS A  13      32.976  56.937  -7.493  1.00  0.00           H  
ATOM    152  HG3 LYS A  13      31.432  57.789  -7.444  1.00  0.00           H  
ATOM    153  HD2 LYS A  13      33.514  57.801  -9.609  1.00  0.00           H  
ATOM    154  HD3 LYS A  13      31.812  57.351  -9.721  1.00  0.00           H  
ATOM    155  HE2 LYS A  13      31.205  59.706  -9.256  1.00  0.00           H  
ATOM    156  HE3 LYS A  13      32.919  60.120  -9.268  1.00  0.00           H  
ATOM    157  HZ1 LYS A  13      32.490  60.546 -11.420  1.00  0.00           H  
ATOM    158  HZ2 LYS A  13      31.141  59.527 -11.486  1.00  0.00           H  
ATOM    159  HZ3 LYS A  13      32.698  58.877 -11.607  1.00  0.00           H  
ATOM    160  N   LEU A  14      32.722  60.738  -4.697  1.00  0.00           N  
ATOM    161  CA  LEU A  14      32.774  61.991  -3.950  1.00  0.00           C  
ATOM    162  C   LEU A  14      33.249  61.752  -2.520  1.00  0.00           C  
ATOM    163  O   LEU A  14      34.208  62.373  -2.063  1.00  0.00           O  
ATOM    164  CB  LEU A  14      31.398  62.658  -3.938  1.00  0.00           C  
ATOM    165  CG  LEU A  14      31.332  64.049  -3.306  1.00  0.00           C  
ATOM    166  CD1 LEU A  14      31.581  65.122  -4.354  1.00  0.00           C  
ATOM    167  CD2 LEU A  14      29.986  64.264  -2.630  1.00  0.00           C  
ATOM    168  H   LEU A  14      31.881  60.474  -5.127  1.00  0.00           H  
ATOM    169  HA  LEU A  14      33.477  62.643  -4.447  1.00  0.00           H  
ATOM    170  HB2 LEU A  14      31.062  62.742  -4.960  1.00  0.00           H  
ATOM    171  HB3 LEU A  14      30.723  62.013  -3.392  1.00  0.00           H  
ATOM    172  HG  LEU A  14      32.104  64.132  -2.554  1.00  0.00           H  
ATOM    173 HD11 LEU A  14      31.396  66.095  -3.924  1.00  0.00           H  
ATOM    174 HD12 LEU A  14      30.919  64.967  -5.194  1.00  0.00           H  
ATOM    175 HD13 LEU A  14      32.607  65.067  -4.690  1.00  0.00           H  
ATOM    176 HD21 LEU A  14      29.467  63.320  -2.553  1.00  0.00           H  
ATOM    177 HD22 LEU A  14      29.396  64.954  -3.215  1.00  0.00           H  
ATOM    178 HD23 LEU A  14      30.142  64.671  -1.641  1.00  0.00           H  
ATOM    179  N   MET A  15      32.574  60.846  -1.821  1.00  0.00           N  
ATOM    180  CA  MET A  15      32.929  60.524  -0.444  1.00  0.00           C  
ATOM    181  C   MET A  15      34.394  60.108  -0.344  1.00  0.00           C  
ATOM    182  O   MET A  15      35.062  60.393   0.649  1.00  0.00           O  
ATOM    183  CB  MET A  15      32.032  59.405   0.088  1.00  0.00           C  
ATOM    184  CG  MET A  15      30.606  59.851   0.366  1.00  0.00           C  
ATOM    185  SD  MET A  15      30.509  61.114   1.649  1.00  0.00           S  
ATOM    186  CE  MET A  15      29.492  62.344   0.836  1.00  0.00           C  
ATOM    187  H   MET A  15      31.818  60.383  -2.240  1.00  0.00           H  
ATOM    188  HA  MET A  15      32.777  61.410   0.153  1.00  0.00           H  
ATOM    189  HB2 MET A  15      32.003  58.607  -0.638  1.00  0.00           H  
ATOM    190  HB3 MET A  15      32.454  59.028   1.009  1.00  0.00           H  
ATOM    191  HG2 MET A  15      30.183  60.249  -0.545  1.00  0.00           H  
ATOM    192  HG3 MET A  15      30.031  58.992   0.680  1.00  0.00           H  
ATOM    193  HE1 MET A  15      29.717  63.321   1.239  1.00  0.00           H  
ATOM    194  HE2 MET A  15      29.697  62.336  -0.225  1.00  0.00           H  
ATOM    195  HE3 MET A  15      28.449  62.117   1.004  1.00  0.00           H  
ATOM    196  N   GLU A  16      34.885  59.434  -1.379  1.00  0.00           N  
ATOM    197  CA  GLU A  16      36.270  58.979  -1.406  1.00  0.00           C  
ATOM    198  C   GLU A  16      37.232  60.164  -1.422  1.00  0.00           C  
ATOM    199  O   GLU A  16      38.300  60.118  -0.814  1.00  0.00           O  
ATOM    200  CB  GLU A  16      36.515  58.091  -2.628  1.00  0.00           C  
ATOM    201  CG  GLU A  16      37.984  57.788  -2.875  1.00  0.00           C  
ATOM    202  CD  GLU A  16      38.497  56.650  -2.014  1.00  0.00           C  
ATOM    203  OE1 GLU A  16      38.752  56.880  -0.814  1.00  0.00           O  
ATOM    204  OE2 GLU A  16      38.643  55.527  -2.542  1.00  0.00           O  
ATOM    205  H   GLU A  16      34.303  59.237  -2.142  1.00  0.00           H  
ATOM    206  HA  GLU A  16      36.446  58.401  -0.512  1.00  0.00           H  
ATOM    207  HB2 GLU A  16      35.994  57.156  -2.489  1.00  0.00           H  
ATOM    208  HB3 GLU A  16      36.121  58.587  -3.502  1.00  0.00           H  
ATOM    209  HG2 GLU A  16      38.114  57.521  -3.912  1.00  0.00           H  
ATOM    210  HG3 GLU A  16      38.563  58.673  -2.657  1.00  0.00           H  
ATOM    211  N   ASN A  17      36.843  61.224  -2.124  1.00  0.00           N  
ATOM    212  CA  ASN A  17      37.671  62.421  -2.222  1.00  0.00           C  
ATOM    213  C   ASN A  17      37.623  63.222  -0.925  1.00  0.00           C  
ATOM    214  O   ASN A  17      38.635  63.763  -0.479  1.00  0.00           O  
ATOM    215  CB  ASN A  17      37.207  63.292  -3.391  1.00  0.00           C  
ATOM    216  CG  ASN A  17      37.540  62.678  -4.737  1.00  0.00           C  
ATOM    217  OD1 ASN A  17      38.668  62.783  -5.219  1.00  0.00           O  
ATOM    218  ND2 ASN A  17      36.555  62.032  -5.352  1.00  0.00           N  
ATOM    219  H   ASN A  17      35.980  61.201  -2.587  1.00  0.00           H  
ATOM    220  HA  ASN A  17      38.688  62.106  -2.399  1.00  0.00           H  
ATOM    221  HB2 ASN A  17      36.137  63.424  -3.331  1.00  0.00           H  
ATOM    222  HB3 ASN A  17      37.689  64.256  -3.326  1.00  0.00           H  
ATOM    223 HD21 ASN A  17      35.683  61.988  -4.907  1.00  0.00           H  
ATOM    224 HD22 ASN A  17      36.743  61.624  -6.222  1.00  0.00           H  
ATOM    225  N   MET A  18      36.439  63.295  -0.324  1.00  0.00           N  
ATOM    226  CA  MET A  18      36.260  64.029   0.924  1.00  0.00           C  
ATOM    227  C   MET A  18      36.924  63.298   2.085  1.00  0.00           C  
ATOM    228  O   MET A  18      37.727  63.878   2.817  1.00  0.00           O  
ATOM    229  CB  MET A  18      34.771  64.226   1.214  1.00  0.00           C  
ATOM    230  CG  MET A  18      34.495  64.873   2.563  1.00  0.00           C  
ATOM    231  SD  MET A  18      32.739  64.911   2.968  1.00  0.00           S  
ATOM    232  CE  MET A  18      32.482  63.226   3.519  1.00  0.00           C  
ATOM    233  H   MET A  18      35.669  62.844  -0.728  1.00  0.00           H  
ATOM    234  HA  MET A  18      36.726  64.997   0.808  1.00  0.00           H  
ATOM    235  HB2 MET A  18      34.346  64.853   0.445  1.00  0.00           H  
ATOM    236  HB3 MET A  18      34.282  63.264   1.195  1.00  0.00           H  
ATOM    237  HG2 MET A  18      35.015  64.315   3.327  1.00  0.00           H  
ATOM    238  HG3 MET A  18      34.869  65.886   2.542  1.00  0.00           H  
ATOM    239  HE1 MET A  18      31.479  62.914   3.268  1.00  0.00           H  
ATOM    240  HE2 MET A  18      33.193  62.576   3.030  1.00  0.00           H  
ATOM    241  HE3 MET A  18      32.619  63.172   4.588  1.00  0.00           H  
ATOM    242  N   ARG A  19      36.585  62.024   2.248  1.00  0.00           N  
ATOM    243  CA  ARG A  19      37.149  61.215   3.323  1.00  0.00           C  
ATOM    244  C   ARG A  19      38.655  61.433   3.435  1.00  0.00           C  
ATOM    245  O   ARG A  19      39.227  61.333   4.520  1.00  0.00           O  
ATOM    246  CB  ARG A  19      36.854  59.733   3.082  1.00  0.00           C  
ATOM    247  CG  ARG A  19      35.418  59.339   3.390  1.00  0.00           C  
ATOM    248  CD  ARG A  19      35.162  57.874   3.071  1.00  0.00           C  
ATOM    249  NE  ARG A  19      34.967  57.651   1.642  1.00  0.00           N  
ATOM    250  CZ  ARG A  19      34.476  56.526   1.134  1.00  0.00           C  
ATOM    251  NH1 ARG A  19      34.131  55.529   1.937  1.00  0.00           N  
ATOM    252  NH2 ARG A  19      34.327  56.397  -0.178  1.00  0.00           N  
ATOM    253  H   ARG A  19      35.940  61.617   1.632  1.00  0.00           H  
ATOM    254  HA  ARG A  19      36.682  61.520   4.248  1.00  0.00           H  
ATOM    255  HB2 ARG A  19      37.054  59.501   2.045  1.00  0.00           H  
ATOM    256  HB3 ARG A  19      37.508  59.143   3.706  1.00  0.00           H  
ATOM    257  HG2 ARG A  19      35.226  59.507   4.439  1.00  0.00           H  
ATOM    258  HG3 ARG A  19      34.754  59.949   2.797  1.00  0.00           H  
ATOM    259  HD2 ARG A  19      36.010  57.294   3.405  1.00  0.00           H  
ATOM    260  HD3 ARG A  19      34.277  57.555   3.601  1.00  0.00           H  
ATOM    261  HE  ARG A  19      35.216  58.375   1.031  1.00  0.00           H  
ATOM    262 HH11 ARG A  19      34.240  55.622   2.926  1.00  0.00           H  
ATOM    263 HH12 ARG A  19      33.759  54.683   1.552  1.00  0.00           H  
ATOM    264 HH21 ARG A  19      34.586  57.147  -0.785  1.00  0.00           H  
ATOM    265 HH22 ARG A  19      33.957  55.551  -0.558  1.00  0.00           H  
ATOM    266  N   ASN A  20      39.290  61.732   2.308  1.00  0.00           N  
ATOM    267  CA  ASN A  20      40.730  61.963   2.279  1.00  0.00           C  
ATOM    268  C   ASN A  20      41.092  63.231   3.046  1.00  0.00           C  
ATOM    269  O   ASN A  20      41.667  63.169   4.133  1.00  0.00           O  
ATOM    270  CB  ASN A  20      41.223  62.070   0.835  1.00  0.00           C  
ATOM    271  CG  ASN A  20      41.452  60.712   0.201  1.00  0.00           C  
ATOM    272  OD1 ASN A  20      41.728  59.731   0.891  1.00  0.00           O  
ATOM    273  ND2 ASN A  20      41.339  60.650  -1.121  1.00  0.00           N  
ATOM    274  H   ASN A  20      38.780  61.798   1.474  1.00  0.00           H  
ATOM    275  HA  ASN A  20      41.211  61.120   2.753  1.00  0.00           H  
ATOM    276  HB2 ASN A  20      40.486  62.600   0.247  1.00  0.00           H  
ATOM    277  HB3 ASN A  20      42.153  62.618   0.817  1.00  0.00           H  
ATOM    278 HD21 ASN A  20      41.116  61.472  -1.607  1.00  0.00           H  
ATOM    279 HD22 ASN A  20      41.481  59.784  -1.558  1.00  0.00           H  
ATOM    280  N   ASP A  21      40.750  64.380   2.474  1.00  0.00           N  
ATOM    281  CA  ASP A  21      41.037  65.664   3.104  1.00  0.00           C  
ATOM    282  C   ASP A  21      40.358  65.764   4.468  1.00  0.00           C  
ATOM    283  O   ASP A  21      40.768  66.553   5.319  1.00  0.00           O  
ATOM    284  CB  ASP A  21      40.575  66.813   2.206  1.00  0.00           C  
ATOM    285  CG  ASP A  21      41.444  68.047   2.352  1.00  0.00           C  
ATOM    286  OD1 ASP A  21      42.512  68.101   1.707  1.00  0.00           O  
ATOM    287  OD2 ASP A  21      41.055  68.959   3.110  1.00  0.00           O  
ATOM    288  H   ASP A  21      40.293  64.365   1.608  1.00  0.00           H  
ATOM    289  HA  ASP A  21      42.106  65.734   3.243  1.00  0.00           H  
ATOM    290  HB2 ASP A  21      40.609  66.491   1.176  1.00  0.00           H  
ATOM    291  HB3 ASP A  21      39.560  67.076   2.463  1.00  0.00           H  
ATOM    292  N   ILE A  22      39.320  64.959   4.666  1.00  0.00           N  
ATOM    293  CA  ILE A  22      38.585  64.958   5.926  1.00  0.00           C  
ATOM    294  C   ILE A  22      39.291  64.101   6.972  1.00  0.00           C  
ATOM    295  O   ILE A  22      39.289  64.427   8.158  1.00  0.00           O  
ATOM    296  CB  ILE A  22      37.148  64.438   5.737  1.00  0.00           C  
ATOM    297  CG1 ILE A  22      36.210  65.589   5.368  1.00  0.00           C  
ATOM    298  CG2 ILE A  22      36.667  63.740   7.001  1.00  0.00           C  
ATOM    299  CD1 ILE A  22      36.008  66.586   6.488  1.00  0.00           C  
ATOM    300  H   ILE A  22      39.042  64.353   3.949  1.00  0.00           H  
ATOM    301  HA  ILE A  22      38.535  65.976   6.282  1.00  0.00           H  
ATOM    302  HB  ILE A  22      37.152  63.715   4.936  1.00  0.00           H  
ATOM    303 HG12 ILE A  22      36.617  66.120   4.522  1.00  0.00           H  
ATOM    304 HG13 ILE A  22      35.244  65.185   5.104  1.00  0.00           H  
ATOM    305 HG21 ILE A  22      36.747  64.419   7.839  1.00  0.00           H  
ATOM    306 HG22 ILE A  22      35.637  63.443   6.878  1.00  0.00           H  
ATOM    307 HG23 ILE A  22      37.276  62.868   7.186  1.00  0.00           H  
ATOM    308 HD11 ILE A  22      35.092  66.357   7.012  1.00  0.00           H  
ATOM    309 HD12 ILE A  22      36.839  66.533   7.173  1.00  0.00           H  
ATOM    310 HD13 ILE A  22      35.945  67.583   6.074  1.00  0.00           H  
ATOM    311  N   ALA A  23      39.895  63.006   6.523  1.00  0.00           N  
ATOM    312  CA  ALA A  23      40.608  62.106   7.420  1.00  0.00           C  
ATOM    313  C   ALA A  23      42.018  62.614   7.703  1.00  0.00           C  
ATOM    314  O   ALA A  23      42.634  62.241   8.701  1.00  0.00           O  
ATOM    315  CB  ALA A  23      40.661  60.704   6.829  1.00  0.00           C  
ATOM    316  H   ALA A  23      39.862  62.800   5.566  1.00  0.00           H  
ATOM    317  HA  ALA A  23      40.060  62.057   8.350  1.00  0.00           H  
ATOM    318  HB1 ALA A  23      41.142  60.740   5.863  1.00  0.00           H  
ATOM    319  HB2 ALA A  23      41.220  60.057   7.487  1.00  0.00           H  
ATOM    320  HB3 ALA A  23      39.656  60.324   6.717  1.00  0.00           H  
ATOM    321  N   SER A  24      42.522  63.469   6.819  1.00  0.00           N  
ATOM    322  CA  SER A  24      43.861  64.026   6.971  1.00  0.00           C  
ATOM    323  C   SER A  24      43.806  65.396   7.642  1.00  0.00           C  
ATOM    324  O   SER A  24      44.712  65.773   8.386  1.00  0.00           O  
ATOM    325  CB  SER A  24      44.547  64.140   5.610  1.00  0.00           C  
ATOM    326  OG  SER A  24      45.957  64.078   5.742  1.00  0.00           O  
ATOM    327  H   SER A  24      41.981  63.729   6.043  1.00  0.00           H  
ATOM    328  HA  SER A  24      44.430  63.355   7.597  1.00  0.00           H  
ATOM    329  HB2 SER A  24      44.222  63.328   4.977  1.00  0.00           H  
ATOM    330  HB3 SER A  24      44.281  65.082   5.153  1.00  0.00           H  
ATOM    331  HG  SER A  24      46.186  63.463   6.443  1.00  0.00           H  
ATOM    332  N   HIS A  25      42.737  66.138   7.372  1.00  0.00           N  
ATOM    333  CA  HIS A  25      42.562  67.466   7.949  1.00  0.00           C  
ATOM    334  C   HIS A  25      41.170  67.616   8.557  1.00  0.00           C  
ATOM    335  O   HIS A  25      40.422  68.539   8.235  1.00  0.00           O  
ATOM    336  CB  HIS A  25      42.784  68.541   6.884  1.00  0.00           C  
ATOM    337  CG  HIS A  25      44.218  68.950   6.736  1.00  0.00           C  
ATOM    338  ND1 HIS A  25      44.735  70.095   7.301  1.00  0.00           N  
ATOM    339  CD2 HIS A  25      45.244  68.356   6.082  1.00  0.00           C  
ATOM    340  CE1 HIS A  25      46.019  70.190   7.001  1.00  0.00           C  
ATOM    341  NE2 HIS A  25      46.352  69.148   6.263  1.00  0.00           N  
ATOM    342  H   HIS A  25      42.048  65.783   6.771  1.00  0.00           H  
ATOM    343  HA  HIS A  25      43.297  67.588   8.729  1.00  0.00           H  
ATOM    344  HB2 HIS A  25      42.446  68.167   5.928  1.00  0.00           H  
ATOM    345  HB3 HIS A  25      42.213  69.420   7.144  1.00  0.00           H  
ATOM    346  HD1 HIS A  25      44.237  70.743   7.841  1.00  0.00           H  
ATOM    347  HD2 HIS A  25      45.201  67.433   5.522  1.00  0.00           H  
ATOM    348  HE1 HIS A  25      46.682  70.984   7.307  1.00  0.00           H  
ATOM    349  N   PRO A  26      40.814  66.687   9.456  1.00  0.00           N  
ATOM    350  CA  PRO A  26      39.511  66.695  10.127  1.00  0.00           C  
ATOM    351  C   PRO A  26      39.153  68.068  10.686  1.00  0.00           C  
ATOM    352  O   PRO A  26      40.019  68.841  11.097  1.00  0.00           O  
ATOM    353  CB  PRO A  26      39.692  65.686  11.265  1.00  0.00           C  
ATOM    354  CG  PRO A  26      40.760  64.763  10.786  1.00  0.00           C  
ATOM    355  CD  PRO A  26      41.656  65.559   9.888  1.00  0.00           C  
ATOM    356  HA  PRO A  26      38.723  66.359   9.469  1.00  0.00           H  
ATOM    357  HB2 PRO A  26      39.991  66.204  12.165  1.00  0.00           H  
ATOM    358  HB3 PRO A  26      38.765  65.161  11.436  1.00  0.00           H  
ATOM    359  HG2 PRO A  26      41.323  64.387  11.626  1.00  0.00           H  
ATOM    360  HG3 PRO A  26      40.317  63.947  10.232  1.00  0.00           H  
ATOM    361  HD2 PRO A  26      42.517  65.908  10.437  1.00  0.00           H  
ATOM    362  HD3 PRO A  26      41.962  64.961   9.042  1.00  0.00           H  
ATOM    363  N   PRO A  27      37.850  68.380  10.701  1.00  0.00           N  
ATOM    364  CA  PRO A  27      37.349  69.661  11.208  1.00  0.00           C  
ATOM    365  C   PRO A  27      37.496  69.785  12.720  1.00  0.00           C  
ATOM    366  O   PRO A  27      37.741  68.797  13.412  1.00  0.00           O  
ATOM    367  CB  PRO A  27      35.870  69.644  10.815  1.00  0.00           C  
ATOM    368  CG  PRO A  27      35.520  68.199  10.714  1.00  0.00           C  
ATOM    369  CD  PRO A  27      36.764  67.507  10.226  1.00  0.00           C  
ATOM    370  HA  PRO A  27      37.840  70.497  10.730  1.00  0.00           H  
ATOM    371  HB2 PRO A  27      35.285  70.140  11.578  1.00  0.00           H  
ATOM    372  HB3 PRO A  27      35.738  70.149   9.869  1.00  0.00           H  
ATOM    373  HG2 PRO A  27      35.238  67.822  11.684  1.00  0.00           H  
ATOM    374  HG3 PRO A  27      34.715  68.065  10.007  1.00  0.00           H  
ATOM    375  HD2 PRO A  27      36.842  66.522  10.662  1.00  0.00           H  
ATOM    376  HD3 PRO A  27      36.763  67.446   9.148  1.00  0.00           H  
ATOM    377  N   VAL A  28      37.345  71.004  13.227  1.00  0.00           N  
ATOM    378  CA  VAL A  28      37.461  71.256  14.659  1.00  0.00           C  
ATOM    379  C   VAL A  28      36.152  70.946  15.378  1.00  0.00           C  
ATOM    380  O   VAL A  28      35.123  71.564  15.109  1.00  0.00           O  
ATOM    381  CB  VAL A  28      37.855  72.718  14.942  1.00  0.00           C  
ATOM    382  CG1 VAL A  28      37.855  72.991  16.438  1.00  0.00           C  
ATOM    383  CG2 VAL A  28      39.214  73.029  14.335  1.00  0.00           C  
ATOM    384  H   VAL A  28      37.151  71.752  12.625  1.00  0.00           H  
ATOM    385  HA  VAL A  28      38.235  70.614  15.051  1.00  0.00           H  
ATOM    386  HB  VAL A  28      37.122  73.363  14.481  1.00  0.00           H  
ATOM    387 HG11 VAL A  28      37.244  73.857  16.645  1.00  0.00           H  
ATOM    388 HG12 VAL A  28      37.456  72.134  16.961  1.00  0.00           H  
ATOM    389 HG13 VAL A  28      38.866  73.177  16.769  1.00  0.00           H  
ATOM    390 HG21 VAL A  28      39.432  72.313  13.557  1.00  0.00           H  
ATOM    391 HG22 VAL A  28      39.201  74.025  13.914  1.00  0.00           H  
ATOM    392 HG23 VAL A  28      39.973  72.972  15.101  1.00  0.00           H  
ATOM    393  N   GLU A  29      36.202  69.984  16.295  1.00  0.00           N  
ATOM    394  CA  GLU A  29      35.020  69.592  17.054  1.00  0.00           C  
ATOM    395  C   GLU A  29      34.496  70.758  17.888  1.00  0.00           C  
ATOM    396  O   GLU A  29      35.143  71.197  18.836  1.00  0.00           O  
ATOM    397  CB  GLU A  29      35.341  68.405  17.964  1.00  0.00           C  
ATOM    398  CG  GLU A  29      36.122  68.788  19.211  1.00  0.00           C  
ATOM    399  CD  GLU A  29      36.917  67.628  19.779  1.00  0.00           C  
ATOM    400  OE1 GLU A  29      37.790  67.100  19.060  1.00  0.00           O  
ATOM    401  OE2 GLU A  29      36.665  67.249  20.941  1.00  0.00           O  
ATOM    402  H   GLU A  29      37.051  69.528  16.465  1.00  0.00           H  
ATOM    403  HA  GLU A  29      34.256  69.297  16.350  1.00  0.00           H  
ATOM    404  HB2 GLU A  29      34.415  67.941  18.272  1.00  0.00           H  
ATOM    405  HB3 GLU A  29      35.923  67.686  17.406  1.00  0.00           H  
ATOM    406  HG2 GLU A  29      36.806  69.584  18.960  1.00  0.00           H  
ATOM    407  HG3 GLU A  29      35.428  69.132  19.963  1.00  0.00           H  
ATOM    408  N   GLY A  30      33.317  71.256  17.523  1.00  0.00           N  
ATOM    409  CA  GLY A  30      32.726  72.367  18.246  1.00  0.00           C  
ATOM    410  C   GLY A  30      33.062  73.708  17.623  1.00  0.00           C  
ATOM    411  O   GLY A  30      33.101  74.727  18.312  1.00  0.00           O  
ATOM    412  H   GLY A  30      32.846  70.865  16.757  1.00  0.00           H  
ATOM    413  HA2 GLY A  30      31.653  72.245  18.256  1.00  0.00           H  
ATOM    414  HA3 GLY A  30      33.090  72.354  19.263  1.00  0.00           H  
ATOM    415  N   SER A  31      33.307  73.708  16.317  1.00  0.00           N  
ATOM    416  CA  SER A  31      33.646  74.933  15.602  1.00  0.00           C  
ATOM    417  C   SER A  31      32.489  75.385  14.718  1.00  0.00           C  
ATOM    418  O   SER A  31      32.109  76.556  14.724  1.00  0.00           O  
ATOM    419  CB  SER A  31      34.901  74.721  14.752  1.00  0.00           C  
ATOM    420  OG  SER A  31      35.223  75.890  14.020  1.00  0.00           O  
ATOM    421  H   SER A  31      33.260  72.862  15.822  1.00  0.00           H  
ATOM    422  HA  SER A  31      33.845  75.700  16.336  1.00  0.00           H  
ATOM    423  HB2 SER A  31      35.731  74.473  15.395  1.00  0.00           H  
ATOM    424  HB3 SER A  31      34.728  73.911  14.057  1.00  0.00           H  
ATOM    425  HG  SER A  31      34.685  75.931  13.227  1.00  0.00           H  
ATOM    426  N   TYR A  32      31.932  74.448  13.959  1.00  0.00           N  
ATOM    427  CA  TYR A  32      30.819  74.749  13.066  1.00  0.00           C  
ATOM    428  C   TYR A  32      29.491  74.702  13.817  1.00  0.00           C  
ATOM    429  O   TYR A  32      29.186  73.725  14.500  1.00  0.00           O  
ATOM    430  CB  TYR A  32      30.793  73.763  11.898  1.00  0.00           C  
ATOM    431  CG  TYR A  32      29.459  73.700  11.189  1.00  0.00           C  
ATOM    432  CD1 TYR A  32      28.395  72.989  11.729  1.00  0.00           C  
ATOM    433  CD2 TYR A  32      29.264  74.353   9.977  1.00  0.00           C  
ATOM    434  CE1 TYR A  32      27.176  72.928  11.083  1.00  0.00           C  
ATOM    435  CE2 TYR A  32      28.047  74.299   9.325  1.00  0.00           C  
ATOM    436  CZ  TYR A  32      27.006  73.585   9.882  1.00  0.00           C  
ATOM    437  OH  TYR A  32      25.793  73.528   9.236  1.00  0.00           O  
ATOM    438  H   TYR A  32      32.278  73.533  13.997  1.00  0.00           H  
ATOM    439  HA  TYR A  32      30.965  75.748  12.679  1.00  0.00           H  
ATOM    440  HB2 TYR A  32      31.539  74.053  11.175  1.00  0.00           H  
ATOM    441  HB3 TYR A  32      31.020  72.773  12.266  1.00  0.00           H  
ATOM    442  HD1 TYR A  32      28.531  72.477  12.670  1.00  0.00           H  
ATOM    443  HD2 TYR A  32      30.081  74.911   9.543  1.00  0.00           H  
ATOM    444  HE1 TYR A  32      26.360  72.370  11.519  1.00  0.00           H  
ATOM    445  HE2 TYR A  32      27.914  74.813   8.385  1.00  0.00           H  
ATOM    446  HH  TYR A  32      25.084  73.578   9.883  1.00  0.00           H  
ATOM    447  N   ALA A  33      28.705  75.765  13.683  1.00  0.00           N  
ATOM    448  CA  ALA A  33      27.409  75.845  14.345  1.00  0.00           C  
ATOM    449  C   ALA A  33      26.286  75.415  13.407  1.00  0.00           C  
ATOM    450  O   ALA A  33      25.975  76.086  12.423  1.00  0.00           O  
ATOM    451  CB  ALA A  33      27.162  77.257  14.854  1.00  0.00           C  
ATOM    452  H   ALA A  33      29.004  76.513  13.125  1.00  0.00           H  
ATOM    453  HA  ALA A  33      27.428  75.179  15.196  1.00  0.00           H  
ATOM    454  HB1 ALA A  33      27.696  77.403  15.782  1.00  0.00           H  
ATOM    455  HB2 ALA A  33      27.511  77.970  14.122  1.00  0.00           H  
ATOM    456  HB3 ALA A  33      26.105  77.399  15.020  1.00  0.00           H  
ATOM    457  N   PRO A  34      25.661  74.269  13.716  1.00  0.00           N  
ATOM    458  CA  PRO A  34      24.564  73.723  12.911  1.00  0.00           C  
ATOM    459  C   PRO A  34      23.294  74.559  13.023  1.00  0.00           C  
ATOM    460  O   PRO A  34      22.812  74.831  14.124  1.00  0.00           O  
ATOM    461  CB  PRO A  34      24.343  72.332  13.511  1.00  0.00           C  
ATOM    462  CG  PRO A  34      24.837  72.439  14.912  1.00  0.00           C  
ATOM    463  CD  PRO A  34      25.980  73.416  14.874  1.00  0.00           C  
ATOM    464  HA  PRO A  34      24.842  73.631  11.872  1.00  0.00           H  
ATOM    465  HB2 PRO A  34      23.290  72.088  13.480  1.00  0.00           H  
ATOM    466  HB3 PRO A  34      24.904  71.601  12.948  1.00  0.00           H  
ATOM    467  HG2 PRO A  34      24.050  72.808  15.552  1.00  0.00           H  
ATOM    468  HG3 PRO A  34      25.181  71.475  15.254  1.00  0.00           H  
ATOM    469  HD2 PRO A  34      26.010  73.998  15.783  1.00  0.00           H  
ATOM    470  HD3 PRO A  34      26.915  72.897  14.724  1.00  0.00           H  
ATOM    471  N   ARG A  35      22.754  74.964  11.878  1.00  0.00           N  
ATOM    472  CA  ARG A  35      21.540  75.770  11.848  1.00  0.00           C  
ATOM    473  C   ARG A  35      20.420  75.039  11.114  1.00  0.00           C  
ATOM    474  O   ARG A  35      20.658  74.365  10.111  1.00  0.00           O  
ATOM    475  CB  ARG A  35      21.811  77.116  11.174  1.00  0.00           C  
ATOM    476  CG  ARG A  35      22.918  77.918  11.840  1.00  0.00           C  
ATOM    477  CD  ARG A  35      22.476  78.462  13.189  1.00  0.00           C  
ATOM    478  NE  ARG A  35      23.613  78.817  14.035  1.00  0.00           N  
ATOM    479  CZ  ARG A  35      23.495  79.215  15.296  1.00  0.00           C  
ATOM    480  NH1 ARG A  35      22.296  79.307  15.856  1.00  0.00           N  
ATOM    481  NH2 ARG A  35      24.577  79.520  16.001  1.00  0.00           N  
ATOM    482  H   ARG A  35      23.184  74.715  11.033  1.00  0.00           H  
ATOM    483  HA  ARG A  35      21.231  75.944  12.868  1.00  0.00           H  
ATOM    484  HB2 ARG A  35      22.093  76.940  10.146  1.00  0.00           H  
ATOM    485  HB3 ARG A  35      20.907  77.704  11.195  1.00  0.00           H  
ATOM    486  HG2 ARG A  35      23.776  77.277  11.986  1.00  0.00           H  
ATOM    487  HG3 ARG A  35      23.187  78.743  11.198  1.00  0.00           H  
ATOM    488  HD2 ARG A  35      21.873  79.343  13.027  1.00  0.00           H  
ATOM    489  HD3 ARG A  35      21.887  77.710  13.691  1.00  0.00           H  
ATOM    490  HE  ARG A  35      24.509  78.756  13.641  1.00  0.00           H  
ATOM    491 HH11 ARG A  35      21.479  79.077  15.328  1.00  0.00           H  
ATOM    492 HH12 ARG A  35      22.210  79.607  16.807  1.00  0.00           H  
ATOM    493 HH21 ARG A  35      25.482  79.451  15.584  1.00  0.00           H  
ATOM    494 HH22 ARG A  35      24.486  79.819  16.951  1.00  0.00           H  
ATOM    495  N   ARG A  36      19.199  75.175  11.620  1.00  0.00           N  
ATOM    496  CA  ARG A  36      18.043  74.526  11.014  1.00  0.00           C  
ATOM    497  C   ARG A  36      17.942  74.870   9.531  1.00  0.00           C  
ATOM    498  O   ARG A  36      17.566  75.982   9.165  1.00  0.00           O  
ATOM    499  CB  ARG A  36      16.760  74.945  11.733  1.00  0.00           C  
ATOM    500  CG  ARG A  36      15.509  74.271  11.192  1.00  0.00           C  
ATOM    501  CD  ARG A  36      14.448  74.120  12.269  1.00  0.00           C  
ATOM    502  NE  ARG A  36      13.122  73.884  11.703  1.00  0.00           N  
ATOM    503  CZ  ARG A  36      12.013  73.813  12.431  1.00  0.00           C  
ATOM    504  NH1 ARG A  36      12.070  73.959  13.748  1.00  0.00           N  
ATOM    505  NH2 ARG A  36      10.844  73.596  11.842  1.00  0.00           N  
ATOM    506  H   ARG A  36      19.072  75.725  12.422  1.00  0.00           H  
ATOM    507  HA  ARG A  36      18.170  73.458  11.116  1.00  0.00           H  
ATOM    508  HB2 ARG A  36      16.850  74.697  12.780  1.00  0.00           H  
ATOM    509  HB3 ARG A  36      16.638  76.013  11.634  1.00  0.00           H  
ATOM    510  HG2 ARG A  36      15.108  74.870  10.388  1.00  0.00           H  
ATOM    511  HG3 ARG A  36      15.773  73.293  10.819  1.00  0.00           H  
ATOM    512  HD2 ARG A  36      14.711  73.286  12.902  1.00  0.00           H  
ATOM    513  HD3 ARG A  36      14.420  75.024  12.860  1.00  0.00           H  
ATOM    514  HE  ARG A  36      13.057  73.773  10.732  1.00  0.00           H  
ATOM    515 HH11 ARG A  36      12.949  74.124  14.193  1.00  0.00           H  
ATOM    516 HH12 ARG A  36      11.234  73.906  14.293  1.00  0.00           H  
ATOM    517 HH21 ARG A  36      10.798  73.485  10.850  1.00  0.00           H  
ATOM    518 HH22 ARG A  36      10.010  73.542  12.391  1.00  0.00           H  
ATOM    519  N   GLY A  37      18.282  73.906   8.680  1.00  0.00           N  
ATOM    520  CA  GLY A  37      18.224  74.127   7.247  1.00  0.00           C  
ATOM    521  C   GLY A  37      19.586  74.427   6.651  1.00  0.00           C  
ATOM    522  O   GLY A  37      19.690  75.146   5.658  1.00  0.00           O  
ATOM    523  H   GLY A  37      18.575  73.038   9.028  1.00  0.00           H  
ATOM    524  HA2 GLY A  37      17.822  73.243   6.774  1.00  0.00           H  
ATOM    525  HA3 GLY A  37      17.567  74.961   7.049  1.00  0.00           H  
ATOM    526  N   GLU A  38      20.631  73.874   7.259  1.00  0.00           N  
ATOM    527  CA  GLU A  38      21.993  74.088   6.782  1.00  0.00           C  
ATOM    528  C   GLU A  38      22.700  72.758   6.540  1.00  0.00           C  
ATOM    529  O   GLU A  38      22.585  71.827   7.337  1.00  0.00           O  
ATOM    530  CB  GLU A  38      22.783  74.923   7.791  1.00  0.00           C  
ATOM    531  CG  GLU A  38      22.676  76.420   7.560  1.00  0.00           C  
ATOM    532  CD  GLU A  38      23.389  76.871   6.301  1.00  0.00           C  
ATOM    533  OE1 GLU A  38      24.632  76.982   6.330  1.00  0.00           O  
ATOM    534  OE2 GLU A  38      22.704  77.110   5.284  1.00  0.00           O  
ATOM    535  H   GLU A  38      20.483  73.309   8.046  1.00  0.00           H  
ATOM    536  HA  GLU A  38      21.935  74.628   5.849  1.00  0.00           H  
ATOM    537  HB2 GLU A  38      22.420  74.705   8.785  1.00  0.00           H  
ATOM    538  HB3 GLU A  38      23.825  74.645   7.731  1.00  0.00           H  
ATOM    539  HG2 GLU A  38      21.632  76.684   7.478  1.00  0.00           H  
ATOM    540  HG3 GLU A  38      23.109  76.935   8.406  1.00  0.00           H  
ATOM    541  N   PHE A  39      23.431  72.677   5.433  1.00  0.00           N  
ATOM    542  CA  PHE A  39      24.156  71.461   5.083  1.00  0.00           C  
ATOM    543  C   PHE A  39      25.520  71.427   5.766  1.00  0.00           C  
ATOM    544  O   PHE A  39      26.163  72.461   5.946  1.00  0.00           O  
ATOM    545  CB  PHE A  39      24.331  71.366   3.566  1.00  0.00           C  
ATOM    546  CG  PHE A  39      23.074  70.975   2.842  1.00  0.00           C  
ATOM    547  CD1 PHE A  39      22.630  69.663   2.855  1.00  0.00           C  
ATOM    548  CD2 PHE A  39      22.338  71.920   2.147  1.00  0.00           C  
ATOM    549  CE1 PHE A  39      21.475  69.301   2.188  1.00  0.00           C  
ATOM    550  CE2 PHE A  39      21.180  71.565   1.479  1.00  0.00           C  
ATOM    551  CZ  PHE A  39      20.749  70.253   1.501  1.00  0.00           C  
ATOM    552  H   PHE A  39      23.483  73.453   4.836  1.00  0.00           H  
ATOM    553  HA  PHE A  39      23.573  70.619   5.424  1.00  0.00           H  
ATOM    554  HB2 PHE A  39      24.648  72.325   3.185  1.00  0.00           H  
ATOM    555  HB3 PHE A  39      25.086  70.627   3.344  1.00  0.00           H  
ATOM    556  HD1 PHE A  39      23.196  68.917   3.394  1.00  0.00           H  
ATOM    557  HD2 PHE A  39      22.675  72.947   2.130  1.00  0.00           H  
ATOM    558  HE1 PHE A  39      21.139  68.275   2.207  1.00  0.00           H  
ATOM    559  HE2 PHE A  39      20.615  72.312   0.942  1.00  0.00           H  
ATOM    560  HZ  PHE A  39      19.846  69.973   0.979  1.00  0.00           H  
ATOM    561  N   CYS A  40      25.954  70.229   6.145  1.00  0.00           N  
ATOM    562  CA  CYS A  40      27.240  70.058   6.810  1.00  0.00           C  
ATOM    563  C   CYS A  40      27.627  68.584   6.874  1.00  0.00           C  
ATOM    564  O   CYS A  40      26.846  67.710   6.498  1.00  0.00           O  
ATOM    565  CB  CYS A  40      27.191  70.646   8.222  1.00  0.00           C  
ATOM    566  SG  CYS A  40      25.806  70.050   9.221  1.00  0.00           S  
ATOM    567  H   CYS A  40      25.396  69.442   5.974  1.00  0.00           H  
ATOM    568  HA  CYS A  40      27.984  70.588   6.235  1.00  0.00           H  
ATOM    569  HB2 CYS A  40      28.103  70.393   8.741  1.00  0.00           H  
ATOM    570  HB3 CYS A  40      27.110  71.721   8.152  1.00  0.00           H  
ATOM    571  HG  CYS A  40      25.388  68.908   8.699  1.00  0.00           H  
ATOM    572  N   ILE A  41      28.838  68.316   7.352  1.00  0.00           N  
ATOM    573  CA  ILE A  41      29.329  66.948   7.464  1.00  0.00           C  
ATOM    574  C   ILE A  41      29.181  66.425   8.889  1.00  0.00           C  
ATOM    575  O   ILE A  41      29.548  67.100   9.850  1.00  0.00           O  
ATOM    576  CB  ILE A  41      30.806  66.843   7.042  1.00  0.00           C  
ATOM    577  CG1 ILE A  41      31.673  67.757   7.911  1.00  0.00           C  
ATOM    578  CG2 ILE A  41      30.963  67.198   5.571  1.00  0.00           C  
ATOM    579  CD1 ILE A  41      33.152  67.647   7.614  1.00  0.00           C  
ATOM    580  H   ILE A  41      29.414  69.055   7.636  1.00  0.00           H  
ATOM    581  HA  ILE A  41      28.742  66.328   6.802  1.00  0.00           H  
ATOM    582  HB  ILE A  41      31.125  65.821   7.177  1.00  0.00           H  
ATOM    583 HG12 ILE A  41      31.378  68.782   7.751  1.00  0.00           H  
ATOM    584 HG13 ILE A  41      31.522  67.501   8.950  1.00  0.00           H  
ATOM    585 HG21 ILE A  41      31.408  68.178   5.482  1.00  0.00           H  
ATOM    586 HG22 ILE A  41      31.601  66.470   5.092  1.00  0.00           H  
ATOM    587 HG23 ILE A  41      29.995  67.197   5.095  1.00  0.00           H  
ATOM    588 HD11 ILE A  41      33.630  68.597   7.806  1.00  0.00           H  
ATOM    589 HD12 ILE A  41      33.592  66.889   8.244  1.00  0.00           H  
ATOM    590 HD13 ILE A  41      33.292  67.379   6.576  1.00  0.00           H  
ATOM    591  N   ALA A  42      28.640  65.218   9.017  1.00  0.00           N  
ATOM    592  CA  ALA A  42      28.447  64.603  10.324  1.00  0.00           C  
ATOM    593  C   ALA A  42      29.328  63.369  10.486  1.00  0.00           C  
ATOM    594  O   ALA A  42      29.538  62.613   9.536  1.00  0.00           O  
ATOM    595  CB  ALA A  42      26.984  64.239  10.526  1.00  0.00           C  
ATOM    596  H   ALA A  42      28.367  64.728   8.214  1.00  0.00           H  
ATOM    597  HA  ALA A  42      28.719  65.328  11.078  1.00  0.00           H  
ATOM    598  HB1 ALA A  42      26.775  64.161  11.582  1.00  0.00           H  
ATOM    599  HB2 ALA A  42      26.360  65.005  10.090  1.00  0.00           H  
ATOM    600  HB3 ALA A  42      26.779  63.293  10.047  1.00  0.00           H  
ATOM    601  N   LYS A  43      29.842  63.168  11.695  1.00  0.00           N  
ATOM    602  CA  LYS A  43      30.701  62.025  11.982  1.00  0.00           C  
ATOM    603  C   LYS A  43      29.875  60.825  12.433  1.00  0.00           C  
ATOM    604  O   LYS A  43      29.093  60.917  13.379  1.00  0.00           O  
ATOM    605  CB  LYS A  43      31.724  62.388  13.060  1.00  0.00           C  
ATOM    606  CG  LYS A  43      33.023  61.608  12.954  1.00  0.00           C  
ATOM    607  CD  LYS A  43      34.109  62.211  13.828  1.00  0.00           C  
ATOM    608  CE  LYS A  43      35.492  61.977  13.239  1.00  0.00           C  
ATOM    609  NZ  LYS A  43      36.551  62.001  14.286  1.00  0.00           N  
ATOM    610  H   LYS A  43      29.639  63.806  12.412  1.00  0.00           H  
ATOM    611  HA  LYS A  43      31.224  61.767  11.074  1.00  0.00           H  
ATOM    612  HB2 LYS A  43      31.954  63.441  12.983  1.00  0.00           H  
ATOM    613  HB3 LYS A  43      31.291  62.194  14.031  1.00  0.00           H  
ATOM    614  HG2 LYS A  43      32.847  60.590  13.267  1.00  0.00           H  
ATOM    615  HG3 LYS A  43      33.354  61.617  11.925  1.00  0.00           H  
ATOM    616  HD2 LYS A  43      33.941  63.274  13.913  1.00  0.00           H  
ATOM    617  HD3 LYS A  43      34.063  61.758  14.808  1.00  0.00           H  
ATOM    618  HE2 LYS A  43      35.503  61.015  12.751  1.00  0.00           H  
ATOM    619  HE3 LYS A  43      35.695  62.751  12.515  1.00  0.00           H  
ATOM    620  HZ1 LYS A  43      36.761  62.983  14.558  1.00  0.00           H  
ATOM    621  HZ2 LYS A  43      37.421  61.560  13.924  1.00  0.00           H  
ATOM    622  HZ3 LYS A  43      36.235  61.480  15.128  1.00  0.00           H  
ATOM    623  N   PHE A  44      30.055  59.699  11.752  1.00  0.00           N  
ATOM    624  CA  PHE A  44      29.327  58.480  12.083  1.00  0.00           C  
ATOM    625  C   PHE A  44      30.045  57.698  13.180  1.00  0.00           C  
ATOM    626  O   PHE A  44      31.253  57.840  13.370  1.00  0.00           O  
ATOM    627  CB  PHE A  44      29.165  57.603  10.840  1.00  0.00           C  
ATOM    628  CG  PHE A  44      28.106  56.548  10.983  1.00  0.00           C  
ATOM    629  CD1 PHE A  44      26.797  56.897  11.273  1.00  0.00           C  
ATOM    630  CD2 PHE A  44      28.419  55.207  10.829  1.00  0.00           C  
ATOM    631  CE1 PHE A  44      25.820  55.928  11.406  1.00  0.00           C  
ATOM    632  CE2 PHE A  44      27.447  54.234  10.961  1.00  0.00           C  
ATOM    633  CZ  PHE A  44      26.146  54.595  11.249  1.00  0.00           C  
ATOM    634  H   PHE A  44      30.693  59.687  11.007  1.00  0.00           H  
ATOM    635  HA  PHE A  44      28.350  58.764  12.441  1.00  0.00           H  
ATOM    636  HB2 PHE A  44      28.899  58.227  10.000  1.00  0.00           H  
ATOM    637  HB3 PHE A  44      30.102  57.108  10.633  1.00  0.00           H  
ATOM    638  HD1 PHE A  44      26.540  57.939  11.395  1.00  0.00           H  
ATOM    639  HD2 PHE A  44      29.437  54.923  10.603  1.00  0.00           H  
ATOM    640  HE1 PHE A  44      24.803  56.213  11.632  1.00  0.00           H  
ATOM    641  HE2 PHE A  44      27.705  53.192  10.837  1.00  0.00           H  
ATOM    642  HZ  PHE A  44      25.384  53.836  11.354  1.00  0.00           H  
ATOM    643  N   VAL A  45      29.291  56.873  13.900  1.00  0.00           N  
ATOM    644  CA  VAL A  45      29.855  56.069  14.978  1.00  0.00           C  
ATOM    645  C   VAL A  45      31.168  55.422  14.553  1.00  0.00           C  
ATOM    646  O   VAL A  45      32.011  55.097  15.389  1.00  0.00           O  
ATOM    647  CB  VAL A  45      28.875  54.969  15.428  1.00  0.00           C  
ATOM    648  CG1 VAL A  45      27.548  55.578  15.856  1.00  0.00           C  
ATOM    649  CG2 VAL A  45      28.670  53.952  14.316  1.00  0.00           C  
ATOM    650  H   VAL A  45      28.335  56.804  13.702  1.00  0.00           H  
ATOM    651  HA  VAL A  45      30.042  56.721  15.819  1.00  0.00           H  
ATOM    652  HB  VAL A  45      29.303  54.459  16.278  1.00  0.00           H  
ATOM    653 HG11 VAL A  45      26.927  54.811  16.295  1.00  0.00           H  
ATOM    654 HG12 VAL A  45      27.727  56.358  16.581  1.00  0.00           H  
ATOM    655 HG13 VAL A  45      27.049  55.994  14.994  1.00  0.00           H  
ATOM    656 HG21 VAL A  45      28.314  53.024  14.738  1.00  0.00           H  
ATOM    657 HG22 VAL A  45      27.941  54.328  13.612  1.00  0.00           H  
ATOM    658 HG23 VAL A  45      29.607  53.780  13.806  1.00  0.00           H  
ATOM    659  N   ASP A  46      31.335  55.238  13.248  1.00  0.00           N  
ATOM    660  CA  ASP A  46      32.546  54.631  12.709  1.00  0.00           C  
ATOM    661  C   ASP A  46      33.559  55.700  12.310  1.00  0.00           C  
ATOM    662  O   ASP A  46      34.370  55.494  11.409  1.00  0.00           O  
ATOM    663  CB  ASP A  46      32.211  53.752  11.503  1.00  0.00           C  
ATOM    664  CG  ASP A  46      31.685  52.390  11.909  1.00  0.00           C  
ATOM    665  OD1 ASP A  46      32.447  51.621  12.532  1.00  0.00           O  
ATOM    666  OD2 ASP A  46      30.511  52.090  11.602  1.00  0.00           O  
ATOM    667  H   ASP A  46      30.626  55.518  12.631  1.00  0.00           H  
ATOM    668  HA  ASP A  46      32.980  54.014  13.483  1.00  0.00           H  
ATOM    669  HB2 ASP A  46      31.456  54.245  10.907  1.00  0.00           H  
ATOM    670  HB3 ASP A  46      33.101  53.613  10.909  1.00  0.00           H  
ATOM    671  N   GLY A  47      33.503  56.844  12.986  1.00  0.00           N  
ATOM    672  CA  GLY A  47      34.418  57.928  12.686  1.00  0.00           C  
ATOM    673  C   GLY A  47      34.450  58.269  11.209  1.00  0.00           C  
ATOM    674  O   GLY A  47      35.477  58.700  10.688  1.00  0.00           O  
ATOM    675  H   GLY A  47      32.834  56.951  13.695  1.00  0.00           H  
ATOM    676  HA2 GLY A  47      34.117  58.804  13.241  1.00  0.00           H  
ATOM    677  HA3 GLY A  47      35.412  57.642  12.998  1.00  0.00           H  
ATOM    678  N   GLU A  48      33.321  58.072  10.535  1.00  0.00           N  
ATOM    679  CA  GLU A  48      33.225  58.360   9.108  1.00  0.00           C  
ATOM    680  C   GLU A  48      32.340  59.578   8.857  1.00  0.00           C  
ATOM    681  O   GLU A  48      31.180  59.610   9.268  1.00  0.00           O  
ATOM    682  CB  GLU A  48      32.670  57.148   8.357  1.00  0.00           C  
ATOM    683  CG  GLU A  48      33.663  56.006   8.227  1.00  0.00           C  
ATOM    684  CD  GLU A  48      34.526  56.121   6.985  1.00  0.00           C  
ATOM    685  OE1 GLU A  48      34.002  56.550   5.936  1.00  0.00           O  
ATOM    686  OE2 GLU A  48      35.726  55.782   7.063  1.00  0.00           O  
ATOM    687  H   GLU A  48      32.535  57.726  11.006  1.00  0.00           H  
ATOM    688  HA  GLU A  48      34.220  58.572   8.745  1.00  0.00           H  
ATOM    689  HB2 GLU A  48      31.799  56.784   8.880  1.00  0.00           H  
ATOM    690  HB3 GLU A  48      32.379  57.459   7.364  1.00  0.00           H  
ATOM    691  HG2 GLU A  48      34.306  56.004   9.094  1.00  0.00           H  
ATOM    692  HG3 GLU A  48      33.118  55.074   8.183  1.00  0.00           H  
ATOM    693  N   TRP A  49      32.896  60.576   8.180  1.00  0.00           N  
ATOM    694  CA  TRP A  49      32.157  61.796   7.874  1.00  0.00           C  
ATOM    695  C   TRP A  49      31.200  61.575   6.708  1.00  0.00           C  
ATOM    696  O   TRP A  49      31.531  60.886   5.744  1.00  0.00           O  
ATOM    697  CB  TRP A  49      33.126  62.934   7.546  1.00  0.00           C  
ATOM    698  CG  TRP A  49      33.897  63.419   8.737  1.00  0.00           C  
ATOM    699  CD1 TRP A  49      35.126  62.989   9.149  1.00  0.00           C  
ATOM    700  CD2 TRP A  49      33.489  64.426   9.670  1.00  0.00           C  
ATOM    701  NE1 TRP A  49      35.507  63.667  10.280  1.00  0.00           N  
ATOM    702  CE2 TRP A  49      34.521  64.555  10.621  1.00  0.00           C  
ATOM    703  CE3 TRP A  49      32.354  65.231   9.794  1.00  0.00           C  
ATOM    704  CZ2 TRP A  49      34.447  65.457  11.680  1.00  0.00           C  
ATOM    705  CZ3 TRP A  49      32.284  66.126  10.845  1.00  0.00           C  
ATOM    706  CH2 TRP A  49      33.325  66.233  11.777  1.00  0.00           C  
ATOM    707  H   TRP A  49      33.825  60.491   7.879  1.00  0.00           H  
ATOM    708  HA  TRP A  49      31.585  62.064   8.750  1.00  0.00           H  
ATOM    709  HB2 TRP A  49      33.834  62.593   6.807  1.00  0.00           H  
ATOM    710  HB3 TRP A  49      32.567  63.769   7.147  1.00  0.00           H  
ATOM    711  HD1 TRP A  49      35.702  62.225   8.647  1.00  0.00           H  
ATOM    712  HE1 TRP A  49      36.350  63.538  10.765  1.00  0.00           H  
ATOM    713  HE3 TRP A  49      31.541  65.163   9.086  1.00  0.00           H  
ATOM    714  HZ2 TRP A  49      35.243  65.550  12.405  1.00  0.00           H  
ATOM    715  HZ3 TRP A  49      31.413  66.756  10.957  1.00  0.00           H  
ATOM    716  HH2 TRP A  49      33.227  66.944  12.582  1.00  0.00           H  
ATOM    717  N   TYR A  50      30.013  62.164   6.804  1.00  0.00           N  
ATOM    718  CA  TYR A  50      29.007  62.030   5.757  1.00  0.00           C  
ATOM    719  C   TYR A  50      28.190  63.311   5.618  1.00  0.00           C  
ATOM    720  O   TYR A  50      28.043  64.072   6.575  1.00  0.00           O  
ATOM    721  CB  TYR A  50      28.081  60.851   6.061  1.00  0.00           C  
ATOM    722  CG  TYR A  50      28.791  59.517   6.102  1.00  0.00           C  
ATOM    723  CD1 TYR A  50      29.281  58.931   4.941  1.00  0.00           C  
ATOM    724  CD2 TYR A  50      28.976  58.844   7.303  1.00  0.00           C  
ATOM    725  CE1 TYR A  50      29.930  57.713   4.975  1.00  0.00           C  
ATOM    726  CE2 TYR A  50      29.625  57.625   7.347  1.00  0.00           C  
ATOM    727  CZ  TYR A  50      30.101  57.063   6.181  1.00  0.00           C  
ATOM    728  OH  TYR A  50      30.748  55.850   6.219  1.00  0.00           O  
ATOM    729  H   TYR A  50      29.809  62.701   7.597  1.00  0.00           H  
ATOM    730  HA  TYR A  50      29.521  61.841   4.825  1.00  0.00           H  
ATOM    731  HB2 TYR A  50      27.613  61.007   7.020  1.00  0.00           H  
ATOM    732  HB3 TYR A  50      27.318  60.797   5.298  1.00  0.00           H  
ATOM    733  HD1 TYR A  50      29.147  59.442   3.999  1.00  0.00           H  
ATOM    734  HD2 TYR A  50      28.602  59.286   8.216  1.00  0.00           H  
ATOM    735  HE1 TYR A  50      30.303  57.273   4.062  1.00  0.00           H  
ATOM    736  HE2 TYR A  50      29.758  57.116   8.291  1.00  0.00           H  
ATOM    737  HH  TYR A  50      30.147  55.177   6.547  1.00  0.00           H  
ATOM    738  N   ARG A  51      27.661  63.540   4.422  1.00  0.00           N  
ATOM    739  CA  ARG A  51      26.859  64.729   4.156  1.00  0.00           C  
ATOM    740  C   ARG A  51      25.491  64.621   4.823  1.00  0.00           C  
ATOM    741  O   ARG A  51      24.823  63.591   4.732  1.00  0.00           O  
ATOM    742  CB  ARG A  51      26.688  64.929   2.650  1.00  0.00           C  
ATOM    743  CG  ARG A  51      27.836  65.688   2.003  1.00  0.00           C  
ATOM    744  CD  ARG A  51      27.379  66.438   0.761  1.00  0.00           C  
ATOM    745  NE  ARG A  51      27.506  65.627  -0.446  1.00  0.00           N  
ATOM    746  CZ  ARG A  51      26.575  64.775  -0.862  1.00  0.00           C  
ATOM    747  NH1 ARG A  51      25.454  64.624  -0.170  1.00  0.00           N  
ATOM    748  NH2 ARG A  51      26.765  64.072  -1.971  1.00  0.00           N  
ATOM    749  H   ARG A  51      27.814  62.896   3.699  1.00  0.00           H  
ATOM    750  HA  ARG A  51      27.380  65.580   4.568  1.00  0.00           H  
ATOM    751  HB2 ARG A  51      26.614  63.962   2.175  1.00  0.00           H  
ATOM    752  HB3 ARG A  51      25.777  65.479   2.473  1.00  0.00           H  
ATOM    753  HG2 ARG A  51      28.231  66.399   2.713  1.00  0.00           H  
ATOM    754  HG3 ARG A  51      28.608  64.987   1.726  1.00  0.00           H  
ATOM    755  HD2 ARG A  51      26.343  66.718   0.887  1.00  0.00           H  
ATOM    756  HD3 ARG A  51      27.980  67.328   0.652  1.00  0.00           H  
ATOM    757  HE  ARG A  51      28.327  65.722  -0.972  1.00  0.00           H  
ATOM    758 HH11 ARG A  51      25.308  65.154   0.665  1.00  0.00           H  
ATOM    759 HH12 ARG A  51      24.754  63.983  -0.485  1.00  0.00           H  
ATOM    760 HH21 ARG A  51      27.609  64.183  -2.494  1.00  0.00           H  
ATOM    761 HH22 ARG A  51      26.065  63.431  -2.282  1.00  0.00           H  
ATOM    762  N   ALA A  52      25.080  65.692   5.496  1.00  0.00           N  
ATOM    763  CA  ALA A  52      23.791  65.719   6.176  1.00  0.00           C  
ATOM    764  C   ALA A  52      23.247  67.140   6.265  1.00  0.00           C  
ATOM    765  O   ALA A  52      24.006  68.109   6.251  1.00  0.00           O  
ATOM    766  CB  ALA A  52      23.917  65.113   7.567  1.00  0.00           C  
ATOM    767  H   ALA A  52      25.657  66.484   5.533  1.00  0.00           H  
ATOM    768  HA  ALA A  52      23.101  65.114   5.607  1.00  0.00           H  
ATOM    769  HB1 ALA A  52      23.637  64.069   7.530  1.00  0.00           H  
ATOM    770  HB2 ALA A  52      24.938  65.200   7.907  1.00  0.00           H  
ATOM    771  HB3 ALA A  52      23.263  65.637   8.248  1.00  0.00           H  
ATOM    772  N   ARG A  53      21.925  67.258   6.353  1.00  0.00           N  
ATOM    773  CA  ARG A  53      21.279  68.562   6.441  1.00  0.00           C  
ATOM    774  C   ARG A  53      20.591  68.738   7.791  1.00  0.00           C  
ATOM    775  O   ARG A  53      19.711  67.958   8.159  1.00  0.00           O  
ATOM    776  CB  ARG A  53      20.260  68.727   5.312  1.00  0.00           C  
ATOM    777  CG  ARG A  53      19.516  70.052   5.352  1.00  0.00           C  
ATOM    778  CD  ARG A  53      18.580  70.200   4.163  1.00  0.00           C  
ATOM    779  NE  ARG A  53      18.370  71.600   3.802  1.00  0.00           N  
ATOM    780  CZ  ARG A  53      17.491  72.000   2.891  1.00  0.00           C  
ATOM    781  NH1 ARG A  53      16.744  71.112   2.250  1.00  0.00           N  
ATOM    782  NH2 ARG A  53      17.359  73.292   2.618  1.00  0.00           N  
ATOM    783  H   ARG A  53      21.373  66.450   6.359  1.00  0.00           H  
ATOM    784  HA  ARG A  53      22.043  69.319   6.338  1.00  0.00           H  
ATOM    785  HB2 ARG A  53      20.774  68.657   4.365  1.00  0.00           H  
ATOM    786  HB3 ARG A  53      19.535  67.930   5.379  1.00  0.00           H  
ATOM    787  HG2 ARG A  53      18.937  70.101   6.262  1.00  0.00           H  
ATOM    788  HG3 ARG A  53      20.235  70.857   5.336  1.00  0.00           H  
ATOM    789  HD2 ARG A  53      19.006  69.681   3.319  1.00  0.00           H  
ATOM    790  HD3 ARG A  53      17.627  69.756   4.415  1.00  0.00           H  
ATOM    791  HE  ARG A  53      18.912  72.273   4.264  1.00  0.00           H  
ATOM    792 HH11 ARG A  53      16.840  70.138   2.455  1.00  0.00           H  
ATOM    793 HH12 ARG A  53      16.082  71.416   1.565  1.00  0.00           H  
ATOM    794 HH21 ARG A  53      17.921  73.965   3.098  1.00  0.00           H  
ATOM    795 HH22 ARG A  53      16.698  73.593   1.931  1.00  0.00           H  
ATOM    796  N   VAL A  54      20.998  69.767   8.528  1.00  0.00           N  
ATOM    797  CA  VAL A  54      20.420  70.045   9.838  1.00  0.00           C  
ATOM    798  C   VAL A  54      18.901  70.131   9.762  1.00  0.00           C  
ATOM    799  O   VAL A  54      18.351  71.011   9.102  1.00  0.00           O  
ATOM    800  CB  VAL A  54      20.968  71.361  10.424  1.00  0.00           C  
ATOM    801  CG1 VAL A  54      20.418  71.591  11.823  1.00  0.00           C  
ATOM    802  CG2 VAL A  54      22.489  71.344  10.437  1.00  0.00           C  
ATOM    803  H   VAL A  54      21.702  70.353   8.182  1.00  0.00           H  
ATOM    804  HA  VAL A  54      20.694  69.238  10.502  1.00  0.00           H  
ATOM    805  HB  VAL A  54      20.643  72.175   9.795  1.00  0.00           H  
ATOM    806 HG11 VAL A  54      21.233  71.794  12.502  1.00  0.00           H  
ATOM    807 HG12 VAL A  54      19.741  72.434  11.810  1.00  0.00           H  
ATOM    808 HG13 VAL A  54      19.888  70.709  12.152  1.00  0.00           H  
ATOM    809 HG21 VAL A  54      22.861  71.822   9.542  1.00  0.00           H  
ATOM    810 HG22 VAL A  54      22.848  71.879  11.305  1.00  0.00           H  
ATOM    811 HG23 VAL A  54      22.839  70.324  10.473  1.00  0.00           H  
ATOM    812  N   GLU A  55      18.227  69.208  10.442  1.00  0.00           N  
ATOM    813  CA  GLU A  55      16.769  69.179  10.451  1.00  0.00           C  
ATOM    814  C   GLU A  55      16.215  69.988  11.620  1.00  0.00           C  
ATOM    815  O   GLU A  55      15.277  70.770  11.461  1.00  0.00           O  
ATOM    816  CB  GLU A  55      16.266  67.736  10.531  1.00  0.00           C  
ATOM    817  CG  GLU A  55      16.725  66.867   9.372  1.00  0.00           C  
ATOM    818  CD  GLU A  55      16.062  65.503   9.369  1.00  0.00           C  
ATOM    819  OE1 GLU A  55      16.127  64.808  10.404  1.00  0.00           O  
ATOM    820  OE2 GLU A  55      15.476  65.130   8.330  1.00  0.00           O  
ATOM    821  H   GLU A  55      18.722  68.531  10.949  1.00  0.00           H  
ATOM    822  HA  GLU A  55      16.423  69.621   9.528  1.00  0.00           H  
ATOM    823  HB2 GLU A  55      16.622  67.294  11.449  1.00  0.00           H  
ATOM    824  HB3 GLU A  55      15.186  67.745  10.542  1.00  0.00           H  
ATOM    825  HG2 GLU A  55      16.486  67.367   8.446  1.00  0.00           H  
ATOM    826  HG3 GLU A  55      17.793  66.731   9.442  1.00  0.00           H  
ATOM    827  N   LYS A  56      16.803  69.795  12.796  1.00  0.00           N  
ATOM    828  CA  LYS A  56      16.371  70.506  13.994  1.00  0.00           C  
ATOM    829  C   LYS A  56      17.514  70.625  14.997  1.00  0.00           C  
ATOM    830  O   LYS A  56      18.078  69.621  15.433  1.00  0.00           O  
ATOM    831  CB  LYS A  56      15.185  69.785  14.639  1.00  0.00           C  
ATOM    832  CG  LYS A  56      15.124  69.946  16.148  1.00  0.00           C  
ATOM    833  CD  LYS A  56      13.786  69.486  16.704  1.00  0.00           C  
ATOM    834  CE  LYS A  56      13.528  70.067  18.086  1.00  0.00           C  
ATOM    835  NZ  LYS A  56      13.343  71.544  18.043  1.00  0.00           N  
ATOM    836  H   LYS A  56      17.547  69.159  12.860  1.00  0.00           H  
ATOM    837  HA  LYS A  56      16.062  71.496  13.698  1.00  0.00           H  
ATOM    838  HB2 LYS A  56      14.270  70.177  14.219  1.00  0.00           H  
ATOM    839  HB3 LYS A  56      15.252  68.731  14.412  1.00  0.00           H  
ATOM    840  HG2 LYS A  56      15.909  69.354  16.596  1.00  0.00           H  
ATOM    841  HG3 LYS A  56      15.269  70.987  16.397  1.00  0.00           H  
ATOM    842  HD2 LYS A  56      12.999  69.809  16.038  1.00  0.00           H  
ATOM    843  HD3 LYS A  56      13.784  68.408  16.770  1.00  0.00           H  
ATOM    844  HE2 LYS A  56      12.638  69.613  18.493  1.00  0.00           H  
ATOM    845  HE3 LYS A  56      14.372  69.837  18.721  1.00  0.00           H  
ATOM    846  HZ1 LYS A  56      14.148  71.990  17.557  1.00  0.00           H  
ATOM    847  HZ2 LYS A  56      13.281  71.925  19.008  1.00  0.00           H  
ATOM    848  HZ3 LYS A  56      12.470  71.780  17.531  1.00  0.00           H  
ATOM    849  N   VAL A  57      17.850  71.858  15.361  1.00  0.00           N  
ATOM    850  CA  VAL A  57      18.923  72.109  16.315  1.00  0.00           C  
ATOM    851  C   VAL A  57      18.372  72.302  17.724  1.00  0.00           C  
ATOM    852  O   VAL A  57      17.742  73.316  18.019  1.00  0.00           O  
ATOM    853  CB  VAL A  57      19.745  73.350  15.922  1.00  0.00           C  
ATOM    854  CG1 VAL A  57      20.855  73.599  16.932  1.00  0.00           C  
ATOM    855  CG2 VAL A  57      20.315  73.190  14.521  1.00  0.00           C  
ATOM    856  H   VAL A  57      17.363  72.619  14.978  1.00  0.00           H  
ATOM    857  HA  VAL A  57      19.580  71.251  16.310  1.00  0.00           H  
ATOM    858  HB  VAL A  57      19.088  74.207  15.924  1.00  0.00           H  
ATOM    859 HG11 VAL A  57      20.640  74.499  17.488  1.00  0.00           H  
ATOM    860 HG12 VAL A  57      20.917  72.760  17.611  1.00  0.00           H  
ATOM    861 HG13 VAL A  57      21.795  73.712  16.413  1.00  0.00           H  
ATOM    862 HG21 VAL A  57      20.196  74.115  13.976  1.00  0.00           H  
ATOM    863 HG22 VAL A  57      21.364  72.942  14.584  1.00  0.00           H  
ATOM    864 HG23 VAL A  57      19.789  72.399  14.006  1.00  0.00           H  
ATOM    865  N   GLU A  58      18.615  71.322  18.588  1.00  0.00           N  
ATOM    866  CA  GLU A  58      18.143  71.386  19.966  1.00  0.00           C  
ATOM    867  C   GLU A  58      19.161  72.089  20.858  1.00  0.00           C  
ATOM    868  O   GLU A  58      18.886  73.154  21.413  1.00  0.00           O  
ATOM    869  CB  GLU A  58      17.867  69.977  20.499  1.00  0.00           C  
ATOM    870  CG  GLU A  58      16.476  69.464  20.170  1.00  0.00           C  
ATOM    871  CD  GLU A  58      15.381  70.283  20.825  1.00  0.00           C  
ATOM    872  OE1 GLU A  58      15.108  71.401  20.343  1.00  0.00           O  
ATOM    873  OE2 GLU A  58      14.798  69.805  21.821  1.00  0.00           O  
ATOM    874  H   GLU A  58      19.123  70.538  18.292  1.00  0.00           H  
ATOM    875  HA  GLU A  58      17.222  71.950  19.976  1.00  0.00           H  
ATOM    876  HB2 GLU A  58      18.590  69.297  20.075  1.00  0.00           H  
ATOM    877  HB3 GLU A  58      17.980  69.985  21.573  1.00  0.00           H  
ATOM    878  HG2 GLU A  58      16.337  69.498  19.100  1.00  0.00           H  
ATOM    879  HG3 GLU A  58      16.394  68.442  20.510  1.00  0.00           H  
ATOM    880  N   SER A  59      20.338  71.486  20.993  1.00  0.00           N  
ATOM    881  CA  SER A  59      21.396  72.051  21.821  1.00  0.00           C  
ATOM    882  C   SER A  59      22.772  71.660  21.288  1.00  0.00           C  
ATOM    883  O   SER A  59      22.920  70.711  20.518  1.00  0.00           O  
ATOM    884  CB  SER A  59      21.246  71.581  23.269  1.00  0.00           C  
ATOM    885  OG  SER A  59      19.887  71.334  23.587  1.00  0.00           O  
ATOM    886  H   SER A  59      20.497  70.639  20.525  1.00  0.00           H  
ATOM    887  HA  SER A  59      21.304  73.127  21.790  1.00  0.00           H  
ATOM    888  HB2 SER A  59      21.806  70.669  23.409  1.00  0.00           H  
ATOM    889  HB3 SER A  59      21.627  72.343  23.934  1.00  0.00           H  
ATOM    890  HG  SER A  59      19.487  70.805  22.894  1.00  0.00           H  
ATOM    891  N   PRO A  60      23.802  72.409  21.706  1.00  0.00           N  
ATOM    892  CA  PRO A  60      25.184  72.161  21.283  1.00  0.00           C  
ATOM    893  C   PRO A  60      25.574  70.692  21.410  1.00  0.00           C  
ATOM    894  O   PRO A  60      26.560  70.249  20.822  1.00  0.00           O  
ATOM    895  CB  PRO A  60      26.009  73.018  22.247  1.00  0.00           C  
ATOM    896  CG  PRO A  60      25.089  74.114  22.662  1.00  0.00           C  
ATOM    897  CD  PRO A  60      23.699  73.557  22.623  1.00  0.00           C  
ATOM    898  HA  PRO A  60      25.355  72.491  20.269  1.00  0.00           H  
ATOM    899  HB2 PRO A  60      26.317  72.419  23.091  1.00  0.00           H  
ATOM    900  HB3 PRO A  60      26.877  73.405  21.736  1.00  0.00           H  
ATOM    901  HG2 PRO A  60      25.327  74.433  23.665  1.00  0.00           H  
ATOM    902  HG3 PRO A  60      25.171  74.942  21.973  1.00  0.00           H  
ATOM    903  HD2 PRO A  60      23.398  73.236  23.609  1.00  0.00           H  
ATOM    904  HD3 PRO A  60      23.012  74.295  22.239  1.00  0.00           H  
ATOM    905  N   ALA A  61      24.793  69.942  22.181  1.00  0.00           N  
ATOM    906  CA  ALA A  61      25.055  68.523  22.383  1.00  0.00           C  
ATOM    907  C   ALA A  61      24.068  67.665  21.598  1.00  0.00           C  
ATOM    908  O   ALA A  61      24.325  66.491  21.330  1.00  0.00           O  
ATOM    909  CB  ALA A  61      24.996  68.180  23.863  1.00  0.00           C  
ATOM    910  H   ALA A  61      24.021  70.354  22.623  1.00  0.00           H  
ATOM    911  HA  ALA A  61      26.055  68.315  22.030  1.00  0.00           H  
ATOM    912  HB1 ALA A  61      24.021  67.779  24.100  1.00  0.00           H  
ATOM    913  HB2 ALA A  61      25.753  67.446  24.094  1.00  0.00           H  
ATOM    914  HB3 ALA A  61      25.169  69.072  24.446  1.00  0.00           H  
ATOM    915  N   LYS A  62      22.936  68.258  21.235  1.00  0.00           N  
ATOM    916  CA  LYS A  62      21.908  67.549  20.481  1.00  0.00           C  
ATOM    917  C   LYS A  62      21.529  68.320  19.220  1.00  0.00           C  
ATOM    918  O   LYS A  62      20.988  69.423  19.296  1.00  0.00           O  
ATOM    919  CB  LYS A  62      20.668  67.331  21.351  1.00  0.00           C  
ATOM    920  CG  LYS A  62      20.920  66.445  22.558  1.00  0.00           C  
ATOM    921  CD  LYS A  62      19.660  65.710  22.983  1.00  0.00           C  
ATOM    922  CE  LYS A  62      19.987  64.393  23.669  1.00  0.00           C  
ATOM    923  NZ  LYS A  62      20.221  64.571  25.129  1.00  0.00           N  
ATOM    924  H   LYS A  62      22.788  69.196  21.478  1.00  0.00           H  
ATOM    925  HA  LYS A  62      22.309  66.589  20.194  1.00  0.00           H  
ATOM    926  HB2 LYS A  62      20.315  68.290  21.701  1.00  0.00           H  
ATOM    927  HB3 LYS A  62      19.897  66.873  20.748  1.00  0.00           H  
ATOM    928  HG2 LYS A  62      21.680  65.720  22.309  1.00  0.00           H  
ATOM    929  HG3 LYS A  62      21.261  67.059  23.380  1.00  0.00           H  
ATOM    930  HD2 LYS A  62      19.105  66.332  23.669  1.00  0.00           H  
ATOM    931  HD3 LYS A  62      19.057  65.510  22.108  1.00  0.00           H  
ATOM    932  HE2 LYS A  62      19.162  63.712  23.526  1.00  0.00           H  
ATOM    933  HE3 LYS A  62      20.877  63.979  23.218  1.00  0.00           H  
ATOM    934  HZ1 LYS A  62      20.872  63.838  25.478  1.00  0.00           H  
ATOM    935  HZ2 LYS A  62      19.322  64.495  25.647  1.00  0.00           H  
ATOM    936  HZ3 LYS A  62      20.637  65.506  25.313  1.00  0.00           H  
ATOM    937  N   ILE A  63      21.815  67.731  18.064  1.00  0.00           N  
ATOM    938  CA  ILE A  63      21.501  68.362  16.788  1.00  0.00           C  
ATOM    939  C   ILE A  63      20.861  67.367  15.825  1.00  0.00           C  
ATOM    940  O   ILE A  63      21.527  66.464  15.317  1.00  0.00           O  
ATOM    941  CB  ILE A  63      22.760  68.958  16.131  1.00  0.00           C  
ATOM    942  CG1 ILE A  63      23.663  69.595  17.189  1.00  0.00           C  
ATOM    943  CG2 ILE A  63      22.371  69.981  15.073  1.00  0.00           C  
ATOM    944  CD1 ILE A  63      23.188  70.956  17.648  1.00  0.00           C  
ATOM    945  H   ILE A  63      22.247  66.852  18.070  1.00  0.00           H  
ATOM    946  HA  ILE A  63      20.803  69.164  16.977  1.00  0.00           H  
ATOM    947  HB  ILE A  63      23.298  68.159  15.643  1.00  0.00           H  
ATOM    948 HG12 ILE A  63      23.704  68.950  18.053  1.00  0.00           H  
ATOM    949 HG13 ILE A  63      24.656  69.710  16.783  1.00  0.00           H  
ATOM    950 HG21 ILE A  63      21.760  70.749  15.524  1.00  0.00           H  
ATOM    951 HG22 ILE A  63      23.263  70.428  14.661  1.00  0.00           H  
ATOM    952 HG23 ILE A  63      21.815  69.493  14.288  1.00  0.00           H  
ATOM    953 HD11 ILE A  63      23.053  71.598  16.791  1.00  0.00           H  
ATOM    954 HD12 ILE A  63      22.251  70.852  18.174  1.00  0.00           H  
ATOM    955 HD13 ILE A  63      23.925  71.389  18.309  1.00  0.00           H  
ATOM    956  N   HIS A  64      19.567  67.539  15.579  1.00  0.00           N  
ATOM    957  CA  HIS A  64      18.836  66.658  14.675  1.00  0.00           C  
ATOM    958  C   HIS A  64      19.261  66.893  13.228  1.00  0.00           C  
ATOM    959  O   HIS A  64      19.105  67.991  12.694  1.00  0.00           O  
ATOM    960  CB  HIS A  64      17.331  66.879  14.819  1.00  0.00           C  
ATOM    961  CG  HIS A  64      16.830  66.696  16.219  1.00  0.00           C  
ATOM    962  ND1 HIS A  64      15.868  65.770  16.559  1.00  0.00           N  
ATOM    963  CD2 HIS A  64      17.166  67.327  17.369  1.00  0.00           C  
ATOM    964  CE1 HIS A  64      15.632  65.839  17.858  1.00  0.00           C  
ATOM    965  NE2 HIS A  64      16.407  66.777  18.372  1.00  0.00           N  
ATOM    966  H   HIS A  64      19.092  68.277  16.015  1.00  0.00           H  
ATOM    967  HA  HIS A  64      19.070  65.639  14.945  1.00  0.00           H  
ATOM    968  HB2 HIS A  64      17.090  67.886  14.510  1.00  0.00           H  
ATOM    969  HB3 HIS A  64      16.808  66.178  14.185  1.00  0.00           H  
ATOM    970  HD1 HIS A  64      15.422  65.154  15.941  1.00  0.00           H  
ATOM    971  HD2 HIS A  64      17.895  68.118  17.478  1.00  0.00           H  
ATOM    972  HE1 HIS A  64      14.926  65.234  18.405  1.00  0.00           H  
ATOM    973  N   VAL A  65      19.797  65.852  12.597  1.00  0.00           N  
ATOM    974  CA  VAL A  65      20.243  65.944  11.213  1.00  0.00           C  
ATOM    975  C   VAL A  65      19.783  64.735  10.406  1.00  0.00           C  
ATOM    976  O   VAL A  65      19.276  63.760  10.962  1.00  0.00           O  
ATOM    977  CB  VAL A  65      21.776  66.053  11.123  1.00  0.00           C  
ATOM    978  CG1 VAL A  65      22.233  67.462  11.474  1.00  0.00           C  
ATOM    979  CG2 VAL A  65      22.438  65.028  12.032  1.00  0.00           C  
ATOM    980  H   VAL A  65      19.894  65.002  13.076  1.00  0.00           H  
ATOM    981  HA  VAL A  65      19.813  66.837  10.782  1.00  0.00           H  
ATOM    982  HB  VAL A  65      22.074  65.847  10.106  1.00  0.00           H  
ATOM    983 HG11 VAL A  65      21.430  67.987  11.971  1.00  0.00           H  
ATOM    984 HG12 VAL A  65      23.090  67.410  12.129  1.00  0.00           H  
ATOM    985 HG13 VAL A  65      22.501  67.989  10.570  1.00  0.00           H  
ATOM    986 HG21 VAL A  65      22.073  65.154  13.040  1.00  0.00           H  
ATOM    987 HG22 VAL A  65      22.200  64.034  11.684  1.00  0.00           H  
ATOM    988 HG23 VAL A  65      23.508  65.169  12.015  1.00  0.00           H  
ATOM    989  N   PHE A  66      19.964  64.804   9.091  1.00  0.00           N  
ATOM    990  CA  PHE A  66      19.568  63.716   8.207  1.00  0.00           C  
ATOM    991  C   PHE A  66      20.615  63.487   7.121  1.00  0.00           C  
ATOM    992  O   PHE A  66      20.917  64.386   6.336  1.00  0.00           O  
ATOM    993  CB  PHE A  66      18.211  64.019   7.566  1.00  0.00           C  
ATOM    994  CG  PHE A  66      17.917  63.175   6.358  1.00  0.00           C  
ATOM    995  CD1 PHE A  66      17.267  61.958   6.488  1.00  0.00           C  
ATOM    996  CD2 PHE A  66      18.289  63.600   5.093  1.00  0.00           C  
ATOM    997  CE1 PHE A  66      16.995  61.181   5.378  1.00  0.00           C  
ATOM    998  CE2 PHE A  66      18.020  62.826   3.980  1.00  0.00           C  
ATOM    999  CZ  PHE A  66      17.371  61.616   4.122  1.00  0.00           C  
ATOM   1000  H   PHE A  66      20.374  65.608   8.707  1.00  0.00           H  
ATOM   1001  HA  PHE A  66      19.482  62.820   8.802  1.00  0.00           H  
ATOM   1002  HB2 PHE A  66      17.431  63.842   8.291  1.00  0.00           H  
ATOM   1003  HB3 PHE A  66      18.188  65.055   7.263  1.00  0.00           H  
ATOM   1004  HD1 PHE A  66      16.971  61.618   7.469  1.00  0.00           H  
ATOM   1005  HD2 PHE A  66      18.797  64.548   4.980  1.00  0.00           H  
ATOM   1006  HE1 PHE A  66      16.487  60.235   5.493  1.00  0.00           H  
ATOM   1007  HE2 PHE A  66      18.315  63.170   2.999  1.00  0.00           H  
ATOM   1008  HZ  PHE A  66      17.160  61.010   3.254  1.00  0.00           H  
ATOM   1009  N   TYR A  67      21.166  62.279   7.084  1.00  0.00           N  
ATOM   1010  CA  TYR A  67      22.183  61.933   6.097  1.00  0.00           C  
ATOM   1011  C   TYR A  67      21.594  61.922   4.689  1.00  0.00           C  
ATOM   1012  O   TYR A  67      20.777  61.064   4.352  1.00  0.00           O  
ATOM   1013  CB  TYR A  67      22.790  60.566   6.419  1.00  0.00           C  
ATOM   1014  CG  TYR A  67      23.601  60.548   7.694  1.00  0.00           C  
ATOM   1015  CD1 TYR A  67      22.980  60.570   8.937  1.00  0.00           C  
ATOM   1016  CD2 TYR A  67      24.989  60.509   7.657  1.00  0.00           C  
ATOM   1017  CE1 TYR A  67      23.717  60.555  10.105  1.00  0.00           C  
ATOM   1018  CE2 TYR A  67      25.735  60.493   8.820  1.00  0.00           C  
ATOM   1019  CZ  TYR A  67      25.095  60.517  10.041  1.00  0.00           C  
ATOM   1020  OH  TYR A  67      25.832  60.500  11.202  1.00  0.00           O  
ATOM   1021  H   TYR A  67      20.883  61.604   7.736  1.00  0.00           H  
ATOM   1022  HA  TYR A  67      22.959  62.681   6.144  1.00  0.00           H  
ATOM   1023  HB2 TYR A  67      21.996  59.842   6.522  1.00  0.00           H  
ATOM   1024  HB3 TYR A  67      23.439  60.269   5.608  1.00  0.00           H  
ATOM   1025  HD1 TYR A  67      21.900  60.599   8.983  1.00  0.00           H  
ATOM   1026  HD2 TYR A  67      25.489  60.492   6.699  1.00  0.00           H  
ATOM   1027  HE1 TYR A  67      23.215  60.573  11.061  1.00  0.00           H  
ATOM   1028  HE2 TYR A  67      26.813  60.463   8.771  1.00  0.00           H  
ATOM   1029  HH  TYR A  67      25.526  59.786  11.767  1.00  0.00           H  
ATOM   1030  N   ILE A  68      22.016  62.880   3.872  1.00  0.00           N  
ATOM   1031  CA  ILE A  68      21.533  62.981   2.500  1.00  0.00           C  
ATOM   1032  C   ILE A  68      22.314  62.057   1.573  1.00  0.00           C  
ATOM   1033  O   ILE A  68      22.287  62.216   0.353  1.00  0.00           O  
ATOM   1034  CB  ILE A  68      21.634  64.424   1.972  1.00  0.00           C  
ATOM   1035  CG1 ILE A  68      23.081  64.752   1.595  1.00  0.00           C  
ATOM   1036  CG2 ILE A  68      21.118  65.407   3.013  1.00  0.00           C  
ATOM   1037  CD1 ILE A  68      23.248  66.124   0.980  1.00  0.00           C  
ATOM   1038  H   ILE A  68      22.668  63.534   4.199  1.00  0.00           H  
ATOM   1039  HA  ILE A  68      20.493  62.688   2.491  1.00  0.00           H  
ATOM   1040  HB  ILE A  68      21.013  64.507   1.094  1.00  0.00           H  
ATOM   1041 HG12 ILE A  68      23.696  64.708   2.479  1.00  0.00           H  
ATOM   1042 HG13 ILE A  68      23.432  64.022   0.880  1.00  0.00           H  
ATOM   1043 HG21 ILE A  68      20.206  65.864   2.655  1.00  0.00           H  
ATOM   1044 HG22 ILE A  68      20.918  64.881   3.935  1.00  0.00           H  
ATOM   1045 HG23 ILE A  68      21.860  66.171   3.187  1.00  0.00           H  
ATOM   1046 HD11 ILE A  68      24.151  66.581   1.359  1.00  0.00           H  
ATOM   1047 HD12 ILE A  68      23.313  66.032  -0.093  1.00  0.00           H  
ATOM   1048 HD13 ILE A  68      22.400  66.741   1.239  1.00  0.00           H  
ATOM   1049  N   ASP A  69      23.010  61.089   2.160  1.00  0.00           N  
ATOM   1050  CA  ASP A  69      23.798  60.136   1.387  1.00  0.00           C  
ATOM   1051  C   ASP A  69      23.175  58.745   1.443  1.00  0.00           C  
ATOM   1052  O   ASP A  69      23.252  57.980   0.481  1.00  0.00           O  
ATOM   1053  CB  ASP A  69      25.235  60.086   1.909  1.00  0.00           C  
ATOM   1054  CG  ASP A  69      25.889  61.453   1.933  1.00  0.00           C  
ATOM   1055  OD1 ASP A  69      26.050  62.052   0.850  1.00  0.00           O  
ATOM   1056  OD2 ASP A  69      26.241  61.923   3.036  1.00  0.00           O  
ATOM   1057  H   ASP A  69      22.993  61.013   3.138  1.00  0.00           H  
ATOM   1058  HA  ASP A  69      23.809  60.470   0.361  1.00  0.00           H  
ATOM   1059  HB2 ASP A  69      25.231  59.692   2.916  1.00  0.00           H  
ATOM   1060  HB3 ASP A  69      25.819  59.437   1.275  1.00  0.00           H  
ATOM   1061  N   TYR A  70      22.559  58.422   2.575  1.00  0.00           N  
ATOM   1062  CA  TYR A  70      21.926  57.122   2.758  1.00  0.00           C  
ATOM   1063  C   TYR A  70      20.417  57.270   2.930  1.00  0.00           C  
ATOM   1064  O   TYR A  70      19.637  56.523   2.341  1.00  0.00           O  
ATOM   1065  CB  TYR A  70      22.521  56.407   3.972  1.00  0.00           C  
ATOM   1066  CG  TYR A  70      24.026  56.265   3.913  1.00  0.00           C  
ATOM   1067  CD1 TYR A  70      24.853  57.377   4.024  1.00  0.00           C  
ATOM   1068  CD2 TYR A  70      24.620  55.021   3.747  1.00  0.00           C  
ATOM   1069  CE1 TYR A  70      26.227  57.252   3.971  1.00  0.00           C  
ATOM   1070  CE2 TYR A  70      25.994  54.886   3.694  1.00  0.00           C  
ATOM   1071  CZ  TYR A  70      26.793  56.005   3.805  1.00  0.00           C  
ATOM   1072  OH  TYR A  70      28.162  55.876   3.753  1.00  0.00           O  
ATOM   1073  H   TYR A  70      22.530  59.073   3.306  1.00  0.00           H  
ATOM   1074  HA  TYR A  70      22.120  56.532   1.874  1.00  0.00           H  
ATOM   1075  HB2 TYR A  70      22.275  56.962   4.864  1.00  0.00           H  
ATOM   1076  HB3 TYR A  70      22.097  55.416   4.041  1.00  0.00           H  
ATOM   1077  HD1 TYR A  70      24.406  58.351   4.155  1.00  0.00           H  
ATOM   1078  HD2 TYR A  70      23.991  54.146   3.659  1.00  0.00           H  
ATOM   1079  HE1 TYR A  70      26.853  58.127   4.059  1.00  0.00           H  
ATOM   1080  HE2 TYR A  70      26.437  53.910   3.564  1.00  0.00           H  
ATOM   1081  HH  TYR A  70      28.542  56.658   3.343  1.00  0.00           H  
ATOM   1082  N   GLY A  71      20.013  58.241   3.743  1.00  0.00           N  
ATOM   1083  CA  GLY A  71      18.600  58.471   3.980  1.00  0.00           C  
ATOM   1084  C   GLY A  71      18.183  58.114   5.392  1.00  0.00           C  
ATOM   1085  O   GLY A  71      17.126  57.521   5.603  1.00  0.00           O  
ATOM   1086  H   GLY A  71      20.680  58.806   4.186  1.00  0.00           H  
ATOM   1087  HA2 GLY A  71      18.382  59.514   3.803  1.00  0.00           H  
ATOM   1088  HA3 GLY A  71      18.028  57.872   3.286  1.00  0.00           H  
ATOM   1089  N   ASN A  72      19.016  58.474   6.363  1.00  0.00           N  
ATOM   1090  CA  ASN A  72      18.729  58.185   7.764  1.00  0.00           C  
ATOM   1091  C   ASN A  72      18.831  59.450   8.611  1.00  0.00           C  
ATOM   1092  O   ASN A  72      19.308  60.484   8.146  1.00  0.00           O  
ATOM   1093  CB  ASN A  72      19.693  57.122   8.295  1.00  0.00           C  
ATOM   1094  CG  ASN A  72      19.071  56.271   9.385  1.00  0.00           C  
ATOM   1095  OD1 ASN A  72      18.157  55.488   9.130  1.00  0.00           O  
ATOM   1096  ND2 ASN A  72      19.566  56.423  10.609  1.00  0.00           N  
ATOM   1097  H   ASN A  72      19.845  58.944   6.132  1.00  0.00           H  
ATOM   1098  HA  ASN A  72      17.721  57.806   7.823  1.00  0.00           H  
ATOM   1099  HB2 ASN A  72      19.987  56.473   7.483  1.00  0.00           H  
ATOM   1100  HB3 ASN A  72      20.569  57.608   8.697  1.00  0.00           H  
ATOM   1101 HD21 ASN A  72      20.294  57.067  10.736  1.00  0.00           H  
ATOM   1102 HD22 ASN A  72      19.183  55.886  11.332  1.00  0.00           H  
ATOM   1103  N   ARG A  73      18.381  59.358   9.858  1.00  0.00           N  
ATOM   1104  CA  ARG A  73      18.420  60.494  10.771  1.00  0.00           C  
ATOM   1105  C   ARG A  73      19.098  60.113  12.083  1.00  0.00           C  
ATOM   1106  O   ARG A  73      18.904  59.011  12.596  1.00  0.00           O  
ATOM   1107  CB  ARG A  73      17.004  61.005  11.044  1.00  0.00           C  
ATOM   1108  CG  ARG A  73      16.127  61.062   9.805  1.00  0.00           C  
ATOM   1109  CD  ARG A  73      14.664  60.829  10.147  1.00  0.00           C  
ATOM   1110  NE  ARG A  73      14.388  59.424  10.440  1.00  0.00           N  
ATOM   1111  CZ  ARG A  73      13.163  58.928  10.569  1.00  0.00           C  
ATOM   1112  NH1 ARG A  73      12.106  59.717  10.434  1.00  0.00           N  
ATOM   1113  NH2 ARG A  73      12.993  57.639  10.836  1.00  0.00           N  
ATOM   1114  H   ARG A  73      18.011  58.505  10.171  1.00  0.00           H  
ATOM   1115  HA  ARG A  73      18.992  61.279  10.299  1.00  0.00           H  
ATOM   1116  HB2 ARG A  73      16.531  60.351  11.763  1.00  0.00           H  
ATOM   1117  HB3 ARG A  73      17.068  61.998  11.461  1.00  0.00           H  
ATOM   1118  HG2 ARG A  73      16.227  62.037   9.350  1.00  0.00           H  
ATOM   1119  HG3 ARG A  73      16.452  60.303   9.110  1.00  0.00           H  
ATOM   1120  HD2 ARG A  73      14.410  61.423  11.012  1.00  0.00           H  
ATOM   1121  HD3 ARG A  73      14.058  61.138   9.308  1.00  0.00           H  
ATOM   1122  HE  ARG A  73      15.155  58.823  10.544  1.00  0.00           H  
ATOM   1123 HH11 ARG A  73      12.232  60.688  10.233  1.00  0.00           H  
ATOM   1124 HH12 ARG A  73      11.185  59.340  10.531  1.00  0.00           H  
ATOM   1125 HH21 ARG A  73      13.787  57.041  10.939  1.00  0.00           H  
ATOM   1126 HH22 ARG A  73      12.071  57.266  10.933  1.00  0.00           H  
ATOM   1127  N   GLU A  74      19.895  61.032  12.621  1.00  0.00           N  
ATOM   1128  CA  GLU A  74      20.602  60.791  13.873  1.00  0.00           C  
ATOM   1129  C   GLU A  74      20.869  62.101  14.608  1.00  0.00           C  
ATOM   1130  O   GLU A  74      21.319  63.080  14.011  1.00  0.00           O  
ATOM   1131  CB  GLU A  74      21.922  60.064  13.607  1.00  0.00           C  
ATOM   1132  CG  GLU A  74      22.625  59.596  14.870  1.00  0.00           C  
ATOM   1133  CD  GLU A  74      22.072  58.285  15.392  1.00  0.00           C  
ATOM   1134  OE1 GLU A  74      22.499  57.222  14.894  1.00  0.00           O  
ATOM   1135  OE2 GLU A  74      21.214  58.321  16.299  1.00  0.00           O  
ATOM   1136  H   GLU A  74      20.009  61.891  12.165  1.00  0.00           H  
ATOM   1137  HA  GLU A  74      19.977  60.166  14.492  1.00  0.00           H  
ATOM   1138  HB2 GLU A  74      21.726  59.202  12.987  1.00  0.00           H  
ATOM   1139  HB3 GLU A  74      22.586  60.733  13.077  1.00  0.00           H  
ATOM   1140  HG2 GLU A  74      23.675  59.467  14.656  1.00  0.00           H  
ATOM   1141  HG3 GLU A  74      22.505  60.351  15.633  1.00  0.00           H  
ATOM   1142  N   VAL A  75      20.588  62.112  15.907  1.00  0.00           N  
ATOM   1143  CA  VAL A  75      20.798  63.301  16.725  1.00  0.00           C  
ATOM   1144  C   VAL A  75      22.225  63.359  17.255  1.00  0.00           C  
ATOM   1145  O   VAL A  75      22.553  62.725  18.259  1.00  0.00           O  
ATOM   1146  CB  VAL A  75      19.818  63.345  17.913  1.00  0.00           C  
ATOM   1147  CG1 VAL A  75      20.063  64.584  18.761  1.00  0.00           C  
ATOM   1148  CG2 VAL A  75      18.380  63.303  17.418  1.00  0.00           C  
ATOM   1149  H   VAL A  75      20.231  61.301  16.326  1.00  0.00           H  
ATOM   1150  HA  VAL A  75      20.619  64.168  16.105  1.00  0.00           H  
ATOM   1151  HB  VAL A  75      19.991  62.474  18.527  1.00  0.00           H  
ATOM   1152 HG11 VAL A  75      19.638  64.436  19.743  1.00  0.00           H  
ATOM   1153 HG12 VAL A  75      21.126  64.755  18.850  1.00  0.00           H  
ATOM   1154 HG13 VAL A  75      19.598  65.438  18.293  1.00  0.00           H  
ATOM   1155 HG21 VAL A  75      18.365  63.002  16.381  1.00  0.00           H  
ATOM   1156 HG22 VAL A  75      17.817  62.593  18.008  1.00  0.00           H  
ATOM   1157 HG23 VAL A  75      17.937  64.283  17.516  1.00  0.00           H  
ATOM   1158  N   LEU A  76      23.073  64.122  16.574  1.00  0.00           N  
ATOM   1159  CA  LEU A  76      24.469  64.263  16.977  1.00  0.00           C  
ATOM   1160  C   LEU A  76      24.761  65.688  17.437  1.00  0.00           C  
ATOM   1161  O   LEU A  76      24.119  66.648  17.010  1.00  0.00           O  
ATOM   1162  CB  LEU A  76      25.394  63.889  15.818  1.00  0.00           C  
ATOM   1163  CG  LEU A  76      25.069  62.582  15.094  1.00  0.00           C  
ATOM   1164  CD1 LEU A  76      25.505  62.654  13.639  1.00  0.00           C  
ATOM   1165  CD2 LEU A  76      25.732  61.404  15.793  1.00  0.00           C  
ATOM   1166  H   LEU A  76      22.755  64.602  15.782  1.00  0.00           H  
ATOM   1167  HA  LEU A  76      24.645  63.588  17.801  1.00  0.00           H  
ATOM   1168  HB2 LEU A  76      25.356  64.687  15.093  1.00  0.00           H  
ATOM   1169  HB3 LEU A  76      26.398  63.809  16.211  1.00  0.00           H  
ATOM   1170  HG  LEU A  76      23.999  62.424  15.114  1.00  0.00           H  
ATOM   1171 HD11 LEU A  76      24.758  63.181  13.065  1.00  0.00           H  
ATOM   1172 HD12 LEU A  76      25.622  61.655  13.248  1.00  0.00           H  
ATOM   1173 HD13 LEU A  76      26.447  63.179  13.571  1.00  0.00           H  
ATOM   1174 HD21 LEU A  76      26.764  61.335  15.479  1.00  0.00           H  
ATOM   1175 HD22 LEU A  76      25.215  60.492  15.532  1.00  0.00           H  
ATOM   1176 HD23 LEU A  76      25.690  61.550  16.863  1.00  0.00           H  
ATOM   1177  N   PRO A  77      25.755  65.831  18.325  1.00  0.00           N  
ATOM   1178  CA  PRO A  77      26.156  67.135  18.861  1.00  0.00           C  
ATOM   1179  C   PRO A  77      26.838  68.006  17.811  1.00  0.00           C  
ATOM   1180  O   PRO A  77      27.090  67.563  16.691  1.00  0.00           O  
ATOM   1181  CB  PRO A  77      27.141  66.773  19.976  1.00  0.00           C  
ATOM   1182  CG  PRO A  77      27.682  65.441  19.586  1.00  0.00           C  
ATOM   1183  CD  PRO A  77      26.562  64.730  18.878  1.00  0.00           C  
ATOM   1184  HA  PRO A  77      25.316  67.669  19.278  1.00  0.00           H  
ATOM   1185  HB2 PRO A  77      27.921  67.518  20.027  1.00  0.00           H  
ATOM   1186  HB3 PRO A  77      26.618  66.725  20.920  1.00  0.00           H  
ATOM   1187  HG2 PRO A  77      28.525  65.567  18.924  1.00  0.00           H  
ATOM   1188  HG3 PRO A  77      27.975  64.892  20.469  1.00  0.00           H  
ATOM   1189  HD2 PRO A  77      26.953  64.104  18.088  1.00  0.00           H  
ATOM   1190  HD3 PRO A  77      25.986  64.142  19.577  1.00  0.00           H  
ATOM   1191  N   SER A  78      27.137  69.248  18.182  1.00  0.00           N  
ATOM   1192  CA  SER A  78      27.786  70.182  17.271  1.00  0.00           C  
ATOM   1193  C   SER A  78      29.272  69.865  17.137  1.00  0.00           C  
ATOM   1194  O   SER A  78      30.009  70.563  16.439  1.00  0.00           O  
ATOM   1195  CB  SER A  78      27.602  71.619  17.764  1.00  0.00           C  
ATOM   1196  OG  SER A  78      28.568  71.949  18.747  1.00  0.00           O  
ATOM   1197  H   SER A  78      26.910  69.542  19.089  1.00  0.00           H  
ATOM   1198  HA  SER A  78      27.319  70.080  16.302  1.00  0.00           H  
ATOM   1199  HB2 SER A  78      27.706  72.299  16.932  1.00  0.00           H  
ATOM   1200  HB3 SER A  78      26.616  71.725  18.194  1.00  0.00           H  
ATOM   1201  HG  SER A  78      28.128  72.304  19.522  1.00  0.00           H  
ATOM   1202  N   THR A  79      29.709  68.806  17.813  1.00  0.00           N  
ATOM   1203  CA  THR A  79      31.107  68.396  17.772  1.00  0.00           C  
ATOM   1204  C   THR A  79      31.382  67.503  16.568  1.00  0.00           C  
ATOM   1205  O   THR A  79      32.436  67.600  15.938  1.00  0.00           O  
ATOM   1206  CB  THR A  79      31.511  67.647  19.056  1.00  0.00           C  
ATOM   1207  OG1 THR A  79      30.638  66.532  19.266  1.00  0.00           O  
ATOM   1208  CG2 THR A  79      31.459  68.573  20.261  1.00  0.00           C  
ATOM   1209  H   THR A  79      29.074  68.290  18.352  1.00  0.00           H  
ATOM   1210  HA  THR A  79      31.713  69.287  17.693  1.00  0.00           H  
ATOM   1211  HB  THR A  79      32.523  67.286  18.940  1.00  0.00           H  
ATOM   1212  HG1 THR A  79      30.734  66.217  20.169  1.00  0.00           H  
ATOM   1213 HG21 THR A  79      30.968  68.070  21.081  1.00  0.00           H  
ATOM   1214 HG22 THR A  79      30.908  69.467  20.005  1.00  0.00           H  
ATOM   1215 HG23 THR A  79      32.463  68.841  20.553  1.00  0.00           H  
ATOM   1216  N   ARG A  80      30.428  66.632  16.252  1.00  0.00           N  
ATOM   1217  CA  ARG A  80      30.569  65.721  15.123  1.00  0.00           C  
ATOM   1218  C   ARG A  80      30.207  66.416  13.814  1.00  0.00           C  
ATOM   1219  O   ARG A  80      30.326  65.833  12.735  1.00  0.00           O  
ATOM   1220  CB  ARG A  80      29.684  64.489  15.321  1.00  0.00           C  
ATOM   1221  CG  ARG A  80      29.414  64.161  16.781  1.00  0.00           C  
ATOM   1222  CD  ARG A  80      29.103  62.685  16.972  1.00  0.00           C  
ATOM   1223  NE  ARG A  80      29.180  62.287  18.375  1.00  0.00           N  
ATOM   1224  CZ  ARG A  80      28.970  61.045  18.799  1.00  0.00           C  
ATOM   1225  NH1 ARG A  80      28.675  60.086  17.933  1.00  0.00           N  
ATOM   1226  NH2 ARG A  80      29.058  60.762  20.092  1.00  0.00           N  
ATOM   1227  H   ARG A  80      29.611  66.602  16.792  1.00  0.00           H  
ATOM   1228  HA  ARG A  80      31.602  65.408  15.076  1.00  0.00           H  
ATOM   1229  HB2 ARG A  80      28.736  64.659  14.833  1.00  0.00           H  
ATOM   1230  HB3 ARG A  80      30.167  63.637  14.867  1.00  0.00           H  
ATOM   1231  HG2 ARG A  80      30.288  64.411  17.364  1.00  0.00           H  
ATOM   1232  HG3 ARG A  80      28.572  64.745  17.121  1.00  0.00           H  
ATOM   1233  HD2 ARG A  80      28.106  62.490  16.606  1.00  0.00           H  
ATOM   1234  HD3 ARG A  80      29.814  62.105  16.404  1.00  0.00           H  
ATOM   1235  HE  ARG A  80      29.397  62.980  19.033  1.00  0.00           H  
ATOM   1236 HH11 ARG A  80      28.609  60.298  16.958  1.00  0.00           H  
ATOM   1237 HH12 ARG A  80      28.519  59.152  18.255  1.00  0.00           H  
ATOM   1238 HH21 ARG A  80      29.282  61.481  20.748  1.00  0.00           H  
ATOM   1239 HH22 ARG A  80      28.900  59.827  20.410  1.00  0.00           H  
ATOM   1240  N   LEU A  81      29.762  67.663  13.917  1.00  0.00           N  
ATOM   1241  CA  LEU A  81      29.381  68.439  12.741  1.00  0.00           C  
ATOM   1242  C   LEU A  81      30.485  69.416  12.352  1.00  0.00           C  
ATOM   1243  O   LEU A  81      31.130  70.015  13.212  1.00  0.00           O  
ATOM   1244  CB  LEU A  81      28.081  69.200  13.008  1.00  0.00           C  
ATOM   1245  CG  LEU A  81      26.862  68.346  13.359  1.00  0.00           C  
ATOM   1246  CD1 LEU A  81      25.721  69.221  13.853  1.00  0.00           C  
ATOM   1247  CD2 LEU A  81      26.424  67.523  12.157  1.00  0.00           C  
ATOM   1248  H   LEU A  81      29.688  68.074  14.803  1.00  0.00           H  
ATOM   1249  HA  LEU A  81      29.223  67.749  11.926  1.00  0.00           H  
ATOM   1250  HB2 LEU A  81      28.257  69.878  13.829  1.00  0.00           H  
ATOM   1251  HB3 LEU A  81      27.844  69.768  12.120  1.00  0.00           H  
ATOM   1252  HG  LEU A  81      27.127  67.663  14.155  1.00  0.00           H  
ATOM   1253 HD11 LEU A  81      25.427  68.906  14.842  1.00  0.00           H  
ATOM   1254 HD12 LEU A  81      24.881  69.130  13.180  1.00  0.00           H  
ATOM   1255 HD13 LEU A  81      26.045  70.252  13.884  1.00  0.00           H  
ATOM   1256 HD21 LEU A  81      26.093  66.550  12.490  1.00  0.00           H  
ATOM   1257 HD22 LEU A  81      27.256  67.407  11.477  1.00  0.00           H  
ATOM   1258 HD23 LEU A  81      25.612  68.026  11.652  1.00  0.00           H  
ATOM   1259  N   GLY A  82      30.697  69.573  11.049  1.00  0.00           N  
ATOM   1260  CA  GLY A  82      31.723  70.481  10.567  1.00  0.00           C  
ATOM   1261  C   GLY A  82      31.328  71.170   9.277  1.00  0.00           C  
ATOM   1262  O   GLY A  82      30.306  70.838   8.673  1.00  0.00           O  
ATOM   1263  H   GLY A  82      30.152  69.069  10.408  1.00  0.00           H  
ATOM   1264  HA2 GLY A  82      31.907  71.230  11.322  1.00  0.00           H  
ATOM   1265  HA3 GLY A  82      32.631  69.922  10.400  1.00  0.00           H  
ATOM   1266  N   THR A  83      32.138  72.134   8.851  1.00  0.00           N  
ATOM   1267  CA  THR A  83      31.867  72.874   7.625  1.00  0.00           C  
ATOM   1268  C   THR A  83      32.032  71.985   6.397  1.00  0.00           C  
ATOM   1269  O   THR A  83      33.126  71.493   6.118  1.00  0.00           O  
ATOM   1270  CB  THR A  83      32.795  74.096   7.489  1.00  0.00           C  
ATOM   1271  OG1 THR A  83      32.926  74.755   8.753  1.00  0.00           O  
ATOM   1272  CG2 THR A  83      32.256  75.072   6.455  1.00  0.00           C  
ATOM   1273  H   THR A  83      32.936  72.353   9.375  1.00  0.00           H  
ATOM   1274  HA  THR A  83      30.846  73.228   7.667  1.00  0.00           H  
ATOM   1275  HB  THR A  83      33.769  73.754   7.167  1.00  0.00           H  
ATOM   1276  HG1 THR A  83      33.345  75.609   8.627  1.00  0.00           H  
ATOM   1277 HG21 THR A  83      31.275  75.408   6.753  1.00  0.00           H  
ATOM   1278 HG22 THR A  83      32.193  74.582   5.495  1.00  0.00           H  
ATOM   1279 HG23 THR A  83      32.920  75.922   6.382  1.00  0.00           H  
ATOM   1280  N   LEU A  84      30.940  71.784   5.669  1.00  0.00           N  
ATOM   1281  CA  LEU A  84      30.964  70.953   4.469  1.00  0.00           C  
ATOM   1282  C   LEU A  84      31.600  71.702   3.301  1.00  0.00           C  
ATOM   1283  O   LEU A  84      31.036  72.670   2.792  1.00  0.00           O  
ATOM   1284  CB  LEU A  84      29.546  70.517   4.099  1.00  0.00           C  
ATOM   1285  CG  LEU A  84      29.366  69.944   2.693  1.00  0.00           C  
ATOM   1286  CD1 LEU A  84      30.257  68.727   2.494  1.00  0.00           C  
ATOM   1287  CD2 LEU A  84      27.908  69.584   2.446  1.00  0.00           C  
ATOM   1288  H   LEU A  84      30.097  72.202   5.942  1.00  0.00           H  
ATOM   1289  HA  LEU A  84      31.558  70.077   4.684  1.00  0.00           H  
ATOM   1290  HB2 LEU A  84      29.237  69.762   4.805  1.00  0.00           H  
ATOM   1291  HB3 LEU A  84      28.900  71.379   4.191  1.00  0.00           H  
ATOM   1292  HG  LEU A  84      29.654  70.691   1.966  1.00  0.00           H  
ATOM   1293 HD11 LEU A  84      29.761  68.019   1.848  1.00  0.00           H  
ATOM   1294 HD12 LEU A  84      30.455  68.267   3.449  1.00  0.00           H  
ATOM   1295 HD13 LEU A  84      31.189  69.035   2.042  1.00  0.00           H  
ATOM   1296 HD21 LEU A  84      27.747  68.544   2.689  1.00  0.00           H  
ATOM   1297 HD22 LEU A  84      27.667  69.751   1.405  1.00  0.00           H  
ATOM   1298 HD23 LEU A  84      27.275  70.201   3.066  1.00  0.00           H  
ATOM   1299  N   SER A  85      32.775  71.244   2.881  1.00  0.00           N  
ATOM   1300  CA  SER A  85      33.487  71.871   1.774  1.00  0.00           C  
ATOM   1301  C   SER A  85      32.629  71.884   0.512  1.00  0.00           C  
ATOM   1302  O   SER A  85      31.858  70.962   0.246  1.00  0.00           O  
ATOM   1303  CB  SER A  85      34.801  71.134   1.504  1.00  0.00           C  
ATOM   1304  OG  SER A  85      35.452  71.659   0.359  1.00  0.00           O  
ATOM   1305  H   SER A  85      33.172  70.467   3.328  1.00  0.00           H  
ATOM   1306  HA  SER A  85      33.707  72.890   2.056  1.00  0.00           H  
ATOM   1307  HB2 SER A  85      35.454  71.245   2.356  1.00  0.00           H  
ATOM   1308  HB3 SER A  85      34.596  70.087   1.339  1.00  0.00           H  
ATOM   1309  HG  SER A  85      35.372  71.037  -0.368  1.00  0.00           H  
ATOM   1310  N   PRO A  86      32.766  72.954  -0.284  1.00  0.00           N  
ATOM   1311  CA  PRO A  86      32.012  73.114  -1.531  1.00  0.00           C  
ATOM   1312  C   PRO A  86      32.459  72.132  -2.609  1.00  0.00           C  
ATOM   1313  O   PRO A  86      31.710  71.830  -3.537  1.00  0.00           O  
ATOM   1314  CB  PRO A  86      32.326  74.551  -1.954  1.00  0.00           C  
ATOM   1315  CG  PRO A  86      33.643  74.852  -1.326  1.00  0.00           C  
ATOM   1316  CD  PRO A  86      33.667  74.090  -0.029  1.00  0.00           C  
ATOM   1317  HA  PRO A  86      30.949  73.008  -1.369  1.00  0.00           H  
ATOM   1318  HB2 PRO A  86      32.379  74.609  -3.032  1.00  0.00           H  
ATOM   1319  HB3 PRO A  86      31.555  75.213  -1.589  1.00  0.00           H  
ATOM   1320  HG2 PRO A  86      34.442  74.518  -1.971  1.00  0.00           H  
ATOM   1321  HG3 PRO A  86      33.727  75.912  -1.139  1.00  0.00           H  
ATOM   1322  HD2 PRO A  86      34.667  73.747   0.189  1.00  0.00           H  
ATOM   1323  HD3 PRO A  86      33.292  74.705   0.776  1.00  0.00           H  
ATOM   1324  N   ALA A  87      33.686  71.635  -2.479  1.00  0.00           N  
ATOM   1325  CA  ALA A  87      34.231  70.686  -3.440  1.00  0.00           C  
ATOM   1326  C   ALA A  87      33.590  69.311  -3.279  1.00  0.00           C  
ATOM   1327  O   ALA A  87      33.398  68.586  -4.255  1.00  0.00           O  
ATOM   1328  CB  ALA A  87      35.742  70.588  -3.285  1.00  0.00           C  
ATOM   1329  H   ALA A  87      34.236  71.914  -1.717  1.00  0.00           H  
ATOM   1330  HA  ALA A  87      34.019  71.056  -4.433  1.00  0.00           H  
ATOM   1331  HB1 ALA A  87      35.995  70.568  -2.235  1.00  0.00           H  
ATOM   1332  HB2 ALA A  87      36.093  69.682  -3.757  1.00  0.00           H  
ATOM   1333  HB3 ALA A  87      36.208  71.442  -3.752  1.00  0.00           H  
ATOM   1334  N   PHE A  88      33.261  68.959  -2.040  1.00  0.00           N  
ATOM   1335  CA  PHE A  88      32.643  67.671  -1.751  1.00  0.00           C  
ATOM   1336  C   PHE A  88      31.144  67.827  -1.514  1.00  0.00           C  
ATOM   1337  O   PHE A  88      30.412  66.842  -1.428  1.00  0.00           O  
ATOM   1338  CB  PHE A  88      33.300  67.029  -0.526  1.00  0.00           C  
ATOM   1339  CG  PHE A  88      34.802  67.039  -0.577  1.00  0.00           C  
ATOM   1340  CD1 PHE A  88      35.475  66.493  -1.658  1.00  0.00           C  
ATOM   1341  CD2 PHE A  88      35.539  67.595   0.457  1.00  0.00           C  
ATOM   1342  CE1 PHE A  88      36.856  66.501  -1.707  1.00  0.00           C  
ATOM   1343  CE2 PHE A  88      36.920  67.606   0.411  1.00  0.00           C  
ATOM   1344  CZ  PHE A  88      37.580  67.056  -0.670  1.00  0.00           C  
ATOM   1345  H   PHE A  88      33.440  69.580  -1.303  1.00  0.00           H  
ATOM   1346  HA  PHE A  88      32.796  67.031  -2.606  1.00  0.00           H  
ATOM   1347  HB2 PHE A  88      32.995  67.566   0.359  1.00  0.00           H  
ATOM   1348  HB3 PHE A  88      32.976  66.002  -0.450  1.00  0.00           H  
ATOM   1349  HD1 PHE A  88      34.909  66.057  -2.469  1.00  0.00           H  
ATOM   1350  HD2 PHE A  88      35.024  68.024   1.304  1.00  0.00           H  
ATOM   1351  HE1 PHE A  88      37.369  66.070  -2.555  1.00  0.00           H  
ATOM   1352  HE2 PHE A  88      37.483  68.041   1.224  1.00  0.00           H  
ATOM   1353  HZ  PHE A  88      38.659  67.065  -0.708  1.00  0.00           H  
ATOM   1354  N   SER A  89      30.695  69.073  -1.410  1.00  0.00           N  
ATOM   1355  CA  SER A  89      29.284  69.360  -1.179  1.00  0.00           C  
ATOM   1356  C   SER A  89      28.411  68.677  -2.228  1.00  0.00           C  
ATOM   1357  O   SER A  89      28.828  68.486  -3.371  1.00  0.00           O  
ATOM   1358  CB  SER A  89      29.038  70.870  -1.201  1.00  0.00           C  
ATOM   1359  OG  SER A  89      27.727  71.168  -1.648  1.00  0.00           O  
ATOM   1360  H   SER A  89      31.328  69.818  -1.487  1.00  0.00           H  
ATOM   1361  HA  SER A  89      29.023  68.977  -0.205  1.00  0.00           H  
ATOM   1362  HB2 SER A  89      29.165  71.267  -0.206  1.00  0.00           H  
ATOM   1363  HB3 SER A  89      29.748  71.338  -1.869  1.00  0.00           H  
ATOM   1364  HG  SER A  89      27.137  71.223  -0.893  1.00  0.00           H  
ATOM   1365  N   THR A  90      27.197  68.311  -1.831  1.00  0.00           N  
ATOM   1366  CA  THR A  90      26.266  67.647  -2.734  1.00  0.00           C  
ATOM   1367  C   THR A  90      26.100  68.435  -4.028  1.00  0.00           C  
ATOM   1368  O   THR A  90      25.615  67.907  -5.029  1.00  0.00           O  
ATOM   1369  CB  THR A  90      24.884  67.461  -2.078  1.00  0.00           C  
ATOM   1370  OG1 THR A  90      24.047  66.659  -2.919  1.00  0.00           O  
ATOM   1371  CG2 THR A  90      24.219  68.806  -1.827  1.00  0.00           C  
ATOM   1372  H   THR A  90      26.923  68.491  -0.907  1.00  0.00           H  
ATOM   1373  HA  THR A  90      26.665  66.671  -2.966  1.00  0.00           H  
ATOM   1374  HB  THR A  90      25.016  66.959  -1.131  1.00  0.00           H  
ATOM   1375  HG1 THR A  90      24.220  65.730  -2.750  1.00  0.00           H  
ATOM   1376 HG21 THR A  90      23.874  69.218  -2.765  1.00  0.00           H  
ATOM   1377 HG22 THR A  90      24.931  69.481  -1.377  1.00  0.00           H  
ATOM   1378 HG23 THR A  90      23.378  68.674  -1.163  1.00  0.00           H  
ATOM   1379  N   ARG A  91      26.505  69.700  -4.002  1.00  0.00           N  
ATOM   1380  CA  ARG A  91      26.401  70.560  -5.175  1.00  0.00           C  
ATOM   1381  C   ARG A  91      26.963  69.865  -6.411  1.00  0.00           C  
ATOM   1382  O   ARG A  91      26.555  70.153  -7.537  1.00  0.00           O  
ATOM   1383  CB  ARG A  91      27.143  71.877  -4.934  1.00  0.00           C  
ATOM   1384  CG  ARG A  91      26.282  72.952  -4.292  1.00  0.00           C  
ATOM   1385  CD  ARG A  91      26.988  74.299  -4.283  1.00  0.00           C  
ATOM   1386  NE  ARG A  91      27.807  74.480  -3.087  1.00  0.00           N  
ATOM   1387  CZ  ARG A  91      27.307  74.769  -1.891  1.00  0.00           C  
ATOM   1388  NH1 ARG A  91      25.998  74.907  -1.732  1.00  0.00           N  
ATOM   1389  NH2 ARG A  91      28.117  74.918  -0.851  1.00  0.00           N  
ATOM   1390  H   ARG A  91      26.884  70.064  -3.174  1.00  0.00           H  
ATOM   1391  HA  ARG A  91      25.355  70.772  -5.339  1.00  0.00           H  
ATOM   1392  HB2 ARG A  91      27.987  71.689  -4.288  1.00  0.00           H  
ATOM   1393  HB3 ARG A  91      27.501  72.251  -5.882  1.00  0.00           H  
ATOM   1394  HG2 ARG A  91      25.361  73.045  -4.849  1.00  0.00           H  
ATOM   1395  HG3 ARG A  91      26.062  72.664  -3.275  1.00  0.00           H  
ATOM   1396  HD2 ARG A  91      27.622  74.364  -5.156  1.00  0.00           H  
ATOM   1397  HD3 ARG A  91      26.243  75.081  -4.320  1.00  0.00           H  
ATOM   1398  HE  ARG A  91      28.777  74.382  -3.183  1.00  0.00           H  
ATOM   1399 HH11 ARG A  91      25.386  74.794  -2.514  1.00  0.00           H  
ATOM   1400 HH12 ARG A  91      25.625  75.124  -0.830  1.00  0.00           H  
ATOM   1401 HH21 ARG A  91      29.105  74.813  -0.967  1.00  0.00           H  
ATOM   1402 HH22 ARG A  91      27.740  75.135   0.048  1.00  0.00           H  
ATOM   1403  N   VAL A  92      27.902  68.950  -6.194  1.00  0.00           N  
ATOM   1404  CA  VAL A  92      28.519  68.213  -7.290  1.00  0.00           C  
ATOM   1405  C   VAL A  92      27.821  66.878  -7.517  1.00  0.00           C  
ATOM   1406  O   VAL A  92      27.623  66.453  -8.656  1.00  0.00           O  
ATOM   1407  CB  VAL A  92      30.015  67.959  -7.023  1.00  0.00           C  
ATOM   1408  CG1 VAL A  92      30.727  67.562  -8.306  1.00  0.00           C  
ATOM   1409  CG2 VAL A  92      30.662  69.188  -6.402  1.00  0.00           C  
ATOM   1410  H   VAL A  92      28.185  68.765  -5.273  1.00  0.00           H  
ATOM   1411  HA  VAL A  92      28.432  68.811  -8.185  1.00  0.00           H  
ATOM   1412  HB  VAL A  92      30.101  67.141  -6.322  1.00  0.00           H  
ATOM   1413 HG11 VAL A  92      30.150  66.807  -8.819  1.00  0.00           H  
ATOM   1414 HG12 VAL A  92      30.834  68.428  -8.942  1.00  0.00           H  
ATOM   1415 HG13 VAL A  92      31.704  67.166  -8.069  1.00  0.00           H  
ATOM   1416 HG21 VAL A  92      31.621  68.918  -5.987  1.00  0.00           H  
ATOM   1417 HG22 VAL A  92      30.798  69.945  -7.162  1.00  0.00           H  
ATOM   1418 HG23 VAL A  92      30.025  69.574  -5.620  1.00  0.00           H  
ATOM   1419  N   LEU A  93      27.448  66.218  -6.425  1.00  0.00           N  
ATOM   1420  CA  LEU A  93      26.769  64.929  -6.505  1.00  0.00           C  
ATOM   1421  C   LEU A  93      25.400  64.992  -5.836  1.00  0.00           C  
ATOM   1422  O   LEU A  93      25.236  65.557  -4.754  1.00  0.00           O  
ATOM   1423  CB  LEU A  93      27.621  63.840  -5.849  1.00  0.00           C  
ATOM   1424  CG  LEU A  93      27.305  62.402  -6.259  1.00  0.00           C  
ATOM   1425  CD1 LEU A  93      27.682  62.166  -7.713  1.00  0.00           C  
ATOM   1426  CD2 LEU A  93      28.027  61.417  -5.352  1.00  0.00           C  
ATOM   1427  H   LEU A  93      27.633  66.606  -5.545  1.00  0.00           H  
ATOM   1428  HA  LEU A  93      26.635  64.689  -7.549  1.00  0.00           H  
ATOM   1429  HB2 LEU A  93      28.654  64.035  -6.096  1.00  0.00           H  
ATOM   1430  HB3 LEU A  93      27.488  63.918  -4.779  1.00  0.00           H  
ATOM   1431  HG  LEU A  93      26.241  62.232  -6.159  1.00  0.00           H  
ATOM   1432 HD11 LEU A  93      26.837  61.751  -8.242  1.00  0.00           H  
ATOM   1433 HD12 LEU A  93      28.512  61.476  -7.762  1.00  0.00           H  
ATOM   1434 HD13 LEU A  93      27.967  63.103  -8.168  1.00  0.00           H  
ATOM   1435 HD21 LEU A  93      29.076  61.673  -5.306  1.00  0.00           H  
ATOM   1436 HD22 LEU A  93      27.917  60.418  -5.746  1.00  0.00           H  
ATOM   1437 HD23 LEU A  93      27.603  61.463  -4.360  1.00  0.00           H  
ATOM   1438  N   PRO A  94      24.393  64.397  -6.490  1.00  0.00           N  
ATOM   1439  CA  PRO A  94      23.020  64.368  -5.976  1.00  0.00           C  
ATOM   1440  C   PRO A  94      22.880  63.476  -4.747  1.00  0.00           C  
ATOM   1441  O   PRO A  94      23.504  62.419  -4.662  1.00  0.00           O  
ATOM   1442  CB  PRO A  94      22.214  63.800  -7.146  1.00  0.00           C  
ATOM   1443  CG  PRO A  94      23.196  62.998  -7.928  1.00  0.00           C  
ATOM   1444  CD  PRO A  94      24.516  63.703  -7.784  1.00  0.00           C  
ATOM   1445  HA  PRO A  94      22.665  65.361  -5.740  1.00  0.00           H  
ATOM   1446  HB2 PRO A  94      21.411  63.183  -6.767  1.00  0.00           H  
ATOM   1447  HB3 PRO A  94      21.808  64.608  -7.734  1.00  0.00           H  
ATOM   1448  HG2 PRO A  94      23.259  61.999  -7.524  1.00  0.00           H  
ATOM   1449  HG3 PRO A  94      22.900  62.965  -8.966  1.00  0.00           H  
ATOM   1450  HD2 PRO A  94      25.325  62.989  -7.763  1.00  0.00           H  
ATOM   1451  HD3 PRO A  94      24.655  64.411  -8.588  1.00  0.00           H  
ATOM   1452  N   ALA A  95      22.056  63.908  -3.799  1.00  0.00           N  
ATOM   1453  CA  ALA A  95      21.832  63.146  -2.577  1.00  0.00           C  
ATOM   1454  C   ALA A  95      21.295  61.753  -2.889  1.00  0.00           C  
ATOM   1455  O   ALA A  95      20.219  61.609  -3.468  1.00  0.00           O  
ATOM   1456  CB  ALA A  95      20.873  63.890  -1.659  1.00  0.00           C  
ATOM   1457  H   ALA A  95      21.587  64.759  -3.925  1.00  0.00           H  
ATOM   1458  HA  ALA A  95      22.779  63.049  -2.064  1.00  0.00           H  
ATOM   1459  HB1 ALA A  95      20.031  64.247  -2.234  1.00  0.00           H  
ATOM   1460  HB2 ALA A  95      20.524  63.223  -0.886  1.00  0.00           H  
ATOM   1461  HB3 ALA A  95      21.383  64.727  -1.208  1.00  0.00           H  
ATOM   1462  N   GLN A  96      22.052  60.732  -2.501  1.00  0.00           N  
ATOM   1463  CA  GLN A  96      21.652  59.351  -2.741  1.00  0.00           C  
ATOM   1464  C   GLN A  96      20.723  58.853  -1.639  1.00  0.00           C  
ATOM   1465  O   GLN A  96      20.271  57.709  -1.664  1.00  0.00           O  
ATOM   1466  CB  GLN A  96      22.884  58.448  -2.832  1.00  0.00           C  
ATOM   1467  CG  GLN A  96      23.898  58.906  -3.868  1.00  0.00           C  
ATOM   1468  CD  GLN A  96      23.335  58.905  -5.276  1.00  0.00           C  
ATOM   1469  OE1 GLN A  96      22.697  57.942  -5.701  1.00  0.00           O  
ATOM   1470  NE2 GLN A  96      23.568  59.988  -6.007  1.00  0.00           N  
ATOM   1471  H   GLN A  96      22.899  60.911  -2.044  1.00  0.00           H  
ATOM   1472  HA  GLN A  96      21.123  59.318  -3.682  1.00  0.00           H  
ATOM   1473  HB2 GLN A  96      23.371  58.426  -1.869  1.00  0.00           H  
ATOM   1474  HB3 GLN A  96      22.565  57.449  -3.089  1.00  0.00           H  
ATOM   1475  HG2 GLN A  96      24.215  59.909  -3.625  1.00  0.00           H  
ATOM   1476  HG3 GLN A  96      24.750  58.242  -3.836  1.00  0.00           H  
ATOM   1477 HE21 GLN A  96      24.085  60.717  -5.603  1.00  0.00           H  
ATOM   1478 HE22 GLN A  96      23.216  60.015  -6.920  1.00  0.00           H  
ATOM   1479  N   ALA A  97      20.443  59.721  -0.672  1.00  0.00           N  
ATOM   1480  CA  ALA A  97      19.567  59.369   0.439  1.00  0.00           C  
ATOM   1481  C   ALA A  97      18.187  58.958  -0.060  1.00  0.00           C  
ATOM   1482  O   ALA A  97      17.683  59.498  -1.046  1.00  0.00           O  
ATOM   1483  CB  ALA A  97      19.452  60.535   1.410  1.00  0.00           C  
ATOM   1484  H   ALA A  97      20.834  60.618  -0.707  1.00  0.00           H  
ATOM   1485  HA  ALA A  97      20.012  58.537   0.965  1.00  0.00           H  
ATOM   1486  HB1 ALA A  97      20.071  60.345   2.275  1.00  0.00           H  
ATOM   1487  HB2 ALA A  97      19.783  61.441   0.924  1.00  0.00           H  
ATOM   1488  HB3 ALA A  97      18.424  60.646   1.720  1.00  0.00           H  
ATOM   1489  N   THR A  98      17.577  57.995   0.625  1.00  0.00           N  
ATOM   1490  CA  THR A  98      16.256  57.508   0.251  1.00  0.00           C  
ATOM   1491  C   THR A  98      15.160  58.411   0.806  1.00  0.00           C  
ATOM   1492  O   THR A  98      14.289  58.870   0.067  1.00  0.00           O  
ATOM   1493  CB  THR A  98      16.023  56.071   0.753  1.00  0.00           C  
ATOM   1494  OG1 THR A  98      16.741  55.143  -0.068  1.00  0.00           O  
ATOM   1495  CG2 THR A  98      14.541  55.726   0.739  1.00  0.00           C  
ATOM   1496  H   THR A  98      18.029  57.603   1.401  1.00  0.00           H  
ATOM   1497  HA  THR A  98      16.195  57.506  -0.828  1.00  0.00           H  
ATOM   1498  HB  THR A  98      16.385  55.997   1.768  1.00  0.00           H  
ATOM   1499  HG1 THR A  98      16.767  55.468  -0.972  1.00  0.00           H  
ATOM   1500 HG21 THR A  98      14.403  54.716   1.095  1.00  0.00           H  
ATOM   1501 HG22 THR A  98      14.162  55.807  -0.269  1.00  0.00           H  
ATOM   1502 HG23 THR A  98      14.007  56.409   1.380  1.00  0.00           H  
ATOM   1503  N   GLU A  99      15.210  58.663   2.110  1.00  0.00           N  
ATOM   1504  CA  GLU A  99      14.220  59.511   2.763  1.00  0.00           C  
ATOM   1505  C   GLU A  99      14.600  60.985   2.637  1.00  0.00           C  
ATOM   1506  O   GLU A  99      14.232  61.805   3.479  1.00  0.00           O  
ATOM   1507  CB  GLU A  99      14.084  59.132   4.239  1.00  0.00           C  
ATOM   1508  CG  GLU A  99      13.400  57.795   4.463  1.00  0.00           C  
ATOM   1509  CD  GLU A  99      13.365  57.395   5.926  1.00  0.00           C  
ATOM   1510  OE1 GLU A  99      14.183  57.925   6.706  1.00  0.00           O  
ATOM   1511  OE2 GLU A  99      12.518  56.551   6.289  1.00  0.00           O  
ATOM   1512  H   GLU A  99      15.929  58.268   2.646  1.00  0.00           H  
ATOM   1513  HA  GLU A  99      13.272  59.353   2.271  1.00  0.00           H  
ATOM   1514  HB2 GLU A  99      15.069  59.088   4.680  1.00  0.00           H  
ATOM   1515  HB3 GLU A  99      13.509  59.896   4.742  1.00  0.00           H  
ATOM   1516  HG2 GLU A  99      12.386  57.857   4.098  1.00  0.00           H  
ATOM   1517  HG3 GLU A  99      13.933  57.035   3.910  1.00  0.00           H  
ATOM   1518  N   TYR A 100      15.337  61.311   1.582  1.00  0.00           N  
ATOM   1519  CA  TYR A 100      15.769  62.684   1.347  1.00  0.00           C  
ATOM   1520  C   TYR A 100      14.607  63.545   0.860  1.00  0.00           C  
ATOM   1521  O   TYR A 100      14.344  64.617   1.403  1.00  0.00           O  
ATOM   1522  CB  TYR A 100      16.906  62.715   0.325  1.00  0.00           C  
ATOM   1523  CG  TYR A 100      17.178  64.093  -0.236  1.00  0.00           C  
ATOM   1524  CD1 TYR A 100      17.669  65.110   0.574  1.00  0.00           C  
ATOM   1525  CD2 TYR A 100      16.945  64.377  -1.577  1.00  0.00           C  
ATOM   1526  CE1 TYR A 100      17.918  66.370   0.065  1.00  0.00           C  
ATOM   1527  CE2 TYR A 100      17.194  65.634  -2.093  1.00  0.00           C  
ATOM   1528  CZ  TYR A 100      17.679  66.627  -1.269  1.00  0.00           C  
ATOM   1529  OH  TYR A 100      17.928  67.880  -1.779  1.00  0.00           O  
ATOM   1530  H   TYR A 100      15.599  60.613   0.946  1.00  0.00           H  
ATOM   1531  HA  TYR A 100      16.130  63.083   2.285  1.00  0.00           H  
ATOM   1532  HB2 TYR A 100      17.812  62.364   0.794  1.00  0.00           H  
ATOM   1533  HB3 TYR A 100      16.656  62.064  -0.500  1.00  0.00           H  
ATOM   1534  HD1 TYR A 100      17.856  64.905   1.618  1.00  0.00           H  
ATOM   1535  HD2 TYR A 100      16.565  63.597  -2.220  1.00  0.00           H  
ATOM   1536  HE1 TYR A 100      18.299  67.148   0.711  1.00  0.00           H  
ATOM   1537  HE2 TYR A 100      17.006  65.835  -3.138  1.00  0.00           H  
ATOM   1538  HH  TYR A 100      17.421  68.532  -1.289  1.00  0.00           H  
ATOM   1539  N   ALA A 101      13.916  63.067  -0.169  1.00  0.00           N  
ATOM   1540  CA  ALA A 101      12.781  63.789  -0.729  1.00  0.00           C  
ATOM   1541  C   ALA A 101      11.804  64.211   0.364  1.00  0.00           C  
ATOM   1542  O   ALA A 101      11.125  65.230   0.243  1.00  0.00           O  
ATOM   1543  CB  ALA A 101      12.073  62.935  -1.771  1.00  0.00           C  
ATOM   1544  H   ALA A 101      14.175  62.206  -0.560  1.00  0.00           H  
ATOM   1545  HA  ALA A 101      13.159  64.675  -1.221  1.00  0.00           H  
ATOM   1546  HB1 ALA A 101      11.386  62.264  -1.279  1.00  0.00           H  
ATOM   1547  HB2 ALA A 101      11.530  63.575  -2.451  1.00  0.00           H  
ATOM   1548  HB3 ALA A 101      12.804  62.361  -2.323  1.00  0.00           H  
ATOM   1549  N   PHE A 102      11.739  63.418   1.429  1.00  0.00           N  
ATOM   1550  CA  PHE A 102      10.844  63.709   2.542  1.00  0.00           C  
ATOM   1551  C   PHE A 102      11.575  64.471   3.644  1.00  0.00           C  
ATOM   1552  O   PHE A 102      10.954  65.141   4.469  1.00  0.00           O  
ATOM   1553  CB  PHE A 102      10.260  62.412   3.106  1.00  0.00           C  
ATOM   1554  CG  PHE A 102       9.442  61.640   2.110  1.00  0.00           C  
ATOM   1555  CD1 PHE A 102       8.323  62.209   1.523  1.00  0.00           C  
ATOM   1556  CD2 PHE A 102       9.792  60.346   1.762  1.00  0.00           C  
ATOM   1557  CE1 PHE A 102       7.569  61.502   0.605  1.00  0.00           C  
ATOM   1558  CE2 PHE A 102       9.042  59.634   0.845  1.00  0.00           C  
ATOM   1559  CZ  PHE A 102       7.928  60.211   0.267  1.00  0.00           C  
ATOM   1560  H   PHE A 102      12.306  62.620   1.467  1.00  0.00           H  
ATOM   1561  HA  PHE A 102      10.039  64.324   2.169  1.00  0.00           H  
ATOM   1562  HB2 PHE A 102      11.066  61.776   3.436  1.00  0.00           H  
ATOM   1563  HB3 PHE A 102       9.625  62.647   3.947  1.00  0.00           H  
ATOM   1564  HD1 PHE A 102       8.041  63.219   1.788  1.00  0.00           H  
ATOM   1565  HD2 PHE A 102      10.662  59.892   2.213  1.00  0.00           H  
ATOM   1566  HE1 PHE A 102       6.699  61.956   0.156  1.00  0.00           H  
ATOM   1567  HE2 PHE A 102       9.325  58.626   0.582  1.00  0.00           H  
ATOM   1568  HZ  PHE A 102       7.342  59.658  -0.451  1.00  0.00           H  
ATOM   1569  N   ALA A 103      12.899  64.364   3.650  1.00  0.00           N  
ATOM   1570  CA  ALA A 103      13.717  65.043   4.648  1.00  0.00           C  
ATOM   1571  C   ALA A 103      13.330  66.513   4.765  1.00  0.00           C  
ATOM   1572  O   ALA A 103      13.293  67.071   5.863  1.00  0.00           O  
ATOM   1573  CB  ALA A 103      15.192  64.909   4.302  1.00  0.00           C  
ATOM   1574  H   ALA A 103      13.338  63.815   2.966  1.00  0.00           H  
ATOM   1575  HA  ALA A 103      13.551  64.561   5.600  1.00  0.00           H  
ATOM   1576  HB1 ALA A 103      15.473  63.866   4.324  1.00  0.00           H  
ATOM   1577  HB2 ALA A 103      15.368  65.309   3.314  1.00  0.00           H  
ATOM   1578  HB3 ALA A 103      15.781  65.456   5.023  1.00  0.00           H  
ATOM   1579  N   PHE A 104      13.045  67.138   3.628  1.00  0.00           N  
ATOM   1580  CA  PHE A 104      12.663  68.545   3.602  1.00  0.00           C  
ATOM   1581  C   PHE A 104      11.627  68.808   2.512  1.00  0.00           C  
ATOM   1582  O   PHE A 104      11.844  68.485   1.346  1.00  0.00           O  
ATOM   1583  CB  PHE A 104      13.894  69.425   3.374  1.00  0.00           C  
ATOM   1584  CG  PHE A 104      14.805  69.502   4.566  1.00  0.00           C  
ATOM   1585  CD1 PHE A 104      15.540  68.398   4.965  1.00  0.00           C  
ATOM   1586  CD2 PHE A 104      14.925  70.679   5.288  1.00  0.00           C  
ATOM   1587  CE1 PHE A 104      16.378  68.465   6.062  1.00  0.00           C  
ATOM   1588  CE2 PHE A 104      15.762  70.753   6.386  1.00  0.00           C  
ATOM   1589  CZ  PHE A 104      16.491  69.646   6.772  1.00  0.00           C  
ATOM   1590  H   PHE A 104      13.093  66.640   2.784  1.00  0.00           H  
ATOM   1591  HA  PHE A 104      12.230  68.787   4.560  1.00  0.00           H  
ATOM   1592  HB2 PHE A 104      14.463  69.029   2.547  1.00  0.00           H  
ATOM   1593  HB3 PHE A 104      13.571  70.427   3.136  1.00  0.00           H  
ATOM   1594  HD1 PHE A 104      15.455  67.475   4.410  1.00  0.00           H  
ATOM   1595  HD2 PHE A 104      14.355  71.546   4.986  1.00  0.00           H  
ATOM   1596  HE1 PHE A 104      16.947  67.599   6.361  1.00  0.00           H  
ATOM   1597  HE2 PHE A 104      15.846  71.676   6.939  1.00  0.00           H  
ATOM   1598  HZ  PHE A 104      17.144  69.701   7.629  1.00  0.00           H  
TER    1599      PHE A 104                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
