
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   66 ( 1028),  selected   66 , name 2eqj_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2eqj_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      X      63           -
LGA    S     2_A      P      64           -
LGA    S     3_A      P      65           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    K     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    A    11_A      A      66           #
LGA    C    12_A      D      67          4.177
LGA    K    13_A      K      68          3.379
LGA    F    14_A      L      69          0.847
LGA    E    15_A      Y      70          1.255
LGA    E    16_A      V      71          1.167
LGA    G    17_A      G      72          0.647
LGA    Q    18_A      S      73          1.400
LGA    D    19_A      R      74          1.409
LGA    V    20_A      V      75          0.662
LGA    L    21_A      V      76          0.509
LGA    A    22_A      A      77          0.914
LGA    R    23_A      K      78          0.153
LGA    W    24_A      Y      79          1.695
LGA    S    25_A      K      80          2.467
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    D    26_A      N      83           #
LGA    -       -      Q      84           -
LGA    G    27_A      V      85          3.929
LGA    L    28_A      W      86          1.796
LGA    F    29_A      L      87          0.671
LGA    Y    30_A      Y      88          0.577
LGA    L    31_A      A      89          0.899
LGA    G    32_A      G      90          0.550
LGA    T    33_A      I      91          0.888
LGA    I    34_A      V      92          1.085
LGA    K    35_A      A      93          1.243
LGA    K    36_A      E      94          1.009
LGA    I    37_A      T      95          0.605
LGA    N    38_A      P      96          1.422
LGA    I    39_A      N      97          4.095
LGA    L    40_A      V      98          4.619
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    K    41_A      K     101          3.167
LGA    Q    42_A      L     102          3.512
LGA    S    43_A      R     103          1.860
LGA    C    44_A      F     104          1.258
LGA    F    45_A      L     105          1.316
LGA    I    46_A      I     106          1.380
LGA    I    47_A      F     107          0.822
LGA    F    48_A      F     108          0.788
LGA    E    49_A      D     109          1.298
LGA    D    50_A      D     110          1.358
LGA    S    51_A      G     111          0.851
LGA    S    52_A      Y     112          1.219
LGA    K    53_A      A     113          1.172
LGA    S    54_A      S     114          0.891
LGA    W    55_A      Y     115          1.163
LGA    V    56_A      V     116          1.655
LGA    L    57_A      T     117          1.108
LGA    W    58_A      Q     118          1.093
LGA    K    59_A      S     119          0.887
LGA    D    60_A      E     120          0.406
LGA    I    61_A      L     121          1.088
LGA    Q    62_A      Y     122          1.131
LGA    T    63_A      P     123          1.306
LGA    G    64_A      I     124          1.944
LGA    A    65_A      C     125          2.847
LGA    T    66_A      R     126          5.428
LGA    -       -      P     127           -
LGA    -       -      L     128           -
LGA    -       -      K     129           -
LGA    -       -      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    -       -      E     133           -
LGA    -       -      D     134           -
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   66   93    5.0     54    1.95    22.22     53.726     2.629

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.344922 * X  +   0.896789 * Y  +  -0.277126 * Z  +  24.635584
  Y_new =   0.854381 * X  +   0.422220 * Y  +   0.302924 * Z  +  68.157074
  Z_new =   0.388667 * X  +  -0.132287 * Y  +  -0.911832 * Z  +  12.079370 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.997520    0.144073  [ DEG:  -171.7453      8.2547 ]
  Theta =  -0.399184   -2.742409  [ DEG:   -22.8716   -157.1284 ]
  Phi   =   1.954496   -1.187096  [ DEG:   111.9844    -68.0156 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eqj_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eqj_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   66   93   5.0   54   1.95   22.22  53.726
REMARK  ---------------------------------------------------------- 
MOLECULE 2eqj_A
HEADER    TRANSCRIPTION                           30-MAR-07   2EQJ              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF METAL-RESPONSE              
TITLE    2 ELEMENT-BINDING TRANSCRIPTION FACTOR 2                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METAL-RESPONSE ELEMENT-BINDING TRANSCRIPTION               
COMPND   3 FACTOR 2;                                                            
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   6 SYNONYM: ZINC-REGULATED FACTOR 1, ZIRF1, METAL-RESPONSE              
COMPND   7 ELEMENT DNA-BINDING PROTEIN M96, METAL-REGULATORY                    
COMPND   8 TRANSCRIPTION FACTOR 2, PCL2;                                        
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: MTF2;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P061002-01;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR,STRUCTURE GENOMICS,TUDOR DOMAIN, METAL-RESPONSE ELEMENT-          
KEYWDS   2 BINDING TRANSCRIPTION FACTOR 2, ZINC-REGULATED FACTOR 1,             
KEYWDS   3 ZIRF1, METAL-RESPONSE ELEMENT DNA-BINDING PROTEIN M96,               
KEYWDS   4 METAL-REGULATORY TRANSCRIPTION FACTOR 2, PCL2, STRUCTURAL            
KEYWDS   5 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   6 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   7 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,K.ISONO,S.WATANABE,T.TARADA,T.KIGAWA,H.KOSEKI,          
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   08-APR-08 2EQJ    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,K.ISONO,S.WATANABE,T.TARADA,T.KIGAWA,          
JRNL        AUTH 2 H.KOSEKI,S.YOKOYAMA                                          
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF                    
JRNL        TITL 2 METAL-RESPONSE ELEMENT-BINDING TRANSCRIPTION                 
JRNL        TITL 3 FACTOR 2                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EQJ A    8    66  UNP    Q02395   MTF2_MOUSE      40     98             
SEQRES   1 A   66  GLY SER SER GLY SER SER GLY LYS LYS PRO ALA CYS LYS          
SEQRES   2 A   66  PHE GLU GLU GLY GLN ASP VAL LEU ALA ARG TRP SER ASP          
SEQRES   3 A   66  GLY LEU PHE TYR LEU GLY THR ILE LYS LYS ILE ASN ILE          
SEQRES   4 A   66  LEU LYS GLN SER CYS PHE ILE ILE PHE GLU ASP SER SER          
SEQRES   5 A   66  LYS SER TRP VAL LEU TRP LYS ASP ILE GLN THR GLY ALA          
SEQRES   6 A   66  THR                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      22.244  88.118  38.709  1.00  0.00           N  
ATOM      2  CA  GLY A   1      21.598  88.054  40.007  1.00  0.00           C  
ATOM      3  C   GLY A   1      20.089  88.165  39.909  1.00  0.00           C  
ATOM      4  O   GLY A   1      19.499  87.813  38.888  1.00  0.00           O  
ATOM      5  H1  GLY A   1      22.661  88.954  38.411  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      21.850  87.115  40.476  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      21.968  88.862  40.620  1.00  0.00           H  
ATOM      8  N   SER A   2      19.464  88.654  40.974  1.00  0.00           N  
ATOM      9  CA  SER A   2      18.014  88.806  41.007  1.00  0.00           C  
ATOM     10  C   SER A   2      17.565  89.939  40.088  1.00  0.00           C  
ATOM     11  O   SER A   2      16.751  89.737  39.187  1.00  0.00           O  
ATOM     12  CB  SER A   2      17.539  89.075  42.436  1.00  0.00           C  
ATOM     13  OG  SER A   2      17.445  87.870  43.176  1.00  0.00           O  
ATOM     14  H   SER A   2      19.989  88.918  41.759  1.00  0.00           H  
ATOM     15  HA  SER A   2      17.576  87.883  40.659  1.00  0.00           H  
ATOM     16  HB2 SER A   2      18.240  89.731  42.928  1.00  0.00           H  
ATOM     17  HB3 SER A   2      16.566  89.544  42.407  1.00  0.00           H  
ATOM     18  HG  SER A   2      17.750  88.021  44.075  1.00  0.00           H  
ATOM     19  N   SER A   3      18.102  91.132  40.325  1.00  0.00           N  
ATOM     20  CA  SER A   3      17.756  92.299  39.523  1.00  0.00           C  
ATOM     21  C   SER A   3      18.348  92.191  38.121  1.00  0.00           C  
ATOM     22  O   SER A   3      19.547  92.377  37.926  1.00  0.00           O  
ATOM     23  CB  SER A   3      18.253  93.577  40.202  1.00  0.00           C  
ATOM     24  OG  SER A   3      17.376  93.977  41.241  1.00  0.00           O  
ATOM     25  H   SER A   3      18.746  91.229  41.059  1.00  0.00           H  
ATOM     26  HA  SER A   3      16.679  92.339  39.444  1.00  0.00           H  
ATOM     27  HB2 SER A   3      19.232  93.400  40.621  1.00  0.00           H  
ATOM     28  HB3 SER A   3      18.312  94.370  39.470  1.00  0.00           H  
ATOM     29  HG  SER A   3      16.475  93.743  41.007  1.00  0.00           H  
ATOM     30  N   GLY A   4      17.495  91.886  37.148  1.00  0.00           N  
ATOM     31  CA  GLY A   4      17.952  91.758  35.775  1.00  0.00           C  
ATOM     32  C   GLY A   4      18.219  90.317  35.386  1.00  0.00           C  
ATOM     33  O   GLY A   4      18.005  89.402  36.182  1.00  0.00           O  
ATOM     34  H   GLY A   4      16.549  91.749  37.362  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      17.197  92.163  35.117  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      18.862  92.326  35.656  1.00  0.00           H  
ATOM     37  N   SER A   5      18.689  90.115  34.160  1.00  0.00           N  
ATOM     38  CA  SER A   5      18.981  88.775  33.665  1.00  0.00           C  
ATOM     39  C   SER A   5      20.481  88.495  33.707  1.00  0.00           C  
ATOM     40  O   SER A   5      21.288  89.305  33.250  1.00  0.00           O  
ATOM     41  CB  SER A   5      18.461  88.611  32.236  1.00  0.00           C  
ATOM     42  OG  SER A   5      17.092  88.968  32.147  1.00  0.00           O  
ATOM     43  H   SER A   5      18.841  90.885  33.573  1.00  0.00           H  
ATOM     44  HA  SER A   5      18.477  88.066  34.306  1.00  0.00           H  
ATOM     45  HB2 SER A   5      19.030  89.246  31.573  1.00  0.00           H  
ATOM     46  HB3 SER A   5      18.572  87.580  31.930  1.00  0.00           H  
ATOM     47  HG  SER A   5      17.013  89.924  32.102  1.00  0.00           H  
ATOM     48  N   SER A   6      20.846  87.342  34.260  1.00  0.00           N  
ATOM     49  CA  SER A   6      22.249  86.957  34.365  1.00  0.00           C  
ATOM     50  C   SER A   6      22.541  85.732  33.505  1.00  0.00           C  
ATOM     51  O   SER A   6      21.974  84.661  33.714  1.00  0.00           O  
ATOM     52  CB  SER A   6      22.611  86.666  35.824  1.00  0.00           C  
ATOM     53  OG  SER A   6      21.839  85.594  36.337  1.00  0.00           O  
ATOM     54  H   SER A   6      20.157  86.739  34.606  1.00  0.00           H  
ATOM     55  HA  SER A   6      22.847  87.782  34.013  1.00  0.00           H  
ATOM     56  HB2 SER A   6      23.656  86.404  35.887  1.00  0.00           H  
ATOM     57  HB3 SER A   6      22.423  87.547  36.420  1.00  0.00           H  
ATOM     58  HG  SER A   6      21.574  85.018  35.618  1.00  0.00           H  
ATOM     59  N   GLY A   7      23.434  85.900  32.532  1.00  0.00           N  
ATOM     60  CA  GLY A   7      23.787  84.801  31.652  1.00  0.00           C  
ATOM     61  C   GLY A   7      23.072  84.873  30.317  1.00  0.00           C  
ATOM     62  O   GLY A   7      22.163  85.684  30.135  1.00  0.00           O  
ATOM     63  H   GLY A   7      23.854  86.776  32.412  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      24.853  84.822  31.480  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      23.529  83.870  32.135  1.00  0.00           H  
ATOM     66  N   LYS A   8      23.483  84.026  29.381  1.00  0.00           N  
ATOM     67  CA  LYS A   8      22.877  83.997  28.056  1.00  0.00           C  
ATOM     68  C   LYS A   8      23.439  82.847  27.225  1.00  0.00           C  
ATOM     69  O   LYS A   8      24.625  82.526  27.312  1.00  0.00           O  
ATOM     70  CB  LYS A   8      23.115  85.325  27.333  1.00  0.00           C  
ATOM     71  CG  LYS A   8      22.083  85.627  26.260  1.00  0.00           C  
ATOM     72  CD  LYS A   8      22.449  86.871  25.470  1.00  0.00           C  
ATOM     73  CE  LYS A   8      21.647  86.970  24.182  1.00  0.00           C  
ATOM     74  NZ  LYS A   8      22.302  87.863  23.187  1.00  0.00           N  
ATOM     75  H   LYS A   8      24.213  83.404  29.587  1.00  0.00           H  
ATOM     76  HA  LYS A   8      21.815  83.848  28.180  1.00  0.00           H  
ATOM     77  HB2 LYS A   8      23.092  86.124  28.060  1.00  0.00           H  
ATOM     78  HB3 LYS A   8      24.090  85.299  26.869  1.00  0.00           H  
ATOM     79  HG2 LYS A   8      22.025  84.788  25.583  1.00  0.00           H  
ATOM     80  HG3 LYS A   8      21.122  85.779  26.730  1.00  0.00           H  
ATOM     81  HD2 LYS A   8      22.246  87.744  26.074  1.00  0.00           H  
ATOM     82  HD3 LYS A   8      23.502  86.836  25.226  1.00  0.00           H  
ATOM     83  HE2 LYS A   8      21.550  85.983  23.757  1.00  0.00           H  
ATOM     84  HE3 LYS A   8      20.667  87.360  24.413  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8      23.260  88.110  23.504  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8      21.750  88.737  23.072  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8      22.367  87.385  22.265  1.00  0.00           H  
ATOM     88  N   LYS A   9      22.581  82.231  26.419  1.00  0.00           N  
ATOM     89  CA  LYS A   9      22.993  81.119  25.570  1.00  0.00           C  
ATOM     90  C   LYS A   9      23.289  81.597  24.152  1.00  0.00           C  
ATOM     91  O   LYS A   9      22.678  82.540  23.649  1.00  0.00           O  
ATOM     92  CB  LYS A   9      21.903  80.044  25.540  1.00  0.00           C  
ATOM     93  CG  LYS A   9      21.879  79.168  26.781  1.00  0.00           C  
ATOM     94  CD  LYS A   9      22.870  78.022  26.675  1.00  0.00           C  
ATOM     95  CE  LYS A   9      22.926  77.213  27.962  1.00  0.00           C  
ATOM     96  NZ  LYS A   9      23.892  76.083  27.865  1.00  0.00           N  
ATOM     97  H   LYS A   9      21.649  82.532  26.393  1.00  0.00           H  
ATOM     98  HA  LYS A   9      23.893  80.696  25.990  1.00  0.00           H  
ATOM     99  HB2 LYS A   9      20.942  80.525  25.445  1.00  0.00           H  
ATOM    100  HB3 LYS A   9      22.066  79.409  24.681  1.00  0.00           H  
ATOM    101  HG2 LYS A   9      22.132  79.771  27.640  1.00  0.00           H  
ATOM    102  HG3 LYS A   9      20.884  78.763  26.904  1.00  0.00           H  
ATOM    103  HD2 LYS A   9      22.570  77.371  25.868  1.00  0.00           H  
ATOM    104  HD3 LYS A   9      23.851  78.424  26.469  1.00  0.00           H  
ATOM    105  HE2 LYS A   9      23.227  77.865  28.768  1.00  0.00           H  
ATOM    106  HE3 LYS A   9      21.942  76.818  28.167  1.00  0.00           H  
ATOM    107  HZ1 LYS A   9      24.630  76.302  27.167  1.00  0.00           H  
ATOM    108  HZ2 LYS A   9      23.398  75.216  27.573  1.00  0.00           H  
ATOM    109  HZ3 LYS A   9      24.341  75.917  28.788  1.00  0.00           H  
ATOM    110  N   PRO A  10      24.248  80.932  23.490  1.00  0.00           N  
ATOM    111  CA  PRO A  10      24.645  81.270  22.121  1.00  0.00           C  
ATOM    112  C   PRO A  10      23.565  80.924  21.102  1.00  0.00           C  
ATOM    113  O   PRO A  10      22.616  80.205  21.410  1.00  0.00           O  
ATOM    114  CB  PRO A  10      25.893  80.413  21.892  1.00  0.00           C  
ATOM    115  CG  PRO A  10      25.737  79.261  22.823  1.00  0.00           C  
ATOM    116  CD  PRO A  10      25.018  79.798  24.029  1.00  0.00           C  
ATOM    117  HA  PRO A  10      24.903  82.316  22.030  1.00  0.00           H  
ATOM    118  HB2 PRO A  10      25.924  80.088  20.861  1.00  0.00           H  
ATOM    119  HB3 PRO A  10      26.777  80.989  22.120  1.00  0.00           H  
ATOM    120  HG2 PRO A  10      25.152  78.484  22.352  1.00  0.00           H  
ATOM    121  HG3 PRO A  10      26.709  78.882  23.104  1.00  0.00           H  
ATOM    122  HD2 PRO A  10      24.361  79.047  24.442  1.00  0.00           H  
ATOM    123  HD3 PRO A  10      25.726  80.132  24.773  1.00  0.00           H  
ATOM    124  N   ALA A  11      23.719  81.440  19.886  1.00  0.00           N  
ATOM    125  CA  ALA A  11      22.757  81.183  18.821  1.00  0.00           C  
ATOM    126  C   ALA A  11      23.173  79.976  17.987  1.00  0.00           C  
ATOM    127  O   ALA A  11      24.349  79.613  17.945  1.00  0.00           O  
ATOM    128  CB  ALA A  11      22.608  82.412  17.937  1.00  0.00           C  
ATOM    129  H   ALA A  11      24.497  82.005  19.702  1.00  0.00           H  
ATOM    130  HA  ALA A  11      21.799  80.979  19.278  1.00  0.00           H  
ATOM    131  HB1 ALA A  11      23.517  82.991  17.970  1.00  0.00           H  
ATOM    132  HB2 ALA A  11      22.413  82.101  16.921  1.00  0.00           H  
ATOM    133  HB3 ALA A  11      21.784  83.013  18.294  1.00  0.00           H  
ATOM    134  N   CYS A  12      22.202  79.358  17.324  1.00  0.00           N  
ATOM    135  CA  CYS A  12      22.467  78.191  16.491  1.00  0.00           C  
ATOM    136  C   CYS A  12      23.086  78.602  15.159  1.00  0.00           C  
ATOM    137  O   CYS A  12      22.423  78.586  14.122  1.00  0.00           O  
ATOM    138  CB  CYS A  12      21.176  77.408  16.246  1.00  0.00           C  
ATOM    139  SG  CYS A  12      19.857  78.381  15.483  1.00  0.00           S  
ATOM    140  H   CYS A  12      21.284  79.693  17.397  1.00  0.00           H  
ATOM    141  HA  CYS A  12      23.165  77.559  17.018  1.00  0.00           H  
ATOM    142  HB2 CYS A  12      21.387  76.573  15.594  1.00  0.00           H  
ATOM    143  HB3 CYS A  12      20.806  77.035  17.189  1.00  0.00           H  
ATOM    144  HG  CYS A  12      18.707  78.003  16.019  1.00  0.00           H  
ATOM    145  N   LYS A  13      24.362  78.973  15.195  1.00  0.00           N  
ATOM    146  CA  LYS A  13      25.072  79.390  13.993  1.00  0.00           C  
ATOM    147  C   LYS A  13      24.735  78.477  12.818  1.00  0.00           C  
ATOM    148  O   LYS A  13      24.670  78.922  11.672  1.00  0.00           O  
ATOM    149  CB  LYS A  13      26.583  79.385  14.240  1.00  0.00           C  
ATOM    150  CG  LYS A  13      27.133  78.019  14.611  1.00  0.00           C  
ATOM    151  CD  LYS A  13      28.594  78.100  15.024  1.00  0.00           C  
ATOM    152  CE  LYS A  13      29.250  76.728  15.021  1.00  0.00           C  
ATOM    153  NZ  LYS A  13      29.787  76.373  13.678  1.00  0.00           N  
ATOM    154  H   LYS A  13      24.838  78.965  16.053  1.00  0.00           H  
ATOM    155  HA  LYS A  13      24.759  80.395  13.754  1.00  0.00           H  
ATOM    156  HB2 LYS A  13      27.083  79.721  13.344  1.00  0.00           H  
ATOM    157  HB3 LYS A  13      26.806  80.070  15.045  1.00  0.00           H  
ATOM    158  HG2 LYS A  13      26.559  77.620  15.433  1.00  0.00           H  
ATOM    159  HG3 LYS A  13      27.047  77.362  13.757  1.00  0.00           H  
ATOM    160  HD2 LYS A  13      29.120  78.740  14.332  1.00  0.00           H  
ATOM    161  HD3 LYS A  13      28.654  78.516  16.020  1.00  0.00           H  
ATOM    162  HE2 LYS A  13      30.062  76.730  15.734  1.00  0.00           H  
ATOM    163  HE3 LYS A  13      28.517  75.992  15.313  1.00  0.00           H  
ATOM    164  HZ1 LYS A  13      29.032  76.430  12.965  1.00  0.00           H  
ATOM    165  HZ2 LYS A  13      30.165  75.404  13.689  1.00  0.00           H  
ATOM    166  HZ3 LYS A  13      30.549  77.028  13.413  1.00  0.00           H  
ATOM    167  N   PHE A  14      24.523  77.198  13.110  1.00  0.00           N  
ATOM    168  CA  PHE A  14      24.192  76.223  12.079  1.00  0.00           C  
ATOM    169  C   PHE A  14      23.000  76.692  11.249  1.00  0.00           C  
ATOM    170  O   PHE A  14      22.382  77.711  11.552  1.00  0.00           O  
ATOM    171  CB  PHE A  14      23.885  74.863  12.711  1.00  0.00           C  
ATOM    172  CG  PHE A  14      25.108  74.138  13.193  1.00  0.00           C  
ATOM    173  CD1 PHE A  14      25.814  73.300  12.344  1.00  0.00           C  
ATOM    174  CD2 PHE A  14      25.552  74.292  14.497  1.00  0.00           C  
ATOM    175  CE1 PHE A  14      26.939  72.631  12.787  1.00  0.00           C  
ATOM    176  CE2 PHE A  14      26.676  73.626  14.945  1.00  0.00           C  
ATOM    177  CZ  PHE A  14      27.372  72.794  14.088  1.00  0.00           C  
ATOM    178  H   PHE A  14      24.590  76.904  14.043  1.00  0.00           H  
ATOM    179  HA  PHE A  14      25.050  76.123  11.430  1.00  0.00           H  
ATOM    180  HB2 PHE A  14      23.229  75.008  13.556  1.00  0.00           H  
ATOM    181  HB3 PHE A  14      23.393  74.239  11.980  1.00  0.00           H  
ATOM    182  HD1 PHE A  14      25.478  73.173  11.326  1.00  0.00           H  
ATOM    183  HD2 PHE A  14      25.009  74.943  15.168  1.00  0.00           H  
ATOM    184  HE1 PHE A  14      27.481  71.982  12.115  1.00  0.00           H  
ATOM    185  HE2 PHE A  14      27.012  73.755  15.963  1.00  0.00           H  
ATOM    186  HZ  PHE A  14      28.250  72.272  14.436  1.00  0.00           H  
ATOM    187  N   GLU A  15      22.684  75.939  10.200  1.00  0.00           N  
ATOM    188  CA  GLU A  15      21.567  76.277   9.326  1.00  0.00           C  
ATOM    189  C   GLU A  15      20.689  75.057   9.068  1.00  0.00           C  
ATOM    190  O   GLU A  15      21.174  73.928   9.022  1.00  0.00           O  
ATOM    191  CB  GLU A  15      22.082  76.839   7.998  1.00  0.00           C  
ATOM    192  CG  GLU A  15      20.975  77.260   7.047  1.00  0.00           C  
ATOM    193  CD  GLU A  15      20.533  76.136   6.131  1.00  0.00           C  
ATOM    194  OE1 GLU A  15      20.699  74.959   6.512  1.00  0.00           O  
ATOM    195  OE2 GLU A  15      20.020  76.434   5.031  1.00  0.00           O  
ATOM    196  H   GLU A  15      23.214  75.137  10.009  1.00  0.00           H  
ATOM    197  HA  GLU A  15      20.976  77.034   9.820  1.00  0.00           H  
ATOM    198  HB2 GLU A  15      22.702  77.699   8.201  1.00  0.00           H  
ATOM    199  HB3 GLU A  15      22.679  76.082   7.509  1.00  0.00           H  
ATOM    200  HG2 GLU A  15      20.125  77.588   7.625  1.00  0.00           H  
ATOM    201  HG3 GLU A  15      21.333  78.080   6.439  1.00  0.00           H  
ATOM    202  N   GLU A  16      19.390  75.294   8.900  1.00  0.00           N  
ATOM    203  CA  GLU A  16      18.444  74.214   8.648  1.00  0.00           C  
ATOM    204  C   GLU A  16      18.434  73.832   7.172  1.00  0.00           C  
ATOM    205  O   GLU A  16      18.159  74.661   6.306  1.00  0.00           O  
ATOM    206  CB  GLU A  16      17.037  74.627   9.089  1.00  0.00           C  
ATOM    207  CG  GLU A  16      16.837  74.595  10.595  1.00  0.00           C  
ATOM    208  CD  GLU A  16      15.444  75.029  11.008  1.00  0.00           C  
ATOM    209  OE1 GLU A  16      14.990  76.093  10.537  1.00  0.00           O  
ATOM    210  OE2 GLU A  16      14.808  74.304  11.801  1.00  0.00           O  
ATOM    211  H   GLU A  16      19.063  76.217   8.948  1.00  0.00           H  
ATOM    212  HA  GLU A  16      18.755  73.358   9.228  1.00  0.00           H  
ATOM    213  HB2 GLU A  16      16.845  75.630   8.742  1.00  0.00           H  
ATOM    214  HB3 GLU A  16      16.321  73.955   8.638  1.00  0.00           H  
ATOM    215  HG2 GLU A  16      17.002  73.587  10.946  1.00  0.00           H  
ATOM    216  HG3 GLU A  16      17.556  75.257  11.055  1.00  0.00           H  
ATOM    217  N   GLY A  17      18.739  72.568   6.891  1.00  0.00           N  
ATOM    218  CA  GLY A  17      18.761  72.097   5.519  1.00  0.00           C  
ATOM    219  C   GLY A  17      20.136  72.205   4.891  1.00  0.00           C  
ATOM    220  O   GLY A  17      20.272  72.151   3.669  1.00  0.00           O  
ATOM    221  H   GLY A  17      18.951  71.951   7.623  1.00  0.00           H  
ATOM    222  HA2 GLY A  17      18.448  71.064   5.499  1.00  0.00           H  
ATOM    223  HA3 GLY A  17      18.065  72.685   4.938  1.00  0.00           H  
ATOM    224  N   GLN A  18      21.157  72.362   5.727  1.00  0.00           N  
ATOM    225  CA  GLN A  18      22.528  72.482   5.246  1.00  0.00           C  
ATOM    226  C   GLN A  18      23.242  71.136   5.299  1.00  0.00           C  
ATOM    227  O   GLN A  18      23.326  70.508   6.355  1.00  0.00           O  
ATOM    228  CB  GLN A  18      23.295  73.513   6.076  1.00  0.00           C  
ATOM    229  CG  GLN A  18      24.781  73.559   5.765  1.00  0.00           C  
ATOM    230  CD  GLN A  18      25.448  74.817   6.288  1.00  0.00           C  
ATOM    231  OE1 GLN A  18      25.146  75.925   5.844  1.00  0.00           O  
ATOM    232  NE2 GLN A  18      26.361  74.652   7.238  1.00  0.00           N  
ATOM    233  H   GLN A  18      20.983  72.400   6.691  1.00  0.00           H  
ATOM    234  HA  GLN A  18      22.491  72.815   4.220  1.00  0.00           H  
ATOM    235  HB2 GLN A  18      22.878  74.491   5.887  1.00  0.00           H  
ATOM    236  HB3 GLN A  18      23.175  73.275   7.122  1.00  0.00           H  
ATOM    237  HG2 GLN A  18      25.259  72.703   6.218  1.00  0.00           H  
ATOM    238  HG3 GLN A  18      24.914  73.518   4.693  1.00  0.00           H  
ATOM    239 HE21 GLN A  18      26.553  73.739   7.542  1.00  0.00           H  
ATOM    240 HE22 GLN A  18      26.809  75.447   7.594  1.00  0.00           H  
ATOM    241  N   ASP A  19      23.756  70.699   4.154  1.00  0.00           N  
ATOM    242  CA  ASP A  19      24.464  69.427   4.070  1.00  0.00           C  
ATOM    243  C   ASP A  19      25.829  69.519   4.747  1.00  0.00           C  
ATOM    244  O   ASP A  19      26.663  70.346   4.378  1.00  0.00           O  
ATOM    245  CB  ASP A  19      24.633  69.008   2.610  1.00  0.00           C  
ATOM    246  CG  ASP A  19      23.433  69.375   1.760  1.00  0.00           C  
ATOM    247  OD1 ASP A  19      22.294  69.236   2.252  1.00  0.00           O  
ATOM    248  OD2 ASP A  19      23.632  69.799   0.602  1.00  0.00           O  
ATOM    249  H   ASP A  19      23.657  71.245   3.347  1.00  0.00           H  
ATOM    250  HA  ASP A  19      23.873  68.684   4.582  1.00  0.00           H  
ATOM    251  HB2 ASP A  19      25.504  69.499   2.199  1.00  0.00           H  
ATOM    252  HB3 ASP A  19      24.773  67.938   2.562  1.00  0.00           H  
ATOM    253  N   VAL A  20      26.050  68.665   5.742  1.00  0.00           N  
ATOM    254  CA  VAL A  20      27.313  68.649   6.470  1.00  0.00           C  
ATOM    255  C   VAL A  20      27.741  67.224   6.799  1.00  0.00           C  
ATOM    256  O   VAL A  20      27.000  66.270   6.557  1.00  0.00           O  
ATOM    257  CB  VAL A  20      27.216  69.459   7.777  1.00  0.00           C  
ATOM    258  CG1 VAL A  20      26.993  70.933   7.476  1.00  0.00           C  
ATOM    259  CG2 VAL A  20      26.106  68.912   8.661  1.00  0.00           C  
ATOM    260  H   VAL A  20      25.347  68.029   5.991  1.00  0.00           H  
ATOM    261  HA  VAL A  20      28.065  69.106   5.844  1.00  0.00           H  
ATOM    262  HB  VAL A  20      28.152  69.360   8.308  1.00  0.00           H  
ATOM    263 HG11 VAL A  20      27.046  71.096   6.410  1.00  0.00           H  
ATOM    264 HG12 VAL A  20      26.020  71.231   7.839  1.00  0.00           H  
ATOM    265 HG13 VAL A  20      27.755  71.520   7.967  1.00  0.00           H  
ATOM    266 HG21 VAL A  20      25.433  68.314   8.066  1.00  0.00           H  
ATOM    267 HG22 VAL A  20      26.535  68.302   9.442  1.00  0.00           H  
ATOM    268 HG23 VAL A  20      25.561  69.733   9.105  1.00  0.00           H  
ATOM    269  N   LEU A  21      28.940  67.085   7.352  1.00  0.00           N  
ATOM    270  CA  LEU A  21      29.468  65.774   7.715  1.00  0.00           C  
ATOM    271  C   LEU A  21      29.372  65.546   9.221  1.00  0.00           C  
ATOM    272  O   LEU A  21      30.038  66.221  10.005  1.00  0.00           O  
ATOM    273  CB  LEU A  21      30.923  65.645   7.260  1.00  0.00           C  
ATOM    274  CG  LEU A  21      31.139  65.394   5.768  1.00  0.00           C  
ATOM    275  CD1 LEU A  21      32.596  65.621   5.394  1.00  0.00           C  
ATOM    276  CD2 LEU A  21      30.705  63.983   5.396  1.00  0.00           C  
ATOM    277  H   LEU A  21      29.485  67.881   7.521  1.00  0.00           H  
ATOM    278  HA  LEU A  21      28.874  65.027   7.212  1.00  0.00           H  
ATOM    279  HB2 LEU A  21      31.433  66.559   7.520  1.00  0.00           H  
ATOM    280  HB3 LEU A  21      31.366  64.822   7.803  1.00  0.00           H  
ATOM    281  HG  LEU A  21      30.538  66.090   5.201  1.00  0.00           H  
ATOM    282 HD11 LEU A  21      33.032  66.340   6.070  1.00  0.00           H  
ATOM    283 HD12 LEU A  21      32.654  65.995   4.383  1.00  0.00           H  
ATOM    284 HD13 LEU A  21      33.135  64.688   5.464  1.00  0.00           H  
ATOM    285 HD21 LEU A  21      31.331  63.267   5.908  1.00  0.00           H  
ATOM    286 HD22 LEU A  21      30.801  63.848   4.328  1.00  0.00           H  
ATOM    287 HD23 LEU A  21      29.674  63.836   5.685  1.00  0.00           H  
ATOM    288  N   ALA A  22      28.538  64.590   9.617  1.00  0.00           N  
ATOM    289  CA  ALA A  22      28.358  64.271  11.028  1.00  0.00           C  
ATOM    290  C   ALA A  22      29.128  63.010  11.408  1.00  0.00           C  
ATOM    291  O   ALA A  22      29.232  62.073  10.617  1.00  0.00           O  
ATOM    292  CB  ALA A  22      26.879  64.105  11.346  1.00  0.00           C  
ATOM    293  H   ALA A  22      28.034  64.087   8.944  1.00  0.00           H  
ATOM    294  HA  ALA A  22      28.735  65.100  11.609  1.00  0.00           H  
ATOM    295  HB1 ALA A  22      26.442  65.072  11.541  1.00  0.00           H  
ATOM    296  HB2 ALA A  22      26.380  63.646  10.505  1.00  0.00           H  
ATOM    297  HB3 ALA A  22      26.768  63.477  12.218  1.00  0.00           H  
ATOM    298  N   ARG A  23      29.665  62.995  12.623  1.00  0.00           N  
ATOM    299  CA  ARG A  23      30.427  61.850  13.107  1.00  0.00           C  
ATOM    300  C   ARG A  23      29.520  60.859  13.831  1.00  0.00           C  
ATOM    301  O   ARG A  23      28.975  61.163  14.892  1.00  0.00           O  
ATOM    302  CB  ARG A  23      31.545  62.313  14.043  1.00  0.00           C  
ATOM    303  CG  ARG A  23      32.691  61.321  14.161  1.00  0.00           C  
ATOM    304  CD  ARG A  23      33.358  61.400  15.525  1.00  0.00           C  
ATOM    305  NE  ARG A  23      32.412  61.163  16.612  1.00  0.00           N  
ATOM    306  CZ  ARG A  23      32.745  61.200  17.898  1.00  0.00           C  
ATOM    307  NH1 ARG A  23      33.993  61.465  18.255  1.00  0.00           N  
ATOM    308  NH2 ARG A  23      31.827  60.973  18.828  1.00  0.00           N  
ATOM    309  H   ARG A  23      29.547  63.772  13.208  1.00  0.00           H  
ATOM    310  HA  ARG A  23      30.867  61.358  12.252  1.00  0.00           H  
ATOM    311  HB2 ARG A  23      31.943  63.247  13.676  1.00  0.00           H  
ATOM    312  HB3 ARG A  23      31.130  62.470  15.028  1.00  0.00           H  
ATOM    313  HG2 ARG A  23      32.306  60.322  14.018  1.00  0.00           H  
ATOM    314  HG3 ARG A  23      33.423  61.540  13.399  1.00  0.00           H  
ATOM    315  HD2 ARG A  23      34.139  60.657  15.573  1.00  0.00           H  
ATOM    316  HD3 ARG A  23      33.788  62.384  15.644  1.00  0.00           H  
ATOM    317  HE  ARG A  23      31.483  60.966  16.371  1.00  0.00           H  
ATOM    318 HH11 ARG A  23      34.687  61.637  17.556  1.00  0.00           H  
ATOM    319 HH12 ARG A  23      34.241  61.493  19.224  1.00  0.00           H  
ATOM    320 HH21 ARG A  23      30.884  60.773  18.563  1.00  0.00           H  
ATOM    321 HH22 ARG A  23      32.078  61.001  19.795  1.00  0.00           H  
ATOM    322  N   TRP A  24      29.363  59.675  13.250  1.00  0.00           N  
ATOM    323  CA  TRP A  24      28.521  58.641  13.839  1.00  0.00           C  
ATOM    324  C   TRP A  24      29.158  58.076  15.104  1.00  0.00           C  
ATOM    325  O   TRP A  24      30.305  58.389  15.426  1.00  0.00           O  
ATOM    326  CB  TRP A  24      28.278  57.517  12.831  1.00  0.00           C  
ATOM    327  CG  TRP A  24      27.018  57.694  12.038  1.00  0.00           C  
ATOM    328  CD1 TRP A  24      26.887  58.334  10.838  1.00  0.00           C  
ATOM    329  CD2 TRP A  24      25.711  57.226  12.389  1.00  0.00           C  
ATOM    330  NE1 TRP A  24      25.578  58.292  10.423  1.00  0.00           N  
ATOM    331  CE2 TRP A  24      24.837  57.618  11.356  1.00  0.00           C  
ATOM    332  CE3 TRP A  24      25.194  56.513  13.474  1.00  0.00           C  
ATOM    333  CZ2 TRP A  24      23.477  57.320  11.380  1.00  0.00           C  
ATOM    334  CZ3 TRP A  24      23.844  56.219  13.496  1.00  0.00           C  
ATOM    335  CH2 TRP A  24      22.998  56.621  12.455  1.00  0.00           C  
ATOM    336  H   TRP A  24      29.823  59.493  12.404  1.00  0.00           H  
ATOM    337  HA  TRP A  24      27.574  59.092  14.098  1.00  0.00           H  
ATOM    338  HB2 TRP A  24      29.104  57.477  12.138  1.00  0.00           H  
ATOM    339  HB3 TRP A  24      28.209  56.577  13.360  1.00  0.00           H  
ATOM    340  HD1 TRP A  24      27.702  58.801  10.307  1.00  0.00           H  
ATOM    341  HE1 TRP A  24      25.233  58.682   9.592  1.00  0.00           H  
ATOM    342  HE3 TRP A  24      25.831  56.194  14.287  1.00  0.00           H  
ATOM    343  HZ2 TRP A  24      22.811  57.623  10.584  1.00  0.00           H  
ATOM    344  HZ3 TRP A  24      23.427  55.669  14.328  1.00  0.00           H  
ATOM    345  HH2 TRP A  24      21.951  56.370  12.513  1.00  0.00           H  
ATOM    346  N   SER A  25      28.408  57.242  15.818  1.00  0.00           N  
ATOM    347  CA  SER A  25      28.900  56.636  17.050  1.00  0.00           C  
ATOM    348  C   SER A  25      30.197  55.872  16.800  1.00  0.00           C  
ATOM    349  O   SER A  25      31.048  55.768  17.682  1.00  0.00           O  
ATOM    350  CB  SER A  25      27.846  55.696  17.637  1.00  0.00           C  
ATOM    351  OG  SER A  25      26.941  56.400  18.468  1.00  0.00           O  
ATOM    352  H   SER A  25      27.502  57.031  15.509  1.00  0.00           H  
ATOM    353  HA  SER A  25      29.094  57.430  17.755  1.00  0.00           H  
ATOM    354  HB2 SER A  25      27.292  55.234  16.834  1.00  0.00           H  
ATOM    355  HB3 SER A  25      28.335  54.932  18.222  1.00  0.00           H  
ATOM    356  HG  SER A  25      27.300  56.456  19.357  1.00  0.00           H  
ATOM    357  N   ASP A  26      30.338  55.338  15.592  1.00  0.00           N  
ATOM    358  CA  ASP A  26      31.531  54.584  15.223  1.00  0.00           C  
ATOM    359  C   ASP A  26      32.775  55.463  15.300  1.00  0.00           C  
ATOM    360  O   ASP A  26      33.857  54.996  15.651  1.00  0.00           O  
ATOM    361  CB  ASP A  26      31.382  54.011  13.814  1.00  0.00           C  
ATOM    362  CG  ASP A  26      30.503  52.777  13.779  1.00  0.00           C  
ATOM    363  OD1 ASP A  26      30.425  52.076  14.810  1.00  0.00           O  
ATOM    364  OD2 ASP A  26      29.892  52.511  12.723  1.00  0.00           O  
ATOM    365  H   ASP A  26      29.623  55.456  14.931  1.00  0.00           H  
ATOM    366  HA  ASP A  26      31.637  53.770  15.924  1.00  0.00           H  
ATOM    367  HB2 ASP A  26      30.943  54.761  13.171  1.00  0.00           H  
ATOM    368  HB3 ASP A  26      32.359  53.746  13.435  1.00  0.00           H  
ATOM    369  N   GLY A  27      32.612  56.741  14.969  1.00  0.00           N  
ATOM    370  CA  GLY A  27      33.730  57.665  15.006  1.00  0.00           C  
ATOM    371  C   GLY A  27      34.040  58.256  13.645  1.00  0.00           C  
ATOM    372  O   GLY A  27      34.793  59.225  13.536  1.00  0.00           O  
ATOM    373  H   GLY A  27      31.726  57.058  14.697  1.00  0.00           H  
ATOM    374  HA2 GLY A  27      33.499  58.467  15.690  1.00  0.00           H  
ATOM    375  HA3 GLY A  27      34.604  57.141  15.364  1.00  0.00           H  
ATOM    376  N   LEU A  28      33.460  57.671  12.603  1.00  0.00           N  
ATOM    377  CA  LEU A  28      33.679  58.144  11.240  1.00  0.00           C  
ATOM    378  C   LEU A  28      32.656  59.212  10.864  1.00  0.00           C  
ATOM    379  O   LEU A  28      31.568  59.275  11.437  1.00  0.00           O  
ATOM    380  CB  LEU A  28      33.600  56.977  10.255  1.00  0.00           C  
ATOM    381  CG  LEU A  28      34.574  55.825  10.499  1.00  0.00           C  
ATOM    382  CD1 LEU A  28      34.137  54.585   9.736  1.00  0.00           C  
ATOM    383  CD2 LEU A  28      35.986  56.228  10.102  1.00  0.00           C  
ATOM    384  H   LEU A  28      32.870  56.903  12.752  1.00  0.00           H  
ATOM    385  HA  LEU A  28      34.666  58.578  11.195  1.00  0.00           H  
ATOM    386  HB2 LEU A  28      32.598  56.577  10.296  1.00  0.00           H  
ATOM    387  HB3 LEU A  28      33.788  57.368   9.264  1.00  0.00           H  
ATOM    388  HG  LEU A  28      34.578  55.584  11.554  1.00  0.00           H  
ATOM    389 HD11 LEU A  28      35.008  54.051   9.388  1.00  0.00           H  
ATOM    390 HD12 LEU A  28      33.532  54.877   8.891  1.00  0.00           H  
ATOM    391 HD13 LEU A  28      33.559  53.946  10.388  1.00  0.00           H  
ATOM    392 HD21 LEU A  28      36.697  55.735  10.748  1.00  0.00           H  
ATOM    393 HD22 LEU A  28      36.095  57.298  10.197  1.00  0.00           H  
ATOM    394 HD23 LEU A  28      36.169  55.938   9.077  1.00  0.00           H  
ATOM    395  N   PHE A  29      33.012  60.050   9.895  1.00  0.00           N  
ATOM    396  CA  PHE A  29      32.125  61.115   9.441  1.00  0.00           C  
ATOM    397  C   PHE A  29      31.320  60.670   8.224  1.00  0.00           C  
ATOM    398  O   PHE A  29      31.847  60.023   7.319  1.00  0.00           O  
ATOM    399  CB  PHE A  29      32.933  62.370   9.101  1.00  0.00           C  
ATOM    400  CG  PHE A  29      33.214  63.241  10.291  1.00  0.00           C  
ATOM    401  CD1 PHE A  29      34.271  62.956  11.141  1.00  0.00           C  
ATOM    402  CD2 PHE A  29      32.422  64.346  10.560  1.00  0.00           C  
ATOM    403  CE1 PHE A  29      34.532  63.756  12.238  1.00  0.00           C  
ATOM    404  CE2 PHE A  29      32.679  65.151  11.655  1.00  0.00           C  
ATOM    405  CZ  PHE A  29      33.735  64.856  12.494  1.00  0.00           C  
ATOM    406  H   PHE A  29      33.892  59.949   9.476  1.00  0.00           H  
ATOM    407  HA  PHE A  29      31.443  61.342  10.246  1.00  0.00           H  
ATOM    408  HB2 PHE A  29      33.879  62.075   8.675  1.00  0.00           H  
ATOM    409  HB3 PHE A  29      32.385  62.957   8.381  1.00  0.00           H  
ATOM    410  HD1 PHE A  29      34.895  62.098  10.941  1.00  0.00           H  
ATOM    411  HD2 PHE A  29      31.595  64.578   9.904  1.00  0.00           H  
ATOM    412  HE1 PHE A  29      35.359  63.524  12.892  1.00  0.00           H  
ATOM    413  HE2 PHE A  29      32.054  66.009  11.853  1.00  0.00           H  
ATOM    414  HZ  PHE A  29      33.937  65.482  13.349  1.00  0.00           H  
ATOM    415  N   TYR A  30      30.038  61.020   8.210  1.00  0.00           N  
ATOM    416  CA  TYR A  30      29.158  60.654   7.107  1.00  0.00           C  
ATOM    417  C   TYR A  30      28.410  61.875   6.579  1.00  0.00           C  
ATOM    418  O   TYR A  30      28.294  62.892   7.266  1.00  0.00           O  
ATOM    419  CB  TYR A  30      28.160  59.585   7.555  1.00  0.00           C  
ATOM    420  CG  TYR A  30      28.786  58.226   7.769  1.00  0.00           C  
ATOM    421  CD1 TYR A  30      29.496  57.940   8.929  1.00  0.00           C  
ATOM    422  CD2 TYR A  30      28.667  57.225   6.811  1.00  0.00           C  
ATOM    423  CE1 TYR A  30      30.070  56.700   9.129  1.00  0.00           C  
ATOM    424  CE2 TYR A  30      29.236  55.982   7.003  1.00  0.00           C  
ATOM    425  CZ  TYR A  30      29.937  55.724   8.162  1.00  0.00           C  
ATOM    426  OH  TYR A  30      30.506  54.486   8.357  1.00  0.00           O  
ATOM    427  H   TYR A  30      29.675  61.535   8.960  1.00  0.00           H  
ATOM    428  HA  TYR A  30      29.771  60.251   6.313  1.00  0.00           H  
ATOM    429  HB2 TYR A  30      27.708  59.892   8.486  1.00  0.00           H  
ATOM    430  HB3 TYR A  30      27.392  59.483   6.804  1.00  0.00           H  
ATOM    431  HD1 TYR A  30      29.598  58.707   9.683  1.00  0.00           H  
ATOM    432  HD2 TYR A  30      28.119  57.432   5.904  1.00  0.00           H  
ATOM    433  HE1 TYR A  30      30.618  56.497  10.036  1.00  0.00           H  
ATOM    434  HE2 TYR A  30      29.133  55.218   6.246  1.00  0.00           H  
ATOM    435  HH  TYR A  30      31.296  54.409   7.816  1.00  0.00           H  
ATOM    436  N   LEU A  31      27.903  61.768   5.357  1.00  0.00           N  
ATOM    437  CA  LEU A  31      27.164  62.862   4.735  1.00  0.00           C  
ATOM    438  C   LEU A  31      25.735  62.921   5.263  1.00  0.00           C  
ATOM    439  O   LEU A  31      25.063  61.897   5.383  1.00  0.00           O  
ATOM    440  CB  LEU A  31      27.152  62.696   3.214  1.00  0.00           C  
ATOM    441  CG  LEU A  31      26.705  63.917   2.410  1.00  0.00           C  
ATOM    442  CD1 LEU A  31      26.954  63.698   0.926  1.00  0.00           C  
ATOM    443  CD2 LEU A  31      25.235  64.216   2.668  1.00  0.00           C  
ATOM    444  H   LEU A  31      28.028  60.933   4.858  1.00  0.00           H  
ATOM    445  HA  LEU A  31      27.666  63.784   4.985  1.00  0.00           H  
ATOM    446  HB2 LEU A  31      28.153  62.443   2.901  1.00  0.00           H  
ATOM    447  HB3 LEU A  31      26.485  61.879   2.976  1.00  0.00           H  
ATOM    448  HG  LEU A  31      27.282  64.777   2.722  1.00  0.00           H  
ATOM    449 HD11 LEU A  31      26.580  62.727   0.637  1.00  0.00           H  
ATOM    450 HD12 LEU A  31      28.014  63.750   0.727  1.00  0.00           H  
ATOM    451 HD13 LEU A  31      26.445  64.465   0.359  1.00  0.00           H  
ATOM    452 HD21 LEU A  31      24.756  64.491   1.740  1.00  0.00           H  
ATOM    453 HD22 LEU A  31      25.153  65.031   3.371  1.00  0.00           H  
ATOM    454 HD23 LEU A  31      24.755  63.338   3.076  1.00  0.00           H  
ATOM    455  N   GLY A  32      25.274  64.129   5.574  1.00  0.00           N  
ATOM    456  CA  GLY A  32      23.926  64.301   6.083  1.00  0.00           C  
ATOM    457  C   GLY A  32      23.424  65.723   5.927  1.00  0.00           C  
ATOM    458  O   GLY A  32      24.203  66.639   5.661  1.00  0.00           O  
ATOM    459  H   GLY A  32      25.855  64.911   5.457  1.00  0.00           H  
ATOM    460  HA2 GLY A  32      23.264  63.636   5.549  1.00  0.00           H  
ATOM    461  HA3 GLY A  32      23.913  64.041   7.131  1.00  0.00           H  
ATOM    462  N   THR A  33      22.119  65.909   6.093  1.00  0.00           N  
ATOM    463  CA  THR A  33      21.513  67.229   5.967  1.00  0.00           C  
ATOM    464  C   THR A  33      20.912  67.688   7.290  1.00  0.00           C  
ATOM    465  O   THR A  33      20.168  66.946   7.934  1.00  0.00           O  
ATOM    466  CB  THR A  33      20.416  67.242   4.885  1.00  0.00           C  
ATOM    467  OG1 THR A  33      20.983  66.931   3.608  1.00  0.00           O  
ATOM    468  CG2 THR A  33      19.732  68.600   4.825  1.00  0.00           C  
ATOM    469  H   THR A  33      21.550  65.140   6.304  1.00  0.00           H  
ATOM    470  HA  THR A  33      22.286  67.925   5.673  1.00  0.00           H  
ATOM    471  HB  THR A  33      19.677  66.495   5.135  1.00  0.00           H  
ATOM    472  HG1 THR A  33      21.764  67.471   3.464  1.00  0.00           H  
ATOM    473 HG21 THR A  33      18.932  68.568   4.101  1.00  0.00           H  
ATOM    474 HG22 THR A  33      20.451  69.352   4.534  1.00  0.00           H  
ATOM    475 HG23 THR A  33      19.329  68.844   5.796  1.00  0.00           H  
ATOM    476  N   ILE A  34      21.236  68.912   7.690  1.00  0.00           N  
ATOM    477  CA  ILE A  34      20.726  69.469   8.936  1.00  0.00           C  
ATOM    478  C   ILE A  34      19.209  69.618   8.892  1.00  0.00           C  
ATOM    479  O   ILE A  34      18.659  70.208   7.961  1.00  0.00           O  
ATOM    480  CB  ILE A  34      21.358  70.841   9.240  1.00  0.00           C  
ATOM    481  CG1 ILE A  34      22.870  70.701   9.424  1.00  0.00           C  
ATOM    482  CG2 ILE A  34      20.721  71.453  10.479  1.00  0.00           C  
ATOM    483  CD1 ILE A  34      23.574  72.020   9.655  1.00  0.00           C  
ATOM    484  H   ILE A  34      21.832  69.454   7.133  1.00  0.00           H  
ATOM    485  HA  ILE A  34      20.987  68.790   9.736  1.00  0.00           H  
ATOM    486  HB  ILE A  34      21.163  71.495   8.404  1.00  0.00           H  
ATOM    487 HG12 ILE A  34      23.065  70.068  10.275  1.00  0.00           H  
ATOM    488 HG13 ILE A  34      23.292  70.248   8.539  1.00  0.00           H  
ATOM    489 HG21 ILE A  34      21.210  72.388  10.710  1.00  0.00           H  
ATOM    490 HG22 ILE A  34      19.673  71.632  10.294  1.00  0.00           H  
ATOM    491 HG23 ILE A  34      20.830  70.776  11.313  1.00  0.00           H  
ATOM    492 HD11 ILE A  34      23.574  72.248  10.711  1.00  0.00           H  
ATOM    493 HD12 ILE A  34      24.594  71.950   9.303  1.00  0.00           H  
ATOM    494 HD13 ILE A  34      23.060  72.802   9.118  1.00  0.00           H  
ATOM    495  N   LYS A  35      18.537  69.083   9.904  1.00  0.00           N  
ATOM    496  CA  LYS A  35      17.083  69.158   9.984  1.00  0.00           C  
ATOM    497  C   LYS A  35      16.646  69.970  11.199  1.00  0.00           C  
ATOM    498  O   LYS A  35      15.671  70.719  11.141  1.00  0.00           O  
ATOM    499  CB  LYS A  35      16.482  67.752  10.053  1.00  0.00           C  
ATOM    500  CG  LYS A  35      17.146  66.760   9.114  1.00  0.00           C  
ATOM    501  CD  LYS A  35      16.461  66.728   7.759  1.00  0.00           C  
ATOM    502  CE  LYS A  35      17.019  67.793   6.826  1.00  0.00           C  
ATOM    503  NZ  LYS A  35      16.105  68.064   5.683  1.00  0.00           N  
ATOM    504  H   LYS A  35      19.032  68.626  10.617  1.00  0.00           H  
ATOM    505  HA  LYS A  35      16.727  69.649   9.091  1.00  0.00           H  
ATOM    506  HB2 LYS A  35      16.579  67.381  11.062  1.00  0.00           H  
ATOM    507  HB3 LYS A  35      15.434  67.810   9.798  1.00  0.00           H  
ATOM    508  HG2 LYS A  35      18.179  67.044   8.977  1.00  0.00           H  
ATOM    509  HG3 LYS A  35      17.098  65.774   9.555  1.00  0.00           H  
ATOM    510  HD2 LYS A  35      16.611  65.758   7.311  1.00  0.00           H  
ATOM    511  HD3 LYS A  35      15.403  66.903   7.896  1.00  0.00           H  
ATOM    512  HE2 LYS A  35      17.161  68.705   7.387  1.00  0.00           H  
ATOM    513  HE3 LYS A  35      17.971  67.453   6.444  1.00  0.00           H  
ATOM    514  HZ1 LYS A  35      15.189  68.410   6.032  1.00  0.00           H  
ATOM    515  HZ2 LYS A  35      15.950  67.193   5.136  1.00  0.00           H  
ATOM    516  HZ3 LYS A  35      16.521  68.783   5.057  1.00  0.00           H  
ATOM    517  N   LYS A  36      17.376  69.817  12.300  1.00  0.00           N  
ATOM    518  CA  LYS A  36      17.065  70.537  13.529  1.00  0.00           C  
ATOM    519  C   LYS A  36      18.342  70.948  14.256  1.00  0.00           C  
ATOM    520  O   LYS A  36      19.411  70.382  14.021  1.00  0.00           O  
ATOM    521  CB  LYS A  36      16.199  69.673  14.447  1.00  0.00           C  
ATOM    522  CG  LYS A  36      14.708  69.833  14.206  1.00  0.00           C  
ATOM    523  CD  LYS A  36      13.898  69.405  15.419  1.00  0.00           C  
ATOM    524  CE  LYS A  36      13.641  67.907  15.416  1.00  0.00           C  
ATOM    525  NZ  LYS A  36      12.421  67.551  16.192  1.00  0.00           N  
ATOM    526  H   LYS A  36      18.142  69.206  12.285  1.00  0.00           H  
ATOM    527  HA  LYS A  36      16.515  71.427  13.263  1.00  0.00           H  
ATOM    528  HB2 LYS A  36      16.457  68.636  14.293  1.00  0.00           H  
ATOM    529  HB3 LYS A  36      16.406  69.938  15.474  1.00  0.00           H  
ATOM    530  HG2 LYS A  36      14.497  70.871  13.994  1.00  0.00           H  
ATOM    531  HG3 LYS A  36      14.422  69.225  13.359  1.00  0.00           H  
ATOM    532  HD2 LYS A  36      14.442  69.665  16.314  1.00  0.00           H  
ATOM    533  HD3 LYS A  36      12.950  69.924  15.408  1.00  0.00           H  
ATOM    534  HE2 LYS A  36      13.517  67.577  14.396  1.00  0.00           H  
ATOM    535  HE3 LYS A  36      14.493  67.408  15.854  1.00  0.00           H  
ATOM    536  HZ1 LYS A  36      11.725  67.090  15.572  1.00  0.00           H  
ATOM    537  HZ2 LYS A  36      11.993  68.409  16.598  1.00  0.00           H  
ATOM    538  HZ3 LYS A  36      12.665  66.900  16.965  1.00  0.00           H  
ATOM    539  N   ILE A  37      18.224  71.933  15.140  1.00  0.00           N  
ATOM    540  CA  ILE A  37      19.369  72.416  15.902  1.00  0.00           C  
ATOM    541  C   ILE A  37      18.996  72.654  17.361  1.00  0.00           C  
ATOM    542  O   ILE A  37      18.278  73.600  17.683  1.00  0.00           O  
ATOM    543  CB  ILE A  37      19.930  73.721  15.308  1.00  0.00           C  
ATOM    544  CG1 ILE A  37      20.320  73.514  13.843  1.00  0.00           C  
ATOM    545  CG2 ILE A  37      21.126  74.199  16.117  1.00  0.00           C  
ATOM    546  CD1 ILE A  37      20.397  74.801  13.051  1.00  0.00           C  
ATOM    547  H   ILE A  37      17.346  72.344  15.283  1.00  0.00           H  
ATOM    548  HA  ILE A  37      20.141  71.662  15.857  1.00  0.00           H  
ATOM    549  HB  ILE A  37      19.161  74.477  15.366  1.00  0.00           H  
ATOM    550 HG12 ILE A  37      21.286  73.037  13.798  1.00  0.00           H  
ATOM    551 HG13 ILE A  37      19.585  72.877  13.370  1.00  0.00           H  
ATOM    552 HG21 ILE A  37      20.808  74.960  16.815  1.00  0.00           H  
ATOM    553 HG22 ILE A  37      21.549  73.368  16.660  1.00  0.00           H  
ATOM    554 HG23 ILE A  37      21.870  74.612  15.451  1.00  0.00           H  
ATOM    555 HD11 ILE A  37      21.415  74.958  12.719  1.00  0.00           H  
ATOM    556 HD12 ILE A  37      19.746  74.736  12.192  1.00  0.00           H  
ATOM    557 HD13 ILE A  37      20.093  75.627  13.675  1.00  0.00           H  
ATOM    558  N   ASN A  38      19.491  71.789  18.242  1.00  0.00           N  
ATOM    559  CA  ASN A  38      19.212  71.907  19.668  1.00  0.00           C  
ATOM    560  C   ASN A  38      20.376  72.569  20.399  1.00  0.00           C  
ATOM    561  O   ASN A  38      21.486  72.037  20.428  1.00  0.00           O  
ATOM    562  CB  ASN A  38      18.936  70.527  20.270  1.00  0.00           C  
ATOM    563  CG  ASN A  38      18.633  70.593  21.754  1.00  0.00           C  
ATOM    564  OD1 ASN A  38      18.953  71.578  22.421  1.00  0.00           O  
ATOM    565  ND2 ASN A  38      18.012  69.543  22.279  1.00  0.00           N  
ATOM    566  H   ASN A  38      20.058  71.056  17.924  1.00  0.00           H  
ATOM    567  HA  ASN A  38      18.332  72.522  19.784  1.00  0.00           H  
ATOM    568  HB2 ASN A  38      18.087  70.086  19.768  1.00  0.00           H  
ATOM    569  HB3 ASN A  38      19.801  69.898  20.125  1.00  0.00           H  
ATOM    570 HD21 ASN A  38      17.788  68.795  21.687  1.00  0.00           H  
ATOM    571 HD22 ASN A  38      17.804  69.560  23.236  1.00  0.00           H  
ATOM    572  N   ILE A  39      20.115  73.732  20.986  1.00  0.00           N  
ATOM    573  CA  ILE A  39      21.140  74.465  21.718  1.00  0.00           C  
ATOM    574  C   ILE A  39      21.305  73.916  23.131  1.00  0.00           C  
ATOM    575  O   ILE A  39      22.411  73.884  23.670  1.00  0.00           O  
ATOM    576  CB  ILE A  39      20.809  75.966  21.797  1.00  0.00           C  
ATOM    577  CG1 ILE A  39      20.341  76.481  20.434  1.00  0.00           C  
ATOM    578  CG2 ILE A  39      22.021  76.751  22.277  1.00  0.00           C  
ATOM    579  CD1 ILE A  39      19.962  77.946  20.439  1.00  0.00           C  
ATOM    580  H   ILE A  39      19.210  74.104  20.927  1.00  0.00           H  
ATOM    581  HA  ILE A  39      22.074  74.350  21.187  1.00  0.00           H  
ATOM    582  HB  ILE A  39      20.015  76.101  22.516  1.00  0.00           H  
ATOM    583 HG12 ILE A  39      21.132  76.346  19.714  1.00  0.00           H  
ATOM    584 HG13 ILE A  39      19.476  75.914  20.122  1.00  0.00           H  
ATOM    585 HG21 ILE A  39      21.872  77.049  23.305  1.00  0.00           H  
ATOM    586 HG22 ILE A  39      22.901  76.131  22.206  1.00  0.00           H  
ATOM    587 HG23 ILE A  39      22.148  77.630  21.663  1.00  0.00           H  
ATOM    588 HD11 ILE A  39      20.421  78.438  19.593  1.00  0.00           H  
ATOM    589 HD12 ILE A  39      18.888  78.040  20.369  1.00  0.00           H  
ATOM    590 HD13 ILE A  39      20.307  78.404  21.353  1.00  0.00           H  
ATOM    591  N   LEU A  40      20.199  73.485  23.726  1.00  0.00           N  
ATOM    592  CA  LEU A  40      20.220  72.935  25.076  1.00  0.00           C  
ATOM    593  C   LEU A  40      21.119  71.705  25.150  1.00  0.00           C  
ATOM    594  O   LEU A  40      21.902  71.550  26.087  1.00  0.00           O  
ATOM    595  CB  LEU A  40      18.803  72.573  25.524  1.00  0.00           C  
ATOM    596  CG  LEU A  40      17.692  73.519  25.066  1.00  0.00           C  
ATOM    597  CD1 LEU A  40      16.373  73.154  25.728  1.00  0.00           C  
ATOM    598  CD2 LEU A  40      18.062  74.963  25.370  1.00  0.00           C  
ATOM    599  H   LEU A  40      19.346  73.537  23.245  1.00  0.00           H  
ATOM    600  HA  LEU A  40      20.613  73.694  25.736  1.00  0.00           H  
ATOM    601  HB2 LEU A  40      18.577  71.589  25.142  1.00  0.00           H  
ATOM    602  HB3 LEU A  40      18.793  72.549  26.605  1.00  0.00           H  
ATOM    603  HG  LEU A  40      17.565  73.423  23.996  1.00  0.00           H  
ATOM    604 HD11 LEU A  40      15.724  72.682  25.005  1.00  0.00           H  
ATOM    605 HD12 LEU A  40      15.899  74.048  26.107  1.00  0.00           H  
ATOM    606 HD13 LEU A  40      16.557  72.471  26.546  1.00  0.00           H  
ATOM    607 HD21 LEU A  40      18.587  75.386  24.526  1.00  0.00           H  
ATOM    608 HD22 LEU A  40      18.697  74.995  26.242  1.00  0.00           H  
ATOM    609 HD23 LEU A  40      17.163  75.533  25.558  1.00  0.00           H  
ATOM    610  N   LYS A  41      21.002  70.834  24.154  1.00  0.00           N  
ATOM    611  CA  LYS A  41      21.805  69.618  24.102  1.00  0.00           C  
ATOM    612  C   LYS A  41      23.019  69.807  23.197  1.00  0.00           C  
ATOM    613  O   LYS A  41      23.865  68.920  23.088  1.00  0.00           O  
ATOM    614  CB  LYS A  41      20.960  68.444  23.603  1.00  0.00           C  
ATOM    615  CG  LYS A  41      19.925  67.968  24.608  1.00  0.00           C  
ATOM    616  CD  LYS A  41      19.517  66.528  24.350  1.00  0.00           C  
ATOM    617  CE  LYS A  41      18.639  66.411  23.114  1.00  0.00           C  
ATOM    618  NZ  LYS A  41      18.311  64.992  22.799  1.00  0.00           N  
ATOM    619  H   LYS A  41      20.359  71.012  23.436  1.00  0.00           H  
ATOM    620  HA  LYS A  41      22.148  69.404  25.104  1.00  0.00           H  
ATOM    621  HB2 LYS A  41      20.446  68.744  22.702  1.00  0.00           H  
ATOM    622  HB3 LYS A  41      21.616  67.616  23.374  1.00  0.00           H  
ATOM    623  HG2 LYS A  41      20.341  68.041  25.602  1.00  0.00           H  
ATOM    624  HG3 LYS A  41      19.051  68.600  24.535  1.00  0.00           H  
ATOM    625  HD2 LYS A  41      20.406  65.932  24.203  1.00  0.00           H  
ATOM    626  HD3 LYS A  41      18.971  66.158  25.206  1.00  0.00           H  
ATOM    627  HE2 LYS A  41      17.722  66.953  23.287  1.00  0.00           H  
ATOM    628  HE3 LYS A  41      19.161  66.845  22.274  1.00  0.00           H  
ATOM    629  HZ1 LYS A  41      19.028  64.592  22.161  1.00  0.00           H  
ATOM    630  HZ2 LYS A  41      17.381  64.936  22.337  1.00  0.00           H  
ATOM    631  HZ3 LYS A  41      18.286  64.429  23.673  1.00  0.00           H  
ATOM    632  N   GLN A  42      23.095  70.966  22.551  1.00  0.00           N  
ATOM    633  CA  GLN A  42      24.206  71.269  21.656  1.00  0.00           C  
ATOM    634  C   GLN A  42      24.325  70.215  20.561  1.00  0.00           C  
ATOM    635  O   GLN A  42      25.423  69.765  20.236  1.00  0.00           O  
ATOM    636  CB  GLN A  42      25.515  71.352  22.444  1.00  0.00           C  
ATOM    637  CG  GLN A  42      25.441  72.273  23.652  1.00  0.00           C  
ATOM    638  CD  GLN A  42      26.770  72.405  24.368  1.00  0.00           C  
ATOM    639  OE1 GLN A  42      27.473  71.416  24.582  1.00  0.00           O  
ATOM    640  NE2 GLN A  42      27.122  73.629  24.743  1.00  0.00           N  
ATOM    641  H   GLN A  42      22.389  71.631  22.680  1.00  0.00           H  
ATOM    642  HA  GLN A  42      24.010  72.227  21.198  1.00  0.00           H  
ATOM    643  HB2 GLN A  42      25.779  70.363  22.788  1.00  0.00           H  
ATOM    644  HB3 GLN A  42      26.292  71.716  21.788  1.00  0.00           H  
ATOM    645  HG2 GLN A  42      25.128  73.253  23.323  1.00  0.00           H  
ATOM    646  HG3 GLN A  42      24.712  71.878  24.345  1.00  0.00           H  
ATOM    647 HE21 GLN A  42      26.511  74.368  24.540  1.00  0.00           H  
ATOM    648 HE22 GLN A  42      27.976  73.742  25.209  1.00  0.00           H  
ATOM    649  N   SER A  43      23.187  69.827  19.993  1.00  0.00           N  
ATOM    650  CA  SER A  43      23.164  68.823  18.937  1.00  0.00           C  
ATOM    651  C   SER A  43      22.358  69.316  17.738  1.00  0.00           C  
ATOM    652  O   SER A  43      21.817  70.422  17.752  1.00  0.00           O  
ATOM    653  CB  SER A  43      22.571  67.513  19.460  1.00  0.00           C  
ATOM    654  OG  SER A  43      21.357  67.745  20.154  1.00  0.00           O  
ATOM    655  H   SER A  43      22.343  70.224  20.296  1.00  0.00           H  
ATOM    656  HA  SER A  43      24.181  68.648  18.623  1.00  0.00           H  
ATOM    657  HB2 SER A  43      22.377  66.852  18.630  1.00  0.00           H  
ATOM    658  HB3 SER A  43      23.275  67.048  20.136  1.00  0.00           H  
ATOM    659  HG  SER A  43      21.324  67.189  20.936  1.00  0.00           H  
ATOM    660  N   CYS A  44      22.282  68.486  16.703  1.00  0.00           N  
ATOM    661  CA  CYS A  44      21.544  68.836  15.495  1.00  0.00           C  
ATOM    662  C   CYS A  44      21.014  67.586  14.801  1.00  0.00           C  
ATOM    663  O   CYS A  44      21.763  66.646  14.534  1.00  0.00           O  
ATOM    664  CB  CYS A  44      22.437  69.626  14.538  1.00  0.00           C  
ATOM    665  SG  CYS A  44      23.317  71.002  15.314  1.00  0.00           S  
ATOM    666  H   CYS A  44      22.735  67.618  16.752  1.00  0.00           H  
ATOM    667  HA  CYS A  44      20.707  69.453  15.786  1.00  0.00           H  
ATOM    668  HB2 CYS A  44      23.175  68.962  14.114  1.00  0.00           H  
ATOM    669  HB3 CYS A  44      21.829  70.030  13.741  1.00  0.00           H  
ATOM    670  HG  CYS A  44      23.778  71.787  14.352  1.00  0.00           H  
ATOM    671  N   PHE A  45      19.717  67.581  14.512  1.00  0.00           N  
ATOM    672  CA  PHE A  45      19.085  66.445  13.851  1.00  0.00           C  
ATOM    673  C   PHE A  45      19.410  66.434  12.360  1.00  0.00           C  
ATOM    674  O   PHE A  45      18.766  67.122  11.568  1.00  0.00           O  
ATOM    675  CB  PHE A  45      17.569  66.488  14.053  1.00  0.00           C  
ATOM    676  CG  PHE A  45      16.928  65.130  14.074  1.00  0.00           C  
ATOM    677  CD1 PHE A  45      17.477  64.102  14.825  1.00  0.00           C  
ATOM    678  CD2 PHE A  45      15.777  64.881  13.346  1.00  0.00           C  
ATOM    679  CE1 PHE A  45      16.889  62.852  14.846  1.00  0.00           C  
ATOM    680  CE2 PHE A  45      15.184  63.632  13.363  1.00  0.00           C  
ATOM    681  CZ  PHE A  45      15.741  62.617  14.116  1.00  0.00           C  
ATOM    682  H   PHE A  45      19.171  68.360  14.750  1.00  0.00           H  
ATOM    683  HA  PHE A  45      19.474  65.544  14.299  1.00  0.00           H  
ATOM    684  HB2 PHE A  45      17.352  66.971  14.994  1.00  0.00           H  
ATOM    685  HB3 PHE A  45      17.122  67.055  13.250  1.00  0.00           H  
ATOM    686  HD1 PHE A  45      18.373  64.285  15.399  1.00  0.00           H  
ATOM    687  HD2 PHE A  45      15.341  65.676  12.756  1.00  0.00           H  
ATOM    688  HE1 PHE A  45      17.325  62.060  15.435  1.00  0.00           H  
ATOM    689  HE2 PHE A  45      14.287  63.452  12.790  1.00  0.00           H  
ATOM    690  HZ  PHE A  45      15.280  61.640  14.130  1.00  0.00           H  
ATOM    691  N   ILE A  46      20.414  65.647  11.986  1.00  0.00           N  
ATOM    692  CA  ILE A  46      20.824  65.545  10.591  1.00  0.00           C  
ATOM    693  C   ILE A  46      20.422  64.200   9.996  1.00  0.00           C  
ATOM    694  O   ILE A  46      20.434  63.178  10.682  1.00  0.00           O  
ATOM    695  CB  ILE A  46      22.346  65.727  10.437  1.00  0.00           C  
ATOM    696  CG1 ILE A  46      22.745  67.167  10.760  1.00  0.00           C  
ATOM    697  CG2 ILE A  46      22.785  65.353   9.029  1.00  0.00           C  
ATOM    698  CD1 ILE A  46      24.143  67.297  11.320  1.00  0.00           C  
ATOM    699  H   ILE A  46      20.888  65.123  12.663  1.00  0.00           H  
ATOM    700  HA  ILE A  46      20.331  66.332  10.040  1.00  0.00           H  
ATOM    701  HB  ILE A  46      22.838  65.061  11.130  1.00  0.00           H  
ATOM    702 HG12 ILE A  46      22.693  67.760   9.860  1.00  0.00           H  
ATOM    703 HG13 ILE A  46      22.056  67.569  11.489  1.00  0.00           H  
ATOM    704 HG21 ILE A  46      21.940  65.424   8.358  1.00  0.00           H  
ATOM    705 HG22 ILE A  46      23.560  66.030   8.702  1.00  0.00           H  
ATOM    706 HG23 ILE A  46      23.163  64.343   9.026  1.00  0.00           H  
ATOM    707 HD11 ILE A  46      24.226  68.221  11.876  1.00  0.00           H  
ATOM    708 HD12 ILE A  46      24.347  66.464  11.977  1.00  0.00           H  
ATOM    709 HD13 ILE A  46      24.858  67.301  10.511  1.00  0.00           H  
ATOM    710  N   ILE A  47      20.066  64.208   8.716  1.00  0.00           N  
ATOM    711  CA  ILE A  47      19.663  62.988   8.027  1.00  0.00           C  
ATOM    712  C   ILE A  47      20.754  62.507   7.077  1.00  0.00           C  
ATOM    713  O   ILE A  47      21.035  63.146   6.064  1.00  0.00           O  
ATOM    714  CB  ILE A  47      18.359  63.194   7.233  1.00  0.00           C  
ATOM    715  CG1 ILE A  47      17.146  62.984   8.139  1.00  0.00           C  
ATOM    716  CG2 ILE A  47      18.310  62.248   6.043  1.00  0.00           C  
ATOM    717  CD1 ILE A  47      15.850  63.485   7.541  1.00  0.00           C  
ATOM    718  H   ILE A  47      20.077  65.054   8.222  1.00  0.00           H  
ATOM    719  HA  ILE A  47      19.489  62.227   8.775  1.00  0.00           H  
ATOM    720  HB  ILE A  47      18.349  64.207   6.859  1.00  0.00           H  
ATOM    721 HG12 ILE A  47      17.031  61.930   8.340  1.00  0.00           H  
ATOM    722 HG13 ILE A  47      17.305  63.507   9.071  1.00  0.00           H  
ATOM    723 HG21 ILE A  47      18.828  61.333   6.289  1.00  0.00           H  
ATOM    724 HG22 ILE A  47      17.281  62.026   5.804  1.00  0.00           H  
ATOM    725 HG23 ILE A  47      18.785  62.713   5.192  1.00  0.00           H  
ATOM    726 HD11 ILE A  47      15.485  64.321   8.121  1.00  0.00           H  
ATOM    727 HD12 ILE A  47      16.023  63.804   6.524  1.00  0.00           H  
ATOM    728 HD13 ILE A  47      15.116  62.693   7.552  1.00  0.00           H  
ATOM    729  N   PHE A  48      21.363  61.374   7.411  1.00  0.00           N  
ATOM    730  CA  PHE A  48      22.424  60.806   6.586  1.00  0.00           C  
ATOM    731  C   PHE A  48      21.849  60.162   5.327  1.00  0.00           C  
ATOM    732  O   PHE A  48      20.700  59.719   5.315  1.00  0.00           O  
ATOM    733  CB  PHE A  48      23.219  59.770   7.384  1.00  0.00           C  
ATOM    734  CG  PHE A  48      23.889  60.337   8.602  1.00  0.00           C  
ATOM    735  CD1 PHE A  48      23.179  60.525   9.776  1.00  0.00           C  
ATOM    736  CD2 PHE A  48      25.232  60.681   8.572  1.00  0.00           C  
ATOM    737  CE1 PHE A  48      23.794  61.049  10.898  1.00  0.00           C  
ATOM    738  CE2 PHE A  48      25.852  61.204   9.692  1.00  0.00           C  
ATOM    739  CZ  PHE A  48      25.132  61.387  10.856  1.00  0.00           C  
ATOM    740  H   PHE A  48      21.095  60.910   8.231  1.00  0.00           H  
ATOM    741  HA  PHE A  48      23.084  61.608   6.297  1.00  0.00           H  
ATOM    742  HB2 PHE A  48      22.552  58.986   7.708  1.00  0.00           H  
ATOM    743  HB3 PHE A  48      23.982  59.346   6.750  1.00  0.00           H  
ATOM    744  HD1 PHE A  48      22.132  60.260   9.811  1.00  0.00           H  
ATOM    745  HD2 PHE A  48      25.795  60.539   7.662  1.00  0.00           H  
ATOM    746  HE1 PHE A  48      23.229  61.190  11.808  1.00  0.00           H  
ATOM    747  HE2 PHE A  48      26.899  61.468   9.655  1.00  0.00           H  
ATOM    748  HZ  PHE A  48      25.615  61.796  11.731  1.00  0.00           H  
ATOM    749  N   GLU A  49      22.654  60.116   4.272  1.00  0.00           N  
ATOM    750  CA  GLU A  49      22.225  59.529   3.009  1.00  0.00           C  
ATOM    751  C   GLU A  49      21.523  58.193   3.239  1.00  0.00           C  
ATOM    752  O   GLU A  49      20.758  57.728   2.395  1.00  0.00           O  
ATOM    753  CB  GLU A  49      23.424  59.332   2.078  1.00  0.00           C  
ATOM    754  CG  GLU A  49      23.817  60.589   1.319  1.00  0.00           C  
ATOM    755  CD  GLU A  49      22.824  60.948   0.231  1.00  0.00           C  
ATOM    756  OE1 GLU A  49      22.212  60.022  -0.341  1.00  0.00           O  
ATOM    757  OE2 GLU A  49      22.659  62.154  -0.049  1.00  0.00           O  
ATOM    758  H   GLU A  49      23.559  60.486   4.344  1.00  0.00           H  
ATOM    759  HA  GLU A  49      21.529  60.212   2.545  1.00  0.00           H  
ATOM    760  HB2 GLU A  49      24.272  59.010   2.666  1.00  0.00           H  
ATOM    761  HB3 GLU A  49      23.183  58.564   1.359  1.00  0.00           H  
ATOM    762  HG2 GLU A  49      23.877  61.412   2.016  1.00  0.00           H  
ATOM    763  HG3 GLU A  49      24.784  60.432   0.865  1.00  0.00           H  
ATOM    764  N   ASP A  50      21.790  57.584   4.389  1.00  0.00           N  
ATOM    765  CA  ASP A  50      21.184  56.302   4.733  1.00  0.00           C  
ATOM    766  C   ASP A  50      19.772  56.498   5.277  1.00  0.00           C  
ATOM    767  O   ASP A  50      19.195  55.589   5.873  1.00  0.00           O  
ATOM    768  CB  ASP A  50      22.043  55.568   5.764  1.00  0.00           C  
ATOM    769  CG  ASP A  50      23.422  55.229   5.232  1.00  0.00           C  
ATOM    770  OD1 ASP A  50      23.506  54.464   4.248  1.00  0.00           O  
ATOM    771  OD2 ASP A  50      24.415  55.729   5.799  1.00  0.00           O  
ATOM    772  H   ASP A  50      22.408  58.005   5.022  1.00  0.00           H  
ATOM    773  HA  ASP A  50      21.131  55.708   3.834  1.00  0.00           H  
ATOM    774  HB2 ASP A  50      22.159  56.193   6.638  1.00  0.00           H  
ATOM    775  HB3 ASP A  50      21.549  54.650   6.045  1.00  0.00           H  
ATOM    776  N   SER A  51      19.221  57.688   5.065  1.00  0.00           N  
ATOM    777  CA  SER A  51      17.878  58.004   5.538  1.00  0.00           C  
ATOM    778  C   SER A  51      17.763  57.774   7.041  1.00  0.00           C  
ATOM    779  O   SER A  51      16.676  57.521   7.561  1.00  0.00           O  
ATOM    780  CB  SER A  51      16.842  57.155   4.800  1.00  0.00           C  
ATOM    781  OG  SER A  51      17.034  57.222   3.397  1.00  0.00           O  
ATOM    782  H   SER A  51      19.732  58.372   4.583  1.00  0.00           H  
ATOM    783  HA  SER A  51      17.691  59.047   5.330  1.00  0.00           H  
ATOM    784  HB2 SER A  51      16.933  56.127   5.115  1.00  0.00           H  
ATOM    785  HB3 SER A  51      15.851  57.519   5.033  1.00  0.00           H  
ATOM    786  HG  SER A  51      17.955  57.421   3.209  1.00  0.00           H  
ATOM    787  N   SER A  52      18.894  57.863   7.736  1.00  0.00           N  
ATOM    788  CA  SER A  52      18.921  57.660   9.179  1.00  0.00           C  
ATOM    789  C   SER A  52      19.078  58.989   9.912  1.00  0.00           C  
ATOM    790  O   SER A  52      19.999  59.758   9.637  1.00  0.00           O  
ATOM    791  CB  SER A  52      20.064  56.716   9.561  1.00  0.00           C  
ATOM    792  OG  SER A  52      19.808  55.397   9.112  1.00  0.00           O  
ATOM    793  H   SER A  52      19.729  58.066   7.265  1.00  0.00           H  
ATOM    794  HA  SER A  52      17.984  57.211   9.470  1.00  0.00           H  
ATOM    795  HB2 SER A  52      20.981  57.065   9.111  1.00  0.00           H  
ATOM    796  HB3 SER A  52      20.173  56.704  10.636  1.00  0.00           H  
ATOM    797  HG  SER A  52      19.558  54.848   9.858  1.00  0.00           H  
ATOM    798  N   LYS A  53      18.172  59.252  10.847  1.00  0.00           N  
ATOM    799  CA  LYS A  53      18.208  60.487  11.622  1.00  0.00           C  
ATOM    800  C   LYS A  53      18.915  60.272  12.955  1.00  0.00           C  
ATOM    801  O   LYS A  53      18.570  59.365  13.713  1.00  0.00           O  
ATOM    802  CB  LYS A  53      16.787  61.004  11.862  1.00  0.00           C  
ATOM    803  CG  LYS A  53      15.800  60.595  10.783  1.00  0.00           C  
ATOM    804  CD  LYS A  53      14.377  60.975  11.155  1.00  0.00           C  
ATOM    805  CE  LYS A  53      14.010  62.351  10.622  1.00  0.00           C  
ATOM    806  NZ  LYS A  53      12.711  62.831  11.170  1.00  0.00           N  
ATOM    807  H   LYS A  53      17.462  58.599  11.021  1.00  0.00           H  
ATOM    808  HA  LYS A  53      18.756  61.221  11.051  1.00  0.00           H  
ATOM    809  HB2 LYS A  53      16.434  60.620  12.808  1.00  0.00           H  
ATOM    810  HB3 LYS A  53      16.812  62.083  11.908  1.00  0.00           H  
ATOM    811  HG2 LYS A  53      16.064  61.090   9.860  1.00  0.00           H  
ATOM    812  HG3 LYS A  53      15.853  59.523  10.647  1.00  0.00           H  
ATOM    813  HD2 LYS A  53      13.698  60.247  10.738  1.00  0.00           H  
ATOM    814  HD3 LYS A  53      14.285  60.980  12.233  1.00  0.00           H  
ATOM    815  HE2 LYS A  53      14.787  63.049  10.897  1.00  0.00           H  
ATOM    816  HE3 LYS A  53      13.939  62.298   9.545  1.00  0.00           H  
ATOM    817  HZ1 LYS A  53      12.833  63.764  11.612  1.00  0.00           H  
ATOM    818  HZ2 LYS A  53      12.357  62.164  11.885  1.00  0.00           H  
ATOM    819  HZ3 LYS A  53      12.009  62.908  10.408  1.00  0.00           H  
ATOM    820  N   SER A  54      19.905  61.113  13.238  1.00  0.00           N  
ATOM    821  CA  SER A  54      20.662  61.014  14.480  1.00  0.00           C  
ATOM    822  C   SER A  54      21.100  62.393  14.961  1.00  0.00           C  
ATOM    823  O   SER A  54      21.617  63.198  14.186  1.00  0.00           O  
ATOM    824  CB  SER A  54      21.886  60.116  14.286  1.00  0.00           C  
ATOM    825  OG  SER A  54      21.586  58.769  14.606  1.00  0.00           O  
ATOM    826  H   SER A  54      20.132  61.816  12.594  1.00  0.00           H  
ATOM    827  HA  SER A  54      20.017  60.573  15.226  1.00  0.00           H  
ATOM    828  HB2 SER A  54      22.205  60.166  13.256  1.00  0.00           H  
ATOM    829  HB3 SER A  54      22.685  60.458  14.928  1.00  0.00           H  
ATOM    830  HG  SER A  54      21.190  58.338  13.846  1.00  0.00           H  
ATOM    831  N   TRP A  55      20.890  62.659  16.246  1.00  0.00           N  
ATOM    832  CA  TRP A  55      21.263  63.942  16.832  1.00  0.00           C  
ATOM    833  C   TRP A  55      22.774  64.042  17.004  1.00  0.00           C  
ATOM    834  O   TRP A  55      23.342  63.474  17.938  1.00  0.00           O  
ATOM    835  CB  TRP A  55      20.570  64.129  18.182  1.00  0.00           C  
ATOM    836  CG  TRP A  55      19.182  64.682  18.066  1.00  0.00           C  
ATOM    837  CD1 TRP A  55      18.011  63.982  18.132  1.00  0.00           C  
ATOM    838  CD2 TRP A  55      18.820  66.053  17.860  1.00  0.00           C  
ATOM    839  NE1 TRP A  55      16.945  64.834  17.980  1.00  0.00           N  
ATOM    840  CE2 TRP A  55      17.413  66.109  17.813  1.00  0.00           C  
ATOM    841  CE3 TRP A  55      19.547  67.237  17.715  1.00  0.00           C  
ATOM    842  CZ2 TRP A  55      16.723  67.303  17.624  1.00  0.00           C  
ATOM    843  CZ3 TRP A  55      18.861  68.421  17.527  1.00  0.00           C  
ATOM    844  CH2 TRP A  55      17.460  68.448  17.484  1.00  0.00           C  
ATOM    845  H   TRP A  55      20.474  61.976  16.814  1.00  0.00           H  
ATOM    846  HA  TRP A  55      20.936  64.720  16.158  1.00  0.00           H  
ATOM    847  HB2 TRP A  55      20.507  63.175  18.684  1.00  0.00           H  
ATOM    848  HB3 TRP A  55      21.152  64.811  18.785  1.00  0.00           H  
ATOM    849  HD1 TRP A  55      17.950  62.915  18.280  1.00  0.00           H  
ATOM    850  HE1 TRP A  55      16.000  64.569  17.992  1.00  0.00           H  
ATOM    851  HE3 TRP A  55      20.627  67.237  17.745  1.00  0.00           H  
ATOM    852  HZ2 TRP A  55      15.644  67.341  17.590  1.00  0.00           H  
ATOM    853  HZ3 TRP A  55      19.406  69.347  17.411  1.00  0.00           H  
ATOM    854  HH2 TRP A  55      16.965  69.396  17.336  1.00  0.00           H  
ATOM    855  N   VAL A  56      23.422  64.769  16.099  1.00  0.00           N  
ATOM    856  CA  VAL A  56      24.869  64.945  16.152  1.00  0.00           C  
ATOM    857  C   VAL A  56      25.245  66.150  17.006  1.00  0.00           C  
ATOM    858  O   VAL A  56      24.538  67.159  17.022  1.00  0.00           O  
ATOM    859  CB  VAL A  56      25.464  65.123  14.742  1.00  0.00           C  
ATOM    860  CG1 VAL A  56      26.980  65.008  14.785  1.00  0.00           C  
ATOM    861  CG2 VAL A  56      24.870  64.104  13.782  1.00  0.00           C  
ATOM    862  H   VAL A  56      22.915  65.197  15.378  1.00  0.00           H  
ATOM    863  HA  VAL A  56      25.298  64.056  16.591  1.00  0.00           H  
ATOM    864  HB  VAL A  56      25.210  66.111  14.389  1.00  0.00           H  
ATOM    865 HG11 VAL A  56      27.363  65.594  15.607  1.00  0.00           H  
ATOM    866 HG12 VAL A  56      27.259  63.972  14.920  1.00  0.00           H  
ATOM    867 HG13 VAL A  56      27.396  65.374  13.858  1.00  0.00           H  
ATOM    868 HG21 VAL A  56      23.823  63.966  14.004  1.00  0.00           H  
ATOM    869 HG22 VAL A  56      24.980  64.460  12.768  1.00  0.00           H  
ATOM    870 HG23 VAL A  56      25.389  63.162  13.889  1.00  0.00           H  
ATOM    871  N   LEU A  57      26.362  66.039  17.716  1.00  0.00           N  
ATOM    872  CA  LEU A  57      26.833  67.121  18.574  1.00  0.00           C  
ATOM    873  C   LEU A  57      27.472  68.232  17.748  1.00  0.00           C  
ATOM    874  O   LEU A  57      28.172  67.968  16.770  1.00  0.00           O  
ATOM    875  CB  LEU A  57      27.840  66.586  19.595  1.00  0.00           C  
ATOM    876  CG  LEU A  57      27.283  65.622  20.644  1.00  0.00           C  
ATOM    877  CD1 LEU A  57      28.407  65.058  21.500  1.00  0.00           C  
ATOM    878  CD2 LEU A  57      26.248  66.320  21.514  1.00  0.00           C  
ATOM    879  H   LEU A  57      26.882  65.211  17.663  1.00  0.00           H  
ATOM    880  HA  LEU A  57      25.980  67.523  19.099  1.00  0.00           H  
ATOM    881  HB2 LEU A  57      28.618  66.071  19.054  1.00  0.00           H  
ATOM    882  HB3 LEU A  57      28.263  67.434  20.115  1.00  0.00           H  
ATOM    883  HG  LEU A  57      26.799  64.795  20.144  1.00  0.00           H  
ATOM    884 HD11 LEU A  57      28.171  64.043  21.782  1.00  0.00           H  
ATOM    885 HD12 LEU A  57      28.521  65.662  22.389  1.00  0.00           H  
ATOM    886 HD13 LEU A  57      29.330  65.071  20.937  1.00  0.00           H  
ATOM    887 HD21 LEU A  57      25.427  66.655  20.897  1.00  0.00           H  
ATOM    888 HD22 LEU A  57      26.702  67.169  22.002  1.00  0.00           H  
ATOM    889 HD23 LEU A  57      25.880  65.630  22.259  1.00  0.00           H  
ATOM    890  N   TRP A  58      27.228  69.474  18.149  1.00  0.00           N  
ATOM    891  CA  TRP A  58      27.781  70.627  17.446  1.00  0.00           C  
ATOM    892  C   TRP A  58      29.276  70.448  17.201  1.00  0.00           C  
ATOM    893  O   TRP A  58      29.818  70.952  16.216  1.00  0.00           O  
ATOM    894  CB  TRP A  58      27.533  71.906  18.247  1.00  0.00           C  
ATOM    895  CG  TRP A  58      26.102  72.353  18.223  1.00  0.00           C  
ATOM    896  CD1 TRP A  58      25.046  71.690  17.668  1.00  0.00           C  
ATOM    897  CD2 TRP A  58      25.573  73.562  18.777  1.00  0.00           C  
ATOM    898  NE1 TRP A  58      23.891  72.414  17.842  1.00  0.00           N  
ATOM    899  CE2 TRP A  58      24.188  73.567  18.521  1.00  0.00           C  
ATOM    900  CE3 TRP A  58      26.134  74.641  19.467  1.00  0.00           C  
ATOM    901  CZ2 TRP A  58      23.359  74.607  18.930  1.00  0.00           C  
ATOM    902  CZ3 TRP A  58      25.309  75.674  19.871  1.00  0.00           C  
ATOM    903  CH2 TRP A  58      23.934  75.651  19.603  1.00  0.00           C  
ATOM    904  H   TRP A  58      26.662  69.622  18.936  1.00  0.00           H  
ATOM    905  HA  TRP A  58      27.279  70.705  16.494  1.00  0.00           H  
ATOM    906  HB2 TRP A  58      27.812  71.739  19.277  1.00  0.00           H  
ATOM    907  HB3 TRP A  58      28.138  72.701  17.837  1.00  0.00           H  
ATOM    908  HD1 TRP A  58      25.122  70.738  17.165  1.00  0.00           H  
ATOM    909  HE1 TRP A  58      23.000  72.147  17.533  1.00  0.00           H  
ATOM    910  HE3 TRP A  58      27.191  74.677  19.682  1.00  0.00           H  
ATOM    911  HZ2 TRP A  58      22.297  74.605  18.731  1.00  0.00           H  
ATOM    912  HZ3 TRP A  58      25.725  76.516  20.405  1.00  0.00           H  
ATOM    913  HH2 TRP A  58      23.329  76.479  19.937  1.00  0.00           H  
ATOM    914  N   LYS A  59      29.938  69.729  18.101  1.00  0.00           N  
ATOM    915  CA  LYS A  59      31.370  69.483  17.982  1.00  0.00           C  
ATOM    916  C   LYS A  59      31.644  68.311  17.045  1.00  0.00           C  
ATOM    917  O   LYS A  59      32.722  68.210  16.461  1.00  0.00           O  
ATOM    918  CB  LYS A  59      31.975  69.202  19.359  1.00  0.00           C  
ATOM    919  CG  LYS A  59      31.502  67.898  19.977  1.00  0.00           C  
ATOM    920  CD  LYS A  59      32.395  67.471  21.130  1.00  0.00           C  
ATOM    921  CE  LYS A  59      31.622  66.667  22.165  1.00  0.00           C  
ATOM    922  NZ  LYS A  59      30.664  67.516  22.926  1.00  0.00           N  
ATOM    923  H   LYS A  59      29.450  69.354  18.865  1.00  0.00           H  
ATOM    924  HA  LYS A  59      31.826  70.371  17.572  1.00  0.00           H  
ATOM    925  HB2 LYS A  59      33.051  69.161  19.264  1.00  0.00           H  
ATOM    926  HB3 LYS A  59      31.713  70.009  20.027  1.00  0.00           H  
ATOM    927  HG2 LYS A  59      30.495  68.030  20.346  1.00  0.00           H  
ATOM    928  HG3 LYS A  59      31.512  67.126  19.220  1.00  0.00           H  
ATOM    929  HD2 LYS A  59      33.199  66.862  20.745  1.00  0.00           H  
ATOM    930  HD3 LYS A  59      32.803  68.352  21.604  1.00  0.00           H  
ATOM    931  HE2 LYS A  59      31.074  65.886  21.660  1.00  0.00           H  
ATOM    932  HE3 LYS A  59      32.325  66.224  22.855  1.00  0.00           H  
ATOM    933  HZ1 LYS A  59      31.163  68.027  23.683  1.00  0.00           H  
ATOM    934  HZ2 LYS A  59      29.923  66.924  23.351  1.00  0.00           H  
ATOM    935  HZ3 LYS A  59      30.218  68.208  22.291  1.00  0.00           H  
ATOM    936  N   ASP A  60      30.661  67.428  16.905  1.00  0.00           N  
ATOM    937  CA  ASP A  60      30.795  66.265  16.037  1.00  0.00           C  
ATOM    938  C   ASP A  60      30.327  66.586  14.622  1.00  0.00           C  
ATOM    939  O   ASP A  60      30.571  65.821  13.688  1.00  0.00           O  
ATOM    940  CB  ASP A  60      29.995  65.088  16.598  1.00  0.00           C  
ATOM    941  CG  ASP A  60      30.724  64.375  17.720  1.00  0.00           C  
ATOM    942  OD1 ASP A  60      31.819  64.836  18.103  1.00  0.00           O  
ATOM    943  OD2 ASP A  60      30.199  63.354  18.213  1.00  0.00           O  
ATOM    944  H   ASP A  60      29.823  67.563  17.398  1.00  0.00           H  
ATOM    945  HA  ASP A  60      31.840  65.995  16.004  1.00  0.00           H  
ATOM    946  HB2 ASP A  60      29.052  65.452  16.980  1.00  0.00           H  
ATOM    947  HB3 ASP A  60      29.808  64.379  15.805  1.00  0.00           H  
ATOM    948  N   ILE A  61      29.653  67.721  14.470  1.00  0.00           N  
ATOM    949  CA  ILE A  61      29.150  68.143  13.168  1.00  0.00           C  
ATOM    950  C   ILE A  61      30.166  69.022  12.446  1.00  0.00           C  
ATOM    951  O   ILE A  61      30.404  70.163  12.841  1.00  0.00           O  
ATOM    952  CB  ILE A  61      27.823  68.912  13.299  1.00  0.00           C  
ATOM    953  CG1 ILE A  61      26.790  68.068  14.049  1.00  0.00           C  
ATOM    954  CG2 ILE A  61      27.299  69.303  11.926  1.00  0.00           C  
ATOM    955  CD1 ILE A  61      25.796  68.889  14.839  1.00  0.00           C  
ATOM    956  H   ILE A  61      29.490  68.289  15.252  1.00  0.00           H  
ATOM    957  HA  ILE A  61      28.972  67.256  12.577  1.00  0.00           H  
ATOM    958  HB  ILE A  61      28.010  69.817  13.858  1.00  0.00           H  
ATOM    959 HG12 ILE A  61      26.238  67.472  13.339  1.00  0.00           H  
ATOM    960 HG13 ILE A  61      27.304  67.413  14.738  1.00  0.00           H  
ATOM    961 HG21 ILE A  61      26.743  68.479  11.504  1.00  0.00           H  
ATOM    962 HG22 ILE A  61      26.652  70.163  12.019  1.00  0.00           H  
ATOM    963 HG23 ILE A  61      28.129  69.545  11.279  1.00  0.00           H  
ATOM    964 HD11 ILE A  61      24.897  68.310  14.998  1.00  0.00           H  
ATOM    965 HD12 ILE A  61      26.225  69.154  15.794  1.00  0.00           H  
ATOM    966 HD13 ILE A  61      25.554  69.787  14.291  1.00  0.00           H  
ATOM    967  N   GLN A  62      30.758  68.483  11.385  1.00  0.00           N  
ATOM    968  CA  GLN A  62      31.747  69.220  10.607  1.00  0.00           C  
ATOM    969  C   GLN A  62      31.072  70.079   9.543  1.00  0.00           C  
ATOM    970  O   GLN A  62      30.310  69.577   8.716  1.00  0.00           O  
ATOM    971  CB  GLN A  62      32.733  68.253   9.950  1.00  0.00           C  
ATOM    972  CG  GLN A  62      34.122  68.839   9.754  1.00  0.00           C  
ATOM    973  CD  GLN A  62      35.188  67.774   9.598  1.00  0.00           C  
ATOM    974  OE1 GLN A  62      36.170  67.746  10.341  1.00  0.00           O  
ATOM    975  NE2 GLN A  62      35.001  66.886   8.627  1.00  0.00           N  
ATOM    976  H   GLN A  62      30.526  67.570  11.121  1.00  0.00           H  
ATOM    977  HA  GLN A  62      32.287  69.865  11.283  1.00  0.00           H  
ATOM    978  HB2 GLN A  62      32.821  67.372  10.567  1.00  0.00           H  
ATOM    979  HB3 GLN A  62      32.348  67.968   8.982  1.00  0.00           H  
ATOM    980  HG2 GLN A  62      34.118  69.454   8.867  1.00  0.00           H  
ATOM    981  HG3 GLN A  62      34.365  69.448  10.613  1.00  0.00           H  
ATOM    982 HE21 GLN A  62      34.197  66.970   8.074  1.00  0.00           H  
ATOM    983 HE22 GLN A  62      35.676  66.187   8.504  1.00  0.00           H  
ATOM    984  N   THR A  63      31.357  71.377   9.569  1.00  0.00           N  
ATOM    985  CA  THR A  63      30.776  72.307   8.608  1.00  0.00           C  
ATOM    986  C   THR A  63      31.639  72.412   7.356  1.00  0.00           C  
ATOM    987  O   THR A  63      32.742  72.954   7.395  1.00  0.00           O  
ATOM    988  CB  THR A  63      30.602  73.710   9.218  1.00  0.00           C  
ATOM    989  OG1 THR A  63      31.878  74.246   9.585  1.00  0.00           O  
ATOM    990  CG2 THR A  63      29.696  73.660  10.439  1.00  0.00           C  
ATOM    991  H   THR A  63      31.971  71.717  10.253  1.00  0.00           H  
ATOM    992  HA  THR A  63      29.800  71.933   8.331  1.00  0.00           H  
ATOM    993  HB  THR A  63      30.149  74.354   8.478  1.00  0.00           H  
ATOM    994  HG1 THR A  63      32.400  73.564  10.015  1.00  0.00           H  
ATOM    995 HG21 THR A  63      29.385  72.642  10.616  1.00  0.00           H  
ATOM    996 HG22 THR A  63      28.827  74.278  10.268  1.00  0.00           H  
ATOM    997 HG23 THR A  63      30.234  74.027  11.302  1.00  0.00           H  
ATOM    998  N   GLY A  64      31.127  71.892   6.244  1.00  0.00           N  
ATOM    999  CA  GLY A  64      31.865  71.939   4.995  1.00  0.00           C  
ATOM   1000  C   GLY A  64      31.518  73.157   4.163  1.00  0.00           C  
ATOM   1001  O   GLY A  64      32.297  74.107   4.086  1.00  0.00           O  
ATOM   1002  H   GLY A  64      30.241  71.472   6.273  1.00  0.00           H  
ATOM   1003  HA2 GLY A  64      32.921  71.954   5.214  1.00  0.00           H  
ATOM   1004  HA3 GLY A  64      31.639  71.050   4.424  1.00  0.00           H  
ATOM   1005  N   ALA A  65      30.346  73.130   3.536  1.00  0.00           N  
ATOM   1006  CA  ALA A  65      29.898  74.240   2.705  1.00  0.00           C  
ATOM   1007  C   ALA A  65      30.276  75.579   3.329  1.00  0.00           C  
ATOM   1008  O   ALA A  65      29.760  75.954   4.382  1.00  0.00           O  
ATOM   1009  CB  ALA A  65      28.394  74.163   2.488  1.00  0.00           C  
ATOM   1010  H   ALA A  65      29.769  72.344   3.637  1.00  0.00           H  
ATOM   1011  HA  ALA A  65      30.381  74.153   1.743  1.00  0.00           H  
ATOM   1012  HB1 ALA A  65      28.042  75.097   2.077  1.00  0.00           H  
ATOM   1013  HB2 ALA A  65      28.171  73.360   1.801  1.00  0.00           H  
ATOM   1014  HB3 ALA A  65      27.903  73.977   3.431  1.00  0.00           H  
ATOM   1015  N   THR A  66      31.181  76.299   2.671  1.00  0.00           N  
ATOM   1016  CA  THR A  66      31.630  77.595   3.162  1.00  0.00           C  
ATOM   1017  C   THR A  66      30.495  78.613   3.143  1.00  0.00           C  
ATOM   1018  O   THR A  66      29.360  78.286   2.795  1.00  0.00           O  
ATOM   1019  CB  THR A  66      32.805  78.136   2.325  1.00  0.00           C  
ATOM   1020  OG1 THR A  66      33.866  77.175   2.291  1.00  0.00           O  
ATOM   1021  CG2 THR A  66      33.320  79.447   2.900  1.00  0.00           C  
ATOM   1022  H   THR A  66      31.555  75.946   1.837  1.00  0.00           H  
ATOM   1023  HA  THR A  66      31.969  77.468   4.180  1.00  0.00           H  
ATOM   1024  HB  THR A  66      32.458  78.314   1.318  1.00  0.00           H  
ATOM   1025  HG1 THR A  66      34.108  76.934   3.188  1.00  0.00           H  
ATOM   1026 HG21 THR A  66      32.519  79.952   3.419  1.00  0.00           H  
ATOM   1027 HG22 THR A  66      33.680  80.075   2.098  1.00  0.00           H  
ATOM   1028 HG23 THR A  66      34.126  79.246   3.590  1.00  0.00           H  
TER    1029      THR A  66                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
