
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   74 ( 1159),  selected   74 , name 2equ_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2equ_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    78_A      -       -           -
LGA    S    79_A      -       -           -
LGA    S    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    S    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    G    84_A      X      63           #
LGA    F    85_A      P      64          3.951
LGA    -       -      P      65           -
LGA    -       -      A      66           -
LGA    -       -      D      67           -
LGA    D    86_A      K      68          1.021
LGA    F    87_A      L      69          0.684
LGA    K    88_A      Y      70          0.841
LGA    A    89_A      V      71          1.176
LGA    G    90_A      G      72          1.530
LGA    E    91_A      S      73          1.139
LGA    E    92_A      R      74          1.279
LGA    V    93_A      V      75          0.686
LGA    L    94_A      V      76          0.581
LGA    A    95_A      A      77          0.371
LGA    R    96_A      K      78          0.925
LGA    W    97_A      Y      79          1.114
LGA    T    98_A      K      80          2.412
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    D    99_A      Q      84          3.701
LGA    C   100_A      V      85          3.727
LGA    R   101_A      W      86          2.742
LGA    Y   102_A      L      87          1.324
LGA    Y   103_A      Y      88          1.177
LGA    P   104_A      A      89          1.200
LGA    A   105_A      G      90          0.181
LGA    K   106_A      I      91          0.545
LGA    I   107_A      V      92          0.645
LGA    E   108_A      A      93          0.656
LGA    A   109_A      E      94          0.576
LGA    I   110_A      T      95          0.886
LGA    N   111_A      P      96          1.176
LGA    K   112_A      N      97          3.003
LGA    -       -      V      98           -
LGA    -       -      K      99           -
LGA    E   113_A      N     100          1.042
LGA    G   114_A      K     101          2.210
LGA    -       -      L     102           -
LGA    T   115_A      R     103          0.690
LGA    F   116_A      F     104          0.633
LGA    T   117_A      L     105          0.784
LGA    V   118_A      I     106          0.874
LGA    Q   119_A      F     107          0.515
LGA    F   120_A      F     108          0.807
LGA    Y   121_A      D     109          1.287
LGA    D   122_A      D     110          1.789
LGA    G   123_A      G     111          1.679
LGA    V   124_A      Y     112          1.934
LGA    I   125_A      A     113          1.345
LGA    R   126_A      S     114          1.322
LGA    C   127_A      Y     115          0.691
LGA    L   128_A      V     116          0.938
LGA    K   129_A      T     117          0.723
LGA    R   130_A      Q     118          0.791
LGA    M   131_A      S     119          1.173
LGA    H   132_A      E     120          1.029
LGA    I   133_A      L     121          1.062
LGA    K   134_A      Y     122          0.906
LGA    A   135_A      P     123          0.593
LGA    M   136_A      I     124          1.259
LGA    P   137_A      C     125          2.257
LGA    E   138_A      R     126          2.484
LGA    D   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    K   141_A      P     127          3.270
LGA    G   142_A      L     128          6.328
LGA    Q   143_A      K     129           -
LGA    D   144_A      K     130           -
LGA    W   145_A      T     131           -
LGA    I   146_A      W     132           -
LGA    A   147_A      E     133           -
LGA    L   148_A      D     134           -
LGA    V   149_A      I     135           -
LGA    K   150_A      E     136           -
LGA    A   151_A      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   74   93    5.0     56    1.80    14.29     56.268     2.953

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.831289 * X  +  -0.154245 * Y  +  -0.534010 * Z  +  31.781384
  Y_new =  -0.316343 * X  +   0.921244 * Y  +   0.226354 * Z  +  77.298141
  Z_new =   0.457040 * X  +   0.357096 * Y  +  -0.814615 * Z  +   5.964192 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.728459   -0.413133  [ DEG:   156.3292    -23.6708 ]
  Theta =  -0.474664   -2.666929  [ DEG:   -27.1962   -152.8038 ]
  Phi   =  -2.777970    0.363623  [ DEG:  -159.1660     20.8340 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2equ_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2equ_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   74   93   5.0   56   1.80   14.29  56.268
REMARK  ---------------------------------------------------------- 
MOLECULE 2equ_A
HEADER    PROTEIN BINDING                         30-MAR-07   2EQU              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 20-LIKE 1                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 20-LIKE 1;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF20L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060911-17;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT           
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, PROTEIN             
KEYWDS   4 BINDING                                                              
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.FUTAMI,S.SUZUKI,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,                   
AUTHOR   2 M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   02-OCT-07 2EQU    0                                                
JRNL        AUTH   K.FUTAMI,S.SUZUKI,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,          
JRNL        AUTH 2 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 20-LIKE 1                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EQU A   85   151  UNP    Q96BT0   Q96BT0_HUMAN    85    151             
SEQRES   1 A   74  GLY SER SER GLY SER SER GLY PHE ASP PHE LYS ALA GLY          
SEQRES   2 A   74  GLU GLU VAL LEU ALA ARG TRP THR ASP CYS ARG TYR TYR          
SEQRES   3 A   74  PRO ALA LYS ILE GLU ALA ILE ASN LYS GLU GLY THR PHE          
SEQRES   4 A   74  THR VAL GLN PHE TYR ASP GLY VAL ILE ARG CYS LEU LYS          
SEQRES   5 A   74  ARG MET HIS ILE LYS ALA MET PRO GLU ASP ALA LYS GLY          
SEQRES   6 A   74  GLN ASP TRP ILE ALA LEU VAL LYS ALA                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  78      42.039  82.572  18.565  1.00  0.00           N  
ATOM      2  CA  GLY A  78      42.327  82.850  17.142  1.00  0.00           C  
ATOM      3  C   GLY A  78      43.074  81.698  16.491  1.00  0.00           C  
ATOM      4  O   GLY A  78      42.730  80.535  16.717  1.00  0.00           O  
ATOM      5  H1  GLY A  78      41.493  81.728  18.649  1.00  0.00           H  
ATOM      6  H2  GLY A  78      42.897  82.454  19.081  1.00  0.00           H  
ATOM      7  H3  GLY A  78      41.522  83.336  18.968  1.00  0.00           H  
ATOM      8  HA2 GLY A  78      41.391  83.001  16.606  1.00  0.00           H  
ATOM      9  HA3 GLY A  78      42.930  83.756  17.067  1.00  0.00           H  
ATOM     10  N   SER A  79      44.091  82.006  15.675  1.00  0.00           N  
ATOM     11  CA  SER A  79      44.997  81.057  14.979  1.00  0.00           C  
ATOM     12  C   SER A  79      44.321  79.881  14.236  1.00  0.00           C  
ATOM     13  O   SER A  79      44.912  78.810  14.081  1.00  0.00           O  
ATOM     14  CB  SER A  79      46.085  80.558  15.948  1.00  0.00           C  
ATOM     15  OG  SER A  79      46.817  81.641  16.505  1.00  0.00           O  
ATOM     16  H   SER A  79      44.279  82.990  15.525  1.00  0.00           H  
ATOM     17  HA  SER A  79      45.509  81.626  14.201  1.00  0.00           H  
ATOM     18  HB2 SER A  79      45.625  79.974  16.745  1.00  0.00           H  
ATOM     19  HB3 SER A  79      46.783  79.918  15.406  1.00  0.00           H  
ATOM     20  HG  SER A  79      46.219  82.143  17.077  1.00  0.00           H  
ATOM     21  N   SER A  80      43.070  80.056  13.792  1.00  0.00           N  
ATOM     22  CA  SER A  80      42.217  78.986  13.227  1.00  0.00           C  
ATOM     23  C   SER A  80      41.223  79.462  12.146  1.00  0.00           C  
ATOM     24  O   SER A  80      40.355  78.696  11.718  1.00  0.00           O  
ATOM     25  CB  SER A  80      41.493  78.251  14.368  1.00  0.00           C  
ATOM     26  OG  SER A  80      40.808  79.147  15.232  1.00  0.00           O  
ATOM     27  H   SER A  80      42.636  80.948  13.983  1.00  0.00           H  
ATOM     28  HA  SER A  80      42.860  78.260  12.730  1.00  0.00           H  
ATOM     29  HB2 SER A  80      40.788  77.530  13.954  1.00  0.00           H  
ATOM     30  HB3 SER A  80      42.230  77.699  14.952  1.00  0.00           H  
ATOM     31  HG  SER A  80      41.483  79.571  15.795  1.00  0.00           H  
ATOM     32  N   GLY A  81      41.353  80.708  11.667  1.00  0.00           N  
ATOM     33  CA  GLY A  81      40.512  81.286  10.609  1.00  0.00           C  
ATOM     34  C   GLY A  81      39.137  81.780  11.080  1.00  0.00           C  
ATOM     35  O   GLY A  81      38.809  81.752  12.270  1.00  0.00           O  
ATOM     36  H   GLY A  81      42.104  81.276  12.028  1.00  0.00           H  
ATOM     37  HA2 GLY A  81      41.039  82.133  10.166  1.00  0.00           H  
ATOM     38  HA3 GLY A  81      40.357  80.548   9.820  1.00  0.00           H  
ATOM     39  N   SER A  82      38.333  82.281  10.140  1.00  0.00           N  
ATOM     40  CA  SER A  82      36.959  82.791  10.359  1.00  0.00           C  
ATOM     41  C   SER A  82      36.108  82.737   9.071  1.00  0.00           C  
ATOM     42  O   SER A  82      35.237  83.581   8.845  1.00  0.00           O  
ATOM     43  CB  SER A  82      37.010  84.224  10.924  1.00  0.00           C  
ATOM     44  OG  SER A  82      37.576  84.235  12.225  1.00  0.00           O  
ATOM     45  H   SER A  82      38.704  82.334   9.199  1.00  0.00           H  
ATOM     46  HA  SER A  82      36.456  82.151  11.087  1.00  0.00           H  
ATOM     47  HB2 SER A  82      37.603  84.854  10.259  1.00  0.00           H  
ATOM     48  HB3 SER A  82      36.001  84.634  10.990  1.00  0.00           H  
ATOM     49  HG  SER A  82      38.044  83.386  12.341  1.00  0.00           H  
ATOM     50  N   SER A  83      36.383  81.768   8.188  1.00  0.00           N  
ATOM     51  CA  SER A  83      35.749  81.619   6.863  1.00  0.00           C  
ATOM     52  C   SER A  83      34.226  81.403   6.891  1.00  0.00           C  
ATOM     53  O   SER A  83      33.540  81.745   5.924  1.00  0.00           O  
ATOM     54  CB  SER A  83      36.432  80.484   6.086  1.00  0.00           C  
ATOM     55  OG  SER A  83      36.444  79.270   6.828  1.00  0.00           O  
ATOM     56  H   SER A  83      37.075  81.076   8.444  1.00  0.00           H  
ATOM     57  HA  SER A  83      35.920  82.539   6.303  1.00  0.00           H  
ATOM     58  HB2 SER A  83      35.930  80.333   5.129  1.00  0.00           H  
ATOM     59  HB3 SER A  83      37.465  80.776   5.887  1.00  0.00           H  
ATOM     60  HG  SER A  83      35.622  78.791   6.646  1.00  0.00           H  
ATOM     61  N   GLY A  84      33.681  80.868   7.989  1.00  0.00           N  
ATOM     62  CA  GLY A  84      32.239  80.752   8.232  1.00  0.00           C  
ATOM     63  C   GLY A  84      31.891  79.916   9.469  1.00  0.00           C  
ATOM     64  O   GLY A  84      32.689  79.097   9.930  1.00  0.00           O  
ATOM     65  H   GLY A  84      34.305  80.576   8.729  1.00  0.00           H  
ATOM     66  HA2 GLY A  84      31.822  81.753   8.360  1.00  0.00           H  
ATOM     67  HA3 GLY A  84      31.755  80.296   7.367  1.00  0.00           H  
ATOM     68  N   PHE A  85      30.684  80.130  10.000  1.00  0.00           N  
ATOM     69  CA  PHE A  85      30.147  79.449  11.193  1.00  0.00           C  
ATOM     70  C   PHE A  85      28.604  79.347  11.199  1.00  0.00           C  
ATOM     71  O   PHE A  85      28.002  78.965  12.206  1.00  0.00           O  
ATOM     72  CB  PHE A  85      30.672  80.163  12.455  1.00  0.00           C  
ATOM     73  CG  PHE A  85      30.305  81.633  12.572  1.00  0.00           C  
ATOM     74  CD1 PHE A  85      29.104  82.022  13.199  1.00  0.00           C  
ATOM     75  CD2 PHE A  85      31.170  82.619  12.056  1.00  0.00           C  
ATOM     76  CE1 PHE A  85      28.769  83.383  13.302  1.00  0.00           C  
ATOM     77  CE2 PHE A  85      30.834  83.981  12.159  1.00  0.00           C  
ATOM     78  CZ  PHE A  85      29.633  84.364  12.782  1.00  0.00           C  
ATOM     79  H   PHE A  85      30.126  80.867   9.593  1.00  0.00           H  
ATOM     80  HA  PHE A  85      30.519  78.424  11.205  1.00  0.00           H  
ATOM     81  HB2 PHE A  85      30.305  79.637  13.338  1.00  0.00           H  
ATOM     82  HB3 PHE A  85      31.758  80.073  12.477  1.00  0.00           H  
ATOM     83  HD1 PHE A  85      28.436  81.273  13.604  1.00  0.00           H  
ATOM     84  HD2 PHE A  85      32.097  82.330  11.579  1.00  0.00           H  
ATOM     85  HE1 PHE A  85      27.845  83.678  13.783  1.00  0.00           H  
ATOM     86  HE2 PHE A  85      31.500  84.735  11.760  1.00  0.00           H  
ATOM     87  HZ  PHE A  85      29.374  85.412  12.864  1.00  0.00           H  
ATOM     88  N   ASP A  86      27.941  79.702  10.091  1.00  0.00           N  
ATOM     89  CA  ASP A  86      26.483  79.719   9.947  1.00  0.00           C  
ATOM     90  C   ASP A  86      25.889  78.300   9.956  1.00  0.00           C  
ATOM     91  O   ASP A  86      26.151  77.479   9.073  1.00  0.00           O  
ATOM     92  CB  ASP A  86      26.095  80.446   8.654  1.00  0.00           C  
ATOM     93  CG  ASP A  86      26.553  81.913   8.652  1.00  0.00           C  
ATOM     94  OD1 ASP A  86      25.797  82.784   9.149  1.00  0.00           O  
ATOM     95  OD2 ASP A  86      27.666  82.198   8.148  1.00  0.00           O  
ATOM     96  H   ASP A  86      28.476  79.963   9.280  1.00  0.00           H  
ATOM     97  HA  ASP A  86      26.058  80.279  10.782  1.00  0.00           H  
ATOM     98  HB2 ASP A  86      26.529  79.920   7.805  1.00  0.00           H  
ATOM     99  HB3 ASP A  86      25.008  80.412   8.545  1.00  0.00           H  
ATOM    100  N   PHE A  87      25.062  78.035  10.965  1.00  0.00           N  
ATOM    101  CA  PHE A  87      24.336  76.780  11.203  1.00  0.00           C  
ATOM    102  C   PHE A  87      22.849  77.090  11.452  1.00  0.00           C  
ATOM    103  O   PHE A  87      22.514  77.995  12.225  1.00  0.00           O  
ATOM    104  CB  PHE A  87      24.928  76.039  12.421  1.00  0.00           C  
ATOM    105  CG  PHE A  87      26.079  75.079  12.156  1.00  0.00           C  
ATOM    106  CD1 PHE A  87      27.276  75.508  11.551  1.00  0.00           C  
ATOM    107  CD2 PHE A  87      25.965  73.734  12.562  1.00  0.00           C  
ATOM    108  CE1 PHE A  87      28.327  74.602  11.319  1.00  0.00           C  
ATOM    109  CE2 PHE A  87      27.013  72.825  12.330  1.00  0.00           C  
ATOM    110  CZ  PHE A  87      28.193  73.255  11.702  1.00  0.00           C  
ATOM    111  H   PHE A  87      24.930  78.781  11.632  1.00  0.00           H  
ATOM    112  HA  PHE A  87      24.408  76.131  10.330  1.00  0.00           H  
ATOM    113  HB2 PHE A  87      25.239  76.764  13.170  1.00  0.00           H  
ATOM    114  HB3 PHE A  87      24.121  75.460  12.877  1.00  0.00           H  
ATOM    115  HD1 PHE A  87      27.395  76.541  11.265  1.00  0.00           H  
ATOM    116  HD2 PHE A  87      25.061  73.399  13.050  1.00  0.00           H  
ATOM    117  HE1 PHE A  87      29.240  74.944  10.852  1.00  0.00           H  
ATOM    118  HE2 PHE A  87      26.909  71.794  12.640  1.00  0.00           H  
ATOM    119  HZ  PHE A  87      29.000  72.558  11.522  1.00  0.00           H  
ATOM    120  N   LYS A  88      21.962  76.326  10.804  1.00  0.00           N  
ATOM    121  CA  LYS A  88      20.493  76.440  10.904  1.00  0.00           C  
ATOM    122  C   LYS A  88      19.803  75.116  10.555  1.00  0.00           C  
ATOM    123  O   LYS A  88      20.376  74.287   9.847  1.00  0.00           O  
ATOM    124  CB  LYS A  88      20.002  77.597  10.008  1.00  0.00           C  
ATOM    125  CG  LYS A  88      20.059  77.296   8.499  1.00  0.00           C  
ATOM    126  CD  LYS A  88      20.045  78.584   7.669  1.00  0.00           C  
ATOM    127  CE  LYS A  88      19.685  78.367   6.188  1.00  0.00           C  
ATOM    128  NZ  LYS A  88      20.475  77.287   5.542  1.00  0.00           N  
ATOM    129  H   LYS A  88      22.333  75.592  10.213  1.00  0.00           H  
ATOM    130  HA  LYS A  88      20.231  76.684  11.935  1.00  0.00           H  
ATOM    131  HB2 LYS A  88      18.969  77.836  10.270  1.00  0.00           H  
ATOM    132  HB3 LYS A  88      20.603  78.483  10.222  1.00  0.00           H  
ATOM    133  HG2 LYS A  88      20.980  76.765   8.274  1.00  0.00           H  
ATOM    134  HG3 LYS A  88      19.208  76.670   8.229  1.00  0.00           H  
ATOM    135  HD2 LYS A  88      19.313  79.276   8.090  1.00  0.00           H  
ATOM    136  HD3 LYS A  88      21.030  79.046   7.737  1.00  0.00           H  
ATOM    137  HE2 LYS A  88      18.621  78.128   6.120  1.00  0.00           H  
ATOM    138  HE3 LYS A  88      19.847  79.309   5.658  1.00  0.00           H  
ATOM    139  HZ1 LYS A  88      20.322  77.275   4.544  1.00  0.00           H  
ATOM    140  HZ2 LYS A  88      21.478  77.391   5.696  1.00  0.00           H  
ATOM    141  HZ3 LYS A  88      20.213  76.382   5.903  1.00  0.00           H  
ATOM    142  N   ALA A  89      18.567  74.919  11.012  1.00  0.00           N  
ATOM    143  CA  ALA A  89      17.763  73.756  10.623  1.00  0.00           C  
ATOM    144  C   ALA A  89      17.567  73.710   9.090  1.00  0.00           C  
ATOM    145  O   ALA A  89      17.166  74.701   8.472  1.00  0.00           O  
ATOM    146  CB  ALA A  89      16.431  73.792  11.382  1.00  0.00           C  
ATOM    147  H   ALA A  89      18.136  75.638  11.573  1.00  0.00           H  
ATOM    148  HA  ALA A  89      18.302  72.858  10.930  1.00  0.00           H  
ATOM    149  HB1 ALA A  89      15.842  72.910  11.127  1.00  0.00           H  
ATOM    150  HB2 ALA A  89      16.616  73.792  12.457  1.00  0.00           H  
ATOM    151  HB3 ALA A  89      15.869  74.687  11.111  1.00  0.00           H  
ATOM    152  N   GLY A  90      17.886  72.570   8.475  1.00  0.00           N  
ATOM    153  CA  GLY A  90      17.872  72.348   7.025  1.00  0.00           C  
ATOM    154  C   GLY A  90      19.244  72.486   6.341  1.00  0.00           C  
ATOM    155  O   GLY A  90      19.374  72.111   5.174  1.00  0.00           O  
ATOM    156  H   GLY A  90      18.168  71.780   9.046  1.00  0.00           H  
ATOM    157  HA2 GLY A  90      17.506  71.339   6.834  1.00  0.00           H  
ATOM    158  HA3 GLY A  90      17.187  73.050   6.548  1.00  0.00           H  
ATOM    159  N   GLU A  91      20.268  73.012   7.026  1.00  0.00           N  
ATOM    160  CA  GLU A  91      21.629  73.142   6.483  1.00  0.00           C  
ATOM    161  C   GLU A  91      22.301  71.774   6.284  1.00  0.00           C  
ATOM    162  O   GLU A  91      22.259  70.920   7.172  1.00  0.00           O  
ATOM    163  CB  GLU A  91      22.479  74.011   7.427  1.00  0.00           C  
ATOM    164  CG  GLU A  91      23.791  74.520   6.817  1.00  0.00           C  
ATOM    165  CD  GLU A  91      23.520  75.449   5.620  1.00  0.00           C  
ATOM    166  OE1 GLU A  91      23.150  76.629   5.840  1.00  0.00           O  
ATOM    167  OE2 GLU A  91      23.611  74.989   4.458  1.00  0.00           O  
ATOM    168  H   GLU A  91      20.115  73.293   7.988  1.00  0.00           H  
ATOM    169  HA  GLU A  91      21.561  73.632   5.510  1.00  0.00           H  
ATOM    170  HB2 GLU A  91      21.895  74.879   7.718  1.00  0.00           H  
ATOM    171  HB3 GLU A  91      22.708  73.444   8.328  1.00  0.00           H  
ATOM    172  HG2 GLU A  91      24.341  75.069   7.584  1.00  0.00           H  
ATOM    173  HG3 GLU A  91      24.410  73.674   6.515  1.00  0.00           H  
ATOM    174  N   GLU A  92      22.947  71.563   5.134  1.00  0.00           N  
ATOM    175  CA  GLU A  92      23.749  70.361   4.867  1.00  0.00           C  
ATOM    176  C   GLU A  92      25.138  70.464   5.530  1.00  0.00           C  
ATOM    177  O   GLU A  92      25.793  71.510   5.491  1.00  0.00           O  
ATOM    178  CB  GLU A  92      23.900  70.134   3.357  1.00  0.00           C  
ATOM    179  CG  GLU A  92      22.566  69.791   2.681  1.00  0.00           C  
ATOM    180  CD  GLU A  92      22.761  69.508   1.181  1.00  0.00           C  
ATOM    181  OE1 GLU A  92      22.691  70.460   0.366  1.00  0.00           O  
ATOM    182  OE2 GLU A  92      22.966  68.328   0.802  1.00  0.00           O  
ATOM    183  H   GLU A  92      22.992  72.317   4.462  1.00  0.00           H  
ATOM    184  HA  GLU A  92      23.233  69.492   5.282  1.00  0.00           H  
ATOM    185  HB2 GLU A  92      24.327  71.027   2.897  1.00  0.00           H  
ATOM    186  HB3 GLU A  92      24.586  69.303   3.199  1.00  0.00           H  
ATOM    187  HG2 GLU A  92      22.138  68.912   3.170  1.00  0.00           H  
ATOM    188  HG3 GLU A  92      21.866  70.620   2.811  1.00  0.00           H  
ATOM    189  N   VAL A  93      25.595  69.363   6.127  1.00  0.00           N  
ATOM    190  CA  VAL A  93      26.796  69.268   6.976  1.00  0.00           C  
ATOM    191  C   VAL A  93      27.486  67.905   6.815  1.00  0.00           C  
ATOM    192  O   VAL A  93      26.995  67.021   6.109  1.00  0.00           O  
ATOM    193  CB  VAL A  93      26.438  69.503   8.470  1.00  0.00           C  
ATOM    194  CG1 VAL A  93      25.985  70.942   8.740  1.00  0.00           C  
ATOM    195  CG2 VAL A  93      25.363  68.544   9.006  1.00  0.00           C  
ATOM    196  H   VAL A  93      25.043  68.516   6.028  1.00  0.00           H  
ATOM    197  HA  VAL A  93      27.517  70.029   6.679  1.00  0.00           H  
ATOM    198  HB  VAL A  93      27.334  69.351   9.070  1.00  0.00           H  
ATOM    199 HG11 VAL A  93      26.727  71.642   8.355  1.00  0.00           H  
ATOM    200 HG12 VAL A  93      25.023  71.138   8.267  1.00  0.00           H  
ATOM    201 HG13 VAL A  93      25.888  71.096   9.815  1.00  0.00           H  
ATOM    202 HG21 VAL A  93      25.212  68.724  10.070  1.00  0.00           H  
ATOM    203 HG22 VAL A  93      24.421  68.700   8.485  1.00  0.00           H  
ATOM    204 HG23 VAL A  93      25.683  67.512   8.874  1.00  0.00           H  
ATOM    205  N   LEU A  94      28.622  67.723   7.489  1.00  0.00           N  
ATOM    206  CA  LEU A  94      29.295  66.438   7.668  1.00  0.00           C  
ATOM    207  C   LEU A  94      29.225  66.056   9.149  1.00  0.00           C  
ATOM    208  O   LEU A  94      29.326  66.924  10.020  1.00  0.00           O  
ATOM    209  CB  LEU A  94      30.767  66.520   7.220  1.00  0.00           C  
ATOM    210  CG  LEU A  94      30.988  66.875   5.741  1.00  0.00           C  
ATOM    211  CD1 LEU A  94      32.483  66.993   5.452  1.00  0.00           C  
ATOM    212  CD2 LEU A  94      30.395  65.835   4.789  1.00  0.00           C  
ATOM    213  H   LEU A  94      28.972  68.494   8.049  1.00  0.00           H  
ATOM    214  HA  LEU A  94      28.788  65.665   7.095  1.00  0.00           H  
ATOM    215  HB2 LEU A  94      31.276  67.262   7.835  1.00  0.00           H  
ATOM    216  HB3 LEU A  94      31.236  65.558   7.417  1.00  0.00           H  
ATOM    217  HG  LEU A  94      30.530  67.837   5.541  1.00  0.00           H  
ATOM    218 HD11 LEU A  94      32.920  67.761   6.090  1.00  0.00           H  
ATOM    219 HD12 LEU A  94      32.977  66.039   5.644  1.00  0.00           H  
ATOM    220 HD13 LEU A  94      32.633  67.274   4.410  1.00  0.00           H  
ATOM    221 HD21 LEU A  94      30.623  66.106   3.758  1.00  0.00           H  
ATOM    222 HD22 LEU A  94      30.809  64.849   5.005  1.00  0.00           H  
ATOM    223 HD23 LEU A  94      29.314  65.809   4.905  1.00  0.00           H  
ATOM    224  N   ALA A  95      29.095  64.768   9.453  1.00  0.00           N  
ATOM    225  CA  ALA A  95      29.092  64.280  10.832  1.00  0.00           C  
ATOM    226  C   ALA A  95      29.765  62.906  10.948  1.00  0.00           C  
ATOM    227  O   ALA A  95      29.687  62.075  10.037  1.00  0.00           O  
ATOM    228  CB  ALA A  95      27.647  64.243  11.343  1.00  0.00           C  
ATOM    229  H   ALA A  95      28.988  64.097   8.702  1.00  0.00           H  
ATOM    230  HA  ALA A  95      29.658  64.970  11.457  1.00  0.00           H  
ATOM    231  HB1 ALA A  95      27.633  63.887  12.374  1.00  0.00           H  
ATOM    232  HB2 ALA A  95      27.215  65.243  11.308  1.00  0.00           H  
ATOM    233  HB3 ALA A  95      27.056  63.574  10.722  1.00  0.00           H  
ATOM    234  N   ARG A  96      30.428  62.679  12.086  1.00  0.00           N  
ATOM    235  CA  ARG A  96      30.964  61.374  12.487  1.00  0.00           C  
ATOM    236  C   ARG A  96      29.814  60.464  12.932  1.00  0.00           C  
ATOM    237  O   ARG A  96      28.888  60.917  13.608  1.00  0.00           O  
ATOM    238  CB  ARG A  96      31.996  61.600  13.607  1.00  0.00           C  
ATOM    239  CG  ARG A  96      32.755  60.322  13.999  1.00  0.00           C  
ATOM    240  CD  ARG A  96      33.831  60.650  15.040  1.00  0.00           C  
ATOM    241  NE  ARG A  96      34.590  59.448  15.437  1.00  0.00           N  
ATOM    242  CZ  ARG A  96      35.679  59.420  16.186  1.00  0.00           C  
ATOM    243  NH1 ARG A  96      36.201  60.503  16.694  1.00  0.00           N  
ATOM    244  NH2 ARG A  96      36.274  58.291  16.441  1.00  0.00           N  
ATOM    245  H   ARG A  96      30.418  63.421  12.781  1.00  0.00           H  
ATOM    246  HA  ARG A  96      31.462  60.912  11.631  1.00  0.00           H  
ATOM    247  HB2 ARG A  96      32.723  62.336  13.258  1.00  0.00           H  
ATOM    248  HB3 ARG A  96      31.494  62.003  14.487  1.00  0.00           H  
ATOM    249  HG2 ARG A  96      32.061  59.595  14.423  1.00  0.00           H  
ATOM    250  HG3 ARG A  96      33.229  59.895  13.114  1.00  0.00           H  
ATOM    251  HD2 ARG A  96      34.513  61.388  14.616  1.00  0.00           H  
ATOM    252  HD3 ARG A  96      33.350  61.085  15.919  1.00  0.00           H  
ATOM    253  HE  ARG A  96      34.242  58.556  15.124  1.00  0.00           H  
ATOM    254 HH11 ARG A  96      35.756  61.388  16.521  1.00  0.00           H  
ATOM    255 HH12 ARG A  96      37.030  60.454  17.262  1.00  0.00           H  
ATOM    256 HH21 ARG A  96      35.911  57.430  16.063  1.00  0.00           H  
ATOM    257 HH22 ARG A  96      37.103  58.273  17.011  1.00  0.00           H  
ATOM    258  N   TRP A  97      29.878  59.184  12.571  1.00  0.00           N  
ATOM    259  CA  TRP A  97      28.832  58.187  12.853  1.00  0.00           C  
ATOM    260  C   TRP A  97      29.387  57.003  13.675  1.00  0.00           C  
ATOM    261  O   TRP A  97      30.451  57.110  14.289  1.00  0.00           O  
ATOM    262  CB  TRP A  97      28.185  57.770  11.519  1.00  0.00           C  
ATOM    263  CG  TRP A  97      26.779  57.254  11.621  1.00  0.00           C  
ATOM    264  CD1 TRP A  97      26.375  55.988  11.369  1.00  0.00           C  
ATOM    265  CD2 TRP A  97      25.563  57.997  11.963  1.00  0.00           C  
ATOM    266  NE1 TRP A  97      25.006  55.890  11.547  1.00  0.00           N  
ATOM    267  CE2 TRP A  97      24.448  57.107  11.880  1.00  0.00           C  
ATOM    268  CE3 TRP A  97      25.283  59.337  12.315  1.00  0.00           C  
ATOM    269  CZ2 TRP A  97      23.130  57.532  12.106  1.00  0.00           C  
ATOM    270  CZ3 TRP A  97      23.958  59.780  12.499  1.00  0.00           C  
ATOM    271  CH2 TRP A  97      22.882  58.886  12.379  1.00  0.00           C  
ATOM    272  H   TRP A  97      30.672  58.888  12.013  1.00  0.00           H  
ATOM    273  HA  TRP A  97      28.050  58.642  13.462  1.00  0.00           H  
ATOM    274  HB2 TRP A  97      28.148  58.642  10.865  1.00  0.00           H  
ATOM    275  HB3 TRP A  97      28.820  57.033  11.021  1.00  0.00           H  
ATOM    276  HD1 TRP A  97      27.024  55.173  11.062  1.00  0.00           H  
ATOM    277  HE1 TRP A  97      24.487  55.030  11.407  1.00  0.00           H  
ATOM    278  HE3 TRP A  97      26.099  60.041  12.396  1.00  0.00           H  
ATOM    279  HZ2 TRP A  97      22.306  56.839  12.051  1.00  0.00           H  
ATOM    280  HZ3 TRP A  97      23.758  60.820  12.715  1.00  0.00           H  
ATOM    281  HH2 TRP A  97      21.867  59.239  12.502  1.00  0.00           H  
ATOM    282  N   THR A  98      28.670  55.873  13.714  1.00  0.00           N  
ATOM    283  CA  THR A  98      29.185  54.599  14.265  1.00  0.00           C  
ATOM    284  C   THR A  98      30.500  54.186  13.578  1.00  0.00           C  
ATOM    285  O   THR A  98      31.410  53.659  14.220  1.00  0.00           O  
ATOM    286  CB  THR A  98      28.137  53.482  14.115  1.00  0.00           C  
ATOM    287  OG1 THR A  98      26.869  53.917  14.563  1.00  0.00           O  
ATOM    288  CG2 THR A  98      28.483  52.227  14.915  1.00  0.00           C  
ATOM    289  H   THR A  98      27.759  55.864  13.274  1.00  0.00           H  
ATOM    290  HA  THR A  98      29.392  54.737  15.326  1.00  0.00           H  
ATOM    291  HB  THR A  98      28.051  53.215  13.061  1.00  0.00           H  
ATOM    292  HG1 THR A  98      26.942  54.084  15.512  1.00  0.00           H  
ATOM    293 HG21 THR A  98      27.673  51.500  14.827  1.00  0.00           H  
ATOM    294 HG22 THR A  98      29.392  51.773  14.522  1.00  0.00           H  
ATOM    295 HG23 THR A  98      28.632  52.477  15.966  1.00  0.00           H  
ATOM    296  N   ASP A  99      30.616  54.477  12.279  1.00  0.00           N  
ATOM    297  CA  ASP A  99      31.858  54.415  11.501  1.00  0.00           C  
ATOM    298  C   ASP A  99      32.615  55.756  11.635  1.00  0.00           C  
ATOM    299  O   ASP A  99      32.014  56.831  11.551  1.00  0.00           O  
ATOM    300  CB  ASP A  99      31.484  54.120  10.038  1.00  0.00           C  
ATOM    301  CG  ASP A  99      32.679  54.052   9.076  1.00  0.00           C  
ATOM    302  OD1 ASP A  99      33.831  53.825   9.511  1.00  0.00           O  
ATOM    303  OD2 ASP A  99      32.457  54.216   7.855  1.00  0.00           O  
ATOM    304  H   ASP A  99      29.826  54.919  11.833  1.00  0.00           H  
ATOM    305  HA  ASP A  99      32.494  53.608  11.869  1.00  0.00           H  
ATOM    306  HB2 ASP A  99      30.960  53.165   9.997  1.00  0.00           H  
ATOM    307  HB3 ASP A  99      30.795  54.892   9.688  1.00  0.00           H  
ATOM    308  N   CYS A 100      33.933  55.704  11.854  1.00  0.00           N  
ATOM    309  CA  CYS A 100      34.776  56.876  12.130  1.00  0.00           C  
ATOM    310  C   CYS A 100      34.890  57.877  10.962  1.00  0.00           C  
ATOM    311  O   CYS A 100      35.219  59.045  11.192  1.00  0.00           O  
ATOM    312  CB  CYS A 100      36.171  56.393  12.552  1.00  0.00           C  
ATOM    313  SG  CYS A 100      36.065  55.436  14.095  1.00  0.00           S  
ATOM    314  H   CYS A 100      34.373  54.794  11.883  1.00  0.00           H  
ATOM    315  HA  CYS A 100      34.335  57.424  12.963  1.00  0.00           H  
ATOM    316  HB2 CYS A 100      36.605  55.779  11.760  1.00  0.00           H  
ATOM    317  HB3 CYS A 100      36.819  57.259  12.712  1.00  0.00           H  
ATOM    318  HG  CYS A 100      37.365  55.107  14.168  1.00  0.00           H  
ATOM    319  N   ARG A 101      34.624  57.447   9.720  1.00  0.00           N  
ATOM    320  CA  ARG A 101      34.554  58.324   8.536  1.00  0.00           C  
ATOM    321  C   ARG A 101      33.408  59.339   8.653  1.00  0.00           C  
ATOM    322  O   ARG A 101      32.340  59.032   9.188  1.00  0.00           O  
ATOM    323  CB  ARG A 101      34.381  57.471   7.264  1.00  0.00           C  
ATOM    324  CG  ARG A 101      35.648  56.659   6.937  1.00  0.00           C  
ATOM    325  CD  ARG A 101      35.469  55.767   5.700  1.00  0.00           C  
ATOM    326  NE  ARG A 101      34.524  54.667   5.961  1.00  0.00           N  
ATOM    327  CZ  ARG A 101      34.305  53.596   5.228  1.00  0.00           C  
ATOM    328  NH1 ARG A 101      34.924  53.364   4.105  1.00  0.00           N  
ATOM    329  NH2 ARG A 101      33.433  52.727   5.643  1.00  0.00           N  
ATOM    330  H   ARG A 101      34.366  56.476   9.617  1.00  0.00           H  
ATOM    331  HA  ARG A 101      35.483  58.891   8.457  1.00  0.00           H  
ATOM    332  HB2 ARG A 101      33.531  56.802   7.396  1.00  0.00           H  
ATOM    333  HB3 ARG A 101      34.167  58.130   6.421  1.00  0.00           H  
ATOM    334  HG2 ARG A 101      36.469  57.351   6.748  1.00  0.00           H  
ATOM    335  HG3 ARG A 101      35.918  56.028   7.785  1.00  0.00           H  
ATOM    336  HD2 ARG A 101      35.116  56.372   4.864  1.00  0.00           H  
ATOM    337  HD3 ARG A 101      36.445  55.349   5.439  1.00  0.00           H  
ATOM    338  HE  ARG A 101      33.965  54.714   6.809  1.00  0.00           H  
ATOM    339 HH11 ARG A 101      35.601  54.030   3.770  1.00  0.00           H  
ATOM    340 HH12 ARG A 101      34.728  52.529   3.578  1.00  0.00           H  
ATOM    341 HH21 ARG A 101      32.931  52.950   6.498  1.00  0.00           H  
ATOM    342 HH22 ARG A 101      33.224  51.900   5.110  1.00  0.00           H  
ATOM    343  N   TYR A 102      33.618  60.543   8.120  1.00  0.00           N  
ATOM    344  CA  TYR A 102      32.556  61.543   7.955  1.00  0.00           C  
ATOM    345  C   TYR A 102      31.697  61.231   6.717  1.00  0.00           C  
ATOM    346  O   TYR A 102      32.185  60.667   5.731  1.00  0.00           O  
ATOM    347  CB  TYR A 102      33.174  62.946   7.840  1.00  0.00           C  
ATOM    348  CG  TYR A 102      33.812  63.442   9.127  1.00  0.00           C  
ATOM    349  CD1 TYR A 102      33.017  64.085  10.095  1.00  0.00           C  
ATOM    350  CD2 TYR A 102      35.185  63.244   9.366  1.00  0.00           C  
ATOM    351  CE1 TYR A 102      33.582  64.503  11.317  1.00  0.00           C  
ATOM    352  CE2 TYR A 102      35.758  63.667  10.581  1.00  0.00           C  
ATOM    353  CZ  TYR A 102      34.955  64.287  11.564  1.00  0.00           C  
ATOM    354  OH  TYR A 102      35.513  64.678  12.741  1.00  0.00           O  
ATOM    355  H   TYR A 102      34.509  60.722   7.686  1.00  0.00           H  
ATOM    356  HA  TYR A 102      31.907  61.517   8.835  1.00  0.00           H  
ATOM    357  HB2 TYR A 102      33.916  62.953   7.039  1.00  0.00           H  
ATOM    358  HB3 TYR A 102      32.392  63.650   7.559  1.00  0.00           H  
ATOM    359  HD1 TYR A 102      31.967  64.250   9.905  1.00  0.00           H  
ATOM    360  HD2 TYR A 102      35.803  62.758   8.620  1.00  0.00           H  
ATOM    361  HE1 TYR A 102      32.963  64.983  12.062  1.00  0.00           H  
ATOM    362  HE2 TYR A 102      36.810  63.513  10.774  1.00  0.00           H  
ATOM    363  HH  TYR A 102      34.865  65.081  13.331  1.00  0.00           H  
ATOM    364  N   TYR A 103      30.428  61.643   6.749  1.00  0.00           N  
ATOM    365  CA  TYR A 103      29.431  61.393   5.695  1.00  0.00           C  
ATOM    366  C   TYR A 103      28.513  62.609   5.483  1.00  0.00           C  
ATOM    367  O   TYR A 103      28.304  63.379   6.427  1.00  0.00           O  
ATOM    368  CB  TYR A 103      28.573  60.189   6.104  1.00  0.00           C  
ATOM    369  CG  TYR A 103      29.274  58.846   6.022  1.00  0.00           C  
ATOM    370  CD1 TYR A 103      29.359  58.179   4.785  1.00  0.00           C  
ATOM    371  CD2 TYR A 103      29.830  58.264   7.178  1.00  0.00           C  
ATOM    372  CE1 TYR A 103      29.997  56.928   4.703  1.00  0.00           C  
ATOM    373  CE2 TYR A 103      30.474  57.014   7.099  1.00  0.00           C  
ATOM    374  CZ  TYR A 103      30.558  56.343   5.859  1.00  0.00           C  
ATOM    375  OH  TYR A 103      31.173  55.137   5.758  1.00  0.00           O  
ATOM    376  H   TYR A 103      30.098  62.095   7.591  1.00  0.00           H  
ATOM    377  HA  TYR A 103      29.939  61.170   4.756  1.00  0.00           H  
ATOM    378  HB2 TYR A 103      28.225  60.353   7.121  1.00  0.00           H  
ATOM    379  HB3 TYR A 103      27.687  60.144   5.470  1.00  0.00           H  
ATOM    380  HD1 TYR A 103      28.932  58.624   3.895  1.00  0.00           H  
ATOM    381  HD2 TYR A 103      29.771  58.780   8.127  1.00  0.00           H  
ATOM    382  HE1 TYR A 103      30.063  56.408   3.758  1.00  0.00           H  
ATOM    383  HE2 TYR A 103      30.903  56.573   7.989  1.00  0.00           H  
ATOM    384  HH  TYR A 103      31.573  54.849   6.607  1.00  0.00           H  
ATOM    385  N   PRO A 104      27.926  62.779   4.278  1.00  0.00           N  
ATOM    386  CA  PRO A 104      26.974  63.852   4.000  1.00  0.00           C  
ATOM    387  C   PRO A 104      25.677  63.668   4.797  1.00  0.00           C  
ATOM    388  O   PRO A 104      25.057  62.598   4.796  1.00  0.00           O  
ATOM    389  CB  PRO A 104      26.740  63.821   2.486  1.00  0.00           C  
ATOM    390  CG  PRO A 104      27.019  62.369   2.106  1.00  0.00           C  
ATOM    391  CD  PRO A 104      28.114  61.954   3.089  1.00  0.00           C  
ATOM    392  HA  PRO A 104      27.414  64.813   4.264  1.00  0.00           H  
ATOM    393  HB2 PRO A 104      25.726  64.122   2.218  1.00  0.00           H  
ATOM    394  HB3 PRO A 104      27.467  64.469   1.996  1.00  0.00           H  
ATOM    395  HG2 PRO A 104      26.126  61.766   2.274  1.00  0.00           H  
ATOM    396  HG3 PRO A 104      27.351  62.277   1.071  1.00  0.00           H  
ATOM    397  HD2 PRO A 104      28.022  60.891   3.312  1.00  0.00           H  
ATOM    398  HD3 PRO A 104      29.093  62.162   2.655  1.00  0.00           H  
ATOM    399  N   ALA A 105      25.257  64.739   5.462  1.00  0.00           N  
ATOM    400  CA  ALA A 105      24.091  64.803   6.333  1.00  0.00           C  
ATOM    401  C   ALA A 105      23.442  66.199   6.265  1.00  0.00           C  
ATOM    402  O   ALA A 105      23.924  67.094   5.565  1.00  0.00           O  
ATOM    403  CB  ALA A 105      24.560  64.457   7.757  1.00  0.00           C  
ATOM    404  H   ALA A 105      25.830  65.575   5.422  1.00  0.00           H  
ATOM    405  HA  ALA A 105      23.348  64.070   6.016  1.00  0.00           H  
ATOM    406  HB1 ALA A 105      23.713  64.431   8.443  1.00  0.00           H  
ATOM    407  HB2 ALA A 105      25.037  63.478   7.755  1.00  0.00           H  
ATOM    408  HB3 ALA A 105      25.280  65.199   8.104  1.00  0.00           H  
ATOM    409  N   LYS A 106      22.362  66.407   7.021  1.00  0.00           N  
ATOM    410  CA  LYS A 106      21.732  67.719   7.231  1.00  0.00           C  
ATOM    411  C   LYS A 106      21.207  67.866   8.659  1.00  0.00           C  
ATOM    412  O   LYS A 106      20.865  66.875   9.305  1.00  0.00           O  
ATOM    413  CB  LYS A 106      20.623  67.964   6.190  1.00  0.00           C  
ATOM    414  CG  LYS A 106      19.520  66.898   6.240  1.00  0.00           C  
ATOM    415  CD  LYS A 106      18.365  67.217   5.288  1.00  0.00           C  
ATOM    416  CE  LYS A 106      17.313  66.113   5.423  1.00  0.00           C  
ATOM    417  NZ  LYS A 106      16.112  66.375   4.592  1.00  0.00           N  
ATOM    418  H   LYS A 106      21.978  65.608   7.519  1.00  0.00           H  
ATOM    419  HA  LYS A 106      22.489  68.491   7.100  1.00  0.00           H  
ATOM    420  HB2 LYS A 106      20.181  68.947   6.369  1.00  0.00           H  
ATOM    421  HB3 LYS A 106      21.065  67.970   5.193  1.00  0.00           H  
ATOM    422  HG2 LYS A 106      19.949  65.934   5.964  1.00  0.00           H  
ATOM    423  HG3 LYS A 106      19.123  66.834   7.252  1.00  0.00           H  
ATOM    424  HD2 LYS A 106      17.925  68.179   5.557  1.00  0.00           H  
ATOM    425  HD3 LYS A 106      18.731  67.257   4.260  1.00  0.00           H  
ATOM    426  HE2 LYS A 106      17.760  65.157   5.138  1.00  0.00           H  
ATOM    427  HE3 LYS A 106      17.015  66.041   6.474  1.00  0.00           H  
ATOM    428  HZ1 LYS A 106      15.433  65.636   4.716  1.00  0.00           H  
ATOM    429  HZ2 LYS A 106      15.669  67.243   4.859  1.00  0.00           H  
ATOM    430  HZ3 LYS A 106      16.346  66.425   3.609  1.00  0.00           H  
ATOM    431  N   ILE A 107      21.138  69.103   9.142  1.00  0.00           N  
ATOM    432  CA  ILE A 107      20.585  69.450  10.456  1.00  0.00           C  
ATOM    433  C   ILE A 107      19.053  69.377  10.407  1.00  0.00           C  
ATOM    434  O   ILE A 107      18.425  70.003   9.556  1.00  0.00           O  
ATOM    435  CB  ILE A 107      21.059  70.857  10.891  1.00  0.00           C  
ATOM    436  CG1 ILE A 107      22.604  70.961  10.868  1.00  0.00           C  
ATOM    437  CG2 ILE A 107      20.519  71.176  12.295  1.00  0.00           C  
ATOM    438  CD1 ILE A 107      23.143  72.350  11.229  1.00  0.00           C  
ATOM    439  H   ILE A 107      21.445  69.856   8.535  1.00  0.00           H  
ATOM    440  HA  ILE A 107      20.940  68.730  11.194  1.00  0.00           H  
ATOM    441  HB  ILE A 107      20.655  71.592  10.195  1.00  0.00           H  
ATOM    442 HG12 ILE A 107      23.030  70.227  11.553  1.00  0.00           H  
ATOM    443 HG13 ILE A 107      22.967  70.736   9.867  1.00  0.00           H  
ATOM    444 HG21 ILE A 107      19.431  71.151  12.312  1.00  0.00           H  
ATOM    445 HG22 ILE A 107      20.908  70.464  13.025  1.00  0.00           H  
ATOM    446 HG23 ILE A 107      20.818  72.180  12.579  1.00  0.00           H  
ATOM    447 HD11 ILE A 107      24.201  72.393  10.979  1.00  0.00           H  
ATOM    448 HD12 ILE A 107      22.621  73.119  10.662  1.00  0.00           H  
ATOM    449 HD13 ILE A 107      23.023  72.541  12.295  1.00  0.00           H  
ATOM    450  N   GLU A 108      18.448  68.662  11.351  1.00  0.00           N  
ATOM    451  CA  GLU A 108      16.992  68.598  11.544  1.00  0.00           C  
ATOM    452  C   GLU A 108      16.512  69.542  12.661  1.00  0.00           C  
ATOM    453  O   GLU A 108      15.421  70.109  12.553  1.00  0.00           O  
ATOM    454  CB  GLU A 108      16.585  67.155  11.890  1.00  0.00           C  
ATOM    455  CG  GLU A 108      16.742  66.169  10.725  1.00  0.00           C  
ATOM    456  CD  GLU A 108      15.743  66.471   9.590  1.00  0.00           C  
ATOM    457  OE1 GLU A 108      14.543  66.129   9.734  1.00  0.00           O  
ATOM    458  OE2 GLU A 108      16.146  67.064   8.562  1.00  0.00           O  
ATOM    459  H   GLU A 108      19.035  68.184  12.027  1.00  0.00           H  
ATOM    460  HA  GLU A 108      16.476  68.896  10.629  1.00  0.00           H  
ATOM    461  HB2 GLU A 108      17.197  66.812  12.722  1.00  0.00           H  
ATOM    462  HB3 GLU A 108      15.544  67.143  12.214  1.00  0.00           H  
ATOM    463  HG2 GLU A 108      17.769  66.197  10.353  1.00  0.00           H  
ATOM    464  HG3 GLU A 108      16.560  65.162  11.107  1.00  0.00           H  
ATOM    465  N   ALA A 109      17.322  69.743  13.709  1.00  0.00           N  
ATOM    466  CA  ALA A 109      17.045  70.664  14.818  1.00  0.00           C  
ATOM    467  C   ALA A 109      18.329  71.080  15.565  1.00  0.00           C  
ATOM    468  O   ALA A 109      19.343  70.378  15.526  1.00  0.00           O  
ATOM    469  CB  ALA A 109      16.055  69.996  15.788  1.00  0.00           C  
ATOM    470  H   ALA A 109      18.216  69.268  13.719  1.00  0.00           H  
ATOM    471  HA  ALA A 109      16.581  71.568  14.418  1.00  0.00           H  
ATOM    472  HB1 ALA A 109      15.749  70.715  16.547  1.00  0.00           H  
ATOM    473  HB2 ALA A 109      15.166  69.663  15.253  1.00  0.00           H  
ATOM    474  HB3 ALA A 109      16.521  69.140  16.274  1.00  0.00           H  
ATOM    475  N   ILE A 110      18.263  72.204  16.288  1.00  0.00           N  
ATOM    476  CA  ILE A 110      19.387  72.824  17.016  1.00  0.00           C  
ATOM    477  C   ILE A 110      18.933  73.169  18.441  1.00  0.00           C  
ATOM    478  O   ILE A 110      17.904  73.820  18.627  1.00  0.00           O  
ATOM    479  CB  ILE A 110      19.894  74.080  16.262  1.00  0.00           C  
ATOM    480  CG1 ILE A 110      20.431  73.681  14.867  1.00  0.00           C  
ATOM    481  CG2 ILE A 110      20.963  74.818  17.093  1.00  0.00           C  
ATOM    482  CD1 ILE A 110      20.995  74.832  14.029  1.00  0.00           C  
ATOM    483  H   ILE A 110      17.382  72.699  16.305  1.00  0.00           H  
ATOM    484  HA  ILE A 110      20.213  72.116  17.087  1.00  0.00           H  
ATOM    485  HB  ILE A 110      19.055  74.765  16.118  1.00  0.00           H  
ATOM    486 HG12 ILE A 110      21.203  72.921  14.978  1.00  0.00           H  
ATOM    487 HG13 ILE A 110      19.613  73.249  14.290  1.00  0.00           H  
ATOM    488 HG21 ILE A 110      20.532  75.191  18.022  1.00  0.00           H  
ATOM    489 HG22 ILE A 110      21.787  74.148  17.328  1.00  0.00           H  
ATOM    490 HG23 ILE A 110      21.342  75.687  16.556  1.00  0.00           H  
ATOM    491 HD11 ILE A 110      21.180  74.476  13.016  1.00  0.00           H  
ATOM    492 HD12 ILE A 110      20.274  75.649  13.996  1.00  0.00           H  
ATOM    493 HD13 ILE A 110      21.939  75.185  14.445  1.00  0.00           H  
ATOM    494  N   ASN A 111      19.700  72.719  19.440  1.00  0.00           N  
ATOM    495  CA  ASN A 111      19.443  72.835  20.890  1.00  0.00           C  
ATOM    496  C   ASN A 111      18.072  72.310  21.396  1.00  0.00           C  
ATOM    497  O   ASN A 111      17.773  72.437  22.587  1.00  0.00           O  
ATOM    498  CB  ASN A 111      19.728  74.282  21.347  1.00  0.00           C  
ATOM    499  CG  ASN A 111      21.161  74.733  21.098  1.00  0.00           C  
ATOM    500  OD1 ASN A 111      22.119  73.983  21.242  1.00  0.00           O  
ATOM    501  ND2 ASN A 111      21.358  75.977  20.722  1.00  0.00           N  
ATOM    502  H   ASN A 111      20.528  72.198  19.179  1.00  0.00           H  
ATOM    503  HA  ASN A 111      20.176  72.196  21.383  1.00  0.00           H  
ATOM    504  HB2 ASN A 111      19.041  74.960  20.840  1.00  0.00           H  
ATOM    505  HB3 ASN A 111      19.548  74.372  22.418  1.00  0.00           H  
ATOM    506 HD21 ASN A 111      20.576  76.607  20.612  1.00  0.00           H  
ATOM    507 HD22 ASN A 111      22.305  76.286  20.556  1.00  0.00           H  
ATOM    508  N   LYS A 112      17.250  71.692  20.534  1.00  0.00           N  
ATOM    509  CA  LYS A 112      15.889  71.192  20.829  1.00  0.00           C  
ATOM    510  C   LYS A 112      15.845  70.135  21.944  1.00  0.00           C  
ATOM    511  O   LYS A 112      14.848  70.023  22.659  1.00  0.00           O  
ATOM    512  CB  LYS A 112      15.287  70.670  19.509  1.00  0.00           C  
ATOM    513  CG  LYS A 112      13.808  70.248  19.558  1.00  0.00           C  
ATOM    514  CD  LYS A 112      12.855  71.400  19.914  1.00  0.00           C  
ATOM    515  CE  LYS A 112      11.401  70.928  19.801  1.00  0.00           C  
ATOM    516  NZ  LYS A 112      10.448  72.022  20.120  1.00  0.00           N  
ATOM    517  H   LYS A 112      17.569  71.628  19.578  1.00  0.00           H  
ATOM    518  HA  LYS A 112      15.294  72.036  21.178  1.00  0.00           H  
ATOM    519  HB2 LYS A 112      15.382  71.456  18.756  1.00  0.00           H  
ATOM    520  HB3 LYS A 112      15.873  69.814  19.171  1.00  0.00           H  
ATOM    521  HG2 LYS A 112      13.538  69.869  18.570  1.00  0.00           H  
ATOM    522  HG3 LYS A 112      13.680  69.435  20.272  1.00  0.00           H  
ATOM    523  HD2 LYS A 112      13.046  71.732  20.936  1.00  0.00           H  
ATOM    524  HD3 LYS A 112      13.021  72.231  19.228  1.00  0.00           H  
ATOM    525  HE2 LYS A 112      11.225  70.570  18.782  1.00  0.00           H  
ATOM    526  HE3 LYS A 112      11.246  70.090  20.485  1.00  0.00           H  
ATOM    527  HZ1 LYS A 112       9.490  71.704  20.040  1.00  0.00           H  
ATOM    528  HZ2 LYS A 112      10.579  72.360  21.063  1.00  0.00           H  
ATOM    529  HZ3 LYS A 112      10.561  72.804  19.489  1.00  0.00           H  
ATOM    530  N   GLU A 113      16.947  69.406  22.128  1.00  0.00           N  
ATOM    531  CA  GLU A 113      17.160  68.419  23.197  1.00  0.00           C  
ATOM    532  C   GLU A 113      18.607  68.516  23.739  1.00  0.00           C  
ATOM    533  O   GLU A 113      19.317  67.517  23.877  1.00  0.00           O  
ATOM    534  CB  GLU A 113      16.769  67.022  22.669  1.00  0.00           C  
ATOM    535  CG  GLU A 113      16.465  66.029  23.800  1.00  0.00           C  
ATOM    536  CD  GLU A 113      16.006  64.669  23.243  1.00  0.00           C  
ATOM    537  OE1 GLU A 113      14.821  64.538  22.849  1.00  0.00           O  
ATOM    538  OE2 GLU A 113      16.818  63.710  23.218  1.00  0.00           O  
ATOM    539  H   GLU A 113      17.686  69.543  21.457  1.00  0.00           H  
ATOM    540  HA  GLU A 113      16.499  68.662  24.031  1.00  0.00           H  
ATOM    541  HB2 GLU A 113      15.866  67.118  22.063  1.00  0.00           H  
ATOM    542  HB3 GLU A 113      17.560  66.630  22.028  1.00  0.00           H  
ATOM    543  HG2 GLU A 113      17.351  65.894  24.423  1.00  0.00           H  
ATOM    544  HG3 GLU A 113      15.677  66.446  24.432  1.00  0.00           H  
ATOM    545  N   GLY A 114      19.095  69.751  23.940  1.00  0.00           N  
ATOM    546  CA  GLY A 114      20.475  70.064  24.366  1.00  0.00           C  
ATOM    547  C   GLY A 114      21.575  69.584  23.400  1.00  0.00           C  
ATOM    548  O   GLY A 114      22.745  69.467  23.776  1.00  0.00           O  
ATOM    549  H   GLY A 114      18.468  70.532  23.788  1.00  0.00           H  
ATOM    550  HA2 GLY A 114      20.570  71.146  24.468  1.00  0.00           H  
ATOM    551  HA3 GLY A 114      20.657  69.612  25.340  1.00  0.00           H  
ATOM    552  N   THR A 115      21.187  69.272  22.163  1.00  0.00           N  
ATOM    553  CA  THR A 115      21.974  68.584  21.129  1.00  0.00           C  
ATOM    554  C   THR A 115      21.562  69.049  19.727  1.00  0.00           C  
ATOM    555  O   THR A 115      20.565  69.758  19.552  1.00  0.00           O  
ATOM    556  CB  THR A 115      21.774  67.053  21.225  1.00  0.00           C  
ATOM    557  OG1 THR A 115      20.406  66.719  21.324  1.00  0.00           O  
ATOM    558  CG2 THR A 115      22.462  66.421  22.433  1.00  0.00           C  
ATOM    559  H   THR A 115      20.218  69.443  21.936  1.00  0.00           H  
ATOM    560  HA  THR A 115      23.034  68.806  21.254  1.00  0.00           H  
ATOM    561  HB  THR A 115      22.184  66.583  20.331  1.00  0.00           H  
ATOM    562  HG1 THR A 115      20.132  66.922  22.234  1.00  0.00           H  
ATOM    563 HG21 THR A 115      22.352  65.337  22.388  1.00  0.00           H  
ATOM    564 HG22 THR A 115      23.521  66.663  22.413  1.00  0.00           H  
ATOM    565 HG23 THR A 115      22.027  66.784  23.363  1.00  0.00           H  
ATOM    566  N   PHE A 116      22.326  68.632  18.717  1.00  0.00           N  
ATOM    567  CA  PHE A 116      22.073  68.866  17.298  1.00  0.00           C  
ATOM    568  C   PHE A 116      21.509  67.582  16.679  1.00  0.00           C  
ATOM    569  O   PHE A 116      22.222  66.583  16.534  1.00  0.00           O  
ATOM    570  CB  PHE A 116      23.381  69.286  16.612  1.00  0.00           C  
ATOM    571  CG  PHE A 116      23.907  70.644  17.040  1.00  0.00           C  
ATOM    572  CD1 PHE A 116      24.585  70.789  18.267  1.00  0.00           C  
ATOM    573  CD2 PHE A 116      23.699  71.771  16.223  1.00  0.00           C  
ATOM    574  CE1 PHE A 116      25.024  72.058  18.686  1.00  0.00           C  
ATOM    575  CE2 PHE A 116      24.158  73.034  16.632  1.00  0.00           C  
ATOM    576  CZ  PHE A 116      24.813  73.181  17.867  1.00  0.00           C  
ATOM    577  H   PHE A 116      23.130  68.052  18.937  1.00  0.00           H  
ATOM    578  HA  PHE A 116      21.346  69.668  17.165  1.00  0.00           H  
ATOM    579  HB2 PHE A 116      24.146  68.537  16.820  1.00  0.00           H  
ATOM    580  HB3 PHE A 116      23.219  69.297  15.533  1.00  0.00           H  
ATOM    581  HD1 PHE A 116      24.757  69.928  18.899  1.00  0.00           H  
ATOM    582  HD2 PHE A 116      23.185  71.665  15.277  1.00  0.00           H  
ATOM    583  HE1 PHE A 116      25.516  72.173  19.642  1.00  0.00           H  
ATOM    584  HE2 PHE A 116      23.984  73.899  16.007  1.00  0.00           H  
ATOM    585  HZ  PHE A 116      25.150  74.157  18.190  1.00  0.00           H  
ATOM    586  N   THR A 117      20.218  67.582  16.350  1.00  0.00           N  
ATOM    587  CA  THR A 117      19.574  66.478  15.622  1.00  0.00           C  
ATOM    588  C   THR A 117      19.962  66.554  14.148  1.00  0.00           C  
ATOM    589  O   THR A 117      19.888  67.627  13.546  1.00  0.00           O  
ATOM    590  CB  THR A 117      18.045  66.526  15.763  1.00  0.00           C  
ATOM    591  OG1 THR A 117      17.693  66.645  17.126  1.00  0.00           O  
ATOM    592  CG2 THR A 117      17.372  65.250  15.255  1.00  0.00           C  
ATOM    593  H   THR A 117      19.689  68.435  16.478  1.00  0.00           H  
ATOM    594  HA  THR A 117      19.918  65.530  16.030  1.00  0.00           H  
ATOM    595  HB  THR A 117      17.656  67.383  15.215  1.00  0.00           H  
ATOM    596  HG1 THR A 117      16.730  66.688  17.171  1.00  0.00           H  
ATOM    597 HG21 THR A 117      16.290  65.332  15.372  1.00  0.00           H  
ATOM    598 HG22 THR A 117      17.593  65.099  14.199  1.00  0.00           H  
ATOM    599 HG23 THR A 117      17.730  64.387  15.814  1.00  0.00           H  
ATOM    600  N   VAL A 118      20.347  65.427  13.551  1.00  0.00           N  
ATOM    601  CA  VAL A 118      20.812  65.331  12.158  1.00  0.00           C  
ATOM    602  C   VAL A 118      20.217  64.113  11.447  1.00  0.00           C  
ATOM    603  O   VAL A 118      19.928  63.094  12.080  1.00  0.00           O  
ATOM    604  CB  VAL A 118      22.358  65.286  12.065  1.00  0.00           C  
ATOM    605  CG1 VAL A 118      23.002  66.607  12.503  1.00  0.00           C  
ATOM    606  CG2 VAL A 118      22.994  64.151  12.883  1.00  0.00           C  
ATOM    607  H   VAL A 118      20.357  64.572  14.101  1.00  0.00           H  
ATOM    608  HA  VAL A 118      20.473  66.210  11.615  1.00  0.00           H  
ATOM    609  HB  VAL A 118      22.627  65.130  11.020  1.00  0.00           H  
ATOM    610 HG11 VAL A 118      22.599  67.426  11.911  1.00  0.00           H  
ATOM    611 HG12 VAL A 118      22.810  66.795  13.558  1.00  0.00           H  
ATOM    612 HG13 VAL A 118      24.079  66.560  12.340  1.00  0.00           H  
ATOM    613 HG21 VAL A 118      24.070  64.138  12.711  1.00  0.00           H  
ATOM    614 HG22 VAL A 118      22.807  64.295  13.946  1.00  0.00           H  
ATOM    615 HG23 VAL A 118      22.587  63.189  12.573  1.00  0.00           H  
ATOM    616  N   GLN A 119      20.081  64.205  10.124  1.00  0.00           N  
ATOM    617  CA  GLN A 119      19.607  63.134   9.243  1.00  0.00           C  
ATOM    618  C   GLN A 119      20.651  62.833   8.161  1.00  0.00           C  
ATOM    619  O   GLN A 119      21.196  63.747   7.536  1.00  0.00           O  
ATOM    620  CB  GLN A 119      18.246  63.519   8.632  1.00  0.00           C  
ATOM    621  CG  GLN A 119      17.688  62.418   7.709  1.00  0.00           C  
ATOM    622  CD  GLN A 119      16.247  62.667   7.270  1.00  0.00           C  
ATOM    623  OE1 GLN A 119      15.890  63.724   6.765  1.00  0.00           O  
ATOM    624  NE2 GLN A 119      15.364  61.703   7.417  1.00  0.00           N  
ATOM    625  H   GLN A 119      20.350  65.081   9.685  1.00  0.00           H  
ATOM    626  HA  GLN A 119      19.463  62.230   9.833  1.00  0.00           H  
ATOM    627  HB2 GLN A 119      17.539  63.689   9.441  1.00  0.00           H  
ATOM    628  HB3 GLN A 119      18.351  64.445   8.063  1.00  0.00           H  
ATOM    629  HG2 GLN A 119      18.302  62.346   6.812  1.00  0.00           H  
ATOM    630  HG3 GLN A 119      17.738  61.463   8.229  1.00  0.00           H  
ATOM    631 HE21 GLN A 119      15.641  60.807   7.812  1.00  0.00           H  
ATOM    632 HE22 GLN A 119      14.416  61.870   7.121  1.00  0.00           H  
ATOM    633  N   PHE A 120      20.920  61.546   7.935  1.00  0.00           N  
ATOM    634  CA  PHE A 120      21.850  61.052   6.911  1.00  0.00           C  
ATOM    635  C   PHE A 120      21.123  60.730   5.594  1.00  0.00           C  
ATOM    636  O   PHE A 120      19.901  60.567   5.560  1.00  0.00           O  
ATOM    637  CB  PHE A 120      22.580  59.809   7.455  1.00  0.00           C  
ATOM    638  CG  PHE A 120      23.875  60.090   8.203  1.00  0.00           C  
ATOM    639  CD1 PHE A 120      23.976  61.158   9.116  1.00  0.00           C  
ATOM    640  CD2 PHE A 120      24.995  59.265   7.981  1.00  0.00           C  
ATOM    641  CE1 PHE A 120      25.194  61.426   9.763  1.00  0.00           C  
ATOM    642  CE2 PHE A 120      26.205  59.517   8.650  1.00  0.00           C  
ATOM    643  CZ  PHE A 120      26.315  60.614   9.521  1.00  0.00           C  
ATOM    644  H   PHE A 120      20.410  60.857   8.479  1.00  0.00           H  
ATOM    645  HA  PHE A 120      22.596  61.816   6.685  1.00  0.00           H  
ATOM    646  HB2 PHE A 120      21.912  59.251   8.110  1.00  0.00           H  
ATOM    647  HB3 PHE A 120      22.821  59.151   6.619  1.00  0.00           H  
ATOM    648  HD1 PHE A 120      23.124  61.787   9.328  1.00  0.00           H  
ATOM    649  HD2 PHE A 120      24.931  58.430   7.295  1.00  0.00           H  
ATOM    650  HE1 PHE A 120      25.259  62.248  10.460  1.00  0.00           H  
ATOM    651  HE2 PHE A 120      27.055  58.867   8.487  1.00  0.00           H  
ATOM    652  HZ  PHE A 120      27.250  60.817  10.024  1.00  0.00           H  
ATOM    653  N   TYR A 121      21.889  60.582   4.508  1.00  0.00           N  
ATOM    654  CA  TYR A 121      21.396  60.208   3.172  1.00  0.00           C  
ATOM    655  C   TYR A 121      20.586  58.890   3.137  1.00  0.00           C  
ATOM    656  O   TYR A 121      19.707  58.723   2.290  1.00  0.00           O  
ATOM    657  CB  TYR A 121      22.585  60.145   2.199  1.00  0.00           C  
ATOM    658  CG  TYR A 121      23.587  59.036   2.489  1.00  0.00           C  
ATOM    659  CD1 TYR A 121      24.665  59.261   3.368  1.00  0.00           C  
ATOM    660  CD2 TYR A 121      23.423  57.768   1.893  1.00  0.00           C  
ATOM    661  CE1 TYR A 121      25.569  58.222   3.661  1.00  0.00           C  
ATOM    662  CE2 TYR A 121      24.327  56.726   2.181  1.00  0.00           C  
ATOM    663  CZ  TYR A 121      25.404  56.952   3.068  1.00  0.00           C  
ATOM    664  OH  TYR A 121      26.280  55.952   3.350  1.00  0.00           O  
ATOM    665  H   TYR A 121      22.882  60.742   4.607  1.00  0.00           H  
ATOM    666  HA  TYR A 121      20.727  60.999   2.830  1.00  0.00           H  
ATOM    667  HB2 TYR A 121      22.198  60.011   1.189  1.00  0.00           H  
ATOM    668  HB3 TYR A 121      23.105  61.104   2.217  1.00  0.00           H  
ATOM    669  HD1 TYR A 121      24.803  60.233   3.822  1.00  0.00           H  
ATOM    670  HD2 TYR A 121      22.595  57.588   1.219  1.00  0.00           H  
ATOM    671  HE1 TYR A 121      26.393  58.388   4.340  1.00  0.00           H  
ATOM    672  HE2 TYR A 121      24.196  55.755   1.726  1.00  0.00           H  
ATOM    673  HH  TYR A 121      26.056  55.140   2.880  1.00  0.00           H  
ATOM    674  N   ASP A 122      20.854  57.963   4.065  1.00  0.00           N  
ATOM    675  CA  ASP A 122      20.112  56.706   4.245  1.00  0.00           C  
ATOM    676  C   ASP A 122      18.675  56.904   4.783  1.00  0.00           C  
ATOM    677  O   ASP A 122      17.815  56.040   4.599  1.00  0.00           O  
ATOM    678  CB  ASP A 122      20.926  55.816   5.195  1.00  0.00           C  
ATOM    679  CG  ASP A 122      20.307  54.422   5.383  1.00  0.00           C  
ATOM    680  OD1 ASP A 122      20.348  53.609   4.427  1.00  0.00           O  
ATOM    681  OD2 ASP A 122      19.808  54.127   6.495  1.00  0.00           O  
ATOM    682  H   ASP A 122      21.626  58.146   4.690  1.00  0.00           H  
ATOM    683  HA  ASP A 122      20.037  56.201   3.280  1.00  0.00           H  
ATOM    684  HB2 ASP A 122      21.935  55.700   4.793  1.00  0.00           H  
ATOM    685  HB3 ASP A 122      21.011  56.314   6.163  1.00  0.00           H  
ATOM    686  N   GLY A 123      18.407  58.038   5.442  1.00  0.00           N  
ATOM    687  CA  GLY A 123      17.113  58.409   6.032  1.00  0.00           C  
ATOM    688  C   GLY A 123      17.099  58.385   7.568  1.00  0.00           C  
ATOM    689  O   GLY A 123      16.248  59.038   8.178  1.00  0.00           O  
ATOM    690  H   GLY A 123      19.146  58.731   5.498  1.00  0.00           H  
ATOM    691  HA2 GLY A 123      16.857  59.417   5.704  1.00  0.00           H  
ATOM    692  HA3 GLY A 123      16.334  57.734   5.679  1.00  0.00           H  
ATOM    693  N   VAL A 124      18.039  57.665   8.197  1.00  0.00           N  
ATOM    694  CA  VAL A 124      18.210  57.573   9.662  1.00  0.00           C  
ATOM    695  C   VAL A 124      18.436  58.945  10.318  1.00  0.00           C  
ATOM    696  O   VAL A 124      19.088  59.819   9.740  1.00  0.00           O  
ATOM    697  CB  VAL A 124      19.342  56.578  10.010  1.00  0.00           C  
ATOM    698  CG1 VAL A 124      20.728  57.023   9.523  1.00  0.00           C  
ATOM    699  CG2 VAL A 124      19.422  56.277  11.513  1.00  0.00           C  
ATOM    700  H   VAL A 124      18.690  57.160   7.615  1.00  0.00           H  
ATOM    701  HA  VAL A 124      17.285  57.165  10.070  1.00  0.00           H  
ATOM    702  HB  VAL A 124      19.109  55.636   9.512  1.00  0.00           H  
ATOM    703 HG11 VAL A 124      20.708  57.205   8.450  1.00  0.00           H  
ATOM    704 HG12 VAL A 124      21.041  57.934  10.038  1.00  0.00           H  
ATOM    705 HG13 VAL A 124      21.457  56.238   9.723  1.00  0.00           H  
ATOM    706 HG21 VAL A 124      20.120  55.457  11.684  1.00  0.00           H  
ATOM    707 HG22 VAL A 124      19.770  57.150  12.065  1.00  0.00           H  
ATOM    708 HG23 VAL A 124      18.441  55.977  11.883  1.00  0.00           H  
ATOM    709  N   ILE A 125      17.921  59.116  11.542  1.00  0.00           N  
ATOM    710  CA  ILE A 125      17.984  60.357  12.332  1.00  0.00           C  
ATOM    711  C   ILE A 125      18.530  60.045  13.734  1.00  0.00           C  
ATOM    712  O   ILE A 125      18.039  59.133  14.406  1.00  0.00           O  
ATOM    713  CB  ILE A 125      16.594  61.041  12.426  1.00  0.00           C  
ATOM    714  CG1 ILE A 125      15.945  61.223  11.034  1.00  0.00           C  
ATOM    715  CG2 ILE A 125      16.714  62.399  13.148  1.00  0.00           C  
ATOM    716  CD1 ILE A 125      14.594  61.951  11.034  1.00  0.00           C  
ATOM    717  H   ILE A 125      17.431  58.336  11.958  1.00  0.00           H  
ATOM    718  HA  ILE A 125      18.666  61.049  11.841  1.00  0.00           H  
ATOM    719  HB  ILE A 125      15.937  60.402  13.020  1.00  0.00           H  
ATOM    720 HG12 ILE A 125      16.633  61.766  10.390  1.00  0.00           H  
ATOM    721 HG13 ILE A 125      15.774  60.240  10.594  1.00  0.00           H  
ATOM    722 HG21 ILE A 125      17.185  62.285  14.123  1.00  0.00           H  
ATOM    723 HG22 ILE A 125      17.301  63.093  12.545  1.00  0.00           H  
ATOM    724 HG23 ILE A 125      15.727  62.827  13.324  1.00  0.00           H  
ATOM    725 HD11 ILE A 125      14.146  61.878  10.044  1.00  0.00           H  
ATOM    726 HD12 ILE A 125      13.924  61.490  11.761  1.00  0.00           H  
ATOM    727 HD13 ILE A 125      14.729  63.005  11.273  1.00  0.00           H  
ATOM    728  N   ARG A 126      19.528  60.816  14.181  1.00  0.00           N  
ATOM    729  CA  ARG A 126      20.147  60.754  15.523  1.00  0.00           C  
ATOM    730  C   ARG A 126      20.493  62.160  16.037  1.00  0.00           C  
ATOM    731  O   ARG A 126      20.378  63.141  15.303  1.00  0.00           O  
ATOM    732  CB  ARG A 126      21.408  59.856  15.484  1.00  0.00           C  
ATOM    733  CG  ARG A 126      21.153  58.352  15.281  1.00  0.00           C  
ATOM    734  CD  ARG A 126      20.391  57.715  16.450  1.00  0.00           C  
ATOM    735  NE  ARG A 126      20.254  56.257  16.276  1.00  0.00           N  
ATOM    736  CZ  ARG A 126      19.758  55.405  17.156  1.00  0.00           C  
ATOM    737  NH1 ARG A 126      19.320  55.784  18.324  1.00  0.00           N  
ATOM    738  NH2 ARG A 126      19.695  54.134  16.876  1.00  0.00           N  
ATOM    739  H   ARG A 126      19.844  61.558  13.563  1.00  0.00           H  
ATOM    740  HA  ARG A 126      19.432  60.343  16.239  1.00  0.00           H  
ATOM    741  HB2 ARG A 126      22.058  60.205  14.683  1.00  0.00           H  
ATOM    742  HB3 ARG A 126      21.965  59.963  16.415  1.00  0.00           H  
ATOM    743  HG2 ARG A 126      20.602  58.186  14.353  1.00  0.00           H  
ATOM    744  HG3 ARG A 126      22.120  57.855  15.188  1.00  0.00           H  
ATOM    745  HD2 ARG A 126      20.938  57.920  17.373  1.00  0.00           H  
ATOM    746  HD3 ARG A 126      19.398  58.161  16.521  1.00  0.00           H  
ATOM    747  HE  ARG A 126      20.563  55.864  15.400  1.00  0.00           H  
ATOM    748 HH11 ARG A 126      19.354  56.760  18.567  1.00  0.00           H  
ATOM    749 HH12 ARG A 126      18.952  55.111  18.977  1.00  0.00           H  
ATOM    750 HH21 ARG A 126      20.025  53.798  15.985  1.00  0.00           H  
ATOM    751 HH22 ARG A 126      19.320  53.484  17.547  1.00  0.00           H  
ATOM    752  N   CYS A 127      20.940  62.254  17.288  1.00  0.00           N  
ATOM    753  CA  CYS A 127      21.341  63.504  17.945  1.00  0.00           C  
ATOM    754  C   CYS A 127      22.809  63.426  18.392  1.00  0.00           C  
ATOM    755  O   CYS A 127      23.260  62.394  18.899  1.00  0.00           O  
ATOM    756  CB  CYS A 127      20.416  63.766  19.145  1.00  0.00           C  
ATOM    757  SG  CYS A 127      18.671  63.877  18.641  1.00  0.00           S  
ATOM    758  H   CYS A 127      21.024  61.404  17.822  1.00  0.00           H  
ATOM    759  HA  CYS A 127      21.250  64.337  17.252  1.00  0.00           H  
ATOM    760  HB2 CYS A 127      20.528  62.955  19.867  1.00  0.00           H  
ATOM    761  HB3 CYS A 127      20.707  64.698  19.633  1.00  0.00           H  
ATOM    762  HG  CYS A 127      18.721  65.080  18.041  1.00  0.00           H  
ATOM    763  N   LEU A 128      23.551  64.522  18.211  1.00  0.00           N  
ATOM    764  CA  LEU A 128      24.997  64.622  18.451  1.00  0.00           C  
ATOM    765  C   LEU A 128      25.375  65.972  19.084  1.00  0.00           C  
ATOM    766  O   LEU A 128      24.583  66.919  19.110  1.00  0.00           O  
ATOM    767  CB  LEU A 128      25.734  64.463  17.100  1.00  0.00           C  
ATOM    768  CG  LEU A 128      25.710  63.063  16.458  1.00  0.00           C  
ATOM    769  CD1 LEU A 128      26.366  63.129  15.076  1.00  0.00           C  
ATOM    770  CD2 LEU A 128      26.469  62.032  17.293  1.00  0.00           C  
ATOM    771  H   LEU A 128      23.107  65.326  17.779  1.00  0.00           H  
ATOM    772  HA  LEU A 128      25.319  63.842  19.141  1.00  0.00           H  
ATOM    773  HB2 LEU A 128      25.286  65.164  16.397  1.00  0.00           H  
ATOM    774  HB3 LEU A 128      26.779  64.752  17.225  1.00  0.00           H  
ATOM    775  HG  LEU A 128      24.680  62.733  16.328  1.00  0.00           H  
ATOM    776 HD11 LEU A 128      25.835  63.845  14.450  1.00  0.00           H  
ATOM    777 HD12 LEU A 128      27.409  63.434  15.163  1.00  0.00           H  
ATOM    778 HD13 LEU A 128      26.320  62.148  14.599  1.00  0.00           H  
ATOM    779 HD21 LEU A 128      26.476  61.074  16.773  1.00  0.00           H  
ATOM    780 HD22 LEU A 128      27.496  62.359  17.454  1.00  0.00           H  
ATOM    781 HD23 LEU A 128      25.976  61.894  18.254  1.00  0.00           H  
ATOM    782  N   LYS A 129      26.612  66.069  19.580  1.00  0.00           N  
ATOM    783  CA  LYS A 129      27.237  67.334  20.002  1.00  0.00           C  
ATOM    784  C   LYS A 129      27.928  68.004  18.809  1.00  0.00           C  
ATOM    785  O   LYS A 129      28.383  67.328  17.885  1.00  0.00           O  
ATOM    786  CB  LYS A 129      28.269  67.060  21.117  1.00  0.00           C  
ATOM    787  CG  LYS A 129      27.690  66.421  22.395  1.00  0.00           C  
ATOM    788  CD  LYS A 129      26.531  67.180  23.062  1.00  0.00           C  
ATOM    789  CE  LYS A 129      26.927  68.580  23.548  1.00  0.00           C  
ATOM    790  NZ  LYS A 129      25.823  69.222  24.313  1.00  0.00           N  
ATOM    791  H   LYS A 129      27.203  65.251  19.521  1.00  0.00           H  
ATOM    792  HA  LYS A 129      26.475  68.021  20.372  1.00  0.00           H  
ATOM    793  HB2 LYS A 129      29.038  66.391  20.727  1.00  0.00           H  
ATOM    794  HB3 LYS A 129      28.765  67.995  21.381  1.00  0.00           H  
ATOM    795  HG2 LYS A 129      27.340  65.417  22.154  1.00  0.00           H  
ATOM    796  HG3 LYS A 129      28.499  66.315  23.121  1.00  0.00           H  
ATOM    797  HD2 LYS A 129      25.701  67.261  22.362  1.00  0.00           H  
ATOM    798  HD3 LYS A 129      26.194  66.591  23.919  1.00  0.00           H  
ATOM    799  HE2 LYS A 129      27.812  68.492  24.187  1.00  0.00           H  
ATOM    800  HE3 LYS A 129      27.191  69.197  22.686  1.00  0.00           H  
ATOM    801  HZ1 LYS A 129      26.083  70.151  24.614  1.00  0.00           H  
ATOM    802  HZ2 LYS A 129      24.972  69.301  23.767  1.00  0.00           H  
ATOM    803  HZ3 LYS A 129      25.598  68.689  25.143  1.00  0.00           H  
ATOM    804  N   ARG A 130      28.113  69.328  18.884  1.00  0.00           N  
ATOM    805  CA  ARG A 130      28.919  70.120  17.928  1.00  0.00           C  
ATOM    806  C   ARG A 130      30.334  69.574  17.684  1.00  0.00           C  
ATOM    807  O   ARG A 130      30.877  69.736  16.596  1.00  0.00           O  
ATOM    808  CB  ARG A 130      28.955  71.605  18.344  1.00  0.00           C  
ATOM    809  CG  ARG A 130      29.860  71.959  19.541  1.00  0.00           C  
ATOM    810  CD  ARG A 130      29.324  71.501  20.905  1.00  0.00           C  
ATOM    811  NE  ARG A 130      30.171  71.982  22.015  1.00  0.00           N  
ATOM    812  CZ  ARG A 130      30.104  73.154  22.627  1.00  0.00           C  
ATOM    813  NH1 ARG A 130      29.243  74.073  22.291  1.00  0.00           N  
ATOM    814  NH2 ARG A 130      30.917  73.428  23.606  1.00  0.00           N  
ATOM    815  H   ARG A 130      27.663  69.813  19.648  1.00  0.00           H  
ATOM    816  HA  ARG A 130      28.417  70.069  16.959  1.00  0.00           H  
ATOM    817  HB2 ARG A 130      29.321  72.172  17.484  1.00  0.00           H  
ATOM    818  HB3 ARG A 130      27.941  71.952  18.542  1.00  0.00           H  
ATOM    819  HG2 ARG A 130      30.851  71.531  19.384  1.00  0.00           H  
ATOM    820  HG3 ARG A 130      29.968  73.044  19.561  1.00  0.00           H  
ATOM    821  HD2 ARG A 130      28.300  71.855  21.034  1.00  0.00           H  
ATOM    822  HD3 ARG A 130      29.312  70.412  20.939  1.00  0.00           H  
ATOM    823  HE  ARG A 130      30.876  71.349  22.362  1.00  0.00           H  
ATOM    824 HH11 ARG A 130      28.604  73.901  21.534  1.00  0.00           H  
ATOM    825 HH12 ARG A 130      29.222  74.954  22.780  1.00  0.00           H  
ATOM    826 HH21 ARG A 130      31.602  72.750  23.903  1.00  0.00           H  
ATOM    827 HH22 ARG A 130      30.865  74.320  24.071  1.00  0.00           H  
ATOM    828  N   MET A 131      30.913  68.895  18.681  1.00  0.00           N  
ATOM    829  CA  MET A 131      32.239  68.262  18.622  1.00  0.00           C  
ATOM    830  C   MET A 131      32.319  67.068  17.645  1.00  0.00           C  
ATOM    831  O   MET A 131      33.417  66.596  17.344  1.00  0.00           O  
ATOM    832  CB  MET A 131      32.652  67.824  20.038  1.00  0.00           C  
ATOM    833  CG  MET A 131      32.826  69.023  20.982  1.00  0.00           C  
ATOM    834  SD  MET A 131      33.165  68.594  22.714  1.00  0.00           S  
ATOM    835  CE  MET A 131      34.837  67.899  22.575  1.00  0.00           C  
ATOM    836  H   MET A 131      30.395  68.818  19.543  1.00  0.00           H  
ATOM    837  HA  MET A 131      32.961  69.002  18.271  1.00  0.00           H  
ATOM    838  HB2 MET A 131      31.891  67.156  20.446  1.00  0.00           H  
ATOM    839  HB3 MET A 131      33.596  67.282  19.985  1.00  0.00           H  
ATOM    840  HG2 MET A 131      33.638  69.650  20.610  1.00  0.00           H  
ATOM    841  HG3 MET A 131      31.915  69.618  20.970  1.00  0.00           H  
ATOM    842  HE1 MET A 131      35.209  67.651  23.568  1.00  0.00           H  
ATOM    843  HE2 MET A 131      34.820  66.994  21.968  1.00  0.00           H  
ATOM    844  HE3 MET A 131      35.504  68.631  22.117  1.00  0.00           H  
ATOM    845  N   HIS A 132      31.175  66.597  17.129  1.00  0.00           N  
ATOM    846  CA  HIS A 132      31.065  65.467  16.182  1.00  0.00           C  
ATOM    847  C   HIS A 132      30.475  65.865  14.813  1.00  0.00           C  
ATOM    848  O   HIS A 132      30.206  64.999  13.976  1.00  0.00           O  
ATOM    849  CB  HIS A 132      30.288  64.307  16.830  1.00  0.00           C  
ATOM    850  CG  HIS A 132      31.067  63.608  17.919  1.00  0.00           C  
ATOM    851  ND1 HIS A 132      31.667  62.349  17.813  1.00  0.00           N  
ATOM    852  CD2 HIS A 132      31.338  64.122  19.151  1.00  0.00           C  
ATOM    853  CE1 HIS A 132      32.281  62.134  18.991  1.00  0.00           C  
ATOM    854  NE2 HIS A 132      32.098  63.183  19.812  1.00  0.00           N  
ATOM    855  H   HIS A 132      30.314  67.031  17.456  1.00  0.00           H  
ATOM    856  HA  HIS A 132      32.065  65.086  15.978  1.00  0.00           H  
ATOM    857  HB2 HIS A 132      29.346  64.676  17.236  1.00  0.00           H  
ATOM    858  HB3 HIS A 132      30.058  63.556  16.073  1.00  0.00           H  
ATOM    859  HD2 HIS A 132      31.031  65.094  19.507  1.00  0.00           H  
ATOM    860  HE1 HIS A 132      32.845  61.243  19.244  1.00  0.00           H  
ATOM    861  HE2 HIS A 132      32.471  63.259  20.755  1.00  0.00           H  
ATOM    862  N   ILE A 133      30.303  67.169  14.562  1.00  0.00           N  
ATOM    863  CA  ILE A 133      29.707  67.750  13.343  1.00  0.00           C  
ATOM    864  C   ILE A 133      30.656  68.823  12.777  1.00  0.00           C  
ATOM    865  O   ILE A 133      31.314  69.548  13.529  1.00  0.00           O  
ATOM    866  CB  ILE A 133      28.302  68.338  13.646  1.00  0.00           C  
ATOM    867  CG1 ILE A 133      27.355  67.283  14.275  1.00  0.00           C  
ATOM    868  CG2 ILE A 133      27.654  68.922  12.372  1.00  0.00           C  
ATOM    869  CD1 ILE A 133      26.008  67.855  14.737  1.00  0.00           C  
ATOM    870  H   ILE A 133      30.610  67.823  15.270  1.00  0.00           H  
ATOM    871  HA  ILE A 133      29.593  66.972  12.590  1.00  0.00           H  
ATOM    872  HB  ILE A 133      28.424  69.151  14.365  1.00  0.00           H  
ATOM    873 HG12 ILE A 133      27.176  66.480  13.561  1.00  0.00           H  
ATOM    874 HG13 ILE A 133      27.824  66.849  15.156  1.00  0.00           H  
ATOM    875 HG21 ILE A 133      28.266  69.719  11.953  1.00  0.00           H  
ATOM    876 HG22 ILE A 133      27.521  68.139  11.625  1.00  0.00           H  
ATOM    877 HG23 ILE A 133      26.685  69.362  12.596  1.00  0.00           H  
ATOM    878 HD11 ILE A 133      25.465  67.095  15.292  1.00  0.00           H  
ATOM    879 HD12 ILE A 133      26.177  68.716  15.385  1.00  0.00           H  
ATOM    880 HD13 ILE A 133      25.397  68.149  13.885  1.00  0.00           H  
ATOM    881  N   LYS A 134      30.725  68.941  11.446  1.00  0.00           N  
ATOM    882  CA  LYS A 134      31.564  69.899  10.708  1.00  0.00           C  
ATOM    883  C   LYS A 134      30.804  70.494   9.519  1.00  0.00           C  
ATOM    884  O   LYS A 134      29.958  69.835   8.914  1.00  0.00           O  
ATOM    885  CB  LYS A 134      32.841  69.203  10.190  1.00  0.00           C  
ATOM    886  CG  LYS A 134      33.716  68.574  11.291  1.00  0.00           C  
ATOM    887  CD  LYS A 134      34.960  67.862  10.731  1.00  0.00           C  
ATOM    888  CE  LYS A 134      35.954  68.780  10.000  1.00  0.00           C  
ATOM    889  NZ  LYS A 134      36.601  69.755  10.917  1.00  0.00           N  
ATOM    890  H   LYS A 134      30.141  68.315  10.896  1.00  0.00           H  
ATOM    891  HA  LYS A 134      31.853  70.721  11.366  1.00  0.00           H  
ATOM    892  HB2 LYS A 134      32.552  68.426   9.481  1.00  0.00           H  
ATOM    893  HB3 LYS A 134      33.434  69.942   9.651  1.00  0.00           H  
ATOM    894  HG2 LYS A 134      34.021  69.347  11.997  1.00  0.00           H  
ATOM    895  HG3 LYS A 134      33.134  67.829  11.832  1.00  0.00           H  
ATOM    896  HD2 LYS A 134      35.479  67.364  11.551  1.00  0.00           H  
ATOM    897  HD3 LYS A 134      34.633  67.089  10.033  1.00  0.00           H  
ATOM    898  HE2 LYS A 134      36.722  68.152   9.539  1.00  0.00           H  
ATOM    899  HE3 LYS A 134      35.434  69.306   9.196  1.00  0.00           H  
ATOM    900  HZ1 LYS A 134      37.269  70.329  10.419  1.00  0.00           H  
ATOM    901  HZ2 LYS A 134      35.925  70.373  11.342  1.00  0.00           H  
ATOM    902  HZ3 LYS A 134      37.102  69.283  11.659  1.00  0.00           H  
ATOM    903  N   ALA A 135      31.134  71.729   9.146  1.00  0.00           N  
ATOM    904  CA  ALA A 135      30.664  72.329   7.897  1.00  0.00           C  
ATOM    905  C   ALA A 135      31.352  71.644   6.699  1.00  0.00           C  
ATOM    906  O   ALA A 135      32.576  71.465   6.705  1.00  0.00           O  
ATOM    907  CB  ALA A 135      30.957  73.835   7.934  1.00  0.00           C  
ATOM    908  H   ALA A 135      31.865  72.196   9.659  1.00  0.00           H  
ATOM    909  HA  ALA A 135      29.584  72.188   7.814  1.00  0.00           H  
ATOM    910  HB1 ALA A 135      30.601  74.297   7.013  1.00  0.00           H  
ATOM    911  HB2 ALA A 135      30.441  74.292   8.780  1.00  0.00           H  
ATOM    912  HB3 ALA A 135      32.030  74.010   8.029  1.00  0.00           H  
ATOM    913  N   MET A 136      30.588  71.251   5.675  1.00  0.00           N  
ATOM    914  CA  MET A 136      31.158  70.667   4.453  1.00  0.00           C  
ATOM    915  C   MET A 136      31.938  71.719   3.624  1.00  0.00           C  
ATOM    916  O   MET A 136      31.624  72.914   3.700  1.00  0.00           O  
ATOM    917  CB  MET A 136      30.060  69.949   3.645  1.00  0.00           C  
ATOM    918  CG  MET A 136      29.097  70.867   2.891  1.00  0.00           C  
ATOM    919  SD  MET A 136      27.903  70.026   1.801  1.00  0.00           S  
ATOM    920  CE  MET A 136      27.390  68.608   2.814  1.00  0.00           C  
ATOM    921  H   MET A 136      29.595  71.430   5.708  1.00  0.00           H  
ATOM    922  HA  MET A 136      31.868  69.902   4.768  1.00  0.00           H  
ATOM    923  HB2 MET A 136      30.517  69.273   2.928  1.00  0.00           H  
ATOM    924  HB3 MET A 136      29.480  69.342   4.338  1.00  0.00           H  
ATOM    925  HG2 MET A 136      28.554  71.446   3.632  1.00  0.00           H  
ATOM    926  HG3 MET A 136      29.668  71.562   2.276  1.00  0.00           H  
ATOM    927  HE1 MET A 136      26.589  68.068   2.310  1.00  0.00           H  
ATOM    928  HE2 MET A 136      28.233  67.932   2.958  1.00  0.00           H  
ATOM    929  HE3 MET A 136      27.035  68.956   3.784  1.00  0.00           H  
ATOM    930  N   PRO A 137      32.942  71.307   2.826  1.00  0.00           N  
ATOM    931  CA  PRO A 137      33.720  72.209   1.976  1.00  0.00           C  
ATOM    932  C   PRO A 137      32.904  72.697   0.768  1.00  0.00           C  
ATOM    933  O   PRO A 137      31.902  72.089   0.385  1.00  0.00           O  
ATOM    934  CB  PRO A 137      34.931  71.380   1.533  1.00  0.00           C  
ATOM    935  CG  PRO A 137      34.382  69.955   1.487  1.00  0.00           C  
ATOM    936  CD  PRO A 137      33.382  69.933   2.645  1.00  0.00           C  
ATOM    937  HA  PRO A 137      34.060  73.075   2.546  1.00  0.00           H  
ATOM    938  HB2 PRO A 137      35.325  71.695   0.566  1.00  0.00           H  
ATOM    939  HB3 PRO A 137      35.710  71.442   2.295  1.00  0.00           H  
ATOM    940  HG2 PRO A 137      33.860  69.794   0.542  1.00  0.00           H  
ATOM    941  HG3 PRO A 137      35.169  69.213   1.621  1.00  0.00           H  
ATOM    942  HD2 PRO A 137      32.536  69.289   2.404  1.00  0.00           H  
ATOM    943  HD3 PRO A 137      33.880  69.590   3.553  1.00  0.00           H  
ATOM    944  N   GLU A 138      33.367  73.757   0.105  1.00  0.00           N  
ATOM    945  CA  GLU A 138      32.781  74.245  -1.155  1.00  0.00           C  
ATOM    946  C   GLU A 138      32.778  73.163  -2.252  1.00  0.00           C  
ATOM    947  O   GLU A 138      31.838  73.081  -3.043  1.00  0.00           O  
ATOM    948  CB  GLU A 138      33.537  75.489  -1.656  1.00  0.00           C  
ATOM    949  CG  GLU A 138      33.333  76.754  -0.804  1.00  0.00           C  
ATOM    950  CD  GLU A 138      33.961  76.694   0.605  1.00  0.00           C  
ATOM    951  OE1 GLU A 138      35.027  76.056   0.790  1.00  0.00           O  
ATOM    952  OE2 GLU A 138      33.387  77.298   1.544  1.00  0.00           O  
ATOM    953  H   GLU A 138      34.179  74.250   0.470  1.00  0.00           H  
ATOM    954  HA  GLU A 138      31.740  74.521  -0.978  1.00  0.00           H  
ATOM    955  HB2 GLU A 138      34.603  75.263  -1.737  1.00  0.00           H  
ATOM    956  HB3 GLU A 138      33.178  75.713  -2.659  1.00  0.00           H  
ATOM    957  HG2 GLU A 138      33.773  77.596  -1.344  1.00  0.00           H  
ATOM    958  HG3 GLU A 138      32.260  76.945  -0.726  1.00  0.00           H  
ATOM    959  N   ASP A 139      33.785  72.280  -2.266  1.00  0.00           N  
ATOM    960  CA  ASP A 139      33.894  71.137  -3.185  1.00  0.00           C  
ATOM    961  C   ASP A 139      32.751  70.107  -3.049  1.00  0.00           C  
ATOM    962  O   ASP A 139      32.472  69.369  -4.000  1.00  0.00           O  
ATOM    963  CB  ASP A 139      35.244  70.439  -2.962  1.00  0.00           C  
ATOM    964  CG  ASP A 139      36.433  71.335  -3.337  1.00  0.00           C  
ATOM    965  OD1 ASP A 139      36.764  71.429  -4.543  1.00  0.00           O  
ATOM    966  OD2 ASP A 139      37.046  71.940  -2.424  1.00  0.00           O  
ATOM    967  H   ASP A 139      34.529  72.417  -1.597  1.00  0.00           H  
ATOM    968  HA  ASP A 139      33.868  71.511  -4.210  1.00  0.00           H  
ATOM    969  HB2 ASP A 139      35.321  70.131  -1.918  1.00  0.00           H  
ATOM    970  HB3 ASP A 139      35.281  69.536  -3.574  1.00  0.00           H  
ATOM    971  N   ALA A 140      32.068  70.060  -1.899  1.00  0.00           N  
ATOM    972  CA  ALA A 140      30.916  69.187  -1.650  1.00  0.00           C  
ATOM    973  C   ALA A 140      29.568  69.789  -2.117  1.00  0.00           C  
ATOM    974  O   ALA A 140      28.531  69.128  -2.004  1.00  0.00           O  
ATOM    975  CB  ALA A 140      30.893  68.837  -0.155  1.00  0.00           C  
ATOM    976  H   ALA A 140      32.321  70.714  -1.167  1.00  0.00           H  
ATOM    977  HA  ALA A 140      31.055  68.257  -2.205  1.00  0.00           H  
ATOM    978  HB1 ALA A 140      30.085  68.133   0.047  1.00  0.00           H  
ATOM    979  HB2 ALA A 140      31.838  68.374   0.131  1.00  0.00           H  
ATOM    980  HB3 ALA A 140      30.734  69.738   0.437  1.00  0.00           H  
ATOM    981  N   LYS A 141      29.570  71.022  -2.652  1.00  0.00           N  
ATOM    982  CA  LYS A 141      28.366  71.791  -3.036  1.00  0.00           C  
ATOM    983  C   LYS A 141      28.465  72.383  -4.451  1.00  0.00           C  
ATOM    984  O   LYS A 141      27.496  72.308  -5.209  1.00  0.00           O  
ATOM    985  CB  LYS A 141      28.125  72.847  -1.936  1.00  0.00           C  
ATOM    986  CG  LYS A 141      26.747  73.541  -1.964  1.00  0.00           C  
ATOM    987  CD  LYS A 141      26.607  74.742  -2.912  1.00  0.00           C  
ATOM    988  CE  LYS A 141      27.519  75.912  -2.518  1.00  0.00           C  
ATOM    989  NZ  LYS A 141      27.470  76.992  -3.536  1.00  0.00           N  
ATOM    990  H   LYS A 141      30.467  71.494  -2.699  1.00  0.00           H  
ATOM    991  HA  LYS A 141      27.506  71.119  -3.048  1.00  0.00           H  
ATOM    992  HB2 LYS A 141      28.190  72.335  -0.974  1.00  0.00           H  
ATOM    993  HB3 LYS A 141      28.927  73.586  -1.951  1.00  0.00           H  
ATOM    994  HG2 LYS A 141      25.987  72.801  -2.216  1.00  0.00           H  
ATOM    995  HG3 LYS A 141      26.531  73.894  -0.954  1.00  0.00           H  
ATOM    996  HD2 LYS A 141      26.820  74.437  -3.934  1.00  0.00           H  
ATOM    997  HD3 LYS A 141      25.570  75.084  -2.880  1.00  0.00           H  
ATOM    998  HE2 LYS A 141      27.202  76.295  -1.545  1.00  0.00           H  
ATOM    999  HE3 LYS A 141      28.547  75.553  -2.427  1.00  0.00           H  
ATOM   1000  HZ1 LYS A 141      28.038  77.781  -3.259  1.00  0.00           H  
ATOM   1001  HZ2 LYS A 141      27.828  76.643  -4.421  1.00  0.00           H  
ATOM   1002  HZ3 LYS A 141      26.525  77.321  -3.679  1.00  0.00           H  
ATOM   1003  N   GLY A 142      29.634  72.899  -4.837  1.00  0.00           N  
ATOM   1004  CA  GLY A 142      29.926  73.436  -6.173  1.00  0.00           C  
ATOM   1005  C   GLY A 142      29.398  74.857  -6.421  1.00  0.00           C  
ATOM   1006  O   GLY A 142      28.754  75.462  -5.561  1.00  0.00           O  
ATOM   1007  H   GLY A 142      30.377  72.936  -4.151  1.00  0.00           H  
ATOM   1008  HA2 GLY A 142      31.006  73.450  -6.314  1.00  0.00           H  
ATOM   1009  HA3 GLY A 142      29.503  72.775  -6.932  1.00  0.00           H  
ATOM   1010  N   GLN A 143      29.665  75.385  -7.621  1.00  0.00           N  
ATOM   1011  CA  GLN A 143      29.254  76.723  -8.095  1.00  0.00           C  
ATOM   1012  C   GLN A 143      29.615  77.888  -7.136  1.00  0.00           C  
ATOM   1013  O   GLN A 143      28.913  78.900  -7.060  1.00  0.00           O  
ATOM   1014  CB  GLN A 143      27.765  76.706  -8.503  1.00  0.00           C  
ATOM   1015  CG  GLN A 143      27.448  75.649  -9.576  1.00  0.00           C  
ATOM   1016  CD  GLN A 143      26.007  75.726 -10.084  1.00  0.00           C  
ATOM   1017  OE1 GLN A 143      25.065  76.048  -9.365  1.00  0.00           O  
ATOM   1018  NE2 GLN A 143      25.770  75.439 -11.348  1.00  0.00           N  
ATOM   1019  H   GLN A 143      30.196  74.816  -8.267  1.00  0.00           H  
ATOM   1020  HA  GLN A 143      29.828  76.921  -9.001  1.00  0.00           H  
ATOM   1021  HB2 GLN A 143      27.150  76.523  -7.621  1.00  0.00           H  
ATOM   1022  HB3 GLN A 143      27.503  77.685  -8.906  1.00  0.00           H  
ATOM   1023  HG2 GLN A 143      28.128  75.795 -10.417  1.00  0.00           H  
ATOM   1024  HG3 GLN A 143      27.611  74.649  -9.176  1.00  0.00           H  
ATOM   1025 HE21 GLN A 143      26.530  75.171 -11.960  1.00  0.00           H  
ATOM   1026 HE22 GLN A 143      24.820  75.488 -11.685  1.00  0.00           H  
ATOM   1027  N   ASP A 144      30.700  77.739  -6.370  1.00  0.00           N  
ATOM   1028  CA  ASP A 144      31.255  78.757  -5.470  1.00  0.00           C  
ATOM   1029  C   ASP A 144      31.950  79.927  -6.210  1.00  0.00           C  
ATOM   1030  O   ASP A 144      32.154  79.893  -7.429  1.00  0.00           O  
ATOM   1031  CB  ASP A 144      32.215  78.070  -4.482  1.00  0.00           C  
ATOM   1032  CG  ASP A 144      33.517  77.610  -5.159  1.00  0.00           C  
ATOM   1033  OD1 ASP A 144      33.536  76.498  -5.738  1.00  0.00           O  
ATOM   1034  OD2 ASP A 144      34.512  78.367  -5.110  1.00  0.00           O  
ATOM   1035  H   ASP A 144      31.238  76.893  -6.484  1.00  0.00           H  
ATOM   1036  HA  ASP A 144      30.436  79.181  -4.885  1.00  0.00           H  
ATOM   1037  HB2 ASP A 144      32.454  78.769  -3.678  1.00  0.00           H  
ATOM   1038  HB3 ASP A 144      31.713  77.214  -4.027  1.00  0.00           H  
ATOM   1039  N   TRP A 145      32.344  80.949  -5.443  1.00  0.00           N  
ATOM   1040  CA  TRP A 145      32.948  82.204  -5.928  1.00  0.00           C  
ATOM   1041  C   TRP A 145      34.251  82.584  -5.190  1.00  0.00           C  
ATOM   1042  O   TRP A 145      34.697  83.734  -5.239  1.00  0.00           O  
ATOM   1043  CB  TRP A 145      31.885  83.317  -5.877  1.00  0.00           C  
ATOM   1044  CG  TRP A 145      30.814  83.200  -6.921  1.00  0.00           C  
ATOM   1045  CD1 TRP A 145      29.650  82.522  -6.799  1.00  0.00           C  
ATOM   1046  CD2 TRP A 145      30.813  83.754  -8.275  1.00  0.00           C  
ATOM   1047  NE1 TRP A 145      28.935  82.611  -7.979  1.00  0.00           N  
ATOM   1048  CE2 TRP A 145      29.605  83.356  -8.926  1.00  0.00           C  
ATOM   1049  CE3 TRP A 145      31.712  84.546  -9.021  1.00  0.00           C  
ATOM   1050  CZ2 TRP A 145      29.307  83.725 -10.247  1.00  0.00           C  
ATOM   1051  CZ3 TRP A 145      31.424  84.923 -10.348  1.00  0.00           C  
ATOM   1052  CH2 TRP A 145      30.224  84.516 -10.960  1.00  0.00           C  
ATOM   1053  H   TRP A 145      32.144  80.885  -4.454  1.00  0.00           H  
ATOM   1054  HA  TRP A 145      33.232  82.080  -6.971  1.00  0.00           H  
ATOM   1055  HB2 TRP A 145      31.428  83.337  -4.888  1.00  0.00           H  
ATOM   1056  HB3 TRP A 145      32.366  84.283  -6.029  1.00  0.00           H  
ATOM   1057  HD1 TRP A 145      29.337  81.977  -5.914  1.00  0.00           H  
ATOM   1058  HE1 TRP A 145      28.034  82.160  -8.120  1.00  0.00           H  
ATOM   1059  HE3 TRP A 145      32.636  84.867  -8.559  1.00  0.00           H  
ATOM   1060  HZ2 TRP A 145      28.383  83.403 -10.707  1.00  0.00           H  
ATOM   1061  HZ3 TRP A 145      32.130  85.534 -10.898  1.00  0.00           H  
ATOM   1062  HH2 TRP A 145      30.013  84.808 -11.983  1.00  0.00           H  
ATOM   1063  N   ILE A 146      34.882  81.624  -4.505  1.00  0.00           N  
ATOM   1064  CA  ILE A 146      36.182  81.790  -3.844  1.00  0.00           C  
ATOM   1065  C   ILE A 146      37.246  82.180  -4.883  1.00  0.00           C  
ATOM   1066  O   ILE A 146      37.433  81.496  -5.892  1.00  0.00           O  
ATOM   1067  CB  ILE A 146      36.581  80.505  -3.080  1.00  0.00           C  
ATOM   1068  CG1 ILE A 146      35.502  80.012  -2.086  1.00  0.00           C  
ATOM   1069  CG2 ILE A 146      37.921  80.702  -2.343  1.00  0.00           C  
ATOM   1070  CD1 ILE A 146      35.082  81.014  -1.000  1.00  0.00           C  
ATOM   1071  H   ILE A 146      34.516  80.685  -4.561  1.00  0.00           H  
ATOM   1072  HA  ILE A 146      36.098  82.604  -3.123  1.00  0.00           H  
ATOM   1073  HB  ILE A 146      36.729  79.707  -3.810  1.00  0.00           H  
ATOM   1074 HG12 ILE A 146      34.611  79.726  -2.641  1.00  0.00           H  
ATOM   1075 HG13 ILE A 146      35.868  79.110  -1.592  1.00  0.00           H  
ATOM   1076 HG21 ILE A 146      38.729  80.849  -3.060  1.00  0.00           H  
ATOM   1077 HG22 ILE A 146      37.870  81.568  -1.682  1.00  0.00           H  
ATOM   1078 HG23 ILE A 146      38.154  79.814  -1.753  1.00  0.00           H  
ATOM   1079 HD11 ILE A 146      34.330  80.552  -0.361  1.00  0.00           H  
ATOM   1080 HD12 ILE A 146      35.936  81.290  -0.385  1.00  0.00           H  
ATOM   1081 HD13 ILE A 146      34.652  81.907  -1.452  1.00  0.00           H  
ATOM   1082  N   ALA A 147      37.941  83.288  -4.618  1.00  0.00           N  
ATOM   1083  CA  ALA A 147      38.952  83.908  -5.488  1.00  0.00           C  
ATOM   1084  C   ALA A 147      38.471  84.239  -6.927  1.00  0.00           C  
ATOM   1085  O   ALA A 147      39.261  84.232  -7.874  1.00  0.00           O  
ATOM   1086  CB  ALA A 147      40.243  83.076  -5.421  1.00  0.00           C  
ATOM   1087  H   ALA A 147      37.698  83.772  -3.767  1.00  0.00           H  
ATOM   1088  HA  ALA A 147      39.183  84.876  -5.037  1.00  0.00           H  
ATOM   1089  HB1 ALA A 147      41.051  83.605  -5.930  1.00  0.00           H  
ATOM   1090  HB2 ALA A 147      40.530  82.918  -4.382  1.00  0.00           H  
ATOM   1091  HB3 ALA A 147      40.092  82.109  -5.904  1.00  0.00           H  
ATOM   1092  N   LEU A 148      37.179  84.561  -7.092  1.00  0.00           N  
ATOM   1093  CA  LEU A 148      36.532  84.937  -8.364  1.00  0.00           C  
ATOM   1094  C   LEU A 148      35.864  86.330  -8.278  1.00  0.00           C  
ATOM   1095  O   LEU A 148      34.797  86.573  -8.850  1.00  0.00           O  
ATOM   1096  CB  LEU A 148      35.564  83.816  -8.806  1.00  0.00           C  
ATOM   1097  CG  LEU A 148      36.241  82.492  -9.215  1.00  0.00           C  
ATOM   1098  CD1 LEU A 148      35.175  81.430  -9.486  1.00  0.00           C  
ATOM   1099  CD2 LEU A 148      37.086  82.637 -10.484  1.00  0.00           C  
ATOM   1100  H   LEU A 148      36.584  84.515  -6.274  1.00  0.00           H  
ATOM   1101  HA  LEU A 148      37.297  85.049  -9.130  1.00  0.00           H  
ATOM   1102  HB2 LEU A 148      34.864  83.624  -7.994  1.00  0.00           H  
ATOM   1103  HB3 LEU A 148      34.985  84.164  -9.662  1.00  0.00           H  
ATOM   1104  HG  LEU A 148      36.880  82.138  -8.408  1.00  0.00           H  
ATOM   1105 HD11 LEU A 148      34.600  81.247  -8.578  1.00  0.00           H  
ATOM   1106 HD12 LEU A 148      34.502  81.762 -10.277  1.00  0.00           H  
ATOM   1107 HD13 LEU A 148      35.650  80.495  -9.784  1.00  0.00           H  
ATOM   1108 HD21 LEU A 148      37.486  81.666 -10.772  1.00  0.00           H  
ATOM   1109 HD22 LEU A 148      36.476  83.031 -11.299  1.00  0.00           H  
ATOM   1110 HD23 LEU A 148      37.924  83.308 -10.302  1.00  0.00           H  
ATOM   1111  N   VAL A 149      36.487  87.251  -7.534  1.00  0.00           N  
ATOM   1112  CA  VAL A 149      36.074  88.665  -7.406  1.00  0.00           C  
ATOM   1113  C   VAL A 149      36.018  89.407  -8.754  1.00  0.00           C  
ATOM   1114  O   VAL A 149      36.744  89.077  -9.699  1.00  0.00           O  
ATOM   1115  CB  VAL A 149      36.984  89.433  -6.421  1.00  0.00           C  
ATOM   1116  CG1 VAL A 149      36.865  88.862  -5.003  1.00  0.00           C  
ATOM   1117  CG2 VAL A 149      38.467  89.439  -6.822  1.00  0.00           C  
ATOM   1118  H   VAL A 149      37.348  86.973  -7.088  1.00  0.00           H  
ATOM   1119  HA  VAL A 149      35.065  88.678  -6.994  1.00  0.00           H  
ATOM   1120  HB  VAL A 149      36.644  90.469  -6.383  1.00  0.00           H  
ATOM   1121 HG11 VAL A 149      35.821  88.868  -4.690  1.00  0.00           H  
ATOM   1122 HG12 VAL A 149      37.246  87.840  -4.966  1.00  0.00           H  
ATOM   1123 HG13 VAL A 149      37.440  89.478  -4.311  1.00  0.00           H  
ATOM   1124 HG21 VAL A 149      39.036  90.030  -6.103  1.00  0.00           H  
ATOM   1125 HG22 VAL A 149      38.867  88.425  -6.840  1.00  0.00           H  
ATOM   1126 HG23 VAL A 149      38.588  89.891  -7.806  1.00  0.00           H  
ATOM   1127  N   LYS A 150      35.163  90.437  -8.835  1.00  0.00           N  
ATOM   1128  CA  LYS A 150      35.033  91.335 -10.002  1.00  0.00           C  
ATOM   1129  C   LYS A 150      36.268  92.230 -10.229  1.00  0.00           C  
ATOM   1130  O   LYS A 150      37.117  92.378  -9.342  1.00  0.00           O  
ATOM   1131  CB  LYS A 150      33.737  92.162  -9.882  1.00  0.00           C  
ATOM   1132  CG  LYS A 150      33.755  93.196  -8.740  1.00  0.00           C  
ATOM   1133  CD  LYS A 150      32.422  93.945  -8.592  1.00  0.00           C  
ATOM   1134  CE  LYS A 150      32.103  94.815  -9.816  1.00  0.00           C  
ATOM   1135  NZ  LYS A 150      30.838  95.572  -9.631  1.00  0.00           N  
ATOM   1136  H   LYS A 150      34.603  90.643  -8.019  1.00  0.00           H  
ATOM   1137  HA  LYS A 150      34.940  90.712 -10.894  1.00  0.00           H  
ATOM   1138  HB2 LYS A 150      33.569  92.678 -10.827  1.00  0.00           H  
ATOM   1139  HB3 LYS A 150      32.899  91.478  -9.728  1.00  0.00           H  
ATOM   1140  HG2 LYS A 150      33.962  92.688  -7.797  1.00  0.00           H  
ATOM   1141  HG3 LYS A 150      34.548  93.925  -8.915  1.00  0.00           H  
ATOM   1142  HD2 LYS A 150      31.618  93.223  -8.437  1.00  0.00           H  
ATOM   1143  HD3 LYS A 150      32.484  94.584  -7.709  1.00  0.00           H  
ATOM   1144  HE2 LYS A 150      32.930  95.512  -9.978  1.00  0.00           H  
ATOM   1145  HE3 LYS A 150      32.021  94.176 -10.699  1.00  0.00           H  
ATOM   1146  HZ1 LYS A 150      30.635  96.143 -10.442  1.00  0.00           H  
ATOM   1147  HZ2 LYS A 150      30.054  94.949  -9.492  1.00  0.00           H  
ATOM   1148  HZ3 LYS A 150      30.893  96.187  -8.832  1.00  0.00           H  
ATOM   1149  N   ALA A 151      36.328  92.863 -11.405  1.00  0.00           N  
ATOM   1150  CA  ALA A 151      37.364  93.819 -11.830  1.00  0.00           C  
ATOM   1151  C   ALA A 151      36.785  94.920 -12.745  1.00  0.00           C  
ATOM   1152  O   ALA A 151      35.960  94.602 -13.633  1.00  0.00           O  
ATOM   1153  CB  ALA A 151      38.497  93.043 -12.521  1.00  0.00           C  
ATOM   1154  OXT ALA A 151      37.157  96.101 -12.559  1.00  0.00           O  
ATOM   1155  H   ALA A 151      35.575  92.696 -12.056  1.00  0.00           H  
ATOM   1156  HA  ALA A 151      37.775  94.317 -10.950  1.00  0.00           H  
ATOM   1157  HB1 ALA A 151      39.283  93.737 -12.825  1.00  0.00           H  
ATOM   1158  HB2 ALA A 151      38.923  92.309 -11.836  1.00  0.00           H  
ATOM   1159  HB3 ALA A 151      38.117  92.530 -13.406  1.00  0.00           H  
TER    1160      ALA A 151                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
