
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1508),  selected   92 , name 2ro0_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2ro0_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -2_A      -       -           -
LGA    S    -1_A      -       -           -
LGA    H     0_A      -       -           -
LGA    M     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    H     3_A      -       -           -
LGA    D     4_A      -       -           -
LGA    G     5_A      -       -           -
LGA    K     6_A      -       -           -
LGA    E     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    G    10_A      -       -           -
LGA    I    11_A      -       -           -
LGA    A    12_A      -       -           -
LGA    K    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    I    15_A      X      63           #
LGA    N    16_A      P      64          3.143
LGA    S    17_A      P      65          2.218
LGA    V    18_A      A      66          3.141
LGA    D    19_A      D      67          2.031
LGA    D    20_A      K      68          1.130
LGA    I    21_A      L      69          1.357
LGA    I    22_A      Y      70          1.452
LGA    I    23_A      V      71          1.582
LGA    K    24_A      G      72          1.797
LGA    C    25_A      S      73          1.241
LGA    Q    26_A      R      74          1.295
LGA    C    27_A      V      75          0.477
LGA    W    28_A      V      76          0.531
LGA    V    29_A      A      77          0.802
LGA    Q    30_A      K      78          1.756
LGA    K    31_A      Y      79          2.340
LGA    -       -      K      80           -
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    N    32_A      Q      84          3.902
LGA    D    33_A      V      85          4.053
LGA    E    34_A      W      86          1.856
LGA    E    35_A      L      87          1.459
LGA    R    36_A      Y      88          0.725
LGA    L    37_A      A      89          0.601
LGA    A    38_A      G      90          1.032
LGA    E    39_A      I      91          1.097
LGA    I    40_A      V      92          1.347
LGA    L    41_A      A      93          1.344
LGA    S    42_A      E      94          1.964
LGA    I    43_A      T      95          1.645
LGA    N    44_A      P      96          2.382
LGA    T    45_A      N      97          3.110
LGA    R    46_A      V      98          3.507
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    K    47_A      K     101           #
LGA    A    48_A      L     102           #
LGA    P    49_A      -       -           -
LGA    P    50_A      -       -           -
LGA    K    51_A      R     103          1.587
LGA    F    52_A      F     104          1.133
LGA    Y    53_A      L     105          1.154
LGA    V    54_A      I     106          0.618
LGA    H    55_A      F     107          0.628
LGA    Y    56_A      F     108          1.090
LGA    V    57_A      D     109          1.498
LGA    N    58_A      D     110          1.677
LGA    Y    59_A      G     111          2.830
LGA    N    60_A      -       -           -
LGA    K    61_A      -       -           -
LGA    R    62_A      -       -           -
LGA    L    63_A      Y     112          2.271
LGA    D    64_A      A     113          0.618
LGA    E    65_A      S     114          2.104
LGA    W    66_A      Y     115          1.784
LGA    I    67_A      V     116          1.301
LGA    T    68_A      T     117          0.926
LGA    T    69_A      Q     118          0.511
LGA    D    70_A      S     119          1.480
LGA    R    71_A      E     120          1.540
LGA    I    72_A      L     121          0.883
LGA    N    73_A      Y     122          2.221
LGA    L    74_A      P     123          4.150
LGA    D    75_A      -       -           -
LGA    K    76_A      I     124          4.166
LGA    E    77_A      C     125          2.053
LGA    V    78_A      R     126          5.526
LGA    L    79_A      P     127          2.312
LGA    Y    80_A      L     128          5.477
LGA    P    81_A      K     129          3.521
LGA    K    82_A      K     130          5.049
LGA    L    83_A      T     131           -
LGA    K    84_A      W     132           -
LGA    A    85_A      E     133           -
LGA    T    86_A      D     134           -
LGA    D    87_A      I     135           -
LGA    E    88_A      E     136           -
LGA    D    89_A      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   93    5.0     59    2.33     6.78     52.579     2.430

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.874440 * X  +  -0.039527 * Y  +  -0.483521 * Z  +  39.966595
  Y_new =  -0.086521 * X  +  -0.967990 * Y  +   0.235604 * Z  +  92.511703
  Z_new =  -0.477357 * X  +   0.247857 * Y  +   0.843029 * Z  +  -7.219554 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.285950   -2.855643  [ DEG:    16.3837   -163.6163 ]
  Theta =   0.497644    2.643949  [ DEG:    28.5129    151.4871 ]
  Phi   =  -3.042969    0.098624  [ DEG:  -174.3493      5.6507 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ro0_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ro0_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   93   5.0   59   2.33    6.78  52.579
REMARK  ---------------------------------------------------------- 
MOLECULE 2ro0_A
HEADER    TRANSFERASE                             01-MAR-08   2RO0              
TITLE     SOLUTION STRUCTURE OF THE KNOTTED TUDOR DOMAIN OF THE YEAST           
TITLE    2 HISTONE ACETYLTRANSFERASE, ESA1                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE ACETYLTRANSFERASE ESA1;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 1-89;                                             
COMPND   5 EC: 2.3.1.48;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 GENUS: SACCHAROMYCES;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_GENUS: ESCHERICHIA;                                
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    ESA1, HAT, CHROMODOMAIN, TUDOR DOMAIN, RNA BINDING,                   
KEYWDS   2 ACTIVATOR, CHROMATIN REGULATOR, TRANSCRIPTION,                       
KEYWDS   3 TRANSCRIPTION REGULATION, TRANSFERASE                                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.SHIMOJO,N.SANO,Y.MORIWAKI,M.OKUDA,M.HORIKOSHI,Y.NISHIMURA           
REVDAT   2   03-JUN-08 2RO0    1       JRNL                                     
REVDAT   1   29-APR-08 2RO0    0                                                
JRNL        AUTH   H.SHIMOJO,N.SANO,Y.MORIWAKI,M.OKUDA,M.HORIKOSHI,             
JRNL        AUTH 2 Y.NISHIMURA                                                  
JRNL        TITL   NOVEL STRUCTURAL AND FUNCTIONAL MODE OF A KNOT               
JRNL        TITL 2 ESSENTIAL FOR RNA BINDING ACTIVITY OF THE ESA1               
JRNL        TITL 3 PRESUMED CHROMODOMAIN                                        
JRNL        REF    J.MOL.BIOL.                   V. 378   987 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2RO0 A    1    89  UNP    Q08649   ESA1_YEAST       1     89             
SEQRES   1 A   92  GLY SER HIS MET SER HIS ASP GLY LYS GLU GLU PRO GLY          
SEQRES   2 A   92  ILE ALA LYS LYS ILE ASN SER VAL ASP ASP ILE ILE ILE          
SEQRES   3 A   92  LYS CYS GLN CYS TRP VAL GLN LYS ASN ASP GLU GLU ARG          
SEQRES   4 A   92  LEU ALA GLU ILE LEU SER ILE ASN THR ARG LYS ALA PRO          
SEQRES   5 A   92  PRO LYS PHE TYR VAL HIS TYR VAL ASN TYR ASN LYS ARG          
SEQRES   6 A   92  LEU ASP GLU TRP ILE THR THR ASP ARG ILE ASN LEU ASP          
SEQRES   7 A   92  LYS GLU VAL LEU TYR PRO LYS LEU LYS ALA THR ASP GLU          
SEQRES   8 A   92  ASP                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  -2      38.804  92.397  -7.854  1.00  0.00           N  
ATOM      2  CA  GLY A  -2      38.759  92.038  -9.259  1.00  0.00           C  
ATOM      3  C   GLY A  -2      37.363  91.662  -9.718  1.00  0.00           C  
ATOM      4  O   GLY A  -2      36.651  90.932  -9.028  1.00  0.00           O  
ATOM      5  H1  GLY A  -2      37.970  92.557  -7.364  1.00  0.00           H  
ATOM      6  HA2 GLY A  -2      39.105  92.876  -9.845  1.00  0.00           H  
ATOM      7  HA3 GLY A  -2      39.417  91.197  -9.426  1.00  0.00           H  
ATOM      8  N   SER A  -1      36.969  92.166 -10.883  1.00  0.00           N  
ATOM      9  CA  SER A  -1      35.646  91.884 -11.430  1.00  0.00           C  
ATOM     10  C   SER A  -1      35.718  91.662 -12.937  1.00  0.00           C  
ATOM     11  O   SER A  -1      36.529  92.279 -13.629  1.00  0.00           O  
ATOM     12  CB  SER A  -1      34.687  93.032 -11.116  1.00  0.00           C  
ATOM     13  OG  SER A  -1      34.863  93.497  -9.789  1.00  0.00           O  
ATOM     14  H   SER A  -1      37.581  92.743 -11.386  1.00  0.00           H  
ATOM     15  HA  SER A  -1      35.280  90.981 -10.962  1.00  0.00           H  
ATOM     16  HB2 SER A  -1      34.870  93.848 -11.797  1.00  0.00           H  
ATOM     17  HB3 SER A  -1      33.669  92.689 -11.231  1.00  0.00           H  
ATOM     18  HG  SER A  -1      35.194  94.398  -9.807  1.00  0.00           H  
ATOM     19  N   HIS A   0      34.863  90.777 -13.440  1.00  0.00           N  
ATOM     20  CA  HIS A   0      34.828  90.473 -14.866  1.00  0.00           C  
ATOM     21  C   HIS A   0      33.410  90.132 -15.314  1.00  0.00           C  
ATOM     22  O   HIS A   0      32.479  90.126 -14.509  1.00  0.00           O  
ATOM     23  CB  HIS A   0      35.769  89.313 -15.186  1.00  0.00           C  
ATOM     24  CG  HIS A   0      37.188  89.562 -14.776  1.00  0.00           C  
ATOM     25  ND1 HIS A   0      37.735  89.063 -13.614  1.00  0.00           N  
ATOM     26  CD2 HIS A   0      38.175  90.262 -15.384  1.00  0.00           C  
ATOM     27  CE1 HIS A   0      38.996  89.447 -13.522  1.00  0.00           C  
ATOM     28  NE2 HIS A   0      39.288  90.175 -14.586  1.00  0.00           N  
ATOM     29  H   HIS A   0      34.241  90.317 -12.838  1.00  0.00           H  
ATOM     30  HA  HIS A   0      35.158  91.351 -15.400  1.00  0.00           H  
ATOM     31  HB2 HIS A   0      35.427  88.428 -14.670  1.00  0.00           H  
ATOM     32  HB3 HIS A   0      35.758  89.129 -16.250  1.00  0.00           H  
ATOM     33  HD1 HIS A   0      37.268  88.512 -12.952  1.00  0.00           H  
ATOM     34  HD2 HIS A   0      38.101  90.792 -16.323  1.00  0.00           H  
ATOM     35  HE1 HIS A   0      39.674  89.206 -12.717  1.00  0.00           H  
ATOM     36  N   MET A   1      33.253  89.848 -16.603  1.00  0.00           N  
ATOM     37  CA  MET A   1      31.949  89.505 -17.157  1.00  0.00           C  
ATOM     38  C   MET A   1      31.419  88.213 -16.542  1.00  0.00           C  
ATOM     39  O   MET A   1      31.884  87.122 -16.872  1.00  0.00           O  
ATOM     40  CB  MET A   1      32.038  89.361 -18.677  1.00  0.00           C  
ATOM     41  CG  MET A   1      32.332  90.669 -19.395  1.00  0.00           C  
ATOM     42  SD  MET A   1      32.299  90.498 -21.190  1.00  0.00           S  
ATOM     43  CE  MET A   1      33.680  89.387 -21.450  1.00  0.00           C  
ATOM     44  H   MET A   1      34.033  89.869 -17.196  1.00  0.00           H  
ATOM     45  HA  MET A   1      31.267  90.308 -16.919  1.00  0.00           H  
ATOM     46  HB2 MET A   1      32.824  88.660 -18.915  1.00  0.00           H  
ATOM     47  HB3 MET A   1      31.099  88.977 -19.047  1.00  0.00           H  
ATOM     48  HG2 MET A   1      31.592  91.398 -19.104  1.00  0.00           H  
ATOM     49  HG3 MET A   1      33.312  91.014 -19.098  1.00  0.00           H  
ATOM     50  HE1 MET A   1      34.473  89.632 -20.759  1.00  0.00           H  
ATOM     51  HE2 MET A   1      33.360  88.369 -21.284  1.00  0.00           H  
ATOM     52  HE3 MET A   1      34.039  89.491 -22.463  1.00  0.00           H  
ATOM     53  N   SER A   2      30.447  88.344 -15.647  1.00  0.00           N  
ATOM     54  CA  SER A   2      29.858  87.187 -14.982  1.00  0.00           C  
ATOM     55  C   SER A   2      28.500  86.846 -15.588  1.00  0.00           C  
ATOM     56  O   SER A   2      27.471  87.382 -15.176  1.00  0.00           O  
ATOM     57  CB  SER A   2      29.707  87.454 -13.484  1.00  0.00           C  
ATOM     58  OG  SER A   2      30.918  87.936 -12.928  1.00  0.00           O  
ATOM     59  H   SER A   2      30.119  89.242 -15.425  1.00  0.00           H  
ATOM     60  HA  SER A   2      30.523  86.349 -15.126  1.00  0.00           H  
ATOM     61  HB2 SER A   2      28.935  88.192 -13.328  1.00  0.00           H  
ATOM     62  HB3 SER A   2      29.435  86.536 -12.982  1.00  0.00           H  
ATOM     63  HG  SER A   2      31.625  87.311 -13.107  1.00  0.00           H  
ATOM     64  N   HIS A   3      28.505  85.950 -16.570  1.00  0.00           N  
ATOM     65  CA  HIS A   3      27.274  85.536 -17.233  1.00  0.00           C  
ATOM     66  C   HIS A   3      26.586  84.419 -16.454  1.00  0.00           C  
ATOM     67  O   HIS A   3      27.114  83.929 -15.456  1.00  0.00           O  
ATOM     68  CB  HIS A   3      27.570  85.071 -18.659  1.00  0.00           C  
ATOM     69  CG  HIS A   3      28.222  86.119 -19.508  1.00  0.00           C  
ATOM     70  ND1 HIS A   3      29.170  85.829 -20.467  1.00  0.00           N  
ATOM     71  CD2 HIS A   3      28.057  87.463 -19.538  1.00  0.00           C  
ATOM     72  CE1 HIS A   3      29.561  86.948 -21.049  1.00  0.00           C  
ATOM     73  NE2 HIS A   3      28.900  87.955 -20.504  1.00  0.00           N  
ATOM     74  H   HIS A   3      29.356  85.558 -16.854  1.00  0.00           H  
ATOM     75  HA  HIS A   3      26.614  86.390 -17.272  1.00  0.00           H  
ATOM     76  HB2 HIS A   3      28.229  84.217 -18.624  1.00  0.00           H  
ATOM     77  HB3 HIS A   3      26.644  84.785 -19.138  1.00  0.00           H  
ATOM     78  HD1 HIS A   3      29.506  84.936 -20.686  1.00  0.00           H  
ATOM     79  HD2 HIS A   3      27.387  88.041 -18.918  1.00  0.00           H  
ATOM     80  HE1 HIS A   3      30.294  87.028 -21.837  1.00  0.00           H  
ATOM     81  N   ASP A   4      25.405  84.022 -16.917  1.00  0.00           N  
ATOM     82  CA  ASP A   4      24.645  82.962 -16.263  1.00  0.00           C  
ATOM     83  C   ASP A   4      24.608  81.707 -17.130  1.00  0.00           C  
ATOM     84  O   ASP A   4      25.115  80.657 -16.740  1.00  0.00           O  
ATOM     85  CB  ASP A   4      23.222  83.436 -15.968  1.00  0.00           C  
ATOM     86  CG  ASP A   4      23.183  84.545 -14.936  1.00  0.00           C  
ATOM     87  OD1 ASP A   4      23.117  84.231 -13.729  1.00  0.00           O  
ATOM     88  OD2 ASP A   4      23.219  85.728 -15.335  1.00  0.00           O  
ATOM     89  H   ASP A   4      25.037  84.451 -17.718  1.00  0.00           H  
ATOM     90  HA  ASP A   4      25.137  82.727 -15.332  1.00  0.00           H  
ATOM     91  HB2 ASP A   4      22.774  83.802 -16.880  1.00  0.00           H  
ATOM     92  HB3 ASP A   4      22.642  82.603 -15.597  1.00  0.00           H  
ATOM     93  N   GLY A   5      24.002  81.824 -18.307  1.00  0.00           N  
ATOM     94  CA  GLY A   5      23.907  80.691 -19.210  1.00  0.00           C  
ATOM     95  C   GLY A   5      22.964  79.621 -18.699  1.00  0.00           C  
ATOM     96  O   GLY A   5      21.745  79.799 -18.711  1.00  0.00           O  
ATOM     97  H   GLY A   5      23.614  82.687 -18.565  1.00  0.00           H  
ATOM     98  HA2 GLY A   5      23.557  81.037 -20.169  1.00  0.00           H  
ATOM     99  HA3 GLY A   5      24.890  80.260 -19.331  1.00  0.00           H  
ATOM    100  N   LYS A   6      23.525  78.503 -18.251  1.00  0.00           N  
ATOM    101  CA  LYS A   6      22.727  77.398 -17.734  1.00  0.00           C  
ATOM    102  C   LYS A   6      23.411  76.745 -16.537  1.00  0.00           C  
ATOM    103  O   LYS A   6      23.984  75.662 -16.655  1.00  0.00           O  
ATOM    104  CB  LYS A   6      22.488  76.358 -18.830  1.00  0.00           C  
ATOM    105  CG  LYS A   6      21.236  76.614 -19.651  1.00  0.00           C  
ATOM    106  CD  LYS A   6      20.622  75.318 -20.151  1.00  0.00           C  
ATOM    107  CE  LYS A   6      19.128  75.466 -20.392  1.00  0.00           C  
ATOM    108  NZ  LYS A   6      18.566  74.296 -21.123  1.00  0.00           N  
ATOM    109  H   LYS A   6      24.503  78.420 -18.267  1.00  0.00           H  
ATOM    110  HA  LYS A   6      21.775  77.798 -17.416  1.00  0.00           H  
ATOM    111  HB2 LYS A   6      23.338  76.355 -19.498  1.00  0.00           H  
ATOM    112  HB3 LYS A   6      22.399  75.383 -18.372  1.00  0.00           H  
ATOM    113  HG2 LYS A   6      20.513  77.129 -19.037  1.00  0.00           H  
ATOM    114  HG3 LYS A   6      21.494  77.231 -20.501  1.00  0.00           H  
ATOM    115  HD2 LYS A   6      21.098  75.037 -21.079  1.00  0.00           H  
ATOM    116  HD3 LYS A   6      20.784  74.544 -19.413  1.00  0.00           H  
ATOM    117  HE2 LYS A   6      18.630  75.556 -19.440  1.00  0.00           H  
ATOM    118  HE3 LYS A   6      18.957  76.359 -20.974  1.00  0.00           H  
ATOM    119  HZ1 LYS A   6      18.518  74.500 -22.142  1.00  0.00           H  
ATOM    120  HZ2 LYS A   6      17.607  74.086 -20.778  1.00  0.00           H  
ATOM    121  HZ3 LYS A   6      19.166  73.460 -20.976  1.00  0.00           H  
ATOM    122  N   GLU A   7      23.346  77.410 -15.388  1.00  0.00           N  
ATOM    123  CA  GLU A   7      23.960  76.891 -14.171  1.00  0.00           C  
ATOM    124  C   GLU A   7      22.922  76.199 -13.291  1.00  0.00           C  
ATOM    125  O   GLU A   7      21.719  76.387 -13.468  1.00  0.00           O  
ATOM    126  CB  GLU A   7      24.633  78.023 -13.392  1.00  0.00           C  
ATOM    127  CG  GLU A   7      23.652  78.955 -12.702  1.00  0.00           C  
ATOM    128  CD  GLU A   7      24.296  80.255 -12.258  1.00  0.00           C  
ATOM    129  OE1 GLU A   7      25.216  80.729 -12.955  1.00  0.00           O  
ATOM    130  OE2 GLU A   7      23.876  80.797 -11.213  1.00  0.00           O  
ATOM    131  H   GLU A   7      22.875  78.268 -15.358  1.00  0.00           H  
ATOM    132  HA  GLU A   7      24.709  76.169 -14.459  1.00  0.00           H  
ATOM    133  HB2 GLU A   7      25.278  77.592 -12.641  1.00  0.00           H  
ATOM    134  HB3 GLU A   7      25.232  78.607 -14.075  1.00  0.00           H  
ATOM    135  HG2 GLU A   7      22.850  79.184 -13.387  1.00  0.00           H  
ATOM    136  HG3 GLU A   7      23.250  78.455 -11.833  1.00  0.00           H  
ATOM    137  N   GLU A   8      23.399  75.400 -12.342  1.00  0.00           N  
ATOM    138  CA  GLU A   8      22.513  74.680 -11.435  1.00  0.00           C  
ATOM    139  C   GLU A   8      22.603  75.248 -10.022  1.00  0.00           C  
ATOM    140  O   GLU A   8      23.560  75.933  -9.660  1.00  0.00           O  
ATOM    141  CB  GLU A   8      22.862  73.190 -11.421  1.00  0.00           C  
ATOM    142  CG  GLU A   8      21.978  72.349 -12.326  1.00  0.00           C  
ATOM    143  CD  GLU A   8      21.722  73.006 -13.668  1.00  0.00           C  
ATOM    144  OE1 GLU A   8      22.695  73.488 -14.286  1.00  0.00           O  
ATOM    145  OE2 GLU A   8      20.552  73.039 -14.100  1.00  0.00           O  
ATOM    146  H   GLU A   8      24.368  75.291 -12.250  1.00  0.00           H  
ATOM    147  HA  GLU A   8      21.503  74.799 -11.794  1.00  0.00           H  
ATOM    148  HB2 GLU A   8      23.887  73.070 -11.741  1.00  0.00           H  
ATOM    149  HB3 GLU A   8      22.765  72.819 -10.411  1.00  0.00           H  
ATOM    150  HG2 GLU A   8      22.459  71.397 -12.494  1.00  0.00           H  
ATOM    151  HG3 GLU A   8      21.030  72.189 -11.833  1.00  0.00           H  
ATOM    152  N   PRO A   9      21.581  74.958  -9.202  1.00  0.00           N  
ATOM    153  CA  PRO A   9      21.520  75.429  -7.816  1.00  0.00           C  
ATOM    154  C   PRO A   9      22.555  74.749  -6.925  1.00  0.00           C  
ATOM    155  O   PRO A   9      23.369  73.957  -7.398  1.00  0.00           O  
ATOM    156  CB  PRO A   9      20.104  75.052  -7.374  1.00  0.00           C  
ATOM    157  CG  PRO A   9      19.729  73.904  -8.246  1.00  0.00           C  
ATOM    158  CD  PRO A   9      20.407  74.147  -9.566  1.00  0.00           C  
ATOM    159  HA  PRO A   9      21.644  76.501  -7.755  1.00  0.00           H  
ATOM    160  HB2 PRO A   9      20.113  74.770  -6.331  1.00  0.00           H  
ATOM    161  HB3 PRO A   9      19.441  75.890  -7.520  1.00  0.00           H  
ATOM    162  HG2 PRO A   9      20.080  72.980  -7.809  1.00  0.00           H  
ATOM    163  HG3 PRO A   9      18.657  73.875  -8.375  1.00  0.00           H  
ATOM    164  HD2 PRO A   9      20.707  73.211 -10.014  1.00  0.00           H  
ATOM    165  HD3 PRO A   9      19.754  74.693 -10.230  1.00  0.00           H  
ATOM    166  N   GLY A  10      22.516  75.063  -5.634  1.00  0.00           N  
ATOM    167  CA  GLY A  10      23.456  74.473  -4.699  1.00  0.00           C  
ATOM    168  C   GLY A  10      24.657  75.362  -4.444  1.00  0.00           C  
ATOM    169  O   GLY A  10      25.463  75.601  -5.343  1.00  0.00           O  
ATOM    170  H   GLY A  10      21.846  75.701  -5.313  1.00  0.00           H  
ATOM    171  HA2 GLY A  10      22.950  74.291  -3.763  1.00  0.00           H  
ATOM    172  HA3 GLY A  10      23.800  73.530  -5.099  1.00  0.00           H  
ATOM    173  N   ILE A  11      24.776  75.854  -3.215  1.00  0.00           N  
ATOM    174  CA  ILE A  11      25.887  76.723  -2.845  1.00  0.00           C  
ATOM    175  C   ILE A  11      26.841  76.018  -1.889  1.00  0.00           C  
ATOM    176  O   ILE A  11      26.431  75.526  -0.837  1.00  0.00           O  
ATOM    177  CB  ILE A  11      25.389  78.025  -2.190  1.00  0.00           C  
ATOM    178  CG1 ILE A  11      24.378  78.726  -3.098  1.00  0.00           C  
ATOM    179  CG2 ILE A  11      26.560  78.944  -1.882  1.00  0.00           C  
ATOM    180  CD1 ILE A  11      22.943  78.338  -2.820  1.00  0.00           C  
ATOM    181  H   ILE A  11      24.101  75.628  -2.543  1.00  0.00           H  
ATOM    182  HA  ILE A  11      26.422  76.981  -3.747  1.00  0.00           H  
ATOM    183  HB  ILE A  11      24.908  77.770  -1.257  1.00  0.00           H  
ATOM    184 HG12 ILE A  11      24.463  79.793  -2.967  1.00  0.00           H  
ATOM    185 HG13 ILE A  11      24.596  78.476  -4.127  1.00  0.00           H  
ATOM    186 HG21 ILE A  11      26.742  78.953  -0.817  1.00  0.00           H  
ATOM    187 HG22 ILE A  11      27.442  78.587  -2.393  1.00  0.00           H  
ATOM    188 HG23 ILE A  11      26.330  79.945  -2.216  1.00  0.00           H  
ATOM    189 HD11 ILE A  11      22.873  77.902  -1.833  1.00  0.00           H  
ATOM    190 HD12 ILE A  11      22.316  79.216  -2.869  1.00  0.00           H  
ATOM    191 HD13 ILE A  11      22.615  77.618  -3.554  1.00  0.00           H  
ATOM    192  N   ALA A  12      28.116  75.973  -2.260  1.00  0.00           N  
ATOM    193  CA  ALA A  12      29.130  75.331  -1.433  1.00  0.00           C  
ATOM    194  C   ALA A  12      30.005  76.366  -0.734  1.00  0.00           C  
ATOM    195  O   ALA A  12      30.768  77.086  -1.379  1.00  0.00           O  
ATOM    196  CB  ALA A  12      29.986  74.398  -2.277  1.00  0.00           C  
ATOM    197  H   ALA A  12      28.381  76.383  -3.109  1.00  0.00           H  
ATOM    198  HA  ALA A  12      28.625  74.738  -0.684  1.00  0.00           H  
ATOM    199  HB1 ALA A  12      29.403  73.532  -2.558  1.00  0.00           H  
ATOM    200  HB2 ALA A  12      30.314  74.915  -3.166  1.00  0.00           H  
ATOM    201  HB3 ALA A  12      30.846  74.082  -1.705  1.00  0.00           H  
ATOM    202  N   LYS A  13      29.889  76.438   0.587  1.00  0.00           N  
ATOM    203  CA  LYS A  13      30.671  77.384   1.375  1.00  0.00           C  
ATOM    204  C   LYS A  13      31.209  76.724   2.640  1.00  0.00           C  
ATOM    205  O   LYS A  13      30.543  75.885   3.247  1.00  0.00           O  
ATOM    206  CB  LYS A  13      29.815  78.598   1.744  1.00  0.00           C  
ATOM    207  CG  LYS A  13      28.831  78.330   2.869  1.00  0.00           C  
ATOM    208  CD  LYS A  13      27.985  79.554   3.173  1.00  0.00           C  
ATOM    209  CE  LYS A  13      27.003  79.848   2.049  1.00  0.00           C  
ATOM    210  NZ  LYS A  13      27.539  80.858   1.094  1.00  0.00           N  
ATOM    211  H   LYS A  13      29.264  75.836   1.044  1.00  0.00           H  
ATOM    212  HA  LYS A  13      31.503  77.711   0.771  1.00  0.00           H  
ATOM    213  HB2 LYS A  13      30.468  79.403   2.049  1.00  0.00           H  
ATOM    214  HB3 LYS A  13      29.258  78.909   0.873  1.00  0.00           H  
ATOM    215  HG2 LYS A  13      28.179  77.519   2.578  1.00  0.00           H  
ATOM    216  HG3 LYS A  13      29.380  78.053   3.757  1.00  0.00           H  
ATOM    217  HD2 LYS A  13      27.430  79.381   4.083  1.00  0.00           H  
ATOM    218  HD3 LYS A  13      28.636  80.408   3.303  1.00  0.00           H  
ATOM    219  HE2 LYS A  13      26.803  78.932   1.516  1.00  0.00           H  
ATOM    220  HE3 LYS A  13      26.086  80.223   2.478  1.00  0.00           H  
ATOM    221  HZ1 LYS A  13      27.626  80.441   0.145  1.00  0.00           H  
ATOM    222  HZ2 LYS A  13      28.478  81.181   1.406  1.00  0.00           H  
ATOM    223  HZ3 LYS A  13      26.902  81.677   1.044  1.00  0.00           H  
ATOM    224  N   LYS A  14      32.418  77.110   3.034  1.00  0.00           N  
ATOM    225  CA  LYS A  14      33.047  76.560   4.229  1.00  0.00           C  
ATOM    226  C   LYS A  14      32.892  77.510   5.412  1.00  0.00           C  
ATOM    227  O   LYS A  14      33.362  78.647   5.372  1.00  0.00           O  
ATOM    228  CB  LYS A  14      34.530  76.288   3.971  1.00  0.00           C  
ATOM    229  CG  LYS A  14      34.856  74.814   3.795  1.00  0.00           C  
ATOM    230  CD  LYS A  14      36.356  74.572   3.795  1.00  0.00           C  
ATOM    231  CE  LYS A  14      36.932  74.641   2.389  1.00  0.00           C  
ATOM    232  NZ  LYS A  14      36.994  73.298   1.749  1.00  0.00           N  
ATOM    233  H   LYS A  14      32.900  77.784   2.508  1.00  0.00           H  
ATOM    234  HA  LYS A  14      32.553  75.628   4.464  1.00  0.00           H  
ATOM    235  HB2 LYS A  14      34.829  76.811   3.074  1.00  0.00           H  
ATOM    236  HB3 LYS A  14      35.104  76.665   4.805  1.00  0.00           H  
ATOM    237  HG2 LYS A  14      34.413  74.257   4.607  1.00  0.00           H  
ATOM    238  HG3 LYS A  14      34.446  74.474   2.855  1.00  0.00           H  
ATOM    239  HD2 LYS A  14      36.834  75.325   4.405  1.00  0.00           H  
ATOM    240  HD3 LYS A  14      36.554  73.592   4.208  1.00  0.00           H  
ATOM    241  HE2 LYS A  14      36.309  75.287   1.790  1.00  0.00           H  
ATOM    242  HE3 LYS A  14      37.930  75.051   2.442  1.00  0.00           H  
ATOM    243  HZ1 LYS A  14      36.507  73.317   0.829  1.00  0.00           H  
ATOM    244  HZ2 LYS A  14      36.534  72.591   2.358  1.00  0.00           H  
ATOM    245  HZ3 LYS A  14      37.984  73.019   1.599  1.00  0.00           H  
ATOM    246  N   ILE A  15      32.231  77.036   6.463  1.00  0.00           N  
ATOM    247  CA  ILE A  15      32.018  77.843   7.658  1.00  0.00           C  
ATOM    248  C   ILE A  15      32.870  77.342   8.820  1.00  0.00           C  
ATOM    249  O   ILE A  15      33.583  76.348   8.695  1.00  0.00           O  
ATOM    250  CB  ILE A  15      30.537  77.839   8.083  1.00  0.00           C  
ATOM    251  CG1 ILE A  15      30.100  76.426   8.475  1.00  0.00           C  
ATOM    252  CG2 ILE A  15      29.663  78.377   6.960  1.00  0.00           C  
ATOM    253  CD1 ILE A  15      28.702  76.363   9.048  1.00  0.00           C  
ATOM    254  H   ILE A  15      31.880  76.122   6.434  1.00  0.00           H  
ATOM    255  HA  ILE A  15      32.302  78.859   7.428  1.00  0.00           H  
ATOM    256  HB  ILE A  15      30.428  78.491   8.936  1.00  0.00           H  
ATOM    257 HG12 ILE A  15      30.129  75.792   7.603  1.00  0.00           H  
ATOM    258 HG13 ILE A  15      30.783  76.040   9.218  1.00  0.00           H  
ATOM    259 HG21 ILE A  15      29.869  77.833   6.051  1.00  0.00           H  
ATOM    260 HG22 ILE A  15      28.623  78.254   7.224  1.00  0.00           H  
ATOM    261 HG23 ILE A  15      29.874  79.425   6.809  1.00  0.00           H  
ATOM    262 HD11 ILE A  15      28.731  75.879  10.015  1.00  0.00           H  
ATOM    263 HD12 ILE A  15      28.313  77.364   9.161  1.00  0.00           H  
ATOM    264 HD13 ILE A  15      28.065  75.801   8.384  1.00  0.00           H  
ATOM    265  N   ASN A  16      32.788  78.037   9.949  1.00  0.00           N  
ATOM    266  CA  ASN A  16      33.551  77.662  11.134  1.00  0.00           C  
ATOM    267  C   ASN A  16      32.710  77.827  12.397  1.00  0.00           C  
ATOM    268  O   ASN A  16      33.237  77.820  13.510  1.00  0.00           O  
ATOM    269  CB  ASN A  16      34.820  78.510  11.238  1.00  0.00           C  
ATOM    270  CG  ASN A  16      35.974  77.922  10.449  1.00  0.00           C  
ATOM    271  OD1 ASN A  16      36.417  78.496   9.455  1.00  0.00           O  
ATOM    272  ND2 ASN A  16      36.467  76.771  10.892  1.00  0.00           N  
ATOM    273  H   ASN A  16      32.201  78.821   9.987  1.00  0.00           H  
ATOM    274  HA  ASN A  16      33.829  76.624  11.034  1.00  0.00           H  
ATOM    275  HB2 ASN A  16      34.617  79.500  10.857  1.00  0.00           H  
ATOM    276  HB3 ASN A  16      35.115  78.581  12.275  1.00  0.00           H  
ATOM    277 HD21 ASN A  16      36.064  76.370  11.691  1.00  0.00           H  
ATOM    278 HD22 ASN A  16      37.214  76.368  10.401  1.00  0.00           H  
ATOM    279  N   SER A  17      31.402  77.976  12.215  1.00  0.00           N  
ATOM    280  CA  SER A  17      30.489  78.146  13.339  1.00  0.00           C  
ATOM    281  C   SER A  17      29.196  77.369  13.110  1.00  0.00           C  
ATOM    282  O   SER A  17      28.559  77.495  12.065  1.00  0.00           O  
ATOM    283  CB  SER A  17      30.176  79.629  13.549  1.00  0.00           C  
ATOM    284  OG  SER A  17      31.334  80.425  13.370  1.00  0.00           O  
ATOM    285  H   SER A  17      31.043  77.973  11.303  1.00  0.00           H  
ATOM    286  HA  SER A  17      30.975  77.762  14.223  1.00  0.00           H  
ATOM    287  HB2 SER A  17      29.427  79.940  12.837  1.00  0.00           H  
ATOM    288  HB3 SER A  17      29.803  79.777  14.552  1.00  0.00           H  
ATOM    289  HG  SER A  17      31.950  80.260  14.087  1.00  0.00           H  
ATOM    290  N   VAL A  18      28.814  76.565  14.098  1.00  0.00           N  
ATOM    291  CA  VAL A  18      27.596  75.768  14.007  1.00  0.00           C  
ATOM    292  C   VAL A  18      26.355  76.648  14.093  1.00  0.00           C  
ATOM    293  O   VAL A  18      25.253  76.220  13.749  1.00  0.00           O  
ATOM    294  CB  VAL A  18      27.537  74.705  15.121  1.00  0.00           C  
ATOM    295  CG1 VAL A  18      28.791  73.844  15.105  1.00  0.00           C  
ATOM    296  CG2 VAL A  18      27.352  75.367  16.478  1.00  0.00           C  
ATOM    297  H   VAL A  18      29.363  76.508  14.907  1.00  0.00           H  
ATOM    298  HA  VAL A  18      27.601  75.259  13.054  1.00  0.00           H  
ATOM    299  HB  VAL A  18      26.686  74.067  14.936  1.00  0.00           H  
ATOM    300 HG11 VAL A  18      28.826  73.276  14.187  1.00  0.00           H  
ATOM    301 HG12 VAL A  18      29.664  74.476  15.172  1.00  0.00           H  
ATOM    302 HG13 VAL A  18      28.772  73.166  15.946  1.00  0.00           H  
ATOM    303 HG21 VAL A  18      27.620  74.670  17.259  1.00  0.00           H  
ATOM    304 HG22 VAL A  18      27.985  76.240  16.542  1.00  0.00           H  
ATOM    305 HG23 VAL A  18      26.319  75.662  16.598  1.00  0.00           H  
ATOM    306  N   ASP A  19      26.542  77.880  14.553  1.00  0.00           N  
ATOM    307  CA  ASP A  19      25.436  78.823  14.683  1.00  0.00           C  
ATOM    308  C   ASP A  19      24.799  79.103  13.326  1.00  0.00           C  
ATOM    309  O   ASP A  19      23.581  79.246  13.218  1.00  0.00           O  
ATOM    310  CB  ASP A  19      25.923  80.130  15.311  1.00  0.00           C  
ATOM    311  CG  ASP A  19      24.826  81.172  15.404  1.00  0.00           C  
ATOM    312  OD1 ASP A  19      23.769  80.870  15.996  1.00  0.00           O  
ATOM    313  OD2 ASP A  19      25.027  82.290  14.885  1.00  0.00           O  
ATOM    314  H   ASP A  19      27.444  78.163  14.811  1.00  0.00           H  
ATOM    315  HA  ASP A  19      24.695  78.378  15.330  1.00  0.00           H  
ATOM    316  HB2 ASP A  19      26.288  79.928  16.308  1.00  0.00           H  
ATOM    317  HB3 ASP A  19      26.728  80.531  14.713  1.00  0.00           H  
ATOM    318  N   ASP A  20      25.630  79.182  12.293  1.00  0.00           N  
ATOM    319  CA  ASP A  20      25.148  79.446  10.942  1.00  0.00           C  
ATOM    320  C   ASP A  20      24.653  78.163  10.282  1.00  0.00           C  
ATOM    321  O   ASP A  20      25.113  77.792   9.201  1.00  0.00           O  
ATOM    322  CB  ASP A  20      26.257  80.074  10.096  1.00  0.00           C  
ATOM    323  CG  ASP A  20      26.346  81.576  10.282  1.00  0.00           C  
ATOM    324  OD1 ASP A  20      25.403  82.283   9.869  1.00  0.00           O  
ATOM    325  OD2 ASP A  20      27.358  82.045  10.842  1.00  0.00           O  
ATOM    326  H   ASP A  20      26.592  79.059  12.442  1.00  0.00           H  
ATOM    327  HA  ASP A  20      24.325  80.140  11.013  1.00  0.00           H  
ATOM    328  HB2 ASP A  20      27.204  79.639  10.374  1.00  0.00           H  
ATOM    329  HB3 ASP A  20      26.064  79.870   9.053  1.00  0.00           H  
ATOM    330  N   ILE A  21      23.715  77.489  10.939  1.00  0.00           N  
ATOM    331  CA  ILE A  21      23.158  76.249  10.416  1.00  0.00           C  
ATOM    332  C   ILE A  21      21.634  76.305  10.371  1.00  0.00           C  
ATOM    333  O   ILE A  21      20.996  76.835  11.280  1.00  0.00           O  
ATOM    334  CB  ILE A  21      23.590  75.036  11.261  1.00  0.00           C  
ATOM    335  CG1 ILE A  21      25.109  74.858  11.198  1.00  0.00           C  
ATOM    336  CG2 ILE A  21      22.883  73.776  10.783  1.00  0.00           C  
ATOM    337  CD1 ILE A  21      25.630  73.784  12.128  1.00  0.00           C  
ATOM    338  H   ILE A  21      23.389  77.835  11.795  1.00  0.00           H  
ATOM    339  HA  ILE A  21      23.532  76.112   9.411  1.00  0.00           H  
ATOM    340  HB  ILE A  21      23.299  75.217  12.284  1.00  0.00           H  
ATOM    341 HG12 ILE A  21      25.391  74.591  10.192  1.00  0.00           H  
ATOM    342 HG13 ILE A  21      25.584  75.790  11.466  1.00  0.00           H  
ATOM    343 HG21 ILE A  21      23.073  73.636   9.729  1.00  0.00           H  
ATOM    344 HG22 ILE A  21      23.256  72.924  11.331  1.00  0.00           H  
ATOM    345 HG23 ILE A  21      21.821  73.875  10.947  1.00  0.00           H  
ATOM    346 HD11 ILE A  21      25.235  72.825  11.827  1.00  0.00           H  
ATOM    347 HD12 ILE A  21      26.709  73.760  12.079  1.00  0.00           H  
ATOM    348 HD13 ILE A  21      25.319  74.001  13.138  1.00  0.00           H  
ATOM    349  N   ILE A  22      21.058  75.754   9.307  1.00  0.00           N  
ATOM    350  CA  ILE A  22      19.610  75.740   9.146  1.00  0.00           C  
ATOM    351  C   ILE A  22      19.107  74.338   8.818  1.00  0.00           C  
ATOM    352  O   ILE A  22      19.886  73.386   8.760  1.00  0.00           O  
ATOM    353  CB  ILE A  22      19.157  76.708   8.037  1.00  0.00           C  
ATOM    354  CG1 ILE A  22      19.918  76.424   6.740  1.00  0.00           C  
ATOM    355  CG2 ILE A  22      19.367  78.150   8.475  1.00  0.00           C  
ATOM    356  CD1 ILE A  22      19.307  77.086   5.525  1.00  0.00           C  
ATOM    357  H   ILE A  22      21.621  75.348   8.617  1.00  0.00           H  
ATOM    358  HA  ILE A  22      19.167  76.060  10.078  1.00  0.00           H  
ATOM    359  HB  ILE A  22      18.103  76.559   7.868  1.00  0.00           H  
ATOM    360 HG12 ILE A  22      20.931  76.781   6.838  1.00  0.00           H  
ATOM    361 HG13 ILE A  22      19.931  75.358   6.567  1.00  0.00           H  
ATOM    362 HG21 ILE A  22      20.234  78.556   7.975  1.00  0.00           H  
ATOM    363 HG22 ILE A  22      18.497  78.735   8.218  1.00  0.00           H  
ATOM    364 HG23 ILE A  22      19.519  78.183   9.544  1.00  0.00           H  
ATOM    365 HD11 ILE A  22      18.262  76.821   5.458  1.00  0.00           H  
ATOM    366 HD12 ILE A  22      19.401  78.159   5.614  1.00  0.00           H  
ATOM    367 HD13 ILE A  22      19.821  76.752   4.636  1.00  0.00           H  
ATOM    368  N   ILE A  23      17.802  74.219   8.599  1.00  0.00           N  
ATOM    369  CA  ILE A  23      17.196  72.934   8.273  1.00  0.00           C  
ATOM    370  C   ILE A  23      17.556  72.502   6.856  1.00  0.00           C  
ATOM    371  O   ILE A  23      17.555  71.311   6.540  1.00  0.00           O  
ATOM    372  CB  ILE A  23      15.663  72.984   8.409  1.00  0.00           C  
ATOM    373  CG1 ILE A  23      15.266  73.256   9.862  1.00  0.00           C  
ATOM    374  CG2 ILE A  23      15.045  71.683   7.921  1.00  0.00           C  
ATOM    375  CD1 ILE A  23      15.256  74.724  10.222  1.00  0.00           C  
ATOM    376  H   ILE A  23      17.233  75.015   8.659  1.00  0.00           H  
ATOM    377  HA  ILE A  23      17.576  72.201   8.969  1.00  0.00           H  
ATOM    378  HB  ILE A  23      15.294  73.786   7.787  1.00  0.00           H  
ATOM    379 HG12 ILE A  23      14.277  72.865  10.038  1.00  0.00           H  
ATOM    380 HG13 ILE A  23      15.967  72.757  10.518  1.00  0.00           H  
ATOM    381 HG21 ILE A  23      14.023  71.619   8.263  1.00  0.00           H  
ATOM    382 HG22 ILE A  23      15.064  71.659   6.841  1.00  0.00           H  
ATOM    383 HG23 ILE A  23      15.608  70.848   8.309  1.00  0.00           H  
ATOM    384 HD11 ILE A  23      16.261  75.044  10.458  1.00  0.00           H  
ATOM    385 HD12 ILE A  23      14.885  75.298   9.385  1.00  0.00           H  
ATOM    386 HD13 ILE A  23      14.619  74.882  11.078  1.00  0.00           H  
ATOM    387  N   LYS A  24      17.864  73.475   6.007  1.00  0.00           N  
ATOM    388  CA  LYS A  24      18.229  73.196   4.622  1.00  0.00           C  
ATOM    389  C   LYS A  24      19.743  73.094   4.469  1.00  0.00           C  
ATOM    390  O   LYS A  24      20.256  72.945   3.360  1.00  0.00           O  
ATOM    391  CB  LYS A  24      17.685  74.289   3.699  1.00  0.00           C  
ATOM    392  CG  LYS A  24      16.188  74.199   3.465  1.00  0.00           C  
ATOM    393  CD  LYS A  24      15.415  75.055   4.454  1.00  0.00           C  
ATOM    394  CE  LYS A  24      13.963  75.219   4.032  1.00  0.00           C  
ATOM    395  NZ  LYS A  24      13.820  76.162   2.889  1.00  0.00           N  
ATOM    396  H   LYS A  24      17.846  74.405   6.318  1.00  0.00           H  
ATOM    397  HA  LYS A  24      17.786  72.252   4.347  1.00  0.00           H  
ATOM    398  HB2 LYS A  24      17.902  75.253   4.137  1.00  0.00           H  
ATOM    399  HB3 LYS A  24      18.184  74.217   2.743  1.00  0.00           H  
ATOM    400  HG2 LYS A  24      15.969  74.537   2.463  1.00  0.00           H  
ATOM    401  HG3 LYS A  24      15.878  73.169   3.575  1.00  0.00           H  
ATOM    402  HD2 LYS A  24      15.446  74.584   5.425  1.00  0.00           H  
ATOM    403  HD3 LYS A  24      15.877  76.031   4.510  1.00  0.00           H  
ATOM    404  HE2 LYS A  24      13.574  74.255   3.743  1.00  0.00           H  
ATOM    405  HE3 LYS A  24      13.399  75.597   4.873  1.00  0.00           H  
ATOM    406  HZ1 LYS A  24      14.751  76.536   2.616  1.00  0.00           H  
ATOM    407  HZ2 LYS A  24      13.203  76.956   3.156  1.00  0.00           H  
ATOM    408  HZ3 LYS A  24      13.401  75.673   2.072  1.00  0.00           H  
ATOM    409  N   CYS A  25      20.453  73.172   5.590  1.00  0.00           N  
ATOM    410  CA  CYS A  25      21.910  73.087   5.579  1.00  0.00           C  
ATOM    411  C   CYS A  25      22.370  71.637   5.692  1.00  0.00           C  
ATOM    412  O   CYS A  25      21.804  70.855   6.455  1.00  0.00           O  
ATOM    413  CB  CYS A  25      22.497  73.912   6.725  1.00  0.00           C  
ATOM    414  SG  CYS A  25      24.241  73.572   7.061  1.00  0.00           S  
ATOM    415  H   CYS A  25      19.988  73.291   6.444  1.00  0.00           H  
ATOM    416  HA  CYS A  25      22.257  73.490   4.641  1.00  0.00           H  
ATOM    417  HB2 CYS A  25      22.407  74.962   6.486  1.00  0.00           H  
ATOM    418  HB3 CYS A  25      21.941  73.707   7.628  1.00  0.00           H  
ATOM    419  HG  CYS A  25      24.302  72.641   7.999  1.00  0.00           H  
ATOM    420  N   GLN A  26      23.399  71.289   4.926  1.00  0.00           N  
ATOM    421  CA  GLN A  26      23.933  69.932   4.938  1.00  0.00           C  
ATOM    422  C   GLN A  26      25.424  69.937   5.259  1.00  0.00           C  
ATOM    423  O   GLN A  26      26.189  70.716   4.688  1.00  0.00           O  
ATOM    424  CB  GLN A  26      23.692  69.253   3.589  1.00  0.00           C  
ATOM    425  CG  GLN A  26      22.223  69.154   3.212  1.00  0.00           C  
ATOM    426  CD  GLN A  26      22.018  68.799   1.752  1.00  0.00           C  
ATOM    427  OE1 GLN A  26      22.042  67.626   1.377  1.00  0.00           O  
ATOM    428  NE2 GLN A  26      21.815  69.813   0.919  1.00  0.00           N  
ATOM    429  H   GLN A  26      23.807  71.957   4.339  1.00  0.00           H  
ATOM    430  HA  GLN A  26      23.415  69.378   5.707  1.00  0.00           H  
ATOM    431  HB2 GLN A  26      24.202  69.816   2.821  1.00  0.00           H  
ATOM    432  HB3 GLN A  26      24.101  68.255   3.623  1.00  0.00           H  
ATOM    433  HG2 GLN A  26      21.760  68.390   3.820  1.00  0.00           H  
ATOM    434  HG3 GLN A  26      21.750  70.104   3.406  1.00  0.00           H  
ATOM    435 HE21 GLN A  26      21.811  70.722   1.289  1.00  0.00           H  
ATOM    436 HE22 GLN A  26      21.681  69.614  -0.030  1.00  0.00           H  
ATOM    437  N   CYS A  27      25.830  69.066   6.176  1.00  0.00           N  
ATOM    438  CA  CYS A  27      27.231  68.971   6.574  1.00  0.00           C  
ATOM    439  C   CYS A  27      27.644  67.516   6.769  1.00  0.00           C  
ATOM    440  O   CYS A  27      26.827  66.605   6.628  1.00  0.00           O  
ATOM    441  CB  CYS A  27      27.471  69.759   7.862  1.00  0.00           C  
ATOM    442  SG  CYS A  27      26.386  69.288   9.229  1.00  0.00           S  
ATOM    443  H   CYS A  27      25.174  68.472   6.595  1.00  0.00           H  
ATOM    444  HA  CYS A  27      27.828  69.398   5.783  1.00  0.00           H  
ATOM    445  HB2 CYS A  27      28.490  69.606   8.184  1.00  0.00           H  
ATOM    446  HB3 CYS A  27      27.317  70.810   7.666  1.00  0.00           H  
ATOM    447  HG  CYS A  27      26.926  68.243   9.837  1.00  0.00           H  
ATOM    448  N   TRP A  28      28.914  67.305   7.092  1.00  0.00           N  
ATOM    449  CA  TRP A  28      29.435  65.960   7.305  1.00  0.00           C  
ATOM    450  C   TRP A  28      29.497  65.629   8.792  1.00  0.00           C  
ATOM    451  O   TRP A  28      29.844  66.478   9.613  1.00  0.00           O  
ATOM    452  CB  TRP A  28      30.826  65.824   6.682  1.00  0.00           C  
ATOM    453  CG  TRP A  28      30.799  65.721   5.187  1.00  0.00           C  
ATOM    454  CD1 TRP A  28      30.750  66.753   4.294  1.00  0.00           C  
ATOM    455  CD2 TRP A  28      30.818  64.518   4.411  1.00  0.00           C  
ATOM    456  NE1 TRP A  28      30.737  66.265   3.011  1.00  0.00           N  
ATOM    457  CE2 TRP A  28      30.779  64.896   3.054  1.00  0.00           C  
ATOM    458  CE3 TRP A  28      30.866  63.158   4.729  1.00  0.00           C  
ATOM    459  CZ2 TRP A  28      30.786  63.963   2.021  1.00  0.00           C  
ATOM    460  CZ3 TRP A  28      30.871  62.233   3.703  1.00  0.00           C  
ATOM    461  CH2 TRP A  28      30.832  62.638   2.362  1.00  0.00           C  
ATOM    462  H   TRP A  28      29.517  68.072   7.190  1.00  0.00           H  
ATOM    463  HA  TRP A  28      28.764  65.264   6.820  1.00  0.00           H  
ATOM    464  HB2 TRP A  28      31.417  66.689   6.945  1.00  0.00           H  
ATOM    465  HB3 TRP A  28      31.301  64.935   7.071  1.00  0.00           H  
ATOM    466  HD1 TRP A  28      30.724  67.796   4.571  1.00  0.00           H  
ATOM    467  HE1 TRP A  28      30.705  66.809   2.195  1.00  0.00           H  
ATOM    468  HE3 TRP A  28      30.896  62.826   5.756  1.00  0.00           H  
ATOM    469  HZ2 TRP A  28      30.756  64.259   0.983  1.00  0.00           H  
ATOM    470  HZ3 TRP A  28      30.907  61.177   3.930  1.00  0.00           H  
ATOM    471  HH2 TRP A  28      30.839  61.881   1.593  1.00  0.00           H  
ATOM    472  N   VAL A  29      29.158  64.390   9.133  1.00  0.00           N  
ATOM    473  CA  VAL A  29      29.176  63.946  10.522  1.00  0.00           C  
ATOM    474  C   VAL A  29      30.091  62.740  10.702  1.00  0.00           C  
ATOM    475  O   VAL A  29      30.073  61.811   9.894  1.00  0.00           O  
ATOM    476  CB  VAL A  29      27.762  63.584  11.014  1.00  0.00           C  
ATOM    477  CG1 VAL A  29      27.771  63.316  12.511  1.00  0.00           C  
ATOM    478  CG2 VAL A  29      26.778  64.691  10.668  1.00  0.00           C  
ATOM    479  H   VAL A  29      28.891  63.758   8.434  1.00  0.00           H  
ATOM    480  HA  VAL A  29      29.547  64.761  11.128  1.00  0.00           H  
ATOM    481  HB  VAL A  29      27.448  62.681  10.511  1.00  0.00           H  
ATOM    482 HG11 VAL A  29      26.901  62.732  12.777  1.00  0.00           H  
ATOM    483 HG12 VAL A  29      28.665  62.771  12.775  1.00  0.00           H  
ATOM    484 HG13 VAL A  29      27.749  64.255  13.044  1.00  0.00           H  
ATOM    485 HG21 VAL A  29      26.797  64.870   9.603  1.00  0.00           H  
ATOM    486 HG22 VAL A  29      25.784  64.394  10.966  1.00  0.00           H  
ATOM    487 HG23 VAL A  29      27.055  65.596  11.189  1.00  0.00           H  
ATOM    488  N   GLN A  30      30.886  62.761  11.767  1.00  0.00           N  
ATOM    489  CA  GLN A  30      31.808  61.667  12.052  1.00  0.00           C  
ATOM    490  C   GLN A  30      31.086  60.512  12.737  1.00  0.00           C  
ATOM    491  O   GLN A  30      30.558  60.662  13.840  1.00  0.00           O  
ATOM    492  CB  GLN A  30      32.959  62.160  12.931  1.00  0.00           C  
ATOM    493  CG  GLN A  30      33.873  61.046  13.415  1.00  0.00           C  
ATOM    494  CD  GLN A  30      35.259  61.543  13.775  1.00  0.00           C  
ATOM    495  OE1 GLN A  30      35.410  62.512  14.520  1.00  0.00           O  
ATOM    496  NE2 GLN A  30      36.281  60.881  13.246  1.00  0.00           N  
ATOM    497  H   GLN A  30      30.853  63.529  12.373  1.00  0.00           H  
ATOM    498  HA  GLN A  30      32.209  61.318  11.112  1.00  0.00           H  
ATOM    499  HB2 GLN A  30      33.551  62.863  12.367  1.00  0.00           H  
ATOM    500  HB3 GLN A  30      32.547  62.659  13.796  1.00  0.00           H  
ATOM    501  HG2 GLN A  30      33.433  60.591  14.291  1.00  0.00           H  
ATOM    502  HG3 GLN A  30      33.963  60.306  12.635  1.00  0.00           H  
ATOM    503 HE21 GLN A  30      36.085  60.120  12.660  1.00  0.00           H  
ATOM    504 HE22 GLN A  30      37.188  61.181  13.461  1.00  0.00           H  
ATOM    505  N   LYS A  31      31.066  59.359  12.078  1.00  0.00           N  
ATOM    506  CA  LYS A  31      30.410  58.176  12.623  1.00  0.00           C  
ATOM    507  C   LYS A  31      31.197  56.914  12.288  1.00  0.00           C  
ATOM    508  O   LYS A  31      31.660  56.740  11.162  1.00  0.00           O  
ATOM    509  CB  LYS A  31      28.985  58.062  12.076  1.00  0.00           C  
ATOM    510  CG  LYS A  31      27.959  57.671  13.126  1.00  0.00           C  
ATOM    511  CD  LYS A  31      27.859  58.717  14.223  1.00  0.00           C  
ATOM    512  CE  LYS A  31      26.624  58.502  15.086  1.00  0.00           C  
ATOM    513  NZ  LYS A  31      26.350  59.674  15.964  1.00  0.00           N  
ATOM    514  H   LYS A  31      31.504  59.301  11.203  1.00  0.00           H  
ATOM    515  HA  LYS A  31      30.366  58.287  13.696  1.00  0.00           H  
ATOM    516  HB2 LYS A  31      28.695  59.014  11.657  1.00  0.00           H  
ATOM    517  HB3 LYS A  31      28.971  57.315  11.295  1.00  0.00           H  
ATOM    518  HG2 LYS A  31      26.995  57.565  12.653  1.00  0.00           H  
ATOM    519  HG3 LYS A  31      28.251  56.727  13.567  1.00  0.00           H  
ATOM    520  HD2 LYS A  31      28.736  58.657  14.849  1.00  0.00           H  
ATOM    521  HD3 LYS A  31      27.804  59.697  13.770  1.00  0.00           H  
ATOM    522  HE2 LYS A  31      25.774  58.341  14.441  1.00  0.00           H  
ATOM    523  HE3 LYS A  31      26.780  57.630  15.703  1.00  0.00           H  
ATOM    524  HZ1 LYS A  31      25.346  59.695  16.231  1.00  0.00           H  
ATOM    525  HZ2 LYS A  31      26.583  60.556  15.465  1.00  0.00           H  
ATOM    526  HZ3 LYS A  31      26.926  59.615  16.827  1.00  0.00           H  
ATOM    527  N   ASN A  32      31.344  56.035  13.274  1.00  0.00           N  
ATOM    528  CA  ASN A  32      32.076  54.787  13.084  1.00  0.00           C  
ATOM    529  C   ASN A  32      33.455  55.052  12.488  1.00  0.00           C  
ATOM    530  O   ASN A  32      33.842  54.437  11.496  1.00  0.00           O  
ATOM    531  CB  ASN A  32      31.287  53.844  12.174  1.00  0.00           C  
ATOM    532  CG  ASN A  32      31.881  52.450  12.134  1.00  0.00           C  
ATOM    533  OD1 ASN A  32      31.974  51.772  13.158  1.00  0.00           O  
ATOM    534  ND2 ASN A  32      32.289  52.015  10.947  1.00  0.00           N  
ATOM    535  H   ASN A  32      30.951  56.230  14.151  1.00  0.00           H  
ATOM    536  HA  ASN A  32      32.196  54.324  14.051  1.00  0.00           H  
ATOM    537  HB2 ASN A  32      30.271  53.771  12.535  1.00  0.00           H  
ATOM    538  HB3 ASN A  32      31.280  54.242  11.171  1.00  0.00           H  
ATOM    539 HD21 ASN A  32      32.184  52.609  10.174  1.00  0.00           H  
ATOM    540 HD22 ASN A  32      32.676  51.116  10.891  1.00  0.00           H  
ATOM    541  N   ASP A  33      34.193  55.970  13.103  1.00  0.00           N  
ATOM    542  CA  ASP A  33      35.531  56.315  12.635  1.00  0.00           C  
ATOM    543  C   ASP A  33      35.515  56.657  11.149  1.00  0.00           C  
ATOM    544  O   ASP A  33      36.504  56.454  10.447  1.00  0.00           O  
ATOM    545  CB  ASP A  33      36.498  55.159  12.897  1.00  0.00           C  
ATOM    546  CG  ASP A  33      37.919  55.635  13.123  1.00  0.00           C  
ATOM    547  OD1 ASP A  33      38.129  56.467  14.031  1.00  0.00           O  
ATOM    548  OD2 ASP A  33      38.823  55.175  12.394  1.00  0.00           O  
ATOM    549  H   ASP A  33      33.829  56.427  13.891  1.00  0.00           H  
ATOM    550  HA  ASP A  33      35.861  57.181  13.188  1.00  0.00           H  
ATOM    551  HB2 ASP A  33      36.175  54.618  13.773  1.00  0.00           H  
ATOM    552  HB3 ASP A  33      36.491  54.494  12.045  1.00  0.00           H  
ATOM    553  N   GLU A  34      34.385  57.174  10.678  1.00  0.00           N  
ATOM    554  CA  GLU A  34      34.241  57.543   9.274  1.00  0.00           C  
ATOM    555  C   GLU A  34      33.469  58.851   9.131  1.00  0.00           C  
ATOM    556  O   GLU A  34      32.988  59.409  10.115  1.00  0.00           O  
ATOM    557  CB  GLU A  34      33.529  56.429   8.503  1.00  0.00           C  
ATOM    558  CG  GLU A  34      34.447  55.291   8.090  1.00  0.00           C  
ATOM    559  CD  GLU A  34      33.830  54.401   7.028  1.00  0.00           C  
ATOM    560  OE1 GLU A  34      32.856  54.838   6.380  1.00  0.00           O  
ATOM    561  OE2 GLU A  34      34.322  53.268   6.845  1.00  0.00           O  
ATOM    562  H   GLU A  34      33.631  57.312  11.288  1.00  0.00           H  
ATOM    563  HA  GLU A  34      35.231  57.676   8.863  1.00  0.00           H  
ATOM    564  HB2 GLU A  34      32.743  56.025   9.122  1.00  0.00           H  
ATOM    565  HB3 GLU A  34      33.090  56.851   7.610  1.00  0.00           H  
ATOM    566  HG2 GLU A  34      35.363  55.707   7.701  1.00  0.00           H  
ATOM    567  HG3 GLU A  34      34.666  54.690   8.960  1.00  0.00           H  
ATOM    568  N   GLU A  35      33.355  59.333   7.897  1.00  0.00           N  
ATOM    569  CA  GLU A  35      32.643  60.575   7.625  1.00  0.00           C  
ATOM    570  C   GLU A  35      31.474  60.335   6.674  1.00  0.00           C  
ATOM    571  O   GLU A  35      31.644  59.769   5.594  1.00  0.00           O  
ATOM    572  CB  GLU A  35      33.595  61.614   7.028  1.00  0.00           C  
ATOM    573  CG  GLU A  35      34.070  62.652   8.031  1.00  0.00           C  
ATOM    574  CD  GLU A  35      35.412  63.250   7.661  1.00  0.00           C  
ATOM    575  OE1 GLU A  35      36.021  62.781   6.677  1.00  0.00           O  
ATOM    576  OE2 GLU A  35      35.855  64.189   8.356  1.00  0.00           O  
ATOM    577  H   GLU A  35      33.761  58.840   7.152  1.00  0.00           H  
ATOM    578  HA  GLU A  35      32.260  60.948   8.562  1.00  0.00           H  
ATOM    579  HB2 GLU A  35      34.461  61.106   6.631  1.00  0.00           H  
ATOM    580  HB3 GLU A  35      33.089  62.127   6.223  1.00  0.00           H  
ATOM    581  HG2 GLU A  35      33.340  63.446   8.080  1.00  0.00           H  
ATOM    582  HG3 GLU A  35      34.155  62.184   9.001  1.00  0.00           H  
ATOM    583  N   ARG A  36      30.287  60.769   7.085  1.00  0.00           N  
ATOM    584  CA  ARG A  36      29.089  60.600   6.272  1.00  0.00           C  
ATOM    585  C   ARG A  36      28.344  61.923   6.120  1.00  0.00           C  
ATOM    586  O   ARG A  36      28.201  62.681   7.080  1.00  0.00           O  
ATOM    587  CB  ARG A  36      28.166  59.552   6.897  1.00  0.00           C  
ATOM    588  CG  ARG A  36      28.820  58.191   7.071  1.00  0.00           C  
ATOM    589  CD  ARG A  36      27.783  57.083   7.176  1.00  0.00           C  
ATOM    590  NE  ARG A  36      27.378  56.586   5.864  1.00  0.00           N  
ATOM    591  CZ  ARG A  36      28.169  55.871   5.074  1.00  0.00           C  
ATOM    592  NH1 ARG A  36      29.402  55.571   5.459  1.00  0.00           N  
ATOM    593  NH2 ARG A  36      27.728  55.455   3.893  1.00  0.00           N  
ATOM    594  H   ARG A  36      30.215  61.212   7.956  1.00  0.00           H  
ATOM    595  HA  ARG A  36      29.396  60.260   5.294  1.00  0.00           H  
ATOM    596  HB2 ARG A  36      27.849  59.901   7.868  1.00  0.00           H  
ATOM    597  HB3 ARG A  36      27.298  59.432   6.265  1.00  0.00           H  
ATOM    598  HG2 ARG A  36      29.454  57.995   6.218  1.00  0.00           H  
ATOM    599  HG3 ARG A  36      29.416  58.202   7.971  1.00  0.00           H  
ATOM    600  HD2 ARG A  36      28.204  56.269   7.746  1.00  0.00           H  
ATOM    601  HD3 ARG A  36      26.915  57.470   7.689  1.00  0.00           H  
ATOM    602  HE  ARG A  36      26.471  56.796   5.560  1.00  0.00           H  
ATOM    603 HH11 ARG A  36      29.737  55.883   6.348  1.00  0.00           H  
ATOM    604 HH12 ARG A  36      29.996  55.031   4.861  1.00  0.00           H  
ATOM    605 HH21 ARG A  36      26.800  55.678   3.600  1.00  0.00           H  
ATOM    606 HH22 ARG A  36      28.325  54.916   3.298  1.00  0.00           H  
ATOM    607  N   LEU A  37      27.871  62.194   4.909  1.00  0.00           N  
ATOM    608  CA  LEU A  37      27.141  63.427   4.630  1.00  0.00           C  
ATOM    609  C   LEU A  37      25.757  63.395   5.270  1.00  0.00           C  
ATOM    610  O   LEU A  37      24.872  62.665   4.823  1.00  0.00           O  
ATOM    611  CB  LEU A  37      27.013  63.636   3.120  1.00  0.00           C  
ATOM    612  CG  LEU A  37      26.553  65.024   2.673  1.00  0.00           C  
ATOM    613  CD1 LEU A  37      27.742  65.958   2.521  1.00  0.00           C  
ATOM    614  CD2 LEU A  37      25.775  64.932   1.367  1.00  0.00           C  
ATOM    615  H   LEU A  37      28.016  61.551   4.183  1.00  0.00           H  
ATOM    616  HA  LEU A  37      27.702  64.247   5.053  1.00  0.00           H  
ATOM    617  HB2 LEU A  37      27.979  63.450   2.678  1.00  0.00           H  
ATOM    618  HB3 LEU A  37      26.302  62.913   2.745  1.00  0.00           H  
ATOM    619  HG  LEU A  37      25.897  65.439   3.426  1.00  0.00           H  
ATOM    620 HD11 LEU A  37      28.135  66.203   3.497  1.00  0.00           H  
ATOM    621 HD12 LEU A  37      27.429  66.863   2.023  1.00  0.00           H  
ATOM    622 HD13 LEU A  37      28.510  65.472   1.936  1.00  0.00           H  
ATOM    623 HD21 LEU A  37      24.934  65.609   1.402  1.00  0.00           H  
ATOM    624 HD22 LEU A  37      25.420  63.921   1.231  1.00  0.00           H  
ATOM    625 HD23 LEU A  37      26.421  65.200   0.544  1.00  0.00           H  
ATOM    626  N   ALA A  38      25.577  64.194   6.316  1.00  0.00           N  
ATOM    627  CA  ALA A  38      24.298  64.262   7.014  1.00  0.00           C  
ATOM    628  C   ALA A  38      23.595  65.587   6.746  1.00  0.00           C  
ATOM    629  O   ALA A  38      24.226  66.644   6.736  1.00  0.00           O  
ATOM    630  CB  ALA A  38      24.502  64.064   8.509  1.00  0.00           C  
ATOM    631  H   ALA A  38      26.319  64.753   6.625  1.00  0.00           H  
ATOM    632  HA  ALA A  38      23.677  63.455   6.651  1.00  0.00           H  
ATOM    633  HB1 ALA A  38      23.577  63.733   8.957  1.00  0.00           H  
ATOM    634  HB2 ALA A  38      25.268  63.320   8.672  1.00  0.00           H  
ATOM    635  HB3 ALA A  38      24.807  64.998   8.957  1.00  0.00           H  
ATOM    636  N   GLU A  39      22.285  65.524   6.527  1.00  0.00           N  
ATOM    637  CA  GLU A  39      21.498  66.721   6.257  1.00  0.00           C  
ATOM    638  C   GLU A  39      20.758  67.181   7.510  1.00  0.00           C  
ATOM    639  O   GLU A  39      20.089  66.389   8.174  1.00  0.00           O  
ATOM    640  CB  GLU A  39      20.497  66.456   5.130  1.00  0.00           C  
ATOM    641  CG  GLU A  39      19.489  67.576   4.935  1.00  0.00           C  
ATOM    642  CD  GLU A  39      18.653  67.398   3.682  1.00  0.00           C  
ATOM    643  OE1 GLU A  39      18.462  66.240   3.258  1.00  0.00           O  
ATOM    644  OE2 GLU A  39      18.193  68.416   3.126  1.00  0.00           O  
ATOM    645  H   GLU A  39      21.839  64.652   6.548  1.00  0.00           H  
ATOM    646  HA  GLU A  39      22.175  67.502   5.947  1.00  0.00           H  
ATOM    647  HB2 GLU A  39      21.040  66.323   4.206  1.00  0.00           H  
ATOM    648  HB3 GLU A  39      19.956  65.548   5.352  1.00  0.00           H  
ATOM    649  HG2 GLU A  39      18.829  67.602   5.789  1.00  0.00           H  
ATOM    650  HG3 GLU A  39      20.021  68.514   4.865  1.00  0.00           H  
ATOM    651  N   ILE A  40      20.886  68.465   7.828  1.00  0.00           N  
ATOM    652  CA  ILE A  40      20.231  69.029   9.000  1.00  0.00           C  
ATOM    653  C   ILE A  40      18.713  68.952   8.874  1.00  0.00           C  
ATOM    654  O   ILE A  40      18.159  69.142   7.790  1.00  0.00           O  
ATOM    655  CB  ILE A  40      20.641  70.498   9.222  1.00  0.00           C  
ATOM    656  CG1 ILE A  40      22.162  70.613   9.337  1.00  0.00           C  
ATOM    657  CG2 ILE A  40      19.966  71.054  10.467  1.00  0.00           C  
ATOM    658  CD1 ILE A  40      22.727  69.949  10.573  1.00  0.00           C  
ATOM    659  H   ILE A  40      21.434  69.045   7.260  1.00  0.00           H  
ATOM    660  HA  ILE A  40      20.540  68.457   9.863  1.00  0.00           H  
ATOM    661  HB  ILE A  40      20.306  71.073   8.373  1.00  0.00           H  
ATOM    662 HG12 ILE A  40      22.619  70.152   8.476  1.00  0.00           H  
ATOM    663 HG13 ILE A  40      22.435  71.658   9.367  1.00  0.00           H  
ATOM    664 HG21 ILE A  40      18.970  71.390  10.217  1.00  0.00           H  
ATOM    665 HG22 ILE A  40      19.907  70.282  11.219  1.00  0.00           H  
ATOM    666 HG23 ILE A  40      20.542  71.884  10.848  1.00  0.00           H  
ATOM    667 HD11 ILE A  40      21.952  69.369  11.055  1.00  0.00           H  
ATOM    668 HD12 ILE A  40      23.540  69.297  10.292  1.00  0.00           H  
ATOM    669 HD13 ILE A  40      23.088  70.704  11.255  1.00  0.00           H  
ATOM    670  N   LEU A  41      18.046  68.671   9.987  1.00  0.00           N  
ATOM    671  CA  LEU A  41      16.590  68.569  10.002  1.00  0.00           C  
ATOM    672  C   LEU A  41      15.981  69.616  10.928  1.00  0.00           C  
ATOM    673  O   LEU A  41      14.918  70.168  10.642  1.00  0.00           O  
ATOM    674  CB  LEU A  41      16.163  67.169  10.446  1.00  0.00           C  
ATOM    675  CG  LEU A  41      16.291  66.063   9.396  1.00  0.00           C  
ATOM    676  CD1 LEU A  41      15.834  64.730   9.967  1.00  0.00           C  
ATOM    677  CD2 LEU A  41      15.490  66.416   8.151  1.00  0.00           C  
ATOM    678  H   LEU A  41      18.542  68.528  10.821  1.00  0.00           H  
ATOM    679  HA  LEU A  41      16.236  68.743   8.998  1.00  0.00           H  
ATOM    680  HB2 LEU A  41      16.769  66.890  11.295  1.00  0.00           H  
ATOM    681  HB3 LEU A  41      15.126  67.220  10.748  1.00  0.00           H  
ATOM    682  HG  LEU A  41      17.328  65.965   9.111  1.00  0.00           H  
ATOM    683 HD11 LEU A  41      16.494  64.436  10.768  1.00  0.00           H  
ATOM    684 HD12 LEU A  41      15.853  63.980   9.190  1.00  0.00           H  
ATOM    685 HD13 LEU A  41      14.827  64.827  10.347  1.00  0.00           H  
ATOM    686 HD21 LEU A  41      14.564  66.891   8.440  1.00  0.00           H  
ATOM    687 HD22 LEU A  41      15.273  65.514   7.597  1.00  0.00           H  
ATOM    688 HD23 LEU A  41      16.064  67.089   7.532  1.00  0.00           H  
ATOM    689  N   SER A  42      16.662  69.887  12.037  1.00  0.00           N  
ATOM    690  CA  SER A  42      16.186  70.868  13.005  1.00  0.00           C  
ATOM    691  C   SER A  42      17.315  71.309  13.932  1.00  0.00           C  
ATOM    692  O   SER A  42      18.411  70.747  13.902  1.00  0.00           O  
ATOM    693  CB  SER A  42      15.034  70.287  13.828  1.00  0.00           C  
ATOM    694  OG  SER A  42      13.925  71.169  13.847  1.00  0.00           O  
ATOM    695  H   SER A  42      17.502  69.414  12.209  1.00  0.00           H  
ATOM    696  HA  SER A  42      15.828  71.728  12.459  1.00  0.00           H  
ATOM    697  HB2 SER A  42      14.724  69.348  13.395  1.00  0.00           H  
ATOM    698  HB3 SER A  42      15.367  70.123  14.843  1.00  0.00           H  
ATOM    699  HG  SER A  42      14.129  71.927  14.401  1.00  0.00           H  
ATOM    700  N   ILE A  43      17.040  72.316  14.752  1.00  0.00           N  
ATOM    701  CA  ILE A  43      18.031  72.832  15.687  1.00  0.00           C  
ATOM    702  C   ILE A  43      17.469  72.899  17.103  1.00  0.00           C  
ATOM    703  O   ILE A  43      16.301  73.229  17.303  1.00  0.00           O  
ATOM    704  CB  ILE A  43      18.519  74.234  15.275  1.00  0.00           C  
ATOM    705  CG1 ILE A  43      19.049  74.210  13.840  1.00  0.00           C  
ATOM    706  CG2 ILE A  43      19.594  74.724  16.233  1.00  0.00           C  
ATOM    707  CD1 ILE A  43      19.298  75.587  13.265  1.00  0.00           C  
ATOM    708  H   ILE A  43      16.148  72.722  14.729  1.00  0.00           H  
ATOM    709  HA  ILE A  43      18.878  72.160  15.679  1.00  0.00           H  
ATOM    710  HB  ILE A  43      17.683  74.913  15.332  1.00  0.00           H  
ATOM    711 HG12 ILE A  43      19.980  73.667  13.814  1.00  0.00           H  
ATOM    712 HG13 ILE A  43      18.329  73.712  13.207  1.00  0.00           H  
ATOM    713 HG21 ILE A  43      20.306  73.930  16.412  1.00  0.00           H  
ATOM    714 HG22 ILE A  43      20.104  75.571  15.800  1.00  0.00           H  
ATOM    715 HG23 ILE A  43      19.138  75.016  17.167  1.00  0.00           H  
ATOM    716 HD11 ILE A  43      18.730  76.318  13.822  1.00  0.00           H  
ATOM    717 HD12 ILE A  43      20.351  75.822  13.336  1.00  0.00           H  
ATOM    718 HD13 ILE A  43      18.993  75.607  12.230  1.00  0.00           H  
ATOM    719  N   ASN A  44      18.310  72.584  18.084  1.00  0.00           N  
ATOM    720  CA  ASN A  44      17.897  72.610  19.482  1.00  0.00           C  
ATOM    721  C   ASN A  44      18.936  73.322  20.343  1.00  0.00           C  
ATOM    722  O   ASN A  44      19.956  72.742  20.716  1.00  0.00           O  
ATOM    723  CB  ASN A  44      17.682  71.185  19.998  1.00  0.00           C  
ATOM    724  CG  ASN A  44      17.448  71.142  21.495  1.00  0.00           C  
ATOM    725  OD1 ASN A  44      16.853  72.055  22.068  1.00  0.00           O  
ATOM    726  ND2 ASN A  44      17.916  70.078  22.137  1.00  0.00           N  
ATOM    727  H   ASN A  44      19.229  72.329  17.862  1.00  0.00           H  
ATOM    728  HA  ASN A  44      16.964  73.149  19.543  1.00  0.00           H  
ATOM    729  HB2 ASN A  44      16.821  70.757  19.506  1.00  0.00           H  
ATOM    730  HB3 ASN A  44      18.554  70.591  19.771  1.00  0.00           H  
ATOM    731 HD21 ASN A  44      18.380  69.390  21.616  1.00  0.00           H  
ATOM    732 HD22 ASN A  44      17.777  70.024  23.106  1.00  0.00           H  
ATOM    733  N   THR A  45      18.669  74.587  20.657  1.00  0.00           N  
ATOM    734  CA  THR A  45      19.580  75.381  21.472  1.00  0.00           C  
ATOM    735  C   THR A  45      19.107  75.443  22.920  1.00  0.00           C  
ATOM    736  O   THR A  45      18.761  76.512  23.424  1.00  0.00           O  
ATOM    737  CB  THR A  45      19.719  76.814  20.927  1.00  0.00           C  
ATOM    738  OG1 THR A  45      18.434  77.444  20.872  1.00  0.00           O  
ATOM    739  CG2 THR A  45      20.346  76.807  19.540  1.00  0.00           C  
ATOM    740  H   THR A  45      17.840  74.995  20.329  1.00  0.00           H  
ATOM    741  HA  THR A  45      20.552  74.909  21.441  1.00  0.00           H  
ATOM    742  HB  THR A  45      20.359  77.375  21.592  1.00  0.00           H  
ATOM    743  HG1 THR A  45      18.531  78.384  21.046  1.00  0.00           H  
ATOM    744 HG21 THR A  45      19.581  76.984  18.799  1.00  0.00           H  
ATOM    745 HG22 THR A  45      20.807  75.847  19.359  1.00  0.00           H  
ATOM    746 HG23 THR A  45      21.093  77.584  19.480  1.00  0.00           H  
ATOM    747  N   ARG A  46      19.097  74.293  23.585  1.00  0.00           N  
ATOM    748  CA  ARG A  46      18.666  74.218  24.976  1.00  0.00           C  
ATOM    749  C   ARG A  46      19.797  73.717  25.869  1.00  0.00           C  
ATOM    750  O   ARG A  46      19.590  73.428  27.048  1.00  0.00           O  
ATOM    751  CB  ARG A  46      17.452  73.297  25.107  1.00  0.00           C  
ATOM    752  CG  ARG A  46      16.132  73.979  24.782  1.00  0.00           C  
ATOM    753  CD  ARG A  46      15.669  74.871  25.923  1.00  0.00           C  
ATOM    754  NE  ARG A  46      14.216  75.015  25.951  1.00  0.00           N  
ATOM    755  CZ  ARG A  46      13.542  75.466  27.003  1.00  0.00           C  
ATOM    756  NH1 ARG A  46      14.188  75.816  28.107  1.00  0.00           N  
ATOM    757  NH2 ARG A  46      12.221  75.568  26.952  1.00  0.00           N  
ATOM    758  H   ARG A  46      19.384  73.474  23.130  1.00  0.00           H  
ATOM    759  HA  ARG A  46      18.388  75.213  25.292  1.00  0.00           H  
ATOM    760  HB2 ARG A  46      17.574  72.461  24.435  1.00  0.00           H  
ATOM    761  HB3 ARG A  46      17.401  72.931  26.121  1.00  0.00           H  
ATOM    762  HG2 ARG A  46      16.259  74.584  23.895  1.00  0.00           H  
ATOM    763  HG3 ARG A  46      15.383  73.224  24.600  1.00  0.00           H  
ATOM    764  HD2 ARG A  46      15.996  74.439  26.856  1.00  0.00           H  
ATOM    765  HD3 ARG A  46      16.116  75.847  25.803  1.00  0.00           H  
ATOM    766  HE  ARG A  46      13.720  74.762  25.145  1.00  0.00           H  
ATOM    767 HH11 ARG A  46      15.184  75.741  28.148  1.00  0.00           H  
ATOM    768 HH12 ARG A  46      13.678  76.156  28.898  1.00  0.00           H  
ATOM    769 HH21 ARG A  46      11.731  75.305  26.121  1.00  0.00           H  
ATOM    770 HH22 ARG A  46      11.715  75.907  27.744  1.00  0.00           H  
ATOM    771  N   LYS A  47      20.993  73.616  25.300  1.00  0.00           N  
ATOM    772  CA  LYS A  47      22.158  73.150  26.042  1.00  0.00           C  
ATOM    773  C   LYS A  47      23.399  73.954  25.668  1.00  0.00           C  
ATOM    774  O   LYS A  47      23.347  74.826  24.803  1.00  0.00           O  
ATOM    775  CB  LYS A  47      22.400  71.663  25.772  1.00  0.00           C  
ATOM    776  CG  LYS A  47      22.728  70.864  27.021  1.00  0.00           C  
ATOM    777  CD  LYS A  47      21.488  70.608  27.862  1.00  0.00           C  
ATOM    778  CE  LYS A  47      20.890  69.241  27.570  1.00  0.00           C  
ATOM    779  NZ  LYS A  47      19.698  69.335  26.681  1.00  0.00           N  
ATOM    780  H   LYS A  47      21.095  73.861  24.356  1.00  0.00           H  
ATOM    781  HA  LYS A  47      21.958  73.288  27.094  1.00  0.00           H  
ATOM    782  HB2 LYS A  47      21.512  71.242  25.324  1.00  0.00           H  
ATOM    783  HB3 LYS A  47      23.224  71.565  25.080  1.00  0.00           H  
ATOM    784  HG2 LYS A  47      23.154  69.916  26.730  1.00  0.00           H  
ATOM    785  HG3 LYS A  47      23.446  71.415  27.614  1.00  0.00           H  
ATOM    786  HD2 LYS A  47      21.757  70.655  28.907  1.00  0.00           H  
ATOM    787  HD3 LYS A  47      20.753  71.368  27.643  1.00  0.00           H  
ATOM    788  HE2 LYS A  47      21.638  68.629  27.091  1.00  0.00           H  
ATOM    789  HE3 LYS A  47      20.595  68.784  28.504  1.00  0.00           H  
ATOM    790  HZ1 LYS A  47      19.986  69.242  25.686  1.00  0.00           H  
ATOM    791  HZ2 LYS A  47      19.229  70.254  26.810  1.00  0.00           H  
ATOM    792  HZ3 LYS A  47      19.022  68.579  26.908  1.00  0.00           H  
ATOM    793  N   ALA A  48      24.514  73.653  26.326  1.00  0.00           N  
ATOM    794  CA  ALA A  48      25.768  74.346  26.060  1.00  0.00           C  
ATOM    795  C   ALA A  48      26.946  73.378  26.087  1.00  0.00           C  
ATOM    796  O   ALA A  48      27.388  72.928  27.144  1.00  0.00           O  
ATOM    797  CB  ALA A  48      25.979  75.464  27.071  1.00  0.00           C  
ATOM    798  H   ALA A  48      24.492  72.948  27.007  1.00  0.00           H  
ATOM    799  HA  ALA A  48      25.703  74.790  25.077  1.00  0.00           H  
ATOM    800  HB1 ALA A  48      25.622  75.144  28.039  1.00  0.00           H  
ATOM    801  HB2 ALA A  48      27.031  75.698  27.134  1.00  0.00           H  
ATOM    802  HB3 ALA A  48      25.432  76.340  26.757  1.00  0.00           H  
ATOM    803  N   PRO A  49      27.468  73.047  24.896  1.00  0.00           N  
ATOM    804  CA  PRO A  49      26.949  73.574  23.630  1.00  0.00           C  
ATOM    805  C   PRO A  49      25.570  73.018  23.291  1.00  0.00           C  
ATOM    806  O   PRO A  49      25.112  72.033  23.871  1.00  0.00           O  
ATOM    807  CB  PRO A  49      27.982  73.108  22.601  1.00  0.00           C  
ATOM    808  CG  PRO A  49      28.599  71.895  23.209  1.00  0.00           C  
ATOM    809  CD  PRO A  49      28.602  72.130  24.693  1.00  0.00           C  
ATOM    810  HA  PRO A  49      26.908  74.654  23.637  1.00  0.00           H  
ATOM    811  HB2 PRO A  49      27.486  72.875  21.670  1.00  0.00           H  
ATOM    812  HB3 PRO A  49      28.714  73.885  22.442  1.00  0.00           H  
ATOM    813  HG2 PRO A  49      28.009  71.024  22.968  1.00  0.00           H  
ATOM    814  HG3 PRO A  49      29.610  71.777  22.845  1.00  0.00           H  
ATOM    815  HD2 PRO A  49      28.448  71.202  25.223  1.00  0.00           H  
ATOM    816  HD3 PRO A  49      29.530  72.593  24.999  1.00  0.00           H  
ATOM    817  N   PRO A  50      24.892  73.662  22.331  1.00  0.00           N  
ATOM    818  CA  PRO A  50      23.555  73.248  21.892  1.00  0.00           C  
ATOM    819  C   PRO A  50      23.579  71.929  21.128  1.00  0.00           C  
ATOM    820  O   PRO A  50      24.634  71.321  20.949  1.00  0.00           O  
ATOM    821  CB  PRO A  50      23.113  74.390  20.974  1.00  0.00           C  
ATOM    822  CG  PRO A  50      24.384  74.990  20.478  1.00  0.00           C  
ATOM    823  CD  PRO A  50      25.377  74.843  21.597  1.00  0.00           C  
ATOM    824  HA  PRO A  50      22.872  73.168  22.725  1.00  0.00           H  
ATOM    825  HB2 PRO A  50      22.519  73.993  20.162  1.00  0.00           H  
ATOM    826  HB3 PRO A  50      22.533  75.105  21.537  1.00  0.00           H  
ATOM    827  HG2 PRO A  50      24.724  74.457  19.602  1.00  0.00           H  
ATOM    828  HG3 PRO A  50      24.230  76.034  20.246  1.00  0.00           H  
ATOM    829  HD2 PRO A  50      26.367  74.673  21.203  1.00  0.00           H  
ATOM    830  HD3 PRO A  50      25.365  75.719  22.229  1.00  0.00           H  
ATOM    831  N   LYS A  51      22.408  71.490  20.678  1.00  0.00           N  
ATOM    832  CA  LYS A  51      22.293  70.244  19.930  1.00  0.00           C  
ATOM    833  C   LYS A  51      21.639  70.481  18.574  1.00  0.00           C  
ATOM    834  O   LYS A  51      20.938  71.474  18.376  1.00  0.00           O  
ATOM    835  CB  LYS A  51      21.482  69.220  20.728  1.00  0.00           C  
ATOM    836  CG  LYS A  51      22.289  68.503  21.796  1.00  0.00           C  
ATOM    837  CD  LYS A  51      21.435  67.514  22.572  1.00  0.00           C  
ATOM    838  CE  LYS A  51      22.289  66.467  23.270  1.00  0.00           C  
ATOM    839  NZ  LYS A  51      21.466  65.545  24.100  1.00  0.00           N  
ATOM    840  H   LYS A  51      21.601  72.019  20.852  1.00  0.00           H  
ATOM    841  HA  LYS A  51      23.289  69.857  19.774  1.00  0.00           H  
ATOM    842  HB2 LYS A  51      20.658  69.727  21.208  1.00  0.00           H  
ATOM    843  HB3 LYS A  51      21.089  68.480  20.046  1.00  0.00           H  
ATOM    844  HG2 LYS A  51      23.100  67.968  21.324  1.00  0.00           H  
ATOM    845  HG3 LYS A  51      22.690  69.235  22.484  1.00  0.00           H  
ATOM    846  HD2 LYS A  51      20.864  68.051  23.315  1.00  0.00           H  
ATOM    847  HD3 LYS A  51      20.761  67.019  21.887  1.00  0.00           H  
ATOM    848  HE2 LYS A  51      22.814  65.892  22.522  1.00  0.00           H  
ATOM    849  HE3 LYS A  51      23.003  66.969  23.905  1.00  0.00           H  
ATOM    850  HZ1 LYS A  51      22.025  65.191  24.902  1.00  0.00           H  
ATOM    851  HZ2 LYS A  51      21.149  64.736  23.529  1.00  0.00           H  
ATOM    852  HZ3 LYS A  51      20.631  66.043  24.467  1.00  0.00           H  
ATOM    853  N   PHE A  52      21.869  69.561  17.642  1.00  0.00           N  
ATOM    854  CA  PHE A  52      21.301  69.672  16.303  1.00  0.00           C  
ATOM    855  C   PHE A  52      20.812  68.314  15.808  1.00  0.00           C  
ATOM    856  O   PHE A  52      21.356  67.272  16.177  1.00  0.00           O  
ATOM    857  CB  PHE A  52      22.339  70.238  15.331  1.00  0.00           C  
ATOM    858  CG  PHE A  52      22.847  71.596  15.721  1.00  0.00           C  
ATOM    859  CD1 PHE A  52      23.790  71.735  16.728  1.00  0.00           C  
ATOM    860  CD2 PHE A  52      22.381  72.735  15.083  1.00  0.00           C  
ATOM    861  CE1 PHE A  52      24.260  72.983  17.089  1.00  0.00           C  
ATOM    862  CE2 PHE A  52      22.848  73.986  15.440  1.00  0.00           C  
ATOM    863  CZ  PHE A  52      23.788  74.110  16.445  1.00  0.00           C  
ATOM    864  H   PHE A  52      22.436  68.792  17.859  1.00  0.00           H  
ATOM    865  HA  PHE A  52      20.462  70.346  16.354  1.00  0.00           H  
ATOM    866  HB2 PHE A  52      23.184  69.568  15.286  1.00  0.00           H  
ATOM    867  HB3 PHE A  52      21.896  70.318  14.350  1.00  0.00           H  
ATOM    868  HD1 PHE A  52      24.160  70.853  17.232  1.00  0.00           H  
ATOM    869  HD2 PHE A  52      21.646  72.639  14.298  1.00  0.00           H  
ATOM    870  HE1 PHE A  52      24.994  73.076  17.875  1.00  0.00           H  
ATOM    871  HE2 PHE A  52      22.478  74.865  14.935  1.00  0.00           H  
ATOM    872  HZ  PHE A  52      24.154  75.086  16.726  1.00  0.00           H  
ATOM    873  N   TYR A  53      19.782  68.333  14.969  1.00  0.00           N  
ATOM    874  CA  TYR A  53      19.217  67.104  14.424  1.00  0.00           C  
ATOM    875  C   TYR A  53      19.728  66.849  13.010  1.00  0.00           C  
ATOM    876  O   TYR A  53      19.470  67.630  12.093  1.00  0.00           O  
ATOM    877  CB  TYR A  53      17.689  67.179  14.421  1.00  0.00           C  
ATOM    878  CG  TYR A  53      17.017  65.825  14.429  1.00  0.00           C  
ATOM    879  CD1 TYR A  53      17.411  64.837  15.323  1.00  0.00           C  
ATOM    880  CD2 TYR A  53      15.985  65.534  13.544  1.00  0.00           C  
ATOM    881  CE1 TYR A  53      16.799  63.598  15.334  1.00  0.00           C  
ATOM    882  CE2 TYR A  53      15.367  64.299  13.549  1.00  0.00           C  
ATOM    883  CZ  TYR A  53      15.778  63.334  14.446  1.00  0.00           C  
ATOM    884  OH  TYR A  53      15.165  62.102  14.454  1.00  0.00           O  
ATOM    885  H   TYR A  53      19.392  69.194  14.711  1.00  0.00           H  
ATOM    886  HA  TYR A  53      19.526  66.287  15.060  1.00  0.00           H  
ATOM    887  HB2 TYR A  53      17.359  67.718  15.296  1.00  0.00           H  
ATOM    888  HB3 TYR A  53      17.363  67.706  13.535  1.00  0.00           H  
ATOM    889  HD1 TYR A  53      18.210  65.048  16.018  1.00  0.00           H  
ATOM    890  HD2 TYR A  53      15.666  66.292  12.843  1.00  0.00           H  
ATOM    891  HE1 TYR A  53      17.121  62.843  16.036  1.00  0.00           H  
ATOM    892  HE2 TYR A  53      14.568  64.091  12.853  1.00  0.00           H  
ATOM    893  HH  TYR A  53      14.273  62.191  14.797  1.00  0.00           H  
ATOM    894  N   VAL A  54      20.455  65.750  12.839  1.00  0.00           N  
ATOM    895  CA  VAL A  54      21.002  65.389  11.537  1.00  0.00           C  
ATOM    896  C   VAL A  54      20.355  64.115  11.002  1.00  0.00           C  
ATOM    897  O   VAL A  54      19.827  63.307  11.767  1.00  0.00           O  
ATOM    898  CB  VAL A  54      22.527  65.187  11.605  1.00  0.00           C  
ATOM    899  CG1 VAL A  54      23.236  66.521  11.781  1.00  0.00           C  
ATOM    900  CG2 VAL A  54      22.887  64.231  12.732  1.00  0.00           C  
ATOM    901  H   VAL A  54      20.627  65.166  13.608  1.00  0.00           H  
ATOM    902  HA  VAL A  54      20.797  66.200  10.853  1.00  0.00           H  
ATOM    903  HB  VAL A  54      22.854  64.750  10.672  1.00  0.00           H  
ATOM    904 HG11 VAL A  54      23.254  66.784  12.828  1.00  0.00           H  
ATOM    905 HG12 VAL A  54      24.246  66.445  11.408  1.00  0.00           H  
ATOM    906 HG13 VAL A  54      22.705  67.285  11.230  1.00  0.00           H  
ATOM    907 HG21 VAL A  54      22.466  63.258  12.528  1.00  0.00           H  
ATOM    908 HG22 VAL A  54      23.962  64.150  12.805  1.00  0.00           H  
ATOM    909 HG23 VAL A  54      22.491  64.606  13.664  1.00  0.00           H  
ATOM    910  N   HIS A  55      20.400  63.944   9.686  1.00  0.00           N  
ATOM    911  CA  HIS A  55      19.818  62.767   9.048  1.00  0.00           C  
ATOM    912  C   HIS A  55      20.721  62.255   7.929  1.00  0.00           C  
ATOM    913  O   HIS A  55      20.955  62.950   6.941  1.00  0.00           O  
ATOM    914  CB  HIS A  55      18.432  63.094   8.492  1.00  0.00           C  
ATOM    915  CG  HIS A  55      17.969  62.139   7.437  1.00  0.00           C  
ATOM    916  ND1 HIS A  55      18.114  60.771   7.543  1.00  0.00           N  
ATOM    917  CD2 HIS A  55      17.359  62.359   6.248  1.00  0.00           C  
ATOM    918  CE1 HIS A  55      17.615  60.193   6.466  1.00  0.00           C  
ATOM    919  NE2 HIS A  55      17.150  61.135   5.664  1.00  0.00           N  
ATOM    920  H   HIS A  55      20.833  64.623   9.129  1.00  0.00           H  
ATOM    921  HA  HIS A  55      19.723  61.997   9.798  1.00  0.00           H  
ATOM    922  HB2 HIS A  55      17.714  63.072   9.298  1.00  0.00           H  
ATOM    923  HB3 HIS A  55      18.450  64.085   8.059  1.00  0.00           H  
ATOM    924  HD1 HIS A  55      18.523  60.297   8.296  1.00  0.00           H  
ATOM    925  HD2 HIS A  55      17.087  63.320   5.834  1.00  0.00           H  
ATOM    926  HE1 HIS A  55      17.590  59.131   6.272  1.00  0.00           H  
ATOM    927  N   TYR A  56      21.222  61.035   8.093  1.00  0.00           N  
ATOM    928  CA  TYR A  56      22.101  60.432   7.099  1.00  0.00           C  
ATOM    929  C   TYR A  56      21.371  60.238   5.772  1.00  0.00           C  
ATOM    930  O   TYR A  56      20.521  59.358   5.641  1.00  0.00           O  
ATOM    931  CB  TYR A  56      22.629  59.088   7.603  1.00  0.00           C  
ATOM    932  CG  TYR A  56      23.488  59.202   8.842  1.00  0.00           C  
ATOM    933  CD1 TYR A  56      24.853  59.443   8.745  1.00  0.00           C  
ATOM    934  CD2 TYR A  56      22.935  59.069  10.110  1.00  0.00           C  
ATOM    935  CE1 TYR A  56      25.642  59.547   9.874  1.00  0.00           C  
ATOM    936  CE2 TYR A  56      23.717  59.173  11.244  1.00  0.00           C  
ATOM    937  CZ  TYR A  56      25.070  59.412  11.121  1.00  0.00           C  
ATOM    938  OH  TYR A  56      25.852  59.517  12.248  1.00  0.00           O  
ATOM    939  H   TYR A  56      20.999  60.531   8.903  1.00  0.00           H  
ATOM    940  HA  TYR A  56      22.935  61.100   6.943  1.00  0.00           H  
ATOM    941  HB2 TYR A  56      21.794  58.446   7.838  1.00  0.00           H  
ATOM    942  HB3 TYR A  56      23.223  58.628   6.828  1.00  0.00           H  
ATOM    943  HD1 TYR A  56      25.298  59.550   7.766  1.00  0.00           H  
ATOM    944  HD2 TYR A  56      21.876  58.882  10.203  1.00  0.00           H  
ATOM    945  HE1 TYR A  56      26.702  59.735   9.778  1.00  0.00           H  
ATOM    946  HE2 TYR A  56      23.269  59.067  12.221  1.00  0.00           H  
ATOM    947  HH  TYR A  56      25.738  60.386  12.637  1.00  0.00           H  
ATOM    948  N   VAL A  57      21.711  61.068   4.791  1.00  0.00           N  
ATOM    949  CA  VAL A  57      21.090  60.988   3.474  1.00  0.00           C  
ATOM    950  C   VAL A  57      21.351  59.635   2.824  1.00  0.00           C  
ATOM    951  O   VAL A  57      20.559  59.162   2.011  1.00  0.00           O  
ATOM    952  CB  VAL A  57      21.608  62.100   2.542  1.00  0.00           C  
ATOM    953  CG1 VAL A  57      20.979  61.976   1.163  1.00  0.00           C  
ATOM    954  CG2 VAL A  57      21.330  63.470   3.143  1.00  0.00           C  
ATOM    955  H   VAL A  57      22.396  61.748   4.957  1.00  0.00           H  
ATOM    956  HA  VAL A  57      20.025  61.118   3.598  1.00  0.00           H  
ATOM    957  HB  VAL A  57      22.677  61.987   2.438  1.00  0.00           H  
ATOM    958 HG11 VAL A  57      21.287  61.045   0.710  1.00  0.00           H  
ATOM    959 HG12 VAL A  57      19.903  61.996   1.254  1.00  0.00           H  
ATOM    960 HG13 VAL A  57      21.304  62.801   0.544  1.00  0.00           H  
ATOM    961 HG21 VAL A  57      21.097  64.169   2.354  1.00  0.00           H  
ATOM    962 HG22 VAL A  57      20.493  63.401   3.822  1.00  0.00           H  
ATOM    963 HG23 VAL A  57      22.202  63.813   3.680  1.00  0.00           H  
ATOM    964  N   ASN A  58      22.469  59.013   3.190  1.00  0.00           N  
ATOM    965  CA  ASN A  58      22.835  57.712   2.643  1.00  0.00           C  
ATOM    966  C   ASN A  58      21.992  56.603   3.265  1.00  0.00           C  
ATOM    967  O   ASN A  58      21.812  55.539   2.673  1.00  0.00           O  
ATOM    968  CB  ASN A  58      24.320  57.434   2.882  1.00  0.00           C  
ATOM    969  CG  ASN A  58      25.208  58.545   2.357  1.00  0.00           C  
ATOM    970  OD1 ASN A  58      25.466  58.634   1.156  1.00  0.00           O  
ATOM    971  ND2 ASN A  58      25.681  59.400   3.257  1.00  0.00           N  
ATOM    972  H   ASN A  58      23.061  59.440   3.844  1.00  0.00           H  
ATOM    973  HA  ASN A  58      22.649  57.736   1.579  1.00  0.00           H  
ATOM    974  HB2 ASN A  58      24.494  57.332   3.944  1.00  0.00           H  
ATOM    975  HB3 ASN A  58      24.592  56.515   2.386  1.00  0.00           H  
ATOM    976 HD21 ASN A  58      25.434  59.267   4.196  1.00  0.00           H  
ATOM    977 HD22 ASN A  58      26.257  60.128   2.945  1.00  0.00           H  
ATOM    978  N   TYR A  59      21.476  56.861   4.462  1.00  0.00           N  
ATOM    979  CA  TYR A  59      20.653  55.885   5.167  1.00  0.00           C  
ATOM    980  C   TYR A  59      19.199  56.341   5.228  1.00  0.00           C  
ATOM    981  O   TYR A  59      18.833  57.363   4.649  1.00  0.00           O  
ATOM    982  CB  TYR A  59      21.189  55.661   6.582  1.00  0.00           C  
ATOM    983  CG  TYR A  59      22.559  55.022   6.616  1.00  0.00           C  
ATOM    984  CD1 TYR A  59      22.782  53.778   6.038  1.00  0.00           C  
ATOM    985  CD2 TYR A  59      23.631  55.662   7.226  1.00  0.00           C  
ATOM    986  CE1 TYR A  59      24.032  53.190   6.068  1.00  0.00           C  
ATOM    987  CE2 TYR A  59      24.885  55.082   7.259  1.00  0.00           C  
ATOM    988  CZ  TYR A  59      25.080  53.847   6.680  1.00  0.00           C  
ATOM    989  OH  TYR A  59      26.327  53.265   6.711  1.00  0.00           O  
ATOM    990  H   TYR A  59      21.655  57.727   4.884  1.00  0.00           H  
ATOM    991  HA  TYR A  59      20.704  54.954   4.621  1.00  0.00           H  
ATOM    992  HB2 TYR A  59      21.254  56.611   7.089  1.00  0.00           H  
ATOM    993  HB3 TYR A  59      20.509  55.017   7.119  1.00  0.00           H  
ATOM    994  HD1 TYR A  59      21.959  53.267   5.560  1.00  0.00           H  
ATOM    995  HD2 TYR A  59      23.474  56.631   7.679  1.00  0.00           H  
ATOM    996  HE1 TYR A  59      24.185  52.223   5.613  1.00  0.00           H  
ATOM    997  HE2 TYR A  59      25.706  55.596   7.738  1.00  0.00           H  
ATOM    998  HH  TYR A  59      26.999  53.950   6.688  1.00  0.00           H  
ATOM    999  N   ASN A  60      18.374  55.575   5.934  1.00  0.00           N  
ATOM   1000  CA  ASN A  60      16.960  55.900   6.072  1.00  0.00           C  
ATOM   1001  C   ASN A  60      16.746  56.956   7.152  1.00  0.00           C  
ATOM   1002  O   ASN A  60      17.678  57.327   7.867  1.00  0.00           O  
ATOM   1003  CB  ASN A  60      16.157  54.641   6.410  1.00  0.00           C  
ATOM   1004  CG  ASN A  60      16.053  53.689   5.234  1.00  0.00           C  
ATOM   1005  OD1 ASN A  60      15.174  53.828   4.384  1.00  0.00           O  
ATOM   1006  ND2 ASN A  60      16.952  52.713   5.182  1.00  0.00           N  
ATOM   1007  H   ASN A  60      18.725  54.772   6.373  1.00  0.00           H  
ATOM   1008  HA  ASN A  60      16.616  56.292   5.127  1.00  0.00           H  
ATOM   1009  HB2 ASN A  60      16.638  54.123   7.227  1.00  0.00           H  
ATOM   1010  HB3 ASN A  60      15.159  54.926   6.708  1.00  0.00           H  
ATOM   1011 HD21 ASN A  60      17.624  52.664   5.894  1.00  0.00           H  
ATOM   1012 HD22 ASN A  60      16.910  52.084   4.432  1.00  0.00           H  
ATOM   1013  N   LYS A  61      15.514  57.439   7.265  1.00  0.00           N  
ATOM   1014  CA  LYS A  61      15.176  58.452   8.257  1.00  0.00           C  
ATOM   1015  C   LYS A  61      15.257  57.880   9.668  1.00  0.00           C  
ATOM   1016  O   LYS A  61      15.227  58.620  10.651  1.00  0.00           O  
ATOM   1017  CB  LYS A  61      13.771  59.001   7.998  1.00  0.00           C  
ATOM   1018  CG  LYS A  61      13.449  60.250   8.799  1.00  0.00           C  
ATOM   1019  CD  LYS A  61      12.503  61.169   8.044  1.00  0.00           C  
ATOM   1020  CE  LYS A  61      11.687  62.033   8.992  1.00  0.00           C  
ATOM   1021  NZ  LYS A  61      11.203  63.277   8.334  1.00  0.00           N  
ATOM   1022  H   LYS A  61      14.813  57.104   6.666  1.00  0.00           H  
ATOM   1023  HA  LYS A  61      15.889  59.256   8.166  1.00  0.00           H  
ATOM   1024  HB2 LYS A  61      13.677  59.237   6.949  1.00  0.00           H  
ATOM   1025  HB3 LYS A  61      13.047  58.240   8.253  1.00  0.00           H  
ATOM   1026  HG2 LYS A  61      12.984  59.961   9.729  1.00  0.00           H  
ATOM   1027  HG3 LYS A  61      14.367  60.783   9.002  1.00  0.00           H  
ATOM   1028  HD2 LYS A  61      13.080  61.812   7.395  1.00  0.00           H  
ATOM   1029  HD3 LYS A  61      11.830  60.568   7.448  1.00  0.00           H  
ATOM   1030  HE2 LYS A  61      10.838  61.464   9.336  1.00  0.00           H  
ATOM   1031  HE3 LYS A  61      12.306  62.299   9.836  1.00  0.00           H  
ATOM   1032  HZ1 LYS A  61      10.870  63.066   7.371  1.00  0.00           H  
ATOM   1033  HZ2 LYS A  61      11.973  63.974   8.277  1.00  0.00           H  
ATOM   1034  HZ3 LYS A  61      10.419  63.688   8.878  1.00  0.00           H  
ATOM   1035  N   ARG A  62      15.361  56.558   9.761  1.00  0.00           N  
ATOM   1036  CA  ARG A  62      15.446  55.886  11.053  1.00  0.00           C  
ATOM   1037  C   ARG A  62      16.870  55.943  11.601  1.00  0.00           C  
ATOM   1038  O   ARG A  62      17.148  55.434  12.688  1.00  0.00           O  
ATOM   1039  CB  ARG A  62      14.994  54.431  10.925  1.00  0.00           C  
ATOM   1040  CG  ARG A  62      15.839  53.613   9.962  1.00  0.00           C  
ATOM   1041  CD  ARG A  62      15.017  52.525   9.287  1.00  0.00           C  
ATOM   1042  NE  ARG A  62      14.512  51.545  10.246  1.00  0.00           N  
ATOM   1043  CZ  ARG A  62      13.770  50.499   9.904  1.00  0.00           C  
ATOM   1044  NH1 ARG A  62      13.449  50.295   8.634  1.00  0.00           N  
ATOM   1045  NH2 ARG A  62      13.349  49.651  10.834  1.00  0.00           N  
ATOM   1046  H   ARG A  62      15.379  56.021   8.941  1.00  0.00           H  
ATOM   1047  HA  ARG A  62      14.789  56.401  11.737  1.00  0.00           H  
ATOM   1048  HB2 ARG A  62      15.044  53.965  11.899  1.00  0.00           H  
ATOM   1049  HB3 ARG A  62      13.972  54.413  10.579  1.00  0.00           H  
ATOM   1050  HG2 ARG A  62      16.240  54.268   9.203  1.00  0.00           H  
ATOM   1051  HG3 ARG A  62      16.648  53.153  10.509  1.00  0.00           H  
ATOM   1052  HD2 ARG A  62      14.180  52.985   8.783  1.00  0.00           H  
ATOM   1053  HD3 ARG A  62      15.639  52.020   8.563  1.00  0.00           H  
ATOM   1054  HE  ARG A  62      14.737  51.677  11.189  1.00  0.00           H  
ATOM   1055 HH11 ARG A  62      13.766  50.931   7.931  1.00  0.00           H  
ATOM   1056 HH12 ARG A  62      12.891  49.504   8.379  1.00  0.00           H  
ATOM   1057 HH21 ARG A  62      13.589  49.800  11.792  1.00  0.00           H  
ATOM   1058 HH22 ARG A  62      12.790  48.864  10.576  1.00  0.00           H  
ATOM   1059  N   LEU A  63      17.767  56.562  10.841  1.00  0.00           N  
ATOM   1060  CA  LEU A  63      19.162  56.684  11.250  1.00  0.00           C  
ATOM   1061  C   LEU A  63      19.436  58.061  11.846  1.00  0.00           C  
ATOM   1062  O   LEU A  63      20.376  58.237  12.621  1.00  0.00           O  
ATOM   1063  CB  LEU A  63      20.087  56.439  10.057  1.00  0.00           C  
ATOM   1064  CG  LEU A  63      20.666  55.029   9.935  1.00  0.00           C  
ATOM   1065  CD1 LEU A  63      21.469  54.674  11.178  1.00  0.00           C  
ATOM   1066  CD2 LEU A  63      19.557  54.014   9.707  1.00  0.00           C  
ATOM   1067  H   LEU A  63      17.485  56.946   9.985  1.00  0.00           H  
ATOM   1068  HA  LEU A  63      19.353  55.934  12.004  1.00  0.00           H  
ATOM   1069  HB2 LEU A  63      19.528  56.645   9.158  1.00  0.00           H  
ATOM   1070  HB3 LEU A  63      20.913  57.132  10.132  1.00  0.00           H  
ATOM   1071  HG  LEU A  63      21.334  54.993   9.087  1.00  0.00           H  
ATOM   1072 HD11 LEU A  63      20.889  54.012  11.804  1.00  0.00           H  
ATOM   1073 HD12 LEU A  63      21.703  55.574  11.725  1.00  0.00           H  
ATOM   1074 HD13 LEU A  63      22.385  54.181  10.885  1.00  0.00           H  
ATOM   1075 HD21 LEU A  63      18.812  54.436   9.048  1.00  0.00           H  
ATOM   1076 HD22 LEU A  63      19.100  53.761  10.652  1.00  0.00           H  
ATOM   1077 HD23 LEU A  63      19.971  53.122   9.258  1.00  0.00           H  
ATOM   1078  N   ASP A  64      18.607  59.033  11.482  1.00  0.00           N  
ATOM   1079  CA  ASP A  64      18.758  60.394  11.983  1.00  0.00           C  
ATOM   1080  C   ASP A  64      18.848  60.406  13.505  1.00  0.00           C  
ATOM   1081  O   ASP A  64      18.452  59.447  14.167  1.00  0.00           O  
ATOM   1082  CB  ASP A  64      17.587  61.263  11.522  1.00  0.00           C  
ATOM   1083  CG  ASP A  64      16.264  60.811  12.110  1.00  0.00           C  
ATOM   1084  OD1 ASP A  64      16.238  59.746  12.761  1.00  0.00           O  
ATOM   1085  OD2 ASP A  64      15.256  61.522  11.920  1.00  0.00           O  
ATOM   1086  H   ASP A  64      17.876  58.830  10.861  1.00  0.00           H  
ATOM   1087  HA  ASP A  64      19.674  60.797  11.579  1.00  0.00           H  
ATOM   1088  HB2 ASP A  64      17.764  62.285  11.825  1.00  0.00           H  
ATOM   1089  HB3 ASP A  64      17.516  61.218  10.446  1.00  0.00           H  
ATOM   1090  N   GLU A  65      19.372  61.497  14.055  1.00  0.00           N  
ATOM   1091  CA  GLU A  65      19.514  61.632  15.500  1.00  0.00           C  
ATOM   1092  C   GLU A  65      19.966  63.041  15.873  1.00  0.00           C  
ATOM   1093  O   GLU A  65      20.147  63.895  15.006  1.00  0.00           O  
ATOM   1094  CB  GLU A  65      20.516  60.606  16.033  1.00  0.00           C  
ATOM   1095  CG  GLU A  65      21.873  60.669  15.354  1.00  0.00           C  
ATOM   1096  CD  GLU A  65      22.904  59.780  16.022  1.00  0.00           C  
ATOM   1097  OE1 GLU A  65      22.882  58.556  15.775  1.00  0.00           O  
ATOM   1098  OE2 GLU A  65      23.732  60.308  16.793  1.00  0.00           O  
ATOM   1099  H   GLU A  65      19.668  62.229  13.475  1.00  0.00           H  
ATOM   1100  HA  GLU A  65      18.550  61.445  15.947  1.00  0.00           H  
ATOM   1101  HB2 GLU A  65      20.657  60.773  17.091  1.00  0.00           H  
ATOM   1102  HB3 GLU A  65      20.111  59.615  15.887  1.00  0.00           H  
ATOM   1103  HG2 GLU A  65      21.763  60.356  14.327  1.00  0.00           H  
ATOM   1104  HG3 GLU A  65      22.228  61.689  15.382  1.00  0.00           H  
ATOM   1105  N   TRP A  66      20.144  63.274  17.168  1.00  0.00           N  
ATOM   1106  CA  TRP A  66      20.573  64.579  17.657  1.00  0.00           C  
ATOM   1107  C   TRP A  66      22.058  64.570  18.001  1.00  0.00           C  
ATOM   1108  O   TRP A  66      22.465  64.009  19.018  1.00  0.00           O  
ATOM   1109  CB  TRP A  66      19.755  64.981  18.886  1.00  0.00           C  
ATOM   1110  CG  TRP A  66      18.284  65.072  18.616  1.00  0.00           C  
ATOM   1111  CD1 TRP A  66      17.389  64.040  18.591  1.00  0.00           C  
ATOM   1112  CD2 TRP A  66      17.537  66.260  18.330  1.00  0.00           C  
ATOM   1113  NE1 TRP A  66      16.131  64.515  18.308  1.00  0.00           N  
ATOM   1114  CE2 TRP A  66      16.195  65.873  18.144  1.00  0.00           C  
ATOM   1115  CE3 TRP A  66      17.870  67.611  18.215  1.00  0.00           C  
ATOM   1116  CZ2 TRP A  66      15.190  66.790  17.848  1.00  0.00           C  
ATOM   1117  CZ3 TRP A  66      16.871  68.521  17.922  1.00  0.00           C  
ATOM   1118  CH2 TRP A  66      15.545  68.108  17.742  1.00  0.00           C  
ATOM   1119  H   TRP A  66      19.983  62.552  17.812  1.00  0.00           H  
ATOM   1120  HA  TRP A  66      20.402  65.300  16.871  1.00  0.00           H  
ATOM   1121  HB2 TRP A  66      19.906  64.250  19.667  1.00  0.00           H  
ATOM   1122  HB3 TRP A  66      20.091  65.947  19.233  1.00  0.00           H  
ATOM   1123  HD1 TRP A  66      17.648  63.007  18.769  1.00  0.00           H  
ATOM   1124  HE1 TRP A  66      15.320  63.968  18.236  1.00  0.00           H  
ATOM   1125  HE3 TRP A  66      18.887  67.949  18.351  1.00  0.00           H  
ATOM   1126  HZ2 TRP A  66      14.163  66.488  17.708  1.00  0.00           H  
ATOM   1127  HZ3 TRP A  66      17.110  69.570  17.829  1.00  0.00           H  
ATOM   1128  HH2 TRP A  66      14.798  68.852  17.513  1.00  0.00           H  
ATOM   1129  N   ILE A  67      22.862  65.196  17.148  1.00  0.00           N  
ATOM   1130  CA  ILE A  67      24.303  65.261  17.364  1.00  0.00           C  
ATOM   1131  C   ILE A  67      24.710  66.604  17.959  1.00  0.00           C  
ATOM   1132  O   ILE A  67      23.933  67.560  17.955  1.00  0.00           O  
ATOM   1133  CB  ILE A  67      25.079  65.036  16.052  1.00  0.00           C  
ATOM   1134  CG1 ILE A  67      24.691  66.094  15.017  1.00  0.00           C  
ATOM   1135  CG2 ILE A  67      24.815  63.638  15.513  1.00  0.00           C  
ATOM   1136  CD1 ILE A  67      25.655  66.184  13.856  1.00  0.00           C  
ATOM   1137  H   ILE A  67      22.478  65.625  16.356  1.00  0.00           H  
ATOM   1138  HA  ILE A  67      24.571  64.476  18.056  1.00  0.00           H  
ATOM   1139  HB  ILE A  67      26.134  65.120  16.266  1.00  0.00           H  
ATOM   1140 HG12 ILE A  67      23.716  65.862  14.622  1.00  0.00           H  
ATOM   1141 HG13 ILE A  67      24.659  67.062  15.498  1.00  0.00           H  
ATOM   1142 HG21 ILE A  67      24.877  62.923  16.320  1.00  0.00           H  
ATOM   1143 HG22 ILE A  67      23.828  63.602  15.077  1.00  0.00           H  
ATOM   1144 HG23 ILE A  67      25.550  63.397  14.760  1.00  0.00           H  
ATOM   1145 HD11 ILE A  67      26.657  66.334  14.230  1.00  0.00           H  
ATOM   1146 HD12 ILE A  67      25.619  65.267  13.286  1.00  0.00           H  
ATOM   1147 HD13 ILE A  67      25.380  67.014  13.222  1.00  0.00           H  
ATOM   1148  N   THR A  68      25.936  66.671  18.470  1.00  0.00           N  
ATOM   1149  CA  THR A  68      26.447  67.898  19.068  1.00  0.00           C  
ATOM   1150  C   THR A  68      27.516  68.536  18.187  1.00  0.00           C  
ATOM   1151  O   THR A  68      27.922  67.965  17.174  1.00  0.00           O  
ATOM   1152  CB  THR A  68      27.040  67.636  20.466  1.00  0.00           C  
ATOM   1153  OG1 THR A  68      27.541  66.298  20.542  1.00  0.00           O  
ATOM   1154  CG2 THR A  68      25.991  67.854  21.547  1.00  0.00           C  
ATOM   1155  H   THR A  68      26.508  65.877  18.443  1.00  0.00           H  
ATOM   1156  HA  THR A  68      25.622  68.587  19.173  1.00  0.00           H  
ATOM   1157  HB  THR A  68      27.854  68.328  20.630  1.00  0.00           H  
ATOM   1158  HG1 THR A  68      27.894  66.138  21.422  1.00  0.00           H  
ATOM   1159 HG21 THR A  68      25.163  67.181  21.385  1.00  0.00           H  
ATOM   1160 HG22 THR A  68      25.640  68.874  21.508  1.00  0.00           H  
ATOM   1161 HG23 THR A  68      26.428  67.659  22.515  1.00  0.00           H  
ATOM   1162  N   THR A  69      27.969  69.722  18.579  1.00  0.00           N  
ATOM   1163  CA  THR A  69      28.990  70.437  17.825  1.00  0.00           C  
ATOM   1164  C   THR A  69      30.238  69.581  17.639  1.00  0.00           C  
ATOM   1165  O   THR A  69      30.836  69.565  16.563  1.00  0.00           O  
ATOM   1166  CB  THR A  69      29.385  71.753  18.522  1.00  0.00           C  
ATOM   1167  OG1 THR A  69      30.036  71.472  19.766  1.00  0.00           O  
ATOM   1168  CG2 THR A  69      28.161  72.623  18.769  1.00  0.00           C  
ATOM   1169  H   THR A  69      27.607  70.125  19.395  1.00  0.00           H  
ATOM   1170  HA  THR A  69      28.582  70.677  16.854  1.00  0.00           H  
ATOM   1171  HB  THR A  69      30.069  72.292  17.880  1.00  0.00           H  
ATOM   1172  HG1 THR A  69      29.572  70.763  20.217  1.00  0.00           H  
ATOM   1173 HG21 THR A  69      27.576  72.685  17.864  1.00  0.00           H  
ATOM   1174 HG22 THR A  69      28.478  73.614  19.061  1.00  0.00           H  
ATOM   1175 HG23 THR A  69      27.563  72.188  19.556  1.00  0.00           H  
ATOM   1176  N   ASP A  70      30.623  68.868  18.691  1.00  0.00           N  
ATOM   1177  CA  ASP A  70      31.798  68.007  18.643  1.00  0.00           C  
ATOM   1178  C   ASP A  70      31.577  66.837  17.690  1.00  0.00           C  
ATOM   1179  O   ASP A  70      32.518  66.136  17.323  1.00  0.00           O  
ATOM   1180  CB  ASP A  70      32.133  67.485  20.041  1.00  0.00           C  
ATOM   1181  CG  ASP A  70      32.873  68.508  20.880  1.00  0.00           C  
ATOM   1182  OD1 ASP A  70      32.767  69.714  20.574  1.00  0.00           O  
ATOM   1183  OD2 ASP A  70      33.558  68.103  21.842  1.00  0.00           O  
ATOM   1184  H   ASP A  70      30.104  68.924  19.522  1.00  0.00           H  
ATOM   1185  HA  ASP A  70      32.628  68.597  18.282  1.00  0.00           H  
ATOM   1186  HB2 ASP A  70      31.216  67.226  20.551  1.00  0.00           H  
ATOM   1187  HB3 ASP A  70      32.751  66.604  19.951  1.00  0.00           H  
ATOM   1188  N   ARG A  71      30.324  66.633  17.294  1.00  0.00           N  
ATOM   1189  CA  ARG A  71      29.978  65.547  16.385  1.00  0.00           C  
ATOM   1190  C   ARG A  71      29.830  66.060  14.956  1.00  0.00           C  
ATOM   1191  O   ARG A  71      29.541  65.293  14.037  1.00  0.00           O  
ATOM   1192  CB  ARG A  71      28.680  64.873  16.834  1.00  0.00           C  
ATOM   1193  CG  ARG A  71      28.819  64.079  18.122  1.00  0.00           C  
ATOM   1194  CD  ARG A  71      27.788  62.965  18.204  1.00  0.00           C  
ATOM   1195  NE  ARG A  71      28.018  62.090  19.350  1.00  0.00           N  
ATOM   1196  CZ  ARG A  71      28.910  61.106  19.357  1.00  0.00           C  
ATOM   1197  NH1 ARG A  71      29.653  60.873  18.284  1.00  0.00           N  
ATOM   1198  NH2 ARG A  71      29.061  60.353  20.439  1.00  0.00           N  
ATOM   1199  H   ARG A  71      29.616  67.226  17.621  1.00  0.00           H  
ATOM   1200  HA  ARG A  71      30.778  64.822  16.414  1.00  0.00           H  
ATOM   1201  HB2 ARG A  71      27.927  65.633  16.984  1.00  0.00           H  
ATOM   1202  HB3 ARG A  71      28.351  64.201  16.056  1.00  0.00           H  
ATOM   1203  HG2 ARG A  71      29.806  63.645  18.162  1.00  0.00           H  
ATOM   1204  HG3 ARG A  71      28.683  64.746  18.961  1.00  0.00           H  
ATOM   1205  HD2 ARG A  71      26.806  63.405  18.290  1.00  0.00           H  
ATOM   1206  HD3 ARG A  71      27.840  62.377  17.299  1.00  0.00           H  
ATOM   1207  HE  ARG A  71      27.480  62.244  20.154  1.00  0.00           H  
ATOM   1208 HH11 ARG A  71      29.542  61.439  17.467  1.00  0.00           H  
ATOM   1209 HH12 ARG A  71      30.325  60.131  18.292  1.00  0.00           H  
ATOM   1210 HH21 ARG A  71      28.503  60.526  21.251  1.00  0.00           H  
ATOM   1211 HH22 ARG A  71      29.732  59.612  20.442  1.00  0.00           H  
ATOM   1212  N   ILE A  72      30.030  67.361  14.776  1.00  0.00           N  
ATOM   1213  CA  ILE A  72      29.920  67.976  13.459  1.00  0.00           C  
ATOM   1214  C   ILE A  72      31.295  68.184  12.833  1.00  0.00           C  
ATOM   1215  O   ILE A  72      32.257  68.518  13.520  1.00  0.00           O  
ATOM   1216  CB  ILE A  72      29.190  69.330  13.530  1.00  0.00           C  
ATOM   1217  CG1 ILE A  72      27.785  69.148  14.104  1.00  0.00           C  
ATOM   1218  CG2 ILE A  72      29.126  69.970  12.150  1.00  0.00           C  
ATOM   1219  CD1 ILE A  72      27.194  70.418  14.676  1.00  0.00           C  
ATOM   1220  H   ILE A  72      30.259  67.921  15.547  1.00  0.00           H  
ATOM   1221  HA  ILE A  72      29.345  67.312  12.829  1.00  0.00           H  
ATOM   1222  HB  ILE A  72      29.754  69.984  14.176  1.00  0.00           H  
ATOM   1223 HG12 ILE A  72      27.125  68.799  13.324  1.00  0.00           H  
ATOM   1224 HG13 ILE A  72      27.820  68.413  14.895  1.00  0.00           H  
ATOM   1225 HG21 ILE A  72      28.885  69.216  11.415  1.00  0.00           H  
ATOM   1226 HG22 ILE A  72      28.363  70.733  12.143  1.00  0.00           H  
ATOM   1227 HG23 ILE A  72      30.082  70.412  11.913  1.00  0.00           H  
ATOM   1228 HD11 ILE A  72      26.589  70.904  13.924  1.00  0.00           H  
ATOM   1229 HD12 ILE A  72      26.580  70.178  15.531  1.00  0.00           H  
ATOM   1230 HD13 ILE A  72      27.992  71.080  14.979  1.00  0.00           H  
ATOM   1231  N   ASN A  73      31.377  67.985  11.521  1.00  0.00           N  
ATOM   1232  CA  ASN A  73      32.634  68.152  10.800  1.00  0.00           C  
ATOM   1233  C   ASN A  73      32.684  69.507  10.101  1.00  0.00           C  
ATOM   1234  O   ASN A  73      32.032  69.713   9.075  1.00  0.00           O  
ATOM   1235  CB  ASN A  73      32.811  67.029   9.776  1.00  0.00           C  
ATOM   1236  CG  ASN A  73      32.817  65.656  10.418  1.00  0.00           C  
ATOM   1237  OD1 ASN A  73      31.913  65.310  11.178  1.00  0.00           O  
ATOM   1238  ND2 ASN A  73      33.840  64.866  10.116  1.00  0.00           N  
ATOM   1239  H   ASN A  73      30.574  67.720  11.026  1.00  0.00           H  
ATOM   1240  HA  ASN A  73      33.437  68.101  11.519  1.00  0.00           H  
ATOM   1241  HB2 ASN A  73      32.000  67.069   9.064  1.00  0.00           H  
ATOM   1242  HB3 ASN A  73      33.747  67.168   9.257  1.00  0.00           H  
ATOM   1243 HD21 ASN A  73      34.524  65.208   9.503  1.00  0.00           H  
ATOM   1244 HD22 ASN A  73      33.869  63.972  10.516  1.00  0.00           H  
ATOM   1245  N   LEU A  74      33.462  70.427  10.660  1.00  0.00           N  
ATOM   1246  CA  LEU A  74      33.598  71.762  10.090  1.00  0.00           C  
ATOM   1247  C   LEU A  74      34.813  71.841   9.171  1.00  0.00           C  
ATOM   1248  O   LEU A  74      35.319  72.927   8.887  1.00  0.00           O  
ATOM   1249  CB  LEU A  74      33.719  72.804  11.204  1.00  0.00           C  
ATOM   1250  CG  LEU A  74      32.414  73.205  11.894  1.00  0.00           C  
ATOM   1251  CD1 LEU A  74      32.685  74.188  13.020  1.00  0.00           C  
ATOM   1252  CD2 LEU A  74      31.440  73.799  10.886  1.00  0.00           C  
ATOM   1253  H   LEU A  74      33.956  70.204  11.475  1.00  0.00           H  
ATOM   1254  HA  LEU A  74      32.710  71.969   9.511  1.00  0.00           H  
ATOM   1255  HB2 LEU A  74      34.382  72.407  11.957  1.00  0.00           H  
ATOM   1256  HB3 LEU A  74      34.155  73.696  10.777  1.00  0.00           H  
ATOM   1257  HG  LEU A  74      31.956  72.324  12.323  1.00  0.00           H  
ATOM   1258 HD11 LEU A  74      33.169  73.676  13.838  1.00  0.00           H  
ATOM   1259 HD12 LEU A  74      31.752  74.612  13.362  1.00  0.00           H  
ATOM   1260 HD13 LEU A  74      33.328  74.979  12.661  1.00  0.00           H  
ATOM   1261 HD21 LEU A  74      30.963  74.667  11.317  1.00  0.00           H  
ATOM   1262 HD22 LEU A  74      30.690  73.064  10.634  1.00  0.00           H  
ATOM   1263 HD23 LEU A  74      31.976  74.087   9.993  1.00  0.00           H  
ATOM   1264  N   ASP A  75      35.273  70.684   8.708  1.00  0.00           N  
ATOM   1265  CA  ASP A  75      36.427  70.622   7.818  1.00  0.00           C  
ATOM   1266  C   ASP A  75      35.985  70.461   6.367  1.00  0.00           C  
ATOM   1267  O   ASP A  75      36.729  70.782   5.440  1.00  0.00           O  
ATOM   1268  CB  ASP A  75      37.343  69.465   8.217  1.00  0.00           C  
ATOM   1269  CG  ASP A  75      38.763  69.652   7.719  1.00  0.00           C  
ATOM   1270  OD1 ASP A  75      39.309  70.763   7.889  1.00  0.00           O  
ATOM   1271  OD2 ASP A  75      39.329  68.690   7.161  1.00  0.00           O  
ATOM   1272  H   ASP A  75      34.826  69.852   8.971  1.00  0.00           H  
ATOM   1273  HA  ASP A  75      36.971  71.549   7.914  1.00  0.00           H  
ATOM   1274  HB2 ASP A  75      37.366  69.386   9.294  1.00  0.00           H  
ATOM   1275  HB3 ASP A  75      36.954  68.546   7.802  1.00  0.00           H  
ATOM   1276  N   LYS A  76      34.769  69.959   6.175  1.00  0.00           N  
ATOM   1277  CA  LYS A  76      34.227  69.755   4.839  1.00  0.00           C  
ATOM   1278  C   LYS A  76      33.278  70.887   4.457  1.00  0.00           C  
ATOM   1279  O   LYS A  76      32.546  71.405   5.299  1.00  0.00           O  
ATOM   1280  CB  LYS A  76      33.493  68.414   4.762  1.00  0.00           C  
ATOM   1281  CG  LYS A  76      34.396  67.246   4.404  1.00  0.00           C  
ATOM   1282  CD  LYS A  76      35.182  66.758   5.610  1.00  0.00           C  
ATOM   1283  CE  LYS A  76      35.869  65.432   5.328  1.00  0.00           C  
ATOM   1284  NZ  LYS A  76      37.130  65.284   6.106  1.00  0.00           N  
ATOM   1285  H   LYS A  76      34.223  69.721   6.955  1.00  0.00           H  
ATOM   1286  HA  LYS A  76      35.052  69.744   4.143  1.00  0.00           H  
ATOM   1287  HB2 LYS A  76      33.040  68.210   5.721  1.00  0.00           H  
ATOM   1288  HB3 LYS A  76      32.717  68.483   4.014  1.00  0.00           H  
ATOM   1289  HG2 LYS A  76      33.790  66.435   4.031  1.00  0.00           H  
ATOM   1290  HG3 LYS A  76      35.090  67.562   3.637  1.00  0.00           H  
ATOM   1291  HD2 LYS A  76      35.932  67.494   5.862  1.00  0.00           H  
ATOM   1292  HD3 LYS A  76      34.504  66.633   6.443  1.00  0.00           H  
ATOM   1293  HE2 LYS A  76      35.198  64.629   5.592  1.00  0.00           H  
ATOM   1294  HE3 LYS A  76      36.098  65.377   4.274  1.00  0.00           H  
ATOM   1295  HZ1 LYS A  76      37.437  64.290   6.105  1.00  0.00           H  
ATOM   1296  HZ2 LYS A  76      36.982  65.589   7.089  1.00  0.00           H  
ATOM   1297  HZ3 LYS A  76      37.881  65.868   5.684  1.00  0.00           H  
ATOM   1298  N   GLU A  77      33.296  71.264   3.182  1.00  0.00           N  
ATOM   1299  CA  GLU A  77      32.437  72.335   2.691  1.00  0.00           C  
ATOM   1300  C   GLU A  77      30.984  72.091   3.087  1.00  0.00           C  
ATOM   1301  O   GLU A  77      30.536  70.948   3.175  1.00  0.00           O  
ATOM   1302  CB  GLU A  77      32.550  72.452   1.169  1.00  0.00           C  
ATOM   1303  CG  GLU A  77      33.970  72.672   0.679  1.00  0.00           C  
ATOM   1304  CD  GLU A  77      34.081  72.612  -0.832  1.00  0.00           C  
ATOM   1305  OE1 GLU A  77      34.069  71.493  -1.383  1.00  0.00           O  
ATOM   1306  OE2 GLU A  77      34.182  73.685  -1.463  1.00  0.00           O  
ATOM   1307  H   GLU A  77      33.903  70.813   2.559  1.00  0.00           H  
ATOM   1308  HA  GLU A  77      32.769  73.259   3.138  1.00  0.00           H  
ATOM   1309  HB2 GLU A  77      32.172  71.544   0.721  1.00  0.00           H  
ATOM   1310  HB3 GLU A  77      31.943  73.283   0.838  1.00  0.00           H  
ATOM   1311  HG2 GLU A  77      34.304  73.645   1.011  1.00  0.00           H  
ATOM   1312  HG3 GLU A  77      34.606  71.910   1.103  1.00  0.00           H  
ATOM   1313  N   VAL A  78      30.252  73.175   3.326  1.00  0.00           N  
ATOM   1314  CA  VAL A  78      28.849  73.080   3.713  1.00  0.00           C  
ATOM   1315  C   VAL A  78      27.932  73.402   2.538  1.00  0.00           C  
ATOM   1316  O   VAL A  78      28.239  74.266   1.717  1.00  0.00           O  
ATOM   1317  CB  VAL A  78      28.523  74.031   4.881  1.00  0.00           C  
ATOM   1318  CG1 VAL A  78      27.043  73.966   5.224  1.00  0.00           C  
ATOM   1319  CG2 VAL A  78      29.377  73.694   6.094  1.00  0.00           C  
ATOM   1320  H   VAL A  78      30.664  74.059   3.240  1.00  0.00           H  
ATOM   1321  HA  VAL A  78      28.660  72.067   4.038  1.00  0.00           H  
ATOM   1322  HB  VAL A  78      28.755  75.039   4.572  1.00  0.00           H  
ATOM   1323 HG11 VAL A  78      26.759  72.938   5.397  1.00  0.00           H  
ATOM   1324 HG12 VAL A  78      26.854  74.548   6.115  1.00  0.00           H  
ATOM   1325 HG13 VAL A  78      26.466  74.366   4.404  1.00  0.00           H  
ATOM   1326 HG21 VAL A  78      29.408  72.623   6.228  1.00  0.00           H  
ATOM   1327 HG22 VAL A  78      30.378  74.069   5.945  1.00  0.00           H  
ATOM   1328 HG23 VAL A  78      28.948  74.154   6.974  1.00  0.00           H  
ATOM   1329  N   LEU A  79      26.805  72.703   2.466  1.00  0.00           N  
ATOM   1330  CA  LEU A  79      25.841  72.914   1.391  1.00  0.00           C  
ATOM   1331  C   LEU A  79      24.642  73.715   1.887  1.00  0.00           C  
ATOM   1332  O   LEU A  79      24.021  73.366   2.891  1.00  0.00           O  
ATOM   1333  CB  LEU A  79      25.374  71.570   0.827  1.00  0.00           C  
ATOM   1334  CG  LEU A  79      25.987  71.156  -0.512  1.00  0.00           C  
ATOM   1335  CD1 LEU A  79      25.478  72.051  -1.631  1.00  0.00           C  
ATOM   1336  CD2 LEU A  79      27.506  71.201  -0.439  1.00  0.00           C  
ATOM   1337  H   LEU A  79      26.617  72.027   3.150  1.00  0.00           H  
ATOM   1338  HA  LEU A  79      26.334  73.472   0.610  1.00  0.00           H  
ATOM   1339  HB2 LEU A  79      25.614  70.807   1.551  1.00  0.00           H  
ATOM   1340  HB3 LEU A  79      24.303  71.621   0.701  1.00  0.00           H  
ATOM   1341  HG  LEU A  79      25.691  70.140  -0.735  1.00  0.00           H  
ATOM   1342 HD11 LEU A  79      24.399  72.079  -1.606  1.00  0.00           H  
ATOM   1343 HD12 LEU A  79      25.804  71.657  -2.583  1.00  0.00           H  
ATOM   1344 HD13 LEU A  79      25.869  73.048  -1.500  1.00  0.00           H  
ATOM   1345 HD21 LEU A  79      27.860  72.127  -0.869  1.00  0.00           H  
ATOM   1346 HD22 LEU A  79      27.917  70.368  -0.991  1.00  0.00           H  
ATOM   1347 HD23 LEU A  79      27.819  71.139   0.593  1.00  0.00           H  
ATOM   1348  N   TYR A  80      24.320  74.788   1.174  1.00  0.00           N  
ATOM   1349  CA  TYR A  80      23.195  75.640   1.541  1.00  0.00           C  
ATOM   1350  C   TYR A  80      22.178  75.718   0.406  1.00  0.00           C  
ATOM   1351  O   TYR A  80      22.496  75.498  -0.763  1.00  0.00           O  
ATOM   1352  CB  TYR A  80      23.684  77.043   1.900  1.00  0.00           C  
ATOM   1353  CG  TYR A  80      24.379  77.119   3.240  1.00  0.00           C  
ATOM   1354  CD1 TYR A  80      23.658  77.345   4.406  1.00  0.00           C  
ATOM   1355  CD2 TYR A  80      25.756  76.960   3.342  1.00  0.00           C  
ATOM   1356  CE1 TYR A  80      24.289  77.416   5.633  1.00  0.00           C  
ATOM   1357  CE2 TYR A  80      26.395  77.027   4.565  1.00  0.00           C  
ATOM   1358  CZ  TYR A  80      25.657  77.255   5.708  1.00  0.00           C  
ATOM   1359  OH  TYR A  80      26.289  77.323   6.928  1.00  0.00           O  
ATOM   1360  H   TYR A  80      24.852  75.016   0.384  1.00  0.00           H  
ATOM   1361  HA  TYR A  80      22.717  75.204   2.407  1.00  0.00           H  
ATOM   1362  HB2 TYR A  80      24.382  77.377   1.147  1.00  0.00           H  
ATOM   1363  HB3 TYR A  80      22.840  77.717   1.924  1.00  0.00           H  
ATOM   1364  HD1 TYR A  80      22.587  77.471   4.345  1.00  0.00           H  
ATOM   1365  HD2 TYR A  80      26.331  76.782   2.444  1.00  0.00           H  
ATOM   1366  HE1 TYR A  80      23.712  77.593   6.529  1.00  0.00           H  
ATOM   1367  HE2 TYR A  80      27.466  76.903   4.624  1.00  0.00           H  
ATOM   1368  HH  TYR A  80      26.127  76.512   7.417  1.00  0.00           H  
ATOM   1369  N   PRO A  81      20.924  76.042   0.756  1.00  0.00           N  
ATOM   1370  CA  PRO A  81      19.835  76.158  -0.217  1.00  0.00           C  
ATOM   1371  C   PRO A  81      19.998  77.373  -1.127  1.00  0.00           C  
ATOM   1372  O   PRO A  81      20.731  78.308  -0.805  1.00  0.00           O  
ATOM   1373  CB  PRO A  81      18.590  76.311   0.660  1.00  0.00           C  
ATOM   1374  CG  PRO A  81      19.095  76.886   1.939  1.00  0.00           C  
ATOM   1375  CD  PRO A  81      20.474  76.318   2.131  1.00  0.00           C  
ATOM   1376  HA  PRO A  81      19.745  75.268  -0.821  1.00  0.00           H  
ATOM   1377  HB2 PRO A  81      17.886  76.975   0.178  1.00  0.00           H  
ATOM   1378  HB3 PRO A  81      18.134  75.345   0.815  1.00  0.00           H  
ATOM   1379  HG2 PRO A  81      19.139  77.962   1.865  1.00  0.00           H  
ATOM   1380  HG3 PRO A  81      18.451  76.590   2.753  1.00  0.00           H  
ATOM   1381  HD2 PRO A  81      21.116  77.043   2.609  1.00  0.00           H  
ATOM   1382  HD3 PRO A  81      20.431  75.409   2.712  1.00  0.00           H  
ATOM   1383  N   LYS A  82      19.309  77.352  -2.262  1.00  0.00           N  
ATOM   1384  CA  LYS A  82      19.375  78.450  -3.218  1.00  0.00           C  
ATOM   1385  C   LYS A  82      18.115  79.307  -3.151  1.00  0.00           C  
ATOM   1386  O   LYS A  82      17.018  78.798  -2.914  1.00  0.00           O  
ATOM   1387  CB  LYS A  82      19.561  77.909  -4.637  1.00  0.00           C  
ATOM   1388  CG  LYS A  82      19.563  78.989  -5.705  1.00  0.00           C  
ATOM   1389  CD  LYS A  82      20.620  78.725  -6.763  1.00  0.00           C  
ATOM   1390  CE  LYS A  82      20.872  79.958  -7.619  1.00  0.00           C  
ATOM   1391  NZ  LYS A  82      21.423  81.086  -6.819  1.00  0.00           N  
ATOM   1392  H   LYS A  82      18.741  76.578  -2.463  1.00  0.00           H  
ATOM   1393  HA  LYS A  82      20.227  79.063  -2.961  1.00  0.00           H  
ATOM   1394  HB2 LYS A  82      20.502  77.381  -4.688  1.00  0.00           H  
ATOM   1395  HB3 LYS A  82      18.759  77.219  -4.855  1.00  0.00           H  
ATOM   1396  HG2 LYS A  82      18.593  79.015  -6.180  1.00  0.00           H  
ATOM   1397  HG3 LYS A  82      19.763  79.943  -5.238  1.00  0.00           H  
ATOM   1398  HD2 LYS A  82      21.543  78.445  -6.277  1.00  0.00           H  
ATOM   1399  HD3 LYS A  82      20.288  77.918  -7.399  1.00  0.00           H  
ATOM   1400  HE2 LYS A  82      21.575  79.702  -8.397  1.00  0.00           H  
ATOM   1401  HE3 LYS A  82      19.938  80.266  -8.065  1.00  0.00           H  
ATOM   1402  HZ1 LYS A  82      20.648  81.668  -6.442  1.00  0.00           H  
ATOM   1403  HZ2 LYS A  82      22.031  81.682  -7.416  1.00  0.00           H  
ATOM   1404  HZ3 LYS A  82      21.986  80.720  -6.026  1.00  0.00           H  
ATOM   1405  N   LEU A  83      18.277  80.608  -3.361  1.00  0.00           N  
ATOM   1406  CA  LEU A  83      17.152  81.536  -3.326  1.00  0.00           C  
ATOM   1407  C   LEU A  83      17.102  82.380  -4.595  1.00  0.00           C  
ATOM   1408  O   LEU A  83      18.120  82.899  -5.049  1.00  0.00           O  
ATOM   1409  CB  LEU A  83      17.254  82.445  -2.099  1.00  0.00           C  
ATOM   1410  CG  LEU A  83      17.272  81.742  -0.742  1.00  0.00           C  
ATOM   1411  CD1 LEU A  83      17.737  82.696   0.347  1.00  0.00           C  
ATOM   1412  CD2 LEU A  83      15.895  81.183  -0.412  1.00  0.00           C  
ATOM   1413  H   LEU A  83      19.176  80.955  -3.545  1.00  0.00           H  
ATOM   1414  HA  LEU A  83      16.245  80.954  -3.259  1.00  0.00           H  
ATOM   1415  HB2 LEU A  83      18.164  83.018  -2.187  1.00  0.00           H  
ATOM   1416  HB3 LEU A  83      16.405  83.115  -2.115  1.00  0.00           H  
ATOM   1417  HG  LEU A  83      17.968  80.916  -0.781  1.00  0.00           H  
ATOM   1418 HD11 LEU A  83      17.760  83.703  -0.042  1.00  0.00           H  
ATOM   1419 HD12 LEU A  83      18.726  82.413   0.676  1.00  0.00           H  
ATOM   1420 HD13 LEU A  83      17.053  82.647   1.183  1.00  0.00           H  
ATOM   1421 HD21 LEU A  83      15.314  81.097  -1.319  1.00  0.00           H  
ATOM   1422 HD22 LEU A  83      15.393  81.847   0.276  1.00  0.00           H  
ATOM   1423 HD23 LEU A  83      16.001  80.209   0.041  1.00  0.00           H  
ATOM   1424  N   LYS A  84      15.908  82.512  -5.164  1.00  0.00           N  
ATOM   1425  CA  LYS A  84      15.722  83.296  -6.379  1.00  0.00           C  
ATOM   1426  C   LYS A  84      14.392  84.043  -6.347  1.00  0.00           C  
ATOM   1427  O   LYS A  84      13.374  83.498  -5.920  1.00  0.00           O  
ATOM   1428  CB  LYS A  84      15.780  82.388  -7.609  1.00  0.00           C  
ATOM   1429  CG  LYS A  84      15.683  83.140  -8.926  1.00  0.00           C  
ATOM   1430  CD  LYS A  84      17.051  83.592  -9.410  1.00  0.00           C  
ATOM   1431  CE  LYS A  84      17.830  82.443 -10.031  1.00  0.00           C  
ATOM   1432  NZ  LYS A  84      18.988  82.927 -10.832  1.00  0.00           N  
ATOM   1433  H   LYS A  84      15.132  82.073  -4.754  1.00  0.00           H  
ATOM   1434  HA  LYS A  84      16.524  84.016  -6.436  1.00  0.00           H  
ATOM   1435  HB2 LYS A  84      16.712  81.844  -7.597  1.00  0.00           H  
ATOM   1436  HB3 LYS A  84      14.961  81.684  -7.562  1.00  0.00           H  
ATOM   1437  HG2 LYS A  84      15.246  82.491  -9.670  1.00  0.00           H  
ATOM   1438  HG3 LYS A  84      15.055  84.008  -8.789  1.00  0.00           H  
ATOM   1439  HD2 LYS A  84      16.922  84.366 -10.152  1.00  0.00           H  
ATOM   1440  HD3 LYS A  84      17.609  83.983  -8.572  1.00  0.00           H  
ATOM   1441  HE2 LYS A  84      18.193  81.804  -9.241  1.00  0.00           H  
ATOM   1442  HE3 LYS A  84      17.169  81.881 -10.674  1.00  0.00           H  
ATOM   1443  HZ1 LYS A  84      19.813  83.075 -10.216  1.00  0.00           H  
ATOM   1444  HZ2 LYS A  84      18.750  83.827 -11.297  1.00  0.00           H  
ATOM   1445  HZ3 LYS A  84      19.235  82.228 -11.561  1.00  0.00           H  
ATOM   1446  N   ALA A  85      14.408  85.290  -6.804  1.00  0.00           N  
ATOM   1447  CA  ALA A  85      13.203  86.109  -6.831  1.00  0.00           C  
ATOM   1448  C   ALA A  85      12.169  85.535  -7.794  1.00  0.00           C  
ATOM   1449  O   ALA A  85      12.376  85.521  -9.008  1.00  0.00           O  
ATOM   1450  CB  ALA A  85      13.546  87.541  -7.216  1.00  0.00           C  
ATOM   1451  H   ALA A  85      15.250  85.668  -7.133  1.00  0.00           H  
ATOM   1452  HA  ALA A  85      12.784  86.121  -5.835  1.00  0.00           H  
ATOM   1453  HB1 ALA A  85      14.400  87.540  -7.878  1.00  0.00           H  
ATOM   1454  HB2 ALA A  85      12.702  87.991  -7.717  1.00  0.00           H  
ATOM   1455  HB3 ALA A  85      13.780  88.106  -6.326  1.00  0.00           H  
ATOM   1456  N   THR A  86      11.056  85.058  -7.246  1.00  0.00           N  
ATOM   1457  CA  THR A  86       9.991  84.480  -8.056  1.00  0.00           C  
ATOM   1458  C   THR A  86       8.624  84.986  -7.608  1.00  0.00           C  
ATOM   1459  O   THR A  86       8.184  84.712  -6.492  1.00  0.00           O  
ATOM   1460  CB  THR A  86      10.004  82.942  -7.985  1.00  0.00           C  
ATOM   1461  OG1 THR A  86      11.348  82.470  -7.844  1.00  0.00           O  
ATOM   1462  CG2 THR A  86       9.377  82.337  -9.232  1.00  0.00           C  
ATOM   1463  H   THR A  86      10.950  85.097  -6.272  1.00  0.00           H  
ATOM   1464  HA  THR A  86      10.156  84.775  -9.081  1.00  0.00           H  
ATOM   1465  HB  THR A  86       9.429  82.631  -7.124  1.00  0.00           H  
ATOM   1466  HG1 THR A  86      11.408  81.569  -8.175  1.00  0.00           H  
ATOM   1467 HG21 THR A  86       8.575  82.973  -9.575  1.00  0.00           H  
ATOM   1468 HG22 THR A  86       8.986  81.358  -9.000  1.00  0.00           H  
ATOM   1469 HG23 THR A  86      10.124  82.253 -10.006  1.00  0.00           H  
ATOM   1470  N   ASP A  87       7.957  85.727  -8.487  1.00  0.00           N  
ATOM   1471  CA  ASP A  87       6.638  86.270  -8.185  1.00  0.00           C  
ATOM   1472  C   ASP A  87       5.560  85.570  -9.006  1.00  0.00           C  
ATOM   1473  O   ASP A  87       4.868  86.200  -9.804  1.00  0.00           O  
ATOM   1474  CB  ASP A  87       6.607  87.775  -8.457  1.00  0.00           C  
ATOM   1475  CG  ASP A  87       5.329  88.426  -7.967  1.00  0.00           C  
ATOM   1476  OD1 ASP A  87       5.068  88.377  -6.747  1.00  0.00           O  
ATOM   1477  OD2 ASP A  87       4.591  88.985  -8.805  1.00  0.00           O  
ATOM   1478  H   ASP A  87       8.361  85.911  -9.362  1.00  0.00           H  
ATOM   1479  HA  ASP A  87       6.442  86.099  -7.137  1.00  0.00           H  
ATOM   1480  HB2 ASP A  87       7.442  88.241  -7.955  1.00  0.00           H  
ATOM   1481  HB3 ASP A  87       6.692  87.942  -9.520  1.00  0.00           H  
ATOM   1482  N   GLU A  88       5.424  84.263  -8.804  1.00  0.00           N  
ATOM   1483  CA  GLU A  88       4.431  83.478  -9.528  1.00  0.00           C  
ATOM   1484  C   GLU A  88       3.277  83.081  -8.611  1.00  0.00           C  
ATOM   1485  O   GLU A  88       3.283  83.389  -7.419  1.00  0.00           O  
ATOM   1486  CB  GLU A  88       5.076  82.226 -10.126  1.00  0.00           C  
ATOM   1487  CG  GLU A  88       5.890  82.500 -11.378  1.00  0.00           C  
ATOM   1488  CD  GLU A  88       6.190  81.241 -12.168  1.00  0.00           C  
ATOM   1489  OE1 GLU A  88       5.275  80.402 -12.313  1.00  0.00           O  
ATOM   1490  OE2 GLU A  88       7.337  81.093 -12.639  1.00  0.00           O  
ATOM   1491  H   GLU A  88       6.005  83.817  -8.153  1.00  0.00           H  
ATOM   1492  HA  GLU A  88       4.044  84.089 -10.329  1.00  0.00           H  
ATOM   1493  HB2 GLU A  88       5.727  81.783  -9.386  1.00  0.00           H  
ATOM   1494  HB3 GLU A  88       4.298  81.519 -10.376  1.00  0.00           H  
ATOM   1495  HG2 GLU A  88       5.339  83.179 -12.010  1.00  0.00           H  
ATOM   1496  HG3 GLU A  88       6.826  82.957 -11.090  1.00  0.00           H  
ATOM   1497  N   ASP A  89       2.290  82.395  -9.176  1.00  0.00           N  
ATOM   1498  CA  ASP A  89       1.129  81.955  -8.410  1.00  0.00           C  
ATOM   1499  C   ASP A  89       0.793  80.499  -8.721  1.00  0.00           C  
ATOM   1500  O   ASP A  89       0.347  80.177  -9.824  1.00  0.00           O  
ATOM   1501  CB  ASP A  89      -0.077  82.846  -8.714  1.00  0.00           C  
ATOM   1502  CG  ASP A  89      -1.383  82.230  -8.252  1.00  0.00           C  
ATOM   1503  OD1 ASP A  89      -1.520  81.969  -7.039  1.00  0.00           O  
ATOM   1504  OD2 ASP A  89      -2.268  82.009  -9.104  1.00  0.00           O  
ATOM   1505  H   ASP A  89       2.343  82.180 -10.130  1.00  0.00           H  
ATOM   1506  HA  ASP A  89       1.372  82.039  -7.362  1.00  0.00           H  
ATOM   1507  HB2 ASP A  89       0.050  83.794  -8.212  1.00  0.00           H  
ATOM   1508  HB3 ASP A  89      -0.134  83.011  -9.780  1.00  0.00           H  
TER    1509      ASP A  89                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
