
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   77 (  603),  selected   77 , name 1vbv_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 1vbv_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     3_A      X      63           -
LGA    -       -      P      64           -
LGA    S     4_A      P      65           #
LGA    K     5_A      A      66          1.299
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    F     6_A      L      69          1.325
LGA    G     7_A      Y      70          1.772
LGA    I     8_A      V      71          0.784
LGA    G     9_A      G      72          1.152
LGA    Q    10_A      S      73          0.987
LGA    Q    11_A      R      74          1.047
LGA    V    12_A      V      75          0.775
LGA    R    13_A      V      76          0.534
LGA    H    14_A      A      77          1.479
LGA    S    15_A      K      78           #
LGA    L    16_A      Y      79           -
LGA    -       -      K      80           -
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    -       -      Q      84           -
LGA    -       -      V      85           -
LGA    L    17_A      W      86          3.426
LGA    G    18_A      L      87          2.680
LGA    Y    19_A      Y      88          0.631
LGA    L    20_A      A      89          0.427
LGA    G    21_A      G      90          0.311
LGA    V    22_A      I      91          0.654
LGA    V    23_A      V      92          0.945
LGA    V    24_A      A      93          1.010
LGA    D    25_A      E      94          1.517
LGA    I    26_A      T      95          2.511
LGA    D    27_A      P      96          3.241
LGA    P    28_A      N      97          2.073
LGA    V    29_A      V      98          4.968
LGA    A    48_A      K      99           -
LGA    A    49_A      N     100           -
LGA    P    50_A      K     101           #
LGA    -       -      L     102           -
LGA    W    51_A      R     103          0.713
LGA    Y    52_A      F     104          0.811
LGA    H    53_A      L     105          0.839
LGA    V    54_A      I     106          0.830
LGA    V    55_A      F     107          0.760
LGA    M    56_A      F     108          0.968
LGA    E    57_A      D     109          3.066
LGA    D    58_A      -       -           -
LGA    D    59_A      -       -           -
LGA    N    60_A      -       -           -
LGA    G    61_A      -       -           -
LGA    L    62_A      D     110          2.709
LGA    P    63_A      G     111          1.327
LGA    V    64_A      Y     112          0.128
LGA    H    65_A      A     113          0.578
LGA    T    66_A      S     114          0.789
LGA    Y    67_A      Y     115          0.744
LGA    L    68_A      V     116          0.264
LGA    A    69_A      T     117          0.598
LGA    E    70_A      Q     118          1.068
LGA    A    71_A      S     119          1.028
LGA    Q    72_A      E     120          0.585
LGA    L    73_A      L     121          0.540
LGA    S    74_A      Y     122          1.213
LGA    S    75_A      P     123          1.157
LGA    E    76_A      I     124          1.418
LGA    L    77_A      C     125          1.850
LGA    Q    78_A      R     126          3.122
LGA    D    79_A      P     127          2.603
LGA    E    80_A      L     128          4.514
LGA    H    81_A      K     129           -
LGA    P    82_A      K     130           -
LGA    E    83_A      T     131           -
LGA    Q    84_A      -       -           -
LGA    P    85_A      -       -           -
LGA    S    86_A      W     132           #
LGA    M    87_A      E     133           #
LGA    D    88_A      D     134          3.820
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    E    89_A      I     138           #
LGA    L    90_A      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    A    91_A      I     144          5.184
LGA    Q    92_A      E     145          3.959
LGA    T    93_A      E     146          3.465
LGA    I    94_A      Y     147          3.302
LGA    R    95_A      V     148          3.327
LGA    K    96_A      T     149          1.171
LGA    Q    97_A      A     150          1.156
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   77   93    5.0     57    2.09    15.79     52.342     2.598

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.293898 * X  +   0.595784 * Y  +   0.747439 * Z  +  -7.633485
  Y_new =   0.771060 * X  +   0.314354 * Y  +  -0.553758 * Z  +  21.054449
  Z_new =  -0.564881 * X  +   0.739069 * Y  +  -0.366997 * Z  +  19.495964 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.031694   -1.109899  [ DEG:   116.4075    -63.5925 ]
  Theta =   0.600289    2.541303  [ DEG:    34.3940    145.6060 ]
  Phi   =   1.206635   -1.934958  [ DEG:    69.1351   -110.8649 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vbv_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vbv_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   77   93   5.0   57   2.09   15.79  52.342
REMARK  ---------------------------------------------------------- 
MOLECULE 1vbv_A
HEADER    UNKNOWN FUNCTION                        02-MAR-04   1VBV              
TITLE     CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN FROM ESHERICHIA             
TITLE    2 COLI                                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN B0966;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PROTEIN DEGRADATION FACTOR;                                 
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12, MG1655, W3110;                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET22B(+)                                 
KEYWDS    PROTEIN DEGRADATION, STRUCTURAL GENOMICS                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SHIOI,K.MAENAKA,D.KOHDA,T.KATAYAMA,T.UEDA                           
REVDAT   1   04-OCT-05 1VBV    0                                                
JRNL        AUTH   S.SHIOI,K.MAENAKA,D.KOHDA,T.KATAYAMA,Y.ABE,T.UEDA            
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN FROM               
JRNL        TITL 2 ESHERICHIA COLI                                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1VBV A    1   105  UNP    P0AB20   YCCV_ECOLI       1    105             
SEQRES   1 A  105  MET ILE ALA SER LYS PHE GLY ILE GLY GLN GLN VAL ARG          
SEQRES   2 A  105  HIS SER LEU LEU GLY TYR LEU GLY VAL VAL VAL ASP ILE          
SEQRES   3 A  105  ASP PRO VAL TYR SER LEU SER GLU PRO SER PRO ASP GLU          
SEQRES   4 A  105  LEU ALA VAL ASN ASP GLU LEU ARG ALA ALA PRO TRP TYR          
SEQRES   5 A  105  HIS VAL VAL MET GLU ASP ASP ASN GLY LEU PRO VAL HIS          
SEQRES   6 A  105  THR TYR LEU ALA GLU ALA GLN LEU SER SER GLU LEU GLN          
SEQRES   7 A  105  ASP GLU HIS PRO GLU GLN PRO SER MET ASP GLU LEU ALA          
SEQRES   8 A  105  GLN THR ILE ARG LYS GLN LEU GLN ALA PRO ARG LEU ARG          
SEQRES   9 A  105  ASN                                                          
FORMUL   2  HOH   *4(H2 O)                                                      
CRYST1   76.822   76.822   85.888  90.00  90.00 120.00 H 3 2        18          
ATOM      1  N   ALA A   3      23.248  81.740  18.360  1.00 69.31           N  
ATOM      2  CA  ALA A   3      22.699  80.817  19.404  1.00 69.89           C  
ATOM      3  C   ALA A   3      22.842  79.354  18.971  1.00 68.59           C  
ATOM      4  O   ALA A   3      22.767  78.434  19.794  1.00 67.61           O  
ATOM      5  CB  ALA A   3      21.225  81.141  19.665  1.00 70.75           C  
ATOM      6  N   SER A   4      23.047  79.162  17.670  1.00 65.93           N  
ATOM      7  CA  SER A   4      23.201  77.845  17.074  1.00 62.98           C  
ATOM      8  C   SER A   4      24.137  77.981  15.880  1.00 60.81           C  
ATOM      9  O   SER A   4      23.876  78.758  14.964  1.00 61.27           O  
ATOM     10  CB  SER A   4      21.838  77.323  16.619  1.00 64.64           C  
ATOM     11  OG  SER A   4      21.974  76.282  15.666  1.00 68.40           O  
ATOM     12  N   LYS A   5      25.228  77.228  15.880  1.00 57.24           N  
ATOM     13  CA  LYS A   5      26.171  77.317  14.783  1.00 54.72           C  
ATOM     14  C   LYS A   5      25.665  76.761  13.453  1.00 53.42           C  
ATOM     15  O   LYS A   5      26.156  77.178  12.399  1.00 51.83           O  
ATOM     16  CB  LYS A   5      27.477  76.600  15.138  1.00 56.08           C  
ATOM     17  CG  LYS A   5      28.086  76.995  16.478  1.00 59.24           C  
ATOM     18  CD  LYS A   5      28.183  78.501  16.647  1.00 58.85           C  
ATOM     19  CE  LYS A   5      28.802  78.879  17.983  1.00 58.13           C  
ATOM     20  NZ  LYS A   5      28.722  80.348  18.202  1.00 56.36           N  
ATOM     21  N   PHE A   6      24.686  75.847  13.481  1.00 51.08           N  
ATOM     22  CA  PHE A   6      24.219  75.234  12.238  1.00 49.20           C  
ATOM     23  C   PHE A   6      22.824  75.464  11.662  1.00 49.47           C  
ATOM     24  O   PHE A   6      22.694  75.658  10.455  1.00 52.45           O  
ATOM     25  CB  PHE A   6      24.515  73.742  12.291  1.00 47.86           C  
ATOM     26  CG  PHE A   6      25.978  73.441  12.444  1.00 48.49           C  
ATOM     27  CD1 PHE A   6      26.884  73.831  11.456  1.00 46.16           C  
ATOM     28  CD2 PHE A   6      26.466  72.846  13.605  1.00 48.19           C  
ATOM     29  CE1 PHE A   6      28.249  73.643  11.628  1.00 44.87           C  
ATOM     30  CE2 PHE A   6      27.836  72.654  13.782  1.00 47.76           C  
ATOM     31  CZ  PHE A   6      28.729  73.056  12.789  1.00 45.40           C  
ATOM     32  N   GLY A   7      21.766  75.445  12.453  1.00 46.60           N  
ATOM     33  CA  GLY A   7      20.473  75.698  11.825  1.00 45.99           C  
ATOM     34  C   GLY A   7      19.917  74.638  10.874  1.00 44.53           C  
ATOM     35  O   GLY A   7      20.619  74.065  10.043  1.00 44.04           O  
ATOM     36  N   ILE A   8      18.616  74.410  11.005  1.00 42.96           N  
ATOM     37  CA  ILE A   8      17.867  73.416  10.255  1.00 41.98           C  
ATOM     38  C   ILE A   8      17.922  73.548   8.740  1.00 41.92           C  
ATOM     39  O   ILE A   8      17.931  74.643   8.208  1.00 44.10           O  
ATOM     40  CB  ILE A   8      16.399  73.423  10.756  1.00 42.76           C  
ATOM     41  CG1 ILE A   8      16.390  73.052  12.244  1.00 42.77           C  
ATOM     42  CG2 ILE A   8      15.542  72.461   9.959  1.00 42.89           C  
ATOM     43  CD1 ILE A   8      15.045  73.094  12.885  1.00 43.39           C  
ATOM     44  N   GLY A   9      17.972  72.412   8.051  1.00 41.76           N  
ATOM     45  CA  GLY A   9      18.032  72.422   6.602  1.00 39.59           C  
ATOM     46  C   GLY A   9      19.444  72.508   6.045  1.00 39.82           C  
ATOM     47  O   GLY A   9      19.651  72.331   4.842  1.00 41.58           O  
ATOM     48  N   GLN A  10      20.420  72.779   6.906  1.00 37.26           N  
ATOM     49  CA  GLN A  10      21.804  72.895   6.459  1.00 37.06           C  
ATOM     50  C   GLN A  10      22.494  71.544   6.232  1.00 36.43           C  
ATOM     51  O   GLN A  10      22.242  70.572   6.947  1.00 35.85           O  
ATOM     52  CB  GLN A  10      22.624  73.719   7.474  1.00 35.99           C  
ATOM     53  CG  GLN A  10      24.081  73.920   7.059  1.00 37.11           C  
ATOM     54  CD  GLN A  10      24.878  74.791   8.015  1.00 37.45           C  
ATOM     55  OE1 GLN A  10      24.344  75.312   8.979  1.00 39.10           O  
ATOM     56  NE2 GLN A  10      26.170  74.953   7.741  1.00 36.09           N  
ATOM     57  N   GLN A  11      23.363  71.477   5.231  1.00 35.66           N  
ATOM     58  CA  GLN A  11      24.087  70.236   4.999  1.00 37.18           C  
ATOM     59  C   GLN A  11      25.342  70.291   5.856  1.00 37.39           C  
ATOM     60  O   GLN A  11      26.034  71.309   5.901  1.00 38.92           O  
ATOM     61  CB  GLN A  11      24.441  70.064   3.518  1.00 34.48           C  
ATOM     62  CG  GLN A  11      23.214  69.886   2.634  1.00 35.19           C  
ATOM     63  CD  GLN A  11      23.542  69.605   1.182  1.00 35.89           C  
ATOM     64  OE1 GLN A  11      24.382  70.273   0.577  1.00 36.84           O  
ATOM     65  NE2 GLN A  11      22.860  68.620   0.606  1.00 38.23           N  
ATOM     66  N   VAL A  12      25.619  69.212   6.569  1.00 37.36           N  
ATOM     67  CA  VAL A  12      26.802  69.181   7.416  1.00 38.37           C  
ATOM     68  C   VAL A  12      27.528  67.865   7.244  1.00 40.09           C  
ATOM     69  O   VAL A  12      27.025  66.935   6.608  1.00 39.87           O  
ATOM     70  CB  VAL A  12      26.450  69.344   8.935  1.00 37.85           C  
ATOM     71  CG1 VAL A  12      25.938  70.750   9.214  1.00 37.85           C  
ATOM     72  CG2 VAL A  12      25.413  68.302   9.355  1.00 33.13           C  
ATOM     73  N   ARG A  13      28.720  67.797   7.820  1.00 42.55           N  
ATOM     74  CA  ARG A  13      29.522  66.588   7.771  1.00 43.86           C  
ATOM     75  C   ARG A  13      29.989  66.254   9.166  1.00 44.43           C  
ATOM     76  O   ARG A  13      30.127  67.137  10.017  1.00 45.08           O  
ATOM     77  CB  ARG A  13      30.724  66.763   6.844  1.00 43.98           C  
ATOM     78  CG  ARG A  13      30.370  66.529   5.396  1.00 45.60           C  
ATOM     79  CD  ARG A  13      31.594  66.370   4.531  1.00 45.79           C  
ATOM     80  NE  ARG A  13      31.218  66.237   3.128  1.00 45.84           N  
ATOM     81  CZ  ARG A  13      30.822  65.104   2.563  1.00 44.82           C  
ATOM     82  NH1 ARG A  13      30.759  63.993   3.279  1.00 44.05           N  
ATOM     83  NH2 ARG A  13      30.474  65.091   1.287  1.00 46.36           N  
ATOM     84  N   HIS A  14      30.205  64.971   9.411  1.00 44.35           N  
ATOM     85  CA  HIS A  14      30.669  64.559  10.718  1.00 45.26           C  
ATOM     86  C   HIS A  14      32.152  64.917  10.769  1.00 47.39           C  
ATOM     87  O   HIS A  14      32.960  64.377  10.010  1.00 47.05           O  
ATOM     88  CB  HIS A  14      30.450  63.060  10.904  1.00 42.55           C  
ATOM     89  CG  HIS A  14      30.684  62.595  12.302  1.00 42.24           C  
ATOM     90  ND1 HIS A  14      29.720  61.950  13.043  1.00 44.25           N  
ATOM     91  CD2 HIS A  14      31.772  62.687  13.102  1.00 43.12           C  
ATOM     92  CE1 HIS A  14      30.202  61.663  14.239  1.00 41.17           C  
ATOM     93  NE2 HIS A  14      31.447  62.098  14.299  1.00 42.97           N  
ATOM     94  N   SER A  15      32.499  65.846  11.654  1.00 50.28           N  
ATOM     95  CA  SER A  15      33.877  66.307  11.795  1.00 52.15           C  
ATOM     96  C   SER A  15      34.902  65.177  11.808  1.00 54.56           C  
ATOM     97  O   SER A  15      35.977  65.308  11.225  1.00 56.26           O  
ATOM     98  CB  SER A  15      34.020  67.132  13.069  1.00 51.62           C  
ATOM     99  OG  SER A  15      33.142  68.241  13.042  1.00 54.04           O  
ATOM    100  N   LEU A  16      34.562  64.065  12.455  1.00 55.11           N  
ATOM    101  CA  LEU A  16      35.467  62.927  12.552  1.00 53.95           C  
ATOM    102  C   LEU A  16      35.307  61.879  11.456  1.00 53.97           C  
ATOM    103  O   LEU A  16      36.299  61.473  10.854  1.00 56.36           O  
ATOM    104  CB  LEU A  16      35.307  62.251  13.913  1.00 54.74           C  
ATOM    105  CG  LEU A  16      36.591  61.960  14.691  1.00 55.73           C  
ATOM    106  CD1 LEU A  16      37.250  63.280  15.080  1.00 55.61           C  
ATOM    107  CD2 LEU A  16      36.271  61.142  15.938  1.00 54.38           C  
ATOM    108  N   LEU A  17      34.077  61.425  11.201  1.00 51.43           N  
ATOM    109  CA  LEU A  17      33.836  60.401  10.179  1.00 48.30           C  
ATOM    110  C   LEU A  17      33.575  60.990   8.793  1.00 45.14           C  
ATOM    111  O   LEU A  17      33.625  60.296   7.783  1.00 43.48           O  
ATOM    112  CB  LEU A  17      32.658  59.500  10.582  1.00 52.48           C  
ATOM    113  CG  LEU A  17      32.689  58.673  11.883  1.00 55.19           C  
ATOM    114  CD1 LEU A  17      34.033  57.967  12.034  1.00 54.39           C  
ATOM    115  CD2 LEU A  17      32.448  59.571  13.070  1.00 54.96           C  
ATOM    116  N   GLY A  18      33.277  62.277   8.748  1.00 42.55           N  
ATOM    117  CA  GLY A  18      33.051  62.927   7.474  1.00 40.63           C  
ATOM    118  C   GLY A  18      31.830  62.535   6.673  1.00 40.46           C  
ATOM    119  O   GLY A  18      31.744  62.870   5.494  1.00 40.26           O  
ATOM    120  N   TYR A  19      30.876  61.840   7.283  1.00 40.47           N  
ATOM    121  CA  TYR A  19      29.672  61.474   6.553  1.00 39.03           C  
ATOM    122  C   TYR A  19      28.897  62.750   6.230  1.00 39.23           C  
ATOM    123  O   TYR A  19      29.059  63.773   6.903  1.00 38.93           O  
ATOM    124  CB  TYR A  19      28.807  60.536   7.388  1.00 39.72           C  
ATOM    125  CG  TYR A  19      29.444  59.193   7.631  1.00 44.41           C  
ATOM    126  CD1 TYR A  19      29.796  58.361   6.563  1.00 45.41           C  
ATOM    127  CD2 TYR A  19      29.709  58.748   8.927  1.00 47.50           C  
ATOM    128  CE1 TYR A  19      30.397  57.119   6.778  1.00 45.93           C  
ATOM    129  CE2 TYR A  19      30.314  57.502   9.153  1.00 48.40           C  
ATOM    130  CZ  TYR A  19      30.654  56.697   8.073  1.00 47.23           C  
ATOM    131  OH  TYR A  19      31.260  55.483   8.289  1.00 46.81           O  
ATOM    132  N   LEU A  20      28.068  62.691   5.194  1.00 37.29           N  
ATOM    133  CA  LEU A  20      27.264  63.836   4.793  1.00 37.04           C  
ATOM    134  C   LEU A  20      25.858  63.689   5.324  1.00 36.70           C  
ATOM    135  O   LEU A  20      25.264  62.622   5.209  1.00 38.29           O  
ATOM    136  CB  LEU A  20      27.186  63.938   3.271  1.00 39.07           C  
ATOM    137  CG  LEU A  20      26.225  64.996   2.719  1.00 38.22           C  
ATOM    138  CD1 LEU A  20      26.728  66.400   3.075  1.00 35.78           C  
ATOM    139  CD2 LEU A  20      26.105  64.834   1.212  1.00 37.24           C  
ATOM    140  N   GLY A  21      25.320  64.762   5.891  1.00 35.43           N  
ATOM    141  CA  GLY A  21      23.964  64.707   6.400  1.00 33.28           C  
ATOM    142  C   GLY A  21      23.260  66.045   6.346  1.00 32.91           C  
ATOM    143  O   GLY A  21      23.805  67.033   5.848  1.00 32.02           O  
ATOM    144  N   VAL A  22      22.040  66.077   6.869  1.00 34.45           N  
ATOM    145  CA  VAL A  22      21.243  67.301   6.893  1.00 35.60           C  
ATOM    146  C   VAL A  22      20.674  67.495   8.293  1.00 36.54           C  
ATOM    147  O   VAL A  22      20.139  66.559   8.887  1.00 39.93           O  
ATOM    148  CB  VAL A  22      20.051  67.228   5.882  1.00 34.83           C  
ATOM    149  CG1 VAL A  22      19.236  68.509   5.932  1.00 32.76           C  
ATOM    150  CG2 VAL A  22      20.565  66.981   4.466  1.00 33.13           C  
ATOM    151  N   VAL A  23      20.803  68.698   8.830  1.00 35.90           N  
ATOM    152  CA  VAL A  23      20.257  68.979  10.149  1.00 36.25           C  
ATOM    153  C   VAL A  23      18.728  69.116  10.025  1.00 38.05           C  
ATOM    154  O   VAL A  23      18.224  69.958   9.270  1.00 36.47           O  
ATOM    155  CB  VAL A  23      20.870  70.271  10.721  1.00 36.02           C  
ATOM    156  CG1 VAL A  23      20.232  70.613  12.060  1.00 33.41           C  
ATOM    157  CG2 VAL A  23      22.389  70.093  10.870  1.00 34.15           C  
ATOM    158  N   VAL A  24      18.001  68.267  10.750  1.00 39.41           N  
ATOM    159  CA  VAL A  24      16.540  68.273  10.718  1.00 40.57           C  
ATOM    160  C   VAL A  24      15.913  68.904  11.953  1.00 42.73           C  
ATOM    161  O   VAL A  24      14.764  69.337  11.911  1.00 43.91           O  
ATOM    162  CB  VAL A  24      15.969  66.849  10.545  1.00 40.02           C  
ATOM    163  CG1 VAL A  24      16.450  66.261   9.225  1.00 38.77           C  
ATOM    164  CG2 VAL A  24      16.380  65.960  11.720  1.00 36.36           C  
ATOM    165  N   ASP A  25      16.651  68.941  13.057  1.00 44.39           N  
ATOM    166  CA  ASP A  25      16.142  69.574  14.267  1.00 47.39           C  
ATOM    167  C   ASP A  25      17.254  69.900  15.263  1.00 46.33           C  
ATOM    168  O   ASP A  25      18.330  69.327  15.202  1.00 45.37           O  
ATOM    169  CB  ASP A  25      15.054  68.711  14.912  1.00 51.12           C  
ATOM    170  CG  ASP A  25      14.457  69.359  16.146  1.00 55.59           C  
ATOM    171  OD1 ASP A  25      14.197  70.581  16.115  1.00 57.92           O  
ATOM    172  OD2 ASP A  25      14.247  68.645  17.149  1.00 59.61           O  
ATOM    173  N   ILE A  26      16.990  70.836  16.170  1.00 47.55           N  
ATOM    174  CA  ILE A  26      17.990  71.259  17.151  1.00 50.04           C  
ATOM    175  C   ILE A  26      17.483  71.173  18.593  1.00 51.97           C  
ATOM    176  O   ILE A  26      16.311  71.440  18.857  1.00 54.41           O  
ATOM    177  CB  ILE A  26      18.455  72.711  16.843  1.00 47.62           C  
ATOM    178  CG1 ILE A  26      19.094  72.753  15.452  1.00 48.39           C  
ATOM    179  CG2 ILE A  26      19.446  73.189  17.888  1.00 47.16           C  
ATOM    180  CD1 ILE A  26      19.382  74.144  14.923  1.00 47.05           C  
ATOM    181  N   ASP A  27      18.369  70.781  19.511  1.00 53.29           N  
ATOM    182  CA  ASP A  27      18.041  70.646  20.936  1.00 56.55           C  
ATOM    183  C   ASP A  27      18.908  71.571  21.790  1.00 60.07           C  
ATOM    184  O   ASP A  27      20.111  71.334  21.949  1.00 59.75           O  
ATOM    185  CB  ASP A  27      18.262  69.209  21.416  1.00 55.00           C  
ATOM    186  CG  ASP A  27      17.143  68.273  21.013  1.00 55.09           C  
ATOM    187  OD1 ASP A  27      16.169  68.720  20.371  1.00 55.45           O  
ATOM    188  OD2 ASP A  27      17.239  67.076  21.346  1.00 55.04           O  
ATOM    189  N   PRO A  28      18.301  72.623  22.371  1.00 62.97           N  
ATOM    190  CA  PRO A  28      18.975  73.618  23.220  1.00 64.46           C  
ATOM    191  C   PRO A  28      19.239  73.122  24.643  1.00 65.82           C  
ATOM    192  O   PRO A  28      18.771  72.051  25.035  1.00 65.66           O  
ATOM    193  CB  PRO A  28      17.998  74.801  23.226  1.00 64.39           C  
ATOM    194  CG  PRO A  28      17.003  74.492  22.108  1.00 64.17           C  
ATOM    195  CD  PRO A  28      16.897  73.004  22.151  1.00 63.41           C  
ATOM    196  N   VAL A  29      19.985  73.921  25.408  1.00 67.89           N  
ATOM    197  CA  VAL A  29      20.317  73.615  26.805  1.00 68.78           C  
ATOM    198  C   VAL A  29      21.073  72.295  26.943  1.00 69.61           C  
ATOM    199  O   VAL A  29      22.052  72.050  26.237  1.00 70.81           O  
ATOM    200  CB  VAL A  29      19.028  73.554  27.696  1.00 68.99           C  
ATOM    201  CG1 VAL A  29      19.394  73.212  29.140  1.00 68.93           C  
ATOM    202  CG2 VAL A  29      18.283  74.891  27.641  1.00 66.95           C  
ATOM    203  N   ALA A  48      26.475  73.926  27.155  1.00 69.56           N  
ATOM    204  CA  ALA A  48      25.647  74.780  26.309  1.00 69.86           C  
ATOM    205  C   ALA A  48      25.878  74.470  24.831  1.00 69.57           C  
ATOM    206  O   ALA A  48      25.901  75.379  23.998  1.00 70.00           O  
ATOM    207  CB  ALA A  48      25.955  76.251  26.589  1.00 70.46           C  
ATOM    208  N   ALA A  49      26.036  73.181  24.524  1.00 68.21           N  
ATOM    209  CA  ALA A  49      26.279  72.696  23.167  1.00 64.53           C  
ATOM    210  C   ALA A  49      25.737  73.615  22.062  1.00 62.07           C  
ATOM    211  O   ALA A  49      26.446  74.536  21.665  1.00 63.25           O  
ATOM    212  CB  ALA A  49      25.747  71.270  23.027  1.00 64.61           C  
ATOM    213  N   PRO A  50      24.510  73.391  21.524  1.00 58.73           N  
ATOM    214  CA  PRO A  50      23.421  72.417  21.703  1.00 54.66           C  
ATOM    215  C   PRO A  50      23.658  71.104  20.947  1.00 51.33           C  
ATOM    216  O   PRO A  50      24.764  70.839  20.467  1.00 49.62           O  
ATOM    217  CB  PRO A  50      22.212  73.163  21.152  1.00 54.97           C  
ATOM    218  CG  PRO A  50      22.797  73.912  20.025  1.00 53.50           C  
ATOM    219  CD  PRO A  50      24.051  74.483  20.639  1.00 55.44           C  
ATOM    220  N   TRP A  51      22.618  70.277  20.861  1.00 48.62           N  
ATOM    221  CA  TRP A  51      22.714  69.002  20.151  1.00 45.88           C  
ATOM    222  C   TRP A  51      21.842  69.055  18.918  1.00 44.35           C  
ATOM    223  O   TRP A  51      20.873  69.815  18.862  1.00 42.93           O  
ATOM    224  CB  TRP A  51      22.296  67.833  21.051  1.00 45.19           C  
ATOM    225  CG  TRP A  51      23.308  67.565  22.130  1.00 43.70           C  
ATOM    226  CD1 TRP A  51      23.661  68.409  23.141  1.00 41.13           C  
ATOM    227  CD2 TRP A  51      24.141  66.405  22.265  1.00 42.09           C  
ATOM    228  NE1 TRP A  51      24.667  67.854  23.891  1.00 42.64           N  
ATOM    229  CE2 TRP A  51      24.981  66.623  23.381  1.00 41.60           C  
ATOM    230  CE3 TRP A  51      24.261  65.205  21.551  1.00 43.03           C  
ATOM    231  CZ2 TRP A  51      25.930  65.687  23.806  1.00 41.94           C  
ATOM    232  CZ3 TRP A  51      25.207  64.268  21.972  1.00 43.59           C  
ATOM    233  CH2 TRP A  51      26.030  64.518  23.090  1.00 43.80           C  
ATOM    234  N   TYR A  52      22.193  68.251  17.921  1.00 43.58           N  
ATOM    235  CA  TYR A  52      21.444  68.256  16.669  1.00 41.78           C  
ATOM    236  C   TYR A  52      20.932  66.916  16.209  1.00 39.00           C  
ATOM    237  O   TYR A  52      21.572  65.884  16.405  1.00 37.92           O  
ATOM    238  CB  TYR A  52      22.301  68.824  15.534  1.00 40.62           C  
ATOM    239  CG  TYR A  52      22.806  70.225  15.757  1.00 39.90           C  
ATOM    240  CD1 TYR A  52      22.273  71.301  15.047  1.00 39.03           C  
ATOM    241  CD2 TYR A  52      23.845  70.471  16.655  1.00 38.85           C  
ATOM    242  CE1 TYR A  52      22.772  72.593  15.221  1.00 38.77           C  
ATOM    243  CE2 TYR A  52      24.350  71.749  16.837  1.00 38.70           C  
ATOM    244  CZ  TYR A  52      23.811  72.806  16.117  1.00 38.58           C  
ATOM    245  OH  TYR A  52      24.320  74.066  16.294  1.00 38.15           O  
ATOM    246  N   HIS A  53      19.766  66.967  15.577  1.00 38.20           N  
ATOM    247  CA  HIS A  53      19.137  65.806  14.982  1.00 38.28           C  
ATOM    248  C   HIS A  53      19.516  65.939  13.516  1.00 38.36           C  
ATOM    249  O   HIS A  53      19.136  66.908  12.862  1.00 38.92           O  
ATOM    250  CB  HIS A  53      17.607  65.858  15.126  1.00 36.83           C  
ATOM    251  CG  HIS A  53      17.128  65.604  16.519  1.00 37.19           C  
ATOM    252  ND1 HIS A  53      17.081  66.588  17.482  1.00 39.39           N  
ATOM    253  CD2 HIS A  53      16.763  64.456  17.138  1.00 35.48           C  
ATOM    254  CE1 HIS A  53      16.711  66.057  18.634  1.00 37.58           C  
ATOM    255  NE2 HIS A  53      16.514  64.765  18.452  1.00 32.89           N  
ATOM    256  N   VAL A  54      20.300  65.002  13.002  1.00 38.23           N  
ATOM    257  CA  VAL A  54      20.672  65.085  11.602  1.00 39.43           C  
ATOM    258  C   VAL A  54      20.498  63.740  10.907  1.00 39.03           C  
ATOM    259  O   VAL A  54      20.839  62.693  11.459  1.00 37.05           O  
ATOM    260  CB  VAL A  54      22.155  65.633  11.407  1.00 40.48           C  
ATOM    261  CG1 VAL A  54      22.731  66.119  12.736  1.00 35.77           C  
ATOM    262  CG2 VAL A  54      23.056  64.576  10.759  1.00 40.80           C  
ATOM    263  N   VAL A  55      19.920  63.782   9.710  1.00 39.17           N  
ATOM    264  CA  VAL A  55      19.731  62.577   8.916  1.00 39.90           C  
ATOM    265  C   VAL A  55      21.029  62.521   8.140  1.00 41.06           C  
ATOM    266  O   VAL A  55      21.326  63.410   7.343  1.00 42.73           O  
ATOM    267  CB  VAL A  55      18.519  62.701   7.972  1.00 38.90           C  
ATOM    268  CG1 VAL A  55      18.422  61.482   7.076  1.00 36.33           C  
ATOM    269  CG2 VAL A  55      17.250  62.851   8.797  1.00 35.15           C  
ATOM    270  N   MET A  56      21.808  61.482   8.414  1.00 41.50           N  
ATOM    271  CA  MET A  56      23.123  61.304   7.830  1.00 41.41           C  
ATOM    272  C   MET A  56      23.214  59.978   7.087  1.00 43.65           C  
ATOM    273  O   MET A  56      22.727  58.957   7.568  1.00 44.23           O  
ATOM    274  CB  MET A  56      24.142  61.354   8.975  1.00 38.67           C  
ATOM    275  CG  MET A  56      25.600  61.533   8.606  1.00 36.95           C  
ATOM    276  SD  MET A  56      26.572  61.999  10.080  1.00 35.01           S  
ATOM    277  CE  MET A  56      26.441  63.765  10.021  1.00 30.77           C  
ATOM    278  N   GLU A  57      23.831  59.993   5.910  1.00 46.66           N  
ATOM    279  CA  GLU A  57      23.993  58.776   5.120  1.00 49.20           C  
ATOM    280  C   GLU A  57      25.260  58.062   5.561  1.00 51.03           C  
ATOM    281  O   GLU A  57      26.353  58.611   5.448  1.00 50.99           O  
ATOM    282  CB  GLU A  57      24.078  59.116   3.634  1.00 48.77           C  
ATOM    283  CG  GLU A  57      22.852  58.709   2.846  1.00 51.35           C  
ATOM    284  CD  GLU A  57      22.921  59.144   1.397  1.00 53.52           C  
ATOM    285  OE1 GLU A  57      24.006  59.002   0.795  1.00 55.95           O  
ATOM    286  OE2 GLU A  57      21.892  59.617   0.861  1.00 53.43           O  
ATOM    287  N   ASP A  58      25.116  56.839   6.065  1.00 53.66           N  
ATOM    288  CA  ASP A  58      26.270  56.078   6.528  1.00 56.47           C  
ATOM    289  C   ASP A  58      27.043  55.367   5.423  1.00 58.29           C  
ATOM    290  O   ASP A  58      26.949  55.708   4.243  1.00 57.52           O  
ATOM    291  CB  ASP A  58      25.852  55.038   7.577  1.00 56.56           C  
ATOM    292  CG  ASP A  58      24.946  53.951   7.010  1.00 59.21           C  
ATOM    293  OD1 ASP A  58      24.988  53.690   5.785  1.00 59.51           O  
ATOM    294  OD2 ASP A  58      24.198  53.338   7.806  1.00 61.11           O  
ATOM    295  N   ASP A  59      27.817  54.375   5.847  1.00 60.91           N  
ATOM    296  CA  ASP A  59      28.627  53.545   4.972  1.00 62.33           C  
ATOM    297  C   ASP A  59      27.799  53.034   3.805  1.00 62.84           C  
ATOM    298  O   ASP A  59      28.078  53.342   2.647  1.00 63.26           O  
ATOM    299  CB  ASP A  59      29.148  52.348   5.764  1.00 66.12           C  
ATOM    300  CG  ASP A  59      30.620  52.444   6.070  1.00 69.45           C  
ATOM    301  OD1 ASP A  59      31.076  53.530   6.486  1.00 71.45           O  
ATOM    302  OD2 ASP A  59      31.320  51.421   5.905  1.00 72.40           O  
ATOM    303  N   ASN A  60      26.775  52.247   4.131  1.00 62.40           N  
ATOM    304  CA  ASN A  60      25.893  51.644   3.136  1.00 61.28           C  
ATOM    305  C   ASN A  60      25.091  52.655   2.331  1.00 58.49           C  
ATOM    306  O   ASN A  60      24.654  52.360   1.221  1.00 59.09           O  
ATOM    307  CB  ASN A  60      24.924  50.680   3.815  1.00 64.67           C  
ATOM    308  CG  ASN A  60      25.492  50.091   5.083  1.00 68.54           C  
ATOM    309  OD1 ASN A  60      26.610  49.574   5.089  1.00 70.87           O  
ATOM    310  ND2 ASN A  60      24.725  50.163   6.172  1.00 69.89           N  
ATOM    311  N   GLY A  61      24.891  53.843   2.888  1.00 54.92           N  
ATOM    312  CA  GLY A  61      24.123  54.844   2.176  1.00 49.54           C  
ATOM    313  C   GLY A  61      22.757  55.021   2.806  1.00 47.61           C  
ATOM    314  O   GLY A  61      21.889  55.685   2.239  1.00 47.18           O  
ATOM    315  N   LEU A  62      22.554  54.415   3.974  1.00 44.29           N  
ATOM    316  CA  LEU A  62      21.286  54.557   4.674  1.00 42.12           C  
ATOM    317  C   LEU A  62      21.202  55.942   5.279  1.00 40.42           C  
ATOM    318  O   LEU A  62      22.122  56.380   5.969  1.00 39.96           O  
ATOM    319  CB  LEU A  62      21.142  53.544   5.816  1.00 40.60           C  
ATOM    320  CG  LEU A  62      20.497  52.181   5.560  1.00 41.34           C  
ATOM    321  CD1 LEU A  62      20.238  51.505   6.902  1.00 38.58           C  
ATOM    322  CD2 LEU A  62      19.191  52.341   4.774  1.00 41.03           C  
ATOM    323  N   PRO A  63      20.103  56.660   5.017  1.00 39.41           N  
ATOM    324  CA  PRO A  63      19.944  58.001   5.576  1.00 39.24           C  
ATOM    325  C   PRO A  63      19.416  57.774   6.995  1.00 38.53           C  
ATOM    326  O   PRO A  63      18.214  57.672   7.223  1.00 38.31           O  
ATOM    327  CB  PRO A  63      18.921  58.637   4.639  1.00 38.51           C  
ATOM    328  CG  PRO A  63      18.024  57.485   4.326  1.00 39.42           C  
ATOM    329  CD  PRO A  63      18.989  56.327   4.111  1.00 38.92           C  
ATOM    330  N   VAL A  64      20.336  57.667   7.939  1.00 39.10           N  
ATOM    331  CA  VAL A  64      19.982  57.403   9.322  1.00 40.65           C  
ATOM    332  C   VAL A  64      19.871  58.653  10.197  1.00 40.70           C  
ATOM    333  O   VAL A  64      20.514  59.677   9.952  1.00 41.49           O  
ATOM    334  CB  VAL A  64      21.006  56.429   9.955  1.00 42.20           C  
ATOM    335  CG1 VAL A  64      20.558  56.029  11.356  1.00 44.47           C  
ATOM    336  CG2 VAL A  64      21.152  55.187   9.083  1.00 43.24           C  
ATOM    337  N   HIS A  65      19.041  58.548  11.226  1.00 39.59           N  
ATOM    338  CA  HIS A  65      18.818  59.627  12.171  1.00 40.04           C  
ATOM    339  C   HIS A  65      19.887  59.519  13.265  1.00 38.69           C  
ATOM    340  O   HIS A  65      19.962  58.526  13.976  1.00 37.08           O  
ATOM    341  CB  HIS A  65      17.387  59.494  12.726  1.00 42.57           C  
ATOM    342  CG  HIS A  65      17.075  60.385  13.888  1.00 46.18           C  
ATOM    343  ND1 HIS A  65      17.612  61.646  14.032  1.00 49.90           N  
ATOM    344  CD2 HIS A  65      16.242  60.211  14.943  1.00 47.77           C  
ATOM    345  CE1 HIS A  65      17.129  62.211  15.125  1.00 46.84           C  
ATOM    346  NE2 HIS A  65      16.295  61.362  15.695  1.00 48.05           N  
ATOM    347  N   THR A  66      20.734  60.539  13.358  1.00 37.70           N  
ATOM    348  CA  THR A  66      21.802  60.590  14.352  1.00 37.68           C  
ATOM    349  C   THR A  66      21.577  61.771  15.295  1.00 38.01           C  
ATOM    350  O   THR A  66      20.901  62.743  14.949  1.00 37.98           O  
ATOM    351  CB  THR A  66      23.211  60.783  13.699  1.00 38.42           C  
ATOM    352  OG1 THR A  66      23.233  62.010  12.952  1.00 39.42           O  
ATOM    353  CG2 THR A  66      23.554  59.624  12.762  1.00 39.20           C  
ATOM    354  N   TYR A  67      22.155  61.676  16.487  1.00 37.33           N  
ATOM    355  CA  TYR A  67      22.064  62.727  17.484  1.00 35.94           C  
ATOM    356  C   TYR A  67      23.515  63.068  17.815  1.00 37.02           C  
ATOM    357  O   TYR A  67      24.216  62.287  18.461  1.00 35.75           O  
ATOM    358  CB  TYR A  67      21.327  62.214  18.713  1.00 35.69           C  
ATOM    359  CG  TYR A  67      20.875  63.302  19.658  1.00 36.26           C  
ATOM    360  CD1 TYR A  67      20.065  64.351  19.210  1.00 34.68           C  
ATOM    361  CD2 TYR A  67      21.237  63.272  21.009  1.00 37.21           C  
ATOM    362  CE1 TYR A  67      19.622  65.344  20.087  1.00 36.34           C  
ATOM    363  CE2 TYR A  67      20.802  64.258  21.898  1.00 37.40           C  
ATOM    364  CZ  TYR A  67      19.994  65.291  21.430  1.00 37.80           C  
ATOM    365  OH  TYR A  67      19.561  66.258  22.304  1.00 37.07           O  
ATOM    366  N   LEU A  68      23.957  64.234  17.353  1.00 38.10           N  
ATOM    367  CA  LEU A  68      25.341  64.676  17.534  1.00 37.69           C  
ATOM    368  C   LEU A  68      25.510  65.977  18.275  1.00 38.02           C  
ATOM    369  O   LEU A  68      24.658  66.865  18.216  1.00 39.01           O  
ATOM    370  CB  LEU A  68      26.010  64.844  16.170  1.00 37.01           C  
ATOM    371  CG  LEU A  68      26.074  63.601  15.299  1.00 36.83           C  
ATOM    372  CD1 LEU A  68      26.068  63.997  13.831  1.00 35.19           C  
ATOM    373  CD2 LEU A  68      27.300  62.796  15.689  1.00 34.98           C  
ATOM    374  N   ALA A  69      26.647  66.094  18.948  1.00 38.81           N  
ATOM    375  CA  ALA A  69      26.974  67.303  19.685  1.00 38.98           C  
ATOM    376  C   ALA A  69      27.496  68.294  18.643  1.00 39.04           C  
ATOM    377  O   ALA A  69      28.081  67.885  17.635  1.00 41.45           O  
ATOM    378  CB  ALA A  69      28.045  66.998  20.728  1.00 34.94           C  
ATOM    379  N   GLU A  70      27.274  69.584  18.867  1.00 39.21           N  
ATOM    380  CA  GLU A  70      27.731  70.612  17.929  1.00 38.99           C  
ATOM    381  C   GLU A  70      29.206  70.403  17.570  1.00 38.78           C  
ATOM    382  O   GLU A  70      29.603  70.458  16.404  1.00 40.22           O  
ATOM    383  CB  GLU A  70      27.529  72.001  18.542  1.00 37.77           C  
ATOM    384  CG  GLU A  70      27.648  73.145  17.552  1.00 40.61           C  
ATOM    385  CD  GLU A  70      27.173  74.466  18.138  1.00 41.80           C  
ATOM    386  OE1 GLU A  70      27.902  75.042  18.969  1.00 44.86           O  
ATOM    387  OE2 GLU A  70      26.066  74.927  17.777  1.00 39.67           O  
ATOM    388  N   ALA A  71      30.014  70.144  18.584  1.00 37.98           N  
ATOM    389  CA  ALA A  71      31.433  69.928  18.389  1.00 38.85           C  
ATOM    390  C   ALA A  71      31.716  68.796  17.414  1.00 40.21           C  
ATOM    391  O   ALA A  71      32.859  68.608  17.003  1.00 41.53           O  
ATOM    392  CB  ALA A  71      32.091  69.630  19.732  1.00 37.88           C  
ATOM    393  N   GLN A  72      30.690  68.035  17.047  1.00 40.98           N  
ATOM    394  CA  GLN A  72      30.888  66.915  16.131  1.00 42.63           C  
ATOM    395  C   GLN A  72      30.526  67.231  14.670  1.00 43.30           C  
ATOM    396  O   GLN A  72      30.736  66.406  13.779  1.00 43.55           O  
ATOM    397  CB  GLN A  72      30.092  65.696  16.620  1.00 43.24           C  
ATOM    398  CG  GLN A  72      30.420  65.261  18.056  1.00 44.73           C  
ATOM    399  CD  GLN A  72      29.663  63.999  18.498  1.00 46.61           C  
ATOM    400  OE1 GLN A  72      30.025  62.883  18.128  1.00 46.96           O  
ATOM    401  NE2 GLN A  72      28.603  64.182  19.283  1.00 44.19           N  
ATOM    402  N   LEU A  73      30.013  68.434  14.426  1.00 43.53           N  
ATOM    403  CA  LEU A  73      29.611  68.837  13.081  1.00 42.99           C  
ATOM    404  C   LEU A  73      30.439  69.959  12.442  1.00 43.41           C  
ATOM    405  O   LEU A  73      30.972  70.825  13.132  1.00 42.72           O  
ATOM    406  CB  LEU A  73      28.147  69.273  13.096  1.00 40.78           C  
ATOM    407  CG  LEU A  73      27.117  68.268  13.597  1.00 39.98           C  
ATOM    408  CD1 LEU A  73      25.743  68.943  13.723  1.00 39.03           C  
ATOM    409  CD2 LEU A  73      27.076  67.095  12.648  1.00 39.35           C  
ATOM    410  N   SER A  74      30.511  69.932  11.113  1.00 43.59           N  
ATOM    411  CA  SER A  74      31.213  70.940  10.320  1.00 43.71           C  
ATOM    412  C   SER A  74      30.276  71.278   9.170  1.00 44.78           C  
ATOM    413  O   SER A  74      29.475  70.442   8.752  1.00 45.84           O  
ATOM    414  CB  SER A  74      32.507  70.383   9.726  1.00 42.37           C  
ATOM    415  OG  SER A  74      33.309  69.764  10.708  1.00 46.20           O  
ATOM    416  N   SER A  75      30.384  72.497   8.657  1.00 45.99           N  
ATOM    417  CA  SER A  75      29.556  72.946   7.546  1.00 46.85           C  
ATOM    418  C   SER A  75      29.936  72.193   6.280  1.00 47.74           C  
ATOM    419  O   SER A  75      31.054  71.699   6.165  1.00 46.19           O  
ATOM    420  CB  SER A  75      29.762  74.441   7.313  1.00 46.48           C  
ATOM    421  OG  SER A  75      29.678  75.160   8.527  1.00 48.96           O  
ATOM    422  N   GLU A  76      29.002  72.097   5.336  1.00 50.38           N  
ATOM    423  CA  GLU A  76      29.275  71.425   4.071  1.00 52.37           C  
ATOM    424  C   GLU A  76      29.442  72.466   2.972  1.00 55.12           C  
ATOM    425  O   GLU A  76      28.556  73.293   2.736  1.00 53.75           O  
ATOM    426  CB  GLU A  76      28.150  70.454   3.689  1.00 49.76           C  
ATOM    427  CG  GLU A  76      28.312  69.831   2.289  1.00 47.44           C  
ATOM    428  CD  GLU A  76      29.627  69.077   2.109  1.00 47.81           C  
ATOM    429  OE1 GLU A  76      30.439  69.065   3.059  1.00 49.16           O  
ATOM    430  OE2 GLU A  76      29.855  68.498   1.021  1.00 45.96           O  
ATOM    431  N   LEU A  77      30.588  72.405   2.303  1.00 58.23           N  
ATOM    432  CA  LEU A  77      30.938  73.322   1.218  1.00 60.81           C  
ATOM    433  C   LEU A  77      29.996  73.233   0.012  1.00 61.72           C  
ATOM    434  O   LEU A  77      29.161  74.117  -0.218  1.00 61.20           O  
ATOM    435  CB  LEU A  77      32.364  73.027   0.747  1.00 60.94           C  
ATOM    436  CG  LEU A  77      33.347  72.403   1.749  1.00 62.12           C  
ATOM    437  CD1 LEU A  77      33.453  73.251   3.027  1.00 59.32           C  
ATOM    438  CD2 LEU A  77      32.888  70.989   2.063  1.00 61.32           C  
ATOM    439  N   GLN A  78      30.147  72.151  -0.751  1.00 62.79           N  
ATOM    440  CA  GLN A  78      29.356  71.915  -1.954  1.00 63.88           C  
ATOM    441  C   GLN A  78      27.857  71.912  -1.722  1.00 63.28           C  
ATOM    442  O   GLN A  78      27.377  71.522  -0.661  1.00 63.33           O  
ATOM    443  CB  GLN A  78      29.739  70.581  -2.589  1.00 66.52           C  
ATOM    444  CG  GLN A  78      31.175  70.166  -2.390  1.00 70.69           C  
ATOM    445  CD  GLN A  78      31.404  68.715  -2.776  1.00 74.18           C  
ATOM    446  OE1 GLN A  78      32.436  68.127  -2.440  1.00 77.10           O  
ATOM    447  NE2 GLN A  78      30.440  68.130  -3.490  1.00 72.66           N  
ATOM    448  N   ASP A  79      27.128  72.329  -2.751  1.00 63.86           N  
ATOM    449  CA  ASP A  79      25.677  72.384  -2.726  1.00 64.66           C  
ATOM    450  C   ASP A  79      25.086  71.220  -3.496  1.00 64.00           C  
ATOM    451  O   ASP A  79      23.925  70.869  -3.298  1.00 65.04           O  
ATOM    452  CB  ASP A  79      25.191  73.692  -3.341  1.00 67.08           C  
ATOM    453  CG  ASP A  79      25.436  74.879  -2.437  1.00 70.96           C  
ATOM    454  OD1 ASP A  79      24.763  74.969  -1.383  1.00 71.03           O  
ATOM    455  OD2 ASP A  79      26.306  75.714  -2.775  1.00 73.83           O  
ATOM    456  N   GLU A  80      25.887  70.630  -4.378  1.00 62.88           N  
ATOM    457  CA  GLU A  80      25.435  69.505  -5.181  1.00 62.38           C  
ATOM    458  C   GLU A  80      26.289  68.292  -4.889  1.00 60.50           C  
ATOM    459  O   GLU A  80      27.507  68.400  -4.764  1.00 58.69           O  
ATOM    460  CB  GLU A  80      25.526  69.832  -6.671  1.00 65.48           C  
ATOM    461  CG  GLU A  80      24.777  71.083  -7.088  1.00 69.77           C  
ATOM    462  CD  GLU A  80      24.810  71.303  -8.588  1.00 72.83           C  
ATOM    463  OE1 GLU A  80      24.210  70.483  -9.321  1.00 74.77           O  
ATOM    464  OE2 GLU A  80      25.440  72.288  -9.034  1.00 73.91           O  
ATOM    465  N   HIS A  81      25.641  67.136  -4.781  1.00 59.01           N  
ATOM    466  CA  HIS A  81      26.346  65.893  -4.499  1.00 57.79           C  
ATOM    467  C   HIS A  81      25.803  64.780  -5.373  1.00 58.53           C  
ATOM    468  O   HIS A  81      24.956  63.997  -4.949  1.00 58.04           O  
ATOM    469  CB  HIS A  81      26.202  65.517  -3.024  1.00 54.02           C  
ATOM    470  CG  HIS A  81      26.626  66.603  -2.086  1.00 49.07           C  
ATOM    471  ND1 HIS A  81      25.828  67.689  -1.796  1.00 47.14           N  
ATOM    472  CD2 HIS A  81      27.779  66.791  -1.404  1.00 46.22           C  
ATOM    473  CE1 HIS A  81      26.471  68.500  -0.976  1.00 45.62           C  
ATOM    474  NE2 HIS A  81      27.658  67.978  -0.724  1.00 47.75           N  
ATOM    475  N   PRO A  82      26.294  64.700  -6.619  1.00 60.70           N  
ATOM    476  CA  PRO A  82      25.885  63.694  -7.602  1.00 61.08           C  
ATOM    477  C   PRO A  82      25.819  62.281  -7.023  1.00 62.26           C  
ATOM    478  O   PRO A  82      24.880  61.532  -7.302  1.00 61.43           O  
ATOM    479  CB  PRO A  82      26.950  63.833  -8.684  1.00 62.15           C  
ATOM    480  CG  PRO A  82      27.251  65.309  -8.648  1.00 60.27           C  
ATOM    481  CD  PRO A  82      27.366  65.557  -7.167  1.00 59.54           C  
ATOM    482  N   GLU A  83      26.813  61.929  -6.212  1.00 62.62           N  
ATOM    483  CA  GLU A  83      26.861  60.604  -5.596  1.00 63.83           C  
ATOM    484  C   GLU A  83      25.915  60.456  -4.403  1.00 62.68           C  
ATOM    485  O   GLU A  83      25.733  59.357  -3.873  1.00 62.68           O  
ATOM    486  CB  GLU A  83      28.290  60.273  -5.154  1.00 67.16           C  
ATOM    487  CG  GLU A  83      29.297  61.409  -5.312  1.00 72.99           C  
ATOM    488  CD  GLU A  83      28.944  62.636  -4.490  1.00 75.35           C  
ATOM    489  OE1 GLU A  83      28.788  62.503  -3.257  1.00 78.39           O  
ATOM    490  OE2 GLU A  83      28.827  63.733  -5.077  1.00 77.00           O  
ATOM    491  N   GLN A  84      25.312  61.562  -3.981  1.00 60.46           N  
ATOM    492  CA  GLN A  84      24.397  61.536  -2.851  1.00 57.21           C  
ATOM    493  C   GLN A  84      23.228  62.485  -3.056  1.00 56.87           C  
ATOM    494  O   GLN A  84      22.953  63.346  -2.225  1.00 57.37           O  
ATOM    495  CB  GLN A  84      25.156  61.886  -1.574  1.00 54.66           C  
ATOM    496  CG  GLN A  84      26.107  60.793  -1.153  1.00 49.20           C  
ATOM    497  CD  GLN A  84      26.866  61.138   0.091  1.00 49.08           C  
ATOM    498  OE1 GLN A  84      27.763  61.979   0.067  1.00 50.30           O  
ATOM    499  NE2 GLN A  84      26.506  60.501   1.198  1.00 46.98           N  
ATOM    500  N   PRO A  85      22.507  62.312  -4.173  1.00 56.56           N  
ATOM    501  CA  PRO A  85      21.347  63.105  -4.582  1.00 54.60           C  
ATOM    502  C   PRO A  85      20.333  63.286  -3.469  1.00 53.78           C  
ATOM    503  O   PRO A  85      19.805  64.376  -3.254  1.00 53.89           O  
ATOM    504  CB  PRO A  85      20.754  62.285  -5.723  1.00 54.16           C  
ATOM    505  CG  PRO A  85      21.914  61.554  -6.269  1.00 55.69           C  
ATOM    506  CD  PRO A  85      22.647  61.125  -5.036  1.00 56.57           C  
ATOM    507  N   SER A  86      20.059  62.188  -2.777  1.00 52.03           N  
ATOM    508  CA  SER A  86      19.075  62.166  -1.706  1.00 51.52           C  
ATOM    509  C   SER A  86      19.319  63.186  -0.592  1.00 49.88           C  
ATOM    510  O   SER A  86      18.370  63.676   0.025  1.00 49.31           O  
ATOM    511  CB  SER A  86      18.988  60.744  -1.145  1.00 52.78           C  
ATOM    512  OG  SER A  86      20.287  60.176  -1.025  1.00 57.80           O  
ATOM    513  N   MET A  87      20.584  63.516  -0.348  1.00 46.66           N  
ATOM    514  CA  MET A  87      20.916  64.482   0.685  1.00 45.16           C  
ATOM    515  C   MET A  87      20.657  65.919   0.221  1.00 45.82           C  
ATOM    516  O   MET A  87      20.260  66.773   1.020  1.00 44.41           O  
ATOM    517  CB  MET A  87      22.363  64.290   1.123  1.00 43.69           C  
ATOM    518  CG  MET A  87      22.604  62.973   1.867  1.00 41.63           C  
ATOM    519  SD  MET A  87      21.932  62.891   3.563  1.00 35.27           S  
ATOM    520  CE  MET A  87      20.345  62.210   3.283  1.00 39.50           C  
ATOM    521  N   ASP A  88      20.872  66.193  -1.065  1.00 46.41           N  
ATOM    522  CA  ASP A  88      20.587  67.527  -1.597  1.00 46.41           C  
ATOM    523  C   ASP A  88      19.061  67.639  -1.676  1.00 45.15           C  
ATOM    524  O   ASP A  88      18.488  68.688  -1.415  1.00 43.90           O  
ATOM    525  CB  ASP A  88      21.178  67.713  -3.002  1.00 46.81           C  
ATOM    526  CG  ASP A  88      22.694  67.581  -3.031  1.00 50.95           C  
ATOM    527  OD1 ASP A  88      23.363  68.022  -2.068  1.00 51.85           O  
ATOM    528  OD2 ASP A  88      23.224  67.051  -4.032  1.00 52.25           O  
ATOM    529  N   GLU A  89      18.425  66.527  -2.032  1.00 46.74           N  
ATOM    530  CA  GLU A  89      16.977  66.428  -2.173  1.00 48.15           C  
ATOM    531  C   GLU A  89      16.313  66.673  -0.815  1.00 47.40           C  
ATOM    532  O   GLU A  89      15.272  67.329  -0.719  1.00 44.25           O  
ATOM    533  CB  GLU A  89      16.631  65.028  -2.695  1.00 52.58           C  
ATOM    534  CG  GLU A  89      15.418  64.937  -3.629  1.00 60.49           C  
ATOM    535  CD  GLU A  89      14.084  64.889  -2.893  1.00 65.60           C  
ATOM    536  OE1 GLU A  89      13.830  65.805  -2.074  1.00 69.08           O  
ATOM    537  OE2 GLU A  89      13.291  63.944  -3.138  1.00 64.02           O  
ATOM    538  N   LEU A  90      16.941  66.142   0.232  1.00 46.17           N  
ATOM    539  CA  LEU A  90      16.450  66.278   1.598  1.00 44.14           C  
ATOM    540  C   LEU A  90      16.610  67.725   2.063  1.00 44.44           C  
ATOM    541  O   LEU A  90      15.678  68.332   2.577  1.00 44.41           O  
ATOM    542  CB  LEU A  90      17.252  65.364   2.520  1.00 43.12           C  
ATOM    543  CG  LEU A  90      16.612  64.680   3.724  1.00 40.77           C  
ATOM    544  CD1 LEU A  90      17.703  64.452   4.746  1.00 39.37           C  
ATOM    545  CD2 LEU A  90      15.497  65.516   4.321  1.00 43.80           C  
ATOM    546  N   ALA A  91      17.808  68.268   1.886  1.00 45.43           N  
ATOM    547  CA  ALA A  91      18.092  69.639   2.286  1.00 46.49           C  
ATOM    548  C   ALA A  91      17.069  70.584   1.688  1.00 48.27           C  
ATOM    549  O   ALA A  91      16.495  71.402   2.396  1.00 49.30           O  
ATOM    550  CB  ALA A  91      19.492  70.039   1.842  1.00 43.31           C  
ATOM    551  N   GLN A  92      16.833  70.458   0.384  1.00 51.35           N  
ATOM    552  CA  GLN A  92      15.886  71.321  -0.316  1.00 54.07           C  
ATOM    553  C   GLN A  92      14.461  71.142   0.206  1.00 55.80           C  
ATOM    554  O   GLN A  92      13.755  72.120   0.484  1.00 55.28           O  
ATOM    555  CB  GLN A  92      15.926  71.043  -1.814  1.00 55.51           C  
ATOM    556  CG  GLN A  92      15.218  72.108  -2.630  1.00 62.67           C  
ATOM    557  CD  GLN A  92      14.934  71.675  -4.062  1.00 66.08           C  
ATOM    558  OE1 GLN A  92      14.377  70.594  -4.298  1.00 67.17           O  
ATOM    559  NE2 GLN A  92      15.298  72.524  -5.024  1.00 65.21           N  
ATOM    560  N   THR A  93      14.036  69.892   0.334  1.00 57.05           N  
ATOM    561  CA  THR A  93      12.705  69.611   0.837  1.00 59.21           C  
ATOM    562  C   THR A  93      12.543  70.258   2.212  1.00 61.83           C  
ATOM    563  O   THR A  93      11.671  71.107   2.398  1.00 63.21           O  
ATOM    564  CB  THR A  93      12.463  68.091   0.935  1.00 59.60           C  
ATOM    565  OG1 THR A  93      12.415  67.535  -0.383  1.00 59.46           O  
ATOM    566  CG2 THR A  93      11.155  67.792   1.652  1.00 60.35           C  
ATOM    567  N   ILE A  94      13.395  69.872   3.161  1.00 63.60           N  
ATOM    568  CA  ILE A  94      13.351  70.416   4.518  1.00 65.88           C  
ATOM    569  C   ILE A  94      13.376  71.940   4.568  1.00 68.85           C  
ATOM    570  O   ILE A  94      12.674  72.543   5.376  1.00 68.87           O  
ATOM    571  CB  ILE A  94      14.522  69.882   5.375  1.00 64.98           C  
ATOM    572  CG1 ILE A  94      14.239  68.443   5.783  1.00 63.94           C  
ATOM    573  CG2 ILE A  94      14.719  70.740   6.613  1.00 62.82           C  
ATOM    574  CD1 ILE A  94      15.290  67.872   6.663  1.00 66.11           C  
ATOM    575  N   ARG A  95      14.184  72.556   3.711  1.00 72.76           N  
ATOM    576  CA  ARG A  95      14.286  74.012   3.664  1.00 77.26           C  
ATOM    577  C   ARG A  95      12.958  74.650   3.269  1.00 80.07           C  
ATOM    578  O   ARG A  95      12.909  75.808   2.847  1.00 80.45           O  
ATOM    579  CB  ARG A  95      15.370  74.434   2.672  1.00 78.46           C  
ATOM    580  CG  ARG A  95      16.772  74.356   3.219  1.00 81.41           C  
ATOM    581  CD  ARG A  95      17.788  74.688   2.147  1.00 86.05           C  
ATOM    582  NE  ARG A  95      18.997  75.272   2.722  1.00 91.37           N  
ATOM    583  CZ  ARG A  95      19.037  76.462   3.319  1.00 93.44           C  
ATOM    584  NH1 ARG A  95      17.937  77.199   3.418  1.00 94.96           N  
ATOM    585  NH2 ARG A  95      20.176  76.917   3.828  1.00 94.11           N  
ATOM    586  N   LYS A  96      11.883  73.883   3.407  1.00 83.14           N  
ATOM    587  CA  LYS A  96      10.549  74.351   3.069  1.00 85.84           C  
ATOM    588  C   LYS A  96       9.520  73.750   4.027  1.00 87.61           C  
ATOM    589  O   LYS A  96       8.505  74.383   4.331  1.00 88.30           O  
ATOM    590  CB  LYS A  96      10.217  73.967   1.625  1.00 85.61           C  
ATOM    591  CG  LYS A  96      11.196  74.531   0.605  1.00 85.30           C  
ATOM    592  CD  LYS A  96      10.883  74.040  -0.797  1.00 85.91           C  
ATOM    593  CE  LYS A  96      11.822  74.652  -1.826  1.00 86.22           C  
ATOM    594  NZ  LYS A  96      13.243  74.320  -1.549  1.00 86.30           N  
ATOM    595  N   GLN A  97       9.791  72.534   4.503  1.00 89.06           N  
ATOM    596  CA  GLN A  97       8.892  71.845   5.430  1.00 90.39           C  
ATOM    597  C   GLN A  97       8.858  72.526   6.794  1.00 91.21           C  
ATOM    598  O   GLN A  97       9.396  71.937   7.755  1.00 92.14           O  
ATOM    599  CB  GLN A  97       9.301  70.376   5.610  1.00 89.58           C  
ATOM    600  CG  GLN A  97       9.105  69.508   4.375  1.00 90.83           C  
ATOM    601  CD  GLN A  97       9.165  68.014   4.687  1.00 91.81           C  
ATOM    602  OE1 GLN A  97      10.160  67.510   5.212  1.00 90.74           O  
ATOM    603  NE2 GLN A  97       8.092  67.300   4.356  1.00 91.44           N  
TER     604      GLN A  97                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
