
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 ( 1167),  selected   78 , name 2d9t_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2d9t_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      X      63           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      P      64           #
LGA    K     8_A      P      65          1.846
LGA    V     9_A      A      66          1.879
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    W    10_A      L      69          1.805
LGA    K    11_A      Y      70          1.507
LGA    P    12_A      V      71          0.922
LGA    G    13_A      G      72          1.213
LGA    D    14_A      S      73          0.613
LGA    E    15_A      R      74          0.926
LGA    C    16_A      V      75          0.621
LGA    F    17_A      V      76          1.023
LGA    A    18_A      A      77          1.381
LGA    L    19_A      K      78          0.773
LGA    Y    20_A      Y      79          1.110
LGA    W    21_A      K      80          1.389
LGA    E    22_A      D      81          3.018
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    D    23_A      Q      84          2.521
LGA    N    24_A      V      85          2.434
LGA    K    25_A      W      86          1.304
LGA    F    26_A      L      87          0.811
LGA    Y    27_A      Y      88          0.312
LGA    R    28_A      A      89          0.199
LGA    A    29_A      G      90          0.403
LGA    E    30_A      I      91          0.417
LGA    V    31_A      V      92          0.324
LGA    E    32_A      A      93          0.346
LGA    A    33_A      E      94          0.806
LGA    L    34_A      T      95          1.552
LGA    H    35_A      P      96          2.721
LGA    S    36_A      N      97          0.737
LGA    S    37_A      V      98          3.883
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    G    38_A      K     101          6.353
LGA    M    39_A      L     102          3.393
LGA    T    40_A      R     103          1.290
LGA    A    41_A      F     104          1.355
LGA    V    42_A      L     105          0.855
LGA    V    43_A      I     106          0.652
LGA    K    44_A      F     107          0.174
LGA    F    45_A      F     108          0.398
LGA    T    46_A      D     109          0.357
LGA    D    47_A      D     110          2.168
LGA    Y    48_A      G     111          3.084
LGA    G    49_A      -       -           -
LGA    N    50_A      Y     112          2.733
LGA    Y    51_A      A     113          1.677
LGA    E    52_A      S     114          1.189
LGA    E    53_A      Y     115          1.451
LGA    V    54_A      V     116          1.497
LGA    L    55_A      T     117          1.619
LGA    L    56_A      Q     118          2.009
LGA    S    57_A      S     119          1.488
LGA    N    58_A      E     120          0.516
LGA    I    59_A      L     121          0.658
LGA    K    60_A      Y     122          0.620
LGA    P    61_A      P     123          0.576
LGA    V    62_A      I     124          0.809
LGA    Q    63_A      C     125          1.026
LGA    T    64_A      R     126          0.325
LGA    E    65_A      P     127          5.775
LGA    A    66_A      L     128           -
LGA    W    67_A      K     129           -
LGA    V    68_A      K     130           -
LGA    R    69_A      T     131           -
LGA    D    70_A      W     132           -
LGA    P    71_A      E     133           -
LGA    N    72_A      D     134           -
LGA    S    73_A      I     135           -
LGA    G    74_A      E     136           -
LGA    P    75_A      D     137           -
LGA    S    76_A      I     138           -
LGA    S    77_A      S     139           -
LGA    G    78_A      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78   93    5.0     57    1.90    17.54     56.900     2.847

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.025249 * X  +   0.002759 * Y  +   0.999677 * Z  +  28.560701
  Y_new =   0.978117 * X  +   0.206651 * Y  +   0.024134 * Z  +  79.474106
  Z_new =  -0.206518 * X  +   0.978411 * Y  +  -0.007916 * Z  +  -2.107253 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.578887   -1.562705  [ DEG:    90.4636    -89.5364 ]
  Theta =   0.208015    2.933578  [ DEG:    11.9184    168.0816 ]
  Phi   =   1.596605   -1.544988  [ DEG:    91.4787    -88.5213 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d9t_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d9t_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78   93   5.0   57   1.90   17.54  56.900
REMARK  ---------------------------------------------------------- 
MOLECULE 2d9t_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   13-DEC-05   2D9T              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF TUDOR DOMAIN                
TITLE    2 CONTAINING PROTEIN 3 FROM MOUSE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TUDOR DOMAIN-CONTAINING PROTEIN 3;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: TDRD3;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050214-04;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT           
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN           
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   13-JUN-06 2D9T    0                                                
JRNL        AUTH   H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,                  
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF TUDOR              
JRNL        TITL 2 DOMAIN CONTAINING PROTEIN 3 FROM MOUSE                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D9T A    8    67  UNP    Q91W18   TDRD3_MOUSE    553    612             
SEQRES   1 A   78  GLY SER SER GLY SER SER GLY LYS VAL TRP LYS PRO GLY          
SEQRES   2 A   78  ASP GLU CYS PHE ALA LEU TYR TRP GLU ASP ASN LYS PHE          
SEQRES   3 A   78  TYR ARG ALA GLU VAL GLU ALA LEU HIS SER SER GLY MET          
SEQRES   4 A   78  THR ALA VAL VAL LYS PHE THR ASP TYR GLY ASN TYR GLU          
SEQRES   5 A   78  GLU VAL LEU LEU SER ASN ILE LYS PRO VAL GLN THR GLU          
SEQRES   6 A   78  ALA TRP VAL ARG ASP PRO ASN SER GLY PRO SER SER GLY          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      25.272  94.150  12.761  1.00  0.00           N  
ATOM      2  CA  GLY A   1      25.939  94.160  14.050  1.00  0.00           C  
ATOM      3  C   GLY A   1      27.412  94.500  13.938  1.00  0.00           C  
ATOM      4  O   GLY A   1      27.777  95.663  13.774  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      25.460  94.890  14.686  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      25.839  93.183  14.502  1.00  0.00           H  
ATOM      7  H1  GLY A   1      25.794  94.009  11.943  1.00  0.00           H  
ATOM      8  N   SER A   2      28.261  93.481  14.029  1.00  0.00           N  
ATOM      9  CA  SER A   2      29.703  93.676  13.943  1.00  0.00           C  
ATOM     10  C   SER A   2      30.356  92.559  13.137  1.00  0.00           C  
ATOM     11  O   SER A   2      30.164  91.378  13.424  1.00  0.00           O  
ATOM     12  CB  SER A   2      30.316  93.736  15.345  1.00  0.00           C  
ATOM     13  OG  SER A   2      30.088  94.998  15.947  1.00  0.00           O  
ATOM     14  H   SER A   2      27.908  92.575  14.160  1.00  0.00           H  
ATOM     15  HA  SER A   2      29.880  94.617  13.442  1.00  0.00           H  
ATOM     16  HB2 SER A   2      29.871  92.970  15.961  1.00  0.00           H  
ATOM     17  HB3 SER A   2      31.381  93.570  15.275  1.00  0.00           H  
ATOM     18  HG  SER A   2      30.433  95.691  15.380  1.00  0.00           H  
ATOM     19  N   SER A   3      31.130  92.941  12.126  1.00  0.00           N  
ATOM     20  CA  SER A   3      31.810  91.972  11.274  1.00  0.00           C  
ATOM     21  C   SER A   3      33.225  91.706  11.777  1.00  0.00           C  
ATOM     22  O   SER A   3      33.956  92.631  12.128  1.00  0.00           O  
ATOM     23  CB  SER A   3      31.854  92.475   9.830  1.00  0.00           C  
ATOM     24  OG  SER A   3      32.013  91.399   8.921  1.00  0.00           O  
ATOM     25  H   SER A   3      31.244  93.898  11.947  1.00  0.00           H  
ATOM     26  HA  SER A   3      31.248  91.050  11.308  1.00  0.00           H  
ATOM     27  HB2 SER A   3      30.935  92.990   9.601  1.00  0.00           H  
ATOM     28  HB3 SER A   3      32.686  93.154   9.714  1.00  0.00           H  
ATOM     29  HG  SER A   3      32.136  91.745   8.033  1.00  0.00           H  
ATOM     30  N   GLY A   4      33.606  90.432  11.807  1.00  0.00           N  
ATOM     31  CA  GLY A   4      34.932  90.065  12.267  1.00  0.00           C  
ATOM     32  C   GLY A   4      34.901  89.300  13.575  1.00  0.00           C  
ATOM     33  O   GLY A   4      35.495  89.725  14.566  1.00  0.00           O  
ATOM     34  H   GLY A   4      32.981  89.736  11.514  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      35.406  89.453  11.515  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      35.515  90.964  12.404  1.00  0.00           H  
ATOM     37  N   SER A   5      34.204  88.167  13.579  1.00  0.00           N  
ATOM     38  CA  SER A   5      34.092  87.344  14.778  1.00  0.00           C  
ATOM     39  C   SER A   5      34.199  85.863  14.430  1.00  0.00           C  
ATOM     40  O   SER A   5      33.465  85.357  13.580  1.00  0.00           O  
ATOM     41  CB  SER A   5      32.765  87.617  15.488  1.00  0.00           C  
ATOM     42  OG  SER A   5      32.750  87.036  16.781  1.00  0.00           O  
ATOM     43  H   SER A   5      33.752  87.881  12.758  1.00  0.00           H  
ATOM     44  HA  SER A   5      34.905  87.607  15.437  1.00  0.00           H  
ATOM     45  HB2 SER A   5      32.624  88.683  15.584  1.00  0.00           H  
ATOM     46  HB3 SER A   5      31.956  87.198  14.908  1.00  0.00           H  
ATOM     47  HG  SER A   5      31.914  87.232  17.210  1.00  0.00           H  
ATOM     48  N   SER A   6      35.121  85.171  15.093  1.00  0.00           N  
ATOM     49  CA  SER A   6      35.329  83.747  14.852  1.00  0.00           C  
ATOM     50  C   SER A   6      34.210  82.921  15.479  1.00  0.00           C  
ATOM     51  O   SER A   6      33.669  83.279  16.525  1.00  0.00           O  
ATOM     52  CB  SER A   6      36.681  83.306  15.415  1.00  0.00           C  
ATOM     53  OG  SER A   6      36.672  83.319  16.832  1.00  0.00           O  
ATOM     54  H   SER A   6      35.676  85.629  15.758  1.00  0.00           H  
ATOM     55  HA  SER A   6      35.323  83.588  13.784  1.00  0.00           H  
ATOM     56  HB2 SER A   6      36.898  82.303  15.078  1.00  0.00           H  
ATOM     57  HB3 SER A   6      37.451  83.977  15.064  1.00  0.00           H  
ATOM     58  HG  SER A   6      35.884  82.875  17.152  1.00  0.00           H  
ATOM     59  N   GLY A   7      33.867  81.812  14.831  1.00  0.00           N  
ATOM     60  CA  GLY A   7      32.815  80.952  15.338  1.00  0.00           C  
ATOM     61  C   GLY A   7      31.990  80.328  14.229  1.00  0.00           C  
ATOM     62  O   GLY A   7      32.191  80.628  13.052  1.00  0.00           O  
ATOM     63  H   GLY A   7      34.332  81.576  14.001  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      33.260  80.164  15.927  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      32.162  81.535  15.971  1.00  0.00           H  
ATOM     66  N   LYS A   8      31.058  79.457  14.604  1.00  0.00           N  
ATOM     67  CA  LYS A   8      30.200  78.789  13.634  1.00  0.00           C  
ATOM     68  C   LYS A   8      28.925  78.278  14.296  1.00  0.00           C  
ATOM     69  O   LYS A   8      28.978  77.534  15.276  1.00  0.00           O  
ATOM     70  CB  LYS A   8      30.947  77.627  12.976  1.00  0.00           C  
ATOM     71  CG  LYS A   8      30.161  76.947  11.868  1.00  0.00           C  
ATOM     72  CD  LYS A   8      30.075  77.822  10.628  1.00  0.00           C  
ATOM     73  CE  LYS A   8      28.833  77.506   9.809  1.00  0.00           C  
ATOM     74  NZ  LYS A   8      28.358  78.690   9.042  1.00  0.00           N  
ATOM     75  H   LYS A   8      30.945  79.260  15.558  1.00  0.00           H  
ATOM     76  HA  LYS A   8      29.933  79.510  12.875  1.00  0.00           H  
ATOM     77  HB2 LYS A   8      31.870  77.999  12.557  1.00  0.00           H  
ATOM     78  HB3 LYS A   8      31.176  76.888  13.731  1.00  0.00           H  
ATOM     79  HG2 LYS A   8      30.650  76.021  11.608  1.00  0.00           H  
ATOM     80  HG3 LYS A   8      29.161  76.742  12.223  1.00  0.00           H  
ATOM     81  HD2 LYS A   8      30.037  78.857  10.931  1.00  0.00           H  
ATOM     82  HD3 LYS A   8      30.950  77.654  10.018  1.00  0.00           H  
ATOM     83  HE2 LYS A   8      29.066  76.711   9.118  1.00  0.00           H  
ATOM     84  HE3 LYS A   8      28.049  77.182  10.478  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8      28.987  79.501   9.211  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8      27.395  78.945   9.339  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8      28.350  78.478   8.024  1.00  0.00           H  
ATOM     88  N   VAL A   9      27.779  78.680  13.755  1.00  0.00           N  
ATOM     89  CA  VAL A   9      26.491  78.260  14.291  1.00  0.00           C  
ATOM     90  C   VAL A   9      25.730  77.402  13.287  1.00  0.00           C  
ATOM     91  O   VAL A   9      25.771  77.654  12.083  1.00  0.00           O  
ATOM     92  CB  VAL A   9      25.622  79.471  14.677  1.00  0.00           C  
ATOM     93  CG1 VAL A   9      25.355  80.345  13.462  1.00  0.00           C  
ATOM     94  CG2 VAL A   9      24.317  79.011  15.310  1.00  0.00           C  
ATOM     95  H   VAL A   9      27.802  79.272  12.974  1.00  0.00           H  
ATOM     96  HA  VAL A   9      26.674  77.677  15.183  1.00  0.00           H  
ATOM     97  HB  VAL A   9      26.162  80.060  15.404  1.00  0.00           H  
ATOM     98 HG11 VAL A   9      26.024  80.064  12.662  1.00  0.00           H  
ATOM     99 HG12 VAL A   9      24.332  80.213  13.140  1.00  0.00           H  
ATOM    100 HG13 VAL A   9      25.520  81.382  13.720  1.00  0.00           H  
ATOM    101 HG21 VAL A   9      23.507  79.157  14.610  1.00  0.00           H  
ATOM    102 HG22 VAL A   9      24.390  77.963  15.563  1.00  0.00           H  
ATOM    103 HG23 VAL A   9      24.129  79.586  16.205  1.00  0.00           H  
ATOM    104  N   TRP A  10      25.037  76.387  13.791  1.00  0.00           N  
ATOM    105  CA  TRP A  10      24.266  75.490  12.937  1.00  0.00           C  
ATOM    106  C   TRP A  10      22.821  75.962  12.816  1.00  0.00           C  
ATOM    107  O   TRP A  10      22.351  76.769  13.619  1.00  0.00           O  
ATOM    108  CB  TRP A  10      24.304  74.066  13.491  1.00  0.00           C  
ATOM    109  CG  TRP A  10      25.678  73.466  13.490  1.00  0.00           C  
ATOM    110  CD1 TRP A  10      26.420  73.116  14.582  1.00  0.00           C  
ATOM    111  CD2 TRP A  10      26.474  73.148  12.344  1.00  0.00           C  
ATOM    112  NE1 TRP A  10      27.629  72.598  14.183  1.00  0.00           N  
ATOM    113  CE2 TRP A  10      27.686  72.607  12.814  1.00  0.00           C  
ATOM    114  CE3 TRP A  10      26.279  73.265  10.964  1.00  0.00           C  
ATOM    115  CZ2 TRP A  10      28.698  72.187  11.955  1.00  0.00           C  
ATOM    116  CZ3 TRP A  10      27.285  72.849  10.112  1.00  0.00           C  
ATOM    117  CH2 TRP A  10      28.481  72.315  10.609  1.00  0.00           C  
ATOM    118  H   TRP A  10      25.043  76.237  14.760  1.00  0.00           H  
ATOM    119  HA  TRP A  10      24.717  75.498  11.956  1.00  0.00           H  
ATOM    120  HB2 TRP A  10      23.944  74.072  14.509  1.00  0.00           H  
ATOM    121  HB3 TRP A  10      23.665  73.436  12.890  1.00  0.00           H  
ATOM    122  HD1 TRP A  10      26.092  73.234  15.603  1.00  0.00           H  
ATOM    123  HE1 TRP A  10      28.335  72.276  14.782  1.00  0.00           H  
ATOM    124  HE3 TRP A  10      25.365  73.675  10.562  1.00  0.00           H  
ATOM    125  HZ2 TRP A  10      29.625  71.773  12.322  1.00  0.00           H  
ATOM    126  HZ3 TRP A  10      27.152  72.932   9.043  1.00  0.00           H  
ATOM    127  HH2 TRP A  10      29.238  72.002   9.907  1.00  0.00           H  
ATOM    128  N   LYS A  11      22.119  75.456  11.808  1.00  0.00           N  
ATOM    129  CA  LYS A  11      20.727  75.825  11.583  1.00  0.00           C  
ATOM    130  C   LYS A  11      19.983  74.716  10.844  1.00  0.00           C  
ATOM    131  O   LYS A  11      20.575  73.914  10.121  1.00  0.00           O  
ATOM    132  CB  LYS A  11      20.645  77.127  10.785  1.00  0.00           C  
ATOM    133  CG  LYS A  11      21.816  78.064  11.028  1.00  0.00           C  
ATOM    134  CD  LYS A  11      21.683  79.345  10.221  1.00  0.00           C  
ATOM    135  CE  LYS A  11      20.416  80.103  10.584  1.00  0.00           C  
ATOM    136  NZ  LYS A  11      20.328  81.409   9.872  1.00  0.00           N  
ATOM    137  H   LYS A  11      22.549  74.817  11.201  1.00  0.00           H  
ATOM    138  HA  LYS A  11      20.263  75.972  12.547  1.00  0.00           H  
ATOM    139  HB2 LYS A  11      20.614  76.890   9.732  1.00  0.00           H  
ATOM    140  HB3 LYS A  11      19.735  77.645  11.055  1.00  0.00           H  
ATOM    141  HG2 LYS A  11      21.852  78.316  12.078  1.00  0.00           H  
ATOM    142  HG3 LYS A  11      22.731  77.563  10.744  1.00  0.00           H  
ATOM    143  HD2 LYS A  11      22.537  79.976  10.420  1.00  0.00           H  
ATOM    144  HD3 LYS A  11      21.654  79.095   9.170  1.00  0.00           H  
ATOM    145  HE2 LYS A  11      19.562  79.500  10.319  1.00  0.00           H  
ATOM    146  HE3 LYS A  11      20.412  80.283  11.649  1.00  0.00           H  
ATOM    147  HZ1 LYS A  11      19.628  81.350   9.105  1.00  0.00           H  
ATOM    148  HZ2 LYS A  11      21.252  81.656   9.465  1.00  0.00           H  
ATOM    149  HZ3 LYS A  11      20.039  82.158  10.533  1.00  0.00           H  
ATOM    150  N   PRO A  12      18.655  74.669  11.027  1.00  0.00           N  
ATOM    151  CA  PRO A  12      17.802  73.665  10.384  1.00  0.00           C  
ATOM    152  C   PRO A  12      17.686  73.881   8.879  1.00  0.00           C  
ATOM    153  O   PRO A  12      16.915  74.722   8.420  1.00  0.00           O  
ATOM    154  CB  PRO A  12      16.444  73.868  11.059  1.00  0.00           C  
ATOM    155  CG  PRO A  12      16.456  75.286  11.516  1.00  0.00           C  
ATOM    156  CD  PRO A  12      17.884  75.594  11.874  1.00  0.00           C  
ATOM    157  HA  PRO A  12      18.156  72.663  10.576  1.00  0.00           H  
ATOM    158  HB2 PRO A  12      15.654  73.689  10.344  1.00  0.00           H  
ATOM    159  HB3 PRO A  12      16.346  73.187  11.891  1.00  0.00           H  
ATOM    160  HG2 PRO A  12      16.123  75.931  10.717  1.00  0.00           H  
ATOM    161  HG3 PRO A  12      15.820  75.398  12.381  1.00  0.00           H  
ATOM    162  HD2 PRO A  12      18.119  76.621  11.639  1.00  0.00           H  
ATOM    163  HD3 PRO A  12      18.061  75.394  12.921  1.00  0.00           H  
ATOM    164  N   GLY A  13      18.459  73.115   8.113  1.00  0.00           N  
ATOM    165  CA  GLY A  13      18.427  73.238   6.668  1.00  0.00           C  
ATOM    166  C   GLY A  13      19.802  73.473   6.076  1.00  0.00           C  
ATOM    167  O   GLY A  13      19.938  74.141   5.050  1.00  0.00           O  
ATOM    168  H   GLY A  13      19.055  72.461   8.535  1.00  0.00           H  
ATOM    169  HA2 GLY A  13      18.016  72.331   6.249  1.00  0.00           H  
ATOM    170  HA3 GLY A  13      17.788  74.067   6.404  1.00  0.00           H  
ATOM    171  N   ASP A  14      20.825  72.923   6.723  1.00  0.00           N  
ATOM    172  CA  ASP A  14      22.197  73.076   6.254  1.00  0.00           C  
ATOM    173  C   ASP A  14      22.915  71.731   6.225  1.00  0.00           C  
ATOM    174  O   ASP A  14      22.914  70.996   7.212  1.00  0.00           O  
ATOM    175  CB  ASP A  14      22.958  74.056   7.149  1.00  0.00           C  
ATOM    176  CG  ASP A  14      22.584  75.500   6.878  1.00  0.00           C  
ATOM    177  OD1 ASP A  14      21.376  75.813   6.901  1.00  0.00           O  
ATOM    178  OD2 ASP A  14      23.500  76.316   6.640  1.00  0.00           O  
ATOM    179  H   ASP A  14      20.652  72.402   7.534  1.00  0.00           H  
ATOM    180  HA  ASP A  14      22.163  73.473   5.250  1.00  0.00           H  
ATOM    181  HB2 ASP A  14      22.736  73.835   8.183  1.00  0.00           H  
ATOM    182  HB3 ASP A  14      24.019  73.939   6.979  1.00  0.00           H  
ATOM    183  N   GLU A  15      23.526  71.415   5.087  1.00  0.00           N  
ATOM    184  CA  GLU A  15      24.246  70.157   4.930  1.00  0.00           C  
ATOM    185  C   GLU A  15      25.548  70.173   5.724  1.00  0.00           C  
ATOM    186  O   GLU A  15      26.361  71.088   5.585  1.00  0.00           O  
ATOM    187  CB  GLU A  15      24.540  69.893   3.452  1.00  0.00           C  
ATOM    188  CG  GLU A  15      25.376  70.978   2.794  1.00  0.00           C  
ATOM    189  CD  GLU A  15      25.084  71.121   1.313  1.00  0.00           C  
ATOM    190  OE1 GLU A  15      23.987  70.706   0.882  1.00  0.00           O  
ATOM    191  OE2 GLU A  15      25.951  71.648   0.585  1.00  0.00           O  
ATOM    192  H   GLU A  15      23.491  72.043   4.335  1.00  0.00           H  
ATOM    193  HA  GLU A  15      23.617  69.366   5.309  1.00  0.00           H  
ATOM    194  HB2 GLU A  15      25.069  68.956   3.365  1.00  0.00           H  
ATOM    195  HB3 GLU A  15      23.603  69.817   2.920  1.00  0.00           H  
ATOM    196  HG2 GLU A  15      25.167  71.920   3.280  1.00  0.00           H  
ATOM    197  HG3 GLU A  15      26.421  70.734   2.918  1.00  0.00           H  
ATOM    198  N   CYS A  16      25.739  69.155   6.557  1.00  0.00           N  
ATOM    199  CA  CYS A  16      26.943  69.053   7.376  1.00  0.00           C  
ATOM    200  C   CYS A  16      27.364  67.596   7.541  1.00  0.00           C  
ATOM    201  O   CYS A  16      26.640  66.681   7.149  1.00  0.00           O  
ATOM    202  CB  CYS A  16      26.707  69.687   8.747  1.00  0.00           C  
ATOM    203  SG  CYS A  16      25.400  68.896   9.713  1.00  0.00           S  
ATOM    204  H   CYS A  16      25.055  68.458   6.624  1.00  0.00           H  
ATOM    205  HA  CYS A  16      27.732  69.588   6.871  1.00  0.00           H  
ATOM    206  HB2 CYS A  16      27.619  69.630   9.322  1.00  0.00           H  
ATOM    207  HB3 CYS A  16      26.438  70.724   8.613  1.00  0.00           H  
ATOM    208  HG  CYS A  16      24.274  68.977   9.020  1.00  0.00           H  
ATOM    209  N   PHE A  17      28.540  67.389   8.122  1.00  0.00           N  
ATOM    210  CA  PHE A  17      29.061  66.044   8.337  1.00  0.00           C  
ATOM    211  C   PHE A  17      28.934  65.639   9.803  1.00  0.00           C  
ATOM    212  O   PHE A  17      29.498  66.284  10.687  1.00  0.00           O  
ATOM    213  CB  PHE A  17      30.525  65.964   7.899  1.00  0.00           C  
ATOM    214  CG  PHE A  17      30.698  65.654   6.439  1.00  0.00           C  
ATOM    215  CD1 PHE A  17      30.456  66.622   5.479  1.00  0.00           C  
ATOM    216  CD2 PHE A  17      31.102  64.394   6.028  1.00  0.00           C  
ATOM    217  CE1 PHE A  17      30.613  66.341   4.135  1.00  0.00           C  
ATOM    218  CE2 PHE A  17      31.261  64.106   4.686  1.00  0.00           C  
ATOM    219  CZ  PHE A  17      31.017  65.080   3.739  1.00  0.00           C  
ATOM    220  H   PHE A  17      29.072  68.159   8.414  1.00  0.00           H  
ATOM    221  HA  PHE A  17      28.476  65.363   7.737  1.00  0.00           H  
ATOM    222  HB2 PHE A  17      31.003  66.911   8.095  1.00  0.00           H  
ATOM    223  HB3 PHE A  17      31.020  65.189   8.465  1.00  0.00           H  
ATOM    224  HD1 PHE A  17      30.140  67.609   5.788  1.00  0.00           H  
ATOM    225  HD2 PHE A  17      31.293  63.630   6.769  1.00  0.00           H  
ATOM    226  HE1 PHE A  17      30.422  67.104   3.397  1.00  0.00           H  
ATOM    227  HE2 PHE A  17      31.578  63.120   4.379  1.00  0.00           H  
ATOM    228  HZ  PHE A  17      31.141  64.858   2.689  1.00  0.00           H  
ATOM    229  N   ALA A  18      28.189  64.568  10.053  1.00  0.00           N  
ATOM    230  CA  ALA A  18      27.989  64.075  11.410  1.00  0.00           C  
ATOM    231  C   ALA A  18      28.642  62.710  11.602  1.00  0.00           C  
ATOM    232  O   ALA A  18      28.622  61.871  10.702  1.00  0.00           O  
ATOM    233  CB  ALA A  18      26.504  64.003  11.731  1.00  0.00           C  
ATOM    234  H   ALA A  18      27.765  64.096   9.306  1.00  0.00           H  
ATOM    235  HA  ALA A  18      28.445  64.780  12.091  1.00  0.00           H  
ATOM    236  HB1 ALA A  18      26.373  63.844  12.792  1.00  0.00           H  
ATOM    237  HB2 ALA A  18      26.027  64.927  11.444  1.00  0.00           H  
ATOM    238  HB3 ALA A  18      26.058  63.183  11.187  1.00  0.00           H  
ATOM    239  N   LEU A  19      29.220  62.496  12.779  1.00  0.00           N  
ATOM    240  CA  LEU A  19      29.879  61.232  13.088  1.00  0.00           C  
ATOM    241  C   LEU A  19      28.858  60.162  13.459  1.00  0.00           C  
ATOM    242  O   LEU A  19      28.163  60.275  14.469  1.00  0.00           O  
ATOM    243  CB  LEU A  19      30.876  61.421  14.233  1.00  0.00           C  
ATOM    244  CG  LEU A  19      32.097  60.502  14.218  1.00  0.00           C  
ATOM    245  CD1 LEU A  19      33.039  60.882  13.087  1.00  0.00           C  
ATOM    246  CD2 LEU A  19      32.820  60.553  15.556  1.00  0.00           C  
ATOM    247  H   LEU A  19      29.203  63.203  13.456  1.00  0.00           H  
ATOM    248  HA  LEU A  19      30.414  60.913  12.205  1.00  0.00           H  
ATOM    249  HB2 LEU A  19      31.230  62.440  14.198  1.00  0.00           H  
ATOM    250  HB3 LEU A  19      30.347  61.257  15.161  1.00  0.00           H  
ATOM    251  HG  LEU A  19      31.771  59.484  14.052  1.00  0.00           H  
ATOM    252 HD11 LEU A  19      33.991  61.180  13.497  1.00  0.00           H  
ATOM    253 HD12 LEU A  19      32.616  61.703  12.527  1.00  0.00           H  
ATOM    254 HD13 LEU A  19      33.177  60.034  12.433  1.00  0.00           H  
ATOM    255 HD21 LEU A  19      32.153  60.947  16.310  1.00  0.00           H  
ATOM    256 HD22 LEU A  19      33.687  61.192  15.473  1.00  0.00           H  
ATOM    257 HD23 LEU A  19      33.131  59.557  15.836  1.00  0.00           H  
ATOM    258  N   TYR A  20      28.774  59.122  12.636  1.00  0.00           N  
ATOM    259  CA  TYR A  20      27.838  58.030  12.878  1.00  0.00           C  
ATOM    260  C   TYR A  20      27.982  57.494  14.299  1.00  0.00           C  
ATOM    261  O   TYR A  20      29.046  57.599  14.909  1.00  0.00           O  
ATOM    262  CB  TYR A  20      28.065  56.903  11.869  1.00  0.00           C  
ATOM    263  CG  TYR A  20      26.833  56.068  11.608  1.00  0.00           C  
ATOM    264  CD1 TYR A  20      25.599  56.665  11.383  1.00  0.00           C  
ATOM    265  CD2 TYR A  20      26.903  54.679  11.584  1.00  0.00           C  
ATOM    266  CE1 TYR A  20      24.470  55.905  11.144  1.00  0.00           C  
ATOM    267  CE2 TYR A  20      25.779  53.911  11.344  1.00  0.00           C  
ATOM    268  CZ  TYR A  20      24.565  54.529  11.125  1.00  0.00           C  
ATOM    269  OH  TYR A  20      23.444  53.769  10.885  1.00  0.00           O  
ATOM    270  H   TYR A  20      29.353  59.088  11.848  1.00  0.00           H  
ATOM    271  HA  TYR A  20      26.837  58.417  12.751  1.00  0.00           H  
ATOM    272  HB2 TYR A  20      28.382  57.328  10.930  1.00  0.00           H  
ATOM    273  HB3 TYR A  20      28.838  56.247  12.242  1.00  0.00           H  
ATOM    274  HD1 TYR A  20      25.528  57.743  11.397  1.00  0.00           H  
ATOM    275  HD2 TYR A  20      27.855  54.199  11.756  1.00  0.00           H  
ATOM    276  HE1 TYR A  20      23.520  56.387  10.971  1.00  0.00           H  
ATOM    277  HE2 TYR A  20      25.853  52.834  11.331  1.00  0.00           H  
ATOM    278  HH  TYR A  20      22.701  54.345  10.696  1.00  0.00           H  
ATOM    279  N   TRP A  21      26.904  56.918  14.818  1.00  0.00           N  
ATOM    280  CA  TRP A  21      26.908  56.364  16.168  1.00  0.00           C  
ATOM    281  C   TRP A  21      27.287  54.887  16.147  1.00  0.00           C  
ATOM    282  O   TRP A  21      27.431  54.261  17.197  1.00  0.00           O  
ATOM    283  CB  TRP A  21      25.536  56.541  16.819  1.00  0.00           C  
ATOM    284  CG  TRP A  21      24.459  55.724  16.171  1.00  0.00           C  
ATOM    285  CD1 TRP A  21      23.625  56.118  15.165  1.00  0.00           C  
ATOM    286  CD2 TRP A  21      24.102  54.374  16.485  1.00  0.00           C  
ATOM    287  NE1 TRP A  21      22.769  55.094  14.836  1.00  0.00           N  
ATOM    288  CE2 TRP A  21      23.043  54.013  15.631  1.00  0.00           C  
ATOM    289  CE3 TRP A  21      24.575  53.433  17.405  1.00  0.00           C  
ATOM    290  CZ2 TRP A  21      22.450  52.753  15.670  1.00  0.00           C  
ATOM    291  CZ3 TRP A  21      23.986  52.185  17.444  1.00  0.00           C  
ATOM    292  CH2 TRP A  21      22.933  51.853  16.581  1.00  0.00           C  
ATOM    293  H   TRP A  21      26.084  56.864  14.282  1.00  0.00           H  
ATOM    294  HA  TRP A  21      27.643  56.904  16.744  1.00  0.00           H  
ATOM    295  HB2 TRP A  21      25.596  56.250  17.856  1.00  0.00           H  
ATOM    296  HB3 TRP A  21      25.248  57.581  16.756  1.00  0.00           H  
ATOM    297  HD1 TRP A  21      23.643  57.094  14.706  1.00  0.00           H  
ATOM    298  HE1 TRP A  21      22.078  55.132  14.142  1.00  0.00           H  
ATOM    299  HE3 TRP A  21      25.386  53.670  18.079  1.00  0.00           H  
ATOM    300  HZ2 TRP A  21      21.638  52.483  15.011  1.00  0.00           H  
ATOM    301  HZ3 TRP A  21      24.338  51.445  18.149  1.00  0.00           H  
ATOM    302  HH2 TRP A  21      22.503  50.866  16.646  1.00  0.00           H  
ATOM    303  N   GLU A  22      27.448  54.337  14.948  1.00  0.00           N  
ATOM    304  CA  GLU A  22      27.810  52.934  14.793  1.00  0.00           C  
ATOM    305  C   GLU A  22      29.095  52.789  13.983  1.00  0.00           C  
ATOM    306  O   GLU A  22      29.701  51.718  13.946  1.00  0.00           O  
ATOM    307  CB  GLU A  22      26.676  52.163  14.114  1.00  0.00           C  
ATOM    308  CG  GLU A  22      25.646  51.613  15.087  1.00  0.00           C  
ATOM    309  CD  GLU A  22      24.919  50.399  14.542  1.00  0.00           C  
ATOM    310  OE1 GLU A  22      24.365  50.490  13.426  1.00  0.00           O  
ATOM    311  OE2 GLU A  22      24.904  49.359  15.232  1.00  0.00           O  
ATOM    312  H   GLU A  22      27.319  54.889  14.148  1.00  0.00           H  
ATOM    313  HA  GLU A  22      27.973  52.522  15.778  1.00  0.00           H  
ATOM    314  HB2 GLU A  22      26.173  52.822  13.422  1.00  0.00           H  
ATOM    315  HB3 GLU A  22      27.099  51.334  13.565  1.00  0.00           H  
ATOM    316  HG2 GLU A  22      26.146  51.333  16.002  1.00  0.00           H  
ATOM    317  HG3 GLU A  22      24.920  52.385  15.298  1.00  0.00           H  
ATOM    318  N   ASP A  23      29.503  53.874  13.334  1.00  0.00           N  
ATOM    319  CA  ASP A  23      30.715  53.869  12.524  1.00  0.00           C  
ATOM    320  C   ASP A  23      31.716  54.900  13.036  1.00  0.00           C  
ATOM    321  O   ASP A  23      32.909  54.821  12.746  1.00  0.00           O  
ATOM    322  CB  ASP A  23      30.377  54.152  11.059  1.00  0.00           C  
ATOM    323  CG  ASP A  23      31.510  53.785  10.122  1.00  0.00           C  
ATOM    324  OD1 ASP A  23      32.676  54.088  10.453  1.00  0.00           O  
ATOM    325  OD2 ASP A  23      31.232  53.194   9.058  1.00  0.00           O  
ATOM    326  H   ASP A  23      28.977  54.697  13.403  1.00  0.00           H  
ATOM    327  HA  ASP A  23      31.161  52.888  12.598  1.00  0.00           H  
ATOM    328  HB2 ASP A  23      29.505  53.578  10.781  1.00  0.00           H  
ATOM    329  HB3 ASP A  23      30.163  55.203  10.943  1.00  0.00           H  
ATOM    330  N   ASN A  24      31.219  55.870  13.799  1.00  0.00           N  
ATOM    331  CA  ASN A  24      32.069  56.919  14.350  1.00  0.00           C  
ATOM    332  C   ASN A  24      32.896  57.582  13.253  1.00  0.00           C  
ATOM    333  O   ASN A  24      33.983  58.102  13.507  1.00  0.00           O  
ATOM    334  CB  ASN A  24      32.994  56.342  15.424  1.00  0.00           C  
ATOM    335  CG  ASN A  24      34.163  55.580  14.832  1.00  0.00           C  
ATOM    336  OD1 ASN A  24      35.135  56.175  14.364  1.00  0.00           O  
ATOM    337  ND2 ASN A  24      34.074  54.255  14.848  1.00  0.00           N  
ATOM    338  H   ASN A  24      30.259  55.880  13.995  1.00  0.00           H  
ATOM    339  HA  ASN A  24      31.429  57.662  14.800  1.00  0.00           H  
ATOM    340  HB2 ASN A  24      33.385  57.151  16.026  1.00  0.00           H  
ATOM    341  HB3 ASN A  24      32.431  55.671  16.054  1.00  0.00           H  
ATOM    342 HD21 ASN A  24      33.271  53.849  15.237  1.00  0.00           H  
ATOM    343 HD22 ASN A  24      34.817  53.737  14.472  1.00  0.00           H  
ATOM    344  N   LYS A  25      32.375  57.560  12.031  1.00  0.00           N  
ATOM    345  CA  LYS A  25      33.062  58.159  10.895  1.00  0.00           C  
ATOM    346  C   LYS A  25      32.289  59.363  10.364  1.00  0.00           C  
ATOM    347  O   LYS A  25      31.059  59.391  10.406  1.00  0.00           O  
ATOM    348  CB  LYS A  25      33.246  57.126   9.781  1.00  0.00           C  
ATOM    349  CG  LYS A  25      34.415  56.184  10.011  1.00  0.00           C  
ATOM    350  CD  LYS A  25      35.738  56.839   9.655  1.00  0.00           C  
ATOM    351  CE  LYS A  25      36.906  55.891   9.876  1.00  0.00           C  
ATOM    352  NZ  LYS A  25      38.215  56.550   9.610  1.00  0.00           N  
ATOM    353  H   LYS A  25      31.505  57.129  11.891  1.00  0.00           H  
ATOM    354  HA  LYS A  25      34.033  58.491  11.231  1.00  0.00           H  
ATOM    355  HB2 LYS A  25      32.345  56.537   9.700  1.00  0.00           H  
ATOM    356  HB3 LYS A  25      33.410  57.647   8.847  1.00  0.00           H  
ATOM    357  HG2 LYS A  25      34.435  55.899  11.052  1.00  0.00           H  
ATOM    358  HG3 LYS A  25      34.282  55.304   9.398  1.00  0.00           H  
ATOM    359  HD2 LYS A  25      35.718  57.130   8.616  1.00  0.00           H  
ATOM    360  HD3 LYS A  25      35.874  57.715  10.274  1.00  0.00           H  
ATOM    361  HE2 LYS A  25      36.887  55.548  10.900  1.00  0.00           H  
ATOM    362  HE3 LYS A  25      36.798  55.045   9.213  1.00  0.00           H  
ATOM    363  HZ1 LYS A  25      38.074  57.567   9.443  1.00  0.00           H  
ATOM    364  HZ2 LYS A  25      38.662  56.131   8.771  1.00  0.00           H  
ATOM    365  HZ3 LYS A  25      38.848  56.428  10.425  1.00  0.00           H  
ATOM    366  N   PHE A  26      33.017  60.355   9.863  1.00  0.00           N  
ATOM    367  CA  PHE A  26      32.400  61.561   9.324  1.00  0.00           C  
ATOM    368  C   PHE A  26      31.661  61.258   8.023  1.00  0.00           C  
ATOM    369  O   PHE A  26      32.270  60.875   7.025  1.00  0.00           O  
ATOM    370  CB  PHE A  26      33.459  62.638   9.082  1.00  0.00           C  
ATOM    371  CG  PHE A  26      33.957  63.283  10.344  1.00  0.00           C  
ATOM    372  CD1 PHE A  26      33.071  63.865  11.236  1.00  0.00           C  
ATOM    373  CD2 PHE A  26      35.310  63.308  10.638  1.00  0.00           C  
ATOM    374  CE1 PHE A  26      33.525  64.460  12.397  1.00  0.00           C  
ATOM    375  CE2 PHE A  26      35.771  63.901  11.798  1.00  0.00           C  
ATOM    376  CZ  PHE A  26      34.878  64.477  12.680  1.00  0.00           C  
ATOM    377  H   PHE A  26      33.995  60.274   9.857  1.00  0.00           H  
ATOM    378  HA  PHE A  26      31.691  61.922  10.052  1.00  0.00           H  
ATOM    379  HB2 PHE A  26      34.306  62.193   8.581  1.00  0.00           H  
ATOM    380  HB3 PHE A  26      33.040  63.410   8.455  1.00  0.00           H  
ATOM    381  HD1 PHE A  26      32.013  63.851  11.017  1.00  0.00           H  
ATOM    382  HD2 PHE A  26      36.011  62.857   9.949  1.00  0.00           H  
ATOM    383  HE1 PHE A  26      32.824  64.909  13.085  1.00  0.00           H  
ATOM    384  HE2 PHE A  26      36.829  63.913  12.016  1.00  0.00           H  
ATOM    385  HZ  PHE A  26      35.235  64.942  13.586  1.00  0.00           H  
ATOM    386  N   TYR A  27      30.344  61.433   8.044  1.00  0.00           N  
ATOM    387  CA  TYR A  27      29.520  61.176   6.869  1.00  0.00           C  
ATOM    388  C   TYR A  27      28.608  62.363   6.573  1.00  0.00           C  
ATOM    389  O   TYR A  27      28.212  63.097   7.479  1.00  0.00           O  
ATOM    390  CB  TYR A  27      28.682  59.913   7.075  1.00  0.00           C  
ATOM    391  CG  TYR A  27      29.507  58.656   7.230  1.00  0.00           C  
ATOM    392  CD1 TYR A  27      30.612  58.423   6.420  1.00  0.00           C  
ATOM    393  CD2 TYR A  27      29.183  57.702   8.186  1.00  0.00           C  
ATOM    394  CE1 TYR A  27      31.369  57.276   6.558  1.00  0.00           C  
ATOM    395  CE2 TYR A  27      29.935  56.552   8.332  1.00  0.00           C  
ATOM    396  CZ  TYR A  27      31.027  56.344   7.516  1.00  0.00           C  
ATOM    397  OH  TYR A  27      31.779  55.200   7.657  1.00  0.00           O  
ATOM    398  H   TYR A  27      29.915  61.740   8.871  1.00  0.00           H  
ATOM    399  HA  TYR A  27      30.180  61.024   6.028  1.00  0.00           H  
ATOM    400  HB2 TYR A  27      28.083  60.028   7.965  1.00  0.00           H  
ATOM    401  HB3 TYR A  27      28.030  59.779   6.224  1.00  0.00           H  
ATOM    402  HD1 TYR A  27      30.878  59.156   5.672  1.00  0.00           H  
ATOM    403  HD2 TYR A  27      28.328  57.868   8.825  1.00  0.00           H  
ATOM    404  HE1 TYR A  27      32.224  57.112   5.919  1.00  0.00           H  
ATOM    405  HE2 TYR A  27      29.667  55.822   9.082  1.00  0.00           H  
ATOM    406  HH  TYR A  27      32.681  55.437   7.886  1.00  0.00           H  
ATOM    407  N   ARG A  28      28.280  62.544   5.298  1.00  0.00           N  
ATOM    408  CA  ARG A  28      27.416  63.642   4.881  1.00  0.00           C  
ATOM    409  C   ARG A  28      26.093  63.612   5.642  1.00  0.00           C  
ATOM    410  O   ARG A  28      25.626  62.551   6.053  1.00  0.00           O  
ATOM    411  CB  ARG A  28      27.152  63.567   3.376  1.00  0.00           C  
ATOM    412  CG  ARG A  28      26.662  64.875   2.777  1.00  0.00           C  
ATOM    413  CD  ARG A  28      27.822  65.751   2.329  1.00  0.00           C  
ATOM    414  NE  ARG A  28      27.377  66.864   1.495  1.00  0.00           N  
ATOM    415  CZ  ARG A  28      26.872  66.711   0.276  1.00  0.00           C  
ATOM    416  NH1 ARG A  28      26.747  65.500  -0.247  1.00  0.00           N  
ATOM    417  NH2 ARG A  28      26.490  67.773  -0.422  1.00  0.00           N  
ATOM    418  H   ARG A  28      28.628  61.926   4.622  1.00  0.00           H  
ATOM    419  HA  ARG A  28      27.924  64.568   5.103  1.00  0.00           H  
ATOM    420  HB2 ARG A  28      28.067  63.287   2.875  1.00  0.00           H  
ATOM    421  HB3 ARG A  28      26.404  62.810   3.191  1.00  0.00           H  
ATOM    422  HG2 ARG A  28      26.038  64.660   1.923  1.00  0.00           H  
ATOM    423  HG3 ARG A  28      26.087  65.407   3.521  1.00  0.00           H  
ATOM    424  HD2 ARG A  28      28.316  66.145   3.206  1.00  0.00           H  
ATOM    425  HD3 ARG A  28      28.516  65.145   1.767  1.00  0.00           H  
ATOM    426  HE  ARG A  28      27.460  67.768   1.862  1.00  0.00           H  
ATOM    427 HH11 ARG A  28      27.034  64.698   0.277  1.00  0.00           H  
ATOM    428 HH12 ARG A  28      26.365  65.388  -1.165  1.00  0.00           H  
ATOM    429 HH21 ARG A  28      26.582  68.689  -0.031  1.00  0.00           H  
ATOM    430 HH22 ARG A  28      26.109  67.657  -1.339  1.00  0.00           H  
ATOM    431  N   ALA A  29      25.496  64.785   5.826  1.00  0.00           N  
ATOM    432  CA  ALA A  29      24.229  64.894   6.536  1.00  0.00           C  
ATOM    433  C   ALA A  29      23.649  66.299   6.414  1.00  0.00           C  
ATOM    434  O   ALA A  29      24.206  67.151   5.722  1.00  0.00           O  
ATOM    435  CB  ALA A  29      24.410  64.522   8.000  1.00  0.00           C  
ATOM    436  H   ALA A  29      25.919  65.597   5.476  1.00  0.00           H  
ATOM    437  HA  ALA A  29      23.537  64.191   6.095  1.00  0.00           H  
ATOM    438  HB1 ALA A  29      24.964  63.597   8.070  1.00  0.00           H  
ATOM    439  HB2 ALA A  29      24.953  65.306   8.507  1.00  0.00           H  
ATOM    440  HB3 ALA A  29      23.442  64.397   8.463  1.00  0.00           H  
ATOM    441  N   GLU A  30      22.527  66.532   7.087  1.00  0.00           N  
ATOM    442  CA  GLU A  30      21.872  67.835   7.051  1.00  0.00           C  
ATOM    443  C   GLU A  30      21.195  68.141   8.385  1.00  0.00           C  
ATOM    444  O   GLU A  30      20.375  67.361   8.870  1.00  0.00           O  
ATOM    445  CB  GLU A  30      20.842  67.881   5.921  1.00  0.00           C  
ATOM    446  CG  GLU A  30      19.951  69.111   5.960  1.00  0.00           C  
ATOM    447  CD  GLU A  30      18.790  68.961   6.923  1.00  0.00           C  
ATOM    448  OE1 GLU A  30      18.385  67.810   7.189  1.00  0.00           O  
ATOM    449  OE2 GLU A  30      18.287  69.994   7.413  1.00  0.00           O  
ATOM    450  H   GLU A  30      22.130  65.813   7.622  1.00  0.00           H  
ATOM    451  HA  GLU A  30      22.629  68.582   6.867  1.00  0.00           H  
ATOM    452  HB2 GLU A  30      21.362  67.868   4.975  1.00  0.00           H  
ATOM    453  HB3 GLU A  30      20.213  67.005   5.988  1.00  0.00           H  
ATOM    454  HG2 GLU A  30      20.544  69.960   6.265  1.00  0.00           H  
ATOM    455  HG3 GLU A  30      19.557  69.286   4.970  1.00  0.00           H  
ATOM    456  N   VAL A  31      21.545  69.281   8.972  1.00  0.00           N  
ATOM    457  CA  VAL A  31      20.972  69.691  10.248  1.00  0.00           C  
ATOM    458  C   VAL A  31      19.449  69.705  10.187  1.00  0.00           C  
ATOM    459  O   VAL A  31      18.848  70.649   9.674  1.00  0.00           O  
ATOM    460  CB  VAL A  31      21.472  71.087  10.664  1.00  0.00           C  
ATOM    461  CG1 VAL A  31      20.750  71.561  11.917  1.00  0.00           C  
ATOM    462  CG2 VAL A  31      22.977  71.072  10.880  1.00  0.00           C  
ATOM    463  H   VAL A  31      22.204  69.860   8.536  1.00  0.00           H  
ATOM    464  HA  VAL A  31      21.286  68.981  10.999  1.00  0.00           H  
ATOM    465  HB  VAL A  31      21.251  71.780   9.865  1.00  0.00           H  
ATOM    466 HG11 VAL A  31      21.359  72.292  12.428  1.00  0.00           H  
ATOM    467 HG12 VAL A  31      19.805  72.006  11.642  1.00  0.00           H  
ATOM    468 HG13 VAL A  31      20.576  70.719  12.571  1.00  0.00           H  
ATOM    469 HG21 VAL A  31      23.453  71.691  10.134  1.00  0.00           H  
ATOM    470 HG22 VAL A  31      23.205  71.456  11.864  1.00  0.00           H  
ATOM    471 HG23 VAL A  31      23.343  70.060  10.795  1.00  0.00           H  
ATOM    472  N   GLU A  32      18.831  68.654  10.715  1.00  0.00           N  
ATOM    473  CA  GLU A  32      17.377  68.546  10.720  1.00  0.00           C  
ATOM    474  C   GLU A  32      16.762  69.529  11.712  1.00  0.00           C  
ATOM    475  O   GLU A  32      15.856  70.288  11.368  1.00  0.00           O  
ATOM    476  CB  GLU A  32      16.950  67.118  11.071  1.00  0.00           C  
ATOM    477  CG  GLU A  32      15.554  66.765  10.589  1.00  0.00           C  
ATOM    478  CD  GLU A  32      14.472  67.534  11.322  1.00  0.00           C  
ATOM    479  OE1 GLU A  32      14.688  67.886  12.500  1.00  0.00           O  
ATOM    480  OE2 GLU A  32      13.409  67.786  10.716  1.00  0.00           O  
ATOM    481  H   GLU A  32      19.366  67.933  11.110  1.00  0.00           H  
ATOM    482  HA  GLU A  32      17.024  68.783   9.728  1.00  0.00           H  
ATOM    483  HB2 GLU A  32      17.649  66.426  10.623  1.00  0.00           H  
ATOM    484  HB3 GLU A  32      16.979  67.001  12.144  1.00  0.00           H  
ATOM    485  HG2 GLU A  32      15.482  66.989   9.535  1.00  0.00           H  
ATOM    486  HG3 GLU A  32      15.389  65.708  10.742  1.00  0.00           H  
ATOM    487  N   ALA A  33      17.261  69.510  12.943  1.00  0.00           N  
ATOM    488  CA  ALA A  33      16.762  70.400  13.984  1.00  0.00           C  
ATOM    489  C   ALA A  33      17.691  70.405  15.193  1.00  0.00           C  
ATOM    490  O   ALA A  33      18.135  69.352  15.653  1.00  0.00           O  
ATOM    491  CB  ALA A  33      15.356  69.993  14.398  1.00  0.00           C  
ATOM    492  H   ALA A  33      17.983  68.882  13.156  1.00  0.00           H  
ATOM    493  HA  ALA A  33      16.716  71.399  13.574  1.00  0.00           H  
ATOM    494  HB1 ALA A  33      14.982  70.691  15.131  1.00  0.00           H  
ATOM    495  HB2 ALA A  33      14.711  69.998  13.532  1.00  0.00           H  
ATOM    496  HB3 ALA A  33      15.379  69.001  14.824  1.00  0.00           H  
ATOM    497  N   LEU A  34      17.982  71.596  15.704  1.00  0.00           N  
ATOM    498  CA  LEU A  34      18.859  71.739  16.860  1.00  0.00           C  
ATOM    499  C   LEU A  34      18.109  71.440  18.154  1.00  0.00           C  
ATOM    500  O   LEU A  34      16.884  71.305  18.157  1.00  0.00           O  
ATOM    501  CB  LEU A  34      19.444  73.151  16.912  1.00  0.00           C  
ATOM    502  CG  LEU A  34      20.103  73.652  15.626  1.00  0.00           C  
ATOM    503  CD1 LEU A  34      20.047  75.170  15.554  1.00  0.00           C  
ATOM    504  CD2 LEU A  34      21.542  73.165  15.541  1.00  0.00           C  
ATOM    505  H   LEU A  34      17.599  72.399  15.295  1.00  0.00           H  
ATOM    506  HA  LEU A  34      19.666  71.028  16.754  1.00  0.00           H  
ATOM    507  HB2 LEU A  34      18.643  73.831  17.159  1.00  0.00           H  
ATOM    508  HB3 LEU A  34      20.187  73.174  17.696  1.00  0.00           H  
ATOM    509  HG  LEU A  34      19.564  73.259  14.776  1.00  0.00           H  
ATOM    510 HD11 LEU A  34      20.904  75.537  15.010  1.00  0.00           H  
ATOM    511 HD12 LEU A  34      20.053  75.579  16.554  1.00  0.00           H  
ATOM    512 HD13 LEU A  34      19.142  75.474  15.048  1.00  0.00           H  
ATOM    513 HD21 LEU A  34      21.677  72.601  14.629  1.00  0.00           H  
ATOM    514 HD22 LEU A  34      21.759  72.535  16.390  1.00  0.00           H  
ATOM    515 HD23 LEU A  34      22.210  74.014  15.542  1.00  0.00           H  
ATOM    516  N   HIS A  35      18.850  71.338  19.253  1.00  0.00           N  
ATOM    517  CA  HIS A  35      18.254  71.058  20.555  1.00  0.00           C  
ATOM    518  C   HIS A  35      18.206  72.317  21.413  1.00  0.00           C  
ATOM    519  O   HIS A  35      19.213  73.006  21.578  1.00  0.00           O  
ATOM    520  CB  HIS A  35      19.042  69.964  21.275  1.00  0.00           C  
ATOM    521  CG  HIS A  35      18.406  69.509  22.552  1.00  0.00           C  
ATOM    522  ND1 HIS A  35      19.132  69.107  23.653  1.00  0.00           N  
ATOM    523  CD2 HIS A  35      17.102  69.397  22.902  1.00  0.00           C  
ATOM    524  CE1 HIS A  35      18.302  68.765  24.623  1.00  0.00           C  
ATOM    525  NE2 HIS A  35      17.066  68.933  24.193  1.00  0.00           N  
ATOM    526  H   HIS A  35      19.820  71.456  19.188  1.00  0.00           H  
ATOM    527  HA  HIS A  35      17.245  70.713  20.389  1.00  0.00           H  
ATOM    528  HB2 HIS A  35      19.131  69.106  20.625  1.00  0.00           H  
ATOM    529  HB3 HIS A  35      20.029  70.336  21.510  1.00  0.00           H  
ATOM    530  HD1 HIS A  35      20.108  69.075  23.715  1.00  0.00           H  
ATOM    531  HD2 HIS A  35      16.249  69.629  22.280  1.00  0.00           H  
ATOM    532  HE1 HIS A  35      18.587  68.410  25.602  1.00  0.00           H  
ATOM    533  HE2 HIS A  35      16.258  68.672  24.682  1.00  0.00           H  
ATOM    534  N   SER A  36      17.031  72.613  21.958  1.00  0.00           N  
ATOM    535  CA  SER A  36      16.851  73.793  22.797  1.00  0.00           C  
ATOM    536  C   SER A  36      18.044  73.983  23.729  1.00  0.00           C  
ATOM    537  O   SER A  36      18.649  75.054  23.771  1.00  0.00           O  
ATOM    538  CB  SER A  36      15.564  73.672  23.615  1.00  0.00           C  
ATOM    539  OG  SER A  36      15.699  72.701  24.637  1.00  0.00           O  
ATOM    540  H   SER A  36      16.265  72.025  21.790  1.00  0.00           H  
ATOM    541  HA  SER A  36      16.776  74.652  22.147  1.00  0.00           H  
ATOM    542  HB2 SER A  36      15.339  74.626  24.067  1.00  0.00           H  
ATOM    543  HB3 SER A  36      14.753  73.382  22.963  1.00  0.00           H  
ATOM    544  HG  SER A  36      15.435  71.842  24.300  1.00  0.00           H  
ATOM    545  N   SER A  37      18.377  72.935  24.475  1.00  0.00           N  
ATOM    546  CA  SER A  37      19.494  72.986  25.411  1.00  0.00           C  
ATOM    547  C   SER A  37      20.716  73.630  24.762  1.00  0.00           C  
ATOM    548  O   SER A  37      21.243  74.625  25.258  1.00  0.00           O  
ATOM    549  CB  SER A  37      19.844  71.579  25.898  1.00  0.00           C  
ATOM    550  OG  SER A  37      18.822  71.059  26.730  1.00  0.00           O  
ATOM    551  H   SER A  37      17.856  72.108  24.397  1.00  0.00           H  
ATOM    552  HA  SER A  37      19.191  73.585  26.256  1.00  0.00           H  
ATOM    553  HB2 SER A  37      19.965  70.926  25.047  1.00  0.00           H  
ATOM    554  HB3 SER A  37      20.766  71.614  26.459  1.00  0.00           H  
ATOM    555  HG  SER A  37      18.335  71.783  27.132  1.00  0.00           H  
ATOM    556  N   GLY A  38      21.161  73.054  23.650  1.00  0.00           N  
ATOM    557  CA  GLY A  38      22.317  73.585  22.951  1.00  0.00           C  
ATOM    558  C   GLY A  38      23.523  72.673  23.050  1.00  0.00           C  
ATOM    559  O   GLY A  38      24.642  73.133  23.271  1.00  0.00           O  
ATOM    560  H   GLY A  38      20.700  72.263  23.300  1.00  0.00           H  
ATOM    561  HA2 GLY A  38      22.065  73.718  21.910  1.00  0.00           H  
ATOM    562  HA3 GLY A  38      22.570  74.545  23.376  1.00  0.00           H  
ATOM    563  N   MET A  39      23.295  71.373  22.889  1.00  0.00           N  
ATOM    564  CA  MET A  39      24.373  70.393  22.962  1.00  0.00           C  
ATOM    565  C   MET A  39      24.309  69.425  21.786  1.00  0.00           C  
ATOM    566  O   MET A  39      25.271  69.285  21.029  1.00  0.00           O  
ATOM    567  CB  MET A  39      24.299  69.619  24.280  1.00  0.00           C  
ATOM    568  CG  MET A  39      24.935  70.350  25.451  1.00  0.00           C  
ATOM    569  SD  MET A  39      26.688  69.970  25.639  1.00  0.00           S  
ATOM    570  CE  MET A  39      26.623  68.687  26.886  1.00  0.00           C  
ATOM    571  H   MET A  39      22.381  71.064  22.716  1.00  0.00           H  
ATOM    572  HA  MET A  39      25.310  70.929  22.922  1.00  0.00           H  
ATOM    573  HB2 MET A  39      23.262  69.436  24.519  1.00  0.00           H  
ATOM    574  HB3 MET A  39      24.805  68.673  24.157  1.00  0.00           H  
ATOM    575  HG2 MET A  39      24.828  71.414  25.296  1.00  0.00           H  
ATOM    576  HG3 MET A  39      24.420  70.067  26.357  1.00  0.00           H  
ATOM    577  HE1 MET A  39      27.581  68.617  27.381  1.00  0.00           H  
ATOM    578  HE2 MET A  39      25.861  68.929  27.612  1.00  0.00           H  
ATOM    579  HE3 MET A  39      26.389  67.742  26.419  1.00  0.00           H  
ATOM    580  N   THR A  40      23.170  68.756  21.637  1.00  0.00           N  
ATOM    581  CA  THR A  40      22.980  67.800  20.554  1.00  0.00           C  
ATOM    582  C   THR A  40      21.969  68.314  19.536  1.00  0.00           C  
ATOM    583  O   THR A  40      21.205  69.237  19.818  1.00  0.00           O  
ATOM    584  CB  THR A  40      22.506  66.435  21.086  1.00  0.00           C  
ATOM    585  OG1 THR A  40      21.395  66.613  21.972  1.00  0.00           O  
ATOM    586  CG2 THR A  40      23.633  65.717  21.815  1.00  0.00           C  
ATOM    587  H   THR A  40      22.440  68.910  22.272  1.00  0.00           H  
ATOM    588  HA  THR A  40      23.932  67.660  20.063  1.00  0.00           H  
ATOM    589  HB  THR A  40      22.194  65.827  20.248  1.00  0.00           H  
ATOM    590  HG1 THR A  40      21.141  65.764  22.341  1.00  0.00           H  
ATOM    591 HG21 THR A  40      24.353  65.356  21.097  1.00  0.00           H  
ATOM    592 HG22 THR A  40      23.228  64.883  22.370  1.00  0.00           H  
ATOM    593 HG23 THR A  40      24.114  66.402  22.494  1.00  0.00           H  
ATOM    594  N   ALA A  41      21.968  67.711  18.351  1.00  0.00           N  
ATOM    595  CA  ALA A  41      21.049  68.107  17.293  1.00  0.00           C  
ATOM    596  C   ALA A  41      20.716  66.928  16.384  1.00  0.00           C  
ATOM    597  O   ALA A  41      21.531  66.024  16.203  1.00  0.00           O  
ATOM    598  CB  ALA A  41      21.639  69.252  16.482  1.00  0.00           C  
ATOM    599  H   ALA A  41      22.602  66.981  18.187  1.00  0.00           H  
ATOM    600  HA  ALA A  41      20.138  68.460  17.756  1.00  0.00           H  
ATOM    601  HB1 ALA A  41      22.562  68.927  16.023  1.00  0.00           H  
ATOM    602  HB2 ALA A  41      20.940  69.547  15.714  1.00  0.00           H  
ATOM    603  HB3 ALA A  41      21.835  70.090  17.132  1.00  0.00           H  
ATOM    604  N   VAL A  42      19.515  66.945  15.817  1.00  0.00           N  
ATOM    605  CA  VAL A  42      19.075  65.877  14.928  1.00  0.00           C  
ATOM    606  C   VAL A  42      19.533  66.131  13.496  1.00  0.00           C  
ATOM    607  O   VAL A  42      19.076  67.070  12.843  1.00  0.00           O  
ATOM    608  CB  VAL A  42      17.542  65.728  14.945  1.00  0.00           C  
ATOM    609  CG1 VAL A  42      17.108  64.565  14.064  1.00  0.00           C  
ATOM    610  CG2 VAL A  42      17.041  65.543  16.369  1.00  0.00           C  
ATOM    611  H   VAL A  42      18.909  67.693  16.001  1.00  0.00           H  
ATOM    612  HA  VAL A  42      19.510  64.952  15.276  1.00  0.00           H  
ATOM    613  HB  VAL A  42      17.108  66.633  14.547  1.00  0.00           H  
ATOM    614 HG11 VAL A  42      17.914  64.301  13.395  1.00  0.00           H  
ATOM    615 HG12 VAL A  42      16.859  63.716  14.684  1.00  0.00           H  
ATOM    616 HG13 VAL A  42      16.243  64.856  13.486  1.00  0.00           H  
ATOM    617 HG21 VAL A  42      17.879  65.353  17.023  1.00  0.00           H  
ATOM    618 HG22 VAL A  42      16.530  66.439  16.691  1.00  0.00           H  
ATOM    619 HG23 VAL A  42      16.359  64.707  16.407  1.00  0.00           H  
ATOM    620  N   VAL A  43      20.439  65.287  13.011  1.00  0.00           N  
ATOM    621  CA  VAL A  43      20.958  65.418  11.656  1.00  0.00           C  
ATOM    622  C   VAL A  43      20.578  64.214  10.802  1.00  0.00           C  
ATOM    623  O   VAL A  43      20.650  63.070  11.253  1.00  0.00           O  
ATOM    624  CB  VAL A  43      22.491  65.570  11.655  1.00  0.00           C  
ATOM    625  CG1 VAL A  43      22.912  66.752  12.514  1.00  0.00           C  
ATOM    626  CG2 VAL A  43      23.153  64.287  12.136  1.00  0.00           C  
ATOM    627  H   VAL A  43      20.764  64.557  13.579  1.00  0.00           H  
ATOM    628  HA  VAL A  43      20.529  66.307  11.219  1.00  0.00           H  
ATOM    629  HB  VAL A  43      22.814  65.758  10.641  1.00  0.00           H  
ATOM    630 HG11 VAL A  43      23.061  66.421  13.532  1.00  0.00           H  
ATOM    631 HG12 VAL A  43      23.832  67.167  12.131  1.00  0.00           H  
ATOM    632 HG13 VAL A  43      22.139  67.506  12.492  1.00  0.00           H  
ATOM    633 HG21 VAL A  43      23.883  64.524  12.897  1.00  0.00           H  
ATOM    634 HG22 VAL A  43      22.404  63.627  12.548  1.00  0.00           H  
ATOM    635 HG23 VAL A  43      23.644  63.801  11.306  1.00  0.00           H  
ATOM    636  N   LYS A  44      20.170  64.478   9.565  1.00  0.00           N  
ATOM    637  CA  LYS A  44      19.779  63.417   8.645  1.00  0.00           C  
ATOM    638  C   LYS A  44      20.966  62.959   7.805  1.00  0.00           C  
ATOM    639  O   LYS A  44      21.631  63.768   7.159  1.00  0.00           O  
ATOM    640  CB  LYS A  44      18.649  63.897   7.731  1.00  0.00           C  
ATOM    641  CG  LYS A  44      18.048  62.794   6.877  1.00  0.00           C  
ATOM    642  CD  LYS A  44      16.677  63.183   6.349  1.00  0.00           C  
ATOM    643  CE  LYS A  44      16.307  62.377   5.114  1.00  0.00           C  
ATOM    644  NZ  LYS A  44      17.041  62.843   3.905  1.00  0.00           N  
ATOM    645  H   LYS A  44      20.133  65.410   9.263  1.00  0.00           H  
ATOM    646  HA  LYS A  44      19.425  62.583   9.232  1.00  0.00           H  
ATOM    647  HB2 LYS A  44      17.865  64.320   8.340  1.00  0.00           H  
ATOM    648  HB3 LYS A  44      19.035  64.663   7.074  1.00  0.00           H  
ATOM    649  HG2 LYS A  44      18.702  62.601   6.040  1.00  0.00           H  
ATOM    650  HG3 LYS A  44      17.952  61.900   7.475  1.00  0.00           H  
ATOM    651  HD2 LYS A  44      15.940  63.003   7.117  1.00  0.00           H  
ATOM    652  HD3 LYS A  44      16.684  64.233   6.093  1.00  0.00           H  
ATOM    653  HE2 LYS A  44      16.545  61.340   5.292  1.00  0.00           H  
ATOM    654  HE3 LYS A  44      15.244  62.476   4.940  1.00  0.00           H  
ATOM    655  HZ1 LYS A  44      16.699  63.783   3.621  1.00  0.00           H  
ATOM    656  HZ2 LYS A  44      16.892  62.180   3.119  1.00  0.00           H  
ATOM    657  HZ3 LYS A  44      18.059  62.903   4.106  1.00  0.00           H  
ATOM    658  N   PHE A  45      21.227  61.656   7.817  1.00  0.00           N  
ATOM    659  CA  PHE A  45      22.335  61.090   7.057  1.00  0.00           C  
ATOM    660  C   PHE A  45      21.909  60.780   5.624  1.00  0.00           C  
ATOM    661  O   PHE A  45      20.908  60.099   5.396  1.00  0.00           O  
ATOM    662  CB  PHE A  45      22.851  59.818   7.734  1.00  0.00           C  
ATOM    663  CG  PHE A  45      23.855  60.083   8.820  1.00  0.00           C  
ATOM    664  CD1 PHE A  45      25.110  60.584   8.513  1.00  0.00           C  
ATOM    665  CD2 PHE A  45      23.543  59.830  10.146  1.00  0.00           C  
ATOM    666  CE1 PHE A  45      26.036  60.829   9.511  1.00  0.00           C  
ATOM    667  CE2 PHE A  45      24.466  60.073  11.146  1.00  0.00           C  
ATOM    668  CZ  PHE A  45      25.713  60.572  10.828  1.00  0.00           C  
ATOM    669  H   PHE A  45      20.661  61.060   8.353  1.00  0.00           H  
ATOM    670  HA  PHE A  45      23.127  61.822   7.033  1.00  0.00           H  
ATOM    671  HB2 PHE A  45      22.018  59.290   8.174  1.00  0.00           H  
ATOM    672  HB3 PHE A  45      23.320  59.189   6.993  1.00  0.00           H  
ATOM    673  HD1 PHE A  45      25.364  60.785   7.482  1.00  0.00           H  
ATOM    674  HD2 PHE A  45      22.568  59.439  10.397  1.00  0.00           H  
ATOM    675  HE1 PHE A  45      27.011  61.219   9.258  1.00  0.00           H  
ATOM    676  HE2 PHE A  45      24.210  59.871  12.176  1.00  0.00           H  
ATOM    677  HZ  PHE A  45      26.435  60.763  11.608  1.00  0.00           H  
ATOM    678  N   THR A  46      22.674  61.284   4.662  1.00  0.00           N  
ATOM    679  CA  THR A  46      22.376  61.064   3.253  1.00  0.00           C  
ATOM    680  C   THR A  46      22.564  59.599   2.874  1.00  0.00           C  
ATOM    681  O   THR A  46      21.826  59.062   2.047  1.00  0.00           O  
ATOM    682  CB  THR A  46      23.269  61.934   2.347  1.00  0.00           C  
ATOM    683  OG1 THR A  46      22.662  62.080   1.059  1.00  0.00           O  
ATOM    684  CG2 THR A  46      24.651  61.318   2.195  1.00  0.00           C  
ATOM    685  H   THR A  46      23.459  61.819   4.908  1.00  0.00           H  
ATOM    686  HA  THR A  46      21.346  61.341   3.083  1.00  0.00           H  
ATOM    687  HB  THR A  46      23.373  62.909   2.801  1.00  0.00           H  
ATOM    688  HG1 THR A  46      22.972  62.892   0.649  1.00  0.00           H  
ATOM    689 HG21 THR A  46      25.131  61.268   3.162  1.00  0.00           H  
ATOM    690 HG22 THR A  46      25.244  61.925   1.529  1.00  0.00           H  
ATOM    691 HG23 THR A  46      24.557  60.322   1.789  1.00  0.00           H  
ATOM    692  N   ASP A  47      23.554  58.957   3.485  1.00  0.00           N  
ATOM    693  CA  ASP A  47      23.836  57.552   3.213  1.00  0.00           C  
ATOM    694  C   ASP A  47      22.548  56.783   2.933  1.00  0.00           C  
ATOM    695  O   ASP A  47      22.467  56.017   1.972  1.00  0.00           O  
ATOM    696  CB  ASP A  47      24.575  56.921   4.394  1.00  0.00           C  
ATOM    697  CG  ASP A  47      25.969  57.489   4.574  1.00  0.00           C  
ATOM    698  OD1 ASP A  47      26.644  57.742   3.554  1.00  0.00           O  
ATOM    699  OD2 ASP A  47      26.385  57.681   5.737  1.00  0.00           O  
ATOM    700  H   ASP A  47      24.107  59.438   4.135  1.00  0.00           H  
ATOM    701  HA  ASP A  47      24.467  57.504   2.338  1.00  0.00           H  
ATOM    702  HB2 ASP A  47      24.014  57.099   5.299  1.00  0.00           H  
ATOM    703  HB3 ASP A  47      24.659  55.856   4.230  1.00  0.00           H  
ATOM    704  N   TYR A  48      21.546  56.990   3.778  1.00  0.00           N  
ATOM    705  CA  TYR A  48      20.263  56.314   3.624  1.00  0.00           C  
ATOM    706  C   TYR A  48      19.108  57.302   3.752  1.00  0.00           C  
ATOM    707  O   TYR A  48      18.123  57.221   3.019  1.00  0.00           O  
ATOM    708  CB  TYR A  48      20.119  55.206   4.668  1.00  0.00           C  
ATOM    709  CG  TYR A  48      21.380  54.397   4.870  1.00  0.00           C  
ATOM    710  CD1 TYR A  48      21.652  53.288   4.079  1.00  0.00           C  
ATOM    711  CD2 TYR A  48      22.299  54.740   5.855  1.00  0.00           C  
ATOM    712  CE1 TYR A  48      22.803  52.545   4.260  1.00  0.00           C  
ATOM    713  CE2 TYR A  48      23.452  54.004   6.043  1.00  0.00           C  
ATOM    714  CZ  TYR A  48      23.700  52.908   5.244  1.00  0.00           C  
ATOM    715  OH  TYR A  48      24.848  52.171   5.428  1.00  0.00           O  
ATOM    716  H   TYR A  48      21.671  57.613   4.526  1.00  0.00           H  
ATOM    717  HA  TYR A  48      20.237  55.873   2.639  1.00  0.00           H  
ATOM    718  HB2 TYR A  48      19.852  55.646   5.617  1.00  0.00           H  
ATOM    719  HB3 TYR A  48      19.336  54.529   4.359  1.00  0.00           H  
ATOM    720  HD1 TYR A  48      20.948  53.007   3.309  1.00  0.00           H  
ATOM    721  HD2 TYR A  48      22.102  55.599   6.480  1.00  0.00           H  
ATOM    722  HE1 TYR A  48      22.998  51.687   3.634  1.00  0.00           H  
ATOM    723  HE2 TYR A  48      24.155  54.287   6.813  1.00  0.00           H  
ATOM    724  HH  TYR A  48      24.658  51.420   5.995  1.00  0.00           H  
ATOM    725  N   GLY A  49      19.237  58.236   4.689  1.00  0.00           N  
ATOM    726  CA  GLY A  49      18.197  59.228   4.897  1.00  0.00           C  
ATOM    727  C   GLY A  49      17.498  59.063   6.232  1.00  0.00           C  
ATOM    728  O   GLY A  49      16.297  59.305   6.345  1.00  0.00           O  
ATOM    729  H   GLY A  49      20.044  58.253   5.244  1.00  0.00           H  
ATOM    730  HA2 GLY A  49      18.639  60.211   4.852  1.00  0.00           H  
ATOM    731  HA3 GLY A  49      17.466  59.136   4.107  1.00  0.00           H  
ATOM    732  N   ASN A  50      18.252  58.651   7.246  1.00  0.00           N  
ATOM    733  CA  ASN A  50      17.696  58.452   8.580  1.00  0.00           C  
ATOM    734  C   ASN A  50      18.243  59.488   9.556  1.00  0.00           C  
ATOM    735  O   ASN A  50      19.377  59.948   9.420  1.00  0.00           O  
ATOM    736  CB  ASN A  50      18.014  57.043   9.083  1.00  0.00           C  
ATOM    737  CG  ASN A  50      19.445  56.634   8.793  1.00  0.00           C  
ATOM    738  OD1 ASN A  50      19.704  55.839   7.889  1.00  0.00           O  
ATOM    739  ND2 ASN A  50      20.382  57.179   9.559  1.00  0.00           N  
ATOM    740  H   ASN A  50      19.203  58.474   7.094  1.00  0.00           H  
ATOM    741  HA  ASN A  50      16.624  58.568   8.513  1.00  0.00           H  
ATOM    742  HB2 ASN A  50      17.859  57.005  10.151  1.00  0.00           H  
ATOM    743  HB3 ASN A  50      17.352  56.337   8.602  1.00  0.00           H  
ATOM    744 HD21 ASN A  50      20.103  57.804  10.260  1.00  0.00           H  
ATOM    745 HD22 ASN A  50      21.316  56.933   9.393  1.00  0.00           H  
ATOM    746  N   TYR A  51      17.429  59.852  10.542  1.00  0.00           N  
ATOM    747  CA  TYR A  51      17.830  60.836  11.541  1.00  0.00           C  
ATOM    748  C   TYR A  51      18.655  60.184  12.646  1.00  0.00           C  
ATOM    749  O   TYR A  51      18.438  59.024  12.995  1.00  0.00           O  
ATOM    750  CB  TYR A  51      16.599  61.516  12.141  1.00  0.00           C  
ATOM    751  CG  TYR A  51      15.687  62.137  11.107  1.00  0.00           C  
ATOM    752  CD1 TYR A  51      16.137  63.156  10.277  1.00  0.00           C  
ATOM    753  CD2 TYR A  51      14.374  61.704  10.961  1.00  0.00           C  
ATOM    754  CE1 TYR A  51      15.306  63.726   9.333  1.00  0.00           C  
ATOM    755  CE2 TYR A  51      13.537  62.268  10.018  1.00  0.00           C  
ATOM    756  CZ  TYR A  51      14.007  63.280   9.206  1.00  0.00           C  
ATOM    757  OH  TYR A  51      13.177  63.845   8.265  1.00  0.00           O  
ATOM    758  H   TYR A  51      16.537  59.451  10.597  1.00  0.00           H  
ATOM    759  HA  TYR A  51      18.436  61.582  11.047  1.00  0.00           H  
ATOM    760  HB2 TYR A  51      16.026  60.786  12.692  1.00  0.00           H  
ATOM    761  HB3 TYR A  51      16.920  62.298  12.814  1.00  0.00           H  
ATOM    762  HD1 TYR A  51      17.154  63.503  10.378  1.00  0.00           H  
ATOM    763  HD2 TYR A  51      14.008  60.912  11.598  1.00  0.00           H  
ATOM    764  HE1 TYR A  51      15.674  64.519   8.696  1.00  0.00           H  
ATOM    765  HE2 TYR A  51      12.519  61.918   9.919  1.00  0.00           H  
ATOM    766  HH  TYR A  51      12.479  64.333   8.707  1.00  0.00           H  
ATOM    767  N   GLU A  52      19.601  60.939  13.194  1.00  0.00           N  
ATOM    768  CA  GLU A  52      20.459  60.435  14.260  1.00  0.00           C  
ATOM    769  C   GLU A  52      20.853  61.556  15.218  1.00  0.00           C  
ATOM    770  O   GLU A  52      21.209  62.654  14.791  1.00  0.00           O  
ATOM    771  CB  GLU A  52      21.715  59.787  13.673  1.00  0.00           C  
ATOM    772  CG  GLU A  52      21.522  58.332  13.281  1.00  0.00           C  
ATOM    773  CD  GLU A  52      21.070  57.471  14.445  1.00  0.00           C  
ATOM    774  OE1 GLU A  52      21.564  57.690  15.571  1.00  0.00           O  
ATOM    775  OE2 GLU A  52      20.225  56.578  14.230  1.00  0.00           O  
ATOM    776  H   GLU A  52      19.727  61.857  12.873  1.00  0.00           H  
ATOM    777  HA  GLU A  52      19.903  59.690  14.808  1.00  0.00           H  
ATOM    778  HB2 GLU A  52      22.011  60.339  12.793  1.00  0.00           H  
ATOM    779  HB3 GLU A  52      22.507  59.840  14.403  1.00  0.00           H  
ATOM    780  HG2 GLU A  52      20.776  58.277  12.503  1.00  0.00           H  
ATOM    781  HG3 GLU A  52      22.459  57.946  12.910  1.00  0.00           H  
ATOM    782  N   GLU A  53      20.784  61.271  16.514  1.00  0.00           N  
ATOM    783  CA  GLU A  53      21.131  62.256  17.532  1.00  0.00           C  
ATOM    784  C   GLU A  53      22.644  62.342  17.711  1.00  0.00           C  
ATOM    785  O   GLU A  53      23.266  61.443  18.280  1.00  0.00           O  
ATOM    786  CB  GLU A  53      20.468  61.901  18.864  1.00  0.00           C  
ATOM    787  CG  GLU A  53      20.583  62.996  19.912  1.00  0.00           C  
ATOM    788  CD  GLU A  53      19.832  62.664  21.186  1.00  0.00           C  
ATOM    789  OE1 GLU A  53      18.772  62.010  21.097  1.00  0.00           O  
ATOM    790  OE2 GLU A  53      20.302  63.060  22.274  1.00  0.00           O  
ATOM    791  H   GLU A  53      20.492  60.378  16.792  1.00  0.00           H  
ATOM    792  HA  GLU A  53      20.765  63.216  17.203  1.00  0.00           H  
ATOM    793  HB2 GLU A  53      19.420  61.706  18.691  1.00  0.00           H  
ATOM    794  HB3 GLU A  53      20.931  61.007  19.255  1.00  0.00           H  
ATOM    795  HG2 GLU A  53      21.626  63.136  20.154  1.00  0.00           H  
ATOM    796  HG3 GLU A  53      20.183  63.911  19.504  1.00  0.00           H  
ATOM    797  N   VAL A  54      23.232  63.429  17.221  1.00  0.00           N  
ATOM    798  CA  VAL A  54      24.672  63.634  17.327  1.00  0.00           C  
ATOM    799  C   VAL A  54      24.990  64.991  17.944  1.00  0.00           C  
ATOM    800  O   VAL A  54      24.249  65.958  17.761  1.00  0.00           O  
ATOM    801  CB  VAL A  54      25.355  63.535  15.951  1.00  0.00           C  
ATOM    802  CG1 VAL A  54      26.829  63.192  16.110  1.00  0.00           C  
ATOM    803  CG2 VAL A  54      24.652  62.505  15.080  1.00  0.00           C  
ATOM    804  H   VAL A  54      22.684  64.110  16.780  1.00  0.00           H  
ATOM    805  HA  VAL A  54      25.073  62.857  17.963  1.00  0.00           H  
ATOM    806  HB  VAL A  54      25.282  64.497  15.465  1.00  0.00           H  
ATOM    807 HG11 VAL A  54      27.418  64.093  16.026  1.00  0.00           H  
ATOM    808 HG12 VAL A  54      26.992  62.744  17.080  1.00  0.00           H  
ATOM    809 HG13 VAL A  54      27.123  62.498  15.337  1.00  0.00           H  
ATOM    810 HG21 VAL A  54      23.885  62.992  14.497  1.00  0.00           H  
ATOM    811 HG22 VAL A  54      25.369  62.043  14.418  1.00  0.00           H  
ATOM    812 HG23 VAL A  54      24.203  61.749  15.707  1.00  0.00           H  
ATOM    813  N   LEU A  55      26.095  65.057  18.678  1.00  0.00           N  
ATOM    814  CA  LEU A  55      26.514  66.297  19.322  1.00  0.00           C  
ATOM    815  C   LEU A  55      26.948  67.329  18.287  1.00  0.00           C  
ATOM    816  O   LEU A  55      27.428  66.979  17.208  1.00  0.00           O  
ATOM    817  CB  LEU A  55      27.658  66.026  20.300  1.00  0.00           C  
ATOM    818  CG  LEU A  55      27.250  65.691  21.735  1.00  0.00           C  
ATOM    819  CD1 LEU A  55      28.309  64.829  22.404  1.00  0.00           C  
ATOM    820  CD2 LEU A  55      27.013  66.964  22.534  1.00  0.00           C  
ATOM    821  H   LEU A  55      26.645  64.254  18.788  1.00  0.00           H  
ATOM    822  HA  LEU A  55      25.668  66.687  19.869  1.00  0.00           H  
ATOM    823  HB2 LEU A  55      28.231  65.196  19.917  1.00  0.00           H  
ATOM    824  HB3 LEU A  55      28.283  66.908  20.330  1.00  0.00           H  
ATOM    825  HG  LEU A  55      26.326  65.129  21.718  1.00  0.00           H  
ATOM    826 HD11 LEU A  55      28.093  64.748  23.459  1.00  0.00           H  
ATOM    827 HD12 LEU A  55      29.279  65.282  22.269  1.00  0.00           H  
ATOM    828 HD13 LEU A  55      28.305  63.845  21.959  1.00  0.00           H  
ATOM    829 HD21 LEU A  55      27.700  67.729  22.203  1.00  0.00           H  
ATOM    830 HD22 LEU A  55      27.174  66.767  23.583  1.00  0.00           H  
ATOM    831 HD23 LEU A  55      25.999  67.302  22.382  1.00  0.00           H  
ATOM    832  N   LEU A  56      26.780  68.603  18.623  1.00  0.00           N  
ATOM    833  CA  LEU A  56      27.156  69.688  17.723  1.00  0.00           C  
ATOM    834  C   LEU A  56      28.673  69.794  17.602  1.00  0.00           C  
ATOM    835  O   LEU A  56      29.194  70.266  16.592  1.00  0.00           O  
ATOM    836  CB  LEU A  56      26.580  71.014  18.222  1.00  0.00           C  
ATOM    837  CG  LEU A  56      25.056  71.139  18.189  1.00  0.00           C  
ATOM    838  CD1 LEU A  56      24.608  72.394  18.922  1.00  0.00           C  
ATOM    839  CD2 LEU A  56      24.554  71.148  16.754  1.00  0.00           C  
ATOM    840  H   LEU A  56      26.393  68.821  19.497  1.00  0.00           H  
ATOM    841  HA  LEU A  56      26.745  69.470  16.749  1.00  0.00           H  
ATOM    842  HB2 LEU A  56      26.901  71.151  19.243  1.00  0.00           H  
ATOM    843  HB3 LEU A  56      26.991  71.804  17.609  1.00  0.00           H  
ATOM    844  HG  LEU A  56      24.621  70.286  18.691  1.00  0.00           H  
ATOM    845 HD11 LEU A  56      25.413  72.756  19.542  1.00  0.00           H  
ATOM    846 HD12 LEU A  56      23.752  72.164  19.539  1.00  0.00           H  
ATOM    847 HD13 LEU A  56      24.338  73.153  18.202  1.00  0.00           H  
ATOM    848 HD21 LEU A  56      25.395  71.168  16.078  1.00  0.00           H  
ATOM    849 HD22 LEU A  56      23.942  72.024  16.592  1.00  0.00           H  
ATOM    850 HD23 LEU A  56      23.966  70.260  16.572  1.00  0.00           H  
ATOM    851  N   SER A  57      29.377  69.347  18.638  1.00  0.00           N  
ATOM    852  CA  SER A  57      30.834  69.392  18.649  1.00  0.00           C  
ATOM    853  C   SER A  57      31.419  68.296  17.763  1.00  0.00           C  
ATOM    854  O   SER A  57      32.632  68.216  17.575  1.00  0.00           O  
ATOM    855  CB  SER A  57      31.360  69.243  20.078  1.00  0.00           C  
ATOM    856  OG  SER A  57      30.967  70.340  20.884  1.00  0.00           O  
ATOM    857  H   SER A  57      28.903  68.981  19.415  1.00  0.00           H  
ATOM    858  HA  SER A  57      31.139  70.353  18.261  1.00  0.00           H  
ATOM    859  HB2 SER A  57      30.965  68.335  20.510  1.00  0.00           H  
ATOM    860  HB3 SER A  57      32.439  69.193  20.058  1.00  0.00           H  
ATOM    861  HG  SER A  57      30.505  70.018  21.661  1.00  0.00           H  
ATOM    862  N   ASN A  58      30.544  67.454  17.221  1.00  0.00           N  
ATOM    863  CA  ASN A  58      30.972  66.362  16.354  1.00  0.00           C  
ATOM    864  C   ASN A  58      30.471  66.569  14.929  1.00  0.00           C  
ATOM    865  O   ASN A  58      30.287  65.610  14.179  1.00  0.00           O  
ATOM    866  CB  ASN A  58      30.464  65.024  16.896  1.00  0.00           C  
ATOM    867  CG  ASN A  58      30.995  64.724  18.284  1.00  0.00           C  
ATOM    868  OD1 ASN A  58      31.871  65.424  18.791  1.00  0.00           O  
ATOM    869  ND2 ASN A  58      30.464  63.677  18.908  1.00  0.00           N  
ATOM    870  H   ASN A  58      29.590  67.570  17.407  1.00  0.00           H  
ATOM    871  HA  ASN A  58      32.052  66.350  16.345  1.00  0.00           H  
ATOM    872  HB2 ASN A  58      29.385  65.048  16.942  1.00  0.00           H  
ATOM    873  HB3 ASN A  58      30.775  64.232  16.232  1.00  0.00           H  
ATOM    874 HD21 ASN A  58      29.769  63.166  18.442  1.00  0.00           H  
ATOM    875 HD22 ASN A  58      30.788  63.462  19.807  1.00  0.00           H  
ATOM    876  N   ILE A  59      30.250  67.828  14.563  1.00  0.00           N  
ATOM    877  CA  ILE A  59      29.771  68.161  13.226  1.00  0.00           C  
ATOM    878  C   ILE A  59      30.713  69.138  12.533  1.00  0.00           C  
ATOM    879  O   ILE A  59      31.285  70.025  13.168  1.00  0.00           O  
ATOM    880  CB  ILE A  59      28.358  68.772  13.272  1.00  0.00           C  
ATOM    881  CG1 ILE A  59      27.528  68.111  14.376  1.00  0.00           C  
ATOM    882  CG2 ILE A  59      27.671  68.619  11.922  1.00  0.00           C  
ATOM    883  CD1 ILE A  59      26.047  68.400  14.272  1.00  0.00           C  
ATOM    884  H   ILE A  59      30.414  68.548  15.205  1.00  0.00           H  
ATOM    885  HA  ILE A  59      29.728  67.248  12.651  1.00  0.00           H  
ATOM    886  HB  ILE A  59      28.452  69.826  13.483  1.00  0.00           H  
ATOM    887 HG12 ILE A  59      27.662  67.042  14.326  1.00  0.00           H  
ATOM    888 HG13 ILE A  59      27.870  68.470  15.335  1.00  0.00           H  
ATOM    889 HG21 ILE A  59      28.345  68.933  11.139  1.00  0.00           H  
ATOM    890 HG22 ILE A  59      27.401  67.585  11.772  1.00  0.00           H  
ATOM    891 HG23 ILE A  59      26.782  69.232  11.900  1.00  0.00           H  
ATOM    892 HD11 ILE A  59      25.892  69.467  14.206  1.00  0.00           H  
ATOM    893 HD12 ILE A  59      25.647  67.922  13.391  1.00  0.00           H  
ATOM    894 HD13 ILE A  59      25.544  68.018  15.148  1.00  0.00           H  
ATOM    895  N   LYS A  60      30.869  68.972  11.224  1.00  0.00           N  
ATOM    896  CA  LYS A  60      31.741  69.841  10.441  1.00  0.00           C  
ATOM    897  C   LYS A  60      30.978  70.469   9.279  1.00  0.00           C  
ATOM    898  O   LYS A  60      30.131  69.839   8.647  1.00  0.00           O  
ATOM    899  CB  LYS A  60      32.940  69.052   9.911  1.00  0.00           C  
ATOM    900  CG  LYS A  60      33.476  68.027  10.894  1.00  0.00           C  
ATOM    901  CD  LYS A  60      34.134  68.694  12.092  1.00  0.00           C  
ATOM    902  CE  LYS A  60      34.013  67.839  13.343  1.00  0.00           C  
ATOM    903  NZ  LYS A  60      35.151  68.058  14.277  1.00  0.00           N  
ATOM    904  H   LYS A  60      30.387  68.248  10.773  1.00  0.00           H  
ATOM    905  HA  LYS A  60      32.096  70.627  11.089  1.00  0.00           H  
ATOM    906  HB2 LYS A  60      32.645  68.535   9.009  1.00  0.00           H  
ATOM    907  HB3 LYS A  60      33.734  69.744   9.675  1.00  0.00           H  
ATOM    908  HG2 LYS A  60      32.659  67.413  11.243  1.00  0.00           H  
ATOM    909  HG3 LYS A  60      34.207  67.408  10.393  1.00  0.00           H  
ATOM    910  HD2 LYS A  60      35.180  68.850  11.876  1.00  0.00           H  
ATOM    911  HD3 LYS A  60      33.655  69.647  12.269  1.00  0.00           H  
ATOM    912  HE2 LYS A  60      33.091  68.089  13.846  1.00  0.00           H  
ATOM    913  HE3 LYS A  60      33.992  66.798  13.051  1.00  0.00           H  
ATOM    914  HZ1 LYS A  60      36.037  67.727  13.845  1.00  0.00           H  
ATOM    915  HZ2 LYS A  60      34.993  67.535  15.162  1.00  0.00           H  
ATOM    916  HZ3 LYS A  60      35.241  69.071  14.499  1.00  0.00           H  
ATOM    917  N   PRO A  61      31.286  71.742   8.987  1.00  0.00           N  
ATOM    918  CA  PRO A  61      30.642  72.483   7.898  1.00  0.00           C  
ATOM    919  C   PRO A  61      31.054  71.966   6.523  1.00  0.00           C  
ATOM    920  O   PRO A  61      32.241  71.806   6.238  1.00  0.00           O  
ATOM    921  CB  PRO A  61      31.140  73.916   8.101  1.00  0.00           C  
ATOM    922  CG  PRO A  61      32.436  73.768   8.821  1.00  0.00           C  
ATOM    923  CD  PRO A  61      32.286  72.556   9.698  1.00  0.00           C  
ATOM    924  HA  PRO A  61      29.566  72.459   7.983  1.00  0.00           H  
ATOM    925  HB2 PRO A  61      31.274  74.393   7.140  1.00  0.00           H  
ATOM    926  HB3 PRO A  61      30.424  74.470   8.688  1.00  0.00           H  
ATOM    927  HG2 PRO A  61      33.236  73.622   8.112  1.00  0.00           H  
ATOM    928  HG3 PRO A  61      32.623  74.645   9.424  1.00  0.00           H  
ATOM    929  HD2 PRO A  61      33.226  72.029   9.777  1.00  0.00           H  
ATOM    930  HD3 PRO A  61      31.927  72.839  10.677  1.00  0.00           H  
ATOM    931  N   VAL A  62      30.064  71.707   5.674  1.00  0.00           N  
ATOM    932  CA  VAL A  62      30.324  71.210   4.328  1.00  0.00           C  
ATOM    933  C   VAL A  62      30.721  72.344   3.389  1.00  0.00           C  
ATOM    934  O   VAL A  62      30.079  73.393   3.364  1.00  0.00           O  
ATOM    935  CB  VAL A  62      29.093  70.487   3.750  1.00  0.00           C  
ATOM    936  CG1 VAL A  62      29.379  69.985   2.342  1.00  0.00           C  
ATOM    937  CG2 VAL A  62      28.674  69.340   4.658  1.00  0.00           C  
ATOM    938  H   VAL A  62      29.139  71.855   5.958  1.00  0.00           H  
ATOM    939  HA  VAL A  62      31.137  70.500   4.384  1.00  0.00           H  
ATOM    940  HB  VAL A  62      28.277  71.192   3.697  1.00  0.00           H  
ATOM    941 HG11 VAL A  62      29.963  70.722   1.810  1.00  0.00           H  
ATOM    942 HG12 VAL A  62      29.929  69.058   2.396  1.00  0.00           H  
ATOM    943 HG13 VAL A  62      28.447  69.822   1.821  1.00  0.00           H  
ATOM    944 HG21 VAL A  62      29.241  69.383   5.575  1.00  0.00           H  
ATOM    945 HG22 VAL A  62      27.620  69.425   4.882  1.00  0.00           H  
ATOM    946 HG23 VAL A  62      28.862  68.400   4.161  1.00  0.00           H  
ATOM    947  N   GLN A  63      31.781  72.124   2.619  1.00  0.00           N  
ATOM    948  CA  GLN A  63      32.263  73.128   1.679  1.00  0.00           C  
ATOM    949  C   GLN A  63      31.219  73.412   0.604  1.00  0.00           C  
ATOM    950  O   GLN A  63      30.350  72.584   0.331  1.00  0.00           O  
ATOM    951  CB  GLN A  63      33.568  72.664   1.029  1.00  0.00           C  
ATOM    952  CG  GLN A  63      34.453  73.808   0.560  1.00  0.00           C  
ATOM    953  CD  GLN A  63      35.563  73.345  -0.364  1.00  0.00           C  
ATOM    954  OE1 GLN A  63      36.268  72.379  -0.071  1.00  0.00           O  
ATOM    955  NE2 GLN A  63      35.724  74.034  -1.487  1.00  0.00           N  
ATOM    956  H   GLN A  63      32.250  71.266   2.685  1.00  0.00           H  
ATOM    957  HA  GLN A  63      32.450  74.036   2.231  1.00  0.00           H  
ATOM    958  HB2 GLN A  63      34.125  72.077   1.745  1.00  0.00           H  
ATOM    959  HB3 GLN A  63      33.332  72.047   0.176  1.00  0.00           H  
ATOM    960  HG2 GLN A  63      33.844  74.526   0.033  1.00  0.00           H  
ATOM    961  HG3 GLN A  63      34.898  74.280   1.424  1.00  0.00           H  
ATOM    962 HE21 GLN A  63      35.126  74.794  -1.653  1.00  0.00           H  
ATOM    963 HE22 GLN A  63      36.434  73.758  -2.103  1.00  0.00           H  
ATOM    964  N   THR A  64      31.311  74.591  -0.006  1.00  0.00           N  
ATOM    965  CA  THR A  64      30.374  74.986  -1.050  1.00  0.00           C  
ATOM    966  C   THR A  64      31.003  74.854  -2.432  1.00  0.00           C  
ATOM    967  O   THR A  64      32.226  74.873  -2.572  1.00  0.00           O  
ATOM    968  CB  THR A  64      29.892  76.435  -0.854  1.00  0.00           C  
ATOM    969  OG1 THR A  64      28.892  76.756  -1.827  1.00  0.00           O  
ATOM    970  CG2 THR A  64      31.053  77.412  -0.974  1.00  0.00           C  
ATOM    971  H   THR A  64      32.025  75.208   0.255  1.00  0.00           H  
ATOM    972  HA  THR A  64      29.516  74.332  -0.992  1.00  0.00           H  
ATOM    973  HB  THR A  64      29.465  76.526   0.135  1.00  0.00           H  
ATOM    974  HG1 THR A  64      29.312  77.121  -2.610  1.00  0.00           H  
ATOM    975 HG21 THR A  64      31.954  76.949  -0.596  1.00  0.00           H  
ATOM    976 HG22 THR A  64      30.836  78.300  -0.398  1.00  0.00           H  
ATOM    977 HG23 THR A  64      31.194  77.679  -2.009  1.00  0.00           H  
ATOM    978  N   GLU A  65      30.160  74.720  -3.451  1.00  0.00           N  
ATOM    979  CA  GLU A  65      30.637  74.586  -4.823  1.00  0.00           C  
ATOM    980  C   GLU A  65      31.183  75.912  -5.342  1.00  0.00           C  
ATOM    981  O   GLU A  65      30.471  76.677  -5.992  1.00  0.00           O  
ATOM    982  CB  GLU A  65      29.508  74.095  -5.732  1.00  0.00           C  
ATOM    983  CG  GLU A  65      29.066  72.671  -5.440  1.00  0.00           C  
ATOM    984  CD  GLU A  65      28.038  72.597  -4.328  1.00  0.00           C  
ATOM    985  OE1 GLU A  65      27.213  73.528  -4.219  1.00  0.00           O  
ATOM    986  OE2 GLU A  65      28.058  71.607  -3.565  1.00  0.00           O  
ATOM    987  H   GLU A  65      29.197  74.712  -3.276  1.00  0.00           H  
ATOM    988  HA  GLU A  65      31.433  73.856  -4.828  1.00  0.00           H  
ATOM    989  HB2 GLU A  65      28.656  74.747  -5.611  1.00  0.00           H  
ATOM    990  HB3 GLU A  65      29.843  74.141  -6.758  1.00  0.00           H  
ATOM    991  HG2 GLU A  65      28.635  72.250  -6.335  1.00  0.00           H  
ATOM    992  HG3 GLU A  65      29.930  72.092  -5.150  1.00  0.00           H  
ATOM    993  N   ALA A  66      32.452  76.177  -5.050  1.00  0.00           N  
ATOM    994  CA  ALA A  66      33.094  77.410  -5.488  1.00  0.00           C  
ATOM    995  C   ALA A  66      33.774  77.225  -6.841  1.00  0.00           C  
ATOM    996  O   ALA A  66      34.886  77.706  -7.058  1.00  0.00           O  
ATOM    997  CB  ALA A  66      34.102  77.878  -4.449  1.00  0.00           C  
ATOM    998  H   ALA A  66      32.968  75.529  -4.528  1.00  0.00           H  
ATOM    999  HA  ALA A  66      32.332  78.170  -5.581  1.00  0.00           H  
ATOM   1000  HB1 ALA A  66      35.005  77.290  -4.533  1.00  0.00           H  
ATOM   1001  HB2 ALA A  66      34.334  78.920  -4.616  1.00  0.00           H  
ATOM   1002  HB3 ALA A  66      33.684  77.755  -3.461  1.00  0.00           H  
ATOM   1003  N   TRP A  67      33.099  76.524  -7.745  1.00  0.00           N  
ATOM   1004  CA  TRP A  67      33.639  76.275  -9.077  1.00  0.00           C  
ATOM   1005  C   TRP A  67      34.015  77.582  -9.766  1.00  0.00           C  
ATOM   1006  O   TRP A  67      33.424  78.628  -9.497  1.00  0.00           O  
ATOM   1007  CB  TRP A  67      32.623  75.509  -9.926  1.00  0.00           C  
ATOM   1008  CG  TRP A  67      32.502  74.064  -9.548  1.00  0.00           C  
ATOM   1009  CD1 TRP A  67      32.128  73.563  -8.333  1.00  0.00           C  
ATOM   1010  CD2 TRP A  67      32.755  72.934 -10.389  1.00  0.00           C  
ATOM   1011  NE1 TRP A  67      32.135  72.190  -8.369  1.00  0.00           N  
ATOM   1012  CE2 TRP A  67      32.515  71.778  -9.619  1.00  0.00           C  
ATOM   1013  CE3 TRP A  67      33.160  72.784 -11.718  1.00  0.00           C  
ATOM   1014  CZ2 TRP A  67      32.669  70.494 -10.135  1.00  0.00           C  
ATOM   1015  CZ3 TRP A  67      33.311  71.509 -12.229  1.00  0.00           C  
ATOM   1016  CH2 TRP A  67      33.066  70.379 -11.440  1.00  0.00           C  
ATOM   1017  H   TRP A  67      32.217  76.166  -7.511  1.00  0.00           H  
ATOM   1018  HA  TRP A  67      34.528  75.672  -8.965  1.00  0.00           H  
ATOM   1019  HB2 TRP A  67      31.651  75.966  -9.813  1.00  0.00           H  
ATOM   1020  HB3 TRP A  67      32.921  75.559 -10.963  1.00  0.00           H  
ATOM   1021  HD1 TRP A  67      31.871  74.170  -7.478  1.00  0.00           H  
ATOM   1022  HE1 TRP A  67      31.904  71.601  -7.620  1.00  0.00           H  
ATOM   1023  HE3 TRP A  67      33.354  73.644 -12.343  1.00  0.00           H  
ATOM   1024  HZ2 TRP A  67      32.482  69.613  -9.540  1.00  0.00           H  
ATOM   1025  HZ3 TRP A  67      33.624  71.375 -13.254  1.00  0.00           H  
ATOM   1026  HH2 TRP A  67      33.198  69.403 -11.880  1.00  0.00           H  
ATOM   1027  N   VAL A  68      34.998  77.515 -10.657  1.00  0.00           N  
ATOM   1028  CA  VAL A  68      35.451  78.694 -11.385  1.00  0.00           C  
ATOM   1029  C   VAL A  68      35.668  78.378 -12.861  1.00  0.00           C  
ATOM   1030  O   VAL A  68      36.398  77.449 -13.207  1.00  0.00           O  
ATOM   1031  CB  VAL A  68      36.760  79.251 -10.793  1.00  0.00           C  
ATOM   1032  CG1 VAL A  68      37.236  80.456 -11.591  1.00  0.00           C  
ATOM   1033  CG2 VAL A  68      36.570  79.613  -9.329  1.00  0.00           C  
ATOM   1034  H   VAL A  68      35.431  76.652 -10.827  1.00  0.00           H  
ATOM   1035  HA  VAL A  68      34.688  79.454 -11.298  1.00  0.00           H  
ATOM   1036  HB  VAL A  68      37.516  78.483 -10.858  1.00  0.00           H  
ATOM   1037 HG11 VAL A  68      36.937  80.345 -12.623  1.00  0.00           H  
ATOM   1038 HG12 VAL A  68      36.797  81.355 -11.183  1.00  0.00           H  
ATOM   1039 HG13 VAL A  68      38.312  80.522 -11.534  1.00  0.00           H  
ATOM   1040 HG21 VAL A  68      35.662  80.186  -9.214  1.00  0.00           H  
ATOM   1041 HG22 VAL A  68      36.501  78.709  -8.740  1.00  0.00           H  
ATOM   1042 HG23 VAL A  68      37.411  80.199  -8.990  1.00  0.00           H  
ATOM   1043  N   ARG A  69      35.028  79.157 -13.727  1.00  0.00           N  
ATOM   1044  CA  ARG A  69      35.150  78.960 -15.167  1.00  0.00           C  
ATOM   1045  C   ARG A  69      36.277  79.814 -15.739  1.00  0.00           C  
ATOM   1046  O   ARG A  69      36.589  80.883 -15.213  1.00  0.00           O  
ATOM   1047  CB  ARG A  69      33.832  79.303 -15.863  1.00  0.00           C  
ATOM   1048  CG  ARG A  69      33.781  78.865 -17.318  1.00  0.00           C  
ATOM   1049  CD  ARG A  69      32.449  79.221 -17.960  1.00  0.00           C  
ATOM   1050  NE  ARG A  69      31.464  78.152 -17.806  1.00  0.00           N  
ATOM   1051  CZ  ARG A  69      31.477  77.034 -18.522  1.00  0.00           C  
ATOM   1052  NH1 ARG A  69      32.417  76.839 -19.436  1.00  0.00           N  
ATOM   1053  NH2 ARG A  69      30.547  76.108 -18.325  1.00  0.00           N  
ATOM   1054  H   ARG A  69      34.460  79.881 -13.390  1.00  0.00           H  
ATOM   1055  HA  ARG A  69      35.379  77.919 -15.341  1.00  0.00           H  
ATOM   1056  HB2 ARG A  69      33.023  78.819 -15.336  1.00  0.00           H  
ATOM   1057  HB3 ARG A  69      33.686  80.372 -15.826  1.00  0.00           H  
ATOM   1058  HG2 ARG A  69      34.572  79.360 -17.861  1.00  0.00           H  
ATOM   1059  HG3 ARG A  69      33.920  77.796 -17.368  1.00  0.00           H  
ATOM   1060  HD2 ARG A  69      32.068  80.117 -17.493  1.00  0.00           H  
ATOM   1061  HD3 ARG A  69      32.608  79.403 -19.012  1.00  0.00           H  
ATOM   1062  HE  ARG A  69      30.760  78.277 -17.136  1.00  0.00           H  
ATOM   1063 HH11 ARG A  69      33.120  77.535 -19.587  1.00  0.00           H  
ATOM   1064 HH12 ARG A  69      32.424  75.995 -19.974  1.00  0.00           H  
ATOM   1065 HH21 ARG A  69      29.837  76.252 -17.637  1.00  0.00           H  
ATOM   1066 HH22 ARG A  69      30.557  75.267 -18.865  1.00  0.00           H  
ATOM   1067  N   ASP A  70      36.886  79.336 -16.818  1.00  0.00           N  
ATOM   1068  CA  ASP A  70      37.978  80.055 -17.463  1.00  0.00           C  
ATOM   1069  C   ASP A  70      38.381  79.377 -18.768  1.00  0.00           C  
ATOM   1070  O   ASP A  70      38.413  78.151 -18.875  1.00  0.00           O  
ATOM   1071  CB  ASP A  70      39.184  80.141 -16.525  1.00  0.00           C  
ATOM   1072  CG  ASP A  70      40.007  81.393 -16.755  1.00  0.00           C  
ATOM   1073  OD1 ASP A  70      39.623  82.460 -16.232  1.00  0.00           O  
ATOM   1074  OD2 ASP A  70      41.036  81.307 -17.459  1.00  0.00           O  
ATOM   1075  H   ASP A  70      36.593  78.478 -17.191  1.00  0.00           H  
ATOM   1076  HA  ASP A  70      37.633  81.054 -17.682  1.00  0.00           H  
ATOM   1077  HB2 ASP A  70      38.837  80.144 -15.502  1.00  0.00           H  
ATOM   1078  HB3 ASP A  70      39.817  79.281 -16.684  1.00  0.00           H  
ATOM   1079  N   PRO A  71      38.695  80.191 -19.787  1.00  0.00           N  
ATOM   1080  CA  PRO A  71      39.099  79.692 -21.104  1.00  0.00           C  
ATOM   1081  C   PRO A  71      40.476  79.036 -21.077  1.00  0.00           C  
ATOM   1082  O   PRO A  71      40.900  78.420 -22.054  1.00  0.00           O  
ATOM   1083  CB  PRO A  71      39.126  80.954 -21.969  1.00  0.00           C  
ATOM   1084  CG  PRO A  71      39.360  82.068 -21.008  1.00  0.00           C  
ATOM   1085  CD  PRO A  71      38.678  81.663 -19.731  1.00  0.00           C  
ATOM   1086  HA  PRO A  71      38.378  78.995 -21.503  1.00  0.00           H  
ATOM   1087  HB2 PRO A  71      39.926  80.881 -22.693  1.00  0.00           H  
ATOM   1088  HB3 PRO A  71      38.181  81.066 -22.480  1.00  0.00           H  
ATOM   1089  HG2 PRO A  71      40.420  82.194 -20.843  1.00  0.00           H  
ATOM   1090  HG3 PRO A  71      38.928  82.980 -21.391  1.00  0.00           H  
ATOM   1091  HD2 PRO A  71      39.231  82.022 -18.876  1.00  0.00           H  
ATOM   1092  HD3 PRO A  71      37.663  82.036 -19.711  1.00  0.00           H  
ATOM   1093  N   ASN A  72      41.169  79.171 -19.951  1.00  0.00           N  
ATOM   1094  CA  ASN A  72      42.498  78.592 -19.796  1.00  0.00           C  
ATOM   1095  C   ASN A  72      42.420  77.220 -19.131  1.00  0.00           C  
ATOM   1096  O   ASN A  72      42.178  77.115 -17.929  1.00  0.00           O  
ATOM   1097  CB  ASN A  72      43.390  79.520 -18.971  1.00  0.00           C  
ATOM   1098  CG  ASN A  72      44.613  78.811 -18.422  1.00  0.00           C  
ATOM   1099  OD1 ASN A  72      45.288  78.070 -19.137  1.00  0.00           O  
ATOM   1100  ND2 ASN A  72      44.903  79.035 -17.145  1.00  0.00           N  
ATOM   1101  H   ASN A  72      40.777  79.673 -19.205  1.00  0.00           H  
ATOM   1102  HA  ASN A  72      42.926  78.478 -20.781  1.00  0.00           H  
ATOM   1103  HB2 ASN A  72      43.722  80.337 -19.594  1.00  0.00           H  
ATOM   1104  HB3 ASN A  72      42.822  79.913 -18.142  1.00  0.00           H  
ATOM   1105 HD21 ASN A  72      44.321  79.636 -16.636  1.00  0.00           H  
ATOM   1106 HD22 ASN A  72      45.689  78.589 -16.765  1.00  0.00           H  
ATOM   1107  N   SER A  73      42.627  76.172 -19.922  1.00  0.00           N  
ATOM   1108  CA  SER A  73      42.576  74.807 -19.412  1.00  0.00           C  
ATOM   1109  C   SER A  73      43.483  74.649 -18.196  1.00  0.00           C  
ATOM   1110  O   SER A  73      44.671  74.962 -18.248  1.00  0.00           O  
ATOM   1111  CB  SER A  73      42.989  73.817 -20.502  1.00  0.00           C  
ATOM   1112  OG  SER A  73      41.927  73.587 -21.412  1.00  0.00           O  
ATOM   1113  H   SER A  73      42.815  76.321 -20.873  1.00  0.00           H  
ATOM   1114  HA  SER A  73      41.558  74.601 -19.117  1.00  0.00           H  
ATOM   1115  HB2 SER A  73      43.833  74.214 -21.046  1.00  0.00           H  
ATOM   1116  HB3 SER A  73      43.266  72.877 -20.046  1.00  0.00           H  
ATOM   1117  HG  SER A  73      41.279  73.005 -21.008  1.00  0.00           H  
ATOM   1118  N   GLY A  74      42.911  74.159 -17.099  1.00  0.00           N  
ATOM   1119  CA  GLY A  74      43.680  73.967 -15.883  1.00  0.00           C  
ATOM   1120  C   GLY A  74      44.445  72.658 -15.882  1.00  0.00           C  
ATOM   1121  O   GLY A  74      45.565  72.568 -16.385  1.00  0.00           O  
ATOM   1122  H   GLY A  74      41.959  73.928 -17.115  1.00  0.00           H  
ATOM   1123  HA2 GLY A  74      44.382  74.782 -15.782  1.00  0.00           H  
ATOM   1124  HA3 GLY A  74      43.008  73.979 -15.040  1.00  0.00           H  
ATOM   1125  N   PRO A  75      43.835  71.614 -15.303  1.00  0.00           N  
ATOM   1126  CA  PRO A  75      44.448  70.284 -15.223  1.00  0.00           C  
ATOM   1127  C   PRO A  75      44.536  69.604 -16.585  1.00  0.00           C  
ATOM   1128  O   PRO A  75      43.617  69.701 -17.398  1.00  0.00           O  
ATOM   1129  CB  PRO A  75      43.501  69.512 -14.300  1.00  0.00           C  
ATOM   1130  CG  PRO A  75      42.186  70.198 -14.447  1.00  0.00           C  
ATOM   1131  CD  PRO A  75      42.500  71.649 -14.683  1.00  0.00           C  
ATOM   1132  HA  PRO A  75      45.432  70.327 -14.779  1.00  0.00           H  
ATOM   1133  HB2 PRO A  75      43.448  68.480 -14.616  1.00  0.00           H  
ATOM   1134  HB3 PRO A  75      43.861  69.564 -13.284  1.00  0.00           H  
ATOM   1135  HG2 PRO A  75      41.651  69.787 -15.290  1.00  0.00           H  
ATOM   1136  HG3 PRO A  75      41.609  70.081 -13.542  1.00  0.00           H  
ATOM   1137  HD2 PRO A  75      41.775  72.088 -15.352  1.00  0.00           H  
ATOM   1138  HD3 PRO A  75      42.525  72.187 -13.746  1.00  0.00           H  
ATOM   1139  N   SER A  76      45.648  68.915 -16.826  1.00  0.00           N  
ATOM   1140  CA  SER A  76      45.856  68.221 -18.091  1.00  0.00           C  
ATOM   1141  C   SER A  76      46.376  66.806 -17.854  1.00  0.00           C  
ATOM   1142  O   SER A  76      46.784  66.459 -16.746  1.00  0.00           O  
ATOM   1143  CB  SER A  76      46.842  68.998 -18.967  1.00  0.00           C  
ATOM   1144  OG  SER A  76      46.198  70.071 -19.631  1.00  0.00           O  
ATOM   1145  H   SER A  76      46.343  68.875 -16.137  1.00  0.00           H  
ATOM   1146  HA  SER A  76      44.905  68.162 -18.599  1.00  0.00           H  
ATOM   1147  HB2 SER A  76      47.633  69.395 -18.348  1.00  0.00           H  
ATOM   1148  HB3 SER A  76      47.263  68.332 -19.706  1.00  0.00           H  
ATOM   1149  HG  SER A  76      46.757  70.390 -20.342  1.00  0.00           H  
ATOM   1150  N   SER A  77      46.357  65.991 -18.905  1.00  0.00           N  
ATOM   1151  CA  SER A  77      46.822  64.612 -18.812  1.00  0.00           C  
ATOM   1152  C   SER A  77      48.241  64.554 -18.258  1.00  0.00           C  
ATOM   1153  O   SER A  77      49.115  65.313 -18.675  1.00  0.00           O  
ATOM   1154  CB  SER A  77      46.770  63.941 -20.187  1.00  0.00           C  
ATOM   1155  OG  SER A  77      47.846  64.370 -21.004  1.00  0.00           O  
ATOM   1156  H   SER A  77      46.020  66.326 -19.763  1.00  0.00           H  
ATOM   1157  HA  SER A  77      46.163  64.085 -18.139  1.00  0.00           H  
ATOM   1158  HB2 SER A  77      46.832  62.871 -20.064  1.00  0.00           H  
ATOM   1159  HB3 SER A  77      45.840  64.196 -20.673  1.00  0.00           H  
ATOM   1160  HG  SER A  77      47.508  64.644 -21.860  1.00  0.00           H  
ATOM   1161  N   GLY A  78      48.464  63.645 -17.312  1.00  0.00           N  
ATOM   1162  CA  GLY A  78      49.779  63.504 -16.715  1.00  0.00           C  
ATOM   1163  C   GLY A  78      50.747  62.758 -17.613  1.00  0.00           C  
ATOM   1164  O   GLY A  78      50.363  61.814 -18.302  1.00  0.00           O  
ATOM   1165  H   GLY A  78      47.730  63.067 -17.018  1.00  0.00           H  
ATOM   1166  HA2 GLY A  78      50.177  64.485 -16.510  1.00  0.00           H  
ATOM   1167  HA3 GLY A  78      49.682  62.965 -15.784  1.00  0.00           H  
TER    1168      GLY A  78                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
