
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 ( 1011),  selected   68 , name 2dig_A
# Molecule2: number of CA atoms   93 (  764),  selected   93 , name T0504_63_155.pdb
# PARAMETERS: 2dig_A.T0504_63_155.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      X      63           -
LGA    S     2_A      P      64           -
LGA    S     3_A      P      65           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    S    10_A      A      66          5.770
LGA    R    11_A      D      67          2.145
LGA    K    12_A      K      68          3.775
LGA    F    13_A      L      69          0.916
LGA    A    14_A      Y      70          1.163
LGA    D    15_A      V      71          1.164
LGA    G    16_A      G      72          0.664
LGA    E    17_A      S      73          1.358
LGA    V    18_A      R      74          1.216
LGA    V    19_A      V      75          0.493
LGA    R    20_A      V      76          0.521
LGA    G    21_A      A      77          1.194
LGA    R    22_A      K      78          0.649
LGA    W    23_A      Y      79          1.006
LGA    P    24_A      K      80          1.815
LGA    G    25_A      D      81          5.328
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    S    26_A      Q      84          3.181
LGA    S    27_A      V      85          3.161
LGA    L    28_A      W      86          1.414
LGA    Y    29_A      L      87          1.133
LGA    Y    30_A      Y      88          0.621
LGA    E    31_A      A      89          0.869
LGA    V    32_A      G      90          0.514
LGA    E    33_A      I      91          0.656
LGA    I    34_A      V      92          0.901
LGA    L    35_A      A      93          0.773
LGA    S    36_A      E      94          0.697
LGA    H    37_A      T      95          1.618
LGA    D    38_A      P      96          2.780
LGA    S    39_A      N      97          2.916
LGA    T    40_A      V      98          3.749
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    S    41_A      K     101          2.900
LGA    Q    42_A      L     102          2.503
LGA    L    43_A      R     103          1.093
LGA    Y    44_A      F     104          0.633
LGA    T    45_A      L     105          0.764
LGA    V    46_A      I     106          1.155
LGA    K    47_A      F     107          0.673
LGA    Y    48_A      F     108          1.716
LGA    K    49_A      D     109          2.308
LGA    D    50_A      D     110          2.729
LGA    G    51_A      G     111          2.104
LGA    T    52_A      Y     112          2.103
LGA    E    53_A      A     113          1.585
LGA    L    54_A      S     114          1.064
LGA    E    55_A      Y     115          0.466
LGA    L    56_A      V     116          0.746
LGA    K    57_A      T     117          0.763
LGA    E    58_A      Q     118          1.191
LGA    N    59_A      S     119          1.072
LGA    D    60_A      E     120          0.921
LGA    I    61_A      L     121          1.332
LGA    K    62_A      Y     122          1.216
LGA    S    63_A      P     123          1.263
LGA    G    64_A      I     124          3.135
LGA    P    65_A      C     125          1.486
LGA    S    66_A      R     126          1.586
LGA    S    67_A      P     127          4.761
LGA    G    68_A      L     128          5.098
LGA    -       -      K     129           -
LGA    -       -      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    -       -      E     133           -
LGA    -       -      D     134           -
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68   93    5.0     59    2.16    10.17     56.291     2.615

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.891162 * X  +   0.288408 * Y  +   0.350217 * Z  +  26.871817
  Y_new =  -0.418508 * X  +   0.820621 * Y  +   0.389143 * Z  +  63.628700
  Z_new =  -0.175164 * X  +  -0.493358 * Y  +   0.852007 * Z  +   7.995983 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.524876    2.616717  [ DEG:   -30.0732    149.9268 ]
  Theta =   0.176072    2.965521  [ DEG:    10.0882    169.9118 ]
  Phi   =  -0.439050    2.702543  [ DEG:   -25.1557    154.8443 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dig_A                                        
REMARK     2: T0504_63_155.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dig_A.T0504_63_155.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68   93   5.0   59   2.16   10.17  56.291
REMARK  ---------------------------------------------------------- 
MOLECULE 2dig_A
HEADER    DNA BINDING PROTEIN                     30-MAR-06   2DIG              
TITLE     SOLUSION STRUCTURE OF THE TODOR DOMAIN OF HUMAN LAMIN-B               
TITLE    2 RECEPTOR                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LAMIN-B RECEPTOR;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: INTEGRAL NUCLEAR ENVELOPE INNER MEMBRANE PROTEIN,           
COMPND   6 LMN2R;                                                               
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: LBR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050905-15;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, INTEGRAL NUCLEAR ENVELOPE INNER MEMBRANE                
KEYWDS   2 PROTEIN, NUCLEAR PROTEIN, RECEPTOR, STRUCTURAL GENOMICS,             
KEYWDS   3 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   4 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   5 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.YONEYAMA,N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,            
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   30-SEP-06 2DIG    0                                                
JRNL        AUTH   M.YONEYAMA,N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,              
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUSION STRUCTURE OF THE TODOR DOMAIN OF HUMAN              
JRNL        TITL 2 LAMIN-B RECEPTOR                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DIG A    8    62  UNP    Q14739   LBR_HUMAN        1     55             
SEQRES   1 A   68  GLY SER SER GLY SER SER GLY MET PRO SER ARG LYS PHE          
SEQRES   2 A   68  ALA ASP GLY GLU VAL VAL ARG GLY ARG TRP PRO GLY SER          
SEQRES   3 A   68  SER LEU TYR TYR GLU VAL GLU ILE LEU SER HIS ASP SER          
SEQRES   4 A   68  THR SER GLN LEU TYR THR VAL LYS TYR LYS ASP GLY THR          
SEQRES   5 A   68  GLU LEU GLU LEU LYS GLU ASN ASP ILE LYS SER GLY PRO          
SEQRES   6 A   68  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      35.096  93.763  22.928  1.00  0.00           N  
ATOM      2  CA  GLY A   1      34.641  94.886  23.725  1.00  0.00           C  
ATOM      3  C   GLY A   1      33.165  95.173  23.533  1.00  0.00           C  
ATOM      4  O   GLY A   1      32.792  96.084  22.795  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      34.823  94.672  24.767  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      35.205  95.765  23.444  1.00  0.00           H  
ATOM      7  H1  GLY A   1      34.629  93.533  22.097  1.00  0.00           H  
ATOM      8  N   SER A   2      32.320  94.391  24.200  1.00  0.00           N  
ATOM      9  CA  SER A   2      30.876  94.561  24.095  1.00  0.00           C  
ATOM     10  C   SER A   2      30.436  94.585  22.635  1.00  0.00           C  
ATOM     11  O   SER A   2      29.726  95.492  22.203  1.00  0.00           O  
ATOM     12  CB  SER A   2      30.442  95.852  24.791  1.00  0.00           C  
ATOM     13  OG  SER A   2      30.391  95.682  26.197  1.00  0.00           O  
ATOM     14  H   SER A   2      32.679  93.681  24.774  1.00  0.00           H  
ATOM     15  HA  SER A   2      30.407  93.723  24.587  1.00  0.00           H  
ATOM     16  HB2 SER A   2      31.147  96.637  24.561  1.00  0.00           H  
ATOM     17  HB3 SER A   2      29.461  96.136  24.438  1.00  0.00           H  
ATOM     18  HG  SER A   2      29.956  96.439  26.596  1.00  0.00           H  
ATOM     19  N   SER A   3      30.863  93.578  21.878  1.00  0.00           N  
ATOM     20  CA  SER A   3      30.517  93.483  20.465  1.00  0.00           C  
ATOM     21  C   SER A   3      30.505  92.029  20.005  1.00  0.00           C  
ATOM     22  O   SER A   3      31.297  91.212  20.471  1.00  0.00           O  
ATOM     23  CB  SER A   3      31.508  94.288  19.621  1.00  0.00           C  
ATOM     24  OG  SER A   3      31.102  94.334  18.264  1.00  0.00           O  
ATOM     25  H   SER A   3      31.427  92.884  22.280  1.00  0.00           H  
ATOM     26  HA  SER A   3      29.529  93.898  20.338  1.00  0.00           H  
ATOM     27  HB2 SER A   3      31.566  95.296  20.001  1.00  0.00           H  
ATOM     28  HB3 SER A   3      32.484  93.826  19.677  1.00  0.00           H  
ATOM     29  HG  SER A   3      31.849  94.124  17.699  1.00  0.00           H  
ATOM     30  N   GLY A   4      29.595  91.713  19.087  1.00  0.00           N  
ATOM     31  CA  GLY A   4      29.494  90.358  18.578  1.00  0.00           C  
ATOM     32  C   GLY A   4      28.058  89.889  18.458  1.00  0.00           C  
ATOM     33  O   GLY A   4      27.558  89.678  17.354  1.00  0.00           O  
ATOM     34  H   GLY A   4      28.989  92.407  18.752  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      29.959  90.315  17.605  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      30.022  89.694  19.248  1.00  0.00           H  
ATOM     37  N   SER A   5      27.394  89.724  19.597  1.00  0.00           N  
ATOM     38  CA  SER A   5      26.008  89.271  19.616  1.00  0.00           C  
ATOM     39  C   SER A   5      25.055  90.428  19.326  1.00  0.00           C  
ATOM     40  O   SER A   5      24.746  91.227  20.209  1.00  0.00           O  
ATOM     41  CB  SER A   5      25.671  88.645  20.970  1.00  0.00           C  
ATOM     42  OG  SER A   5      26.152  87.314  21.050  1.00  0.00           O  
ATOM     43  H   SER A   5      27.848  89.908  20.446  1.00  0.00           H  
ATOM     44  HA  SER A   5      25.892  88.524  18.845  1.00  0.00           H  
ATOM     45  HB2 SER A   5      26.126  89.227  21.756  1.00  0.00           H  
ATOM     46  HB3 SER A   5      24.599  88.636  21.103  1.00  0.00           H  
ATOM     47  HG  SER A   5      25.427  86.703  20.907  1.00  0.00           H  
ATOM     48  N   SER A   6      24.594  90.509  18.082  1.00  0.00           N  
ATOM     49  CA  SER A   6      23.680  91.569  17.674  1.00  0.00           C  
ATOM     50  C   SER A   6      22.764  91.094  16.549  1.00  0.00           C  
ATOM     51  O   SER A   6      23.228  90.593  15.527  1.00  0.00           O  
ATOM     52  CB  SER A   6      24.465  92.802  17.221  1.00  0.00           C  
ATOM     53  OG  SER A   6      25.395  93.207  18.211  1.00  0.00           O  
ATOM     54  H   SER A   6      24.878  89.841  17.423  1.00  0.00           H  
ATOM     55  HA  SER A   6      23.075  91.832  18.528  1.00  0.00           H  
ATOM     56  HB2 SER A   6      25.001  92.571  16.313  1.00  0.00           H  
ATOM     57  HB3 SER A   6      23.777  93.615  17.036  1.00  0.00           H  
ATOM     58  HG  SER A   6      25.137  94.062  18.561  1.00  0.00           H  
ATOM     59  N   GLY A   7      21.460  91.255  16.749  1.00  0.00           N  
ATOM     60  CA  GLY A   7      20.499  90.839  15.745  1.00  0.00           C  
ATOM     61  C   GLY A   7      19.885  89.488  16.056  1.00  0.00           C  
ATOM     62  O   GLY A   7      19.077  89.362  16.977  1.00  0.00           O  
ATOM     63  H   GLY A   7      21.148  91.662  17.585  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      19.712  91.575  15.688  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      20.996  90.783  14.788  1.00  0.00           H  
ATOM     66  N   MET A   8      20.267  88.475  15.285  1.00  0.00           N  
ATOM     67  CA  MET A   8      19.748  87.127  15.484  1.00  0.00           C  
ATOM     68  C   MET A   8      20.860  86.173  15.910  1.00  0.00           C  
ATOM     69  O   MET A   8      22.024  86.335  15.545  1.00  0.00           O  
ATOM     70  CB  MET A   8      19.088  86.616  14.201  1.00  0.00           C  
ATOM     71  CG  MET A   8      17.819  87.368  13.831  1.00  0.00           C  
ATOM     72  SD  MET A   8      16.610  87.388  15.169  1.00  0.00           S  
ATOM     73  CE  MET A   8      15.431  88.581  14.540  1.00  0.00           C  
ATOM     74  H   MET A   8      20.914  88.636  14.568  1.00  0.00           H  
ATOM     75  HA  MET A   8      19.006  87.169  16.267  1.00  0.00           H  
ATOM     76  HB2 MET A   8      19.789  86.716  13.386  1.00  0.00           H  
ATOM     77  HB3 MET A   8      18.839  85.574  14.328  1.00  0.00           H  
ATOM     78  HG2 MET A   8      18.078  88.386  13.585  1.00  0.00           H  
ATOM     79  HG3 MET A   8      17.375  86.892  12.969  1.00  0.00           H  
ATOM     80  HE1 MET A   8      14.948  89.079  15.368  1.00  0.00           H  
ATOM     81  HE2 MET A   8      15.945  89.310  13.934  1.00  0.00           H  
ATOM     82  HE3 MET A   8      14.689  88.073  13.942  1.00  0.00           H  
ATOM     83  N   PRO A   9      20.495  85.153  16.703  1.00  0.00           N  
ATOM     84  CA  PRO A   9      21.448  84.154  17.195  1.00  0.00           C  
ATOM     85  C   PRO A   9      21.954  83.239  16.085  1.00  0.00           C  
ATOM     86  O   PRO A   9      21.262  82.309  15.671  1.00  0.00           O  
ATOM     87  CB  PRO A   9      20.630  83.357  18.214  1.00  0.00           C  
ATOM     88  CG  PRO A   9      19.215  83.522  17.777  1.00  0.00           C  
ATOM     89  CD  PRO A   9      19.125  84.898  17.177  1.00  0.00           C  
ATOM     90  HA  PRO A   9      22.288  84.618  17.690  1.00  0.00           H  
ATOM     91  HB2 PRO A   9      20.932  82.320  18.190  1.00  0.00           H  
ATOM     92  HB3 PRO A   9      20.786  83.761  19.203  1.00  0.00           H  
ATOM     93  HG2 PRO A   9      18.969  82.774  17.038  1.00  0.00           H  
ATOM     94  HG3 PRO A   9      18.556  83.441  18.628  1.00  0.00           H  
ATOM     95  HD2 PRO A   9      18.424  84.906  16.356  1.00  0.00           H  
ATOM     96  HD3 PRO A   9      18.837  85.619  17.928  1.00  0.00           H  
ATOM     97  N   SER A  10      23.165  83.509  15.610  1.00  0.00           N  
ATOM     98  CA  SER A  10      23.763  82.711  14.545  1.00  0.00           C  
ATOM     99  C   SER A  10      24.083  81.303  15.036  1.00  0.00           C  
ATOM    100  O   SER A  10      24.810  81.124  16.013  1.00  0.00           O  
ATOM    101  CB  SER A  10      25.035  83.384  14.028  1.00  0.00           C  
ATOM    102  OG  SER A  10      25.988  83.538  15.065  1.00  0.00           O  
ATOM    103  H   SER A  10      23.668  84.264  15.981  1.00  0.00           H  
ATOM    104  HA  SER A  10      23.048  82.645  13.739  1.00  0.00           H  
ATOM    105  HB2 SER A  10      25.468  82.779  13.245  1.00  0.00           H  
ATOM    106  HB3 SER A  10      24.789  84.360  13.634  1.00  0.00           H  
ATOM    107  HG  SER A  10      26.872  83.413  14.710  1.00  0.00           H  
ATOM    108  N   ARG A  11      23.534  80.304  14.350  1.00  0.00           N  
ATOM    109  CA  ARG A  11      23.759  78.911  14.716  1.00  0.00           C  
ATOM    110  C   ARG A  11      24.850  78.291  13.848  1.00  0.00           C  
ATOM    111  O   ARG A  11      24.821  78.401  12.622  1.00  0.00           O  
ATOM    112  CB  ARG A  11      22.465  78.110  14.577  1.00  0.00           C  
ATOM    113  CG  ARG A  11      22.614  76.643  14.946  1.00  0.00           C  
ATOM    114  CD  ARG A  11      21.274  76.022  15.313  1.00  0.00           C  
ATOM    115  NE  ARG A  11      20.470  75.719  14.132  1.00  0.00           N  
ATOM    116  CZ  ARG A  11      19.149  75.581  14.158  1.00  0.00           C  
ATOM    117  NH1 ARG A  11      18.487  75.718  15.299  1.00  0.00           N  
ATOM    118  NH2 ARG A  11      18.487  75.304  13.041  1.00  0.00           N  
ATOM    119  H   ARG A  11      22.964  80.511  13.580  1.00  0.00           H  
ATOM    120  HA  ARG A  11      24.079  78.886  15.747  1.00  0.00           H  
ATOM    121  HB2 ARG A  11      21.714  78.546  15.220  1.00  0.00           H  
ATOM    122  HB3 ARG A  11      22.127  78.169  13.553  1.00  0.00           H  
ATOM    123  HG2 ARG A  11      23.026  76.109  14.103  1.00  0.00           H  
ATOM    124  HG3 ARG A  11      23.282  76.560  15.790  1.00  0.00           H  
ATOM    125  HD2 ARG A  11      21.454  75.109  15.859  1.00  0.00           H  
ATOM    126  HD3 ARG A  11      20.731  76.715  15.939  1.00  0.00           H  
ATOM    127  HE  ARG A  11      20.939  75.613  13.278  1.00  0.00           H  
ATOM    128 HH11 ARG A  11      18.983  75.928  16.141  1.00  0.00           H  
ATOM    129 HH12 ARG A  11      17.493  75.616  15.315  1.00  0.00           H  
ATOM    130 HH21 ARG A  11      18.983  75.200  12.180  1.00  0.00           H  
ATOM    131 HH22 ARG A  11      17.493  75.201  13.062  1.00  0.00           H  
ATOM    132  N   LYS A  12      25.812  77.639  14.493  1.00  0.00           N  
ATOM    133  CA  LYS A  12      26.912  76.999  13.781  1.00  0.00           C  
ATOM    134  C   LYS A  12      26.442  76.435  12.444  1.00  0.00           C  
ATOM    135  O   LYS A  12      27.156  76.504  11.444  1.00  0.00           O  
ATOM    136  CB  LYS A  12      27.516  75.881  14.634  1.00  0.00           C  
ATOM    137  CG  LYS A  12      28.964  75.572  14.294  1.00  0.00           C  
ATOM    138  CD  LYS A  12      29.523  74.474  15.183  1.00  0.00           C  
ATOM    139  CE  LYS A  12      31.043  74.428  15.123  1.00  0.00           C  
ATOM    140  NZ  LYS A  12      31.531  73.933  13.806  1.00  0.00           N  
ATOM    141  H   LYS A  12      25.780  77.585  15.471  1.00  0.00           H  
ATOM    142  HA  LYS A  12      27.667  77.747  13.597  1.00  0.00           H  
ATOM    143  HB2 LYS A  12      27.466  76.170  15.673  1.00  0.00           H  
ATOM    144  HB3 LYS A  12      26.935  74.981  14.490  1.00  0.00           H  
ATOM    145  HG2 LYS A  12      29.023  75.251  13.265  1.00  0.00           H  
ATOM    146  HG3 LYS A  12      29.554  76.467  14.427  1.00  0.00           H  
ATOM    147  HD2 LYS A  12      29.221  74.660  16.204  1.00  0.00           H  
ATOM    148  HD3 LYS A  12      29.130  73.522  14.858  1.00  0.00           H  
ATOM    149  HE2 LYS A  12      31.427  75.423  15.289  1.00  0.00           H  
ATOM    150  HE3 LYS A  12      31.400  73.770  15.901  1.00  0.00           H  
ATOM    151  HZ1 LYS A  12      32.554  74.098  13.720  1.00  0.00           H  
ATOM    152  HZ2 LYS A  12      31.045  74.433  13.035  1.00  0.00           H  
ATOM    153  HZ3 LYS A  12      31.346  72.914  13.716  1.00  0.00           H  
ATOM    154  N   PHE A  13      25.235  75.879  12.434  1.00  0.00           N  
ATOM    155  CA  PHE A  13      24.669  75.304  11.219  1.00  0.00           C  
ATOM    156  C   PHE A  13      23.248  75.811  10.989  1.00  0.00           C  
ATOM    157  O   PHE A  13      22.553  76.191  11.930  1.00  0.00           O  
ATOM    158  CB  PHE A  13      24.669  73.776  11.304  1.00  0.00           C  
ATOM    159  CG  PHE A  13      25.952  73.206  11.841  1.00  0.00           C  
ATOM    160  CD1 PHE A  13      27.066  73.087  11.027  1.00  0.00           C  
ATOM    161  CD2 PHE A  13      26.041  72.790  13.160  1.00  0.00           C  
ATOM    162  CE1 PHE A  13      28.247  72.561  11.519  1.00  0.00           C  
ATOM    163  CE2 PHE A  13      27.220  72.265  13.657  1.00  0.00           C  
ATOM    164  CZ  PHE A  13      28.323  72.151  12.835  1.00  0.00           C  
ATOM    165  H   PHE A  13      24.713  75.853  13.264  1.00  0.00           H  
ATOM    166  HA  PHE A  13      25.287  75.610  10.389  1.00  0.00           H  
ATOM    167  HB2 PHE A  13      23.868  73.458  11.954  1.00  0.00           H  
ATOM    168  HB3 PHE A  13      24.510  73.368  10.318  1.00  0.00           H  
ATOM    169  HD1 PHE A  13      27.007  73.407   9.997  1.00  0.00           H  
ATOM    170  HD2 PHE A  13      25.178  72.879  13.804  1.00  0.00           H  
ATOM    171  HE1 PHE A  13      29.108  72.474  10.874  1.00  0.00           H  
ATOM    172  HE2 PHE A  13      27.276  71.946  14.687  1.00  0.00           H  
ATOM    173  HZ  PHE A  13      29.245  71.742  13.221  1.00  0.00           H  
ATOM    174  N   ALA A  14      22.825  75.812   9.729  1.00  0.00           N  
ATOM    175  CA  ALA A  14      21.487  76.272   9.373  1.00  0.00           C  
ATOM    176  C   ALA A  14      20.558  75.094   9.100  1.00  0.00           C  
ATOM    177  O   ALA A  14      21.001  73.948   9.014  1.00  0.00           O  
ATOM    178  CB  ALA A  14      21.549  77.190   8.162  1.00  0.00           C  
ATOM    179  H   ALA A  14      23.426  75.498   9.022  1.00  0.00           H  
ATOM    180  HA  ALA A  14      21.097  76.839  10.206  1.00  0.00           H  
ATOM    181  HB1 ALA A  14      22.194  76.754   7.414  1.00  0.00           H  
ATOM    182  HB2 ALA A  14      20.557  77.316   7.754  1.00  0.00           H  
ATOM    183  HB3 ALA A  14      21.941  78.151   8.459  1.00  0.00           H  
ATOM    184  N   ASP A  15      19.268  75.383   8.964  1.00  0.00           N  
ATOM    185  CA  ASP A  15      18.277  74.348   8.700  1.00  0.00           C  
ATOM    186  C   ASP A  15      18.327  73.906   7.240  1.00  0.00           C  
ATOM    187  O   ASP A  15      18.215  74.724   6.329  1.00  0.00           O  
ATOM    188  CB  ASP A  15      16.874  74.855   9.044  1.00  0.00           C  
ATOM    189  CG  ASP A  15      16.643  76.277   8.575  1.00  0.00           C  
ATOM    190  OD1 ASP A  15      17.263  77.199   9.144  1.00  0.00           O  
ATOM    191  OD2 ASP A  15      15.840  76.470   7.637  1.00  0.00           O  
ATOM    192  H   ASP A  15      18.977  76.316   9.044  1.00  0.00           H  
ATOM    193  HA  ASP A  15      18.506  73.500   9.328  1.00  0.00           H  
ATOM    194  HB2 ASP A  15      16.142  74.217   8.572  1.00  0.00           H  
ATOM    195  HB3 ASP A  15      16.739  74.821  10.115  1.00  0.00           H  
ATOM    196  N   GLY A  16      18.498  72.605   7.027  1.00  0.00           N  
ATOM    197  CA  GLY A  16      18.563  72.077   5.677  1.00  0.00           C  
ATOM    198  C   GLY A  16      19.985  71.951   5.171  1.00  0.00           C  
ATOM    199  O   GLY A  16      20.284  71.087   4.348  1.00  0.00           O  
ATOM    200  H   GLY A  16      18.582  71.998   7.792  1.00  0.00           H  
ATOM    201  HA2 GLY A  16      18.099  71.102   5.661  1.00  0.00           H  
ATOM    202  HA3 GLY A  16      18.016  72.737   5.018  1.00  0.00           H  
ATOM    203  N   GLU A  17      20.866  72.818   5.662  1.00  0.00           N  
ATOM    204  CA  GLU A  17      22.265  72.801   5.252  1.00  0.00           C  
ATOM    205  C   GLU A  17      22.825  71.381   5.284  1.00  0.00           C  
ATOM    206  O   GLU A  17      22.514  70.600   6.184  1.00  0.00           O  
ATOM    207  CB  GLU A  17      23.097  73.709   6.159  1.00  0.00           C  
ATOM    208  CG  GLU A  17      24.382  74.201   5.515  1.00  0.00           C  
ATOM    209  CD  GLU A  17      24.142  74.881   4.181  1.00  0.00           C  
ATOM    210  OE1 GLU A  17      23.105  75.563   4.039  1.00  0.00           O  
ATOM    211  OE2 GLU A  17      24.991  74.731   3.277  1.00  0.00           O  
ATOM    212  H   GLU A  17      20.568  73.484   6.316  1.00  0.00           H  
ATOM    213  HA  GLU A  17      22.318  73.172   4.240  1.00  0.00           H  
ATOM    214  HB2 GLU A  17      22.503  74.568   6.432  1.00  0.00           H  
ATOM    215  HB3 GLU A  17      23.355  73.163   7.055  1.00  0.00           H  
ATOM    216  HG2 GLU A  17      24.856  74.907   6.179  1.00  0.00           H  
ATOM    217  HG3 GLU A  17      25.038  73.358   5.359  1.00  0.00           H  
ATOM    218  N   VAL A  18      23.650  71.053   4.296  1.00  0.00           N  
ATOM    219  CA  VAL A  18      24.254  69.729   4.211  1.00  0.00           C  
ATOM    220  C   VAL A  18      25.667  69.730   4.784  1.00  0.00           C  
ATOM    221  O   VAL A  18      26.601  70.232   4.160  1.00  0.00           O  
ATOM    222  CB  VAL A  18      24.303  69.226   2.756  1.00  0.00           C  
ATOM    223  CG1 VAL A  18      24.887  67.824   2.694  1.00  0.00           C  
ATOM    224  CG2 VAL A  18      22.915  69.263   2.133  1.00  0.00           C  
ATOM    225  H   VAL A  18      23.859  71.719   3.607  1.00  0.00           H  
ATOM    226  HA  VAL A  18      23.643  69.046   4.784  1.00  0.00           H  
ATOM    227  HB  VAL A  18      24.946  69.885   2.191  1.00  0.00           H  
ATOM    228 HG11 VAL A  18      24.828  67.454   1.681  1.00  0.00           H  
ATOM    229 HG12 VAL A  18      25.920  67.849   3.009  1.00  0.00           H  
ATOM    230 HG13 VAL A  18      24.327  67.172   3.347  1.00  0.00           H  
ATOM    231 HG21 VAL A  18      22.725  70.250   1.739  1.00  0.00           H  
ATOM    232 HG22 VAL A  18      22.860  68.539   1.332  1.00  0.00           H  
ATOM    233 HG23 VAL A  18      22.177  69.026   2.883  1.00  0.00           H  
ATOM    234  N   VAL A  19      25.815  69.164   5.978  1.00  0.00           N  
ATOM    235  CA  VAL A  19      27.114  69.098   6.637  1.00  0.00           C  
ATOM    236  C   VAL A  19      27.537  67.654   6.873  1.00  0.00           C  
ATOM    237  O   VAL A  19      26.779  66.722   6.606  1.00  0.00           O  
ATOM    238  CB  VAL A  19      27.099  69.846   7.983  1.00  0.00           C  
ATOM    239  CG1 VAL A  19      26.627  71.279   7.794  1.00  0.00           C  
ATOM    240  CG2 VAL A  19      26.222  69.115   8.988  1.00  0.00           C  
ATOM    241  H   VAL A  19      25.032  68.781   6.427  1.00  0.00           H  
ATOM    242  HA  VAL A  19      27.839  69.575   5.993  1.00  0.00           H  
ATOM    243  HB  VAL A  19      28.108  69.870   8.370  1.00  0.00           H  
ATOM    244 HG11 VAL A  19      27.482  71.923   7.646  1.00  0.00           H  
ATOM    245 HG12 VAL A  19      25.979  71.334   6.932  1.00  0.00           H  
ATOM    246 HG13 VAL A  19      26.085  71.599   8.672  1.00  0.00           H  
ATOM    247 HG21 VAL A  19      25.910  69.803   9.759  1.00  0.00           H  
ATOM    248 HG22 VAL A  19      25.351  68.720   8.485  1.00  0.00           H  
ATOM    249 HG23 VAL A  19      26.780  68.304   9.431  1.00  0.00           H  
ATOM    250  N   ARG A  20      28.754  67.474   7.378  1.00  0.00           N  
ATOM    251  CA  ARG A  20      29.279  66.142   7.651  1.00  0.00           C  
ATOM    252  C   ARG A  20      29.094  65.775   9.121  1.00  0.00           C  
ATOM    253  O   ARG A  20      29.614  66.448  10.010  1.00  0.00           O  
ATOM    254  CB  ARG A  20      30.761  66.069   7.279  1.00  0.00           C  
ATOM    255  CG  ARG A  20      31.067  66.599   5.888  1.00  0.00           C  
ATOM    256  CD  ARG A  20      30.709  65.584   4.813  1.00  0.00           C  
ATOM    257  NE  ARG A  20      31.207  65.979   3.500  1.00  0.00           N  
ATOM    258  CZ  ARG A  20      32.475  65.850   3.124  1.00  0.00           C  
ATOM    259  NH1 ARG A  20      33.368  65.337   3.960  1.00  0.00           N  
ATOM    260  NH2 ARG A  20      32.851  66.232   1.911  1.00  0.00           N  
ATOM    261  H   ARG A  20      29.312  68.256   7.571  1.00  0.00           H  
ATOM    262  HA  ARG A  20      28.730  65.438   7.044  1.00  0.00           H  
ATOM    263  HB2 ARG A  20      31.328  66.646   7.993  1.00  0.00           H  
ATOM    264  HB3 ARG A  20      31.081  65.039   7.327  1.00  0.00           H  
ATOM    265  HG2 ARG A  20      30.493  67.499   5.722  1.00  0.00           H  
ATOM    266  HG3 ARG A  20      32.120  66.823   5.822  1.00  0.00           H  
ATOM    267  HD2 ARG A  20      31.141  64.630   5.080  1.00  0.00           H  
ATOM    268  HD3 ARG A  20      29.634  65.491   4.769  1.00  0.00           H  
ATOM    269  HE  ARG A  20      30.564  66.360   2.866  1.00  0.00           H  
ATOM    270 HH11 ARG A  20      33.086  65.048   4.874  1.00  0.00           H  
ATOM    271 HH12 ARG A  20      34.321  65.240   3.674  1.00  0.00           H  
ATOM    272 HH21 ARG A  20      32.181  66.618   1.278  1.00  0.00           H  
ATOM    273 HH22 ARG A  20      33.805  66.135   1.629  1.00  0.00           H  
ATOM    274  N   GLY A  21      28.348  64.702   9.368  1.00  0.00           N  
ATOM    275  CA  GLY A  21      28.107  64.265  10.732  1.00  0.00           C  
ATOM    276  C   GLY A  21      28.810  62.963  11.055  1.00  0.00           C  
ATOM    277  O   GLY A  21      28.885  62.065  10.216  1.00  0.00           O  
ATOM    278  H   GLY A  21      27.958  64.204   8.620  1.00  0.00           H  
ATOM    279  HA2 GLY A  21      28.455  65.029  11.410  1.00  0.00           H  
ATOM    280  HA3 GLY A  21      27.044  64.132  10.871  1.00  0.00           H  
ATOM    281  N   ARG A  22      29.328  62.859  12.274  1.00  0.00           N  
ATOM    282  CA  ARG A  22      30.032  61.657  12.707  1.00  0.00           C  
ATOM    283  C   ARG A  22      29.066  60.661  13.342  1.00  0.00           C  
ATOM    284  O   ARG A  22      28.649  60.830  14.488  1.00  0.00           O  
ATOM    285  CB  ARG A  22      31.138  62.017  13.701  1.00  0.00           C  
ATOM    286  CG  ARG A  22      32.106  60.878  13.972  1.00  0.00           C  
ATOM    287  CD  ARG A  22      33.185  61.289  14.962  1.00  0.00           C  
ATOM    288  NE  ARG A  22      34.373  60.447  14.858  1.00  0.00           N  
ATOM    289  CZ  ARG A  22      35.320  60.390  15.788  1.00  0.00           C  
ATOM    290  NH1 ARG A  22      35.216  61.124  16.887  1.00  0.00           N  
ATOM    291  NH2 ARG A  22      36.372  59.599  15.620  1.00  0.00           N  
ATOM    292  H   ARG A  22      29.236  63.609  12.900  1.00  0.00           H  
ATOM    293  HA  ARG A  22      30.477  61.202  11.835  1.00  0.00           H  
ATOM    294  HB2 ARG A  22      31.699  62.853  13.310  1.00  0.00           H  
ATOM    295  HB3 ARG A  22      30.683  62.305  14.636  1.00  0.00           H  
ATOM    296  HG2 ARG A  22      31.559  60.041  14.380  1.00  0.00           H  
ATOM    297  HG3 ARG A  22      32.574  60.587  13.042  1.00  0.00           H  
ATOM    298  HD2 ARG A  22      33.464  62.314  14.766  1.00  0.00           H  
ATOM    299  HD3 ARG A  22      32.786  61.209  15.962  1.00  0.00           H  
ATOM    300  HE  ARG A  22      34.471  59.896  14.053  1.00  0.00           H  
ATOM    301 HH11 ARG A  22      34.424  61.721  17.016  1.00  0.00           H  
ATOM    302 HH12 ARG A  22      35.929  61.080  17.587  1.00  0.00           H  
ATOM    303 HH21 ARG A  22      36.453  59.046  14.793  1.00  0.00           H  
ATOM    304 HH22 ARG A  22      37.083  59.559  16.322  1.00  0.00           H  
ATOM    305  N   TRP A  23      28.716  59.623  12.590  1.00  0.00           N  
ATOM    306  CA  TRP A  23      27.799  58.600  13.079  1.00  0.00           C  
ATOM    307  C   TRP A  23      28.322  57.971  14.365  1.00  0.00           C  
ATOM    308  O   TRP A  23      29.520  57.730  14.525  1.00  0.00           O  
ATOM    309  CB  TRP A  23      27.592  57.521  12.017  1.00  0.00           C  
ATOM    310  CG  TRP A  23      26.671  56.422  12.456  1.00  0.00           C  
ATOM    311  CD1 TRP A  23      26.950  55.428  13.348  1.00  0.00           C  
ATOM    312  CD2 TRP A  23      25.325  56.208  12.020  1.00  0.00           C  
ATOM    313  NE1 TRP A  23      25.857  54.607  13.494  1.00  0.00           N  
ATOM    314  CE2 TRP A  23      24.847  55.065  12.691  1.00  0.00           C  
ATOM    315  CE3 TRP A  23      24.475  56.871  11.130  1.00  0.00           C  
ATOM    316  CZ2 TRP A  23      23.559  54.573  12.498  1.00  0.00           C  
ATOM    317  CZ3 TRP A  23      23.197  56.381  10.939  1.00  0.00           C  
ATOM    318  CH2 TRP A  23      22.748  55.242  11.620  1.00  0.00           C  
ATOM    319  H   TRP A  23      29.081  59.543  11.684  1.00  0.00           H  
ATOM    320  HA  TRP A  23      26.852  59.076  13.285  1.00  0.00           H  
ATOM    321  HB2 TRP A  23      27.172  57.972  11.130  1.00  0.00           H  
ATOM    322  HB3 TRP A  23      28.547  57.078  11.773  1.00  0.00           H  
ATOM    323  HD1 TRP A  23      27.896  55.313  13.857  1.00  0.00           H  
ATOM    324  HE1 TRP A  23      25.809  53.823  14.080  1.00  0.00           H  
ATOM    325  HE3 TRP A  23      24.802  57.751  10.596  1.00  0.00           H  
ATOM    326  HZ2 TRP A  23      23.198  53.696  13.016  1.00  0.00           H  
ATOM    327  HZ3 TRP A  23      22.526  56.880  10.255  1.00  0.00           H  
ATOM    328  HH2 TRP A  23      21.743  54.895  11.441  1.00  0.00           H  
ATOM    329  N   PRO A  24      27.408  57.696  15.307  1.00  0.00           N  
ATOM    330  CA  PRO A  24      27.754  57.089  16.596  1.00  0.00           C  
ATOM    331  C   PRO A  24      28.188  55.635  16.453  1.00  0.00           C  
ATOM    332  O   PRO A  24      27.389  54.770  16.097  1.00  0.00           O  
ATOM    333  CB  PRO A  24      26.452  57.183  17.394  1.00  0.00           C  
ATOM    334  CG  PRO A  24      25.377  57.226  16.363  1.00  0.00           C  
ATOM    335  CD  PRO A  24      25.963  57.955  15.185  1.00  0.00           C  
ATOM    336  HA  PRO A  24      28.530  57.647  17.100  1.00  0.00           H  
ATOM    337  HB2 PRO A  24      26.354  56.317  18.032  1.00  0.00           H  
ATOM    338  HB3 PRO A  24      26.458  58.080  17.995  1.00  0.00           H  
ATOM    339  HG2 PRO A  24      25.099  56.223  16.082  1.00  0.00           H  
ATOM    340  HG3 PRO A  24      24.522  57.762  16.747  1.00  0.00           H  
ATOM    341  HD2 PRO A  24      25.575  57.553  14.261  1.00  0.00           H  
ATOM    342  HD3 PRO A  24      25.755  59.013  15.255  1.00  0.00           H  
ATOM    343  N   GLY A  25      29.461  55.371  16.736  1.00  0.00           N  
ATOM    344  CA  GLY A  25      29.978  54.019  16.634  1.00  0.00           C  
ATOM    345  C   GLY A  25      30.879  53.831  15.428  1.00  0.00           C  
ATOM    346  O   GLY A  25      31.879  53.118  15.498  1.00  0.00           O  
ATOM    347  H   GLY A  25      30.052  56.100  17.016  1.00  0.00           H  
ATOM    348  HA2 GLY A  25      30.539  53.791  17.528  1.00  0.00           H  
ATOM    349  HA3 GLY A  25      29.147  53.333  16.558  1.00  0.00           H  
ATOM    350  N   SER A  26      30.521  54.473  14.321  1.00  0.00           N  
ATOM    351  CA  SER A  26      31.302  54.370  13.093  1.00  0.00           C  
ATOM    352  C   SER A  26      32.502  55.311  13.131  1.00  0.00           C  
ATOM    353  O   SER A  26      33.490  55.103  12.428  1.00  0.00           O  
ATOM    354  CB  SER A  26      30.428  54.691  11.880  1.00  0.00           C  
ATOM    355  OG  SER A  26      30.868  53.985  10.732  1.00  0.00           O  
ATOM    356  H   SER A  26      29.713  55.027  14.328  1.00  0.00           H  
ATOM    357  HA  SER A  26      31.658  53.354  13.011  1.00  0.00           H  
ATOM    358  HB2 SER A  26      29.406  54.410  12.090  1.00  0.00           H  
ATOM    359  HB3 SER A  26      30.474  55.751  11.676  1.00  0.00           H  
ATOM    360  HG  SER A  26      30.480  53.107  10.727  1.00  0.00           H  
ATOM    361  N   SER A  27      32.408  56.347  13.959  1.00  0.00           N  
ATOM    362  CA  SER A  27      33.484  57.323  14.088  1.00  0.00           C  
ATOM    363  C   SER A  27      33.905  57.850  12.720  1.00  0.00           C  
ATOM    364  O   SER A  27      35.076  58.160  12.494  1.00  0.00           O  
ATOM    365  CB  SER A  27      34.687  56.697  14.797  1.00  0.00           C  
ATOM    366  OG  SER A  27      35.275  55.680  14.004  1.00  0.00           O  
ATOM    367  H   SER A  27      31.595  56.458  14.494  1.00  0.00           H  
ATOM    368  HA  SER A  27      33.116  58.146  14.680  1.00  0.00           H  
ATOM    369  HB2 SER A  27      35.425  57.460  14.990  1.00  0.00           H  
ATOM    370  HB3 SER A  27      34.364  56.265  15.734  1.00  0.00           H  
ATOM    371  HG  SER A  27      35.087  55.848  13.078  1.00  0.00           H  
ATOM    372  N   LEU A  28      32.943  57.951  11.810  1.00  0.00           N  
ATOM    373  CA  LEU A  28      33.213  58.440  10.462  1.00  0.00           C  
ATOM    374  C   LEU A  28      32.223  59.535  10.074  1.00  0.00           C  
ATOM    375  O   LEU A  28      31.024  59.419  10.323  1.00  0.00           O  
ATOM    376  CB  LEU A  28      33.138  57.292   9.455  1.00  0.00           C  
ATOM    377  CG  LEU A  28      34.283  56.278   9.509  1.00  0.00           C  
ATOM    378  CD1 LEU A  28      34.018  55.123   8.556  1.00  0.00           C  
ATOM    379  CD2 LEU A  28      35.607  56.951   9.181  1.00  0.00           C  
ATOM    380  H   LEU A  28      32.030  57.688  12.048  1.00  0.00           H  
ATOM    381  HA  LEU A  28      34.210  58.853  10.453  1.00  0.00           H  
ATOM    382  HB2 LEU A  28      32.217  56.758   9.630  1.00  0.00           H  
ATOM    383  HB3 LEU A  28      33.123  57.721   8.464  1.00  0.00           H  
ATOM    384  HG  LEU A  28      34.351  55.874  10.510  1.00  0.00           H  
ATOM    385 HD11 LEU A  28      33.075  54.660   8.804  1.00  0.00           H  
ATOM    386 HD12 LEU A  28      34.811  54.395   8.644  1.00  0.00           H  
ATOM    387 HD13 LEU A  28      33.981  55.495   7.542  1.00  0.00           H  
ATOM    388 HD21 LEU A  28      36.190  56.304   8.541  1.00  0.00           H  
ATOM    389 HD22 LEU A  28      36.151  57.139  10.094  1.00  0.00           H  
ATOM    390 HD23 LEU A  28      35.420  57.885   8.673  1.00  0.00           H  
ATOM    391  N   TYR A  29      32.736  60.597   9.460  1.00  0.00           N  
ATOM    392  CA  TYR A  29      31.899  61.713   9.037  1.00  0.00           C  
ATOM    393  C   TYR A  29      31.218  61.410   7.705  1.00  0.00           C  
ATOM    394  O   TYR A  29      31.880  61.091   6.716  1.00  0.00           O  
ATOM    395  CB  TYR A  29      32.734  62.988   8.918  1.00  0.00           C  
ATOM    396  CG  TYR A  29      33.368  63.421  10.220  1.00  0.00           C  
ATOM    397  CD1 TYR A  29      32.632  64.103  11.181  1.00  0.00           C  
ATOM    398  CD2 TYR A  29      34.704  63.148  10.490  1.00  0.00           C  
ATOM    399  CE1 TYR A  29      33.207  64.500  12.373  1.00  0.00           C  
ATOM    400  CE2 TYR A  29      35.287  63.541  11.679  1.00  0.00           C  
ATOM    401  CZ  TYR A  29      34.535  64.217  12.617  1.00  0.00           C  
ATOM    402  OH  TYR A  29      35.112  64.611  13.802  1.00  0.00           O  
ATOM    403  H   TYR A  29      33.700  60.631   9.288  1.00  0.00           H  
ATOM    404  HA  TYR A  29      31.138  61.862   9.790  1.00  0.00           H  
ATOM    405  HB2 TYR A  29      33.525  62.826   8.202  1.00  0.00           H  
ATOM    406  HB3 TYR A  29      32.102  63.793   8.573  1.00  0.00           H  
ATOM    407  HD1 TYR A  29      31.592  64.324  10.987  1.00  0.00           H  
ATOM    408  HD2 TYR A  29      35.290  62.619   9.752  1.00  0.00           H  
ATOM    409  HE1 TYR A  29      32.618  65.030  13.108  1.00  0.00           H  
ATOM    410  HE2 TYR A  29      36.326  63.320  11.870  1.00  0.00           H  
ATOM    411  HH  TYR A  29      34.429  64.908  14.408  1.00  0.00           H  
ATOM    412  N   TYR A  30      29.895  61.513   7.687  1.00  0.00           N  
ATOM    413  CA  TYR A  30      29.124  61.248   6.478  1.00  0.00           C  
ATOM    414  C   TYR A  30      28.276  62.459   6.096  1.00  0.00           C  
ATOM    415  O   TYR A  30      28.046  63.350   6.913  1.00  0.00           O  
ATOM    416  CB  TYR A  30      28.227  60.026   6.677  1.00  0.00           C  
ATOM    417  CG  TYR A  30      28.994  58.744   6.912  1.00  0.00           C  
ATOM    418  CD1 TYR A  30      29.506  58.014   5.847  1.00  0.00           C  
ATOM    419  CD2 TYR A  30      29.203  58.263   8.199  1.00  0.00           C  
ATOM    420  CE1 TYR A  30      30.208  56.841   6.057  1.00  0.00           C  
ATOM    421  CE2 TYR A  30      29.904  57.092   8.417  1.00  0.00           C  
ATOM    422  CZ  TYR A  30      30.403  56.385   7.344  1.00  0.00           C  
ATOM    423  OH  TYR A  30      31.101  55.218   7.558  1.00  0.00           O  
ATOM    424  H   TYR A  30      29.423  61.771   8.507  1.00  0.00           H  
ATOM    425  HA  TYR A  30      29.820  61.044   5.678  1.00  0.00           H  
ATOM    426  HB2 TYR A  30      27.589  60.191   7.532  1.00  0.00           H  
ATOM    427  HB3 TYR A  30      27.614  59.890   5.797  1.00  0.00           H  
ATOM    428  HD1 TYR A  30      29.352  58.373   4.841  1.00  0.00           H  
ATOM    429  HD2 TYR A  30      28.810  58.819   9.037  1.00  0.00           H  
ATOM    430  HE1 TYR A  30      30.599  56.288   5.217  1.00  0.00           H  
ATOM    431  HE2 TYR A  30      30.056  56.735   9.425  1.00  0.00           H  
ATOM    432  HH  TYR A  30      30.485  54.485   7.622  1.00  0.00           H  
ATOM    433  N   GLU A  31      27.815  62.480   4.850  1.00  0.00           N  
ATOM    434  CA  GLU A  31      26.992  63.581   4.360  1.00  0.00           C  
ATOM    435  C   GLU A  31      25.587  63.514   4.951  1.00  0.00           C  
ATOM    436  O   GLU A  31      24.784  62.659   4.578  1.00  0.00           O  
ATOM    437  CB  GLU A  31      26.918  63.549   2.833  1.00  0.00           C  
ATOM    438  CG  GLU A  31      25.980  64.591   2.247  1.00  0.00           C  
ATOM    439  CD  GLU A  31      26.010  64.618   0.732  1.00  0.00           C  
ATOM    440  OE1 GLU A  31      27.090  64.376   0.154  1.00  0.00           O  
ATOM    441  OE2 GLU A  31      24.951  64.881   0.122  1.00  0.00           O  
ATOM    442  H   GLU A  31      28.032  61.740   4.247  1.00  0.00           H  
ATOM    443  HA  GLU A  31      27.456  64.504   4.670  1.00  0.00           H  
ATOM    444  HB2 GLU A  31      27.906  63.719   2.432  1.00  0.00           H  
ATOM    445  HB3 GLU A  31      26.576  62.573   2.521  1.00  0.00           H  
ATOM    446  HG2 GLU A  31      24.972  64.371   2.568  1.00  0.00           H  
ATOM    447  HG3 GLU A  31      26.269  65.564   2.616  1.00  0.00           H  
ATOM    448  N   VAL A  32      25.296  64.424   5.876  1.00  0.00           N  
ATOM    449  CA  VAL A  32      23.988  64.470   6.518  1.00  0.00           C  
ATOM    450  C   VAL A  32      23.367  65.858   6.401  1.00  0.00           C  
ATOM    451  O   VAL A  32      24.064  66.839   6.145  1.00  0.00           O  
ATOM    452  CB  VAL A  32      24.079  64.085   8.006  1.00  0.00           C  
ATOM    453  CG1 VAL A  32      24.607  62.666   8.158  1.00  0.00           C  
ATOM    454  CG2 VAL A  32      24.957  65.073   8.760  1.00  0.00           C  
ATOM    455  H   VAL A  32      25.977  65.080   6.131  1.00  0.00           H  
ATOM    456  HA  VAL A  32      23.347  63.757   6.021  1.00  0.00           H  
ATOM    457  HB  VAL A  32      23.086  64.123   8.429  1.00  0.00           H  
ATOM    458 HG11 VAL A  32      25.140  62.578   9.094  1.00  0.00           H  
ATOM    459 HG12 VAL A  32      23.780  61.971   8.147  1.00  0.00           H  
ATOM    460 HG13 VAL A  32      25.277  62.442   7.342  1.00  0.00           H  
ATOM    461 HG21 VAL A  32      25.980  64.965   8.431  1.00  0.00           H  
ATOM    462 HG22 VAL A  32      24.620  66.079   8.561  1.00  0.00           H  
ATOM    463 HG23 VAL A  32      24.895  64.875   9.819  1.00  0.00           H  
ATOM    464  N   GLU A  33      22.054  65.930   6.592  1.00  0.00           N  
ATOM    465  CA  GLU A  33      21.339  67.199   6.507  1.00  0.00           C  
ATOM    466  C   GLU A  33      20.869  67.652   7.887  1.00  0.00           C  
ATOM    467  O   GLU A  33      20.574  66.829   8.753  1.00  0.00           O  
ATOM    468  CB  GLU A  33      20.141  67.073   5.564  1.00  0.00           C  
ATOM    469  CG  GLU A  33      19.085  68.145   5.775  1.00  0.00           C  
ATOM    470  CD  GLU A  33      18.029  68.146   4.687  1.00  0.00           C  
ATOM    471  OE1 GLU A  33      17.573  67.048   4.303  1.00  0.00           O  
ATOM    472  OE2 GLU A  33      17.659  69.243   4.220  1.00  0.00           O  
ATOM    473  H   GLU A  33      21.553  65.112   6.793  1.00  0.00           H  
ATOM    474  HA  GLU A  33      22.020  67.938   6.113  1.00  0.00           H  
ATOM    475  HB2 GLU A  33      20.492  67.139   4.545  1.00  0.00           H  
ATOM    476  HB3 GLU A  33      19.680  66.108   5.715  1.00  0.00           H  
ATOM    477  HG2 GLU A  33      18.601  67.973   6.725  1.00  0.00           H  
ATOM    478  HG3 GLU A  33      19.568  69.111   5.789  1.00  0.00           H  
ATOM    479  N   ILE A  34      20.803  68.964   8.082  1.00  0.00           N  
ATOM    480  CA  ILE A  34      20.369  69.526   9.354  1.00  0.00           C  
ATOM    481  C   ILE A  34      18.848  69.590   9.437  1.00  0.00           C  
ATOM    482  O   ILE A  34      18.194  70.200   8.589  1.00  0.00           O  
ATOM    483  CB  ILE A  34      20.944  70.938   9.572  1.00  0.00           C  
ATOM    484  CG1 ILE A  34      22.472  70.907   9.501  1.00  0.00           C  
ATOM    485  CG2 ILE A  34      20.481  71.499  10.909  1.00  0.00           C  
ATOM    486  CD1 ILE A  34      23.116  70.193  10.668  1.00  0.00           C  
ATOM    487  H   ILE A  34      21.052  69.569   7.352  1.00  0.00           H  
ATOM    488  HA  ILE A  34      20.735  68.885  10.144  1.00  0.00           H  
ATOM    489  HB  ILE A  34      20.567  71.580   8.790  1.00  0.00           H  
ATOM    490 HG12 ILE A  34      22.773  70.403   8.597  1.00  0.00           H  
ATOM    491 HG13 ILE A  34      22.844  71.922   9.485  1.00  0.00           H  
ATOM    492 HG21 ILE A  34      19.546  71.034  11.189  1.00  0.00           H  
ATOM    493 HG22 ILE A  34      21.225  71.291  11.662  1.00  0.00           H  
ATOM    494 HG23 ILE A  34      20.341  72.565  10.823  1.00  0.00           H  
ATOM    495 HD11 ILE A  34      23.903  69.548  10.306  1.00  0.00           H  
ATOM    496 HD12 ILE A  34      23.530  70.919  11.352  1.00  0.00           H  
ATOM    497 HD13 ILE A  34      22.373  69.599  11.182  1.00  0.00           H  
ATOM    498  N   LEU A  35      18.289  68.959  10.464  1.00  0.00           N  
ATOM    499  CA  LEU A  35      16.844  68.945  10.658  1.00  0.00           C  
ATOM    500  C   LEU A  35      16.442  69.850  11.820  1.00  0.00           C  
ATOM    501  O   LEU A  35      15.576  70.713  11.676  1.00  0.00           O  
ATOM    502  CB  LEU A  35      16.357  67.519  10.918  1.00  0.00           C  
ATOM    503  CG  LEU A  35      16.895  66.444   9.972  1.00  0.00           C  
ATOM    504  CD1 LEU A  35      16.484  65.059  10.448  1.00  0.00           C  
ATOM    505  CD2 LEU A  35      16.403  66.689   8.553  1.00  0.00           C  
ATOM    506  H   LEU A  35      18.861  68.490  11.106  1.00  0.00           H  
ATOM    507  HA  LEU A  35      16.384  69.315   9.754  1.00  0.00           H  
ATOM    508  HB2 LEU A  35      16.646  67.248  11.922  1.00  0.00           H  
ATOM    509  HB3 LEU A  35      15.279  67.518  10.843  1.00  0.00           H  
ATOM    510  HG  LEU A  35      17.975  66.487   9.965  1.00  0.00           H  
ATOM    511 HD11 LEU A  35      17.358  64.429  10.520  1.00  0.00           H  
ATOM    512 HD12 LEU A  35      15.786  64.629   9.746  1.00  0.00           H  
ATOM    513 HD13 LEU A  35      16.016  65.137  11.419  1.00  0.00           H  
ATOM    514 HD21 LEU A  35      15.485  67.258   8.584  1.00  0.00           H  
ATOM    515 HD22 LEU A  35      16.222  65.741   8.066  1.00  0.00           H  
ATOM    516 HD23 LEU A  35      17.151  67.239   8.003  1.00  0.00           H  
ATOM    517  N   SER A  36      17.079  69.648  12.968  1.00  0.00           N  
ATOM    518  CA  SER A  36      16.787  70.444  14.154  1.00  0.00           C  
ATOM    519  C   SER A  36      18.025  70.579  15.037  1.00  0.00           C  
ATOM    520  O   SER A  36      19.047  69.936  14.794  1.00  0.00           O  
ATOM    521  CB  SER A  36      15.645  69.812  14.951  1.00  0.00           C  
ATOM    522  OG  SER A  36      14.928  70.793  15.680  1.00  0.00           O  
ATOM    523  H   SER A  36      17.760  68.944  13.019  1.00  0.00           H  
ATOM    524  HA  SER A  36      16.485  71.428  13.827  1.00  0.00           H  
ATOM    525  HB2 SER A  36      14.967  69.318  14.272  1.00  0.00           H  
ATOM    526  HB3 SER A  36      16.050  69.089  15.644  1.00  0.00           H  
ATOM    527  HG  SER A  36      15.401  70.999  16.490  1.00  0.00           H  
ATOM    528  N   HIS A  37      17.925  71.418  16.062  1.00  0.00           N  
ATOM    529  CA  HIS A  37      19.034  71.636  16.983  1.00  0.00           C  
ATOM    530  C   HIS A  37      18.532  71.786  18.415  1.00  0.00           C  
ATOM    531  O   HIS A  37      17.867  72.767  18.751  1.00  0.00           O  
ATOM    532  CB  HIS A  37      19.825  72.880  16.575  1.00  0.00           C  
ATOM    533  CG  HIS A  37      20.560  73.522  17.711  1.00  0.00           C  
ATOM    534  ND1 HIS A  37      21.370  72.818  18.577  1.00  0.00           N  
ATOM    535  CD2 HIS A  37      20.604  74.811  18.121  1.00  0.00           C  
ATOM    536  CE1 HIS A  37      21.880  73.647  19.471  1.00  0.00           C  
ATOM    537  NE2 HIS A  37      21.431  74.862  19.216  1.00  0.00           N  
ATOM    538  H   HIS A  37      17.084  71.901  16.204  1.00  0.00           H  
ATOM    539  HA  HIS A  37      19.684  70.776  16.930  1.00  0.00           H  
ATOM    540  HB2 HIS A  37      20.551  72.607  15.823  1.00  0.00           H  
ATOM    541  HB3 HIS A  37      19.145  73.612  16.163  1.00  0.00           H  
ATOM    542  HD1 HIS A  37      21.544  71.855  18.542  1.00  0.00           H  
ATOM    543  HD2 HIS A  37      20.085  75.646  17.671  1.00  0.00           H  
ATOM    544  HE1 HIS A  37      22.551  73.377  20.273  1.00  0.00           H  
ATOM    545  HE2 HIS A  37      21.586  75.650  19.778  1.00  0.00           H  
ATOM    546  N   ASP A  38      18.852  70.807  19.255  1.00  0.00           N  
ATOM    547  CA  ASP A  38      18.433  70.830  20.651  1.00  0.00           C  
ATOM    548  C   ASP A  38      19.475  71.527  21.520  1.00  0.00           C  
ATOM    549  O   ASP A  38      20.634  71.115  21.567  1.00  0.00           O  
ATOM    550  CB  ASP A  38      18.197  69.407  21.158  1.00  0.00           C  
ATOM    551  CG  ASP A  38      16.933  68.791  20.591  1.00  0.00           C  
ATOM    552  OD1 ASP A  38      16.725  68.889  19.364  1.00  0.00           O  
ATOM    553  OD2 ASP A  38      16.151  68.213  21.375  1.00  0.00           O  
ATOM    554  H   ASP A  38      19.383  70.051  18.927  1.00  0.00           H  
ATOM    555  HA  ASP A  38      17.506  71.381  20.711  1.00  0.00           H  
ATOM    556  HB2 ASP A  38      19.035  68.787  20.874  1.00  0.00           H  
ATOM    557  HB3 ASP A  38      18.116  69.424  22.236  1.00  0.00           H  
ATOM    558  N   SER A  39      19.054  72.585  22.205  1.00  0.00           N  
ATOM    559  CA  SER A  39      19.952  73.343  23.069  1.00  0.00           C  
ATOM    560  C   SER A  39      20.137  72.640  24.411  1.00  0.00           C  
ATOM    561  O   SER A  39      21.215  72.683  25.005  1.00  0.00           O  
ATOM    562  CB  SER A  39      19.411  74.756  23.290  1.00  0.00           C  
ATOM    563  OG  SER A  39      20.451  75.654  23.636  1.00  0.00           O  
ATOM    564  H   SER A  39      18.119  72.864  22.127  1.00  0.00           H  
ATOM    565  HA  SER A  39      20.912  73.408  22.576  1.00  0.00           H  
ATOM    566  HB2 SER A  39      18.938  75.104  22.384  1.00  0.00           H  
ATOM    567  HB3 SER A  39      18.686  74.738  24.092  1.00  0.00           H  
ATOM    568  HG  SER A  39      20.727  75.492  24.541  1.00  0.00           H  
ATOM    569  N   THR A  40      19.077  71.994  24.884  1.00  0.00           N  
ATOM    570  CA  THR A  40      19.118  71.283  26.155  1.00  0.00           C  
ATOM    571  C   THR A  40      20.420  70.503  26.306  1.00  0.00           C  
ATOM    572  O   THR A  40      21.140  70.663  27.292  1.00  0.00           O  
ATOM    573  CB  THR A  40      17.932  70.311  26.296  1.00  0.00           C  
ATOM    574  OG1 THR A  40      16.697  71.021  26.140  1.00  0.00           O  
ATOM    575  CG2 THR A  40      17.957  69.618  27.649  1.00  0.00           C  
ATOM    576  H   THR A  40      18.245  71.997  24.364  1.00  0.00           H  
ATOM    577  HA  THR A  40      19.054  72.014  26.949  1.00  0.00           H  
ATOM    578  HB  THR A  40      18.007  69.561  25.522  1.00  0.00           H  
ATOM    579  HG1 THR A  40      16.198  70.639  25.414  1.00  0.00           H  
ATOM    580 HG21 THR A  40      17.372  70.187  28.357  1.00  0.00           H  
ATOM    581 HG22 THR A  40      18.977  69.548  27.999  1.00  0.00           H  
ATOM    582 HG23 THR A  40      17.540  68.627  27.554  1.00  0.00           H  
ATOM    583  N   SER A  41      20.716  69.659  25.323  1.00  0.00           N  
ATOM    584  CA  SER A  41      21.929  68.852  25.348  1.00  0.00           C  
ATOM    585  C   SER A  41      22.792  69.129  24.120  1.00  0.00           C  
ATOM    586  O   SER A  41      23.604  68.295  23.719  1.00  0.00           O  
ATOM    587  CB  SER A  41      21.577  67.365  25.413  1.00  0.00           C  
ATOM    588  OG  SER A  41      21.038  67.023  26.679  1.00  0.00           O  
ATOM    589  H   SER A  41      20.101  69.577  24.563  1.00  0.00           H  
ATOM    590  HA  SER A  41      22.488  69.121  26.233  1.00  0.00           H  
ATOM    591  HB2 SER A  41      20.847  67.137  24.652  1.00  0.00           H  
ATOM    592  HB3 SER A  41      22.469  66.778  25.245  1.00  0.00           H  
ATOM    593  HG  SER A  41      21.358  67.642  27.340  1.00  0.00           H  
ATOM    594  N   GLN A  42      22.607  70.304  23.529  1.00  0.00           N  
ATOM    595  CA  GLN A  42      23.367  70.691  22.346  1.00  0.00           C  
ATOM    596  C   GLN A  42      23.408  69.555  21.329  1.00  0.00           C  
ATOM    597  O   GLN A  42      24.412  69.358  20.642  1.00  0.00           O  
ATOM    598  CB  GLN A  42      24.791  71.093  22.736  1.00  0.00           C  
ATOM    599  CG  GLN A  42      24.859  72.375  23.550  1.00  0.00           C  
ATOM    600  CD  GLN A  42      24.682  73.617  22.699  1.00  0.00           C  
ATOM    601  OE1 GLN A  42      25.195  73.697  21.583  1.00  0.00           O  
ATOM    602  NE2 GLN A  42      23.951  74.594  23.223  1.00  0.00           N  
ATOM    603  H   GLN A  42      21.945  70.925  23.895  1.00  0.00           H  
ATOM    604  HA  GLN A  42      22.874  71.540  21.897  1.00  0.00           H  
ATOM    605  HB2 GLN A  42      25.229  70.297  23.320  1.00  0.00           H  
ATOM    606  HB3 GLN A  42      25.373  71.231  21.837  1.00  0.00           H  
ATOM    607  HG2 GLN A  42      24.079  72.354  24.296  1.00  0.00           H  
ATOM    608  HG3 GLN A  42      25.821  72.424  24.039  1.00  0.00           H  
ATOM    609 HE21 GLN A  42      23.574  74.461  24.119  1.00  0.00           H  
ATOM    610 HE22 GLN A  42      23.822  75.409  22.696  1.00  0.00           H  
ATOM    611  N   LEU A  43      22.313  68.808  21.239  1.00  0.00           N  
ATOM    612  CA  LEU A  43      22.224  67.690  20.306  1.00  0.00           C  
ATOM    613  C   LEU A  43      21.499  68.103  19.029  1.00  0.00           C  
ATOM    614  O   LEU A  43      20.339  68.513  19.067  1.00  0.00           O  
ATOM    615  CB  LEU A  43      21.498  66.512  20.959  1.00  0.00           C  
ATOM    616  CG  LEU A  43      22.297  65.725  21.999  1.00  0.00           C  
ATOM    617  CD1 LEU A  43      21.389  64.771  22.760  1.00  0.00           C  
ATOM    618  CD2 LEU A  43      23.434  64.964  21.332  1.00  0.00           C  
ATOM    619  H   LEU A  43      21.546  69.013  21.813  1.00  0.00           H  
ATOM    620  HA  LEU A  43      23.229  67.388  20.055  1.00  0.00           H  
ATOM    621  HB2 LEU A  43      20.614  66.897  21.445  1.00  0.00           H  
ATOM    622  HB3 LEU A  43      21.208  65.827  20.175  1.00  0.00           H  
ATOM    623  HG  LEU A  43      22.727  66.415  22.711  1.00  0.00           H  
ATOM    624 HD11 LEU A  43      21.913  63.845  22.943  1.00  0.00           H  
ATOM    625 HD12 LEU A  43      20.503  64.574  22.175  1.00  0.00           H  
ATOM    626 HD13 LEU A  43      21.107  65.218  23.702  1.00  0.00           H  
ATOM    627 HD21 LEU A  43      24.349  65.530  21.426  1.00  0.00           H  
ATOM    628 HD22 LEU A  43      23.206  64.819  20.287  1.00  0.00           H  
ATOM    629 HD23 LEU A  43      23.555  64.004  21.811  1.00  0.00           H  
ATOM    630  N   TYR A  44      22.190  67.990  17.900  1.00  0.00           N  
ATOM    631  CA  TYR A  44      21.613  68.351  16.611  1.00  0.00           C  
ATOM    632  C   TYR A  44      21.002  67.132  15.927  1.00  0.00           C  
ATOM    633  O   TYR A  44      21.607  66.061  15.884  1.00  0.00           O  
ATOM    634  CB  TYR A  44      22.678  68.976  15.709  1.00  0.00           C  
ATOM    635  CG  TYR A  44      22.999  70.412  16.056  1.00  0.00           C  
ATOM    636  CD1 TYR A  44      23.671  70.730  17.231  1.00  0.00           C  
ATOM    637  CD2 TYR A  44      22.630  71.451  15.211  1.00  0.00           C  
ATOM    638  CE1 TYR A  44      23.965  72.041  17.553  1.00  0.00           C  
ATOM    639  CE2 TYR A  44      22.922  72.765  15.524  1.00  0.00           C  
ATOM    640  CZ  TYR A  44      23.589  73.055  16.696  1.00  0.00           C  
ATOM    641  OH  TYR A  44      23.881  74.362  17.014  1.00  0.00           O  
ATOM    642  H   TYR A  44      23.111  67.656  17.935  1.00  0.00           H  
ATOM    643  HA  TYR A  44      20.834  69.078  16.789  1.00  0.00           H  
ATOM    644  HB2 TYR A  44      23.590  68.404  15.791  1.00  0.00           H  
ATOM    645  HB3 TYR A  44      22.334  68.951  14.686  1.00  0.00           H  
ATOM    646  HD1 TYR A  44      23.964  69.933  17.900  1.00  0.00           H  
ATOM    647  HD2 TYR A  44      22.107  71.221  14.294  1.00  0.00           H  
ATOM    648  HE1 TYR A  44      24.488  72.269  18.471  1.00  0.00           H  
ATOM    649  HE2 TYR A  44      22.628  73.558  14.854  1.00  0.00           H  
ATOM    650  HH  TYR A  44      24.473  74.384  17.768  1.00  0.00           H  
ATOM    651  N   THR A  45      19.798  67.303  15.391  1.00  0.00           N  
ATOM    652  CA  THR A  45      19.103  66.219  14.708  1.00  0.00           C  
ATOM    653  C   THR A  45      19.331  66.283  13.202  1.00  0.00           C  
ATOM    654  O   THR A  45      18.768  67.136  12.515  1.00  0.00           O  
ATOM    655  CB  THR A  45      17.589  66.256  14.989  1.00  0.00           C  
ATOM    656  OG1 THR A  45      17.354  66.271  16.402  1.00  0.00           O  
ATOM    657  CG2 THR A  45      16.893  65.056  14.366  1.00  0.00           C  
ATOM    658  H   THR A  45      19.367  68.181  15.458  1.00  0.00           H  
ATOM    659  HA  THR A  45      19.495  65.285  15.083  1.00  0.00           H  
ATOM    660  HB  THR A  45      17.180  67.158  14.555  1.00  0.00           H  
ATOM    661  HG1 THR A  45      17.610  65.425  16.778  1.00  0.00           H  
ATOM    662 HG21 THR A  45      16.061  64.760  14.988  1.00  0.00           H  
ATOM    663 HG22 THR A  45      17.592  64.237  14.284  1.00  0.00           H  
ATOM    664 HG23 THR A  45      16.532  65.322  13.384  1.00  0.00           H  
ATOM    665  N   VAL A  46      20.158  65.375  12.694  1.00  0.00           N  
ATOM    666  CA  VAL A  46      20.457  65.326  11.268  1.00  0.00           C  
ATOM    667  C   VAL A  46      19.878  64.071  10.627  1.00  0.00           C  
ATOM    668  O   VAL A  46      19.582  63.091  11.310  1.00  0.00           O  
ATOM    669  CB  VAL A  46      21.977  65.366  11.013  1.00  0.00           C  
ATOM    670  CG1 VAL A  46      22.571  66.667  11.530  1.00  0.00           C  
ATOM    671  CG2 VAL A  46      22.656  64.166  11.655  1.00  0.00           C  
ATOM    672  H   VAL A  46      20.575  64.721  13.293  1.00  0.00           H  
ATOM    673  HA  VAL A  46      20.013  66.195  10.804  1.00  0.00           H  
ATOM    674  HB  VAL A  46      22.142  65.319   9.946  1.00  0.00           H  
ATOM    675 HG11 VAL A  46      23.624  66.527  11.728  1.00  0.00           H  
ATOM    676 HG12 VAL A  46      22.444  67.441  10.788  1.00  0.00           H  
ATOM    677 HG13 VAL A  46      22.069  66.955  12.442  1.00  0.00           H  
ATOM    678 HG21 VAL A  46      22.146  63.262  11.357  1.00  0.00           H  
ATOM    679 HG22 VAL A  46      23.686  64.121  11.334  1.00  0.00           H  
ATOM    680 HG23 VAL A  46      22.618  64.264  12.730  1.00  0.00           H  
ATOM    681  N   LYS A  47      19.717  64.108   9.308  1.00  0.00           N  
ATOM    682  CA  LYS A  47      19.175  62.972   8.571  1.00  0.00           C  
ATOM    683  C   LYS A  47      20.206  62.414   7.595  1.00  0.00           C  
ATOM    684  O   LYS A  47      20.917  63.168   6.931  1.00  0.00           O  
ATOM    685  CB  LYS A  47      17.912  63.387   7.814  1.00  0.00           C  
ATOM    686  CG  LYS A  47      17.034  62.216   7.408  1.00  0.00           C  
ATOM    687  CD  LYS A  47      15.729  62.686   6.785  1.00  0.00           C  
ATOM    688  CE  LYS A  47      14.673  61.592   6.811  1.00  0.00           C  
ATOM    689  NZ  LYS A  47      13.313  62.128   6.526  1.00  0.00           N  
ATOM    690  H   LYS A  47      19.973  64.918   8.818  1.00  0.00           H  
ATOM    691  HA  LYS A  47      18.920  62.205   9.286  1.00  0.00           H  
ATOM    692  HB2 LYS A  47      17.330  64.045   8.442  1.00  0.00           H  
ATOM    693  HB3 LYS A  47      18.201  63.919   6.919  1.00  0.00           H  
ATOM    694  HG2 LYS A  47      17.566  61.611   6.689  1.00  0.00           H  
ATOM    695  HG3 LYS A  47      16.811  61.625   8.285  1.00  0.00           H  
ATOM    696  HD2 LYS A  47      15.363  63.538   7.338  1.00  0.00           H  
ATOM    697  HD3 LYS A  47      15.913  62.972   5.759  1.00  0.00           H  
ATOM    698  HE2 LYS A  47      14.922  60.851   6.069  1.00  0.00           H  
ATOM    699  HE3 LYS A  47      14.672  61.134   7.791  1.00  0.00           H  
ATOM    700  HZ1 LYS A  47      13.187  62.251   5.500  1.00  0.00           H  
ATOM    701  HZ2 LYS A  47      13.185  63.048   6.993  1.00  0.00           H  
ATOM    702  HZ3 LYS A  47      12.588  61.469   6.876  1.00  0.00           H  
ATOM    703  N   TYR A  48      20.278  61.090   7.512  1.00  0.00           N  
ATOM    704  CA  TYR A  48      21.222  60.432   6.618  1.00  0.00           C  
ATOM    705  C   TYR A  48      20.545  60.031   5.310  1.00  0.00           C  
ATOM    706  O   TYR A  48      19.321  60.067   5.195  1.00  0.00           O  
ATOM    707  CB  TYR A  48      21.821  59.197   7.293  1.00  0.00           C  
ATOM    708  CG  TYR A  48      22.769  59.527   8.425  1.00  0.00           C  
ATOM    709  CD1 TYR A  48      22.295  59.745   9.712  1.00  0.00           C  
ATOM    710  CD2 TYR A  48      24.138  59.621   8.206  1.00  0.00           C  
ATOM    711  CE1 TYR A  48      23.157  60.046  10.750  1.00  0.00           C  
ATOM    712  CE2 TYR A  48      25.007  59.920   9.237  1.00  0.00           C  
ATOM    713  CZ  TYR A  48      24.512  60.133  10.506  1.00  0.00           C  
ATOM    714  OH  TYR A  48      25.374  60.433  11.536  1.00  0.00           O  
ATOM    715  H   TYR A  48      19.684  60.543   8.066  1.00  0.00           H  
ATOM    716  HA  TYR A  48      22.016  61.131   6.399  1.00  0.00           H  
ATOM    717  HB2 TYR A  48      21.024  58.593   7.695  1.00  0.00           H  
ATOM    718  HB3 TYR A  48      22.368  58.622   6.560  1.00  0.00           H  
ATOM    719  HD1 TYR A  48      21.233  59.676   9.900  1.00  0.00           H  
ATOM    720  HD2 TYR A  48      24.522  59.454   7.210  1.00  0.00           H  
ATOM    721  HE1 TYR A  48      22.770  60.212  11.744  1.00  0.00           H  
ATOM    722  HE2 TYR A  48      26.068  59.989   9.046  1.00  0.00           H  
ATOM    723  HH  TYR A  48      26.161  59.886  11.465  1.00  0.00           H  
ATOM    724  N   LYS A  49      21.353  59.648   4.327  1.00  0.00           N  
ATOM    725  CA  LYS A  49      20.835  59.238   3.026  1.00  0.00           C  
ATOM    726  C   LYS A  49      19.888  58.051   3.168  1.00  0.00           C  
ATOM    727  O   LYS A  49      18.908  57.935   2.432  1.00  0.00           O  
ATOM    728  CB  LYS A  49      21.987  58.876   2.086  1.00  0.00           C  
ATOM    729  CG  LYS A  49      22.906  57.800   2.638  1.00  0.00           C  
ATOM    730  CD  LYS A  49      22.440  56.410   2.238  1.00  0.00           C  
ATOM    731  CE  LYS A  49      23.091  55.336   3.095  1.00  0.00           C  
ATOM    732  NZ  LYS A  49      24.497  55.072   2.680  1.00  0.00           N  
ATOM    733  H   LYS A  49      22.321  59.641   4.479  1.00  0.00           H  
ATOM    734  HA  LYS A  49      20.289  60.071   2.610  1.00  0.00           H  
ATOM    735  HB2 LYS A  49      21.576  58.525   1.152  1.00  0.00           H  
ATOM    736  HB3 LYS A  49      22.576  59.763   1.901  1.00  0.00           H  
ATOM    737  HG2 LYS A  49      23.902  57.958   2.252  1.00  0.00           H  
ATOM    738  HG3 LYS A  49      22.919  57.869   3.716  1.00  0.00           H  
ATOM    739  HD2 LYS A  49      21.369  56.350   2.359  1.00  0.00           H  
ATOM    740  HD3 LYS A  49      22.697  56.237   1.203  1.00  0.00           H  
ATOM    741  HE2 LYS A  49      23.084  55.661   4.124  1.00  0.00           H  
ATOM    742  HE3 LYS A  49      22.521  54.424   3.001  1.00  0.00           H  
ATOM    743  HZ1 LYS A  49      24.527  54.286   1.999  1.00  0.00           H  
ATOM    744  HZ2 LYS A  49      25.074  54.820   3.508  1.00  0.00           H  
ATOM    745  HZ3 LYS A  49      24.903  55.919   2.233  1.00  0.00           H  
ATOM    746  N   ASP A  50      20.186  57.172   4.119  1.00  0.00           N  
ATOM    747  CA  ASP A  50      19.360  55.995   4.358  1.00  0.00           C  
ATOM    748  C   ASP A  50      18.184  56.332   5.269  1.00  0.00           C  
ATOM    749  O   ASP A  50      17.739  55.501   6.060  1.00  0.00           O  
ATOM    750  CB  ASP A  50      20.198  54.875   4.979  1.00  0.00           C  
ATOM    751  CG  ASP A  50      19.593  53.504   4.747  1.00  0.00           C  
ATOM    752  OD1 ASP A  50      19.257  53.192   3.586  1.00  0.00           O  
ATOM    753  OD2 ASP A  50      19.458  52.743   5.728  1.00  0.00           O  
ATOM    754  H   ASP A  50      20.981  57.320   4.673  1.00  0.00           H  
ATOM    755  HA  ASP A  50      18.976  55.659   3.407  1.00  0.00           H  
ATOM    756  HB2 ASP A  50      21.186  54.891   4.544  1.00  0.00           H  
ATOM    757  HB3 ASP A  50      20.275  55.041   6.043  1.00  0.00           H  
ATOM    758  N   GLY A  51      17.686  57.560   5.155  1.00  0.00           N  
ATOM    759  CA  GLY A  51      16.567  57.987   5.975  1.00  0.00           C  
ATOM    760  C   GLY A  51      16.745  57.619   7.435  1.00  0.00           C  
ATOM    761  O   GLY A  51      15.957  56.855   7.993  1.00  0.00           O  
ATOM    762  H   GLY A  51      18.081  58.181   4.507  1.00  0.00           H  
ATOM    763  HA2 GLY A  51      16.464  59.057   5.894  1.00  0.00           H  
ATOM    764  HA3 GLY A  51      15.666  57.518   5.606  1.00  0.00           H  
ATOM    765  N   THR A  52      17.787  58.164   8.057  1.00  0.00           N  
ATOM    766  CA  THR A  52      18.068  57.887   9.460  1.00  0.00           C  
ATOM    767  C   THR A  52      18.288  59.177  10.242  1.00  0.00           C  
ATOM    768  O   THR A  52      19.050  60.046   9.821  1.00  0.00           O  
ATOM    769  CB  THR A  52      19.309  56.988   9.618  1.00  0.00           C  
ATOM    770  OG1 THR A  52      19.215  55.864   8.735  1.00  0.00           O  
ATOM    771  CG2 THR A  52      19.448  56.502  11.052  1.00  0.00           C  
ATOM    772  H   THR A  52      18.379  58.764   7.560  1.00  0.00           H  
ATOM    773  HA  THR A  52      17.218  57.366   9.875  1.00  0.00           H  
ATOM    774  HB  THR A  52      20.188  57.565   9.362  1.00  0.00           H  
ATOM    775  HG1 THR A  52      20.098  55.566   8.501  1.00  0.00           H  
ATOM    776 HG21 THR A  52      18.581  56.807  11.620  1.00  0.00           H  
ATOM    777 HG22 THR A  52      20.336  56.931  11.493  1.00  0.00           H  
ATOM    778 HG23 THR A  52      19.523  55.426  11.062  1.00  0.00           H  
ATOM    779  N   GLU A  53      17.615  59.295  11.383  1.00  0.00           N  
ATOM    780  CA  GLU A  53      17.737  60.480  12.222  1.00  0.00           C  
ATOM    781  C   GLU A  53      18.515  60.167  13.497  1.00  0.00           C  
ATOM    782  O   GLU A  53      18.252  59.168  14.168  1.00  0.00           O  
ATOM    783  CB  GLU A  53      16.352  61.025  12.578  1.00  0.00           C  
ATOM    784  CG  GLU A  53      15.573  61.539  11.379  1.00  0.00           C  
ATOM    785  CD  GLU A  53      14.194  62.046  11.753  1.00  0.00           C  
ATOM    786  OE1 GLU A  53      13.597  61.497  12.703  1.00  0.00           O  
ATOM    787  OE2 GLU A  53      13.711  62.992  11.096  1.00  0.00           O  
ATOM    788  H   GLU A  53      17.022  58.567  11.665  1.00  0.00           H  
ATOM    789  HA  GLU A  53      18.275  61.229  11.662  1.00  0.00           H  
ATOM    790  HB2 GLU A  53      15.778  60.238  13.045  1.00  0.00           H  
ATOM    791  HB3 GLU A  53      16.469  61.838  13.280  1.00  0.00           H  
ATOM    792  HG2 GLU A  53      16.126  62.347  10.926  1.00  0.00           H  
ATOM    793  HG3 GLU A  53      15.463  60.734  10.666  1.00  0.00           H  
ATOM    794  N   LEU A  54      19.475  61.025  13.823  1.00  0.00           N  
ATOM    795  CA  LEU A  54      20.293  60.841  15.017  1.00  0.00           C  
ATOM    796  C   LEU A  54      20.590  62.179  15.685  1.00  0.00           C  
ATOM    797  O   LEU A  54      20.309  63.238  15.127  1.00  0.00           O  
ATOM    798  CB  LEU A  54      21.602  60.134  14.657  1.00  0.00           C  
ATOM    799  CG  LEU A  54      21.465  58.790  13.941  1.00  0.00           C  
ATOM    800  CD1 LEU A  54      22.827  58.279  13.502  1.00  0.00           C  
ATOM    801  CD2 LEU A  54      20.775  57.775  14.840  1.00  0.00           C  
ATOM    802  H   LEU A  54      19.637  61.802  13.249  1.00  0.00           H  
ATOM    803  HA  LEU A  54      19.738  60.223  15.707  1.00  0.00           H  
ATOM    804  HB2 LEU A  54      22.169  60.794  14.019  1.00  0.00           H  
ATOM    805  HB3 LEU A  54      22.148  59.967  15.575  1.00  0.00           H  
ATOM    806  HG  LEU A  54      20.857  58.922  13.056  1.00  0.00           H  
ATOM    807 HD11 LEU A  54      22.884  58.285  12.424  1.00  0.00           H  
ATOM    808 HD12 LEU A  54      22.967  57.271  13.864  1.00  0.00           H  
ATOM    809 HD13 LEU A  54      23.599  58.917  13.908  1.00  0.00           H  
ATOM    810 HD21 LEU A  54      21.515  57.115  15.269  1.00  0.00           H  
ATOM    811 HD22 LEU A  54      20.073  57.196  14.258  1.00  0.00           H  
ATOM    812 HD23 LEU A  54      20.251  58.291  15.631  1.00  0.00           H  
ATOM    813  N   GLU A  55      21.164  62.122  16.884  1.00  0.00           N  
ATOM    814  CA  GLU A  55      21.501  63.330  17.626  1.00  0.00           C  
ATOM    815  C   GLU A  55      23.011  63.462  17.795  1.00  0.00           C  
ATOM    816  O   GLU A  55      23.627  62.733  18.575  1.00  0.00           O  
ATOM    817  CB  GLU A  55      20.824  63.317  18.999  1.00  0.00           C  
ATOM    818  CG  GLU A  55      19.440  63.947  19.000  1.00  0.00           C  
ATOM    819  CD  GLU A  55      18.691  63.708  20.297  1.00  0.00           C  
ATOM    820  OE1 GLU A  55      18.231  62.567  20.514  1.00  0.00           O  
ATOM    821  OE2 GLU A  55      18.567  64.660  21.094  1.00  0.00           O  
ATOM    822  H   GLU A  55      21.364  61.246  17.276  1.00  0.00           H  
ATOM    823  HA  GLU A  55      21.139  64.177  17.064  1.00  0.00           H  
ATOM    824  HB2 GLU A  55      20.730  62.294  19.332  1.00  0.00           H  
ATOM    825  HB3 GLU A  55      21.443  63.860  19.697  1.00  0.00           H  
ATOM    826  HG2 GLU A  55      19.543  65.012  18.854  1.00  0.00           H  
ATOM    827  HG3 GLU A  55      18.867  63.528  18.187  1.00  0.00           H  
ATOM    828  N   LEU A  56      23.604  64.396  17.058  1.00  0.00           N  
ATOM    829  CA  LEU A  56      25.043  64.623  17.124  1.00  0.00           C  
ATOM    830  C   LEU A  56      25.351  65.985  17.740  1.00  0.00           C  
ATOM    831  O   LEU A  56      24.743  66.993  17.379  1.00  0.00           O  
ATOM    832  CB  LEU A  56      25.658  64.531  15.727  1.00  0.00           C  
ATOM    833  CG  LEU A  56      25.266  63.307  14.901  1.00  0.00           C  
ATOM    834  CD1 LEU A  56      25.781  63.436  13.476  1.00  0.00           C  
ATOM    835  CD2 LEU A  56      25.795  62.034  15.547  1.00  0.00           C  
ATOM    836  H   LEU A  56      23.061  64.946  16.456  1.00  0.00           H  
ATOM    837  HA  LEU A  56      25.472  63.855  17.750  1.00  0.00           H  
ATOM    838  HB2 LEU A  56      25.362  65.411  15.177  1.00  0.00           H  
ATOM    839  HB3 LEU A  56      26.733  64.524  15.840  1.00  0.00           H  
ATOM    840  HG  LEU A  56      24.188  63.238  14.860  1.00  0.00           H  
ATOM    841 HD11 LEU A  56      24.961  63.682  12.817  1.00  0.00           H  
ATOM    842 HD12 LEU A  56      26.224  62.501  13.167  1.00  0.00           H  
ATOM    843 HD13 LEU A  56      26.525  64.219  13.432  1.00  0.00           H  
ATOM    844 HD21 LEU A  56      26.205  62.269  16.518  1.00  0.00           H  
ATOM    845 HD22 LEU A  56      26.567  61.608  14.923  1.00  0.00           H  
ATOM    846 HD23 LEU A  56      24.988  61.325  15.658  1.00  0.00           H  
ATOM    847  N   LYS A  57      26.301  66.008  18.668  1.00  0.00           N  
ATOM    848  CA  LYS A  57      26.694  67.246  19.331  1.00  0.00           C  
ATOM    849  C   LYS A  57      27.200  68.269  18.319  1.00  0.00           C  
ATOM    850  O   LYS A  57      27.629  67.910  17.223  1.00  0.00           O  
ATOM    851  CB  LYS A  57      27.776  66.968  20.376  1.00  0.00           C  
ATOM    852  CG  LYS A  57      27.226  66.504  21.714  1.00  0.00           C  
ATOM    853  CD  LYS A  57      26.883  67.681  22.613  1.00  0.00           C  
ATOM    854  CE  LYS A  57      28.083  68.117  23.440  1.00  0.00           C  
ATOM    855  NZ  LYS A  57      27.698  69.079  24.509  1.00  0.00           N  
ATOM    856  H   LYS A  57      26.750  65.172  18.913  1.00  0.00           H  
ATOM    857  HA  LYS A  57      25.822  67.648  19.826  1.00  0.00           H  
ATOM    858  HB2 LYS A  57      28.437  66.201  19.997  1.00  0.00           H  
ATOM    859  HB3 LYS A  57      28.344  67.872  20.538  1.00  0.00           H  
ATOM    860  HG2 LYS A  57      26.331  65.924  21.543  1.00  0.00           H  
ATOM    861  HG3 LYS A  57      27.968  65.891  22.206  1.00  0.00           H  
ATOM    862  HD2 LYS A  57      26.562  68.510  22.001  1.00  0.00           H  
ATOM    863  HD3 LYS A  57      26.084  67.391  23.280  1.00  0.00           H  
ATOM    864  HE2 LYS A  57      28.528  67.246  23.894  1.00  0.00           H  
ATOM    865  HE3 LYS A  57      28.802  68.588  22.786  1.00  0.00           H  
ATOM    866  HZ1 LYS A  57      28.414  69.830  24.589  1.00  0.00           H  
ATOM    867  HZ2 LYS A  57      27.625  68.588  25.423  1.00  0.00           H  
ATOM    868  HZ3 LYS A  57      26.780  69.514  24.287  1.00  0.00           H  
ATOM    869  N   GLU A  58      27.147  69.543  18.695  1.00  0.00           N  
ATOM    870  CA  GLU A  58      27.601  70.616  17.819  1.00  0.00           C  
ATOM    871  C   GLU A  58      29.026  70.359  17.336  1.00  0.00           C  
ATOM    872  O   GLU A  58      29.397  70.744  16.228  1.00  0.00           O  
ATOM    873  CB  GLU A  58      27.534  71.961  18.545  1.00  0.00           C  
ATOM    874  CG  GLU A  58      27.779  73.156  17.639  1.00  0.00           C  
ATOM    875  CD  GLU A  58      28.132  74.411  18.412  1.00  0.00           C  
ATOM    876  OE1 GLU A  58      29.004  74.334  19.303  1.00  0.00           O  
ATOM    877  OE2 GLU A  58      27.537  75.471  18.124  1.00  0.00           O  
ATOM    878  H   GLU A  58      26.794  69.766  19.582  1.00  0.00           H  
ATOM    879  HA  GLU A  58      26.944  70.646  16.963  1.00  0.00           H  
ATOM    880  HB2 GLU A  58      26.555  72.067  18.990  1.00  0.00           H  
ATOM    881  HB3 GLU A  58      28.278  71.971  19.328  1.00  0.00           H  
ATOM    882  HG2 GLU A  58      28.592  72.922  16.969  1.00  0.00           H  
ATOM    883  HG3 GLU A  58      26.884  73.345  17.064  1.00  0.00           H  
ATOM    884  N   ASN A  59      29.820  69.702  18.176  1.00  0.00           N  
ATOM    885  CA  ASN A  59      31.203  69.393  17.836  1.00  0.00           C  
ATOM    886  C   ASN A  59      31.277  68.209  16.877  1.00  0.00           C  
ATOM    887  O   ASN A  59      32.052  68.219  15.920  1.00  0.00           O  
ATOM    888  CB  ASN A  59      32.006  69.088  19.103  1.00  0.00           C  
ATOM    889  CG  ASN A  59      33.473  68.839  18.812  1.00  0.00           C  
ATOM    890  OD1 ASN A  59      34.005  67.772  19.118  1.00  0.00           O  
ATOM    891  ND2 ASN A  59      34.134  69.825  18.217  1.00  0.00           N  
ATOM    892  H   ASN A  59      29.466  69.419  19.045  1.00  0.00           H  
ATOM    893  HA  ASN A  59      31.628  70.260  17.353  1.00  0.00           H  
ATOM    894  HB2 ASN A  59      31.930  69.926  19.780  1.00  0.00           H  
ATOM    895  HB3 ASN A  59      31.597  68.209  19.578  1.00  0.00           H  
ATOM    896 HD21 ASN A  59      33.645  70.647  18.003  1.00  0.00           H  
ATOM    897 HD22 ASN A  59      35.084  69.691  18.017  1.00  0.00           H  
ATOM    898  N   ASP A  60      30.465  67.190  17.140  1.00  0.00           N  
ATOM    899  CA  ASP A  60      30.436  65.999  16.299  1.00  0.00           C  
ATOM    900  C   ASP A  60      30.149  66.366  14.847  1.00  0.00           C  
ATOM    901  O   ASP A  60      30.600  65.685  13.924  1.00  0.00           O  
ATOM    902  CB  ASP A  60      29.380  65.016  16.808  1.00  0.00           C  
ATOM    903  CG  ASP A  60      29.787  64.352  18.108  1.00  0.00           C  
ATOM    904  OD1 ASP A  60      30.228  65.071  19.029  1.00  0.00           O  
ATOM    905  OD2 ASP A  60      29.665  63.112  18.205  1.00  0.00           O  
ATOM    906  H   ASP A  60      29.870  67.242  17.917  1.00  0.00           H  
ATOM    907  HA  ASP A  60      31.407  65.531  16.355  1.00  0.00           H  
ATOM    908  HB2 ASP A  60      28.453  65.546  16.971  1.00  0.00           H  
ATOM    909  HB3 ASP A  60      29.225  64.248  16.065  1.00  0.00           H  
ATOM    910  N   ILE A  61      29.398  67.444  14.651  1.00  0.00           N  
ATOM    911  CA  ILE A  61      29.052  67.900  13.311  1.00  0.00           C  
ATOM    912  C   ILE A  61      30.103  68.863  12.769  1.00  0.00           C  
ATOM    913  O   ILE A  61      30.554  69.768  13.472  1.00  0.00           O  
ATOM    914  CB  ILE A  61      27.677  68.595  13.290  1.00  0.00           C  
ATOM    915  CG1 ILE A  61      26.596  67.649  13.817  1.00  0.00           C  
ATOM    916  CG2 ILE A  61      27.340  69.060  11.881  1.00  0.00           C  
ATOM    917  CD1 ILE A  61      25.245  68.309  13.982  1.00  0.00           C  
ATOM    918  H   ILE A  61      29.069  67.945  15.426  1.00  0.00           H  
ATOM    919  HA  ILE A  61      29.005  67.035  12.665  1.00  0.00           H  
ATOM    920  HB  ILE A  61      27.728  69.464  13.927  1.00  0.00           H  
ATOM    921 HG12 ILE A  61      26.481  66.826  13.132  1.00  0.00           H  
ATOM    922 HG13 ILE A  61      26.900  67.270  14.782  1.00  0.00           H  
ATOM    923 HG21 ILE A  61      27.134  70.120  11.891  1.00  0.00           H  
ATOM    924 HG22 ILE A  61      28.176  68.863  11.228  1.00  0.00           H  
ATOM    925 HG23 ILE A  61      26.471  68.528  11.525  1.00  0.00           H  
ATOM    926 HD11 ILE A  61      25.283  69.010  14.802  1.00  0.00           H  
ATOM    927 HD12 ILE A  61      24.985  68.830  13.073  1.00  0.00           H  
ATOM    928 HD13 ILE A  61      24.500  67.555  14.190  1.00  0.00           H  
ATOM    929  N   LYS A  62      30.490  68.663  11.514  1.00  0.00           N  
ATOM    930  CA  LYS A  62      31.486  69.515  10.874  1.00  0.00           C  
ATOM    931  C   LYS A  62      31.088  69.832   9.436  1.00  0.00           C  
ATOM    932  O   LYS A  62      30.389  69.052   8.789  1.00  0.00           O  
ATOM    933  CB  LYS A  62      32.857  68.836  10.897  1.00  0.00           C  
ATOM    934  CG  LYS A  62      33.422  68.651  12.295  1.00  0.00           C  
ATOM    935  CD  LYS A  62      34.941  68.688  12.292  1.00  0.00           C  
ATOM    936  CE  LYS A  62      35.527  67.413  11.704  1.00  0.00           C  
ATOM    937  NZ  LYS A  62      36.998  67.524  11.497  1.00  0.00           N  
ATOM    938  H   LYS A  62      30.093  67.925  11.004  1.00  0.00           H  
ATOM    939  HA  LYS A  62      31.541  70.436  11.432  1.00  0.00           H  
ATOM    940  HB2 LYS A  62      32.771  67.863  10.435  1.00  0.00           H  
ATOM    941  HB3 LYS A  62      33.551  69.436  10.327  1.00  0.00           H  
ATOM    942  HG2 LYS A  62      33.055  69.445  12.929  1.00  0.00           H  
ATOM    943  HG3 LYS A  62      33.094  67.698  12.683  1.00  0.00           H  
ATOM    944  HD2 LYS A  62      35.271  69.529  11.702  1.00  0.00           H  
ATOM    945  HD3 LYS A  62      35.292  68.799  13.309  1.00  0.00           H  
ATOM    946  HE2 LYS A  62      35.327  66.595  12.378  1.00  0.00           H  
ATOM    947  HE3 LYS A  62      35.052  67.221  10.752  1.00  0.00           H  
ATOM    948  HZ1 LYS A  62      37.496  67.394  12.401  1.00  0.00           H  
ATOM    949  HZ2 LYS A  62      37.235  68.461  11.114  1.00  0.00           H  
ATOM    950  HZ3 LYS A  62      37.321  66.797  10.828  1.00  0.00           H  
ATOM    951  N   SER A  63      31.538  70.982   8.942  1.00  0.00           N  
ATOM    952  CA  SER A  63      31.226  71.403   7.582  1.00  0.00           C  
ATOM    953  C   SER A  63      32.503  71.675   6.792  1.00  0.00           C  
ATOM    954  O   SER A  63      33.581  71.824   7.366  1.00  0.00           O  
ATOM    955  CB  SER A  63      30.348  72.656   7.602  1.00  0.00           C  
ATOM    956  OG  SER A  63      31.047  73.759   8.155  1.00  0.00           O  
ATOM    957  H   SER A  63      32.090  71.561   9.509  1.00  0.00           H  
ATOM    958  HA  SER A  63      30.685  70.602   7.103  1.00  0.00           H  
ATOM    959  HB2 SER A  63      30.053  72.902   6.594  1.00  0.00           H  
ATOM    960  HB3 SER A  63      29.469  72.466   8.199  1.00  0.00           H  
ATOM    961  HG  SER A  63      31.991  73.633   8.035  1.00  0.00           H  
ATOM    962  N   GLY A  64      32.372  71.740   5.471  1.00  0.00           N  
ATOM    963  CA  GLY A  64      33.521  71.993   4.622  1.00  0.00           C  
ATOM    964  C   GLY A  64      33.323  73.195   3.720  1.00  0.00           C  
ATOM    965  O   GLY A  64      32.499  74.069   3.988  1.00  0.00           O  
ATOM    966  H   GLY A  64      31.487  71.613   5.069  1.00  0.00           H  
ATOM    967  HA2 GLY A  64      34.385  72.164   5.248  1.00  0.00           H  
ATOM    968  HA3 GLY A  64      33.701  71.122   4.008  1.00  0.00           H  
ATOM    969  N   PRO A  65      34.092  73.249   2.623  1.00  0.00           N  
ATOM    970  CA  PRO A  65      34.015  74.349   1.656  1.00  0.00           C  
ATOM    971  C   PRO A  65      32.713  74.334   0.862  1.00  0.00           C  
ATOM    972  O   PRO A  65      32.252  73.278   0.429  1.00  0.00           O  
ATOM    973  CB  PRO A  65      35.208  74.093   0.732  1.00  0.00           C  
ATOM    974  CG  PRO A  65      35.458  72.628   0.833  1.00  0.00           C  
ATOM    975  CD  PRO A  65      35.095  72.242   2.241  1.00  0.00           C  
ATOM    976  HA  PRO A  65      34.130  75.309   2.138  1.00  0.00           H  
ATOM    977  HB2 PRO A  65      34.953  74.383  -0.278  1.00  0.00           H  
ATOM    978  HB3 PRO A  65      36.060  74.663   1.072  1.00  0.00           H  
ATOM    979  HG2 PRO A  65      34.836  72.100   0.127  1.00  0.00           H  
ATOM    980  HG3 PRO A  65      36.500  72.420   0.645  1.00  0.00           H  
ATOM    981  HD2 PRO A  65      34.673  71.249   2.262  1.00  0.00           H  
ATOM    982  HD3 PRO A  65      35.962  72.299   2.882  1.00  0.00           H  
ATOM    983  N   SER A  66      32.126  75.511   0.675  1.00  0.00           N  
ATOM    984  CA  SER A  66      30.875  75.631  -0.065  1.00  0.00           C  
ATOM    985  C   SER A  66      31.114  75.486  -1.565  1.00  0.00           C  
ATOM    986  O   SER A  66      32.122  75.956  -2.092  1.00  0.00           O  
ATOM    987  CB  SER A  66      30.212  76.978   0.229  1.00  0.00           C  
ATOM    988  OG  SER A  66      31.050  78.054  -0.153  1.00  0.00           O  
ATOM    989  H   SER A  66      32.542  76.317   1.045  1.00  0.00           H  
ATOM    990  HA  SER A  66      30.218  74.838   0.261  1.00  0.00           H  
ATOM    991  HB2 SER A  66      29.285  77.048  -0.320  1.00  0.00           H  
ATOM    992  HB3 SER A  66      30.010  77.053   1.288  1.00  0.00           H  
ATOM    993  HG  SER A  66      30.738  78.426  -0.981  1.00  0.00           H  
ATOM    994  N   SER A  67      30.179  74.831  -2.246  1.00  0.00           N  
ATOM    995  CA  SER A  67      30.289  74.620  -3.685  1.00  0.00           C  
ATOM    996  C   SER A  67      28.945  74.846  -4.372  1.00  0.00           C  
ATOM    997  O   SER A  67      27.902  74.423  -3.873  1.00  0.00           O  
ATOM    998  CB  SER A  67      30.792  73.205  -3.976  1.00  0.00           C  
ATOM    999  OG  SER A  67      29.913  72.231  -3.441  1.00  0.00           O  
ATOM   1000  H   SER A  67      29.398  74.481  -1.769  1.00  0.00           H  
ATOM   1001  HA  SER A  67      31.001  75.334  -4.071  1.00  0.00           H  
ATOM   1002  HB2 SER A  67      30.860  73.063  -5.044  1.00  0.00           H  
ATOM   1003  HB3 SER A  67      31.769  73.075  -3.533  1.00  0.00           H  
ATOM   1004  HG  SER A  67      29.005  72.509  -3.580  1.00  0.00           H  
ATOM   1005  N   GLY A  68      28.979  75.517  -5.519  1.00  0.00           N  
ATOM   1006  CA  GLY A  68      27.758  75.788  -6.256  1.00  0.00           C  
ATOM   1007  C   GLY A  68      27.825  77.091  -7.028  1.00  0.00           C  
ATOM   1008  O   GLY A  68      26.898  77.433  -7.762  1.00  0.00           O  
ATOM   1009  H   GLY A  68      29.839  75.829  -5.868  1.00  0.00           H  
ATOM   1010  HA2 GLY A  68      27.582  74.979  -6.950  1.00  0.00           H  
ATOM   1011  HA3 GLY A  68      26.935  75.838  -5.559  1.00  0.00           H  
TER    1012      GLY A  68                                                      
END
MOLECULE T0504_63_155.pdb
ATOM    492  N   HSD    63      35.010  73.105  13.440  1.00 24.32          
ATOM    493  CA  HSD    63      33.615  73.111  13.872  1.00 25.56          
ATOM    494  CB  HSD    63      33.519  72.477  15.263  1.00 24.97          
ATOM    495  CG  HSD    63      34.160  71.127  15.321  1.00 24.22          
ATOM    496  ND1 HSD    63      35.270  70.847  16.088  1.00 28.07          
ATOM    497  CE1 HSD    63      35.632  69.590  15.888  1.00 26.20          
ATOM    498  NE2 HSD    63      34.807  69.053  15.003  1.00 26.25          
ATOM    499  CD2 HSD    63      33.881  69.993  14.634  1.00 22.43          
ATOM    500  C   HSD    63      33.056  74.547  13.817  1.00 27.28          
ATOM    501  O   HSD    63      33.586  75.443  14.467  1.00 29.56          
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66          
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40          
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92          
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74          
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41          
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53          
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81          
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51          
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90          
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10          
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99          
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84          
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20          
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73          
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87          
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85          
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88          
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29          
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66          
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76          
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53          
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00          
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77          
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49          
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84          
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00          
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51          
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05          
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09          
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00          
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64          
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82          
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10          
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28          
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41          
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19          
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13          
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80          
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60          
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76          
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41          
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04          
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41          
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95          
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13          
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67          
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50          
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84          
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92          
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60          
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62          
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75          
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82          
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32          
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40          
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25          
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95          
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52          
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43          
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15          
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14          
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13          
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79          
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52          
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27          
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65          
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42          
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32          
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94          
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83          
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16          
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98          
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46          
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33          
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00          
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66          
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27          
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00          
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45          
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96          
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65          
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44          
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93          
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89          
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79          
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83          
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62          
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43          
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70          
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62          
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18          
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40          
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21          
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42          
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77          
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22          
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24          
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16          
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51          
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54          
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86          
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89          
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43          
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68          
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04          
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30          
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63          
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97          
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00          
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09          
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29          
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83          
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82          
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33          
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99          
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73          
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64          
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11          
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97          
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65          
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25          
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71          
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65          
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57          
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32          
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27          
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32          
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72          
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04          
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43          
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93          
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48          
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81          
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78          
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62          
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24          
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99          
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44          
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57          
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52          
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39          
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60          
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72          
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07          
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78          
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49          
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85          
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92          
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01          
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64          
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43          
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94          
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99          
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49          
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91          
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50          
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10          
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73          
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41          
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20          
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46          
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29          
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39          
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91          
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56          
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69          
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70          
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15          
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90          
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99          
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21          
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50          
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34          
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51          
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04          
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89          
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94          
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27          
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48          
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06          
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81          
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19          
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63          
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91          
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62          
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68          
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51          
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55          
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57          
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15          
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15          
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09          
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91          
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64          
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36          
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44          
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12          
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12          
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59          
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18          
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61          
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17          
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43          
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08          
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00          
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19          
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22          
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28          
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54          
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43          
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72          
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00          
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87          
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36          
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32          
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77          
ATOM    718  CD  ILE    91      21.004  68.804   3.522  1.00 26.35          
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37          
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40          
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69          
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01          
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58          
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01          
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99          
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64          
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26          
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42          
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59          
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19          
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13          
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92          
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56          
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37          
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21          
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92          
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03          
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98          
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90          
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28          
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23          
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59          
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37          
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74          
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84          
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78          
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52          
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60          
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69          
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69          
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59          
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22          
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67          
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43          
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84          
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06          
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07          
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93          
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42          
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70          
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18          
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03          
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34          
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04          
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73          
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02          
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18          
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17          
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25          
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86          
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40          
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93          
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74          
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01          
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21          
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77          
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90          
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85          
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32          
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38          
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61          
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96          
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58          
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24          
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88          
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73          
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87          
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07          
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69          
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96          
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57          
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38          
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44          
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30          
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55          
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33          
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46          
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23          
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59          
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55          
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10          
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70          
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74          
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80          
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60          
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82          
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44          
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22          
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32          
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56          
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24          
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25          
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17          
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74          
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49          
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66          
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03          
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77          
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90          
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91          
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77          
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30          
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62          
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79          
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41          
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73          
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07          
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95          
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90          
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16          
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79          
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70          
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00          
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31          
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80          
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01          
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24          
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24          
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43          
ATOM    840  CD  ILE   106      23.603  67.212  12.165  1.00 20.23          
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52          
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58          
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61          
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23          
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45          
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44          
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93          
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99          
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41          
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32          
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50          
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35          
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80          
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67          
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44          
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55          
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60          
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49          
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81          
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08          
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48          
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72          
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79          
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19          
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68          
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03          
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13          
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75          
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93          
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78          
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40          
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28          
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96          
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54          
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57          
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39          
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68          
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45          
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92          
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52          
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49          
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29          
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31          
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94          
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78          
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27          
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81          
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78          
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13          
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13          
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46          
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51          
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35          
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49          
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42          
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38          
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60          
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28          
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48          
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94          
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88          
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02          
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78          
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51          
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32          
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59          
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14          
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10          
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88          
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97          
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23          
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98          
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69          
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06          
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17          
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32          
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57          
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00          
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83          
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57          
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72          
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52          
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69          
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00          
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31          
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61          
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30          
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89          
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98          
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31          
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79          
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61          
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21          
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79          
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01          
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28          
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49          
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99          
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55          
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72          
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57          
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10          
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56          
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49          
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07          
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47          
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78          
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32          
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85          
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18          
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24          
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92          
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83          
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58          
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17          
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52          
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67          
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73          
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86          
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32          
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01          
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02          
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23          
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86          
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96          
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86          
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66          
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39          
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52          
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82          
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09          
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95          
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50          
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88          
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16          
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29          
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68          
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71          
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87          
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79          
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35          
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92          
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87          
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69          
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01          
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52          
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49          
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21          
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81          
ATOM    990  CD  ILE   124      28.803  68.039   3.091  1.00 25.49          
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25          
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92          
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39          
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68          
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92          
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66          
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72          
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26          
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07          
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14          
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10          
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44          
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05          
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38          
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14          
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93          
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80          
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37          
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61          
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58          
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84          
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55          
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73          
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71          
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69          
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20          
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13          
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93          
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11          
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11          
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78          
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21          
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11          
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10          
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50          
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83          
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96          
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23          
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25          
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12          
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73          
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80          
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59          
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18          
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19          
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79          
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69          
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99          
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29          
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81          
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82          
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63          
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95          
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22          
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50          
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06          
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82          
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04          
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62          
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97          
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04          
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89          
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11          
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44          
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59          
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49          
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16          
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91          
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11          
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36          
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08          
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78          
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73          
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50          
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66          
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34          
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61          
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64          
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80          
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45          
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15          
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32          
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86          
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24          
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25          
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54          
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08          
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87          
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84          
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00          
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24          
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19          
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87          
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06          
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49          
ATOM   1086  CD  ILE   135      19.824  64.761   1.305  1.00 23.82          
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41          
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62          
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83          
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22          
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84          
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33          
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07          
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16          
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64          
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16          
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21          
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43          
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97          
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33          
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96          
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40          
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12          
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44          
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22          
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47          
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01          
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20          
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03          
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30          
ATOM   1111  CD  ILE   138      16.726  60.053  -7.522  1.00 39.39          
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48          
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36          
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12          
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01          
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00          
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18          
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34          
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51          
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97          
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81          
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88          
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25          
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11          
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83          
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62          
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66          
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46          
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64          
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59          
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60          
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75          
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41          
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78          
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62          
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45          
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66          
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96          
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71          
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78          
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65          
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59          
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79          
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31          
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37          
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25          
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37          
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32          
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89          
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74          
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27          
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23          
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99          
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83          
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84          
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22          
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15          
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71          
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41          
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65          
ATOM   1161  CD  ILE   144      16.433  64.307   5.309  1.00 32.59          
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38          
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23          
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99          
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54          
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22          
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83          
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06          
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55          
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48          
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38          
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02          
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51          
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22          
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31          
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99          
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93          
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96          
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56          
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44          
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30          
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67          
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95          
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26          
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62          
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42          
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78          
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51          
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34          
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94          
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26          
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68          
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42          
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71          
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89          
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22          
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51          
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81          
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91          
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19          
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11          
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28          
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60          
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71          
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07          
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99          
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95          
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70          
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59          
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60          
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85          
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59          
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80          
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51          
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02          
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25          
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64          
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89          
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64          
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96          
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53          
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39          
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63          
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26          
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36          
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02          
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87          
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97          
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14          
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10          
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49          
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95          
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00          
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00          
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00          
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00          
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11          
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24          
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67          
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22          
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95          
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24          
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56          
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65          
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10          
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91          
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48          
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60          
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81          
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57          
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30          
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91          
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74          
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68          
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45          
END
