
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1508),  selected   92 , name 2ro0_A
# Molecule2: number of CA atoms   53 (  447),  selected   53 , name T0504_156_208.pdb
# PARAMETERS: 2ro0_A.T0504_156_208.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -2_A      -       -           -
LGA    S    -1_A      -       -           -
LGA    H     0_A      -       -           -
LGA    M     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    H     3_A      -       -           -
LGA    D     4_A      -       -           -
LGA    G     5_A      -       -           -
LGA    K     6_A      -       -           -
LGA    E     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    G    10_A      -       -           -
LGA    I    11_A      -       -           -
LGA    A    12_A      -       -           -
LGA    K    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    I    15_A      -       -           -
LGA    N    16_A      -       -           -
LGA    S    17_A      M     156          5.204
LGA    V    18_A      V     157          1.449
LGA    D    19_A      L     158          1.754
LGA    D    20_A      -       -           -
LGA    I    21_A      L     159          1.359
LGA    I    22_A      K     160          0.893
LGA    I    23_A      S     161          0.725
LGA    K    24_A      G     162          1.251
LGA    C    25_A      Q     163          0.540
LGA    Q    26_A      L     164          1.135
LGA    C    27_A      I     165          0.650
LGA    W    28_A      K     166          0.693
LGA    V    29_A      T     167          0.621
LGA    Q    30_A      E     168          0.939
LGA    K    31_A      W     169          0.851
LGA    N    32_A      E     170          0.545
LGA    D    33_A      G     171          0.756
LGA    E    34_A      T     172          0.551
LGA    E    35_A      W     173          0.493
LGA    R    36_A      W     174          0.463
LGA    L    37_A      K     175          1.123
LGA    A    38_A      S     176          1.075
LGA    E    39_A      R     177          0.500
LGA    I    40_A      V     178          0.497
LGA    L    41_A      E     179          0.336
LGA    S    42_A      E     180          0.378
LGA    I    43_A      V     181          0.314
LGA    N    44_A      D     182          0.967
LGA    T    45_A      G     183          0.350
LGA    R    46_A      -       -           -
LGA    K    47_A      -       -           -
LGA    A    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    P    50_A      S     184          1.223
LGA    K    51_A      L     185          0.838
LGA    F    52_A      V     186          0.425
LGA    Y    53_A      R     187          0.314
LGA    V    54_A      I     188          0.291
LGA    H    55_A      L     189          0.417
LGA    Y    56_A      F     190          0.625
LGA    V    57_A      L     191          0.655
LGA    N    58_A      D     192          0.775
LGA    Y    59_A      D     193          0.961
LGA    N    60_A      K     194          2.145
LGA    K    61_A      R     195          3.595
LGA    R    62_A      -       -           -
LGA    L    63_A      -       -           -
LGA    D    64_A      C     196          0.735
LGA    E    65_A      E     197          1.065
LGA    W    66_A      W     198          0.315
LGA    I    67_A      I     199          1.067
LGA    T    68_A      Y     200          1.506
LGA    T    69_A      R     201          2.675
LGA    -       -      G     202           -
LGA    D    70_A      S     203          0.990
LGA    -       -      T     204           -
LGA    R    71_A      R     205          2.346
LGA    I    72_A      L     206          0.848
LGA    N    73_A      E     207          0.928
LGA    L    74_A      P     208          1.191
LGA    D    75_A      -       -           -
LGA    K    76_A      -       -           -
LGA    E    77_A      -       -           -
LGA    V    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    Y    80_A      -       -           -
LGA    P    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    A    85_A      -       -           -
LGA    T    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    D    89_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   53    5.0     51    1.34     9.80     92.428     3.537

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.245627 * X  +   0.711427 * Y  +   0.658437 * Z  + -24.669069
  Y_new =  -0.525974 * X  +  -0.472749 * Y  +   0.707008 * Z  +  57.407574
  Z_new =   0.814260 * X  +  -0.519981 * Y  +   0.258072 * Z  +  21.755352 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.110105    2.031487  [ DEG:   -63.6044    116.3956 ]
  Theta =  -0.951453   -2.190140  [ DEG:   -54.5142   -125.4858 ]
  Phi   =  -1.133899    2.007694  [ DEG:   -64.9676    115.0324 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ro0_A                                        
REMARK     2: T0504_156_208.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ro0_A.T0504_156_208.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   53   5.0   51   1.34    9.80  92.428
REMARK  ---------------------------------------------------------- 
MOLECULE 2ro0_A
HEADER    TRANSFERASE                             01-MAR-08   2RO0              
TITLE     SOLUTION STRUCTURE OF THE KNOTTED TUDOR DOMAIN OF THE YEAST           
TITLE    2 HISTONE ACETYLTRANSFERASE, ESA1                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE ACETYLTRANSFERASE ESA1;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 1-89;                                             
COMPND   5 EC: 2.3.1.48;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 GENUS: SACCHAROMYCES;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_GENUS: ESCHERICHIA;                                
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    ESA1, HAT, CHROMODOMAIN, TUDOR DOMAIN, RNA BINDING,                   
KEYWDS   2 ACTIVATOR, CHROMATIN REGULATOR, TRANSCRIPTION,                       
KEYWDS   3 TRANSCRIPTION REGULATION, TRANSFERASE                                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.SHIMOJO,N.SANO,Y.MORIWAKI,M.OKUDA,M.HORIKOSHI,Y.NISHIMURA           
REVDAT   2   03-JUN-08 2RO0    1       JRNL                                     
REVDAT   1   29-APR-08 2RO0    0                                                
JRNL        AUTH   H.SHIMOJO,N.SANO,Y.MORIWAKI,M.OKUDA,M.HORIKOSHI,             
JRNL        AUTH 2 Y.NISHIMURA                                                  
JRNL        TITL   NOVEL STRUCTURAL AND FUNCTIONAL MODE OF A KNOT               
JRNL        TITL 2 ESSENTIAL FOR RNA BINDING ACTIVITY OF THE ESA1               
JRNL        TITL 3 PRESUMED CHROMODOMAIN                                        
JRNL        REF    J.MOL.BIOL.                   V. 378   987 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2RO0 A    1    89  UNP    Q08649   ESA1_YEAST       1     89             
SEQRES   1 A   92  GLY SER HIS MET SER HIS ASP GLY LYS GLU GLU PRO GLY          
SEQRES   2 A   92  ILE ALA LYS LYS ILE ASN SER VAL ASP ASP ILE ILE ILE          
SEQRES   3 A   92  LYS CYS GLN CYS TRP VAL GLN LYS ASN ASP GLU GLU ARG          
SEQRES   4 A   92  LEU ALA GLU ILE LEU SER ILE ASN THR ARG LYS ALA PRO          
SEQRES   5 A   92  PRO LYS PHE TYR VAL HIS TYR VAL ASN TYR ASN LYS ARG          
SEQRES   6 A   92  LEU ASP GLU TRP ILE THR THR ASP ARG ILE ASN LEU ASP          
SEQRES   7 A   92  LYS GLU VAL LEU TYR PRO LYS LEU LYS ALA THR ASP GLU          
SEQRES   8 A   92  ASP                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  -2     -24.342  56.708  22.838  1.00  0.00           N  
ATOM      2  CA  GLY A  -2     -24.981  55.436  23.119  1.00  0.00           C  
ATOM      3  C   GLY A  -2     -24.270  54.659  24.211  1.00  0.00           C  
ATOM      4  O   GLY A  -2     -23.043  54.576  24.224  1.00  0.00           O  
ATOM      5  H1  GLY A  -2     -23.663  57.059  23.451  1.00  0.00           H  
ATOM      6  HA2 GLY A  -2     -26.000  55.617  23.426  1.00  0.00           H  
ATOM      7  HA3 GLY A  -2     -24.987  54.841  22.217  1.00  0.00           H  
ATOM      8  N   SER A  -1     -25.045  54.092  25.131  1.00  0.00           N  
ATOM      9  CA  SER A  -1     -24.481  53.323  26.235  1.00  0.00           C  
ATOM     10  C   SER A  -1     -25.325  52.084  26.519  1.00  0.00           C  
ATOM     11  O   SER A  -1     -26.547  52.103  26.370  1.00  0.00           O  
ATOM     12  CB  SER A  -1     -24.387  54.190  27.491  1.00  0.00           C  
ATOM     13  OG  SER A  -1     -23.929  55.494  27.179  1.00  0.00           O  
ATOM     14  H   SER A  -1     -26.017  54.195  25.067  1.00  0.00           H  
ATOM     15  HA  SER A  -1     -23.488  53.010  25.948  1.00  0.00           H  
ATOM     16  HB2 SER A  -1     -25.362  54.264  27.948  1.00  0.00           H  
ATOM     17  HB3 SER A  -1     -23.696  53.737  28.187  1.00  0.00           H  
ATOM     18  HG  SER A  -1     -24.626  56.130  27.359  1.00  0.00           H  
ATOM     19  N   HIS A   0     -24.663  51.008  26.931  1.00  0.00           N  
ATOM     20  CA  HIS A   0     -25.350  49.758  27.238  1.00  0.00           C  
ATOM     21  C   HIS A   0     -24.640  49.009  28.360  1.00  0.00           C  
ATOM     22  O   HIS A   0     -23.620  49.465  28.877  1.00  0.00           O  
ATOM     23  CB  HIS A   0     -25.431  48.876  25.992  1.00  0.00           C  
ATOM     24  CG  HIS A   0     -26.114  49.536  24.834  1.00  0.00           C  
ATOM     25  ND1 HIS A   0     -25.430  50.125  23.792  1.00  0.00           N  
ATOM     26  CD2 HIS A   0     -27.430  49.696  24.557  1.00  0.00           C  
ATOM     27  CE1 HIS A   0     -26.295  50.622  22.925  1.00  0.00           C  
ATOM     28  NE2 HIS A   0     -27.516  50.373  23.366  1.00  0.00           N  
ATOM     29  H   HIS A   0     -23.689  51.054  27.031  1.00  0.00           H  
ATOM     30  HA  HIS A   0     -26.351  50.001  27.561  1.00  0.00           H  
ATOM     31  HB2 HIS A   0     -24.431  48.614  25.679  1.00  0.00           H  
ATOM     32  HB3 HIS A   0     -25.977  47.975  26.230  1.00  0.00           H  
ATOM     33  HD1 HIS A   0     -24.456  50.176  23.703  1.00  0.00           H  
ATOM     34  HD2 HIS A   0     -28.259  49.355  25.160  1.00  0.00           H  
ATOM     35  HE1 HIS A   0     -26.047  51.141  22.011  1.00  0.00           H  
ATOM     36  N   MET A   1     -25.186  47.856  28.735  1.00  0.00           N  
ATOM     37  CA  MET A   1     -24.604  47.044  29.797  1.00  0.00           C  
ATOM     38  C   MET A   1     -23.213  46.555  29.407  1.00  0.00           C  
ATOM     39  O   MET A   1     -23.071  45.647  28.588  1.00  0.00           O  
ATOM     40  CB  MET A   1     -25.508  45.850  30.109  1.00  0.00           C  
ATOM     41  CG  MET A   1     -26.839  46.242  30.730  1.00  0.00           C  
ATOM     42  SD  MET A   1     -27.828  44.813  31.211  1.00  0.00           S  
ATOM     43  CE  MET A   1     -28.147  44.068  29.614  1.00  0.00           C  
ATOM     44  H   MET A   1     -26.000  47.544  28.287  1.00  0.00           H  
ATOM     45  HA  MET A   1     -24.521  47.662  30.678  1.00  0.00           H  
ATOM     46  HB2 MET A   1     -25.706  45.315  29.193  1.00  0.00           H  
ATOM     47  HB3 MET A   1     -24.995  45.194  30.797  1.00  0.00           H  
ATOM     48  HG2 MET A   1     -26.650  46.842  31.607  1.00  0.00           H  
ATOM     49  HG3 MET A   1     -27.398  46.824  30.011  1.00  0.00           H  
ATOM     50  HE1 MET A   1     -28.304  44.844  28.879  1.00  0.00           H  
ATOM     51  HE2 MET A   1     -27.301  43.464  29.322  1.00  0.00           H  
ATOM     52  HE3 MET A   1     -29.028  43.448  29.676  1.00  0.00           H  
ATOM     53  N   SER A   2     -22.189  47.163  29.997  1.00  0.00           N  
ATOM     54  CA  SER A   2     -20.809  46.793  29.707  1.00  0.00           C  
ATOM     55  C   SER A   2     -20.230  45.937  30.829  1.00  0.00           C  
ATOM     56  O   SER A   2     -19.696  46.456  31.810  1.00  0.00           O  
ATOM     57  CB  SER A   2     -19.952  48.045  29.512  1.00  0.00           C  
ATOM     58  OG  SER A   2     -20.558  48.939  28.595  1.00  0.00           O  
ATOM     59  H   SER A   2     -22.367  47.882  30.641  1.00  0.00           H  
ATOM     60  HA  SER A   2     -20.806  46.218  28.793  1.00  0.00           H  
ATOM     61  HB2 SER A   2     -19.832  48.547  30.460  1.00  0.00           H  
ATOM     62  HB3 SER A   2     -18.982  47.759  29.131  1.00  0.00           H  
ATOM     63  HG  SER A   2     -20.717  48.486  27.763  1.00  0.00           H  
ATOM     64  N   HIS A   3     -20.339  44.620  30.677  1.00  0.00           N  
ATOM     65  CA  HIS A   3     -19.825  43.691  31.677  1.00  0.00           C  
ATOM     66  C   HIS A   3     -18.341  43.417  31.452  1.00  0.00           C  
ATOM     67  O   HIS A   3     -17.752  43.890  30.480  1.00  0.00           O  
ATOM     68  CB  HIS A   3     -20.609  42.379  31.633  1.00  0.00           C  
ATOM     69  CG  HIS A   3     -22.078  42.551  31.873  1.00  0.00           C  
ATOM     70  ND1 HIS A   3     -23.038  41.786  31.243  1.00  0.00           N  
ATOM     71  CD2 HIS A   3     -22.749  43.406  32.679  1.00  0.00           C  
ATOM     72  CE1 HIS A   3     -24.236  42.164  31.651  1.00  0.00           C  
ATOM     73  NE2 HIS A   3     -24.088  43.145  32.524  1.00  0.00           N  
ATOM     74  H   HIS A   3     -20.773  44.267  29.873  1.00  0.00           H  
ATOM     75  HA  HIS A   3     -19.953  44.144  32.648  1.00  0.00           H  
ATOM     76  HB2 HIS A   3     -20.483  41.923  30.662  1.00  0.00           H  
ATOM     77  HB3 HIS A   3     -20.224  41.711  32.391  1.00  0.00           H  
ATOM     78  HD1 HIS A   3     -22.866  41.074  30.594  1.00  0.00           H  
ATOM     79  HD2 HIS A   3     -22.313  44.154  33.326  1.00  0.00           H  
ATOM     80  HE1 HIS A   3     -25.176  41.743  31.329  1.00  0.00           H  
ATOM     81  N   ASP A   4     -17.742  42.652  32.359  1.00  0.00           N  
ATOM     82  CA  ASP A   4     -16.326  42.315  32.260  1.00  0.00           C  
ATOM     83  C   ASP A   4     -16.141  40.837  31.931  1.00  0.00           C  
ATOM     84  O   ASP A   4     -15.603  40.488  30.881  1.00  0.00           O  
ATOM     85  CB  ASP A   4     -15.608  42.653  33.567  1.00  0.00           C  
ATOM     86  CG  ASP A   4     -15.569  44.145  33.837  1.00  0.00           C  
ATOM     87  OD1 ASP A   4     -14.616  44.806  33.374  1.00  0.00           O  
ATOM     88  OD2 ASP A   4     -16.490  44.650  34.512  1.00  0.00           O  
ATOM     89  H   ASP A   4     -18.265  42.304  33.112  1.00  0.00           H  
ATOM     90  HA  ASP A   4     -15.900  42.905  31.463  1.00  0.00           H  
ATOM     91  HB2 ASP A   4     -16.120  42.172  34.387  1.00  0.00           H  
ATOM     92  HB3 ASP A   4     -14.593  42.287  33.518  1.00  0.00           H  
ATOM     93  N   GLY A   5     -16.589  39.973  32.837  1.00  0.00           N  
ATOM     94  CA  GLY A   5     -16.462  38.543  32.625  1.00  0.00           C  
ATOM     95  C   GLY A   5     -15.024  38.070  32.714  1.00  0.00           C  
ATOM     96  O   GLY A   5     -14.446  38.014  33.800  1.00  0.00           O  
ATOM     97  H   GLY A   5     -17.009  40.310  33.657  1.00  0.00           H  
ATOM     98  HA2 GLY A   5     -17.046  38.026  33.370  1.00  0.00           H  
ATOM     99  HA3 GLY A   5     -16.848  38.300  31.646  1.00  0.00           H  
ATOM    100  N   LYS A   6     -14.444  37.726  31.569  1.00  0.00           N  
ATOM    101  CA  LYS A   6     -13.066  37.253  31.521  1.00  0.00           C  
ATOM    102  C   LYS A   6     -12.352  37.783  30.280  1.00  0.00           C  
ATOM    103  O   LYS A   6     -12.145  37.050  29.313  1.00  0.00           O  
ATOM    104  CB  LYS A   6     -13.028  35.724  31.530  1.00  0.00           C  
ATOM    105  CG  LYS A   6     -12.971  35.125  32.925  1.00  0.00           C  
ATOM    106  CD  LYS A   6     -12.215  33.808  32.936  1.00  0.00           C  
ATOM    107  CE  LYS A   6     -11.606  33.527  34.302  1.00  0.00           C  
ATOM    108  NZ  LYS A   6     -11.091  32.133  34.403  1.00  0.00           N  
ATOM    109  H   LYS A   6     -14.956  37.792  30.735  1.00  0.00           H  
ATOM    110  HA  LYS A   6     -12.557  37.623  32.399  1.00  0.00           H  
ATOM    111  HB2 LYS A   6     -13.913  35.351  31.036  1.00  0.00           H  
ATOM    112  HB3 LYS A   6     -12.155  35.394  30.984  1.00  0.00           H  
ATOM    113  HG2 LYS A   6     -12.474  35.820  33.586  1.00  0.00           H  
ATOM    114  HG3 LYS A   6     -13.980  34.953  33.274  1.00  0.00           H  
ATOM    115  HD2 LYS A   6     -12.896  33.008  32.687  1.00  0.00           H  
ATOM    116  HD3 LYS A   6     -11.424  33.851  32.201  1.00  0.00           H  
ATOM    117  HE2 LYS A   6     -10.792  34.215  34.467  1.00  0.00           H  
ATOM    118  HE3 LYS A   6     -12.364  33.677  35.056  1.00  0.00           H  
ATOM    119  HZ1 LYS A   6     -11.803  31.520  34.847  1.00  0.00           H  
ATOM    120  HZ2 LYS A   6     -10.224  32.114  34.977  1.00  0.00           H  
ATOM    121  HZ3 LYS A   6     -10.874  31.763  33.456  1.00  0.00           H  
ATOM    122  N   GLU A   7     -11.979  39.058  30.317  1.00  0.00           N  
ATOM    123  CA  GLU A   7     -11.288  39.683  29.195  1.00  0.00           C  
ATOM    124  C   GLU A   7      -9.781  39.721  29.436  1.00  0.00           C  
ATOM    125  O   GLU A   7      -9.320  39.552  30.564  1.00  0.00           O  
ATOM    126  CB  GLU A   7     -11.816  41.102  28.970  1.00  0.00           C  
ATOM    127  CG  GLU A   7     -11.358  42.096  30.024  1.00  0.00           C  
ATOM    128  CD  GLU A   7     -12.168  43.378  30.007  1.00  0.00           C  
ATOM    129  OE1 GLU A   7     -13.376  43.313  29.699  1.00  0.00           O  
ATOM    130  OE2 GLU A   7     -11.592  44.446  30.304  1.00  0.00           O  
ATOM    131  H   GLU A   7     -12.173  39.590  31.116  1.00  0.00           H  
ATOM    132  HA  GLU A   7     -11.485  39.092  28.314  1.00  0.00           H  
ATOM    133  HB2 GLU A   7     -11.477  41.450  28.006  1.00  0.00           H  
ATOM    134  HB3 GLU A   7     -12.895  41.076  28.974  1.00  0.00           H  
ATOM    135  HG2 GLU A   7     -11.456  41.639  30.998  1.00  0.00           H  
ATOM    136  HG3 GLU A   7     -10.321  42.340  29.845  1.00  0.00           H  
ATOM    137  N   GLU A   8      -9.023  39.943  28.368  1.00  0.00           N  
ATOM    138  CA  GLU A   8      -7.569  40.002  28.463  1.00  0.00           C  
ATOM    139  C   GLU A   8      -7.067  41.426  28.246  1.00  0.00           C  
ATOM    140  O   GLU A   8      -7.761  42.280  27.695  1.00  0.00           O  
ATOM    141  CB  GLU A   8      -6.930  39.062  27.438  1.00  0.00           C  
ATOM    142  CG  GLU A   8      -6.522  37.717  28.016  1.00  0.00           C  
ATOM    143  CD  GLU A   8      -7.568  37.143  28.952  1.00  0.00           C  
ATOM    144  OE1 GLU A   8      -8.761  37.147  28.581  1.00  0.00           O  
ATOM    145  OE2 GLU A   8      -7.195  36.689  30.053  1.00  0.00           O  
ATOM    146  H   GLU A   8      -9.450  40.070  27.495  1.00  0.00           H  
ATOM    147  HA  GLU A   8      -7.288  39.681  29.454  1.00  0.00           H  
ATOM    148  HB2 GLU A   8      -7.635  38.889  26.639  1.00  0.00           H  
ATOM    149  HB3 GLU A   8      -6.050  39.537  27.032  1.00  0.00           H  
ATOM    150  HG2 GLU A   8      -6.368  37.022  27.204  1.00  0.00           H  
ATOM    151  HG3 GLU A   8      -5.599  37.841  28.563  1.00  0.00           H  
ATOM    152  N   PRO A   9      -5.829  41.691  28.691  1.00  0.00           N  
ATOM    153  CA  PRO A   9      -5.205  43.009  28.558  1.00  0.00           C  
ATOM    154  C   PRO A   9      -4.861  43.345  27.110  1.00  0.00           C  
ATOM    155  O   PRO A   9      -5.169  42.581  26.196  1.00  0.00           O  
ATOM    156  CB  PRO A   9      -3.929  42.885  29.395  1.00  0.00           C  
ATOM    157  CG  PRO A   9      -3.617  41.429  29.395  1.00  0.00           C  
ATOM    158  CD  PRO A   9      -4.943  40.721  29.359  1.00  0.00           C  
ATOM    159  HA  PRO A   9      -5.831  43.788  28.968  1.00  0.00           H  
ATOM    160  HB2 PRO A   9      -3.137  43.459  28.936  1.00  0.00           H  
ATOM    161  HB3 PRO A   9      -4.112  43.250  30.394  1.00  0.00           H  
ATOM    162  HG2 PRO A   9      -3.034  41.177  28.522  1.00  0.00           H  
ATOM    163  HG3 PRO A   9      -3.079  41.169  30.295  1.00  0.00           H  
ATOM    164  HD2 PRO A   9      -4.868  39.808  28.786  1.00  0.00           H  
ATOM    165  HD3 PRO A   9      -5.288  40.512  30.361  1.00  0.00           H  
ATOM    166  N   GLY A  10      -4.221  44.493  26.909  1.00  0.00           N  
ATOM    167  CA  GLY A  10      -3.846  44.909  25.570  1.00  0.00           C  
ATOM    168  C   GLY A  10      -4.857  45.855  24.952  1.00  0.00           C  
ATOM    169  O   GLY A  10      -5.995  45.468  24.682  1.00  0.00           O  
ATOM    170  H   GLY A  10      -4.002  45.063  27.675  1.00  0.00           H  
ATOM    171  HA2 GLY A  10      -2.887  45.401  25.612  1.00  0.00           H  
ATOM    172  HA3 GLY A  10      -3.762  44.032  24.944  1.00  0.00           H  
ATOM    173  N   ILE A  11      -4.443  47.097  24.730  1.00  0.00           N  
ATOM    174  CA  ILE A  11      -5.320  48.101  24.141  1.00  0.00           C  
ATOM    175  C   ILE A  11      -4.878  48.457  22.727  1.00  0.00           C  
ATOM    176  O   ILE A  11      -3.729  48.839  22.503  1.00  0.00           O  
ATOM    177  CB  ILE A  11      -5.361  49.383  24.994  1.00  0.00           C  
ATOM    178  CG1 ILE A  11      -5.740  49.052  26.438  1.00  0.00           C  
ATOM    179  CG2 ILE A  11      -6.340  50.384  24.399  1.00  0.00           C  
ATOM    180  CD1 ILE A  11      -4.549  48.799  27.334  1.00  0.00           C  
ATOM    181  H   ILE A  11      -3.526  47.345  24.968  1.00  0.00           H  
ATOM    182  HA  ILE A  11      -6.318  47.688  24.102  1.00  0.00           H  
ATOM    183  HB  ILE A  11      -4.376  49.828  24.980  1.00  0.00           H  
ATOM    184 HG12 ILE A  11      -6.300  49.874  26.855  1.00  0.00           H  
ATOM    185 HG13 ILE A  11      -6.356  48.163  26.445  1.00  0.00           H  
ATOM    186 HG21 ILE A  11      -5.793  51.192  23.935  1.00  0.00           H  
ATOM    187 HG22 ILE A  11      -6.950  49.892  23.656  1.00  0.00           H  
ATOM    188 HG23 ILE A  11      -6.970  50.779  25.181  1.00  0.00           H  
ATOM    189 HD11 ILE A  11      -3.661  49.217  26.879  1.00  0.00           H  
ATOM    190 HD12 ILE A  11      -4.714  49.265  28.294  1.00  0.00           H  
ATOM    191 HD13 ILE A  11      -4.416  47.736  27.466  1.00  0.00           H  
ATOM    192  N   ALA A  12      -5.797  48.331  21.775  1.00  0.00           N  
ATOM    193  CA  ALA A  12      -5.502  48.644  20.383  1.00  0.00           C  
ATOM    194  C   ALA A  12      -6.138  49.966  19.970  1.00  0.00           C  
ATOM    195  O   ALA A  12      -7.362  50.082  19.896  1.00  0.00           O  
ATOM    196  CB  ALA A  12      -5.982  47.520  19.476  1.00  0.00           C  
ATOM    197  H   ALA A  12      -6.694  48.022  22.016  1.00  0.00           H  
ATOM    198  HA  ALA A  12      -4.429  48.724  20.278  1.00  0.00           H  
ATOM    199  HB1 ALA A  12      -5.348  46.655  19.609  1.00  0.00           H  
ATOM    200  HB2 ALA A  12      -6.999  47.262  19.731  1.00  0.00           H  
ATOM    201  HB3 ALA A  12      -5.939  47.843  18.448  1.00  0.00           H  
ATOM    202  N   LYS A  13      -5.301  50.963  19.703  1.00  0.00           N  
ATOM    203  CA  LYS A  13      -5.781  52.279  19.296  1.00  0.00           C  
ATOM    204  C   LYS A  13      -4.940  52.834  18.151  1.00  0.00           C  
ATOM    205  O   LYS A  13      -3.728  52.624  18.098  1.00  0.00           O  
ATOM    206  CB  LYS A  13      -5.747  53.244  20.484  1.00  0.00           C  
ATOM    207  CG  LYS A  13      -4.355  53.751  20.817  1.00  0.00           C  
ATOM    208  CD  LYS A  13      -4.373  54.678  22.020  1.00  0.00           C  
ATOM    209  CE  LYS A  13      -4.675  53.919  23.304  1.00  0.00           C  
ATOM    210  NZ  LYS A  13      -6.122  53.972  23.652  1.00  0.00           N  
ATOM    211  H   LYS A  13      -4.335  50.808  19.780  1.00  0.00           H  
ATOM    212  HA  LYS A  13      -6.800  52.170  18.959  1.00  0.00           H  
ATOM    213  HB2 LYS A  13      -6.373  54.095  20.256  1.00  0.00           H  
ATOM    214  HB3 LYS A  13      -6.142  52.740  21.353  1.00  0.00           H  
ATOM    215  HG2 LYS A  13      -3.718  52.906  21.036  1.00  0.00           H  
ATOM    216  HG3 LYS A  13      -3.964  54.289  19.966  1.00  0.00           H  
ATOM    217  HD2 LYS A  13      -3.406  55.150  22.115  1.00  0.00           H  
ATOM    218  HD3 LYS A  13      -5.132  55.433  21.872  1.00  0.00           H  
ATOM    219  HE2 LYS A  13      -4.381  52.889  23.175  1.00  0.00           H  
ATOM    220  HE3 LYS A  13      -4.104  54.358  24.109  1.00  0.00           H  
ATOM    221  HZ1 LYS A  13      -6.522  53.012  23.660  1.00  0.00           H  
ATOM    222  HZ2 LYS A  13      -6.637  54.544  22.951  1.00  0.00           H  
ATOM    223  HZ3 LYS A  13      -6.250  54.397  24.591  1.00  0.00           H  
ATOM    224  N   LYS A  14      -5.591  53.545  17.237  1.00  0.00           N  
ATOM    225  CA  LYS A  14      -4.904  54.135  16.094  1.00  0.00           C  
ATOM    226  C   LYS A  14      -4.618  55.613  16.335  1.00  0.00           C  
ATOM    227  O   LYS A  14      -5.537  56.410  16.524  1.00  0.00           O  
ATOM    228  CB  LYS A  14      -5.744  53.967  14.826  1.00  0.00           C  
ATOM    229  CG  LYS A  14      -5.218  52.897  13.885  1.00  0.00           C  
ATOM    230  CD  LYS A  14      -5.925  52.940  12.541  1.00  0.00           C  
ATOM    231  CE  LYS A  14      -7.151  52.038  12.527  1.00  0.00           C  
ATOM    232  NZ  LYS A  14      -6.833  50.680  12.006  1.00  0.00           N  
ATOM    233  H   LYS A  14      -6.558  53.678  17.334  1.00  0.00           H  
ATOM    234  HA  LYS A  14      -3.966  53.615  15.966  1.00  0.00           H  
ATOM    235  HB2 LYS A  14      -6.753  53.704  15.109  1.00  0.00           H  
ATOM    236  HB3 LYS A  14      -5.763  54.907  14.294  1.00  0.00           H  
ATOM    237  HG2 LYS A  14      -4.161  53.056  13.728  1.00  0.00           H  
ATOM    238  HG3 LYS A  14      -5.376  51.926  14.334  1.00  0.00           H  
ATOM    239  HD2 LYS A  14      -6.237  53.954  12.340  1.00  0.00           H  
ATOM    240  HD3 LYS A  14      -5.240  52.612  11.772  1.00  0.00           H  
ATOM    241  HE2 LYS A  14      -7.527  51.949  13.534  1.00  0.00           H  
ATOM    242  HE3 LYS A  14      -7.905  52.488  11.899  1.00  0.00           H  
ATOM    243  HZ1 LYS A  14      -7.135  49.955  12.689  1.00  0.00           H  
ATOM    244  HZ2 LYS A  14      -5.809  50.588  11.849  1.00  0.00           H  
ATOM    245  HZ3 LYS A  14      -7.326  50.519  11.105  1.00  0.00           H  
ATOM    246  N   ILE A  15      -3.339  55.973  16.325  1.00  0.00           N  
ATOM    247  CA  ILE A  15      -2.932  57.357  16.538  1.00  0.00           C  
ATOM    248  C   ILE A  15      -2.419  57.985  15.247  1.00  0.00           C  
ATOM    249  O   ILE A  15      -2.345  57.326  14.212  1.00  0.00           O  
ATOM    250  CB  ILE A  15      -1.838  57.461  17.617  1.00  0.00           C  
ATOM    251  CG1 ILE A  15      -0.568  56.742  17.159  1.00  0.00           C  
ATOM    252  CG2 ILE A  15      -2.336  56.883  18.934  1.00  0.00           C  
ATOM    253  CD1 ILE A  15       0.603  56.926  18.097  1.00  0.00           C  
ATOM    254  H   ILE A  15      -2.652  55.291  16.169  1.00  0.00           H  
ATOM    255  HA  ILE A  15      -3.797  57.908  16.877  1.00  0.00           H  
ATOM    256  HB  ILE A  15      -1.615  58.506  17.772  1.00  0.00           H  
ATOM    257 HG12 ILE A  15      -0.769  55.684  17.084  1.00  0.00           H  
ATOM    258 HG13 ILE A  15      -0.281  57.119  16.188  1.00  0.00           H  
ATOM    259 HG21 ILE A  15      -2.708  55.883  18.769  1.00  0.00           H  
ATOM    260 HG22 ILE A  15      -1.521  56.850  19.642  1.00  0.00           H  
ATOM    261 HG23 ILE A  15      -3.128  57.503  19.324  1.00  0.00           H  
ATOM    262 HD11 ILE A  15       1.449  57.312  17.545  1.00  0.00           H  
ATOM    263 HD12 ILE A  15       0.335  57.626  18.876  1.00  0.00           H  
ATOM    264 HD13 ILE A  15       0.865  55.978  18.539  1.00  0.00           H  
ATOM    265  N   ASN A  16      -2.066  59.264  15.318  1.00  0.00           N  
ATOM    266  CA  ASN A  16      -1.558  59.982  14.155  1.00  0.00           C  
ATOM    267  C   ASN A  16      -0.402  60.900  14.544  1.00  0.00           C  
ATOM    268  O   ASN A  16      -0.010  61.779  13.777  1.00  0.00           O  
ATOM    269  CB  ASN A  16      -2.676  60.799  13.506  1.00  0.00           C  
ATOM    270  CG  ASN A  16      -3.483  59.988  12.510  1.00  0.00           C  
ATOM    271  OD1 ASN A  16      -4.661  59.707  12.731  1.00  0.00           O  
ATOM    272  ND2 ASN A  16      -2.849  59.607  11.408  1.00  0.00           N  
ATOM    273  H   ASN A  16      -2.148  59.737  16.173  1.00  0.00           H  
ATOM    274  HA  ASN A  16      -1.199  59.252  13.445  1.00  0.00           H  
ATOM    275  HB2 ASN A  16      -3.346  61.156  14.275  1.00  0.00           H  
ATOM    276  HB3 ASN A  16      -2.245  61.644  12.990  1.00  0.00           H  
ATOM    277 HD21 ASN A  16      -1.910  59.867  11.299  1.00  0.00           H  
ATOM    278 HD22 ASN A  16      -3.346  59.082  10.746  1.00  0.00           H  
ATOM    279  N   SER A  17       0.138  60.687  15.740  1.00  0.00           N  
ATOM    280  CA  SER A  17       1.247  61.497  16.232  1.00  0.00           C  
ATOM    281  C   SER A  17       2.263  60.633  16.972  1.00  0.00           C  
ATOM    282  O   SER A  17       1.909  59.867  17.868  1.00  0.00           O  
ATOM    283  CB  SER A  17       0.728  62.600  17.156  1.00  0.00           C  
ATOM    284  OG  SER A  17      -0.473  63.162  16.658  1.00  0.00           O  
ATOM    285  H   SER A  17      -0.219  59.971  16.304  1.00  0.00           H  
ATOM    286  HA  SER A  17       1.730  61.951  15.380  1.00  0.00           H  
ATOM    287  HB2 SER A  17       0.539  62.187  18.135  1.00  0.00           H  
ATOM    288  HB3 SER A  17       1.472  63.381  17.232  1.00  0.00           H  
ATOM    289  HG  SER A  17      -0.287  63.659  15.858  1.00  0.00           H  
ATOM    290  N   VAL A  18       3.530  60.763  16.590  1.00  0.00           N  
ATOM    291  CA  VAL A  18       4.600  59.996  17.218  1.00  0.00           C  
ATOM    292  C   VAL A  18       4.861  60.479  18.640  1.00  0.00           C  
ATOM    293  O   VAL A  18       5.506  59.790  19.431  1.00  0.00           O  
ATOM    294  CB  VAL A  18       5.906  60.090  16.408  1.00  0.00           C  
ATOM    295  CG1 VAL A  18       5.671  59.673  14.964  1.00  0.00           C  
ATOM    296  CG2 VAL A  18       6.477  61.498  16.479  1.00  0.00           C  
ATOM    297  H   VAL A  18       3.750  61.391  15.871  1.00  0.00           H  
ATOM    298  HA  VAL A  18       4.294  58.961  17.249  1.00  0.00           H  
ATOM    299  HB  VAL A  18       6.625  59.411  16.843  1.00  0.00           H  
ATOM    300 HG11 VAL A  18       5.402  58.627  14.931  1.00  0.00           H  
ATOM    301 HG12 VAL A  18       4.871  60.264  14.544  1.00  0.00           H  
ATOM    302 HG13 VAL A  18       6.574  59.830  14.392  1.00  0.00           H  
ATOM    303 HG21 VAL A  18       7.193  61.638  15.681  1.00  0.00           H  
ATOM    304 HG22 VAL A  18       5.676  62.216  16.373  1.00  0.00           H  
ATOM    305 HG23 VAL A  18       6.966  61.642  17.431  1.00  0.00           H  
ATOM    306  N   ASP A  19       4.355  61.665  18.958  1.00  0.00           N  
ATOM    307  CA  ASP A  19       4.533  62.240  20.287  1.00  0.00           C  
ATOM    308  C   ASP A  19       3.901  61.350  21.353  1.00  0.00           C  
ATOM    309  O   ASP A  19       4.439  61.201  22.450  1.00  0.00           O  
ATOM    310  CB  ASP A  19       3.920  63.641  20.346  1.00  0.00           C  
ATOM    311  CG  ASP A  19       4.014  64.256  21.728  1.00  0.00           C  
ATOM    312  OD1 ASP A  19       5.138  64.342  22.264  1.00  0.00           O  
ATOM    313  OD2 ASP A  19       2.963  64.653  22.272  1.00  0.00           O  
ATOM    314  H   ASP A  19       3.850  62.167  18.283  1.00  0.00           H  
ATOM    315  HA  ASP A  19       5.593  62.313  20.478  1.00  0.00           H  
ATOM    316  HB2 ASP A  19       4.440  64.283  19.650  1.00  0.00           H  
ATOM    317  HB3 ASP A  19       2.878  63.583  20.066  1.00  0.00           H  
ATOM    318  N   ASP A  20       2.756  60.763  21.023  1.00  0.00           N  
ATOM    319  CA  ASP A  20       2.051  59.887  21.952  1.00  0.00           C  
ATOM    320  C   ASP A  20       2.635  58.478  21.921  1.00  0.00           C  
ATOM    321  O   ASP A  20       1.919  57.504  21.686  1.00  0.00           O  
ATOM    322  CB  ASP A  20       0.560  59.842  21.611  1.00  0.00           C  
ATOM    323  CG  ASP A  20      -0.208  60.996  22.224  1.00  0.00           C  
ATOM    324  OD1 ASP A  20      -0.325  61.039  23.467  1.00  0.00           O  
ATOM    325  OD2 ASP A  20      -0.693  61.857  21.461  1.00  0.00           O  
ATOM    326  H   ASP A  20       2.377  60.921  20.133  1.00  0.00           H  
ATOM    327  HA  ASP A  20       2.172  60.291  22.945  1.00  0.00           H  
ATOM    328  HB2 ASP A  20       0.441  59.883  20.539  1.00  0.00           H  
ATOM    329  HB3 ASP A  20       0.142  58.918  21.980  1.00  0.00           H  
ATOM    330  N   ILE A  21       3.939  58.379  22.157  1.00  0.00           N  
ATOM    331  CA  ILE A  21       4.619  57.090  22.156  1.00  0.00           C  
ATOM    332  C   ILE A  21       5.415  56.887  23.441  1.00  0.00           C  
ATOM    333  O   ILE A  21       6.038  57.818  23.951  1.00  0.00           O  
ATOM    334  CB  ILE A  21       5.568  56.954  20.951  1.00  0.00           C  
ATOM    335  CG1 ILE A  21       4.775  56.996  19.642  1.00  0.00           C  
ATOM    336  CG2 ILE A  21       6.370  55.665  21.050  1.00  0.00           C  
ATOM    337  CD1 ILE A  21       5.649  57.027  18.407  1.00  0.00           C  
ATOM    338  H   ILE A  21       4.456  59.191  22.336  1.00  0.00           H  
ATOM    339  HA  ILE A  21       3.867  56.317  22.084  1.00  0.00           H  
ATOM    340  HB  ILE A  21       6.259  57.782  20.971  1.00  0.00           H  
ATOM    341 HG12 ILE A  21       4.147  56.122  19.581  1.00  0.00           H  
ATOM    342 HG13 ILE A  21       4.156  57.881  19.634  1.00  0.00           H  
ATOM    343 HG21 ILE A  21       5.694  54.827  21.141  1.00  0.00           H  
ATOM    344 HG22 ILE A  21       6.970  55.545  20.160  1.00  0.00           H  
ATOM    345 HG23 ILE A  21       7.012  55.705  21.916  1.00  0.00           H  
ATOM    346 HD11 ILE A  21       6.219  56.111  18.346  1.00  0.00           H  
ATOM    347 HD12 ILE A  21       5.028  57.123  17.530  1.00  0.00           H  
ATOM    348 HD13 ILE A  21       6.324  57.867  18.465  1.00  0.00           H  
ATOM    349  N   ILE A  22       5.391  55.662  23.958  1.00  0.00           N  
ATOM    350  CA  ILE A  22       6.112  55.337  25.182  1.00  0.00           C  
ATOM    351  C   ILE A  22       6.970  54.090  24.998  1.00  0.00           C  
ATOM    352  O   ILE A  22       7.027  53.517  23.910  1.00  0.00           O  
ATOM    353  CB  ILE A  22       5.148  55.114  26.362  1.00  0.00           C  
ATOM    354  CG1 ILE A  22       4.082  54.081  25.990  1.00  0.00           C  
ATOM    355  CG2 ILE A  22       4.500  56.428  26.771  1.00  0.00           C  
ATOM    356  CD1 ILE A  22       3.311  53.555  27.180  1.00  0.00           C  
ATOM    357  H   ILE A  22       4.876  54.963  23.505  1.00  0.00           H  
ATOM    358  HA  ILE A  22       6.756  56.171  25.421  1.00  0.00           H  
ATOM    359  HB  ILE A  22       5.719  54.746  27.200  1.00  0.00           H  
ATOM    360 HG12 ILE A  22       3.376  54.530  25.310  1.00  0.00           H  
ATOM    361 HG13 ILE A  22       4.560  53.242  25.504  1.00  0.00           H  
ATOM    362 HG21 ILE A  22       3.481  56.454  26.414  1.00  0.00           H  
ATOM    363 HG22 ILE A  22       4.505  56.513  27.847  1.00  0.00           H  
ATOM    364 HG23 ILE A  22       5.052  57.251  26.343  1.00  0.00           H  
ATOM    365 HD11 ILE A  22       4.003  53.185  27.922  1.00  0.00           H  
ATOM    366 HD12 ILE A  22       2.718  54.350  27.606  1.00  0.00           H  
ATOM    367 HD13 ILE A  22       2.662  52.752  26.862  1.00  0.00           H  
ATOM    368  N   ILE A  23       7.635  53.672  26.070  1.00  0.00           N  
ATOM    369  CA  ILE A  23       8.488  52.491  26.029  1.00  0.00           C  
ATOM    370  C   ILE A  23       7.655  51.216  25.947  1.00  0.00           C  
ATOM    371  O   ILE A  23       8.122  50.188  25.455  1.00  0.00           O  
ATOM    372  CB  ILE A  23       9.404  52.414  27.264  1.00  0.00           C  
ATOM    373  CG1 ILE A  23      10.369  53.602  27.286  1.00  0.00           C  
ATOM    374  CG2 ILE A  23      10.172  51.101  27.272  1.00  0.00           C  
ATOM    375  CD1 ILE A  23       9.780  54.847  27.911  1.00  0.00           C  
ATOM    376  H   ILE A  23       7.550  54.171  26.910  1.00  0.00           H  
ATOM    377  HA  ILE A  23       9.109  52.560  25.148  1.00  0.00           H  
ATOM    378  HB  ILE A  23       8.784  52.447  28.147  1.00  0.00           H  
ATOM    379 HG12 ILE A  23      11.248  53.333  27.848  1.00  0.00           H  
ATOM    380 HG13 ILE A  23      10.654  53.843  26.271  1.00  0.00           H  
ATOM    381 HG21 ILE A  23      10.992  51.169  27.972  1.00  0.00           H  
ATOM    382 HG22 ILE A  23       9.511  50.300  27.569  1.00  0.00           H  
ATOM    383 HG23 ILE A  23      10.559  50.903  26.284  1.00  0.00           H  
ATOM    384 HD11 ILE A  23       9.184  55.371  27.178  1.00  0.00           H  
ATOM    385 HD12 ILE A  23       9.156  54.570  28.748  1.00  0.00           H  
ATOM    386 HD13 ILE A  23      10.577  55.490  28.252  1.00  0.00           H  
ATOM    387  N   LYS A  24       6.421  51.290  26.431  1.00  0.00           N  
ATOM    388  CA  LYS A  24       5.521  50.143  26.410  1.00  0.00           C  
ATOM    389  C   LYS A  24       4.633  50.169  25.170  1.00  0.00           C  
ATOM    390  O   LYS A  24       3.747  49.330  25.010  1.00  0.00           O  
ATOM    391  CB  LYS A  24       4.652  50.127  27.670  1.00  0.00           C  
ATOM    392  CG  LYS A  24       5.399  49.690  28.918  1.00  0.00           C  
ATOM    393  CD  LYS A  24       5.965  50.879  29.675  1.00  0.00           C  
ATOM    394  CE  LYS A  24       6.431  50.483  31.068  1.00  0.00           C  
ATOM    395  NZ  LYS A  24       5.285  50.261  31.993  1.00  0.00           N  
ATOM    396  H   LYS A  24       6.106  52.137  26.811  1.00  0.00           H  
ATOM    397  HA  LYS A  24       6.123  49.249  26.388  1.00  0.00           H  
ATOM    398  HB2 LYS A  24       4.264  51.121  27.838  1.00  0.00           H  
ATOM    399  HB3 LYS A  24       3.825  49.449  27.515  1.00  0.00           H  
ATOM    400  HG2 LYS A  24       4.719  49.155  29.565  1.00  0.00           H  
ATOM    401  HG3 LYS A  24       6.211  49.038  28.630  1.00  0.00           H  
ATOM    402  HD2 LYS A  24       6.805  51.277  29.126  1.00  0.00           H  
ATOM    403  HD3 LYS A  24       5.199  51.637  29.763  1.00  0.00           H  
ATOM    404  HE2 LYS A  24       7.006  49.574  30.996  1.00  0.00           H  
ATOM    405  HE3 LYS A  24       7.053  51.273  31.463  1.00  0.00           H  
ATOM    406  HZ1 LYS A  24       4.388  50.439  31.500  1.00  0.00           H  
ATOM    407  HZ2 LYS A  24       5.355  50.904  32.809  1.00  0.00           H  
ATOM    408  HZ3 LYS A  24       5.290  49.280  32.338  1.00  0.00           H  
ATOM    409  N   CYS A  25       4.879  51.137  24.292  1.00  0.00           N  
ATOM    410  CA  CYS A  25       4.103  51.271  23.065  1.00  0.00           C  
ATOM    411  C   CYS A  25       4.718  50.446  21.940  1.00  0.00           C  
ATOM    412  O   CYS A  25       5.938  50.401  21.786  1.00  0.00           O  
ATOM    413  CB  CYS A  25       4.019  52.741  22.649  1.00  0.00           C  
ATOM    414  SG  CYS A  25       3.435  52.997  20.957  1.00  0.00           S  
ATOM    415  H   CYS A  25       5.599  51.776  24.475  1.00  0.00           H  
ATOM    416  HA  CYS A  25       3.107  50.904  23.262  1.00  0.00           H  
ATOM    417  HB2 CYS A  25       3.340  53.257  23.313  1.00  0.00           H  
ATOM    418  HB3 CYS A  25       4.999  53.186  22.731  1.00  0.00           H  
ATOM    419  HG  CYS A  25       4.493  53.066  20.166  1.00  0.00           H  
ATOM    420  N   GLN A  26       3.864  49.794  21.157  1.00  0.00           N  
ATOM    421  CA  GLN A  26       4.323  48.968  20.048  1.00  0.00           C  
ATOM    422  C   GLN A  26       3.681  49.409  18.737  1.00  0.00           C  
ATOM    423  O   GLN A  26       2.469  49.619  18.668  1.00  0.00           O  
ATOM    424  CB  GLN A  26       4.007  47.495  20.314  1.00  0.00           C  
ATOM    425  CG  GLN A  26       4.655  46.952  21.577  1.00  0.00           C  
ATOM    426  CD  GLN A  26       4.070  45.621  22.008  1.00  0.00           C  
ATOM    427  OE1 GLN A  26       4.477  44.565  21.522  1.00  0.00           O  
ATOM    428  NE2 GLN A  26       3.110  45.665  22.923  1.00  0.00           N  
ATOM    429  H   GLN A  26       2.903  49.869  21.330  1.00  0.00           H  
ATOM    430  HA  GLN A  26       5.394  49.087  19.967  1.00  0.00           H  
ATOM    431  HB2 GLN A  26       2.937  47.381  20.406  1.00  0.00           H  
ATOM    432  HB3 GLN A  26       4.352  46.908  19.477  1.00  0.00           H  
ATOM    433  HG2 GLN A  26       5.712  46.822  21.396  1.00  0.00           H  
ATOM    434  HG3 GLN A  26       4.513  47.666  22.375  1.00  0.00           H  
ATOM    435 HE21 GLN A  26       2.836  46.542  23.265  1.00  0.00           H  
ATOM    436 HE22 GLN A  26       2.713  44.820  23.220  1.00  0.00           H  
ATOM    437  N   CYS A  27       4.499  49.550  17.701  1.00  0.00           N  
ATOM    438  CA  CYS A  27       4.010  49.969  16.391  1.00  0.00           C  
ATOM    439  C   CYS A  27       4.706  49.193  15.277  1.00  0.00           C  
ATOM    440  O   CYS A  27       5.583  48.369  15.536  1.00  0.00           O  
ATOM    441  CB  CYS A  27       4.230  51.470  16.198  1.00  0.00           C  
ATOM    442  SG  CYS A  27       5.940  52.004  16.441  1.00  0.00           S  
ATOM    443  H   CYS A  27       5.455  49.369  17.817  1.00  0.00           H  
ATOM    444  HA  CYS A  27       2.952  49.760  16.351  1.00  0.00           H  
ATOM    445  HB2 CYS A  27       3.940  51.742  15.193  1.00  0.00           H  
ATOM    446  HB3 CYS A  27       3.612  52.010  16.901  1.00  0.00           H  
ATOM    447  HG  CYS A  27       6.590  51.822  15.301  1.00  0.00           H  
ATOM    448  N   TRP A  28       4.308  49.461  14.039  1.00  0.00           N  
ATOM    449  CA  TRP A  28       4.893  48.787  12.886  1.00  0.00           C  
ATOM    450  C   TRP A  28       5.955  49.660  12.226  1.00  0.00           C  
ATOM    451  O   TRP A  28       5.793  50.875  12.116  1.00  0.00           O  
ATOM    452  CB  TRP A  28       3.805  48.433  11.871  1.00  0.00           C  
ATOM    453  CG  TRP A  28       2.959  47.268  12.290  1.00  0.00           C  
ATOM    454  CD1 TRP A  28       1.865  47.301  13.108  1.00  0.00           C  
ATOM    455  CD2 TRP A  28       3.139  45.899  11.913  1.00  0.00           C  
ATOM    456  NE1 TRP A  28       1.355  46.035  13.262  1.00  0.00           N  
ATOM    457  CE2 TRP A  28       2.118  45.156  12.539  1.00  0.00           C  
ATOM    458  CE3 TRP A  28       4.062  45.227  11.108  1.00  0.00           C  
ATOM    459  CZ2 TRP A  28       1.997  43.778  12.383  1.00  0.00           C  
ATOM    460  CZ3 TRP A  28       3.942  43.859  10.954  1.00  0.00           C  
ATOM    461  CH2 TRP A  28       2.915  43.146  11.588  1.00  0.00           C  
ATOM    462  H   TRP A  28       3.604  50.129  13.896  1.00  0.00           H  
ATOM    463  HA  TRP A  28       5.357  47.876  13.235  1.00  0.00           H  
ATOM    464  HB2 TRP A  28       3.155  49.284  11.736  1.00  0.00           H  
ATOM    465  HB3 TRP A  28       4.270  48.185  10.927  1.00  0.00           H  
ATOM    466  HD1 TRP A  28       1.472  48.198  13.561  1.00  0.00           H  
ATOM    467  HE1 TRP A  28       0.571  45.800  13.801  1.00  0.00           H  
ATOM    468  HE3 TRP A  28       4.860  45.758  10.611  1.00  0.00           H  
ATOM    469  HZ2 TRP A  28       1.212  43.215  12.865  1.00  0.00           H  
ATOM    470  HZ3 TRP A  28       4.647  43.322  10.336  1.00  0.00           H  
ATOM    471  HH2 TRP A  28       2.859  42.079  11.440  1.00  0.00           H  
ATOM    472  N   VAL A  29       7.042  49.032  11.789  1.00  0.00           N  
ATOM    473  CA  VAL A  29       8.131  49.752  11.138  1.00  0.00           C  
ATOM    474  C   VAL A  29       8.397  49.200   9.742  1.00  0.00           C  
ATOM    475  O   VAL A  29       8.427  47.986   9.540  1.00  0.00           O  
ATOM    476  CB  VAL A  29       9.427  49.675  11.966  1.00  0.00           C  
ATOM    477  CG1 VAL A  29      10.491  50.589  11.377  1.00  0.00           C  
ATOM    478  CG2 VAL A  29       9.153  50.029  13.419  1.00  0.00           C  
ATOM    479  H   VAL A  29       7.113  48.062  11.905  1.00  0.00           H  
ATOM    480  HA  VAL A  29       7.843  50.790  11.055  1.00  0.00           H  
ATOM    481  HB  VAL A  29       9.796  48.660  11.927  1.00  0.00           H  
ATOM    482 HG11 VAL A  29      11.466  50.274  11.719  1.00  0.00           H  
ATOM    483 HG12 VAL A  29      10.453  50.539  10.299  1.00  0.00           H  
ATOM    484 HG13 VAL A  29      10.310  51.604  11.698  1.00  0.00           H  
ATOM    485 HG21 VAL A  29       8.389  49.374  13.811  1.00  0.00           H  
ATOM    486 HG22 VAL A  29      10.060  49.911  13.995  1.00  0.00           H  
ATOM    487 HG23 VAL A  29       8.816  51.054  13.484  1.00  0.00           H  
ATOM    488  N   GLN A  30       8.593  50.100   8.784  1.00  0.00           N  
ATOM    489  CA  GLN A  30       8.858  49.702   7.406  1.00  0.00           C  
ATOM    490  C   GLN A  30      10.325  49.330   7.219  1.00  0.00           C  
ATOM    491  O   GLN A  30      11.215  50.163   7.393  1.00  0.00           O  
ATOM    492  CB  GLN A  30       8.479  50.831   6.446  1.00  0.00           C  
ATOM    493  CG  GLN A  30       8.881  50.564   5.005  1.00  0.00           C  
ATOM    494  CD  GLN A  30       8.048  51.349   4.010  1.00  0.00           C  
ATOM    495  OE1 GLN A  30       7.883  52.562   4.142  1.00  0.00           O  
ATOM    496  NE2 GLN A  30       7.516  50.659   3.008  1.00  0.00           N  
ATOM    497  H   GLN A  30       8.558  51.053   9.008  1.00  0.00           H  
ATOM    498  HA  GLN A  30       8.249  48.837   7.188  1.00  0.00           H  
ATOM    499  HB2 GLN A  30       7.410  50.972   6.478  1.00  0.00           H  
ATOM    500  HB3 GLN A  30       8.964  51.741   6.769  1.00  0.00           H  
ATOM    501  HG2 GLN A  30       9.918  50.838   4.876  1.00  0.00           H  
ATOM    502  HG3 GLN A  30       8.761  49.511   4.800  1.00  0.00           H  
ATOM    503 HE21 GLN A  30       7.689  49.694   2.968  1.00  0.00           H  
ATOM    504 HE22 GLN A  30       6.973  51.141   2.352  1.00  0.00           H  
ATOM    505  N   LYS A  31      10.571  48.074   6.864  1.00  0.00           N  
ATOM    506  CA  LYS A  31      11.930  47.590   6.652  1.00  0.00           C  
ATOM    507  C   LYS A  31      11.983  46.608   5.487  1.00  0.00           C  
ATOM    508  O   LYS A  31      11.128  45.733   5.361  1.00  0.00           O  
ATOM    509  CB  LYS A  31      12.457  46.919   7.923  1.00  0.00           C  
ATOM    510  CG  LYS A  31      13.895  47.283   8.252  1.00  0.00           C  
ATOM    511  CD  LYS A  31      14.044  48.771   8.522  1.00  0.00           C  
ATOM    512  CE  LYS A  31      15.387  49.088   9.164  1.00  0.00           C  
ATOM    513  NZ  LYS A  31      15.429  50.476   9.703  1.00  0.00           N  
ATOM    514  H   LYS A  31       9.819  47.457   6.740  1.00  0.00           H  
ATOM    515  HA  LYS A  31      12.552  48.441   6.420  1.00  0.00           H  
ATOM    516  HB2 LYS A  31      11.834  47.211   8.755  1.00  0.00           H  
ATOM    517  HB3 LYS A  31      12.400  45.847   7.799  1.00  0.00           H  
ATOM    518  HG2 LYS A  31      14.204  46.736   9.129  1.00  0.00           H  
ATOM    519  HG3 LYS A  31      14.525  47.013   7.416  1.00  0.00           H  
ATOM    520  HD2 LYS A  31      13.970  49.307   7.588  1.00  0.00           H  
ATOM    521  HD3 LYS A  31      13.253  49.089   9.186  1.00  0.00           H  
ATOM    522  HE2 LYS A  31      15.557  48.393   9.972  1.00  0.00           H  
ATOM    523  HE3 LYS A  31      16.162  48.975   8.421  1.00  0.00           H  
ATOM    524  HZ1 LYS A  31      16.146  50.548  10.453  1.00  0.00           H  
ATOM    525  HZ2 LYS A  31      14.503  50.735  10.098  1.00  0.00           H  
ATOM    526  HZ3 LYS A  31      15.669  51.146   8.944  1.00  0.00           H  
ATOM    527  N   ASN A  32      12.993  46.759   4.637  1.00  0.00           N  
ATOM    528  CA  ASN A  32      13.158  45.885   3.481  1.00  0.00           C  
ATOM    529  C   ASN A  32      11.871  45.816   2.664  1.00  0.00           C  
ATOM    530  O   ASN A  32      11.386  44.732   2.342  1.00  0.00           O  
ATOM    531  CB  ASN A  32      13.566  44.481   3.932  1.00  0.00           C  
ATOM    532  CG  ASN A  32      13.980  43.599   2.771  1.00  0.00           C  
ATOM    533  OD1 ASN A  32      14.933  43.905   2.054  1.00  0.00           O  
ATOM    534  ND2 ASN A  32      13.264  42.497   2.579  1.00  0.00           N  
ATOM    535  H   ASN A  32      13.645  47.476   4.791  1.00  0.00           H  
ATOM    536  HA  ASN A  32      13.942  46.297   2.863  1.00  0.00           H  
ATOM    537  HB2 ASN A  32      14.397  44.556   4.617  1.00  0.00           H  
ATOM    538  HB3 ASN A  32      12.732  44.014   4.435  1.00  0.00           H  
ATOM    539 HD21 ASN A  32      12.518  42.316   3.190  1.00  0.00           H  
ATOM    540 HD22 ASN A  32      13.511  41.908   1.836  1.00  0.00           H  
ATOM    541  N   ASP A  33      11.325  46.980   2.331  1.00  0.00           N  
ATOM    542  CA  ASP A  33      10.096  47.052   1.549  1.00  0.00           C  
ATOM    543  C   ASP A  33       9.002  46.194   2.177  1.00  0.00           C  
ATOM    544  O   ASP A  33       8.128  45.682   1.480  1.00  0.00           O  
ATOM    545  CB  ASP A  33      10.354  46.602   0.111  1.00  0.00           C  
ATOM    546  CG  ASP A  33       9.432  47.280  -0.882  1.00  0.00           C  
ATOM    547  OD1 ASP A  33       9.410  48.529  -0.916  1.00  0.00           O  
ATOM    548  OD2 ASP A  33       8.732  46.563  -1.628  1.00  0.00           O  
ATOM    549  H   ASP A  33      11.760  47.811   2.617  1.00  0.00           H  
ATOM    550  HA  ASP A  33       9.769  48.081   1.542  1.00  0.00           H  
ATOM    551  HB2 ASP A  33      11.375  46.835  -0.156  1.00  0.00           H  
ATOM    552  HB3 ASP A  33      10.204  45.534   0.043  1.00  0.00           H  
ATOM    553  N   GLU A  34       9.060  46.042   3.496  1.00  0.00           N  
ATOM    554  CA  GLU A  34       8.074  45.245   4.217  1.00  0.00           C  
ATOM    555  C   GLU A  34       7.694  45.911   5.535  1.00  0.00           C  
ATOM    556  O   GLU A  34       8.259  46.938   5.909  1.00  0.00           O  
ATOM    557  CB  GLU A  34       8.618  43.839   4.480  1.00  0.00           C  
ATOM    558  CG  GLU A  34       8.481  42.901   3.292  1.00  0.00           C  
ATOM    559  CD  GLU A  34       8.668  41.445   3.675  1.00  0.00           C  
ATOM    560  OE1 GLU A  34       8.575  41.132   4.880  1.00  0.00           O  
ATOM    561  OE2 GLU A  34       8.909  40.620   2.769  1.00  0.00           O  
ATOM    562  H   GLU A  34       9.782  46.477   3.997  1.00  0.00           H  
ATOM    563  HA  GLU A  34       7.193  45.170   3.598  1.00  0.00           H  
ATOM    564  HB2 GLU A  34       9.664  43.913   4.736  1.00  0.00           H  
ATOM    565  HB3 GLU A  34       8.082  43.410   5.313  1.00  0.00           H  
ATOM    566  HG2 GLU A  34       7.497  43.021   2.866  1.00  0.00           H  
ATOM    567  HG3 GLU A  34       9.226  43.163   2.556  1.00  0.00           H  
ATOM    568  N   GLU A  35       6.732  45.317   6.237  1.00  0.00           N  
ATOM    569  CA  GLU A  35       6.276  45.854   7.513  1.00  0.00           C  
ATOM    570  C   GLU A  35       6.481  44.839   8.634  1.00  0.00           C  
ATOM    571  O   GLU A  35       6.036  43.695   8.540  1.00  0.00           O  
ATOM    572  CB  GLU A  35       4.799  46.243   7.428  1.00  0.00           C  
ATOM    573  CG  GLU A  35       4.573  47.736   7.252  1.00  0.00           C  
ATOM    574  CD  GLU A  35       3.260  48.050   6.563  1.00  0.00           C  
ATOM    575  OE1 GLU A  35       2.574  47.101   6.129  1.00  0.00           O  
ATOM    576  OE2 GLU A  35       2.917  49.247   6.456  1.00  0.00           O  
ATOM    577  H   GLU A  35       6.320  44.500   5.886  1.00  0.00           H  
ATOM    578  HA  GLU A  35       6.859  46.735   7.729  1.00  0.00           H  
ATOM    579  HB2 GLU A  35       4.351  45.732   6.589  1.00  0.00           H  
ATOM    580  HB3 GLU A  35       4.304  45.930   8.335  1.00  0.00           H  
ATOM    581  HG2 GLU A  35       4.571  48.204   8.225  1.00  0.00           H  
ATOM    582  HG3 GLU A  35       5.380  48.142   6.660  1.00  0.00           H  
ATOM    583  N   ARG A  36       7.160  45.267   9.693  1.00  0.00           N  
ATOM    584  CA  ARG A  36       7.426  44.397  10.833  1.00  0.00           C  
ATOM    585  C   ARG A  36       7.017  45.070  12.139  1.00  0.00           C  
ATOM    586  O   ARG A  36       7.266  46.259  12.342  1.00  0.00           O  
ATOM    587  CB  ARG A  36       8.909  44.025  10.881  1.00  0.00           C  
ATOM    588  CG  ARG A  36       9.405  43.330   9.623  1.00  0.00           C  
ATOM    589  CD  ARG A  36      10.665  42.523   9.891  1.00  0.00           C  
ATOM    590  NE  ARG A  36      10.363  41.177  10.370  1.00  0.00           N  
ATOM    591  CZ  ARG A  36       9.830  40.229   9.608  1.00  0.00           C  
ATOM    592  NH1 ARG A  36       9.541  40.478   8.338  1.00  0.00           N  
ATOM    593  NH2 ARG A  36       9.583  39.028  10.116  1.00  0.00           N  
ATOM    594  H   ARG A  36       7.489  46.189   9.710  1.00  0.00           H  
ATOM    595  HA  ARG A  36       6.842  43.497  10.707  1.00  0.00           H  
ATOM    596  HB2 ARG A  36       9.490  44.924  11.021  1.00  0.00           H  
ATOM    597  HB3 ARG A  36       9.075  43.364  11.719  1.00  0.00           H  
ATOM    598  HG2 ARG A  36       8.633  42.663   9.264  1.00  0.00           H  
ATOM    599  HG3 ARG A  36       9.617  44.075   8.871  1.00  0.00           H  
ATOM    600  HD2 ARG A  36      11.231  42.451   8.974  1.00  0.00           H  
ATOM    601  HD3 ARG A  36      11.253  43.037  10.636  1.00  0.00           H  
ATOM    602  HE  ARG A  36      10.568  40.971  11.305  1.00  0.00           H  
ATOM    603 HH11 ARG A  36       9.726  41.382   7.952  1.00  0.00           H  
ATOM    604 HH12 ARG A  36       9.140  39.761   7.766  1.00  0.00           H  
ATOM    605 HH21 ARG A  36       9.800  38.836  11.072  1.00  0.00           H  
ATOM    606 HH22 ARG A  36       9.182  38.315   9.542  1.00  0.00           H  
ATOM    607  N   LEU A  37       6.388  44.303  13.022  1.00  0.00           N  
ATOM    608  CA  LEU A  37       5.943  44.824  14.310  1.00  0.00           C  
ATOM    609  C   LEU A  37       7.131  45.081  15.233  1.00  0.00           C  
ATOM    610  O   LEU A  37       7.758  44.145  15.728  1.00  0.00           O  
ATOM    611  CB  LEU A  37       4.971  43.845  14.971  1.00  0.00           C  
ATOM    612  CG  LEU A  37       4.185  44.385  16.166  1.00  0.00           C  
ATOM    613  CD1 LEU A  37       2.906  45.063  15.702  1.00  0.00           C  
ATOM    614  CD2 LEU A  37       3.870  43.264  17.147  1.00  0.00           C  
ATOM    615  H   LEU A  37       6.218  43.362  12.805  1.00  0.00           H  
ATOM    616  HA  LEU A  37       5.433  45.759  14.130  1.00  0.00           H  
ATOM    617  HB2 LEU A  37       4.260  43.530  14.223  1.00  0.00           H  
ATOM    618  HB3 LEU A  37       5.541  42.990  15.307  1.00  0.00           H  
ATOM    619  HG  LEU A  37       4.785  45.123  16.681  1.00  0.00           H  
ATOM    620 HD11 LEU A  37       3.149  45.993  15.210  1.00  0.00           H  
ATOM    621 HD12 LEU A  37       2.274  45.262  16.554  1.00  0.00           H  
ATOM    622 HD13 LEU A  37       2.385  44.415  15.011  1.00  0.00           H  
ATOM    623 HD21 LEU A  37       3.988  43.628  18.157  1.00  0.00           H  
ATOM    624 HD22 LEU A  37       4.547  42.440  16.979  1.00  0.00           H  
ATOM    625 HD23 LEU A  37       2.854  42.931  17.000  1.00  0.00           H  
ATOM    626  N   ALA A  38       7.431  46.355  15.460  1.00  0.00           N  
ATOM    627  CA  ALA A  38       8.540  46.735  16.328  1.00  0.00           C  
ATOM    628  C   ALA A  38       8.034  47.331  17.637  1.00  0.00           C  
ATOM    629  O   ALA A  38       7.087  48.117  17.646  1.00  0.00           O  
ATOM    630  CB  ALA A  38       9.452  47.721  15.615  1.00  0.00           C  
ATOM    631  H   ALA A  38       6.893  47.057  15.038  1.00  0.00           H  
ATOM    632  HA  ALA A  38       9.112  45.845  16.546  1.00  0.00           H  
ATOM    633  HB1 ALA A  38      10.431  47.701  16.073  1.00  0.00           H  
ATOM    634  HB2 ALA A  38       9.535  47.447  14.574  1.00  0.00           H  
ATOM    635  HB3 ALA A  38       9.039  48.716  15.693  1.00  0.00           H  
ATOM    636  N   GLU A  39       8.670  46.950  18.740  1.00  0.00           N  
ATOM    637  CA  GLU A  39       8.282  47.447  20.055  1.00  0.00           C  
ATOM    638  C   GLU A  39       9.211  48.568  20.510  1.00  0.00           C  
ATOM    639  O   GLU A  39      10.435  48.431  20.466  1.00  0.00           O  
ATOM    640  CB  GLU A  39       8.298  46.310  21.079  1.00  0.00           C  
ATOM    641  CG  GLU A  39       8.123  46.780  22.514  1.00  0.00           C  
ATOM    642  CD  GLU A  39       7.921  45.632  23.483  1.00  0.00           C  
ATOM    643  OE1 GLU A  39       8.411  44.520  23.195  1.00  0.00           O  
ATOM    644  OE2 GLU A  39       7.274  45.845  24.529  1.00  0.00           O  
ATOM    645  H   GLU A  39       9.417  46.320  18.668  1.00  0.00           H  
ATOM    646  HA  GLU A  39       7.278  47.836  19.980  1.00  0.00           H  
ATOM    647  HB2 GLU A  39       7.499  45.620  20.847  1.00  0.00           H  
ATOM    648  HB3 GLU A  39       9.242  45.790  21.006  1.00  0.00           H  
ATOM    649  HG2 GLU A  39       9.003  47.330  22.809  1.00  0.00           H  
ATOM    650  HG3 GLU A  39       7.261  47.430  22.563  1.00  0.00           H  
ATOM    651  N   ILE A  40       8.623  49.678  20.944  1.00  0.00           N  
ATOM    652  CA  ILE A  40       9.397  50.822  21.406  1.00  0.00           C  
ATOM    653  C   ILE A  40      10.215  50.470  22.644  1.00  0.00           C  
ATOM    654  O   ILE A  40       9.754  49.731  23.515  1.00  0.00           O  
ATOM    655  CB  ILE A  40       8.489  52.024  21.729  1.00  0.00           C  
ATOM    656  CG1 ILE A  40       7.641  52.392  20.510  1.00  0.00           C  
ATOM    657  CG2 ILE A  40       9.323  53.212  22.181  1.00  0.00           C  
ATOM    658  CD1 ILE A  40       8.452  52.927  19.351  1.00  0.00           C  
ATOM    659  H   ILE A  40       7.645  49.727  20.953  1.00  0.00           H  
ATOM    660  HA  ILE A  40      10.071  51.110  20.612  1.00  0.00           H  
ATOM    661  HB  ILE A  40       7.836  51.743  22.542  1.00  0.00           H  
ATOM    662 HG12 ILE A  40       7.112  51.517  20.168  1.00  0.00           H  
ATOM    663 HG13 ILE A  40       6.927  53.152  20.794  1.00  0.00           H  
ATOM    664 HG21 ILE A  40       9.542  53.118  23.235  1.00  0.00           H  
ATOM    665 HG22 ILE A  40      10.247  53.236  21.623  1.00  0.00           H  
ATOM    666 HG23 ILE A  40       8.774  54.125  22.007  1.00  0.00           H  
ATOM    667 HD11 ILE A  40       9.505  52.784  19.551  1.00  0.00           H  
ATOM    668 HD12 ILE A  40       8.184  52.397  18.449  1.00  0.00           H  
ATOM    669 HD13 ILE A  40       8.249  53.980  19.224  1.00  0.00           H  
ATOM    670  N   LEU A  41      11.429  51.003  22.716  1.00  0.00           N  
ATOM    671  CA  LEU A  41      12.311  50.746  23.849  1.00  0.00           C  
ATOM    672  C   LEU A  41      12.641  52.040  24.586  1.00  0.00           C  
ATOM    673  O   LEU A  41      12.756  52.056  25.811  1.00  0.00           O  
ATOM    674  CB  LEU A  41      13.600  50.074  23.374  1.00  0.00           C  
ATOM    675  CG  LEU A  41      13.497  48.585  23.039  1.00  0.00           C  
ATOM    676  CD1 LEU A  41      14.844  48.047  22.582  1.00  0.00           C  
ATOM    677  CD2 LEU A  41      12.987  47.803  24.240  1.00  0.00           C  
ATOM    678  H   LEU A  41      11.741  51.584  21.991  1.00  0.00           H  
ATOM    679  HA  LEU A  41      11.796  50.082  24.526  1.00  0.00           H  
ATOM    680  HB2 LEU A  41      13.936  50.590  22.487  1.00  0.00           H  
ATOM    681  HB3 LEU A  41      14.339  50.187  24.155  1.00  0.00           H  
ATOM    682  HG  LEU A  41      12.794  48.454  22.229  1.00  0.00           H  
ATOM    683 HD11 LEU A  41      15.129  48.525  21.658  1.00  0.00           H  
ATOM    684 HD12 LEU A  41      14.772  46.980  22.429  1.00  0.00           H  
ATOM    685 HD13 LEU A  41      15.589  48.251  23.338  1.00  0.00           H  
ATOM    686 HD21 LEU A  41      13.420  48.206  25.143  1.00  0.00           H  
ATOM    687 HD22 LEU A  41      13.268  46.765  24.138  1.00  0.00           H  
ATOM    688 HD23 LEU A  41      11.911  47.881  24.289  1.00  0.00           H  
ATOM    689  N   SER A  42      12.790  53.124  23.831  1.00  0.00           N  
ATOM    690  CA  SER A  42      13.107  54.423  24.413  1.00  0.00           C  
ATOM    691  C   SER A  42      12.798  55.549  23.431  1.00  0.00           C  
ATOM    692  O   SER A  42      12.476  55.302  22.268  1.00  0.00           O  
ATOM    693  CB  SER A  42      14.582  54.477  24.820  1.00  0.00           C  
ATOM    694  OG  SER A  42      14.726  54.930  26.155  1.00  0.00           O  
ATOM    695  H   SER A  42      12.686  53.048  22.860  1.00  0.00           H  
ATOM    696  HA  SER A  42      12.495  54.551  25.294  1.00  0.00           H  
ATOM    697  HB2 SER A  42      15.011  53.490  24.739  1.00  0.00           H  
ATOM    698  HB3 SER A  42      15.109  55.154  24.162  1.00  0.00           H  
ATOM    699  HG  SER A  42      14.532  55.870  26.197  1.00  0.00           H  
ATOM    700  N   ILE A  43      12.897  56.785  23.907  1.00  0.00           N  
ATOM    701  CA  ILE A  43      12.629  57.949  23.072  1.00  0.00           C  
ATOM    702  C   ILE A  43      13.777  58.950  23.139  1.00  0.00           C  
ATOM    703  O   ILE A  43      14.372  59.157  24.195  1.00  0.00           O  
ATOM    704  CB  ILE A  43      11.324  58.653  23.490  1.00  0.00           C  
ATOM    705  CG1 ILE A  43      10.159  57.662  23.476  1.00  0.00           C  
ATOM    706  CG2 ILE A  43      11.038  59.828  22.566  1.00  0.00           C  
ATOM    707  CD1 ILE A  43       8.902  58.199  24.125  1.00  0.00           C  
ATOM    708  H   ILE A  43      13.158  56.917  24.842  1.00  0.00           H  
ATOM    709  HA  ILE A  43      12.521  57.608  22.052  1.00  0.00           H  
ATOM    710  HB  ILE A  43      11.452  59.035  24.490  1.00  0.00           H  
ATOM    711 HG12 ILE A  43       9.922  57.407  22.456  1.00  0.00           H  
ATOM    712 HG13 ILE A  43      10.450  56.768  24.008  1.00  0.00           H  
ATOM    713 HG21 ILE A  43      11.188  59.524  21.540  1.00  0.00           H  
ATOM    714 HG22 ILE A  43      10.015  60.149  22.699  1.00  0.00           H  
ATOM    715 HG23 ILE A  43      11.705  60.643  22.803  1.00  0.00           H  
ATOM    716 HD11 ILE A  43       9.157  59.017  24.783  1.00  0.00           H  
ATOM    717 HD12 ILE A  43       8.224  58.551  23.360  1.00  0.00           H  
ATOM    718 HD13 ILE A  43       8.426  57.415  24.694  1.00  0.00           H  
ATOM    719  N   ASN A  44      14.082  59.570  22.004  1.00  0.00           N  
ATOM    720  CA  ASN A  44      15.158  60.551  21.933  1.00  0.00           C  
ATOM    721  C   ASN A  44      14.709  61.799  21.179  1.00  0.00           C  
ATOM    722  O   ASN A  44      14.687  61.822  19.948  1.00  0.00           O  
ATOM    723  CB  ASN A  44      16.386  59.945  21.251  1.00  0.00           C  
ATOM    724  CG  ASN A  44      17.461  60.976  20.972  1.00  0.00           C  
ATOM    725  OD1 ASN A  44      17.641  61.925  21.736  1.00  0.00           O  
ATOM    726  ND2 ASN A  44      18.182  60.797  19.872  1.00  0.00           N  
ATOM    727  H   ASN A  44      13.571  59.363  21.193  1.00  0.00           H  
ATOM    728  HA  ASN A  44      15.420  60.830  22.943  1.00  0.00           H  
ATOM    729  HB2 ASN A  44      16.804  59.181  21.890  1.00  0.00           H  
ATOM    730  HB3 ASN A  44      16.087  59.501  20.314  1.00  0.00           H  
ATOM    731 HD21 ASN A  44      17.984  60.018  19.310  1.00  0.00           H  
ATOM    732 HD22 ASN A  44      18.885  61.448  19.668  1.00  0.00           H  
ATOM    733  N   THR A  45      14.349  62.839  21.927  1.00  0.00           N  
ATOM    734  CA  THR A  45      13.899  64.090  21.331  1.00  0.00           C  
ATOM    735  C   THR A  45      15.019  65.124  21.313  1.00  0.00           C  
ATOM    736  O   THR A  45      14.930  66.160  21.973  1.00  0.00           O  
ATOM    737  CB  THR A  45      12.691  64.670  22.089  1.00  0.00           C  
ATOM    738  OG1 THR A  45      13.028  64.876  23.465  1.00  0.00           O  
ATOM    739  CG2 THR A  45      11.491  63.739  21.989  1.00  0.00           C  
ATOM    740  H   THR A  45      14.387  62.759  22.903  1.00  0.00           H  
ATOM    741  HA  THR A  45      13.596  63.884  20.314  1.00  0.00           H  
ATOM    742  HB  THR A  45      12.429  65.620  21.644  1.00  0.00           H  
ATOM    743  HG1 THR A  45      12.560  65.646  23.798  1.00  0.00           H  
ATOM    744 HG21 THR A  45      11.367  63.213  22.923  1.00  0.00           H  
ATOM    745 HG22 THR A  45      11.653  63.027  21.193  1.00  0.00           H  
ATOM    746 HG23 THR A  45      10.604  64.318  21.781  1.00  0.00           H  
ATOM    747  N   ARG A  46      16.071  64.837  20.554  1.00  0.00           N  
ATOM    748  CA  ARG A  46      17.209  65.744  20.451  1.00  0.00           C  
ATOM    749  C   ARG A  46      17.401  66.215  19.013  1.00  0.00           C  
ATOM    750  O   ARG A  46      18.401  66.854  18.685  1.00  0.00           O  
ATOM    751  CB  ARG A  46      18.482  65.057  20.949  1.00  0.00           C  
ATOM    752  CG  ARG A  46      18.644  65.095  22.460  1.00  0.00           C  
ATOM    753  CD  ARG A  46      19.110  66.462  22.936  1.00  0.00           C  
ATOM    754  NE  ARG A  46      19.863  66.380  24.185  1.00  0.00           N  
ATOM    755  CZ  ARG A  46      20.637  67.358  24.642  1.00  0.00           C  
ATOM    756  NH1 ARG A  46      20.758  68.487  23.956  1.00  0.00           N  
ATOM    757  NH2 ARG A  46      21.291  67.208  25.786  1.00  0.00           N  
ATOM    758  H   ARG A  46      16.084  63.996  20.052  1.00  0.00           H  
ATOM    759  HA  ARG A  46      17.006  66.603  21.075  1.00  0.00           H  
ATOM    760  HB2 ARG A  46      18.464  64.023  20.637  1.00  0.00           H  
ATOM    761  HB3 ARG A  46      19.336  65.545  20.505  1.00  0.00           H  
ATOM    762  HG2 ARG A  46      17.693  64.871  22.921  1.00  0.00           H  
ATOM    763  HG3 ARG A  46      19.372  64.354  22.754  1.00  0.00           H  
ATOM    764  HD2 ARG A  46      19.739  66.899  22.176  1.00  0.00           H  
ATOM    765  HD3 ARG A  46      18.244  67.090  23.089  1.00  0.00           H  
ATOM    766  HE  ARG A  46      19.787  65.555  24.706  1.00  0.00           H  
ATOM    767 HH11 ARG A  46      20.267  68.603  23.094  1.00  0.00           H  
ATOM    768 HH12 ARG A  46      21.342  69.222  24.303  1.00  0.00           H  
ATOM    769 HH21 ARG A  46      21.202  66.359  26.306  1.00  0.00           H  
ATOM    770 HH22 ARG A  46      21.874  67.945  26.129  1.00  0.00           H  
ATOM    771  N   LYS A  47      16.435  65.895  18.158  1.00  0.00           N  
ATOM    772  CA  LYS A  47      16.496  66.284  16.754  1.00  0.00           C  
ATOM    773  C   LYS A  47      15.124  66.719  16.250  1.00  0.00           C  
ATOM    774  O   LYS A  47      14.137  66.665  16.983  1.00  0.00           O  
ATOM    775  CB  LYS A  47      17.019  65.125  15.903  1.00  0.00           C  
ATOM    776  CG  LYS A  47      18.046  65.546  14.867  1.00  0.00           C  
ATOM    777  CD  LYS A  47      19.400  65.819  15.500  1.00  0.00           C  
ATOM    778  CE  LYS A  47      20.315  64.608  15.401  1.00  0.00           C  
ATOM    779  NZ  LYS A  47      20.385  63.860  16.687  1.00  0.00           N  
ATOM    780  H   LYS A  47      15.663  65.384  18.479  1.00  0.00           H  
ATOM    781  HA  LYS A  47      17.178  67.117  16.670  1.00  0.00           H  
ATOM    782  HB2 LYS A  47      17.476  64.394  16.555  1.00  0.00           H  
ATOM    783  HB3 LYS A  47      16.186  64.666  15.390  1.00  0.00           H  
ATOM    784  HG2 LYS A  47      18.154  64.756  14.138  1.00  0.00           H  
ATOM    785  HG3 LYS A  47      17.701  66.445  14.375  1.00  0.00           H  
ATOM    786  HD2 LYS A  47      19.865  66.650  14.990  1.00  0.00           H  
ATOM    787  HD3 LYS A  47      19.256  66.067  16.541  1.00  0.00           H  
ATOM    788  HE2 LYS A  47      19.940  63.951  14.632  1.00  0.00           H  
ATOM    789  HE3 LYS A  47      21.307  64.944  15.136  1.00  0.00           H  
ATOM    790  HZ1 LYS A  47      19.665  63.110  16.704  1.00  0.00           H  
ATOM    791  HZ2 LYS A  47      20.218  64.505  17.485  1.00  0.00           H  
ATOM    792  HZ3 LYS A  47      21.323  63.426  16.797  1.00  0.00           H  
ATOM    793  N   ALA A  48      15.069  67.151  14.995  1.00  0.00           N  
ATOM    794  CA  ALA A  48      13.817  67.592  14.392  1.00  0.00           C  
ATOM    795  C   ALA A  48      13.709  67.124  12.945  1.00  0.00           C  
ATOM    796  O   ALA A  48      14.360  67.656  12.045  1.00  0.00           O  
ATOM    797  CB  ALA A  48      13.699  69.108  14.469  1.00  0.00           C  
ATOM    798  H   ALA A  48      15.890  67.173  14.460  1.00  0.00           H  
ATOM    799  HA  ALA A  48      13.004  67.163  14.960  1.00  0.00           H  
ATOM    800  HB1 ALA A  48      14.672  69.551  14.312  1.00  0.00           H  
ATOM    801  HB2 ALA A  48      13.017  69.454  13.707  1.00  0.00           H  
ATOM    802  HB3 ALA A  48      13.328  69.390  15.442  1.00  0.00           H  
ATOM    803  N   PRO A  49      12.869  66.105  12.713  1.00  0.00           N  
ATOM    804  CA  PRO A  49      12.090  65.463  13.776  1.00  0.00           C  
ATOM    805  C   PRO A  49      12.965  64.655  14.729  1.00  0.00           C  
ATOM    806  O   PRO A  49      14.124  64.356  14.443  1.00  0.00           O  
ATOM    807  CB  PRO A  49      11.137  64.541  13.012  1.00  0.00           C  
ATOM    808  CG  PRO A  49      11.837  64.256  11.727  1.00  0.00           C  
ATOM    809  CD  PRO A  49      12.616  65.498  11.395  1.00  0.00           C  
ATOM    810  HA  PRO A  49      11.518  66.186  14.341  1.00  0.00           H  
ATOM    811  HB2 PRO A  49      10.973  63.637  13.581  1.00  0.00           H  
ATOM    812  HB3 PRO A  49      10.197  65.045  12.846  1.00  0.00           H  
ATOM    813  HG2 PRO A  49      12.503  63.417  11.851  1.00  0.00           H  
ATOM    814  HG3 PRO A  49      11.112  64.050  10.953  1.00  0.00           H  
ATOM    815  HD2 PRO A  49      13.543  65.242  10.904  1.00  0.00           H  
ATOM    816  HD3 PRO A  49      12.027  66.158  10.775  1.00  0.00           H  
ATOM    817  N   PRO A  50      12.398  64.292  15.889  1.00  0.00           N  
ATOM    818  CA  PRO A  50      13.109  63.512  16.907  1.00  0.00           C  
ATOM    819  C   PRO A  50      13.358  62.074  16.466  1.00  0.00           C  
ATOM    820  O   PRO A  50      12.993  61.681  15.358  1.00  0.00           O  
ATOM    821  CB  PRO A  50      12.159  63.545  18.107  1.00  0.00           C  
ATOM    822  CG  PRO A  50      10.809  63.759  17.515  1.00  0.00           C  
ATOM    823  CD  PRO A  50      11.020  64.614  16.296  1.00  0.00           C  
ATOM    824  HA  PRO A  50      14.048  63.972  17.176  1.00  0.00           H  
ATOM    825  HB2 PRO A  50      12.214  62.607  18.640  1.00  0.00           H  
ATOM    826  HB3 PRO A  50      12.434  64.356  18.765  1.00  0.00           H  
ATOM    827  HG2 PRO A  50      10.375  62.810  17.237  1.00  0.00           H  
ATOM    828  HG3 PRO A  50      10.173  64.268  18.225  1.00  0.00           H  
ATOM    829  HD2 PRO A  50      10.317  64.348  15.522  1.00  0.00           H  
ATOM    830  HD3 PRO A  50      10.929  65.660  16.549  1.00  0.00           H  
ATOM    831  N   LYS A  51      13.982  61.292  17.340  1.00  0.00           N  
ATOM    832  CA  LYS A  51      14.279  59.895  17.043  1.00  0.00           C  
ATOM    833  C   LYS A  51      13.681  58.975  18.101  1.00  0.00           C  
ATOM    834  O   LYS A  51      13.403  59.399  19.222  1.00  0.00           O  
ATOM    835  CB  LYS A  51      15.792  59.681  16.960  1.00  0.00           C  
ATOM    836  CG  LYS A  51      16.393  60.091  15.626  1.00  0.00           C  
ATOM    837  CD  LYS A  51      17.897  59.878  15.603  1.00  0.00           C  
ATOM    838  CE  LYS A  51      18.428  59.803  14.179  1.00  0.00           C  
ATOM    839  NZ  LYS A  51      19.911  59.679  14.147  1.00  0.00           N  
ATOM    840  H   LYS A  51      14.248  61.662  18.208  1.00  0.00           H  
ATOM    841  HA  LYS A  51      13.838  59.659  16.086  1.00  0.00           H  
ATOM    842  HB2 LYS A  51      16.268  60.258  17.738  1.00  0.00           H  
ATOM    843  HB3 LYS A  51      16.004  58.633  17.120  1.00  0.00           H  
ATOM    844  HG2 LYS A  51      15.944  59.499  14.843  1.00  0.00           H  
ATOM    845  HG3 LYS A  51      16.184  61.137  15.454  1.00  0.00           H  
ATOM    846  HD2 LYS A  51      18.376  60.702  16.111  1.00  0.00           H  
ATOM    847  HD3 LYS A  51      18.129  58.955  16.114  1.00  0.00           H  
ATOM    848  HE2 LYS A  51      17.992  58.944  13.692  1.00  0.00           H  
ATOM    849  HE3 LYS A  51      18.138  60.700  13.654  1.00  0.00           H  
ATOM    850  HZ1 LYS A  51      20.286  60.104  13.275  1.00  0.00           H  
ATOM    851  HZ2 LYS A  51      20.187  58.676  14.177  1.00  0.00           H  
ATOM    852  HZ3 LYS A  51      20.329  60.166  14.964  1.00  0.00           H  
ATOM    853  N   PHE A  52      13.490  57.710  17.738  1.00  0.00           N  
ATOM    854  CA  PHE A  52      12.925  56.729  18.658  1.00  0.00           C  
ATOM    855  C   PHE A  52      13.649  55.391  18.536  1.00  0.00           C  
ATOM    856  O   PHE A  52      14.148  55.037  17.467  1.00  0.00           O  
ATOM    857  CB  PHE A  52      11.431  56.540  18.382  1.00  0.00           C  
ATOM    858  CG  PHE A  52      10.633  57.804  18.521  1.00  0.00           C  
ATOM    859  CD1 PHE A  52      10.645  58.761  17.518  1.00  0.00           C  
ATOM    860  CD2 PHE A  52       9.870  58.037  19.654  1.00  0.00           C  
ATOM    861  CE1 PHE A  52       9.910  59.925  17.642  1.00  0.00           C  
ATOM    862  CE2 PHE A  52       9.133  59.200  19.784  1.00  0.00           C  
ATOM    863  CZ  PHE A  52       9.155  60.144  18.777  1.00  0.00           C  
ATOM    864  H   PHE A  52      13.732  57.431  16.831  1.00  0.00           H  
ATOM    865  HA  PHE A  52      13.053  57.103  19.660  1.00  0.00           H  
ATOM    866  HB2 PHE A  52      11.301  56.175  17.375  1.00  0.00           H  
ATOM    867  HB3 PHE A  52      11.033  55.817  19.078  1.00  0.00           H  
ATOM    868  HD1 PHE A  52      11.236  58.588  16.629  1.00  0.00           H  
ATOM    869  HD2 PHE A  52       9.854  57.299  20.443  1.00  0.00           H  
ATOM    870  HE1 PHE A  52       9.929  60.661  16.853  1.00  0.00           H  
ATOM    871  HE2 PHE A  52       8.544  59.370  20.672  1.00  0.00           H  
ATOM    872  HZ  PHE A  52       8.580  61.054  18.875  1.00  0.00           H  
ATOM    873  N   TYR A  53      13.701  54.651  19.637  1.00  0.00           N  
ATOM    874  CA  TYR A  53      14.365  53.353  19.656  1.00  0.00           C  
ATOM    875  C   TYR A  53      13.352  52.220  19.537  1.00  0.00           C  
ATOM    876  O   TYR A  53      12.500  52.038  20.408  1.00  0.00           O  
ATOM    877  CB  TYR A  53      15.180  53.192  20.941  1.00  0.00           C  
ATOM    878  CG  TYR A  53      16.313  52.199  20.819  1.00  0.00           C  
ATOM    879  CD1 TYR A  53      17.189  52.244  19.740  1.00  0.00           C  
ATOM    880  CD2 TYR A  53      16.510  51.217  21.783  1.00  0.00           C  
ATOM    881  CE1 TYR A  53      18.226  51.338  19.625  1.00  0.00           C  
ATOM    882  CE2 TYR A  53      17.545  50.309  21.676  1.00  0.00           C  
ATOM    883  CZ  TYR A  53      18.401  50.373  20.595  1.00  0.00           C  
ATOM    884  OH  TYR A  53      19.433  49.471  20.484  1.00  0.00           O  
ATOM    885  H   TYR A  53      13.284  54.986  20.458  1.00  0.00           H  
ATOM    886  HA  TYR A  53      15.036  53.312  18.809  1.00  0.00           H  
ATOM    887  HB2 TYR A  53      15.603  54.146  21.214  1.00  0.00           H  
ATOM    888  HB3 TYR A  53      14.526  52.854  21.733  1.00  0.00           H  
ATOM    889  HD1 TYR A  53      17.050  53.002  18.984  1.00  0.00           H  
ATOM    890  HD2 TYR A  53      15.838  51.169  22.627  1.00  0.00           H  
ATOM    891  HE1 TYR A  53      18.896  51.389  18.779  1.00  0.00           H  
ATOM    892  HE2 TYR A  53      17.682  49.552  22.434  1.00  0.00           H  
ATOM    893  HH  TYR A  53      20.095  49.658  21.153  1.00  0.00           H  
ATOM    894  N   VAL A  54      13.448  51.458  18.452  1.00  0.00           N  
ATOM    895  CA  VAL A  54      12.542  50.341  18.218  1.00  0.00           C  
ATOM    896  C   VAL A  54      13.283  49.009  18.278  1.00  0.00           C  
ATOM    897  O   VAL A  54      14.497  48.954  18.080  1.00  0.00           O  
ATOM    898  CB  VAL A  54      11.839  50.464  16.853  1.00  0.00           C  
ATOM    899  CG1 VAL A  54      10.810  51.583  16.881  1.00  0.00           C  
ATOM    900  CG2 VAL A  54      12.860  50.695  15.749  1.00  0.00           C  
ATOM    901  H   VAL A  54      14.148  51.652  17.793  1.00  0.00           H  
ATOM    902  HA  VAL A  54      11.787  50.356  18.990  1.00  0.00           H  
ATOM    903  HB  VAL A  54      11.326  49.535  16.650  1.00  0.00           H  
ATOM    904 HG11 VAL A  54      11.297  52.525  16.681  1.00  0.00           H  
ATOM    905 HG12 VAL A  54      10.056  51.397  16.130  1.00  0.00           H  
ATOM    906 HG13 VAL A  54      10.345  51.619  17.856  1.00  0.00           H  
ATOM    907 HG21 VAL A  54      13.511  49.837  15.674  1.00  0.00           H  
ATOM    908 HG22 VAL A  54      12.347  50.842  14.810  1.00  0.00           H  
ATOM    909 HG23 VAL A  54      13.447  51.573  15.978  1.00  0.00           H  
ATOM    910  N   HIS A  55      12.545  47.939  18.551  1.00  0.00           N  
ATOM    911  CA  HIS A  55      13.132  46.606  18.637  1.00  0.00           C  
ATOM    912  C   HIS A  55      12.223  45.570  17.983  1.00  0.00           C  
ATOM    913  O   HIS A  55      11.099  45.346  18.431  1.00  0.00           O  
ATOM    914  CB  HIS A  55      13.387  46.230  20.096  1.00  0.00           C  
ATOM    915  CG  HIS A  55      13.529  44.756  20.319  1.00  0.00           C  
ATOM    916  ND1 HIS A  55      14.271  43.938  19.494  1.00  0.00           N  
ATOM    917  CD2 HIS A  55      13.019  43.953  21.283  1.00  0.00           C  
ATOM    918  CE1 HIS A  55      14.211  42.696  19.939  1.00  0.00           C  
ATOM    919  NE2 HIS A  55      13.457  42.678  21.023  1.00  0.00           N  
ATOM    920  H   HIS A  55      11.582  48.047  18.700  1.00  0.00           H  
ATOM    921  HA  HIS A  55      14.074  46.625  18.109  1.00  0.00           H  
ATOM    922  HB2 HIS A  55      14.298  46.705  20.429  1.00  0.00           H  
ATOM    923  HB3 HIS A  55      12.562  46.580  20.701  1.00  0.00           H  
ATOM    924  HD1 HIS A  55      14.767  44.225  18.700  1.00  0.00           H  
ATOM    925  HD2 HIS A  55      12.385  44.257  22.103  1.00  0.00           H  
ATOM    926  HE1 HIS A  55      14.696  41.840  19.493  1.00  0.00           H  
ATOM    927  N   TYR A  56      12.718  44.941  16.922  1.00  0.00           N  
ATOM    928  CA  TYR A  56      11.949  43.932  16.205  1.00  0.00           C  
ATOM    929  C   TYR A  56      11.652  42.734  17.103  1.00  0.00           C  
ATOM    930  O   TYR A  56      12.537  41.932  17.402  1.00  0.00           O  
ATOM    931  CB  TYR A  56      12.708  43.472  14.959  1.00  0.00           C  
ATOM    932  CG  TYR A  56      12.924  44.570  13.942  1.00  0.00           C  
ATOM    933  CD1 TYR A  56      11.964  44.848  12.977  1.00  0.00           C  
ATOM    934  CD2 TYR A  56      14.087  45.331  13.948  1.00  0.00           C  
ATOM    935  CE1 TYR A  56      12.157  45.850  12.045  1.00  0.00           C  
ATOM    936  CE2 TYR A  56      14.287  46.336  13.021  1.00  0.00           C  
ATOM    937  CZ  TYR A  56      13.319  46.591  12.071  1.00  0.00           C  
ATOM    938  OH  TYR A  56      13.514  47.591  11.147  1.00  0.00           O  
ATOM    939  H   TYR A  56      13.621  45.164  16.612  1.00  0.00           H  
ATOM    940  HA  TYR A  56      11.015  44.380  15.901  1.00  0.00           H  
ATOM    941  HB2 TYR A  56      13.678  43.100  15.253  1.00  0.00           H  
ATOM    942  HB3 TYR A  56      12.154  42.679  14.479  1.00  0.00           H  
ATOM    943  HD1 TYR A  56      11.054  44.265  12.960  1.00  0.00           H  
ATOM    944  HD2 TYR A  56      14.842  45.129  14.692  1.00  0.00           H  
ATOM    945  HE1 TYR A  56      11.399  46.050  11.302  1.00  0.00           H  
ATOM    946  HE2 TYR A  56      15.197  46.916  13.041  1.00  0.00           H  
ATOM    947  HH  TYR A  56      13.335  48.441  11.553  1.00  0.00           H  
ATOM    948  N   VAL A  57      10.398  42.620  17.530  1.00  0.00           N  
ATOM    949  CA  VAL A  57       9.982  41.520  18.392  1.00  0.00           C  
ATOM    950  C   VAL A  57      10.187  40.175  17.706  1.00  0.00           C  
ATOM    951  O   VAL A  57      10.394  39.157  18.363  1.00  0.00           O  
ATOM    952  CB  VAL A  57       8.502  41.656  18.798  1.00  0.00           C  
ATOM    953  CG1 VAL A  57       8.076  40.480  19.664  1.00  0.00           C  
ATOM    954  CG2 VAL A  57       8.267  42.974  19.521  1.00  0.00           C  
ATOM    955  H   VAL A  57       9.738  43.290  17.257  1.00  0.00           H  
ATOM    956  HA  VAL A  57      10.584  41.552  19.289  1.00  0.00           H  
ATOM    957  HB  VAL A  57       7.901  41.650  17.901  1.00  0.00           H  
ATOM    958 HG11 VAL A  57       8.142  39.567  19.089  1.00  0.00           H  
ATOM    959 HG12 VAL A  57       8.726  40.412  20.525  1.00  0.00           H  
ATOM    960 HG13 VAL A  57       7.057  40.625  19.992  1.00  0.00           H  
ATOM    961 HG21 VAL A  57       7.526  42.834  20.293  1.00  0.00           H  
ATOM    962 HG22 VAL A  57       9.192  43.309  19.966  1.00  0.00           H  
ATOM    963 HG23 VAL A  57       7.917  43.714  18.817  1.00  0.00           H  
ATOM    964  N   ASN A  58      10.130  40.179  16.377  1.00  0.00           N  
ATOM    965  CA  ASN A  58      10.310  38.958  15.601  1.00  0.00           C  
ATOM    966  C   ASN A  58      11.780  38.555  15.554  1.00  0.00           C  
ATOM    967  O   ASN A  58      12.108  37.385  15.353  1.00  0.00           O  
ATOM    968  CB  ASN A  58       9.777  39.150  14.179  1.00  0.00           C  
ATOM    969  CG  ASN A  58       8.340  39.632  14.160  1.00  0.00           C  
ATOM    970  OD1 ASN A  58       7.408  38.851  14.354  1.00  0.00           O  
ATOM    971  ND2 ASN A  58       8.153  40.926  13.926  1.00  0.00           N  
ATOM    972  H   ASN A  58       9.961  41.023  15.908  1.00  0.00           H  
ATOM    973  HA  ASN A  58       9.748  38.172  16.083  1.00  0.00           H  
ATOM    974  HB2 ASN A  58      10.388  39.880  13.668  1.00  0.00           H  
ATOM    975  HB3 ASN A  58       9.830  38.210  13.652  1.00  0.00           H  
ATOM    976 HD21 ASN A  58       8.942  41.489  13.781  1.00  0.00           H  
ATOM    977 HD22 ASN A  58       7.234  41.265  13.909  1.00  0.00           H  
ATOM    978  N   TYR A  59      12.662  39.530  15.743  1.00  0.00           N  
ATOM    979  CA  TYR A  59      14.098  39.278  15.722  1.00  0.00           C  
ATOM    980  C   TYR A  59      14.699  39.429  17.116  1.00  0.00           C  
ATOM    981  O   TYR A  59      13.982  39.641  18.093  1.00  0.00           O  
ATOM    982  CB  TYR A  59      14.790  40.235  14.749  1.00  0.00           C  
ATOM    983  CG  TYR A  59      14.397  40.019  13.305  1.00  0.00           C  
ATOM    984  CD1 TYR A  59      14.607  38.795  12.682  1.00  0.00           C  
ATOM    985  CD2 TYR A  59      13.815  41.040  12.563  1.00  0.00           C  
ATOM    986  CE1 TYR A  59      14.250  38.594  11.363  1.00  0.00           C  
ATOM    987  CE2 TYR A  59      13.453  40.847  11.244  1.00  0.00           C  
ATOM    988  CZ  TYR A  59      13.673  39.623  10.648  1.00  0.00           C  
ATOM    989  OH  TYR A  59      13.315  39.427   9.334  1.00  0.00           O  
ATOM    990  H   TYR A  59      12.340  40.443  15.898  1.00  0.00           H  
ATOM    991  HA  TYR A  59      14.251  38.264  15.384  1.00  0.00           H  
ATOM    992  HB2 TYR A  59      14.539  41.250  15.013  1.00  0.00           H  
ATOM    993  HB3 TYR A  59      15.860  40.102  14.825  1.00  0.00           H  
ATOM    994  HD1 TYR A  59      15.059  37.990  13.245  1.00  0.00           H  
ATOM    995  HD2 TYR A  59      13.644  41.998  13.034  1.00  0.00           H  
ATOM    996  HE1 TYR A  59      14.422  37.635  10.897  1.00  0.00           H  
ATOM    997  HE2 TYR A  59      13.002  41.653  10.683  1.00  0.00           H  
ATOM    998  HH  TYR A  59      12.544  39.961   9.130  1.00  0.00           H  
ATOM    999  N   ASN A  60      16.020  39.319  17.199  1.00  0.00           N  
ATOM   1000  CA  ASN A  60      16.719  39.444  18.472  1.00  0.00           C  
ATOM   1001  C   ASN A  60      16.915  40.911  18.844  1.00  0.00           C  
ATOM   1002  O   ASN A  60      16.627  41.808  18.052  1.00  0.00           O  
ATOM   1003  CB  ASN A  60      18.075  38.738  18.405  1.00  0.00           C  
ATOM   1004  CG  ASN A  60      17.940  37.228  18.372  1.00  0.00           C  
ATOM   1005  OD1 ASN A  60      17.834  36.580  19.414  1.00  0.00           O  
ATOM   1006  ND2 ASN A  60      17.944  36.659  17.172  1.00  0.00           N  
ATOM   1007  H   ASN A  60      16.538  39.150  16.384  1.00  0.00           H  
ATOM   1008  HA  ASN A  60      16.114  38.970  19.230  1.00  0.00           H  
ATOM   1009  HB2 ASN A  60      18.594  39.053  17.511  1.00  0.00           H  
ATOM   1010  HB3 ASN A  60      18.660  39.010  19.270  1.00  0.00           H  
ATOM   1011 HD21 ASN A  60      18.032  37.238  16.386  1.00  0.00           H  
ATOM   1012 HD22 ASN A  60      17.856  35.684  17.121  1.00  0.00           H  
ATOM   1013  N   LYS A  61      17.409  41.148  20.054  1.00  0.00           N  
ATOM   1014  CA  LYS A  61      17.646  42.505  20.533  1.00  0.00           C  
ATOM   1015  C   LYS A  61      18.785  43.162  19.761  1.00  0.00           C  
ATOM   1016  O   LYS A  61      18.995  44.371  19.856  1.00  0.00           O  
ATOM   1017  CB  LYS A  61      17.971  42.491  22.029  1.00  0.00           C  
ATOM   1018  CG  LYS A  61      17.950  43.868  22.668  1.00  0.00           C  
ATOM   1019  CD  LYS A  61      17.508  43.802  24.120  1.00  0.00           C  
ATOM   1020  CE  LYS A  61      18.069  44.962  24.928  1.00  0.00           C  
ATOM   1021  NZ  LYS A  61      17.246  45.248  26.135  1.00  0.00           N  
ATOM   1022  H   LYS A  61      17.620  40.390  20.641  1.00  0.00           H  
ATOM   1023  HA  LYS A  61      16.743  43.074  20.375  1.00  0.00           H  
ATOM   1024  HB2 LYS A  61      17.248  41.870  22.536  1.00  0.00           H  
ATOM   1025  HB3 LYS A  61      18.956  42.068  22.167  1.00  0.00           H  
ATOM   1026  HG2 LYS A  61      18.943  44.290  22.625  1.00  0.00           H  
ATOM   1027  HG3 LYS A  61      17.265  44.498  22.120  1.00  0.00           H  
ATOM   1028  HD2 LYS A  61      16.429  43.839  24.161  1.00  0.00           H  
ATOM   1029  HD3 LYS A  61      17.853  42.873  24.551  1.00  0.00           H  
ATOM   1030  HE2 LYS A  61      19.073  44.715  25.237  1.00  0.00           H  
ATOM   1031  HE3 LYS A  61      18.092  45.841  24.301  1.00  0.00           H  
ATOM   1032  HZ1 LYS A  61      16.959  44.359  26.591  1.00  0.00           H  
ATOM   1033  HZ2 LYS A  61      16.393  45.779  25.867  1.00  0.00           H  
ATOM   1034  HZ3 LYS A  61      17.793  45.814  26.814  1.00  0.00           H  
ATOM   1035  N   ARG A  62      19.517  42.359  18.996  1.00  0.00           N  
ATOM   1036  CA  ARG A  62      20.634  42.864  18.207  1.00  0.00           C  
ATOM   1037  C   ARG A  62      20.141  43.496  16.908  1.00  0.00           C  
ATOM   1038  O   ARG A  62      20.935  43.987  16.104  1.00  0.00           O  
ATOM   1039  CB  ARG A  62      21.617  41.734  17.895  1.00  0.00           C  
ATOM   1040  CG  ARG A  62      21.006  40.599  17.091  1.00  0.00           C  
ATOM   1041  CD  ARG A  62      21.656  39.265  17.427  1.00  0.00           C  
ATOM   1042  NE  ARG A  62      23.072  39.240  17.069  1.00  0.00           N  
ATOM   1043  CZ  ARG A  62      23.859  38.188  17.259  1.00  0.00           C  
ATOM   1044  NH1 ARG A  62      23.372  37.080  17.802  1.00  0.00           N  
ATOM   1045  NH2 ARG A  62      25.137  38.241  16.906  1.00  0.00           N  
ATOM   1046  H   ARG A  62      19.301  41.403  18.961  1.00  0.00           H  
ATOM   1047  HA  ARG A  62      21.138  43.618  18.791  1.00  0.00           H  
ATOM   1048  HB2 ARG A  62      22.446  42.139  17.332  1.00  0.00           H  
ATOM   1049  HB3 ARG A  62      21.988  41.329  18.825  1.00  0.00           H  
ATOM   1050  HG2 ARG A  62      19.951  40.538  17.315  1.00  0.00           H  
ATOM   1051  HG3 ARG A  62      21.143  40.801  16.039  1.00  0.00           H  
ATOM   1052  HD2 ARG A  62      21.561  39.090  18.489  1.00  0.00           H  
ATOM   1053  HD3 ARG A  62      21.142  38.484  16.887  1.00  0.00           H  
ATOM   1054  HE  ARG A  62      23.452  40.047  16.666  1.00  0.00           H  
ATOM   1055 HH11 ARG A  62      22.409  37.037  18.068  1.00  0.00           H  
ATOM   1056 HH12 ARG A  62      23.967  36.289  17.944  1.00  0.00           H  
ATOM   1057 HH21 ARG A  62      25.508  39.074  16.497  1.00  0.00           H  
ATOM   1058 HH22 ARG A  62      25.729  37.449  17.051  1.00  0.00           H  
ATOM   1059  N   LEU A  63      18.827  43.479  16.709  1.00  0.00           N  
ATOM   1060  CA  LEU A  63      18.228  44.050  15.509  1.00  0.00           C  
ATOM   1061  C   LEU A  63      17.676  45.445  15.785  1.00  0.00           C  
ATOM   1062  O   LEU A  63      17.527  46.256  14.872  1.00  0.00           O  
ATOM   1063  CB  LEU A  63      17.112  43.141  14.991  1.00  0.00           C  
ATOM   1064  CG  LEU A  63      17.494  42.188  13.858  1.00  0.00           C  
ATOM   1065  CD1 LEU A  63      18.004  42.967  12.655  1.00  0.00           C  
ATOM   1066  CD2 LEU A  63      18.540  41.189  14.331  1.00  0.00           C  
ATOM   1067  H   LEU A  63      18.247  43.073  17.386  1.00  0.00           H  
ATOM   1068  HA  LEU A  63      18.999  44.124  14.756  1.00  0.00           H  
ATOM   1069  HB2 LEU A  63      16.759  42.547  15.818  1.00  0.00           H  
ATOM   1070  HB3 LEU A  63      16.310  43.773  14.636  1.00  0.00           H  
ATOM   1071  HG  LEU A  63      16.618  41.635  13.549  1.00  0.00           H  
ATOM   1072 HD11 LEU A  63      19.081  42.901  12.613  1.00  0.00           H  
ATOM   1073 HD12 LEU A  63      17.709  44.001  12.744  1.00  0.00           H  
ATOM   1074 HD13 LEU A  63      17.583  42.548  11.751  1.00  0.00           H  
ATOM   1075 HD21 LEU A  63      18.319  40.890  15.345  1.00  0.00           H  
ATOM   1076 HD22 LEU A  63      19.517  41.648  14.295  1.00  0.00           H  
ATOM   1077 HD23 LEU A  63      18.526  40.321  13.687  1.00  0.00           H  
ATOM   1078  N   ASP A  64      17.379  45.716  17.051  1.00  0.00           N  
ATOM   1079  CA  ASP A  64      16.846  47.015  17.450  1.00  0.00           C  
ATOM   1080  C   ASP A  64      17.725  48.146  16.926  1.00  0.00           C  
ATOM   1081  O   ASP A  64      18.885  47.932  16.577  1.00  0.00           O  
ATOM   1082  CB  ASP A  64      16.739  47.100  18.973  1.00  0.00           C  
ATOM   1083  CG  ASP A  64      18.093  47.045  19.653  1.00  0.00           C  
ATOM   1084  OD1 ASP A  64      19.098  46.804  18.953  1.00  0.00           O  
ATOM   1085  OD2 ASP A  64      18.147  47.245  20.884  1.00  0.00           O  
ATOM   1086  H   ASP A  64      17.520  45.027  17.734  1.00  0.00           H  
ATOM   1087  HA  ASP A  64      15.860  47.114  17.022  1.00  0.00           H  
ATOM   1088  HB2 ASP A  64      16.258  48.030  19.242  1.00  0.00           H  
ATOM   1089  HB3 ASP A  64      16.143  46.274  19.332  1.00  0.00           H  
ATOM   1090  N   GLU A  65      17.163  49.349  16.872  1.00  0.00           N  
ATOM   1091  CA  GLU A  65      17.895  50.514  16.389  1.00  0.00           C  
ATOM   1092  C   GLU A  65      17.089  51.791  16.603  1.00  0.00           C  
ATOM   1093  O   GLU A  65      15.981  51.756  17.137  1.00  0.00           O  
ATOM   1094  CB  GLU A  65      18.230  50.353  14.904  1.00  0.00           C  
ATOM   1095  CG  GLU A  65      17.015  50.085  14.032  1.00  0.00           C  
ATOM   1096  CD  GLU A  65      17.341  50.118  12.551  1.00  0.00           C  
ATOM   1097  OE1 GLU A  65      17.880  49.116  12.039  1.00  0.00           O  
ATOM   1098  OE2 GLU A  65      17.056  51.148  11.904  1.00  0.00           O  
ATOM   1099  H   GLU A  65      16.234  49.457  17.165  1.00  0.00           H  
ATOM   1100  HA  GLU A  65      18.815  50.583  16.949  1.00  0.00           H  
ATOM   1101  HB2 GLU A  65      18.707  51.257  14.554  1.00  0.00           H  
ATOM   1102  HB3 GLU A  65      18.917  49.527  14.789  1.00  0.00           H  
ATOM   1103  HG2 GLU A  65      16.620  49.111  14.275  1.00  0.00           H  
ATOM   1104  HG3 GLU A  65      16.268  50.838  14.237  1.00  0.00           H  
ATOM   1105  N   TRP A  66      17.656  52.918  16.185  1.00  0.00           N  
ATOM   1106  CA  TRP A  66      16.991  54.207  16.332  1.00  0.00           C  
ATOM   1107  C   TRP A  66      16.373  54.656  15.012  1.00  0.00           C  
ATOM   1108  O   TRP A  66      17.080  55.078  14.098  1.00  0.00           O  
ATOM   1109  CB  TRP A  66      17.982  55.261  16.829  1.00  0.00           C  
ATOM   1110  CG  TRP A  66      18.591  54.924  18.157  1.00  0.00           C  
ATOM   1111  CD1 TRP A  66      19.650  54.093  18.385  1.00  0.00           C  
ATOM   1112  CD2 TRP A  66      18.176  55.408  19.438  1.00  0.00           C  
ATOM   1113  NE1 TRP A  66      19.919  54.032  19.731  1.00  0.00           N  
ATOM   1114  CE2 TRP A  66      19.029  54.830  20.398  1.00  0.00           C  
ATOM   1115  CE3 TRP A  66      17.169  56.276  19.868  1.00  0.00           C  
ATOM   1116  CZ2 TRP A  66      18.903  55.091  21.760  1.00  0.00           C  
ATOM   1117  CZ3 TRP A  66      17.044  56.534  21.221  1.00  0.00           C  
ATOM   1118  CH2 TRP A  66      17.907  55.945  22.153  1.00  0.00           C  
ATOM   1119  H   TRP A  66      18.542  52.881  15.767  1.00  0.00           H  
ATOM   1120  HA  TRP A  66      16.204  54.093  17.064  1.00  0.00           H  
ATOM   1121  HB2 TRP A  66      18.782  55.362  16.111  1.00  0.00           H  
ATOM   1122  HB3 TRP A  66      17.470  56.208  16.928  1.00  0.00           H  
ATOM   1123  HD1 TRP A  66      20.187  53.566  17.610  1.00  0.00           H  
ATOM   1124  HE1 TRP A  66      20.634  53.502  20.144  1.00  0.00           H  
ATOM   1125  HE3 TRP A  66      16.493  56.740  19.164  1.00  0.00           H  
ATOM   1126  HZ2 TRP A  66      19.561  54.646  22.492  1.00  0.00           H  
ATOM   1127  HZ3 TRP A  66      16.271  57.201  21.572  1.00  0.00           H  
ATOM   1128  HH2 TRP A  66      17.773  56.174  23.199  1.00  0.00           H  
ATOM   1129  N   ILE A  67      15.051  54.562  14.921  1.00  0.00           N  
ATOM   1130  CA  ILE A  67      14.339  54.960  13.712  1.00  0.00           C  
ATOM   1131  C   ILE A  67      13.731  56.349  13.865  1.00  0.00           C  
ATOM   1132  O   ILE A  67      13.635  56.880  14.972  1.00  0.00           O  
ATOM   1133  CB  ILE A  67      13.223  53.958  13.361  1.00  0.00           C  
ATOM   1134  CG1 ILE A  67      12.217  53.858  14.510  1.00  0.00           C  
ATOM   1135  CG2 ILE A  67      13.816  52.592  13.048  1.00  0.00           C  
ATOM   1136  CD1 ILE A  67      10.913  53.202  14.117  1.00  0.00           C  
ATOM   1137  H   ILE A  67      14.542  54.218  15.684  1.00  0.00           H  
ATOM   1138  HA  ILE A  67      15.049  54.976  12.898  1.00  0.00           H  
ATOM   1139  HB  ILE A  67      12.715  54.314  12.477  1.00  0.00           H  
ATOM   1140 HG12 ILE A  67      12.651  53.280  15.311  1.00  0.00           H  
ATOM   1141 HG13 ILE A  67      11.994  54.853  14.870  1.00  0.00           H  
ATOM   1142 HG21 ILE A  67      14.672  52.711  12.402  1.00  0.00           H  
ATOM   1143 HG22 ILE A  67      14.122  52.115  13.967  1.00  0.00           H  
ATOM   1144 HG23 ILE A  67      13.074  51.982  12.555  1.00  0.00           H  
ATOM   1145 HD11 ILE A  67      10.497  53.713  13.260  1.00  0.00           H  
ATOM   1146 HD12 ILE A  67      11.092  52.167  13.864  1.00  0.00           H  
ATOM   1147 HD13 ILE A  67      10.218  53.257  14.941  1.00  0.00           H  
ATOM   1148  N   THR A  68      13.319  56.935  12.744  1.00  0.00           N  
ATOM   1149  CA  THR A  68      12.719  58.263  12.752  1.00  0.00           C  
ATOM   1150  C   THR A  68      11.225  58.193  12.459  1.00  0.00           C  
ATOM   1151  O   THR A  68      10.691  57.127  12.150  1.00  0.00           O  
ATOM   1152  CB  THR A  68      13.390  59.189  11.720  1.00  0.00           C  
ATOM   1153  OG1 THR A  68      13.898  58.417  10.627  1.00  0.00           O  
ATOM   1154  CG2 THR A  68      14.522  59.981  12.359  1.00  0.00           C  
ATOM   1155  H   THR A  68      13.423  56.462  11.893  1.00  0.00           H  
ATOM   1156  HA  THR A  68      12.864  58.688  13.735  1.00  0.00           H  
ATOM   1157  HB  THR A  68      12.650  59.884  11.348  1.00  0.00           H  
ATOM   1158  HG1 THR A  68      14.329  59.000   9.997  1.00  0.00           H  
ATOM   1159 HG21 THR A  68      15.260  59.298  12.752  1.00  0.00           H  
ATOM   1160 HG22 THR A  68      14.129  60.587  13.161  1.00  0.00           H  
ATOM   1161 HG23 THR A  68      14.979  60.616  11.616  1.00  0.00           H  
ATOM   1162  N   THR A  69      10.553  59.336  12.558  1.00  0.00           N  
ATOM   1163  CA  THR A  69       9.120  59.404  12.304  1.00  0.00           C  
ATOM   1164  C   THR A  69       8.780  58.865  10.918  1.00  0.00           C  
ATOM   1165  O   THR A  69       7.793  58.151  10.745  1.00  0.00           O  
ATOM   1166  CB  THR A  69       8.596  60.847  12.421  1.00  0.00           C  
ATOM   1167  OG1 THR A  69       9.150  61.657  11.378  1.00  0.00           O  
ATOM   1168  CG2 THR A  69       8.952  61.443  13.776  1.00  0.00           C  
ATOM   1169  H   THR A  69      11.033  60.152  12.807  1.00  0.00           H  
ATOM   1170  HA  THR A  69       8.620  58.799  13.046  1.00  0.00           H  
ATOM   1171  HB  THR A  69       7.519  60.834  12.322  1.00  0.00           H  
ATOM   1172  HG1 THR A  69      10.081  61.447  11.271  1.00  0.00           H  
ATOM   1173 HG21 THR A  69       8.690  60.745  14.555  1.00  0.00           H  
ATOM   1174 HG22 THR A  69       8.404  62.363  13.919  1.00  0.00           H  
ATOM   1175 HG23 THR A  69      10.012  61.644  13.813  1.00  0.00           H  
ATOM   1176  N   ASP A  70       9.605  59.209   9.936  1.00  0.00           N  
ATOM   1177  CA  ASP A  70       9.394  58.758   8.566  1.00  0.00           C  
ATOM   1178  C   ASP A  70       9.582  57.248   8.455  1.00  0.00           C  
ATOM   1179  O   ASP A  70       9.217  56.639   7.451  1.00  0.00           O  
ATOM   1180  CB  ASP A  70      10.354  59.475   7.615  1.00  0.00           C  
ATOM   1181  CG  ASP A  70       9.886  60.873   7.265  1.00  0.00           C  
ATOM   1182  OD1 ASP A  70       9.089  61.443   8.038  1.00  0.00           O  
ATOM   1183  OD2 ASP A  70      10.317  61.397   6.217  1.00  0.00           O  
ATOM   1184  H   ASP A  70      10.376  59.781  10.138  1.00  0.00           H  
ATOM   1185  HA  ASP A  70       8.380  59.003   8.288  1.00  0.00           H  
ATOM   1186  HB2 ASP A  70      11.326  59.548   8.083  1.00  0.00           H  
ATOM   1187  HB3 ASP A  70      10.441  58.903   6.703  1.00  0.00           H  
ATOM   1188  N   ARG A  71      10.155  56.651   9.496  1.00  0.00           N  
ATOM   1189  CA  ARG A  71      10.394  55.213   9.515  1.00  0.00           C  
ATOM   1190  C   ARG A  71       9.315  54.493  10.318  1.00  0.00           C  
ATOM   1191  O   ARG A  71       9.338  53.269  10.451  1.00  0.00           O  
ATOM   1192  CB  ARG A  71      11.772  54.911  10.107  1.00  0.00           C  
ATOM   1193  CG  ARG A  71      12.925  55.339   9.215  1.00  0.00           C  
ATOM   1194  CD  ARG A  71      14.173  54.512   9.482  1.00  0.00           C  
ATOM   1195  NE  ARG A  71      15.233  54.794   8.518  1.00  0.00           N  
ATOM   1196  CZ  ARG A  71      15.282  54.262   7.302  1.00  0.00           C  
ATOM   1197  NH1 ARG A  71      14.336  53.424   6.903  1.00  0.00           N  
ATOM   1198  NH2 ARG A  71      16.280  54.568   6.483  1.00  0.00           N  
ATOM   1199  H   ARG A  71      10.424  57.190  10.269  1.00  0.00           H  
ATOM   1200  HA  ARG A  71      10.365  54.858   8.495  1.00  0.00           H  
ATOM   1201  HB2 ARG A  71      11.865  55.427  11.052  1.00  0.00           H  
ATOM   1202  HB3 ARG A  71      11.852  53.848  10.277  1.00  0.00           H  
ATOM   1203  HG2 ARG A  71      12.636  55.213   8.183  1.00  0.00           H  
ATOM   1204  HG3 ARG A  71      13.147  56.379   9.404  1.00  0.00           H  
ATOM   1205  HD2 ARG A  71      14.532  54.735  10.475  1.00  0.00           H  
ATOM   1206  HD3 ARG A  71      13.913  53.465   9.421  1.00  0.00           H  
ATOM   1207  HE  ARG A  71      15.943  55.410   8.793  1.00  0.00           H  
ATOM   1208 HH11 ARG A  71      13.582  53.192   7.518  1.00  0.00           H  
ATOM   1209 HH12 ARG A  71      14.375  53.025   5.986  1.00  0.00           H  
ATOM   1210 HH21 ARG A  71      16.996  55.200   6.780  1.00  0.00           H  
ATOM   1211 HH22 ARG A  71      16.316  54.167   5.568  1.00  0.00           H  
ATOM   1212  N   ILE A  72       8.370  55.261  10.850  1.00  0.00           N  
ATOM   1213  CA  ILE A  72       7.282  54.696  11.639  1.00  0.00           C  
ATOM   1214  C   ILE A  72       6.010  54.566  10.808  1.00  0.00           C  
ATOM   1215  O   ILE A  72       5.707  55.423   9.980  1.00  0.00           O  
ATOM   1216  CB  ILE A  72       6.983  55.555  12.882  1.00  0.00           C  
ATOM   1217  CG1 ILE A  72       8.226  55.659  13.767  1.00  0.00           C  
ATOM   1218  CG2 ILE A  72       5.818  54.967  13.664  1.00  0.00           C  
ATOM   1219  CD1 ILE A  72       8.204  56.847  14.704  1.00  0.00           C  
ATOM   1220  H   ILE A  72       8.404  56.229  10.709  1.00  0.00           H  
ATOM   1221  HA  ILE A  72       7.586  53.713  11.970  1.00  0.00           H  
ATOM   1222  HB  ILE A  72       6.701  56.542  12.551  1.00  0.00           H  
ATOM   1223 HG12 ILE A  72       8.311  54.766  14.367  1.00  0.00           H  
ATOM   1224 HG13 ILE A  72       9.100  55.750  13.138  1.00  0.00           H  
ATOM   1225 HG21 ILE A  72       5.920  53.892  13.710  1.00  0.00           H  
ATOM   1226 HG22 ILE A  72       5.818  55.369  14.666  1.00  0.00           H  
ATOM   1227 HG23 ILE A  72       4.890  55.221  13.174  1.00  0.00           H  
ATOM   1228 HD11 ILE A  72       7.812  56.541  15.664  1.00  0.00           H  
ATOM   1229 HD12 ILE A  72       9.207  57.226  14.831  1.00  0.00           H  
ATOM   1230 HD13 ILE A  72       7.576  57.621  14.290  1.00  0.00           H  
ATOM   1231  N   ASN A  73       5.268  53.486  11.035  1.00  0.00           N  
ATOM   1232  CA  ASN A  73       4.027  53.244  10.309  1.00  0.00           C  
ATOM   1233  C   ASN A  73       2.819  53.648  11.147  1.00  0.00           C  
ATOM   1234  O   ASN A  73       2.440  52.949  12.088  1.00  0.00           O  
ATOM   1235  CB  ASN A  73       3.922  51.769   9.917  1.00  0.00           C  
ATOM   1236  CG  ASN A  73       5.075  51.319   9.042  1.00  0.00           C  
ATOM   1237  OD1 ASN A  73       6.241  51.518   9.381  1.00  0.00           O  
ATOM   1238  ND2 ASN A  73       4.754  50.709   7.907  1.00  0.00           N  
ATOM   1239  H   ASN A  73       5.563  52.838  11.709  1.00  0.00           H  
ATOM   1240  HA  ASN A  73       4.047  53.844   9.412  1.00  0.00           H  
ATOM   1241  HB2 ASN A  73       3.918  51.165  10.812  1.00  0.00           H  
ATOM   1242  HB3 ASN A  73       3.001  51.611   9.377  1.00  0.00           H  
ATOM   1243 HD21 ASN A  73       3.804  50.584   7.701  1.00  0.00           H  
ATOM   1244 HD22 ASN A  73       5.479  50.407   7.322  1.00  0.00           H  
ATOM   1245  N   LEU A  74       2.215  54.779  10.798  1.00  0.00           N  
ATOM   1246  CA  LEU A  74       1.047  55.275  11.518  1.00  0.00           C  
ATOM   1247  C   LEU A  74      -0.242  54.824  10.840  1.00  0.00           C  
ATOM   1248  O   LEU A  74      -1.303  55.412  11.048  1.00  0.00           O  
ATOM   1249  CB  LEU A  74       1.086  56.803  11.599  1.00  0.00           C  
ATOM   1250  CG  LEU A  74       2.020  57.396  12.654  1.00  0.00           C  
ATOM   1251  CD1 LEU A  74       2.013  58.914  12.581  1.00  0.00           C  
ATOM   1252  CD2 LEU A  74       1.618  56.926  14.045  1.00  0.00           C  
ATOM   1253  H   LEU A  74       2.562  55.292  10.040  1.00  0.00           H  
ATOM   1254  HA  LEU A  74       1.076  54.869  12.518  1.00  0.00           H  
ATOM   1255  HB2 LEU A  74       1.397  57.177  10.635  1.00  0.00           H  
ATOM   1256  HB3 LEU A  74       0.084  57.148  11.810  1.00  0.00           H  
ATOM   1257  HG  LEU A  74       3.029  57.057  12.465  1.00  0.00           H  
ATOM   1258 HD11 LEU A  74       2.529  59.234  11.687  1.00  0.00           H  
ATOM   1259 HD12 LEU A  74       2.512  59.319  13.449  1.00  0.00           H  
ATOM   1260 HD13 LEU A  74       0.993  59.270  12.554  1.00  0.00           H  
ATOM   1261 HD21 LEU A  74       1.669  57.756  14.734  1.00  0.00           H  
ATOM   1262 HD22 LEU A  74       2.292  56.147  14.370  1.00  0.00           H  
ATOM   1263 HD23 LEU A  74       0.609  56.540  14.018  1.00  0.00           H  
ATOM   1264  N   ASP A  75      -0.143  53.774  10.032  1.00  0.00           N  
ATOM   1265  CA  ASP A  75      -1.303  53.240   9.327  1.00  0.00           C  
ATOM   1266  C   ASP A  75      -1.856  52.013  10.043  1.00  0.00           C  
ATOM   1267  O   ASP A  75      -3.022  51.653   9.872  1.00  0.00           O  
ATOM   1268  CB  ASP A  75      -0.930  52.882   7.888  1.00  0.00           C  
ATOM   1269  CG  ASP A  75      -2.137  52.838   6.970  1.00  0.00           C  
ATOM   1270  OD1 ASP A  75      -2.955  53.781   7.023  1.00  0.00           O  
ATOM   1271  OD2 ASP A  75      -2.263  51.864   6.201  1.00  0.00           O  
ATOM   1272  H   ASP A  75       0.731  53.348   9.907  1.00  0.00           H  
ATOM   1273  HA  ASP A  75      -2.063  54.006   9.311  1.00  0.00           H  
ATOM   1274  HB2 ASP A  75      -0.238  53.618   7.507  1.00  0.00           H  
ATOM   1275  HB3 ASP A  75      -0.457  51.911   7.876  1.00  0.00           H  
ATOM   1276  N   LYS A  76      -1.014  51.371  10.845  1.00  0.00           N  
ATOM   1277  CA  LYS A  76      -1.417  50.184  11.588  1.00  0.00           C  
ATOM   1278  C   LYS A  76      -1.747  50.534  13.036  1.00  0.00           C  
ATOM   1279  O   LYS A  76      -1.106  51.396  13.637  1.00  0.00           O  
ATOM   1280  CB  LYS A  76      -0.308  49.130  11.548  1.00  0.00           C  
ATOM   1281  CG  LYS A  76      -0.387  48.210  10.341  1.00  0.00           C  
ATOM   1282  CD  LYS A  76       0.184  48.871   9.098  1.00  0.00           C  
ATOM   1283  CE  LYS A  76       0.360  47.871   7.966  1.00  0.00           C  
ATOM   1284  NZ  LYS A  76       0.212  48.512   6.631  1.00  0.00           N  
ATOM   1285  H   LYS A  76      -0.097  51.706  10.940  1.00  0.00           H  
ATOM   1286  HA  LYS A  76      -2.302  49.782  11.118  1.00  0.00           H  
ATOM   1287  HB2 LYS A  76       0.648  49.631  11.529  1.00  0.00           H  
ATOM   1288  HB3 LYS A  76      -0.371  48.524  12.440  1.00  0.00           H  
ATOM   1289  HG2 LYS A  76       0.174  47.311  10.548  1.00  0.00           H  
ATOM   1290  HG3 LYS A  76      -1.423  47.956  10.161  1.00  0.00           H  
ATOM   1291  HD2 LYS A  76      -0.491  49.649   8.773  1.00  0.00           H  
ATOM   1292  HD3 LYS A  76       1.145  49.302   9.339  1.00  0.00           H  
ATOM   1293  HE2 LYS A  76       1.344  47.434   8.039  1.00  0.00           H  
ATOM   1294  HE3 LYS A  76      -0.385  47.096   8.069  1.00  0.00           H  
ATOM   1295  HZ1 LYS A  76       0.591  47.888   5.890  1.00  0.00           H  
ATOM   1296  HZ2 LYS A  76       0.730  49.414   6.608  1.00  0.00           H  
ATOM   1297  HZ3 LYS A  76      -0.792  48.698   6.432  1.00  0.00           H  
ATOM   1298  N   GLU A  77      -2.749  49.858  13.590  1.00  0.00           N  
ATOM   1299  CA  GLU A  77      -3.163  50.100  14.967  1.00  0.00           C  
ATOM   1300  C   GLU A  77      -1.968  50.026  15.914  1.00  0.00           C  
ATOM   1301  O   GLU A  77      -1.029  49.264  15.688  1.00  0.00           O  
ATOM   1302  CB  GLU A  77      -4.225  49.082  15.390  1.00  0.00           C  
ATOM   1303  CG  GLU A  77      -5.446  49.066  14.486  1.00  0.00           C  
ATOM   1304  CD  GLU A  77      -6.403  47.938  14.819  1.00  0.00           C  
ATOM   1305  OE1 GLU A  77      -6.113  46.785  14.442  1.00  0.00           O  
ATOM   1306  OE2 GLU A  77      -7.443  48.210  15.455  1.00  0.00           O  
ATOM   1307  H   GLU A  77      -3.223  49.184  13.059  1.00  0.00           H  
ATOM   1308  HA  GLU A  77      -3.587  51.090  15.018  1.00  0.00           H  
ATOM   1309  HB2 GLU A  77      -3.785  48.096  15.383  1.00  0.00           H  
ATOM   1310  HB3 GLU A  77      -4.549  49.314  16.394  1.00  0.00           H  
ATOM   1311  HG2 GLU A  77      -5.969  50.005  14.594  1.00  0.00           H  
ATOM   1312  HG3 GLU A  77      -5.120  48.952  13.463  1.00  0.00           H  
ATOM   1313  N   VAL A  78      -2.012  50.827  16.975  1.00  0.00           N  
ATOM   1314  CA  VAL A  78      -0.934  50.854  17.957  1.00  0.00           C  
ATOM   1315  C   VAL A  78      -1.320  50.087  19.217  1.00  0.00           C  
ATOM   1316  O   VAL A  78      -2.476  50.108  19.640  1.00  0.00           O  
ATOM   1317  CB  VAL A  78      -0.562  52.298  18.342  1.00  0.00           C  
ATOM   1318  CG1 VAL A  78       0.516  52.304  19.415  1.00  0.00           C  
ATOM   1319  CG2 VAL A  78      -0.109  53.075  17.115  1.00  0.00           C  
ATOM   1320  H   VAL A  78      -2.787  51.412  17.101  1.00  0.00           H  
ATOM   1321  HA  VAL A  78      -0.066  50.387  17.514  1.00  0.00           H  
ATOM   1322  HB  VAL A  78      -1.441  52.780  18.743  1.00  0.00           H  
ATOM   1323 HG11 VAL A  78       1.352  51.702  19.088  1.00  0.00           H  
ATOM   1324 HG12 VAL A  78       0.846  53.317  19.589  1.00  0.00           H  
ATOM   1325 HG13 VAL A  78       0.115  51.893  20.330  1.00  0.00           H  
ATOM   1326 HG21 VAL A  78       0.549  52.460  16.520  1.00  0.00           H  
ATOM   1327 HG22 VAL A  78      -0.971  53.354  16.528  1.00  0.00           H  
ATOM   1328 HG23 VAL A  78       0.417  53.967  17.428  1.00  0.00           H  
ATOM   1329  N   LEU A  79      -0.344  49.411  19.813  1.00  0.00           N  
ATOM   1330  CA  LEU A  79      -0.580  48.637  21.027  1.00  0.00           C  
ATOM   1331  C   LEU A  79      -0.047  49.370  22.252  1.00  0.00           C  
ATOM   1332  O   LEU A  79       1.112  49.785  22.286  1.00  0.00           O  
ATOM   1333  CB  LEU A  79       0.081  47.261  20.914  1.00  0.00           C  
ATOM   1334  CG  LEU A  79      -0.855  46.090  20.611  1.00  0.00           C  
ATOM   1335  CD1 LEU A  79      -1.753  45.802  21.804  1.00  0.00           C  
ATOM   1336  CD2 LEU A  79      -1.688  46.381  19.371  1.00  0.00           C  
ATOM   1337  H   LEU A  79       0.557  49.433  19.428  1.00  0.00           H  
ATOM   1338  HA  LEU A  79      -1.646  48.507  21.134  1.00  0.00           H  
ATOM   1339  HB2 LEU A  79       0.815  47.311  20.124  1.00  0.00           H  
ATOM   1340  HB3 LEU A  79       0.577  47.056  21.852  1.00  0.00           H  
ATOM   1341  HG  LEU A  79      -0.263  45.206  20.417  1.00  0.00           H  
ATOM   1342 HD11 LEU A  79      -1.148  45.693  22.691  1.00  0.00           H  
ATOM   1343 HD12 LEU A  79      -2.303  44.889  21.629  1.00  0.00           H  
ATOM   1344 HD13 LEU A  79      -2.447  46.620  21.938  1.00  0.00           H  
ATOM   1345 HD21 LEU A  79      -2.664  46.736  19.669  1.00  0.00           H  
ATOM   1346 HD22 LEU A  79      -1.796  45.477  18.790  1.00  0.00           H  
ATOM   1347 HD23 LEU A  79      -1.196  47.135  18.775  1.00  0.00           H  
ATOM   1348  N   TYR A  80      -0.899  49.525  23.259  1.00  0.00           N  
ATOM   1349  CA  TYR A  80      -0.515  50.209  24.488  1.00  0.00           C  
ATOM   1350  C   TYR A  80      -0.685  49.294  25.697  1.00  0.00           C  
ATOM   1351  O   TYR A  80      -1.459  48.337  25.679  1.00  0.00           O  
ATOM   1352  CB  TYR A  80      -1.348  51.478  24.673  1.00  0.00           C  
ATOM   1353  CG  TYR A  80      -0.957  52.602  23.741  1.00  0.00           C  
ATOM   1354  CD1 TYR A  80       0.038  53.506  24.092  1.00  0.00           C  
ATOM   1355  CD2 TYR A  80      -1.579  52.759  22.509  1.00  0.00           C  
ATOM   1356  CE1 TYR A  80       0.399  54.535  23.244  1.00  0.00           C  
ATOM   1357  CE2 TYR A  80      -1.223  53.784  21.653  1.00  0.00           C  
ATOM   1358  CZ  TYR A  80      -0.234  54.670  22.025  1.00  0.00           C  
ATOM   1359  OH  TYR A  80       0.123  55.692  21.177  1.00  0.00           O  
ATOM   1360  H   TYR A  80      -1.810  49.173  23.174  1.00  0.00           H  
ATOM   1361  HA  TYR A  80       0.526  50.484  24.403  1.00  0.00           H  
ATOM   1362  HB2 TYR A  80      -2.387  51.248  24.494  1.00  0.00           H  
ATOM   1363  HB3 TYR A  80      -1.233  51.832  25.688  1.00  0.00           H  
ATOM   1364  HD1 TYR A  80       0.533  53.399  25.046  1.00  0.00           H  
ATOM   1365  HD2 TYR A  80      -2.355  52.063  22.221  1.00  0.00           H  
ATOM   1366  HE1 TYR A  80       1.175  55.229  23.534  1.00  0.00           H  
ATOM   1367  HE2 TYR A  80      -1.720  53.889  20.700  1.00  0.00           H  
ATOM   1368  HH  TYR A  80       0.964  55.484  20.762  1.00  0.00           H  
ATOM   1369  N   PRO A  81       0.054  49.595  26.775  1.00  0.00           N  
ATOM   1370  CA  PRO A  81       0.003  48.814  28.013  1.00  0.00           C  
ATOM   1371  C   PRO A  81      -1.320  48.985  28.753  1.00  0.00           C  
ATOM   1372  O   PRO A  81      -2.053  49.947  28.520  1.00  0.00           O  
ATOM   1373  CB  PRO A  81       1.156  49.386  28.842  1.00  0.00           C  
ATOM   1374  CG  PRO A  81       1.339  50.774  28.330  1.00  0.00           C  
ATOM   1375  CD  PRO A  81       0.998  50.722  26.867  1.00  0.00           C  
ATOM   1376  HA  PRO A  81       0.177  47.764  27.828  1.00  0.00           H  
ATOM   1377  HB2 PRO A  81       0.887  49.382  29.889  1.00  0.00           H  
ATOM   1378  HB3 PRO A  81       2.043  48.789  28.690  1.00  0.00           H  
ATOM   1379  HG2 PRO A  81       0.672  51.446  28.847  1.00  0.00           H  
ATOM   1380  HG3 PRO A  81       2.364  51.082  28.465  1.00  0.00           H  
ATOM   1381  HD2 PRO A  81       0.529  51.644  26.556  1.00  0.00           H  
ATOM   1382  HD3 PRO A  81       1.884  50.531  26.279  1.00  0.00           H  
ATOM   1383  N   LYS A  82      -1.619  48.048  29.646  1.00  0.00           N  
ATOM   1384  CA  LYS A  82      -2.853  48.096  30.420  1.00  0.00           C  
ATOM   1385  C   LYS A  82      -2.580  48.546  31.852  1.00  0.00           C  
ATOM   1386  O   LYS A  82      -1.536  48.228  32.425  1.00  0.00           O  
ATOM   1387  CB  LYS A  82      -3.529  46.722  30.427  1.00  0.00           C  
ATOM   1388  CG  LYS A  82      -4.785  46.666  31.279  1.00  0.00           C  
ATOM   1389  CD  LYS A  82      -5.882  45.862  30.604  1.00  0.00           C  
ATOM   1390  CE  LYS A  82      -7.232  46.097  31.263  1.00  0.00           C  
ATOM   1391  NZ  LYS A  82      -7.676  47.512  31.131  1.00  0.00           N  
ATOM   1392  H   LYS A  82      -0.995  47.306  29.787  1.00  0.00           H  
ATOM   1393  HA  LYS A  82      -3.513  48.810  29.951  1.00  0.00           H  
ATOM   1394  HB2 LYS A  82      -3.795  46.461  29.414  1.00  0.00           H  
ATOM   1395  HB3 LYS A  82      -2.829  45.992  30.807  1.00  0.00           H  
ATOM   1396  HG2 LYS A  82      -4.547  46.205  32.226  1.00  0.00           H  
ATOM   1397  HG3 LYS A  82      -5.140  47.674  31.447  1.00  0.00           H  
ATOM   1398  HD2 LYS A  82      -5.946  46.156  29.566  1.00  0.00           H  
ATOM   1399  HD3 LYS A  82      -5.638  44.812  30.667  1.00  0.00           H  
ATOM   1400  HE2 LYS A  82      -7.963  45.454  30.797  1.00  0.00           H  
ATOM   1401  HE3 LYS A  82      -7.153  45.850  32.312  1.00  0.00           H  
ATOM   1402  HZ1 LYS A  82      -7.332  48.071  31.938  1.00  0.00           H  
ATOM   1403  HZ2 LYS A  82      -8.715  47.559  31.108  1.00  0.00           H  
ATOM   1404  HZ3 LYS A  82      -7.302  47.923  30.252  1.00  0.00           H  
ATOM   1405  N   LEU A  83      -3.522  49.286  32.425  1.00  0.00           N  
ATOM   1406  CA  LEU A  83      -3.383  49.779  33.791  1.00  0.00           C  
ATOM   1407  C   LEU A  83      -4.603  49.411  34.630  1.00  0.00           C  
ATOM   1408  O   LEU A  83      -5.742  49.567  34.191  1.00  0.00           O  
ATOM   1409  CB  LEU A  83      -3.192  51.297  33.789  1.00  0.00           C  
ATOM   1410  CG  LEU A  83      -1.978  51.819  33.020  1.00  0.00           C  
ATOM   1411  CD1 LEU A  83      -2.099  53.317  32.784  1.00  0.00           C  
ATOM   1412  CD2 LEU A  83      -0.692  51.497  33.769  1.00  0.00           C  
ATOM   1413  H   LEU A  83      -4.332  49.507  31.918  1.00  0.00           H  
ATOM   1414  HA  LEU A  83      -2.510  49.315  34.224  1.00  0.00           H  
ATOM   1415  HB2 LEU A  83      -4.074  51.741  33.355  1.00  0.00           H  
ATOM   1416  HB3 LEU A  83      -3.097  51.619  34.817  1.00  0.00           H  
ATOM   1417  HG  LEU A  83      -1.934  51.333  32.055  1.00  0.00           H  
ATOM   1418 HD11 LEU A  83      -2.910  53.710  33.379  1.00  0.00           H  
ATOM   1419 HD12 LEU A  83      -2.296  53.502  31.739  1.00  0.00           H  
ATOM   1420 HD13 LEU A  83      -1.175  53.801  33.068  1.00  0.00           H  
ATOM   1421 HD21 LEU A  83      -0.876  50.699  34.473  1.00  0.00           H  
ATOM   1422 HD22 LEU A  83      -0.357  52.376  34.300  1.00  0.00           H  
ATOM   1423 HD23 LEU A  83       0.067  51.190  33.065  1.00  0.00           H  
ATOM   1424  N   LYS A  84      -4.355  48.921  35.840  1.00  0.00           N  
ATOM   1425  CA  LYS A  84      -5.433  48.533  36.744  1.00  0.00           C  
ATOM   1426  C   LYS A  84      -5.080  48.875  38.188  1.00  0.00           C  
ATOM   1427  O   LYS A  84      -3.945  48.683  38.622  1.00  0.00           O  
ATOM   1428  CB  LYS A  84      -5.717  47.035  36.617  1.00  0.00           C  
ATOM   1429  CG  LYS A  84      -6.888  46.564  37.462  1.00  0.00           C  
ATOM   1430  CD  LYS A  84      -8.204  46.701  36.714  1.00  0.00           C  
ATOM   1431  CE  LYS A  84      -8.385  45.585  35.696  1.00  0.00           C  
ATOM   1432  NZ  LYS A  84      -9.795  45.483  35.231  1.00  0.00           N  
ATOM   1433  H   LYS A  84      -3.425  48.820  36.134  1.00  0.00           H  
ATOM   1434  HA  LYS A  84      -6.317  49.084  36.461  1.00  0.00           H  
ATOM   1435  HB2 LYS A  84      -5.931  46.807  35.584  1.00  0.00           H  
ATOM   1436  HB3 LYS A  84      -4.837  46.486  36.923  1.00  0.00           H  
ATOM   1437  HG2 LYS A  84      -6.740  45.527  37.721  1.00  0.00           H  
ATOM   1438  HG3 LYS A  84      -6.933  47.160  38.363  1.00  0.00           H  
ATOM   1439  HD2 LYS A  84      -9.017  46.660  37.424  1.00  0.00           H  
ATOM   1440  HD3 LYS A  84      -8.219  47.651  36.200  1.00  0.00           H  
ATOM   1441  HE2 LYS A  84      -7.749  45.783  34.848  1.00  0.00           H  
ATOM   1442  HE3 LYS A  84      -8.097  44.649  36.152  1.00  0.00           H  
ATOM   1443  HZ1 LYS A  84      -9.963  46.144  34.446  1.00  0.00           H  
ATOM   1444  HZ2 LYS A  84     -10.447  45.713  36.009  1.00  0.00           H  
ATOM   1445  HZ3 LYS A  84      -9.994  44.516  34.903  1.00  0.00           H  
ATOM   1446  N   ALA A  85      -6.062  49.379  38.928  1.00  0.00           N  
ATOM   1447  CA  ALA A  85      -5.856  49.743  40.324  1.00  0.00           C  
ATOM   1448  C   ALA A  85      -5.550  48.514  41.173  1.00  0.00           C  
ATOM   1449  O   ALA A  85      -6.403  47.647  41.362  1.00  0.00           O  
ATOM   1450  CB  ALA A  85      -7.080  50.468  40.866  1.00  0.00           C  
ATOM   1451  H   ALA A  85      -6.946  49.507  38.526  1.00  0.00           H  
ATOM   1452  HA  ALA A  85      -5.016  50.421  40.372  1.00  0.00           H  
ATOM   1453  HB1 ALA A  85      -7.965  50.101  40.367  1.00  0.00           H  
ATOM   1454  HB2 ALA A  85      -7.164  50.289  41.928  1.00  0.00           H  
ATOM   1455  HB3 ALA A  85      -6.978  51.528  40.687  1.00  0.00           H  
ATOM   1456  N   THR A  86      -4.323  48.443  41.682  1.00  0.00           N  
ATOM   1457  CA  THR A  86      -3.902  47.319  42.509  1.00  0.00           C  
ATOM   1458  C   THR A  86      -3.141  47.797  43.740  1.00  0.00           C  
ATOM   1459  O   THR A  86      -2.056  48.368  43.629  1.00  0.00           O  
ATOM   1460  CB  THR A  86      -3.013  46.342  41.718  1.00  0.00           C  
ATOM   1461  OG1 THR A  86      -3.419  46.312  40.345  1.00  0.00           O  
ATOM   1462  CG2 THR A  86      -3.091  44.941  42.305  1.00  0.00           C  
ATOM   1463  H   THR A  86      -3.687  49.165  41.496  1.00  0.00           H  
ATOM   1464  HA  THR A  86      -4.788  46.790  42.828  1.00  0.00           H  
ATOM   1465  HB  THR A  86      -1.989  46.683  41.775  1.00  0.00           H  
ATOM   1466  HG1 THR A  86      -3.156  45.476  39.951  1.00  0.00           H  
ATOM   1467 HG21 THR A  86      -3.204  45.007  43.377  1.00  0.00           H  
ATOM   1468 HG22 THR A  86      -2.186  44.401  42.071  1.00  0.00           H  
ATOM   1469 HG23 THR A  86      -3.940  44.422  41.886  1.00  0.00           H  
ATOM   1470  N   ASP A  87      -3.717  47.560  44.914  1.00  0.00           N  
ATOM   1471  CA  ASP A  87      -3.092  47.965  46.168  1.00  0.00           C  
ATOM   1472  C   ASP A  87      -2.603  46.749  46.949  1.00  0.00           C  
ATOM   1473  O   ASP A  87      -3.055  46.494  48.065  1.00  0.00           O  
ATOM   1474  CB  ASP A  87      -4.077  48.770  47.018  1.00  0.00           C  
ATOM   1475  CG  ASP A  87      -3.420  49.388  48.235  1.00  0.00           C  
ATOM   1476  OD1 ASP A  87      -2.497  50.211  48.059  1.00  0.00           O  
ATOM   1477  OD2 ASP A  87      -3.830  49.051  49.366  1.00  0.00           O  
ATOM   1478  H   ASP A  87      -4.583  47.101  44.937  1.00  0.00           H  
ATOM   1479  HA  ASP A  87      -2.244  48.588  45.930  1.00  0.00           H  
ATOM   1480  HB2 ASP A  87      -4.497  49.563  46.416  1.00  0.00           H  
ATOM   1481  HB3 ASP A  87      -4.871  48.118  47.350  1.00  0.00           H  
ATOM   1482  N   GLU A  88      -1.678  46.003  46.354  1.00  0.00           N  
ATOM   1483  CA  GLU A  88      -1.130  44.813  46.994  1.00  0.00           C  
ATOM   1484  C   GLU A  88       0.301  45.058  47.465  1.00  0.00           C  
ATOM   1485  O   GLU A  88       0.859  46.136  47.255  1.00  0.00           O  
ATOM   1486  CB  GLU A  88      -1.165  43.626  46.029  1.00  0.00           C  
ATOM   1487  CG  GLU A  88      -2.543  43.007  45.875  1.00  0.00           C  
ATOM   1488  CD  GLU A  88      -2.497  41.628  45.246  1.00  0.00           C  
ATOM   1489  OE1 GLU A  88      -1.608  40.835  45.622  1.00  0.00           O  
ATOM   1490  OE2 GLU A  88      -3.348  41.342  44.378  1.00  0.00           O  
ATOM   1491  H   GLU A  88      -1.356  46.259  45.464  1.00  0.00           H  
ATOM   1492  HA  GLU A  88      -1.744  44.585  47.852  1.00  0.00           H  
ATOM   1493  HB2 GLU A  88      -0.830  43.958  45.057  1.00  0.00           H  
ATOM   1494  HB3 GLU A  88      -0.489  42.864  46.390  1.00  0.00           H  
ATOM   1495  HG2 GLU A  88      -2.998  42.925  46.850  1.00  0.00           H  
ATOM   1496  HG3 GLU A  88      -3.145  43.651  45.251  1.00  0.00           H  
ATOM   1497  N   ASP A  89       0.889  44.052  48.101  1.00  0.00           N  
ATOM   1498  CA  ASP A  89       2.255  44.157  48.602  1.00  0.00           C  
ATOM   1499  C   ASP A  89       3.060  42.909  48.251  1.00  0.00           C  
ATOM   1500  O   ASP A  89       2.811  41.828  48.787  1.00  0.00           O  
ATOM   1501  CB  ASP A  89       2.251  44.367  50.117  1.00  0.00           C  
ATOM   1502  CG  ASP A  89       3.609  44.113  50.741  1.00  0.00           C  
ATOM   1503  OD1 ASP A  89       4.576  44.805  50.359  1.00  0.00           O  
ATOM   1504  OD2 ASP A  89       3.705  43.222  51.610  1.00  0.00           O  
ATOM   1505  H   ASP A  89       0.393  43.218  48.238  1.00  0.00           H  
ATOM   1506  HA  ASP A  89       2.716  45.011  48.131  1.00  0.00           H  
ATOM   1507  HB2 ASP A  89       1.962  45.386  50.332  1.00  0.00           H  
ATOM   1508  HB3 ASP A  89       1.537  43.692  50.566  1.00  0.00           H  
TER    1509      ASP A  89                                                      
END
MOLECULE T0504_156_208.pdb
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58          
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91          
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72          
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80          
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27          
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73          
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88          
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77          
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68          
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94          
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31          
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02          
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19          
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70          
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12          
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86          
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34          
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76          
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71          
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52          
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91          
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36          
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38          
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39          
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82          
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48          
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98          
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19          
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71          
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84          
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14          
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05          
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85          
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53          
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66          
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77          
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29          
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32          
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60          
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59          
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08          
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57          
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74          
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20          
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82          
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39          
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79          
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54          
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96          
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12          
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51          
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64          
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76          
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65          
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28          
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12          
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38          
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12          
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39          
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12          
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66          
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46          
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68          
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83          
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29          
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79          
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92          
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19          
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22          
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55          
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94          
ATOM   1327  CD  ILE   165       6.209  52.315  15.886  1.00 31.23          
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32          
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55          
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72          
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69          
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62          
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02          
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39          
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70          
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81          
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59          
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66          
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59          
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49          
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44          
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65          
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70          
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83          
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50          
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37          
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23          
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42          
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75          
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02          
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37          
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81          
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83          
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47          
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48          
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67          
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31          
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92          
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33          
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61          
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22          
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95          
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43          
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18          
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32          
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82          
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67          
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81          
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65          
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53          
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22          
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81          
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48          
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91          
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38          
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53          
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91          
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93          
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29          
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97          
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96          
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58          
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03          
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14          
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39          
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72          
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96          
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58          
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06          
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62          
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25          
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07          
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76          
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53          
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95          
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13          
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72          
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76          
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92          
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47          
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94          
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59          
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02          
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27          
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02          
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07          
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96          
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25          
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15          
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78          
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29          
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76          
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16          
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08          
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93          
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03          
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12          
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58          
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08          
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32          
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83          
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01          
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96          
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78          
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65          
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82          
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57          
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13          
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30          
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50          
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23          
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69          
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37          
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78          
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90          
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76          
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41          
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84          
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54          
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82          
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67          
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14          
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15          
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17          
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26          
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41          
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74          
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77          
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35          
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94          
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10          
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30          
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27          
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60          
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02          
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04          
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81          
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78          
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10          
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01          
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48          
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67          
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28          
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92          
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88          
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40          
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39          
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18          
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81          
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39          
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32          
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58          
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76          
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51          
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24          
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81          
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85          
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36          
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04          
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46          
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63          
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34          
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28          
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60          
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82          
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12          
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15          
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45          
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55          
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99          
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01          
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84          
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91          
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02          
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76          
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01          
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62          
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91          
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03          
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69          
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74          
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00          
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67          
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49          
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21          
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37          
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33          
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21          
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88          
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64          
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81          
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28          
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49          
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90          
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02          
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12          
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09          
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66          
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30          
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33          
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61          
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16          
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49          
ATOM   1524  CD  ILE   188      10.070  52.171  17.195  1.00 22.12          
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97          
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24          
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98          
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53          
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66          
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05          
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76          
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44          
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56          
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30          
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61          
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27          
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14          
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24          
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90          
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65          
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09          
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22          
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07          
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13          
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23          
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45          
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88          
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39          
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37          
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18          
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11          
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76          
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98          
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06          
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15          
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12          
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35          
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17          
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49          
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48          
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20          
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84          
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46          
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90          
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22          
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81          
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17          
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73          
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40          
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81          
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79          
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00          
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11          
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34          
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22          
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08          
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25          
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17          
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60          
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73          
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18          
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44          
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65          
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06          
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18          
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07          
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04          
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77          
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81          
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67          
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17          
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89          
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26          
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76          
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18          
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50          
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36          
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74          
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30          
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31          
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51          
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61          
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47          
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94          
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12          
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46          
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05          
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37          
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69          
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54          
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80          
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60          
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83          
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73          
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65          
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44          
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23          
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26          
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58          
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43          
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27          
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13          
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58          
ATOM   1624  CD  ILE   199      12.999  52.559  12.729  1.00 20.55          
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51          
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19          
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92          
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19          
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38          
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91          
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47          
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20          
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57          
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44          
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50          
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12          
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97          
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26          
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54          
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69          
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36          
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88          
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58          
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28          
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92          
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45          
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56          
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01          
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86          
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26          
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88          
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49          
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20          
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50          
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52          
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94          
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80          
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15          
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74          
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11          
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13          
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63          
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86          
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83          
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24          
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93          
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95          
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76          
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56          
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52          
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50          
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97          
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21          
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11          
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43          
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70          
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63          
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00          
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37          
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66          
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91          
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37          
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02          
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72          
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09          
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64          
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26          
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27          
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33          
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61          
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10          
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09          
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83          
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60          
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76          
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26          
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94          
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04          
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06          
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74          
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96          
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24          
END
