
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  170 ( 1283),  selected  170 , name 1k1e_D
# Molecule2: number of CA atoms  159 ( 1235),  selected  159 , name T0505_6_84_201_280.pdb
# PARAMETERS: 1k1e_D.T0505_6_84_201_280.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     5_D      -       -           -
LGA    E     6_D      -       -           -
LGA    N     7_D      -       -           -
LGA    I     8_D      K       6          1.258
LGA    K     9_D      Q       7          1.450
LGA    F    10_D      L       8          1.093
LGA    V    11_D      L       9          0.880
LGA    I    12_D      A      10          0.607
LGA    T    13_D      L      11          0.674
LGA    D    14_D      N      12          1.054
LGA    V    15_D      I      13          1.070
LGA    D    16_D      D      14          0.927
LGA    G    17_D      G      15          0.467
LGA    V    18_D      A      16          0.666
LGA    L    19_D      L      17          0.942
LGA    T    20_D      L      18          1.779
LGA    D    21_D      R      19          3.402
LGA    G    22_D      S      20          4.689
LGA    Q    23_D      N      21           #
LGA    L    24_D      -       -           -
LGA    H    25_D      -       -           -
LGA    Y    26_D      -       -           -
LGA    D    27_D      -       -           -
LGA    A    28_D      -       -           -
LGA    N    29_D      -       -           -
LGA    G    30_D      -       -           -
LGA    E    31_D      -       -           -
LGA    A    32_D      -       -           -
LGA    I    33_D      -       -           -
LGA    K    34_D      G      22          3.970
LGA    S    35_D      K      23          2.301
LGA    F    36_D      I      24          1.751
LGA    H    37_D      X      25          1.817
LGA    V    38_D      Q      26          1.646
LGA    R    39_D      A      27          0.883
LGA    D    40_D      T      28          0.758
LGA    G    41_D      K      29          1.099
LGA    L    42_D      D      30          0.890
LGA    G    43_D      A      31          0.465
LGA    I    44_D      I      32          0.545
LGA    K    45_D      E      33          0.757
LGA    M    46_D      Y      34          0.449
LGA    L    47_D      V      35          0.500
LGA    M    48_D      K      36          0.651
LGA    D    49_D      K      37          0.432
LGA    A    50_D      K      38          0.679
LGA    D    51_D      G      39          0.876
LGA    I    52_D      I      40          1.230
LGA    Q    53_D      Y      41          1.259
LGA    V    54_D      V      42          0.835
LGA    A    55_D      T      43          0.989
LGA    V    56_D      L      44          0.637
LGA    L    57_D      V      45          0.512
LGA    S    58_D      T      46          0.673
LGA    G    59_D      N      47          1.286
LGA    R    60_D      R      48          0.967
LGA    D    61_D      X      49          1.403
LGA    S    62_D      F      50          5.173
LGA    P    63_D      R      51          3.189
LGA    I    64_D      S      52          3.813
LGA    L    65_D      A      53          3.153
LGA    R    66_D      Q      54          1.544
LGA    R    67_D      K      55          1.681
LGA    R    68_D      I      56          2.055
LGA    I    69_D      A      57          0.421
LGA    A    70_D      K      58          1.216
LGA    D    71_D      S      59          2.452
LGA    L    72_D      L      60          1.488
LGA    G    73_D      K      61          1.830
LGA    I    74_D      L      62          1.155
LGA    K    75_D      D      63          2.772
LGA    L    76_D      A      64          2.439
LGA    -       -      K      65           -
LGA    F    77_D      L      66          1.317
LGA    F    78_D      I      67          1.008
LGA    L    79_D      T      68          1.422
LGA    G    80_D      X      69          1.303
LGA    K    81_D      S      70          1.770
LGA    L    82_D      G      71          5.378
LGA    -       -      A      72           -
LGA    -       -      Y      73           -
LGA    -       -      I      74           -
LGA    -       -      A      75           -
LGA    -       -      E      76           -
LGA    -       -      K      77           -
LGA    -       -      I      78           -
LGA    -       -      D      79           -
LGA    -       -      A      80           -
LGA    -       -      P      81           -
LGA    -       -      F      82           -
LGA    -       -      F      83           -
LGA    -       -      E      84           -
LGA    E    83_D      V     201          4.512
LGA    -       -      S     202           -
LGA    K    84_D      K     203          1.035
LGA    E    85_D      E     204          1.398
LGA    T    86_D      A     205          0.426
LGA    A    87_D      G     206          1.182
LGA    C    88_D      L     207          1.629
LGA    F    89_D      A     208          0.253
LGA    D    90_D      L     209          1.078
LGA    L    91_D      V     210          1.785
LGA    M    92_D      A     211          0.902
LGA    K    93_D      S     212          1.592
LGA    Q    94_D      E     213          2.822
LGA    A    95_D      L     214          2.787
LGA    G    96_D      G     215          2.331
LGA    V    97_D      L     216          1.441
LGA    T    98_D      S     217          1.415
LGA    A    99_D      M     218          1.261
LGA    E   100_D      D     219          1.176
LGA    Q   101_D      D     220          1.228
LGA    T   102_D      V     221          0.749
LGA    A   103_D      V     222          0.890
LGA    Y   104_D      A     223          0.491
LGA    I   105_D      I     224          0.492
LGA    G   106_D      G     225          0.621
LGA    D   107_D      X     226          0.473
LGA    D   108_D      Q     227          0.643
LGA    S   109_D      Y     228          0.354
LGA    V   110_D      D     229          0.743
LGA    D   111_D      D     230          0.290
LGA    L   112_D      L     231          0.509
LGA    P   113_D      P     232          0.993
LGA    A   114_D      M     233          0.907
LGA    F   115_D      I     234          0.902
LGA    A   116_D      E     235          1.885
LGA    A   117_D      L     236          2.107
LGA    C   118_D      A     237          0.741
LGA    G   119_D      G     238          1.170
LGA    T   120_D      L     239          0.775
LGA    S   121_D      G     240          0.758
LGA    F   122_D      V     241          0.767
LGA    A   123_D      A     242          0.769
LGA    V   124_D      M     243          0.915
LGA    A   125_D      G     244          0.985
LGA    D   126_D      N     245          1.402
LGA    A   127_D      A     246          0.750
LGA    P   128_D      V     247          0.383
LGA    I   129_D      P     248          0.773
LGA    Y   130_D      E     249          1.016
LGA    V   131_D      I     250          0.669
LGA    K   132_D      K     251          0.326
LGA    N   133_D      R     252          0.943
LGA    A   134_D      K     253          1.009
LGA    V   135_D      A     254          0.602
LGA    D   136_D      D     255          0.568
LGA    H   137_D      W     256          0.514
LGA    V   138_D      V     257          0.550
LGA    L   139_D      T     258          0.768
LGA    S   140_D      R     259          2.797
LGA    T   141_D      -       -           -
LGA    H   142_D      S     260          0.964
LGA    G   143_D      N     261          1.441
LGA    G   144_D      D     262          4.404
LGA    K   145_D      E     263          3.385
LGA    G   146_D      Q     264          1.185
LGA    A   147_D      G     265          1.062
LGA    F   148_D      V     266          0.928
LGA    R   149_D      A     267          0.487
LGA    E   150_D      Y     268          0.886
LGA    M   151_D      M     269          1.499
LGA    S   152_D      M     270          1.257
LGA    D   153_D      K     271          0.620
LGA    M   154_D      E     272          1.251
LGA    I   155_D      Y     273          1.377
LGA    L   156_D      F     274          1.475
LGA    Q   157_D      R     275          1.437
LGA    A   158_D      M     276          1.482
LGA    Q   159_D      Q     277          1.467
LGA    G   160_D      Q     278          1.375
LGA    K   161_D      R     279           -
LGA    S   162_D      K     280           -
LGA    S   163_D      -       -           -
LGA    V   164_D      -       -           -
LGA    F   165_D      -       -           -
LGA    D   166_D      -       -           -
LGA    T   167_D      -       -           -
LGA    A   168_D      -       -           -
LGA    Q   169_D      -       -           -
LGA    G   170_D      -       -           -
LGA    F   171_D      -       -           -
LGA    L   172_D      -       -           -
LGA    K   173_D      -       -           -
LGA    S   174_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  170  159    5.0    141    1.67    17.02     82.073     7.985

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.722766 * X  +   0.532489 * Y  +   0.440528 * Z  +  12.239500
  Y_new =  -0.046959 * X  +   0.598123 * Y  +  -0.800027 * Z  + 101.901573
  Z_new =  -0.689496 * X  +  -0.598919 * Y  +  -0.407298 * Z  + 105.840996 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.168010    0.973583  [ DEG:  -124.2178     55.7822 ]
  Theta =   0.760793    2.380800  [ DEG:    43.5902    136.4098 ]
  Phi   =  -3.076712    0.064880  [ DEG:  -176.2826      3.7174 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k1e_D                                        
REMARK     2: T0505_6_84_201_280.pdb                        
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k1e_D.T0505_6_84_201_280.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  170  159   5.0  141   1.67   17.02  82.073
REMARK  ---------------------------------------------------------- 
MOLECULE 1k1e_D
HEADER    HYDROLASE                               25-SEP-01   1K1E              
TITLE     STRUCTURE OF THE COBALT-BOUND FORM OF THE DEOXY-D-MANNOSE-            
TITLE    2 OCTULOSONATE 8-PHOSPHATE PHOSPHATASE (YRBI) FROM                     
TITLE    3 HAEMOPHILUS INFLUENZAE (HI1679)                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEOXY-D-MANNOSE-OCTULOSONATE 8-PHOSPHATE                   
COMPND   3 PHOSPHATASE;                                                         
COMPND   4 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   5 SYNONYM: YRBI, KDO 8-P PHOSPHATASE, HI1679;                          
COMPND   6 EC: 3.1.3.-;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: KW20;                                                        
SOURCE   5 GENE: HI1679;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B21(DE3);                                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDEST17-HI1679                            
KEYWDS    HI1679, STRUCTURAL GENOMICS, KDO 8-P PHOSPHATASE, STRUCTURE           
KEYWDS   2 2 FUNCTION PROJECT, S2F                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.LIM,O.HERZBERG,STRUCTURE 2 FUNCTION PROJECT (S2F)                   
REVDAT   3   12-AUG-03 1K1E    1       REMARK                                   
REVDAT   2   22-APR-03 1K1E    1       JRNL   TITLE  COMPND KEYWDS              
REVDAT   1   27-FEB-02 1K1E    0                                                
JRNL        AUTH   J.F.PARSONS,K.LIM,A.TEMPCZYK,W.KRAJEWSKI,                    
JRNL        AUTH 2 E.EISENSTEIN,O.HERZBERG                                      
JRNL        TITL   FROM STRUCTURE TO FUNCTION: YRBI FROM HAEMOPHILUS            
JRNL        TITL 2 INFLUENZAE (HI1679) IS A PHOSPHATASE.                        
JRNL        REF    PROTEINS: STRUCT., FUNCT.,    V.  46   393 2002              
JRNL        REF  2 GENET.                                                       
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 1.67 ANGSTROMS.                                          
DBREF  1K1E A    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E B    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E C    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E D    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E E    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E F    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E G    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E H    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E I    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E J    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E K    1   180  UNP    P45314   KDOP_HAEIN       1    180             
DBREF  1K1E L    1   180  UNP    P45314   KDOP_HAEIN       1    180             
SEQRES   1 A  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 A  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 A  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 A  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 A  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 A  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 A  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 A  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 A  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 A  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 A  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 A  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 A  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 A  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 B  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 B  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 B  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 B  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 B  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 B  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 B  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 B  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 B  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 B  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 B  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 B  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 B  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 B  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 C  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 C  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 C  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 C  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 C  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 C  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 C  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 C  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 C  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 C  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 C  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 C  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 C  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 C  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 D  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 D  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 D  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 D  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 D  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 D  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 D  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 D  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 D  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 D  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 D  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 D  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 D  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 D  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 E  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 E  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 E  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 E  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 E  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 E  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 E  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 E  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 E  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 E  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 E  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 E  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 E  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 E  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 F  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 F  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 F  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 F  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 F  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 F  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 F  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 F  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 F  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 F  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 F  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 F  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 F  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 F  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 G  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 G  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 G  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 G  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 G  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 G  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 G  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 G  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 G  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 G  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 G  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 G  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 G  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 G  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 H  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 H  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 H  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 H  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 H  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 H  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 H  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 H  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 H  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 H  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 H  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 H  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 H  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 H  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 I  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 I  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 I  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 I  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 I  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 I  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 I  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 I  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 I  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 I  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 I  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 I  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 I  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 I  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 J  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 J  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 J  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 J  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 J  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 J  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 J  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 J  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 J  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 J  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 J  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 J  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 J  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 J  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 K  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 K  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 K  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 K  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 K  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 K  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 K  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 K  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 K  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 K  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 K  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 K  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 K  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 K  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
SEQRES   1 L  180  MET GLN GLN LYS LEU GLU ASN ILE LYS PHE VAL ILE THR          
SEQRES   2 L  180  ASP VAL ASP GLY VAL LEU THR ASP GLY GLN LEU HIS TYR          
SEQRES   3 L  180  ASP ALA ASN GLY GLU ALA ILE LYS SER PHE HIS VAL ARG          
SEQRES   4 L  180  ASP GLY LEU GLY ILE LYS MET LEU MET ASP ALA ASP ILE          
SEQRES   5 L  180  GLN VAL ALA VAL LEU SER GLY ARG ASP SER PRO ILE LEU          
SEQRES   6 L  180  ARG ARG ARG ILE ALA ASP LEU GLY ILE LYS LEU PHE PHE          
SEQRES   7 L  180  LEU GLY LYS LEU GLU LYS GLU THR ALA CYS PHE ASP LEU          
SEQRES   8 L  180  MET LYS GLN ALA GLY VAL THR ALA GLU GLN THR ALA TYR          
SEQRES   9 L  180  ILE GLY ASP ASP SER VAL ASP LEU PRO ALA PHE ALA ALA          
SEQRES  10 L  180  CYS GLY THR SER PHE ALA VAL ALA ASP ALA PRO ILE TYR          
SEQRES  11 L  180  VAL LYS ASN ALA VAL ASP HIS VAL LEU SER THR HIS GLY          
SEQRES  12 L  180  GLY LYS GLY ALA PHE ARG GLU MET SER ASP MET ILE LEU          
SEQRES  13 L  180  GLN ALA GLN GLY LYS SER SER VAL PHE ASP THR ALA GLN          
SEQRES  14 L  180  GLY PHE LEU LYS SER VAL LYS SER MET GLY GLN                  
HET     CO  A 201       1                                                       
HET     CO  B 202       1                                                       
HET     CO  C 203       1                                                       
HET     CO  D 204       1                                                       
HET     CO  E 205       1                                                       
HET     CO  F 206       1                                                       
HET     CO  G 207       1                                                       
HET     CO  H 208       1                                                       
HET     CO  I 209       1                                                       
HET     CO  J 210       1                                                       
HET     CO  K 211       1                                                       
HET     CO  L 212       1                                                       
HET     HG  A 301       1                                                       
HET     HG  B 302       1                                                       
HET     HG  C 303       1                                                       
HET     HG  D 304       1                                                       
HET     HG  E 305       1                                                       
HET     HG  F 306       1                                                       
HET     HG  G 307       1                                                       
HET     HG  H 308       1                                                       
HET     HG  I 309       1                                                       
HET     HG  J 310       1                                                       
HET     HG  K 311       1                                                       
HET     HG  L 312       1                                                       
HET    SO4   2401       5                                                       
HET    SO4   2402       5                                                       
HET    SO4   2403       5                                                       
HET    SO4   2404       5                                                       
HET    SO4   2405       5                                                       
HET    SO4   2406       5                                                       
HET    SO4   2407       5                                                       
HET    SO4   2408       5                                                       
HET    SO4   2409       5                                                       
HET    SO4   2410       5                                                       
HET    SO4   2411       5                                                       
HET    SO4   2412       5                                                       
HET    SO4   2413       5                                                       
HET    SO4   2414       5                                                       
HET    SO4   2415       5                                                       
HET    SO4   2416       5                                                       
HET    SO4   2417       5                                                       
HET    SO4   2418       5                                                       
HET    MES   2601      12                                                       
HET    MES   2602      12                                                       
HET    MES   2603      12                                                       
HET    GOL   2501       6                                                       
HET    GOL   2502       6                                                       
HET    GOL   2503       6                                                       
HET    GOL   2504       6                                                       
HET    GOL   2505       6                                                       
HET    GOL   2506       6                                                       
HETNAM      CO COBALT (II) ION                                                  
HETNAM      HG MERCURY (II) ION                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
HETNAM     GOL GLYCEROL                                                         
FORMUL  13   CO    12(CO 2+)                                                    
FORMUL  25   HG    12(HG 2+)                                                    
FORMUL  37  SO4    18(O4 S 2-)                                                  
FORMUL  55  MES    3(C6 H13 N O4 S)                                             
FORMUL  58  GOL    6(C3 H8 O3)                                                  
FORMUL  64  HOH   *1414(H2 O)                                                   
CRYST1  109.300  109.100  179.100  90.00 107.60  90.00 C 1 2 1      48          
ATOM   3993  N   LEU D   5      40.117   4.340  53.146  1.00 23.83           N  
ATOM   3994  CA  LEU D   5      40.087   5.821  52.833  1.00 20.23           C  
ATOM   3995  C   LEU D   5      38.870   6.190  52.008  1.00 18.48           C  
ATOM   3996  O   LEU D   5      38.318   7.247  52.150  1.00 17.31           O  
ATOM   3997  CB  LEU D   5      41.321   6.297  52.027  1.00 25.71           C  
ATOM   3998  CG  LEU D   5      42.645   6.289  52.736  1.00 24.76           C  
ATOM   3999  CD1 LEU D   5      43.727   7.099  52.010  1.00 23.52           C  
ATOM   4000  CD2 LEU D   5      42.382   6.897  54.080  1.00 22.24           C  
ATOM   4001  N   GLU D   6      38.439   5.281  51.142  1.00 22.95           N  
ATOM   4002  CA  GLU D   6      37.275   5.535  50.283  1.00 24.51           C  
ATOM   4003  C   GLU D   6      36.023   5.775  51.094  1.00 25.29           C  
ATOM   4004  O   GLU D   6      35.074   6.384  50.619  1.00 23.35           O  
ATOM   4005  CB  GLU D   6      37.056   4.310  49.369  1.00 32.01           C  
ATOM   4006  CG  GLU D   6      36.201   4.561  48.176  1.00 37.92           C  
ATOM   4007  CD  GLU D   6      36.393   3.477  47.126  1.00 42.43           C  
ATOM   4008  OE1 GLU D   6      36.556   2.268  47.524  1.00 36.75           O  
ATOM   4009  OE2 GLU D   6      36.376   3.858  45.909  1.00 44.97           O  
ATOM   4010  N   ASN D   7      35.991   5.259  52.310  1.00 21.74           N  
ATOM   4011  CA  ASN D   7      34.802   5.423  53.146  1.00 24.95           C  
ATOM   4012  C   ASN D   7      34.902   6.519  54.190  1.00 29.82           C  
ATOM   4013  O   ASN D   7      34.008   6.669  55.041  1.00 21.93           O  
ATOM   4014  CB  ASN D   7      34.469   4.112  53.843  1.00 28.41           C  
ATOM   4015  CG  ASN D   7      34.151   3.016  52.850  1.00 35.46           C  
ATOM   4016  OD1 ASN D   7      33.793   3.297  51.696  1.00 34.55           O  
ATOM   4017  ND2 ASN D   7      34.263   1.758  53.290  1.00 36.79           N  
ATOM   4018  N   ILE D   8      35.982   7.292  54.132  1.00 24.64           N  
ATOM   4019  CA  ILE D   8      36.096   8.352  55.111  1.00 17.87           C  
ATOM   4020  C   ILE D   8      35.039   9.398  54.854  1.00 14.89           C  
ATOM   4021  O   ILE D   8      34.890   9.901  53.732  1.00 17.21           O  
ATOM   4022  CB  ILE D   8      37.468   8.987  55.087  1.00 20.74           C  
ATOM   4023  CG1 ILE D   8      38.507   8.007  55.642  1.00 17.64           C  
ATOM   4024  CG2 ILE D   8      37.450  10.242  55.919  1.00 18.56           C  
ATOM   4025  CD1 ILE D   8      39.916   8.511  55.378  1.00 22.74           C  
ATOM   4026  N   LYS D   9      34.279   9.715  55.904  1.00 18.67           N  
ATOM   4027  CA  LYS D   9      33.262  10.745  55.790  1.00 17.13           C  
ATOM   4028  C   LYS D   9      33.533  11.919  56.769  1.00 15.41           C  
ATOM   4029  O   LYS D   9      32.796  12.897  56.753  1.00 15.21           O  
ATOM   4030  CB  LYS D   9      31.841  10.226  56.154  1.00 21.54           C  
ATOM   4031  CG  LYS D   9      31.275   9.075  55.324  1.00 24.74           C  
ATOM   4032  CD  LYS D   9      29.801   8.723  55.754  1.00 35.77           C  
ATOM   4033  CE  LYS D   9      28.707   9.623  55.065  1.00 35.20           C  
ATOM   4034  NZ  LYS D   9      27.198   9.302  55.268  1.00 31.72           N  
ATOM   4035  N   PHE D  10      34.511  11.776  57.656  1.00 18.62           N  
ATOM   4036  CA  PHE D  10      34.796  12.788  58.673  1.00 15.05           C  
ATOM   4037  C   PHE D  10      36.308  12.755  58.965  1.00  8.49           C  
ATOM   4038  O   PHE D  10      36.930  11.692  59.112  1.00 12.32           O  
ATOM   4039  CB  PHE D  10      33.983  12.414  59.932  1.00 14.19           C  
ATOM   4040  CG  PHE D  10      34.123  13.382  61.076  1.00 17.18           C  
ATOM   4041  CD1 PHE D  10      34.250  14.728  60.831  1.00 13.18           C  
ATOM   4042  CD2 PHE D  10      34.032  12.931  62.384  1.00 15.99           C  
ATOM   4043  CE1 PHE D  10      34.286  15.667  61.930  1.00 13.66           C  
ATOM   4044  CE2 PHE D  10      34.055  13.838  63.452  1.00 15.30           C  
ATOM   4045  CZ  PHE D  10      34.183  15.189  63.200  1.00 12.25           C  
ATOM   4046  N   VAL D  11      36.914  13.940  59.044  1.00 17.33           N  
ATOM   4047  CA  VAL D  11      38.325  14.039  59.305  1.00 18.00           C  
ATOM   4048  C   VAL D  11      38.459  15.012  60.474  1.00 12.98           C  
ATOM   4049  O   VAL D  11      37.896  16.083  60.433  1.00 15.40           O  
ATOM   4050  CB  VAL D  11      39.060  14.601  58.085  1.00 20.81           C  
ATOM   4051  CG1 VAL D  11      40.544  14.962  58.458  1.00 10.51           C  
ATOM   4052  CG2 VAL D  11      39.026  13.588  56.979  1.00 18.82           C  
ATOM   4053  N   ILE D  12      39.178  14.570  61.494  1.00 14.67           N  
ATOM   4054  CA  ILE D  12      39.483  15.330  62.696  1.00 11.65           C  
ATOM   4055  C   ILE D  12      40.986  15.605  62.692  1.00 14.21           C  
ATOM   4056  O   ILE D  12      41.821  14.697  62.542  1.00 11.17           O  
ATOM   4057  CB  ILE D  12      39.164  14.501  63.957  1.00 16.71           C  
ATOM   4058  CG1 ILE D  12      37.677  14.101  63.916  1.00 16.45           C  
ATOM   4059  CG2 ILE D  12      39.548  15.278  65.214  1.00 11.66           C  
ATOM   4060  CD1 ILE D  12      37.240  13.059  64.997  1.00 20.38           C  
ATOM   4061  N   THR D  13      41.340  16.874  62.840  1.00 12.99           N  
ATOM   4062  CA  THR D  13      42.742  17.208  62.853  1.00 10.21           C  
ATOM   4063  C   THR D  13      43.177  17.954  64.106  1.00  9.22           C  
ATOM   4064  O   THR D  13      42.475  18.865  64.595  1.00 12.94           O  
ATOM   4065  CB  THR D  13      43.120  18.064  61.644  1.00 13.41           C  
ATOM   4066  OG1 THR D  13      44.518  18.396  61.690  1.00 13.43           O  
ATOM   4067  CG2 THR D  13      42.352  19.403  61.704  1.00 12.16           C  
ATOM   4068  N   ASP D  14      44.284  17.492  64.646  1.00 12.07           N  
ATOM   4069  CA  ASP D  14      44.950  18.177  65.744  1.00 12.21           C  
ATOM   4070  C   ASP D  14      45.400  19.503  65.110  1.00 13.89           C  
ATOM   4071  O   ASP D  14      45.453  19.656  63.875  1.00 13.50           O  
ATOM   4072  CB  ASP D  14      46.161  17.368  66.175  1.00  8.96           C  
ATOM   4073  CG  ASP D  14      47.045  18.089  67.216  1.00 16.82           C  
ATOM   4074  OD1 ASP D  14      46.538  18.690  68.166  1.00 14.72           O  
ATOM   4075  OD2 ASP D  14      48.247  17.955  67.073  1.00 11.59           O  
ATOM   4076  N   VAL D  15      45.741  20.458  65.962  1.00 10.35           N  
ATOM   4077  CA  VAL D  15      46.153  21.753  65.463  1.00  7.80           C  
ATOM   4078  C   VAL D  15      47.663  21.890  65.590  1.00 10.81           C  
ATOM   4079  O   VAL D  15      48.371  22.030  64.589  1.00 12.84           O  
ATOM   4080  CB  VAL D  15      45.495  22.945  66.262  1.00  6.93           C  
ATOM   4081  CG1 VAL D  15      46.077  24.286  65.815  1.00 14.77           C  
ATOM   4082  CG2 VAL D  15      44.002  22.958  65.998  1.00 13.95           C  
ATOM   4083  N   ASP D  16      48.189  21.904  66.815  1.00 12.44           N  
ATOM   4084  CA  ASP D  16      49.623  22.145  66.934  1.00 12.98           C  
ATOM   4085  C   ASP D  16      50.514  21.005  66.473  1.00 13.18           C  
ATOM   4086  O   ASP D  16      50.343  19.858  66.915  1.00 16.84           O  
ATOM   4087  CB  ASP D  16      49.932  22.586  68.354  1.00 13.35           C  
ATOM   4088  CG  ASP D  16      49.156  23.856  68.705  1.00 18.12           C  
ATOM   4089  OD1 ASP D  16      49.387  24.892  68.059  1.00 14.26           O  
ATOM   4090  OD2 ASP D  16      48.310  23.775  69.622  1.00 15.23           O  
ATOM   4091  N   GLY D  17      51.439  21.346  65.559  1.00 10.90           N  
ATOM   4092  CA  GLY D  17      52.314  20.364  64.935  1.00 10.66           C  
ATOM   4093  C   GLY D  17      51.662  19.669  63.750  1.00 13.12           C  
ATOM   4094  O   GLY D  17      52.321  18.836  63.070  1.00 13.55           O  
ATOM   4095  N   VAL D  18      50.383  19.953  63.512  1.00 12.26           N  
ATOM   4096  CA  VAL D  18      49.716  19.357  62.335  1.00 12.51           C  
ATOM   4097  C   VAL D  18      49.350  20.489  61.359  1.00 10.85           C  
ATOM   4098  O   VAL D  18      49.901  20.551  60.244  1.00 13.82           O  
ATOM   4099  CB  VAL D  18      48.522  18.561  62.725  1.00 15.40           C  
ATOM   4100  CG1 VAL D  18      47.824  18.040  61.399  1.00  9.34           C  
ATOM   4101  CG2 VAL D  18      48.997  17.367  63.601  1.00 15.43           C  
ATOM   4102  N   LEU D  19      48.453  21.385  61.766  1.00  7.53           N  
ATOM   4103  CA  LEU D  19      48.089  22.565  60.967  1.00  9.17           C  
ATOM   4104  C   LEU D  19      49.183  23.655  61.143  1.00 11.59           C  
ATOM   4105  O   LEU D  19      49.174  24.634  60.429  1.00 14.72           O  
ATOM   4106  CB  LEU D  19      46.728  23.092  61.438  1.00 12.00           C  
ATOM   4107  CG  LEU D  19      45.561  22.152  61.183  1.00 11.64           C  
ATOM   4108  CD1 LEU D  19      44.214  22.864  61.523  1.00 12.34           C  
ATOM   4109  CD2 LEU D  19      45.636  21.766  59.688  1.00 16.74           C  
ATOM   4110  N   THR D  20      50.054  23.498  62.159  1.00 16.46           N  
ATOM   4111  CA  THR D  20      51.202  24.421  62.370  1.00 10.58           C  
ATOM   4112  C   THR D  20      52.464  23.561  62.444  1.00 13.77           C  
ATOM   4113  O   THR D  20      52.409  22.307  62.627  1.00 13.19           O  
ATOM   4114  CB  THR D  20      51.148  25.157  63.675  1.00 11.83           C  
ATOM   4115  OG1 THR D  20      51.568  24.266  64.696  1.00 13.00           O  
ATOM   4116  CG2 THR D  20      49.764  25.612  63.993  1.00 12.45           C  
ATOM   4117  N   ASP D  21      53.632  24.214  62.378  1.00  9.87           N  
ATOM   4118  CA  ASP D  21      54.839  23.446  62.504  1.00 10.95           C  
ATOM   4119  C   ASP D  21      55.198  23.174  63.949  1.00 14.38           C  
ATOM   4120  O   ASP D  21      56.320  22.730  64.236  1.00 13.32           O  
ATOM   4121  CB  ASP D  21      56.016  24.116  61.810  1.00 14.96           C  
ATOM   4122  CG  ASP D  21      56.420  25.425  62.446  1.00 20.31           C  
ATOM   4123  OD1 ASP D  21      55.778  25.890  63.406  1.00 14.82           O  
ATOM   4124  OD2 ASP D  21      57.427  25.991  61.950  1.00 20.04           O  
ATOM   4125  N   GLY D  22      54.242  23.409  64.836  1.00 13.62           N  
ATOM   4126  CA  GLY D  22      54.485  23.103  66.254  1.00  9.41           C  
ATOM   4127  C   GLY D  22      55.013  24.305  67.030  1.00 18.83           C  
ATOM   4128  O   GLY D  22      55.131  24.244  68.278  1.00 12.67           O  
ATOM   4129  N   GLN D  23      55.298  25.383  66.325  1.00 11.49           N  
ATOM   4130  CA  GLN D  23      55.793  26.575  67.050  1.00 14.78           C  
ATOM   4131  C   GLN D  23      54.614  27.280  67.729  1.00  9.59           C  
ATOM   4132  O   GLN D  23      53.478  27.305  67.218  1.00 10.85           O  
ATOM   4133  CB  GLN D  23      56.503  27.548  66.088  1.00 12.80           C  
ATOM   4134  CG  GLN D  23      57.880  27.128  65.644  1.00 11.82           C  
ATOM   4135  CD  GLN D  23      58.518  28.193  64.817  1.00 24.01           C  
ATOM   4136  OE1 GLN D  23      59.141  29.108  65.358  1.00 21.35           O  
ATOM   4137  NE2 GLN D  23      58.382  28.101  63.486  1.00 16.07           N  
ATOM   4138  N   LEU D  24      54.889  27.831  68.928  1.00 10.07           N  
ATOM   4139  CA  LEU D  24      53.898  28.562  69.763  1.00 13.50           C  
ATOM   4140  C   LEU D  24      54.595  29.928  69.917  1.00 12.85           C  
ATOM   4141  O   LEU D  24      55.672  30.050  70.553  1.00 10.82           O  
ATOM   4142  CB  LEU D  24      53.716  27.895  71.122  1.00 11.51           C  
ATOM   4143  CG  LEU D  24      53.075  26.462  71.059  1.00 12.95           C  
ATOM   4144  CD1 LEU D  24      52.931  25.820  72.475  1.00 18.15           C  
ATOM   4145  CD2 LEU D  24      51.714  26.581  70.437  1.00 14.26           C  
ATOM   4146  N   HIS D  25      53.993  30.898  69.213  1.00 13.61           N  
ATOM   4147  CA  HIS D  25      54.492  32.267  69.130  1.00  9.07           C  
ATOM   4148  C   HIS D  25      53.855  33.055  70.238  1.00 13.55           C  
ATOM   4149  O   HIS D  25      52.683  33.399  70.155  1.00 14.66           O  
ATOM   4150  CB  HIS D  25      54.065  32.888  67.765  1.00 11.46           C  
ATOM   4151  CG  HIS D  25      54.600  32.141  66.598  1.00 14.67           C  
ATOM   4152  ND1 HIS D  25      55.921  31.797  66.500  1.00 13.59           N  
ATOM   4153  CD2 HIS D  25      53.994  31.644  65.490  1.00 22.04           C  
ATOM   4154  CE1 HIS D  25      56.121  31.122  65.385  1.00 18.04           C  
ATOM   4155  NE2 HIS D  25      54.964  31.017  64.750  1.00 19.20           N  
ATOM   4156  N   TYR D  26      54.632  33.305  71.286  1.00 10.00           N  
ATOM   4157  CA  TYR D  26      54.131  34.024  72.507  1.00  8.49           C  
ATOM   4158  C   TYR D  26      54.487  35.463  72.618  1.00  9.23           C  
ATOM   4159  O   TYR D  26      55.567  35.843  72.154  1.00 13.07           O  
ATOM   4160  CB  TYR D  26      54.830  33.442  73.734  1.00 12.78           C  
ATOM   4161  CG  TYR D  26      54.256  32.227  74.393  1.00 12.60           C  
ATOM   4162  CD1 TYR D  26      54.146  30.991  73.714  1.00 14.27           C  
ATOM   4163  CD2 TYR D  26      53.778  32.326  75.701  1.00 13.73           C  
ATOM   4164  CE1 TYR D  26      53.535  29.902  74.363  1.00 12.76           C  
ATOM   4165  CE2 TYR D  26      53.207  31.269  76.357  1.00 13.14           C  
ATOM   4166  CZ  TYR D  26      53.079  30.061  75.665  1.00 16.28           C  
ATOM   4167  OH  TYR D  26      52.421  29.063  76.264  1.00 14.10           O  
ATOM   4168  N   ASP D  27      53.588  36.259  73.218  1.00  9.38           N  
ATOM   4169  CA  ASP D  27      54.004  37.580  73.631  1.00  9.72           C  
ATOM   4170  C   ASP D  27      53.854  37.494  75.161  1.00 15.31           C  
ATOM   4171  O   ASP D  27      53.835  36.374  75.720  1.00 12.73           O  
ATOM   4172  CB  ASP D  27      53.215  38.725  72.973  1.00 12.66           C  
ATOM   4173  CG  ASP D  27      51.764  38.738  73.277  1.00 12.21           C  
ATOM   4174  OD1 ASP D  27      51.102  39.610  72.646  1.00 14.21           O  
ATOM   4175  OD2 ASP D  27      51.256  37.930  74.087  1.00 13.74           O  
ATOM   4176  N   ALA D  28      53.803  38.613  75.858  1.00 14.31           N  
ATOM   4177  CA  ALA D  28      53.720  38.499  77.351  1.00 17.29           C  
ATOM   4178  C   ALA D  28      52.418  37.945  77.872  1.00 17.97           C  
ATOM   4179  O   ALA D  28      52.270  37.651  79.061  1.00 16.45           O  
ATOM   4180  CB  ALA D  28      53.908  39.874  77.971  1.00 19.10           C  
ATOM   4181  N   ASN D  29      51.440  37.931  76.984  1.00 12.32           N  
ATOM   4182  CA  ASN D  29      50.074  37.502  77.301  1.00 17.36           C  
ATOM   4183  C   ASN D  29      49.666  36.104  76.855  1.00 18.93           C  
ATOM   4184  O   ASN D  29      48.493  35.703  77.048  1.00 19.60           O  
ATOM   4185  CB  ASN D  29      49.095  38.556  76.737  1.00 17.24           C  
ATOM   4186  CG  ASN D  29      49.230  39.871  77.455  1.00 22.37           C  
ATOM   4187  OD1 ASN D  29      49.305  40.952  76.844  1.00 28.30           O  
ATOM   4188  ND2 ASN D  29      49.265  39.796  78.797  1.00 27.30           N  
ATOM   4189  N   GLY D  30      50.606  35.371  76.256  1.00 12.17           N  
ATOM   4190  CA  GLY D  30      50.272  34.030  75.841  1.00 11.89           C  
ATOM   4191  C   GLY D  30      50.478  33.926  74.352  1.00 18.07           C  
ATOM   4192  O   GLY D  30      51.249  34.683  73.779  1.00 12.79           O  
ATOM   4193  N   GLU D  31      49.798  33.011  73.703  1.00 10.56           N  
ATOM   4194  CA  GLU D  31      50.033  32.970  72.239  1.00 16.07           C  
ATOM   4195  C   GLU D  31      49.633  34.290  71.586  1.00 15.23           C  
ATOM   4196  O   GLU D  31      48.574  34.844  71.871  1.00 16.02           O  
ATOM   4197  CB  GLU D  31      49.232  31.858  71.570  1.00 17.14           C  
ATOM   4198  CG  GLU D  31      49.521  30.510  72.026  1.00 17.36           C  
ATOM   4199  CD  GLU D  31      48.747  29.539  71.195  1.00 17.90           C  
ATOM   4200  OE1 GLU D  31      49.183  29.247  70.072  1.00 15.38           O  
ATOM   4201  OE2 GLU D  31      47.682  29.086  71.626  1.00 23.08           O  
ATOM   4202  N   ALA D  32      50.446  34.750  70.646  1.00 12.14           N  
ATOM   4203  CA  ALA D  32      50.209  36.025  70.018  1.00 10.79           C  
ATOM   4204  C   ALA D  32      49.923  35.924  68.525  1.00 13.92           C  
ATOM   4205  O   ALA D  32      49.238  36.766  67.947  1.00 13.98           O  
ATOM   4206  CB  ALA D  32      51.442  36.931  70.286  1.00 10.68           C  
ATOM   4207  N   ILE D  33      50.433  34.838  67.964  1.00 15.21           N  
ATOM   4208  CA  ILE D  33      50.312  34.549  66.557  1.00 14.46           C  
ATOM   4209  C   ILE D  33      50.241  33.046  66.433  1.00 11.28           C  
ATOM   4210  O   ILE D  33      50.876  32.336  67.227  1.00 13.23           O  
ATOM   4211  CB  ILE D  33      51.585  35.025  65.815  1.00 11.35           C  
ATOM   4212  CG1 ILE D  33      51.623  36.539  65.747  1.00 18.72           C  
ATOM   4213  CG2 ILE D  33      51.605  34.560  64.305  1.00 11.10           C  
ATOM   4214  CD1 ILE D  33      52.860  36.999  65.113  1.00 30.80           C  
ATOM   4215  N   LYS D  34      49.477  32.551  65.457  1.00 15.00           N  
ATOM   4216  CA  LYS D  34      49.458  31.117  65.160  1.00 15.33           C  
ATOM   4217  C   LYS D  34      49.645  31.126  63.626  1.00 10.72           C  
ATOM   4218  O   LYS D  34      49.020  31.913  62.933  1.00 12.01           O  
ATOM   4219  CB  LYS D  34      48.126  30.460  65.544  1.00  9.11           C  
ATOM   4220  CG  LYS D  34      47.968  30.366  67.068  1.00 12.98           C  
ATOM   4221  CD  LYS D  34      46.794  29.453  67.464  1.00 13.84           C  
ATOM   4222  CE  LYS D  34      47.130  27.970  67.149  1.00 14.86           C  
ATOM   4223  NZ  LYS D  34      48.304  27.548  67.985  1.00 20.14           N  
ATOM   4224  N   SER D  35      50.491  30.223  63.131  1.00  9.29           N  
ATOM   4225  CA  SER D  35      50.806  30.160  61.726  1.00 12.62           C  
ATOM   4226  C   SER D  35      50.205  28.936  61.071  1.00 16.61           C  
ATOM   4227  O   SER D  35      50.589  27.819  61.415  1.00 12.62           O  
ATOM   4228  CB  SER D  35      52.313  30.111  61.588  1.00 19.57           C  
ATOM   4229  OG  SER D  35      52.857  31.261  62.231  1.00 17.34           O  
ATOM   4230  N   PHE D  36      49.351  29.165  60.083  1.00 13.87           N  
ATOM   4231  CA  PHE D  36      48.665  28.052  59.423  1.00 10.43           C  
ATOM   4232  C   PHE D  36      49.254  27.936  58.019  1.00 15.11           C  
ATOM   4233  O   PHE D  36      50.173  28.668  57.687  1.00 19.52           O  
ATOM   4234  CB  PHE D  36      47.170  28.354  59.417  1.00 11.50           C  
ATOM   4235  CG  PHE D  36      46.570  28.374  60.820  1.00 13.94           C  
ATOM   4236  CD1 PHE D  36      46.404  29.590  61.504  1.00 17.87           C  
ATOM   4237  CD2 PHE D  36      46.277  27.204  61.469  1.00 15.63           C  
ATOM   4238  CE1 PHE D  36      45.965  29.617  62.808  1.00  9.75           C  
ATOM   4239  CE2 PHE D  36      45.833  27.209  62.804  1.00 14.55           C  
ATOM   4240  CZ  PHE D  36      45.682  28.414  63.473  1.00 16.69           C  
ATOM   4241  N   HIS D  37      48.780  27.013  57.216  1.00 12.69           N  
ATOM   4242  CA  HIS D  37      49.351  26.888  55.891  1.00 11.76           C  
ATOM   4243  C   HIS D  37      48.219  27.052  54.875  1.00  8.96           C  
ATOM   4244  O   HIS D  37      47.163  26.428  54.969  1.00 15.18           O  
ATOM   4245  CB  HIS D  37      50.020  25.502  55.731  1.00 10.71           C  
ATOM   4246  CG  HIS D  37      50.938  25.444  54.555  1.00 16.68           C  
ATOM   4247  ND1 HIS D  37      52.307  25.551  54.671  1.00 19.02           N  
ATOM   4248  CD2 HIS D  37      50.670  25.406  53.226  1.00  9.12           C  
ATOM   4249  CE1 HIS D  37      52.844  25.594  53.457  1.00 16.08           C  
ATOM   4250  NE2 HIS D  37      51.875  25.511  52.568  1.00 20.55           N  
ATOM   4251  N   VAL D  38      48.488  27.849  53.846  1.00 13.51           N  
ATOM   4252  CA  VAL D  38      47.478  28.121  52.873  1.00 13.66           C  
ATOM   4253  C   VAL D  38      47.009  26.895  52.118  1.00 17.17           C  
ATOM   4254  O   VAL D  38      45.809  26.780  51.799  1.00 13.72           O  
ATOM   4255  CB  VAL D  38      47.951  29.210  51.874  1.00 15.78           C  
ATOM   4256  CG1 VAL D  38      49.178  28.738  51.069  1.00 12.62           C  
ATOM   4257  CG2 VAL D  38      46.802  29.593  50.998  1.00 19.26           C  
ATOM   4258  N   ARG D  39      47.937  25.970  51.829  1.00 13.12           N  
ATOM   4259  CA  ARG D  39      47.530  24.808  51.038  1.00 14.95           C  
ATOM   4260  C   ARG D  39      46.669  23.850  51.867  1.00 14.88           C  
ATOM   4261  O   ARG D  39      45.783  23.125  51.327  1.00 13.69           O  
ATOM   4262  CB  ARG D  39      48.757  24.140  50.323  1.00 10.27           C  
ATOM   4263  CG  ARG D  39      49.356  25.123  49.213  1.00 17.56           C  
ATOM   4264  CD  ARG D  39      50.338  24.449  48.252  1.00 12.52           C  
ATOM   4265  NE  ARG D  39      51.446  23.893  48.975  1.00 10.17           N  
ATOM   4266  CZ  ARG D  39      52.586  24.587  49.157  1.00 12.58           C  
ATOM   4267  NH1 ARG D  39      52.710  25.833  48.672  1.00 14.73           N  
ATOM   4268  NH2 ARG D  39      53.600  24.019  49.788  1.00 17.40           N  
ATOM   4269  N   ASP D  40      46.861  23.859  53.196  1.00 12.15           N  
ATOM   4270  CA  ASP D  40      45.990  23.071  54.025  1.00 12.00           C  
ATOM   4271  C   ASP D  40      44.590  23.692  54.016  1.00 11.81           C  
ATOM   4272  O   ASP D  40      43.576  22.959  54.066  1.00 14.13           O  
ATOM   4273  CB  ASP D  40      46.432  23.107  55.491  1.00 15.03           C  
ATOM   4274  CG  ASP D  40      47.683  22.322  55.767  1.00 19.92           C  
ATOM   4275  OD1 ASP D  40      48.007  21.372  55.015  1.00 14.98           O  
ATOM   4276  OD2 ASP D  40      48.336  22.654  56.813  1.00 16.87           O  
ATOM   4277  N   GLY D  41      44.500  25.018  54.017  1.00 11.89           N  
ATOM   4278  CA  GLY D  41      43.159  25.616  54.030  1.00 11.65           C  
ATOM   4279  C   GLY D  41      42.374  25.199  52.789  1.00 17.39           C  
ATOM   4280  O   GLY D  41      41.167  24.970  52.863  1.00 15.48           O  
ATOM   4281  N   LEU D  42      43.046  25.110  51.635  1.00 18.40           N  
ATOM   4282  CA  LEU D  42      42.330  24.744  50.413  1.00 13.98           C  
ATOM   4283  C   LEU D  42      41.917  23.292  50.537  1.00 11.96           C  
ATOM   4284  O   LEU D  42      40.792  22.923  50.176  1.00 16.61           O  
ATOM   4285  CB  LEU D  42      43.215  24.937  49.188  1.00 15.33           C  
ATOM   4286  CG  LEU D  42      42.507  24.679  47.841  1.00 17.49           C  
ATOM   4287  CD1 LEU D  42      41.295  25.573  47.693  1.00 18.48           C  
ATOM   4288  CD2 LEU D  42      43.463  24.973  46.665  1.00 19.00           C  
ATOM   4289  N   GLY D  43      42.818  22.470  51.068  1.00 18.06           N  
ATOM   4290  CA  GLY D  43      42.506  21.059  51.260  1.00 15.42           C  
ATOM   4291  C   GLY D  43      41.284  20.912  52.170  1.00 14.14           C  
ATOM   4292  O   GLY D  43      40.429  20.044  51.989  1.00 12.38           O  
ATOM   4293  N   ILE D  44      41.176  21.792  53.141  1.00 11.89           N  
ATOM   4294  CA  ILE D  44      40.021  21.686  54.076  1.00 13.73           C  
ATOM   4295  C   ILE D  44      38.758  21.995  53.338  1.00 16.31           C  
ATOM   4296  O   ILE D  44      37.742  21.281  53.436  1.00 18.20           O  
ATOM   4297  CB  ILE D  44      40.225  22.634  55.267  1.00 12.27           C  
ATOM   4298  CG1 ILE D  44      41.209  21.982  56.230  1.00 10.01           C  
ATOM   4299  CG2 ILE D  44      38.887  22.893  55.967  1.00 14.59           C  
ATOM   4300  CD1 ILE D  44      41.711  22.925  57.281  1.00 16.53           C  
ATOM   4301  N   LYS D  45      38.815  23.030  52.530  1.00 13.82           N  
ATOM   4302  CA  LYS D  45      37.650  23.395  51.747  1.00 16.40           C  
ATOM   4303  C   LYS D  45      37.312  22.292  50.742  1.00 18.44           C  
ATOM   4304  O   LYS D  45      36.121  22.024  50.531  1.00 17.70           O  
ATOM   4305  CB  LYS D  45      37.901  24.717  51.033  1.00 26.08           C  
ATOM   4306  CG  LYS D  45      38.097  25.897  52.014  1.00 29.62           C  
ATOM   4307  CD  LYS D  45      36.886  26.169  52.952  1.00 32.33           C  
ATOM   4308  CE  LYS D  45      35.604  26.529  52.172  1.00 32.92           C  
ATOM   4309  NZ  LYS D  45      34.493  26.874  53.112  1.00 41.80           N  
ATOM   4310  N   MET D  46      38.322  21.658  50.123  1.00 13.46           N  
ATOM   4311  CA  MET D  46      38.015  20.589  49.166  1.00 10.44           C  
ATOM   4312  C   MET D  46      37.271  19.462  49.840  1.00 17.27           C  
ATOM   4313  O   MET D  46      36.363  18.877  49.277  1.00 14.43           O  
ATOM   4314  CB  MET D  46      39.317  20.066  48.546  1.00 18.17           C  
ATOM   4315  CG  MET D  46      39.927  21.105  47.568  1.00 23.62           C  
ATOM   4316  SD  MET D  46      41.602  20.704  47.030  1.00 18.53           S  
ATOM   4317  CE  MET D  46      41.744  21.811  45.677  1.00 14.08           C  
ATOM   4318  N   LEU D  47      37.701  19.086  51.037  1.00 15.04           N  
ATOM   4319  CA  LEU D  47      37.036  18.023  51.719  1.00 15.06           C  
ATOM   4320  C   LEU D  47      35.557  18.393  51.928  1.00 17.68           C  
ATOM   4321  O   LEU D  47      34.647  17.596  51.623  1.00 16.44           O  
ATOM   4322  CB  LEU D  47      37.701  17.793  53.098  1.00 17.49           C  
ATOM   4323  CG  LEU D  47      39.093  17.148  53.071  1.00 16.63           C  
ATOM   4324  CD1 LEU D  47      39.626  17.051  54.459  1.00 16.34           C  
ATOM   4325  CD2 LEU D  47      38.990  15.686  52.459  1.00 14.15           C  
ATOM   4326  N   MET D  48      35.322  19.585  52.475  1.00 14.08           N  
ATOM   4327  CA  MET D  48      33.952  20.036  52.735  1.00 21.33           C  
ATOM   4328  C   MET D  48      33.103  20.080  51.480  1.00 21.92           C  
ATOM   4329  O   MET D  48      31.890  19.713  51.501  1.00 18.74           O  
ATOM   4330  CB  MET D  48      33.978  21.394  53.440  1.00 15.59           C  
ATOM   4331  CG  MET D  48      34.592  21.197  54.782  1.00 19.15           C  
ATOM   4332  SD  MET D  48      34.514  22.586  55.902  1.00 30.20           S  
ATOM   4333  CE  MET D  48      34.715  23.922  54.845  1.00 30.26           C  
ATOM   4334  N   ASP D  49      33.709  20.529  50.399  1.00 20.43           N  
ATOM   4335  CA  ASP D  49      33.000  20.580  49.118  1.00 23.33           C  
ATOM   4336  C   ASP D  49      32.643  19.158  48.734  1.00 23.92           C  
ATOM   4337  O   ASP D  49      31.664  18.966  48.000  1.00 27.02           O  
ATOM   4338  CB  ASP D  49      33.876  21.055  47.953  1.00 21.93           C  
ATOM   4339  CG  ASP D  49      34.160  22.552  47.955  1.00 36.65           C  
ATOM   4340  OD1 ASP D  49      33.378  23.341  48.557  1.00 35.21           O  
ATOM   4341  OD2 ASP D  49      35.178  22.939  47.316  1.00 34.51           O  
ATOM   4342  N   ALA D  50      33.488  18.188  49.120  1.00 16.86           N  
ATOM   4343  CA  ALA D  50      33.219  16.804  48.762  1.00 19.65           C  
ATOM   4344  C   ALA D  50      32.385  16.103  49.834  1.00 22.07           C  
ATOM   4345  O   ALA D  50      32.398  14.877  49.918  1.00 18.92           O  
ATOM   4346  CB  ALA D  50      34.503  16.032  48.512  1.00 20.02           C  
ATOM   4347  N   ASP D  51      31.677  16.902  50.625  1.00 20.00           N  
ATOM   4348  CA  ASP D  51      30.808  16.421  51.686  1.00 23.25           C  
ATOM   4349  C   ASP D  51      31.491  15.569  52.710  1.00 23.72           C  
ATOM   4350  O   ASP D  51      30.897  14.649  53.211  1.00 22.10           O  
ATOM   4351  CB  ASP D  51      29.640  15.630  51.089  1.00 27.08           C  
ATOM   4352  CG  ASP D  51      28.805  16.480  50.168  1.00 24.43           C  
ATOM   4353  OD1 ASP D  51      28.421  15.963  49.110  1.00 31.44           O  
ATOM   4354  OD2 ASP D  51      28.538  17.665  50.509  1.00 28.08           O  
ATOM   4355  N   ILE D  52      32.749  15.876  53.017  1.00 19.96           N  
ATOM   4356  CA  ILE D  52      33.480  15.164  54.009  1.00 18.63           C  
ATOM   4357  C   ILE D  52      33.542  16.195  55.111  1.00 21.13           C  
ATOM   4358  O   ILE D  52      34.065  17.280  54.912  1.00 21.69           O  
ATOM   4359  CB  ILE D  52      34.890  14.827  53.520  1.00 22.74           C  
ATOM   4360  CG1 ILE D  52      34.780  13.797  52.361  1.00 23.14           C  
ATOM   4361  CG2 ILE D  52      35.708  14.335  54.684  1.00 20.84           C  
ATOM   4362  CD1 ILE D  52      36.089  13.237  51.869  1.00 15.76           C  
ATOM   4363  N   GLN D  53      33.039  15.863  56.293  1.00 14.90           N  
ATOM   4364  CA  GLN D  53      33.039  16.866  57.348  1.00 16.73           C  
ATOM   4365  C   GLN D  53      34.429  16.991  57.911  1.00 14.92           C  
ATOM   4366  O   GLN D  53      35.188  15.999  57.897  1.00 14.49           O  
ATOM   4367  CB  GLN D  53      32.058  16.459  58.441  1.00 11.00           C  
ATOM   4368  CG  GLN D  53      30.646  16.346  57.925  1.00 24.72           C  
ATOM   4369  CD  GLN D  53      29.695  15.971  59.014  1.00 20.76           C  
ATOM   4370  OE1 GLN D  53      29.391  16.791  59.882  1.00 21.90           O  
ATOM   4371  NE2 GLN D  53      29.225  14.729  58.994  1.00 22.02           N  
ATOM   4372  N   VAL D  54      34.737  18.176  58.448  1.00 17.72           N  
ATOM   4373  CA  VAL D  54      36.058  18.448  59.030  1.00 21.77           C  
ATOM   4374  C   VAL D  54      35.910  19.019  60.428  1.00 16.01           C  
ATOM   4375  O   VAL D  54      35.114  19.907  60.660  1.00 15.59           O  
ATOM   4376  CB  VAL D  54      36.818  19.460  58.151  1.00 21.05           C  
ATOM   4377  CG1 VAL D  54      38.222  19.855  58.755  1.00 13.22           C  
ATOM   4378  CG2 VAL D  54      36.945  18.868  56.792  1.00 17.23           C  
ATOM   4379  N   ALA D  55      36.712  18.521  61.352  1.00 10.91           N  
ATOM   4380  CA  ALA D  55      36.691  19.048  62.724  1.00 14.07           C  
ATOM   4381  C   ALA D  55      38.124  19.311  63.181  1.00 14.93           C  
ATOM   4382  O   ALA D  55      39.098  18.704  62.698  1.00 14.27           O  
ATOM   4383  CB  ALA D  55      36.065  17.993  63.674  1.00 14.81           C  
ATOM   4384  N   VAL D  56      38.266  20.221  64.129  1.00 13.91           N  
ATOM   4385  CA  VAL D  56      39.554  20.465  64.707  1.00 15.57           C  
ATOM   4386  C   VAL D  56      39.502  20.081  66.154  1.00 22.18           C  
ATOM   4387  O   VAL D  56      38.532  20.373  66.822  1.00 17.85           O  
ATOM   4388  CB  VAL D  56      39.861  21.934  64.613  1.00 24.28           C  
ATOM   4389  CG1 VAL D  56      40.955  22.315  65.574  1.00 20.75           C  
ATOM   4390  CG2 VAL D  56      40.209  22.239  63.145  1.00 20.07           C  
ATOM   4391  N   LEU D  57      40.576  19.476  66.633  1.00 18.94           N  
ATOM   4392  CA  LEU D  57      40.672  19.064  68.016  1.00 21.31           C  
ATOM   4393  C   LEU D  57      41.929  19.762  68.577  1.00 22.19           C  
ATOM   4394  O   LEU D  57      43.027  19.641  68.041  1.00 22.23           O  
ATOM   4395  CB  LEU D  57      40.855  17.531  68.067  1.00 25.38           C  
ATOM   4396  CG  LEU D  57      40.023  16.749  69.063  1.00 26.96           C  
ATOM   4397  CD1 LEU D  57      40.702  15.364  69.450  1.00 22.96           C  
ATOM   4398  CD2 LEU D  57      39.809  17.615  70.310  1.00 24.82           C  
ATOM   4399  N   SER D  58      41.800  20.506  69.654  1.00 20.72           N  
ATOM   4400  CA  SER D  58      42.985  21.117  70.214  1.00 19.66           C  
ATOM   4401  C   SER D  58      42.813  21.279  71.711  1.00 25.84           C  
ATOM   4402  O   SER D  58      41.717  21.563  72.179  1.00 21.63           O  
ATOM   4403  CB  SER D  58      43.261  22.506  69.621  1.00 20.87           C  
ATOM   4404  OG  SER D  58      44.292  23.111  70.380  1.00 22.07           O  
ATOM   4405  N   GLY D  59      43.901  21.085  72.441  1.00 26.37           N  
ATOM   4406  CA  GLY D  59      43.852  21.276  73.864  1.00 25.11           C  
ATOM   4407  C   GLY D  59      44.195  22.711  74.252  1.00 20.91           C  
ATOM   4408  O   GLY D  59      44.280  22.992  75.420  1.00 20.53           O  
ATOM   4409  N   ARG D  60      44.432  23.594  73.279  1.00 27.02           N  
ATOM   4410  CA  ARG D  60      44.756  24.988  73.537  1.00 26.37           C  
ATOM   4411  C   ARG D  60      43.628  25.768  72.913  1.00 29.08           C  
ATOM   4412  O   ARG D  60      43.374  25.630  71.735  1.00 38.99           O  
ATOM   4413  CB  ARG D  60      46.029  25.430  72.818  1.00 24.98           C  
ATOM   4414  CG  ARG D  60      47.282  25.185  73.500  1.00 26.80           C  
ATOM   4415  CD  ARG D  60      48.485  25.326  72.554  1.00 31.06           C  
ATOM   4416  NE  ARG D  60      49.358  24.201  72.849  1.00 36.88           N  
ATOM   4417  CZ  ARG D  60      49.091  22.950  72.466  1.00 29.41           C  
ATOM   4418  NH1 ARG D  60      48.027  22.678  71.746  1.00 37.55           N  
ATOM   4419  NH2 ARG D  60      49.792  21.948  72.956  1.00 39.20           N  
ATOM   4420  N   ASP D  61      42.931  26.582  73.671  1.00 28.58           N  
ATOM   4421  CA  ASP D  61      41.870  27.351  73.059  1.00 28.66           C  
ATOM   4422  C   ASP D  61      42.532  28.740  72.945  1.00 27.73           C  
ATOM   4423  O   ASP D  61      43.412  29.077  73.753  1.00 36.10           O  
ATOM   4424  CB  ASP D  61      40.626  27.301  73.974  1.00 25.77           C  
ATOM   4425  CG  ASP D  61      39.420  28.052  73.392  1.00 23.29           C  
ATOM   4426  OD1 ASP D  61      38.287  27.863  73.866  1.00 29.00           O  
ATOM   4427  OD2 ASP D  61      39.613  28.856  72.474  1.00 30.59           O  
ATOM   4428  N   SER D  62      42.268  29.474  71.870  1.00 15.93           N  
ATOM   4429  CA  SER D  62      42.759  30.830  71.757  1.00 11.72           C  
ATOM   4430  C   SER D  62      41.851  31.489  70.745  1.00 15.24           C  
ATOM   4431  O   SER D  62      41.282  30.846  69.863  1.00 14.32           O  
ATOM   4432  CB  SER D  62      44.206  30.918  71.230  1.00 18.34           C  
ATOM   4433  OG  SER D  62      44.240  30.400  69.928  1.00 17.21           O  
ATOM   4434  N   PRO D  63      41.678  32.790  70.884  1.00 15.79           N  
ATOM   4435  CA  PRO D  63      40.832  33.499  69.930  1.00 15.83           C  
ATOM   4436  C   PRO D  63      41.474  33.457  68.555  1.00 13.73           C  
ATOM   4437  O   PRO D  63      40.792  33.621  67.590  1.00 13.30           O  
ATOM   4438  CB  PRO D  63      40.793  34.940  70.441  1.00 18.84           C  
ATOM   4439  CG  PRO D  63      41.533  34.889  71.779  1.00 28.15           C  
ATOM   4440  CD  PRO D  63      41.785  33.487  72.168  1.00 22.42           C  
ATOM   4441  N   ILE D  64      42.795  33.267  68.483  1.00 12.85           N  
ATOM   4442  CA  ILE D  64      43.486  33.207  67.194  1.00 14.68           C  
ATOM   4443  C   ILE D  64      43.063  31.951  66.433  1.00 13.49           C  
ATOM   4444  O   ILE D  64      42.744  32.022  65.233  1.00 13.52           O  
ATOM   4445  CB  ILE D  64      45.055  33.140  67.381  1.00 12.56           C  
ATOM   4446  CG1 ILE D  64      45.566  34.367  68.157  1.00 13.39           C  
ATOM   4447  CG2 ILE D  64      45.763  33.003  66.009  1.00 11.26           C  
ATOM   4448  CD1 ILE D  64      47.071  34.216  68.507  1.00 14.17           C  
ATOM   4449  N   LEU D  65      43.076  30.825  67.152  1.00 12.68           N  
ATOM   4450  CA  LEU D  65      42.694  29.560  66.534  1.00 18.94           C  
ATOM   4451  C   LEU D  65      41.211  29.688  66.109  1.00 17.70           C  
ATOM   4452  O   LEU D  65      40.827  29.273  65.015  1.00 17.09           O  
ATOM   4453  CB  LEU D  65      42.898  28.405  67.540  1.00 13.09           C  
ATOM   4454  CG  LEU D  65      42.308  27.069  67.012  1.00 13.81           C  
ATOM   4455  CD1 LEU D  65      42.872  26.658  65.621  1.00 12.96           C  
ATOM   4456  CD2 LEU D  65      42.680  26.006  68.052  1.00 16.47           C  
ATOM   4457  N   ARG D  66      40.368  30.252  66.977  1.00 15.74           N  
ATOM   4458  CA  ARG D  66      38.969  30.421  66.603  1.00 19.57           C  
ATOM   4459  C   ARG D  66      38.818  31.329  65.375  1.00 16.17           C  
ATOM   4460  O   ARG D  66      37.924  31.138  64.575  1.00 15.13           O  
ATOM   4461  CB  ARG D  66      38.161  30.999  67.787  1.00 19.30           C  
ATOM   4462  CG  ARG D  66      37.935  29.940  68.844  1.00 14.20           C  
ATOM   4463  CD  ARG D  66      37.509  30.509  70.199  1.00 20.39           C  
ATOM   4464  NE  ARG D  66      37.311  29.389  71.128  1.00 25.18           N  
ATOM   4465  CZ  ARG D  66      36.240  28.589  71.094  1.00 18.56           C  
ATOM   4466  NH1 ARG D  66      35.297  28.805  70.192  1.00 19.83           N  
ATOM   4467  NH2 ARG D  66      36.107  27.589  71.967  1.00 18.08           N  
ATOM   4468  N   ARG D  67      39.628  32.364  65.241  1.00 10.88           N  
ATOM   4469  CA  ARG D  67      39.486  33.177  64.022  1.00 18.54           C  
ATOM   4470  C   ARG D  67      39.805  32.347  62.791  1.00 18.99           C  
ATOM   4471  O   ARG D  67      39.137  32.493  61.731  1.00 16.08           O  
ATOM   4472  CB  ARG D  67      40.427  34.385  64.046  1.00 19.50           C  
ATOM   4473  CG  ARG D  67      40.373  35.279  62.794  1.00 20.98           C  
ATOM   4474  CD  ARG D  67      38.931  35.622  62.332  1.00 16.45           C  
ATOM   4475  NE  ARG D  67      38.936  36.481  61.129  1.00 20.47           N  
ATOM   4476  CZ  ARG D  67      38.691  37.790  61.163  1.00 31.16           C  
ATOM   4477  NH1 ARG D  67      38.418  38.359  62.342  1.00 24.22           N  
ATOM   4478  NH2 ARG D  67      38.695  38.537  60.032  1.00 29.55           N  
ATOM   4479  N   ARG D  68      40.856  31.517  62.879  1.00 17.87           N  
ATOM   4480  CA  ARG D  68      41.230  30.667  61.716  1.00 12.98           C  
ATOM   4481  C   ARG D  68      40.088  29.670  61.369  1.00 16.37           C  
ATOM   4482  O   ARG D  68      39.753  29.467  60.187  1.00 19.17           O  
ATOM   4483  CB  ARG D  68      42.505  29.860  62.012  1.00 12.68           C  
ATOM   4484  CG  ARG D  68      42.879  28.935  60.865  1.00 14.65           C  
ATOM   4485  CD  ARG D  68      43.265  29.710  59.577  1.00 16.44           C  
ATOM   4486  NE  ARG D  68      43.855  28.809  58.565  1.00 16.50           N  
ATOM   4487  CZ  ARG D  68      43.874  29.059  57.247  1.00 16.05           C  
ATOM   4488  NH1 ARG D  68      43.353  30.171  56.771  1.00 14.34           N  
ATOM   4489  NH2 ARG D  68      44.391  28.181  56.415  1.00 16.94           N  
ATOM   4490  N   ILE D  69      39.523  29.052  62.396  1.00 14.62           N  
ATOM   4491  CA  ILE D  69      38.389  28.132  62.196  1.00 14.78           C  
ATOM   4492  C   ILE D  69      37.269  28.909  61.481  1.00 22.90           C  
ATOM   4493  O   ILE D  69      36.659  28.412  60.510  1.00 15.68           O  
ATOM   4494  CB  ILE D  69      37.888  27.635  63.545  1.00 13.32           C  
ATOM   4495  CG1 ILE D  69      38.896  26.645  64.106  1.00 18.00           C  
ATOM   4496  CG2 ILE D  69      36.412  27.049  63.454  1.00 18.31           C  
ATOM   4497  CD1 ILE D  69      38.590  26.243  65.586  1.00 19.84           C  
ATOM   4498  N   ALA D  70      36.977  30.124  61.949  1.00 15.57           N  
ATOM   4499  CA  ALA D  70      35.902  30.895  61.336  1.00 21.34           C  
ATOM   4500  C   ALA D  70      36.187  31.203  59.897  1.00 20.47           C  
ATOM   4501  O   ALA D  70      35.306  31.092  59.051  1.00 18.04           O  
ATOM   4502  CB  ALA D  70      35.666  32.210  62.089  1.00 20.79           C  
ATOM   4503  N   ASP D  71      37.402  31.642  59.611  1.00 12.32           N  
ATOM   4504  CA  ASP D  71      37.746  31.941  58.243  1.00 16.80           C  
ATOM   4505  C   ASP D  71      37.583  30.730  57.331  1.00 21.95           C  
ATOM   4506  O   ASP D  71      37.220  30.893  56.134  1.00 21.99           O  
ATOM   4507  CB  ASP D  71      39.182  32.371  58.153  1.00 17.41           C  
ATOM   4508  CG  ASP D  71      39.393  33.830  58.553  1.00 22.34           C  
ATOM   4509  OD1 ASP D  71      38.406  34.502  59.009  1.00 21.53           O  
ATOM   4510  OD2 ASP D  71      40.562  34.272  58.393  1.00 20.53           O  
ATOM   4511  N   LEU D  72      37.881  29.534  57.859  1.00 16.18           N  
ATOM   4512  CA  LEU D  72      37.802  28.320  57.002  1.00 12.32           C  
ATOM   4513  C   LEU D  72      36.427  27.683  56.917  1.00 20.79           C  
ATOM   4514  O   LEU D  72      36.225  26.653  56.236  1.00 20.83           O  
ATOM   4515  CB  LEU D  72      38.790  27.259  57.480  1.00 23.31           C  
ATOM   4516  CG  LEU D  72      40.272  27.583  57.276  1.00 22.46           C  
ATOM   4517  CD1 LEU D  72      41.062  26.490  57.967  1.00 29.01           C  
ATOM   4518  CD2 LEU D  72      40.629  27.751  55.751  1.00 13.91           C  
ATOM   4519  N   GLY D  73      35.495  28.234  57.682  1.00 22.53           N  
ATOM   4520  CA  GLY D  73      34.164  27.674  57.660  1.00 27.50           C  
ATOM   4521  C   GLY D  73      34.119  26.312  58.319  1.00 23.50           C  
ATOM   4522  O   GLY D  73      33.253  25.544  58.023  1.00 25.39           O  
ATOM   4523  N   ILE D  74      35.060  26.019  59.199  1.00 19.00           N  
ATOM   4524  CA  ILE D  74      35.037  24.738  59.896  1.00 24.32           C  
ATOM   4525  C   ILE D  74      33.891  24.775  60.893  1.00 21.92           C  
ATOM   4526  O   ILE D  74      33.764  25.683  61.707  1.00 20.23           O  
ATOM   4527  CB  ILE D  74      36.362  24.462  60.593  1.00 18.00           C  
ATOM   4528  CG1 ILE D  74      37.393  24.132  59.493  1.00 21.44           C  
ATOM   4529  CG2 ILE D  74      36.181  23.321  61.618  1.00 24.74           C  
ATOM   4530  CD1 ILE D  74      38.791  23.892  59.985  1.00 23.29           C  
ATOM   4531  N   LYS D  75      33.057  23.765  60.831  1.00 17.22           N  
ATOM   4532  CA  LYS D  75      31.842  23.758  61.641  1.00 22.71           C  
ATOM   4533  C   LYS D  75      31.880  22.970  62.932  1.00 26.61           C  
ATOM   4534  O   LYS D  75      31.036  23.162  63.812  1.00 21.41           O  
ATOM   4535  CB  LYS D  75      30.672  23.241  60.758  1.00 25.98           C  
ATOM   4536  CG  LYS D  75      30.558  23.891  59.389  1.00 29.53           C  
ATOM   4537  CD  LYS D  75      29.541  23.150  58.498  1.00 35.15           C  
ATOM   4538  CE  LYS D  75      29.468  23.714  57.048  1.00 36.35           C  
ATOM   4539  NZ  LYS D  75      28.415  23.038  56.198  1.00 37.13           N  
ATOM   4540  N   LEU D  76      32.866  22.094  63.066  1.00 14.96           N  
ATOM   4541  CA  LEU D  76      32.943  21.230  64.224  1.00 17.19           C  
ATOM   4542  C   LEU D  76      34.258  21.348  64.874  1.00 20.43           C  
ATOM   4543  O   LEU D  76      35.259  21.302  64.189  1.00 17.03           O  
ATOM   4544  CB  LEU D  76      32.781  19.784  63.779  1.00 15.94           C  
ATOM   4545  CG  LEU D  76      31.461  19.564  63.030  1.00 24.30           C  
ATOM   4546  CD1 LEU D  76      31.490  18.229  62.282  1.00 25.07           C  
ATOM   4547  CD2 LEU D  76      30.323  19.644  64.065  1.00 26.66           C  
ATOM   4548  N   PHE D  77      34.256  21.440  66.200  1.00 16.07           N  
ATOM   4549  CA  PHE D  77      35.505  21.508  66.911  1.00 21.57           C  
ATOM   4550  C   PHE D  77      35.389  21.374  68.386  1.00 16.62           C  
ATOM   4551  O   PHE D  77      34.347  21.627  68.994  1.00 19.10           O  
ATOM   4552  CB  PHE D  77      36.263  22.799  66.594  1.00 19.38           C  
ATOM   4553  CG  PHE D  77      35.439  24.028  66.666  1.00 25.73           C  
ATOM   4554  CD1 PHE D  77      35.321  24.725  67.857  1.00 24.93           C  
ATOM   4555  CD2 PHE D  77      34.799  24.513  65.523  1.00 19.33           C  
ATOM   4556  CE1 PHE D  77      34.589  25.879  67.915  1.00 15.91           C  
ATOM   4557  CE2 PHE D  77      34.053  25.688  65.565  1.00 20.44           C  
ATOM   4558  CZ  PHE D  77      33.954  26.368  66.775  1.00 22.58           C  
ATOM   4559  N   PHE D  78      36.501  20.990  68.966  1.00 17.33           N  
ATOM   4560  CA  PHE D  78      36.583  20.826  70.403  1.00 18.89           C  
ATOM   4561  C   PHE D  78      37.884  21.487  70.855  1.00 24.79           C  
ATOM   4562  O   PHE D  78      38.961  20.945  70.691  1.00 17.35           O  
ATOM   4563  CB  PHE D  78      36.523  19.334  70.665  1.00 19.36           C  
ATOM   4564  CG  PHE D  78      36.099  18.977  72.057  1.00 34.88           C  
ATOM   4565  CD1 PHE D  78      35.141  17.991  72.255  1.00 33.27           C  
ATOM   4566  CD2 PHE D  78      36.641  19.655  73.170  1.00 30.52           C  
ATOM   4567  CE1 PHE D  78      34.720  17.676  73.525  1.00 35.73           C  
ATOM   4568  CE2 PHE D  78      36.212  19.341  74.462  1.00 35.01           C  
ATOM   4569  CZ  PHE D  78      35.254  18.353  74.637  1.00 33.59           C  
ATOM   4570  N   LEU D  79      37.784  22.677  71.431  1.00 15.13           N  
ATOM   4571  CA  LEU D  79      38.968  23.404  71.844  1.00 16.65           C  
ATOM   4572  C   LEU D  79      39.070  23.424  73.342  1.00 21.79           C  
ATOM   4573  O   LEU D  79      38.051  23.592  73.996  1.00 22.00           O  
ATOM   4574  CB  LEU D  79      38.872  24.840  71.306  1.00 22.58           C  
ATOM   4575  CG  LEU D  79      38.575  24.916  69.787  1.00 22.24           C  
ATOM   4576  CD1 LEU D  79      38.733  26.335  69.377  1.00 20.12           C  
ATOM   4577  CD2 LEU D  79      39.516  24.016  68.962  1.00 19.63           C  
ATOM   4578  N   GLY D  80      40.299  23.277  73.844  1.00 23.35           N  
ATOM   4579  CA  GLY D  80      40.557  23.308  75.269  1.00 26.00           C  
ATOM   4580  C   GLY D  80      40.813  21.981  75.983  1.00 31.15           C  
ATOM   4581  O   GLY D  80      41.282  22.000  77.148  1.00 30.85           O  
ATOM   4582  N   LYS D  81      40.566  20.836  75.340  1.00 23.62           N  
ATOM   4583  CA  LYS D  81      40.730  19.565  76.075  1.00 38.04           C  
ATOM   4584  C   LYS D  81      41.855  18.613  75.730  1.00 40.52           C  
ATOM   4585  O   LYS D  81      42.107  18.229  74.539  1.00 40.45           O  
ATOM   4586  CB  LYS D  81      39.406  18.749  76.129  1.00 37.47           C  
ATOM   4587  CG  LYS D  81      39.407  17.603  77.223  1.00 34.45           C  
ATOM   4588  CD  LYS D  81      37.959  17.009  77.437  1.00 31.77           C  
ATOM   4589  CE  LYS D  81      37.666  15.889  76.467  1.00 31.46           C  
ATOM   4590  NZ  LYS D  81      36.196  15.801  76.070  1.00 38.65           N  
ATOM   4591  N   LEU D  82      42.496  18.189  76.819  1.00 39.13           N  
ATOM   4592  CA  LEU D  82      43.643  17.288  76.768  1.00 38.01           C  
ATOM   4593  C   LEU D  82      43.264  15.838  76.568  1.00 35.74           C  
ATOM   4594  O   LEU D  82      44.149  15.053  76.145  1.00 35.97           O  
ATOM   4595  CB  LEU D  82      44.480  17.431  78.040  0.00 32.80           C  
ATOM   4596  CG  LEU D  82      45.066  18.823  78.286  0.00 31.95           C  
ATOM   4597  CD1 LEU D  82      45.901  18.807  79.555  0.00 31.25           C  
ATOM   4598  CD2 LEU D  82      45.914  19.244  77.095  0.00 31.33           C  
ATOM   4599  N   GLU D  83      41.987  15.474  76.849  1.00 34.69           N  
ATOM   4600  CA  GLU D  83      41.574  14.078  76.653  1.00 30.28           C  
ATOM   4601  C   GLU D  83      40.855  13.829  75.328  1.00 26.47           C  
ATOM   4602  O   GLU D  83      39.634  13.772  75.189  1.00 23.41           O  
ATOM   4603  CB  GLU D  83      40.770  13.525  77.816  1.00 39.41           C  
ATOM   4604  CG  GLU D  83      41.160  12.053  77.993  1.00 39.98           C  
ATOM   4605  CD  GLU D  83      40.375  11.114  77.078  1.00 41.21           C  
ATOM   4606  OE1 GLU D  83      39.355  10.569  77.554  1.00 40.30           O  
ATOM   4607  OE2 GLU D  83      40.767  10.916  75.892  1.00 46.51           O  
ATOM   4608  N   LYS D  84      41.702  13.649  74.347  1.00 29.47           N  
ATOM   4609  CA  LYS D  84      41.264  13.509  72.993  1.00 25.10           C  
ATOM   4610  C   LYS D  84      40.436  12.321  72.621  1.00 21.02           C  
ATOM   4611  O   LYS D  84      39.651  12.422  71.701  1.00 20.45           O  
ATOM   4612  CB  LYS D  84      42.481  13.598  72.093  1.00 17.66           C  
ATOM   4613  CG  LYS D  84      43.148  14.932  72.297  1.00 15.15           C  
ATOM   4614  CD  LYS D  84      44.147  15.214  71.207  1.00 23.33           C  
ATOM   4615  CE  LYS D  84      44.837  16.516  71.492  1.00 25.03           C  
ATOM   4616  NZ  LYS D  84      45.883  16.775  70.489  1.00 28.77           N  
ATOM   4617  N   GLU D  85      40.643  11.172  73.256  1.00 14.83           N  
ATOM   4618  CA  GLU D  85      39.832  10.032  72.869  1.00 16.58           C  
ATOM   4619  C   GLU D  85      38.347  10.387  73.097  1.00 19.59           C  
ATOM   4620  O   GLU D  85      37.486  10.068  72.279  1.00 21.34           O  
ATOM   4621  CB  GLU D  85      40.213   8.827  73.738  1.00 26.20           C  
ATOM   4622  CG  GLU D  85      39.184   7.691  73.810  1.00 32.44           C  
ATOM   4623  CD  GLU D  85      39.553   6.716  74.939  1.00 31.65           C  
ATOM   4624  OE1 GLU D  85      40.114   5.628  74.643  1.00 38.48           O  
ATOM   4625  OE2 GLU D  85      39.318   7.072  76.131  1.00 37.85           O  
ATOM   4626  N   THR D  86      38.026  11.000  74.227  1.00 22.72           N  
ATOM   4627  CA  THR D  86      36.633  11.371  74.526  1.00 20.36           C  
ATOM   4628  C   THR D  86      36.145  12.413  73.551  1.00 19.21           C  
ATOM   4629  O   THR D  86      34.981  12.439  73.129  1.00 18.09           O  
ATOM   4630  CB  THR D  86      36.486  12.048  75.920  1.00 20.05           C  
ATOM   4631  OG1 THR D  86      37.030  11.211  76.952  1.00 35.27           O  
ATOM   4632  CG2 THR D  86      35.010  12.293  76.221  1.00 26.92           C  
ATOM   4633  N   ALA D  87      37.033  13.352  73.271  1.00 15.03           N  
ATOM   4634  CA  ALA D  87      36.699  14.405  72.345  1.00 15.44           C  
ATOM   4635  C   ALA D  87      36.426  13.751  70.988  1.00 15.44           C  
ATOM   4636  O   ALA D  87      35.480  14.161  70.341  1.00 17.45           O  
ATOM   4637  CB  ALA D  87      37.880  15.461  72.287  1.00 16.18           C  
ATOM   4638  N   CYS D  88      37.186  12.700  70.598  1.00 18.34           N  
ATOM   4639  CA  CYS D  88      36.966  12.053  69.298  1.00 18.91           C  
ATOM   4640  C   CYS D  88      35.533  11.530  69.232  1.00 16.99           C  
ATOM   4641  O   CYS D  88      34.792  11.845  68.308  1.00 14.01           O  
ATOM   4642  CB  CYS D  88      37.952  10.895  69.044  1.00 16.54           C  
ATOM   4643  SG  CYS D  88      39.606  11.459  68.662  1.00 21.28           S  
ATOM   4644  N   PHE D  89      35.130  10.811  70.267  1.00 13.59           N  
ATOM   4645  CA  PHE D  89      33.764  10.264  70.265  1.00 13.97           C  
ATOM   4646  C   PHE D  89      32.679  11.288  70.290  1.00 23.20           C  
ATOM   4647  O   PHE D  89      31.644  11.155  69.614  1.00 17.51           O  
ATOM   4648  CB  PHE D  89      33.667   9.265  71.412  1.00 20.83           C  
ATOM   4649  CG  PHE D  89      34.454   7.987  71.103  1.00 28.72           C  
ATOM   4650  CD1 PHE D  89      34.241   7.318  69.885  1.00 30.99           C  
ATOM   4651  CD2 PHE D  89      35.430   7.503  71.949  1.00 30.99           C  
ATOM   4652  CE1 PHE D  89      34.993   6.193  69.517  1.00 24.29           C  
ATOM   4653  CE2 PHE D  89      36.186   6.363  71.582  1.00 29.80           C  
ATOM   4654  CZ  PHE D  89      35.959   5.723  70.373  1.00 27.94           C  
ATOM   4655  N   ASP D  90      32.888  12.365  71.047  1.00 19.30           N  
ATOM   4656  CA  ASP D  90      31.861  13.387  71.091  1.00 18.59           C  
ATOM   4657  C   ASP D  90      31.713  14.078  69.737  1.00 18.75           C  
ATOM   4658  O   ASP D  90      30.604  14.448  69.342  1.00 16.96           O  
ATOM   4659  CB  ASP D  90      32.172  14.449  72.158  1.00 17.98           C  
ATOM   4660  CG  ASP D  90      31.950  13.936  73.609  1.00 25.52           C  
ATOM   4661  OD1 ASP D  90      32.522  14.538  74.545  1.00 21.76           O  
ATOM   4662  OD2 ASP D  90      31.205  12.936  73.811  1.00 21.04           O  
ATOM   4663  N   LEU D  91      32.844  14.265  69.062  1.00 15.12           N  
ATOM   4664  CA  LEU D  91      32.847  14.891  67.748  1.00 15.27           C  
ATOM   4665  C   LEU D  91      32.192  13.949  66.688  1.00 12.85           C  
ATOM   4666  O   LEU D  91      31.465  14.412  65.752  1.00 15.83           O  
ATOM   4667  CB  LEU D  91      34.288  15.255  67.314  1.00 16.95           C  
ATOM   4668  CG  LEU D  91      34.901  16.531  67.956  1.00 17.74           C  
ATOM   4669  CD1 LEU D  91      36.405  16.689  67.647  1.00 18.93           C  
ATOM   4670  CD2 LEU D  91      34.093  17.717  67.483  1.00 15.51           C  
ATOM   4671  N   MET D  92      32.529  12.667  66.767  1.00 11.85           N  
ATOM   4672  CA  MET D  92      31.912  11.700  65.844  1.00 12.53           C  
ATOM   4673  C   MET D  92      30.399  11.759  65.994  1.00 19.69           C  
ATOM   4674  O   MET D  92      29.677  11.779  65.016  1.00 19.42           O  
ATOM   4675  CB  MET D  92      32.436  10.286  66.118  1.00 17.64           C  
ATOM   4676  CG  MET D  92      33.870  10.060  65.617  1.00 15.94           C  
ATOM   4677  SD  MET D  92      34.363   8.598  66.327  1.00 22.78           S  
ATOM   4678  CE  MET D  92      36.012   8.712  66.073  1.00 21.25           C  
ATOM   4679  N   LYS D  93      29.919  11.861  67.234  1.00 18.74           N  
ATOM   4680  CA  LYS D  93      28.462  11.914  67.485  1.00 18.21           C  
ATOM   4681  C   LYS D  93      27.879  13.198  66.883  1.00 15.46           C  
ATOM   4682  O   LYS D  93      26.836  13.196  66.251  1.00 22.62           O  
ATOM   4683  CB  LYS D  93      28.178  11.793  69.017  1.00 20.96           C  
ATOM   4684  CG  LYS D  93      26.784  11.253  69.350  1.00 35.28           C  
ATOM   4685  CD  LYS D  93      26.661  10.840  70.815  1.00 35.55           C  
ATOM   4686  CE  LYS D  93      26.139   9.416  70.943  0.00 31.52           C  
ATOM   4687  NZ  LYS D  93      26.258   8.895  72.335  0.00 31.33           N  
ATOM   4688  N   GLN D  94      28.562  14.328  67.062  1.00 17.86           N  
ATOM   4689  CA  GLN D  94      28.071  15.569  66.476  1.00 17.25           C  
ATOM   4690  C   GLN D  94      28.025  15.459  64.944  1.00 14.62           C  
ATOM   4691  O   GLN D  94      27.154  16.006  64.286  1.00 14.82           O  
ATOM   4692  CB  GLN D  94      29.005  16.713  66.838  1.00 20.81           C  
ATOM   4693  CG  GLN D  94      28.931  17.129  68.277  1.00 23.61           C  
ATOM   4694  CD  GLN D  94      29.765  18.413  68.500  1.00 21.27           C  
ATOM   4695  OE1 GLN D  94      30.405  18.612  69.559  1.00 24.04           O  
ATOM   4696  NE2 GLN D  94      29.768  19.268  67.507  1.00 12.12           N  
ATOM   4697  N   ALA D  95      29.008  14.761  64.399  1.00 18.14           N  
ATOM   4698  CA  ALA D  95      29.089  14.610  62.955  1.00 15.60           C  
ATOM   4699  C   ALA D  95      28.130  13.573  62.374  1.00 19.71           C  
ATOM   4700  O   ALA D  95      27.893  13.546  61.150  1.00 20.15           O  
ATOM   4701  CB  ALA D  95      30.511  14.227  62.541  1.00 15.89           C  
ATOM   4702  N   GLY D  96      27.634  12.696  63.218  1.00 14.28           N  
ATOM   4703  CA  GLY D  96      26.733  11.652  62.742  1.00 21.77           C  
ATOM   4704  C   GLY D  96      27.462  10.497  62.041  1.00 20.88           C  
ATOM   4705  O   GLY D  96      26.854   9.777  61.230  1.00 25.15           O  
ATOM   4706  N   VAL D  97      28.745  10.273  62.366  1.00 16.38           N  
ATOM   4707  CA  VAL D  97      29.537   9.218  61.753  1.00 15.75           C  
ATOM   4708  C   VAL D  97      30.099   8.253  62.756  1.00 15.28           C  
ATOM   4709  O   VAL D  97      30.171   8.523  63.959  1.00 24.56           O  
ATOM   4710  CB  VAL D  97      30.725   9.810  61.016  1.00 25.63           C  
ATOM   4711  CG1 VAL D  97      30.262  10.788  59.971  1.00 19.34           C  
ATOM   4712  CG2 VAL D  97      31.626  10.511  62.055  1.00 13.80           C  
ATOM   4713  N   THR D  98      30.502   7.089  62.270  1.00 18.73           N  
ATOM   4714  CA  THR D  98      31.065   6.094  63.140  1.00 17.49           C  
ATOM   4715  C   THR D  98      32.585   6.291  63.109  1.00 15.36           C  
ATOM   4716  O   THR D  98      33.131   6.992  62.287  1.00 20.67           O  
ATOM   4717  CB  THR D  98      30.827   4.623  62.600  1.00 22.86           C  
ATOM   4718  OG1 THR D  98      31.564   4.469  61.378  1.00 21.65           O  
ATOM   4719  CG2 THR D  98      29.318   4.336  62.324  1.00 25.03           C  
ATOM   4720  N   ALA D  99      33.258   5.633  64.009  1.00 20.47           N  
ATOM   4721  CA  ALA D  99      34.701   5.712  64.039  1.00 22.99           C  
ATOM   4722  C   ALA D  99      35.310   5.158  62.764  1.00 20.07           C  
ATOM   4723  O   ALA D  99      36.269   5.723  62.250  1.00 18.26           O  
ATOM   4724  CB  ALA D  99      35.247   4.960  65.237  1.00 22.36           C  
ATOM   4725  N   GLU D 100      34.755   4.063  62.222  1.00 17.72           N  
ATOM   4726  CA  GLU D 100      35.383   3.504  61.025  1.00 19.98           C  
ATOM   4727  C   GLU D 100      35.275   4.470  59.850  1.00 20.33           C  
ATOM   4728  O   GLU D 100      35.964   4.308  58.836  1.00 27.63           O  
ATOM   4729  CB  GLU D 100      34.791   2.123  60.640  1.00 26.01           C  
ATOM   4730  CG  GLU D 100      35.315   1.576  59.225  1.00 35.26           C  
ATOM   4731  CD  GLU D 100      36.820   1.113  59.137  1.00 37.58           C  
ATOM   4732  OE1 GLU D 100      37.103  -0.054  59.495  1.00 36.54           O  
ATOM   4733  OE2 GLU D 100      37.731   1.914  58.696  1.00 40.62           O  
ATOM   4734  N   GLN D 101      34.431   5.474  59.969  1.00 17.10           N  
ATOM   4735  CA  GLN D 101      34.263   6.432  58.884  1.00 17.64           C  
ATOM   4736  C   GLN D 101      35.050   7.693  59.195  1.00 17.57           C  
ATOM   4737  O   GLN D 101      34.929   8.656  58.496  1.00 17.68           O  
ATOM   4738  CB  GLN D 101      32.778   6.831  58.680  1.00 25.19           C  
ATOM   4739  CG  GLN D 101      31.858   5.625  58.338  1.00 24.35           C  
ATOM   4740  CD  GLN D 101      30.332   5.889  58.433  1.00 32.47           C  
ATOM   4741  OE1 GLN D 101      29.838   6.804  59.129  1.00 27.96           O  
ATOM   4742  NE2 GLN D 101      29.579   5.034  57.763  1.00 30.69           N  
ATOM   4743  N   THR D 102      35.837   7.677  60.265  1.00 20.89           N  
ATOM   4744  CA  THR D 102      36.559   8.907  60.662  1.00 11.99           C  
ATOM   4745  C   THR D 102      38.051   8.690  60.652  1.00 12.86           C  
ATOM   4746  O   THR D 102      38.532   7.627  61.072  1.00 19.88           O  
ATOM   4747  CB  THR D 102      36.152   9.246  62.129  1.00 17.52           C  
ATOM   4748  OG1 THR D 102      34.726   9.343  62.188  1.00 16.42           O  
ATOM   4749  CG2 THR D 102      36.785  10.564  62.635  1.00 18.56           C  
ATOM   4750  N   ALA D 103      38.772   9.701  60.195  1.00 13.85           N  
ATOM   4751  CA  ALA D 103      40.224   9.652  60.140  1.00 16.25           C  
ATOM   4752  C   ALA D 103      40.724  10.767  61.035  1.00 10.35           C  
ATOM   4753  O   ALA D 103      40.061  11.840  61.135  1.00 13.85           O  
ATOM   4754  CB  ALA D 103      40.757   9.958  58.685  1.00 15.63           C  
ATOM   4755  N   TYR D 104      41.917  10.540  61.584  1.00 11.49           N  
ATOM   4756  CA  TYR D 104      42.543  11.520  62.478  1.00 10.55           C  
ATOM   4757  C   TYR D 104      43.971  11.758  62.017  1.00 12.49           C  
ATOM   4758  O   TYR D 104      44.597  10.831  61.469  1.00 16.63           O  
ATOM   4759  CB  TYR D 104      42.577  10.958  63.923  1.00 12.71           C  
ATOM   4760  CG  TYR D 104      42.997  11.977  64.934  1.00 15.16           C  
ATOM   4761  CD1 TYR D 104      42.047  12.721  65.594  1.00 12.31           C  
ATOM   4762  CD2 TYR D 104      44.359  12.204  65.195  1.00 11.18           C  
ATOM   4763  CE1 TYR D 104      42.458  13.730  66.532  1.00 11.68           C  
ATOM   4764  CE2 TYR D 104      44.785  13.213  66.176  1.00  7.93           C  
ATOM   4765  CZ  TYR D 104      43.804  13.947  66.804  1.00 15.91           C  
ATOM   4766  OH  TYR D 104      44.272  14.854  67.711  1.00 13.96           O  
ATOM   4767  N   ILE D 105      44.462  12.978  62.229  1.00 10.97           N  
ATOM   4768  CA  ILE D 105      45.848  13.314  61.872  1.00 16.86           C  
ATOM   4769  C   ILE D 105      46.412  14.030  63.083  1.00 17.58           C  
ATOM   4770  O   ILE D 105      45.782  14.948  63.615  1.00 17.79           O  
ATOM   4771  CB  ILE D 105      45.972  14.163  60.578  1.00 15.09           C  
ATOM   4772  CG1 ILE D 105      47.448  14.494  60.308  1.00 10.65           C  
ATOM   4773  CG2 ILE D 105      45.029  15.360  60.579  1.00 17.18           C  
ATOM   4774  CD1 ILE D 105      47.559  15.237  58.985  1.00 11.70           C  
ATOM   4775  N   GLY D 106      47.555  13.541  63.532  1.00 16.58           N  
ATOM   4776  CA  GLY D 106      48.175  14.078  64.740  1.00 11.02           C  
ATOM   4777  C   GLY D 106      49.670  14.080  64.711  1.00 16.58           C  
ATOM   4778  O   GLY D 106      50.253  13.626  63.727  1.00 13.80           O  
ATOM   4779  N   ASP D 107      50.308  14.632  65.756  1.00 10.01           N  
ATOM   4780  CA  ASP D 107      51.754  14.608  65.766  1.00 11.07           C  
ATOM   4781  C   ASP D 107      52.478  14.124  67.046  1.00  9.86           C  
ATOM   4782  O   ASP D 107      53.717  13.998  67.054  1.00 12.39           O  
ATOM   4783  CB  ASP D 107      52.253  16.030  65.483  1.00 13.90           C  
ATOM   4784  CG  ASP D 107      52.000  16.958  66.688  1.00 12.62           C  
ATOM   4785  OD1 ASP D 107      52.948  17.659  67.161  1.00 11.12           O  
ATOM   4786  OD2 ASP D 107      50.815  16.953  67.070  1.00 10.78           O  
ATOM   4787  N   ASP D 108      51.736  13.933  68.125  1.00 14.91           N  
ATOM   4788  CA  ASP D 108      52.412  13.620  69.405  1.00 11.62           C  
ATOM   4789  C   ASP D 108      51.668  12.615  70.245  1.00 10.42           C  
ATOM   4790  O   ASP D 108      50.591  12.104  69.871  1.00 11.97           O  
ATOM   4791  CB  ASP D 108      52.557  14.945  70.190  1.00 19.56           C  
ATOM   4792  CG  ASP D 108      53.742  14.948  71.154  1.00 16.10           C  
ATOM   4793  OD1 ASP D 108      53.961  15.983  71.817  1.00 15.78           O  
ATOM   4794  OD2 ASP D 108      54.453  13.927  71.224  1.00 19.13           O  
ATOM   4795  N   SER D 109      52.228  12.348  71.415  1.00 14.55           N  
ATOM   4796  CA  SER D 109      51.704  11.355  72.328  1.00 20.32           C  
ATOM   4797  C   SER D 109      50.262  11.506  72.679  1.00 22.17           C  
ATOM   4798  O   SER D 109      49.535  10.503  72.836  1.00 17.62           O  
ATOM   4799  CB  SER D 109      52.564  11.373  73.576  1.00 11.01           C  
ATOM   4800  OG  SER D 109      53.830  10.958  73.202  1.00 17.66           O  
ATOM   4801  N   VAL D 110      49.838  12.767  72.763  1.00 20.25           N  
ATOM   4802  CA  VAL D 110      48.493  13.111  73.159  1.00 11.84           C  
ATOM   4803  C   VAL D 110      47.513  12.645  72.118  1.00 13.96           C  
ATOM   4804  O   VAL D 110      46.302  12.511  72.414  1.00 14.59           O  
ATOM   4805  CB  VAL D 110      48.356  14.640  73.460  1.00 18.48           C  
ATOM   4806  CG1 VAL D 110      46.957  14.974  73.959  1.00 25.68           C  
ATOM   4807  CG2 VAL D 110      49.283  14.985  74.639  1.00 28.55           C  
ATOM   4808  N   ASP D 111      48.031  12.378  70.919  1.00 13.35           N  
ATOM   4809  CA  ASP D 111      47.189  11.920  69.847  1.00 18.22           C  
ATOM   4810  C   ASP D 111      47.019  10.422  69.815  1.00 18.39           C  
ATOM   4811  O   ASP D 111      46.118   9.941  69.151  1.00 14.53           O  
ATOM   4812  CB  ASP D 111      47.698  12.491  68.506  1.00  9.43           C  
ATOM   4813  CG  ASP D 111      47.742  14.033  68.566  1.00 14.28           C  
ATOM   4814  OD1 ASP D 111      46.673  14.668  68.816  1.00 13.68           O  
ATOM   4815  OD2 ASP D 111      48.865  14.567  68.430  1.00 12.36           O  
ATOM   4816  N   LEU D 112      47.820   9.693  70.586  1.00 15.87           N  
ATOM   4817  CA  LEU D 112      47.739   8.241  70.539  1.00 13.53           C  
ATOM   4818  C   LEU D 112      46.333   7.701  70.800  1.00 16.30           C  
ATOM   4819  O   LEU D 112      45.836   6.830  70.056  1.00 12.78           O  
ATOM   4820  CB  LEU D 112      48.809   7.613  71.427  1.00 13.35           C  
ATOM   4821  CG  LEU D 112      50.260   7.882  70.902  1.00 19.11           C  
ATOM   4822  CD1 LEU D 112      51.310   7.509  71.989  1.00 14.85           C  
ATOM   4823  CD2 LEU D 112      50.537   7.088  69.601  1.00 18.17           C  
ATOM   4824  N   PRO D 113      45.645   8.214  71.829  1.00 17.12           N  
ATOM   4825  CA  PRO D 113      44.267   7.744  72.126  1.00 19.84           C  
ATOM   4826  C   PRO D 113      43.314   8.129  70.977  1.00 11.75           C  
ATOM   4827  O   PRO D 113      42.312   7.460  70.712  1.00 15.41           O  
ATOM   4828  CB  PRO D 113      43.913   8.533  73.391  1.00 17.86           C  
ATOM   4829  CG  PRO D 113      45.321   8.689  74.076  1.00 21.42           C  
ATOM   4830  CD  PRO D 113      46.128   9.127  72.895  1.00 14.03           C  
ATOM   4831  N   ALA D 114      43.621   9.219  70.304  1.00 15.65           N  
ATOM   4832  CA  ALA D 114      42.757   9.680  69.187  1.00 19.74           C  
ATOM   4833  C   ALA D 114      42.926   8.776  67.963  1.00 17.79           C  
ATOM   4834  O   ALA D 114      41.917   8.440  67.277  1.00 14.19           O  
ATOM   4835  CB  ALA D 114      43.064  11.152  68.854  1.00 15.00           C  
ATOM   4836  N   PHE D 115      44.164   8.371  67.680  1.00 14.41           N  
ATOM   4837  CA  PHE D 115      44.371   7.427  66.573  1.00 14.65           C  
ATOM   4838  C   PHE D 115      43.611   6.143  66.861  1.00 18.12           C  
ATOM   4839  O   PHE D 115      43.009   5.562  65.954  1.00 17.26           O  
ATOM   4840  CB  PHE D 115      45.810   6.997  66.424  1.00 14.10           C  
ATOM   4841  CG  PHE D 115      46.762   8.118  66.215  1.00 14.29           C  
ATOM   4842  CD1 PHE D 115      48.017   8.009  66.738  1.00 14.24           C  
ATOM   4843  CD2 PHE D 115      46.396   9.262  65.495  1.00 13.08           C  
ATOM   4844  CE1 PHE D 115      48.944   9.054  66.555  1.00 18.68           C  
ATOM   4845  CE2 PHE D 115      47.296  10.319  65.288  1.00 16.56           C  
ATOM   4846  CZ  PHE D 115      48.571  10.202  65.833  1.00 17.11           C  
ATOM   4847  N   ALA D 116      43.681   5.682  68.123  1.00 11.92           N  
ATOM   4848  CA  ALA D 116      43.034   4.422  68.477  1.00 20.01           C  
ATOM   4849  C   ALA D 116      41.535   4.595  68.421  1.00 24.84           C  
ATOM   4850  O   ALA D 116      40.830   3.647  68.049  1.00 24.81           O  
ATOM   4851  CB  ALA D 116      43.453   3.945  69.876  1.00 23.87           C  
ATOM   4852  N   ALA D 117      41.030   5.772  68.833  1.00 20.99           N  
ATOM   4853  CA  ALA D 117      39.600   5.994  68.769  1.00 20.59           C  
ATOM   4854  C   ALA D 117      39.097   6.055  67.305  1.00 22.88           C  
ATOM   4855  O   ALA D 117      37.989   5.614  67.017  1.00 17.92           O  
ATOM   4856  CB  ALA D 117      39.207   7.265  69.565  1.00 18.75           C  
ATOM   4857  N   CYS D 118      39.906   6.577  66.386  1.00 19.14           N  
ATOM   4858  CA  CYS D 118      39.513   6.650  64.960  1.00 23.77           C  
ATOM   4859  C   CYS D 118      39.724   5.383  64.108  1.00 24.63           C  
ATOM   4860  O   CYS D 118      40.549   4.510  64.432  1.00 19.29           O  
ATOM   4861  CB  CYS D 118      40.235   7.846  64.300  1.00 17.88           C  
ATOM   4862  SG  CYS D 118      39.253   9.305  64.485  1.00 19.97           S  
ATOM   4863  N   GLY D 119      38.973   5.287  63.013  1.00 13.98           N  
ATOM   4864  CA  GLY D 119      39.111   4.140  62.126  1.00 18.86           C  
ATOM   4865  C   GLY D 119      40.396   4.162  61.300  1.00 15.55           C  
ATOM   4866  O   GLY D 119      40.972   3.096  61.057  1.00 19.84           O  
ATOM   4867  N   THR D 120      40.805   5.372  60.885  1.00 14.36           N  
ATOM   4868  CA  THR D 120      42.017   5.631  60.107  1.00 13.55           C  
ATOM   4869  C   THR D 120      42.836   6.744  60.792  1.00  7.93           C  
ATOM   4870  O   THR D 120      42.266   7.677  61.329  1.00 14.69           O  
ATOM   4871  CB  THR D 120      41.635   6.184  58.673  1.00 21.16           C  
ATOM   4872  OG1 THR D 120      40.865   5.208  57.987  1.00 25.25           O  
ATOM   4873  CG2 THR D 120      42.818   6.519  57.868  1.00 22.65           C  
ATOM   4874  N   SER D 121      44.162   6.632  60.747  1.00 14.79           N  
ATOM   4875  CA  SER D 121      44.997   7.655  61.369  1.00 15.60           C  
ATOM   4876  C   SER D 121      46.214   8.022  60.496  1.00 16.76           C  
ATOM   4877  O   SER D 121      46.807   7.175  59.829  1.00 18.65           O  
ATOM   4878  CB  SER D 121      45.478   7.157  62.767  1.00 18.62           C  
ATOM   4879  OG  SER D 121      46.121   5.867  62.697  1.00 14.36           O  
ATOM   4880  N   PHE D 122      46.589   9.280  60.542  1.00 13.69           N  
ATOM   4881  CA  PHE D 122      47.753   9.769  59.824  1.00 14.43           C  
ATOM   4882  C   PHE D 122      48.690  10.468  60.773  1.00 10.06           C  
ATOM   4883  O   PHE D 122      48.203  11.155  61.672  1.00 12.40           O  
ATOM   4884  CB  PHE D 122      47.324  10.829  58.829  1.00 13.11           C  
ATOM   4885  CG  PHE D 122      46.472  10.319  57.736  1.00 17.81           C  
ATOM   4886  CD1 PHE D 122      45.094  10.223  57.893  1.00 10.21           C  
ATOM   4887  CD2 PHE D 122      47.039   9.882  56.576  1.00 15.53           C  
ATOM   4888  CE1 PHE D 122      44.276   9.672  56.870  1.00 17.49           C  
ATOM   4889  CE2 PHE D 122      46.222   9.331  55.542  1.00 19.19           C  
ATOM   4890  CZ  PHE D 122      44.848   9.233  55.709  1.00 13.75           C  
ATOM   4891  N   ALA D 123      49.990  10.333  60.556  1.00 12.02           N  
ATOM   4892  CA  ALA D 123      51.001  11.056  61.344  1.00 16.68           C  
ATOM   4893  C   ALA D 123      51.740  12.002  60.405  1.00 18.44           C  
ATOM   4894  O   ALA D 123      52.028  11.631  59.262  1.00 13.46           O  
ATOM   4895  CB  ALA D 123      51.977  10.110  61.910  1.00 13.14           C  
ATOM   4896  N   VAL D 124      52.099  13.218  60.877  1.00 14.53           N  
ATOM   4897  CA  VAL D 124      52.869  14.109  60.058  1.00 13.33           C  
ATOM   4898  C   VAL D 124      54.313  13.594  60.036  1.00 10.84           C  
ATOM   4899  O   VAL D 124      54.710  12.795  60.917  1.00 14.15           O  
ATOM   4900  CB  VAL D 124      52.827  15.591  60.578  1.00 10.35           C  
ATOM   4901  CG1 VAL D 124      51.361  16.116  60.528  1.00 14.04           C  
ATOM   4902  CG2 VAL D 124      53.328  15.660  62.033  1.00 16.94           C  
ATOM   4903  N   ALA D 125      55.071  14.026  59.023  1.00 11.79           N  
ATOM   4904  CA  ALA D 125      56.460  13.524  58.760  1.00 12.64           C  
ATOM   4905  C   ALA D 125      57.484  13.751  59.857  1.00 10.34           C  
ATOM   4906  O   ALA D 125      58.484  13.054  59.935  1.00 13.77           O  
ATOM   4907  CB  ALA D 125      57.003  14.107  57.422  1.00 14.84           C  
ATOM   4908  N   ASP D 126      57.232  14.756  60.691  1.00  9.49           N  
ATOM   4909  CA  ASP D 126      58.140  15.038  61.804  1.00 16.86           C  
ATOM   4910  C   ASP D 126      57.613  14.534  63.157  1.00 21.06           C  
ATOM   4911  O   ASP D 126      58.150  14.870  64.215  1.00 16.25           O  
ATOM   4912  CB  ASP D 126      58.537  16.520  61.856  1.00 14.35           C  
ATOM   4913  CG  ASP D 126      57.364  17.473  61.831  1.00 18.46           C  
ATOM   4914  OD1 ASP D 126      57.536  18.571  62.399  1.00 19.72           O  
ATOM   4915  OD2 ASP D 126      56.292  17.171  61.300  1.00 13.76           O  
ATOM   4916  N   ALA D 127      56.569  13.707  63.121  1.00 10.55           N  
ATOM   4917  CA  ALA D 127      56.079  13.104  64.377  1.00 12.92           C  
ATOM   4918  C   ALA D 127      57.149  12.108  64.870  1.00 11.92           C  
ATOM   4919  O   ALA D 127      57.954  11.583  64.101  1.00 13.15           O  
ATOM   4920  CB  ALA D 127      54.741  12.389  64.121  1.00 14.41           C  
ATOM   4921  N   PRO D 128      57.223  11.887  66.188  1.00 10.77           N  
ATOM   4922  CA  PRO D 128      58.201  10.956  66.721  1.00 13.25           C  
ATOM   4923  C   PRO D 128      57.867   9.534  66.310  1.00 12.75           C  
ATOM   4924  O   PRO D 128      56.728   9.234  66.009  1.00 13.08           O  
ATOM   4925  CB  PRO D 128      58.087  11.142  68.235  1.00 13.50           C  
ATOM   4926  CG  PRO D 128      56.693  11.657  68.434  1.00 17.59           C  
ATOM   4927  CD  PRO D 128      56.541  12.641  67.253  1.00 10.51           C  
ATOM   4928  N   ILE D 129      58.902   8.694  66.280  1.00 12.89           N  
ATOM   4929  CA  ILE D 129      58.795   7.301  65.920  1.00 15.74           C  
ATOM   4930  C   ILE D 129      57.633   6.624  66.555  1.00 14.32           C  
ATOM   4931  O   ILE D 129      56.945   5.822  65.887  1.00 16.85           O  
ATOM   4932  CB  ILE D 129      60.052   6.539  66.448  1.00 21.46           C  
ATOM   4933  CG1 ILE D 129      61.280   6.995  65.653  1.00 31.59           C  
ATOM   4934  CG2 ILE D 129      59.810   5.069  66.506  1.00 30.66           C  
ATOM   4935  CD1 ILE D 129      61.066   7.140  64.206  1.00 26.35           C  
ATOM   4936  N   TYR D 130      57.411   6.875  67.852  1.00 11.40           N  
ATOM   4937  CA  TYR D 130      56.299   6.170  68.515  1.00 16.04           C  
ATOM   4938  C   TYR D 130      54.918   6.616  68.063  1.00 22.83           C  
ATOM   4939  O   TYR D 130      53.923   5.870  68.197  1.00 19.35           O  
ATOM   4940  CB  TYR D 130      56.401   6.219  70.026  1.00 13.74           C  
ATOM   4941  CG  TYR D 130      56.830   7.545  70.540  1.00 11.78           C  
ATOM   4942  CD1 TYR D 130      55.895   8.524  70.811  1.00 12.87           C  
ATOM   4943  CD2 TYR D 130      58.193   7.815  70.741  1.00 13.13           C  
ATOM   4944  CE1 TYR D 130      56.292   9.797  71.265  1.00 15.83           C  
ATOM   4945  CE2 TYR D 130      58.600   9.100  71.232  1.00 10.18           C  
ATOM   4946  CZ  TYR D 130      57.631  10.054  71.458  1.00 11.87           C  
ATOM   4947  OH  TYR D 130      57.954  11.342  71.871  1.00 14.13           O  
ATOM   4948  N   VAL D 131      54.834   7.830  67.538  1.00 16.72           N  
ATOM   4949  CA  VAL D 131      53.574   8.288  67.001  1.00 15.07           C  
ATOM   4950  C   VAL D 131      53.456   7.679  65.576  1.00 16.30           C  
ATOM   4951  O   VAL D 131      52.402   7.144  65.214  1.00 15.12           O  
ATOM   4952  CB  VAL D 131      53.537   9.826  66.955  1.00  9.40           C  
ATOM   4953  CG1 VAL D 131      52.447  10.322  65.972  1.00 14.62           C  
ATOM   4954  CG2 VAL D 131      53.292  10.371  68.362  1.00 17.76           C  
ATOM   4955  N   LYS D 132      54.567   7.677  64.827  1.00 12.42           N  
ATOM   4956  CA  LYS D 132      54.513   7.174  63.469  1.00 17.54           C  
ATOM   4957  C   LYS D 132      54.179   5.704  63.442  1.00 16.40           C  
ATOM   4958  O   LYS D 132      53.509   5.246  62.529  1.00 14.22           O  
ATOM   4959  CB  LYS D 132      55.854   7.403  62.720  1.00 12.43           C  
ATOM   4960  CG  LYS D 132      56.132   8.852  62.352  1.00 16.94           C  
ATOM   4961  CD  LYS D 132      57.433   8.948  61.573  1.00 15.46           C  
ATOM   4962  CE  LYS D 132      57.483  10.305  60.928  1.00 11.45           C  
ATOM   4963  NZ  LYS D 132      58.824  10.369  60.202  1.00 17.28           N  
ATOM   4964  N   ASN D 133      54.601   4.965  64.471  1.00 15.55           N  
ATOM   4965  CA  ASN D 133      54.377   3.520  64.458  1.00 17.18           C  
ATOM   4966  C   ASN D 133      52.946   3.168  64.729  1.00 19.67           C  
ATOM   4967  O   ASN D 133      52.511   2.067  64.379  1.00 19.31           O  
ATOM   4968  CB  ASN D 133      55.262   2.803  65.493  1.00 18.04           C  
ATOM   4969  CG  ASN D 133      55.413   1.339  65.178  1.00 18.62           C  
ATOM   4970  OD1 ASN D 133      55.855   0.979  64.070  1.00 20.28           O  
ATOM   4971  ND2 ASN D 133      55.019   0.492  66.088  1.00 18.99           N  
ATOM   4972  N   ALA D 134      52.230   4.114  65.300  1.00 17.40           N  
ATOM   4973  CA  ALA D 134      50.847   3.898  65.715  1.00 24.30           C  
ATOM   4974  C   ALA D 134      49.820   4.226  64.683  1.00 18.16           C  
ATOM   4975  O   ALA D 134      48.675   3.836  64.839  1.00 18.79           O  
ATOM   4976  CB  ALA D 134      50.534   4.705  66.984  1.00 16.50           C  
ATOM   4977  N   VAL D 135      50.212   4.938  63.622  1.00 19.15           N  
ATOM   4978  CA  VAL D 135      49.234   5.273  62.621  1.00 18.88           C  
ATOM   4979  C   VAL D 135      49.165   4.332  61.438  1.00 20.58           C  
ATOM   4980  O   VAL D 135      50.052   3.519  61.213  1.00 20.07           O  
ATOM   4981  CB  VAL D 135      49.466   6.668  62.079  1.00 14.61           C  
ATOM   4982  CG1 VAL D 135      49.356   7.677  63.308  1.00 14.32           C  
ATOM   4983  CG2 VAL D 135      50.875   6.750  61.322  1.00 15.47           C  
ATOM   4984  N   ASP D 136      48.117   4.510  60.660  1.00 16.07           N  
ATOM   4985  CA  ASP D 136      47.930   3.705  59.448  1.00 21.21           C  
ATOM   4986  C   ASP D 136      48.827   4.264  58.380  1.00 23.25           C  
ATOM   4987  O   ASP D 136      49.511   3.487  57.662  1.00 19.73           O  
ATOM   4988  CB  ASP D 136      46.462   3.733  59.009  1.00 19.34           C  
ATOM   4989  CG  ASP D 136      45.570   3.175  60.069  1.00 31.18           C  
ATOM   4990  OD1 ASP D 136      44.563   3.837  60.381  1.00 25.69           O  
ATOM   4991  OD2 ASP D 136      45.920   2.098  60.645  1.00 28.51           O  
ATOM   4992  N   HIS D 137      48.844   5.588  58.256  1.00 14.45           N  
ATOM   4993  CA  HIS D 137      49.693   6.191  57.255  1.00 16.35           C  
ATOM   4994  C   HIS D 137      50.567   7.330  57.702  1.00 15.25           C  
ATOM   4995  O   HIS D 137      50.081   8.309  58.252  1.00 14.84           O  
ATOM   4996  CB  HIS D 137      48.941   6.712  56.018  1.00 23.74           C  
ATOM   4997  CG  HIS D 137      49.822   6.744  54.794  1.00 34.00           C  
ATOM   4998  ND1 HIS D 137      50.246   5.595  54.134  1.00 31.87           N  
ATOM   4999  CD2 HIS D 137      50.457   7.777  54.180  1.00 36.72           C  
ATOM   5000  CE1 HIS D 137      51.096   5.926  53.180  1.00 34.73           C  
ATOM   5001  NE2 HIS D 137      51.243   7.242  53.189  1.00 31.85           N  
ATOM   5002  N   VAL D 138      51.854   7.184  57.463  1.00 11.31           N  
ATOM   5003  CA  VAL D 138      52.813   8.237  57.818  1.00  7.88           C  
ATOM   5004  C   VAL D 138      52.987   9.136  56.616  1.00 17.63           C  
ATOM   5005  O   VAL D 138      53.422   8.676  55.507  1.00 12.43           O  
ATOM   5006  CB  VAL D 138      54.179   7.630  58.196  1.00 14.08           C  
ATOM   5007  CG1 VAL D 138      55.163   8.718  58.566  1.00 14.67           C  
ATOM   5008  CG2 VAL D 138      54.024   6.696  59.458  1.00 12.68           C  
ATOM   5009  N   LEU D 139      52.672  10.418  56.800  1.00 13.69           N  
ATOM   5010  CA  LEU D 139      52.791  11.393  55.705  1.00 12.87           C  
ATOM   5011  C   LEU D 139      54.254  11.773  55.449  1.00 12.74           C  
ATOM   5012  O   LEU D 139      55.105  11.664  56.314  1.00 15.81           O  
ATOM   5013  CB  LEU D 139      51.944  12.637  56.039  1.00 10.45           C  
ATOM   5014  CG  LEU D 139      50.451  12.288  56.186  1.00 10.91           C  
ATOM   5015  CD1 LEU D 139      49.802  13.413  56.958  1.00 12.89           C  
ATOM   5016  CD2 LEU D 139      49.790  12.058  54.792  1.00 13.29           C  
ATOM   5017  N   SER D 140      54.533  12.244  54.228  1.00 12.69           N  
ATOM   5018  CA  SER D 140      55.850  12.603  53.864  1.00 13.87           C  
ATOM   5019  C   SER D 140      56.074  14.083  54.153  1.00 12.79           C  
ATOM   5020  O   SER D 140      57.225  14.534  54.129  1.00 16.50           O  
ATOM   5021  CB  SER D 140      56.074  12.333  52.367  1.00 20.41           C  
ATOM   5022  OG  SER D 140      55.368  13.331  51.704  1.00 21.78           O  
ATOM   5023  N   THR D 141      54.995  14.824  54.440  1.00 15.28           N  
ATOM   5024  CA  THR D 141      55.133  16.279  54.676  1.00 14.91           C  
ATOM   5025  C   THR D 141      55.174  16.649  56.155  1.00 15.60           C  
ATOM   5026  O   THR D 141      54.402  16.120  56.921  1.00 13.56           O  
ATOM   5027  CB  THR D 141      53.990  16.998  54.037  1.00 14.44           C  
ATOM   5028  OG1 THR D 141      53.965  16.638  52.644  1.00 13.65           O  
ATOM   5029  CG2 THR D 141      54.164  18.550  54.155  1.00 13.18           C  
ATOM   5030  N   HIS D 142      56.084  17.552  56.532  1.00 12.75           N  
ATOM   5031  CA  HIS D 142      56.181  18.038  57.916  1.00 15.51           C  
ATOM   5032  C   HIS D 142      54.938  18.791  58.373  1.00 17.31           C  
ATOM   5033  O   HIS D 142      54.232  19.377  57.573  1.00 13.99           O  
ATOM   5034  CB  HIS D 142      57.359  18.993  58.057  1.00 10.88           C  
ATOM   5035  CG  HIS D 142      58.683  18.286  58.186  1.00 26.81           C  
ATOM   5036  ND1 HIS D 142      59.015  17.175  57.433  1.00 32.10           N  
ATOM   5037  CD2 HIS D 142      59.760  18.536  58.977  1.00 28.51           C  
ATOM   5038  CE1 HIS D 142      60.228  16.766  57.757  1.00 26.96           C  
ATOM   5039  NE2 HIS D 142      60.706  17.574  58.690  1.00 30.12           N  
ATOM   5040  N   GLY D 143      54.647  18.738  59.676  1.00 11.67           N  
ATOM   5041  CA  GLY D 143      53.498  19.483  60.180  1.00 13.42           C  
ATOM   5042  C   GLY D 143      53.673  20.965  59.809  1.00 15.11           C  
ATOM   5043  O   GLY D 143      54.801  21.489  59.751  1.00 13.75           O  
ATOM   5044  N   GLY D 144      52.544  21.619  59.548  1.00 11.95           N  
ATOM   5045  CA  GLY D 144      52.538  23.032  59.201  1.00 13.24           C  
ATOM   5046  C   GLY D 144      53.043  23.387  57.804  1.00 14.58           C  
ATOM   5047  O   GLY D 144      53.031  24.565  57.421  1.00 18.55           O  
ATOM   5048  N   LYS D 145      53.415  22.379  57.035  1.00 12.26           N  
ATOM   5049  CA  LYS D 145      53.944  22.610  55.696  1.00 13.85           C  
ATOM   5050  C   LYS D 145      53.084  21.924  54.645  1.00 13.26           C  
ATOM   5051  O   LYS D 145      53.580  21.647  53.534  1.00 14.55           O  
ATOM   5052  CB  LYS D 145      55.397  22.085  55.545  1.00 13.97           C  
ATOM   5053  CG  LYS D 145      56.349  22.430  56.696  1.00 15.59           C  
ATOM   5054  CD  LYS D 145      56.312  23.906  56.895  1.00 19.06           C  
ATOM   5055  CE  LYS D 145      57.390  24.356  57.831  1.00 23.07           C  
ATOM   5056  NZ  LYS D 145      57.350  25.880  58.018  1.00 27.36           N  
ATOM   5057  N   GLY D 146      51.820  21.638  54.976  1.00 10.03           N  
ATOM   5058  CA  GLY D 146      50.980  21.034  53.947  1.00  9.97           C  
ATOM   5059  C   GLY D 146      50.738  19.557  54.241  1.00 16.74           C  
ATOM   5060  O   GLY D 146      50.354  18.823  53.352  1.00 13.72           O  
ATOM   5061  N   ALA D 147      50.923  19.088  55.482  1.00 15.18           N  
ATOM   5062  CA  ALA D 147      50.658  17.676  55.740  1.00  7.66           C  
ATOM   5063  C   ALA D 147      49.149  17.391  55.718  1.00  8.38           C  
ATOM   5064  O   ALA D 147      48.708  16.311  55.257  1.00  9.75           O  
ATOM   5065  CB  ALA D 147      51.264  17.212  57.147  1.00 15.00           C  
ATOM   5066  N   PHE D 148      48.330  18.340  56.164  1.00 10.48           N  
ATOM   5067  CA  PHE D 148      46.894  18.073  56.125  1.00 16.55           C  
ATOM   5068  C   PHE D 148      46.459  17.928  54.632  1.00 13.46           C  
ATOM   5069  O   PHE D 148      45.609  17.090  54.276  1.00 14.03           O  
ATOM   5070  CB  PHE D 148      46.113  19.216  56.764  1.00 14.17           C  
ATOM   5071  CG  PHE D 148      44.645  18.960  56.801  1.00 14.01           C  
ATOM   5072  CD1 PHE D 148      44.044  18.464  57.959  1.00 12.00           C  
ATOM   5073  CD2 PHE D 148      43.852  19.169  55.663  1.00 13.21           C  
ATOM   5074  CE1 PHE D 148      42.627  18.171  57.966  1.00 19.40           C  
ATOM   5075  CE2 PHE D 148      42.495  18.888  55.651  1.00 13.29           C  
ATOM   5076  CZ  PHE D 148      41.871  18.386  56.801  1.00 17.55           C  
ATOM   5077  N   ARG D 149      46.997  18.838  53.813  1.00 10.00           N  
ATOM   5078  CA  ARG D 149      46.719  18.842  52.355  1.00 13.54           C  
ATOM   5079  C   ARG D 149      47.194  17.518  51.746  1.00 10.45           C  
ATOM   5080  O   ARG D 149      46.526  16.932  50.830  1.00 14.83           O  
ATOM   5081  CB  ARG D 149      47.457  20.007  51.668  1.00 13.70           C  
ATOM   5082  CG  ARG D 149      47.164  20.135  50.160  1.00 15.13           C  
ATOM   5083  CD  ARG D 149      45.689  20.032  49.832  1.00 15.44           C  
ATOM   5084  NE  ARG D 149      45.509  20.190  48.381  1.00 10.28           N  
ATOM   5085  CZ  ARG D 149      45.577  21.356  47.733  1.00 13.07           C  
ATOM   5086  NH1 ARG D 149      45.785  22.493  48.398  1.00 13.48           N  
ATOM   5087  NH2 ARG D 149      45.549  21.361  46.390  1.00 13.78           N  
ATOM   5088  N   GLU D 150      48.343  17.023  52.212  1.00 13.88           N  
ATOM   5089  CA  GLU D 150      48.839  15.766  51.647  1.00 11.47           C  
ATOM   5090  C   GLU D 150      47.813  14.690  51.984  1.00 10.49           C  
ATOM   5091  O   GLU D 150      47.462  13.783  51.174  1.00 14.34           O  
ATOM   5092  CB  GLU D 150      50.184  15.419  52.241  1.00 11.34           C  
ATOM   5093  CG  GLU D 150      50.742  14.116  51.711  1.00 14.62           C  
ATOM   5094  CD  GLU D 150      51.991  13.651  52.416  1.00 19.69           C  
ATOM   5095  OE1 GLU D 150      52.383  12.482  52.183  1.00 14.20           O  
ATOM   5096  OE2 GLU D 150      52.603  14.450  53.199  1.00 16.07           O  
ATOM   5097  N   MET D 151      47.282  14.798  53.195  1.00 13.25           N  
ATOM   5098  CA  MET D 151      46.261  13.858  53.596  1.00 12.50           C  
ATOM   5099  C   MET D 151      44.966  14.013  52.803  1.00 15.30           C  
ATOM   5100  O   MET D 151      44.385  13.012  52.315  1.00 14.66           O  
ATOM   5101  CB  MET D 151      45.903  13.993  55.068  1.00 13.73           C  
ATOM   5102  CG  MET D 151      44.805  13.034  55.447  1.00 16.21           C  
ATOM   5103  SD  MET D 151      44.310  13.393  57.191  1.00 16.21           S  
ATOM   5104  CE  MET D 151      43.617  15.023  56.951  1.00 19.29           C  
ATOM   5105  N   SER D 152      44.471  15.253  52.708  1.00 13.33           N  
ATOM   5106  CA  SER D 152      43.181  15.448  52.023  1.00 14.47           C  
ATOM   5107  C   SER D 152      43.276  15.038  50.552  1.00 13.23           C  
ATOM   5108  O   SER D 152      42.321  14.423  50.044  1.00 12.54           O  
ATOM   5109  CB  SER D 152      42.672  16.895  52.183  1.00 15.23           C  
ATOM   5110  OG  SER D 152      43.572  17.850  51.629  1.00 16.08           O  
ATOM   5111  N   ASP D 153      44.414  15.277  49.878  1.00 15.38           N  
ATOM   5112  CA  ASP D 153      44.549  14.870  48.457  1.00 14.09           C  
ATOM   5113  C   ASP D 153      44.415  13.349  48.379  1.00 16.27           C  
ATOM   5114  O   ASP D 153      43.751  12.790  47.461  1.00 16.89           O  
ATOM   5115  CB  ASP D 153      45.929  15.230  47.895  1.00 17.09           C  
ATOM   5116  CG  ASP D 153      46.105  16.725  47.599  1.00 14.10           C  
ATOM   5117  OD1 ASP D 153      47.243  17.039  47.219  1.00 14.63           O  
ATOM   5118  OD2 ASP D 153      45.178  17.563  47.709  1.00 13.00           O  
ATOM   5119  N   MET D 154      45.023  12.663  49.340  1.00  8.87           N  
ATOM   5120  CA  MET D 154      44.981  11.204  49.348  1.00 16.14           C  
ATOM   5121  C   MET D 154      43.570  10.669  49.568  1.00 22.99           C  
ATOM   5122  O   MET D 154      43.170   9.694  48.925  1.00 15.82           O  
ATOM   5123  CB  MET D 154      45.943  10.680  50.416  1.00 23.48           C  
ATOM   5124  CG  MET D 154      46.286   9.183  50.315  1.00 24.49           C  
ATOM   5125  SD  MET D 154      47.368   8.689  51.701  1.00 33.08           S  
ATOM   5126  CE  MET D 154      48.187  10.213  51.999  1.00 20.26           C  
ATOM   5127  N   ILE D 155      42.808  11.294  50.461  1.00 14.27           N  
ATOM   5128  CA  ILE D 155      41.442  10.858  50.687  1.00 11.65           C  
ATOM   5129  C   ILE D 155      40.556  11.107  49.454  1.00 21.57           C  
ATOM   5130  O   ILE D 155      39.808  10.215  49.022  1.00 20.41           O  
ATOM   5131  CB  ILE D 155      40.858  11.558  51.950  1.00 17.27           C  
ATOM   5132  CG1 ILE D 155      41.651  11.073  53.181  1.00 17.40           C  
ATOM   5133  CG2 ILE D 155      39.415  11.216  52.090  1.00 14.52           C  
ATOM   5134  CD1 ILE D 155      41.270  11.828  54.532  1.00 15.10           C  
ATOM   5135  N   LEU D 156      40.653  12.310  48.895  1.00 20.13           N  
ATOM   5136  CA  LEU D 156      39.865  12.670  47.684  1.00 22.71           C  
ATOM   5137  C   LEU D 156      40.260  11.819  46.499  1.00 24.15           C  
ATOM   5138  O   LEU D 156      39.385  11.369  45.731  1.00 19.73           O  
ATOM   5139  CB  LEU D 156      40.034  14.145  47.339  1.00 16.11           C  
ATOM   5140  CG  LEU D 156      39.411  15.005  48.442  1.00 21.74           C  
ATOM   5141  CD1 LEU D 156      39.782  16.478  48.209  1.00 15.21           C  
ATOM   5142  CD2 LEU D 156      37.836  14.785  48.491  1.00 22.82           C  
ATOM   5143  N   GLN D 157      41.561  11.610  46.320  1.00 17.82           N  
ATOM   5144  CA  GLN D 157      41.986  10.737  45.238  1.00 20.14           C  
ATOM   5145  C   GLN D 157      41.334   9.363  45.412  1.00 28.86           C  
ATOM   5146  O   GLN D 157      40.757   8.792  44.474  1.00 22.87           O  
ATOM   5147  CB  GLN D 157      43.493  10.533  45.277  1.00 19.42           C  
ATOM   5148  CG  GLN D 157      43.979   9.547  44.208  1.00 25.66           C  
ATOM   5149  CD  GLN D 157      45.396   9.875  43.784  1.00 30.83           C  
ATOM   5150  OE1 GLN D 157      45.630  10.916  43.168  1.00 36.27           O  
ATOM   5151  NE2 GLN D 157      46.337   9.029  44.133  1.00 32.04           N  
ATOM   5152  N   ALA D 158      41.468   8.813  46.617  1.00 21.14           N  
ATOM   5153  CA  ALA D 158      40.902   7.506  46.929  1.00 22.42           C  
ATOM   5154  C   ALA D 158      39.428   7.439  46.627  1.00 25.24           C  
ATOM   5155  O   ALA D 158      38.925   6.380  46.237  1.00 26.83           O  
ATOM   5156  CB  ALA D 158      41.114   7.177  48.409  1.00 21.70           C  
ATOM   5157  N   GLN D 159      38.731   8.558  46.773  1.00 16.49           N  
ATOM   5158  CA  GLN D 159      37.307   8.561  46.544  1.00 24.96           C  
ATOM   5159  C   GLN D 159      36.986   8.942  45.127  1.00 19.71           C  
ATOM   5160  O   GLN D 159      35.858   9.318  44.827  1.00 20.07           O  
ATOM   5161  CB  GLN D 159      36.627   9.508  47.538  1.00 23.16           C  
ATOM   5162  CG  GLN D 159      36.689   8.913  48.953  1.00 24.52           C  
ATOM   5163  CD  GLN D 159      35.998   9.720  50.043  1.00 25.26           C  
ATOM   5164  OE1 GLN D 159      35.159  10.575  49.782  1.00 20.86           O  
ATOM   5165  NE2 GLN D 159      36.356   9.410  51.301  1.00 17.89           N  
ATOM   5166  N   GLY D 160      38.003   8.871  44.277  1.00 21.92           N  
ATOM   5167  CA  GLY D 160      37.809   9.233  42.886  1.00 21.00           C  
ATOM   5168  C   GLY D 160      37.598  10.695  42.565  1.00 28.55           C  
ATOM   5169  O   GLY D 160      37.121  11.018  41.464  1.00 24.23           O  
ATOM   5170  N   LYS D 161      37.963  11.599  43.487  1.00 23.27           N  
ATOM   5171  CA  LYS D 161      37.785  13.014  43.241  1.00 16.72           C  
ATOM   5172  C   LYS D 161      39.076  13.827  43.068  1.00 15.85           C  
ATOM   5173  O   LYS D 161      39.061  15.038  43.297  1.00 18.40           O  
ATOM   5174  CB  LYS D 161      36.955  13.640  44.381  1.00 23.20           C  
ATOM   5175  CG  LYS D 161      35.564  13.033  44.444  1.00 31.02           C  
ATOM   5176  CD  LYS D 161      34.790  13.457  45.679  1.00 25.94           C  
ATOM   5177  CE  LYS D 161      33.391  12.781  45.654  1.00 30.81           C  
ATOM   5178  NZ  LYS D 161      32.903  12.642  44.201  1.00 36.48           N  
ATOM   5179  N   SER D 162      40.177  13.212  42.660  1.00 18.59           N  
ATOM   5180  CA  SER D 162      41.395  14.018  42.527  1.00 20.23           C  
ATOM   5181  C   SER D 162      41.247  15.131  41.471  1.00 18.69           C  
ATOM   5182  O   SER D 162      42.019  16.094  41.444  1.00 18.26           O  
ATOM   5183  CB  SER D 162      42.559  13.113  42.168  1.00 25.90           C  
ATOM   5184  OG  SER D 162      42.335  12.564  40.877  1.00 24.32           O  
ATOM   5185  N   SER D 163      40.258  15.011  40.584  1.00 17.45           N  
ATOM   5186  CA  SER D 163      40.085  16.051  39.584  1.00 24.04           C  
ATOM   5187  C   SER D 163      39.819  17.439  40.182  1.00 19.59           C  
ATOM   5188  O   SER D 163      39.991  18.439  39.508  1.00 23.98           O  
ATOM   5189  CB  SER D 163      38.930  15.719  38.626  1.00 28.78           C  
ATOM   5190  OG  SER D 163      37.662  15.974  39.233  1.00 26.93           O  
ATOM   5191  N   VAL D 164      39.383  17.498  41.430  1.00 20.32           N  
ATOM   5192  CA  VAL D 164      39.050  18.780  42.058  1.00 19.84           C  
ATOM   5193  C   VAL D 164      40.327  19.550  42.370  1.00 19.86           C  
ATOM   5194  O   VAL D 164      40.300  20.772  42.566  1.00 21.88           O  
ATOM   5195  CB  VAL D 164      38.193  18.645  43.382  1.00 18.47           C  
ATOM   5196  CG1 VAL D 164      36.831  18.037  43.086  1.00 25.08           C  
ATOM   5197  CG2 VAL D 164      38.951  17.842  44.453  1.00 22.01           C  
ATOM   5198  N   PHE D 165      41.459  18.857  42.370  1.00 14.55           N  
ATOM   5199  CA  PHE D 165      42.713  19.570  42.624  1.00 13.45           C  
ATOM   5200  C   PHE D 165      43.787  19.282  41.606  1.00 14.23           C  
ATOM   5201  O   PHE D 165      44.807  19.968  41.573  1.00 15.46           O  
ATOM   5202  CB  PHE D 165      43.232  19.207  44.042  1.00 17.01           C  
ATOM   5203  CG  PHE D 165      43.577  17.727  44.227  1.00 18.52           C  
ATOM   5204  CD1 PHE D 165      44.708  17.181  43.631  1.00 21.00           C  
ATOM   5205  CD2 PHE D 165      42.760  16.880  45.020  1.00 16.97           C  
ATOM   5206  CE1 PHE D 165      45.041  15.832  43.808  1.00 19.86           C  
ATOM   5207  CE2 PHE D 165      43.082  15.539  45.193  1.00 16.81           C  
ATOM   5208  CZ  PHE D 165      44.222  15.008  44.594  1.00 20.40           C  
ATOM   5209  N   ASP D 166      43.603  18.260  40.773  1.00 18.89           N  
ATOM   5210  CA  ASP D 166      44.700  17.902  39.883  1.00 21.40           C  
ATOM   5211  C   ASP D 166      44.663  18.338  38.421  1.00 19.34           C  
ATOM   5212  O   ASP D 166      45.623  18.104  37.696  1.00 27.62           O  
ATOM   5213  CB  ASP D 166      45.075  16.391  40.029  1.00 20.93           C  
ATOM   5214  CG  ASP D 166      44.089  15.444  39.374  1.00 22.12           C  
ATOM   5215  OD1 ASP D 166      44.197  14.236  39.636  1.00 21.89           O  
ATOM   5216  OD2 ASP D 166      43.238  15.879  38.593  1.00 17.82           O  
ATOM   5217  N   THR D 167      43.605  19.037  38.024  1.00 21.36           N  
ATOM   5218  CA  THR D 167      43.522  19.590  36.678  1.00 27.34           C  
ATOM   5219  C   THR D 167      42.783  20.932  36.723  1.00 22.21           C  
ATOM   5220  O   THR D 167      41.961  21.208  37.622  1.00 23.52           O  
ATOM   5221  CB  THR D 167      42.759  18.683  35.697  1.00 28.83           C  
ATOM   5222  OG1 THR D 167      41.390  18.652  36.095  1.00 28.60           O  
ATOM   5223  CG2 THR D 167      43.363  17.240  35.682  1.00 28.82           C  
ATOM   5224  N   ALA D 168      43.115  21.776  35.762  1.00 23.51           N  
ATOM   5225  CA  ALA D 168      42.517  23.096  35.619  1.00 26.73           C  
ATOM   5226  C   ALA D 168      40.990  22.972  35.441  1.00 31.48           C  
ATOM   5227  O   ALA D 168      40.221  23.531  36.242  1.00 31.56           O  
ATOM   5228  CB  ALA D 168      43.145  23.771  34.429  1.00 25.87           C  
ATOM   5229  N   GLN D 169      40.550  22.244  34.411  1.00 35.61           N  
ATOM   5230  CA  GLN D 169      39.085  22.032  34.197  1.00 36.99           C  
ATOM   5231  C   GLN D 169      38.486  21.376  35.445  1.00 37.68           C  
ATOM   5232  O   GLN D 169      37.392  21.759  35.933  1.00 36.74           O  
ATOM   5233  CB  GLN D 169      38.762  21.083  33.026  1.00 35.98           C  
ATOM   5234  CG  GLN D 169      37.212  20.948  32.897  1.00 39.48           C  
ATOM   5235  CD  GLN D 169      36.707  19.911  31.869  1.00 42.22           C  
ATOM   5236  OE1 GLN D 169      37.222  19.831  30.759  1.00 45.69           O  
ATOM   5237  NE2 GLN D 169      35.667  19.145  32.244  1.00 35.27           N  
ATOM   5238  N   GLY D 170      39.204  20.362  35.939  1.00 37.72           N  
ATOM   5239  CA  GLY D 170      38.768  19.669  37.137  1.00 31.69           C  
ATOM   5240  C   GLY D 170      38.486  20.693  38.203  1.00 30.58           C  
ATOM   5241  O   GLY D 170      37.409  20.723  38.755  1.00 37.15           O  
ATOM   5242  N   PHE D 171      39.447  21.566  38.491  1.00 34.96           N  
ATOM   5243  CA  PHE D 171      39.252  22.583  39.532  1.00 29.78           C  
ATOM   5244  C   PHE D 171      38.174  23.595  39.214  1.00 32.00           C  
ATOM   5245  O   PHE D 171      37.440  24.005  40.108  1.00 36.44           O  
ATOM   5246  CB  PHE D 171      40.539  23.379  39.770  1.00 25.66           C  
ATOM   5247  CG  PHE D 171      40.364  24.571  40.713  1.00 29.24           C  
ATOM   5248  CD1 PHE D 171      40.426  24.413  42.091  1.00 21.11           C  
ATOM   5249  CD2 PHE D 171      40.149  25.857  40.212  1.00 31.95           C  
ATOM   5250  CE1 PHE D 171      40.286  25.517  42.959  1.00 27.12           C  
ATOM   5251  CE2 PHE D 171      39.997  26.945  41.065  1.00 25.94           C  
ATOM   5252  CZ  PHE D 171      40.070  26.782  42.432  1.00 26.98           C  
ATOM   5253  N   LEU D 172      38.109  24.039  37.962  1.00 34.07           N  
ATOM   5254  CA  LEU D 172      37.124  25.069  37.578  1.00 33.57           C  
ATOM   5255  C   LEU D 172      35.637  24.792  37.896  1.00 34.03           C  
ATOM   5256  O   LEU D 172      34.784  25.660  37.741  1.00 40.52           O  
ATOM   5257  CB  LEU D 172      37.314  25.455  36.106  1.00 34.83           C  
ATOM   5258  CG  LEU D 172      38.544  26.397  35.935  1.00 34.16           C  
ATOM   5259  CD1 LEU D 172      38.850  26.664  34.472  1.00 30.94           C  
ATOM   5260  CD2 LEU D 172      38.305  27.711  36.730  1.00 32.10           C  
ATOM   5261  N   LYS D 173      35.299  23.623  38.406  1.00 40.88           N  
ATOM   5262  CA  LYS D 173      33.884  23.431  38.725  1.00 40.89           C  
ATOM   5263  C   LYS D 173      33.421  23.929  40.103  1.00 43.24           C  
ATOM   5264  O   LYS D 173      32.261  24.361  40.260  1.00 41.25           O  
ATOM   5265  CB  LYS D 173      33.514  21.971  38.557  1.00 36.03           C  
ATOM   5266  CG  LYS D 173      33.555  21.583  37.135  1.00 31.39           C  
ATOM   5267  CD  LYS D 173      33.057  20.161  36.964  1.00 36.84           C  
ATOM   5268  CE  LYS D 173      33.529  19.673  35.615  1.00 37.48           C  
ATOM   5269  NZ  LYS D 173      34.764  20.498  35.332  1.00 31.06           N  
ATOM   5270  N   SER D 174      34.328  23.882  41.086  1.00 35.12           N  
ATOM   5271  CA  SER D 174      34.022  24.298  42.446  1.00 39.76           C  
ATOM   5272  C   SER D 174      34.975  25.423  42.954  1.00 42.51           C  
ATOM   5273  O   SER D 174      35.299  25.404  44.177  1.00 43.54           O  
ATOM   5274  CB  SER D 174      34.090  23.058  43.368  1.00 40.54           C  
ATOM   5275  OG  SER D 174      35.149  22.161  42.983  1.00 45.43           O  
TER    5276      SER D 174                                                      
END
MOLECULE T0505_6_84_201_280.pdb
ATOM      1  N   LYS     6      34.876   8.083  54.296  1.00 32.10          
ATOM      2  CA  LYS     6      35.022   8.794  55.595  1.00 30.60          
ATOM      3  C   LYS     6      34.171  10.050  55.575  1.00 30.04          
ATOM      4  O   LYS     6      33.987  10.662  54.513  1.00 31.08          
ATOM      5  CB  LYS     6      36.491   9.159  55.851  1.00 31.17          
ATOM      6  CG  LYS     6      37.392   7.952  56.020  1.00 33.54          
ATOM      7  CD  LYS     6      37.138   7.255  57.363  1.00 35.57          
ATOM      8  CE  LYS     6      38.133   6.150  57.642  1.00 36.27          
ATOM      9  NZ  LYS     6      37.853   4.949  56.798  1.00 38.14          
ATOM     10  N   GLN     7      33.690  10.451  56.753  1.00 27.59          
ATOM     11  CA  GLN     7      32.685  11.487  56.895  0.50 26.89          
ATOM     13  C   GLN     7      33.138  12.631  57.799  1.00 25.56          
ATOM     14  O   GLN     7      32.526  13.695  57.807  1.00 25.38          
ATOM     15  CB  GLN     7      31.426  10.868  57.485  0.50 26.93          
ATOM     17  CG  GLN     7      30.647  10.009  56.503  0.50 28.57          
ATOM     19  CD  GLN     7      29.661  10.836  55.717  0.50 29.35          
ATOM     21  OE1 GLN     7      29.854  11.087  54.530  0.50 30.06          
ATOM     23  NE2 GLN     7      28.612  11.308  56.395  0.50 29.45          
ATOM     25  N   LEU     8      34.200  12.400  58.577  0.50 24.45          
ATOM     27  CA  LEU     8      34.661  13.377  59.583  0.50 23.92          
ATOM     29  C   LEU     8      36.187  13.456  59.657  0.50 23.34          
ATOM     31  O   LEU     8      36.847  12.452  59.952  0.50 23.15          
ATOM     33  CB  LEU     8      34.101  13.028  60.972  0.50 24.05          
ATOM     35  CG  LEU     8      34.601  13.825  62.197  0.50 24.47          
ATOM     37  CD1 LEU     8      34.433  15.330  62.006  0.50 23.47          
ATOM     39  CD2 LEU     8      33.919  13.376  63.497  0.50 23.31          
ATOM     41  N   LEU     9      36.730  14.650  59.413  1.00 23.12          
ATOM     42  CA  LEU     9      38.176  14.891  59.468  1.00 23.12          
ATOM     43  C   LEU     9      38.484  15.724  60.712  1.00 22.53          
ATOM     44  O   LEU     9      37.954  16.839  60.871  1.00 23.46          
ATOM     45  CB  LEU     9      38.656  15.617  58.198  1.00 23.25          
ATOM     46  CG  LEU     9      40.093  16.142  58.238  1.00 25.00          
ATOM     47  CD1 LEU     9      41.072  14.935  58.280  1.00 26.13          
ATOM     48  CD2 LEU     9      40.418  17.054  57.039  1.00 24.10          
ATOM     49  N   ALA    10      39.282  15.171  61.620  1.00 22.09          
ATOM     50  CA  ALA    10      39.697  15.881  62.836  1.00 23.55          
ATOM     51  C   ALA    10      41.197  16.143  62.812  1.00 24.22          
ATOM     52  O   ALA    10      41.973  15.196  62.631  1.00 24.53          
ATOM     53  CB  ALA    10      39.325  15.052  64.049  1.00 25.36          
ATOM     54  N   LEU    11      41.581  17.415  62.969  1.00 23.75          
ATOM     55  CA  LEU    11      42.967  17.843  62.829  0.50 23.98          
ATOM     57  C   LEU    11      43.477  18.526  64.105  1.00 23.85          
ATOM     58  O   LEU    11      42.800  19.360  64.673  1.00 23.47          
ATOM     59  CB  LEU    11      43.102  18.860  61.664  0.50 24.46          
ATOM     61  CG  LEU    11      42.423  18.598  60.316  0.50 24.12          
ATOM     63  CD1 LEU    11      41.927  19.862  59.697  0.50 27.02          
ATOM     65  CD2 LEU    11      43.374  17.912  59.348  0.50 26.73          
ATOM     67  N   ASN    12      44.706  18.206  64.500  1.00 23.73          
ATOM     68  CA  ASN    12      45.425  19.070  65.448  1.00 23.73          
ATOM     69  C   ASN    12      45.664  20.434  64.786  1.00 23.97          
ATOM     70  O   ASN    12      45.753  20.542  63.562  1.00 23.62          
ATOM     71  CB  ASN    12      46.846  18.547  65.770  1.00 23.79          
ATOM     72  CG  ASN    12      46.888  17.356  66.714  1.00 25.38          
ATOM     73  OD1 ASN    12      47.905  16.688  66.770  1.00 26.57          
ATOM     74  ND2 ASN    12      45.834  17.118  67.483  1.00 25.65          
ATOM     75  N   ILE    13      45.828  21.453  65.605  1.00 23.30          
ATOM     76  CA  ILE    13      46.238  22.768  65.137  1.00 23.99          
ATOM     77  C   ILE    13      47.789  22.837  65.112  1.00 23.85          
ATOM     78  O   ILE    13      48.420  22.815  64.037  1.00 23.87          
ATOM     79  CB  ILE    13      45.632  23.862  66.060  1.00 22.93          
ATOM     80  CG1 ILE    13      44.086  23.825  65.985  1.00 24.81          
ATOM     81  CG2 ILE    13      46.199  25.239  65.708  1.00 23.98          
ATOM     82  CD  ILE    13      43.379  24.872  66.896  1.00 24.97          
ATOM     83  N   ASP    14      48.402  22.882  66.293  1.00 24.30          
ATOM     84  CA  ASP    14      49.864  22.869  66.407  1.00 24.52          
ATOM     85  C   ASP    14      50.378  21.560  65.861  1.00 24.12          
ATOM     86  O   ASP    14      49.775  20.505  66.099  1.00 24.08          
ATOM     87  CB  ASP    14      50.303  23.017  67.872  1.00 25.34          
ATOM     88  CG  ASP    14      49.842  24.344  68.475  1.00 27.52          
ATOM     89  OD1 ASP    14      50.553  25.363  68.292  1.00 29.57          
ATOM     90  OD2 ASP    14      48.759  24.366  69.108  1.00 29.16          
ATOM     91  N   GLY    15      51.474  21.643  65.104  1.00 24.35          
ATOM     92  CA  GLY    15      52.109  20.442  64.523  1.00 24.03          
ATOM     93  C   GLY    15      51.370  19.759  63.375  1.00 24.06          
ATOM     94  O   GLY    15      51.829  18.728  62.915  1.00 24.44          
ATOM     95  N   ALA    16      50.237  20.303  62.919  1.00 24.06          
ATOM     96  CA  ALA    16      49.507  19.703  61.805  1.00 25.16          
ATOM     97  C   ALA    16      48.940  20.748  60.833  1.00 25.27          
ATOM     98  O   ALA    16      49.489  20.959  59.745  1.00 26.24          
ATOM     99  CB  ALA    16      48.424  18.744  62.299  1.00 25.08          
ATOM    100  N   LEU    17      47.865  21.415  61.239  1.00 24.72          
ATOM    101  CA  LEU    17      47.293  22.507  60.467  0.50 24.60          
ATOM    103  C   LEU    17      48.303  23.653  60.282  1.00 24.79          
ATOM    104  O   LEU    17      48.373  24.261  59.223  1.00 24.69          
ATOM    105  CB  LEU    17      46.048  23.045  61.188  0.50 24.67          
ATOM    107  CG  LEU    17      45.298  24.166  60.484  0.50 22.73          
ATOM    109  CD1 LEU    17      44.590  23.620  59.290  0.50 21.17          
ATOM    111  CD2 LEU    17      44.307  24.780  61.426  0.50 24.59          
ATOM    113  N   LEU    18      49.063  23.947  61.328  1.00 24.24          
ATOM    114  CA  LEU    18      49.948  25.112  61.313  1.00 24.06          
ATOM    115  C   LEU    18      51.362  24.684  61.027  1.00 23.97          
ATOM    116  O   LEU    18      51.832  23.682  61.581  1.00 23.46          
ATOM    117  CB  LEU    18      49.979  25.804  62.674  1.00 24.49          
ATOM    118  CG  LEU    18      48.695  26.396  63.242  1.00 26.89          
ATOM    119  CD1 LEU    18      49.022  27.243  64.441  1.00 28.82          
ATOM    120  CD2 LEU    18      47.977  27.204  62.171  1.00 30.68          
ATOM    121  N   ARG    19      52.048  25.466  60.196  1.00 22.83          
ATOM    122  CA  ARG    19      53.493  25.358  60.033  1.00 22.38          
ATOM    123  C   ARG    19      54.177  25.715  61.348  1.00 23.88          
ATOM    124  O   ARG    19      53.533  26.298  62.230  1.00 24.58          
ATOM    125  CB  ARG    19      53.948  26.318  58.936  1.00 21.76          
ATOM    126  CG  ARG    19      53.468  25.901  57.548  1.00 22.17          
ATOM    127  CD  ARG    19      53.934  26.920  56.486  1.00 22.97          
ATOM    128  NE  ARG    19      55.382  27.057  56.473  1.00 26.02          
ATOM    129  CZ  ARG    19      56.201  26.234  55.821  1.00 26.76          
ATOM    130  NH1 ARG    19      55.711  25.222  55.115  1.00 24.02          
ATOM    131  NH2 ARG    19      57.517  26.439  55.854  1.00 27.49          
ATOM    132  N   SER    20      55.474  25.442  61.480  1.00 23.98          
ATOM    133  CA  SER    20      56.170  25.724  62.749  0.50 24.69          
ATOM    135  C   SER    20      56.314  27.208  63.018  1.00 25.45          
ATOM    136  O   SER    20      56.571  27.609  64.158  1.00 27.08          
ATOM    137  CB  SER    20      57.532  25.038  62.816  0.50 24.83          
ATOM    139  OG  SER    20      58.378  25.470  61.782  0.50 22.79          
ATOM    141  N   ASN    21      56.145  28.033  61.990  1.00 25.31          
ATOM    142  CA  ASN    21      56.128  29.493  62.202  1.00 26.85          
ATOM    143  C   ASN    21      54.719  30.047  62.494  1.00 27.13          
ATOM    144  O   ASN    21      54.530  31.272  62.574  1.00 28.54          
ATOM    145  CB  ASN    21      56.766  30.217  61.013  1.00 27.65          
ATOM    146  CG  ASN    21      55.984  30.014  59.721  1.00 29.55          
ATOM    147  OD1 ASN    21      54.897  29.445  59.739  1.00 28.27          
ATOM    148  ND2 ASN    21      56.549  30.460  58.590  1.00 31.07          
ATOM    149  N   GLY    22      53.737  29.163  62.628  1.00 25.53          
ATOM    150  CA  GLY    22      52.387  29.527  63.002  1.00 25.70          
ATOM    151  C   GLY    22      51.485  29.910  61.853  1.00 25.79          
ATOM    152  O   GLY    22      50.292  30.178  62.058  1.00 27.47          
ATOM    153  N   LYS    23      52.021  29.911  60.645  1.00 24.24          
ATOM    154  CA  LYS    23      51.223  30.238  59.465  1.00 25.66          
ATOM    155  C   LYS    23      50.427  29.032  58.983  1.00 25.17          
ATOM    156  O   LYS    23      50.855  27.911  59.153  1.00 24.56          
ATOM    157  CB  LYS    23      52.117  30.762  58.330  1.00 25.43          
ATOM    158  CG  LYS    23      52.785  32.105  58.702  1.00 27.84          
ATOM    159  CD  LYS    23      53.244  32.848  57.454  1.00 30.68          
ATOM    160  CE  LYS    23      53.760  34.234  57.782  1.00 28.94          
ATOM    161  NZ  LYS    23      52.715  35.300  57.751  1.00 29.37          
ATOM    162  N   ILE    24      49.249  29.288  58.406  1.00 25.05          
ATOM    163  CA  ILE    24      48.492  28.250  57.692  1.00 24.61          
ATOM    164  C   ILE    24      48.836  28.392  56.223  1.00 24.55          
ATOM    165  O   ILE    24      48.561  29.435  55.618  1.00 23.98          
ATOM    166  CB  ILE    24      46.968  28.406  57.879  1.00 24.43          
ATOM    167  CG1 ILE    24      46.617  28.469  59.371  1.00 26.44          
ATOM    168  CG2 ILE    24      46.215  27.250  57.165  1.00 26.26          
ATOM    169  CD  ILE    24      45.173  28.887  59.631  1.00 28.57          
ATOM    170  N   HSD    25      49.450  27.361  55.639  1.00 23.24          
ATOM    171  CA  HSD    25      49.853  27.392  54.219  1.00 23.46          
ATOM    172  C   HSD    25      48.615  27.448  53.296  1.00 23.13          
ATOM    173  O   HSD    25      47.581  26.857  53.600  1.00 22.32          
ATOM    174  CB  HSD    25      50.711  26.150  53.888  1.00 23.35          
ATOM    175  CG  HSD    25      51.489  26.271  52.617  1.00 24.93          
ATOM    176  ND1 HSD    25      50.970  25.915  51.391  1.00 25.91          
ATOM    177  CD2 HSD    25      52.750  26.707  52.383  1.00 25.47          
ATOM    178  CE1 HSD    25      51.877  26.134  50.452  1.00 29.41          
ATOM    179  NE2 HSD    25      52.966  26.617  51.029  1.00 27.47          
ATOM    180  N   GLN    26      48.711  28.178  52.186  1.00 23.33          
ATOM    181  CA  GLN    26      47.586  28.242  51.235  1.00 24.16          
ATOM    182  C   GLN    26      47.101  26.853  50.791  1.00 23.73          
ATOM    183  O   GLN    26      45.909  26.616  50.628  1.00 23.72          
ATOM    184  CB  GLN    26      47.951  29.079  50.005  1.00 25.56          
ATOM    185  CG  GLN    26      46.757  29.297  49.048  1.00 27.94          
ATOM    186  CD  GLN    26      45.643  30.104  49.695  1.00 29.07          
ATOM    187  OE1 GLN    26      45.884  31.167  50.253  1.00 31.50          
ATOM    188  NE2 GLN    26      44.424  29.598  49.627  1.00 31.03          
ATOM    189  N   ALA    27      48.026  25.925  50.620  1.00 23.38          
ATOM    190  CA  ALA    27      47.657  24.552  50.203  1.00 23.29          
ATOM    191  C   ALA    27      46.735  23.850  51.206  1.00 22.81          
ATOM    192  O   ALA    27      45.839  23.056  50.834  1.00 23.09          
ATOM    193  CB  ALA    27      48.915  23.708  49.930  1.00 22.66          
ATOM    194  N   THR    28      46.933  24.179  52.474  1.00 22.59          
ATOM    195  CA  THR    28      46.164  23.629  53.542  1.00 22.61          
ATOM    196  C   THR    28      44.731  24.189  53.494  1.00 22.57          
ATOM    197  O   THR    28      43.758  23.433  53.647  1.00 21.44          
ATOM    198  CB  THR    28      46.837  23.968  54.896  1.00 22.91          
ATOM    199  OG1 THR    28      48.216  23.533  54.845  1.00 24.83          
ATOM    200  CG2 THR    28      46.126  23.252  56.001  1.00 22.58          
ATOM    201  N   LYS    29      44.627  25.501  53.288  1.00 22.30          
ATOM    202  CA  LYS    29      43.359  26.181  53.109  1.00 23.06          
ATOM    203  C   LYS    29      42.612  25.581  51.924  1.00 23.15          
ATOM    204  O   LYS    29      41.420  25.279  52.029  1.00 22.86          
ATOM    205  CB  LYS    29      43.599  27.683  52.910  1.00 23.25          
ATOM    206  CG  LYS    29      44.128  28.315  54.166  1.00 26.35          
ATOM    207  CD  LYS    29      44.230  29.796  54.031  1.00 31.59          
ATOM    208  CE  LYS    29      44.681  30.363  55.349  1.00 34.35          
ATOM    209  NZ  LYS    29      44.844  31.817  55.183  1.00 37.71          
ATOM    210  N   ASP    30      43.318  25.381  50.805  1.00 23.81          
ATOM    211  CA  ASP    30      42.702  24.826  49.608  1.00 24.01          
ATOM    212  C   ASP    30      42.220  23.391  49.847  1.00 23.94          
ATOM    213  O   ASP    30      41.125  23.013  49.411  1.00 23.20          
ATOM    214  CB  ASP    30      43.652  24.895  48.400  1.00 24.83          
ATOM    215  CG  ASP    30      44.001  26.344  47.987  1.00 28.08          
ATOM    216  OD1 ASP    30      43.319  27.297  48.421  1.00 31.03          
ATOM    217  OD2 ASP    30      44.973  26.531  47.207  1.00 30.74          
ATOM    218  N   ALA    31      43.032  22.600  50.554  1.00 22.91          
ATOM    219  CA  ALA    31      42.656  21.219  50.851  1.00 23.25          
ATOM    220  C   ALA    31      41.406  21.159  51.735  1.00 22.86          
ATOM    221  O   ALA    31      40.491  20.378  51.456  1.00 23.53          
ATOM    222  CB  ALA    31      43.832  20.452  51.501  1.00 22.70          
ATOM    223  N   ILE    32      41.345  22.004  52.763  1.00 22.86          
ATOM    224  CA  ILE    32      40.174  22.022  53.676  1.00 24.08          
ATOM    225  C   ILE    32      38.897  22.482  52.960  1.00 24.09          
ATOM    226  O   ILE    32      37.834  21.899  53.157  1.00 23.39          
ATOM    227  CB  ILE    32      40.478  22.819  54.970  1.00 24.17          
ATOM    228  CG1 ILE    32      41.480  22.018  55.828  1.00 26.95          
ATOM    229  CG2 ILE    32      39.216  23.101  55.802  1.00 25.00          
ATOM    230  CD  ILE    32      42.097  22.820  56.869  1.00 33.14          
ATOM    231  N   GLU    33      39.009  23.502  52.110  1.00 25.36          
ATOM    232  CA  GLU    33      37.880  23.960  51.299  1.00 27.05          
ATOM    233  C   GLU    33      37.351  22.819  50.425  1.00 26.16          
ATOM    234  O   GLU    33      36.147  22.583  50.344  1.00 26.64          
ATOM    235  CB  GLU    33      38.326  25.123  50.405  1.00 27.23          
ATOM    236  CG  GLU    33      37.236  25.620  49.481  1.00 29.62          
ATOM    237  CD  GLU    33      37.638  26.869  48.708  1.00 32.79          
ATOM    238  OE1 GLU    33      38.853  27.052  48.407  1.00 39.72          
ATOM    239  OE2 GLU    33      36.724  27.664  48.377  1.00 40.81          
ATOM    240  N   TYR    34      38.261  22.092  49.793  1.00 24.96          
ATOM    241  CA  TYR    34      37.861  20.961  48.968  1.00 25.67          
ATOM    242  C   TYR    34      37.136  19.878  49.790  1.00 25.32          
ATOM    243  O   TYR    34      36.093  19.371  49.368  1.00 26.28          
ATOM    244  CB  TYR    34      39.080  20.371  48.269  1.00 26.00          
ATOM    245  CG  TYR    34      38.715  19.304  47.255  1.00 27.85          
ATOM    246  CD1 TYR    34      38.370  19.649  45.954  1.00 28.71          
ATOM    247  CD2 TYR    34      38.702  17.955  47.609  1.00 28.41          
ATOM    248  CE1 TYR    34      38.040  18.675  45.016  1.00 30.02          
ATOM    249  CE2 TYR    34      38.376  16.967  46.676  1.00 30.06          
ATOM    250  CZ  TYR    34      38.041  17.339  45.392  1.00 29.85          
ATOM    251  OH  TYR    34      37.703  16.375  44.472  1.00 31.87          
ATOM    252  N   VAL    35      37.707  19.518  50.936  1.00 24.93          
ATOM    253  CA  VAL    35      37.145  18.495  51.844  1.00 25.76          
ATOM    254  C   VAL    35      35.690  18.832  52.214  1.00 26.68          
ATOM    255  O   VAL    35      34.787  17.983  52.122  1.00 26.22          
ATOM    256  CB  VAL    35      38.010  18.369  53.144  1.00 25.70          
ATOM    257  CG1 VAL    35      37.301  17.518  54.201  1.00 25.36          
ATOM    258  CG2 VAL    35      39.396  17.791  52.816  1.00 27.20          
ATOM    259  N   LYS    36      35.484  20.081  52.631  1.00 26.28          
ATOM    260  CA  LYS    36      34.158  20.606  52.971  1.00 27.35          
ATOM    261  C   LYS    36      33.184  20.574  51.782  1.00 28.31          
ATOM    262  O   LYS    36      32.012  20.256  51.950  1.00 28.21          
ATOM    263  CB  LYS    36      34.298  22.018  53.522  1.00 27.03          
ATOM    264  CG  LYS    36      34.806  22.052  54.954  1.00 28.56          
ATOM    265  CD  LYS    36      34.950  23.494  55.483  1.00 27.72          
ATOM    266  CE  LYS    36      33.587  24.133  55.783  1.00 32.60          
ATOM    267  NZ  LYS    36      32.768  23.365  56.795  1.00 34.40          
ATOM    268  N   LYS    37      33.679  20.892  50.589  1.00 29.26          
ATOM    269  CA  LYS    37      32.875  20.910  49.367  1.00 31.00          
ATOM    270  C   LYS    37      32.397  19.483  49.050  1.00 30.88          
ATOM    271  O   LYS    37      31.316  19.287  48.493  1.00 30.71          
ATOM    272  CB  LYS    37      33.714  21.498  48.216  1.00 30.85          
ATOM    273  CG  LYS    37      32.965  21.866  46.941  1.00 33.81          
ATOM    274  CD  LYS    37      33.954  22.296  45.849  1.00 33.63          
ATOM    275  CE  LYS    37      33.263  22.487  44.506  1.00 37.30          
ATOM    276  NZ  LYS    37      34.147  22.033  43.390  1.00 40.68          
ATOM    277  N   LYS    38      33.195  18.495  49.455  1.00 31.07          
ATOM    278  CA  LYS    38      32.858  17.080  49.266  1.00 31.54          
ATOM    279  C   LYS    38      31.920  16.521  50.339  1.00 31.64          
ATOM    280  O   LYS    38      31.583  15.336  50.311  1.00 32.09          
ATOM    281  CB  LYS    38      34.130  16.235  49.180  1.00 31.54          
ATOM    282  CG  LYS    38      34.977  16.547  47.962  1.00 33.50          
ATOM    283  CD  LYS    38      34.261  16.225  46.641  1.00 37.72          
ATOM    284  CE  LYS    38      34.129  14.711  46.450  1.00 41.39          
ATOM    285  NZ  LYS    38      33.660  14.331  45.082  1.00 42.99          
ATOM    286  N   GLY    39      31.523  17.364  51.288  1.00 30.54          
ATOM    287  CA  GLY    39      30.557  16.984  52.308  1.00 30.28          
ATOM    288  C   GLY    39      31.143  16.408  53.584  1.00 29.53          
ATOM    289  O   GLY    39      30.408  15.969  54.465  1.00 30.24          
ATOM    290  N   ILE    40      32.463  16.437  53.714  1.00 28.20          
ATOM    291  CA  ILE    40      33.113  15.914  54.912  1.00 27.30          
ATOM    292  C   ILE    40      33.134  16.977  56.021  1.00 26.53          
ATOM    293  O   ILE    40      33.489  18.126  55.766  1.00 25.76          
ATOM    294  CB  ILE    40      34.545  15.411  54.560  1.00 26.64          
ATOM    295  CG1 ILE    40      34.433  14.216  53.596  1.00 28.03          
ATOM    296  CG2 ILE    40      35.357  15.077  55.834  1.00 25.77          
ATOM    297  CD  ILE    40      35.690  13.989  52.719  1.00 26.43          
ATOM    298  N   TYR    41      32.759  16.591  57.243  1.00 26.02          
ATOM    299  CA  TYR    41      32.716  17.522  58.373  1.00 25.38          
ATOM    300  C   TYR    41      34.156  17.697  58.843  1.00 25.27          
ATOM    301  O   TYR    41      34.865  16.693  59.047  1.00 24.68          
ATOM    302  CB  TYR    41      31.909  16.899  59.494  1.00 26.37          
ATOM    303  CG  TYR    41      31.554  17.785  60.700  1.00 27.48          
ATOM    304  CD1 TYR    41      30.309  18.382  60.786  1.00 28.59          
ATOM    305  CD2 TYR    41      32.450  17.970  61.775  1.00 28.27          
ATOM    306  CE1 TYR    41      29.947  19.155  61.889  1.00 29.47          
ATOM    307  CE2 TYR    41      32.092  18.754  62.897  1.00 29.43          
ATOM    308  CZ  TYR    41      30.827  19.332  62.936  1.00 29.11          
ATOM    309  OH  TYR    41      30.409  20.096  64.013  1.00 28.75          
ATOM    310  N   VAL    42      34.608  18.942  58.958  1.00 23.79          
ATOM    311  CA  VAL    42      36.002  19.208  59.371  1.00 23.71          
ATOM    312  C   VAL    42      36.002  19.914  60.731  1.00 24.94          
ATOM    313  O   VAL    42      35.384  20.981  60.907  1.00 25.46          
ATOM    314  CB  VAL    42      36.794  20.060  58.336  1.00 22.33          
ATOM    315  CG1 VAL    42      38.207  20.363  58.867  1.00 24.54          
ATOM    316  CG2 VAL    42      36.846  19.387  56.961  1.00 20.26          
ATOM    317  N   THR    43      36.712  19.341  61.692  1.00 25.37          
ATOM    318  CA  THR    43      36.816  19.992  62.990  1.00 26.04          
ATOM    319  C   THR    43      38.256  19.976  63.496  1.00 24.85          
ATOM    320  O   THR    43      39.131  19.283  62.926  1.00 25.08          
ATOM    321  CB  THR    43      35.881  19.367  64.023  1.00 26.77          
ATOM    322  OG1 THR    43      35.868  20.214  65.194  1.00 30.70          
ATOM    323  CG2 THR    43      36.333  17.945  64.392  1.00 26.35          
ATOM    324  N   LEU    44      38.480  20.721  64.568  1.00 23.09          
ATOM    325  CA  LEU    44      39.802  20.826  65.170  1.00 23.27          
ATOM    326  C   LEU    44      39.761  20.093  66.507  1.00 23.03          
ATOM    327  O   LEU    44      38.747  20.137  67.234  1.00 24.38          
ATOM    328  CB  LEU    44      40.193  22.306  65.365  1.00 22.31          
ATOM    329  CG  LEU    44      40.108  23.141  64.071  1.00 23.25          
ATOM    330  CD1 LEU    44      40.439  24.642  64.366  1.00 26.01          
ATOM    331  CD2 LEU    44      41.059  22.559  62.992  1.00 25.08          
ATOM    332  N   VAL    45      40.835  19.370  66.799  1.00 22.18          
ATOM    333  CA  VAL    45      40.983  18.659  68.061  0.50 22.15          
ATOM    335  C   VAL    45      42.315  19.106  68.647  1.00 22.54          
ATOM    336  O   VAL    45      43.365  18.795  68.091  1.00 23.44          
ATOM    337  CB  VAL    45      40.882  17.111  67.863  0.50 22.53          
ATOM    339  CG1 VAL    45      41.743  16.626  66.699  0.50 20.55          
ATOM    341  CG2 VAL    45      41.216  16.364  69.150  0.50 22.45          
ATOM    343  N   THR    46      42.268  19.832  69.763  1.00 21.76          
ATOM    344  CA  THR    46      43.431  20.613  70.192  1.00 21.81          
ATOM    345  C   THR    46      43.554  20.762  71.691  1.00 21.47          
ATOM    346  O   THR    46      42.546  20.719  72.425  1.00 21.29          
ATOM    347  CB  THR    46      43.389  22.038  69.512  1.00 23.35          
ATOM    348  OG1 THR    46      44.618  22.725  69.750  1.00 23.07          
ATOM    349  CG2 THR    46      42.189  22.914  70.046  1.00 24.16          
ATOM    350  N   ASN    47      44.793  20.935  72.130  1.00 21.21          
ATOM    351  CA  ASN    47      45.074  21.417  73.490  1.00 22.60          
ATOM    352  C   ASN    47      44.889  22.927  73.644  1.00 22.42          
ATOM    353  O   ASN    47      44.891  23.422  74.773  1.00 22.92          
ATOM    354  CB  ASN    47      46.514  21.061  73.901  1.00 22.46          
ATOM    355  CG  ASN    47      46.706  19.558  74.061  1.00 25.07          
ATOM    356  OD1 ASN    47      45.756  18.830  74.350  1.00 28.70          
ATOM    357  ND2 ASN    47      47.919  19.099  73.874  1.00 26.45          
ATOM    358  N   ARG    48      44.766  23.642  72.527  1.00 21.70          
ATOM    359  CA  ARG    48      44.621  25.128  72.590  1.00 22.31          
ATOM    360  C   ARG    48      43.334  25.546  73.281  1.00 21.33          
ATOM    361  O   ARG    48      42.367  24.793  73.281  1.00 21.43          
ATOM    362  CB  ARG    48      44.602  25.701  71.185  1.00 22.83          
ATOM    363  CG  ARG    48      46.020  25.748  70.580  1.00 26.34          
ATOM    364  CD  ARG    48      46.039  26.722  69.403  1.00 27.37          
ATOM    365  NE  ARG    48      47.403  26.804  68.879  1.00 28.67          
ATOM    366  CZ  ARG    48      47.886  27.842  68.223  1.00 30.50          
ATOM    367  NH1 ARG    48      47.106  28.904  68.015  1.00 30.63          
ATOM    368  NH2 ARG    48      49.151  27.813  67.782  1.00 28.11          
ATOM    369  N   HSD    49      43.340  26.753  73.837  1.00 20.28          
ATOM    370  CA  HSD    49      42.122  27.286  74.438  1.00 20.93          
ATOM    371  C   HSD    49      41.112  27.590  73.339  1.00 20.60          
ATOM    372  O   HSD    49      41.482  27.707  72.139  1.00 19.38          
ATOM    373  CB  HSD    49      42.432  28.486  75.362  1.00 20.36          
ATOM    374  CG  HSD    49      43.039  29.684  74.687  1.00 22.13          
ATOM    375  ND1 HSD    49      42.293  30.600  73.965  1.00 22.00          
ATOM    376  CD2 HSD    49      44.310  30.157  74.690  1.00 22.70          
ATOM    377  CE1 HSD    49      43.080  31.580  73.543  1.00 23.02          
ATOM    378  NE2 HSD    49      44.305  31.349  73.992  1.00 23.55          
ATOM    379  N   PHE    50      39.838  27.646  73.725  1.00 20.17          
ATOM    380  CA  PHE    50      38.758  27.704  72.750  1.00 20.73          
ATOM    381  C   PHE    50      38.892  28.914  71.799  1.00 21.11          
ATOM    382  O   PHE    50      38.740  28.799  70.551  1.00 21.34          
ATOM    383  CB  PHE    50      37.368  27.777  73.419  1.00 20.96          
ATOM    384  CG  PHE    50      36.269  27.807  72.391  1.00 21.48          
ATOM    385  CD1 PHE    50      35.951  26.638  71.710  1.00 21.51          
ATOM    386  CD2 PHE    50      35.669  29.013  72.009  1.00 22.59          
ATOM    387  CE1 PHE    50      34.993  26.646  70.684  1.00 23.30          
ATOM    388  CE2 PHE    50      34.695  29.024  70.990  1.00 20.94          
ATOM    389  CZ  PHE    50      34.356  27.834  70.344  1.00 20.08          
ATOM    390  N   ARG    51      39.145  30.075  72.377  1.00 20.54          
ATOM    391  CA  ARG    51      39.239  31.285  71.582  1.00 20.39          
ATOM    392  C   ARG    51      40.305  31.191  70.466  1.00 20.64          
ATOM    393  O   ARG    51      40.025  31.535  69.318  1.00 20.00          
ATOM    394  CB  ARG    51      39.476  32.492  72.485  1.00 21.15          
ATOM    395  CG  ARG    51      39.698  33.770  71.707  1.00 22.28          
ATOM    396  CD  ARG    51      39.879  34.931  72.698  1.00 21.76          
ATOM    397  NE  ARG    51      40.420  36.050  71.947  1.00 26.25          
ATOM    398  CZ  ARG    51      39.656  36.881  71.238  1.00 25.66          
ATOM    399  NH1 ARG    51      38.323  36.734  71.227  1.00 21.50          
ATOM    400  NH2 ARG    51      40.228  37.864  70.570  1.00 22.78          
ATOM    401  N   SER    52      41.501  30.708  70.784  1.00 20.61          
ATOM    402  CA  SER    52      42.523  30.554  69.758  1.00 22.63          
ATOM    403  C   SER    52      42.037  29.592  68.651  1.00 22.74          
ATOM    404  O   SER    52      42.141  29.902  67.431  1.00 21.96          
ATOM    405  CB  SER    52      43.832  30.074  70.387  1.00 22.87          
ATOM    406  OG  SER    52      44.788  29.862  69.357  1.00 26.87          
ATOM    407  N   ALA    53      41.493  28.437  69.060  1.00 20.89          
ATOM    408  CA  ALA    53      40.951  27.451  68.102  1.00 22.06          
ATOM    409  C   ALA    53      39.863  28.060  67.190  1.00 22.53          
ATOM    410  O   ALA    53      39.842  27.822  65.971  1.00 21.42          
ATOM    411  CB  ALA    53      40.381  26.209  68.844  1.00 20.73          
ATOM    412  N   GLN    54      38.972  28.852  67.784  1.00 21.77          
ATOM    413  CA  GLN    54      37.863  29.434  67.034  1.00 22.99          
ATOM    414  C   GLN    54      38.352  30.471  66.008  1.00 23.32          
ATOM    415  O   GLN    54      37.810  30.553  64.902  1.00 22.70          
ATOM    416  CB  GLN    54      36.818  30.043  67.983  1.00 23.51          
ATOM    417  CG  GLN    54      35.409  30.303  67.345  1.00 25.23          
ATOM    418  CD  GLN    54      35.338  31.586  66.526  1.00 29.86          
ATOM    419  OE1 GLN    54      36.043  32.576  66.813  1.00 25.97          
ATOM    420  NE2 GLN    54      34.484  31.573  65.470  1.00 31.74          
ATOM    421  N   LYS    55      39.360  31.270  66.354  1.00 22.59          
ATOM    422  CA  LYS    55      39.867  32.236  65.362  1.00 23.42          
ATOM    423  C   LYS    55      40.453  31.500  64.160  1.00 23.55          
ATOM    424  O   LYS    55      40.245  31.914  63.011  1.00 23.20          
ATOM    425  CB  LYS    55      40.909  33.165  65.993  1.00 23.58          
ATOM    426  CG  LYS    55      40.316  34.052  67.114  1.00 25.05          
ATOM    427  CD  LYS    55      39.268  35.041  66.621  1.00 27.47          
ATOM    428  CE  LYS    55      38.929  36.141  67.677  1.00 26.35          
ATOM    429  NZ  LYS    55      37.822  37.000  67.145  1.00 27.23          
ATOM    430  N   ILE    56      41.144  30.398  64.429  1.00 23.00          
ATOM    431  CA  ILE    56      41.709  29.540  63.366  1.00 24.02          
ATOM    432  C   ILE    56      40.572  28.924  62.527  1.00 23.51          
ATOM    433  O   ILE    56      40.601  28.985  61.296  1.00 22.40          
ATOM    434  CB  ILE    56      42.641  28.470  63.951  1.00 24.23          
ATOM    435  CG1 ILE    56      43.923  29.147  64.465  1.00 27.31          
ATOM    436  CG2 ILE    56      42.995  27.421  62.871  1.00 24.80          
ATOM    437  CD  ILE    56      44.653  28.378  65.516  1.00 31.44          
ATOM    438  N   ALA    57      39.573  28.359  63.202  1.00 22.14          
ATOM    439  CA  ALA    57      38.357  27.865  62.520  1.00 22.65          
ATOM    440  C   ALA    57      37.681  28.943  61.649  1.00 23.56          
ATOM    441  O   ALA    57      37.234  28.665  60.517  1.00 24.43          
ATOM    442  CB  ALA    57      37.370  27.325  63.533  1.00 22.21          
ATOM    443  N   LYS    58      37.629  30.177  62.144  1.00 24.66          
ATOM    444  CA  LYS    58      37.056  31.275  61.381  1.00 26.83          
ATOM    445  C   LYS    58      37.842  31.502  60.081  1.00 26.21          
ATOM    446  O   LYS    58      37.247  31.711  59.014  1.00 26.97          
ATOM    447  CB  LYS    58      36.992  32.552  62.238  1.00 26.20          
ATOM    448  CG  LYS    58      36.160  33.654  61.624  1.00 28.89          
ATOM    449  CD  LYS    58      36.119  34.893  62.548  1.00 30.34          
ATOM    450  CE  LYS    58      35.429  36.020  61.816  1.00 36.90          
ATOM    451  NZ  LYS    58      35.490  37.304  62.544  1.00 39.28          
ATOM    452  N   SER    59      39.164  31.428  60.166  1.00 26.49          
ATOM    453  CA  SER    59      40.052  31.595  58.999  0.50 26.74          
ATOM    455  C   SER    59      39.793  30.531  57.939  1.00 27.28          
ATOM    456  O   SER    59      39.928  30.787  56.723  1.00 27.35          
ATOM    457  CB  SER    59      41.516  31.523  59.432  0.50 26.35          
ATOM    459  OG  SER    59      41.897  32.723  60.090  0.50 27.19          
ATOM    461  N   LEU    60      39.447  29.331  58.416  1.00 25.49          
ATOM    462  CA  LEU    60      39.179  28.172  57.546  1.00 26.35          
ATOM    463  C   LEU    60      37.705  28.037  57.199  1.00 26.59          
ATOM    464  O   LEU    60      37.310  27.069  56.526  1.00 26.80          
ATOM    465  CB  LEU    60      39.656  26.886  58.228  1.00 25.25          
ATOM    466  CG  LEU    60      41.138  26.779  58.538  1.00 27.58          
ATOM    467  CD1 LEU    60      41.387  25.562  59.387  1.00 28.20          
ATOM    468  CD2 LEU    60      41.902  26.711  57.211  1.00 28.42          
ATOM    469  N   LYS    61      36.897  28.989  57.665  1.00 27.23          
ATOM    470  CA  LYS    61      35.432  28.981  57.478  1.00 28.49          
ATOM    471  C   LYS    61      34.784  27.641  57.908  1.00 27.82          
ATOM    472  O   LYS    61      33.917  27.112  57.198  1.00 27.47          
ATOM    473  CB  LYS    61      35.076  29.295  56.004  1.00 28.70          
ATOM    474  CG  LYS    61      35.668  30.598  55.463  1.00 30.96          
ATOM    475  CD  LYS    61      35.543  30.753  53.935  1.00 32.09          
ATOM    476  CE  LYS    61      36.849  30.335  53.258  1.00 36.97          
ATOM    477  NZ  LYS    61      36.860  30.655  51.781  1.00 41.53          
ATOM    478  N   LEU    62      35.190  27.089  59.048  1.00 26.95          
ATOM    479  CA  LEU    62      34.717  25.753  59.448  1.00 27.46          
ATOM    480  C   LEU    62      33.252  25.648  59.899  1.00 29.60          
ATOM    481  O   LEU    62      32.591  24.655  59.602  1.00 30.44          
ATOM    482  CB  LEU    62      35.586  25.149  60.542  1.00 26.53          
ATOM    483  CG  LEU    62      37.049  24.843  60.217  1.00 26.51          
ATOM    484  CD1 LEU    62      37.672  24.005  61.374  1.00 25.49          
ATOM    485  CD2 LEU    62      37.160  24.116  58.867  1.00 25.94          
ATOM    486  N   ASP    63      32.775  26.618  60.661  1.00 31.37          
ATOM    487  CA  ASP    63      31.447  26.481  61.308  1.00 34.07          
ATOM    488  C   ASP    63      31.144  25.066  61.854  1.00 33.74          
ATOM    489  O   ASP    63      30.177  24.419  61.456  1.00 35.61          
ATOM    490  CB  ASP    63      30.357  26.950  60.343  1.00 35.41          
ATOM    491  CG  ASP    63      30.539  28.405  59.959  1.00 39.11          
ATOM    492  OD1 ASP    63      30.700  29.246  60.888  1.00 41.22          
ATOM    493  OD2 ASP    63      30.551  28.698  58.739  1.00 43.66          
ATOM    494  N   ALA    64      31.990  24.589  62.757  1.00 32.83          
ATOM    495  CA  ALA    64      31.909  23.216  63.257  1.00 30.86          
ATOM    496  C   ALA    64      32.060  23.248  64.770  1.00 29.07          
ATOM    497  O   ALA    64      32.556  24.223  65.310  1.00 29.36          
ATOM    498  CB  ALA    64      33.030  22.400  62.660  1.00 32.36          
ATOM    499  N   LYS    65      31.665  22.172  65.445  1.00 27.04          
ATOM    500  CA  LYS    65      31.967  22.001  66.873  1.00 25.79          
ATOM    501  C   LYS    65      33.456  21.687  67.034  1.00 24.88          
ATOM    502  O   LYS    65      33.943  20.690  66.483  1.00 26.80          
ATOM    503  CB  LYS    65      31.145  20.861  67.467  1.00 26.09          
ATOM    504  CG  LYS    65      29.645  21.189  67.709  1.00 24.81          
ATOM    505  CD  LYS    65      28.846  19.911  68.020  1.00 27.18          
ATOM    506  CE  LYS    65      27.327  20.155  68.132  1.00 30.13          
ATOM    507  NZ  LYS    65      26.732  20.900  66.973  1.00 31.93          
ATOM    508  N   LEU    66      34.169  22.513  67.793  1.00 22.23          
ATOM    509  CA  LEU    66      35.607  22.356  67.914  1.00 21.65          
ATOM    510  C   LEU    66      35.872  21.678  69.255  1.00 21.94          
ATOM    511  O   LEU    66      35.179  21.973  70.250  1.00 21.43          
ATOM    512  CB  LEU    66      36.280  23.737  67.899  1.00 21.77          
ATOM    513  CG  LEU    66      35.849  24.630  66.719  1.00 21.08          
ATOM    514  CD1 LEU    66      36.443  26.057  66.921  1.00 23.95          
ATOM    515  CD2 LEU    66      36.285  24.034  65.394  1.00 21.87          
ATOM    516  N   ILE    67      36.851  20.786  69.274  1.00 21.05          
ATOM    517  CA  ILE    67      37.226  20.056  70.494  1.00 21.79          
ATOM    518  C   ILE    67      38.489  20.699  71.055  1.00 21.05          
ATOM    519  O   ILE    67      39.567  20.585  70.479  1.00 20.88          
ATOM    520  CB  ILE    67      37.438  18.545  70.200  1.00 22.27          
ATOM    521  CG1 ILE    67      36.119  17.950  69.663  1.00 24.26          
ATOM    522  CG2 ILE    67      37.846  17.799  71.502  1.00 21.10          
ATOM    523  CD  ILE    67      36.317  16.897  68.631  1.00 27.11          
ATOM    524  N   THR    68      38.335  21.429  72.157  1.00 19.41          
ATOM    525  CA  THR    68      39.412  22.313  72.640  1.00 19.84          
ATOM    526  C   THR    68      39.685  22.018  74.123  1.00 19.61          
ATOM    527  O   THR    68      38.961  21.215  74.761  1.00 20.40          
ATOM    528  CB  THR    68      39.033  23.825  72.394  1.00 19.80          
ATOM    529  OG1 THR    68      38.006  24.217  73.305  1.00 19.77          
ATOM    530  CG2 THR    68      38.499  23.997  70.973  1.00 21.02          
ATOM    531  N   HSD    69      40.721  22.659  74.663  1.00 19.41          
ATOM    532  CA  HSD    69      41.147  22.453  76.055  1.00 19.78          
ATOM    533  C   HSD    69      41.289  20.937  76.284  1.00 20.78          
ATOM    534  O   HSD    69      40.790  20.420  77.295  1.00 20.95          
ATOM    535  CB  HSD    69      40.138  23.082  77.062  1.00 19.33          
ATOM    536  CG  HSD    69      40.027  24.582  76.972  1.00 19.21          
ATOM    537  ND1 HSD    69      40.623  25.425  77.886  1.00 18.89          
ATOM    538  CD2 HSD    69      39.384  25.384  76.083  1.00 19.50          
ATOM    539  CE1 HSD    69      40.328  26.686  77.581  1.00 18.35          
ATOM    540  NE2 HSD    69      39.569  26.686  76.493  1.00 19.29          
ATOM    541  N   SER    70      41.930  20.221  75.335  1.00 20.83          
ATOM    542  CA  SER    70      42.220  18.789  75.517  0.50 21.41          
ATOM    544  C   SER    70      40.949  17.908  75.620  1.00 22.14          
ATOM    545  O   SER    70      40.992  16.797  76.208  1.00 22.78          
ATOM    546  CB  SER    70      43.086  18.618  76.773  0.50 21.80          
ATOM    548  OG  SER    70      43.785  17.398  76.758  0.50 21.52          
ATOM    550  N   GLY    71      39.823  18.399  75.087  1.00 21.30          
ATOM    551  CA  GLY    71      38.531  17.682  75.145  1.00 21.84          
ATOM    552  C   GLY    71      37.566  18.176  76.216  1.00 20.49          
ATOM    553  O   GLY    71      36.451  17.666  76.334  1.00 22.40          
ATOM    554  N   ALA    72      38.003  19.123  77.053  1.00 19.92          
ATOM    555  CA  ALA    72      37.170  19.600  78.164  1.00 20.96          
ATOM    556  C   ALA    72      36.155  20.646  77.731  1.00 21.33          
ATOM    557  O   ALA    72      35.248  20.972  78.484  1.00 22.16          
ATOM    558  CB  ALA    72      38.064  20.183  79.302  1.00 21.39          
ATOM    559  N   TYR    73      36.331  21.205  76.536  1.00 21.33          
ATOM    560  CA  TYR    73      35.467  22.316  76.085  1.00 21.67          
ATOM    561  C   TYR    73      35.156  22.166  74.603  1.00 21.49          
ATOM    562  O   TYR    73      36.061  22.265  73.755  1.00 21.48          
ATOM    563  CB  TYR    73      36.119  23.682  76.371  1.00 21.37          
ATOM    564  CG  TYR    73      35.080  24.761  76.456  1.00 21.71          
ATOM    565  CD1 TYR    73      34.381  24.960  77.663  1.00 23.03          
ATOM    566  CD2 TYR    73      34.778  25.582  75.357  1.00 23.35          
ATOM    567  CE1 TYR    73      33.374  25.928  77.776  1.00 26.01          
ATOM    568  CE2 TYR    73      33.747  26.588  75.461  1.00 21.42          
ATOM    569  CZ  TYR    73      33.081  26.748  76.670  1.00 25.65          
ATOM    570  OH  TYR    73      32.096  27.695  76.850  1.00 24.71          
ATOM    571  N   ILE    74      33.904  21.843  74.281  1.00 21.45          
ATOM    572  CA  ILE    74      33.530  21.515  72.889  1.00 21.25          
ATOM    573  C   ILE    74      32.403  22.451  72.530  1.00 21.83          
ATOM    574  O   ILE    74      31.382  22.491  73.221  1.00 21.41          
ATOM    575  CB  ILE    74      33.079  20.030  72.706  1.00 21.10          
ATOM    576  CG1 ILE    74      34.181  19.066  73.213  1.00 21.25          
ATOM    577  CG2 ILE    74      32.687  19.744  71.221  1.00 21.03          
ATOM    578  CD  ILE    74      33.749  17.567  73.338  1.00 21.33          
ATOM    579  N   ALA    75      32.616  23.242  71.483  1.00 21.36          
ATOM    580  CA  ALA    75      31.686  24.331  71.193  1.00 21.45          
ATOM    581  C   ALA    75      31.867  24.891  69.799  1.00 21.63          
ATOM    582  O   ALA    75      32.903  24.688  69.162  1.00 20.86          
ATOM    583  CB  ALA    75      31.899  25.494  72.243  1.00 21.22          
ATOM    584  N   GLU    76      30.827  25.558  69.314  1.00 22.41          
ATOM    585  CA  GLU    76      30.984  26.384  68.125  0.50 22.73          
ATOM    587  C   GLU    76      31.083  27.854  68.505  1.00 23.14          
ATOM    588  O   GLU    76      31.827  28.629  67.858  1.00 23.26          
ATOM    589  CB  GLU    76      29.854  26.166  67.128  0.50 22.55          
ATOM    591  CG  GLU    76      30.171  26.782  65.765  0.50 23.11          
ATOM    593  CD  GLU    76      29.105  26.535  64.712  0.50 24.63          
ATOM    595  OE1 GLU    76      28.124  25.806  64.978  0.50 25.39          
ATOM    597  OE2 GLU    76      29.248  27.108  63.616  0.50 22.88          
ATOM    599  N   LYS    77      30.382  28.242  69.569  1.00 23.36          
ATOM    600  CA  LYS    77      30.450  29.622  70.066  1.00 24.10          
ATOM    601  C   LYS    77      30.680  29.580  71.569  1.00 22.97          
ATOM    602  O   LYS    77      30.090  28.767  72.269  1.00 22.29          
ATOM    603  CB  LYS    77      29.171  30.410  69.739  1.00 24.74          
ATOM    604  CG  LYS    77      28.963  30.705  68.229  1.00 25.92          
ATOM    605  CD  LYS    77      27.715  31.554  68.048  1.00 27.04          
ATOM    606  CE  LYS    77      27.350  31.768  66.560  1.00 30.16          
ATOM    607  NZ  LYS    77      26.213  32.750  66.465  1.00 32.73          
ATOM    608  N   ILE    78      31.583  30.435  72.043  1.00 22.60          
ATOM    609  CA  ILE    78      32.071  30.339  73.413  1.00 22.07          
ATOM    610  C   ILE    78      31.012  30.326  74.533  1.00 22.75          
ATOM    611  O   ILE    78      31.152  29.564  75.504  1.00 23.41          
ATOM    612  CB  ILE    78      33.171  31.402  73.697  1.00 21.45          
ATOM    613  CG1 ILE    78      33.998  30.962  74.928  1.00 23.92          
ATOM    614  CG2 ILE    78      32.562  32.812  73.824  1.00 21.51          
ATOM    615  CD  ILE    78      35.292  31.689  75.027  1.00 24.33          
ATOM    616  N   ASP    79      29.970  31.146  74.440  1.00 23.59          
ATOM    617  CA  ASP    79      29.029  31.223  75.570  1.00 24.43          
ATOM    618  C   ASP    79      28.100  30.016  75.696  1.00 25.45          
ATOM    619  O   ASP    79      27.417  29.879  76.716  1.00 24.78          
ATOM    620  CB  ASP    79      28.210  32.536  75.557  1.00 24.23          
ATOM    621  CG  ASP    79      29.086  33.776  75.601  1.00 27.88          
ATOM    622  OD1 ASP    79      29.804  33.964  76.614  1.00 26.74          
ATOM    623  OD2 ASP    79      29.094  34.527  74.593  1.00 32.80          
ATOM    624  N   ALA    80      28.066  29.156  74.665  1.00 25.69          
ATOM    625  CA  ALA    80      27.047  28.111  74.563  1.00 26.54          
ATOM    626  C   ALA    80      27.682  26.765  74.211  1.00 26.30          
ATOM    627  O   ALA    80      27.503  26.249  73.096  1.00 27.12          
ATOM    628  CB  ALA    80      25.985  28.507  73.530  1.00 26.86          
ATOM    629  N   PRO    81      28.447  26.184  75.142  1.00 26.15          
ATOM    630  CA  PRO    81      29.122  24.949  74.732  1.00 24.68          
ATOM    631  C   PRO    81      28.218  23.743  74.545  1.00 24.12          
ATOM    632  O   PRO    81      27.161  23.624  75.174  1.00 22.35          
ATOM    633  CB  PRO    81      30.133  24.700  75.858  1.00 25.45          
ATOM    634  CG  PRO    81      29.445  25.319  77.098  1.00 26.62          
ATOM    635  CD  PRO    81      28.774  26.577  76.531  1.00 25.97          
ATOM    636  N   PHE    82      28.635  22.882  73.622  1.00 23.55          
ATOM    637  CA  PHE    82      28.009  21.589  73.410  1.00 23.30          
ATOM    638  C   PHE    82      28.340  20.635  74.570  1.00 23.67          
ATOM    639  O   PHE    82      27.463  19.880  75.036  1.00 22.81          
ATOM    640  CB  PHE    82      28.527  21.019  72.092  1.00 24.35          
ATOM    641  CG  PHE    82      28.172  19.587  71.875  1.00 25.21          
ATOM    642  CD1 PHE    82      26.838  19.213  71.728  1.00 28.92          
ATOM    643  CD2 PHE    82      29.165  18.615  71.831  1.00 27.78          
ATOM    644  CE1 PHE    82      26.501  17.867  71.539  1.00 30.70          
ATOM    645  CE2 PHE    82      28.833  17.275  71.630  1.00 31.51          
ATOM    646  CZ  PHE    82      27.502  16.912  71.485  1.00 30.20          
ATOM    647  N   PHE    83      29.607  20.662  75.011  1.00 22.68          
ATOM    648  CA  PHE    83      30.089  19.864  76.127  1.00 22.25          
ATOM    649  C   PHE    83      31.094  20.714  76.902  1.00 22.99          
ATOM    650  O   PHE    83      32.029  21.288  76.312  1.00 23.07          
ATOM    651  CB  PHE    83      30.776  18.557  75.645  1.00 23.52          
ATOM    652  CG  PHE    83      31.457  17.768  76.743  1.00 22.78          
ATOM    653  CD1 PHE    83      30.727  16.888  77.557  1.00 26.75          
ATOM    654  CD2 PHE    83      32.847  17.887  76.951  1.00 24.70          
ATOM    655  CE1 PHE    83      31.354  16.155  78.577  1.00 28.70          
ATOM    656  CE2 PHE    83      33.499  17.159  77.979  1.00 24.92          
ATOM    657  CZ  PHE    83      32.743  16.278  78.787  1.00 25.97          
ATOM    658  N   GLU    84      30.936  20.765  78.225  1.00 23.12          
ATOM    659  CA  GLU    84      31.992  21.343  79.050  1.00 23.53          
ATOM    660  C   GLU    84      32.175  20.569  80.340  1.00 23.50          
ATOM    661  O   GLU    84      31.204  20.097  80.934  1.00 23.03          
ATOM    662  CB  GLU    84      31.722  22.822  79.341  1.00 23.79          
ATOM    663  CG  GLU    84      30.401  23.073  80.119  1.00 26.04          
ATOM    664  CD  GLU    84      30.205  24.545  80.531  1.00 27.27          
ATOM    665  OE1 GLU    84      31.156  25.360  80.506  1.00 26.40          
ATOM    666  OE2 GLU    84      29.069  24.870  80.924  1.00 28.28          
ATOM   1663  N   VAL   201      37.880  13.061  80.607  1.00 23.17          
ATOM   1664  CA  VAL   201      38.086  14.017  79.515  1.00 23.28          
ATOM   1665  C   VAL   201      39.338  13.660  78.712  1.00 23.78          
ATOM   1666  O   VAL   201      40.379  13.293  79.280  1.00 23.42          
ATOM   1667  CB  VAL   201      38.199  15.469  80.058  1.00 22.66          
ATOM   1668  CG1 VAL   201      38.784  16.473  79.002  1.00 23.26          
ATOM   1669  CG2 VAL   201      36.823  15.925  80.614  1.00 22.85          
ATOM   1670  N   SER   202      39.229  13.755  77.396  1.00 23.76          
ATOM   1671  CA  SER   202      40.381  13.594  76.515  1.00 23.73          
ATOM   1672  C   SER   202      40.013  14.008  75.100  1.00 23.53          
ATOM   1673  O   SER   202      38.820  14.117  74.756  1.00 23.55          
ATOM   1674  CB  SER   202      40.877  12.133  76.511  1.00 23.24          
ATOM   1675  OG  SER   202      39.953  11.270  75.866  1.00 25.09          
ATOM   1676  N   LYS   203      41.041  14.174  74.266  1.00 23.78          
ATOM   1677  CA  LYS   203      40.816  14.429  72.835  1.00 24.42          
ATOM   1678  C   LYS   203      39.967  13.338  72.193  1.00 24.78          
ATOM   1679  O   LYS   203      39.042  13.648  71.456  1.00 25.33          
ATOM   1680  CB  LYS   203      42.133  14.566  72.085  1.00 24.43          
ATOM   1681  CG  LYS   203      42.904  15.830  72.372  1.00 24.22          
ATOM   1682  CD  LYS   203      44.319  15.747  71.699  1.00 24.40          
ATOM   1683  CE  LYS   203      44.861  17.178  71.476  1.00 25.18          
ATOM   1684  NZ  LYS   203      46.372  17.189  71.101  1.00 27.07          
ATOM   1685  N   GLU   204      40.273  12.070  72.476  1.00 24.74          
ATOM   1686  CA  GLU   204      39.565  10.962  71.860  1.00 25.22          
ATOM   1687  C   GLU   204      38.110  10.856  72.355  1.00 25.34          
ATOM   1688  O   GLU   204      37.205  10.479  71.600  1.00 25.63          
ATOM   1689  CB  GLU   204      40.316   9.638  72.067  1.00 25.18          
ATOM   1690  CG  GLU   204      40.476   9.140  73.525  1.00 26.39          
ATOM   1691  CD  GLU   204      41.728   9.648  74.230  1.00 28.45          
ATOM   1692  OE1 GLU   204      42.320  10.686  73.810  1.00 27.42          
ATOM   1693  OE2 GLU   204      42.103   8.993  75.240  1.00 27.94          
ATOM   1694  N   ALA   205      37.896  11.155  73.633  1.00 25.21          
ATOM   1695  CA  ALA   205      36.551  11.140  74.178  1.00 25.48          
ATOM   1696  C   ALA   205      35.704  12.277  73.560  1.00 25.74          
ATOM   1697  O   ALA   205      34.506  12.085  73.256  1.00 24.87          
ATOM   1698  CB  ALA   205      36.602  11.262  75.696  1.00 26.78          
ATOM   1699  N   GLY   206      36.331  13.442  73.376  1.00 26.29          
ATOM   1700  CA  GLY   206      35.640  14.624  72.822  1.00 26.95          
ATOM   1701  C   GLY   206      35.268  14.331  71.360  1.00 27.05          
ATOM   1702  O   GLY   206      34.129  14.554  70.931  1.00 26.85          
ATOM   1703  N   LEU   207      36.233  13.798  70.615  1.00 27.18          
ATOM   1704  CA  LEU   207      36.010  13.370  69.240  1.00 28.57          
ATOM   1705  C   LEU   207      34.881  12.342  69.137  1.00 28.45          
ATOM   1706  O   LEU   207      34.008  12.481  68.286  1.00 29.73          
ATOM   1707  CB  LEU   207      37.306  12.843  68.603  1.00 28.40          
ATOM   1708  CG  LEU   207      37.299  12.573  67.080  1.00 30.73          
ATOM   1709  CD1 LEU   207      36.715  13.757  66.324  1.00 31.91          
ATOM   1710  CD2 LEU   207      38.732  12.337  66.627  1.00 29.73          
ATOM   1711  N   ALA   208      34.869  11.336  70.019  1.00 28.38          
ATOM   1712  CA  ALA   208      33.753  10.374  70.037  1.00 28.76          
ATOM   1713  C   ALA   208      32.393  11.036  70.262  1.00 28.80          
ATOM   1714  O   ALA   208      31.392  10.637  69.640  1.00 29.85          
ATOM   1715  CB  ALA   208      33.989   9.278  71.060  1.00 28.97          
ATOM   1716  N   LEU   209      32.341  12.038  71.147  1.00 28.07          
ATOM   1717  CA  LEU   209      31.084  12.727  71.442  0.50 27.57          
ATOM   1719  C   LEU   209      30.596  13.496  70.215  1.00 27.61          
ATOM   1720  O   LEU   209      29.392  13.520  69.912  1.00 26.72          
ATOM   1721  CB  LEU   209      31.220  13.676  72.640  0.50 27.41          
ATOM   1723  CG  LEU   209      31.416  13.169  74.076  0.50 27.68          
ATOM   1725  CD1 LEU   209      31.349  14.332  75.046  0.50 28.55          
ATOM   1727  CD2 LEU   209      30.382  12.113  74.470  0.50 28.32          
ATOM   1729  N   VAL   210      31.526  14.126  69.503  1.00 27.12          
ATOM   1730  CA  VAL   210      31.157  14.895  68.322  1.00 28.29          
ATOM   1731  C   VAL   210      30.689  13.954  67.202  1.00 28.23          
ATOM   1732  O   VAL   210      29.676  14.225  66.551  1.00 28.96          
ATOM   1733  CB  VAL   210      32.301  15.829  67.883  1.00 28.91          
ATOM   1734  CG1 VAL   210      32.044  16.463  66.500  1.00 30.73          
ATOM   1735  CG2 VAL   210      32.503  16.935  68.926  1.00 28.46          
ATOM   1736  N   ALA   211      31.405  12.855  67.008  1.00 27.53          
ATOM   1737  CA  ALA   211      31.037  11.889  65.955  1.00 29.77          
ATOM   1738  C   ALA   211      29.634  11.330  66.251  1.00 30.23          
ATOM   1739  O   ALA   211      28.777  11.275  65.357  1.00 31.50          
ATOM   1740  CB  ALA   211      32.052  10.785  65.874  1.00 28.32          
ATOM   1741  N   SER   212      29.389  10.948  67.507  1.00 31.44          
ATOM   1742  CA  SER   212      28.087  10.426  67.907  0.50 31.31          
ATOM   1744  C   SER   212      26.966  11.446  67.658  1.00 31.67          
ATOM   1745  O   SER   212      25.882  11.085  67.178  1.00 30.94          
ATOM   1746  CB  SER   212      28.103   9.983  69.378  0.50 31.80          
ATOM   1748  OG  SER   212      28.942   8.849  69.550  0.50 31.57          
ATOM   1750  N   GLU   213      27.228  12.714  67.983  1.00 31.98          
ATOM   1751  CA  GLU   213      26.271  13.804  67.745  1.00 32.98          
ATOM   1752  C   GLU   213      25.899  13.918  66.260  1.00 32.21          
ATOM   1753  O   GLU   213      24.760  14.240  65.919  1.00 31.44          
ATOM   1754  CB  GLU   213      26.815  15.143  68.288  1.00 33.71          
ATOM   1755  CG  GLU   213      25.921  16.357  68.005  1.00 36.91          
ATOM   1756  CD  GLU   213      24.602  16.358  68.767  1.00 41.90          
ATOM   1757  OE1 GLU   213      24.389  15.516  69.668  1.00 42.24          
ATOM   1758  OE2 GLU   213      23.759  17.233  68.466  1.00 44.94          
ATOM   1759  N   LEU   214      26.860  13.628  65.400  1.00 31.56          
ATOM   1760  CA  LEU   214      26.669  13.655  63.955  1.00 31.83          
ATOM   1761  C   LEU   214      26.129  12.349  63.367  1.00 31.36          
ATOM   1762  O   LEU   214      25.994  12.242  62.154  1.00 32.00          
ATOM   1763  CB  LEU   214      27.986  14.012  63.262  1.00 31.66          
ATOM   1764  CG  LEU   214      28.554  15.405  63.558  1.00 32.94          
ATOM   1765  CD1 LEU   214      29.941  15.500  62.964  1.00 32.27          
ATOM   1766  CD2 LEU   214      27.652  16.491  63.025  1.00 34.12          
ATOM   1767  N   GLY   215      25.837  11.363  64.211  1.00 30.66          
ATOM   1768  CA  GLY   215      25.340  10.066  63.730  1.00 31.52          
ATOM   1769  C   GLY   215      26.423   9.187  63.115  1.00 31.35          
ATOM   1770  O   GLY   215      26.134   8.258  62.348  1.00 30.33          
ATOM   1771  N   LEU   216      27.679   9.481  63.445  1.00 31.95          
ATOM   1772  CA  LEU   216      28.823   8.740  62.909  1.00 33.17          
ATOM   1773  C   LEU   216      29.469   7.892  63.993  1.00 34.61          
ATOM   1774  O   LEU   216      29.202   8.097  65.174  1.00 35.18          
ATOM   1775  CB  LEU   216      29.856   9.699  62.314  1.00 33.09          
ATOM   1776  CG  LEU   216      29.341  10.716  61.286  1.00 34.24          
ATOM   1777  CD1 LEU   216      30.383  11.781  61.015  1.00 35.51          
ATOM   1778  CD2 LEU   216      28.954  10.016  60.009  1.00 34.74          
ATOM   1779  N   SER   217      30.255   6.891  63.595  1.00 36.05          
ATOM   1780  CA  SER   217      31.118   6.198  64.550  1.00 37.27          
ATOM   1781  C   SER   217      32.572   6.603  64.317  1.00 37.16          
ATOM   1782  O   SER   217      32.890   7.227  63.295  1.00 37.08          
ATOM   1783  CB  SER   217      30.977   4.680  64.452  1.00 37.36          
ATOM   1784  OG  SER   217      31.434   4.162  63.207  1.00 39.38          
ATOM   1785  N   MET   218      33.450   6.241  65.252  1.00 36.89          
ATOM   1786  CA  MET   218      34.900   6.434  65.054  1.00 36.52          
ATOM   1787  C   MET   218      35.416   5.826  63.729  1.00 35.52          
ATOM   1788  O   MET   218      36.384   6.340  63.146  1.00 35.11          
ATOM   1789  CB  MET   218      35.699   5.948  66.279  1.00 36.94          
ATOM   1790  CG  MET   218      35.501   6.844  67.527  1.00 39.01          
ATOM   1791  SD  MET   218      35.943   8.725  67.266  0.50 41.58          
ATOM   1792  CE  MET   218      37.884   8.654  67.325  1.00 41.87          
ATOM   1793  N   ASP   219      34.756   4.762  63.257  0.50 34.83          
ATOM   1795  CA  ASP   219      35.063   4.146  61.957  0.50 34.53          
ATOM   1797  C   ASP   219      35.023   5.116  60.772  0.50 34.07          
ATOM   1799  O   ASP   219      35.703   4.899  59.758  0.50 33.98          
ATOM   1801  CB  ASP   219      34.117   2.970  61.664  0.50 34.79          
ATOM   1803  CG  ASP   219      34.244   1.834  62.673  0.50 35.41          
ATOM   1805  OD1 ASP   219      35.291   1.713  63.352  0.50 35.59          
ATOM   1807  OD2 ASP   219      33.285   1.045  62.775  0.50 38.09          
ATOM   1809  N   ASP   220      34.222   6.167  60.910  1.00 33.45          
ATOM   1810  CA  ASP   220      33.965   7.135  59.846  1.00 33.21          
ATOM   1811  C   ASP   220      34.915   8.335  59.921  1.00 31.68          
ATOM   1812  O   ASP   220      34.766   9.296  59.152  1.00 31.82          
ATOM   1813  CB  ASP   220      32.513   7.654  59.956  1.00 33.38          
ATOM   1814  CG  ASP   220      31.467   6.539  59.830  1.00 36.94          
ATOM   1815  OD1 ASP   220      31.547   5.724  58.870  1.00 35.69          
ATOM   1816  OD2 ASP   220      30.552   6.495  60.694  1.00 39.56          
ATOM   1817  N   VAL   221      35.863   8.279  60.857  1.00 29.72          
ATOM   1818  CA  VAL   221      36.720   9.418  61.186  1.00 29.05          
ATOM   1819  C   VAL   221      38.148   9.248  60.657  1.00 28.17          
ATOM   1820  O   VAL   221      38.740   8.159  60.765  1.00 28.41          
ATOM   1821  CB  VAL   221      36.790   9.635  62.712  1.00 28.79          
ATOM   1822  CG1 VAL   221      37.689  10.800  63.041  1.00 30.06          
ATOM   1823  CG2 VAL   221      35.380   9.848  63.307  1.00 31.31          
ATOM   1824  N   VAL   222      38.672  10.319  60.057  1.00 27.83          
ATOM   1825  CA  VAL   222      40.110  10.473  59.815  1.00 28.23          
ATOM   1826  C   VAL   222      40.653  11.421  60.884  1.00 27.20          
ATOM   1827  O   VAL   222      40.133  12.543  61.058  1.00 27.97          
ATOM   1828  CB  VAL   222      40.425  11.042  58.399  1.00 28.20          
ATOM   1829  CG1 VAL   222      41.961  11.195  58.185  1.00 29.34          
ATOM   1830  CG2 VAL   222      39.803  10.172  57.328  1.00 30.60          
ATOM   1831  N   ALA   223      41.658  10.972  61.643  1.00 26.30          
ATOM   1832  CA  ALA   223      42.220  11.821  62.692  1.00 25.77          
ATOM   1833  C   ALA   223      43.707  12.042  62.431  1.00 26.13          
ATOM   1834  O   ALA   223      44.431  11.092  62.163  1.00 25.66          
ATOM   1835  CB  ALA   223      41.999  11.215  64.064  1.00 26.54          
ATOM   1836  N   ILE   224      44.157  13.296  62.469  1.00 24.89          
ATOM   1837  CA  ILE   224      45.565  13.598  62.158  1.00 24.93          
ATOM   1838  C   ILE   224      46.203  14.224  63.398  1.00 24.71          
ATOM   1839  O   ILE   224      45.780  15.324  63.837  1.00 24.37          
ATOM   1840  CB  ILE   224      45.690  14.545  60.947  1.00 24.68          
ATOM   1841  CG1 ILE   224      44.926  13.981  59.740  1.00 25.85          
ATOM   1842  CG2 ILE   224      47.177  14.741  60.567  1.00 25.43          
ATOM   1843  CD  ILE   224      45.102  14.817  58.464  1.00 26.42          
ATOM   1844  N   GLY   225      47.193  13.531  63.976  1.00 24.29          
ATOM   1845  CA  GLY   225      47.828  13.965  65.243  1.00 24.00          
ATOM   1846  C   GLY   225      49.365  13.959  65.143  1.00 23.46          
ATOM   1847  O   GLY   225      49.934  13.514  64.134  1.00 23.07          
ATOM   1848  N   HSD   226      50.044  14.381  66.201  1.00 22.78          
ATOM   1849  CA  HSD   226      51.527  14.471  66.158  1.00 23.19          
ATOM   1850  C   HSD   226      52.239  14.197  67.489  1.00 23.03          
ATOM   1851  O   HSD   226      53.450  14.048  67.496  1.00 22.15          
ATOM   1852  CB  HSD   226      51.993  15.824  65.559  1.00 23.23          
ATOM   1853  CG  HSD   226      51.933  16.971  66.526  1.00 23.91          
ATOM   1854  ND1 HSD   226      50.743  17.456  67.032  1.00 25.13          
ATOM   1855  CD2 HSD   226      52.914  17.748  67.046  1.00 25.12          
ATOM   1856  CE1 HSD   226      50.996  18.472  67.844  1.00 25.61          
ATOM   1857  NE2 HSD   226      52.305  18.675  67.864  1.00 23.93          
ATOM   1858  N   GLN   227      51.500  14.155  68.608  1.00 22.83          
ATOM   1859  CA  GLN   227      52.134  13.879  69.923  1.00 23.45          
ATOM   1860  C   GLN   227      51.501  12.700  70.685  1.00 22.59          
ATOM   1861  O   GLN   227      50.537  12.093  70.215  1.00 22.33          
ATOM   1862  CB  GLN   227      52.113  15.133  70.801  1.00 22.88          
ATOM   1863  CG  GLN   227      52.760  16.301  70.143  1.00 25.56          
ATOM   1864  CD  GLN   227      52.962  17.441  71.109  1.00 28.03          
ATOM   1865  OE1 GLN   227      52.022  18.141  71.458  1.00 29.31          
ATOM   1866  NE2 GLN   227      54.190  17.623  71.539  1.00 25.63          
ATOM   1867  N   TYR   228      52.045  12.386  71.858  1.00 22.47          
ATOM   1868  CA  TYR   228      51.575  11.199  72.618  1.00 22.82          
ATOM   1869  C   TYR   228      50.096  11.257  72.947  1.00 23.18          
ATOM   1870  O   TYR   228      49.387  10.227  72.910  1.00 23.61          
ATOM   1871  CB  TYR   228      52.399  10.986  73.899  1.00 23.04          
ATOM   1872  CG  TYR   228      53.850  10.655  73.611  1.00 24.87          
ATOM   1873  CD1 TYR   228      54.202   9.458  72.991  1.00 28.27          
ATOM   1874  CD2 TYR   228      54.865  11.517  73.980  1.00 28.89          
ATOM   1875  CE1 TYR   228      55.549   9.121  72.725  1.00 28.17          
ATOM   1876  CE2 TYR   228      56.233  11.195  73.722  1.00 28.28          
ATOM   1877  CZ  TYR   228      56.546   9.999  73.091  1.00 28.51          
ATOM   1878  OH  TYR   228      57.875   9.681  72.846  1.00 27.14          
ATOM   1879  N   ASP   229      49.609  12.460  73.215  1.00 22.58          
ATOM   1880  CA  ASP   229      48.221  12.594  73.618  1.00 23.33          
ATOM   1881  C   ASP   229      47.262  12.372  72.454  1.00 23.38          
ATOM   1882  O   ASP   229      46.058  12.244  72.666  1.00 24.04          
ATOM   1883  CB  ASP   229      47.959  13.940  74.312  1.00 23.91          
ATOM   1884  CG  ASP   229      48.228  15.132  73.408  1.00 24.90          
ATOM   1885  OD1 ASP   229      49.172  15.064  72.593  1.00 27.32          
ATOM   1886  OD2 ASP   229      47.499  16.154  73.523  1.00 27.38          
ATOM   1887  N   ASP   230      47.799  12.378  71.231  1.00 23.48          
ATOM   1888  CA  ASP   230      47.022  12.092  70.011  1.00 24.70          
ATOM   1889  C   ASP   230      46.957  10.601  69.704  1.00 25.26          
ATOM   1890  O   ASP   230      46.155  10.143  68.863  1.00 25.79          
ATOM   1891  CB  ASP   230      47.652  12.817  68.831  1.00 23.62          
ATOM   1892  CG  ASP   230      47.716  14.333  69.056  1.00 25.09          
ATOM   1893  OD1 ASP   230      46.675  14.930  69.417  1.00 25.87          
ATOM   1894  OD2 ASP   230      48.804  14.916  68.925  1.00 25.09          
ATOM   1895  N   LEU   231      47.773   9.810  70.387  1.00 26.29          
ATOM   1896  CA  LEU   231      47.804   8.372  70.052  1.00 26.35          
ATOM   1897  C   LEU   231      46.455   7.652  70.147  1.00 27.21          
ATOM   1898  O   LEU   231      46.104   6.861  69.251  1.00 27.17          
ATOM   1899  CB  LEU   231      48.858   7.647  70.892  1.00 27.34          
ATOM   1900  CG  LEU   231      50.265   7.741  70.328  1.00 29.56          
ATOM   1901  CD1 LEU   231      51.271   7.174  71.343  1.00 30.37          
ATOM   1902  CD2 LEU   231      50.346   6.987  68.964  1.00 30.69          
ATOM   1903  N   PRO   232      45.690   7.874  71.236  1.00 27.17          
ATOM   1904  CA  PRO   232      44.395   7.182  71.317  1.00 27.16          
ATOM   1905  C   PRO   232      43.461   7.491  70.154  1.00 27.46          
ATOM   1906  O   PRO   232      42.847   6.575  69.619  1.00 27.80          
ATOM   1907  CB  PRO   232      43.804   7.699  72.642  1.00 27.75          
ATOM   1908  CG  PRO   232      45.047   8.054  73.455  1.00 27.55          
ATOM   1909  CD  PRO   232      45.981   8.650  72.458  1.00 26.76          
ATOM   1910  N   MET   233      43.371   8.751  69.722  1.00 27.42          
ATOM   1911  CA  MET   233      42.440   9.030  68.639  1.00 28.57          
ATOM   1912  C   MET   233      42.994   8.478  67.317  1.00 28.53          
ATOM   1913  O   MET   233      42.218   8.092  66.450  1.00 29.36          
ATOM   1914  CB  MET   233      42.101  10.519  68.529  1.00 29.13          
ATOM   1915  CG  MET   233      43.183  11.353  67.938  1.00 27.81          
ATOM   1916  SD  MET   233      42.680  13.240  67.696  0.50 30.15          
ATOM   1917  CE  MET   233      44.251  13.669  66.592  1.00 32.01          
ATOM   1918  N   ILE   234      44.318   8.447  67.176  1.00 27.31          
ATOM   1919  CA  ILE   234      44.958   7.823  66.013  1.00 28.21          
ATOM   1920  C   ILE   234      44.637   6.325  65.959  1.00 28.21          
ATOM   1921  O   ILE   234      44.330   5.807  64.873  1.00 29.17          
ATOM   1922  CB  ILE   234      46.508   8.081  65.966  1.00 26.73          
ATOM   1923  CG1 ILE   234      46.783   9.530  65.567  1.00 28.11          
ATOM   1924  CG2 ILE   234      47.215   7.093  64.970  1.00 28.48          
ATOM   1925  CD  ILE   234      48.201  10.011  65.865  1.00 28.72          
ATOM   1926  N   GLU   235      44.686   5.643  67.111  1.00 28.54          
ATOM   1927  CA  GLU   235      44.384   4.220  67.177  0.50 29.19          
ATOM   1929  C   GLU   235      42.883   3.938  66.985  1.00 29.62          
ATOM   1930  O   GLU   235      42.500   2.945  66.343  1.00 28.04          
ATOM   1931  CB  GLU   235      44.873   3.645  68.509  0.50 29.29          
ATOM   1933  CG  GLU   235      46.276   3.029  68.460  0.50 30.56          
ATOM   1935  CD  GLU   235      47.359   3.906  69.051  0.50 31.08          
ATOM   1937  OE1 GLU   235      47.777   3.650  70.211  0.50 30.84          
ATOM   1939  OE2 GLU   235      47.796   4.847  68.359  0.50 28.87          
ATOM   1941  N   LEU   236      42.044   4.813  67.537  1.00 28.58          
ATOM   1942  CA  LEU   236      40.593   4.605  67.535  1.00 29.29          
ATOM   1943  C   LEU   236      39.868   5.059  66.250  1.00 29.42          
ATOM   1944  O   LEU   236      38.822   4.498  65.889  1.00 28.58          
ATOM   1945  CB  LEU   236      39.966   5.252  68.792  1.00 30.15          
ATOM   1946  CG  LEU   236      40.315   4.638  70.158  1.00 31.75          
ATOM   1947  CD1 LEU   236      40.036   5.637  71.300  1.00 36.79          
ATOM   1948  CD2 LEU   236      39.595   3.318  70.423  1.00 37.77          
ATOM   1949  N   ALA   237      40.418   6.062  65.554  1.00 29.65          
ATOM   1950  CA  ALA   237      39.818   6.548  64.293  1.00 29.89          
ATOM   1951  C   ALA   237      39.876   5.488  63.196  1.00 29.89          
ATOM   1952  O   ALA   237      40.800   4.661  63.183  1.00 30.68          
ATOM   1953  CB  ALA   237      40.540   7.804  63.821  1.00 29.61          
ATOM   1954  N   GLY   238      38.918   5.519  62.265  1.00 28.95          
ATOM   1955  CA  GLY   238      38.940   4.646  61.085  1.00 29.07          
ATOM   1956  C   GLY   238      40.256   4.754  60.333  1.00 28.70          
ATOM   1957  O   GLY   238      40.816   3.742  59.864  1.00 28.91          
ATOM   1958  N   LEU   239      40.755   5.980  60.205  1.00 27.16          
ATOM   1959  CA  LEU   239      42.070   6.225  59.612  1.00 27.11          
ATOM   1960  C   LEU   239      42.861   7.191  60.525  1.00 26.00          
ATOM   1961  O   LEU   239      42.470   8.349  60.699  1.00 25.76          
ATOM   1962  CB  LEU   239      41.906   6.807  58.212  1.00 26.94          
ATOM   1963  CG  LEU   239      43.143   7.089  57.372  1.00 30.13          
ATOM   1964  CD1 LEU   239      44.072   5.828  57.356  1.00 31.29          
ATOM   1965  CD2 LEU   239      42.612   7.377  55.973  1.00 34.74          
ATOM   1966  N   GLY   240      43.945   6.698  61.120  1.00 24.72          
ATOM   1967  CA  GLY   240      44.729   7.483  62.057  1.00 24.42          
ATOM   1968  C   GLY   240      46.042   7.840  61.374  1.00 24.09          
ATOM   1969  O   GLY   240      46.785   6.949  60.937  1.00 23.99          
ATOM   1970  N   VAL   241      46.332   9.142  61.299  1.00 24.04          
ATOM   1971  CA  VAL   241      47.449   9.639  60.515  1.00 24.33          
ATOM   1972  C   VAL   241      48.455  10.346  61.447  1.00 23.63          
ATOM   1973  O   VAL   241      48.043  11.158  62.283  1.00 23.79          
ATOM   1974  CB  VAL   241      46.928  10.651  59.474  1.00 24.63          
ATOM   1975  CG1 VAL   241      48.129  11.281  58.676  1.00 25.61          
ATOM   1976  CG2 VAL   241      45.830   9.988  58.557  1.00 25.98          
ATOM   1977  N   ALA   242      49.743  10.018  61.317  1.00 22.72          
ATOM   1978  CA  ALA   242      50.804  10.750  62.022  1.00 23.21          
ATOM   1979  C   ALA   242      51.487  11.737  61.068  1.00 22.60          
ATOM   1980  O   ALA   242      51.840  11.384  59.944  1.00 22.15          
ATOM   1981  CB  ALA   242      51.846   9.767  62.625  1.00 23.54          
ATOM   1982  N   MET   243      51.630  12.988  61.524  1.00 22.05          
ATOM   1983  CA  MET   243      52.361  14.012  60.813  1.00 22.04          
ATOM   1984  C   MET   243      53.819  13.591  60.787  1.00 22.56          
ATOM   1985  O   MET   243      54.292  12.919  61.700  1.00 22.91          
ATOM   1986  CB  MET   243      52.199  15.376  61.527  1.00 20.21          
ATOM   1987  CG  MET   243      50.726  15.848  61.559  1.00 22.79          
ATOM   1988  SD  MET   243      50.166  16.341  59.759  0.70 26.56          
ATOM   1989  CE  MET   243      51.564  17.566  59.227  1.00 24.96          
ATOM   1990  N   GLY   244      54.527  14.004  59.743  1.00 22.35          
ATOM   1991  CA  GLY   244      55.936  13.689  59.578  1.00 23.44          
ATOM   1992  C   GLY   244      56.833  14.174  60.708  1.00 24.47          
ATOM   1993  O   GLY   244      57.893  13.588  60.958  1.00 24.84          
ATOM   1994  N   ASN   245      56.422  15.250  61.373  1.00 24.06          
ATOM   1995  CA  ASN   245      57.198  15.842  62.460  1.00 22.95          
ATOM   1996  C   ASN   245      56.949  15.141  63.812  1.00 23.19          
ATOM   1997  O   ASN   245      57.580  15.509  64.827  1.00 23.42          
ATOM   1998  CB  ASN   245      56.876  17.341  62.571  1.00 21.83          
ATOM   1999  CG  ASN   245      55.377  17.622  62.450  1.00 22.80          
ATOM   2000  OD1 ASN   245      54.792  17.493  61.360  1.00 21.47          
ATOM   2001  ND2 ASN   245      54.739  17.947  63.576  1.00 21.39          
ATOM   2002  N   ALA   246      56.072  14.130  63.836  1.00 22.82          
ATOM   2003  CA  ALA   246      55.839  13.332  65.050  1.00 22.79          
ATOM   2004  C   ALA   246      57.073  12.480  65.367  1.00 23.93          
ATOM   2005  O   ALA   246      57.844  12.153  64.467  1.00 23.59          
ATOM   2006  CB  ALA   246      54.623  12.428  64.894  1.00 22.71          
ATOM   2007  N   VAL   247      57.269  12.103  66.638  1.00 24.77          
ATOM   2008  CA  VAL   247      58.391  11.192  66.956  1.00 25.24          
ATOM   2009  C   VAL   247      58.183   9.791  66.325  1.00 26.43          
ATOM   2010  O   VAL   247      57.052   9.408  66.064  1.00 26.31          
ATOM   2011  CB  VAL   247      58.661  11.093  68.485  1.00 25.73          
ATOM   2012  CG1 VAL   247      59.047  12.472  69.049  1.00 26.91          
ATOM   2013  CG2 VAL   247      57.456  10.490  69.236  1.00 25.18          
ATOM   2014  N   PRO   248      59.274   9.053  66.041  1.00 26.84          
ATOM   2015  CA  PRO   248      59.184   7.721  65.401  1.00 28.05          
ATOM   2016  C   PRO   248      58.164   6.752  66.010  1.00 28.51          
ATOM   2017  O   PRO   248      57.472   6.056  65.262  1.00 28.43          
ATOM   2018  CB  PRO   248      60.611   7.178  65.543  1.00 28.55          
ATOM   2019  CG  PRO   248      61.437   8.402  65.432  1.00 28.21          
ATOM   2020  CD  PRO   248      60.688   9.441  66.243  1.00 27.65          
ATOM   2021  N   GLU   249      58.045   6.714  67.336  1.00 29.47          
ATOM   2022  CA  GLU   249      57.081   5.809  67.977  1.00 31.60          
ATOM   2023  C   GLU   249      55.653   6.076  67.531  1.00 30.30          
ATOM   2024  O   GLU   249      54.891   5.145  67.255  1.00 30.56          
ATOM   2025  CB  GLU   249      57.137   5.920  69.496  1.00 32.47          
ATOM   2026  CG  GLU   249      56.068   5.031  70.201  1.00 36.08          
ATOM   2027  CD  GLU   249      56.011   5.273  71.694  1.00 36.27          
ATOM   2028  OE1 GLU   249      57.098   5.515  72.270  1.00 41.61          
ATOM   2029  OE2 GLU   249      54.892   5.224  72.281  1.00 40.09          
ATOM   2030  N   ILE   250      55.291   7.358  67.480  1.00 27.91          
ATOM   2031  CA  ILE   250      53.971   7.750  67.007  1.00 26.50          
ATOM   2032  C   ILE   250      53.788   7.397  65.539  1.00 26.00          
ATOM   2033  O   ILE   250      52.730   6.896  65.129  1.00 25.28          
ATOM   2034  CB  ILE   250      53.729   9.236  67.272  1.00 26.28          
ATOM   2035  CG1 ILE   250      53.754   9.446  68.802  1.00 27.05          
ATOM   2036  CG2 ILE   250      52.427   9.698  66.596  1.00 26.15          
ATOM   2037  CD  ILE   250      53.726  10.881  69.239  1.00 30.28          
ATOM   2038  N   LYS   251      54.833   7.635  64.750  1.00 25.02          
ATOM   2039  CA  LYS   251      54.780   7.291  63.324  1.00 25.90          
ATOM   2040  C   LYS   251      54.607   5.792  63.105  1.00 26.34          
ATOM   2041  O   LYS   251      53.857   5.373  62.218  1.00 27.33          
ATOM   2042  CB  LYS   251      56.008   7.853  62.597  1.00 25.13          
ATOM   2043  CG  LYS   251      55.946   9.402  62.603  1.00 27.20          
ATOM   2044  CD  LYS   251      56.880  10.070  61.611  1.00 27.44          
ATOM   2045  CE  LYS   251      58.301  10.034  62.110  1.00 30.65          
ATOM   2046  NZ  LYS   251      59.127  11.048  61.390  1.00 27.07          
ATOM   2047  N   ARG   252      55.258   4.982  63.931  1.00 26.48          
ATOM   2048  CA  ARG   252      55.081   3.521  63.830  1.00 26.17          
ATOM   2049  C   ARG   252      53.658   3.088  64.172  1.00 27.38          
ATOM   2050  O   ARG   252      53.122   2.138  63.558  1.00 27.56          
ATOM   2051  CB  ARG   252      56.067   2.788  64.726  1.00 25.93          
ATOM   2052  CG  ARG   252      57.483   2.791  64.223  1.00 24.21          
ATOM   2053  CD  ARG   252      58.314   1.746  64.989  1.00 27.39          
ATOM   2054  NE  ARG   252      58.402   2.104  66.409  1.00 28.96          
ATOM   2055  CZ  ARG   252      59.325   2.912  66.926  1.00 29.93          
ATOM   2056  NH1 ARG   252      60.255   3.464  66.150  1.00 30.96          
ATOM   2057  NH2 ARG   252      59.301   3.185  68.223  1.00 31.28          
ATOM   2058  N   LYS   253      53.029   3.806  65.104  1.00 26.16          
ATOM   2059  CA  LYS   253      51.714   3.395  65.603  1.00 26.68          
ATOM   2060  C   LYS   253      50.532   3.801  64.737  1.00 25.93          
ATOM   2061  O   LYS   253      49.469   3.203  64.830  1.00 25.23          
ATOM   2062  CB  LYS   253      51.530   3.854  67.034  1.00 26.72          
ATOM   2063  CG  LYS   253      52.386   3.029  67.945  1.00 30.39          
ATOM   2064  CD  LYS   253      52.209   3.410  69.383  1.00 31.63          
ATOM   2065  CE  LYS   253      52.644   2.234  70.273  1.00 33.52          
ATOM   2066  NZ  LYS   253      52.440   2.596  71.683  1.00 36.24          
ATOM   2067  N   ALA   254      50.729   4.814  63.907  1.00 24.33          
ATOM   2068  CA  ALA   254      49.709   5.294  62.990  1.00 24.70          
ATOM   2069  C   ALA   254      49.421   4.318  61.839  1.00 26.07          
ATOM   2070  O   ALA   254      50.261   3.451  61.495  1.00 25.87          
ATOM   2071  CB  ALA   254      50.128   6.638  62.423  1.00 24.51          
ATOM   2072  N   ASP   255      48.266   4.483  61.207  1.00 25.57          
ATOM   2073  CA  ASP   255      47.956   3.693  60.015  1.00 27.11          
ATOM   2074  C   ASP   255      48.709   4.236  58.813  1.00 27.57          
ATOM   2075  O   ASP   255      49.010   3.523  57.870  1.00 26.36          
ATOM   2076  CB  ASP   255      46.465   3.750  59.727  1.00 27.08          
ATOM   2077  CG  ASP   255      45.630   3.348  60.935  1.00 28.43          
ATOM   2078  OD1 ASP   255      46.098   2.472  61.708  1.00 30.86          
ATOM   2079  OD2 ASP   255      44.525   3.911  61.114  1.00 27.78          
ATOM   2080  N   TRP   256      49.014   5.524  58.873  1.00 28.09          
ATOM   2081  CA  TRP   256      49.508   6.246  57.732  1.00 28.91          
ATOM   2082  C   TRP   256      50.416   7.359  58.225  1.00 27.48          
ATOM   2083  O   TRP   256      50.028   8.072  59.143  1.00 26.12          
ATOM   2084  CB  TRP   256      48.280   6.865  57.103  1.00 31.66          
ATOM   2085  CG  TRP   256      48.473   7.553  55.835  1.00 35.83          
ATOM   2086  CD1 TRP   256      49.530   8.360  55.467  1.00 39.27          
ATOM   2087  CD2 TRP   256      47.555   7.570  54.750  1.00 37.87          
ATOM   2088  NE1 TRP   256      49.330   8.846  54.196  1.00 40.18          
ATOM   2089  CE2 TRP   256      48.114   8.392  53.741  1.00 40.29          
ATOM   2090  CE3 TRP   256      46.304   6.976  54.529  1.00 39.44          
ATOM   2091  CZ2 TRP   256      47.465   8.627  52.523  1.00 39.24          
ATOM   2092  CZ3 TRP   256      45.653   7.213  53.317  1.00 38.57          
ATOM   2093  CH2 TRP   256      46.237   8.034  52.330  1.00 38.71          
ATOM   2094  N   VAL   257      51.592   7.522  57.616  1.00 25.70          
ATOM   2095  CA  VAL   257      52.486   8.651  57.971  1.00 26.11          
ATOM   2096  C   VAL   257      52.534   9.629  56.808  1.00 26.15          
ATOM   2097  O   VAL   257      52.800   9.222  55.658  1.00 25.71          
ATOM   2098  CB  VAL   257      53.926   8.165  58.276  1.00 25.53          
ATOM   2099  CG1 VAL   257      54.822   9.328  58.596  1.00 25.30          
ATOM   2100  CG2 VAL   257      53.931   7.181  59.453  1.00 27.38          
ATOM   2101  N   THR   258      52.256  10.903  57.078  1.00 24.62          
ATOM   2102  CA  THR   258      52.303  11.903  56.008  1.00 24.30          
ATOM   2103  C   THR   258      53.565  12.763  56.156  1.00 23.94          
ATOM   2104  O   THR   258      54.437  12.497  57.010  1.00 23.29          
ATOM   2105  CB  THR   258      50.963  12.710  55.940  1.00 24.99          
ATOM   2106  OG1 THR   258      50.926  13.539  54.768  1.00 24.74          
ATOM   2107  CG2 THR   258      50.718  13.567  57.201  1.00 23.24          
ATOM   2108  N   ARG   259      53.689  13.775  55.312  1.00 22.47          
ATOM   2109  CA  ARG   259      54.808  14.695  55.401  1.00 22.99          
ATOM   2110  C   ARG   259      54.673  15.618  56.633  1.00 22.86          
ATOM   2111  O   ARG   259      53.647  15.593  57.317  1.00 23.01          
ATOM   2112  CB  ARG   259      54.849  15.529  54.139  1.00 21.55          
ATOM   2113  CG  ARG   259      55.174  14.668  52.937  1.00 24.21          
ATOM   2114  CD  ARG   259      55.297  15.488  51.699  1.00 24.26          
ATOM   2115  NE  ARG   259      55.839  14.667  50.598  1.00 24.24          
ATOM   2116  CZ  ARG   259      56.083  15.144  49.382  1.00 27.53          
ATOM   2117  NH1 ARG   259      55.805  16.426  49.121  1.00 22.20          
ATOM   2118  NH2 ARG   259      56.564  14.331  48.426  1.00 25.32          
ATOM   2119  N   SER   260      55.706  16.405  56.917  1.00 23.28          
ATOM   2120  CA  SER   260      55.705  17.229  58.138  1.00 23.33          
ATOM   2121  C   SER   260      54.753  18.428  57.995  1.00 22.50          
ATOM   2122  O   SER   260      54.306  18.746  56.884  1.00 22.18          
ATOM   2123  CB  SER   260      57.131  17.734  58.409  1.00 25.09          
ATOM   2124  OG  SER   260      57.382  18.926  57.677  1.00 27.19          
ATOM   2125  N   ASN   261      54.516  19.142  59.105  1.00 22.48          
ATOM   2126  CA  ASN   261      53.738  20.376  59.074  1.00 22.26          
ATOM   2127  C   ASN   261      54.443  21.519  58.344  1.00 22.43          
ATOM   2128  O   ASN   261      53.813  22.519  58.003  1.00 22.77          
ATOM   2129  CB  ASN   261      53.318  20.802  60.502  1.00 21.69          
ATOM   2130  CG  ASN   261      54.498  21.144  61.391  1.00 22.89          
ATOM   2131  OD1 ASN   261      55.555  20.481  61.364  1.00 22.86          
ATOM   2132  ND2 ASN   261      54.307  22.171  62.227  1.00 22.44          
ATOM   2133  N   ASP   262      55.749  21.385  58.121  1.00 22.12          
ATOM   2134  CA  ASP   262      56.460  22.377  57.308  1.00 22.60          
ATOM   2135  C   ASP   262      56.566  21.958  55.830  1.00 21.47          
ATOM   2136  O   ASP   262      57.220  22.631  55.028  1.00 21.76          
ATOM   2137  CB  ASP   262      57.827  22.702  57.914  1.00 23.23          
ATOM   2138  CG  ASP   262      57.701  23.550  59.204  1.00 28.19          
ATOM   2139  OD1 ASP   262      56.796  24.403  59.290  1.00 27.66          
ATOM   2140  OD2 ASP   262      58.485  23.332  60.143  1.00 33.51          
ATOM   2141  N   GLU   263      55.935  20.842  55.488  1.00 20.80          
ATOM   2142  CA  GLU   263      55.899  20.352  54.103  1.00 20.78          
ATOM   2143  C   GLU   263      54.452  19.989  53.758  1.00 21.17          
ATOM   2144  O   GLU   263      54.193  19.045  53.025  1.00 22.36          
ATOM   2145  CB  GLU   263      56.830  19.147  53.922  1.00 21.19          
ATOM   2146  CG  GLU   263      57.305  18.969  52.469  1.00 23.89          
ATOM   2147  CD  GLU   263      58.305  20.051  52.082  1.00 26.49          
ATOM   2148  OE1 GLU   263      57.984  20.868  51.161  1.00 26.66          
ATOM   2149  OE2 GLU   263      59.402  20.108  52.732  1.00 27.13          
ATOM   2150  N   GLN   264      53.509  20.729  54.332  1.00 20.75          
ATOM   2151  CA  GLN   264      52.091  20.622  53.972  1.00 21.64          
ATOM   2152  C   GLN   264      51.573  19.180  54.046  1.00 21.50          
ATOM   2153  O   GLN   264      50.905  18.699  53.141  1.00 21.41          
ATOM   2154  CB  GLN   264      51.838  21.292  52.588  1.00 20.91          
ATOM   2155  CG  GLN   264      51.810  22.840  52.717  1.00 23.81          
ATOM   2156  CD  GLN   264      53.155  23.394  53.217  1.00 25.44          
ATOM   2157  OE1 GLN   264      53.308  23.782  54.413  1.00 22.26          
ATOM   2158  NE2 GLN   264      54.162  23.374  52.313  1.00 22.74          
ATOM   2159  N   GLY   265      51.851  18.519  55.166  1.00 20.55          
ATOM   2160  CA  GLY   265      51.471  17.127  55.333  1.00 21.09          
ATOM   2161  C   GLY   265      49.973  16.875  55.378  1.00 22.40          
ATOM   2162  O   GLY   265      49.515  15.828  54.922  1.00 21.89          
ATOM   2163  N   VAL   266      49.211  17.835  55.908  1.00 21.97          
ATOM   2164  CA  VAL   266      47.721  17.726  55.884  1.00 22.34          
ATOM   2165  C   VAL   266      47.177  17.692  54.434  1.00 22.44          
ATOM   2166  O   VAL   266      46.434  16.773  54.065  1.00 22.33          
ATOM   2167  CB  VAL   266      47.061  18.869  56.706  1.00 21.95          
ATOM   2168  CG1 VAL   266      45.535  18.928  56.427  1.00 23.91          
ATOM   2169  CG2 VAL   266      47.319  18.618  58.180  1.00 23.66          
ATOM   2170  N   ALA   267      47.548  18.697  53.632  1.00 21.52          
ATOM   2171  CA  ALA   267      47.176  18.747  52.217  1.00 22.29          
ATOM   2172  C   ALA   267      47.645  17.503  51.447  1.00 22.60          
ATOM   2173  O   ALA   267      46.916  16.959  50.594  1.00 22.47          
ATOM   2174  CB  ALA   267      47.726  20.014  51.562  1.00 22.47          
ATOM   2175  N   TYR   268      48.857  17.052  51.748  1.00 21.54          
ATOM   2176  CA  TYR   268      49.449  15.932  51.026  1.00 23.44          
ATOM   2177  C   TYR   268      48.621  14.669  51.301  1.00 24.29          
ATOM   2178  O   TYR   268      48.274  13.905  50.367  1.00 24.69          
ATOM   2179  CB  TYR   268      50.894  15.731  51.491  1.00 23.22          
ATOM   2180  CG  TYR   268      51.715  14.768  50.652  1.00 23.53          
ATOM   2181  CD1 TYR   268      52.211  15.146  49.413  1.00 23.71          
ATOM   2182  CD2 TYR   268      52.037  13.505  51.133  1.00 25.80          
ATOM   2183  CE1 TYR   268      53.010  14.275  48.643  1.00 24.92          
ATOM   2184  CE2 TYR   268      52.818  12.595  50.355  1.00 22.95          
ATOM   2185  CZ  TYR   268      53.302  13.009  49.117  1.00 23.37          
ATOM   2186  OH  TYR   268      54.091  12.152  48.347  1.00 27.35          
ATOM   2187  N   MET   269      48.306  14.468  52.581  1.00 25.17          
ATOM   2188  CA  MET   269      47.506  13.307  52.969  0.50 25.64          
ATOM   2190  C   MET   269      46.100  13.379  52.366  1.00 25.96          
ATOM   2191  O   MET   269      45.602  12.371  51.838  1.00 26.32          
ATOM   2192  CB  MET   269      47.481  13.137  54.495  0.50 26.22          
ATOM   2194  CG  MET   269      46.753  11.904  54.997  0.50 26.59          
ATOM   2196  SD  MET   269      44.912  12.282  55.331  0.40 30.28          
ATOM   2198  CE  MET   269      44.208  10.481  55.334  0.50 26.85          
ATOM   2200  N   MET   270      45.450  14.538  52.412  1.00 25.78          
ATOM   2201  CA  MET   270      44.070  14.568  51.896  1.00 25.69          
ATOM   2202  C   MET   270      43.972  14.413  50.375  1.00 24.64          
ATOM   2203  O   MET   270      43.013  13.825  49.877  1.00 23.32          
ATOM   2204  CB  MET   270      43.268  15.755  52.440  1.00 26.63          
ATOM   2205  CG  MET   270      42.825  15.545  53.961  1.00 27.90          
ATOM   2206  SD  MET   270      41.981  13.811  54.467  0.50 33.51          
ATOM   2207  CE  MET   270      40.197  14.101  53.788  1.00 31.19          
ATOM   2208  N   LYS   271      44.983  14.896  49.653  1.00 23.82          
ATOM   2209  CA  LYS   271      45.079  14.665  48.209  1.00 24.03          
ATOM   2210  C   LYS   271      45.081  13.154  47.917  1.00 24.38          
ATOM   2211  O   LYS   271      44.362  12.670  47.021  1.00 22.62          
ATOM   2212  CB  LYS   271      46.335  15.337  47.654  1.00 24.47          
ATOM   2213  CG  LYS   271      46.520  15.228  46.144  1.00 28.95          
ATOM   2214  CD  LYS   271      45.551  16.114  45.384  1.00 33.45          
ATOM   2215  CE  LYS   271      45.691  15.935  43.886  1.00 37.61          
ATOM   2216  NZ  LYS   271      44.779  16.886  43.204  1.00 39.47          
ATOM   2217  N   GLU   272      45.877  12.411  48.677  1.00 23.92          
ATOM   2218  CA  GLU   272      45.906  10.938  48.549  1.00 26.36          
ATOM   2219  C   GLU   272      44.581  10.270  48.930  1.00 26.60          
ATOM   2220  O   GLU   272      44.140   9.337  48.218  1.00 27.95          
ATOM   2221  CB  GLU   272      47.062  10.326  49.346  1.00 26.62          
ATOM   2222  CG  GLU   272      47.214   8.811  49.151  1.00 29.70          
ATOM   2223  CD  GLU   272      47.293   8.396  47.695  1.00 32.19          
ATOM   2224  OE1 GLU   272      47.910   9.137  46.883  1.00 34.53          
ATOM   2225  OE2 GLU   272      46.727   7.327  47.342  1.00 31.05          
ATOM   2226  N   TYR   273      43.962  10.730  50.018  1.00 27.42          
ATOM   2227  CA  TYR   273      42.645  10.244  50.417  1.00 29.11          
ATOM   2228  C   TYR   273      41.693  10.315  49.235  1.00 28.66          
ATOM   2229  O   TYR   273      40.979   9.347  48.960  1.00 28.96          
ATOM   2230  CB  TYR   273      42.071  10.981  51.636  1.00 30.66          
ATOM   2231  CG  TYR   273      40.606  10.658  51.859  1.00 33.11          
ATOM   2232  CD1 TYR   273      39.612  11.556  51.477  1.00 35.41          
ATOM   2233  CD2 TYR   273      40.211   9.410  52.383  1.00 37.23          
ATOM   2234  CE1 TYR   273      38.252  11.254  51.638  1.00 36.08          
ATOM   2235  CE2 TYR   273      38.848   9.091  52.547  1.00 35.87          
ATOM   2236  CZ  TYR   273      37.884  10.029  52.179  1.00 36.29          
ATOM   2237  OH  TYR   273      36.545   9.741  52.329  1.00 36.82          
ATOM   2238  N   PHE   274      41.701  11.436  48.511  1.00 27.89          
ATOM   2239  CA  PHE   274      40.801  11.576  47.361  1.00 27.82          
ATOM   2240  C   PHE   274      41.198  10.776  46.122  1.00 28.80          
ATOM   2241  O   PHE   274      40.331  10.270  45.398  1.00 27.67          
ATOM   2242  CB  PHE   274      40.536  13.035  47.045  1.00 28.07          
ATOM   2243  CG  PHE   274      39.715  13.705  48.098  1.00 29.10          
ATOM   2244  CD1 PHE   274      38.391  13.303  48.324  1.00 31.46          
ATOM   2245  CD2 PHE   274      40.262  14.696  48.889  1.00 29.57          
ATOM   2246  CE1 PHE   274      37.625  13.911  49.319  1.00 32.39          
ATOM   2247  CE2 PHE   274      39.508  15.316  49.883  1.00 30.78          
ATOM   2248  CZ  PHE   274      38.198  14.925  50.098  1.00 29.96          
ATOM   2249  N   ARG   275      42.492  10.670  45.869  1.00 29.47          
ATOM   2250  CA  ARG   275      42.956   9.764  44.817  1.00 32.37          
ATOM   2251  C   ARG   275      42.481   8.333  45.105  1.00 33.10          
ATOM   2252  O   ARG   275      42.013   7.642  44.205  1.00 33.20          
ATOM   2253  CB  ARG   275      44.478   9.860  44.643  1.00 31.99          
ATOM   2254  CG  ARG   275      44.897  11.083  43.793  1.00 34.08          
ATOM   2255  CD  ARG   275      46.361  11.045  43.328  1.00 34.50          
ATOM   2256  NE  ARG   275      47.193  11.008  44.498  1.00 36.44          
ATOM   2257  CZ  ARG   275      47.923  12.011  44.982  1.00 37.79          
ATOM   2258  NH1 ARG   275      48.059  13.173  44.338  1.00 39.78          
ATOM   2259  NH2 ARG   275      48.571  11.808  46.104  1.00 27.71          
ATOM   2260  N   MET   276      42.568   7.917  46.363  1.00 35.02          
ATOM   2261  CA  MET   276      42.074   6.605  46.816  1.00 38.13          
ATOM   2262  C   MET   276      40.580   6.439  46.522  1.00 38.01          
ATOM   2263  O   MET   276      40.161   5.423  45.963  1.00 38.25          
ATOM   2264  CB  MET   276      42.323   6.465  48.319  1.00 38.20          
ATOM   2265  CG  MET   276      43.023   5.196  48.773  1.00 40.53          
ATOM   2266  SD  MET   276      44.223   5.555  50.270  0.50 41.91          
ATOM   2267  CE  MET   276      43.199   6.978  51.120  1.00 42.05          
ATOM   2268  N   GLN   277      39.793   7.443  46.899  1.00 38.41          
ATOM   2269  CA  GLN   277      38.355   7.535  46.572  1.00 39.20          
ATOM   2270  C   GLN   277      38.045   7.405  45.086  1.00 39.22          
ATOM   2271  O   GLN   277      37.153   6.650  44.691  1.00 38.94          
ATOM   2272  CB  GLN   277      37.792   8.870  47.074  1.00 39.68          
ATOM   2273  CG  GLN   277      37.736   8.976  48.580  1.00 42.29          
ATOM   2274  CD  GLN   277      36.893   7.873  49.186  1.00 46.38          
ATOM   2275  OE1 GLN   277      37.383   7.072  49.988  1.00 49.96          
ATOM   2276  NE2 GLN   277      35.626   7.810  48.790  1.00 46.50          
ATOM   2277  N   GLN   278      38.777   8.151  44.267  1.00 39.48          
ATOM   2278  CA  GLN   278      38.612   8.118  42.821  1.00 40.80          
ATOM   2279  C   GLN   278      38.903   6.717  42.258  1.00 40.52          
ATOM   2280  O   GLN   278      38.180   6.228  41.383  1.00 40.34          
ATOM   2281  CB  GLN   278      39.540   9.151  42.190  1.00 40.71          
ATOM   2282  CG  GLN   278      39.202   9.545  40.770  1.00 42.69          
ATOM   2283  CD  GLN   278      40.159  10.602  40.240  1.00 43.19          
ATOM   2284  OE1 GLN   278      40.382  11.636  40.889  1.00 46.36          
ATOM   2285  NE2 GLN   278      40.743  10.342  39.064  1.00 44.93          
ATOM   2286  N   ARG   279      39.954   6.074  42.772  1.00 40.61          
ATOM   2287  CA  ARG   279      40.327   4.713  42.359  1.00 40.81          
ATOM   2288  C   ARG   279      39.246   3.698  42.730  1.00 40.76          
ATOM   2289  O   ARG   279      38.869   2.854  41.910  1.00 40.29          
ATOM   2290  CB  ARG   279      41.671   4.317  42.969  1.00 41.24          
ATOM   2291  CG  ARG   279      42.856   5.053  42.346  1.00 41.88          
ATOM   2292  CD  ARG   279      44.163   4.348  42.653  1.00 42.99          
ATOM   2293  NE  ARG   279      44.582   4.612  44.016  1.00 43.79          
ATOM   2294  CZ  ARG   279      45.338   5.647  44.376  1.00 43.13          
ATOM   2295  NH1 ARG   279      45.777   6.518  43.463  1.00 42.82          
ATOM   2296  NH2 ARG   279      45.652   5.802  45.650  1.00 41.15          
ATOM   2297  N   LYS   280      38.754   3.792  43.965  1.00 40.64          
ATOM   2298  CA  LYS   280      37.587   3.026  44.395  1.00 40.87          
ATOM   2299  C   LYS   280      36.318   3.585  43.743  1.00 40.93          
ATOM   2300  O   LYS   280      35.798   3.009  42.779  1.00 41.19          
ATOM   2301  CB  LYS   280      37.465   3.046  45.922  1.00 40.47          
END
